/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.json;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2gis.api.DriverFunction;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.DriverManager;
import org.h2gis.functions.io.json.JsonWriteDriver;

public class JsonDriverFunction
implements DriverFunction {
    public DriverFunction.IMPORT_DRIVER_TYPE getImportDriverType() {
        return DriverFunction.IMPORT_DRIVER_TYPE.COPY;
    }

    public String[] getImportFormats() {
        return new String[0];
    }

    public String[] getExportFormats() {
        return new String[]{"json", "json.gz"};
    }

    public String getFormatDescription(String format) {
        if (format.equalsIgnoreCase("json")) {
            return "JSON";
        }
        return "";
    }

    public boolean isSpatialFormat(String extension) {
        return false;
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, null, false, progress);
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, boolean deleteFiles, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, null, deleteFiles, progress);
    }

    public String[] exportTable(Connection connection, String tableReference, File file, String options, boolean deleteFiles, ProgressVisitor progress) throws SQLException, IOException {
        progress = DriverManager.check(connection, tableReference, file, progress);
        JsonWriteDriver jsonDriver = new JsonWriteDriver(connection);
        try {
            jsonDriver.write(progress, tableReference, file, deleteFiles, options);
            return new String[]{file.getAbsolutePath()};
        }
        catch (IOException | SQLException ex) {
            throw new SQLException(ex);
        }
    }

    public String[] exportTable(Connection connection, String tableReference, File file, String encoding, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, file, encoding, false, progress);
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, String options, ProgressVisitor progress) throws SQLException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, boolean deleteTables, ProgressVisitor progress) throws SQLException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, String options, boolean deleteTables, ProgressVisitor progress) throws SQLException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

