/*
 * Decompiled with CFR 0.152.
 */
package org.javanetworkanalyzer.graphcreators;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Scanner;
import org.javanetworkanalyzer.data.VId;
import org.javanetworkanalyzer.model.DirectedPseudoG;
import org.javanetworkanalyzer.model.EdgeID;
import org.javanetworkanalyzer.model.KeyedGraph;
import org.javanetworkanalyzer.model.PseudoG;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphCreator<V extends VId, E extends EdgeID> {
    protected static final String START_NODE = "start_node";
    protected static final String END_NODE = "end_node";
    protected final int orientation;
    protected final Class<? extends V> vertexClass;
    protected final Class<? extends E> edgeClass;
    private final String csvFile;
    protected static int startNodeIndex = -1;
    protected static int endNodeIndex = -1;
    public static final int DIRECTED = 1;
    public static final int REVERSED = 2;
    public static final int UNDIRECTED = 3;
    protected static final String SEPARATOR = ";";
    protected static final String DOUBLE_QUOTES = "\"";
    protected static final String EMPTY_STRING = "";
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphCreator.class);

    public GraphCreator(String csvFile, int orientation, Class<? extends V> vertexClass, Class<? extends E> edgeClass) {
        this.csvFile = csvFile;
        this.orientation = orientation;
        this.vertexClass = vertexClass;
        this.edgeClass = edgeClass;
    }

    public KeyedGraph<V, E> loadGraph() throws FileNotFoundException, NoSuchMethodException {
        long start = System.currentTimeMillis();
        Scanner scanner = this.getScannerOnCSVFile(this.csvFile);
        this.initializeIndices(scanner);
        KeyedGraph<V, E> graph = this.initializeGraph();
        this.loadEdges(scanner, graph);
        long stop = System.currentTimeMillis();
        LOGGER.info("({} ms) Created graph from CSV.", (Object)(stop - start));
        scanner.close();
        return graph;
    }

    private Scanner getScannerOnCSVFile(String path) throws FileNotFoundException {
        File edgesFile = new File(path);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(edgesFile));
        Scanner scanner = new Scanner(bufferedReader);
        return scanner;
    }

    protected void initializeIndices(Scanner scanner) {
        String[] row = scanner.nextLine().split(SEPARATOR);
        for (int i = 0; i < row.length; ++i) {
            if (row[i].replace(DOUBLE_QUOTES, EMPTY_STRING).equals(START_NODE)) {
                startNodeIndex = i;
                continue;
            }
            if (!row[i].replace(DOUBLE_QUOTES, EMPTY_STRING).equals(END_NODE)) continue;
            endNodeIndex = i;
        }
    }

    protected String deleteDoubleQuotes(String s) {
        return s.replace(DOUBLE_QUOTES, EMPTY_STRING);
    }

    protected KeyedGraph<V, E> initializeGraph() throws NoSuchMethodException {
        KeyedGraph<? extends V, ? extends E> graph = this.orientation != 3 ? new DirectedPseudoG<V, E>(this.vertexClass, this.edgeClass) : new PseudoG<V, E>(this.vertexClass, this.edgeClass);
        return graph;
    }

    private KeyedGraph<V, E> loadEdges(Scanner scanner, KeyedGraph<V, E> graph) {
        boolean reverse;
        boolean bl = reverse = this.orientation == 2;
        while (scanner.hasNextLine()) {
            String[] row = scanner.nextLine().split(SEPARATOR);
            this.loadEdge(row, graph, reverse);
        }
        return graph;
    }

    protected E loadEdge(String[] row, KeyedGraph<V, E> graph, boolean reverse) {
        int startNode = Integer.parseInt(this.deleteDoubleQuotes(row[startNodeIndex]));
        int endNode = Integer.parseInt(this.deleteDoubleQuotes(row[endNodeIndex]));
        E edge = reverse ? graph.addEdge(endNode, startNode) : graph.addEdge(startNode, endNode);
        return edge;
    }
}

