/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public final class ValueReal
extends Value {
    static final int PRECISION = 7;
    static final int DISPLAY_SIZE = 15;
    public static final int ZERO_BITS = 0;
    public static final ValueReal ZERO = new ValueReal(0.0f);
    public static final ValueReal ONE = new ValueReal(1.0f);
    private static final ValueReal NAN = new ValueReal(Float.NaN);
    private final float value;

    private ValueReal(float f) {
        this.value = f;
    }

    @Override
    public Value add(Value value) {
        ValueReal valueReal = (ValueReal)value;
        return ValueReal.get(this.value + valueReal.value);
    }

    @Override
    public Value subtract(Value value) {
        ValueReal valueReal = (ValueReal)value;
        return ValueReal.get(this.value - valueReal.value);
    }

    @Override
    public Value negate() {
        return ValueReal.get(-this.value);
    }

    @Override
    public Value multiply(Value value) {
        ValueReal valueReal = (ValueReal)value;
        return ValueReal.get(this.value * valueReal.value);
    }

    @Override
    public Value divide(Value value, long l) {
        ValueReal valueReal = (ValueReal)value;
        if ((double)valueReal.value == 0.0) {
            throw DbException.get(22012, this.getTraceSQL());
        }
        return ValueReal.get(this.value / valueReal.value);
    }

    @Override
    public Value modulus(Value value) {
        ValueReal valueReal = (ValueReal)value;
        if (valueReal.value == 0.0f) {
            throw DbException.get(22012, this.getTraceSQL());
        }
        return ValueReal.get(this.value % valueReal.value);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, int n) {
        if ((n & 4) == 0) {
            return this.getSQL(stringBuilder.append("CAST(")).append(" AS REAL)");
        }
        return this.getSQL(stringBuilder);
    }

    private StringBuilder getSQL(StringBuilder stringBuilder) {
        if (this.value == Float.POSITIVE_INFINITY) {
            stringBuilder.append("POWER(0, -1)");
        } else if (this.value == Float.NEGATIVE_INFINITY) {
            stringBuilder.append("(-POWER(0, -1))");
        } else if (Float.isNaN(this.value)) {
            stringBuilder.append("SQRT(-1)");
        } else {
            stringBuilder.append(this.value);
        }
        return stringBuilder;
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_REAL;
    }

    @Override
    public int getValueType() {
        return 8;
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode, CastDataProvider castDataProvider) {
        return Float.compare(this.value, ((ValueReal)value).value);
    }

    @Override
    public int getSignum() {
        return this.value == 0.0f ? 0 : (this.value < 0.0f ? -1 : 1);
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (Math.abs(this.value) <= Float.MAX_VALUE) {
            return new BigDecimal(Float.toString(this.value));
        }
        throw DbException.get(22018, Float.toString(this.value));
    }

    @Override
    public String getString() {
        return Float.toString(this.value);
    }

    @Override
    public int hashCode() {
        return Float.floatToRawIntBits(this.value);
    }

    @Override
    public Object getObject() {
        return Float.valueOf(this.value);
    }

    public static ValueReal get(float f) {
        if (f == 1.0f) {
            return ONE;
        }
        if (f == 0.0f) {
            return ZERO;
        }
        if (Float.isNaN(f)) {
            return NAN;
        }
        return (ValueReal)Value.cache(new ValueReal(f));
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ValueReal)) {
            return false;
        }
        return this.compareTypeSafe((ValueReal)object, null, null) == 0;
    }
}

