/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import javax.naming.Context;
import javax.sql.DataSource;
import org.h2.api.JavaObjectSerializer;
import org.h2.engine.CastDataProvider;
import org.h2.engine.SysProperties;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.message.DbException;
import org.h2.util.Bits;
import org.h2.util.JSR310Utils;
import org.h2.util.LegacyDateTimeUtils;
import org.h2.util.NetworkConnectionInfo;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.ValueUuid;

public class JdbcUtils {
    public static JavaObjectSerializer serializer;
    private static final String[] DRIVERS;
    private static final byte[] UUID_PREFIX;
    private static boolean allowAllClasses;
    private static HashSet<String> allowedClassNames;
    private static final ArrayList<Utils.ClassFactory> userClassFactories;
    private static String[] allowedClassNamePrefixes;

    private JdbcUtils() {
    }

    public static void addClassFactory(Utils.ClassFactory classFactory) {
        userClassFactories.add(classFactory);
    }

    public static void removeClassFactory(Utils.ClassFactory classFactory) {
        userClassFactories.remove(classFactory);
    }

    public static <Z> Class<Z> loadUserClass(String string) {
        if (allowedClassNames == null) {
            String string2 = SysProperties.ALLOWED_CLASSES;
            ArrayList<String> object = new ArrayList<String>();
            int n = 0;
            HashSet<String> hashSet = new HashSet<String>();
            for (String string3 : StringUtils.arraySplit(string2, ',', true)) {
                if (string3.equals("*")) {
                    n = 1;
                    continue;
                }
                if (string3.endsWith("*")) {
                    object.add(string3.substring(0, string3.length() - 1));
                    continue;
                }
                hashSet.add(string3);
            }
            allowedClassNamePrefixes = object.toArray(new String[0]);
            allowAllClasses = n;
            allowedClassNames = hashSet;
        }
        if (!allowAllClasses && !allowedClassNames.contains(string)) {
            boolean bl = false;
            for (String string4 : allowedClassNamePrefixes) {
                if (!string.startsWith(string4)) continue;
                bl = true;
            }
            if (!bl) {
                throw DbException.get(90134, string);
            }
        }
        for (Utils.ClassFactory classFactory : userClassFactories) {
            if (!classFactory.match(string)) continue;
            try {
                Class<?> clazz = classFactory.loadClass(string);
                if (clazz == null) continue;
                return clazz;
            }
            catch (Exception exception) {
                throw DbException.get(90086, exception, string);
            }
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception exception) {
                throw DbException.get(90086, classNotFoundException, string);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw DbException.get(90086, noClassDefFoundError, string);
        }
        catch (Error error) {
            throw DbException.get(50000, error, string);
        }
    }

    public static void closeSilently(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static Connection getConnection(String string, String string2, String string3, String string4) throws SQLException {
        Properties properties = new Properties();
        if (string3 != null) {
            properties.setProperty("user", string3);
        }
        if (string4 != null) {
            properties.setProperty("password", string4);
        }
        return JdbcUtils.getConnection(string, string2, properties, null);
    }

    public static Connection getConnection(String string, String string2, Properties properties, NetworkConnectionInfo networkConnectionInfo) throws SQLException {
        Connection connection = JdbcUtils.getConnection(string, string2, properties);
        if (networkConnectionInfo != null && connection instanceof JdbcConnection) {
            ((JdbcConnection)connection).getSession().setNetworkConnectionInfo(networkConnectionInfo);
        }
        return connection;
    }

    private static Connection getConnection(String string, String string2, Properties properties) throws SQLException {
        if (StringUtils.isNullOrEmpty(string)) {
            JdbcUtils.load(string2);
        } else {
            Class clazz = JdbcUtils.loadUserClass(string);
            try {
                if (Driver.class.isAssignableFrom(clazz)) {
                    Driver driver = (Driver)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Connection connection = driver.connect(string2, properties);
                    if (connection != null) {
                        return connection;
                    }
                    throw new SQLException("Driver " + string + " is not suitable for " + string2, "08001");
                }
                if (Context.class.isAssignableFrom(clazz)) {
                    Context context = (Context)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    DataSource dataSource = (DataSource)context.lookup(string2);
                    String string3 = properties.getProperty("user");
                    String string4 = properties.getProperty("password");
                    if (StringUtils.isNullOrEmpty(string3) && StringUtils.isNullOrEmpty(string4)) {
                        return dataSource.getConnection();
                    }
                    return dataSource.getConnection(string3, string4);
                }
            }
            catch (Exception exception) {
                throw DbException.toSQLException(exception);
            }
        }
        return DriverManager.getConnection(string2, properties);
    }

    public static String getDriver(String string) {
        if (string.startsWith("jdbc:")) {
            string = string.substring("jdbc:".length());
            for (int i = 0; i < DRIVERS.length; i += 2) {
                String string2 = DRIVERS[i];
                if (!string.startsWith(string2)) continue;
                return DRIVERS[i + 1];
            }
        }
        return null;
    }

    public static void load(String string) {
        String string2 = JdbcUtils.getDriver(string);
        if (string2 != null) {
            JdbcUtils.loadUserClass(string2);
        }
    }

    public static byte[] serialize(Object object, JavaObjectSerializer javaObjectSerializer) {
        try {
            if (javaObjectSerializer != null) {
                return javaObjectSerializer.serialize(object);
            }
            if (serializer != null) {
                return serializer.serialize(object);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            throw DbException.get(90026, throwable, throwable.toString());
        }
    }

    public static Object deserialize(byte[] byArray, JavaObjectSerializer javaObjectSerializer) {
        try {
            ObjectInputStream objectInputStream;
            if (javaObjectSerializer != null) {
                return javaObjectSerializer.deserialize(byArray);
            }
            if (serializer != null) {
                return serializer.deserialize(byArray);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            if (SysProperties.USE_THREAD_CONTEXT_CLASS_LOADER) {
                final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                objectInputStream = new ObjectInputStream(byteArrayInputStream){

                    @Override
                    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                        try {
                            return Class.forName(objectStreamClass.getName(), true, classLoader);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            return super.resolveClass(objectStreamClass);
                        }
                    }
                };
            } else {
                objectInputStream = new ObjectInputStream(byteArrayInputStream);
            }
            return objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            throw DbException.get(90027, throwable, throwable.toString());
        }
    }

    public static ValueUuid deserializeUuid(byte[] byArray) {
        block3: {
            if (byArray.length == 80) {
                for (int i = 0; i < 64; ++i) {
                    if (byArray[i] == UUID_PREFIX[i]) {
                        continue;
                    }
                    break block3;
                }
                return ValueUuid.get(Bits.readLong(byArray, 72), Bits.readLong(byArray, 64));
            }
        }
        throw DbException.get(90027, "Is not a UUID");
    }

    public static void set(PreparedStatement preparedStatement, int n, Value value, CastDataProvider castDataProvider) throws SQLException {
        if (preparedStatement instanceof JdbcPreparedStatement) {
            if (value instanceof ValueLob) {
                JdbcUtils.setLob(preparedStatement, n, (ValueLob)value);
            } else {
                preparedStatement.setObject(n, value);
            }
        } else {
            JdbcUtils.setOther(preparedStatement, n, value, castDataProvider);
        }
    }

    private static void setOther(PreparedStatement preparedStatement, int n, Value value, CastDataProvider castDataProvider) throws SQLException {
        int n2 = value.getValueType();
        switch (n2) {
            case 0: {
                preparedStatement.setNull(n, 0);
                break;
            }
            case 1: {
                preparedStatement.setBoolean(n, value.getBoolean());
                break;
            }
            case 2: {
                preparedStatement.setByte(n, value.getByte());
                break;
            }
            case 3: {
                preparedStatement.setShort(n, value.getShort());
                break;
            }
            case 4: {
                preparedStatement.setInt(n, value.getInt());
                break;
            }
            case 5: {
                preparedStatement.setLong(n, value.getLong());
                break;
            }
            case 6: {
                preparedStatement.setBigDecimal(n, value.getBigDecimal());
                break;
            }
            case 7: {
                preparedStatement.setDouble(n, value.getDouble());
                break;
            }
            case 8: {
                preparedStatement.setFloat(n, value.getFloat());
                break;
            }
            case 9: {
                try {
                    preparedStatement.setObject(n, JSR310Utils.valueToLocalTime(value, null), 92);
                }
                catch (SQLException sQLException) {
                    preparedStatement.setTime(n, LegacyDateTimeUtils.toTime(null, null, value));
                }
                break;
            }
            case 10: {
                try {
                    preparedStatement.setObject(n, JSR310Utils.valueToLocalDate(value, null), 91);
                }
                catch (SQLException sQLException) {
                    preparedStatement.setDate(n, LegacyDateTimeUtils.toDate(null, null, value));
                }
                break;
            }
            case 11: {
                try {
                    preparedStatement.setObject(n, JSR310Utils.valueToLocalDateTime(value, null), 93);
                }
                catch (SQLException sQLException) {
                    preparedStatement.setTimestamp(n, LegacyDateTimeUtils.toTimestamp(null, null, value));
                }
                break;
            }
            case 12: 
            case 22: 
            case 40: 
            case 42: {
                preparedStatement.setBytes(n, value.getBytesNoCopy());
                break;
            }
            case 13: 
            case 14: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                preparedStatement.setString(n, value.getString());
                break;
            }
            case 15: 
            case 16: {
                JdbcUtils.setLob(preparedStatement, n, (ValueLob)value);
                break;
            }
            case 17: {
                preparedStatement.setArray(n, preparedStatement.getConnection().createArrayOf("NULL", (Object[])value.getObject()));
                break;
            }
            case 19: {
                preparedStatement.setObject(n, JdbcUtils.deserialize(value.getBytesNoCopy(), castDataProvider.getJavaObjectSerializer()), 2000);
                break;
            }
            case 20: {
                preparedStatement.setBytes(n, value.getBytes());
                break;
            }
            case 21: {
                try {
                    preparedStatement.setObject(n, (Object)value.getString(), 1);
                }
                catch (SQLException sQLException) {
                    preparedStatement.setString(n, value.getString());
                }
                break;
            }
            case 24: {
                try {
                    preparedStatement.setObject(n, JSR310Utils.valueToOffsetDateTime(value, null), 2014);
                    return;
                }
                catch (SQLException sQLException) {
                    preparedStatement.setString(n, value.getString());
                    break;
                }
            }
            case 41: {
                try {
                    preparedStatement.setObject(n, JSR310Utils.valueToOffsetTime(value, null), 2013);
                    return;
                }
                catch (SQLException sQLException) {
                    preparedStatement.setString(n, value.getString());
                    break;
                }
            }
            default: {
                throw DbException.getUnsupportedException(DataType.getDataType((int)n2).name);
            }
        }
    }

    private static void setLob(PreparedStatement preparedStatement, int n, ValueLob valueLob) throws SQLException {
        long l = valueLob.getPrecision();
        if (l > Integer.MAX_VALUE) {
            l = -1L;
        }
        if (valueLob.getValueType() == 15) {
            preparedStatement.setBinaryStream(n, valueLob.getInputStream(), (int)l);
        } else {
            preparedStatement.setCharacterStream(n, valueLob.getReader(), (int)l);
        }
    }

    static {
        DRIVERS = new String[]{"h2:", "org.h2.Driver", "Cache:", "com.intersys.jdbc.CacheDriver", "daffodilDB://", "in.co.daffodil.db.rmi.RmiDaffodilDBDriver", "daffodil", "in.co.daffodil.db.jdbc.DaffodilDBDriver", "db2:", "com.ibm.db2.jcc.DB2Driver", "derby:net:", "org.apache.derby.client.ClientAutoloadedDriver", "derby://", "org.apache.derby.client.ClientAutoloadedDriver", "derby:", "org.apache.derby.iapi.jdbc.AutoloadedDriver", "FrontBase:", "com.frontbase.jdbc.FBJDriver", "firebirdsql:", "org.firebirdsql.jdbc.FBDriver", "hsqldb:", "org.hsqldb.jdbcDriver", "informix-sqli:", "com.informix.jdbc.IfxDriver", "jtds:", "net.sourceforge.jtds.jdbc.Driver", "microsoft:", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "mimer:", "com.mimer.jdbc.Driver", "mysql:", "com.mysql.cj.jdbc.Driver", "mariadb:", "org.mariadb.jdbc.Driver", "odbc:", "sun.jdbc.odbc.JdbcOdbcDriver", "oracle:", "oracle.jdbc.driver.OracleDriver", "pervasive:", "com.pervasive.jdbc.v2.Driver", "pointbase:micro:", "com.pointbase.me.jdbc.jdbcDriver", "pointbase:", "com.pointbase.jdbc.jdbcUniversalDriver", "postgresql:", "org.postgresql.Driver", "sybase:", "com.sybase.jdbc3.jdbc.SybDriver", "sqlserver:", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "teradata:", "com.ncr.teradata.TeraDriver"};
        UUID_PREFIX = "\u00ac\u00ed\u0000\u0005sr\u0000\u000ejava.util.UUID\u00bc\u0099\u0003\u00f7\u0098m\u0085/\u0002\u0000\u0002J\u0000\fleastSigBitsJ\u0000\u000bmostSigBitsxp".getBytes(StandardCharsets.ISO_8859_1);
        userClassFactories = new ArrayList();
        String string = SysProperties.JAVA_OBJECT_SERIALIZER;
        if (string != null) {
            try {
                serializer = (JavaObjectSerializer)JdbcUtils.loadUserClass(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw DbException.convert(exception);
            }
        }
    }
}

