/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import java.util.ArrayList;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintDomain;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.Utils;
import org.h2.value.Value;

public class Domain
extends SchemaObjectBase {
    private Column column;
    private ArrayList<ConstraintDomain> constraints;

    public Domain(Schema schema, int n, String string) {
        super(schema, n, string, 8);
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public String getDropSQL() {
        StringBuilder stringBuilder = new StringBuilder("DROP DOMAIN IF EXISTS ");
        return this.getSQL(stringBuilder, 0).toString();
    }

    @Override
    public String getCreateSQL() {
        return this.getSQL(new StringBuilder("CREATE DOMAIN "), 0).append(" AS ").append(this.column.getCreateSQL()).toString();
    }

    public Column getColumn() {
        return this.column;
    }

    public void addConstraint(ConstraintDomain constraintDomain) {
        if (this.constraints == null) {
            this.constraints = Utils.newSmallArrayList();
        }
        if (!this.constraints.contains(constraintDomain)) {
            this.constraints.add(constraintDomain);
        }
    }

    public ArrayList<ConstraintDomain> getConstraints() {
        return this.constraints;
    }

    public void removeConstraint(Constraint constraint) {
        if (this.constraints != null) {
            this.constraints.remove(constraint);
        }
    }

    @Override
    public int getType() {
        return 12;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        if (this.constraints != null && !this.constraints.isEmpty()) {
            for (ConstraintDomain constraintDomain : this.constraints.toArray(new ConstraintDomain[0])) {
                this.database.removeSchemaObject(session, constraintDomain);
            }
            this.constraints = null;
        }
        this.database.removeMeta(session, this.getId());
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public void checkConstraints(Session session, Value value) {
        Object object;
        if (this.constraints != null) {
            object = this.constraints.iterator();
            while (object.hasNext()) {
                ConstraintDomain constraintDomain = (ConstraintDomain)object.next();
                constraintDomain.check(session, value);
            }
        }
        if ((object = this.column.getDomain()) != null) {
            ((Domain)object).checkConstraints(session, value);
        }
    }
}

