/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.h2.api.IntervalQualifier;
import org.h2.engine.CastDataProvider;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.rtree.SpatialDataType;
import org.h2.mvstore.rtree.SpatialKey;
import org.h2.mvstore.type.BasicDataType;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.MetaType;
import org.h2.mvstore.type.StatefulDataType;
import org.h2.result.ResultInterface;
import org.h2.result.RowFactory;
import org.h2.result.SearchRow;
import org.h2.result.SimpleResult;
import org.h2.result.SortOrder;
import org.h2.store.DataHandler;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBinary;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueChar;
import org.h2.value.ValueCollectionBase;
import org.h2.value.ValueDate;
import org.h2.value.ValueDouble;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInteger;
import org.h2.value.ValueInterval;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueJson;
import org.h2.value.ValueLob;
import org.h2.value.ValueNull;
import org.h2.value.ValueNumeric;
import org.h2.value.ValueReal;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueRow;
import org.h2.value.ValueSmallint;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueTinyint;
import org.h2.value.ValueUuid;
import org.h2.value.ValueVarbinary;
import org.h2.value.ValueVarchar;
import org.h2.value.ValueVarcharIgnoreCase;

public final class ValueDataType
extends BasicDataType<Value>
implements StatefulDataType<Database> {
    private static final byte NULL = 0;
    private static final byte TINYINT = 2;
    private static final byte SMALLINT = 3;
    private static final byte INTEGER = 4;
    private static final byte BIGINT = 5;
    private static final byte NUMERIC = 6;
    private static final byte DOUBLE = 7;
    private static final byte REAL = 8;
    private static final byte TIME = 9;
    private static final byte DATE = 10;
    private static final byte TIMESTAMP = 11;
    private static final byte VARBINARY = 12;
    private static final byte VARCHAR = 13;
    private static final byte VARCHAR_IGNORECASE = 14;
    private static final byte BLOB = 15;
    private static final byte CLOB = 16;
    private static final byte ARRAY = 17;
    private static final byte RESULT_SET = 18;
    private static final byte JAVA_OBJECT = 19;
    private static final byte UUID = 20;
    private static final byte CHAR = 21;
    private static final byte GEOMETRY = 22;
    private static final byte TIMESTAMP_TZ = 24;
    private static final byte ENUM = 25;
    private static final byte INTERVAL = 26;
    private static final byte ROW = 27;
    private static final byte INT_0_15 = 32;
    private static final byte BIGINT_0_7 = 48;
    private static final byte NUMERIC_0_1 = 56;
    private static final byte NUMERIC_SMALL_0 = 58;
    private static final byte NUMERIC_SMALL = 59;
    private static final byte DOUBLE_0_1 = 60;
    private static final byte REAL_0_1 = 62;
    private static final byte BOOLEAN_FALSE = 64;
    private static final byte BOOLEAN_TRUE = 65;
    private static final byte INT_NEG = 66;
    private static final byte BIGINT_NEG = 67;
    private static final byte VARCHAR_0_31 = 68;
    private static final int VARBINARY_0_31 = 100;
    private static final int SPATIAL_KEY_2D = 132;
    private static final int JSON = 134;
    private static final int TIMESTAMP_TZ_2 = 135;
    private static final int TIME_TZ = 136;
    private static final int BINARY = 137;
    final DataHandler handler;
    final CastDataProvider provider;
    final CompareMode compareMode;
    protected final Mode mode;
    final int[] sortTypes;
    SpatialDataType spatialType;
    private RowFactory rowFactory;
    private static final Factory FACTORY = new Factory();

    public ValueDataType() {
        this(null, CompareMode.getInstance(null, 0), null, null, null);
    }

    public ValueDataType(Database database, int[] nArray) {
        this(database, database.getCompareMode(), database.getMode(), database, nArray);
    }

    public ValueDataType(CastDataProvider castDataProvider, CompareMode compareMode, Mode mode, DataHandler dataHandler, int[] nArray) {
        this.provider = castDataProvider;
        this.compareMode = compareMode;
        this.mode = mode;
        this.handler = dataHandler;
        this.sortTypes = nArray;
    }

    public RowFactory getRowFactory() {
        return this.rowFactory;
    }

    public void setRowFactory(RowFactory rowFactory) {
        this.rowFactory = rowFactory;
    }

    private SpatialDataType getSpatialDataType() {
        if (this.spatialType == null) {
            this.spatialType = new SpatialDataType(2);
        }
        return this.spatialType;
    }

    public Value[] createStorage(int n) {
        return new Value[n];
    }

    @Override
    public int compare(Value value, Value value2) {
        if (value == value2) {
            return 0;
        }
        if (value instanceof SearchRow && value2 instanceof SearchRow) {
            return this.compare((SearchRow)value, (SearchRow)value2);
        }
        if (value instanceof ValueCollectionBase && value2 instanceof ValueCollectionBase) {
            Value[] valueArray = ((ValueCollectionBase)value).getList();
            Value[] valueArray2 = ((ValueCollectionBase)value2).getList();
            int n = valueArray.length;
            int n2 = valueArray2.length;
            int n3 = Math.min(n, n2);
            for (int i = 0; i < n3; ++i) {
                int n4 = this.sortTypes == null ? 0 : this.sortTypes[i];
                Value value3 = valueArray[i];
                Value value4 = valueArray2[i];
                if (value3 == null || value4 == null) {
                    return this.compareValues(valueArray[n3 - 1], valueArray2[n3 - 1], 0);
                }
                int n5 = this.compareValues(value3, value4, n4);
                if (n5 == 0) continue;
                return n5;
            }
            if (n3 < n) {
                return -1;
            }
            if (n3 < n2) {
                return 1;
            }
            return 0;
        }
        return this.compareValues(value, value2, 0);
    }

    @Override
    private int compare(SearchRow searchRow, SearchRow searchRow2) {
        if (searchRow == searchRow2) {
            return 0;
        }
        int[] nArray = this.rowFactory.getIndexes();
        if (nArray == null) {
            int n = searchRow.getColumnCount();
            assert (n == searchRow2.getColumnCount()) : n + " != " + searchRow2.getColumnCount();
            for (int i = 0; i < n; ++i) {
                int n2 = this.compareValues(searchRow.getValue(i), searchRow2.getValue(i), this.sortTypes[i]);
                if (n2 == 0) continue;
                return n2;
            }
            return 0;
        }
        assert (this.sortTypes.length == nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            Value value = searchRow.getValue(n);
            Value value2 = searchRow2.getValue(n);
            if (value == null || value2 == null) break;
            int n3 = this.compareValues(searchRow.getValue(n), searchRow2.getValue(n), this.sortTypes[i]);
            if (n3 == 0) continue;
            return n3;
        }
        long l = searchRow.getKey();
        long l2 = searchRow2.getKey();
        return l == SearchRow.MATCH_ALL_ROW_KEY || l2 == SearchRow.MATCH_ALL_ROW_KEY ? 0 : Long.compare(l, l2);
    }

    public int compareValues(Value value, Value value2, int n) {
        boolean bl;
        if (value == value2) {
            return 0;
        }
        boolean bl2 = bl = value == ValueNull.INSTANCE;
        if (bl || value2 == ValueNull.INSTANCE) {
            return SortOrder.compareNull(bl, n);
        }
        int n2 = value.compareTo(value2, this.provider, this.compareMode);
        if ((n & 1) != 0) {
            n2 = -n2;
        }
        return n2;
    }

    @Override
    public int getMemory(Value value) {
        if (value instanceof SpatialKey) {
            return this.getSpatialDataType().getMemory((SpatialKey)value);
        }
        return value == null ? 0 : value.getMemory();
    }

    @Override
    public Value read(ByteBuffer byteBuffer) {
        return this.readValue(byteBuffer, true);
    }

    @Override
    public void write(WriteBuffer writeBuffer, Value value) {
        if (value instanceof SpatialKey) {
            writeBuffer.put((byte)-124);
            this.getSpatialDataType().write(writeBuffer, (SpatialKey)value);
            return;
        }
        this.writeValue(writeBuffer, value, true);
    }

    private void writeValue(WriteBuffer writeBuffer, Value value, boolean bl) {
        if (value == ValueNull.INSTANCE) {
            writeBuffer.put((byte)0);
            return;
        }
        int n = value.getValueType();
        switch (n) {
            case 1: {
                writeBuffer.put(value.getBoolean() ? (byte)65 : 64);
                break;
            }
            case 2: {
                writeBuffer.put((byte)2).put(value.getByte());
                break;
            }
            case 3: {
                writeBuffer.put((byte)3).putShort(value.getShort());
                break;
            }
            case 4: 
            case 25: {
                int n2 = value.getInt();
                if (n2 < 0) {
                    writeBuffer.put((byte)66).putVarInt(-n2);
                    break;
                }
                if (n2 < 16) {
                    writeBuffer.put((byte)(32 + n2));
                    break;
                }
                writeBuffer.put(n == 4 ? (byte)4 : 25).putVarInt(n2);
                break;
            }
            case 5: {
                long l = value.getLong();
                ValueDataType.writeLong(writeBuffer, l);
                break;
            }
            case 6: {
                BigDecimal bigDecimal = value.getBigDecimal();
                if (BigDecimal.ZERO.equals(bigDecimal)) {
                    writeBuffer.put((byte)56);
                    break;
                }
                if (BigDecimal.ONE.equals(bigDecimal)) {
                    writeBuffer.put((byte)57);
                    break;
                }
                int n3 = bigDecimal.scale();
                BigInteger bigInteger = bigDecimal.unscaledValue();
                int n4 = bigInteger.bitLength();
                if (n4 <= 63) {
                    if (n3 == 0) {
                        writeBuffer.put((byte)58).putVarLong(bigInteger.longValue());
                        break;
                    }
                    writeBuffer.put((byte)59).putVarInt(n3).putVarLong(bigInteger.longValue());
                    break;
                }
                byte[] byArray = bigInteger.toByteArray();
                writeBuffer.put((byte)6).putVarInt(n3).putVarInt(byArray.length).put(byArray);
                break;
            }
            case 9: {
                ValueTime valueTime = (ValueTime)value;
                long l = valueTime.getNanos();
                long l2 = l / 1000000L;
                writeBuffer.put((byte)9).putVarLong(l2).putVarInt((int)(l -= l2 * 1000000L));
                break;
            }
            case 41: {
                ValueTimeTimeZone valueTimeTimeZone = (ValueTimeTimeZone)value;
                long l = valueTimeTimeZone.getNanos();
                writeBuffer.put((byte)-120).putVarInt((int)(l / 1000000000L)).putVarInt((int)(l % 1000000000L));
                ValueDataType.writeTimeZone(writeBuffer, valueTimeTimeZone.getTimeZoneOffsetSeconds());
                break;
            }
            case 10: {
                long l = ((ValueDate)value).getDateValue();
                writeBuffer.put((byte)10).putVarLong(l);
                break;
            }
            case 11: {
                ValueTimestamp valueTimestamp = (ValueTimestamp)value;
                long l = valueTimestamp.getDateValue();
                long l3 = valueTimestamp.getTimeNanos();
                long l4 = l3 / 1000000L;
                writeBuffer.put((byte)11).putVarLong(l).putVarLong(l4).putVarInt((int)(l3 -= l4 * 1000000L));
                break;
            }
            case 24: {
                ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value;
                long l = valueTimestampTimeZone.getDateValue();
                long l5 = valueTimestampTimeZone.getTimeNanos();
                long l6 = l5 / 1000000L;
                l5 -= l6 * 1000000L;
                int n5 = valueTimestampTimeZone.getTimeZoneOffsetSeconds();
                if (n5 % 60 == 0) {
                    writeBuffer.put((byte)24).putVarLong(l).putVarLong(l6).putVarInt((int)l5).putVarInt(n5 / 60);
                    break;
                }
                writeBuffer.put((byte)-121).putVarLong(l).putVarLong(l6).putVarInt((int)l5);
                ValueDataType.writeTimeZone(writeBuffer, n5);
                break;
            }
            case 19: {
                byte[] byArray = value.getBytesNoCopy();
                writeBuffer.put((byte)19).putVarInt(byArray.length).put(byArray);
                break;
            }
            case 12: {
                byte[] byArray = value.getBytesNoCopy();
                int n6 = byArray.length;
                if (n6 < 32) {
                    writeBuffer.put((byte)(100 + n6)).put(byArray);
                    break;
                }
                writeBuffer.put((byte)12).putVarInt(n6).put(byArray);
                break;
            }
            case 42: {
                byte[] byArray = value.getBytesNoCopy();
                writeBuffer.put((byte)-119).putVarInt(byArray.length).put(byArray);
                break;
            }
            case 20: {
                ValueUuid valueUuid = (ValueUuid)value;
                writeBuffer.put((byte)20).putLong(valueUuid.getHigh()).putLong(valueUuid.getLow());
                break;
            }
            case 13: {
                String string = value.getString();
                int n7 = string.length();
                if (n7 < 32) {
                    writeBuffer.put((byte)(68 + n7)).putStringData(string, n7);
                    break;
                }
                writeBuffer.put((byte)13);
                ValueDataType.writeString(writeBuffer, string);
                break;
            }
            case 14: {
                writeBuffer.put((byte)14);
                ValueDataType.writeString(writeBuffer, value.getString());
                break;
            }
            case 21: {
                writeBuffer.put((byte)21);
                ValueDataType.writeString(writeBuffer, value.getString());
                break;
            }
            case 7: {
                double d = value.getDouble();
                if (d == 1.0) {
                    writeBuffer.put((byte)61);
                    break;
                }
                long l = Double.doubleToLongBits(d);
                if (l == 0L) {
                    writeBuffer.put((byte)60);
                    break;
                }
                writeBuffer.put((byte)7).putVarLong(Long.reverse(l));
                break;
            }
            case 8: {
                float f = value.getFloat();
                if (f == 1.0f) {
                    writeBuffer.put((byte)63);
                    break;
                }
                int n8 = Float.floatToIntBits(f);
                if (n8 == 0) {
                    writeBuffer.put((byte)62);
                    break;
                }
                writeBuffer.put((byte)8).putVarInt(Integer.reverse(n8));
                break;
            }
            case 15: 
            case 16: {
                writeBuffer.put(n == 15 ? (byte)15 : 16);
                ValueLob valueLob = (ValueLob)value;
                byte[] byArray = valueLob.getSmall();
                if (byArray == null) {
                    writeBuffer.putVarInt(-3).putVarInt(valueLob.getTableId()).putVarLong(valueLob.getLobId()).putVarLong(valueLob.getType().getPrecision());
                    break;
                }
                writeBuffer.putVarInt(byArray.length).put(byArray);
                break;
            }
            case 17: {
                if (bl && this.rowFactory != null && value instanceof SearchRow) {
                    SearchRow searchRow = (SearchRow)value;
                    int[] nArray = this.rowFactory.getIndexes();
                    this.writeRow(writeBuffer, searchRow, nArray);
                    break;
                }
            }
            case 39: {
                Value[] valueArray = ((ValueCollectionBase)value).getList();
                writeBuffer.put(n == 17 ? (byte)17 : 27).putVarInt(valueArray.length);
                for (Value value2 : valueArray) {
                    this.writeValue(writeBuffer, value2, false);
                }
                break;
            }
            case 18: {
                writeBuffer.put((byte)18);
                ResultInterface resultInterface = value.getResult();
                int n9 = resultInterface.getVisibleColumnCount();
                writeBuffer.putVarInt(n9);
                for (int i = 0; i < n9; ++i) {
                    ValueDataType.writeString(writeBuffer, resultInterface.getAlias(i));
                    ValueDataType.writeString(writeBuffer, resultInterface.getColumnName(i));
                    TypeInfo typeInfo = resultInterface.getColumnType(i);
                    writeBuffer.putVarInt(typeInfo.getValueType()).putVarLong(typeInfo.getPrecision()).putVarInt(typeInfo.getScale());
                }
                while (resultInterface.next()) {
                    writeBuffer.put((byte)1);
                    Value[] valueArray = resultInterface.currentRow();
                    for (int i = 0; i < n9; ++i) {
                        this.writeValue(writeBuffer, valueArray[i], false);
                    }
                }
                writeBuffer.put((byte)0);
                break;
            }
            case 22: {
                byte[] byArray = value.getBytes();
                int n10 = byArray.length;
                writeBuffer.put((byte)22).putVarInt(n10).put(byArray);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                ValueInterval valueInterval = (ValueInterval)value;
                int n11 = n - 26;
                if (valueInterval.isNegative()) {
                    n11 ^= 0xFFFFFFFF;
                }
                writeBuffer.put((byte)26).put((byte)n11).putVarLong(valueInterval.getLeading());
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                ValueInterval valueInterval = (ValueInterval)value;
                int n12 = n - 26;
                if (valueInterval.isNegative()) {
                    n12 ^= 0xFFFFFFFF;
                }
                writeBuffer.put((byte)26).put((byte)n12).putVarLong(valueInterval.getLeading()).putVarLong(valueInterval.getRemaining());
                break;
            }
            case 40: {
                byte[] byArray = value.getBytesNoCopy();
                writeBuffer.put((byte)-122).putVarInt(byArray.length).put(byArray);
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + value.getValueType());
            }
        }
    }

    public void writeRow(WriteBuffer writeBuffer, SearchRow searchRow, int[] nArray) {
        writeBuffer.put((byte)17);
        if (nArray == null) {
            int n = searchRow.getColumnCount();
            writeBuffer.putVarInt(n + 1);
            for (int i = 0; i < n; ++i) {
                this.writeValue(writeBuffer, searchRow.getValue(i), false);
            }
        } else {
            writeBuffer.putVarInt(nArray.length + 1);
            for (int n : nArray) {
                this.writeValue(writeBuffer, searchRow.getValue(n), false);
            }
        }
        this.writeValue(writeBuffer, ValueBigint.get(searchRow.getKey()), false);
    }

    public static void writeLong(WriteBuffer writeBuffer, long l) {
        if (l < 0L) {
            writeBuffer.put((byte)67).putVarLong(-l);
        } else if (l < 8L) {
            writeBuffer.put((byte)(48L + l));
        } else {
            writeBuffer.put((byte)5).putVarLong(l);
        }
    }

    private static void writeString(WriteBuffer writeBuffer, String string) {
        int n = string.length();
        writeBuffer.putVarInt(n).putStringData(string, n);
    }

    private static void writeTimeZone(WriteBuffer writeBuffer, int n) {
        if (n % 900 == 0) {
            writeBuffer.put((byte)(n / 900));
        } else if (n > 0) {
            writeBuffer.put((byte)127).putVarInt(n);
        } else {
            writeBuffer.put((byte)-128).putVarInt(-n);
        }
    }

    private Value readValue(ByteBuffer byteBuffer, boolean bl) {
        int n = byteBuffer.get() & 0xFF;
        switch (n) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 65: {
                return ValueBoolean.TRUE;
            }
            case 64: {
                return ValueBoolean.FALSE;
            }
            case 66: {
                return ValueInteger.get(-DataUtils.readVarInt(byteBuffer));
            }
            case 4: 
            case 25: {
                return ValueInteger.get(DataUtils.readVarInt(byteBuffer));
            }
            case 67: {
                return ValueBigint.get(-DataUtils.readVarLong(byteBuffer));
            }
            case 5: {
                return ValueBigint.get(DataUtils.readVarLong(byteBuffer));
            }
            case 2: {
                return ValueTinyint.get(byteBuffer.get());
            }
            case 3: {
                return ValueSmallint.get(byteBuffer.getShort());
            }
            case 56: {
                return ValueNumeric.ZERO;
            }
            case 57: {
                return ValueNumeric.ONE;
            }
            case 58: {
                return ValueNumeric.get(BigDecimal.valueOf(DataUtils.readVarLong(byteBuffer)));
            }
            case 59: {
                int n2 = DataUtils.readVarInt(byteBuffer);
                return ValueNumeric.get(BigDecimal.valueOf(DataUtils.readVarLong(byteBuffer), n2));
            }
            case 6: {
                int n3 = DataUtils.readVarInt(byteBuffer);
                int n4 = DataUtils.readVarInt(byteBuffer);
                byte[] byArray = Utils.newBytes(n4);
                byteBuffer.get(byArray, 0, n4);
                BigInteger bigInteger = new BigInteger(byArray);
                return ValueNumeric.get(new BigDecimal(bigInteger, n3));
            }
            case 10: {
                return ValueDate.fromDateValue(DataUtils.readVarLong(byteBuffer));
            }
            case 9: {
                long l = DataUtils.readVarLong(byteBuffer) * 1000000L + (long)DataUtils.readVarInt(byteBuffer);
                return ValueTime.fromNanos(l);
            }
            case 136: {
                return ValueTimeTimeZone.fromNanos((long)DataUtils.readVarInt(byteBuffer) * 1000000000L + (long)DataUtils.readVarInt(byteBuffer), ValueDataType.readTimeZone(byteBuffer));
            }
            case 11: {
                long l = DataUtils.readVarLong(byteBuffer);
                long l2 = DataUtils.readVarLong(byteBuffer) * 1000000L + (long)DataUtils.readVarInt(byteBuffer);
                return ValueTimestamp.fromDateValueAndNanos(l, l2);
            }
            case 24: {
                long l = DataUtils.readVarLong(byteBuffer);
                long l3 = DataUtils.readVarLong(byteBuffer) * 1000000L + (long)DataUtils.readVarInt(byteBuffer);
                int n5 = DataUtils.readVarInt(byteBuffer) * 60;
                return ValueTimestampTimeZone.fromDateValueAndNanos(l, l3, n5);
            }
            case 135: {
                long l = DataUtils.readVarLong(byteBuffer);
                long l4 = DataUtils.readVarLong(byteBuffer) * 1000000L + (long)DataUtils.readVarInt(byteBuffer);
                int n6 = ValueDataType.readTimeZone(byteBuffer);
                return ValueTimestampTimeZone.fromDateValueAndNanos(l, l4, n6);
            }
            case 12: {
                int n7 = DataUtils.readVarInt(byteBuffer);
                byte[] byArray = Utils.newBytes(n7);
                byteBuffer.get(byArray, 0, n7);
                return ValueVarbinary.getNoCopy(byArray);
            }
            case 137: {
                int n8 = DataUtils.readVarInt(byteBuffer);
                byte[] byArray = Utils.newBytes(n8);
                byteBuffer.get(byArray, 0, n8);
                return ValueBinary.getNoCopy(byArray);
            }
            case 19: {
                int n9 = DataUtils.readVarInt(byteBuffer);
                byte[] byArray = Utils.newBytes(n9);
                byteBuffer.get(byArray, 0, n9);
                return ValueJavaObject.getNoCopy(byArray);
            }
            case 20: {
                return ValueUuid.get(byteBuffer.getLong(), byteBuffer.getLong());
            }
            case 13: {
                return ValueVarchar.get(DataUtils.readString(byteBuffer));
            }
            case 14: {
                return ValueVarcharIgnoreCase.get(DataUtils.readString(byteBuffer));
            }
            case 21: {
                return ValueChar.get(DataUtils.readString(byteBuffer));
            }
            case 26: {
                boolean bl2;
                int n10 = byteBuffer.get();
                boolean bl3 = bl2 = n10 < 0;
                if (bl2) {
                    n10 ^= 0xFFFFFFFF;
                }
                return ValueInterval.from(IntervalQualifier.valueOf(n10), bl2, DataUtils.readVarLong(byteBuffer), n10 < 5 ? 0L : DataUtils.readVarLong(byteBuffer));
            }
            case 62: {
                return ValueReal.ZERO;
            }
            case 63: {
                return ValueReal.ONE;
            }
            case 60: {
                return ValueDouble.ZERO;
            }
            case 61: {
                return ValueDouble.ONE;
            }
            case 7: {
                return ValueDouble.get(Double.longBitsToDouble(Long.reverse(DataUtils.readVarLong(byteBuffer))));
            }
            case 8: {
                return ValueReal.get(Float.intBitsToFloat(Integer.reverse(DataUtils.readVarInt(byteBuffer))));
            }
            case 15: 
            case 16: {
                int n11 = DataUtils.readVarInt(byteBuffer);
                if (n11 >= 0) {
                    byte[] byArray = Utils.newBytes(n11);
                    byteBuffer.get(byArray, 0, n11);
                    return ValueLob.createSmallLob(n == 15 ? 15 : 16, byArray);
                }
                if (n11 == -3) {
                    int n12 = DataUtils.readVarInt(byteBuffer);
                    long l = DataUtils.readVarLong(byteBuffer);
                    long l5 = DataUtils.readVarLong(byteBuffer);
                    return ValueLob.create(n == 15 ? 15 : 16, this.handler, n12, l, null, l5);
                }
                throw DbException.get(90030, "lob type: " + n11);
            }
            case 17: {
                if (this.rowFactory != null && bl) {
                    boolean bl4;
                    int n13 = DataUtils.readVarInt(byteBuffer) - 1;
                    SearchRow searchRow = this.rowFactory.createRow();
                    int[] nArray = this.rowFactory.getIndexes();
                    if (nArray == null) {
                        int n14 = searchRow.getColumnCount();
                        for (int i = 0; i < n14; ++i) {
                            searchRow.setValue(i, this.readValue(byteBuffer, false));
                        }
                        bl4 = n13 == n14;
                    } else {
                        for (int n15 : nArray) {
                            searchRow.setValue(n15, this.readValue(byteBuffer, false));
                        }
                        boolean bl5 = bl4 = n13 == nArray.length;
                    }
                    if (bl4) {
                        searchRow.setKey(this.readValue(byteBuffer, false).getLong());
                    }
                    return searchRow;
                }
            }
            case 27: {
                int n16 = DataUtils.readVarInt(byteBuffer);
                Value[] valueArray = new Value[n16];
                for (int i = 0; i < n16; ++i) {
                    valueArray[i] = this.readValue(byteBuffer, false);
                }
                return n == 17 ? ValueArray.get(valueArray) : ValueRow.get(valueArray);
            }
            case 18: {
                SimpleResult simpleResult = new SimpleResult();
                int n17 = DataUtils.readVarInt(byteBuffer);
                for (int i = 0; i < n17; ++i) {
                    simpleResult.addColumn(DataUtils.readString(byteBuffer), DataUtils.readString(byteBuffer), DataUtils.readVarInt(byteBuffer), DataUtils.readVarLong(byteBuffer), DataUtils.readVarInt(byteBuffer));
                }
                while (byteBuffer.get() != 0) {
                    Value[] valueArray = new Value[n17];
                    for (int i = 0; i < n17; ++i) {
                        valueArray[i] = this.readValue(byteBuffer, false);
                    }
                    simpleResult.addRow(valueArray);
                }
                return ValueResultSet.get(simpleResult);
            }
            case 22: {
                int n18 = DataUtils.readVarInt(byteBuffer);
                byte[] byArray = Utils.newBytes(n18);
                byteBuffer.get(byArray, 0, n18);
                return ValueGeometry.get(byArray);
            }
            case 132: {
                return this.getSpatialDataType().read(byteBuffer);
            }
            case 134: {
                int n19 = DataUtils.readVarInt(byteBuffer);
                byte[] byArray = Utils.newBytes(n19);
                byteBuffer.get(byArray, 0, n19);
                return ValueJson.getInternal(byArray);
            }
        }
        if (n >= 32 && n < 48) {
            return ValueInteger.get(n - 32);
        }
        if (n >= 48 && n < 56) {
            return ValueBigint.get(n - 48);
        }
        if (n >= 100 && n < 132) {
            int n20 = n - 100;
            byte[] byArray = Utils.newBytes(n20);
            byteBuffer.get(byArray, 0, n20);
            return ValueVarbinary.getNoCopy(byArray);
        }
        if (n >= 68 && n < 100) {
            return ValueVarchar.get(DataUtils.readString(byteBuffer, n - 68));
        }
        throw DbException.get(90030, "type: " + n);
    }

    private static int readTimeZone(ByteBuffer byteBuffer) {
        byte by = byteBuffer.get();
        if (by == 127) {
            return DataUtils.readVarInt(byteBuffer);
        }
        if (by == -128) {
            return -DataUtils.readVarInt(byteBuffer);
        }
        return by * 900;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ValueDataType)) {
            return false;
        }
        ValueDataType valueDataType = (ValueDataType)object;
        if (!this.compareMode.equals(valueDataType.compareMode)) {
            return false;
        }
        int[] nArray = this.rowFactory == null ? null : this.rowFactory.getIndexes();
        int[] nArray2 = valueDataType.rowFactory == null ? null : valueDataType.rowFactory.getIndexes();
        return Arrays.equals(this.sortTypes, valueDataType.sortTypes) && Arrays.equals(nArray, nArray2);
    }

    @Override
    public int hashCode() {
        int[] nArray = this.rowFactory == null ? null : this.rowFactory.getIndexes();
        return super.hashCode() ^ Arrays.hashCode(nArray) ^ this.compareMode.hashCode() ^ Arrays.hashCode(this.sortTypes);
    }

    @Override
    public void save(WriteBuffer writeBuffer, MetaType<Database> metaType) {
        ValueDataType.writeIntArray(writeBuffer, this.sortTypes);
        int n = this.rowFactory == null ? 0 : this.rowFactory.getColumnCount();
        writeBuffer.putVarInt(n);
        int[] nArray = this.rowFactory == null ? null : this.rowFactory.getIndexes();
        ValueDataType.writeIntArray(writeBuffer, nArray);
    }

    private static void writeIntArray(WriteBuffer writeBuffer, int[] nArray) {
        if (nArray == null) {
            writeBuffer.putVarInt(0);
        } else {
            writeBuffer.putVarInt(nArray.length + 1);
            for (int n : nArray) {
                writeBuffer.putVarInt(n);
            }
        }
    }

    public Factory getFactory() {
        return FACTORY;
    }

    public static final class Factory
    implements StatefulDataType.Factory<Database> {
        @Override
        public DataType<?> create(ByteBuffer byteBuffer, MetaType<Database> metaType, Database database) {
            Mode mode;
            int[] nArray = Factory.readIntArray(byteBuffer);
            int n = DataUtils.readVarInt(byteBuffer);
            int[] nArray2 = Factory.readIntArray(byteBuffer);
            CompareMode compareMode = database == null ? CompareMode.getInstance(null, 0) : database.getCompareMode();
            Mode mode2 = mode = database == null ? Mode.getRegular() : database.getMode();
            if (database == null) {
                return new ValueDataType();
            }
            if (nArray == null) {
                return new ValueDataType(database, null);
            }
            RowFactory rowFactory = RowFactory.getDefaultRowFactory().createRowFactory(database, compareMode, mode, database, nArray, nArray2, n);
            return rowFactory.getRowDataType();
        }

        private static int[] readIntArray(ByteBuffer byteBuffer) {
            int n = DataUtils.readVarInt(byteBuffer) - 1;
            if (n < 0) {
                return null;
            }
            int[] nArray = new int[n];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = DataUtils.readVarInt(byteBuffer);
            }
            return nArray;
        }
    }
}

