/*
 * Decompiled with CFR 0.152.
 */
package org.h2.constraint;

import java.util.HashSet;
import org.h2.command.Parser;
import org.h2.constraint.Constraint;
import org.h2.constraint.DomainColumnResolver;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.schema.Domain;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class ConstraintDomain
extends Constraint {
    private Domain domain;
    private Expression expr;
    private DomainColumnResolver resolver;

    public ConstraintDomain(Schema schema, int n, String string, Domain domain) {
        super(schema, n, string, null);
        this.domain = domain;
        this.resolver = new DomainColumnResolver(domain.getColumn().getType());
    }

    @Override
    public Constraint.Type getConstraintType() {
        return Constraint.Type.DOMAIN;
    }

    public Domain getDomain() {
        return this.domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpression(Session session, Expression expression) {
        expression.mapColumns(this.resolver, 0, 0);
        expression = expression.optimize(session);
        ConstraintDomain constraintDomain = this;
        synchronized (constraintDomain) {
            this.resolver.setValue(ValueNull.INSTANCE);
            expression.getValue(session);
        }
        this.expr = expression;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQL();
    }

    @Override
    public String getCreateSQL() {
        StringBuilder stringBuilder = new StringBuilder("ALTER DOMAIN ");
        this.domain.getSQL(stringBuilder, 0).append(" ADD CONSTRAINT ");
        this.getSQL(stringBuilder, 0);
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ");
            StringUtils.quoteStringSQL(stringBuilder, this.comment);
        }
        stringBuilder.append(" CHECK(");
        this.expr.getUnenclosedSQL(stringBuilder, 0).append(") NOCHECK");
        return stringBuilder.toString();
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.domain.removeConstraint(this);
        this.database.removeMeta(session, this.getId());
        this.domain = null;
        this.expr = null;
        this.invalidate();
    }

    @Override
    public void checkRow(Session session, Table table, Row row, Row row2) {
        DbException.throwInternalError(this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(Session session, Value value) {
        Value value2;
        ConstraintDomain constraintDomain = this;
        synchronized (constraintDomain) {
            this.resolver.setValue(value);
            value2 = this.expr.getValue(session);
        }
        if (value2 != ValueNull.INSTANCE && !value2.getBoolean()) {
            throw DbException.get(23513, this.expr.getTraceSQL());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getCheckConstraint(Session session, String string) {
        String string2;
        if (string != null) {
            String string3;
            ConstraintDomain constraintDomain = this;
            synchronized (constraintDomain) {
                try {
                    this.resolver.setColumnName(string);
                    string3 = this.expr.getSQL(0);
                }
                finally {
                    this.resolver.resetColumnName();
                }
            }
            return new Parser(session).parseExpression(string3);
        }
        ConstraintDomain constraintDomain = this;
        synchronized (constraintDomain) {
            string2 = this.expr.getSQL(0);
        }
        return new Parser(session).parseDomainConstraintExpression(string2);
    }

    @Override
    public boolean usesIndex(Index index) {
        return false;
    }

    @Override
    public void setIndexOwner(Index index) {
        DbException.throwInternalError(this.toString());
    }

    @Override
    public HashSet<Column> getReferencedColumns(Table table) {
        HashSet<Column> hashSet = new HashSet<Column>();
        this.expr.isEverything(ExpressionVisitor.getColumnsVisitor(hashSet, table));
        return hashSet;
    }

    @Override
    public Expression getExpression() {
        return this.expr;
    }

    @Override
    public boolean isBefore() {
        return true;
    }

    @Override
    public void checkExistingData(Session session) {
    }

    @Override
    public void rebuild() {
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.expr.isEverything(expressionVisitor);
    }
}

