/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.h2.command.Command;
import org.h2.command.dml.CommandWithValues;
import org.h2.command.dml.DataChangeStatement;
import org.h2.command.dml.Query;
import org.h2.command.dml.Select;
import org.h2.command.dml.Update;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.Comparison;
import org.h2.expression.condition.ConditionAndOr;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.mvstore.db.MVPrimaryIndex;
import org.h2.pagestore.db.PageDataIndex;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.DataChangeDeltaTable;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.HasSQL;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class Insert
extends CommandWithValues
implements ResultTarget,
DataChangeStatement {
    private Table table;
    private Column[] columns;
    private Query query;
    private boolean sortedInsertMode;
    private int rowNumber;
    private boolean insertFromSelect;
    private TableFilter sourceTableFilter;
    private HashMap<Column, Expression> duplicateKeyAssignmentMap;
    private boolean ignore;
    private ResultTarget deltaChangeCollector;
    private DataChangeDeltaTable.ResultOption deltaChangeCollectionMode;

    public Insert(Session session) {
        super(session);
    }

    @Override
    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Column[] columnArray) {
        this.columns = columnArray;
    }

    public void setIgnore(boolean bl) {
        this.ignore = bl;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void addAssignmentForDuplicate(Column column, Expression expression) {
        if (this.duplicateKeyAssignmentMap == null) {
            this.duplicateKeyAssignmentMap = new HashMap();
        }
        if (this.duplicateKeyAssignmentMap.putIfAbsent(column, expression) != null) {
            throw DbException.get(42121, column.getName());
        }
    }

    @Override
    public void setDeltaChangeCollector(ResultTarget resultTarget, DataChangeDeltaTable.ResultOption resultOption) {
        this.deltaChangeCollector = resultTarget;
        this.deltaChangeCollectionMode = resultOption;
    }

    @Override
    public int update() {
        Index index = null;
        if (this.sortedInsertMode) {
            if (!this.session.getDatabase().isMVStore()) {
                this.table.lock(this.session, true, true);
            }
            index = this.table.getScanIndex(this.session);
            index.setSortedInsertMode(true);
        }
        try {
            int n = this.insertRows();
            return n;
        }
        finally {
            if (index != null) {
                index.setSortedInsertMode(false);
            }
        }
    }

    private int insertRows() {
        this.session.getUser().checkRight(this.table, 4);
        this.setCurrentRowNumber(0L);
        this.table.fire(this.session, 1, true);
        this.rowNumber = 0;
        int n = this.valuesExpressionList.size();
        if (n > 0) {
            int n2 = this.columns.length;
            for (int i = 0; i < n; ++i) {
                Row row = this.table.getTemplateRow();
                Expression[] expressionArray = (Expression[])this.valuesExpressionList.get(i);
                this.setCurrentRowNumber(i + 1);
                for (int j = 0; j < n2; ++j) {
                    Column column = this.columns[j];
                    int n3 = column.getColumnId();
                    Expression expression = expressionArray[j];
                    if (expression == ValueExpression.DEFAULT) continue;
                    expression = expression.optimize(this.session);
                    try {
                        Value value = expression.getValue(this.session);
                        row.setValue(n3, value);
                        continue;
                    }
                    catch (DbException dbException) {
                        throw this.setRow(dbException, i, Insert.getSimpleSQL(expressionArray));
                    }
                }
                ++this.rowNumber;
                this.table.validateConvertUpdateSequence(this.session, row);
                if (this.deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.NEW) {
                    this.deltaChangeCollector.addRow((Value[])row.getValueList().clone());
                }
                if (!this.table.fireBeforeRow(this.session, null, row)) {
                    this.table.lock(this.session, true, false);
                    try {
                        this.table.addRow(this.session, row);
                    }
                    catch (DbException dbException) {
                        if (this.handleOnDuplicate(dbException, null)) {
                            ++this.rowNumber;
                            continue;
                        }
                        --this.rowNumber;
                        continue;
                    }
                    if (this.deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.FINAL) {
                        this.deltaChangeCollector.addRow(row.getValueList());
                    }
                    this.session.log(this.table, (short)0, row);
                    this.table.fireAfterRow(this.session, null, row, false);
                    continue;
                }
                if (this.deltaChangeCollectionMode != DataChangeDeltaTable.ResultOption.FINAL) continue;
                this.deltaChangeCollector.addRow(row.getValueList());
            }
        } else {
            this.table.lock(this.session, true, false);
            if (this.insertFromSelect) {
                this.query.query(0, this);
            } else {
                ResultInterface resultInterface = this.query.query(0);
                while (resultInterface.next()) {
                    Value[] valueArray = resultInterface.currentRow();
                    try {
                        this.addRow(valueArray);
                    }
                    catch (DbException dbException) {
                        if (this.handleOnDuplicate(dbException, valueArray)) {
                            ++this.rowNumber;
                            continue;
                        }
                        --this.rowNumber;
                    }
                }
                resultInterface.close();
            }
        }
        this.table.fire(this.session, 1, false);
        return this.rowNumber;
    }

    @Override
    public void addRow(Value ... valueArray) {
        Row row = this.table.getTemplateRow();
        this.setCurrentRowNumber(++this.rowNumber);
        int n = this.columns.length;
        for (int i = 0; i < n; ++i) {
            row.setValue(this.columns[i].getColumnId(), valueArray[i]);
        }
        this.table.validateConvertUpdateSequence(this.session, row);
        if (this.deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.NEW) {
            this.deltaChangeCollector.addRow((Value[])row.getValueList().clone());
        }
        if (!this.table.fireBeforeRow(this.session, null, row)) {
            this.table.addRow(this.session, row);
            if (this.deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.FINAL) {
                this.deltaChangeCollector.addRow(row.getValueList());
            }
            this.session.log(this.table, (short)0, row);
            this.table.fireAfterRow(this.session, null, row, false);
        } else if (this.deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.FINAL) {
            this.deltaChangeCollector.addRow(row.getValueList());
        }
    }

    @Override
    public int getRowCount() {
        return this.rowNumber;
    }

    @Override
    public void limitsWereApplied() {
    }

    @Override
    public String getPlanSQL(int n) {
        StringBuilder stringBuilder = new StringBuilder("INSERT INTO ");
        this.table.getSQL(stringBuilder, n).append('(');
        Column.writeColumns(stringBuilder, this.columns, n);
        stringBuilder.append(")\n");
        if (this.insertFromSelect) {
            stringBuilder.append("DIRECT ");
        }
        if (this.sortedInsertMode) {
            stringBuilder.append("SORTED ");
        }
        if (!this.valuesExpressionList.isEmpty()) {
            stringBuilder.append("VALUES ");
            int n2 = 0;
            if (this.valuesExpressionList.size() > 1) {
                stringBuilder.append('\n');
            }
            for (Expression[] expressionArray : this.valuesExpressionList) {
                if (n2++ > 0) {
                    stringBuilder.append(",\n");
                }
                stringBuilder.append('(');
                Expression.writeExpressions(stringBuilder, expressionArray, n);
                stringBuilder.append(')');
            }
        } else {
            stringBuilder.append(this.query.getPlanSQL(n));
        }
        return stringBuilder.toString();
    }

    @Override
    public void prepare() {
        if (this.columns == null) {
            this.columns = !this.valuesExpressionList.isEmpty() && ((Expression[])this.valuesExpressionList.get(0)).length == 0 ? new Column[0] : this.table.getColumns();
        }
        if (!this.valuesExpressionList.isEmpty()) {
            for (Expression[] expressionArray : this.valuesExpressionList) {
                if (expressionArray.length != this.columns.length) {
                    throw DbException.get(21002);
                }
                int n = expressionArray.length;
                for (int i = 0; i < n; ++i) {
                    Expression expression = expressionArray[i];
                    if (expression == null) continue;
                    if (this.sourceTableFilter != null) {
                        expression.mapColumns(this.sourceTableFilter, 0, 0);
                    }
                    if ((expression = expression.optimize(this.session)) instanceof Parameter) {
                        Parameter parameter = (Parameter)expression;
                        parameter.setColumn(this.columns[i]);
                    }
                    expressionArray[i] = expression;
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw DbException.get(21002);
            }
        }
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    public void setSortedInsertMode(boolean bl) {
        this.sortedInsertMode = bl;
    }

    @Override
    public int getType() {
        return 61;
    }

    @Override
    public String getStatementName() {
        return "INSERT";
    }

    public void setInsertFromSelect(boolean bl) {
        this.insertFromSelect = bl;
    }

    @Override
    public boolean isCacheable() {
        return this.duplicateKeyAssignmentMap == null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean handleOnDuplicate(DbException dbException, Value[] valueArray) {
        Object object2;
        if (dbException.getErrorCode() != 23505) {
            throw dbException;
        }
        if (this.duplicateKeyAssignmentMap == null) {
            if (this.ignore) {
                return false;
            }
            throw dbException;
        }
        int n = this.columns.length;
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        Expression[] expressionArray = valueArray == null ? (Expression[])this.valuesExpressionList.get((int)this.getCurrentRowNumber() - 1) : new Expression[n];
        for (int i = 0; i < n; ++i) {
            void object3;
            StringBuilder stringBuilder = this.table.getSQL(new StringBuilder(), 0).append('.');
            object2 = this.columns[i].getSQL(stringBuilder, 0).toString();
            arrayList.add(object2);
            if (valueArray != null) {
                Value value = valueArray[i];
                expressionArray[i] = ValueExpression.get(value);
            } else {
                Value value = expressionArray[i].getValue(this.session);
            }
            this.session.setVariable((String)object2, (Value)object3);
        }
        StringBuilder stringBuilder = new StringBuilder("UPDATE ");
        this.table.getSQL(stringBuilder, 0).append(" SET ");
        boolean bl = false;
        for (Map.Entry entry : this.duplicateKeyAssignmentMap.entrySet()) {
            if (bl) {
                stringBuilder.append(", ");
            }
            bl = true;
            ((Column)entry.getKey()).getSQL(stringBuilder, 0).append('=');
            ((Expression)entry.getValue()).getSQL(stringBuilder, 0);
        }
        stringBuilder.append(" WHERE ");
        object2 = (Index)dbException.getSource();
        if (object2 == null) {
            throw DbException.getUnsupportedException("Unable to apply ON DUPLICATE KEY UPDATE, no index found!");
        }
        this.prepareUpdateCondition((Index)object2, expressionArray).getSQL(stringBuilder, 0);
        String string = stringBuilder.toString();
        Update update = (Update)this.session.prepare(string);
        update.setUpdateToCurrentValuesReturnsZero(true);
        for (Parameter parameter : update.getParameters()) {
            Object object = (Parameter)this.parameters.get(parameter.getIndex());
            parameter.setValue(((Parameter)object).getValue(this.session));
        }
        boolean bl2 = update.update() > 0;
        for (Object object : arrayList) {
            this.session.setVariable((String)object, ValueNull.INSTANCE);
        }
        return bl2;
    }

    private Expression prepareUpdateCondition(Index index, Expression[] expressionArray) {
        Column[] columnArray;
        HasSQL hasSQL;
        if (index instanceof MVPrimaryIndex) {
            hasSQL = (MVPrimaryIndex)index;
            columnArray = new Column[]{hasSQL.getIndexColumns()[hasSQL.getMainIndexColumn()].column};
        } else if (index instanceof PageDataIndex) {
            Column[] columnArray2;
            hasSQL = (PageDataIndex)index;
            int n = ((PageDataIndex)hasSQL).getMainIndexColumn();
            if (n >= 0) {
                Column[] columnArray3 = new Column[1];
                columnArray2 = columnArray3;
                columnArray3[0] = hasSQL.getIndexColumns()[n].column;
            } else {
                columnArray2 = index.getColumns();
            }
            columnArray = columnArray2;
        } else {
            columnArray = index.getColumns();
        }
        hasSQL = null;
        block0: for (Column column : columnArray) {
            ExpressionColumn expressionColumn = new ExpressionColumn(this.session.getDatabase(), this.table.getSchema().getName(), this.table.getName(), column.getName(), false);
            for (int i = 0; i < this.columns.length; ++i) {
                if (!expressionColumn.getColumnName().equals(this.columns[i].getName())) continue;
                if (hasSQL == null) {
                    hasSQL = new Comparison(0, expressionColumn, expressionArray[i]);
                    continue block0;
                }
                hasSQL = new ConditionAndOr(0, (Expression)hasSQL, new Comparison(0, expressionColumn, expressionArray[i]));
                continue block0;
            }
        }
        return hasSQL;
    }

    public void setSourceTableFilter(TableFilter tableFilter) {
        this.sourceTableFilter = tableFilter;
    }

    @Override
    public void collectDependencies(HashSet<DbObject> hashSet) {
        Select select;
        ExpressionVisitor expressionVisitor = ExpressionVisitor.getDependenciesVisitor(hashSet);
        if (this.query != null) {
            this.query.isEverything(expressionVisitor);
        }
        if (this.sourceTableFilter != null && (select = this.sourceTableFilter.getSelect()) != null) {
            select.isEverything(expressionVisitor);
        }
    }
}

