"""
Algorithm and group name formatting utilities
"""

groups = {
    "ta_slope_stability": "Terrain Analysis",
    "pointcloud_tools": "Features",
    "imagery_maxent": "Imagery",
    "imagery_tools": "Imagery",
    "shapes_grid": "Features",
    "ta_profiles": "Terrain Analysis",
    "contrib_perego": "Raster",
    "imagery_photogrammetry": "Imagery",
    "shapes_lines": "Features",
    "io_table": "Import/Export",
    "io_shapes": "Import/Export",
    "imagery_isocluster": "Imagery",
    "statistics_kriging": "Spatial and Geostatistics",
    "grid_analysis": "Raster",
    "shapes_polygons": "Features",
    "io_gdal": "Import/Export",
    "grid_tools": "Raster",
    "grid_filter": "Raster",
    "statistics_grid": "Spatial and Geostatistics",
    "io_webservices": "Import/Export",
    "ta_morphometry": "Terrain Analysis",
    "shapes_tools": "Features",
    "grid_calculus": "Raster",
    "ta_preprocessor": "Terrain Analysis",
    "io_gps": "Import/Export",
    "ta_channels": "Terrain Analysis",
    "imagery_segmentation": "Imagery",
    "ta_lighting": "Terrain Analysis",
    "grid_gridding": "Raster",
    "ta_hydrology": "Terrain Analysis",
    "imagery_opencv": "Imagery",
    "statistics_points": "Spatial and Geostatistics",
    "io_grid_image": "Import/Export",
    "pj_georeference": "Projection",
    "statistics_regression": "Spatial and Geostatistics",
    "ta_compound": "Terrain Analysis",
    "ta_cliffmetrics": "Terrain Analysis",
    "imagery_classification": "Imagery",
    "io_grid": "Import/Export",
    "io_pdal": "Import/Export",
    "shapes_transect": "Features",
    "imagery_svm": "Imagery",
    "grid_spline": "Raster",
    "climate_tools": "Climate and Weather",
    "shapes_points": "Features",
    "io_virtual": "Import/Export",
    "pj_proj4": "Projection",
    "imagery_vigra": "Imagery",
    "tta_tools": "Tool Chains",
}


def decoratedGroupName(name: str) -> str:
    """
    Returns a nice user-friendly group name instead of a raw SAGA group name
    """
    return groups.get(name, name)


algorithms = {
    "SAFETYFACTOR": "SAFETYFACTOR",
    "TOBIA": "TOBIA",
    "SHALSTAB": "SHALSTAB",
    "WETNESS": "WETNESS",
    "WEDGEFAIL": "WEDGEFAIL",
    "ANGMAP": "ANGMAP",
    "Point Cloud from Grid Points": "Point Cloud from Raster Points",
    "Point Cloud from Shapes": "Point Cloud from Features",
    "Point Cloud to Shapes": "Point Cloud to Features",
    "Drop Point Cloud Attributes": "Drop Point Cloud Attributes",
    "Transform Point Cloud": "Transform Point Cloud",
    "Point Cloud Thinning (Simple)": "Point Cloud Thinning (Simple)",
    "Point Cloud Attribute Calculator": "Point Cloud Attribute Calculator",
    "Cluster Analysis for Point Clouds": "Cluster Analysis for Point Clouds",
    "Merge Point Clouds": "Merge Point Clouds",
    "Point Cloud from Table": "Point Cloud from Table",
    "Select Point Cloud from List": "Select Point Cloud from List",
    "Ground Classification": "Ground Classification",
    "Isolated Points Filter": "Isolated Points Filter",
    "Maximum Entropy Classification": "Maximum Entropy Classification",
    "Maximum Entropy Presence Prediction": "Maximum Entropy Presence Prediction",
    "Vegetation Index (Distance Based)": "Vegetation Index (Distance Based)",
    "Vegetation Index (Slope Based)": "Vegetation Index (Slope Based)",
    "Enhanced Vegetation Index": "Enhanced Vegetation Index",
    "Tasseled Cap Transformation": "Tasseled Cap Transformation",
    "IHS Sharpening": "IHS Sharpening",
    "Colour Normalized Brovey Sharpening": "Colour Normalized Brovey Sharpening",
    "Colour Normalized Spectral Sharpening": "Colour Normalized Spectral Sharpening",
    "Principal Component Based Image Sharpening": "Principal Component Based Image Sharpening",
    "Top of Atmosphere Reflectance": "Top of Atmosphere Reflectance",
    "Automated Cloud Cover Assessment": "Automated Cloud Cover Assessment",
    "Landsat Import with Options": "Landsat Import with Options",
    "Textural Features": "Textural Features",
    "Local Statistical Measures": "Local Statistical Measures",
    "Universal Image Quality Index": "Universal Image Quality Index",
    "Import Landsat Scene": "Import Landsat Scene",
    "Import Sentinel-2 Scene": "Import Sentinel-2 Scene",
    "Import Sentinel-3 OLCI Scene": "Import Sentinel-3 OLCI Scene",
    "Spectral Profile": "Spectral Profile",
    "Topographic Correction": "Topographic Correction",
    "Cloud Detection": "Cloud Detection",
    "Cloud Shadow Detection": "Cloud Shadow Detection",
    "Add Grid Values to Points": "Add Raster Values to Points",
    "Add Grid Values to Shapes": "Add Raster Values to Features",
    "Grid Statistics for Polygons": "Raster Statistics for Polygons",
    "Grid Values to Points": "Raster Values to Points",
    "Grid Values to Points (randomly)": "Raster Values to Points (randomly)",
    "Contour Lines from Grid": "Contour Lines from Raster",
    "Vectorizing Grid Classes": "Vectorizing Raster Classes",
    "Clip Grid with Polygon": "Clip Raster with Polygon",
    "Grid Statistics for Points": "Raster Statistics for Points",
    "Local Minima and Maxima": "Local Minima and Maxima",
    "Grid System Extent": "Raster System Extent",
    "Gradient Vectors from Surface": "Gradient Vectors from Surface",
    "Gradient Vectors from Direction and Length": "Gradient Vectors from Direction and Length",
    "Gradient Vectors from Directional Components": "Gradient Vectors from Directional Components",
    "Grid Classes Area for Polygons": "Raster Classes Area for Polygons",
    "Boundary Cells to Polygons": "Boundary Cells to Polygons",
    "Cross Profiles": "Cross Profiles",
    "Profiles from Lines": "Profiles from Lines",
    "Profile from Points": "Profile from Points",
    "Average With Thereshold 1": "Average With Thereshold 1",
    "Average With Thereshold 2": "Average With Thereshold 2",
    "Average With Thereshold 3": "Average With Thereshold 3",
    "Average With Mask 1": "Average With Mask 1",
    "Average With Mask 2": "Average With Mask 2",
    "Destriping": "Destriping",
    "Destriping with Mask": "Destriping with Mask",
    "Directional Average": "Directional Average",
    "Resection (Terrestrial)": "Resection (Terrestrial)",
    "Colorisation (PC)": "Colorisation (PC)",
    "Convert Polygons to Lines": "Convert Polygons to Lines",
    "Convert Points to Line(s)": "Convert Points to Line(s)",
    "Line Properties": "Line Properties",
    "Line-Polygon Intersection": "Line-Polygon Intersection",
    "Line Simplification": "Line Simplification",
    "Line Dissolve": "Line Dissolve",
    "Split Lines with Lines": "Split Lines with Lines",
    "Line Smoothing": "Line Smoothing",
    "Split Lines at Points": "Split Lines at Points",
    "Line Crossings": "Line Crossings",
    "Extract Closed Lines": "Extract Closed Lines",
    "Split Lines": "Split Lines",
    "Line Parts to Separate Lines": "Line Parts to Separate Lines",
    "Flip Line Direction": "Flip Line Direction",
    "Export Text Table": "Export Text Table",
    "Import Text Table": "Import Text Table",
    "Import Text Table with Numbers only": "Import Text Table with Numbers only",
    "Export GStat Shapes": "Export GStat Features",
    "Import GStat Shapes": "Import GStat Features",
    "Export Shapes to XYZ": "Export Features to XYZ",
    "Import Shapes from XYZ": "Import Features from XYZ",
    "Export Shapes to Generate": "Export Features to Generate",
    "Export Surfer Blanking File": "Export Surfer Blanking File",
    "Import Surfer Blanking Files": "Import Surfer Blanking Files",
    "Export Atlas Boundary File": "Export Atlas Boundary File",
    "Import Atlas Boundary File": "Import Atlas Boundary File",
    "Export WASP terrain map file": "Export WASP terrain map file",
    "Import WASP terrain map file": "Import WASP terrain map file",
    "Import GPX": "Import GPX",
    "Export GPX": "Export GPX",
    "Export Scalable Vector Graphics (SVG) File": "Export Scalable Vector Graphics (SVG) File",
    "Export Point Cloud to Text File": "Export Point Cloud to Text File",
    "Import Simple Features from Well Known Text": "Import Simple Features from Well Known Text",
    "Export Simple Features to Well Known Text": "Export Simple Features to Well Known Text",
    "Import Building Sketches from CityGML": "Import Building Sketches from CityGML",
    "Export Polygons to HTML Image Map": "Export Polygons to HTML Image Map",
    "Import Point Cloud from PTS File": "Import Point Cloud from PTS File",
    "ISODATA Clustering for Grids": "ISODATA Clustering for Rasters",
    "Ordinary Kriging": "Ordinary Kriging",
    "Simple Kriging": "Simple Kriging",
    "Universal Kriging": "Universal Kriging",
    "Regression Kriging": "Regression Kriging",
    "Variogram (Dialog)": "Variogram (Dialog)",
    "Accumulated Cost": "Accumulated Cost",
    "Least Cost Paths": "Least Cost Paths",
    "Covered Distance": "Covered Distance",
    "Pattern Analysis": "Pattern Analysis",
    "Layer of extreme value": "Layer of extreme value",
    "Analytical Hierarchy Process": "Analytical Hierarchy Process",
    "Aggregation Index": "Aggregation Index",
    "Cross-Classification and Tabulation": "Cross-Classification and Tabulation",
    "Fragmentation (Standard)": "Fragmentation (Standard)",
    "Fragmentation (Alternative)": "Fragmentation (Alternative)",
    "Fragmentation Classes from Density and Connectivity": "Fragmentation Classes from Density and Connectivity",
    "Accumulation Functions": "Accumulation Functions",
    "IMCORR - Feature Tracking": "IMCORR - Feature Tracking",
    "Diversity of Categories": "Diversity of Categories",
    "Shannon Index": "Shannon Index",
    "Simpson Index": "Simpson Index",
    "Raos Q Diversity Index (Classic)": "Raos Q Diversity Index (Classic)",
    "Raos Q Diversity Index": "Raos Q Diversity Index",
    "Coverage of Categories": "Coverage of Categories",
    "Iterative Truncation": "Iterative Truncation",
    "Object Enumeration": "Object Enumeration",
    "Polygon Centroids": "Polygon Centroids",
    "Polygon Properties": "Polygon Properties",
    "Convert Lines to Polygons": "Convert Lines to Polygons",
    "Point Statistics for Polygons": "Point Statistics for Polygons",
    "Polygon Dissolve": "Polygon Dissolve",
    "Convert Polygon/Line Vertices to Points": "Convert Polygon/Line Vertices to Points",
    "Polygon Shape Indices": "Polygon Shape Indices",
    "Polygon-Line Intersection": "Polygon-Line Intersection",
    "Polygons to Edges and Nodes": "Polygons to Edges and Nodes",
    "Polygon Parts to Separate Polygons": "Polygon Parts to Separate Polygons",
    "Polygon Clipping": "Polygon Clipping",
    "Polygon Self-Intersection": "Polygon Self-Intersection",
    "Intersect": "Intersect",
    "Difference": "Difference",
    "Symmetrical Difference": "Symmetrical Difference",
    "Union": "Union",
    "Update": "Update",
    "Identity": "Identity",
    "Add Point Attributes to Polygons": "Add Point Attributes to Polygons",
    "Flatten Polygon Layer": "Flatten Polygon Layer",
    "Shared Polygon Edges": "Shared Polygon Edges",
    "Polygon Generalization": "Polygon Generalization",
    "Import Raster": "Import Raster",
    "Export Raster": "Export Raster",
    "Export GeoTIFF": "Export GeoTIFF",
    "Import Shapes": "Import Features",
    "Export Shapes": "Export Features",
    "Export Shapes to KML": "Export Features to KML",
    "Import NetCDF": "Import NetCDF",
    "Create Raster Catalogue from Files": "Create Raster Catalogue from Files",
    "Create Raster Catalogues from Directory": "Create Raster Catalogues from Directory",
    "GDAL Formats": "GDAL Formats",
    "Create Virtual Raster (VRT)": "Create Virtual Raster (VRT)",
    "Import from Virtual Raster (VRT)": "Import from Virtual Raster (VRT)",
    "Create Raster Catalogue from Virtual Raster (VRT)": "Create Raster Catalogue from Virtual Raster (VRT)",
    "Resampling": "Resampling",
    "Mosaicking": "Mosaicking",
    "Constant Grid": "Constant Raster",
    "Patching": "Patching",
    "Close One Cell Gaps": "Close One Cell Gaps",
    "Close Gaps": "Close Gaps",
    "Grid Buffer": "Raster Buffer",
    "Threshold Buffer": "Threshold Buffer",
    "Grid Proximity Buffer": "Raster Proximity Buffer",
    "Change Data Storage": "Change Data Storage",
    "Crop to Data": "Crop to Data",
    "Invert Data/No-Data": "Invert Data/No-Data",
    "Grid Cell Index": "Raster Cell Index",
    "Grids from Classified Grid and Table": "Rasters from Classified Raster and Table",
    "Grid Masking": "Raster Masking",
    "Close Gaps with Spline": "Close Gaps with Spline",
    "Proximity Grid": "Proximity Raster",
    "Tiling": "Tiling",
    "Shrink and Expand": "Shrink and Expand",
    "Close Gaps with Stepwise Resampling": "Close Gaps with Stepwise Resampling",
    "Transpose Grids": "Transpose Rasters",
    "Clip Grids": "Clip Rasters",
    "Select Grid from List": "Select Raster from List",
    "Copy Grid": "Copy Raster",
    "Invert Grid": "Invert Raster",
    "Mirror Grid": "Mirror Raster",
    "Change a Grids No-Data Value": "Change a Rasters No-Data Value",
    "Combine Classes": "Combine Classes",
    "Change Grid Values - Flood Fill": "Change Raster Values - Flood Fill",
    "Simple Filter": "Simple Filter",
    "Gaussian Filter": "Gaussian Filter",
    "Laplacian Filter": "Laplacian Filter",
    "Multi Direction Lee Filter": "Multi Direction Lee Filter",
    "Filter Clumps": "Filter Clumps",
    "Majority/Minority Filter": "Majority/Minority Filter",
    "DTM Filter (slope-based)": "DTM Filter (slope-based)",
    "Morphological Filter": "Morphological Filter",
    "Rank Filter": "Rank Filter",
    "Mesh Denoise": "Mesh Denoise",
    "Resampling Filter": "Resampling Filter",
    "Geodesic Morphological Reconstruction": "Geodesic Morphological Reconstruction",
    "Binary Erosion-Reconstruction": "Binary Erosion-Reconstruction",
    "Connectivity Analysis": "Connectivity Analysis",
    "Sieve Classes": "Sieve Classes",
    "Wombling (Edge Detection)": "Wombling (Edge Detection)",
    "Wombling for Multiple Features (Edge Detection)": "Wombling for Multiple Features (Edge Detection)",
    "Simple Filter (Restricted to Polygons)": "Simple Filter (Restricted to Polygons)",
    "Sharpening Filter": "Sharpening Filter",
    "Fast Representativeness": "Fast Representativeness",
    "Focal Statistics": "Focal Statistics",
    "Representativeness (Grid)": "Representativeness (Raster)",
    "Radius of Variance (Grid)": "Radius of Variance (Raster)",
    "Statistics for Grids": "Statistics for Rasters",
    "Zonal Grid Statistics": "Zonal Raster Statistics",
    "Directional Statistics for Single Grid": "Directional Statistics for Single Raster",
    "Global Morans I for Grids": "Global Morans I for Rasters",
    "Principal Component Analysis": "Principal Component Analysis",
    "Multi-Band Variation": "Multi-Band Variation",
    "Inverse Principal Components Rotation": "Inverse Principal Components Rotation",
    "Longitudinal Grid Statistics": "Longitudinal Raster Statistics",
    "Meridional Grid Statistics": "Meridional Raster Statistics",
    "Save Grid Statistics to Table": "Save Raster Statistics to Table",
    "Categorical Coincidence": "Categorical Coincidence",
    "Focal PCA on a Grid": "Focal PCA on a Raster",
    "Unique Value Statistics for Grids": "Unique Value Statistics for Rasters",
    "Geocoding": "Geocoding",
    "Slope, Aspect, Curvature": "Slope, Aspect, Curvature",
    "Convergence Index": "Convergence Index",
    "Convergence Index (Search Radius)": "Convergence Index (Search Radius)",
    "Surface Specific Points": "Surface Specific Points",
    "Curvature Classification": "Curvature Classification",
    "Hypsometry": "Hypsometry",
    "Real Surface Area": "Real Surface Area",
    "Morphometric Protection Index": "Morphometric Protection Index",
    "Multiresolution Index of Valley Bottom Flatness (MRVBF)": "Multiresolution Index of Valley Bottom Flatness (MRVBF)",
    "Downslope Distance Gradient": "Downslope Distance Gradient",
    "Mass Balance Index": "Mass Balance Index",
    "Effective Air Flow Heights": "Effective Air Flow Heights",
    "Diurnal Anisotropic Heat": "Diurnal Anisotropic Heat",
    "Land Surface Temperature (Lapse Rates)": "Land Surface Temperature (Lapse Rates)",
    "Relative Heights and Slope Positions": "Relative Heights and Slope Positions",
    "Wind Effect (Windward / Leeward Index)": "Wind Effect (Windward / Leeward Index)",
    "Terrain Ruggedness Index (TRI)": "Terrain Ruggedness Index (TRI)",
    "Vector Ruggedness Measure (VRM)": "Vector Ruggedness Measure (VRM)",
    "Topographic Position Index (TPI)": "Topographic Position Index (TPI)",
    "TPI Based Landform Classification": "TPI Based Landform Classification",
    "Terrain Surface Texture": "Terrain Surface Texture",
    "Terrain Surface Convexity": "Terrain Surface Convexity",
    "Terrain Surface Classification (Iwahashi and Pike)": "Terrain Surface Classification (Iwahashi and Pike)",
    "Morphometric Features": "Morphometric Features",
    "Valley and Ridge Detection (Top Hat Approach)": "Valley and Ridge Detection (Top Hat Approach)",
    "Fuzzy Landform Element Classification": "Fuzzy Landform Element Classification",
    "Upslope and Downslope Curvature": "Upslope and Downslope Curvature",
    "Wind Exposition Index": "Wind Exposition Index",
    "Multi-Scale Topographic Position Index (TPI)": "Multi-Scale Topographic Position Index (TPI)",
    "Wind Shelter Index": "Wind Shelter Index",
    "Merge Layers": "Merge Layers",
    "Select by Attributes... (Numerical Expression)": "Select by Attributes... (Numerical Expression)",
    "Select by Attributes... (String Expression)": "Select by Attributes... (String Expression)",
    "Select by Location...": "Select by Location...",
    "Copy Selection to New Shapes Layer": "Copy Selection to New Features Layer",
    "Delete Selection from Shapes Layer": "Delete Selection from Features Layer",
    "Invert Selection of Shapes Layer": "Invert Selection of Features Layer",
    "Split Shapes Layer Completely": "Split Features Layer Completely",
    "Transform Shapes": "Transform Features",
    "Create Graticule": "Create Graticule",
    "Copy Shapes from Region": "Copy Features from Region",
    "Split Shapes Layer": "Split Features Layer",
    "Split Shapes Layer Randomly": "Split Features Layer Randomly",
    "Split Table/Shapes by Attribute": "Split Table/Features by Attribute",
    "Shapes Buffer": "Features Buffer",
    "Get Shapes Extents": "Get Features Extents",
    "QuadTree Structure to Shapes": "QuadTree Structure to Features",
    "Polar to Cartesian Coordinates": "Polar to Cartesian Coordinates",
    "Generate Shapes": "Generate Features",
    "Convert Vertex Type (2D/3D)": "Convert Vertex Type (2D/3D)",
    "Merge Tables": "Merge Tables",
    "Land Use Scenario Generator": "Land Use Scenario Generator",
    "Select Shapes from List": "Select Features from List",
    "Remove Invalid Shapes": "Remove Invalid Features",
    "Copy Shapes": "Copy Features",
    "Focal Mechanism (Beachball Plots)": "Focal Mechanism (Beachball Plots)",
    "Gradient Lines from Points": "Gradient Lines from Points",
    "Grid Normalization": "Raster Normalization",
    "Grid Calculator": "Raster Calculator",
    "Grid Volume": "Raster Volume",
    "Grid Difference": "Raster Difference",
    "Function Plotter": "Function Plotter",
    "Geometric Figures": "Geometric Figures",
    "Random Terrain": "Random Terrain",
    "Random Field": "Random Field",
    "Grids Sum": "Rasters Sum",
    "Grids Product": "Rasters Product",
    "Grid Standardization": "Raster Standardization",
    "Fuzzify": "Fuzzify",
    "Fuzzy Intersection (AND)": "Fuzzy Intersection (AND)",
    "Fuzzy Union (OR)": "Fuzzy Union (OR)",
    "Metric Conversions": "Metric Conversions",
    "Gradient Vector from Cartesian to Polar Coordinates": "Gradient Vector from Cartesian to Polar Coordinates",
    "Gradient Vector from Polar to Cartesian Coordinates": "Gradient Vector from Polar to Cartesian Coordinates",
    "Fractal Brownian Noise": "Fractal Brownian Noise",
    "Grid Division": "Raster Division",
    "Histogram Matching": "Histogram Matching",
    "Flat Detection": "Flat Detection",
    "Sink Drainage Route Detection": "Sink Drainage Route Detection",
    "Sink Removal": "Sink Removal",
    "Fill Sinks (Planchon/Darboux, 2001)": "Fill Sinks (Planchon/Darboux, 2001)",
    "Fill Sinks (Wang & Liu)": "Fill Sinks (Wang & Liu)",
    "Fill Sinks XXL (Wang & Liu)": "Fill Sinks XXL (Wang & Liu)",
    "Burn Stream Network into DEM": "Burn Stream Network into DEM",
    "Breach Depressions": "Breach Depressions",
    "GPX to shapefile": "GPX to shapefile",
    "GPSBabel": "GPSBabel",
    "Channel Network": "Channel Network",
    "Watershed Basins": "Watershed Basins",
    "Watershed Basins (Extended)": "Watershed Basins (Extended)",
    "Vertical Distance to Channel Network": "Vertical Distance to Channel Network",
    "Overland Flow Distance to Channel Network": "Overland Flow Distance to Channel Network",
    "Channel Network and Drainage Basins": "Channel Network and Drainage Basins",
    "Strahler Order": "Strahler Order",
    "Valley Depth": "Valley Depth",
    "Grid Skeletonization": "Raster Skeletonization",
    "Seed Generation": "Seed Generation",
    "Seeded Region Growing": "Seeded Region Growing",
    "Superpixel Segmentation": "Superpixel Segmentation",
    "Connected Component Labeling": "Connected Component Labeling",
    "Analytical Hillshading": "Analytical Hillshading",
    "Potential Incoming Solar Radiation": "Potential Incoming Solar Radiation",
    "Sky View Factor": "Sky View Factor",
    "Topographic Openness": "Topographic Openness",
    "Visibility Analysis": "Visibility Analysis",
    "Geomorphons": "Geomorphons",
    "Shapes to Grid": "Features to Raster",
    "Inverse Distance Weighted": "Inverse Distance Weighted",
    "Nearest Neighbour": "Nearest Neighbour",
    "Natural Neighbour": "Natural Neighbour",
    "Modifed Quadratic Shepard": "Modifed Quadratic Shepard",
    "Triangulation": "Triangulation",
    "Kernel Density Estimation": "Kernel Density Estimation",
    "Angular Distance Weighted": "Angular Distance Weighted",
    "Grid Cell Area Covered by Polygons": "Raster Cell Area Covered by Polygons",
    "Polygons to Grid": "Polygons to Raster",
    "Polygon Categories to Grid": "Polygon Categories to Raster",
    "Flow Accumulation (Top-Down)": "Flow Accumulation (Top-Down)",
    "Flow Accumulation (Recursive)": "Flow Accumulation (Recursive)",
    "Flow Accumulation (Flow Tracing)": "Flow Accumulation (Flow Tracing)",
    "Upslope Area": "Upslope Area",
    "Flow Path Length": "Flow Path Length",
    "Slope Length": "Slope Length",
    "Cell Balance": "Cell Balance",
    "Edge Contamination": "Edge Contamination",
    "SAGA Wetness Index": "SAGA Wetness Index",
    "Flow Width and Specific Catchment Area": "Flow Width and Specific Catchment Area",
    "Topographic Wetness Index (TWI)": "Topographic Wetness Index (TWI)",
    "Stream Power Index": "Stream Power Index",
    "LS Factor": "LS Factor",
    "Melton Ruggedness Number": "Melton Ruggedness Number",
    "TCI Low": "TCI Low",
    "LS-Factor, Field Based": "LS-Factor, Field Based",
    "Slope Limited Flow Accumulation": "Slope Limited Flow Accumulation",
    "Maximum Flow Path Length": "Maximum Flow Path Length",
    "Flow between fields": "Flow between fields",
    "Flow Accumulation (Parallelizable)": "Flow Accumulation (Parallelizable)",
    "Isochrones Variable Speed": "Isochrones Variable Speed",
    "CIT Index": "CIT Index",
    "Terrain Flooding": "Terrain Flooding",
    "Morphological Filter (OpenCV)": "Morphological Filter (OpenCV)",
    "Single Value Decomposition (OpenCV)": "Single Value Decomposition (OpenCV)",
    "Stereo Match (OpenCV)": "Stereo Match (OpenCV)",
    "Normal Bayes Classification": "Normal Bayes Classification",
    "K-Nearest Neighbours Classification": "K-Nearest Neighbours Classification",
    "Support Vector Machine Classification": "Support Vector Machine Classification",
    "Decision Tree Classification": "Decision Tree Classification",
    "Boosting Classification": "Boosting Classification",
    "Random Forest Classification": "Random Forest Classification",
    "Artificial Neural Network Classification": "Artificial Neural Network Classification",
    "Logistic Regression Classification": "Logistic Regression Classification",
    "Inverse Fourier Transformation": "Inverse Fourier Transformation",
    "Frequency Domain Filter": "Frequency Domain Filter",
    "Canny Edge Detection": "Canny Edge Detection",
    "Hough Circle Transformation": "Hough Circle Transformation",
    "Watershed Image Segmentation": "Watershed Image Segmentation",
    "Variogram": "Variogram",
    "Variogram Cloud": "Variogram Cloud",
    "Minimum Distance Analysis": "Minimum Distance Analysis",
    "Spatial Point Pattern Analysis": "Spatial Point Pattern Analysis",
    "Import Grids from KML": "Import Rasters from KML",
    "Warping Shapes": "Warping Features",
    "Direct Georeferencing of Airborne Photographs": "Direct Georeferencing of Airborne Photographs",
    "Define Georeference for Grids": "Define Georeference for Rasters",
    "World File from Flight and Camera Settings": "World File from Flight and Camera Settings",
    "Georeference with Coordinate Grids": "Georeference with Coordinate Rasters",
    "Regression Analysis (Points and Predictor Grid)": "Regression Analysis (Points and Predictor Raster)",
    "Multiple Regression Analysis (Points and Predictor Grids)": "Multiple Regression Analysis (Points and Predictor Rasters)",
    "Polynomial Regression": "Polynomial Regression",
    "GWR for Single Predictor (Gridded Model Output)": "GWR for Single Predictor (Rasterded Model Output)",
    "GWR for Single Predictor Grid": "GWR for Single Predictor Raster",
    "GWR for Multiple Predictors (Gridded Model Output)": "GWR for Multiple Predictors (Rasterded Model Output)",
    "GWR for Multiple Predictor Grids": "GWR for Multiple Predictor Rasters",
    "GWR for Multiple Predictors (Shapes)": "GWR for Multiple Predictors (Features)",
    "Multiple Regression Analysis (Grid and Predictor Grids)": "Multiple Regression Analysis (Raster and Predictor Rasters)",
    "Trend Analysis": "Trend Analysis",
    "Trend Analysis (Shapes)": "Trend Analysis (Features)",
    "Multiple Linear Regression Analysis (Table)": "Multiple Linear Regression Analysis (Table)",
    "Multiple Linear Regression Analysis (Shapes)": "Multiple Linear Regression Analysis (Features)",
    "GWR for Grid Downscaling": "GWR for Raster Downscaling",
    "Zonal Multiple Regression Analysis (Points and Predictor Grids)": "Zonal Multiple Regression Analysis (Points and Predictor Rasters)",
    "Basic Terrain Analysis": "Basic Terrain Analysis",
    "CliffMetrics": "CliffMetrics",
    "Coastal Profile Crossings": "Coastal Profile Crossings",
    "Supervised Image Classification": "Supervised Image Classification",
    "K-Means Clustering for Grids": "K-Means Clustering for Rasters",
    "Confusion Matrix (Two Grids)": "Confusion Matrix (Two Rasters)",
    "Decision Tree": "Decision Tree",
    "Confusion Matrix (Polygons / Grid)": "Confusion Matrix (Polygons / Raster)",
    "Export ESRI Arc/Info Grid": "Export ESRI Arc/Info Raster",
    "Export Surfer Grid": "Export Surfer Raster",
    "Export Grid to XYZ": "Export Raster to XYZ",
    "Import USGS SRTM Grid": "Import USGS SRTM Raster",
    "Export True Color Bitmap": "Export True Color Bitmap",
    "Import Erdas LAN/GIS": "Import Erdas LAN/GIS",
    "Import WRF Geogrid Binary Format": "Import WRF Geogrid Binary Format",
    "Export WRF Geogrid Binary Format": "Export WRF Geogrid Binary Format",
    "Import, Clip and Resample Grids": "Import, Clip and Resample Rasters",
    "Import CRU Grids": "Import CRU Rasters",
    "Import Point Cloud": "Import Point Cloud",
    "Export LAS/LAZ File": "Export LAS/LAZ File",
    "Transect through polygon shapefile": "Transect through polygon shapefile",
    "SVM Classification": "SVM Classification",
    "Thin Plate Spline": "Thin Plate Spline",
    "Thin Plate Spline (TIN)": "Thin Plate Spline (TIN)",
    "B-Spline Approximation": "B-Spline Approximation",
    "Multilevel B-Spline": "Multilevel B-Spline",
    "Multilevel B-Spline from Grid Points": "Multilevel B-Spline from Raster Points",
    "Cubic Spline Approximation": "Cubic Spline Approximation",
    "Multilevel B-Spline for Categories": "Multilevel B-Spline for Categories",
    "Earths Orbital Parameters": "Earths Orbital Parameters",
    "Annual Course of Daily Insolation": "Annual Course of Daily Insolation",
    "Daily Insolation over Latitude": "Daily Insolation over Latitude",
    "Monthly Global by Latitude": "Monthly Global by Latitude",
    "Evapotranspiration (Table)": "Evapotranspiration (Table)",
    "Daily to Hourly Evapotranspiration": "Daily to Hourly Evapotranspiration",
    "Evapotranspiration (Grid)": "Evapotranspiration (Raster)",
    "Sunrise and Sunset": "Sunrise and Sunset",
    "Bioclimatic Variables": "Bioclimatic Variables",
    "Tree Growth Season": "Tree Growth Season",
    "Wind Effect Correction": "Wind Effect Correction",
    "Frost Change Frequency": "Frost Change Frequency",
    "Thermic Belt Classification": "Thermic Belt Classification",
    "Snow Cover": "Snow Cover",
    "Growing Degree Days": "Growing Degree Days",
    "Climate Classification": "Climate Classification",
    "PhenIps (Table)": "PhenIps (Table)",
    "PhenIps (Grids, Annual)": "PhenIps (Rasters, Annual)",
    "PhenIps (Grids, Days)": "PhenIps (Rasters, Days)",
    "Soil Water Balance (Days)": "Soil Water Balance (Days)",
    "Cloud Overlap": "Cloud Overlap",
    "Temperature Lapse Rates": "Temperature Lapse Rates",
    "Air Pressure Adjustment": "Air Pressure Adjustment",
    "Land Surface Temperature": "Land Surface Temperature",
    "Air Humidity Conversions": "Air Humidity Conversions",
    "Lapse Rate Based Temperature Downscaling": "Lapse Rate Based Temperature Downscaling",
    "Daily Solar Radiation": "Daily Solar Radiation",
    "Convert Table to Points": "Convert Table to Points",
    "Count Points in Polygons": "Count Points in Polygons",
    "Create Point Grid": "Create Point Raster",
    "Point to Point Distances": "Point to Point Distances",
    "Populate Polygons with Points": "Populate Polygons with Points",
    "Convert Line/Polygon Vertices to Points": "Convert Line/Polygon Vertices to Points",
    "Add Coordinates to Points": "Add Coordinates to Points",
    "Remove Duplicate Points": "Remove Duplicate Points",
    "Clip Points with Polygons": "Clip Points with Polygons",
    "Separate points by direction": "Separate points by direction",
    "Add Polygon Attributes to Points": "Add Polygon Attributes to Points",
    "Points Filter": "Points Filter",
    "Convex Hull": "Convex Hull",
    "Point Thinning": "Point Thinning",
    "Convert Multipoints to Points": "Convert Multipoints to Points",
    "Thiessen Polygons": "Thiessen Polygons",
    "Aggregate Point Observations": "Aggregate Point Observations",
    "Snap Points to Points": "Snap Points to Points",
    "Snap Points to Lines": "Snap Points to Lines",
    "Snap Points to Grid": "Snap Points to Raster",
    "Create Random Points": "Create Random Points",
    "Snap Points to Polygons": "Snap Points to Polygons",
    "3D Points Selection": "3D Points Selection",
    "Point to Line Distances": "Point to Line Distances",
    "Create Virtual Point Cloud Dataset": "Create Virtual Point Cloud Dataset",
    "Get Subset from Virtual Point Cloud": "Get Subset from Virtual Point Cloud",
    "Create Tileshape from Virtual Point Cloud": "Create Tileshape from Virtual Point Cloud",
    "Get Grid from Virtual Point Cloud": "Get Raster from Virtual Point Cloud",
    "Remove Overlap from Virtual Point Cloud Tiles": "Remove Overlap from Virtual Point Cloud Tiles",
    "Set Coordinate Reference System": "Set Coordinate Reference System",
    "Coordinate Transformation (Shapes List)": "Coordinate Transformation (Features List)",
    "Coordinate Transformation (Shapes)": "Coordinate Transformation (Features)",
    "Coordinate Transformation (Grid List)": "Coordinate Transformation (Raster List)",
    "Coordinate Transformation (Grid)": "Coordinate Transformation (Raster)",
    "Change Longitudinal Range for Grids": "Change Longitudinal Range for Rasters",
    "Latitude/Longitude Graticule": "Latitude/Longitude Graticule",
    "Coordinate Reference System Picker": "Coordinate Reference System Picker",
    "Tissots Indicatrix": "Tissots Indicatrix",
    "Geographic Coordinate Grids": "Geographic Coordinate Rasters",
    "Rotated to Regular Grid": "Rotated to Regular Raster",
    "Geographic Distances": "Geographic Distances",
    "Geographic Distances (Pair of Coordinates)": "Geographic Distances (Pair of Coordinates)",
    "UTM Projection (Grid List)": "UTM Projection (Raster List)",
    "UTM Projection (Grid)": "UTM Projection (Raster)",
    "UTM Projection (Shapes List)": "UTM Projection (Features List)",
    "UTM Projection (Shapes)": "UTM Projection (Features)",
    "Single Coordinate Transformation": "Single Coordinate Transformation",
    "Coordinate Conversion (Grids)": "Coordinate Conversion (Rasters)",
    "Coordinate Conversion (Table)": "Coordinate Conversion (Table)",
    "Smoothing (ViGrA)": "Smoothing (ViGrA)",
    "Edge Detection (ViGrA)": "Edge Detection (ViGrA)",
    "Morphological Filter (ViGrA)": "Morphological Filter (ViGrA)",
    "Distance (ViGrA)": "Distance (ViGrA)",
    "Watershed Segmentation (ViGrA)": "Watershed Segmentation (ViGrA)",
    "Fourier Transform (ViGrA)": "Fourier Transform (ViGrA)",
    "Fourier Transform Inverse (ViGrA)": "Fourier Transform Inverse (ViGrA)",
    "Fourier Filter (ViGrA)": "Fourier Filter (ViGrA)",
    "Random Forest Classification (ViGrA)": "Random Forest Classification (ViGrA)",
    "Random Forest Presence Prediction (ViGrA)": "Random Forest Presence Prediction (ViGrA)",
    "Random Forest Table Classification (ViGrA)": "Random Forest Table Classification (ViGrA)",
    "Summit Extraction": "Summit Extraction",
    "Terrain Segmentation": "Terrain Segmentation",
    "Terrain Clustering": "Terrain Clustering",
    "Local Climate Zone Classification": "Local Climate Zone Classification",
    "Supervised Majority Choice Image Classification": "Supervised Majority Choice Image Classification",
    "Simple Filter for Multiple Grids": "Simple Filter for Multiple Rasters",
    "Sieve and Clump": "Sieve and Clump",
    "Notch Filter for Grids": "Notch Filter for Rasters",
    "LS Factor (One Step)": "LS Factor (One Step)",
    "Upslope Height, Slope, Aspect": "Upslope Height, Slope, Aspect",
    "Flow Accumulation (One Step)": "Flow Accumulation (One Step)",
    "Topographic Wetness Index (One Step)": "Topographic Wetness Index (One Step)",
    "Contour Lines from Points": "Contour Lines from Points",
    "Select and Delete": "Select and Delete",
    "Object Based Image Segmentation": "Object Based Image Segmentation",
    "Directional Grid Statistics": "Directional Raster Statistics",
    "Land Cover Scenario Offset": "Land Cover Scenario Offset",
    "Travel Time Calculation": "Travel Time Calculation",
    "Import Text Tables": "Import Text Tables",
    "Largest Circles in Polygons": "Largest Circles in Polygons",
    "Remove Boundary Polygons": "Remove Boundary Polygons",
    "Grid Values and Polygon Attributes to Points": "Raster Values and Polygon Attributes to Points",
    "Change a Grids No-Data Value [Bulk Processing]": "Change a Raster"
    "s No-Data Value [Bulk Processing]",
}


def decoratedAlgorithmName(name: str) -> str:
    """
    Returns a nice user friendly algorithm name instead of the raw SAGA name
    """
    return algorithms.get(name, name)
