# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PrgDig
                                 A QGIS plugin
 Template for PRG design
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-07-27
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Massimo Endrighi
        email                : prgdig@geopartner.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtGui import QStandardItemModel, QStandardItem
from qgis.PyQt import  QtWidgets
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt, QThreadPool
from qgis.PyQt.QtGui import QIcon, QBrush, QColor, QFont
from qgis.PyQt.QtWidgets import QAction, QMessageBox, QInputDialog 
from qgis.core import QgsRectangle, QgsProject, QgsMessageLog

# Initialize Qt resources from file resources.py
from .resources import *

import inspect,time
import os
import sqlite3
import time
import json

# Import the code for the DockWidget
from .prg_dig_dockwidget import PrgDigDockWidget
from .Worker import Worker
#from .WorkerSignals import WorkerSignals
from .CallBackInfo import CallBackInfo


class PrgDig:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'PrgDig_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&PrgDig')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'PrgDig')
        self.toolbar.setObjectName(u'PrgDig')

        #print "** INITIALIZING PrgDig"

        self.pluginIsActive = False
        self.dockwidget = None


    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('PrgDig', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToVectorMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action


    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/prg_dig/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'PrgDig check'),
            callback=self.run,
            parent=self.iface.mainWindow())

    #--------------------------------------------------------------------------

    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""

        #print "** CLOSING PrgDig"

        # disconnects
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)

        self.iface.newProjectCreated.disconnect(self.newProjectCreated)
        self.iface.projectRead.disconnect(self.projectRead)

        self.dockwidget.selectAllRulesPushButton.clicked.disconnect(self.selectAllRules)
        self.dockwidget.unselectAllRulesPushButton.clicked.disconnect(self.unselectAllRules)

         # connessione eventi UI
        self.dockwidget.treeWidget.itemChanged.disconnect(self.iterItemChanged)
        self.dockwidget.treeWidget.currentItemChanged.disconnect(self.currentIterItemChanged)

        # polygon error handling
        self.dockwidget.zoomPolyErrorPushButton.clicked.disconnect(self.zoomGeom)
        
        self.dockwidget.zoomPoly1PushButton.clicked.disconnect(self.zoomGeom1)
        self.dockwidget.fixPoly1PushButton.clicked.disconnect(self.fixGeom1)

        self.dockwidget.zoomPoly2PushButton.clicked.disconnect(self.zoomGeom2)
        self.dockwidget.fixPoly2PushButton.clicked.disconnect(self.fixGeom2)

        # line error handling
        self.dockwidget.zoomLineErrorPushButton.clicked.disconnect(self.zoomGeom)
        self.dockwidget.zoomLine1PushButton.clicked.disconnect(self.zoomGeom1)
        self.dockwidget.fixLine1PushButton.clicked.disconnect(self.fixGeom1)

        self.dockwidget.zoomLine2PushButton.clicked.disconnect(self.zoomGeom2)
        self.dockwidget.fixLine2PushButton.clicked.disconnect(self.fixGeom2)

        # point error handling
        self.dockwidget.zoomPointErrorPushButton.clicked.disconnect(self.zoomGeom)
        self.dockwidget.zoomPoint1PushButton.clicked.disconnect(self.zoomGeom1)
        self.dockwidget.fixPoint1PushButton.clicked.disconnect(self.fixGeom1)

        self.dockwidget.zoomPoint2PushButton.clicked.connect(self.zoomGeom2)
        self.dockwidget.fixPoint2PushButton.clicked.disconnect(self.fixGeom2)

        # validation button
        self.dockwidget.startValidationPushButton.clicked.disconnect(self.startValidationButtonClicked)

        # cambio tab (validazione,errori ignorati, navigatore dati)
        self.dockwidget.tabWidget.currentChanged.disconnect(self.tabChanged)

        self.dockwidget.ignoreAttributeErrorPushButton.clicked.disconnect(self.ignoreCurrentError)
        self.dockwidget.ignorePolyErrorPushButton.clicked.disconnect(self.ignoreCurrentError)
        self.dockwidget.ignoreLineErrorPushButton.clicked.disconnect(self.ignoreCurrentError)
        self.dockwidget.ignorePointErrorPushButton.clicked.disconnect(self.ignoreCurrentError)
        self.dockwidget.removeIgnoredErrorPushButton.clicked.disconnect(self.removeIgnoredErrorPushButton)
      
        try: 
            # il segnale potrebbe non essere connesso
            self.dockwidget.ignoredErrorsTableView.horizontalHeader().sectionResized.disconnect(self.sectionResized)
        except:
            pass

        # remove this statement if dockwidget is to remain
        # for reuse if plugin is reopened
        # Commented next statement since it causes QGIS crashe
        # when closing the docked window:
        # self.dockwidget = None

        self.pluginIsActive = False


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""

        #print "** UNLOAD PrgDig"

        for action in self.actions:
            self.iface.removePluginVectorMenu(
                self.tr(u'&PrgDig'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    #--------------------------------------------------------------------------

    def run(self):
        """Run method that loads and starts the plugin"""

        if not self.pluginIsActive:
            self.pluginIsActive = True

            #print "** STARTING PrgDig"

            # dockwidget may not exist if:
            #    first run of plugin
            #    removed on close (see self.onClosePlugin method)
            if self.dockwidget == None:
                # Create the dockwidget (after translation) and keep reference
                self.dockwidget = PrgDigDockWidget()
                self.dockwidget.Out_RuleReportAttributesGroupBox.setVisible(False)
                self.dockwidget.Out_RuleReportPolyGroupBox.setVisible(False)
                self.dockwidget.Out_RuleReportLineGroupBox.setVisible(False)
                self.dockwidget.Out_RuleReportPointGroupBox.setVisible(False)

            # connect to provide cleanup on closing of dockwidget
            self.dockwidget.closingPlugin.connect(self.onClosePlugin)

            # show the dockwidget
            # TODO: fix to allow choice of dock location
            self.dockwidget.show()
            self.iface.addDockWidget(Qt.RightDockWidgetArea, self.dockwidget)

            # N.B. senza blocco try gli erroi non vengono visualizzati
            try:                
                self.initialize()
            except Exception as e:
                QgsMessageLog.logMessage('Unexpected error in function run: ' + str(e))

    #--------------------------------------------------------------------------
    # custom code
    #--------------------------------------------------------------------------

    def initialize(self):
      
        self.callStack = []

        # variabile che indica se è in corso una validazione
        self.validating = False

        # thread pool che esegue il thred di validazione per non bloccare la UI
        self.threadpool = QThreadPool()

        self.strikeOutFont = QFont()
        self.strikeOutFont.setStrikeOut(True)

        # nome del file spatialite collegato al progetto
        self.spatialiteTemplateName = QgsProject.instance().readPath("./") + '/' + QgsProject.instance().baseName() + '.sqlite'

        # nasconde le progress bar che verranno visualizzate quando si attiva la validazione
        self.dockwidget.iterProgressBar.setVisible(False)
        self.dockwidget.ruleProgressBar.setVisible(False)

         # configurazioen del tree di visualizzazione errori
        self.dockwidget.treeWidget.setColumnCount(2)
        self.dockwidget.treeWidget.setHeaderLabels(['Regola',"Errori"])
        # configure header https://doc.qt.io/qt-5/qheaderview.html
        self.dockwidget.treeWidget.header().setStretchLastSection(False)
        # Stretch
        self.dockwidget.treeWidget.header().setSectionResizeMode(0,1)
        # ResizeToContents
        self.dockwidget.treeWidget.header().setSectionResizeMode(1,3)

         # connessione eventi di cambio progetto
        self.iface.newProjectCreated.connect(self.newProjectCreated)
        self.iface.projectRead.connect(self.projectRead)

        self.dockwidget.selectAllRulesPushButton.clicked.connect(self.selectAllRules)
        self.dockwidget.unselectAllRulesPushButton.clicked.connect(self.unselectAllRules)

         # connessione eventi UI
        self.dockwidget.treeWidget.itemChanged.connect(self.iterItemChanged)
        self.dockwidget.treeWidget.currentItemChanged.connect(self.currentIterItemChanged)

        # polygon error handling
        self.dockwidget.zoomPolyErrorPushButton.clicked.connect(self.zoomGeom)
        
        self.dockwidget.zoomPoly1PushButton.clicked.connect(self.zoomGeom1)
        self.dockwidget.fixPoly1PushButton.clicked.connect(self.fixGeom1)

        self.dockwidget.zoomPoly2PushButton.clicked.connect(self.zoomGeom2)
        self.dockwidget.fixPoly2PushButton.clicked.connect(self.fixGeom2)

        # line error handling
        self.dockwidget.zoomLineErrorPushButton.clicked.connect(self.zoomGeom)
        self.dockwidget.zoomLine1PushButton.clicked.connect(self.zoomGeom1)
        self.dockwidget.fixLine1PushButton.clicked.connect(self.fixGeom1)

        self.dockwidget.zoomLine2PushButton.clicked.connect(self.zoomGeom2)
        self.dockwidget.fixLine2PushButton.clicked.connect(self.fixGeom2)

        # point error handling
        self.dockwidget.zoomPointErrorPushButton.clicked.connect(self.zoomGeom)
        self.dockwidget.zoomPoint1PushButton.clicked.connect(self.zoomGeom1)
        self.dockwidget.fixPoint1PushButton.clicked.connect(self.fixGeom1)

        self.dockwidget.zoomPoint2PushButton.clicked.connect(self.zoomGeom2)
        self.dockwidget.fixPoint2PushButton.clicked.connect(self.fixGeom2)

        # validation button
        self.dockwidget.startValidationPushButton.clicked.connect(self.startValidationButtonClicked)

        # cambio tab (validazione,errori ignorati, navigatore dati)
        self.dockwidget.tabWidget.currentChanged.connect(self.tabChanged)

        self.dockwidget.ignoreAttributeErrorPushButton.clicked.connect(self.ignoreCurrentError)
        self.dockwidget.ignorePolyErrorPushButton.clicked.connect(self.ignoreCurrentError)
        self.dockwidget.ignoreLineErrorPushButton.clicked.connect(self.ignoreCurrentError)
        self.dockwidget.ignorePointErrorPushButton.clicked.connect(self.ignoreCurrentError)
        self.dockwidget.removeIgnoredErrorPushButton.clicked.connect(self.removeIgnoredErrorPushButton)
      
        if not self.canExecute():
            return;

        self.caricaTemplate()
        self.dockwidget.ignoredErrorsTableView.horizontalHeader().sectionResized.connect (self.sectionResized)

    def canExecute(self):
        if os.path.isfile(self.spatialiteTemplateName) == False:
            # il plugin non può essere usato senza un template valido
            QgsMessageLog.logMessage('Plugin disabilitato causa mancanza del file template')
            self.dockwidget.tabWidget.setEnabled(False)
            return False

        conn = self.getConnection()
        prj_version :str = ''
        try:
            result = conn.execute('SELECT DBVersion FROM VersionInfo').fetchone()
            prj_version = result['DBVersion']
            if prj_version <= '1.2.0.0':
                QMessageBox.critical(None,'Prg_dig','Plugin disabilitato. La versione ({}) del progetto è incompatibile con il plugin'.format(prj_version))
                return False

        except Exception as e:
            QMessageBox.critical(None,'Prg_dig','Plugin disabilitato. La versione del database del progetto non è determinabile ' + str(e))
            self.dockwidget.tabWidget.setEnabled(False)
            return False
        finally:
            conn.close()
        return True

    def removeIgnoredErrorPushButton(self):
        self.logFunctionStart()
        if QMessageBox.question(None,'Errori Ignorati','Confermi il ripristiono degli errori ignorati selezionati?') != QMessageBox.Yes:
            self.logFunctionEnd()
            return

        model = self.dockwidget.ignoredErrorsTableView.model()

        conn = self.getConnection()
        for selectedRow in self.dockwidget.ignoredErrorsTableView.selectionModel().selectedRows():
            oid = model.item(selectedRow.row(),0).text()
            result = conn.execute('SELECT Oid, Out_RuleReportTableName, OidRegola, OidGeom1, OidGeom2, OidGeometry, OidAttributo FROM ErroriIgnorati WHERE Oid=' + oid).fetchone()
            
            tableName = result['Out_RuleReportTableName']
            if tableName == 'Out_RuleReportAttributes':
                oidErrore = conn.execute('SELECT Oid FROM ' + tableName + ' WHERE OidRegola = ? AND OidGeometry = ? AND OidAttributo = ?',
                (result['OidRegola'],result['OidGeometry'],result['OidAttributo'])).fetchone()[0]
            else:
                oidErrore = conn.execute('SELECT Oid FROM ' + tableName + ' WHERE OidRegola = ? AND OidGeom1 = ? AND OidGeom2 = ?',
                (result['OidRegola'],result['OidGeom1'],result['OidGeom2'])).fetchone()[0]

            # aggiornamento dell'errore ignorato sul tree delle regole di validazione
            topLevelItem = self.dockwidget.treeWidget.topLevelItem(0)
            ruleItem = self.findItem(topLevelItem,'Rule',result['OidRegola'])

            for i in range(ruleItem.childCount()):
                errorItem = ruleItem.child(i)
                if errorItem.data(0,Qt.UserRole).startswith(tableName + ';' + str(oidErrore)):
                    errorItem.setData(0,Qt.FontRole,QFont())
                    break

            conn.execute('DELETE FROM ErroriIgnorati WHERE Oid=' + oid)

        conn.commit()
        conn.close()

        # simula cambio tab per ricaricare elenco errori ignorati
        self.tabChanged(1)

        self.logFunctionEnd()

    def ignoredErrorsSelectionChanged(self,selected,deselected):
        self.logFunctionStart()
        if len(self.dockwidget.ignoredErrorsTableView.selectionModel().selectedRows()) > 0:
            self.dockwidget.removeIgnoredErrorPushButton.setEnabled(True)
        else:
            self.dockwidget.removeIgnoredErrorPushButton.setEnabled(False)
        self.logFunctionEnd()

    def logFunctionStart(self,message=''):
        funcInfo = (time.time(),inspect.stack()[1].function)
        self.callStack.append(funcInfo)
        QgsMessageLog.logMessage('>' * len(self.callStack) + inspect.stack()[1].function + message)

    def logFunctionEnd(self):
        endTime = time.time()
        stackDepth = len(self.callStack)
        if stackDepth >= 1:
            funcInfo = self.callStack.pop()
            elapsed = endTime -  funcInfo[0]
            QgsMessageLog.logMessage('<' * stackDepth + inspect.stack()[1].function + ' (' + str(elapsed) + ')')
        else:
            raise Exception('Mancata corrispondenza di chiamata delle funzioni logFunctionStart/End')
        
    def currentIgnoredErrorChanged(self,currentModelIndex,previousModelIndex):
        self.logFunctionStart()

        if currentModelIndex == None:
            return

        topLevelItem = self.dockwidget.treeWidget.topLevelItem(0)
        if topLevelItem == None:
            return

        model = self.dockwidget.ignoredErrorsTableView.model()
        row = currentModelIndex.row()

        oid = model.item(row,0).text()
        tableName = model.item(row,1).text()
        oidRegola = model.item(row,2).text()
        oidGeom1 = model.item(row,3).text()
        oidGeom2 = model.item(row,4).text()
        oidGeometry = model.item(row,5).text()
        oidAttributo = model.item(row,6).text()
        conn = self.getConnection()
        query = ''
        if tableName == 'Out_RuleReportAttributes':
            query = 'SELECT Oid FROM ' + tableName + ' WHERE OidRegola=' + oidRegola + ' AND OidGeometry=' + oidGeometry + ' AND OidAttributo=' + oidAttributo
        else:
            query = 'SELECT Oid FROM ' + tableName + ' WHERE OidRegola=' + oidRegola + ' AND OidGeom1=' + oidGeom1 + ' AND OidGeom2=' + oidGeom2
                    
        result = conn.execute(query).fetchone()
        if result == None:
            QMessageBox.critical(None,'Errori Ignorati',"L'errore selezionato non è stato trovato nell'elenco degli errori." + os.linesep + 'Verrà rimosso anche da questa lista')
            conn.execute('DELETE FROM ErroriIgnorati WHERE Oid=' + oid)
            conn.commit()
            conn.close()
            # simula cambio tab per ricaricare elenco errori ignorati
            self.tabChanged(1)
            return

        conn.close()

        # sincronizzazione dell'errore ignorato con il tree delle regole di validazione
        errorOid = result[0]
        ruleItem = self.findItem(topLevelItem,'Rule',oidRegola)

        for i in range(ruleItem.childCount()):
            errorItem = ruleItem.child(i)
            if errorItem.data(0,Qt.UserRole).startswith(tableName + ';' + str(errorOid)):
                self.dockwidget.treeWidget.setCurrentItem(errorItem)
                break
        self.logFunctionEnd()
        
    def sectionResized(self):
        self.dockwidget.ignoredErrorsTableView.resizeRowsToContents()

    def poligonErrorsLayer(self):
        return QgsProject.instance().mapLayersByName('Errori_poligoni')[0]

    def projectRead(self):
        """Evento generato al caricamento di un progetto"""
        projectBaseName = QgsProject.instance().readPath("./") + '/' + QgsProject.instance().baseName()
        QgsMessageLog.logMessage('projectRead ' + projectBaseName)

        # nome del file spatialite collegato al progetto
        self.spatialiteTemplateName = projectBaseName + '.sqlite'

        # elimina eventuali dati caricati precedentemente
        self.dockwidget.treeWidget.clear()

        if not self.canExecute():
            return

        self.dockwidget.tabWidget.setEnabled(True)
        self.caricaTemplate()

    def ignoreCurrentError(self):
        """Evento generato dal pulsante per ignorare l'errore"""
        # per ignorare l'errore è necessario inserie una nota
        result = QInputDialog.getMultiLineText(None,'Ignora errore','Motivo')
        if result[1] != True:
            return;

        motivo = result[0].strip()
        if motivo == '':
            return

        conn = None
        try:         
            conn = self.getConnection()
            tableName = self.selectedError['TableName']
            command = 'INSERT OR REPLACE INTO ErroriIgnorati (Out_RuleReportTableName,OidRegola,OidGeom1,OidGeom2,OidGeometry,OidAttributo,Motivo) VALUES (?,?,?,?,?,?,?)'
            values = ()

            # I valori mancanti vengono forzati a 0 anziché lasciato a NULL per poter usufruire
            # della clausola INSERT OR REPLACE che permette all'utente di ignorare N volte l'errore
            # con lo scopo di aggiornare il motivo.
            # Questo meccanismo usa un indice univoco sui campi OidRegola,OidGeom1,OidGeom2,OidGeometry,OidAttributo
            # che vista la particolartià di SQLITE che tratta, in questo caso specifico, i NULL come valori distinti
            # allora è necessario mettere uno 0

            if tableName == 'Out_RuleReportAttributes':
                values = (tableName,self.selectedError['OidRegola'],0,0,self.selectedError['OidGeometry'],self.selectedError['OidAttributo'], motivo)
            else:
                values = (tableName,self.selectedError['OidRegola'],self.selectedError['OidGeom1'],self.selectedError['OidGeom2'],0,0, motivo)
            conn.execute (command,values)
            conn.commit()
            conn.close()

            currentItem = self.dockwidget.treeWidget.currentItem()
            currentItem.setData(0,Qt.FontRole,self.strikeOutFont)
        except Exception as e:
            if conn != None:
                conn.close()
            QMessageBox.critical(None,'Ignora errore','Si è verificato un errore imprevisto')
            QgsMessageLog.logMessage('Unexpected error in function ignoreCurrentError: ' + str(e))

    def newProjectCreated(self):
        """Evento generato in caso di cambio progetto"""
        # in questo caso il plugin non può funzionare perchè il file Template
        # viene identificato solo attraverso il nome del file di progetto
        QgsMessageLog.logMessage('newProjectCreated ' + QgsProject.instance().readPath("./"))
        self.dockwidget.treeWidget.clear()
        self.dockwidget.tabWidget.setEnabled(False)


    def getConnection(self, enableSpatialite = False):
        # https://docs.python.org/3/library/sqlite3.html
        conn = sqlite3.connect(self.spatialiteTemplateName)
        conn.row_factory = sqlite3.Row
        if enableSpatialite:
            conn.enable_load_extension(True)
            conn.load_extension('mod_spatialite')
        return conn
    
    def caricaTemplate(self):
        """Caricamento dei dati dal template"""

        # elimina eventuali dati caricati precedentemente
        self.dockwidget.treeWidget.clear()

        # connessione usata per caricare i dati
        try:
            conn = self.getConnection()
        except Exception as e:
            QMessageBox.critical(None,'PRG.DIG','Errore imprevisto nel caricamento del database template [' + self.spatialiteTemplateName + ']' + os.linesep + str(e))
            # il plugin non può essere usato senza un template valido
            return

        # caricamento del tree view con iter->regole->steps
        # ogni elemento è identificabile tramite 'objectType' + 'Oid' (es: 'Rule1')
        # visualizza tutte le regole di validazione e relativi eventuali errori
        iters = conn.execute('SELECT "Oid","Nome" FROM "IterValidazione"')
        for the_iter in iters.fetchall():
            QgsMessageLog.logMessage('Popolamento elenco regole per iter ' + the_iter['Nome'])
            iter_item = QtWidgets.QTreeWidgetItem([the_iter['Nome']])
            self.dockwidget.treeWidget.addTopLevelItem(iter_item)
            regole = conn.execute((
                'SELECT DISTINCT Regole.Oid,Regole.Nome,Regole.Esegui,Regole.EsecuzioneObbligatoria,Regole.OutReportTableName,TipiRegola.Nome AS TipoRegola,Regole.ErroriIgnorabili '
                'FROM ValidationSteps '
                'INNER JOIN Regole ON ValidationSteps.OidRegola = Regole.Oid '
                'INNER JOIN IterValidazione ON Regole.OidIter = IterValidazione.Oid '
                'INNER JOIN TipiRegola ON Regole.OidTipoRegola = TipiRegola.Oid '
                'WHERE IterValidazione.Oid = ' + str(the_iter['Oid'])))
            for regola in regole.fetchall():
                QgsMessageLog.logMessage('Popolamento elenco regole ' + regola['Nome'])
                regola_Item = QtWidgets.QTreeWidgetItem([regola['Nome']])
                regola_Item.setData(0,Qt.UserRole,'Rule' + ';' + str(regola['Oid']))
                if regola['EsecuzioneObbligatoria'] == 0:
                    regola_Item.setFlags(Qt.ItemIsSelectable | Qt.ItemIsEnabled | Qt.ItemIsUserCheckable)
                else:
                    regola_Item.setFlags(Qt.ItemIsSelectable | Qt.ItemIsEnabled)
                if regola['Esegui'] == 1 or regola['EsecuzioneObbligatoria'] == 1:
                     regola_Item.setCheckState(0, Qt.Checked)
                else:
                     regola_Item.setCheckState(0, Qt.Unchecked)
                iter_item.addChild(regola_Item)

                table = regola['OutReportTableName']
                if table == 'Out_RuleReportAttributes':
                    command = (
                        'SELECT t.Oid,TipoMessaggio,Messaggio, ee.oid IS NOT NULL AS ErroreIgnorato '
                        'FROM ' + table + ' t '
                        'LEFT JOIN ErroriIgnorati ee ON t.OidRegola = ee.OidRegola AND t.OidGeometry = ee.OidGeometry AND t.OidAttributo = ee.OidAttributo '
                        'WHERE t.OidRegola = ' + str(regola['Oid']))
                else:
                    command = (
                        'SELECT t.Oid,TipoMessaggio,Messaggio, ee.oid IS NOT NULL AS ErroreIgnorato '
                        'FROM ' + table + ' t '
                        'LEFT JOIN ErroriIgnorati ee ON t.OidRegola = ee.OidRegola AND t.OidGeom1 = ee.OidGeom1 AND t.OidGeom2 = ee.OidGeom2 '
                        'WHERE t.OidRegola = ' + str(regola['Oid']))
                errors = conn.execute(command).fetchall()
                if len(errors):
                    regola_Item.setData(0,Qt.ForegroundRole,QBrush(QColor('red')))
                    regola_Item.setText(1,str(len(errors)))
                    for error in errors:
                        error_Item = QtWidgets.QTreeWidgetItem([error['Messaggio']])
                        if error['TipoMessaggio'] == 'W':
                            error_Item.setData(0,Qt.ForegroundRole,QBrush(QColor('orange')))
                        if error['ErroreIgnorato']:
                            error_Item.setData(0,Qt.FontRole,self.strikeOutFont)
                        error_Item.setData(0,Qt.UserRole,table + ';' + str(error['Oid']) + ';' + str(regola['ErroriIgnorabili']) + ';' + str(error['ErroreIgnorato']))
                        regola_Item.addChild(error_Item)
                else:
                    regola_Item.setText(1,'')
                    regola_Item.setData(0,Qt.ForegroundRole,QBrush(QColor('green')))
            iter_item.setExpanded(True)
             
        conn.close()

    def tabChanged(self, tabIndex):
        """Gestisce il cambio tab (validazione,errori ignorati,navigatore dati)"""
        try:
            QgsMessageLog.logMessage('tabChanged (tabIndex=' + str(tabIndex) + ')')
            if tabIndex == 1:
                conn = self.getConnection()

                # caricamento degli errori ignorati
                queryString = (
                    'SELECT ee.Oid, ee.Out_RuleReportTableName, ee.OidRegola, ee.OidGeom1, ee.OidGeom2, ee.OidGeometry, ee.OidAttributo, Regole.Nome AS Regola, ee.Motivo '
                    'FROM ErroriIgnorati ee '
                    'INNER JOIN Regole ON Regole.Oid = ee.OidRegola')
                ignoredErrors = conn.execute(queryString).fetchall()
                
                # inserimento in un data model per la visualizzazione in griglia
                dataModel = QStandardItemModel (len(ignoredErrors),8)
                columnNames = ['Oid','Out_RuleReportTableName', 'OidRegola', 'OidGeom1', 'OidGeom2', 'OidGeometry', 'OidAttributo', 'Regola', 'Motivo']
                dataModel.setHorizontalHeaderLabels(columnNames)

                row = 0
                for ignoredError in ignoredErrors:
                    col = 0
                    for columnName in columnNames:
                        item = QStandardItem(str(ignoredError[columnName]))
                        dataModel.setItem(row,col,item)
                        col = col + 1
                    row = row + 1
                    
                self.dockwidget.ignoredErrorsTableView.setModel(dataModel)
                
                QgsMessageLog.logMessage(str(dataModel.rowCount()) + ' errori ignorati')
                
                selectionModel = self.dockwidget.ignoredErrorsTableView.selectionModel()
                selectionModel.currentChanged.connect(self.currentIgnoredErrorChanged)
                selectionModel.selectionChanged.connect(self.ignoredErrorsSelectionChanged)

                self.dockwidget.ignoredErrorsTableView.setColumnHidden(0, True)
                self.dockwidget.ignoredErrorsTableView.setColumnHidden(1, True)
                self.dockwidget.ignoredErrorsTableView.setColumnHidden(2, True)
                self.dockwidget.ignoredErrorsTableView.setColumnHidden(3, True)
                self.dockwidget.ignoredErrorsTableView.setColumnHidden(4, True)
                self.dockwidget.ignoredErrorsTableView.setColumnHidden(5, True)
                self.dockwidget.ignoredErrorsTableView.setColumnHidden(6, True)
                
                # https://doc.qt.io/qt-5/qheaderview.html#ResizeMode-enum
                self.dockwidget.ignoredErrorsTableView.horizontalHeader().setStretchLastSection(True)
                self.dockwidget.ignoredErrorsTableView.horizontalHeader().setSectionResizeMode(1)
                self.dockwidget.ignoredErrorsTableView.resizeRowsToContents()
                conn.close()
        except Exception as e:
            QgsMessageLog.logMessage('Unexpected error in function tabChanged: ' + str(e))

    def fixGeom1(self):
        QgsMessageLog.logMessage('fixGeom1')
        self.fixGeom(self.selectedError['FixGeom1SQLcommand'],self.selectedError['TableName'],self.selectedError['Oid'])

    def fixGeom2(self):
        QgsMessageLog.logMessage('fixGeom2')
        self.fixGeom(self.selectedError['FixGeom2SQLcommand'],self.selectedError['TableName'],self.selectedError['Oid'])

    def fixGeom(self,fixGeomSQLcommand,tableName,oid):
        QgsMessageLog.logMessage('fixGeom')
        if QMessageBox.question(None,self.selectedError['FixErrorMessage'],'Confermi la correzione automatica del seguente errore ?' + os.linesep + self.selectedError['Messaggio']) != QMessageBox.Yes:
            return
        conn = None

        try:
            conn = self.getConnection(True)
            conn.executescript(fixGeomSQLcommand)

            # cancellazion dell'errore
            conn.execute('DELETE FROM ' + tableName + ' WHERE Oid=' + str(oid))

            conn.commit()
            conn.close()

            # rimuove l'elemento corrente dalla lista ed aggiorna conteggio errori
            currentItem = self.dockwidget.treeWidget.currentItem()
            parent = currentItem.parent()
            parent.removeChild(currentItem)
            errorsCount = parent.childCount()
            if errorsCount == 0:
                parent.setText(1, None)
            else:
                parent.setText(1, str(errorsCount))

            # aggiorna la visualizzazione del layer degli errori
            self.poligonErrorsLayer().triggerRepaint()
            self.iface.mapCanvas().refresh()

        except Exception as e:
            if conn != None:
                conn.close()
            QgsMessageLog.logMessage('Unexpected error in function fixGeom: ' + str(e))
            QMessageBox.critical(None,self.selectedError['FixErrorMessage'],'Errore imprevisto nell''esecuzione del comando')

    def zoomGeom(self):
        """Zoom to selected error geometry"""
        QgsMessageLog.logMessage('zoomGeom')
        conn = self.getConnection(True)
        table = self.selectedError['TableName']
        oid = self.selectedError['Oid']
        zoomCoord = conn.execute((
            'SELECT '
                'MbrMinX(geom) AS XMin,'
                'MbrMinY(geom) AS YMin,'
                'MbrMaxX(geom) AS XMax,'
                'MbrMaxY(geom) AS YMax '
            'FROM ' + table + ' WHERE Oid = ' + str(oid))).fetchone()
        conn.close()
        self.zoomToError(table,zoomCoord,oid)

    def zoomGeom1(self):
        QgsMessageLog.logMessage('zoomGeom1')
        self.zoomGeometry(self.selectedError['OidArea1'],self.selectedError['OidGeom1'])

    def zoomGeom2(self):
        QgsMessageLog.logMessage('zoomGeom2')
        self.zoomGeometry(self.selectedError['OidArea2'],self.selectedError['OidGeom2'])

    def zoomGeometry(self, oidArea, oidGeom):
        QgsMessageLog.logMessage('zoomGeom')
        try:
            conn = self.getConnection()
            self.zoomToGeom(conn,oidArea,oidGeom)
            conn.close()
        except Exception as e:
            if conn != None:
                conn.close()
            QgsMessageLog.logMessage('Unexpected error in function zoomGeometry: ' + str(e))
            QMessageBox.critical(None,self.selectedError['FixErrorMessage'],'Errore imprevisto nell''esecuzione del comando')

    def startValidationButtonClicked(self):
        
        if QMessageBox.question(None,'Validazione','Confermi l\'esecuzione della validazione?') != QMessageBox.Yes:
           return

        topLevelItem = self.dockwidget.treeWidget.topLevelItem(0)
        if topLevelItem != None:
            self.dockwidget.treeWidget.setCurrentItem(topLevelItem)

        self.dockwidget.tabWidget.setDisabled(True)

        # Pass the function to execute
        self.validationFatalErrors = 0
        validateWorker = Worker(self.validate)
        validateWorker.signals.result.connect(self.print_output)
        validateWorker.signals.finished.connect(self.thread_complete)
        validateWorker.signals.progress.connect(self.progress_fn)
        validateWorker.signals.error.connect(self.print_error)
        
        self.dockwidget.iterProgressBar.setVisible(True)
        self.dockwidget.ruleProgressBar.setVisible(True)
        self.validating = True
        # Execute
        try:
            self.threadpool.start(validateWorker) 
        except:
            self.dockwidget.tabWidget.setDisabled(False)

    def currentIterItemChanged(self,currentItem,previousItem):
        """Aggiorna la visualizzazione dei dettagli dell'Errore"""
        
        QgsMessageLog.logMessage('currentIterItemChanged')
   
        if self.validating:
            return
        if currentItem == None:
            # currentItem could be None when clearing the tree
            return

        # userdata is a string in form "table name;error id;can ignore error"
        # for example Out_RuleReportPoly;123;1
        userData = currentItem.data(0,Qt.UserRole)
        if userData == None:
            return
        QgsMessageLog.logMessage('userData = ' + userData)
        conn = self.getConnection(True)

        tokens = userData.split(';')
        table = tokens[0]
        oid = tokens[1]
        if len(tokens) == 4:
            canIgnoreError = userData.split(';')[2] == '1'
        else:
            canIgnoreError = None
        oidArea = None
        zoomCoord = None
        QgsMessageLog.logMessage(table)
        self.changeGroupBoxVisibility(table,canIgnoreError)

        if table == 'Out_RuleReportAttributes':
            command = (
                'SELECT OidRegola,OidGeometry,OidAttributo,GeometryTable,OidArea,'
                'Messaggio,TipoMessaggio,'
                "'" + table + "' AS TableName "
                'FROM ' + table + ' WHERE Oid = ' + oid)
            self.selectedError = conn.execute(command).fetchone()
            oidArea = self.selectedError['OidArea']
            oidGeom = self.selectedError['OidGeometry']
            self.dockwidget.ErrorType.setText(self.selectedError['TipoMessaggio'])
            self.dockwidget.ErrorText.setText(self.selectedError['Messaggio'])
            self.dockwidget.Out_RuleReportAttributesGroupBox.setVisible(True)
            self.dockwidget.Out_RuleReportPolyGroupBox.setVisible(False)
            self.dockwidget.Out_RuleReportLineGroupBox.setVisible(False)
            self.dockwidget.Out_RuleReportPointGroupBox.setVisible(False)

        elif table == 'Out_RuleReportPoly':
            command = (
                "SELECT Oid,OidRegola,OidArea1,OidGeom1,Area1,Perimetro1,"
                "OidArea2,OidGeom2,Area2,Perimetro2,"
                "Area,Perimetro,Geom IS NOT NULL AS GeomIsNotNull,"
                "Messaggio,TipoMessaggio,FixGeom1SQLcommand,FixGeom2SQLcommand,FixErrorMessage,"
                "'" + table + "' AS TableName "
                "FROM " + table + " WHERE Oid = " + oid)
            QgsMessageLog.logMessage(command)
            self.selectedError = conn.execute(command).fetchone()
            oidArea = self.selectedError['OidArea1']
            oidGeom = self.selectedError['OidGeom1']
            geomIsNotNull = self.selectedError['GeomIsNotNull']
            if (self.selectedError['FixErrorMessage'] != None):
                self.dockwidget.fixPoly1PushButton.setText(self.selectedError['FixErrorMessage'])
                self.dockwidget.fixPoly2PushButton.setText(self.selectedError['FixErrorMessage'])
                self.dockwidget.fixPoly1PushButton.setVisible(True)
                self.dockwidget.fixPoly2PushButton.setVisible(True)
            else:
                self.dockwidget.fixPoly1PushButton.setVisible(False)
                self.dockwidget.fixPoly2PushButton.setVisible(False)

            if (self.selectedError['Area'] != None):
                self.dockwidget.areaLineEdit.setText(format(self.selectedError['Area'],'g'))
                self.dockwidget.perimetroLineEdit.setText(format(self.selectedError['Perimetro'],'g'))
            if (self.selectedError['Area1'] != None):
                self.dockwidget.areaPoly1LineEdit.setText(format(self.selectedError['Area1'],'g'))
                self.dockwidget.perimetroPoly1LineEdit.setText(format(self.selectedError['Perimetro1'],'g'))
            if (self.selectedError['Area2'] != None):
                self.dockwidget.areaPoly2LineEdit.setText(format(self.selectedError['Area2'],'g'))
                self.dockwidget.perimetroPoly2LineEdit.setText(format(self.selectedError['Perimetro2'],'g'))

            self.dockwidget.fixPoly1PushButton.setEnabled(self.selectedError['FixGeom1SQLcommand'] != None)
            self.dockwidget.fixPoly2PushButton.setEnabled(self.selectedError['FixGeom2SQLcommand'] != None)
            self.dockwidget.zoomPoly1PushButton.setEnabled(self.selectedError['OidArea1'] != None)
            self.dockwidget.zoomPoly2PushButton.setEnabled(self.selectedError['OidArea2'] != None)
            

            # zoom sulla eventuale geometria generata dalla regola di errore
            # nel caso non ci sia un area specifica
            if oidArea == None and geomIsNotNull:
                zoomCoord = conn.execute('SELECT MbrMinX(geom) AS XMin,MbrMinY(geom) AS YMin,MbrMaxX(geom) AS XMax,MbrMaxY(geom) AS YMax FROM ' + table + ' WHERE Oid = ' + oid).fetchone()

        elif table == 'Out_RuleReportLine':
            command = (
                'SELECT Oid,OidRegola,OidArea1,OidGeom1,LunghezzaLinea1,OidArea2,OidGeom2,LunghezzaLinea2,'
                'LunghezzaLinea,Geom IS NOT NULL AS GeomIsNotNull,'
                'Messaggio,TipoMessaggio,FixGeom1SQLcommand,FixGeom2SQLcommand,FixErrorMessage,'
                "'" + table + "' AS TableName "
                'FROM ' + table + ' WHERE Oid = ' + oid)
            QgsMessageLog.logMessage(command)
            self.selectedError = conn.execute(command).fetchone()
            oidArea = self.selectedError['OidArea1']
            oidGeom = self.selectedError['OidGeom1']
            geomIsNotNull = self.selectedError['GeomIsNotNull']
            self.dockwidget.fixLine1PushButton.setText(self.selectedError['FixErrorMessage'])
            self.dockwidget.fixLine2PushButton.setText(self.selectedError['FixErrorMessage'])
            self.dockwidget.fixLine1PushButton.setEnabled(self.selectedError['FixGeom1SQLcommand'] != None)
            self.dockwidget.fixLine2PushButton.setEnabled(self.selectedError['FixGeom2SQLcommand'] != None)
            self.dockwidget.zoomLine1PushButton.setEnabled(self.selectedError['OidArea1'] != None)
            self.dockwidget.zoomLine2PushButton.setEnabled(self.selectedError['OidArea2'] != None)

            if (self.selectedError['LunghezzaLinea'] != None):
                self.dockwidget.lunghezzaLineEdit.setText(format(self.selectedError['LunghezzaLinea'],'g'))
            if (self.selectedError['LunghezzaLinea1'] != None):
                self.dockwidget.lunghezzaLinea1LineEdit.setText(format(self.selectedError['LunghezzaLinea1'],'g'))
            if (self.selectedError['LunghezzaLinea2'] != None):
                self.dockwidget.lunghezzaLinea2LineEdit.setText(format(self.selectedError['LunghezzaLinea2'],'g'))

            # zoom sulla eventuale geometria generata dalla regola di errore
            # nel caso non ci sia un area specifica
            if oidArea == None and geomIsNotNull:
                zoomCoord = conn.execute('SELECT MbrMinX(geom) AS XMin,MbrMinY(geom) AS YMin,MbrMaxX(geom) AS XMax,MbrMaxY(geom) AS YMax FROM ' + table + ' WHERE Oid = ' + oid).fetchone()

        elif table == 'Out_RuleReportPoint':
            command = (
                'SELECT Oid,OidRegola,OidArea1,OidGeom1,OidArea2,OidGeom2,Messaggio,TipoMessaggio,'
                'Geom IS NOT NULL AS GeomIsNotNull,FixGeom1SQLcommand,FixGeom2SQLcommand,FixErrorMessage,'
                "'" + table + "' AS TableName "
                'FROM ' + table + ' WHERE Oid = ' + oid)
            
            self.selectedError = conn.execute(command).fetchone()
            oidArea = self.selectedError['OidArea1']
            oidGeom = self.selectedError['OidGeom1']
            geomIsNotNull = self.selectedError['GeomIsNotNull'] 
            self.dockwidget.fixPoint1PushButton.setText(self.selectedError['FixErrorMessage'])
            self.dockwidget.fixPoint2PushButton.setText(self.selectedError['FixErrorMessage'])
            self.dockwidget.fixPoint1PushButton.setEnabled(self.selectedError['FixGeom1SQLcommand'] != None)
            self.dockwidget.fixPoint2PushButton.setEnabled( self.selectedError['FixGeom2SQLcommand'] != None)
            self.dockwidget.zoomPoint1PushButton.setEnabled(self.selectedError['OidArea1'] != None)
            self.dockwidget.zoomPoint2PushButton.setEnabled(self.selectedError['OidArea2'] != None)

            # zoom sulla eventuale geometria generata dalla regola di errore
            # nel caso non ci sia un area specifica
            if oidArea == None and geomIsNotNull:
                zoomCoord = conn.execute('SELECT MbrMinX(geom) AS XMin,MbrMinY(geom) AS YMin,MbrMaxX(geom) AS XMax,MbrMaxY(geom) AS YMax FROM ' + table + ' WHERE Oid = ' + oid).fetchone()

        # eventuale zoom sulla geometria con selezione del layer corrispondente
        if oidArea != None:
            self.zoomToGeom(conn,oidArea,oidGeom)

        # eventuale zoom su coordinate della geometria generata dalla regola
        elif zoomCoord != None:
            self.zoomToError(table,zoomCoord,int(oid))

        conn.close()

    def zoomToError(self,table,rectangle,oid):
        if table == 'Out_RuleReportPoly':
            layerName = 'Errori_poligoni'
        elif table == 'Out_RuleReportLine':
            layerName = 'Errori_linee'
        elif table == 'Out_RuleReportPoint':
            layerName = 'Errori_punti'
        QgsMessageLog.logMessage('layerName = ' + layerName)
        layer = QgsProject.instance().mapLayersByName(layerName)[0]
        self.iface.setActiveLayer(layer)
        layer.selectByIds([oid])
        r = QgsRectangle(rectangle['XMin'], rectangle['YMin'], rectangle['XMax'], rectangle['YMax'])
        self.iface.mapCanvas().setExtent(r,True)
        self.iface.mapCanvas().refresh()

    def zoomToGeom(self,conn,oidArea,oidGeom):
        QgsMessageLog.logMessage('zoomToGeom (oidArea=' + str(oidArea) + ',OidGeom=' + str(oidGeom) + ')')
        command = (
            'SELECT GeometryType,TipiArea.Nome AS TipoArea ,Sistemi.Nome AS Sistema '
            'FROM Aree '
            'INNER JOIN TipiArea ON Aree.OidTipoArea = TipiArea.oid '
            'INNER JOIN Aree_Sistemi ON Aree.Oid = Aree_Sistemi.OidArea '
            'INNER JOIN Sistemi ON Aree_Sistemi.OidSistema = Sistemi.Oid '
            'WHERE Aree.Oid = ' + str(oidArea))
        QgsMessageLog.logMessage(command)
        result = conn.execute(command).fetchone()
        if result['GeometryType'] == 'POLYGON':
            table = 'poligoni_{0}_{1}'.format(result['TipoArea'].lower(),result['Sistema'].lower()) 
        elif result['GeometryType'] == 'LINESTRING':
            table = 'linee_{0}_{1}'.format(result['TipoArea'].lower(),result['Sistema'].lower())
        elif result['GeometryType'] == 'POINT':
            table = 'punti_{0}_{1}'.format(result['TipoArea'].lower(),result['Sistema'].lower())
        QgsMessageLog.logMessage('Table = ' + table)
        layer = QgsProject.instance().mapLayersByName(table)[0]
        self.iface.setActiveLayer(layer)
        layer.selectByIds([oidGeom])
        self.iface.mapCanvas().zoomToSelected()

    def changeGroupBoxVisibility(self,table,canIgnoreError):
        
        if table == 'Out_RuleReportAttributes':
            self.dockwidget.Out_RuleReportAttributesGroupBox.setVisible(True)
            self.dockwidget.Out_RuleReportPolyGroupBox.setVisible(False)
            self.dockwidget.Out_RuleReportLineGroupBox.setVisible(False)
            self.dockwidget.Out_RuleReportPointGroupBox.setVisible(False)
            self.dockwidget.ignoreAttributeErrorPushButton.setVisible(canIgnoreError)
        elif table == 'Out_RuleReportPoly':
            self.dockwidget.Out_RuleReportAttributesGroupBox.setVisible(False)
            self.dockwidget.Out_RuleReportPolyGroupBox.setVisible(True)
            self.dockwidget.Out_RuleReportLineGroupBox.setVisible(False)
            self.dockwidget.Out_RuleReportPointGroupBox.setVisible(False)
            self.dockwidget.ignorePolyErrorPushButton.setVisible(canIgnoreError)
        elif table == 'Out_RuleReportLine':
            self.dockwidget.Out_RuleReportAttributesGroupBox.setVisible(False)
            self.dockwidget.Out_RuleReportPolyGroupBox.setVisible(False)
            self.dockwidget.Out_RuleReportLineGroupBox.setVisible(True)
            self.dockwidget.Out_RuleReportPointGroupBox.setVisible(False)
            self.dockwidget.ignoreLineErrorPushButton.setVisible(canIgnoreError)
        elif table == 'Out_RuleReportPoint':
            self.dockwidget.Out_RuleReportAttributesGroupBox.setVisible(False)
            self.dockwidget.Out_RuleReportPolyGroupBox.setVisible(False)
            self.dockwidget.Out_RuleReportLineGroupBox.setVisible(False)
            self.dockwidget.Out_RuleReportPointGroupBox.setVisible(True)
            self.dockwidget.ignorePointErrorPushButton.setVisible(canIgnoreError)
        else:
            self.dockwidget.Out_RuleReportAttributesGroupBox.setVisible(False)
            self.dockwidget.Out_RuleReportPolyGroupBox.setVisible(False)
            self.dockwidget.Out_RuleReportLineGroupBox.setVisible(False)
            self.dockwidget.Out_RuleReportPointGroupBox.setVisible(False)

    def selectAllRules(self):
        if self.validating:
            return
        conn = self.getConnection()
        conn.execute('UPDATE Regole SET Esegui = 1')
        conn.commit()
        conn.close()
        self.caricaTemplate()

    def unselectAllRules(self):
        if self.validating:
            return
        conn = self.getConnection()
        conn.execute('UPDATE Regole SET Esegui = 0 OR EsecuzioneObbligatoria')
        conn.commit()
        conn.close()
        self.caricaTemplate()
    
    def iterItemChanged(self,item,column):
        if self.validating:
            return
        userData = item.data(0,Qt.UserRole)
        if userData != None and userData.startswith('Rule;'):
            conn = self.getConnection()

            # extract oid from string
            oid = userData[5:]
            if item.checkState(0) == Qt.Checked:
                conn.execute('UPDATE Regole SET Esegui = 1 WHERE Oid = ' + oid)
            else:
                conn.execute('UPDATE Regole SET Esegui = 0 OR EsecuzioneObbligatoria WHERE Oid = ' + oid)
            conn.commit()
            conn.close()

    def validate(self, progress_callback):
        
        conn = self.getConnection(True)

        # Esecuzione delle regole di validazione per ogni iter di validazione (solitamente 1 solo iter)
        # Le regole sono predisposte nell'ordine corretto dal builder
        iters = conn.execute('SELECT Oid,Nome FROM IterValidazione').fetchall()
        for the_iter in iters:
            regole = conn.execute((
                'SELECT DISTINCT Regole.Oid,Regole.Nome,Regole.OutReportTableName,TipiRegola.Nome AS TipoRegola, Regole.ErroriIgnorabili, Regole.BloccaVerificaPerErrori '
                'FROM ValidationSteps '
                'INNER JOIN Regole ON ValidationSteps.OidRegola = Regole.Oid '
                'INNER JOIN IterValidazione ON Regole.OidIter = IterValidazione.Oid '
                'INNER JOIN TipiRegola ON Regole.OidTipoRegola = TipiRegola.Oid '
                'WHERE Regole.Esegui = 1 AND IterValidazione.Oid = ' + str(the_iter['Oid']))).fetchall()
            ruleIncrement = 100 / len(regole)
            ruleValue = 0
            
            for regola in regole:
                progress_callback.emit(CallBackInfo('Rule',regola['Oid'],'Begin'))

                steps = conn.execute((
                    'SELECT "Oid","Step","SQLCommand" FROM "ValidationSteps"'
                    ' WHERE "OidRegola" = ' + str(regola['Oid']))).fetchall()
                stepIncrement = 100 / len(steps)
                stepValue = 0
                QgsMessageLog.logMessage('Executing ' + str(len(steps)) + ' validation steps')
                
                for step in steps:
                    progress_callback.emit(CallBackInfo('Step',step['Oid'],'Begin'))
                    try:
                        result = conn.executescript(step['SQLCommand'])
                        stepValue = stepValue + stepIncrement
                        progress_callback.emit(CallBackInfo('Rule',regola['Oid'],'Progress',stepValue))
                    except Exception as e:
                        progress_callback.emit(CallBackInfo('Step',step['Oid'],'UnexpectedError'))
                        QgsMessageLog.logMessage('Unexpected error executing ' + step['SQLCommand'])
                        QgsMessageLog.logMessage('Unexpected error in function validate: ' + str(e))

                    progress_callback.emit(CallBackInfo('Step',step['Oid'],'End'))

                ruleValue = ruleValue + ruleIncrement
                progress_callback.emit(CallBackInfo('Iter',the_iter['Oid'],'Progress',ruleValue))
                progress_callback.emit(CallBackInfo('Rule',regola['Oid'],'End',0))

                # verifica del risultato 
                table = regola['OutReportTableName']

                errors = conn.execute('SELECT Oid,TipoMessaggio,Messaggio FROM ' + table + ' WHERE OidRegola = ' + str(regola['Oid'])).fetchall()
                if table == 'Out_RuleReportAttributes':
                    command = (
                        'SELECT t.Oid,TipoMessaggio,Messaggio, ee.oid IS NOT NULL AS ErroreIgnorato '
                        'FROM ' + table + ' t '
                        'LEFT JOIN ErroriIgnorati ee ON t.OidRegola = ee.OidRegola AND t.OidGeometry = ee.OidGeometry AND t.OidAttributo = ee.OidAttributo '
                        'WHERE t.OidRegola = ' + str(regola['Oid']))
                else:
                    command = (
                        'SELECT t.Oid,TipoMessaggio,Messaggio, ee.oid IS NOT NULL AS ErroreIgnorato '
                        'FROM ' + table + ' t '
                        'LEFT JOIN ErroriIgnorati ee ON t.OidRegola = ee.OidRegola AND t.OidGeom1 = ee.OidGeom1 AND t.OidGeom2 = ee.OidGeom2 '
                        'WHERE t.OidRegola = ' + str(regola['Oid']))

                errors = conn.execute(command).fetchall()

                if len(errors) == 0:
                    progress_callback.emit(CallBackInfo('Rule', regola['Oid'],'Success'))
                else:
                    error_info = CallBackInfo('Rule', regola['Oid'],'Error')
                    error_info.error_table = table
                    error_info.errors = []
                    for error in errors:
                       error_info.errors.append((error['Oid'],error['Messaggio'],error['TipoMessaggio'],regola['ErroriIgnorabili'],error['ErroreIgnorato']))
                    # non è possibile passare un vettore nei parametri della callback
                    # e quindi viene convertito in json
                    error_info.errors = json.dumps(error_info.errors)

                    # verifica se l'errore è di quelli bloccanti'
                    if regola['BloccaVerificaPerErrori']:
                        error_info.fatal = True
                        progress_callback.emit(error_info)
                        break
                    else:
                        progress_callback.emit(error_info)

        conn.close()
        return 
    
    def findItem(self,parentItem,objectType,oid):
        """Ricerca ricorsiva un elemento nel tree di navigazione delle regole di validazione

        :param parentItem: item di partenza della ricerca.
        :type parentItem: QTreeWidgetItem

        :param objectType: tipo di oggetto da cercare: Iter,Rule
        :type objectType: str, QString

        :returns: None or the item corresponding to objectType.
        :rtype: QTreeWidgetItem
        """

        if parentItem.data(0,Qt.UserRole) == objectType + ';' + str(oid):
            return parentItem
        elif parentItem.childCount() > 0:
            for i in range(parentItem.childCount()):
                item = self.findItem(parentItem.child(i),objectType,oid)
                if item != None:
                    return item
        else:
            return None

    def progress_fn(self, callBackInfo):
        """Funzione che processa l'avanzamento dell'eleaborazione
        :param callBackInfo: informazioni da processare
        """

        # item associato alla callback
        item = self.findItem(self.dockwidget.treeWidget.topLevelItem(0),callBackInfo.objectType,callBackInfo.oid)
        if item == None:
            return

        if callBackInfo.objectType == 'Iter' and callBackInfo.status =='Progress':
            self.dockwidget.iterProgressBar.setValue(callBackInfo.progress)
        elif callBackInfo.objectType == 'Rule' and callBackInfo.status =='Progress':
            self.dockwidget.ruleProgressBar.setMaximum(100)
            self.dockwidget.ruleProgressBar.setValue(callBackInfo.progress)
        elif callBackInfo.objectType == 'Rule' and callBackInfo.status =='Begin':
            item.takeChildren()
            self.dockwidget.ruleProgressBar.setMaximum(0)
        elif callBackInfo.objectType == 'Rule' and callBackInfo.status =='Error':
            # ogni errore è una cinquina con (oid,messaggio,tipo messaggio,errore ignorabile, errore ignorato)
            errors = json.loads(callBackInfo.errors)
            error_Items = []
            for error in errors:
                error_Item = QtWidgets.QTreeWidgetItem([error[1]])
                error_Item.setData(0,Qt.UserRole,callBackInfo.error_table + ';' + str(error[0]) + ';' + str(error[3]) + ';' + str(error[4]))
                if error[2] == 'W':
                    # questo è un warning
                    error_Item.setData(0,Qt.ForegroundRole,QBrush(QColor('orange')))
                if error[4] == True:
                    # questo è un errore ignorato
                    error_Item.setData(0,Qt.FontRole,self.strikeOutFont)

                error_Items.append(error_Item)
            item.addChildren(error_Items)
            item.setText(1,str(len(errors)))

            # aggiorna la visualizzazione del layer degli errori
            self.poligonErrorsLayer().triggerRepaint()
        elif callBackInfo.objectType == 'Rule' and callBackInfo.status =='Success':
            item.setText(1,None)

        if callBackInfo.status == 'Begin':
            item.setData(0,Qt.ForegroundRole,QBrush(QColor('darkyellow')))
        elif callBackInfo.status == 'End':
            item.setData(0,Qt.ForegroundRole,QBrush(QColor('blue')))
        elif callBackInfo.status == 'Success':
            item.setData(0,Qt.ForegroundRole,QBrush(QColor('green')))
        elif callBackInfo.status == 'UnexpectedError':
            item.setData(0,Qt.ForegroundRole,QBrush(QColor('darkred')))
        elif callBackInfo.status == 'Error':
            item.setData(0,Qt.ForegroundRole,QBrush(QColor('red')))

        self.dockwidget.treeWidget.setCurrentItem(item)
        self.dockwidget.treeWidget.scrollToItem(item)
        
        if callBackInfo.fatal:
            self.validationFatalErrors = self.validationFatalErrors + 1
            

    def print_error(self, s):
        QgsMessageLog.logMessage(s[2])

    def print_output(self, s):
        QgsMessageLog.logMessage(s)
        
    def thread_complete(self):
        self.validating = False
        self.dockwidget.iterProgressBar.setVisible(False)
        self.dockwidget.ruleProgressBar.setVisible(False)
        self.dockwidget.tabWidget.setDisabled(False)

        sl = self.poligonErrorsLayer()
        sl.setDataSource(sl.source(), sl.name(), sl.providerType())
        if self.validationFatalErrors == 0:
            QMessageBox.information(None,'Validazione','Validazione terminata!')
        else:
            QMessageBox.critical(None,'Validazione','Validazione terminata con ' + str (self.validationFatalErrors) + ' errori bloccanti')
  