# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PrefixProxy
                                 A QGIS plugin
 Adds prefix proxy addresses to connections
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-08-02
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Dror Bogin
        email                : dror.bogin@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.core import QgsNetworkAccessManager, QgsNetworkRequestParameters
from PyQt5.QtWidgets import QTableWidgetItem
from PyQt5.QtCore import QRegExp, QUrl
from PyQt5.QtGui import QRegExpValidator

# Initialize Qt resources from file resources.py
from .resources import *  # noqa: F403
# Import the code for the dialog
from .prefix_proxy_dialog import PrefixProxyDialog
import os.path
import json


class PrefixProxy:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'PrefixProxy_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Proxy Handler')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

        # Add Empty Handlers List
        self.handlers = []

        # Add QgsNetworkAccessManager and process ID
        self.nam = QgsNetworkAccessManager.instance()
        self.processID = None

        self.readHandlers()
        
        # set the preprocessor
        self.setPreprocessor()


    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('PrefixProxy', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToWebMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/prefix_proxy/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Add proxy rule'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.dlg = PrefixProxyDialog()
        self.bindActions()
        self.setValidators()
        self.populateHandlersTable()
        # prebuild handlers list when OK is pressed
        self.buildHandlersList()
        


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginWebMenu(
                self.tr(u'&Proxy Handler'),
                action)
            self.iface.removeToolBarIcon(action)


    def setPreprocessor(self):    
        """
        Sets self.addPrefixProxyToRequest to run before every request is run 
        """
        if self.processID is not None:
            self.nam.removeRequestPreprocessor(self.processID)
        self.processID = self.nam.setRequestPreprocessor(self.addPrefixProxyToRequest)
        print(self.processID)


    def addPrefixProxyToRequest(self,request):
        """
        uses the requestAboutToBeSent signal to add the prefix proxy to the request
        """
        url = request.url().toString()
        for handler in self.handlers:
                if url.startswith(handler["url"]):
                    prefixedURL = handler["proxy"] + "?" + url
                    print(prefixedURL)
                    request.setUrl(QUrl(prefixedURL))


    def writeHandlers(self):
        """
        writes currently defined handlers to the handlers.json file in the profile's plugin folder
        """
        handlers = self.handlers
        with open(self.plugin_dir + "/handlers.json", 'w') as outfile:
            json.dump(handlers, outfile)

    def readHandlers(self):
        """
        reads the handlers from the handlers.json file
        if one exists
        """
        if os.path.exists(self.plugin_dir + "/handlers.json"):
            with open(self.plugin_dir + "/handlers.json") as json_file:
                self.handlers = json.load(json_file)


    def populateHandlersTable(self):
        """
        Update the table to display handlers
        """
        rowCount = len(self.handlers)
        self.dlg.handlersTable.clearContents()
        self.dlg.handlersTable.setRowCount(rowCount)
        for i in range(rowCount):
            url = self.handlers[i]["url"]
            proxyUrl = self.handlers[i]["proxy"]
            self.dlg.handlersTable.setItem(i,0,QTableWidgetItem(url))
            self.dlg.handlersTable.setItem(i,1,QTableWidgetItem(proxyUrl))


    def buildHandlersList(self):
        """
        Build object and write to handlers.json
        """
        rowCount = self.dlg.handlersTable.rowCount()
        self.handlers = []
        for i in range(rowCount):
            url = self.dlg.handlersTable.item(i,0).text()
            proxyUrl = self.dlg.handlersTable.item(i,1).text()
            self.handlers.append({"url":url,"proxy":proxyUrl})

        self.writeHandlers()
        return self.handlers


    def addHandler(self):
        """
        Add new rule to handlers list
        """
        url = self.dlg.uRLLineEdit.text()
        proxyUrl = self.dlg.proxyURLLineEdit.text()
        rowCount = self.dlg.handlersTable.rowCount()
        self.dlg.handlersTable.insertRow(rowCount)
        self.dlg.handlersTable.setItem(rowCount,0,QTableWidgetItem(url))
        self.dlg.handlersTable.setItem(rowCount,1,QTableWidgetItem(proxyUrl))
        self.dlg.uRLLineEdit.clear()
        self.dlg.proxyURLLineEdit.clear()
        self.buildHandlersList()

    def removeHandler(self):
        """
        Remov rule from list
        """
        index_list = []
        for model_index in self.dlg.handlersTable.selectionModel().selectedRows():
            index = QtCore.QPersistentModelIndex(model_index)
            index_list.append(index)
        for index in index_list:
            self.dlg.handlersTable.removeRow(index.row())

    def toggleRemoveButtonVisibility(self):
        if self.dlg.handlersTable.rowCount() > 0:
            self.dlg.removeHandlerButton.setEnabled(True)
            self.dlg.clearSelectionButton.setEnabled(True)
        else:
            self.dlg.removeHandlerButton.setEnabled(False)
            self.dlg.clearSelectionButton.setEnabled(False)

    def clearSelection(self):
        for item in self.dlg.handlersTable.selectedItems():
            item.setSelected(False)


    def bindActions(self):
        self.dlg.addHandlerButton.clicked.connect(self.addHandler)
        self.dlg.removeHandlerButton.clicked.connect(self.removeHandler)
        self.dlg.handlersTable.itemSelectionChanged.connect(self.toggleRemoveButtonVisibility)
        self.dlg.clearSelectionButton.clicked.connect(self.clearSelection)

    def setValidators(self):
        urlValidator = QRegExpValidator(QRegExp("^(http|https)://.*$"))
        self.dlg.uRLLineEdit.setValidator(urlValidator)
        self.dlg.proxyURLLineEdit.setValidator(urlValidator)


    def run(self):

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # prebuild handlers list when OK is pressed
            self.buildHandlersList()
            # set the preprocessor
            self.setPreprocessor()
            pass
