# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PowerPinDockWidget
                                 A QGIS plugin
 Plugin eksportuje pinezkę do serwiów tpy geoportal. Plugin export pin to popular geoportal like serives
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-03-15
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Łukasz Świątek
        email                : lukasz.swiatek1996@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import QtGui, QtWidgets, uic
from qgis.PyQt.QtCore import pyqtSignal

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'power_pin_dockwidget_base.ui'))


class PowerPinDockWidget(QtWidgets.QDockWidget, FORM_CLASS):

    closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        """Constructor."""
        super(PowerPinDockWidget, self).__init__(parent)
        self.setupUi(self)

        # Dynamiczny layout
        layout = self.dockWidgetContents.layout()
        if layout is None:
             layout = QtWidgets.QVBoxLayout(self.dockWidgetContents)
        
        # 1. Checkbox dla Dynamic View
        self.cb_dynamic_view = QtWidgets.QCheckBox("Dynamic View (Zoom/Extent)")
        self.cb_dynamic_view.setToolTip("If checked, uses current map scale and extent. If unchecked, uses fixed zoom and point buffer.")
        
        # 2. Checkbox dla Compact Mode (Split Button)
        self.cb_compact_mode = QtWidgets.QCheckBox("Compact Mode (Split Button)")
        self.cb_compact_mode.setToolTip("If checked, shows only one button with the last used portal. Others are in a dropdown.")

        # Dodawanie do layoutu (bezpiecznie dla Grid i innych)
        if hasattr(layout, 'insertWidget'):
             layout.insertWidget(0, self.cb_compact_mode)
             layout.insertWidget(1, self.cb_dynamic_view)
        elif hasattr(layout, 'addWidget'):
             if isinstance(layout, QtWidgets.QGridLayout):
                 layout.addWidget(self.cb_compact_mode, layout.rowCount(), 0, 1, layout.columnCount())
                 layout.addWidget(self.cb_dynamic_view, layout.rowCount(), 0, 1, layout.columnCount())
             else:
                 layout.addWidget(self.cb_compact_mode)
                 layout.addWidget(self.cb_dynamic_view)

    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()
