# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PowerPin
                                 A QGIS plugin
 Plugin eksportuje pinezkę do serwiów tpy geoportal. Plugin export pin to popular geoportal like serives
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-03-15
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Łukasz Świątek
        email                : lukasz.swiatek1996@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# from PyQt5 import Qt, QtCore, QtWidgets, QtGui, QtWebKit, QtWebKitWidgets, QtXml, QtNetwork, uic
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import *

from qgis.gui import *
from qgis.utils import *
from qgis.core import *

from qgis.gui import QgsRubberBand
# Initialize Qt resources from file resources.py
from .resources import *

# Import the code for the DockWidget
from .power_pin_dockwidget import PowerPinDockWidget
import os.path

import math
import webbrowser  
import subprocess

rb=QgsRubberBand(iface.mapCanvas(),QgsWkbTypes.PointGeometry )
rl=QgsRubberBand(iface.mapCanvas(),QgsWkbTypes.LineGeometry )
premuto= False
linea=False
point0=iface.mapCanvas().getCoordinateTransform().toMapCoordinates(0, 0)
point1=iface.mapCanvas().getCoordinateTransform().toMapCoordinates(0, 0)


class PowerPin:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """

        self.upoint = ""
        # Save reference to the QGIS interface
        self.iface = iface

        ###
        self.canvas = self.iface.mapCanvas()
        
        # out click tool will emit a QgsPoint on every click
        self.clickTool = QgsMapToolEmitPoint(self.canvas)
        self.clickTool.canvasClicked.connect(self.canvasClicked)
        ###

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'PowerPin_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Power Pin PL')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'PowerPin')
        self.toolbar.setObjectName(u'PowerPin')

        #print "** INITIALIZING PowerPin"

        self.pluginIsActive = False
        self.dockwidget = None


    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('PowerPin', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToWebMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action


    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        #

        portals = ['google', 'streetview', 'earth', 'geoportal', 'geoportal2', 'g360', 'emapa', 'osm', 'ump', 'yandex', 'bing', 'streeteye', 'c-geo','apple', 'Alookmap', 'internet.gov']
        self.portals = portals
        # ons = [True, True, True, True, True, True, True, True, True, True, True]

        ons = [True] * 16

        file_path = os.path.join(self.plugin_dir, "power_pin_config.txt")
        if os.path.exists(file_path):
            
            temp_ons = ons.copy()
            temp_portals = portals.copy()
            portals = []
            ons = []
            with open(file_path, 'r', encoding='utf-8') as file:
                lines = file.read().split("\n")
                for line in lines:
                    line = line.split("\t")

                    if len(line) > 1:
                        if line[1] == "ON":
                            portals.append(line[0])
                            ons.append(True)
                        else:
                            ons.append(False)

            if len(ons) < 16:
                ons = temp_ons.copy()
                portals = temp_portals.copy()


        else:
            try:
                with open(file_path, 'w', encoding='utf-8') as file:
                    for portal in portals:
                        file.write(f"{portal}\tON\n")
                QgsMessageLog.logMessage(f"Default setting loaded succesful")
            except PermissionError:
                QgsMessageLog.logMessage(f"Load without widget settings")


        # self.popupMenu = QMenu( self.iface.mainWindow() )

        icon_path = ':/plugins/power_pin/icons/map32.png'
        self.main_btn = self.add_action(
            icon_path,
            text=self.tr(u'Power Pin'),
            callback=self.run,
            parent=self.iface.mainWindow()) #
        #self.popupMenu.addAction(self.main_btn)

        """

        for portal in portals:
            icon_path = f':/plugins/power_pin/icons/_{portal}.png'
            self.add_action(
                    icon_path,
                    text=self.tr(f'{portal.capitalize()}'),
                    #callback=lambda: self.put_pin(portal),
                    callback=lambda: self.put_pin(f"{portal}"),
                    parent=self.iface.mainWindow() #
                )
        """

        if ons[0]:
            portal = "google"
            icon_path = f':/plugins/power_pin/icons/_{portal}.png'
            btn = self.add_action(
                    icon_path,
                    text=self.tr(f'{portal.capitalize()}'),
                    #callback=lambda: self.put_pin(portal),
                    callback=lambda: self.put_pin(f"google"),
                    parent=self.iface.mainWindow() #
                )
        
        if ons[1]:
            portal = "streetview"
            icon_path = f':/plugins/power_pin/icons/_{portal}.png'
            btn = self.add_action(
                    icon_path,
                    text=self.tr(f'{portal.capitalize()}'),
                    #callback=lambda: self.put_pin(portal),
                    callback=lambda: self.put_pin(f"streetview"),
                    parent=self.iface.mainWindow() #
                )
        
        if ons[2]:
            portal = "earth"
            icon_path = f':/plugins/power_pin/icons/_{portal}.png'
            btn = self.add_action(
                    icon_path,
                    text=self.tr(f'{portal.capitalize()}'),
                    #callback=lambda: self.put_pin(portal),
                    callback=lambda: self.put_pin(f"earth"),
                    parent=self.iface.mainWindow() #
                )
        
        if ons[3]:
            portal = "geoportal"
            icon_path = f':/plugins/power_pin/icons/_{portal}.png'
            btn = self.add_action(
                    icon_path,
                    text=self.tr(f'{portal.capitalize()}'),
                    #callback=lambda: self.put_pin(portal),
                    callback=lambda: self.put_pin(f"geoportal"),
                    parent=self.iface.mainWindow() #
                )
        
        if ons[4]:
            portal = "geoportal2"
            icon_path = f':/plugins/power_pin/icons/_{portal}.png'
            btn = self.add_action(
                    icon_path,
                    text=self.tr(f'{portal.capitalize()}'),
                    #callback=lambda: self.put_pin(portal),
                    callback=lambda: self.put_pin(f"geoportal2"),
                    parent=self.iface.mainWindow() #
                )

        if ons[5]:
            portal = "g360"
            icon_path = f':/plugins/power_pin/icons/_{portal}.png'
            btn = self.add_action(
                    icon_path,
                    text=self.tr(f'{portal.capitalize()}'),
                    #callback=lambda: self.put_pin(portal),
                    callback=lambda: self.put_pin(f"g360"),
                    parent=self.iface.mainWindow() #
                )
        
        if ons[6]:
            portal = "emapa"
            icon_path = f':/plugins/power_pin/icons/_{portal}.png'
            btn = self.add_action(
                    icon_path,
                    text=self.tr(f'{portal.capitalize()}'),
                    #callback=lambda: self.put_pin(portal),
                    callback=lambda: self.put_pin(f"emapa"),
                    parent=self.iface.mainWindow() #
                )
        
        if ons[7]:
            portal = "osm"
            icon_path = f':/plugins/power_pin/icons/_{portal}.png'
            btn = self.add_action(
                    icon_path,
                    text=self.tr(f'{portal.capitalize()}'),
                    #callback=lambda: self.put_pin(portal),
                    callback=lambda: self.put_pin(f"osm"),
                    parent=self.iface.mainWindow() #
                )
        
        if ons[8]:
            portal = "ump"
            icon_path = f':/plugins/power_pin/icons/_{portal}.png'
            btn = self.add_action(
                    icon_path,
                    text=self.tr(f'{portal.capitalize()}'),
                    #callback=lambda: self.put_pin(portal),
                    callback=lambda: self.put_pin(f"ump"),
                    parent=self.iface.mainWindow() #
                )
            
        if ons[9]:
            portal = "yandex"
            icon_path = f':/plugins/power_pin/icons/_{portal}.png'
            btn = self.add_action(
                    icon_path,
                    text=self.tr(f'{portal.capitalize()}'),
                    #callback=lambda: self.put_pin(portal),
                    callback=lambda: self.put_pin(f"yandex"),
                    parent=self.iface.mainWindow() #
                )
        if ons[10]:
            portal = "bing"
            icon_path = f':/plugins/power_pin/icons/_{portal}.png'
            btn = self.add_action(
                    icon_path,
                    text=self.tr(f'{portal.capitalize()}'),
                    #callback=lambda: self.put_pin(portal),
                    callback=lambda: self.put_pin(f"bing"),
                    parent=self.iface.mainWindow() #
                )
        if ons[11]:
            portal = "streeteye"
            icon_path = f':/plugins/power_pin/icons/_{portal}.png'
            btn = self.add_action(
                    icon_path,
                    text=self.tr(f'{portal.capitalize()}'),
                    #callback=lambda: self.put_pin(portal),
                    callback=lambda: self.put_pin(f"streeteye"),
                    parent=self.iface.mainWindow() #
                )
                
        if ons[12]:
            portal = "c-geo"
            icon_path = f':/plugins/power_pin/icons/_{portal}.png'
            btn = self.add_action(
                    icon_path,
                    text=self.tr(f'{portal.capitalize()}'),
                    #callback=lambda: self.put_pin(portal),
                    callback=lambda: self.put_pin(f"c-geo"),
                    parent=self.iface.mainWindow() #
                )
        if ons[13]:
            portal = "apple"
            icon_path = f':/plugins/power_pin/icons/_{portal}.png'
            btn = self.add_action(
                    icon_path,
                    text=self.tr(f'{portal.capitalize()}'),
                    #callback=lambda: self.put_pin(portal),
                    callback=lambda: self.put_pin(f"apple"),
                    parent=self.iface.mainWindow() #
                )
        if ons[14]:
            portal = "Alookmap"
            icon_path = f':/plugins/power_pin/icons/_{portal}.png'
            btn = self.add_action(
                    icon_path,
                    text=self.tr(f'{portal.capitalize()}'),
                    #callback=lambda: self.put_pin(portal),
                    callback=lambda: self.put_pin(f"Alookmap"),
                    parent=self.iface.mainWindow() #
                )
        if ons[15]:
            portal = "internet.gov"
            icon_path = f':/plugins/power_pin/icons/_{portal}.png'
            btn = self.add_action(
                    icon_path,
                    text=self.tr(f'{portal.capitalize()}'),
                    #callback=lambda: self.put_pin(portal),
                    callback=lambda: self.put_pin(f"internet.gov"),
                    parent=self.iface.mainWindow() #
                )

        

        """
        self.toolButton = QToolButton()
        self.toolButton.setMenu( self.popupMenu )
        self.toolButton.setDefaultAction(self.main_btn)
        self.toolButton.setPopupMode(QToolButton.MenuButtonPopup)
        self.toolbar.addWidget(self.toolButton)
        """

        self.ons = ons
 


    #--------------------------------------------------------------------------



    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""

        #print "** CLOSING PowerPin"

        # disconnects
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)

        # remove this statement if dockwidget is to remain
        # for reuse if plugin is reopened
        # Commented next statement since it causes QGIS crashe
        # when closing the docked window:
        # self.dockwidget = None

        self.pluginIsActive = False


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""

        #print "** UNLOAD PowerPin"

        for action in self.actions:
            self.iface.removePluginWebMenu(
                self.tr(u'&Power Pin PL'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    #--------------------------------------------------------------------------

    def put_pin(self, portal):

        """self.dockwidget.listWidget.clear()
        self.dockwidget.listWidget.addItem(f"{portal}")"""

        # QgsMessageLog.logMessage("Select loaction on map: First point is pin location, second without click release is direction (for streetview or bingeye)")

        self.iface.messageBar().pushMessage( f"Select loaction for {portal}:", "First point is pin location, second without click release is direction (for streetview or bingeye)", level=Qgis.Success, duration=2)

        tool = PointTool(self.iface.mapCanvas(), portal)
        self.iface.mapCanvas().setMapTool(tool)

    def put_pin_cross(self, portal):

        """self.dockwidget.listWidget.clear()
        self.dockwidget.listWidget.addItem(f"{portal}")"""

        self.iface.messageBar().pushMessage( "Select point", "and copy it to clipboard", level=Qgis.Success, duration=2)
        self.canvas.setMapTool(self.clickTool)



    def canvasClicked(self, point):
        # dodać przyciąganie według obecnych ustawień
        # self.canvas.unsetMapTool(self.clickTool)
        # self.portal = portal.strip()

        coords = f"{point.y():.3f}\t{point.x():.3f}"
        actual_crs = self.canvas.mapSettings().destinationCrs()

        self.canvas.unsetMapTool(self.clickTool)
        QgsMessageLog.logMessage(str(coords), 'Power Clipboard')
        self.iface.messageBar().pushMessage("Copied to clipboard:", f"{coords}// {actual_crs}", level=Qgis.Success, duration=2)
        


    def save_congig(self):

        l =  [item.text() for item in self.dockwidget.listWidget.selectedItems()]

        file_path = os.path.join(self.plugin_dir, "power_pin_config.txt")
        try:
            with open(file_path, 'w', encoding='utf-8') as file:
                for portal in self.portals:
                    if portal in l:
                        file.write(f"{portal}\tON\n")
                    else:
                        file.write(f"{portal}\tOFF\n")

            reloadPlugin("power_pin")
        except PermissionError:
            QgsMessageLog.logMessage(f"Cannot save setting without premission to document directory")

    

    def run(self):
        """Run method that loads and starts the plugin"""

        if not self.pluginIsActive:
            self.pluginIsActive = True


                #print "** STARTING PowerPin"

                # dockwidget may not exist if:
                #    first run of plugin
                #    removed on close (see self.onClosePlugin method)
            if self.dockwidget == None:
                    # Create the dockwidget (after translation) and keep reference
                self.dockwidget = PowerPinDockWidget()

                self.dockwidget.pushButton.clicked.connect(lambda: self.save_congig())
                self.dockwidget.pushButton_2.clicked.connect(lambda: webbrowser.open_new('https://www.paypal.com/donate/?hosted_button_id=2AFDC9PRMGN3Q'))
                self.dockwidget.pushButton_3.clicked.connect(lambda: webbrowser.open_new('http://github.com/Rzezimioszek/QGIS-power-pin'))

                self.dockwidget.listWidget.clear()

                portals = self.portals
                i = 0
                for portal in portals:
                    self.dockwidget.listWidget.addItem(f"{portal}")
            
                    item = self.dockwidget.listWidget.item(i)
                    item.setSelected(self.ons[i])
                    i += 1



            


                # connect to provide cleanup on closing of dockwidget
            self.dockwidget.closingPlugin.connect(self.onClosePlugin)

                # show the dockwidget
            self.iface.addDockWidget(Qt.RightDockWidgetArea, self.dockwidget)
            self.dockwidget.show()

class PointTool(QgsMapTool):  

        
        def __init__(self, canvas, portal):
        
            QgsMapTool.__init__(self, canvas)
            self.canvas = canvas    
            self.portal = portal.strip()

        def canvasPressEvent(self, event):
            x = event.pos().x()
            y = event.pos().y()
            global rb ,premuto ,point0
            if not premuto: 
              premuto=True
              rb=QgsRubberBand(iface.mapCanvas(),QgsWkbTypes.PointGeometry )
              rb.setColor ( QtCore.Qt.red )
              point0 = self.canvas.getCoordinateTransform().toMapCoordinates(x, y)
              rb.addPoint(point0)  
  
        def canvasMoveEvent(self, event):
              x = event.pos().x()
              y = event.pos().y()        
              global premuto,point0,point1,linea,rl
              if premuto:
               if not linea:              
                rl.setColor ( QtCore.Qt.red )
                point1 = self.canvas.getCoordinateTransform().toMapCoordinates(x, y)
                rl.addPoint(point0)  
                rl.addPoint(point1)
                linea=True
               else:
                if linea: 
                  point1 = self.canvas.getCoordinateTransform().toMapCoordinates(x, y)
                  rl.reset(QgsWkbTypes.LineGeometry)
                  rl.addPoint(point0)  
                  rl.addPoint(point1)
                  
                  
      
        def canvasReleaseEvent(self, event):
            global premuto,linea,rb,rl,point1,point0

            premuto=False
            linea=False
            actual_crs = self.canvas.mapSettings().destinationCrs()

            p = str(self.portal)

            if p == 'google':

                crsDest = QgsCoordinateReferenceSystem(4326) # WGS 84 / UTM zone 33N

                xform = QgsCoordinateTransform(actual_crs, crsDest,QgsProject.instance())
                pt1 = xform.transform(point0)

                """url = f"https://www.google.pl/maps/@"
                url = f"{url}{pt1.y()},{pt1.x()},19z"
                """

                url = f"https://www.google.pl/maps/place/"
                url = f"{url}{pt1.y()},{pt1.x()}"
                webbrowser.open_new(url)

            elif p == 'streetview':

                angle = math.atan2(point1.x() - point0.x(), point1.y() - point0.y())
                angle = math.degrees(angle)if angle>0 else (math.degrees(angle) + 180)+180

                crsDest = QgsCoordinateReferenceSystem(4326) # WGS 84 / UTM zone 33N

                xform = QgsCoordinateTransform(actual_crs, crsDest,QgsProject.instance())
                pt1 = xform.transform(point0)

                url = f"https://www.google.com/maps/@?api=1&map_action=pano&viewpoint="
                url = f"{url}{pt1.y()},{pt1.x()}&heading={angle}&pitch=10&fov=250"
                webbrowser.open_new(url)

            elif p == 'earth':
                crsDest = QgsCoordinateReferenceSystem(4326) # WGS 84 / UTM zone 33N

                xform = QgsCoordinateTransform(actual_crs, crsDest,QgsProject.instance())
                pt1 = xform.transform(point0)

                url = f"https://earth.google.com/web/@"
                url = f"{url}{pt1.y()},{pt1.x()},110a,300d,90y,0h,0t,0r/data=OgMKATA"
                webbrowser.open_new(url)

            elif p == 'geoportal':

                crsDest = QgsCoordinateReferenceSystem(2180)  # 92

                xform = QgsCoordinateTransform(actual_crs, crsDest,QgsProject.instance())
                pt1 = xform.transform(point0)
        
                url = f"https://mapy.geoportal.gov.pl/?bbox="   
                url = f"{url}{pt1.x()},{pt1.y()},{pt1.x()},{pt1.y()}&variant=KATASTER"
                    
                webbrowser.open_new(url)

            elif p == 'geoportal2':

                crsDest = QgsCoordinateReferenceSystem(2180)  # 92

                xform = QgsCoordinateTransform(actual_crs, crsDest,QgsProject.instance())
                pt1 = xform.transform(point0)
        
                url = f"https://polska.geoportal2.pl/map/www/mapa.php?CFGF=wms&mylayers=%20OSM%20wmts1:ORTOFOTOMAPA@EPSG:2180%20g1:dzialki%20g1:numery_dzialek%20g1:budynki&bbox="   
                url = f"{url}{pt1.x()},{pt1.y()},{pt1.x()},{pt1.y()}&markery=0,{pt1.x()},{pt1.y()}"
                    
                webbrowser.open_new(url)
            
            elif p == 'g360':
                crsDest = QgsCoordinateReferenceSystem(4326) # WGS 84 / UTM zone 33N

                xform = QgsCoordinateTransform(actual_crs, crsDest,QgsProject.instance())
                pt1 = xform.transform(point0)
        
                url = f"https://geoportal360.pl/map/#l:"
                url = f"{url}{pt1.y()},{pt1.x()},19"
                    
                webbrowser.open_new(url)

            elif p == 'emapa':
                crsDest = QgsCoordinateReferenceSystem(2180)  # 92

                xform = QgsCoordinateTransform(actual_crs, crsDest,QgsProject.instance())
                pt1 = xform.transform(point0)
        
                url = f"https://polska.e-mapa.net?"
                url = f"{url}x={pt1.x()}&y={pt1.y()}&zoom=11&group=2,1000255&service=123,124,129,130,133,136,137,145,148,153,154,155,169,171,175,176,177,178,179,182,187,188,193,194,195,196,197,198,201,204,205,206,223,228,229,244,249,251,252,254,260,261,271,273,278,280,282,283,284,285,295,302,318,319,321,322,323,324,330&alllayers=123,126,128,129,130,131,Plany wektorowes133,Plany wektorowes133,Plany wektorowes133,Plany wektorowes133,Plany wektorowes133,134,136,137,139,140,141,143,144,145,147,148,149,150,151,152,153,154,155,156,159,161,162,167,169,170,171,172,176,177,178,182,204,205,206,210,211,213,221,222,223,224,225,226,231,232,233,234,235,236,237,238,239,240,241,242,244,246,248,249,250,252,254,256,257,258,259,261,263,264,265,266,267,268,269,271,274,282,283,284,285,293,295,296,297,298,299,300,302,308,309,311,312,313,314,315,316,318,319,320,321,322,323,324,326,327,328,330,331&layer=124001,124002,124003,127002,127003,127004,127005,127006,127007,127008,127009,1270010,132001,132002,132003,132004,133002,133008,146002,146003,146004,146005,173001,179001,180001,184006,184007,184009,185006,185007,185009,186006,186007,186009,187007,187008,187009,1870010,187021,187022,187023,187024,188007,188008,188009,1880010,188021,188022,188023,188024,189007,189008,189009,1890010,190009,1900010,190011,190012,190013,191005,193002,193005,193007,194001,194004,194006,1940010,196001,196004,196006,1960010,197005,201001,201003,201009,202001,209001,209002,209003,209004,209005,209006,212006,212008,212009,2120010,212011,228002,229003,247004,247005,247006,247037,247038,247039,247040,247041,247042,251004,276016,277002,278002,280001,286002,286003,304001,305001,306001"
                    
                webbrowser.open_new(url)

            elif p == 'osm':
                crsDest = QgsCoordinateReferenceSystem(4326) # WGS 84 / UTM zone 33N

                xform = QgsCoordinateTransform(actual_crs, crsDest,QgsProject.instance())
                pt1 = xform.transform(point0)
        
                url = f"https://www.openstreetmap.org/?m"
                url = f"{url}lat={pt1.y()}&mlon={pt1.x()}#map=19/{pt1.y()}/{pt1.x()}"
                webbrowser.open_new(url)

            elif p == 'ump':
                crsDest = QgsCoordinateReferenceSystem(4326) # WGS 84 / UTM zone 33N

                xform = QgsCoordinateTransform(actual_crs, crsDest,QgsProject.instance())
                pt1 = xform.transform(point0)
        
                url = f"https://mapa.ump.waw.pl/ump-www/?zoom=19"
                url = f"{url}&lat={pt1.y()}&lon={pt1.x()}"
                webbrowser.open_new(url)

            elif p == 'yandex':
                crsDest = QgsCoordinateReferenceSystem(4326) # WGS 84 / UTM zone 33N

                xform = QgsCoordinateTransform(actual_crs, crsDest,QgsProject.instance())
                pt1 = xform.transform(point0)
        
                url = f"https://yandex.eu/maps/?ll="
                url = f"{url}{pt1.x()}%2C{pt1.y()}&z=19"
                webbrowser.open_new(url)

            elif p == 'bing':
                crsDest = QgsCoordinateReferenceSystem(4326) # WGS 84 / UTM zone 33N

                xform = QgsCoordinateTransform(actual_crs, crsDest,QgsProject.instance())
                pt1 = xform.transform(point0)
        
                url = f"https://www.bing.com/maps?cp="
                url = f"{url}{pt1.y()}%7E{pt1.x()}&lvl=19"
                webbrowser.open_new(url)

            elif p == 'streeteye':
                crsDest = QgsCoordinateReferenceSystem(4326) # WGS 84 / UTM zone 33N

                xform = QgsCoordinateTransform(actual_crs, crsDest,QgsProject.instance())
                pt1 = xform.transform(point0)

                angle = math.atan2(point1.x() - point0.x(), point1.y() - point0.y())
                angle = math.degrees(angle)if angle>0 else (math.degrees(angle) + 180)+180
        
                url = f"https://bing.com/maps/default.aspx?cp="
                url = f"{url}{pt1.y()}~{pt1.x()}&style=x&lvl=19&dir={angle}"
                webbrowser.open_new(url)
                
            elif p == 'c-geo':

                crsDest = QgsCoordinateReferenceSystem(2180)  # 92

                xform = QgsCoordinateTransform(actual_crs, crsDest,QgsProject.instance())
                pt1 = xform.transform(point0)
                
                
        
                url = f"https://www.c-geoportal.pl/map?extent="   
                
                pt1.x  = pt1.x() - 100.0
                pt1.y  = pt1.y() - 100.0
                url = f"{url}{pt1.x},{pt1.y},"
                
                pt1.x  = pt1.x + 200.0
                pt1.y  = pt1.y + 200.0
                url = f"{url}{pt1.x},{pt1.y}"
                    
                webbrowser.open_new(url)
            elif p == 'apple':


                crsDest = QgsCoordinateReferenceSystem(4326) # WGS 84 / UTM zone 33N

                xform = QgsCoordinateTransform(actual_crs, crsDest,QgsProject.instance())
                pt1 = xform.transform(point0)

                url = f"https://beta.maps.apple.com/"
                url = f"{url}?ll={pt1.y()},{pt1.x()}"
                webbrowser.open_new(url)
            elif p == 'Alookmap':

                angle = math.atan2(point1.x() - point0.x(), point1.y() - point0.y())
                angle = math.degrees(angle)if angle>0 else (math.degrees(angle) + 180)+180

                crsDest = QgsCoordinateReferenceSystem(4326) # WGS 84 / UTM zone 33N

                xform = QgsCoordinateTransform(actual_crs, crsDest,QgsProject.instance())
                pt1 = xform.transform(point0)

                url = f"https://lookmap.eu.pythonanywhere.com/#c=14/"
                url = f"{url}{pt1.y()}/{pt1.x()}&p={pt1.y()}/{pt1.x()}&a={angle}/0"
                webbrowser.open_new(url)
            elif p == 'internet.gov':

                angle = math.atan2(point1.x() - point0.x(), point1.y() - point0.y())
                angle = math.degrees(angle)if angle>0 else (math.degrees(angle) + 180)+180

                crsDest = QgsCoordinateReferenceSystem(3857) #WGS84

                xform = QgsCoordinateTransform(actual_crs, crsDest,QgsProject.instance())
                pt1 = xform.transform(point0)

                url = f"https://internet.gov.pl/map/?"
                url = f"{url}center={pt1.x()};{pt1.y()}&zoom=19"
                webbrowser.open_new(url)

            QgsMessageLog.logMessage(f"{point0.y()}\t{point0.x()}")
            QgsMessageLog.logMessage(f"{url}")

            rl.reset()
            rb.reset()           
            self.canvas.unsetMapTool(self)           
        def activate(self):
            pass
    
        def deactivate(self):
            pass
           
        def isZoomTool(self):
            return False
    
        def isTransient(self):
            return False
    
        def isEditTool(self):
            return True    
