# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PowerClipboard
                                 A QGIS plugin
 Plugin give extended clipboard option to work with coords.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-04-16
        copyright            : (C) 2024 by Łukasz Świątek
        email                : lukasz.swiatek1996@gmail.com
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""

import subprocess
from qgis.core import Qgis
import os
import site


# noinspection PyPep8Naming
def classFactory(iface):  # pylint: disable=invalid-name
    """Load PowerClipboard class from file PowerClipboard.

    :param iface: A QGIS interface instance.
    :type iface: QgsInterface
    """
    #
    
    try:
        import pyperclip
    except ImportError:
        res = subprocess.call(['python3', "-m", "pip", "install", 'pyperclip'])
        site.addsitedir(os.path.abspath(os.path.dirname(__file__) + '/libs'))
        
        if res == 0:
            import pyperclip
        else:
            iface.messageBar().pushMessage('Power Clipboard',
                                           'Import modułu "pyperclip" zakończony niepowodzeniem, zalecamy manualne zainstalowanie zależności',
                                           level=Qgis.Warning, duration=3)
                                           
    from .power_clipboard import PowerClipboard
    return PowerClipboard(iface)
