# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PolygonClusterReducer
                                 A QGIS plugin
 This plugin removes polygons from the cluster, based on the user parameters.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-10-15
        git sha              : $Format:%H$
        copyright            : (C) 2018 by Zoran Petrović / Zoran-Software.com
        email                : zoran@zoran-software.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os.path
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication, QVariant
from PyQt5.QtGui import QIcon, QColor
from PyQt5.QtWidgets import QMessageBox
from PyQt5.QtWidgets import QAction

from qgis.core import QgsField, QgsSymbol, QgsRuleBasedRenderer, QgsWkbTypes
from qgis.utils import iface
# Import the code for the dialog
from .polygon_cluster_reducer_dialog import PolygonClusterReducerDialog
# Initialize Qt resources from file resources.py
from .resources import qt_resource_data
from .app_polygon_cluster_reducer import AppPolygonClusterReducer


class PolygonClusterReducer:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'PolygonClusterReducer_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Create the dialog (after translation) and keep reference
        self.dlg = PolygonClusterReducerDialog()

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&PolygonClusterReducer')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'PolygonClusterReducer')
        self.toolbar.setObjectName(u'PolygonClusterReducer')
        self.selected_features = []

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('PolygonClusterReducer', message)

    def add_action(
            self,
            icon_path,
            text,
            callback,
            enabled_flag=True,
            add_to_menu=True,
            add_to_toolbar=True,
            status_tip=None,
            whats_this=None,
            parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/polygon_cluster_reducer/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Poligon cluster reducer'),
            callback=self.run,
            parent=self.iface.mainWindow())
        self.dlg.btnRun.clicked.connect(self.process)
        self.dlg.btnPreviousSelection.clicked.connect(self.previous_selection)

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&PolygonClusterReducer'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    def run(self):
        """Run method that performs all the real work"""
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass

    def process(self):
        """Runs the algorithm."""
        # Set the defaults.
        field_name = "to_remove"
        search_radius = 0.0
        area_greater_than = 0.0
        area_less_than = 1000000.0
        is_random_order = False
        opacity_of_removed = 1.0
        # Get the input.
        field_name = self.dlg.txtFieldName.text()
        try:
            search_radius = float(self.dlg.txtSearchRadius.text())
        except ValueError:
            self.dlg.txtSearchRadius.text("Error: enter a number!")
            return
        try:
            search_radius = float(self.dlg.txtSearchRadius.text())
        except ValueError:
            self.dlg.txtSearchRadius.text("Error: enter a number!")
            return
        try:
            area_greater_than = float(self.dlg.txtAreaGreaterThan.text())
        except ValueError:
            self.dlg.txtAreaGreaterThan.text("Error: enter an number!")
            return
        try:
            area_less_than = float(self.dlg.txtAreaLessThan.text())
        except ValueError:
            self.dlg.txtAreaLessThan.text("Error: enter an number!")
            return

        is_random_order = self.dlg.chkRandomOrder.isChecked()
        opacity_of_removed = self.dlg.txtOpacityOfRemovedFeatures.value()
        opacity_of_removed /= 100.0

        self.selected_features = AppPolygonClusterReducer.run(
            field_name,
            search_radius,
            area_greater_than,
            area_less_than,
            is_random_order,
            opacity_of_removed)

    def previous_selection(self):
        """Selects features that were previously processed using this tool."""
        canvas = iface.mapCanvas()
        layer = canvas.currentLayer()
        layer.removeSelection()
        layer.selectByIds([f.id() for f in self.selected_features])
