# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PolygonLabeler
                                 A QGIS plugin
 Automatically generate and label polygons with custom names, and add the labels as a new attribute field to the attribute table.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-01-06
        git sha              : $Format:%H$
        email                : peterboateng06@gmail.com
 ***************************************************************************/

"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QVariant
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QMessageBox, QDialog, QVBoxLayout, QLineEdit, QPushButton, QFormLayout, QHBoxLayout
from qgis.core import (
    QgsProject,
    QgsVectorLayer,
    QgsField,
    QgsWkbTypes,
    edit,
    QgsPalLayerSettings,
    QgsVectorLayerSimpleLabeling,
    QgsMapLayerType
)
import os.path

class PolygonLabeler:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(self.plugin_dir, 'i18n', 'PolygonLabeler_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        self.actions = []
        self.menu = self.tr(u'&Polygon Labeler')
        self.first_start = None

    def tr(self, message):
        """Get the translation for a string using Qt translation API."""
        return QCoreApplication.translate('PolygonLabeler', message)

    def add_action(self, icon_path, text, callback, enabled_flag=True, add_to_menu=True, add_to_toolbar=True, status_tip=None, whats_this=None, parent=None):
        """Add a toolbar icon to the toolbar."""
        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToVectorMenu(self.menu, action)

        self.actions.append(action)
        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        icon_path = ':/plugins/Polygon Labeler/icon.png'
        self.add_action(icon_path, text=self.tr(u'Polygon Labeler'), callback=self.run, parent=self.iface.mainWindow())
        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginVectorMenu(self.tr(u'&Polygon Labeler'), action)
            self.iface.removeToolBarIcon(action)

    def run(self):
        """Run method that performs all the real work"""
        if self.first_start:
            self.first_start = False
            self.dlg = PolygonLabelerDialog()

        # Show the dialog to let the user configure the labeling options
        self.dlg.show()
        result = self.dlg.exec_()
        
        if result:
            # Retrieve user input from the dialog
            label_prefix = self.dlg.get_label_prefix()
            field_name = self.dlg.get_field_name()

            if not label_prefix or not field_name:
                QMessageBox.warning(None, "Error", "Both label prefix and field name must be provided.")
                return

            # Get the active layer
            layer = self.iface.activeLayer()
            if not layer or layer.type() != QgsMapLayerType.VectorLayer:
                QMessageBox.warning(None, "Error", "Please select a polygon vector layer.")
                return

            if layer.geometryType() != QgsWkbTypes.PolygonGeometry:
                QMessageBox.warning(None, "Error", "Selected layer is not a polygon layer.")
                return

            # Add a new field to the attribute table
            with edit(layer):
                if field_name not in [field.name() for field in layer.fields()]:
                    layer.dataProvider().addAttributes([QgsField(field_name, QVariant.String)])
                    layer.updateFields()

            # Generate labels for each polygon and update the new field
            with edit(layer):
                for feature in layer.getFeatures():
                    label = f"{label_prefix}{feature.id()}"  # Label format: prefix + feature ID
                    feature.setAttribute(field_name, label)
                    layer.updateFeature(feature)

            # Apply labels to the map
            self.add_labels(layer, field_name)
            QMessageBox.information(None, "Success", "Polygons labeled successfully!")

    def add_labels(self, layer, field_name):
        """Apply labeling to the layer."""
        label_settings = QgsPalLayerSettings()
        label_settings.fieldName = field_name
        label_settings.enabled = True

        labeling = QgsVectorLayerSimpleLabeling(label_settings)
        layer.setLabeling(labeling)
        layer.setLabelsEnabled(True)
        layer.triggerRepaint()

class PolygonLabelerDialog(QDialog):
    def __init__(self, parent=None):
        super().__init__(parent)

        self.setWindowTitle("Polygon Labeler")
        self.setModal(True)
        
        # Create layout
        layout = QVBoxLayout(self)
        
        # Form layout for input fields
        form_layout = QFormLayout()
        self.prefix_input = QLineEdit()
        self.field_input = QLineEdit()
        
        # Add form fields to the layout
        form_layout.addRow("Label Prefix:", self.prefix_input)
        form_layout.addRow("Field Name:", self.field_input)
        
        layout.addLayout(form_layout)

        # OK and Cancel buttons
        button_layout = QHBoxLayout()
        ok_button = QPushButton("OK")
        cancel_button = QPushButton("Cancel")
        
        ok_button.clicked.connect(self.accept)
        cancel_button.clicked.connect(self.reject)
        
        button_layout.addWidget(ok_button)
        button_layout.addWidget(cancel_button)
        
        layout.addLayout(button_layout)
        
        self.setLayout(layout)

    def get_label_prefix(self):
        """Get the label prefix entered by the user."""
        return self.prefix_input.text()

    def get_field_name(self):
        """Get the field name entered by the user."""
        return self.field_input.text()