# -*- coding: utf-8 -*-
"""
/***************************************************************************
 vgle
                                 A QGIS plugin
 This plugin groups framgented poylgons together.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-07-01
        git sha              : $Format:%H$
        copyright            : (C) 2024 by GOPA
        email                : gudmandras@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication,  QVariant
from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtGui import QIcon
from qgis.core import QgsProject, Qgis, QgsLayerTree, QgsLayerTreeLayer, QgsField, QgsVectorFileWriter, QgsVectorLayer, QgsExpression, QgsProcessingFeedback

from qgis.utils import iface
from qgis.core import QgsFieldProxyModel
from PyQt5.QtCore import Qt
import qgis.core

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from qgis.core import QgsApplication
from .vgle_provider import PolygonGrouperProvider
import os.path
import processing
import sys
import traceback
from qgis.core import QgsMessageLog, Qgis

MESSAGE_CATEGORY = 'Messages'

"""
def enable_remote_debugging():
    try:
        import ptvsd
        if ptvsd.is_attached():
            QgsMessageLog.logMessage("Remote Debug for Visual Studio is already active", MESSAGE_CATEGORY, Qgis.Info)
            return
        ptvsd.enable_attach(address=('localhost', 5678))
        QgsMessageLog.logMessage("Attached remote Debug for Visual Studio", MESSAGE_CATEGORY, Qgis.Info)
    except Exception as e:
        exc_type, exc_value, exc_traceback = sys.exc_info()
        format_exception = traceback.format_exception(exc_type, exc_value, exc_traceback)
        QgsMessageLog.logMessage(str(e), MESSAGE_CATEGORY, Qgis.Critical)        
        QgsMessageLog.logMessage(repr(format_exception[0]), MESSAGE_CATEGORY, Qgis.Critical)
        QgsMessageLog.logMessage(repr(format_exception[1]), MESSAGE_CATEGORY, Qgis.Critical)
        QgsMessageLog.logMessage(repr(format_exception[2]), MESSAGE_CATEGORY, Qgis.Critical)
"""


class vgle(object):
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        self.provider = None
        #enable_remote_debugging()
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'vgle_{}.qm'.format(locale))


        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('vgle', message)

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = PolygonGrouperProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()

        icon_path = ':/plugins/polygon_grouper/icon.png'
        self.action = QAction(QIcon(icon_path), 
            u'Polygon grouper',
            parent=self.iface.mainWindow())

        self.action.triggered.connect(self.run)
        self.iface.addPluginToVectorMenu(u"&VGLE", self.action)
        self.iface.addToolBarIcon(self.action)

        # will be set False in run()
        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        QgsApplication.processingRegistry().removeProvider(self.provider)
        self.iface.removePluginVectorMenu(u"&VGLE", self.action)
        self.iface.removeToolBarIcon(self.action)

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
        #import ptvsd
        #ptvsd.debug_this_thread()
        processing.execAlgorithmDialog("Polygon Grouper:polygon_grouper")

