# -*- coding: utf-8 -*-
"""
/***********************************************************
 PoliscopePlugin
                                 A QGIS plugin
 KI-basiertes Crawling von Ratsinformationssystemen der 5.000+ Planungsträger optimiert Ihre Flächensicherung und verschafft den Wissensvorsprung am Erneuerbare Energie - Markt.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-10-18
        git sha              : $Format:%H$
        copyright            : (C) 2024 by planGIS GmbH
        email                : s.wiemers@plangis.de
 ***********************************************************/

/***********************************************************
 *                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***********************************************************/
"""

import os
import webbrowser
from datetime import date, timedelta

from dateutil.relativedelta import relativedelta

from PyQt5 import QtWidgets, uic
from PyQt5.QtCore import QSettings, QDate
from PyQt5.QtWidgets import (
    QTabWidget, QInputDialog, QMessageBox, QLabel,
    QGroupBox, QCheckBox
)

from qgis.core import QgsRectangle, QgsCoordinateReferenceSystem, QgsCoordinateTransform, QgsProject
from qgis.utils import iface

from qgis.PyQt.QtCore import QSettings as QgisQSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QApplication

from qgis.gui import QgsCollapsibleGroupBox

from .resources import *
from .ui.poliscope_plugin_dockwidget import PoliscopePluginDockWidget
from .ui.list_missing_api_key_error_widget import ListMissingApiKeyErrorWidget
from .ui.list_wrong_plugin_version_error_widget import ListWrongPluginVersionErrorWidget
from .ui.list_item_widget import ListItemWidget
from .ui.detail_dialog import DetailDialog
from .utils.utils import Utils
from .api.poliscopeAPI import Meeting, MeetingsAPI


class PoliscopePlugin:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)

        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir, 'i18n', f'PoliscopePlugin_{locale}.qm')

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        self.actions = []
        self.menu = self.tr(u'&Poliscope Plugin')
        self.toolbar = self.iface.addToolBar(u'PoliscopePlugin')
        self.toolbar.setObjectName(u'PoliscopePlugin')

        self.pluginIsActive = False
        self.dockwidget = None
        self.nr = 0
        self.QGIS_PLUGIN_VERSION_UP2DATE = True

        self.currPage_news = 1
        self.currPage_search = 1
        self.currPage_watchlist = 1

        self.sortString_news = ""
        self.sortString_search = ""
        self.sortString_watchlist = ""

        self.filter_news = {}
        self.filter_search = {}
        self.filter_watchlist = {}

        self.meetings_count_news = 0
        self.meetings_count_search = 0
        self.meetings_count_watchlist = 0

        self.entityRSCodes_news = []

        self.BBoxSearchClicked = False
        self.CenterSearchClicked = False

    def tr(self, message):
        return QCoreApplication.translate('PoliscopePlugin', message)

    def add_action(self, icon_path, text, callback, enabled_flag=True, add_to_menu=True, add_to_toolbar=True, status_tip=None, whats_this=None, parent=None):
        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(self.menu, action)

        self.actions.append(action)
        return action

    def initGui(self):
        icon_path = ':/plugins/poliscope_plugin/icon.png'
        self.add_action(icon_path, text=self.tr(u'Poliscope Plugin'),
                        callback=self.run, parent=self.iface.mainWindow())
        self.run()

    def onClosePlugin(self):
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)
        self.pluginIsActive = False

    def unload(self):
        for action in self.actions:
            self.iface.removePluginMenu(self.tr(u'&Poliscope Plugin'), action)
            self.iface.removeToolBarIcon(action)
        del self.toolbar

    def run(self):
        if not self.pluginIsActive:

            if self.dockwidget is None:
                self.dockwidget = PoliscopePluginDockWidget()

            self.dockwidget.closingPlugin.connect(self.onClosePlugin)
            self.list_widget = self.dockwidget.newsList
            self.iface.addDockWidget(Qt.RightDockWidgetArea, self.dockwidget)

            self.tabWidget = self.dockwidget.findChild(QTabWidget, "tabWidget")

            settings = QSettings()
            settings.beginGroup("PoliscopePlugin")
            api_key = settings.value("api_key", "", type=str)
            settings.endGroup()
            try:
                self.api = MeetingsAPI(api_key=api_key)
            except Exception as e:
                print(f"Fehler beim Initialisieren der API: {e}")
                self.api = None

            # Score Variables
            self.windScore = 0
            self.pvScore = 0
            self.focusregion_id = None

            ########################
            # Tab Neuigkeiten
            # Meetingliste
            self.newsList = self.dockwidget.findChild(
                QtWidgets.QListWidget, "newsList")
            # Eventhandelt den Scrollwert
            self.newsList.verticalScrollBar().valueChanged.connect(
                self.check_scroll_position_news)

            # Sortierbox
            self.cgbNews = self.dockwidget.findChild(
                QgsCollapsibleGroupBox, "cgbNews")
            # Fokusregionen

            self.gbFocusregions_news = self.dockwidget.findChild(
                QGroupBox, "gbFocusregions_news")
            if self.api:
                self.clearAndFillFoxsregionGroupbox(self.gbFocusregions_news)
            else:
                self.clearFocusregionGroupbox(self.gbFocusregions_news)
            # Suchzeit
            self.dateBegin_news = self.dockwidget.findChild(
                QtWidgets.QDateTimeEdit, "mteBegin_news")
            self.dateEnd_news = self.dockwidget.findChild(
                QtWidgets.QDateTimeEdit, "mteEnd_news")
            # Zeit Buttons
            self.dockwidget.pbNext30Days_news.clicked.connect(
                self.setDateNext30Days_news)
            self.dockwidget.pbLast30Days_news.clicked.connect(
                self.setDateLast30Days_news)
            self.dockwidget.pbThisYear_news.clicked.connect(
                self.setDateThisYear_news)
            self.dockwidget.pbLastYear_news.clicked.connect(
                self.setDateLastYear_news)
            # Scores
            # Wind
            self.pbDeleteWindScore_news = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbDeleteWindScore_news")
            self.pbWindScore1_news = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbWindScore1_news")
            self.pbWindScore2_news = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbWindScore2_news")
            self.pbWindScore3_news = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbWindScore3_news")
            self.dockwidget.pbDeleteWindScore_news.clicked.connect(
                self.pbDeleteWindScoreClicked_news)
            self.dockwidget.pbWindScore1_news.clicked.connect(
                self.pbWindScore1Clicked_news)
            self.dockwidget.pbWindScore2_news.clicked.connect(
                self.pbWindScore2Clicked_news)
            self.dockwidget.pbWindScore3_news.clicked.connect(
                self.pbWindScore3Clicked_news)
            # PV
            self.pbDeletePVScore_news = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbDeletePVScore_news")
            self.pbPVScore1_news = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbPVScore1_news")
            self.pbPVScore2_news = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbPVScore2_news")
            self.pbPVScore3_news = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbPVScore3_news")
            self.dockwidget.pbDeletePVScore_news.clicked.connect(
                self.pbDeletePVScoreClicked_news)
            self.dockwidget.pbPVScore1_news.clicked.connect(
                self.pbPVScore1Clicked_news)
            self.dockwidget.pbPVScore2_news.clicked.connect(
                self.pbPVScore2Clicked_news)
            self.dockwidget.pbPVScore3_news.clicked.connect(
                self.pbPVScore3Clicked_news)
            # Status
            self.rbStatusAll_news = self.dockwidget.findChild(
                QtWidgets.QRadioButton, "rbStatusAll_news")
            self.rbStatusWithBeschlussVorlage_news = self.dockwidget.findChild(
                QtWidgets.QRadioButton, "rbStatusWithBeschlussVorlage_news")
            self.rbStatusWithBeschluss_news = self.dockwidget.findChild(
                QtWidgets.QRadioButton, "rbStatusWithBeschluss_news")
            # Speicher
            self.cbSpeicherHiddenMeetings_news = self.dockwidget.findChild(
                QtWidgets.QCheckBox, "cbSpeicherHiddenMeetings_news")
            self.cbSpeicherNotSaved_news = self.dockwidget.findChild(
                QtWidgets.QCheckBox, "cbSpeicherNotSaved_news")
            self.cbSpeicherSaved_news = self.dockwidget.findChild(
                QtWidgets.QCheckBox, "cbSpeicherSaved_news")
            # Sortierung
            self.cobSortBy_news = self.dockwidget.findChild(
                QtWidgets.QComboBox, "cobSortBy_news")

            # Anzahl Meetings
            self.lMeetingCount_news = self.dockwidget.findChild(
                QtWidgets.QLabel, "lMeetingCount_news")

            # Aktualisierungsbutton
            if self.api and self.QGIS_PLUGIN_VERSION_UP2DATE:
                self.dockwidget.newsRefButton.setEnabled(True)
            else:
                self.dockwidget.newsRefButton.setEnabled(False)
            self.dockwidget.newsRefButton.clicked.connect(
                self.btnHandlerRefresh)
            # Optionsbutton
            self.dockwidget.pbOptions_news.clicked.connect(self.showOptions)

            # INIT Date on NEWS
            todayLastYear = date.today() - relativedelta(months=12)
            todayPlusTwoMonths = date.today() + relativedelta(months=2)
            self.dateBegin_news.setDate(
                QDate(todayLastYear.year, todayLastYear.month, todayLastYear.day))
            self.dateEnd_news.setDate(
                QDate(todayPlusTwoMonths.year, todayPlusTwoMonths.month, todayPlusTwoMonths.day))
            begin_str = todayLastYear.strftime("%d.%m.%y")
            end_str = todayPlusTwoMonths.strftime("%d.%m.%y")
            self.setCgbTitleNews(begin_str + " - " + end_str)

            ########################
            # Tab Suche
            # Meetingliste
            self.searchList = self.dockwidget.findChild(
                QtWidgets.QListWidget, "searchList")
            # Eventhandelt den Scrollwert
            self.searchList.verticalScrollBar().valueChanged.connect(
                self.check_scroll_position_search)
            # Sortierbox
            self.cgbSearch = self.dockwidget.findChild(
                QgsCollapsibleGroupBox, "cgbSearch")
            # Fokusregionen
            self.gbFocusregions_search = self.dockwidget.findChild(
                QgsCollapsibleGroupBox, "gbFocusregions_search")
            # Suchzeit
            self.dateBegin_search = self.dockwidget.findChild(
                QtWidgets.QDateTimeEdit, "mteBegin_search")
            self.dateEnd_search = self.dockwidget.findChild(
                QtWidgets.QDateTimeEdit, "mteEnd_search")
            # Zeit Buttons
            self.dockwidget.pbNext30Days_search.clicked.connect(
                self.setDateNext30Days_search)
            self.dockwidget.pbLast30Days_search.clicked.connect(
                self.setDateLast30Days_search)
            self.dockwidget.pbThisYear_search.clicked.connect(
                self.setDateThisYear_search)
            self.dockwidget.pbLastYear_search.clicked.connect(
                self.setDateLastYear_search)
            # Scores
            # Wind
            self.pbDeleteWindScore_search = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbDeleteWindScore_search")
            self.pbWindScore1_search = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbWindScore1_search")
            self.pbWindScore2_search = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbWindScore2_search")
            self.pbWindScore3_search = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbWindScore3_search")
            self.dockwidget.pbDeleteWindScore_search.clicked.connect(
                self.pbDeleteWindScoreClicked_search)
            self.dockwidget.pbWindScore1_search.clicked.connect(
                self.pbWindScore1Clicked_search)
            self.dockwidget.pbWindScore2_search.clicked.connect(
                self.pbWindScore2Clicked_search)
            self.dockwidget.pbWindScore3_search.clicked.connect(
                self.pbWindScore3Clicked_search)
            # PV
            self.pbDeletePVScore_search = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbDeletePVScore_search")
            self.pbPVScore1_search = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbPVScore1_search")
            self.pbPVScore2_search = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbPVScore2_search")
            self.pbPVScore3_search = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbPVScore3_search")
            self.dockwidget.pbDeletePVScore_search.clicked.connect(
                self.pbDeletePVScoreClicked_search)
            self.dockwidget.pbPVScore1_search.clicked.connect(
                self.pbPVScore1Clicked_search)
            self.dockwidget.pbPVScore2_search.clicked.connect(
                self.pbPVScore2Clicked_search)
            self.dockwidget.pbPVScore3_search.clicked.connect(
                self.pbPVScore3Clicked_search)
            # Status
            self.rbStatusAll_search = self.dockwidget.findChild(
                QtWidgets.QRadioButton, "rbStatusAll_search")
            self.rbStatusWithBeschlussVorlage_search = self.dockwidget.findChild(
                QtWidgets.QRadioButton, "rbStatusWithBeschlussVorlage_search")
            self.rbStatusWithBeschluss_search = self.dockwidget.findChild(
                QtWidgets.QRadioButton, "rbStatusWithBeschluss_search")
            # Speicher
            self.cbSpeicherHiddenMeetings_search = self.dockwidget.findChild(
                QtWidgets.QCheckBox, "cbSpeicherHiddenMeetings_search")
            self.cbSpeicherNotSaved_search = self.dockwidget.findChild(
                QtWidgets.QCheckBox, "cbSpeicherNotSaved_search")
            self.cbSpeicherSaved_search = self.dockwidget.findChild(
                QtWidgets.QCheckBox, "cbSpeicherSaved_search")
            # Sortierung
            self.cobSortBy_search = self.dockwidget.findChild(
                QtWidgets.QComboBox, "cobSortBy_search")

            # Anzahl Meetings
            self.lMeetingCount_search = self.dockwidget.findChild(
                QtWidgets.QLabel, "lMeetingCount_search")

            # Aktualisierungsbutton
            if self.api and self.QGIS_PLUGIN_VERSION_UP2DATE:
                self.dockwidget.searchBbSearchButton.setEnabled(True)
                self.dockwidget.searchCenterSearchButton.setEnabled(True)
            else:
                self.dockwidget.searchBbSearchButton.setEnabled(False)
                self.dockwidget.searchBbSearchButton.setEnabled(False)
            self.dockwidget.searchBbSearchButton.clicked.connect(
                self.btnBBSearchClicked)
            self.dockwidget.searchCenterSearchButton.clicked.connect(self.btnCenterSearchClicked)
            # Optionsbutton
            self.dockwidget.pbOptions_search.clicked.connect(self.showOptions)

            # INIT Date on SEARCH
            todayLastYear = date.today() - relativedelta(months=12)
            todayPlusTwoMonths = date.today() + relativedelta(months=2)
            self.dateBegin_search.setDate(
                QDate(todayLastYear.year, todayLastYear.month, todayLastYear.day))
            self.dateEnd_search.setDate(
                QDate(todayPlusTwoMonths.year, todayPlusTwoMonths.month, todayPlusTwoMonths.day))
            begin_str = todayLastYear.strftime("%d.%m.%y")
            end_str = todayPlusTwoMonths.strftime("%d.%m.%y")
            self.setCgbTitleSearch(begin_str + " - " + end_str)

            ########################
            # Tab Merkliste
            # Meetingliste
            self.watchlistList = self.dockwidget.findChild(
                QtWidgets.QListWidget, "watchlistList")
            # Eventhandelt den Scrollwert
            self.watchlistList.verticalScrollBar().valueChanged.connect(
                self.check_scroll_position_watchlist)
            # Sortierbox
            self.cgbWatchlist = self.dockwidget.findChild(
                QgsCollapsibleGroupBox, "cgbWatchlist")
            # Fokusregionen
            self.gbFocusregions_watchlist = self.dockwidget.findChild(
                QgsCollapsibleGroupBox, "gbFocusregions_watchlist")
            # Suchzeit
            self.dateBegin_watchlist = self.dockwidget.findChild(
                QtWidgets.QDateTimeEdit, "mteBegin_watchlist")
            self.dateEnd_watchlist = self.dockwidget.findChild(
                QtWidgets.QDateTimeEdit, "mteEnd_watchlist")
            # Zeit Buttons
            self.dockwidget.pbNext30Days_watchlist.clicked.connect(
                self.setDateNext30Days_watchlist)
            self.dockwidget.pbLast30Days_watchlist.clicked.connect(
                self.setDateLast30Days_watchlist)
            self.dockwidget.pbThisYear_watchlist.clicked.connect(
                self.setDateThisYear_watchlist)
            self.dockwidget.pbLastYear_watchlist.clicked.connect(
                self.setDateLastYear_watchlist)
            # Scores
            # Wind
            self.pbDeleteWindScore_watchlist = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbDeleteWindScore_watchlist")
            self.pbWindScore1_watchlist = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbWindScore1_watchlist")
            self.pbWindScore2_watchlist = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbWindScore2_watchlist")
            self.pbWindScore3_watchlist = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbWindScore3_watchlist")
            self.dockwidget.pbDeleteWindScore_watchlist.clicked.connect(
                self.pbDeleteWindScoreClicked_watchlist)
            self.dockwidget.pbWindScore1_watchlist.clicked.connect(
                self.pbWindScore1Clicked_watchlist)
            self.dockwidget.pbWindScore2_watchlist.clicked.connect(
                self.pbWindScore2Clicked_watchlist)
            self.dockwidget.pbWindScore3_watchlist.clicked.connect(
                self.pbWindScore3Clicked_watchlist)
            # PV
            self.pbDeletePVScore_watchlist = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbDeletePVScore_watchlist")
            self.pbPVScore1_watchlist = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbPVScore1_watchlist")
            self.pbPVScore2_watchlist = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbPVScore2_watchlist")
            self.pbPVScore3_watchlist = self.dockwidget.findChild(
                QtWidgets.QPushButton, "pbPVScore3_watchlist")
            self.dockwidget.pbDeletePVScore_watchlist.clicked.connect(
                self.pbDeletePVScoreClicked_watchlist)
            self.dockwidget.pbPVScore1_watchlist.clicked.connect(
                self.pbPVScore1Clicked_watchlist)
            self.dockwidget.pbPVScore2_watchlist.clicked.connect(
                self.pbPVScore2Clicked_watchlist)
            self.dockwidget.pbPVScore3_watchlist.clicked.connect(
                self.pbPVScore3Clicked_watchlist)
            # Status
            self.rbStatusAll_watchlist = self.dockwidget.findChild(
                QtWidgets.QRadioButton, "rbStatusAll_watchlist")
            self.rbStatusWithBeschlussVorlage_watchlist = self.dockwidget.findChild(
                QtWidgets.QRadioButton, "rbStatusWithBeschlussVorlage_watchlist")
            self.rbStatusWithBeschluss_watchlist = self.dockwidget.findChild(
                QtWidgets.QRadioButton, "rbStatusWithBeschluss_watchlist")
            # Speicher
            self.cbSpeicherHiddenMeetings_watchlist = self.dockwidget.findChild(
                QtWidgets.QCheckBox, "cbSpeicherHiddenMeetings_watchlist")
            self.cbSpeicherNotSaved_watchlist = self.dockwidget.findChild(
                QtWidgets.QCheckBox, "cbSpeicherNotSaved_watchlist")
            self.cbSpeicherSaved_watchlist = self.dockwidget.findChild(
                QtWidgets.QCheckBox, "cbSpeicherSaved_watchlist")
            # Sortierung
            self.cobSortBy_watchlist = self.dockwidget.findChild(
                QtWidgets.QComboBox, "cobSortBy_watchlist")

            # Anzahl Meetings
            self.lMeetingCount_watchlist = self.dockwidget.findChild(
                QtWidgets.QLabel, "lMeetingCount_watchlist")

            # Aktualisierungsbutton
            if self.api and self.QGIS_PLUGIN_VERSION_UP2DATE:
                self.dockwidget.watchlistRefButton.setEnabled(True)
            else:
                self.dockwidget.watchlistRefButton.setEnabled(False)
            self.dockwidget.watchlistRefButton.clicked.connect(
                self.btnHandlerRefresh)
            # Optionsbutton
            self.dockwidget.pbOptions_watchlist.clicked.connect(
                self.showOptions)

            # INIT Date on WATCHLIST
            todayLastYear = date.today() - relativedelta(months=12)
            todayPlusTwoMonths = date.today() + relativedelta(months=2)
            self.dateBegin_watchlist.setDate(
                QDate(todayLastYear.year, todayLastYear.month, todayLastYear.day))
            self.dateEnd_watchlist.setDate(
                QDate(todayPlusTwoMonths.year, todayPlusTwoMonths.month, todayPlusTwoMonths.day))
            begin_str = todayLastYear.strftime("%d.%m.%y")
            end_str = todayPlusTwoMonths.strftime("%d.%m.%y")
            self.setCgbTitleWatchlist(begin_str + " - " + end_str)

            # Items auf die Listen setzen, wenn API nicht verfügbar ist
            if self.api is None:
                # Set the error item in the list widgets
                self.addMissingApiKeyItemToList(self.dockwidget.newsList)
                self.addMissingApiKeyItemToList(self.dockwidget.searchList)
                self.addMissingApiKeyItemToList(self.dockwidget.watchlistList)

            # QGIS Plugin Version Prüfen
            if self.api and Utils.get_plugin_version()[:3] != self.api.get_qgis_plugin_version()[:3]:
                self.QGIS_PLUGIN_VERSION_UP2DATE = False
                self.addWrongPluginVersionItemToList(self.dockwidget.newsList)
                self.addWrongPluginVersionItemToList(
                    self.dockwidget.searchList)
                self.addWrongPluginVersionItemToList(
                    self.dockwidget.watchlistList)

            # Show the dock widget
            self.dockwidget.setWindowTitle(self.tr(u'Poliscope Plugin'))
            icon_path = ":/plugins/poliscope_plugin/resources/icons/icon.png"
            self.dockwidget.setWindowIcon(QIcon(icon_path))

        self.dockwidget.show()
        self.pluginIsActive = True

    def addWrongPluginVersionItemToList(self, list_widget: QtWidgets.QListWidget):
        item_widget = ListWrongPluginVersionErrorWidget()
        item = QtWidgets.QListWidgetItem()
        item.setSizeHint(item_widget.sizeHint())
        list_widget.addItem(item)
        list_widget.setItemWidget(item, item_widget)

    def addMissingApiKeyItemToList(self, list_widget: QtWidgets.QListWidget):
        item_widget = ListMissingApiKeyErrorWidget()
        item = QtWidgets.QListWidgetItem()
        item.setSizeHint(item_widget.sizeHint())
        list_widget.addItem(item)
        list_widget.setItemWidget(item, item_widget)

    def btnBBSearchClicked(self):
        self.BBoxSearchClicked = True
        self.btnHandlerRefresh()

    def btnCenterSearchClicked(self):
        self.CenterSearchClicked = True
        self.btnHandlerRefresh()

    def btnHandlerRefresh(self):
        self.filter_news = {}
        self.filter_search = {}
        self.filter_watchlist = {}
        meetings = []

        current_index = self.tabWidget.currentIndex()
        current_tab_text = self.tabWidget.tabText(current_index)

        if self.api:
            if current_tab_text == "Neuigkeiten":

                self.setRefNewsButton2Loading()
                self.dockwidget.newsList.clear()
                # Filter
                self.filter_news = self.getFilters_news()
                # self.fetch_and_display_meetings_news()
                self.list_widget = self.dockwidget.newsList

                # Sortierung
                self.sortString_news = Utils.convertSortStringToAPI(
                    str(self.cobSortBy_news.currentText()))

                # Prüfen der Fokusregionen
                checkedFocusregionsIDs = []
                for checkbox in self.gbFocusregions_news.findChildren(QCheckBox):
                    if checkbox.isChecked():
                        checkedFocusregionsIDs.append(checkbox.property("id"))

                # Use focusregion endpoint if focusregions are selected
                if checkedFocusregionsIDs:
                    self.meetings_count_news = self.api.get_focusregion_meetings_count(
                        filters=self.filter_news, focusregion_ids=checkedFocusregionsIDs)

                    # Abrufen der Meetings
                    meetings = self.api.get_focusregion_meetings(
                        filters=self.filter_news, focusregion_ids=checkedFocusregionsIDs, sortString=self.sortString_news)
                else:
                    # No focusregions selected - return empty results
                    self.meetings_count_news = 0
                    meetings = []

                if self.meetings_count_news == 0:
                    self.lMeetingCount_news.setText(
                        "Keine Sitzungen gefunden")
                elif self.meetings_count_news == 1:
                    self.lMeetingCount_news.setText(
                        "1 Sitzung gefunden")
                else:
                    self.lMeetingCount_news.setText(
                        f"{self.meetings_count_news} Sitzungen gefunden")

                self.currPage_news = 1
                # Set the meetings to the list
                self.setMeetingsToList(meetings)
                self.setRefNewsButton2Normal()

            elif current_tab_text == "Suche":
                self.setRefSearchButton2Loading()
                if self.BBoxSearchClicked:
                    coords = Utils.get_current_canvas_bbox_polygon_epsg4326(
                        self.iface)
                else:
                    coords = Utils.get_current_canvas_bbox_center_epsg4326(
                        self.iface)
                if coords is not None:
                    self.filter_search = self.getFilterInformation_search(
                        coords)
                    self.dockwidget.searchList.clear()
                    self.list_widget = self.dockwidget.searchList

                    # Sortierung
                    self.sortString_search = Utils.convertSortStringToAPI(
                        self.cobSortBy_search.currentText())

                    self.meetings_count_search = self.api.get_meetings_count(
                        filters=self.filter_search, entityRSCodes=[])

                    # Abrufen der Meetings
                    meetings = self.api.get_meetings(
                        filters=self.filter_search, entityRSCodes=[], sortString=self.sortString_search)

                    # Anzahl Meetings
                    if self.meetings_count_search == 0:
                        self.lMeetingCount_search.setText(
                            "Keine Sitzungen gefunden")
                    elif self.meetings_count_search == 1:
                        self.lMeetingCount_search.setText(
                            "1 Sitzung gefunden")
                    else:
                        self.lMeetingCount_search.setText(
                            f"{self.meetings_count_search} Sitzungen gefunden")
                else:
                    meetings = []
                    self.lMeetingCount_search.setText(
                        f"0 Sitzungen gefunden")

                self.currPage_search = 1
                # Set the meetings to the list
                self.setMeetingsToList(meetings)
                self.setRefSearchButton2Normal()
                self.BBoxSearchClicked = False
                self.CenterSearchClicked = False

            elif current_tab_text == "Merkliste":
                self.setRefWatchlistButton2Loading()
                self.dockwidget.watchlistList.clear()
                self.filter_watchlist = self.getFilterInformation_watchlist()
                # self.fetch_and_display_meetings_watchlist()
                self.list_widget = self.dockwidget.watchlistList

                # Sortierung
                self.sortString_watchlist = Utils.convertSortStringToAPI(
                    self.cobSortBy_news.currentText())

                self.meetings_count_watchlist = self.api.get_bookmarked_meetings_count(
                    filters=self.filter_watchlist)

                # Abrufen der Meetings
                meetings = self.api.get_bookmarked_meetings(
                    filters=self.filter_watchlist, sortString=self.sortString_watchlist)

                if self.meetings_count_watchlist == 0:
                    self.lMeetingCount_watchlist.setText(
                        "Keine Sitzungen gefunden")
                elif self.meetings_count_watchlist == 1:
                    self.lMeetingCount_watchlist.setText(
                        "1 Sitzung gefunden")
                else:
                    self.lMeetingCount_watchlist.setText(
                        f"{self.meetings_count_watchlist} Sitzungen gefunden")

                self.currPage_watchlist = 1
                # Set the meetings to the list
                self.setMeetingsToList(meetings)
                self.setRefWatchlistButton2Normal()


    def setMeetingsToList(self, meetings):
        # Todo: für die anderen Tabs
        for meeting in meetings:
            pvScore = meeting.solar_score
            windScore = meeting.wind_score

            text = meeting.title
            description = meeting.description

            item_widget = ListItemWidget()

            item_widget.lTitle.setText(text)
            if description is not None:
                item_widget.lDescription.setText(description)
            else:
                layout = item_widget.lDescription.parent().layout()
                if layout is not None:
                    layout.removeWidget(item_widget.lDescription)
                item_widget.lDescription.deleteLater()
                item_widget.lDescription = None

            item_widget.lDate.setText(Utils.format_date(meeting.date))
            item_widget.lLastStatusUpdate.setText(
                Utils.format_last_status_update(meeting.last_status_update))
            item_widget.lRISBreadcrumbs.setText(
                Utils.buildRISBreadcrumbs(meeting))

            # PV Score
            Utils.setPVScore(item_widget, pvScore)

            # Wind Score
            Utils.setWindScore(item_widget, windScore)

            # Set Line
            Utils.setLineIcon(item_widget, meeting.status)

            # Set Location
            item_widget.lLocation.setText(
                Utils.getLocationString(meeting.rsName))

            item_widget.lLocation.mousePressEvent = lambda event, rs=meeting.rs: self.openLocationInQGIS(
                event, rs)

            item = QtWidgets.QListWidgetItem(self.list_widget)
            item.setSizeHint(item_widget.sizeHint())

            # Set Documents
            countDocuments = len(meeting.relevant_documents) + \
                len(meeting.relevant_agenda_items_relevant_documents)

            item_widget.lDocuments.setText(
                Utils.getDocumentsCountString(countDocuments))

            # Buttons
            # Details
            item_widget.pbDetails.clicked.connect(
                lambda checked=False, m=meeting: self.showDetailDialog(m))
            # Open RIS
            item_widget.pbOpenRIS.clicked.connect(
                lambda _, url=meeting.url: webbrowser.open(url))

            # Bookmark
            if meeting.bookmark_id:
                item_widget.pbBookmark.setChecked(True)
            item_widget.pbBookmark.clicked.connect(
                lambda checked=False, m=meeting: self.bookmarkButtonPressed(m))
            # Open in WEB App
            urlSaveTitle = Utils.slugify(meeting.title)
            item_widget.pbWeb.clicked.connect(
                lambda _, mrs=meeting.rs, ust=urlSaveTitle, mid=meeting.id: webbrowser.open(f"https://app.poliscope.de/entity/{mrs}/{ust}/{mid}"))

            container = QtWidgets.QWidget()
            container.setObjectName("container")
            layout = QtWidgets.QVBoxLayout(container)
            layout.setContentsMargins(0, 0, 0, 0)
            layout.addWidget(item_widget)

            # Stil nur auf Container setzen
            if self.nr % 2 == 0:
                container.setStyleSheet("background-color: #ffffff;")
            else:
                container.setStyleSheet("background-color: #eeeeee;")
            item.setSizeHint(container.sizeHint())

            # Größe dynamisch aktualisieren
            item_widget.updateGeometry()
            container.updateGeometry()
            item.setSizeHint(container.sizeHint())

            self.list_widget.addItem(item)
            self.list_widget.setItemWidget(item, container)
            self.list_widget.update()
            self.nr += 1

    def showDetailDialog(self, meeting):
        dialog = DetailDialog()
        dialog.openInDialog(meeting)

    def getDocumentsCount(self, meeting):
        pass

    def bookmarkButtonPressed(self, meeting):
        if meeting.bookmark_id:
            # Remove bookmark
            self.api.remove_meeting_bookmark(meeting.id)
        else:
            # Add bookmark
            self.api.bookmark_meeting(meeting.id)

        # self.btnHandlerRefresh()

    # Datumsfunktionen für die News
    def setDateLast30Days_news(self):
        today = date.today()
        last_30_days = today - timedelta(days=30)
        self.dateBegin_news.setDate(
            QDate(last_30_days.year, last_30_days.month, last_30_days.day))
        self.dateEnd_news.setDate(QDate(today.year, today.month, today.day))
        end_str = today.strftime("%d.%m.%y")
        begin_str = last_30_days.strftime("%d.%m.%y")
        self.setCgbTitleNews(begin_str + " - " + end_str)

    def setDateNext30Days_news(self):
        today = date.today()
        next_30_days = today + timedelta(days=30)
        self.dateBegin_news.setDate(QDate(today.year, today.month, today.day))
        self.dateEnd_news.setDate(
            QDate(next_30_days.year, next_30_days.month, next_30_days.day))
        begin_str = today.strftime("%d.%m.%y")
        end_str = next_30_days.strftime("%d.%m.%y")
        self.setCgbTitleNews(begin_str + " - " + end_str)

    def setDateThisYear_news(self):
        today = date.today()
        self.dateBegin_news.setDate(QDate(today.year, 1, 1))
        self.dateEnd_news.setDate(QDate(today.year, 12, 31))
        begin_str = date(today.year, 1, 1).strftime("%d.%m.%y")
        end_str = date(today.year, 12, 31).strftime("%d.%m.%y")
        self.setCgbTitleNews(begin_str + " - " + end_str)

    def setDateLastYear_news(self):
        today = date.today()
        last_year = today.year - 1
        self.dateBegin_news.setDate(QDate(last_year, 1, 1))
        self.dateEnd_news.setDate(QDate(last_year, 12, 31))
        begin_str = date(last_year, 1, 1).strftime("%d.%m.%y")
        end_str = date(last_year, 12, 31).strftime("%d.%m.%y")
        self.setCgbTitleNews(begin_str + " - " + end_str)

    # Datumsfunktionen für die Search
    def setDateLast30Days_search(self):
        today = date.today()
        last_30_days = today - timedelta(days=30)
        self.dateBegin_search.setDate(
            QDate(last_30_days.year, last_30_days.month, last_30_days.day))
        self.dateEnd_search.setDate(QDate(today.year, today.month, today.day))
        end_str = today.strftime("%d.%m.%y")
        begin_str = last_30_days.strftime("%d.%m.%y")
        self.setCgbTitleSearch(begin_str + " - " + end_str)

    def setDateNext30Days_search(self):
        today = date.today()
        next_30_days = today + timedelta(days=30)
        self.dateBegin_search.setDate(
            QDate(today.year, today.month, today.day))
        self.dateEnd_search.setDate(
            QDate(next_30_days.year, next_30_days.month, next_30_days.day))
        begin_str = today.strftime("%d.%m.%y")
        end_str = next_30_days.strftime("%d.%m.%y")
        self.setCgbTitleSearch(begin_str + " - " + end_str)

    def setDateThisYear_search(self):
        today = date.today()
        self.dateBegin_search.setDate(QDate(today.year, 1, 1))
        self.dateEnd_search.setDate(QDate(today.year, 12, 31))
        begin_str = date(today.year, 1, 1).strftime("%d.%m.%y")
        end_str = date(today.year, 12, 31).strftime("%d.%m.%y")
        self.setCgbTitleSearch(begin_str + " - " + end_str)

    def setDateLastYear_search(self):
        today = date.today()
        last_year = today.year - 1
        self.dateBegin_search.setDate(QDate(last_year, 1, 1))
        self.dateEnd_search.setDate(QDate(last_year, 12, 31))
        begin_str = date(last_year, 1, 1).strftime("%d.%m.%y")
        end_str = date(last_year, 12, 31).strftime("%d.%m.%y")
        self.setCgbTitleSearch(begin_str + " - " + end_str)

    ## Datumsfunktionen für die Watchlist#
    def setDateLast30Days_watchlist(self):
        today = date.today()
        last_30_days = today - timedelta(days=30)
        self.dateBegin_watchlist.setDate(
            QDate(last_30_days.year, last_30_days.month, last_30_days.day))
        self.dateEnd_watchlist.setDate(
            QDate(today.year, today.month, today.day))
        end_str = today.strftime("%d.%m.%y")
        begin_str = last_30_days.strftime("%d.%m.%y")
        self.setCgbTitleWatchlist(begin_str + " - " + end_str)

    def setDateNext30Days_watchlist(self):
        today = date.today()
        next_30_days = today + timedelta(days=30)
        self.dateBegin_watchlist.setDate(
            QDate(today.year, today.month, today.day))
        self.dateEnd_watchlist.setDate(
            QDate(next_30_days.year, next_30_days.month, next_30_days.day))
        begin_str = today.strftime("%d.%m.%y")
        end_str = next_30_days.strftime("%d.%m.%y")
        self.setCgbTitleWatchlist(begin_str + " - " + end_str)

    def setDateThisYear_watchlist(self):
        today = date.today()
        self.dateBegin_watchlist.setDate(QDate(today.year, 1, 1))
        self.dateEnd_watchlist.setDate(QDate(today.year, 12, 31))
        begin_str = date(today.year, 1, 1).strftime("%d.%m.%y")
        end_str = date(today.year, 12, 31).strftime("%d.%m.%y")
        self.setCgbTitleWatchlist(begin_str + " - " + end_str)

    def setDateLastYear_watchlist(self):
        today = date.today()
        last_year = today.year - 1
        self.dateBegin_watchlist.setDate(QDate(last_year, 1, 1))
        self.dateEnd_watchlist.setDate(QDate(last_year, 12, 31))
        begin_str = date(last_year, 1, 1).strftime("%d.%m.%y")
        end_str = date(last_year, 12, 31).strftime("%d.%m.%y")
        self.setCgbTitleWatchlist(begin_str + " - " + end_str)

    # Scores News
    def pbDeleteWindScoreClicked_news(self):
        self.pbWindScore1_news.setChecked(False)
        self.pbWindScore2_news.setChecked(False)
        self.pbWindScore3_news.setChecked(False)
        self.windScore = 0

    def pbWindScore1Clicked_news(self):
        self.pbWindScore1_news.setChecked(True)
        self.pbWindScore2_news.setChecked(False)
        self.pbWindScore3_news.setChecked(False)
        self.windScore = 1

    def pbWindScore2Clicked_news(self):
        self.pbWindScore1_news.setChecked(True)
        self.pbWindScore2_news.setChecked(True)
        self.pbWindScore3_news.setChecked(False)
        self.windScore = 2

    def pbWindScore3Clicked_news(self):
        self.pbWindScore1_news.setChecked(True)
        self.pbWindScore2_news.setChecked(True)
        self.pbWindScore3_news.setChecked(True)
        self.windScore = 3

    def pbDeletePVScoreClicked_news(self):
        self.pbPVScore1_news.setChecked(False)
        self.pbPVScore2_news.setChecked(False)
        self.pbPVScore3_news.setChecked(False)
        self.pvScore = 0

    def pbPVScore1Clicked_news(self):
        self.pbPVScore1_news.setChecked(True)
        self.pbPVScore2_news.setChecked(False)
        self.pbPVScore3_news.setChecked(False)
        self.pvScore = 1

    def pbPVScore2Clicked_news(self):
        self.pbPVScore1_news.setChecked(True)
        self.pbPVScore2_news.setChecked(True)
        self.pbPVScore3_news.setChecked(False)
        self.pvScore = 2

    def pbPVScore3Clicked_news(self):
        self.pbPVScore1_news.setChecked(True)
        self.pbPVScore2_news.setChecked(True)
        self.pbPVScore3_news.setChecked(True)
        self.pvScore = 3

    # Scores Search
    def pbDeleteWindScoreClicked_search(self):
        self.pbWindScore1_search.setChecked(False)
        self.pbWindScore2_search.setChecked(False)
        self.pbWindScore3_search.setChecked(False)
        self.windScore = 0

    def pbWindScore1Clicked_search(self):
        self.pbWindScore1_search.setChecked(True)
        self.pbWindScore2_search.setChecked(False)
        self.pbWindScore3_search.setChecked(False)
        self.windScore = 1

    def pbWindScore2Clicked_search(self):
        self.pbWindScore1_search.setChecked(True)
        self.pbWindScore2_search.setChecked(True)
        self.pbWindScore3_search.setChecked(False)
        self.windScore = 2

    def pbWindScore3Clicked_search(self):
        self.pbWindScore1_search.setChecked(True)
        self.pbWindScore2_search.setChecked(True)
        self.pbWindScore3_search.setChecked(True)
        self.windScore = 3

    def pbDeletePVScoreClicked_search(self):
        self.pbPVScore1_search.setChecked(False)
        self.pbPVScore2_search.setChecked(False)
        self.pbPVScore3_search.setChecked(False)
        self.pvScore = 0

    def pbPVScore1Clicked_search(self):
        self.pbPVScore1_search.setChecked(True)
        self.pbPVScore2_search.setChecked(False)
        self.pbPVScore3_search.setChecked(False)
        self.pvScore = 1

    def pbPVScore2Clicked_search(self):
        self.pbPVScore1_search.setChecked(True)
        self.pbPVScore2_search.setChecked(True)
        self.pbPVScore3_search.setChecked(False)
        self.pvScore = 2

    def pbPVScore3Clicked_search(self):
        self.pbPVScore1_search.setChecked(True)
        self.pbPVScore2_search.setChecked(True)
        self.pbPVScore3_search.setChecked(True)
        self.pvScore = 3

    # Scores Watchlist
    def pbDeleteWindScoreClicked_watchlist(self):
        self.pbWindScore1_watchlist.setChecked(False)
        self.pbWindScore2_watchlist.setChecked(False)
        self.pbWindScore3_watchlist.setChecked(False)
        self.windScore = 0

    def pbWindScore1Clicked_watchlist(self):
        self.pbWindScore1_watchlist.setChecked(True)
        self.pbWindScore2_watchlist.setChecked(False)
        self.pbWindScore3_watchlist.setChecked(False)
        self.windScore = 1

    def pbWindScore2Clicked_watchlist(self):
        self.pbWindScore1_watchlist.setChecked(True)
        self.pbWindScore2_watchlist.setChecked(True)
        self.pbWindScore3_watchlist.setChecked(False)
        self.windScore = 2

    def pbWindScore3Clicked_watchlist(self):
        self.pbWindScore1_watchlist.setChecked(True)
        self.pbWindScore2_watchlist.setChecked(True)
        self.pbWindScore3_watchlist.setChecked(True)
        self.windScore = 3

    def pbDeletePVScoreClicked_watchlist(self):
        self.pbPVScore1_watchlist.setChecked(False)
        self.pbPVScore2_watchlist.setChecked(False)
        self.pbPVScore3_watchlist.setChecked(False)
        self.pvScore = 0

    def pbPVScore1Clicked_watchlist(self):
        self.pbPVScore1_watchlist.setChecked(True)
        self.pbPVScore2_watchlist.setChecked(False)
        self.pbPVScore3_watchlist.setChecked(False)
        self.pvScore = 1

    def pbPVScore2Clicked_watchlist(self):
        self.pbPVScore1_watchlist.setChecked(True)
        self.pbPVScore2_watchlist.setChecked(True)
        self.pbPVScore3_watchlist.setChecked(False)
        self.pvScore = 2

    def pbPVScore3Clicked_watchlist(self):
        self.pbPVScore1_watchlist.setChecked(True)
        self.pbPVScore2_watchlist.setChecked(True)
        self.pbPVScore3_watchlist.setChecked(True)
        self.pvScore = 3

    # Informationen abfragen News
    def getFilters_news(self):
        # Datumsfilter
        filters = self.api.create_date_range_filter(
            self.dateBegin_news.text(), self.dateEnd_news.text())

        # GetPVScore
        self.pvScore = 0
        if self.pbPVScore1_news.isChecked():
            self.pvScore = 1
        if self.pbPVScore2_news.isChecked():
            self.pvScore = 2
        if self.pbPVScore3_news.isChecked():
            self.pvScore = 3
        # GetWindScore
        self.windScore = 0
        if self.pbWindScore1_news.isChecked():
            self.windScore = 1
        if self.pbWindScore2_news.isChecked():
            self.windScore = 2
        if self.pbWindScore3_news.isChecked():
            self.windScore = 3
        # Filter für Wind und PV
        if self.pvScore > 0 or self.windScore > 0:
            filters = {**filters, **
                       self.api.create_wind_and_solar_score_filter(self.windScore, self.pvScore)}

        # Status
        if self.rbStatusWithBeschlussVorlage_news.isChecked():
            filters = {**filters, **
                       self.api.create_status_filter(["vorlage", "beschluss"])}
        elif self.rbStatusWithBeschluss_news.isChecked():
            filters = {**filters, **
                       self.api.create_status_filter(["beschluss"])}

        # Speicheroptionen
        speicherSaved = self.cbSpeicherSaved_news.isChecked()
        speicherNotSaved = self.cbSpeicherNotSaved_news.isChecked()
        speicherHiddenMeetings = self.cbSpeicherHiddenMeetings_news.isChecked()
        # Einzelne Filter sammeln
        speicher_filter_list = []

        if speicherSaved:
            speicher_filter_list.append(
                self.api.create_saved_meetings_filter())

        if speicherNotSaved:
            speicher_filter_list.append(
                self.api.create_not_saved_meetings_filter())

        if speicherHiddenMeetings:
            speicher_filter_list.append(
                self.api.create_hidden_meetings_filter())

        filters = {**filters, "_or": speicher_filter_list}

        return filters

    # Informationen abfragen Search

    def getFilterInformation_search(self, coords=None):

        # Datumsfilter
        filters = self.api.create_date_range_filter(
            self.dateBegin_search.text(), self.dateEnd_search.text())

        # Coordinates
        if coords is not None:
            filters = {**filters, **self.api.create_bounds_filter(coords)}

        # GetPVScore
        self.pvScore = 0
        if self.pbPVScore1_search.isChecked():
            self.pvScore = 1
        if self.pbPVScore2_search.isChecked():
            self.pvScore = 2
        if self.pbPVScore3_search.isChecked():
            self.pvScore = 3
        # GetWindScore
        self.windScore = 0
        if self.pbWindScore1_search.isChecked():
            self.windScore = 1
        if self.pbWindScore2_search.isChecked():
            self.windScore = 2
        if self.pbWindScore3_search.isChecked():
            self.windScore = 3
        # Filter für Wind und PV
        if self.pvScore > 0 or self.windScore > 0:
            filters = {**filters, **
                       self.api.create_wind_and_solar_score_filter(self.windScore, self.pvScore)}

        if self.rbStatusWithBeschlussVorlage_search.isChecked():
            filters = {**filters, **
                       self.api.create_status_filter(["vorlage", "beschluss"])}
        elif self.rbStatusWithBeschluss_search.isChecked():
            filters = {**filters, **
                       self.api.create_status_filter(["beschluss"])}

        # Speicheroptionen
        speicherSaved = self.cbSpeicherSaved_search.isChecked()
        speicherNotSaved = self.cbSpeicherNotSaved_search.isChecked()
        speicherHiddenMeetings = self.cbSpeicherHiddenMeetings_search.isChecked()
        # Einzelne Filter sammeln
        speicher_filter_list = []

        if speicherSaved:
            speicher_filter_list.append(
                self.api.create_saved_meetings_filter())

        if speicherNotSaved:
            speicher_filter_list.append(
                self.api.create_not_saved_meetings_filter())

        if speicherHiddenMeetings:
            speicher_filter_list.append(
                self.api.create_hidden_meetings_filter())

        filters = {**filters, "_or": speicher_filter_list}

        return filters

    # Informationen abfragen Watchlist

    def getFilterInformation_watchlist(self):
        # Datumsfilter
        filters = self.api.create_date_range_filter(
            self.dateBegin_watchlist.text(), self.dateEnd_watchlist.text())

        # GetPVScore
        self.pvScore = 0
        if self.pbPVScore1_watchlist.isChecked():
            self.pvScore = 1
        if self.pbPVScore2_watchlist.isChecked():
            self.pvScore = 2
        if self.pbPVScore3_watchlist.isChecked():
            self.pvScore = 3
        # GetWindScore
        self.windScore = 0
        if self.pbWindScore1_watchlist.isChecked():
            self.windScore = 1
        if self.pbWindScore2_watchlist.isChecked():
            self.windScore = 2
        if self.pbWindScore3_watchlist.isChecked():
            self.windScore = 3
        # Filter für Wind und PV
        if self.pvScore > 0 or self.windScore > 0:
            filters = {**filters, **
                       self.api.create_wind_and_solar_score_filter(self.windScore, self.pvScore)}
        # Status
        if self.rbStatusWithBeschlussVorlage_watchlist.isChecked():
            filters = {**filters, **
                       self.api.create_status_filter(["vorlage", "beschluss"])}
        elif self.rbStatusWithBeschluss_watchlist.isChecked():
            filters = {**filters, **
                       self.api.create_status_filter(["beschluss"])}

        # Speicheroptionen
        speicherSaved = self.cbSpeicherSaved_watchlist.isChecked()
        speicherNotSaved = self.cbSpeicherNotSaved_watchlist.isChecked()
        speicherHiddenMeetings = self.cbSpeicherHiddenMeetings_watchlist.isChecked()
        # Einzelne Filter sammeln
        speicher_filter_list = []

        if speicherSaved:
            speicher_filter_list.append(
                self.api.create_saved_meetings_filter())

        if speicherNotSaved:
            speicher_filter_list.append(
                self.api.create_not_saved_meetings_filter())

        if speicherHiddenMeetings:
            speicher_filter_list.append(
                self.api.create_hidden_meetings_filter())

        filters = {**filters, "_or": speicher_filter_list}

        return filters

    def setCgbTitleNews(self, dateString):
        self.cgbNews.setTitle(f"Neuigkeiten filtern ({dateString})")

    def setCgbTitleSearch(self, dateString):
        self.cgbSearch.setTitle(f"Suche filtern ({dateString})")

    def setCgbTitleWatchlist(self, dateString):
        self.cgbWatchlist.setTitle(f"Merkliste filtern ({dateString})")

    def clearAndFillFoxsregionGroupbox(self, groupbox):
        self.clearFocusregionGroupbox(groupbox)
        columns = 4
        layout = groupbox.layout()
        focusregionen = self.getFocusregionNameAndId()
        if not focusregionen or len(focusregionen) == 0:
            label = QLabel(
                "Keine Fokusregionen gefunden. Bitte über die <a href=\"https://app.poliscope.de/focusregions\">Webseite</a> hinzufügen.")
            label.setOpenExternalLinks(True)
            # label.setAlignment(Qt.AlignCenter)
            layout.addWidget(label, 0, 0, 1, columns)
        else:
            for index, item in enumerate(focusregionen):
                row = index // columns
                col = index % columns
                checkbox = QCheckBox(item["name"])
                checkbox.setProperty("id", item["id"])
                # Standardmäßig aktiviert
                checkbox.setChecked(not item['paused'])
                layout.addWidget(checkbox, row, col)

            # Leere Plätze mit leeren Labels auffüllen für gleichmäßige Darstellung
            remainder = len(focusregionen) % columns
            if remainder != 0:
                for col in range(remainder, columns):
                    spacer = QLabel()
                    spacer.setVisible(True)
                    layout.addWidget(spacer, len(
                        focusregionen) // columns, col)

    def clearFocusregionGroupbox(self, groupbox):
        layout = groupbox.layout()
        while layout.count():
            child = layout.takeAt(0)
            if child.widget():
                child.widget().deleteLater()

    def getFocusregionNameAndId(self):
        self.fokusregionen = self.api.get_fokusregionen()
        fokusregionenList = []
        for fokusregion in self.fokusregionen:
            fokusregionenList.append(
                {"name": fokusregion['name'], "id": fokusregion['id'], "paused": fokusregion['team'][0]['paused']})
        return fokusregionenList

    def getEntitiesByFokusregionIds(self, target_ids: list) -> list:
        result = []
        for region in self.fokusregionen:
            if region.get("id") in target_ids:
                result.extend(region.get("entities", []))

        return result

    def showOptions(self):
        # Zugriff auf QGIS-Einstellungen (Plugin-spezifisch)
        settings = QSettings()
        settings.beginGroup("PoliscopePlugin")

        # Bestehenden Key laden, falls vorhanden
        current_key = settings.value("api_key", "", type=str)

        # Eingabedialog anzeigen
        api_key, ok = QInputDialog.getText(
            None, "API-Key eingeben", "Bitte API-Key eingeben:", text=current_key)

        apiIsWorking = True
        try:
            MeetingsAPI(api_key=api_key)
        except Exception as e:
            apiIsWorking = False
            print(f"API-Key ungültig: {e}")

        if ok and api_key and apiIsWorking:
            settings.setValue("api_key", api_key)
            QMessageBox.information(
                None, "Erfolg", "API-Key wurde gespeichert und ist gültig! Bitte QGIS neu starten.")
        elif ok and api_key:
            settings.setValue("api_key", api_key)
            QMessageBox.warning(
                None, "Erfolg", "API-Key wurde gespeichert ist aber nicht gültig! Bitte gültigen API-Key eingeben.")
        elif ok:
            settings.setValue("", api_key)
            QMessageBox.critical(
                None, "Achtung", "Es wurde ein leerer API-Key gespeichert.")

        settings.endGroup()

    def check_scroll_position_news(self, value):
        max_value = self.newsList.verticalScrollBar().maximum()
        if max_value > 0 and value >= max_value * 0.9:
            if self.meetings_count_news > (self.currPage_news * 10):
                self.currPage_news += 1
                self.setRefNewsButton2Loading()

                # Get checked focusregions
                checkedFocusregionsIDs = []
                for checkbox in self.gbFocusregions_news.findChildren(QCheckBox):
                    if checkbox.isChecked():
                        checkedFocusregionsIDs.append(checkbox.property("id"))

                # Use focusregion endpoint if focusregions are selected
                if checkedFocusregionsIDs:
                    meetings = self.api.get_focusregion_meetings(
                        filters=self.filter_news, focusregion_ids=checkedFocusregionsIDs, sortString=self.sortString_news, page=self.currPage_news)
                else:
                    meetings = []

                self.setMeetingsToList(meetings)
                self.setRefNewsButton2Normal()
        else:
            pass

    def check_scroll_position_search(self, value):
        max_value = self.searchList.verticalScrollBar().maximum()
        if max_value > 0 and value >= max_value * 0.9:
            if self.meetings_count_search > (self.currPage_search * 10):
                self.currPage_search += 1
                self.setRefSearchButton2Loading()
                meetings = self.api.get_meetings(
                    filters=self.filter_search, entityRSCodes=[], sortString=self.sortString_search, page=self.currPage_search)
                self.setMeetingsToList(meetings)
                self.setRefSearchButton2Normal()

    def check_scroll_position_watchlist(self, value):
        max_value = self.watchlistList.verticalScrollBar().maximum()
        if max_value > 0 and value >= max_value * 0.9:
            if self.meetings_count_watchlist > (self.currPage_watchlist * 10):
                self.currPage_watchlist += 1
                self.setRefWatchlistButton2Loading()
                meetings = self.api.get_bookmarked_meetings(
                    filters=self.filter_watchlist, sortString=self.sortString_watchlist, page=self.currPage_watchlist)
                self.setMeetingsToList(meetings)
                self.setRefWatchlistButton2Normal()

    def setRefNewsButton2Loading(self):
        self.dockwidget.newsRefButton.setText("Lade...")
        self.dockwidget.newsRefButton.setEnabled(False)
        self.dockwidget.newsRefButton.setStyleSheet(
            "background-color: #cccccc;")
        self.dockwidget.newsRefButton.setCursor(QtCore.Qt.WaitCursor)
        QApplication.processEvents()

    def setRefNewsButton2Normal(self):
        self.dockwidget.newsRefButton.setText("Aktualisieren")
        self.dockwidget.newsRefButton.setEnabled(True)
        self.dockwidget.newsRefButton.setStyleSheet(
            "background-color: None;")
        self.dockwidget.newsRefButton.setCursor(QtCore.Qt.PointingHandCursor)
        QApplication.processEvents()

    def setRefSearchButton2Loading(self):
        self.dockwidget.searchCenterSearchButton.setText("Lade...")	
        self.dockwidget.searchBbSearchButton.setText("Lade...")
        self.dockwidget.searchCenterSearchButton.setEnabled(False)
        self.dockwidget.searchBbSearchButton.setEnabled(False)
        self.dockwidget.searchBbSearchButton.setStyleSheet(
            "background-color: #cccccc;")
        self.dockwidget.searchCenterSearchButton.setStyleSheet(
            "background-color: #cccccc;")
        self.dockwidget.searchCenterSearchButton.setCursor(QtCore.Qt.WaitCursor)
        self.dockwidget.searchBbSearchButton.setCursor(QtCore.Qt.WaitCursor)
        QApplication.processEvents()

    def setRefSearchButton2Normal(self):
        self.dockwidget.searchCenterSearchButton.setText("Zentrum Suche")
        self.dockwidget.searchBbSearchButton.setText("BBox Suche")
        self.dockwidget.searchCenterSearchButton.setEnabled(True)
        self.dockwidget.searchBbSearchButton.setEnabled(True)
        self.dockwidget.searchCenterSearchButton.setStyleSheet(
            "background-color: None;")
        self.dockwidget.searchBbSearchButton.setStyleSheet(
            "background-color: None;")
        self.dockwidget.searchCenterSearchButton.setCursor(
            QtCore.Qt.PointingHandCursor)
        self.dockwidget.searchBbSearchButton.setCursor(QtCore.Qt.PointingHandCursor)
        QApplication.processEvents()

    def setRefWatchlistButton2Loading(self):
        self.dockwidget.watchlistRefButton.setText("Lade...")
        self.dockwidget.watchlistRefButton.setEnabled(False)
        self.dockwidget.watchlistRefButton.setStyleSheet(
            "background-color: #cccccc;")
        self.dockwidget.watchlistRefButton.setCursor(QtCore.Qt.WaitCursor)
        QApplication.processEvents()

    def setRefWatchlistButton2Normal(self):
        self.dockwidget.watchlistRefButton.setText("Aktualisieren")
        self.dockwidget.watchlistRefButton.setEnabled(True)
        self.dockwidget.watchlistRefButton.setStyleSheet(
            "background-color: None;")
        self.dockwidget.watchlistRefButton.setCursor(
            QtCore.Qt.PointingHandCursor)
        QApplication.processEvents()

    def openLocationInQGIS(self, event, rs):
        # Zuerst das vollständige Entity-Objekt abrufen
        entity = self.api.get_entity(rs)
        bounds = self.extract_bounds(entity)  # Dann die Bounds extrahieren
        self.zoom_to_polygon_bounds(bounds)

    def extract_bounds(self, entity):
        if 'bounds' in entity:
            return entity['bounds']
        return None

    def zoom_to_polygon_bounds(self, bounds_data):
        try:
            # Koordinaten aus dem Dictionary extrahieren
            if bounds_data['type'] != 'Polygon':
                print("Fehler: Nur Polygon-Typ wird unterstützt")
                return False

            # Erster Ring (äußerer Ring)
            coordinates = bounds_data['coordinates'][0]

            # Min/Max Werte für Bounding Box finden
            lons = [coord[0] for coord in coordinates]
            lats = [coord[1] for coord in coordinates]

            min_lon = min(lons)
            max_lon = max(lons)
            min_lat = min(lats)
            max_lat = max(lats)

            print(f"Bounding Box: {min_lon}, {min_lat}, {max_lon}, {max_lat}")

            # QgsRectangle erstellen (WGS84 Koordinaten)
            bbox = QgsRectangle(min_lon, min_lat, max_lon, max_lat)

            # Koordinatensystem definieren
            source_crs = QgsCoordinateReferenceSystem("EPSG:4326")  # WGS84
            project_crs = QgsProject.instance().crs()  # Projekt-CRS

            # Koordinatentransformation (falls nötig)
            if source_crs != project_crs:
                transform = QgsCoordinateTransform(
                    source_crs, project_crs, QgsProject.instance())
                bbox = transform.transformBoundingBox(bbox)

            # Auf Bounding Box zoomen
            iface.mapCanvas().setExtent(bbox)
            iface.mapCanvas().refresh()

            return True

        except Exception as e:
            print(f"Fehler beim Zoomen: {str(e)}")
            return False
