# -*- coding: utf-8 -*-

"""
/***************************************************************************
 LabelGrid
                                 A QGIS plugin
 Select points in grid cells
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-12-07
        copyright            : (C) 2020 by Mathias Gröbe
        email                : mathias.groebe@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Mathias Gröbe'
__date__ = '2020-12-07'
__copyright__ = '(C) 2020 by Mathias Gröbe'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import (QCoreApplication, QVariant)
from qgis.PyQt.QtGui import QIcon
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingException,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterVectorDestination,
                       QgsProcessingParameterFeatureSink,
                       QgsProcessingParameterField,
                       QgsProcessingParameterNumber,
                       QgsProcessingParameterEnum,
                       QgsWkbTypes,
                       QgsGeometry,
                       QgsFields,
                       QgsField,
                       QgsFeature,
                       QgsProcessingUtils, QgsMessageLog)
import os, processing
from operator import itemgetter, attrgetter

class GridPoint:
  def __init__(self, pointID, gridID, pointValue, rank):
    self.pointID = pointID
    self.gridID = gridID
    self.pointValue = pointValue
    self.rank = rank
    
  def __repr__(self):
    rep = 'Point(' + str(self.pointID) + ', ' + str(self.gridID) + ', ' + str(self.pointValue) + ', ' + str(self.rank) +')\n'
    return rep

def rankPoints(point_list, desc):
    rank = 1
    grid = 0
    ranked_list = sorted(point_list, key=attrgetter('gridID', 'pointValue'), reverse = desc)
    for point in ranked_list:
        if point.gridID == -1:
            point.rank = 0
        else:
            if grid == point.gridID:
                point.rank = rank
                rank = rank + 1
            else:
                grid = point.gridID
                rank = 1
                point.rank = rank
                rank = rank + 1
            
    return ranked_list


class LabelGridPredefinedAlgorithm(QgsProcessingAlgorithm):


    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    OUTPUT_POINTS = 'OUTPUT_POINTS'
    INPUT_GRID = 'INPUT_GRID'
    INPUT = 'INPUT'
    MINMAX = 'MINMAX'
    VALUE_FIELD = 'VALUE_FIELD'
    FIELD_FOR_GRID_ID = 'FIELD_FOR_GRID_ID'
    FIELD_FOR_SELECTION = 'FIELD_FOR_SELECTION'


    def initAlgorithm(self, config):

        # Here we define the inputs and output of the algorithm

        # Input grid layer
        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.INPUT_GRID,
                self.tr('Input polygon layer'),
                [QgsProcessing.TypeVectorPolygon]
            )
        )


        # Input point layer
        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.INPUT,
                self.tr('Input point layer'),
                [QgsProcessing.TypeVectorPoint]
            )
        )
        
        # Field in point layer with numeric values
        self.addParameter(
            QgsProcessingParameterField(
            self.VALUE_FIELD,
            self.tr('Field with numeric values'),
            None,
            self.INPUT,
            QgsProcessingParameterField.Numeric)
        )

        # Select min or max
        self.addParameter(
            QgsProcessingParameterEnum(
            self.MINMAX,
            self.tr('Use max or min values'),
            options = ['Max', 'Min'],
            defaultValue = 0,
            optional = False)
        )  
        
        # Chose field for grid id
        self.addParameter(
            QgsProcessingParameterField(
            self.FIELD_FOR_GRID_ID,
            self.tr('Field for storing the id of the used polygon'),
            None,
            self.INPUT,
            QgsProcessingParameterField.Numeric)
        )

        # Chose field for selection
        self.addParameter(
            QgsProcessingParameterField(
            self.FIELD_FOR_SELECTION,
            self.tr('Field for storing the ranking of the points inside each polygon'),
            None,
            self.INPUT,
            QgsProcessingParameterField.Numeric)
        )        
        
        # Output points
        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.OUTPUT_POINTS,
                self.tr('Point in Polygon')
            )
        )       

    def processAlgorithm(self, parameters, context, feedback):

        # Retrieve the feature source and sink. 
        source = self.parameterAsSource(parameters, self.INPUT, context)
        
        (sink, dest_id) = self.parameterAsSink(parameters, self.OUTPUT_POINTS,
                context, source.fields(), source.wkbType(), source.sourceCrs())
                
        if source is None:
            raise QgsProcessingException(self.invalidSourceError(parameters, self.INPUT))

        if QgsWkbTypes.isMultiType(source.wkbType()):
            raise QgsProcessingException(self.tr('Input layer is a MultiPoint layer - first convert to single points before using this algorithm.'))
                
        # Get variables
        value_field = self.parameterAsString(parameters, self.VALUE_FIELD, context)
        minmax_input = self.parameterAsString(parameters, self.MINMAX, context)
        field_for_selection = self.parameterAsString(parameters, self.FIELD_FOR_SELECTION, context)
        field_for_grid_id = self.parameterAsString(parameters, self.FIELD_FOR_GRID_ID, context)
        grid = self.parameterAsSource(parameters, self.INPUT_GRID, context)
        

        # Compute the number of steps to display within the progress bar and
        # get features from source
        total = 100.0 / source.featureCount() if source.featureCount() else 0

        # check which point is in which grid cell
        points = source.getFeatures()
        pointList = []
        # point id, grid id, value

        
        for current, point in enumerate(points):
            if feedback.isCanceled():
                break    
                
            grid_cells = grid.getFeatures()
            check = True
            for cell in grid_cells:
                if cell.geometry().contains(point.geometry()):
                    pointList.append(GridPoint(point.id(), cell.id(), point[value_field], None))
                    check = False

            # if point is not cotained by one grid cell set values
            if check:
                pointList.append(GridPoint(point.id(), -1, None, None))

            # Update progress
            feedback.setProgress(int(current * total))

        
        # search for highest/lowest value
        # Handle input for min/max
        if minmax_input == '1': 
            # use min  
            points = sorted(rankPoints(pointList, False), key=attrgetter('pointID'))
        else:
            # use max
            points = sorted(rankPoints(pointList, True), key=attrgetter('pointID'))   

        # bring values to features
        features = source.getFeatures()

        for current, (feature, point) in enumerate(zip(features, points)):
            # Stop the algorithm if cancel button has been clicked
            if feedback.isCanceled():
                break
            
            # set grid_id 
            if feature.id() == point.pointID:
                # write grid_id to point
                feature[field_for_grid_id] = point.gridID
                # write rank to point
                feature[field_for_selection] = point.rank

            # Add a feature in the sink
            sink.addFeature(feature, QgsFeatureSink.FastInsert)

            # Update the progress bar
            feedback.setProgress(int(current * total))

        # Return the results of the algorithm.
        return {self.OUTPUT_POINTS: dest_id}  

    def name(self):
        """
        Returns the algorithm name
        """
        return 'Point in Polygon'

    def displayName(self):
        """
        Returns the translated algorithm name
        """
        return 'Point in Polygon' 

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return ''
        
    def icon(self):
        return QIcon(self.svgIconPath())


    def svgIconPath(self):
        return os.path.dirname(__file__) + '/icon/point_in_polygon_icon.png'
        
    def shortHelpString(self):
        file = os.path.dirname(__file__) + '/help/label_grid_predefined.help'
        if not os.path.exists(file):
            return ''
        with open(file) as helpfile:
            help = helpfile.read()
        return help        

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return LabelGridPredefinedAlgorithm()
