# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PointOnArcIntersection
                                 A QGIS plugin
 The plugin creates a new layer with points on arcs' intersection within the same layer
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-08-24
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Piotr Andryk
        email                : andryk.p@wp.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os.path
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QDialogButtonBox
from qgis.core import(
    Qgis,
    QgsProject,
    QgsVectorLayer,
    QgsWkbTypes
)

# Initialize Qt resources from file resources.py
# Import the code for the dialog
if __name__ == "__main__":
    from resources import *
    from point_on_arc_intersection_dialog import PointOnArcIntersectionDialog
    from point_on_arc_intersection_core import PointOnArcIntersectionCore
else:
    from .resources import *
    from .point_on_arc_intersection_dialog import PointOnArcIntersectionDialog
    from .point_on_arc_intersection_core import PointOnArcIntersectionCore


class PointOnArcIntersection:
    """QGIS Plugin Implementation."""
    ComboMapDict = {}

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'PointOnArcIntersection_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Create points on arcs\' intersection')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        self.dlg = PointOnArcIntersectionDialog()

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('PointOnArcIntersection', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToVectorMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/point_on_arc_intersection/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Create points on arcs\' intersection'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginVectorMenu(
                self.tr(u'&Create points on arcs\' intersection'),
                action)
            self.iface.removeToolBarIcon(action)

    def prepare_layers_combobox(self):
        layers = [layer for layer in QgsProject.instance().mapLayers(True).values()
                  if isinstance(layer, QgsVectorLayer) and layer.geometryType() == QgsWkbTypes.LineGeometry
                  ]

        # Mapping of combo box index and layer id
        for i in range(len(layers)):
            self.ComboMapDict[i] = layers[i].id()

        self.dlg.layerComboBox.clear()
        self.dlg.layerComboBox.addItems([layer.name() for layer in layers])

    def build_point_on_arc_intersection_core(self):
        # Get parameters for core algorithms
        name = self.dlg.outputLayerNameTextEdit.toPlainText().strip()
        if name == "":
            return

        layer = QgsProject.instance().mapLayer(self.ComboMapDict[self.dlg.layerComboBox.currentIndex()])
        if layer is None:
            return

        algorithm_list = []
        for i in range(self.dlg.algorithmListWidget.count()):
            item = self.dlg.algorithmListWidget.item(i)
            if item.checkState() == Qt.Checked:
                algorithm_list.append(i)

        if len(algorithm_list) == 0:
            self.iface.messageBar().pushMessage("Warning!",
                                                "You have to pick at least one algorithm!",
                                                level=Qgis.Warning
                                                )
            return

        return PointOnArcIntersectionCore(
            layer,
            name,
            algorithm_list,
            self.dlg.arcsNumberSpinBox.value(),
            self.dlg.progressLabel,
            self.dlg.progressBar
        )

    def execute_core(self):
        core = self.build_point_on_arc_intersection_core()
        if core is None:
            return

        core.execute()

        if core.output_layer.isValid():
            QgsProject.instance().addMapLayer(core.output_layer)

        self.iface.messageBar().pushMessage("Success!",
                                            "Create points on arcs\' intersection algorithms has been completed!",
                                            level=Qgis.Success
                                            )

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start:
            self.first_start = False
            self.dlg.button_box.button(QDialogButtonBox.Apply).clicked.connect(self.execute_core)

        # Populate layersComboBox
        self.prepare_layers_combobox()

        # Clear name
        self.dlg.outputLayerNameTextEdit.setPlainText("")

        # Reset progress
        self.dlg.progressLabel.setText("Algorithm")
        self.dlg.progressBar.setValue(0)

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        self.dlg.exec_()
