




import os
import sys




from PyQt5.QtGui import *
from qgis.PyQt.QtCore import QVariant
from qgis.analysis import QgsNativeAlgorithms
from qgis.core import *


# Tell Python where you will get processing from
sys.path.append(r'C:\Program Files\QGIS 3.0\apps\qgis\python\plugins')

# Reference the algorithm you want to run





if __name__ == "__main__":
    app = QGuiApplication([])
    QgsApplication.setPrefixPath(r'C:\Program Files\QGIS 3.0\apps\qgis', True)
    QgsApplication.processingRegistry().addProvider(QgsNativeAlgorithms())
    QgsApplication.initQgis()

    layer = QgsVectorLayer('sight_line.shp', 'layer_name', 'ogr')  # Load the layer
    if not layer.isValid():  # Check if the layer is valid
        print('Layer not loaded')

    # Get the layer's data provider
    provider = layer.dataProvider()

    # Get the field indexes
    fields = provider.fields()
    field_names = [field.name() for field in fields]

    # Delete all the fields
    if provider.deleteAttributes(field_names):
        layer.updateFields()  # Update the layer's fields
        print('Fields deleted')
    else:
        print('Fields not deleted')

    output_path = 'output_file.shp'
    if provider.writeAsVectorFormat(output_path, provider.encoding(), provider.crs(), 'ESRI Shapefile'):
        print('Layer saved')
    else:
        print('Layer not saved')
    """For standalone application"""
    # Exit applications
    QgsApplication.exitQgis()

    app.exit()
