from qgis.core import QgsTask, Qgis
from ..constants import BUDYNKI_3D_WMS_URL
from ..utils import MessageUtils, ServiceAPI


class DownloadModel3dTask(QgsTask):
    """QgsTask pobierania modeli 3D"""

    def __init__(self, description, folder, teryt_powiat, teryt_wojewodztwo, standard, data_lista, iface):
        super().__init__(description, QgsTask.CanCancel)
        self.folder = folder
        self.exception = None
        self.teryt_powiat = teryt_powiat
        self.teryt_wojewodztwo = teryt_wojewodztwo
        self.standard = standard
        self.data_lista = data_lista
        self.iface = iface
        self.liczba_dobrych_url = []
        self.service_api = ServiceAPI()

    def run(self):
        list_url = []
        MessageUtils.pushLogInfo(f'Rozpoczęto zadanie: "{self.description()}"')
        for standard in self.standard:
            for rok in self.data_lista:
                list_url.extend(
                    (
                        f'{BUDYNKI_3D_WMS_URL}{standard}/{rok}/{self.teryt_wojewodztwo}/{self.teryt_powiat}.zip',
                        f'{BUDYNKI_3D_WMS_URL}{standard}/{rok}/{self.teryt_wojewodztwo}/{self.teryt_powiat}_gml.zip',
                    )
                )
            list_url.extend(
                (
                    f'{BUDYNKI_3D_WMS_URL}{standard}/{self.teryt_powiat}_gml.zip',
                    f'{BUDYNKI_3D_WMS_URL}{standard}/{self.teryt_powiat}.zip',
                )
            )
        results = []
        for url in list_url:
            if self.isCanceled():
                MessageUtils.pushLogWarning(f'Przerwano zadanie: "{self.description()}"')
                return False
            MessageUtils.pushLogInfo(f'Pobieram {url}')
            res, self.exception = self.service_api.retreiveFile(url=url, destFolder=self.folder, obj=self)
            if res:
                self.liczba_dobrych_url.append(url)
            results.append(res)
        return any(results)

    def finished(self, result):
        if result:
            if self.liczba_dobrych_url:
                title = "Komunikat"
                message = f"Pobrano {len(self.liczba_dobrych_url)} plików z danymi"
                MessageUtils.pushMessageBoxInfo(self.iface.mainWindow(), title, message)
            
            MessageUtils.pushLogInfo('Pobrano dane modelu 3D budynków')
            MessageUtils.pushSuccess(self.iface, 'Udało się! Dane modelu 3D budynków zostały pobrane.')
        else:
            MessageUtils.pushWarning(self.iface, 'Dane modelu 3D budynków nie zostały pobrane.')
            if self.exception is None:
                MessageUtils.pushLogWarning('Nie udało się pobrać danych modelu 3D budynków')
            elif isinstance(self.exception, BaseException):
                MessageUtils.pushLogWarning("Nie udało się pobrać danych modelu 3D budynków. Wystąpił błąd: " + str(self.exception))


    def cancel(self):
        MessageUtils.pushLogWarning('Anulowano pobieranie danych modelu 3D budynków')
        super().cancel()
