-- ##########################################################################################################
-- #                        Script qui copie les données spécifiques à GAM                                  #
-- #                Données à remplacer par les données propres de la collectivité territoriale             #
-- ##########################################################################################################

-- copie des champs supplémentaires utilisés dans les tables
-- ces champs sont pour la plupart rassemblés dans une colonne au format HSTORE pour être dynamique sans changer la structure globale

-- explication des champs GAM
-- clef_plumanager : identifiant pour faire le lien avec un logiciel de gestion du règlement écrit
-- modif : permet de savoir l'évolution de l'objet dans une même version insert/update/suppr
-- modif_comment : ajout de commentaires
-- code_insee : pour pouvoir faire des tris sur les communes
-- etiquette et légende : l'usage des champs CNIG txt et libelle à des limites contraignantes pour l'édition des ATLAS

INSERT INTO urba_plui_ecriture.pluiv_champs_lib (classe_entite,nom_col,publique,valeur_defaut,deployable) VALUES
     ('zoneurba','lib_cle_plumanager',NULL,NULL,false),
     ('prescription','lib_cle_plumanager',NULL,NULL,false),
     ('zoneurba','lib_modif_comment',NULL,NULL,true),
     ('prescription','lib_modif_comment',NULL,NULL,true),
     ('zoneurba','lib_code_insee',true,NULL,true),
     ('prescription','lib_code_insee',true,NULL,true),
     ('information','lib_code_insee',true,NULL,true);
INSERT INTO urba_plui_ecriture.pluiv_champs_lib (classe_entite,nom_col,publique,valeur_defaut,deployable) VALUES
     ('information','lib_modif_comment',NULL,NULL,true),
     ('habillage','lib_modif_comment',NULL,NULL,true),
     ('habillage','lib_code_insee',true,NULL,true),
     ('zoneurba','lib_modif',NULL,'N',true),
     ('prescription','lib_modif',NULL,'N',true),
     ('information','lib_modif',NULL,'N',true),
     ('habillage','lib_modif',NULL,'N',true),
     ('zoneurba','lib_etiquette',true,NULL,true),
     ('zoneurba','lib_legende',true,NULL,true);
INSERT INTO urba_plui_ecriture.pluiv_champs_lib (classe_entite,nom_col,publique,valeur_defaut,deployable) VALUES
     ('prescription','lib_etiquette',true,NULL,true),
     ('prescription','lib_legende',true,NULL,true),
     ('information','lib_etiquette',true,NULL,true),
     ('information','lib_legende',true,NULL,true);

-- Les libellés de zonage propres du PLUi GAM
INSERT INTO urba_plui_ecriture.pluiv_zoneurbatype_ct (id,libelle,libelong,id_typezone) VALUES
     (1,'A','Agricole',4),
     (2,'Ak','Agricole avec domaines skiables',4),
     (3,'AL','STECAL en zone agricole',4),
     (4,'ALb1','STECAL en zone agricole avec locaux industriels des administrations autorisés',4),
     (5,'ALc1','STECAL en zone agricole avec mixité fonctionnelle (restauration, hôtellerie, campings autorisés)',4),
     (6,'ALg1','STECAL en zone agricole avec hébergement autorisé',4),
     (7,'ALj1','STECAL en zone agricole pour les jardins partagés',4),
     (8,'ALj2','STECAL en zone agricole pour les jardins partagés',4),
     (9,'ALj3','STECAL en zone agricole pour les jardins partagés',4),
     (10,'ALt1','STECAL en zone agricole pour hébergement touristique et hôtelier',4),
     (11,'ALt2','STECAL en zone agricole pour hébergement touristique et hôtelier',4),
     (12,'ALv1','STECAL en zone agricole réservé aux gens du voyage',4),
     (13,'ALv2','STECAL en zone agricole réservé aux gens du voyage',4),
     (14,'ALv3','STECAL en zone agricole réservé aux gens du voyage',4),
     (15,'ALv4','STECAL en zone agricole réservé aux gens du voyage',4),
     (16,'ALv5','STECAL en zone agricole réservé aux gens du voyage',4),
     (17,'ALv6','STECAL en zone agricole réservé aux gens du voyage',4),
     (18,'As','Agricole avec secteurs à protéger (stricts)',4),
     (19,'AU','Zone à urbaniser stricte',3),
     (20,'AUC1','Zone à urbaniser de type UC1',2),
     (21,'AUC2','Zone à urbaniser de type UC2',2),
     (22,'AUC3','Zone à urbaniser de type UC3',2),
     (23,'AUD1','Zone à urbaniser de type UD1',2),
     (24,'AUD2','Zone à urbaniser de type UD2',2),
     (25,'AUD3','Zone à urbaniser de type UD3',2),
     (26,'AUD4','Zone à urbaniser de type UD4',2),
     (27,'AUE1','Zone à urbaniser de type UE1',2),
     (28,'AUP','Zone à urbaniser avec réglement spécifique',2),
     (29,'AUP1r','Zone à urbaniser avec réglement spécifique ; opération réalisée au fur et à mesure de la réalisation des équipements',2),
     (30,'N','Naturelle',5),
     (31,'Nc','Naturelle avec mixité fonctionnelle (restauration, hôtellerie, campings autorisés)',5),
     (32,'Nk','Naturelle avec domaines skiables',5),
     (33,'NL','STECAL en zone naturelle',5),
     (34,'NLj','STECAL en zone naturelle pour les jardins partagés',5),
     (35,'NLj1','STECAL en zone naturelle pour les jardins partagés',5),
     (36,'NLj2','STECAL en zone naturelle pour les jardins partagés',5),
     (37,'NLt2','STECAL en zone naturelle pour hébergement touristique et hôtelier',5),
     (38,'NLt3','STECAL en zone naturelle pour hébergement touristique et hôtelier',5),
     (39,'NLt4','STECAL en zone naturelle pour hébergement touristique et hôtelier',5),
     (40,'NLt5','STECAL en zone naturelle pour hébergement touristique et hôtelier',5),
     (41,'NLt6','STECAL en zone naturelle pour hébergement touristique et hôtelier',5),
     (42,'NLv1','STECAL en zone naturelle réservés aux gens du voyage',5),
     (43,'NLv2','STECAL en zone naturelle réservés aux gens du voyage',5),
     (44,'NLv3','STECAL en zone naturelle réservés aux gens du voyage',5),
     (45,'NLv4','STECAL en zone naturelle réservés aux gens du voyage',5),
     (46,'NLv5','STECAL en zone naturelle réservés aux gens du voyage',5),
     (47,'Ns','Naturelle avec secteurs à protéger (stricts)',5),
     (48,'UA1','Centre ancien de Grenoble',1),
     (49,'UA2','Centres bourgs et villages',1),
     (50,'UA3','Hameaux anciens ',1),
     (51,'UB','Tissus urbains hétérogènes du coeur métropolitain ',1),
     (52,'UBa','Tissus urbains hétérogènes du coeur métropolitain avec végétalisation renforcée',1),
     (53,'UBau','Tissus urbains hétérogènes du coeur métropolitain  avec végétalisation renforcée et bureaux autorisés sans limitation de surface',1),
     (54,'UC1','Habitat collectif en R+5',1),
     (55,'UC1a','Habitat collectif en R+5 avec végétalisation renforcée',1),
     (56,'UC1an','Habitat collectif en R+5 avec végétalisation renforcée et commerce de gros interdit',1),
     (57,'UC1au','Habitat collectif en R+5 avec végétalisation renforcée et bureaux autorisés sans limitation de surface',1),
     (58,'UC1n','Habitat collectif en R+5 avec commerce de gros interdit',1),
     (59,'UC1u','Habitat collectif en R+5 avec bureaux autorisés sans limitation de surface',1),
     (60,'UC2','Habitat collectif en R+4',1),
     (61,'UC2f','Habitat collectif en R+4 avec restauration interdite',1),
     (62,'UC3','Habitat collectif en R+3',1),
     (63,'UCRU','Renouvellement urbain',1),
     (64,'UCRU1','Zone de renouvellement urbain Artelia',1),
     (65,'UCRU2','Zone de renouvellement urbain Frange Verte',1),
     (66,'UCRU3','Zone de renouvellement urbain Abbaye',1),
     (67,'UCRU4','Zone de renouvellement urbain Cadran Solaire',1),
     (68,'UCRU5','Zone de renouvellement urbain Les Minotiers',1),
     (69,'UCRU6','Zone de renouvellement urbain SMH Péri section centrale',1),
     (70,'UCRU7','Zone de renouvellement urbain SMH Neyrpic',1),
     (71,'UCRU8','Zone de renouvellement urbain SMH Daudet',1),
     (72,'UCRU9','Zone de renouvellement urbain Fauconnière',1),
     (73,'UD1','Pavillonnaire en mutation',1),
     (74,'UD2','Pavillonnaire en densification',1),
     (75,'UD2m','Pavillonnaire en densification avec secteurs où l''implantation en limite est restreinte',1),
     (76,'UD2mf','Pavillonnaire en densification avec secteurs où l''implantation en limite est restreinte et restauration interdite',1),
     (77,'UD3','Pavillonnaire en évolution modérée',1),
     (78,'UD3b','Pavillonnaire en évolution modérée avec locaux industriels des administrations autorisés',1),
     (79,'UD3d','Pavillonnaire en évolution modérée avec secteurs de densité plus faible',1),
     (80,'UD3df','Pavillonnaire en évolution modérée avec secteurs de densité plus faible et  restauration interdite',1),
     (81,'UD3f','Pavillonnaire en évolution modérée avec restauration interdite',1),
     (82,'UD3v','Pavillonnaire en évolution modérée avec secteurs réservés aux gens du voyage',1),
     (83,'UD4','Pavillonnaire au développement limité',1),
     (84,'UD4b','Pavillonnaire au développement limité avec locaux industriels des administrations autorisés',1),
     (85,'UD4h','Pavillonnaire au développement limité avec secteurs aux hauteurs limitées',1),
     (86,'UD4v','Pavillonnaire au développement limité avec secteurs réservés aux gens du voyage',1),
     (87,'UE1','Activités productives et artisanales',1),
     (88,'UE1e','Activités productives et artisanales avec secteurs réservés aux entrepôts et commerces de gros',1),
     (89,'UE1nv','Activités productives et artisanales avec commerce de gros interdit et secteurs réservés aux gens du voyage',1),
     (90,'UE2','Activités de production industrielle',1),
     (91,'UE2e','Activités de production industrielle avec secteurs réservés aux entrepôts et commerces de gros',1),
     (92,'UE2u','Activités de production industrielle avec bureaux autorisés sans limitation de surface',1),
     (93,'UE2v','Activités de production industrielle avec secteurs réservés aux gens du voyage',1),
     (94,'UE3','Activités productives et de services',1),
     (95,'UE3n','Activités productives et de services avec commerce de gros interdit',1),
     (96,'UE4','Activités tertiaires et technologiques',1),
     (97,'UV','Parcs urbains',1),
     (98,'UZ1','Equipements collectifs et touristiques',1),
     (99,'UZ1c','Equipements collectifs et touristiques avec mixité fonctionnelle (restauration, hôtellerie, campings autorisés)',1),
     (100,'UZ1v','Equipements collectifs et touristiques avec secteurs réservés aux gens du voyage',1),
     (101,'UZ2','Campus universitaire',1),
     (102,'UZ2g','Campus universitaire avec hébergement autorisé',1),
     (103,'UZ3','Défense nationale et administration pénitentiaire',1);


-- Les types de prescriptions de niveau 2 propres au PLUi GAM
INSERT INTO urba_plui_ecriture.pluiv_prescriptionurbatype_ct (id,typepsc_ct,libelle_typepsc_ct,id_stypepsc,urlfic) VALUES
     (1,'01-00-37Q','Arbre isolé exceptionnel - EBC',1,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (2,'01-00-37R','Ordonnancement et plantation exceptionnels - EBC',1,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (3,'01-00-37S','Haie agricole et ripisylve exceptionnelles - EBC',1,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (4,'01-00-37T','Boisement et bosquet exceptionnel - EBC',1,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (5,'02-01-ATP','Aléa en attente de précision (Sonnant d''uriage)',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (6,'02-01-ATR','Aléa traduction réglemtaire : Zone d''interdiction',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_2_REGLEMENT_RISQUES.pdf'),
     (7,'02-01-BP','Bande de précaution type Hx100m',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_2_REGLEMENT_RISQUES.pdf'),
     (8,'02-01-BPEDF','Bande de précaution barrage EDF',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_2_REGLEMENT_RISQUES.pdf'),
     (9,'02-01-BR','Bande de recul',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_2_REGLEMENT_RISQUES.pdf'),
     (10,'02-01-D-RC','PPRI Drac - RC : Zone d''interdiction forte',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_2_2_Reglement_type_PPRI_DRAC.pdf'),
     (11,'02-01-D-RC''','PPRI Drac - RC'' : Zone d''interdiction forte',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_2_2_Reglement_type_PPRI_DRAC.pdf'),
     (12,'02-01-D-RCn','PPRI Drac - RCn : Zone d''interdiction',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_2_2_Reglement_type_PPRI_DRAC.pdf'),
     (13,'02-01-D-RCu','PPRI Drac - RCu : Zone d''interdiction',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_2_2_Reglement_type_PPRI_DRAC.pdf'),
     (14,'02-01-DUP','Captage avec arrêté de DUP',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (15,'02-01-IAM-BIu','PPRI Isère Amont - BIu : Zone d''interdiction en attente de révision',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1D_PPRI/1D_1_PPRI_Isere_amont/1D1_4_PPRI_Isere_Amont_Reglement.pdf'),
     (16,'02-01-IAM-BIu2','PPRI Isère Amont - BIu2 : Zone d''interdiction en attente de révision',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1D_PPRI/1D_1_PPRI_Isere_amont/1D1_4_PPRI_Isere_Amont_Reglement.pdf'),
     (17,'02-01-IAM-Blu','PPRI Isère Amont - Blu : Zone d''interdiction en attente de révision',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1D_PPRI/1D_1_PPRI_Isere_amont/1D1_4_PPRI_Isere_Amont_Reglement.pdf'),
     (18,'02-01-IAM-Blu2','PPRI Isère Amont - Blu2 : Zone d''interdiction en attente de révision',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1D_PPRI/1D_1_PPRI_Isere_amont/1D1_4_PPRI_Isere_Amont_Reglement.pdf'),
     (19,'02-01-IAM-RI','PPRI Isère Amont - RI : Zone d''interdiction forte',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1D_PPRI/1D_1_PPRI_Isere_amont/1D1_4_PPRI_Isere_Amont_Reglement.pdf'),
     (20,'02-01-IAM-RIa','PPRI Isère Amont - RIa : Zone d''interdiction',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1D_PPRI/1D_1_PPRI_Isere_amont/1D1_4_PPRI_Isere_Amont_Reglement.pdf'),
     (21,'02-01-IAM-RIn','PPRI Isère Amont - RIn : Zone d''interdiction',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1D_PPRI/1D_1_PPRI_Isere_amont/1D1_4_PPRI_Isere_Amont_Reglement.pdf'),
     (22,'02-01-IAM-RIs','PPRI Isère Amont - RIs : Zone d''interdiction forte (champ d''inondation contrôlée)',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1D_PPRI/1D_1_PPRI_Isere_amont/1D1_4_PPRI_Isere_Amont_Reglement.pdf'),
     (23,'02-01-IAM-RIs2','PPRI Isère Amont - RIs2 : Zone d''interdiction forte en attente de révision (champ d''inondation contrôlée)',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1D_PPRI/1D_1_PPRI_Isere_amont/1D1_4_PPRI_Isere_Amont_Reglement.pdf'),
     (24,'02-01-IAV-RI','PPRI Isère Aval - RI : Zone d''interdiction forte',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1D_PPRI/1D_2_PPRI_Isere_aval/1D2_6_PPRI_Isere_Aval_Reglement.pdf'),
     (25,'02-01-IAV-RIn','PPRI Isère Aval - RIn : Zone d''interdiction',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1D_PPRI/1D_2_PPRI_Isere_aval/1D2_6_PPRI_Isere_Aval_Reglement.pdf'),
     (26,'02-01-PI','Périmètre de protection de captage immédiat ',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (27,'02-01-PM','Périmètre minier inconstructible',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM_20191220/3_1_Reglement_ecrit/T1_2_REGLEMENT_RISQUES.pdf'),
     (28,'02-01-RA-RCn','PPRI Romanche Aval - RCn : Zone d''interdiction ',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1D_PPRI/1D_3_PPRI_Romanche_aval/1D3_5_PPRI_Romanche_Reglement.pdf'),
     (29,'02-01-RA-RCs','PPRI Romanche Aval - RCs : Zone d''interdiction forte',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1D_PPRI/1D_3_PPRI_Romanche_aval/1D3_5_PPRI_Romanche_Reglement.pdf'),
     (30,'02-01-RA-RCu','PPRI Romanche Aval - RCu : Zone d''interdiction ',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1D_PPRI/1D_3_PPRI_Romanche_aval/1D3_5_PPRI_Romanche_Reglement.pdf'),
     (31,'02-01-RH','Captage avec rapport hydrogéologique',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (32,'02-01-ZAM','Zones d’aléas miniers',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_2_REGLEMENT_RISQUES.pdf'),
     (33,'02-01-ZT','Zone de travaux inconstructible',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM_20191220/3_1_Reglement_ecrit/T1_2_REGLEMENT_RISQUES.pdf'),
     (34,'02-01-ZTS','Zones de travaux sans aléas miniers connus',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_2_REGLEMENT_RISQUES.pdf'),
     (35,'02-02-00','PPRN approuvé',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1E_PPRN/'),
     (36,'02-02-01','PPRN en cours d''élaboration',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1E_PPRN/1E_28_PER_LaTronche/1E28_4_PER_LaTronche_Reglement.pdf'),
     (37,'02-02-02','Carte R.111-3',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1E_PPRN/'),
     (38,'02-02-APAC','Aire Probable d''alimentation des captages',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM_20191220/3_1_Reglement_ecrit/T1_2_REGLEMENT_RISQUES.pdf'),
     (39,'02-02-ATP','Aléa en attente de précision',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1E_PPRN/'),
     (40,'02-02-ATR','Aléa traduction réglemtaire : Zone d''autorisation sous prescriptions',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_2_REGLEMENT_RISQUES.pdf'),
     (41,'02-02-b','Zone d''autorisation sous conditions (b)',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1F_PPRT/'),
     (42,'02-02-B','PPRT: Zone d''autorisation limitée (B)',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1F_PPRT/'),
     (43,'02-02-D-BC','PPRI Drac - BC : Zone d''autorisation sous prescriptions importantes',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_2_2_Reglement_type_PPRI_DRAC.pdf'),
     (44,'02-02-D-Bc1','PPRI Drac - Bc1 : Zone d''autorisation sous prescriptions',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_2_2_Reglement_type_PPRI_DRAC.pdf'),
     (45,'02-02-D-Bc2','PPRI Drac - Bc2 : Zone d''autorisation sous prescriptions',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_2_2_Reglement_type_PPRI_DRAC.pdf'),
     (46,'02-02-IAM-Bi1','PPRI Isère Amont - Bi1 : Zone d''autorisation sous prescriptions',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1D_PPRI/1D_1_PPRI_Isere_amont/1D1_4_PPRI_Isere_Amont_Reglement.pdf'),
     (47,'02-02-IAM-Bi2','PPRI Isère Amont - Bi2 : Zone d''autorisation sous prescriptions',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1D_PPRI/1D_1_PPRI_Isere_amont/1D1_4_PPRI_Isere_Amont_Reglement.pdf'),
     (48,'02-02-IAM-Bi3','PPRI Isère Amont - Bi3 : Zone d''autorisation sous prescriptions',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1D_PPRI/1D_1_PPRI_Isere_amont/1D1_4_PPRI_Isere_Amont_Reglement.pdf'),
     (49,'02-02-IAV-bi3','PPRI Isère Aval - bi3 : Zone d''autorisation sous prescriptions',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1D_PPRI/1D_2_PPRI_Isere_aval/1D2_6_PPRI_Isere_Aval_Reglement.pdf'),
     (50,'02-02-IAV-Bi3,r','PPRI Isère Aval - Bi3,r : Zone d''autorisation sous prescriptions',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1D_PPRI/1D_2_PPRI_Isere_aval/1D2_6_PPRI_Isere_Aval_Reglement.pdf'),
     (51,'02-02-IAV-Bir','PPRI Isère Aval - Bir : Zone d''autorisation sous prescriptions',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1D_PPRI/1D_2_PPRI_Isere_aval/1D2_6_PPRI_Isere_Aval_Reglement.pdf'),
     (52,'02-02-ICPE','Installation classée pour la protection de l''environnement',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (53,'02-02-ILL500','Zone de protection Insitut Laue Langevin (ILL)',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_2_REGLEMENT_RISQUES.pdf'),
     (54,'02-02-PE','Périmètre de protection de captage éloigné',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (55,'02-02-PE1','Périmètre de protection de captage éloigné 1',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (56,'02-02-PE2','Périmètre de protection de captage éloigné 2',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (57,'02-02-PM','Périmètre minier constructible',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_2_REGLEMENT_RISQUES.pdf'),
     (58,'02-02-PR','Périmètre de protection de captage rapproché',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (59,'02-02-PR2','Périmètre de protection de captage rapproché',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (60,'02-02-r','PPRT: Zone d''interdiction (r)',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1F_PPRT/'),
     (61,'02-02-R','PPRT: Zone dinterdiction stricte(R)',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1F_PPRT/'),
     (62,'02-02-RA-Bc1','PPRI Romanche Aval - Bc1 : Zone d''autorisation sous prescriptions',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1D_PPRI/1D_3_PPRI_Romanche_aval/1D3_5_PPRI_Romanche_Reglement.pdf'),
     (63,'02-02-RA-Bc2','PPRI Romanche Aval - Bc2 : Zone d''autorisation sous prescriptions',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1D_PPRI/1D_3_PPRI_Romanche_aval/1D3_5_PPRI_Romanche_Reglement.pdf'),
     (64,'02-02-RA-Bi0','PPRI Romanche Aval - Bi0 : Zone d''autorisation sous prescriptions',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1D_PPRI/1D_3_PPRI_Romanche_aval/1D3_5_PPRI_Romanche_Reglement.pdf'),
     (65,'02-02-SCL','Secteur de constructibilité limité',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM_20191220/3_1_Reglement_ecrit/T1_2_REGLEMENT_RISQUES.pdf'),
     (66,'02-02-SUP1','Transport de matière dangeureuse SUP1',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1A_Liste_SUP/1A3_SUP_TMD.pdf'),
     (67,'02-02-SUP2','Transport de matière dangeureuse SUP2',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1A_Liste_SUP/1A3_SUP_TMD.pdf'),
     (68,'02-02-SUP3','Transport de matière dangeureuse SUP3',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1A_Liste_SUP/1A3_SUP_TMD.pdf'),
     (69,'02-02-v','Zone de recommandations (v)',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1F_PPRT/'),
     (70,'02-02-Z1','Zone de prescriptions Sandvik-Eurotungstene Z1',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_2_REGLEMENT_RISQUES.pdf'),
     (71,'02-02-Z2','Zone de prescriptions Sandvik-Eurotungstene Z2',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_2_REGLEMENT_RISQUES.pdf'),
     (72,'02-02-ZCM','Zones de concessions minières',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_2_REGLEMENT_RISQUES.pdf'),
     (73,'02-02-ZG','PPRT: Zone grisée',7,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/01_Servitudes_Utilite_publique/1F_PPRT/'),
     (74,'05-01-A','Création de voirie',13,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (75,'05-01-B','Elargissement de voie',13,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (76,'05-01-C','Régularisation et requalification',13,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (77,'05-01-D','Nouvelle ligne de transport',13,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (78,'05-01-E','Espace public',13,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (79,'05-01-F','Parking public',13,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (80,'05-01-G','Ponts et ouvrages d''art',13,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (81,'05-02-AE','Aménagement hydraulique',14,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (82,'05-02-H','Incendie',14,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (83,'05-02-I','Inondation',14,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (84,'05-02-J','Captage d''eau potable',14,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (85,'05-02-K','Bassin et réservoir',14,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (86,'05-02-L','Station d''épuration',14,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (87,'05-02-M','Collecteur/décanteur d''eaux usées',14,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (88,'05-03-AA','Aménagement paysager/Haie',15,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (89,'05-03-AC','Espace vert de loisirs',15,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (90,'05-03-AF','Equipement public / Installation d''intérêt général',15,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (91,'05-03-N','Voie férée et gare',15,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (92,'05-03-O','Cimetière',15,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (93,'05-03-P','Equipement scolaire',15,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (94,'05-03-Q','Equipement sportif',15,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (95,'05-03-R','Equipement culturel et ludique',15,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (96,'05-03-S','Administration',15,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (97,'05-03-T','Santé',15,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (98,'05-03-U','Aire d''accueil des gens du voyage',15,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (99,'05-03-V','Décharge publique',15,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (100,'05-03-W','Emplacement de collecte et conteneurs',15,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf');
INSERT INTO urba_plui_ecriture.pluiv_prescriptionurbatype_ct (id,typepsc_ct,libelle_typepsc_ct,id_stypepsc,urlfic) VALUES
     (101,'05-03-X','Chargeoir à bois',15,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (102,'05-04-AA','Aménagement paysager',16,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (103,'05-04-AB','Corridor écologique',16,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (104,'05-04-AC','Espace vert non renseigné',16,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (105,'05-04-Y','Parc',16,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (106,'05-04-Z','Jardin',16,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (107,'05-05','Emplacements réservé en vue de la réalisation, dans le respect des objectifs de mixité sociale, de programmes de logements',17,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_2_LISTE_ER_MIXITE_SOCIALE.pdf'),
     (108,'05-06','Servitude de localisation des voies, ouvrages publics, installations d''intérêt général et espaces verts en zone U ou AU',18,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T6_1_LISTE_EMPLACEMENTS_RESERVES.pdf'),
     (109,'05-07','Secteur de projet en attente d''un projet d''aménagement global ',19,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (110,'07-01-11A','Bâti agricole intéressant',23,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (111,'07-01-11B','Bâti domestique intéressant',23,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (112,'07-01-11C','Demeure bourgeoise intéressante',23,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (113,'07-01-11D','Bâti repère intéressant',23,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (114,'07-01-12E','noyau ancien intéressant',23,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (115,'07-01-12F','Cité ouvrière et quartier de villas intéressants',23,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (116,'07-01-12G','ensemble "moderne" intéressant',23,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (117,'07-01-15M','Elément de proximité intéressant',23,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (118,'07-01-15N','Mur et clôture intéressant',23,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (119,'07-01-16O','Canal intéressant',23,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (120,'07-01-16P','Ouvrage d''art intéressant',23,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (121,'07-01-21A','Bâti agricole remarquable',23,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (122,'07-01-21B','Bâti domestique remarquable',23,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (123,'07-01-21C','Demeure bourgeoise remarquable',23,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (124,'07-01-21D','Bâti repère remarquable',23,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (125,'07-01-25M','Elément de proximité remarquable',23,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (126,'07-01-25N','Mur et clôture remarquable',23,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (127,'07-01-31A','Bâti agricole exceptionnel',23,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (128,'07-01-31B','Bâti domestique exceptionnel',23,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (129,'07-01-31C','Demeure bourgeoise exceptionnelle',23,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (130,'07-01-31D','Bâti repère exceptionnel',23,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (131,'07-02-13H','Parc d''accompagnement intéressant',24,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (132,'07-02-13I','Parc public intéressant',24,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (133,'07-02-14J','Espace paysage intéressant',24,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (134,'07-02-14K','Espace naturel intéressant',24,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (135,'07-02-14L','Espace de nature ordinaire intéressant',24,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (136,'07-02-18U','Verger et jardin intéressant',24,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (137,'07-02-23H','Parc d''accompagnement remarquable',24,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (138,'07-02-23I','Parc public remarquable',24,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (139,'07-03-17Q','Arbre isolé intéressant',25,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (140,'07-03-17R','Ordonnancement et plantation intéressant',25,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (141,'07-03-17S','Haie agricole et ripisylve intéressante',25,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (142,'07-03-17T','Boisement et bosquet intéressant',25,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (143,'07-04-19W','Espace de bon fonctionnement de zone humide',26,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (144,'07-04-29W','Zone humide',26,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_3_REGLEMENT_PATRIMOINE.pdf'),
     (145,'14-00','Secteur de plan de masse : Nom du secteur',34,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (146,'15-01-01','Continuité obligatoire',36,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (147,'15-01-01,5','1,5m',36,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (148,'15-01-02','Discontinuité obligatoire',36,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (149,'15-01-02,5','2,5m',36,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (150,'15-01-03','Ligne d''implantation',36,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (151,'15-01-04','4m',36,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (152,'15-01-21,5','21,5m',36,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (153,'15-01-68','68m',36,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (154,'15-03','se référer au plan',38,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (155,'15-03-01','1m',38,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (156,'15-03-01,5','1,5m',38,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (157,'15-03-02','2m',38,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (158,'15-03-02,5','2,5m',38,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (159,'15-03-03','3m',38,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (160,'15-03-03,5','3,5m',38,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (161,'15-03-04','4m',38,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (162,'15-03-04,5','4,5m',38,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (163,'15-03-05','5m',38,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (164,'15-03-06','6m',38,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (165,'15-03-06,5','6,5m',38,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (166,'15-03-07,5','7,5m',38,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (167,'15-03-08','8m',38,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (168,'15-03-08,5','8,5m',38,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (169,'15-03-09','9m',38,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (170,'15-03-10','10m',38,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (171,'15-03-11,5','11,5m',38,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (172,'15-03-13','13m',38,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (173,'16-01','Bâtiment susceptible de changer de destination',41,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (174,'17-00-LA','LA',46,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (175,'17-00-LS15','LS15',46,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (176,'17-00-LS20','LS20',46,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (177,'17-00-LS25','LS25',46,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (178,'17-00-LS30','LS30',46,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (179,'17-00-LS35','LS35',46,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (180,'17-00-LS40','LS40',46,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (181,'17-00-S50','S50',46,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (182,'17-00-SA','SA',46,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (183,'18-00','Secteur comportant des orientations d’aménagement et de programmation (L123-1-4 et R123-3-1) : Nom du secteur',47,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/4_2_OAP_sectorielles/'),
     (184,'18-05-air','OAP: Qualité de l''Air',52,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/4_1_OAP_thematiques/08_OAP_Air.pdf'),
     (185,'18-05-AP1','Bourgs, villages et hameaux',52,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/4_1_OAP_thematiques/OAP_Paysage_Biodiversite/'),
     (186,'18-05-AP10','Plaine agricole',52,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/4_1_OAP_thematiques/OAP_Paysage_Biodiversite/'),
     (187,'18-05-AP11','Plaine urbaine',52,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/4_1_OAP_thematiques/OAP_Paysage_Biodiversite/'),
     (188,'18-05-AP12','Versant boisé',52,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/4_1_OAP_thematiques/OAP_Paysage_Biodiversite/'),
     (189,'18-05-AP13','Ville parc',52,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/4_1_OAP_thematiques/OAP_Paysage_Biodiversite/'),
     (190,'18-05-AP14','Villégiature thermale',52,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/4_1_OAP_thematiques/OAP_Paysage_Biodiversite/'),
     (191,'18-05-AP2','Centre ancien de Grenoble',52,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/4_1_OAP_thematiques/OAP_Paysage_Biodiversite/'),
     (192,'18-05-AP3','Coteau résidentiel',52,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/4_1_OAP_thematiques/OAP_Paysage_Biodiversite/'),
     (193,'18-05-AP4','Faubourgs',52,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/4_1_OAP_thematiques/OAP_Paysage_Biodiversite/'),
     (194,'18-05-AP5','Fond de valée',52,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/4_1_OAP_thematiques/OAP_Paysage_Biodiversite/'),
     (195,'18-05-AP6','Fond de vallée d''activité',52,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/4_1_OAP_thematiques/OAP_Paysage_Biodiversite/'),
     (196,'18-05-AP7','Montagne pastorale',52,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/4_1_OAP_thematiques/OAP_Paysage_Biodiversite/'),
     (197,'18-05-AP8','Pente agricole',52,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/4_1_OAP_thematiques/OAP_Paysage_Biodiversite/'),
     (198,'18-05-AP9','Piémont urbain',52,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/4_1_OAP_thematiques/OAP_Paysage_Biodiversite/'),
     (199,'18-05-UP','Unités paysagères',52,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/4_1_OAP_thematiques/OAP_Paysage_Biodiversite/'),
     (200,'19-00','Secteur protégé en raison de la richesse du sol et du sous-sol',62,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/');
INSERT INTO urba_plui_ecriture.pluiv_prescriptionurbatype_ct (id,typepsc_ct,libelle_typepsc_ct,id_stypepsc,urlfic) VALUES
     (201,'22-00-CUC1000','Centralité Urbaine Commerciale, dimensionnement : 1000 m² de surface de vente maximum par établissement',65,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (202,'22-00-CUC2000','Centralité Urbaine Commerciale, dimensionnement : 2000 m² de surface de vente maximum par établissement',65,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (203,'22-00-CUC3000','Centralité Urbaine Commerciale, dimensionnement : 3000 m² de surface de vente maximum par établissement',65,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (204,'22-00-CUC400','Centralité Urbaine Commerciale, dimensionnement : 400 m² de surface de vente maximum par établissement',65,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (205,'22-00-CUC4000','Centralité Urbaine Commerciale, dimensionnement : 4000 m² de surface de vente maximum par établissement',65,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (206,'22-00-CUC8000','Centralité Urbaine Commerciale, dimensionnement : 8000 m² de surface de vente maximum par établissement',65,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (207,'22-00-EDC1000','Espace de Développement Commercial, dimensionnement : 1000 m² de surface de vente maximum par établissement',65,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (208,'22-00-EDC2000','Espace de Développement Commercial, dimensionnement : 2000 m² de surface de vente maximum par établissement',65,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (209,'22-00-EDC3000','Espace de Développement Commercial, dimensionnement : 3000 m² de surface de vente maximum par établissement',65,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (210,'22-00-EDC400','Espace de Développement Commercial, dimensionnement : 400 m² de surface de vente maximum par établissement',65,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (211,'22-00-EDC4000','Espace de Développement Commercial, dimensionnement : 4000 m² de surface de vente maximum par établissement',65,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (212,'22-00-EDC5000','Espace de Développement Commercial, dimensionnement : 5000 m² de surface de vente maximum par établissement',65,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (213,'22-00-EDC8000','Espace de Développement Commercial, dimensionnement : 8000 m² de surface de vente maximum par établissement',65,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (214,'22-03-L1','L1 : commerces uniquement',68,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (215,'22-03-L2','L2 : commerces et services',68,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (216,'25-00-11Y','Troncons de cours d''eau ou fossé',76,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/'),
     (217,'25-00-12Y','Troncons de cours d''eau reconnus au titre de la trame verte et bleue',76,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/'),
     (218,'26-01-01','Secteur de performances énergétiques renforcées de niveau 1',78,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (219,'26-01-02','Secteur de performances énergétiques renforcées de niveau 2',78,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (220,'28-00','condition de desserte d''accès depuis une voie ouverte au public',80,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (221,'29-01-F1','Secteur d''intensification urbaine de catégorie F1 autour des arrêts TC les mieux desservis',83,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (222,'29-01-F2','Secteur d''intensification urbaine de catégorie F2 autour des arrêts TC les mieux desservis',83,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (223,'29-01-F3','Secteur d''intensification urbaine de catégorie F3 autour des arrêts TC les mieux desservis',83,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (224,'29-01-F4','Secteur d''intensification urbaine de catégorie F4 autour des arrêts TC les mieux desservis',83,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (225,'29-01-F5','Secteur d''intensification urbaine de catégorie F5 autour des arrêts TC les mieux desservis',83,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (226,'29-01-F6','Secteur d''intensification urbaine de catégorie F6 autour des arrêts TC les mieux desservis',83,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (227,'37-02-L3','L3 : linéaire RDC sans logement',106,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (228,'39-02-05','5m',114,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (229,'39-02-11','11m',114,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (230,'39-02-14','14m',114,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (231,'39-02-17','17m',114,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (232,'39-02-20','20m',114,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (233,'39-02-23','23m',114,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (234,'39-02-26','26m',114,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (235,'39-02-29','29m',114,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (236,'39-02-32','32m',114,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (237,'39-02-35','35m',114,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (238,'39-02-38','38m',114,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (239,'39-02-41','41m',114,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (240,'42-00','Variation des surfaces végétalisées (0%) et des surface de pleine terre (0%)',127,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (241,'44-00-C','Principales zones commerciales destinées en priorité aux commerces de non-proximité',132,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (242,'44-00-S1','Centre-ville élargi de Grenoble',132,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (243,'44-00-S2','Coeur métropolitain - 500m autour des stations de transports en commun en site propre et des principales gares',132,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (244,'44-00-S3','Coeur métropolitain - 200m autour des arrêts de transports en commun à forte fréquence, des lignes rapides périurbaines ou des axes chronovélo',132,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (245,'44-00-S4','Coeur métropolitain - Eloigné des réseaux structurants de transports en commun et des axes chronovélo',132,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (246,'44-00-S5','Territoires périurbains, ruraux, et montagnards - 200m autour des arrêts de transports en commun à forte fréquence, des lignes rapides périurbaines ou des axes chronovélo',132,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (247,'44-00-S6','Territoires périurbains, ruraux et montagnards – Eloignés des réseaux structurants de transports en commun et des axes chronovélo',132,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (248,'45-00','Zone d’aménagement concerté : Nom du secteur',139,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (249,'47-03-AC','Zone d''assainissement collectif',144,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/3_1_Reglement_ecrit/T1_1_REGLES_COMMUNES_LEXIQUE.pdf'),
     (250,'99-00-10','Monuments historiques',157,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/');

 -- Les types d'informations de niveau 2 propres au PLUi GAM
 INSERT INTO urba_plui_ecriture.pluiv_informationurbatype_ct (id,typeinf_ct,libelle_typeinf_ct,id_stypeinf,urlfic) VALUES
     (1,'02-00','Zone d''aménagement concerté',2,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/06_Amenagement_Fiscalite/6A_Notice_annexes_amenagement.pdf'),
     (2,'04-00-01','Droit de préemption urbain',4,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/05_Preemption/5A_Notice_annexes_preemption.pdf'),
     (3,'04-01-01','Droit de préemption urbain renforcé',5,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/05_Preemption/5A_Notice_annexes_preemption.pdf'),
     (4,'04-01-02','Droit de préemption urbain renforcé - Etat',5,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/05_Preemption/5A_Notice_annexes_preemption.pdf'),
     (5,'05-00','Zone d''aménagement différé',6,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/05_Preemption/5A_Notice_annexes_preemption.pdf'),
     (6,'07-00-00','Réseau de chaleur classé',8,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/04_Environnement_Energie/4A_Notice_annexes_env_energie.pdf'),
     (7,'08-00-01','Réglementé',9,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/04_Environnement_Energie/4A_Notice_annexes_env_energie.pdf'),
     (8,'08-00-02','Interdit',9,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/04_Environnement_Energie/4A_Notice_annexes_env_energie.pdf'),
     (9,'08-00-03','Bâti',9,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/04_Environnement_Energie/4A_Notice_annexes_env_energie.pdf'),
     (10,'09-00-01','Mine',10,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/04_Environnement_Energie/4A_Notice_annexes_env_energie.pdf'),
     (11,'09-00-02','Après mine',10,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/04_Environnement_Energie/4A_Notice_annexes_env_energie.pdf'),
     (12,'12-00','Périmètre de sursis à statuer',13,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/06_Amenagement_Fiscalite/6A_Notice_annexes_amenagement.pdf'),
     (13,'13-00','Programme d''aménagement d''ensemble',14,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/06_Amenagement_Fiscalite/6A_Notice_annexes_amenagement.pdf'),
     (14,'14-00-01','Secteur affecté par les routes',15,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/03_Nuisances_sonores/3A_Classement_sonore_voies.pdf'),
     (15,'14-00-03','Secteur affecté par le TRAM',15,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/03_Nuisances_sonores/3A_Classement_sonore_voies.pdf'),
     (16,'14-00-05','Secteur affecté par la RFF',15,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/03_Nuisances_sonores/3A_Classement_sonore_voies.pdf'),
     (17,'16-00','Périmètres Archéologiques',17,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM'),
     (18,'20-00-01-A','ZP1A : Coeurs historiques, sites patrimoniaux remarquables',20,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/09_RLPI/9_2_RLPI_Reglement_zonage.pdf'),
     (19,'20-00-01-B','ZP1B : Autres coeurs historiques',20,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/09_RLPI/9_2_RLPI_Reglement_zonage.pdf'),
     (20,'20-00-02','ZP2 : Centralités, pôles de vie',20,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/09_RLPI/9_2_RLPI_Reglement_zonage.pdf'),
     (21,'20-00-03','ZP3 : Trames vertes et bleues',20,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/09_RLPI/9_2_RLPI_Reglement_zonage.pdf'),
     (22,'20-00-04','ZP4 : Secteurs naturels',20,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/09_RLPI/9_2_RLPI_Reglement_zonage.pdf'),
     (23,'20-00-05','ZP5 : Secteurs sensibles',20,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/09_RLPI/9_2_RLPI_Reglement_zonage.pdf'),
     (24,'20-00-06','ZP6 : Zones d''activités économiques et commerciales',20,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/09_RLPI/9_2_RLPI_Reglement_zonage.pdf'),
     (25,'20-00-07-A','ZP7.1 : Routes majeures, Autoroutes et nationales',20,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/09_RLPI/9_2_RLPI_Reglement_zonage.pdf'),
     (26,'20-00-07-B','ZP7.2 : Axes secondaires et historiques, entrée de métropole et entrée de ville',20,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/09_RLPI/9_2_RLPI_Reglement_zonage.pdf'),
     (27,'20-00-07-C','ZP7.3 : Axes d''entrées de ville au sein des sites patrimoniaux remarquables',20,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/09_RLPI/9_2_RLPI_Reglement_zonage.pdf'),
     (28,'20-00-08','ZP8 : Reste du territoire',20,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/09_RLPI/9_2_RLPI_Reglement_zonage.pdf'),
     (29,'20-00-LA','Limite de l''espace aggloméré',20,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/09_RLPI/9_2_RLPI_Reglement_zonage.pdf'),
     (30,'25-00-00','Périmètre de protection et de mise en valeur des espaces agricoles et naturels périurbains (PAEN)',25,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/04_Environnement_Energie/4A_Notice_annexes_env_energie.pdf'),
     (31,'27-00-A',NULL,27,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/03_Nuisances_sonores/3B_PEB_Versoud.pdf'),
     (32,'27-00-B',NULL,27,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/03_Nuisances_sonores/3B_PEB_Versoud.pdf'),
     (33,'27-00-C',NULL,27,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/03_Nuisances_sonores/3B_PEB_Versoud.pdf'),
     (34,'27-00-D',NULL,27,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/03_Nuisances_sonores/3B_PEB_Versoud.pdf'),
     (35,'30-00-00','Périmètre projet urbain partenarial',30,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/06_Amenagement_Fiscalite/6A_Notice_annexes_amenagement.pdf'),
     (36,'30-00-01','Convention projet urbain partenarial',30,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/06_Amenagement_Fiscalite/6A_Notice_annexes_amenagement.pdf'),
     (37,'32-00-01','Taxe d''Aménagement',32,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/04_Environnement_Energie/4A_Notice_annexes_env_energie.pdf'),
     (38,'32-00-02','Taxe d''Aménagement Majorée',32,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/04_Environnement_Energie/4A_Notice_annexes_env_energie.pdf'),
     (39,'37-00-01','Bois ou forêt communale',37,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/04_Environnement_Energie/4A_Notice_annexes_env_energie.pdf'),
     (40,'37-00-02','Bois ou forêt domaniale',37,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM/5_Annexes/04_Environnement_Energie/4A_Notice_annexes_env_energie.pdf'),
     (41,'38-00-01','',38,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM'),
     (42,'99-00-01','Réserve naturelle Nationale',47,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM'),
     (43,'99-00-02','Réserve naturelle Régionale',47,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM'),
     (44,'99-00-03','Déchèterie',47,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM'),
     (45,'99-00-04','Points d''apport volontaire (OMR-CS-Verre)',47,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM'),
     (46,'99-00-05','Porte à porte (OMR) et points d''apport volontaire (CS-Verre)',47,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM'),
     (47,'99-00-06','Porte à porte (OMR-CS) et points d''apport volontaire (Verre)',47,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM'),
     (48,'99-00-07','Construction ou installlation destinée à l''activité agricole',47,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM'),
     (49,'99-00-08','Périmètre de réciprocité de 50m',47,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM'),
     (50,'99-00-09','Périmètre de réciprocité de 100m',47,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM'),
     (51,'99-00-10','Monuments historiques',47,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM'),
     (52,'99-01-01','Zones urbanisées (Rapport de présentation)',48,'https://sitdl.lametro.fr/urba_posplu/PLUI_GAM');


-- Les 49 communes de GAM

INSERT INTO urba_plui_ecriture.ref_limites_communales (ogc_fid,geom,code_insee,nom,nom_etiquette,nom_abv,trigram) VALUES
     (29,'SRID=3945;POLYGON ((1915274.7848220733 4219562.89993174, 1915304.4804840123 4219575.518865458, 1915325.1423682799 4219584.661343208, 1915336.6878095665 4219589.916261781, 1915352.381859117 4219597.117211213, 1915355.3993322926 4219598.536985043, 1915370.9981523075 4219605.853315649, 1915382.4048955825 4219611.629595196, 1915390.0557757155 4219615.580017648, 1915395.9347994737 4219618.620436222, 1915397.5004345654 4219619.426416235, 1915413.132278097 4219602.225604224, 1915415.379755937 4219599.536211422, 1915415.4647895459 4219599.434450494, 1915415.9158571858 4219598.825465707, 1915421.7145125521 4219590.959978476, 1915442.8570417196 4219561.709969469, 1915448.7604954941 4219553.547883481, 1915451.1547260582 4219550.313645679, 1915451.9568059773 4219549.233233453, 1915462.8516080345 4219534.250010327, 1915464.5086421052 4219531.9719949225, 1915465.717136737 4219530.311470481, 1915479.8018678636 4219510.963457077, 1915485.005743843 4219503.889145655, 1915492.373961441 4219493.882027081, 1915506.8547798286 4219474.17284975, 1915507.3473187624 4219473.503777566, 1915507.8426843458 4219472.831900278, 1915509.9821873421 4219469.918760997, 1915510.338097849 4219469.434592447, 1915510.3981927943 4219469.3529780945, 1915510.5053612792 4219469.211484336, 1915522.9652235878 4219452.732832635, 1915529.0652186365 4219445.030541487, 1915534.5000903045 4219438.126663403, 1915534.7410380873 4219437.611670449, 1915546.291537952 4219437.472442559, 1915564.0747251501 4219437.173111478, 1915570.308086412 4219436.778286785, 1915580.8148481746 4219436.437093645, 1915588.000251544 4219436.250098964, 1915589.590468488 4219436.215740776, 1915605.0487965497 4219435.865885303, 1915633.5180943205 4219434.663775712, 1915639.796028181 4219434.382901408, 1915707.8757147547 4219431.355056904, 1915723.7908759178 4219430.424123765, 1915740.4702458754 4219429.513484769, 1915747.7666067814 4219429.243643724, 1915754.0357684437 4219429.20300311, 1915760.638021585 4219429.490196456, 1915765.116146084 4219429.954524863, 1915769.403908916 4219430.579722453, 1915773.2107232797 4219431.283269524, 1915780.2551181854 4219432.91654142, 1915794.5762022603 4219436.373402957, 1915800.6611501102 4219437.536401384, 1915812.4607667516 4219438.577950811, 1915814.4829180937 4219438.613482145, 1915815.466763722 4219438.62538658, 1915817.7614814795 4219438.407314816, 1915819.146107898 4219438.278167365, 1915826.583289963 4219437.3237831285, 1915826.783375618 4219437.285797694, 1915827.602800803 4219437.095813398, 1915837.6451449282 4219434.769493244, 1915840.241275881 4219434.088975813, 1915841.3191145102 4219433.806859657, 1915855.2021837125 4219429.78243648, 1915860.7894626195 4219428.096025157, 1915874.487253951 4219423.997900761, 1915884.4226573904 4219421.564641231, 1915892.4386478672 4219419.835134504, 1915895.6263727758 4219419.212573789, 1915899.4309292596 4219418.49734537, 1915908.0856844457 4219416.866918883, 1915917.6463163637 4219415.08214437, 1915919.9065881344 4219414.644868342, 1915924.4981784176 4219413.63516729, 1915924.5681939689 4219413.619805772, 1915924.688174445 4219413.592656743, 1915934.0555015656 4219411.472438322, 1915935.444699421 4219411.089639299, 1915952.7776277624 4219405.894679541, 1915968.5525644347 4219400.440033561, 1915980.694881883 4219394.917779259, 1916002.2518335576 4219383.065710448, 1916038.3089144635 4219364.49385754, 1916064.4935888767 4219350.861283472, 1916074.1275451002 4219345.982402696, 1916086.1363090847 4219339.741746275, 1916088.5350841382 4219338.566637114, 1916095.8697076978 4219335.203827375, 1916096.0855470165 4219335.105534487, 1916099.5361675648 4219333.565548541, 1916104.2591764783 4219331.834665933, 1916109.2669822415 4219330.194248807, 1916117.3132329201 4219327.887297723, 1916123.645153626 4219326.411290073, 1916126.0762431019 4219325.9560291, 1916129.4009950473 4219325.828246928, 1916146.7210526315 4219325.869939271, 1916147.924342536 4219325.544090901, 1916154.1494539154 4219325.890637212, 1916182.9947042426 4219328.506753937, 1916219.0591453186 4219331.632788743, 1916228.4903509999 4219332.384662668, 1916228.7616111285 4219332.349372308, 1916231.6129216575 4219332.034229556, 1916235.1941427428 4219332.324015452, 1916293.362792918 4219334.123295966, 1916349.4918466911 4219335.4521814855, 1916418.1746011905 4219337.505401341, 1916419.8495178118 4219341.026122594, 1916429.2027440907 4219341.438108773, 1916518.254689998 4219346.221789895, 1916596.4746894403 4219350.292947232, 1916599.6082813595 4219350.459443916, 1916605.1625731494 4219350.754542189, 1916613.1431140634 4219351.178330224, 1916622.515571987 4219351.666533997, 1916669.4766277468 4219353.9801686155, 1916669.5978502228 4219353.7168350825, 1916669.8655435094 4219353.728711163, 1916672.281855562 4219348.36364379, 1916677.4005055362 4219336.9320929395, 1916749.8667558192 4219175.1652115835, 1916795 4219075.18, 1916793.449420004 4219074.402665589, 1916850.8804180692 4218944.412218997, 1916930.1211725546 4218762.287382218, 1916953.3090395462 4218709.562036054, 1917026.0347115349 4218542.942238964, 1917248.8201105902 4218424.631070399, 1917441.6415435222 4218322.529321862, 1917505.198554428 4218289.051537079, 1917498.355079273 4218271.631067361, 1917479.0525704857 4218231.678628107, 1917450.7727121096 4218173.107097503, 1917427.5003481887 4218146.690910763, 1917375.2875320048 4218099.593405425, 1917339.2662795077 4218062.175034022, 1917329.3000602904 4218049.185652089, 1917322.3419058677 4218038.810374131, 1917317.895926541 4218030.960170009, 1917316.8183382011 4218029.070976462, 1917314.9377544904 4218025.055356398, 1917314.4462428945 4218023.824303828, 1917314.4478251934 4218023.354186435, 1917314.48492327 4218018.004709269, 1917340.0856405196 4217985.488864414, 1917340.081106002 4217983.355373887, 1917340.076449537 4217981.164507136, 1917340.0733245867 4217979.69421805, 1917307.3078997976 4217948.130323433, 1917287.1612867685 4217927.13267927, 1917261.6631162008 4217894.104187253, 1917245.0055638365 4217870.0314974515, 1917214.0015710748 4217822.55290217, 1917196.2692884377 4217794.041521928, 1917184.615030779 4217767.427635043, 1917157.465875571 4217712.39295681, 1917144.2252180546 4217682.30700361, 1917123.67319845 4217611.181791509, 1917113.93 4217588.32, 1917102.5209414777 4217565.334765747, 1917091.5515033223 4217551.711824282, 1917085.24 4217555.2, 1917081.40990869 4217556.695661356, 1917070.485931174 4217558.65597166, 1917027.3961114427 4217579.89404145, 1917012.8 4217587.2, 1917011.86 4217586.78, 1917008.2 4217588.41, 1916998.9138919548 4217581.769839515, 1916996.004986008 4217547.386962075, 1917008.6725439827 4217444.205228277, 1917010.3865638596 4217439.270717823, 1917027.716561807 4217400.652029465, 1917026.8301883228 4217400.566534714, 1917026.8977230075 4217400.418466071, 1916813.0055478222 4217379.603300001, 1916804.1385182373 4217378.480040316, 1916790.956330375 4217367.401307207, 1916776.2297828377 4217357.038662881, 1916762.2425513933 4217345.308456261, 1916760.7891153274 4217338.831105418, 1916760.9445379267 4217336.149848419, 1916761.614625642 4217329.618110298, 1916762.2117543716 4217324.768265054, 1916763.396389548 4217316.943826796, 1916763.6267343129 4217313.045332671, 1916762.621362628 4217312.914300816, 1916762.7549998069 4217309.046873058, 1916717.6975346238 4217305.000022355, 1916700.0556313037 4217317.849733684, 1916688.7747483833 4217326.166508097, 1916684.5022130616 4217330.709522707, 1916677.1698655628 4217338.544177365, 1916672.613964641 4217344.91703712, 1916666.2506152566 4217362.854496437, 1916657.7049930694 4217390.113743598, 1916649.4207152228 4217405.952373552, 1916637.6663111653 4217422.464127406, 1916631.5884662622 4217428.310504283, 1916626.2634316909 4217432.93170609, 1916604.5467611335 4217445.953279352, 1916509.0120200193 4217503.094621037, 1916509.205974266 4217503.483116381, 1916506.8240656299 4217504.90196073, 1916518.3184032093 4217528.708311934, 1916512.1235780572 4217530.139545941, 1916507.0977192384 4217531.35301771, 1916492.6337733006 4217531.362385729, 1916464.470826391 4217532.613254812, 1916443.3925761273 4217538.145147707, 1916374.1884691468 4217566.766287134, 1916308.002150009 4217594.295903173, 1916155.7345905078 4217656.564165727, 1916155.0912537097 4217657.614946065, 1916152.5026248493 4217658.666819759, 1916073.493572234 4217787.252532204, 1916072.0729333383 4217786.093712254, 1916068.9969685168 4217791.085331906, 1916048.4220482248 4217769.07785695, 1916048.3604563577 4217769.128719911, 1916048.194146276 4217768.792394821, 1916033.4937950226 4217780.826655765, 1915985.4956215464 4217819.593041385, 1915977.0032960265 4217827.635514957, 1915927.0005357028 4217876.69121742, 1915919.8332443764 4217883.576084365, 1915917.215748988 4217886.0883249, 1915902.1086017466 4217901.090561867, 1915892.1772879006 4217911.004376783, 1915890.1804466106 4217913.038279663, 1915863.5029048717 4217940.247350433, 1915855.352188221 4217949.113872766, 1915841.1728816235 4217962.639586266, 1915834.2415014412 4217968.083000085, 1915832.6842073416 4217969.427391509, 1915821.5726855628 4217978.956226022, 1915814.9687233553 4217984.2555955555, 1915804.829823812 4217994.563361128, 1915804.8185499439 4217994.585578993, 1915802.4418149884 4217999.628514746, 1915795.5157275056 4218009.806091333, 1915787.6469629426 4218019.906685035, 1915786.7311185922 4218019.145677679, 1915786.30881415 4218018.794770031, 1915773.7252196963 4218038.203920151, 1915768.6460988796 4218046.017654826, 1915757.87801872 4218064.060893236, 1915754.8521438027 4218069.135605556, 1915754.6350468136 4218069.5976205515, 1915750.2456553758 4218081.233543578, 1915743.7677561508 4218099.802903965, 1915740.3838696012 4218111.746616594, 1915737.101171219 4218135.349374827, 1915736.6693962812 4218142.966695165, 1915736.4073545279 4218161.0159077, 1915739.171518583 4218192.7079746155, 1915742.0226118013 4218214.151088962, 1915744.495705917 4218241.295801015, 1915744.5517339464 4218245.005165608, 1915742.98652012 4218280.61961884, 1915712.7309633996 4218287.653031262, 1915697.5112276804 4218290.100282382, 1915643.7835640917 4218283.601774751, 1915561.2496465407 4218272.6642571585, 1915560.244711449 4218276.743515942, 1915556.3901151933 4218295.29925247, 1915556.206546181 4218300.060050641, 1915556.2244918211 4218304.144176051, 1915559.3079256362 4218324.372797008, 1915562.2615135564 4218336.054142372, 1915565.807264735 4218357.938962221, 1915575.4170833395 4218393.590436023, 1915580.7534126523 4218415.501282646, 1915582.234752423 4218424.433635281, 1915585.8871408494 4218441.035400497, 1915592.9842273693 4218473.838968556, 1915595.1293480883 4218499.085224027, 1915595.089966606 4218516.535386777, 1915594.1035767726 4218522.522981027, 1915591.9940005448 4218530.572376422, 1915589.236487199 4218538.419632527, 1915588.60874636 4218540.223247013, 1915585.3610398143 4218547.455034077, 1915580.4305124127 4218553.307015846, 1915568.6160547426 4218562.101650671, 1915559.8283100543 4218569.582650521, 1915550.1367260944 4218579.742514394, 1915543.9654893226 4218606.491357369, 1915541.544335175 4218630.220987523, 1915542.3472483454 4218647.181201105, 1915544.0803525706 4218658.044222663, 1915546.5368033517 4218670.392639708, 1915549.5914371319 4218676.079249877, 1915561.2824743907 4218693.346964632, 1915573.0517262956 4218727.324914492, 1915578.1716047218 4218745.308997929, 1915577.820129107 4218751.329379003, 1915570.0203293457 4218782.092971046, 1915564.604374769 4218804.058958508, 1915560.7583240594 4218822.613413041, 1915554.9343153366 4218850.264877347, 1915551.5593908275 4218870.184630543, 1915544.2321220122 4218872.978660942, 1915528.0978492624 4218880.717806992, 1915518.91 4218886.33, 1915517.0544696478 4218888.805587915, 1915508.3064179388 4218904.007510187, 1915506.226317757 4218907.831458994, 1915500.6735845369 4218917.892122769, 1915497.0757430939 4218924.614862451, 1915493.7400152136 4218930.12944726, 1915491.8334927817 4218933.293201371, 1915486.9480560147 4218940.565734003, 1915482.9974015998 4218946.117973532, 1915480.8743521788 4218949.091399365, 1915475.5711121596 4218956.117531635, 1915473.7802408645 4218958.471376018, 1915469.5216021428 4218964.102822709, 1915463.884379011 4218971.298523002, 1915460.3368418098 4218975.4491312355, 1915459.0084212418 4218977.000111229, 1915446.8458067074 4218990.549464552, 1915439.949414853 4218997.264037235, 1915435.2958736024 4219001.416394055, 1915427.341289676 4219008.3688152265, 1915426.9787429457 4219008.80198755, 1915426.817990115 4219008.993515903, 1915426.4003511607 4219009.888499221, 1915426.1723613478 4219010.358216723, 1915424.8778532287 4219013.425699896, 1915419.3806800311 4219026.4468406355, 1915415.4746243544 4219033.397352065, 1915412.640984454 4219038.225596251, 1915408.7151487814 4219044.969834526, 1915406.3420714133 4219048.541253726, 1915406.1124999989 4219048.865000001, 1915402.8163402549 4219053.517403189, 1915399.57719002 4219057.938446211, 1915393.7679056947 4219065.255631596, 1915388.901752857 4219071.229167203, 1915383.791994832 4219077.500200642, 1915380.0516123828 4219082.350144609, 1915376.5435156773 4219087.20697281, 1915370.470672441 4219096.538276417, 1915369.339451825 4219098.310336384, 1915365.8927801584 4219103.301672159, 1915365.1805814805 4219104.288666817, 1915364.3739215846 4219105.33634125, 1915361.0416499423 4219109.689762958, 1915342.5844083861 4219130.654658136, 1915327.8531279955 4219145.345102543, 1915323.489792054 4219148.876297111, 1915319.027900483 4219151.945218571, 1915308.6677683496 4219159.181430629, 1915296.9159568064 4219167.955563113, 1915291.8517295027 4219171.7637387505, 1915284.2869112627 4219177.677696246, 1915275.9701077489 4219184.255192871, 1915270.7760665414 4219188.478920773, 1915260.1408386268 4219197.355248996, 1915259.264160215 4219198.102338175, 1915255.288388522 4219201.488740825, 1915254.3188436327 4219202.365111275, 1915243.1812014296 4219213.338718649, 1915232.3405798369 4219224.806555654, 1915226.5252058434 4219230.964385898, 1915220.7778985759 4219237.114163697, 1915210.4154495846 4219248.376161468, 1915204.7048094855 4219254.782935987, 1915201.3575614034 4219258.488351586, 1915198.872998385 4219261.078914169, 1915193.7899301958 4219266.188247821, 1915188.4364725454 4219270.619154114, 1915184.4479893895 4219273.228464593, 1915179.0305561116 4219275.45954995, 1915173.9258658295 4219277.219394784, 1915146.2067768362 4219285.916424299, 1915117.2073642174 4219295.363807322, 1915093.0834743143 4219304.938274504, 1915073.701931744 4219311.359756844, 1915063.704092948 4219313.921866906, 1915053.765520452 4219315.423840723, 1915028.2606960945 4219318.336494057, 1915018.5805270704 4219319.429595397, 1915005.0740679041 4219321.32364539, 1915004.2337182327 4219321.581388368, 1915002.455346172 4219322.149906452, 1915001.5057008315 4219322.613928287, 1915000.471696662 4219323.108142416, 1914997.6843190417 4219325.118252538, 1914996.3580169084 4219326.677048512, 1914993.2124746244 4219332.548981973, 1914989.5626275565 4219341.661123993, 1914986.7210407315 4219358.958280918, 1914986.138419875 4219362.625348794, 1914983.5117988617 4219383.454313327, 1914983.1197948144 4219386.558616709, 1914982.4120829904 4219392.19592211, 1914981.9799048658 4219395.294855798, 1914981.646488809 4219397.697023347, 1914977.2481233387 4219426.699923359, 1914975.420134795 4219438.784148721, 1914973.4772017237 4219452.794683347, 1914973.7477142161 4219452.860662004, 1914973.6741004726 4219453.362540693, 1914975.9656285555 4219453.728364558, 1914993.8708083373 4219458.222824002, 1915002.5841696325 4219460.5360304685, 1915011.0162159558 4219463.02517824, 1915019.5384955707 4219465.686039757, 1915035.97275392 4219470.86015106, 1915036.3559179304 4219470.981545275, 1915037.5782902238 4219471.375595528, 1915038.6124311024 4219471.709506957, 1915039.4248987534 4219471.971979745, 1915041.7966567292 4219472.737101829, 1915045.1645910232 4219473.825759839, 1915047.4911654152 4219474.590072749, 1915071.3451294797 4219482.471377306, 1915087.7585911173 4219488.063678286, 1915102.3948803418 4219493.165424576, 1915117.0397576694 4219498.360932041, 1915145.6397444743 4219509.84839423, 1915167.3892450945 4219518.728655329, 1915240.3043773235 4219548.495973338, 1915274.7848220733 4219562.89993174))'::geometry,'38057','Bresson','BRESSON','BRE','BRE'),
     (25,'SRID=3945;POLYGON ((1917340.0856405196 4217985.488864414, 1917314.48492327 4218018.004709269, 1917314.4478251934 4218023.354186435, 1917314.4462428945 4218023.824303828, 1917314.9377544904 4218025.055356398, 1917316.8183382011 4218029.070976462, 1917317.895926541 4218030.960170009, 1917322.3419058677 4218038.810374131, 1917329.3000602904 4218049.185652089, 1917339.2662795077 4218062.175034022, 1917375.2875320048 4218099.593405425, 1917427.5003481887 4218146.690910763, 1917450.7727121096 4218173.107097503, 1917479.0525704857 4218231.678628107, 1917498.355079273 4218271.631067361, 1917505.198554428 4218289.051537079, 1917441.6415435222 4218322.529321862, 1917248.8201105902 4218424.631070399, 1917026.0347115349 4218542.942238964, 1916953.3090395462 4218709.562036054, 1916930.1211725546 4218762.287382218, 1916850.8804180692 4218944.412218997, 1916793.449420004 4219074.402665589, 1916795 4219075.18, 1916797.7842858946 4219076.502342735, 1916798.2246932853 4219075.552242679, 1916841.9762414931 4219097.2711936245, 1916851.6945961476 4219102.985520827, 1916880.840245716 4219122.633184221, 1916881.879135313 4219122.5976394955, 1916899.329320597 4219120.565566168, 1916926.5394611252 4219137.156607637, 1916984.8310737207 4219139.007612158, 1916987.2320169194 4219140.496370617, 1917005.6548295429 4219157.701033168, 1917026.035620776 4219212.145549904, 1917114.0720559051 4219389.089728412, 1917202.3666455252 4219568.064607528, 1917270.8293842897 4219706.6465215795, 1917317.0458269434 4219799.759952931, 1917361.653517486 4219888.770672179, 1917380.3925000208 4219927.503749992, 1917427.8931250286 4220023.328749991, 1917449.7466742597 4220068.277291666, 1917454.3283414661 4220048.990893663, 1917456.318387064 4220032.211980942, 1917460.8325129014 4220021.593586707, 1917465.1736217944 4220016.152154977, 1917480.3049805935 4220004.535452017, 1917509.8620833158 4219991.431249886, 1917530.5299999742 4219982.784999864, 1917547.4629166264 4219977.614999836, 1917586.4499999548 4219968.61916651, 1917602.667083274 4219961.78749986, 1917612.1684210526 4219955.144494473, 1917622.002108332 4219945.44898034, 1917632.3259747326 4219933.194859663, 1917647.2654535288 4219923.150918092, 1917660.5134505245 4219918.916401562, 1917677.7610579524 4219914.804395588, 1917693.4456080792 4219909.539349668, 1917726.2447983255 4219884.747613097, 1917746.6423888234 4219867.687514424, 1917768.2488328235 4219845.327668936, 1917822.7416650762 4219778.321092604, 1917843.874019914 4219760.601379732, 1917852.4194483645 4219766.600716804, 1917862.8695482232 4219771.198837773, 1917871.6311217702 4219774.220649374, 1917898.0207042508 4219778.241320817, 1917931.6166666718 4219779.357499963, 1917959.7181250125 4219781.1295833215, 1917975.2090720101 4219789.179205705, 1917990.2380920423 4219800.22710819, 1917998.0362499992 4219804.349583321, 1918048.5935416692 4219838.992499978, 1918091.3312500122 4219921.183541666, 1918103.4648800755 4219942.757215356, 1918114.223921847 4219964.738853092, 1918114.2832593594 4219964.829237167, 1918116.621421126 4219968.1273266515, 1918120.833486471 4219970.385185773, 1918123.2920568595 4219971.362078355, 1918128.277073407 4219972.898592898, 1918129.7299502026 4219973.335804179, 1918133.7648994182 4219974.767591584, 1918136.4758144328 4219976.10027485, 1918141.7741666927 4219978.513124997, 1918148.223519507 4219983.344833446, 1918168.3612500315 4219996.171666666, 1918178.249585115 4220002.50968858, 1918188.230335023 4220005.671165819, 1918202.7761033173 4220007.988054942, 1918216.8236208898 4220011.565632039, 1918229.6458149375 4220020.655412055, 1918236.7801277572 4220024.22424627, 1918245.2638294676 4220018.488208781, 1918250.3348751997 4220015.060919048, 1918250.4446892263 4220014.986701135, 1918250.4820656464 4220014.961440468, 1918252.19873587 4220013.801259761, 1918257.9835585128 4220009.891818671, 1918284.1974677863 4219992.1759556355, 1918337.5855228587 4219956.09822113, 1918399.583133973 4219914.200267557, 1918412.4910906341 4219905.476922033, 1918428.0973531988 4219894.9264224665, 1918458.974291067 4219874.060936908, 1918502.3992823665 4219844.716040725, 1918520.677819186 4219832.3633744605, 1918520.6893548262 4219832.355578625, 1918520.8573215713 4219832.2420669375, 1918522.0584526628 4219831.4303539395, 1918526.4840179444 4219828.439626591, 1918553.385499798 4219810.259669966, 1918554.3970171807 4219808.704999764, 1918557.6065366021 4219803.772507034, 1918600.914548952 4219737.217997769, 1918607.1289255447 4219727.667847992, 1918608.3148975954 4219725.845274137, 1918608.7541840444 4219725.170188924, 1918608.9101306458 4219724.930534737, 1918608.911323844 4219724.928700915, 1918608.9247609756 4219724.908051259, 1918608.9283486109 4219724.902537781, 1918608.9293038636 4219724.901069814, 1918608.9308392648 4219724.898718573, 1918608.9334821436 4219724.894683294, 1918608.942052767 4219724.88159725, 1918608.9745242058 4219724.832018261, 1918609.0173088992 4219724.766692489, 1918610.8220798061 4219722.011079778, 1918615.0111052946 4219715.615070234, 1918624.65174559 4219700.895267879, 1918642.014233127 4219674.385370494, 1918648.023830506 4219665.209622511, 1918655.794090405 4219653.345608676, 1918662.9348258865 4219642.44269418, 1918685.55753942 4219607.900791308, 1918714.8640440337 4219563.153620064, 1918781.76 4219461, 1918782.4102847618 4219460.130414378, 1918807.45 4219426.65, 1918814.4106152302 4219427.679479297, 1918815.225735714 4219425.853967709, 1918817.9766678484 4219425.572344093, 1918820.5216780745 4219412.490962015, 1918821.2086821732 4219409.742838614, 1918821.790014372 4219408.539281326, 1918826.2651281944 4219402.367371776, 1918828.4662360095 4219399.597904475, 1918834.0406891 4219393.205416666, 1918839.7157624022 4219387.187450226, 1918840.4840796445 4219386.3860000465, 1918844.196038826 4219382.785500314, 1918844.7433318726 4219382.255741109, 1918845.5084163365 4219381.512911775, 1918857.1419787568 4219370.175716633, 1918861.1244528303 4219366.081122504, 1918871.5661053623 4219354.981693321, 1918877.8100271656 4219348.309960674, 1918883.6631568018 4219344.53391592, 1918885.6327420298 4219344.2981252475, 1918892.9898097694 4219340.868212287, 1918900.7745038685 4219337.8373844465, 1918910.6065639048 4219333.270389324, 1918912.8951805814 4219332.248818125, 1918924.2188238024 4219325.581425747, 1918920.4287638885 4219319.391766419, 1918918.875513557 4219317.039225517, 1918914.806887706 4219310.970545985, 1918910.4988326188 4219303.609445619, 1918909.5199738732 4219301.750422239, 1918903.9411043196 4219289.929174412, 1918903.2494777031 4219288.113858912, 1918903.204145234 4219287.988007931, 1918902.1860562128 4219284.30135259, 1918901.2499118652 4219280.906386214, 1918900.4985170402 4219278.174555748, 1918899.6929858886 4219275.012273266, 1918896.3647756565 4219260.2187660225, 1918895.9334950428 4219258.296481729, 1918895.7234010533 4219257.301745674, 1918895.2335067086 4219254.978169242, 1918892.082533527 4219239.291813431, 1918889.9743095494 4219231.6925238585, 1918887.7286822607 4219223.447490001, 1918884.627793856 4219213.452493322, 1918883.2635188266 4219208.908935362, 1918882.981703375 4219207.403256219, 1918882.9427433629 4219207.042876107, 1918882.6192669629 4219199.849315044, 1918883.2241666769 4219194.724791668, 1918885.8739960853 4219181.628056855, 1918888.8776493676 4219170.571916267, 1918890.620938199 4219161.223641882, 1918889.7715626804 4219155.446405364, 1918889.2669620386 4219153.2804050585, 1918887.4117575784 4219147.56583237, 1918885.875526509 4219143.010363655, 1918884.2331701303 4219138.143647087, 1918883.0631889352 4219135.11298078, 1918878.8407201774 4219126.26856318, 1918872.4982689815 4219114.310753654, 1918871.138605767 4219111.423445486, 1918867.3628169405 4219102.1950386325, 1918866.7834053233 4219100.312419758, 1918864.6033064502 4219091.327932178, 1918864.6574028493 4219091.2236232245, 1918864.8874839835 4219089.4214262795, 1918868.7585869124 4219084.184426397, 1918876.016804704 4219074.966611606, 1918878.59276565 4219071.102192461, 1918890.8812527328 4219050.731108484, 1918896.707361358 4219041.417113014, 1918907.262855569 4219023.604632169, 1918913.570797012 4219014.012661474, 1918918.7321041906 4219007.074102233, 1918922.114423085 4219003.501907045, 1918923.3336244046 4219002.835148391, 1918924.5202359543 4219002.448182818, 1918926.0501006404 4219002.0751133645, 1918927.1519836492 4219002.149381769, 1918928.8845833885 4219002.288040013, 1918932.8399354136 4219003.595924833, 1918940.0554653828 4219006.732787673, 1918944.0840013837 4219008.347153448, 1918950.2405104137 4219009.460528872, 1918956.0617692543 4219007.5403133575, 1918958.2304166665 4219005.801250006, 1918964.6930988708 4218995.337637682, 1918970.4677853244 4218985.09458236, 1918976.3082123655 4218975.243409195, 1918981.9409009393 4218968.303705803, 1918988.4131376024 4218961.20089658, 1918994.1967201484 4218954.108666672, 1918998.3584921227 4218947.652875485, 1919002.1090300046 4218940.652234776, 1919007.6901039307 4218927.715031551, 1919014.6877313575 4218910.5958583485, 1919018.5957726082 4218901.541709474, 1919027.9025000047 4218879.640032032, 1919031.912081737 4218870.332110394, 1919034.1840884679 4218861.208121372, 1919035.8735390902 4218845.095548205, 1919034.9615099307 4218836.362283535, 1919033.7358969438 4218827.400767331, 1919033.111081173 4218824.026265231, 1919031.3868590107 4218810.321077716, 1919031.080160255 4218799.561891012, 1919031.5835244632 4218792.935679679, 1919033.2681443205 4218775.965640229, 1919036.3645827896 4218747.660521611, 1919038.2235056427 4218740.488289482, 1919041.6668020452 4218733.849942143, 1919041.8045369314 4218733.6118017705, 1919043.064588448 4218731.494277852, 1919043.624068663 4218730.622087921, 1919044.4281684859 4218729.381155565, 1919045.4546256796 4218727.947712644, 1919052.694743573 4218717.926730756, 1919055.7034277427 4218714.169676678, 1919064.1413192777 4218704.396296493, 1919064.9834798889 4218703.474022572, 1919066.5917163189 4218701.739120106, 1919068.2229202571 4218700.188757693, 1919073.5041517778 4218695.299970462, 1919083.261275882 4218687.156220598, 1919093.6072128566 4218679.903754594, 1919099.6212959692 4218677.267971718, 1919110.699898062 4218672.670111373, 1919114.3930232485 4218669.057929657, 1919114.4062499877 4218668.806602575, 1919110.0428823181 4218664.016230977, 1919109.8433281477 4218663.792327487, 1919109.6414762228 4218663.630159244, 1919108.885801587 4218663.187952217, 1919108.6805371053 4218663.145179351, 1919108.5944048222 4218663.121759025, 1919104.694231497 4218663.007646409, 1919104.209569672 4218663.051251464, 1919103.2029043706 4218663.305314611, 1919096.2666739323 4218665.101229653, 1919089.7186876088 4218666.703119288, 1919089.184971625 4218667.26612514, 1919086.583670758 4218670.0266120015, 1919085.6755143274 4218670.78385946, 1919085.4015666104 4218671.010527669, 1919084.1347463105 4218671.853198456, 1919082.5150645166 4218672.922453772, 1919081.1539994366 4218673.73057494, 1919079.965969813 4218674.441083545, 1919079.855602783 4218674.457927059, 1919079.7150689897 4218674.462681464, 1919078.2561016958 4218674.5250220215, 1919077.0503164749 4218674.389069516, 1919076.3717089458 4218674.32730044, 1919075.585936403 4218674.145833503, 1919074.6163645245 4218673.882364341, 1919073.8264996752 4218673.644915909, 1919073.3299060035 4218673.501136722, 1919073.0700946483 4218673.423266213, 1919072.660633719 4218673.302940529, 1919072.2392732203 4218673.179045863, 1919071.9872766347 4218673.104917169, 1919071.7355428692 4218673.030771084, 1919071.565511884 4218672.98077987, 1919071.3135593298 4218672.906438567, 1919071.2130635567 4218672.87716743, 1919070.9875395892 4218672.810840177, 1919070.7971955212 4218672.754442922, 1919070.608688158 4218672.698169386, 1919070.2270924507 4218672.587146495, 1919069.7098142782 4218672.434374639, 1919068.7907089759 4218672.163591249, 1919067.688814246 4218671.841290554, 1919065.705847839 4218671.257860596, 1919064.521156285 4218670.887810373, 1919063.8098080542 4218670.664824907, 1919063.7752798302 4218670.659847719, 1919063.2587690663 4218670.57729872, 1919054.4174072202 4218670.608081923, 1919045.9350045405 4218670.287960561, 1919045.7363683167 4218670.530364088, 1919045.7176404092 4218670.5301766, 1919045.5894240846 4218670.709685863, 1919044.9216097812 4218671.634000319, 1919044.6449903052 4218671.862215221, 1919044.3088144634 4218672.144349815, 1919036.7827862184 4218674.540154371, 1919036.062428398 4218674.752556977, 1919034.374965643 4218675.256450444, 1919033.8002338198 4218675.373816384, 1919033.443332726 4218675.444298705, 1919032.7664549144 4218675.502796355, 1919030.6105321497 4218675.705732676, 1919030.0600631044 4218675.632648488, 1919029.4909876944 4218675.5755319055, 1919027.0031383075 4218674.813568159, 1919026.4203459052 4218674.635571403, 1919026.1909018678 4218674.6258692, 1919023.0445195534 4218675.2068416, 1919021.0250588078 4218675.582374334, 1919020.1638937332 4218675.746444583, 1919019.167192032 4218675.886818413, 1919016.620059177 4218675.925838824, 1919009.8746678017 4218675.825717288, 1919008.4631863672 4218675.717060939, 1919007.5576622654 4218675.658981171, 1919006.8826097168 4218675.521484535, 1919005.8718221649 4218675.344732139, 1919005.4806286395 4218675.140774157, 1919002.8471243922 4218673.401227965, 1919002.0704819271 4218672.188313252, 1919001.8841916341 4218671.764812528, 1919001.7833304245 4218667.991482863, 1919001.6151952462 4218666.291171478, 1919001.5123305847 4218665.131600034, 1919000.5715173827 4218662.6622108305, 1918999.8217280668 4218660.647439513, 1918999.5592263096 4218660.259119848, 1918999.189079941 4218659.704547637, 1918998.6486142236 4218659.291995313, 1918994.2158410805 4218657.034433069, 1918992.1994007418 4218655.10439049, 1918990.8257224094 4218653.6843432, 1918989.317165684 4218652.153981965, 1918986.3707369997 4218649.392986743, 1918985.5554644181 4218648.628907635, 1918984.8367438887 4218647.949337656, 1918984.5103447603 4218647.520966576, 1918984.5012479136 4218647.508930524, 1918984.4269337102 4218647.381070859, 1918982.8027344577 4218644.587139138, 1918980.69299838 4218640.953042996, 1918980.8878631075 4218639.04817639, 1918980.9830232826 4218637.566596521, 1918980.9148806531 4218637.156036432, 1918980.8822569363 4218636.930704045, 1918980.4817452847 4218635.732877363, 1918979.825585243 4218633.774091827, 1918979.4595132202 4218632.822743155, 1918978.7717699546 4218631.691323747, 1918978.0494116528 4218630.4901521, 1918977.6711223298 4218630.13847634, 1918977.4641610617 4218629.946168802, 1918976.8901179116 4218629.392645253, 1918976.4048410938 4218629.209456498, 1918973.6150621865 4218628.550258745, 1918970.5285693635 4218627.806870419, 1918968.5915586546 4218627.443790606, 1918966.193988384 4218627.500032268, 1918964.6711610088 4218627.5169417355, 1918961.6963463663 4218627.087748417, 1918960.7434746479 4218626.954566732, 1918959.7000357108 4218626.0548627535, 1918958.9555805887 4218625.205422052, 1918957.9031661295 4218624.048183893, 1918957.2860415217 4218622.872172782, 1918957.1874749123 4218622.691565918, 1918954.8819151095 4218616.91439407, 1918954.2419616296 4218614.778992676, 1918955.3521104476 4218611.634360432, 1918956.609715137 4218608.203593444, 1918957.4798360341 4218605.913732279, 1918959.7078662273 4218599.983888217, 1918963.84966716 4218588.934221472, 1918977.6193190108 4218552.202365363, 1918982.2578508025 4218539.904606725, 1918987.9395721206 4218524.821637276, 1919013.6617706625 4218456.538258471, 1919052.64 4218353.05, 1919173.4231270896 4218298.35043469, 1919195.8926389539 4218288.173295367, 1919213.1707579647 4218280.347455073, 1919215.6793980151 4218279.211216391, 1919218.3989643042 4218277.979774003, 1919224.6401206623 4218275.153729479, 1919233.5903553013 4218271.100992181, 1919317.2267418983 4218233.229738433, 1919317.2539501812 4218233.217395831, 1919317.3110227466 4218233.191592047, 1919317.3694357541 4218233.165113245, 1919317.412233119 4218233.145745255, 1919347.02 4218219.74, 1919391.2288703322 4218201.110294719, 1919402.3902335588 4218196.406874228, 1919405.394193639 4218195.140999503, 1919409.4512781773 4218193.431157853, 1919414.367687744 4218191.357421356, 1919435.7812135364 4218182.330876219, 1919480.8816450413 4218163.325204765, 1919494.8238306623 4218157.445021469, 1919516.9225667631 4218148.134699955, 1919539.01 4218138.83, 1919548.7456190002 4218133.703531242, 1919549.1396185919 4218133.459690108, 1919550.2055445237 4218132.804898833, 1919550.4516820044 4218132.684486703, 1919551.3439999977 4218132.312000001, 1919551.8979688224 4218132.056322082, 1919552.0159710073 4218131.9954934325, 1919662.9918320088 4218070.180686038, 1919800.5310175167 4217993.573907423, 1919914.1405258414 4217930.295192308, 1920146.4089483174 4217982.824657452, 1920245.2835651878 4217916.991858502, 1920310.8166908424 4217873.352843887, 1920347.3637538983 4217849.020530615, 1920368.2704466258 4217835.10132862, 1920389.09 4217821.24, 1920391.3358872668 4217820.125770228, 1920445.1019996996 4217793.451615084, 1920446.399052842 4217792.681879357, 1920446.4167577652 4217792.562822782, 1920446.4695024039 4217792.527285614, 1920446.7277222802 4217790.471745075, 1920447.1486031658 4217787.1959227845, 1920448.0216883395 4217782.38513076, 1920448.6424449666 4217778.932302969, 1920448.9454352474 4217777.549420145, 1920449.140631746 4217776.669676773, 1920449.4034667506 4217775.783222908, 1920449.9821156266 4217773.87724817, 1920450.48391433 4217772.499698437, 1920450.8256569302 4217771.609002625, 1920451.5076141758 4217769.920727107, 1920451.5500108066 4217769.836328073, 1920451.8971951522 4217769.129893966, 1920452.8404802473 4217767.677273433, 1920453.8651855595 4217766.117725322, 1920454.62 4217764.7, 1920445.883279184 4217751.251598358, 1920427.519500761 4217729.301836106, 1920405.4380544245 4217701.245852046, 1920389.2280782263 4217680.594049655, 1920388.741677796 4217679.884206924, 1920382.3968861785 4217670.025760146, 1920378.5768819852 4217661.611162722, 1920378.462638916 4217661.3141771825, 1920372.253491191 4217644.37949997, 1920366.6837111427 4217631.076057486, 1920360.2472731855 4217617.435383574, 1920346.7434767073 4217593.751776224, 1920330.993908937 4217564.816274963, 1920326.9577971823 4217558.5525999805, 1920320.2001868223 4217548.7734005535, 1920304.3951744463 4217526.717577335, 1920289.2721265336 4217507.257296122, 1920280.6983331698 4217495.7586870985, 1920280.0795165736 4217494.9468592955, 1920276.0775648837 4217490.089061064, 1920249.7364191778 4217459.775355793, 1920226.59037305 4217433.329512955, 1920220.0773586053 4217426.978281854, 1920205.50844579 4217414.258341259, 1920194.7378074818 4217403.6764883455, 1920173.8120573396 4217377.699180985, 1920164.4154343042 4217365.661635953, 1920163.5647981137 4217364.584637835, 1920162.4384168407 4217363.066115262, 1920161.0174658222 4217360.937210983, 1920159.962169325 4217359.28373796, 1920159.4718252728 4217358.50924112, 1920159.33912567 4217358.29806234, 1920151.6027013483 4217346.076386774, 1920138.5724478255 4217327.02651884, 1920130.7258333329 4217316.102916671, 1920128.894668056 4217313.564474377, 1920128.0526801478 4217312.344203362, 1920111.090799595 4217285.038259109, 1920081.8443042946 4217243.670161952, 1920067.786956273 4217221.206937745, 1920055.8878752573 4217200.259699246, 1920042.3275736745 4217178.615985502, 1920030.4010603405 4217162.258992677, 1919999.1024999788 4217114.417083326, 1919976.7445763631 4217087.203856621, 1919959.1719273878 4217062.265485358, 1919930.32713065 4217019.633581093, 1919924.961554225 4217012.858156874, 1919921.2615994166 4217008.400320383, 1919918.9607816006 4217005.655219489, 1919913.5547914824 4216998.404029469, 1919905.9528804338 4216988.359686603, 1919901.0820416557 4216981.51081819, 1919893.6849741056 4216970.28426569, 1919876.3935073316 4216943.550613802, 1919871.9324856265 4216938.760729055, 1919853.0717845657 4216920.541559117, 1919835.9675750665 4216905.001416155, 1919992.5250205256 4216771.247079406, 1919996.7923739026 4216767.599556652, 1920032.615452932 4216737.2863519015, 1920035.3177302834 4216735.484365172, 1919915.594111842 4216632.222699898, 1919883.0065725348 4216604.078696118, 1919882.9569032332 4216601.045557447, 1919881.7394565812 4216600.007864414, 1919879.4790392884 4216545.052119604, 1919877.3764667748 4216496.459455165, 1919840.3965857965 4216404.853387889, 1919774.1726685811 4216244.163698479, 1919708.9516618766 4216086.729616728, 1919663.8310482134 4215922.962990724, 1919635.1288415587 4215818.884455523, 1919600.7141183103 4215698.1012142105, 1919583.315843158 4215635.484261262, 1919580.3029440786 4215633.084826671, 1919579.412506893 4215627.495326417, 1919580.169174559 4215578.358255655, 1919573.7784052833 4215546.19054415, 1919567.532247571 4215524.810603053, 1919537.5749404847 4215456.278314887, 1919505.2274507023 4215383.8466003435, 1919483.1119475875 4215333.771448075, 1919477.8185506386 4215321.799474852, 1919439.7308546444 4215234.245503205, 1919423.118241397 4215197.081118421, 1919420.0629354217 4215190.801567423, 1919415.0619261817 4215180.460223653, 1919406.8272812762 4215165.676763749, 1919395.4536246809 4215146.32767664, 1919353.9976074116 4215074.947979894, 1919328.6930131866 4215030.4077910995, 1919318.4677785472 4215010.637957221, 1919292.5869943227 4214959.231554097, 1919276.2081808904 4214929.879750906, 1919270.5468461828 4214923.872209606, 1919263.9636265514 4214922.2395225195, 1919156.329997349 4214865.455466586, 1918910.014096881 4214735.220095522, 1918574.4600675018 4214557.818654609, 1918550.10548911 4214545.683195176, 1918280.626174089 4214515.345799595, 1918139.496304871 4214498.597691909, 1918136.21101109 4214502.4112663, 1918134.0210113628 4214504.920102384, 1918104.9196730491 4214532.726788909, 1917984.9459593242 4214646.70013836, 1917963.6608262893 4214666.8994836975, 1917949.4682217652 4214680.368052403, 1917941.2991352146 4214688.163939948, 1917901.7695521694 4214725.96398535, 1917793.5704284755 4214829.795130713, 1917778.4780151425 4214844.253922194, 1917776.3464307257 4214844.200014648, 1917774.570376964 4214845.881533756, 1917772.81 4214847.55, 1917945.394746514 4215112.031015131, 1918241.0682821132 4215567.548747496, 1918367.4279412061 4215760.80640812, 1918432.5773924736 4215861.686978903, 1918433.0507254265 4215865.092815477, 1918435.4496220916 4215868.785413373, 1918433.3051557662 4215874.386364644, 1918423.3457270407 4215885.919153747, 1918414.0009669554 4215892.472941756, 1918411.2541568403 4215895.83865339, 1918339.7917013504 4215926.350192168, 1918331.7389796996 4215930.478347219, 1918325.5785964676 4215935.669196135, 1918310.7491392721 4215950.456873392, 1918308.5005921747 4215949.147626015, 1918306.7827357142 4215950.999179031, 1918294.7502863593 4215944.593049969, 1918289.4750261046 4215942.935707446, 1918283.7843606346 4215941.708955642, 1918279.933556207 4215941.983258745, 1918275.9614926788 4215942.311410908, 1918266.6447558496 4215943.924617879, 1918259.4615230195 4215947.180688914, 1918221.167725385 4215967.735738203, 1918208.4172142788 4215973.747784683, 1918199.99 4215977.03, 1918218.47 4215997.5, 1918202.9475134863 4216007.783539643, 1918190.9896994638 4216015.704640648, 1918187.3355972723 4216008.541671236, 1918187.3316250485 4216008.543179057, 1918187.330832107 4216008.541627837, 1918134.52 4216028.59, 1918136.5958658066 4216031.238260658, 1918136.9793079654 4216031.727161233, 1918137.7849459252 4216032.750528049, 1918138.004098245 4216033.028957586, 1918138.346438814 4216033.464643274, 1918138.8529767685 4216034.109737446, 1918140.932741131 4216036.76021422, 1918142.8791820966 4216039.241484902, 1918146.2828874008 4216043.580718306, 1918149.2343498734 4216047.342971794, 1918150.0757780666 4216048.416306399, 1918150.2812383901 4216048.678487855, 1918150.5316198443 4216049.002255422, 1918150.823446142 4216049.379495747, 1918165.67634804 4216068.579606275, 1918191.1698126406 4216101.534852606, 1918191.1696322574 4216101.539524531, 1918191.16982564 4216101.539774393, 1918190.67 4216114.48, 1918181.850668813 4216120.796147514, 1918178.3549836 4216123.299433632, 1918177.5826587481 4216123.853705398, 1918175.845982145 4216125.101425722, 1918175.473612281 4216125.368980535, 1918175.1446767414 4216125.604988869, 1918174.5139538578 4216126.057403935, 1918173.9030605347 4216126.495593311, 1918159.9 4216136.54, 1918159.2860435331 4216137.437717859, 1918163.0891366918 4216139.770550299, 1918167.873842945 4216146.064701447, 1918170.1265654752 4216152.132605066, 1918171.634988756 4216158.393528541, 1918174.7953774042 4216168.385974341, 1918178.324346514 4216173.727927934, 1918178.4524926208 4216173.90082244, 1918178.4595015543 4216173.910146026, 1918178.96 4216174.65, 1918179.530313361 4216175.387474174, 1918180.05 4216176, 1918180.7353484025 4216176.715257752, 1918181.32 4216177.29, 1918182.0099817165 4216177.902237298, 1918182.92 4216178.64, 1918184.3755717354 4216179.669852649, 1918185.331508477 4216180.314279395, 1918186.25 4216180.91, 1918187.1016452154 4216181.41923116, 1918187.2200000642 4216181.49000004, 1918187.2278396536 4216181.49452073, 1918187.5030997451 4216181.653074253, 1918187.579389575 4216181.700174758, 1918188.3105231228 4216182.131424223, 1918189.8687973574 4216182.990819864, 1918191.6090971364 4216184.02777683, 1918202.5550305021 4216189.266552854, 1918211.2017921628 4216194.216205713, 1918226.5631276683 4216204.215945566, 1918225.65 4216205.43, 1918223.86 4216206.83, 1918203.3 4216212.1, 1918195.0078252417 4216213.39520017, 1918192.3226244706 4216213.814616251, 1918191.4098556368 4216213.953578932, 1918190.1853909094 4216214.1345650535, 1918180.92 4216215.5, 1918175.5 4216216.96, 1918170.17 4216217.73, 1918162.6 4216219.77, 1918158.98 4216221.23, 1918147.26 4216228.45, 1918129.39 4216232.3, 1918100.1302723733 4216256.275097564, 1918100.1305119041 4216256.27958047, 1918100.1302332755 4216256.279809887, 1918103.4437983704 4216318.291100746, 1918109.5795128534 4216432.787726638, 1918110.8943501804 4216457.255613594, 1918111.3732397258 4216466.167843704, 1918111.66849297 4216471.6615792, 1918111.862517432 4216475.2694729185, 1918111.8651620825 4216475.315560643, 1918111.8757531487 4216475.499534666, 1918111.904770426 4216476.007587422, 1918112.06 4216478.27, 1918112.209930403 4216478.259081131, 1918112.21 4216478.26, 1918112.2357262564 4216478.460664799, 1918129.2772957245 4216477.045827333, 1918149.7007671078 4216474.877467928, 1918167.6130517554 4216473.17600395, 1918188.2978036797 4216472.5502101015, 1918193.8554532516 4216472.474939272, 1918210.5446584662 4216472.640063336, 1918215.4 4216472.8, 1918215.2 4216475.88, 1918215.95 4216476.14, 1918208.3 4216487.92, 1918198.629913079 4216501.909012448, 1918194.102387165 4216508.458655371, 1918193.253898339 4216509.686102534, 1918193.0444762015 4216509.989058331, 1918193.03 4216510.01, 1918192.9324112118 4216510.148287539, 1918192.7598156158 4216510.392862961, 1918192.4318654442 4216510.857582538, 1918191.7401060045 4216511.837835596, 1918190.086126348 4216514.181596298, 1918177.54 4216531.96, 1918173.9050193469 4216536.915703591, 1918168.0229400208 4216544.934959928, 1918158.5761210765 4216557.8421134725, 1918144.03 4216578.21, 1918123.537261824 4216606.246802901, 1918119.16 4216612.24, 1918118.2724053084 4216613.356889986, 1918108.36 4216625.83, 1918102.1492750142 4216634.054083675, 1918100.11 4216636.98, 1918095.4756536242 4216642.166523816, 1918090.3 4216647.76, 1918072.64 4216664.53, 1918063.59 4216674, 1918056.67 4216682, 1918056.091040412 4216682.736327798, 1918050.71 4216689.58, 1918046.54 4216695.94, 1918042.39 4216703.24, 1918039.05 4216710.53, 1918035.7 4216719.07, 1918033.7 4216727.01, 1918032.98 4216731.53, 1918032.68 4216734.74, 1918032.82 4216739.46, 1918033.71 4216743.88, 1918035.15 4216748.86, 1918036.9 4216753.78, 1918037.0288849915 4216754.210530717, 1918037.37 4216755.35, 1918037.93 4216757.44, 1918037.9885468462 4216757.691593205, 1918038.3 4216759.03, 1918038.5627523754 4216760.308728227, 1918039.4017625612 4216764.0834418405, 1918039.528334916 4216764.671622994, 1918039.5687107616 4216764.861124562, 1918039.6196996642 4216765.1004725415, 1918040.28 4216768.2, 1918040.4286253124 4216768.744959478, 1918040.4895959985 4216768.968527028, 1918040.5116971491 4216769.049557994, 1918040.52 4216769.08, 1918040.5257327645 4216769.102774719, 1918040.7173683285 4216769.863228285, 1918041.3585321922 4216772.407924637, 1918045.95 4216789.93, 1918047 4216793.31, 1918048.2674357677 4216796.743426773, 1918050.125622688 4216801.628338293, 1918051.204950744 4216804.4793922445, 1918052.64 4216808.68, 1918076.8629895898 4216855.491137202, 1918076.3482283514 4216856.026638861, 1917974.54 4216960.61, 1917970.57 4216957.69, 1917931.81 4217012.17, 1917878.55 4217038.63, 1917828.46 4217094.97, 1917799.96 4217152.32, 1917784.5205459562 4217180.365203412, 1917777.7602129017 4217192.42614792, 1917771.7944817608 4217203.037462414, 1917769.28 4217207.51, 1917760.644674835 4217220.968117004, 1917758.8477539872 4217223.667764741, 1917752.594169675 4217233.063393855, 1917751.2562383313 4217235.072060451, 1917751.1983241232 4217235.159007132, 1917749.67212398 4217237.449940717, 1917712.259704264 4217293.612686196, 1917711.7052561773 4217294.44373747, 1917705.1047507676 4217304.352080658, 1917700.3902567637 4217311.248185989, 1917696.3999935975 4217317.070283921, 1917695.2151572984 4217318.796985443, 1917694.0758358592 4217320.459506329, 1917691.1173435438 4217324.7746275775, 1917683.734725739 4217335.543092286, 1917682.9242497268 4217336.722923667, 1917681.8198624747 4217338.316173209, 1917679.657408433 4217341.435788118, 1917676.5517253815 4217345.917647373, 1917672.7899467014 4217351.343208736, 1917671.3817600906 4217353.370103532, 1917669.0962167955 4217356.673877424, 1917666.1961499916 4217360.857637764, 1917663.612930018 4217364.5655996865, 1917661.1520115903 4217368.087849467, 1917636.8795506503 4217402.994056476, 1917631.1058325588 4217410.890365358, 1917612.7574550528 4217428.478283077, 1917593.7557288243 4217446.5808887575, 1917585.5782443015 4217454.366294195, 1917584.530060305 4217455.366800801, 1917582.5029422394 4217457.301754088, 1917582.489607293 4217457.318597476, 1917581.2938948413 4217458.665093254, 1917579.49 4217460.17, 1917436.8 4217471.36, 1917435.12 4217465.57, 1917376.8176615513 4217486.294928888, 1917359.9164420883 4217492.30287311, 1917347.7039942772 4217496.646797073, 1917344.3319097671 4217497.846746796, 1917316.6 4217507.7, 1917303.248170028 4217510.727620663, 1917286.4256969392 4217514.548264065, 1917286.3844506626 4217514.557633774, 1917286.329953152 4217514.570010558, 1917286.0449456326 4217514.634176992, 1917285.9520314063 4217514.655217747, 1917285.5344026748 4217514.749315673, 1917285.339996852 4217514.793040865, 1917285.1760200781 4217514.829984274, 1917284.6476013716 4217514.948868653, 1917284.141613038 4217515.063127854, 1917283.5090808023 4217515.205682721, 1917279.7598717394 4217516.9900582, 1917279.7594493092 4217516.990249901, 1917279.7516491015 4217516.993789481, 1917278.7431528678 4217517.45142643, 1917278.6759119583 4217517.481939107, 1917277.990691 4217517.792879726, 1917277.4781752892 4217518.025449874, 1917277.4453304722 4217518.040354228, 1917277.3789146957 4217518.070495784, 1917277.2508875397 4217518.128980914, 1917277.0101177641 4217518.238968933, 1917276.4167925825 4217518.510010662, 1917272.7478453908 4217520.1860524565, 1917270.0854048734 4217521.402303679, 1917269.12341543 4217521.841757945, 1917268.7129062638 4217522.029286001, 1917268.6248256497 4217522.069522833, 1917268.5373820532 4217522.109449335, 1917268.4197117826 4217522.1631529, 1917267.2278551823 4217522.707109577, 1917263.7264881919 4217524.305069271, 1917207.5472747977 4217549.944111843, 1917206.53 4217550.16, 1917196.099038296 4217552.380614478, 1917188.683565059 4217553.96022664, 1917188.6293002982 4217553.970925336, 1917120.71 4217567.13, 1917109.82 4217565.99, 1917105.679969606 4217565.660536962, 1917105.54 4217565.65, 1917102.5209414777 4217565.334765747, 1917113.93 4217588.32, 1917123.67319845 4217611.181791509, 1917144.2252180546 4217682.30700361, 1917157.465875571 4217712.39295681, 1917184.615030779 4217767.427635043, 1917196.2692884377 4217794.041521928, 1917214.0015710748 4217822.55290217, 1917245.0055638365 4217870.0314974515, 1917261.6631162008 4217894.104187253, 1917287.1612867685 4217927.13267927, 1917307.3078997976 4217948.130323433, 1917340.0733245867 4217979.69421805, 1917340.076449537 4217981.164507136, 1917340.081106002 4217983.355373887, 1917340.0856405196 4217985.488864414))'::geometry,'38059','Brié-et-Angonnes','BRIÉ-ET-<br>ANGONNES','BEA','BEA'),
     (1,'SRID=3945;POLYGON ((1914113.3723903352 4217833.470223486, 1914117.6255352253 4217830.027840399, 1914127.7768996707 4217823.122544113, 1914171.4277393264 4217803.561495561, 1914178.3872254149 4217799.374275112, 1914200.7012560805 4217783.449734211, 1914203.355589755 4217781.263052728, 1914209.8351192393 4217774.358279287, 1914220.4570317592 4217761.191815196, 1914231.3148001223 4217745.389330162, 1914240.1470695345 4217731.44439152, 1914242.2478305555 4217727.6004185425, 1914249.7594313761 4217711.686977276, 1914252.2864242517 4217706.326681179, 1914257.4856830263 4217695.375102011, 1914259.922739744 4217689.455286297, 1914260.7857849437 4217687.407782259, 1914265.3590502376 4217677.532897223, 1914267.0859169704 4217674.481261696, 1914279.963218668 4217652.413325579, 1914298.584384922 4217618.397081163, 1914309.837131111 4217598.978881024, 1914310.0062742033 4217598.699081049, 1914312.1587858438 4217595.531915382, 1914319.2249422057 4217585.142448655, 1914323.210705919 4217579.438625721, 1914323.3077207045 4217579.3006659215, 1914323.5643315585 4217578.935281773, 1914323.6321055659 4217578.850524528, 1914345.0943483694 4217551.946450792, 1914392.8415822852 4217485.6047509145, 1914398.9671880219 4217474.415025593, 1914402.746962313 4217467.937445837, 1914419.95999465 4217440.391626133, 1914428.0465537466 4217427.879803536, 1914434.9776958765 4217417.017571654, 1914441.0942890977 4217398.1979865385, 1914446.675572667 4217377.429790058, 1914450.6020147146 4217358.400480272, 1914454.0369869908 4217340.261304134, 1914455.4108663748 4217331.057130827, 1914458.9768665016 4217305.562041661, 1914461.08606348 4217285.469457798, 1914462.1901064785 4217270.90443613, 1914461.7766024708 4217258.807812892, 1914460.3503459473 4217237.746574158, 1914460.3372716738 4217237.545584199, 1914459.641048318 4217226.608443933, 1914459.3577863544 4217221.157233137, 1914459.1403629307 4217208.717210394, 1914459.7437177044 4217199.414967997, 1914461.1991282147 4217182.069429121, 1914464.0477154665 4217161.432655831, 1914470.5348966746 4217136.075139955, 1914483.8096075319 4217091.65427859, 1914492.224432697 4217056.6032201145, 1914508.013967544 4217014.328521627, 1914515.257339397 4216995.135828814, 1914521.7864664572 4216978.182004751, 1914531.538227978 4216943.5708679, 1914536.2951978957 4216919.000662772, 1914538.357034636 4216908.6105591, 1914544.887095413 4216888.8979530325, 1914552.8788461538 4216869.7035020245, 1914556.484573063 4216863.636400029, 1914561.305287683 4216856.383324391, 1914564.001923077 4216852.3777429145, 1914571.6803171276 4216841.7049424965, 1914573.4226488643 4216839.566943884, 1914601.2700891523 4216809.924668422, 1914619.2900863413 4216789.4540489195, 1914628.3515005587 4216779.259218157, 1914651.264067756 4216755.178873924, 1914651.4800851536 4216755.199882544, 1914652.5385474893 4216754.069499499, 1914662.49973596 4216755.929059568, 1914677.0821292873 4216757.513429636, 1914682.5941695021 4216758.22586098, 1914689.638808488 4216759.145294782, 1914715.3355201653 4216761.583991286, 1914742.8283879517 4216763.371998062, 1914770.7276270678 4216761.691656198, 1914810.64669354 4216756.774263376, 1914812.4011758333 4216756.675906294, 1914818.587848775 4216757.093803155, 1914827.4494843523 4216757.724460733, 1914838.7504978946 4216758.835051033, 1914844.8173088504 4216759.609218162, 1914856.9537612954 4216761.876371762, 1914869.4417962488 4216764.885475517, 1914881.3384803936 4216768.493159537, 1914889.305617409 4216771.508793016, 1914892.5506513822 4216772.966960372, 1914904.5643237778 4216779.630514337, 1914911.6716418876 4216784.49984743, 1914927.0302093779 4216799.329058152, 1914938.856894339 4216811.703104505, 1914946.3694966065 4216821.199294652, 1914965.001462238 4216849.992500681, 1914991.495349809 4216889.261904292, 1914995.368641224 4216894.441986738, 1914996.7775614152 4216896.021479541, 1914997.3033475645 4216896.532066608, 1915004.1250782097 4216903.135221085, 1915010.725068708 4216907.469830321, 1915020.9972849817 4216911.739978095, 1915030.355035256 4216913.212834512, 1915045.1943795958 4216911.238467753, 1915059.4519205645 4216902.040061879, 1915070.0880104208 4216891.501603538, 1915094.474959514 4216854.898218623, 1915105.3196743724 4216847.829133706, 1915113.536048597 4216848.178068041, 1915118.2914781715 4216849.518686006, 1915120.5796351787 4216850.596988531, 1915121.9455662526 4216851.23813741, 1915125.834061877 4216853.381935774, 1915132.4218034307 4216857.219445625, 1915136.4945405433 4216860.59575471, 1915139.5015092534 4216863.084462949, 1915140.8271378602 4216864.115345188, 1915144.010472476 4216866.555839362, 1915152.169840351 4216872.808606744, 1915155.061969287 4216874.911489893, 1915157.642632609 4216876.456870623, 1915165.7367111112 4216881.298085077, 1915170.6167878178 4216883.723284879, 1915178.5536682403 4216886.181945338, 1915190.3135131719 4216887.216401416, 1915201.8008517541 4216886.254235936, 1915212.552810995 4216884.962380536, 1915219.1544579242 4216883.244778209, 1915233.2195968996 4216876.887967469, 1915239.1063483767 4216875.038300066, 1915250.4702563153 4216874.351003698, 1915267.9695125706 4216875.826006705, 1915308.6465271024 4216887.93980609, 1915356.2397031295 4216896.846247272, 1915369.9656797396 4216898.769026229, 1915404.8177390718 4216908.238144668, 1915408.4395801441 4216909.021143933, 1915498.352461747 4216329.968039832, 1915498.8467548466 4216326.782848477, 1915498.939588843 4216326.182402853, 1915499.0390175416 4216325.666060616, 1915499.2253093005 4216324.731258225, 1915499.2476346649 4216324.185400231, 1915499.2541790274 4216320.250162235, 1915500.2658191782 4216312.386753887, 1915506.0605822136 4216229.668883798, 1915505.8883250807 4216220.494580935, 1915505.8227911983 4216215.9182228735, 1915504.762333693 4216201.457526465, 1915504.5923728258 4216195.999159816, 1915503.0755305062 4216162.087662346, 1915502.3405875228 4216157.36962447, 1915498.2004467212 4216138.6044791015, 1915496.047208314 4216130.055382667, 1915494.8627174522 4216124.677174021, 1915493.962627031 4216120.621510663, 1915493.054905998 4216117.353693409, 1915482.7950711593 4216086.062870452, 1915478.0782015976 4216070.159662787, 1915476.2627732127 4216066.60815404, 1915458.7152215505 4216035.357963662, 1915447.4174548048 4216015.120899345, 1915444.706471161 4216010.965544219, 1915438.419584879 4216001.176906522, 1915434.9508758436 4215994.485511994, 1915428.8381045612 4215982.148418502, 1915427.039027712 4215978.645104755, 1915427.0365054542 4215978.640276881, 1915421.28072431 4215967.474787126, 1915416.7449184726 4215959.815322869, 1915409.016577488 4215946.668954913, 1915371.947187283 4215888.228963685, 1915364.5829795413 4215873.49912392, 1915337.4547451108 4215816.9463713225, 1915329.9321099792 4215801.201928707, 1915323.6261583779 4215788.17997873, 1915314.5135775118 4215772.805758091, 1915313.0428466229 4215770.277361208, 1915311.5825039896 4215767.945470988, 1915309.4568898452 4215764.5527012255, 1915302.5196046482 4215753.131302194, 1915301.1501293487 4215749.674700869, 1915269.0595727942 4215658.088891775, 1915247.947206247 4215593.792756569, 1915214.6868563339 4215493.038440873, 1915199.9494129901 4215453.90706911, 1915186.8761858125 4215426.142646142, 1915176.9133193898 4215399.446225396, 1915171.2284602758 4215352.791099312, 1915153.9384431457 4215293.492213222, 1915136.8097180089 4215249.676171172, 1915110.2701454875 4215176.147193306, 1915087.81113251 4215117.544202006, 1915075.7737438362 4215087.254869474, 1915055.5465148187 4215051.401539965, 1915055.2275184845 4215050.817010389, 1915058.7131504614 4215040.104863536, 1915072.454179396 4214997.779778704, 1915071.2773378799 4214994.349604983, 1915071.4339102157 4214993.773746497, 1915057.4086059602 4214952.6365587115, 1915055.4147786812 4214948.657836991, 1915039.7303460825 4214913.317429841, 1915039.037183097 4214912.286613213, 1915037.7334830284 4214911.185613009, 1915030.3933279917 4214904.869359242, 1915029.3869796915 4214902.900182288, 1915000.282704972 4214833.471119559, 1914998.7251974756 4214827.029276145, 1914997.3803151126 4214821.465121543, 1914997.1838088536 4214820.327997165, 1914992.5432943592 4214794.365888483, 1914986.661136379 4214762.325723549, 1914978.696680526 4214735.900341707, 1914961.691113446 4214704.502224249, 1914959.9846977869 4214701.299161436, 1914955.6114922084 4214690.868335046, 1914949.6199561986 4214676.447328757, 1914940.4831839644 4214656.212553982, 1914934.2387878147 4214646.369979024, 1914930.1562889603 4214636.704674971, 1914915.9845445661 4214612.376891418, 1914910.2214500634 4214603.088401701, 1914890.7455675306 4214570.687820462, 1914867.7619081377 4214550.345438379, 1914862.9090650035 4214542.3879037425, 1914862.0642893265 4214538.297056165, 1914861.5191355185 4214534.038156157, 1914855.2234020054 4214513.327108494, 1914849.1963097851 4214496.646205312, 1914845.681611837 4214489.389282502, 1914829.7989779015 4214459.3900597, 1914815.2885785974 4214437.079116495, 1914818.491864268 4214430.219368909, 1914823.533251114 4214422.242651409, 1914821.8396054085 4214420.545049743, 1914821.9795143714 4214420.229325977, 1914820.2985824095 4214419.000427273, 1914819.3577650557 4214418.458118885, 1914806.4070861114 4214407.800379529, 1914762.7729563045 4214362.258851817, 1914760.3736208596 4214357.026318302, 1914758.8251159124 4214349.720946141, 1914758.7109726593 4214347.364752842, 1914758.6187551215 4214345.752335475, 1914759.930990985 4214339.010405796, 1914760.7300669395 4214334.68167816, 1914760.786500155 4214331.492265317, 1914759.7972338588 4214328.337243288, 1914757.3433454977 4214323.334471338, 1914756.6374921137 4214321.934779723, 1914756.3874120237 4214321.551751968, 1914753.3831236595 4214317.235361153, 1914750.9032774076 4214315.421310963, 1914748.7049466341 4214313.961657868, 1914743.0626130684 4214307.435238856, 1914733.9993431189 4214296.525244553, 1914726.2710751598 4214287.182697127, 1914720.865130418 4214281.843162191, 1914717.8397368803 4214278.837682376, 1914714.5854455247 4214274.823415145, 1914710.6349854236 4214269.943596834, 1914700.6862604779 4214256.142128773, 1914700.4236790377 4214255.249651955, 1914699.4808836635 4214247.446668362, 1914697.5309109169 4214243.000583036, 1914674.4674898973 4214207.014757275, 1914649.586066922 4214161.37953655, 1914646.030919747 4214157.951993196, 1914611.3869898499 4214128.932470076, 1914525.2602869696 4214058.77783044, 1914518.8508303242 4214049.777304852, 1914500.5350507516 4214003.616509623, 1914494.8408771423 4213905.420724888, 1914474.649237433 4213694.758204888, 1914453.498001788 4213698.470782074, 1914442.6210472304 4213701.905548694, 1914438.2728258253 4213703.331872656, 1914434.5313135674 4213705.130201539, 1914429.69 4213707.06, 1914385.398347657 4213729.963560622, 1914344.181383502 4213759.936665945, 1914328.4841156614 4213788.994514779, 1914293.2980030777 4213810.13609035, 1914215.045 4213841.105, 1914076.1194880547 4213931.050017064, 1913878.0340188146 4214079.231849309, 1913616.785 4214302.47, 1913239.8512649618 4214621.173938044, 1912672.7610356521 4215083.814572111, 1912729.759215751 4215189.903703984, 1912864.9988006072 4215427.642869433, 1912916.568804848 4215517.808658268, 1912939.138329234 4215557.776441635, 1912944.2797985247 4215566.795161981, 1912957.9993858053 4215590.850714917, 1912962.1354226551 4215598.25553551, 1912986.4434615385 4215641.791396761, 1913087.215182186 4215817.538643724, 1913094.732959964 4215827.018568671, 1913098.1613360324 4215830.791052632, 1913098.4265560089 4215833.254014715, 1913093.2325778892 4215845.667450956, 1913092.038696625 4215849.339322769, 1913109.6954335028 4215851.90098991, 1913121.8597872183 4215856.402387152, 1913126.3439304144 4215858.1671185335, 1913125.905987323 4215859.011451525, 1913126.4 4215859.33, 1913127.3302223324 4215859.734967481, 1913110.7591826369 4215889.50921209, 1913102.882503015 4215906.732725258, 1913083.177441423 4215970.076407061, 1913076.0199284635 4215993.995865944, 1913061.8456663145 4216037.758363608, 1913042.2444759007 4216108.536787224, 1913034.8382406698 4216139.123832341, 1913036.5167076169 4216140.318673219, 1913037.0477253296 4216146.422973271, 1913043.2100498115 4216138.561822477, 1913048.5770555674 4216132.6627044715, 1913053.6433353005 4216115.940576071, 1913055.2818808914 4216110.58275136, 1913056.5135648656 4216108.226194379, 1913066.1665377705 4216092.621334803, 1913070.0164024378 4216083.630901716, 1913076.0553424119 4216064.298871209, 1913080.245569299 4216056.153323338, 1913081.2183922443 4216054.666194206, 1913081.736729087 4216053.8970714, 1913083.6931682199 4216052.357622124, 1913084.3852722358 4216051.81416646, 1913106.2380819118 4216031.987062015, 1913109.929171348 4216028.58662438, 1913114.3096875106 4216022.610882207, 1913117.229110863 4216020.203357722, 1913118.4995280681 4216021.7560898615, 1913118.71 4216021.57, 1913120.6482049066 4216020.736172718, 1913124.1232216936 4216026.004728279, 1913130.931364041 4216040.019577894, 1913155.436998949 4216095.134307266, 1913171.760205963 4216130.191726181, 1913175.2563918475 4216138.457694879, 1913184.883330871 4216165.780166991, 1913192.094461996 4216181.4704439575, 1913200.444659112 4216179.713699818, 1913209.5899019653 4216178.105242015, 1913222.971437732 4216182.12185514, 1913231.6175745807 4216184.792042366, 1913232.736862217 4216185.665122787, 1913234.3729424416 4216187.009902835, 1913245.5675534122 4216200.364375987, 1913247.2015526223 4216202.007515965, 1913261.4026676344 4216213.105153147, 1913275.110206738 4216223.9760245625, 1913280.481452469 4216229.093574835, 1913281.645527432 4216230.379480971, 1913290.5383044998 4216240.097144535, 1913311.141132861 4216262.331245769, 1913315.0740462563 4216266.576581211, 1913325.7054856834 4216278.64057049, 1913325.813501776 4216278.763382169, 1913326.438531099 4216279.486159688, 1913329.3911778284 4216282.993493248, 1913330.966441961 4216284.867642395, 1913332.0534363086 4216286.182873478, 1913332.2564028786 4216286.491675837, 1913337.2266601813 4216293.885762096, 1913351.1785234832 4216319.597421292, 1913352.0039939745 4216321.814216608, 1913352.9562900034 4216324.3247835245, 1913354.4666468839 4216325.915845697, 1913355.4952535138 4216327.109725946, 1913389.1430818043 4216379.179111108, 1913394.3042966519 4216387.758464432, 1913411.920585292 4216427.317730818, 1913426.7018328533 4216459.366324395, 1913427.2172034641 4216460.356042407, 1913427.5698523612 4216460.797625361, 1913429.5074433405 4216463.157085532, 1913429.7873452622 4216462.763270038, 1913430.356171988 4216461.962944063, 1913441.785687409 4216471.910343584, 1913452.7850809717 4216479.719944332, 1913482.6212753034 4216499.237449393, 1913512.585261738 4216519.211112266, 1913522.1481519272 4216523.70894096, 1913550.8743440355 4216526.809677635, 1913551.1 4216527.73, 1913551.119421842 4216527.94710307, 1913552.9651643392 4216528.0859527, 1913560.7198068576 4216630.04312091, 1913569.655315732 4216711.663688835, 1913571.068457567 4216724.508055989, 1913548.53179594 4216729.473444173, 1913548.844455068 4216774.197722593, 1913548.36798583 4216834.012489878, 1913548.1182183092 4216870.486008339, 1913544.8504813125 4216892.37492019, 1913543.0386339535 4216902.534772222, 1913542.3244281074 4216906.439066055, 1913542.2095757467 4216906.96278843, 1913541.8335045546 4216908.731401822, 1913540.148688016 4216923.720718015, 1913525.6448178135 4216974.299939271, 1913509.489713683 4217027.447225415, 1913475.0353878199 4217097.084367519, 1913469.1622840425 4217108.390102349, 1913465.99548583 4217114.486194332, 1913448.9026087776 4217175.182616913, 1913449.8107122409 4217180.250674779, 1913450.6559433846 4217184.383707091, 1913456.8985231316 4217197.090056868, 1913461.3141840112 4217203.849124085, 1913463.5042757567 4217212.09880713, 1913467.6373366439 4217240.175915926, 1913471.6371125288 4217288.420434971, 1913478.634237425 4217305.396261965, 1913475.2205081235 4217319.510758364, 1913468.9895596656 4217334.579445765, 1913465.0395880423 4217347.575759293, 1913464.0735835927 4217353.510686126, 1913462.9309589572 4217361.630175698, 1913461.2011286227 4217362.648664582, 1913460.824079422 4217363.848149869, 1913453.8620065164 4217367.961035118, 1913446.8231411544 4217371.254771001, 1913444.2071751785 4217372.151116884, 1913431.8774340956 4217391.939490863, 1913427.1035920132 4217399.835850577, 1913422.7665512788 4217405.9870868055, 1913420.3904584656 4217409.155108607, 1913406.423347219 4217430.73801015, 1913396.5186364877 4217450.192718824, 1913392.4328564042 4217458.278866621, 1913389.0796253316 4217463.953719808, 1913386.8297390586 4217468.115655657, 1913386.280351568 4217469.131936133, 1913388.1090493326 4217473.427574403, 1913389.7048534255 4217476.990451062, 1913398.8479521663 4217488.222371869, 1913399.746004169 4217489.337880474, 1913409.2983914935 4217500.090925678, 1913428.4814834294 4217521.724575899, 1913430.0631135344 4217523.74846399, 1913431.191525985 4217526.379139368, 1913433.6700500136 4217538.391532406, 1913433.7084526923 4217539.675236632, 1913433.7872046225 4217542.1282501435, 1913432.234359373 4217554.035094494, 1913432.6518200764 4217556.605204932, 1913443.4960462614 4217584.503108409, 1913440.315605068 4217595.537037934, 1913430.7029941664 4217611.322619121, 1913419.218301666 4217630.448777729, 1913413.4135313535 4217640.604108783, 1913405.0802828 4217661.515581133, 1913399.726201173 4217686.933702532, 1913398.2933180807 4217693.965178565, 1913395.6744230264 4217704.516475407, 1913391.217391708 4217712.094036374, 1913391.1215592446 4217712.263396548, 1913386.003229269 4217718.429501602, 1913385.144676467 4217719.462176523, 1913383.0314145694 4217722.007699572, 1913370.6232582233 4217736.911883624, 1913354.7430807452 4217755.939283925, 1913354.1705101111 4217756.788292839, 1913352.1281919184 4217759.852176705, 1913341.4830322443 4217780.331057588, 1913337.8682968486 4217787.31903615, 1913336.6362554675 4217789.480123769, 1913335.1409289383 4217792.099404908, 1913312.6397129833 4217831.808511459, 1913309.7870595485 4217838.848492212, 1913300.7255326263 4217863.778637855, 1913292.0576013068 4217880.241091908, 1913286.330074391 4217890.501763823, 1913286.668043158 4217891.22359835, 1913286.7179816177 4217891.330257035, 1913282.9814084382 4217897.285636999, 1913275.3056079978 4217908.597148935, 1913269.9633037657 4217917.413494689, 1913267.6637056237 4217925.106591689, 1913267.4759079502 4217943.07985564, 1913267.4776867253 4217944.108524164, 1913267.8329564338 4217960.411388072, 1913269.2502918253 4217988.150844479, 1913269.3438286528 4217990.037173254, 1913270.7409345985 4218017.9605635675, 1913270.810668016 4218022.417823887, 1913269.2120197362 4218037.413424686, 1913267.1576442823 4218053.198266909, 1913264.8771607226 4218066.207159717, 1913264.0658201352 4218069.936671983, 1913246.2672530664 4218099.628842906, 1913241.8798548458 4218108.653080569, 1913235.7272829006 4218126.145260926, 1913234.8159421044 4218128.297696629, 1913229.2923294315 4218133.786375576, 1913208.0523351494 4218186.209307883, 1913206.8058123067 4218263.284356046, 1913210.6919102813 4218275.924698191, 1913216.2356199743 4218289.569741663, 1913221.0779698738 4218308.312745416, 1913224.9332310688 4218323.920325834, 1913226.4002037544 4218328.43934332, 1913233.6570514687 4218345.478570629, 1913237.5812509614 4218351.032908937, 1913244.2486080418 4218360.489840936, 1913254.6146890675 4218372.540780997, 1913259.0293227013 4218377.085933086, 1913263.261158456 4218381.548149127, 1913275.9044129555 4218393.568704453, 1913300.2922623528 4218415.601355797, 1913301.996390758 4218417.180685746, 1913308.3986845068 4218422.882178613, 1913328.3557895862 4218439.882479846, 1913335.12465375 4218445.541498038, 1913337.2542066092 4218447.333221976, 1913349.91550731 4218458.204676296, 1913368.7628683404 4218474.211984387, 1913378.6939031575 4218483.13762868, 1913382.2140000316 4218487.221419773, 1913384.2617932062 4218490.765561411, 1913386.8823154825 4218499.392800948, 1913391.7449240226 4218515.337047345, 1913394.610141518 4218521.358651918, 1913397.01119822 4218524.860464159, 1913398.440988042 4218527.012814849, 1913408.4427174518 4218539.535164484, 1913411.7519824703 4218543.460275566, 1913412.7318898747 4218544.5602520425, 1913413.4538313777 4218545.37536538, 1913416.3784545003 4218548.308207393, 1913419.3827865606 4218551.311892764, 1913423.5052373135 4218555.435942006, 1913443.158564694 4218573.82905983, 1913451.5126606675 4218579.046550876, 1913458.12 4218582.47, 1913459.56 4218553.28, 1913479.57 4218518.28, 1913495.2952927926 4218495.778289385, 1913506.28 4218480.06, 1913530.8687493356 4218443.499442048, 1913532.96 4218440.39, 1913549.1894825124 4218417.108135109, 1913564.5915033699 4218395.161097268, 1913603.743860656 4218340.006445099, 1913603.7950126713 4218339.934149711, 1913603.89 4218339.8, 1913614.8975159612 4218322.6491997335, 1913616.086162071 4218320.742455025, 1913635.0555584873 4218290.313048042, 1913638.43 4218284.9, 1913663.940977783 4218246.972381427, 1913671.18 4218236.21, 1913690.007831707 4218209.3548713075, 1913691.14 4218207.74, 1913692.6715998824 4218205.625904117, 1913695.3392582485 4218201.943936431, 1913697.244167873 4218199.314667968, 1913700.0618841907 4218195.4254899435, 1913702.3222707934 4218192.305571219, 1913703.337832906 4218190.903832574, 1913703.4880836753 4218190.696447613, 1913703.5 4218190.68, 1913704.270461549 4218189.682263657, 1913717.06 4218173.12, 1913741.758103211 4218146.822424383, 1913749.3351493664 4218138.754681496, 1913757.6467934423 4218129.922163799, 1913776.88 4218109.76, 1913795.0523923116 4218092.889033531, 1913817.3470040485 4218072.532995951, 1913830.78 4218060.88, 1913855.5548078036 4218040.580077276, 1913861.8928888442 4218035.386795602, 1913867.8579253757 4218030.378165372, 1913868.9859155908 4218029.430810666, 1913871.233106403 4218027.5434833085, 1913873.4696200974 4218025.666643442, 1913875.4770747249 4218024.083690089, 1913915.8981800175 4217992.210130777, 1913923.6221498328 4217986.119490547, 1913924.0365927322 4217985.792686759, 1913929.793491904 4217981.50166947, 1913939.6023994458 4217974.190659326, 1913950.50620223 4217966.059670766, 1913967.4656334224 4217952.995098236, 1913967.9319498711 4217952.635874785, 1913968.7500036352 4217952.005692906, 1913969.0177673995 4217951.799423857, 1913969.0292432953 4217951.790582914, 1913969.029843549 4217951.7901205495, 1913969.0302194017 4217951.789827757, 1913969.0317481773 4217951.78862766, 1913969.0468587491 4217951.77676569, 1913969.0922450507 4217951.741136947, 1913969.1603799015 4217951.687650351, 1913976.0533543287 4217946.27659001, 1913987.31 4217937.44, 1914025.55 4217903.05, 1914042.0686013561 4217889.062947609, 1914088.7757638576 4217852.858481353, 1914094.0976806837 4217849.053067604, 1914093.9245902158 4217848.80826886, 1914096.6519524152 4217846.592493531, 1914103.8078264445 4217840.935817882, 1914104.8096117605 4217840.150875016, 1914113.3723903352 4217833.470223486))'::geometry,'38068','Champagnier','CHAMPAGNIER','CHA','CHG'),
     (14,'SRID=3945;POLYGON ((1914374.3012233067 4213194.741939098, 1914414.4477980481 4213499.448919852, 1914429.69 4213707.06, 1914434.5313135674 4213705.130201539, 1914438.2728258253 4213703.331872656, 1914442.6210472304 4213701.905548694, 1914453.498001788 4213698.470782074, 1914474.649237433 4213694.758204888, 1914484.911902834 4213692.670647774, 1914489.8554556991 4213692.897948944, 1914509.0437443154 4213692.781255074, 1914531.0487482932 4213682.124563336, 1914572.886707918 4213654.31465788, 1914641.8502705507 4213612.098599581, 1914683.1268113274 4213591.496880648, 1914690.0417122846 4213588.0781007325, 1914721.9528958537 4213570.685325343, 1914810.3865688506 4213523.158841731, 1914835.31450005 4213510.113617081, 1914881.085045057 4213487.66105806, 1914936.5338383417 4213459.7814533245, 1914949.96 4213450.35, 1915221.117970891 4213307.543442965, 1915470.6591783627 4213176.165059945, 1915591.98588566 4213112.881327172, 1915747.6549019786 4213031.682574234, 1915843.420880621 4212981.7308656, 1915888.6 4212958.54, 1915888.7142594666 4212959.239267935, 1915920.6298098727 4212942.628909068, 1915945.029342865 4212929.8797438815, 1915945.0805088384 4212929.554282125, 1915947.5458941883 4212928.28860129, 1915946.8277142944 4212921.499569423, 1915944.006814241 4212912.514997207, 1915943.48 4212910.43, 1915937.5987575348 4212895.405289037, 1915917.46 4212841.68, 1915936.73 4212832.98, 1915958.86 4212827.53, 1915973.25 4212825.95, 1915980.198602088 4212827.584233283, 1915999.115003984 4212826.935780551, 1916010.686861064 4212826.318434593, 1916019.0795319006 4212825.416054624, 1916038.851201039 4212822.831525738, 1916079.285771091 4212801.343208608, 1916103.3649030451 4212792.473014698, 1916124.3669565602 4212790.985630793, 1916112.922544261 4212777.964922656, 1916096.1921102433 4212766.361673337, 1916101.960326531 4212760.178832182, 1916116.5230192463 4212756.413448722, 1916136.0818881725 4212757.597793351, 1916145.9256415772 4212755.690877142, 1916136.4151569125 4212748.555110737, 1916101.86 4212728.75218376, 1916096.627731136 4212723.890328964, 1916087.62 4212719.11, 1916079.371071052 4212715.536071052, 1916049.5726616166 4212718.09141979, 1916043.4509369852 4212716.149750236, 1916036.0626223306 4212704.085632481, 1916044.418499473 4212682.770826391, 1916046.3972852626 4212650.202866992, 1916041.2723581782 4212637.86360711, 1916021.9479715372 4212609.207707258, 1915988.7710966861 4212551.200405299, 1915976.1421685505 4212514.022630712, 1915967.727866992 4212471.3860203, 1915964.4566527817 4212407.467479172, 1915974.5732058648 4212372.693337026, 1915982.7484994729 4212339.589898497, 1915980.359662932 4212314.780978645, 1915963.98574453 4212288.229894072, 1915960.1971837594 4212263.405775639, 1915953.6575737274 4212233.4701605085, 1915931.230359346 4212153.524386304, 1915911.6920406013 4212101.20422436, 1915910.8340304508 4212084.386897442, 1915919.7076730824 4212069.858600976, 1915902.175 4212023.415, 1915888.256264962 4211980.027091353, 1915884.8134487213 4211950.707959399, 1915880.5550507514 4211923.747571579, 1915882.878836541 4211896.584173609, 1915887.407234511 4211871.13378579, 1915895.7590812026 4211852.92679594, 1915918.855101503 4211838.093938043, 1915942.2246121801 4211820.4525806755, 1916005.420092407 4211752.721694437, 1916028.632158354 4211742.19588253, 1916035.8973538214 4211721.488815608, 1916027.758550156 4211687.158243778, 1916036.695739822 4211676.696099885, 1916048.0136039678 4211661.549360746, 1916060.5135972244 4211649.412979181, 1916071.0738117867 4211636.253842079, 1916077.1764242991 4211616.286680872, 1916076.6226496724 4211606.502941947, 1916069.6791267681 4211589.133739581, 1916067.4020694762 4211580.8708008425, 1916062.0941794794 4211572.665295502, 1916057.2076957298 4211565.694876003, 1916046.561765362 4211556.478815456, 1916038.3684169068 4211549.558887478, 1916035.0548228407 4211544.941995582, 1916016.2734462048 4211514.352936487, 1916019.000762831 4211496.005095854, 1916026.416915826 4211491.60969278, 1916036.9843558117 4211488.471370157, 1916048.6703701958 4211485.499674802, 1916054.7143766154 4211463.4453461645, 1916053.188339722 4211455.482094433, 1916046.7977054892 4211438.308455661, 1916043.8395051507 4211417.622764101, 1916015.2194182705 4211359.94038782, 1916008.009007284 4211339.627767088, 1916000.3975026791 4211309.406183558, 1916002.9154694255 4211298.50476654, 1916000.7601074798 4211289.792197548, 1915987.0401087506 4211240.571525973, 1915992.7999075935 4211200.412816242, 1915988.1917477963 4211189.818559569, 1915977.7102034464 4211175.370460926, 1915973.7555865445 4211141.482566352, 1915966.5138877507 4211121.776573747, 1915970.7753515972 4211095.594064415, 1915972.6052446614 4211058.552571579, 1915976.9689594153 4211025.197698941, 1915974.9012936945 4210948.875182796, 1915997.7699075933 4210902.857479173, 1916020.1625503928 4210808.023928752, 1916046.6239567157 4210732.509023094, 1916057.109570525 4210677.229907593, 1916047.7393535527 4210641.760704164, 1916041.7306959566 4210632.660698379, 1916038.473334223 4210622.0828986745, 1916035.2540812027 4210585.936071053, 1916038.8312233065 4210561.1655908255, 1916024.2444678152 4210534.002716164, 1916001.7387441343 4210483.634030451, 1915913.9060203005 4210400.441551278, 1915803.8856902234 4210297.231950334, 1915758.025429475 4210248.75179594, 1915727.0005726332 4210185.2626639865, 1915699.6837857896 4210144.855683233, 1915668.871491627 4210095.375326432, 1915653.6686933828 4210058.494039548, 1915639.0169516373 4210032.930530074, 1915577.4989796996 4209869.785318876, 1915545.67679594 4209824.365766543, 1915489.036175547 4209712.301785963, 1915483.3170106057 4209639.007355639, 1915494.6530101504 4209565.834672028, 1915498.9365582673 4209510.2367457505, 1915494.0263573688 4209443.385346165, 1915505.633068048 4209438.393394791, 1915508.1093005755 4209422.410531209, 1915513.9852388275 4209413.659042566, 1915562.7707430802 4209182.650235564, 1915574.4863562754 4209158.136437247, 1915566.2761373683 4209156.220612554, 1915527.1384215944 4209149.035833806, 1915452.1852518944 4209135.360197537, 1915330.8159401529 4209113.992769964, 1915326.3359142705 4209115.854218627, 1915325.9618707183 4209115.791932795, 1915291.3372773067 4209129.617104862, 1915279.0075538368 4209134.529247391, 1915207.010371374 4209163.202053408, 1914978.657722387 4209254.485867729, 1914918.655438571 4209278.33024466, 1914828.5963734633 4209313.074482225, 1914751.7927419266 4209343.906806404, 1914437.5988576123 4209470.358420025, 1914423.9195980425 4209489.410560447, 1914414.574529776 4209496.608146485, 1914405.0412381934 4209499.473385098, 1914399.3976256275 4209502.202733352, 1914378.0363273444 4209518.609182574, 1914357.6170312027 4209535.023634145, 1914329.7569405837 4209552.053622197, 1914302.168553654 4209569.1518208, 1914268.8626129325 4209588.402775427, 1914227.181972719 4209606.878761807, 1914199.2423686716 4209629.175071363, 1914174.6337120715 4209641.085604, 1914161.7891409982 4209647.967491892, 1914123.1716937367 4209676.100924976, 1914084.503884462 4209692.379775128, 1914056.0153460389 4209705.354285807, 1914032.9473712808 4209726.541292368, 1913995.1849462476 4209759.112185041, 1913983.4349213308 4209773.280681055, 1913973.5038974953 4209792.030162299, 1913960.8786315948 4209803.653551707, 1913954.6282577608 4209805.978493035, 1913934.2467671416 4209801.541419154, 1913930.870274863 4209799.924966776, 1913925.7637320946 4209796.979135558, 1913920.676283736 4209798.12713308, 1913920.1976581535 4209798.197417758, 1913902.3937240795 4209810.016834968, 1913898.2497130272 4209812.768649941, 1913890.58618724 4209817.854077786, 1913890.5217068698 4209817.896530487, 1913890.343648593 4209818.013588985, 1913867.4924872003 4209833.404729057, 1913865.825617286 4209834.040964269, 1913818.4407248874 4209842.806071051, 1913812.6259153385 4209844.060498441, 1913806.9455701513 4209844.754810212, 1913774.3237129122 4209850.233823535, 1913759.2531323493 4209852.771569805, 1913739.9634347234 4209856.258340878, 1913731.4589030738 4209854.155641587, 1913369.5575121478 4210076.215738641, 1913327.2056909348 4210101.723892216, 1913285.4412142104 4210127.435969549, 1913209.766112996 4210173.4933450315, 1912973.3524791722 4210316.059713683, 1912867.5798238663 4210380.817036658, 1912819.7943367378 4210410.076020303, 1912818.2497871092 4210407.67964824, 1912812.61 4210411.07, 1912811.1333313594 4210411.958975212, 1912895.4448204725 4210554.029201183, 1912913.048807357 4210583.59865108, 1912937.4655768198 4210625.064766313, 1912990.4461634587 4210718.862816241, 1913064.7300598477 4210857.505364357, 1913089.4306252485 4210907.17689191, 1913237.315032183 4211147.970225834, 1913314.577673082 4211253.145, 1913399.955835487 4211387.894713683, 1913511.07 4211507.005, 1913551.141163459 4211558.538448721, 1913586.6820822565 4211605.762082256, 1913665.530282569 4211556.158157784, 1913871.663162405 4211969.470106773, 1913979.47632481 4212205.285655945, 1914158.6291410504 4212574.556574741, 1914211.5088781961 4212746.841884521, 1914292.896467968 4212962.334940151, 1914335.444630373 4213047.483448721, 1914374.3012233067 4213194.741939098))'::geometry,'38071','Champ-sur-Drac','CHAMP-SUR-<br>DRAC','CSD','CSD'),
     (11,'SRID=3945;POLYGON ((1907213.4155747811 4218715.471932075, 1907311.08 4218917.2, 1907348.51 4218993.52, 1907397.1 4219093.88, 1907431.66 4219165.34, 1907446.57 4219311.54, 1907459.81 4219442.28, 1907474.98 4219594, 1907481.73 4219662.28, 1907548.67 4219802.79, 1907954.31 4219732.9, 1908139.2703202716 4219748.040975251, 1908219.5782388665 4219741.361012146, 1908739.1277147378 4219783.207183759, 1908969.5227654888 4219727.930969549, 1909152.195 4219680.22, 1909402.2398568417 4219618.767622331, 1909533.858121462 4219584.0930213, 1909544.808810848 4219581.210717673, 1909555.5377763147 4219578.261368488, 1909823.3317870563 4219544.204143024, 1910093.0945551752 4219509.337969594, 1910404.6322523027 4219467.885733908, 1910401.9055782168 4219463.238804053, 1910410.0422950282 4219461.976592282, 1910621.0614055602 4219430.953458173, 1910635.1158388231 4219428.873667839, 1910635.262038581 4219430.384398671, 1910790.3182349487 4219407.615583573, 1910954.9864960946 4219480.171355699, 1911042.8785229377 4219465.447908647, 1911159.9471655686 4219445.310530978, 1911261.0843675192 4219428.270286317, 1911265.4650920148 4219425.686883814, 1911279.316985543 4219418.111728061, 1911399.6067170198 4219403.82532482, 1911417.2656432875 4219401.758459874, 1911419.155342687 4219401.438327741, 1911417.910308997 4219392.609792256, 1911401.3235583487 4219275.895698007, 1911399.5744342923 4219216.688822706, 1911394.2451548823 4219127.636835043, 1911384.9988483158 4219103.058624599, 1911382.1497823568 4219081.363754137, 1911381.9763613022 4219076.153753018, 1911389.268480739 4219025.119627393, 1911390.8999257346 4219013.554828872, 1911391.3917023505 4219010.08656392, 1911391.703050729 4219007.649105138, 1911392.21695479 4219003.57439721, 1911392.2318675057 4219002.232803762, 1911391.773402652 4218999.619324251, 1911391.0176462948 4218995.450236145, 1911382.6253001422 4218962.197266021, 1911378.4546109962 4218943.971930661, 1911376.1002815543 4218933.67740176, 1911372.6795663356 4218916.078857812, 1911372.0407697915 4218912.779221835, 1911372.2248426308 4218910.846419129, 1911372.726590716 4218905.390329043, 1911374.8772064974 4218890.766701354, 1911376.7587053217 4218877.791666275, 1911380.0673219229 4218858.29320598, 1911380.5793097406 4218855.429114737, 1911385.8402919034 4218825.897509837, 1911388.6088939519 4218810.367541613, 1911391.312579375 4218794.678671955, 1911391.779632709 4218791.926601836, 1911392.0416456475 4218790.391405333, 1911392.340633636 4218788.629684635, 1911393.0570041882 4218784.426363483, 1911394.4608541888 4218776.153953793, 1911395.6526615196 4218769.65918288, 1911399.6974831296 4218749.041308994, 1911402.49858205 4218734.802646091, 1911410.9997973605 4218694.671110763, 1911418.159184039 4218660.891593248, 1911427.8811051864 4218586.676920664, 1911434.239652221 4218532.803889844, 1911439.1946121806 4218488.551998945, 1911443.0832847797 4218467.869024269, 1911443.7692984121 4218464.236918223, 1911460.5876730818 4218387.178254812, 1911467.4612070324 4218356.426549825, 1911474.4850145392 4218325.789909653, 1911475.4430747917 4218321.6100104675, 1911475.600244661 4218319.166754284, 1911476.0052694506 4218312.951964458, 1911476.7887374589 4218292.302507013, 1911481.2993667969 4218220.344109055, 1911483.6368242342 4218200.012299377, 1911499.8925786712 4218109.042965196, 1911490.5095578604 4218053.012219294, 1911503.4102446612 4217980.858836541, 1911509.48980609 4217948.331998946, 1911520.5688913972 4217903.425314872, 1911528.894275112 4217870.5175299235, 1911539.4862016896 4217828.653760483, 1911536.7490336567 4217757.114630767, 1911540.4128664788 4217687.304603975, 1911551.127479172 4217642.732225415, 1911559.5386309077 4217611.059158969, 1911575.0962649616 4217575.700877141, 1911594.654396934 4217534.763469252, 1911603.8484487215 4217515.759570524, 1911616.0202954125 4217488.236509624, 1911626.5340487938 4217464.461757561, 1911628.1772161836 4217460.792118896, 1911632.86076848 4217449.377032233, 1911634.531383944 4217446.152229484, 1911635.2186751203 4217444.365387675, 1911642.76075887 4217431.390039925, 1911649.2392204676 4217420.532105807, 1911656.5894487787 4217408.611155957, 1911663.7037934274 4217396.628853865, 1911672.3438504136 4217381.43063179, 1911683.2500720352 4217361.95844664, 1911686.8975650147 4217355.920931352, 1911691.1137032527 4217349.620798926, 1911695.7549759576 4217343.078485448, 1911697.025648125 4217341.476486799, 1911702.7327807313 4217335.288324144, 1911706.3041603279 4217331.673563744, 1911709.340532793 4217328.605043905, 1911716.6396089306 4217323.051737107, 1911720.9739522093 4217319.757102538, 1911721.4525175383 4217319.392752571, 1911728.6169191306 4217314.07468301, 1911737.270696596 4217307.6789839575, 1911745.797461555 4217301.384497261, 1911750.0320253125 4217298.258692818, 1911756.3650388694 4217293.54184117, 1911758.9627523297 4217291.577537356, 1911766.0188337544 4217286.225577712, 1911768.8097329605 4217283.971705632, 1911770.1779635302 4217282.875246855, 1911774.1862892823 4217279.455935989, 1911777.2850449146 4217276.819931252, 1911777.513393236 4217276.611787911, 1911790.6435457144 4217262.861983959, 1911807.6415376985 4217243.495732012, 1911824.8606082848 4217224.455754586, 1911826.3690659963 4217222.7810585275, 1911827.4747947692 4217221.549052728, 1911828.4166041014 4217220.469944142, 1911839.5722960935 4217207.616275193, 1911847.6942983284 4217197.984528403, 1911868.6958880683 4217172.434378838, 1911868.7374126439 4217172.384632215, 1911868.8491915658 4217172.250815582, 1911876.9001044193 4217162.639579857, 1911882.3633264727 4217156.281297273, 1911908.0757478818 4217127.537584057, 1911914.759078747 4217121.145212145, 1911942.7662068163 4217097.329104141, 1911995.0080161944 4217053.857287449, 1912009.2471046222 4217042.871291014, 1912027.8274500372 4217029.952480325, 1912056.3342864565 4217010.556028179, 1912071.3383663676 4216992.654832741, 1912079.2520868047 4216980.260678685, 1912098.0596336357 4216948.480327443, 1912105.0160783208 4216937.425646262, 1912110.7615908426 4216929.16834508, 1912118.4764377733 4216918.327669605, 1912125.9346111377 4216906.484657192, 1912127.4937112418 4216903.733482621, 1912128.121476491 4216902.632343376, 1912128.730101323 4216901.563765893, 1912128.942722614 4216901.051103425, 1912132.5344160225 4216891.2304124115, 1912133.622186235 4216886.740364372, 1912134.0485987032 4216882.338096313, 1912134.2222616016 4216859.579059816, 1912134.3400870734 4216857.899486364, 1912134.5853137234 4216854.120450879, 1912135.9707230984 4216846.861809936, 1912141.17655211 4216826.148609231, 1912144.8955681075 4216791.791026325, 1912145.2103479519 4216789.255171273, 1912148.7008400958 4216781.934537723, 1912154.6969099888 4216769.318535513, 1912160.7554521419 4216756.617080395, 1912161.442489879 4216754.954919027, 1912162.9607545573 4216751.270205698, 1912162.7883502026 4216747.918481781, 1912161.6553632403 4216739.528458198, 1912160.8934321532 4216733.371755972, 1912160.823821254 4216732.809268477, 1912160.547975235 4216731.115551391, 1912159.390788142 4216725.959639715, 1912157.255975729 4216716.372211386, 1912155.7859942804 4216711.758679715, 1912155.71424781 4216711.529904164, 1912155.4052466634 4216710.687660632, 1912154.5941295547 4216708.479089069, 1912145.849008097 4216684.4706275305, 1912145.0117240117 4216681.452026007, 1912143.9424446928 4216676.220568193, 1912144.3433029258 4216673.994730271, 1912145.876183542 4216667.697845163, 1912147.6129382015 4216661.119271051, 1912147.6964121168 4216660.841671745, 1912148.526452653 4216658.560813347, 1912149.3904143693 4216656.190010963, 1912150.0914268745 4216654.292084662, 1912150.7183316106 4216652.658886942, 1912157.4931423797 4216634.977600962, 1912160.0288451293 4216627.766834924, 1912162.941490722 4216619.337521359, 1912171.8987864833 4216593.550360256, 1912174.9899046554 4216584.984383402, 1912176.3644374236 4216581.3685091, 1912179.6598127645 4216573.645809967, 1912180.57549507 4216571.7524644425, 1912205.7227965281 4216518.89843248, 1912211.1362877344 4216500.482918887, 1912212.7367382515 4216489.950169162, 1912208.7745723468 4216477.212919832, 1912203.8990922028 4216465.838046639, 1912203.6553753552 4216464.952171878, 1912203.452438457 4216461.975764036, 1912203.856495354 4216458.528741518, 1912213.4534740804 4216431.019737028, 1912217.2566676275 4216421.120182941, 1912217.510021388 4216420.122529037, 1912219.8955136808 4216406.163433323, 1912221.3237308995 4216394.672349832, 1912221.4393159624 4216378.676061956, 1912219.8902653155 4216357.612946951, 1912196.9009689994 4216108.676847355, 1912195.4739697985 4216078.205080378, 1912194.2816313494 4215999.721935724, 1912193.8941178536 4215968.275012602, 1912196.1465512787 4215905.9928162405, 1912184.681741021 4215842.826910554, 1912163.0100295008 4215746.683994636, 1912158.7800802188 4215704.638540304, 1912157.8467611335 4215687.648582996, 1912161.277700261 4215678.990569823, 1912188.5478413156 4215628.06879752, 1912250.4905564545 4215544.487326113, 1912268.6849674552 4215520.752195994, 1912319.455425101 4215454.104089069, 1912410.8785730952 4215343.87629948, 1912562.6149386405 4215197.891542325, 1912553.6291454618 4215203.3403061675, 1912500.4030485284 4215237.617253628, 1912376.9873995513 4215317.128577731, 1912308.7487370726 4215361.064634458, 1912199.5787278241 4215431.394717616, 1911999.4164624403 4215560.625632116, 1911924.378337224 4215609.854922392, 1911897.969153606 4215628.062952192, 1911845.0217197335 4215666.240128282, 1911793.1697973083 4215703.535643761, 1911792.2097820437 4215704.274177598, 1911791.322738306 4215704.974107449, 1911790.6048953424 4215705.541618479, 1911790.29722124 4215705.765451327, 1911788.4548310412 4215707.10849158, 1911780.140288716 4215712.9089782415, 1911719.3074912163 4215755.377401775, 1911662.60749927 4215794.781276738, 1911622.7026804488 4215822.394908611, 1911617.4781245512 4215823.931514539, 1911606.924406942 4215828.873346858, 1911596.290791965 4215834.836649315, 1911550.5322608198 4215855.7897943, 1911536.3909438157 4215864.014390622, 1911481.686205115 4215890.621592934, 1911467.0212497222 4215881.134758958, 1911459.4744080428 4215869.33068455, 1911453.167666339 4215864.73227191, 1911442.0933738004 4215858.866130062, 1911424.3787812418 4215847.046015753, 1911403.8415512785 4215838.22718376, 1911395.2067227322 4215836.371627568, 1911383.0549178708 4215835.389904184, 1911347.9812096625 4215825.6502908645, 1911297.055 4215816.714515225, 1911283.6370780186 4215813.962595609, 1911258.7308233664 4215805.632316872, 1911231.0196211294 4215794.927156318, 1911214.1730096573 4215784.430279195, 1911208.9027194094 4215780.9730958305, 1911200.003745734 4215770.036254265, 1911195.6201935438 4215765.137172932, 1911195.4017190144 4215766.522301448, 1911194.0551969756 4215765.423062947, 1911190.3269672103 4215772.796357837, 1911189.1390367667 4215772.287775116, 1911188.8001993967 4215772.142710366, 1911187.242572189 4215775.107627352, 1911187.1174128507 4215775.35414905, 1911186.354656276 4215777.820135983, 1911181.3959697818 4215793.816669259, 1911180.2911684858 4215798.365696452, 1911180.91488054 4215803.280212771, 1911181.3965516353 4215806.916458042, 1911181.5350920598 4215809.231062788, 1911182.0099709518 4215816.852724954, 1911182.07743181 4215822.701477153, 1911182.186250285 4215832.715014172, 1911181.6186865973 4215832.213181691, 1911181.56 4215833.43, 1911181.3252140316 4215833.918354814, 1911172.3368421434 4215828.072326918, 1911162.3121405656 4215826.293075909, 1911150.0503495273 4215828.049444378, 1911137.02660203 4215831.241795939, 1911078.0363641714 4215852.61112862, 1911071.5398126417 4215853.729443175, 1911065.5764572024 4215852.286786335, 1911062.5673513808 4215849.823481819, 1911060.334574899 4215847.4795141695, 1911056.553550351 4215842.490811252, 1911036.014232354 4215811.22637019, 1911014.7899144806 4215779.601988468, 1911008.6853733773 4215772.992829745, 1911004.371411363 4215769.429713395, 1911000.155641723 4215766.8854874335, 1910989.6181045757 4215762.749577319, 1910980.8883010151 4215760.658228928, 1910961.5163111652 4215756.982280714, 1910943.9512142104 4215753.855872595, 1910926.1659727152 4215750.768925379, 1910912.6653668862 4215749.20648629, 1910860.3189915377 4215744.921629084, 1910844.2079548512 4215741.698781242, 1910831.6707295484 4215737.391755954, 1910821.131985302 4215732.06649598, 1910815.9753229814 4215729.073994127, 1910811.2831071052 4215725.282996507, 1910802.1330748126 4215717.90824867, 1910790.661744273 4215709.98362312, 1910783.4280953347 4215706.985356981, 1910779.5790881542 4215707.540537423, 1910776.5887044535 4215709.94534413, 1910769.7326894507 4215716.685471378, 1910748.6664354624 4215737.374207552, 1910732.8583424555 4215752.734448061, 1910724.9868044516 4215760.307616169, 1910715.248846957 4215768.152043961, 1910706.469168598 4215776.993905798, 1910698.1988901892 4215786.572925144, 1910692.2510728617 4215792.746185753, 1910686.5553295664 4215798.646834642, 1910679.810605608 4215805.383703701, 1910669.8137309335 4215815.270059466, 1910660.7579781837 4215823.920634667, 1910639.852739083 4215808.464084218, 1910633.175741549 4215801.622704656, 1910627.316526395 4215795.721434781, 1910621.7429689197 4215790.850693364, 1910602.259354468 4215775.595347249, 1910584.0196034343 4215759.168486605, 1910547.0120052123 4215726.614675031, 1910521.3275101215 4215703.130829959, 1910511.3501177174 4215694.3091226835, 1910502.0786223814 4215687.061818264, 1910491.9223776695 4215679.803688835, 1910490.8398622791 4215677.275084588, 1910489.9943977708 4215672.858833978, 1910489.6338065073 4215669.884848833, 1910486.5786028258 4215645.780571876, 1910485.6587390418 4215638.464975714, 1910475.0653467677 4215626.32444971, 1910465.4588259107 4215613.701336033, 1910455.1032812987 4215597.390470063, 1910444.0008575672 4215576.207957247, 1910433.8645076235 4215556.003435973, 1910425.7137622256 4215543.964536216, 1910419.9417536696 4215537.815224821, 1910417.0293147152 4215535.312774189, 1910413.966132913 4215532.864986468, 1910409.2144705302 4215530.088381095, 1910389.6417451885 4215519.507862444, 1910379.837103398 4215517.06419466, 1910375.2922909178 4215516.4361351505, 1910373.1846330739 4215516.231839692, 1910369.3635090853 4215516.289812381, 1910356.47105589 4215517.5429821, 1910350.1872868573 4215517.704989619, 1910344.9949567511 4215517.217765086, 1910340.6781221568 4215515.943806766, 1910338.1985182299 4215514.032193096, 1910325.5876223305 4215497.130969549, 1910316.046331323 4215487.127693178, 1910305.2255746298 4215479.085011436, 1910283.7307756392 4215456.582036054, 1910273.8712053564 4215449.707501374, 1910265.4998425406 4215442.007061465, 1910261.1124555988 4215435.017959976, 1910259.7707429212 4215430.034868149, 1910260.0363786193 4215423.961968183, 1910266.235 4215392.98, 1910274.668535711 4215375.677554009, 1910277.9372942057 4215359.81173971, 1910277.6736009752 4215348.316454324, 1910274.5339679848 4215336.081097578, 1910265.3904585834 4215317.3918939, 1910258.1932324027 4215308.21129097, 1910248.2223241783 4215298.042431582, 1910244.699748056 4215292.838430081, 1910239.5245578652 4215279.105853175, 1910237.4310144847 4215274.800102104, 1910220.0413303478 4215249.681382558, 1910209.0522852624 4215230.48881835, 1910204.1628299667 4215223.689357825, 1910202.250110291 4215221.637303001, 1910200.5442447893 4215220.34472562, 1910188.9367988142 4215217.688666599, 1910181.7111637914 4215218.103875455, 1910171.328510551 4215221.454139918, 1910156.129820692 4215227.55071539, 1910151.7574666715 4215229.53718394, 1910146.5243146187 4215230.937746704, 1910141.7457761085 4215229.881238683, 1910141.423755685 4215229.774504893, 1910126.0108602038 4215221.260053936, 1910122.1205696797 4215219.826376191, 1910119.8386842092 4215219.228815789, 1910117.829671397 4215218.684239576, 1910109.708562753 4215218.362044535, 1910104.8238498473 4215217.578061559, 1910100.0896675903 4215216.265457064, 1910099.1462990574 4215215.8827353595, 1910095.2095058768 4215213.430201219, 1910073.720787638 4215196.437130906, 1910070.9976473027 4215194.620830486, 1910063.2708516936 4215188.27243063, 1910060.3504345077 4215187.321301992, 1910058.0743258311 4215187.105133482, 1910039.5168250108 4215188.708042629, 1910022.67461892 4215189.442028854, 1910005.3621649747 4215190.237507281, 1909994.108233389 4215193.338593561, 1909988.9948239361 4215194.612516285, 1909984.4462240066 4215197.00260397, 1909976.111990898 4215201.737231537, 1909970.2953381815 4215204.271324393, 1909967.6374198173 4215204.430888344, 1909966.0984806025 4215204.4748475645, 1909962.4174395497 4215202.900122126, 1909958.9980981525 4215199.259490798, 1909950.648735038 4215189.199755339, 1909949.4107451194 4215188.38337662, 1909947.9766981357 4215187.910435694, 1909946.9810971073 4215187.788517602, 1909944.2266257764 4215188.022839118, 1909942.3099492488 4215188.571066505, 1909929.762576898 4215199.898277627, 1909925.0228733344 4215203.795283491, 1909919.4236902164 4215205.35776902, 1909899.6906562112 4215200.658536699, 1909898.2061947274 4215200.316763668, 1909894.3600342763 4215199.764650822, 1909892.3050771912 4215199.7819489315, 1909889.8167094311 4215199.84178878, 1909886.4967339542 4215200.94917567, 1909863.5135918797 4215211.51417361, 1909850.8980490156 4215217.313030902, 1909837.3 4215219.865, 1909830.269019261 4215218.124047503, 1909818.8983459333 4215213.934151078, 1909809.7869155693 4215205.230142606, 1909807.7242615717 4215202.000645187, 1909802.0199630868 4215204.584941727, 1909794.4114834447 4215211.870281014, 1909786.58902125 4215216.068133801, 1909782.1274898688 4215218.19512455, 1909775.1727609413 4215221.1310203, 1909759.7228610292 4215224.097451845, 1909740.4055817297 4215225.905050752, 1909725.1706072874 4215219.955141701, 1909718.0353273733 4215214.961563312, 1909717.3494319539 4215214.472336613, 1909715.5915625854 4215213.465027708, 1909709.095122692 4215209.704590895, 1909706.711895684 4215209.011654811, 1909703.7266353602 4215208.961880455, 1909695.837172831 4215211.545399412, 1909684.62 4215218.1, 1909674.7103679287 4215222.475850434, 1909668.0498287713 4215223.459885996, 1909663.4758241607 4215222.062652455, 1909660.2297614387 4215220.393891859, 1909655.2844560826 4215217.63545837, 1909652.6640357885 4215216.605879215, 1909650.6446489522 4215216.155638055, 1909636.6415204327 4215213.0851326445, 1909634.0796356278 4215211.598714574, 1909632.9523192707 4215210.507644999, 1909620.7761661669 4215201.309151616, 1909616.4508406187 4215199.272208248, 1909612.075115289 4215198.95185276, 1909607.3121056785 4215199.950345962, 1909605.6913871104 4215200.663193901, 1909604.5758489566 4215201.261037768, 1909602.7815442851 4215202.47749952, 1909601.3870194 4215203.744638449, 1909596.7073777078 4215208.829453114, 1909591.5385719966 4215214.818168023, 1909588.3161559952 4215219.351344225, 1909583.8658931577 4215226.763031483, 1909579.1786496122 4215232.5648533655, 1909568.0940104637 4215243.78791348, 1909564.467871418 4215248.306801064, 1909562.4394349107 4215251.056018176, 1909559.4639778854 4215256.216085519, 1909558.969761499 4215258.332483817, 1909557.4946713387 4215265.676833845, 1909553.3409443293 4215271.3413036885, 1909551.8530627673 4215273.080583452, 1909549.5981738816 4215275.761804796, 1909547.1345468413 4215279.388287694, 1909546.6787767536 4215280.056456885, 1909540.391209251 4215290.90805803, 1909534.9190809936 4215299.284931042, 1909526.204357097 4215306.800702784, 1909520.2754340232 4215320.191994397, 1909516.9593232663 4215324.021442745, 1909512.4414081206 4215326.781311165, 1909503.2561513763 4215326.779216324, 1909495.8891274058 4215326.253638082, 1909479.8353923673 4215325.919510677, 1909479.5466669283 4215325.9810583405, 1909476.6282524026 4215326.856596607, 1909471.3960222716 4215329.423333807, 1909470.7901858662 4215329.7670952, 1909452.9239682744 4215339.895844405, 1909444.600133921 4215343.521904043, 1909441.6385425099 4215345.137085021, 1909438.2439797174 4215347.486191496, 1909435.1829335035 4215351.025676965, 1909430.1404322179 4215358.872887536, 1909425.4794324352 4215363.125825915, 1909422.5750842371 4215365.837502687, 1909419.6900672151 4215369.002874505, 1909418.5279448177 4215370.257180192, 1909415.252866929 4215374.39246619, 1909412.471132258 4215377.275313749, 1909408.934681174 4215380.911959977, 1909407.8588212621 4215381.666097493, 1909406.8811806412 4215382.299100215, 1909402.254288203 4215384.37197572, 1909399.8672702536 4215384.969949288, 1909387.9601871974 4215387.557169974, 1909379.5095247987 4215387.864172013, 1909356.9641187359 4215390.445109808, 1909337.1425545411 4215397.272282925, 1909330.8318089095 4215399.018981079, 1909324.5712990665 4215400.076295173, 1909315.5664951305 4215399.3595112385, 1909313.5146346102 4215399.164195961, 1909310.1453416157 4215401.242329192, 1909301.9830625597 4215407.5357127115, 1909289.6111740891 4215415.223562753, 1909276.622340847 4215422.891645198, 1909271.8493568597 4215425.722192978, 1909265.983805668 4215429.842449393, 1909258.2453012099 4215435.493132526, 1909257.6967901224 4215435.858806585, 1909241.9859695493 4215443.432234511, 1909234.630724574 4215449.894651788, 1909226.173290385 4215459.120447782, 1909225.7296487242 4215459.612260625, 1909225.6944680875 4215459.64308581, 1909220.7987127814 4215462.175502978, 1909208.9593145046 4215470.905624259, 1909201.535020243 4215474.196842105, 1909194.3809600102 4215474.554428754, 1909175.898056354 4215473.026745188, 1909171.04 4215473.18, 1909170.207163013 4215473.239283507, 1909152.2059315885 4215476.76829669, 1909137.7784468913 4215477.620302122, 1909121.3039676112 4215483.248623482, 1909117.629794857 4215484.276409104, 1909112.8497102137 4215485.559727777, 1909103.2348402864 4215486.924099453, 1909094.9625401683 4215488.014184494, 1909079.7591170904 4215490.091437029, 1909068.9721311834 4215490.976693733, 1909018.0015342783 4215495.939679682, 1909009.6139014638 4215494.300752581, 1908996.4199030453 4215490.5429593995, 1908969.1596410554 4215482.244926653, 1908959.29815319 4215479.211376345, 1908923.465652033 4215468.068896942, 1908895.9864347056 4215459.325269669, 1908882.6069971458 4215453.264300156, 1908875.516415811 4215448.647858386, 1908868.436713952 4215442.693748367, 1908849.7504133394 4215420.1664209375, 1908829.7118687185 4215396.057674943, 1908823.6284591444 4215390.391158235, 1908821.956292255 4215389.20934407, 1908808.8444135487 4215381.084206573, 1908805.7859335402 4215381.748637342, 1908803.5529735053 4215382.167224245, 1908796.1644945415 4215386.207479254, 1908784.4704643115 4215393.99499897, 1908780.9207962654 4215390.143934357, 1908777.2890964947 4215385.6301928535, 1908769.7944947835 4215375.058493363, 1908765.1997549362 4215368.891553755, 1908759.688964822 4215361.75542411, 1908748.4726916049 4215349.937561009, 1908737.2539518948 4215338.816653233, 1908726.6381337466 4215332.7110900385, 1908722.7524616467 4215330.976839568, 1908718.4107523854 4215329.685910384, 1908715.5010238644 4215328.779538636, 1908704.8124999902 4215326.564999998, 1908697.1377748034 4215324.990419336, 1908691.2732609136 4215323.815191787, 1908680.2201931756 4215323.173180296, 1908678.2486369242 4215323.406597896, 1908668.6595973137 4215324.616729684, 1908648.0831475663 4215327.673555669, 1908648.0771331359 4215326.781415139, 1908646.425778418 4215326.472625232, 1908647.072821109 4215316.715951602, 1908649.4055303822 4215302.827907311, 1908634.3523093837 4215299.8719435865, 1908630.7948533013 4215299.031408038, 1908621.9945746514 4215296.898667918, 1908617.0337285928 4215295.341569639, 1908613.340518852 4215293.359198802, 1908606.2275509336 4215258.786834314, 1908598.0317813384 4215228.646249745, 1908598.7838872923 4215187.463250264, 1908592.3578260345 4215170.268120169, 1908584.5444640715 4215161.333639138, 1908580.7042724728 4215155.655740852, 1908578.8959682763 4215140.1320030475, 1908576.348169814 4215133.166551721, 1908569.1873438158 4215123.906234867, 1908561.8066140627 4215115.167384343, 1908555.1132388664 4215107.664615385, 1908552.94782359 4215105.436081555, 1908550.7164074122 4215103.824527829, 1908538.733453019 4215096.005067502, 1908525.1382305834 4215091.738478127, 1908519.4387579313 4215089.441555736, 1908515.3044268754 4215087.794968625, 1908511.4735910576 4215084.805867148, 1908499.9902934544 4215072.633074082, 1908496.554619525 4215069.023334493, 1908490.1820863243 4215063.693104908, 1908480.900554051 4215058.606283864, 1908469.448076981 4215054.233154398, 1908454.574846576 4215052.12647566, 1908438.7838320227 4215051.833383385, 1908420.0380922155 4215046.837002303, 1908397.7411363584 4215043.699507785, 1908387.4191825686 4215040.481111156, 1908355.2407348389 4215021.530414126, 1908350.17900003 4215017.396391121, 1908344.5106667187 4215010.434162313, 1908339.0052907187 4215003.155502952, 1908332.5863616096 4214997.669116921, 1908320.779426357 4214994.689435159, 1908295.458172861 4214992.835067501, 1908279.65561368 4214997.614077468, 1908243.7048444033 4215011.720241156, 1908236.8271649154 4215010.711408277, 1908236.6016882493 4215010.669569494, 1908218.9084814158 4215005.373476986, 1908205.3302927092 4215001.124148813, 1908204.6167670614 4215000.969022762, 1908195.064463727 4214999.1094778925, 1908181.8042914981 4215003.102611335, 1908149.0578452672 4215007.429538654, 1908136.4030135504 4215017.235018554, 1908127.335911603 4215019.984293104, 1908114.1686477552 4215019.664482828, 1908100.7896356275 4215019.535991903, 1908078.6230970884 4215023.298689969, 1908073.654057358 4215023.398929254, 1908072.1853936897 4215023.393505743, 1908063.8076607422 4215021.688374135, 1908050.1276339155 4215017.034925461, 1908041.3102285606 4215015.084679789, 1908027.8543212682 4215013.510456712, 1908025.1197393674 4215012.459782305, 1908022.809902229 4215006.286481098, 1908020.627363772 4214999.534045021, 1908020.0022350536 4214997.817177722, 1908018.37204251 4214995.922326278, 1908008.0187002383 4214992.135108591, 1907996.0775715793 4214990.523444175, 1907990.954291498 4214989.195303644, 1907988.6399071417 4214987.180034042, 1907984.7493621616 4214981.061467212, 1907980.7120679077 4214974.402626591, 1907968.307155688 4214971.951267513, 1907967.3186173576 4214971.517521063, 1907964.9655203174 4214969.601169474, 1907964.411195358 4214969.122678317, 1907961.9616684788 4214966.186485931, 1907955.5312597028 4214960.88638186, 1907950.6568267068 4214957.382770834, 1907949.9889069279 4214957.104411901, 1907937.3043726978 4214951.920557779, 1907935.6887927572 4214947.756579479, 1907935.3071298 4214946.74912016, 1907934.9628507185 4214945.980735286, 1907932.851491398 4214941.240760417, 1907927.3490889587 4214941.979537347, 1907918.6271417502 4214943.211162605, 1907897.8876878654 4214947.380469992, 1907892.1492116598 4214946.7586239325, 1907886.2154413185 4214944.034884556, 1907872.7036077876 4214932.659286727, 1907861.2480014772 4214920.320476116, 1907853.0325077658 4214909.286346936, 1907851.1593443328 4214907.516767528, 1907850.343841745 4214906.810416307, 1907847.9163444047 4214906.147658344, 1907845.1212286192 4214905.729351562, 1907823.2725746206 4214904.42902985, 1907822.2342576825 4214904.352025597, 1907817.9304929406 4214903.684535129, 1907814.076164071 4214902.1316091865, 1907807.3280749298 4214898.125750837, 1907799.7331336793 4214892.5364278415, 1907793.483134732 4214885.352232972, 1907786.5002400212 4214876.229877887, 1907778.946113725 4214867.608608957, 1907774.368216113 4214866.242327441, 1907773.603248294 4214865.993845488, 1907771.2779257789 4214865.712056664, 1907770.5457487358 4214865.641256345, 1907767.323045853 4214865.3376988955, 1907760.0074702553 4214864.647528727, 1907759.1929445183 4214864.194561268, 1907759.0382815525 4214864.103866997, 1907758.8030021144 4214863.563849058, 1907758.1791401217 4214861.932878334, 1907756.939609539 4214857.31819562, 1907756.3166957148 4214854.7009967165, 1907755.3031768734 4214848.447090266, 1907754.5344534414 4214841.611619433, 1907753.2477826925 4214817.966328279, 1907752.1966691238 4214814.699370884, 1907751.6367488974 4214813.3797836015, 1907750.511202112 4214811.354784063, 1907746.2631700165 4214808.008205415, 1907740.1012817908 4214805.112574029, 1907735.5955005207 4214803.589207514, 1907730.5418946561 4214802.501454871, 1907727.717526978 4214801.9901455045, 1907722.465351991 4214800.797368636, 1907720.3763491462 4214799.163583957, 1907718.639757763 4214797.824540937, 1907715.285934377 4214793.7927017575, 1907710.191145694 4214787.7325654235, 1907707.5140421742 4214785.121352235, 1907697.0195333222 4214782.063984553, 1907694.8842352729 4214781.210020435, 1907694.6502726977 4214781.118808113, 1907694.4911571853 4214781.000740239, 1907690.155723127 4214777.835344031, 1907683.3554215708 4214769.81430468, 1907679.8601074042 4214764.35409685, 1907677.5986592397 4214759.928535788, 1907674.0720641138 4214752.9173339475, 1907670.4742954315 4214743.758828827, 1907664.172720767 4214721.505150858, 1907662.236285742 4214718.655354722, 1907660.924183792 4214716.7824948365, 1907658.234253387 4214715.114701438, 1907647.8832187376 4214709.008837313, 1907627.9069792195 4214699.106369092, 1907606.8666751934 4214686.848337597, 1907602.5844167816 4214684.335123535, 1907597.9934727317 4214681.00538291, 1907595.2837830493 4214677.00889157, 1907595.2558895147 4214671.902538139, 1907595.5040314137 4214670.680541012, 1907595.5895253886 4214670.29451929, 1907597.5297269644 4214666.160238904, 1907599.8180231801 4214661.374891235, 1907600.823314824 4214659.125230431, 1907604.0194759825 4214651.930793661, 1907604.5790284043 4214646.550694675, 1907604.3992714672 4214644.634491303, 1907604.2585228663 4214642.839101287, 1907601.590850571 4214633.557647977, 1907594.7266717902 4214610.098544958, 1907591.781256399 4214601.49985626, 1907590.7897484081 4214598.870289856, 1907589.6748228616 4214596.27265704, 1907588.198387338 4214592.741457565, 1907587.6620505156 4214591.89558591, 1907587.260843333 4214591.244063991, 1907582.162876963 4214584.5527697615, 1907578.6872568068 4214582.043596653, 1907576.3544207846 4214581.68946134, 1907568.437052656 4214580.547890684, 1907563.7884968591 4214579.339511842, 1907562.7286596668 4214579.04743965, 1907561.6437067126 4214578.518896481, 1907561.1800394054 4214578.283176831, 1907558.7557365259 4214576.748868887, 1907552.2654974929 4214571.525273724, 1907547.366081831 4214565.531265886, 1907541.7132481183 4214557.273224504, 1907534.4426250355 4214543.621556746, 1907534.2120481927 4214543.189012247, 1907533.8077343074 4214542.504320947, 1907528.0617547631 4214532.952543546, 1907514.538723976 4214523.486934348, 1907513.5266840875 4214520.887323606, 1907513.1126337238 4214519.795640006, 1907513.466139406 4214512.536800893, 1907514.9492577792 4214501.5417831065, 1907516.5891830197 4214489.216508485, 1907517.6304216776 4214483.275780323, 1907516.9940666729 4214477.430206374, 1907516.6429689177 4214475.247774691, 1907513.0412538599 4214466.06168907, 1907511.0813088012 4214461.598826362, 1907509.1540960248 4214456.555086219, 1907507.5418531492 4214450.369985961, 1907506.3032040603 4214442.845918798, 1907499.0282693824 4214428.597584939, 1907493.1633233067 4214416.358600619, 1907490.4852898454 4214411.146530308, 1907478.814561429 4214385.888494925, 1907464.6258745666 4214359.516781441, 1907458.902032439 4214346.587952464, 1907441.8955355259 4214310.521892894, 1907437.445535526 4214300.790830938, 1907453.4631016725 4214296.085703554, 1907469.0769039926 4214288.987281389, 1907475.4524961165 4214285.003283459, 1907480.8826477695 4214280.770932112, 1907481.5919256539 4214274.565192956, 1907480.956450479 4214260.049039935, 1907480.638971011 4214252.201121197, 1907479.1023444666 4214244.947673955, 1907477.691648395 4214242.056941957, 1907474.9035568228 4214236.228833863, 1907468.5964048328 4214227.773357951, 1907461.2229955487 4214217.560556057, 1907457.3441295547 4214202.690526316, 1907455.2734119568 4214195.48630723, 1907450.9808270328 4214177.467849805, 1907449.8981071052 4214173.0818928955, 1907447.4403181341 4214167.516165503, 1907447.011455957 4214166.597803044, 1907433.9272730462 4214143.691696677, 1907413.3034810524 4214108.309006677, 1907403.575721893 4214091.519305701, 1907397.016756842 4214080.295081903, 1907386.3290655 4214060.375192068, 1907373.9080122968 4214038.909941113, 1907373.4129477998 4214038.0871113995, 1907372.893376746 4214037.247351118, 1907366.6926919052 4214027.2235517595, 1907351.9825260662 4214009.339255271, 1907324.6160203007 4213976.251260415, 1907316.0710955162 4213968.015149165, 1907295.9812404348 4213960.547854805, 1907281.5023730455 4213955.7656243555, 1907253.0059751258 4213946.210101197, 1907252.1192150575 4213945.473204282, 1907252.0727114102 4213945.440668088, 1907243.2451633003 4213929.896868941, 1907237.4799670486 4213919.065298215, 1907236.8349189188 4213917.472760485, 1907234.914060345 4213912.693262861, 1907235.2431761355 4213908.043962362, 1907235.5400526845 4213904.172851637, 1907237.9779251644 4213880.786657088, 1907233.0370850204 4213868.68368421, 1907226.4451756733 4213852.795201583, 1907220.8837145865 4213838.706680852, 1907216.2147955962 4213828.843177076, 1907204.4821862348 4213806.904979758, 1907191.7881983807 4213789.319433198, 1907188.0296396795 4213779.854821827, 1907186.66506388 4213776.184243044, 1907183.8998269015 4213767.683210703, 1907183.1433422558 4213764.624095472, 1907181.2555799447 4213757.579058248, 1907169.3177590803 4213741.277340677, 1907156.6146512558 4213726.606755955, 1907148.696808802 4213716.080935448, 1907143.2116537457 4213707.846604112, 1907139.5153370681 4213702.058254811, 1907133.3398229345 4213694.421653033, 1907128.0067022222 4213688.3641594, 1907127.8309661958 4213688.160835301, 1907127.026440047 4213687.083903868, 1907126.3992960823 4213685.967147223, 1907123.7319635628 4213681.14304532, 1907105.8345866743 4213638.295717572, 1907100.7844207245 4213627.051647479, 1907084.4580574709 4213591.090532552, 1907083.3182128188 4213589.28761838, 1907081.2954885324 4213587.534134274, 1907051.9231001944 4213565.404606885, 1907034.4135918797 4213549.700826391, 1906997.8233979698 4213520.02820406, 1906975.203145095 4213509.135953623, 1906947.4792254888 4213513.43548389, 1906940.2608364916 4213512.807797022, 1906918.7238446842 4213507.459861927, 1906884.2210108675 4213511.786893463, 1906861.936963438 4213506.938074551, 1906843.6473226463 4213501.925409497, 1906814.582385038 4213493.243515166, 1906810.030027353 4213491.654597787, 1906807.5255370436 4213490.778021265, 1906805.0969353614 4213489.639604502, 1906804.2203415658 4213489.207121556, 1906801.1019327575 4213487.43351447, 1906798.0975688552 4213484.890491116, 1906785.9640550297 4213470.983331524, 1906766.9051177104 4213447.712420168, 1906755.1856915453 4213434.454552088, 1906746.461506358 4213431.655768257, 1906693.1111565894 4213418.042752842, 1906670.8165907094 4213412.333475738, 1906666.2597312287 4213403.755420222, 1906663.4382179915 4213397.082926626, 1906661.307884201 4213393.240239478, 1906652.9856766688 4213381.4399859365, 1906640.8308823463 4213364.078161449, 1906612.0344795224 4213322.4151109215, 1906556.3063393435 4213242.302297963, 1906545.4987141686 4213227.421011712, 1906539.7873021353 4213219.183786477, 1906512.6041781572 4213193.729358424, 1906503.4094699507 4213201.586450498, 1906465.4166247677 4213234.052220592, 1906418.4035441296 4213274.225991734, 1906213.4021571996 4213448.098871333, 1906127.415169976 4213520.844750307, 1906130.48 4213523.59, 1906110.79 4213576.45, 1906104.52 4213615.68, 1906103.31 4213645.68, 1906105.7 4213662.94, 1906100.58 4213687.5, 1906098.52 4213702.52, 1906098.15 4213717.28, 1906095.48 4213730.65, 1906094.58 4213742.01, 1906094.49 4213772.05, 1906091.93 4213790.15, 1906081.43 4213834, 1906067.53 4213886.45, 1906054.69 4213934.56, 1906037.83 4213988.17, 1906025.52 4214027.08, 1906038.2 4214049.09, 1906025.57 4214098.57, 1906057.394178813 4214159.229666536, 1906064.01 4214171.84, 1906062.61 4214182.17, 1906063.3 4214232.29, 1906069.89 4214242.05, 1906081.35 4214302.37, 1906088.14 4214324.61, 1906085.32 4214327.2, 1906085.94 4214334.89, 1906088.33 4214344.05, 1906099.7 4214383.7, 1906103.98 4214393.56, 1906105.34 4214400.29, 1906104.15 4214408.82, 1906105.87 4214428.04, 1906107.92 4214454.96, 1906109.68 4214478.66, 1906112.37 4214491.34, 1906116.56 4214502.9, 1906124.69 4214524.01, 1906134.03 4214548.31, 1906134.98 4214552.44, 1906135.63 4214560.9, 1906134.55 4214571.75, 1906131.29 4214597.34, 1906131.43 4214604.44, 1906133.02 4214623.97, 1906135.17 4214631.13, 1906137.86 4214636.42, 1906142.96 4214644.08, 1906164.74 4214670.33, 1906169.51 4214677.53, 1906180.84 4214708.86, 1906188.52 4214726.29, 1906203.14 4214754.99, 1906222.76 4214781.33, 1906223.25 4214815.42, 1906243.56 4214836.17, 1906240.01 4214869.65, 1906257.23 4214879.12, 1906263.82 4214885.48, 1906272.63 4214897, 1906278.69 4214905.23, 1906284.92 4214925.19, 1906293.16 4214967.43, 1906296.15 4214987.22, 1906297.33 4215008.31, 1906300.01 4215076.25, 1906317.15 4215080.16, 1906340.25 4215112.23, 1906345.18 4215167.73, 1906348.76 4215179.46, 1906350.84 4215196.05, 1906350.25 4215230.02, 1906349.6 4215269.86, 1906349.15 4215303.83, 1906348.58 4215323.44, 1906349.44 4215332.82, 1906351.73 4215339.68, 1906354.08 4215344.21, 1906358.02 4215349.91, 1906363.55 4215356.62, 1906368.11 4215362.6, 1906371.35 4215369.72, 1906374.11 4215376.7, 1906378.25 4215383.63, 1906393.6 4215403.82, 1906401.67 4215423.39, 1906396.99 4215448.13, 1906396.56 4215452.62, 1906397.38 4215457.52, 1906399.08 4215465.17, 1906400.66 4215469.42, 1906404.21 4215473.29, 1906412.97 4215479.86, 1906440.14 4215498.79, 1906444.19 4215517.91, 1906444.96 4215522.34, 1906447.35 4215546.13, 1906418.96 4215574.77, 1906418.650227349 4215579.6066775285, 1906418.08 4215588.51, 1906408.67 4215619.24, 1906412.97 4215633.21, 1906400.95 4215644.06, 1906396.99 4215666.03, 1906397.82 4215668.95, 1906411.76 4215683.68, 1906413.76 4215713.87, 1906416.7 4215725.75, 1906416.04 4215737.48, 1906419.15 4215750.52, 1906418.03 4215764.03, 1906426.08 4215782.47, 1906430.45 4215802.97, 1906433.91 4215830.53, 1906428.75 4215865.69, 1906430.06 4215877.13, 1906434.55 4215901.96, 1906456.21 4215912.66, 1906463.14 4215958.36, 1906467.02 4215978.61, 1906487.07 4216025.88, 1906490.35 4216087.37, 1906492.83 4216094.08, 1906516.87 4216139.81, 1906523.34 4216152.14, 1906529.06 4216165.4, 1906533.81 4216183.1, 1906540.97 4216229.97, 1906550.32 4216297.28, 1906563.65 4216394.53, 1906573.56 4216471.44, 1906574.13 4216489.38, 1906568.59 4216520.35, 1906568.45 4216527.29, 1906574.01 4216582.34, 1906575.29 4216598.4, 1906572.69 4216631.43, 1906573.83 4216641.55, 1906578.17 4216665.62, 1906594 4216712.6, 1906598.78 4216735, 1906606.4 4216787.11, 1906609.32 4216802.05, 1906621.09 4216837.77, 1906626.95 4216878.32, 1906639.99 4216890.54, 1906659.64 4216933.26, 1906668.1 4216965.11, 1906669.06 4216992.54, 1906663.61 4217067.29, 1906659.61 4217120.87, 1906685.81 4217141.36, 1906687.67 4217143.49, 1906693.43 4217155.48, 1906696.49 4217166.48, 1906700.68 4217194.33, 1906700.5 4217211.01, 1906690.88 4217264.02, 1906680.9 4217310.67, 1906659.5 4217352.29, 1906641.59 4217415.33, 1906657.09 4217421.23, 1906654.66 4217442.42, 1906652.72 4217468.5, 1906631.5 4217538.46, 1906632.05 4217544.77, 1906662.7 4217654.86, 1906665.29 4217708.16, 1906700.51 4217769.02, 1906720.29 4217806.19, 1906727.56 4217819.05, 1906760.48 4217859.27, 1906815.27 4217885.96, 1906894.5 4218030.52, 1906930.12 4218098.77, 1906975.05 4218204.04, 1907030.9 4218241.49, 1907032.32 4218243.16, 1907033.11 4218244.85, 1907058.02 4218285.2, 1907083.41 4218326.15, 1907105.39 4218400.14, 1907150.17 4218550.42, 1907179.98 4218646.41, 1907213.4155747811 4218715.471932075))'::geometry,'38111','Claix','CLAIX','CLA','CLX'),
     (4,'SRID=3945;POLYGON ((1916762.4778795398 4229902.470041465, 1916774.482816062 4229876.179404803, 1916776.0064615067 4229872.768172376, 1916792.4531007204 4229835.70822805, 1916792.280512234 4229834.772654256, 1916791.6473190696 4229833.729408509, 1916788.917216622 4229831.6862145495, 1916790.1989739644 4229823.407178352, 1916790.7014498382 4229822.345532694, 1916791.4062500023 4229820.722499998, 1916813.8122398865 4229796.02059232, 1916815.4394862093 4229792.8451886885, 1916816.8855337617 4229790.226747502, 1916820.9770881722 4229774.91700771, 1916821.8102315946 4229774.311795181, 1916824.1646207683 4229773.391347558, 1916833.609409012 4229764.239765553, 1916836.3893238837 4229763.470788491, 1916838.6889428522 4229763.211745394, 1916842.9846529593 4229764.351304834, 1916845.0708323768 4229769.269720243, 1916846.4897494344 4229771.135796582, 1916854.7281143395 4229773.389075673, 1916857.7789857741 4229773.702384788, 1916864.7326931234 4229772.515166448, 1916883.164769486 4229777.080345804, 1916903.080217617 4229782.005566836, 1916912.722953126 4229782.586333533, 1916925.7916503907 4229783.236256102, 1916935.3949215095 4229783.492109645, 1916939.0447113558 4229783.7560204575, 1916955.9943423073 4229786.4439968765, 1916961.6373785 4229787.338607822, 1916978.0684032377 4229789.640277307, 1916981.0648395328 4229790.213520308, 1916990.3325393265 4229791.945542013, 1917027.597272436 4229801.202796075, 1917033.9466340758 4229803.074601541, 1917035.4163464042 4229803.502238008, 1917039.1447376534 4229804.784003712, 1917042.857738465 4229806.052918208, 1917052.72268301 4229809.437379354, 1917064.526646497 4229813.480816425, 1917066.7126864544 4229814.423728092, 1917067.405299667 4229814.730737986, 1917069.129382869 4229815.669243412, 1917102.9279919006 4229834.161315344, 1917114.2484211777 4229840.307947002, 1917116.5062054652 4229841.125199509, 1917118.086011994 4229841.716773268, 1917131.8288574596 4229844.242210251, 1917132.7052900796 4229844.4963676315, 1917141.7034463868 4229848.467902369, 1917158.6932496922 4229856.2956399955, 1917532.9903715507 4229290.571367436, 1917587.318776585 4229209.052732294, 1917629.9562267729 4229154.715939943, 1917629.0663170407 4229154.218735536, 1917629.5592066129 4229153.70393976, 1917598.875652927 4229136.845735338, 1917598.8403867423 4229136.307441596, 1917598.6800854725 4229136.220965285, 1917597.551258029 4229121.623686166, 1917637.0693408393 4229105.176016117, 1917655.9477341135 4229083.865203255, 1917654.9067800662 4229081.782947015, 1917655.1469944238 4229081.481957188, 1917628.0450758555 4229024.945863062, 1917633.2897928443 4229020.739375457, 1917633.4091207818 4229020.643988269, 1917636.0562651586 4229018.524726013, 1917643.9977585024 4229012.169935729, 1917694.9484836145 4228971.028645155, 1917693.405013334 4228969.894868605, 1917693.73 4228969.62, 1917694.9634277858 4228968.635133707, 1917654.4025688663 4228941.705827766, 1917648.5266256544 4228936.949654979, 1917650.026271985 4228927.222521411, 1917652.3824999665 4228921.459999985, 1917660.993070038 4228911.43544132, 1917671.248275329 4228901.246378822, 1917672.0622150623 4228900.299993213, 1917675.3655985969 4228896.039232317, 1917684.3233499436 4228890.057370531, 1917700.9494978015 4228883.650793041, 1917726.4829403833 4228877.139665085, 1917748.268438038 4228874.121089207, 1917798.476031363 4228871.167920413, 1917831.1435476444 4228868.347106309, 1917856.705790627 4228853.514028744, 1917866.9433880642 4228856.67155376, 1917867.0707285586 4228854.964192386, 1917867.9521553281 4228855.207241128, 1917869.4523880882 4228823.282158134, 1917869.4626171973 4228822.807216714, 1917869.6093226683 4228815.813527914, 1917869.6297886826 4228814.800460208, 1917897.07749997 4228816.0562500525, 1917904.024732444 4228802.78902455, 1917937.8943743412 4228737.845319736, 1917889.6934898063 4228674.72613795, 1917859.7879659508 4228638.985447903, 1917860.8184049907 4228623.855102938, 1917845.1772163117 4228619.192877756, 1917791.8812229654 4228602.879081526, 1917788.4231725638 4228601.82319819, 1917782.9479479876 4228600.849225054, 1917760.5304274035 4228610.11292953, 1917760.5024085653 4228609.803467736, 1917759.5465379693 4228610.2116961125, 1917752.3607920846 4228532.902462428, 1917745.6622827875 4228494.7391707925, 1917745.5014392193 4228464.325587068, 1917705.901594716 4228455.437631213, 1917705.9365585153 4228455.301146816, 1917703.7699793286 4228454.823983543, 1917708.9850721697 4228439.884771115, 1917712.1543889157 4228404.235744562, 1917714.3965779808 4228398.559089765, 1917718.549556149 4228390.739104625, 1917725.481511391 4228379.2593725035, 1917731.7308055782 4228369.431900332, 1917761.5220974514 4228344.768282232, 1917768.94099397 4228337.650293047, 1917786.4055150999 4228318.900378021, 1917790.2094042932 4228310.518693511, 1917793.2678269148 4228305.207993178, 1917797.1851670055 4228298.6724640485, 1917797.5673693272 4228298.097708215, 1917798.5321595524 4228296.657355226, 1917799.4398849076 4228295.61860308, 1917800.0061156226 4228294.969856328, 1917802.4756471114 4228292.608611353, 1917803.3840799846 4228291.73109239, 1917804.3380481664 4228290.774353977, 1917806.233684738 4228288.788573169, 1917810.540302294 4228284.247219802, 1917813.223723092 4228281.25954997, 1917817.0056752765 4228276.830669724, 1917819.163912087 4228274.205917104, 1917819.7922863893 4228273.441352852, 1917820.4662593482 4228272.628850067, 1917821.2018866914 4228271.748644343, 1917821.718907005 4228271.1333765, 1917823.1842026492 4228269.373785359, 1917829.3188584317 4228265.233374313, 1917841.9355716456 4228251.247082616, 1917850.6245299168 4228239.62164112, 1917851.570480005 4228238.211834933, 1917856.7968749995 4228227.93625, 1917860.6820971204 4228220.834795147, 1917865.8170808551 4228208.690598409, 1917878.3027849887 4228186.660666875, 1917880.0565171198 4228183.6784227025, 1917879.9828711604 4228182.657208382, 1917880.0099924922 4228180.843091549, 1917878.3703278315 4228178.220178782, 1917876.610640006 4228175.300785891, 1917867.67687501 4228166.283750007, 1917866.5188772092 4228165.085156771, 1917863.9278271117 4228162.486883267, 1917859.6250770662 4228158.025830205, 1917859.550101033 4228156.489240745, 1917859.468451277 4228154.065760133, 1917859.9037756235 4228152.6192156505, 1917868.8659407978 4228141.5792798195, 1917889.2247197723 4228117.512657517, 1917905.1843089429 4228098.815609756, 1917909.9127137307 4228093.272075601, 1917913.9047836475 4228088.5468832115, 1917915.3442971061 4228086.573917632, 1917926.3400636388 4228066.513480586, 1917929.3078467723 4228057.72231766, 1917933.6320098438 4228048.39854463, 1917933.9422123693 4228046.778029662, 1917934.6626067737 4228039.499332926, 1917935.6803588918 4228027.552645928, 1917935.9371850116 4228023.979569407, 1917934.3627073346 4228012.525780859, 1917931.57075945 4227988.889658935, 1917927.7746820736 4227952.625232948, 1917925.7893750137 4227936.7624999955, 1917925.3969503655 4227933.396061435, 1917925.8100000015 4227931.905, 1917935.673124999 4227920.618125, 1917951.3630529377 4227899.453445292, 1917960.5361117793 4227885.514803585, 1917965.6907038637 4227873.361775475, 1917968.1806824792 4227867.270456149, 1917980.0128109297 4227842.872984271, 1917979.9396383606 4227840.072938992, 1917980.0991765545 4227837.078602566, 1917971.9287785043 4227828.285220577, 1917969.1958959415 4227825.190946786, 1917957.2504308268 4227816.296510458, 1917953.7114022884 4227814.239906548, 1917929.0805014947 4227800.006019811, 1917905.075 4227787.060624999, 1917886.9722517668 4227777.928700639, 1917862.525 4227768.434375, 1917777.0877650208 4227734.539721214, 1917739.0503744958 4227719.616766192, 1917740.4960670767 4227684.37179241, 1917742.5521865587 4227648.330067054, 1917743.6470423813 4227610.13125531, 1917743.6468405584 4227596.990301251, 1917743.5093750006 4227577.839375007, 1917730.820103682 4227568.292428782, 1917696.9488329336 4227544.8252761, 1917690.7016924792 4227540.493284775, 1917682.0657892593 4227534.524450763, 1917664.6635336524 4227522.445977725, 1917648.2355399781 4227510.881220491, 1917632.9645289632 4227500.389985611, 1917620.348518198 4227491.974042654, 1917610.4996997924 4227485.664999727, 1917592.3062382129 4227474.518318103, 1917547.4372940876 4227447.662593944, 1917525.9156249992 4227434.3568750005, 1917464.4155160945 4227396.106933824, 1917448.9424394877 4227386.744948518, 1917386.072835699 4227349.189106465, 1917362.7207964675 4227334.983487332, 1917354.2949772503 4227330.071086705, 1917343.2416634269 4227323.473587919, 1917337.5167828156 4227319.83765517, 1917332.0769520917 4227316.238216716, 1917314.3525875176 4227304.109716082, 1917309.606812881 4227300.763247903, 1917308.9969310383 4227300.285872644, 1917304.4786383065 4227296.893543656, 1917298.497721285 4227292.450391981, 1917289.566864144 4227284.485175207, 1917286.4802314364 4227283.271218067, 1917284.4024430467 4227282.152881967, 1917252.1131214807 4227274.494262478, 1917233.0203973514 4227268.657019491, 1917215.8547465834 4227262.277442125, 1917188.0524797211 4227250.3823917005, 1917171.2341019502 4227242.412689541, 1917149.3518750023 4227230.725625006, 1917128.1856250246 4227217.0368750235, 1917102.7064689035 4227197.959327647, 1917092.511509608 4227189.907945603, 1917089.218662535 4227187.320059695, 1917086.4867678494 4227185.0438840855, 1917081.6702925304 4227181.032320816, 1917060.5773798109 4227163.105187254, 1917039.52706012 4227145.30371883, 1917039.5123792116 4227145.291296099, 1917035.9098869597 4227142.24696652, 1917031.8499059852 4227138.777494307, 1917028.913043131 4227136.231268747, 1917024.596166111 4227132.495358774, 1917020.4167120054 4227128.889984152, 1917018.508224243 4227127.237787502, 1917017.609059778 4227126.449406202, 1917015.8378807148 4227124.908236723, 1917014.0599934373 4227123.362519773, 1917012.340227931 4227121.863639387, 1917009.3985562671 4227119.310491108, 1916988.6642764488 4227101.236319005, 1916970.2891723616 4227085.088262147, 1916933.7786166873 4227053.497409551, 1916902.5950213003 4227031.052769182, 1916896.4899536334 4227026.799629135, 1916892.2090670583 4227023.967931287, 1916850.5216597342 4226996.385405681, 1916835.7639429553 4226986.918141919, 1916813.991313572 4226972.978691002, 1916803.4475000042 4226965.962500006, 1916799.7772501193 4226963.526121788, 1916777.4228108965 4226949.021383467, 1916735.0465435323 4226921.549232752, 1916702.8313309716 4226900.765240386, 1916655.9596993222 4226870.091216775, 1916592.5521459559 4226828.757005057, 1916570.4206250014 4226814.48625, 1916522.56875 4226783.543750002, 1916493.29875 4226764.808750002, 1916447.58625 4226735.303125001, 1916381.76375 4226693.1725, 1916350.8784261132 4226673.307823887, 1916292.2002059266 4226635.703078036, 1916240.0052637216 4226603.082029218, 1916219.8669864228 4226594.303036361, 1916203.4678651956 4226588.16215691, 1916187.5205978993 4226583.060584721, 1916186.5761133602 4226582.802360831, 1916172.251707993 4226594.974663453, 1916164.5494910146 4226602.231490927, 1916145.1830807421 4226621.626424412, 1916130.972639793 4226636.523213707, 1916118.2608653824 4226650.881535932, 1916090.1735728728 4226685.584893726, 1916070.2537500022 4226709.313749999, 1916056.702536462 4226722.016314398, 1916027.0093749994 4226748.939999999, 1916000.7446868208 4226772.630575969, 1915969.4740751523 4226800.827637905, 1915957.7724880301 4226811.481053188, 1915949.6500553945 4226818.925441195, 1915946.8360786864 4226821.507078402, 1915940.1300000062 4226828.243333328, 1915939.318207316 4226829.061414115, 1915914.5553978018 4226854.064894454, 1915910.0712500017 4226856.5665625, 1915903.8625702045 4226853.884740212, 1915896.9633511964 4226848.3808967685, 1915889.4310274252 4226841.127982753, 1915871.8322130109 4226821.983174839, 1915843.7618101076 4226790.345188383, 1915820.9668740737 4226764.593219142, 1915812.7601047938 4226755.3860036, 1915806.7385029164 4226749.046828041, 1915802.5068749965 4226745.651874999, 1915797.1676445997 4226742.446275297, 1915797.9486893606 4226807.856307718, 1915798.4398977403 4226840.748552267, 1915798.9610438726 4226869.651743527, 1915800.8369977516 4226928.696854456, 1915801.9675000224 4226938.452499983, 1915771.2712499993 4226990.74875001, 1915780.6521815502 4227004.8762755, 1915781.2121833994 4227009.723795402, 1915780.9864625256 4227019.95092817, 1915780.686308874 4227022.336132032, 1915780.5869749752 4227022.770009923, 1915779.4514401332 4227024.391184625, 1915766.3404580506 4227039.750713271, 1915765.831363226 4227040.787095383, 1915765.3868703952 4227042.246505492, 1915765.2303646244 4227045.356955033, 1915766.211852227 4227047.730662964, 1915768.3608541514 4227052.178146271, 1915770.6109455815 4227056.907247858, 1915772.0838893258 4227060.009809815, 1915773.1016387318 4227064.278874122, 1915773.941986192 4227072.324321856, 1915775.8510281565 4227093.1911271205, 1915776.1394444443 4227095.935740741, 1915776.2419423868 4227096.932267829, 1915776.325938097 4227097.3655254105, 1915776.4047251164 4227097.773822446, 1915777.3841244031 4227101.615980866, 1915779.0075596937 4227107.973282189, 1915781.2513508457 4227115.97918686, 1915783.745825752 4227123.888182406, 1915785.6836510021 4227129.402106473, 1915786.6095399547 4227131.693900598, 1915790.943149824 4227144.808491227, 1915793.6362571071 4227152.611506485, 1915797.4844072682 4227162.346196934, 1915799.7648645544 4227167.884252375, 1915805.3829014762 4227179.126126084, 1915805.8000180337 4227179.959916327, 1915807.0965694967 4227182.55431405, 1915807.885917966 4227184.319819222, 1915809.4822803976 4227187.901993179, 1915816.39148144 4227206.384918799, 1915823.8102101379 4227223.106775364, 1915823.2162905072 4227225.78183705, 1915812.7258268204 4227244.475578613, 1915813.006599197 4227246.159352232, 1915820.1298059854 4227253.627723308, 1915821.3979617297 4227254.907635847, 1915829.5049813502 4227262.661034052, 1915839.0475000115 4227279.208749997, 1915852.375824909 4227301.426356264, 1915857.2780205254 4227309.954822086, 1915859.3014870477 4227314.587465741, 1915858.2721245047 4227319.281220759, 1915854.6856315914 4227332.346207522, 1915855.2046773424 4227336.070952712, 1915861.495979518 4227360.575871576, 1915863.048527211 4227366.619771195, 1915859.851895065 4227375.11427747, 1915860.6672773557 4227384.417399752, 1915860.2338581374 4227385.212048392, 1915859.6902842668 4227386.213672262, 1915859.5366970324 4227386.426984119, 1915858.1945000053 4227388.168353443, 1915857.2857663275 4227389.61488021, 1915856.7281855925 4227391.092078473, 1915857.9742483215 4227398.50099883, 1915857.75 4227400.85, 1915855.4107140594 4227406.406267279, 1915851.8737689138 4227410.67224209, 1915851.7777405719 4227410.802262765, 1915850.0892389661 4227414.3616393795, 1915850.4150000075 4227422.883749999, 1915852.5807788603 4227427.39631173, 1915861.4594003772 4227434.141705609, 1915862.6926386128 4227435.051983011, 1915865.380566005 4227437.554902135, 1915866.4602503928 4227438.828894029, 1915871.6087500255 4227445.212499998, 1915874.0480370985 4227449.41287411, 1915876.157457453 4227455.541075718, 1915876.20916856 4227455.720890916, 1915876.2190465708 4227456.849104597, 1915876.3005496743 4227461.986272686, 1915880.0559562086 4227471.714234025, 1915881.136941443 4227474.970489326, 1915895.668694059 4227472.223738591, 1915912.0167322252 4227477.768282613, 1915919.461817588 4227484.720735012, 1915941.0097480335 4227495.916580924, 1915957.0900000408 4227501.724999998, 1915967.153203132 4227511.499175497, 1915974.98750003 4227532.126250007, 1915982.0962500281 4227546.373750006, 1915989.2512500233 4227557.933749983, 1916000.5711311714 4227594.555039318, 1916002.7313048479 4227597.690639856, 1916003.5513477023 4227598.418462135, 1916007.480037897 4227602.133713714, 1916009.131955414 4227604.466301911, 1916015.433619703 4227613.097380427, 1916029.2950000425 4227622.021250013, 1916033.2810062193 4227627.6366191385, 1916037.3514951572 4227634.678780347, 1916039.291664254 4227637.615460396, 1916041.1322482885 4227642.215081588, 1916043.662076578 4227649.034332993, 1916046.482623574 4227654.707253833, 1916058.9076266477 4227677.013924421, 1916061.420203133 4227680.629053979, 1916063.8894921027 4227683.220907165, 1916065.2444244653 4227684.272038788, 1916070.3282862934 4227686.861591978, 1916081.2207850586 4227696.909325899, 1916093.6068515442 4227707.718369128, 1916097.5297173804 4227710.999385428, 1916101.7595853386 4227723.565025122, 1916102.070980734 4227724.385147061, 1916105.0116435 4227729.740211358, 1916106.5900322762 4227734.208339103, 1916108.087424853 4227738.852294309, 1916136.6854954949 4227761.473243243, 1916138.2031832093 4227762.751571358, 1916138.7910968487 4227767.367505142, 1916138.8518927128 4227767.912451923, 1916138.34250001 4227788.041250008, 1916139.5362500043 4227800.110000009, 1916134.097010272 4227813.367199789, 1916132.6799999974 4227825.898750015, 1916133.0922717333 4227851.617083732, 1916126.5514784162 4227869.391427781, 1916125.0541388988 4227872.069658773, 1916123.4509059829 4227874.553641026, 1916123.1885576865 4227875.82344796, 1916123.284059317 4227877.37247154, 1916123.87 4227880.72, 1916124.2514336046 4227883.370294426, 1916124.7235393145 4227890.205299799, 1916125.0323275102 4227894.5267697545, 1916125.2815852882 4227900.319256714, 1916126.091003413 4227924.067612379, 1916126.2987722731 4227925.399079315, 1916126.6525552266 4227926.916634668, 1916128.3992336905 4227929.935699963, 1916130.0060701333 4227933.239246192, 1916130.4737297813 4227934.290359325, 1916129.5644208295 4227939.669537722, 1916129.5464468068 4227939.757117029, 1916128.6214293442 4227943.931461017, 1916128.5419033733 4227944.935097176, 1916128.6898543867 4227945.574379323, 1916129.2282490109 4227947.905662952, 1916139.7832924682 4227971.1404341245, 1916138.7708477254 4227980.05986222, 1916138.4074306597 4227983.175703471, 1916138.2192976587 4227985.991839468, 1916138.1400545689 4227988.004613947, 1916138.2373643396 4227988.838471658, 1916139.105890166 4227996.28096126, 1916138.9257054788 4228000.863643559, 1916141.4389119432 4228017.823785424, 1916142.3914789723 4228021.81180859, 1916142.9391649798 4228027.019777328, 1916141.2342830473 4228033.81138495, 1916144.3279273822 4228042.169317989, 1916143.9174721355 4228051.701073473, 1916144.7652677305 4228059.422258569, 1916147.262178375 4228069.2988051325, 1916153.5994628784 4228078.547843207, 1916153.8937870471 4228079.029173588, 1916154.5137674918 4228081.6355805015, 1916155.395170584 4228085.3284265185, 1916156.6212177742 4228087.570997933, 1916163.5250200992 4228096.887817296, 1916177.232693855 4228108.585079296, 1916186.7531376684 4228121.076923083, 1916188.3338764322 4228129.063745275, 1916186.4112198583 4228142.308615497, 1916186.6061869739 4228155.219424632, 1916190.1867653516 4228165.45795361, 1916190.575587371 4228178.219366093, 1916191.5941786538 4228179.623938745, 1916193.9120833904 4228183.9680204475, 1916195.2824222737 4228189.565490939, 1916196.4598933903 4228193.207398721, 1916196.9935819316 4228194.870769103, 1916197.5258267429 4228196.843110215, 1916198.8158454779 4228202.2509336, 1916199.3608376742 4228207.120760674, 1916199.8907434796 4228217.79722142, 1916200.8619671396 4228225.589159687, 1916200.9581434277 4228226.772234336, 1916201.681666623 4228231.624994558, 1916203.5555072464 4228239.66099196, 1916203.8376605695 4228240.877368338, 1916204.0857494748 4228242.392612744, 1916203.6704342975 4228255.278827483, 1916203.1826814017 4228260.710817492, 1916203.1158520745 4228262.387519668, 1916203.276450225 4228264.623214974, 1916203.870520883 4228266.866244512, 1916205.7050328443 4228272.3289046325, 1916205.1094388457 4228277.532207279, 1916204.6181459874 4228280.78272228, 1916203.088525427 4228283.395071282, 1916201.5842740496 4228286.134787983, 1916202.9075180467 4228294.251798243, 1916202.3754706678 4228297.179903864, 1916199.832349402 4228300.798388457, 1916199.3253667152 4228302.07954174, 1916200.2771326501 4228308.129815705, 1916200.726556589 4228310.597188342, 1916200.8009238618 4228314.714349919, 1916200.6903933382 4228314.941651991, 1916193.73768726 4228322.54385629, 1916191.376292199 4228338.03237699, 1916191.216189677 4228342.96867394, 1916190.7456012585 4228345.540098993, 1916189.0415494232 4228349.005990161, 1916186.2662249573 4228354.638543775, 1916184.949783614 4228360.330283757, 1916183.1388845574 4228365.733196403, 1916173.4187499871 4228388.543750009, 1916162.0397054974 4228408.705758625, 1916159.6888134766 4228411.605047594, 1916157.060756317 4228414.961079925, 1916155.1317136784 4228419.140450105, 1916154.2506767923 4228424.219081664, 1916155.5118896877 4228430.117843035, 1916156.3178179802 4228436.66327654, 1916156.1865156956 4228437.125405088, 1916152.8707475483 4228445.04935842, 1916145.4611087046 4228451.753818559, 1916140.247588707 4228459.734992937, 1916134.918834235 4228469.905863012, 1916130.5110191368 4228478.037984825, 1916126.5326070117 4228486.144958438, 1916125.0937233188 4228488.792979955, 1916117.566321815 4228501.043789917, 1916111.8413171736 4228510.914901161, 1916109.888576939 4228514.584826837, 1916108.8630881538 4228516.536998319, 1916107.7947686305 4228518.637054175, 1916105.3724320168 4228524.5319763925, 1916099.6891233597 4228531.241657848, 1916100.6883040806 4228547.4110356085, 1916101.7647842327 4228557.086301573, 1916104.4797935039 4228571.813010293, 1916105.283078575 4228577.164297717, 1916102.434867221 4228599.870491029, 1916105.1952977353 4228617.598406642, 1916105.5352782796 4228619.946342727, 1916108.9719215445 4228630.880240938, 1916111.0199960375 4228637.587819487, 1916111.8895289265 4228640.328365002, 1916117.389597102 4228652.21259411, 1916118.3697429544 4228654.279747398, 1916119.0163167766 4228656.252812909, 1916119.1909701808 4228656.940448312, 1916119.9971759964 4228661.0859548915, 1916121.7016933425 4228672.822111898, 1916121.8053962665 4228676.99722443, 1916121.345197982 4228679.619451556, 1916120.9623694145 4228680.1945100585, 1916120.049723872 4228681.597747551, 1916116.9166753958 4228684.209974732, 1916113.3958881672 4228687.218087045, 1916112.994783838 4228689.153676769, 1916111.2437455954 4228697.572674361, 1916111.34888285 4228699.978000689, 1916111.3674033408 4228700.132671191, 1916111.5552923728 4228702.176683649, 1916113.7455916922 4228709.62941949, 1916112.66043956 4228712.9649450565, 1916111.2843373506 4228716.267590359, 1916109.8183951103 4228719.584211068, 1916109.1757142853 4228721.328285716, 1916108.9188200003 4228722.124657999, 1916108.6862758566 4228723.003270735, 1916107.7716939065 4228727.418818728, 1916105.7875418628 4228737.026287422, 1916101.2943835666 4228748.677389966, 1916100.845819017 4228753.110043545, 1916100.5051779165 4228761.359527416, 1916096.7761230485 4228771.977509833, 1916089.4737659523 4228781.369121868, 1916081.4340267594 4228792.163352173, 1916076.1762626106 4228801.988255276, 1916075.7674762825 4228803.014799049, 1916074.6534754797 4228807.199360342, 1916071.600916073 4228819.452983109, 1916067.16446356 4228826.064726728, 1916064.492708714 4228849.626488515, 1916056.70421191 4228861.232303253, 1916051.7854746683 4228876.141328576, 1916048.2302036094 4228883.504250621, 1916045.0033198392 4228888.641199391, 1916039.0398960605 4228897.086718689, 1916038.3873736432 4228900.035338904, 1916038.1945748988 4228906.136821862, 1916035.3035448808 4228914.0311115, 1916034.3949224642 4228916.395111371, 1916030.7347489793 4228923.896177176, 1916020.755039686 4228940.111281174, 1916007.3318196812 4228954.406143269, 1915992.9040332753 4228963.35932999, 1915975.132304808 4228973.198175277, 1915963.8830996628 4228974.853137717, 1915950.9058267577 4228985.379894807, 1915925.4551581817 4228994.610190116, 1915914.745712665 4229000.233889701, 1915901.3566242668 4229011.319951434, 1915880.9549999968 4229026.4624999985, 1915868.983942318 4229034.051973683, 1915864.076423677 4229035.676543325, 1915851.5736842128 4229038.313461533, 1915850.7695720312 4229042.4790174505, 1915850.5913392184 4229043.393778682, 1915851.648393376 4229064.458227066, 1915853.0302133856 4229077.825923022, 1915856.8807818927 4229101.331357322, 1915860.3903567693 4229114.920997975, 1915859.9 4229117.01, 1915865.3028683017 4229143.772236633, 1915870.9630375518 4229171.80897199, 1915874.101602382 4229187.388433423, 1915877.3750919031 4229203.664272243, 1915885.404611975 4229242.478290408, 1915893.3636384127 4229280.907084736, 1915898.0818093515 4229303.687322158, 1915900.870563172 4229317.652734632, 1915902.71 4229326.87, 1915895.48 4229326.79, 1915888.3439701023 4229365.816664632, 1915882.11 4229399.91, 1915851.45 4229434.2, 1915811.89 4229464.34, 1915803.8498886814 4229470.57065032, 1915725.592164711 4229517.420903812, 1915726.1597693735 4229517.862617608, 1915748.4457096169 4229535.205687364, 1915765.9556740033 4229548.832060335, 1915771.1335728937 4229553.287535634, 1915788.5499033309 4229570.140696724, 1915798.7720040828 4229580.332720018, 1915798.486955611 4229580.523381596, 1915797.3192814041 4229581.383805688, 1915577.713749813 4229662.971739152, 1915502.1678340065 4229719.732499972, 1915430.115464345 4229728.6045054225, 1915431.679481936 4229730.687959514, 1915431.3013843973 4229730.742255504, 1915434.5202971203 4229735.773434875, 1915448.3400488445 4229762.232081018, 1915481.756783486 4229840.528384801, 1915491.7684365485 4229850.707807532, 1915499.36 4229855.665, 1915533.4301675928 4229873.903589354, 1915539.3082229968 4229879.076386844, 1915540.68 4229889.29, 1915543.955 4229908.27, 1915546.0100143354 4229950.017387533, 1915539.6754472095 4229985.045013449, 1915522.2865782396 4230025.706731497, 1915527.3365782397 4230065.91694121, 1915535.5379888862 4230101.007582909, 1915540.3855726826 4230163.129007893, 1915538.4263760676 4230232.636384257, 1915536.7267037125 4230265.4509356525, 1915533.4196226946 4230295.167150922, 1915533.7027791736 4230318.019874527, 1915505.3393851975 4230331.800684707, 1915480.5017314968 4230344.692402755, 1915415.762598132 4230420.966871305, 1915388.9472325572 4230449.464222367, 1915375.2139676714 4230679.040132496, 1915401.8642597245 4230902.785502778, 1915362.4160897965 4230933.54261158, 1915365.3496370302 4231015.656370432, 1915385.2853797928 4231059.708884053, 1915390.0945114235 4231056.906623715, 1915392.6670827186 4231063.102510369, 1915500.4084615386 4231005.0271862345, 1915527.2069383187 4231008.394719284, 1915541.725493114 4231010.348173152, 1915550.024965483 4231009.435979454, 1915559.543771862 4231007.70831685, 1915574.9047975708 4230987.898097166, 1915601.5126518218 4230981.617834008, 1915616.0058704456 4230966.62805668, 1915615.5611133603 4230945.643663968, 1915644.0851012145 4230899.700890688, 1915653.7476923077 4230874.1922672065, 1915688.676882591 4230859.573441296, 1915704.9370850201 4230842.956234817, 1915711.743036437 4230825.863421053, 1915706.6222469634 4230791.051133604, 1915711.291619433 4230779.024595141, 1915757.7910323888 4230755.824170041, 1915789.8194331983 4230727.714665991, 1915793.0656781378 4230716.015946356, 1915794.7292165689 4230706.579626741, 1915797.1302593262 4230701.711049785, 1915798.8734866248 4230699.4500322, 1915804.9419626119 4230694.995156133, 1915813.263570126 4230694.712307572, 1915834.675180699 4230698.102413038, 1915839.2327593477 4230698.577272224, 1915856.9119928612 4230686.423376224, 1915871.08645749 4230677.954696357, 1915884.3698700236 4230674.48037622, 1915895.9267493666 4230673.581982635, 1915902.5312340031 4230673.935061614, 1915907.3613139226 4230677.127494119, 1915908.6308909522 4230678.654548101, 1915913.912361308 4230688.122274229, 1915913.2332011694 4230694.858878658, 1915903.6024493927 4230709.3002226725, 1915901.4293522912 4230722.035561717, 1915904.2126586307 4230730.772381972, 1915911.4740554495 4230738.955004117, 1915917.7840491578 4230746.53917674, 1915929.9309547872 4230755.507481558, 1915945.0119396928 4230765.098550075, 1915946.7165471867 4230770.663991329, 1915949.411335384 4230785.624459849, 1915955.2267503655 4230791.430945244, 1915965.4843522268 4230791.210060729, 1915984.882388664 4230777.641963563, 1916003.8254655872 4230773.169817814, 1916024.8632549974 4230771.209613435, 1916038.6295546559 4230760.85277328, 1916058.0507749927 4230738.450434438, 1916074.4575945989 4230723.698688636, 1916080.9225358402 4230714.281413371, 1916086.957327938 4230701.3094391255, 1916109.5102024307 4230678.201577382, 1916114.5525506071 4230673.735040486, 1916128.3463360325 4230665.557914981, 1916148.9956072876 4230662.01228745, 1916164.8416599191 4230662.3723684205, 1916182.4136234818 4230667.963967611, 1916197.438972833 4230679.541306476, 1916210.7443788669 4230703.888603551, 1916225.540826558 4230740.381462399, 1916237.9622279475 4230744.133610046, 1916249.3758704453 4230745.791012146, 1916288.5237449391 4230737.500040486, 1916296.854760607 4230739.85717449, 1916305.096844184 4230755.176107383, 1916306.8906787243 4230758.403169725, 1916308.1335514688 4230786.1773572955, 1916310.7782414895 4230794.080675148, 1916312.7664571737 4230798.983698838, 1916318.5766396758 4230808.138967611, 1916321.5432186234 4230811.227914981, 1916331.65659919 4230813.278380567, 1916355.0803441296 4230808.006578947, 1916368.3583281813 4230809.558330622, 1916407.4190308917 4230811.161490972, 1916431.808117409 4230817.266882592, 1916451.0795546558 4230812.4248178145, 1916483.788319838 4230825.757813766, 1916519.303340081 4230836.952145749, 1916572.6939271255 4230846.785566802, 1916594.7706477735 4230857.347226721, 1916614.9449220817 4230849.970882771, 1916625.5690927096 4230851.102706904, 1916633.2428853647 4230857.848726434, 1916653.6073510533 4230884.967248081, 1916658.21794655 4230888.581576894, 1916667.4425101234 4230889.315283397, 1916699.4815334051 4230878.735050588, 1916725.3399999852 4230883.101249994, 1916748.028398749 4230874.983519307, 1916772.524999985 4230875.873749987, 1916809.0801291068 4230892.7273759665, 1916828.6229257323 4230860.344552721, 1916829.2500868002 4230858.467220149, 1916832.3045762002 4230848.288388954, 1916828.5299999858 4230771.167500009, 1916824.839999994 4230705.785000008, 1916820.7400000123 4230623.2799999975, 1916796.2512500128 4230470.378749941, 1916753.688750015 4230319.572499996, 1916739.9509894378 4230272.590925488, 1916727.870000012 4230239.106249999, 1916719.8087500047 4230187.396249997, 1916714.4612500088 4230125.061250005, 1916711.548750011 4230051.95999999, 1916705.3717755429 4230036.269784351, 1916708.9050355987 4230009.756318075, 1916712.472604181 4230001.6819000505, 1916714.6217956527 4229999.128046162, 1916719.495415239 4229991.916345074, 1916722.3440173848 4229987.396728083, 1916734.8122047314 4229958.21601106, 1916737.91281883 4229945.702748002, 1916741.5174233865 4229938.825333165, 1916760.0030614126 4229907.301311444, 1916762.4778795398 4229902.470041465))'::geometry,'38126','Corenc','CORENC','COR','COR'),
     (37,'SRID=3945;POLYGON ((1913984.0680273932 4221328.28211194, 1913993.223823402 4221326.030384316, 1914003.3978825305 4221323.568541469, 1914005.1069442255 4221323.159492123, 1914006.8012734088 4221322.753130704, 1914010.3040598254 4221321.935631169, 1914014.97688479 4221320.859507163, 1914021.9778593678 4221319.268357977, 1914034.9645656762 4221316.45253898, 1914039.869962696 4221315.414697053, 1914046.3198354456 4221314.100096349, 1914047.4416706997 4221313.872753314, 1914053.9516346515 4221312.573081527, 1914061.5691632284 4221311.07368043, 1914081.7654169865 4221307.313754505, 1914102.4353310743 4221303.516958192, 1914109.4219565853 4221302.250371573, 1914116.3632103545 4221300.97094171, 1914145.1140802072 4221295.8908694815, 1914159.2567331041 4221294.121142971, 1914189.1551213001 4221290.489896887, 1914191.3039503759 4221290.233378849, 1914196.1229593991 4221289.7378831655, 1914211.9517182114 4221288.102068924, 1914240.2315832588 4221285.028207744, 1914261.355921799 4221282.9068279965, 1914273.4801113259 4221281.918331988, 1914290.6480943104 4221280.604953973, 1914297.204274018 4221280.251698368, 1914304.0460778081 4221279.957686635, 1914316.4571712795 4221279.43259341, 1914332.2163857212 4221278.955478464, 1914351.8650574419 4221278.362543219, 1914360.0767239274 4221278.229436082, 1914360.8476445898 4221278.217314274, 1914361.5752524927 4221278.204203391, 1914365.9903752184 4221278.172522057, 1914381.6670637897 4221278.05452334, 1914382.592835842 4221278.064876, 1914383.2613889305 4221278.072013977, 1914392.7943505822 4221278.339861315, 1914392.800527538 4221278.340034031, 1914407.854416677 4221278.764386699, 1914417.1859299168 4221279.028967691, 1914434.3409661981 4221279.483799042, 1914444.5564362265 4221279.753757858, 1914453.7383580978 4221279.995491359, 1914459.228316819 4221280.149807874, 1914468.1314276902 4221280.4053394, 1914468.1362043028 4221280.405476657, 1914487.9384939424 4221280.975058466, 1914500.5469760061 4221281.775370041, 1914506.4938677787 4221282.152439972, 1914522.0091189286 4221283.139872383, 1914524.5650812816 4221283.309003985, 1914529.0747465577 4221283.654349725, 1914539.319048988 4221284.441391705, 1914542.3769663554 4221284.709301479, 1914550.6166541858 4221285.412735534, 1914552.0982352851 4221285.552352941, 1914554.3085056446 4221285.760132571, 1914566.1781391185 4221286.997106636, 1914587.123170154 4221289.172041165, 1914603.1749729577 4221290.702956377, 1914609.991848764 4221291.397610755, 1914609.995963486 4221291.398032776, 1914613.9520387638 4221291.800632302, 1914632.5858443417 4221293.720818936, 1914635.8482297189 4221241.244670937, 1914636.1872309723 4221235.817626741, 1914636.5356732025 4221229.621867865, 1914636.5358037811 4221229.619502481, 1914636.550167615 4221229.361224543, 1914636.8193390442 4221224.525928016, 1914637.0073072892 4221221.496001632, 1914637.2447684098 4221217.673093499, 1914637.2811038983 4221217.090755197, 1914638.2564708379 4221201.4560325295, 1914643.6570564057 4221114.960991749, 1914644.2194028897 4221108.594289243, 1914644.7790505188 4221108.531216748, 1914644.7901812478 4221108.440247086, 1914728.254021623 4221099.002781405, 1914731.1599639289 4221098.610793245, 1914733.8689976805 4221098.512277122, 1914733.8985380954 4221098.045987278, 1914734.0666208386 4221095.392833092, 1914734.2230141007 4221092.587151967, 1914734.436865696 4221089.111824449, 1914734.8187809538 4221083.2894062875, 1914735.0510714601 4221079.744125474, 1914735.308494561 4221075.788715223, 1914736.1732334625 4221062.515092422, 1914736.681589743 4221053.901384627, 1914737.5482425147 4221039.261238276, 1914737.8491042845 4221034.547838833, 1914742.250412395 4220965.462541844, 1914743.6800685558 4220943.030443555, 1914751.4212048645 4220821.58539606, 1914751.4770127996 4220821.588439297, 1914752.1979986483 4220809.867736098, 1914753.1197798406 4220794.811938449, 1914753.2974472838 4220791.81866063, 1914753.7406809023 4220784.8954204945, 1914753.7416049398 4220784.881132251, 1914760.0865529985 4220687.120969549, 1914764.7840026794 4220615.380538516, 1914764.874587302 4220613.463303708, 1914764.9086754583 4220612.81711738, 1914764.9652247934 4220611.561550355, 1914765.00085652 4220610.838444351, 1914765.0141052564 4220610.547818532, 1914765.030323141 4220610.213769763, 1914765.037022133 4220610.073851106, 1914765.044114003 4220609.925278912, 1914765.4433168743 4220601.500061522, 1914783.8037183264 4220564.208407547, 1914788.8580273888 4220554.016177509, 1914790.4535427855 4220550.806437045, 1914792.3839020166 4220546.921393195, 1914808.720660363 4220514.373749241, 1914843.3389523148 4220446.112111835, 1914847.6319227763 4220437.678591414, 1914849.9838329183 4220433.081665404, 1914850.66 4220431.44, 1914857.4041896898 4220418.588586863, 1914867.3665725798 4220400.223746197, 1914872.2495942926 4220392.236113837, 1914879.007222952 4220381.618237607, 1914886.3661476625 4220370.414766613, 1914893.798950512 4220360.553566553, 1914900.4070095224 4220351.851093401, 1914900.9871787583 4220351.090704962, 1914902.9552057888 4220348.303463498, 1914907.1930499983 4220342.265089646, 1914912.3813814558 4220334.84687172, 1914915.674735884 4220330.169780244, 1914918.5026686168 4220326.183724347, 1914935.4788849188 4220300.550840883, 1914942.9385805305 4220288.385548137, 1914946.9174709518 4220281.893281863, 1914948.3726185022 4220279.490469832, 1914951.529286848 4220274.133964609, 1914953.0249193043 4220271.588452846, 1914954.041781528 4220269.848963729, 1914957.213518276 4220264.398130305, 1914959.1719178509 4220261.034932118, 1914960.5240226744 4220258.72419707, 1914960.5283369594 4220258.716826003, 1914963.2936917602 4220253.992568124, 1914963.4718912197 4220253.689476794, 1914964.168014003 4220252.4917633375, 1914964.5846746352 4220251.760328235, 1914964.6550245737 4220251.631713068, 1914966.924225381 4220247.455094791, 1914975.228949028 4220231.792428005, 1914979.9166674106 4220222.74441499, 1914980.0289992872 4220222.526337964, 1914980.1392587468 4220222.303577246, 1914980.2956046404 4220221.987407664, 1914980.6881788522 4220221.195042558, 1914981.0294907335 4220220.497020893, 1914981.2042802277 4220220.13111325, 1914981.9372745508 4220218.601053401, 1914985.9288565312 4220210.278809397, 1914988.6847409355 4220204.753899575, 1914990.8361293306 4220200.454621511, 1914992.632786994 4220196.784306569, 1914992.6332415887 4220196.783368459, 1914994.5889683184 4220192.747001521, 1914995.589863655 4220190.7158119595, 1915001.7536918437 4220178.407503901, 1915003.0228121455 4220175.97723055, 1915006.4917235493 4220169.462406144, 1915011.0158603685 4220161.325716231, 1915014.516239752 4220155.377619991, 1915021.7905604336 4220143.628063168, 1915029.939376561 4220131.100538227, 1915045.0022610922 4220109.302209898, 1915046.7859178954 4220106.751861563, 1915066.5095485928 4220079.985466948, 1915069.0892338974 4220076.518690171, 1915073.0961814276 4220071.224623644, 1915080.9452823661 4220061.039454574, 1915083.8953544158 4220057.214028235, 1915085.7586754784 4220054.738358186, 1915094.7203317806 4220042.737345161, 1915101.0818189036 4220034.147501021, 1915103.7895936226 4220030.474972709, 1915130.8474629843 4219993.489698068, 1915172.7456324808 4219935.88820406, 1915175.7657268057 4219931.726358804, 1915179.7612999885 4219926.069753522, 1915186.2732062077 4219916.691992661, 1915198.5631798066 4219898.810936686, 1915221.138936355 4219865.727725178, 1915257.2182649695 4219813.263551235, 1915260.7976787356 4219808.16185862, 1915264.3244182705 4219803.40320406, 1915299.4222536685 4219758.205083897, 1915312.4008778906 4219741.40147326, 1915329.5660403236 4219718.733477135, 1915333.7187305405 4219712.90158965, 1915355.8865651558 4219680.990274546, 1915369.447109488 4219661.15659859, 1915376.4966705074 4219650.984778259, 1915388.2507718117 4219634.345765234, 1915398.9418164815 4219620.103428953, 1915398.1275214 4219619.720957021, 1915397.5004345654 4219619.426416235, 1915395.9347994737 4219618.620436222, 1915390.0557757155 4219615.580017648, 1915382.4048955825 4219611.629595196, 1915370.9981523075 4219605.853315649, 1915355.3993322926 4219598.536985043, 1915352.381859117 4219597.117211213, 1915336.6878095665 4219589.916261781, 1915325.1423682799 4219584.661343208, 1915304.4804840123 4219575.518865458, 1915274.7848220733 4219562.89993174, 1915240.3043773235 4219548.495973338, 1915167.3892450945 4219518.728655329, 1915145.6397444743 4219509.84839423, 1915117.0397576694 4219498.360932041, 1915102.3948803418 4219493.165424576, 1915087.7585911173 4219488.063678286, 1915071.3451294797 4219482.471377306, 1915047.4911654152 4219474.590072749, 1915045.1645910232 4219473.825759839, 1915041.7966567292 4219472.737101829, 1915039.4248987534 4219471.971979745, 1915038.6124311024 4219471.709506957, 1915037.5782902238 4219471.375595528, 1915036.3559179304 4219470.981545275, 1915035.97275392 4219470.86015106, 1915019.5384955707 4219465.686039757, 1915011.0162159558 4219463.02517824, 1915002.5841696325 4219460.5360304685, 1914993.8708083373 4219458.222824002, 1914975.9656285555 4219453.728364558, 1914973.6741004726 4219453.362540693, 1914973.7477142161 4219452.860662004, 1914973.4772017237 4219452.794683347, 1914975.420134795 4219438.784148721, 1914977.2481233387 4219426.699923359, 1914981.646488809 4219397.697023347, 1914981.9799048658 4219395.294855798, 1914982.4120829904 4219392.19592211, 1914983.1197948144 4219386.558616709, 1914983.5117988617 4219383.454313327, 1914986.138419875 4219362.625348794, 1914986.7210407315 4219358.958280918, 1914989.5626275565 4219341.661123993, 1914993.2124746244 4219332.548981973, 1914996.3580169084 4219326.677048512, 1914997.6843190417 4219325.118252538, 1915000.471696662 4219323.108142416, 1915001.5057008315 4219322.613928287, 1915002.455346172 4219322.149906452, 1915004.2337182327 4219321.581388368, 1915005.0740679041 4219321.32364539, 1915018.5805270704 4219319.429595397, 1915028.2606960945 4219318.336494057, 1915053.765520452 4219315.423840723, 1915063.704092948 4219313.921866906, 1915073.701931744 4219311.359756844, 1915093.0834743143 4219304.938274504, 1915117.2073642174 4219295.363807322, 1915146.2067768362 4219285.916424299, 1915173.9258658295 4219277.219394784, 1915179.0305561116 4219275.45954995, 1915184.4479893895 4219273.228464593, 1915188.4364725454 4219270.619154114, 1915193.7899301958 4219266.188247821, 1915198.872998385 4219261.078914169, 1915201.3575614034 4219258.488351586, 1915204.7048094855 4219254.782935987, 1915210.4154495846 4219248.376161468, 1915220.7778985759 4219237.114163697, 1915226.5252058434 4219230.964385898, 1915232.3405798369 4219224.806555654, 1915243.1812014296 4219213.338718649, 1915254.3188436327 4219202.365111275, 1915255.288388522 4219201.488740825, 1915259.264160215 4219198.102338175, 1915260.1408386268 4219197.355248996, 1915270.7760665414 4219188.478920773, 1915275.9701077489 4219184.255192871, 1915284.2869112627 4219177.677696246, 1915291.8517295027 4219171.7637387505, 1915296.9159568064 4219167.955563113, 1915308.6677683496 4219159.181430629, 1915319.027900483 4219151.945218571, 1915323.489792054 4219148.876297111, 1915327.8531279955 4219145.345102543, 1915342.5844083861 4219130.654658136, 1915361.0416499423 4219109.689762958, 1915364.3739215846 4219105.33634125, 1915365.1805814805 4219104.288666817, 1915365.8927801584 4219103.301672159, 1915369.339451825 4219098.310336384, 1915370.470672441 4219096.538276417, 1915376.5435156773 4219087.20697281, 1915380.0516123828 4219082.350144609, 1915383.791994832 4219077.500200642, 1915388.901752857 4219071.229167203, 1915393.7679056947 4219065.255631596, 1915399.57719002 4219057.938446211, 1915402.8163402549 4219053.517403189, 1915406.1124999989 4219048.865000001, 1915406.3420714133 4219048.541253726, 1915408.7151487814 4219044.969834526, 1915412.640984454 4219038.225596251, 1915415.4746243544 4219033.397352065, 1915419.3806800311 4219026.4468406355, 1915424.8778532287 4219013.425699896, 1915426.1723613478 4219010.358216723, 1915426.4003511607 4219009.888499221, 1915426.817990115 4219008.993515903, 1915426.9787429457 4219008.80198755, 1915427.341289676 4219008.3688152265, 1915435.2958736024 4219001.416394055, 1915439.949414853 4218997.264037235, 1915446.8458067074 4218990.549464552, 1915459.0084212418 4218977.000111229, 1915460.3368418098 4218975.4491312355, 1915463.884379011 4218971.298523002, 1915469.5216021428 4218964.102822709, 1915473.7802408645 4218958.471376018, 1915475.5711121596 4218956.117531635, 1915480.8743521788 4218949.091399365, 1915482.9974015998 4218946.117973532, 1915486.9480560147 4218940.565734003, 1915491.8334927817 4218933.293201371, 1915493.7400152136 4218930.12944726, 1915497.0757430939 4218924.614862451, 1915500.6735845369 4218917.892122769, 1915506.226317757 4218907.831458994, 1915508.3064179388 4218904.007510187, 1915517.0544696478 4218888.805587915, 1915518.91 4218886.33, 1915482.6949044839 4218910.446667776, 1915472.1745243217 4218915.94737767, 1915419.8098757507 4218928.615652815, 1915378.9191071985 4218938.435763515, 1915359.3008387836 4218941.710848349, 1915345.7994198892 4218940.203727804, 1915337.9842854217 4218938.5751955435, 1915316.6643783734 4218933.648653001, 1915309.4141209982 4218932.216768608, 1915301.079554983 4218931.54944725, 1915299.0499023711 4218932.623700322, 1915294.1950352087 4218934.483424072, 1915272.0988182593 4218946.701348122, 1915259.741289846 4218952.055151837, 1915230.3247672305 4218961.012560888, 1915205.3335803892 4218969.384525721, 1915193.6120776148 4218973.523798872, 1915188.52996674 4218975.021028845, 1915183.4621144412 4218975.982036049, 1915183.0158869915 4218975.987641205, 1915174.9219796192 4218975.351412301, 1915172.2153882075 4218975.084894068, 1915161.0923695576 4218973.927766453, 1915157.5533611972 4218973.674339414, 1915147.910960968 4218973.603659057, 1915128.8776273772 4218974.173935748, 1915111.2165823977 4218975.138431445, 1915109.7695348081 4218975.6952735325, 1915109.6174314413 4218975.708795168, 1915093.4503632928 4218981.975095701, 1915082.9231929656 4218986.054128049, 1915081.6718871703 4218986.507601252, 1915040.2591904749 4219001.620445759, 1915018.2583788394 4219010.0632593855, 1915008.1237475292 4219012.828361235, 1914998.8262160881 4219014.612542211, 1914991.0425760965 4219015.521372975, 1914985.923426019 4219014.656298063, 1914963.0909271594 4219009.339206564, 1914956.476119396 4219008.468977708, 1914935.5509701876 4219007.246582803, 1914904.3827704694 4219018.520816817, 1914899.7026305925 4219020.423560357, 1914872.1634600328 4219028.017061257, 1914855.1949357428 4219033.496514933, 1914847.5659173708 4219036.702398422, 1914841.8862606012 4219040.4152378235, 1914837.0781147259 4219044.019026092, 1914835.921491757 4219045.260807052, 1914832.964752288 4219051.932259324, 1914827.8324594032 4219069.354930854, 1914795.670989761 4219066.471040956, 1914785.0955991717 4219067.58990404, 1914780.80632224 4219068.949635996, 1914777.8053201085 4219071.724899498, 1914774.6152425967 4219077.5406368, 1914772.776071052 4219082.567040602, 1914767.0497519986 4219112.809200112, 1914764.8867097716 4219116.441650701, 1914761.2495343974 4219121.402272174, 1914755.0277696487 4219125.328816856, 1914749.5636730054 4219127.096183395, 1914741.6935390376 4219127.595122027, 1914737.422801782 4219127.348773494, 1914731.3404465667 4219124.732749746, 1914721.7609489057 4219118.36984201, 1914721.346618047 4219118.044135782, 1914718.2752176803 4219115.654465508, 1914693.8016594213 4219095.196028563, 1914690.615635384 4219093.5610722955, 1914683.814485989 4219090.942353424, 1914685.0288313946 4219076.227971824, 1914685.6067979478 4219067.01672197, 1914682.153993333 4219041.453873612, 1914675.3853635455 4219005.569646401, 1914671.2618930761 4218983.557781155, 1914667.0396457487 4218944.88714201, 1914663.7630703445 4218907.3734260425, 1914663.7267727158 4218906.949974505, 1914663.6915518388 4218906.346587349, 1914657.5494297785 4218905.18058088, 1914655.8080373365 4218904.579122225, 1914651.9612626496 4218904.234658386, 1914581.865629308 4218891.2021820145, 1914582.8757432543 4218903.774571941, 1914573.6121053388 4218896.219047543, 1914571.9217831898 4218894.019098231, 1914556.60486949 4218864.016723682, 1914555.8531497174 4218862.967956921, 1914555.283725594 4218862.207509177, 1914541.922385221 4218849.872967164, 1914515.6517352122 4218825.582189025, 1914505.1845795559 4218812.899078422, 1914486.6635711582 4218790.622856891, 1914486.1628083005 4218791.228018594, 1914486.0361789577 4218791.083752741, 1914482.693881166 4218795.420146309, 1914451.463404805 4218836.0128432885, 1914438.8165578078 4218824.887954759, 1914372.9050157617 4218766.512333753, 1914362.3442605562 4218757.0012328, 1914349.39179606 4218764.027656379, 1914330.3714081203 4218771.350535525, 1914321.5353998404 4218773.3982247375, 1914317.7681544418 4218773.581781807, 1914316.0508124921 4218773.671420474, 1914306.4572549283 4218772.590249105, 1914304.3147178327 4218772.259029699, 1914302.5792447205 4218771.681544957, 1914297.4972463027 4218769.895263013, 1914288.575989761 4218763.730324231, 1914271.8078043847 4218752.140636444, 1914269.0300312103 4218750.229414394, 1914268.072714084 4218749.670276087, 1914264.1165784982 4218747.3473122865, 1914257.720143005 4218745.8172614155, 1914212.1535494882 4218739.781365188, 1914205.881979522 4218738.539931741, 1914198.9956313823 4218736.747584136, 1914198.118870415 4218736.516423866, 1914197.1470708258 4218736.050819004, 1914196.4298805206 4218735.624061136, 1914191.1137372013 4218731.981774744, 1914178.4473901535 4218721.693748506, 1914174.5066076138 4218717.711561357, 1914159.7924451667 4218696.249446105, 1914154.8759888872 4218690.725301466, 1914153.690885188 4218689.436007486, 1914151.4578775049 4218687.625135463, 1914146.9507985145 4218684.055144509, 1914143.4672879798 4218681.302417883, 1914136.2879092859 4218675.892909557, 1914115.201923366 4218659.95670728, 1914101.1702324823 4218649.407903368, 1914079.989707469 4218633.876744077, 1914068.6182616018 4218624.666168677, 1914050.002356832 4218609.482110005, 1914045.6300662535 4218606.498822255, 1914044.4364475766 4218605.856303853, 1914038.5813001199 4218602.61613125, 1914038.960277948 4218601.5760793155, 1914038.2073375762 4218600.987574197, 1914049.5694890956 4218570.470300668, 1914053.3086129862 4218557.69673558, 1914053.8477556547 4218555.858177604, 1914058.8062072836 4218539.040253803, 1914065.452465782 4218517.009269543, 1914072.2090675146 4218497.733530658, 1914076.9664562028 4218484.1499305265, 1914079.0566439729 4218478.230567769, 1914083.7969677476 4218464.911759095, 1914084.8919666947 4218460.79644711, 1914085.7943911606 4218457.524289835, 1914092.5584634545 4218437.0816487875, 1914097.6734919574 4218421.444932431, 1914097.9328763797 4218420.640263408, 1914099.0702860076 4218417.122577613, 1914099.6268284926 4218415.288050623, 1914101.4983700982 4218409.162488612, 1914101.7000919404 4218408.212953577, 1914104.3652138545 4218395.963949652, 1914108.8747405836 4218362.64024876, 1914115.070415765 4218341.666679605, 1914133.212105531 4218274.077913096, 1914134.483060902 4218267.708633535, 1914139.5984339144 4218243.87523959, 1914152.2868368705 4218162.501200233, 1914154.864335188 4218149.735188739, 1914159.1977593459 4218139.306473907, 1914159.6473440493 4218138.298663958, 1914161.0876083411 4218134.5047522355, 1914163.1335174493 4218128.845148327, 1914163.4579775285 4218127.975056179, 1914163.6170882254 4218127.547947357, 1914163.8009999997 4218127.117500001, 1914165.8781222028 4218122.18885605, 1914167.392735528 4218119.055073388, 1914178.8891045055 4218096.826702881, 1914186.8763965277 4218081.506437113, 1914191.6240829926 4218072.121012373, 1914198.9951283154 4218058.720576496, 1914202.5774321794 4218052.2394902, 1914206.5060402283 4218045.503836763, 1914207.4159358656 4218044.15808255, 1914207.4995191304 4218044.033935862, 1914211.3805871995 4218038.685864699, 1914215.8361871962 4218033.402491389, 1914218.8524778779 4218030.123910751, 1914223.1702789145 4218025.594389819, 1914223.0991623488 4218025.504352331, 1914223.1408180383 4218025.460885525, 1914222.4648758366 4218024.6813883, 1914222.2724259908 4218024.457658594, 1914222.0351498704 4218024.180159311, 1914218.6783020427 4218019.624324742, 1914216.777441432 4218017.043132259, 1914216.757621644 4218017.016234659, 1914214.0256900175 4218013.307636549, 1914210.9250631793 4218009.081101583, 1914203.9747563058 4217999.597215015, 1914196.8155952971 4217989.814428117, 1914189.6208123663 4217979.955211528, 1914144.5428485875 4217918.183589982, 1914121.1448928956 4217886.120702868, 1914120.1071174874 4217884.698609571, 1914118.6302993582 4217882.68076722, 1914115.894077139 4217878.954585957, 1914110.8495072557 4217872.084902023, 1914103.12161834 4217861.561080308, 1914103.1102872798 4217861.545649644, 1914101.52 4217859.38, 1914100.16 4217857.73, 1914099.9970756266 4217857.500537555, 1914097.5114332545 4217853.999715106, 1914097.4746396637 4217853.94781998, 1914097.3953517836 4217853.83621312, 1914097.2954039813 4217853.6949673835, 1914097.2152431111 4217853.580944776, 1914097.2136436382 4217853.578669342, 1914096.5915818606 4217852.6941195205, 1914096.2999962799 4217852.267352174, 1914094.0976806837 4217849.053067604, 1914088.7757638576 4217852.858481353, 1914042.0686013561 4217889.062947609, 1914025.55 4217903.05, 1913987.31 4217937.44, 1913976.0533543287 4217946.27659001, 1913969.1603799015 4217951.687650351, 1913969.0922450507 4217951.741136947, 1913969.0468587491 4217951.77676569, 1913969.0317481773 4217951.78862766, 1913969.0302194017 4217951.789827757, 1913969.029843549 4217951.7901205495, 1913969.0292432953 4217951.790582914, 1913969.0177673995 4217951.799423857, 1913968.7500036352 4217952.005692906, 1913967.9319498711 4217952.635874785, 1913967.4656334224 4217952.995098236, 1913950.50620223 4217966.059670766, 1913939.6023994458 4217974.190659326, 1913929.793491904 4217981.50166947, 1913924.0365927322 4217985.792686759, 1913923.6221498328 4217986.119490547, 1913915.8981800175 4217992.210130777, 1913875.4770747249 4218024.083690089, 1913873.4696200974 4218025.666643442, 1913871.233106403 4218027.5434833085, 1913868.9859155908 4218029.430810666, 1913867.8579253757 4218030.378165372, 1913861.8928888442 4218035.386795602, 1913855.5548078036 4218040.580077276, 1913830.78 4218060.88, 1913817.3470040485 4218072.532995951, 1913795.0523923116 4218092.889033531, 1913776.88 4218109.76, 1913757.6467934423 4218129.922163799, 1913749.3351493664 4218138.754681496, 1913741.758103211 4218146.822424383, 1913717.06 4218173.12, 1913704.270461549 4218189.682263657, 1913703.5 4218190.68, 1913703.4880836753 4218190.696447613, 1913703.337832906 4218190.903832574, 1913702.3222707934 4218192.305571219, 1913700.0618841907 4218195.4254899435, 1913697.244167873 4218199.314667968, 1913695.3392582485 4218201.943936431, 1913692.6715998824 4218205.625904117, 1913691.14 4218207.74, 1913690.007831707 4218209.3548713075, 1913671.18 4218236.21, 1913663.940977783 4218246.972381427, 1913638.43 4218284.9, 1913635.0555584873 4218290.313048042, 1913616.086162071 4218320.742455025, 1913614.8975159612 4218322.6491997335, 1913603.89 4218339.8, 1913603.7950126713 4218339.934149711, 1913603.743860656 4218340.006445099, 1913564.5915033699 4218395.161097268, 1913549.1894825124 4218417.108135109, 1913532.96 4218440.39, 1913530.8687493356 4218443.499442048, 1913506.28 4218480.06, 1913495.2952927926 4218495.778289385, 1913479.57 4218518.28, 1913459.56 4218553.28, 1913458.12 4218582.47, 1913451.5126606675 4218579.046550876, 1913443.158564694 4218573.82905983, 1913438.5186658239 4218575.706878011, 1913437.6664717982 4218576.166069544, 1913429.299903045 4218581.6054385705, 1913393.8607993904 4218605.174533324, 1913306.9836157507 4218662.434526626, 1913298.9515929054 4218667.485762753, 1913283.9369530855 4218676.935951629, 1913281.3145405916 4218679.067022248, 1913279.692744683 4218680.428890049, 1913252.0413743611 4218698.567659996, 1913247.4259462396 4218701.784970778, 1913203.197768622 4218730.811065525, 1913167.6546108385 4218754.108561515, 1913160.471389343 4218758.839159534, 1913159.0244203527 4218759.790987256, 1913158.1888991483 4218760.335125571, 1913121.7996143063 4218784.190788457, 1913118.6666643166 4218786.227426167, 1913094.9353283208 4218801.673845829, 1913090.1351404905 4218804.792473888, 1913090.1305830556 4218804.795435635, 1913090.1264725341 4218804.7981069, 1913084.9989273371 4218808.129798491, 1913080.9707433996 4218810.777830482, 1913080.455178935 4218811.116580295, 1913080.425950632 4218811.135797775, 1913080.4214272446 4218811.13877351, 1913080.417090356 4218811.141627545, 1913062.6624636466 4218822.816854066, 1912985.4250025037 4218873.62177226, 1912824.2153878198 4218980.182086806, 1912623.921892895 4219112.947377671, 1912615.6128023681 4219116.515178329, 1912603.532532488 4219124.526493633, 1912594.1084472064 4219130.752714848, 1912594.108272252 4219130.7528303405, 1912591.5805974107 4219132.423233438, 1912563.0760029457 4219151.262065539, 1912556.0430188419 4219155.9284981415, 1912529.9225387014 4219172.918623519, 1912451.4233719134 4219194.554312581, 1912413.7854744708 4219204.882981935, 1912355.887725512 4219220.863935461, 1912252.5306702692 4219249.449140599, 1912251.0468916919 4219249.79535534, 1912188.280562051 4219267.349575766, 1912144.619955253 4219274.863392472, 1912139.0767609088 4219275.810035067, 1912137.756790657 4219276.033366029, 1912113.2545178828 4219280.183753094, 1912087.235957229 4219284.555397728, 1912040.755866832 4219293.211778818, 1912004.9900477177 4219299.828494582, 1911996.9699747693 4219301.28723214, 1911996.8915974214 4219301.301491233, 1911995.8892469509 4219301.483819799, 1911823.0554725735 4219332.926197204, 1911795.0353996917 4219337.903113969, 1911789.7080175108 4219338.843792303, 1911788.9714784825 4219338.973640843, 1911786.7820464906 4219339.360727152, 1911777.259125328 4219341.055983714, 1911766.9540957897 4219342.919045152, 1911764.4003913635 4219343.342707669, 1911761.7196632647 4219343.780741958, 1911757.0994348307 4219344.517707631, 1911744.8336348685 4219346.747823887, 1911717.3275234783 4219351.603450523, 1911717.1692937596 4219351.631034339, 1911709.8058179661 4219352.918471264, 1911707.1685800648 4219353.311991448, 1911700.6014308566 4219354.313260542, 1911671.6935572259 4219359.21971034, 1911667.7140018523 4219359.840715794, 1911663.3108112896 4219360.544492418, 1911649.6528611323 4219362.857835051, 1911633.2811384478 4219365.629571475, 1911575.1116275322 4219375.51560123, 1911569.026724763 4219376.662096937, 1911557.228241163 4219378.67419238, 1911444.4867235068 4219397.778849662, 1911424.2548890787 4219400.584317406, 1911430.131180815 4219439.133631116, 1911431.388905033 4219446.928261542, 1911432.8935716276 4219456.255198211, 1911433.67014332 4219461.005010861, 1911434.4101972443 4219465.129830553, 1911435.5313314188 4219471.507995585, 1911436.2223367277 4219475.146319977, 1911436.5158763267 4219476.628420633, 1911438.2433704454 4219484.611518219, 1911440.5835145258 4219494.769266352, 1911442.6828082143 4219503.089965687, 1911442.7190398653 4219503.224439099, 1911443.4559839899 4219505.948006858, 1911444.1195097994 4219508.407280797, 1911445.0291549398 4219511.452877122, 1911449.1471978708 4219524.717008567, 1911450.3236568265 4219528.652657947, 1911451.391843207 4219532.289074078, 1911452.0883252244 4219534.555233788, 1911456.5525183144 4219547.621301195, 1911456.9579117158 4219547.83411166, 1911457.001525177 4219547.8594690915, 1911457.807703389 4219548.281319279, 1911458.3831779119 4219548.582354173, 1911458.4075329849 4219548.5950958645, 1911458.4116525059 4219548.597251211, 1911458.4125245858 4219548.597707826, 1911458.4282316102 4219548.605929264, 1911487.7722848614 4219563.970355771, 1911512.7845374742 4219577.024737963, 1911523.3126809995 4219618.240620901, 1911537.508378222 4219674.142812743, 1911549.9441030882 4219721.685471948, 1911554.1920918582 4219737.71479364, 1911558.7080503094 4219755.081853738, 1911558.7994721655 4219755.433689912, 1911560.5138038131 4219762.023900786, 1911563.5782922495 4219773.649389502, 1911566.1594103994 4219783.413873626, 1911567.10591653 4219787.023556811, 1911567.2122770322 4219787.5114316745, 1911569.6690985865 4219803.260398372, 1911574.8801283557 4219836.919965507, 1911575.5623153832 4219841.237937092, 1911575.8798016757 4219843.24232588, 1911580.1455426118 4219869.193640118, 1911582.2578112138 4219882.0638031345, 1911588.9614236788 4219922.959839732, 1911591.6775833522 4219939.625556588, 1911591.8682339957 4219940.6022276115, 1911592.7911769385 4219944.78771431, 1911594.1463259486 4219950.928587954, 1911596.7234253208 4219962.570494982, 1911599.4753587642 4219974.777389477, 1911604.2328358504 4219995.652107184, 1911604.4627161277 4219996.667223422, 1911606.845907332 4220006.747132222, 1911608.5747812695 4220014.361380162, 1911608.8684730027 4220015.644083623, 1911609.167490682 4220016.967942263, 1911610.9784216506 4220025.173769829, 1911612.282350319 4220031.102247593, 1911612.3677692665 4220031.490888763, 1911612.6303587789 4220032.617521234, 1911614.837295802 4220041.977721642, 1911615.3076665967 4220043.97067436, 1911615.5791805726 4220044.938509486, 1911620.094767214 4220056.567611331, 1911621.2713629846 4220059.583195614, 1911636.6512756397 4220097.6032691775, 1911645.527012921 4220120.048083075, 1911647.5569678636 4220125.188638477, 1911649.9543392102 4220131.203732944, 1911655.085186346 4220144.066834133, 1911659.4603480669 4220154.958674527, 1911663.1220000095 4220164.025052525, 1911664.2169716426 4220166.738717755, 1911667.3876660448 4220174.62882743, 1911672.2039650888 4220186.610508599, 1911684.087844979 4220216.198737108, 1911694.1943579125 4220241.6789159225, 1911709.6352935275 4220280.0825708425, 1911711.8510222991 4220285.612976885, 1911718.4297682925 4220300.0187607985, 1911724.1939555148 4220311.665275155, 1911726.1032232787 4220315.658707302, 1911726.8227855142 4220317.074540388, 1911727.6370233928 4220318.683402436, 1911728.5163471864 4220320.28101367, 1911730.8354657125 4220324.511701582, 1911732.2747143225 4220327.041870356, 1911732.588459136 4220327.595112261, 1911733.4447097497 4220329.029173058, 1911735.5099236907 4220332.4862097055, 1911736.3228019287 4220333.8616684405, 1911737.3416216515 4220335.669882428, 1911743.8412975664 4220347.210573503, 1911744.3524966496 4220348.118312002, 1911744.8224847806 4220348.9484688705, 1911749.3751617265 4220356.927902751, 1911752.2661430286 4220361.995368168, 1911754.0943148904 4220365.20911767, 1911756.6102138893 4220369.6328213615, 1911758.8830196953 4220373.6334714815, 1911759.966005562 4220375.529605868, 1911763.605552651 4220381.867521397, 1911767.8728838626 4220389.252180673, 1911774.0616700582 4220400.113202511, 1911786.7792155985 4220422.533577924, 1911798.9133809246 4220443.9655092135, 1911805.2589504586 4220455.191267567, 1911810.374699864 4220464.192477756, 1911816.2349940643 4220474.460343931, 1911816.4508451496 4220474.836200653, 1911817.6067861964 4220476.858067115, 1911817.6257059618 4220476.891169829, 1911822.0123695051 4220484.562881206, 1911822.6695002124 4220485.638548485, 1911823.2954134499 4220486.666970272, 1911826.669258398 4220491.885832743, 1911830.3205772536 4220497.370384359, 1911836.38634023 4220506.341530951, 1911838.01341546 4220508.722040303, 1911838.7013554855 4220509.729036203, 1911852.4073800996 4220529.995173777, 1911862.6050340482 4220545.076861911, 1911864.5399742015 4220547.8209574595, 1911867.9665113867 4220552.551620866, 1911869.1319988067 4220553.985527034, 1911872.113210917 4220557.529833157, 1911876.5700230056 4220562.103443756, 1911878.893046527 4220564.517808667, 1911880.100470935 4220565.587438423, 1911880.652995114 4220566.080810094, 1911881.8329082804 4220566.974836019, 1911882.153164162 4220567.218103534, 1911882.8216007499 4220567.766616199, 1911884.945059218 4220569.510735041, 1911885.604886436 4220570.052497846, 1911892.0117795987 4220574.9809832, 1911897.8742550272 4220579.427936087, 1911905.514453699 4220585.123049168, 1911911.4050192668 4220589.665748898, 1911913.7722730427 4220591.413769501, 1911918.8887285173 4220595.181792396, 1911920.5241501457 4220596.312825231, 1911924.3466997487 4220598.95039805, 1911929.1275910812 4220602.480086004, 1911935.7931561677 4220607.443437625, 1911936.895800012 4220608.266350791, 1911939.5921885287 4220610.33321113, 1911946.3508046241 4220615.787960475, 1911953.1139849995 4220621.290379592, 1911957.4265585234 4220625.2665362675, 1911962.5385458553 4220630.0470042955, 1911964.130029047 4220631.614417332, 1911968.3857638254 4220635.883809885, 1911971.2372086034 4220638.766130384, 1911974.595511169 4220642.424549967, 1911977.8275753777 4220646.06514414, 1911978.1075704745 4220646.409040682, 1911980.5246119301 4220649.386033327, 1911984.2897705561 4220654.487488053, 1911989.6407017633 4220661.720101861, 1911992.5375553966 4220665.710514704, 1911993.1226762806 4220666.557130027, 1911997.4509914152 4220672.805696757, 1912005.6907159723 4220685.6159005575, 1912009.442314581 4220691.581917612, 1912016.2768826 4220702.696867401, 1912019.0803313933 4220707.390162625, 1912021.6304513072 4220712.026274308, 1912025.5057301167 4220719.59768713, 1912028.4811534914 4220725.803212313, 1912028.5376181132 4220725.920561106, 1912028.7270032861 4220726.342249441, 1912029.8987318072 4220728.948732972, 1912031.5636640526 4220732.657424, 1912032.5247568716 4220734.837110258, 1912033.159111367 4220736.294016155, 1912033.9760760944 4220738.161077298, 1912038.0898782173 4220748.155837967, 1912038.7864303556 4220749.86678362, 1912039.1205853692 4220750.717160816, 1912040.6214448074 4220754.53612322, 1912048.6195632736 4220774.480829962, 1912054.7192752939 4220789.602924442, 1912059.7846874283 4220801.913305, 1912064.664899948 4220814.292585407, 1912066.4208131132 4220818.7664469965, 1912067.2842813833 4220820.9580313675, 1912088.3937499812 4220874.822499938, 1912097.278514173 4220899.216713032, 1912114.428839305 4220946.531439319, 1912117.7633428627 4220955.358192682, 1912121.4629834269 4220964.350668145, 1912123.9180912003 4220969.706010744, 1912124.554207323 4220971.035895448, 1912130.7151136992 4220983.914335664, 1912132.480813744 4220987.227100271, 1912132.7336128124 4220987.69798891, 1912137.2634776123 4220996.614920198, 1912143.071014968 4221007.615321465, 1912165.478692708 4221049.2033727905, 1912167.9800228272 4221053.642032563, 1912171.129984278 4221059.282215992, 1912172.8547279544 4221063.030206766, 1912172.9564450711 4221063.253369686, 1912174.3639019814 4221066.482551238, 1912174.4954441637 4221066.784366583, 1912175.234910394 4221068.481006068, 1912175.5796379028 4221069.273528361, 1912176.0531353427 4221070.390640434, 1912177.7848752465 4221074.501401832, 1912180.5989137478 4221081.700365349, 1912181.3728741389 4221083.4844418345, 1912181.7324359303 4221084.699523638, 1912182.8977848599 4221088.711019955, 1912195.667667018 4221128.679645747, 1912215.3496862457 4221191.033916993, 1912229.9968117478 4221236.272312754, 1912235.982986757 4221254.563840032, 1912238.0650290991 4221262.178671558, 1912238.1707604302 4221262.671294957, 1912244.7796255075 4221294.191249996, 1912252.812330775 4221334.9538906105, 1912258.056436944 4221331.660657476, 1912276.2775338748 4221320.2498107, 1912280.483680325 4221317.613600279, 1912283.582475734 4221315.67135304, 1912284.5538725809 4221315.063853893, 1912284.5566212388 4221315.062139847, 1912324.8734527372 4221289.954122111, 1912332.8589932332 4221284.992539498, 1912346.0264229851 4221278.632603273, 1912345.4003027214 4221276.8645026535, 1912345.2450991983 4221276.426223523, 1912364.0271716749 4221265.114387013, 1912370.9444984095 4221260.937518664, 1912382.9438769426 4221253.702673758, 1912389.846579422 4221249.396302757, 1912415.4928152123 4221233.633252066, 1912434.879458502 4221221.63777328, 1912448.4513663969 4221213.12909919, 1912454.2866839608 4221209.569558998, 1912454.293777322 4221209.388678291, 1912454.6368363602 4221209.179168328, 1912454.8791070834 4221206.102144408, 1912456.0354180648 4221202.478709614, 1912457.7276375114 4221199.657029229, 1912458.7085201994 4221198.288950516, 1912459.2354821134 4221197.637904474, 1912460.2536681462 4221196.739284326, 1912461.2218155705 4221195.976906424, 1912464.139785382 4221194.202361323, 1912468.604464574 4221193.24488756, 1912471.2241480942 4221193.294738981, 1912473.2701010492 4221193.519894331, 1912475.2997740903 4221194.183760663, 1912477.4744036351 4221195.04948621, 1912489.9974746245 4221187.124173609, 1912516.7025083753 4221170.45173778, 1912544.0279520699 4221153.330098269, 1912564.043375072 4221155.401686908, 1912584.725188892 4221157.516131623, 1912603.5851031095 4221159.98389763, 1912628.483928628 4221163.252659266, 1912632.2073331773 4221163.748057558, 1912654.7822214437 4221166.652804775, 1912657.1907782864 4221166.769426666, 1912662.2049419093 4221166.7555512255, 1912783.5330158211 4221166.403448654, 1912803.228936015 4221161.537612505, 1912809.75 4221159.96, 1912814.931988447 4221158.860973317, 1912869.82 4221147.22, 1912890.73 4221148.91, 1912891.4850962092 4221149.218025191, 1912891.2779542003 4221151.305187247, 1912891.5129378107 4221152.159935447, 1912917.3543624755 4221169.0366532765, 1912962.5540804563 4221198.609026871, 1913046.901043786 4221179.363592311, 1913060.3262188346 4221187.2431411445, 1913070.4120813522 4221192.662099502, 1913077.2631578336 4221196.335885737, 1913088.9659458844 4221202.004081376, 1913095.6762491465 4221205.3699172605, 1913098.6717660185 4221206.876638746, 1913099.3308600592 4221207.208152071, 1913099.3414355265 4221207.2109835055, 1913099.8625626036 4221207.36927827, 1913117.3318691237 4221209.051089242, 1913165.6474788547 4221213.314379912, 1913217.3523537072 4221217.957733635, 1913296.2285082506 4221224.674538015, 1913464.794755339 4221238.892673083, 1913497.0605530944 4221241.69908004, 1913541.348523463 4221245.467743786, 1913561.1000911037 4221247.188698189, 1913605.2933928398 4221251.052808204, 1913789.7198890748 4221266.526008621, 1913807.0515557635 4221267.983461418, 1913829.6042417886 4221269.8782728035, 1913830.3111498328 4221269.9176203245, 1913836.073846581 4221309.122299255, 1913836.8998547534 4221313.163685834, 1913838.0704072858 4221317.112926312, 1913838.8333273833 4221319.294130691, 1913839.4624628176 4221320.984372602, 1913839.6817347535 4221321.5272457255, 1913840.30895565 4221322.532731865, 1913841.5556211814 4221324.586756546, 1913846.2884663893 4221331.321466686, 1913849.7034180197 4221335.3804482, 1913852.0148392282 4221337.823813598, 1913854.0196145033 4221339.485481646, 1913857.794696382 4221342.264457121, 1913862.9168140972 4221345.2965838695, 1913868.5102628227 4221348.165925647, 1913875.5257480592 4221350.720513667, 1913880.2056320384 4221351.617354851, 1913884.2424746242 4221351.9949954515, 1913887.4915635765 4221352.231948879, 1913889.941693855 4221352.257277188, 1913895.5760582753 4221351.701814183, 1913899.5685001768 4221350.902933258, 1913902.441211713 4221350.208501273, 1913906.5772764196 4221349.062341678, 1913918.317219612 4221345.572046595, 1913933.5056989775 4221341.316610671, 1913951.446831934 4221336.412538418, 1913968.4665433485 4221332.090113757, 1913970.983325567 4221331.464161963, 1913972.6912419896 4221331.038928305, 1913973.868798182 4221330.754153599, 1913974.0061671184 4221330.720922197, 1913981.092428687 4221329.014169282, 1913984.0680273932 4221328.28211194))'::geometry,'38151','Échirolles','ÉCHIROLLES','ECH','ECH'),
     (44,'SRID=3945;POLYGON ((1915615.1355468715 4222107.9005596265, 1915650.0586874764 4222061.296311728, 1915687.9538474088 4222010.43499104, 1915694.4639697787 4222001.6851721015, 1915695.6322425061 4222000.089575583, 1915746.688127338 4221931.325105913, 1915809.4272202705 4221846.7303768555, 1915816.642987842 4221837.057361536, 1915819.8822709713 4221832.636635574, 1915845.5788966808 4221796.923845699, 1915858.0255613385 4221781.204258466, 1915866.5512379734 4221771.19307807, 1915860.6799806552 4221762.463974771, 1915879.064356935 4221759.535372766, 1915886.6574787484 4221758.392057039, 1915931.1625638742 4221751.726726103, 1915989.79566359 4221743.164845123, 1916023.7639867633 4221738.339912693, 1916114.4655265585 4221725.284073321, 1916123.5856202168 4221723.788785077, 1916130.9070961287 4221722.863672485, 1916204.8306584822 4221712.358810587, 1916446.956755988 4221677.992395124, 1916462.8500000173 4221676.52624999, 1916555.8011734686 4221598.429827808, 1916602.5851084157 4221559.465133923, 1916639.990626413 4221528.301375112, 1916653.7125776687 4221516.874694503, 1916653.4006191695 4221516.546824419, 1916647.3174090046 4221510.152098513, 1916647.020928356 4221509.8315006625, 1916646.6605137663 4221509.430203626, 1916642.516389107 4221504.4439951265, 1916612.3919154503 4221468.289016199, 1916598.9743109122 4221452.1477972735, 1916589.8408016902 4221441.004981339, 1916529.8225297304 4221368.730137907, 1916507.5144057258 4221341.820396805, 1916491.2082540581 4221322.193522283, 1916492.9087951295 4221319.153522964, 1916494.6352313245 4221316.068988983, 1916499.5048345008 4221306.354555369, 1916510.6654768991 4221284.093974534, 1916522.3823578134 4221260.224011283, 1916523.12060507 4221258.599405624, 1916522.379538299 4221258.073897589, 1916507.8882865065 4221247.73919886, 1916508.1240966944 4221247.42055778, 1916518.9341121307 4221234.016211045, 1916530.288496042 4221219.77378628, 1916536.5205857437 4221211.917770733, 1916539.661208277 4221207.935067749, 1916542.003106887 4221205.047280075, 1916555.8698972494 4221187.950055374, 1916555.8373180262 4221187.87435659, 1916555.9289659958 4221187.760590539, 1916555.342800366 4221186.626003399, 1916554.6184000366 4221184.6356461495, 1916554.3458495084 4221183.7839587545, 1916554.2317330604 4221183.299052834, 1916554.2498427106 4221182.845548607, 1916554.3577808328 4221182.044109528, 1916554.7387116565 4221180.096638036, 1916554.8617617828 4221179.533819158, 1916554.9878524675 4221179.208965256, 1916555.3212906918 4221178.365938824, 1916556.5142384993 4221176.188302624, 1916557.1808548458 4221175.071911827, 1916557.3466720718 4221174.81392475, 1916558.1753691405 4221173.529617559, 1916560.7252614973 4221169.907026823, 1916567.0999632496 4221161.675410762, 1916572.7282523578 4221154.300186403, 1916572.8000795518 4221154.206104921, 1916616.3680099521 4221097.00291024, 1916616.4678411128 4221097.056129498, 1916618.3101735602 4221094.546285295, 1916645.3394796592 4221112.451081649, 1916645.917392598 4221112.859329433, 1916663.4691289866 4221093.739248256, 1916695.6912439105 4221057.990731354, 1916770.913757969 4220975.484447387, 1916798.441309722 4220945.804055718, 1916815.8465336263 4220926.872099572, 1916816.8165749444 4220925.916907471, 1916829.6103191215 4220914.840337779, 1916830.0402755174 4220914.541012896, 1916838.0352400548 4220910.052873145, 1916843.5974381964 4220915.3753016265, 1916847.5952479194 4220919.176944977, 1916854.049305633 4220925.35541125, 1916855.753611822 4220926.986842973, 1916855.796072072 4220927.027528811, 1916874.5966399675 4220945.131542051, 1916884.0117263708 4220954.109413034, 1916895.300871057 4220964.905290844, 1916895.891713385 4220965.410125388, 1916896.75832098 4220966.15128246, 1916903.1700555168 4220971.0309096975, 1916908.22970422 4220974.9137910595, 1916914.7238511983 4220979.86683442, 1916926.5197025803 4220988.809190687, 1916940.234327723 4220974.768704167, 1916958.6417150127 4220955.793074653, 1916998.8624999996 4220914.153750004, 1917053.601544906 4220857.221765247, 1917126.140909551 4220782.382003874, 1917127.823141202 4220780.834257785, 1917127.7367551255 4220780.560016272, 1917128.1665402858 4220780.140287374, 1917125.9146066268 4220774.24541419, 1917122.060890712 4220762.541399086, 1917114.6099751308 4220737.882185726, 1917108.7233296647 4220721.4474482965, 1917106.8300814524 4220718.720568245, 1917105.3775853282 4220716.628511494, 1917098.3736844158 4220707.791462228, 1917093.8665324177 4220702.39889423, 1917080.9503199314 4220688.023365917, 1917070.5419752502 4220676.495046697, 1917068.887505721 4220673.8974066265, 1917067.9857327484 4220672.299001172, 1917067.1243254836 4220669.7317668665, 1917068.7844358627 4220667.395795937, 1917079.216880416 4220658.39060615, 1917086.5602950123 4220649.450783066, 1917090.6432389389 4220643.582859423, 1917091.1267576502 4220642.8157681525, 1917092.625978075 4220640.26632739, 1917105.9594110127 4220617.77544071, 1917114.153776889 4220603.928747105, 1917120.5627396367 4220592.078403598, 1917127.1648482024 4220578.462545989, 1917132.1317530076 4220566.66008556, 1917132.476816784 4220565.729355225, 1917134.00862857 4220557.047260315, 1917135.0232793542 4220539.899278846, 1917132.5223581996 4220507.3831825685, 1917129.6186057734 4220484.326376522, 1917123.2757888967 4220449.300154292, 1917119.4246470146 4220436.973980892, 1917113.3524519897 4220418.884883851, 1917105.9438458001 4220395.920908494, 1917105.231286601 4220391.784353948, 1917105.4597381072 4220385.596524545, 1917109.7958517466 4220353.48064292, 1917112.9567459594 4220327.989934845, 1917113.6611141977 4220302.620777386, 1917113.6490219506 4220292.434180127, 1917114.0137431424 4220289.286219743, 1917115.0632049667 4220282.093589644, 1917116.2557626448 4220275.14649192, 1917117.1661367703 4220271.230357231, 1917118.020410233 4220267.494308135, 1917121.1484715757 4220258.464401639, 1917122.9461286967 4220257.927567047, 1917124.056917692 4220256.108731264, 1917155.522243335 4220248.292921976, 1917167.4821133607 4220245.503218588, 1917175.7981025893 4220243.973090972, 1917186.8624340415 4220242.02509246, 1917207.2844502819 4220241.146287997, 1917216.846840345 4220240.149076733, 1917221.010119203 4220238.894863867, 1917226.428349246 4220237.207440236, 1917242.2958666154 4220230.9996871045, 1917251.0888366783 4220226.051406156, 1917259.7065802142 4220219.936217105, 1917295.6962544278 4220188.567282387, 1917320.580354251 4220166.612869433, 1917335.0458603238 4220152.349210526, 1917352.953170546 4220132.73872343, 1917369.2699999844 4220117.11125001, 1917443.6270086374 4220072.272326485, 1917449.7466742597 4220068.277291666, 1917427.8931250286 4220023.328749991, 1917380.3925000208 4219927.503749992, 1917361.653517486 4219888.770672179, 1917317.0458269434 4219799.759952931, 1917270.8293842897 4219706.6465215795, 1917202.3666455252 4219568.064607528, 1917114.0720559051 4219389.089728412, 1917026.035620776 4219212.145549904, 1917005.6548295429 4219157.701033168, 1916987.2320169194 4219140.496370617, 1916984.8310737207 4219139.007612158, 1916926.5394611252 4219137.156607637, 1916899.329320597 4219120.565566168, 1916881.879135313 4219122.5976394955, 1916880.840245716 4219122.633184221, 1916851.6945961476 4219102.985520827, 1916841.9762414931 4219097.2711936245, 1916798.2246932853 4219075.552242679, 1916797.7842858946 4219076.502342735, 1916795 4219075.18, 1916749.8667558192 4219175.1652115835, 1916677.4005055362 4219336.9320929395, 1916672.281855562 4219348.36364379, 1916669.8655435094 4219353.728711163, 1916669.5978502228 4219353.7168350825, 1916669.4766277468 4219353.9801686155, 1916622.515571987 4219351.666533997, 1916613.1431140634 4219351.178330224, 1916605.1625731494 4219350.754542189, 1916599.6082813595 4219350.459443916, 1916596.4746894403 4219350.292947232, 1916518.254689998 4219346.221789895, 1916429.2027440907 4219341.438108773, 1916419.8495178118 4219341.026122594, 1916418.1746011905 4219337.505401341, 1916349.4918466911 4219335.4521814855, 1916293.362792918 4219334.123295966, 1916235.1941427428 4219332.324015452, 1916231.6129216575 4219332.034229556, 1916228.7616111285 4219332.349372308, 1916228.4903509999 4219332.384662668, 1916219.0591453186 4219331.632788743, 1916182.9947042426 4219328.506753937, 1916154.1494539154 4219325.890637212, 1916147.924342536 4219325.544090901, 1916146.7210526315 4219325.869939271, 1916129.4009950473 4219325.828246928, 1916126.0762431019 4219325.9560291, 1916123.645153626 4219326.411290073, 1916117.3132329201 4219327.887297723, 1916109.2669822415 4219330.194248807, 1916104.2591764783 4219331.834665933, 1916099.5361675648 4219333.565548541, 1916096.0855470165 4219335.105534487, 1916095.8697076978 4219335.203827375, 1916088.5350841382 4219338.566637114, 1916086.1363090847 4219339.741746275, 1916074.1275451002 4219345.982402696, 1916064.4935888767 4219350.861283472, 1916038.3089144635 4219364.49385754, 1916002.2518335576 4219383.065710448, 1915980.694881883 4219394.917779259, 1915968.5525644347 4219400.440033561, 1915952.7776277624 4219405.894679541, 1915935.444699421 4219411.089639299, 1915934.0555015656 4219411.472438322, 1915924.688174445 4219413.592656743, 1915924.5681939689 4219413.619805772, 1915924.4981784176 4219413.63516729, 1915919.9065881344 4219414.644868342, 1915917.6463163637 4219415.08214437, 1915908.0856844457 4219416.866918883, 1915899.4309292596 4219418.49734537, 1915895.6263727758 4219419.212573789, 1915892.4386478672 4219419.835134504, 1915884.4226573904 4219421.564641231, 1915874.487253951 4219423.997900761, 1915860.7894626195 4219428.096025157, 1915855.2021837125 4219429.78243648, 1915841.3191145102 4219433.806859657, 1915840.241275881 4219434.088975813, 1915837.6451449282 4219434.769493244, 1915827.602800803 4219437.095813398, 1915826.783375618 4219437.285797694, 1915826.583289963 4219437.3237831285, 1915819.146107898 4219438.278167365, 1915817.7614814795 4219438.407314816, 1915815.466763722 4219438.62538658, 1915814.4829180937 4219438.613482145, 1915812.4607667516 4219438.577950811, 1915800.6611501102 4219437.536401384, 1915794.5762022603 4219436.373402957, 1915780.2551181854 4219432.91654142, 1915773.2107232797 4219431.283269524, 1915769.403908916 4219430.579722453, 1915765.116146084 4219429.954524863, 1915760.638021585 4219429.490196456, 1915754.0357684437 4219429.20300311, 1915747.7666067814 4219429.243643724, 1915740.4702458754 4219429.513484769, 1915723.7908759178 4219430.424123765, 1915707.8757147547 4219431.355056904, 1915639.796028181 4219434.382901408, 1915633.5180943205 4219434.663775712, 1915605.0487965497 4219435.865885303, 1915589.590468488 4219436.215740776, 1915588.000251544 4219436.250098964, 1915580.8148481746 4219436.437093645, 1915570.308086412 4219436.778286785, 1915564.0747251501 4219437.173111478, 1915546.291537952 4219437.472442559, 1915534.7410380873 4219437.611670449, 1915534.5000903045 4219438.126663403, 1915529.0652186365 4219445.030541487, 1915522.9652235878 4219452.732832635, 1915510.5053612792 4219469.211484336, 1915510.3981927943 4219469.3529780945, 1915510.338097849 4219469.434592447, 1915509.9821873421 4219469.918760997, 1915507.8426843458 4219472.831900278, 1915507.3473187624 4219473.503777566, 1915506.8547798286 4219474.17284975, 1915492.373961441 4219493.882027081, 1915485.005743843 4219503.889145655, 1915479.8018678636 4219510.963457077, 1915465.717136737 4219530.311470481, 1915464.5086421052 4219531.9719949225, 1915462.8516080345 4219534.250010327, 1915451.9568059773 4219549.233233453, 1915451.1547260582 4219550.313645679, 1915448.7604954941 4219553.547883481, 1915442.8570417196 4219561.709969469, 1915421.7145125521 4219590.959978476, 1915415.9158571858 4219598.825465707, 1915415.4647895459 4219599.434450494, 1915415.379755937 4219599.536211422, 1915413.132278097 4219602.225604224, 1915397.5004345654 4219619.426416235, 1915398.1275214 4219619.720957021, 1915398.9418164815 4219620.103428953, 1915388.2507718117 4219634.345765234, 1915376.4966705074 4219650.984778259, 1915369.447109488 4219661.15659859, 1915355.8865651558 4219680.990274546, 1915333.7187305405 4219712.90158965, 1915329.5660403236 4219718.733477135, 1915312.4008778906 4219741.40147326, 1915299.4222536685 4219758.205083897, 1915264.3244182705 4219803.40320406, 1915260.7976787356 4219808.16185862, 1915257.2182649695 4219813.263551235, 1915221.138936355 4219865.727725178, 1915198.5631798066 4219898.810936686, 1915186.2732062077 4219916.691992661, 1915179.7612999885 4219926.069753522, 1915175.7657268057 4219931.726358804, 1915172.7456324808 4219935.88820406, 1915130.8474629843 4219993.489698068, 1915103.7895936226 4220030.474972709, 1915101.0818189036 4220034.147501021, 1915094.7203317806 4220042.737345161, 1915085.7586754784 4220054.738358186, 1915083.8953544158 4220057.214028235, 1915080.9452823661 4220061.039454574, 1915073.0961814276 4220071.224623644, 1915069.0892338974 4220076.518690171, 1915066.5095485928 4220079.985466948, 1915046.7859178954 4220106.751861563, 1915045.0022610922 4220109.302209898, 1915029.939376561 4220131.100538227, 1915021.7905604336 4220143.628063168, 1915014.516239752 4220155.377619991, 1915011.0158603685 4220161.325716231, 1915006.4917235493 4220169.462406144, 1915003.0228121455 4220175.97723055, 1915001.7536918437 4220178.407503901, 1914995.589863655 4220190.7158119595, 1914994.5889683184 4220192.747001521, 1914992.6332415887 4220196.783368459, 1914992.632786994 4220196.784306569, 1914990.8361293306 4220200.454621511, 1914988.6847409355 4220204.753899575, 1914985.9288565312 4220210.278809397, 1914981.9372745508 4220218.601053401, 1914981.2042802277 4220220.13111325, 1914981.0294907335 4220220.497020893, 1914980.6881788522 4220221.195042558, 1914980.2956046404 4220221.987407664, 1914980.1392587468 4220222.303577246, 1914980.0289992872 4220222.526337964, 1914979.9166674106 4220222.74441499, 1914975.228949028 4220231.792428005, 1914966.924225381 4220247.455094791, 1914964.6550245737 4220251.631713068, 1914964.5846746352 4220251.760328235, 1914964.168014003 4220252.4917633375, 1914963.4718912197 4220253.689476794, 1914963.2936917602 4220253.992568124, 1914960.5283369594 4220258.716826003, 1914960.5240226744 4220258.72419707, 1914959.1719178509 4220261.034932118, 1914957.213518276 4220264.398130305, 1914954.041781528 4220269.848963729, 1914953.0249193043 4220271.588452846, 1914951.529286848 4220274.133964609, 1914948.3726185022 4220279.490469832, 1914946.9174709518 4220281.893281863, 1914942.9385805305 4220288.385548137, 1914935.4788849188 4220300.550840883, 1914918.5026686168 4220326.183724347, 1914915.674735884 4220330.169780244, 1914912.3813814558 4220334.84687172, 1914907.1930499983 4220342.265089646, 1914902.9552057888 4220348.303463498, 1914900.9871787583 4220351.090704962, 1914900.4070095224 4220351.851093401, 1914893.798950512 4220360.553566553, 1914886.3661476625 4220370.414766613, 1914879.007222952 4220381.618237607, 1914872.2495942926 4220392.236113837, 1914867.3665725798 4220400.223746197, 1914857.4041896898 4220418.588586863, 1914850.66 4220431.44, 1914849.9838329183 4220433.081665404, 1914847.6319227763 4220437.678591414, 1914843.3389523148 4220446.112111835, 1914808.720660363 4220514.373749241, 1914792.3839020166 4220546.921393195, 1914790.4535427855 4220550.806437045, 1914788.8580273888 4220554.016177509, 1914783.8037183264 4220564.208407547, 1914765.4433168743 4220601.500061522, 1914765.044114003 4220609.925278912, 1914765.037022133 4220610.073851106, 1914765.030323141 4220610.213769763, 1914765.0141052564 4220610.547818532, 1914765.00085652 4220610.838444351, 1914764.9652247934 4220611.561550355, 1914764.9086754583 4220612.81711738, 1914764.874587302 4220613.463303708, 1914764.7840026794 4220615.380538516, 1914760.0865529985 4220687.120969549, 1914753.7416049398 4220784.881132251, 1914753.7406809023 4220784.8954204945, 1914753.2974472838 4220791.81866063, 1914753.1197798406 4220794.811938449, 1914752.1979986483 4220809.867736098, 1914751.4770127996 4220821.588439297, 1914913.4431178856 4220831.626691934, 1914911.6831154947 4220860.873650144, 1914990.7138067824 4220865.990573918, 1914991.757636142 4220850.214603164, 1914997.8592231825 4220758.18658148, 1915125.3028403118 4220766.147863815, 1915138.1944378235 4220766.939828501, 1915143.0351447342 4220767.237318641, 1915150.7423440372 4220767.733811687, 1915182.9158915572 4220769.767519679, 1915225.920064426 4220772.480113461, 1915225.860813438 4220773.395869323, 1915223.0955040301 4220816.205615506, 1915214.1100784428 4220955.849096674, 1915168.162965587 4220952.962117927, 1915164.201914352 4221017.164467946, 1915162.2990049105 4221049.072476527, 1915162.0024141984 4221054.189477245, 1915161.892190864 4221056.108183445, 1915161.2901695315 4221066.254493292, 1915153.3905625334 4221191.6459326325, 1915153.232484815 4221193.671064035, 1915171.4982527823 4221195.00217233, 1915182.197580544 4221279.2493564645, 1915189.7161117797 4221338.477939286, 1915189.9224175832 4221338.530803454, 1915189.9428914846 4221338.693797777, 1915196.93536744 4221340.538884946, 1915215.9451309976 4221345.7710186, 1915234.1074607393 4221351.219219311, 1915268.8296859763 4221362.9346603695, 1915288.8699178104 4221370.644587047, 1915307.8915132328 4221378.37193882, 1915326.0774090905 4221386.508714469, 1915326.9499373585 4221386.898379483, 1915334.4365649067 4221390.394221146, 1915345.2766017844 4221395.524635182, 1915363.7450312667 4221404.295220495, 1915363.7728167113 4221404.689525723, 1915363.9004951047 4221404.751754696, 1915367.310091103 4221454.46341093, 1915370.3069127412 4221496.67319309, 1915370.1138736114 4221499.078304776, 1915366.8101514468 4221522.233817957, 1915365.990430167 4221527.826695332, 1915366.2327430157 4221535.408363953, 1915366.923775315 4221549.32089606, 1915367.0320612262 4221551.727840058, 1915367.3988598015 4221563.155272954, 1915367.6880089028 4221571.892779597, 1915368.30537538 4221589.978337903, 1915368.7834553027 4221600.014106884, 1915369.9011250066 4221633.045907014, 1915370.0104269441 4221634.816053147, 1915372.3717328808 4221669.266032451, 1915373.982831488 4221690.664493292, 1915375.711764319 4221712.33476336, 1915376.8005296276 4221722.779878518, 1915377.9813576392 4221730.318757187, 1915379.817355252 4221739.526481645, 1915382.9678507114 4221751.834237253, 1915386.942824474 4221763.698545653, 1915388.362136112 4221767.606061494, 1915388.4762295664 4221767.903137722, 1915389.9621465579 4221771.203169452, 1915391.6413543941 4221774.8865182, 1915393.76158563 4221779.488532262, 1915394.3521346268 4221780.648524721, 1915396.3425811634 4221784.361048436, 1915396.9291357165 4221785.455614206, 1915398.7993152272 4221788.9396478655, 1915401.2210804657 4221793.365980832, 1915401.5455041225 4221793.919481798, 1915406.8417765375 4221802.401868197, 1915407.1553939362 4221802.886528964, 1915410.4814454454 4221807.743222343, 1915412.291676886 4221810.324939054, 1915416.254411741 4221815.625554278, 1915418.8967942838 4221819.002832305, 1915419.041284078 4221819.177779227, 1915419.3173245203 4221819.510309262, 1915420.6902867358 4221821.006579682, 1915430.7080195672 4221831.825557732, 1915441.1620858083 4221843.043109572, 1915451.6990690094 4221854.282771848, 1915476.0675000062 4221880.33125, 1915467.5250431243 4221888.216777685, 1915460.5653708254 4221894.3156968625, 1915460.04876488 4221894.746984265, 1915454.543621456 4221899.592692829, 1915451.6386152687 4221902.154317937, 1915450.1725578872 4221903.438298416, 1915448.2337114108 4221905.144554335, 1915446.62128163 4221906.586214575, 1915443.381631135 4221909.496891429, 1915442.7685720045 4221910.13620883, 1915441.8545843647 4221911.090703123, 1915441.258100897 4221911.955487364, 1915439.146376522 4221915.000895732, 1915436.6306478332 4221920.007107141, 1915435.6619563228 4221921.94787859, 1915435.4694436956 4221924.642620968, 1915435.1705759058 4221929.3642634, 1915435.2778713033 4221930.508116859, 1915435.4514798468 4221932.388132869, 1915436.221777304 4221934.9841810325, 1915438.1138413034 4221939.054698059, 1915443.2744914002 4221949.856926227, 1915444.3392225602 4221952.073966335, 1915445.2121984428 4221953.820155641, 1915445.2188666565 4221953.833482108, 1915445.7654495856 4221954.939741676, 1915446.3059505087 4221956.047211598, 1915454.1383798404 4221972.136459498, 1915465.0749459653 4221994.7503679795, 1915467.5717449824 4222000.613798133, 1915467.632563681 4222000.790895645, 1915467.7940810907 4222001.267223605, 1915468.9042133822 4222006.286672038, 1915468.3405769274 4222014.979767198, 1915466.5298521249 4222023.267750785, 1915465.3033527343 4222027.9453820875, 1915461.0393747517 4222033.204033168, 1915454.9999848178 4222039.454858299, 1915454.1224283217 4222040.113265676, 1915448.0553782557 4222043.75592672, 1915421.1701192379 4222052.565343498, 1915421.203387938 4222052.714839388, 1915421.1248283223 4222052.739582057, 1915422.7941805457 4222060.32160697, 1915424.8685291645 4222069.121031143, 1915426.726669831 4222076.567803914, 1915429.210965555 4222086.972567343, 1915451.38498185 4222180.110745003, 1915451.57204796 4222180.063489627, 1915451.5860987008 4222180.122056266, 1915454.1170096241 4222179.420598614, 1915456.9525153069 4222178.643806558, 1915465.9921261745 4222175.9259577505, 1915470.7469313433 4222174.5816413965, 1915474.2671662024 4222173.578165875, 1915480.0229024799 4222171.90860838, 1915491.7640965378 4222168.468527957, 1915502.6777793586 4222165.130303491, 1915513.1736452975 4222162.035666842, 1915543.311213143 4222153.039664515, 1915582.6179551831 4222141.364475882, 1915587.037508337 4222140.235201418, 1915590.512181812 4222138.966363639, 1915592.6832724258 4222138.1604980985, 1915593.3988266613 4222137.93541905, 1915593.2003784224 4222137.391038084, 1915594.4248090764 4222135.7260568915, 1915615.1355468715 4222107.9005596265))'::geometry,'38158','Eybens','EYBENS','EYB','EYB'),
     (10,'SRID=3945;POLYGON ((1910849.3860962905 4226229.513890484, 1910941.172854251 4226262.655283401, 1911039.1061867434 4226298.062656883, 1911037.9840905254 4226300.674226866, 1911041.1931603872 4226303.478993126, 1911045.0385553401 4226310.068492855, 1911045.3753873988 4226310.517542961, 1911046.6301227838 4226312.09147646, 1911047.792002136 4226313.304028595, 1911048.8279189232 4226314.204367379, 1911048.846772749 4226314.220650466, 1911049.9160703816 4226315.302567687, 1911051.91024704 4226317.449317953, 1911056.366663844 4226322.226955745, 1911057.8225956932 4226323.782480992, 1911059.3877751185 4226325.457902106, 1911060.897238939 4226327.070005761, 1911062.33033739 4226328.60308573, 1911063.1321235897 4226329.4596155835, 1911064.0833385678 4226330.4761710195, 1911065.097726308 4226331.561565842, 1911066.158847671 4226332.695458643, 1911067.824608946 4226334.475962871, 1911068.814854067 4226335.534543087, 1911069.4287201248 4226336.191097673, 1911070.030327796 4226336.8339644, 1911070.698201753 4226337.548723633, 1911071.95719484 4226338.893933639, 1911072.3647346138 4226339.328646124, 1911072.8642246414 4226339.864047576, 1911073.4349201587 4226340.474054669, 1911073.8909243443 4226340.961761547, 1911074.4654868692 4226341.574310376, 1911074.8262202754 4226341.961011957, 1911075.5953378319 4226342.783660087, 1911076.1427951278 4226343.363940163, 1911076.3770425674 4226343.618929674, 1911076.8299122693 4226344.1007548785, 1911077.4474785007 4226344.760123223, 1911077.857469668 4226345.202490157, 1911078.3322566312 4226345.708438687, 1911078.737845994 4226346.13971761, 1911079.0549495344 4226346.479972336, 1911079.4139183601 4226346.865379564, 1911079.8039667166 4226347.2803215785, 1911080.119958896 4226347.619178209, 1911080.4633576034 4226347.986226077, 1911080.7873384207 4226348.332132647, 1911091.434443981 4226359.713738822, 1911093.7752032499 4226362.215715108, 1911094.2800962953 4226362.755687067, 1911094.4174433865 4226362.902391591, 1911094.5176643627 4226363.009210762, 1911094.7294714735 4226363.235717344, 1911094.8591706806 4226363.374273092, 1911095.0452681077 4226363.573254618, 1911095.120455124 4226363.653609013, 1911095.176626036 4226363.713654672, 1911095.386287104 4226363.937760372, 1911095.4020764863 4226363.954640031, 1911095.4207942055 4226363.974647298, 1911095.5385067787 4226364.100477909, 1911095.9077548052 4226364.495196814, 1911101.5854112313 4226370.564584138, 1911105.957212578 4226375.237725836, 1911106.980103319 4226376.33058477, 1911161.985456938 4226324.716835346, 1911255.81839565 4226236.716236191, 1911276.5786669787 4226216.986466745, 1911302.2701084344 4226192.849020497, 1911356.3034061391 4226142.633409862, 1911369.6875317218 4226130.052474563, 1911432.7178413456 4226070.566588158, 1911462.0267581563 4226042.86912473, 1911517.571114056 4225990.462002841, 1911522.3949303362 4225985.928616017, 1911522.8191494197 4225985.529929699, 1911554.2293845848 4225956.018209197, 1911577.7850181686 4225933.718162565, 1911585.766173336 4225926.139938996, 1911587.4635669927 4225924.526048503, 1911587.541126802 4225924.452278259, 1911587.5486673347 4225924.445109473, 1911588.05886289 4225923.960040588, 1911588.4935122766 4225923.550898459, 1911588.5719928932 4225923.4771562535, 1911588.8714992919 4225923.195874904, 1911590.123267954 4225922.02167015, 1911594.800681165 4225917.627828115, 1911615.5686065087 4225898.129521134, 1911641.386499784 4225873.594352887, 1911649.2995037204 4225866.0356224645, 1911662.6170546245 4225853.326922185, 1911674.658238439 4225842.042456046, 1911681.2453935072 4225835.890881526, 1911689.2945592608 4225828.370319378, 1911690.2589056366 4225827.469525556, 1911690.5061830624 4225827.238482686, 1911747.1995766957 4225774.279514711, 1911782.3644675806 4225741.089966737, 1911785.1726178094 4225738.434406222, 1911805.9106431624 4225718.8240422765, 1911860.0136576844 4225667.586628015, 1911908.1892208003 4225621.760749703, 1911924.147235986 4225606.486793125, 1911972.116313392 4225560.441674999, 1911982.103283664 4225550.848438751, 1911989.4008226001 4225543.612282137, 1912014.0740790714 4225519.013493009, 1912039.151422542 4225493.563265894, 1912050.9899100794 4225480.997493937, 1912062.298041496 4225467.323937241, 1912086.927252024 4225437.389939264, 1912121.9271103228 4225389.827839064, 1912139.0587044535 4225363.141027321, 1912157.466965005 4225334.463600267, 1912168.9853069603 4225315.8568922905, 1912179.942960533 4225293.212904858, 1912193.8273327562 4225258.1630869005, 1912198.7179301355 4225245.033484342, 1912204.1398988394 4225223.6641990105, 1912207.1957118928 4225210.840782574, 1912207.5719057252 4225209.278157946, 1912207.7465796988 4225208.363770753, 1912211.0043977867 4225188.78871961, 1912214.821758094 4225161.492207188, 1912216.3193941608 4225150.220275275, 1912219.3402935234 4225123.045688259, 1912223.4879815725 4225084.05499661, 1912228.1650707829 4225038.645220003, 1912230.985578851 4225015.510717349, 1912232.7037836437 4224999.200742829, 1912238.3480777638 4224942.553296828, 1912239.1662499902 4224929.476250005, 1912243.0433702918 4224771.722817038, 1912244.756209505 4224647.402874485, 1912245.16520748 4224616.596249999, 1912246.14630151 4224548.796549789, 1912248.1359357706 4224411.395437686, 1912248.1398745994 4224406.716969433, 1912246.64735782 4224406.221560251, 1912244.1652132033 4224405.353600092, 1912233.8341591808 4224401.741839525, 1912221.4416201217 4224397.347124253, 1912188.6708957502 4224385.676052624, 1912174.186779456 4224380.526946793, 1912160.859965262 4224375.884926351, 1912160.855145417 4224378.528857357, 1912079.6836639673 4224349.71534413, 1911981.6329149797 4224314.87951417, 1911926.488016987 4224295.489528426, 1911919.4563157894 4224291.144858301, 1911906.629796805 4224284.940139449, 1911827.2731578948 4224256.274696356, 1911719.7518218623 4224217.987024292, 1911481.2476351121 4224133.488324732, 1911438.5836639677 4224119.774372471, 1911286.86349379 4224065.74708503, 1911288.99 4224062.89, 1911289.054519565 4224062.805619648, 1911279.7753441297 4224059.567004049, 1911273.8135829957 4224055.94597166, 1911256.8742781724 4224050.474029922, 1911188.312909896 4224029.178305577, 1911114.2547610754 4224006.155555841, 1911088.241749351 4223999.378893007, 1910924.9356726117 4223956.7679475, 1910440.1028731945 4223813.722874921, 1910118.845923492 4223732.782164598, 1910111.6093388551 4223732.013176067, 1910104.7687774054 4223732.874751283, 1910097.0836195913 4223732.2360088285, 1910080.5589678136 4223728.928799286, 1910069.7351821526 4223724.972115849, 1910060.9914595783 4223716.086056189, 1910052.8994754015 4223705.562979786, 1910048.2625637378 4223703.601730661, 1910014.1405492632 4223697.319149013, 1909978.5110919417 4223689.824495163, 1909975.7297216218 4223695.695326054, 1909975.2269707338 4223695.667221966, 1909973.4897969062 4223699.481739159, 1909969.6050112776 4223709.748816616, 1909966.902173721 4223718.966610131, 1909965.6296558704 4223725.512004049, 1909963.4439212794 4223732.863941708, 1909962.3898669493 4223736.546412178, 1909959.1393522269 4223744.441761133, 1909953.9189026742 4223754.84767454, 1909950.952030824 4223764.362693855, 1909951.651038947 4223773.768763669, 1909952.4974898787 4223780.136558704, 1909953.3925834203 4223783.489163312, 1909954.5177199324 4223785.881940667, 1909950.8289917337 4223790.394199615, 1909948.9126693015 4223792.811630562, 1909934.4039776656 4223808.697756551, 1909921.8098431923 4223821.664272979, 1909902.5831034197 4223841.453600476, 1909902.5826116933 4223841.454108741, 1909902.5809094408 4223841.455865801, 1909895.0842284847 4223849.198236618, 1909851.8661543964 4223893.736265099, 1909828.62 4223887.52, 1909807.2653441299 4223881.750364372, 1909802.3766711599 4223879.230107991, 1909795.8222326974 4223874.704804507, 1909775.1207574522 4223859.074554047, 1909556.3811301743 4223698.606927908, 1909524.9210298487 4223675.457499766, 1909522.2432562222 4223677.4264742285, 1909521.7599192762 4223677.067095814, 1909465.033242263 4223718.613056256, 1909411.2064757592 4223758.2759529, 1909135.6769114356 4223961.327350502, 1909092.885473878 4223992.872671033, 1909091.4663071565 4223993.918836344, 1909091.2946921121 4223994.045346655, 1909090.893538424 4223994.341102761, 1909090.5283030618 4223994.61041755, 1909089.0176156352 4223995.723895251, 1909088.3626908667 4223996.199982384, 1909087.56701467 4223996.773404642, 1909086.9127547394 4223997.285373727, 1909086.5313813775 4223997.583849797, 1909086.1404382193 4223997.889719202, 1909085.3149993531 4223998.478970037, 1909084.8786909126 4223998.789175158, 1909079.976688405 4224002.28026004, 1909073.1933639431 4224007.111246083, 1909054.772016217 4224020.2779573025, 1909055.2909187542 4224020.673084922, 1909055.2347635583 4224020.714599796, 1909054.9855687695 4224020.892980954, 1909054.145532122 4224021.512365313, 1909052.7572645268 4224022.535868232, 1909051.9990964998 4224023.0948848855, 1909051.9900540013 4224023.1015539, 1909051.5922971624 4224023.394808875, 1909050.7728764678 4224023.999217386, 1909049.303326334 4224025.083507786, 1909046.8604506701 4224026.888963063, 1909034.213737846 4224036.205406993, 1909022.9522383907 4224044.500604925, 1909009.9052850143 4224054.114535583, 1908986.992049899 4224071.00129135, 1908977.052994656 4224078.322424044, 1908970.3548824803 4224083.267071756, 1908966.513624137 4224086.067696916, 1908963.2127936746 4224088.463686319, 1908961.3580746506 4224089.807274851, 1908960.3309497237 4224090.550890442, 1908958.7034072566 4224091.72868223, 1908958.6968874156 4224091.733406955, 1908958.491236651 4224091.882391028, 1908955.906686076 4224093.755509879, 1908932.2511065933 4224110.883602382, 1908865.9841693423 4224158.72198793, 1908862.3196931637 4224161.313052485, 1908861.557419614 4224161.873780987, 1908861.132885413 4224162.324288756, 1908860.558906059 4224163.212953943, 1908858.9164815727 4224165.859880209, 1908855.2486915062 4224171.28293235, 1908854.1817434032 4224172.823149395, 1908852.8533723936 4224174.751488554, 1908848.5769971502 4224181.048946254, 1908847.1389736198 4224182.975560176, 1908845.9846846613 4224184.373512787, 1908837.5328837577 4224193.735372299, 1908831.6665648029 4224199.496784572, 1908827.687661245 4224202.77099736, 1908819.608267853 4224207.975302592, 1908814.2890917272 4224210.818037694, 1908809.7871439971 4224212.763335004, 1908805.2587668567 4224214.534213187, 1908797.288237927 4224216.068871116, 1908787.808074025 4224217.902959941, 1908780.776374846 4224224.210969511, 1908772.3471065648 4224232.833848546, 1908769.2152822495 4224236.797008663, 1908766.7742435273 4224239.897505553, 1908758.7458337958 4224249.994130069, 1908755.219859381 4224255.038811189, 1908749.6237539465 4224263.888554803, 1908748.7162613675 4224265.15994943, 1908746.7177360174 4224267.603701434, 1908745.1335242193 4224269.343995966, 1908744.6345699849 4224269.904922258, 1908744.201156851 4224270.267466958, 1908743.229403291 4224271.188275931, 1908741.5845075182 4224272.5821527, 1908726.085275559 4224282.278184176, 1908716.5916817638 4224288.823335412, 1908715.4042182257 4224289.812191808, 1908714.7161987047 4224290.170669546, 1908713.2349749124 4224290.985318973, 1908712.5063423207 4224291.578199703, 1908711.7645552761 4224292.262036962, 1908711.0506757693 4224292.936212053, 1908709.7606640353 4224293.842385382, 1908709.0917720767 4224294.324000995, 1908708.7086229024 4224294.4333727, 1908705.2770802306 4224295.293532185, 1908700.750598288 4224296.575380824, 1908696.312193967 4224298.139376353, 1908692.103454508 4224299.73845797, 1908689.8379362 4224300.469165358, 1908686.5437781245 4224301.721555014, 1908685.3669057537 4224302.244605445, 1908684.480116324 4224302.613579273, 1908681.950136731 4224303.878599978, 1908680.758171674 4224304.613494563, 1908679.3120021569 4224305.990812522, 1908678.3077448646 4224307.117656486, 1908673.6269228845 4224312.501379839, 1908668.0232771249 4224318.914178732, 1908664.0173378813 4224322.164272183, 1908659.4528701422 4224324.240339442, 1908656.2543223472 4224325.485788247, 1908655.0699634475 4224325.9032357065, 1908653.7306725294 4224326.067355032, 1908649.735095626 4224326.640435271, 1908637.9288805418 4224328.26539678, 1908635.0952962223 4224328.610419491, 1908629.336594372 4224331.1464178655, 1908626.7055638381 4224332.395303834, 1908625.5388384878 4224332.731143033, 1908621.1270561134 4224333.773683919, 1908619.678477959 4224333.491758922, 1908617.2207850844 4224333.003854535, 1908614.5528939536 4224332.317722459, 1908611.7956071196 4224331.43182627, 1908608.4370673024 4224330.467947619, 1908605.1843055699 4224329.524902936, 1908602.2718235606 4224328.890553487, 1908601.0007683255 4224328.606440813, 1908599.8154648803 4224329.441384978, 1908598.8993033264 4224330.270945541, 1908596.1690050906 4224332.751683082, 1908595.559939088 4224333.3230093615, 1908590.9165424374 4224337.671934504, 1908584.5826071645 4224343.270969871, 1908580.586172515 4224346.478620305, 1908578.0798355872 4224348.469870553, 1908571.8364263435 4224353.826607215, 1908561.1033499485 4224362.375714731, 1908549.521711752 4224371.0300299805, 1908525.4263606733 4224384.246824988, 1908514.62097502 4224389.878921591, 1908506.0122274125 4224395.2094223285, 1908504.7225606588 4224396.117439341, 1908503.9976171474 4224396.636001704, 1908503.3177355067 4224397.522264494, 1908502.7018357792 4224398.323671559, 1908500.045429979 4224402.411432244, 1908495.6850021326 4224409.281302749, 1908492.9632644837 4224413.376694375, 1908490.2245406907 4224417.907494587, 1908489.0773569834 4224421.544420038, 1908486.7795524632 4224429.125939617, 1908484.50991711 4224434.95742698, 1908482.2845253989 4224439.029281836, 1908481.427201262 4224440.521528738, 1908481.2645073219 4224440.737820274, 1908481.0457858937 4224440.903630974, 1908479.0695393959 4224442.137591625, 1908476.7097715545 4224443.654013095, 1908475.9262910446 4224444.156272296, 1908475.5333145258 4224444.391575304, 1908472.3731515903 4224446.119135411, 1908470.6845157656 4224446.993935882, 1908452.3680683163 4224456.542754764, 1908426.042408267 4224469.919932632, 1908401.8939067612 4224482.9102910515, 1908382.7128035075 4224493.353251752, 1908375.21 4224498.9, 1908369.46 4224503.07, 1908362.8 4224507.91, 1908356.25 4224512.07, 1908351.34 4224514.94, 1908346.05 4224518.08, 1908340.03 4224520.36, 1908333.65 4224523.39, 1908328.87 4224524.78, 1908326.84 4224526.24, 1908325.34 4224527.33, 1908324.51 4224530.03, 1908324.09 4224534.12, 1908322.8 4224539.35, 1908321.92 4224541.99, 1908319.58 4224546.17, 1908316.46 4224549.84, 1908312.43 4224553.37, 1908308.7 4224556.87, 1908305.54 4224560.36, 1908304.66 4224561.89, 1908304.02 4224563.5, 1908303.81 4224564.01, 1908303.8 4224567.3, 1908304.29 4224573.05, 1908304.42 4224578.03, 1908305.15 4224581.09, 1908304.65 4224585.64, 1908303.34 4224596.87, 1908302.04 4224614.17, 1908301.75 4224632.32, 1908302.13 4224641.22, 1908302.13 4224646.71, 1908302.39 4224651.6, 1908302.05 4224654.84, 1908301.78 4224659.13, 1908300.32 4224661.79, 1908298.02 4224666.74, 1908295.04 4224671.7, 1908292.93 4224674.43, 1908290.35 4224676.91, 1908297.67 4224685.75, 1908300.98 4224684.14, 1908309.72 4224682.58, 1908315.84 4224681.53, 1908319.99 4224681.61, 1908323.6 4224681.78, 1908326.62 4224682.77, 1908328.75 4224683.92, 1908331.43 4224685.97, 1908332.9 4224687.99, 1908334.66 4224690.4, 1908335.59 4224692.93, 1908335.56 4224695.23, 1908334.8 4224699.27, 1908332.29 4224707.88, 1908329.58 4224715.83, 1908328.12 4224721.38, 1908327.01 4224725.48, 1908324.15 4224731.15, 1908322.68 4224736.4, 1908319.05 4224743.62, 1908315.54 4224750.75, 1908314.8 4224753.7, 1908312.16 4224762.69, 1908309.08 4224769.32, 1908304.44 4224781.46, 1908299.36 4224792.33, 1908296.91 4224797.6, 1908295.78 4224801.81, 1908294.68 4224805.79, 1908293 4224812.4, 1908290.86 4224822.64, 1908288.91 4224837.12, 1908289.46 4224847.09, 1908289.77 4224853.83, 1908291.95 4224863.42, 1908293.82 4224879.32, 1908295.38 4224887.37, 1908296.97 4224899.87, 1908298.13 4224910.39, 1908299.93 4224924.95, 1908301.55 4224935.14, 1908302.09 4224941.1, 1908302.26 4224943, 1908304.54 4224953.82, 1908305.79 4224962.97, 1908306.71 4224973.57, 1908307.65 4224982.96, 1908307.96 4224993.01, 1908308.39 4224999.78, 1908309.01 4225011.9, 1908309.28 4225022.57, 1908309.29 4225033.03, 1908309.18 4225044.68, 1908308.7 4225053.91, 1908308.93 4225063.01, 1908307.51 4225077, 1908306.91 4225089.22, 1908305.9 4225097.43, 1908305.53 4225099.79, 1908305.17 4225102.34, 1908304.42 4225105.28, 1908301.11 4225113.08, 1908298.79 4225119.64, 1908297.9 4225122.68, 1908298.38 4225125.82, 1908299.4 4225128.18, 1908301.06 4225130.46, 1908303.66 4225134.05, 1908308.1 4225139.61, 1908311.68 4225143.58, 1908313.82 4225146.53, 1908315.14 4225149.86, 1908315.02 4225154.23, 1908315.66 4225156.95, 1908315.71 4225163, 1908315.69 4225170.8, 1908314.34 4225181.16, 1908312.88 4225188.49, 1908312.11 4225192.24, 1908311.55 4225194.35, 1908309.95 4225196.81, 1908306.69 4225199.87, 1908302.05 4225203.94, 1908297.34 4225207.46, 1908295.12 4225209.77, 1908290.98 4225215.47, 1908285.64 4225221.44, 1908281.18 4225228.06, 1908277.33 4225233.06, 1908275.19 4225236.01, 1908270.97 4225242.16, 1908267.61 4225247.69, 1908266.24 4225249.78, 1908265.12 4225251.69, 1908265.34 4225254.33, 1908265.85 4225258.44, 1908267.95 4225262.71, 1908270.35 4225268.64, 1908276.23 4225276.73, 1908289.04 4225292.87, 1908290.57 4225294.14, 1908292.66 4225295.13, 1908295.4 4225296.9, 1908297.66 4225298.35, 1908298.54 4225298.93, 1908298.87 4225300.49, 1908297.87 4225303.86, 1908295.68 4225313.67, 1908292.98 4225325.21, 1908291.85 4225328.87, 1908290.65 4225331.48, 1908288.66 4225334.63, 1908286.02 4225337.41, 1908278.65 4225345.29, 1908269.84 4225354.87, 1908265.53 4225359.5, 1908264.62 4225360.86, 1908264.05 4225364.14, 1908262.78 4225374.95, 1908263.88 4225381.54, 1908264.42 4225385.99, 1908264.83 4225390.83, 1908265.18 4225396.27, 1908265.06 4225401.02, 1908264.58 4225406.27, 1908263.37 4225412.02, 1908261.68 4225420.14, 1908259.65 4225427.5, 1908258.28 4225435.08, 1908257.17 4225443.86, 1908256.38 4225449.91, 1908256.83 4225454.38, 1908256.413446692 4225457.023220082, 1908260.1510627766 4225456.731673108, 1908396.060194763 4225446.6465200735, 1908440.426750993 4225443.377534048, 1908474.754198814 4225440.878070682, 1908558.40246544 4225434.838233653, 1908669.176106063 4225427.042285637, 1908750.348532131 4225420.601381724, 1908769.5759940022 4225409.015725262, 1908791.5765789475 4225397.869873482, 1908830.5863067852 4225378.455561111, 1908842.2189420864 4225350.304476684, 1908852.8467408903 4225340.910991902, 1908866.9088569079 4225330.930767966, 1908887.024641259 4225330.149582557, 1908926.3397346034 4225331.920417508, 1908954.434612214 4225330.072259422, 1908985.2510402529 4225324.855886176, 1909028.910945486 4225361.677120742, 1909030.801535842 4225363.036414495, 1909087.3363958339 4225345.875423402, 1909152.689974186 4225326.661246896, 1909281.3917801112 4225289.337713816, 1909291.6665270748 4225288.196064651, 1909306.5136183864 4225290.584135825, 1909331.2153403338 4225291.477155254, 1909344.5363536985 4225297.091858199, 1909356.4452419502 4225300.651656047, 1909375.2816055163 4225303.41629175, 1909387.3083309087 4225305.167740701, 1909388.033960888 4225306.063345689, 1909388.9797437273 4225328.584378707, 1909387.494381805 4225329.176613042, 1909389.2202897372 4225332.144641314, 1909395.6689517985 4225341.76765569, 1909397.9012186695 4225346.4475713065, 1909398.0731052416 4225346.876359054, 1909403.4690135883 4225358.851383958, 1909410.3365290875 4225374.22695366, 1909413.7221713688 4225381.578629175, 1909416.8224315217 4225387.1489380365, 1909421.214255124 4225393.8594071055, 1909424.1192316627 4225397.573775927, 1909424.5692299209 4225398.095625212, 1909427.4685187305 4225395.453261946, 1909428.4116120054 4225394.822505276, 1909437.631788966 4225394.735105006, 1909463.1701404243 4225393.581015935, 1909470.7408903218 4225392.428713795, 1909476.3368653564 4225391.032277298, 1909510.682709814 4225382.441608892, 1909550.3677092488 4225372.401695234, 1909553.898994693 4225372.344192888, 1909556.2352928917 4225372.349573313, 1909598.6857888966 4225382.928981313, 1909634.8449367557 4225391.258810329, 1909645.2000856702 4225393.522863945, 1909657.5568686607 4225396.02623732, 1909672.8064948507 4225396.908623412, 1909673.3548741068 4225396.908989242, 1909674.1919135347 4225396.909547641, 1909679.6975591977 4225390.27619988, 1909679.940496549 4225390.45363133, 1909679.995910727 4225390.386053355, 1909682.4859001883 4225392.312689468, 1909689.0491916267 4225397.383265505, 1909698.7802103949 4225405.202130002, 1909706.4142080592 4225411.488990434, 1909709.927621795 4225414.9766577, 1909712.9694750428 4225418.257132446, 1909715.2076520834 4225420.973424738, 1909717.2474482057 4225423.670177285, 1909718.074569119 4225424.921220824, 1909720.1254356608 4225428.013685972, 1909721.3255087489 4225429.8891133275, 1909722.332324212 4225431.623501412, 1909723.239212238 4225433.391261618, 1909724.5277295976 4225436.519022397, 1909726.9883097708 4225443.771535017, 1909728.4777626034 4225448.040234151, 1909730.2348565278 4225453.265611143, 1909734.3744308532 4225466.141577319, 1909737.052980738 4225474.724580203, 1909740.8785789341 4225486.248436117, 1909743.0704442388 4225492.196895241, 1909744.7460763247 4225496.1837569475, 1909745.700195627 4225498.3968778765, 1909746.4322234313 4225500.172045113, 1909747.7637462744 4225502.9380469, 1909748.0830367007 4225503.600958167, 1909748.7436679478 4225504.915344774, 1909749.0692377717 4225505.579621959, 1909751.7323463087 4225511.022278737, 1909754.429384876 4225515.897452295, 1909756.0635538308 4225518.78142736, 1909757.7905381543 4225521.780140578, 1909760.0461514 4225525.63394323, 1909760.9180417901 4225527.087798002, 1909762.3903398886 4225529.46619212, 1909763.821834374 4225531.782969953, 1909767.8762264214 4225537.780936417, 1909768.064781509 4225538.059957489, 1909768.1538495442 4225538.1815521205, 1909770.9150311593 4225541.959035855, 1909773.5337179236 4225545.165806897, 1909775.5936846503 4225547.684501451, 1909777.5858132248 4225550.2065277975, 1909777.988739496 4225550.677815126, 1909778.3619657701 4225551.113187061, 1909780.3891764928 4225553.278381119, 1909782.06126067 4225555.259892614, 1909785.8489567987 4225560.228904542, 1909796.4399039666 4225577.46913232, 1909799.720702291 4225583.055510013, 1909819.3096100704 4225615.242216192, 1909822.9219507242 4225621.227364434, 1909830.20972889 4225632.853805114, 1909832.5852515115 4225636.284818619, 1909835.819431315 4225640.818286618, 1909838.0209294371 4225643.706475553, 1909842.5973861185 4225649.128097544, 1909848.0231639608 4225655.091066071, 1909853.747815173 4225660.673420847, 1909857.2046898373 4225663.666454992, 1909862.0619032609 4225667.52111698, 1909862.7228904348 4225668.029292427, 1909862.9876531751 4225668.235095775, 1909866.085523994 4225670.459943359, 1909870.6000543658 4225673.578342115, 1909880.9714420787 4225679.916926451, 1909888.0295869499 4225683.570526017, 1909892.5315958604 4225685.766071074, 1909904.24309222 4225691.050824414, 1909908.7093415402 4225692.945476849, 1909925.0737696232 4225699.56483423, 1909936.3133377924 4225703.260922606, 1909942.7281715022 4225705.051638724, 1909946.272272098 4225706.067065246, 1909946.7916300416 4225706.224611061, 1909955.2765898644 4225708.734780769, 1909961.2547982251 4225710.48961825, 1909983.733039183 4225717.008704734, 1909992.4703955867 4225719.883842188, 1909998.549119008 4225722.417312549, 1910002.7004232272 4225724.498848986, 1910007.1384320972 4225727.066736603, 1910010.5417106166 4225729.548946217, 1910015.7312857236 4225733.746651415, 1910020.2851615173 4225739.013494758, 1910022.9974528528 4225742.241089028, 1910028.328753373 4225749.18132002, 1910032.9988137805 4225755.416850013, 1910038.3129022035 4225762.901364916, 1910044.3989037345 4225771.708809134, 1910051.242157259 4225782.125057577, 1910061.1331777596 4225797.895635585, 1910065.9890063747 4225806.185851139, 1910069.307575105 4225812.340823181, 1910071.3042168291 4225816.4189492045, 1910073.2824645673 4225820.781448759, 1910075.430459107 4225826.592141687, 1910080.6776791979 4225847.396946337, 1910084.0499390736 4225859.327984413, 1910088.5302490022 4225869.741205574, 1910094.069113153 4225877.084041008, 1910101.9040054334 4225884.876174222, 1910108.512230631 4225889.108083242, 1910114.274790783 4225892.150918974, 1910119.658070112 4225894.618137608, 1910126.731119679 4225897.641493784, 1910127.4542079372 4225897.939650589, 1910127.8146130266 4225898.068872081, 1910129.9644000174 4225898.814800006, 1910133.0168577225 4225899.880037283, 1910135.798798408 4225900.5638380265, 1910138.778333271 4225901.295484948, 1910143.7967623624 4225902.542229574, 1910151.374055318 4225904.33174739, 1910155.8584077733 4225905.387805298, 1910158.7707665656 4225906.070749544, 1910160.675275635 4225906.514282352, 1910161.7852015547 4225906.773622034, 1910161.7897641635 4225906.774688217, 1910161.794323966 4225906.775756501, 1910169.6364106908 4225908.611629432, 1910174.468350075 4225909.796092756, 1910177.7320060122 4225910.512052751, 1910189.0300523015 4225912.952110857, 1910200.4491637473 4225915.719326309, 1910212.0220620742 4225918.576430473, 1910232.5022599525 4225923.640171488, 1910260.1206737692 4225930.2091328725, 1910275.1920663326 4225933.4899223335, 1910283.069794668 4225935.213246978, 1910283.7715475154 4225935.515409339, 1910289.9763219776 4225938.09385242, 1910337.3393280958 4225973.190117063, 1910339.9797094364 4225975.1545320125, 1910351.208517432 4225983.510261588, 1910376.4752112394 4226002.331573199, 1910385.6231253166 4226010.4302085955, 1910411.9715233694 4226035.952960246, 1910426.2596047544 4226048.894669148, 1910447.9272584487 4226069.220116036, 1910463.3777161087 4226083.057947992, 1910467.7172375806 4226086.767917438, 1910472.3557392815 4226089.9522473365, 1910492.3751079333 4226102.062980583, 1910503.3562771082 4226108.541793126, 1910516.2764381168 4226116.452968236, 1910528.3807525602 4226125.421334104, 1910537.576722764 4226132.524343702, 1910551.7010503355 4226143.655606111, 1910576.3450767621 4226163.229206576, 1910581.5056946338 4226167.339514341, 1910584.219971788 4226169.5127728125, 1910586.072886809 4226170.996046898, 1910586.5028356551 4226171.341250762, 1910586.8876990168 4226171.650211579, 1910590.1035412585 4226174.231832878, 1910591.8585438966 4226175.64212592, 1910593.1694120339 4226176.692669423, 1910594.613280822 4226177.854192564, 1910597.0384889373 4226179.79822484, 1910608.4864238044 4226188.989963853, 1910620.4258334804 4226198.640642716, 1910629.408954263 4226205.974145944, 1910629.8286771558 4226206.316801133, 1910630.1647008988 4226206.590960983, 1910630.3006110026 4226206.697303023, 1910630.4959360345 4226206.8452353, 1910632.9240604169 4226208.588773665, 1910634.5763521693 4226209.773731029, 1910638.9082591399 4226212.8852114035, 1910642.4989801568 4226215.465928213, 1910647.2077331422 4226218.845070204, 1910659.5457678211 4226227.482759424, 1910675.5460830492 4226238.657101172, 1910750.8013511403 4226290.192401637, 1910795.0879330589 4226269.590288657, 1910804.7200122762 4226264.995970648, 1910809.1678506467 4226262.607620087, 1910818.9643078838 4226257.224228534, 1910822.4155096905 4226255.365676928, 1910827.9189079106 4226252.047857157, 1910832.6789679625 4226248.827875788, 1910843.4371950245 4226236.638095047, 1910848.9802119439 4226229.587424193, 1910849.247329746 4226229.6837328, 1910849.3860962905 4226229.513890484))'::geometry,'38169','Fontaine','FONTAINE','FON','FTN'),
     (24,'SRID=3945;POLYGON ((1910284.088952414 4230988.255268197, 1910278.9903287324 4230989.568930288, 1910220.0554966081 4231055.967715514, 1910122.6727596107 4231165.9301937595, 1910122.054966396 4231164.866651011, 1910120.5646551037 4231166.557070564, 1910111.483081182 4231145.541908851, 1910099.7185270062 4231121.890974043, 1910086.207994322 4231106.747654561, 1910052.3495546195 4231069.732740719, 1910005.953709566 4231033.864160318, 1909998.2128558867 4231027.246196256, 1909998.070696854 4231027.14277954, 1909997.184062534 4231026.500997211, 1909993.0135538985 4231024.189980727, 1909987.613987852 4231021.224245952, 1909986.9352716496 4231020.646242026, 1909986.4287814419 4231020.259951696, 1909981.8484193657 4231013.804735752, 1909980.4311168506 4231011.606031816, 1909979.3203167745 4231009.361617186, 1909978.307919883 4231006.687256719, 1909970.510444176 4230982.722537817, 1909965.2004644724 4230977.450795795, 1909964.626563764 4230976.881190532, 1909962.1982247606 4230974.024222522, 1909961.350372578 4230973.028132775, 1909960.8508301845 4230972.2638351405, 1909959.4965735537 4230968.534422783, 1909957.1989437805 4230962.913523249, 1909956.9617012914 4230962.602163282, 1909955.875405298 4230961.2258308055, 1909954.0932228058 4230959.972025575, 1909946.4672576068 4230957.356395565, 1909945.9017733596 4230957.1205982985, 1909943.9322485065 4230956.0770341735, 1909941.801000486 4230955.043330186, 1909940.6842654545 4230954.239965744, 1909940.1147298792 4230953.745777288, 1909938.009321143 4230950.89997589, 1909937.147380419 4230948.622255707, 1909936.4856534798 4230945.539251961, 1909935.9634618184 4230941.995919165, 1909935.0430969181 4230934.765398104, 1909934.3660002768 4230926.786351892, 1909932.2280187355 4230920.721403263, 1909931.6340133636 4230919.616761694, 1909931.1179501715 4230918.707831019, 1909930.1394544211 4230916.973461675, 1909924.2452281865 4230908.973112168, 1909923.3653609788 4230906.705450911, 1909922.8420000002 4230905.211217392, 1909921.4763306156 4230900.727419471, 1909920.4211803868 4230898.105728325, 1909919.6670608106 4230897.199689189, 1909915.3948881237 4230892.990036103, 1909911.9663340966 4230889.81410194, 1909908.9601248316 4230886.874619214, 1909894.9200892502 4230873.651579372, 1909884.8687406403 4230864.004684163, 1909881.5657607904 4230861.290866372, 1909880.826007306 4230860.684065761, 1909879.675674632 4230859.770204044, 1909877.1855410277 4230857.925442325, 1909875.9775456004 4230856.666329454, 1909858.1148970758 4230839.3078770945, 1909857.7659691172 4230838.98625078, 1909855.9311975623 4230837.378173962, 1909841.18980146 4230824.460386916, 1909817.2343476075 4230803.827364455, 1909816.262950915 4230802.92791663, 1909799.8819434212 4230786.740787975, 1909794.2847288912 4230782.375572354, 1909779.1272194202 4230769.806631709, 1909776.0387750054 4230767.452112942, 1909756.4814194888 4230750.0979580805, 1909753.653815184 4230748.184704491, 1909748.8994604247 4230745.0926238205, 1909745.674717386 4230743.305979428, 1909740.194881036 4230740.51403749, 1909734.0128004432 4230737.500661522, 1909732.2482478751 4230736.705021587, 1909726.1489929024 4230734.398749995, 1909724.8255944243 4230733.992827039, 1909713.8709320063 4230731.703569047, 1909707.3107640436 4230731.761429706, 1909704.9631979624 4230731.812358309, 1909703.0434789408 4230732.106630265, 1909700.0664617694 4230732.562974478, 1909688.977958934 4230734.117013917, 1909685.00182508 4230734.4644391835, 1909669.2675265537 4230735.004312999, 1909664.5768912751 4230735.3012944665, 1909660.3438956393 4230735.762660614, 1909657.6920518624 4230736.165136418, 1909645.057407616 4230738.177121121, 1909633.354251014 4230740.638760113, 1909589.5090841253 4230748.595436899, 1909571.6193740277 4230751.965376688, 1909566.5786363673 4230752.822272726, 1909566.3414980532 4230752.863054475, 1909555.0107556875 4230754.525816353, 1909550.1685844308 4230755.2606807165, 1909529.511888243 4230759.444919718, 1909524.303904055 4230760.513147078, 1909522.3626321969 4230760.846516853, 1909514.2421491228 4230762.087408357, 1909512.4874232868 4230762.356795527, 1909509.2666526916 4230762.859755623, 1909508.7223263928 4230762.954629708, 1909502.6978007562 4230764.00774051, 1909483.3939798158 4230767.840525249, 1909474.2193822125 4230769.63040951, 1909466.1005058244 4230770.938087973, 1909449.6028002515 4230775.672703474, 1909445.3392045493 4230776.908095494, 1909430.3589915002 4230780.543973217, 1909429.7386952809 4230780.694899734, 1909422.0718108534 4230784.694641709, 1909422.9651461272 4230782.487843827, 1909421.4678367176 4230782.888025622, 1909428.4704033725 4230768.888257662, 1909429.036056686 4230767.745757257, 1909428.9535439985 4230767.694759832, 1909428.9767484933 4230767.6374379825, 1909424.7534872994 4230765.098891456, 1909423.3241688188 4230764.2432716, 1909416.7219915895 4230760.409729946, 1909404.9512695957 4230753.577064654, 1909308.1862500042 4230698.041249994, 1909272.5398298705 4230677.500185915, 1909216.1076901 4230644.69008009, 1909203.3903272392 4230636.733808423, 1909200.784079686 4230635.247765766, 1909197.9846095329 4230633.676684176, 1909194.2007439171 4230631.641189265, 1909190.415619331 4230629.607921776, 1909187.296299569 4230627.979699333, 1909183.3771428624 4230625.7832919285, 1909174.7345135014 4230621.180724898, 1909159.2372963952 4230611.767885858, 1909097.6358358692 4230573.969704421, 1909093.5128789833 4230571.506495264, 1909078.7366526232 4230562.228547002, 1909060.2418784017 4230550.529479833, 1909045.5772277014 4230541.074623033, 1909042.3085768856 4230538.9509768635, 1909039.2100384056 4230536.925047416, 1909037.0064835192 4230535.49110609, 1909027.4950206992 4230529.892787362, 1909017.700774269 4230524.099168898, 1909002.1389656558 4230514.903626792, 1908969.577716033 4230495.439459899, 1908969.17 4230495.08, 1908967.2563998902 4230489.760575328, 1908967.2412057188 4230489.698977732, 1908926.6838947965 4230465.429623531, 1908899.1909953644 4230449.018610273, 1908877.0702580556 4230435.729285863, 1908868.4573748242 4230430.528621997, 1908802.1798004904 4230390.3859941205, 1908741.6970192306 4230353.918891701, 1908702.9542833045 4230330.346917768, 1908685.2817401015 4230319.6272537615, 1908611.6146710417 4230275.402208994, 1908537.0986185279 4230230.629667119, 1908536.3933085075 4230230.177832104, 1908532.171654309 4230227.724109657, 1908480.011340688 4230196.531696741, 1908430.9904996634 4230167.207670097, 1908428.7814565604 4230165.891765808, 1908382.9450917789 4230248.375738595, 1908330.7035123156 4230342.631408618, 1908291.0541497988 4230413.444645751, 1908229.7292225247 4230523.345482499, 1908166.923182624 4230635.6977784, 1908133.0238104116 4230695.722238505, 1908099.3154310095 4230749.252403037, 1908058.5684716478 4230809.292226714, 1908043.5574999854 4230831.179999998, 1908029.5441639079 4230850.777098198, 1908000.3428744473 4230889.684959557, 1907973.065951353 4230924.954988888, 1907950.9791842687 4230949.789475785, 1907853.0033225112 4231049.189344632, 1907837.3969866817 4231064.875176471, 1907823.1165013325 4231079.359027107, 1907815.4468360196 4231087.153342962, 1907719.3468313983 4231182.687643739, 1907675.210643458 4231227.125255348, 1907627.7728974402 4231274.973796337, 1907606.798981473 4231296.493859421, 1907565.426858416 4231338.677896494, 1907554.3247398366 4231349.529142941, 1907501.5931376505 4231401.264524291, 1907465.4129167735 4231436.764865988, 1907439.2718117114 4231463.146435707, 1907421.0169939308 4231482.019402834, 1907401.0093899872 4231503.205367059, 1907387.8367401923 4231516.656575718, 1907375.9993436693 4231527.651726957, 1907374.8679568954 4231528.686634422, 1907368.9719228598 4231534.064731336, 1907368.1885171882 4231534.769444047, 1907363.100916034 4231539.33771985, 1907343.9040503304 4231556.484714042, 1907337.061269497 4231562.1753426, 1907325.2245750735 4231571.946068915, 1907310.5953554537 4231583.349434201, 1907305.070657895 4231587.574382591, 1907298.435328351 4231592.153609668, 1907290.143605423 4231597.931570583, 1907271.3633417448 4231610.068611026, 1907262.7286201573 4231615.5635513645, 1907246.209027813 4231625.907258929, 1907231.323431174 4231635.1782489875, 1907228.3759109313 4231637.082115384, 1907204.9230642715 4231652.56291751, 1907184.1912398783 4231666.339268724, 1907171.6985399798 4231674.676131073, 1907165.2285399798 4231678.969251645, 1907158.0476206075 4231683.579139291, 1907154.63 4231685.58, 1907154.97 4231685.77, 1907264.05 4231737.26, 1907266.66 4231738.48, 1907270.86 4231740.45, 1907272.37 4231741.16, 1907275.3 4231742.52, 1907292.75 4231750.7, 1907327.69 4231767.67, 1907332.86 4231770.15, 1907371.79 4231788.81, 1907381.26 4231793.31, 1907391.76 4231798.31, 1907405.85 4231805.01, 1907415.83 4231809.78, 1907418.11 4231810.87, 1907418.93 4231811.25, 1907422.51 4231812.96, 1907440.62 4231821.62, 1907455.06 4231828.52, 1907458.02 4231829.92, 1907461.8 4231831.73, 1907465.47 4231833.47, 1907469.16 4231835.22, 1907471.79 4231836.48, 1907474.42 4231837.42, 1907508.05 4231854.04, 1907550.54 4231875.11, 1907560.39 4231880.01, 1907630.42 4231913.35, 1907696.59 4231944.64, 1907708.23 4231950.03, 1907716.15 4231953.71, 1907739.03 4231964.33, 1907791.83 4231989.33, 1907844.27 4232014.5, 1907860.48 4232022.4, 1907876.98 4232030.43, 1907894.24 4232038.34, 1907912.86 4232046.53, 1907917.22 4232048.29, 1907926.57 4232051.12, 1907931.07 4232052.19, 1907949.54 4232056.17, 1907968.82 4232061.47, 1907987.74 4232065.99, 1907992.64 4232066.87, 1908002.87 4232068.14, 1908008.38 4232068.3, 1908013.23 4232068.3, 1908029.22 4232067.56, 1908049.15 4232066.25, 1908095.98 4232065.35, 1908114.68 4232065.42, 1908119.65 4232065.06, 1908130.27 4232063.56, 1908135.32 4232062.72, 1908140.37 4232061.66, 1908154.7 4232059.18, 1908159.58 4232058.24, 1908173.21 4232056.88, 1908193.96 4232057.16, 1908202.34 4232057.28, 1908203.32 4232057.29, 1908222.93 4232057.63, 1908227.63 4232057.8, 1908239.95 4232061, 1908248.64 4232063.04, 1908270.48 4232068.99, 1908286.36 4232069.88, 1908289.91 4232070.34, 1908294.57 4232071.08, 1908304.73 4232073.27, 1908309.57 4232074.17, 1908324.93 4232079.37, 1908345.3 4232086.35, 1908371.31 4232096.08, 1908392.35 4232102.8, 1908412.9 4232110.04, 1908438.8 4232118.87, 1908476.3851835963 4232135.412311613, 1908477.08 4232135.69, 1908514.45 4232153.09, 1908528.68 4232159.53, 1908535.77 4232162.74, 1908608.28 4232195.53, 1908634.64 4232207.46, 1908636.69 4232208.4, 1908644.47 4232212.02, 1908649.69 4232214.3, 1908651.83 4232214.86, 1908659.46 4232215.93, 1908704.82 4232235.31, 1908712.73 4232238.73, 1908714.29 4232241.73, 1908714.55 4232242.23, 1908721.79 4232247.58, 1908726.89 4232251.33, 1908736.19 4232328.13, 1908752.73 4232453.37, 1908764.93 4232504.75, 1908771.03 4232678.84, 1908781.58 4232796.16, 1908801.71 4232831.7, 1908812.34 4232912.66, 1908816.94 4232945.52, 1908838.49 4232945.76, 1908858.12 4232931.18, 1908863.04 4232918.92, 1908857.97 4232911.05, 1908857.62 4232906.35, 1908871.69 4232889.89, 1908883.26 4232859.41, 1908883.34 4232856.9, 1908919.3 4232891.42, 1908918.59 4232894.97, 1908917.67 4232933.24, 1908896.94 4232978.9, 1908897.49 4232985.33, 1908918.64 4232997.95, 1908921.83 4233004.58, 1908922.77 4233006.54, 1908920.03 4233015.79, 1908952.13 4233055.42, 1908958.43 4233063.41, 1909062.56 4233195.49, 1909081.93 4233220.84, 1909084.06 4233223.64, 1909086.51 4233226.83, 1909087.65 4233228.33, 1909114.97 4233264.94, 1909117.23 4233271.3, 1909120.54 4233279.57, 1909123.81 4233287.72, 1909130.48 4233304.52, 1909131.55 4233305.45, 1909162.35 4233383.64, 1909182.34 4233434.89, 1909186.5166654652 4233430.212559784, 1909207.4319046512 4233347.421190084, 1909218.465829061 4233302.306440648, 1909270.9418562886 4233184.334460671, 1909294.2048176564 4233131.821151642, 1909296.4311415106 4233128.739473685, 1909360.031473196 4233070.626178993, 1909399.6690015423 4233094.821368611, 1909464.332034776 4233133.171769957, 1909482.4373240361 4233158.895254646, 1909497.197559603 4233182.676676922, 1909518.497744919 4233219.283847319, 1909533.3469374133 4233258.48366255, 1909533.9743539873 4233256.711656568, 1909534.5010236234 4233257.881586827, 1909542.9221649359 4233231.440448903, 1909543.97853662 4233228.154943461, 1909544.5126724748 4233226.605261197, 1909546.0681530505 4233221.842016618, 1909556.395870156 4233190.127208682, 1909570.8485583519 4233143.064859664, 1909571.7450935212 4233143.691519451, 1909572.5231892627 4233141.21315839, 1909636.6703796894 4233209.367564223, 1909736.5257228666 4233317.457780666, 1909736.4314227982 4233314.536934277, 1909737.8992263717 4233316.097813813, 1909732.2334672417 4233170.952156599, 1909671.5970850068 4232921.480323828, 1909633.3410806467 4232854.410669424, 1909589.8183544914 4232759.134372149, 1909568.8521407358 4232690.931416993, 1909570.5812439523 4232689.906526047, 1909570.1567585568 4232688.6249442715, 1909683.8281712497 4232622.0507390015, 1909776.7342759345 4232636.003772733, 1910266.420565622 4232732.088105638, 1910535.691297043 4232782.685895463, 1910535.491597691 4232780.49856074, 1910539.6317324808 4232781.249345134, 1910512.5652125224 4232460.897499996, 1910489.5859412616 4232193.050728732, 1910482.0293724593 4232163.181042606, 1910446.6499999936 4232028.094999993, 1910357.702499946 4231795.629999883, 1910338.7256141223 4231657.104343039, 1910283.6848525316 4231279.938575361, 1910283.7309102172 4231236.228721502, 1910284.088952414 4230988.255268197))'::geometry,'38170','Le Fontanil-Cornillon','LE FONTANIL-<br>CORNILLON','FTC','FTC');
INSERT INTO urba_plui_ecriture.ref_limites_communales (ogc_fid,geom,code_insee,nom,nom_etiquette,nom_abv,trigram) VALUES
     (7,'SRID=3945;POLYGON ((1920639.9917250706 4225184.269089062, 1920682.3629856997 4225098.326455584, 1920687.4641445125 4225088.119493985, 1920712.1410545232 4225038.918584255, 1920713.3366929628 4225036.445043142, 1920716.7478248489 4225029.705631223, 1920735.680609134 4224992.4219871145, 1920758.6399024795 4224947.626181458, 1920776.0981947798 4224913.037836432, 1920776.3637601868 4224913.319794766, 1920776.4740098922 4224913.436850009, 1920796.8167074102 4224873.115407766, 1920806.8242790243 4224853.483494975, 1920806.6420362822 4224853.351291208, 1920806.7650795265 4224853.077196692, 1920799.202123146 4224847.809231011, 1920799.263121858 4224847.6752437195, 1920799.0657410887 4224847.54373817, 1920802.1275152874 4224840.829716233, 1920806.6502723119 4224831.44892924, 1920813.2547473626 4224816.530668805, 1920817.1831463631 4224807.376995493, 1920818.8635776408 4224803.253200271, 1920826.2206085653 4224783.958566017, 1920828.1640900213 4224779.067501897, 1920841.3528130807 4224745.6754347505, 1920844.8818443816 4224736.5273309685, 1920849.5808234399 4224724.201052775, 1920852.5798824804 4224716.797545694, 1920855.1591813127 4224710.435904534, 1920857.577161424 4224704.877356904, 1920858.4447554646 4224702.879531734, 1920859.0566666059 4224701.456666652, 1920859.4340701196 4224700.715205822, 1920860.5308940185 4224698.562652354, 1920862.1836109841 4224695.314841621, 1920865.9362260168 4224689.025642999, 1920867.089010935 4224688.732080522, 1920869.8289510247 4224688.035975487, 1920876.396956244 4224686.478560106, 1920880.7030331877 4224685.336380342, 1920882.3526879023 4224684.886339058, 1920884.893558246 4224684.192851813, 1920885.6580153594 4224683.985065212, 1920886.2493496523 4224683.819759745, 1920886.979588277 4224683.591340312, 1920895.5785844112 4224680.913165535, 1920904.0339805633 4224678.585181959, 1920925.0069390908 4224674.52994858, 1920929.1799999543 4224673.636666583, 1920930.7281364845 4224673.18166702, 1920934.0905790299 4224669.672097026, 1920937.1905085794 4224664.488112909, 1920952.8175000048 4224658.366249994, 1920958.941249985 4224646.818749995, 1920975.3674999725 4224587.741249971, 1920977.2090892862 4224570.9101017015, 1920979.9150022443 4224549.907414221, 1920990.3526417848 4224519.183723214, 1920991.7764625226 4224514.870283359, 1920992.1974945834 4224511.632991377, 1920993.7699999646 4224491.008750019, 1921001.0538081336 4224464.401386072, 1920998.7551008458 4224460.506886233, 1920995.8774999403 4224452.7412500745, 1920986.8237499797 4224458.638750042, 1920961.9829250767 4224470.174979797, 1920942.73374998 4224467.042500033, 1920906.3074999694 4224439.491250031, 1920860.9424999743 4224403.426250037, 1920788.6149999734 4224349.167500032, 1920730.3878145902 4224299.525328781, 1920727.767119439 4224297.158991337, 1920691.6670181525 4224259.073519084, 1920686.001996079 4224253.992761263, 1920681.6718114677 4224249.993052032, 1920647.7331891218 4224223.791890683, 1920624.8394939273 4224206.822935223, 1920615.8501151223 4224198.940622495, 1920544.9084836284 4224145.384750869, 1920537.9109125393 4224137.795592426, 1920516.9516817222 4224106.563303708, 1920506.3180464676 4224090.027201295, 1920491.0066635099 4224074.4550051, 1920434.2559333383 4224014.4721506685, 1920432.1631141452 4224016.667632428, 1920426.7788713295 4224011.038728531, 1920378.079510859 4224064.917433194, 1920352.5873285998 4224052.138479975, 1920288.9134952393 4224020.772374507, 1920249.0536690508 4224001.235664654, 1920201.8374506128 4223978.027042859, 1920167.4074169823 4223960.966568024, 1920139.6323445614 4223947.42891258, 1920137.7881491 4223946.053573265, 1920136.1939785029 4223944.863166268, 1920114.6788696793 4223934.376675264, 1920085.8366671524 4223920.243332939, 1920040.4196158764 4223898.089307039, 1920004.8765587774 4223880.719546221, 1919978.8708201118 4223867.960224507, 1919899.3333342136 4223828.833332301, 1919839.681684272 4223800.0216562245, 1919828.2977801517 4223790.681088361, 1919796.0389131147 4223763.70155696, 1919759.4497570312 4223733.151247924, 1919738.8537039757 4223715.9305520095, 1919727.8429915095 4223706.724704474, 1919717.701135474 4223698.183144894, 1919660.0205026427 4223649.529403428, 1919625.3845746103 4223620.27810018, 1919580.8748012283 4223582.899629254, 1919575.710300278 4223578.5666082045, 1919568.7032036174 4223572.876732669, 1919563.7930144325 4223568.914176362, 1919555.971304867 4223562.5867021205, 1919462.054470007 4223485.753924563, 1919455.6809643477 4223416.092861043, 1919455.2335470035 4223412.064624341, 1919454.430804656 4223404.184053645, 1919453.2242137627 4223392.09794766, 1919451.7026399947 4223373.912986809, 1919449.282459514 4223351.1591801625, 1919449.099025976 4223344.19804724, 1919449.0150297573 4223341.7982467795, 1919447.6028884596 4223327.5206686845, 1919437.4218835302 4223218.35033039, 1919436.2067206479 4223199.37, 1919426.2503831068 4223069.6836177055, 1919434.9966525827 4223050.7599941725, 1919478.8599825162 4222964.423329934, 1919502.8349868872 4222916.07, 1919563.2888175831 4222791.041630882, 1919569.515 4222777.37, 1919588.1971135233 4222743.420213609, 1919614.8333350332 4222727.823336854, 1919942.8579045061 4222554.664240687, 1920115.0226499494 4222461.964145786, 1920143.1965024692 4222448.1273479415, 1920273.2938803195 4222378.602040925, 1920273.1462063554 4222378.159374588, 1920275.8638444718 4222376.705122856, 1920233.6370338053 4222243.727146072, 1920237.6625464296 4222242.988689746, 1920236.4211452047 4222238.960199448, 1920285.3849963013 4222230.538496845, 1920362.2566147994 4222194.547459494, 1920359.4538652922 4222188.634290233, 1920357.39 4222184.28, 1920265.33 4222035.89, 1920254.25 4221984.71, 1920252.96 4221978.86, 1920227.43 4221917.57, 1920224.34 4221910.22, 1920208.97 4221856.13, 1920203.08 4221835.64, 1920202.63 4221832.09, 1920183.53 4221703.27, 1920184.8300000078 4221698.327499982, 1920144.9669441811 4221722.985057544, 1920044.0506949087 4221746.455426362, 1919963.2863055153 4221752.793611193, 1919949.6263994486 4221764.429125946, 1919944.2419895253 4221768.819284231, 1919927.9171452937 4221775.110225677, 1919912.00033403 4221781.82969636, 1919832.8449696328 4221704.023147782, 1919622.4935394642 4221752.779294123, 1919565.3912593024 4221684.210501712, 1919537.1349392778 4221648.781639663, 1919512.0914072052 4221618.8910765, 1919509.2993966753 4221616.926163995, 1919507.0526399352 4221619.3292474365, 1919497.5111143563 4221632.496012531, 1919493.8678183858 4221636.992503897, 1919491.952411453 4221639.355184383, 1919490.3296466772 4221640.685251422, 1919483.9373872255 4221642.315885259, 1919482.8335895124 4221642.502745447, 1919476.4488183695 4221643.590045601, 1919471.9890461934 4221644.324261198, 1919463.7824099802 4221645.284751075, 1919463.1383712243 4221645.294209865, 1919462.6568081337 4221645.309341441, 1919461.2365561996 4221645.131383236, 1919457.0816429167 4221644.634254661, 1919452.196924383 4221644.034078145, 1919433.2158310257 4221640.666664801, 1919412.5374698811 4221635.98358057, 1919404.0943957441 4221634.049480836, 1919392.2980060766 4221629.264922309, 1919362.3721870254 4221616.146372357, 1919354.2979837733 4221611.359995043, 1919326.6627044296 4221593.451298307, 1919303.8908256947 4221579.730829913, 1919286.9530285446 4221567.746505659, 1919247.3591698536 4221535.452596749, 1919236.795521002 4221527.607931608, 1919194.5532530672 4221503.480928537, 1919180.482601879 4221494.306846576, 1919172.765465613 4221487.835587035, 1919162.1376417351 4221475.568431169, 1919096.6050000004 4221464.424168961, 1919051.6922230066 4221457.136859841, 1919015.6337478778 4221451.350376672, 1919012.534942236 4221467.7257648995, 1918985.608873137 4221584.204999818, 1918976.530466199 4221624.242122143, 1918955.3624999982 4221717.219999996, 1918953.8886007343 4221724.3988045575, 1918942.987793087 4221771.176176246, 1918910.2386781734 4221912.4427950205, 1918902.2239907107 4221948.091870674, 1918846.8044138162 4222188.820883149, 1918808.7079514647 4222356.199578478, 1918768.3075038742 4222531.608971273, 1918755.0775000008 4222589.659999999, 1918734.2375000026 4222680.4575000005, 1918724.125495913 4222724.391914822, 1918704.1309588533 4222813.928897519, 1918697.5893100167 4222835.111951735, 1918694.620831034 4222845.537191678, 1918691.0890381294 4222850.209650266, 1918685.8515223193 4222856.946883322, 1918681.8372591333 4222868.225848393, 1918674.896328163 4222897.070343089, 1918669.5137499992 4222912.658750004, 1918655.139045935 4222931.121415746, 1918638.7050777515 4222951.177950182, 1918634.5733622462 4222956.89245062, 1918630.31165615 4222964.224008636, 1918629.3999019628 4222966.042028584, 1918628.9460025674 4222966.985888803, 1918623.3196688225 4222981.832487099, 1918622.3052360178 4222984.399985206, 1918618.767120264 4222992.892588606, 1918617.6345371068 4222995.875555708, 1918617.0886997846 4222997.173550899, 1918616.2861231016 4222999.107170158, 1918612.0354447763 4223007.008524164, 1918610.6982511322 4223009.201935447, 1918594.7044399262 4223035.571972602, 1918590.9599999937 4223041.090000008, 1918584.1522166133 4223048.742787268, 1918577.2761370013 4223054.29693919, 1918658.5636878693 4223202.800434771, 1918677.3286842557 4223236.92360173, 1918616.697807436 4223312.6117747845, 1918608.5972779098 4223322.659848668, 1918599.7421709858 4223333.541611475, 1918583.4660429463 4223354.389608329, 1918574.6579890861 4223364.955822369, 1918525.319471197 4223425.675891863, 1918515.8047298533 4223436.345328057, 1918507.6091022757 4223446.406770306, 1918498.6748156992 4223457.636626857, 1918484.6769271474 4223475.3792443555, 1918475.4601891902 4223487.172443501, 1918466.2053272538 4223498.919099254, 1918465.6989125255 4223499.571702133, 1918464.7466399968 4223500.812594764, 1918462.598291047 4223503.553051399, 1918459.8242618262 4223507.028657166, 1918436.9820174337 4223536.2207890125, 1918409.528779646 4223571.327652328, 1918420.3834537705 4223577.861666688, 1918417.41 4223583.8, 1918410.9884301326 4223593.676949066, 1918405.3625608413 4223602.330039448, 1918400.7831499893 4223609.375444066, 1918388.2949997974 4223628.850926136, 1918369.9066142903 4223658.01598346, 1918356.82 4223678.81, 1918352.0274794602 4223677.261170006, 1918342.123370142 4223674.060337594, 1918337.9986661766 4223672.727401444, 1918333.6172399381 4223671.316783203, 1918333.5152925877 4223671.283930603, 1918329.3430870364 4223681.305232784, 1918343.0435352244 4223700.156692698, 1918354.1532768123 4223715.414569813, 1918361.6957235583 4223723.996189104, 1918376.479842212 4223740.2173671685, 1918379.0375186699 4223742.69986996, 1918403.7192954973 4223770.550500252, 1918406.14 4223768.02, 1918437.11 4223799.45, 1918437.2133799098 4223799.849514274, 1918438.5893720798 4223805.167052608, 1918438.8457700477 4223806.15689564, 1918439.6741168092 4223809.211452854, 1918439.7786152444 4223809.596399141, 1918443.74 4223824.2, 1918445.64 4223850.52, 1918444.56 4223868.34, 1918441.07 4223892.5, 1918432.1933957487 4223937.9925354505, 1918429.9781072885 4223944.849860464, 1918421.746794484 4223968.199901044, 1918419.2216245094 4223975.144696385, 1918413.8418309907 4223989.967511139, 1918407.8673722846 4224005.381002452, 1918400.9512145864 4224023.436250025, 1918390.9386184295 4224047.900971676, 1918389.3229868694 4224051.208639383, 1918387.04834514 4224055.607808712, 1918377.3364307208 4224070.879332823, 1918377.683602175 4224071.067398565, 1918376.9252431812 4224072.248339145, 1918449.1917554347 4224109.932836512, 1918470.2425323639 4224120.944207376, 1918445.5581462036 4224154.542112194, 1918443.1667527058 4224157.109480988, 1918442.5535274865 4224157.787584957, 1918439.823916731 4224161.447447932, 1918431.110274541 4224173.456897774, 1918426.65 4224178.99, 1918415.3177807524 4224194.201181691, 1918387.5680381698 4224231.474440144, 1918355.9075653793 4224274.001211752, 1918321.036859531 4224320.900294497, 1918282.6367011918 4224372.175712815, 1918236.2758518057 4224434.20236587, 1918205.4904051004 4224475.39043587, 1918152.0482681035 4224546.545507237, 1918125.7295214648 4224581.752403018, 1918110.247541672 4224602.452920935, 1918096.24 4224621.28, 1918095.72 4224622.52, 1918094.897452732 4224624.09654893, 1918094.88 4224624.13, 1918094.1 4224625.5, 1918093.49 4224626.42, 1918053.4199999338 4224695.860000127, 1918045.2019421763 4224710.925418111, 1917986.016853181 4224813.451380147, 1917963.1499122488 4224853.000424499, 1917894.2902628907 4224938.748915156, 1917781.1274265922 4224918.961341191, 1917685.109488766 4225087.25602842, 1917645.0287665846 4225157.726252953, 1917631.0576722655 4225182.346334544, 1917630.4513392262 4225183.299816575, 1917629.154780547 4225185.372760918, 1917607.3467874625 4225224.1292591235, 1917595.115625693 4225245.681504532, 1917589.1169292633 4225256.269348745, 1917585.2223444157 4225263.14761048, 1917581.736257423 4225269.273173471, 1917557.2653565994 4225312.75580497, 1917511.6939925905 4225393.332635079, 1917510.6974307054 4225395.486692117, 1917509.6324754097 4225397.707345844, 1917483.175553966 4225444.600956822, 1917422.590711658 4225551.633230643, 1917400.0999569534 4225591.978036433, 1917384.387107567 4225620.570734401, 1917379.438453133 4225629.950475139, 1917384.7453486444 4225633.864657984, 1917393.1415628504 4225639.915395198, 1917402.4964516188 4225646.658826341, 1917423.449134318 4225661.3055610685, 1917430.4942040246 4225666.204046517, 1917435.2402739427 4225669.473491554, 1917438.0585679011 4225671.410390916, 1917440.3759012276 4225673.0088550495, 1917442.2642596406 4225674.30996734, 1917442.890515212 4225674.740927583, 1917443.277709844 4225675.007394437, 1917443.6203981678 4225675.244291607, 1917443.78759453 4225675.358893016, 1917443.9467356082 4225675.46848011, 1917444.2474804106 4225675.6756769, 1917446.4257284026 4225677.176055699, 1917447.5700131913 4225677.973698821, 1917448.655749806 4225678.734638054, 1917453.251711866 4225681.955275765, 1917456.0371226654 4225683.909923156, 1917459.1039402203 4225686.051252243, 1917464.8511659054 4225690.121767249, 1917467.9306261868 4225692.292025463, 1917469.177525774 4225693.166684747, 1917475.9555427108 4225697.959022057, 1917483.362908033 4225703.26876815, 1917484.914136579 4225704.391380309, 1917485.0066387472 4225704.456615756, 1917485.145213929 4225704.560706839, 1917485.2771421892 4225704.658652215, 1917485.5598314537 4225704.866799348, 1917486.2721078957 4225705.390632116, 1917486.643819198 4225705.662647582, 1917486.927617047 4225705.871564984, 1917487.2534704576 4225706.113611054, 1917487.4846552042 4225706.281711669, 1917487.8919020803 4225706.5855460195, 1917488.253489015 4225706.853869987, 1917488.509786918 4225707.04363469, 1917488.8232585492 4225707.276940203, 1917489.7157474745 4225707.941494534, 1917489.7527567234 4225707.9687325815, 1917489.7854327804 4225707.993155668, 1917489.913151873 4225708.088010062, 1917497.483714604 4225713.715298293, 1917502.49335197 4225717.558401284, 1917522.043614724 4225732.445824358, 1917524.8412982062 4225734.596360862, 1917527.7705390595 4225736.899415162, 1917532.120275111 4225740.378514449, 1917534.1567552094 4225742.02498055, 1917536.733240561 4225744.223960572, 1917540.4976745457 4225747.4431597, 1917543.638329475 4225750.238531122, 1917547.8754226544 4225754.00965137, 1917554.016599781 4225760.065239306, 1917562.3565858528 4225768.465522871, 1917565.9177335291 4225772.345956859, 1917567.8496819166 4225774.453003968, 1917571.8785146044 4225779.16314751, 1917574.3596437008 4225782.063754274, 1917576.3604617822 4225784.535423831, 1917582.6404187959 4225793.335193673, 1917590.9741782215 4225805.423512289, 1917597.0942365115 4225814.576551966, 1917598.723330034 4225817.200957582, 1917602.8988861244 4225824.455164327, 1917613.8896024846 4225843.620552866, 1917620.9435964131 4225855.794546797, 1917627.8883849722 4225867.666650758, 1917629.897205918 4225871.107752234, 1917632.465846006 4225875.501737873, 1917633.0521195715 4225876.505557143, 1917633.7249030008 4225877.640355026, 1917642.8403175583 4225893.070762909, 1917645.1487780432 4225896.595228035, 1917649.6812121219 4225903.111887934, 1917657.4018685764 4225913.768030636, 1917666.3709910146 4225924.943949577, 1917668.3575340977 4225927.348282213, 1917678.3032338058 4225939.027034412, 1917699.4108019874 4225961.095237636, 1917717.2762065178 4225980.564417039, 1917722.0938769353 4225984.708970748, 1917724.0756299065 4225986.281904421, 1917728.91981907 4225989.820038785, 1917733.39343989 4225992.718612382, 1917741.5353289829 4225997.650485846, 1917758.0214018328 4226006.731591595, 1917779.7457529712 4226016.647938677, 1917787.2914395132 4226019.689463421, 1917817.0403399963 4226029.233043422, 1917820.9137605433 4226030.473324822, 1917828.465823706 4226032.974680407, 1917835.1697936307 4226035.197019111, 1917839.7577798928 4226036.679908496, 1917848.1999654553 4226039.256782562, 1917851.6529672313 4226040.27948656, 1917872.964009465 4226046.0275514675, 1917887.1838381542 4226049.4742825255, 1917893.0126655768 4226050.805503374, 1917903.3024443614 4226052.810845136, 1917913.1251587037 4226054.18398383, 1917921.155021137 4226054.620297957, 1917935.6293890304 4226054.529394759, 1917948.6142766261 4226054.313064382, 1917963.1551841989 4226054.4349740995, 1917973.6103846454 4226055.143999145, 1917977.51420214 4226055.124736892, 1917991.3305988663 4226054.390674371, 1917997.8227567656 4226053.529726943, 1918010.027963551 4226051.920388769, 1918024.0540029812 4226049.26023839, 1918025.52702495 4226048.95867751, 1918028.9097134485 4226048.077816008, 1918042.1687500228 4226044.446249976, 1918043.6584142763 4226044.042128695, 1918061.9415188157 4226038.608767595, 1918062.0946724126 4226038.5598274125, 1918066.295041072 4226037.214622185, 1918072.5461007117 4226034.99538206, 1918073.851154384 4226034.508821694, 1918077.981150431 4226032.8747967305, 1918095.173193444 4226026.081777942, 1918126.005506094 4226014.445516165, 1918129.7260636473 4226012.672703361, 1918131.1211233796 4226011.9143062895, 1918132.0411111098 4226011.293015874, 1918134.8132690443 4226009.280793126, 1918136.3594198509 4226008.140834092, 1918141.7448507084 4226003.39812247, 1918145.641572382 4225999.631236962, 1918148.1753944443 4225996.93848502, 1918149.0470157103 4225996.021446003, 1918151.7030985998 4225993.058383956, 1918153.206042542 4225991.342117123, 1918154.2511209098 4225990.113640602, 1918155.1442281571 4225988.98606504, 1918158.4014989643 4225984.449497405, 1918159.4489759675 4225982.962023287, 1918161.4173259947 4225980.101990112, 1918173.1884665992 4225963.159916475, 1918174.018590726 4225962.026455641, 1918176.4150082264 4225958.993234617, 1918177.4589965409 4225957.71601487, 1918177.6410441883 4225957.502063996, 1918186.6261771088 4225947.254848359, 1918191.5698768622 4225941.658949646, 1918200.0260892475 4225932.4722803105, 1918211.1003926208 4225919.865323585, 1918215.6031427116 4225914.1570546385, 1918239.895275773 4225876.920144373, 1918244.0393519423 4225870.2191363005, 1918247.9535728607 4225863.60830465, 1918257.159162703 4225847.26515002, 1918272.9235839874 4225818.000868447, 1918288.3665333793 4225791.2688917015, 1918307.6111811437 4225758.330700221, 1918308.519477414 4225756.643543504, 1918312.4782250414 4225747.688487458, 1918313.5189479054 4225744.293940168, 1918320.274080191 4225719.470966381, 1918324.561787538 4225687.623790021, 1918324.9203838212 4225685.69006395, 1918330.1606059074 4225663.756895312, 1918330.6664704764 4225661.168466975, 1918331.806905218 4225654.05119885, 1918334.2754191374 4225638.02489862, 1918336.4363374603 4225627.129280406, 1918340.7755057567 4225606.399965524, 1918343.3888065177 4225597.189951701, 1918344.2807552742 4225594.464146555, 1918347.5716242667 4225585.281224462, 1918353.7465024283 4225568.32351084, 1918359.2857693993 4225551.595190195, 1918359.7554022116 4225549.1820091475, 1918360.0850377071 4225547.513949738, 1918361.013073073 4225541.588821323, 1918361.6347862906 4225537.216248317, 1918362.3580071675 4225531.368379174, 1918362.7605545656 4225528.360017407, 1918363.1643580706 4225526.237674002, 1918363.268339845 4225525.6953788465, 1918363.7452929139 4225523.143514916, 1918366.64174081 4225510.589086766, 1918367.3172549752 4225507.783531452, 1918368.0381202477 4225504.880213308, 1918376.3171647184 4225473.379223177, 1918382.9161390555 4225447.332558022, 1918383.4412351004 4225445.485289014, 1918386.8254291501 4225432.449506877, 1918387.2156924803 4225430.520924346, 1918388.2458480524 4225423.91866495, 1918389.512083368 4225415.963838788, 1918391.4857114581 4225405.608855037, 1918394.8671611736 4225388.462587544, 1918396.1445126357 4225381.360358047, 1918398.6182338055 4225355.575268218, 1918403.5137879706 4225304.57879345, 1918403.7290122656 4225301.70978623, 1918404.15497764 4225296.207395113, 1918404.7493380194 4225286.390154584, 1918405.5770913628 4225275.641085497, 1918406.0188517498 4225270.420966425, 1918407.635973101 4225254.133581052, 1918408.4387803555 4225248.207444335, 1918410.805290533 4225235.327043222, 1918415.8488414094 4225210.326704508, 1918416.1294668163 4225208.949574223, 1918416.4727774342 4225207.238533989, 1918416.9335397512 4225205.043803692, 1918421.2181244548 4225185.887871861, 1918426.1561723677 4225169.132257486, 1918428.3405051106 4225162.005179541, 1918430.9701973668 4225153.946718098, 1918433.556404231 4225147.026600107, 1918434.5341494232 4225144.753026489, 1918438.3257847074 4225137.636615775, 1918450.6461082154 4225118.029367591, 1918451.199193887 4225117.2458870765, 1918453.3789884765 4225114.710879298, 1918474.38654656 4225090.484619574, 1918487.5283697748 4225074.566330629, 1918489.854451391 4225071.752253349, 1918490.5196662252 4225070.996928344, 1918494.5914617153 4225066.87428791, 1918499.5406420873 4225062.321647126, 1918501.6763562143 4225060.37107438, 1918509.6452170121 4225053.32129738, 1918510.4439707177 4225052.615711774, 1918510.5801336823 4225052.505207049, 1918514.1582939867 4225049.611701325, 1918526.6696326674 4225040.423415658, 1918527.4835950609 4225039.864680009, 1918528.0299999877 4225039.488749997, 1918528.7269970435 4225039.004938207, 1918535.392045419 4225034.846215852, 1918548.6386968556 4225026.581584003, 1918551.9833672324 4225024.32512518, 1918560.4680791397 4225018.132803538, 1918574.5434880247 4225007.997372924, 1918583.6669377305 4225002.223045958, 1918597.5526059733 4224993.814223446, 1918615.1467614279 4224983.364234228, 1918642.7699595115 4224967.234180156, 1918653.727379987 4224961.212129681, 1918660.8811382547 4224957.555133522, 1918677.1493066566 4224948.528233603, 1918687.3003492078 4224942.915045178, 1918699.9130136834 4224936.322693321, 1918699.9153685833 4224936.321468735, 1918699.9237806424 4224936.317079152, 1918715.6243407596 4224928.1300473055, 1918733.8477277625 4224921.089969609, 1918742.960787435 4224917.959671418, 1918746.41584787 4224916.846387229, 1918762.4694460684 4224911.917567752, 1918775.0487499994 4224908.2956781285, 1918795.0006257563 4224902.91032976, 1918806.3149192648 4224899.536673935, 1918824.5987214902 4224894.319234355, 1918836.827897543 4224891.14600728, 1918856.1257102918 4224886.709071222, 1918946.275 4224866.154999998, 1919078.0375000406 4224838.077499995, 1919135.0374999868 4224829.0625, 1919194.501388044 4224822.9144880185, 1919274.815 4224824.128749997, 1919410.87 4224825.56, 1919498.0249999787 4224830.462499993, 1919543.4756885923 4224837.8918686295, 1919598.3537006695 4224832.298645168, 1919633.940000009 4224831.386249993, 1919684.7121503246 4224823.1025155885, 1919750.8162500316 4224812.411249988, 1919795.8154251012 4224797.260991902, 1919826.5476156883 4224784.516143589, 1919844.669025417 4224771.826265584, 1919883.8341477423 4224751.997873032, 1919892.8971700536 4224743.77163675, 1919907.7499683446 4224729.424999978, 1919916.6688044358 4224722.682354427, 1919936.5727580374 4224710.830635656, 1919944.9800273362 4224706.357592281, 1919961.8966945698 4224696.553550551, 1919991.6940500352 4224678.077052987, 1920024.311800253 4224657.310458034, 1920024.3488812444 4224657.286847026, 1920024.8841972991 4224656.9469987, 1920025.514035917 4224656.547266941, 1920027.7690121531 4224655.122079747, 1920031.9478893466 4224652.4813202685, 1920036.6926436217 4224649.51824421, 1920038.843201489 4224648.207498469, 1920046.0598375786 4224643.936112627, 1920051.9123406278 4224640.391343502, 1920059.3351570978 4224636.437917421, 1920062.8348419035 4224634.731650068, 1920065.9525895498 4224633.247901346, 1920076.7116147808 4224628.839449752, 1920080.6368016128 4224627.2699245615, 1920085.061256962 4224625.531501118, 1920086.043193561 4224625.144166347, 1920089.0072566317 4224623.995532838, 1920094.1143521052 4224622.053195987, 1920097.2060496064 4224620.895422414, 1920098.5329557352 4224620.39828935, 1920102.967243472 4224618.737759427, 1920105.1562612175 4224617.918298, 1920106.8724549068 4224617.275726067, 1920110.5881392513 4224615.835336555, 1920124.98943783 4224610.070764116, 1920128.4444221943 4224608.689393432, 1920132.0164363615 4224607.22921459, 1920137.4352478913 4224604.943126967, 1920177.1189062647 4224586.716940225, 1920182.4435774724 4224584.459667719, 1920189.353428198 4224582.569774747, 1920190.0729844132 4224582.368702842, 1920190.3764715518 4224582.314838944, 1920194.9050426842 4224581.49096763, 1920246.0151426836 4224575.288742646, 1920251.4281249214 4224574.723657415, 1920267.835124257 4224577.857958488, 1920282.3572591108 4224581.31116777, 1920285.365233559 4224582.0281811105, 1920288.4142370739 4224582.888729359, 1920289.1846318066 4224583.111136842, 1920296.0796881083 4224585.109623273, 1920311.7553388032 4224590.118792533, 1920318.6291621116 4224592.608927687, 1920326.3427757632 4224595.666071119, 1920332.074017654 4224598.144748948, 1920347.6691319884 4224605.300085911, 1920347.841587946 4224605.379170738, 1920350.1168938247 4224606.419303058, 1920355.0857266888 4224609.044699584, 1920365.8490358137 4224616.361893162, 1920366.861398032 4224617.0333691845, 1920370.5979221708 4224619.498167014, 1920376.0911053573 4224624.2171357535, 1920378.9079634135 4224626.723639917, 1920382.3533474002 4224629.748018347, 1920386.859752495 4224633.835284945, 1920393.3312793914 4224639.611552883, 1920414.6817394348 4224663.894150304, 1920432.1295040548 4224687.185708494, 1920435.6426659373 4224694.4076667465, 1920435.8364939073 4224694.932236077, 1920436.1553848134 4224695.8175172, 1920436.5109291025 4224696.80625674, 1920437.144903322 4224698.556064519, 1920437.6505459095 4224699.951055209, 1920438.703504028 4224702.893662042, 1920440.557086663 4224707.990546756, 1920442.0477808972 4224712.140138106, 1920443.0213538613 4224715.258439929, 1920444.132560429 4224719.612672242, 1920444.3911058593 4224721.697873534, 1920448.8712738955 4224780.400894382, 1920444.24339362 4224826.0175, 1920434.070108514 4224905.246678723, 1920417.4550723427 4224961.66, 1920378.8500361713 4225022.991497868, 1920324.4842809902 4225066.966523531, 1920251.8037416318 4225100.507106761, 1920013.0860881556 4225167.856977534, 1919970.2294420958 4225186.308666799, 1919917.7586406951 4225200.201191131, 1919871.1362540263 4225209.750020972, 1919731.299039325 4225246.601560707, 1919626.6515616933 4225278.3549601035, 1919563.1128815156 4225299.512294505, 1919497.58437246 4225328.229316811, 1919448.7576167474 4225350.164927042, 1919432.4373709753 4225358.875236126, 1919430.799453981 4225359.733358822, 1919427.0865243163 4225361.777219609, 1919414.8740261567 4225369.562557447, 1919408.4836921582 4225374.026418798, 1919406.675347536 4225375.291501582, 1919377.587077745 4225400.476244959, 1919360.3599999973 4225414.32750002, 1919351.258750004 4225425.770000011, 1919351.535099944 4225457.06704922, 1919353.9659118108 4225478.998155058, 1919370.4633247545 4225517.215476734, 1919387.0850452837 4225549.71163345, 1919413.585391721 4225579.58993195, 1919415.0416867645 4225580.933344594, 1919439.0387590611 4225603.900794081, 1919474.530801113 4225637.033436279, 1919508.5993036078 4225660.970023008, 1919582.4292348234 4225703.585516841, 1919652.4170069783 4225739.485196152, 1919689.567569396 4225761.533519669, 1919747.601768043 4225800.745909637, 1919777.2997728207 4225825.95629713, 1919823.736287278 4225875.250833808, 1919852.6388690243 4225907.552211876, 1919870.8627658451 4225935.381781926, 1919880.4228315405 4225960.450841926, 1919891.3849094594 4225999.448755857, 1919887.07503284 4226040.329111407, 1919877.6997105682 4226070.136544203, 1919862.444897838 4226111.745169082, 1919838.9793720827 4226161.254021626, 1919814.1055206296 4226196.740256779, 1919797.628992659 4226217.423397643, 1919772.2409550317 4226245.909641719, 1919747.8487952785 4226276.931250006, 1919725.095794463 4226304.668727174, 1919686.5309411706 4226348.22674724, 1919658.0763367077 4226395.059140947, 1919643.8731350524 4226436.863917097, 1919633.3694831398 4226436.911933792, 1919630.1723641122 4226436.926549193, 1919628.6331354722 4226448.363001771, 1919628.9175143396 4226455.407439471, 1919630.1766560995 4226465.730421946, 1919639.6203061522 4226496.26270675, 1919649.7651692163 4226509.275974836, 1919649.980835844 4226509.539493202, 1919651.8361259596 4226511.726948411, 1919655.886784628 4226516.479647678, 1919673.6937658319 4226538.302559163, 1919731.50250001 4226584.438749991, 1919788.1017964785 4226619.051625506, 1919843.1875000405 4226645.872500011, 1919913.8775479132 4226676.567920188, 1919984.9140913573 4226701.614396581, 1920061.6462003915 4226722.288615961, 1920091.993210314 4226729.550431367, 1920094.7591031813 4226730.143720893, 1920106.6738399747 4226732.923188474, 1920138.89900952 4226738.120767777, 1920150.7687139262 4226739.917424586, 1920166.7397258324 4226742.073720342, 1920189.2870300706 4226744.441534152, 1920268.81409117 4226749.250558537, 1920346.0456249993 4226753.5831250055, 1920352.666998991 4226699.3706072895, 1920356.0909874786 4226670.781072858, 1920378.7595085718 4226652.402875631, 1920379.7845075224 4226651.571793579, 1920403.6671096103 4226632.211539462, 1920504.9591668816 4226550.096462177, 1920554.5535609322 4226509.892046836, 1920554.5119514929 4226509.814451738, 1920554.6065707593 4226509.737686604, 1920521.6768981954 4226448.477863623, 1920497.2012857525 4226402.938512968, 1920497.0772684435 4226402.707749072, 1920488.716550823 4226387.1508967085, 1920482.1965362257 4226375.010122475, 1920477.901375694 4226366.865684342, 1920457.0779308164 4226327.319664969, 1920438.1416061644 4226291.54778184, 1920415.0736832556 4226248.643238797, 1920418.849875413 4226246.684486933, 1920418.702948859 4226246.479483216, 1920418.8366375887 4226246.423836131, 1920413.9681250027 4226239.608749989, 1920402.4949944352 4226226.6512633, 1920400.1072417349 4226223.936238015, 1920395.7245887045 4226218.716499376, 1920390.9512797366 4226213.008011795, 1920388.9251387157 4226210.5471913265, 1920383.7872127604 4226204.280414328, 1920378.9625523528 4226198.28018294, 1920370.6403963245 4226187.9145024335, 1920331.4898304665 4226139.315912824, 1920321.695301256 4226127.164567882, 1920317.913695276 4226120.836941302, 1920316.6246174031 4226117.656987047, 1920315.8090197183 4226115.588033803, 1920315.6810713578 4226115.177846412, 1920314.7872115409 4226111.651262652, 1920314.389843874 4226108.804287494, 1920313.874670178 4226103.336015617, 1920313.0473149428 4226092.9330340745, 1920312.3673041994 4226085.370598807, 1920312.064967148 4226082.328462546, 1920311.6768793457 4226078.692703052, 1920308.4710263035 4226047.360910089, 1920305.7431473283 4226034.664530509, 1920304.8757200304 4226031.053245658, 1920301.4049367404 4226018.85216092, 1920300.4012622219 4226015.7118985085, 1920297.4775749722 4226007.3067276785, 1920296.8355996946 4226005.698323652, 1920296.5964432324 4226005.10070174, 1920295.4058486852 4226002.368214871, 1920292.3658602815 4225995.437753472, 1920291.3124147176 4225993.276918774, 1920290.2681602088 4225991.120525873, 1920284.965203062 4225981.19784666, 1920281.9283010198 4225975.905816983, 1920281.5479248846 4225975.244212917, 1920277.690939009 4225968.527385448, 1920272.6698328985 4225960.134982166, 1920261.9066475593 4225942.087652543, 1920265.1172023213 4225942.8894860605, 1920280.1558204815 4225947.221534022, 1920331.0278238705 4225960.329817807, 1920362.55144487 4225876.556294021, 1920391.8541244927 4225798.450280863, 1920339.1806338567 4225778.639027071, 1920351.8264551684 4225743.658765948, 1920368.7937499983 4225719.176875, 1920381.6756123377 4225700.337970646, 1920401.4289126915 4225673.0467795525, 1920420.9362810263 4225641.432819048, 1920433.091945541 4225615.765054924, 1920483.4606919556 4225510.694415427, 1920533.1521523318 4225407.09850911, 1920591.2912636977 4225286.084148385, 1920639.9917250706 4225184.269089062))'::geometry,'38179','Gières','GIÈRES','GIE','GIE'),
     (17,'SRID=3945;POLYGON ((1914113.3723903352 4217833.470223486, 1914104.8096117605 4217840.150875016, 1914103.8078264445 4217840.935817882, 1914096.6519524152 4217846.592493531, 1914093.9245902158 4217848.80826886, 1914094.0976806837 4217849.053067604, 1914096.2999962799 4217852.267352174, 1914096.5915818606 4217852.6941195205, 1914097.2136436382 4217853.578669342, 1914097.2152431111 4217853.580944776, 1914097.2954039813 4217853.6949673835, 1914097.3953517836 4217853.83621312, 1914097.4746396637 4217853.94781998, 1914097.5114332545 4217853.999715106, 1914099.9970756266 4217857.500537555, 1914100.16 4217857.73, 1914101.52 4217859.38, 1914103.1102872798 4217861.545649644, 1914103.12161834 4217861.561080308, 1914110.8495072557 4217872.084902023, 1914115.894077139 4217878.954585957, 1914118.6302993582 4217882.68076722, 1914120.1071174874 4217884.698609571, 1914121.1448928956 4217886.120702868, 1914144.5428485875 4217918.183589982, 1914189.6208123663 4217979.955211528, 1914196.8155952971 4217989.814428117, 1914203.9747563058 4217999.597215015, 1914210.9250631793 4218009.081101583, 1914214.0256900175 4218013.307636549, 1914216.757621644 4218017.016234659, 1914216.777441432 4218017.043132259, 1914218.6783020427 4218019.624324742, 1914222.0351498704 4218024.180159311, 1914222.2724259908 4218024.457658594, 1914222.4648758366 4218024.6813883, 1914223.1408180383 4218025.460885525, 1914223.0991623488 4218025.504352331, 1914223.1702789145 4218025.594389819, 1914218.8524778779 4218030.123910751, 1914215.8361871962 4218033.402491389, 1914211.3805871995 4218038.685864699, 1914207.4995191304 4218044.033935862, 1914207.4159358656 4218044.15808255, 1914206.5060402283 4218045.503836763, 1914202.5774321794 4218052.2394902, 1914198.9951283154 4218058.720576496, 1914191.6240829926 4218072.121012373, 1914186.8763965277 4218081.506437113, 1914178.8891045055 4218096.826702881, 1914167.392735528 4218119.055073388, 1914165.8781222028 4218122.18885605, 1914163.8009999997 4218127.117500001, 1914163.6170882254 4218127.547947357, 1914163.4579775285 4218127.975056179, 1914163.1335174493 4218128.845148327, 1914161.0876083411 4218134.5047522355, 1914159.6473440493 4218138.298663958, 1914159.1977593459 4218139.306473907, 1914154.864335188 4218149.735188739, 1914152.2868368705 4218162.501200233, 1914139.5984339144 4218243.87523959, 1914134.483060902 4218267.708633535, 1914133.212105531 4218274.077913096, 1914115.070415765 4218341.666679605, 1914108.8747405836 4218362.64024876, 1914104.3652138545 4218395.963949652, 1914101.7000919404 4218408.212953577, 1914101.4983700982 4218409.162488612, 1914099.6268284926 4218415.288050623, 1914099.0702860076 4218417.122577613, 1914097.9328763797 4218420.640263408, 1914097.6734919574 4218421.444932431, 1914092.5584634545 4218437.0816487875, 1914085.7943911606 4218457.524289835, 1914084.8919666947 4218460.79644711, 1914083.7969677476 4218464.911759095, 1914079.0566439729 4218478.230567769, 1914076.9664562028 4218484.1499305265, 1914072.2090675146 4218497.733530658, 1914065.452465782 4218517.009269543, 1914058.8062072836 4218539.040253803, 1914053.8477556547 4218555.858177604, 1914053.3086129862 4218557.69673558, 1914049.5694890956 4218570.470300668, 1914038.2073375762 4218600.987574197, 1914038.960277948 4218601.5760793155, 1914038.5813001199 4218602.61613125, 1914044.4364475766 4218605.856303853, 1914045.6300662535 4218606.498822255, 1914050.002356832 4218609.482110005, 1914068.6182616018 4218624.666168677, 1914079.989707469 4218633.876744077, 1914101.1702324823 4218649.407903368, 1914115.201923366 4218659.95670728, 1914136.2879092859 4218675.892909557, 1914143.4672879798 4218681.302417883, 1914146.9507985145 4218684.055144509, 1914151.4578775049 4218687.625135463, 1914153.690885188 4218689.436007486, 1914154.8759888872 4218690.725301466, 1914159.7924451667 4218696.249446105, 1914174.5066076138 4218717.711561357, 1914178.4473901535 4218721.693748506, 1914191.1137372013 4218731.981774744, 1914196.4298805206 4218735.624061136, 1914197.1470708258 4218736.050819004, 1914198.118870415 4218736.516423866, 1914198.9956313823 4218736.747584136, 1914205.881979522 4218738.539931741, 1914212.1535494882 4218739.781365188, 1914257.720143005 4218745.8172614155, 1914264.1165784982 4218747.3473122865, 1914268.072714084 4218749.670276087, 1914269.0300312103 4218750.229414394, 1914271.8078043847 4218752.140636444, 1914288.575989761 4218763.730324231, 1914297.4972463027 4218769.895263013, 1914302.5792447205 4218771.681544957, 1914304.3147178327 4218772.259029699, 1914306.4572549283 4218772.590249105, 1914316.0508124921 4218773.671420474, 1914317.7681544418 4218773.581781807, 1914321.5353998404 4218773.3982247375, 1914330.3714081203 4218771.350535525, 1914349.39179606 4218764.027656379, 1914362.3442605562 4218757.0012328, 1914372.9050157617 4218766.512333753, 1914438.8165578078 4218824.887954759, 1914451.463404805 4218836.0128432885, 1914482.693881166 4218795.420146309, 1914486.0361789577 4218791.083752741, 1914486.1628083005 4218791.228018594, 1914486.6635711582 4218790.622856891, 1914505.1845795559 4218812.899078422, 1914515.6517352122 4218825.582189025, 1914541.922385221 4218849.872967164, 1914555.283725594 4218862.207509177, 1914555.8531497174 4218862.967956921, 1914556.60486949 4218864.016723682, 1914571.9217831898 4218894.019098231, 1914573.6121053388 4218896.219047543, 1914582.8757432543 4218903.774571941, 1914581.865629308 4218891.2021820145, 1914651.9612626496 4218904.234658386, 1914655.8080373365 4218904.579122225, 1914657.5494297785 4218905.18058088, 1914663.6915518388 4218906.346587349, 1914663.7267727158 4218906.949974505, 1914663.7630703445 4218907.3734260425, 1914667.0396457487 4218944.88714201, 1914671.2618930761 4218983.557781155, 1914675.3853635455 4219005.569646401, 1914682.153993333 4219041.453873612, 1914685.6067979478 4219067.01672197, 1914685.0288313946 4219076.227971824, 1914683.814485989 4219090.942353424, 1914690.615635384 4219093.5610722955, 1914693.8016594213 4219095.196028563, 1914718.2752176803 4219115.654465508, 1914721.346618047 4219118.044135782, 1914721.7609489057 4219118.36984201, 1914731.3404465667 4219124.732749746, 1914737.422801782 4219127.348773494, 1914741.6935390376 4219127.595122027, 1914749.5636730054 4219127.096183395, 1914755.0277696487 4219125.328816856, 1914761.2495343974 4219121.402272174, 1914764.8867097716 4219116.441650701, 1914767.0497519986 4219112.809200112, 1914772.776071052 4219082.567040602, 1914774.6152425967 4219077.5406368, 1914777.8053201085 4219071.724899498, 1914780.80632224 4219068.949635996, 1914785.0955991717 4219067.58990404, 1914795.670989761 4219066.471040956, 1914827.8324594032 4219069.354930854, 1914832.964752288 4219051.932259324, 1914835.921491757 4219045.260807052, 1914837.0781147259 4219044.019026092, 1914841.8862606012 4219040.4152378235, 1914847.5659173708 4219036.702398422, 1914855.1949357428 4219033.496514933, 1914872.1634600328 4219028.017061257, 1914899.7026305925 4219020.423560357, 1914904.3827704694 4219018.520816817, 1914935.5509701876 4219007.246582803, 1914956.476119396 4219008.468977708, 1914963.0909271594 4219009.339206564, 1914985.923426019 4219014.656298063, 1914991.0425760965 4219015.521372975, 1914998.8262160881 4219014.612542211, 1915008.1237475292 4219012.828361235, 1915018.2583788394 4219010.0632593855, 1915040.2591904749 4219001.620445759, 1915081.6718871703 4218986.507601252, 1915082.9231929656 4218986.054128049, 1915093.4503632928 4218981.975095701, 1915109.6174314413 4218975.708795168, 1915109.7695348081 4218975.6952735325, 1915111.2165823977 4218975.138431445, 1915128.8776273772 4218974.173935748, 1915147.910960968 4218973.603659057, 1915157.5533611972 4218973.674339414, 1915161.0923695576 4218973.927766453, 1915172.2153882075 4218975.084894068, 1915174.9219796192 4218975.351412301, 1915183.0158869915 4218975.987641205, 1915183.4621144412 4218975.982036049, 1915188.52996674 4218975.021028845, 1915193.6120776148 4218973.523798872, 1915205.3335803892 4218969.384525721, 1915230.3247672305 4218961.012560888, 1915259.741289846 4218952.055151837, 1915272.0988182593 4218946.701348122, 1915294.1950352087 4218934.483424072, 1915299.0499023711 4218932.623700322, 1915301.079554983 4218931.54944725, 1915309.4141209982 4218932.216768608, 1915316.6643783734 4218933.648653001, 1915337.9842854217 4218938.5751955435, 1915345.7994198892 4218940.203727804, 1915359.3008387836 4218941.710848349, 1915378.9191071985 4218938.435763515, 1915419.8098757507 4218928.615652815, 1915472.1745243217 4218915.94737767, 1915482.6949044839 4218910.446667776, 1915518.91 4218886.33, 1915528.0978492624 4218880.717806992, 1915544.2321220122 4218872.978660942, 1915551.5593908275 4218870.184630543, 1915554.9343153366 4218850.264877347, 1915560.7583240594 4218822.613413041, 1915564.604374769 4218804.058958508, 1915570.0203293457 4218782.092971046, 1915577.820129107 4218751.329379003, 1915578.1716047218 4218745.308997929, 1915573.0517262956 4218727.324914492, 1915561.2824743907 4218693.346964632, 1915549.5914371319 4218676.079249877, 1915546.5368033517 4218670.392639708, 1915544.0803525706 4218658.044222663, 1915542.3472483454 4218647.181201105, 1915541.544335175 4218630.220987523, 1915543.9654893226 4218606.491357369, 1915550.1367260944 4218579.742514394, 1915559.8283100543 4218569.582650521, 1915568.6160547426 4218562.101650671, 1915580.4305124127 4218553.307015846, 1915585.3610398143 4218547.455034077, 1915588.60874636 4218540.223247013, 1915589.236487199 4218538.419632527, 1915591.9940005448 4218530.572376422, 1915594.1035767726 4218522.522981027, 1915595.089966606 4218516.535386777, 1915595.1293480883 4218499.085224027, 1915592.9842273693 4218473.838968556, 1915585.8871408494 4218441.035400497, 1915582.234752423 4218424.433635281, 1915580.7534126523 4218415.501282646, 1915575.4170833395 4218393.590436023, 1915565.807264735 4218357.938962221, 1915562.2615135564 4218336.054142372, 1915559.3079256362 4218324.372797008, 1915556.2244918211 4218304.144176051, 1915556.206546181 4218300.060050641, 1915556.3901151933 4218295.29925247, 1915560.244711449 4218276.743515942, 1915561.2496465407 4218272.6642571585, 1915643.7835640917 4218283.601774751, 1915697.5112276804 4218290.100282382, 1915712.7309633996 4218287.653031262, 1915742.98652012 4218280.61961884, 1915744.5517339464 4218245.005165608, 1915744.495705917 4218241.295801015, 1915742.0226118013 4218214.151088962, 1915739.171518583 4218192.7079746155, 1915736.4073545279 4218161.0159077, 1915736.6693962812 4218142.966695165, 1915737.101171219 4218135.349374827, 1915740.3838696012 4218111.746616594, 1915743.7677561508 4218099.802903965, 1915750.2456553758 4218081.233543578, 1915754.6350468136 4218069.5976205515, 1915754.8521438027 4218069.135605556, 1915757.87801872 4218064.060893236, 1915768.6460988796 4218046.017654826, 1915773.7252196963 4218038.203920151, 1915786.30881415 4218018.794770031, 1915786.7311185922 4218019.145677679, 1915787.6469629426 4218019.906685035, 1915795.5157275056 4218009.806091333, 1915802.4418149884 4217999.628514746, 1915804.8185499439 4217994.585578993, 1915804.829823812 4217994.563361128, 1915814.9687233553 4217984.2555955555, 1915821.5726855628 4217978.956226022, 1915832.6842073416 4217969.427391509, 1915834.2415014412 4217968.083000085, 1915841.1728816235 4217962.639586266, 1915855.352188221 4217949.113872766, 1915863.5029048717 4217940.247350433, 1915890.1804466106 4217913.038279663, 1915892.1772879006 4217911.004376783, 1915902.1086017466 4217901.090561867, 1915917.215748988 4217886.0883249, 1915919.8332443764 4217883.576084365, 1915927.0005357028 4217876.69121742, 1915977.0032960265 4217827.635514957, 1915985.4956215464 4217819.593041385, 1916033.4937950226 4217780.826655765, 1916048.194146276 4217768.792394821, 1916048.3604563577 4217769.128719911, 1916048.4220482248 4217769.07785695, 1916068.9969685168 4217791.085331906, 1916072.0729333383 4217786.093712254, 1916073.493572234 4217787.252532204, 1916152.5026248493 4217658.666819759, 1916155.0912537097 4217657.614946065, 1916155.7345905078 4217656.564165727, 1916308.002150009 4217594.295903173, 1916374.1884691468 4217566.766287134, 1916443.3925761273 4217538.145147707, 1916464.470826391 4217532.613254812, 1916492.6337733006 4217531.362385729, 1916507.0977192384 4217531.35301771, 1916512.1235780572 4217530.139545941, 1916518.3184032093 4217528.708311934, 1916506.8240656299 4217504.90196073, 1916509.205974266 4217503.483116381, 1916509.0120200193 4217503.094621037, 1916604.5467611335 4217445.953279352, 1916626.2634316909 4217432.93170609, 1916631.5884662622 4217428.310504283, 1916637.6663111653 4217422.464127406, 1916649.4207152228 4217405.952373552, 1916657.7049930694 4217390.113743598, 1916666.2506152566 4217362.854496437, 1916672.613964641 4217344.91703712, 1916677.1698655628 4217338.544177365, 1916684.5022130616 4217330.709522707, 1916688.7747483833 4217326.166508097, 1916700.0556313037 4217317.849733684, 1916717.6975346238 4217305.000022355, 1916762.7549998069 4217309.046873058, 1916762.621362628 4217312.914300816, 1916763.6267343129 4217313.045332671, 1916763.396389548 4217316.943826796, 1916762.2117543716 4217324.768265054, 1916761.614625642 4217329.618110298, 1916760.9445379267 4217336.149848419, 1916760.7891153274 4217338.831105418, 1916762.2425513933 4217345.308456261, 1916776.2297828377 4217357.038662881, 1916790.956330375 4217367.401307207, 1916804.1385182373 4217378.480040316, 1916813.0055478222 4217379.603300001, 1917026.8977230075 4217400.418466071, 1917026.8301883228 4217400.566534714, 1917027.716561807 4217400.652029465, 1917010.3865638596 4217439.270717823, 1917008.6725439827 4217444.205228277, 1916996.004986008 4217547.386962075, 1916998.9138919548 4217581.769839515, 1917008.2 4217588.41, 1917011.86 4217586.78, 1917012.8 4217587.2, 1917027.3961114427 4217579.89404145, 1917070.485931174 4217558.65597166, 1917081.40990869 4217556.695661356, 1917085.24 4217555.2, 1917091.5515033223 4217551.711824282, 1917102.5209414777 4217565.334765747, 1917105.54 4217565.65, 1917105.679969606 4217565.660536962, 1917109.82 4217565.99, 1917120.71 4217567.13, 1917188.6293002982 4217553.970925336, 1917188.683565059 4217553.96022664, 1917196.099038296 4217552.380614478, 1917206.53 4217550.16, 1917207.5472747977 4217549.944111843, 1917263.7264881919 4217524.305069271, 1917267.2278551823 4217522.707109577, 1917268.4197117826 4217522.1631529, 1917268.5373820532 4217522.109449335, 1917268.6248256497 4217522.069522833, 1917268.7129062638 4217522.029286001, 1917269.12341543 4217521.841757945, 1917270.0854048734 4217521.402303679, 1917272.7478453908 4217520.1860524565, 1917276.4167925825 4217518.510010662, 1917277.0101177641 4217518.238968933, 1917277.2508875397 4217518.128980914, 1917277.3789146957 4217518.070495784, 1917277.4453304722 4217518.040354228, 1917277.4781752892 4217518.025449874, 1917277.990691 4217517.792879726, 1917278.6759119583 4217517.481939107, 1917278.7431528678 4217517.45142643, 1917279.7516491015 4217516.993789481, 1917279.7594493092 4217516.990249901, 1917279.7598717394 4217516.9900582, 1917283.5090808023 4217515.205682721, 1917284.141613038 4217515.063127854, 1917284.6476013716 4217514.948868653, 1917285.1760200781 4217514.829984274, 1917285.339996852 4217514.793040865, 1917285.5344026748 4217514.749315673, 1917285.9520314063 4217514.655217747, 1917286.0449456326 4217514.634176992, 1917286.329953152 4217514.570010558, 1917286.3844506626 4217514.557633774, 1917286.4256969392 4217514.548264065, 1917303.248170028 4217510.727620663, 1917316.6 4217507.7, 1917344.3319097671 4217497.846746796, 1917347.7039942772 4217496.646797073, 1917359.9164420883 4217492.30287311, 1917376.8176615513 4217486.294928888, 1917435.12 4217465.57, 1917436.8 4217471.36, 1917579.49 4217460.17, 1917581.2938948413 4217458.665093254, 1917582.489607293 4217457.318597476, 1917582.5029422394 4217457.301754088, 1917584.530060305 4217455.366800801, 1917585.5782443015 4217454.366294195, 1917593.7557288243 4217446.5808887575, 1917612.7574550528 4217428.478283077, 1917631.1058325588 4217410.890365358, 1917636.8795506503 4217402.994056476, 1917661.1520115903 4217368.087849467, 1917663.612930018 4217364.5655996865, 1917666.1961499916 4217360.857637764, 1917669.0962167955 4217356.673877424, 1917671.3817600906 4217353.370103532, 1917672.7899467014 4217351.343208736, 1917676.5517253815 4217345.917647373, 1917679.657408433 4217341.435788118, 1917681.8198624747 4217338.316173209, 1917682.9242497268 4217336.722923667, 1917683.734725739 4217335.543092286, 1917691.1173435438 4217324.7746275775, 1917694.0758358592 4217320.459506329, 1917695.2151572984 4217318.796985443, 1917696.3999935975 4217317.070283921, 1917700.3902567637 4217311.248185989, 1917705.1047507676 4217304.352080658, 1917711.7052561773 4217294.44373747, 1917712.259704264 4217293.612686196, 1917749.67212398 4217237.449940717, 1917751.1983241232 4217235.159007132, 1917751.2562383313 4217235.072060451, 1917752.594169675 4217233.063393855, 1917758.8477539872 4217223.667764741, 1917760.644674835 4217220.968117004, 1917769.28 4217207.51, 1917771.7944817608 4217203.037462414, 1917777.7602129017 4217192.42614792, 1917784.5205459562 4217180.365203412, 1917799.96 4217152.32, 1917828.46 4217094.97, 1917878.55 4217038.63, 1917931.81 4217012.17, 1917970.57 4216957.69, 1917974.54 4216960.61, 1918076.3482283514 4216856.026638861, 1918076.8629895898 4216855.491137202, 1918052.64 4216808.68, 1918051.204950744 4216804.4793922445, 1918050.125622688 4216801.628338293, 1918048.2674357677 4216796.743426773, 1918047 4216793.31, 1918045.95 4216789.93, 1918041.3585321922 4216772.407924637, 1918040.7173683285 4216769.863228285, 1918040.5257327645 4216769.102774719, 1918040.52 4216769.08, 1918040.5116971491 4216769.049557994, 1918040.4895959985 4216768.968527028, 1918040.4286253124 4216768.744959478, 1918040.28 4216768.2, 1918039.6196996642 4216765.1004725415, 1918039.5687107616 4216764.861124562, 1918039.528334916 4216764.671622994, 1918039.4017625612 4216764.0834418405, 1918038.5627523754 4216760.308728227, 1918038.3 4216759.03, 1918037.9885468462 4216757.691593205, 1918037.93 4216757.44, 1918037.37 4216755.35, 1918037.0288849915 4216754.210530717, 1918036.9 4216753.78, 1918035.15 4216748.86, 1918033.71 4216743.88, 1918032.82 4216739.46, 1918032.68 4216734.74, 1918032.98 4216731.53, 1918033.7 4216727.01, 1918035.7 4216719.07, 1918039.05 4216710.53, 1918042.39 4216703.24, 1918046.54 4216695.94, 1918050.71 4216689.58, 1918056.091040412 4216682.736327798, 1918056.67 4216682, 1918063.59 4216674, 1918072.64 4216664.53, 1918090.3 4216647.76, 1918095.4756536242 4216642.166523816, 1918100.11 4216636.98, 1918102.1492750142 4216634.054083675, 1918108.36 4216625.83, 1918118.2724053084 4216613.356889986, 1918119.16 4216612.24, 1918123.537261824 4216606.246802901, 1918144.03 4216578.21, 1918158.5761210765 4216557.8421134725, 1918168.0229400208 4216544.934959928, 1918173.9050193469 4216536.915703591, 1918177.54 4216531.96, 1918190.086126348 4216514.181596298, 1918191.7401060045 4216511.837835596, 1918192.4318654442 4216510.857582538, 1918192.7598156158 4216510.392862961, 1918192.9324112118 4216510.148287539, 1918193.03 4216510.01, 1918193.0444762015 4216509.989058331, 1918193.253898339 4216509.686102534, 1918194.102387165 4216508.458655371, 1918198.629913079 4216501.909012448, 1918208.3 4216487.92, 1918215.95 4216476.14, 1918215.2 4216475.88, 1918215.4 4216472.8, 1918210.5446584662 4216472.640063336, 1918193.8554532516 4216472.474939272, 1918188.2978036797 4216472.5502101015, 1918167.6130517554 4216473.17600395, 1918149.7007671078 4216474.877467928, 1918129.2772957245 4216477.045827333, 1918112.2357262564 4216478.460664799, 1918112.21 4216478.26, 1918112.209930403 4216478.259081131, 1918112.06 4216478.27, 1918111.904770426 4216476.007587422, 1918111.8757531487 4216475.499534666, 1918111.8651620825 4216475.315560643, 1918111.862517432 4216475.2694729185, 1918111.66849297 4216471.6615792, 1918111.3732397258 4216466.167843704, 1918110.8943501804 4216457.255613594, 1918109.5795128534 4216432.787726638, 1918103.4437983704 4216318.291100746, 1918100.1302332755 4216256.279809887, 1918100.1305119041 4216256.27958047, 1918100.1302723733 4216256.275097564, 1918129.39 4216232.3, 1918147.26 4216228.45, 1918158.98 4216221.23, 1918162.6 4216219.77, 1918170.17 4216217.73, 1918175.5 4216216.96, 1918180.92 4216215.5, 1918190.1853909094 4216214.1345650535, 1918191.4098556368 4216213.953578932, 1918192.3226244706 4216213.814616251, 1918195.0078252417 4216213.39520017, 1918203.3 4216212.1, 1918223.86 4216206.83, 1918225.65 4216205.43, 1918226.5631276683 4216204.215945566, 1918211.2017921628 4216194.216205713, 1918202.5550305021 4216189.266552854, 1918191.6090971364 4216184.02777683, 1918189.8687973574 4216182.990819864, 1918188.3105231228 4216182.131424223, 1918187.579389575 4216181.700174758, 1918187.5030997451 4216181.653074253, 1918187.2278396536 4216181.49452073, 1918187.2200000642 4216181.49000004, 1918187.1016452154 4216181.41923116, 1918186.25 4216180.91, 1918185.331508477 4216180.314279395, 1918184.3755717354 4216179.669852649, 1918182.92 4216178.64, 1918182.0099817165 4216177.902237298, 1918181.32 4216177.29, 1918180.7353484025 4216176.715257752, 1918180.05 4216176, 1918179.530313361 4216175.387474174, 1918178.96 4216174.65, 1918178.4595015543 4216173.910146026, 1918178.4524926208 4216173.90082244, 1918178.324346514 4216173.727927934, 1918174.7953774042 4216168.385974341, 1918171.634988756 4216158.393528541, 1918170.1265654752 4216152.132605066, 1918167.873842945 4216146.064701447, 1918163.0891366918 4216139.770550299, 1918159.2860435331 4216137.437717859, 1918159.9 4216136.54, 1918173.9030605347 4216126.495593311, 1918174.5139538578 4216126.057403935, 1918175.1446767414 4216125.604988869, 1918175.473612281 4216125.368980535, 1918175.845982145 4216125.101425722, 1918177.5826587481 4216123.853705398, 1918178.3549836 4216123.299433632, 1918181.850668813 4216120.796147514, 1918190.67 4216114.48, 1918191.16982564 4216101.539774393, 1918191.1696322574 4216101.539524531, 1918191.1698126406 4216101.534852606, 1918165.67634804 4216068.579606275, 1918150.823446142 4216049.379495747, 1918150.5316198443 4216049.002255422, 1918150.2812383901 4216048.678487855, 1918150.0757780666 4216048.416306399, 1918149.2343498734 4216047.342971794, 1918146.2828874008 4216043.580718306, 1918142.8791820966 4216039.241484902, 1918140.932741131 4216036.76021422, 1918138.8529767685 4216034.109737446, 1918138.346438814 4216033.464643274, 1918138.004098245 4216033.028957586, 1918137.7849459252 4216032.750528049, 1918136.9793079654 4216031.727161233, 1918136.5958658066 4216031.238260658, 1918134.52 4216028.59, 1918187.330832107 4216008.541627837, 1918187.3316250485 4216008.543179057, 1918187.3355972723 4216008.541671236, 1918190.9896994638 4216015.704640648, 1918202.9475134863 4216007.783539643, 1918218.47 4215997.5, 1918199.99 4215977.03, 1918208.4172142788 4215973.747784683, 1918221.167725385 4215967.735738203, 1918259.4615230195 4215947.180688914, 1918266.6447558496 4215943.924617879, 1918275.9614926788 4215942.311410908, 1918279.933556207 4215941.983258745, 1918283.7843606346 4215941.708955642, 1918289.4750261046 4215942.935707446, 1918294.7502863593 4215944.593049969, 1918306.7827357142 4215950.999179031, 1918308.5005921747 4215949.147626015, 1918310.7491392721 4215950.456873392, 1918325.5785964676 4215935.669196135, 1918331.7389796996 4215930.478347219, 1918339.7917013504 4215926.350192168, 1918411.2541568403 4215895.83865339, 1918414.0009669554 4215892.472941756, 1918423.3457270407 4215885.919153747, 1918433.3051557662 4215874.386364644, 1918435.4496220916 4215868.785413373, 1918433.0507254265 4215865.092815477, 1918432.5773924736 4215861.686978903, 1918367.4279412061 4215760.80640812, 1918241.0682821132 4215567.548747496, 1917945.394746514 4215112.031015131, 1917772.81 4214847.55, 1917774.570376964 4214845.881533756, 1917457.99834584 4214837.219739657, 1917425.4565309924 4214855.593161885, 1917416.179530775 4214859.946928759, 1917413.7541871902 4214860.57924428, 1917410.4019235172 4214861.504125113, 1917404.00156878 4214861.223800989, 1917399.4775973714 4214860.705841511, 1917392.8750242656 4214860.12555655, 1917390.2111239347 4214859.906769519, 1917386.7985666802 4214859.3869725065, 1917379.7168884336 4214858.310121892, 1917378.5923285424 4214858.389516924, 1917366.861764855 4214859.805866806, 1917359.5084122946 4214858.968009889, 1917330.3998780907 4214870.167740211, 1917320.1980643945 4214872.790349445, 1917314.317977824 4214873.041849283, 1917254.0627063739 4214868.458232125, 1917252.0591767246 4214868.136586202, 1917251.9615265867 4214868.917787307, 1917251.814925656 4214870.090594753, 1917237.953334428 4214866.667504659, 1917030.008348035 4214829.394179539, 1916982.2447910863 4214782.161983442, 1916980.4656661132 4214779.532259609, 1916974.9619751526 4214768.13756395, 1916970.6183035935 4214759.131135458, 1916958.1545003369 4214732.895778898, 1916942.4121381552 4214698.675755921, 1916914.3254695307 4214638.039585668, 1916899.778538955 4214606.888891522, 1916885.5908509549 4214576.474390054, 1916856.7213633712 4214515.465861324, 1916830.4218385296 4214458.291433541, 1916829.8007490574 4214455.154720009, 1916829.479085458 4214453.205967842, 1916829.7325482697 4214449.365978147, 1916830.0747861248 4214444.176283023, 1916830.0802956203 4214444.092473898, 1916830.154482359 4214442.969750918, 1916830.5368688835 4214437.189890522, 1916830.7088410659 4214434.216853083, 1916833.152553879 4214392.692731019, 1916836.5925132497 4214339.901742568, 1916836.7761834962 4214329.302841413, 1916832.9651288847 4214249.839368707, 1916833.575277021 4214243.459153558, 1916847.254117485 4214196.992184185, 1916843.6139061684 4214188.71248322, 1916821.142505474 4214163.713332162, 1916823.0423799918 4214148.623989662, 1916824.194671674 4214141.125848798, 1916823.6453781326 4214137.615596776, 1916822.847180629 4214133.976882962, 1916815.126020215 4214113.253670651, 1916832.793505302 4214044.929670287, 1916832.9692318605 4214043.959462013, 1916834.2970371766 4214036.936817936, 1916834.6896073432 4214029.468950862, 1916834.1524979556 4214010.782377998, 1916833.5880802718 4214005.555982001, 1916828.4631687424 4213995.11350993, 1916827.722567753 4213993.665840231, 1916820.7576454736 4213983.5193419065, 1916812.3460902264 4213971.358977637, 1916810.9204006155 4213970.206767487, 1916798.6665400728 4213964.105559532, 1916796.556160511 4213961.617345286, 1916794.2858368696 4213958.49494936, 1916787.82203165 4213940.883832108, 1916778.4238736443 4213918.181125625, 1916775.72485272 4213912.398653121, 1916770.252003794 4213900.426197422, 1916728.1650017367 4213825.755127694, 1916716.11594311 4213786.250183781, 1916643.0682411634 4213673.819009004, 1916627.0302082615 4213595.31112786, 1916619.577531576 4213583.981851717, 1916561.9460203007 4213520.805530977, 1916353.453002602 4213292.880897297, 1916357.6437694586 4213286.876793763, 1916333.9835800305 4213264.9996067835, 1916160.3109308856 4213103.43797782, 1915983.9497854826 4212941.004334018, 1915958.6298380566 4212917.663967611, 1915946.6209961283 4212909.093613449, 1915943.48 4212910.43, 1915944.006814241 4212912.514997207, 1915946.8277142944 4212921.499569423, 1915947.5458941883 4212928.28860129, 1915945.0805088384 4212929.554282125, 1915945.029342865 4212929.8797438815, 1915920.6298098727 4212942.628909068, 1915888.7142594666 4212959.239267935, 1915888.6 4212958.54, 1915843.420880621 4212981.7308656, 1915747.6549019786 4213031.682574234, 1915591.98588566 4213112.881327172, 1915470.6591783627 4213176.165059945, 1915221.117970891 4213307.543442965, 1914949.96 4213450.35, 1914936.5338383417 4213459.7814533245, 1914881.085045057 4213487.66105806, 1914835.31450005 4213510.113617081, 1914810.3865688506 4213523.158841731, 1914721.9528958537 4213570.685325343, 1914690.0417122846 4213588.0781007325, 1914683.1268113274 4213591.496880648, 1914641.8502705507 4213612.098599581, 1914572.886707918 4213654.31465788, 1914531.0487482932 4213682.124563336, 1914509.0437443154 4213692.781255074, 1914489.8554556991 4213692.897948944, 1914484.911902834 4213692.670647774, 1914474.649237433 4213694.758204888, 1914494.8408771423 4213905.420724888, 1914500.5350507516 4214003.616509623, 1914518.8508303242 4214049.777304852, 1914525.2602869696 4214058.77783044, 1914611.3869898499 4214128.932470076, 1914646.030919747 4214157.951993196, 1914649.586066922 4214161.37953655, 1914674.4674898973 4214207.014757275, 1914697.5309109169 4214243.000583036, 1914699.4808836635 4214247.446668362, 1914700.4236790377 4214255.249651955, 1914700.6862604779 4214256.142128773, 1914710.6349854236 4214269.943596834, 1914714.5854455247 4214274.823415145, 1914717.8397368803 4214278.837682376, 1914720.865130418 4214281.843162191, 1914726.2710751598 4214287.182697127, 1914733.9993431189 4214296.525244553, 1914743.0626130684 4214307.435238856, 1914748.7049466341 4214313.961657868, 1914750.9032774076 4214315.421310963, 1914753.3831236595 4214317.235361153, 1914756.3874120237 4214321.551751968, 1914756.6374921137 4214321.934779723, 1914757.3433454977 4214323.334471338, 1914759.7972338588 4214328.337243288, 1914760.786500155 4214331.492265317, 1914760.7300669395 4214334.68167816, 1914759.930990985 4214339.010405796, 1914758.6187551215 4214345.752335475, 1914758.7109726593 4214347.364752842, 1914758.8251159124 4214349.720946141, 1914760.3736208596 4214357.026318302, 1914762.7729563045 4214362.258851817, 1914806.4070861114 4214407.800379529, 1914819.3577650557 4214418.458118885, 1914820.2985824095 4214419.000427273, 1914821.9795143714 4214420.229325977, 1914821.8396054085 4214420.545049743, 1914823.533251114 4214422.242651409, 1914818.491864268 4214430.219368909, 1914815.2885785974 4214437.079116495, 1914829.7989779015 4214459.3900597, 1914845.681611837 4214489.389282502, 1914849.1963097851 4214496.646205312, 1914855.2234020054 4214513.327108494, 1914861.5191355185 4214534.038156157, 1914862.0642893265 4214538.297056165, 1914862.9090650035 4214542.3879037425, 1914867.7619081377 4214550.345438379, 1914890.7455675306 4214570.687820462, 1914910.2214500634 4214603.088401701, 1914915.9845445661 4214612.376891418, 1914930.1562889603 4214636.704674971, 1914934.2387878147 4214646.369979024, 1914940.4831839644 4214656.212553982, 1914949.6199561986 4214676.447328757, 1914955.6114922084 4214690.868335046, 1914959.9846977869 4214701.299161436, 1914961.691113446 4214704.502224249, 1914978.696680526 4214735.900341707, 1914986.661136379 4214762.325723549, 1914992.5432943592 4214794.365888483, 1914997.1838088536 4214820.327997165, 1914997.3803151126 4214821.465121543, 1914998.7251974756 4214827.029276145, 1915000.282704972 4214833.471119559, 1915029.3869796915 4214902.900182288, 1915030.3933279917 4214904.869359242, 1915037.7334830284 4214911.185613009, 1915039.037183097 4214912.286613213, 1915039.7303460825 4214913.317429841, 1915055.4147786812 4214948.657836991, 1915057.4086059602 4214952.6365587115, 1915071.4339102157 4214993.773746497, 1915071.2773378799 4214994.349604983, 1915072.454179396 4214997.779778704, 1915058.7131504614 4215040.104863536, 1915055.2275184845 4215050.817010389, 1915055.5465148187 4215051.401539965, 1915075.7737438362 4215087.254869474, 1915087.81113251 4215117.544202006, 1915110.2701454875 4215176.147193306, 1915136.8097180089 4215249.676171172, 1915153.9384431457 4215293.492213222, 1915171.2284602758 4215352.791099312, 1915176.9133193898 4215399.446225396, 1915186.8761858125 4215426.142646142, 1915199.9494129901 4215453.90706911, 1915214.6868563339 4215493.038440873, 1915247.947206247 4215593.792756569, 1915269.0595727942 4215658.088891775, 1915301.1501293487 4215749.674700869, 1915302.5196046482 4215753.131302194, 1915309.4568898452 4215764.5527012255, 1915311.5825039896 4215767.945470988, 1915313.0428466229 4215770.277361208, 1915314.5135775118 4215772.805758091, 1915323.6261583779 4215788.17997873, 1915329.9321099792 4215801.201928707, 1915337.4547451108 4215816.9463713225, 1915364.5829795413 4215873.49912392, 1915371.947187283 4215888.228963685, 1915409.016577488 4215946.668954913, 1915416.7449184726 4215959.815322869, 1915421.28072431 4215967.474787126, 1915427.0365054542 4215978.640276881, 1915427.039027712 4215978.645104755, 1915428.8381045612 4215982.148418502, 1915434.9508758436 4215994.485511994, 1915438.419584879 4216001.176906522, 1915444.706471161 4216010.965544219, 1915447.4174548048 4216015.120899345, 1915458.7152215505 4216035.357963662, 1915476.2627732127 4216066.60815404, 1915478.0782015976 4216070.159662787, 1915482.7950711593 4216086.062870452, 1915493.054905998 4216117.353693409, 1915493.962627031 4216120.621510663, 1915494.8627174522 4216124.677174021, 1915496.047208314 4216130.055382667, 1915498.2004467212 4216138.6044791015, 1915502.3405875228 4216157.36962447, 1915503.0755305062 4216162.087662346, 1915504.5923728258 4216195.999159816, 1915504.762333693 4216201.457526465, 1915505.8227911983 4216215.9182228735, 1915505.8883250807 4216220.494580935, 1915506.0605822136 4216229.668883798, 1915500.2658191782 4216312.386753887, 1915499.2541790274 4216320.250162235, 1915499.2476346649 4216324.185400231, 1915499.2253093005 4216324.731258225, 1915499.0390175416 4216325.666060616, 1915498.939588843 4216326.182402853, 1915498.8467548466 4216326.782848477, 1915498.352461747 4216329.968039832, 1915408.4395801441 4216909.021143933, 1915404.8177390718 4216908.238144668, 1915369.9656797396 4216898.769026229, 1915356.2397031295 4216896.846247272, 1915308.6465271024 4216887.93980609, 1915267.9695125706 4216875.826006705, 1915250.4702563153 4216874.351003698, 1915239.1063483767 4216875.038300066, 1915233.2195968996 4216876.887967469, 1915219.1544579242 4216883.244778209, 1915212.552810995 4216884.962380536, 1915201.8008517541 4216886.254235936, 1915190.3135131719 4216887.216401416, 1915178.5536682403 4216886.181945338, 1915170.6167878178 4216883.723284879, 1915165.7367111112 4216881.298085077, 1915157.642632609 4216876.456870623, 1915155.061969287 4216874.911489893, 1915152.169840351 4216872.808606744, 1915144.010472476 4216866.555839362, 1915140.8271378602 4216864.115345188, 1915139.5015092534 4216863.084462949, 1915136.4945405433 4216860.59575471, 1915132.4218034307 4216857.219445625, 1915125.834061877 4216853.381935774, 1915121.9455662526 4216851.23813741, 1915120.5796351787 4216850.596988531, 1915118.2914781715 4216849.518686006, 1915113.536048597 4216848.178068041, 1915105.3196743724 4216847.829133706, 1915094.474959514 4216854.898218623, 1915070.0880104208 4216891.501603538, 1915059.4519205645 4216902.040061879, 1915045.1943795958 4216911.238467753, 1915030.355035256 4216913.212834512, 1915020.9972849817 4216911.739978095, 1915010.725068708 4216907.469830321, 1915004.1250782097 4216903.135221085, 1914997.3033475645 4216896.532066608, 1914996.7775614152 4216896.021479541, 1914995.368641224 4216894.441986738, 1914991.495349809 4216889.261904292, 1914965.001462238 4216849.992500681, 1914946.3694966065 4216821.199294652, 1914938.856894339 4216811.703104505, 1914927.0302093779 4216799.329058152, 1914911.6716418876 4216784.49984743, 1914904.5643237778 4216779.630514337, 1914892.5506513822 4216772.966960372, 1914889.305617409 4216771.508793016, 1914881.3384803936 4216768.493159537, 1914869.4417962488 4216764.885475517, 1914856.9537612954 4216761.876371762, 1914844.8173088504 4216759.609218162, 1914838.7504978946 4216758.835051033, 1914827.4494843523 4216757.724460733, 1914818.587848775 4216757.093803155, 1914812.4011758333 4216756.675906294, 1914810.64669354 4216756.774263376, 1914770.7276270678 4216761.691656198, 1914742.8283879517 4216763.371998062, 1914715.3355201653 4216761.583991286, 1914689.638808488 4216759.145294782, 1914682.5941695021 4216758.22586098, 1914677.0821292873 4216757.513429636, 1914662.49973596 4216755.929059568, 1914652.5385474893 4216754.069499499, 1914651.4800851536 4216755.199882544, 1914651.264067756 4216755.178873924, 1914628.3515005587 4216779.259218157, 1914619.2900863413 4216789.4540489195, 1914601.2700891523 4216809.924668422, 1914573.4226488643 4216839.566943884, 1914571.6803171276 4216841.7049424965, 1914564.001923077 4216852.3777429145, 1914561.305287683 4216856.383324391, 1914556.484573063 4216863.636400029, 1914552.8788461538 4216869.7035020245, 1914544.887095413 4216888.8979530325, 1914538.357034636 4216908.6105591, 1914536.2951978957 4216919.000662772, 1914531.538227978 4216943.5708679, 1914521.7864664572 4216978.182004751, 1914515.257339397 4216995.135828814, 1914508.013967544 4217014.328521627, 1914492.224432697 4217056.6032201145, 1914483.8096075319 4217091.65427859, 1914470.5348966746 4217136.075139955, 1914464.0477154665 4217161.432655831, 1914461.1991282147 4217182.069429121, 1914459.7437177044 4217199.414967997, 1914459.1403629307 4217208.717210394, 1914459.3577863544 4217221.157233137, 1914459.641048318 4217226.608443933, 1914460.3372716738 4217237.545584199, 1914460.3503459473 4217237.746574158, 1914461.7766024708 4217258.807812892, 1914462.1901064785 4217270.90443613, 1914461.08606348 4217285.469457798, 1914458.9768665016 4217305.562041661, 1914455.4108663748 4217331.057130827, 1914454.0369869908 4217340.261304134, 1914450.6020147146 4217358.400480272, 1914446.675572667 4217377.429790058, 1914441.0942890977 4217398.1979865385, 1914434.9776958765 4217417.017571654, 1914428.0465537466 4217427.879803536, 1914419.95999465 4217440.391626133, 1914402.746962313 4217467.937445837, 1914398.9671880219 4217474.415025593, 1914392.8415822852 4217485.6047509145, 1914345.0943483694 4217551.946450792, 1914323.6321055659 4217578.850524528, 1914323.5643315585 4217578.935281773, 1914323.3077207045 4217579.3006659215, 1914323.210705919 4217579.438625721, 1914319.2249422057 4217585.142448655, 1914312.1587858438 4217595.531915382, 1914310.0062742033 4217598.699081049, 1914309.837131111 4217598.978881024, 1914298.584384922 4217618.397081163, 1914279.963218668 4217652.413325579, 1914267.0859169704 4217674.481261696, 1914265.3590502376 4217677.532897223, 1914260.7857849437 4217687.407782259, 1914259.922739744 4217689.455286297, 1914257.4856830263 4217695.375102011, 1914252.2864242517 4217706.326681179, 1914249.7594313761 4217711.686977276, 1914242.2478305555 4217727.6004185425, 1914240.1470695345 4217731.44439152, 1914231.3148001223 4217745.389330162, 1914220.4570317592 4217761.191815196, 1914209.8351192393 4217774.358279287, 1914203.355589755 4217781.263052728, 1914200.7012560805 4217783.449734211, 1914178.3872254149 4217799.374275112, 1914171.4277393264 4217803.561495561, 1914127.7768996707 4217823.122544113, 1914117.6255352253 4217830.027840399, 1914113.3723903352 4217833.470223486))'::geometry,'38200','Jarrie','JARRIE','JAR','JAR'),
     (3,'SRID=3945;POLYGON ((1917869.6093226683 4228815.813527914, 1917869.4626171973 4228822.807216714, 1917869.4523880882 4228823.282158134, 1917867.9521553281 4228855.207241128, 1917867.0707285586 4228854.964192386, 1917866.9433880642 4228856.67155376, 1917856.705790627 4228853.514028744, 1917831.1435476444 4228868.347106309, 1917798.476031363 4228871.167920413, 1917748.268438038 4228874.121089207, 1917726.4829403833 4228877.139665085, 1917700.9494978015 4228883.650793041, 1917684.3233499436 4228890.057370531, 1917675.3655985969 4228896.039232317, 1917672.0622150623 4228900.299993213, 1917671.248275329 4228901.246378822, 1917660.993070038 4228911.43544132, 1917652.3824999665 4228921.459999985, 1917650.026271985 4228927.222521411, 1917648.5266256544 4228936.949654979, 1917654.4025688663 4228941.705827766, 1917694.9634277858 4228968.635133707, 1917693.73 4228969.62, 1917693.405013334 4228969.894868605, 1917694.9484836145 4228971.028645155, 1917643.9977585024 4229012.169935729, 1917636.0562651586 4229018.524726013, 1917633.4091207818 4229020.643988269, 1917633.2897928443 4229020.739375457, 1917628.0450758555 4229024.945863062, 1917655.1469944238 4229081.481957188, 1917654.9067800662 4229081.782947015, 1917655.9477341135 4229083.865203255, 1917637.0693408393 4229105.176016117, 1917597.551258029 4229121.623686166, 1917598.6800854725 4229136.220965285, 1917598.8403867423 4229136.307441596, 1917598.875652927 4229136.845735338, 1917629.5592066129 4229153.70393976, 1917629.0663170407 4229154.218735536, 1917629.9562267729 4229154.715939943, 1917587.318776585 4229209.052732294, 1917532.9903715507 4229290.571367436, 1917158.6932496922 4229856.2956399955, 1917160.4127668543 4229857.133164873, 1917178.4066180065 4229865.41459828, 1917190.1316337916 4229870.816771585, 1917194.0131995757 4229872.588043067, 1917196.2265739657 4229873.735384077, 1917198.6448327398 4229874.959445365, 1917224.77907621 4229888.249486396, 1917252.6291848742 4229902.937187554, 1917285.0328949841 4229919.411316133, 1917316.0325296207 4229926.543013382, 1917335.2081239116 4229931.964458556, 1917352.1787515315 4229938.4720192915, 1917378.4998894434 4229948.889255111, 1917387.9590081146 4229969.700425074, 1917400.5237094893 4229966.485940576, 1917419.2291332402 4229981.011762114, 1917448.097770882 4229996.975985568, 1917457.506109656 4229997.453919301, 1917483.5976993 4230012.045925786, 1917490.274990555 4230024.575028337, 1917498.7608603921 4230037.785354248, 1917504.2642152824 4230043.250116444, 1917547.9491257148 4230082.504082523, 1917557.830491225 4230094.737628053, 1917575.1778437959 4230108.808913488, 1917582.5540072245 4230122.517904003, 1917593.7530951425 4230143.956073452, 1917598.0975000153 4230155.317499986, 1917650.0912208618 4230180.601862829, 1917674.593853673 4230200.390277381, 1917685.0592654743 4230211.565725081, 1917705.6782577606 4230225.891181222, 1917734.705377334 4230268.866091824, 1917765.8475000164 4230299.899999992, 1917807.6274162033 4230335.574931188, 1917823.3510723482 4230351.374707195, 1917839.3953914645 4230360.173882426, 1917844.843238144 4230369.618285371, 1917860.2000000516 4230377.885000027, 1917867.2081705949 4230391.994338553, 1917880.5694164003 4230407.26945831, 1917886.0647103915 4230417.988510263, 1917902.4348136303 4230462.6843798505, 1917918.2450716265 4230462.497780972, 1917925.592960554 4230465.626182718, 1917935.1683418269 4230483.927594281, 1917952.3241197765 4230498.918036387, 1917970.061708822 4230509.394437024, 1917977.0328780042 4230533.747038809, 1917994.170329205 4230545.775584284, 1918008.2720719858 4230576.383811905, 1918022.8814543572 4230581.348472345, 1918036.5485783375 4230588.702718412, 1918041.1089205006 4230596.962218865, 1918048.3650795538 4230601.300054826, 1918084.3219998814 4230636.833050872, 1918087.941602798 4230652.291096545, 1918115.3168019564 4230667.462430962, 1918124.58 4230668.05, 1918130.04 4230660.59, 1918207.15 4230560.88, 1918284.68 4230460.02, 1918393.495000058 4230318.62500003, 1918459.8850000266 4230235.445000064, 1918568.25 4230098.5, 1918632.09 4230017.15, 1918653.9 4229989.42, 1918679.9 4229956.48, 1918703.67 4229926.08, 1918739.13 4229881.33, 1918764.84 4229848.45, 1918797.37 4229806.78, 1918849.97 4229732.72, 1918866.89 4229711.64, 1918875.18 4229701.29, 1918918.36 4229647.7, 1918940.42 4229619.93, 1918945.6 4229613.45, 1918970.48 4229582.67, 1918972.15 4229580.43, 1918980.3 4229570.36, 1918987.04 4229561.85, 1919022.04 4229517.91, 1919034.16 4229502.75, 1919035.46 4229501.09, 1919036.77 4229499.43, 1919105.51 4229414.57, 1919119.58 4229397.24, 1919134.57 4229378.64, 1919140.7 4229371.02, 1919153.89 4229354.95, 1919159.87 4229350.36, 1919168.34 4229340.45, 1919171.79 4229336.69, 1919174.8 4229333.43, 1919178.21 4229327.24, 1919185.04 4229313.77, 1919191.46 4229301.75, 1919194.4 4229296.73, 1919199.31 4229289.22, 1919206.06 4229279.53, 1919208.6 4229275.77, 1919212.5 4229269.1, 1919216.57 4229261.68, 1919221 4229251.7, 1919225.99 4229241.53, 1919230.73 4229233.2, 1919234.87 4229226.43, 1919237.57 4229222.24, 1919241.02 4229217.76, 1919247.97 4229210.29, 1919253.86 4229204.11, 1919258.83 4229198.68, 1919262.73 4229194.12, 1919268.12 4229185.55, 1919271.47 4229179.88, 1919274.59 4229174.11, 1919277.33 4229168.06, 1919280.56 4229160.94, 1919283.55 4229154.53, 1919289.62 4229143.46, 1919292.91 4229137.08, 1919296.67 4229131.46, 1919299.24 4229127.44, 1919301.85 4229123.9, 1919305.09 4229119.96, 1919309.93 4229115.06, 1919318.2 4229107.18, 1919322.97 4229102.75, 1919327.42 4229098.57, 1919329.73 4229096.47, 1919331.99 4229093.72, 1919334.5 4229088.96, 1919337.14 4229082.45, 1919338.47 4229079.92, 1919342.08 4229075.33, 1919349.04 4229067.11, 1919353.34 4229061.78, 1919357.29 4229058.17, 1919359.71 4229055.69, 1919363.42 4229051.46, 1919366.78 4229047.17, 1919367.5 4229045.42, 1919367.91 4229043.67, 1919368.48 4229040.67, 1919369.36 4229038.13, 1919375.33 4229030.37, 1919382.08 4229023.35, 1919387.96 4229017.95, 1919390.56 4229015.13, 1919391.77 4229012.61, 1919392.36 4229010.62, 1919392.45 4229008.17, 1919391.98 4229006.04, 1919391.02 4229003.41, 1919391.05 4229001.22, 1919390.92 4228994.26, 1919391.53 4228992.18, 1919393.31 4228989.45, 1919397.96 4228984.14, 1919403.43 4228978.44, 1919410.37 4228972.62, 1919412.01 4228970.65, 1919413.26 4228967.74, 1919414.46 4228965.17, 1919415.87 4228961.98, 1919417.15 4228959.47, 1919420.04 4228956.53, 1919427.16 4228949.82, 1919428.67 4228948.13, 1919429.32 4228947.03, 1919429.48 4228944.62, 1919428.72 4228942.03, 1919428.12 4228940, 1919428.71 4228935.86, 1919429.54 4228932.78, 1919430.98 4228928.88, 1919434.72 4228921.93, 1919441.13 4228910.35, 1919444.1 4228904.44, 1919445.5 4228900.29, 1919446.48 4228896.72, 1919447.69 4228892.42, 1919448.66 4228890.66, 1919450.95 4228887.98, 1919453.27 4228885.39, 1919453.96 4228883.37, 1919455.4 4228874.9, 1919458.12 4228867.49, 1919460.09 4228858.14, 1919463.21 4228844.96, 1919464.24 4228840.04, 1919464.77 4228837.88, 1919464.23 4228830.05, 1919464.06 4228825.85, 1919464.27 4228821.52, 1919465.94 4228814.99, 1919466.36 4228813.18, 1919467 4228810.97, 1919466.83 4228809.89, 1919465.63 4228807.93, 1919464.09 4228805.87, 1919463.32 4228803.38, 1919463.17 4228799.79, 1919463.27 4228796.3, 1919464.31 4228788.26, 1919465.84 4228782.21, 1919467.02 4228780.08, 1919468.28 4228778.12, 1919472.33 4228773.55, 1919472.91 4228770.91, 1919471.97 4228767.73, 1919470.93 4228765.49, 1919469.13 4228761.78, 1919468.2 4228759.47, 1919468.36 4228757.77, 1919469.03 4228755.54, 1919470.69 4228753.31, 1919472.03 4228750.87, 1919473.01 4228748.85, 1919472.75 4228747.53, 1919472.15 4228746.38, 1919469.44 4228743.09, 1919468.86 4228741.84, 1919469.41 4228740.56, 1919471.22 4228738.58, 1919472.65 4228737.44, 1919473.28 4228735.8, 1919473.45 4228733.37, 1919473.07 4228731.34, 1919472.34 4228728.86, 1919471.72 4228725.09, 1919471.92 4228722.53, 1919473.31 4228716.06, 1919473.82 4228713.58, 1919474.1 4228710.31, 1919473.5 4228702.54, 1919475.75 4228697.05, 1919478.02 4228691.56, 1919479.5 4228686, 1919480.01 4228682.02, 1919478.78 4228676.85, 1919477.53 4228672.07, 1919477.99 4228668.1, 1919479.13 4228663.62, 1919480.06 4228660.09, 1919481.65 4228658.18, 1919485.59 4228655.76, 1919487.78 4228654.6, 1919489.9 4228653.27, 1919494.34 4228649.29, 1919499.42 4228644.7, 1919512.2 4228633.35, 1919517.95 4228627.72, 1919525.51 4228620.54, 1919530.69 4228615.73, 1919538.29 4228607.12, 1919544.33 4228600.63, 1919550.7 4228593.82, 1919557.27 4228585.9, 1919558.32 4228580.67, 1919560.4 4228567.26, 1919564.08 4228544.66, 1919567.33 4228527.05, 1919573.85 4228515.93, 1919576.07 4228512.63, 1919580.15 4228508.13, 1919583.51 4228505.69, 1919588.44 4228502.5, 1919592.9 4228500.47, 1919596.38 4228499.13, 1919598.41 4228498.2, 1919601.37 4228497.81, 1919609.04 4228498.04, 1919612.36 4228497.87, 1919616.56 4228496.91, 1919626.57 4228493.73, 1919632.28 4228491.78, 1919637.55 4228489.54, 1919643.44 4228486.8, 1919648.05 4228483.98, 1919654.47 4228479.4, 1919659.06 4228476.48, 1919663.57 4228473.64, 1919674.79 4228467.62, 1919683.23 4228462.99, 1919689.53 4228459.12, 1919697.21 4228453.8, 1919702.71 4228450.6, 1919704.29 4228449.04, 1919709.8 4228441.6, 1919712.47 4228438.44, 1919716.46 4228435.15, 1919719.81 4228432.51, 1919721.78 4228429.94, 1919723.42 4228426.83, 1919724.73 4228424.94, 1919725.98 4228424.49, 1919732.99 4228421.31, 1919740.52 4228418.46, 1919758.79 4228411.27, 1919769.22 4228407.22, 1919776.49 4228403.24, 1919790.54 4228395.7, 1919806.61 4228387.85, 1919821.35 4228381.1, 1919838.21 4228372.49, 1919853.59 4228364.58, 1919872.18 4228354.94, 1919896.5 4228342.13, 1919919.28 4228330.14, 1919938.09 4228320.16, 1919950.8 4228313.17, 1919971.03 4228300.8, 1919992.98 4228287.62, 1920004.25 4228281.17, 1920010.79 4228277.08, 1920018.75 4228271.65, 1920028.49 4228265.35, 1920031.9 4228263.76, 1920036.51 4228261.5, 1920040.78 4228258.83, 1920043.14 4228257.39, 1920046.36 4228255.29, 1920049.3 4228253.34, 1920054.07 4228249.24, 1920058.57 4228244.55, 1920060.74 4228242.33, 1920065.69 4228234.02, 1920067.54 4228225.25, 1920067.75 4228221.88, 1920067.71 4228217.35, 1920067.19 4228207.23, 1920066.38 4228196.3, 1920063.87 4228170.71, 1920063.67 4228165.91, 1920063.82 4228161.08, 1920064.35 4228156.63, 1920064.51 4228154.5, 1920065.35 4228151.11, 1920067.1 4228145.54, 1920070.94 4228131.81, 1920075.72 4228114.45, 1920079.62 4228099.22, 1920080.04 4228096.85, 1920080.4 4228094.75, 1920080.14 4228089.87, 1920079.77 4228086.22, 1920079.13 4228076.79, 1920078.8 4228062.55, 1920078.34 4228051.33, 1920077.9 4228042.61, 1920077.48 4228031.63, 1920077.12 4228015.25, 1920076.59 4228000.53, 1920076.33 4227998.18, 1920074.48 4227982.04, 1920072.73 4227967.66, 1920070.6 4227949.22, 1920069.3 4227939.25, 1920067.19 4227925.01, 1920066.53 4227919.94, 1920065.47 4227910.28, 1920064.7 4227902.96, 1920063.87 4227893.79, 1920063.36 4227887.85, 1920063.21 4227884.82, 1920063.16 4227882.93, 1920063.52 4227872.56, 1920063.8 4227868.88, 1920064.43 4227865.52, 1920065.64 4227861.66, 1920066.9 4227858.82, 1920068.21 4227856.57, 1920069.34 4227855.02, 1920072.29 4227850.62, 1920078.34 4227842.98, 1920082.87 4227837.77, 1920089.72 4227829.72, 1920100.98 4227816.91, 1920104.15 4227813.15, 1920106.96 4227809.49, 1920109.92 4227805.49, 1920111.45 4227803.01, 1920113.06 4227800.18, 1920117.36 4227791.25, 1920118.93 4227787.4, 1920120.43 4227784.07, 1920122 4227780.65, 1920122.33 4227780.38, 1920122.97 4227779.7, 1920122.83 4227778.86, 1920123.43 4227779.14, 1920124.63 4227774.93, 1920127.75 4227767.95, 1920131.21 4227760.26, 1920132.17 4227758.42, 1920133.74 4227756.06, 1920134.89 4227754.17, 1920140.74 4227744.97, 1920143.51 4227740.32, 1920144.75 4227738.76, 1920151.59 4227731.52, 1920164.23 4227717.69, 1920169.06 4227712.4, 1920177.59 4227703.89, 1920182.32 4227699.43, 1920184.18 4227697.64, 1920188.74 4227693.49, 1920193.21 4227690.24, 1920197.64 4227686.92, 1920198.3 4227686.37, 1920200.96 4227684.4, 1920216.84 4227672.66, 1920223.52 4227667.39, 1920233.52 4227659.59, 1920236.75 4227657.07, 1920240.2 4227653.74, 1920243.48 4227650.47, 1920247.17 4227646.47, 1920248.81 4227644.55, 1920250.38 4227642.08, 1920255.03 4227633.77, 1920259.93 4227624.7, 1920266 4227614.15, 1920267.29 4227611.44, 1920270.36 4227606.46, 1920275.1 4227599.16, 1920277.15 4227596.1, 1920282.33 4227589.27, 1920290.83 4227577.55, 1920299.47 4227565.51, 1920317.37 4227540.39, 1920332.86 4227519.01, 1920344.04 4227503.69, 1920347.51 4227499.06, 1920350.24 4227495.6, 1920351.47 4227493.62, 1920353.4 4227490.23, 1920354.59 4227488.28, 1920362.67 4227478.78, 1920371.86 4227468.02, 1920378.16 4227460.48, 1920384.22 4227453.66, 1920387.85 4227449.51, 1920389.59 4227447.59, 1920393.05 4227444.12, 1920395.13 4227441.78, 1920396.79 4227439.85, 1920398.78 4227437.12, 1920399.98 4227435.37, 1920405.87 4227426.11, 1920407.37 4227423.33, 1920408.24 4227421.89, 1920409.01 4227422.42, 1920409.83 4227421.15, 1920416.78 4227416.76, 1920420.23 4227414.79, 1920425.52 4227412.48, 1920429.73 4227410.48, 1920432.35 4227409.68, 1920435.99 4227409.39, 1920457.02 4227410.62, 1920482.91 4227412.6, 1920501.02 4227414.19, 1920505.99 4227412.18, 1920515.74 4227412.23, 1920521.07 4227412.37, 1920523.29 4227412.65, 1920528.07 4227413.6, 1920537.46 4227415.47, 1920551.16 4227418.6, 1920562.73 4227421.39, 1920576.11 4227424.49, 1920578.67 4227425.12, 1920591.61 4227428.31, 1920604.51 4227431.7, 1920621.86 4227436.28, 1920628.88 4227438.02, 1920637.83 4227440.3, 1920640.34 4227441, 1920645.41 4227442.18, 1920652.26 4227443.51, 1920653.76 4227443.22, 1920655.04 4227442.67, 1920656.29 4227439.83, 1920656.67 4227438.3, 1920657.46 4227434, 1920661.47 4227401.46, 1920662.21 4227390.3, 1920663.49 4227379.18, 1920670.84 4227364.14, 1920673.15 4227352.17, 1920677.65 4227336.88, 1920680.67 4227327.64, 1920686.82 4227311.57, 1920694.72 4227293, 1920692.41 4227288.49, 1920659.92 4227285.65, 1920624.75 4227282.53, 1920592.4349999684 4227279.688749993, 1920623.99 4227177.43, 1920624.23 4227176.86, 1920652.33 4227182.65, 1920676.58 4227187.71, 1920687.86 4227165.49, 1920713.58 4227114.87, 1920723.1187499994 4227095.821249995, 1920662.96 4227079.7, 1920675.34 4227047.86, 1920687.49 4227015.44, 1920693.01 4227000.72, 1920694.94 4226996.72, 1920718.67 4226993.47, 1920776.476970882 4226982.564053762, 1920791.34 4226979.6, 1920807.2174477458 4226974.825980293, 1920816.69 4226971.31, 1920820.19 4226968.81, 1920822.63 4226972.01, 1920817.03 4226977.45, 1920811.33 4226982.46, 1920754.56 4227034.72, 1920762.07 4227045.36, 1920788.1 4227084.36, 1920793.61 4227092.96, 1920811.53 4227119.54, 1920815.91 4227125.06, 1920831.85 4227146.17, 1920841.98 4227158.42, 1920853.84 4227172.55, 1920869.28 4227188.72, 1920882.94 4227200.6, 1920901.04 4227214.72, 1920925.04 4227233.05, 1920954.66 4227255.23, 1920985.22 4227232.99, 1920988.49 4227228.96, 1920992.28 4227223.27, 1920995.91 4227216.59, 1920998.32 4227211.23, 1921001.43 4227203.5, 1921004.35 4227196.86, 1921005.52 4227193.24, 1921007.58 4227186, 1921009.33 4227179.03, 1921010.35 4227172.61, 1921013.17 4227138.4, 1921007.54 4227095.75, 1921000.28 4227075.01, 1920995.2 4227062.94, 1920986.79 4227044.84, 1920981.89 4227035.42, 1920975.88 4227024.65, 1920974.71 4227022.68, 1920991.65 4227009.64, 1921013.24 4226992.61, 1921027.17 4226982.08, 1921073.88 4226944.34, 1921076.455 4226942.565, 1921079.31 4226939.37, 1921085.77 4226933.42, 1921106.07 4226912.35, 1921115.52 4226903.67, 1921128.72 4226894.92, 1921140.83 4226890.07, 1921178.24 4226879.95, 1921207.02 4226871.22, 1921223.08 4226866.3, 1921233.99 4226861.56, 1921239.45 4226856.64, 1921242.31 4226853.53, 1921278.58 4226802.35, 1921298.4 4226775.51, 1921350.09 4226707.42, 1921353.34 4226706.12, 1921355.65 4226706.52, 1921419.6 4226741.43, 1921485.8 4226650.31, 1921484.43 4226648.41, 1921477.97 4226636.34, 1921468.5 4226618.6, 1921463.9 4226610.39, 1921529.08 4226458.22, 1921511.82 4226448.88, 1921455.9 4226425.2, 1921427.48 4226414.43, 1921413.42 4226409.3, 1921407.85 4226407.96, 1921399.61 4226407.78, 1921390.24 4226407.77, 1921364.6688812065 4226409.948850477, 1921354.9548727395 4226413.174738961, 1921314.6133144165 4226436.044282423, 1921245.1421405945 4226491.965074022, 1921208.7522300833 4226521.320536068, 1921188.2925409102 4226537.710652322, 1921123.0604911046 4226589.221164988, 1921020.6011868159 4226671.275859336, 1920951.322367271 4226728.543635143, 1920891.8013598549 4226750.809587134, 1920808.1003331973 4226765.308868293, 1920770.4892558635 4226767.661960032, 1920704.963954155 4226765.623656733, 1920669.61696992 4226761.887643355, 1920627.0463139447 4226758.653513248, 1920567.842906274 4226749.144520692, 1920531.2168256943 4226748.683169476, 1920500.0955745508 4226749.745280043, 1920441.9037969648 4226751.014094022, 1920413.4905614848 4226754.840567057, 1920395.9934035987 4226756.312775126, 1920346.0456249993 4226753.5831250055, 1920268.81409117 4226749.250558537, 1920189.2870300706 4226744.441534152, 1920166.7397258324 4226742.073720342, 1920150.7687139262 4226739.917424586, 1920138.89900952 4226738.120767777, 1920106.6738399747 4226732.923188474, 1920094.7591031813 4226730.143720893, 1920091.993210314 4226729.550431367, 1920061.6462003915 4226722.288615961, 1919984.9140913573 4226701.614396581, 1919913.8775479132 4226676.567920188, 1919843.1875000405 4226645.872500011, 1919788.1017964785 4226619.051625506, 1919731.50250001 4226584.438749991, 1919673.6937658319 4226538.302559163, 1919655.886784628 4226516.479647678, 1919651.8361259596 4226511.726948411, 1919649.980835844 4226509.539493202, 1919649.7651692163 4226509.275974836, 1919639.6203061522 4226496.26270675, 1919630.1766560995 4226465.730421946, 1919628.9175143396 4226455.407439471, 1919628.6331354722 4226448.363001771, 1919630.1723641122 4226436.926549193, 1919633.3694831398 4226436.911933792, 1919643.8731350524 4226436.863917097, 1919658.0763367077 4226395.059140947, 1919686.5309411706 4226348.22674724, 1919725.095794463 4226304.668727174, 1919747.8487952785 4226276.931250006, 1919772.2409550317 4226245.909641719, 1919797.628992659 4226217.423397643, 1919814.1055206296 4226196.740256779, 1919838.9793720827 4226161.254021626, 1919862.444897838 4226111.745169082, 1919877.6997105682 4226070.136544203, 1919887.07503284 4226040.329111407, 1919891.3849094594 4225999.448755857, 1919880.4228315405 4225960.450841926, 1919870.8627658451 4225935.381781926, 1919852.6388690243 4225907.552211876, 1919823.736287278 4225875.250833808, 1919777.2997728207 4225825.95629713, 1919747.601768043 4225800.745909637, 1919689.567569396 4225761.533519669, 1919652.4170069783 4225739.485196152, 1919582.4292348234 4225703.585516841, 1919508.5993036078 4225660.970023008, 1919474.530801113 4225637.033436279, 1919439.0387590611 4225603.900794081, 1919415.0416867645 4225580.933344594, 1919413.585391721 4225579.58993195, 1919387.0850452837 4225549.71163345, 1919370.4633247545 4225517.215476734, 1919353.9659118108 4225478.998155058, 1919351.535099944 4225457.06704922, 1919351.258750004 4225425.770000011, 1919360.3599999973 4225414.32750002, 1919377.587077745 4225400.476244959, 1919406.675347536 4225375.291501582, 1919408.4836921582 4225374.026418798, 1919414.8740261567 4225369.562557447, 1919427.0865243163 4225361.777219609, 1919430.799453981 4225359.733358822, 1919432.4373709753 4225358.875236126, 1919448.7576167474 4225350.164927042, 1919497.58437246 4225328.229316811, 1919563.1128815156 4225299.512294505, 1919626.6515616933 4225278.3549601035, 1919731.299039325 4225246.601560707, 1919871.1362540263 4225209.750020972, 1919917.7586406951 4225200.201191131, 1919970.2294420958 4225186.308666799, 1920013.0860881556 4225167.856977534, 1920251.8037416318 4225100.507106761, 1920324.4842809902 4225066.966523531, 1920378.8500361713 4225022.991497868, 1920417.4550723427 4224961.66, 1920434.070108514 4224905.246678723, 1920444.24339362 4224826.0175, 1920448.8712738955 4224780.400894382, 1920444.3911058593 4224721.697873534, 1920444.132560429 4224719.612672242, 1920443.0213538613 4224715.258439929, 1920442.0477808972 4224712.140138106, 1920440.557086663 4224707.990546756, 1920438.703504028 4224702.893662042, 1920437.6505459095 4224699.951055209, 1920437.144903322 4224698.556064519, 1920436.5109291025 4224696.80625674, 1920436.1553848134 4224695.8175172, 1920435.8364939073 4224694.932236077, 1920435.6426659373 4224694.4076667465, 1920432.1295040548 4224687.185708494, 1920414.6817394348 4224663.894150304, 1920393.3312793914 4224639.611552883, 1920386.859752495 4224633.835284945, 1920382.3533474002 4224629.748018347, 1920378.9079634135 4224626.723639917, 1920376.0911053573 4224624.2171357535, 1920370.5979221708 4224619.498167014, 1920366.861398032 4224617.0333691845, 1920365.8490358137 4224616.361893162, 1920355.0857266888 4224609.044699584, 1920350.1168938247 4224606.419303058, 1920347.841587946 4224605.379170738, 1920347.6691319884 4224605.300085911, 1920332.074017654 4224598.144748948, 1920326.3427757632 4224595.666071119, 1920318.6291621116 4224592.608927687, 1920311.7553388032 4224590.118792533, 1920296.0796881083 4224585.109623273, 1920289.1846318066 4224583.111136842, 1920288.4142370739 4224582.888729359, 1920285.365233559 4224582.0281811105, 1920282.3572591108 4224581.31116777, 1920267.835124257 4224577.857958488, 1920251.4281249214 4224574.723657415, 1920246.0151426836 4224575.288742646, 1920194.9050426842 4224581.49096763, 1920190.3764715518 4224582.314838944, 1920190.0729844132 4224582.368702842, 1920189.353428198 4224582.569774747, 1920182.4435774724 4224584.459667719, 1920177.1189062647 4224586.716940225, 1920137.4352478913 4224604.943126967, 1920132.0164363615 4224607.22921459, 1920128.4444221943 4224608.689393432, 1920124.98943783 4224610.070764116, 1920110.5881392513 4224615.835336555, 1920106.8724549068 4224617.275726067, 1920105.1562612175 4224617.918298, 1920102.967243472 4224618.737759427, 1920098.5329557352 4224620.39828935, 1920097.2060496064 4224620.895422414, 1920094.1143521052 4224622.053195987, 1920089.0072566317 4224623.995532838, 1920086.043193561 4224625.144166347, 1920085.061256962 4224625.531501118, 1920080.6368016128 4224627.2699245615, 1920076.7116147808 4224628.839449752, 1920065.9525895498 4224633.247901346, 1920062.8348419035 4224634.731650068, 1920059.3351570978 4224636.437917421, 1920051.9123406278 4224640.391343502, 1920046.0598375786 4224643.936112627, 1920038.843201489 4224648.207498469, 1920036.6926436217 4224649.51824421, 1920031.9478893466 4224652.4813202685, 1920027.7690121531 4224655.122079747, 1920025.514035917 4224656.547266941, 1920024.8841972991 4224656.9469987, 1920024.3488812444 4224657.286847026, 1920024.311800253 4224657.310458034, 1919991.6940500352 4224678.077052987, 1919961.8966945698 4224696.553550551, 1919944.9800273362 4224706.357592281, 1919936.5727580374 4224710.830635656, 1919916.6688044358 4224722.682354427, 1919907.7499683446 4224729.424999978, 1919892.8971700536 4224743.77163675, 1919883.8341477423 4224751.997873032, 1919844.669025417 4224771.826265584, 1919826.5476156883 4224784.516143589, 1919795.8154251012 4224797.260991902, 1919750.8162500316 4224812.411249988, 1919684.7121503246 4224823.1025155885, 1919633.940000009 4224831.386249993, 1919598.3537006695 4224832.298645168, 1919543.4756885923 4224837.8918686295, 1919498.0249999787 4224830.462499993, 1919410.87 4224825.56, 1919274.815 4224824.128749997, 1919194.501388044 4224822.9144880185, 1919135.0374999868 4224829.0625, 1919078.0375000406 4224838.077499995, 1918946.275 4224866.154999998, 1918856.1257102918 4224886.709071222, 1918836.827897543 4224891.14600728, 1918824.5987214902 4224894.319234355, 1918806.3149192648 4224899.536673935, 1918795.0006257563 4224902.91032976, 1918775.0487499994 4224908.2956781285, 1918762.4694460684 4224911.917567752, 1918746.41584787 4224916.846387229, 1918742.960787435 4224917.959671418, 1918733.8477277625 4224921.089969609, 1918715.6243407596 4224928.1300473055, 1918699.9237806424 4224936.317079152, 1918699.9153685833 4224936.321468735, 1918699.9130136834 4224936.322693321, 1918687.3003492078 4224942.915045178, 1918677.1493066566 4224948.528233603, 1918660.8811382547 4224957.555133522, 1918653.727379987 4224961.212129681, 1918642.7699595115 4224967.234180156, 1918615.1467614279 4224983.364234228, 1918597.5526059733 4224993.814223446, 1918583.6669377305 4225002.223045958, 1918574.5434880247 4225007.997372924, 1918560.4680791397 4225018.132803538, 1918551.9833672324 4225024.32512518, 1918548.6386968556 4225026.581584003, 1918535.392045419 4225034.846215852, 1918528.7269970435 4225039.004938207, 1918528.0299999877 4225039.488749997, 1918527.4835950609 4225039.864680009, 1918526.6696326674 4225040.423415658, 1918514.1582939867 4225049.611701325, 1918510.5801336823 4225052.505207049, 1918510.4439707177 4225052.615711774, 1918509.6452170121 4225053.32129738, 1918501.6763562143 4225060.37107438, 1918499.5406420873 4225062.321647126, 1918494.5914617153 4225066.87428791, 1918490.5196662252 4225070.996928344, 1918489.854451391 4225071.752253349, 1918487.5283697748 4225074.566330629, 1918474.38654656 4225090.484619574, 1918453.3789884765 4225114.710879298, 1918451.199193887 4225117.2458870765, 1918450.6461082154 4225118.029367591, 1918438.3257847074 4225137.636615775, 1918434.5341494232 4225144.753026489, 1918433.556404231 4225147.026600107, 1918430.9701973668 4225153.946718098, 1918428.3405051106 4225162.005179541, 1918426.1561723677 4225169.132257486, 1918421.2181244548 4225185.887871861, 1918416.9335397512 4225205.043803692, 1918416.4727774342 4225207.238533989, 1918416.1294668163 4225208.949574223, 1918415.8488414094 4225210.326704508, 1918410.805290533 4225235.327043222, 1918408.4387803555 4225248.207444335, 1918407.635973101 4225254.133581052, 1918406.0188517498 4225270.420966425, 1918405.5770913628 4225275.641085497, 1918404.7493380194 4225286.390154584, 1918404.15497764 4225296.207395113, 1918403.7290122656 4225301.70978623, 1918403.5137879706 4225304.57879345, 1918398.6182338055 4225355.575268218, 1918396.1445126357 4225381.360358047, 1918394.8671611736 4225388.462587544, 1918391.4857114581 4225405.608855037, 1918389.512083368 4225415.963838788, 1918388.2458480524 4225423.91866495, 1918387.2156924803 4225430.520924346, 1918386.8254291501 4225432.449506877, 1918383.4412351004 4225445.485289014, 1918382.9161390555 4225447.332558022, 1918376.3171647184 4225473.379223177, 1918368.0381202477 4225504.880213308, 1918367.3172549752 4225507.783531452, 1918366.64174081 4225510.589086766, 1918363.7452929139 4225523.143514916, 1918363.268339845 4225525.6953788465, 1918363.1643580706 4225526.237674002, 1918362.7605545656 4225528.360017407, 1918362.3580071675 4225531.368379174, 1918361.6347862906 4225537.216248317, 1918361.013073073 4225541.588821323, 1918360.0850377071 4225547.513949738, 1918359.7554022116 4225549.1820091475, 1918359.2857693993 4225551.595190195, 1918353.7465024283 4225568.32351084, 1918347.5716242667 4225585.281224462, 1918344.2807552742 4225594.464146555, 1918343.3888065177 4225597.189951701, 1918340.7755057567 4225606.399965524, 1918336.4363374603 4225627.129280406, 1918334.2754191374 4225638.02489862, 1918331.806905218 4225654.05119885, 1918330.6664704764 4225661.168466975, 1918330.1606059074 4225663.756895312, 1918324.9203838212 4225685.69006395, 1918324.561787538 4225687.623790021, 1918320.274080191 4225719.470966381, 1918313.5189479054 4225744.293940168, 1918312.4782250414 4225747.688487458, 1918308.519477414 4225756.643543504, 1918307.6111811437 4225758.330700221, 1918288.3665333793 4225791.2688917015, 1918272.9235839874 4225818.000868447, 1918257.159162703 4225847.26515002, 1918247.9535728607 4225863.60830465, 1918244.0393519423 4225870.2191363005, 1918239.895275773 4225876.920144373, 1918215.6031427116 4225914.1570546385, 1918211.1003926208 4225919.865323585, 1918200.0260892475 4225932.4722803105, 1918191.5698768622 4225941.658949646, 1918186.6261771088 4225947.254848359, 1918177.6410441883 4225957.502063996, 1918177.4589965409 4225957.71601487, 1918176.4150082264 4225958.993234617, 1918174.018590726 4225962.026455641, 1918173.1884665992 4225963.159916475, 1918161.4173259947 4225980.101990112, 1918159.4489759675 4225982.962023287, 1918158.4014989643 4225984.449497405, 1918155.1442281571 4225988.98606504, 1918154.2511209098 4225990.113640602, 1918153.206042542 4225991.342117123, 1918151.7030985998 4225993.058383956, 1918149.0470157103 4225996.021446003, 1918148.1753944443 4225996.93848502, 1918145.641572382 4225999.631236962, 1918141.7448507084 4226003.39812247, 1918136.3594198509 4226008.140834092, 1918134.8132690443 4226009.280793126, 1918132.0411111098 4226011.293015874, 1918131.1211233796 4226011.9143062895, 1918129.7260636473 4226012.672703361, 1918126.005506094 4226014.445516165, 1918095.173193444 4226026.081777942, 1918077.981150431 4226032.8747967305, 1918073.851154384 4226034.508821694, 1918072.5461007117 4226034.99538206, 1918066.295041072 4226037.214622185, 1918062.0946724126 4226038.5598274125, 1918061.9415188157 4226038.608767595, 1918043.6584142763 4226044.042128695, 1918042.1687500228 4226044.446249976, 1918028.9097134485 4226048.077816008, 1918025.52702495 4226048.95867751, 1918024.0540029812 4226049.26023839, 1918010.027963551 4226051.920388769, 1917997.8227567656 4226053.529726943, 1917991.3305988663 4226054.390674371, 1917977.51420214 4226055.124736892, 1917973.6103846454 4226055.143999145, 1917963.1551841989 4226054.4349740995, 1917948.6142766261 4226054.313064382, 1917935.6293890304 4226054.529394759, 1917921.155021137 4226054.620297957, 1917913.1251587037 4226054.18398383, 1917903.3024443614 4226052.810845136, 1917893.0126655768 4226050.805503374, 1917887.1838381542 4226049.4742825255, 1917872.964009465 4226046.0275514675, 1917851.6529672313 4226040.27948656, 1917848.1999654553 4226039.256782562, 1917839.7577798928 4226036.679908496, 1917835.1697936307 4226035.197019111, 1917828.465823706 4226032.974680407, 1917820.9137605433 4226030.473324822, 1917817.0403399963 4226029.233043422, 1917787.2914395132 4226019.689463421, 1917779.7457529712 4226016.647938677, 1917758.0214018328 4226006.731591595, 1917741.5353289829 4225997.650485846, 1917733.39343989 4225992.718612382, 1917728.91981907 4225989.820038785, 1917724.0756299065 4225986.281904421, 1917722.0938769353 4225984.708970748, 1917717.2762065178 4225980.564417039, 1917699.4108019874 4225961.095237636, 1917678.3032338058 4225939.027034412, 1917668.3575340977 4225927.348282213, 1917666.3709910146 4225924.943949577, 1917657.4018685764 4225913.768030636, 1917649.6812121219 4225903.111887934, 1917645.1487780432 4225896.595228035, 1917642.8403175583 4225893.070762909, 1917633.7249030008 4225877.640355026, 1917633.0521195715 4225876.505557143, 1917632.465846006 4225875.501737873, 1917629.897205918 4225871.107752234, 1917627.8883849722 4225867.666650758, 1917620.9435964131 4225855.794546797, 1917613.8896024846 4225843.620552866, 1917602.8988861244 4225824.455164327, 1917598.723330034 4225817.200957582, 1917597.0942365115 4225814.576551966, 1917590.9741782215 4225805.423512289, 1917582.6404187959 4225793.335193673, 1917576.3604617822 4225784.535423831, 1917574.3596437008 4225782.063754274, 1917571.8785146044 4225779.16314751, 1917567.8496819166 4225774.453003968, 1917565.9177335291 4225772.345956859, 1917562.3565858528 4225768.465522871, 1917554.016599781 4225760.065239306, 1917547.8754226544 4225754.00965137, 1917543.638329475 4225750.238531122, 1917540.4976745457 4225747.4431597, 1917536.733240561 4225744.223960572, 1917534.1567552094 4225742.02498055, 1917532.120275111 4225740.378514449, 1917527.7705390595 4225736.899415162, 1917524.8412982062 4225734.596360862, 1917522.043614724 4225732.445824358, 1917502.49335197 4225717.558401284, 1917497.483714604 4225713.715298293, 1917489.913151873 4225708.088010062, 1917489.7854327804 4225707.993155668, 1917489.7527567234 4225707.9687325815, 1917489.7157474745 4225707.941494534, 1917488.8232585492 4225707.276940203, 1917488.509786918 4225707.04363469, 1917488.253489015 4225706.853869987, 1917487.8919020803 4225706.5855460195, 1917487.4846552042 4225706.281711669, 1917487.2534704576 4225706.113611054, 1917486.927617047 4225705.871564984, 1917486.643819198 4225705.662647582, 1917486.2721078957 4225705.390632116, 1917485.5598314537 4225704.866799348, 1917485.2771421892 4225704.658652215, 1917485.145213929 4225704.560706839, 1917485.0066387472 4225704.456615756, 1917484.914136579 4225704.391380309, 1917483.362908033 4225703.26876815, 1917475.9555427108 4225697.959022057, 1917469.177525774 4225693.166684747, 1917467.9306261868 4225692.292025463, 1917464.8511659054 4225690.121767249, 1917459.1039402203 4225686.051252243, 1917456.0371226654 4225683.909923156, 1917453.251711866 4225681.955275765, 1917448.655749806 4225678.734638054, 1917447.5700131913 4225677.973698821, 1917446.4257284026 4225677.176055699, 1917444.2474804106 4225675.6756769, 1917443.9467356082 4225675.46848011, 1917443.78759453 4225675.358893016, 1917443.6203981678 4225675.244291607, 1917443.277709844 4225675.007394437, 1917442.890515212 4225674.740927583, 1917442.2642596406 4225674.30996734, 1917440.3759012276 4225673.0088550495, 1917438.0585679011 4225671.410390916, 1917435.2402739427 4225669.473491554, 1917430.4942040246 4225666.204046517, 1917423.449134318 4225661.3055610685, 1917402.4964516188 4225646.658826341, 1917393.1415628504 4225639.915395198, 1917384.7453486444 4225633.864657984, 1917379.438453133 4225629.950475139, 1917378.7657289843 4225631.1620510295, 1917343.3751038534 4225603.4875274515, 1917309.034798537 4225577.379862965, 1917263.0219812586 4225543.810829908, 1917223.7784210728 4225519.334068838, 1917202.6294707006 4225509.777594923, 1917189.147573291 4225504.612962743, 1917147.9739547437 4225489.174267055, 1917093.2432365285 4225474.680771402, 1917029.8806704795 4225462.792541508, 1917012.2755494667 4225497.2316823965, 1916949.7681210649 4225616.762116536, 1916899.3908346682 4225713.018932968, 1916898.0617054892 4225715.603329218, 1916894.2614802294 4225723.002665691, 1916892.7425735518 4225725.963560587, 1916889.8407776337 4225731.600497324, 1916865.4987364127 4225778.569002428, 1916859.4668434905 4225790.293017808, 1916835.1112438084 4225837.24096986, 1916832.8324509074 4225841.535009471, 1916829.192099977 4225848.339509056, 1916819.5037115528 4225866.496306103, 1916814.1054986264 4225875.378850423, 1916808.453404988 4225882.153983018, 1916771.479794216 4225917.989873034, 1916748.6097253906 4225940.159553518, 1916738.1850424688 4225949.337139105, 1916732.2685834942 4225954.537824412, 1916722.6265992618 4225962.860526905, 1916711.200055729 4225972.180275665, 1916700.8687108576 4225980.759388362, 1916699.692766247 4225981.93362956, 1916692.7253931665 4225989.787012244, 1916690.4580709874 4225992.402797384, 1916688.6814705273 4225994.475256525, 1916686.579587334 4225997.105725217, 1916684.4349687207 4225999.780746904, 1916682.211123323 4226002.566517362, 1916680.7858848055 4226004.351300519, 1916677.9507561221 4226008.03312895, 1916674.861577033 4226012.098462377, 1916667.111996126 4226022.737333513, 1916661.8728359938 4226030.020379121, 1916661.2306601922 4226030.935753725, 1916660.2430981938 4226032.296651477, 1916656.467631157 4226037.455774788, 1916651.6878929106 4226044.059631261, 1916647.9332690171 4226049.333331759, 1916644.5164605342 4226054.233309805, 1916638.9876846422 4226062.1257454455, 1916626.6139476143 4226079.786909311, 1916623.6642028475 4226083.9831130495, 1916622.02524058 4226086.347985369, 1916619.9230377697 4226089.354669214, 1916617.4567060673 4226092.887923837, 1916613.4054579355 4226098.806689611, 1916611.9020730406 4226100.993477302, 1916610.9777639655 4226102.36171433, 1916608.9810136475 4226105.29309526, 1916607.8610601197 4226106.93144825, 1916607.3601405884 4226107.686265485, 1916606.908240806 4226108.336623996, 1916605.9097056945 4226109.817565677, 1916599.361300636 4226119.452472665, 1916594.002833744 4226127.341172255, 1916593.2214325848 4226128.581593258, 1916592.9041697509 4226129.081631937, 1916591.8931694927 4226130.75737659, 1916590.0151319804 4226133.883502968, 1916587.2522947236 4226138.647979384, 1916586.5548018254 4226140.018748123, 1916584.9198502619 4226143.667498006, 1916583.9344193207 4226146.165316767, 1916582.4987500017 4226150.311250007, 1916576.6892846834 4226168.334413689, 1916574.3837145353 4226174.587915312, 1916572.649866071 4226178.371252271, 1916569.5727367098 4226183.129998541, 1916567.504229459 4226185.52811472, 1916565.9572750893 4226187.064965835, 1916565.1959625026 4226187.748052418, 1916563.2687743935 4226189.410518693, 1916556.182929791 4226194.677815245, 1916539.3823555512 4226207.00079136, 1916535.3035276646 4226211.736447881, 1916535.1043244365 4226211.991636584, 1916529.5551318747 4226219.186099731, 1916524.9357692304 4226225.68175101, 1916516.1338694666 4226237.876076534, 1916515.9957225218 4226238.069122925, 1916515.8381055165 4226238.287173397, 1916513.166004486 4226241.896592492, 1916509.7769733733 4226246.3765383335, 1916507.015525139 4226249.939939492, 1916506.1223900262 4226251.094214479, 1916505.619583611 4226251.6957237255, 1916504.896901752 4226252.569548321, 1916504.3755156505 4226253.181995363, 1916502.1429801001 4226255.813548443, 1916500.6727382296 4226257.624947624, 1916494.730766596 4226264.552173027, 1916480.583905658 4226280.034896906, 1916477.264887541 4226283.658294931, 1916468.4727608457 4226293.407863418, 1916465.6688245249 4226296.776959186, 1916461.1330524448 4226302.272604414, 1916458.9421576408 4226305.151329614, 1916455.2567200055 4226309.966971455, 1916454.2711972452 4226311.25968047, 1916453.3557784194 4226312.491271443, 1916450.5384762404 4226316.351565533, 1916449.3017173065 4226318.097072921, 1916448.687156259 4226318.966929208, 1916448.641374228 4226319.031449962, 1916448.6143699083 4226319.069392891, 1916448.5815066209 4226319.115398505, 1916448.566173477 4226319.137055725, 1916448.5369593413 4226319.178229054, 1916448.5329031695 4226319.184081443, 1916448.428169362 4226319.330752156, 1916448.3337497665 4226319.464818064, 1916448.1441735006 4226319.735623579, 1916447.9252251377 4226320.045483189, 1916447.5255881632 4226320.608286792, 1916446.5958785599 4226321.909663203, 1916443.805356827 4226325.90341799, 1916442.0338189325 4226328.469641721, 1916437.8574240694 4226334.557952071, 1916417.8732278713 4226363.879697788, 1916412.1769442696 4226370.416057486, 1916406.9442963465 4226375.126087588, 1916399.3067989503 4226380.893620626, 1916396.7307387746 4226382.669648189, 1916392.3266327986 4226385.3744717995, 1916387.3411526252 4226388.237626449, 1916380.797028285 4226391.821668937, 1916373.9368717293 4226395.508819421, 1916369.7083239376 4226397.744819511, 1916365.4544720927 4226401.196068884, 1916360.7770249099 4226405.32146632, 1916355.3398970363 4226410.136345284, 1916352.891936984 4226412.804020931, 1916349.4692913939 4226416.456741335, 1916344.4161899136 4226421.952027479, 1916337.23845618 4226430.174520975, 1916333.255544972 4226434.855080911, 1916329.6244894022 4226439.416812749, 1916325.42648883 4226444.6891608015, 1916315.9914085066 4226456.712662229, 1916303.0901867156 4226471.929374563, 1916284.754170677 4226492.436314191, 1916278.0577994722 4226499.418471453, 1916271.7162251193 4226505.657039962, 1916265.1895744235 4226511.670836187, 1916261.0376873298 4226515.468745677, 1916252.0814563239 4226523.601869826, 1916250.8985210308 4226524.679955891, 1916250.804864341 4226524.765007701, 1916237.7192952386 4226536.665550315, 1916227.9821211076 4226545.652587792, 1916222.90210115 4226550.3596146535, 1916210.0814066515 4226562.356237932, 1916194.1978160564 4226577.044745843, 1916187.8995910913 4226582.719438509, 1916187.5205978993 4226583.060584721, 1916203.4678651956 4226588.16215691, 1916219.8669864228 4226594.303036361, 1916240.0052637216 4226603.082029218, 1916292.2002059266 4226635.703078036, 1916350.8784261132 4226673.307823887, 1916381.76375 4226693.1725, 1916447.58625 4226735.303125001, 1916493.29875 4226764.808750002, 1916522.56875 4226783.543750002, 1916570.4206250014 4226814.48625, 1916592.5521459559 4226828.757005057, 1916655.9596993222 4226870.091216775, 1916702.8313309716 4226900.765240386, 1916735.0465435323 4226921.549232752, 1916777.4228108965 4226949.021383467, 1916799.7772501193 4226963.526121788, 1916803.4475000042 4226965.962500006, 1916813.991313572 4226972.978691002, 1916835.7639429553 4226986.918141919, 1916850.5216597342 4226996.385405681, 1916892.2090670583 4227023.967931287, 1916896.4899536334 4227026.799629135, 1916902.5950213003 4227031.052769182, 1916933.7786166873 4227053.497409551, 1916970.2891723616 4227085.088262147, 1916988.6642764488 4227101.236319005, 1917009.3985562671 4227119.310491108, 1917012.340227931 4227121.863639387, 1917014.0599934373 4227123.362519773, 1917015.8378807148 4227124.908236723, 1917017.609059778 4227126.449406202, 1917018.508224243 4227127.237787502, 1917020.4167120054 4227128.889984152, 1917024.596166111 4227132.495358774, 1917028.913043131 4227136.231268747, 1917031.8499059852 4227138.777494307, 1917035.9098869597 4227142.24696652, 1917039.5123792116 4227145.291296099, 1917039.52706012 4227145.30371883, 1917060.5773798109 4227163.105187254, 1917081.6702925304 4227181.032320816, 1917086.4867678494 4227185.0438840855, 1917089.218662535 4227187.320059695, 1917092.511509608 4227189.907945603, 1917102.7064689035 4227197.959327647, 1917128.1856250246 4227217.0368750235, 1917149.3518750023 4227230.725625006, 1917171.2341019502 4227242.412689541, 1917188.0524797211 4227250.3823917005, 1917215.8547465834 4227262.277442125, 1917233.0203973514 4227268.657019491, 1917252.1131214807 4227274.494262478, 1917284.4024430467 4227282.152881967, 1917286.4802314364 4227283.271218067, 1917289.566864144 4227284.485175207, 1917298.497721285 4227292.450391981, 1917304.4786383065 4227296.893543656, 1917308.9969310383 4227300.285872644, 1917309.606812881 4227300.763247903, 1917314.3525875176 4227304.109716082, 1917332.0769520917 4227316.238216716, 1917337.5167828156 4227319.83765517, 1917343.2416634269 4227323.473587919, 1917354.2949772503 4227330.071086705, 1917362.7207964675 4227334.983487332, 1917386.072835699 4227349.189106465, 1917448.9424394877 4227386.744948518, 1917464.4155160945 4227396.106933824, 1917525.9156249992 4227434.3568750005, 1917547.4372940876 4227447.662593944, 1917592.3062382129 4227474.518318103, 1917610.4996997924 4227485.664999727, 1917620.348518198 4227491.974042654, 1917632.9645289632 4227500.389985611, 1917648.2355399781 4227510.881220491, 1917664.6635336524 4227522.445977725, 1917682.0657892593 4227534.524450763, 1917690.7016924792 4227540.493284775, 1917696.9488329336 4227544.8252761, 1917730.820103682 4227568.292428782, 1917743.5093750006 4227577.839375007, 1917743.6468405584 4227596.990301251, 1917743.6470423813 4227610.13125531, 1917742.5521865587 4227648.330067054, 1917740.4960670767 4227684.37179241, 1917739.0503744958 4227719.616766192, 1917777.0877650208 4227734.539721214, 1917862.525 4227768.434375, 1917886.9722517668 4227777.928700639, 1917905.075 4227787.060624999, 1917929.0805014947 4227800.006019811, 1917953.7114022884 4227814.239906548, 1917957.2504308268 4227816.296510458, 1917969.1958959415 4227825.190946786, 1917971.9287785043 4227828.285220577, 1917980.0991765545 4227837.078602566, 1917979.9396383606 4227840.072938992, 1917980.0128109297 4227842.872984271, 1917968.1806824792 4227867.270456149, 1917965.6907038637 4227873.361775475, 1917960.5361117793 4227885.514803585, 1917951.3630529377 4227899.453445292, 1917935.673124999 4227920.618125, 1917925.8100000015 4227931.905, 1917925.3969503655 4227933.396061435, 1917925.7893750137 4227936.7624999955, 1917927.7746820736 4227952.625232948, 1917931.57075945 4227988.889658935, 1917934.3627073346 4228012.525780859, 1917935.9371850116 4228023.979569407, 1917935.6803588918 4228027.552645928, 1917934.6626067737 4228039.499332926, 1917933.9422123693 4228046.778029662, 1917933.6320098438 4228048.39854463, 1917929.3078467723 4228057.72231766, 1917926.3400636388 4228066.513480586, 1917915.3442971061 4228086.573917632, 1917913.9047836475 4228088.5468832115, 1917909.9127137307 4228093.272075601, 1917905.1843089429 4228098.815609756, 1917889.2247197723 4228117.512657517, 1917868.8659407978 4228141.5792798195, 1917859.9037756235 4228152.6192156505, 1917859.468451277 4228154.065760133, 1917859.550101033 4228156.489240745, 1917859.6250770662 4228158.025830205, 1917863.9278271117 4228162.486883267, 1917866.5188772092 4228165.085156771, 1917867.67687501 4228166.283750007, 1917876.610640006 4228175.300785891, 1917878.3703278315 4228178.220178782, 1917880.0099924922 4228180.843091549, 1917879.9828711604 4228182.657208382, 1917880.0565171198 4228183.6784227025, 1917878.3027849887 4228186.660666875, 1917865.8170808551 4228208.690598409, 1917860.6820971204 4228220.834795147, 1917856.7968749995 4228227.93625, 1917851.570480005 4228238.211834933, 1917850.6245299168 4228239.62164112, 1917841.9355716456 4228251.247082616, 1917829.3188584317 4228265.233374313, 1917823.1842026492 4228269.373785359, 1917821.718907005 4228271.1333765, 1917821.2018866914 4228271.748644343, 1917820.4662593482 4228272.628850067, 1917819.7922863893 4228273.441352852, 1917819.163912087 4228274.205917104, 1917817.0056752765 4228276.830669724, 1917813.223723092 4228281.25954997, 1917810.540302294 4228284.247219802, 1917806.233684738 4228288.788573169, 1917804.3380481664 4228290.774353977, 1917803.3840799846 4228291.73109239, 1917802.4756471114 4228292.608611353, 1917800.0061156226 4228294.969856328, 1917799.4398849076 4228295.61860308, 1917798.5321595524 4228296.657355226, 1917797.5673693272 4228298.097708215, 1917797.1851670055 4228298.6724640485, 1917793.2678269148 4228305.207993178, 1917790.2094042932 4228310.518693511, 1917786.4055150999 4228318.900378021, 1917768.94099397 4228337.650293047, 1917761.5220974514 4228344.768282232, 1917731.7308055782 4228369.431900332, 1917725.481511391 4228379.2593725035, 1917718.549556149 4228390.739104625, 1917714.3965779808 4228398.559089765, 1917712.1543889157 4228404.235744562, 1917708.9850721697 4228439.884771115, 1917703.7699793286 4228454.823983543, 1917705.9365585153 4228455.301146816, 1917705.901594716 4228455.437631213, 1917745.5014392193 4228464.325587068, 1917745.6622827875 4228494.7391707925, 1917752.3607920846 4228532.902462428, 1917759.5465379693 4228610.2116961125, 1917760.5024085653 4228609.803467736, 1917760.5304274035 4228610.11292953, 1917782.9479479876 4228600.849225054, 1917788.4231725638 4228601.82319819, 1917791.8812229654 4228602.879081526, 1917845.1772163117 4228619.192877756, 1917860.8184049907 4228623.855102938, 1917859.7879659508 4228638.985447903, 1917889.6934898063 4228674.72613795, 1917937.8943743412 4228737.845319736, 1917904.024732444 4228802.78902455, 1917897.07749997 4228816.0562500525, 1917869.6297886826 4228814.800460208, 1917869.6093226683 4228815.813527914))'::geometry,'38229','Meylan','MEYLAN','MEY','MEY'),
     (8,'SRID=3945;POLYGON ((1906399.2909579559 4201294.212232185, 1906400.0260417974 4201294.2161902115, 1906404.695418795 4201294.50821442, 1906422.5741553481 4201297.640448555, 1906437.0252530572 4201302.638698181, 1906454.9574848907 4201319.914078639, 1906483.9693421514 4201325.207290554, 1906501.4847271903 4201324.631751306, 1906516.4649546763 4201322.412251311, 1906535.628628856 4201322.902769424, 1906560.7454289491 4201327.3631227305, 1906574.3062472246 4201327.547085991, 1906580.587867433 4201327.65744969, 1906596.4362130137 4201323.792513183, 1906607.5610973788 4201321.121422455, 1906620.978136666 4201320.235262481, 1906631.0836819024 4201323.948703901, 1906642.8817068224 4201334.483541282, 1906650.3019898497 4201343.301652782, 1906697.6756502097 4201413.200394655, 1906738.6812942522 4201474.094869762, 1906759.758203011 4201509.129762898, 1906768.5042911659 4201514.490999371, 1906782.544153156 4201519.47592029, 1906794.377248206 4201547.672116451, 1906804.3774904138 4201556.300951026, 1906824.1439641817 4201564.771720117, 1906830.269422008 4201567.315182757, 1906834.39 4201567.63, 1906842.7141262598 4201566.501356392, 1906852.63194041 4201570.7855830835, 1906854.0858170162 4201571.452699125, 1906860.1385449125 4201575.658654105, 1906865.3395671565 4201581.429224401, 1906866.301497886 4201581.289557567, 1906866.7893924778 4201581.758475079, 1906878.4139962303 4201582.582942, 1906889.5825187792 4201587.794350605, 1906895.2583736852 4201590.526642153, 1906902.6949019332 4201592.894818403, 1906909.546563279 4201594.2463343805, 1906914.4235372583 4201595.658964634, 1906919.4943478839 4201599.458241162, 1906922.4684372232 4201601.48233337, 1906931.082140005 4201606.062163382, 1906952.5983835561 4201617.093371197, 1906955.9507336793 4201616.995603022, 1906961.3856957234 4201616.816867438, 1906972.420469687 4201621.138165218, 1906973.6855799516 4201621.663978794, 1906977.2989583607 4201623.809845761, 1906979.548641889 4201625.161488759, 1906987.924537084 4201630.747539569, 1906995.051909596 4201635.508032764, 1906997.284878548 4201637.323656795, 1907007.6102520314 4201647.19921126, 1907012.5798285573 4201651.194136691, 1907018.7547016563 4201656.637526059, 1907022.8623474806 4201662.988022682, 1907025.8170687659 4201667.609802616, 1907032.081831994 4201675.096026496, 1907040.3929770587 4201686.181761057, 1907053.2290311444 4201690.315946341, 1907066.5896841716 4201700.524770057, 1907067.6908467622 4201701.384034339, 1907069.985638066 4201702.820390206, 1907071.4549292629 4201703.746788902, 1907074.0851192577 4201706.299296121, 1907077.9028258892 4201718.137385234, 1907079.4806758487 4201724.671998281, 1907083.7270750487 4201735.952171493, 1907098.4584866874 4201765.671155152, 1907101.957717417 4201771.962563858, 1907105.037693094 4201777.2706864625, 1907112.84812372 4201789.382235887, 1907115.2675523427 4201802.330447584, 1907115.8359413256 4201805.889167317, 1907118.578451569 4201822.880625005, 1907119.8297673832 4201832.600587102, 1907121.741643171 4201842.61361966, 1907124.1754648911 4201855.659576465, 1907128.2939345364 4201871.884021621, 1907133.1960511392 4201882.655010531, 1907134.0641947503 4201885.2315888405, 1907137.9305654217 4201903.674334266, 1907148.2385777773 4201917.431711616, 1907148.4393949164 4201929.669713142, 1907148.8583211964 4201931.062279106, 1907149.0661992037 4201931.875192667, 1907153.6506098206 4201938.081533684, 1907153.7498909493 4201939.15480533, 1907153.9598516042 4201942.1693464015, 1907147.1511546648 4201957.710232942, 1907146.8325096418 4201962.539960338, 1907149.847335819 4201966.804127541, 1907169.7836011047 4201993.18266477, 1907179.5787862863 4202007.200761959, 1907183.3837285487 4202024.294067028, 1907189.0470805962 4202058.503439173, 1907188.6176741756 4202094.133933531, 1907195.2107790366 4202115.805475912, 1907203.2559690238 4202135.7522878945, 1907206.2040029734 4202144.479383883, 1907207.034947304 4202147.1271238625, 1907208.728306753 4202153.518144677, 1907214.767616292 4202177.0540364655, 1907217.9556043153 4202187.745013213, 1907220.837699198 4202203.012812912, 1907223.4584249784 4202219.013526272, 1907219.9336370286 4202239.485941678, 1907225.4612701535 4202257.980384684, 1907230.173203466 4202260.189397226, 1907245.0959724097 4202266.824272481, 1907250.7659064326 4202272.455944997, 1907253.8784919225 4202275.655990676, 1907256.2181801244 4202281.207766181, 1907258.4923450504 4202282.556337552, 1907259.253148578 4202283.0999101205, 1907262.1796828462 4202283.443315586, 1907277.0546612658 4202283.484053579, 1907303.7153046655 4202293.521742884, 1907319.5350335252 4202301.741334903, 1907349.908972251 4202317.195515829, 1907370.3822179474 4202331.680838249, 1907393.8934612786 4202340.9600153025, 1907426.354077949 4202358.878014676, 1907442.6125779215 4202369.670891898, 1907463.8610541627 4202385.259572334, 1907465.56191223 4202385.8642365085, 1907466.5352229874 4202386.194307898, 1907489.8031588409 4202388.170708806, 1907501.6526577545 4202390.063270822, 1907518.7488682277 4202395.083620886, 1907520.4961721578 4202395.275481605, 1907527.240497607 4202395.850639873, 1907544.4645963528 4202392.451154633, 1907551.3668816194 4202391.153841232, 1907553.142973626 4202391.4285352575, 1907553.4574703919 4202391.475859093, 1907575.177918274 4202400.688356965, 1907575.4895929159 4202400.771781443, 1907577.5654408669 4202401.306551422, 1907588.8562520845 4202402.416333706, 1907599.9006291486 4202403.500815226, 1907601.0975956975 4202403.922434004, 1907603.148694957 4202404.557580998, 1907606.7775925049 4202407.165971055, 1907607.261560574 4202407.538636755, 1907612.7469649508 4202412.934316927, 1907625.165823053 4202425.176451406, 1907626.471662352 4202425.184774333, 1907635.1572330415 4202425.077331146, 1907638.695602248 4202427.707054038, 1907640.600114636 4202428.925242278, 1907651.429553335 4202447.172590558, 1907665.2029767092 4202476.433598195, 1907680.647163106 4202506.4435420325, 1907683.2741091186 4202522.559806266, 1907680.7765847174 4202528.4271246875, 1907668.142564278 4202551.237237001, 1907671.3044933092 4202571.061716027, 1907675.0799259418 4202580.886759523, 1907687.6040282412 4202598.720008596, 1907689.1085376642 4202603.47804254, 1907693.6264887888 4202655.21873965, 1907699.064194127 4202670.23446925, 1907704.9275273825 4202680.6194718825, 1907706.2614411267 4202683.062830647, 1907708.5784429365 4202686.04814364, 1907714.390979268 4202693.535535103, 1907749.5471964183 4202724.055386166, 1907767.8101914688 4202729.16326852, 1907771.5389012848 4202731.335800844, 1907774.307355512 4202733.126067224, 1907796.497278006 4202753.599355203, 1907819.9712933202 4202754.296023008, 1907851.3955892492 4202748.282605403, 1907895.3797254078 4202730.293177581, 1907902.789515581 4202734.476912129, 1907906.2835781751 4202736.44427492, 1907931.3239897932 4202762.56020999, 1907949.0755521904 4202769.041774408, 1907970.2544713041 4202773.564869633, 1908000.2283896694 4202771.43755116, 1908010.9561268825 4202772.0416900525, 1908012.432318232 4202772.739666309, 1908018.774030451 4202775.744469022, 1908049.1163865414 4202795.816137062, 1908066.2380914858 4202798.442417408, 1908078.4683755338 4202795.755165303, 1908111.304270591 4202786.701090509, 1908146.019731397 4202788.6619575145, 1908158.8972260617 4202793.1604139, 1908162.15 4202792.92, 1908148.23 4202713.41, 1908147.51 4202709.32, 1908146.78 4202705.1, 1908151.77 4202667.64, 1908164.82 4202617.35, 1908200.56 4202511.8, 1908205.56 4202469.97, 1908208.99 4202457.85, 1908290.88 4202371.32, 1908315.61 4202348.18, 1908325.05 4202336.46, 1908335.74 4202318.42, 1908341.95 4202296.38, 1908342.46 4202284.58, 1908338.3 4202255, 1908329.14 4202206.53, 1908322.43 4202173.43, 1908320.37 4202150.87, 1908324.57 4202095.9, 1908324.45 4202060.65, 1908320.49 4201945.31, 1908321.26 4201908.26, 1908327.45 4201850.06, 1908337.28 4201780.91, 1908338.15 4201763.15, 1908335.79 4201743.51, 1908318.71 4201688.98, 1908310.68 4201667.29, 1908303.05 4201651.04, 1908292.99 4201633.45, 1908282.36 4201618.97, 1908269.94 4201605.8, 1908238.05 4201579.98, 1908203.36 4201554.66, 1908178.13 4201533.25, 1908160.97 4201513.14, 1908152.44 4201499.7, 1908143.64 4201482.54, 1908138.19 4201465.2, 1908134.53 4201447.27, 1908129.6 4201407.7, 1908131.76 4201279.83, 1908130.04 4201251.06, 1908126.84 4201226.91, 1908115.35 4201187.39, 1908110.79 4201175.09, 1908057.56 4201077.78, 1908043.11 4201048.82, 1908030.8 4201014.78, 1908013.46 4200970.55, 1908007.84 4200950.74, 1908002.84 4200921.31, 1908000.17 4200914.29, 1907994.23 4200905.94, 1907979.07 4200894.26, 1907921.87 4200868.43, 1907901.06 4200857.95, 1907830.48 4200804.61, 1907818.38 4200788.44, 1907811 4200771.8, 1907808.59 4200756.48, 1907809.48 4200741.32, 1907816.68 4200710.64, 1907834.77 4200648.47, 1907834.37 4200634.98, 1907832.44 4200619.12, 1907827.3 4200605.48, 1907816.21 4200593.47, 1907777.59 4200562.79, 1907738.65 4200532.7, 1907708.96 4200506.17, 1907664.11 4200475.78, 1907618.36 4200448.8, 1907615.27 4200448.12, 1907611.51 4200436.13, 1907593.84 4200417.37, 1907588.1 4200399.38, 1907589.5 4200381.34, 1907595.12 4200359.68, 1907623.15 4200283.15, 1907628.26 4200264.21, 1907628.27 4200247.93, 1907619.08 4200226.82, 1907589.73 4200213.56, 1907534.57 4200203.21, 1907517.61 4200195.9, 1907506.93 4200185.13, 1907502.83 4200165.29, 1907496.28 4200116.5, 1907486.52 4200099.07, 1907459.48 4200069.6, 1907429.66 4200030.62, 1907423.03 4200010.45, 1907423.9 4199998.55, 1907429.18 4199981.31, 1907438.09 4199964.53, 1907451.21 4199942.65, 1907459.07 4199926.13, 1907461.81 4199910.23, 1907461.45 4199890.21, 1907460.49 4199884.83, 1907457.68 4199878.78, 1907440.38 4199855.11, 1907430.66 4199843.29, 1907419.41 4199830.24, 1907407.84 4199817.47, 1907402.72 4199808.99, 1907397.61 4199795.06, 1907392.96 4199763.12, 1907387.33 4199741.47, 1907374.54 4199720.23, 1907366.3 4199710.51, 1907357.32 4199703.21, 1907348.22 4199696.38, 1907338.9 4199689.88, 1907321.18 4199680.13, 1907307.14 4199675.98, 1907286.73 4199672.25, 1907280.1 4199671.5, 1907264.13 4199669.98, 1907248.13 4199668.89, 1907232.11 4199668.22, 1907216.07 4199667.98, 1907200.03 4199668.17, 1907184.01 4199668.77, 1907138.08 4199677.1, 1907123.14 4199676.06, 1907077.96 4199670.51, 1907076.47 4199670.33, 1907075.42 4199670.29, 1907026.56 4199668.3, 1907017.28 4199665.61, 1907008.71 4199659.71, 1907001.14 4199652.62, 1906997.7 4199647.56, 1906993.77 4199641.1, 1906990.22 4199634.44, 1906987.43 4199610.92, 1906983.67 4199600.08, 1906977.86 4199589.51, 1906973.27 4199583.61, 1906967.41 4199579.12, 1906949.71 4199570.64, 1906943.34 4199566.22, 1906938.64 4199559.05, 1906934.72 4199542.23, 1906928.99 4199528.04, 1906922.62 4199516.93, 1906912.16 4199506.39, 1906903.28 4199501.04, 1906884.94 4199495, 1906870.77 4199494.49, 1906851.21 4199496.61, 1906830.09 4199496.87, 1906818.72 4199492.87, 1906809.38 4199487.65, 1906800.58 4199479.96, 1906767.33 4199442.6, 1906755.14 4199426.16, 1906749.43 4199421.09, 1906740.57 4199419.65, 1906704.84 4199426.72, 1906690.7 4199428.5, 1906681.37 4199426.02, 1906668.78 4199416.85, 1906662.63 4199408.64, 1906643.73 4199374.94, 1906635.44 4199368.15, 1906623.9 4199363.44, 1906598.77 4199358.86, 1906565.27 4199344.9, 1906529.75 4199330.55, 1906491.33 4199326.15, 1906445.39 4199328.41, 1906436.19 4199328.31, 1906432.51 4199328.28, 1906427.9 4199329.24, 1906401.93 4199334.72, 1906380.06 4199346.46, 1906341.5 4199371.87, 1906316.57 4199383.97, 1906302.86 4199387.08, 1906290.47 4199386.75, 1906277.95 4199382.24, 1906215.67 4199339.63, 1906204.38 4199333.57, 1906195.6 4199331.19, 1906154.13 4199334.77, 1906116.03 4199330.25, 1906097.83 4199323.37, 1906086.02 4199316.03, 1906046.69 4199283.02, 1906035.09 4199274.07, 1906022.76 4199269.9, 1906012.15 4199270.58, 1905995.06 4199277.58, 1905984.35 4199278.21, 1905974.49 4199276.71, 1905960.02 4199271.62, 1905947.69 4199262.25, 1905922.59 4199235.58, 1905910.08 4199226.48, 1905898.7 4199222.98, 1905854.71 4199220.32, 1905831.61 4199217.47, 1905806.67 4199211.1, 1905777.63 4199196.7, 1905733.54 4199164.75, 1905718.48 4199156.39, 1905652.61 4199139.96, 1905637.38 4199133.38, 1905615.57 4199115.76, 1905570.69 4199063.73, 1905516.49 4199031.4, 1905498.03 4199016.35, 1905473.65 4199005.71, 1905423.23 4199012.44, 1905399.97 4199011.9, 1905386.88 4199008.05, 1905325.79 4198974.38, 1905314.43 4198971.95, 1905300.75 4198974.15, 1905189.32 4199037.28, 1905159.3 4199056.29, 1905110.07 4199074.51, 1905094.52 4199077.87, 1905080.2 4199074.08, 1905047.27 4199056.81, 1905028.64 4199041.65, 1905010.73 4199023.88, 1905002.22 4199012.96, 1904997.15 4199003.21, 1904994.09 4198994.81, 1904989.57 4198968.39, 1904977.65 4198892.15, 1904975.55 4198886, 1904970.1 4198880.42, 1904953.38 4198868.21, 1904949.69 4198864.3, 1904925.8 4198832.81, 1904912.98 4198818.67, 1904892.26 4198805.81, 1904880.19 4198800.62, 1904871.72 4198799.37, 1904860.13 4198800.43, 1904810.27 4198808.03, 1904802.66 4198806.72, 1904762.61 4198778.37, 1904728.04 4198763.56, 1904705.33 4198759.11, 1904692.89 4198757.95, 1904682.15 4198756.48, 1904671.48 4198754.6, 1904663 4198750.89, 1904655.3 4198744.73, 1904648.83 4198735.02, 1904634.2 4198716.95, 1904627.78 4198713.86, 1904617.44 4198711.97, 1904604.08 4198712.41, 1904586.97 4198718.31, 1904572.75 4198725.9, 1904528.57 4198761.73, 1904502.76 4198777.24, 1904489.3 4198780.71, 1904444.95 4198786.87, 1904397.18 4198795.8, 1904322.34 4198816.53, 1904295.88 4198824.72, 1904283.19 4198831.44, 1904250.42 4198858.11, 1904240.52 4198863.5, 1904230.94 4198867.05, 1904212.3 4198872.84, 1904185.71 4198877.32, 1904163.37 4198878.63, 1904151.78 4198876.3, 1904135.75 4198867.52, 1904133.2 4198864.2, 1904107.79 4198851.26, 1904073.8 4198838.68, 1904039.09 4198827.98, 1904028.26 4198823.03, 1903986.28 4198796.81, 1903960.42 4198772.1, 1903936.57 4198744.68, 1903909.75 4198706.44, 1903901.36 4198697.58, 1903892.08 4198691.51, 1903880.18 4198687.78, 1903842.93 4198682.63, 1903805.12 4198673.64, 1903792.11 4198668.83, 1903774.16 4198659.38, 1903759.49 4198647.96, 1903746.3 4198632.42, 1903736.45 4198614.18, 1903726.58 4198595.01, 1903717.09 4198575.66, 1903704.03 4198553.01, 1903689.86 4198534.14, 1903680.13 4198523.66, 1903655.93 4198504.89, 1903645.83 4198498.86, 1903627.91 4198495.11, 1903600.3 4198494.41, 1903560.73 4198491, 1903550.13 4198486.85, 1903541.33 4198480.76, 1903535.89 4198475.06, 1903513.35 4198438.05, 1903488.7 4198418.26, 1903476.89 4198412.75, 1903463.32 4198410.06, 1903454.73 4198410.48, 1903442.54 4198411.42, 1903430.39 4198412.79, 1903410.71 4198412.68, 1903395.37 4198410.06, 1903352.85 4198386.7, 1903323.58 4198373.7, 1903295.33 4198364.27, 1903247.92 4198350.93, 1903207.7 4198341.56, 1903169.16 4198334.18, 1903145.28 4198331.02, 1903130.56 4198330.76, 1903110.86 4198332.28, 1903087.27 4198336.77, 1903048.69 4198351.5, 1903028.88 4198357.73, 1903025.72 4198358.22, 1903018.17 4198359.13, 1903010.58 4198359.6, 1903002.97 4198359.66, 1902960.23 4198352.05, 1902952.3 4198353.36, 1902946.8 4198356.46, 1902940.46 4198363.58, 1902936.2 4198371.61, 1902930.4 4198381.73, 1902924.24 4198391.64, 1902916.75 4198398.43, 1902909.43 4198402.58, 1902874.86 4198417.68, 1902865.25 4198423.91, 1902861.55 4198429.05, 1902859.78 4198437.11, 1902859.65 4198443.21, 1902872.23 4198473.99, 1902876.1 4198486.35, 1902878.6 4198499.57, 1902879.61 4198513.72, 1902878.12 4198524.27, 1902874.39 4198537.24, 1902865.32 4198554.61, 1902859.93 4198558.93, 1902814.31 4198571.88, 1902805 4198576.66, 1902798.88 4198583.39, 1902794.1 4198593.42, 1902786.37 4198618.61, 1902784.84 4198631.21, 1902781.31 4198647.45, 1902778.94 4198652.15, 1902770.36 4198658.31, 1902753.05 4198667.8, 1902736.11 4198679.46, 1902735.49 4198683.55, 1902737.08 4198690.21, 1902749.9 4198707.01, 1902753.39 4198714.75, 1902754.95 4198725.35, 1902752.23 4198736.84, 1902741.56 4198761.92, 1902733.57 4198788.95, 1902723.41 4198828.3, 1902713.26 4198858.53, 1902709.04 4198866.5, 1902693.91 4198890.87, 1902687.1 4198905.47, 1902677.52 4198922.73, 1902658.55 4198953.01, 1902663.88 4198949.75, 1902670.99 4198943.19, 1902703.52 4198911.59, 1902705.86 4198911.17, 1902746.64 4198916.17, 1902754.57 4198913.71, 1902785.59 4198901.35, 1902795.21 4198896.6, 1902824.39 4198880.02, 1902833.23 4198883.08, 1902839.19 4198885.67, 1902851.96 4198889.95, 1902856.41 4198895.16, 1902862.27 4198895.9, 1902884.34 4198898.64, 1902891.85 4198899.01, 1902916.6 4198895.94, 1902936.78 4198905.2, 1902942.56 4198906.3, 1902956.46 4198907.17, 1902970.21 4198915.71, 1903002.43 4198923.05, 1903021.06 4198929.08, 1903029.2 4198947.63, 1903032.81 4198952.53, 1903042.04 4198961.68, 1903066.64 4198965.94, 1903077.25 4198961.96, 1903087.7 4198957.6, 1903094.04 4198954.71, 1903101.28 4198951.47, 1903106.98 4198965.76, 1903112.28 4198980.2, 1903115.49 4198989.6, 1903127.55 4199023.59, 1903138.4 4199016.03, 1903150.75 4199012.77, 1903170.97 4199007.56, 1903193.15 4199068.9, 1903196.33 4199077.61, 1903225.8 4199094.76, 1903250.11 4199109.04, 1903252.82 4199112.96, 1903274.89 4199151.15, 1903284.93 4199168.11, 1903293.75 4199169.97, 1903307.28 4199172.82, 1903310.67 4199179.06, 1903317.28 4199191.25, 1903318.23 4199193, 1903316.96 4199206.42, 1903317.61 4199208.52, 1903319.91 4199211.65, 1903322.79 4199213.79, 1903336.15 4199216.58, 1903340.43 4199219.94, 1903356.46 4199235.03, 1903367.28 4199245.34, 1903379.49 4199256.26, 1903390.1 4199265.68, 1903405.5 4199296.47, 1903409.71 4199302.49, 1903414.57 4199306.71, 1903436.51 4199317.47, 1903439.24 4199322.7, 1903447.72 4199344.24, 1903459.07 4199378.97, 1903461.81 4199386.25, 1903465.43 4199391.18, 1903469.37 4199395.85, 1903473.65 4199400.23, 1903475.13 4199401.62, 1903485.45 4199422.2, 1903489.33 4199426.92, 1903512.53 4199455.65, 1903524.7 4199469.64, 1903553.09 4199496, 1903564.83 4199517.46, 1903574.93 4199521.95, 1903583.29 4199532.79, 1903587.67 4199541.34, 1903599.77 4199545.81, 1903596.42 4199550.64, 1903609.64 4199563.92, 1903630.4 4199568.93, 1903635.86 4199585.07, 1903652.17 4199596.07, 1903663.77 4199595.93, 1903660.44 4199605.06, 1903679.52 4199612.51, 1903676.86 4199619.07, 1903680.66 4199625.91, 1903687.12 4199632.12, 1903693.88 4199638.01, 1903698.34 4199641.61, 1903700.62 4199651.78, 1903707.92 4199653.3, 1903734.1 4199673.33, 1903742.77 4199679.03, 1903769.06 4199686.76, 1903768.4 4199693.88, 1903774.7 4199702.56, 1903779.74 4199698.01, 1903791.98 4199729.26, 1903805.08 4199743.07, 1903818.48 4199756.59, 1903829.99 4199767.72, 1903833.23 4199773.97, 1903836.85 4199780.03, 1903840.41 4199785.28, 1903841.39 4199809.87, 1903847.81 4199820.38, 1903856.39 4199821.92, 1903868.54 4199833.86, 1903871.52 4199849.2, 1903877.54 4199856.48, 1903888.59 4199865.19, 1903898.33 4199881.53, 1903910.79 4199896.78, 1903915.32 4199901.18, 1903926.46 4199908.91, 1903931.14 4199915.9, 1903938.3 4199918.86, 1903944.85 4199930.69, 1903962.91 4199965.79, 1903976.54 4199991.66, 1903978.52 4199996.72, 1903985.35 4199999.53, 1903985.9 4200008.97, 1904000.79 4200017.61, 1904027.99 4200036.85, 1904053.23 4200055.3, 1904077.24 4200072.37, 1904128.29 4200143.56, 1904139.77 4200164.19, 1904177.31 4200197.38, 1904185.93 4200197.77, 1904193.02 4200208.53, 1904223.94 4200224.34, 1904226.28 4200232.43, 1904239.21 4200241.8, 1904242.85 4200247.27, 1904246.76 4200254.16, 1904262.92 4200273.25, 1904265.52 4200281.61, 1904272.34 4200290.87, 1904278.89 4200305.39, 1904305.36 4200334.44, 1904316.94 4200343.78, 1904341.45 4200360.98, 1904348.86 4200368.58, 1904357.28 4200383.47, 1904368.8 4200393.53, 1904385.93 4200432.98, 1904407.48 4200459.57, 1904421.3 4200467.39, 1904439.49 4200477.9, 1904457.58 4200488.6, 1904490.55 4200511.22, 1904501.58 4200519.49, 1904504.12 4200522.35, 1904522.48 4200549.12, 1904546.22 4200556.81, 1904573.69 4200583.52, 1904589.12 4200589.74, 1904610.43 4200612.17, 1904624.79 4200622.91, 1904695.05 4200660.28, 1904691.7 4200667.71, 1904736.08 4200713.22, 1904749.9 4200737.95, 1904757.33 4200766.85, 1904771.26 4200778.96, 1904784.67 4200786.69, 1904794.3 4200807.22, 1904802.85 4200825.51, 1904810.04 4200833.93, 1904820.73 4200854.06, 1904828.91 4200869.63, 1904869.31 4200917.21, 1904873.13 4200936.04, 1904880.58 4200940.2, 1904894.5 4200960.86, 1904907.21 4200973.09, 1904916.2 4200987.05, 1904926.27 4201004.48, 1904936.17 4201022.03, 1904939.83 4201028.64, 1904932.9 4201035.7, 1904958.11 4201070.95, 1904967.48 4201078.64, 1904976.72 4201086.49, 1904986.73 4201095.31, 1904993.17 4201104.14, 1904997.54 4201130.23, 1905017.95 4201145.01, 1905059.8 4201166.82, 1905077.25 4201170.28, 1905094.33 4201187.44, 1905101.14 4201193.86, 1905106.93 4201199.02, 1905112.87 4201204.01, 1905118.93 4201208.85, 1905126.45 4201214.47, 1905159.15 4201264.12, 1905187.69 4201296.67, 1905188.43 4201297.52, 1905189.03 4201298.78, 1905181.26 4201301.11, 1905180.01 4201314.2, 1905191.42 4201331.76, 1905213.97 4201366.33, 1905247.43 4201448.82, 1905247.84 4201474.4, 1905259.89 4201538.22, 1905264.59 4201565.02, 1905279.1206733093 4201602.005602976, 1905280.8632911097 4201600.441706997, 1905294.5491085234 4201588.05652252, 1905352.2282382485 4201539.097585757, 1905460.636159683 4201445.836978142, 1905566.5042366749 4201355.519661019, 1905693.3690458075 4201245.195312886, 1905706.4755375304 4201241.18446817, 1905717.0392181883 4201235.853574913, 1905732.9005753614 4201227.534193525, 1905751.9304971949 4201217.104362366, 1905765.6390749214 4201210.635178198, 1905768.2506533777 4201209.3152039265, 1905775.4591616294 4201201.374659112, 1905778.3079858413 4201197.239413435, 1905784.494910943 4201180.694200916, 1905785.8523816278 4201177.562894684, 1905806.188555119 4201167.571764954, 1905826.3439440886 4201157.413316345, 1905878.7199167542 4201132.299268389, 1905906.5217705797 4201130.966001222, 1905927.0286823958 4201132.269840001, 1905944.728845413 4201133.085422973, 1905964.3657822052 4201138.471807903, 1905984.787146905 4201142.92711857, 1906016.8369080725 4201148.955422959, 1906052.0271316012 4201154.540798054, 1906058.667773351 4201158.972259266, 1906076.2359741426 4201173.433863687, 1906086.0368666344 4201184.367865064, 1906090.93 4201193.395, 1906094.4387766945 4201203.066202907, 1906098.442195323 4201218.388841453, 1906120.8725890252 4201247.267545082, 1906138.8832604662 4201266.367573981, 1906152.8707763723 4201269.768756246, 1906179.6773628793 4201271.530393783, 1906198.9826419856 4201270.827648392, 1906203.808322861 4201269.734371242, 1906218.289142436 4201262.085430539, 1906228.011985364 4201257.138951203, 1906230.1307215707 4201257.003919064, 1906232.6213176202 4201256.757908218, 1906245.5775424195 4201258.684198163, 1906264.174715233 4201264.82939793, 1906291.7721276083 4201278.039341855, 1906306.5689216943 4201288.136975206, 1906331.694576629 4201285.867078944, 1906337.1525885444 4201285.48361996, 1906373.424942076 4201297.1993753975, 1906380.781526345 4201296.5426737, 1906387.0450858737 4201295.946227082, 1906399.2909579559 4201294.212232185))'::geometry,'38235','Miribel-Lanchâtre','MIRIBEL-<br>LANCHÂTRE','MIR','MBL'),
     (9,'SRID=3945;POLYGON ((1908853.49 4205955.89, 1908861.8791760218 4205935.8526068, 1908862.9827219434 4205933.216728161, 1908863.4910990638 4205931.958475006, 1908864.0329786371 4205930.611243016, 1908866.9305036545 4205923.407376933, 1908888.79 4205869.06, 1908909.83 4205788.39, 1908912.83 4205788.52, 1908932.6 4205713.91, 1908942.95 4205683.75, 1908949.66 4205668.56, 1908959.9 4205638.37, 1908972.78 4205583.44, 1908976.54 4205572.2, 1908992.6 4205528.18, 1908996.6739288503 4205515.741007879, 1909007.98 4205481.22, 1909014.15 4205450.18, 1909016.2 4205403.03, 1909014.76 4205365.42, 1909012.4 4205348.35, 1909000.92 4205298.1, 1908997.37 4205289.16, 1908981.84 4205251.6, 1908942.25 4205191.64, 1908928.09 4205162.76, 1908912.46 4205120.01, 1908895.32 4205077.96, 1908877.63 4205035.47, 1908868.82 4205014.19, 1908860.74 4204987.89, 1908855.49 4204951.59, 1908843.99 4204906.34, 1908825.3 4204865.29, 1908800.19 4204827.59, 1908773.15 4204796.2, 1908740.14 4204754.08, 1908721.23 4204729.11, 1908707.69 4204707.21, 1908698.49 4204682.37, 1908696.06 4204673.31, 1908692.13 4204642.05, 1908693.5 4204586.08, 1908690.52 4204562.92, 1908679.85 4204525.75, 1908661.17 4204457.69, 1908654.01 4204431.61, 1908649.6 4204414.31, 1908643.14 4204378.61, 1908633.21 4204327.01, 1908615.82 4204269.26, 1908604.96 4204236.93, 1908581.15 4204167.34, 1908559.56 4204127.84, 1908509.47 4204056.54, 1908491.51 4204015.78, 1908519.28 4203960.31, 1908566.54 4203864.12, 1908576.47 4203822.27, 1908567.29 4203789.23, 1908514.08 4203728.38, 1908476.55 4203686.21, 1908456.89 4203659.37, 1908422.6 4203543.98, 1908404.36 4203491.63, 1908394.31 4203444.85, 1908380.23 4203346.59, 1908371.91 4203312.25, 1908356.26 4203272.29, 1908342.09 4203246.63, 1908308.52 4203204.93, 1908288.02 4203176.48, 1908268.02 4203139.05, 1908262.7 4203109.04, 1908251.95 4203059.56, 1908231.46 4203008.29, 1908215.05 4202979.57, 1908170.08 4202926.84, 1908160.75 4202809.1, 1908158.8972260617 4202793.1604139, 1908146.019731397 4202788.6619575145, 1908111.304270591 4202786.701090509, 1908078.4683755338 4202795.755165303, 1908066.2380914858 4202798.442417408, 1908049.1163865414 4202795.816137062, 1908018.774030451 4202775.744469022, 1908012.432318232 4202772.739666309, 1908010.9561268825 4202772.0416900525, 1908000.2283896694 4202771.43755116, 1907970.2544713041 4202773.564869633, 1907949.0755521904 4202769.041774408, 1907931.3239897932 4202762.56020999, 1907906.2835781751 4202736.44427492, 1907902.789515581 4202734.476912129, 1907895.3797254078 4202730.293177581, 1907851.3955892492 4202748.282605403, 1907819.9712933202 4202754.296023008, 1907796.497278006 4202753.599355203, 1907774.307355512 4202733.126067224, 1907771.5389012848 4202731.335800844, 1907767.8101914688 4202729.16326852, 1907749.5471964183 4202724.055386166, 1907714.390979268 4202693.535535103, 1907708.5784429365 4202686.04814364, 1907706.2614411267 4202683.062830647, 1907704.9275273825 4202680.6194718825, 1907699.064194127 4202670.23446925, 1907693.6264887888 4202655.21873965, 1907689.1085376642 4202603.47804254, 1907687.6040282412 4202598.720008596, 1907675.0799259418 4202580.886759523, 1907671.3044933092 4202571.061716027, 1907668.142564278 4202551.237237001, 1907680.7765847174 4202528.4271246875, 1907683.2741091186 4202522.559806266, 1907680.647163106 4202506.4435420325, 1907665.2029767092 4202476.433598195, 1907651.429553335 4202447.172590558, 1907640.600114636 4202428.925242278, 1907638.695602248 4202427.707054038, 1907635.1572330415 4202425.077331146, 1907626.471662352 4202425.184774333, 1907625.165823053 4202425.176451406, 1907612.7469649508 4202412.934316927, 1907607.261560574 4202407.538636755, 1907606.7775925049 4202407.165971055, 1907603.148694957 4202404.557580998, 1907601.0975956975 4202403.922434004, 1907599.9006291486 4202403.500815226, 1907588.8562520845 4202402.416333706, 1907577.5654408669 4202401.306551422, 1907575.4895929159 4202400.771781443, 1907575.177918274 4202400.688356965, 1907553.4574703919 4202391.475859093, 1907553.142973626 4202391.4285352575, 1907551.3668816194 4202391.153841232, 1907544.4645963528 4202392.451154633, 1907527.240497607 4202395.850639873, 1907520.4961721578 4202395.275481605, 1907518.7488682277 4202395.083620886, 1907501.6526577545 4202390.063270822, 1907489.8031588409 4202388.170708806, 1907466.5352229874 4202386.194307898, 1907465.56191223 4202385.8642365085, 1907463.8610541627 4202385.259572334, 1907442.6125779215 4202369.670891898, 1907426.354077949 4202358.878014676, 1907393.8934612786 4202340.9600153025, 1907370.3822179474 4202331.680838249, 1907349.908972251 4202317.195515829, 1907319.5350335252 4202301.741334903, 1907303.7153046655 4202293.521742884, 1907277.0546612658 4202283.484053579, 1907262.1796828462 4202283.443315586, 1907259.253148578 4202283.0999101205, 1907258.4923450504 4202282.556337552, 1907256.2181801244 4202281.207766181, 1907253.8784919225 4202275.655990676, 1907250.7659064326 4202272.455944997, 1907245.0959724097 4202266.824272481, 1907230.173203466 4202260.189397226, 1907225.4612701535 4202257.980384684, 1907219.9336370286 4202239.485941678, 1907223.4584249784 4202219.013526272, 1907220.837699198 4202203.012812912, 1907217.9556043153 4202187.745013213, 1907214.767616292 4202177.0540364655, 1907208.728306753 4202153.518144677, 1907207.034947304 4202147.1271238625, 1907206.2040029734 4202144.479383883, 1907203.2559690238 4202135.7522878945, 1907195.2107790366 4202115.805475912, 1907188.6176741756 4202094.133933531, 1907189.0470805962 4202058.503439173, 1907183.3837285487 4202024.294067028, 1907179.5787862863 4202007.200761959, 1907169.7836011047 4201993.18266477, 1907149.847335819 4201966.804127541, 1907146.8325096418 4201962.539960338, 1907147.1511546648 4201957.710232942, 1907153.9598516042 4201942.1693464015, 1907153.7498909493 4201939.15480533, 1907153.6506098206 4201938.081533684, 1907149.0661992037 4201931.875192667, 1907148.8583211964 4201931.062279106, 1907148.4393949164 4201929.669713142, 1907148.2385777773 4201917.431711616, 1907137.9305654217 4201903.674334266, 1907134.0641947503 4201885.2315888405, 1907133.1960511392 4201882.655010531, 1907128.2939345364 4201871.884021621, 1907124.1754648911 4201855.659576465, 1907121.741643171 4201842.61361966, 1907119.8297673832 4201832.600587102, 1907118.578451569 4201822.880625005, 1907115.8359413256 4201805.889167317, 1907115.2675523427 4201802.330447584, 1907112.84812372 4201789.382235887, 1907105.037693094 4201777.2706864625, 1907101.957717417 4201771.962563858, 1907098.4584866874 4201765.671155152, 1907083.7270750487 4201735.952171493, 1907079.4806758487 4201724.671998281, 1907077.9028258892 4201718.137385234, 1907074.0851192577 4201706.299296121, 1907071.4549292629 4201703.746788902, 1907069.985638066 4201702.820390206, 1907067.6908467622 4201701.384034339, 1907066.5896841716 4201700.524770057, 1907053.2290311444 4201690.315946341, 1907040.3929770587 4201686.181761057, 1907032.081831994 4201675.096026496, 1907025.8170687659 4201667.609802616, 1907022.8623474806 4201662.988022682, 1907018.7547016563 4201656.637526059, 1907012.5798285573 4201651.194136691, 1907007.6102520314 4201647.19921126, 1906997.284878548 4201637.323656795, 1906995.051909596 4201635.508032764, 1906987.924537084 4201630.747539569, 1906979.548641889 4201625.161488759, 1906977.2989583607 4201623.809845761, 1906973.6855799516 4201621.663978794, 1906972.420469687 4201621.138165218, 1906961.3856957234 4201616.816867438, 1906955.9507336793 4201616.995603022, 1906952.5983835561 4201617.093371197, 1906931.082140005 4201606.062163382, 1906922.4684372232 4201601.48233337, 1906919.4943478839 4201599.458241162, 1906914.4235372583 4201595.658964634, 1906909.546563279 4201594.2463343805, 1906902.6949019332 4201592.894818403, 1906895.2583736852 4201590.526642153, 1906889.5825187792 4201587.794350605, 1906878.4139962303 4201582.582942, 1906866.7893924778 4201581.758475079, 1906866.301497886 4201581.289557567, 1906865.3395671565 4201581.429224401, 1906860.1385449125 4201575.658654105, 1906854.0858170162 4201571.452699125, 1906852.63194041 4201570.7855830835, 1906842.7141262598 4201566.501356392, 1906834.39 4201567.63, 1906830.269422008 4201567.315182757, 1906824.1439641817 4201564.771720117, 1906804.3774904138 4201556.300951026, 1906794.377248206 4201547.672116451, 1906782.544153156 4201519.47592029, 1906768.5042911659 4201514.490999371, 1906759.758203011 4201509.129762898, 1906738.6812942522 4201474.094869762, 1906697.6756502097 4201413.200394655, 1906650.3019898497 4201343.301652782, 1906642.8817068224 4201334.483541282, 1906631.0836819024 4201323.948703901, 1906620.978136666 4201320.235262481, 1906607.5610973788 4201321.121422455, 1906596.4362130137 4201323.792513183, 1906580.587867433 4201327.65744969, 1906574.3062472246 4201327.547085991, 1906560.7454289491 4201327.3631227305, 1906535.628628856 4201322.902769424, 1906516.4649546763 4201322.412251311, 1906501.4847271903 4201324.631751306, 1906483.9693421514 4201325.207290554, 1906454.9574848907 4201319.914078639, 1906437.0252530572 4201302.638698181, 1906422.5741553481 4201297.640448555, 1906404.695418795 4201294.50821442, 1906400.0260417974 4201294.2161902115, 1906399.2909579559 4201294.212232185, 1906387.0450858737 4201295.946227082, 1906380.781526345 4201296.5426737, 1906373.424942076 4201297.1993753975, 1906337.1525885444 4201285.48361996, 1906331.694576629 4201285.867078944, 1906306.5689216943 4201288.136975206, 1906291.7721276083 4201278.039341855, 1906264.174715233 4201264.82939793, 1906245.5775424195 4201258.684198163, 1906232.6213176202 4201256.757908218, 1906230.1307215707 4201257.003919064, 1906228.011985364 4201257.138951203, 1906218.289142436 4201262.085430539, 1906203.808322861 4201269.734371242, 1906198.9826419856 4201270.827648392, 1906179.6773628793 4201271.530393783, 1906152.8707763723 4201269.768756246, 1906138.8832604662 4201266.367573981, 1906120.8725890252 4201247.267545082, 1906098.442195323 4201218.388841453, 1906094.4387766945 4201203.066202907, 1906090.93 4201193.395, 1906086.0368666344 4201184.367865064, 1906076.2359741426 4201173.433863687, 1906058.667773351 4201158.972259266, 1906052.0271316012 4201154.540798054, 1906016.8369080725 4201148.955422959, 1905984.787146905 4201142.92711857, 1905964.3657822052 4201138.471807903, 1905944.728845413 4201133.085422973, 1905927.0286823958 4201132.269840001, 1905906.5217705797 4201130.966001222, 1905878.7199167542 4201132.299268389, 1905826.3439440886 4201157.413316345, 1905806.188555119 4201167.571764954, 1905785.8523816278 4201177.562894684, 1905784.494910943 4201180.694200916, 1905778.3079858413 4201197.239413435, 1905775.4591616294 4201201.374659112, 1905768.2506533777 4201209.3152039265, 1905765.6390749214 4201210.635178198, 1905751.9304971949 4201217.104362366, 1905732.9005753614 4201227.534193525, 1905717.0392181883 4201235.853574913, 1905706.4755375304 4201241.18446817, 1905693.3690458075 4201245.195312886, 1905566.5042366749 4201355.519661019, 1905460.636159683 4201445.836978142, 1905352.2282382485 4201539.097585757, 1905294.5491085234 4201588.05652252, 1905280.8632911097 4201600.441706997, 1905279.1206733093 4201602.005602976, 1905244.95 4201635.61, 1905204.33 4201675.94, 1905122.49 4201757.75, 1905034.66 4201844.86, 1904957.65 4201920.77, 1904947.74 4201930.62, 1904856.17 4202021.6, 1904778.43 4202097.84, 1904774.72 4202101.47, 1904771.37 4202103.94, 1904717.16 4202157.18, 1904714.3 4202159.96, 1904690.42 4202183.37, 1904663.73 4202209.53, 1904633.82 4202238.86, 1904623.6 4202248.87, 1904612.39 4202260.98, 1904610.67 4202262.61, 1904608.38 4202264.78, 1904567.74 4202291.9, 1904518.21 4202324.96, 1904513.27 4202328.25, 1904483.84 4202347.78, 1904453.26 4202367.99, 1904404.22 4202400.51, 1904403.83 4202401.11, 1904403.46 4202401.71, 1904375.44 4202420.08, 1904339.34 4202443.77, 1904278.36 4202483.75, 1904248.08 4202503.79, 1904115.33 4202591.62, 1903958.71 4202693.81, 1903786.77 4202806.43, 1903667.63 4202884.91, 1903654.66 4202893.53, 1903652.84 4202894.77, 1903646.25 4202899.22, 1903572.99 4202947.37, 1903469.77 4203015.07, 1903386.31 4203070.45, 1903366.87 4203083.34, 1903288.58 4203135.06, 1903224.39 4203177.45, 1903203.58 4203191.2, 1903139.46 4203233.54, 1903102.68 4203257.78, 1903106.34 4203265.25, 1903108.24 4203269.12, 1903109.27 4203271.51, 1903112.22 4203278.34, 1903113.44 4203285.79, 1903113.32 4203291.52, 1903112.86 4203296.89, 1903112.83 4203297.22, 1903110.26 4203307.64, 1903117.8 4203312.08, 1903125.95 4203316.89, 1903143.33 4203329.68, 1903146.4 4203332.25, 1903155.2 4203339.61, 1903163.16 4203347.09, 1903163.47 4203347.39, 1903173.32 4203359.97, 1903176.28 4203364.24, 1903181.12 4203371.2, 1903185.45 4203378.29, 1903189.83 4203385.46, 1903196.75 4203400.27, 1903200.6 4203408.49, 1903210.15 4203429.63, 1903216.68 4203446.31, 1903218.39 4203453.59, 1903219.19 4203460.39, 1903218.33 4203468.69, 1903216.04 4203478.56, 1903214.54 4203485.09, 1903208.71 4203505.73, 1903207.71 4203508.47, 1903202.54 4203522.64, 1903179.46 4203576.19, 1903170.36 4203604.16, 1903168.13 4203611.06, 1903164.86 4203622.75, 1903163.21 4203628.65, 1903162.98 4203629.77, 1903161.43 4203637.14, 1903161.12 4203645.13, 1903161.09 4203645.98, 1903161.03 4203646.54, 1903160.48 4203651.13, 1903162.6 4203657.91, 1903166.35 4203665.04, 1903167.64 4203666.85, 1903172.57 4203673.81, 1903179.52 4203678.92, 1903187.35 4203683.17, 1903196.9 4203688.36, 1903218.93 4203698.53, 1903243.21 4203709.72, 1903251 4203711.65, 1903258.12 4203713.41, 1903295.32 4203728.27, 1903301.9 4203731.52, 1903310.61 4203736.28, 1903317.83 4203740.31, 1903328.59 4203748.56, 1903333.31 4203752.73, 1903345.98 4203796.29, 1903357.95 4203839.79, 1903362.09 4203858.67, 1903362.47 4203864.15, 1903364.36 4203891.62, 1903364.32 4203909.95, 1903363.49 4203920.59, 1903359.42 4203929.57, 1903351.75 4203939.51, 1903330.3 4203966.04, 1903302.05 4203997.36, 1903270.52 4204034.76, 1903263.86 4204045.37, 1903258.34 4204058.38, 1903254.95 4204073.6, 1903252.39 4204092.61, 1903250.17 4204130.56, 1903251.8 4204155.89, 1903255.63 4204183.5, 1903260.43 4204212.4, 1903273.66 4204276.58, 1903281.42 4204312.49, 1903297.08 4204401.72, 1903314.78 4204499.35, 1903322.18 4204529.76, 1903354.47 4204596.15, 1903409.75 4204710.41, 1903432.76 4204756.73, 1903456.55 4204794.71, 1903542.13 4204932.86, 1903589.08 4205009.32, 1903612.13 4205046.94, 1903648.34 4205106.32, 1903688.94 4205171.92, 1903737.01 4205249.97, 1903765.3 4205297.05, 1903779.2 4205348.78, 1903816.66 4205487.5, 1903859.14 4205638.06, 1903859.14 4205640.768549839, 1903928.91 4205890.62, 1903981.2 4206082.8, 1904040.93 4206304.6, 1904055.63 4206363.22, 1904073.29 4206426.44, 1904092.1 4206493.1, 1904136.36 4206653.06, 1904168.46 4206770.44, 1904195.77 4206872.01, 1904214.35 4206939.67, 1904194.57 4207191.75, 1904219.63 4207296.73, 1904261.82 4207471.78, 1904278.26 4207546.1, 1904287.32 4207582.41, 1904287.49 4207582.78, 1904287.53 4207583.59, 1904305.02 4207808.32, 1904320.31 4207991.53, 1904320.49 4207993.3, 1904341.02 4208204.9, 1904344.7740975085 4208204.558593344, 1904362.742790962 4208190.466636288, 1905548.0469807533 4208080.647386765, 1905629.8118939456 4208059.836937523, 1905715.985896853 4208041.0921512935, 1905795.1013450355 4207976.360741127, 1905832.7334408336 4207961.22057006, 1905930.1523867657 4207935.309570525, 1905979.5598251193 4207901.49344396, 1906100.5910857753 4207844.544367627, 1906365.9651628507 4207601.262796984, 1906595.286402471 4207395.155181588, 1906595.5243998375 4207398.036478905, 1906595.7114353843 4207397.869457205, 1906602.8146525305 4207477.73359188, 1906625.4257807417 4207732.334549705, 1906638.8786396922 4207879.0925714, 1906817.176991719 4208245.200579919, 1906941.3914588718 4208394.731306617, 1907064.8015712858 4208541.666458707, 1907065.1091372091 4208531.387433082, 1907073.0287258255 4208540.81108371, 1907078.5818466912 4208372.795978646, 1907103.1519119358 4208313.405606349, 1907134.8948568418 4208277.014469022, 1907174.5321421043 4208205.595632481, 1907150.8607292217 4208121.118161239, 1907142.1545582607 4208055.8392084995, 1907143.280632481 4207968.681467968, 1907158.2396374121 4207900.23441027, 1907154.943211202 4207842.4680011105, 1907179.936509623 4207757.47961218, 1907212.0428162406 4207640.068060902, 1907220.6064081201 4207572.83312075, 1907227.1811001878 4207536.945309952, 1907310.7976730822 4207360.619612181, 1907390.3098151865 4207194.621551279, 1907445.3958868461 4207078.011860779, 1907491.8966273828 4206978.611052382, 1907504.9534940184 4206949.241591747, 1907507.1544233577 4206944.534928699, 1907537.8583084028 4206979.585403992, 1907596.0217997157 4207007.663368539, 1907606.3007650338 4207013.154611648, 1907679.2370490674 4207072.180172498, 1907731.338996258 4207118.994428582, 1907764.6697679514 4207133.327068533, 1907794.8146379818 4207151.740585381, 1907884.427489713 4207205.903560436, 1907929.4829471342 4207283.748973123, 1907994.3883306598 4207344.610373872, 1908051.618990101 4207437.663544814, 1908085.3590635275 4207467.112391288, 1908109.3816762445 4207540.051306617, 1908101.9178018735 4207640.236913772, 1908134.6227004102 4207640.612351414, 1908179.1479864884 4207633.822000734, 1908191.047318005 4207630.65759349, 1908225.953424959 4207618.536164051, 1908240.587671971 4207617.394365889, 1908264.3101419925 4207619.969186433, 1908269.1190578383 4207686.45489385, 1908376.057728541 4207636.519228281, 1908438.5969702597 4207617.0175814815, 1908511.5600228766 4207593.184505702, 1908507.6340696728 4207605.831566876, 1908520.0901403532 4207609.341574629, 1908577.9387452807 4207566.9085515775, 1908589.6578870234 4207561.166585468, 1908622.5333200912 4207554.93546907, 1908652.762954547 4207542.156260668, 1908756.4207142505 4207513.404404355, 1908845.2936933828 4207523.522631427, 1908906.884189042 4207512.723756827, 1908923.5935006884 4207506.722722618, 1908927.7169390984 4207521.119081203, 1908949.4802170836 4207547.001464853, 1908988.8878701604 4207559.355312489, 1909004.8540603996 4207584.904518001, 1909018.715838277 4207597.557278858, 1909028.0753721471 4207602.956170149, 1909043.2491386782 4207604.18698731, 1909063.8440731738 4207600.611498695, 1909088.4114362348 4207593.130987668, 1909099.6920910429 4207591.582496775, 1909106.0480101504 4207593.284469022, 1909116.1303448256 4207600.8946084045, 1909146.565908239 4207648.711769529, 1909183.9438184858 4207690.163909347, 1909202.8729128917 4207711.770286785, 1909259.7332879102 4207665.89046466, 1909245.1381182834 4207631.960550612, 1909236.3636189976 4207608.69361707, 1909211.449206168 4207542.301163459, 1909159.4792569198 4207379.768388874, 1909116.848633535 4207284.285581729, 1909076.2412160165 4207211.941689788, 1909022.0003118245 4207123.600500845, 1909020.4375074042 4207120.478768285, 1908963.5742569198 4207002.97742842, 1908932.9786751904 4206924.460193909, 1908910.8851340618 4206838.534173609, 1908874.089991806 4206687.672886927, 1908853.7159137495 4206588.213786786, 1908853.145536678 4206583.343259891, 1908849.8614483404 4206570.39725344, 1908845.1572550752 4206554.24078479, 1908836.1383823662 4206525.521525483, 1908832.0259426793 4206512.709472795, 1908829.667665683 4206503.763663676, 1908828.930102101 4206500.065096373, 1908828.097379932 4206489.130023172, 1908827.9507026405 4206486.751106642, 1908827.9398442025 4206486.211976276, 1908827.9787687627 4206475.453726838, 1908828.5339157875 4206462.743988374, 1908829.3687385435 4206452.660134351, 1908832.0993631312 4206424.463121044, 1908836.30598829 4206390.891032914, 1908837.5659810936 4206377.85569824, 1908838.3695628208 4206369.606183166, 1908839.4834552943 4206355.378935469, 1908839.5273050426 4206354.650083438, 1908839.6285334236 4206352.921206368, 1908841.2663891693 4206325.73592303, 1908842.1340906362 4206311.681630352, 1908842.2409698877 4206310.174873829, 1908842.391133162 4206308.122364489, 1908844.6861570077 4206277.402912776, 1908846.9636101446 4206250.529570893, 1908850.3419810391 4206222.563882945, 1908849.2926156186 4206222.28797221, 1908847.9858713895 4206221.944388598, 1908850.3232604107 4206211.867548184, 1908856.8648840445 4206191.522979324, 1908860.4425504084 4206180.872571767, 1908862.0837780824 4206175.780368418, 1908862.95 4206172.19, 1908869.6628820861 4206148.837251511, 1908869.9606690896 4206147.8012927715, 1908870.1751454435 4206147.055413315, 1908870.2675739587 4206146.732116385, 1908870.3789410724 4206146.324569687, 1908871.658874247 4206141.6388737345, 1908874.3 4206131.97, 1908875.1087454902 4206126.382303885, 1908876.06 4206119.81, 1908876.24 4206109.07, 1908872.79 4206093.16, 1908866.53 4206074.54, 1908852.61 4206041.71, 1908848.85 4206030.46, 1908844.9 4206013.64, 1908844.35 4206000.22, 1908844.89 4205991, 1908846.27 4205980.06, 1908849.86 4205967.63, 1908853.49 4205955.89))'::geometry,'38187','Le Gua','LE GUA','GUA','GUA'),
     (45,'SRID=3945;POLYGON ((1918752.1485723883 4221012.522658688, 1918894.7715558137 4221242.182454034, 1918974.3680173436 4221371.498946619, 1919018.240353213 4221441.855139545, 1919009.5584589709 4221441.632080038, 1919012.6045742717 4221446.527474068, 1919015.6337478778 4221451.350376672, 1919051.6922230066 4221457.136859841, 1919096.6050000004 4221464.424168961, 1919162.1376417351 4221475.568431169, 1919172.765465613 4221487.835587035, 1919180.482601879 4221494.306846576, 1919194.5532530672 4221503.480928537, 1919236.795521002 4221527.607931608, 1919247.3591698536 4221535.452596749, 1919286.9530285446 4221567.746505659, 1919303.8908256947 4221579.730829913, 1919326.6627044296 4221593.451298307, 1919354.2979837733 4221611.359995043, 1919362.3721870254 4221616.146372357, 1919392.2980060766 4221629.264922309, 1919404.0943957441 4221634.049480836, 1919412.5374698811 4221635.98358057, 1919433.2158310257 4221640.666664801, 1919452.196924383 4221644.034078145, 1919457.0816429167 4221644.634254661, 1919461.2365561996 4221645.131383236, 1919462.6568081337 4221645.309341441, 1919463.1383712243 4221645.294209865, 1919463.7824099802 4221645.284751075, 1919471.9890461934 4221644.324261198, 1919476.4488183695 4221643.590045601, 1919482.8335895124 4221642.502745447, 1919483.9373872255 4221642.315885259, 1919490.3296466772 4221640.685251422, 1919491.952411453 4221639.355184383, 1919493.8678183858 4221636.992503897, 1919497.5111143563 4221632.496012531, 1919507.0526399352 4221619.3292474365, 1919509.2993966753 4221616.926163995, 1919512.0914072052 4221618.8910765, 1919537.1349392778 4221648.781639663, 1919565.3912593024 4221684.210501712, 1919622.4935394642 4221752.779294123, 1919832.8449696328 4221704.023147782, 1919912.00033403 4221781.82969636, 1919927.9171452937 4221775.110225677, 1919944.2419895253 4221768.819284231, 1919949.6263994486 4221764.429125946, 1919963.2863055153 4221752.793611193, 1920044.0506949087 4221746.455426362, 1920144.9669441811 4221722.985057544, 1920184.8300000078 4221698.327499982, 1920191.97 4221688.82, 1920256.46 4221474.87, 1920299.890000004 4221329.1, 1920329.79 4221229.36, 1920330.79 4221224.91, 1920366.34 4221104.22, 1920404.31 4220976.79, 1920429.57 4220891.94, 1920464.51 4220868.86, 1920488.91 4220860, 1920578.1 4220840.44, 1920604.25 4220813.81, 1920646.26 4220792.81, 1920652.2 4220785.63, 1920668.07 4220768.84, 1920746.3 4220685.71, 1920752.96 4220678.5, 1920753.77 4220676.57, 1920754.75 4220675.72, 1920791.86 4220636.76, 1920834.17 4220592.32, 1920869.82 4220554.89, 1920988.48 4220430.28, 1921052.51 4220363.04, 1921106.53 4220306.37, 1921108.39 4220304.51, 1921108.6 4220304.3, 1921110.68 4220302.01, 1921123.74 4220284.86, 1921143.25 4220259.26, 1921160.51 4220236.07, 1921181.91 4220207.33, 1921183.62 4220205.04, 1921278.1 4220078.16, 1921287.77 4220062.57, 1921281.34 4220026.45, 1921280.64 4220022.5, 1921269.12 4219957.86, 1921261.96 4219916.2, 1921260.35 4219906.87, 1921252.31 4219860.15, 1921257.21 4219848.86, 1921270.26 4219818.77, 1921295.05 4219761.63, 1921306.27 4219735.74, 1921322.32 4219698.75, 1921340.5 4219656.83, 1921322.18 4219514.55, 1921303.52 4219367.61, 1921275.24 4219302.95, 1921246.28 4219249.41, 1921294.15 4219166.6, 1921311.27 4219139.16, 1921365.03 4219112.16, 1921360.29 4219063.05, 1921361.5 4219058.92, 1921362.7 4219054.78, 1921400.08 4219038.59, 1921404.04 4219037.18, 1921427.4 4219028.89, 1921444.22 4219026.89, 1921496.01 4219010.8, 1921497.19 4219015.99, 1921596.33 4218979.7, 1921597.7265960108 4218979.065183631, 1921577.7694283756 4218955.140101113, 1921569.119381118 4218943.530660635, 1921568.497042677 4218942.698548647, 1921550.0244853874 4218916.514418405, 1921541.8318350231 4218904.934856705, 1921510.316574297 4218882.010682536, 1921499.9247274692 4218869.5794289345, 1921483.2244391392 4218848.037301679, 1921478.3243374086 4218840.859379848, 1921473.6059236594 4218835.462516099, 1921469.8474167262 4218831.246797557, 1921463.9440648674 4218824.727314306, 1921453.5524830257 4218816.229790214, 1921451.356467824 4218814.445795443, 1921450.2024845101 4218813.823777535, 1921443.9771144583 4218810.950091036, 1921429.751811168 4218811.0517775575, 1921416.1684072823 4218804.371073573, 1921393.9696996142 4218790.5985091245, 1921385.835044765 4218783.876653956, 1921378.9160545622 4218778.356596011, 1921357.5887760178 4218757.461630364, 1921340.2810251834 4218744.0394874085, 1921328.6476207816 4218737.322782923, 1921314.7923077033 4218730.270840706, 1921296.6436159564 4218717.698813204, 1921276.556377714 4218704.288488831, 1921259.1212628596 4218689.362164512, 1921241.9556817946 4218672.164061909, 1921228.9493638773 4218656.040097727, 1921211.2578153135 4218632.452024116, 1921196.4013823152 4218612.0304782, 1921162.4654675205 4218581.176194716, 1921122.365834469 4218538.301173396, 1921107.483081334 4218522.594347576, 1921081.387587519 4218496.152232495, 1921075.1288226023 4218485.895898849, 1921075.3465269948 4218477.147957396, 1921071.9378954228 4218464.07084067, 1921069.7521365772 4218458.491336565, 1921063.9077366702 4218447.337277231, 1921052.8726344826 4218432.96039818, 1921049.0010800243 4218427.686746571, 1921038.0108332948 4218409.394560115, 1921028.7564299183 4218393.968230506, 1921022.241412255 4218385.454950688, 1921009.6423649532 4218371.536750759, 1920999.0354924651 4218361.4130715225, 1920987.394059062 4218351.590294714, 1920975.2956685838 4218343.200349105, 1920966.4157145119 4218336.788921204, 1920959.6123887722 4218330.997543547, 1920952.8759017922 4218318.718285075, 1920945.9115100775 4218304.265349717, 1920939.9603468236 4218292.742536441, 1920931.6940494527 4218275.584502389, 1920931.0271160677 4218274.394543369, 1920906.2887956575 4218286.066104151, 1920890.9006515115 4218293.473416422, 1920860.0636348473 4218266.541064007, 1920842.4186234819 4218251.818223684, 1920830.9880786878 4218241.5560697, 1920829.800765348 4218240.22113573, 1920827.543289805 4218237.483482419, 1920819.562215444 4218222.698587843, 1920805.0904066348 4218186.962360119, 1920795.4583539614 4218156.585452537, 1920787.4146753731 4218139.6718851505, 1920785.8655119108 4218137.2315712515, 1920785.200219275 4218136.178774468, 1920781.146458711 4218130.7796618445, 1920776.0794446752 4218125.204567785, 1920752.1704612668 4218101.452700874, 1920744.0517606558 4218094.033970641, 1920736.1632462847 4218086.7867657645, 1920729.0152731228 4218078.490050237, 1920718.5246783542 4218065.9814043315, 1920711.2554153688 4218057.983332601, 1920705.2595698107 4218051.27652682, 1920687.2515236961 4218029.228582404, 1920680.3416956917 4218018.8360545365, 1920678.5174979127 4218016.105090065, 1920674.7221623345 4218008.880100462, 1920674.1397453942 4218007.776958245, 1920673.1541738873 4218005.97870118, 1920667.298596733 4217995.870710984, 1920659.8607197476 4217983.209439836, 1920658.3947047342 4217980.770675847, 1920645.1001318586 4217958.667467577, 1920629.149751647 4217933.705597151, 1920627.4996626591 4217931.250675399, 1920600.8861500507 4217892.593057312, 1920590.1796331815 4217877.980833424, 1920578.6263280488 4217856.941602504, 1920568.5778709294 4217841.912041942, 1920560.441203254 4217835.0677213995, 1920552.4900446665 4217830.398731085, 1920550.803099895 4217832.720182981, 1920547.81357084 4217837.641167564, 1920541.710182304 4217880.490562422, 1920538.26980984 4217886.691392343, 1920534.9550000099 4217884.601666688, 1920494.3702487338 4217818.511808552, 1920471.0333333246 4217783.197500004, 1920454.62 4217764.7, 1920453.8651855595 4217766.117725322, 1920452.8404802473 4217767.677273433, 1920451.8971951522 4217769.129893966, 1920451.5500108066 4217769.836328073, 1920451.5076141758 4217769.920727107, 1920450.8256569302 4217771.609002625, 1920450.48391433 4217772.499698437, 1920449.9821156266 4217773.87724817, 1920449.4034667506 4217775.783222908, 1920449.140631746 4217776.669676773, 1920448.9454352474 4217777.549420145, 1920448.6424449666 4217778.932302969, 1920448.0216883395 4217782.38513076, 1920447.1486031658 4217787.1959227845, 1920446.7277222802 4217790.471745075, 1920446.4695024039 4217792.527285614, 1920446.4167577652 4217792.562822782, 1920446.399052842 4217792.681879357, 1920445.1019996996 4217793.451615084, 1920391.3358872668 4217820.125770228, 1920389.09 4217821.24, 1920368.2704466258 4217835.10132862, 1920347.3637538983 4217849.020530615, 1920310.8166908424 4217873.352843887, 1920245.2835651878 4217916.991858502, 1920146.4089483174 4217982.824657452, 1919914.1405258414 4217930.295192308, 1919800.5310175167 4217993.573907423, 1919662.9918320088 4218070.180686038, 1919552.0159710073 4218131.9954934325, 1919551.8979688224 4218132.056322082, 1919551.3439999977 4218132.312000001, 1919550.4516820044 4218132.684486703, 1919550.2055445237 4218132.804898833, 1919549.1396185919 4218133.459690108, 1919548.7456190002 4218133.703531242, 1919539.01 4218138.83, 1919516.9225667631 4218148.134699955, 1919494.8238306623 4218157.445021469, 1919480.8816450413 4218163.325204765, 1919435.7812135364 4218182.330876219, 1919414.367687744 4218191.357421356, 1919409.4512781773 4218193.431157853, 1919405.394193639 4218195.140999503, 1919402.3902335588 4218196.406874228, 1919391.2288703322 4218201.110294719, 1919347.02 4218219.74, 1919317.412233119 4218233.145745255, 1919317.3694357541 4218233.165113245, 1919317.3110227466 4218233.191592047, 1919317.2539501812 4218233.217395831, 1919317.2267418983 4218233.229738433, 1919233.5903553013 4218271.100992181, 1919224.6401206623 4218275.153729479, 1919218.3989643042 4218277.979774003, 1919215.6793980151 4218279.211216391, 1919213.1707579647 4218280.347455073, 1919195.8926389539 4218288.173295367, 1919173.4231270896 4218298.35043469, 1919052.64 4218353.05, 1919013.6617706625 4218456.538258471, 1918987.9395721206 4218524.821637276, 1918982.2578508025 4218539.904606725, 1918977.6193190108 4218552.202365363, 1918963.84966716 4218588.934221472, 1918959.7078662273 4218599.983888217, 1918957.4798360341 4218605.913732279, 1918956.609715137 4218608.203593444, 1918955.3521104476 4218611.634360432, 1918954.2419616296 4218614.778992676, 1918954.8819151095 4218616.91439407, 1918957.1874749123 4218622.691565918, 1918957.2860415217 4218622.872172782, 1918957.9031661295 4218624.048183893, 1918958.9555805887 4218625.205422052, 1918959.7000357108 4218626.0548627535, 1918960.7434746479 4218626.954566732, 1918961.6963463663 4218627.087748417, 1918964.6711610088 4218627.5169417355, 1918966.193988384 4218627.500032268, 1918968.5915586546 4218627.443790606, 1918970.5285693635 4218627.806870419, 1918973.6150621865 4218628.550258745, 1918976.4048410938 4218629.209456498, 1918976.8901179116 4218629.392645253, 1918977.4641610617 4218629.946168802, 1918977.6711223298 4218630.13847634, 1918978.0494116528 4218630.4901521, 1918978.7717699546 4218631.691323747, 1918979.4595132202 4218632.822743155, 1918979.825585243 4218633.774091827, 1918980.4817452847 4218635.732877363, 1918980.8822569363 4218636.930704045, 1918980.9148806531 4218637.156036432, 1918980.9830232826 4218637.566596521, 1918980.8878631075 4218639.04817639, 1918980.69299838 4218640.953042996, 1918982.8027344577 4218644.587139138, 1918984.4269337102 4218647.381070859, 1918984.5012479136 4218647.508930524, 1918984.5103447603 4218647.520966576, 1918984.8367438887 4218647.949337656, 1918985.5554644181 4218648.628907635, 1918986.3707369997 4218649.392986743, 1918989.317165684 4218652.153981965, 1918990.8257224094 4218653.6843432, 1918992.1994007418 4218655.10439049, 1918994.2158410805 4218657.034433069, 1918998.6486142236 4218659.291995313, 1918999.189079941 4218659.704547637, 1918999.5592263096 4218660.259119848, 1918999.8217280668 4218660.647439513, 1919000.5715173827 4218662.6622108305, 1919001.5123305847 4218665.131600034, 1919001.6151952462 4218666.291171478, 1919001.7833304245 4218667.991482863, 1919001.8841916341 4218671.764812528, 1919002.0704819271 4218672.188313252, 1919002.8471243922 4218673.401227965, 1919005.4806286395 4218675.140774157, 1919005.8718221649 4218675.344732139, 1919006.8826097168 4218675.521484535, 1919007.5576622654 4218675.658981171, 1919008.4631863672 4218675.717060939, 1919009.8746678017 4218675.825717288, 1919016.620059177 4218675.925838824, 1919019.167192032 4218675.886818413, 1919020.1638937332 4218675.746444583, 1919021.0250588078 4218675.582374334, 1919023.0445195534 4218675.2068416, 1919026.1909018678 4218674.6258692, 1919026.4203459052 4218674.635571403, 1919027.0031383075 4218674.813568159, 1919029.4909876944 4218675.5755319055, 1919030.0600631044 4218675.632648488, 1919030.6105321497 4218675.705732676, 1919032.7664549144 4218675.502796355, 1919033.443332726 4218675.444298705, 1919033.8002338198 4218675.373816384, 1919034.374965643 4218675.256450444, 1919036.062428398 4218674.752556977, 1919036.7827862184 4218674.540154371, 1919044.3088144634 4218672.144349815, 1919044.6449903052 4218671.862215221, 1919044.9216097812 4218671.634000319, 1919045.5894240846 4218670.709685863, 1919045.7176404092 4218670.5301766, 1919045.7363683167 4218670.530364088, 1919045.9350045405 4218670.287960561, 1919054.4174072202 4218670.608081923, 1919063.2587690663 4218670.57729872, 1919063.7752798302 4218670.659847719, 1919063.8098080542 4218670.664824907, 1919064.521156285 4218670.887810373, 1919065.705847839 4218671.257860596, 1919067.688814246 4218671.841290554, 1919068.7907089759 4218672.163591249, 1919069.7098142782 4218672.434374639, 1919070.2270924507 4218672.587146495, 1919070.608688158 4218672.698169386, 1919070.7971955212 4218672.754442922, 1919070.9875395892 4218672.810840177, 1919071.2130635567 4218672.87716743, 1919071.3135593298 4218672.906438567, 1919071.565511884 4218672.98077987, 1919071.7355428692 4218673.030771084, 1919071.9872766347 4218673.104917169, 1919072.2392732203 4218673.179045863, 1919072.660633719 4218673.302940529, 1919073.0700946483 4218673.423266213, 1919073.3299060035 4218673.501136722, 1919073.8264996752 4218673.644915909, 1919074.6163645245 4218673.882364341, 1919075.585936403 4218674.145833503, 1919076.3717089458 4218674.32730044, 1919077.0503164749 4218674.389069516, 1919078.2561016958 4218674.5250220215, 1919079.7150689897 4218674.462681464, 1919079.855602783 4218674.457927059, 1919079.965969813 4218674.441083545, 1919081.1539994366 4218673.73057494, 1919082.5150645166 4218672.922453772, 1919084.1347463105 4218671.853198456, 1919085.4015666104 4218671.010527669, 1919085.6755143274 4218670.78385946, 1919086.583670758 4218670.0266120015, 1919089.184971625 4218667.26612514, 1919089.7186876088 4218666.703119288, 1919096.2666739323 4218665.101229653, 1919103.2029043706 4218663.305314611, 1919104.209569672 4218663.051251464, 1919104.694231497 4218663.007646409, 1919108.5944048222 4218663.121759025, 1919108.6805371053 4218663.145179351, 1919108.885801587 4218663.187952217, 1919109.6414762228 4218663.630159244, 1919109.8433281477 4218663.792327487, 1919110.0428823181 4218664.016230977, 1919114.4062499877 4218668.806602575, 1919114.3930232485 4218669.057929657, 1919110.699898062 4218672.670111373, 1919099.6212959692 4218677.267971718, 1919093.6072128566 4218679.903754594, 1919083.261275882 4218687.156220598, 1919073.5041517778 4218695.299970462, 1919068.2229202571 4218700.188757693, 1919066.5917163189 4218701.739120106, 1919064.9834798889 4218703.474022572, 1919064.1413192777 4218704.396296493, 1919055.7034277427 4218714.169676678, 1919052.694743573 4218717.926730756, 1919045.4546256796 4218727.947712644, 1919044.4281684859 4218729.381155565, 1919043.624068663 4218730.622087921, 1919043.064588448 4218731.494277852, 1919041.8045369314 4218733.6118017705, 1919041.6668020452 4218733.849942143, 1919038.2235056427 4218740.488289482, 1919036.3645827896 4218747.660521611, 1919033.2681443205 4218775.965640229, 1919031.5835244632 4218792.935679679, 1919031.080160255 4218799.561891012, 1919031.3868590107 4218810.321077716, 1919033.111081173 4218824.026265231, 1919033.7358969438 4218827.400767331, 1919034.9615099307 4218836.362283535, 1919035.8735390902 4218845.095548205, 1919034.1840884679 4218861.208121372, 1919031.912081737 4218870.332110394, 1919027.9025000047 4218879.640032032, 1919018.5957726082 4218901.541709474, 1919014.6877313575 4218910.5958583485, 1919007.6901039307 4218927.715031551, 1919002.1090300046 4218940.652234776, 1918998.3584921227 4218947.652875485, 1918994.1967201484 4218954.108666672, 1918988.4131376024 4218961.20089658, 1918981.9409009393 4218968.303705803, 1918976.3082123655 4218975.243409195, 1918970.4677853244 4218985.09458236, 1918964.6930988708 4218995.337637682, 1918958.2304166665 4219005.801250006, 1918956.0617692543 4219007.5403133575, 1918950.2405104137 4219009.460528872, 1918944.0840013837 4219008.347153448, 1918940.0554653828 4219006.732787673, 1918932.8399354136 4219003.595924833, 1918928.8845833885 4219002.288040013, 1918927.1519836492 4219002.149381769, 1918926.0501006404 4219002.0751133645, 1918924.5202359543 4219002.448182818, 1918923.3336244046 4219002.835148391, 1918922.114423085 4219003.501907045, 1918918.7321041906 4219007.074102233, 1918913.570797012 4219014.012661474, 1918907.262855569 4219023.604632169, 1918896.707361358 4219041.417113014, 1918890.8812527328 4219050.731108484, 1918878.59276565 4219071.102192461, 1918876.016804704 4219074.966611606, 1918868.7585869124 4219084.184426397, 1918864.8874839835 4219089.4214262795, 1918864.6574028493 4219091.2236232245, 1918864.6033064502 4219091.327932178, 1918866.7834053233 4219100.312419758, 1918867.3628169405 4219102.1950386325, 1918871.138605767 4219111.423445486, 1918872.4982689815 4219114.310753654, 1918878.8407201774 4219126.26856318, 1918883.0631889352 4219135.11298078, 1918884.2331701303 4219138.143647087, 1918885.875526509 4219143.010363655, 1918887.4117575784 4219147.56583237, 1918889.2669620386 4219153.2804050585, 1918889.7715626804 4219155.446405364, 1918890.620938199 4219161.223641882, 1918888.8776493676 4219170.571916267, 1918885.8739960853 4219181.628056855, 1918883.2241666769 4219194.724791668, 1918882.6192669629 4219199.849315044, 1918882.9427433629 4219207.042876107, 1918882.981703375 4219207.403256219, 1918883.2635188266 4219208.908935362, 1918884.627793856 4219213.452493322, 1918887.7286822607 4219223.447490001, 1918889.9743095494 4219231.6925238585, 1918892.082533527 4219239.291813431, 1918895.2335067086 4219254.978169242, 1918895.7234010533 4219257.301745674, 1918895.9334950428 4219258.296481729, 1918896.3647756565 4219260.2187660225, 1918899.6929858886 4219275.012273266, 1918900.4985170402 4219278.174555748, 1918901.2499118652 4219280.906386214, 1918902.1860562128 4219284.30135259, 1918903.204145234 4219287.988007931, 1918903.2494777031 4219288.113858912, 1918903.9411043196 4219289.929174412, 1918909.5199738732 4219301.750422239, 1918910.4988326188 4219303.609445619, 1918914.806887706 4219310.970545985, 1918918.875513557 4219317.039225517, 1918920.4287638885 4219319.391766419, 1918924.2188238024 4219325.581425747, 1918912.8951805814 4219332.248818125, 1918910.6065639048 4219333.270389324, 1918900.7745038685 4219337.8373844465, 1918892.9898097694 4219340.868212287, 1918885.6327420298 4219344.2981252475, 1918883.6631568018 4219344.53391592, 1918877.8100271656 4219348.309960674, 1918871.5661053623 4219354.981693321, 1918861.1244528303 4219366.081122504, 1918857.1419787568 4219370.175716633, 1918845.5084163365 4219381.512911775, 1918844.7433318726 4219382.255741109, 1918844.196038826 4219382.785500314, 1918840.4840796445 4219386.3860000465, 1918839.7157624022 4219387.187450226, 1918834.0406891 4219393.205416666, 1918828.4662360095 4219399.597904475, 1918826.2651281944 4219402.367371776, 1918821.790014372 4219408.539281326, 1918821.2086821732 4219409.742838614, 1918820.5216780745 4219412.490962015, 1918817.9766678484 4219425.572344093, 1918815.225735714 4219425.853967709, 1918814.4106152302 4219427.679479297, 1918807.45 4219426.65, 1918782.4102847618 4219460.130414378, 1918781.76 4219461, 1918714.8640440337 4219563.153620064, 1918685.55753942 4219607.900791308, 1918662.9348258865 4219642.44269418, 1918655.794090405 4219653.345608676, 1918648.023830506 4219665.209622511, 1918642.014233127 4219674.385370494, 1918624.65174559 4219700.895267879, 1918615.0111052946 4219715.615070234, 1918610.8220798061 4219722.011079778, 1918609.0173088992 4219724.766692489, 1918608.9745242058 4219724.832018261, 1918608.942052767 4219724.88159725, 1918608.9334821436 4219724.894683294, 1918608.9308392648 4219724.898718573, 1918608.9293038636 4219724.901069814, 1918608.9283486109 4219724.902537781, 1918608.9247609756 4219724.908051259, 1918608.911323844 4219724.928700915, 1918608.9101306458 4219724.930534737, 1918608.7541840444 4219725.170188924, 1918608.3148975954 4219725.845274137, 1918607.1289255447 4219727.667847992, 1918600.914548952 4219737.217997769, 1918557.6065366021 4219803.772507034, 1918554.3970171807 4219808.704999764, 1918553.385499798 4219810.259669966, 1918526.4840179444 4219828.439626591, 1918522.0584526628 4219831.4303539395, 1918520.8573215713 4219832.2420669375, 1918520.6893548262 4219832.355578625, 1918520.677819186 4219832.3633744605, 1918502.3992823665 4219844.716040725, 1918458.974291067 4219874.060936908, 1918428.0973531988 4219894.9264224665, 1918412.4910906341 4219905.476922033, 1918399.583133973 4219914.200267557, 1918337.5855228587 4219956.09822113, 1918284.1974677863 4219992.1759556355, 1918257.9835585128 4220009.891818671, 1918252.19873587 4220013.801259761, 1918250.4820656464 4220014.961440468, 1918250.4446892263 4220014.986701135, 1918250.3348751997 4220015.060919048, 1918245.2638294676 4220018.488208781, 1918236.7801277572 4220024.22424627, 1918241.5687989176 4220026.644553133, 1918248.2658333296 4220071.730208332, 1918254.593749988 4220113.232500005, 1918279.228538876 4220267.109927427, 1918276.7055719586 4220270.480463677, 1918274.5058651038 4220271.477859237, 1918273.952033607 4220271.789546443, 1918273.7 4220272.23, 1918281.99 4220280.45, 1918287.709474493 4220285.058799785, 1918297.15 4220290.8, 1918301.85 4220294.49, 1918304.42 4220300.11, 1918309.96 4220316, 1918309.6 4220336.68, 1918314.15 4220342.38, 1918324.28 4220353.27, 1918326.58 4220355.86, 1918333.61 4220361.05, 1918342.315348067 4220367.112196352, 1918343.82 4220368.16, 1918351.46 4220373.73, 1918355 4220376.52, 1918355.95 4220377.91, 1918358.4 4220383.64, 1918358.9131797766 4220384.475194586, 1918359.703965648 4220385.493462877, 1918365.7053243988 4220393.0950458525, 1918369.335464712 4220397.441968365, 1918371.5092771833 4220399.6217475915, 1918372.8478117227 4220401.3723987825, 1918376.0193943153 4220404.542411497, 1918378.177905993 4220407.216824173, 1918379.4138540027 4220409.053532042, 1918382.3482740475 4220414.88928612, 1918387.8565122797 4220427.505530783, 1918389.4055830408 4220430.881177106, 1918394.3224806197 4220441.5434252275, 1918410.574516999 4220466.623539416, 1918410.8577093342 4220466.26436865, 1918412.7145737805 4220469.350762726, 1918445.0357059655 4220521.0276695425, 1918479.049789564 4220575.386513118, 1918510.2812499884 4220624.65625, 1918512.4529721292 4220627.527433067, 1918568.2043554964 4220716.490824148, 1918632.3950894875 4220818.884672644, 1918679.9162500028 4220894.924999997, 1918752.1485723883 4221012.522658688))'::geometry,'38188','Herbeys','HERBEYS','HER','HRB'),
     (2,'SRID=3945;POLYGON ((1910379.5565045413 4227203.473912908, 1910387.4342486935 4227212.471698963, 1910393.2927428412 4227219.163326468, 1910396.6028588056 4227222.943537274, 1910398.4028982138 4227224.999367957, 1910399.9037267924 4227226.716790995, 1910400.6432536463 4227227.560808741, 1910401.894155001 4227228.98962978, 1910403.2737585118 4227230.565531868, 1910403.5175882825 4227230.844418199, 1910403.7740913846 4227231.137271464, 1910404.0342972449 4227231.4347289475, 1910404.132222899 4227231.546550636, 1910404.2731812596 4227231.707570203, 1910404.34535357 4227231.790162866, 1910404.4191272608 4227231.874326874, 1910404.4839022288 4227231.948350005, 1910404.6377905838 4227232.124162516, 1910405.9163334495 4227233.584690069, 1910406.47991061 4227234.228913385, 1910407.2238826554 4227235.0787275145, 1910407.924452803 4227235.877824302, 1910409.3624974368 4227237.522660142, 1910410.4265074849 4227238.735423263, 1910412.345071641 4227240.927157362, 1910415.2426725442 4227244.240088133, 1910417.60964712 4227246.945114928, 1910419.486774179 4227249.087276091, 1910422.7850680838 4227252.859865755, 1910426.4777198192 4227257.073456058, 1910430.1034831726 4227261.213850959, 1910433.1700219105 4227264.717442941, 1910434.038711864 4227265.712680597, 1910436.3759895486 4227268.494111109, 1910436.6877461658 4227268.8644123385, 1910436.6947338905 4227268.859371763, 1910436.7479418986 4227268.920344742, 1910455.0407763885 4227255.742259147, 1910535.0800645459 4227198.087556943, 1910644.471233379 4227124.446088358, 1910656.4192527966 4227116.632088427, 1910660.1029368755 4227114.327480543, 1910710.544711639 4227082.926046195, 1910712.1771407754 4227081.970628812, 1910717.0822812628 4227079.34323812, 1910735.6860667204 4227069.486682636, 1910797.5882180345 4227037.975639213, 1910798.753018519 4227037.515324056, 1910799.9183553034 4227037.05646686, 1910812.8363802403 4227033.540588929, 1910818.5733034883 4227031.979447423, 1910822.5306909927 4227030.893497014, 1910828.2465950625 4227029.3341054125, 1910830.8071854915 4227028.635269313, 1910832.3075656723 4227028.225062634, 1910833.7818189852 4227027.823599337, 1910834.825555376 4227027.538841698, 1910835.9351844438 4227027.238276163, 1910836.771773157 4227027.007125295, 1910837.4423130245 4227026.825973176, 1910838.112820105 4227026.641896373, 1910838.578616571 4227026.5154963145, 1910839.779794343 4227026.187109792, 1910840.783988915 4227025.912654838, 1910842.692317588 4227025.392321691, 1910843.2570815939 4227025.238276012, 1910843.424960747 4227025.192540147, 1910856.742749495 4227021.557182491, 1910889.7552896088 4227012.538445047, 1910929.884052177 4227001.4551473, 1910946.9860886089 4226996.710119847, 1910961.1183971732 4226992.788682087, 1910969.2401860713 4226990.540144261, 1910976.8708409178 4226988.426589941, 1911151.9809380774 4226942.2731062295, 1911226.8653803237 4226930.287460089, 1911245.6912133284 4226927.264474866, 1911274.2995183594 4226923.361836799, 1911387.2914227725 4226909.502073284, 1911467.105375093 4226899.962845547, 1911553.9812499552 4226884.1899999995, 1911603.6779117896 4226870.094183588, 1911614.7924999367 4226866.410000005, 1911626.2394876878 4226862.31748405, 1911681.0934544324 4226842.156253296, 1911726.3566089077 4226819.343507006, 1911735.3419068484 4226814.790354649, 1911752.3037500014 4226804.118750002, 1911786.8579201987 4226782.255692215, 1911790.1079607669 4226780.576331912, 1911957.28074897 4226714.916090907, 1912033.367768606 4226683.672874794, 1912075.2352072722 4226666.452494929, 1912084.67222524 4226662.57907353, 1912089.5963176126 4226660.510878336, 1912092.3919457272 4226659.3149527125, 1912120.966521654 4226647.029173844, 1912168.7873419898 4226621.551004137, 1912218.702499997 4226595.190000002, 1912230.9095567355 4226588.660892076, 1912255.6868218142 4226575.418581093, 1912340.7596609197 4226533.253684194, 1912480.796789063 4226465.542720814, 1912524.069953237 4226444.559605473, 1912534.4344139376 4226439.555057182, 1912535.9457892778 4226438.824548555, 1912538.1181829206 4226437.774039436, 1912539.6651581663 4226437.02625322, 1912541.4818189596 4226436.151189198, 1912552.1027470855 4226431.016221723, 1912553.3060306814 4226430.501636886, 1912577.090791919 4226420.889888677, 1912588.3220793025 4226417.271004859, 1912588.5768912954 4226417.192891408, 1912590.3789435462 4226416.713218592, 1912591.552900725 4226416.400499748, 1912592.1331402694 4226416.246576726, 1912592.4605436358 4226416.159392104, 1912592.899750923 4226416.042378185, 1912593.4451642926 4226415.89720594, 1912593.9352811263 4226415.766779911, 1912596.0873208065 4226415.194586946, 1912631.3717191175 4226405.416330307, 1912664.9063216501 4226396.208900977, 1912686.54383967 4226389.815946086, 1912692.0147139938 4226388.072992609, 1912697.372984405 4226386.114628839, 1912699.7538364814 4226385.243709832, 1912699.9941413163 4226385.155728929, 1912700.1048634262 4226385.11522614, 1912737.6990040282 4226371.364693847, 1912742.9252854383 4226369.475035452, 1912750.340370636 4226366.872477915, 1912767.3700910902 4226361.194853219, 1912805.7477882185 4226348.401992123, 1912830.7848291188 4226338.892576626, 1912848.44128623 4226331.675697309, 1912853.406371563 4226329.228386703, 1912879.041126854 4226315.743167166, 1912885.3751765457 4226312.347056844, 1912899.435486605 4226303.917871022, 1912920.190444132 4226290.007927709, 1912940.6810546925 4226273.76379746, 1912948.9654990823 4226267.119524648, 1912952.4305177405 4226264.203648541, 1912955.6358610282 4226261.469375067, 1912962.9049061122 4226255.167020987, 1912963.900314915 4226254.298014263, 1912994.7859315332 4226225.805913978, 1913002.1273540747 4226218.686856402, 1913005.5931147689 4226215.305237486, 1913008.9356744573 4226212.064843242, 1913011.9514628302 4226209.148851982, 1913016.5166089667 4226204.697962769, 1913018.0989296052 4226203.132620428, 1913019.815519801 4226201.435139651, 1913023.8583399826 4226197.43283993, 1913030.5880348675 4226190.771538155, 1913043.5566111347 4226177.703970663, 1913056.4087387626 4226164.6309430655, 1913063.9477233095 4226156.99500857, 1913146.596943749 4226071.9432004625, 1913151.2104917977 4226066.83390025, 1913152.2468039396 4226065.705275275, 1913152.9991150647 4226064.741677228, 1913161.913126989 4226053.498278669, 1913199.628887041 4226002.865209817, 1913225.2551960172 4225967.388912517, 1913236.7714539152 4225950.882525342, 1913246.1228169792 4225936.155299993, 1913251.7909174077 4225926.162946271, 1913258.1633562527 4225912.795192587, 1913262.165823842 4225902.5040272195, 1913263.0056625097 4225900.388187658, 1913285.2664353834 4225838.239170997, 1913289.226186673 4225822.593175199, 1913291.09616571 4225813.6687539155, 1913293.938517158 4225800.2603728715, 1913297.8986168911 4225778.939541156, 1913298.6676953882 4225774.727988768, 1913299.4606916816 4225770.5707883155, 1913377.311249998 4225779.622499984, 1913422.112500006 4225785.148124983, 1913432.3174689256 4225786.282910807, 1913447.3562238577 4225787.573609202, 1913462.126950985 4225788.856676214, 1913466.5888387908 4225789.3130027745, 1913470.1363137288 4225789.843333076, 1913483.8904473437 4225792.226202529, 1913483.982985959 4225792.345091826, 1913484.0268642372 4225792.352531129, 1913484.5247439868 4225793.041117274, 1913491.5148163273 4225802.8713691635, 1913496.0086294184 4225806.573446458, 1913496.077744231 4225806.550106046, 1913496.1269078269 4225806.592681964, 1913499.950431032 4225805.266717216, 1913502.6911409115 4225804.330451171, 1913506.7414445733 4225802.959531161, 1913511.0481438825 4225801.498912754, 1913513.7131367235 4225800.59698893, 1913514.2173227675 4225800.425874184, 1913515.1440212447 4225800.112354873, 1913515.3867834262 4225800.030103637, 1913515.5264497567 4225799.982519511, 1913515.8036873275 4225799.888707182, 1913515.8533180298 4225799.871929158, 1913515.8903271419 4225799.859375894, 1913515.9172545753 4225799.850240847, 1913515.9406031335 4225799.84234096, 1913515.9467151524 4225799.840270415, 1913515.951280254 4225799.838725358, 1913515.9547743157 4225799.837542527, 1913515.9561341798 4225799.8370808195, 1913515.9577623557 4225799.836529455, 1913515.958676386 4225799.836219989, 1913515.9591567176 4225799.836057459, 1913515.9596076694 4225799.835904315, 1913515.959941119 4225799.835791272, 1913515.9602114048 4225799.83569972, 1913515.9606747075 4225799.835542872, 1913515.9609114535 4225799.835462693, 1913515.9688495076 4225799.832773226, 1913515.9737782816 4225799.831105014, 1913515.980213907 4225799.828924057, 1913515.9898984814 4225799.825651881, 1913515.9993161808 4225799.822456309, 1913516.0161286194 4225799.81676396, 1913516.0478857434 4225799.8060065145, 1913516.0912593424 4225799.791311084, 1913516.1958780475 4225799.755909706, 1913516.3179582448 4225799.714552084, 1913516.6481075366 4225799.602773236, 1913517.1413862568 4225799.435539873, 1913518.8189398877 4225798.867556748, 1913523.7575933638 4225797.194614343, 1913526.0163619618 4225796.425367939, 1913532.6067454878 4225794.175776265, 1913553.0644057363 4225787.204146606, 1913576.0320237244 4225779.396464796, 1913600.1560225189 4225771.254272676, 1913620.3388803424 4225764.484957165, 1913624.7098791993 4225763.046720156, 1913632.4288690968 4225760.768906373, 1913633.3498757747 4225760.737453416, 1913635.2109195075 4225760.631575011, 1913720.9726090394 4225734.695377435, 1913734.4674270782 4225730.609451897, 1913728.1580531478 4225723.693036134, 1913728.5148864512 4225723.488066196, 1913728.4508864204 4225723.417812727, 1913745.0145387903 4225714.00742337, 1913761.9340434982 4225704.445414254, 1913768.2673888404 4225700.866364787, 1913771.693382223 4225698.940764911, 1913774.48366423 4225697.360380453, 1913779.8762752737 4225694.334471151, 1913794.7298453555 4225688.093727596, 1913814.3492965505 4225679.8750911085, 1913819.881745592 4225666.521691069, 1913825.6669630217 4225652.657795127, 1913835.059613812 4225652.201417301, 1913836.1121086413 4225651.528660449, 1913837.124517465 4225650.8165720925, 1913838.214691278 4225650.553366094, 1913838.6159794063 4225650.446244195, 1913869.8520394762 4225648.179541993, 1913900.6217924268 4225633.05611523, 1913900.4611765796 4225632.9759942135, 1913900.9258246082 4225632.755343567, 1913888.7218042621 4225626.699745746, 1913889.5256408271 4225626.679440155, 1913889.2948150798 4225626.563272948, 1913894.2798987927 4225626.435834793, 1913906.598078388 4225626.120700873, 1913929.3305547654 4225636.786809854, 1913942.733862308 4225642.956504853, 1913955.637871766 4225648.9923101785, 1913955.6892300465 4225648.799121415, 1913955.8366342091 4225648.868164515, 1913958.7470999153 4225637.886008139, 1913958.8785439287 4225637.918183917, 1913958.8990250758 4225637.84003401, 1913970.0414492034 4225640.559983111, 1913960.3197799055 4225680.182575725, 1913995.8424017776 4225683.725112183, 1913999.489201603 4225684.090095583, 1914001.4742240596 4225684.287220987, 1914003.2851293103 4225684.468524873, 1914003.844353108 4225684.523810053, 1914004.4817666174 4225684.58777961, 1914004.6955123306 4225684.608585168, 1914005.0124167458 4225684.640483572, 1914005.1043045556 4225684.649468343, 1914005.4628077657 4225684.68535059, 1914005.4648431768 4225684.6855526, 1914005.4654981527 4225684.68561822, 1914020.9702518955 4225686.232004992, 1914021.155508914 4225686.2486247495, 1914021.161639354 4225686.280478996, 1914021.6610756118 4225686.331202991, 1914024.2173507907 4225701.294072345, 1914024.280412452 4225701.281087031, 1914024.3013961457 4225701.434227641, 1914042.5951572896 4225697.579659497, 1914042.7729690962 4225697.606682873, 1914042.971866904 4225697.563963727, 1914049.3972600864 4225698.613425403, 1914059.6919025248 4225700.293054318, 1914090.11490231 4225763.326953655, 1914096.4957338045 4225776.681855915, 1914096.546540484 4225777.171809202, 1914096.6127226546 4225777.62098368, 1914091.4904809832 4225801.678335211, 1914081.018180449 4225851.402949324, 1914076.5690928302 4225858.507931602, 1914076.038024706 4225859.352201215, 1914073.3179594565 4225863.690836277, 1914069.287636717 4225870.102335918, 1914071.93513936 4225877.354423494, 1914073.2918637653 4225881.073905763, 1914074.6590341427 4225884.826502704, 1914073.7702796198 4225896.775620775, 1914073.4524321877 4225901.033021362, 1914073.3081060494 4225902.026263551, 1914072.7982277304 4225905.336836222, 1914068.7794261053 4225948.90877703, 1914013.83780239 4226068.70247895, 1914012.3633312257 4226071.788354292, 1914003.5595123828 4226090.172979883, 1914003.2574125293 4226091.677730863, 1914002.518633757 4226095.714150438, 1914006.729261256 4226214.605598151, 1914020.8375000067 4226294.370000021, 1914084.4886285018 4226385.224601871, 1914093.4500000144 4226413.058750003, 1914314.0753137378 4226265.397355812, 1914376.8878660433 4226223.602079385, 1914400.4544987986 4226208.24663348, 1914402.952695333 4226206.587616088, 1914407.691060314 4226203.306538872, 1914419.1121256892 4226195.420074542, 1914430.4921187428 4226187.546516536, 1914460.555258559 4226166.755414562, 1914478.7489266826 4226154.211642076, 1914504.8148080907 4226136.145539712, 1914505.5025366677 4226135.701057488, 1914514.6109521922 4226130.321872874, 1914518.6875950517 4226127.911847281, 1914522.4056801838 4226125.713365546, 1914526.4944173626 4226123.284553305, 1914527.25460991 4226122.833163104, 1914527.6820475815 4226122.579218393, 1914527.9890838545 4226122.396802407, 1914528.19718127 4226122.273269686, 1914528.3251877932 4226122.197265987, 1914528.3807000653 4226122.164257586, 1914528.4191212424 4226122.141471599, 1914528.4574888812 4226122.118683492, 1914528.4714362775 4226122.1103941575, 1914528.479531258 4226122.105592017, 1914528.4833090159 4226122.10334708, 1914528.4853247541 4226122.102150046, 1914528.4874423302 4226122.100893214, 1914528.4883617966 4226122.10034959, 1914528.490038817 4226122.099353138, 1914528.4904290908 4226122.099121188, 1914528.4907290363 4226122.09894297, 1914528.4908466372 4226122.098873221, 1914528.491044021 4226122.098756173, 1914528.4911416876 4226122.098698148, 1914528.4912196216 4226122.098651853, 1914528.4913832534 4226122.098554726, 1914528.4917937096 4226122.098310896, 1914528.492160589 4226122.098093013, 1914528.4945262563 4226122.096688028, 1914528.498184447 4226122.094519049, 1914528.5060544182 4226122.089838456, 1914528.522421248 4226122.0801312085, 1914528.5556771406 4226122.06036845, 1914528.672982668 4226121.990726812, 1914529.4411096524 4226121.534594844, 1914530.6234656419 4226120.836097645, 1914530.844391476 4226120.706032738, 1914531.2452247138 4226120.469946676, 1914531.4936131132 4226120.323868352, 1914531.6939272305 4226120.206001159, 1914531.7634597425 4226120.164977957, 1914531.8725420036 4226120.100785825, 1914531.977107478 4226120.03922, 1914532.032536361 4226120.006587829, 1914532.092128712 4226119.971509096, 1914532.124334372 4226119.952546411, 1914532.139727584 4226119.943468454, 1914532.1458839178 4226119.939865624, 1914532.196352154 4226119.91015132, 1914537.556492858 4226116.756246098, 1914547.551046892 4226110.853006118, 1914558.3457275939 4226104.467966701, 1914559.3596739394 4226103.86566607, 1914570.3912500006 4226097.306875013, 1914572.8941541968 4226096.255692623, 1914575.549499223 4226095.139827496, 1914577.7876569412 4226094.203499281, 1914581.583831413 4226092.649867267, 1914583.7523981712 4226091.645485345, 1914585.6235148842 4226090.798942425, 1914585.7525386019 4226090.790839211, 1914586.4483229918 4226090.7176148705, 1914590.7200264272 4226091.409197281, 1914591.1622564793 4226091.413690873, 1914592.839837388 4226090.847078171, 1914604.9530454243 4226086.476648413, 1914607.9557986371 4226085.393323648, 1914608.6371983297 4226085.147505467, 1914609.158843976 4226084.959529588, 1914609.2380280716 4226084.930959204, 1914609.2634369594 4226084.921789499, 1914609.2907199606 4226084.911945676, 1914612.9629941708 4226083.587161345, 1914616.2108253 4226082.405523676, 1914618.9263415148 4226081.401371932, 1914629.6086610355 4226077.444307472, 1914635.5983570672 4226076.475206305, 1914635.7776630032 4226076.444078589, 1914636.3292773964 4226076.225483036, 1914638.4234577506 4226074.399600829, 1914640.2468293037 4226072.798884452, 1914643.5848254906 4226072.753888467, 1914645.9431697999 4226072.730985282, 1914647.316527595 4226071.513737122, 1914647.5636796076 4226071.385769028, 1914647.6943484596 4226071.355505125, 1914649.6772074776 4226071.004654547, 1914650.8787933025 4226070.650331395, 1914652.847546024 4226069.9792308975, 1914657.9975225872 4226068.232790559, 1914659.7319406464 4226067.5200424995, 1914660.3897253873 4226067.237443424, 1914672.4937799436 4226061.765770832, 1914675.8726308183 4226060.342463365, 1914682.199630851 4226058.227203109, 1914687.6105144084 4226056.782797341, 1914688.0603017462 4226056.62359354, 1914689.4894404013 4226056.14082553, 1914692.4663909876 4226053.887865344, 1914697.3370152588 4226052.636543059, 1914701.8893102491 4226051.134152513, 1914706.5347818097 4226049.550788845, 1914709.5976404247 4226048.4719850775, 1914709.8855319147 4226048.498496687, 1914710.0819700016 4226048.532999767, 1914724.3185602229 4226055.936506834, 1914730.253651896 4226058.568355211, 1914735.6990106367 4226060.407259618, 1914739.2055844057 4226061.048675322, 1914739.872274534 4226061.021718405, 1914742.4207089953 4226060.730068683, 1914744.99929337 4226057.762167632, 1914745.777856296 4226056.805252652, 1914750.984276749 4226050.242198069, 1914757.188749999 4226045.241874998, 1914761.9765434493 4226041.460681888, 1914765.6492040516 4226038.741830181, 1914773.5065271237 4226032.679583593, 1914781.6393447889 4226026.128141814, 1914825.0917178367 4225990.7304530945, 1914825.2925826604 4225990.9301180085, 1914825.5506146129 4225990.720608466, 1914854.9354201194 4226019.113367212, 1914868.2251239843 4226031.659915871, 1914873.4886216114 4226036.092179108, 1914875.944719137 4226038.176470131, 1914881.8760163952 4226042.647624813, 1914897.3804301154 4226053.848671479, 1914909.0391106084 4226061.633392138, 1914916.5537499273 4226066.841383632, 1914937.1720144933 4226079.078437723, 1914959.5425000268 4226089.168750007, 1914973.2509755825 4226093.146006446, 1915005.1590376059 4226100.654175028, 1915008.2684059 4226101.289504048, 1915068.2155013059 4226100.620597892, 1915078.0387780175 4226098.540391539, 1915089.85200961 4226096.032369896, 1915095.6260319499 4226094.5191778345, 1915107.4229213118 4226091.1037611775, 1915128.407278301 4226083.636832543, 1915159.6572886608 4226069.228513299, 1915173.5735374368 4226062.16776315, 1915217.5144615336 4226041.418919424, 1915230.2733566815 4226031.603479545, 1915238.889483219 4226023.731908102, 1915248.043724705 4226014.6173785245, 1915262.0561830604 4225999.24734891, 1915272.173096149 4225989.072083821, 1915279.0737757573 4225982.141204708, 1915292.3016990297 4225968.3259182405, 1915295.028442455 4225965.540503844, 1915301.6414187977 4225958.934619793, 1915306.3447335337 4225954.231623946, 1915311.1251957724 4225949.371652951, 1915313.8992523989 4225946.870079278, 1915315.2231226978 4225945.738533174, 1915317.070014395 4225944.16162847, 1915322.712466936 4225939.191734842, 1915324.7212676865 4225937.439958759, 1915335.547882155 4225927.972289773, 1915345.9965390007 4225917.067543204, 1915346.6156117015 4225916.416772899, 1915349.9810938616 4225912.228354164, 1915352.8385259153 4225908.491405052, 1915354.0505046418 4225906.9148635985, 1915356.1029225518 4225904.002835463, 1915358.6564705768 4225900.288095008, 1915370.5677569679 4225882.617592141, 1915372.4232039123 4225879.89366192, 1915381.6965072544 4225865.124661894, 1915388.3162539932 4225853.887589896, 1915395.3723511405 4225841.202833836, 1915401.125975614 4225830.0633128565, 1915409.650156087 4225812.407212654, 1915419.333831639 4225789.8436787, 1915429.4397512097 4225763.847918548, 1915432.2779259777 4225756.859484899, 1915442.442458767 4225733.799343579, 1915469.156592878 4225677.558887884, 1915473.8561253569 4225668.6473631235, 1915477.8054721914 4225661.968633691, 1915478.5576275212 4225660.388178775, 1915482.4503297 4225649.194546313, 1915484.2026975148 4225644.342919299, 1915485.2904624345 4225641.082184367, 1915486.9562915105 4225635.618361632, 1915487.6815968365 4225627.942520768, 1915489.6750000077 4225593.147500003, 1915491.0432244088 4225561.521829984, 1915491.5848056783 4225546.447739897, 1915492.0294523165 4225529.063389402, 1915492.512709291 4225486.395862056, 1915492.6741891245 4225480.912732742, 1915492.3500090481 4225479.34627481, 1915488.0286032455 4225467.776816835, 1915487.8153933117 4225465.107263486, 1915487.682752994 4225463.065309784, 1915487.7277400498 4225435.616933408, 1915487.620942784 4225422.655003653, 1915487.4140715592 4225420.664813282, 1915487.3143511289 4225419.652436592, 1915484.3253454787 4225403.697060326, 1915482.8197366747 4225395.983766685, 1915482.1167601317 4225392.883817145, 1915480.919285358 4225387.52199426, 1915476.2015584966 4225368.965525356, 1915466.7400588028 4225333.232360231, 1915460.6791172626 4225310.077042976, 1915447.4810879058 4225260.6208618665, 1915445.6407109955 4225253.274729204, 1915440.4703542623 4225232.32428642, 1915432.2246651454 4225197.237161878, 1915423.3432781885 4225159.522375828, 1915420.55541751 4225147.584858299, 1915419.0707347675 4225141.194530677, 1915417.428312422 4225133.544193153, 1915415.6912820307 4225124.32669251, 1915414.987393556 4225120.656981802, 1915414.8476611644 4225119.604046039, 1915411.9063051338 4225094.455195714, 1915410.9335287071 4225086.026110807, 1915409.3836842754 4225071.245867296, 1915407.9587249947 4225056.106705361, 1915407.2983919978 4225043.992430188, 1915406.9108995942 4225036.292919338, 1915406.3736589246 4225020.831080448, 1915405.523558355 4224995.268439444, 1915405.1234007329 4224987.233046094, 1915407.2887517018 4224971.070117132, 1915408.3851173627 4224963.89948555, 1915410.4636567703 4224951.12520482, 1915412.541259086 4224937.966778578, 1915418.2219352634 4224910.129376789, 1915422.803257095 4224891.317525203, 1915428.5834234508 4224873.788150017, 1915432.7112500088 4224862.728749998, 1915438.6792106002 4224850.209174369, 1915446.3403530046 4224836.66494598, 1915451.5253359128 4224828.13494874, 1915466.5375000208 4224802.17124998, 1915478.853143029 4224781.275520667, 1915485.895440282 4224771.232378547, 1915494.9025000029 4224760.5025, 1915510.4309482542 4224746.691894986, 1915523.9484487597 4224736.462806937, 1915555.2963290103 4224715.980146566, 1915559.2070592176 4224713.819793948, 1915572.9776691948 4224706.788986324, 1915579.9481980877 4224703.236330018, 1915601.290132003 4224693.2438560035, 1915604.469250678 4224691.84673976, 1915655.5658524577 4224671.773088435, 1915675.641269133 4224665.386743912, 1915696.5573496586 4224660.360294111, 1915708.2442273686 4224657.803323322, 1915716.7613355694 4224656.358023048, 1915749.8075000015 4224651.900000004, 1915768.357111046 4224649.8521911, 1915798.5002402014 4224646.772111251, 1915813.36644798 4224645.217184537, 1915826.8508694044 4224643.319078083, 1915841.0762530603 4224641.318591351, 1915851.713938619 4224639.960115935, 1915888.4065760928 4224638.864496772, 1915911.28263376 4224638.349532545, 1915917.2844979363 4224638.432336505, 1915949.3709271788 4224641.663187269, 1915966.8975631583 4224645.347033858, 1915974.9645201762 4224647.937922922, 1915986.9267958226 4224651.842677052, 1915982.2685398278 4224645.644749302, 1915956.9437875955 4224613.967490717, 1915939.730559666 4224591.916068472, 1915927.7672713033 4224576.86384079, 1915919.114224726 4224565.879447787, 1915913.7825056307 4224559.1429864215, 1915912.433565125 4224557.681452112, 1915905.4902435723 4224551.934398714, 1915892.6663191854 4224542.512075787, 1915889.7559844318 4224540.013887731, 1915887.8196360886 4224538.087414198, 1915884.1801532279 4224534.131857685, 1915884.0180809298 4224533.919138327, 1915883.8869999475 4224533.754122167, 1915881.2807037963 4224529.455315466, 1915876.0877373063 4224521.079516734, 1915872.02041286 4224514.6661917, 1915863.049254677 4224500.590880904, 1915853.6058227639 4224485.920282002, 1915851.4077842706 4224482.535475348, 1915847.1953543604 4224475.798271883, 1915840.1596397322 4224464.575098184, 1915833.178550471 4224455.027708825, 1915815.625773627 4224432.879125646, 1915797.5167169203 4224409.032878843, 1915794.5243398868 4224404.695009397, 1915787.165252405 4224391.51450345, 1915785.2763098725 4224387.388652171, 1915783.5079474174 4224383.077271967, 1915781.3690395767 4224375.084713624, 1915780.5439271254 4224370.836518219, 1915780.0136569922 4224365.843809169, 1915780.2847777945 4224363.739183456, 1915780.4569379936 4224362.744864809, 1915780.9244393082 4224360.451052684, 1915780.9823332503 4224360.256573254, 1915781.3319509868 4224359.1075400645, 1915782.3332968128 4224357.012387115, 1915783.8658657202 4224354.117277321, 1915786.4625617047 4224349.328886642, 1915786.6724471832 4224348.942405611, 1915786.7631947212 4224348.783822034, 1915787.2049602373 4224348.014639367, 1915787.897467613 4224346.882980099, 1915790.3523788392 4224342.865664469, 1915791.8107085049 4224340.649054646, 1915798.2534256207 4224330.698538699, 1915800.784903302 4224327.07346408, 1915803.479126571 4224323.425859316, 1915807.4485377376 4224318.130056181, 1915808.8076939913 4224316.483617484, 1915811.1804256684 4224313.608877798, 1915816.7769724964 4224307.297411133, 1915825.3217196453 4224297.130322666, 1915838.448717142 4224282.008712468, 1915855.9828542513 4224260.257052126, 1915858.3662440293 4224256.380873902, 1915863.212664367 4224247.448563469, 1915865.3612720019 4224243.058303859, 1915867.2365797989 4224238.327635476, 1915868.6719097234 4224232.395547737, 1915868.9455392158 4224230.829787581, 1915869.3912399728 4224228.125468452, 1915869.8251996206 4224224.043515969, 1915866.9524053356 4224206.384975882, 1915864.586655742 4224194.880182055, 1915863.687470743 4224187.193935598, 1915863.625432482 4224186.650287741, 1915863.4915449112 4224184.8743369365, 1915863.5722552608 4224181.50986791, 1915863.598539361 4224180.597784503, 1915863.9412164234 4224174.191677705, 1915864.6989215536 4224167.25954475, 1915864.8845065795 4224166.212874486, 1915871.0495900803 4224134.6464176355, 1915877.741745348 4224101.095452045, 1915880.8517701644 4224085.614519385, 1915881.5025444028 4224082.394371439, 1915882.0333496125 4224079.831863528, 1915883.1302498232 4224074.5953079, 1915902.4106256943 4223982.507251835, 1915912.710199466 4223932.517625173, 1915915.7608384427 4223919.559842868, 1915916.7534908203 4223916.594184942, 1915917.4611464946 4223915.041452235, 1915918.5655597863 4223912.6357764, 1915921.6768750024 4223907.379999991, 1915927.2924999997 4223901.944374999, 1915944.1349273568 4223887.564380963, 1915955.4358908979 4223878.578168515, 1915986.2484353015 4223855.119297905, 1916018.122696983 4223830.987449102, 1916047.6724187227 4223808.60280807, 1916106.2291350092 4223764.072253626, 1916108.264923741 4223762.507849973, 1916110.470275811 4223760.755374495, 1916111.5904392225 4223759.610874954, 1916113.7648391135 4223757.462442517, 1916116.2694587368 4223754.2021575095, 1916118.0631827095 4223751.1214261465, 1916118.9445241762 4223747.790027565, 1916120.1393964565 4223745.199135764, 1916120.4674894991 4223744.461435694, 1916121.9355763143 4223740.007156875, 1916122.7438572873 4223737.4864353165, 1916124.2147911766 4223731.532669942, 1916126.0530169525 4223724.147689139, 1916126.5511429296 4223722.190626306, 1916133.5460688253 4223695.0333494, 1916136.8605982517 4223680.693766983, 1916141.7123026322 4223662.676017207, 1916151.7002317873 4223622.615078565, 1916156.9574663152 4223605.283872822, 1916161.4667609746 4223590.926914051, 1916168.0150000015 4223575.51875, 1916179.9804883625 4223558.379936736, 1916181.2398921517 4223556.978178066, 1916185.9190714115 4223552.268301277, 1916191.0013175365 4223547.058574308, 1916192.7690175893 4223545.467770522, 1916193.1865458097 4223545.092201826, 1916195.5808108773 4223542.418681384, 1916201.1685112643 4223536.161470962, 1916204.2035842652 4223532.55951289, 1916205.6258774616 4223530.833157305, 1916208.3544635675 4223526.795781882, 1916211.3087125565 4223516.328504171, 1916212.7359357723 4223511.572641405, 1916214.0370210728 4223506.476306409, 1916214.4521527407 4223504.856986441, 1916214.5400981545 4223504.509836265, 1916214.6903172305 4223503.944182347, 1916216.2747115137 4223498.115392974, 1916216.285930563 4223498.074136356, 1916219.2662456236 4223487.089134192, 1916223.349877647 4223471.8973906515, 1916224.5589434125 4223467.602383596, 1916227.328854478 4223457.791204365, 1916233.3202943252 4223435.92393262, 1916237.352545542 4223421.57706035, 1916242.7430541483 4223402.509035929, 1916245.5090188882 4223392.935727653, 1916249.5928975001 4223380.663898582, 1916254.8680207916 4223365.493815192, 1916259.647895804 4223352.918386628, 1916266.3115404313 4223338.248802897, 1916276.110698473 4223319.857968506, 1916293.5427867027 4223285.079057023, 1916294.4384450135 4223283.272563763, 1916299.968272613 4223272.257581161, 1916304.1880132444 4223262.386092717, 1916304.2797008315 4223262.168597515, 1916305.506742775 4223259.113974046, 1916307.6601675218 4223253.6610069955, 1916307.8669869879 4223252.99724532, 1916310.6188795047 4223243.118754596, 1916313.1564457335 4223229.342804941, 1916314.9231669651 4223218.992113785, 1916318.9207456904 4223198.376403238, 1916322.0909530967 4223190.389759086, 1916331.919846774 4223182.027779601, 1916331.5835692082 4223179.844735479, 1916329.888099672 4223165.843491895, 1916329.7024995133 4223165.436870712, 1916325.9199746903 4223156.2059337, 1916321.9835829935 4223132.339999992, 1916318.2452408064 4223108.415103221, 1916316.4113223124 4223095.919200983, 1916314.8752638488 4223090.4845695635, 1916313.263341045 4223085.932560909, 1916313.192056729 4223081.490040837, 1916312.5949850716 4223074.202331098, 1916311.4932699325 4223069.026832953, 1916306.8005730025 4223046.44768321, 1916308.4214655792 4223046.131816964, 1916308.7905712468 4223046.059060758, 1916308.1283288654 4223037.710229445, 1916306.6348805155 4223022.154449303, 1916307.0486680493 4223003.941561462, 1916307.0330228435 4222994.292629364, 1916304.5969346545 4222982.107262579, 1916302.213324097 4222974.583079631, 1916289.8402359025 4222947.261114013, 1916286.5681249998 4222931.76, 1916285.725193828 4222929.148156842, 1916284.4260642969 4222921.606943863, 1916281.4906949184 4222908.958382629, 1916278.8353399485 4222899.009695076, 1916277.167486616 4222890.686654252, 1916273.793112546 4222872.779303162, 1916272.4119346216 4222867.980236159, 1916270.059219764 4222861.656024375, 1916269.7862540544 4222860.995607338, 1916266.3279258616 4222853.015746617, 1916264.0685655067 4222844.746668189, 1916263.0017104319 4222832.152377086, 1916261.7671002024 4222823.634673576, 1916256.6197748652 4222811.503351301, 1916255.423650515 4222806.722689808, 1916254.8641918087 4222799.588110124, 1916256.8488098686 4222789.162591089, 1916254.2498302946 4222772.646826858, 1916249.776152573 4222758.179793529, 1916239.2610606444 4222749.728753867, 1916234.7662886477 4222745.947889138, 1916225.0038066008 4222735.296154326, 1916219.3049974646 4222726.0264929, 1916215.814399941 4222715.348876493, 1916215.7025272083 4222715.003297052, 1916215.4935810904 4222714.273658838, 1916214.3889278304 4222708.7086827895, 1916213.7098149594 4222703.239916317, 1916211.4268750127 4222679.561874981, 1916210.7710276141 4222674.244464736, 1916207.9929473074 4222666.351522816, 1916191.9657283775 4222629.117369988, 1916188.366179614 4222619.791034686, 1916185.5595368117 4222611.910449335, 1916176.2712626345 4222591.183208144, 1916166.2062028053 4222574.201796738, 1916164.7719696702 4222569.035937178, 1916164.0022831399 4222566.122003418, 1916162.1563222918 4222550.43523855, 1916161.1328122912 4222546.288623914, 1916159.9143878713 4222542.825228516, 1916159.51345451 4222541.987584475, 1916155.7321849773 4222534.785100047, 1916153.3224017913 4222529.495049037, 1916151.3873369708 4222523.2194777345, 1916150.179322034 4222519.838135594, 1916150.1428930275 4222519.747747608, 1916149.266576509 4222518.265450301, 1916146.4687500072 4222515.009374983, 1916137.0196384294 4222510.927550041, 1916133.8829775804 4222507.616681404, 1916131.265201493 4222501.513783336, 1916129.502956707 4222489.582616432, 1916128.1617974332 4222486.769159615, 1916123.944056123 4222482.498290817, 1916123.1766515523 4222481.723461189, 1916118.4867562728 4222476.5202095425, 1916116.2487955508 4222473.57895494, 1916113.7220229667 4222469.879884836, 1916112.3150000053 4222466.905624986, 1916111.9037972272 4222465.852693645, 1916111.7623041777 4222463.594912403, 1916112.0764147823 4222460.997957486, 1916113.183496944 4222457.059918985, 1916113.8689271475 4222454.524458493, 1916114.624149851 4222440.983224029, 1916114.6086592304 4222438.159282355, 1916114.3658411445 4222438.24812839, 1916114.353260357 4222437.991008541, 1916044.7879934725 4222463.617712566, 1916005.0328329362 4222482.076907968, 1915972.1216561452 4222497.215475117, 1915944.1180383775 4222510.093946691, 1915936.2342202894 4222513.644155348, 1915920.6330140529 4222520.858775067, 1915920.1312828844 4222521.116591651, 1915904.629898773 4222531.619883649, 1915880.0647841746 4222562.536718933, 1915879.094597237 4222563.779520073, 1915862.612919355 4222588.240238238, 1915849.6122950169 4222606.488004854, 1915835.6719410662 4222626.103738116, 1915814.9200506115 4222654.671801621, 1915798.2987419148 4222677.55706485, 1915788.7874999996 4222690.800000012, 1915777.5766143682 4222714.626810545, 1915766.402897258 4222723.826348712, 1915764.9335935551 4222724.146766889, 1915764.2755420855 4222724.239395835, 1915762.6311032432 4222723.993911952, 1915761.906277091 4222722.57089936, 1915761.7181215219 4222722.329629841, 1915759.54386905 4222702.667761895, 1915759.3600529071 4222701.01026639, 1915753.6110020333 4222646.751624491, 1915750.2141169102 4222617.763919531, 1915747.0755390923 4222593.376127863, 1915744.9878736502 4222578.078803062, 1915743.3643471694 4222567.901093109, 1915739.3061802203 4222549.006745711, 1915734.1750433855 4222528.367412902, 1915732.011512373 4222519.656348186, 1915729.2501872955 4222508.970203049, 1915728.9475503266 4222507.800240936, 1915728.8269399996 4222507.333377422, 1915726.3927127854 4222497.965884655, 1915724.7140267296 4222491.6417769715, 1915720.2646415036 4222477.078899134, 1915719.2168989389 4222473.520785784, 1915715.0286861167 4222459.473415663, 1915709.8280307958 4222442.866620569, 1915706.8248582494 4222433.534902217, 1915702.81184203 4222422.743989399, 1915702.7734179466 4222422.640220585, 1915700.9952175368 4222417.983419013, 1915698.0208860978 4222410.201079504, 1915695.198713433 4222403.0109345885, 1915692.2867865772 4222395.622965593, 1915689.9616999684 4222389.646191179, 1915688.407259288 4222385.718274638, 1915684.3483634489 4222375.654629548, 1915679.2805440412 4222363.123647511, 1915677.0437593623 4222357.616178304, 1915674.0303502118 4222350.423926021, 1915672.0548769506 4222346.112877913, 1915669.6952165936 4222340.260787852, 1915667.776407308 4222335.623772717, 1915666.2467036895 4222331.619579823, 1915663.1897767254 4222323.422381678, 1915656.659717688 4222307.128830767, 1915653.2428424507 4222297.457195231, 1915652.365969503 4222294.972893354, 1915651.1077519336 4222291.996898927, 1915650.2339564657 4222289.933564127, 1915644.502330909 4222277.399851777, 1915636.8284626533 4222256.456524574, 1915635.2899675532 4222252.2472726535, 1915608.5026907409 4222179.515724647, 1915605.2650842345 4222170.486802716, 1915603.8170765936 4222166.454351978, 1915598.6904330382 4222152.308965605, 1915593.432927578 4222137.923240151, 1915593.3988266613 4222137.93541905, 1915592.6832724258 4222138.1604980985, 1915590.512181812 4222138.966363639, 1915587.037508337 4222140.235201418, 1915582.6179551831 4222141.364475882, 1915543.311213143 4222153.039664515, 1915513.1736452975 4222162.035666842, 1915502.6777793586 4222165.130303491, 1915491.7640965378 4222168.468527957, 1915480.0229024799 4222171.90860838, 1915474.2671662024 4222173.578165875, 1915470.7469313433 4222174.5816413965, 1915465.9921261745 4222175.9259577505, 1915456.9525153069 4222178.643806558, 1915454.1170096241 4222179.420598614, 1915451.5860987008 4222180.122056266, 1915451.57204796 4222180.063489627, 1915451.38498185 4222180.110745003, 1915429.210965555 4222086.972567343, 1915426.726669831 4222076.567803914, 1915424.8685291645 4222069.121031143, 1915422.7941805457 4222060.32160697, 1915421.1248283223 4222052.739582057, 1915421.203387938 4222052.714839388, 1915421.1701192379 4222052.565343498, 1915448.0553782557 4222043.75592672, 1915454.1224283217 4222040.113265676, 1915454.9999848178 4222039.454858299, 1915461.0393747517 4222033.204033168, 1915465.3033527343 4222027.9453820875, 1915466.5298521249 4222023.267750785, 1915468.3405769274 4222014.979767198, 1915468.9042133822 4222006.286672038, 1915467.7940810907 4222001.267223605, 1915467.632563681 4222000.790895645, 1915467.5717449824 4222000.613798133, 1915465.0749459653 4221994.7503679795, 1915454.1383798404 4221972.136459498, 1915446.3059505087 4221956.047211598, 1915445.7654495856 4221954.939741676, 1915445.2188666565 4221953.833482108, 1915445.2121984428 4221953.820155641, 1915444.3392225602 4221952.073966335, 1915443.2744914002 4221949.856926227, 1915438.1138413034 4221939.054698059, 1915436.221777304 4221934.9841810325, 1915435.4514798468 4221932.388132869, 1915435.2778713033 4221930.508116859, 1915435.1705759058 4221929.3642634, 1915435.4694436956 4221924.642620968, 1915435.6619563228 4221921.94787859, 1915436.6306478332 4221920.007107141, 1915439.146376522 4221915.000895732, 1915441.258100897 4221911.955487364, 1915441.8545843647 4221911.090703123, 1915442.7685720045 4221910.13620883, 1915443.381631135 4221909.496891429, 1915446.62128163 4221906.586214575, 1915448.2337114108 4221905.144554335, 1915450.1725578872 4221903.438298416, 1915451.6386152687 4221902.154317937, 1915454.543621456 4221899.592692829, 1915460.04876488 4221894.746984265, 1915460.5653708254 4221894.3156968625, 1915467.5250431243 4221888.216777685, 1915476.0675000062 4221880.33125, 1915451.6990690094 4221854.282771848, 1915441.1620858083 4221843.043109572, 1915430.7080195672 4221831.825557732, 1915420.6902867358 4221821.006579682, 1915419.3173245203 4221819.510309262, 1915419.041284078 4221819.177779227, 1915418.8967942838 4221819.002832305, 1915416.254411741 4221815.625554278, 1915412.291676886 4221810.324939054, 1915410.4814454454 4221807.743222343, 1915407.1553939362 4221802.886528964, 1915406.8417765375 4221802.401868197, 1915401.5455041225 4221793.919481798, 1915401.2210804657 4221793.365980832, 1915398.7993152272 4221788.9396478655, 1915396.9291357165 4221785.455614206, 1915396.3425811634 4221784.361048436, 1915394.3521346268 4221780.648524721, 1915393.76158563 4221779.488532262, 1915391.6413543941 4221774.8865182, 1915389.9621465579 4221771.203169452, 1915388.4762295664 4221767.903137722, 1915388.362136112 4221767.606061494, 1915386.942824474 4221763.698545653, 1915382.9678507114 4221751.834237253, 1915379.817355252 4221739.526481645, 1915377.9813576392 4221730.318757187, 1915376.8005296276 4221722.779878518, 1915375.711764319 4221712.33476336, 1915373.982831488 4221690.664493292, 1915372.3717328808 4221669.266032451, 1915370.0104269441 4221634.816053147, 1915369.9011250066 4221633.045907014, 1915368.7834553027 4221600.014106884, 1915368.30537538 4221589.978337903, 1915367.6880089028 4221571.892779597, 1915367.3988598015 4221563.155272954, 1915367.0320612262 4221551.727840058, 1915366.923775315 4221549.32089606, 1915366.2327430157 4221535.408363953, 1915365.990430167 4221527.826695332, 1915366.8101514468 4221522.233817957, 1915370.1138736114 4221499.078304776, 1915370.3069127412 4221496.67319309, 1915367.310091103 4221454.46341093, 1915363.9004951047 4221404.751754696, 1915363.7728167113 4221404.689525723, 1915363.7450312667 4221404.295220495, 1915345.2766017844 4221395.524635182, 1915334.4365649067 4221390.394221146, 1915326.9499373585 4221386.898379483, 1915326.0774090905 4221386.508714469, 1915307.8915132328 4221378.37193882, 1915288.8699178104 4221370.644587047, 1915268.8296859763 4221362.9346603695, 1915234.1074607393 4221351.219219311, 1915215.9451309976 4221345.7710186, 1915196.93536744 4221340.538884946, 1915189.9428914846 4221338.693797777, 1915189.9224175832 4221338.530803454, 1915189.7161117797 4221338.477939286, 1915182.197580544 4221279.2493564645, 1915171.4982527823 4221195.00217233, 1915153.232484815 4221193.671064035, 1915153.3905625334 4221191.6459326325, 1915161.2901695315 4221066.254493292, 1915161.892190864 4221056.108183445, 1915162.0024141984 4221054.189477245, 1915162.2990049105 4221049.072476527, 1915164.201914352 4221017.164467946, 1915168.162965587 4220952.962117927, 1915214.1100784428 4220955.849096674, 1915223.0955040301 4220816.205615506, 1915225.860813438 4220773.395869323, 1915225.920064426 4220772.480113461, 1915182.9158915572 4220769.767519679, 1915150.7423440372 4220767.733811687, 1915143.0351447342 4220767.237318641, 1915138.1944378235 4220766.939828501, 1915125.3028403118 4220766.147863815, 1914997.8592231825 4220758.18658148, 1914991.757636142 4220850.214603164, 1914990.7138067824 4220865.990573918, 1914911.6831154947 4220860.873650144, 1914913.4431178856 4220831.626691934, 1914751.4770127996 4220821.588439297, 1914751.4212048645 4220821.58539606, 1914743.6800685558 4220943.030443555, 1914742.250412395 4220965.462541844, 1914737.8491042845 4221034.547838833, 1914737.5482425147 4221039.261238276, 1914736.681589743 4221053.901384627, 1914736.1732334625 4221062.515092422, 1914735.308494561 4221075.788715223, 1914735.0510714601 4221079.744125474, 1914734.8187809538 4221083.2894062875, 1914734.436865696 4221089.111824449, 1914734.2230141007 4221092.587151967, 1914734.0666208386 4221095.392833092, 1914733.8985380954 4221098.045987278, 1914733.8689976805 4221098.512277122, 1914731.1599639289 4221098.610793245, 1914728.254021623 4221099.002781405, 1914644.7901812478 4221108.440247086, 1914644.7790505188 4221108.531216748, 1914644.2194028897 4221108.594289243, 1914643.6570564057 4221114.960991749, 1914638.2564708379 4221201.4560325295, 1914637.2811038983 4221217.090755197, 1914637.2447684098 4221217.673093499, 1914637.0073072892 4221221.496001632, 1914636.8193390442 4221224.525928016, 1914636.550167615 4221229.361224543, 1914636.5358037811 4221229.619502481, 1914636.5356732025 4221229.621867865, 1914636.1872309723 4221235.817626741, 1914635.8482297189 4221241.244670937, 1914632.5858443417 4221293.720818936, 1914613.9520387638 4221291.800632302, 1914609.995963486 4221291.398032776, 1914609.991848764 4221291.397610755, 1914603.1749729577 4221290.702956377, 1914587.123170154 4221289.172041165, 1914566.1781391185 4221286.997106636, 1914554.3085056446 4221285.760132571, 1914552.0982352851 4221285.552352941, 1914550.6166541858 4221285.412735534, 1914542.3769663554 4221284.709301479, 1914539.319048988 4221284.441391705, 1914529.0747465577 4221283.654349725, 1914524.5650812816 4221283.309003985, 1914522.0091189286 4221283.139872383, 1914506.4938677787 4221282.152439972, 1914500.5469760061 4221281.775370041, 1914487.9384939424 4221280.975058466, 1914468.1362043028 4221280.405476657, 1914468.1314276902 4221280.4053394, 1914459.228316819 4221280.149807874, 1914453.7383580978 4221279.995491359, 1914444.5564362265 4221279.753757858, 1914434.3409661981 4221279.483799042, 1914417.1859299168 4221279.028967691, 1914407.854416677 4221278.764386699, 1914392.800527538 4221278.340034031, 1914392.7943505822 4221278.339861315, 1914383.2613889305 4221278.072013977, 1914382.592835842 4221278.064876, 1914381.6670637897 4221278.05452334, 1914365.9903752184 4221278.172522057, 1914361.5752524927 4221278.204203391, 1914360.8476445898 4221278.217314274, 1914360.0767239274 4221278.229436082, 1914351.8650574419 4221278.362543219, 1914332.2163857212 4221278.955478464, 1914316.4571712795 4221279.43259341, 1914304.0460778081 4221279.957686635, 1914297.204274018 4221280.251698368, 1914290.6480943104 4221280.604953973, 1914273.4801113259 4221281.918331988, 1914261.355921799 4221282.9068279965, 1914240.2315832588 4221285.028207744, 1914211.9517182114 4221288.102068924, 1914196.1229593991 4221289.7378831655, 1914191.3039503759 4221290.233378849, 1914189.1551213001 4221290.489896887, 1914159.2567331041 4221294.121142971, 1914145.1140802072 4221295.8908694815, 1914116.3632103545 4221300.97094171, 1914109.4219565853 4221302.250371573, 1914102.4353310743 4221303.516958192, 1914081.7654169865 4221307.313754505, 1914061.5691632284 4221311.07368043, 1914053.9516346515 4221312.573081527, 1914047.4416706997 4221313.872753314, 1914046.3198354456 4221314.100096349, 1914039.869962696 4221315.414697053, 1914034.9645656762 4221316.45253898, 1914021.9778593678 4221319.268357977, 1914014.97688479 4221320.859507163, 1914010.3040598254 4221321.935631169, 1914006.8012734088 4221322.753130704, 1914005.1069442255 4221323.159492123, 1914003.3978825305 4221323.568541469, 1913993.223823402 4221326.030384316, 1913984.0680273932 4221328.28211194, 1913981.092428687 4221329.014169282, 1913974.0061671184 4221330.720922197, 1913973.868798182 4221330.754153599, 1913972.6912419896 4221331.038928305, 1913970.983325567 4221331.464161963, 1913968.4665433485 4221332.090113757, 1913951.446831934 4221336.412538418, 1913933.5056989775 4221341.316610671, 1913918.317219612 4221345.572046595, 1913906.5772764196 4221349.062341678, 1913902.441211713 4221350.208501273, 1913899.5685001768 4221350.902933258, 1913895.5760582753 4221351.701814183, 1913889.941693855 4221352.257277188, 1913887.4915635765 4221352.231948879, 1913884.2424746242 4221351.9949954515, 1913880.2056320384 4221351.617354851, 1913875.5257480592 4221350.720513667, 1913868.5102628227 4221348.165925647, 1913862.9168140972 4221345.2965838695, 1913857.794696382 4221342.264457121, 1913854.0196145033 4221339.485481646, 1913852.0148392282 4221337.823813598, 1913849.7034180197 4221335.3804482, 1913846.2884663893 4221331.321466686, 1913841.5556211814 4221324.586756546, 1913840.30895565 4221322.532731865, 1913839.6817347535 4221321.5272457255, 1913839.4624628176 4221320.984372602, 1913838.8333273833 4221319.294130691, 1913838.0704072858 4221317.112926312, 1913836.8998547534 4221313.163685834, 1913836.073846581 4221309.122299255, 1913830.3111498328 4221269.9176203245, 1913829.6042417886 4221269.8782728035, 1913807.0515557635 4221267.983461418, 1913789.7198890748 4221266.526008621, 1913605.2933928398 4221251.052808204, 1913561.1000911037 4221247.188698189, 1913541.348523463 4221245.467743786, 1913497.0605530944 4221241.69908004, 1913464.794755339 4221238.892673083, 1913296.2285082506 4221224.674538015, 1913217.3523537072 4221217.957733635, 1913165.6474788547 4221213.314379912, 1913117.3318691237 4221209.051089242, 1913099.8625626036 4221207.36927827, 1913099.3414355265 4221207.2109835055, 1913099.3308600592 4221207.208152071, 1913098.6717660185 4221206.876638746, 1913095.6762491465 4221205.3699172605, 1913088.9659458844 4221202.004081376, 1913077.2631578336 4221196.335885737, 1913070.4120813522 4221192.662099502, 1913060.3262188346 4221187.2431411445, 1913046.901043786 4221179.363592311, 1912962.5540804563 4221198.609026871, 1912917.3543624755 4221169.0366532765, 1912891.5129378107 4221152.159935447, 1912891.2779542003 4221151.305187247, 1912891.4850962092 4221149.218025191, 1912890.73 4221148.91, 1912869.82 4221147.22, 1912814.931988447 4221158.860973317, 1912809.75 4221159.96, 1912803.228936015 4221161.537612505, 1912783.5330158211 4221166.403448654, 1912662.2049419093 4221166.7555512255, 1912657.1907782864 4221166.769426666, 1912654.7822214437 4221166.652804775, 1912632.2073331773 4221163.748057558, 1912628.483928628 4221163.252659266, 1912603.5851031095 4221159.98389763, 1912584.725188892 4221157.516131623, 1912564.043375072 4221155.401686908, 1912544.0279520699 4221153.330098269, 1912516.7025083753 4221170.45173778, 1912489.9974746245 4221187.124173609, 1912477.4744036351 4221195.04948621, 1912475.2997740903 4221194.183760663, 1912473.2701010492 4221193.519894331, 1912471.2241480942 4221193.294738981, 1912468.604464574 4221193.24488756, 1912464.139785382 4221194.202361323, 1912461.2218155705 4221195.976906424, 1912460.2536681462 4221196.739284326, 1912459.2354821134 4221197.637904474, 1912458.7085201994 4221198.288950516, 1912457.7276375114 4221199.657029229, 1912456.0354180648 4221202.478709614, 1912454.8791070834 4221206.102144408, 1912454.6368363602 4221209.179168328, 1912454.293777322 4221209.388678291, 1912454.2866839608 4221209.569558998, 1912448.4513663969 4221213.12909919, 1912434.879458502 4221221.63777328, 1912415.4928152123 4221233.633252066, 1912389.846579422 4221249.396302757, 1912382.9438769426 4221253.702673758, 1912370.9444984095 4221260.937518664, 1912364.0271716749 4221265.114387013, 1912345.2450991983 4221276.426223523, 1912345.4003027214 4221276.8645026535, 1912346.0264229851 4221278.632603273, 1912332.8589932332 4221284.992539498, 1912324.8734527372 4221289.954122111, 1912284.5566212388 4221315.062139847, 1912284.5538725809 4221315.063853893, 1912283.582475734 4221315.67135304, 1912280.483680325 4221317.613600279, 1912276.2775338748 4221320.2498107, 1912258.056436944 4221331.660657476, 1912252.812330775 4221334.9538906105, 1912252.5421639169 4221335.197558593, 1912246.6107130307 4221343.560740181, 1912251.4433472187 4221445.817377669, 1912257.1846357072 4221556.436223192, 1912258.0092043825 4221572.309601094, 1912261.7284012511 4221613.352781636, 1912263.9365501471 4221638.800338616, 1912266.1676001656 4221661.097461816, 1912267.6032689288 4221675.243167025, 1912272.3411068493 4221729.827121593, 1912276.956016177 4221783.195280699, 1912277.7636337474 4221794.100029819, 1912277.836468405 4221796.205716163, 1912277.5896382527 4221829.142146607, 1912277.6155946576 4221841.185950242, 1912277.4153272046 4221861.713402035, 1912277.0684397935 4221895.965056663, 1912276.8812403444 4221926.271715087, 1912276.8697628903 4221943.598612818, 1912276.8697858101 4221946.821252421, 1912276.7232615466 4221981.347750926, 1912276.5865884654 4222002.184607269, 1912276.314058202 4222027.005820675, 1912276.0651944594 4222050.59771648, 1912276.0886444403 4222060.840568983, 1912276.0907664439 4222061.586965725, 1912276.0941561821 4222062.7363441065, 1912276.1048181583 4222067.133582672, 1912276.0051867587 4222108.815497057, 1912275.5462294011 4222163.884320188, 1912275.5000121065 4222171.79298783, 1912275.4749347821 4222176.572687996, 1912275.3171621046 4222190.471615815, 1912275.192400712 4222199.714156933, 1912275.178119967 4222201.082688686, 1912275.0627591694 4222213.181870741, 1912274.9287444942 4222224.9868569365, 1912274.8253067213 4222231.816174501, 1912274.4320787296 4222254.920544985, 1912274.382714645 4222264.07281977, 1912273.291332099 4222413.785923346, 1912271.459482713 4222571.5925463615, 1912269.8834018763 4222671.2587482035, 1912269.320870589 4222718.430011724, 1912269.0677721032 4222737.204006942, 1912268.842403483 4222756.2645295635, 1912268.764724041 4222756.223768237, 1912268.7584263084 4222756.584961728, 1912268.7519912054 4222756.954033812, 1912268.8478246226 4222757.002950501, 1912267.5244534465 4222867.37910931, 1912267.040034153 4222916.559573418, 1912265.5832248135 4223022.248168699, 1912265.024234123 4223117.721233212, 1912264.9878004051 4223129.080316611, 1912265.0562639104 4223147.671790687, 1912265.0563213557 4223147.686775524, 1912265.0680835657 4223150.290375803, 1912265.0271550498 4223153.93500712, 1912264.883757715 4223167.280831886, 1912264.7574187536 4223190.749334074, 1912264.577909616 4223223.476553402, 1912264.206443798 4223262.93055291, 1912263.2301844626 4223352.129795379, 1912262.3553390424 4223410.662298904, 1912261.4045647662 4223461.382231778, 1912261.2257549532 4223476.567038869, 1912261.071600363 4223490.302118102, 1912260.923380071 4223501.312120356, 1912260.9216450509 4223501.43160816, 1912260.8111313176 4223508.801016685, 1912260.5145139038 4223521.238417005, 1912260.3210526232 4223535.159817816, 1912260.0458653765 4223563.404822884, 1912259.465467518 4223635.969515079, 1912259.242448083 4223664.001373392, 1912258.9384986158 4223697.20329257, 1912258.4751467602 4223748.456604249, 1912257.9506937726 4223805.984657533, 1912257.0063205773 4223883.557067235, 1912256.4150989132 4223944.600337195, 1912255.0106090473 4224118.819916075, 1912253.5222101898 4224206.372133716, 1912252.664850125 4224274.2616524575, 1912252.6122551758 4224278.476631079, 1912251.1270175632 4224407.741604919, 1912248.1398745994 4224406.716969433, 1912248.1359357706 4224411.395437686, 1912246.14630151 4224548.796549789, 1912245.16520748 4224616.596249999, 1912244.756209505 4224647.402874485, 1912243.0433702918 4224771.722817038, 1912239.1662499902 4224929.476250005, 1912238.3480777638 4224942.553296828, 1912232.7037836437 4224999.200742829, 1912230.985578851 4225015.510717349, 1912228.1650707829 4225038.645220003, 1912223.4879815725 4225084.05499661, 1912219.3402935234 4225123.045688259, 1912216.3193941608 4225150.220275275, 1912214.821758094 4225161.492207188, 1912211.0043977867 4225188.78871961, 1912207.7465796988 4225208.363770753, 1912207.5719057252 4225209.278157946, 1912207.1957118928 4225210.840782574, 1912204.1398988394 4225223.6641990105, 1912198.7179301355 4225245.033484342, 1912193.8273327562 4225258.1630869005, 1912179.942960533 4225293.212904858, 1912168.9853069603 4225315.8568922905, 1912157.466965005 4225334.463600267, 1912139.0587044535 4225363.141027321, 1912121.9271103228 4225389.827839064, 1912086.927252024 4225437.389939264, 1912062.298041496 4225467.323937241, 1912050.9899100794 4225480.997493937, 1912039.151422542 4225493.563265894, 1912014.0740790714 4225519.013493009, 1911989.4008226001 4225543.612282137, 1911982.103283664 4225550.848438751, 1911972.116313392 4225560.441674999, 1911924.147235986 4225606.486793125, 1911908.1892208003 4225621.760749703, 1911860.0136576844 4225667.586628015, 1911805.9106431624 4225718.8240422765, 1911785.1726178094 4225738.434406222, 1911782.3644675806 4225741.089966737, 1911747.1995766957 4225774.279514711, 1911690.5061830624 4225827.238482686, 1911690.2589056366 4225827.469525556, 1911689.2945592608 4225828.370319378, 1911681.2453935072 4225835.890881526, 1911674.658238439 4225842.042456046, 1911662.6170546245 4225853.326922185, 1911649.2995037204 4225866.0356224645, 1911641.386499784 4225873.594352887, 1911615.5686065087 4225898.129521134, 1911594.800681165 4225917.627828115, 1911590.123267954 4225922.02167015, 1911588.8714992919 4225923.195874904, 1911588.5719928932 4225923.4771562535, 1911588.4935122766 4225923.550898459, 1911588.05886289 4225923.960040588, 1911587.5486673347 4225924.445109473, 1911587.541126802 4225924.452278259, 1911587.4635669927 4225924.526048503, 1911585.766173336 4225926.139938996, 1911577.7850181686 4225933.718162565, 1911554.2293845848 4225956.018209197, 1911522.8191494197 4225985.529929699, 1911522.3949303362 4225985.928616017, 1911517.571114056 4225990.462002841, 1911462.0267581563 4226042.86912473, 1911432.7178413456 4226070.566588158, 1911369.6875317218 4226130.052474563, 1911356.3034061391 4226142.633409862, 1911302.2701084344 4226192.849020497, 1911276.5786669787 4226216.986466745, 1911255.81839565 4226236.716236191, 1911161.985456938 4226324.716835346, 1911106.980103319 4226376.33058477, 1911007.3423563212 4226471.1947675245, 1910991.9097727097 4226486.737261697, 1910982.2903773412 4226496.437019274, 1910979.495974282 4226499.24683823, 1910950.1094022563 4226527.723057703, 1910912.6718680495 4226563.9721138235, 1910896.5822189916 4226579.560562837, 1910882.6161876882 4226593.090993256, 1910851.752353036 4226623.034038957, 1910836.0969146176 4226638.18218827, 1910826.8826677054 4226647.0974259665, 1910822.4846895363 4226651.360950374, 1910819.0608362677 4226654.7219326105, 1910815.68084544 4226657.972313242, 1910812.918482907 4226660.676719523, 1910806.916601728 4226666.494945675, 1910785.3850032294 4226687.386145051, 1910774.1588279582 4226698.255728356, 1910747.5032202199 4226723.9455914125, 1910709.7903642135 4226760.279383105, 1910519.8669143752 4226943.439852329, 1910385.7894524082 4227073.243260867, 1910320.8993012232 4227136.337459237, 1910351.6389926083 4227171.56351236, 1910371.323366059 4227194.095508622, 1910375.0730637847 4227198.376347359, 1910376.6319092188 4227200.166308801, 1910379.5565045413 4227203.473912908))'::geometry,'38185','Grenoble','GRENOBLE','GRE','GRE'),
     (26,'SRID=3945;POLYGON ((1915937.5987575348 4212895.405289037, 1915943.48 4212910.43, 1915946.6209961283 4212909.093613449, 1915958.6298380566 4212917.663967611, 1915983.9497854826 4212941.004334018, 1916160.3109308856 4213103.43797782, 1916333.9835800305 4213264.9996067835, 1916357.6437694586 4213286.876793763, 1916353.453002602 4213292.880897297, 1916561.9460203007 4213520.805530977, 1916619.577531576 4213583.981851717, 1916627.0302082615 4213595.31112786, 1916643.0682411634 4213673.819009004, 1916716.11594311 4213786.250183781, 1916728.1650017367 4213825.755127694, 1916770.252003794 4213900.426197422, 1916775.72485272 4213912.398653121, 1916778.4238736443 4213918.181125625, 1916787.82203165 4213940.883832108, 1916794.2858368696 4213958.49494936, 1916796.556160511 4213961.617345286, 1916798.6665400728 4213964.105559532, 1916810.9204006155 4213970.206767487, 1916812.3460902264 4213971.358977637, 1916820.7576454736 4213983.5193419065, 1916827.722567753 4213993.665840231, 1916828.4631687424 4213995.11350993, 1916833.5880802718 4214005.555982001, 1916834.1524979556 4214010.782377998, 1916834.6896073432 4214029.468950862, 1916834.2970371766 4214036.936817936, 1916832.9692318605 4214043.959462013, 1916832.793505302 4214044.929670287, 1916815.126020215 4214113.253670651, 1916822.847180629 4214133.976882962, 1916823.6453781326 4214137.615596776, 1916824.194671674 4214141.125848798, 1916823.0423799918 4214148.623989662, 1916821.142505474 4214163.713332162, 1916843.6139061684 4214188.71248322, 1916847.254117485 4214196.992184185, 1916833.575277021 4214243.459153558, 1916832.9651288847 4214249.839368707, 1916836.7761834962 4214329.302841413, 1916836.5925132497 4214339.901742568, 1916833.152553879 4214392.692731019, 1916830.7088410659 4214434.216853083, 1916830.5368688835 4214437.189890522, 1916830.154482359 4214442.969750918, 1916830.0802956203 4214444.092473898, 1916830.0747861248 4214444.176283023, 1916829.7325482697 4214449.365978147, 1916829.479085458 4214453.205967842, 1916829.8007490574 4214455.154720009, 1916830.4218385296 4214458.291433541, 1916856.7213633712 4214515.465861324, 1916885.5908509549 4214576.474390054, 1916899.778538955 4214606.888891522, 1916914.3254695307 4214638.039585668, 1916942.4121381552 4214698.675755921, 1916958.1545003369 4214732.895778898, 1916970.6183035935 4214759.131135458, 1916974.9619751526 4214768.13756395, 1916980.4656661132 4214779.532259609, 1916982.2447910863 4214782.161983442, 1917030.008348035 4214829.394179539, 1917237.953334428 4214866.667504659, 1917251.814925656 4214870.090594753, 1917251.9615265867 4214868.917787307, 1917252.0591767246 4214868.136586202, 1917254.0627063739 4214868.458232125, 1917314.317977824 4214873.041849283, 1917320.1980643945 4214872.790349445, 1917330.3998780907 4214870.167740211, 1917359.5084122946 4214858.968009889, 1917366.861764855 4214859.805866806, 1917378.5923285424 4214858.389516924, 1917379.7168884336 4214858.310121892, 1917386.7985666802 4214859.3869725065, 1917390.2111239347 4214859.906769519, 1917392.8750242656 4214860.12555655, 1917399.4775973714 4214860.705841511, 1917404.00156878 4214861.223800989, 1917410.4019235172 4214861.504125113, 1917413.7541871902 4214860.57924428, 1917416.179530775 4214859.946928759, 1917425.4565309924 4214855.593161885, 1917457.99834584 4214837.219739657, 1917774.570376964 4214845.881533756, 1917776.3464307257 4214844.200014648, 1917778.4780151425 4214844.253922194, 1917793.5704284755 4214829.795130713, 1917901.7695521694 4214725.96398535, 1917941.2991352146 4214688.163939948, 1917949.4682217652 4214680.368052403, 1917963.6608262893 4214666.8994836975, 1917984.9459593242 4214646.70013836, 1918104.9196730491 4214532.726788909, 1918134.0210113628 4214504.920102384, 1918136.21101109 4214502.4112663, 1918139.496304871 4214498.597691909, 1918280.626174089 4214515.345799595, 1918550.10548911 4214545.683195176, 1918548.2295899699 4214529.43126441, 1918535.3149414388 4214392.605758855, 1918524.0469195715 4214269.723996574, 1918523.145228146 4214269.07382827, 1918523.116315102 4214268.77865284, 1918498.8628883401 4214251.409537652, 1918433.9689170148 4214205.331836452, 1918371.9544461241 4214160.978178153, 1918340.36517085 4214137.995349875, 1918339.4776760605 4214136.936159593, 1918315.7730838144 4214133.88060493, 1918300.9309532666 4214132.473764352, 1918282.3898544917 4214130.256837744, 1918265.6200112172 4214129.4832307445, 1918179.3170445343 4214130.038886639, 1918167.00043933 4214125.949392304, 1918151.3771356274 4214119.983820851, 1918137.8275188622 4214112.106129717, 1918130.166453873 4214107.252966224, 1918126.110933334 4214104.452932402, 1918121.924541157 4214101.438531111, 1918110.5958942447 4214091.187115701, 1918110.0219573763 4214090.659180928, 1918110.0158089236 4214090.653482853, 1918103.318927442 4214084.407201733, 1918085.819066701 4214067.950009611, 1918078.5218347334 4214060.252233834, 1918078.5140090117 4214059.410968743, 1918078.501469709 4214058.062993726, 1918070.9517988476 4214052.903742972, 1918048.591103383 4214020.20900919, 1918025.171945379 4213985.907962099, 1918021.8022489303 4213980.986914735, 1918017.1086223687 4213974.778127208, 1917956.4856937265 4213884.305898996, 1917949.8118308806 4213868.497929526, 1917949.727117644 4213866.669907051, 1917942.3079834513 4213862.607017193, 1917881.188408189 4213825.11344821, 1917874.7649434994 4213820.752271717, 1917860.6904916572 4213812.200099533, 1917821.3644977396 4213790.315645409, 1917789.8155170486 4213775.184780132, 1917788.7688963753 4213774.787326408, 1917783.0075730977 4213772.728579129, 1917769.4895483917 4213772.158915037, 1917762.7175835264 4213772.2528123, 1917758.852980612 4213772.222888426, 1917743.4405638345 4213772.00647227, 1917730.3052894187 4213774.1124737, 1917727.4312916927 4213774.635062568, 1917721.347081313 4213776.473723769, 1917718.800255151 4213777.620270892, 1917715.661724982 4213779.088719543, 1917706.157644979 4213785.827353648, 1917693.0042121236 4213795.6228035195, 1917654.2730216158 4213834.570235723, 1917643.07104251 4213846.632722672, 1917641.7818708706 4213847.203843524, 1917630.6150230446 4213856.117852945, 1917619.3380831778 4213840.508895371, 1917614.595526953 4213830.977951905, 1917608.1304256846 4213816.674854459, 1917606.284631975 4213812.223038044, 1917597.711163078 4213787.772448724, 1917590.916829345 4213770.495751274, 1917574.756063313 4213740.447455619, 1917547.091936577 4213732.498481667, 1917535.2069733508 4213726.571330323, 1917510.2301806954 4213711.03517622, 1917500.7240054233 4213703.451118952, 1917469.1758058993 4213677.935519233, 1917448.4724354066 4213655.312125744, 1917433.1885375592 4213639.3639397705, 1917402.81700161 4213618.919350563, 1917389.4594554745 4213609.39768723, 1917381.0339973022 4213604.404001612, 1917345.5573637746 4213594.582526686, 1917340.808259083 4213591.576443, 1917327.1845890766 4213582.173121895, 1917293.3665257206 4213568.237428527, 1917271.17592426 4213557.599111, 1917257.1625810366 4213551.18117415, 1917250.7420719685 4213547.924805442, 1917224.145540159 4213531.176394296, 1917220.2298410605 4213529.418779483, 1917214.9291656953 4213528.266929431, 1917213.1671307087 4213527.922253572, 1917184.965300295 4213524.336779987, 1917143.7908107268 4213468.469232569, 1917127.9478973642 4213446.527408288, 1917126.3240916082 4213444.00666095, 1917114.8675396165 4213421.652997267, 1917104.7520801227 4213401.039695849, 1917104.111664645 4213401.521127811, 1917103.6588637296 4213400.653059742, 1917065.4743867728 4213428.400886339, 1917065.8324788602 4213426.242469019, 1917063.9116700308 4213427.613884226, 1917080.6782174648 4213326.297391627, 1917077.1911224986 4213324.708751075, 1917077.3741891866 4213324.194420856, 1917069.7006548927 4213321.296265694, 1917064.737892498 4213319.433988376, 1917050.6281928758 4213312.607289088, 1917045.4870321979 4213310.117860648, 1917022.2188463432 4213299.628601874, 1916993.54520305 4213299.412228872, 1916986.091996584 4213297.652337036, 1916970.8536472274 4213292.894129487, 1916970.3238716635 4213292.735020184, 1916969.9503045098 4213292.65170065, 1916942.3513896277 4213286.370835344, 1916917.9311790909 4213284.068189926, 1916899.0043084065 4213282.022907584, 1916863.6946747536 4213276.16722142, 1916818.6211973962 4213271.579642927, 1916819.328765182 4213269.11, 1916849.9542449093 4213160.551394929, 1916854.8546633262 4213139.695873202, 1916852.1117497867 4213138.550551842, 1916846.3462276012 4213136.143120614, 1916830.925791745 4213130.432903595, 1916815.252080836 4213123.884735799, 1916799.4247397722 4213116.550748678, 1916726.2162796026 4213082.638714511, 1916658.2579085832 4213054.2326707095, 1916556.2714081202 4213021.5105309775, 1916494.2792402138 4212998.968606492, 1916394.16443529 4212976.45314557, 1916299.2185876206 4212945.332080788, 1916094.0417785773 4212885.099781719, 1916028.3783100427 4212885.953897968, 1915971.7468410383 4212894.063485566, 1915964.4911361448 4212895.1083192, 1915953.2681366869 4212894.789581648, 1915937.5987575348 4212895.405289037))'::geometry,'38252','Montchaboud','MONTCHABOUD','MCB','MCB'),
     (23,'SRID=3945;POLYGON ((1911543.97 4236900.11, 1911562.6946244743 4236884.741457786, 1911564.0071903686 4236886.863512418, 1911632.0378947367 4236832.69208502, 1911579.6323157225 4236467.331801684, 1911627.4910032034 4235994.190099847, 1911620.1687497222 4235857.037905646, 1911574.9225914269 4235398.6041057855, 1911470.6832484654 4234955.302881458, 1911462.4061705237 4234914.8579325145, 1911448.5564303065 4234858.038573429, 1911402.5449999587 4234755.320000032, 1911368.6044331603 4234677.45546563, 1911326.5515586839 4234587.2070344305, 1911238.3749999723 4234408.760000033, 1911197.7867003968 4234317.349585022, 1911068.7824999292 4234121.7275, 1910962.4605405636 4233897.936105073, 1910956.0213351764 4233883.977775258, 1910952.7390715084 4233877.11023093, 1910952.0452416777 4233874.20311821, 1910945.5724999933 4233852.7849999685, 1910943.217151334 4233795.0938515775, 1910934.946750991 4233724.465354268, 1910926.1356680128 4233650.939473711, 1910926.145026876 4233648.785372258, 1910926.0997208094 4233646.960701846, 1910927.119692503 4233633.007653524, 1910927.1404834078 4233632.720937741, 1910927.179895455 4233632.195302914, 1910927.222697872 4233631.608260668, 1910937.3584728637 4233486.609866576, 1910936.2761015033 4233483.115244946, 1910929.8576341502 4233472.295789511, 1910925.2534039752 4233464.535834329, 1910915.3665062592 4233447.907273307, 1910880.3525463135 4233388.735462061, 1910800.7738764912 4233254.245749017, 1910763.378615017 4233190.450646506, 1910760.1920075722 4233185.0584418345, 1910758.9131492272 4233182.898132435, 1910757.8319792617 4233181.0688889595, 1910757.5450463356 4233180.583418151, 1910757.365562882 4233180.279811007, 1910757.2485127083 4233180.082323154, 1910757.240168437 4233180.068218843, 1910757.092752968 4233179.81877582, 1910744.7377327438 4233158.951525321, 1910740.8422334942 4233152.364169362, 1910737.1973711737 4233146.4248787435, 1910734.2738778156 4233141.883401128, 1910720.819934771 4233121.20144947, 1910698.6181781208 4233089.791639691, 1910661.7913165276 4233038.104300559, 1910655.3249220243 4233029.211017828, 1910621.0309601775 4232980.519359238, 1910587.223693654 4232932.575879132, 1910586.5238325729 4232931.5815756805, 1910585.4791209113 4232930.096909563, 1910582.7327363545 4232926.184834488, 1910545.2155325962 4232872.699344397, 1910537.9281697616 4232785.5901946565, 1910535.9211955396 4232785.204005608, 1910535.691297043 4232782.685895463, 1910266.420565622 4232732.088105638, 1909776.7342759345 4232636.003772733, 1909683.8281712497 4232622.0507390015, 1909570.1567585568 4232688.6249442715, 1909570.5812439523 4232689.906526047, 1909568.8521407358 4232690.931416993, 1909589.8183544914 4232759.134372149, 1909633.3410806467 4232854.410669424, 1909671.5970850068 4232921.480323828, 1909732.2334672417 4233170.952156599, 1909737.8992263717 4233316.097813813, 1909736.4314227982 4233314.536934277, 1909736.5257228666 4233317.457780666, 1909636.6703796894 4233209.367564223, 1909572.5231892627 4233141.21315839, 1909571.7450935212 4233143.691519451, 1909570.8485583519 4233143.064859664, 1909556.395870156 4233190.127208682, 1909546.0681530505 4233221.842016618, 1909544.5126724748 4233226.605261197, 1909543.97853662 4233228.154943461, 1909542.9221649359 4233231.440448903, 1909534.5010236234 4233257.881586827, 1909533.9743539873 4233256.711656568, 1909533.3469374133 4233258.48366255, 1909518.497744919 4233219.283847319, 1909497.197559603 4233182.676676922, 1909482.4373240361 4233158.895254646, 1909464.332034776 4233133.171769957, 1909399.6690015423 4233094.821368611, 1909360.031473196 4233070.626178993, 1909296.4311415106 4233128.739473685, 1909294.2048176564 4233131.821151642, 1909270.9418562886 4233184.334460671, 1909218.465829061 4233302.306440648, 1909207.4319046512 4233347.421190084, 1909186.5166654652 4233430.212559784, 1909188.77 4233435.5, 1909184.44 4233438.03, 1909185.51 4233440.87, 1909188.63 4233439.31, 1909195.77 4233489.5, 1909197.23 4233500.79, 1909198.47 4233510.21, 1909200.34 4233522.43, 1909206.75 4233568.97, 1909211.05 4233602.61, 1909223.5 4233694.56, 1909242.56 4233836.35, 1909248.67 4233880.15, 1909256.64 4233938.6, 1909263.71 4233990.77, 1909269.32 4234031.49, 1909275.59 4234078.53, 1909280.62 4234112.7, 1909284.7 4234141.67, 1909288.48 4234166.45, 1909296.06 4234206.07, 1909301.4 4234244.65, 1909309.92 4234304.27, 1909317.51 4234354.4, 1909323.23 4234395.46, 1909329.18 4234435.04, 1909332.35 4234455.87, 1909354.24 4234455.01, 1909374.92 4234454.19, 1909381.26 4234454.57, 1909389.23 4234457.1, 1909405.86 4234474.76, 1909416.94 4234484.45, 1909424.46 4234493.26, 1909450.59 4234487.86, 1909470.4 4234517.54, 1909463.16 4234542.74, 1909474.77 4234591.62, 1909483.53 4234616.29, 1909508.27 4234626.73, 1909517.8 4234632.63, 1909522.58 4234637.45, 1909535.68 4234653.24, 1909554.63 4234682.03, 1909560.35 4234690.16, 1909566.76 4234697.4, 1909580.44 4234702.66, 1909603.9 4234702.28, 1909630.23 4234704.67, 1909655.55 4234707.04, 1909691.76 4234716.36, 1909708.49 4234720.81, 1909716.98 4234713.33, 1909723.67 4234711.44, 1909736.39 4234709.71, 1909752.39 4234710.49, 1909762.02 4234711.58, 1909794.28 4234722.7, 1909811.71 4234717.92, 1909823.11 4234720.55, 1909825.97 4234719.81, 1909841.5 4234715.84, 1909863.64 4234730.3, 1909875.94 4234748.63, 1909905.98 4234762.53, 1909925.73 4234793.54, 1909928.33 4234807.58, 1909924.48 4234838.28, 1909922.89 4234852.23, 1909928.47 4234866.45, 1909931.55 4234869.11, 1909948.98 4234894.79, 1909954.87 4234902.94, 1909982.27 4234933.12, 1910002.16 4234954.9, 1910010.06 4234963.57, 1910020.94 4234966.72, 1910033.55 4234975.15, 1910042.35 4234990.35, 1910065.67 4235010.26, 1910089.12 4235030.71, 1910093.8 4235033.69, 1910115.9 4235038.16, 1910153.46 4235048.01, 1910162.92 4235058.34, 1910188.52 4235074.51, 1910194.9 4235078.41, 1910208.76 4235100.24, 1910223.38 4235112.32, 1910238 4235126.68, 1910248.63 4235137.83, 1910271.5 4235165.82, 1910281.76 4235180.66, 1910291.91 4235198.46, 1910296.2 4235207.37, 1910301.37 4235219.58, 1910304.66 4235232.88, 1910305.9 4235240.84, 1910295.06 4235264.32, 1910286.88 4235281.96, 1910291.04 4235289.66, 1910319.42 4235314.19, 1910337.33 4235330.92, 1910365.7 4235358.01, 1910366.78 4235362.95, 1910369.9 4235374.58, 1910375.23 4235383.64, 1910389.26 4235399.29, 1910406.45 4235418.51, 1910416.08 4235430.11, 1910421.14 4235441.17, 1910421.14 4235441.84713746, 1910426.02 4235460.49, 1910438.19 4235501.3, 1910443.07 4235515.7, 1910447.82 4235526.11, 1910453.08 4235532.75, 1910470.41 4235550.24, 1910483.47 4235563.85, 1910496.46 4235579.29, 1910508.38 4235593.32, 1910520.61 4235611.18, 1910537.52 4235636.23, 1910552.17 4235657.44, 1910574.62 4235650.64, 1910586.22 4235648.08, 1910586.91 4235642.65, 1910588.4 4235642.64, 1910595.44 4235643.09, 1910614.28 4235649.01, 1910629.74 4235655.51, 1910637.39 4235660.37, 1910639.96 4235664.25, 1910647.27 4235684.7, 1910646.8974484522 4235684.154447507, 1910649.97 4235692.97, 1910649.24 4235702.34, 1910658.91 4235714.99, 1910661.54 4235721.71, 1910667.61 4235731.32, 1910685.45 4235742.04, 1910698.61 4235744.82, 1910708.7 4235748.3, 1910714.52 4235753.46, 1910716.73 4235739.87, 1910718.67 4235736.55, 1910722.62 4235734.37, 1910723.84 4235740.57, 1910727.58 4235746.33, 1910732.6 4235751.07, 1910743.38 4235759.04, 1910749.86 4235765.44, 1910768.29 4235778.33, 1910782.35 4235788.42, 1910784.61 4235792.33, 1910785.3 4235796.28, 1910784.68 4235805.33, 1910783.77 4235827.94, 1910790.6 4235842.83, 1910791.64 4235847.77, 1910795.87 4235866.9, 1910802.35 4235896.85, 1910811.04 4235943.87, 1910812.7 4235958.19, 1910810.9 4235985.49, 1910811.94 4235995.93, 1910813.61 4235999.08, 1910816.72 4236001.78, 1910821.44 4236004.45, 1910845.41 4236010.44, 1910865.47 4236016.33, 1910876.94 4236020.85, 1910883.14 4236025.12, 1910886.33 4236029.04, 1910891.98 4236040.22, 1910897.48 4236052.74, 1910900.22 4236057.13, 1910903.2 4236059.9, 1910920.11 4236069.53, 1910927.7 4236076.27, 1910933.31 4236083.8, 1910947.1 4236103.01, 1910961.37 4236121.68, 1910974.12 4236138.7, 1910976.44 4236144.95, 1910981.16 4236178.27, 1910981.85 4236210.53, 1910980.91 4236227.93, 1910987.88 4236235.96, 1911005.17 4236248.24, 1910998.55 4236274.4, 1911004.68 4236287.26, 1911007.83 4236295.26, 1911009.95 4236304.14, 1911010.54 4236310.98, 1911008.91 4236326.77, 1911010.43 4236335.63, 1911014.31 4236342.73, 1911021.38 4236350.56, 1911045.91 4236372.21, 1911048.98 4236372.11, 1911049.29 4236377.03, 1911055.91 4236391.45, 1911063.29 4236422.13, 1911067.58 4236436.92, 1911063.74 4236436.5, 1911067.72 4236471.44, 1911069.56 4236487.8, 1911076.04 4236513.34, 1911084.11 4236544.71, 1911092.67 4236577.92, 1911099.35 4236603.85, 1911104.86 4236620.32, 1911112.38 4236637.3, 1911116.71 4236643.91, 1911121.35 4236648.38, 1911126.9 4236652.05, 1911157.28 4236669.26, 1911162.24 4236684.37, 1911178.42 4236708.42, 1911182.3 4236721.73, 1911188.19 4236736.45, 1911198.86 4236755.98, 1911207.14 4236768.08, 1911222.63 4236786.02, 1911230.66 4236795.68, 1911238.63 4236806.78, 1911250.48 4236824.61, 1911254.15 4236829.77, 1911274.42 4236848.6, 1911288.59 4236873.64, 1911294.76 4236883.89, 1911333.53 4236903.16, 1911337.27 4236904.56, 1911348.15 4236928.47, 1911358.44 4236950.91, 1911361.21 4236956.03, 1911374.17 4236966.99, 1911401.3 4236980.56, 1911412.18 4236986.97, 1911415.05 4236989.55, 1911416.23 4236990.61, 1911440.62 4236981.85, 1911449.07 4236976.53, 1911465.43 4236963.96, 1911467.71 4236962.68, 1911495.43 4236939.91, 1911543.97 4236900.11))'::geometry,'38258','Mont-Saint-Martin','MONT-SAINT-<br>MARTIN','MSM','MSM'),
     (40,'SRID=3945;POLYGON ((1921364.6688812065 4226409.948850477, 1921383.69 4226396.51, 1921383.2918217103 4226395.22453168, 1921383.0232976482 4226395.293899376, 1921378.7322954605 4226380.5046770405, 1921375.1518338476 4226368.029327595, 1921369.7737926936 4226350.337850075, 1921352.3781188405 4226292.356684149, 1921347.98052275 4226277.213852328, 1921343.221255443 4226261.253669398, 1921341.2321576218 4226254.1550071845, 1921339.8836173678 4226249.258295695, 1921332.991494948 4226225.403859014, 1921328.3893344668 4226208.000658063, 1921318.161667331 4226173.930108554, 1921302.4219774758 4226120.449171937, 1921291.9812633358 4226085.068136, 1921286.0718909919 4226064.823044447, 1921281.323171228 4226049.091255671, 1921280.6436127478 4226047.1264557745, 1921277.396313258 4226035.774156124, 1921265.1174536992 4225993.264733014, 1921146.4980617396 4225903.894615376, 1921143.2201848924 4225901.590636162, 1921142.9680322313 4225901.41462365, 1921125.0161553537 4225887.597155492, 1921115.6879875928 4225880.419404001, 1921110.4526905215 4225876.386578264, 1921104.1419818061 4225871.530772997, 1921101.17262286 4225869.288994252, 1921098.5077142585 4225867.299095668, 1921097.4422839247 4225866.504393913, 1921096.652045117 4225865.91122701, 1921095.6390513862 4225865.151969504, 1921089.885264687 4225860.839866255, 1921084.2338167804 4225856.58837818, 1921080.279840327 4225853.533026345, 1921050.984560746 4225830.855673384, 1921038.9198810286 4225821.287947822, 1921014.5563200163 4225801.962162076, 1921014.458843747 4225801.873430101, 1921070.4491599316 4225732.988990388, 1921112.0470856396 4225681.900248839, 1921111.856469204 4225681.672732733, 1921103.7710266812 4225675.910269309, 1921103.836017504 4225675.784354675, 1921110.9003533632 4225663.643085437, 1921110.3048841376 4225663.216570524, 1921116.8853224856 4225651.954331462, 1921272.7036566222 4225655.088248643, 1921274.30956425 4225655.393705593, 1921481.9245254586 4225659.526173743, 1921497.5369775544 4225659.819320301, 1921513.6561316783 4225660.061501447, 1921574.3152701124 4225660.942817556, 1921584.499133038 4225661.059993524, 1921616.8999640597 4225661.413632103, 1921643.1067409872 4225661.65957672, 1921652.112638322 4225661.724357437, 1921674.4721332774 4225661.859351911, 1921701.117980615 4225662.033335484, 1921710.9101901276 4225662.132541262, 1921712.0496606876 4225662.098349724, 1921715.613498911 4225661.981107152, 1921717.711688153 4225661.714741327, 1921720.1601740075 4225661.379346194, 1921725.1956390443 4225660.00519219, 1921732.0710956552 4225656.5702492455, 1921749.8784417713 4225645.376072978, 1921786.3253741958 4225622.481050197, 1921809.4416852817 4225608.320240125, 1921814.0149467285 4225605.474586717, 1921845.8554353728 4225585.659028424, 1921919.6309577168 4225539.508880565, 1921927.2434324394 4225534.981065282, 1921931.5725779128 4225531.749233212, 1921931.6556013739 4225531.6884323675, 1921934.5030302142 4225529.948071091, 1921945.3908770203 4225523.734406851, 1921966.3087499943 4225510.561249988, 1922001.8618749913 4225487.441874988, 1922034.7724999937 4225454.264999993, 1922043.0625623255 4225443.384048018, 1922050.348021836 4225435.076742211, 1922054.518193652 4225424.50222072, 1922060.213771536 4225415.033615725, 1922069.767944262 4225408.827668217, 1922083.9931250087 4225400.612499989, 1922099.5899711289 4225387.271748926, 1922118.6799999985 4225379.060625002, 1922134.19524363 4225372.722756468, 1922138.9343968031 4225371.341026496, 1922149.7594472815 4225360.922509248, 1922154.9420521597 4225358.063857912, 1922166.9540967837 4225356.752102674, 1922177.1410053137 4225353.183039887, 1922194.0365664265 4225344.5669776695, 1922210.424422064 4225341.660690676, 1922225.8934105267 4225334.125435354, 1922229.147816972 4225331.024415303, 1922238.755419112 4225318.290385007, 1922240.8721099908 4225315.5468344195, 1922245.4113360415 4225311.208404744, 1922247.8169555657 4225310.671331721, 1922248.8587868009 4225310.537513524, 1922255.7664973272 4225311.635447746, 1922268.6385531982 4225312.837430442, 1922281.2307580714 4225307.190340568, 1922294.9245828856 4225298.681137507, 1922311.7174999963 4225278.08625, 1922316.3154278768 4225271.061770948, 1922328.1778080089 4225257.206405962, 1922343.1516347923 4225239.144599377, 1922350.6891452773 4225229.876663691, 1922357.5024999876 4225218.912499996, 1922370.6933025979 4225195.64678415, 1922376.8092736313 4225185.1687404085, 1922392.371042828 4225171.046513684, 1922397.4910880416 4225165.976508086, 1922400.4784277827 4225165.242246628, 1922421.2858916721 4225161.620341352, 1922448.964930423 4225155.523265087, 1922453.9718343015 4225153.02057248, 1922465.1078921389 4225145.94788059, 1922467.62898151 4225144.252392435, 1922478.7740028552 4225135.601940306, 1922486.9871567881 4225128.220053095, 1922488.707007809 4225126.76076325, 1922491.2264598738 4225123.817795411, 1922491.7939869333 4225122.311202694, 1922492.249142424 4225120.78595211, 1922499.7427362043 4225111.067906028, 1922504.0150290835 4225105.442413653, 1922505.148530548 4225104.4411630435, 1922514.2231249963 4225096.902499989, 1922555.692973178 4225097.337363993, 1922571.5495539352 4225100.667606863, 1922586.637729176 4225101.178122153, 1922601.623905177 4225105.129945379, 1922619.5941678865 4225106.2204073025, 1922628.3684025935 4225106.252979314, 1922637.2168560487 4225109.023866156, 1922641.0455625718 4225110.2031318825, 1922653.457702027 4225109.727329561, 1922655.28162421 4225109.58539444, 1922681.5321043557 4225151.430850751, 1922761.761062862 4225196.217889685, 1922759.6457429926 4225199.1191744525, 1922752.4924566452 4225208.728875737, 1922743.9637403197 4225222.54157884, 1922722.1044507683 4225254.95275159, 1922720.0837943733 4225259.47217124, 1922716.6039271632 4225267.354741903, 1922734.6070871893 4225286.925654229, 1922751.2450073014 4225304.65209252, 1922756.8395128732 4225310.059035791, 1922759.7089191065 4225312.660246265, 1922762.9244560888 4225315.236998989, 1922773.297960085 4225323.372797232, 1922782.4028907055 4225330.114521726, 1922787.4032461545 4225333.681951432, 1922788.6655970055 4225334.613362631, 1922795.7133830797 4225344.554013631, 1922805.074893254 4225357.624592434, 1922816.1318027219 4225373.591142092, 1922828.1694510356 4225391.434821116, 1922834.466948442 4225397.343127486, 1922843.2470405754 4225423.447519627, 1922848.3362515266 4225427.731666412, 1922849.803985525 4225428.954068136, 1922851.7833335986 4225430.599999908, 1922852.1477568166 4225431.0641563125, 1922877.97693854 4225459.124954082, 1922890.1990298887 4225475.586317107, 1922916.1606614096 4225513.127062062, 1922929.392450282 4225524.760410164, 1922937.1908786902 4225528.959531491, 1922940.654582943 4225538.7409356395, 1922947.5637500556 4225550.1237499695, 1922953.2468547798 4225567.464407921, 1922959.9869467556 4225579.007210359, 1922991.8746786742 4225598.12134192, 1922996.7040899482 4225602.418252283, 1922997.2495984614 4225603.159670974, 1922997.745878809 4225604.595341617, 1922995.582500048 4225624.629999991, 1923014.87840084 4225640.100759066, 1923028.2070647832 4225675.011953407, 1923031.8608811996 4225673.262505693, 1923054.7025000034 4225659.569999956, 1923084.3975000067 4225712.112500003, 1923102.4199999978 4225740.447500004, 1923115.824048578 4225761.477029352, 1923142.843749964 4225816.11499999, 1923149.888705902 4225832.699997209, 1923160.6656317585 4225831.611091819, 1923193.6563751418 4225806.421951334, 1923214.8318768335 4225783.554914839, 1923233.4210406565 4225770.958395085, 1923259.4171659402 4225738.879664898, 1923281.1964575974 4225706.745511901, 1923288.074061235 4225699.989463562, 1923290.7566423789 4225695.4630077565, 1923297.9175053798 4225679.969552131, 1923309.8571456727 4225657.87483659, 1923310.9037758976 4225655.560005397, 1923312.5738097595 4225651.8663929, 1923314.696931308 4225647.170686745, 1923319.848079585 4225651.305063785, 1923331.998472888 4225664.93642506, 1923333.4096826017 4225677.903511556, 1923340.797876806 4225688.78814075, 1923341.6812224344 4225683.103349539, 1923343.7228742705 4225686.311659568, 1923348.9294129557 4225657.7878542505, 1923353.4172047488 4225635.750613773, 1923357.4156719432 4225625.269072635, 1923368.147499994 4225609.228749991, 1923377.104083107 4225586.196468671, 1923378.1300010018 4225584.326668335, 1923426.7969809354 4225556.481727697, 1923433.086653311 4225553.243341589, 1923466.3710131443 4225540.90575627, 1923500.4237487407 4225527.187761769, 1923520.2810231748 4225528.563511358, 1923543.189685816 4225530.158086143, 1923557.8711796475 4225531.823980819, 1923579.4521089557 4225534.82011816, 1923618.3200000299 4225540.2162500005, 1923622.0111025136 4225547.837978164, 1923633.3966236478 4225571.3478502035, 1923636.3612163526 4225587.8340447135, 1923641.3794923034 4225595.299695786, 1923650.8419427495 4225604.2484448375, 1923653.46 4225602.08, 1923666.36 4225619.53, 1923667.47 4225622.12, 1923684.61 4225598.28, 1923703.45 4225570.24, 1923726.47 4225535.29, 1923731.23 4225529.18, 1923737.68 4225522.5, 1923743.61 4225517.1, 1923751.45 4225511.23, 1923750.66 4225509.37, 1923716.7527539162 4225428.090353945, 1923704.8721921772 4225399.705435083, 1923693.4 4225372.4, 1923692.64 4225370.2, 1923663.88 4225301.85, 1923681.62 4225285.38, 1923683.34 4225283.5, 1923684.12 4225281.81, 1923684.54 4225272.44, 1923683.16 4225266.22, 1923681.48 4225259.67, 1923675.53 4225237.66, 1923672.77 4225218.6, 1923671.92 4225213.17, 1923661.38 4225166.79, 1923656.31 4225156.62, 1923652.51 4225147.72, 1923640.94 4225120.13, 1923636.84 4225109.86, 1923623.45 4225083.69, 1923620.56 4225073.32, 1923608.49 4225061.2, 1923602.26 4225054.48, 1923591.02 4225039.68, 1923579.47 4225024.51, 1923575.8 4225018.74, 1923576.45 4225018.12, 1923581.46 4225014.72, 1923615.16 4224991.83, 1923594.84 4224961.49, 1923623.05 4224946.44, 1923611.57 4224922.36, 1923599.56 4224892.51, 1923567.37 4224894.91, 1923564.19 4224908.25, 1923560.27 4224927.81, 1923559.45 4224930.83, 1923558.55 4224932.63, 1923557.48 4224934.61, 1923556.21 4224936.25, 1923554.68 4224937.77, 1923549.74 4224939.14, 1923547.42 4224935.65, 1923530.27 4224907.15, 1923527.93 4224904.62, 1923518.4 4224894.27, 1923516.25 4224889.54, 1923511.5 4224879.49, 1923509.25 4224874.48, 1923509.28 4224871.62, 1923509.84 4224867.53, 1923510.21 4224861.34, 1923509.44 4224855.81, 1923508.44 4224851.56, 1923501.03 4224833.91, 1923487.45 4224802, 1923483.69 4224747.46, 1923483.98 4224739.04, 1923485.66 4224704.25, 1923485.44 4224694.97, 1923484.46 4224675.87, 1923483.52 4224673.83, 1923479.92 4224666.72, 1923475.98 4224657.6, 1923472.14 4224646.84, 1923469.82 4224637.32, 1923467.4 4224622.69, 1923468.28 4224580.9, 1923462.51 4224570.58, 1923451.93 4224541.9, 1923444.66 4224530.13, 1923420.61 4224484.84, 1923418.91 4224470.64, 1923378.93 4224401.64, 1923360.1 4224360.63, 1923349.86 4224339.08, 1923326.42 4224293.88, 1923319.79 4224271.94, 1923310.32 4224265.73, 1923298.58 4224236.51, 1923275.06 4224196.58, 1923268.69 4224176.1, 1923259.62 4224162.27, 1923250.49 4224136.61, 1923234.89 4224126.66, 1923214.52 4224100.68, 1923206.63 4224097, 1923191.86 4224074.97, 1923193.52 4224072.4, 1923192.64 4224069.93, 1923190.29 4224059.47, 1923188.08 4224047.36, 1923187.78 4224042.37, 1923188 4224039.41, 1923188.19 4224035.15, 1923189.11 4224031.54, 1923191.81 4224026.71, 1923197.69 4224017.82, 1923200.84 4224012.06, 1923203.45 4224006.66, 1923207.09 4223998.05, 1923209.57 4223989.91, 1923211.3 4223986.38, 1923213.86 4223982.48, 1923219.67 4223973.68, 1923220.34 4223970.24, 1923222.94 4223961.99, 1923225.63 4223951.37, 1923228.57 4223940.93, 1923232.12 4223930.87, 1923234.68 4223925.26, 1923238.19 4223920.18, 1923241.9 4223915.28, 1923248.02 4223909.14, 1923256.41 4223898.69, 1923266.01 4223889.12, 1923272.37 4223882.69, 1923274.61 4223880.41, 1923284.36 4223870.54, 1923299.17 4223856.23, 1923306 4223849.83, 1923312.56 4223842.94, 1923320.26 4223834.28, 1923334.05 4223818.56, 1923346.64 4223803.48, 1923349.42 4223799.1, 1923351.77 4223795.36, 1923354.16 4223784.67, 1923356.88 4223777.95, 1923360.38 4223771.6, 1923367.35 4223763.27, 1923372.79 4223750.16, 1923379.34 4223734.63, 1923380.55 4223731.02, 1923380.12 4223725.27, 1923372.04 4223700.85, 1923363.9 4223679.38, 1923356.68 4223661.58, 1923353.27 4223648.25, 1923348.47 4223627.38, 1923345.77 4223614.77, 1923342.69 4223605.14, 1923339.22 4223596.01, 1923336.68 4223588.94, 1923335.84 4223587.38, 1923329.57 4223575.71, 1923318.52 4223556.48, 1923314.83 4223550.92, 1923310.18 4223545.78, 1923297.93 4223534.13, 1923282.84 4223519.17, 1923280.37 4223515.71, 1923277.69 4223507.49, 1923272.98 4223493.08, 1923268.09 4223481, 1923261.92 4223469.28, 1923250.6 4223451.16, 1923239.52 4223435.19, 1923235.68 4223431.01, 1923227.21 4223422.63, 1923208.41 4223407.62, 1923195.01 4223395.59, 1923186.01 4223386.11, 1923181.33 4223382.3, 1923170.18 4223375.08, 1923150.23 4223360.58, 1923133 4223348.23, 1923126.31 4223343.34, 1923122.47 4223339.66, 1923113.86 4223329.36, 1923100.55 4223313.22, 1923092.29 4223303.31, 1923087.31 4223298.71, 1923078.14 4223289.86, 1923059.82 4223276.79, 1923043.42 4223265.55, 1923029.01 4223255.69, 1923015.99 4223245.87, 1923011.88 4223243.19, 1923007.82 4223238.89, 1923003.11 4223232.02, 1922998.07 4223225.41, 1922993.35 4223221.01, 1922985.14 4223214.21, 1922976.8 4223208.2, 1922966.9 4223201.82, 1922953.59 4223193.55, 1922940.72 4223185.42, 1922928.04 4223177.1, 1922911.32 4223164.41, 1922896.48 4223153.97, 1922888.07 4223149.3, 1922863.29 4223135.81, 1922845.94 4223126.76, 1922839.43 4223123.39, 1922826.62 4223115.99, 1922815.41 4223108.89, 1922801.26 4223099.35, 1922794.82 4223095.66, 1922785.39 4223091.18, 1922770.8 4223083.38, 1922751.51 4223073.7, 1922736.12 4223066.7, 1922724.42 4223062.18, 1922717.82 4223058.24, 1922710.64 4223054.23, 1922705.24 4223050.63, 1922702.23 4223049.66, 1922693.3 4223048.8, 1922679.02 4223049.11, 1922673.87 4223048.66, 1922661.23 4223046.48, 1922650.17 4223044.25, 1922642.72 4223044.22, 1922637.1 4223044.8, 1922624.62 4223047.67, 1922611.74 4223052.36, 1922603.61 4223054.61, 1922591.7 4223055.3, 1922563.81 4223055.96, 1922551.78 4223056.26, 1922536.43 4223054.3, 1922515.38 4223051.63, 1922503.87 4223049.88, 1922492.16 4223048.56, 1922478 4223049.86, 1922466.45 4223050.5, 1922461.66 4223051.37, 1922458.47 4223053.54, 1922456.71 4223054.72, 1922441.5974999901 4223058.12124998, 1922438.9659807733 4223059.989845761, 1922409.3735232316 4223081.002932408, 1922389.7885388131 4223093.295232242, 1922377.99 4223100.57, 1922362.6787013698 4223113.67121335, 1922351.317499996 4223123.392500009, 1922337.241927198 4223136.2300610505, 1922323.5475000087 4223148.7200000025, 1922281.3662499993 4223165.968750003, 1922254.6202342075 4223177.261512227, 1922236.0850000025 4223185.087500003, 1922207.6912500095 4223215.215000015, 1922178.515000007 4223236.098750011, 1922151.38 4223261.695, 1922131.748750013 4223274.889999985, 1922095.2769997742 4223287.983876129, 1922071.6437499912 4223307.184999997, 1922056.9403774631 4223316.603823182, 1922044.8324999867 4223324.359999998, 1922052.7592235745 4223375.202797606, 1922059.158750021 4223416.25000006, 1922067.901250043 4223430.446250012, 1922055.5587500336 4223454.986249968, 1922048.6500000264 4223541.382499994, 1922043.4462500121 4223606.9775, 1922037.628750004 4223645.808750009, 1922030.5425000023 4223666.842500014, 1922021.2937499997 4223677.907500016, 1922005.1974999874 4223686.825000019, 1921945.921249992 4223697.193750002, 1921925.5387500073 4223721.001250005, 1921906.253750006 4223742.355000005, 1921888.966250005 4223782.305000005, 1921871.2212499946 4223852.199999993, 1921855.9937499783 4223885.963749986, 1921845.4089851656 4223891.552388363, 1921830.9337497996 4223889.124166208, 1921828.4752833624 4223888.73799632, 1921816.942499979 4223884.49249997, 1921746.7786994472 4223845.997274825, 1921662.6962500012 4223792.9187499955, 1921599.533749994 4223736.684999985, 1921561.4087499776 4223723.498749986, 1921537.675000006 4223716.004999995, 1921517.5451970666 4223707.737268603, 1921512.7487282725 4223708.945639446, 1921506.8810842566 4223708.997996997, 1921491.878750018 4223716.46000002, 1921453.7237499931 4223737.638750042, 1921399.942499997 4223766.093750036, 1921383.0928087044 4223777.770167025, 1921326.3424999788 4223836.291250015, 1921318.122499981 4223847.081250006, 1921305.8132338107 4223867.815850152, 1921284.91124999 4223915.64874999, 1921284.794811623 4223915.797405945, 1921276.2422505806 4223930.158906857, 1921265.82342372 4223935.415557507, 1921258.0215996301 4223937.232107361, 1921254.0063269802 4223939.018444098, 1921226.4638066092 4223967.490146318, 1921210.5667342204 4223991.335826781, 1921189.7336101695 4224017.459268493, 1921161.14124998 4224039.103749968, 1921141.2687499775 4224104.092499998, 1921127.9250466537 4224149.495852302, 1921109.5587499945 4224179.029999976, 1921101.8618420323 4224197.554082702, 1921089.3854878712 4224249.828561002, 1921083.2186540929 4224263.578318842, 1921060.300112298 4224300.046030151, 1921043.9408440604 4224327.928420215, 1921032.3042494925 4224354.349363137, 1921025.3776555886 4224365.746356938, 1921000.8792122449 4224411.786877508, 1920995.7351147118 4224427.941020327, 1920995.8774999403 4224452.7412500745, 1920998.7551008458 4224460.506886233, 1921001.0538081336 4224464.401386072, 1920993.7699999646 4224491.008750019, 1920992.1974945834 4224511.632991377, 1920991.7764625226 4224514.870283359, 1920990.3526417848 4224519.183723214, 1920979.9150022443 4224549.907414221, 1920977.2090892862 4224570.9101017015, 1920975.3674999725 4224587.741249971, 1920958.941249985 4224646.818749995, 1920952.8175000048 4224658.366249994, 1920937.1905085794 4224664.488112909, 1920934.0905790299 4224669.672097026, 1920930.7281364845 4224673.18166702, 1920929.1799999543 4224673.636666583, 1920925.0069390908 4224674.52994858, 1920904.0339805633 4224678.585181959, 1920895.5785844112 4224680.913165535, 1920886.979588277 4224683.591340312, 1920886.2493496523 4224683.819759745, 1920885.6580153594 4224683.985065212, 1920884.893558246 4224684.192851813, 1920882.3526879023 4224684.886339058, 1920880.7030331877 4224685.336380342, 1920876.396956244 4224686.478560106, 1920869.8289510247 4224688.035975487, 1920867.089010935 4224688.732080522, 1920865.9362260168 4224689.025642999, 1920862.1836109841 4224695.314841621, 1920860.5308940185 4224698.562652354, 1920859.4340701196 4224700.715205822, 1920859.0566666059 4224701.456666652, 1920858.4447554646 4224702.879531734, 1920857.577161424 4224704.877356904, 1920855.1591813127 4224710.435904534, 1920852.5798824804 4224716.797545694, 1920849.5808234399 4224724.201052775, 1920844.8818443816 4224736.5273309685, 1920841.3528130807 4224745.6754347505, 1920828.1640900213 4224779.067501897, 1920826.2206085653 4224783.958566017, 1920818.8635776408 4224803.253200271, 1920817.1831463631 4224807.376995493, 1920813.2547473626 4224816.530668805, 1920806.6502723119 4224831.44892924, 1920802.1275152874 4224840.829716233, 1920799.0657410887 4224847.54373817, 1920799.263121858 4224847.6752437195, 1920799.202123146 4224847.809231011, 1920806.7650795265 4224853.077196692, 1920806.6420362822 4224853.351291208, 1920806.8242790243 4224853.483494975, 1920796.8167074102 4224873.115407766, 1920776.4740098922 4224913.436850009, 1920776.3637601868 4224913.319794766, 1920776.0981947798 4224913.037836432, 1920758.6399024795 4224947.626181458, 1920735.680609134 4224992.4219871145, 1920716.7478248489 4225029.705631223, 1920713.3366929628 4225036.445043142, 1920712.1410545232 4225038.918584255, 1920687.4641445125 4225088.119493985, 1920682.3629856997 4225098.326455584, 1920639.9917250706 4225184.269089062, 1920591.2912636977 4225286.084148385, 1920533.1521523318 4225407.09850911, 1920483.4606919556 4225510.694415427, 1920433.091945541 4225615.765054924, 1920420.9362810263 4225641.432819048, 1920401.4289126915 4225673.0467795525, 1920381.6756123377 4225700.337970646, 1920368.7937499983 4225719.176875, 1920351.8264551684 4225743.658765948, 1920339.1806338567 4225778.639027071, 1920391.8541244927 4225798.450280863, 1920362.55144487 4225876.556294021, 1920331.0278238705 4225960.329817807, 1920280.1558204815 4225947.221534022, 1920265.1172023213 4225942.8894860605, 1920261.9066475593 4225942.087652543, 1920272.6698328985 4225960.134982166, 1920277.690939009 4225968.527385448, 1920281.5479248846 4225975.244212917, 1920281.9283010198 4225975.905816983, 1920284.965203062 4225981.19784666, 1920290.2681602088 4225991.120525873, 1920291.3124147176 4225993.276918774, 1920292.3658602815 4225995.437753472, 1920295.4058486852 4226002.368214871, 1920296.5964432324 4226005.10070174, 1920296.8355996946 4226005.698323652, 1920297.4775749722 4226007.3067276785, 1920300.4012622219 4226015.7118985085, 1920301.4049367404 4226018.85216092, 1920304.8757200304 4226031.053245658, 1920305.7431473283 4226034.664530509, 1920308.4710263035 4226047.360910089, 1920311.6768793457 4226078.692703052, 1920312.064967148 4226082.328462546, 1920312.3673041994 4226085.370598807, 1920313.0473149428 4226092.9330340745, 1920313.874670178 4226103.336015617, 1920314.389843874 4226108.804287494, 1920314.7872115409 4226111.651262652, 1920315.6810713578 4226115.177846412, 1920315.8090197183 4226115.588033803, 1920316.6246174031 4226117.656987047, 1920317.913695276 4226120.836941302, 1920321.695301256 4226127.164567882, 1920331.4898304665 4226139.315912824, 1920370.6403963245 4226187.9145024335, 1920378.9625523528 4226198.28018294, 1920383.7872127604 4226204.280414328, 1920388.9251387157 4226210.5471913265, 1920390.9512797366 4226213.008011795, 1920395.7245887045 4226218.716499376, 1920400.1072417349 4226223.936238015, 1920402.4949944352 4226226.6512633, 1920413.9681250027 4226239.608749989, 1920418.8366375887 4226246.423836131, 1920418.702948859 4226246.479483216, 1920418.849875413 4226246.684486933, 1920415.0736832556 4226248.643238797, 1920438.1416061644 4226291.54778184, 1920457.0779308164 4226327.319664969, 1920477.901375694 4226366.865684342, 1920482.1965362257 4226375.010122475, 1920488.716550823 4226387.1508967085, 1920497.0772684435 4226402.707749072, 1920497.2012857525 4226402.938512968, 1920521.6768981954 4226448.477863623, 1920554.6065707593 4226509.737686604, 1920554.5119514929 4226509.814451738, 1920554.5535609322 4226509.892046836, 1920504.9591668816 4226550.096462177, 1920403.6671096103 4226632.211539462, 1920379.7845075224 4226651.571793579, 1920378.7595085718 4226652.402875631, 1920356.0909874786 4226670.781072858, 1920352.666998991 4226699.3706072895, 1920346.0456249993 4226753.5831250055, 1920395.9934035987 4226756.312775126, 1920413.4905614848 4226754.840567057, 1920441.9037969648 4226751.014094022, 1920500.0955745508 4226749.745280043, 1920531.2168256943 4226748.683169476, 1920567.842906274 4226749.144520692, 1920627.0463139447 4226758.653513248, 1920669.61696992 4226761.887643355, 1920704.963954155 4226765.623656733, 1920770.4892558635 4226767.661960032, 1920808.1003331973 4226765.308868293, 1920891.8013598549 4226750.809587134, 1920951.322367271 4226728.543635143, 1921020.6011868159 4226671.275859336, 1921123.0604911046 4226589.221164988, 1921188.2925409102 4226537.710652322, 1921208.7522300833 4226521.320536068, 1921245.1421405945 4226491.965074022, 1921314.6133144165 4226436.044282423, 1921354.9548727395 4226413.174738961, 1921364.6688812065 4226409.948850477))'::geometry,'38271','Murianette','MURIANETTE','MUR','MUR');
INSERT INTO urba_plui_ecriture.ref_limites_communales (ogc_fid,geom,code_insee,nom,nom_etiquette,nom_abv,trigram) VALUES
     (21,'SRID=3945;POLYGON ((1912603.92 4203436.22, 1912589.03 4203437.48, 1912545.76 4203431.76, 1912530.66 4203430.41, 1912518.55 4203430.72, 1912494.06 4203440.45, 1912482.04 4203442.62, 1912263.24 4203457.8, 1912295.59 4203479.82, 1912299.59 4203482.9, 1912312.14 4203495.98, 1912324.41 4203509.49, 1912335.3 4203521.72, 1912347.47 4203539.18, 1912356.35 4203556.47, 1912359.27 4203563.14, 1912361.59 4203570.65, 1912362.86 4203576.25, 1912363.1 4203580.53, 1912360.28 4203595.53, 1912357.7 4203607.3, 1912353.35 4203620.87, 1912350.41 4203629.08, 1912348.33 4203634.56, 1912345.58 4203641.89, 1912345.08 4203647.71, 1912344.52 4203655.57, 1912341.55 4203670.82, 1912341.26 4203676.9, 1912340.78 4203693.51, 1912339.82 4203703.91, 1912337.45 4203715.34, 1912335.45 4203722.52, 1912331.08 4203732.54, 1912327.11 4203740.22, 1912321.96 4203746.62, 1912317.48 4203752.14, 1912307.88 4203761.7, 1912286.84 4203782.15, 1912264.71 4203805.9, 1912247.22 4203829.42, 1912231.5 4203852.28, 1912214.95 4203878.33, 1912191.22 4203920.68, 1912167.65 4203950.05, 1912150.3 4203968.59, 1912128.75 4203991.2, 1912104.54 4204012.46, 1912083.7 4204028.06, 1912056.37 4204042.35, 1912005.2 4204064.32, 1911868.03 4204124.65, 1911813.65 4204148.97, 1911794.4 4204159.01, 1911778.01 4204171.09, 1911757.33 4204190.95, 1911745.65 4204207.14, 1911731.4301133435 4204204.262165796, 1911725.758663183 4204218.48001889, 1911723.4278123463 4204231.639214323, 1911725.4371941318 4204244.899246584, 1911726.9421846864 4204259.622805869, 1911729.3311017884 4204281.574971664, 1911735.5680840253 4204310.65431916, 1911757.1653164218 4204381.4222868, 1911769.1677775325 4204423.196967444, 1911773.496346262 4204447.177024117, 1911778.6964407153 4204478.664048232, 1911783.307024116 4204510.516214028, 1911787.429886656 4204551.182805868, 1911789.3207482249 4204583.092601478, 1911784.2257817523 4204614.26858762, 1911784.1914690514 4204649.434274919, 1911786.1600188906 4204683.869284365, 1911790.1034002418 4204718.263648971, 1911790.2589612068 4204735.279904955, 1911792.7407496427 4204754.7278470965, 1911789.3815068325 4204778.285649518, 1911786.1194383814 4204804.596769362, 1911781.4001133437 4204838.255441721, 1911794.4598299842 4204904.161166802, 1911799.0479475479 4204937.415536174, 1911809.7062967294 4205035.769612901, 1911815.8184600184 4205065.11479225, 1911823.1306190966 4205096.065357817, 1911825.3281852559 4205104.346420408, 1911834.530710418 4205137.225879364, 1911844.6765162412 4205160.469952255, 1911875.2744237832 4205213.997312924, 1911893.1144447823 4205244.334199166, 1911915.8551694534 4205276.301190238, 1911951.0199001357 4205319.014561229, 1911986.6699001358 4205350.326190239, 1912026.5296308182 4205374.033145052, 1912080.1141343182 4205401.63643606, 1912140.8385969272 4205423.783583823, 1912210.0057514682 4205467.85011297, 1912259.1511902392 4205507.833866245, 1912297.6829507507 4205567.294313598, 1912311.9006247954 4205604.530268605, 1912310.5790608611 4205694.256641695, 1912308.7327884948 4205731.539487923, 1912317.928110871 4205788.045848028, 1912319.3035053886 4205794.539577131, 1912319.6781497942 4205795.804284223, 1912332.9264682909 4205844.009573413, 1912351.2828626293 4205889.9283840945, 1912408.331459557 4206018.120495255, 1912448.6345993653 4206110.2917744415, 1912483.1437401713 4206209.869022595, 1912549.2485838227 4206176.743258021, 1912654.94 4206128.45, 1912665.2470303427 4206125.324811749, 1912686.7377700026 4206113.493735193, 1912694.2807898598 4206106.802654487, 1912716.2031180472 4206077.984467588, 1912720.1938055493 4206059.718788242, 1912721.0219586557 4206039.505072899, 1912739.480867521 4205971.607135559, 1912753.500813582 4205954.8334518885, 1912788.2685973763 4205920.079232194, 1912829.1800564844 4205885.134079078, 1912861.3283145053 4205858.838073431, 1912881.9972176328 4205828.681359954, 1912898.772084054 4205810.562003787, 1912903.4550944678 4205805.434780057, 1912903.9 4205803.88, 1912904.9092006083 4205797.96727236, 1912904.183295793 4205774.894432472, 1912904.717826196 4205774.754685962, 1912904.605292213 4205773.986754062, 1912937.0877157096 4205759.421334138, 1912951.8338693653 4205753.299309214, 1912963.3608197076 4205749.082758863, 1912967.178419835 4205747.768576442, 1912969.5399370082 4205746.950324169, 1912983.026309624 4205740.930833743, 1912991.4010669538 4205737.766475781, 1912999.4727908212 4205735.627722615, 1913006.06257379 4205734.395845432, 1913008.6318418079 4205733.844071473, 1913040.1871438548 4205727.2313797595, 1913057.0943208663 4205718.959866217, 1913069.0212381233 4205711.4656119635, 1913070.0604797567 4205710.7850218825, 1913070.8972191059 4205710.50714133, 1913072.3874239984 4205709.968048016, 1913085.9206681242 4205706.569283685, 1913099.2411489543 4205702.726569031, 1913104.0975483437 4205701.353419363, 1913107.5725427275 4205699.480187545, 1913114.3347481717 4205695.65150909, 1913116.8042620837 4205694.191194078, 1913118.6536107652 4205692.5533964345, 1913123.6055642837 4205688.434932959, 1913143.5057243758 4205668.020459894, 1913145.6475647904 4205666.619622405, 1913147.876330867 4205664.997951249, 1913156.1821020758 4205663.133278622, 1913190.5344944375 4205657.7476135185, 1913192.9646535418 4205657.055980488, 1913204.7195782617 4205648.283725718, 1913218.5580451875 4205639.116954813, 1913220.8676569327 4205639.244486597, 1913430.7988712303 4205644.775099395, 1913610.4073570282 4205650.152834387, 1913730.6460295592 4205653.180917077, 1913826.1040856256 4205655.937845192, 1913827.0362870912 4205655.752883396, 1913833.6761349835 4205654.098499258, 1913964.6143074334 4205598.663237445, 1913973.481254694 4205597.263827234, 1914076.68375226 4205580.976076255, 1914079.7184483025 4205578.337971743, 1914114.0323016257 4205549.404022848, 1914182.7918369 4205538.239828962, 1914244.4508225909 4205528.110378174, 1914253.9255845146 4205495.920052297, 1914255.3628814307 4205485.370037781, 1914256.2124856585 4205456.099039502, 1914255.982165796 4205420.98572508, 1914259.39031155 4205398.986968102, 1914260.9985862155 4205385.100259079, 1914260.0397693329 4205372.040367211, 1914259.6847260615 4205366.534229808, 1914257.6864407153 4205360.901779642, 1914257.243229803 4205355.126440715, 1914256.9807345257 4205346.705028336, 1914259.65627831 4205340.528089955, 1914264.366146421 4205330.124058167, 1914268.822206141 4205317.7506024605, 1914272.630624268 4205299.981706106, 1914279.8046799637 4205263.00570619, 1914281.813460038 4205257.137445945, 1914283.0313239954 4205251.455270904, 1914287.8839643288 4205241.957542503, 1914296.0792122465 4205233.482320283, 1914315.3518633065 4205208.820650272, 1914318.4439546776 4205203.005777047, 1914318.8886863152 4205196.967050317, 1914316.909317751 4205181.984555118, 1914318.2456651516 4205163.164524881, 1914323.332215529 4205137.8254230935, 1914324.0773015886 4205125.832263182, 1914322.2149330059 4205112.893586661, 1914323.2264560824 4205099.176545142, 1914336.4998586378 4205089.452541102, 1914367.2432980903 4205066.930107368, 1914378.1886911823 4205056.370819365, 1914402.412407249 4205029.822642419, 1914416.5311545231 4205014.973025134, 1914431.1698966355 4205002.250797775, 1914455.3244113603 4204981.258609667, 1914484.9330451875 4204955.526359693, 1914512.64735122 4204939.364419002, 1914542.8290903082 4204937.880797753, 1914573.406168108 4204936.144367791, 1914603.5699070054 4204934.368724241, 1914644.7861943673 4204943.67248312, 1914679.1202331244 4204940.479826394, 1914698.0311529667 4204943.191085479, 1914732.0622489266 4204948.0701246215, 1914746.5888521238 4204950.152804112, 1914763.2770665775 4204949.649441072, 1914780.5793911389 4204949.12755476, 1914823.1439747282 4204947.843688338, 1914832.65530662 4204943.597815672, 1914853.2997730456 4204931.834688319, 1914869.5952769134 4204918.622275374, 1914894.5507229725 4204898.388371516, 1914911.5009437304 4204881.3872508835, 1914923.1632668723 4204869.689906912, 1914938.039444388 4204854.769057673, 1914957.3068592001 4204835.4437846765, 1914970.8318088062 4204821.878220954, 1914991.3400858308 4204801.051983738, 1915090.7233713951 4204698.045384965, 1915089.64 4204684.97, 1915095.82 4204672.7, 1915081.35 4204670.77, 1915032.67 4204659.55, 1915012.95 4204661.55, 1914893.14 4204689.8, 1914842.6 4204694.56, 1914805.6 4204676.69, 1914786.03 4204668.03, 1914775.41 4204659.82, 1914766.1 4204647.19, 1914762.61 4204628.41, 1914755.99 4204580.17, 1914757.79 4204558.09, 1914774.36 4204521.18, 1914792.75 4204471.76, 1914797.3 4204452.39, 1914796.61 4204423.9, 1914792.25 4204400.37, 1914781.06 4204352.34, 1914716.44 4204363.41, 1914687.7 4204359.1, 1914677.56 4204356.91, 1914645.45 4204349.97, 1914635.02 4204341.31, 1914612.09 4204316.69, 1914592.15 4204300.2, 1914577.51 4204294.57, 1914519.23 4204320.38, 1914465.1 4204341.43, 1914438.69 4204349.62, 1914412.75 4204363.25, 1914394.95 4204364.52, 1914349.68 4204351.61, 1914327.64 4204346.33, 1914303.67 4204336.78, 1914259.19 4204280.08, 1914212.81 4204215.4, 1914159.58 4204143.86, 1914130.29 4204095.37, 1914098.66 4204039.23, 1914097.62 4203950.52, 1914110.91 4203886.4, 1914109.38 4203865.1, 1914098.43 4203812.61, 1914108.9 4203763.62, 1914109.57 4203742.58, 1914103.37 4203707.41, 1914097.62 4203679.61, 1914084.21 4203621.83, 1914089.34 4203572.63, 1914098.7 4203546.56, 1914100.34 4203534.6, 1914096.76 4203512.87, 1914080.34 4203523.56, 1914054.41 4203529.72, 1914018.45 4203544.73, 1914002.54 4203534.73, 1913978 4203524.17, 1913948.74 4203515.65, 1913931.12 4203514.48, 1913899.26 4203517.08, 1913862.58 4203518.05, 1913852.24 4203511.53, 1913817.07 4203468.4, 1913795.57 4203447.14, 1913775.05 4203430.63, 1913761.53 4203417.44, 1913740.98 4203367.3, 1913715.56 4203323.33, 1913694.32 4203250.41, 1913686.33 4203220.19, 1913683.33 4203183.89, 1913681.26 4203183.82, 1913560.00143127 4203224.01, 1913513.7 4203239.48, 1913383.59 4203282.8, 1913377.94 4203286.11, 1913349.79 4203292.66, 1913321.1 4203304.32, 1913280.03 4203319.2, 1913245.26 4203324.76, 1913203.93 4203339.38, 1913183.75 4203344.39, 1913158.56 4203342.2, 1913136.68 4203343.45, 1913097.5 4203357.75, 1913047.8 4203346.6, 1913004.31 4203335.06, 1912890.29 4203338.98, 1912848.78 4203345.23, 1912795.61 4203359.93, 1912790.57 4203361.33, 1912792.06 4203370.2, 1912786.92 4203371.24, 1912722.68 4203385.04, 1912703.73 4203390.81, 1912684.09 4203401.05, 1912668.23 4203407.16, 1912663.9 4203413.16, 1912658.91 4203416.38, 1912648.97 4203418.79, 1912639.35 4203421.36, 1912623.81 4203431.93, 1912603.92 4203436.22))'::geometry,'38277','Notre-Dame-de-Commiers','NOTRE-DAME-<br>DE-COMMIERS','NDC','NDC'),
     (27,'SRID=3945;POLYGON ((1915937.5987575348 4212895.405289037, 1915953.2681366869 4212894.789581648, 1915964.4911361448 4212895.1083192, 1915971.7468410383 4212894.063485566, 1916028.3783100427 4212885.953897968, 1916094.0417785773 4212885.099781719, 1916299.2185876206 4212945.332080788, 1916394.16443529 4212976.45314557, 1916494.2792402138 4212998.968606492, 1916556.2714081202 4213021.5105309775, 1916658.2579085832 4213054.2326707095, 1916726.2162796026 4213082.638714511, 1916799.4247397722 4213116.550748678, 1916815.252080836 4213123.884735799, 1916830.925791745 4213130.432903595, 1916846.3462276012 4213136.143120614, 1916852.1117497867 4213138.550551842, 1916852.56 4213136.56, 1916855.7642205416 4213124.635896839, 1916918.3367959398 4213130.365489323, 1916950.76 4213110.845, 1916975.075 4213090.57, 1917043.401939098 4213038.118735038, 1917106.166264962 4212996.266264962, 1917190.3576314268 4212952.848448721, 1917229.2213470708 4212932.74420405, 1917252.1514679682 4212925.115632481, 1917310.7463209068 4212918.252486121, 1917328.525 4212912.455, 1917362.969512479 4212872.905950658, 1917372.6533734514 4212861.623663288, 1917398.9092062365 4212835.938522131, 1917421.9139443375 4212822.908111566, 1917439.7103374812 4212815.178292065, 1917450.174836333 4212809.351365453, 1917467.3698990692 4212800.437793408, 1917518.1690936838 4212781.975830077, 1917534.1123930695 4212770.127704972, 1917560.756061956 4212746.465918797, 1917604.7611261427 4212703.972174427, 1917655.263071254 4212639.186052784, 1917661.3717568354 4212630.178140517, 1917682.6836270313 4212596.7819172945, 1917690.7038108062 4212582.506643486, 1917706.3172852625 4212554.755490051, 1917714.7149136686 4212529.161158921, 1917718.2314136461 4212515.319317174, 1917720.1192951214 4212503.002191565, 1917721.951000913 4212472.014627375, 1917722.04783255 4212436.275339028, 1917715.6670668747 4212396.706561126, 1917708.97 4212372.474755338, 1917658.3490590362 4212219.3897611415, 1917638.3829981384 4212161.0005057845, 1917526.2680925971 4211782.124520964, 1917491.5703896761 4211669.575602227, 1917453.40354251 4211546.459554656, 1917450.0090582648 4211523.525871714, 1917441.8191911243 4211470.55471499, 1917420.400921448 4211365.437230155, 1917418.2096893631 4211353.989674808, 1917411.4036822096 4211304.98337015, 1917407.445260404 4211273.50367775, 1917403.0935051665 4211237.736240221, 1917399.823952429 4211185.989569838, 1917399.4582340596 4211172.761250614, 1917398.5525319988 4211155.138869235, 1917398.7780302446 4211124.88981608, 1917400.5034976695 4211054.490956929, 1917403.7681658722 4210997.199853728, 1917408.8807189697 4210935.658564156, 1917411.909171109 4210900.760208864, 1917417.1169849643 4210857.506059014, 1917421.5949727406 4210823.312822807, 1917429.689374958 4210765.020393114, 1917433.161710338 4210750.5117183775, 1917437.8815749488 4210737.546980819, 1917477.8750893418 4210688.077703637, 1917492.5684970117 4210656.80299168, 1917494.711088064 4210650.5924545145, 1917498.3492967556 4210639.627420884, 1917487.2546441383 4210632.026380835, 1917456.7009836114 4210623.311359472, 1917385.985972318 4210604.115941033, 1917379.7854065346 4210600.873171195, 1917375.6366623591 4210597.825586499, 1917363.1193685497 4210588.396696428, 1917333.8322289754 4210561.0077985795, 1917282.9786520281 4210514.620063135, 1917224.6835141177 4210464.316644859, 1917149.7715804493 4210411.707345395, 1917119.68 4210391.869325863, 1917087.9774872444 4210373.631651514, 1917041.937518855 4210347.941856909, 1916992.7723089345 4210311.566128157, 1916983.705429111 4210300.382276138, 1916980.5402848958 4210297.033675016, 1916976.94796517 4210291.604141292, 1916964.9850763408 4210275.139228156, 1916940.3351385174 4210239.8367762, 1916924.2045308966 4210219.63397678, 1916920.4669638006 4210215.005657643, 1916917.1669923991 4210211.685879574, 1916905.782330952 4210203.672267947, 1916891.7079987389 4210196.799382058, 1916882.6192849786 4210187.016379748, 1916877.9140445665 4210178.606764974, 1916870.214096503 4210168.436468706, 1916860.6723101577 4210150.852189799, 1916841.9772066616 4210130.469329633, 1916824.8892224655 4210117.316210156, 1916807.9493046228 4210109.795624713, 1916807.2884283776 4210111.485942803, 1916806.7312581562 4210112.911012793, 1916792.3366234037 4210108.527476939, 1916783.8395515103 4210106.593738232, 1916747.9718096433 4210100.432259793, 1916727.0418786984 4210092.617915177, 1916706.389768804 4210087.725317047, 1916693.7670589741 4210082.407538312, 1916649.658935704 4210060.30505953, 1916643.4241234662 4210057.598326648, 1916635.7377575897 4210055.895302596, 1916621.4475553434 4210054.957332423, 1916574.858969935 4210055.509260119, 1916544.0668883973 4210052.284718997, 1916529.05372157 4210050.503098684, 1916509.6164512783 4210047.197871847, 1916488.9601365936 4210042.634475425, 1916479.1266610054 4210040.374387108, 1916451.2497770824 4210034.604310583, 1916432.6695030914 4210033.433423155, 1916421.4171149782 4210032.3304944495, 1916409.4193396922 4210028.936457137, 1916408.6422191295 4210028.76767211, 1916407.636704882 4210028.831307346, 1916373.2622505354 4210032.658953887, 1916349.3304564736 4210034.130041565, 1916333.4942240217 4210033.506910012, 1916311.78502316 4210031.344854432, 1916291.8271061678 4210027.866831686, 1916273.2682477406 4210025.063196376, 1916265.975416395 4210023.55857012, 1916253.6521971168 4210094.639931593, 1916213.2055049061 4210164.907487663, 1916203.6305324603 4210176.628014137, 1916191.060375535 4210183.80163956, 1916186.03 4210185.45, 1916185.441810547 4210184.466245976, 1916180.6264377306 4210186.862694642, 1916115.503060645 4210073.34458864, 1916067.7475748763 4209991.294132424, 1916000.9732045068 4209876.500093379, 1915981.5417734543 4209842.751393444, 1915979.8385316706 4209838.861380579, 1915969.5003642398 4209820.968422598, 1915965.0230038748 4209813.218853433, 1915917.252876259 4209731.825763393, 1915805.7830648352 4209539.973882859, 1915582.857793721 4209162.175689034, 1915574.4863562754 4209158.136437247, 1915562.7707430802 4209182.650235564, 1915513.9852388275 4209413.659042566, 1915508.1093005755 4209422.410531209, 1915505.633068048 4209438.393394791, 1915494.0263573688 4209443.385346165, 1915498.9365582673 4209510.2367457505, 1915494.6530101504 4209565.834672028, 1915483.3170106057 4209639.007355639, 1915489.036175547 4209712.301785963, 1915545.67679594 4209824.365766543, 1915577.4989796996 4209869.785318876, 1915639.0169516373 4210032.930530074, 1915653.6686933828 4210058.494039548, 1915668.871491627 4210095.375326432, 1915699.6837857896 4210144.855683233, 1915727.0005726332 4210185.2626639865, 1915758.025429475 4210248.75179594, 1915803.8856902234 4210297.231950334, 1915913.9060203005 4210400.441551278, 1916001.7387441343 4210483.634030451, 1916024.2444678152 4210534.002716164, 1916038.8312233065 4210561.1655908255, 1916035.2540812027 4210585.936071053, 1916038.473334223 4210622.0828986745, 1916041.7306959566 4210632.660698379, 1916047.7393535527 4210641.760704164, 1916057.109570525 4210677.229907593, 1916046.6239567157 4210732.509023094, 1916020.1625503928 4210808.023928752, 1915997.7699075933 4210902.857479173, 1915974.9012936945 4210948.875182796, 1915976.9689594153 4211025.197698941, 1915972.6052446614 4211058.552571579, 1915970.7753515972 4211095.594064415, 1915966.5138877507 4211121.776573747, 1915973.7555865445 4211141.482566352, 1915977.7102034464 4211175.370460926, 1915988.1917477963 4211189.818559569, 1915992.7999075935 4211200.412816242, 1915987.0401087506 4211240.571525973, 1916000.7601074798 4211289.792197548, 1916002.9154694255 4211298.50476654, 1916000.3975026791 4211309.406183558, 1916008.009007284 4211339.627767088, 1916015.2194182705 4211359.94038782, 1916043.8395051507 4211417.622764101, 1916046.7977054892 4211438.308455661, 1916053.188339722 4211455.482094433, 1916054.7143766154 4211463.4453461645, 1916048.6703701958 4211485.499674802, 1916036.9843558117 4211488.471370157, 1916026.416915826 4211491.60969278, 1916019.000762831 4211496.005095854, 1916016.2734462048 4211514.352936487, 1916035.0548228407 4211544.941995582, 1916038.3684169068 4211549.558887478, 1916046.561765362 4211556.478815456, 1916057.2076957298 4211565.694876003, 1916062.0941794794 4211572.665295502, 1916067.4020694762 4211580.8708008425, 1916069.6791267681 4211589.133739581, 1916076.6226496724 4211606.502941947, 1916077.1764242991 4211616.286680872, 1916071.0738117867 4211636.253842079, 1916060.5135972244 4211649.412979181, 1916048.0136039678 4211661.549360746, 1916036.695739822 4211676.696099885, 1916027.758550156 4211687.158243778, 1916035.8973538214 4211721.488815608, 1916028.632158354 4211742.19588253, 1916005.420092407 4211752.721694437, 1915942.2246121801 4211820.4525806755, 1915918.855101503 4211838.093938043, 1915895.7590812026 4211852.92679594, 1915887.407234511 4211871.13378579, 1915882.878836541 4211896.584173609, 1915880.5550507514 4211923.747571579, 1915884.8134487213 4211950.707959399, 1915888.256264962 4211980.027091353, 1915902.175 4212023.415, 1915919.7076730824 4212069.858600976, 1915910.8340304508 4212084.386897442, 1915911.6920406013 4212101.20422436, 1915931.230359346 4212153.524386304, 1915953.6575737274 4212233.4701605085, 1915960.1971837594 4212263.405775639, 1915963.98574453 4212288.229894072, 1915980.359662932 4212314.780978645, 1915982.7484994729 4212339.589898497, 1915974.5732058648 4212372.693337026, 1915964.4566527817 4212407.467479172, 1915967.727866992 4212471.3860203, 1915976.1421685505 4212514.022630712, 1915988.7710966861 4212551.200405299, 1916021.9479715372 4212609.207707258, 1916041.2723581782 4212637.86360711, 1916046.3972852626 4212650.202866992, 1916044.418499473 4212682.770826391, 1916036.0626223306 4212704.085632481, 1916043.4509369852 4212716.149750236, 1916049.5726616166 4212718.09141979, 1916079.371071052 4212715.536071052, 1916087.62 4212719.11, 1916096.627731136 4212723.890328964, 1916101.86 4212728.75218376, 1916136.4151569125 4212748.555110737, 1916145.9256415772 4212755.690877142, 1916136.0818881725 4212757.597793351, 1916116.5230192463 4212756.413448722, 1916101.960326531 4212760.178832182, 1916096.1921102433 4212766.361673337, 1916112.922544261 4212777.964922656, 1916124.3669565602 4212790.985630793, 1916103.3649030451 4212792.473014698, 1916079.285771091 4212801.343208608, 1916038.851201039 4212822.831525738, 1916019.0795319006 4212825.416054624, 1916010.686861064 4212826.318434593, 1915999.115003984 4212826.935780551, 1915980.198602088 4212827.584233283, 1915973.25 4212825.95, 1915958.86 4212827.53, 1915936.73 4212832.98, 1915917.46 4212841.68, 1915937.5987575348 4212895.405289037))'::geometry,'38279','Notre-Dame-de-Mésage','NOTRE-DAME-<br>DE-MÉSAGE','NDM','NDM'),
     (48,'SRID=3945;POLYGON ((1908291.0541497988 4230413.444645751, 1908330.7035123156 4230342.631408618, 1908382.9450917789 4230248.375738595, 1908428.7814565604 4230165.891765808, 1908426.239855545 4230164.311923813, 1908694.7857814815 4229682.89232171, 1908738.259227447 4229605.829076593, 1908821.6752989783 4229457.333158917, 1908847.4601151107 4229411.426806044, 1908850.1136642536 4229406.732573832, 1908850.09 4229406.72, 1908850.0597071676 4229406.703783068, 1908849.9173505155 4229406.693740126, 1908839.8476829573 4229401.311341126, 1908834.044334114 4229398.200163137, 1908825.9420708024 4229393.869130276, 1908820.5135569377 4229390.95422523, 1908814.2885505229 4229387.609157047, 1908808.9970596624 4229384.76052878, 1908802.481112976 4229381.258084301, 1908796.6306032806 4229378.121320845, 1908790.581622547 4229374.845204445, 1908778.6552284458 4229368.471626096, 1908773.3986849852 4229365.643210091, 1908765.010986789 4229361.170097098, 1908746.839287988 4229351.558194021, 1908739.8263413503 4229347.832682213, 1908733.0622780004 4229344.271503507, 1908731.1078433217 4229343.24264017, 1908730.1894026916 4229342.75937656, 1908729.487320638 4229342.390434177, 1908728.586087878 4229341.915944214, 1908728.1231106252 4229341.672272312, 1908727.7210618602 4229341.460602448, 1908727.6110832994 4229341.4027254805, 1908727.5618444819 4229341.376792419, 1908727.5359074348 4229341.363150144, 1908727.5137354594 4229341.351477605, 1908727.4838993046 4229341.3357776115, 1908716.2799039148 4229335.439968415, 1908627.2321796294 4229288.390567441, 1908572.3010390804 4229259.364457494, 1908554.3824546896 4229249.920366726, 1908500.0461228578 4229221.329525545, 1908492.4789824581 4229217.347547328, 1908481.3825159587 4229211.510564348, 1908469.1882795182 4229205.091609879, 1908464.001538763 4229202.363668737, 1908460.3689911298 4229200.451380317, 1908457.9839934306 4229199.197089381, 1908455.591272541 4229197.93794285, 1908453.3360394347 4229196.751004839, 1908452.3463746803 4229196.230226069, 1908451.2636078787 4229195.660284048, 1908450.7069906003 4229195.367326117, 1908450.471979619 4229195.2437009355, 1908450.2634470128 4229195.1338928845, 1908450.1530971262 4229195.075834301, 1908450.0840571718 4229195.039480313, 1908450.0366934412 4229195.0145672625, 1908449.989461913 4229194.989700659, 1908449.962563926 4229194.975542349, 1908449.9008212523 4229194.943048948, 1908449.8875561296 4229194.936067227, 1908449.8872783487 4229194.935921057, 1908417.8848514985 4229178.088507585, 1908388.355906122 4229162.590075047, 1908340.2660015572 4229137.429470798, 1908322.801726728 4229128.279575349, 1908299.748266985 4229116.075788724, 1908292.9692688698 4229112.680031602, 1908274.5620080326 4229102.730931042, 1908263.3962393033 4229096.740626883, 1908252.7337057856 4229091.022118898, 1908246.7674701528 4229087.8270029565, 1908232.498380288 4229080.064435594, 1908221.1780674497 4229073.91917588, 1908217.457789384 4229071.898428145, 1908207.0875388994 4229066.29052697, 1908207.0873828141 4229066.290443133, 1908207.0872935497 4229066.290395209, 1908207.0872007117 4229066.290345263, 1908207.0870916855 4229066.29028668, 1908207.0868873317 4229066.290177108, 1908207.0865454664 4229066.289993382, 1908207.0859947393 4229066.289697113, 1908207.0854981183 4229066.289431659, 1908207.0845301643 4229066.288910898, 1908207.082558543 4229066.287851307, 1908207.0811833984 4229066.287114506, 1908207.0777892263 4229066.285286569, 1908207.0749108067 4229066.2837432455, 1908207.0702657562 4229066.281245465, 1908207.0611845772 4229066.276357458, 1908207.0503747107 4229066.270582586, 1908207.040295208 4229066.265138019, 1908207.0170881506 4229066.252717987, 1908206.9900575052 4229066.238216692, 1908206.926292579 4229066.2038876135, 1908206.8042739818 4229066.1383386925, 1908206.6586370738 4229066.0602143295, 1908206.5066005362 4229065.978938933, 1908206.2216623633 4229065.8256349685, 1908205.7725858171 4229065.584407832, 1908204.9492294227 4229065.140680084, 1908203.7877300684 4229064.519149881, 1908201.8409625057 4229063.474773122, 1908198.1421778963 4229061.490911833, 1908138.5666784872 4229029.405728768, 1908086.9350233607 4229001.596042095, 1908081.7083086253 4228998.725971637, 1908074.478902779 4228994.683358508, 1908051.2116550447 4228981.511679931, 1908027.8601019753 4228968.339105995, 1908020.4556846712 4228964.148974992, 1908018.4609106972 4228963.019274833, 1907997.4033219493 4228951.148095868, 1907983.4982063791 4228943.3178376155, 1907982.638783392 4228942.824765648, 1907982.1526461993 4228942.5463919835, 1907978.8403338932 4228940.649000157, 1907973.9465202373 4228937.854217956, 1907967.706023315 4228935.161098397, 1907967.5754368945 4228935.104563107, 1907967.5002248976 4228935.072022987, 1907961.7357043622 4228932.6243651025, 1907935.6321128488 4228918.905774407, 1907927.3133789198 4228914.484388655, 1907923.6757355765 4228912.552174926, 1907915.6092729133 4228908.324119302, 1907912.0457266325 4228906.471868144, 1907911.4854186669 4228906.18066223, 1907911.4841212255 4228906.179986968, 1907911.4812838917 4228906.178513654, 1907911.4793687256 4228906.177523945, 1907911.4764426635 4228906.176004115, 1907911.4700595574 4228906.172673852, 1907911.4425975832 4228906.158402133, 1907911.362358909 4228906.116821981, 1907911.2848201673 4228906.076374298, 1907911.1854962353 4228906.024892925, 1907910.9999162087 4228905.928481647, 1907910.7565012304 4228905.802232543, 1907910.500416022 4228905.6686659455, 1907909.776006837 4228905.291661526, 1907908.8407268822 4228904.80532158, 1907905.8319974248 4228903.24395356, 1907896.2540732224 4228898.240001316, 1907885.982475795 4228892.831669383, 1907884.8097923335 4228892.016883123, 1907787.8967983637 4228838.470512143, 1907785.2919198498 4228837.224454808, 1907784.9917189947 4228840.1764298845, 1907781.9874945336 4228842.962000152, 1907781.2715491522 4228848.126082367, 1907776.3093996637 4228857.527221478, 1907751.833785534 4228881.242866083, 1907744.842354314 4228887.317124998, 1907719.382852509 4228908.311911898, 1907707.7052100135 4228917.95766881, 1907700.7266799533 4228923.179143349, 1907688.3901455738 4228932.347399609, 1907688.7008615024 4228932.75146367, 1907690.8381146777 4228939.714818043, 1907688.9877023061 4228943.124103038, 1907688.4635338427 4228944.432361525, 1907671.1116181768 4228963.804817663, 1907671.1533986058 4228963.922034978, 1907670.815544505 4228975.604366793, 1907654.5587139716 4228993.628525014, 1907651.4665634106 4228997.5873027975, 1907631.592619693 4229024.074482022, 1907629.6625000779 4229025.328750031, 1907513.2624744647 4228934.8770862315, 1907514.9685677313 4228920.882529833, 1907436.0749999916 4228871.593749962, 1907387.0987499997 4228840.832499974, 1907339.2127831464 4228810.665533335, 1907243.0375000015 4228750.077499953, 1907199.6893814225 4228723.033770054, 1907067.9072186833 4228640.818409122, 1906988.4425000062 4228591.242499973, 1906957.086701788 4228571.51853741, 1906912.400650728 4228543.409350329, 1906725.7275000191 4228425.984999961, 1906625.7549999955 4228362.057500002, 1906581.4756376387 4228331.063117401, 1906574.936447359 4228311.190627515, 1906549.686912968 4228283.52211545, 1906490.7105875204 4228257.005765009, 1906428.6574999143 4228217.005000039, 1906345.2324999112 4228134.027499977, 1906289.6874999988 4228070.037500022, 1906191.6694418911 4228000.947647354, 1906105.520000002 4227944.984999993, 1906064.7776469947 4227916.205220566, 1906062.86 4227917.43, 1906060.51 4227917.41, 1906055.89 4227917.4, 1906044.98 4227918.49, 1906041.15 4227919.62, 1906039.38 4227920.38, 1906038.71 4227920.68, 1906033.49 4227926.56, 1906019.33 4227914.32, 1906014.59 4227910.89, 1906012.64 4227910.44, 1906008.98 4227909.83, 1905994.33 4227912.88, 1905982.79 4227910.97, 1905980.31 4227910.56, 1905972.985 4227908.875, 1905963.44 4227907.27, 1905958.68 4227897.9, 1905949.15 4227878.18, 1905957.7415494137 4227863.670171044, 1905960.27 4227859.4, 1905957.68 4227837.99, 1905955.88 4227817.04, 1905963.22 4227763.96, 1905964.09 4227750.92, 1905963.5 4227743.95, 1905956.94 4227713.71, 1905954.3 4227698.25, 1905956.54 4227678.9, 1905958.65 4227662.56, 1905939.37 4227641.11, 1905928.87 4227629.93, 1905919.53 4227626.58, 1905918.58 4227626.25, 1905917.56 4227626.5, 1905916.25 4227626.81, 1905914.54 4227629.24, 1905913.17 4227631.55, 1905911.59 4227632.93, 1905908.92 4227634.19, 1905905.63 4227634.93, 1905903.39 4227635.3, 1905900.41 4227635.52, 1905897.34 4227634.35, 1905892.44 4227632.17, 1905884.52 4227636.97, 1905881.67 4227635.6, 1905879.96 4227640.82, 1905866.21 4227653.98, 1905858.84 4227660.85, 1905843.8 4227656.39, 1905838.12 4227648.29, 1905829.93 4227651.62, 1905814.55 4227657.62, 1905806.62 4227660.24, 1905795.28 4227662.92, 1905781.83 4227665.18, 1905776.86 4227665.56, 1905766.45 4227664.37, 1905763.26 4227664.13, 1905756.01 4227664.96, 1905744.37 4227666.29, 1905742.41 4227666.85, 1905732.93 4227671.77, 1905711.2 4227683.53, 1905700.59 4227688.95, 1905697.94 4227689.82, 1905677.98 4227697.61, 1905670.07 4227700.77, 1905663.2 4227703.23, 1905643.83 4227709.31, 1905638.84 4227710.92, 1905626.13 4227715.41, 1905626.91 4227728.5, 1905622.87 4227730.7, 1905616.4 4227734.03, 1905613.56 4227735.35, 1905609.28 4227738.47, 1905605.44 4227741.66, 1905596.99 4227750.03, 1905590.99 4227756.36, 1905584.55 4227761.56, 1905574.23 4227768.71, 1905569.88 4227773.05, 1905566.3 4227781.95, 1905565.56 4227783.77, 1905555.98 4227805.85, 1905553.32 4227810.57, 1905551.65 4227812.2, 1905541.66 4227817.46, 1905525.16 4227825.74, 1905522.86 4227827.12, 1905521.39 4227828.44, 1905519.8 4227836.74, 1905519.68 4227840.34, 1905520.61 4227852.91, 1905521.37 4227860.56, 1905521.56 4227865.81, 1905521.35 4227867.5, 1905520.38 4227869.82, 1905519.06 4227871.96, 1905516.49 4227875.08, 1905512.75 4227879.27, 1905506.21 4227885.09, 1905499.66 4227889.74, 1905487.02 4227900.7, 1905483.33 4227904.78, 1905477.93 4227912.35, 1905466.02 4227929.96, 1905453.06 4227949.66, 1905439.48 4227968.75, 1905435.86 4227973.94, 1905417.58 4227990.55, 1905410.74 4227996.56, 1905381.98 4228005.21, 1905367.68 4228009.49, 1905361.63 4228006.38, 1905354.3 4228018.3, 1905346.07 4228032.18, 1905349.57 4228044.5, 1905345.5 4228051.92, 1905334.72 4228071.47, 1905333.13 4228075.19, 1905332.74 4228076.22, 1905332.44 4228077.01, 1905330.93 4228084.53, 1905330.09 4228088.44, 1905328 4228090.37, 1905322.69 4228094.6, 1905311.75 4228098.31, 1905309.71 4228099.08, 1905308.93 4228099.92, 1905304.78 4228104.43, 1905298.49 4228106.33, 1905293.65 4228107.96, 1905287.49 4228111.76, 1905281.24 4228116.29, 1905277.76 4228118.8, 1905265.71 4228128.06, 1905255.88 4228127.75, 1905244.23 4228127, 1905237.72 4228131.81, 1905228.09 4228139.01, 1905222.05 4228139.44, 1905218.44 4228139.71, 1905214.93 4228140.21, 1905205.88 4228144.06, 1905203.96 4228145.1, 1905196.23 4228139.09, 1905192.38 4228135.87, 1905181.49 4228125.09, 1905179.31 4228122.81, 1905175.31 4228120.14, 1905149.43 4228121.7, 1905128.15 4228122.62, 1905101.77 4228106.17, 1905082.49 4228094.34, 1905077.48 4228100.55, 1905063.83 4228118.05, 1905057.49 4228114.75, 1905052.47 4228112.39, 1905035.98 4228105.36, 1905034.11 4228100.52, 1905031.9 4228095.49, 1905029.25 4228093.03, 1905024.54 4228089.47, 1905012.13 4228081.32, 1905008.1 4228079.33, 1905003.78 4228077.08, 1904990.56 4228070.2, 1904989.87 4228065.98, 1904989.89 4228060.66, 1904988.97 4228057.11, 1904986.75 4228052.17, 1904982.76 4228043, 1904985.38 4228034.01, 1904982.2 4228031.63, 1904978.34 4228027.68, 1904977.7 4228026.06, 1904973.38 4228010.16, 1904972.37 4228007.51, 1904965.93 4227996.88, 1904973.17 4227992.23, 1904988.46 4227982.38, 1904987.77 4227978.64, 1904985.58 4227970.94, 1904985.05 4227966.29, 1904987.18 4227960.63, 1904983.83 4227959.42, 1904980.56 4227958.17, 1904979.39 4227956.99, 1904976.45 4227947.29, 1904971.25 4227943, 1904968.43 4227940.36, 1904962.58 4227935.13, 1904958.15 4227931.57, 1904955.27 4227930.46, 1904945.14 4227926.02, 1904944.92 4227923.7, 1904944.1 4227916.06, 1904943.23 4227908.13, 1904942.93 4227904.53, 1904941.69 4227901.86, 1904938.66 4227898.65, 1904937.42 4227897.9, 1904936.54 4227899.61, 1904935.3 4227902.05, 1904932.26 4227908.04, 1904922.39 4227911, 1904920.91 4227917.36, 1904915.97 4227944.46, 1904912.49 4227964.87, 1904911.66 4227987.87, 1904911.31 4228001.35, 1904915.99 4228011.16, 1904917.04 4228015.28, 1904918.7 4228022.56, 1904919.67 4228029.96, 1904920.81 4228043.99, 1904920.64 4228051.63, 1904918.2 4228060.23, 1904913.85 4228073.57, 1904912.4 4228082.45, 1904910.48 4228092.67, 1904903.34 4228106.3, 1904859.72 4228133.05, 1904821.91 4228156, 1904809.36 4228163.35, 1904804.17 4228168.21, 1904780.49 4228191.72, 1904754.5 4228217.22, 1904747.59 4228224.3, 1904731.01 4228238.19, 1904704.07 4228265.77, 1904687.58 4228282.74, 1904673.72 4228296.43, 1904647.02 4228321.22, 1904635 4228330.97, 1904604.79 4228356.51, 1904596.45 4228363.11, 1904596.34 4228368.91, 1904595.51 4228378.48, 1904593.07 4228386.62, 1904587.64 4228403.87, 1904580.29 4228425.94, 1904577.51 4228433.22, 1904575.06 4228439.72, 1904567.13 4228455.48, 1904562.33 4228465.07, 1904558.06 4228471.66, 1904552.75 4228479.61, 1904543.71 4228484.65, 1904535.32 4228489.64, 1904522.42 4228496.12, 1904505.76 4228504.74, 1904490.65 4228514.14, 1904487.01 4228517.61, 1904483.54 4228521.96, 1904474.82 4228530.96, 1904468.67 4228535, 1904455.37 4228542.28, 1904442.75 4228549.84, 1904436.52 4228556.44, 1904432.25 4228560.87, 1904421.13 4228570.03, 1904410.44 4228579.04, 1904393.01 4228593.22, 1904385.43 4228598.92, 1904381.68 4228604.75, 1904380.08 4228607.69, 1904374.26 4228617, 1904362.49 4228637.32, 1904354.98 4228651.01, 1904350.61 4228662.31, 1904348.15 4228669.63, 1904347.92 4228670.29, 1904346.31 4228674.57, 1904344.8 4228679.4, 1904338.92 4228696.05, 1904336.51 4228703.89, 1904334.97 4228708.27, 1904331.8 4228717.1, 1904329 4228727.13, 1904328.96 4228730.83, 1904330.65 4228737.99, 1904332.26 4228742.86, 1904332.86 4228746.63, 1904333.35 4228749.7, 1904327.01 4228757.42, 1904325.36 4228759.42, 1904323.55 4228763.53, 1904323.36 4228764.17, 1904321.99 4228768.86, 1904320.48 4228774.05, 1904313 4228789.55, 1904306.34 4228804.72, 1904305.9 4228807.69, 1904302.14 4228835.23, 1904301.06 4228841.41, 1904300.57 4228844.19, 1904299.37 4228848.28, 1904295.41 4228859.07, 1904294.99 4228860.09, 1904293.37 4228864.04, 1904291.59 4228869.4, 1904289.39 4228874.72, 1904288.52 4228876.93, 1904286.98 4228880.84, 1904284.82 4228884.34, 1904278.57 4228891.35, 1904276.78 4228893.74, 1904273.8 4228897.74, 1904270.05 4228903.14, 1904267.89 4228908.64, 1904262.12 4228920.21, 1904256.91 4228930.13, 1904251.29 4228939.91, 1904238.38 4228963.13, 1904230.26 4228979.7, 1904228.51 4228984.65, 1904228.79 4228986.87, 1904230.04 4228990.6, 1904232.58 4228994.39, 1904235.37 4228999.07, 1904235.87 4229002.27, 1904236.02 4229006.26, 1904235.17 4229009.36, 1904233.7 4229013.09, 1904232.24 4229017, 1904231.3 4229019.85, 1904241.94 4229027.25, 1904241.99 4229029.1, 1904240.66 4229036.85, 1904235.96 4229049.66, 1904231.36 4229062.28, 1904229.92 4229066.23, 1904224.03 4229080.84, 1904218.96 4229087.96, 1904208.31 4229103.09, 1904197.23 4229098.11, 1904191.78 4229099.77, 1904183.34 4229115.42, 1904177.69 4229126.68, 1904172.19 4229127.2, 1904167.31 4229127.76, 1904162.28 4229131.43, 1904157.21 4229133.41, 1904153.54 4229134.95, 1904148.98 4229138.36, 1904141.45 4229136.48, 1904129.82 4229133.8, 1904123.93 4229148.3, 1904124.19 4229153.77, 1904123.95 4229156.09, 1904119.47 4229167.08, 1904115.52 4229167.56, 1904108.38 4229171.06, 1904110.84 4229179.4, 1904104.07 4229183.52, 1904100.14 4229185.05, 1904087.78 4229189.54, 1904086.83 4229197.64, 1904084.79 4229219.65, 1904083.1 4229226.14, 1904079.55 4229238.45, 1904074.71 4229256.32, 1904070.61 4229265.48, 1904066.2 4229275.68, 1904059.36 4229292.29, 1904055.18 4229301.38, 1904050.71 4229305.02, 1904047.64 4229308.07, 1904044.04 4229312.08, 1904041.62 4229315.96, 1904041.21 4229320.87, 1904039.85 4229323.42, 1904035.44 4229327.04, 1904028.49 4229329.4, 1904025.85 4229331.85, 1904018.67 4229338.22, 1904014.42 4229341.26, 1903992.38 4229344.03, 1903985.85 4229344.89, 1903985.03 4229345.01, 1903983.11 4229349.94, 1903973.81 4229370.07, 1903969.18 4229380.84, 1903963.13 4229393.28, 1903959.36 4229399.56, 1903955.01 4229401.71, 1903947.13 4229406.04, 1903940.02 4229409.69, 1903933.36 4229412.18, 1903920.24 4229416.55, 1903905.17 4229421.11, 1903895.48 4229423.99, 1903883.84 4229424.89, 1903871.35 4229425.46, 1903868.03 4229425.54, 1903861.38 4229428.35, 1903849.83 4229433.23, 1903843.51 4229434.91, 1903835.12 4229436.71, 1903825.27 4229437.37, 1903812.47 4229437.09, 1903803.59 4229436.94, 1903797.03 4229438.37, 1903783.95 4229440.56, 1903777.11 4229433.63, 1903770.56 4229427.04, 1903768.17 4229425.09, 1903765.48 4229423.6, 1903762.06 4229422.54, 1903753.81 4229427.25, 1903749.18 4229430.66, 1903743.97 4229434.27, 1903739.37 4229436.61, 1903733.43 4229439.29, 1903728.62 4229440.84, 1903721.15 4229440.17, 1903720.14 4229440.32, 1903716.33 4229443.74, 1903713.01 4229446.37, 1903709.05 4229449.19, 1903706.35 4229449.87, 1903693.11 4229449.21, 1903688.29 4229448.53, 1903684.9 4229448.81, 1903676.56 4229449.28, 1903668.25 4229449.23, 1903665.43 4229447.23, 1903660.36 4229443.73, 1903657.43 4229441.15, 1903655.17 4229435.05, 1903653.15 4229434.44, 1903645.75 4229434.58, 1903633.13 4229436.57, 1903625.09 4229438.98, 1903616.27 4229442.18, 1903608.88 4229445.24, 1903602.81 4229447.77, 1903598.21 4229450.79, 1903589.29 4229457.03, 1903581.72 4229461.49, 1903571.26 4229462.58, 1903558.55 4229472.8, 1903553.71 4229476.83, 1903544.17 4229483.37, 1903538.2 4229487.88, 1903529.43 4229485.13, 1903522.87 4229491.72, 1903517.75 4229499.38, 1903511.41 4229507.78, 1903505.22 4229515.37, 1903494.69 4229520.15, 1903483.27 4229525.11, 1903480.56 4229524.98, 1903476.83 4229525.55, 1903474.64 4229525.97, 1903471.15 4229527.21, 1903463.09 4229532.1, 1903458.29 4229535.33, 1903450.04 4229540.87, 1903445.14 4229543.99, 1903434.38 4229548.53, 1903427.54 4229551.47, 1903424.8 4229552.89, 1903421.47 4229554.9, 1903418.87 4229558, 1903413.04 4229564.76, 1903405.81 4229572.33, 1903401.41 4229575.02, 1903389.57 4229582.09, 1903380.15 4229587.58, 1903374.32 4229591.7, 1903369.96 4229595.16, 1903359.78 4229600.24, 1903349.12 4229605.08, 1903336.6 4229611.02, 1903326.77 4229616.21, 1903322.58 4229618.48, 1903316.15 4229621.05, 1903304.81 4229632.86, 1903297.69 4229639.83, 1903294.84 4229642.25, 1903293.41 4229643.86, 1903290.5 4229650.62, 1903279.97 4229670.5, 1903273.92 4229681.67, 1903267.58 4229690.49, 1903266.61 4229691.45, 1903263.04 4229694.04, 1903256.25 4229698.88, 1903248.06 4229705.33, 1903238.16 4229726.46, 1903233.13 4229735.7, 1903231.28 4229738.56, 1903216.8 4229756.56, 1903202.99 4229765.18, 1903197.72 4229769.12, 1903193.21 4229774.01, 1903185.82 4229783.14, 1903172.94 4229798.8, 1903171.35 4229800.34, 1903170.38 4229800.53, 1903163.92 4229801.56, 1903160.03 4229819.54, 1903154.65 4229842.12, 1903149.46 4229850.37, 1903143.16 4229860.3, 1903138.14 4229867.08, 1903133.34 4229873.12, 1903130.61 4229876.97, 1903128.06 4229879.81, 1903114.71 4229892.37, 1903111.72 4229895.08, 1903094.3 4229905.26, 1903085.25 4229924.5, 1903084.27 4229927.68, 1903078.93 4229946.58, 1903076.7 4229958.13, 1903074.22 4229973.06, 1903073.2 4229978.59, 1903076.86 4229987.41, 1903073.65 4230008.83, 1903070.43 4230028.8, 1903068.42 4230042.12, 1903065.23 4230055.6, 1903060.4818730052 4230072.182411102, 1903058.721491809 4230078.3303858135, 1903057.1787896017 4230083.718136023, 1903055.706736277 4230088.859151294, 1903051.34 4230093.3, 1903049.46 4230094.77, 1903047.85 4230097, 1903044.33 4230105.22, 1903032.29 4230133.03, 1903019.64 4230161.21, 1903012.68 4230176.48, 1903005.6 4230192.78, 1902997.67 4230209.62, 1902992.47 4230220.8, 1902985.79 4230229.25, 1902977.13 4230240.75, 1902967.88 4230252.64, 1902964.86 4230251.33, 1902953.88 4230246.31, 1902946.56 4230257.35, 1902939 4230269.44, 1902937.67 4230271.95, 1902931.05 4230285.14, 1902927.73 4230290.74, 1902922.25 4230299.04, 1902920.71 4230301.25, 1902912.3 4230308.78, 1902898.65 4230321.3, 1902888.46 4230330, 1902888.2 4230330.23, 1902882.41 4230334.54, 1902874.51 4230339.84, 1902863.3 4230348.06, 1902880.0939945935 4230362.772798056, 1902891.666091778 4230362.914204695, 1902962.937982552 4230427.531426008, 1902989.675095713 4230456.257470376, 1903021.4990874527 4230477.021066968, 1903050.6139732788 4230515.686271273, 1903079.1350000077 4230582.774999975, 1903079.32 4230632.08, 1903056.7275836861 4230736.658712052, 1903015.0600000322 4230778.929999968, 1902977.3750000123 4230901.354999994, 1902968.2874898785 4230937.412894737, 1902950.45416341 4230938.943256617, 1902929.6624882147 4230940.052325271, 1902832.9675000003 4230978.540000001, 1902838.8475000127 4231036.217500036, 1902849.2125000043 4231082.102500002, 1902857.7322630398 4231119.02325273, 1902846.7166434708 4231115.516471514, 1902842.4173393724 4231116.326172493, 1902820.8674999939 4231109.307500002, 1902690.8945103884 4231057.219693151, 1902611.1422267181 4231021.5778643675, 1902540.658565998 4230957.518642047, 1902527.3963136743 4230938.609771524, 1902520.764544908 4230945.710749451, 1902517.2819628713 4230937.822173474, 1902492.5350000046 4230963.165000015, 1902499.866784393 4230990.941465551, 1902495.749879059 4231035.378462419, 1902485.5549999974 4231068.9799999995, 1902472.84750001 4231107.502500013, 1902501.102500017 4231151.0700000115, 1902500.3300000161 4231172.8275000155, 1902512.450000022 4231206.205000026, 1902522.2900000336 4231216.8999999855, 1902554.0875000262 4231227.169999991, 1902567.20529145 4231231.730143573, 1902571.0361096098 4231231.796460516, 1902574.6075000241 4231231.7299999865, 1902584.1242747405 4231231.673422943, 1902588.146734664 4231233.654772483, 1902594.865 4231242.65, 1902603.5274999964 4231264.217500009, 1902607.0749999986 4231287.2175, 1902615.085216606 4231292.763671544, 1902625.9995711995 4231295.320703924, 1902632.905 4231298.277499993, 1902643.7199999955 4231306.902499987, 1902648.3474999946 4231328.152499987, 1902635.1849999898 4231349.519999988, 1902629.92 4231377.13, 1902630.462500007 4231398.712500003, 1902639.7650000127 4231415.792500001, 1902668.5825000105 4231437.454999985, 1902698.7824999888 4231449.887499971, 1902717.5404103836 4231455.133282529, 1902736.0028769115 4231477.489188912, 1902775.0077890214 4231491.688948745, 1902803.885 4231507.162499998, 1902838.283902435 4231526.47278743, 1902868.98 4231538.205, 1902908.6796007373 4231547.693512503, 1902949.721373187 4231576.529082121, 1902981.1700000046 4231594.584999988, 1903012.7625000041 4231603.459999989, 1903038.6649999989 4231611.159999992, 1903033.5899999936 4231696.645000005, 1903014.2525000023 4231763.815000009, 1903018.6199999852 4231783.642500002, 1903035.814999989 4231806.630000003, 1903043.9549999959 4231822.762500006, 1903024.4825000043 4231856.080000019, 1903006.7250000206 4231898.957500031, 1902993.0659984301 4231925.268463905, 1902994.6997615828 4231941.522816161, 1903008.3325000235 4231964.972500035, 1903029.675 4231994.747500006, 1903058.7724999983 4232017.302500006, 1903080.944999996 4232029.975000019, 1903107.0375000027 4232042.065, 1903144.595 4232052.855, 1903181.0325000011 4232066.565000016, 1903214.6345416962 4232078.114526521, 1903241.674999971 4232085.379999983, 1903276.7874999894 4232101.757499992, 1903286.9404743433 4232102.993978035, 1903288.9199999864 4232103.187499995, 1903312.6738554288 4232096.247868362, 1903313.0973066427 4232096.299110023, 1903336.3878801425 4232099.072498305, 1903343.0360006096 4232097.274181601, 1903352.849044691 4231969.440847111, 1903444.9721685492 4231888.738046768, 1903450.6312662477 4231887.7363107875, 1903455.6715356153 4231886.96922739, 1903493.5868883075 4231906.592503573, 1903504.8289723936 4231908.980886212, 1903507.96996506 4231908.518281225, 1903514.266229367 4231907.514340153, 1903542.1112703923 4231892.925544787, 1903544.8716578824 4231893.146614743, 1903549.5384732243 4231893.031855278, 1903559.0015963162 4231902.408858847, 1903578.219797607 4231938.34581977, 1903581.4637194946 4231985.645400555, 1903585.7815324268 4231984.116544889, 1903585.9024884047 4231985.127316147, 1903708.852077231 4231940.4776649, 1903709.0104834207 4231940.86632271, 1903714.8800801835 4231938.700004266, 1903734.0749467786 4231977.814992686, 1903778.0676940328 4232060.578823461, 1903810.5150000046 4232114.547499998, 1903832.9274999849 4232148.62749996, 1903853.5394736612 4232178.498856225, 1903862.1641056582 4232197.158612931, 1903870.783127612 4232230.045600288, 1903912.2816118407 4232297.349619424, 1903914.1483018456 4232306.592272862, 1903920.4500000072 4232318.602499974, 1903933.9374999886 4232388.887499999, 1903970.9175000056 4232439.762500005, 1903992.2649999904 4232485.910000007, 1904006.4374999881 4232523.727500018, 1904019.0274999791 4232550.082500001, 1904039.222499979 4232583.607500007, 1904078.6074999953 4232616.817500012, 1904098.655111322 4232675.272398813, 1904101.281052615 4232689.416164004, 1904111.0149999864 4232700.437500026, 1904121.2574999945 4232706.7050000075, 1904134.5050000027 4232712.620000008, 1904139.804367449 4232710.899320409, 1904140.570710031 4232710.408558031, 1904148.9719230507 4232623.375394776, 1904162.245860306 4232565.941680169, 1904173.9568357423 4232518.2639043, 1904175.9574999474 4232512.292500002, 1904222.6324999523 4232459.127500021, 1904284.625 4232406.362500007, 1904292.1430115362 4232405.056959962, 1904323.2774999978 4232370.150000021, 1904341.3675000016 4232349.927500004, 1904444.7159919073 4232264.330941296, 1904477.2674999447 4232237.485000046, 1904517.052297544 4232190.209483805, 1904555.6757913972 4232213.019865295, 1904587.3920079705 4232179.796104273, 1904614.6933085998 4232152.672487466, 1904637.7155005024 4232133.858688085, 1904657.1221009952 4232125.10267964, 1904702.5899999947 4232108.590000018, 1904718.1375000023 4232100.727500022, 1904728.2575000075 4232089.605000023, 1904732.058326524 4232084.087353924, 1904739.2530760954 4232071.453081031, 1904740.2927166657 4232066.218775979, 1904741.0184992284 4232060.613393913, 1904734.8300000143 4232030.925000011, 1904733.8765503603 4232019.118992584, 1904735.0927879887 4232019.731985898, 1904734.98 4232018.39, 1904735.033625245 4232016.482473429, 1904768.395 4232032.74, 1904797.0299999597 4232046.632499981, 1904866.92 4232071.44, 1904927.5700000362 4232082.395000011, 1904955.643024829 4232089.542375597, 1904972.4069838228 4232062.054139681, 1905004.084777328 4232010.412004048, 1905018.8229771473 4231986.670838444, 1905027.0046303426 4231973.471700187, 1905028.8756992836 4231970.542191059, 1905036.1390211936 4231959.139308364, 1905037.7538153634 4231956.612332209, 1905039.4315121681 4231953.986903658, 1905040.4469394847 4231952.618219732, 1905043.9774770138 4231947.865889209, 1905071.1261855839 4231913.535996334, 1905082.755202416 4231899.0598077215, 1905084.5909663194 4231896.908059405, 1905117.1438714166 4231863.075131611, 1905131.8191149053 4231848.005693307, 1905162.2406780908 4231817.095991931, 1905168.9364373267 4231811.216480166, 1905271.32249999 4231701.84000001, 1905293.3595749137 4231669.1498987945, 1905280.0276379173 4231640.012835469, 1905286.1153431805 4231640.024263181, 1905285.4034154147 4231638.357474952, 1905309.6825000008 4231636.967499997, 1905335.6675000044 4231640.082499999, 1905371.170000024 4231653.872500002, 1905388.8425000238 4231663.344999987, 1905417.6025000045 4231677.43499997, 1905441.4911651926 4231695.9099551635, 1905470.6237687436 4231707.557791948, 1905484.632500009 4231723.069999986, 1905510.450947056 4231733.117792659, 1905583.25999994 4231772.50749998, 1905637.8959707965 4231800.709558249, 1905689.9636169516 4231825.584681167, 1905693.016718776 4231823.967861148, 1905696.3459836622 4231826.403071345, 1905710.7674999938 4231814.407499994, 1905738.0549999992 4231795.042499997, 1905793.4287071242 4231763.480576153, 1905810.062732675 4231753.592636768, 1905822.0218522272 4231741.652206484, 1905829.27302491 4231730.222813583, 1905831.8868944454 4231725.695694292, 1905834.5356146635 4231720.206920502, 1905834.5999032776 4231720.057748814, 1905854.4291700183 4231669.058350224, 1905871.3426216827 4231632.14545427, 1905886.8463562645 4231608.056153873, 1905909.4248965743 4231580.581330567, 1905896.5173138077 4231565.714747357, 1905890.3591747824 4231554.628989045, 1905886.7503702964 4231530.360940582, 1905887.490741944 4231530.495003249, 1905927.995348232 4231537.422271306, 1906075.7983643957 4231562.582270407, 1906205.1381391725 4231584.732848939, 1906236.8132506213 4231590.234507928, 1906301.3277813985 4231601.475165462, 1906324.4803643725 4231605.801720648, 1906462.997544596 4231629.05550062, 1906574.3878431492 4231647.96188955, 1906721.3033856277 4231673.057960523, 1906785.9636917086 4231684.2603301015, 1906829.5296551941 4231692.3018172365, 1906850.8728553413 4231696.210495111, 1906859.6834076415 4231698.0259424895, 1906867.3133462747 4231699.490174186, 1906888.0323210913 4231703.659729276, 1906907.8904668007 4231707.712728351, 1906910.065154774 4231708.191295907, 1906928.810227462 4231712.126885944, 1906970.4108702675 4231721.123643073, 1907030.0440947465 4231734.134831176, 1907054.3274456165 4231739.584713497, 1907054.85 4231740.01, 1907060.39 4231740.24, 1907076.39 4231731.34, 1907103.7 4231715.14, 1907129.91 4231700, 1907152.26 4231686.94, 1907154.05 4231685.94, 1907154.63 4231685.58, 1907158.0476206075 4231683.579139291, 1907165.2285399798 4231678.969251645, 1907171.6985399798 4231674.676131073, 1907184.1912398783 4231666.339268724, 1907204.9230642715 4231652.56291751, 1907228.3759109313 4231637.082115384, 1907231.323431174 4231635.1782489875, 1907246.209027813 4231625.907258929, 1907262.7286201573 4231615.5635513645, 1907271.3633417448 4231610.068611026, 1907290.143605423 4231597.931570583, 1907298.435328351 4231592.153609668, 1907305.070657895 4231587.574382591, 1907310.5953554537 4231583.349434201, 1907325.2245750735 4231571.946068915, 1907337.061269497 4231562.1753426, 1907343.9040503304 4231556.484714042, 1907363.100916034 4231539.33771985, 1907368.1885171882 4231534.769444047, 1907368.9719228598 4231534.064731336, 1907374.8679568954 4231528.686634422, 1907375.9993436693 4231527.651726957, 1907387.8367401923 4231516.656575718, 1907401.0093899872 4231503.205367059, 1907421.0169939308 4231482.019402834, 1907439.2718117114 4231463.146435707, 1907465.4129167735 4231436.764865988, 1907501.5931376505 4231401.264524291, 1907554.3247398366 4231349.529142941, 1907565.426858416 4231338.677896494, 1907606.798981473 4231296.493859421, 1907627.7728974402 4231274.973796337, 1907675.210643458 4231227.125255348, 1907719.3468313983 4231182.687643739, 1907815.4468360196 4231087.153342962, 1907823.1165013325 4231079.359027107, 1907837.3969866817 4231064.875176471, 1907853.0033225112 4231049.189344632, 1907950.9791842687 4230949.789475785, 1907973.065951353 4230924.954988888, 1908000.3428744473 4230889.684959557, 1908029.5441639079 4230850.777098198, 1908043.5574999854 4230831.179999998, 1908058.5684716478 4230809.292226714, 1908099.3154310095 4230749.252403037, 1908133.0238104116 4230695.722238505, 1908166.923182624 4230635.6977784, 1908229.7292225247 4230523.345482499, 1908291.0541497988 4230413.444645751))'::geometry,'38281','Noyarey','NOYAREY','NOY','NOY'),
     (18,'SRID=3945;POLYGON ((1916797.2167292195 4221604.543321516, 1916838.1738317325 4221653.422305301, 1916842.8727905827 4221659.554686192, 1916875.2078312691 4221698.44114258, 1916908.179377976 4221738.135899825, 1916912.9871208777 4221743.587200018, 1916915.5012326161 4221746.499455593, 1916929.5102412314 4221763.182217758, 1916929.9327884791 4221763.77128543, 1916949.6833123534 4221731.739334489, 1916953.016929739 4221730.154065194, 1916953.9096376335 4221729.732370608, 1916986.2174280775 4221710.851286723, 1917103.584832285 4221641.606247384, 1917115.0580252383 4221635.023994596, 1917130.428726719 4221625.973433506, 1917149.8839600347 4221614.522264687, 1917145.7077758193 4221607.945066773, 1917137.3825701175 4221596.0720850285, 1917120.2397565478 4221573.544106567, 1917120.3666171003 4221573.42133829, 1917120.1807377702 4221573.151455801, 1917157.6665412153 4221564.442301622, 1917201.0966877516 4221554.500063251, 1917286.6694015784 4221534.60810854, 1917441.58666538 4221501.094473022, 1917450.1904161454 4221500.687764011, 1917540.2920951212 4221489.272807745, 1917541.6066058578 4221488.947819298, 1917681.2569908402 4221463.224570467, 1917696.1380420597 4221471.446239116, 1917697.002418915 4221473.305428072, 1917882.3841677033 4221451.3860170515, 1918030.5473355632 4221434.174141372, 1918173.052520251 4221418.312079945, 1918181.1426255354 4221418.199754544, 1918187.1971530856 4221418.554171762, 1918195.173198208 4221420.528724704, 1918408.9718865931 4221426.816350148, 1918648.1000000027 4221434.373279341, 1919012.6045742717 4221446.527474068, 1919009.5584589709 4221441.632080038, 1919018.240353213 4221441.855139545, 1918974.3680173436 4221371.498946619, 1918894.7715558137 4221242.182454034, 1918752.1485723883 4221012.522658688, 1918679.9162500028 4220894.924999997, 1918632.3950894875 4220818.884672644, 1918568.2043554964 4220716.490824148, 1918512.4529721292 4220627.527433067, 1918510.2812499884 4220624.65625, 1918479.049789564 4220575.386513118, 1918445.0357059655 4220521.0276695425, 1918412.7145737805 4220469.350762726, 1918410.8577093342 4220466.26436865, 1918410.574516999 4220466.623539416, 1918394.3224806197 4220441.5434252275, 1918389.4055830408 4220430.881177106, 1918387.8565122797 4220427.505530783, 1918382.3482740475 4220414.88928612, 1918379.4138540027 4220409.053532042, 1918378.177905993 4220407.216824173, 1918376.0193943153 4220404.542411497, 1918372.8478117227 4220401.3723987825, 1918371.5092771833 4220399.6217475915, 1918369.335464712 4220397.441968365, 1918365.7053243988 4220393.0950458525, 1918359.703965648 4220385.493462877, 1918358.9131797766 4220384.475194586, 1918358.4 4220383.64, 1918355.95 4220377.91, 1918355 4220376.52, 1918351.46 4220373.73, 1918343.82 4220368.16, 1918342.315348067 4220367.112196352, 1918333.61 4220361.05, 1918326.58 4220355.86, 1918324.28 4220353.27, 1918314.15 4220342.38, 1918309.6 4220336.68, 1918309.96 4220316, 1918304.42 4220300.11, 1918301.85 4220294.49, 1918297.15 4220290.8, 1918287.709474493 4220285.058799785, 1918281.99 4220280.45, 1918273.7 4220272.23, 1918273.952033607 4220271.789546443, 1918274.5058651038 4220271.477859237, 1918276.7055719586 4220270.480463677, 1918279.228538876 4220267.109927427, 1918254.593749988 4220113.232500005, 1918248.2658333296 4220071.730208332, 1918241.5687989176 4220026.644553133, 1918236.7801277572 4220024.22424627, 1918229.6458149375 4220020.655412055, 1918216.8236208898 4220011.565632039, 1918202.7761033173 4220007.988054942, 1918188.230335023 4220005.671165819, 1918178.249585115 4220002.50968858, 1918168.3612500315 4219996.171666666, 1918148.223519507 4219983.344833446, 1918141.7741666927 4219978.513124997, 1918136.4758144328 4219976.10027485, 1918133.7648994182 4219974.767591584, 1918129.7299502026 4219973.335804179, 1918128.277073407 4219972.898592898, 1918123.2920568595 4219971.362078355, 1918120.833486471 4219970.385185773, 1918116.621421126 4219968.1273266515, 1918114.2832593594 4219964.829237167, 1918114.223921847 4219964.738853092, 1918103.4648800755 4219942.757215356, 1918091.3312500122 4219921.183541666, 1918048.5935416692 4219838.992499978, 1917998.0362499992 4219804.349583321, 1917990.2380920423 4219800.22710819, 1917975.2090720101 4219789.179205705, 1917959.7181250125 4219781.1295833215, 1917931.6166666718 4219779.357499963, 1917898.0207042508 4219778.241320817, 1917871.6311217702 4219774.220649374, 1917862.8695482232 4219771.198837773, 1917852.4194483645 4219766.600716804, 1917843.874019914 4219760.601379732, 1917822.7416650762 4219778.321092604, 1917768.2488328235 4219845.327668936, 1917746.6423888234 4219867.687514424, 1917726.2447983255 4219884.747613097, 1917693.4456080792 4219909.539349668, 1917677.7610579524 4219914.804395588, 1917660.5134505245 4219918.916401562, 1917647.2654535288 4219923.150918092, 1917632.3259747326 4219933.194859663, 1917622.002108332 4219945.44898034, 1917612.1684210526 4219955.144494473, 1917602.667083274 4219961.78749986, 1917586.4499999548 4219968.61916651, 1917547.4629166264 4219977.614999836, 1917530.5299999742 4219982.784999864, 1917509.8620833158 4219991.431249886, 1917480.3049805935 4220004.535452017, 1917465.1736217944 4220016.152154977, 1917460.8325129014 4220021.593586707, 1917456.318387064 4220032.211980942, 1917454.3283414661 4220048.990893663, 1917449.7466742597 4220068.277291666, 1917443.6270086374 4220072.272326485, 1917369.2699999844 4220117.11125001, 1917352.953170546 4220132.73872343, 1917335.0458603238 4220152.349210526, 1917320.580354251 4220166.612869433, 1917295.6962544278 4220188.567282387, 1917259.7065802142 4220219.936217105, 1917251.0888366783 4220226.051406156, 1917242.2958666154 4220230.9996871045, 1917226.428349246 4220237.207440236, 1917221.010119203 4220238.894863867, 1917216.846840345 4220240.149076733, 1917207.2844502819 4220241.146287997, 1917186.8624340415 4220242.02509246, 1917175.7981025893 4220243.973090972, 1917167.4821133607 4220245.503218588, 1917155.522243335 4220248.292921976, 1917124.056917692 4220256.108731264, 1917122.9461286967 4220257.927567047, 1917121.1484715757 4220258.464401639, 1917118.020410233 4220267.494308135, 1917117.1661367703 4220271.230357231, 1917116.2557626448 4220275.14649192, 1917115.0632049667 4220282.093589644, 1917114.0137431424 4220289.286219743, 1917113.6490219506 4220292.434180127, 1917113.6611141977 4220302.620777386, 1917112.9567459594 4220327.989934845, 1917109.7958517466 4220353.48064292, 1917105.4597381072 4220385.596524545, 1917105.231286601 4220391.784353948, 1917105.9438458001 4220395.920908494, 1917113.3524519897 4220418.884883851, 1917119.4246470146 4220436.973980892, 1917123.2757888967 4220449.300154292, 1917129.6186057734 4220484.326376522, 1917132.5223581996 4220507.3831825685, 1917135.0232793542 4220539.899278846, 1917134.00862857 4220557.047260315, 1917132.476816784 4220565.729355225, 1917132.1317530076 4220566.66008556, 1917127.1648482024 4220578.462545989, 1917120.5627396367 4220592.078403598, 1917114.153776889 4220603.928747105, 1917105.9594110127 4220617.77544071, 1917092.625978075 4220640.26632739, 1917091.1267576502 4220642.8157681525, 1917090.6432389389 4220643.582859423, 1917086.5602950123 4220649.450783066, 1917079.216880416 4220658.39060615, 1917068.7844358627 4220667.395795937, 1917067.1243254836 4220669.7317668665, 1917067.9857327484 4220672.299001172, 1917068.887505721 4220673.8974066265, 1917070.5419752502 4220676.495046697, 1917080.9503199314 4220688.023365917, 1917093.8665324177 4220702.39889423, 1917098.3736844158 4220707.791462228, 1917105.3775853282 4220716.628511494, 1917106.8300814524 4220718.720568245, 1917108.7233296647 4220721.4474482965, 1917114.6099751308 4220737.882185726, 1917122.060890712 4220762.541399086, 1917125.9146066268 4220774.24541419, 1917128.1665402858 4220780.140287374, 1917127.7367551255 4220780.560016272, 1917127.823141202 4220780.834257785, 1917126.140909551 4220782.382003874, 1917053.601544906 4220857.221765247, 1916998.8624999996 4220914.153750004, 1916958.6417150127 4220955.793074653, 1916940.234327723 4220974.768704167, 1916926.5197025803 4220988.809190687, 1916914.7238511983 4220979.86683442, 1916908.22970422 4220974.9137910595, 1916903.1700555168 4220971.0309096975, 1916896.75832098 4220966.15128246, 1916895.891713385 4220965.410125388, 1916895.300871057 4220964.905290844, 1916884.0117263708 4220954.109413034, 1916874.5966399675 4220945.131542051, 1916855.796072072 4220927.027528811, 1916855.753611822 4220926.986842973, 1916854.049305633 4220925.35541125, 1916847.5952479194 4220919.176944977, 1916843.5974381964 4220915.3753016265, 1916838.0352400548 4220910.052873145, 1916830.0402755174 4220914.541012896, 1916829.6103191215 4220914.840337779, 1916816.8165749444 4220925.916907471, 1916815.8465336263 4220926.872099572, 1916798.441309722 4220945.804055718, 1916770.913757969 4220975.484447387, 1916695.6912439105 4221057.990731354, 1916663.4691289866 4221093.739248256, 1916645.917392598 4221112.859329433, 1916645.3394796592 4221112.451081649, 1916618.3101735602 4221094.546285295, 1916616.4678411128 4221097.056129498, 1916616.3680099521 4221097.00291024, 1916572.8000795518 4221154.206104921, 1916572.7282523578 4221154.300186403, 1916567.0999632496 4221161.675410762, 1916560.7252614973 4221169.907026823, 1916558.1753691405 4221173.529617559, 1916557.3466720718 4221174.81392475, 1916557.1808548458 4221175.071911827, 1916556.5142384993 4221176.188302624, 1916555.3212906918 4221178.365938824, 1916554.9878524675 4221179.208965256, 1916554.8617617828 4221179.533819158, 1916554.7387116565 4221180.096638036, 1916554.3577808328 4221182.044109528, 1916554.2498427106 4221182.845548607, 1916554.2317330604 4221183.299052834, 1916554.3458495084 4221183.7839587545, 1916554.6184000366 4221184.6356461495, 1916555.342800366 4221186.626003399, 1916555.9289659958 4221187.760590539, 1916555.8373180262 4221187.87435659, 1916555.8698972494 4221187.950055374, 1916542.003106887 4221205.047280075, 1916539.661208277 4221207.935067749, 1916536.5205857437 4221211.917770733, 1916530.288496042 4221219.77378628, 1916518.9341121307 4221234.016211045, 1916508.1240966944 4221247.42055778, 1916507.8882865065 4221247.73919886, 1916522.379538299 4221258.073897589, 1916523.12060507 4221258.599405624, 1916522.3823578134 4221260.224011283, 1916510.6654768991 4221284.093974534, 1916499.5048345008 4221306.354555369, 1916494.6352313245 4221316.068988983, 1916492.9087951295 4221319.153522964, 1916491.2082540581 4221322.193522283, 1916507.5144057258 4221341.820396805, 1916529.8225297304 4221368.730137907, 1916589.8408016902 4221441.004981339, 1916598.9743109122 4221452.1477972735, 1916612.3919154503 4221468.289016199, 1916642.516389107 4221504.4439951265, 1916646.6605137663 4221509.430203626, 1916647.020928356 4221509.8315006625, 1916647.3174090046 4221510.152098513, 1916653.4006191695 4221516.546824419, 1916653.7125776687 4221516.874694503, 1916694.7520738211 4221482.141843601, 1916695.1864503897 4221482.6466366835, 1916695.2915626096 4221482.559693542, 1916718.1744201903 4221509.893909216, 1916770.5286981482 4221572.442828931, 1916797.2167292195 4221604.543321516))'::geometry,'38309','Poisat','POISAT','POI','POI'),
     (12,'SRID=3945;POLYGON ((1911744.8336348685 4219346.747823887, 1911757.0994348307 4219344.517707631, 1911761.7196632647 4219343.780741958, 1911764.4003913635 4219343.342707669, 1911766.9540957897 4219342.919045152, 1911777.259125328 4219341.055983714, 1911786.7820464906 4219339.360727152, 1911788.9714784825 4219338.973640843, 1911789.7080175108 4219338.843792303, 1911795.0353996917 4219337.903113969, 1911823.0554725735 4219332.926197204, 1911995.8892469509 4219301.483819799, 1911996.8915974214 4219301.301491233, 1911996.9699747693 4219301.28723214, 1912004.9900477177 4219299.828494582, 1912040.755866832 4219293.211778818, 1912087.235957229 4219284.555397728, 1912113.2545178828 4219280.183753094, 1912137.756790657 4219276.033366029, 1912139.0767609088 4219275.810035067, 1912144.619955253 4219274.863392472, 1912188.280562051 4219267.349575766, 1912251.0468916919 4219249.79535534, 1912252.5306702692 4219249.449140599, 1912355.887725512 4219220.863935461, 1912413.7854744708 4219204.882981935, 1912451.4233719134 4219194.554312581, 1912529.9225387014 4219172.918623519, 1912556.0430188419 4219155.9284981415, 1912563.0760029457 4219151.262065539, 1912591.5805974107 4219132.423233438, 1912594.108272252 4219130.7528303405, 1912594.1084472064 4219130.752714848, 1912603.532532488 4219124.526493633, 1912615.6128023681 4219116.515178329, 1912623.921892895 4219112.947377671, 1912824.2153878198 4218980.182086806, 1912985.4250025037 4218873.62177226, 1913062.6624636466 4218822.816854066, 1913080.417090356 4218811.141627545, 1913080.4214272446 4218811.13877351, 1913080.425950632 4218811.135797775, 1913080.455178935 4218811.116580295, 1913080.9707433996 4218810.777830482, 1913084.9989273371 4218808.129798491, 1913090.1264725341 4218804.7981069, 1913090.1305830556 4218804.795435635, 1913090.1351404905 4218804.792473888, 1913094.9353283208 4218801.673845829, 1913118.6666643166 4218786.227426167, 1913121.7996143063 4218784.190788457, 1913158.1888991483 4218760.335125571, 1913159.0244203527 4218759.790987256, 1913160.471389343 4218758.839159534, 1913167.6546108385 4218754.108561515, 1913203.197768622 4218730.811065525, 1913247.4259462396 4218701.784970778, 1913252.0413743611 4218698.567659996, 1913279.692744683 4218680.428890049, 1913281.3145405916 4218679.067022248, 1913283.9369530855 4218676.935951629, 1913298.9515929054 4218667.485762753, 1913306.9836157507 4218662.434526626, 1913393.8607993904 4218605.174533324, 1913429.299903045 4218581.6054385705, 1913437.6664717982 4218576.166069544, 1913438.5186658239 4218575.706878011, 1913443.158564694 4218573.82905983, 1913423.5052373135 4218555.435942006, 1913419.3827865606 4218551.311892764, 1913416.3784545003 4218548.308207393, 1913413.4538313777 4218545.37536538, 1913412.7318898747 4218544.5602520425, 1913411.7519824703 4218543.460275566, 1913408.4427174518 4218539.535164484, 1913398.440988042 4218527.012814849, 1913397.01119822 4218524.860464159, 1913394.610141518 4218521.358651918, 1913391.7449240226 4218515.337047345, 1913386.8823154825 4218499.392800948, 1913384.2617932062 4218490.765561411, 1913382.2140000316 4218487.221419773, 1913378.6939031575 4218483.13762868, 1913368.7628683404 4218474.211984387, 1913349.91550731 4218458.204676296, 1913337.2542066092 4218447.333221976, 1913335.12465375 4218445.541498038, 1913328.3557895862 4218439.882479846, 1913308.3986845068 4218422.882178613, 1913301.996390758 4218417.180685746, 1913300.2922623528 4218415.601355797, 1913275.9044129555 4218393.568704453, 1913263.261158456 4218381.548149127, 1913259.0293227013 4218377.085933086, 1913254.6146890675 4218372.540780997, 1913244.2486080418 4218360.489840936, 1913237.5812509614 4218351.032908937, 1913233.6570514687 4218345.478570629, 1913226.4002037544 4218328.43934332, 1913224.9332310688 4218323.920325834, 1913221.0779698738 4218308.312745416, 1913216.2356199743 4218289.569741663, 1913210.6919102813 4218275.924698191, 1913206.8058123067 4218263.284356046, 1913208.0523351494 4218186.209307883, 1913229.2923294315 4218133.786375576, 1913234.8159421044 4218128.297696629, 1913235.7272829006 4218126.145260926, 1913241.8798548458 4218108.653080569, 1913246.2672530664 4218099.628842906, 1913264.0658201352 4218069.936671983, 1913264.8771607226 4218066.207159717, 1913267.1576442823 4218053.198266909, 1913269.2120197362 4218037.413424686, 1913270.810668016 4218022.417823887, 1913270.7409345985 4218017.9605635675, 1913269.3438286528 4217990.037173254, 1913269.2502918253 4217988.150844479, 1913267.8329564338 4217960.411388072, 1913267.4776867253 4217944.108524164, 1913267.4759079502 4217943.07985564, 1913267.6637056237 4217925.106591689, 1913269.9633037657 4217917.413494689, 1913275.3056079978 4217908.597148935, 1913282.9814084382 4217897.285636999, 1913286.7179816177 4217891.330257035, 1913286.668043158 4217891.22359835, 1913286.330074391 4217890.501763823, 1913292.0576013068 4217880.241091908, 1913300.7255326263 4217863.778637855, 1913309.7870595485 4217838.848492212, 1913312.6397129833 4217831.808511459, 1913335.1409289383 4217792.099404908, 1913336.6362554675 4217789.480123769, 1913337.8682968486 4217787.31903615, 1913341.4830322443 4217780.331057588, 1913352.1281919184 4217759.852176705, 1913354.1705101111 4217756.788292839, 1913354.7430807452 4217755.939283925, 1913370.6232582233 4217736.911883624, 1913383.0314145694 4217722.007699572, 1913385.144676467 4217719.462176523, 1913386.003229269 4217718.429501602, 1913391.1215592446 4217712.263396548, 1913391.217391708 4217712.094036374, 1913395.6744230264 4217704.516475407, 1913398.2933180807 4217693.965178565, 1913399.726201173 4217686.933702532, 1913405.0802828 4217661.515581133, 1913413.4135313535 4217640.604108783, 1913419.218301666 4217630.448777729, 1913430.7029941664 4217611.322619121, 1913440.315605068 4217595.537037934, 1913443.4960462614 4217584.503108409, 1913432.6518200764 4217556.605204932, 1913432.234359373 4217554.035094494, 1913433.7872046225 4217542.1282501435, 1913433.7084526923 4217539.675236632, 1913433.6700500136 4217538.391532406, 1913431.191525985 4217526.379139368, 1913430.0631135344 4217523.74846399, 1913428.4814834294 4217521.724575899, 1913409.2983914935 4217500.090925678, 1913399.746004169 4217489.337880474, 1913398.8479521663 4217488.222371869, 1913389.7048534255 4217476.990451062, 1913388.1090493326 4217473.427574403, 1913386.280351568 4217469.131936133, 1913386.8297390586 4217468.115655657, 1913389.0796253316 4217463.953719808, 1913392.4328564042 4217458.278866621, 1913396.5186364877 4217450.192718824, 1913406.423347219 4217430.73801015, 1913420.3904584656 4217409.155108607, 1913422.7665512788 4217405.9870868055, 1913427.1035920132 4217399.835850577, 1913431.8774340956 4217391.939490863, 1913444.2071751785 4217372.151116884, 1913446.8231411544 4217371.254771001, 1913453.8620065164 4217367.961035118, 1913460.824079422 4217363.848149869, 1913461.2011286227 4217362.648664582, 1913462.9309589572 4217361.630175698, 1913464.0735835927 4217353.510686126, 1913465.0395880423 4217347.575759293, 1913468.9895596656 4217334.579445765, 1913475.2205081235 4217319.510758364, 1913478.634237425 4217305.396261965, 1913471.6371125288 4217288.420434971, 1913467.6373366439 4217240.175915926, 1913463.5042757567 4217212.09880713, 1913461.3141840112 4217203.849124085, 1913456.8985231316 4217197.090056868, 1913450.6559433846 4217184.383707091, 1913449.8107122409 4217180.250674779, 1913448.9026087776 4217175.182616913, 1913465.99548583 4217114.486194332, 1913469.1622840425 4217108.390102349, 1913475.0353878199 4217097.084367519, 1913509.489713683 4217027.447225415, 1913525.6448178135 4216974.299939271, 1913540.148688016 4216923.720718015, 1913541.8335045546 4216908.731401822, 1913542.2095757467 4216906.96278843, 1913542.3244281074 4216906.439066055, 1913543.0386339535 4216902.534772222, 1913544.8504813125 4216892.37492019, 1913548.1182183092 4216870.486008339, 1913548.36798583 4216834.012489878, 1913548.844455068 4216774.197722593, 1913548.53179594 4216729.473444173, 1913571.068457567 4216724.508055989, 1913569.655315732 4216711.663688835, 1913560.7198068576 4216630.04312091, 1913552.9651643392 4216528.0859527, 1913551.119421842 4216527.94710307, 1913551.1 4216527.73, 1913550.8743440355 4216526.809677635, 1913522.1481519272 4216523.70894096, 1913512.585261738 4216519.211112266, 1913482.6212753034 4216499.237449393, 1913452.7850809717 4216479.719944332, 1913441.785687409 4216471.910343584, 1913430.356171988 4216461.962944063, 1913429.7873452622 4216462.763270038, 1913429.5074433405 4216463.157085532, 1913427.5698523612 4216460.797625361, 1913427.2172034641 4216460.356042407, 1913426.7018328533 4216459.366324395, 1913411.920585292 4216427.317730818, 1913394.3042966519 4216387.758464432, 1913389.1430818043 4216379.179111108, 1913355.4952535138 4216327.109725946, 1913354.4666468839 4216325.915845697, 1913352.9562900034 4216324.3247835245, 1913352.0039939745 4216321.814216608, 1913351.1785234832 4216319.597421292, 1913337.2266601813 4216293.885762096, 1913332.2564028786 4216286.491675837, 1913332.0534363086 4216286.182873478, 1913330.966441961 4216284.867642395, 1913329.3911778284 4216282.993493248, 1913326.438531099 4216279.486159688, 1913325.813501776 4216278.763382169, 1913325.7054856834 4216278.64057049, 1913315.0740462563 4216266.576581211, 1913311.141132861 4216262.331245769, 1913290.5383044998 4216240.097144535, 1913281.645527432 4216230.379480971, 1913280.481452469 4216229.093574835, 1913275.110206738 4216223.9760245625, 1913261.4026676344 4216213.105153147, 1913247.2015526223 4216202.007515965, 1913245.5675534122 4216200.364375987, 1913234.3729424416 4216187.009902835, 1913232.736862217 4216185.665122787, 1913231.6175745807 4216184.792042366, 1913222.971437732 4216182.12185514, 1913209.5899019653 4216178.105242015, 1913200.444659112 4216179.713699818, 1913192.094461996 4216181.4704439575, 1913184.883330871 4216165.780166991, 1913175.2563918475 4216138.457694879, 1913171.760205963 4216130.191726181, 1913155.436998949 4216095.134307266, 1913130.931364041 4216040.019577894, 1913124.1232216936 4216026.004728279, 1913120.6482049066 4216020.736172718, 1913118.71 4216021.57, 1913118.4995280681 4216021.7560898615, 1913117.229110863 4216020.203357722, 1913114.3096875106 4216022.610882207, 1913109.929171348 4216028.58662438, 1913106.2380819118 4216031.987062015, 1913084.3852722358 4216051.81416646, 1913083.6931682199 4216052.357622124, 1913081.736729087 4216053.8970714, 1913081.2183922443 4216054.666194206, 1913080.245569299 4216056.153323338, 1913076.0553424119 4216064.298871209, 1913070.0164024378 4216083.630901716, 1913066.1665377705 4216092.621334803, 1913056.5135648656 4216108.226194379, 1913055.2818808914 4216110.58275136, 1913053.6433353005 4216115.940576071, 1913048.5770555674 4216132.6627044715, 1913043.2100498115 4216138.561822477, 1913037.0477253296 4216146.422973271, 1913036.5167076169 4216140.318673219, 1913034.8382406698 4216139.123832341, 1913042.2444759007 4216108.536787224, 1913061.8456663145 4216037.758363608, 1913076.0199284635 4215993.995865944, 1913083.177441423 4215970.076407061, 1913102.882503015 4215906.732725258, 1913110.7591826369 4215889.50921209, 1913127.3302223324 4215859.734967481, 1913126.4 4215859.33, 1913125.905987323 4215859.011451525, 1913126.3439304144 4215858.1671185335, 1913121.8597872183 4215856.402387152, 1913109.6954335028 4215851.90098991, 1913092.038696625 4215849.339322769, 1913093.2325778892 4215845.667450956, 1913098.4265560089 4215833.254014715, 1913098.1613360324 4215830.791052632, 1913094.732959964 4215827.018568671, 1913087.215182186 4215817.538643724, 1912986.4434615385 4215641.791396761, 1912962.1354226551 4215598.25553551, 1912957.9993858053 4215590.850714917, 1912944.2797985247 4215566.795161981, 1912939.138329234 4215557.776441635, 1912916.568804848 4215517.808658268, 1912864.9988006072 4215427.642869433, 1912729.759215751 4215189.903703984, 1912672.7610356521 4215083.814572111, 1912562.6149386405 4215197.891542325, 1912410.8785730952 4215343.87629948, 1912319.455425101 4215454.104089069, 1912268.6849674552 4215520.752195994, 1912250.4905564545 4215544.487326113, 1912188.5478413156 4215628.06879752, 1912161.277700261 4215678.990569823, 1912157.8467611335 4215687.648582996, 1912158.7800802188 4215704.638540304, 1912163.0100295008 4215746.683994636, 1912184.681741021 4215842.826910554, 1912196.1465512787 4215905.9928162405, 1912193.8941178536 4215968.275012602, 1912194.2816313494 4215999.721935724, 1912195.4739697985 4216078.205080378, 1912196.9009689994 4216108.676847355, 1912219.8902653155 4216357.612946951, 1912221.4393159624 4216378.676061956, 1912221.3237308995 4216394.672349832, 1912219.8955136808 4216406.163433323, 1912217.510021388 4216420.122529037, 1912217.2566676275 4216421.120182941, 1912213.4534740804 4216431.019737028, 1912203.856495354 4216458.528741518, 1912203.452438457 4216461.975764036, 1912203.6553753552 4216464.952171878, 1912203.8990922028 4216465.838046639, 1912208.7745723468 4216477.212919832, 1912212.7367382515 4216489.950169162, 1912211.1362877344 4216500.482918887, 1912205.7227965281 4216518.89843248, 1912180.57549507 4216571.7524644425, 1912179.6598127645 4216573.645809967, 1912176.3644374236 4216581.3685091, 1912174.9899046554 4216584.984383402, 1912171.8987864833 4216593.550360256, 1912162.941490722 4216619.337521359, 1912160.0288451293 4216627.766834924, 1912157.4931423797 4216634.977600962, 1912150.7183316106 4216652.658886942, 1912150.0914268745 4216654.292084662, 1912149.3904143693 4216656.190010963, 1912148.526452653 4216658.560813347, 1912147.6964121168 4216660.841671745, 1912147.6129382015 4216661.119271051, 1912145.876183542 4216667.697845163, 1912144.3433029258 4216673.994730271, 1912143.9424446928 4216676.220568193, 1912145.0117240117 4216681.452026007, 1912145.849008097 4216684.4706275305, 1912154.5941295547 4216708.479089069, 1912155.4052466634 4216710.687660632, 1912155.71424781 4216711.529904164, 1912155.7859942804 4216711.758679715, 1912157.255975729 4216716.372211386, 1912159.390788142 4216725.959639715, 1912160.547975235 4216731.115551391, 1912160.823821254 4216732.809268477, 1912160.8934321532 4216733.371755972, 1912161.6553632403 4216739.528458198, 1912162.7883502026 4216747.918481781, 1912162.9607545573 4216751.270205698, 1912161.442489879 4216754.954919027, 1912160.7554521419 4216756.617080395, 1912154.6969099888 4216769.318535513, 1912148.7008400958 4216781.934537723, 1912145.2103479519 4216789.255171273, 1912144.8955681075 4216791.791026325, 1912141.17655211 4216826.148609231, 1912135.9707230984 4216846.861809936, 1912134.5853137234 4216854.120450879, 1912134.3400870734 4216857.899486364, 1912134.2222616016 4216859.579059816, 1912134.0485987032 4216882.338096313, 1912133.622186235 4216886.740364372, 1912132.5344160225 4216891.2304124115, 1912128.942722614 4216901.051103425, 1912128.730101323 4216901.563765893, 1912128.121476491 4216902.632343376, 1912127.4937112418 4216903.733482621, 1912125.9346111377 4216906.484657192, 1912118.4764377733 4216918.327669605, 1912110.7615908426 4216929.16834508, 1912105.0160783208 4216937.425646262, 1912098.0596336357 4216948.480327443, 1912079.2520868047 4216980.260678685, 1912071.3383663676 4216992.654832741, 1912056.3342864565 4217010.556028179, 1912027.8274500372 4217029.952480325, 1912009.2471046222 4217042.871291014, 1911995.0080161944 4217053.857287449, 1911942.7662068163 4217097.329104141, 1911914.759078747 4217121.145212145, 1911908.0757478818 4217127.537584057, 1911882.3633264727 4217156.281297273, 1911876.9001044193 4217162.639579857, 1911868.8491915658 4217172.250815582, 1911868.7374126439 4217172.384632215, 1911868.6958880683 4217172.434378838, 1911847.6942983284 4217197.984528403, 1911839.5722960935 4217207.616275193, 1911828.4166041014 4217220.469944142, 1911827.4747947692 4217221.549052728, 1911826.3690659963 4217222.7810585275, 1911824.8606082848 4217224.455754586, 1911807.6415376985 4217243.495732012, 1911790.6435457144 4217262.861983959, 1911777.513393236 4217276.611787911, 1911777.2850449146 4217276.819931252, 1911774.1862892823 4217279.455935989, 1911770.1779635302 4217282.875246855, 1911768.8097329605 4217283.971705632, 1911766.0188337544 4217286.225577712, 1911758.9627523297 4217291.577537356, 1911756.3650388694 4217293.54184117, 1911750.0320253125 4217298.258692818, 1911745.797461555 4217301.384497261, 1911737.270696596 4217307.6789839575, 1911728.6169191306 4217314.07468301, 1911721.4525175383 4217319.392752571, 1911720.9739522093 4217319.757102538, 1911716.6396089306 4217323.051737107, 1911709.340532793 4217328.605043905, 1911706.3041603279 4217331.673563744, 1911702.7327807313 4217335.288324144, 1911697.025648125 4217341.476486799, 1911695.7549759576 4217343.078485448, 1911691.1137032527 4217349.620798926, 1911686.8975650147 4217355.920931352, 1911683.2500720352 4217361.95844664, 1911672.3438504136 4217381.43063179, 1911663.7037934274 4217396.628853865, 1911656.5894487787 4217408.611155957, 1911649.2392204676 4217420.532105807, 1911642.76075887 4217431.390039925, 1911635.2186751203 4217444.365387675, 1911634.531383944 4217446.152229484, 1911632.86076848 4217449.377032233, 1911628.1772161836 4217460.792118896, 1911626.5340487938 4217464.461757561, 1911616.0202954125 4217488.236509624, 1911603.8484487215 4217515.759570524, 1911594.654396934 4217534.763469252, 1911575.0962649616 4217575.700877141, 1911559.5386309077 4217611.059158969, 1911551.127479172 4217642.732225415, 1911540.4128664788 4217687.304603975, 1911536.7490336567 4217757.114630767, 1911539.4862016896 4217828.653760483, 1911528.894275112 4217870.5175299235, 1911520.5688913972 4217903.425314872, 1911509.48980609 4217948.331998946, 1911503.4102446612 4217980.858836541, 1911490.5095578604 4218053.012219294, 1911499.8925786712 4218109.042965196, 1911483.6368242342 4218200.012299377, 1911481.2993667969 4218220.344109055, 1911476.7887374589 4218292.302507013, 1911476.0052694506 4218312.951964458, 1911475.600244661 4218319.166754284, 1911475.4430747917 4218321.6100104675, 1911474.4850145392 4218325.789909653, 1911467.4612070324 4218356.426549825, 1911460.5876730818 4218387.178254812, 1911443.7692984121 4218464.236918223, 1911443.0832847797 4218467.869024269, 1911439.1946121806 4218488.551998945, 1911434.239652221 4218532.803889844, 1911427.8811051864 4218586.676920664, 1911418.159184039 4218660.891593248, 1911410.9997973605 4218694.671110763, 1911402.49858205 4218734.802646091, 1911399.6974831296 4218749.041308994, 1911395.6526615196 4218769.65918288, 1911394.4608541888 4218776.153953793, 1911393.0570041882 4218784.426363483, 1911392.340633636 4218788.629684635, 1911392.0416456475 4218790.391405333, 1911391.779632709 4218791.926601836, 1911391.312579375 4218794.678671955, 1911388.6088939519 4218810.367541613, 1911385.8402919034 4218825.897509837, 1911380.5793097406 4218855.429114737, 1911380.0673219229 4218858.29320598, 1911376.7587053217 4218877.791666275, 1911374.8772064974 4218890.766701354, 1911372.726590716 4218905.390329043, 1911372.2248426308 4218910.846419129, 1911372.0407697915 4218912.779221835, 1911372.6795663356 4218916.078857812, 1911376.1002815543 4218933.67740176, 1911378.4546109962 4218943.971930661, 1911382.6253001422 4218962.197266021, 1911391.0176462948 4218995.450236145, 1911391.773402652 4218999.619324251, 1911392.2318675057 4219002.232803762, 1911392.21695479 4219003.57439721, 1911391.703050729 4219007.649105138, 1911391.3917023505 4219010.08656392, 1911390.8999257346 4219013.554828872, 1911389.268480739 4219025.119627393, 1911381.9763613022 4219076.153753018, 1911382.1497823568 4219081.363754137, 1911384.9988483158 4219103.058624599, 1911394.2451548823 4219127.636835043, 1911399.5744342923 4219216.688822706, 1911401.3235583487 4219275.895698007, 1911417.910308997 4219392.609792256, 1911419.155342687 4219401.438327741, 1911424.2548890787 4219400.584317406, 1911444.4867235068 4219397.778849662, 1911557.228241163 4219378.67419238, 1911569.026724763 4219376.662096937, 1911575.1116275322 4219375.51560123, 1911633.2811384478 4219365.629571475, 1911649.6528611323 4219362.857835051, 1911663.3108112896 4219360.544492418, 1911667.7140018523 4219359.840715794, 1911671.6935572259 4219359.21971034, 1911700.6014308566 4219354.313260542, 1911707.1685800648 4219353.311991448, 1911709.8058179661 4219352.918471264, 1911717.1692937596 4219351.631034339, 1911717.3275234783 4219351.603450523, 1911744.8336348685 4219346.747823887))'::geometry,'38317','Le Pont-de-Claix','LE PONT-DE-<br>CLAIX','PDC','PDC'),
     (13,'SRID=3945;POLYGON ((1910874.8899999573 4230596.530000024, 1910869.7012752988 4230632.127105259, 1910874.1919779903 4230662.615617074, 1910878.4922773372 4230680.172297555, 1910874.0416753523 4230751.723073672, 1910886.6278476864 4230888.442769093, 1910896.5699999935 4230941.250000068, 1910905.107499986 4231043.437499983, 1910856.2300000354 4231057.782499972, 1910782.941250005 4231101.1887499895, 1910756.7787499982 4231124.0587499915, 1910738.7362499991 4231154.4099999955, 1910722.409762065 4231192.19542393, 1910716.315214147 4231188.399585656, 1910689.6405435936 4231101.336751916, 1910680.8863759122 4231083.131066896, 1910666.4792329653 4231070.066698109, 1910647.0044837904 4231049.39895745, 1910608.4226113423 4230976.717287439, 1910594.1625000106 4230956.5975, 1910565.582500005 4230921.166249985, 1910542.035000009 4230898.211249981, 1910520.9374976456 4230882.80393597, 1910506.9170707222 4230875.671159069, 1910499.404068505 4230873.371035804, 1910488.2855652072 4230871.509642473, 1910482.6074999946 4230871.374999968, 1910463.4974999882 4230878.074999967, 1910446.272500023 4230897.0549999215, 1910428.7100000174 4230915.5649999315, 1910387.845526306 4230965.2671406455, 1910284.088952414 4230988.255268197, 1910283.7309102172 4231236.228721502, 1910283.6848525316 4231279.938575361, 1910338.7256141223 4231657.104343039, 1910357.702499946 4231795.629999883, 1910446.6499999936 4232028.094999993, 1910482.0293724593 4232163.181042606, 1910489.5859412616 4232193.050728732, 1910512.5652125224 4232460.897499996, 1910539.6317324808 4232781.249345134, 1910535.491597691 4232780.49856074, 1910535.691297043 4232782.685895463, 1910535.9211955396 4232785.204005608, 1910537.9281697616 4232785.5901946565, 1910545.2155325962 4232872.699344397, 1910582.7327363545 4232926.184834488, 1910585.4791209113 4232930.096909563, 1910586.5238325729 4232931.5815756805, 1910587.223693654 4232932.575879132, 1910621.0309601775 4232980.519359238, 1910655.3249220243 4233029.211017828, 1910661.7913165276 4233038.104300559, 1910698.6181781208 4233089.791639691, 1910720.819934771 4233121.20144947, 1910734.2738778156 4233141.883401128, 1910737.1973711737 4233146.4248787435, 1910740.8422334942 4233152.364169362, 1910744.7377327438 4233158.951525321, 1910757.092752968 4233179.81877582, 1910757.240168437 4233180.068218843, 1910757.2485127083 4233180.082323154, 1910757.365562882 4233180.279811007, 1910757.5450463356 4233180.583418151, 1910757.8319792617 4233181.0688889595, 1910758.9131492272 4233182.898132435, 1910760.1920075722 4233185.0584418345, 1910763.378615017 4233190.450646506, 1910800.7738764912 4233254.245749017, 1910880.3525463135 4233388.735462061, 1910915.3665062592 4233447.907273307, 1910925.2534039752 4233464.535834329, 1910929.8576341502 4233472.295789511, 1910936.2761015033 4233483.115244946, 1910937.3584728637 4233486.609866576, 1910927.222697872 4233631.608260668, 1910927.179895455 4233632.195302914, 1910927.1404834078 4233632.720937741, 1910927.119692503 4233633.007653524, 1910926.0997208094 4233646.960701846, 1910926.145026876 4233648.785372258, 1910926.1356680128 4233650.939473711, 1910934.946750991 4233724.465354268, 1910943.217151334 4233795.0938515775, 1910945.5724999933 4233852.7849999685, 1910952.0452416777 4233874.20311821, 1910952.7390715084 4233877.11023093, 1910956.0213351764 4233883.977775258, 1910962.4605405636 4233897.936105073, 1911068.7824999292 4234121.7275, 1911197.7867003968 4234317.349585022, 1911238.3749999723 4234408.760000033, 1911326.5515586839 4234587.2070344305, 1911368.6044331603 4234677.45546563, 1911402.5449999587 4234755.320000032, 1911448.5564303065 4234858.038573429, 1911462.4061705237 4234914.8579325145, 1911470.6832484654 4234955.302881458, 1911574.9225914269 4235398.6041057855, 1911620.1687497222 4235857.037905646, 1911627.4910032034 4235994.190099847, 1911579.6323157225 4236467.331801684, 1911632.0378947367 4236832.69208502, 1911564.0071903686 4236886.863512418, 1911565.26 4236889.26, 1911612.84 4236998.05, 1911647.56 4237074.61, 1911663.27 4237107.07, 1911675.38 4237129.13, 1911716.05 4237183.18, 1911739.12 4237225.92, 1911770.56 4237279.03, 1911795.84 4237320.4, 1911819.38 4237353.42, 1911838.36 4237379.23, 1911851.55 4237397.74, 1911858.18 4237405.25, 1911870.46 4237415.67, 1911885.19 4237426.52, 1911899.82 4237436.24, 1911915.7 4237446.23, 1911926.92 4237452.09, 1911965.87 4237465.66, 1912031.33 4237497.81, 1912078.05 4237520.72, 1912120.95 4237543.11, 1912151.15 4237564.58, 1912184.99 4237593.17, 1912214.83 4237617.46, 1912264.54 4237647.05, 1912299.49 4237674.41, 1912313.33 4237684.49, 1912323.73 4237691.26, 1912338.96 4237700.79, 1912350.31 4237708.54, 1912380.93 4237736.96, 1912445.83 4237804.5, 1912479.72 4237845.81, 1912485.4 4237852.71, 1912491.56 4237858.18, 1912503.56 4237865.99, 1912514.97 4237873.98, 1912517.76 4237874.52, 1912521.3 4237875.92, 1912601.56 4237934.81, 1912706.42 4238011.18, 1912799.33 4238079.13, 1912926 4238170.84, 1913031.93 4238247.44, 1913139.57 4238325.09, 1913167.34 4238382.48, 1913174.5 4238396.66, 1913175.34 4238398.26, 1913176.66 4238400.75, 1913201.2 4238453.64, 1913232 4238518.15, 1913265.2 4238587.57, 1913290.43 4238640.67, 1913311.82 4238685.14, 1913330.05 4238722.89, 1913371.12 4238808.51, 1913403.43 4238875.58, 1913420.97 4238911.52, 1913439.15 4238949.27, 1913457.49 4238987.45, 1913475.42 4239024.46, 1913485.99 4239046.64, 1913496.7 4239068.58, 1913496.71 4239068.6, 1913516.34 4239109.87, 1913531.82 4239141.45, 1913561.69 4239203.29, 1913577.22 4239235.07, 1913610.38 4239301.96, 1913632.26 4239345.91, 1913659.4 4239400.43, 1913716.5 4239330.01, 1913774.32 4239258.89, 1913831.14 4239189.41, 1913897.3 4239108.58, 1913977.54 4239010.95, 1913993.95 4239027.44, 1913994.01 4239027.51, 1914043.23 4239076.24, 1914066.3 4239098.71, 1914112.92 4239145.09, 1914162.24 4239193.73, 1914171.21 4239196.66, 1914173.13 4239197.26, 1914175.96 4239198.14, 1914285.98 4239234.85, 1914383.95 4239267.92, 1914385.73 4239268.85, 1914387.6 4239269.83, 1914478.7 4239299.47, 1914488.51 4239302.78, 1914574.96 4239355.16, 1914658.27 4239405.47, 1914698.37 4239430.01, 1914700.13 4239431.08, 1914757.9 4239427.57, 1914761.22 4239426.68, 1914774.25 4239423.19, 1914777.35 4239420.92, 1914799.07 4239403.28, 1914801.26 4239401.43, 1914803.16 4239399.82, 1914853.05 4239359.03, 1914859.1 4239354.07, 1914924.37 4239300.54, 1915014.32 4239226.3, 1915047.76 4239198.54, 1915079.93 4239171.83, 1915114.73 4239142.73, 1915121.45 4239137.31, 1915135.98 4239125.59, 1915136.15 4239125.11, 1915136.5 4239124.1, 1915143.81 4239102.98, 1915151.06 4239082.05, 1915154.42 4239072.35, 1915158.71 4239059.99, 1915163.67 4239045.74, 1915175.45 4239011.85, 1915181.7 4238993.85, 1915202.09 4238934.45, 1915230.68 4238851.13, 1915251.02 4238792.46, 1915273.17 4238728.51, 1915277.04 4238717.34, 1915317.06 4238602.1, 1915361.46 4238476.08, 1915369.63 4238452.72, 1915373.24 4238442.39, 1915401.04 4238363.03, 1915475.48 4238325.15, 1915554.18 4238284.49, 1915582.4 4238269.93, 1915592.3 4238264.82, 1915628.27 4238246.29, 1915632.69 4238243.99, 1915690.95 4238213.9, 1915716.6 4238200.24, 1915758.44 4238177.95, 1915758.41 4238176.84, 1915758.35 4238174.22, 1915757.51 4238142.15, 1915756.84 4238124.83, 1915756.31 4238111.42, 1915756.15 4238107.41, 1915757.95 4238106.3, 1915757.16 4238078.96, 1915755.22 4238078.82, 1915754.25 4238043.15, 1915754.98 4238040.23, 1915753.22 4238033.53, 1915752.23 4238016.39, 1915751.82 4237997.46, 1915752.52 4237986.13, 1915752.52 4237963.68, 1915750.86 4237962.44, 1915723.65 4237943.32, 1915692.53 4237921.08, 1915661.57 4237899.24, 1915631.83 4237878.2, 1915607.64 4237864.72, 1915592.54 4237856.48, 1915569.11 4237844.29, 1915546.52 4237832.79, 1915531.37 4237819.8, 1915500.8 4237793.04, 1915478.57 4237773.76, 1915470.95 4237767.25, 1915449.98 4237748.9, 1915444.36 4237742.02, 1915436.66 4237730.97, 1915429.45 4237721, 1915426.87 4237715.97, 1915425.19 4237706.41, 1915423.91 4237701.41, 1915407.36 4237647.52, 1915402.07 4237630.81, 1915391.68 4237600.01, 1915382.32 4237573.08, 1915356.2 4237490.36, 1915324.97 4237391.74, 1915289.52 4237279.91, 1915256.64 4237179.08, 1915256.64 4237179.84236014, 1915220.59 4237064.52, 1915193.87 4236978.49, 1915175.42 4236916.26, 1915169.71 4236898.57, 1915143.65 4236850.5, 1915082.54 4236769.69, 1915066.45 4236748.28, 1915133.06 4236714.65, 1915173.717004107 4236693.37058371, 1915181.67500002 4236587.7949999245, 1915170.2102226734 4236552.554352238, 1915145.8691008498 4236366.324942643, 1915237.5200000303 4236062.520000031, 1914831.0899998979 4235706.209999925, 1914782.7669310726 4235664.564063139, 1914728.199999978 4235538.824999913, 1914692.719999984 4235516.504999996, 1914667.7199999993 4235435.949999981, 1914646.1939473602 4235392.49417003, 1914646.5892712548 4235349.780511134, 1914656.6485864397 4235332.893477964, 1914658.441690136 4235323.58189261, 1914659.3203193336 4235318.996355407, 1914660.697974604 4235315.819321158, 1914675.9894041675 4235279.291342423, 1914695.3659711662 4235246.218654574, 1914699.2748936366 4235225.932831251, 1914661.8282973801 4235153.849552894, 1914603.5326550624 4235068.8504372155, 1914555.7249999805 4235007.970000013, 1914498.3126909165 4234987.544141891, 1914414.59 4234952.75, 1914374.35 4234920.090000007, 1914252.905 4234763.805, 1914172.4268968585 4234672.3027208615, 1914172.7296354466 4234661.256246218, 1914166.230256404 4234652.349618364, 1914161.4817656584 4234639.3463854585, 1914124.59455891 4234616.94614402, 1914102.6649999444 4234588.567499969, 1914092.2097227995 4234554.4904692825, 1914064.1834513964 4234530.900840073, 1914063.9420175569 4234525.171777583, 1914065.4548785903 4234521.643245456, 1914070.469574907 4234515.500020232, 1914107.044599927 4234499.981524805, 1914113.5873154143 4234487.980379654, 1914114.3228636747 4234481.473940393, 1914109.977966355 4234467.15864407, 1914101.436391566 4234457.116153108, 1914098.31 4234448.26, 1914101.4820421566 4234426.35358627, 1914101.5099893096 4234423.908142964, 1914101.2406064286 4234409.088791519, 1914098.1274999825 4234401.487499986, 1914089.0353618918 4234389.636691053, 1914048.5474822847 4234356.230621131, 1914035.0901532331 4234336.300109463, 1914025.4881866486 4234323.463077999, 1914022.1787643803 4234317.460038347, 1914021.6268278805 4234316.410444223, 1914018.2978854484 4234303.712195131, 1914015.9116258437 4234298.119343599, 1914014.2568386525 4234293.892761831, 1913998.8303844917 4234284.6711872695, 1913981.4569064172 4234259.649330551, 1913979.4326253785 4234255.414036171, 1913969.3364389786 4234225.92416268, 1913960.9981034782 4234212.175359976, 1913957.4254507078 4234207.712708883, 1913948.5400243108 4234199.921329572, 1913926.3905257476 4234183.791733963, 1913925.7716518214 4234183.121750805, 1913900.2364768449 4234151.970752539, 1913894.9394899271 4234139.148919156, 1913893.64 4234126.83, 1913899.3012123862 4234102.565542303, 1913917.9201884936 4234066.311195664, 1913917.6266803502 4234054.975119569, 1913916.0272995036 4234055.057561881, 1913914.3379180557 4234055.022420015, 1913914.1049905047 4234050.32073426, 1913855.6220602253 4234052.47211607, 1913811.3674999576 4234045.724999994, 1913762.9716236712 4234025.107276183, 1913730.0234762356 4234018.001221193, 1913669.0924392613 4234020.233846161, 1913647.21 4233962.855, 1913575.535321791 4233777.621180482, 1913573.410808819 4233777.77408477, 1913572.3482952968 4233777.844030344, 1913469.526894986 4233824.56692968, 1913394.9135440374 4233858.493469379, 1913387.4756715246 4233861.915035676, 1913372.0456351803 4233868.996703007, 1913356.3606661889 4233876.054329589, 1913356.2845498815 4233875.817561482, 1913356.19 4233875.86, 1913355.3933147357 4233876.1854750775, 1913350.3776117456 4233860.586030396, 1913345.872415059 4233834.7629363, 1913343.0836808668 4233812.282390601, 1913340.1238143472 4233795.64870933, 1913336.5251306747 4233782.223077934, 1913324.597490438 4233747.785528729, 1913322.416811928 4233742.1277787695, 1913319.928654815 4233736.001059413, 1913316.4709022178 4233729.755687579, 1913310.585067028 4233720.56184867, 1913306.0376069269 4233715.014805806, 1913296.0159714206 4233705.428863536, 1913283.9680930078 4233695.758456906, 1913235.6079150164 4233674.883724721, 1913220.8524797992 4233690.514615425, 1913206.309075854 4233705.561266767, 1913199.501664899 4233713.060217921, 1913193.975456098 4233717.736404985, 1913179.2155969576 4233728.717948878, 1913160.0533060743 4233741.347603881, 1913135.9875881039 4233757.512156987, 1913126.1497116326 4233764.383039337, 1913110.0723548308 4233776.249833708, 1913108.6334939555 4233777.370204057, 1913087.7866326768 4233786.928941116, 1913048.9140802315 4233805.858988525, 1913043.9862302428 4233807.634811175, 1913041.2795334272 4233807.962919644, 1913038.4313004701 4233808.368570602, 1913028.3482233097 4233807.359664366, 1913028.0905600584 4233807.337119496, 1913027.7683718216 4233807.326895137, 1913027.1432700034 4233807.310023285, 1913026.8671680996 4233807.328615475, 1912995.468620634 4233811.498916218, 1912961.178477454 4233818.509410782, 1912938.828991701 4233821.083400619, 1912928.849606474 4233822.5057490235, 1912919.0198133998 4233823.962272364, 1912912.6867028468 4233824.562035046, 1912891.9388286625 4233826.284879946, 1912845.0983094906 4233828.589304801, 1912816.577860971 4233829.239996673, 1912809.2855969253 4233828.637762098, 1912804.834689549 4233828.617484408, 1912790.807059816 4233828.335764445, 1912790.453457399 4233828.265228456, 1912783.2699999516 4233826.444999987, 1912771.177723952 4233822.337651647, 1912746.5120327568 4233807.64708288, 1912739.9474999832 4233804.289999985, 1912729.6174249551 4233801.418535527, 1912710.8419959235 4233798.779615034, 1912681.941376622 4233798.916670257, 1912651.8412809793 4233800.426910569, 1912617.4804673465 4233793.866042783, 1912577.3149999606 4233778.977499972, 1912547.648045912 4233762.838100274, 1912530.1949999896 4233751.807499981, 1912521.5404038432 4233733.081782983, 1912515.5049999948 4233724.557499973, 1912482.134972119 4233690.848252301, 1912463.3127024283 4233672.161670037, 1912439.119919335 4233637.540238144, 1912412.0174125403 4233598.266720957, 1912403.82103857 4233587.867692279, 1912357.3569505035 4233515.044589199, 1912351.2025643259 4233505.228697824, 1912350.1941659858 4233503.307539992, 1912337.8488040906 4233471.0897269985, 1912332.3295396764 4233450.322778557, 1912332.15248013 4233449.356629384, 1912331.5046933508 4233445.819792405, 1912329.4215898288 4233434.341025428, 1912328.635714095 4233431.289482358, 1912326.0647971982 4233421.109399531, 1912323.3031290525 4233414.091115058, 1912322.093103006 4233411.835563936, 1912318.750857588 4233407.296075141, 1912311.3805533652 4233401.832045982, 1912305.3625616906 4233397.664074783, 1912301.4369039023 4233394.968418067, 1912291.1946582708 4233386.344646259, 1912279.3021074526 4233378.5281263245, 1912273.9611271915 4233375.200744771, 1912270.231921894 4233373.585787477, 1912267.66139851 4233372.69409773, 1912247.3181196314 4233369.804039302, 1912233.764119719 4233360.377528438, 1912223.1494887418 4233357.738620865, 1912215.7260514274 4233351.756248221, 1912212.9918449624 4233347.393177167, 1912210.6914428077 4233339.92248321, 1912205.5974037037 4233336.702268301, 1912189.1596390938 4233341.244287023, 1912163.7131720227 4233342.897961503, 1912157.3893151022 4233343.105679431, 1912151.8640551683 4233340.1368394615, 1912142.8866064132 4233328.27006596, 1912127.5937010818 4233318.193817592, 1912096.8263519392 4233304.094693433, 1912083.384284013 4233293.107633411, 1912077.1601900624 4233284.785255801, 1912071.5529732849 4233273.937884659, 1912061.041148605 4233247.41960236, 1912060.0644168786 4233217.42498526, 1912061.5940957814 4233203.935321917, 1912076.9292951773 4233173.689092365, 1912089.1178221013 4233156.911428634, 1912090.3700642558 4233145.279544798, 1912089.0315002922 4233136.963152214, 1912087.9125477022 4233129.77560083, 1912083.1594482558 4233112.938982924, 1912082.2907900214 4233109.173748913, 1912083.6673233018 4233105.544057775, 1912084.7608755408 4233102.944874076, 1912088.2816309582 4233097.090731697, 1912090.5278537727 4233093.510074176, 1912093.3975462934 4233083.864952984, 1912094.791545812 4233075.910315044, 1912095.1966380712 4233073.46142389, 1912095.7380202897 4233072.417135451, 1912098.465504264 4233065.793844677, 1912115.5761367283 4233053.856164443, 1912120.7171581753 4233044.298065478, 1912124.420150803 4233033.5638156785, 1912125.0976655553 4233019.684688421, 1912122.7642105538 4233012.812674018, 1912098.8752299943 4232982.796253569, 1912083.127500008 4232948.252499943, 1912082.4350000026 4232874.069999964, 1912088.8436831003 4232845.082296532, 1912075.555668965 4232819.141145255, 1912070.8680553497 4232809.461647361, 1912070.4952183343 4232801.568852151, 1912077.0705816608 4232774.598707196, 1912064.8474999971 4232710.172499975, 1912064.0608299403 4232674.8423380405, 1912066.2110400277 4232669.675369974, 1912071.177716449 4232667.737112915, 1912074.0911390192 4232666.801460948, 1912100.4369713776 4232663.501690253, 1912117.0041330298 4232654.37458643, 1912119.291263296 4232652.746900572, 1912124.7300739146 4232648.3226854075, 1912131.8097284874 4232640.684347999, 1912135.940192371 4232633.656095178, 1912138.246305675 4232623.767763117, 1912137.6040503527 4232613.657168359, 1912134.814999998 4232605.25499996, 1912129.7000567925 4232594.99254099, 1912116.4042046212 4232583.545916359, 1912115.559495043 4232582.90462946, 1912113.230611737 4232581.615609514, 1912098.0728221515 4232573.164769515, 1912093.1713239742 4232562.398864659, 1912093.555670649 4232536.25233981, 1912092.2303716138 4232529.734175282, 1912083.2018625608 4232514.942142696, 1912081.67 4232513.9, 1912076.8841581221 4232511.357783753, 1912064.7114283722 4232507.04941588, 1912054.7697892878 4232503.442492078, 1912049.5866251718 4232500.9741022745, 1912047.4611675523 4232496.517808818, 1912045.8398301618 4232492.8305000635, 1912051.6629385431 4232476.97875039, 1912052.461740402 4232472.4191714395, 1912051.9488543628 4232469.3499520905, 1912048.540503976 4232461.128786237, 1912044.113215565 4232455.854487978, 1912040.1098953849 4232451.178768762, 1912014.2981220204 4232427.0781941805, 1912007.5338954849 4232419.585827386, 1912005.431827144 4232413.412443024, 1912005.254646895 4232412.561416564, 1912004.920043765 4232410.178795746, 1912006.511520099 4232402.28462978, 1912009.947797375 4232382.25243685, 1912007.6990204877 4232374.842012525, 1912002.0589617235 4232368.79482034, 1911997.113924115 4232367.045703587, 1911993.30258402 4232368.029791108, 1911992.9049712312 4232368.147314238, 1911977.7683305417 4232377.81594223, 1911969.217084879 4232380.674046876, 1911961.0163889283 4232381.72357683, 1911955.370674975 4232378.502646128, 1911955.343349188 4232378.476584719, 1911951.7557633517 4232372.712084835, 1911948.2181627466 4232322.3698781105, 1911945.8487694 4232312.93011126, 1911937.3636654292 4232298.68226974, 1911934.2657267128 4232294.489851396, 1911927.5362650726 4232286.295967492, 1911915.7518915804 4232271.456058238, 1911914.7492352282 4232258.88454015, 1911916.57795845 4232252.911806207, 1911918.5624368605 4232246.588714376, 1911921.4542307693 4232236.274671053, 1911922.7596417484 4232229.394115315, 1911923.1419135735 4232222.152230325, 1911923.1640220042 4232218.612152416, 1911922.1234343476 4232214.219301774, 1911917.724620779 4232208.526886946, 1911906.473891498 4232205.712107742, 1911894.8450000214 4232199.202499987, 1911882.388236916 4232181.818213273, 1911880.3345531079 4232175.362113716, 1911878.7229897073 4232165.461466397, 1911876.3319079028 4232133.150005133, 1911870.0163120774 4232121.733167114, 1911856.5272606222 4232102.523006357, 1911843.9697714152 4232086.882267007, 1911842.2008794262 4232078.748305692, 1911836.5727633568 4232042.963012462, 1911831.6152125346 4232016.445819824, 1911830.4477760755 4232007.336018968, 1911825.0855439524 4231973.502805262, 1911823.3318623235 4231963.565414978, 1911820.4327373856 4231931.328567664, 1911809.6798663803 4231917.223742474, 1911805.2130748688 4231909.0993608115, 1911803.730079167 4231900.85377534, 1911814.3761538544 4231879.60874489, 1911817.2211375642 4231865.767474175, 1911816.4248567852 4231859.738520007, 1911813.3145135967 4231857.144149103, 1911811.1375602065 4231855.260062644, 1911805.0706601313 4231853.152521554, 1911797.25999998 4231856.922499985, 1911776.7070850004 4231870.293127534, 1911753.2376363464 4231879.144280408, 1911734.8238561898 4231879.329392453, 1911727.0437670057 4231876.567228274, 1911725.522154585 4231875.614817513, 1911720.7112348138 4231870.8541396605, 1911716.7571957912 4231860.475297979, 1911719.1049999974 4231852.627499995, 1911741.087111187 4231806.44209646, 1911742.1604954805 4231793.114812602, 1911746.4375000005 4231759.907500002, 1911768.028744552 4231682.65979387, 1911762.267601112 4231677.549591125, 1911758.6703486466 4231675.350217072, 1911758.6471247731 4231675.333428485, 1911725.0303036605 4231623.990563923, 1911718.9371373393 4231616.537971356, 1911707.9045696813 4231610.688780684, 1911698.835216285 4231608.428586303, 1911696.2401872652 4231608.068108396, 1911682.8786234523 4231607.85149796, 1911658.8341870878 4231611.947356385, 1911655.0075896876 4231612.147306349, 1911651.6811509007 4231612.349770745, 1911646.0244493918 4231610.374482905, 1911639.8136399807 4231603.033255607, 1911640.8349999806 4231593.92999998, 1911672.1683906664 4231564.663572889, 1911693.184898775 4231522.832085, 1911709.105 4231477.31, 1911725.0690788352 4231459.701628775, 1911740.0278280042 4231451.496690112, 1911747.132562165 4231450.20996675, 1911760.3816396964 4231461.099625512, 1911770.0747938491 4231466.9966264395, 1911776.9475911784 4231468.4147993, 1911785.3138405713 4231464.992057259, 1911794.5224999906 4231449.9899999825, 1911803.484999989 4231413.522499956, 1911800.5980133107 4231358.077358806, 1911808.3790582034 4231322.373999039, 1911805.662674138 4231312.401983716, 1911791.058673681 4231301.502290184, 1911784.8424522188 4231292.659744318, 1911785.9746407587 4231284.6278485935, 1911800.2199999876 4231264.907499983, 1911821.7528696167 4231253.786690376, 1911834.4483425156 4231244.653892524, 1911839.9224999927 4231232.587499986, 1911834.1399999817 4231200.642499979, 1911808.7843623338 4231168.669757072, 1911804.9412785422 4231158.388112054, 1911809.3309200273 4231136.399278202, 1911821.0774999855 4231109.707500002, 1911828.3278947368 4231075.659210526, 1911828.4975000035 4231012.654999997, 1911824.8625000028 4230989.69, 1911814.7600000051 4230926.392499943, 1911799.777500019 4230908.514999962, 1911782.3175000197 4230895.429999973, 1911758.415000007 4230881.657499966, 1911753.5825000352 4230872.3149999725, 1911700.874387999 4230839.163088498, 1911656.4571423007 4230826.8911903, 1911651.5256629817 4230824.695677294, 1911640.8156520398 4230817.300949652, 1911637.6658570985 4230815.054056328, 1911612.1878389432 4230794.882156329, 1911525.6200000187 4230939.74249998, 1911502.2395827079 4230933.008653541, 1911449.0461516704 4230920.106519592, 1911423.050236773 4230896.056320682, 1911407.1585892905 4230882.489397589, 1911400.915 4230874.445, 1911383.8279372603 4230837.97881042, 1911365.4218159204 4230823.978263628, 1911355.3700000206 4230798.2174999975, 1911332.0125000016 4230761.234999989, 1911314.0575000108 4230732.955000002, 1911304.2850000046 4230715.877499993, 1911305.0864574881 4230691.441690275, 1911320.912116121 4230684.256012874, 1911285.7469083893 4230529.349675864, 1911275.54 4230523.66, 1911242.8850891807 4230517.023935998, 1911215.6401952761 4230511.591505349, 1911203.0700000292 4230494.405000018, 1911204.055000037 4230443.062500002, 1911197.4793404762 4230430.824726836, 1911190.316009416 4230425.970280819, 1911183.023606762 4230422.118487124, 1911158.1825000087 4230417.332499993, 1911131.434999997 4230420.789999995, 1911078.7576517954 4230448.994777343, 1911043.797500001 4230450.212500004, 1910999.6725000113 4230462.360000016, 1910974.7174999933 4230491.31500004, 1910929.7879766123 4230516.233574526, 1910902.149352359 4230524.25254627, 1910890.3974999296 4230570.582500069, 1910874.8899999573 4230596.530000024))'::geometry,'38325','Proveysieux','PROVEYSIEUX','PRO','PVY'),
     (5,'SRID=3945;POLYGON ((1915480.5017314968 4230344.692402755, 1915505.3393851975 4230331.800684707, 1915533.7027791736 4230318.019874527, 1915533.4196226946 4230295.167150922, 1915536.7267037125 4230265.4509356525, 1915538.4263760676 4230232.636384257, 1915540.3855726826 4230163.129007893, 1915535.5379888862 4230101.007582909, 1915527.3365782397 4230065.91694121, 1915522.2865782396 4230025.706731497, 1915539.6754472095 4229985.045013449, 1915546.0100143354 4229950.017387533, 1915543.955 4229908.27, 1915540.68 4229889.29, 1915539.3082229968 4229879.076386844, 1915533.4301675928 4229873.903589354, 1915499.36 4229855.665, 1915491.7684365485 4229850.707807532, 1915481.756783486 4229840.528384801, 1915448.3400488445 4229762.232081018, 1915434.5202971203 4229735.773434875, 1915431.3013843973 4229730.742255504, 1915431.679481936 4229730.687959514, 1915430.115464345 4229728.6045054225, 1915428.2548117978 4229726.125898927, 1915426.8622820296 4229724.687682526, 1915426.698759669 4229705.592488993, 1915427.2210891345 4229691.324032104, 1915425.7275000063 4229685.24249998, 1915417.820000015 4229672.537499992, 1915393.122499999 4229648.790000001, 1915329.5900000136 4229580.5325, 1915309.8564589787 4229557.168729014, 1915277.0977802507 4229476.142667334, 1915273.2900000021 4229453.10499994, 1915265.1850000187 4229432.054999979, 1915251.065000018 4229410.665000003, 1915235.5250000167 4229387.404999999, 1915229.1900000381 4229359.199999998, 1915210.8925414507 4229320.081338224, 1915181.2709105818 4229254.027170825, 1915163.9983250934 4229209.741167216, 1915133.0649999962 4229186.614999994, 1915130.5838586541 4229185.9450418735, 1915128.598182005 4229186.138208205, 1915127.8138880779 4229185.586371071, 1915126.4877217629 4229185.742315837, 1915121.5256434132 4229186.152757107, 1915119.2 4229186.03, 1915118.8133498968 4229185.050267959, 1915117.4603046428 4229186.261096511, 1915103.7311857746 4229188.564347826, 1915101.5948902885 4229188.911657081, 1915101.2204554288 4229189.246859717, 1915100.8590727719 4229189.693984363, 1915101.0558010323 4229196.783172422, 1915102.2703851727 4229244.22336322, 1915104.4998528475 4229293.73613007, 1915104.5154552374 4229349.612387539, 1915104.7476317228 4229384.809856806, 1915105.0230784398 4229409.669208585, 1915106.4507930009 4229469.7143959245, 1915109.9151095273 4229586.604455039, 1915108.5113425911 4229588.887705237, 1915104.9067114408 4229594.561896235, 1914698.3622520308 4229761.925597003, 1914637.6699473958 4229786.874393639, 1914634.591378626 4229787.710638428, 1914505.7119450106 4229840.657908454, 1914501.4041797423 4229841.737566848, 1914431.7651931245 4229847.898134963, 1914400.3104821832 4229850.456629553, 1914374.9608463163 4229852.60744224, 1914277.1768487385 4229860.654846602, 1914185.09565325 4229868.251871791, 1914124.5682602825 4229873.8925824175, 1914058.5827130727 4229879.5967563605, 1913819.4881918614 4229899.754085402, 1913604.2605599791 4229873.896519331, 1913426.7234322897 4229853.140118749, 1913423.599004971 4229860.465523835, 1913398.916127355 4229918.203871911, 1913363.3909600812 4229988.138567781, 1913329.8134060777 4230043.839399959, 1913306.89 4230090.4, 1913305.8696480559 4230090.259755652, 1913305.0227736467 4230091.800415635, 1913155.1556636658 4230070.824662207, 1913029.4289923487 4230053.332415173, 1912898.2010619822 4230035.253303161, 1912717.4568228242 4230010.505668035, 1912717.1414654136 4230009.844858962, 1912712.7774787543 4230007.906919103, 1912676.497510177 4230148.667084984, 1912661.0612449828 4230202.106143733, 1912649.4950000653 4230241.689999955, 1912604.8800000246 4230298.254999991, 1912580.6550000077 4230328.825000001, 1912552.4325000215 4230380.9525, 1912525.9278900395 4230429.462462417, 1912512.0765867317 4230466.8976903055, 1912500.0194212436 4230527.723929938, 1912496.318738551 4230552.629559084, 1912492.910861727 4230577.160274249, 1912484.372843955 4230617.622180934, 1912472.0455305516 4230676.405223131, 1912470.7463711617 4230675.9296156475, 1912469.3245667876 4230682.03887567, 1912469.1040396036 4230682.986783768, 1912469.077470778 4230683.101717662, 1912469.006660111 4230683.424754257, 1912468.6444831905 4230685.080488521, 1912465.804130744 4230698.062051612, 1912227.804999942 4230605.084999953, 1912080.1650000783 4230587.32499997, 1911975.5129499063 4230634.754549818, 1911964.8942733346 4230641.388125389, 1911936.857500016 4230664.495000014, 1911897.7100000037 4230686.782500016, 1911870.8106612784 4230723.722077856, 1911829.9437230008 4230778.0475716395, 1911792.9046392331 4230816.41199285, 1911753.5825000352 4230872.3149999725, 1911758.415000007 4230881.657499966, 1911782.3175000197 4230895.429999973, 1911799.777500019 4230908.514999962, 1911814.7600000051 4230926.392499943, 1911824.8625000028 4230989.69, 1911828.4975000035 4231012.654999997, 1911828.3278947368 4231075.659210526, 1911821.0774999855 4231109.707500002, 1911809.3309200273 4231136.399278202, 1911804.9412785422 4231158.388112054, 1911808.7843623338 4231168.669757072, 1911834.1399999817 4231200.642499979, 1911839.9224999927 4231232.587499986, 1911834.4483425156 4231244.653892524, 1911821.7528696167 4231253.786690376, 1911800.2199999876 4231264.907499983, 1911785.9746407587 4231284.6278485935, 1911784.8424522188 4231292.659744318, 1911791.058673681 4231301.502290184, 1911805.662674138 4231312.401983716, 1911808.3790582034 4231322.373999039, 1911800.5980133107 4231358.077358806, 1911803.484999989 4231413.522499956, 1911794.5224999906 4231449.9899999825, 1911785.3138405713 4231464.992057259, 1911776.9475911784 4231468.4147993, 1911770.0747938491 4231466.9966264395, 1911760.3816396964 4231461.099625512, 1911747.132562165 4231450.20996675, 1911740.0278280042 4231451.496690112, 1911725.0690788352 4231459.701628775, 1911709.105 4231477.31, 1911693.184898775 4231522.832085, 1911672.1683906664 4231564.663572889, 1911640.8349999806 4231593.92999998, 1911639.8136399807 4231603.033255607, 1911646.0244493918 4231610.374482905, 1911651.6811509007 4231612.349770745, 1911655.0075896876 4231612.147306349, 1911658.8341870878 4231611.947356385, 1911682.8786234523 4231607.85149796, 1911696.2401872652 4231608.068108396, 1911698.835216285 4231608.428586303, 1911707.9045696813 4231610.688780684, 1911718.9371373393 4231616.537971356, 1911725.0303036605 4231623.990563923, 1911758.6471247731 4231675.333428485, 1911758.6703486466 4231675.350217072, 1911762.267601112 4231677.549591125, 1911768.028744552 4231682.65979387, 1911746.4375000005 4231759.907500002, 1911742.1604954805 4231793.114812602, 1911741.087111187 4231806.44209646, 1911719.1049999974 4231852.627499995, 1911716.7571957912 4231860.475297979, 1911720.7112348138 4231870.8541396605, 1911725.522154585 4231875.614817513, 1911727.0437670057 4231876.567228274, 1911734.8238561898 4231879.329392453, 1911753.2376363464 4231879.144280408, 1911776.7070850004 4231870.293127534, 1911797.25999998 4231856.922499985, 1911805.0706601313 4231853.152521554, 1911811.1375602065 4231855.260062644, 1911813.3145135967 4231857.144149103, 1911816.4248567852 4231859.738520007, 1911817.2211375642 4231865.767474175, 1911814.3761538544 4231879.60874489, 1911803.730079167 4231900.85377534, 1911805.2130748688 4231909.0993608115, 1911809.6798663803 4231917.223742474, 1911820.4327373856 4231931.328567664, 1911823.3318623235 4231963.565414978, 1911825.0855439524 4231973.502805262, 1911830.4477760755 4232007.336018968, 1911831.6152125346 4232016.445819824, 1911836.5727633568 4232042.963012462, 1911842.2008794262 4232078.748305692, 1911843.9697714152 4232086.882267007, 1911856.5272606222 4232102.523006357, 1911870.0163120774 4232121.733167114, 1911876.3319079028 4232133.150005133, 1911878.7229897073 4232165.461466397, 1911880.3345531079 4232175.362113716, 1911882.388236916 4232181.818213273, 1911894.8450000214 4232199.202499987, 1911906.473891498 4232205.712107742, 1911917.724620779 4232208.526886946, 1911922.1234343476 4232214.219301774, 1911923.1640220042 4232218.612152416, 1911923.1419135735 4232222.152230325, 1911922.7596417484 4232229.394115315, 1911921.4542307693 4232236.274671053, 1911918.5624368605 4232246.588714376, 1911916.57795845 4232252.911806207, 1911914.7492352282 4232258.88454015, 1911915.7518915804 4232271.456058238, 1911927.5362650726 4232286.295967492, 1911934.2657267128 4232294.489851396, 1911937.3636654292 4232298.68226974, 1911945.8487694 4232312.93011126, 1911948.2181627466 4232322.3698781105, 1911951.7557633517 4232372.712084835, 1911955.343349188 4232378.476584719, 1911955.370674975 4232378.502646128, 1911961.0163889283 4232381.72357683, 1911969.217084879 4232380.674046876, 1911977.7683305417 4232377.81594223, 1911992.9049712312 4232368.147314238, 1911993.30258402 4232368.029791108, 1911997.113924115 4232367.045703587, 1912002.0589617235 4232368.79482034, 1912007.6990204877 4232374.842012525, 1912009.947797375 4232382.25243685, 1912006.511520099 4232402.28462978, 1912004.920043765 4232410.178795746, 1912005.254646895 4232412.561416564, 1912005.431827144 4232413.412443024, 1912007.5338954849 4232419.585827386, 1912014.2981220204 4232427.0781941805, 1912040.1098953849 4232451.178768762, 1912044.113215565 4232455.854487978, 1912048.540503976 4232461.128786237, 1912051.9488543628 4232469.3499520905, 1912052.461740402 4232472.4191714395, 1912051.6629385431 4232476.97875039, 1912045.8398301618 4232492.8305000635, 1912047.4611675523 4232496.517808818, 1912049.5866251718 4232500.9741022745, 1912054.7697892878 4232503.442492078, 1912064.7114283722 4232507.04941588, 1912076.8841581221 4232511.357783753, 1912081.67 4232513.9, 1912083.2018625608 4232514.942142696, 1912092.2303716138 4232529.734175282, 1912093.555670649 4232536.25233981, 1912093.1713239742 4232562.398864659, 1912098.0728221515 4232573.164769515, 1912113.230611737 4232581.615609514, 1912115.559495043 4232582.90462946, 1912116.4042046212 4232583.545916359, 1912129.7000567925 4232594.99254099, 1912134.814999998 4232605.25499996, 1912137.6040503527 4232613.657168359, 1912138.246305675 4232623.767763117, 1912135.940192371 4232633.656095178, 1912131.8097284874 4232640.684347999, 1912124.7300739146 4232648.3226854075, 1912119.291263296 4232652.746900572, 1912117.0041330298 4232654.37458643, 1912100.4369713776 4232663.501690253, 1912074.0911390192 4232666.801460948, 1912071.177716449 4232667.737112915, 1912066.2110400277 4232669.675369974, 1912064.0608299403 4232674.8423380405, 1912064.8474999971 4232710.172499975, 1912077.0705816608 4232774.598707196, 1912070.4952183343 4232801.568852151, 1912070.8680553497 4232809.461647361, 1912075.555668965 4232819.141145255, 1912088.8436831003 4232845.082296532, 1912082.4350000026 4232874.069999964, 1912083.127500008 4232948.252499943, 1912098.8752299943 4232982.796253569, 1912122.7642105538 4233012.812674018, 1912125.0976655553 4233019.684688421, 1912124.420150803 4233033.5638156785, 1912120.7171581753 4233044.298065478, 1912115.5761367283 4233053.856164443, 1912098.465504264 4233065.793844677, 1912095.7380202897 4233072.417135451, 1912095.1966380712 4233073.46142389, 1912094.791545812 4233075.910315044, 1912093.3975462934 4233083.864952984, 1912090.5278537727 4233093.510074176, 1912088.2816309582 4233097.090731697, 1912084.7608755408 4233102.944874076, 1912083.6673233018 4233105.544057775, 1912082.2907900214 4233109.173748913, 1912083.1594482558 4233112.938982924, 1912087.9125477022 4233129.77560083, 1912089.0315002922 4233136.963152214, 1912090.3700642558 4233145.279544798, 1912089.1178221013 4233156.911428634, 1912076.9292951773 4233173.689092365, 1912061.5940957814 4233203.935321917, 1912060.0644168786 4233217.42498526, 1912061.041148605 4233247.41960236, 1912071.5529732849 4233273.937884659, 1912077.1601900624 4233284.785255801, 1912083.384284013 4233293.107633411, 1912096.8263519392 4233304.094693433, 1912127.5937010818 4233318.193817592, 1912142.8866064132 4233328.27006596, 1912151.8640551683 4233340.1368394615, 1912157.3893151022 4233343.105679431, 1912163.7131720227 4233342.897961503, 1912189.1596390938 4233341.244287023, 1912205.5974037037 4233336.702268301, 1912210.6914428077 4233339.92248321, 1912212.9918449624 4233347.393177167, 1912215.7260514274 4233351.756248221, 1912223.1494887418 4233357.738620865, 1912233.764119719 4233360.377528438, 1912247.3181196314 4233369.804039302, 1912267.66139851 4233372.69409773, 1912270.231921894 4233373.585787477, 1912273.9611271915 4233375.200744771, 1912279.3021074526 4233378.5281263245, 1912291.1946582708 4233386.344646259, 1912301.4369039023 4233394.968418067, 1912305.3625616906 4233397.664074783, 1912311.3805533652 4233401.832045982, 1912318.750857588 4233407.296075141, 1912322.093103006 4233411.835563936, 1912323.3031290525 4233414.091115058, 1912326.0647971982 4233421.109399531, 1912328.635714095 4233431.289482358, 1912329.4215898288 4233434.341025428, 1912331.5046933508 4233445.819792405, 1912332.15248013 4233449.356629384, 1912332.3295396764 4233450.322778557, 1912337.8488040906 4233471.0897269985, 1912350.1941659858 4233503.307539992, 1912351.2025643259 4233505.228697824, 1912357.3569505035 4233515.044589199, 1912403.82103857 4233587.867692279, 1912412.0174125403 4233598.266720957, 1912439.119919335 4233637.540238144, 1912463.3127024283 4233672.161670037, 1912482.134972119 4233690.848252301, 1912515.5049999948 4233724.557499973, 1912521.5404038432 4233733.081782983, 1912530.1949999896 4233751.807499981, 1912547.648045912 4233762.838100274, 1912577.3149999606 4233778.977499972, 1912617.4804673465 4233793.866042783, 1912651.8412809793 4233800.426910569, 1912681.941376622 4233798.916670257, 1912710.8419959235 4233798.779615034, 1912729.6174249551 4233801.418535527, 1912739.9474999832 4233804.289999985, 1912746.5120327568 4233807.64708288, 1912771.177723952 4233822.337651647, 1912783.2699999516 4233826.444999987, 1912790.453457399 4233828.265228456, 1912790.807059816 4233828.335764445, 1912804.834689549 4233828.617484408, 1912809.2855969253 4233828.637762098, 1912816.577860971 4233829.239996673, 1912845.0983094906 4233828.589304801, 1912891.9388286625 4233826.284879946, 1912912.6867028468 4233824.562035046, 1912919.0198133998 4233823.962272364, 1912928.849606474 4233822.5057490235, 1912938.828991701 4233821.083400619, 1912961.178477454 4233818.509410782, 1912995.468620634 4233811.498916218, 1913026.8671680996 4233807.328615475, 1913027.1432700034 4233807.310023285, 1913027.7683718216 4233807.326895137, 1913028.0905600584 4233807.337119496, 1913028.3482233097 4233807.359664366, 1913038.4313004701 4233808.368570602, 1913041.2795334272 4233807.962919644, 1913043.9862302428 4233807.634811175, 1913048.9140802315 4233805.858988525, 1913087.7866326768 4233786.928941116, 1913108.6334939555 4233777.370204057, 1913110.0723548308 4233776.249833708, 1913126.1497116326 4233764.383039337, 1913135.9875881039 4233757.512156987, 1913160.0533060743 4233741.347603881, 1913179.2155969576 4233728.717948878, 1913193.975456098 4233717.736404985, 1913199.501664899 4233713.060217921, 1913206.309075854 4233705.561266767, 1913220.8524797992 4233690.514615425, 1913235.6079150164 4233674.883724721, 1913283.9680930078 4233695.758456906, 1913296.0159714206 4233705.428863536, 1913306.0376069269 4233715.014805806, 1913310.585067028 4233720.56184867, 1913316.4709022178 4233729.755687579, 1913319.928654815 4233736.001059413, 1913322.416811928 4233742.1277787695, 1913324.597490438 4233747.785528729, 1913336.5251306747 4233782.223077934, 1913340.1238143472 4233795.64870933, 1913343.0836808668 4233812.282390601, 1913345.872415059 4233834.7629363, 1913350.3776117456 4233860.586030396, 1913355.3933147357 4233876.1854750775, 1913356.19 4233875.86, 1913356.2845498815 4233875.817561482, 1913356.3606661889 4233876.054329589, 1913372.0456351803 4233868.996703007, 1913387.4756715246 4233861.915035676, 1913394.9135440374 4233858.493469379, 1913469.526894986 4233824.56692968, 1913572.3482952968 4233777.844030344, 1913573.410808819 4233777.77408477, 1913575.535321791 4233777.621180482, 1913647.21 4233962.855, 1913669.0924392613 4234020.233846161, 1913730.0234762356 4234018.001221193, 1913762.9716236712 4234025.107276183, 1913811.3674999576 4234045.724999994, 1913855.6220602253 4234052.47211607, 1913914.1049905047 4234050.32073426, 1913914.3379180557 4234055.022420015, 1913916.0272995036 4234055.057561881, 1913917.6266803502 4234054.975119569, 1913917.9201884936 4234066.311195664, 1913899.3012123862 4234102.565542303, 1913893.64 4234126.83, 1913894.9394899271 4234139.148919156, 1913900.2364768449 4234151.970752539, 1913925.7716518214 4234183.121750805, 1913926.3905257476 4234183.791733963, 1913948.5400243108 4234199.921329572, 1913957.4254507078 4234207.712708883, 1913960.9981034782 4234212.175359976, 1913969.3364389786 4234225.92416268, 1913979.4326253785 4234255.414036171, 1913981.4569064172 4234259.649330551, 1913998.8303844917 4234284.6711872695, 1914014.2568386525 4234293.892761831, 1914015.9116258437 4234298.119343599, 1914018.2978854484 4234303.712195131, 1914021.6268278805 4234316.410444223, 1914022.1787643803 4234317.460038347, 1914025.4881866486 4234323.463077999, 1914035.0901532331 4234336.300109463, 1914048.5474822847 4234356.230621131, 1914089.0353618918 4234389.636691053, 1914098.1274999825 4234401.487499986, 1914101.2406064286 4234409.088791519, 1914101.5099893096 4234423.908142964, 1914101.4820421566 4234426.35358627, 1914098.31 4234448.26, 1914101.436391566 4234457.116153108, 1914109.977966355 4234467.15864407, 1914114.3228636747 4234481.473940393, 1914113.5873154143 4234487.980379654, 1914107.044599927 4234499.981524805, 1914070.469574907 4234515.500020232, 1914065.4548785903 4234521.643245456, 1914063.9420175569 4234525.171777583, 1914064.1834513964 4234530.900840073, 1914092.2097227995 4234554.4904692825, 1914102.6649999444 4234588.567499969, 1914124.59455891 4234616.94614402, 1914161.4817656584 4234639.3463854585, 1914166.230256404 4234652.349618364, 1914172.7296354466 4234661.256246218, 1914172.4268968585 4234672.3027208615, 1914252.905 4234763.805, 1914374.35 4234920.090000007, 1914414.59 4234952.75, 1914498.3126909165 4234987.544141891, 1914555.7249999805 4235007.970000013, 1914603.5326550624 4235068.8504372155, 1914661.8282973801 4235153.849552894, 1914699.2748936366 4235225.932831251, 1914695.3659711662 4235246.218654574, 1914675.9894041675 4235279.291342423, 1914660.697974604 4235315.819321158, 1914659.3203193336 4235318.996355407, 1914658.441690136 4235323.58189261, 1914656.6485864397 4235332.893477964, 1914646.5892712548 4235349.780511134, 1914646.1939473602 4235392.49417003, 1914667.7199999993 4235435.949999981, 1914692.719999984 4235516.504999996, 1914728.199999978 4235538.824999913, 1914782.7669310726 4235664.564063139, 1914795.4650000005 4235645.705000007, 1915098.4196476645 4235237.108215043, 1915361.972411523 4234881.25870883, 1915373.0778836855 4234861.223920035, 1915413.366037708 4234783.850136779, 1915435.6398997256 4234740.533167623, 1915438.7597981335 4234733.763637902, 1915440.8370294648 4234728.115247002, 1915441.793454863 4234725.479768721, 1915443.8888088483 4234717.916449647, 1915446.5466408273 4234708.294764978, 1915464.6106477352 4234644.366457529, 1915481.9534707165 4234596.605319343, 1915483.808625669 4234569.750416477, 1915486.6507939221 4234510.781906913, 1915487.8414934278 4234281.30218306, 1915488.4179402776 4234146.884508821, 1915488.714091642 4234091.051436168, 1915488.9953119478 4234015.048527898, 1915489.7378994247 4233967.219548884, 1915489.901675108 4233961.414436621, 1915490.1030410076 4233954.332466519, 1915490.2792796472 4233947.817733838, 1915491.0824764946 4233917.686316766, 1915491.7286814288 4233917.65243806, 1915491.830927873 4233915.345407282, 1915558.7803296857 4233913.192493932, 1915565.1676631558 4233909.7477466175, 1915572.2117419285 4233903.452200442, 1915625.1137992886 4233822.822084951, 1915671.4841704427 4233715.041789685, 1915734.51859566 4233632.253577687, 1915736.2845595707 4233627.465388497, 1915738.362889671 4233614.32175612, 1915737.0666354154 4233587.512731816, 1915739.530763869 4233579.577693039, 1915740.8781027955 4233575.689582983, 1915748.9169108532 4233564.145732268, 1915756.2268058532 4233554.833476296, 1915765.6817661708 4233544.260951446, 1915826.5632216437 4233486.727534689, 1915832.4907100918 4233486.165915887, 1915857.6924999948 4233560.183750048, 1915890.0919584804 4233611.53591104, 1915904.624442498 4233621.568560307, 1915902.1241183784 4233615.989545278, 1915906.29 4233618.96, 1915905.1620056336 4233613.52815305, 1915879.1858275717 4233567.186226892, 1915877.8748291372 4233556.148035623, 1915889.7396248407 4233539.223092526, 1915896.203124229 4233531.681212862, 1915905.6999795472 4233521.065833533, 1915914.282809254 4233511.390710107, 1915917.652584162 4233501.581577074, 1915922.4131275204 4233456.55447875, 1915937.699608031 4233400.823363934, 1915942.2939619161 4233392.780421383, 1915943.6051605046 4233396.059120533, 1915944.9921475125 4233394.5234312145, 1915959.1229313964 4233432.723701798, 1915959.6024696175 4233433.972695247, 1915960.110400589 4233434.670902285, 1915962.6589556017 4233438.282613986, 1915974.3137500014 4233442.246249971, 1915981.0671398537 4233454.543133651, 1915983.6488313272 4233457.955276993, 1915987.8797545831 4233461.049626779, 1916002.279052679 4233470.6552789295, 1916009.5675000018 4233476.368750001, 1916023.1462258135 4233496.401280443, 1916036.9007874078 4233510.946283547, 1916047.786366453 4233523.8045465695, 1916054.7689424474 4233532.148663253, 1916065.7930793623 4233545.062187641, 1916068.8917557567 4233547.910935446, 1916072.3991795636 4233550.67601838, 1916080.5762324638 4233556.5996993985, 1916087.5851460814 4233561.659311335, 1916092.43939975 4233567.701986088, 1916096.135368512 4233572.430844269, 1916103.3183524983 4233578.2529901285, 1916138.6634773372 4233594.447281137, 1916144.8687961074 4233600.043286678, 1916161.7890524147 4233613.966528868, 1916176.1611141937 4233637.423659475, 1916190.5370325788 4233644.761366452, 1916189.9825323941 4233642.632595628, 1916191.3166557457 4233641.855205685, 1916182.491787081 4233609.721532952, 1916175.9349595143 4233582.725182187, 1916161.3751780367 4233535.305985328, 1916159.882000625 4233526.331261234, 1916160.8851369156 4233519.443230895, 1916163.1429897412 4233509.528164671, 1916175.1671113574 4233474.448773176, 1916179.7158188908 4233464.223086595, 1916186.1638768055 4233435.495814793, 1916185.1560504353 4233425.7634174945, 1916182.4240495022 4233419.988950967, 1916173.1753085542 4233410.446612153, 1916162.437551372 4233398.97433293, 1916157.5489324818 4233392.534778993, 1916146.120262753 4233374.375872527, 1916125.418262299 4233331.207747358, 1916117.406356271 4233297.342297565, 1916169.9267532062 4233276.892891686, 1916184.0173578267 4233273.8957255725, 1916198.7231068655 4233261.015570077, 1916227.4083855953 4233264.62207996, 1916260.1620268014 4233273.543680214, 1916264.4628912963 4233266.33776765, 1916266.0356621668 4233242.525437672, 1916280.685441107 4233238.469036834, 1916295.3702119559 4233229.030762697, 1916309.8105371487 4233229.686236382, 1916321.1778999984 4233237.4824626045, 1916338.7234399123 4233251.064745082, 1916363.9992317155 4233269.007015987, 1916415.0040789426 4233281.646022264, 1916461.329325556 4233274.489607236, 1916504.960307622 4233290.347374791, 1916592.7137499852 4233295.653749984, 1916634.331788571 4233295.722851725, 1916629.580248998 4233279.890885846, 1916627.6639473476 4233274.918697908, 1916622.5466536349 4233251.424598634, 1916620.8341230296 4233241.643233452, 1916619.5984669607 4233234.568989348, 1916616.4119710159 4233220.7413753215, 1916615.0946193265 4233209.881967186, 1916612.639751493 4233175.111865041, 1916632.207236849 4233148.210576941, 1916645.9824813902 4233073.287663298, 1916646.799223845 4233071.480729351, 1916657.5352727517 4233050.111129015, 1916663.1134029336 4233013.874164341, 1916663.1140856133 4233012.351019711, 1916659.882499986 4232953.977499999, 1916623.2855596794 4232894.12681721, 1916611.992942502 4232830.45714314, 1916607.5157291654 4232813.057823007, 1916589.658157278 4232776.2626129035, 1916569.8004251763 4232751.4010961, 1916542.8908068687 4232717.710746954, 1916497.1337499793 4232660.423749983, 1916481.4138552027 4232635.966845924, 1916479.8589312276 4232626.354560361, 1916478.8067714323 4232618.1563490415, 1916477.1094456743 4232601.8229185445, 1916477.337500006 4232573.562499976, 1916486.5337500104 4232545.1237499975, 1916510.4556593944 4232470.277023433, 1916509.1855718663 4232451.4420394655, 1916504.6386390023 4232430.7752583455, 1916499.85 4232407.09, 1916457.884280625 4232227.845906202, 1916427.0915620117 4232085.707404615, 1916428.2787704428 4232002.906033264, 1916426.5699999954 4231935.904999999, 1916426.4506816275 4231865.083526439, 1916428.0867480708 4231839.142892185, 1916430.8521991319 4231792.625137606, 1916430.8081719454 4231774.143576211, 1916443.5612381669 4231748.365143307, 1916455.5681762414 4231724.113447365, 1916550.3072665588 4231607.06481922, 1916581.802499978 4231548.0000000065, 1916602.1718816317 4231474.47039113, 1916632.0099999837 4231419.339999948, 1916683.9423937113 4231309.811821868, 1916730.1637499884 4231204.92874999, 1916800.4952244656 4231049.2330625495, 1916858.0809362535 4231001.513097173, 1916932.532618997 4230938.400827164, 1916932.0227012034 4230937.971578142, 1916892.4832836855 4230914.0978545435, 1916891.6408354817 4230913.530421725, 1916876.17367965 4230904.740333742, 1916869.5560214308 4230901.845739556, 1916854.859919931 4230899.386481147, 1916839.8749503442 4230899.1592782065, 1916822.9499999483 4230901.513749973, 1916806.201872496 4230897.318738441, 1916809.0801291068 4230892.7273759665, 1916772.524999985 4230875.873749987, 1916748.028398749 4230874.983519307, 1916725.3399999852 4230883.101249994, 1916699.4815334051 4230878.735050588, 1916667.4425101234 4230889.315283397, 1916658.21794655 4230888.581576894, 1916653.6073510533 4230884.967248081, 1916633.2428853647 4230857.848726434, 1916625.5690927096 4230851.102706904, 1916614.9449220817 4230849.970882771, 1916594.7706477735 4230857.347226721, 1916572.6939271255 4230846.785566802, 1916519.303340081 4230836.952145749, 1916483.788319838 4230825.757813766, 1916451.0795546558 4230812.4248178145, 1916431.808117409 4230817.266882592, 1916407.4190308917 4230811.161490972, 1916368.3583281813 4230809.558330622, 1916355.0803441296 4230808.006578947, 1916331.65659919 4230813.278380567, 1916321.5432186234 4230811.227914981, 1916318.5766396758 4230808.138967611, 1916312.7664571737 4230798.983698838, 1916310.7782414895 4230794.080675148, 1916308.1335514688 4230786.1773572955, 1916306.8906787243 4230758.403169725, 1916305.096844184 4230755.176107383, 1916296.854760607 4230739.85717449, 1916288.5237449391 4230737.500040486, 1916249.3758704453 4230745.791012146, 1916237.9622279475 4230744.133610046, 1916225.540826558 4230740.381462399, 1916210.7443788669 4230703.888603551, 1916197.438972833 4230679.541306476, 1916182.4136234818 4230667.963967611, 1916164.8416599191 4230662.3723684205, 1916148.9956072876 4230662.01228745, 1916128.3463360325 4230665.557914981, 1916114.5525506071 4230673.735040486, 1916109.5102024307 4230678.201577382, 1916086.957327938 4230701.3094391255, 1916080.9225358402 4230714.281413371, 1916074.4575945989 4230723.698688636, 1916058.0507749927 4230738.450434438, 1916038.6295546559 4230760.85277328, 1916024.8632549974 4230771.209613435, 1916003.8254655872 4230773.169817814, 1915984.882388664 4230777.641963563, 1915965.4843522268 4230791.210060729, 1915955.2267503655 4230791.430945244, 1915949.411335384 4230785.624459849, 1915946.7165471867 4230770.663991329, 1915945.0119396928 4230765.098550075, 1915929.9309547872 4230755.507481558, 1915917.7840491578 4230746.53917674, 1915911.4740554495 4230738.955004117, 1915904.2126586307 4230730.772381972, 1915901.4293522912 4230722.035561717, 1915903.6024493927 4230709.3002226725, 1915913.2332011694 4230694.858878658, 1915913.912361308 4230688.122274229, 1915908.6308909522 4230678.654548101, 1915907.3613139226 4230677.127494119, 1915902.5312340031 4230673.935061614, 1915895.9267493666 4230673.581982635, 1915884.3698700236 4230674.48037622, 1915871.08645749 4230677.954696357, 1915856.9119928612 4230686.423376224, 1915839.2327593477 4230698.577272224, 1915834.675180699 4230698.102413038, 1915813.263570126 4230694.712307572, 1915804.9419626119 4230694.995156133, 1915798.8734866248 4230699.4500322, 1915797.1302593262 4230701.711049785, 1915794.7292165689 4230706.579626741, 1915793.0656781378 4230716.015946356, 1915789.8194331983 4230727.714665991, 1915757.7910323888 4230755.824170041, 1915711.291619433 4230779.024595141, 1915706.6222469634 4230791.051133604, 1915711.743036437 4230825.863421053, 1915704.9370850201 4230842.956234817, 1915688.676882591 4230859.573441296, 1915653.7476923077 4230874.1922672065, 1915644.0851012145 4230899.700890688, 1915615.5611133603 4230945.643663968, 1915616.0058704456 4230966.62805668, 1915601.5126518218 4230981.617834008, 1915574.9047975708 4230987.898097166, 1915559.543771862 4231007.70831685, 1915550.024965483 4231009.435979454, 1915541.725493114 4231010.348173152, 1915527.2069383187 4231008.394719284, 1915500.4084615386 4231005.0271862345, 1915392.6670827186 4231063.102510369, 1915390.0945114235 4231056.906623715, 1915385.2853797928 4231059.708884053, 1915365.3496370302 4231015.656370432, 1915362.4160897965 4230933.54261158, 1915401.8642597245 4230902.785502778, 1915375.2139676714 4230679.040132496, 1915388.9472325572 4230449.464222367, 1915415.762598132 4230420.966871305, 1915480.5017314968 4230344.692402755))'::geometry,'38328','Quaix-en-Chartreuse','QUAIX-EN-<br>CHARTREUSE','QEC','QEC'),
     (31,'SRID=3945;POLYGON ((1924202.39 4208229.18, 1924199.01 4208228.85, 1924196.19 4208228.94, 1924192.63 4208228.76, 1924000.3 4208211.4, 1923993.19 4208211.51, 1923989.78 4208211.86, 1923987.42 4208212.55, 1923982.56 4208209.85, 1923977.49 4208207.05, 1923954.29 4208204.62, 1923860.83 4208196.99, 1923795.98 4208191.62, 1923772.61 4208189.6, 1923743.28 4208187.19, 1923705.42 4208184.22, 1923653.07 4208179.74, 1923631.15 4208176.36, 1923628.04 4208167.53, 1923623.89 4208154.05, 1923614.79 4208125.73, 1923608.57 4208105.01, 1923601.22 4208081.21, 1923591.74 4208050.57, 1923587.49 4208036.19, 1923584.17 4208025.85, 1923580.54 4208014.57, 1923571.95 4207986.92, 1923562.95 4207957.88, 1923554.76 4207931.78, 1923545.91 4207902.81, 1923537.1 4207874.59, 1923528.55 4207847.02, 1923521.15 4207822.4, 1923512.56 4207795.53, 1923505.37 4207771.07, 1923499.65 4207752.32, 1923493.7 4207733.46, 1923487.09 4207711.52, 1923478.29 4207684.12, 1923470.42 4207658.95, 1923463.21 4207636.38, 1923457.41 4207617.7, 1923449.13 4207591.17, 1923434.38 4207543.87, 1923425.6 4207516.54, 1923416.69 4207487.54, 1923410.33 4207466.88, 1923405.59 4207453.39, 1923398.21 4207430.35, 1923389.48 4207402.95, 1923380.59 4207376.4, 1923371.34 4207347.4, 1923360.85 4207315.53, 1923354.86 4207296.84, 1923346.16 4207270.59, 1923337.7 4207244.17, 1923328.79 4207216.87, 1923319.19 4207187.28, 1923310.26 4207159.18, 1923300.76 4207130.38, 1923286.6 4207086.62, 1923274.06 4207048.32, 1923263.13 4207014.18, 1923250.75 4206975.16, 1923241.27 4206945.96, 1923232.19 4206917.58, 1923222.29 4206887.24, 1923212.99 4206857.86, 1923202.91 4206826.49, 1923191.76 4206791.91, 1923190.53 4206787.37, 1923189.25 4206782.56, 1923187.45 4206777.13, 1923182.91 4206762.24, 1923178.63 4206747.49, 1923175.41 4206736.68, 1923170.7 4206721.62, 1923166.9 4206709.68, 1923159.27 4206684.56, 1923158.02 4206677.58, 1923155.75 4206663.77, 1923154.47 4206656.75, 1923153.89 4206652.53, 1923150.14 4206631.79, 1923147.26 4206616.89, 1923144.91 4206603.58, 1923141.47 4206584.85, 1923137.38 4206562.5, 1923133.69 4206542.3, 1923129.99 4206520.87, 1923125.79 4206497.96, 1923122.42 4206480.48, 1923119.22 4206463.93, 1923115.76 4206444.98, 1923111.43 4206421.32, 1923106.64 4206396.7, 1923104.17 4206384.13, 1923101.4 4206370.13, 1923098.23 4206353.11, 1923095.31 4206337.79, 1923091.81 4206319.43, 1923088.28 4206300.53, 1923083.94 4206277.22, 1923079.88 4206255.06, 1923074.74 4206227.42, 1923070.1442195359 4206203.059600545, 1923066.4755321795 4206183.613351933, 1923065.7429583196 4206179.7302700505, 1923059.77 4206148.07, 1923054.864793779 4206120.890356068, 1923050.9911362089 4206100.127836319, 1923047.54 4206081.63, 1923044.07 4206063.54, 1923040.16 4206041.59, 1923035.47 4206015.4, 1923031.75 4205995.21, 1923028.29 4205976.76, 1923024.42 4205955.85, 1923021.86 4205941.39, 1923018.27 4205921.88, 1923015.02 4205903.01, 1923010.86 4205880.73, 1923007.48 4205863.11, 1923005.24 4205852.48, 1922999.31 4205847.51, 1922997.25 4205846.1, 1922995.7 4205845.04, 1922976.23 4205828.11, 1922958.33 4205812.74, 1922937.25 4205794.62, 1922916.79 4205777.09, 1922896.25 4205759.61, 1922879.72 4205745.54, 1922862.28 4205730.6, 1922838.97 4205710.65, 1922835.16 4205707.24, 1922832.77 4205705.24, 1922817.27 4205692.18, 1922797.03 4205674.79, 1922781.16 4205661.37, 1922779.67 4205660.09, 1922769.32 4205651.22, 1922747.35 4205632.51, 1922730.78 4205618.19, 1922725.01 4205613.34, 1922715.73 4205605.52, 1922696.77 4205589.3, 1922682.99 4205577.46, 1922678.13 4205573.3, 1922663.17 4205560.73, 1922662.28 4205559.99, 1922658.26 4205556.67, 1922651.73 4205551.27, 1922648.95 4205548.98, 1922635.98 4205537.83, 1922623.31 4205527.09, 1922611.5 4205516.89, 1922597.36 4205504.78, 1922582.02 4205491.72, 1922566.96 4205478.82, 1922551.39 4205465.57, 1922550.87 4205465.15, 1922534.86 4205451.18, 1922527.32 4205444.69, 1922522.29 4205440.35, 1922509.12 4205429.14, 1922504.49 4205425.21, 1922499.4 4205420.89, 1922480.59 4205404.86, 1922476.89 4205400.02, 1922457.53 4205372.89, 1922447.59 4205358.85, 1922435.6328641342 4205377.703819953, 1922429.8613891108 4205386.804189153, 1922426.6801215226 4205391.820360836, 1922416.04 4205408.38, 1922407.01 4205422.49, 1922386.77 4205454.75, 1922375.53 4205472.62, 1922362.71 4205492.79, 1922351.64 4205510.39, 1922339.57 4205529.41, 1922324.49 4205553.08, 1922311.15 4205574.42, 1922296.15 4205598.49, 1922287.7 4205612.13, 1922284.99 4205616.51, 1922277.33 4205628.45, 1922274.32 4205633.15, 1922266.14 4205646.13, 1922265.71 4205646.83, 1922255.19 4205663.83, 1922246.23 4205677.92, 1922240.28 4205687.43, 1922239.06 4205689.4, 1922232.86 4205699.02, 1922224.78 4205712.14, 1922217.14 4205724.45, 1922208.22 4205738.79, 1922196.7 4205757.52, 1922191.15 4205766.45, 1922189.7 4205768.78, 1922183.1 4205780.01, 1922177.42 4205789.84, 1922174.76 4205794.46, 1922173.31 4205796.98, 1922168.26 4205806.26, 1922161.22 4205819.59, 1922155.03 4205831.07, 1922147.68 4205844.76, 1922147 4205846.09, 1922144.37 4205851.24, 1922137.88 4205863.24, 1922132.08 4205874.24, 1922127.13 4205883.36, 1922121.82 4205893.49, 1922121.45 4205894.17, 1922115.18 4205905.67, 1922111.05 4205913.67, 1922110.42 4205914.85, 1922106.87 4205921.42, 1922099.18 4205936.35, 1922098.37 4205937.91, 1922092.26 4205949.49, 1922090.58 4205952.83, 1922089.89 4205955.07, 1922088.15 4205960.61, 1922083.24 4205977.18, 1922077.79 4205995.62, 1922074.72 4206005.76, 1922073.8 4206008.81, 1922069.32 4206024.28, 1922068.84 4206024.84, 1922067.32 4206026.58, 1922061.78 4206033.02, 1922050.46 4206046.28, 1922036.05 4206063, 1922025.43 4206075.37, 1922011.38 4206091.78, 1921997.95 4206107.55, 1921982.66 4206125.45, 1921973.3 4206136.36, 1921971.33 4206139.38, 1921953.97 4206164.37, 1921940.75 4206183.33, 1921930.73 4206197.62, 1921919.33 4206213.99, 1921907.56 4206230.95, 1921892.6 4206252.32, 1921881.26 4206268.69, 1921876.58 4206275.29, 1921872.32 4206281.25, 1921871.7 4206282.11, 1921867.69 4206288.45, 1921864.34 4206293.72, 1921860.67 4206299.36, 1921852.44 4206311.44, 1921839.52 4206330.23, 1921827.6 4206348.13, 1921818.86 4206360.79, 1921808.98 4206375.19, 1921797.08 4206392.47, 1921786.16 4206408.33, 1921774.79 4206425.06, 1921764.03 4206440.6, 1921756.06 4206452.45, 1921754.08 4206455.4, 1921746.85 4206466.24, 1921742.4 4206472.75, 1921735.56 4206482.7, 1921728.08 4206493.66, 1921723.75 4206499.94, 1921721.76 4206502.83, 1921719.86 4206499.6, 1921718.11 4206501.84, 1921637.25 4206621.61, 1921615.6 4206653.54, 1921597.22 4206680.67, 1921582.76 4206702.02, 1921552.37 4206746.86, 1921521.37 4206793.7, 1921051.37 4207049.72, 1921036.42 4207126.99, 1921034.12 4207132.47, 1921008.95 4207204.77, 1921008.04 4207206.36, 1921007.61 4207207.72, 1920998.07 4207236.25, 1920997.98 4207236.52, 1920996.95 4207238.21, 1920996.16 4207239.57, 1920978.31 4207289.88, 1920940.89 4207392.74, 1920939.38 4207397.88, 1920938.09 4207402.89, 1920928.75 4207429.48, 1920928.37 4207430.58, 1920927.58 4207431.99, 1920884.86 4207553.41, 1920887.5685498393 4207556.11854984, 1920879.81 4207568.97, 1920876.52 4207579.07, 1920875.64 4207580.88, 1920875.1 4207583.3, 1920840.37 4207678.91, 1920825.91 4207719.37, 1920820.63 4207734.12, 1920809.87 4207764.23, 1920793.26 4207811.53, 1920786.62 4207830.45, 1920781.98 4207843.69, 1920801.78 4207941.81, 1920805.64 4207960.92, 1920807.78 4207971.51, 1920809.58 4207979.87, 1920812.61 4207993.81, 1920825.69 4208054.25, 1920825.99 4208057.05, 1920826.32 4208060.19, 1920827.41 4208064.44, 1920826.56 4208068.25, 1920825.66 4208069.74, 1920822.99 4208074.18, 1920808.58 4208098.57, 1920803.35 4208107.43, 1920796.62 4208118.75, 1920788.6 4208128.89, 1920781.71 4208137.91, 1920770.56 4208151.37, 1920763.78 4208159.96, 1920761.64 4208162.25, 1920753.48 4208171.28, 1920749.52 4208175.34, 1920746.4 4208180.44, 1920738.05 4208194.75, 1920730.85 4208206.25, 1920726.72 4208212.7, 1920722.47 4208220.37, 1920717.72 4208228.89, 1920712.21 4208238.69, 1920708.63 4208246.31, 1920698.81 4208264.4, 1920696.25 4208268.62, 1920691.91 4208276.89, 1920686.43 4208286.56, 1920679.14 4208299.89, 1920673.79 4208310.3, 1920667.36 4208322.74, 1920661.48 4208334.32, 1920655.97 4208344.88, 1920643.93 4208370.2, 1920639.13 4208380.19, 1920634.54 4208389.4, 1920630.8 4208397.75, 1920627.48 4208405.92, 1920625.41 4208410.87, 1920623.55 4208416.7, 1920620.07 4208426.81, 1920618.07 4208434.04, 1920615.76 4208442.19, 1920615.2 4208444.01, 1920613.9 4208451.42, 1920613.49 4208455.32, 1920613.44 4208480.13, 1920613.39 4208477.69, 1920602.41 4208476.71, 1920602.14 4208478.32, 1920532.44 4208478.47, 1920495.53 4208478.97, 1920494.86 4208478.95, 1920488.57 4208478.69, 1920479.07 4208477.83, 1920361.158988063 4208477.830543669, 1920301.821011937 4208477.829456331, 1920300.8227767022 4208477.820256006, 1920299.925167273 4208491.700895588, 1920303.3005682053 4208577.533983548, 1920306.2201783007 4208591.172324637, 1920311.2748889297 4208606.01572434, 1920316.6467198245 4208621.213623995, 1920332.311223411 4208649.608689387, 1920344.0583271538 4208671.534006098, 1920345.0713364508 4208673.99862724, 1920346.3266709466 4208678.920982478, 1920346.8612289792 4208683.4370840965, 1920347.3554008023 4208710.216033109, 1920347.5321926717 4208725.765879428, 1920347.4535817492 4208736.718967234, 1920344.3766357289 4208768.218676223, 1920342.0950009103 4208782.545816033, 1920337.6912272898 4208819.881947095, 1920331.9344233084 4208843.072033739, 1920325.57402363 4208858.228683098, 1920316.089038637 4208876.051841119, 1920305.7619910166 4208941.214814626, 1920302.189771207 4208958.267108608, 1920296.5415120947 4208971.610798104, 1920289.5499627483 4208972.398479735, 1920280.6083301317 4208972.274889958, 1920196.9890031077 4208945.899960003, 1920120.4280422858 4208920.528231654, 1920028.1055221024 4208904.648205022, 1919927.4741855506 4208894.588847621, 1919852.6614993813 4208909.822407794, 1919844.758058691 4208903.831341351, 1919840.5291517829 4208903.350711502, 1919835.2586421536 4208907.916109114, 1919826.4709480973 4208914.520972915, 1919791.7918581674 4208931.589702118, 1919756.4208517566 4208941.862570636, 1919728.1133696125 4208946.142063869, 1919700.6537985052 4208961.073072592, 1919679.0936562608 4208976.8069210835, 1919642.8239704424 4208989.326700319, 1919611.5448946783 4208990.709720196, 1919507.5244695058 4208993.887635123, 1919489.72 4208998.44, 1919480.3036933828 4208999.938735038, 1919457.7593927132 4209009.422914857, 1919442.1447435261 4209032.110225248, 1919425.2726393056 4209064.121765075, 1919506.8031139139 4209106.738250383, 1919524.6440213118 4209117.167518166, 1919581.7244645273 4209131.512381121, 1919635.6735684169 4209152.60547113, 1919742.551651131 4209210.087580932, 1919749.5827287403 4209198.328135648, 1919897.2524718605 4209329.878486905, 1919937.316068232 4209372.021491661, 1919998.8291335644 4209446.994865149, 1920080.4380415208 4209567.93298531, 1920136.8691479145 4209638.905293456, 1920161.6369345873 4209667.5594637245, 1920185.5819779586 4209690.240507277, 1920253.2571023216 4209739.712793555, 1920267.1785210602 4209749.361594196, 1920381.293627806 4209818.6763251275, 1920418.4585592847 4209839.857871985, 1920491.939342802 4209881.848665254, 1920507.7537480942 4209890.855186832, 1920678.4581135383 4209986.942059429, 1920782.1674004474 4210043.7948508, 1920869.211789963 4210085.615572633, 1921058.528391212 4210131.887098156, 1921334.5683301205 4210124.834680583, 1921416.555922303 4210162.538294821, 1921480.8509858847 4210154.171070837, 1921503.9354149238 4210102.840816818, 1921731.5891709202 4209897.351994895, 1921758.325 4209864.935, 1921824.4977208604 4209800.658653738, 1921862.0781542405 4209769.947146905, 1921899.0089402928 4209739.52053503, 1921912.6176014198 4209729.584728396, 1921919.3604479705 4209726.968659351, 1921937.7528037832 4209718.746537253, 1921975.443399664 4209708.535293773, 1922005.773027281 4209707.106478496, 1922033.6841179456 4209707.94540692, 1922035.7971776074 4209707.970702172, 1922049.333508561 4209711.035292685, 1922115.7593430378 4209726.001182915, 1922184.207206547 4209744.416438456, 1922224.509471678 4209755.65165832, 1922275.1220942014 4209762.554138139, 1922276.1933188094 4209762.670323786, 1922278.2270520178 4209762.892557539, 1922279.2792816719 4209763.04502547, 1922287.847180795 4209764.30302597, 1922349.7431957931 4209775.396418541, 1922389.4915795254 4209775.310121098, 1922516.1953878195 4209754.849469022, 1922574.3995470647 4209747.26705592, 1922592.0297027822 4209742.008445022, 1922697.1112113204 4209706.812300382, 1922750.217311803 4209704.291153521, 1922757.7558873736 4209704.302528365, 1922764.9365601514 4209704.444457943, 1922783.2346421822 4209707.7941649305, 1922795.118379753 4209709.205674387, 1922839.8821741357 4209714.756359095, 1922871.5216011682 4209713.437833556, 1922887.9231642024 4209710.724184783, 1922909.3436334522 4209706.072007114, 1922917.6773569293 4209703.569717436, 1922927.6528532773 4209699.929086019, 1922974.2861738037 4209674.587313242, 1923008.894983343 4209655.075123889, 1923029.8515852732 4209643.668057313, 1923054.340367949 4209631.421444529, 1923095.001388289 4209611.541473297, 1923108.5005467546 4209607.655522271, 1923136.9555518155 4209603.39745417, 1923223.6772823888 4209590.989058704, 1923255.5205660122 4209596.637262988, 1923284.7308538768 4209603.9110471085, 1923317.3251479173 4209614.0084927315, 1923348.0515709203 4209629.408691975, 1923401.4174952772 4209660.551440715, 1923423.9808496097 4209673.589473155, 1923432.4788931215 4209678.732806741, 1923447.967728558 4209689.132333267, 1923458.5287934244 4209696.586706656, 1923463.511283981 4209700.419983438, 1923472.6597624826 4209707.491904752, 1923537.6544386572 4209767.109456867, 1923543.6906193297 4209771.101279806, 1923581.702617891 4209797.402144431, 1923640.2535632101 4209829.468863247, 1923642.1652759847 4209827.599097485, 1923651.4370954537 4209818.5307213, 1923698.447524118 4209836.454761402, 1923697.309402456 4209845.233702475, 1923707.99 4209838.84, 1923711.57 4209836.06, 1923728.39 4209825.01, 1923810.96 4209774.79, 1923922.13 4209706.36, 1924071.79 4209615.03, 1924174.9 4209552.06, 1924319.44 4209462.76, 1924505.27 4209349.56, 1924692.09 4209235.5, 1924844.33 4209141.48, 1925005.92 4209041.56, 1925058.98 4209008.43, 1925066.31 4209003.95, 1925098.04 4208984.25, 1924909.56 4208731.93, 1924758.75 4208529.41, 1924642.41 4208372.25, 1924504.83 4208324.21, 1924239.92 4208232.82, 1924202.39 4208229.18))'::geometry,'38364','Saint-Barthélemy-de-Séchilienne','SAINT-BARTHÉLEMY-<br>DE-SÉCHILIENNE','SBS','SBS'),
     (49,'SRID=3945;POLYGON ((1910874.8899999573 4230596.530000024, 1910890.3974999296 4230570.582500069, 1910902.149352359 4230524.25254627, 1910929.7879766123 4230516.233574526, 1910974.7174999933 4230491.31500004, 1910999.6725000113 4230462.360000016, 1911043.797500001 4230450.212500004, 1911078.7576517954 4230448.994777343, 1911131.434999997 4230420.789999995, 1911158.1825000087 4230417.332499993, 1911183.023606762 4230422.118487124, 1911190.316009416 4230425.970280819, 1911197.4793404762 4230430.824726836, 1911204.055000037 4230443.062500002, 1911203.0700000292 4230494.405000018, 1911215.6401952761 4230511.591505349, 1911242.8850891807 4230517.023935998, 1911275.54 4230523.66, 1911285.7469083893 4230529.349675864, 1911320.912116121 4230684.256012874, 1911305.0864574881 4230691.441690275, 1911304.2850000046 4230715.877499993, 1911314.0575000108 4230732.955000002, 1911332.0125000016 4230761.234999989, 1911355.3700000206 4230798.2174999975, 1911365.4218159204 4230823.978263628, 1911383.8279372603 4230837.97881042, 1911400.915 4230874.445, 1911407.1585892905 4230882.489397589, 1911423.050236773 4230896.056320682, 1911449.0461516704 4230920.106519592, 1911502.2395827079 4230933.008653541, 1911525.6200000187 4230939.74249998, 1911612.1878389432 4230794.882156329, 1911637.6658570985 4230815.054056328, 1911640.8156520398 4230817.300949652, 1911651.5256629817 4230824.695677294, 1911656.4571423007 4230826.8911903, 1911700.874387999 4230839.163088498, 1911753.5825000352 4230872.3149999725, 1911792.9046392331 4230816.41199285, 1911829.9437230008 4230778.0475716395, 1911870.8106612784 4230723.722077856, 1911897.7100000037 4230686.782500016, 1911936.857500016 4230664.495000014, 1911964.8942733346 4230641.388125389, 1911975.5129499063 4230634.754549818, 1912080.1650000783 4230587.32499997, 1912227.804999942 4230605.084999953, 1912465.804130744 4230698.062051612, 1912468.6444831905 4230685.080488521, 1912469.006660111 4230683.424754257, 1912469.077470778 4230683.101717662, 1912469.1040396036 4230682.986783768, 1912469.3245667876 4230682.03887567, 1912470.7463711617 4230675.9296156475, 1912472.0455305516 4230676.405223131, 1912484.372843955 4230617.622180934, 1912492.910861727 4230577.160274249, 1912496.318738551 4230552.629559084, 1912500.0194212436 4230527.723929938, 1912512.0765867317 4230466.8976903055, 1912525.9278900395 4230429.462462417, 1912552.4325000215 4230380.9525, 1912580.6550000077 4230328.825000001, 1912604.8800000246 4230298.254999991, 1912649.4950000653 4230241.689999955, 1912661.0612449828 4230202.106143733, 1912676.497510177 4230148.667084984, 1912712.7774787543 4230007.906919103, 1912712.226012913 4229999.544877099, 1912710.852170195 4229960.578966236, 1912719.776795623 4229895.733308756, 1912708.6408272649 4229838.655138244, 1912735.7885442744 4229741.406340371, 1912736.7437443128 4229711.94017717, 1912740.8107162276 4229684.109331725, 1912741.379554757 4229649.983704526, 1912755.1015775404 4229611.969862393, 1912741.8638809926 4229554.4602099955, 1912741.2311265825 4229551.750465072, 1912739.0402183447 4229531.038444465, 1912715.085606341 4229474.306118506, 1912702.588755047 4229410.860101244, 1912702.343145949 4229391.827598311, 1912704.6803471125 4229381.2526561655, 1912702.453865494 4229364.2946978705, 1912646.620212541 4229282.399979746, 1912612.1059112255 4229172.438564006, 1912618.3613056452 4229063.859777356, 1912629.930988629 4229017.223709491, 1912635.0196542845 4228996.939066699, 1912634.593184062 4228994.743576019, 1912633.1356941834 4228987.334669136, 1912601.774886489 4228941.798989163, 1912601.345417029 4228892.478141781, 1912542.4749929367 4228710.949242364, 1912540.0483932185 4228703.510144231, 1912540.0640580587 4228703.240144681, 1912541.4398062616 4228697.076111191, 1912554.9079736234 4228586.399232922, 1912543.4126820385 4228557.211448573, 1912526.9482278356 4228536.9542299295, 1912482.7381479614 4228512.287478383, 1912469.243494864 4228469.707980901, 1912464.3649999807 4228431.29749996, 1912372.6379504167 4228337.118503012, 1912367.8083353403 4228310.465898182, 1912365.7595514255 4228299.224726884, 1912364.4311946551 4228291.933997938, 1912363.704184364 4228287.963548064, 1912363.1331142257 4228284.815909971, 1912362.58627571 4228281.783371426, 1912362.2423933295 4228279.916561172, 1912361.7721287743 4228277.194785998, 1912274.2325505116 4228175.4007521, 1912246.8736023966 4228143.434250898, 1912244.4634731945 4228140.616713129, 1912243.8511811278 4228139.9005658645, 1912243.831621534 4228139.877680849, 1912243.8287336333 4228139.8743047295, 1912243.7930133776 4228139.832473289, 1912243.7544247468 4228139.787379791, 1912243.7001385563 4228139.723946291, 1912243.5114891278 4228139.502829093, 1912242.9551454533 4228138.853610604, 1912242.3250773342 4228138.118768801, 1912240.8965932147 4228136.446517233, 1912238.9653509262 4228134.184844593, 1912197.3970108805 4228085.365947402, 1912122.6340743047 4227998.127973421, 1912027.9103962008 4227927.2611486595, 1912026.8356363536 4227926.787028433, 1912026.7971572208 4227926.768911849, 1912025.000540529 4227926.339680558, 1912024.559915976 4227926.234667283, 1912024.267570143 4227926.164831617, 1912023.4058264561 4227925.959617736, 1912021.9994717042 4227925.6235892605, 1912018.7979268348 4227924.8593136575, 1912011.162594033 4227923.036840856, 1911983.7700274915 4227916.496166692, 1911927.9627591071 4227903.060863351, 1911851.9328170733 4227884.906262007, 1911791.8136731682 4227870.357689536, 1911781.167747549 4227874.421107655, 1911778.9631860764 4227905.141567301, 1911807.8809729484 4227937.430411676, 1911814.9291102905 4227954.884123631, 1911815.3942580514 4227955.002565048, 1911823.6687765734 4227957.254831298, 1911825.1908831312 4227958.495615149, 1911825.5271497846 4227958.839398046, 1911836.2355787363 4227992.098656829, 1911838.2263498576 4227998.403266581, 1911838.5894312933 4227999.553115871, 1911552.3189473678 4227975.769706468, 1911479.5578397624 4227925.827999476, 1911478.1628188272 4227925.063555151, 1911477.7293093512 4227926.289539542, 1911467.6527351583 4227954.607630705, 1911463.9985021353 4227962.107666203, 1911463.0436993882 4227964.386229757, 1911462.6916535913 4227968.532471608, 1911462.48446959 4227971.13682931, 1911462.605313763 4228004.805885631, 1911462.622499999 4228017.362499998, 1911459.6922990982 4228024.773576488, 1911456.085149919 4228029.730878239, 1911451.5741467704 4228033.516203736, 1911446.863167612 4228036.137942755, 1911440.3931853476 4228037.014422028, 1911426.202226722 4228035.75775303, 1911419.025395271 4228034.019972628, 1911413.6017471505 4228032.125846383, 1911411.3400224028 4228031.3007563595, 1911408.804506618 4228029.687666881, 1911400.8267054746 4228023.861766199, 1911399.3544362003 4228022.563172399, 1911388.568207828 4228011.296555289, 1911388.457421899 4228011.178946397, 1911388.4179615579 4228011.135601553, 1911386.4213099468 4228008.9498601025, 1911384.7635880997 4228006.879537757, 1911383.0309771232 4228004.719375459, 1911378.0942965737 4227998.250976733, 1911375.023908606 4227994.209420656, 1911363.3127371583 4227977.908317723, 1911355.9558252257 4227969.423676851, 1911346.7407415626 4227962.024589219, 1911341.0910719768 4227958.841852987, 1911340.0563967628 4227958.133380567, 1911337.634856894 4227955.820962705, 1911336.8412641224 4227955.065257221, 1911332.3023671098 4227949.64016338, 1911331.834681175 4227949.017074899, 1911328.290051334 4227943.238907947, 1911323.7701907165 4227933.613068618, 1911323.1560531259 4227932.2477544695, 1911322.3449481053 4227929.837148587, 1911319.9323525669 4227921.581385358, 1911317.4097566023 4227911.229292216, 1911314.6464835743 4227896.743595314, 1911311.720324008 4227879.7100485, 1911310.6130108417 4227875.0669108555, 1911308.1639247504 4227867.953545804, 1911306.383103553 4227863.794189139, 1911305.143740436 4227861.1455860585, 1911304.2700083565 4227859.416778101, 1911302.7996975 4227857.059956287, 1911301.9386386678 4227855.824676115, 1911300.6153005979 4227854.096749947, 1911297.2110460927 4227850.222684782, 1911293.3532597134 4227846.142467099, 1911291.7379838817 4227844.773677636, 1911288.4487842165 4227842.091919754, 1911279.017235578 4227835.377983298, 1911277.9070961508 4227834.595267089, 1911277.6899111168 4227834.4648331115, 1911277.2034882533 4227834.180496091, 1911273.9783389887 4227832.737009595, 1911270.7842712568 4227831.526244938, 1911265.4230111334 4227829.7537348205, 1911261.895582645 4227828.283677649, 1911260.4333215188 4227827.488386504, 1911259.64067265 4227827.053007262, 1911258.8747658443 4227826.493220133, 1911196.3566907533 4227774.602428012, 1911127.1047267164 4227717.045318834, 1911037.07875 4227642.356250002, 1911003.2918533941 4227614.3417823715, 1910996.9832945305 4227609.2260020245, 1910981.66 4227596.214999996, 1910965.9809716598 4227583.42555668, 1910948.6520648724 4227568.581645952, 1910921.2624999962 4227544.842500004, 1910832.862191298 4227466.059013154, 1910777.3436766146 4227416.278385615, 1910727.5462499994 4227371.756250001, 1910690.0892915023 4227338.113390685, 1910672.074362351 4227321.828046554, 1910621.332813726 4227275.940890646, 1910556.9189068903 4227217.698866392, 1910535.0800645459 4227198.087556943, 1910455.0407763885 4227255.742259147, 1910436.7479418986 4227268.920344742, 1910436.6947338905 4227268.859371763, 1910436.6877461658 4227268.8644123385, 1910436.3759895486 4227268.494111109, 1910434.038711864 4227265.712680597, 1910433.1700219105 4227264.717442941, 1910430.1034831726 4227261.213850959, 1910426.4777198192 4227257.073456058, 1910422.7850680838 4227252.859865755, 1910419.486774179 4227249.087276091, 1910417.60964712 4227246.945114928, 1910415.2426725442 4227244.240088133, 1910412.345071641 4227240.927157362, 1910410.4265074849 4227238.735423263, 1910409.3624974368 4227237.522660142, 1910407.924452803 4227235.877824302, 1910407.2238826554 4227235.0787275145, 1910406.47991061 4227234.228913385, 1910405.9163334495 4227233.584690069, 1910404.6377905838 4227232.124162516, 1910404.4839022288 4227231.948350005, 1910404.4191272608 4227231.874326874, 1910404.34535357 4227231.790162866, 1910404.2731812596 4227231.707570203, 1910404.132222899 4227231.546550636, 1910404.0342972449 4227231.4347289475, 1910403.7740913846 4227231.137271464, 1910403.5175882825 4227230.844418199, 1910403.2737585118 4227230.565531868, 1910401.894155001 4227228.98962978, 1910400.6432536463 4227227.560808741, 1910399.9037267924 4227226.716790995, 1910398.4028982138 4227224.999367957, 1910396.6028588056 4227222.943537274, 1910393.2927428412 4227219.163326468, 1910387.4342486935 4227212.471698963, 1910379.5565045413 4227203.473912908, 1910286.4949582815 4227273.691695203, 1910276.227225876 4227281.447215552, 1910275.1390253275 4227282.269553549, 1910244.6994349658 4227305.356458647, 1910170.16874917 4227361.812247457, 1910166.822420357 4227364.3441697825, 1910163.7849900161 4227366.648696671, 1910162.4662983231 4227367.654581406, 1910159.0539655166 4227370.259177023, 1910155.721384951 4227372.8184776995, 1910152.0834774517 4227375.615082804, 1910098.1254959514 4227417.053006073, 1910039.5840155557 4227461.920149578, 1910031.2845489061 4227468.4457912585, 1910031.0826099073 4227468.605418032, 1910026.7289777326 4227472.050217612, 1910024.1780738605 4227474.21475171, 1910006.4444694803 4227489.750430883, 1909995.8223309636 4227499.204758725, 1909995.102444741 4227499.841862302, 1909990.6576721128 4227503.807907245, 1909981.9161817194 4227511.65923371, 1909970.2380135898 4227522.331530491, 1909961.1248709233 4227530.7702540755, 1909943.1588536343 4227547.56293169, 1909925.4923265234 4227565.060193681, 1909920.2964219043 4227570.223950389, 1909915.0760685238 4227575.602292571, 1909906.9009445203 4227584.081932952, 1909902.1390119249 4227589.1539482465, 1909884.1146114906 4227608.598219728, 1909880.3967477223 4227612.635080157, 1909876.2989561101 4227617.36295271, 1909858.4629216564 4227637.995705347, 1909847.4197692021 4227650.631576955, 1909834.613193116 4227665.282313877, 1909831.8224652587 4227668.575103492, 1909830.1188697394 4227670.584377096, 1909826.4953600324 4227674.861640824, 1909826.1476455801 4227675.272000614, 1909824.4246770982 4227677.330797855, 1909820.7923840776 4227681.798145575, 1909811.59151411 4227693.962852425, 1909801.137492952 4227707.995138768, 1909798.5766160134 4227711.980530577, 1909795.856885317 4227716.243254034, 1909790.6613987146 4227724.9456173135, 1909780.8621422239 4227741.396276166, 1909758.5493739808 4227779.4841773845, 1909721.5845692048 4227842.639233691, 1909687.8420658445 4227900.499093028, 1909654.4945958222 4227958.585968395, 1909574.8788772176 4228098.605462298, 1909541.1485000004 4228158.476493381, 1909524.5994313934 4228188.123877774, 1909517.5290521246 4228200.97081714, 1909500.9096872623 4228232.259629022, 1909494.7513446196 4228244.58443153, 1909482.8449567426 4228268.41598572, 1909480.427395931 4228273.259302627, 1909462.288214088 4228309.821791655, 1909456.0657470352 4228322.005065505, 1909453.861843279 4228326.315514333, 1909452.300521611 4228329.213702215, 1909419.2039106647 4228389.1654142905, 1909411.816775638 4228402.479449045, 1909358.2779063429 4228498.590604771, 1909250.899010108 4228692.331045184, 1909240.3750630796 4228711.364416706, 1909223.0671122056 4228742.322374681, 1909195.7485661162 4228791.160904815, 1909163.0501784629 4228849.657495549, 1909108.6727188558 4228947.010675784, 1909095.8931189347 4228969.693513629, 1909035.042578017 4229078.081579356, 1909034.2175715226 4229079.5526923435, 1909030.648816017 4229085.909625145, 1909025.0010747497 4229095.922031908, 1909011.7769359732 4229119.369695802, 1908981.9806871507 4229172.215144867, 1908968.906093165 4229195.422692056, 1908928.4247568734 4229267.332713532, 1908922.5577339155 4229277.765509417, 1908916.6899067222 4229288.196356542, 1908912.6959338638 4229295.362893236, 1908894.0994753684 4229328.745812221, 1908859.822461589 4229389.533479431, 1908850.1136642536 4229406.732573832, 1908847.4601151107 4229411.426806044, 1908821.6752989783 4229457.333158917, 1908738.259227447 4229605.829076593, 1908694.7857814815 4229682.89232171, 1908426.239855545 4230164.311923813, 1908428.7814565604 4230165.891765808, 1908430.9904996634 4230167.207670097, 1908480.011340688 4230196.531696741, 1908532.171654309 4230227.724109657, 1908536.3933085075 4230230.177832104, 1908537.0986185279 4230230.629667119, 1908611.6146710417 4230275.402208994, 1908685.2817401015 4230319.6272537615, 1908702.9542833045 4230330.346917768, 1908741.6970192306 4230353.918891701, 1908802.1798004904 4230390.3859941205, 1908868.4573748242 4230430.528621997, 1908877.0702580556 4230435.729285863, 1908899.1909953644 4230449.018610273, 1908926.6838947965 4230465.429623531, 1908967.2412057188 4230489.698977732, 1908967.2563998902 4230489.760575328, 1908969.17 4230495.08, 1908969.577716033 4230495.439459899, 1909002.1389656558 4230514.903626792, 1909017.700774269 4230524.099168898, 1909027.4950206992 4230529.892787362, 1909037.0064835192 4230535.49110609, 1909039.2100384056 4230536.925047416, 1909042.3085768856 4230538.9509768635, 1909045.5772277014 4230541.074623033, 1909060.2418784017 4230550.529479833, 1909078.7366526232 4230562.228547002, 1909093.5128789833 4230571.506495264, 1909097.6358358692 4230573.969704421, 1909159.2372963952 4230611.767885858, 1909174.7345135014 4230621.180724898, 1909183.3771428624 4230625.7832919285, 1909187.296299569 4230627.979699333, 1909190.415619331 4230629.607921776, 1909194.2007439171 4230631.641189265, 1909197.9846095329 4230633.676684176, 1909200.784079686 4230635.247765766, 1909203.3903272392 4230636.733808423, 1909216.1076901 4230644.69008009, 1909272.5398298705 4230677.500185915, 1909308.1862500042 4230698.041249994, 1909404.9512695957 4230753.577064654, 1909416.7219915895 4230760.409729946, 1909423.3241688188 4230764.2432716, 1909424.7534872994 4230765.098891456, 1909428.9767484933 4230767.6374379825, 1909428.9535439985 4230767.694759832, 1909429.036056686 4230767.745757257, 1909428.4704033725 4230768.888257662, 1909421.4678367176 4230782.888025622, 1909422.9651461272 4230782.487843827, 1909422.0718108534 4230784.694641709, 1909429.7386952809 4230780.694899734, 1909430.3589915002 4230780.543973217, 1909445.3392045493 4230776.908095494, 1909449.6028002515 4230775.672703474, 1909466.1005058244 4230770.938087973, 1909474.2193822125 4230769.63040951, 1909483.3939798158 4230767.840525249, 1909502.6978007562 4230764.00774051, 1909508.7223263928 4230762.954629708, 1909509.2666526916 4230762.859755623, 1909512.4874232868 4230762.356795527, 1909514.2421491228 4230762.087408357, 1909522.3626321969 4230760.846516853, 1909524.303904055 4230760.513147078, 1909529.511888243 4230759.444919718, 1909550.1685844308 4230755.2606807165, 1909555.0107556875 4230754.525816353, 1909566.3414980532 4230752.863054475, 1909566.5786363673 4230752.822272726, 1909571.6193740277 4230751.965376688, 1909589.5090841253 4230748.595436899, 1909633.354251014 4230740.638760113, 1909645.057407616 4230738.177121121, 1909657.6920518624 4230736.165136418, 1909660.3438956393 4230735.762660614, 1909664.5768912751 4230735.3012944665, 1909669.2675265537 4230735.004312999, 1909685.00182508 4230734.4644391835, 1909688.977958934 4230734.117013917, 1909700.0664617694 4230732.562974478, 1909703.0434789408 4230732.106630265, 1909704.9631979624 4230731.812358309, 1909707.3107640436 4230731.761429706, 1909713.8709320063 4230731.703569047, 1909724.8255944243 4230733.992827039, 1909726.1489929024 4230734.398749995, 1909732.2482478751 4230736.705021587, 1909734.0128004432 4230737.500661522, 1909740.194881036 4230740.51403749, 1909745.674717386 4230743.305979428, 1909748.8994604247 4230745.0926238205, 1909753.653815184 4230748.184704491, 1909756.4814194888 4230750.0979580805, 1909776.0387750054 4230767.452112942, 1909779.1272194202 4230769.806631709, 1909794.2847288912 4230782.375572354, 1909799.8819434212 4230786.740787975, 1909816.262950915 4230802.92791663, 1909817.2343476075 4230803.827364455, 1909841.18980146 4230824.460386916, 1909855.9311975623 4230837.378173962, 1909857.7659691172 4230838.98625078, 1909858.1148970758 4230839.3078770945, 1909875.9775456004 4230856.666329454, 1909877.1855410277 4230857.925442325, 1909879.675674632 4230859.770204044, 1909880.826007306 4230860.684065761, 1909881.5657607904 4230861.290866372, 1909884.8687406403 4230864.004684163, 1909894.9200892502 4230873.651579372, 1909908.9601248316 4230886.874619214, 1909911.9663340966 4230889.81410194, 1909915.3948881237 4230892.990036103, 1909919.6670608106 4230897.199689189, 1909920.4211803868 4230898.105728325, 1909921.4763306156 4230900.727419471, 1909922.8420000002 4230905.211217392, 1909923.3653609788 4230906.705450911, 1909924.2452281865 4230908.973112168, 1909930.1394544211 4230916.973461675, 1909931.1179501715 4230918.707831019, 1909931.6340133636 4230919.616761694, 1909932.2280187355 4230920.721403263, 1909934.3660002768 4230926.786351892, 1909935.0430969181 4230934.765398104, 1909935.9634618184 4230941.995919165, 1909936.4856534798 4230945.539251961, 1909937.147380419 4230948.622255707, 1909938.009321143 4230950.89997589, 1909940.1147298792 4230953.745777288, 1909940.6842654545 4230954.239965744, 1909941.801000486 4230955.043330186, 1909943.9322485065 4230956.0770341735, 1909945.9017733596 4230957.1205982985, 1909946.4672576068 4230957.356395565, 1909954.0932228058 4230959.972025575, 1909955.875405298 4230961.2258308055, 1909956.9617012914 4230962.602163282, 1909957.1989437805 4230962.913523249, 1909959.4965735537 4230968.534422783, 1909960.8508301845 4230972.2638351405, 1909961.350372578 4230973.028132775, 1909962.1982247606 4230974.024222522, 1909964.626563764 4230976.881190532, 1909965.2004644724 4230977.450795795, 1909970.510444176 4230982.722537817, 1909978.307919883 4231006.687256719, 1909979.3203167745 4231009.361617186, 1909980.4311168506 4231011.606031816, 1909981.8484193657 4231013.804735752, 1909986.4287814419 4231020.259951696, 1909986.9352716496 4231020.646242026, 1909987.613987852 4231021.224245952, 1909993.0135538985 4231024.189980727, 1909997.184062534 4231026.500997211, 1909998.070696854 4231027.14277954, 1909998.2128558867 4231027.246196256, 1910005.953709566 4231033.864160318, 1910052.3495546195 4231069.732740719, 1910086.207994322 4231106.747654561, 1910099.7185270062 4231121.890974043, 1910111.483081182 4231145.541908851, 1910120.5646551037 4231166.557070564, 1910122.054966396 4231164.866651011, 1910122.6727596107 4231165.9301937595, 1910220.0554966081 4231055.967715514, 1910278.9903287324 4230989.568930288, 1910284.088952414 4230988.255268197, 1910387.845526306 4230965.2671406455, 1910428.7100000174 4230915.5649999315, 1910446.272500023 4230897.0549999215, 1910463.4974999882 4230878.074999967, 1910482.6074999946 4230871.374999968, 1910488.2855652072 4230871.509642473, 1910499.404068505 4230873.371035804, 1910506.9170707222 4230875.671159069, 1910520.9374976456 4230882.80393597, 1910542.035000009 4230898.211249981, 1910565.582500005 4230921.166249985, 1910594.1625000106 4230956.5975, 1910608.4226113423 4230976.717287439, 1910647.0044837904 4231049.39895745, 1910666.4792329653 4231070.066698109, 1910680.8863759122 4231083.131066896, 1910689.6405435936 4231101.336751916, 1910716.315214147 4231188.399585656, 1910722.409762065 4231192.19542393, 1910738.7362499991 4231154.4099999955, 1910756.7787499982 4231124.0587499915, 1910782.941250005 4231101.1887499895, 1910856.2300000354 4231057.782499972, 1910905.107499986 4231043.437499983, 1910896.5699999935 4230941.250000068, 1910886.6278476864 4230888.442769093, 1910874.0416753523 4230751.723073672, 1910878.4922773372 4230680.172297555, 1910874.1919779903 4230662.615617074, 1910869.7012752988 4230632.127105259, 1910874.8899999573 4230596.530000024))'::geometry,'38382','Saint-Égrève','SAINT-ÉGRÈVE','SEG','SEG'),
     (35,'SRID=3945;POLYGON ((1915146.4 4204897.75, 1915141.82 4204883.78, 1915138.59 4204873.85, 1915137.02 4204868.05, 1915136.17 4204862.85, 1915134.78 4204851.95, 1915133.32 4204839.72, 1915133.2 4204824.18, 1915132.79 4204811.02, 1915131.91 4204798.24, 1915133.93 4204778.43, 1915135.11 4204762.94, 1915125.62 4204745.17, 1915122.83 4204739.95, 1915116.7 4204721.37, 1915113.07 4204711.83, 1915109.44 4204703.69, 1915105.58 4204700.09, 1915101.65 4204699.43, 1915100.32 4204699.21, 1915095.27 4204704.47, 1915090.7233713951 4204698.045384965, 1914991.3400858308 4204801.051983738, 1914970.8318088062 4204821.878220954, 1914957.3068592001 4204835.4437846765, 1914938.039444388 4204854.769057673, 1914923.1632668723 4204869.689906912, 1914911.5009437304 4204881.3872508835, 1914894.5507229725 4204898.388371516, 1914869.5952769134 4204918.622275374, 1914853.2997730456 4204931.834688319, 1914832.65530662 4204943.597815672, 1914823.1439747282 4204947.843688338, 1914780.5793911389 4204949.12755476, 1914763.2770665775 4204949.649441072, 1914746.5888521238 4204950.152804112, 1914732.0622489266 4204948.0701246215, 1914698.0311529667 4204943.191085479, 1914679.1202331244 4204940.479826394, 1914644.7861943673 4204943.67248312, 1914603.5699070054 4204934.368724241, 1914573.406168108 4204936.144367791, 1914542.8290903082 4204937.880797753, 1914512.64735122 4204939.364419002, 1914484.9330451875 4204955.526359693, 1914455.3244113603 4204981.258609667, 1914431.1698966355 4205002.250797775, 1914416.5311545231 4205014.973025134, 1914402.412407249 4205029.822642419, 1914378.1886911823 4205056.370819365, 1914367.2432980903 4205066.930107368, 1914336.4998586378 4205089.452541102, 1914323.2264560824 4205099.176545142, 1914322.2149330059 4205112.893586661, 1914324.0773015886 4205125.832263182, 1914323.332215529 4205137.8254230935, 1914318.2456651516 4205163.164524881, 1914316.909317751 4205181.984555118, 1914318.8886863152 4205196.967050317, 1914318.4439546776 4205203.005777047, 1914315.3518633065 4205208.820650272, 1914296.0792122465 4205233.482320283, 1914287.8839643288 4205241.957542503, 1914283.0313239954 4205251.455270904, 1914281.813460038 4205257.137445945, 1914279.8046799637 4205263.00570619, 1914272.630624268 4205299.981706106, 1914268.822206141 4205317.7506024605, 1914264.366146421 4205330.124058167, 1914259.65627831 4205340.528089955, 1914256.9807345257 4205346.705028336, 1914257.243229803 4205355.126440715, 1914257.6864407153 4205360.901779642, 1914259.6847260615 4205366.534229808, 1914260.0397693329 4205372.040367211, 1914260.9985862155 4205385.100259079, 1914259.39031155 4205398.986968102, 1914255.982165796 4205420.98572508, 1914256.2124856585 4205456.099039502, 1914255.3628814307 4205485.370037781, 1914253.9255845146 4205495.920052297, 1914244.4508225909 4205528.110378174, 1914182.7918369 4205538.239828962, 1914114.0323016257 4205549.404022848, 1914079.7184483025 4205578.337971743, 1914076.68375226 4205580.976076255, 1913973.481254694 4205597.263827234, 1913964.6143074334 4205598.663237445, 1913833.6761349835 4205654.098499258, 1913827.0362870912 4205655.752883396, 1913826.1040856256 4205655.937845192, 1913730.6460295592 4205653.180917077, 1913610.4073570282 4205650.152834387, 1913430.7988712303 4205644.775099395, 1913220.8676569327 4205639.244486597, 1913218.5580451875 4205639.116954813, 1913204.7195782617 4205648.283725718, 1913192.9646535418 4205657.055980488, 1913190.5344944375 4205657.7476135185, 1913156.1821020758 4205663.133278622, 1913147.876330867 4205664.997951249, 1913145.6475647904 4205666.619622405, 1913143.5057243758 4205668.020459894, 1913123.6055642837 4205688.434932959, 1913118.6536107652 4205692.5533964345, 1913116.8042620837 4205694.191194078, 1913114.3347481717 4205695.65150909, 1913107.5725427275 4205699.480187545, 1913104.0975483437 4205701.353419363, 1913099.2411489543 4205702.726569031, 1913085.9206681242 4205706.569283685, 1913072.3874239984 4205709.968048016, 1913070.8972191059 4205710.50714133, 1913070.0604797567 4205710.7850218825, 1913069.0212381233 4205711.4656119635, 1913057.0943208663 4205718.959866217, 1913040.1871438548 4205727.2313797595, 1913008.6318418079 4205733.844071473, 1913006.06257379 4205734.395845432, 1912999.4727908212 4205735.627722615, 1912991.4010669538 4205737.766475781, 1912983.026309624 4205740.930833743, 1912969.5399370082 4205746.950324169, 1912967.178419835 4205747.768576442, 1912963.3608197076 4205749.082758863, 1912951.8338693653 4205753.299309214, 1912937.0877157096 4205759.421334138, 1912904.605292213 4205773.986754062, 1912904.717826196 4205774.754685962, 1912904.183295793 4205774.894432472, 1912904.9092006083 4205797.96727236, 1912903.9 4205803.88, 1912903.4550944678 4205805.434780057, 1912898.772084054 4205810.562003787, 1912881.9972176328 4205828.681359954, 1912861.3283145053 4205858.838073431, 1912829.1800564844 4205885.134079078, 1912788.2685973763 4205920.079232194, 1912753.500813582 4205954.8334518885, 1912739.480867521 4205971.607135559, 1912721.0219586557 4206039.505072899, 1912720.1938055493 4206059.718788242, 1912716.2031180472 4206077.984467588, 1912694.2807898598 4206106.802654487, 1912686.7377700026 4206113.493735193, 1912665.2470303427 4206125.324811749, 1912654.94 4206128.45, 1912549.2485838227 4206176.743258021, 1912483.1437401713 4206209.869022595, 1912483.1495017356 4206301.106050009, 1912444.6573625572 4206390.33915787, 1912340.3518158207 4206590.819986704, 1912273.2214700978 4206766.261136033, 1912233.545739255 4206917.558245715, 1912219.7637585013 4206981.623800157, 1912216.8916676368 4207064.949320283, 1912223.3556254047 4207135.816066038, 1912230.0680190097 4207176.7263201745, 1912241.7292552968 4207246.451042965, 1912248.1213833028 4207288.720886378, 1912255.862291699 4207367.9978022715, 1912258.8881068535 4207439.154057396, 1912258.8967052372 4207468.035123886, 1912255.200172958 4207525.8554531485, 1912252.420796092 4207629.352423637, 1912251.9895895368 4207661.092536352, 1912249.9864060928 4207707.314584935, 1912250.0815934476 4207714.346249335, 1912250.8240983535 4207719.641828288, 1912256.2811973917 4207752.076997718, 1912262.1178858513 4207773.589919231, 1912271.9285004553 4207805.949478278, 1912282.8987282242 4207843.052929958, 1912286.4035672012 4207855.768800917, 1912287.927838464 4207861.310806911, 1912288.8726036046 4207864.470908804, 1912317.7237482267 4207961.338367277, 1912331.7571209 4208000.242670414, 1912353.217408531 4208056.932278462, 1912367.5196363116 4208097.869455872, 1912378.681631644 4208162.219244198, 1912389.2970731603 4208213.317243607, 1912394.1560530069 4208238.80785126, 1912420.855041655 4208344.861509624, 1912432.9145297068 4208397.0658912305, 1912466.984876752 4208539.731514646, 1912469.5513293713 4208551.3619267605, 1912471.839883219 4208562.606793684, 1912479.8161808122 4208609.289729084, 1912475.616804573 4208723.7681197105, 1912505.3713973537 4208846.206335681, 1912516.9076093356 4208953.488488159, 1912523.8500924069 4209091.570665039, 1912517.984459926 4209196.052243607, 1912505.0700959377 4209395.838688405, 1912495.439074687 4209481.496771149, 1912502.2790545742 4209534.301299745, 1912521.466551516 4209641.726998668, 1912530.4290434278 4209681.984139035, 1912561.3167478708 4209795.118311721, 1912574.3026064574 4209840.335130934, 1912580.048032512 4209859.762435946, 1912592.9310834089 4209897.570955586, 1912603.9337356456 4209927.936348832, 1912613.9616061284 4209955.844033761, 1912626.628560728 4209995.491324435, 1912645.5091798448 4210042.081084357, 1912658.500956069 4210082.9376144, 1912685.964593938 4210173.700998891, 1912710.1535827832 4210242.776297522, 1912811.1333313594 4210411.958975212, 1912812.61 4210411.07, 1912818.2497871092 4210407.67964824, 1912819.7943367378 4210410.076020303, 1912867.5798238663 4210380.817036658, 1912973.3524791722 4210316.059713683, 1913209.766112996 4210173.4933450315, 1913285.4412142104 4210127.435969549, 1913327.2056909348 4210101.723892216, 1913369.5575121478 4210076.215738641, 1913731.4589030738 4209854.155641587, 1913739.9634347234 4209856.258340878, 1913759.2531323493 4209852.771569805, 1913774.3237129122 4209850.233823535, 1913806.9455701513 4209844.754810212, 1913812.6259153385 4209844.060498441, 1913818.4407248874 4209842.806071051, 1913865.825617286 4209834.040964269, 1913867.4924872003 4209833.404729057, 1913890.343648593 4209818.013588985, 1913890.5217068698 4209817.896530487, 1913890.58618724 4209817.854077786, 1913898.2497130272 4209812.768649941, 1913902.3937240795 4209810.016834968, 1913920.1976581535 4209798.197417758, 1913920.676283736 4209798.12713308, 1913925.7637320946 4209796.979135558, 1913930.870274863 4209799.924966776, 1913934.2467671416 4209801.541419154, 1913954.6282577608 4209805.978493035, 1913960.8786315948 4209803.653551707, 1913973.5038974953 4209792.030162299, 1913983.4349213308 4209773.280681055, 1913995.1849462476 4209759.112185041, 1914032.9473712808 4209726.541292368, 1914056.0153460389 4209705.354285807, 1914084.503884462 4209692.379775128, 1914123.1716937367 4209676.100924976, 1914161.7891409982 4209647.967491892, 1914174.6337120715 4209641.085604, 1914199.2423686716 4209629.175071363, 1914227.181972719 4209606.878761807, 1914268.8626129325 4209588.402775427, 1914302.168553654 4209569.1518208, 1914329.7569405837 4209552.053622197, 1914357.6170312027 4209535.023634145, 1914378.0363273444 4209518.609182574, 1914399.3976256275 4209502.202733352, 1914405.0412381934 4209499.473385098, 1914414.574529776 4209496.608146485, 1914423.9195980425 4209489.410560447, 1914437.5988576123 4209470.358420025, 1914751.7927419266 4209343.906806404, 1914828.5963734633 4209313.074482225, 1914918.655438571 4209278.33024466, 1914978.657722387 4209254.485867729, 1915207.010371374 4209163.202053408, 1915279.0075538368 4209134.529247391, 1915291.3372773067 4209129.617104862, 1915325.9618707183 4209115.791932795, 1915326.3359142705 4209115.854218627, 1915330.8159401529 4209113.992769964, 1915452.1852518944 4209135.360197537, 1915527.1384215944 4209149.035833806, 1915566.2761373683 4209156.220612554, 1915574.4863562754 4209158.136437247, 1915584.3328430415 4209143.652158674, 1915618.3024262406 4209098.7236795295, 1916005 4208590.15, 1916035.93 4208549.49, 1916082.99 4208487.66, 1916106.53 4208456.73, 1916114.37 4208446.43, 1916132.29 4208422.5, 1916187.59 4208349.86, 1916233.62 4208289.39, 1916264.37 4208249.22, 1916277.5 4208232.07, 1916290.31 4208215.32, 1916313.6 4208185.63, 1916333.98 4208158.77, 1916346.06 4208142.86, 1916346.42 4208142.43, 1916350.7 4208137.51, 1916378.64 4208101.95, 1916404.27 4208069.05, 1916406.3 4208066.39, 1916427.5 4208039.24, 1916465.13 4207990.53, 1916485.16 4207964.61, 1916486.45 4207963, 1916482.83 4207959.66, 1916477.66 4207954.54, 1916472.13 4207948.76, 1916468.14 4207944.41, 1916462.7 4207937.14, 1916458.79 4207930.97, 1916453.25 4207921.49, 1916449.18 4207913.6, 1916445.62 4207905.58, 1916441.26 4207894.58, 1916436.62 4207882.89, 1916431.67 4207868.49, 1916426.24 4207853.72, 1916420.51 4207838.14, 1916415.75 4207826.87, 1916412.45 4207818.6, 1916411.22 4207815.54, 1916407.78 4207809.21, 1916405.81 4207806.23, 1916400.55 4207799.26, 1916398.5 4207796.94, 1916393.79 4207792.42, 1916386.95 4207786.91, 1916380.54 4207782.24, 1916377.51 4207780.16, 1916372.54 4207777.55, 1916354.12 4207769.22, 1916348.09 4207766.29, 1916343.39 4207764, 1916339.58 4207762.65, 1916323.99 4207757.48, 1916313.16 4207754.06, 1916303.07 4207750.87, 1916285.23 4207734.29, 1916271.99 4207721.62, 1916242.13 4207693.37, 1916218.91 4207671.84, 1916210.95 4207664.46, 1916206.18 4207660.02, 1916194.59 4207647.35, 1916190.16 4207638.7, 1916184.95 4207629.87, 1916183.37 4207626.91, 1916177.23 4207618.01, 1916167.1 4207606.65, 1916156.2 4207594.12, 1916143.67 4207579.74, 1916137.26 4207570.38, 1916130.7 4207561.33, 1916115.25 4207538.8, 1916110.26 4207531.75, 1916104.22 4207523.44, 1916089.08 4207502.25, 1916080.77 4207490.26, 1916066.39 4207470.81, 1916063.33 4207462.34, 1916058.2 4207443.6, 1916051.06 4207416.68, 1916043.02 4207385.87, 1916036.27 4207359.17, 1916030.35 4207336.54, 1916026.72 4207321.66, 1916022.93 4207306.15, 1916022.16 4207301.11, 1916021.72 4207293.61, 1916021.93 4207290.49, 1916022.99 4207277.08, 1916024.45 4207260.94, 1916026.26 4207235.82, 1916028.26 4207207.75, 1916028.37 4207203.06, 1916028.96 4207195.1, 1916026.81 4207186.94, 1916016.14 4207169.08, 1916000.89 4207144.86, 1915999.08 4207141.97, 1915995.34 4207135.43, 1915993.79 4207131.62, 1915983.86 4207105.12, 1915977.6 4207089.22, 1915965.71 4207059.39, 1915962.48 4207047.92, 1915955.05 4207021.59, 1915951.22 4207009.66, 1915949.79 4207005.2, 1915944.62 4206990.2, 1915940.08 4206979.52, 1915933.86 4206964.89, 1915929.6 4206954.89, 1915922.69 4206940.24, 1915915.91 4206925.86, 1915903.46 4206900.31, 1915889.02 4206870.64, 1915878.31 4206849.2, 1915874.08 4206837.98, 1915883.95 4206822.9, 1915889.5 4206813.12, 1915891.08 4206809.3, 1915897.02 4206789.81, 1915904.03 4206767.68, 1915911.51 4206742.16, 1915920.84 4206712.46, 1915927.84 4206690.15, 1915927 4206684.13, 1915922.97 4206671.5, 1915911.47 4206641.46, 1915905.51 4206625.91, 1915900.44 4206613.5, 1915893.01 4206597.2, 1915881.91 4206572.83, 1915877.33 4206562.78, 1915872.04 4206551.17, 1915871.93 4206535.88, 1915871.8 4206518.24, 1915872.32 4206509.93, 1915874.95 4206475.55, 1915875.01 4206465.65, 1915874.46 4206445.9, 1915876.34 4206430.4, 1915878.16 4206415.28, 1915877.78 4206393.85, 1915877.56 4206364.98, 1915877.91 4206342.1, 1915877.83 4206331.61, 1915876.49 4206328.03, 1915875.39 4206325.59, 1915871.31 4206319.92, 1915868.43 4206318.08, 1915846.27 4206305.78, 1915832.19 4206297.83, 1915809.18 4206285.55, 1915792.52 4206276.21, 1915786.25 4206264.66, 1915779.84 4206252.9, 1915773.57 4206237.61, 1915756.88 4206198.95, 1915745.91 4206173.54, 1915738.87 4206157.25, 1915731.82 4206140.92, 1915729.99 4206131.11, 1915727.07 4206118.21, 1915726.02 4206113.54, 1915727.8 4206100.85, 1915729.99 4206087.21, 1915731.97 4206072.66, 1915729.09 4206062.06, 1915725.11 4206050.33, 1915721.3 4206044.78, 1915716.52 4206038.22, 1915706.22 4206027.2, 1915690.68 4206011.05, 1915673.17 4205995.44, 1915662.81 4205985.77, 1915645.14 4205970.62, 1915633.98 4205960.64, 1915624.3 4205952.18, 1915615.74 4205944.45, 1915612.87 4205941.05, 1915606.55 4205933.19, 1915591.34 4205913.08, 1915584.37 4205904.35, 1915581.15 4205901.7, 1915569.26 4205893.89, 1915546.98 4205879.04, 1915540.66 4205874.82, 1915536.43 4205872.33, 1915524.89 4205861.73, 1915511.11 4205849.06, 1915493.61 4205832.85, 1915490.2 4205831.69, 1915475.69 4205826.55, 1915454.31 4205820.54, 1915440.35 4205816.61, 1915433.35 4205814.98, 1915430.53 4205816.6, 1915416.24 4205829.2, 1915397.35 4205845.85, 1915390.27 4205852.1, 1915383.04 4205857.72, 1915364.26 4205871.91, 1915345.25 4205885.79, 1915325.52 4205899.78, 1915320.93 4205901.4, 1915307.63 4205904.43, 1915302.47 4205906.97, 1915292.51 4205918.88, 1915279.49 4205935.18, 1915271.29 4205937.85, 1915253.27 4205942.49, 1915244.77 4205944.68, 1915239.14 4205946.72, 1915233.87 4205948.62, 1915231.38 4205949.86, 1915224.17 4205953.78, 1915220.95 4205954.85, 1915211.77 4205960.44, 1915199.28 4205969.99, 1915196.7 4205971.97, 1915188.52 4205977.14, 1915167.58 4205990.17, 1915156.08 4205996.81, 1915144.44 4206004.36, 1915137.31 4206014.8, 1915128.23 4206027.16, 1915111.39 4206031.93, 1915087.46 4206038.41, 1915065.01 4206044.5, 1915054.56 4206047.49, 1915045.6 4206046.98, 1915038.02 4206042.4, 1915029.28 4206037.62, 1915024.53 4206035.36, 1915015.98 4206027.37, 1915018.07 4206011.82, 1915020.16 4206001.75, 1915023.03 4205987.13, 1915030.52 4205968.48, 1915046.78 4205929.85, 1915054.25 4205911.69, 1915066.13 4205896.14, 1915093.17 4205861.11, 1915097.74 4205854.92, 1915122.1 4205829, 1915142.45 4205807.54, 1915148.34 4205798.5, 1915159.69 4205780.27, 1915168.76 4205760.74, 1915182.09 4205731.33, 1915193.99 4205704.47, 1915198.81 4205694.01, 1915200.54 4205682.77, 1915206.01 4205651.67, 1915207.51 4205643.14, 1915239.4 4205586.27, 1915243.24 4205564.71, 1915247.01 4205543.53, 1915257.01 4205528.47, 1915272.44 4205505.95, 1915281.34 4205493.13, 1915284.96 4205487.62, 1915293.55 4205484.1, 1915300.54 4205481.38, 1915302.76 4205478.5, 1915309.16 4205466.52, 1915328.54 4205430.71, 1915339.77 4205409.3, 1915338.95 4205393.7, 1915338.03 4205367.41, 1915337.15 4205354.24, 1915336.21 4205332.14, 1915335.58 4205322.91, 1915332.86 4205316.64, 1915328.57 4205313.95, 1915316.98 4205313.75, 1915308.87 4205314.1, 1915302.45 4205312.53, 1915290.77 4205309.3, 1915283.44 4205306.84, 1915281.86 4205303.98, 1915283.9 4205301.04, 1915291.76 4205294.32, 1915295.46 4205291.14, 1915298.68 4205284.7, 1915300.57 4205280.91, 1915305.96 4205274.1, 1915306.99 4205271.83, 1915303.44 4205265.1, 1915295.72 4205261.96, 1915284.64 4205261.06, 1915276.67 4205260.5, 1915269.36 4205259.31, 1915256.56 4205255.7, 1915248.1 4205254.74, 1915244.84 4205254.67, 1915240.92 4205255.95, 1915239.04 4205257.51, 1915232.25 4205261.84, 1915226.65 4205264.8, 1915220.88 4205263.37, 1915218.77 4205260.67, 1915216.51 4205256.61, 1915216.78 4205253.86, 1915217.98 4205247.37, 1915221.06 4205241.57, 1915225.96 4205232.34, 1915232.38 4205224.8, 1915235.17 4205222.18, 1915238.91 4205215.64, 1915238.49 4205213.07, 1915234.03 4205210.5, 1915224.55 4205208.87, 1915220.14 4205207.75, 1915215.62 4205205.75, 1915207.02 4205202.16, 1915201.74 4205199.96, 1915197.82 4205197.06, 1915197.77 4205190.27, 1915199.31 4205185.71, 1915201.01 4205182.83, 1915205.89 4205177.83, 1915209.66 4205175.86, 1915227.5 4205168.22, 1915234.19 4205165.12, 1915241.19 4205158.22, 1915245.67 4205150.36, 1915245.83 4205143.27, 1915238.14 4205137.22, 1915234.32 4205129.76, 1915232.97 4205124.92, 1915228.11 4205101.79, 1915224.09 4205086.77, 1915221.63 4205078.07, 1915218.98 4205070.93, 1915216.89 4205066.53, 1915214.54 4205062.94, 1915212.94 4205060.5, 1915207.83 4205055.7, 1915204.6 4205052.38, 1915197.08 4205044.83, 1915191.14 4205038.39, 1915186.17 4205032.5, 1915183.82 4205029.19, 1915178.68 4205020.92, 1915175.92 4205015.12, 1915173.63 4205008.92, 1915166.96 4204992.05, 1915160.62 4204975.71, 1915155.66 4204957.93, 1915150.74 4204938.35, 1915149.48 4204932.82, 1915147.53 4204912.5, 1915146.4 4204897.75))'::geometry,'38388','Saint-Georges-de-Commiers','SAINT-GEORGES-<br>DE-COMMIERS','SGC','SGC');
INSERT INTO urba_plui_ecriture.ref_limites_communales (ogc_fid,geom,code_insee,nom,nom_etiquette,nom_abv,trigram) VALUES
     (38,'SRID=3945;POLYGON ((1914400.3104821832 4229850.456629553, 1914431.7651931245 4229847.898134963, 1914501.4041797423 4229841.737566848, 1914505.7119450106 4229840.657908454, 1914634.591378626 4229787.710638428, 1914637.6699473958 4229786.874393639, 1914698.3622520308 4229761.925597003, 1915104.9067114408 4229594.561896235, 1915108.5113425911 4229588.887705237, 1915109.9151095273 4229586.604455039, 1915106.4507930009 4229469.7143959245, 1915105.0230784398 4229409.669208585, 1915104.7476317228 4229384.809856806, 1915104.5154552374 4229349.612387539, 1915104.4998528475 4229293.73613007, 1915102.2703851727 4229244.22336322, 1915101.0558010323 4229196.783172422, 1915100.8590727719 4229189.693984363, 1915101.2204554288 4229189.246859717, 1915101.5948902885 4229188.911657081, 1915103.7311857746 4229188.564347826, 1915117.4603046428 4229186.261096511, 1915118.8133498968 4229185.050267959, 1915119.5918892974 4229184.15879704, 1915097.2231447368 4229129.980354015, 1915095.3592127603 4229126.736393593, 1915086.7952827122 4229118.414517746, 1915081.6422060807 4229113.631003808, 1915045.419549606 4229084.114923926, 1915039.0074999984 4229079.932499991, 1915014.5261862222 4229073.331150615, 1915014.5725107666 4229072.350965372, 1915013.4266172135 4229072.086962461, 1915014.7925000095 4229043.812499988, 1915017.892806098 4229012.921098696, 1915017.0397665016 4229003.1642857585, 1915015.5775412908 4228987.953562599, 1915010.555 4228975.314999973, 1915005.954456285 4228946.571371221, 1914999.5500560177 4228932.55895314, 1914995.1171525507 4228922.125433193, 1914991.5289115235 4228909.034887085, 1914991.438561976 4228907.97556384, 1914989.0124861782 4228889.551456171, 1914977.513858328 4228857.016457541, 1914962.7142716816 4228838.239443624, 1914953.59835711 4228814.365969875, 1914949.406230614 4228803.432781741, 1914948.4634005504 4228801.004969424, 1914945.4580807523 4228794.817163271, 1914937.1400011904 4228777.970403123, 1914935.4937404308 4228773.07306603, 1914934.7512939908 4228770.939801797, 1914929.7446814363 4228749.189930306, 1914925.713427266 4228731.653479427, 1914925.4417077468 4228731.051862792, 1914924.5596356299 4228728.994342091, 1914907.1262862568 4228703.984701384, 1914906.8018581297 4228703.221318108, 1914906.140000006 4228701.552499973, 1914904.9764589826 4228694.117724925, 1914903.5794161248 4228684.449320459, 1914902.593009533 4228677.775067788, 1914901.1806782258 4228674.13546501, 1914900.6838417146 4228672.709672141, 1914898.9038796811 4228665.15802256, 1914899.4983582855 4228653.510894813, 1914902.3238956137 4228632.919468841, 1914904.5283251486 4228622.471470202, 1914904.20715136 4228614.440208009, 1914905.1177154214 4228546.237937686, 1914906.729109859 4228526.39406709, 1914901.8665604538 4228497.158391307, 1914894.3681708535 4228470.233024471, 1914886.0300000105 4228391.312500006, 1914872.001908268 4228342.445915011, 1914836.0900000085 4228269.159999974, 1914825.4725000197 4228259.592499973, 1914806.2103602148 4228232.850033892, 1914792.6587531532 4228217.6440069135, 1914782.380000006 4228214.217499963, 1914757.0213479945 4228148.034156099, 1914736.5975000008 4228101.244999985, 1914718.7700000259 4228034.847499993, 1914651.2875000138 4227888.004999987, 1914601.2091892858 4227832.115646034, 1914523.110326192 4227737.534937116, 1914518.6294106029 4227726.159673243, 1914514.7908020378 4227714.622594675, 1914497.2124999985 4227697.439999968, 1914484.4985830777 4227676.508120693, 1914483.1609278177 4227669.498881544, 1914483.8803774083 4227663.303854725, 1914481.9316887478 4227629.437074787, 1914471.1822992486 4227598.921999063, 1914448.7825000365 4227513.747499965, 1914407.5596650525 4227423.155208993, 1914403.4944182907 4227413.385598692, 1914396.2103799619 4227386.078810647, 1914389.5963558902 4227371.652609246, 1914375.1100000169 4227342.207499976, 1914366.6341457095 4227300.560249154, 1914355.846406485 4227250.641164012, 1914338.2409856708 4227204.28877669, 1914301.6679000382 4227140.323116025, 1914264.1483534323 4227059.167966224, 1914290.772950053 4227004.811784884, 1914302.958219419 4226980.113779615, 1914305.8925458163 4226968.5661059795, 1914309.089118858 4226953.11275954, 1914312.6033644704 4226913.0380370375, 1914314.9508228258 4226888.425273766, 1914314.3600777546 4226886.71453148, 1914309.2508063808 4226867.095109626, 1914215.7941412395 4226737.994248238, 1914087.7500000142 4226546.614999989, 1914093.4500000144 4226413.058750003, 1914084.4886285018 4226385.224601871, 1914020.8375000067 4226294.370000021, 1914006.729261256 4226214.605598151, 1914002.518633757 4226095.714150438, 1914003.2574125293 4226091.677730863, 1914003.5595123828 4226090.172979883, 1914012.3633312257 4226071.788354292, 1914013.83780239 4226068.70247895, 1914068.7794261053 4225948.90877703, 1914072.7982277304 4225905.336836222, 1914073.3081060494 4225902.026263551, 1914073.4524321877 4225901.033021362, 1914073.7702796198 4225896.775620775, 1914074.6590341427 4225884.826502704, 1914073.2918637653 4225881.073905763, 1914071.93513936 4225877.354423494, 1914069.287636717 4225870.102335918, 1914073.3179594565 4225863.690836277, 1914076.038024706 4225859.352201215, 1914076.5690928302 4225858.507931602, 1914081.018180449 4225851.402949324, 1914091.4904809832 4225801.678335211, 1914096.6127226546 4225777.62098368, 1914096.546540484 4225777.171809202, 1914096.4957338045 4225776.681855915, 1914090.11490231 4225763.326953655, 1914059.6919025248 4225700.293054318, 1914049.3972600864 4225698.613425403, 1914042.971866904 4225697.563963727, 1914042.7729690962 4225697.606682873, 1914042.5951572896 4225697.579659497, 1914024.3013961457 4225701.434227641, 1914024.280412452 4225701.281087031, 1914024.2173507907 4225701.294072345, 1914021.6610756118 4225686.331202991, 1914021.161639354 4225686.280478996, 1914021.155508914 4225686.2486247495, 1914020.9702518955 4225686.232004992, 1914005.4654981527 4225684.68561822, 1914005.4648431768 4225684.6855526, 1914005.4628077657 4225684.68535059, 1914005.1043045556 4225684.649468343, 1914005.0124167458 4225684.640483572, 1914004.6955123306 4225684.608585168, 1914004.4817666174 4225684.58777961, 1914003.844353108 4225684.523810053, 1914003.2851293103 4225684.468524873, 1914001.4742240596 4225684.287220987, 1913999.489201603 4225684.090095583, 1913995.8424017776 4225683.725112183, 1913960.3197799055 4225680.182575725, 1913970.0414492034 4225640.559983111, 1913958.8990250758 4225637.84003401, 1913958.8785439287 4225637.918183917, 1913958.7470999153 4225637.886008139, 1913955.8366342091 4225648.868164515, 1913955.6892300465 4225648.799121415, 1913955.637871766 4225648.9923101785, 1913942.733862308 4225642.956504853, 1913929.3305547654 4225636.786809854, 1913906.598078388 4225626.120700873, 1913894.2798987927 4225626.435834793, 1913889.2948150798 4225626.563272948, 1913889.5256408271 4225626.679440155, 1913888.7218042621 4225626.699745746, 1913900.9258246082 4225632.755343567, 1913900.4611765796 4225632.9759942135, 1913900.6217924268 4225633.05611523, 1913869.8520394762 4225648.179541993, 1913838.6159794063 4225650.446244195, 1913838.214691278 4225650.553366094, 1913837.124517465 4225650.8165720925, 1913836.1121086413 4225651.528660449, 1913835.059613812 4225652.201417301, 1913825.6669630217 4225652.657795127, 1913819.881745592 4225666.521691069, 1913814.3492965505 4225679.8750911085, 1913794.7298453555 4225688.093727596, 1913779.8762752737 4225694.334471151, 1913774.48366423 4225697.360380453, 1913771.693382223 4225698.940764911, 1913768.2673888404 4225700.866364787, 1913761.9340434982 4225704.445414254, 1913745.0145387903 4225714.00742337, 1913728.4508864204 4225723.417812727, 1913728.5148864512 4225723.488066196, 1913728.1580531478 4225723.693036134, 1913734.4674270782 4225730.609451897, 1913720.9726090394 4225734.695377435, 1913635.2109195075 4225760.631575011, 1913633.3498757747 4225760.737453416, 1913632.4288690968 4225760.768906373, 1913624.7098791993 4225763.046720156, 1913620.3388803424 4225764.484957165, 1913600.1560225189 4225771.254272676, 1913576.0320237244 4225779.396464796, 1913553.0644057363 4225787.204146606, 1913532.6067454878 4225794.175776265, 1913526.0163619618 4225796.425367939, 1913523.7575933638 4225797.194614343, 1913518.8189398877 4225798.867556748, 1913517.1413862568 4225799.435539873, 1913516.6481075366 4225799.602773236, 1913516.3179582448 4225799.714552084, 1913516.1958780475 4225799.755909706, 1913516.0912593424 4225799.791311084, 1913516.0478857434 4225799.8060065145, 1913516.0161286194 4225799.81676396, 1913515.9993161808 4225799.822456309, 1913515.9898984814 4225799.825651881, 1913515.980213907 4225799.828924057, 1913515.9737782816 4225799.831105014, 1913515.9688495076 4225799.832773226, 1913515.9609114535 4225799.835462693, 1913515.9606747075 4225799.835542872, 1913515.9602114048 4225799.83569972, 1913515.959941119 4225799.835791272, 1913515.9596076694 4225799.835904315, 1913515.9591567176 4225799.836057459, 1913515.958676386 4225799.836219989, 1913515.9577623557 4225799.836529455, 1913515.9561341798 4225799.8370808195, 1913515.9547743157 4225799.837542527, 1913515.951280254 4225799.838725358, 1913515.9467151524 4225799.840270415, 1913515.9406031335 4225799.84234096, 1913515.9172545753 4225799.850240847, 1913515.8903271419 4225799.859375894, 1913515.8533180298 4225799.871929158, 1913515.8036873275 4225799.888707182, 1913515.5264497567 4225799.982519511, 1913515.3867834262 4225800.030103637, 1913515.1440212447 4225800.112354873, 1913514.2173227675 4225800.425874184, 1913513.7131367235 4225800.59698893, 1913511.0481438825 4225801.498912754, 1913506.7414445733 4225802.959531161, 1913502.6911409115 4225804.330451171, 1913499.950431032 4225805.266717216, 1913496.1269078269 4225806.592681964, 1913496.077744231 4225806.550106046, 1913496.0086294184 4225806.573446458, 1913491.5148163273 4225802.8713691635, 1913484.5247439868 4225793.041117274, 1913484.0268642372 4225792.352531129, 1913483.982985959 4225792.345091826, 1913483.8904473437 4225792.226202529, 1913470.1363137288 4225789.843333076, 1913466.5888387908 4225789.3130027745, 1913462.126950985 4225788.856676214, 1913447.3562238577 4225787.573609202, 1913432.3174689256 4225786.282910807, 1913422.112500006 4225785.148124983, 1913377.311249998 4225779.622499984, 1913299.4606916816 4225770.5707883155, 1913298.6676953882 4225774.727988768, 1913297.8986168911 4225778.939541156, 1913293.938517158 4225800.2603728715, 1913291.09616571 4225813.6687539155, 1913289.226186673 4225822.593175199, 1913285.2664353834 4225838.239170997, 1913263.0056625097 4225900.388187658, 1913262.165823842 4225902.5040272195, 1913258.1633562527 4225912.795192587, 1913251.7909174077 4225926.162946271, 1913246.1228169792 4225936.155299993, 1913236.7714539152 4225950.882525342, 1913225.2551960172 4225967.388912517, 1913199.628887041 4226002.865209817, 1913161.913126989 4226053.498278669, 1913152.9991150647 4226064.741677228, 1913152.2468039396 4226065.705275275, 1913151.2104917977 4226066.83390025, 1913146.596943749 4226071.9432004625, 1913063.9477233095 4226156.99500857, 1913056.4087387626 4226164.6309430655, 1913043.5566111347 4226177.703970663, 1913030.5880348675 4226190.771538155, 1913023.8583399826 4226197.43283993, 1913019.815519801 4226201.435139651, 1913018.0989296052 4226203.132620428, 1913016.5166089667 4226204.697962769, 1913011.9514628302 4226209.148851982, 1913008.9356744573 4226212.064843242, 1913005.5931147689 4226215.305237486, 1913002.1273540747 4226218.686856402, 1912994.7859315332 4226225.805913978, 1912963.900314915 4226254.298014263, 1912962.9049061122 4226255.167020987, 1912955.6358610282 4226261.469375067, 1912952.4305177405 4226264.203648541, 1912948.9654990823 4226267.119524648, 1912940.6810546925 4226273.76379746, 1912920.190444132 4226290.007927709, 1912899.435486605 4226303.917871022, 1912885.3751765457 4226312.347056844, 1912879.041126854 4226315.743167166, 1912853.406371563 4226329.228386703, 1912848.44128623 4226331.675697309, 1912830.7848291188 4226338.892576626, 1912805.7477882185 4226348.401992123, 1912767.3700910902 4226361.194853219, 1912750.340370636 4226366.872477915, 1912742.9252854383 4226369.475035452, 1912737.6990040282 4226371.364693847, 1912700.1048634262 4226385.11522614, 1912699.9941413163 4226385.155728929, 1912699.7538364814 4226385.243709832, 1912697.372984405 4226386.114628839, 1912692.0147139938 4226388.072992609, 1912686.54383967 4226389.815946086, 1912664.9063216501 4226396.208900977, 1912631.3717191175 4226405.416330307, 1912596.0873208065 4226415.194586946, 1912593.9352811263 4226415.766779911, 1912593.4451642926 4226415.89720594, 1912592.899750923 4226416.042378185, 1912592.4605436358 4226416.159392104, 1912592.1331402694 4226416.246576726, 1912591.552900725 4226416.400499748, 1912590.3789435462 4226416.713218592, 1912588.5768912954 4226417.192891408, 1912588.3220793025 4226417.271004859, 1912577.090791919 4226420.889888677, 1912553.3060306814 4226430.501636886, 1912552.1027470855 4226431.016221723, 1912541.4818189596 4226436.151189198, 1912539.6651581663 4226437.02625322, 1912538.1181829206 4226437.774039436, 1912535.9457892778 4226438.824548555, 1912534.4344139376 4226439.555057182, 1912524.069953237 4226444.559605473, 1912480.796789063 4226465.542720814, 1912340.7596609197 4226533.253684194, 1912255.6868218142 4226575.418581093, 1912230.9095567355 4226588.660892076, 1912218.702499997 4226595.190000002, 1912168.7873419898 4226621.551004137, 1912120.966521654 4226647.029173844, 1912092.3919457272 4226659.3149527125, 1912089.5963176126 4226660.510878336, 1912084.67222524 4226662.57907353, 1912075.2352072722 4226666.452494929, 1912033.367768606 4226683.672874794, 1911957.28074897 4226714.916090907, 1911790.1079607669 4226780.576331912, 1911786.8579201987 4226782.255692215, 1911752.3037500014 4226804.118750002, 1911735.3419068484 4226814.790354649, 1911726.3566089077 4226819.343507006, 1911681.0934544324 4226842.156253296, 1911626.2394876878 4226862.31748405, 1911614.7924999367 4226866.410000005, 1911603.6779117896 4226870.094183588, 1911553.9812499552 4226884.1899999995, 1911467.105375093 4226899.962845547, 1911387.2914227725 4226909.502073284, 1911274.2995183594 4226923.361836799, 1911245.6912133284 4226927.264474866, 1911226.8653803237 4226930.287460089, 1911151.9809380774 4226942.2731062295, 1910976.8708409178 4226988.426589941, 1910969.2401860713 4226990.540144261, 1910961.1183971732 4226992.788682087, 1910946.9860886089 4226996.710119847, 1910929.884052177 4227001.4551473, 1910889.7552896088 4227012.538445047, 1910856.742749495 4227021.557182491, 1910843.424960747 4227025.192540147, 1910843.2570815939 4227025.238276012, 1910842.692317588 4227025.392321691, 1910840.783988915 4227025.912654838, 1910839.779794343 4227026.187109792, 1910838.578616571 4227026.5154963145, 1910838.112820105 4227026.641896373, 1910837.4423130245 4227026.825973176, 1910836.771773157 4227027.007125295, 1910835.9351844438 4227027.238276163, 1910834.825555376 4227027.538841698, 1910833.7818189852 4227027.823599337, 1910832.3075656723 4227028.225062634, 1910830.8071854915 4227028.635269313, 1910828.2465950625 4227029.3341054125, 1910822.5306909927 4227030.893497014, 1910818.5733034883 4227031.979447423, 1910812.8363802403 4227033.540588929, 1910799.9183553034 4227037.05646686, 1910798.753018519 4227037.515324056, 1910797.5882180345 4227037.975639213, 1910735.6860667204 4227069.486682636, 1910717.0822812628 4227079.34323812, 1910712.1771407754 4227081.970628812, 1910710.544711639 4227082.926046195, 1910660.1029368755 4227114.327480543, 1910656.4192527966 4227116.632088427, 1910644.471233379 4227124.446088358, 1910535.0800645459 4227198.087556943, 1910556.9189068903 4227217.698866392, 1910621.332813726 4227275.940890646, 1910672.074362351 4227321.828046554, 1910690.0892915023 4227338.113390685, 1910727.5462499994 4227371.756250001, 1910777.3436766146 4227416.278385615, 1910832.862191298 4227466.059013154, 1910921.2624999962 4227544.842500004, 1910948.6520648724 4227568.581645952, 1910965.9809716598 4227583.42555668, 1910981.66 4227596.214999996, 1910996.9832945305 4227609.2260020245, 1911003.2918533941 4227614.3417823715, 1911037.07875 4227642.356250002, 1911127.1047267164 4227717.045318834, 1911196.3566907533 4227774.602428012, 1911258.8747658443 4227826.493220133, 1911259.64067265 4227827.053007262, 1911260.4333215188 4227827.488386504, 1911261.895582645 4227828.283677649, 1911265.4230111334 4227829.7537348205, 1911270.7842712568 4227831.526244938, 1911273.9783389887 4227832.737009595, 1911277.2034882533 4227834.180496091, 1911277.6899111168 4227834.4648331115, 1911277.9070961508 4227834.595267089, 1911279.017235578 4227835.377983298, 1911288.4487842165 4227842.091919754, 1911291.7379838817 4227844.773677636, 1911293.3532597134 4227846.142467099, 1911297.2110460927 4227850.222684782, 1911300.6153005979 4227854.096749947, 1911301.9386386678 4227855.824676115, 1911302.7996975 4227857.059956287, 1911304.2700083565 4227859.416778101, 1911305.143740436 4227861.1455860585, 1911306.383103553 4227863.794189139, 1911308.1639247504 4227867.953545804, 1911310.6130108417 4227875.0669108555, 1911311.720324008 4227879.7100485, 1911314.6464835743 4227896.743595314, 1911317.4097566023 4227911.229292216, 1911319.9323525669 4227921.581385358, 1911322.3449481053 4227929.837148587, 1911323.1560531259 4227932.2477544695, 1911323.7701907165 4227933.613068618, 1911328.290051334 4227943.238907947, 1911331.834681175 4227949.017074899, 1911332.3023671098 4227949.64016338, 1911336.8412641224 4227955.065257221, 1911337.634856894 4227955.820962705, 1911340.0563967628 4227958.133380567, 1911341.0910719768 4227958.841852987, 1911346.7407415626 4227962.024589219, 1911355.9558252257 4227969.423676851, 1911363.3127371583 4227977.908317723, 1911375.023908606 4227994.209420656, 1911378.0942965737 4227998.250976733, 1911383.0309771232 4228004.719375459, 1911384.7635880997 4228006.879537757, 1911386.4213099468 4228008.9498601025, 1911388.4179615579 4228011.135601553, 1911388.457421899 4228011.178946397, 1911388.568207828 4228011.296555289, 1911399.3544362003 4228022.563172399, 1911400.8267054746 4228023.861766199, 1911408.804506618 4228029.687666881, 1911411.3400224028 4228031.3007563595, 1911413.6017471505 4228032.125846383, 1911419.025395271 4228034.019972628, 1911426.202226722 4228035.75775303, 1911440.3931853476 4228037.014422028, 1911446.863167612 4228036.137942755, 1911451.5741467704 4228033.516203736, 1911456.085149919 4228029.730878239, 1911459.6922990982 4228024.773576488, 1911462.622499999 4228017.362499998, 1911462.605313763 4228004.805885631, 1911462.48446959 4227971.13682931, 1911462.6916535913 4227968.532471608, 1911463.0436993882 4227964.386229757, 1911463.9985021353 4227962.107666203, 1911467.6527351583 4227954.607630705, 1911477.7293093512 4227926.289539542, 1911478.1628188272 4227925.063555151, 1911479.5578397624 4227925.827999476, 1911552.3189473678 4227975.769706468, 1911838.5894312933 4227999.553115871, 1911838.2263498576 4227998.403266581, 1911836.2355787363 4227992.098656829, 1911825.5271497846 4227958.839398046, 1911825.1908831312 4227958.495615149, 1911823.6687765734 4227957.254831298, 1911815.3942580514 4227955.002565048, 1911814.9291102905 4227954.884123631, 1911807.8809729484 4227937.430411676, 1911778.9631860764 4227905.141567301, 1911781.167747549 4227874.421107655, 1911791.8136731682 4227870.357689536, 1911851.9328170733 4227884.906262007, 1911927.9627591071 4227903.060863351, 1911983.7700274915 4227916.496166692, 1912011.162594033 4227923.036840856, 1912018.7979268348 4227924.8593136575, 1912021.9994717042 4227925.6235892605, 1912023.4058264561 4227925.959617736, 1912024.267570143 4227926.164831617, 1912024.559915976 4227926.234667283, 1912025.000540529 4227926.339680558, 1912026.7971572208 4227926.768911849, 1912026.8356363536 4227926.787028433, 1912027.9103962008 4227927.2611486595, 1912122.6340743047 4227998.127973421, 1912197.3970108805 4228085.365947402, 1912238.9653509262 4228134.184844593, 1912240.8965932147 4228136.446517233, 1912242.3250773342 4228138.118768801, 1912242.9551454533 4228138.853610604, 1912243.5114891278 4228139.502829093, 1912243.7001385563 4228139.723946291, 1912243.7544247468 4228139.787379791, 1912243.7930133776 4228139.832473289, 1912243.8287336333 4228139.8743047295, 1912243.831621534 4228139.877680849, 1912243.8511811278 4228139.9005658645, 1912244.4634731945 4228140.616713129, 1912246.8736023966 4228143.434250898, 1912274.2325505116 4228175.4007521, 1912361.7721287743 4228277.194785998, 1912362.2423933295 4228279.916561172, 1912362.58627571 4228281.783371426, 1912363.1331142257 4228284.815909971, 1912363.704184364 4228287.963548064, 1912364.4311946551 4228291.933997938, 1912365.7595514255 4228299.224726884, 1912367.8083353403 4228310.465898182, 1912372.6379504167 4228337.118503012, 1912464.3649999807 4228431.29749996, 1912469.243494864 4228469.707980901, 1912482.7381479614 4228512.287478383, 1912526.9482278356 4228536.9542299295, 1912543.4126820385 4228557.211448573, 1912554.9079736234 4228586.399232922, 1912541.4398062616 4228697.076111191, 1912540.0640580587 4228703.240144681, 1912540.0483932185 4228703.510144231, 1912542.4749929367 4228710.949242364, 1912601.345417029 4228892.478141781, 1912601.774886489 4228941.798989163, 1912633.1356941834 4228987.334669136, 1912634.593184062 4228994.743576019, 1912635.0196542845 4228996.939066699, 1912629.930988629 4229017.223709491, 1912618.3613056452 4229063.859777356, 1912612.1059112255 4229172.438564006, 1912646.620212541 4229282.399979746, 1912702.453865494 4229364.2946978705, 1912704.6803471125 4229381.2526561655, 1912702.343145949 4229391.827598311, 1912702.588755047 4229410.860101244, 1912715.085606341 4229474.306118506, 1912739.0402183447 4229531.038444465, 1912741.2311265825 4229551.750465072, 1912741.8638809926 4229554.4602099955, 1912755.1015775404 4229611.969862393, 1912741.379554757 4229649.983704526, 1912740.8107162276 4229684.109331725, 1912736.7437443128 4229711.94017717, 1912735.7885442744 4229741.406340371, 1912708.6408272649 4229838.655138244, 1912719.776795623 4229895.733308756, 1912710.852170195 4229960.578966236, 1912712.226012913 4229999.544877099, 1912712.7774787543 4230007.906919103, 1912717.1414654136 4230009.844858962, 1912717.4568228242 4230010.505668035, 1912898.2010619822 4230035.253303161, 1913029.4289923487 4230053.332415173, 1913155.1556636658 4230070.824662207, 1913305.0227736467 4230091.800415635, 1913305.8696480559 4230090.259755652, 1913306.89 4230090.4, 1913329.8134060777 4230043.839399959, 1913363.3909600812 4229988.138567781, 1913398.916127355 4229918.203871911, 1913423.599004971 4229860.465523835, 1913426.7234322897 4229853.140118749, 1913604.2605599791 4229873.896519331, 1913819.4881918614 4229899.754085402, 1914058.5827130727 4229879.5967563605, 1914124.5682602825 4229873.8925824175, 1914185.09565325 4229868.251871791, 1914277.1768487385 4229860.654846602, 1914374.9608463163 4229852.60744224, 1914400.3104821832 4229850.456629553))'::geometry,'38423','Saint-Martin-le-Vinoux','SAINT-MARTIN-<br>LE-VINOUX','SMV','SMV'),
     (42,'SRID=3945;POLYGON ((1905686.05 4212561.95, 1905687.7 4212564.76, 1905690.01 4212567.15, 1905692.74 4212569.13, 1905708.3 4212571.15, 1905728.01 4212611.26, 1905740.53 4212615.15, 1905756.21 4212621.44, 1905758.95 4212623.84, 1905763.59 4212626.7, 1905771.76 4212634.13, 1905778.03 4212641.52, 1905792.79 4212672.78, 1905796.93 4212679.49, 1905798.16 4212682.08, 1905829.27 4212729.47, 1905847.08 4212757.58, 1905800.75 4212961.72, 1905798.428098735 4212965.719550596, 1905906.1498161098 4212886.39497677, 1906035.057684943 4212791.192549027, 1906090.151256058 4212750.412076332, 1906175.4047612345 4212687.655623739, 1906446.0337536673 4212488.1374536, 1906548.418831955 4212412.810964406, 1906632.2820263072 4212351.099571976, 1906633.5744787676 4212350.600143578, 1906636.6888096407 4212349.360802423, 1906715.3572710354 4212339.044205488, 1906810.1778271953 4212326.367568979, 1906981.2669378305 4212407.118402518, 1907051.8083419208 4212474.897447762, 1907056.071597891 4212477.295552163, 1907060.091634514 4212479.410158044, 1907083.5998083628 4212484.984479982, 1907120.7528020914 4212493.85876415, 1907126.8609170383 4212493.859225473, 1907129.3669793024 4212493.923144099, 1907197.7252551627 4212481.541891189, 1907208.2791082945 4212479.628650769, 1907260.3623481782 4212509.850121457, 1907305.6501696208 4212535.454862694, 1907317.1637740692 4212540.008144311, 1907319.399397771 4212539.724380329, 1907319.6401728613 4212539.701666837, 1907332.643796842 4212532.762050431, 1907349.3236020503 4212525.416754804, 1907352.8946678024 4212523.877579237, 1907354.967231041 4212523.198303895, 1907356.8778338148 4212522.625329181, 1907358.5215668408 4212522.348041626, 1907367.6512290244 4212521.033559097, 1907395.0736621844 4212518.729986386, 1907395.5645509963 4212517.590330639, 1907397.8022735142 4212517.423064366, 1907402.8327566434 4212506.034776964, 1907410.0400542028 4212502.507271369, 1907410.1299740258 4212502.486291416, 1907413.773029708 4212501.741875966, 1907448.4006279327 4212504.173739587, 1907497.8511634588 4212530.430733984, 1907533.722076065 4212540.705033564, 1907553.6200578227 4212564.296988686, 1907573.178494925 4212581.469372067, 1907614.8333873656 4212592.840123236, 1907620.4083545704 4212592.909849609, 1907621.1898440002 4212592.961676556, 1907629.7253069605 4212590.893750335, 1907660.798978013 4212583.44149617, 1907701.307335035 4212601.208224744, 1907705.4380874033 4212641.137278352, 1907742.4871837595 4212677.465, 1907751.3917430858 4212693.522026736, 1907772.3936600345 4212699.014640905, 1907812.945295413 4212719.690489322, 1907831.7347598865 4212740.957866992, 1907829.500664419 4212750.310395454, 1907853.0258263908 4212772.011555826, 1907913.459778403 4212830.128650104, 1907929.6044599258 4212856.039704586, 1907963.47301015 4212878.932474624, 1907976.166311165 4212900.206842143, 1908012.5994253247 4212964.126296305, 1908071.5606374047 4213020.095891877, 1908087.379540372 4213023.641243537, 1908088.0626738872 4213032.419305696, 1908125.540468458 4213039.615855154, 1908127.862982638 4213038.964925575, 1908137.3875821226 4213035.45621694, 1908141.8591487214 4213034.665175245, 1908148.156505075 4213039.30281624, 1908168.5531245668 4213061.80499359, 1908170.4819939535 4213071.454431595, 1908202.4787395862 4213111.055152254, 1908228.341772957 4213125.41911918, 1908261.6753492663 4213167.686286874, 1908289.4533192823 4213193.0538497465, 1908301.779942779 4213207.393436061, 1908319.199079993 4213256.951084642, 1908326.0071636147 4213256.317033149, 1908338.386579097 4213255.826385585, 1908346.9878070122 4213313.920309119, 1908350.7124799292 4213334.941881941, 1908367.5891274058 4213391.806597482, 1908354.9685918798 4213432.553301015, 1908281.2014497756 4213553.640868046, 1908437.5464081203 4213563.883827445, 1908623.5320406011 4213574.708536579, 1908814.8338827444 4213586.597326918, 1908911.232573197 4213592.675988178, 1908925.8994091745 4213613.248642632, 1908933.8760112042 4213630.933208608, 1908946.5110226714 4213641.607395915, 1908955.0267761322 4213660.015929865, 1908961.86217689 4213667.993518151, 1908988.5909892495 4213680.654832323, 1908997.2524294998 4213684.596248321, 1909002.2285276202 4213686.217960378, 1909009.8393478715 4213687.254551799, 1909010.0833669037 4213687.29300831, 1909022.2786497383 4213687.592047104, 1909028.7914320668 4213687.834362103, 1909035.3902235304 4213688.243636596, 1909036.7097737142 4213688.4468794335, 1909038.432430333 4213688.727537999, 1909043.7641747 4213690.15487119, 1909050.0881597183 4213693.055956172, 1909074.2399647313 4213711.442447561, 1909084.0363297146 4213724.557303233, 1909088.0763077557 4213726.800554218, 1909090.2957966465 4213728.186427429, 1909098.523442351 4213728.615080606, 1909111.721464913 4213730.643882755, 1909113.506922918 4213730.91985933, 1909117.3928780325 4213731.012767496, 1909123.5680374273 4213731.162480803, 1909127.1930699714 4213731.540271549, 1909133.8327926542 4213732.8653863715, 1909193.6232004147 4213747.35819684, 1909203.32007465 4213748.774571876, 1909209.5041139536 4213749.123943647, 1909223.6956580996 4213747.590031453, 1909239.6128351984 4213746.202778007, 1909245.7449856743 4213745.783740796, 1909249.1050991039 4213745.765020972, 1909274.9483394483 4213747.06086918, 1909280.3250906218 4213747.982816657, 1909289.4020328869 4213750.64391217, 1909292.3495914442 4213752.222917044, 1909303.8391252572 4213758.538152216, 1909308.1217478146 4213757.076479435, 1909309.7751362808 4213754.761544121, 1909318.4320931372 4213743.175171921, 1909323.160240811 4213732.9326738855, 1909323.596255438 4213731.86926144, 1909324.6106479345 4213729.428408119, 1909325.0726340387 4213727.813150628, 1909328.7558666444 4213715.288997977, 1909339.35 4213669.08, 1909345.6910203006 4213637.35160203, 1909349.120244661 4213614.547474625, 1909347.895 4213603.835, 1909355.3517790101 4213592.748581344, 1909360.0323314662 4213557.774122858, 1909358.8293213157 4213528.8217959395, 1909355.4373474494 4213471.658305275, 1909365.83 4213463.230387819, 1909378.8024746242 4213452.437474624, 1909393.4695576953 4213439.260678484, 1909400.8829830382 4213431.350223732, 1909416.0229842276 4213413.962570851, 1909447.5966264792 4213378.311889663, 1909460.9481468282 4213362.805577624, 1909473.375295413 4213344.322959399, 1909477.2984366335 4213333.917074755, 1909479.7392999567 4213312.150929872, 1909480.0437826854 4213298.66690433, 1909479.0274284207 4213272.323296466, 1909484.2764588718 4213257.58403045, 1909496.5269098943 4213225.417096516, 1909501.5642231912 4213210.958913193, 1909504.5488866398 4213189.639979756, 1909507.4168046417 4213162.547996752, 1909509.759705586 4213142.704386716, 1909509.7426067118 4213136.99516857, 1909509.6001284656 4213135.57747197, 1909509.4205870447 4213133.790627531, 1909507.9193533359 4213126.413877425, 1909507.2782154554 4213124.386322714, 1909504.4768876077 4213116.423933846, 1909491.7135669063 4213093.640831131, 1909490.1558256964 4213091.059717171, 1909489.6724045025 4213089.77669475, 1909487.391473598 4213083.064800215, 1909495.7283434952 4213078.408662249, 1909512.2887695516 4213071.178373572, 1909523.254088689 4213067.377556492, 1909532.9049147614 4213064.870556774, 1909543.4693151957 4213063.66889683, 1909550.9637758126 4213063.476980525, 1909556.1073699186 4213064.093557941, 1909569.0395056412 4213066.20143094, 1909581.3549203519 4213068.7727029165, 1909590.4908548084 4213070.10276544, 1909594.8626994565 4213069.872251091, 1909600.2617827964 4213069.018669647, 1909615.2431703003 4213064.731450797, 1909652.5592210167 4213053.527044798, 1909668.8253166266 4213048.221796478, 1909684.5675968993 4213043.452204049, 1909689.5438117625 4213041.9238144765, 1909701.8872380417 4213034.095005354, 1909712.486960647 4213026.14161924, 1909721.6960931174 4213018.763947368, 1909734.8065685944 4213008.700899784, 1909743.2876390237 4213002.514883145, 1909747.1301897317 4212999.826319739, 1909750.9351658383 4212997.600459908, 1909788.908238023 4212979.00054851, 1909798.3475750308 4212974.441841758, 1909814.249364522 4212966.906419275, 1909819.108327002 4212964.525282008, 1909834.3848529835 4212957.006613704, 1909858.6937990831 4212944.533363599, 1909880.3333904715 4212934.36626741, 1909926.4840014088 4212917.1433664635, 1909926.2704411424 4212916.51506597, 1909927.2613995946 4212916.147657263, 1909914.2194366911 4212885.198291863, 1909911.0182349212 4212877.40024123, 1909895.2445614287 4212839.270387819, 1909884.6432006552 4212813.505623262, 1909874.5492281232 4212790.893099537, 1909865.208896303 4212768.122711635, 1909856.6097197747 4212748.84511658, 1909855.9782201913 4212747.428638765, 1909855.950015886 4212747.365600333, 1909853.1565557462 4212741.258662205, 1909850.8528340065 4212736.226031899, 1909845.9792220993 4212725.660369435, 1909836.8756602448 4212706.785854741, 1909835.896053984 4212704.761485458, 1909832.6498468579 4212697.976775463, 1909830.9214019189 4212694.208435626, 1909826.09094515 4212683.663939244, 1909823.6440632904 4212677.975301311, 1909820.0379703937 4212668.727211465, 1909797.9782248484 4212612.390294108, 1909782.782257238 4212582.532899549, 1909766.7332373688 4212550.695341093, 1909762.9789858193 4212544.340664234, 1909730.7349260384 4212490.060520272, 1909747.741236352 4212483.053900801, 1909742.1320745633 4212407.328804703, 1909742.666354446 4212406.006634913, 1909743.1090735737 4212404.997922433, 1909749.4940442734 4212400.9526060615, 1909772.9678797657 4212386.144091557, 1909801.3850180935 4212372.3490092, 1909795.4355978142 4212357.60105376, 1909787.712268534 4212337.949684108, 1909786.6629434584 4212335.044684312, 1909787.0129781598 4212334.989824505, 1909789.219069013 4212334.644071015, 1909793.518219212 4212333.979889772, 1909795.17875601 4212333.643466782, 1909802.6126568825 4212331.622583502, 1909806.2248653544 4212330.350111069, 1909816.5067590782 4212326.094368995, 1909845.2526627977 4212314.114142717, 1909858.4179391568 4212309.594670365, 1909864.1382830115 4212308.732631474, 1909866.8959514154 4212308.740850203, 1909867.6679114907 4212308.638324255, 1909869.5813128718 4212308.3842006335, 1909868.5427828378 4212305.549412414, 1909865.6035779032 4212300.931769378, 1909831.792036053 4212254.444173609, 1909837.1857228996 4212248.8915489735, 1909844.588617884 4212242.415225865, 1909852.7090490526 4212235.316997069, 1909900.970569984 4212192.542959184, 1909764.19305668 4212022.108157895, 1909746.8781023645 4212000.466181102, 1909744.3263738598 4211997.286321926, 1909739.3325402658 4211991.2503707055, 1909794.9960184374 4211935.340012966, 1909828.7021534808 4211900.732302357, 1909833.473678826 4211896.705338153, 1909842.174321546 4211888.018170217, 1909850.281247041 4211879.1124243345, 1909850.97273173 4211879.243005133, 1909851.5 4211878.79, 1909853.2763044706 4211877.089377674, 1910100.8201075196 4211924.997084582, 1910129.975364623 4211930.552409102, 1910129.792797326 4211930.129607601, 1910136.0791038817 4211931.243229198, 1910020.564365332 4211662.239151255, 1909917.0948003347 4211422.88257129, 1909852.1947644348 4211272.4731025575, 1909821.5139380442 4211206.933827445, 1909744.9328578957 4211108.526417216, 1909715.4791565356 4211033.075589914, 1909663.8352863165 4210991.287968495, 1909632.986399024 4210913.68038782, 1909599.32320406 4210824.987386766, 1909596.1814778908 4210806.519259455, 1909591.5368991047 4210763.414664109, 1909583.9208802632 4210737.960856853, 1909575.4242751126 4210721.4869989455, 1909529.8233990371 4210664.561654657, 1909501.1935411282 4210624.30198985, 1909485.5756366032 4210599.531818937, 1909464.7062324174 4210559.718754807, 1909426.3446043585 4210515.258610916, 1909420.9408406226 4210502.352026363, 1909409.0370902626 4210486.697564163, 1909395.1566492554 4210468.992865176, 1909381.1835872938 4210440.990150307, 1909368.5644673035 4210412.776941913, 1909349.8569038224 4210362.510482545, 1909342.8676813063 4210341.986534554, 1909339.1795069664 4210335.406139396, 1909312.8223497586 4210302.290077493, 1909295.5144156376 4210278.073680745, 1909274.65321832 4210250.665782961, 1909260.337856795 4210217.3940343475, 1909228.2747709888 4210181.7339278925, 1909220.592333194 4210170.859174829, 1909213.2769763402 4210157.706722939, 1909212.3939219797 4210155.812267753, 1909208.578768083 4210143.544659772, 1909200.3242185486 4210116.925981101, 1909191.2944006566 4210110.206142833, 1909181.9568834137 4210092.863733122, 1909111.0066659376 4209952.882369414, 1909071.160241838 4209951.910181155, 1909069.9795217968 4209949.147928082, 1909069.631182777 4209949.153772408, 1909066.3925155583 4209940.756252953, 1909059.637739645 4209923.412687623, 1909038.2158643599 4209885.861540269, 1909004.3255170684 4209885.395981989, 1909002.3414807164 4209882.153710652, 1909001.6921029815 4209881.11564171, 1908973.5943274768 4209836.211226508, 1908966.2086102478 4209823.430643454, 1908941.650765469 4209777.782442929, 1908936.8117000572 4209771.585302434, 1908936.5315079188 4209771.203780451, 1908929.5398212443 4209763.430931475, 1908927.6977108195 4209759.388580922, 1908924.8815918434 4209750.228359164, 1908918.477529924 4209710.956560375, 1908879.5749492485 4209600.794275112, 1908854.2404178581 4209552.6554740695, 1908849.1062044853 4209548.000217259, 1908847.9498420176 4209547.052878842, 1908844.0054075825 4209545.014384926, 1908830.3744547837 4209538.028926101, 1908826.5505906106 4209537.150014494, 1908780.3507736924 4209530.36146786, 1908775.9673210904 4209528.683062095, 1908736.864323965 4209487.765401045, 1908676.8180886689 4209446.415179369, 1908623.9741410501 4209412.0921512, 1908590.1255491704 4209381.588407067, 1908494.6608351546 4209347.128245747, 1908479.913986865 4209344.409696757, 1908451.848478112 4209340.289077656, 1908420.3032146557 4209380.187736538, 1908413.2143784477 4209374.770932837, 1908412.431423424 4209374.18820122, 1908375.6944450573 4209346.914139651, 1908352.8990414836 4209329.9740207335, 1908352.0127940432 4209330.378507108, 1908347.2785579152 4209326.945701056, 1908264.0516436854 4209365.155927894, 1908238.4131533084 4209439.383854733, 1908146.780322448 4209402.44986017, 1908146.4163676016 4209402.156137523, 1908138.5061480568 4209395.344622476, 1908102.2621803007 4209301.70541004, 1908093.5280499249 4209294.726326862, 1908066.9886941658 4209283.087122034, 1908062.0028797092 4209280.948186181, 1907998.6917657573 4209219.855993742, 1907997.7271370844 4209220.641628668, 1907974.703647448 4209221.425321245, 1907971.4504913602 4209223.522730416, 1907942.5184947108 4209148.466768372, 1907875.7319481943 4208990.10206789, 1907825.6950346748 4208831.415565857, 1907783.1348060903 4208587.226701553, 1907777.7995363257 4208588.102526698, 1907777.2827165022 4208585.317966736, 1907692.8913884833 4208601.085987183, 1907658.4027774935 4208616.889528267, 1907655.5112226803 4208616.763920033, 1907652.2041205775 4208616.72314221, 1907638.9012203128 4208609.643374786, 1907633.8170405012 4208608.329987421, 1907629.1847671592 4208608.063355556, 1907621.9983549977 4208607.63809897, 1907615.7932092524 4208607.02851617, 1907604.7508341921 4208605.924772548, 1907572.0972255603 4208598.94595565, 1907563.1832964667 4208595.996509624, 1907536.967337117 4208584.910393328, 1907500.4485251396 4208561.443999344, 1907465.0026566715 4208545.33454262, 1907419.4756278982 4208508.395019707, 1907397.1466401785 4208496.692306065, 1907372.9452429132 4208486.234150579, 1907348.4623802362 4208479.873166678, 1907332.554487245 4208478.076424228, 1907312.317631427 4208478.168845637, 1907285.6642105354 4208479.620801299, 1907283.7784612202 4208479.727307421, 1907271.5385974469 4208480.894214853, 1907269.918865474 4208481.116954529, 1907249.6601826106 4208484.023117112, 1907239.455267911 4208488.101440811, 1907211.1806421971 4208502.539965447, 1907207.936212671 4208503.924256408, 1907175.9499069888 4208511.564223806, 1907170.3861903206 4208514.533891788, 1907169.3690980517 4208515.211040753, 1907165.272374542 4208517.977846572, 1907163.7167827415 4208519.228243073, 1907160.3478552082 4208523.242395695, 1907145.7909216075 4208543.3783397125, 1907138.8182852555 4208550.648608059, 1907105.9729310933 4208577.794423771, 1907096.5403825704 4208583.891052944, 1907092.9110617484 4208586.207372338, 1907088.9262006595 4208589.426277336, 1907086.547094533 4208591.396278597, 1907085.3323758985 4208592.65778189, 1907080.3515147483 4208598.1079227775, 1907076.1370889533 4208600.926023557, 1907069.5557247743 4208604.10838034, 1907051.8546779691 4208605.641812716, 1907053.458595161 4208597.714010484, 1907057.9431274876 4208581.353229353, 1907060.074631098 4208573.607613622, 1907063.7476530562 4208554.518764073, 1907064.0605434559 4208552.106823707, 1907063.9532406293 4208551.909196349, 1907064.75 4208543.39, 1907064.8015712858 4208541.666458707, 1906941.3914588718 4208394.731306617, 1906817.176991719 4208245.200579919, 1906638.8786396922 4207879.0925714, 1906625.4257807417 4207732.334549705, 1906602.8146525305 4207477.73359188, 1906595.7114353843 4207397.869457205, 1906595.5243998375 4207398.036478905, 1906595.286402471 4207395.155181588, 1906365.9651628507 4207601.262796984, 1906100.5910857753 4207844.544367627, 1905979.5598251193 4207901.49344396, 1905930.1523867657 4207935.309570525, 1905832.7334408336 4207961.22057006, 1905795.1013450355 4207976.360741127, 1905715.985896853 4208041.0921512935, 1905629.8118939456 4208059.836937523, 1905548.0469807533 4208080.647386765, 1904362.742790962 4208190.466636288, 1904344.7740975085 4208204.558593344, 1904359.97 4208307.99, 1904360.72 4208310.73, 1904372.41 4208389.15, 1904405.2 4208596.35, 1904408.23 4208612.44, 1904438.2 4208753.85, 1904448.9 4208799.25, 1904518.21 4209116.87, 1904518.78 4209120.26, 1904526.37 4209172.62, 1904530.35 4209193.22, 1904566 4209327.53, 1904612.57 4209511.48, 1904663 4209705.78, 1904683.02 4209779.92, 1904725.27 4209941.32, 1904771.3 4210121.16, 1904800.86 4210236.97, 1904925.92 4210492.13, 1905064.23 4210771.27, 1905205.79 4211059.09, 1905323.95 4211296.88, 1905332.87 4211487.53, 1905336.81 4211561.11, 1905351.27 4211701.58, 1905352.41 4211708.65, 1905367.52 4211776.02, 1905378.96 4211824.09, 1905418.44 4211976.96, 1905457.37 4212082.17, 1905516.56 4212221.76, 1905521.26 4212232.32, 1905561.52 4212313.21, 1905586.63 4212361.76, 1905596.43 4212373.28, 1905618.24 4212394, 1905641.29 4212416.89, 1905642.51 4212419.91, 1905644.74 4212469.07, 1905686.05 4212561.95))'::geometry,'38436','Saint-Paul-de-Varces','SAINT-PAUL-<br>DE-VARCES','SPV','SPV'),
     (46,'SRID=3945;POLYGON ((1917510.6974307054 4225395.486692117, 1917511.6939925905 4225393.332635079, 1917557.2653565994 4225312.75580497, 1917581.736257423 4225269.273173471, 1917585.2223444157 4225263.14761048, 1917589.1169292633 4225256.269348745, 1917595.115625693 4225245.681504532, 1917607.3467874625 4225224.1292591235, 1917629.154780547 4225185.372760918, 1917630.4513392262 4225183.299816575, 1917631.0576722655 4225182.346334544, 1917645.0287665846 4225157.726252953, 1917685.109488766 4225087.25602842, 1917781.1274265922 4224918.961341191, 1917894.2902628907 4224938.748915156, 1917963.1499122488 4224853.000424499, 1917986.016853181 4224813.451380147, 1918045.2019421763 4224710.925418111, 1918053.4199999338 4224695.860000127, 1918093.49 4224626.42, 1918094.1 4224625.5, 1918094.88 4224624.13, 1918094.897452732 4224624.09654893, 1918095.72 4224622.52, 1918096.24 4224621.28, 1918110.247541672 4224602.452920935, 1918125.7295214648 4224581.752403018, 1918152.0482681035 4224546.545507237, 1918205.4904051004 4224475.39043587, 1918236.2758518057 4224434.20236587, 1918282.6367011918 4224372.175712815, 1918321.036859531 4224320.900294497, 1918355.9075653793 4224274.001211752, 1918387.5680381698 4224231.474440144, 1918415.3177807524 4224194.201181691, 1918426.65 4224178.99, 1918431.110274541 4224173.456897774, 1918439.823916731 4224161.447447932, 1918442.5535274865 4224157.787584957, 1918443.1667527058 4224157.109480988, 1918445.5581462036 4224154.542112194, 1918470.2425323639 4224120.944207376, 1918449.1917554347 4224109.932836512, 1918376.9252431812 4224072.248339145, 1918377.683602175 4224071.067398565, 1918377.3364307208 4224070.879332823, 1918387.04834514 4224055.607808712, 1918389.3229868694 4224051.208639383, 1918390.9386184295 4224047.900971676, 1918400.9512145864 4224023.436250025, 1918407.8673722846 4224005.381002452, 1918413.8418309907 4223989.967511139, 1918419.2216245094 4223975.144696385, 1918421.746794484 4223968.199901044, 1918429.9781072885 4223944.849860464, 1918432.1933957487 4223937.9925354505, 1918441.07 4223892.5, 1918444.56 4223868.34, 1918445.64 4223850.52, 1918443.74 4223824.2, 1918439.7786152444 4223809.596399141, 1918439.6741168092 4223809.211452854, 1918438.8457700477 4223806.15689564, 1918438.5893720798 4223805.167052608, 1918437.2133799098 4223799.849514274, 1918437.11 4223799.45, 1918406.14 4223768.02, 1918403.7192954973 4223770.550500252, 1918379.0375186699 4223742.69986996, 1918376.479842212 4223740.2173671685, 1918361.6957235583 4223723.996189104, 1918354.1532768123 4223715.414569813, 1918343.0435352244 4223700.156692698, 1918329.3430870364 4223681.305232784, 1918333.5152925877 4223671.283930603, 1918333.6172399381 4223671.316783203, 1918337.9986661766 4223672.727401444, 1918342.123370142 4223674.060337594, 1918352.0274794602 4223677.261170006, 1918356.82 4223678.81, 1918369.9066142903 4223658.01598346, 1918388.2949997974 4223628.850926136, 1918400.7831499893 4223609.375444066, 1918405.3625608413 4223602.330039448, 1918410.9884301326 4223593.676949066, 1918417.41 4223583.8, 1918420.3834537705 4223577.861666688, 1918409.528779646 4223571.327652328, 1918436.9820174337 4223536.2207890125, 1918459.8242618262 4223507.028657166, 1918462.598291047 4223503.553051399, 1918464.7466399968 4223500.812594764, 1918465.6989125255 4223499.571702133, 1918466.2053272538 4223498.919099254, 1918475.4601891902 4223487.172443501, 1918484.6769271474 4223475.3792443555, 1918498.6748156992 4223457.636626857, 1918507.6091022757 4223446.406770306, 1918515.8047298533 4223436.345328057, 1918525.319471197 4223425.675891863, 1918574.6579890861 4223364.955822369, 1918583.4660429463 4223354.389608329, 1918599.7421709858 4223333.541611475, 1918608.5972779098 4223322.659848668, 1918616.697807436 4223312.6117747845, 1918677.3286842557 4223236.92360173, 1918658.5636878693 4223202.800434771, 1918577.2761370013 4223054.29693919, 1918584.1522166133 4223048.742787268, 1918590.9599999937 4223041.090000008, 1918594.7044399262 4223035.571972602, 1918610.6982511322 4223009.201935447, 1918612.0354447763 4223007.008524164, 1918616.2861231016 4222999.107170158, 1918617.0886997846 4222997.173550899, 1918617.6345371068 4222995.875555708, 1918618.767120264 4222992.892588606, 1918622.3052360178 4222984.399985206, 1918623.3196688225 4222981.832487099, 1918628.9460025674 4222966.985888803, 1918629.3999019628 4222966.042028584, 1918630.31165615 4222964.224008636, 1918634.5733622462 4222956.89245062, 1918638.7050777515 4222951.177950182, 1918655.139045935 4222931.121415746, 1918669.5137499992 4222912.658750004, 1918674.896328163 4222897.070343089, 1918681.8372591333 4222868.225848393, 1918685.8515223193 4222856.946883322, 1918691.0890381294 4222850.209650266, 1918694.620831034 4222845.537191678, 1918697.5893100167 4222835.111951735, 1918704.1309588533 4222813.928897519, 1918724.125495913 4222724.391914822, 1918734.2375000026 4222680.4575000005, 1918755.0775000008 4222589.659999999, 1918768.3075038742 4222531.608971273, 1918808.7079514647 4222356.199578478, 1918846.8044138162 4222188.820883149, 1918902.2239907107 4221948.091870674, 1918910.2386781734 4221912.4427950205, 1918942.987793087 4221771.176176246, 1918953.8886007343 4221724.3988045575, 1918955.3624999982 4221717.219999996, 1918976.530466199 4221624.242122143, 1918985.608873137 4221584.204999818, 1919012.534942236 4221467.7257648995, 1919015.6337478778 4221451.350376672, 1919012.6045742717 4221446.527474068, 1918648.1000000027 4221434.373279341, 1918408.9718865931 4221426.816350148, 1918195.173198208 4221420.528724704, 1918187.1971530856 4221418.554171762, 1918181.1426255354 4221418.199754544, 1918173.052520251 4221418.312079945, 1918030.5473355632 4221434.174141372, 1917882.3841677033 4221451.3860170515, 1917697.002418915 4221473.305428072, 1917696.1380420597 4221471.446239116, 1917681.2569908402 4221463.224570467, 1917541.6066058578 4221488.947819298, 1917540.2920951212 4221489.272807745, 1917450.1904161454 4221500.687764011, 1917441.58666538 4221501.094473022, 1917286.6694015784 4221534.60810854, 1917201.0966877516 4221554.500063251, 1917157.6665412153 4221564.442301622, 1917120.1807377702 4221573.151455801, 1917120.3666171003 4221573.42133829, 1917120.2397565478 4221573.544106567, 1917137.3825701175 4221596.0720850285, 1917145.7077758193 4221607.945066773, 1917149.8839600347 4221614.522264687, 1917130.428726719 4221625.973433506, 1917115.0580252383 4221635.023994596, 1917103.584832285 4221641.606247384, 1916986.2174280775 4221710.851286723, 1916953.9096376335 4221729.732370608, 1916953.016929739 4221730.154065194, 1916949.6833123534 4221731.739334489, 1916929.9327884791 4221763.77128543, 1916929.5102412314 4221763.182217758, 1916915.5012326161 4221746.499455593, 1916912.9871208777 4221743.587200018, 1916908.179377976 4221738.135899825, 1916875.2078312691 4221698.44114258, 1916842.8727905827 4221659.554686192, 1916838.1738317325 4221653.422305301, 1916797.2167292195 4221604.543321516, 1916770.5286981482 4221572.442828931, 1916718.1744201903 4221509.893909216, 1916695.2915626096 4221482.559693542, 1916695.1864503897 4221482.6466366835, 1916694.7520738211 4221482.141843601, 1916653.7125776687 4221516.874694503, 1916639.990626413 4221528.301375112, 1916602.5851084157 4221559.465133923, 1916555.8011734686 4221598.429827808, 1916462.8500000173 4221676.52624999, 1916446.956755988 4221677.992395124, 1916204.8306584822 4221712.358810587, 1916130.9070961287 4221722.863672485, 1916123.5856202168 4221723.788785077, 1916114.4655265585 4221725.284073321, 1916023.7639867633 4221738.339912693, 1915989.79566359 4221743.164845123, 1915931.1625638742 4221751.726726103, 1915886.6574787484 4221758.392057039, 1915879.064356935 4221759.535372766, 1915860.6799806552 4221762.463974771, 1915866.5512379734 4221771.19307807, 1915858.0255613385 4221781.204258466, 1915845.5788966808 4221796.923845699, 1915819.8822709713 4221832.636635574, 1915816.642987842 4221837.057361536, 1915809.4272202705 4221846.7303768555, 1915746.688127338 4221931.325105913, 1915695.6322425061 4222000.089575583, 1915694.4639697787 4222001.6851721015, 1915687.9538474088 4222010.43499104, 1915650.0586874764 4222061.296311728, 1915615.1355468715 4222107.9005596265, 1915594.4248090764 4222135.7260568915, 1915593.2003784224 4222137.391038084, 1915593.3988266613 4222137.93541905, 1915593.432927578 4222137.923240151, 1915598.6904330382 4222152.308965605, 1915603.8170765936 4222166.454351978, 1915605.2650842345 4222170.486802716, 1915608.5026907409 4222179.515724647, 1915635.2899675532 4222252.2472726535, 1915636.8284626533 4222256.456524574, 1915644.502330909 4222277.399851777, 1915650.2339564657 4222289.933564127, 1915651.1077519336 4222291.996898927, 1915652.365969503 4222294.972893354, 1915653.2428424507 4222297.457195231, 1915656.659717688 4222307.128830767, 1915663.1897767254 4222323.422381678, 1915666.2467036895 4222331.619579823, 1915667.776407308 4222335.623772717, 1915669.6952165936 4222340.260787852, 1915672.0548769506 4222346.112877913, 1915674.0303502118 4222350.423926021, 1915677.0437593623 4222357.616178304, 1915679.2805440412 4222363.123647511, 1915684.3483634489 4222375.654629548, 1915688.407259288 4222385.718274638, 1915689.9616999684 4222389.646191179, 1915692.2867865772 4222395.622965593, 1915695.198713433 4222403.0109345885, 1915698.0208860978 4222410.201079504, 1915700.9952175368 4222417.983419013, 1915702.7734179466 4222422.640220585, 1915702.81184203 4222422.743989399, 1915706.8248582494 4222433.534902217, 1915709.8280307958 4222442.866620569, 1915715.0286861167 4222459.473415663, 1915719.2168989389 4222473.520785784, 1915720.2646415036 4222477.078899134, 1915724.7140267296 4222491.6417769715, 1915726.3927127854 4222497.965884655, 1915728.8269399996 4222507.333377422, 1915728.9475503266 4222507.800240936, 1915729.2501872955 4222508.970203049, 1915732.011512373 4222519.656348186, 1915734.1750433855 4222528.367412902, 1915739.3061802203 4222549.006745711, 1915743.3643471694 4222567.901093109, 1915744.9878736502 4222578.078803062, 1915747.0755390923 4222593.376127863, 1915750.2141169102 4222617.763919531, 1915753.6110020333 4222646.751624491, 1915759.3600529071 4222701.01026639, 1915759.54386905 4222702.667761895, 1915761.7181215219 4222722.329629841, 1915761.906277091 4222722.57089936, 1915762.6311032432 4222723.993911952, 1915764.2755420855 4222724.239395835, 1915764.9335935551 4222724.146766889, 1915766.402897258 4222723.826348712, 1915777.5766143682 4222714.626810545, 1915788.7874999996 4222690.800000012, 1915798.2987419148 4222677.55706485, 1915814.9200506115 4222654.671801621, 1915835.6719410662 4222626.103738116, 1915849.6122950169 4222606.488004854, 1915862.612919355 4222588.240238238, 1915879.094597237 4222563.779520073, 1915880.0647841746 4222562.536718933, 1915904.629898773 4222531.619883649, 1915920.1312828844 4222521.116591651, 1915920.6330140529 4222520.858775067, 1915936.2342202894 4222513.644155348, 1915944.1180383775 4222510.093946691, 1915972.1216561452 4222497.215475117, 1916005.0328329362 4222482.076907968, 1916044.7879934725 4222463.617712566, 1916114.353260357 4222437.991008541, 1916114.3658411445 4222438.24812839, 1916114.6086592304 4222438.159282355, 1916114.624149851 4222440.983224029, 1916113.8689271475 4222454.524458493, 1916113.183496944 4222457.059918985, 1916112.0764147823 4222460.997957486, 1916111.7623041777 4222463.594912403, 1916111.9037972272 4222465.852693645, 1916112.3150000053 4222466.905624986, 1916113.7220229667 4222469.879884836, 1916116.2487955508 4222473.57895494, 1916118.4867562728 4222476.5202095425, 1916123.1766515523 4222481.723461189, 1916123.944056123 4222482.498290817, 1916128.1617974332 4222486.769159615, 1916129.502956707 4222489.582616432, 1916131.265201493 4222501.513783336, 1916133.8829775804 4222507.616681404, 1916137.0196384294 4222510.927550041, 1916146.4687500072 4222515.009374983, 1916149.266576509 4222518.265450301, 1916150.1428930275 4222519.747747608, 1916150.179322034 4222519.838135594, 1916151.3873369708 4222523.2194777345, 1916153.3224017913 4222529.495049037, 1916155.7321849773 4222534.785100047, 1916159.51345451 4222541.987584475, 1916159.9143878713 4222542.825228516, 1916161.1328122912 4222546.288623914, 1916162.1563222918 4222550.43523855, 1916164.0022831399 4222566.122003418, 1916164.7719696702 4222569.035937178, 1916166.2062028053 4222574.201796738, 1916176.2712626345 4222591.183208144, 1916185.5595368117 4222611.910449335, 1916188.366179614 4222619.791034686, 1916191.9657283775 4222629.117369988, 1916207.9929473074 4222666.351522816, 1916210.7710276141 4222674.244464736, 1916211.4268750127 4222679.561874981, 1916213.7098149594 4222703.239916317, 1916214.3889278304 4222708.7086827895, 1916215.4935810904 4222714.273658838, 1916215.7025272083 4222715.003297052, 1916215.814399941 4222715.348876493, 1916219.3049974646 4222726.0264929, 1916225.0038066008 4222735.296154326, 1916234.7662886477 4222745.947889138, 1916239.2610606444 4222749.728753867, 1916249.776152573 4222758.179793529, 1916254.2498302946 4222772.646826858, 1916256.8488098686 4222789.162591089, 1916254.8641918087 4222799.588110124, 1916255.423650515 4222806.722689808, 1916256.6197748652 4222811.503351301, 1916261.7671002024 4222823.634673576, 1916263.0017104319 4222832.152377086, 1916264.0685655067 4222844.746668189, 1916266.3279258616 4222853.015746617, 1916269.7862540544 4222860.995607338, 1916270.059219764 4222861.656024375, 1916272.4119346216 4222867.980236159, 1916273.793112546 4222872.779303162, 1916277.167486616 4222890.686654252, 1916278.8353399485 4222899.009695076, 1916281.4906949184 4222908.958382629, 1916284.4260642969 4222921.606943863, 1916285.725193828 4222929.148156842, 1916286.5681249998 4222931.76, 1916289.8402359025 4222947.261114013, 1916302.213324097 4222974.583079631, 1916304.5969346545 4222982.107262579, 1916307.0330228435 4222994.292629364, 1916307.0486680493 4223003.941561462, 1916306.6348805155 4223022.154449303, 1916308.1283288654 4223037.710229445, 1916308.7905712468 4223046.059060758, 1916308.4214655792 4223046.131816964, 1916306.8005730025 4223046.44768321, 1916311.4932699325 4223069.026832953, 1916312.5949850716 4223074.202331098, 1916313.192056729 4223081.490040837, 1916313.263341045 4223085.932560909, 1916314.8752638488 4223090.4845695635, 1916316.4113223124 4223095.919200983, 1916318.2452408064 4223108.415103221, 1916321.9835829935 4223132.339999992, 1916325.9199746903 4223156.2059337, 1916329.7024995133 4223165.436870712, 1916329.888099672 4223165.843491895, 1916331.5835692082 4223179.844735479, 1916331.919846774 4223182.027779601, 1916322.0909530967 4223190.389759086, 1916318.9207456904 4223198.376403238, 1916314.9231669651 4223218.992113785, 1916313.1564457335 4223229.342804941, 1916310.6188795047 4223243.118754596, 1916307.8669869879 4223252.99724532, 1916307.6601675218 4223253.6610069955, 1916305.506742775 4223259.113974046, 1916304.2797008315 4223262.168597515, 1916304.1880132444 4223262.386092717, 1916299.968272613 4223272.257581161, 1916294.4384450135 4223283.272563763, 1916293.5427867027 4223285.079057023, 1916276.110698473 4223319.857968506, 1916266.3115404313 4223338.248802897, 1916259.647895804 4223352.918386628, 1916254.8680207916 4223365.493815192, 1916249.5928975001 4223380.663898582, 1916245.5090188882 4223392.935727653, 1916242.7430541483 4223402.509035929, 1916237.352545542 4223421.57706035, 1916233.3202943252 4223435.92393262, 1916227.328854478 4223457.791204365, 1916224.5589434125 4223467.602383596, 1916223.349877647 4223471.8973906515, 1916219.2662456236 4223487.089134192, 1916216.285930563 4223498.074136356, 1916216.2747115137 4223498.115392974, 1916214.6903172305 4223503.944182347, 1916214.5400981545 4223504.509836265, 1916214.4521527407 4223504.856986441, 1916214.0370210728 4223506.476306409, 1916212.7359357723 4223511.572641405, 1916211.3087125565 4223516.328504171, 1916208.3544635675 4223526.795781882, 1916205.6258774616 4223530.833157305, 1916204.2035842652 4223532.55951289, 1916201.1685112643 4223536.161470962, 1916195.5808108773 4223542.418681384, 1916193.1865458097 4223545.092201826, 1916192.7690175893 4223545.467770522, 1916191.0013175365 4223547.058574308, 1916185.9190714115 4223552.268301277, 1916181.2398921517 4223556.978178066, 1916179.9804883625 4223558.379936736, 1916168.0150000015 4223575.51875, 1916161.4667609746 4223590.926914051, 1916156.9574663152 4223605.283872822, 1916151.7002317873 4223622.615078565, 1916141.7123026322 4223662.676017207, 1916136.8605982517 4223680.693766983, 1916133.5460688253 4223695.0333494, 1916126.5511429296 4223722.190626306, 1916126.0530169525 4223724.147689139, 1916124.2147911766 4223731.532669942, 1916122.7438572873 4223737.4864353165, 1916121.9355763143 4223740.007156875, 1916120.4674894991 4223744.461435694, 1916120.1393964565 4223745.199135764, 1916118.9445241762 4223747.790027565, 1916118.0631827095 4223751.1214261465, 1916116.2694587368 4223754.2021575095, 1916113.7648391135 4223757.462442517, 1916111.5904392225 4223759.610874954, 1916110.470275811 4223760.755374495, 1916108.264923741 4223762.507849973, 1916106.2291350092 4223764.072253626, 1916047.6724187227 4223808.60280807, 1916018.122696983 4223830.987449102, 1915986.2484353015 4223855.119297905, 1915955.4358908979 4223878.578168515, 1915944.1349273568 4223887.564380963, 1915927.2924999997 4223901.944374999, 1915921.6768750024 4223907.379999991, 1915918.5655597863 4223912.6357764, 1915917.4611464946 4223915.041452235, 1915916.7534908203 4223916.594184942, 1915915.7608384427 4223919.559842868, 1915912.710199466 4223932.517625173, 1915902.4106256943 4223982.507251835, 1915883.1302498232 4224074.5953079, 1915882.0333496125 4224079.831863528, 1915881.5025444028 4224082.394371439, 1915880.8517701644 4224085.614519385, 1915877.741745348 4224101.095452045, 1915871.0495900803 4224134.6464176355, 1915864.8845065795 4224166.212874486, 1915864.6989215536 4224167.25954475, 1915863.9412164234 4224174.191677705, 1915863.598539361 4224180.597784503, 1915863.5722552608 4224181.50986791, 1915863.4915449112 4224184.8743369365, 1915863.625432482 4224186.650287741, 1915863.687470743 4224187.193935598, 1915864.586655742 4224194.880182055, 1915866.9524053356 4224206.384975882, 1915869.8251996206 4224224.043515969, 1915869.3912399728 4224228.125468452, 1915868.9455392158 4224230.829787581, 1915868.6719097234 4224232.395547737, 1915867.2365797989 4224238.327635476, 1915865.3612720019 4224243.058303859, 1915863.212664367 4224247.448563469, 1915858.3662440293 4224256.380873902, 1915855.9828542513 4224260.257052126, 1915838.448717142 4224282.008712468, 1915825.3217196453 4224297.130322666, 1915816.7769724964 4224307.297411133, 1915811.1804256684 4224313.608877798, 1915808.8076939913 4224316.483617484, 1915807.4485377376 4224318.130056181, 1915803.479126571 4224323.425859316, 1915800.784903302 4224327.07346408, 1915798.2534256207 4224330.698538699, 1915791.8107085049 4224340.649054646, 1915790.3523788392 4224342.865664469, 1915787.897467613 4224346.882980099, 1915787.2049602373 4224348.014639367, 1915786.7631947212 4224348.783822034, 1915786.6724471832 4224348.942405611, 1915786.4625617047 4224349.328886642, 1915783.8658657202 4224354.117277321, 1915782.3332968128 4224357.012387115, 1915781.3319509868 4224359.1075400645, 1915780.9823332503 4224360.256573254, 1915780.9244393082 4224360.451052684, 1915780.4569379936 4224362.744864809, 1915780.2847777945 4224363.739183456, 1915780.0136569922 4224365.843809169, 1915780.5439271254 4224370.836518219, 1915781.3690395767 4224375.084713624, 1915783.5079474174 4224383.077271967, 1915785.2763098725 4224387.388652171, 1915787.165252405 4224391.51450345, 1915794.5243398868 4224404.695009397, 1915797.5167169203 4224409.032878843, 1915815.625773627 4224432.879125646, 1915833.178550471 4224455.027708825, 1915840.1596397322 4224464.575098184, 1915847.1953543604 4224475.798271883, 1915851.4077842706 4224482.535475348, 1915853.6058227639 4224485.920282002, 1915863.049254677 4224500.590880904, 1915872.02041286 4224514.6661917, 1915876.0877373063 4224521.079516734, 1915881.2807037963 4224529.455315466, 1915883.8869999475 4224533.754122167, 1915884.0180809298 4224533.919138327, 1915884.1801532279 4224534.131857685, 1915887.8196360886 4224538.087414198, 1915889.7559844318 4224540.013887731, 1915892.6663191854 4224542.512075787, 1915905.4902435723 4224551.934398714, 1915912.433565125 4224557.681452112, 1915913.7825056307 4224559.1429864215, 1915919.114224726 4224565.879447787, 1915927.7672713033 4224576.86384079, 1915939.730559666 4224591.916068472, 1915956.9437875955 4224613.967490717, 1915982.2685398278 4224645.644749302, 1915986.9267958226 4224651.842677052, 1915988.2714016566 4224652.931515472, 1915994.983246903 4224656.483020468, 1916029.110312829 4224671.743152305, 1916031.491247564 4224672.96134503, 1916041.5324026956 4224680.4644741425, 1916055.0491150434 4224692.184229912, 1916058.598808938 4224695.791570399, 1916062.8449475735 4224700.665634619, 1916071.3412405513 4224711.249499404, 1916072.977590579 4224713.567083333, 1916074.5449936306 4224715.758958329, 1916103.7757455548 4224751.208756639, 1916104.3266715212 4224751.883967155, 1916110.5939005779 4224759.721277187, 1916115.7859129184 4224767.695109847, 1916147.110579095 4224831.716675071, 1916161.158970007 4224857.068765089, 1916166.272986518 4224867.687362546, 1916171.605452813 4224880.933533547, 1916176.5346990814 4224896.9117074115, 1916181.4611808679 4224915.362205015, 1916207.829061844 4225009.773265558, 1916226.9588157947 4225104.14228744, 1916241.8734675907 4225184.87305166, 1916251.8399741985 4225251.360141968, 1916254.9513551977 4225271.672820771, 1916256.0207692548 4225277.869263712, 1916257.326921346 4225283.859680465, 1916264.3391539059 4225309.585883234, 1916272.1812252835 4225330.708134016, 1916297.2722043237 4225391.171865053, 1916320.9305851483 4225448.311360948, 1916336.3280791298 4225482.1362296, 1916342.3253796732 4225494.122291925, 1916346.8279277475 4225502.94600068, 1916354.2511214188 4225515.49884469, 1916359.3985134107 4225524.06090589, 1916363.6464909448 4225530.312964796, 1916368.4534257066 4225536.578754777, 1916380.570737149 4225550.472873772, 1916385.3262500262 4225555.20374999, 1916391.0247212653 4225560.651357249, 1916393.1434882293 4225562.619816492, 1916397.6798799199 4225566.627981916, 1916406.7343387231 4225574.392355241, 1916418.0079950085 4225582.617812346, 1916418.6984883402 4225583.037138182, 1916443.932287499 4225598.626816801, 1916462.9400000407 4225608.351249992, 1916475.704032842 4225612.153960753, 1916484.0985370735 4225613.040940052, 1916498.985315505 4225610.985760618, 1916516.935 4225606.127499981, 1916567.9150000194 4225590.149999979, 1916580.7705377853 4225584.927318153, 1916625.4087499958 4225558.4974999875, 1916657.9369437317 4225539.646246479, 1916691.6112500115 4225521.671249985, 1916726.2862499785 4225507.4275, 1916773.6821331365 4225491.806246064, 1916796.7787500003 4225485.591249993, 1916829.086249983 4225479.139999999, 1916896.2462499999 4225468.454999998, 1916951.9775000163 4225459.65374999, 1916965.704217511 4225457.92511358, 1916975.5712499972 4225457.316249989, 1916991.6820973873 4225457.583730166, 1917029.8806704795 4225462.792541508, 1917093.2432365285 4225474.680771402, 1917147.9739547437 4225489.174267055, 1917189.147573291 4225504.612962743, 1917202.6294707006 4225509.777594923, 1917223.7784210728 4225519.334068838, 1917263.0219812586 4225543.810829908, 1917309.034798537 4225577.379862965, 1917343.3751038534 4225603.4875274515, 1917378.7657289843 4225631.1620510295, 1917379.438453133 4225629.950475139, 1917384.387107567 4225620.570734401, 1917400.0999569534 4225591.978036433, 1917422.590711658 4225551.633230643, 1917483.175553966 4225444.600956822, 1917509.6324754097 4225397.707345844, 1917510.6974307054 4225395.486692117))'::geometry,'38421','Saint-Martin-d''Hères','SAINT-MARTIN-<br>D''HÈRES','SMH','SMH'),
     (30,'SRID=3945;POLYGON ((1920299.925167273 4208491.700895588, 1920300.8227767022 4208477.820256006, 1920301.821011937 4208477.829456331, 1920301.78 4208476.03, 1920299.31 4208475.22, 1920297.39 4208474.43, 1920248.08108036 4208457.618456612, 1920199.85 4208440.61, 1920157.9294591716 4208426.570370377, 1920063.95 4208392.97, 1919890.52 4208332.27, 1919724.89 4208273.67, 1919641.12 4208242.8, 1919638.74 4208242.39, 1919635.81 4208241.37, 1919148.11 4208069.91, 1919094.21 4208050.92, 1919089.81 4208050.18, 1918994.59 4208016.98, 1918984.99 4208013.66, 1918945.66 4208000.03, 1918924.47 4207992.9, 1918840.96 4207963.03, 1918839.51 4207962.86, 1918826.95 4207958.38, 1918688.83 4207910.32, 1918536.36 4207856.29, 1918495.42 4207842.2, 1918485.53 4207838.83, 1918416.89 4207814.79, 1918324.38 4207782.5, 1918319.42 4207780.14, 1918215.6 4207743.06, 1918194.65 4207735.08, 1918193.16 4207734.39, 1918213.89 4207697.77, 1918221.51 4207676.95, 1918169.87 4207706.65, 1918148.12 4207705.88, 1918125.32 4207720.06, 1918109.84 4207731.88, 1918098.66 4207737.05, 1918092.04 4207742.32, 1918079.66 4207746.5, 1918075.49 4207759.05, 1918072.89 4207761.47, 1918065.51 4207765.49, 1918059.63 4207774.14, 1918053.93 4207789.03, 1918043.21 4207806.29, 1918036.89 4207817.32, 1918035.79 4207822.27, 1918022.88 4207840.59, 1917987.82 4207854.91, 1917972.07 4207901.53, 1917949.91 4207930.79, 1917921.47 4207990.5, 1917898.76 4208020.49, 1917889.79 4208041.16, 1917879.23 4208091.01, 1917868.16 4208118.25, 1917833.94 4208154.72, 1917823.27 4208179.25, 1917805.3 4208206.94, 1917793.24 4208223.43, 1917764 4208251.49, 1917752.09 4208263.8, 1917735.07 4208284.32, 1917719.14 4208301.17, 1917683.07 4208325.94, 1917669.61 4208342.78, 1917664.08 4208336.37, 1917656.69 4208332.72, 1917467.07 4208238.69, 1917463.67 4208236.69, 1917194.12 4208100.22, 1917187.49 4208095.03, 1917180.86 4208085.41, 1917151.94 4208094.55, 1917118.98 4208103.81, 1917105.4 4208107.5, 1917078.42 4208111.97, 1917063.87 4208114.56, 1917039.52 4208121.78, 1916994.13 4208137.21, 1916974.23 4208151.69, 1916958.92 4208162.77, 1916917.93 4208184.96, 1916891.03 4208205.2, 1916854.37 4208218.25, 1916838.9 4208223.68, 1916829.66 4208227.57, 1916798.65 4208246.37, 1916772.84 4208256.43, 1916744.15 4208266.7, 1916731.85 4208268.43, 1916712.1 4208270.68, 1916694.73 4208273.49, 1916686.19 4208275.49, 1916672.08 4208280.42, 1916659.32 4208286.52, 1916647.23 4208294.86, 1916588.17 4208334.39, 1916537.93 4208367.7, 1916471.84 4208411.22, 1916392.79 4208464.06, 1916349.16 4208492.19, 1916265.01 4208548.25, 1916226.56 4208573.83, 1916211.77 4208582.05, 1915944.41 4208763.29, 1915836.16 4208874.25, 1915618.3024262406 4209098.7236795295, 1915584.3328430415 4209143.652158674, 1915574.4863562754 4209158.136437247, 1915582.857793721 4209162.175689034, 1915805.7830648352 4209539.973882859, 1915917.252876259 4209731.825763393, 1915965.0230038748 4209813.218853433, 1915969.5003642398 4209820.968422598, 1915979.8385316706 4209838.861380579, 1915981.5417734543 4209842.751393444, 1916000.9732045068 4209876.500093379, 1916067.7475748763 4209991.294132424, 1916115.503060645 4210073.34458864, 1916180.6264377306 4210186.862694642, 1916185.441810547 4210184.466245976, 1916186.03 4210185.45, 1916191.060375535 4210183.80163956, 1916203.6305324603 4210176.628014137, 1916213.2055049061 4210164.907487663, 1916253.6521971168 4210094.639931593, 1916265.975416395 4210023.55857012, 1916273.2682477406 4210025.063196376, 1916291.8271061678 4210027.866831686, 1916311.78502316 4210031.344854432, 1916333.4942240217 4210033.506910012, 1916349.3304564736 4210034.130041565, 1916373.2622505354 4210032.658953887, 1916407.636704882 4210028.831307346, 1916408.6422191295 4210028.76767211, 1916409.4193396922 4210028.936457137, 1916421.4171149782 4210032.3304944495, 1916432.6695030914 4210033.433423155, 1916451.2497770824 4210034.604310583, 1916479.1266610054 4210040.374387108, 1916488.9601365936 4210042.634475425, 1916509.6164512783 4210047.197871847, 1916529.05372157 4210050.503098684, 1916544.0668883973 4210052.284718997, 1916574.858969935 4210055.509260119, 1916621.4475553434 4210054.957332423, 1916635.7377575897 4210055.895302596, 1916643.4241234662 4210057.598326648, 1916649.658935704 4210060.30505953, 1916693.7670589741 4210082.407538312, 1916706.389768804 4210087.725317047, 1916727.0418786984 4210092.617915177, 1916747.9718096433 4210100.432259793, 1916783.8395515103 4210106.593738232, 1916792.3366234037 4210108.527476939, 1916806.7312581562 4210112.911012793, 1916807.2884283776 4210111.485942803, 1916807.9493046228 4210109.795624713, 1916824.8892224655 4210117.316210156, 1916841.9772066616 4210130.469329633, 1916860.6723101577 4210150.852189799, 1916870.214096503 4210168.436468706, 1916877.9140445665 4210178.606764974, 1916882.6192849786 4210187.016379748, 1916891.7079987389 4210196.799382058, 1916905.782330952 4210203.672267947, 1916917.1669923991 4210211.685879574, 1916920.4669638006 4210215.005657643, 1916924.2045308966 4210219.63397678, 1916940.3351385174 4210239.8367762, 1916964.9850763408 4210275.139228156, 1916976.94796517 4210291.604141292, 1916980.5402848958 4210297.033675016, 1916983.705429111 4210300.382276138, 1916992.7723089345 4210311.566128157, 1917041.937518855 4210347.941856909, 1917087.9774872444 4210373.631651514, 1917119.68 4210391.869325863, 1917149.7715804493 4210411.707345395, 1917224.6835141177 4210464.316644859, 1917282.9786520281 4210514.620063135, 1917333.8322289754 4210561.0077985795, 1917363.1193685497 4210588.396696428, 1917375.6366623591 4210597.825586499, 1917379.7854065346 4210600.873171195, 1917385.985972318 4210604.115941033, 1917456.7009836114 4210623.311359472, 1917487.2546441383 4210632.026380835, 1917498.3492967556 4210639.627420884, 1917511.0288869021 4210618.699060384, 1917527.280701616 4210590.318651239, 1917540.9450700015 4210553.608637323, 1917558.119047912 4210508.380601561, 1917587.1060486906 4210457.970277292, 1917620.3427188273 4210404.518795536, 1917683.0467673398 4210319.0527301375, 1917749.6812088732 4210256.221913457, 1917840.53534582 4210199.092455074, 1917914.9782224114 4210158.204365519, 1918027.5884920578 4210100.109520853, 1918166.613207136 4209980.431922354, 1918199.6830114776 4209956.209865625, 1918318.6539656979 4209869.41889873, 1918409.6033739739 4209801.880790894, 1918518.868449792 4209708.306168334, 1918574.977696642 4209656.739315904, 1918610.2135579668 4209624.334207592, 1918643.5380367946 4209598.513327849, 1918729.137550242 4209533.680225003, 1918768.884139995 4209489.891525874, 1918780.767784741 4209477.841486235, 1918837.2467111838 4209424.090024838, 1918915.8397376996 4209359.40020809, 1918943.6526680384 4209337.1500315415, 1918952.4792752592 4209331.94801116, 1918976.7143650816 4209315.537777151, 1919079.2865949143 4209241.215729749, 1919135.0031325086 4209203.325958703, 1919199.5010838713 4209146.622682891, 1919322.3680166814 4209116.614763079, 1919425.2726393056 4209064.121765075, 1919442.1447435261 4209032.110225248, 1919457.7593927132 4209009.422914857, 1919480.3036933828 4208999.938735038, 1919489.72 4208998.44, 1919507.5244695058 4208993.887635123, 1919611.5448946783 4208990.709720196, 1919642.8239704424 4208989.326700319, 1919679.0936562608 4208976.8069210835, 1919700.6537985052 4208961.073072592, 1919728.1133696125 4208946.142063869, 1919756.4208517566 4208941.862570636, 1919791.7918581674 4208931.589702118, 1919826.4709480973 4208914.520972915, 1919835.2586421536 4208907.916109114, 1919840.5291517829 4208903.350711502, 1919844.758058691 4208903.831341351, 1919852.6614993813 4208909.822407794, 1919927.4741855506 4208894.588847621, 1920028.1055221024 4208904.648205022, 1920120.4280422858 4208920.528231654, 1920196.9890031077 4208945.899960003, 1920280.6083301317 4208972.274889958, 1920289.5499627483 4208972.398479735, 1920296.5415120947 4208971.610798104, 1920302.189771207 4208958.267108608, 1920305.7619910166 4208941.214814626, 1920316.089038637 4208876.051841119, 1920325.57402363 4208858.228683098, 1920331.9344233084 4208843.072033739, 1920337.6912272898 4208819.881947095, 1920342.0950009103 4208782.545816033, 1920344.3766357289 4208768.218676223, 1920347.4535817492 4208736.718967234, 1920347.5321926717 4208725.765879428, 1920347.3554008023 4208710.216033109, 1920346.8612289792 4208683.4370840965, 1920346.3266709466 4208678.920982478, 1920345.0713364508 4208673.99862724, 1920344.0583271538 4208671.534006098, 1920332.311223411 4208649.608689387, 1920316.6467198245 4208621.213623995, 1920311.2748889297 4208606.01572434, 1920306.2201783007 4208591.172324637, 1920303.3005682053 4208577.533983548, 1920299.925167273 4208491.700895588))'::geometry,'38445','Saint-Pierre-de-Mésage','SAINT-PIERRE-<br>DE-MÉSAGE','SPM','SPM'),
     (43,'SRID=3945;POLYGON ((1916762.4778795398 4229902.470041465, 1916760.0030614126 4229907.301311444, 1916741.5174233865 4229938.825333165, 1916737.91281883 4229945.702748002, 1916734.8122047314 4229958.21601106, 1916722.3440173848 4229987.396728083, 1916719.495415239 4229991.916345074, 1916714.6217956527 4229999.128046162, 1916712.472604181 4230001.6819000505, 1916708.9050355987 4230009.756318075, 1916705.3717755429 4230036.269784351, 1916711.548750011 4230051.95999999, 1916714.4612500088 4230125.061250005, 1916719.8087500047 4230187.396249997, 1916727.870000012 4230239.106249999, 1916739.9509894378 4230272.590925488, 1916753.688750015 4230319.572499996, 1916796.2512500128 4230470.378749941, 1916820.7400000123 4230623.2799999975, 1916824.839999994 4230705.785000008, 1916828.5299999858 4230771.167500009, 1916832.3045762002 4230848.288388954, 1916829.2500868002 4230858.467220149, 1916828.6229257323 4230860.344552721, 1916809.0801291068 4230892.7273759665, 1916806.201872496 4230897.318738441, 1916822.9499999483 4230901.513749973, 1916839.8749503442 4230899.1592782065, 1916854.859919931 4230899.386481147, 1916869.5560214308 4230901.845739556, 1916876.17367965 4230904.740333742, 1916891.6408354817 4230913.530421725, 1916892.4832836855 4230914.0978545435, 1916932.0227012034 4230937.971578142, 1916932.532618997 4230938.400827164, 1916858.0809362535 4231001.513097173, 1916800.4952244656 4231049.2330625495, 1916730.1637499884 4231204.92874999, 1916683.9423937113 4231309.811821868, 1916632.0099999837 4231419.339999948, 1916602.1718816317 4231474.47039113, 1916581.802499978 4231548.0000000065, 1916550.3072665588 4231607.06481922, 1916455.5681762414 4231724.113447365, 1916443.5612381669 4231748.365143307, 1916430.8081719454 4231774.143576211, 1916430.8521991319 4231792.625137606, 1916428.0867480708 4231839.142892185, 1916426.4506816275 4231865.083526439, 1916426.5699999954 4231935.904999999, 1916428.2787704428 4232002.906033264, 1916427.0915620117 4232085.707404615, 1916457.884280625 4232227.845906202, 1916499.85 4232407.09, 1916504.6386390023 4232430.7752583455, 1916509.1855718663 4232451.4420394655, 1916510.4556593944 4232470.277023433, 1916486.5337500104 4232545.1237499975, 1916477.337500006 4232573.562499976, 1916477.1094456743 4232601.8229185445, 1916478.8067714323 4232618.1563490415, 1916479.8589312276 4232626.354560361, 1916481.4138552027 4232635.966845924, 1916497.1337499793 4232660.423749983, 1916542.8908068687 4232717.710746954, 1916569.8004251763 4232751.4010961, 1916589.658157278 4232776.2626129035, 1916607.5157291654 4232813.057823007, 1916611.992942502 4232830.45714314, 1916623.2855596794 4232894.12681721, 1916659.882499986 4232953.977499999, 1916663.1140856133 4233012.351019711, 1916663.1134029336 4233013.874164341, 1916657.5352727517 4233050.111129015, 1916646.799223845 4233071.480729351, 1916645.9824813902 4233073.287663298, 1916632.207236849 4233148.210576941, 1916612.639751493 4233175.111865041, 1916615.0946193265 4233209.881967186, 1916616.4119710159 4233220.7413753215, 1916619.5984669607 4233234.568989348, 1916620.8341230296 4233241.643233452, 1916622.5466536349 4233251.424598634, 1916627.6639473476 4233274.918697908, 1916629.580248998 4233279.890885846, 1916634.331788571 4233295.722851725, 1916639.5281559804 4233302.135725559, 1916642.7837249022 4233304.219927021, 1916683.5111943379 4233409.957813825, 1916701.893340061 4233458.155000009, 1916766.9249999612 4233663.704999934, 1916772.0837785292 4233683.665113396, 1916778.1048411843 4233699.423215541, 1916810.8802561655 4233753.519631631, 1916816.5110487295 4233768.61260359, 1916827.7571009817 4233805.7000389695, 1916831.6548861535 4233849.544964559, 1916840.6155698975 4233878.247173415, 1916845.9780066088 4233888.36183696, 1916856.4467466178 4233900.156696351, 1916885.891166498 4233928.735913462, 1916903.8056670916 4233949.061462507, 1916920.457965459 4233968.11597927, 1916942.8484806353 4233998.808248223, 1916947.9660222696 4234005.7781579085, 1916950.1014055763 4234007.080547868, 1916954.5998553012 4234009.671570891, 1916959.4615771263 4234012.485578376, 1916964.605546372 4234015.313237463, 1916973.278293282 4234020.101899061, 1917150.4920819232 4234116.850246277, 1917205.8119527842 4234148.760110441, 1917244.343116025 4234169.3483838, 1917291.0174999647 4234474.71999997, 1917301.4938736893 4234543.86180701, 1917306.1441809938 4234562.5026559625, 1917361.6672996047 4234617.880674704, 1917442.1986191494 4234696.649810108, 1917480.0904269593 4234733.679565296, 1917575.068740973 4234827.120386001, 1917600.7691396985 4234852.0986740785, 1917603.5514898181 4234854.326257841, 1917649.6904956184 4234885.438052357, 1917867.0910931227 4235026.702813756, 1918371.4600000186 4235437.434999989, 1918632.6342975793 4235652.7835415825, 1918635.7062943294 4235671.334502122, 1918658.24 4235690.09, 1918698.39 4235704.11, 1918885.7 4235777.46, 1919009.68 4235826.08, 1919011.59 4235826.82, 1919167.13 4235887.75, 1919182.24 4235893.76, 1919183.33 4235894.2, 1919224.97 4235885.31, 1919383.02 4235850.96, 1919640.89 4235794.04, 1919643.92 4235793.63, 1919646.53 4235792.81, 1919741.47 4235771.92, 1920381.86 4235627.94, 1920383.64 4235628.71, 1920388.88 4235652.31, 1920390.43 4235651.98, 1920766.94 4235526.75, 1920774.68 4235289.61, 1920774.75 4235287.2, 1920784.91 4234973.1, 1920822.13 4234974.06, 1920829.38 4234967.52, 1920829.17 4234967, 1920823.32 4234951.86, 1920832.05 4234866.93, 1920855.99 4234811.31, 1920858.34 4234806.41, 1920868.74 4234787.36, 1920874.64 4234776.54, 1920876.59 4234729.18, 1920872.34 4234666.25, 1920878.36 4234607.89, 1920922.47 4234562.7, 1920929.89 4234534.78, 1920936.03 4234511.68, 1920932.71 4234421.19, 1920929.01 4234365.13, 1920915.05 4234343.83, 1920910.59 4234323.97, 1920903.32 4234314.99, 1920856.3 4234293.52, 1920847.18 4234226.26, 1920840.91 4234192.28, 1920839.76 4234173.04, 1920831.77 4234158.76, 1920813.21 4234146.85, 1920807.21 4234133.71, 1920798.41 4234123.57, 1920788.92 4234098.53, 1920780.52 4234085.45, 1920774.39 4234074.36, 1920769.06 4234055.25, 1920760.75 4234043.38, 1920752.48 4234031.33, 1920743.66 4234019.69, 1920741.41 4234016.91, 1920732.68 4233994.56, 1920724.81 4233987.57, 1920721.08 4233985.5, 1920706.81 4233981.93, 1920702.81 4233980.51, 1920701.01 4233979.81, 1920697.47 4233977.42, 1920678.53 4233965.13, 1920659.21 4233953.42, 1920649.1 4233945.81, 1920641.89 4233943.29, 1920635.54 4233943.42, 1920631.42 4233945.1, 1920625.03 4233948.32, 1920618.97 4233952.11, 1920616.21 4233952.7, 1920613.57 4233951.71, 1920603.3 4233942.7, 1920600.66 4233942.08, 1920583.59 4233938.07, 1920579.33 4233933.72, 1920581.75 4233929.46, 1920582.73 4233924.76, 1920581.83 4233922.36, 1920563.31 4233904.05, 1920554.8 4233899.35, 1920549.74 4233894.51, 1920543.21 4233877.01, 1920539.17 4233873.85, 1920529.76 4233872.33, 1920524.84 4233866.01, 1920507.48 4233848.95, 1920495.92 4233841.55, 1920481.64 4233829.19, 1920474.04 4233828.5, 1920463.64 4233813.75, 1920445.26 4233796.23, 1920434.29 4233792.32, 1920430.69 4233789.66, 1920424.68 4233775.36, 1920403.02 4233758.58, 1920399.25 4233754.78, 1920375.15 4233725.58, 1920372.95 4233720.9, 1920367.37 4233706.44, 1920356.86 4233698.11, 1920354.43 4233695.75, 1920351.36 4233691.97, 1920348.85 4233687.79, 1920345.04 4233682.06, 1920341.89 4233675.56, 1920330.05 4233655.87, 1920320.97 4233651.1, 1920315.56 4233642.95, 1920314.77 4233642.03, 1920300.04 4233625.38, 1920284.8 4233609.19, 1920275.34 4233590.99, 1920268.33 4233586.5, 1920250.46 4233570.15, 1920227.07 4233549.75, 1920225.84 4233540.22, 1920224.25 4233536.62, 1920218.13 4233535.32, 1920204.44 4233527.77, 1920202.45 4233524.65, 1920205.13 4233513.07, 1920191.58 4233494.66, 1920177.59 4233457.92, 1920159.85 4233439.95, 1920155.59 4233434.62, 1920150.68 4233412.35, 1920146.22 4233407.78, 1920116.82 4233394.17, 1920108.46 4233384.58, 1920098.98 4233378.28, 1920096.37 4233374.91, 1920100.9 4233356.73, 1920095.77 4233347.65, 1920096.36 4233340.44, 1920087.29 4233331.93, 1920087.12 4233330.67, 1920085.97 4233322.21, 1920083.65 4233319.02, 1920076.4 4233315.15, 1920069.55 4233308.87, 1920066.35 4233308.57, 1920054.31 4233307.09, 1920047.04 4233298.24, 1920036.63 4233297.4, 1920029.45 4233295.22, 1920018.05 4233291.23, 1920020.94 4233284.83, 1920021.32 4233282.24, 1920017.88 4233272.76, 1920010.41 4233253.8, 1920007.21 4233250.44, 1920001.04 4233247.55, 1919997.11 4233247.54, 1919991.19 4233247.52, 1919973.95 4233247.48, 1919968.45 4233243.44, 1919957.98 4233245.71, 1919949.32 4233243.38, 1919947.36 4233245.31, 1919945.5 4233243.87, 1919938.97 4233225.04, 1919927.45 4233205.96, 1919922.75 4233190.38, 1919915.67 4233177.96, 1919911.51 4233175.48, 1919913.89 4233171.73, 1919907.88 4233161.73, 1919905.71 4233158.14, 1919903.97 4233140.49, 1919902.17 4233136.78, 1919899.4 4233132.49, 1919896.08 4233128.6, 1919892.16 4233125.39, 1919847.91 4233104.58, 1919801.22 4233063.45, 1919781.69 4233050.04, 1919772.98 4233044.11, 1919770.08 4233039.65, 1919771.25 4233034.69, 1919768.06 4233026.86, 1919767.87 4233023.38, 1919773.88 4233015.09, 1919774.35 4233013.12, 1919772.76 4233010.4, 1919765.55 4233008.94, 1919761.05 4232992.48, 1919760.06 4232990.73, 1919758.53 4232989.36, 1919756.64 4232988.56, 1919746.76 4232983.81, 1919744.2 4232980.58, 1919742.54 4232967.84, 1919746.26 4232960.72, 1919745.44 4232958.38, 1919727.04 4232944.12, 1919727.13 4232934.49, 1919727.54 4232903.86, 1919720.22 4232900.95, 1919707.68 4232895.37, 1919695.43 4232889.18, 1919690.65 4232884.95, 1919687.75 4232862.43, 1919683.5 4232857.26, 1919682.06 4232849.01, 1919670.27 4232840.97, 1919669.04 4232839.59, 1919666.69 4232836.96, 1919666.47 4232836.77, 1919666.25 4232836.01, 1919666.65 4232835.34, 1919667.59 4232831.79, 1919664.17 4232801.41, 1919660.98 4232776.47, 1919664.17 4232760.36, 1919658.78 4232754.54, 1919662.63 4232731.04, 1919661.99 4232725.59, 1919660.34 4232716.13, 1919658.02 4232706.82, 1919655.75 4232706.64, 1919650.97 4232686.15, 1919648.65 4232681.35, 1919632.5 4232658.01, 1919623.94 4232648.61, 1919623.77 4232648.42, 1919617.25 4232641.44, 1919610.24 4232634.95, 1919578.37 4232613.3, 1919577.86 4232612.24, 1919574.91 4232607.1, 1919571.39 4232602.31, 1919560.56 4232592.92, 1919559.29 4232592, 1919544.12 4232581.37, 1919528.56 4232571.31, 1919513.66 4232544.77, 1919504.87 4232537.43, 1919494.06 4232521.25, 1919493.38 4232520.4, 1919490.28 4232517.16, 1919486.72 4232514.44, 1919482.8 4232512.28, 1919471.75 4232497.1, 1919455.85 4232481.13, 1919446.33 4232476.98, 1919443.22 4232472.38, 1919436.58 4232463.94, 1919422.89 4232451.16, 1919386.81 4232437.19, 1919381.65 4232429.66, 1919380.54 4232423.8, 1919378.6 4232415.82, 1919371.76 4232403.11, 1919364.32 4232394.91, 1919352.1 4232381.44, 1919348.53 4232384.21, 1919334.19 4232369.62, 1919333.16 4232370.71, 1919321.48 4232359.98, 1919320.78 4232357.73, 1919319.04 4232353.9, 1919316.72 4232350.41, 1919312.82 4232349.16, 1919307.55 4232350.02, 1919306.89 4232349.53, 1919306.57 4232348.58, 1919306.91 4232347.65, 1919307.52 4232344.4, 1919304.33 4232338.25, 1919302.46 4232323.23, 1919299.19 4232317.89, 1919290.55 4232309.05, 1919289.74 4232307.41, 1919282.7 4232293.92, 1919275.06 4232280.76, 1919266.84 4232267.95, 1919236.3 4232220.99, 1919233.03 4232220.97, 1919229.07 4232204.46, 1919228.7 4232203.59, 1919227.64 4232202.48, 1919226.19 4232201.92, 1919224.06 4232200.66, 1919223.57 4232198.84, 1919219.46 4232193.69, 1919215.45 4232191.17, 1919210.71 4232185.42, 1919196.88 4232176.19, 1919189.14 4232164.97, 1919166.31 4232146.06, 1919160.63 4232115.93, 1919139.6 4232085.9, 1919137.03 4232080.47, 1919135.84 4232076.22, 1919129.02 4232059.56, 1919089.94 4232022.25, 1919086.81 4232013.51, 1919073.24 4232001.68, 1919069.9 4232002.75, 1919063.96 4231993.32, 1919061.99 4231985.75, 1919057.38 4231976.46, 1919055.2 4231974.39, 1919053.9 4231970.46, 1919055.61 4231967.98, 1919058.4 4231963.93, 1919057.69 4231959.95, 1919052.21 4231951.02, 1919050.47 4231943.31, 1919049.34 4231941.47, 1919048.25 4231938.58, 1919047.82 4231935.53, 1919043.91 4231934.92, 1919036.76 4231922.63, 1919029.88 4231909.47, 1919020.22 4231897.75, 1919018.9 4231890.37, 1919017.55 4231888.55, 1919016.06 4231885.58, 1919015.21 4231882.37, 1919011.95 4231878.27, 1919006.24 4231870.23, 1919001.09 4231861.82, 1918990.41 4231830.73, 1918986.29 4231824.03, 1918987.18 4231820.28, 1918985.65 4231786.47, 1918983.67 4231781.9, 1918959.33 4231770.42, 1918950.33 4231770.7, 1918948.23 4231767.57, 1918950.69 4231760.26, 1918949.14 4231756.17, 1918941.02 4231741.77, 1918931.41 4231731.31, 1918927.2 4231728.55, 1918911.76 4231723.07, 1918908.68 4231721.18, 1918901.08 4231705.68, 1918900.8 4231703.42, 1918900.52 4231701.19, 1918896.92 4231699.73, 1918875.95 4231658.75, 1918867.84 4231645.74, 1918865.01 4231639.74, 1918848.43 4231600.17, 1918834.86 4231570.08, 1918824.89 4231559.52, 1918825.06 4231549.74, 1918821.93 4231542.79, 1918808.25 4231521.65, 1918807.53 4231520.53, 1918804.32 4231518.44, 1918801.83 4231510.67, 1918798.24 4231501.58, 1918794.04 4231492.75, 1918789.24 4231484.24, 1918789.08 4231484.13, 1918782.68 4231480.01, 1918775.94 4231476.47, 1918776.61 4231471.29, 1918777.18 4231466.94, 1918768.31 4231448, 1918762.74 4231440.93, 1918747.34 4231421.7, 1918743.3 4231415.72, 1918741.63 4231421.53, 1918730.72 4231403.65, 1918714.79 4231394.93, 1918714.11 4231394.58, 1918710.99 4231392.6, 1918708.29 4231390.07, 1918705.16 4231376.29, 1918702.06 4231371.86, 1918695.59 4231366.78, 1918694.03 4231365.56, 1918654.93 4231351.29, 1918648.52 4231347, 1918641.9 4231331.02, 1918638.53 4231328.13, 1918611.57 4231319.14, 1918602.9 4231315.26, 1918594.9 4231310.43, 1918544.29 4231277.86, 1918507.91 4231254.28, 1918512.54 4231253.45, 1918513.64 4231229.44, 1918514.8 4231220.47, 1918518.57 4231201.44, 1918521.45 4231192.16, 1918519.05 4231180.6, 1918519.85 4231172.48, 1918521.35 4231163.94, 1918523.52 4231155.55, 1918516.73 4231138.25, 1918505.32 4231120.58, 1918496.48 4231106.9, 1918495.37 4231101.84, 1918486.99 4231090.52, 1918482.59 4231082.94, 1918467.86 4231065.67, 1918459.6 4231057.8, 1918448.47 4231048.04, 1918436.91 4231038.8, 1918424.93 4231030.09, 1918421.64 4231023.99, 1918417.83 4231015.71, 1918414.67 4231007.16, 1918413.1 4231005.16, 1918410.69 4231002.55, 1918389.08 4230988.02, 1918372.74 4230978.66, 1918357.26 4230966.17, 1918348.66 4230957.14, 1918351.06 4230941.42, 1918346.32 4230943.6, 1918334.39 4230909.81, 1918332.08 4230905.82, 1918328.28 4230900.37, 1918323.95 4230895.35, 1918307.78 4230891.25, 1918284.25 4230891.17, 1918277.64 4230881.28, 1918273.47 4230863.1, 1918277.89 4230857.39, 1918278.47 4230854.8, 1918276.46 4230852.46, 1918252.86 4230842.94, 1918250.9 4230831.62, 1918248.1 4230828.72, 1918240.88 4230820.56, 1918234.16 4230811.97, 1918235.87 4230804.83, 1918229.05 4230788.78, 1918218.81 4230779.98, 1918215.66 4230778.97, 1918198.32 4230781.45, 1918183.62 4230783.21, 1918170.01 4230749.03, 1918163.97 4230737.2, 1918141.04 4230704.93, 1918135.17 4230698.14, 1918118.29 4230685.36, 1918113.45 4230673.17, 1918115.3168019564 4230667.462430962, 1918087.941602798 4230652.291096545, 1918084.3219998814 4230636.833050872, 1918048.3650795538 4230601.300054826, 1918041.1089205006 4230596.962218865, 1918036.5485783375 4230588.702718412, 1918022.8814543572 4230581.348472345, 1918008.2720719858 4230576.383811905, 1917994.170329205 4230545.775584284, 1917977.0328780042 4230533.747038809, 1917970.061708822 4230509.394437024, 1917952.3241197765 4230498.918036387, 1917935.1683418269 4230483.927594281, 1917925.592960554 4230465.626182718, 1917918.2450716265 4230462.497780972, 1917902.4348136303 4230462.6843798505, 1917886.0647103915 4230417.988510263, 1917880.5694164003 4230407.26945831, 1917867.2081705949 4230391.994338553, 1917860.2000000516 4230377.885000027, 1917844.843238144 4230369.618285371, 1917839.3953914645 4230360.173882426, 1917823.3510723482 4230351.374707195, 1917807.6274162033 4230335.574931188, 1917765.8475000164 4230299.899999992, 1917734.705377334 4230268.866091824, 1917705.6782577606 4230225.891181222, 1917685.0592654743 4230211.565725081, 1917674.593853673 4230200.390277381, 1917650.0912208618 4230180.601862829, 1917598.0975000153 4230155.317499986, 1917593.7530951425 4230143.956073452, 1917582.5540072245 4230122.517904003, 1917575.1778437959 4230108.808913488, 1917557.830491225 4230094.737628053, 1917547.9491257148 4230082.504082523, 1917504.2642152824 4230043.250116444, 1917498.7608603921 4230037.785354248, 1917490.274990555 4230024.575028337, 1917483.5976993 4230012.045925786, 1917457.506109656 4229997.453919301, 1917448.097770882 4229996.975985568, 1917419.2291332402 4229981.011762114, 1917400.5237094893 4229966.485940576, 1917387.9590081146 4229969.700425074, 1917378.4998894434 4229948.889255111, 1917352.1787515315 4229938.4720192915, 1917335.2081239116 4229931.964458556, 1917316.0325296207 4229926.543013382, 1917285.0328949841 4229919.411316133, 1917252.6291848742 4229902.937187554, 1917224.77907621 4229888.249486396, 1917198.6448327398 4229874.959445365, 1917196.2265739657 4229873.735384077, 1917194.0131995757 4229872.588043067, 1917190.1316337916 4229870.816771585, 1917178.4066180065 4229865.41459828, 1917160.4127668543 4229857.133164873, 1917158.6932496922 4229856.2956399955, 1917141.7034463868 4229848.467902369, 1917132.7052900796 4229844.4963676315, 1917131.8288574596 4229844.242210251, 1917118.086011994 4229841.716773268, 1917116.5062054652 4229841.125199509, 1917114.2484211777 4229840.307947002, 1917102.9279919006 4229834.161315344, 1917069.129382869 4229815.669243412, 1917067.405299667 4229814.730737986, 1917066.7126864544 4229814.423728092, 1917064.526646497 4229813.480816425, 1917052.72268301 4229809.437379354, 1917042.857738465 4229806.052918208, 1917039.1447376534 4229804.784003712, 1917035.4163464042 4229803.502238008, 1917033.9466340758 4229803.074601541, 1917027.597272436 4229801.202796075, 1916990.3325393265 4229791.945542013, 1916981.0648395328 4229790.213520308, 1916978.0684032377 4229789.640277307, 1916961.6373785 4229787.338607822, 1916955.9943423073 4229786.4439968765, 1916939.0447113558 4229783.7560204575, 1916935.3949215095 4229783.492109645, 1916925.7916503907 4229783.236256102, 1916912.722953126 4229782.586333533, 1916903.080217617 4229782.005566836, 1916883.164769486 4229777.080345804, 1916864.7326931234 4229772.515166448, 1916857.7789857741 4229773.702384788, 1916854.7281143395 4229773.389075673, 1916846.4897494344 4229771.135796582, 1916845.0708323768 4229769.269720243, 1916842.9846529593 4229764.351304834, 1916838.6889428522 4229763.211745394, 1916836.3893238837 4229763.470788491, 1916833.609409012 4229764.239765553, 1916824.1646207683 4229773.391347558, 1916821.8102315946 4229774.311795181, 1916820.9770881722 4229774.91700771, 1916816.8855337617 4229790.226747502, 1916815.4394862093 4229792.8451886885, 1916813.8122398865 4229796.02059232, 1916791.4062500023 4229820.722499998, 1916790.7014498382 4229822.345532694, 1916790.1989739644 4229823.407178352, 1916788.917216622 4229831.6862145495, 1916791.6473190696 4229833.729408509, 1916792.280512234 4229834.772654256, 1916792.4531007204 4229835.70822805, 1916776.0064615067 4229872.768172376, 1916774.482816062 4229876.179404803, 1916762.4778795398 4229902.470041465))'::geometry,'38471','Le Sappey-en-Chartreuse','LE SAPPEY-EN-<br>CHARTREUSE','SAP','SPC'),
     (16,'SRID=3945;POLYGON ((1914782.7669310726 4235664.564063139, 1914831.0899998979 4235706.209999925, 1915237.5200000303 4236062.520000031, 1915145.8691008498 4236366.324942643, 1915170.2102226734 4236552.554352238, 1915181.67500002 4236587.7949999245, 1915173.717004107 4236693.37058371, 1915174.13 4236703.41, 1915331.194105983 4236786.797752242, 1915439.37 4236844.23, 1915573.87 4236915.19, 1915600.75 4236918.62, 1915762.66 4236931.63, 1915780.08 4236931.77, 1915796.15 4236927.71, 1915803.67 4236925.55, 1915836.12 4236918.77, 1915890.53 4236901.49, 1915911.63 4236899.06, 1915936.27 4236898.31, 1915971.93 4236902.42, 1915992.84 4236906.9, 1916035.53 4236921.84, 1916080.9 4236941.81, 1916096.58 4236942.74, 1916129.81 4236951.32, 1916159.44 4236955.3, 1916168.59 4236955.3, 1916178.3 4236951.19, 1916231.69 4236910.14, 1916253.16 4236898.2, 1916265.58 4236895.36, 1916289.66 4236893.31, 1916319.53 4236894.8, 1916365.09 4236908.8, 1916423.82 4236924.68, 1916441.19 4236926.91, 1916459.48 4236924.68, 1916485.81 4236918.52, 1916513.81 4236917.96, 1916563.03 4236926.57, 1916611.39 4236942.8, 1916646.67 4236956.79, 1916666.28 4236959.97, 1916673.93 4236951.52, 1916674.89 4236948.12, 1916688.63 4236926.03, 1916704.67 4236901.84, 1916718.28 4236881.81, 1916743.73 4236860.87, 1916774.54 4236835.8, 1916805.17 4236819.36, 1916837.9 4236802.11, 1916887.35 4236776.54, 1916950.62 4236743.32, 1917005.18 4236714.8, 1917059.91 4236686.01, 1917104.22 4236662.46, 1917138.95 4236643.86, 1917147.48 4236639.32, 1917170.56 4236626.98, 1917183.3 4236620.5, 1917184.07 4236620.11, 1917186.81 4236616.96, 1917217.21 4236583.71, 1917242.46 4236556.37, 1917277.93 4236517.5, 1917320.61 4236470.95, 1917355.78 4236432.69, 1917392.07 4236393.25, 1917418.33 4236364.42, 1917448.02 4236331.95, 1917489.42 4236286.52, 1917502.89 4236271.8, 1917526.78 4236244.91, 1917546.42 4236222.81, 1917571.4 4236210.64, 1917600.05 4236194.7, 1917661.91 4236161.92, 1917703.68 4236141.32, 1917816.33 4236084.69, 1917876.44 4236054.75, 1917943.77 4236020.58, 1918010.52 4235987.06, 1918069.75 4235957.05, 1918113.65 4235934.79, 1918157.52 4235913.14, 1918207.14 4235887.9, 1918269.73 4235856.44, 1918323.82 4235828.87, 1918382.31 4235799.3, 1918443.98 4235768.05, 1918534.76 4235723.15, 1918635.7062943294 4235671.334502122, 1918632.6342975793 4235652.7835415825, 1918371.4600000186 4235437.434999989, 1917867.0910931227 4235026.702813756, 1917649.6904956184 4234885.438052357, 1917603.5514898181 4234854.326257841, 1917600.7691396985 4234852.0986740785, 1917575.068740973 4234827.120386001, 1917480.0904269593 4234733.679565296, 1917442.1986191494 4234696.649810108, 1917361.6672996047 4234617.880674704, 1917306.1441809938 4234562.5026559625, 1917301.4938736893 4234543.86180701, 1917291.0174999647 4234474.71999997, 1917244.343116025 4234169.3483838, 1917205.8119527842 4234148.760110441, 1917150.4920819232 4234116.850246277, 1916973.278293282 4234020.101899061, 1916964.605546372 4234015.313237463, 1916959.4615771263 4234012.485578376, 1916954.5998553012 4234009.671570891, 1916950.1014055763 4234007.080547868, 1916947.9660222696 4234005.7781579085, 1916942.8484806353 4233998.808248223, 1916920.457965459 4233968.11597927, 1916903.8056670916 4233949.061462507, 1916885.891166498 4233928.735913462, 1916856.4467466178 4233900.156696351, 1916845.9780066088 4233888.36183696, 1916840.6155698975 4233878.247173415, 1916831.6548861535 4233849.544964559, 1916827.7571009817 4233805.7000389695, 1916816.5110487295 4233768.61260359, 1916810.8802561655 4233753.519631631, 1916778.1048411843 4233699.423215541, 1916772.0837785292 4233683.665113396, 1916766.9249999612 4233663.704999934, 1916701.893340061 4233458.155000009, 1916683.5111943379 4233409.957813825, 1916642.7837249022 4233304.219927021, 1916639.5281559804 4233302.135725559, 1916634.331788571 4233295.722851725, 1916592.7137499852 4233295.653749984, 1916504.960307622 4233290.347374791, 1916461.329325556 4233274.489607236, 1916415.0040789426 4233281.646022264, 1916363.9992317155 4233269.007015987, 1916338.7234399123 4233251.064745082, 1916321.1778999984 4233237.4824626045, 1916309.8105371487 4233229.686236382, 1916295.3702119559 4233229.030762697, 1916280.685441107 4233238.469036834, 1916266.0356621668 4233242.525437672, 1916264.4628912963 4233266.33776765, 1916260.1620268014 4233273.543680214, 1916227.4083855953 4233264.62207996, 1916198.7231068655 4233261.015570077, 1916184.0173578267 4233273.8957255725, 1916169.9267532062 4233276.892891686, 1916117.406356271 4233297.342297565, 1916125.418262299 4233331.207747358, 1916146.120262753 4233374.375872527, 1916157.5489324818 4233392.534778993, 1916162.437551372 4233398.97433293, 1916173.1753085542 4233410.446612153, 1916182.4240495022 4233419.988950967, 1916185.1560504353 4233425.7634174945, 1916186.1638768055 4233435.495814793, 1916179.7158188908 4233464.223086595, 1916175.1671113574 4233474.448773176, 1916163.1429897412 4233509.528164671, 1916160.8851369156 4233519.443230895, 1916159.882000625 4233526.331261234, 1916161.3751780367 4233535.305985328, 1916175.9349595143 4233582.725182187, 1916182.491787081 4233609.721532952, 1916191.3166557457 4233641.855205685, 1916189.9825323941 4233642.632595628, 1916190.5370325788 4233644.761366452, 1916176.1611141937 4233637.423659475, 1916161.7890524147 4233613.966528868, 1916144.8687961074 4233600.043286678, 1916138.6634773372 4233594.447281137, 1916103.3183524983 4233578.2529901285, 1916096.135368512 4233572.430844269, 1916092.43939975 4233567.701986088, 1916087.5851460814 4233561.659311335, 1916080.5762324638 4233556.5996993985, 1916072.3991795636 4233550.67601838, 1916068.8917557567 4233547.910935446, 1916065.7930793623 4233545.062187641, 1916054.7689424474 4233532.148663253, 1916047.786366453 4233523.8045465695, 1916036.9007874078 4233510.946283547, 1916023.1462258135 4233496.401280443, 1916009.5675000018 4233476.368750001, 1916002.279052679 4233470.6552789295, 1915987.8797545831 4233461.049626779, 1915983.6488313272 4233457.955276993, 1915981.0671398537 4233454.543133651, 1915974.3137500014 4233442.246249971, 1915962.6589556017 4233438.282613986, 1915960.110400589 4233434.670902285, 1915959.6024696175 4233433.972695247, 1915959.1229313964 4233432.723701798, 1915944.9921475125 4233394.5234312145, 1915943.6051605046 4233396.059120533, 1915942.2939619161 4233392.780421383, 1915937.699608031 4233400.823363934, 1915922.4131275204 4233456.55447875, 1915917.652584162 4233501.581577074, 1915914.282809254 4233511.390710107, 1915905.6999795472 4233521.065833533, 1915896.203124229 4233531.681212862, 1915889.7396248407 4233539.223092526, 1915877.8748291372 4233556.148035623, 1915879.1858275717 4233567.186226892, 1915905.1620056336 4233613.52815305, 1915906.29 4233618.96, 1915902.1241183784 4233615.989545278, 1915904.624442498 4233621.568560307, 1915890.0919584804 4233611.53591104, 1915857.6924999948 4233560.183750048, 1915832.4907100918 4233486.165915887, 1915826.5632216437 4233486.727534689, 1915765.6817661708 4233544.260951446, 1915756.2268058532 4233554.833476296, 1915748.9169108532 4233564.145732268, 1915740.8781027955 4233575.689582983, 1915739.530763869 4233579.577693039, 1915737.0666354154 4233587.512731816, 1915738.362889671 4233614.32175612, 1915736.2845595707 4233627.465388497, 1915734.51859566 4233632.253577687, 1915671.4841704427 4233715.041789685, 1915625.1137992886 4233822.822084951, 1915572.2117419285 4233903.452200442, 1915565.1676631558 4233909.7477466175, 1915558.7803296857 4233913.192493932, 1915491.830927873 4233915.345407282, 1915491.7286814288 4233917.65243806, 1915491.0824764946 4233917.686316766, 1915490.2792796472 4233947.817733838, 1915490.1030410076 4233954.332466519, 1915489.901675108 4233961.414436621, 1915489.7378994247 4233967.219548884, 1915488.9953119478 4234015.048527898, 1915488.714091642 4234091.051436168, 1915488.4179402776 4234146.884508821, 1915487.8414934278 4234281.30218306, 1915486.6507939221 4234510.781906913, 1915483.808625669 4234569.750416477, 1915481.9534707165 4234596.605319343, 1915464.6106477352 4234644.366457529, 1915446.5466408273 4234708.294764978, 1915443.8888088483 4234717.916449647, 1915441.793454863 4234725.479768721, 1915440.8370294648 4234728.115247002, 1915438.7597981335 4234733.763637902, 1915435.6398997256 4234740.533167623, 1915413.366037708 4234783.850136779, 1915373.0778836855 4234861.223920035, 1915361.972411523 4234881.25870883, 1915098.4196476645 4235237.108215043, 1914795.4650000005 4235645.705000007, 1914782.7669310726 4235664.564063139))'::geometry,'38472','Sarcenas','SARCENAS','SAR','SAR'),
     (39,'SRID=3945;POLYGON ((1907390.86 4225056.11, 1907359.56 4225033.37, 1907306.93 4225036.32, 1907273.65 4225015.37, 1907256.09 4224994.44, 1907237.6 4224979.41, 1907223.71 4224970.53, 1907201.61 4224983.59, 1907154.11 4225039.7, 1907094.94 4225109.81, 1907091.11 4225114.14, 1907071.55 4225138.18, 1907067.2 4225154.2, 1907064.66 4225157.69, 1906991.61 4225255.15, 1906947.53 4225314.32, 1906911.09 4225352.31, 1906831.66 4225434.84, 1906829.36 4225436.95, 1906817.28 4225449.64, 1906816.09 4225451.36, 1906803.09 4225457.72, 1906765.13 4225440.4, 1906744.6 4225436.61, 1906736.07 4225435.19, 1906731.86 4225433.53, 1906714.41 4225422.37, 1906700.25 4225412.51, 1906684.13 4225400.74, 1906673.43 4225394.88, 1906660.32 4225387.46, 1906647.93 4225380.27, 1906640.93 4225376.21, 1906635.38 4225370.94, 1906632.05 4225367.4, 1906624.97 4225346.29, 1906619.72 4225331.06, 1906613.98 4225313.72, 1906611.3 4225306.7, 1906608.43 4225299.83, 1906592.36 4225314.06, 1906585.24 4225320.84, 1906568.86 4225332.08, 1906559.07 4225338.46, 1906552.35 4225340.91, 1906542.93 4225342.21, 1906529.14 4225342.76, 1906518.91 4225343.21, 1906513.07 4225344.08, 1906532.56 4225371.41, 1906539.14 4225379.98, 1906542.9 4225387.62, 1906549.18 4225401.08, 1906555.87 4225416.1, 1906559.92 4225423.6, 1906567.31 4225435.07, 1906572.23 4225443.21, 1906573.1 4225445.08, 1906571.95 4225460.97, 1906570.93 4225470.61, 1906571.05 4225477.8, 1906573.65 4225486.71, 1906578.61 4225497.02, 1906586.96 4225504.48, 1906596.14 4225512.25, 1906607.4 4225519.82, 1906619.97 4225525.06, 1906633.95 4225529.4, 1906641.24 4225531.61, 1906652.32 4225539.65, 1906668.19 4225552.62, 1906685.14 4225566.12, 1906691.54 4225572.14, 1906696.28 4225577.45, 1906704.34 4225587.59, 1906711.13 4225600.56, 1906717.11 4225613.08, 1906723.34 4225628.42, 1906729.84 4225643.51, 1906732.85 4225650.29, 1906736.59 4225657.43, 1906743.48 4225668.35, 1906748.71 4225675.12, 1906753.77 4225681.27, 1906761.32 4225690.58, 1906764.97 4225693.86, 1906768.62 4225694.43, 1906772.61 4225693.73, 1906767.81 4225666.89, 1906766.39 4225649.78, 1906765.7 4225637.69, 1906765.09 4225626.1, 1906760.51 4225593.57, 1906769.93 4225608.66, 1906775.73 4225625.4, 1906779.46 4225638.25, 1906781.87 4225644.69, 1906783.96 4225662.75, 1906786.1 4225678.74, 1906787.6 4225686.4, 1906792.84 4225701.05, 1906798.99 4225716.75, 1906806.54 4225736.59, 1906809.97 4225746.84, 1906813.76 4225760.98, 1906816.79 4225769.54, 1906821.89 4225776.97, 1906828.26 4225784.04, 1906838.63 4225794.58, 1906845.23 4225803.07, 1906851.74 4225814.52, 1906856.62 4225841.46, 1906859.11 4225853.25, 1906861.34 4225855.84, 1906867.13 4225860.03, 1906872.6 4225862.17, 1906877.91 4225864.34, 1906884.44 4225867.01, 1906900.38 4225870.71, 1906908.94 4225872.17, 1906918.82 4225874.02, 1906930.26 4225877.07, 1906944.76 4225884.06, 1906957.85 4225889.98, 1906977.43 4225899.95, 1907003.32 4225911.65, 1907012.31 4225915.9, 1907030.97 4225929.06, 1907036.27 4225933.48, 1907042.71 4225939.2, 1907052.32 4225951.13, 1907056.54 4225956.91, 1907060.95 4225961.9, 1907064.52 4225964.79, 1907062.25 4225967.9, 1907046.26 4225974.58, 1907023.18 4225983.27, 1907016.15 4225984.88, 1907011.5 4225985.31, 1907001.86 4225984.51, 1906996.1 4225983.88, 1906988.46 4225988.01, 1906990.28 4225990.75, 1906929.91 4225999.9, 1906927.21 4225998.97, 1906914.54 4226003.06, 1906894.3 4226010.73, 1906889.58 4226012.59, 1906883.09 4226016.83, 1906876.17 4226021.9, 1906870.73 4226026.19, 1906865.05 4226030.46, 1906858.5 4226037.54, 1906847.02 4226048.77, 1906843.27 4226052.53, 1906838.57 4226056.04, 1906833.35 4226057.75, 1906825.76 4226059.58, 1906820.74 4226061.9, 1906816.21 4226066.02, 1906806.34 4226075.37, 1906798.96 4226083.05, 1906794.63 4226086.99, 1906785.26 4226093.89, 1906776.64 4226098.96, 1906769.64 4226101.93, 1906763.18 4226104.42, 1906756.77 4226112.96, 1906750.56 4226120.03, 1906742.22 4226125.72, 1906737.68 4226127.95, 1906726.11 4226131.2, 1906716.89 4226132.98, 1906698.96 4226135.23, 1906689.81 4226136.37, 1906681.69 4226137.49, 1906667.03 4226140.5, 1906659.93 4226142.46, 1906654.88 4226143.87, 1906651.99 4226145.8, 1906649.96 4226150.05, 1906643.83 4226169.75, 1906637.1 4226190.44, 1906632.89 4226204.61, 1906628.04 4226222.29, 1906625.69 4226231.81, 1906624.65 4226241.35, 1906622.76 4226256.45, 1906621.77 4226262.12, 1906618.27 4226269.91, 1906617.35 4226278.16, 1906614.74 4226289.7, 1906613.03 4226296.38, 1906608.98 4226308.55, 1906608.88 4226318.66, 1906608.31 4226326.94, 1906603.56 4226337.01, 1906601.05 4226342.3, 1906598.7 4226354.18, 1906594.72 4226368.9, 1906592.28 4226379.8, 1906589.92 4226391.93, 1906587.36 4226403.04, 1906582.99 4226414.34, 1906576.69 4226428.95, 1906573.14 4226437.12, 1906568.87 4226445.7, 1906564.74 4226455.15, 1906560.08 4226463.55, 1906555.67 4226471.33, 1906549.69 4226477.1, 1906540.5 4226482.57, 1906535.62 4226485.84, 1906531.74 4226489.42, 1906530 4226490.35, 1906529.93 4226487.96, 1906529.73 4226480, 1906529.79 4226471.78, 1906529.77 4226464.03, 1906529.94 4226455.76, 1906527.11 4226447, 1906523.28 4226436.54, 1906520.27 4226427.98, 1906518.83 4226423.72, 1906516.94 4226414.74, 1906515.61 4226403.98, 1906514.67 4226394.2, 1906513.39 4226382.43, 1906511.78 4226370.5, 1906510.61 4226363.85, 1906508.37 4226356.03, 1906506.31 4226348.42, 1906504.54 4226341.1, 1906502.38 4226333.43, 1906503.08 4226325.27, 1906504.48 4226313.73, 1906505.94 4226300.4, 1906506.92 4226290.26, 1906507.2 4226282.39, 1906506.49 4226274.99, 1906504.73 4226265.56, 1906502.87 4226259.62, 1906492 4226268.04, 1906419.7 4226310.36, 1906411.29 4226314.09, 1906400.55 4226318.86, 1906390.53 4226323.52, 1906379.91 4226328, 1906366.42 4226334.1, 1906317.12 4226338.14, 1906282.62 4226380.82, 1906228.07 4226436.21, 1906176.77 4226488.08, 1906134.33 4226531.33, 1906070.5 4226581.81, 1906011.65 4226521.73, 1905961.56 4226470.69, 1905894.68 4226491.05, 1905863.75 4226570.59, 1905843.06 4226623.39, 1905833.74 4226678.35, 1905815.36 4226693.35, 1905791.4 4226725.63, 1905801.96 4226742.28, 1905814.06 4226761.28, 1905820.62 4226777.09, 1905826.61 4226792.85, 1905831.52 4226804.38, 1905834.26 4226810.99, 1905845.17 4226827.4, 1905847.99 4226833.2, 1905849.48 4226843.04, 1905851.11 4226861.34, 1905852.8 4226870.97, 1905853.52 4226872.88, 1905856.38 4226875.14, 1905867.04 4226880.35, 1905870.46 4226885.23, 1905873.41 4226897.04, 1905876.3 4226909.25, 1905880.38 4226926.03, 1905882.28 4226934.3, 1905883.06 4226939.81, 1905883.4 4226942.71, 1905881.45 4226949.04, 1905880.17 4226953.78, 1905883.92 4226964.76, 1905887.97 4226973.41, 1905891.3 4226979.9, 1905894.44 4226986.35, 1905898.45 4226998.83, 1905900.97 4227007.4, 1905902.17 4227010.18, 1905908.33 4227019.43, 1905915.09 4227028.8, 1905920.88 4227036.4, 1905922.53 4227039.89, 1905926.76 4227049.87, 1905931.63 4227062.36, 1905936.23 4227073.99, 1905941.91 4227088.7, 1905945.96 4227098.77, 1905946.64 4227103.93, 1905947.1 4227107.75, 1905945.63 4227120.43, 1905943.7 4227132.77, 1905941.79 4227140.59, 1905936.74 4227153.19, 1905931.66 4227164.48, 1905925.28 4227176.04, 1905914.85 4227188.85, 1905906.08 4227199.69, 1905900.31 4227207.96, 1905898.26 4227211.55, 1905896.74 4227215.16, 1905897.42 4227217.62, 1905901.37 4227214.83, 1905902.72 4227216.13, 1905906.96 4227220.21, 1905933.12 4227229.66, 1905937.11 4227232.69, 1905984.84 4227280.15, 1905993.69 4227290.87, 1905999.03 4227321.26, 1906010.33 4227385.04, 1906018.46 4227431.07, 1906023.82 4227459.51, 1906054.73 4227554.45, 1906059.57 4227568.77, 1906067.05 4227606.71, 1906077.99 4227645.49, 1906082.62 4227663.14, 1906079.85 4227688.97, 1906074.67 4227732.84, 1906076.33 4227765.8, 1906078.19 4227797.44, 1906079.9 4227824.72, 1906080 4227833.72, 1906079.65 4227844.62, 1906076.76 4227867.13, 1906073.42 4227885.89, 1906070.39 4227900.52, 1906067.1 4227914.68, 1906064.7776469947 4227916.205220566, 1906105.520000002 4227944.984999993, 1906191.6694418911 4228000.947647354, 1906289.6874999988 4228070.037500022, 1906345.2324999112 4228134.027499977, 1906428.6574999143 4228217.005000039, 1906490.7105875204 4228257.005765009, 1906549.686912968 4228283.52211545, 1906574.936447359 4228311.190627515, 1906581.4756376387 4228331.063117401, 1906625.7549999955 4228362.057500002, 1906725.7275000191 4228425.984999961, 1906912.400650728 4228543.409350329, 1906957.086701788 4228571.51853741, 1906988.4425000062 4228591.242499973, 1907067.9072186833 4228640.818409122, 1907199.6893814225 4228723.033770054, 1907243.0375000015 4228750.077499953, 1907339.2127831464 4228810.665533335, 1907387.0987499997 4228840.832499974, 1907436.0749999916 4228871.593749962, 1907514.9685677313 4228920.882529833, 1907513.2624744647 4228934.8770862315, 1907629.6625000779 4229025.328750031, 1907631.592619693 4229024.074482022, 1907651.4665634106 4228997.5873027975, 1907654.5587139716 4228993.628525014, 1907670.815544505 4228975.604366793, 1907671.1533986058 4228963.922034978, 1907671.1116181768 4228963.804817663, 1907688.4635338427 4228944.432361525, 1907688.9877023061 4228943.124103038, 1907690.8381146777 4228939.714818043, 1907688.7008615024 4228932.75146367, 1907688.3901455738 4228932.347399609, 1907700.7266799533 4228923.179143349, 1907707.7052100135 4228917.95766881, 1907719.382852509 4228908.311911898, 1907744.842354314 4228887.317124998, 1907751.833785534 4228881.242866083, 1907776.3093996637 4228857.527221478, 1907781.2715491522 4228848.126082367, 1907781.9874945336 4228842.962000152, 1907784.9917189947 4228840.1764298845, 1907785.2919198498 4228837.224454808, 1907787.8967983637 4228838.470512143, 1907884.8097923335 4228892.016883123, 1907885.982475795 4228892.831669383, 1907896.2540732224 4228898.240001316, 1907905.8319974248 4228903.24395356, 1907908.8407268822 4228904.80532158, 1907909.776006837 4228905.291661526, 1907910.500416022 4228905.6686659455, 1907910.7565012304 4228905.802232543, 1907910.9999162087 4228905.928481647, 1907911.1854962353 4228906.024892925, 1907911.2848201673 4228906.076374298, 1907911.362358909 4228906.116821981, 1907911.4425975832 4228906.158402133, 1907911.4700595574 4228906.172673852, 1907911.4764426635 4228906.176004115, 1907911.4793687256 4228906.177523945, 1907911.4812838917 4228906.178513654, 1907911.4841212255 4228906.179986968, 1907911.4854186669 4228906.18066223, 1907912.0457266325 4228906.471868144, 1907915.6092729133 4228908.324119302, 1907923.6757355765 4228912.552174926, 1907927.3133789198 4228914.484388655, 1907935.6321128488 4228918.905774407, 1907961.7357043622 4228932.6243651025, 1907967.5002248976 4228935.072022987, 1907967.5754368945 4228935.104563107, 1907967.706023315 4228935.161098397, 1907973.9465202373 4228937.854217956, 1907978.8403338932 4228940.649000157, 1907982.1526461993 4228942.5463919835, 1907982.638783392 4228942.824765648, 1907983.4982063791 4228943.3178376155, 1907997.4033219493 4228951.148095868, 1908018.4609106972 4228963.019274833, 1908020.4556846712 4228964.148974992, 1908027.8601019753 4228968.339105995, 1908051.2116550447 4228981.511679931, 1908074.478902779 4228994.683358508, 1908081.7083086253 4228998.725971637, 1908086.9350233607 4229001.596042095, 1908138.5666784872 4229029.405728768, 1908198.1421778963 4229061.490911833, 1908201.8409625057 4229063.474773122, 1908203.7877300684 4229064.519149881, 1908204.9492294227 4229065.140680084, 1908205.7725858171 4229065.584407832, 1908206.2216623633 4229065.8256349685, 1908206.5066005362 4229065.978938933, 1908206.6586370738 4229066.0602143295, 1908206.8042739818 4229066.1383386925, 1908206.926292579 4229066.2038876135, 1908206.9900575052 4229066.238216692, 1908207.0170881506 4229066.252717987, 1908207.040295208 4229066.265138019, 1908207.0503747107 4229066.270582586, 1908207.0611845772 4229066.276357458, 1908207.0702657562 4229066.281245465, 1908207.0749108067 4229066.2837432455, 1908207.0777892263 4229066.285286569, 1908207.0811833984 4229066.287114506, 1908207.082558543 4229066.287851307, 1908207.0845301643 4229066.288910898, 1908207.0854981183 4229066.289431659, 1908207.0859947393 4229066.289697113, 1908207.0865454664 4229066.289993382, 1908207.0868873317 4229066.290177108, 1908207.0870916855 4229066.29028668, 1908207.0872007117 4229066.290345263, 1908207.0872935497 4229066.290395209, 1908207.0873828141 4229066.290443133, 1908207.0875388994 4229066.29052697, 1908217.457789384 4229071.898428145, 1908221.1780674497 4229073.91917588, 1908232.498380288 4229080.064435594, 1908246.7674701528 4229087.8270029565, 1908252.7337057856 4229091.022118898, 1908263.3962393033 4229096.740626883, 1908274.5620080326 4229102.730931042, 1908292.9692688698 4229112.680031602, 1908299.748266985 4229116.075788724, 1908322.801726728 4229128.279575349, 1908340.2660015572 4229137.429470798, 1908388.355906122 4229162.590075047, 1908417.8848514985 4229178.088507585, 1908449.8872783487 4229194.935921057, 1908449.8875561296 4229194.936067227, 1908449.9008212523 4229194.943048948, 1908449.962563926 4229194.975542349, 1908449.989461913 4229194.989700659, 1908450.0366934412 4229195.0145672625, 1908450.0840571718 4229195.039480313, 1908450.1530971262 4229195.075834301, 1908450.2634470128 4229195.1338928845, 1908450.471979619 4229195.2437009355, 1908450.7069906003 4229195.367326117, 1908451.2636078787 4229195.660284048, 1908452.3463746803 4229196.230226069, 1908453.3360394347 4229196.751004839, 1908455.591272541 4229197.93794285, 1908457.9839934306 4229199.197089381, 1908460.3689911298 4229200.451380317, 1908464.001538763 4229202.363668737, 1908469.1882795182 4229205.091609879, 1908481.3825159587 4229211.510564348, 1908492.4789824581 4229217.347547328, 1908500.0461228578 4229221.329525545, 1908554.3824546896 4229249.920366726, 1908572.3010390804 4229259.364457494, 1908627.2321796294 4229288.390567441, 1908716.2799039148 4229335.439968415, 1908727.4838993046 4229341.3357776115, 1908727.5137354594 4229341.351477605, 1908727.5359074348 4229341.363150144, 1908727.5618444819 4229341.376792419, 1908727.6110832994 4229341.4027254805, 1908727.7210618602 4229341.460602448, 1908728.1231106252 4229341.672272312, 1908728.586087878 4229341.915944214, 1908729.487320638 4229342.390434177, 1908730.1894026916 4229342.75937656, 1908731.1078433217 4229343.24264017, 1908733.0622780004 4229344.271503507, 1908739.8263413503 4229347.832682213, 1908746.839287988 4229351.558194021, 1908765.010986789 4229361.170097098, 1908773.3986849852 4229365.643210091, 1908778.6552284458 4229368.471626096, 1908790.581622547 4229374.845204445, 1908796.6306032806 4229378.121320845, 1908802.481112976 4229381.258084301, 1908808.9970596624 4229384.76052878, 1908814.2885505229 4229387.609157047, 1908820.5135569377 4229390.95422523, 1908825.9420708024 4229393.869130276, 1908834.044334114 4229398.200163137, 1908839.8476829573 4229401.311341126, 1908849.9173505155 4229406.693740126, 1908850.0597071676 4229406.703783068, 1908850.09 4229406.72, 1908850.1136642536 4229406.732573832, 1908859.822461589 4229389.533479431, 1908894.0994753684 4229328.745812221, 1908912.6959338638 4229295.362893236, 1908916.6899067222 4229288.196356542, 1908922.5577339155 4229277.765509417, 1908928.4247568734 4229267.332713532, 1908968.906093165 4229195.422692056, 1908981.9806871507 4229172.215144867, 1909011.7769359732 4229119.369695802, 1909025.0010747497 4229095.922031908, 1909030.648816017 4229085.909625145, 1909034.2175715226 4229079.5526923435, 1909035.042578017 4229078.081579356, 1909095.8931189347 4228969.693513629, 1909108.6727188558 4228947.010675784, 1909163.0501784629 4228849.657495549, 1909195.7485661162 4228791.160904815, 1909223.0671122056 4228742.322374681, 1909240.3750630796 4228711.364416706, 1909250.899010108 4228692.331045184, 1909358.2779063429 4228498.590604771, 1909411.816775638 4228402.479449045, 1909419.2039106647 4228389.1654142905, 1909452.300521611 4228329.213702215, 1909453.861843279 4228326.315514333, 1909456.0657470352 4228322.005065505, 1909462.288214088 4228309.821791655, 1909480.427395931 4228273.259302627, 1909482.8449567426 4228268.41598572, 1909494.7513446196 4228244.58443153, 1909500.9096872623 4228232.259629022, 1909517.5290521246 4228200.97081714, 1909524.5994313934 4228188.123877774, 1909541.1485000004 4228158.476493381, 1909574.8788772176 4228098.605462298, 1909654.4945958222 4227958.585968395, 1909687.8420658445 4227900.499093028, 1909721.5845692048 4227842.639233691, 1909758.5493739808 4227779.4841773845, 1909780.8621422239 4227741.396276166, 1909790.6613987146 4227724.9456173135, 1909795.856885317 4227716.243254034, 1909798.5766160134 4227711.980530577, 1909801.137492952 4227707.995138768, 1909811.59151411 4227693.962852425, 1909820.7923840776 4227681.798145575, 1909824.4246770982 4227677.330797855, 1909826.1476455801 4227675.272000614, 1909826.4953600324 4227674.861640824, 1909830.1188697394 4227670.584377096, 1909831.8224652587 4227668.575103492, 1909834.613193116 4227665.282313877, 1909847.4197692021 4227650.631576955, 1909858.4629216564 4227637.995705347, 1909876.2989561101 4227617.36295271, 1909880.3967477223 4227612.635080157, 1909884.1146114906 4227608.598219728, 1909902.1390119249 4227589.1539482465, 1909906.9009445203 4227584.081932952, 1909915.0760685238 4227575.602292571, 1909920.2964219043 4227570.223950389, 1909925.4923265234 4227565.060193681, 1909943.1588536343 4227547.56293169, 1909961.1248709233 4227530.7702540755, 1909970.2380135898 4227522.331530491, 1909981.9161817194 4227511.65923371, 1909990.6576721128 4227503.807907245, 1909995.102444741 4227499.841862302, 1909995.8223309636 4227499.204758725, 1910006.4444694803 4227489.750430883, 1910024.1780738605 4227474.21475171, 1910026.7289777326 4227472.050217612, 1910031.0826099073 4227468.605418032, 1910031.2845489061 4227468.4457912585, 1910039.5840155557 4227461.920149578, 1910098.1254959514 4227417.053006073, 1910152.0834774517 4227375.615082804, 1910155.721384951 4227372.8184776995, 1910159.0539655166 4227370.259177023, 1910162.4662983231 4227367.654581406, 1910163.7849900161 4227366.648696671, 1910166.822420357 4227364.3441697825, 1910170.16874917 4227361.812247457, 1910244.6994349658 4227305.356458647, 1910275.1390253275 4227282.269553549, 1910276.227225876 4227281.447215552, 1910286.4949582815 4227273.691695203, 1910379.5565045413 4227203.473912908, 1910376.6319092188 4227200.166308801, 1910375.0730637847 4227198.376347359, 1910371.323366059 4227194.095508622, 1910351.6389926083 4227171.56351236, 1910320.8993012232 4227136.337459237, 1910385.7894524082 4227073.243260867, 1910519.8669143752 4226943.439852329, 1910709.7903642135 4226760.279383105, 1910747.5032202199 4226723.9455914125, 1910774.1588279582 4226698.255728356, 1910785.3850032294 4226687.386145051, 1910806.916601728 4226666.494945675, 1910812.918482907 4226660.676719523, 1910815.68084544 4226657.972313242, 1910819.0608362677 4226654.7219326105, 1910822.4846895363 4226651.360950374, 1910826.8826677054 4226647.0974259665, 1910836.0969146176 4226638.18218827, 1910851.752353036 4226623.034038957, 1910882.6161876882 4226593.090993256, 1910896.5822189916 4226579.560562837, 1910912.6718680495 4226563.9721138235, 1910950.1094022563 4226527.723057703, 1910979.495974282 4226499.24683823, 1910982.2903773412 4226496.437019274, 1910991.9097727097 4226486.737261697, 1911007.3423563212 4226471.1947675245, 1911106.980103319 4226376.33058477, 1911105.957212578 4226375.237725836, 1911101.5854112313 4226370.564584138, 1911095.9077548052 4226364.495196814, 1911095.5385067787 4226364.100477909, 1911095.4207942055 4226363.974647298, 1911095.4020764863 4226363.954640031, 1911095.386287104 4226363.937760372, 1911095.176626036 4226363.713654672, 1911095.120455124 4226363.653609013, 1911095.0452681077 4226363.573254618, 1911094.8591706806 4226363.374273092, 1911094.7294714735 4226363.235717344, 1911094.5176643627 4226363.009210762, 1911094.4174433865 4226362.902391591, 1911094.2800962953 4226362.755687067, 1911093.7752032499 4226362.215715108, 1911091.434443981 4226359.713738822, 1911080.7873384207 4226348.332132647, 1911080.4633576034 4226347.986226077, 1911080.119958896 4226347.619178209, 1911079.8039667166 4226347.2803215785, 1911079.4139183601 4226346.865379564, 1911079.0549495344 4226346.479972336, 1911078.737845994 4226346.13971761, 1911078.3322566312 4226345.708438687, 1911077.857469668 4226345.202490157, 1911077.4474785007 4226344.760123223, 1911076.8299122693 4226344.1007548785, 1911076.3770425674 4226343.618929674, 1911076.1427951278 4226343.363940163, 1911075.5953378319 4226342.783660087, 1911074.8262202754 4226341.961011957, 1911074.4654868692 4226341.574310376, 1911073.8909243443 4226340.961761547, 1911073.4349201587 4226340.474054669, 1911072.8642246414 4226339.864047576, 1911072.3647346138 4226339.328646124, 1911071.95719484 4226338.893933639, 1911070.698201753 4226337.548723633, 1911070.030327796 4226336.8339644, 1911069.4287201248 4226336.191097673, 1911068.814854067 4226335.534543087, 1911067.824608946 4226334.475962871, 1911066.158847671 4226332.695458643, 1911065.097726308 4226331.561565842, 1911064.0833385678 4226330.4761710195, 1911063.1321235897 4226329.4596155835, 1911062.33033739 4226328.60308573, 1911060.897238939 4226327.070005761, 1911059.3877751185 4226325.457902106, 1911057.8225956932 4226323.782480992, 1911056.366663844 4226322.226955745, 1911051.91024704 4226317.449317953, 1911049.9160703816 4226315.302567687, 1911048.846772749 4226314.220650466, 1911048.8279189232 4226314.204367379, 1911047.792002136 4226313.304028595, 1911046.6301227838 4226312.09147646, 1911045.3753873988 4226310.517542961, 1911045.0385553401 4226310.068492855, 1911041.1931603872 4226303.478993126, 1911037.9840905254 4226300.674226866, 1911039.1061867434 4226298.062656883, 1910941.172854251 4226262.655283401, 1910849.3860962905 4226229.513890484, 1910849.247329746 4226229.6837328, 1910848.9802119439 4226229.587424193, 1910843.4371950245 4226236.638095047, 1910832.6789679625 4226248.827875788, 1910827.9189079106 4226252.047857157, 1910822.4155096905 4226255.365676928, 1910818.9643078838 4226257.224228534, 1910809.1678506467 4226262.607620087, 1910804.7200122762 4226264.995970648, 1910795.0879330589 4226269.590288657, 1910750.8013511403 4226290.192401637, 1910675.5460830492 4226238.657101172, 1910659.5457678211 4226227.482759424, 1910647.2077331422 4226218.845070204, 1910642.4989801568 4226215.465928213, 1910638.9082591399 4226212.8852114035, 1910634.5763521693 4226209.773731029, 1910632.9240604169 4226208.588773665, 1910630.4959360345 4226206.8452353, 1910630.3006110026 4226206.697303023, 1910630.1647008988 4226206.590960983, 1910629.8286771558 4226206.316801133, 1910629.408954263 4226205.974145944, 1910620.4258334804 4226198.640642716, 1910608.4864238044 4226188.989963853, 1910597.0384889373 4226179.79822484, 1910594.613280822 4226177.854192564, 1910593.1694120339 4226176.692669423, 1910591.8585438966 4226175.64212592, 1910590.1035412585 4226174.231832878, 1910586.8876990168 4226171.650211579, 1910586.5028356551 4226171.341250762, 1910586.072886809 4226170.996046898, 1910584.219971788 4226169.5127728125, 1910581.5056946338 4226167.339514341, 1910576.3450767621 4226163.229206576, 1910551.7010503355 4226143.655606111, 1910537.576722764 4226132.524343702, 1910528.3807525602 4226125.421334104, 1910516.2764381168 4226116.452968236, 1910503.3562771082 4226108.541793126, 1910492.3751079333 4226102.062980583, 1910472.3557392815 4226089.9522473365, 1910467.7172375806 4226086.767917438, 1910463.3777161087 4226083.057947992, 1910447.9272584487 4226069.220116036, 1910426.2596047544 4226048.894669148, 1910411.9715233694 4226035.952960246, 1910385.6231253166 4226010.4302085955, 1910376.4752112394 4226002.331573199, 1910351.208517432 4225983.510261588, 1910339.9797094364 4225975.1545320125, 1910337.3393280958 4225973.190117063, 1910289.9763219776 4225938.09385242, 1910283.7715475154 4225935.515409339, 1910283.069794668 4225935.213246978, 1910275.1920663326 4225933.4899223335, 1910260.1206737692 4225930.2091328725, 1910232.5022599525 4225923.640171488, 1910212.0220620742 4225918.576430473, 1910200.4491637473 4225915.719326309, 1910189.0300523015 4225912.952110857, 1910177.7320060122 4225910.512052751, 1910174.468350075 4225909.796092756, 1910169.6364106908 4225908.611629432, 1910161.794323966 4225906.775756501, 1910161.7897641635 4225906.774688217, 1910161.7852015547 4225906.773622034, 1910160.675275635 4225906.514282352, 1910158.7707665656 4225906.070749544, 1910155.8584077733 4225905.387805298, 1910151.374055318 4225904.33174739, 1910143.7967623624 4225902.542229574, 1910138.778333271 4225901.295484948, 1910135.798798408 4225900.5638380265, 1910133.0168577225 4225899.880037283, 1910129.9644000174 4225898.814800006, 1910127.8146130266 4225898.068872081, 1910127.4542079372 4225897.939650589, 1910126.731119679 4225897.641493784, 1910119.658070112 4225894.618137608, 1910114.274790783 4225892.150918974, 1910108.512230631 4225889.108083242, 1910101.9040054334 4225884.876174222, 1910094.069113153 4225877.084041008, 1910088.5302490022 4225869.741205574, 1910084.0499390736 4225859.327984413, 1910080.6776791979 4225847.396946337, 1910075.430459107 4225826.592141687, 1910073.2824645673 4225820.781448759, 1910071.3042168291 4225816.4189492045, 1910069.307575105 4225812.340823181, 1910065.9890063747 4225806.185851139, 1910061.1331777596 4225797.895635585, 1910051.242157259 4225782.125057577, 1910044.3989037345 4225771.708809134, 1910038.3129022035 4225762.901364916, 1910032.9988137805 4225755.416850013, 1910028.328753373 4225749.18132002, 1910022.9974528528 4225742.241089028, 1910020.2851615173 4225739.013494758, 1910015.7312857236 4225733.746651415, 1910010.5417106166 4225729.548946217, 1910007.1384320972 4225727.066736603, 1910002.7004232272 4225724.498848986, 1909998.549119008 4225722.417312549, 1909992.4703955867 4225719.883842188, 1909983.733039183 4225717.008704734, 1909961.2547982251 4225710.48961825, 1909955.2765898644 4225708.734780769, 1909946.7916300416 4225706.224611061, 1909946.272272098 4225706.067065246, 1909942.7281715022 4225705.051638724, 1909936.3133377924 4225703.260922606, 1909925.0737696232 4225699.56483423, 1909908.7093415402 4225692.945476849, 1909904.24309222 4225691.050824414, 1909892.5315958604 4225685.766071074, 1909888.0295869499 4225683.570526017, 1909880.9714420787 4225679.916926451, 1909870.6000543658 4225673.578342115, 1909866.085523994 4225670.459943359, 1909862.9876531751 4225668.235095775, 1909862.7228904348 4225668.029292427, 1909862.0619032609 4225667.52111698, 1909857.2046898373 4225663.666454992, 1909853.747815173 4225660.673420847, 1909848.0231639608 4225655.091066071, 1909842.5973861185 4225649.128097544, 1909838.0209294371 4225643.706475553, 1909835.819431315 4225640.818286618, 1909832.5852515115 4225636.284818619, 1909830.20972889 4225632.853805114, 1909822.9219507242 4225621.227364434, 1909819.3096100704 4225615.242216192, 1909799.720702291 4225583.055510013, 1909796.4399039666 4225577.46913232, 1909785.8489567987 4225560.228904542, 1909782.06126067 4225555.259892614, 1909780.3891764928 4225553.278381119, 1909778.3619657701 4225551.113187061, 1909777.988739496 4225550.677815126, 1909777.5858132248 4225550.2065277975, 1909775.5936846503 4225547.684501451, 1909773.5337179236 4225545.165806897, 1909770.9150311593 4225541.959035855, 1909768.1538495442 4225538.1815521205, 1909768.064781509 4225538.059957489, 1909767.8762264214 4225537.780936417, 1909763.821834374 4225531.782969953, 1909762.3903398886 4225529.46619212, 1909760.9180417901 4225527.087798002, 1909760.0461514 4225525.63394323, 1909757.7905381543 4225521.780140578, 1909756.0635538308 4225518.78142736, 1909754.429384876 4225515.897452295, 1909751.7323463087 4225511.022278737, 1909749.0692377717 4225505.579621959, 1909748.7436679478 4225504.915344774, 1909748.0830367007 4225503.600958167, 1909747.7637462744 4225502.9380469, 1909746.4322234313 4225500.172045113, 1909745.700195627 4225498.3968778765, 1909744.7460763247 4225496.1837569475, 1909743.0704442388 4225492.196895241, 1909740.8785789341 4225486.248436117, 1909737.052980738 4225474.724580203, 1909734.3744308532 4225466.141577319, 1909730.2348565278 4225453.265611143, 1909728.4777626034 4225448.040234151, 1909726.9883097708 4225443.771535017, 1909724.5277295976 4225436.519022397, 1909723.239212238 4225433.391261618, 1909722.332324212 4225431.623501412, 1909721.3255087489 4225429.8891133275, 1909720.1254356608 4225428.013685972, 1909718.074569119 4225424.921220824, 1909717.2474482057 4225423.670177285, 1909715.2076520834 4225420.973424738, 1909712.9694750428 4225418.257132446, 1909709.927621795 4225414.9766577, 1909706.4142080592 4225411.488990434, 1909698.7802103949 4225405.202130002, 1909689.0491916267 4225397.383265505, 1909682.4859001883 4225392.312689468, 1909679.995910727 4225390.386053355, 1909679.940496549 4225390.45363133, 1909679.6975591977 4225390.27619988, 1909674.1919135347 4225396.909547641, 1909673.3548741068 4225396.908989242, 1909672.8064948507 4225396.908623412, 1909657.5568686607 4225396.02623732, 1909645.2000856702 4225393.522863945, 1909634.8449367557 4225391.258810329, 1909598.6857888966 4225382.928981313, 1909556.2352928917 4225372.349573313, 1909553.898994693 4225372.344192888, 1909550.3677092488 4225372.401695234, 1909510.682709814 4225382.441608892, 1909476.3368653564 4225391.032277298, 1909470.7408903218 4225392.428713795, 1909463.1701404243 4225393.581015935, 1909437.631788966 4225394.735105006, 1909428.4116120054 4225394.822505276, 1909427.4685187305 4225395.453261946, 1909424.5692299209 4225398.095625212, 1909424.1192316627 4225397.573775927, 1909421.214255124 4225393.8594071055, 1909416.8224315217 4225387.1489380365, 1909413.7221713688 4225381.578629175, 1909410.3365290875 4225374.22695366, 1909403.4690135883 4225358.851383958, 1909398.0731052416 4225346.876359054, 1909397.9012186695 4225346.4475713065, 1909395.6689517985 4225341.76765569, 1909389.2202897372 4225332.144641314, 1909387.494381805 4225329.176613042, 1909388.9797437273 4225328.584378707, 1909388.033960888 4225306.063345689, 1909387.3083309087 4225305.167740701, 1909375.2816055163 4225303.41629175, 1909356.4452419502 4225300.651656047, 1909344.5363536985 4225297.091858199, 1909331.2153403338 4225291.477155254, 1909306.5136183864 4225290.584135825, 1909291.6665270748 4225288.196064651, 1909281.3917801112 4225289.337713816, 1909152.689974186 4225326.661246896, 1909087.3363958339 4225345.875423402, 1909030.801535842 4225363.036414495, 1909028.910945486 4225361.677120742, 1908985.2510402529 4225324.855886176, 1908954.434612214 4225330.072259422, 1908926.3397346034 4225331.920417508, 1908887.024641259 4225330.149582557, 1908866.9088569079 4225330.930767966, 1908852.8467408903 4225340.910991902, 1908842.2189420864 4225350.304476684, 1908830.5863067852 4225378.455561111, 1908791.5765789475 4225397.869873482, 1908769.5759940022 4225409.015725262, 1908750.348532131 4225420.601381724, 1908669.176106063 4225427.042285637, 1908558.40246544 4225434.838233653, 1908474.754198814 4225440.878070682, 1908440.426750993 4225443.377534048, 1908396.060194763 4225446.6465200735, 1908260.1510627766 4225456.731673108, 1908257.46 4225476.45, 1908257.57 4225503.45, 1908245.05 4225536.73, 1908241.37 4225547.93, 1908240.47 4225567.69, 1908232.32 4225568.57, 1908232.52 4225587.26, 1908221.88 4225616.99, 1908203.33 4225625.62, 1908222.33 4225688.74, 1908196.05 4225682.91, 1908161.36 4225671.99, 1908111.76 4225644.34, 1908076.29 4225624.85, 1908056.66 4225614.07, 1908048.53 4225608, 1908037.95 4225598.12, 1908020.54 4225580.44, 1908019.79 4225583.88, 1908009.23 4225562.43, 1908001.21 4225543.01, 1907995.75 4225526.15, 1907994.05 4225517.76, 1907996.78 4225518.67, 1907985.24 4225500.26, 1907976.72 4225489.35, 1907970.84 4225480.88, 1907968.09 4225476.01, 1907963.63 4225464.74, 1907962.9 4225462.88, 1907956.82 4225447.8, 1907952.83 4225437.12, 1907948.22 4225425.04, 1907947.18 4225425.32, 1907943.01 4225425.79, 1907910.47 4225394.34, 1907877.67 4225363.28, 1907874.22 4225360.3, 1907861.41 4225348.72, 1907844.14 4225339.59, 1907825.99 4225318.76, 1907801.75 4225301.24, 1907776.56 4225283.34, 1907752.52 4225266.51, 1907735.22 4225247.85, 1907709.48 4225220.76, 1907700.02 4225211.47, 1907692.64 4225205.69, 1907679.05 4225196.49, 1907663.66 4225186.32, 1907638.55 4225169.23, 1907627.84 4225162.49, 1907598.2 4225152.25, 1907569.8 4225155.7, 1907531.47 4225146.13, 1907487.5 4225127.26, 1907452.9 4225106.28, 1907438.17 4225097.1, 1907390.86 4225056.11))'::geometry,'38474','Sassenage','SASSENAGE','SAS','SAS'),
     (20,'SRID=3945;POLYGON ((1923767.41 4210002.39, 1923702.33 4209939.32, 1923688.18 4209924.39, 1923682.24 4209918.11, 1923685.25 4209911.03, 1923689.53 4209907.22, 1923692.81 4209879.94, 1923697.309402456 4209845.233702475, 1923698.447524118 4209836.454761402, 1923651.4370954537 4209818.5307213, 1923642.1652759847 4209827.599097485, 1923640.2535632101 4209829.468863247, 1923581.702617891 4209797.402144431, 1923543.6906193297 4209771.101279806, 1923537.6544386572 4209767.109456867, 1923472.6597624826 4209707.491904752, 1923463.511283981 4209700.419983438, 1923458.5287934244 4209696.586706656, 1923447.967728558 4209689.132333267, 1923432.4788931215 4209678.732806741, 1923423.9808496097 4209673.589473155, 1923401.4174952772 4209660.551440715, 1923348.0515709203 4209629.408691975, 1923317.3251479173 4209614.0084927315, 1923284.7308538768 4209603.9110471085, 1923255.5205660122 4209596.637262988, 1923223.6772823888 4209590.989058704, 1923136.9555518155 4209603.39745417, 1923108.5005467546 4209607.655522271, 1923095.001388289 4209611.541473297, 1923054.340367949 4209631.421444529, 1923029.8515852732 4209643.668057313, 1923008.894983343 4209655.075123889, 1922974.2861738037 4209674.587313242, 1922927.6528532773 4209699.929086019, 1922917.6773569293 4209703.569717436, 1922909.3436334522 4209706.072007114, 1922887.9231642024 4209710.724184783, 1922871.5216011682 4209713.437833556, 1922839.8821741357 4209714.756359095, 1922795.118379753 4209709.205674387, 1922783.2346421822 4209707.7941649305, 1922764.9365601514 4209704.444457943, 1922757.7558873736 4209704.302528365, 1922750.217311803 4209704.291153521, 1922697.1112113204 4209706.812300382, 1922592.0297027822 4209742.008445022, 1922574.3995470647 4209747.26705592, 1922516.1953878195 4209754.849469022, 1922389.4915795254 4209775.310121098, 1922349.7431957931 4209775.396418541, 1922287.847180795 4209764.30302597, 1922279.2792816719 4209763.04502547, 1922278.2270520178 4209762.892557539, 1922276.1933188094 4209762.670323786, 1922275.1220942014 4209762.554138139, 1922224.509471678 4209755.65165832, 1922184.207206547 4209744.416438456, 1922115.7593430378 4209726.001182915, 1922049.333508561 4209711.035292685, 1922035.7971776074 4209707.970702172, 1922033.6841179456 4209707.94540692, 1922005.773027281 4209707.106478496, 1921975.443399664 4209708.535293773, 1921937.7528037832 4209718.746537253, 1921919.3604479705 4209726.968659351, 1921912.6176014198 4209729.584728396, 1921899.0089402928 4209739.52053503, 1921862.0781542405 4209769.947146905, 1921824.4977208604 4209800.658653738, 1921758.325 4209864.935, 1921731.5891709202 4209897.351994895, 1921503.9354149238 4210102.840816818, 1921480.8509858847 4210154.171070837, 1921416.555922303 4210162.538294821, 1921334.5683301205 4210124.834680583, 1921058.528391212 4210131.887098156, 1920869.211789963 4210085.615572633, 1920782.1674004474 4210043.7948508, 1920678.4581135383 4209986.942059429, 1920507.7537480942 4209890.855186832, 1920491.939342802 4209881.848665254, 1920418.4585592847 4209839.857871985, 1920381.293627806 4209818.6763251275, 1920267.1785210602 4209749.361594196, 1920253.2571023216 4209739.712793555, 1920185.5819779586 4209690.240507277, 1920161.6369345873 4209667.5594637245, 1920136.8691479145 4209638.905293456, 1920080.4380415208 4209567.93298531, 1919998.8291335644 4209446.994865149, 1919937.316068232 4209372.021491661, 1919897.2524718605 4209329.878486905, 1919749.5827287403 4209198.328135648, 1919742.551651131 4209210.087580932, 1919729.4813148119 4209231.947658907, 1919700.6970171384 4209278.709838649, 1919668.018884301 4209331.353540187, 1919616.6500493695 4209412.801565843, 1919291.2060028943 4209929.479942469, 1919276.9024136446 4210357.024301769, 1919277.9374770615 4210364.973821553, 1919413.5365144669 4210728.654993581, 1919488.4774534095 4210928.523084754, 1919501.5270608442 4210958.318786594, 1919586.0228593869 4211153.299672495, 1919595.546694437 4211173.53281624, 1919681.6017203594 4211341.0528059, 1919752.2049772742 4211481.045314577, 1919757.617323989 4211484.051119749, 1919759.2876830725 4211487.079396649, 1919790.482412111 4211504.170196021, 1920156.0565654037 4211707.335415782, 1920276.7204481992 4211774.978491502, 1920292.9595612262 4211785.151554038, 1920307.085028903 4211795.495341956, 1920308.4962445002 4211795.27178305, 1920308.6711438785 4211795.2440762175, 1920320.2407551876 4211805.232119616, 1920331.0504059452 4211817.225230754, 1920366.1547282469 4211871.4093245575, 1920488.9468996297 4212059.655998312, 1920851.5876802197 4212611.1544700395, 1920925.4270850203 4212835.206983806, 1921005.318060902 4213079.652529924, 1921363.3806997207 4213353.05412671, 1921703.6837342198 4213566.651534877, 1921714.6876858613 4213557.600153874, 1921716.017192767 4213558.417842919, 1921719.2007168005 4213556.341675408, 1921886.2119501063 4213416.431093072, 1921978.672698149 4213338.931861176, 1922070.7660853248 4213218.013981631, 1922073.3023063948 4213219.695247003, 1922076.951034384 4213214.8749367315, 1922384.1982910256 4213419.686253711, 1922551.7615587476 4213567.226158875, 1922701.8975000004 4213703.454999955, 1922805.9338051307 4213796.925272443, 1922916.2997332336 4213897.819679141, 1922978.9433862653 4213962.669069419, 1923090.054999978 4214081.522499941, 1923160.0975000034 4214157.104999998, 1923175.8067482978 4214173.327989522, 1923184.4096031985 4214173.599384532, 1923290.9037090868 4214176.243644867, 1923292.021043061 4214176.271525026, 1923293.1133011775 4214176.299522159, 1923300.9321745352 4214176.489019948, 1923312.4713518848 4214176.768040526, 1923323.3367564033 4214177.072156456, 1923368.337802732 4214178.310746967, 1923396.8622594618 4214178.064025282, 1923444.3259058492 4214175.152213358, 1923697.0453997336 4214159.029374586, 1923709.9517207537 4214151.7360585565, 1923724.029112929 4214147.121516405, 1923744.0773183224 4214134.217715519, 1923766.2852547176 4214116.820470574, 1923779.1311753506 4214111.655696499, 1923782.0195199063 4214110.899743569, 1923800.480996801 4214110.095725236, 1923825.3800000208 4214112.945000233, 1923841.7212171152 4214118.653697969, 1923864.8312814476 4214141.034719586, 1923874.1707422384 4214147.828409489, 1923880.6919210094 4214150.529839575, 1923910.5629509874 4214159.972301653, 1923949.1078973515 4214172.760206285, 1923955.051525791 4214174.409226056, 1923961.3070915574 4214176.19196287, 1923983.2592350496 4214174.978230598, 1924037.4364372462 4214164.492793643, 1924064.8934988538 4214143.5349671785, 1924078.1381852818 4214130.539003747, 1924088.3529747264 4214131.749946745, 1924160.702499866 4214158.610000049, 1924225.5474662727 4214191.39091525, 1924298.4837481908 4214193.70141238, 1924329.048231354 4214207.072806752, 1924341.9704355414 4214226.81367781, 1924344.8644679966 4214235.025222455, 1924349.8023391825 4214245.18239627, 1924355.2380964183 4214257.3011981435, 1924365.4303051322 4214272.119488583, 1924374.479825814 4214288.020309549, 1924381.6118245013 4214299.672378632, 1924393.6282203577 4214317.008201468, 1924404.2418946493 4214327.030756274, 1924411.1039076569 4214332.996845759, 1924422.0257628616 4214332.346149015, 1924438.5875613946 4214326.410405044, 1924457.4198017723 4214317.479142137, 1924483.1948641606 4214307.569762544, 1924520.8074999934 4214321.362500018, 1924550.9862751032 4214326.128718004, 1924602.6075000004 4214283.145, 1924652.85 4214277.17, 1924702.63 4214296.735, 1924731.1824994884 4214312.215718995, 1924781.302500003 4214339.389999982, 1924816.0584812802 4214367.126464945, 1924832.0035403941 4214373.565047227, 1924843.8527869778 4214375.110056671, 1924877.4124999836 4214364.229999989, 1924907.8250000097 4214346.952499971, 1924943.075278757 4214349.042707303, 1924968.495 4214350.55, 1924989.2687198548 4214347.1122602485, 1925063.9321280147 4214374.750075563, 1925168.3690202862 4214400.696864109, 1925206.047853095 4214405.467909767, 1925248.0935011057 4214408.8633539425, 1925325.817443911 4214411.2814641595, 1925351.817881882 4214424.561119907, 1925384.2974999952 4214441.149999979, 1925397.0505810552 4214458.015550755, 1925408.4750000043 4214476.022499993, 1925442.8045098719 4214507.736231221, 1925474.8825000254 4214537.37000001, 1925552.165000033 4214562.015000011, 1925587.9686375197 4214561.389493253, 1925614.5205582294 4214567.886234725, 1925641.0673260824 4214565.312291041, 1925680.8450000011 4214552.199999997, 1925697.0974999918 4214556.4174999865, 1925715.8187511705 4214568.124966433, 1925738.8650000193 4214602.630000008, 1925749.2858432624 4214613.411383777, 1925790.331194596 4214637.438743852, 1925837.8268922793 4214660.637721207, 1925864.3275000034 4214676.787499993, 1925875.7805554825 4214710.654761237, 1925883.716365153 4214746.214199357, 1925886.3721280145 4214755.22572508, 1925890.5500188905 4214763.428917102, 1925895.5850000044 4214769.21750003, 1925915.442499994 4214784.900000012, 1925968.8708204406 4214794.019219683, 1925985.9587367843 4214801.54369713, 1926004.9024999717 4214815.832499999, 1926037.174624333 4214820.850851163, 1926097.3719429106 4214832.939546758, 1926099.38 4214832.14, 1926102.42 4214832.47, 1926162.65 4214780.99, 1926272.35 4214612.77, 1926300.4 4214478.37, 1926336.3 4214455.96, 1926344.14 4214451, 1926373.17 4214433.23, 1926386.45 4214470.73, 1926408.85 4214552.28, 1926413.15 4214562.85, 1926417.08 4214576.76, 1926457.8 4214624.87, 1926493.77 4214668.95, 1926494.43 4214669.72, 1926519.41 4214699.25, 1926667.63 4214638.44, 1926671.08 4214637.37, 1926681.76 4214609.79, 1926682.86 4214596.29, 1926663.64 4214586.65, 1926661.43 4214579.31, 1926665.5 4214522.66, 1926693.2 4214497.18, 1926726.74 4214489.12, 1926730.64 4214481.55, 1926731.81 4214456.41, 1926754.83 4214409.99, 1926754.28 4214399.11, 1926752.14 4214384.58, 1926738.29 4214346.63, 1926738.98 4214329.9, 1926743.05 4214306.27, 1926754.48 4214275.59, 1926754.62 4214261.16, 1926746.49 4214225.87, 1926720.3 4214203.04, 1926695.29 4214183.96, 1926664.14 4214164.88, 1926634.17 4214151.9, 1926616.8 4214087.3, 1926627 4214048.84, 1926625 4213969.98, 1926602.33 4213909.92, 1926610.87 4213830.79, 1926600.26 4213701.83, 1926575.73 4213685.34, 1926509.3 4213642.67, 1926490.63 4213633.79, 1926433.15 4213610.89, 1926401.04 4213602, 1926283.96 4213573.66, 1926165.16 4213545.56, 1926049.25 4213494.5, 1925949.4 4213448.21, 1925834.94 4213395.43, 1925747.97 4213356.07, 1925710.07 4213338.33, 1925651.71 4213305.86, 1925549.17 4213287.44, 1925526.36 4213272.46, 1925520.71 4213269.67, 1925413.76 4213250.04, 1925362.69 4213256.69, 1925328.65 4213269.05, 1925264.92 4213274.38, 1925249.95 4213270.42, 1925253.02 4213267.77, 1925333.98 4213241.86, 1925322.09 4213120.38, 1925389.11 4213057.06, 1925335.77 4212995.89, 1925321.89 4212973.02, 1925319.65 4212966.32, 1925315.52 4212944.54, 1925325.54 4212904.42, 1925346.6 4212890.55, 1925423.84 4212880.67, 1925429.93 4212878.57, 1925432.78 4212875.05, 1925432.5 4212871.2, 1925416.12 4212858.34, 1925380.85 4212835.88, 1925430.74 4212830.26, 1925422.69 4212796.84, 1925406.37 4212723.09, 1925408.18 4212702.41, 1925279.83 4212671.29, 1925305.14 4212635.68, 1925330.53 4212599.23, 1925333.78 4212597.54, 1925448.26 4212589.89, 1925371.89 4212517.3, 1925310.7 4212469.05, 1925304.53 4212465.13, 1925284.36 4212461.88, 1925282.48 4212455.98, 1925278.75 4212445.33, 1925274.61 4212434.82, 1925268.18 4212428.05, 1925271.7 4212419.12, 1925360.86 4212434.01, 1925372.03 4212400.85, 1925319.86 4212371.82, 1925265.41 4212341.99, 1925212.74 4212318.58, 1925196.9 4212311.21, 1925178.55 4212215.6, 1925083.44 4212052, 1925083.64 4212046.73, 1925100.71 4211949.71, 1925116.07 4211859.85, 1925007.21 4211669.26, 1924916.63 4211621.56, 1924898.83 4211592.73, 1924878.04 4211585.09, 1924763.57 4211465.2, 1924751.86 4211417.23, 1924739.94 4211340.37, 1924737.15 4211319.16, 1924770.51 4211284.43, 1924752.56 4211247.43, 1924744.22 4211229.75, 1924729.03 4211198.02, 1924743.74 4211168.02, 1924751.39 4211152.61, 1924747.32 4211135.43, 1924741.95 4211109.88, 1924735.33 4211078.73, 1924733.58 4211069.78, 1924740.29 4211040.82, 1924748.98 4211004.44, 1924750.11 4211000.51, 1924738.09 4210976.51, 1924729.58 4210958.43, 1924717 4210933.57, 1924670.69 4210922.43, 1924626.83 4210912.6, 1924608.57 4210908.57, 1924603.68 4210908.95, 1924584.38 4210912.55, 1924553.24 4210919.07, 1924516.02 4210927.3, 1924503.07 4210930.23, 1924490.73 4210916.15, 1924468.48 4210890.58, 1924446.05 4210864.63, 1924434.64 4210852.3, 1924431.75 4210850.78, 1924425.3 4210847.38, 1924396.4 4210832.66, 1924402.8 4210792.3, 1924409.87 4210752.22, 1924415.04 4210723.29, 1924421.31 4210690.39, 1924427.16 4210655.94, 1924420.62 4210646.74, 1924405.8 4210626.39, 1924401.46 4210620.19, 1924386.23 4210604.8, 1924359.7 4210577.15, 1924330.72 4210568.49, 1924312.29 4210539.85, 1924310.5 4210538.01, 1924284.83 4210512.89, 1924245.86 4210474.12, 1924224.05 4210452.72, 1924109.18 4210338.72, 1924080.99 4210311.01, 1924046.57 4210277.54, 1924020.35 4210251.58, 1923984.58 4210216.18, 1923948.27 4210180.23, 1923918.12 4210150.39, 1923881.32 4210114.15, 1923871.08 4210103.79, 1923846.73 4210080.09, 1923817.89 4210052.15, 1923784.74 4210019.57, 1923767.41 4210002.39))'::geometry,'38478','Séchilienne','SÉCHILIENNE','SEC','SEC'),
     (47,'SRID=3945;POLYGON ((1912275.0627591694 4222213.181870741, 1912275.178119967 4222201.082688686, 1912275.192400712 4222199.714156933, 1912275.3171621046 4222190.471615815, 1912275.4749347821 4222176.572687996, 1912275.5000121065 4222171.79298783, 1912275.5462294011 4222163.884320188, 1912276.0051867587 4222108.815497057, 1912276.1048181583 4222067.133582672, 1912276.0941561821 4222062.7363441065, 1912276.0907664439 4222061.586965725, 1912276.0886444403 4222060.840568983, 1912276.0651944594 4222050.59771648, 1912276.314058202 4222027.005820675, 1912276.5865884654 4222002.184607269, 1912276.7232615466 4221981.347750926, 1912276.8697858101 4221946.821252421, 1912276.8697628903 4221943.598612818, 1912276.8812403444 4221926.271715087, 1912277.0684397935 4221895.965056663, 1912277.4153272046 4221861.713402035, 1912277.6155946576 4221841.185950242, 1912277.5896382527 4221829.142146607, 1912277.836468405 4221796.205716163, 1912277.7636337474 4221794.100029819, 1912276.956016177 4221783.195280699, 1912272.3411068493 4221729.827121593, 1912267.6032689288 4221675.243167025, 1912266.1676001656 4221661.097461816, 1912263.9365501471 4221638.800338616, 1912261.7284012511 4221613.352781636, 1912258.0092043825 4221572.309601094, 1912257.1846357072 4221556.436223192, 1912251.4433472187 4221445.817377669, 1912246.6107130307 4221343.560740181, 1912252.5421639169 4221335.197558593, 1912252.812330775 4221334.9538906105, 1912244.7796255075 4221294.191249996, 1912238.1707604302 4221262.671294957, 1912238.0650290991 4221262.178671558, 1912235.982986757 4221254.563840032, 1912229.9968117478 4221236.272312754, 1912215.3496862457 4221191.033916993, 1912195.667667018 4221128.679645747, 1912182.8977848599 4221088.711019955, 1912181.7324359303 4221084.699523638, 1912181.3728741389 4221083.4844418345, 1912180.5989137478 4221081.700365349, 1912177.7848752465 4221074.501401832, 1912176.0531353427 4221070.390640434, 1912175.5796379028 4221069.273528361, 1912175.234910394 4221068.481006068, 1912174.4954441637 4221066.784366583, 1912174.3639019814 4221066.482551238, 1912172.9564450711 4221063.253369686, 1912172.8547279544 4221063.030206766, 1912171.129984278 4221059.282215992, 1912167.9800228272 4221053.642032563, 1912165.478692708 4221049.2033727905, 1912143.071014968 4221007.615321465, 1912137.2634776123 4220996.614920198, 1912132.7336128124 4220987.69798891, 1912132.480813744 4220987.227100271, 1912130.7151136992 4220983.914335664, 1912124.554207323 4220971.035895448, 1912123.9180912003 4220969.706010744, 1912121.4629834269 4220964.350668145, 1912117.7633428627 4220955.358192682, 1912114.428839305 4220946.531439319, 1912097.278514173 4220899.216713032, 1912088.3937499812 4220874.822499938, 1912067.2842813833 4220820.9580313675, 1912066.4208131132 4220818.7664469965, 1912064.664899948 4220814.292585407, 1912059.7846874283 4220801.913305, 1912054.7192752939 4220789.602924442, 1912048.6195632736 4220774.480829962, 1912040.6214448074 4220754.53612322, 1912039.1205853692 4220750.717160816, 1912038.7864303556 4220749.86678362, 1912038.0898782173 4220748.155837967, 1912033.9760760944 4220738.161077298, 1912033.159111367 4220736.294016155, 1912032.5247568716 4220734.837110258, 1912031.5636640526 4220732.657424, 1912029.8987318072 4220728.948732972, 1912028.7270032861 4220726.342249441, 1912028.5376181132 4220725.920561106, 1912028.4811534914 4220725.803212313, 1912025.5057301167 4220719.59768713, 1912021.6304513072 4220712.026274308, 1912019.0803313933 4220707.390162625, 1912016.2768826 4220702.696867401, 1912009.442314581 4220691.581917612, 1912005.6907159723 4220685.6159005575, 1911997.4509914152 4220672.805696757, 1911993.1226762806 4220666.557130027, 1911992.5375553966 4220665.710514704, 1911989.6407017633 4220661.720101861, 1911984.2897705561 4220654.487488053, 1911980.5246119301 4220649.386033327, 1911978.1075704745 4220646.409040682, 1911977.8275753777 4220646.06514414, 1911974.595511169 4220642.424549967, 1911971.2372086034 4220638.766130384, 1911968.3857638254 4220635.883809885, 1911964.130029047 4220631.614417332, 1911962.5385458553 4220630.0470042955, 1911957.4265585234 4220625.2665362675, 1911953.1139849995 4220621.290379592, 1911946.3508046241 4220615.787960475, 1911939.5921885287 4220610.33321113, 1911936.895800012 4220608.266350791, 1911935.7931561677 4220607.443437625, 1911929.1275910812 4220602.480086004, 1911924.3466997487 4220598.95039805, 1911920.5241501457 4220596.312825231, 1911918.8887285173 4220595.181792396, 1911913.7722730427 4220591.413769501, 1911911.4050192668 4220589.665748898, 1911905.514453699 4220585.123049168, 1911897.8742550272 4220579.427936087, 1911892.0117795987 4220574.9809832, 1911885.604886436 4220570.052497846, 1911884.945059218 4220569.510735041, 1911882.8216007499 4220567.766616199, 1911882.153164162 4220567.218103534, 1911881.8329082804 4220566.974836019, 1911880.652995114 4220566.080810094, 1911880.100470935 4220565.587438423, 1911878.893046527 4220564.517808667, 1911876.5700230056 4220562.103443756, 1911872.113210917 4220557.529833157, 1911869.1319988067 4220553.985527034, 1911867.9665113867 4220552.551620866, 1911864.5399742015 4220547.8209574595, 1911862.6050340482 4220545.076861911, 1911852.4073800996 4220529.995173777, 1911838.7013554855 4220509.729036203, 1911838.01341546 4220508.722040303, 1911836.38634023 4220506.341530951, 1911830.3205772536 4220497.370384359, 1911826.669258398 4220491.885832743, 1911823.2954134499 4220486.666970272, 1911822.6695002124 4220485.638548485, 1911822.0123695051 4220484.562881206, 1911817.6257059618 4220476.891169829, 1911817.6067861964 4220476.858067115, 1911816.4508451496 4220474.836200653, 1911816.2349940643 4220474.460343931, 1911810.374699864 4220464.192477756, 1911805.2589504586 4220455.191267567, 1911798.9133809246 4220443.9655092135, 1911786.7792155985 4220422.533577924, 1911774.0616700582 4220400.113202511, 1911767.8728838626 4220389.252180673, 1911763.605552651 4220381.867521397, 1911759.966005562 4220375.529605868, 1911758.8830196953 4220373.6334714815, 1911756.6102138893 4220369.6328213615, 1911754.0943148904 4220365.20911767, 1911752.2661430286 4220361.995368168, 1911749.3751617265 4220356.927902751, 1911744.8224847806 4220348.9484688705, 1911744.3524966496 4220348.118312002, 1911743.8412975664 4220347.210573503, 1911737.3416216515 4220335.669882428, 1911736.3228019287 4220333.8616684405, 1911735.5099236907 4220332.4862097055, 1911733.4447097497 4220329.029173058, 1911732.588459136 4220327.595112261, 1911732.2747143225 4220327.041870356, 1911730.8354657125 4220324.511701582, 1911728.5163471864 4220320.28101367, 1911727.6370233928 4220318.683402436, 1911726.8227855142 4220317.074540388, 1911726.1032232787 4220315.658707302, 1911724.1939555148 4220311.665275155, 1911718.4297682925 4220300.0187607985, 1911711.8510222991 4220285.612976885, 1911709.6352935275 4220280.0825708425, 1911694.1943579125 4220241.6789159225, 1911684.087844979 4220216.198737108, 1911672.2039650888 4220186.610508599, 1911667.3876660448 4220174.62882743, 1911664.2169716426 4220166.738717755, 1911663.1220000095 4220164.025052525, 1911659.4603480669 4220154.958674527, 1911655.085186346 4220144.066834133, 1911649.9543392102 4220131.203732944, 1911647.5569678636 4220125.188638477, 1911645.527012921 4220120.048083075, 1911636.6512756397 4220097.6032691775, 1911621.2713629846 4220059.583195614, 1911620.094767214 4220056.567611331, 1911615.5791805726 4220044.938509486, 1911615.3076665967 4220043.97067436, 1911614.837295802 4220041.977721642, 1911612.6303587789 4220032.617521234, 1911612.3677692665 4220031.490888763, 1911612.282350319 4220031.102247593, 1911610.9784216506 4220025.173769829, 1911609.167490682 4220016.967942263, 1911608.8684730027 4220015.644083623, 1911608.5747812695 4220014.361380162, 1911606.845907332 4220006.747132222, 1911604.4627161277 4219996.667223422, 1911604.2328358504 4219995.652107184, 1911599.4753587642 4219974.777389477, 1911596.7234253208 4219962.570494982, 1911594.1463259486 4219950.928587954, 1911592.7911769385 4219944.78771431, 1911591.8682339957 4219940.6022276115, 1911591.6775833522 4219939.625556588, 1911588.9614236788 4219922.959839732, 1911582.2578112138 4219882.0638031345, 1911580.1455426118 4219869.193640118, 1911575.8798016757 4219843.24232588, 1911575.5623153832 4219841.237937092, 1911574.8801283557 4219836.919965507, 1911569.6690985865 4219803.260398372, 1911567.2122770322 4219787.5114316745, 1911567.10591653 4219787.023556811, 1911566.1594103994 4219783.413873626, 1911563.5782922495 4219773.649389502, 1911560.5138038131 4219762.023900786, 1911558.7994721655 4219755.433689912, 1911558.7080503094 4219755.081853738, 1911554.1920918582 4219737.71479364, 1911549.9441030882 4219721.685471948, 1911537.508378222 4219674.142812743, 1911523.3126809995 4219618.240620901, 1911512.7845374742 4219577.024737963, 1911487.7722848614 4219563.970355771, 1911458.4282316102 4219548.605929264, 1911458.4125245858 4219548.597707826, 1911458.4116525059 4219548.597251211, 1911458.4075329849 4219548.5950958645, 1911458.3831779119 4219548.582354173, 1911457.807703389 4219548.281319279, 1911457.001525177 4219547.8594690915, 1911456.9579117158 4219547.83411166, 1911456.5525183144 4219547.621301195, 1911452.0883252244 4219534.555233788, 1911451.391843207 4219532.289074078, 1911450.3236568265 4219528.652657947, 1911449.1471978708 4219524.717008567, 1911445.0291549398 4219511.452877122, 1911444.1195097994 4219508.407280797, 1911443.4559839899 4219505.948006858, 1911442.7190398653 4219503.224439099, 1911442.6828082143 4219503.089965687, 1911440.5835145258 4219494.769266352, 1911438.2433704454 4219484.611518219, 1911436.5158763267 4219476.628420633, 1911436.2223367277 4219475.146319977, 1911435.5313314188 4219471.507995585, 1911434.4101972443 4219465.129830553, 1911433.67014332 4219461.005010861, 1911432.8935716276 4219456.255198211, 1911431.388905033 4219446.928261542, 1911430.131180815 4219439.133631116, 1911424.2548890787 4219400.584317406, 1911419.155342687 4219401.438327741, 1911417.2656432875 4219401.758459874, 1911399.6067170198 4219403.82532482, 1911279.316985543 4219418.111728061, 1911265.4650920148 4219425.686883814, 1911261.0843675192 4219428.270286317, 1911159.9471655686 4219445.310530978, 1911042.8785229377 4219465.447908647, 1910954.9864960946 4219480.171355699, 1910790.3182349487 4219407.615583573, 1910635.262038581 4219430.384398671, 1910635.1158388231 4219428.873667839, 1910621.0614055602 4219430.953458173, 1910410.0422950282 4219461.976592282, 1910401.9055782168 4219463.238804053, 1910404.6322523027 4219467.885733908, 1910093.0945551752 4219509.337969594, 1909823.3317870563 4219544.204143024, 1909555.5377763147 4219578.261368488, 1909544.808810848 4219581.210717673, 1909533.858121462 4219584.0930213, 1909402.2398568417 4219618.767622331, 1909152.195 4219680.22, 1908969.5227654888 4219727.930969549, 1908739.1277147378 4219783.207183759, 1908219.5782388665 4219741.361012146, 1908139.2703202716 4219748.040975251, 1908078.3 4219765.88, 1908062.76 4219770.43, 1907853.25 4219831.96, 1907735.52 4219866.62, 1907649.04 4219891.6, 1907600.71 4219906.14, 1907559.84 4219918.1, 1907560.89 4219920.37, 1907566.14 4219934.21, 1907567.21 4219948.41, 1907531.68 4219971.34, 1907516.83 4219980.51, 1907503 4220009.84, 1907491.34 4220033.87, 1907489.4 4220043.96, 1907482.5 4220082.3, 1907472.82 4220131.27, 1907470.72 4220141.52, 1907463.13 4220155.54, 1907447.36 4220184.37, 1907435.29 4220206.62, 1907426.81 4220234.76, 1907418.34 4220263.27, 1907428.04 4220330.31, 1907437.09 4220394.63, 1907443.25 4220433.71, 1907443.3304755136 4220434.719166946, 1907502.5552760651 4220436.527671341, 1907625.10854251 4220440.2316194335, 1907737.924291498 4220443.809878543, 1907805.68 4220445.977246963, 1907975.131417004 4220451.568663967, 1908005.0896356276 4220452.645425102, 1908046.0317813766 4220454.109676113, 1908211.22 4220459.307206478, 1908358.6317813764 4220464.083441296, 1908709.5957085022 4220475.201376518, 1908714.4386546977 4220475.354405748, 1908727.041321694 4220579.58332101, 1908732.913430379 4220579.907790627, 1908734.8594718352 4220583.241284623, 1908740.820129119 4220583.834751228, 1908721.4613066174 4220638.949519773, 1908753.9118179986 4220661.063797846, 1908762.219757168 4220664.295283934, 1908795.8129801385 4220677.526560442, 1908813.659007753 4220682.32567943, 1908823.9780108694 4220685.316740148, 1908877.9106657403 4220714.007793631, 1908883.296662141 4220717.261355724, 1908883.8451328797 4220723.468119984, 1908862.8963120608 4220729.9727342, 1908851.5367000594 4220730.845920558, 1908841.0894197272 4220730.769864638, 1908809.641552677 4220730.574386212, 1908794.4307177055 4220733.661118553, 1908809.8045802137 4220750.346974635, 1908824.013360874 4220781.029704505, 1908861.4522345108 4220835.128153308, 1908910.0323875705 4220952.237407889, 1908909.07768022 4221013.827247175, 1908883.921562197 4221014.41313372, 1908877.7854850215 4221050.372428695, 1908884.5233086064 4221058.72562843, 1908891.3544030546 4221067.328150757, 1908915.6262663407 4221083.627390035, 1908923.0654915096 4221088.357186522, 1908916.7576639866 4221114.40596955, 1908908.0466436858 4221149.730969549, 1908882.4301091577 4221214.948141874, 1908946.9671926436 4221290.058159852, 1909053.8041624401 4221319.357160204, 1909060.0642377539 4221350.924007368, 1909061.9295580348 4221386.046156368, 1909063.7524612762 4221417.631122534, 1909064.2033590435 4221417.39788102, 1909064.431657691 4221420.542510777, 1909220.8490156475 4221331.449097403, 1909227.0944238298 4221327.960042553, 1909239.0350417492 4221324.084751584, 1909279.0524745863 4221315.526539191, 1909360.2231528903 4221406.512029549, 1909362.5240800618 4221405.800215626, 1909365.9933801482 4221404.726954319, 1909368.050777579 4221404.021694975, 1909409.5520557603 4221388.64538167, 1909423.924965404 4221383.038045771, 1909423.9718505892 4221384.759309855, 1909424.2834097252 4221396.126850122, 1909424.1599839625 4221402.57604878, 1909423.850973596 4221417.830696149, 1909422.8244804572 4221433.680298251, 1909420.5392417589 4221460.768219934, 1909418.8573789783 4221477.559205501, 1909419.5071958706 4221480.464739599, 1909418.1836071657 4221495.411835009, 1909434.7285740871 4221490.146526985, 1909453.924213325 4221484.1921261195, 1909455.0811044096 4221483.668373394, 1909473.5419306636 4221471.204931688, 1909476.1093790336 4221469.505246113, 1909477.294908506 4221468.848934997, 1909479.1067525698 4221468.117112843, 1909503.1853975735 4221458.440122523, 1909526.269596562 4221446.249367461, 1909527.1660134895 4221446.019327067, 1909529.4031568808 4221445.369009251, 1909535.797515835 4221445.917647065, 1909549.4217755073 4221447.130749965, 1909560.489868421 4221468.477722673, 1909564.9485283238 4221477.916832983, 1909565.6410967384 4221479.232412824, 1909574.1537454438 4221494.368632607, 1909582.9013737033 4221508.085030336, 1909603.3567249554 4221539.577030706, 1909604.2773683716 4221539.23694228, 1909604.5668645084 4221539.67807925, 1909618.8794633276 4221536.4143966315, 1909624.0007267385 4221535.166009475, 1909626.3612818373 4221535.036781365, 1909627.4977999674 4221534.985980532, 1909629.335289397 4221535.294994483, 1909633.2245550521 4221535.909902891, 1909644.3880101503 4221538.368785789, 1909650.777854251 4221539.536842105, 1909658.247903216 4221540.046867162, 1909663.077806872 4221539.892478873, 1909669.0303025981 4221539.459653194, 1909673.616265657 4221546.543513728, 1909675.8431807996 4221546.30291173, 1909676.0928236344 4221546.730011519, 1909730.9802246352 4221540.336278832, 1909754.743976495 4221537.384901261, 1909766.8827508665 4221534.240819454, 1909788.3850372816 4221533.153719455, 1909792.5274238728 4221532.6319841705, 1909828.1474093047 4221530.023179223, 1909846.8221301304 4221525.492782566, 1909885.57994284 4221534.939286223, 1909894.2864665529 4221539.698824178, 1909897.6619060584 4221548.130296949, 1909898.2943051583 4221549.649931509, 1909898.0218707644 4221551.963434626, 1909895.8619028847 4221559.958988169, 1909893.6678465195 4221567.015712588, 1909892.5151261422 4221570.950289537, 1909891.4295890196 4221574.671244268, 1909889.6195401684 4221580.855190007, 1909888.4041268704 4221585.0128721, 1909886.4496265762 4221591.669593459, 1909885.7191535393 4221593.9243839495, 1909879.522545945 4221613.544948808, 1909877.196751092 4221621.071422813, 1909875.1223792885 4221626.151329951, 1909871.4084016148 4221634.1207819, 1909864.9378706382 4221647.58113498, 1909861.4759968098 4221655.426464061, 1909856.8158704222 4221665.923702432, 1909852.4993604654 4221676.499307246, 1909852.0270698816 4221679.2274233755, 1909851.2676717287 4221683.939396246, 1909850.6097773279 4221701.403036438, 1909849.530911412 4221711.913249575, 1909849.3423851782 4221717.304357765, 1909852.1608741002 4221737.052667504, 1909852.4864710404 4221739.540995598, 1909852.4042589369 4221739.959396483, 1909855.0121185621 4221737.233718648, 1909862.5714776835 4221728.456613367, 1909873.9395980423 4221715.548813932, 1909877.5504340234 4221711.501948194, 1909886.727716336 4221707.602367728, 1909901.6170940027 4221700.293016845, 1909913.87335335 4221691.865584718, 1909917.811417004 4221687.958906882, 1909938.05290847 4221675.078116016, 1909945.2738298976 4221669.472230329, 1909956.5659190302 4221659.361369158, 1909981.3593675194 4221629.41198985, 1909991 4221621.17, 1909997.9272850628 4221619.20025826, 1910005.7510931173 4221617.9444008665, 1910011.2207383935 4221617.89923708, 1910074.5336210064 4221634.47377443, 1910120.98483177 4221647.158193551, 1910125.941857762 4221647.924838421, 1910136.6187226695 4221648.269713517, 1910141.62 4221648.01, 1910146.9969462005 4221647.6276389295, 1910171.9538276359 4221643.9875259325, 1910172.46 4221644.33, 1910173.5847716439 4221645.560732499, 1910174.4629888115 4221645.475307596, 1910192.944283691 4221665.422096362, 1910193.544479854 4221664.827937379, 1910195.0785832459 4221666.467116345, 1910245.3716385826 4221616.880072088, 1910255.8294801952 4221606.903616562, 1910352.1631442134 4221604.884877161, 1910436.5163482735 4221621.343153309, 1910508.3780828652 4221628.890976072, 1910530.594866649 4221643.623421121, 1910543.6681071052 4221652.9561634585, 1910559.501428562 4221666.173669073, 1910576.5742243605 4221680.824076654, 1910590.2531501164 4221693.807196125, 1910605.7945287332 4221709.952715103, 1910610.6662873924 4221715.346062046, 1910613.48170256 4221718.623977182, 1910621.21053107 4221729.42543819, 1910622.7817481298 4221732.186794708, 1910623.1498025928 4221733.381096052, 1910625.0237505138 4221739.869653877, 1910626.1129938378 4221746.3525171345, 1910626.7119398485 4221749.943289343, 1910627.836341925 4221753.607849353, 1910628.7506804185 4221755.993799004, 1910629.7907894738 4221757.728334765, 1910633.9138674824 4221761.739824918, 1910641.8941105471 4221767.3112481395, 1910650.4126389406 4221773.707738312, 1910653.5983404457 4221776.468499185, 1910659.1218638693 4221781.219827286, 1910661.751672502 4221784.154087202, 1910665.2865235654 4221788.435624812, 1910666.510573705 4221790.39012749, 1910667.461346892 4221791.911826199, 1910668.9510179395 4221794.863162651, 1910669.2718225464 4221795.594756299, 1910670.4935297682 4221799.027979833, 1910671.1990995633 4221801.130937079, 1910671.6625183732 4221801.588873051, 1910675.1628002007 4221805.114585393, 1910697.6707294357 4221813.728684287, 1910716.360974097 4221818.807760941, 1910803.7509695492 4221838.71154673, 1910852.965244661 4221850.228601933, 1910895.207544525 4221860.901532896, 1910903.202660431 4221841.498674465, 1910904.0339271254 4221838.867532895, 1910904.1176968638 4221838.6877772445, 1910905.8129738073 4221835.080087465, 1910906.8472988275 4221832.286031202, 1910908.7769274344 4221827.032263605, 1910910.5944084805 4221822.833988939, 1910914.5884319085 4221814.315633229, 1910915.1822170217 4221813.096700044, 1910917.801323911 4221807.72763353, 1910919.9057682478 4221803.017522696, 1910920.7856138565 4221800.469942264, 1910921.4010785068 4221798.736862431, 1910922.95 4221792.26, 1910923.4867560093 4221790.537950115, 1910924.1612210723 4221788.65961513, 1910926.3419246548 4221785.233263708, 1910932.620821843 4221774.977798049, 1910933.41702577 4221778.278947967, 1910935.4423736918 4221789.708138258, 1910943.2626012214 4221823.963439583, 1910946.0501544294 4221835.128357713, 1910949.362125583 4221850.110550762, 1910951.28752716 4221859.072803, 1910963.718961241 4221855.237194984, 1911025.4904562205 4221837.009450092, 1911075.0093141866 4221817.602151907, 1911135.3563325782 4221794.067921868, 1911230.654678224 4221757.502418711, 1911237.521513959 4221754.911770938, 1911242.1083497796 4221762.158148779, 1911245.8243785533 4221768.178725456, 1911253.8434284783 4221780.679092753, 1911260.2933727861 4221789.473555401, 1911260.9657618282 4221790.636663557, 1911262.2044454492 4221794.123281479, 1911265.507770678 4221802.6915083015, 1911268.1708515089 4221806.398348705, 1911271.3873477534 4221811.440553056, 1911273.8093221285 4221818.721654262, 1911276.3812380116 4221824.254170507, 1911277.1208138433 4221825.616663773, 1911278.610991903 4221828.332540485, 1911281.1773521353 4221834.847584179, 1911282.220456601 4221837.611532288, 1911282.4381556455 4221838.188438419, 1911282.578365042 4221838.495439953, 1911283.4590872843 4221840.425959034, 1911293.3180361113 4221859.586436619, 1911295.2686689901 4221863.514620773, 1911298.3322845756 4221869.803775194, 1911302.2134384555 4221878.593324258, 1911304.464629936 4221883.679960714, 1911307.4180566804 4221890.592044534, 1911311.7665288397 4221899.901439861, 1911313.4952521406 4221903.594201583, 1911320.6451716844 4221919.104850923, 1911327.1077185182 4221933.196353148, 1911336.8584014724 4221954.330353492, 1911344.0729949551 4221969.44424831, 1911347.6961954492 4221976.970861703, 1911352.856818762 4221987.688304709, 1911356.3391499703 4221995.455082079, 1911369.0367035356 4222023.8993107695, 1911372.0264515318 4222030.386571022, 1911375.2204338415 4222037.312588885, 1911375.6800218679 4222038.684950237, 1911376.7849292243 4222042.2641818, 1911377.6813699552 4222048.999952556, 1911377.8309682675 4222051.204180131, 1911378.551156874 4222052.856984735, 1911379.9812365246 4222055.0313950535, 1911380.2480499523 4222055.3080766, 1911380.5224246788 4222055.469110393, 1911381.325973154 4222055.846912752, 1911381.4704101186 4222055.915662253, 1911382.5984210626 4222056.336315793, 1911382.9075217855 4222056.452005168, 1911382.9485500068 4222056.473428181, 1911385.1457913767 4222057.647239346, 1911386.3381028355 4222058.537950576, 1911387.4962799312 4222059.44501098, 1911388.2373460827 4222060.164509764, 1911391.393509661 4222063.07891522, 1911392.942599795 4222064.968518332, 1911396.9041710356 4222069.749424082, 1911398.560587976 4222071.731492821, 1911398.9078843277 4222072.103348602, 1911400.3930706985 4222073.47020705, 1911401.8940330767 4222074.84941107, 1911402.399878226 4222075.307186439, 1911402.7956524992 4222075.667552771, 1911403.0690963205 4222075.8887077, 1911403.4572883856 4222076.207287064, 1911404.3721852119 4222076.850942321, 1911406.3327087394 4222078.240996164, 1911407.158294987 4222078.795385474, 1911409.1889399632 4222079.885917732, 1911411.7894118526 4222081.231768203, 1911415.0296264717 4222083.065488289, 1911415.7794882234 4222083.4880178, 1911418.1802283898 4222084.888088397, 1911419.9379449803 4222085.935299246, 1911422.285384865 4222087.266288697, 1911423.9563400992 4222088.341361559, 1911425.6090051348 4222089.595963973, 1911427.2593347738 4222090.369989055, 1911436.242777013 4222094.579466013, 1911436.4191640378 4222094.634810726, 1911439.5921181082 4222095.272970844, 1911446.9872567698 4222096.827750328, 1911453.6348306693 4222094.916457279, 1911455.631231107 4222094.6101690885, 1911457.57 4222094.371153847, 1911458.9143490244 4222094.387869507, 1911461.9500706072 4222094.9400348, 1911462.8926969133 4222095.143991085, 1911464.7548860887 4222095.62359742, 1911471.4391975706 4222092.716413118, 1911480.657545686 4222090.049191558, 1911485.997894172 4222093.599903468, 1911494.2460675733 4222095.516447696, 1911499.695182186 4222099.426336032, 1911503.5283666404 4222103.710014895, 1911506.5212039046 4222107.064146472, 1911507.065103187 4222107.730138251, 1911508.6992965324 4222109.782996154, 1911509.4665527057 4222111.086151334, 1911509.9567224705 4222112.033684403, 1911510.747731342 4222113.816699405, 1911515.0235134761 4222126.107035482, 1911518.6942235285 4222135.968979409, 1911519.9407572064 4222139.34788409, 1911520.72758266 4222142.025977162, 1911522.6520430907 4222148.749920289, 1911523.2542872385 4222150.450064374, 1911525.0242678733 4222155.0297315, 1911526.282165699 4222158.464760178, 1911527.9124017386 4222163.436087614, 1911529.7099555582 4222169.935177463, 1911530.382024316 4222172.578330486, 1911530.4781741935 4222172.959978419, 1911530.9269000606 4222174.962551359, 1911532.1906343654 4222180.550529784, 1911533.0371839667 4222184.8629656015, 1911534.208316833 4222191.035973786, 1911535.9074412668 4222199.184231525, 1911536.391796264 4222201.508067899, 1911536.577571116 4222202.522691466, 1911537.4667604056 4222206.4795838045, 1911537.7172879693 4222207.350624737, 1911538.8177118045 4222211.054861235, 1911542.937762597 4222224.917054705, 1911544.0267070273 4222227.831176296, 1911560.3344059961 4222255.821677311, 1911573.7601410889 4222279.0159742655, 1911577.3555746316 4222285.705201992, 1911585.7538185145 4222301.925598072, 1911593.176584978 4222316.866297287, 1911595.5723304655 4222321.66638664, 1911599.4856276254 4222329.369356958, 1911605.6042571652 4222339.4958213335, 1911621.226110433 4222359.4075059565, 1911628.6452156997 4222368.321448534, 1911632.773415525 4222373.316017836, 1911638.4293512001 4222380.58864391, 1911641.1337315314 4222384.12986198, 1911644.904312703 4222389.15051734, 1911645.4911598735 4222389.991214564, 1911647.429637787 4222392.750433217, 1911651.2545012073 4222398.129005674, 1911664.9464439554 4222417.095249789, 1911668.5264886136 4222421.839832232, 1911671.2491558418 4222425.017628049, 1911675.2666903508 4222429.883274461, 1911683.019897476 4222437.435478992, 1911691.0528679234 4222444.537172831, 1911731.4861950607 4222478.824915863, 1911746.7381782287 4222491.560684351, 1911758.7451759109 4222501.427015304, 1911768.7563184244 4222509.381459978, 1911787.8000608068 4222524.342993997, 1911791.5297551109 4222527.211614229, 1911799.2660355843 4222533.081773122, 1911814.9200812841 4222544.150069142, 1911822.3943789776 4222548.67277947, 1911831.5626720649 4222553.641194332, 1911850.9948178139 4222562.722489879, 1911893.2288047518 4222582.168220544, 1911895.6663148964 4222583.28823311, 1911900.315131125 4222585.517600533, 1911905.714913863 4222588.079110786, 1911914.3059619984 4222592.1579377735, 1911915.3519166189 4222592.629991589, 1911922.9112286407 4222595.993604444, 1911927.6972048231 4222597.901009296, 1911943.5833486002 4222604.183050636, 1912002.395426521 4222629.222157109, 1912072.6505259154 4222659.893677663, 1912101.972071077 4222672.96923076, 1912123.7856680162 4222683.465870445, 1912149.9297101758 4222696.125004989, 1912172.4988335373 4222707.223760944, 1912191.0249595144 4222716.949449182, 1912202.1900316018 4222722.713760558, 1912234.7901487723 4222739.1267397115, 1912268.7584263084 4222756.584961728, 1912268.764724041 4222756.223768237, 1912268.842403483 4222756.2645295635, 1912269.0677721032 4222737.204006942, 1912269.320870589 4222718.430011724, 1912269.8834018763 4222671.2587482035, 1912271.459482713 4222571.5925463615, 1912273.291332099 4222413.785923346, 1912274.382714645 4222264.07281977, 1912274.4320787296 4222254.920544985, 1912274.8253067213 4222231.816174501, 1912274.9287444942 4222224.9868569365, 1912275.0627591694 4222213.181870741))'::geometry,'38486','Seyssins','SEYSSINS','SEY','SEY'),
     (6,'SRID=3945;POLYGON ((1915119.5918892974 4229184.15879704, 1915118.8133498968 4229185.050267959, 1915119.2 4229186.03, 1915121.5256434132 4229186.152757107, 1915126.4877217629 4229185.742315837, 1915127.8138880779 4229185.586371071, 1915128.598182005 4229186.138208205, 1915130.5838586541 4229185.9450418735, 1915133.0649999962 4229186.614999994, 1915163.9983250934 4229209.741167216, 1915181.2709105818 4229254.027170825, 1915210.8925414507 4229320.081338224, 1915229.1900000381 4229359.199999998, 1915235.5250000167 4229387.404999999, 1915251.065000018 4229410.665000003, 1915265.1850000187 4229432.054999979, 1915273.2900000021 4229453.10499994, 1915277.0977802507 4229476.142667334, 1915309.8564589787 4229557.168729014, 1915329.5900000136 4229580.5325, 1915393.122499999 4229648.790000001, 1915417.820000015 4229672.537499992, 1915425.7275000063 4229685.24249998, 1915427.2210891345 4229691.324032104, 1915426.698759669 4229705.592488993, 1915426.8622820296 4229724.687682526, 1915428.2548117978 4229726.125898927, 1915430.115464345 4229728.6045054225, 1915502.1678340065 4229719.732499972, 1915577.713749813 4229662.971739152, 1915797.3192814041 4229581.383805688, 1915798.486955611 4229580.523381596, 1915798.7720040828 4229580.332720018, 1915788.5499033309 4229570.140696724, 1915771.1335728937 4229553.287535634, 1915765.9556740033 4229548.832060335, 1915748.4457096169 4229535.205687364, 1915726.1597693735 4229517.862617608, 1915725.592164711 4229517.420903812, 1915803.8498886814 4229470.57065032, 1915811.89 4229464.34, 1915851.45 4229434.2, 1915882.11 4229399.91, 1915888.3439701023 4229365.816664632, 1915895.48 4229326.79, 1915902.71 4229326.87, 1915900.870563172 4229317.652734632, 1915898.0818093515 4229303.687322158, 1915893.3636384127 4229280.907084736, 1915885.404611975 4229242.478290408, 1915877.3750919031 4229203.664272243, 1915874.101602382 4229187.388433423, 1915870.9630375518 4229171.80897199, 1915865.3028683017 4229143.772236633, 1915859.9 4229117.01, 1915860.3903567693 4229114.920997975, 1915856.8807818927 4229101.331357322, 1915853.0302133856 4229077.825923022, 1915851.648393376 4229064.458227066, 1915850.5913392184 4229043.393778682, 1915850.7695720312 4229042.4790174505, 1915851.5736842128 4229038.313461533, 1915864.076423677 4229035.676543325, 1915868.983942318 4229034.051973683, 1915880.9549999968 4229026.4624999985, 1915901.3566242668 4229011.319951434, 1915914.745712665 4229000.233889701, 1915925.4551581817 4228994.610190116, 1915950.9058267577 4228985.379894807, 1915963.8830996628 4228974.853137717, 1915975.132304808 4228973.198175277, 1915992.9040332753 4228963.35932999, 1916007.3318196812 4228954.406143269, 1916020.755039686 4228940.111281174, 1916030.7347489793 4228923.896177176, 1916034.3949224642 4228916.395111371, 1916035.3035448808 4228914.0311115, 1916038.1945748988 4228906.136821862, 1916038.3873736432 4228900.035338904, 1916039.0398960605 4228897.086718689, 1916045.0033198392 4228888.641199391, 1916048.2302036094 4228883.504250621, 1916051.7854746683 4228876.141328576, 1916056.70421191 4228861.232303253, 1916064.492708714 4228849.626488515, 1916067.16446356 4228826.064726728, 1916071.600916073 4228819.452983109, 1916074.6534754797 4228807.199360342, 1916075.7674762825 4228803.014799049, 1916076.1762626106 4228801.988255276, 1916081.4340267594 4228792.163352173, 1916089.4737659523 4228781.369121868, 1916096.7761230485 4228771.977509833, 1916100.5051779165 4228761.359527416, 1916100.845819017 4228753.110043545, 1916101.2943835666 4228748.677389966, 1916105.7875418628 4228737.026287422, 1916107.7716939065 4228727.418818728, 1916108.6862758566 4228723.003270735, 1916108.9188200003 4228722.124657999, 1916109.1757142853 4228721.328285716, 1916109.8183951103 4228719.584211068, 1916111.2843373506 4228716.267590359, 1916112.66043956 4228712.9649450565, 1916113.7455916922 4228709.62941949, 1916111.5552923728 4228702.176683649, 1916111.3674033408 4228700.132671191, 1916111.34888285 4228699.978000689, 1916111.2437455954 4228697.572674361, 1916112.994783838 4228689.153676769, 1916113.3958881672 4228687.218087045, 1916116.9166753958 4228684.209974732, 1916120.049723872 4228681.597747551, 1916120.9623694145 4228680.1945100585, 1916121.345197982 4228679.619451556, 1916121.8053962665 4228676.99722443, 1916121.7016933425 4228672.822111898, 1916119.9971759964 4228661.0859548915, 1916119.1909701808 4228656.940448312, 1916119.0163167766 4228656.252812909, 1916118.3697429544 4228654.279747398, 1916117.389597102 4228652.21259411, 1916111.8895289265 4228640.328365002, 1916111.0199960375 4228637.587819487, 1916108.9719215445 4228630.880240938, 1916105.5352782796 4228619.946342727, 1916105.1952977353 4228617.598406642, 1916102.434867221 4228599.870491029, 1916105.283078575 4228577.164297717, 1916104.4797935039 4228571.813010293, 1916101.7647842327 4228557.086301573, 1916100.6883040806 4228547.4110356085, 1916099.6891233597 4228531.241657848, 1916105.3724320168 4228524.5319763925, 1916107.7947686305 4228518.637054175, 1916108.8630881538 4228516.536998319, 1916109.888576939 4228514.584826837, 1916111.8413171736 4228510.914901161, 1916117.566321815 4228501.043789917, 1916125.0937233188 4228488.792979955, 1916126.5326070117 4228486.144958438, 1916130.5110191368 4228478.037984825, 1916134.918834235 4228469.905863012, 1916140.247588707 4228459.734992937, 1916145.4611087046 4228451.753818559, 1916152.8707475483 4228445.04935842, 1916156.1865156956 4228437.125405088, 1916156.3178179802 4228436.66327654, 1916155.5118896877 4228430.117843035, 1916154.2506767923 4228424.219081664, 1916155.1317136784 4228419.140450105, 1916157.060756317 4228414.961079925, 1916159.6888134766 4228411.605047594, 1916162.0397054974 4228408.705758625, 1916173.4187499871 4228388.543750009, 1916183.1388845574 4228365.733196403, 1916184.949783614 4228360.330283757, 1916186.2662249573 4228354.638543775, 1916189.0415494232 4228349.005990161, 1916190.7456012585 4228345.540098993, 1916191.216189677 4228342.96867394, 1916191.376292199 4228338.03237699, 1916193.73768726 4228322.54385629, 1916200.6903933382 4228314.941651991, 1916200.8009238618 4228314.714349919, 1916200.726556589 4228310.597188342, 1916200.2771326501 4228308.129815705, 1916199.3253667152 4228302.07954174, 1916199.832349402 4228300.798388457, 1916202.3754706678 4228297.179903864, 1916202.9075180467 4228294.251798243, 1916201.5842740496 4228286.134787983, 1916203.088525427 4228283.395071282, 1916204.6181459874 4228280.78272228, 1916205.1094388457 4228277.532207279, 1916205.7050328443 4228272.3289046325, 1916203.870520883 4228266.866244512, 1916203.276450225 4228264.623214974, 1916203.1158520745 4228262.387519668, 1916203.1826814017 4228260.710817492, 1916203.6704342975 4228255.278827483, 1916204.0857494748 4228242.392612744, 1916203.8376605695 4228240.877368338, 1916203.5555072464 4228239.66099196, 1916201.681666623 4228231.624994558, 1916200.9581434277 4228226.772234336, 1916200.8619671396 4228225.589159687, 1916199.8907434796 4228217.79722142, 1916199.3608376742 4228207.120760674, 1916198.8158454779 4228202.2509336, 1916197.5258267429 4228196.843110215, 1916196.9935819316 4228194.870769103, 1916196.4598933903 4228193.207398721, 1916195.2824222737 4228189.565490939, 1916193.9120833904 4228183.9680204475, 1916191.5941786538 4228179.623938745, 1916190.575587371 4228178.219366093, 1916190.1867653516 4228165.45795361, 1916186.6061869739 4228155.219424632, 1916186.4112198583 4228142.308615497, 1916188.3338764322 4228129.063745275, 1916186.7531376684 4228121.076923083, 1916177.232693855 4228108.585079296, 1916163.5250200992 4228096.887817296, 1916156.6212177742 4228087.570997933, 1916155.395170584 4228085.3284265185, 1916154.5137674918 4228081.6355805015, 1916153.8937870471 4228079.029173588, 1916153.5994628784 4228078.547843207, 1916147.262178375 4228069.2988051325, 1916144.7652677305 4228059.422258569, 1916143.9174721355 4228051.701073473, 1916144.3279273822 4228042.169317989, 1916141.2342830473 4228033.81138495, 1916142.9391649798 4228027.019777328, 1916142.3914789723 4228021.81180859, 1916141.4389119432 4228017.823785424, 1916138.9257054788 4228000.863643559, 1916139.105890166 4227996.28096126, 1916138.2373643396 4227988.838471658, 1916138.1400545689 4227988.004613947, 1916138.2192976587 4227985.991839468, 1916138.4074306597 4227983.175703471, 1916138.7708477254 4227980.05986222, 1916139.7832924682 4227971.1404341245, 1916129.2282490109 4227947.905662952, 1916128.6898543867 4227945.574379323, 1916128.5419033733 4227944.935097176, 1916128.6214293442 4227943.931461017, 1916129.5464468068 4227939.757117029, 1916129.5644208295 4227939.669537722, 1916130.4737297813 4227934.290359325, 1916130.0060701333 4227933.239246192, 1916128.3992336905 4227929.935699963, 1916126.6525552266 4227926.916634668, 1916126.2987722731 4227925.399079315, 1916126.091003413 4227924.067612379, 1916125.2815852882 4227900.319256714, 1916125.0323275102 4227894.5267697545, 1916124.7235393145 4227890.205299799, 1916124.2514336046 4227883.370294426, 1916123.87 4227880.72, 1916123.284059317 4227877.37247154, 1916123.1885576865 4227875.82344796, 1916123.4509059829 4227874.553641026, 1916125.0541388988 4227872.069658773, 1916126.5514784162 4227869.391427781, 1916133.0922717333 4227851.617083732, 1916132.6799999974 4227825.898750015, 1916134.097010272 4227813.367199789, 1916139.5362500043 4227800.110000009, 1916138.34250001 4227788.041250008, 1916138.8518927128 4227767.912451923, 1916138.7910968487 4227767.367505142, 1916138.2031832093 4227762.751571358, 1916136.6854954949 4227761.473243243, 1916108.087424853 4227738.852294309, 1916106.5900322762 4227734.208339103, 1916105.0116435 4227729.740211358, 1916102.070980734 4227724.385147061, 1916101.7595853386 4227723.565025122, 1916097.5297173804 4227710.999385428, 1916093.6068515442 4227707.718369128, 1916081.2207850586 4227696.909325899, 1916070.3282862934 4227686.861591978, 1916065.2444244653 4227684.272038788, 1916063.8894921027 4227683.220907165, 1916061.420203133 4227680.629053979, 1916058.9076266477 4227677.013924421, 1916046.482623574 4227654.707253833, 1916043.662076578 4227649.034332993, 1916041.1322482885 4227642.215081588, 1916039.291664254 4227637.615460396, 1916037.3514951572 4227634.678780347, 1916033.2810062193 4227627.6366191385, 1916029.2950000425 4227622.021250013, 1916015.433619703 4227613.097380427, 1916009.131955414 4227604.466301911, 1916007.480037897 4227602.133713714, 1916003.5513477023 4227598.418462135, 1916002.7313048479 4227597.690639856, 1916000.5711311714 4227594.555039318, 1915989.2512500233 4227557.933749983, 1915982.0962500281 4227546.373750006, 1915974.98750003 4227532.126250007, 1915967.153203132 4227511.499175497, 1915957.0900000408 4227501.724999998, 1915941.0097480335 4227495.916580924, 1915919.461817588 4227484.720735012, 1915912.0167322252 4227477.768282613, 1915895.668694059 4227472.223738591, 1915881.136941443 4227474.970489326, 1915880.0559562086 4227471.714234025, 1915876.3005496743 4227461.986272686, 1915876.2190465708 4227456.849104597, 1915876.20916856 4227455.720890916, 1915876.157457453 4227455.541075718, 1915874.0480370985 4227449.41287411, 1915871.6087500255 4227445.212499998, 1915866.4602503928 4227438.828894029, 1915865.380566005 4227437.554902135, 1915862.6926386128 4227435.051983011, 1915861.4594003772 4227434.141705609, 1915852.5807788603 4227427.39631173, 1915850.4150000075 4227422.883749999, 1915850.0892389661 4227414.3616393795, 1915851.7777405719 4227410.802262765, 1915851.8737689138 4227410.67224209, 1915855.4107140594 4227406.406267279, 1915857.75 4227400.85, 1915857.9742483215 4227398.50099883, 1915856.7281855925 4227391.092078473, 1915857.2857663275 4227389.61488021, 1915858.1945000053 4227388.168353443, 1915859.5366970324 4227386.426984119, 1915859.6902842668 4227386.213672262, 1915860.2338581374 4227385.212048392, 1915860.6672773557 4227384.417399752, 1915859.851895065 4227375.11427747, 1915863.048527211 4227366.619771195, 1915861.495979518 4227360.575871576, 1915855.2046773424 4227336.070952712, 1915854.6856315914 4227332.346207522, 1915858.2721245047 4227319.281220759, 1915859.3014870477 4227314.587465741, 1915857.2780205254 4227309.954822086, 1915852.375824909 4227301.426356264, 1915839.0475000115 4227279.208749997, 1915829.5049813502 4227262.661034052, 1915821.3979617297 4227254.907635847, 1915820.1298059854 4227253.627723308, 1915813.006599197 4227246.159352232, 1915812.7258268204 4227244.475578613, 1915823.2162905072 4227225.78183705, 1915823.8102101379 4227223.106775364, 1915816.39148144 4227206.384918799, 1915809.4822803976 4227187.901993179, 1915807.885917966 4227184.319819222, 1915807.0965694967 4227182.55431405, 1915805.8000180337 4227179.959916327, 1915805.3829014762 4227179.126126084, 1915799.7648645544 4227167.884252375, 1915797.4844072682 4227162.346196934, 1915793.6362571071 4227152.611506485, 1915790.943149824 4227144.808491227, 1915786.6095399547 4227131.693900598, 1915785.6836510021 4227129.402106473, 1915783.745825752 4227123.888182406, 1915781.2513508457 4227115.97918686, 1915779.0075596937 4227107.973282189, 1915777.3841244031 4227101.615980866, 1915776.4047251164 4227097.773822446, 1915776.325938097 4227097.3655254105, 1915776.2419423868 4227096.932267829, 1915776.1394444443 4227095.935740741, 1915775.8510281565 4227093.1911271205, 1915773.941986192 4227072.324321856, 1915773.1016387318 4227064.278874122, 1915772.0838893258 4227060.009809815, 1915770.6109455815 4227056.907247858, 1915768.3608541514 4227052.178146271, 1915766.211852227 4227047.730662964, 1915765.2303646244 4227045.356955033, 1915765.3868703952 4227042.246505492, 1915765.831363226 4227040.787095383, 1915766.3404580506 4227039.750713271, 1915779.4514401332 4227024.391184625, 1915780.5869749752 4227022.770009923, 1915780.686308874 4227022.336132032, 1915780.9864625256 4227019.95092817, 1915781.2121833994 4227009.723795402, 1915780.6521815502 4227004.8762755, 1915771.2712499993 4226990.74875001, 1915801.9675000224 4226938.452499983, 1915800.8369977516 4226928.696854456, 1915798.9610438726 4226869.651743527, 1915798.4398977403 4226840.748552267, 1915797.9486893606 4226807.856307718, 1915797.1676445997 4226742.446275297, 1915802.5068749965 4226745.651874999, 1915806.7385029164 4226749.046828041, 1915812.7601047938 4226755.3860036, 1915820.9668740737 4226764.593219142, 1915843.7618101076 4226790.345188383, 1915871.8322130109 4226821.983174839, 1915889.4310274252 4226841.127982753, 1915896.9633511964 4226848.3808967685, 1915903.8625702045 4226853.884740212, 1915910.0712500017 4226856.5665625, 1915914.5553978018 4226854.064894454, 1915939.318207316 4226829.061414115, 1915940.1300000062 4226828.243333328, 1915946.8360786864 4226821.507078402, 1915949.6500553945 4226818.925441195, 1915957.7724880301 4226811.481053188, 1915969.4740751523 4226800.827637905, 1916000.7446868208 4226772.630575969, 1916027.0093749994 4226748.939999999, 1916056.702536462 4226722.016314398, 1916070.2537500022 4226709.313749999, 1916090.1735728728 4226685.584893726, 1916118.2608653824 4226650.881535932, 1916130.972639793 4226636.523213707, 1916145.1830807421 4226621.626424412, 1916164.5494910146 4226602.231490927, 1916172.251707993 4226594.974663453, 1916186.5761133602 4226582.802360831, 1916187.5205978993 4226583.060584721, 1916187.8995910913 4226582.719438509, 1916194.1978160564 4226577.044745843, 1916210.0814066515 4226562.356237932, 1916222.90210115 4226550.3596146535, 1916227.9821211076 4226545.652587792, 1916237.7192952386 4226536.665550315, 1916250.804864341 4226524.765007701, 1916250.8985210308 4226524.679955891, 1916252.0814563239 4226523.601869826, 1916261.0376873298 4226515.468745677, 1916265.1895744235 4226511.670836187, 1916271.7162251193 4226505.657039962, 1916278.0577994722 4226499.418471453, 1916284.754170677 4226492.436314191, 1916303.0901867156 4226471.929374563, 1916315.9914085066 4226456.712662229, 1916325.42648883 4226444.6891608015, 1916329.6244894022 4226439.416812749, 1916333.255544972 4226434.855080911, 1916337.23845618 4226430.174520975, 1916344.4161899136 4226421.952027479, 1916349.4692913939 4226416.456741335, 1916352.891936984 4226412.804020931, 1916355.3398970363 4226410.136345284, 1916360.7770249099 4226405.32146632, 1916365.4544720927 4226401.196068884, 1916369.7083239376 4226397.744819511, 1916373.9368717293 4226395.508819421, 1916380.797028285 4226391.821668937, 1916387.3411526252 4226388.237626449, 1916392.3266327986 4226385.3744717995, 1916396.7307387746 4226382.669648189, 1916399.3067989503 4226380.893620626, 1916406.9442963465 4226375.126087588, 1916412.1769442696 4226370.416057486, 1916417.8732278713 4226363.879697788, 1916437.8574240694 4226334.557952071, 1916442.0338189325 4226328.469641721, 1916443.805356827 4226325.90341799, 1916446.5958785599 4226321.909663203, 1916447.5255881632 4226320.608286792, 1916447.9252251377 4226320.045483189, 1916448.1441735006 4226319.735623579, 1916448.3337497665 4226319.464818064, 1916448.428169362 4226319.330752156, 1916448.5329031695 4226319.184081443, 1916448.5369593413 4226319.178229054, 1916448.566173477 4226319.137055725, 1916448.5815066209 4226319.115398505, 1916448.6143699083 4226319.069392891, 1916448.641374228 4226319.031449962, 1916448.687156259 4226318.966929208, 1916449.3017173065 4226318.097072921, 1916450.5384762404 4226316.351565533, 1916453.3557784194 4226312.491271443, 1916454.2711972452 4226311.25968047, 1916455.2567200055 4226309.966971455, 1916458.9421576408 4226305.151329614, 1916461.1330524448 4226302.272604414, 1916465.6688245249 4226296.776959186, 1916468.4727608457 4226293.407863418, 1916477.264887541 4226283.658294931, 1916480.583905658 4226280.034896906, 1916494.730766596 4226264.552173027, 1916500.6727382296 4226257.624947624, 1916502.1429801001 4226255.813548443, 1916504.3755156505 4226253.181995363, 1916504.896901752 4226252.569548321, 1916505.619583611 4226251.6957237255, 1916506.1223900262 4226251.094214479, 1916507.015525139 4226249.939939492, 1916509.7769733733 4226246.3765383335, 1916513.166004486 4226241.896592492, 1916515.8381055165 4226238.287173397, 1916515.9957225218 4226238.069122925, 1916516.1338694666 4226237.876076534, 1916524.9357692304 4226225.68175101, 1916529.5551318747 4226219.186099731, 1916535.1043244365 4226211.991636584, 1916535.3035276646 4226211.736447881, 1916539.3823555512 4226207.00079136, 1916556.182929791 4226194.677815245, 1916563.2687743935 4226189.410518693, 1916565.1959625026 4226187.748052418, 1916565.9572750893 4226187.064965835, 1916567.504229459 4226185.52811472, 1916569.5727367098 4226183.129998541, 1916572.649866071 4226178.371252271, 1916574.3837145353 4226174.587915312, 1916576.6892846834 4226168.334413689, 1916582.4987500017 4226150.311250007, 1916583.9344193207 4226146.165316767, 1916584.9198502619 4226143.667498006, 1916586.5548018254 4226140.018748123, 1916587.2522947236 4226138.647979384, 1916590.0151319804 4226133.883502968, 1916591.8931694927 4226130.75737659, 1916592.9041697509 4226129.081631937, 1916593.2214325848 4226128.581593258, 1916594.002833744 4226127.341172255, 1916599.361300636 4226119.452472665, 1916605.9097056945 4226109.817565677, 1916606.908240806 4226108.336623996, 1916607.3601405884 4226107.686265485, 1916607.8610601197 4226106.93144825, 1916608.9810136475 4226105.29309526, 1916610.9777639655 4226102.36171433, 1916611.9020730406 4226100.993477302, 1916613.4054579355 4226098.806689611, 1916617.4567060673 4226092.887923837, 1916619.9230377697 4226089.354669214, 1916622.02524058 4226086.347985369, 1916623.6642028475 4226083.9831130495, 1916626.6139476143 4226079.786909311, 1916638.9876846422 4226062.1257454455, 1916644.5164605342 4226054.233309805, 1916647.9332690171 4226049.333331759, 1916651.6878929106 4226044.059631261, 1916656.467631157 4226037.455774788, 1916660.2430981938 4226032.296651477, 1916661.2306601922 4226030.935753725, 1916661.8728359938 4226030.020379121, 1916667.111996126 4226022.737333513, 1916674.861577033 4226012.098462377, 1916677.9507561221 4226008.03312895, 1916680.7858848055 4226004.351300519, 1916682.211123323 4226002.566517362, 1916684.4349687207 4225999.780746904, 1916686.579587334 4225997.105725217, 1916688.6814705273 4225994.475256525, 1916690.4580709874 4225992.402797384, 1916692.7253931665 4225989.787012244, 1916699.692766247 4225981.93362956, 1916700.8687108576 4225980.759388362, 1916711.200055729 4225972.180275665, 1916722.6265992618 4225962.860526905, 1916732.2685834942 4225954.537824412, 1916738.1850424688 4225949.337139105, 1916748.6097253906 4225940.159553518, 1916771.479794216 4225917.989873034, 1916808.453404988 4225882.153983018, 1916814.1054986264 4225875.378850423, 1916819.5037115528 4225866.496306103, 1916829.192099977 4225848.339509056, 1916832.8324509074 4225841.535009471, 1916835.1112438084 4225837.24096986, 1916859.4668434905 4225790.293017808, 1916865.4987364127 4225778.569002428, 1916889.8407776337 4225731.600497324, 1916892.7425735518 4225725.963560587, 1916894.2614802294 4225723.002665691, 1916898.0617054892 4225715.603329218, 1916899.3908346682 4225713.018932968, 1916949.7681210649 4225616.762116536, 1917012.2755494667 4225497.2316823965, 1917029.8806704795 4225462.792541508, 1916991.6820973873 4225457.583730166, 1916975.5712499972 4225457.316249989, 1916965.704217511 4225457.92511358, 1916951.9775000163 4225459.65374999, 1916896.2462499999 4225468.454999998, 1916829.086249983 4225479.139999999, 1916796.7787500003 4225485.591249993, 1916773.6821331365 4225491.806246064, 1916726.2862499785 4225507.4275, 1916691.6112500115 4225521.671249985, 1916657.9369437317 4225539.646246479, 1916625.4087499958 4225558.4974999875, 1916580.7705377853 4225584.927318153, 1916567.9150000194 4225590.149999979, 1916516.935 4225606.127499981, 1916498.985315505 4225610.985760618, 1916484.0985370735 4225613.040940052, 1916475.704032842 4225612.153960753, 1916462.9400000407 4225608.351249992, 1916443.932287499 4225598.626816801, 1916418.6984883402 4225583.037138182, 1916418.0079950085 4225582.617812346, 1916406.7343387231 4225574.392355241, 1916397.6798799199 4225566.627981916, 1916393.1434882293 4225562.619816492, 1916391.0247212653 4225560.651357249, 1916385.3262500262 4225555.20374999, 1916380.570737149 4225550.472873772, 1916368.4534257066 4225536.578754777, 1916363.6464909448 4225530.312964796, 1916359.3985134107 4225524.06090589, 1916354.2511214188 4225515.49884469, 1916346.8279277475 4225502.94600068, 1916342.3253796732 4225494.122291925, 1916336.3280791298 4225482.1362296, 1916320.9305851483 4225448.311360948, 1916297.2722043237 4225391.171865053, 1916272.1812252835 4225330.708134016, 1916264.3391539059 4225309.585883234, 1916257.326921346 4225283.859680465, 1916256.0207692548 4225277.869263712, 1916254.9513551977 4225271.672820771, 1916251.8399741985 4225251.360141968, 1916241.8734675907 4225184.87305166, 1916226.9588157947 4225104.14228744, 1916207.829061844 4225009.773265558, 1916181.4611808679 4224915.362205015, 1916176.5346990814 4224896.9117074115, 1916171.605452813 4224880.933533547, 1916166.272986518 4224867.687362546, 1916161.158970007 4224857.068765089, 1916147.110579095 4224831.716675071, 1916115.7859129184 4224767.695109847, 1916110.5939005779 4224759.721277187, 1916104.3266715212 4224751.883967155, 1916103.7757455548 4224751.208756639, 1916074.5449936306 4224715.758958329, 1916072.977590579 4224713.567083333, 1916071.3412405513 4224711.249499404, 1916062.8449475735 4224700.665634619, 1916058.598808938 4224695.791570399, 1916055.0491150434 4224692.184229912, 1916041.5324026956 4224680.4644741425, 1916031.491247564 4224672.96134503, 1916029.110312829 4224671.743152305, 1915994.983246903 4224656.483020468, 1915988.2714016566 4224652.931515472, 1915986.9267958226 4224651.842677052, 1915974.9645201762 4224647.937922922, 1915966.8975631583 4224645.347033858, 1915949.3709271788 4224641.663187269, 1915917.2844979363 4224638.432336505, 1915911.28263376 4224638.349532545, 1915888.4065760928 4224638.864496772, 1915851.713938619 4224639.960115935, 1915841.0762530603 4224641.318591351, 1915826.8508694044 4224643.319078083, 1915813.36644798 4224645.217184537, 1915798.5002402014 4224646.772111251, 1915768.357111046 4224649.8521911, 1915749.8075000015 4224651.900000004, 1915716.7613355694 4224656.358023048, 1915708.2442273686 4224657.803323322, 1915696.5573496586 4224660.360294111, 1915675.641269133 4224665.386743912, 1915655.5658524577 4224671.773088435, 1915604.469250678 4224691.84673976, 1915601.290132003 4224693.2438560035, 1915579.9481980877 4224703.236330018, 1915572.9776691948 4224706.788986324, 1915559.2070592176 4224713.819793948, 1915555.2963290103 4224715.980146566, 1915523.9484487597 4224736.462806937, 1915510.4309482542 4224746.691894986, 1915494.9025000029 4224760.5025, 1915485.895440282 4224771.232378547, 1915478.853143029 4224781.275520667, 1915466.5375000208 4224802.17124998, 1915451.5253359128 4224828.13494874, 1915446.3403530046 4224836.66494598, 1915438.6792106002 4224850.209174369, 1915432.7112500088 4224862.728749998, 1915428.5834234508 4224873.788150017, 1915422.803257095 4224891.317525203, 1915418.2219352634 4224910.129376789, 1915412.541259086 4224937.966778578, 1915410.4636567703 4224951.12520482, 1915408.3851173627 4224963.89948555, 1915407.2887517018 4224971.070117132, 1915405.1234007329 4224987.233046094, 1915405.523558355 4224995.268439444, 1915406.3736589246 4225020.831080448, 1915406.9108995942 4225036.292919338, 1915407.2983919978 4225043.992430188, 1915407.9587249947 4225056.106705361, 1915409.3836842754 4225071.245867296, 1915410.9335287071 4225086.026110807, 1915411.9063051338 4225094.455195714, 1915414.8476611644 4225119.604046039, 1915414.987393556 4225120.656981802, 1915415.6912820307 4225124.32669251, 1915417.428312422 4225133.544193153, 1915419.0707347675 4225141.194530677, 1915420.55541751 4225147.584858299, 1915423.3432781885 4225159.522375828, 1915432.2246651454 4225197.237161878, 1915440.4703542623 4225232.32428642, 1915445.6407109955 4225253.274729204, 1915447.4810879058 4225260.6208618665, 1915460.6791172626 4225310.077042976, 1915466.7400588028 4225333.232360231, 1915476.2015584966 4225368.965525356, 1915480.919285358 4225387.52199426, 1915482.1167601317 4225392.883817145, 1915482.8197366747 4225395.983766685, 1915484.3253454787 4225403.697060326, 1915487.3143511289 4225419.652436592, 1915487.4140715592 4225420.664813282, 1915487.620942784 4225422.655003653, 1915487.7277400498 4225435.616933408, 1915487.682752994 4225463.065309784, 1915487.8153933117 4225465.107263486, 1915488.0286032455 4225467.776816835, 1915492.3500090481 4225479.34627481, 1915492.6741891245 4225480.912732742, 1915492.512709291 4225486.395862056, 1915492.0294523165 4225529.063389402, 1915491.5848056783 4225546.447739897, 1915491.0432244088 4225561.521829984, 1915489.6750000077 4225593.147500003, 1915487.6815968365 4225627.942520768, 1915486.9562915105 4225635.618361632, 1915485.2904624345 4225641.082184367, 1915484.2026975148 4225644.342919299, 1915482.4503297 4225649.194546313, 1915478.5576275212 4225660.388178775, 1915477.8054721914 4225661.968633691, 1915473.8561253569 4225668.6473631235, 1915469.156592878 4225677.558887884, 1915442.442458767 4225733.799343579, 1915432.2779259777 4225756.859484899, 1915429.4397512097 4225763.847918548, 1915419.333831639 4225789.8436787, 1915409.650156087 4225812.407212654, 1915401.125975614 4225830.0633128565, 1915395.3723511405 4225841.202833836, 1915388.3162539932 4225853.887589896, 1915381.6965072544 4225865.124661894, 1915372.4232039123 4225879.89366192, 1915370.5677569679 4225882.617592141, 1915358.6564705768 4225900.288095008, 1915356.1029225518 4225904.002835463, 1915354.0505046418 4225906.9148635985, 1915352.8385259153 4225908.491405052, 1915349.9810938616 4225912.228354164, 1915346.6156117015 4225916.416772899, 1915345.9965390007 4225917.067543204, 1915335.547882155 4225927.972289773, 1915324.7212676865 4225937.439958759, 1915322.712466936 4225939.191734842, 1915317.070014395 4225944.16162847, 1915315.2231226978 4225945.738533174, 1915313.8992523989 4225946.870079278, 1915311.1251957724 4225949.371652951, 1915306.3447335337 4225954.231623946, 1915301.6414187977 4225958.934619793, 1915295.028442455 4225965.540503844, 1915292.3016990297 4225968.3259182405, 1915279.0737757573 4225982.141204708, 1915272.173096149 4225989.072083821, 1915262.0561830604 4225999.24734891, 1915248.043724705 4226014.6173785245, 1915238.889483219 4226023.731908102, 1915230.2733566815 4226031.603479545, 1915217.5144615336 4226041.418919424, 1915173.5735374368 4226062.16776315, 1915159.6572886608 4226069.228513299, 1915128.407278301 4226083.636832543, 1915107.4229213118 4226091.1037611775, 1915095.6260319499 4226094.5191778345, 1915089.85200961 4226096.032369896, 1915078.0387780175 4226098.540391539, 1915068.2155013059 4226100.620597892, 1915008.2684059 4226101.289504048, 1915005.1590376059 4226100.654175028, 1914973.2509755825 4226093.146006446, 1914959.5425000268 4226089.168750007, 1914937.1720144933 4226079.078437723, 1914916.5537499273 4226066.841383632, 1914909.0391106084 4226061.633392138, 1914897.3804301154 4226053.848671479, 1914881.8760163952 4226042.647624813, 1914875.944719137 4226038.176470131, 1914873.4886216114 4226036.092179108, 1914868.2251239843 4226031.659915871, 1914854.9354201194 4226019.113367212, 1914825.5506146129 4225990.720608466, 1914825.2925826604 4225990.9301180085, 1914825.0917178367 4225990.7304530945, 1914781.6393447889 4226026.128141814, 1914773.5065271237 4226032.679583593, 1914765.6492040516 4226038.741830181, 1914761.9765434493 4226041.460681888, 1914757.188749999 4226045.241874998, 1914750.984276749 4226050.242198069, 1914745.777856296 4226056.805252652, 1914744.99929337 4226057.762167632, 1914742.4207089953 4226060.730068683, 1914739.872274534 4226061.021718405, 1914739.2055844057 4226061.048675322, 1914735.6990106367 4226060.407259618, 1914730.253651896 4226058.568355211, 1914724.3185602229 4226055.936506834, 1914710.0819700016 4226048.532999767, 1914709.8855319147 4226048.498496687, 1914709.5976404247 4226048.4719850775, 1914706.5347818097 4226049.550788845, 1914701.8893102491 4226051.134152513, 1914697.3370152588 4226052.636543059, 1914692.4663909876 4226053.887865344, 1914689.4894404013 4226056.14082553, 1914688.0603017462 4226056.62359354, 1914687.6105144084 4226056.782797341, 1914682.199630851 4226058.227203109, 1914675.8726308183 4226060.342463365, 1914672.4937799436 4226061.765770832, 1914660.3897253873 4226067.237443424, 1914659.7319406464 4226067.5200424995, 1914657.9975225872 4226068.232790559, 1914652.847546024 4226069.9792308975, 1914650.8787933025 4226070.650331395, 1914649.6772074776 4226071.004654547, 1914647.6943484596 4226071.355505125, 1914647.5636796076 4226071.385769028, 1914647.316527595 4226071.513737122, 1914645.9431697999 4226072.730985282, 1914643.5848254906 4226072.753888467, 1914640.2468293037 4226072.798884452, 1914638.4234577506 4226074.399600829, 1914636.3292773964 4226076.225483036, 1914635.7776630032 4226076.444078589, 1914635.5983570672 4226076.475206305, 1914629.6086610355 4226077.444307472, 1914618.9263415148 4226081.401371932, 1914616.2108253 4226082.405523676, 1914612.9629941708 4226083.587161345, 1914609.2907199606 4226084.911945676, 1914609.2634369594 4226084.921789499, 1914609.2380280716 4226084.930959204, 1914609.158843976 4226084.959529588, 1914608.6371983297 4226085.147505467, 1914607.9557986371 4226085.393323648, 1914604.9530454243 4226086.476648413, 1914592.839837388 4226090.847078171, 1914591.1622564793 4226091.413690873, 1914590.7200264272 4226091.409197281, 1914586.4483229918 4226090.7176148705, 1914585.7525386019 4226090.790839211, 1914585.6235148842 4226090.798942425, 1914583.7523981712 4226091.645485345, 1914581.583831413 4226092.649867267, 1914577.7876569