
-- Procédure
INSERT INTO urba_plui_ecriture.pluiv_procedures (code_proc,num_proc,num_phase,intitule,datefin_proc,commentaires) VALUES
     ('MJ',3,1,'Mise à jour N°3','2023-03-03','Procédure du PLUi GAM'),
     ('M',1,1,'test M1',NULL,'comment'),
     ('M',2,1,'nouvelle proc',NULL,'commentaire'),
     ('M',3,1,'proc en cours',NULL,NULL);

-- Thématique
INSERT INTO urba_plui_ecriture.pluiv_thematiques (nom_thematique,description,classe_entite,code_cnig,categories) VALUES
     ('Plan de zonage','Couche de zonage du PLUi GAM','zon',NULL,NULL),
     ('Emplacements réservés',NULL,'psc','05',ARRAY['05-01','05-02','05-03','05-04']),
     ('Servitudes de localisation',NULL,'psc','05',ARRAY['05-06']);

-- Procédure / thématique
 INSERT INTO urba_plui_ecriture.pluiv_corresp_procedures_thematiques (id_procedure,id_thematique) VALUES
    (1,1),
    (1,2),
    (2,1),
    (2,2),
    (2,3),
    (3,1),
    (3,2),
    (3,3),
    (4,1),
    (4,2),
    (4,3);
--ALTER TABLE urba_plui_ecriture.pluiv_thematiques ENABLE TRIGGER tt_pluiv_thematiques_insert;

-- Projets de thématique
INSERT INTO urba_plui_ecriture.pluiv_projets (id_proc_them,nom_projet,description,date_init,date_fin,commentaires,categorie,num_proj) VALUES
     (1,'Plan de zonage [PARTIEL]','Partie du zonage GAM','2021-06-01',NULL,'Projet récupéré depuis la BDD de prod du PLUi GAM','ZON',50),
     (2,'Emplacements réservés [LOT1]','ER traités par géomaticien NNN','2021-06-01',NULL,'Projet récupéré depuis la BDD de prod du PLUi GAM','P05',1),
     (3,'Plan de zonage M1','Partie du zonage GAM','2023-03-27',NULL,'Projet récupéré de la MJ3','ZON',50),
     (4,'Emplacements réservés [LOT1]','ER traités par géomaticien NNN','2023-06-01',NULL,'Projet issu de la MJ3','P05',1),
     (5,'Servitudes de localisation[LOT1]','SL isolées des ER','2023-06-02',NULL,'Projet issu de la MJ3','P05',2);

-- Versions des projets
INSERT INTO urba_plui_ecriture.pluiv_versions (id_projet,date_init,date_fin,commentaires,num_version,statut,intitule) VALUES
     (1,'2022-04-22 10:02:19.763',NULL,'[MJ3] version de référence C05','09','08','ZONAGE GAM'),
     (2,'2022-04-22 08:50:38.053',NULL,'[MJ3] version de référence C05','07','03','J : EMPLACEMENT RÉSERVÉ & SERVITUDE DE LOCALISATION'),
     (3,'2023-05-02 11:11:59.183',NULL,'[M1] version issue de la MJ3','09','03','ZONAGE GAM'),
     (4,'2023-06-02 11:21:02.983',NULL,'[M1] version issue de la MJ3','07','03','J : EMPLACEMENT RÉSERVÉ'),
     (5,'2023-06-03 17:19:52.146',NULL,'[M1] SL issues des ER de la MJ3','01','03','K : SERVITUDE DE LOCALISATION');

-- Versions validées des procédures terminées
INSERT INTO urba_plui_ecriture.pluiv_versions_proc_terminees (id_proc,id_them,id_version) VALUES
     (1,1,1),
     (1,2,2);

-- Objets CNIG (échantillon de 200 objets par version)
INSERT INTO urba_plui_ecriture.zoneurba (idurba,libelle,libelong,typezone,nomfic,urlfic,datevalid,geom,lib_idzone,lib_hstore,lib_id_version) VALUES
     ('MJ3_PH1_ZON_050_09','UD2m','Pavillonnaire en densification avec secteurs où l''implantation en limite est restreinte','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD2.pdf','2019-12-20','SRID=3945;POLYGON ((1916819.8771930868 4227096.020857094, 1916779.2440501358 4227069.647340989, 1916773.5562999286 4227065.9428021, 1916740.1165999286 4227044.2596021015, 1916735.5467526477 4227041.322387839, 1916735.87 4227040.87, 1916738.36 4227037.44, 1916736.3 4227035.97, 1916728.34 4227030.29, 1916727.02 4227029.34, 1916725 4227027.89, 1916724.42 4227027.48, 1916722.92 4227026.4, 1916712.01 4227018.61, 1916710 4227017.17, 1916708.07 4227015.79, 1916707.36 4227015.29, 1916702.1234431528 4227022.695130962, 1916702.1215594695 4227022.6977947205, 1916682.89 4227006.47, 1916676.52 4227001.55, 1916671.83 4226997.93, 1916673.57 4226994.03, 1916652.85 4226979.46, 1916648.98 4226976.14, 1916633.88 4226966.02, 1916625.772365898 4226960.580049258, 1916625.7716484251 4226960.581105726, 1916610.2833586002 4226983.387386713, 1916601.8241377126 4226979.292599595, 1916585.976666715 4226992.604840555, 1916568.7787818518 4227007.058981065, 1916530.2001090888 4226979.105949856, 1916498.0405274346 4226956.500686079, 1916476.5839152066 4226941.561003835, 1916481.8429567504 4226936.633314148, 1916489.7210122426 4226929.241788946, 1916498.5594627454 4226920.9584644, 1916499.7388059034 4226919.856942129, 1916525.073522353 4226896.010031529, 1916509.56918684 4226879.3035847, 1916530.0038471397 4226859.673212115, 1916545.5890147032 4226876.8100478435, 1916566.7141027981 4226857.189264721, 1916550.2187613326 4226840.033429055, 1916564.935444265 4226825.721392466, 1916571.3832343312 4226825.075620119, 1916571.3888177546 4226825.075060917, 1916576.4103474992 4226823.790011215, 1916580.7296048522 4226821.133643401, 1916570.4206250014 4226814.48625, 1916522.56875 4226783.543750002, 1916520.1818069385 4226782.015927034, 1916493.29875 4226764.808750002, 1916450.768841174 4226737.357362719, 1916447.58625 4226735.303125001, 1916381.76375 4226693.1725, 1916350.8784261132 4226673.307823887, 1916292.2002059266 4226635.703078036, 1916255.3116616255 4226612.634420132, 1916240.0052637216 4226603.082029218, 1916219.8669864228 4226594.303036361, 1916203.4678651956 4226588.16215691, 1916187.5205978993 4226583.060584721, 1916186.5761133602 4226582.802360831, 1916186.4251611512 4226582.930633937, 1916185.957528667 4226583.3280091835, 1916185.1723748993 4226583.995201225, 1916172.251707993 4226594.974663453, 1916164.5494910146 4226602.231490927, 1916145.1830807421 4226621.626424412, 1916139.7184333338 4226627.355008156, 1916130.972639793 4226636.523213707, 1916129.9523617355 4226637.675647713, 1916118.2608653824 4226650.881535932, 1916090.1735728728 4226685.584893726, 1916070.2537500022 4226709.313749999, 1916056.702536462 4226722.016314398, 1916027.0093749994 4226748.939999999, 1916000.7446868208 4226772.630575969, 1915969.4740751523 4226800.827637905, 1915957.7724880301 4226811.481053188, 1915949.6500553945 4226818.925441195, 1915946.8360786864 4226821.507078402, 1915940.1300000062 4226828.243333328, 1915939.318207316 4226829.061414115, 1915914.5553978018 4226854.064894454, 1915910.0712500017 4226856.5665625, 1915908.1406999289 4226856.9834021, 1915918.0483343753 4226862.575226683, 1915956.9957999287 4226884.557002101, 1915979.4546334492 4226896.409597463, 1916000.3418999289 4226907.4328021, 1916010.7536999288 4226912.826802101, 1916015.2581999288 4226914.723602101, 1916016.8683388466 4226915.456358242, 1916012.472038642 4226921.140422244, 1916000.1276540053 4226936.450540345, 1915983.3262207746 4226957.2681826465, 1915977.6086038018 4226964.357592727, 1915977.6107309 4226964.359094042, 1915977.61 4226964.36, 1915969.4 4226974.54, 1915951.9697999288 4226971.814602101, 1915929.9463830935 4227002.137088167, 1915936.9 4227007.23, 1915974.1 4227034.19, 1915975.93 4227035.39, 1916000.375418452 4227052.306503857, 1916004.8439585087 4227061.950770419, 1916004.842007891 4227061.953238807, 1916036.5717147065 4227084.578772059, 1916054.2036703571 4227097.151042832, 1916062.133732388 4227102.310121048, 1916058.5545999287 4227106.603002098, 1916054.7549999286 4227109.2078021, 1916046.4947962358 4227115.438490284, 1916053.4683999286 4227126.119402099, 1916059.3763999287 4227131.0174021, 1916062.5802999288 4227132.515402101, 1916098.158149353 4227148.995389328, 1916135.4544999287 4227166.271402101, 1916149.7701999287 4227173.8636021, 1916151.5726999287 4227175.462402101, 1916154.4769999287 4227178.062002099, 1916156.5811999287 4227181.762002099, 1916170.8163999286 4227212.0678020995, 1916185.3497999285 4227238.871602102, 1916188.2582999289 4227246.573602101, 1916191.6665999289 4227253.3752021, 1916194.6723999288 4227257.875202101, 1916195.5418043558 4227259.122523561, 1916196.2753999287 4227260.175002101, 1916203.5133575755 4227271.78326461, 1916204.2 4227271.62, 1916205.37 4227271.43, 1916215.22 4227280.17, 1916236.74 4227298.54, 1916241.83 4227303, 1916254.87 4227313.98, 1916268.7526340552 4227325.430304782, 1916273.02 4227328.95, 1916279.15 4227334.26, 1916283.46 4227337.99, 1916284.25 4227338.69, 1916303.52 4227355.08, 1916307.4 4227358.42, 1916313.98 4227363.66, 1916319.43 4227367.8, 1916322.83 4227370.41, 1916324.4 4227371.47, 1916325.55 4227372.32, 1916328.44 4227374.13, 1916331.81 4227376.33, 1916333.11 4227377.08, 1916336.1 4227378.95, 1916339.45 4227380.58, 1916341.41 4227381.51, 1916344.01 4227382.66, 1916346.16 4227383.58, 1916347.68 4227384.14, 1916350.4 4227385.26, 1916350.87 4227385.45, 1916354.25 4227386.42, 1916356.79 4227387.15, 1916361.29 4227388.16, 1916365.93 4227389.09, 1916366.7 4227389.24, 1916370.36 4227390.09, 1916372.16 4227390.35, 1916374.01 4227390.55, 1916377.74 4227390.83, 1916381.39 4227391.11, 1916386.47 4227391.33, 1916392.83 4227391.37, 1916396.04 4227391.1, 1916401.46 4227390.48, 1916414.03 4227388.7, 1916427.07 4227386.84, 1916428.34 4227386.69, 1916445.05 4227384.32, 1916458.33 4227382.47, 1916468.443437528 4227381.252346375, 1916477.35 4227380.18, 1916495.61 4227377.65, 1916496.38 4227377.53, 1916498.46 4227376.99, 1916500.28 4227376.45, 1916502.18 4227375.19, 1916504.11 4227373.79, 1916506.01 4227372.11, 1916507.04 4227371.27, 1916510.79 4227366.91, 1916514.85 4227355.31, 1916516.18 4227350.38, 1916516.12 4227349.26, 1916515.87 4227346.97, 1916514.96 4227342.85, 1916513.88 4227337.62, 1916513.78 4227336.31, 1916513.77 4227332.49, 1916513.67 4227328.81, 1916514.15 4227324.2, 1916514.67 4227320.81, 1916515.58 4227317.01, 1916516.15 4227314.44, 1916510.1140999286 4227312.528602099, 1916516.5995999286 4227291.209802102, 1916513.87 4227289.84, 1916490.12 4227281.44, 1916478.62 4227277.27, 1916477.33 4227276.78, 1916474.59 4227275.77, 1916469.17 4227273.75, 1916466.32 4227272.69, 1916467.17 4227270.62, 1916472.26 4227258.19, 1916480.54 4227237.98, 1916486.22 4227225.93, 1916503.61 4227201.91, 1916507.94 4227196.02, 1916511.51 4227191.18, 1916545.0753082968 4227214.12006582, 1916545.0982843237 4227214.086925712, 1916545.967705381 4227212.835585424, 1916549.5455254596 4227207.689048716, 1916560.597989549 4227191.8096857155, 1916562.047217915 4227189.716713963, 1916562.0506120333 4227189.71912112, 1916562.667789706 4227190.156832256, 1916564.1594639157 4227191.236168244, 1916570.447562142 4227195.783167306, 1916572.6000681291 4227197.342210044, 1916582.9029876448 4227204.767405215, 1916592.8058316023 4227211.9329966, 1916595.539249726 4227213.891968085, 1916604.2886128693 4227218.8372228015, 1916606.567143248 4227226.410042169, 1916614.4367951464 4227231.836373982, 1916628.9010099666 4227241.7873389935, 1916628.9043200428 4227241.789616231, 1916636.2116783385 4227222.531104922, 1916647.8759642015 4227230.325513975, 1916648.3661848495 4227230.685298748, 1916669.4986170253 4227240.882961613, 1916675.0141455592 4227243.519673952, 1916689.7895524667 4227250.650907826, 1916692.7672771616 4227252.299132634, 1916696.7374355902 4227254.496687575, 1916697.8985611345 4227255.186077766, 1916692.8749300607 4227265.587127425, 1916695.6378069252 4227266.915685175, 1916702.5948423073 4227270.251143732, 1916703.5660646686 4227270.730574022, 1916712.404854988 4227274.965510476, 1916728.0613428715 4227282.475991834, 1916730.7239228596 4227283.764413859, 1916731.3346840856 4227283.973999137, 1916732.543167898 4227281.211228778, 1916734.564897195 4227282.210243263, 1916736.4770656135 4227282.879152638, 1916748.6593697197 4227288.531583337, 1916764.3156371783 4227295.792309645, 1916770.0378816223 4227283.129047565, 1916778.0054360002 4227286.574072265, 1916800.437847468 4227296.290273614, 1916791.7841626238 4227320.593089338, 1916787.7925417756 4227332.313435131, 1916787.0531132598 4227333.915276343, 1916783.8015199194 4227333.918171452, 1916780.5405006576 4227335.471826811, 1916778.2942050213 4227341.172452145, 1916786.44 4227342.25, 1916785.46 4227345.14, 1916784.86 4227346.64, 1916784.19 4227348.14, 1916777.78 4227359.64, 1916776.26 4227362.32, 1916768.18 4227370.46, 1916761.3664838336 4227377.666461059, 1916758.99 4227380.18, 1916754.99 4227384.45, 1916753.92 4227385.75, 1916750.23 4227391.95, 1916744.7661373543 4227401.12071848, 1916740.03 4227409.07, 1916744.64 4227409.17, 1916744.82 4227422.31, 1916746.4194344042 4227424.807039144, 1916751.6799523488 4227432.997389639, 1916773.048274192 4227439.062502897, 1916781.1038592106 4227417.301569159, 1916784.1386199691 4227409.094228208, 1916802.955829238 4227415.671322769, 1916831.2621018304 4227425.882402708, 1916840.4806779139 4227429.156408719, 1916860.2572258117 4227433.65116639, 1916879.4026632383 4227438.00719913, 1916870.5081922153 4227461.589203212, 1916908.7531498382 4227485.470227178, 1916887.993514484 4227511.664805829, 1916894.7893194752 4227513.269541848, 1916904.507159413 4227515.592117274, 1916918.8420913073 4227522.243441683, 1916919.3824587944 4227522.283184967, 1916925.2358109502 4227522.007803857, 1916938.5416356237 4227519.814807982, 1916946.5878573095 4227521.248524026, 1916954.6845009406 4227522.671988606, 1916955.975676793 4227523.101302605, 1916972.1962128151 4227524.187324396, 1916978.2600416634 4227524.301994278, 1916995.6475984475 4227520.564210524, 1916995.6804043222 4227520.557543108, 1916995.734783998 4227520.545860624, 1917004.42 4227518.68, 1917005.02 4227518.54, 1917005.86 4227525.92, 1917005.2181112324 4227530.798354635, 1917007.66 4227531.72, 1917013.7191859419 4227534.634346555, 1917014.932501719 4227535.215837322, 1917017.184846924 4227536.294493916, 1917028.697052147 4227541.8280397095, 1917030.1197450561 4227544.318302953, 1917023.163262561 4227575.293341068, 1917036.6287727354 4227583.186397891, 1917052.10684468 4227593.23838854, 1917049.608768689 4227596.672925947, 1917072.1828623267 4227608.359999021, 1917090.8831879566 4227618.489564688, 1917090.7606961532 4227615.777806253, 1917091.1363872646 4227610.234262576, 1917091.831251274 4227604.440080492, 1917093.6139629274 4227594.582230545, 1917093.6614830447 4227591.9909949815, 1917095.4227390457 4227592.409682915, 1917104.4314451579 4227595.963640008, 1917125.65206367 4227604.009475193, 1917144.3496784235 4227611.09756866, 1917149.291100544 4227598.0651507, 1917153.8057258627 4227589.145642466, 1917157.5436399537 4227583.778610874, 1917158.5530520335 4227582.647215521, 1917163.1399942087 4227587.495907753, 1917166.4751728768 4227591.005092268, 1917172.7641765345 4227596.543291164, 1917177.7405555854 4227600.491082284, 1917181.7862230502 4227603.609393044, 1917182.3665181943 4227603.988909079, 1917185.5304364613 4227605.977511232, 1917192.2476976626 4227609.713620033, 1917197.002994814 4227612.151079327, 1917202.368454119 4227614.798123427, 1917204.5253536094 4227609.832947249, 1917221.753176271 4227617.492096446, 1917235.121718177 4227618.300873388, 1917251.9544811654 4227620.557050384, 1917255.8774667743 4227621.424085116, 1917277.4770812446 4227628.299449901, 1917278.2260505257 4227626.62735363, 1917281.6021859755 4227620.190784347, 1917283.5500708972 4227616.47636294, 1917285.5173666102 4227612.312247744, 1917289.6605616733 4227601.602166957, 1917291.5073006675 4227596.8972269865, 1917295.6390742399 4227584.826120234, 1917301.338163091 4227568.44116419, 1917304.9315883005 4227570.028934983, 1917309.646357188 4227572.126018581, 1917310.9178374491 4227572.6850280585, 1917332.7298373776 4227582.091353162, 1917362.4596341592 4227595.002767287, 1917368.723842986 4227595.62756228, 1917384.6701256677 4227602.887997684, 1917388.273802654 4227604.525588915, 1917412.0681330273 4227615.171101023, 1917426.0329956037 4227622.202761808, 1917430.2374621928 4227624.310505448, 1917432.1691503199 4227625.31920168, 1917434.5255677924 4227619.233556345, 1917436.1546410643 4227617.521049325, 1917439.2053696648 4227615.78746047, 1917443.4875313947 4227615.483451498, 1917446.5399646729 4227616.330848068, 1917448.963272897 4227617.919662041, 1917450.8462838351 4227620.219795664, 1917452.690813688 4227623.7999507515, 1917452.6901771568 4227623.805103309, 1917459.59 4227626.51, 1917467.09 4227629.22, 1917477.75 4227597.65, 1917486.26 4227572.48, 1917492.32 4227574.89, 1917504.33 4227579.63, 1917517.94 4227585.03, 1917544.73 4227595.65, 1917545.23 4227594.62, 1917548.33 4227588.25, 1917558.36 4227567.65, 1917562.82 4227558.83, 1917568.77 4227546.73, 1917569.6 4227545.05, 1917589.87 4227563.12, 1917592.95 4227565.87, 1917601.82 4227573.78, 1917613.41 4227584.12, 1917622.94 4227586.49, 1917640.5 4227590.86, 1917653.65 4227594.14, 1917658.26 4227595.27, 1917659.21 4227595.5, 1917677.03 4227599.85, 1917684.53 4227601.68, 1917697.51 4227604.84, 1917712.48 4227610.92, 1917709.3358393533 4227632.815920136, 1917703.87 4227670.88, 1917731.75 4227677.73, 1917736.85 4227678.31, 1917740.8283705632 4227678.546843472, 1917742.7865538767 4227640.153142869, 1917743.8814096993 4227601.954331124, 1917743.6468405584 4227596.990301251, 1917743.5093750006 4227577.839375007, 1917730.820103682 4227568.292428782, 1917696.9488329336 4227544.8252761, 1917690.7016924792 4227540.493284775, 1917682.0657892593 4227534.524450763, 1917664.6635336524 4227522.445977725, 1917648.2355399781 4227510.881220491, 1917632.9645289632 4227500.389985611, 1917620.348518198 4227491.974042654, 1917610.4996997924 4227485.664999727, 1917592.3062382129 4227474.518318103, 1917547.4372940876 4227447.662593944, 1917525.9156249992 4227434.3568750005, 1917464.4155160945 4227396.106933824, 1917448.9424394877 4227386.744948518, 1917447.85829287 4227386.097321738, 1917386.072835699 4227349.189106465, 1917362.7207964675 4227334.983487332, 1917354.2949772503 4227330.071086705, 1917343.2416634269 4227323.473587919, 1917337.5167828156 4227319.83765517, 1917332.0769520917 4227316.238216716, 1917314.3525875176 4227304.109716082, 1917311.385993518 4227302.017831579, 1917309.3483503815 4227305.502527965, 1917297.0521887126 4227340.465152403, 1917287.8994634342 4227365.908533835, 1917285.3242655972 4227373.065424251, 1917272.63798094 4227408.838903237, 1917269.8532871562 4227416.706217885, 1917269.4937894894 4227417.5170364175, 1917260.5230716527 4227433.654547153, 1917238.6495692832 4227422.58765582, 1917237.9486358385 4227422.247872161, 1917206.075641396 4227406.746571481, 1917197.2787584753 4227394.317182034, 1917186.248290856 4227389.72399537, 1917187.136539104 4227387.371559133, 1917195.8112794217 4227364.182122346, 1917186.94 4227361.51, 1917165.23 4227355.54, 1917152.67 4227352.08, 1917156.62 4227338.06, 1917160.48 4227324.34, 1917134.23 4227317.09, 1917128.16 4227315.41, 1917121.75 4227313.64, 1917111.3522412532 4227315.1815875, 1917105.569540926 4227315.8619051855, 1917097.216288711 4227314.7241590815, 1917066.4280738435 4227288.556371174, 1917033.6895999284 4227260.731002099, 1917002.7467999286 4227234.1418021, 1917003.2465999285 4227233.641202101, 1916987.3250999283 4227220.847802101, 1916959.2010164722 4227196.240538125, 1916945.9676999284 4227184.6620021, 1916892.4515499265 4227140.7326271, 1916888.5456677524 4227138.411229827, 1916869.1692999285 4227126.8952021, 1916819.8771930868 4227096.020857094), (1916749.1531503778 4227141.783814041, 1916717.6139503776 4227118.755063591, 1916709.9682207245 4227112.929075529, 1916701.223413619 4227107.102300451, 1916698.38 4227111.28, 1916685.05 4227130.3, 1916683.09 4227133.1, 1916676.96 4227141.85, 1916680.4820949892 4227144.201449142, 1916690.83 4227151.11, 1916693.56 4227152.94, 1916695.32 4227153.79, 1916701.82 4227156.98, 1916707.45 4227159.74, 1916729.02 4227170.32, 1916732.0916543573 4227171.816877325, 1916735.8115100716 4227168.62638759, 1916736.503169912 4227167.234809815, 1916748.3220821319 4227143.455873098, 1916749.1531503778 4227141.783814041))','ZO32139','"lib_modif"=>"N", "lib_code_insee"=>"38126 / 38229 / 38516", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','N','Naturelle','N',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/N.pdf','2019-12-20','SRID=3945;POLYGON ((1922111.01 4216242.76, 1922145.2362036875 4216217.4655606225, 1922056.2790918474 4216224.761344536, 1922050.3682352272 4216209.561177443, 1922050.36 4216209.54, 1922048.25 4216210.7, 1922042.64 4216212.95, 1922037.58 4216214.97, 1922028.54 4216217.21, 1922019.41 4216219.46, 1922014.58 4216201.17, 1922006.85 4216204.78, 1922000.2 4216208.53, 1921991.43 4216184.72, 1921990.8435703055 4216182.490569672, 1921982.0968736764 4216186.590477792, 1921970.6221772684 4216191.931651251, 1921963.3449585766 4216193.534172767, 1921957.6118897742 4216194.428122774, 1921953.2541564212 4216194.726410508, 1921948.818852173 4216194.914722147, 1921942.1372875383 4216194.66996936, 1921929.8827121926 4216194.386736105, 1921912.9325728503 4216194.326959738, 1921905.5213538615 4216194.713425787, 1921898.6016663352 4216195.149006093, 1921893.1241129262 4216196.271283339, 1921888.7040232532 4216197.504873523, 1921884.4358217684 4216199.26527586, 1921881.3046595317 4216200.7989215655, 1921878.1689587778 4216202.184373401, 1921875.3496343896 4216203.913017298, 1921872.2045301383 4216205.886185703, 1921867.8437689953 4216208.724350503, 1921864.260905421 4216211.421834763, 1921861.7042618978 4216213.1814876655, 1921863.24 4216214.87, 1921876.12 4216229.57, 1921855.99 4216246.89, 1921850.15 4216241.85, 1921841.6 4216234.48, 1921834.01 4216242.27, 1921829.38 4216247.03, 1921818.92 4216257.76, 1921810.92 4216265.83, 1921804.37 4216272.44, 1921801.01 4216275.46, 1921782.88 4216286.72, 1921769.32 4216295.56, 1921760.33 4216300.87, 1921753.41 4216304.86, 1921747.01 4216307.8, 1921738.57 4216311.09, 1921728.59 4216314.42, 1921723.23 4216316.55, 1921716.61 4216319.32, 1921713.21 4216320.75, 1921711.1 4216321.91, 1921720.71 4216336.64, 1921722.49 4216339.71, 1921684.83 4216366.35, 1921688.34 4216375.86, 1921663.26 4216388.41, 1921661.54 4216386.17, 1921655.73 4216378.72, 1921649.16 4216370.53, 1921638.5 4216376.51, 1921630.78 4216381.19, 1921619.3 4216388.12, 1921606.11 4216395.57, 1921592.65 4216403.51, 1921588.81 4216406.04, 1921584.32 4216409.41, 1921581.46 4216411.78, 1921576.26 4216416.65, 1921572.23 4216420.47, 1921562.49 4216429.11, 1921554.51 4216436.18, 1921549.19 4216440.9, 1921545.43 4216446.23, 1921541.67 4216451.43, 1921535 4216458.71, 1921527.47 4216467.1, 1921523.16 4216471.53, 1921521 4216480.93, 1921540.53 4216491.85, 1921553.86 4216499.32, 1921557.4772646995 4216501.341847316, 1921536.67 4216529.6, 1921554.1917570708 4216574.877066556, 1921567.1472540915 4216605.412483083, 1921573.4 4216620.17, 1921575.46 4216619.57, 1921579.58 4216619.54, 1921582.89 4216620.1, 1921587.12 4216620.81, 1921589.29 4216622.51, 1921598.4238897986 4216615.359946015, 1921590.9954333522 4216610.924166479, 1921583.9060617622 4216572.008054926, 1921582.5787574933 4216564.795555851, 1921582.0661036987 4216562.194141055, 1921576.502481457 4216528.21025741, 1921610.0996959426 4216504.095832799, 1921616.8198053963 4216500.007404762, 1921620.4996415635 4216497.742574818, 1921634.1796052966 4216489.135655975, 1921664.1907619154 4216471.398311165, 1921667.38 4216469.51, 1921668.4532034034 4216470.938836307, 1921665.4926778562 4216474.060723319, 1921663.4839204038 4216477.361316145, 1921662.1435697444 4216481.099597053, 1921661.9107503386 4216483.8165544495, 1921662.0984593134 4216486.37705175, 1921663.0530437306 4216489.725362478, 1921664.7229323962 4216493.349800552, 1921667.118737035 4216497.647407437, 1921670.8766666153 4216502.3664603755, 1921676.516800056 4216509.428082363, 1921679.278469156 4216512.958594952, 1921684.5741690472 4216519.1005080305, 1921689.7713557577 4216524.385822562, 1921692.7854868057 4216527.960103192, 1921695.5329684485 4216531.429499818, 1921697.5635071953 4216534.391372465, 1921699.968848996 4216538.661528457, 1921702.2342628592 4216542.677232798, 1921703.816735958 4216546.169196937, 1921707.70447401 4216554.977723403, 1921711.7382650068 4216564.959894889, 1921718.602138493 4216588.589964032, 1921717.8502349055 4216590.961326447, 1921716.8771822283 4216592.566398021, 1921716.0093235332 4216594.484953868, 1921716.7939813635 4216596.331398112, 1921722.6770701592 4216607.272080022, 1921729.222208757 4216619.393032574, 1921740.3225015646 4216635.212151856, 1921752.411393874 4216648.2087662425, 1921757.8297479479 4216653.787018547, 1921766.841136145 4216660.6725500105, 1921776.7536646717 4216668.24765502, 1921778.3459253097 4216669.7374563, 1921787.3789728214 4216678.653924287, 1921790.9046151447 4216682.432872005, 1921798.3473965253 4216692.051985532, 1921802.7511233012 4216704.174887549, 1921803.24244317 4216716.321159499, 1921799.053043305 4216720.047089721, 1921801.544955481 4216731.151150369, 1921803.7656497858 4216741.745167418, 1921805.9006475485 4216745.9053970855, 1921807.8742714925 4216748.87529528, 1921810.8194940838 4216752.7748400355, 1921815.7587798138 4216759.674281581, 1921835.7881589732 4216779.759774184, 1921858.1333200757 4216826.324146111, 1921857.2239938704 4216827.19546955, 1921858.4078286448 4216828.146017083, 1921864.9536432317 4216833.401980166, 1921873.765281874 4216840.457590999, 1921887.4435953475 4216851.801821741, 1921891.9563651346 4216852.458092482, 1921893.4524481222 4216857.769760693, 1921895.4367807494 4216861.290163634, 1921895.6646638114 4216861.802399358, 1921897.9730109745 4216866.991108147, 1921898.220463241 4216867.475982788, 1921900.21 4216871.37, 1921905.77 4216880.59, 1921908.07 4216884.65, 1921910.36 4216888.71, 1921911.3034487562 4216891.8829812715, 1921913.26 4216898.45, 1921914.83 4216903.85, 1921915.5 4216906.87, 1921916.27 4216909.94, 1921916.49 4216911.91, 1921916.89 4216915.6, 1921931.64 4216911.33, 1921935.84 4216914.08, 1921946.66 4216935.63, 1921953.14 4216945.05, 1921956.11 4216969.98, 1921950.8098187635 4216973.283489546, 1921944.0262809228 4216973.649868587, 1921942.1274280923 4216975.662744329, 1921938.92 4216984.31, 1921921.28 4216990.77, 1921917.34 4216992.55, 1921910.8 4216995.45, 1921908.89 4216999.91, 1921908.63 4217017.17, 1921926.79 4217059.25, 1921897.91 4217085.19, 1921897.7 4217090.33, 1921896.73 4217102.98, 1921909.69 4217127.76, 1921917.64 4217138.31, 1921923.04 4217135.87, 1921923.92 4217134.4, 1921936.18 4217127.64, 1921963.74 4217172.46, 1921964.44 4217173.43, 1921975.23 4217176.07, 1921993.36 4217202.8, 1921989.76 4217217.86, 1921986.73 4217230.58, 1921989.3767871573 4217234.655121411, 1921998.3030561595 4217219.060597523, 1922005.1716749973 4217205.6462903535, 1922006.0849785102 4217207.857379067, 1922012.2811235858 4217221.7094599595, 1922017.615193225 4217233.60160531, 1922021.4056688305 4217242.732977121, 1922024.52 4217249.85, 1922025.58 4217251.84, 1922030.64 4217260.23, 1922039.58 4217274.91, 1922044.95 4217283.72, 1922049.83 4217291.46, 1922056.46 4217299.98, 1922067.41 4217314.36, 1922068.8278612508 4217316.418174673, 1922081.8903312704 4217308.719967005, 1922082.79 4217310.82, 1922097.6 4217351.09, 1922118.84 4217349.24, 1922130.27 4217386.31, 1922131.65 4217391.156301964, 1922118.78 4217433.586301964, 1922122.23 4217441.16, 1922135.49 4217472.49, 1922152.39 4217516.32, 1922153.9679611002 4217545.274190789, 1922154.97 4217548.38, 1922160.5883000034 4217564.600530344, 1922129.7890770345 4217585.280422808, 1922142.2222829785 4217657.860912833, 1922156.3401536788 4217712.089161129, 1922161.9937182544 4217734.6269433545, 1922170.9266342141 4217765.366648122, 1922152.552408353 4217804.815820523, 1922138.487754456 4217809.011234417, 1922151.4065622953 4217843.268940252, 1922146.7094898638 4217849.226837971, 1922152.614922868 4217873.435163079, 1922143.3031302968 4217888.762644737, 1922143.8541289722 4217889.292247254, 1922151.8158288419 4217897.119494085, 1922158.6940523193 4217890.609692045, 1922167.4447392537 4217897.265547118, 1922184.7567779552 4217910.327085525, 1922193.2460128106 4217915.332229948, 1922198.3129053111 4217908.723819228, 1922219.3431588188 4217928.676328453, 1922230.7505364364 4217951.318748202, 1922239.4609013856 4217968.40083058, 1922245.4149546106 4217980.072114718, 1922250.234774699 4217987.591846239, 1922255.5656453068 4217995.941989666, 1922256.8975023355 4218008.11757526, 1922266.601086344 4218006.367729585, 1922270.8627849673 4218005.543173149, 1922299.3022832838 4218019.97595951, 1922297.9525762848 4218042.880357969, 1922302.6865799956 4218055.042638081, 1922304.4017681093 4218059.654127097, 1922309.87 4218078.89, 1922313.31 4218078.22, 1922327.71 4218074.98, 1922333.3318123512 4218074.806279155, 1922336.07 4218082.37, 1922332.64 4218092.4, 1922327.26 4218107.72, 1922318.64 4218128.58, 1922316.03 4218133.71, 1922313.69 4218139.81, 1922312.56 4218142.59, 1922311.08 4218147.27, 1922308 4218154.93, 1922304.3469536218 4218164.153892679, 1922321.4186400296 4218155.22319746, 1922322.6787262154 4218154.522045736, 1922329.1894857783 4218151.244226542, 1922331.6653588845 4218156.564631891, 1922343.848083177 4218184.779967706, 1922368.886550055 4218189.229708956, 1922388.0809104391 4218192.6443790225, 1922392.3139054142 4218204.446914206, 1922392.945444998 4218205.737081201, 1922393.4168459876 4218206.53751226, 1922395.976631351 4218205.124365412, 1922401.4170306774 4218201.907554411, 1922406.2671283835 4218199.171558218, 1922411.2471722958 4218196.075236098, 1922417.0375723762 4218192.858105632, 1922424.1789036267 4218189.809640554, 1922430.5202852779 4218187.102300958, 1922434.5118497373 4218186.2983991355, 1922441.2 4218185.09, 1922451.09 4218182.82, 1922454.72 4218181.36, 1922461.15 4218178.79, 1922467.39 4218176.29, 1922473.43 4218172.57, 1922480.53 4218168.04, 1922498.36 4218154.71, 1922518.32 4218140.11, 1922519.4752428364 4218138.921162327, 1922514.3320584625 4218125.320898662, 1922512.928205699 4218119.828876027, 1922513.3630591366 4218117.098029963, 1922514.3630050037 4218114.34960256, 1922512.94 4218114.05, 1922509.01 4218113.15, 1922501.84 4218111.5, 1922495.7885116017 4218111.069038135, 1922477.0769423319 4218110.185593312, 1922473.3195710613 4218109.794487753, 1922472.4704558253 4218117.164008182, 1922394.78 4218132.03, 1922376.47 4218130.56, 1922395.3006202695 4218034.706842584, 1922404.2175891474 4217989.315944509, 1922407.69 4217971.64, 1922421.89 4217966.03, 1922440.36 4217958.97, 1922455.6 4217953.26, 1922471.16 4217946.26, 1922466 4217925.45, 1922466.0018714003 4217925.448666192, 1922459.233518744 4217898.119766595, 1922453.94 4217876.64, 1922434.74 4217827.34, 1922433.133341448 4217826.564717974, 1922431.71 4217825.85, 1922415.08 4217808.87, 1922413.6856803733 4217808.9705239665, 1922395.6969466412 4217810.267444335, 1922384.01 4217811.11, 1922378.09 4217811.55, 1922361.65 4217809.5, 1922330.26 4217804.33, 1922322.8 4217747.82, 1922303.5 4217748.08, 1922317.26 4217660.52, 1922317.24 4217628.67, 1922317.58 4217601.48, 1922317.9 4217587.5, 1922318.4466982197 4217554.354348215, 1922331.0741192603 4217553.294382931, 1922340.092056821 4217553.145158223, 1922353.2921942964 4217551.29018937, 1922356.9907852423 4217550.725910418, 1922359.3181270054 4217550.602782178, 1922361.6411033052 4217550.692764211, 1922364.4696335122 4217551.221259537, 1922370.6941582614 4217552.12411923, 1922378.1154831399 4217552.9707147805, 1922381.0449224138 4217552.794848656, 1922388.7000796811 4217551.154774688, 1922394.4001546577 4217550.190501601, 1922432.88 4217366.28, 1922411.3053918064 4217371.321847533, 1922376.15 4217379.56, 1922358.73 4217398.55, 1922354.03 4217412.33, 1922353.09 4217423.3, 1922342.19 4217443.26, 1922321.0612768994 4217412.287534249, 1922312.7621932821 4217396.555891387, 1922305.4554007137 4217382.714426891, 1922283.7334974692 4217394.271030131, 1922284.0033808798 4217349.845361969, 1922284.220391651 4217291.541612602, 1922316.8 4217288.94, 1922325.76 4217275.59, 1922341.74 4217260.86, 1922363.6 4217240.83, 1922386.61 4217221.84, 1922407.98 4217210.3, 1922397.2 4217175.52, 1922389.66 4217174.05, 1922384.37 4217173.02, 1922357 4217167.72, 1922348.74 4217164.68, 1922338.94 4217161.01, 1922329.39 4217156.92, 1922315.32 4217150.34, 1922305.56 4217142.53, 1922302.47 4217149.54, 1922299.1 4217157.12, 1922270.49 4217132.27, 1922256.24 4217149.21, 1922242.73 4217167.68, 1922231.9 4217163.88, 1922221.41 4217160.42, 1922212.18 4217158.33, 1922207.4641777053 4217157.224741237, 1922179.9288607764 4217190.849229066, 1922178.11 4217190.58, 1922173.17 4217189.7, 1922168.16 4217188.4, 1922156.72 4217185.12, 1922149.91 4217182.98, 1922148.01 4217181.93, 1922144.76 4217178.25, 1922140.3 4217172.86, 1922136.34 4217167.35, 1922131.48 4217159.43, 1922127.54 4217152.99, 1922124.09 4217145.61, 1922120.93 4217137.96, 1922122.44 4217080, 1922141.61 4217070.37, 1922140.3 4217068.12, 1922151.5 4217065.05, 1922124.15 4217019.98, 1922114.25 4217025.17, 1922101.28 4217031.98, 1922094.54 4217021.12, 1922085.35 4217005.39, 1922074.09 4216985.87, 1922073.59 4216973.83, 1922073.15 4216960.66, 1922072.36 4216949.97, 1922071.97 4216942.95, 1922077.07 4216928.13, 1922082.77 4216925.29, 1922095.49 4216919.51, 1922110.25 4216908.49, 1922116.6 4216906.68, 1922095 4216857.15, 1922093.8641006318 4216854.490444081, 1922089.8961225725 4216861.946062486, 1922086.8901050074 4216868.874220408, 1922085.48 4216868.19, 1922080.07 4216865.38, 1922066.15 4216857.46, 1922062 4216854.32, 1922059.47 4216852.07, 1922057.31 4216849.03, 1922055.79 4216846.47, 1922054.13 4216842.62, 1922051.96 4216836.27, 1922050.66 4216831.44, 1922050.77 4216826.06, 1922050.72 4216819.66, 1922051.03 4216808.43, 1922050.98 4216802.32, 1922050.83 4216799.85, 1922050.52 4216794.72, 1922049.78 4216788.41, 1922049.09 4216783.81, 1922048.47 4216781.9, 1922047.62 4216779.28, 1922044.07 4216772.84, 1922040.06 4216766.1, 1922037.01 4216761.4, 1922031.09 4216752.33, 1922025.48 4216743.86, 1922013.66 4216726.3, 1922001.96 4216709.01, 1921987.32 4216694.76, 1921957.91 4216669.4, 1921937.71 4216651.97, 1921929.63 4216647.54, 1921925.58 4216651.02, 1921918.98 4216641.31, 1921918.77 4216636.76, 1921917.2 4216625.59, 1921915.37 4216610.63, 1921912.25 4216586.71, 1921915.79 4216584.54, 1921937.7 4216581.24, 1921945.44 4216575.47, 1921948.94 4216573.04, 1921956.56 4216565.82, 1921964.72 4216558.28, 1921956.95 4216550.32, 1921945.11 4216539.54, 1921925.46 4216522.14, 1921907.15 4216506.26, 1921894.35 4216495.19, 1921886.57 4216489.29, 1921888.16 4216476.91, 1921883.53 4216477.63, 1921878.91 4216478.36, 1921872.04 4216479.44, 1921867.15 4216481.23, 1921863.87 4216482.42, 1921859.12 4216484.52, 1921856.76 4216486.18, 1921854.24 4216487.77, 1921851.22 4216490.71, 1921848.41 4216494.19, 1921847.21 4216496.08, 1921845.11 4216499.18, 1921843.42 4216501.98, 1921841.5 4216505.86, 1921839.4156826187 4216510.651411082, 1921836.36 4216507.54, 1921822.39 4216494.65, 1921818.06 4216490.38, 1921809.66 4216479.1, 1921769.35 4216497.39, 1921724.641477671 4216531.667993463, 1921679.7 4216464.18, 1921678.5759487923 4216462.306564141, 1921693.8965201606 4216451.282788546, 1921699.2108722029 4216448.135799118, 1921703.270846833 4216445.742506615, 1921709.082380705 4216443.084854392, 1921716.167363894 4216439.529041784, 1921721.5289174677 4216437.033704088, 1921725.6662305996 4216434.20030478, 1921729.8869707633 4216430.952100777, 1921733.8988105273 4216427.314217128, 1921738.5039269684 4216423.224862522, 1921742.6973208564 4216418.511310964, 1921747.9288682917 4216413.081948347, 1921753.3877556534 4216407.308721215, 1921757.957929083 4216402.3201162275, 1921761.0127741492 4216399.547642798, 1921764.481851727 4216396.481440317, 1921769.612533537 4216392.482690178, 1921776.3756859996 4216387.150329638, 1921781.7554377748 4216383.191483426, 1921792.9060343176 4216375.098550506, 1921798.9752952417 4216370.829301094, 1921804.0214236833 4216367.903022942, 1921810.1647069564 4216364.320618248, 1921815.0042881004 4216361.885389698, 1921819.3182496505 4216359.467062616, 1921823.7374647164 4216356.179670525, 1921828.7379188116 4216352.706012717, 1921834.5097722665 4216349.785230596, 1921840.921543005 4216346.710762786, 1921850.816951015 4216341.786893319, 1921855.5458518 4216339.585573918, 1921858.629914244 4216337.272134673, 1921861.5268317668 4216335.166411054, 1921865.8147728948 4216331.355933464, 1921867.9446056886 4216328.759601391, 1921870.1055011724 4216326.499460286, 1921871.9943981713 4216323.698612976, 1921873.9701926676 4216320.613171942, 1921877.3878557142 4216316.415417813, 1921882.797624825 4216308.720081692, 1921889.7012909986 4216299.980458056, 1921893.1946274636 4216295.410039155, 1921896.3846425926 4216292.132556397, 1921899.4964394257 4216289.726942459, 1921907.0685813953 4216284.157280816, 1921913.922305028 4216279.540211488, 1921920.503313201 4216275.287934997, 1921924.890546712 4216273.265322097, 1921923.6567444885 4216279.754275665, 1921917.7182628305 4216290.004111423, 1921910.7966385914 4216303.741021356, 1921907.5683314821 4216309.700063765, 1921905.710890767 4216312.5587031, 1921904.2520462116 4216314.92589482, 1921906.07 4216315.51, 1921912.49 4216309.68, 1921914.39 4216307.93, 1921916.99 4216305.1, 1921920.68 4216300.89, 1921921.94 4216299.45, 1921924 4216296.29, 1921927.45 4216291.27, 1921930.5 4216287.04, 1921932.86 4216283.29, 1921934.97 4216279.74, 1921936.71 4216276.38, 1921939.62 4216270.52, 1921942.42 4216265.78, 1921943.29 4216264.32, 1921950.07 4216257.15, 1921957.35 4216254.87, 1921967.79 4216252.14, 1921976.18 4216249.94, 1921978.08 4216249.58, 1921991.79 4216249, 1922016.81 4216248.38, 1922033.43 4216247.85, 1922038.06 4216247.93, 1922048.98 4216249.04, 1922058.8 4216249.94, 1922065.05 4216250.52, 1922069.08 4216250, 1922083.33 4216247.94, 1922101.11 4216244.75, 1922111.01 4216242.76))','ZO32416','"lib_modif"=>"N", "lib_code_insee"=>"38529", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UD3','Pavillonnaire en évolution modérée','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD3.pdf','2019-12-20','SRID=3945;POLYGON ((1916616.02 4217136.32, 1916617.6 4217137.26, 1916621.78 4217139.8, 1916625.37 4217141.37, 1916633.06 4217145.06, 1916652.79 4217153.93, 1916660.83 4217157.54, 1916661.48 4217157.84, 1916679.7 4217165.41, 1916692.25 4217170.08, 1916696.82 4217171.61, 1916703.88 4217173.95, 1916705.49 4217174.51, 1916711.59 4217173.57, 1916712.03 4217173.06, 1916712.75 4217172.63, 1916713.9 4217172.32, 1916724.13 4217169.66, 1916733.98 4217166.09, 1916744.58 4217161.43, 1916768.25 4217147.11, 1916802.59 4217125.15, 1916817.6 4217114.82, 1916823.6542403705 4217110.631022995, 1916827.4503588348 4217205.142152674, 1916849.2559833096 4217196.978502913, 1916871.9210834475 4217188.573349432, 1916872.8915087706 4217188.202074467, 1916874.3852289827 4217187.959504102, 1916875.885169734 4217187.751939669, 1916875.75 4217181.23, 1916875.74 4217180.58, 1916876.23 4217169.03, 1916876.3446511375 4217167.237409501, 1916877.8858117305 4217167.326090437, 1916898.948766839 4217168.5680790255, 1916903.5858043854 4217105.777639642, 1916908.598658696 4217105.763575554, 1916912.3507032963 4217105.649775121, 1916922.3803157469 4217076.2642555935, 1916934.0459904096 4217043.044809129, 1916933.2666778425 4217038.000508762, 1916931.48 4217038.33, 1916931.36 4217037.71, 1916926.0699999277 4217038.400002127, 1916922.7899999276 4217016.7700021295, 1916921.9499999275 4217008.390002127, 1916918.9699999276 4216990.490002129, 1916910.0399999276 4216991.720002127, 1916907.4099999275 4216986.540002129, 1916909.1599999275 4216984.400002128, 1916916.9099999275 4216983.32000213, 1916917.8999999275 4216983.180002128, 1916914.2999999276 4216960.540002128, 1916894.983163823 4216962.31348237, 1916896.1954011656 4216941.550743867, 1916897.161659572 4216925.020042868, 1916897.27 4216923.15, 1916931.3476802898 4216921.077802227, 1916963.9445901632 4216919.157724728, 1916996.1710966714 4216917.24757797, 1917028.35 4216915.32, 1917028.36 4216920.91, 1917028.2439030057 4216933.538759071, 1917028.4285185316 4216950.078042182, 1917032.6435174835 4216975.028147023, 1917033.890476773 4216982.501307767, 1917034.6854287772 4216987.333361651, 1917037.556059689 4216997.21665581, 1917037.8168003615 4216998.10673251, 1917039.052088932 4217003.258977999, 1917041.4299999275 4217009.720002127, 1917040.8399999277 4217010.000002127, 1917040.8799999275 4217011.230002128, 1917040.9699999276 4217011.580002127, 1917041.6099999277 4217013.930002129, 1917041.4699999276 4217017.320002129, 1917041.6699999275 4217020.870002128, 1917042.6899999275 4217025.2300021285, 1917043.6099999277 4217027.430002129, 1917043.6199999277 4217028.220002129, 1917044.0099999276 4217030.490002128, 1917043.9299999275 4217032.190002129, 1917042.8699999277 4217034.420002128, 1917040.5699999277 4217034.400002128, 1917039.9699999276 4217034.390002129, 1917038.6799999275 4217037.19000213, 1917037.1199999277 4217039.210002128, 1917036.5099999276 4217040.800002129, 1917036.2699999276 4217041.770002129, 1917035.7199999276 4217043.870002128, 1917034.9499999275 4217050.860002129, 1917034.6899999275 4217051.930002127, 1917034.2099999276 4217053.910002129, 1917034.6899999275 4217055.580002128, 1917034.2199999276 4217056.360002129, 1917032.7599999276 4217058.760002127, 1917032.6299999275 4217059.070002129, 1917031.9996850016 4217061.078298695, 1917031.3703044434 4217062.179287916, 1917030.3301649601 4217063.140762719, 1917028.9918969504 4217065.723429536, 1917028.773004589 4217067.334345207, 1917028.8035025632 4217067.874626971, 1917029.6250173822 4217068.824839553, 1917061.9365619486 4217105.777227941, 1917063.378845155 4217107.416682497, 1917070.2231993333 4217107.671346206, 1917071.62 4217096.7, 1917074.2999999276 4217079.970002128, 1917071.06074293 4217079.3960476015, 1917076.1256999276 4217051.043402128, 1917085.994832211 4217009.9108213475, 1917087.789067234 4217002.447334944, 1917092.3999999275 4217003.910002127, 1917122.2999999276 4217010.35000213, 1917128.2599999276 4217011.630002129, 1917143.21392625 4217014.852623754, 1917159.3516546304 4217018.322320701, 1917162.5867071045 4217019.017874092, 1917172.3339576535 4217021.130206419, 1917196.6525037764 4217026.351945952, 1917208.1716362035 4216995.063812492, 1917208.832066488 4216995.123258578, 1917249.128588302 4216999.499886179, 1917287.0539482527 4217003.418156708, 1917311.019998316 4217005.838397464, 1917315.5926620932 4217006.344614418, 1917326.009595525 4217007.445966355, 1917361.0199999274 4217016.250002129, 1917366.4199999273 4217017.610002128, 1917370.2600524568 4217016.58314186, 1917368.72 4217012.55, 1917365.8 4217000.72, 1917364.43 4216991.6, 1917363.85 4216983.83, 1917364.14 4216978.57, 1917364.28 4216977.19, 1917365.71 4216967.91, 1917369.58 4216951.39, 1917373.39 4216940.11, 1917374.55 4216935.6, 1917375.28 4216932.37, 1917375.77 4216930.7, 1917376.16 4216929.82, 1917376.2471649523 4216925.870261718, 1917376.16 4216920.07, 1917375.51 4216919.09, 1917374.72 4216917.29, 1917374.21 4216915.79, 1917373.74 4216911.69, 1917373.9 4216908.38, 1917373.13 4216903.13, 1917371.74 4216895.93, 1917370.54 4216891.5, 1917366.72 4216885.92, 1917360.9632874252 4216876.679944721, 1917364.348809398 4216869.483020467, 1917343.475028113 4216833.931320632, 1917321.1638675882 4216757.097152759, 1917304.1184484349 4216705.332810976, 1917297.4069855192 4216685.52749526, 1917317.903727048 4216679.975877688, 1917310.4388143355 4216656.779302349, 1917304.2983637843 4216637.744321269, 1917318.4194817557 4216630.187239324, 1917307.9276932403 4216600.979739216, 1917300.92662212 4216582.245700171, 1917274.3181967011 4216510.738665734, 1917269.313070979 4216497.175399367, 1917269.05 4216495.99, 1917268.3267049023 4216493.22354313, 1917251.3653229596 4216498.112452454, 1917227.5272999275 4216506.297602128, 1917211.3278968178 4216517.218230723, 1917209.6983459885 4216518.273645574, 1917193.2279999272 4216528.941202129, 1917179.82725915 4216536.657337489, 1917167.9229999275 4216539.36940213, 1917169.805138977 4216523.772702051, 1917166.8099999276 4216523.89000213, 1917113.8499999277 4216537.370002131, 1917107.4790015712 4216506.024469799, 1917097.11 4216516.92, 1917088.21 4216526.28, 1917077.74 4216537.3, 1917074.38 4216540.82, 1917071.871111362 4216542.656808081, 1917072.9742999275 4216545.757602131, 1917078.582850353 4216551.555906481, 1917084.3919999276 4216558.25440213, 1917096.2994216215 4216572.7111782525, 1917102.9388831113 4216578.034439741, 1917108.754403907 4216585.943281334, 1917111.1256742543 4216591.401067599, 1917112.5340742539 4216601.72461407, 1917112.3581366418 4216611.401626007, 1917112.2319910706 4216621.326572474, 1917110.511866295 4216631.734372477, 1917106.3142039073 4216653.160214068, 1917105.9995904623 4216664.798882777, 1917105.981441269 4216670.705879405, 1917111.5699999277 4216670.440002129, 1917127.0099999276 4216664.570002128, 1917124.9099999275 4216671.15000213, 1917129.64 4216711.45, 1917121.16 4216712.52, 1917125.39 4216727.68, 1917128.9 4216730.25, 1917130.1047392325 4216736.738683235, 1917120.447995948 4216737.134643722, 1917123.8328662948 4216757.666184413, 1917126.762207887 4216781.424118944, 1917122.59 4216780.46, 1917114.59 4216780.83, 1917114.43 4216779.44, 1917114.4234813226 4216779.439931042, 1917098.36 4216779.27, 1917081.15 4216781.56, 1917078.3636283423 4216781.227733739, 1917076.9901999275 4216785.090602129, 1917075.5992999275 4216796.89820213, 1917074.7049441263 4216824.810286185, 1917089.65 4216823.76, 1917090.75 4216823.68, 1917091.02 4216831.15, 1917089.64 4216831.07, 1917088.14 4216836.54, 1917088.78 4216846.11, 1917088.12 4216854.37, 1917088.27 4216856.03, 1917088.3 4216860.82, 1917082.53 4216859.37, 1917064.8 4216854.9, 1917051.28 4216851.54, 1917052.84 4216841.13, 1917053.79 4216834.71, 1917052.57 4216833.12, 1917053.26 4216823.12, 1917051.05 4216821.27, 1917032.19 4216822.22, 1916993.0239416417 4216822.850898467, 1916992.8299999277 4216817.49000213, 1916991.3599999277 4216777.15000213, 1916988.9499999275 4216774.07000213, 1916987.6399999275 4216772.180002128, 1916987.5882032383 4216769.745515987, 1916976.2937458064 4216769.998733078, 1916968.6483277662 4216770.395059362, 1916952.5937195239 4216772.304169161, 1916920.612747362 4216775.317205241, 1916913.4185776287 4216775.574410175, 1916910.3845999276 4216775.682880514, 1916895.4699164121 4216773.501877402, 1916890.8566741357 4216772.687183471, 1916891.4700417863 4216769.346637992, 1916891.5297641917 4216768.995984858, 1916896.6985990366 4216741.866114173, 1916899.2386890482 4216729.086767391, 1916901.7782801345 4216715.7467019325, 1916913.990895128 4216710.853255751, 1916923.6956917453 4216732.746915276, 1916921.8250309143 4216733.42876709, 1916923.8712577405 4216739.120594599, 1916925.6064618984 4216743.41149961, 1916929.4897030285 4216755.814722732, 1916962.4707429204 4216747.070813461, 1916963.574899197 4216751.262022514, 1916965.4053814516 4216750.630034499, 1916993.103632207 4216742.140563438, 1916993.6738059002 4216741.970159222, 1916995.4941532295 4216741.418025572, 1916998.978318439 4216754.662682234, 1917016.8027946267 4216748.2627803795, 1917022.9141184292 4216746.056486842, 1917034.4267828758 4216741.8936733045, 1917054.0909943993 4216734.792452725, 1917054.0918828442 4216734.792131886, 1917056.5422865797 4216733.899643259, 1917080.9683655628 4216725.0726810405, 1917085.5498970568 4216723.407455633, 1917090.0708297577 4216721.782507036, 1917089.9103161676 4216721.532907487, 1917076.0935463142 4216700.072761144, 1917067.1962151662 4216686.2926185625, 1917064.2402293216 4216681.682819723, 1917061.187827973 4216680.714782948, 1917053.9516346501 4216678.390094074, 1917049.397960561 4216676.953325266, 1917030.8021014319 4216649.00413191, 1917013.39 4216650.2, 1916998.2559327243 4216651.233946431, 1916993.353351492 4216651.698770909, 1916974.5836148204 4216653.006205876, 1916953.3928422418 4216654.476084459, 1916918.2151120384 4216657.088846301, 1916906.419108323 4216657.899593805, 1916900.2845663119 4216656.273919776, 1916885.6183964084 4216647.712274749, 1916871.2968471334 4216643.902631454, 1916853.487576783 4216645.11915166, 1916849.7045255322 4216644.112139414, 1916837.101016586 4216636.769153477, 1916834.413685822 4216630.467949875, 1916833.9426308454 4216629.357735668, 1916830.4788387264 4216627.344849976, 1916826.7097932412 4216633.356239766, 1916809.9458493588 4216656.037741596, 1916809.59 4216655.78, 1916807.2199999276 4216653.95000213, 1916739.6399999275 4216601.690002131, 1916722.1999999275 4216561.84000213, 1916753.1299999275 4216543.060002129, 1916782.5799999277 4216525.170002132, 1916782.8999999275 4216524.970002131, 1916785.9436117685 4216522.680772319, 1916776.7766877192 4216513.00223443, 1916757.0490270609 4216494.509227193, 1916753.1456521864 4216493.211955582, 1916748.6435365642 4216493.716241527, 1916738.240375977 4216496.827252807, 1916724.7371406136 4216501.842101004, 1916713.2331756395 4216504.7539755665, 1916698.2271999277 4216507.66900213, 1916671.0153999275 4216511.695602131, 1916653.0064999275 4216513.61220213, 1916641.9009999277 4216514.623002131, 1916628.5471306988 4216514.689032551, 1916628.49 4216511.84, 1916627.57 4216510.3, 1916607.83 4216477.42, 1916598.24 4216461.51, 1916586.17 4216441.48, 1916579.94 4216431.19, 1916562.5099999276 4216441.900002129, 1916560.2799999276 4216443.11000213, 1916557.3799999277 4216444.29000213, 1916554.3399999277 4216445.09000213, 1916553.9199999275 4216445.170002132, 1916544.26 4216446.91, 1916492.34 4216445.01, 1916490.27 4216444.98, 1916489.6 4216439.6, 1916487.36 4216432.92, 1916483.49 4216425.67, 1916479.12 4216420.82, 1916478.74 4216420.47, 1916475.55 4216417.65, 1916475.15 4216417.31, 1916474.8899999997 4216417.05, 1916466.8 4216414.02, 1916450.05 4216406.9, 1916453.14 4216399.77, 1916457.13 4216390.49, 1916461.79 4216380.79, 1916463.52 4216376.79, 1916465.95 4216370.46, 1916467.35 4216365.89, 1916469.14 4216359.18, 1916470.67 4216350.38, 1916472.39 4216335.96, 1916472.96 4216331.24, 1916473.9 4216325.03, 1916475.16 4216318.09, 1916476.35 4216312.71, 1916477.88 4216306.62, 1916479.6 4216300.5, 1916481.67 4216292.7, 1916481.87 4216291.96, 1916483.35 4216284.93, 1916485.26 4216270.23, 1916485.79 4216266.13, 1916486.09 4216263.43, 1916486.85 4216254.04, 1916486.63 4216251.75, 1916486.18 4216249.07, 1916485.7099999278 4216246.78000213, 1916485.7059480494 4216246.7817877, 1916485.66 4216246.56, 1916477.9 4216226.34, 1916473.52 4216212.91, 1916471.9 4216206.55, 1916470.04 4216199.32, 1916467.41 4216185.45, 1916468.12 4216176.03, 1916468.03 4216175.02, 1916462.7721877373 4216175.030920815, 1916462.7705610367 4216175.006520305, 1916458.3999999275 4216175.040002131, 1916458.3921464463 4216175.040516708, 1916455.3422680593 4216173.464417902, 1916428.0646981471 4216159.4004203575, 1916394.7203133588 4216142.210424346, 1916357.7399999278 4216123.14000213, 1916354.03 4216119.98, 1916346.89 4216132.8, 1916339.84 4216144.59, 1916329.9531678888 4216159.52755306, 1916326.37 4216165.8, 1916323.5 4216170.36, 1916321.36 4216175.07, 1916320.79 4216177.8, 1916319.77 4216185.72, 1916319.45 4216188.16, 1916319.14 4216190.04, 1916318.13 4216194.01, 1916314.78 4216202.48, 1916310.87 4216208.88, 1916303.99 4216219.82, 1916302.13 4216222.19, 1916301.89 4216222.53, 1916298.88 4216227.05, 1916296.78 4216229.4, 1916290.47 4216236.3, 1916286.38 4216240.44, 1916276.29 4216249.87, 1916271.76 4216253.8, 1916266.17 4216256.7, 1916260.25 4216260.73, 1916256.51 4216263.74, 1916255.29 4216265.21, 1916250.32 4216271.44, 1916249.23 4216272.05, 1916248.14 4216274.4, 1916247.55 4216276.37, 1916247.83 4216277.86, 1916247.81 4216284.36, 1916249.27 4216294.05, 1916254.52 4216317.76, 1916260.98 4216347.32, 1916263.35 4216359.25, 1916262.84 4216360.19, 1916261.14 4216361.06, 1916257.3 4216361.61, 1916248.54 4216361.73, 1916246.92 4216361.89, 1916209.63 4216365.6, 1916208.98 4216365.65, 1916208.35 4216365.72, 1916206.23 4216365.99, 1916183.15 4216369.98, 1916164.16 4216374.27, 1916149.37 4216379.12, 1916130.82 4216385.69, 1916116.38 4216390.96, 1916110.67 4216393.03, 1916101.26 4216395.99, 1916096.3 4216397.21, 1916092.02 4216398.12, 1916082.64 4216398.37, 1916077.75 4216397.23, 1916068.18 4216402.65, 1916068.35 4216404.1, 1916068.25 4216406.92, 1916068.24 4216407.3, 1916067.53 4216417.41, 1916067.56 4216422.05, 1916067.56 4216422.39, 1916067.59 4216429.58, 1916068.52 4216436.95, 1916068.68 4216437.69, 1916070.33 4216444.9, 1916072.13 4216451.63, 1916072.91 4216453.99, 1916077.22 4216466.41, 1916078.92 4216470.77, 1916084.03 4216483.78, 1916084.44 4216484.8, 1916084.53 4216485.03, 1916084.62 4216485.27, 1916088.4 4216494.62, 1916090.09 4216499.5, 1916091.48 4216503.51, 1916094.68 4216512.24, 1916097.23 4216520.88, 1916098.42 4216524.93, 1916100.57 4216532.7, 1916101.76 4216537.45, 1916102.81 4216541.67, 1916103.58 4216544.8, 1916105.2 4216552.48, 1916106.45 4216559.81, 1916107.04 4216563.62, 1916107.09 4216563.93, 1916107.4 4216565.96, 1916109.57 4216579.84, 1916113.46 4216611.28, 1916113.69 4216613.09, 1916116.07 4216634.97, 1916119.1 4216661.22, 1916122.16 4216689.59, 1916124.86 4216717.6, 1916125.62 4216727.37, 1916125.82 4216729.89, 1916127.31 4216748.95, 1916127.43 4216754.9, 1916127.05 4216758.44, 1916125.23 4216761.58, 1916132.2082289432 4216765.2767125545, 1916139.0752928103 4216762.999644379, 1916145.5137055186 4216760.787630792, 1916153.3594880588 4216754.478651018, 1916182.4778562489 4216726.411779457, 1916190.323638789 4216718.727765629, 1916193.8825504566 4216713.389398127, 1916198.5416924702 4216709.110594237, 1916201.2999999279 4216711.40000213, 1916230.85 4216682.91, 1916233.59 4216680.89, 1916229.31 4216672.32, 1916227.11 4216666.16, 1916213.76 4216631.4, 1916211.72 4216625.75, 1916202.13 4216600.64, 1916196.05 4216584.66, 1916216.95 4216576.32, 1916241.66 4216566.39, 1916264.08 4216557.31, 1916260.14 4216520.24, 1916287.26 4216526.72, 1916303.27 4216551.22, 1916319.08 4216558.66, 1916327.47 4216562.57, 1916335.8813053006 4216566.4955167845, 1916338.6912884922 4216567.806922778, 1916350.74 4216573.43, 1916354.1630164976 4216577.5617747875, 1916348.7950243372 4216583.021930489, 1916319.200091381 4216607.762265765, 1916316.8538619957 4216610.045915457, 1916320.811295178 4216614.887402588, 1916320.8262335435 4216614.8735042345, 1916320.8275241316 4216614.875077032, 1916341.850614339 4216638.909739931, 1916360.9110313614 4216660.735684129, 1916370.075635422 4216671.3133893665, 1916376.845850868 4216678.931730306, 1916379.4606045603 4216682.611309976, 1916379.6408850185 4216682.811664366, 1916388.2848579916 4216692.559558252, 1916395.5459177517 4216700.58749764, 1916401.615221503 4216707.175672776, 1916402.907461818 4216708.681166754, 1916438.8848253884 4216678.624448187, 1916444.5521658515 4216687.396512653, 1916452.1832462936 4216699.314157947, 1916477.4965942546 4216738.846633668, 1916481.3741465658 4216744.866427838, 1916489.379977028 4216757.336839777, 1916495.590292597 4216765.195813929, 1916499.599678162 4216762.150319189, 1916504.179242781 4216758.2638387345, 1916520.6966192347 4216744.911966288, 1916546.972790776 4216723.706153901, 1916570.7593252945 4216704.514298774, 1916580.017781964 4216697.0516259605, 1916595.5357088544 4216684.5207072245, 1916629.6799999275 4216676.530002128, 1916632.6999999275 4216675.830002128, 1916633.1799999275 4216675.710002129, 1916646.1699999277 4216678.050002127, 1916683.6099999277 4216684.66000213, 1916684.665141174 4216682.730559405, 1916694.216532906 4216689.426095778, 1916721.1382486206 4216708.302752255, 1916724.031909369 4216710.341344939, 1916722.8230027012 4216712.573891823, 1916709.7070853882 4216736.629260147, 1916708.2584684337 4216739.342294166, 1916691.0558926752 4216770.014668636, 1916676.9003497956 4216794.941461528, 1916668.05 4216810.17, 1916641.2299999278 4216867.080002128, 1916616.2699999276 4216884.10000213, 1916633.829999928 4216915.330002127, 1916635.0599999279 4216917.510002131, 1916636.213552568 4216919.739757137, 1916604.45 4216938.19, 1916614.41 4216966.35, 1916601.49 4216974.88, 1916586 4216985.14, 1916580.68 4216988.63, 1916573.59 4216994.92, 1916570.32 4216997.86, 1916530.9179874193 4217032.887346488, 1916563.1508749996 4217079.319869446, 1916581.4599964393 4217066.500104745, 1916585.419996439 4217063.060104745, 1916589.8399964392 4217059.220104744, 1916592.0799964392 4217057.280104745, 1916602.9599964388 4217047.690104747, 1916606.9599964386 4217046.750104747, 1916610.0899964387 4217044.080104747, 1916611.3399964387 4217045.620104747, 1916614.2599964386 4217043.640104745, 1916624.0099964384 4217057.770104745, 1916628.0299964384 4217067.1401047455, 1916637.399996438 4217080.720104745, 1916639.0499964382 4217079.590104746, 1916643.4899964381 4217077.3901047455, 1916655.6499964378 4217069.100104745, 1916660.5417238653 4217066.259524622, 1916660.513182248 4217065.678070208, 1916660.5510310002 4217056.637713913, 1916661.5286238634 4217046.834320834, 1916662.855710871 4217014.698281207, 1916663.5355342356 4217008.526396414, 1916663.8739034268 4217005.848851849, 1916664.4516237173 4217001.277301413, 1916665.5910369845 4216993.465572923, 1916667.408122407 4216985.761217865, 1916669.3442428636 4216975.585936023, 1916671.649434862 4216963.566470959, 1916675.6279667665 4216950.656226685, 1916678.3090692314 4216950.709349332, 1916745.6568433193 4216938.662455412, 1916789.4052835286 4216930.839523681, 1916832.6899999275 4216922.63000213, 1916833.0499999276 4216927.870002129, 1916835.5199999278 4216959.010002128, 1916823.1699999275 4216960.520002129, 1916824.6399999275 4216998.910002127, 1916826.2099999276 4217039.360002128, 1916828.3799999275 4217100.09000213, 1916827.8899999275 4217100.430002128, 1916828.5299999276 4217102.570002129, 1916829.3768532632 4217104.05322302, 1916825.0080850485 4217107.061656119, 1916824.1999999275 4217105.520002129, 1916809.4299999275 4217056.440002129, 1916798.9899999276 4217019.9800021285, 1916748.6446877713 4217035.185357244, 1916743.4219211745 4217024.623959476, 1916743.41910572 4217024.625636769, 1916704.9704866358 4217047.53120537, 1916665.379353509 4217071.520078029, 1916664.8789343035 4217071.820694257, 1916660.7468234915 4217073.005807538, 1916660.5511424788 4217078.207870674, 1916656.5551547015 4217096.873810472, 1916638.0557780575 4217112.154540981, 1916631.7464937149 4217116.982670893, 1916624.3316999276 4217123.412202635, 1916616.02 4217136.32), (1916406.24 4216471.02, 1916410.23 4216472.98, 1916411.65 4216473.87, 1916417.71 4216475.69, 1916434.22 4216480.66, 1916437.28 4216471.69, 1916457.53 4216471.42, 1916460.48 4216462.3, 1916475.6211798487 4216466.227539866, 1916479.64 4216467.27, 1916485.56 4216463.66, 1916487.44 4216462.51, 1916489.0453493276 4216462.304260783, 1916489.068593456 4216463.12924136, 1916490.5798999276 4216474.8346021315, 1916493.091499928 4216486.339002129, 1916497.2028662013 4216496.541049242, 1916504.8159837842 4216506.439932157, 1916512.2267675728 4216513.837570207, 1916490.5175999277 4216517.458802129, 1916463.0061999278 4216522.086202128, 1916401.0315916855 4216531.734421725, 1916391.2806522825 4216535.155345359, 1916385.8894371013 4216537.626890776, 1916385.427675201 4216529.527687664, 1916386.6666968158 4216519.321057806, 1916392.951996816 4216496.239999018, 1916398.2532772198 4216480.195654692, 1916403.0723053175 4216469.440580205, 1916406.24 4216471.02))','ZO32570','"lib_modif"=>"N", "lib_code_insee"=>"38200", "lib_modif_comment"=>"reclassement de la parcelle H240 de UD2 en UD3
"',1),
     ('MJ3_PH1_ZON_050_09','N','Naturelle','N',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/N.pdf','2019-12-20','SRID=3945;POLYGON ((1906623.1043409195 4216851.7088266695, 1906626.95 4216878.32, 1906639.99 4216890.54, 1906659.64 4216933.26, 1906668.1 4216965.11, 1906669.06 4216992.54, 1906663.61 4217067.29, 1906659.61 4217120.87, 1906685.81 4217141.36, 1906687.67 4217143.49, 1906693.43 4217155.48, 1906696.49 4217166.48, 1906700.68 4217194.33, 1906700.5 4217211.01, 1906690.88 4217264.02, 1906680.9 4217310.67, 1906659.5 4217352.29, 1906641.59 4217415.33, 1906657.09 4217421.23, 1906654.66 4217442.42, 1906652.72 4217468.5, 1906631.5 4217538.46, 1906632.05 4217544.77, 1906662.7 4217654.86, 1906665.29 4217708.16, 1906700.51 4217769.02, 1906720.29 4217806.19, 1906727.56 4217819.05, 1906760.48 4217859.27, 1906815.27 4217885.96, 1906894.5 4218030.52, 1906930.12 4218098.77, 1906975.05 4218204.04, 1907030.9 4218241.49, 1907032.32 4218243.16, 1907033.11 4218244.85, 1907058.02 4218285.2, 1907083.41 4218326.15, 1907105.39 4218400.14, 1907150.17 4218550.42, 1907179.98 4218646.41, 1907213.4155747811 4218715.471932075, 1907311.08 4218917.2, 1907348.51 4218993.52, 1907397.1 4219093.88, 1907431.66 4219165.34, 1907446.57 4219311.54, 1907459.81 4219442.28, 1907474.98 4219594, 1907481.73 4219662.28, 1907548.67 4219802.79, 1907954.31 4219732.9, 1908139.2703202716 4219748.040975251, 1908219.5782388665 4219741.361012146, 1908739.1277147378 4219783.207183759, 1908969.5227654888 4219727.930969549, 1909152.195 4219680.22, 1909402.2398568417 4219618.767622331, 1909489.1036369565 4219595.883511769, 1909519.317097769 4219587.923828495, 1909480.8232615595 4219565.020027706, 1909481.09 4219562.91, 1909483.34 4219543.13, 1909504.25 4219542.18, 1909505.32 4219527.29, 1909521.18 4219526.07, 1909527.83 4219500.85, 1909527.18 4219480.4, 1909530.18 4219475.86, 1909529.5 4219471.53, 1909507.13 4219453.56, 1909506.79 4219447.26, 1909539.57 4219444.39, 1909550.4 4219441.07, 1909558.28 4219438.77, 1909564.1 4219439.51, 1909599.92 4219446.53, 1909640.05 4219460.55, 1909643.468516396 4219466.307501298, 1909643.4687465376 4219466.30719332, 1909646.4769210792 4219461.911847418, 1909648.5452605442 4219458.578127755, 1909670.7427802142 4219436.231862464, 1909664.16 4219437.93, 1909637.54 4219440.37, 1909612.75 4219419.9, 1909590.62 4219412.69, 1909572.26 4219416.32, 1909541.9 4219420.78, 1909528.8 4219353.82, 1909549.02 4219349.77, 1909577.91 4219349.43, 1909596.54 4219349.14, 1909647.2631618169 4219340.890905421, 1909697.2950424051 4219309.439395315, 1909710.1752294598 4219323.737041923, 1909723.13 4219345.11, 1909737.59 4219366.05, 1909747.75 4219361.44, 1909759.07 4219357.26, 1909765.7741708267 4219355.117497926, 1909765.8843679659 4219354.807022444, 1909777.3454019898 4219325.2299521975, 1909780.432635617 4219319.92440967, 1909783.7296982973 4219314.278288581, 1909799.605190408 4219287.165173019, 1909798.63 4219308.49, 1909843.31 4219313.85, 1909856.38 4219315.02, 1909857.8 4219308.66, 1909859.51 4219302.34, 1909863.2 4219291.39, 1909866.78 4219282.2, 1909872.81 4219267.44, 1909887.41 4219266.88, 1909895.95 4219266.68, 1909905.16 4219266.05, 1909910.4 4219265.46, 1909915.23 4219264.81, 1909920.1 4219263.54, 1909924.06 4219262.41, 1909927.65 4219261.28, 1909931.1682244248 4219260.397455998, 1909931.4041345008 4219258.687107947, 1909931.1092469057 4219255.915164554, 1909929.8707190068 4219251.963670781, 1909927.039798095 4219246.596716553, 1909921.8497764233 4219238.2808863735, 1909917.7213500936 4219230.024033714, 1909914.949406701 4219222.415933764, 1909913.415991207 4219215.810451637, 1909912.7356998166 4219207.046697844, 1909911.4107555612 4219189.978298317, 1909910.2312051812 4219182.606108443, 1909908.3439245734 4219175.469828644, 1909904.4514083199 4219167.5668410985, 1909898.6126339391 4219158.307370616, 1909888.822365786 4219145.922091627, 1909887.22 4219147.34, 1909880.76 4219156.07, 1909878.35 4219159.21, 1909874.37 4219164.67, 1909856.3299491608 4219189.112180683, 1909781.64 4219144.36, 1909761.11 4219127.8, 1909741.12 4219112.55, 1909738.55 4219111.22, 1909730 4219106.22, 1909729.994900782 4219106.22040884, 1909729.999544775 4219106.22311506, 1909728.1216691104 4219121.593661107, 1909714.2812563637 4219141.867342669, 1909681.3951836177 4219215.668918284, 1909671.4782407875 4219248.736273746, 1909664.4407882963 4219256.92748733, 1909645.7736760748 4219261.285867112, 1909606.9084485646 4219269.874263635, 1909605.86 4219266.86, 1909597.4 4219271.97, 1909579.17 4219282.32, 1909571.81 4219286.45, 1909567.63 4219288.96, 1909564.97 4219290.32, 1909547.08 4219301.02, 1909534.71 4219305.38, 1909521.53 4219310.8, 1909490.1 4219322.46, 1909488.187532653 4219323.340025297, 1909471.6081635104 4219316.492497413, 1909481.4 4219304.45, 1909480.34 4219295.83, 1909522.52 4219200.94, 1909535.9 4219170.18, 1909523.14 4219154.7, 1909509.5 4219160.74, 1909497.96 4219169.41, 1909493.6 4219187.3, 1909475.82 4219170.04, 1909473.44 4219166.15, 1909452.45 4219178.32, 1909440.14 4219179, 1909437.54 4219178.34, 1909429.66 4219173.41, 1909421.91 4219130.38, 1909417.84 4219126.92, 1909404.58 4219136.64, 1909402.73 4219159.8, 1909378.21 4219171.6, 1909358.12 4219162.13, 1909376.65 4219149.75, 1909366.96 4219119.89, 1909366.1635924408 4219118.025725143, 1909379.964331886 4219106.878974052, 1909398.2473627746 4219097.855413646, 1909415.7047083976 4219088.7138982015, 1909432.3363687545 4219079.749315314, 1909431.73 4219078.33, 1909427.55 4219049.21, 1909436.21 4219046.46, 1909416.65 4218980.3, 1909413.5 4218968.87, 1909560.4377705103 4218950.160518826, 1909560.6757664823 4218948.85765149, 1909561.8426087783 4218944.3936581155, 1909562.3417683993 4218942.612595564, 1909562.03791289 4218938.329971021, 1909561.0940971056 4218934.75870918, 1909559.6701495324 4218931.358359048, 1909550.8362619968 4218921.1600294765, 1909545.2779350244 4218915.221358036, 1909535.7866844898 4218908.535631438, 1909519.3738998382 4218881.453615912, 1909503.3547762039 4218858.36417998, 1909497.4641799887 4218850.004590054, 1909491.1014221068 4218839.213395446, 1909489.2562437688 4218834.662540678, 1909487.9326760792 4218831.401986341, 1909484.7644872775 4218823.540147712, 1909476.0307553427 4218802.03477726, 1909475.2897013584 4218801.074857025, 1909467.2453555698 4218790.265897584, 1909461.758761355 4218786.057969091, 1909448.5544858144 4218778.114701545, 1909438.654479177 4218773.61039023, 1909428.7261135827 4218770.337416744, 1909418.3088278258 4218768.885118061, 1909416.841379741 4218772.848675548, 1909414.0126687454 4218776.493416858, 1909407.4823947873 4218780.351459429, 1909403.0291437143 4218779.8047652645, 1909402.1499447883 4218778.927075206, 1909330.9856088457 4218790.945940832, 1909315.295588964 4218776.337991286, 1909314.6174669527 4218775.636240019, 1909313.1428028636 4218776.604867673, 1909303.1756021534 4218779.199878508, 1909282.9463131377 4218784.566832736, 1909267.2582930846 4218790.051742003, 1909259.5322380962 4218799.370190004, 1909245.7904761701 4218810.81182869, 1909237.2977134348 4218824.553590616, 1909233.051332067 4218831.512937858, 1909224.2636817365 4218843.426396694, 1909215.3580763682 4218855.516788088, 1909214.1913865341 4218854.672299983, 1909193.2087928858 4218874.369833247, 1909171.990017184 4218890.387322242, 1909160.8852204564 4218892.307758486, 1909150.2542639414 4218886.72343344, 1909143.6380613379 4218871.831777149, 1909143.64 4218871.83, 1909142.4028853702 4218868.668774825, 1909137.8026388886 4218867.017404293, 1909123.6480343295 4218846.493227682, 1909114.80140648 4218835.523409149, 1909097.6979259711 4218817.948108488, 1909093.2746120463 4218813.406839524, 1909080.7124005 4218795.595628788, 1909078.5302322973 4218793.059595471, 1909074.5787385243 4218791.34924742, 1909069.3297393338 4218791.1133373445, 1909062.7242572063 4218792.587775319, 1909060.8740204927 4218794.344062348, 1909059.5984486993 4218795.300741193, 1909057.7714343595 4218793.879056416, 1909055.6581238492 4218791.679392047, 1909026.1073759906 4218763.888802338, 1909023.035345844 4218763.831401374, 1909019.8134861486 4218764.074302845, 1909010.8643707451 4218712.572118376, 1909011.7307998776 4218707.818421174, 1909018.9775452658 4218675.543510669, 1909037.4128764945 4218645.960576343, 1909039.9091503124 4218628.488317099, 1909039.9108486637 4218628.48542592, 1909041.86 4218617.98, 1909046.613053414 4218617.075962868, 1909069.1443676513 4218614.5856117485, 1909110.1442899955 4218610.127688695, 1909140.3887342862 4218606.780022893, 1909177.6169467648 4218602.645309407, 1909211.5417381937 4218597.453211157, 1909235.0360994597 4218586.677221753, 1909248.0225490127 4218573.02203325, 1909255.5217668056 4218572.188786829, 1909259.8861032112 4218570.537416297, 1909276.54 4218559.6, 1909287.78 4218549.3, 1909308.69 4218520.09, 1909304.0865813536 4218517.287662362, 1909304.08674306 4218517.287422191, 1909305.5152485678 4218514.815165912, 1909305.0561749039 4218492.978317369, 1909304.3366670092 4218458.753341821, 1909306.19288193 4218441.201797217, 1909306.4287945204 4218436.278747487, 1909305.9544289277 4218431.976466269, 1909304.2683042486 4218425.974441786, 1909302.364857982 4218422.7744242735, 1909300.7420834783 4218420.634378957, 1909297.6376954913 4218417.845429532, 1909284.081331402 4218408.141648318, 1909279.185104706 4218404.183559935, 1909277.6628033097 4218402.29377313, 1909276.1500131837 4218400.294114643, 1909274.9950937126 4218394.871570059, 1909274.5965035346 4218385.126477663, 1909275.196845401 4218373.929489382, 1909275.4095374285 4218365.033964546, 1909275.6651589957 4218359.9908300415, 1909276.572715668 4218356.297916854, 1909279.1184001835 4218349.552033804, 1909282.5949649054 4218343.205182982, 1909286.2119688014 4218337.50898785, 1909289.1508154802 4218334.18474542, 1909296.7803027276 4218328.214349582, 1909313.6093624327 4218315.782927039, 1909318.7492491228 4218311.956105682, 1909322.8782300467 4218308.22080455, 1909325.9473680595 4218304.9162616925, 1909327.9255043592 4218301.412139663, 1909328.2415975675 4218296.879249376, 1909327.1762497355 4218291.597111625, 1909324.107619799 4218283.605527523, 1909318.266218728 4218273.7846659385, 1909310.1102734602 4218260.924434738, 1909282.5008671149 4218242.15921594, 1909236.97 4218258.97, 1909231.38 4218263.2, 1909215.31 4218232.57, 1909207.6615101402 4218155.836991478, 1909220.4006542433 4218154.775396136, 1909247.0584928296 4218152.1803853, 1909264.5158384524 4218149.113554312, 1909263.0761120433 4218134.078441746, 1909329.920005871 4218124.7864857195, 1909336.7043217036 4218136.020545095, 1909366.4289912777 4218128.825287778, 1909401.6975476374 4218123.517311068, 1909447.1140607283 4218100.46499003, 1909448.3050086051 4218098.293032527, 1909451.3515454587 4218092.736997114, 1909448.8850448478 4218091.57717168, 1909431.28 4218081.54, 1909423.4057601432 4218074.819377188, 1909422.1799904995 4218073.975244154, 1909419.195061498 4218071.919656315, 1909415.66 4218069.48, 1909414.6362848578 4218069.674136773, 1909415.6796189744 4218078.536750312, 1909414.7905568546 4218080.286789645, 1909354.6334874786 4218059.880568074, 1909341.5404782614 4218059.290792883, 1909337.5300069696 4218058.701017694, 1909304.0307761799 4218033.812504677, 1909289.5223065068 4218010.693317231, 1909292.1299694832 4218010.379943975, 1909343.329615024 4218005.12003955, 1909343.329958515 4218005.118303144, 1909335.152041855 4217931.692795167, 1909335.1015058295 4217930.305832372, 1909371.253208361 4217930.237241842, 1909371.05 4217928.7, 1909364.66 4217890.96, 1909357.5204797706 4217891.31053319, 1909350.62 4217850.13, 1909350.6025316957 4217848.782401982, 1909363.3655016897 4217846.3216052875, 1909363.2640874635 4217845.278889232, 1909354.0337641365 4217734.092599827, 1909353.468343137 4217728.62033592, 1909353.3272597152 4217727.21925073, 1909352.9767864267 4217726.669635189, 1909352.2139153914 4217724.068392932, 1909348.0117409832 4217724.352362059, 1909346.6989544942 4217721.752192282, 1909333.2416182773 4217695.092389292, 1909320.7697642776 4217670.384886619, 1909311.6695856662 4217652.732340376, 1909300.14 4217630.36, 1909282.0548473278 4217620.899238166, 1909270.950521776 4217623.300543664, 1909260.3179447467 4217615.765130255, 1909264.73 4217602.28, 1909269.6093335352 4217587.638174876, 1909287.126099866 4217525.229895264, 1909293.5538213362 4217483.760956034, 1909292.1750932299 4217451.19343226, 1909285.6825759232 4217405.972634194, 1909274.2067795806 4217371.4530607285, 1909246.3648511888 4217317.875791676, 1909214.2487970113 4217270.392064232, 1909209.961633381 4217268.815105774, 1909197.9302195057 4217237.792930783, 1909167.7337297797 4217186.364534218, 1909159.3589220822 4217170.204694013, 1909146.5018229408 4217126.6792849945, 1909143.199081877 4217079.261359721, 1909139.306565623 4217065.2247102, 1909105.0996046055 4217022.760896522, 1909091.4168201983 4216998.6980687715, 1909079.1494962473 4216955.526524866, 1909087.1704388307 4216910.113835239, 1909097.0786620218 4216891.594894273, 1909110.407581315 4216741.43813091, 1909112.0589518468 4216743.4433665555, 1909115.387885931 4216749.054998297, 1909116.5416635103 4216748.11082509, 1909158.3219981985 4216720.179456678, 1909176.528498693 4216715.861183232, 1909195.081943724 4216696.083779686, 1909207.407222392 4216693.561972474, 1909221.797236456 4216684.224501244, 1909221.7995874046 4216684.224487176, 1909221.8 4216684.22, 1909210.303598655 4216652.217576834, 1909235 4216632.55, 1909257.84 4216664.05, 1909284.19 4216700.69, 1909335.6093202038 4216813.906069832, 1909263.8081082243 4216858.744416191, 1909265.577433794 4216873.842661054, 1909267.700624478 4216888.233175689, 1909269.116084934 4216896.37207331, 1909272.8906461496 4216905.690521312, 1909274.626095175 4216910.434081982, 1909277.3222331065 4216909.35538269, 1909298.507540508 4216901.412668151, 1909305.4391922436 4216898.715379465, 1909300.3808298702 4216873.942707384, 1909346.92454653 4216861.709270908, 1909364.0295838928 4216831.310400861, 1909395.062785295 4216818.765089644, 1909431.3875528725 4216816.60237882, 1909442.7833070648 4216825.956443845, 1909447.29 4216844.56, 1909447.285535827 4216844.564457133, 1909447.29345803 4216844.56268851, 1909453.245641485 4216856.561371272, 1909453.25 4216856.56, 1909479.06 4216859.21, 1909485.37 4216856.59, 1909500.03 4216851.84, 1909507.7584723216 4216849.498652975, 1909520.93858494 4216795.77718129, 1909504.81 4216800.36, 1909494.26 4216773.28, 1909491.3168311382 4216767.71977517, 1909468.28 4216775.17, 1909457.72 4216778.75, 1909451.86 4216780.54, 1909444.66 4216782.23, 1909436.28 4216783.98, 1909430.85 4216785.08, 1909409.53 4216798.42, 1909406.6 4216792.88, 1909404.21 4216788.19, 1909388.17 4216757.43, 1909375.32 4216734.81, 1909392.05 4216717.94, 1909412.58 4216697, 1909425.73 4216683.78, 1909420.1 4216677.56, 1909417.37 4216674.62, 1909416.01 4216672.72, 1909413.5 4216669.24, 1909410.19 4216669.93, 1909407.09 4216670.93, 1909402.69 4216672.86, 1909395.18 4216677.21, 1909387.33 4216682.08, 1909381.16 4216673.74, 1909376.3448367617 4216667.212648863, 1909372.92 4216662.57, 1909367.9 4216656.35, 1909363.18 4216650.89, 1909358.57 4216646.25, 1909353.14 4216641.28, 1909348.57 4216637.56, 1909345.25 4216634.32, 1909343.14 4216631.86, 1909336.75 4216623.92, 1909330.32 4216615.73, 1909344.84 4216606.27, 1909365.39 4216592.55, 1909407.24 4216565.02, 1909409.4815162406 4216563.501385748, 1909409.712845887 4216559.339511862, 1909410.12568852 4216553.618692519, 1909410.0077334822 4216548.546625886, 1909409.476935811 4216543.356604215, 1909408.5922730262 4216538.579425176, 1909407.5306776843 4216534.863841478, 1909405.3485094814 4216528.494269427, 1909404.4638466965 4216525.722326034, 1909403.9330490255 4216522.655495046, 1909403.9920265444 4216519.411731501, 1909404.6997567725 4216516.108990437, 1909405.4664645195 4216513.513979602, 1909403.97 4216513.1, 1909402.69 4216504.84, 1909413.13 4216495.97, 1909411.79 4216496.46, 1909409.86 4216497.52, 1909404.3 4216500.63, 1909398.27 4216502.9, 1909393.39 4216504.61, 1909385 4216507.22, 1909380.23 4216507.09, 1909377.57 4216506.79, 1909373.87 4216506.4, 1909370.73 4216507.09, 1909367.62 4216506.93, 1909363.93 4216507.21, 1909364.09 4216506.67, 1909361.89 4216499.8, 1909355.41 4216478.61, 1909352.6037924162 4216471.094313097, 1909343.5928449854 4216446.960866953, 1909338.469376961 4216460.3863320155, 1909325.0516238601 4216464.326781841, 1909318.7238893108 4216456.562633228, 1909320.9322993124 4216441.596563655, 1909316.4511505542 4216414.0503149275, 1909302.1092566522 4216404.306610694, 1909295.6564832253 4216384.708236591, 1909274.775748458 4216376.588283765, 1909252.2091173301 4216325.731429127, 1909235.1871225373 4216322.697440344, 1909233.88 4216323.03, 1909232.9 4216323.28, 1909232.14 4216304.45, 1909231.79 4216288.79, 1909311.63 4216267.51, 1909314.4051751888 4216266.928972678, 1909309.4510635932 4216255.015513841, 1909305.7944574154 4216248.174121638, 1909301.4301210097 4216241.332729435, 1909280.8469668801 4216216.031373785, 1909283.26 4216214.32, 1909282.58 4216209.79, 1909282.13 4216206.23, 1909281.78 4216202.85, 1909281.72 4216201.98, 1909282.59 4216202.34, 1909284.51 4216203.65, 1909288.4 4216205.41, 1909290.48 4216205.5, 1909296.57 4216204.17, 1909304.88 4216204.68, 1909311.87 4216204.44, 1909320.15 4216204.27, 1909325.66 4216204.09, 1909330.37 4216202.93, 1909335.84 4216200.34, 1909341.95 4216196.55, 1909346.26 4216192.89, 1909346.67 4216193.06, 1909350.69 4216191.14, 1909353.74 4216189.09, 1909356.74 4216186.48, 1909359.98 4216183.03, 1909364.98 4216179.27, 1909367.02 4216178.74, 1909393.41 4216216.43, 1909409.08 4216241.83, 1909415.15 4216282.26, 1909416.18 4216291.08, 1909429.17 4216296.59, 1909435.26 4216303.07, 1909441.27 4216305.55, 1909446.6 4216306.7, 1909453.99 4216307.57, 1909463.48 4216308.48, 1909466.99 4216310.8, 1909469.1091167263 4216312.390037789, 1909471.5610316857 4216312.527811625, 1909472.56 4216312.37, 1909480.6900000004 4216311.049999982, 1909501.9525122854 4216305.968186023, 1909523.4876729671 4216297.924915879, 1909546.8034784647 4216289.220338514, 1909551.386304713 4216289.006281389, 1909562.6900000004 4216288.159999981, 1909570.2600000005 4216284.019999981, 1909603.4321946576 4216261.585969262, 1909624.1400000004 4216292.489999982, 1909624.8216270066 4216293.545396827, 1909639.7538850873 4216285.808563305, 1909650.4041403444 4216279.045562427, 1909670.5946966503 4216266.310563964, 1909677.8656378149 4216263.052861814, 1909687.7776055878 4216258.541776547, 1909702.5018232102 4216253.926296358, 1909714.0853232082 4216250.324491543, 1909721.1578011971 4216248.056922625, 1909721.27751689 4216247.646786235, 1909722.7449285823 4216243.66285699, 1909723.1640493819 4216242.362156288, 1909723.3336532821 4216242.021616656, 1909721.9820422803 4216241.042420752, 1909715.1025589714 4216234.564645023, 1909707.01119809 4216226.937056123, 1909693.402508168 4216214.201700694, 1909690.4688481314 4216211.652770629, 1909681.1349814837 4216201.464591783, 1909676.247152612 4216196.056113238, 1909663.2462257126 4216180.077789954, 1909655.7224578136 4216169.268502814, 1909633.6328479892 4216148.9659272935, 1909633.2020422115 4216148.546058481, 1909617.3708338852 4216134.341175799, 1909616.660071607 4216133.69161678, 1909613.435392677 4216130.612835123, 1909606.27344904 4216121.683507132, 1909596.5579489204 4216109.6051812675, 1909596.057307326 4216109.655439833, 1909595.5272495372 4216109.706324018, 1909592.6418894308 4216105.376139177, 1909591.2797556042 4216104.026541423, 1909589.1258876391 4216100.716308504, 1909587.3722084658 4216097.826571075, 1909582.9921178673 4216088.744767704, 1909580.127352048 4216085.325283293, 1909579.1558257742 4216083.725607909, 1909578.2125550332 4216080.774539764, 1909576.7656326897 4216073.671943394, 1909575.7825677418 4216070.520995873, 1909572.9448702345 4216063.669336807, 1909571.560079638 4216059.007675404, 1909570.3155729366 4216054.816561152, 1909569.45 4216049.4, 1909568.98 4216047.86, 1909506.34 4216052.84, 1909462.14 4216056.31, 1909466.67 4216082.05, 1909470.95 4216104.61, 1909471.71 4216110.1, 1909473.4 4216121.2, 1909475.03 4216133.37, 1909473.8776728334 4216132.793706264, 1909469.726177877 4216133.337579112, 1909467.6051741433 4216134.039999259, 1909462.8555978155 4216137.215682617, 1909458.7245855671 4216139.240580304, 1909450.0545799874 4216144.981287721, 1909442.383383675 4216148.439839283, 1909437.5926817232 4216150.564959906, 1909431.6208684335 4216152.411335473, 1909427.4483856275 4216152.284644127, 1909421.1374499379 4216155.611753013, 1909417.8366132965 4216156.825476202, 1909412.5166356247 4216160.612196085, 1909406.874141526 4216161.447313111, 1909401.8017313066 4216162.002181372, 1909387.938943914 4216167.947259188, 1909384.7490165455 4216169.681382979, 1909380.0683394563 4216171.996716532, 1909376.9769688237 4216172.4496265855, 1909373.3967510422 4216174.803637892, 1909369.3270072618 4216177.56870308, 1909367.1557554991 4216165.893922062, 1909351.8482804976 4216086.202118555, 1909334.9245790923 4215999.377271814, 1909333.7885216721 4215993.534525508, 1909302.703737888 4215996.663165221, 1909271.5384642459 4215999.74144144, 1909259.8831489985 4216000.802038573, 1909261.5378115918 4215993.947123602, 1909263.1536406975 4215988.011964845, 1909265.448102077 4215979.565597171, 1909266.7135555686 4215973.891287421, 1909267.7280650744 4215966.815996872, 1909274.307586276 4215938.574508405, 1909280.389443374 4215913.155052813, 1909283.2955061344 4215906.63885946, 1909288.6478221752 4215894.36689939, 1909292.2112712802 4215884.368164914, 1909296.1243659258 4215873.258500092, 1909297.6009079227 4215868.715053809, 1909298.189444798 4215866.152894191, 1909298.3962582534 4215862.300329251, 1909298.4274323098 4215852.454712227, 1909296.371541863 4215835.286728409, 1909294.842251166 4215825.23233219, 1909295.9923911795 4215824.401073972, 1909299.8913492486 4215820.605375595, 1909303.1008003405 4215817.841053998, 1909305.0795021795 4215815.017754439, 1909307.7473676961 4215810.76325149, 1909309.196003799 4215808.680626988, 1909312.7344053674 4215804.475205345, 1909316.5427281093 4215799.999398766, 1909319.972212024 4215796.8950955225, 1909323.421824445 4215794.160584881, 1909326.811385245 4215791.405714173, 1909333.7702232976 4215785.446763643, 1909338.9909421608 4215782.830801037, 1909342.5516355096 4215781.516601005, 1909346.4619748017 4215779.092070925, 1909353.42428961 4215777.1848163195, 1909361.3171491663 4215775.297174396, 1909363.5993762799 4215772.843847795, 1909357.2145011039 4215769.849733545, 1909344.2608626864 4215769.615583679, 1909338.4351788838 4215768.874286124, 1909325.6682172045 4215762.262265233, 1909316.8361378887 4215755.312235279, 1909303.4128627751 4215744.21768538, 1909304.4969138692 4215742.657391568, 1909301.0909911965 4215738.2376051005, 1909298.5061544657 4215734.307592346, 1909298.455674072 4215733.547604505, 1909294.6507140843 4215625.099370227, 1909280.04 4215628.41, 1909268.33 4215629.37, 1909268.49 4215585.37, 1909266.24 4215577.18, 1909269.64 4215576.6, 1909284.470990428 4215574.309114772, 1909267.434866256 4215496.319743393, 1909266.6776448656 4215493.460359113, 1909270.316477759 4215489.869917831, 1909275.0145328229 4215486.154926674, 1909274.2175695803 4215483.796835957, 1909271.0576406224 4215474.303970109, 1909261.8387548712 4215446.235783127, 1909258.77 4215436.89, 1909258.2453012099 4215435.493132526, 1909257.6967901224 4215435.858806585, 1909241.9859695493 4215443.432234511, 1909234.630724574 4215449.894651788, 1909226.173290385 4215459.120447782, 1909225.7296487242 4215459.612260625, 1909225.6944680875 4215459.64308581, 1909220.7987127814 4215462.175502978, 1909208.9593145046 4215470.905624259, 1909201.535020243 4215474.196842105, 1909194.3809600102 4215474.554428754, 1909175.898056354 4215473.026745188, 1909171.04 4215473.18, 1909170.207163013 4215473.239283507, 1909152.2059315885 4215476.76829669, 1909137.7784468913 4215477.620302122, 1909121.3039676112 4215483.248623482, 1909117.629794857 4215484.276409104, 1909112.8497102137 4215485.559727777, 1909103.2348402864 4215486.924099453, 1909094.9625401683 4215488.014184494, 1909079.7591170904 4215490.091437029, 1909068.9721311834 4215490.976693733, 1909018.0015342783 4215495.939679682, 1909009.6139014638 4215494.300752581, 1908996.4199030453 4215490.5429593995, 1908969.1596410554 4215482.244926653, 1908959.29815319 4215479.211376345, 1908923.465652033 4215468.068896942, 1908895.9864347056 4215459.325269669, 1908882.6069971458 4215453.264300156, 1908875.516415811 4215448.647858386, 1908868.436713952 4215442.693748367, 1908849.7504133394 4215420.1664209375, 1908829.7118687185 4215396.057674943, 1908823.6284591444 4215390.391158235, 1908821.956292255 4215389.20934407, 1908808.8444135487 4215381.084206573, 1908805.7859335402 4215381.748637342, 1908803.5529735053 4215382.167224245, 1908796.1644945415 4215386.207479254, 1908784.4704643115 4215393.99499897, 1908780.9207962654 4215390.143934357, 1908777.2890964947 4215385.6301928535, 1908769.7944947835 4215375.058493363, 1908765.1997549362 4215368.891553755, 1908759.688964822 4215361.75542411, 1908748.4726916049 4215349.937561009, 1908737.2539518948 4215338.816653233, 1908726.6381337466 4215332.7110900385, 1908722.7524616467 4215330.976839568, 1908718.4107523854 4215329.685910384, 1908715.5010238644 4215328.779538636, 1908704.8124999902 4215326.564999998, 1908697.1377748034 4215324.990419336, 1908691.2732609136 4215323.815191787, 1908680.2201931756 4215323.173180296, 1908678.2486369242 4215323.406597896, 1908668.6595973137 4215324.616729684, 1908648.0831475663 4215327.673555669, 1908648.0771331359 4215326.781415139, 1908646.425778418 4215326.472625232, 1908647.072821109 4215316.715951602, 1908649.4055303822 4215302.827907311, 1908634.3523093837 4215299.8719435865, 1908630.7948533013 4215299.031408038, 1908621.9945746514 4215296.898667918, 1908617.0337285928 4215295.341569639, 1908613.340518852 4215293.359198802, 1908606.2275509336 4215258.786834314, 1908598.0317813384 4215228.646249745, 1908598.7838872923 4215187.463250264, 1908592.3578260345 4215170.268120169, 1908584.5444640715 4215161.333639138, 1908580.7042724728 4215155.655740852, 1908578.8959682763 4215140.1320030475, 1908576.348169814 4215133.166551721, 1908569.1873438158 4215123.906234867, 1908561.8066140627 4215115.167384343, 1908555.1132388664 4215107.664615385, 1908552.94782359 4215105.436081555, 1908550.7164074122 4215103.824527829, 1908538.733453019 4215096.005067502, 1908525.1382305834 4215091.738478127, 1908519.4387579313 4215089.441555736, 1908515.3044268754 4215087.794968625, 1908511.4735910576 4215084.805867148, 1908499.9902934544 4215072.633074082, 1908496.554619525 4215069.023334493, 1908490.1820863243 4215063.693104908, 1908480.900554051 4215058.606283864, 1908469.448076981 4215054.233154398, 1908454.574846576 4215052.12647566, 1908438.7838320227 4215051.833383385, 1908420.0380922155 4215046.837002303, 1908397.7411363584 4215043.699507785, 1908387.4191825686 4215040.481111156, 1908355.2407348389 4215021.530414126, 1908350.17900003 4215017.396391121, 1908344.5106667187 4215010.434162313, 1908339.0052907187 4215003.155502952, 1908332.5863616096 4214997.669116921, 1908320.779426357 4214994.689435159, 1908295.458172861 4214992.835067501, 1908279.65561368 4214997.614077468, 1908243.7048444033 4215011.720241156, 1908236.8271649154 4215010.711408277, 1908236.6016882493 4215010.669569494, 1908218.9084814158 4215005.373476986, 1908205.3302927092 4215001.124148813, 1908204.6167670614 4215000.969022762, 1908195.064463727 4214999.1094778925, 1908181.8042914981 4215003.102611335, 1908149.0578452672 4215007.429538654, 1908136.4030135504 4215017.235018554, 1908127.335911603 4215019.984293104, 1908114.1686477552 4215019.664482828, 1908100.7896356275 4215019.535991903, 1908078.6230970884 4215023.298689969, 1908073.654057358 4215023.398929254, 1908072.1853936897 4215023.393505743, 1908063.8076607422 4215021.688374135, 1908050.1276339155 4215017.034925461, 1908041.3102285606 4215015.084679789, 1908027.8543212682 4215013.510456712, 1908025.1197393674 4215012.459782305, 1908022.809902229 4215006.286481098, 1908020.627363772 4214999.534045021, 1908020.0022350536 4214997.817177722, 1908018.37204251 4214995.922326278, 1908008.0187002383 4214992.135108591, 1907996.0775715793 4214990.523444175, 1907990.954291498 4214989.195303644, 1907988.6399071417 4214987.180034042, 1907984.7493621616 4214981.061467212, 1907980.7120679077 4214974.402626591, 1907968.307155688 4214971.951267513, 1907967.3186173576 4214971.517521063, 1907964.9655203174 4214969.601169474, 1907964.411195358 4214969.122678317, 1907961.9616684788 4214966.186485931, 1907955.5312597028 4214960.88638186, 1907950.6568267068 4214957.382770834, 1907949.9889069279 4214957.104411901, 1907937.3043726978 4214951.920557779, 1907935.6887927572 4214947.756579479, 1907935.3071298 4214946.74912016, 1907934.9628507185 4214945.980735286, 1907932.851491398 4214941.240760417, 1907927.3490889587 4214941.979537347, 1907918.6271417502 4214943.211162605, 1907897.8876878654 4214947.380469992, 1907892.1492116598 4214946.7586239325, 1907886.2154413185 4214944.034884556, 1907872.7036077876 4214932.659286727, 1907861.2480014772 4214920.320476116, 1907853.0325077658 4214909.286346936, 1907851.1593443328 4214907.516767528, 1907850.343841745 4214906.810416307, 1907847.9163444047 4214906.147658344, 1907845.1212286192 4214905.729351562, 1907823.2725746206 4214904.42902985, 1907822.2342576825 4214904.352025597, 1907817.9304929406 4214903.684535129, 1907814.076164071 4214902.1316091865, 1907807.3280749298 4214898.125750837, 1907799.7331336793 4214892.5364278415, 1907793.483134732 4214885.352232972, 1907786.5002400212 4214876.229877887, 1907778.946113725 4214867.608608957, 1907774.368216113 4214866.242327441, 1907773.603248294 4214865.993845488, 1907771.2779257789 4214865.712056664, 1907770.5457487358 4214865.641256345, 1907767.323045853 4214865.3376988955, 1907760.0074702553 4214864.647528727, 1907759.1929445183 4214864.194561268, 1907759.0382815525 4214864.103866997, 1907758.8030021144 4214863.563849058, 1907758.1791401217 4214861.932878334, 1907756.939609539 4214857.31819562, 1907756.3166957148 4214854.7009967165, 1907755.3031768734 4214848.447090266, 1907754.5344534414 4214841.611619433, 1907753.2477826925 4214817.966328279, 1907752.1966691238 4214814.699370884, 1907751.6367488974 4214813.3797836015, 1907750.511202112 4214811.354784063, 1907746.2631700165 4214808.008205415, 1907740.1012817908 4214805.112574029, 1907735.5955005207 4214803.589207514, 1907730.5418946561 4214802.501454871, 1907727.717526978 4214801.9901455045, 1907722.465351991 4214800.797368636, 1907720.3763491462 4214799.163583957, 1907718.639757763 4214797.824540937, 1907715.285934377 4214793.7927017575, 1907710.191145694 4214787.7325654235, 1907707.5140421742 4214785.121352235, 1907697.0195333222 4214782.063984553, 1907694.8842352729 4214781.210020435, 1907694.6502726977 4214781.118808113, 1907694.4911571853 4214781.000740239, 1907690.155723127 4214777.835344031, 1907683.3554215708 4214769.81430468, 1907679.8601074042 4214764.35409685, 1907677.5986592397 4214759.928535788, 1907674.0720641138 4214752.9173339475, 1907670.4742954315 4214743.758828827, 1907664.172720767 4214721.505150858, 1907662.236285742 4214718.655354722, 1907660.924183792 4214716.7824948365, 1907658.234253387 4214715.114701438, 1907647.8832187376 4214709.008837313, 1907627.9069792195 4214699.106369092, 1907606.8666751934 4214686.848337597, 1907602.5844167816 4214684.335123535, 1907597.9934727317 4214681.00538291, 1907595.2837830493 4214677.00889157, 1907595.2558895147 4214671.902538139, 1907595.5040314137 4214670.680541012, 1907595.5895253886 4214670.29451929, 1907597.5297269644 4214666.160238904, 1907599.8180231801 4214661.374891235, 1907600.823314824 4214659.125230431, 1907604.0194759825 4214651.930793661, 1907604.5790284043 4214646.550694675, 1907604.3992714672 4214644.634491303, 1907604.2585228663 4214642.839101287, 1907601.590850571 4214633.557647977, 1907594.7266717902 4214610.098544958, 1907591.781256399 4214601.49985626, 1907590.7897484081 4214598.870289856, 1907589.6748228616 4214596.27265704, 1907588.198387338 4214592.741457565, 1907587.6620505156 4214591.89558591, 1907587.260843333 4214591.244063991, 1907582.162876963 4214584.5527697615, 1907578.6872568068 4214582.043596653, 1907576.3544207846 4214581.68946134, 1907568.437052656 4214580.547890684, 1907563.7884968591 4214579.339511842, 1907562.7286596668 4214579.04743965, 1907561.6437067126 4214578.518896481, 1907561.1800394054 4214578.283176831, 1907558.7557365259 4214576.748868887, 1907552.2654974929 4214571.525273724, 1907547.366081831 4214565.531265886, 1907541.7132481183 4214557.273224504, 1907534.4426250355 4214543.621556746, 1907534.2120481927 4214543.189012247, 1907533.8077343074 4214542.504320947, 1907528.0617547631 4214532.952543546, 1907514.538723976 4214523.486934348, 1907513.5266840875 4214520.887323606, 1907513.1126337238 4214519.795640006, 1907513.466139406 4214512.536800893, 1907514.9492577792 4214501.5417831065, 1907516.5891830197 4214489.216508485, 1907517.6304216776 4214483.275780323, 1907516.9940666729 4214477.430206374, 1907516.6429689177 4214475.247774691, 1907513.0412538599 4214466.06168907, 1907511.0813088012 4214461.598826362, 1907509.1540960248 4214456.555086219, 1907507.5418531492 4214450.369985961, 1907506.3032040603 4214442.845918798, 1907499.0282693824 4214428.597584939, 1907493.1633233067 4214416.358600619, 1907490.4852898454 4214411.146530308, 1907478.814561429 4214385.888494925, 1907464.6258745666 4214359.516781441, 1907458.902032439 4214346.587952464, 1907441.8955355259 4214310.521892894, 1907437.445535526 4214300.790830938, 1907453.4631016725 4214296.085703554, 1907469.0769039926 4214288.987281389, 1907475.4524961165 4214285.003283459, 1907480.8826477695 4214280.770932112, 1907481.5919256539 4214274.565192956, 1907480.956450479 4214260.049039935, 1907480.638971011 4214252.201121197, 1907479.1023444666 4214244.947673955, 1907477.691648395 4214242.056941957, 1907474.9035568228 4214236.228833863, 1907468.5964048328 4214227.773357951, 1907461.2229955487 4214217.560556057, 1907457.3441295547 4214202.690526316, 1907455.2734119568 4214195.48630723, 1907450.9808270328 4214177.467849805, 1907449.8981071052 4214173.0818928955, 1907447.4403181341 4214167.516165503, 1907447.011455957 4214166.597803044, 1907433.9272730462 4214143.691696677, 1907413.3034810524 4214108.309006677, 1907403.575721893 4214091.519305701, 1907397.016756842 4214080.295081903, 1907386.3290655 4214060.375192068, 1907373.9080122968 4214038.909941113, 1907373.4129477998 4214038.0871113995, 1907372.893376746 4214037.247351118, 1907366.6926919052 4214027.2235517595, 1907351.9825260662 4214009.339255271, 1907324.6160203007 4213976.251260415, 1907316.0710955162 4213968.015149165, 1907295.9812404348 4213960.547854805, 1907281.5023730455 4213955.7656243555, 1907253.0059751258 4213946.210101197, 1907252.1192150575 4213945.473204282, 1907252.0727114102 4213945.440668088, 1907243.2451633003 4213929.896868941, 1907237.4799670486 4213919.065298215, 1907236.8349189188 4213917.472760485, 1907234.914060345 4213912.693262861, 1907235.2431761355 4213908.043962362, 1907235.5400526845 4213904.172851637, 1907237.9779251644 4213880.786657088, 1907233.0370850204 4213868.68368421, 1907226.4451756733 4213852.795201583, 1907220.8837145865 4213838.706680852, 1907216.2147955962 4213828.843177076, 1907204.4821862348 4213806.904979758, 1907191.7881983807 4213789.319433198, 1907188.0296396795 4213779.854821827, 1907186.66506388 4213776.184243044, 1907183.8998269015 4213767.683210703, 1907183.1433422558 4213764.624095472, 1907181.2555799447 4213757.579058248, 1907169.3177590803 4213741.277340677, 1907156.6146512558 4213726.606755955, 1907148.696808802 4213716.080935448, 1907143.2116537457 4213707.846604112, 1907139.5153370681 4213702.058254811, 1907133.3398229345 4213694.421653033, 1907128.0067022222 4213688.3641594, 1907127.8309661958 4213688.160835301, 1907127.026440047 4213687.083903868, 1907126.3992960823 4213685.967147223, 1907123.7319635628 4213681.14304532, 1907105.8345866743 4213638.295717572, 1907100.7844207245 4213627.051647479, 1907084.4580574709 4213591.090532552, 1907083.3182128188 4213589.28761838, 1907081.2954885324 4213587.534134274, 1907051.9231001944 4213565.404606885, 1907034.4135918797 4213549.700826391, 1906997.8233979698 4213520.02820406, 1906975.203145095 4213509.135953623, 1906947.4792254888 4213513.43548389, 1906940.2608364916 4213512.807797022, 1906918.7238446842 4213507.459861927, 1906884.2210108675 4213511.786893463, 1906861.936963438 4213506.938074551, 1906843.6473226463 4213501.925409497, 1906814.582385038 4213493.243515166, 1906810.030027353 4213491.654597787, 1906807.5255370436 4213490.778021265, 1906805.0969353614 4213489.639604502, 1906804.2203415658 4213489.207121556, 1906801.1019327575 4213487.43351447, 1906798.0975688552 4213484.890491116, 1906785.9640550297 4213470.983331524, 1906766.9051177104 4213447.712420168, 1906755.1856915453 4213434.454552088, 1906746.461506358 4213431.655768257, 1906693.1111565894 4213418.042752842, 1906670.8165907094 4213412.333475738, 1906666.2597312287 4213403.755420222, 1906663.4382179915 4213397.082926626, 1906661.307884201 4213393.240239478, 1906652.9856766688 4213381.4399859365, 1906640.8308823463 4213364.078161449, 1906612.0344795224 4213322.4151109215, 1906556.3063393435 4213242.302297963, 1906545.4987141686 4213227.421011712, 1906539.7873021353 4213219.183786477, 1906512.6041781572 4213193.729358424, 1906503.4094699507 4213201.586450498, 1906465.4166247677 4213234.052220592, 1906418.4035441296 4213274.225991734, 1906213.4021571996 4213448.098871333, 1906127.415169976 4213520.844750307, 1906130.48 4213523.59, 1906110.79 4213576.45, 1906104.52 4213615.68, 1906103.31 4213645.68, 1906105.7 4213662.94, 1906100.58 4213687.5, 1906098.52 4213702.52, 1906098.15 4213717.28, 1906095.48 4213730.65, 1906094.58 4213742.01, 1906094.49 4213772.05, 1906091.93 4213790.15, 1906081.43 4213834, 1906067.53 4213886.45, 1906054.69 4213934.56, 1906037.83 4213988.17, 1906025.52 4214027.08, 1906038.2 4214049.09, 1906025.57 4214098.57, 1906057.394178813 4214159.229666536, 1906064.01 4214171.84, 1906062.61 4214182.17, 1906063.3 4214232.29, 1906069.89 4214242.05, 1906081.35 4214302.37, 1906088.14 4214324.61, 1906085.32 4214327.2, 1906085.94 4214334.89, 1906088.33 4214344.05, 1906099.7 4214383.7, 1906103.98 4214393.56, 1906105.34 4214400.29, 1906104.15 4214408.82, 1906105.87 4214428.04, 1906107.92 4214454.96, 1906109.68 4214478.66, 1906112.37 4214491.34, 1906116.56 4214502.9, 1906124.69 4214524.01, 1906134.03 4214548.31, 1906134.98 4214552.44, 1906135.63 4214560.9, 1906134.55 4214571.75, 1906131.29 4214597.34, 1906131.43 4214604.44, 1906133.02 4214623.97, 1906135.17 4214631.13, 1906137.86 4214636.42, 1906142.96 4214644.08, 1906164.74 4214670.33, 1906169.51 4214677.53, 1906180.84 4214708.86, 1906188.52 4214726.29, 1906203.14 4214754.99, 1906222.76 4214781.33, 1906223.25 4214815.42, 1906243.56 4214836.17, 1906240.01 4214869.65, 1906257.23 4214879.12, 1906263.82 4214885.48, 1906272.63 4214897, 1906278.69 4214905.23, 1906284.92 4214925.19, 1906293.16 4214967.43, 1906296.15 4214987.22, 1906297.33 4215008.31, 1906300.01 4215076.25, 1906317.15 4215080.16, 1906340.25 4215112.23, 1906345.18 4215167.73, 1906348.76 4215179.46, 1906350.84 4215196.05, 1906350.25 4215230.02, 1906349.6 4215269.86, 1906349.15 4215303.83, 1906348.58 4215323.44, 1906349.44 4215332.82, 1906351.73 4215339.68, 1906354.08 4215344.21, 1906358.02 4215349.91, 1906363.55 4215356.62, 1906368.11 4215362.6, 1906371.35 4215369.72, 1906374.11 4215376.7, 1906378.25 4215383.63, 1906393.6 4215403.82, 1906401.67 4215423.39, 1906396.99 4215448.13, 1906396.56 4215452.62, 1906397.38 4215457.52, 1906399.08 4215465.17, 1906400.66 4215469.42, 1906404.21 4215473.29, 1906412.97 4215479.86, 1906440.14 4215498.79, 1906444.19 4215517.91, 1906444.96 4215522.34, 1906447.35 4215546.13, 1906418.96 4215574.77, 1906418.650227349 4215579.6066775285, 1906418.08 4215588.51, 1906408.67 4215619.24, 1906412.97 4215633.21, 1906400.95 4215644.06, 1906396.99 4215666.03, 1906397.82 4215668.95, 1906411.76 4215683.68, 1906413.76 4215713.87, 1906416.7 4215725.75, 1906416.04 4215737.48, 1906419.15 4215750.52, 1906418.03 4215764.03, 1906426.08 4215782.47, 1906430.45 4215802.97, 1906433.91 4215830.53, 1906428.75 4215865.69, 1906430.06 4215877.13, 1906434.55 4215901.96, 1906456.21 4215912.66, 1906463.14 4215958.36, 1906467.02 4215978.61, 1906487.07 4216025.88, 1906490.35 4216087.37, 1906492.83 4216094.08, 1906516.87 4216139.81, 1906523.34 4216152.14, 1906529.06 4216165.4, 1906533.81 4216183.1, 1906540.97 4216229.97, 1906550.32 4216297.28, 1906563.65 4216394.53, 1906573.56 4216471.44, 1906574.13 4216489.38, 1906568.59 4216520.35, 1906568.45 4216527.29, 1906574.01 4216582.34, 1906575.29 4216598.4, 1906572.69 4216631.43, 1906573.83 4216641.55, 1906578.17 4216665.62, 1906594 4216712.6, 1906598.78 4216735, 1906606.4 4216787.11, 1906609.32 4216802.05, 1906621.09 4216837.77, 1906623.1043409195 4216851.7088266695), (1908152.104178478 4216638.497745383, 1908145.8181398432 4216655.3477775, 1908168.223500856 4216658.82084883, 1908168.1943974004 4216659.891285119, 1908166.3455745298 4216674.231454249, 1908145.1510575505 4216671.407520576, 1908181.1938708432 4216708.708485756, 1908203.072907787 4216704.647098139, 1908214.9785314596 4216715.453314593, 1908247.0421055371 4216732.855698431, 1908257.742817666 4216738.710112026, 1908273.0481254614 4216757.878005039, 1908317.3939571003 4216770.157370142, 1908365.7253884003 4216786.555278998, 1908388.4469179239 4216784.844697915, 1908403.229358024 4216777.337981725, 1908427.4174381236 4216782.550502413, 1908442.6629545614 4216778.805138668, 1908446.7246273933 4216777.811100802, 1908449.3450055066 4216776.968380603, 1908518.94640299 4216813.489594393, 1908522.1765379955 4216846.826298691, 1908538.1640850666 4216845.191701035, 1908555.4876060132 4216849.418913121, 1908540.3980797823 4216871.304728264, 1908537.0320290974 4216890.348099412, 1908540.581745306 4216899.340610721, 1908541.5744331111 4216901.820981515, 1908546.7991462983 4216903.837870212, 1908562.96978756 4216904.994711143, 1908572.3462852174 4216906.787722524, 1908581.569150704 4216915.664918504, 1908590.627986566 4216919.469351783, 1908598.6375776536 4216937.492618916, 1908604.5155680634 4216954.367452067, 1908610.5254446222 4216996.986712118, 1908616.8013140047 4217011.579302004, 1908651.3728854717 4217037.044524972, 1908661.6160603901 4217056.817090454, 1908699.7325262425 4217062.467928829, 1908706.6408466431 4217090.717803339, 1908698.6010730662 4217096.367917115, 1908681.4211625552 4217108.449533116, 1908676.5386725273 4217131.727248003, 1908686.0111321167 4217151.640359629, 1908692.9759618272 4217187.695271157, 1908699.7348875569 4217240.599627068, 1908697.0620316654 4217250.978266003, 1908692.0358743414 4217270.533382173, 1908709.3636248773 4217279.664199174, 1908726.5661857375 4217282.810889131, 1908748.7696672718 4217283.212124365, 1908751.911245856 4217295.106460733, 1908763.7691247342 4217307.583474422, 1908774.6296345768 4217312.816984936, 1908758.5690760824 4217369.453432639, 1908741.9767236062 4217366.6159995105, 1908711.897168869 4217445.306716673, 1908704.03599941 4217461.142737405, 1908688.7220664127 4217490.212536814, 1908675.4858855589 4217515.028317133, 1908675.4849587975 4217515.030670824, 1908673.4599460508 4217515.300135645, 1908675.8551233413 4217546.437440423, 1908679.1356984642 4217551.527593702, 1908693.1256122268 4217568.939500759, 1908718.7792216307 4217595.4755439, 1908727.0362801852 4217598.122845117, 1908745.6934506602 4217583.62571941, 1908764.6477377766 4217585.594069265, 1908773.3820897315 4217596.642529263, 1908782.8817296478 4217600.644084371, 1908783.03 4217605.28, 1908799.46 4217720.01, 1908804.13 4217752.73, 1908791.88 4217785.7, 1908828 4217851.26, 1908870.7 4217950, 1908831.94 4217957.96, 1908780.34 4217978.91, 1908762.04 4217986.98, 1908756.434363913 4217986.15023916, 1908742.4186185838 4218025.69134767, 1908741.6376030287 4218036.296326436, 1908742.996507489 4218046.59986963, 1908738.19589062 4218116.686745414, 1908733.623513306 4218123.023692326, 1908730.1995769588 4218185.146259319, 1908726.9985114275 4218184.820074475, 1908678.525553686 4218179.47825726, 1908674.489909471 4218210.209254789, 1908613.89 4218209.04, 1908543.12 4218207.57, 1908545.31 4218164.69, 1908518.2850351566 4218111.120102244, 1908526.8557056538 4218064.625888054, 1908505.3995496621 4218043.467786844, 1908471.982174792 4218045.927763533, 1908413.0972068799 4218056.464352494, 1908382.3768851024 4218064.895458119, 1908382.3767631561 4218064.895470042, 1908303.45 4218086.35, 1908188.84 4218091.17, 1908168.48 4218100.85, 1908166.03 4218101.97, 1908137 4218064.3, 1908145.79 4218032.12, 1908158.4623448888 4218011.745949462, 1908126.5795170062 4217936.209394758, 1908095.6584237274 4217862.033022013, 1908095.6555379287 4217862.03211932, 1908095.66 4217862.03, 1908095.9700950622 4217860.520820411, 1908069.560113883 4217852.326792838, 1908037.4773443837 4217837.892698112, 1908031.17424625 4217835.686613765, 1908025.6698034294 4217836.259863352, 1908025.15 4217834.8, 1908016.624300208 4217809.192915747, 1908016.618020053 4217809.179979259, 1908005.6964031777 4217733.025240918, 1908016.3348206934 4217688.330646779, 1907986.290389105 4217633.26437813, 1908009.2767205946 4217601.957175034, 1908009.278775722 4217601.95651175, 1907983.28 4217527.88, 1907965.3921726632 4217447.574066162, 1907951.8301648798 4217457.197414633, 1907942.2249264254 4217469.097957648, 1907942.2252846104 4217469.100208851, 1907932.07 4217469.55, 1907895.86 4217471.13, 1907833.06 4217499.44, 1907831.334519929 4217500.046638159, 1907757.6513027484 4217413.883286674, 1907736.2207690945 4217402.159524146, 1907721.3454574996 4217390.309699655, 1907700.2286687978 4217339.30833279, 1907697.9839966998 4217339.181376454, 1907628.6473326357 4217330.885426602, 1907561.5374851436 4217188.030560216, 1907550.4170384626 4217171.490334942, 1907550.8613268088 4217164.4761351505, 1907560.2071075835 4217153.451864494, 1907555.7784734296 4217146.521658499, 1907549.2662037136 4217136.251110073, 1907508.618647555 4217095.972594875, 1907456.6811184245 4217016.271294536, 1907458.4041369634 4217007.134396329, 1907465.297659041 4216994.871912291, 1907464.010538218 4216987.128572228, 1907449.7045511084 4216978.195619926, 1907471.7811472523 4216935.332108979, 1907472.725026782 4216933.640111907, 1907499.0626410306 4216945.08714578, 1907504.0729719226 4216953.743778554, 1907530.0460821828 4216969.709795123, 1907531.24 4216966.81, 1907515.11 4216902.33, 1907540.28 4216868.39, 1907525.52 4216840.21, 1907528.4 4216795.65, 1907592.38 4216749.63, 1907607.33 4216765.07, 1907626.87 4216788.98, 1907629.49 4216792.53, 1907645.0011076354 4217009.828518067, 1907793.12 4217055.13, 1907797.03 4216984.31, 1907792.08 4216891.92, 1907787.8 4216876.49, 1907785.55 4216815.41, 1907807.77 4216811.29, 1907850.6390665602 4216796.160263473, 1907860.7017912467 4216679.132293893, 1907862.3200258405 4216660.312469768, 1907877.238443067 4216601.026100149, 1907885.7484760124 4216525.165544008, 1907883.7083518663 4216503.144315161, 1907895.1738902885 4216478.020412481, 1907896.5371637866 4216476.084892997, 1907887.6522655159 4216460.242281966, 1907889.1630599825 4216458.064148632, 1907929.4167995488 4216399.826638996, 1907931.0943960454 4216386.883088622, 1907933.4724490792 4216368.535143038, 1907930.8139869517 4216337.379649533, 1907932.1211533826 4216309.472832154, 1907977.6398503436 4216312.475954111, 1907962.9484478224 4216215.512840984, 1907932.9106785296 4216214.498058947, 1907932.5030243609 4216182.07994842, 1907941.3733694823 4216153.556153271, 1907962.771252738 4216148.514850126, 1907964.6193010963 4216144.521002152, 1907961.6367324945 4216143.733495614, 1907924.9124521746 4216140.002464632, 1907891.3430747036 4216127.944401628, 1907875.0129388426 4216114.980735236, 1907872.5500219297 4216077.981982346, 1907889.7771280748 4216027.628667874, 1907906.1978759356 4216006.042004354, 1907942.9769186568 4215980.376076874, 1907957.0527278231 4215977.803020188, 1907957.22761155 4215959.712187865, 1907949.363887196 4215925.379376607, 1907949.0808351014 4215924.217385317, 1907962.8217724534 4215920.353478181, 1907978.5624110012 4215923.634089713, 1907978.336826487 4215921.7130039865, 1907974.7893886282 4215856.2086142665, 1907983.0663992877 4215859.153433148, 1907988.9528503448 4215839.567092805, 1907978.672946257 4215799.123088968, 1907986.9067456715 4215798.565555519, 1907982.2057414737 4215774.217987419, 1907974.3244694322 4215733.39909008, 1907975.455892756 4215711.315795531, 1907957.2202166314 4215681.354537373, 1908003.865952217 4215668.537116314, 1908093.6448076393 4215630.929655916, 1908086.2904920338 4215619.499445441, 1908085.1485890807 4215617.970493125, 1908097.3661693535 4215603.082383214, 1908098.880258123 4215593.129037059, 1908093.9747591347 4215562.966925353, 1908095.603611731 4215558.939245495, 1908101.305622219 4215557.233225501, 1908111.2663726965 4215558.632029456, 1908112.4604083546 4215557.252521527, 1908094.2595619878 4215539.911067566, 1908092.527753815 4215541.769868797, 1908068.57 4215564.91, 1908064.6853038052 4215566.658869065, 1908042.87 4215576.48, 1908009.33 4215546.18, 1907968.7439614346 4215503.264188834, 1907943.888047844 4215523.135998848, 1907920.5742047755 4215510.889122623, 1907883.2733264512 4215487.707564377, 1907845.0969693055 4215481.91679832, 1907787.4120868046 4215479.794514053, 1907740.2898278409 4215449.757615277, 1907782.5805691914 4215422.026111519, 1907785.0494165616 4215420.318497922, 1907795.838768317 4215417.644836505, 1907807.8057673345 4215395.833684932, 1907802.7012545296 4215397.705411778, 1907787.667746279 4215403.581137522, 1907753.4687465348 4215357.014291925, 1907770.1556407094 4215342.742010334, 1907756.5274408003 4215330.18610644, 1907763.9190430644 4215295.873511966, 1907706.48 4215321.78, 1907706.4779547246 4215321.781695224, 1907680.3026587195 4215304.506649475, 1907669.5255635898 4215268.075211403, 1907680.1370432451 4215249.129524395, 1907680.15 4215249.12, 1907704.4269520273 4215230.4393222155, 1907674.388088321 4215136.605800773, 1907673.8769256857 4215135.012573597, 1907717.973299998 4215139.410325213, 1907791.8456101222 4215167.900328777, 1907837.227916683 4215198.785509631, 1907867.2306637985 4215187.439932991, 1907891.0563747429 4215185.927189439, 1907891.31 4215183.84, 1907891.3086276192 4215183.838811968, 1907891.3092507436 4215183.838777589, 1907888.41 4215166.06, 1907903.65 4215161.41, 1907917.24 4215161.77, 1907926.81 4215158.13, 1907933.68 4215156.14, 1907940.5982092174 4215159.211948058, 1907934.7388297906 4215185.0939776385, 1907934.73 4215185.11, 1907934.7297323346 4215185.1118587665, 1907934.7346805339 4215185.11230572, 1907934.73879776 4215185.1125081815, 1907934.7368448079 4215186.242344345, 1907951.9443027123 4215188.070242804, 1907961.9662287445 4215190.591482057, 1907977.534881134 4215195.129712713, 1907993.3556574488 4215195.949115471, 1908006.8442874544 4215194.436371919, 1908066.3455338343 4215185.485972569, 1908082.6075270185 4215177.2919449955, 1908089.9191208533 4215172.375528452, 1908095.465847211 4215169.91732018, 1908126.9813378784 4215162.731788308, 1908141.6675565292 4215149.306189284, 1908143.96 4215150.62, 1908143.9597639046 4215150.629019253, 1908143.9637273992 4215150.624477123, 1908156.0063431219 4215157.438257285, 1908158.5279198426 4215146.3598468695, 1908158.5300995382 4215146.359542075, 1908162.5952551991 4215127.657764746, 1908232.7690967296 4215115.99047392, 1908237.1976916897 4215135.35895979, 1908288.7486840815 4215122.566139748, 1908314.6445145947 4215091.795418249, 1908363.15 4215091.28, 1908382.69 4215095.12, 1908408.58 4215103.84, 1908414.69 4215098.57, 1908459.59 4215121.12, 1908486.18 4215141.05, 1908512.5 4215165.13, 1908517.46 4215170.32, 1908517.2412630168 4215241.208150285, 1908501.5914521539 4215266.407672778, 1908502.5956915184 4215384.589667333, 1908590.0761032542 4215482.412934285, 1908653.7 4215556.9, 1908648.95 4215559.08, 1908610.96 4215575.37, 1908597.99 4215568.09, 1908561.88 4215548.85, 1908498.88 4215492.62, 1908468.74 4215509.45, 1908436.8176265024 4215476.649386219, 1908435.7204043954 4215492.3390095765, 1908450.466047166 4215512.817816272, 1908469.4888625988 4215585.682856749, 1908454.9739106793 4215577.340926619, 1908397.681494595 4215542.740046015, 1908382.09 4215533.64, 1908379.6251450144 4215535.14551717, 1908442.0101825888 4215640.947843696, 1908443.1447402528 4215646.620632017, 1908443.2708022154 4215653.932225851, 1908442.3883684769 4215658.722580433, 1908438.102261746 4215663.638996977, 1908439.51 4215665.68, 1908439.51342725 4215665.6804302605, 1908439.510196478 4215665.684019258, 1908436.0432010926 4215671.270148349, 1908425.701553792 4215687.918623102, 1908419.368979715 4215705.03727295, 1908415.3198313767 4215715.98320927, 1908360.5465349439 4215748.988705392, 1908352.3201911545 4215758.270996135, 1908359.5404371852 4215777.185767065, 1908362.20771162 4215784.167252581, 1908374.7023184132 4215769.778417943, 1908396.1361492998 4215759.784244537, 1908411.4220591234 4215768.256399657, 1908436.8213010794 4215773.907915921, 1908443.0917958647 4215770.320324263, 1908472.1081965999 4215805.595562783, 1908467.1116605895 4215835.917045974, 1908507.3541240436 4215870.812284013, 1908485.196979638 4215888.651746025, 1908480.408212421 4215904.985115307, 1908480.243871829 4215923.425332221, 1908475.701179757 4215923.529472001, 1908469.7879356074 4215923.664800173, 1908455.4543029016 4215917.473125944, 1908444.2728161963 4215922.936180383, 1908449.7208077183 4215928.434251031, 1908468.5878048914 4215947.48916291, 1908477.869448818 4215954.94527139, 1908492.1184882675 4215968.221043608, 1908473.6238498003 4216021.687036798, 1908456.3907564995 4216017.829564291, 1908452.135587509 4216026.317825178, 1908439.0107173843 4216040.827286076, 1908424.7060954056 4216056.648901003, 1908408.7265283782 4216056.322162048, 1908335.414340618 4215996.94079366, 1908324.270070001 4215987.645022629, 1908304.9459092214 4215972.442876285, 1908301.9386186972 4216001.051705971, 1908293.8015519697 4216021.390414868, 1908290.5690770608 4216021.11281596, 1908286.2290977014 4216035.745040374, 1908286.7306295384 4216060.638969714, 1908273.8472035453 4216064.741898847, 1908273.238237715 4216066.593871929, 1908271.9370145877 4216077.510992179, 1908272.9386318568 4216125.607700965, 1908238.0611074357 4216128.328812774, 1908236.4486009064 4216138.185998079, 1908270.3919835424 4216155.136478837, 1908279.9101594647 4216134.466392072, 1908297.3956014235 4216129.418795811, 1908363.8408983028 4216114.7635341305, 1908365.8963934896 4216143.488124258, 1908353.4004517857 4216156.336505487, 1908342.3341647426 4216156.1154275155, 1908333.8196181688 4216168.179963237, 1908327.7036986947 4216212.180032847, 1908332.8216841575 4216218.58911294, 1908347.9129469409 4216221.247742933, 1908337.9210401198 4216260.818808799, 1908326.5011639178 4216304.193666993, 1908326.8315301775 4216306.955884191, 1908330.532435406 4216337.899431752, 1908347.0041065824 4216364.0002451725, 1908372.799307755 4216376.294828625, 1908374.9795031303 4216375.302401263, 1908403.062492851 4216383.243146459, 1908399.2845058795 4216400.066163661, 1908397.6996187672 4216407.111333937, 1908393.2348817056 4216427.496770626, 1908385.3134205916 4216431.075576043, 1908390.3251066091 4216441.64752533, 1908384.9101961013 4216462.93429031, 1908376.7877524018 4216477.208968902, 1908378.3207635889 4216491.656101682, 1908381.0399137854 4216512.265338421, 1908362.3753806774 4216530.672179594, 1908351.992957866 4216558.666621853, 1908319.1244771269 4216582.188510722, 1908289.9158561677 4216603.105386282, 1908273.9066152356 4216591.271894368, 1908226.2758367038 4216610.743860933, 1908210.8904169756 4216603.202883072, 1908193.1866293799 4216610.611818724, 1908178.4846292727 4216606.151814953, 1908164.5659786188 4216605.093284354, 1908152.104178478 4216638.497745383), (1909036.0660516538 4217572.584317229, 1909093.3 4217617.96, 1909096.99 4217631.86, 1909105.22 4217662, 1909113.21 4217661.48, 1909116.15 4217675.05, 1909129.08 4217687.25, 1909125.47 4217694.65, 1909125.86 4217711.36, 1909119.4258958723 4217719.845502047, 1909061.8549815428 4217737.236715751, 1908878.6874538697 4217644.661069996, 1908906.4601475962 4217603.002029406, 1909036.0660516538 4217572.584317229))','ZO32050','"lib_modif"=>"N", "lib_code_insee"=>"38111 / 38486 / 38524", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UD2m','Pavillonnaire en densification avec secteurs où l''implantation en limite est restreinte','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD2.pdf','2019-12-20','SRID=3945;POLYGON ((1910811.4099999308 4230334.660002093, 1910811.27 4230334.75, 1910805.77 4230338.35, 1910786.43 4230351, 1910778.85 4230355.77, 1910777.41 4230356.5, 1910774.8 4230357.45, 1910772.19 4230357.91, 1910769.63 4230358.13, 1910768.06 4230357.89, 1910766.43 4230357.4, 1910765.09 4230356.6, 1910764.23 4230355.9, 1910763.38 4230355.07, 1910762.47 4230353.8, 1910757.8 4230344.72, 1910754.69 4230338.67, 1910735.9 4230301.64, 1910701.98 4230234.99, 1910704.12 4230233.24, 1910704.91 4230235.5, 1910744.17 4230203.4, 1910753.44 4230218.85, 1910754.54 4230220.69, 1910768.97 4230244.76, 1910784.06 4230269.91, 1910785.11 4230271.64, 1910798.43 4230293.55, 1910804.91 4230304.22, 1910810.11 4230312.51, 1910818.71 4230326.18, 1910818.62 4230326.26, 1910817.64 4230327.97, 1910815.6299999307 4230330.660002092, 1910819.7099999306 4230329.120002091, 1910880.6499999308 4230265.890002092, 1910907.6699999305 4230241.380002093, 1910945.6199999307 4230212.650002092, 1911025.9799999306 4230151.670002093, 1911027.9599999306 4230154.900002092, 1911029.8299999307 4230158.030002091, 1911032.0499999307 4230161.390002091, 1911033.1299999307 4230162.790002092, 1911034.6199999307 4230164.720002093, 1911037.5199999306 4230168.260002093, 1911039.8399999305 4230170.620002096, 1911042.4199999305 4230172.790002094, 1911046.4099999308 4230175.550002093, 1911050.9399999306 4230177.520002092, 1911049.0999999307 4230199.6400020905, 1911050.9299999306 4230204.970002092, 1911055.9799999306 4230219.220002092, 1911058.8799999307 4230225.680002091, 1911060.4999999306 4230229.370002091, 1911063.9599999306 4230237.210002093, 1911064.7299999306 4230238.960002093, 1911066.1899999306 4230242.240002092, 1911070.3899999307 4230251.770002092, 1911073.1899999303 4230258.100002093, 1911075.0999999307 4230262.580002093, 1911076.5199999306 4230265.890002091, 1911078.2099999303 4230269.870002094, 1911082.0499999307 4230279.160002092, 1911082.9699999306 4230281.360002093, 1911083.5099999304 4230282.880002092, 1911084.0299999304 4230289.060002095, 1911081.8799999307 4230308.350002092, 1911081.5899999307 4230311.120002093, 1911080.9499999306 4230316.490002092, 1911093.6899999306 4230305.270002093, 1911097.6299999307 4230301.880002093, 1911103.0899999307 4230297.230002093, 1911112.4899999306 4230289.250002092, 1911121.7399999306 4230281.730002094, 1911124.3899999307 4230279.570002092, 1911135.7699999306 4230269.910002093, 1911145.4799999306 4230261.510002092, 1911146.2499999306 4230260.860002092, 1911147.4499999306 4230259.860002093, 1911157.9299999303 4230245.340002094, 1911166.0699999307 4230233.930002093, 1911166.6899999303 4230233.080002094, 1911167.0699999304 4230232.540002093, 1911173.4299999303 4230223.570002093, 1911174.8599999307 4230221.720002092, 1911171.7899999307 4230219.200002093, 1911164.5599999307 4230211.370002093, 1911162.4899999304 4230209.070002093, 1911156.1499999308 4230202.060002093, 1911153.8199999304 4230199.480002093, 1911148.8599999305 4230194.180002091, 1911147.7299999306 4230192.910002093, 1911146.2399999306 4230191.260002092, 1911144.7999999307 4230189.650002092, 1911143.4699999304 4230188.270002093, 1911140.2899999307 4230184.430002092, 1911138.1299999307 4230181.840002091, 1911132.4999999306 4230175.090002093, 1911129.1399999307 4230171.140002092, 1911125.7399999304 4230167.140002092, 1911120.4399999306 4230160.810002092, 1911119.3899999305 4230159.550002093, 1911117.6399999307 4230157.490002094, 1911116.0699999304 4230155.650002094, 1911114.8599999307 4230154.230002093, 1911113.4599999306 4230152.550002092, 1911125.2899999307 4230142.130002093, 1911124.0699999304 4230140.560002093, 1911123.6599999308 4230139.980002092, 1911121.9399999306 4230137.520002092, 1911117.3999999305 4230131.030002094, 1911102.9099999308 4230109.680002093, 1911111.7099999303 4230104.320002094, 1911112.5799999307 4230103.790002094, 1911117.3199999307 4230100.890002092, 1911119.4699999304 4230099.610002093, 1911122.7899999307 4230097.600002091, 1911130.8099999307 4230092.790002094, 1911137.9499999303 4230103.070002094, 1911142.5799999307 4230099.550002093, 1911150.6899999306 4230109.240002093, 1911156.9599999303 4230104.420002094, 1911160.4199999305 4230102.520002092, 1911158.7499999304 4230096.960002094, 1911156.1099999305 4230088.000002094, 1911155.4699999304 4230085.770002093, 1911153.8399999305 4230080.2100020945, 1911153.2399999304 4230077.700002092, 1911153.0099999304 4230076.870002093, 1911152.4699999304 4230074.630002093, 1911152.2699999306 4230073.860002092, 1911150.5199999306 4230066.610002095, 1911150.3699999307 4230065.950002094, 1911149.3699999307 4230061.240002093, 1911148.5099999304 4230056.320002094, 1911148.2499999306 4230054.930002091, 1911147.9299999303 4230053.160002094, 1911147.6099999305 4230051.370002095, 1911146.9799999306 4230047.860002094, 1911146.2099999306 4230042.710002092, 1911145.7299999306 4230039.570002093, 1911144.6699999303 4230033.220002093, 1911144.1799999306 4230030.260002093, 1911142.7099999303 4230021.160002094, 1911141.9999999306 4230016.280002092, 1911122.8299999305 4230021.920002094, 1911121.5499999304 4230017.000002095, 1911120.1299999305 4230012.000002095, 1911118.0399999304 4230004.970002092, 1911116.9499999303 4230001.160002094, 1911114.0799999307 4229992.620002092, 1911111.9899999304 4229986.010002093, 1911098.2099999303 4229990.820002095, 1911083.5299999304 4229995.940002093, 1911078.6699999305 4229997.650002092, 1911069.9999999306 4230000.700002095, 1911059.8799999305 4230004.220002094, 1911064.9999999306 4230015.500002091, 1911070.9699999306 4230028.360002095, 1911071.4099999308 4230029.300002091, 1911074.7299999306 4230036.540002093, 1911076.1999999306 4230045.460002094, 1911078.7999999304 4230061.810002095, 1911074.5899999307 4230064.040002093, 1911065.1099999307 4230069.000002095, 1911055.4299999306 4230073.940002092, 1911054.0499999307 4230074.640002093, 1911052.1799999303 4230075.630002094, 1911042.8599999305 4230080.5900020925, 1911041.0499999304 4230081.530002094, 1911038.1499999305 4230083.040002095, 1911031.6199999307 4230086.5900020925, 1911024.0199999306 4230090.740002093, 1911020.5299999306 4230092.550002092, 1911016.0299999306 4230094.890002093, 1911008.9799999306 4230098.680002091, 1911005.8099999304 4230100.330002095, 1911001.0599999307 4230102.8400020925, 1910997.2199999306 4230104.870002094, 1910995.0299999306 4230106.460002094, 1910979.8499999307 4230095.800002092, 1910961.8999999308 4230087.720002092, 1910938.6799999306 4230058.290002093, 1910922.5199999306 4230035.230002094, 1910904.5699999307 4230013.170002093, 1910925.5999999307 4229993.990002094, 1910948.2199999304 4229983.820002094, 1911026.7399999304 4229959.010002092, 1911015.2299999306 4229928.090002093, 1911013.9599999303 4229900.810002095, 1911019.7999999304 4229853.820002094, 1911013.8799999305 4229861.120002094, 1911013.2299999306 4229862.310002094, 1911012.3799999307 4229863.780002094, 1911011.3799999307 4229865.140002092, 1911010.2699999306 4229866.380002092, 1911008.9599999306 4229867.570002095, 1911007.6499999308 4229868.360002094, 1911006.3599999305 4229869.120002094, 1911005.0599999304 4229869.690002095, 1911003.5099999304 4229870.330002094, 1911001.8299999307 4229870.700002094, 1911000.2299999306 4229870.950002094, 1910998.4999999306 4229871.040002095, 1910996.9399999306 4229871.1400020905, 1910993.6799999306 4229870.710002094, 1910989.2499999306 4229870.270002096, 1910985.9799999306 4229869.710002093, 1910976.8499999307 4229868.650002094, 1910974.8299999307 4229868.380002092, 1910966.0899999307 4229867.200002095, 1910960.7299999306 4229866.570002096, 1910951.2499999306 4229864.980002094, 1910947.6499999308 4229864.040002093, 1910945.0699999307 4229863.310002093, 1910943.1399999307 4229862.570002094, 1910940.6799999306 4229861.610002093, 1910937.8399999307 4229860.3000020925, 1910935.4399999306 4229859.030002094, 1910932.8199999307 4229857.360002093, 1910930.1599999308 4229855.460002094, 1910927.6599999308 4229853.450002093, 1910925.5999999307 4229851.560002094, 1910924.2599999304 4229850.270002094, 1910922.8299999307 4229848.570002094, 1910922.1799999303 4229847.920002094, 1910915.5799999307 4229840.050002094, 1910906.8799999305 4229828.340002094, 1910894.7999999307 4229812.200002094, 1910881.5999999305 4229794.770002096, 1910875.2699999306 4229786.320002096, 1910871.0399999304 4229780.770002096, 1910866.3599999307 4229774.050002094, 1910864.9099999308 4229771.680002093, 1910862.6999999306 4229768.090002093, 1910860.8999999308 4229764.810002092, 1910859.3399999305 4229761.800002095, 1910857.6399999305 4229758.010002095, 1910856.3799999307 4229754.9600020945, 1910855.1999999306 4229751.290002094, 1910852.3499999307 4229742.800002093, 1910850.3699999307 4229736.230002094, 1910848.0299999304 4229729.180002094, 1910847.7299999306 4229727.620002094, 1910847.6499999308 4229726.750002094, 1910847.7299999306 4229725.520002093, 1910847.8999999305 4229724.000002095, 1910848.4299999306 4229722.400002095, 1910848.9399999306 4229721.210002094, 1910849.5099999306 4229720.240002093, 1910850.0799999307 4229719.290002094, 1910850.8799999305 4229718.4200020945, 1910851.8899999307 4229717.4200020945, 1910852.8899999307 4229716.620002094, 1910853.9499999303 4229715.970002094, 1910854.8399999307 4229715.550002093, 1910855.9199999305 4229715.190002093, 1910856.9899999304 4229714.870002095, 1910857.7599999306 4229714.730002094, 1910860.2299999306 4229714.530002094, 1910905.4999999304 4229707.690002095, 1910906.5199999306 4229679.760002095, 1910898.2999999304 4229669.660002096, 1910925.3199999307 4229650.390002094, 1910926.0599999307 4229651.440002095, 1910954.5699999304 4229691.510002094, 1910958.2799999306 4229696.560002094, 1910981.9299999303 4229728.890002095, 1910989.3299999307 4229738.780002093, 1911001.9999999306 4229754.810002094, 1911004.1499999308 4229760.970002096, 1911008.3599999307 4229766.080002094, 1911018.3799999307 4229777.610002094, 1911019.9999999306 4229779.080002094, 1911024.3399999305 4229783.100002094, 1911030.3399999305 4229790.460002094, 1911038.8399999305 4229800.990002093, 1911045.3899999305 4229809.240002095, 1911048.5999999307 4229813.380002094, 1911058.7999999304 4229826.410002094, 1911064.1599999305 4229833.310002094, 1911069.1799999303 4229836.150002095, 1911072.5699999304 4229833.8800020935, 1911082.0999999307 4229827.490002095, 1911086.0799999307 4229824.830002092, 1911087.3699999307 4229823.980002095, 1911088.8899999307 4229822.960002094, 1911089.7899999304 4229822.360002094, 1911090.6799999303 4229821.770002095, 1911092.8999999308 4229820.280002095, 1911100.7999999304 4229815.000002095, 1911102.8199999304 4229813.650002095, 1911108.7299999306 4229809.700002095, 1911110.2399999304 4229808.680002094, 1911113.1899999303 4229807.390002093, 1911126.8599999307 4229830.810002094, 1911131.7399999306 4229849.7200020915, 1911131.8199999307 4229872.530002094, 1911131.0099999304 4229888.980002092, 1911129.5899999305 4229904.180002094, 1911134.5499999307 4229911.600002092, 1911138.9199999303 4229907.700002095, 1911141.8599999307 4229905.280002093, 1911144.5699999307 4229903.000002093, 1911145.5299999304 4229902.200002095, 1911149.6199999305 4229898.680002093, 1911151.0599999304 4229897.470002094, 1911152.5399999307 4229896.230002095, 1911154.0499999304 4229894.150002093, 1911158.2299999306 4229888.720002093, 1911162.2399999304 4229883.290002094, 1911163.5299999304 4229881.550002094, 1911168.2899999307 4229875.510002092, 1911171.3499999305 4229871.200002095, 1911173.4099999305 4229868.240002094, 1911173.9099999308 4229867.060002095, 1911175.2699999304 4229863.240002095, 1911176.6999999306 4229864.300002093, 1911177.8599999305 4229865.230002095, 1911180.2099999303 4229867.7100020945, 1911181.4099999305 4229869.000002094, 1911183.6399999305 4229871.400002093, 1911185.5299999304 4229873.370002095, 1911186.2699999304 4229874.150002094, 1911186.7699999304 4229874.590002093, 1911212.5199999304 4229899.730002095, 1911219.1599999308 4229906.0900020925, 1911221.7399999304 4229908.460002094, 1911224.3099999304 4229910.830002096, 1911232.0999999305 4229918.230002095, 1911233.7199999304 4229919.630002093, 1911235.3499999305 4229921.030002095, 1911239.1399999305 4229925.430002094, 1911241.1299999307 4229927.670002092, 1911243.1099999305 4229929.910002095, 1911245.3499999305 4229932.150002094, 1911249.0999999305 4229935.710002094, 1911252.5299999304 4229938.680002094, 1911258.3499999305 4229943.430002093, 1911261.4099999308 4229945.980002094, 1911264.4699999304 4229948.520002094, 1911267.3199999307 4229951.1300020935, 1911271.4799999304 4229954.7100020945, 1911272.9399999303 4229955.940002095, 1911276.1399999305 4229959.500002093, 1911277.3399999305 4229960.820002094, 1911277.9199999303 4229961.730002096, 1911280.8499999305 4229966.840002094, 1911284.7999999304 4229974.050002093, 1911287.8399999305 4229979.5900020925, 1911289.3 4229981.99, 1911289.8399999305 4229984.090002093, 1911290.3799999305 4229986.190002094, 1911300.9899999306 4229983.340002092, 1911310.0422276377 4229977.468286823, 1911316.1599999305 4229973.500002093, 1911328.8799999305 4229965.150002094, 1911339.4699999304 4229958.240002096, 1911346.29 4229957.82, 1911347.33 4229951.82, 1911348.12 4229948.53, 1911348.31 4229947.76, 1911348.78 4229946.87, 1911349.1 4229945.91, 1911349.51 4229945.22, 1911350.28 4229944.52, 1911350.97 4229943.94, 1911351.9 4229943.5, 1911353.3 4229943.02, 1911354.77 4229942.79, 1911355.97 4229942.77, 1911357.31 4229942.75, 1911359.39 4229942.89, 1911361.26 4229942.99, 1911362.53 4229943.11, 1911362.8246055346 4229941.267828044, 1911363.36 4229937.92, 1911363.56 4229933.78, 1911363.44 4229931.56, 1911363.31 4229922.36, 1911363.18 4229915.44, 1911363.4 4229908.97, 1911363.38 4229906.95, 1911363.12 4229905.79, 1911363.09 4229903.51, 1911363.19 4229901.36, 1911363.48 4229898.22, 1911364.55 4229888.99, 1911365.41 4229881.92, 1911366.14 4229875.41, 1911366.32 4229872.19, 1911367.09 4229864.35, 1911367.8 4229858.75, 1911368.55 4229851.54, 1911368.7 4229847.19, 1911369.01 4229841.6, 1911369.22 4229837.49, 1911369.04 4229834.63, 1911368.89 4229831.88, 1911368.69 4229830.48, 1911368.67 4229829.24, 1911368.01 4229824.08, 1911367.85 4229822.75, 1911367.66 4229821.21, 1911367.48 4229819.77, 1911367 4229817.47, 1911364.83 4229808.46, 1911363.78 4229803.89, 1911362.99 4229802.3, 1911361.78 4229799.46, 1911359.98 4229795.69, 1911358.43 4229792.05, 1911357.9 4229787.72, 1911354.66 4229767.58, 1911352.61 4229754.23, 1911350.9 4229743.72, 1911350.34 4229740.31, 1911353.12 4229740.16, 1911396.57 4229737.78, 1911439.03 4229735.51, 1911453.48 4229734.7, 1911468.23 4229733.87, 1911467.4 4229732.24, 1911466.22 4229730.63, 1911462.21 4229724.44, 1911458.71 4229719.54, 1911456.15 4229715.97, 1911452.63 4229711.33, 1911450.58 4229707.51, 1911449.5 4229704.65, 1911448.82 4229702.6, 1911447.84 4229696.24, 1911445.04 4229676.51, 1911441.2124818687 4229648.500222315, 1911440.04 4229639.92, 1911438.06 4229625.09, 1911404.39 4229627.19, 1911378 4229629.05, 1911378.71 4229666.08, 1911349.67 4229668.2, 1911344.3999999305 4229668.530002094, 1911345.9699999304 4229654.910002093, 1911347.7199999304 4229640.490002095, 1911349.5899999305 4229625.190002095, 1911351.3399999305 4229610.810002094, 1911353.2499999304 4229595.140002094, 1911353.2099999303 4229592.6700020945, 1911353.6299999305 4229585.570002096, 1911353.5399999304 4229571.350002095, 1911352.7991868416 4229544.417051662, 1911346.3699999305 4229545.320002096, 1911342.3499999305 4229549.160002093, 1911337.2999999304 4229549.300002095, 1911300.2899999304 4229550.360002094, 1911292.0499999304 4229550.600002095, 1911288.8699999305 4229550.700002096, 1911251.1799999303 4229551.950002096, 1911206.7799999304 4229553.280002096, 1911206.1899999303 4229542.420002095, 1911205.9499999303 4229538.080002094, 1911203.3999999305 4229491.390002094, 1911203.1899999306 4229487.370002094, 1911199.6399999305 4229420.690002094, 1911217.4699999304 4229419.770002095, 1911259.7799999304 4229417.570002095, 1911286.0599999304 4229416.200002096, 1911336.2099999303 4229413.470002096, 1911339.9699999304 4229413.590002094, 1911347.7837036564 4229413.499420344, 1911348.0799999305 4229403.100002094, 1911348.4399999303 4229357.430002096, 1911347.2599999304 4229337.730002095, 1911342.2799999304 4229272.850002095, 1911342.1399999305 4229271.130002095, 1911337.3899999305 4229241.530002096, 1911332.1199999305 4229208.710002095, 1911325.2699999304 4229177.120002097, 1911325.1699999303 4229171.520002096, 1911325.016995558 4229163.057403125, 1911345.97 4229160.89, 1911381.57 4229156.98, 1911411.23 4229153.65, 1911448.84 4229149.64, 1911453.05 4229149.94, 1911453.1 4229147.28, 1911477.59 4229147.02, 1911489.9 4229146.94, 1911509.75 4229146.56, 1911507.65 4229137.87, 1911506.4 4229136.42, 1911511.42 4229131.94, 1911529.81 4229115.51, 1911531.2340413937 4229113.950186487, 1911523.33 4229107.26, 1911522.92 4229106.78, 1911506.5 4229098.19, 1911505.55 4229097.93, 1911500.8362429435 4229096.677881033, 1911505.4 4229088.76, 1911511.39 4229076.2, 1911511.85 4229076.46, 1911512.89 4229074.07, 1911525.18 4229045.85, 1911530.54 4229048.05, 1911539.95 4229011.01, 1911514.4499999303 4229005.020002097, 1911517.7699999304 4229001.490002096, 1911518.69999993 4229000.500002099, 1911542.94999993 4228978.6600020975, 1911543.7499999302 4228971.9100020975, 1911545.7499999302 4228955.070002097, 1911552.0399999302 4228925.180002096, 1911552.2899999304 4228923.980002096, 1911548.9099999303 4228923.960002097, 1911543.3799999305 4228923.930002095, 1911542.66999993 4228928.760002097, 1911541.7999999302 4228934.580002098, 1911537.70999993 4228933.890002095, 1911532.5599999302 4228933.020002098, 1911521.6399999303 4228931.180002097, 1911521.6899999303 4228930.250002096, 1911514.0999999305 4228929.5000020955, 1911513.8899999303 4228930.4100020975, 1911507.3499999302 4228928.890002097, 1911506.68999993 4228931.690002097, 1911499.5899999305 4228930.450002096, 1911494.9099999305 4228929.300002096, 1911494.4299999303 4228930.990002095, 1911490.0599999304 4228946.490002097, 1911488.2099999303 4228946.030002096, 1911474.2399999304 4228941.800002095, 1911475.6999999303 4228936.970002096, 1911476.6999999303 4228933.640002096, 1911472.8099999304 4228932.550002095, 1911449.8199999304 4228926.100002096, 1911455.8899999303 4228917.820002098, 1911462.8299999305 4228910.080002096, 1911453.3899999303 4228904.120002097, 1911462.3099999304 4228884.950002096, 1911468.7299999301 4228887.580002097, 1911471.0499999304 4228882.170002096, 1911478.5799999305 4228864.630002094, 1911482.6499999305 4228866.130002096, 1911497.1099999303 4228871.420002097, 1911499.7199999304 4228864.190002096, 1911504.7999999304 4228866.020002096, 1911512.95999993 4228868.960002096, 1911509.6999999303 4228875.910002095, 1911506.3399999305 4228886.300002096, 1911511.43999993 4228887.300002095, 1911521.42999993 4228885.560002097, 1911530.9999999302 4228882.910002098, 1911539.6499999303 4228878.610002098, 1911542.7299999301 4228877.750002097, 1911542.0999999302 4228891.840002095, 1911541.9999999302 4228893.980002098, 1911559.0099999304 4228895.270002096, 1911559.20999993 4228893.240002098, 1911561.6099999305 4228868.190002097, 1911555.97 4228867.79, 1911567.96 4228859.76, 1911568.19 4228859.64, 1911572.18 4228854.13, 1911578.47 4228843.88, 1911578.65 4228843.58, 1911582.74 4228836.68, 1911584.95 4228832.93, 1911588.69 4228822.2, 1911590.56 4228798.17, 1911590.6 4228797.55, 1911590.2 4228776.24, 1911587.84 4228760.62, 1911582.52 4228761.94, 1911567.25 4228767.6, 1911553.54 4228769.18, 1911553.31 4228760.08, 1911555.19 4228753.24, 1911555.09 4228743.87, 1911554.9076453478 4228724.635925966, 1911554.88 4228721.72, 1911555.18 4228709.52, 1911555.03 4228692.17, 1911555.2604009148 4228690.749874008, 1911549.52 4228690.04, 1911510.23 4228686.2, 1911503.4244017717 4228685.395080381, 1911498.118240696 4228684.508228364, 1911495.5317999304 4228691.384402094, 1911491.4444999304 4228708.498602095, 1911489.8631999304 4228717.536202096, 1911484.9233855442 4228739.095190465, 1911483.7703999304 4228744.1272020945, 1911478.7363221177 4228755.194541253, 1911465.0699999304 4228764.7500020955, 1911428.8399999305 4228847.430002096, 1911425.5499999304 4228854.7100020945, 1911424.8399999305 4228856.280002098, 1911419.9999999304 4228852.940002095, 1911414.6799999303 4228849.280002096, 1911405.5699999304 4228842.980002096, 1911374.6299999305 4228844.630002095, 1911343.9599999303 4228824.510002095, 1911342.6099999303 4228823.620002098, 1911316.0399999302 4228806.1500021, 1911309.5699999304 4228805.070002099, 1911304.7099999303 4228801.800002095, 1911296.94999993 4228813.810002099, 1911279.6699999303 4228840.670002095, 1911270.3499999305 4228828.400002097, 1911269.7299999304 4228827.7000020975, 1911264.7699999304 4228822.390002095, 1911260.0399999304 4228817.730002097, 1911258.6999999303 4228816.410002098, 1911256.2099999303 4228813.880002098, 1911245.9099999305 4228803.980002096, 1911235.3699999305 4228809.2500020955, 1911246.2999999304 4228819.3700020965, 1911247.8199999304 4228820.780002097, 1911250.2399999304 4228823.020002098, 1911251.7599999304 4228824.670002095, 1911257.1699999303 4228830.560002097, 1911260.1399999305 4228834.210002096, 1911260.8299999305 4228835.060002097, 1911261.1599999305 4228835.590002096, 1911268.7299999304 4228847.400002096, 1911272.2399999304 4228851.7500020955, 1911273.3799999305 4228853.160002096, 1911276.0099999304 4228856.4100020975, 1911286.2999999304 4228869.190002097, 1911289.5999999305 4228872.580002097, 1911292.7899999304 4228877.130002096, 1911300.3299999302 4228887.890002098, 1911305.9199999303 4228895.790002096, 1911288.0499999304 4228905.820002098, 1911273.6999999303 4228913.660002094, 1911255.3599999305 4228923.850002096, 1911261.5399999307 4228947.380002095, 1911264.0699999304 4228956.9500020975, 1911269.7399999304 4228978.510002097, 1911271.0499999304 4228982.860002098, 1911272.3199999304 4228987.070002096, 1911274.2799999304 4228986.490002097, 1911277.6699999303 4228997.870002095, 1911285.4999999304 4229024.130002095, 1911250.3399999305 4229033.830002096, 1911252.3699999305 4229043.130002095, 1911254.0799999305 4229051.810002095, 1911218.0599999304 4229063.430002095, 1911225.7999999304 4229093.170002096, 1911237.1099999305 4229136.690002097, 1911242.6299999305 4229158.820002097, 1911229.3099999304 4229156.470002095, 1911217.8899999305 4229154.410002097, 1911206.5899999305 4229153.560002096, 1911198.8999999305 4229153.760002097, 1911190.5099999304 4229155.080002095, 1911187.0399999304 4229156.050002096, 1911182.6399999305 4229157.3300020965, 1911150.9999999304 4229167.350002094, 1911089.2099999303 4229187.020002096, 1911047.8899999307 4229199.510002093, 1911025.7799999304 4229204.2000020975, 1911017.59 4229204.59, 1910996.71 4229205.41, 1910953.82 4229209.49, 1910948.3 4229210.02, 1910944.46 4229210.26, 1910915.22 4229217.87, 1910902.92 4229219.82, 1910890.68 4229220.84, 1910867.99 4229222.74, 1910864.58 4229223.03, 1910857.35 4229224.06, 1910838.98 4229225.43, 1910834.25 4229225.95, 1910829.88 4229225.59, 1910827.37 4229225.17, 1910824.6499999308 4229224.620002095, 1910823.8999999308 4229224.280002094, 1910815.8699999307 4229221.820002094, 1910810.6399999307 4229219.310002097, 1910804.9899999306 4229227.380002094, 1910800.4499999303 4229232.550002094, 1910796.7799999304 4229236.460002096, 1910793.5599999304 4229239.900002098, 1910782.6499999308 4229252.020002094, 1910775.0199999306 4229260.890002093, 1910746.0199999306 4229291.470002094, 1910710.3999999308 4229329.630002096, 1910660.8499999307 4229382.220002097, 1910664.6599999308 4229385.700002097, 1910667.5799999307 4229386.070002095, 1910671.7499999306 4229387.160002094, 1910677.1999999306 4229388.900002095, 1910691.8999999308 4229393.530002095, 1910697.3499999307 4229395.370002095, 1910702.7499999306 4229397.190002095, 1910701.9799999306 4229399.370002096, 1910700.1699999305 4229398.790002095, 1910679.1099999307 4229422.410002096, 1910676.1099999307 4229425.780002095, 1910667.0199999306 4229435.840002093, 1910656.9099999308 4229447.020002095, 1910645.3499999307 4229459.800002094, 1910643.2799999306 4229462.080002096, 1910630.9399999306 4229475.640002095, 1910619.359999931 4229488.360002093, 1910612.6699999305 4229495.700002096, 1910611.4099999308 4229497.080002095, 1910594.46 4229515.67, 1910587.91 4229522.86, 1910582.39 4229528.95, 1910570.21 4229542.37, 1910558.17 4229555.65, 1910554.4799999306 4229558.730002095, 1910552.3299999307 4229561.040002095, 1910556.3899999307 4229565.420002094, 1910557.7899999307 4229566.970002094, 1910563.6399999307 4229573.440002096, 1910569.9499999306 4229579.900002095, 1910571.1999999308 4229581.180002093, 1910581.6399999307 4229592.320002094, 1910582.6399999307 4229593.310002096, 1910592.2999999307 4229602.790002095, 1910595.7499999306 4229606.310002094, 1910598.899999931 4229608.410002093, 1910606.8299999307 4229616.040002094, 1910612.9999999306 4229621.920002095, 1910618.2599999306 4229627.580002093, 1910619.2299999306 4229628.730002096, 1910619.1099999307 4229629.620002095, 1910618.7499999306 4229632.010002092, 1910617.0199999306 4229643.680002093, 1910603.2999999307 4229658.610002095, 1910592.2499999306 4229670.630002095, 1910591.5899999307 4229671.360002093, 1910579.5399999307 4229684.380002094, 1910567.6599999308 4229697.210002093, 1910563.6699999305 4229701.510002093, 1910558.0899999307 4229707.540002095, 1910536.5999999307 4229730.250002094, 1910533.3099999307 4229733.740002096, 1910530.5899999307 4229736.130002094, 1910528.3999999308 4229738.030002096, 1910526.549999931 4229739.580002093, 1910518.4299999306 4229746.360002093, 1910517.9399999306 4229746.770002094, 1910508.4699999306 4229754.360002094, 1910499.9899999306 4229761.150002095, 1910488.4399999306 4229770.410002094, 1910486.5199999306 4229771.9200020945, 1910480.92 4229777.14, 1910474.3 4229783.33, 1910455.09 4229801.24, 1910429.01 4229825.65, 1910414.42 4229839.15, 1910410.6 4229842.67, 1910399.0399999307 4229851.980002093, 1910402.5599999307 4229856.150002095, 1910404.359999931 4229858.490002096, 1910405.4999999308 4229860.3400020925, 1910406.4399999306 4229862.160002094, 1910407.1399999307 4229864.1300020935, 1910407.879999931 4229866.160002093, 1910408.4399999306 4229868.230002093, 1910408.899999931 4229870.210002094, 1910409.3199999307 4229872.860002095, 1910409.6899999306 4229875.580002095, 1910410.089999931 4229878.770002093, 1910410.4299999306 4229881.660002096, 1910410.6099999307 4229883.800002093, 1910410.629999931 4229885.780002094, 1910410.5999999307 4229890.610002095, 1910410.4899999308 4229894.150002092, 1910410.099999931 4229899.360002094, 1910409.619999931 4229906.220002092, 1910408.9299999306 4229917.930002093, 1910408.6599999308 4229922.680002094, 1910408.1699999308 4229927.820002093, 1910408.0399999307 4229931.100002094, 1910407.7399999306 4229933.260002092, 1910407.4499999308 4229934.580002094, 1910406.9499999306 4229936.810002095, 1910406.1899999306 4229939.080002094, 1910405.619999931 4229940.680002091, 1910404.7299999306 4229942.640002092, 1910403.7599999306 4229944.350002094, 1910402.909999931 4229945.990002092, 1910401.6899999308 4229948.010002093, 1910400.2299999308 4229950.360002093, 1910398.5099999309 4229952.400002093, 1910397.1699999308 4229954.290002094, 1910394.9699999308 4229956.680002092, 1910391.6799999306 4229960.370002094, 1910386.7099999308 4229965.850002093, 1910381.299999931 4229971.930002092, 1910350.4199999305 4230006.720002093, 1910320.2599999309 4230040.170002093, 1910306.339999931 4230055.8800020935, 1910291.1699999308 4230073.040002093, 1910275.9999999308 4230089.910002093, 1910270.149999931 4230096.400002091, 1910251.869999931 4230116.960002091, 1910250.7599999309 4230118.240002095, 1910239.809999931 4230130.790002093, 1910226.7299999308 4230145.2200020915, 1910217.359999931 4230155.940002093, 1910213.2199999306 4230160.310002094, 1910210.1899999308 4230163.3400020925, 1910208.4999999308 4230164.840002094, 1910206.789999931 4230166.250002092, 1910184.604699931 4230180.847602091, 1910198.530499931 4230200.948202092, 1910203.2449999312 4230213.85220209, 1910204.348199931 4230217.1532020895, 1910208.8575999308 4230225.354802092, 1910237.8123999308 4230266.955602093, 1910243.721099931 4230273.254402091, 1910246.329999931 4230281.757802091, 1910249.1598478393 4230292.464472525, 1910253.289999931 4230289.600002092, 1910289.0299999309 4230269.060002093, 1910304.159999931 4230260.520002092, 1910306.2499999308 4230259.330002092, 1910308.4999999306 4230257.570002095, 1910315.549999931 4230252.060002092, 1910333.4799999308 4230271.810002092, 1910342.049999931 4230281.260002092, 1910342.7399999308 4230282.020002094, 1910350.6699999308 4230290.280002093, 1910367.819999931 4230308.120002093, 1910381.299999931 4230295.910002094, 1910382.7099999308 4230294.640002091, 1910401.3937637897 4230277.843934021, 1910413.944999931 4230293.220002091, 1910432.8311741194 4230318.651170047, 1910453.668786196 4230344.447574235, 1910444.4520642299 4230354.920646077, 1910425.881849482 4230376.0222040815, 1910404.353586294 4230406.215573242, 1910408.9399999308 4230408.390002091, 1910434.7599999309 4230418.270002092, 1910458.1799999308 4230427.2200020915, 1910458.7399999308 4230427.440002092, 1910493.59 4230388.75, 1910500.5 4230366.92, 1910506.31 4230360.05, 1910502.36 4230356.4, 1910498.07 4230353.17, 1910493.48 4230350.39, 1910488.63 4230348.08, 1910483.57 4230346.27, 1910481.65 4230345.69, 1910466.509399931 4230329.2974020885, 1910475.4840711756 4230318.212021985, 1910485.698499931 4230303.164402091, 1910491.9523906189 4230294.127741847, 1910513.9840999306 4230265.616402093, 1910540.1018199737 4230234.963406639, 1910550.452012944 4230222.762687332, 1910550.1884831146 4230222.467243684, 1910556.3905739456 4230216.221120925, 1910564.5670768346 4230207.98656871, 1910566.8099999307 4230210.730002093, 1910569.4899999306 4230213.990002093, 1910573.7799999306 4230219.2200020915, 1910584.6099999307 4230232.430002092, 1910576.589999931 4230238.530002092, 1910588.8199999307 4230253.1400020905, 1910592.879999931 4230257.990002094, 1910607.6599999308 4230275.450002092, 1910622.2499999306 4230292.960002093, 1910630.8399999307 4230303.210002093, 1910635.0299999306 4230305.270002093, 1910643.6999999308 4230309.530002091, 1910662.2799999306 4230318.870002094, 1910666.3799999307 4230320.500002093, 1910657.0155456443 4230346.481381014, 1910638.18 4230398.74, 1910638.08 4230399.01, 1910637.33 4230401.08, 1910630.0960559142 4230420.429812186, 1910630.01 4230420.66, 1910625.7 4230432.19, 1910625.16 4230433.63, 1910625.09 4230433.83, 1910618.9899999308 4230450.150002093, 1910665.3799999307 4230422.6700020945, 1910668.4599999308 4230441.740002092, 1910670.6499999308 4230455.770002093, 1910674.1699999305 4230470.660002093, 1910675.6599999308 4230476.500002094, 1910676.5299999306 4230478.840002092, 1910677.9399999306 4230481.480002091, 1910679.909999931 4230484.500002091, 1910680.7499999306 4230485.620002092, 1910659.9599999306 4230502.1000020895, 1910656.8799999307 4230504.510002092, 1910633.9699999306 4230522.490002093, 1910653.9799999306 4230541.320002091, 1910669.4799999306 4230555.780002093, 1910674.9899999308 4230560.820002091, 1910667.0599999307 4230566.66000209, 1910652.6899999308 4230580.300002092, 1910656.3499999307 4230586.090002091, 1910666.579999931 4230601.980002092, 1910682.9899999306 4230591.580002091, 1910698.139999931 4230615.890002091, 1910694.8499999307 4230620.620002093, 1910698.079999931 4230635.060002092, 1910724.6899999308 4230644.40000209, 1910726.7499999306 4230644.630002092, 1910739.859999931 4230631.52000209, 1910755.0499999307 4230615.470002094, 1910764.8299999307 4230626.470002091, 1910764.9899999306 4230627.1400020905, 1910766.04 4230631.47, 1910768.98 4230645.54, 1910802.0351314514 4230641.966658159, 1910801.6499999308 4230607.570002093, 1910823.6699999305 4230595.770002091, 1910823.0999999307 4230583.420002093, 1910815.589999931 4230586.6800020905, 1910813.5599999307 4230581.620002093, 1910810.0999999307 4230580.900002093, 1910798.5099999306 4230578.980002093, 1910791.9599999306 4230578.070002092, 1910785.2799999306 4230576.710002091, 1910783.0099999306 4230556.500002092, 1910778.9899999306 4230545.240002091, 1910774.7399999306 4230533.590002092, 1910760.7299999306 4230538.800002093, 1910756.359999931 4230540.450002092, 1910742.5199999306 4230545.310002093, 1910741.9199999305 4230539.280002093, 1910741.4999999306 4230538.870002092, 1910739.7899999307 4230537.190002093, 1910731.5299999309 4230522.720002091, 1910728.9599999306 4230517.550002091, 1910752.1099999307 4230501.580002092, 1910753.2599999306 4230500.900002092, 1910782.4999999306 4230481.190002092, 1910791.9499999306 4230476.230002092, 1910797.6899999306 4230473.210002094, 1910798.6099999307 4230474.620002091, 1910806.7799999306 4230468.790002092, 1910814.4499999306 4230463.920002092, 1910815.3099999307 4230463.370002092, 1910821.0799999307 4230459.700002092, 1910824.8999999308 4230456.750002092, 1910826.9099999308 4230455.230002092, 1910837.0899999307 4230447.590002092, 1910854.5999999307 4230434.560002094, 1910857.7199999306 4230432.090002091, 1910859.3299999307 4230430.830002092, 1910856.1199999307 4230419.620002093, 1910852.3899999307 4230409.690002093, 1910845.6199999307 4230394.400002092, 1910838.1099999307 4230380.9600020945, 1910830.7199999306 4230366.610002091, 1910818.2799999306 4230344.910002094, 1910811.4099999308 4230334.660002093), (1910625.7099999306 4230191.830002093, 1910621.5499999307 4230198.230002094, 1910616.7799999306 4230203.600002092, 1910603.0199999306 4230187.780002093, 1910594.6699999305 4230177.270002093, 1910594.0499999307 4230176.630002092, 1910592.9399999306 4230175.480002093, 1910591.9099999308 4230174.3400020925, 1910590.7399999306 4230173.110002094, 1910587.5699999307 4230168.900002093, 1910604.8499999307 4230154.600002094, 1910608.809999931 4230151.320002093, 1910617.0199999306 4230144.490002091, 1910630.2399999306 4230133.520002095, 1910633.6199999307 4230137.750002092, 1910652.4199999305 4230121.890002093, 1910661.6899999308 4230114.070002093, 1910669.3799999307 4230107.590002092, 1910676.5499999307 4230115.830002094, 1910699.0599999307 4230141.750002091, 1910703.2199999306 4230147.010002092, 1910686.3299999307 4230163.820002094, 1910652.4199999305 4230188.850002091, 1910650.7599999306 4230188.460002093, 1910641.9499999306 4230187.410002092, 1910629.8699999307 4230186.150002092, 1910628.3399999307 4230186.020002094, 1910625.7099999306 4230191.830002093), (1910590.2899999307 4230102.210002094, 1910563.4599999308 4230125.190002091, 1910562.6599999308 4230125.910002094, 1910561.6999999306 4230126.330002095, 1910560.6099999307 4230126.680002094, 1910559.1799999308 4230126.770002092, 1910557.9599999306 4230126.590002093, 1910556.8799999307 4230126.060002094, 1910555.7099999308 4230125.330002092, 1910554.7199999306 4230124.140002091, 1910544.7299999306 4230112.050002092, 1910543.7699999306 4230110.430002093, 1910515.1899999308 4230095.940002091, 1910512.6299999307 4230095.970002094, 1910509.6399999307 4230095.790002095, 1910505.6599999308 4230095.570002094, 1910502.3199999307 4230095.440002095, 1910499.1099999307 4230095.470002093, 1910495.609999931 4230095.590002092, 1910490.359999931 4230095.970002093, 1910490.0299999306 4230094.740002094, 1910482.1999999306 4230065.210002094, 1910476.8899999307 4230045.150002094, 1910465.319999931 4230032.950002092, 1910458.4699999308 4230025.640002091, 1910451.0699999307 4230017.350002094, 1910446.549999931 4230012.600002092, 1910454.6299999307 4230005.070002094, 1910464.5299999306 4229995.840002093, 1910481.3999999308 4229980.1300020935, 1910484.399999931 4229977.350002093, 1910502.3199999307 4229960.750002094, 1910503.2199999306 4229959.920002094, 1910506.1699999305 4229957.200002094, 1910509.8199999307 4229961.220002093, 1910512.3199999307 4229964.220002092, 1910515.0099999306 4229967.200002095, 1910517.4299999306 4229970.220002094, 1910518.9099999308 4229971.990002094, 1910522.4999999308 4229977.0500020925, 1910527.1499999308 4229983.610002094, 1910530.5999999307 4229988.490002092, 1910535.0999999307 4229994.7100020945, 1910538.1699999308 4229999.110002091, 1910540.7799999309 4230002.530002093, 1910541.8599999307 4230004.150002094, 1910543.1699999305 4230006.350002091, 1910544.059999931 4230007.960002094, 1910544.629999931 4230009.380002093, 1910545.1799999306 4230011.110002093, 1910545.5599999307 4230012.5900020925, 1910545.9199999308 4230014.6300020935, 1910546.049999931 4230016.020002093, 1910546.1699999305 4230017.240002093, 1910546.4799999306 4230019.8000020925, 1910551.7399999306 4230050.700002093, 1910578.3799999307 4230077.090002093, 1910617.6199999307 4230043.650002093, 1910634.9999999306 4230064.670002094, 1910600.5699999307 4230093.430002092, 1910590.2899999307 4230102.210002094))','ZO32049','"lib_modif"=>"N", "lib_code_insee"=>"38382", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','N','Naturelle','N',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/N.pdf','2019-12-20','SRID=3945;POLYGON ((1917052.789999929 4236260.440002077, 1917050.74 4236253.22, 1917047.84 4236244.93, 1917041.23 4236229.51, 1917040.52 4236229.2, 1917040.07 4236228.56, 1917039.98 4236228.14, 1917027.01 4236199.13, 1917028.33 4236198.73, 1917028.17 4236198.3, 1917027.05 4236195.31, 1917020.04 4236167.91, 1917020.07 4236148.93, 1917019.5 4236055.7, 1917015.87 4235995.91, 1917017.95 4235976.91, 1917014.87 4235936.35, 1917015.51 4235924.88, 1917018.11 4235917.57, 1917023.09 4235909.05, 1917108.049999929 4235936.690002078, 1917118.309999929 4235863.070002077, 1917140.949999929 4235782.050002078, 1917142.949999929 4235775.220002077, 1917149.949999929 4235752.760002077, 1917176.459999929 4235679.560002078, 1917179.769999929 4235668.1800020775, 1917199.879999929 4235674.780002078, 1917250.999999929 4235691.560002078, 1917268.849999929 4235695.290002078, 1917288.329999929 4235699.370002079, 1917302.329999929 4235705.130002077, 1917368.8599999289 4235677.04000208, 1917434.1599999291 4235658.500002078, 1917434.5899999288 4235622.070002078, 1917434.819999929 4235613.650002078, 1917269.419999929 4235581.010002077, 1917188.719999929 4235535.590002079, 1917185.1499999291 4235529.140002079, 1917172.709999929 4235496.770002079, 1917153.599999929 4235423.6000020765, 1917135.109999929 4235368.90000208, 1917119.339999929 4235283.280002079, 1917073.919999929 4235206.43000208, 1917043.719999929 4235161.520002081, 1917027.0199999288 4235130.59000208, 1917011.239999929 4235101.700002082, 1917003.469999929 4235084.760002079, 1917030.349999929 4235086.15000208, 1917035.289999929 4235077.52000208, 1917038.669999929 4235069.07000208, 1917039.109999929 4235060.390002079, 1917460.8799999289 4235257.480002079, 1917493.1587334601 4235272.805569276, 1917675.253883612 4235357.674439858, 1917831.8599999286 4235430.84000208, 1917819.2899999288 4235459.910002081, 1917822.4699999287 4235520.770002079, 1917963.3099999288 4235547.800002078, 1917992.3499999288 4235501.220002078, 1918013.6699999287 4235467.540002077, 1917978.6799999285 4235377.20000208, 1917959.5799999288 4235280.54000208, 1917952.139999929 4235197.490002081, 1917956.3021155095 4235099.351697857, 1917915.84855514 4235066.408391748, 1917867.0910931227 4235026.702813756, 1917649.6904956184 4234885.438052357, 1917603.5514898181 4234854.326257841, 1917600.7691396985 4234852.0986740785, 1917575.068740973 4234827.120386001, 1917480.0904269593 4234733.679565296, 1917442.1986191494 4234696.649810108, 1917361.6672996047 4234617.880674704, 1917306.1441809938 4234562.5026559625, 1917301.4938736893 4234543.86180701, 1917291.0174999647 4234474.71999997, 1917282.1253785163 4234416.542445845, 1917270.7281946721 4234341.975281665, 1917244.343116025 4234169.3483838, 1917205.8119527842 4234148.760110441, 1917150.4920819232 4234116.850246277, 1916973.278293282 4234020.101899061, 1916964.605546372 4234015.313237463, 1916959.4615771263 4234012.485578376, 1916954.5998553012 4234009.671570891, 1916950.1014055763 4234007.080547868, 1916947.9660222696 4234005.7781579085, 1916942.8484806353 4233998.808248223, 1916920.457965459 4233968.11597927, 1916903.8056670916 4233949.061462507, 1916885.891166498 4233928.735913462, 1916856.4467466178 4233900.156696351, 1916845.9780066088 4233888.36183696, 1916840.6155698975 4233878.247173415, 1916831.6548861535 4233849.544964559, 1916827.7571009817 4233805.7000389695, 1916816.5110487295 4233768.61260359, 1916810.8802561655 4233753.519631631, 1916778.1048411843 4233699.423215541, 1916772.0837785292 4233683.665113396, 1916766.9249999612 4233663.704999934, 1916701.893340061 4233458.155000009, 1916683.5111943379 4233409.957813825, 1916642.7837249022 4233304.219927021, 1916639.5281559804 4233302.135725559, 1916634.331788571 4233295.722851725, 1916592.7137499852 4233295.653749984, 1916504.960307622 4233290.347374791, 1916461.329325556 4233274.489607236, 1916415.0040789426 4233281.646022264, 1916363.9992317155 4233269.007015987, 1916338.7234399123 4233251.064745082, 1916321.1778999984 4233237.4824626045, 1916309.8105371487 4233229.686236382, 1916295.3702119559 4233229.030762697, 1916280.685441107 4233238.469036834, 1916266.0356621668 4233242.525437672, 1916264.4628912963 4233266.33776765, 1916260.1620268014 4233273.543680214, 1916227.4083855953 4233264.62207996, 1916198.7231068655 4233261.015570077, 1916184.0173578267 4233273.8957255725, 1916169.9267532062 4233276.892891686, 1916117.406356271 4233297.342297565, 1916125.418262299 4233331.207747358, 1916146.120262753 4233374.375872527, 1916157.5489324818 4233392.534778993, 1916162.437551372 4233398.97433293, 1916173.1753085542 4233410.446612153, 1916182.4240495022 4233419.988950967, 1916185.1560504353 4233425.7634174945, 1916186.1638768055 4233435.495814793, 1916179.7158188908 4233464.223086595, 1916175.1671113574 4233474.448773176, 1916163.1429897412 4233509.528164671, 1916160.8851369156 4233519.443230895, 1916159.882000625 4233526.331261234, 1916161.3751780367 4233535.305985328, 1916175.9349595143 4233582.725182187, 1916182.491787081 4233609.721532952, 1916191.3166557457 4233641.855205685, 1916189.9825323941 4233642.632595628, 1916190.5370325788 4233644.761366452, 1916176.1611141937 4233637.423659475, 1916161.7890524147 4233613.966528868, 1916144.8687961074 4233600.043286678, 1916138.6634773372 4233594.447281137, 1916103.3183524983 4233578.2529901285, 1916096.135368512 4233572.430844269, 1916092.43939975 4233567.701986088, 1916087.5851460814 4233561.659311335, 1916080.5762324638 4233556.5996993985, 1916072.3991795636 4233550.67601838, 1916068.8917557567 4233547.910935446, 1916065.7930793623 4233545.062187641, 1916054.7689424474 4233532.148663253, 1916047.786366453 4233523.8045465695, 1916036.9007874078 4233510.946283547, 1916023.1462258135 4233496.401280443, 1916009.5675000018 4233476.368750001, 1916002.279052679 4233470.6552789295, 1915987.8797545831 4233461.049626779, 1915983.6488313272 4233457.955276993, 1915981.0671398537 4233454.543133651, 1915974.3137500014 4233442.246249971, 1915962.6589556017 4233438.282613986, 1915960.110400589 4233434.670902285, 1915959.6024696175 4233433.972695247, 1915959.1229313964 4233432.723701798, 1915944.9921475125 4233394.5234312145, 1915943.6051605046 4233396.059120533, 1915942.2939619161 4233392.780421383, 1915937.699608031 4233400.823363934, 1915922.4131275204 4233456.55447875, 1915917.652584162 4233501.581577074, 1915914.282809254 4233511.390710107, 1915905.6999795472 4233521.065833533, 1915896.203124229 4233531.681212862, 1915889.7396248407 4233539.223092526, 1915877.8748291372 4233556.148035623, 1915879.1858275717 4233567.186226892, 1915905.1620056336 4233613.52815305, 1915906.29 4233618.96, 1915902.1241183784 4233615.989545278, 1915904.624442498 4233621.568560307, 1915890.0919584804 4233611.53591104, 1915857.6924999948 4233560.183750048, 1915832.4907100918 4233486.165915887, 1915826.5632216437 4233486.727534689, 1915765.6817661708 4233544.260951446, 1915756.2268058532 4233554.833476296, 1915748.9169108532 4233564.145732268, 1915740.8781027955 4233575.689582983, 1915739.530763869 4233579.577693039, 1915737.0666354154 4233587.512731816, 1915738.362889671 4233614.32175612, 1915741.5299999292 4233613.290002083, 1915742.5599999293 4233609.480002084, 1915743.6499999294 4233606.570002084, 1915747.4599999292 4233602.100002083, 1915751.5899999293 4233597.920002085, 1915756.3299999293 4233593.790002084, 1915761.5399999293 4233590.840002082, 1915766.9399999292 4233588.280002084, 1915769.1799999292 4233587.340002083, 1915788.7499999292 4233609.720002084, 1915836.0199999292 4233627.7000020845, 1915882.3799999293 4233669.540002086, 1915915.7599999292 4233700.260002085, 1915942.0799999293 4233713.9500020845, 1915956.3099999293 4233759.030002082, 1915966.3499999293 4233780.310002084, 1915971.3499999293 4233807.690002086, 1915968.9599999292 4233829.550002082, 1915931.3499999293 4233836.440002082, 1915918.3399999293 4233847.940002084, 1915824.1099999296 4233829.890002081, 1915822.0499999293 4233826.120002083, 1915794.0199999292 4233784.980002082, 1915787.9499999292 4233776.250002082, 1915782.2299999294 4233767.280002082, 1915778.2199999292 4233760.470002082, 1915775.8899999293 4233756.050002085, 1915773.9499999292 4233751.4500020845, 1915772.8999999294 4233748.390002081, 1915771.0499999293 4233740.340002084, 1915767.7399999294 4233715.290002083, 1915765.4099999294 4233705.7900020825, 1915762.9099999296 4233696.440002082, 1915739.6099999293 4233643.720002084, 1915736.2845595707 4233627.465388497, 1915734.51859566 4233632.253577687, 1915671.4841704427 4233715.041789685, 1915625.1137992886 4233822.822084951, 1915572.2117419285 4233903.452200442, 1915565.1676631558 4233909.7477466175, 1915558.7803296857 4233913.192493932, 1915491.830927873 4233915.345407282, 1915491.7286814288 4233917.65243806, 1915491.0824764946 4233917.686316766, 1915490.2792796472 4233947.817733838, 1915490.1030410076 4233954.332466519, 1915489.901675108 4233961.414436621, 1915489.7378994247 4233967.219548884, 1915488.9953119478 4234015.048527898, 1915488.714091642 4234091.051436168, 1915488.4179402776 4234146.884508821, 1915487.8414934278 4234281.30218306, 1915486.6507939221 4234510.781906913, 1915483.808625669 4234569.750416477, 1915481.9534707165 4234596.605319343, 1915464.6106477352 4234644.366457529, 1915446.5466408273 4234708.294764978, 1915443.8888088483 4234717.916449647, 1915441.793454863 4234725.479768721, 1915440.8370294648 4234728.115247002, 1915438.7597981335 4234733.763637902, 1915435.6398997256 4234740.533167623, 1915413.366037708 4234783.850136779, 1915373.0778836855 4234861.223920035, 1915361.972411523 4234881.25870883, 1915098.4196476645 4235237.108215043, 1914795.4650000005 4235645.705000007, 1914782.7669310726 4235664.564063139, 1914831.0899998979 4235706.209999925, 1915237.5200000303 4236062.520000031, 1915145.8691008498 4236366.324942643, 1915170.2102226734 4236552.554352238, 1915181.67500002 4236587.7949999245, 1915173.717004107 4236693.37058371, 1915174.12999993 4236703.410002073, 1915331.194105983 4236786.797752242, 1915439.37 4236844.23, 1915573.87 4236915.19, 1915600.75 4236918.62, 1915762.66 4236931.63, 1915780.08 4236931.77, 1915796.15 4236927.71, 1915803.67 4236925.55, 1915836.12 4236918.77, 1915890.53 4236901.49, 1915911.63 4236899.06, 1915936.27 4236898.31, 1915971.93 4236902.42, 1915992.84 4236906.9, 1916035.53 4236921.84, 1916080.9 4236941.81, 1916096.58 4236942.74, 1916129.81 4236951.32, 1916159.44 4236955.3, 1916168.59 4236955.3, 1916178.3 4236951.19, 1916231.69 4236910.14, 1916253.16 4236898.2, 1916265.58 4236895.36, 1916289.66 4236893.31, 1916319.53 4236894.8, 1916365.09 4236908.8, 1916423.82 4236924.68, 1916441.19 4236926.91, 1916459.48 4236924.68, 1916485.81 4236918.52, 1916513.81 4236917.96, 1916563.03 4236926.57, 1916611.39 4236942.8, 1916646.67 4236956.79, 1916666.28 4236959.97, 1916673.93 4236951.52, 1916674.89 4236948.12, 1916688.63 4236926.03, 1916704.67 4236901.84, 1916718.28 4236881.81, 1916687.9999999292 4236732.090002076, 1916663.8899999293 4236706.170002075, 1916626.4099999294 4236693.000002075, 1916577.1599999294 4236675.170002075, 1916534.5799999293 4236642.120002077, 1916528.9299999294 4236640.580002075, 1916369.0799999293 4236663.340002075, 1916311.4199999291 4236672.580002076, 1916308.1099999296 4236660.010002074, 1916305.5899999295 4236645.620002074, 1916365.8299999293 4236626.920002075, 1916384.5899999293 4236621.160002075, 1916423.5599999293 4236604.960002077, 1916463.8399999293 4236593.230002076, 1916532.4799999292 4236566.700002075, 1916540.6199999293 4236566.220002074, 1916547.1099999293 4236533.370002075, 1916548.5299999292 4236525.110002075, 1916550.5299999292 4236520.140002075, 1916554.1199999293 4236515.140002076, 1916560.6799999292 4236510.030002076, 1916573.1399999293 4236503.570002076, 1916580.5199999292 4236500.320002074, 1916592.6999999292 4236496.390002076, 1916636.8799999293 4236490.780002075, 1916652.2099999292 4236488.3100020755, 1916662.1599999294 4236484.650002075, 1916671.3699999293 4236476.840002075, 1916673.5999999293 4236466.490002076, 1916689.3099999293 4236429.240002077, 1916693.9799999292 4236422.100002076, 1916698.3399999293 4236417.400002076, 1916705.4499999292 4236414.220002075, 1916713.5399999293 4236413.140002075, 1916723.2899999293 4236414.560002077, 1916742.1299999293 4236415.520002077, 1916763.9999999292 4236427.660002076, 1916770.0299999292 4236430.460002076, 1916780.2099999292 4236435.170002076, 1916783.9899999292 4236436.090002076, 1916787.129999929 4236436.360002077, 1916790.2799999292 4236436.210002077, 1916838.5499999293 4236439.990002075, 1916847.759999929 4236440.710002077, 1916859.9699999292 4236441.660002076, 1916860.819999929 4236452.010002076, 1916867.4699999292 4236532.820002074, 1916900.4099999294 4236533.170002075, 1916883.599999929 4236568.290002077, 1916909.0199999292 4236588.860002076, 1916902.6099999293 4236626.970002075, 1916937.7599999292 4236696.210002075, 1916902.569999929 4236728.280002076, 1916849.5399999293 4236735.650002075, 1916849.1799999292 4236745.970002074, 1916806.2199999292 4236751.350002075, 1916805.17 4236819.36, 1916837.9 4236802.11, 1916887.35 4236776.54, 1916950.62 4236743.32, 1917005.18 4236714.8, 1917059.91 4236686.01, 1917104.22 4236662.46, 1917138.95 4236643.86, 1917147.48 4236639.32, 1917122.19 4236611.35, 1917110.99 4236596.9, 1917105.45 4236587.79, 1917097.65 4236571.5, 1917091.32 4236554.51, 1917088.41 4236542.77, 1917086.11 4236526.47, 1917085.87 4236512.67, 1917091.29 4236451.23, 1917089.7 4236438.58, 1917085.84 4236427.42, 1917065.97 4236383.44, 1917061.37 4236370.92, 1917060.18 4236366.62, 1917058.12 4236354.17, 1917056.09 4236331.07, 1917055.48 4236316.76, 1917055.87 4236285.59, 1917055.42 4236277.13, 1917054.43 4236267.77, 1917052.789999929 4236260.440002077), (1916210.5101960127 4234565.948888002, 1916255.6499999291 4234545.370002083, 1916277.9599999292 4234546.580002082, 1916291.2699999292 4234555.95000208, 1916309.7099999292 4234575.70000208, 1916313.8199999293 4234578.520002082, 1916322.239999929 4234583.910002082, 1916330.8699999293 4234588.93000208, 1916334.5899999293 4234592.110002082, 1916336.2799999292 4234594.580002081, 1916343.7299999292 4234609.130002081, 1916352.9399999292 4234624.150002081, 1916355.509999929 4234629.490002081, 1916358.1499999294 4234636.870002082, 1916364.0699999293 4234658.55000208, 1916365.599999929 4234666.910002083, 1916355.879999929 4234709.530002083, 1916351.6199999293 4234745.29000208, 1916355.5999999293 4234791.050002081, 1916361.6699999291 4234828.950002081, 1916363.9399999292 4234836.870002082, 1916385.0599999293 4234904.70000208, 1916399.5099999292 4234992.110002079, 1916415.3499999293 4235104.680002081, 1916425.1999999292 4235113.010002079, 1916438.569999929 4235127.660002081, 1916446.7599999292 4235142.510002079, 1916447.6699999291 4235146.710002081, 1916447.3699999293 4235149.1800020775, 1916445.0699999293 4235157.700002079, 1916441.679999929 4235158.51000208, 1916416.3399999293 4235169.99000208, 1916372.9199999291 4235165.220002078, 1916334.4899999292 4235161.46000208, 1916337.0599999293 4235141.370002079, 1916336.8899999293 4235128.0100020785, 1916334.9299999292 4235115.12000208, 1916331.9499999292 4235105.470002079, 1916329.0399999293 4235098.950002079, 1916324.4999999292 4235093.06000208, 1916322.2699999292 4235091.14000208, 1916316.9272769063 4235086.24099614, 1916317.0650087101 4235086.918767605, 1916317.3345461977 4235088.942128424, 1916317.7174939488 4235094.881842835, 1916317.5567902364 4235098.239408067, 1916313.2803159163 4235124.732729087, 1916313.2763338326 4235124.757269411, 1916312.2369281559 4235131.129415716, 1916314.4503123313 4235139.53834123, 1916314.7166359986 4235140.752267709, 1916316.2940669362 4235149.697064793, 1916316.504931463 4235153.022790503, 1916316.0239405069 4235163.052820834, 1916314.185181721 4235169.563718942, 1916306.3384302605 4235183.839761839, 1916305.0172016514 4235193.7913429905, 1916303.730664159 4235198.182402698, 1916301.6794950115 4235202.561687372, 1916308.200422599 4235208.266691421, 1916308.6434717537 4235208.6701991465, 1916314.0342758077 4235213.780443966, 1916316.4913253938 4235216.807241585, 1916328.6079827212 4235236.497525173, 1916329.9846205034 4235239.385078822, 1916335.914058015 4235256.248684962, 1916336.7121699413 4235259.982907806, 1916338.0371999138 4235275.908061278, 1916338.0855290848 4235277.47007724, 1916337.851129833 4235285.5646929005, 1916319.2599999292 4235291.00000208, 1916307.6727068655 4235295.750025613, 1916295.0199999292 4235301.23000208, 1916293.4699999292 4235303.510002078, 1916297.0899999293 4235311.360002079, 1916284.0799999293 4235317.77000208, 1916283.9499999292 4235317.840002079, 1916262.1899999292 4235328.5500020785, 1916247.7599999292 4235309.58000208, 1916193.3399999293 4235329.430002079, 1916181.1599999294 4235341.91000208, 1916152.5199999295 4235370.930002078, 1916136.8399999293 4235387.910002079, 1916087.1299999296 4235325.110002078, 1916069.9199999291 4235304.35000208, 1916065.2099999292 4235298.67000208, 1916035.7699999292 4235273.54000208, 1916023.9499999292 4235264.95000208, 1916015.7899999293 4235259.480002079, 1916011.2999999293 4235256.610002081, 1916006.4899999294 4235253.060002079, 1916001.9499999294 4235249.180002079, 1915997.6999999292 4235244.990002079, 1915995.1699999294 4235243.380002079, 1915961.7899999295 4235222.080002078, 1915945.5999999293 4235249.250002079, 1915895.5999999293 4235239.080002079, 1915888.0199999292 4235232.880002079, 1915879.8799999293 4235228.810002079, 1915894.6999999294 4235195.690002078, 1915849.7699999295 4235202.94000208, 1915855.4899999294 4235159.790002079, 1915849.3499999295 4235156.550002078, 1915843.7899999293 4235160.020002081, 1915835.4699999292 4235164.77000208, 1915826.9599999294 4235169.150002079, 1915779.4099999296 4235181.930002079, 1915768.8199999295 4235137.070002079, 1915782.0499999295 4235130.700002081, 1915790.7399999294 4235129.730002079, 1915802.9999999295 4235123.190002079, 1915812.2399999294 4235115.1700020805, 1915823.6099999296 4235100.770002079, 1915828.8199999295 4235094.960002079, 1915834.3299999295 4235089.44000208, 1915838.7299999292 4235085.44000208, 1915844.7499999292 4235080.480002082, 1915851.0299999295 4235075.85000208, 1915857.5499999295 4235071.56000208, 1915864.2899999295 4235067.64000208, 1915886.1499999294 4235022.490002079, 1915885.9099999294 4235017.520002082, 1915880.2399999294 4234986.0100020785, 1915877.8899999293 4234951.580002079, 1915868.0699999293 4234927.920002081, 1915857.8599999293 4234904.430002079, 1915852.0599999293 4234891.540002082, 1915847.2199999294 4234883.020002081, 1915842.0199999292 4234874.730002081, 1915836.4699999294 4234866.66000208, 1915832.6399999296 4234861.50000208, 1915830.3899999296 4234856.19000208, 1915822.7299999294 4234836.640002079, 1915815.0499999295 4234815.75000208, 1915816.2499999292 4234804.120002082, 1915823.9699999294 4234746.90000208, 1915825.7699999292 4234734.690002081, 1915827.9899999294 4234722.54000208, 1915830.4899999292 4234711.030002083, 1915829.8499999295 4234703.08000208, 1915831.7999999295 4234680.6300020795, 1915833.4099999294 4234673.750002082, 1915821.0899999293 4234666.39000208, 1915823.4299999294 4234670.450002082, 1915823.0899999293 4234673.860002083, 1915809.1199999293 4234706.170002081, 1915756.5099999295 4234704.950002081, 1915753.4999999292 4234742.200002083, 1915747.0599999293 4234776.280002081, 1915739.7199999294 4234791.070002081, 1915729.7999999293 4234812.470002081, 1915729.1099999293 4234814.18000208, 1915703.6499999296 4234878.30000208, 1915692.1399999296 4234907.52000208, 1915691.6599999294 4234922.82000208, 1915681.1199999296 4234936.720002078, 1915644.7499999295 4234958.41000208, 1915613.7399999294 4234975.520002079, 1915602.6499999296 4234983.440002081, 1915581.6299999296 4235000.08000208, 1915576.3899999296 4235003.830002079, 1915571.7099999294 4235010.68000208, 1915563.9899999294 4235016.470002079, 1915547.8599999296 4235025.870002081, 1915534.9099999296 4235040.230002079, 1915521.6499999296 4235059.040002079, 1915516.3399999295 4235066.490002079, 1915497.3899999298 4235052.510002079, 1915493.0599999295 4235049.930002079, 1915477.5399999295 4235041.150002078, 1915470.2399999294 4234901.56000208, 1915465.7699999295 4234807.6700020805, 1915462.5899999295 4234740.97000208, 1915461.7299999297 4234723.260002079, 1915465.1799999294 4234720.500002082, 1915467.6799999294 4234717.94000208, 1915471.6699999294 4234713.360002081, 1915475.3399999295 4234708.52000208, 1915477.2999999295 4234704.940002081, 1915484.6799999294 4234685.26000208, 1915486.7299999294 4234682.550002079, 1915489.5699999295 4234678.21000208, 1915492.0499999295 4234673.66000208, 1915492.9799999294 4234660.930002081, 1915496.6299999296 4234642.110002081, 1915501.3899999296 4234632.300002082, 1915505.1799999294 4234610.540002082, 1915506.8999999296 4234603.170002081, 1915512.8999999296 4234600.290002082, 1915625.6399999296 4234549.320002084, 1915607.3199999295 4234508.10000208, 1915621.9199999291 4234501.150002082, 1915651.2999999293 4234490.05000208, 1915656.5399999295 4234490.320002081, 1915666.2899999293 4234487.340002081, 1915670.5299999295 4234486.900002081, 1915672.7799999295 4234487.49000208, 1915676.6899999294 4234488.86000208, 1915680.4499999294 4234490.630002081, 1915683.9999999292 4234492.770002083, 1915687.7099999294 4234495.960002081, 1915690.7199999294 4234499.150002081, 1915693.3999999296 4234502.600002081, 1915696.8899999296 4234508.47000208, 1915710.8099999295 4234536.64000208, 1915719.9999999295 4234530.30000208, 1915727.7199999294 4234512.120002082, 1915734.5399999295 4234500.200002082, 1915749.4199999291 4234481.540002082, 1915754.1099999293 4234476.240002082, 1915762.0499999295 4234449.360002081, 1915767.4099999296 4234438.060002083, 1915763.6199999293 4234436.870002082, 1915737.1999999294 4234426.040002082, 1915755.5099999292 4234390.350002081, 1915788.7399999292 4234295.580002082, 1915791.88 4234283.74, 1915793.1445919129 4234278.964291377, 1915761.5759639898 4234267.488092725, 1915771.8322592871 4234234.916688086, 1915767.3835827827 4234230.969035684, 1915768.1299999293 4234225.840002081, 1915776.5199999292 4234217.870002082, 1915793.0099999292 4234184.650002082, 1915780.4599999294 4234163.330002082, 1915763.6999999292 4234171.320002084, 1915744.9499999294 4234154.220002081, 1915744.5999999295 4234152.800002081, 1915742.9699999294 4234143.340002082, 1915742.8699999293 4234142.760002082, 1915740.6799999294 4234134.480002083, 1915723.2899999293 4234109.740002082, 1915693.1899999294 4234065.880002082, 1915681.1799999292 4234023.9100020835, 1915641.4699999292 4233998.3700020835, 1915632.7199999294 4233972.760002085, 1915624.1699999291 4233967.940002084, 1915615.5799999293 4233962.350002082, 1915629.2299999292 4233924.280002084, 1915637.1199999293 4233895.140002083, 1915660.0999999293 4233837.650002083, 1915660.4899999292 4233836.700002084, 1915694.3899999296 4233797.770002083, 1915718.8999999294 4233803.460002083, 1915753.7199999292 4233825.470002084, 1915750.3099999293 4233833.030002083, 1915763.4399999292 4233839.810002084, 1915769.1399999293 4233850.190002083, 1915793.0299999292 4233847.580002083, 1915806.9599999292 4233855.100002082, 1915810.3299999293 4233856.5000020815, 1915812.2999999293 4233859.220002083, 1915820.4899999292 4233873.760002082, 1915832.3699999296 4233855.9600020815, 1915841.3799999293 4233871.880002082, 1915856.6499999294 4233890.470002082, 1915866.8799999293 4233893.680002083, 1915891.2099999292 4233897.170002082, 1915904.3399999293 4233897.4100020835, 1915915.5399999293 4233896.790002083, 1915926.6999999292 4233895.740002084, 1915931.5799999293 4233895.150002085, 1915945.9199999291 4233892.600002083, 1915960.1899999292 4233889.630002083, 1915969.2899999293 4233887.500002083, 1915980.4899999292 4233887.260002084, 1915966.9999999292 4233856.020002084, 1915995.8499999293 4233855.690002083, 1916001.9699999292 4233862.4600020815, 1916005.9999999292 4233864.800002083, 1916018.8099999293 4233882.840002084, 1916023.8099999293 4233891.780002084, 1916031.2999999293 4233905.740002084, 1916038.4199999291 4233919.900002082, 1916041.5399999293 4233926.4100020835, 1916045.1999999292 4233936.150002083, 1916045.9999999292 4233939.210002083, 1916047.7699999292 4233958.210002081, 1916050.9999999292 4234007.100002081, 1916063.4099999294 4234036.900002081, 1916093.7899999293 4234061.14000208, 1916105.2299999292 4234091.260002082, 1916109.1899999292 4234104.6600020835, 1916163.0299999292 4234152.150002083, 1916166.1399999293 4234154.430002083, 1916210.719999929 4234194.950002084, 1916221.5099999292 4234211.820002083, 1916224.9899999292 4234243.46000208, 1916231.8999999291 4234309.230002084, 1916221.7499999292 4234351.310002082, 1916218.2899999293 4234423.39000208, 1916204.2199999292 4234428.87000208, 1916196.6299999293 4234438.510002081, 1916193.3299999293 4234479.000002081, 1916187.0599999293 4234517.270002082, 1916174.8599999293 4234544.240002081, 1916158.6199999293 4234570.660002081, 1916136.2199999292 4234595.4200020805, 1916106.7099999292 4234596.10000208, 1916105.3299999293 4234557.270002081, 1916109.6599999294 4234546.27000208, 1916110.9799999292 4234539.270002082, 1916109.3099999293 4234525.940002081, 1916103.6299999293 4234510.950002079, 1916098.9499999292 4234500.9600020815, 1916090.2799999292 4234488.970002082, 1916082.2699999292 4234478.98000208, 1916078.9299999292 4234473.320002081, 1916074.2499999292 4234455.330002082, 1916071.5799999293 4234441.6700020805, 1916069.5599999293 4234418.010002081, 1916070.5299999292 4234394.350002081, 1916073.1699999291 4234365.020002081, 1916069.0299999292 4234345.640002082, 1916064.3599999293 4234343.130002081, 1916059.3399999293 4234364.200002081, 1916057.1899999292 4234379.860002083, 1916056.5399999293 4234393.690002082, 1916055.2199999292 4234416.360002081, 1916055.9099999294 4234435.020002082, 1916059.5899999293 4234454.010002082, 1916064.6099999293 4234477.3300020825, 1916070.2899999293 4234489.320002082, 1916083.6299999293 4234506.640002081, 1916090.2999999293 4234516.290002081, 1916094.9799999292 4234528.290002082, 1916096.3199999293 4234538.610002081, 1916094.9899999292 4234545.28000208, 1916091.9999999292 4234554.950002081, 1916091.0099999292 4234558.280002083, 1916093.3499999293 4234575.270002082, 1916099.0599999293 4234603.620002082, 1916097.6799999292 4234606.83000208, 1916083.2599999292 4234633.810002083, 1916080.4399999292 4234641.380002079, 1916074.9099999294 4234660.3800020795, 1916070.3799999293 4234670.530002082, 1916066.3699999293 4234680.520002082, 1916058.4399999292 4234713.890002081, 1916046.2899999293 4234759.460002081, 1916059.5399999293 4234764.650002083, 1916075.7277958281 4234770.986697482, 1916076.2243325275 4234771.180643902, 1916080.5899999295 4234772.890002079, 1916092.0571353345 4234779.650404102, 1916092.2599999292 4234779.770002081, 1916095.6499999294 4234774.750002081, 1916111.2499999292 4234753.810002081, 1916109.5299999292 4234731.650002081, 1916103.8499999293 4234715.58000208, 1916105.1299999293 4234709.3400020795, 1916113.3699999296 4234690.00000208, 1916113.0999999293 4234688.960002081, 1916113.8399999293 4234685.17000208, 1916116.0599999293 4234683.490002082, 1916148.6399999293 4234624.470002082, 1916156.7599999292 4234621.790002081, 1916159.2799999292 4234617.56000208, 1916162.2007893946 4234612.830928322, 1916167.4299999292 4234604.420002081, 1916183.8999999294 4234578.330002079, 1916200.9399999292 4234570.280002083, 1916210.5101960127 4234565.948888002), (1915737.1999999294 4234426.040002082, 1915732.7599999295 4234430.410002081, 1915726.5199999292 4234436.500002082, 1915639.2799999295 4234462.14000208, 1915625.7699999292 4234438.410002083, 1915624.2899999293 4234435.170002082, 1915618.4599999294 4234414.860002081, 1915617.1699999294 4234412.480002079, 1915615.5299999295 4234410.330002082, 1915613.5699999295 4234408.47000208, 1915623.7899999293 4234399.620002084, 1915591.4699999294 4234350.520002082, 1915560.1199999296 4234308.610002083, 1915557.9499999294 4234292.900002081, 1915606.1899999294 4234285.520002082, 1915608.6299999296 4234283.620002082, 1915611.3199999295 4234276.200002082, 1915602.4999999292 4234252.200002082, 1915612.5499999295 4234226.600002081, 1915614.5399999295 4234227.910002082, 1915641.7099999292 4234243.900002083, 1915648.8099999295 4234246.18000208, 1915657.2799999295 4234247.280002081, 1915683.3299999295 4234247.110002082, 1915699.9399999292 4234254.650002082, 1915720.9499999294 4234253.22000208, 1915722.6999999294 4234256.650002083, 1915717.2199999294 4234277.84000208, 1915716.4999999295 4234284.610002084, 1915718.6699999294 4234297.420002081, 1915718.9099999294 4234305.050002084, 1915722.9099999296 4234311.940002084, 1915732.5599999295 4234322.610002081, 1915732.0399999293 4234329.020002083, 1915728.1799999292 4234353.450002083, 1915728.4599999292 4234378.330002082, 1915733.1399999293 4234402.290002081, 1915737.1999999294 4234426.040002082), (1916186.5137110932 4234111.073334621, 1916193.3399999293 4234110.390002081, 1916206.0599999293 4234112.800002083, 1916216.119999929 4234119.150002084, 1916227.429999929 4234128.650002083, 1916244.4699999292 4234143.310002082, 1916253.3399999293 4234152.110002083, 1916256.969999929 4234158.150002084, 1916262.989999929 4234164.93000208, 1916266.1599999291 4234169.350002084, 1916273.6499999294 4234183.930002082, 1916284.7499999292 4234193.330002082, 1916289.8299999293 4234200.290002081, 1916295.5599999293 4234214.140002082, 1916299.2599999292 4234224.450002082, 1916301.7299999292 4234227.740002082, 1916303.9299999292 4234242.09000208, 1916292.0999999293 4234246.560002082, 1916288.956493224 4234247.678637755, 1916281.4199999291 4234250.39000208, 1916251.7299999292 4234247.730002082, 1916247.359999929 4234222.780002084, 1916246.0699999293 4234211.810002082, 1916241.6099999293 4234203.740002083, 1916237.5699999293 4234196.630002082, 1916234.4499999292 4234191.010002083, 1916229.8199999293 4234184.990002083, 1916225.2299999292 4234179.490002083, 1916219.0899999293 4234173.550002081, 1916211.7299999292 4234168.2500020815, 1916208.1899999292 4234162.360002083, 1916208.419999929 4234153.570002085, 1916204.1299999293 4234148.570002082, 1916198.8699999293 4234143.660002082, 1916186.1699999291 4234133.860002083, 1916181.2499999292 4234128.270002082, 1916180.2299999292 4234123.200002082, 1916180.3999999294 4234118.460002082, 1916181.7499999292 4234114.05000208, 1916184.9599999292 4234111.170002081, 1916186.5137110932 4234111.073334621), (1915709.9899999292 4234176.670002082, 1915712.0899999293 4234199.800002082, 1915713.8799999296 4234203.930002083, 1915716.5999999293 4234210.940002083, 1915718.0999999293 4234226.680002082, 1915680.2899999295 4234217.450002081, 1915648.9399999294 4234221.940002082, 1915643.6699999291 4234210.0000020815, 1915641.8399999293 4234206.380002082, 1915639.6499999296 4234202.980002082, 1915637.1199999296 4234199.820002082, 1915634.2699999292 4234196.940002084, 1915631.1399999296 4234194.370002083, 1915617.2799999295 4234186.110002082, 1915615.7799999295 4234171.240002083, 1915600.4799999294 4234153.670002082, 1915608.7099999294 4234134.850002081, 1915591.7199999294 4234112.300002082, 1915565.4799999292 4234099.860002083, 1915570.2299999292 4234082.910002084, 1915569.5799999295 4234063.840002082, 1915584.2199999294 4234065.130002081, 1915586.0499999295 4234042.520002083, 1915629.2399999294 4234052.380002083, 1915635.1699999291 4234057.240002084, 1915672.9499999294 4234083.600002081, 1915683.4899999294 4234089.380002083, 1915690.3099999293 4234098.130002081, 1915698.8199999293 4234113.260002083, 1915699.5099999292 4234115.530002084, 1915702.0399999293 4234128.540002082, 1915704.9699999294 4234141.4600020815, 1915705.9599999292 4234145.410002083, 1915707.8199999295 4234167.810002083, 1915709.9899999292 4234176.670002082), (1916552.989999929 4234354.840002083, 1916550.229999929 4234355.10000208, 1916542.829999929 4234361.010002082, 1916534.509999929 4234367.120002083, 1916525.949999929 4234372.88000208, 1916517.1599999294 4234378.280002082, 1916508.1599999291 4234383.330002083, 1916504.8999999291 4234384.570002085, 1916500.369999929 4234385.890002081, 1916495.7299999292 4234386.810002082, 1916491.0399999293 4234387.310002082, 1916486.319999929 4234387.390002082, 1916455.669999929 4234365.410002082, 1916455.0999999293 4234365.000002082, 1916449.799999929 4234358.100002081, 1916444.8399999293 4234350.960002081, 1916443.4699999292 4234348.850002079, 1916438.309999929 4234339.110002084, 1916436.2099999292 4234333.580002081, 1916434.5199999292 4234327.9200020805, 1916432.989999929 4234320.820002082, 1916428.559999929 4234290.540002083, 1916426.769999929 4234285.360002083, 1916421.8999999294 4234279.220002081, 1916419.099999929 4234265.970002081, 1916416.3999999291 4234251.500002082, 1916412.6999999292 4234233.710002082, 1916393.8899999293 4234236.890002081, 1916393.609999929 4234230.860002081, 1916392.8999999291 4234224.860002082, 1916391.7699999292 4234218.930002081, 1916389.799999929 4234211.2500020815, 1916386.6999999292 4234200.64000208, 1916383.1999999292 4234190.150002083, 1916379.5699999293 4234180.330002082, 1916377.1899999292 4234175.440002082, 1916371.819999929 4234161.780002084, 1916371.099999929 4234158.480002082, 1916364.8499999293 4234162.360002083, 1916362.569999929 4234163.300002083, 1916358.5399999293 4234164.470002083, 1916352.7099999292 4234136.400002083, 1916348.9299999292 4234117.830002082, 1916348.5699999293 4234110.950002083, 1916348.6799999292 4234102.870002083, 1916346.1499999291 4234091.720002082, 1916344.6899999292 4234085.420002081, 1916345.939999929 4234075.310002082, 1916338.8699999293 4234076.220002083, 1916325.9899999292 4234079.110002082, 1916319.4099999294 4234078.930002083, 1916281.7899999293 4234070.620002083, 1916280.1199999293 4234073.5000020815, 1916276.6999999292 4234090.770002084, 1916263.8299999293 4234084.650002082, 1916262.2199999292 4234067.490002082, 1916261.1099999293 4234056.320002082, 1916262.189999929 4234020.040002083, 1916262.3899999291 4234017.980002084, 1916263.1599999294 4234013.010002083, 1916264.349999929 4234008.130002084, 1916263.2699999292 4233994.690002082, 1916169.3499999293 4233978.470002081, 1916165.699999929 4233958.740002083, 1916161.6699999291 4233932.320002083, 1916159.3399999293 4233899.220002083, 1916159.209999929 4233873.300002084, 1916218.7099999292 4233897.980002083, 1916235.189999929 4233887.410002084, 1916265.569999929 4233890.690002085, 1916298.009999929 4233882.020002083, 1916323.3099999293 4233867.680002083, 1916337.169999929 4233861.240002084, 1916343.7699999292 4233858.670002082, 1916372.869999929 4233849.800002083, 1916385.599999929 4233845.700002084, 1916391.559999929 4233844.570002083, 1916398.359999929 4233843.730002083, 1916410.0399999293 4233843.860002082, 1916417.199999929 4233844.830002083, 1916429.749999929 4233848.260002082, 1916437.479999929 4233851.810002083, 1916441.939999929 4233855.940002086, 1916444.3899999291 4233859.500002083, 1916447.8199999293 4233867.1200020835, 1916450.129999929 4233874.730002084, 1916452.849999929 4233888.490002083, 1916456.4799999292 4233894.470002082, 1916465.829999929 4233902.330002083, 1916474.8999999291 4233910.510002083, 1916483.679999929 4233919.010002081, 1916489.689999929 4233925.170002081, 1916494.119999929 4233926.850002081, 1916499.4099999291 4233927.200002083, 1916504.6599999291 4233927.970002081, 1916506.299999929 4233928.300002083, 1916511.779999929 4233929.740002084, 1916517.1399999291 4233931.590002082, 1916520.1399999291 4233932.820002083, 1916527.199999929 4233937.130002081, 1916534.029999929 4233941.790002083, 1916540.619999929 4233946.800002084, 1916544.209999929 4233949.770002084, 1916596.189999929 4234000.140002082, 1916611.8999999291 4234025.920002083, 1916618.609999929 4234029.530002082, 1916625.499999929 4234032.770002084, 1916630.089999929 4234034.670002082, 1916680.839999929 4234051.670002082, 1916704.209999929 4234056.260002082, 1916708.839999929 4234062.060002083, 1916714.679999929 4234068.5000020815, 1916740.229999929 4234082.060002083, 1916765.589999929 4234096.000002082, 1916779.789999929 4234104.020002083, 1916782.799999929 4234108.410002082, 1916785.4399999287 4234113.020002083, 1916787.929999929 4234118.350002081, 1916790.989999929 4234126.240002084, 1916793.429999929 4234135.170002082, 1916795.4099999291 4234143.970002083, 1916804.839999929 4234165.9900020845, 1916821.5999999288 4234175.810002083, 1916829.359999929 4234179.610002082, 1916837.289999929 4234183.010002083, 1916843.599999929 4234185.400002082, 1916862.359999929 4234192.020002081, 1916884.699999929 4234199.3300020825, 1916892.8915081185 4234201.167050542, 1916902.67 4234203.36, 1916914.8899999291 4234208.480002084, 1916924.84 4234214.82, 1916924.839999929 4234214.820002084, 1916928.765031667 4234218.412497004, 1916905.893471913 4234318.182214824, 1916957.3999999291 4234313.7500020815, 1916949.329999929 4234328.950002083, 1916940.8899999291 4234343.940002082, 1916937.5999999288 4234348.920002083, 1916934.209999929 4234353.250002081, 1916930.489999929 4234357.310002084, 1916917.279999929 4234374.140002081, 1916912.199999929 4234382.200002081, 1916910.959999929 4234384.810002081, 1916909.559999929 4234388.590002083, 1916908.569999929 4234392.50000208, 1916908.249999929 4234397.900002082, 1916915.499999929 4234424.880002081, 1916953.779999929 4234436.640002082, 1916950.309999929 4234476.34000208, 1916989.229999929 4234484.480002079, 1916953.379999929 4234589.980002081, 1916941.279999929 4234590.360002082, 1916910.919999929 4234591.030002081, 1916880.549999929 4234591.270002081, 1916883.6499999291 4234535.270002084, 1916878.819999929 4234519.710002081, 1916863.9799999287 4234500.450002084, 1916856.609999929 4234466.470002082, 1916836.3999999291 4234440.150002083, 1916836.879999929 4234431.770002081, 1916815.769999929 4234419.370002083, 1916803.439999929 4234406.9600020815, 1916788.779999929 4234406.400002081, 1916761.459999929 4234381.510002082, 1916760.999999929 4234377.390002082, 1916759.989999929 4234371.480002082, 1916758.559999929 4234365.650002082, 1916711.099999929 4234354.210002081, 1916706.069999929 4234353.260002083, 1916697.239999929 4234347.0000020815, 1916688.6599999291 4234340.400002083, 1916680.349999929 4234333.470002081, 1916671.009999929 4234324.990002082, 1916662.769999929 4234315.280002083, 1916654.859999929 4234305.300002081, 1916628.969999929 4234347.280002083, 1916626.789999929 4234355.420002081, 1916624.689999929 4234359.170002081, 1916622.359999929 4234362.420002081, 1916619.699999929 4234365.400002081, 1916613.819999929 4234369.110002082, 1916610.939999929 4234370.110002083, 1916606.339999929 4234371.35000208, 1916601.6499999291 4234372.170002082, 1916596.469999929 4234372.43000208, 1916591.229999929 4234372.27000208, 1916586.019999929 4234371.690002083, 1916581.269999929 4234369.790002082, 1916577.6099999293 4234367.820002082, 1916574.169999929 4234365.480002082, 1916570.629999929 4234362.10000208, 1916569.099999929 4234360.130002081, 1916566.959999929 4234356.810002082, 1916565.199999929 4234353.2900020825, 1916563.8199999293 4234349.590002081, 1916562.839999929 4234345.770002083, 1916552.989999929 4234354.840002083))','ZO32793','"lib_modif"=>"N", "lib_code_insee"=>"38325 / 38328 / 38471 / 38472", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','As','Agricole avec secteurs à protéger (stricts)','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1916787.1273185315 4219092.620619141, 1916752.1141411322 4219084.1852916395, 1916760.7057077317 4219151.153312595, 1916780.2695981439 4219107.812760463, 1916782.9884152743 4219101.789672361, 1916787.1273185315 4219092.620619141))','ZO32700','"lib_modif"=>"N", "lib_code_insee"=>"38057 / 38158", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UE2','Activités de production industrielle','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UE2.pdf','2019-12-20','SRID=3945;POLYGON ((1912747.5774185138 4219030.981850872, 1912715.91 4219035.59, 1912689.34 4219039.56, 1912701.9272624152 4219061.241227267, 1912747.5774185138 4219030.981850872))','ZO32730','"lib_modif"=>"N", "lib_code_insee"=>"38317", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UV','Parcs urbains','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UV.pdf','2019-12-20','SRID=3945;POLYGON ((1911853.95 4224875.52, 1911891.8598714168 4224875.518680429, 1911900.4162888464 4224875.588228467, 1911900.9135531806 4224831.093420037, 1911896.12 4224831.06, 1911875.24 4224830.64, 1911874.74 4224845.91, 1911870.17 4224845.88, 1911854.69 4224845.79, 1911852.03 4224845.77, 1911849.2101229033 4224845.822997231, 1911848.717163002 4224875.483311742, 1911853.95 4224875.52))','ZO32558','"lib_modif"=>"N", "lib_code_insee"=>"38169", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','Nk','Naturelle avec domaines skiables','N',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/N.pdf','2019-12-20','SRID=3945;POLYGON ((1917460.8799999289 4235257.480002079, 1917039.109999929 4235060.390002079, 1917038.669999929 4235069.07000208, 1917035.289999929 4235077.52000208, 1917030.349999929 4235086.15000208, 1917457.8699999289 4235289.43000208, 1917500.7513032826 4235309.717289904, 1917678.9012380207 4235394.248867062, 1917768.4299999287 4235437.0900020795, 1917793.1799999287 4235448.36000208, 1917819.2899999288 4235459.910002081, 1917831.8599999286 4235430.84000208, 1917675.253883612 4235357.674439858, 1917493.1587334601 4235272.805569276, 1917460.8799999289 4235257.480002079))','ZO33134','"lib_modif"=>"N", "lib_code_insee"=>"38472", "lib_modif_comment"=>NULL',1);
INSERT INTO urba_plui_ecriture.zoneurba (idurba,libelle,libelong,typezone,nomfic,urlfic,datevalid,geom,lib_idzone,lib_hstore,lib_id_version) VALUES
     ('MJ3_PH1_ZON_050_09','Ns','Naturelle avec secteurs à protéger (stricts)','N',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/N.pdf','2019-12-20','SRID=3945;POLYGON ((1917128.1665402858 4220780.140287374, 1917129.939217808 4220778.236435505, 1917136.3134024474 4220791.556358487, 1917141.56 4220802.52, 1917144.64 4220808.69, 1917149.65 4220818.77, 1917158.18 4220834.4, 1917166.88 4220850.8, 1917169.82 4220856.34, 1917175.86 4220864.71, 1917187.77 4220876.11, 1917200.46 4220888.43, 1917235.36 4220898.83, 1917242.14 4220900.86, 1917243.78 4220901.38, 1917254.01 4220904.59, 1917272.23 4220911, 1917279.67 4220913.58, 1917291.37 4220917.63, 1917309.51 4220923.51, 1917313.3 4220924.83, 1917324.19 4220928.63, 1917329.65 4220930.43, 1917343.2598885214 4220935.030214619, 1917343.4315627809 4220934.186229433, 1917343.9799999278 4220931.490002118, 1917348.319999928 4220922.210002119, 1917352.7699999276 4220912.20000212, 1917354.349999928 4220908.850002117, 1917355.5699999277 4220905.20000212, 1917355.9499999275 4220902.1300021205, 1917359.1399999277 4220907.48000212, 1917369.2499999278 4220924.270002118, 1917375.3399999277 4220928.80000212, 1917380.5785506049 4220925.608189541, 1917383.9452585895 4220923.879449967, 1917389.9010395592 4220922.9924187595, 1917400.92557029 4220922.358825039, 1917422.721194264 4220923.879449967, 1917439.9549434527 4220925.906949872, 1917459.2161925458 4220932.4963245625, 1917472.9018169018 4220941.113199157, 1917481.518691496 4220948.7163237985, 1917512.4380650404 4220990.786946818, 1917532.20618911 4221022.720070315, 1917538.7955637998 4221040.46069448, 1917540.8230637042 4221048.063819122, 1917541.3299386804 4221061.242568501, 1917539.809313752 4221073.407567929, 1917536.7499999276 4221091.900002118, 1917541.9599999278 4221088.320002119, 1917549.1799999275 4221107.42000212, 1917560.1799999275 4221137.250002117, 1917593.1299999277 4221203.02000212, 1917592.5999999277 4221218.350002118, 1917592.4799999276 4221220.280002119, 1917592.5899999277 4221222.320002119, 1917592.9399999275 4221225.160002119, 1917593.1899999275 4221226.880002118, 1917593.4199999275 4221227.470002118, 1917594.2099999276 4221229.530002118, 1917600.3999999277 4221242.160002119, 1917611.9999999276 4221266.48000212, 1917625.4399999275 4221293.950002118, 1917621.9599999278 4221296.140002115, 1917617.8199999277 4221313.450002119, 1917622.7599999276 4221319.400002118, 1917625.2199999276 4221322.350002116, 1917628.5899999277 4221327.010002118, 1917630.2999999276 4221334.130002119, 1917631.0985152326 4221333.876296586, 1917634.1079214052 4221332.920151244, 1917635.21 4221332.57, 1917635.38 4221333.44, 1917634.54 4221334.97, 1917632.67 4221337.21, 1917630.91 4221339.92, 1917629.23 4221343.31, 1917628.09 4221348.03, 1917628.11 4221349.07, 1917628.12 4221349.67, 1917628.12 4221350.26, 1917628.14 4221350.84, 1917628.15 4221351.42, 1917628.18 4221351.97, 1917628.19 4221352.52, 1917628.22 4221353.05, 1917628.27 4221354.04, 1917628.34 4221354.93, 1917628.43 4221355.72, 1917628.54 4221356.38, 1917628.69 4221356.99, 1917628.93 4221357.87, 1917629.23 4221358.8, 1917629.39 4221359.29, 1917629.57 4221359.77, 1917629.74 4221360.27, 1917629.92 4221360.78, 1917630.12 4221361.29, 1917630.31 4221361.8, 1917630.51 4221362.32, 1917633.21 4221367.25, 1917634.88 4221369.66, 1917638.07 4221373.59, 1917642.22 4221378.54, 1917646.91 4221383.44, 1917651.16 4221388.09, 1917652.7 4221389.52, 1917656.81 4221394.14, 1917659.83 4221397.88, 1917663.43 4221402.96, 1917665.94 4221407.43, 1917667.97 4221411.86, 1917670.45 4221418.72, 1917673.01 4221426.15, 1917675.69 4221435.23, 1917677.95 4221440.47, 1917680.06 4221445.64, 1917682.85 4221452.4, 1917693.42 4221465.6, 1917696.1380420597 4221471.446239116, 1917697.002418915 4221473.305428072, 1917882.3841677033 4221451.3860170515, 1917939.9175424785 4221444.702457916, 1918030.5473355632 4221434.174141372, 1918173.052520251 4221418.312079945, 1918181.1426255354 4221418.199754544, 1918187.1971530856 4221418.554171762, 1918195.173198208 4221420.528724704, 1918408.9718865931 4221426.816350148, 1918624.5570814842 4221433.629275778, 1918648.1000000027 4221434.373279341, 1918814.6738297332 4221439.927587588, 1919005.6286613797 4221446.294866278, 1919012.6045742717 4221446.527474068, 1919009.5584589709 4221441.632080038, 1919018.240353213 4221441.855139545, 1918974.3680173436 4221371.498946619, 1918953.1961704912 4221337.10207867, 1918894.7715558137 4221242.182454034, 1918817.594636687 4221117.9077051375, 1918752.1485723883 4221012.522658688, 1918713.6437882904 4220949.835037568, 1918701.2600251285 4220929.673681743, 1918699.429084087 4220930.651130035, 1918684.5499374103 4220938.594365864, 1918649.08 4220957.53, 1918598.6 4220984.7, 1918573.1626393397 4220998.336808984, 1918561.89 4221004.38, 1918558.72 4220999.27, 1918558.67 4220998.67, 1918557.78 4220988.2, 1918555.34 4220961.91, 1918539.1050390308 4220940.716452247, 1918501.9330550951 4220944.591403482, 1918497.9131999274 4220930.422002118, 1918461.05 4220942.94, 1918430.54 4220921.77, 1918430.64 4220939.14, 1918437.12 4220962.75, 1918438.152126464 4220979.670914229, 1918476.5002705066 4221015.561909698, 1918476.2604759124 4221018.589848537, 1918475.52 4221027.94, 1918471.63 4221027.22, 1918457.96 4221022.85, 1918430.79 4221013.72, 1918421.01 4221010.56, 1918403.8597573857 4221005.011577748, 1918393.84 4221001.77, 1918404.43 4220995.03, 1918388.97 4220935.5, 1918381.25 4220904.71, 1918364.7 4220898.9, 1918328.69 4220887.05, 1918323.8 4220909.05, 1918308.29 4220908.87, 1918293.9133369073 4220915.83765775, 1918289.63 4220885.52, 1918290.2582493448 4220869.445124205, 1918290.84 4220854.56, 1918291.2 4220834.06, 1918290.44 4220834.19, 1918289.48 4220834.81, 1918275.9760981426 4220845.838691147, 1918271.64 4220849.38, 1918271.53 4220849.52, 1918271.47 4220849.59, 1918271.4 4220849.65, 1918271.32 4220849.71, 1918271.24 4220849.76, 1918271.16 4220849.8, 1918271.07 4220849.84, 1918270.98 4220849.87, 1918270.89 4220849.89, 1918270.79 4220849.9, 1918270.7 4220849.91, 1918270.61 4220849.91, 1918270.51 4220849.92, 1918270.42 4220849.9, 1918270.33 4220849.88, 1918270.24 4220849.85, 1918270.15 4220849.82, 1918270.06 4220849.78, 1918269.98 4220849.73, 1918269.9 4220849.67, 1918269.83 4220849.61, 1918269.76 4220849.55, 1918269.7 4220849.47, 1918269.65 4220849.4, 1918269.6 4220849.32, 1918269.55 4220849.23, 1918269.52 4220849.15, 1918269.49 4220849.06, 1918269.44 4220848.87, 1918267.28 4220839.68, 1918267.28 4220839.63, 1918267.28 4220839.59, 1918267.27 4220839.56, 1918267.27 4220839.52, 1918267.26 4220839.49, 1918267.24 4220839.45, 1918267.23 4220839.42, 1918267.21 4220839.39, 1918267.19 4220839.36, 1918267.17 4220839.33, 1918267.14 4220839.3, 1918267.12 4220839.28, 1918267.09 4220839.26, 1918267.06 4220839.24, 1918267.02 4220839.22, 1918266.99 4220839.2, 1918266.96 4220839.19, 1918266.92 4220839.18, 1918266.89 4220839.18, 1918266.85 4220839.17, 1918266.81 4220839.17, 1918266.74 4220839.18, 1918266.55 4220839.22, 1918266.44 4220839.26, 1918266.33 4220839.3, 1918266.23 4220839.35, 1918266.13 4220839.4, 1918266.03 4220839.47, 1918265.94 4220839.54, 1918265.78 4220839.71, 1918252.25 4220853.07, 1918251.07 4220853, 1918249.9287577488 4220843.7057922715, 1918247.11 4220820.75, 1918225.99 4220814.42, 1918221.8 4220850.83, 1918219.890961191 4220869.239608666, 1918199.6 4220875.6, 1918198.52 4220865.78, 1918197.64 4220854.48, 1918200.85 4220834.57, 1918202.91 4220821.18, 1918204.57 4220810.99, 1918207.31 4220800.34, 1918209.3 4220795.2, 1918211.69 4220790.23, 1918210.0880932054 4220773.351129703, 1918200.42 4220782.74, 1918186.2556303793 4220799.09967869, 1918183.58 4220802.19, 1918181.31 4220804.89, 1918181.12 4220805.12, 1918177.7 4220809.66, 1918174.99 4220813.99, 1918170.95 4220828.08, 1918163.26 4220858.69, 1918159.66 4220873.44, 1918156.58 4220898.24, 1918155.77 4220909.89, 1918155.55 4220917.18, 1918155.63 4220919.71, 1918150.82 4220919.55, 1918130.6499999275 4220922.320002119, 1918130.4999999274 4220921.50000212, 1918127.3599999275 4220900.9300021175, 1918126.8699999275 4220898.150002119, 1918089.9299999273 4220905.850002118, 1918068.4899999276 4220910.540002119, 1918064.4599999273 4220911.950002119, 1918059.7899999274 4220901.12000212, 1918058.5399999274 4220898.200002121, 1918058.36999917 4220897.810000352, 1918057.154267781 4220898.326146667, 1918051.61 4220900.68, 1918036.33 4220907.23, 1918033.4271421477 4220908.518450678, 1918026.89 4220911.42, 1918007.27 4220921.22, 1918011.09 4220935, 1918011.6407817816 4220936.941821484, 1918016.76 4220954.99, 1918018.44 4220960.83, 1918022.46 4220970.84, 1918029.33 4220984.11, 1918034.873052225 4220993.640740542, 1918036.03 4220995.63, 1918041.73 4221004.73, 1918043.92 4221007.97, 1918051.66 4221017.15, 1918053.13 4221018.87, 1918054.27 4221020.44, 1918057.25 4221024.62, 1918060.03 4221028.72, 1918063.03 4221034.3, 1918065.41 4221038.55, 1918067.79 4221043.3, 1918011.408313584 4221068.719446678, 1918009.19 4221062.73, 1918005.09 4221051.49, 1917990.5170410897 4221028.960848449, 1917968.3428874752 4221039.259763855, 1917955.1838748313 4221020.53347663, 1917942.0248621874 4220997.75826244, 1917933.4208923818 4220978.525859344, 1917927.8536178016 4220966.885194313, 1917920.6200005906 4220944.940001792, 1917914.4499999275 4220921.980002118, 1917912.6999999275 4220915.490002119, 1917904.6799999273 4220886.180002119, 1917906.6999999275 4220855.61000212, 1917905.9399999275 4220836.190002119, 1917905.2899999276 4220819.430002117, 1917916.7499999274 4220819.630002119, 1917921.2799999276 4220769.060002121, 1917923.7599999276 4220739.640002119, 1917875.8599999277 4220735.30000212, 1917870.3599999277 4220692.42000212, 1917869.0199999274 4220682.03000212, 1917867.8799999277 4220673.890002118, 1917864.2699999274 4220638.470002119, 1917863.1699999273 4220627.660002122, 1917859.0399999274 4220589.8800021205, 1917881.9399999275 4220589.50000212, 1917875.6299999277 4220557.15000212, 1917861.3699999275 4220476.900002121, 1917861.3099999274 4220474.610002121, 1917841.7299999273 4220462.620002121, 1917823.7399999276 4220450.51000212, 1917811.9699999273 4220443.320002121, 1917811.5699999274 4220441.10000212, 1917811.4799999276 4220440.640002119, 1917804.7299999273 4220422.650002121, 1917804.4999999274 4220422.030002122, 1917803.4099999275 4220419.990002121, 1917802.2899999274 4220419.240002122, 1917800.4299999275 4220418.71000212, 1917779.8899999275 4220412.860002122, 1917766.9199999275 4220409.950002121, 1917756.9199999275 4220407.840002121, 1917741.6199999277 4220404.610002119, 1917741.2799999276 4220404.550002121, 1917734.5899999277 4220402.920002121, 1917725.3799999277 4220373.150002121, 1917724.6499999277 4220370.810002121, 1917724.1499999277 4220369.220002119, 1917723.3599999277 4220367.82000212, 1917721.8099999276 4220368.98000212, 1917719.1599999277 4220370.540002121, 1917716.9399999273 4220371.800002121, 1917714.9799999276 4220372.25000212, 1917712.3699999277 4220372.410002122, 1917708.9199999273 4220371.780002122, 1917703.0399999276 4220369.30000212, 1917694.0099999276 4220364.78000212, 1917678.7599999276 4220356.8400021205, 1917661.4799999273 4220347.590002121, 1917659.3999999277 4220346.310002122, 1917643.0999999274 4220312.840002121, 1917632.4199999275 4220290.72000212, 1917639.0599999276 4220282.42000212, 1917640.9199999273 4220281.380002121, 1917647.8499999274 4220277.520002122, 1917663.0899999277 4220293.16000212, 1917672.4299999275 4220302.250002121, 1917675.2199999273 4220304.3700021235, 1917683.2699999276 4220307.880002121, 1917689.5399999274 4220309.890002123, 1917698.6199999277 4220310.410002121, 1917700.1099999277 4220309.450002119, 1917701.2999999276 4220308.690002121, 1917710.5099999276 4220298.490002121, 1917711.8099999276 4220297.150002122, 1917725.0999999274 4220283.450002121, 1917731.8899999275 4220276.400002121, 1917736.1999999275 4220273.000002122, 1917741.0899999277 4220269.51000212, 1917742.8099999274 4220267.620002121, 1917744.1099999277 4220265.69000212, 1917745.5099999274 4220263.130002121, 1917746.5699999277 4220261.330002121, 1917748.6799999273 4220256.950002122, 1917755.9299999273 4220235.870002121, 1917755.9799999273 4220235.330002121, 1917756.76 4220226, 1917761.7112534414 4220217.3557474315, 1917767.66 4220206.97, 1917773.44 4220196.59, 1917781.94 4220181.31, 1917782.65 4220181.37, 1917846.66 4220186.59, 1917830.9776174359 4220204.772494434, 1917810.8866249172 4220239.533100539, 1917841.50147066 4220237.61967268, 1917867.651651399 4220252.289286265, 1917873.3919349757 4220233.473912319, 1917874.9864581914 4220227.893081063, 1917916.58 4220193.13, 1917935.18 4220205.23, 1917940.015378589 4220197.786353492, 1917957 4220171.64, 1917968.9200018295 4220153.109999165, 1917983.4699999276 4220130.49000212, 1918007.4299999273 4220093.90000212, 1918015.1099999275 4220095.360002122, 1918017.0699999274 4220092.810002121, 1918025.6099999275 4220080.130002118, 1918039.1799999275 4220059.2600021195, 1918039.5599999274 4220058.660002124, 1918047.1299999275 4220054.370002123, 1918065.2899999274 4220051.280002122, 1918069.4799999273 4220051.270002122, 1918070.3099999274 4220051.26000212, 1918079.8199999274 4220050.930002123, 1918100.3899999275 4220049.980002122, 1918105.3299999274 4220049.750002121, 1918107.104386292 4220069.856331525, 1918139.3185442863 4220075.895155521, 1918191.9378104073 4220079.403106595, 1918196.173466826 4220079.389393637, 1918247.0960422386 4220063.854961688, 1918241.5687989176 4220026.644553133, 1918236.7801277572 4220024.22424627, 1918229.6458149375 4220020.655412055, 1918216.8236208898 4220011.565632039, 1918202.7761033173 4220007.988054942, 1918188.230335023 4220005.671165819, 1918178.249585115 4220002.50968858, 1918168.3612500315 4219996.171666666, 1918148.223519507 4219983.344833446, 1918141.7741666927 4219978.513124997, 1918136.4758144328 4219976.10027485, 1918133.7648994182 4219974.767591584, 1918129.7299502026 4219973.335804179, 1918128.277073407 4219972.898592898, 1918123.2920568595 4219971.362078355, 1918120.833486471 4219970.385185773, 1918116.621421126 4219968.1273266515, 1918114.2832593594 4219964.829237167, 1918114.223921847 4219964.738853092, 1918103.4648800755 4219942.757215356, 1918091.3312500122 4219921.183541666, 1918084.3183081446 4219907.696599578, 1918048.5935416692 4219838.992499978, 1917998.0362499992 4219804.349583321, 1917990.2380920423 4219800.22710819, 1917975.2090720101 4219789.179205705, 1917959.7181250125 4219781.1295833215, 1917931.6166666718 4219779.357499963, 1917898.0207042508 4219778.241320817, 1917871.6311217702 4219774.220649374, 1917862.8695482232 4219771.198837773, 1917852.4194483645 4219766.600716804, 1917843.874019914 4219760.601379732, 1917841.18 4219768.81, 1917836.2 4219772.16, 1917834.37 4219773.84, 1917840.1 4219777.41, 1917856.17 4219787.97, 1917869.31 4219796.65, 1917875.48 4219801.35, 1917877.93 4219803.23, 1917936.62 4219808.9, 1917899.39 4219850.33, 1917882.99 4219868.2, 1917869.31 4219880.78, 1917831.07 4219916.46, 1917806.8392145536 4219938.898546547, 1917797 4219948.01, 1917764.94 4219977.97, 1917745.23 4219995.56, 1917735.07 4220005.61, 1917726.65 4220017.75, 1917724.36 4220021.04, 1917716.68 4220031.9, 1917730.78 4220042.04, 1917717.74 4220057.21, 1917717.03 4220058.02, 1917705.2871820203 4220071.278534974, 1917702.31 4220074.64, 1917699.28 4220077.96, 1917694.57 4220083.09, 1917677.12 4220103.22, 1917637.03 4220123.98, 1917604.08 4220150.45, 1917589.8078243213 4220161.711472746, 1917570.47 4220176.97, 1917585.37 4220188.08, 1917587.65 4220188.85, 1917559.31 4220209.27, 1917561.29 4220212.27, 1917555.1 4220217.33, 1917545.9568603477 4220224.822207475, 1917526.08 4220241.11, 1917529.95 4220245.65, 1917502.85 4220263.41, 1917484.66 4220271.42, 1917465.4730179636 4220279.688630848, 1917454.03 4220284.62, 1917450.16 4220280.12, 1917441.2 4220282.93, 1917412.8078685943 4220291.9043619335, 1917411.05 4220292.46, 1917414.62 4220304.1, 1917412.82 4220304.41, 1917403.8 4220306.07, 1917402.21 4220306.3, 1917401.55 4220306.49, 1917400.92 4220306.61, 1917295.6312645173 4220358.007200617, 1917205.66 4220359.22, 1917199 4220345.2, 1917186.69 4220318.85, 1917160.83 4220300.07, 1917155.84 4220290.03, 1917145.57 4220270.52, 1917143.6381343608 4220262.152243932, 1917135.06 4220261.63, 1917123.8552155516 4220260.90655504, 1917122.05 4220260.79, 1917120.314985752 4220260.8704602895, 1917118.020410233 4220267.494308135, 1917117.1661367703 4220271.230357231, 1917116.2557626448 4220275.14649192, 1917115.0632049667 4220282.093589644, 1917114.0137431424 4220289.286219743, 1917113.6490219506 4220292.434180127, 1917113.6611141977 4220302.620777386, 1917112.9567459594 4220327.989934845, 1917111.0989377492 4220342.972039134, 1917109.7958517466 4220353.48064292, 1917105.4597381072 4220385.596524545, 1917105.231286601 4220391.784353948, 1917105.9438458001 4220395.920908494, 1917113.3524519897 4220418.884883851, 1917119.4246470146 4220436.973980892, 1917123.2757888967 4220449.300154292, 1917129.6186057734 4220484.326376522, 1917132.5223581996 4220507.3831825685, 1917135.0232793542 4220539.899278846, 1917134.00862857 4220557.047260315, 1917132.476816784 4220565.729355225, 1917132.1317530076 4220566.66008556, 1917127.1648482024 4220578.462545989, 1917120.5627396367 4220592.078403598, 1917114.153776889 4220603.928747105, 1917105.9594110127 4220617.77544071, 1917092.625978075 4220640.26632739, 1917091.1267576502 4220642.8157681525, 1917090.6432389389 4220643.582859423, 1917086.5602950123 4220649.450783066, 1917079.216880416 4220658.39060615, 1917068.7844358627 4220667.395795937, 1917067.1243254836 4220669.7317668665, 1917067.9857327484 4220672.299001172, 1917068.887505721 4220673.8974066265, 1917070.5419752502 4220676.495046697, 1917080.9503199314 4220688.023365917, 1917093.8665324177 4220702.39889423, 1917098.3736844158 4220707.791462228, 1917105.3775853282 4220716.628511494, 1917106.8300814524 4220718.720568245, 1917108.7233296647 4220721.4474482965, 1917114.6099751308 4220737.882185726, 1917122.060890712 4220762.541399086, 1917125.9146066268 4220774.24541419, 1917128.1665402858 4220780.140287374), (1917890.8551066096 4221076.268344405, 1917893.96 4221076.24, 1917894.91 4221076.31, 1917904.3581255234 4221077.046281748, 1917914.03 4221077.8, 1917982.29 4221193.96, 1917982.8 4221194.14, 1917996.57 4221221.77, 1917995.76 4221222.33, 1917982.61 4221231.18, 1917982.52 4221231.76, 1917947.6022398875 4221279.769513042, 1917936.31 4221280.23, 1917897.55 4221206.12, 1917890.15 4221196.72, 1917885.94 4221191.37, 1917871.12 4221172.33, 1917856.16 4221144.94, 1917859.8808479768 4221140.504309309, 1917866.31 4221132.84, 1917865.66 4221113.38, 1917865.65 4221112.75, 1917865.43 4221090.68, 1917867.67 4221076.48, 1917890.8551066096 4221076.268344405))','ZO33052','"lib_modif"=>"N", "lib_code_insee"=>"38059 / 38158 / 38188 / 38309 / 38421", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UD3','Pavillonnaire en évolution modérée','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD3.pdf','2019-12-20','SRID=3945;POLYGON ((1915479.8751732945 4227066.572912905, 1915481.3779343255 4227051.6392901065, 1915482.9415365655 4227044.029759206, 1915485.0263395524 4227036.837188901, 1915487.8408235845 4227029.748858746, 1915490.8637879153 4227024.43261113, 1915493.886752246 4227020.784205903, 1915497.8478779208 4227017.969721871, 1915501.0793225502 4227016.823080229, 1915504.5192474783 4227016.406119632, 1915507.9591724067 4227016.718840079, 1915511.3990973348 4227017.448521124, 1915515.5687033082 4227019.116363514, 1915518.4874274896 4227020.263005157, 1915520.5722304764 4227020.784205903, 1915522.4485531645 4227020.679965754, 1915523.9079152553 4227020.158765008, 1915525.4715174953 4227019.429083962, 1915527.1393598847 4227017.969721871, 1915529.3284030207 4227015.467958287, 1915533.0668943666 4227010.282477096, 1915535.950699929 4227012.4080021, 1915557.1802999289 4227030.900802101, 1915568.6980999287 4227042.797802101, 1915573.1947009566 4227046.832553506, 1915595.435299929 4227066.7888021, 1915612.6577242797 4227081.70204217, 1915622.4315191566 4227090.165365708, 1915620.23 4227094.97, 1915619.54 4227095.91, 1915617.86 4227097, 1915615.54 4227105.25, 1915613.196653114 4227110.828763326, 1915608.5 4227122.01, 1915603.18 4227130.74, 1915597.05 4227140.8, 1915593.9322713101 4227140.099386811, 1915584.59 4227138, 1915583.39 4227140.05, 1915580.5145716995 4227144.954701918, 1915579.5752022867 4227146.557011724, 1915579.55 4227146.6, 1915578.59 4227148.22, 1915592.82 4227157.01, 1915611.0582889658 4227168.281849372, 1915619.55 4227173.53, 1915621.09 4227174.46, 1915622.17 4227174.96, 1915622.37 4227174.66, 1915624.52 4227171.33, 1915631.64 4227160.32, 1915633.27 4227157.83, 1915637.02 4227157.16, 1915646.29 4227151.21, 1915649.34 4227150.02, 1915650.83 4227150.96, 1915655.9789102506 4227154.196888023, 1915657.67 4227155.26, 1915657.26 4227156.6, 1915655.71 4227161.44, 1915656.17 4227161.57, 1915661.88 4227163.17, 1915664.83 4227164.67, 1915666.7037448667 4227165.64329039, 1915660.413562169 4227185.528384079, 1915662.2 4227186.15, 1915663.72 4227186.64, 1915670.2181798476 4227190.889912857, 1915675.05 4227194.05, 1915678.52 4227196.29, 1915672.08 4227201.21, 1915658.44 4227211.69, 1915656.2539252243 4227212.515296943, 1915655.0364705087 4227218.501115962, 1915654.0219249122 4227222.863662026, 1915652.3986519582 4227226.820389852, 1915653.92 4227228.2, 1915679.08 4227252, 1915684.22 4227256.81, 1915708.23 4227279.2, 1915709.3146599145 4227280.794215579, 1915688.0092023904 4227289.5193077065, 1915677.9652009865 4227293.577490092, 1915673.2475639633 4227295.606581285, 1915674.31 4227297.6, 1915684.47 4227318.68, 1915690.6131923208 4227331.418628161, 1915706.8322222217 4227365.050684633, 1915707.97 4227367.41, 1915717.29 4227372.2, 1915723.46 4227394.6, 1915729.9311520515 4227401.872082263, 1915737.68 4227410.58, 1915725.52 4227421.18, 1915727.1 4227422.78, 1915732.422548382 4227428.130126353, 1915734.82 4227430.54, 1915730.02 4227434.79, 1915730.94 4227435.84, 1915727.33 4227439.04, 1915731.62 4227443.52, 1915744.64 4227457.07, 1915752.6864841594 4227463.260241086, 1915754.1068479945 4227461.636968131, 1915758.3679394992 4227458.593331343, 1915765.2668495541 4227455.549694554, 1915767.7082456704 4227455.285209974, 1915777.4413967107 4227454.230785279, 1915780.1806698209 4227453.419148802, 1915783.4272157291 4227451.694421288, 1915787.3839435552 4227449.158057297, 1915797.6308540786 4227440.027146929, 1915821.5741301528 4227417.4027801305, 1915834.325883671 4227414.256243547, 1915839.0258871447 4227395.162702739, 1915839.5470882137 4227384.842928671, 1915840.068289153 4227375.148595064, 1915837.9834868673 4227362.327058218, 1915829.92 4227338.8, 1915840.527762371 4227336.435172882, 1915838.8316713297 4227327.501838853, 1915837.2304706923 4227321.959118471, 1915835.8650299273 4227317.175516558, 1915833.7468687796 4227312.29735541, 1915832.1180694173 4227308.20519745, 1915821.979740747 4227291.699345848, 1915818.694227257 4227284.573678896, 1915821.14 4227279.37, 1915817.84 4227276.08, 1915814.46 4227272.42, 1915811.21 4227268.53, 1915809.01 4227265.55, 1915807.07 4227262.39, 1915805 4227258.94, 1915803.74 4227259.59, 1915798.4782914123 4227247.826604118, 1915795.72 4227241.66, 1915811.81 4227232.72, 1915809.9546610636 4227222.584439979, 1915807.9 4227211.36, 1915807.57 4227209.55, 1915811.96 4227205.21, 1915813.13 4227200.82, 1915813.774140106 4227199.383222814, 1915809.4822803976 4227187.901993179, 1915807.885917966 4227184.319819222, 1915807.0965694967 4227182.55431405, 1915805.8000180337 4227179.959916327, 1915805.3829014762 4227179.126126084, 1915799.7648645544 4227167.884252375, 1915797.4844072682 4227162.346196934, 1915793.6362571071 4227152.611506485, 1915790.943149824 4227144.808491227, 1915786.6095399547 4227131.693900598, 1915785.6836510021 4227129.402106473, 1915783.745825752 4227123.888182406, 1915781.2513508457 4227115.97918686, 1915779.0075596937 4227107.973282189, 1915777.3841244031 4227101.615980866, 1915776.4047251164 4227097.773822446, 1915776.325938097 4227097.3655254105, 1915776.2419423868 4227096.932267829, 1915776.1394444443 4227095.935740741, 1915775.8510281565 4227093.1911271205, 1915773.941986192 4227072.324321856, 1915773.1016387318 4227064.278874122, 1915772.0838893258 4227060.009809815, 1915770.6109455815 4227056.907247858, 1915768.3608541514 4227052.178146271, 1915766.211852227 4227047.730662964, 1915765.2303646244 4227045.356955033, 1915765.3868703952 4227042.246505492, 1915765.831363226 4227040.787095383, 1915766.3404580506 4227039.750713271, 1915779.4514401332 4227024.391184625, 1915780.5869749752 4227022.770009923, 1915780.686308874 4227022.336132032, 1915780.9864625256 4227019.95092817, 1915781.2121833994 4227009.723795402, 1915780.6521815502 4227004.8762755, 1915771.2712499993 4226990.74875001, 1915793.5793309025 4226952.743163801, 1915801.9675000224 4226938.452499983, 1915800.8369977516 4226928.696854456, 1915798.9610438726 4226869.651743527, 1915798.4398977403 4226840.748552267, 1915797.9486893606 4226807.856307718, 1915797.1676445997 4226742.446275297, 1915785.4199998572 4226736.620004207, 1915785.8599998578 4226784.450004204, 1915774.749999858 4226779.110004186, 1915767.1972265781 4226794.875576067, 1915765.8699998579 4226797.690004203, 1915765.0099998575 4226799.480004204, 1915764.1699998574 4226801.230004204, 1915762.8599998576 4226803.990004203, 1915750.43 4226829.98, 1915679.51 4226797.19, 1915676.1900014982 4226795.66000069, 1915678.5199998578 4226790.670004205, 1915680.8399998576 4226785.460004202, 1915688.4199998574 4226768.990004206, 1915689.0599998576 4226767.620004202, 1915692.6399998576 4226759.930004205, 1915696.4999998575 4226751.550004203, 1915704.1099998578 4226735.230004205, 1915705.8799998576 4226731.320004204, 1915706.9999998575 4226728.860004202, 1915702.8599998578 4226726.470004204, 1915692.2099998577 4226720.340004202, 1915689.1946431827 4226718.612664123, 1915689.1899998575 4226718.610004206, 1915681.4699998575 4226714.170004205, 1915682.4999998575 4226711.950004207, 1915677.7699998575 4226709.660004204, 1915676.5999998578 4226709.090004202, 1915675.8299998576 4226710.790004204, 1915672.5099998575 4226709.210004206, 1915672.0499998576 4226708.990004206, 1915671.1199998574 4226711.290004207, 1915667.2032493167 4226709.886636697, 1915664.1802967298 4226708.810117082, 1915664.1799998574 4226708.8100042045, 1915659.3599998576 4226709.520004205, 1915663.4699998575 4226717.870004204, 1915653.2099998577 4226738.320004202, 1915648.4399998575 4226747.930004206, 1915645.1199998579 4226753.700004203, 1915641.7599998575 4226760.550004206, 1915641.5399998575 4226761.020004206, 1915633.0899998576 4226755.9300042065, 1915620.5299998578 4226748.370004204, 1915610.7799998578 4226742.400004203, 1915605.0499998578 4226740.060004207, 1915604.159999858 4226739.820004204, 1915602.5599998576 4226739.650004204, 1915593.0699998573 4226735.040004206, 1915591.5399998578 4226738.760004202, 1915589.9699998577 4226738.110004203, 1915588.0099998577 4226739.580004204, 1915585.2599998575 4226738.470004203, 1915584.9799998577 4226736.150004204, 1915583.6999998575 4226735.680004205, 1915585.3799998579 4226731.750004205, 1915573.8799998576 4226726.920004204, 1915569.4799998577 4226725.020004204, 1915569.7499998577 4226724.160004204, 1915570.0899998578 4226723.170004204, 1915571.0599998576 4226720.440004205, 1915573.6299998576 4226715.660004207, 1915578.9899998577 4226705.670004205, 1915574.3199998576 4226703.120004205, 1915573.9399998577 4226703.790004206, 1915564.2499998575 4226699.830004203, 1915559.8199998576 4226698.0200042045, 1915558.0999998578 4226698.540004207, 1915554.9399998575 4226699.500004204, 1915539.3799998576 4226692.360004204, 1915537.1799998574 4226696.040004205, 1915533.0199998575 4226694.100004204, 1915531.6399998579 4226693.360004202, 1915530.1899998575 4226692.380004204, 1915528.4899998577 4226691.010004205, 1915526.5799998576 4226688.830004205, 1915525.3699998579 4226687.220004205, 1915525.7099998575 4226686.710004205, 1915521.9199998574 4226684.940004206, 1915517.8399998578 4226683.760004206, 1915496.1299998576 4226674.460004203, 1915494.8299998578 4226677.280004204, 1915493.2699998578 4226676.570004203, 1915487.9499998577 4226674.140004202, 1915486.659999858 4226677.0600042045, 1915483.5699998578 4226675.280004203, 1915484.0599998578 4226674.430004204, 1915470.5699998578 4226665.840004205, 1915473.3799998579 4226659.920004208, 1915469.8499998578 4226658.330004204, 1915465.7099998575 4226656.460004205, 1915466.9599998577 4226653.780004205, 1915455.0999998578 4226648.350004206, 1915449.6299998579 4226645.850004204, 1915450.659999858 4226643.460004204, 1915436.529999858 4226636.970004206, 1915426.1999998577 4226643.100004205, 1915425.499999858 4226642.790004202, 1915417.4799998577 4226639.410004204, 1915414.5599998576 4226638.280004207, 1915411.3299998576 4226646.280004205, 1915384.9999998577 4226632.090004203, 1915384.6699998577 4226631.900004207, 1915384.1799998577 4226631.550004203, 1915379.3299998578 4226640.690004204, 1915369.5599998576 4226634.820004203, 1915363.5699998576 4226631.230004205, 1915354.1599998577 4226625.580004208, 1915354.7399998577 4226624.690004208, 1915348.3099998578 4226621.440004204, 1915341.2799998578 4226617.8900042055, 1915336.3399998578 4226615.400004206, 1915329.7199998577 4226627.970004206, 1915321.1799998577 4226638.630004207, 1915316.009999858 4226636.240004205, 1915307.2999998578 4226632.200004204, 1915305.5599998578 4226633.140004204, 1915303.7199998575 4226632.140004205, 1915310.3799998579 4226619.090004205, 1915302.7299998577 4226615.390004205, 1915301.3399998578 4226614.720004204, 1915304.3899998579 4226608.690004206, 1915288.549999858 4226600.500004203, 1915288.689999858 4226600.200004204, 1915294.3799998583 4226589.350004203, 1915290.1599998581 4226587.210004204, 1915284.8799998579 4226584.510004206, 1915283.629999858 4226583.930004205, 1915270.4699998577 4226578.080004207, 1915258.4899998577 4226572.6400042055, 1915256.029999858 4226571.590004206, 1915231.689999858 4226560.640004205, 1915230.1099998578 4226559.930004205, 1915235.269999858 4226549.410004204, 1915218.0699998578 4226540.980004205, 1915214.469999858 4226548.740004206, 1915209.9299998577 4226558.210004207, 1915207.699999858 4226562.870004204, 1915203.7399998577 4226571.130004205, 1915196.1799998577 4226573.370004207, 1915185.5999998578 4226559.110004206, 1915184.8399998578 4226558.070004205, 1915182.169999858 4226554.360004207, 1915179.9999998577 4226551.540004208, 1915177.4099998581 4226548.010004205, 1915169.159999858 4226536.730004205, 1915150.7899998578 4226511.620004204, 1915146.2699998578 4226505.430004205, 1915120.3099998578 4226469.620004206, 1915115.9399998577 4226467.720004206, 1915113.8999998579 4226467.030004203, 1915113.209999858 4226468.8500042055, 1915112.1899998577 4226471.560004208, 1915111.809999858 4226472.900004207, 1915111.7099998577 4226473.360004205, 1915111.079999858 4226475.940004206, 1915106.589999858 4226476.920004206, 1915105.5599998578 4226481.610004204, 1915105.3499998578 4226483.440004204, 1915102.4099998581 4226491.630004205, 1915094.0199998578 4226514.860004206, 1915090.949999858 4226513.850004205, 1915089.339999858 4226513.380004206, 1915067.079999858 4226506.900004206, 1915051.869999858 4226502.570004205, 1915047.089999858 4226501.200004208, 1915035.419999858 4226497.880004207, 1915030.9399998577 4226496.610004208, 1915022.3499998578 4226494.170004208, 1915015.129999858 4226492.110004206, 1915014.3599998578 4226491.880004208, 1915015.059999858 4226489.510004204, 1915019.219999858 4226476.480004208, 1915020.589999858 4226472.200004208, 1915026.9499998582 4226453.230004204, 1915022.2999998578 4226452.030004208, 1915007.179999858 4226448.070004205, 1914993.529999858 4226444.610004207, 1914986.549999858 4226442.180004207, 1914979.899999858 4226440.010004207, 1914971.6499998579 4226437.060004207, 1914965.049999858 4226434.710004207, 1914952.4899998582 4226430.150004205, 1914951.219999858 4226429.470004207, 1914936.9299998581 4226424.540004206, 1914922.639999858 4226419.260004206, 1914919.789999858 4226418.210004205, 1914923.599999858 4226412.490004207, 1914924.769999858 4226411.030004205, 1914928.399999858 4226406.510004207, 1914936.779999858 4226395.480004206, 1914938.589999858 4226392.100004204, 1914941.719999858 4226387.680004206, 1914942.419999858 4226385.990004207, 1914943.8099998578 4226383.120004206, 1914945.539999858 4226378.120004205, 1914948.009999858 4226372.700004206, 1914949.079999858 4226371.290004207, 1914950.179999858 4226369.770004207, 1914953.7199998582 4226365.510004206, 1914957.769999858 4226361.1400042055, 1914963.9899998582 4226355.340004205, 1914966.999999858 4226352.690004204, 1914952.919999858 4226337.270004209, 1914958.429999858 4226332.080004206, 1914950.3599998578 4226323.400004207, 1914961.939999858 4226314.040004208, 1914956.8899998579 4226308.390004207, 1914941.359999858 4226321.900004204, 1914938.1799998581 4226317.090004207, 1914936.899999858 4226315.180004208, 1914932.41 4226308.42, 1914929.4823579073 4226311.250054023, 1914928.81 4226311.9, 1914927.8 4226310.93, 1914909.82 4226292.2, 1914903.1490948168 4226285.246118478, 1914897.0900020364 4226278.930002122, 1914895.4599998577 4226280.48000421, 1914893.109999858 4226279.670004208, 1914890.9099998581 4226278.750004207, 1914889.139999858 4226277.910004209, 1914884.429999858 4226276.650004206, 1914881.689999858 4226274.910004207, 1914880.369999858 4226273.650004207, 1914879.049999858 4226274.800004207, 1914874.4636255791 4226278.801569982, 1914869.1199998583 4226273.070004204, 1914872.7652645055 4226268.258876665, 1914868.9999998582 4226264.340004208, 1914872.619999858 4226258.640004206, 1914874.4199998581 4226255.690004205, 1914875.179999858 4226253.850004205, 1914876.7699998578 4226249.890004209, 1914877.439999858 4226248.000004205, 1914877.739999858 4226246.890004208, 1914878.589999858 4226243.720004207, 1914879.5099998582 4226239.560004206, 1914879.869999858 4226236.120004205, 1914879.9899998577 4226235.3400042085, 1914880.019999858 4226235.000004209, 1914880.419999858 4226230.440004205, 1914880.8599998578 4226226.780004209, 1914883.079999858 4226218.650004208, 1914873.559999858 4226213.420004206, 1914873.8799998583 4226212.700004207, 1914872.6599998581 4226211.840004209, 1914873.379999858 4226210.310004209, 1914869.119999858 4226207.490004208, 1914869.499999858 4226206.8500042055, 1914861.989999858 4226201.33000421, 1914863.7299998582 4226198.440004205, 1914860.589999858 4226195.570004206, 1914857.879999858 4226192.840004207, 1914856.089999858 4226191.260004207, 1914853.9599998577 4226189.83000421, 1914845.439999858 4226201.990004207, 1914841.279999858 4226199.080004209, 1914838.429999858 4226196.95000421, 1914836.969999858 4226199.740004209, 1914832.7899998582 4226196.160004206, 1914828.869999858 4226192.770004209, 1914822.2399998582 4226198.960004208, 1914811.439999858 4226187.600004209, 1914814.669999858 4226184.390004207, 1914813.4899998582 4226183.050004205, 1914810.579999858 4226180.310004206, 1914804.389999858 4226174.520004206, 1914799.169999858 4226169.640004208, 1914794.1499998583 4226164.950004208, 1914793.729999858 4226164.300004207, 1914788.099999858 4226158.040004207, 1914802.609999858 4226146.110004206, 1914797.24 4226140.84, 1914797.73 4226140.19, 1914790.53 4226133.2, 1914794.26 4226129.77, 1914795.29 4226130.56, 1914797.8799998583 4226127.840004208, 1914798.0599998583 4226127.660004206, 1914797.3199998583 4226127.120004208, 1914789.419999858 4226121.420004207, 1914787.8299998578 4226120.270004209, 1914786.7299998577 4226119.480004208, 1914782.529999858 4226116.130004209, 1914775.979999858 4226111.170004208, 1914773.069999858 4226108.960004207, 1914770.629999858 4226110.600004209, 1914765.1099998583 4226118.870004207, 1914756.439999858 4226111.010004208, 1914753.309999858 4226107.940004208, 1914749.5499998583 4226104.860004207, 1914748.829999858 4226103.720004207, 1914748.5699998583 4226103.270004208, 1914757.9499998582 4226097.210004204, 1914757.649999858 4226096.520004208, 1914757.529999858 4226096.230004207, 1914753.0099998582 4226084.530004208, 1914752.839999858 4226084.660004208, 1914748.549999858 4226086.740004209, 1914746.279999858 4226081.750004211, 1914738.449999858 4226063.130004207, 1914738.8699998579 4226062.9200042095, 1914738.1837805053 4226060.861768926, 1914735.6990106367 4226060.407259618, 1914730.253651896 4226058.568355211, 1914724.3185602229 4226055.936506834, 1914713.5688975623 4226050.346319701, 1914710.0819700016 4226048.532999767, 1914709.8855319147 4226048.498496687, 1914709.5976404247 4226048.4719850775, 1914706.5347818097 4226049.550788845, 1914701.8893102491 4226051.134152513, 1914697.3370152588 4226052.636543059, 1914692.4663941034 4226053.887864664, 1914689.4894404013 4226056.14082553, 1914688.0603017462 4226056.62359354, 1914687.6105144084 4226056.782797341, 1914682.199630851 4226058.227203109, 1914675.8726308183 4226060.342463365, 1914672.4937799436 4226061.765770832, 1914660.3897253873 4226067.237443424, 1914659.7319406464 4226067.5200424995, 1914657.9975225872 4226068.232790559, 1914652.847546024 4226069.9792308975, 1914650.8787933025 4226070.650331395, 1914649.6772074776 4226071.004654547, 1914647.6943484596 4226071.355505125, 1914647.5636796076 4226071.385769028, 1914647.316527595 4226071.513737122, 1914646.042428846 4226072.643009015, 1914645.9431697999 4226072.730985282, 1914645.745140796 4226072.732908451, 1914645.7793343298 4226072.794121129, 1914652.3850943574 4226084.6196395615, 1914656.1 4226091.27, 1914660.22 4226098.22, 1914671.49 4226121.13, 1914676.73 4226131.01, 1914681.78 4226141.54, 1914682.1 4226142.15, 1914687.68 4226153.19, 1914691.6105528323 4226160.891758928, 1914695.82 4226169.14, 1914694.83 4226169.77, 1914706.08 4226190.1, 1914715.871611941 4226235.812251312, 1914721.0457944833 4226240.073342817, 1914731.2927050067 4226249.914435102, 1914737.582887704 4226255.190072203, 1914745.2934342367 4226260.161345625, 1914752.1923442918 4226263.813709772, 1914757.0621631546 4226266.248619203, 1914761.729072898 4226269.698074232, 1914776.9472568436 4226283.090076105, 1914781.7156211466 4226288.9744405635, 1914795.4119866975 4226302.670806115, 1914808.0938066524 4226316.164262546, 1914818.8479899738 4226327.932991464, 1914823.311990598 4226334.020265042, 1914827.6745366624 4226338.078447428, 1914841.3709022135 4226349.441358109, 1914862.3719960586 4226369.935179155, 1914870.894179068 4226377.341362009, 1914882.7643625457 4226388.501363569, 1914887.6341814082 4226394.588637148, 1914882.9672716649 4226395.806091865, 1914879.4163620775 4226398.443910415, 1914877.894543683 4226399.762819691, 1914876.1698161692 4226402.603547361, 1914875.053816013 4226404.835547673, 1914874.7494523341 4226407.7777299015, 1914874.8509068938 4226410.719912131, 1914875.6625433709 4226417.720276746, 1914876.8799980867 4226428.3730055075, 1914878.1989073618 4226437.199552196, 1914879.2134529583 4226442.576643857, 1914880.0250894353 4226446.4319171235, 1914882.5614534263 4226454.649736454, 1914887.1269086099 4226469.66501128, 1914892.7069093902 4226485.694831703, 1914897.8810919316 4226502.637743162, 1914899.8087285648 4226507.913380263, 1914901.6349106382 4226510.7541079335, 1914904.1 4226514.24, 1914906.71 4226517.18, 1914916.93 4226529.17, 1914924.69 4226538.13, 1914927.8488560661 4226541.867979678, 1914933.69 4226548.78, 1914951.94 4226561.6, 1914954.75 4226563.62, 1914957.480798382 4226565.577003938, 1914961.42 4226568.4, 1914961.87 4226567.66, 1914971.4 4226572.44, 1914977.68 4226575.67, 1914992.1739940988 4226583.38210283, 1915004.48 4226589.93, 1915006.91 4226590.53, 1915010.6 4226591.87, 1915014.14 4226592.59, 1915027.3061937625 4226595.138090588, 1915034.86 4226596.6, 1915036.58 4226596.93, 1915063.72 4226602.17, 1915065.0782062148 4226602.469029844, 1915066.8029337286 4226603.280666321, 1915081.6152994356 4226613.4261222845, 1915096.5618875192 4226623.657698354, 1915113.7763948408 4226635.441761726, 1915121.7913050521 4226641.326126184, 1915132.0382155755 4226647.616308882, 1915139.5458529887 4226651.877400387, 1915152.7349457415 4226656.74721925, 1915160.4454922741 4226659.58794692, 1915168.9676752836 4226661.819947232, 1915180.7364042015 4226664.457765782, 1915196.9691337436 4226668.617402727, 1915207.8247716248 4226673.18285791, 1915242.6236855804 4226688.806860095, 1915260.2767789573 4226699.155225177, 1915278.538599692 4226710.213772179, 1915290.205874051 4226717.822864151, 1915289.1 4226719.52, 1915277.65 4226735.08, 1915276.72 4226736.35, 1915274.6 4226739.24, 1915268.03 4226748.1, 1915266.83 4226749.74, 1915266.24 4226750.53, 1915278.56 4226765.24, 1915279.38 4226766.37, 1915280.37 4226768.36, 1915280.93 4226770.51, 1915281.02 4226772.74, 1915280.65 4226774.94, 1915279.83 4226777, 1915278.91 4226778.47, 1915282.1092427059 4226781.286648016, 1915292.54 4226790.47, 1915276.41 4226807.6, 1915287.67 4226818.42, 1915296.64 4226808.84, 1915300.57 4226804.64, 1915303.31 4226801.72, 1915325.27 4226822.75, 1915328.57 4226824.44, 1915315.5560129816 4226839.81454037, 1915313.85 4226841.83, 1915314.41 4226842.28, 1915315.85 4226843.43, 1915314.4 4226845.17, 1915314.1 4226845.52, 1915329.86 4226858.92, 1915332.13 4226861.27, 1915335.048789411 4226864.931975625, 1915334.07 4226869.6, 1915329.28 4226875.23, 1915330.78 4226880.46, 1915348.22 4226898.05, 1915340.16 4226904.78, 1915346.71 4226906.84, 1915360.1133992064 4226911.484225643, 1915364.69 4226913.07, 1915369.39 4226901.4, 1915373.6015220736 4226893.8465251215, 1915374.8189767895 4226895.165434397, 1915381.5149777255 4226902.67307181, 1915387.1964330652 4226907.948708911, 1915385.89 4226912.73, 1915381.0910261192 4226929.19784813, 1915378.66 4226937.54, 1915391.9904774828 4226941.10345015, 1915397.14 4226942.48, 1915397.02 4226942.95, 1915401.76 4226944.99, 1915406.7 4226947.05, 1915422.79 4226953.69, 1915415.75 4226972.07, 1915415.14 4226973.65, 1915413.9804368096 4226976.633445785, 1915419.2560739107 4226976.836354905, 1915424.1258927733 4226976.836354905, 1915429.4015298744 4226976.2276275465, 1915433.5611668197 4226975.31453651, 1915438.4309856822 4226973.6912635565, 1915445.431350297 4226971.662172363, 1915445.0255320587 4226973.995627235, 1915433.231439501 4227003.3159949705, 1915434.76 4227003.83, 1915439.47 4227005.62, 1915448.11 4227011.21, 1915450.414066894 4227012.278573443, 1915451.92 4227009.39, 1915460.0673850174 4227013.92145399, 1915462.51 4227015.28, 1915463.37 4227013.65, 1915479.97 4227022.9, 1915478.99 4227025.33, 1915481.62 4227026.79, 1915476.32 4227037, 1915475.84 4227038.53, 1915468.49 4227056.14, 1915466.15 4227061.71, 1915476.81 4227065.17, 1915479.8751732945 4227066.572912905), (1915518.0601225714 4226887.381830916, 1915522.306299929 4226858.1256021, 1915523.103599929 4226854.723202101, 1915524.127665035 4226845.691418897, 1915524.294999929 4226844.2156021, 1915530.0860999287 4226830.201602102, 1915533.2716534797 4226823.417209576, 1915534.880399929 4226819.991002101, 1915539.975699929 4226811.782002101, 1915546.9474922214 4226795.26775357, 1915547.94 4226795.72, 1915569.21 4226803.25, 1915574.7191333242 4226805.20312762, 1915586.2476200883 4226809.290268844, 1915591.86 4226811.28, 1915608.11 4226817.03, 1915616.13229197 4226820.049013407, 1915601.0334547104 4226852.089409023, 1915581.3829840103 4226893.788570651, 1915575.177551921 4226909.326415676, 1915559.16063075 4226904.363432143, 1915548.1632949908 4226899.959285832, 1915529.1655277668 4226891.463713657, 1915518.0601225714 4226887.381830916))','ZO32636','"lib_modif"=>"N", "lib_code_insee"=>"38126 / 38185 / 38516", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','A','Agricole','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1909475.6568002873 4214999.980351654, 1909475.18 4214990.88, 1909510.27 4214997.78, 1909509.5825568638 4215007.685381348, 1909519.3480467058 4215008.127248208, 1909524.4518681073 4215009.223885868, 1909530.3080456203 4215012.570547263, 1909534.813763172 4215016.268966381, 1909538.759570931 4215020.207401591, 1909547.7224503155 4215029.0847169245, 1909559.949736716 4215041.181246498, 1909600.88021111 4215038.354506026, 1909641.6808910316 4215035.387991358, 1909645.2322689632 4215035.124392275, 1909649.084399902 4215034.841323826, 1909653.0061437679 4215034.527578209, 1909662.4113783296 4215034.209119687, 1909666.794020796 4215034.405866055, 1909689.5236879585 4215030.493732228, 1909687.7279353281 4215025.442824481, 1909727.9627448635 4214957.829909079, 1909760.3044448686 4214903.671375304, 1909760.3081595977 4214903.670142318, 1909760.3 4214903.67, 1909759.89 4214903.32, 1909759.71 4214903.08, 1909759.55 4214902.81, 1909759.45 4214902.51, 1909759.4 4214902.21, 1909759.39 4214901.9, 1909759.44 4214901.6, 1909759.52 4214901.3, 1909759.65 4214901.03, 1909759.83 4214900.77, 1909760.05 4214900.55, 1909760.29 4214900.37, 1909760.55 4214900.22, 1909760.85 4214900.11, 1909761.15 4214900.06, 1909761.46 4214900.05, 1909761.76 4214900.09, 1909762.06 4214900.18, 1909762.34 4214900.31, 1909762.6 4214900.49, 1909762.82 4214900.7, 1909763 4214900.95, 1909763.15 4214901.22, 1909763.25 4214901.51, 1909763.31 4214901.82, 1909763.27 4214902.11, 1909763.18 4214902.72, 1909763.27477604 4214902.107941167, 1909763.314749359 4214901.817943307, 1909763.254448674 4214901.507620161, 1909763.1539428916 4214901.217743096, 1909763.0036260874 4214900.947720033, 1909762.8233094166 4214900.6975339325, 1909762.6028046836 4214900.487605073, 1909761.3183346763 4214895.896120202, 1909757.8142834469 4214893.248038499, 1909755.200128873 4214890.128526258, 1909752.6040563062 4214884.997864689, 1909749.74668667 4214878.296342194, 1909747.3792084954 4214870.914215216, 1909745.108143517 4214859.760079461, 1909742.6946961575 4214845.693825263, 1909737.1631950685 4214824.066590321, 1909731.331768613 4214803.419967345, 1909725.2935952728 4214785.995538788, 1909721.5550846998 4214778.774282924, 1909714.9648314759 4214770.695794476, 1909705.139659463 4214759.477917064, 1909698.932690508 4214755.901034904, 1909685.7633255576 4214753.401140335, 1909678.3386481104 4214753.056924487, 1909656.745725155 4214751.7049106965, 1909645.718308192 4214750.533522438, 1909636.2717510227 4214748.860693565, 1909630.317678179 4214748.255866456, 1909611.9465974045 4214747.401161801, 1909607.1929843703 4214746.544361328, 1909600.8069633392 4214743.48812379, 1909594.2696459622 4214739.021221578, 1909588.4019879184 4214734.18393568, 1909584.815990637 4214729.784137005, 1909580.8495847087 4214724.924806205, 1909574.0575952686 4214715.415282959, 1909564.130472678 4214701.516380159, 1909542.6860087232 4214675.900368915, 1909529.3938539566 4214658.341695572, 1909522.9097177987 4214646.590847669, 1909519.7737947726 4214641.280550794, 1909513.4680160643 4214627.498007033, 1909505.254025953 4214604.932359779, 1909498.0138156724 4214585.897664896, 1909489.6307578785 4214564.292706336, 1909485.5718661484 4214556.59205841, 1909474.952795988 4214541.562718735, 1909455.8689310118 4214514.604135235, 1909433.3560283228 4214479.353633825, 1909418.3475391085 4214456.213303345, 1909414.4695513223 4214449.443025198, 1909409.5598824269 4214440.922448572, 1909401.3180899934 4214420.9178774655, 1909390.7485453484 4214393.63201374, 1909380.800429393 4214367.135662963, 1909370.6114003449 4214340.429403332, 1909365.5257184117 4214325.4751678035, 1909362.4340156105 4214313.621163562, 1909358.6403551274 4214300.176869069, 1909356.3411397573 4214279.276908385, 1909353.736659624 4214264.330752845, 1909351.317689471 4214254.9879838, 1909343.5384108766 4214238.065158284, 1909336.6626078156 4214223.903107952, 1909328.0959752987 4214210.112316426, 1909324.2938125078 4214198.649145677, 1909323.9125624837 4214185.312391036, 1909328.3105597435 4214157.2428759085, 1909328.9352984184 4214150.698670091, 1909329.024651862 4214137.9912674455, 1909327.6495774053 4214132.739501699, 1909325.1207741813 4214124.126840896, 1909316.6714579898 4214095.9284768365, 1909310.27083904 4214075.832300232, 1909307.6479782644 4214062.547303235, 1909308.8773877807 4214049.15874594, 1909309.0874885747 4214037.942480567, 1909309.3242490697 4214022.113208236, 1909308.4243545567 4214010.927913173, 1909306.814846502 4214001.123400539, 1909303.5322354415 4213988.559377039, 1909297.679554293 4213966.1616500225, 1909293.2402379836 4213946.064401353, 1909288.5473728266 4213922.925468621, 1909287.7772647827 4213899.97347964, 1909286.5830666714 4213883.72520847, 1909289.7730344469 4213882.071548126, 1909293.9445772164 4213881.147654671, 1909310.5939149866 4213869.506664959, 1909326.0842705017 4213859.577626521, 1909334.3064204499 4213856.718976532, 1909344.180385989 4213854.899891566, 1909354.445813967 4213854.530881948, 1909362.219875344 4213854.194026509, 1909368.6245298507 4213855.209101796, 1909375.0908586092 4213858.835585358, 1909382.0994118263 4213864.002065554, 1909388.0886834557 4213870.67086066, 1909398.5445084518 4213882.298199852, 1909411.4802935743 4213892.4928098405, 1909415.2465472866 4213897.092353653, 1909421.6583063207 4213907.082445585, 1909430.1052604166 4213921.3331770655, 1909438.2229497225 4213936.654591021, 1909444.6271410233 4213949.016018247, 1909449.1682224644 4213958.968095158, 1909455.5851202204 4213974.241142963, 1909466.8758114474 4214002.407031576, 1909463.6550974231 4214003.910637383, 1909487.8268114973 4214048.394619101, 1909508.5113961548 4214086.838613442, 1909513.6730162126 4214097.239813798, 1909513.995623781 4214099.601260665, 1909512.886857922 4214101.76342432, 1909508.5372736068 4214105.088821495, 1909507.7595519007 4214108.251461936, 1909507.8735973476 4214113.123695513, 1909511.8840805031 4214122.485502199, 1909517.5892091906 4214136.618529979, 1909520.3465993658 4214143.660512047, 1909520.4714612318 4214149.243535622, 1909519.3038901517 4214152.836352509, 1909516.74630998 4214156.86080453, 1909513.6959188737 4214158.86434619, 1909512.867260781 4214160.736307221, 1909512.1721417971 4214167.110678776, 1909498.7779762866 4214170.544099711, 1909496.1076913222 4214171.957183896, 1909500.5353628304 4214201.53977778, 1909500.3706572517 4214207.583509674, 1909498.184704687 4214213.728633262, 1909494.4765634804 4214218.784852378, 1909483.5711708015 4214231.050693264, 1909477.9940131726 4214238.009784169, 1909476.7865623438 4214242.003061142, 1909475.948263982 4214255.721479085, 1909452.2884861664 4214260.034201315, 1909453.7856239139 4214267.606766834, 1909459.599273829 4214279.478842133, 1909462.666985661 4214298.346601289, 1909466.0185861068 4214309.439753184, 1909467.2828752508 4214313.611010235, 1909472.569875656 4214330.196185775, 1909476.924180026 4214343.5499479845, 1909495.206347858 4214345.765102675, 1909515.8479997125 4214346.067956968, 1909525.02364143 4214346.87053208, 1909527.276201247 4214348.379045778, 1909529.529380316 4214350.608563843, 1909533.720957917 4214361.121069947, 1909589.6355848766 4214353.228435395, 1909600.270069885 4214375.021744429, 1909602.8560907876 4214380.342112372, 1909628.798804469 4214401.001440402, 1909629.6942116444 4214395.067537927, 1909631.2111935092 4214390.7936342945, 1909631.929121604 4214387.911398689, 1909652.3643040222 4214380.579930352, 1909656.511442234 4214374.302842734, 1909660.3282419913 4214368.546531436, 1909661.6066174598 4214365.353440064, 1909661.4536095816 4214361.951460822, 1909661.1447738553 4214351.866062078, 1909658.40842768 4214335.088991134, 1909652.7350308576 4214311.090589524, 1909651.9591687594 4214305.23797018, 1909651.1164792364 4214302.657245132, 1909648.9604006375 4214296.755984059, 1909641.4487481413 4214276.220708384, 1909633.4774817715 4214256.6667795945, 1909595.828876267 4214236.777546979, 1909588.4267514376 4214203.965893274, 1909582.6010730476 4214178.096383863, 1909577.9086947027 4214166.743845265, 1909569.3360521402 4214145.969354727, 1909557.1237634644 4214116.333421871, 1909550.4762048263 4214100.2200951325, 1909544.3802808155 4214085.416830038, 1909541.6125220275 4214078.185152501, 1909528.1047403056 4214042.9870214285, 1909522.0980879955 4214027.273572584, 1909503.5859095769 4213978.792502586, 1909521.750541703 4213972.102966507, 1909578.94355143 4213961.828318672, 1909583.9631324948 4213981.5948793, 1909589.2037514155 4214002.192116938, 1909587.5935743062 4214002.803441795, 1909589.01994138 4214009.055919685, 1909591.3399845662 4214019.239832925, 1909669.2456711777 4213998.331020922, 1909689.3057538646 4213776.019568199, 1909688.6114245045 4213770.761410005, 1909677.79 4213759.52, 1909667.79 4213745.55, 1909664.78 4213740.91, 1909652.32 4213722.66, 1909650.4750148894 4213719.866495899, 1909656.8495014664 4213719.775597096, 1909684.6443911395 4213719.021704078, 1909687.0852934474 4213718.949367123, 1909684.0762394483 4213698.490716313, 1909777.2564164274 4213684.873055613, 1909777.47 4213680.66, 1909774.71 4213654.51, 1909773.4648223608 4213643.486515606, 1909776.5601933487 4213643.160025117, 1909776.5656574026 4213643.159448785, 1909812.3175657815 4213639.90780181, 1909813.5038966325 4213646.270336762, 1909818.178243338 4213671.560249613, 1909838.3673916482 4213669.311440731, 1909839.331292353 4213673.222997905, 1909830.8681778996 4213675.101521776, 1909837.9736060775 4213723.101841379, 1909866.5754184672 4213718.244540391, 1909871.0569362622 4213740.593581104, 1909876.3125211059 4213766.703661286, 1909876.8044860652 4213769.134597637, 1909881.4072495857 4213792.153513157, 1909895.889811238 4213794.378506081, 1909903.4286463354 4213795.5367165655, 1909902.56 4213802.35, 1909914.305811144 4213803.809479512, 1909914.3054723411 4213803.811347695, 1909913.9599999296 4213805.760002135, 1909912.641649208 4213813.016138014, 1909910.7204960554 4213823.615907869, 1909914.5932356394 4213824.282550797, 1909925.220738939 4213826.094826168, 1909932.786066517 4213827.3688332755, 1909941.091736837 4213828.792287077, 1909965.458012986 4213831.403192171, 1909964.9449181096 4213839.998041686, 1909964.224651043 4213852.015584652, 1909964.2203101176 4213852.014822759, 1909963.6683254512 4213859.321463548, 1909957.731989787 4213858.283544101, 1909946.33 4213856.29, 1909922.9 4213852.06, 1909918.57 4213852.01, 1909916.04 4213853.31, 1909915.58 4213855.35, 1909905.95 4213855.29, 1909871.5533121822 4213845.831778577, 1909866.31 4213844.39, 1909860.07 4213842.67, 1909859.9 4213840.32, 1909848.89 4213837.9, 1909837.51 4213834.99, 1909829.96 4213832.48, 1909825.14 4213830.43, 1909814.11 4213824.66, 1909801.14 4213818.27, 1909794.15 4213815.47, 1909788.38 4213813.95, 1909772.62 4213811.05, 1909769.7060433275 4213875.555778708, 1909766.6567851626 4213924.956449428, 1909765.0978477611 4213950.251751149, 1909766.8307952667 4213963.957736798, 1909769.5605960486 4213985.687560398, 1909772.9257464875 4214012.5299038, 1909747.8019320383 4214012.831860687, 1909729.8736419748 4214073.070616425, 1909724.2561486315 4214102.932580039, 1909703.0516969517 4214100.17905274, 1909704.4212019984 4214133.1663694745, 1909717.8562798565 4214235.302114723, 1909730.3652335978 4214283.878428712, 1909710.613227761 4214294.681662259, 1909720.1847056423 4214348.11363877, 1909702.132312374 4214357.594071558, 1909708.696468967 4214381.421815299, 1909724.5104070422 4214410.584611547, 1909728.9287403557 4214417.39464153, 1909735.6909341589 4214427.164720939, 1909764.1449430508 4214412.992108521, 1909776.226336765 4214406.948330988, 1909791.5283865072 4214399.330700972, 1909807.2484785803 4214447.1040318655, 1909804.009538367 4214473.49164579, 1909814.4190406804 4214512.875037726, 1909834.8609664247 4214525.244220715, 1909841.0571243346 4214539.987384335, 1909843.5440044152 4214545.898570574, 1909847.5444483217 4214555.430291883, 1909868.8099642773 4214606.090705519, 1909861.5971310704 4214607.747839136, 1909867.9726304756 4214633.466828696, 1909859.1943061638 4214640.928774956, 1909864.545204395 4214661.966013919, 1909840.1016917187 4214755.309582729, 1909842.4387045393 4214761.470643699, 1909844.2556834905 4214768.863445663, 1909849.1332569693 4214786.10876669, 1909853.167595917 4214800.143604993, 1909854.523124099 4214805.685361842, 1909857.2841727054 4214828.12543215, 1909860.9011537726 4214857.369003105, 1909861.465914737 4214862.07096773, 1909862.7195091043 4214865.662314189, 1909864.192247952 4214867.882299274, 1909865.7853467339 4214870.441972356, 1909870.1019900874 4214875.571152142, 1909877.503273783 4214883.609319526, 1909880.3390626526 4214888.249897246, 1909886.975228815 4214902.932068496, 1909894.2139983545 4214920.2456059875, 1909889.2584288009 4214917.018247514, 1909886.3773654653 4214917.67089293, 1909882.557128747 4214919.435572936, 1909879.7180289659 4214922.809516701, 1909877.7513114284 4214927.684156621, 1909877.474956368 4214932.337018097, 1909880.5609611492 4214948.6935890885, 1909881.4666076 4214954.66617895, 1909881.0120363906 4214961.510430231, 1909888.2824469612 4214968.84811743, 1909881.1777710856 4214979.70054854, 1909868.8455562475 4214996.380762719, 1909855.3638445886 4215015.333047836, 1909849.4792723749 4215025.043186547, 1909845.8146716792 4215033.961369997, 1909840.0550662938 4215050.065610677, 1909828.6572267534 4215083.094053462, 1909825.7249921365 4215094.052761252, 1909823.0438213646 4215105.851728131, 1909818.59 4215123.85, 1909835.7540779195 4215167.82580274, 1909842.0895984054 4215181.948134035, 1909843.0497101743 4215181.447225593, 1909848.3924495236 4215181.122648771, 1909854.0252446008 4215180.20708856, 1909861.4555373495 4215175.8980656145, 1909869.206522773 4215171.719040216, 1909873.3368896304 4215169.664728183, 1909877.4678070203 4215168.250377136, 1909880.4095523213 4215168.3475024225, 1909882.901879351 4215169.416363063, 1909885.505270999 4215171.185123556, 1909888.1585273524 4215173.694059289, 1909889.950799108 4215174.693282537, 1909892.3917933095 4215174.710993429, 1909901.025463794 4215172.842513242, 1909906.4472383931 4215171.577135728, 1909912.5372319336 4215167.56943429, 1909917.0471710488 4215164.303910935, 1909927.4476232266 4215158.231535788, 1909935.850487403 4215156.043272411, 1909946.0438598548 4215153.502869748, 1909956.616787527 4215149.731444899, 1909964.1589695376 4215147.0834613545, 1909969.13052385 4215145.8586928435, 1909977.4757903523 4215146.501676776, 1909980.7999999297 4215146.360002134, 1909983.48999993 4215145.700002133, 1909965.89 4215105.21, 1909956.11 4215083.82, 1909953.5758834437 4215078.560250959, 1909946.98 4215064.87, 1909946.3398578146 4215063.409628348, 1909949.92 4215057.57, 1909961.38 4215055.78, 1909969.7424999296 4215054.726802136, 1909975.51 4215053.86, 1909980.17 4215052.76, 1909984.53 4215051.04, 1909991.31 4215047.74, 1910000.12 4215041.94, 1910006.75 4215037.2, 1910022.84 4215023.85, 1910035.12 4215013.67, 1910052.76 4215002.84, 1910068.47 4214993.05, 1910087.51 4214981.41, 1910087.33 4214976.02, 1910081.45 4214961.44, 1910077.9467056475 4214949.65959654, 1910082.7714770872 4214948.002553393, 1910087.7899999297 4214946.180002133, 1910176.5599999297 4214915.570002136, 1910182.5199999297 4214934.190002134, 1910187.3399999298 4214949.280002134, 1910187.7299999297 4214950.500002135, 1910259.74 4214926.31, 1910284.23 4214918.08, 1910314.1306414579 4214908.0272612395, 1910316.141100157 4214919.081961547, 1910320.7858556497 4214944.772445488, 1910324.995416643 4214964.950397853, 1910327.3299999298 4214974.040002133, 1910330.4799999297 4214984.460002133, 1910336.3813885883 4214982.511527421, 1910337.79 4214986.56, 1910344.81 4215007.05, 1910352.15 4215028.59, 1910354.14 4215032.55, 1910360.29 4215046.23, 1910361.39 4215057.42, 1910364.27 4215072.89, 1910369.13 4215093.13, 1910371.8299999298 4215106.290002134, 1910384.4899999297 4215104.7200021325, 1910398.0299999297 4215103.030002135, 1910405.4299999294 4215130.180002133, 1910410.4599999296 4215148.620002132, 1910415.3799999296 4215148.040002135, 1910431.0799999298 4215213.280002133, 1910450.3699999298 4215286.250002134, 1910465.0899999298 4215283.800002132, 1910483.6999999294 4215280.700002134, 1910489.9199999296 4215279.660002133, 1910514.5099999297 4215275.450002133, 1910539.4399999296 4215271.180002132, 1910566.2999999297 4215266.730002132, 1910604.0699999295 4215260.490002135, 1910608.4399999296 4215259.760002131, 1910628.3899999293 4215256.360002135, 1910595.2599999297 4215119.570002132, 1910591.046335579 4215104.809916195, 1910585.0577655102 4215087.204744783, 1910577.8654625467 4215066.059214812, 1910569.2893165178 4215041.362676459, 1910561.194263185 4215017.61606116, 1910553.6507755662 4214995.0900606, 1910545.9399999296 4214978.8000021335, 1910526.4465406938 4214938.872019992, 1910505.7745530433 4214891.643222351, 1910484.4001270833 4214842.964020275, 1910493.3929868767 4214828.808089086, 1910492.5465486927 4214821.895324282, 1910478.8342024006 4214781.514001339, 1910462.4437385702 4214733.461473978, 1910453.100001032 4214688.834407366, 1910438.3371791951 4214684.064250221, 1910403.2746472477 4214668.985789343, 1910380.6135821631 4214659.109963706, 1910378.2666062901 4214652.54849414, 1910374.8185595432 4214645.927340105, 1910337.0544846454 4214630.811579099, 1910339.3536624764 4214628.5883470345, 1910326.8905903783 4214621.555329331, 1910307.0966586636 4214606.703828988, 1910291.2056199568 4214592.659419518, 1910288.1997856908 4214587.849703685, 1910285.0401668327 4214578.747105896, 1910284.3689398011 4214577.296668378, 1910282.0879001003 4214577.578992205, 1910278.0874887404 4214556.960843059, 1910271.2903551066 4214541.508009018, 1910262.4698231206 4214522.965181424, 1910253.8477160528 4214503.391404438, 1910245.6766792154 4214484.067580651, 1910235.4222238383 4214462.364615453, 1910225.8783563133 4214441.110692032, 1910217.49884427 4214423.688319865, 1910209.7111709784 4214408.245951207, 1910204.3403450001 4214398.94535184, 1910203.488383466 4214397.455448601, 1910198.5253638395 4214385.573048247, 1910194.5737887723 4214374.940279224, 1910192.728898127 4214369.999292962, 1910186.6219727565 4214354.325549689, 1910181.276988487 4214340.872998321, 1910176.008102181 4214333.52340841, 1910164.8384403093 4214318.434554152, 1910162.8443281457 4214314.493858776, 1910161.8092233413 4214309.4717307445, 1910160.673725858 4214292.443550252, 1910159.724066024 4214281.377757141, 1910157.5316440586 4214268.842809976, 1910152.955228325 4214252.75772375, 1910150.3954302077 4214243.044677521, 1910147.6850305975 4214232.7308242135, 1910145.265168679 4214222.3873045575, 1910142.7241910663 4214211.52339766, 1910136.4272533394 4214184.333567739, 1910129.978388745 4214155.002470761, 1910125.3162041325 4214132.03400614, 1910120.9350691142 4214110.565542444, 1910114.909115181 4214084.336027989, 1910109.0043671983 4214059.42715182, 1910103.1394123635 4214034.018163588, 1910095.45712805 4214001.506363531, 1910089.3312769106 4213975.686975619, 1910089.160779151 4213974.987130441, 1910083.5183858084 4213952.869601703, 1910078.019280428 4213934.013577324, 1910077.5471012136 4213932.253198169, 1910069.4174580118 4213903.0934717, 1910064.8811747846 4213886.888305764, 1910060.003434153 4213869.44314076, 1910058.0449441168 4213860.84981766, 1910055.5426894932 4213848.234712619, 1910052.2365965974 4213831.448566518, 1910048.0360311782 4213810.510068607, 1910042.7711317148 4213784.760197502, 1910042.0374662818 4213781.209243022, 1910039.9473442084 4213771.0353523, 1910035.6358520295 4213748.856661373, 1910030.6233188268 4213725.457493261, 1910029.850318098 4213722.936749281, 1910022.264874785 4213698.289899667, 1910015.4720543774 4213675.942855451, 1910012.2321318397 4213666.280243594, 1910004.9275075449 4213642.863844842, 1910000.3743163648 4213630.020587111, 1909995.429670111 4213616.4368530875, 1909995.505484582 4213611.754172506, 1909995.6535546319 4213597.556115799, 1909995.5960718074 4213588.661598247, 1909994.1343933996 4213576.265933906, 1909994.4299034674 4213558.995837313, 1909995.333821126 4213539.944624372, 1909995.64958136 4213523.1847977415, 1909995.7358082123 4213518.742244013, 1909996.151170213 4213501.222308981, 1909996.1083572041 4213486.353848804, 1909995.4331697496 4213469.135022125, 1909995.4318051324 4213469.128359765, 1909994.2877204844 4213463.542687328, 1909993.5040307129 4213459.761251763, 1909991.2082570314 4213454.770242055, 1909986.6902907111 4213448.671125599, 1909978.588688224 4213440.203170049, 1909971.9592663294 4213433.315229667, 1909967.9532547551 4213429.155955043, 1909955.3755811104 4213416.529729684, 1909944.8797869226 4213405.2026385125, 1909934.7244431842 4213393.944893302, 1909926.9226416647 4213385.046840208, 1909917.3980554892 4213374.259214911, 1909903.566932209 4213358.892339379, 1909899.5422310731 4213356.034006128, 1909884.6045628383 4213345.40112078, 1909871.2430545927 4213316.946547018, 1909868.887027824 4213311.695645914, 1909838.5293433573 4213276.13212263, 1909830.4313704176 4213248.834074724, 1909830.217872168 4213244.902067934, 1909827.884125064 4213241.821957943, 1909827.0131850012 4213241.292611595, 1909817.1981982433 4213241.851557994, 1909811.8251856528 4213229.959351515, 1909802.3214912305 4213208.545792616, 1909793.2590127946 4213188.492213281, 1909783.8754658822 4213167.168604035, 1909774.6124689174 4213146.405004377, 1909765.2098538629 4213125.94169316, 1909754.3420806844 4213100.887087113, 1909744.7289220784 4213079.923281234, 1909736.8387296677 4213061.760354732, 1909734.36172994 4213055.448771539, 1909721.6960931174 4213018.763947368, 1909712.486960647 4213026.14161924, 1909701.8872380417 4213034.095005354, 1909689.5438117625 4213041.9238144765, 1909684.5675968993 4213043.452204049, 1909668.8253166266 4213048.221796478, 1909652.5592210167 4213053.527044798, 1909615.2431703003 4213064.731450797, 1909600.2617827964 4213069.018669647, 1909594.8626994565 4213069.872251091, 1909590.4908548084 4213070.10276544, 1909581.3549203519 4213068.7727029165, 1909569.0395056412 4213066.20143094, 1909556.1073699186 4213064.093557941, 1909550.9637758126 4213063.476980525, 1909543.4693151957 4213063.66889683, 1909532.9049147614 4213064.870556774, 1909527.7324836303 4213066.21420169, 1909523.254088689 4213067.377556492, 1909512.2887695516 4213071.178373572, 1909495.7283434952 4213078.408662249, 1909487.391473598 4213083.064800215, 1909489.6724045025 4213089.77669475, 1909490.1558256964 4213091.059717171, 1909491.7135669063 4213093.640831131, 1909501.6755462433 4213111.42341325, 1909502.7704797739 4213110.898256422, 1909519.5839371427 4213103.790272888, 1909531.0959701077 4213098.927287415, 1909543.5673366212 4213126.922164139, 1909517.4040760775 4213140.091947864, 1909514.8537489465 4213141.365045066, 1909513.1333307761 4213142.226801106, 1909509.759705586 4213142.704386716, 1909507.4168046417 4213162.547996752, 1909504.5488866398 4213189.639979756, 1909501.934674576 4213208.312843192, 1909501.5642231912 4213210.958913193, 1909496.5269098943 4213225.417096516, 1909484.2764588718 4213257.58403045, 1909479.0274284207 4213272.323296466, 1909480.0437826854 4213298.66690433, 1909479.7392999567 4213312.150929872, 1909477.2984366335 4213333.917074755, 1909473.375295413 4213344.322959399, 1909460.9481468282 4213362.805577624, 1909447.5966264792 4213378.311889663, 1909416.0229842276 4213413.962570851, 1909400.8829830382 4213431.350223732, 1909393.4695576953 4213439.260678484, 1909378.8024746242 4213452.437474624, 1909365.83 4213463.230387819, 1909355.4373474494 4213471.658305275, 1909358.8293213157 4213528.8217959395, 1909360.0323314662 4213557.774122858, 1909355.3517790101 4213592.748581344, 1909347.895 4213603.835, 1909349.120244661 4213614.547474625, 1909345.6910203006 4213637.35160203, 1909339.35 4213669.08, 1909328.7558666444 4213715.288997977, 1909325.0726340387 4213727.813150628, 1909324.6106479345 4213729.428408119, 1909323.596255438 4213731.86926144, 1909323.160240811 4213732.9326738855, 1909318.4320931372 4213743.175171921, 1909309.7751362808 4213754.761544121, 1909308.1217478146 4213757.076479435, 1909303.8391252572 4213758.538152216, 1909292.3495914442 4213752.222917044, 1909289.4020328869 4213750.64391217, 1909280.3250906218 4213747.982816657, 1909274.9483394483 4213747.06086918, 1909249.1050991039 4213745.765020972, 1909245.7449856743 4213745.783740796, 1909239.6128351984 4213746.202778007, 1909223.6956580996 4213747.590031453, 1909209.5041139536 4213749.123943647, 1909203.32007465 4213748.774571876, 1909193.6232004147 4213747.35819684, 1909133.8327926542 4213732.8653863715, 1909127.1930699714 4213731.540271549, 1909123.5680374273 4213731.162480803, 1909117.3928780325 4213731.012767496, 1909113.506922918 4213730.91985933, 1909111.721464913 4213730.643882755, 1909098.523442351 4213728.615080606, 1909090.2957966465 4213728.186427429, 1909088.0763077557 4213726.800554218, 1909084.0363297146 4213724.557303233, 1909079.8175718405 4213718.909453166, 1909077.5477628992 4213722.474118457, 1909071.2363923506 4213736.437330576, 1909069.7145052096 4213746.9042866435, 1909069.0676396608 4213762.663653516, 1909101.6138561876 4213772.021412507, 1909101.8089298338 4213778.284548367, 1909096.5524441823 4213785.3532043025, 1909099.052470496 4213795.426497584, 1909109.360280203 4213798.279464444, 1909112.9834317598 4213811.033495764, 1909125.3997486795 4213810.53237957, 1909128.450464253 4213832.722381139, 1909139.5868754361 4213832.932558553, 1909145.715195407 4213849.847173174, 1909148.8175523006 4213897.2608523965, 1909153.781575537 4213922.290612154, 1909156.7642504354 4213935.135248639, 1909153.289148885 4213955.029166277, 1909132.5266997875 4213953.836686035, 1909132.942998274 4213961.150225263, 1909131.3886861377 4213968.805844478, 1909152.3273962657 4213976.722540073, 1909144.8758069435 4214003.083690892, 1909139.101485566 4214025.160606895, 1909142.2264832326 4214028.950253072, 1909143.8292516985 4214030.899972425, 1909153.1494776302 4214048.411600331, 1909191.4682552046 4214080.506955272, 1909210.4491360222 4214115.56054033, 1909237.8590785554 4214295.898024688, 1909238.0106985585 4214297.688700036, 1909235.9696828413 4214297.840534735, 1909225.3440854277 4214298.269883219, 1909219.6112312686 4214298.695035481, 1909217.3988447397 4214297.826444007, 1909190.085562658 4214300.221196318, 1909196.2740122345 4214352.235100859, 1909215.0100654413 4214347.486576616, 1909212.8560394878 4214367.069621847, 1909205.78136191 4214389.818264253, 1909170.204227129 4214393.380553772, 1909174.8681016432 4214441.523609645, 1909187.7523008622 4214437.740642617, 1909190.5515330322 4214458.580156381, 1909207.3051309206 4214463.458540406, 1909217.6934970822 4214477.607390303, 1909224.6853870417 4214487.126949159, 1909235.9635894394 4214512.631621967, 1909237.5749715404 4214513.420284191, 1909239.4306590934 4214518.371477632, 1909242.3990393553 4214526.433866933, 1909243.4430876947 4214530.70497388, 1909251.1468623322 4214529.587741743, 1909251.1768791901 4214529.587716, 1909251.9368030592 4214529.4669966735, 1909254.3343034098 4214548.075406834, 1909255.8203031556 4214565.764282519, 1909256.1950179753 4214582.68327902, 1909255.9213270927 4214601.65418706, 1909256.065316967 4214606.447160482, 1909256.7023637795 4214626.147300006, 1909262.0208156295 4214643.712826366, 1909263.1834307457 4214646.233248242, 1909265.9802438116 4214652.344090015, 1909275.1417244086 4214671.617284531, 1909277.3252136793 4214673.78683384, 1909278.936871996 4214674.896076511, 1909278.930871759 4214679.79844152, 1909278.9251206315 4214684.291375906, 1909278.9106059298 4214691.165258404, 1909279.7212243802 4214691.354269818, 1909293.8120674114 4214694.5143674975, 1909292.8022839217 4214730.184919672, 1909291.8768352522 4214759.892845917, 1909290.5037415992 4214791.9418786485, 1909290.1017799869 4214801.347723057, 1909289.6698016603 4214811.453588029, 1909287.3840038902 4214852.378813297, 1909286.1428737312 4214875.202343743, 1909287.1865229239 4214913.993521463, 1909287.386186876 4214924.899700872, 1909287.575250075 4214935.345430151, 1909285.4438359 4214958.890138556, 1909285.1462595018 4214961.91249869, 1909283.5692691985 4214978.122996221, 1909281.5263083477 4214999.106587686, 1909281.9518935462 4215028.432772806, 1909281.9559623473 4215033.175446143, 1909281.9782796917 4215036.096675831, 1909285.1318765173 4215038.215567809, 1909289.1274315785 4215042.063914016, 1909291.4921252881 4215046.214429199, 1909292.1318975743 4215057.189876219, 1909292.123262542 4215058.320922122, 1909292.0481996217 4215064.594528168, 1909291.964037597 4215071.458275356, 1909289.5045132 4215084.828133023, 1909288.8471796697 4215088.370696936, 1909278.9024013714 4215101.476224403, 1909265.0668293163 4215104.089962985, 1909262.6045649254 4215114.267821845, 1909260.084687085 4215127.96731955, 1909258.3227776494 4215138.564815959, 1909255.8855169495 4215154.796474636, 1909255.719638105 4215160.17925777, 1909255.35955441 4215171.516371601, 1909261.818817664 4215178.064133258, 1909264.9541589613 4215182.694261255, 1909261.7354273852 4215197.725314473, 1909259.3634282798 4215208.8540372215, 1909259.9950715557 4215210.354343569, 1909262.6294548083 4215213.263729189, 1909266.7339217132 4215216.001357313, 1909271.8940809024 4215235.878367731, 1909275.1282458967 4215238.83706712, 1909279.8448639787 4215243.446028241, 1909281.0279536054 4215246.036077927, 1909281.6101045012 4215248.627243544, 1909282.6779596936 4215256.850976951, 1909253.79380219 4215259.617506341, 1909254.1109150334 4215267.471474857, 1909245.8568462497 4215268.1689456515, 1909245.4575788258 4215269.520051854, 1909242.6742750509 4215290.364424188, 1909242.4023106124 4215300.150191203, 1909243.3265340747 4215315.898105137, 1909266.8573459333 4215312.986083887, 1909286.192211056 4215376.345547599, 1909292.8338475726 4215373.638320555, 1909299.7755417742 4215370.800562203, 1909309.9183987835 4215367.4401627295, 1909323.1522637 4215363.216223369, 1909337.9763062475 4215358.151043558, 1909342.5470212125 4215356.436153024, 1909358.1579049905 4215346.937389159, 1909369.258502766 4215340.313920235, 1909374.348491509 4215337.1775797475, 1909388.0504515925 4215329.96174362, 1909405.0818717557 4215320.622049181, 1909422.3536663982 4215311.5619057985, 1909436.1154512907 4215304.105880664, 1909455.4568069666 4215293.173300937, 1909467.4377793309 4215286.179264124, 1909473.6176020973 4215281.901341546, 1909476.1069983495 4215279.557880002, 1909479.6425195567 4215272.010378314, 1909486.8636723608 4215256.945863894, 1909491.2278293513 4215247.496976736, 1909439.2421729998 4215251.84364834, 1909439.0434556028 4215242.04868199, 1909457.2733454877 4215241.332433386, 1909453.1831447359 4215197.180990743, 1909434.1036850517 4215198.488101687, 1909425.047405872 4215150.749100764, 1909432.171246669 4215150.302335817, 1909431.86658496 4215145.070041662, 1909429.7960376176 4215110.832081008, 1909429.3792556764 4215103.668593358, 1909434.713247447 4215104.344198019, 1909432.670488726 4215021.359303853, 1909430.9905649081 4214998.77780237, 1909475.6568002873 4214999.980351654), (1910074.9657638767 4214821.427926579, 1910066.6199151482 4214813.697434986, 1910063.3487238558 4214791.447515127, 1910057.984007065 4214766.237931888, 1910054.9091469424 4214750.982386126, 1910049.2536502224 4214724.822121754, 1910041.668876815 4214689.839153548, 1910037.7500570149 4214670.531457759, 1910027.8542777356 4214612.177535693, 1910024.5649101424 4214591.818712879, 1910032.1587112634 4214591.271871362, 1910070.089997871 4214590.748736458, 1910127.6088953963 4214587.197431475, 1910152.381477709 4214585.39489128, 1910154.7526722034 4214585.2331588585, 1910176.9940974405 4214583.973100488, 1910204.378464947 4214582.5387132885, 1910232.3830926332 4214581.234061798, 1910233.6207968714 4214601.214034306, 1910233.9806350218 4214635.623283014, 1910234.1663525307 4214653.983254353, 1910260.240432448 4214652.830347149, 1910266.7715136507 4214652.812316494, 1910266.35 4214656.33, 1910265.83 4214661.63, 1910265.44 4214665.58, 1910264.03 4214681.25, 1910263.6 4214690.77, 1910264.12 4214695.53, 1910264.5 4214699.01, 1910267.99 4214708.84, 1910271.52 4214719.37, 1910280.5 4214742.19, 1910288.63 4214764.39, 1910280.1400929308 4214767.357680385, 1910276.068287143 4214767.691376072, 1910254.9330511498 4214775.664072825, 1910245.2105897006 4214779.164018691, 1910232.6969114917 4214783.077000942, 1910214.9812873867 4214788.365637586, 1910197.6262150975 4214793.363398738, 1910177.359256892 4214798.773698522, 1910157.122763013 4214804.704463761, 1910142.357841133 4214808.649398153, 1910124.1619825934 4214813.287675912, 1910107.0460017696 4214817.774937799, 1910094.6519643122 4214821.197334328, 1910082.978461641 4214824.769794693, 1910074.9657638767 4214821.427926579), (1909770.47 4213539.29, 1909761.9557065086 4213539.712821684, 1909761.7404568526 4213537.784093592, 1909761.7415660608 4213537.78383167, 1909760.8453522162 4213530.901159624, 1909756.0805919163 4213494.004460088, 1909755.1540948935 4213486.811442078, 1909753.8746368955 4213476.866792125, 1909752.2429308558 4213464.301382964, 1909749.6846416467 4213444.44210145, 1909758.149469483 4213444.56509748, 1909775.769225394 4213444.479710844, 1909772.6075726252 4213421.09938575, 1909787.4240523141 4213419.255626226, 1909787.4247231102 4213419.259362501, 1909790.755787125 4213418.809754597, 1909790.95 4213419.69, 1909792.47 4213432.56, 1909793.07 4213445.37, 1909793.29 4213463.04, 1909793.44 4213479.1, 1909793.26 4213489.97, 1909793.23 4213493.26, 1909794.72 4213495.3, 1909796.99 4213496.21, 1909801.89 4213496.89, 1909806.21 4213496.58, 1909821.77 4213493.64, 1909830.8572610782 4213492.257037559, 1909838.46 4213491.1, 1909853.26 4213489.74, 1909865.93 4213488.64, 1909873.11 4213488.82, 1909889.7 4213490.82, 1909902.17 4213492.48, 1909906.75 4213493.01, 1909908.84 4213493.24, 1909922.89 4213491.02, 1909927.1272065153 4213490.37865941, 1909927.2288004784 4213496.678847454, 1909929.5094178172 4213554.529376606, 1909896.0239070917 4213557.999905616, 1909898.2619187236 4213565.632442863, 1909894.6399719254 4213566.185465611, 1909881.0946342025 4213568.308496148, 1909858.4746399573 4213571.83991307, 1909815.8769704304 4213578.49043976, 1909820.7943439703 4213595.975777979, 1909768.1886172509 4213599.993427916, 1909764.422985237 4213600.381243302, 1909764.16 4213599.87, 1909761.49 4213597.17, 1909763.21 4213590.31, 1909764.99 4213574.65, 1909765.46 4213567.1, 1909767.5 4213560.72, 1909787.43 4213559.67, 1909799.47 4213558.66, 1909817.1903724335 4213546.921284895, 1909816.9287156868 4213544.930798555, 1909801.01 4213544.47, 1909783.64 4213543.93, 1909770.47 4213539.29))','ZO32548','"lib_modif"=>"N", "lib_code_insee"=>"38436 / 38524", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UD3','Pavillonnaire en évolution modérée','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD3.pdf','2019-12-20','SRID=3945;POLYGON ((1910602.19 4221359.8, 1910602.22 4221362.32, 1910602.81 4221369.54, 1910632.5063885455 4221378.124682981, 1910633.82 4221382.9, 1910646.92 4221403.32, 1910646.9199994544 4221403.320002214, 1910646.9199999298 4221403.320002117, 1910649.01999993 4221405.110002116, 1910649.03999993 4221407.400002118, 1910649.08999993 4221408.900002118, 1910649.23999993 4221409.930002116, 1910649.32999993 4221411.880002118, 1910649.53999993 4221414.340002118, 1910649.9799999301 4221417.350002116, 1910650.80999993 4221423.710002117, 1910651.27999993 4221425.890002117, 1910651.83999993 4221427.840002118, 1910653.88999993 4221433.330002117, 1910655.6999999299 4221437.550002118, 1910659.2499999302 4221444.930002116, 1910664.79999993 4221456.410002117, 1910667.78999993 4221463.020002118, 1910668.02999993 4221463.480002117, 1910671.35999993 4221470.730002117, 1910674.75999993 4221479.090002117, 1910678.7099999299 4221487.980002117, 1910682.58999993 4221497.110002118, 1910685.46999993 4221503.750002117, 1910687.36999993 4221508.290002117, 1910688.8699999303 4221512.890002117, 1910689.4199999298 4221515.660002118, 1910689.9299999299 4221518.230002118, 1910690.12999993 4221519.750002118, 1910690.1899999299 4221521.460002117, 1910690.36999993 4221523.860002116, 1910690.29999993 4221525.600002117, 1910690.14999993 4221527.020002117, 1910689.80999993 4221528.630002118, 1910689.35999993 4221530.540002117, 1910688.90999993 4221531.820002118, 1910688.24999993 4221532.920002118, 1910687.4599999299 4221533.840002118, 1910686.1999999299 4221535.000002116, 1910684.6699999298 4221535.700002117, 1910683.3899999303 4221536.170002116, 1910683.27999993 4221537.740002117, 1910666.79999993 4221538.8500021165, 1910669.4999999302 4221546.810002117, 1910674.90999993 4221563.160002116, 1910681.79999993 4221583.190002116, 1910686.4299999299 4221597.440002118, 1910687.57999993 4221601.390002116, 1910687.6999999299 4221613.920002116, 1910687.89999993 4221618.870002116, 1910689.72999993 4221626.670002116, 1910695.78999993 4221649.330002116, 1910701.1899999299 4221670.570002115, 1910704.09999993 4221681.660002116, 1910706.4299999299 4221690.470002115, 1910706.93999993 4221692.090002116, 1910722.9599999299 4221688.140002115, 1910734.64999993 4221685.120002116, 1910742.3699999303 4221683.120002116, 1910774.61999993 4221674.760002117, 1910782.79999993 4221672.680002116, 1910792.73999993 4221670.160002116, 1910803.76999993 4221667.510002117, 1910806.85999993 4221666.750002116, 1910813.31999993 4221664.990002117, 1910816.64999993 4221664.080002116, 1910828.35999993 4221661.020002117, 1910830.1999999299 4221660.540002116, 1910829.99 4221662.3, 1910829.07 4221668.86, 1910828.33 4221672.66, 1910827.6 4221675.17, 1910825.91 4221680.37, 1910823.39 4221686.66, 1910820.72 4221693.71, 1910817.23 4221702.69, 1910814.36 4221709.99, 1910812.27 4221716.24, 1910811.29 4221719.84, 1910810.3 4221724.31, 1910809.29 4221729.12, 1910808.69 4221733.3, 1910807.72 4221740.19, 1910806.66 4221750.35, 1910806.36 4221757.4, 1910805.79 4221767.05, 1910805.35 4221777.84, 1910804.75 4221791.8, 1910803.9 4221809.47, 1910803.2 4221821.13, 1910803.09 4221824.02, 1910803.02 4221826.1, 1910802.73 4221830.57, 1910802.66 4221832.08, 1910802.46 4221836.36, 1910802.3653522267 4221838.395961059, 1910803.7509695492 4221838.71154673, 1910852.965244661 4221850.228601933, 1910864.2966288426 4221853.091587175, 1910895.207544525 4221860.901532896, 1910903.202660431 4221841.498674465, 1910904.0339271254 4221838.867532895, 1910904.1176968638 4221838.6877772445, 1910905.8129738073 4221835.080087465, 1910906.8472988275 4221832.286031202, 1910908.7769274344 4221827.032263605, 1910910.5944084805 4221822.833988939, 1910914.5884319085 4221814.315633229, 1910915.1822170217 4221813.096700044, 1910917.801323911 4221807.72763353, 1910919.9057682478 4221803.017522696, 1910920.7856138565 4221800.469942264, 1910921.4010785068 4221798.736862431, 1910922.95 4221792.26, 1910923.4867560093 4221790.537950115, 1910924.1612210723 4221788.65961513, 1910926.3419246548 4221785.233263708, 1910932.620821843 4221774.977798049, 1910937 4221774.75, 1910936.2 4221764.48, 1910934.88 4221748.21, 1910934.12 4221738.85, 1910934.08999993 4221730.180002116, 1910933.1699999296 4221719.510002118, 1910933.10999993 4221715.2700021155, 1910932.96999993 4221706.710002118, 1910933.14999993 4221704.900002117, 1910934.40999993 4221691.600002116, 1910935.79999993 4221679.250002118, 1910936.60999993 4221670.990002116, 1910936.86999993 4221668.3500021165, 1910937.4499999299 4221662.8900021175, 1910937.72999993 4221661.780002117, 1910938.4199999298 4221657.870002115, 1910938.50999993 4221657.400002115, 1910939.53999993 4221653.930002116, 1910940.31999993 4221651.830002116, 1910940.48999993 4221651.350002116, 1910941.30999993 4221648.830002118, 1910942.84999993 4221645.360002116, 1910945.87999993 4221636.830002118, 1910995.05999993 4221616.980002117, 1911048.97999993 4221593.520002117, 1911067.81999993 4221593.180002117, 1911084.3999999298 4221601.080002117, 1911092.4981883042 4221607.511133902, 1911094.1024830663 4221576.758505478, 1911087.26999993 4221550.230002118, 1911074.29999993 4221507.370002116, 1911069.7899999297 4221499.130002117, 1911057.06999993 4221479.280002118, 1911029.304965325 4221436.273182856, 1911029.28999993 4221436.250002116, 1910985.60999993 4221373.4300021175, 1910962.14999993 4221340.040002118, 1910931.759437099 4221301.655187996, 1910921.59 4221301.88, 1910920.98 4221301.89, 1910920.02 4221301.78, 1910919.97 4221301.77, 1910919.21 4221301.57, 1910917.97 4221301.17, 1910916.19 4221300.58, 1910916.02 4221300.51, 1910914.06 4221299.65, 1910912.36 4221298.81, 1910910.79 4221297.93, 1910909.79 4221297.34, 1910909.04 4221296.8, 1910908.63 4221296.47, 1910907.71 4221295.63, 1910906.83 4221294.49, 1910906.26 4221293.75, 1910905.33 4221292.58, 1910904.6 4221291.64, 1910903.76 4221290.59, 1910903.24 4221290.01, 1910902.73 4221289.55, 1910902.3 4221289.23, 1910901.68 4221288.86, 1910901.47 4221288.76, 1910900.79 4221288.51, 1910900.7 4221288.48, 1910899.76 4221288.35, 1910899.46 4221288.32, 1910898.46 4221288.19, 1910897.73 4221288.08, 1910897.29 4221288, 1910896.84 4221287.88, 1910896.7 4221287.82, 1910895.1 4221287.15, 1910894.63 4221286.85, 1910893.57 4221286.31, 1910892.74 4221285.8, 1910891.55 4221285.18, 1910891 4221284.94, 1910889.23 4221284.15, 1910887.39 4221283.24, 1910887.14 4221283.1, 1910886.22 4221282.44, 1910885.81 4221282.08, 1910885.35 4221281.55, 1910885.3 4221281.46, 1910884.86 4221280.55, 1910884.28 4221279.21, 1910884.19 4221279.03, 1910883.91 4221278.52, 1910883.29 4221277.42, 1910883.19 4221277.31, 1910882.11 4221276.24, 1910880.47 4221274.75, 1910880.3 4221274.62, 1910879.57 4221274.12, 1910879.15 4221273.87, 1910878.08 4221273.38, 1910877.91 4221273.29, 1910876.91 4221272.81, 1910876.58 4221272.67, 1910876.15 4221272.47, 1910875.63 4221272.12, 1910875.43 4221271.9, 1910875.32 4221271.76, 1910874.86 4221271.24, 1910874.55 4221270.84, 1910873.48 4221269.62, 1910873.43 4221269.57, 1910872.78 4221269.13, 1910871.09 4221268.5, 1910869.89 4221268.06, 1910867.79 4221267.46, 1910866.51 4221267.05, 1910864.84 4221266.56, 1910863.53 4221266.07, 1910860.36 4221264.68, 1910860.22 4221264.62, 1910858.71 4221263.99, 1910857.51 4221263.46, 1910855.69 4221262.59, 1910855.29 4221262.4, 1910853.52 4221261.53, 1910853.4 4221261.46, 1910850.67 4221259.8, 1910849.59 4221259.13, 1910847.69 4221257.9, 1910845.82 4221256.69, 1910844.37 4221255.77, 1910843.92 4221255.43, 1910843.82 4221255.42, 1910843.09 4221255.01, 1910842.5 4221254.83, 1910842.12 4221254.66, 1910841.17 4221254.33, 1910840.48 4221254.12, 1910839.9 4221253.95, 1910839.49 4221253.86, 1910838.22 4221253.68, 1910837.06 4221253.62, 1910836.53 4221253.61, 1910835.43 4221253.54, 1910834.12 4221253.38, 1910833.1 4221253.06, 1910832.66 4221252.91, 1910831.93 4221252.55, 1910831.38 4221252.25, 1910830.68 4221251.8, 1910830.09 4221251.34, 1910829.3 4221250.68, 1910828.66 4221250.14, 1910827.81 4221249.29, 1910827.14 4221248.57, 1910826.49 4221247.79, 1910825.85 4221246.79, 1910825 4221244.79, 1910823.58 4221241.45, 1910819.63 4221231.67, 1910818.18 4221227.38, 1910817.95 4221226.52, 1910817.8 4221225.7, 1910817.7 4221224.97, 1910817.6 4221223.82, 1910817.53 4221222.85, 1910817.47 4221221.74, 1910817.42 4221220.94, 1910817.3 4221219.53, 1910816.8 4221218.6, 1910816.44 4221217.93, 1910816.43 4221217.9, 1910806.46 4221211.79, 1910805.47 4221210.09, 1910805.46 4221209.24, 1910805.45 4221208.03, 1910805.42 4221202.05, 1910805.44 4221199.36, 1910805.53 4221189.98, 1910805.47 4221186.43, 1910804.57 4221186.13, 1910801.63 4221185.11, 1910784.88 4221179.34, 1910759.66 4221170.41, 1910755 4221168.76, 1910752.65 4221167.94, 1910735.59 4221161.99, 1910733.9 4221161.4, 1910722.97 4221157.59, 1910716.81 4221155.48, 1910712.18 4221153.89, 1910708.18 4221152.52, 1910705.8821124705 4221151.717503519, 1910694.450543087 4221186.036375956, 1910690.6351421273 4221198.428546014, 1910687.292724758 4221209.370233063, 1910684.7701456111 4221217.221760658, 1910682.6259533365 4221224.379578986, 1910679.945712993 4221232.010380905, 1910676.5796464456 4221231.513748135, 1910675.7834574024 4221231.2851394005, 1910675.0109175383 4221230.780623572, 1910671.006323143 4221226.523771262, 1910668.010760406 4221222.929095978, 1910659.465523546 4221215.928938844, 1910649.2175457622 4221208.392733644, 1910645.7489994352 4221205.68096106, 1910642.816501177 4221204.703461641, 1910639.0326324566 4221204.041284615, 1910620.9961915568 4221205.050316274, 1910606.7751516171 4221206.185476891, 1910585.0809709544 4221207.888217815, 1910579.8150869855 4221209.023378431, 1910578.124217592 4221208.587969949, 1910575.5766689742 4221205.975099572, 1910568.5872407153 4221203.88480327, 1910561.0099166213 4221203.100942156, 1910550.035861037 4221204.211412067, 1910531.4191595993 4221208.130717632, 1910515.676615577 4221211.331483845, 1910502.5469419314 4221213.944354221, 1910484.8447451259 4221216.622546358, 1910467.5998006363 4221218.451555622, 1910455.2539881042 4221219.039451458, 1910442.4509232556 4221219.2354167355, 1910427.2309533085 4221218.908807938, 1910420.8947426437 4221217.079798674, 1910419.1583275727 4221213.973940005, 1910425.212517525 4221202.622333843, 1910442.3660557233 4221175.000092186, 1910457.753788519 4221148.5130111445, 1910473.7721661008 4221127.575604226, 1910488.4031251525 4221110.295937071, 1910501.6466656732 4221093.142398872, 1910511.7369822604 4221077.12402129, 1910519.3047197012 4221059.08758039, 1910527.043437104 4221035.324492616, 1910539.74999993 4220992.20000212, 1910556.5758265953 4220962.252073391, 1910570.498699513 4220938.233730868, 1910565.2569905662 4220935.91792667, 1910564.1081362597 4220935.410359071, 1910562.3271258336 4220934.623502825, 1910561.76999993 4220923.830002119, 1910558.29999993 4220924.140002118, 1910531.89999993 4220921.500002119, 1910529.03999993 4220936.120002119, 1910523.0999999302 4220935.170002118, 1910513.51999993 4220933.640002119, 1910512.80999993 4220939.280002119, 1910506.31999993 4220938.53000212, 1910504.52999993 4220938.320002119, 1910503.14 4220948.24, 1910498.68 4220947.56, 1910489.56 4220946.16, 1910470.56 4220943.26, 1910465.55999993 4220942.520002121, 1910465.74999993 4220941.160002119, 1910467.04999993 4220931.59000212, 1910431.7999999302 4220928.4300021175, 1910421.5799999302 4220927.460002116, 1910416.3399999302 4220927.290002119, 1910413.4023459528 4220927.2676864, 1910417.3007534568 4220890.4733551545, 1910419.9199999298 4220890.89000212, 1910420.159326216 4220890.923139606, 1910451.11999993 4220895.210002119, 1910479.40999993 4220896.490002119, 1910501.7290072083 4220897.9737366885, 1910502.8979836975 4220898.135773034, 1910511.097584027 4220900.468992639, 1910511.29999993 4220898.610002119, 1910511.6399999303 4220895.800002119, 1910513.52999993 4220879.960002118, 1910513.94 4220879.91, 1910519.63 4220879.93, 1910524.47 4220879.96, 1910526.77 4220879.97, 1910527.81 4220880.07, 1910529.34 4220880.23, 1910532.69 4220880.57, 1910536.55 4220880.96, 1910538.19 4220880.96, 1910540.06 4220880.98, 1910541.02 4220880.99, 1910545 4220881.1, 1910553.18 4220881.33, 1910554.03 4220881.42, 1910555.39 4220881.48, 1910557.08 4220881.6, 1910557.16 4220880.67, 1910557.2 4220880.22, 1910558.37 4220880.35, 1910559.46 4220880.46, 1910560.32 4220880.56, 1910559.64 4220883.81, 1910570.33 4220884.24, 1910575.67 4220885.25, 1910577.99 4220885.69, 1910579.85 4220886.04, 1910580.02 4220884.53, 1910580.73 4220884.63, 1910581.79 4220884.8, 1910581.65 4220886.16, 1910581.41 4220888.41, 1910591.340586165 4220890.848154668, 1910592.57 4220891.15, 1910597.765644071 4220892.397821183, 1910599.6266022203 4220889.26953853, 1910612.509307616 4220867.287276672, 1910618.9756590954 4220855.954495729, 1910615.3827135826 4220853.358863575, 1910605.09999993 4220846.46000212, 1910557.9399999299 4220785.690002118, 1910558.46999993 4220777.180002118, 1910558.5399999302 4220770.540002117, 1910573.90999993 4220763.520002119, 1910587.85999993 4220757.13000212, 1910583.72999993 4220743.28000212, 1910580.33999993 4220731.870002121, 1910580.14999993 4220731.210002121, 1910579.31999993 4220728.280002118, 1910574.9199999298 4220712.79000212, 1910570.37999993 4220696.77000212, 1910569.31999993 4220693.08000212, 1910568.50999993 4220690.28000212, 1910579.55999993 4220687.910002119, 1910581.40999993 4220696.910002118, 1910582.49999993 4220696.680002119, 1910595.1699999298 4220694.110002119, 1910604.52999993 4220692.20000212, 1910609.6999999299 4220691.150002118, 1910615.01999993 4220690.050002118, 1910620.74999993 4220688.86000212, 1910624.07999993 4220688.170002119, 1910625.30999993 4220687.920002119, 1910627.98999993 4220687.360002121, 1910643.85999993 4220684.0500021195, 1910646.90999993 4220699.830002121, 1910647.46999993 4220702.610002121, 1910650.4599999299 4220717.67000212, 1910651.1999999299 4220721.38000212, 1910652.64999993 4220728.720002119, 1910653.4299999299 4220732.590002118, 1910655.1799999299 4220741.2200021185, 1910661.78999993 4220773.940002118, 1910668.91 4220764.21, 1910670.57 4220762.24, 1910672.68 4220759.97, 1910674.91 4220758.06, 1910676.99 4220756.39, 1910677.94 4220755.82, 1910679.06 4220755.22, 1910680.68 4220754.46, 1910680.17 4220751.89, 1910682.28 4220750.55, 1910686.2 4220748.07, 1910690.1 4220746.49, 1910692.14 4220745.92, 1910694.21 4220745.52, 1910696.3 4220745.29, 1910700.33 4220745.31, 1910703.79 4220745.86, 1910710.68 4220747.64, 1910717.57 4220749.49, 1910724.59999993 4220751.520002119, 1910762.1899999296 4220750.83000212, 1910766.08999993 4220763.860002119, 1910772.9399999299 4220762.32000212, 1910800.53999993 4220757.620002118, 1910821.40999993 4220754.240002118, 1910828.4499999299 4220766.790002118, 1910832.2099999299 4220773.48000212, 1910835.54999993 4220779.340002118, 1910837.13999993 4220782.140002117, 1910839.6599999298 4220786.54000212, 1910845.84999993 4220791.550002119, 1910853.28999993 4220797.890002119, 1910853.57999993 4220798.120002118, 1910867.33999993 4220809.380002119, 1910882.24999993 4220821.630002118, 1910883.0799999298 4220822.310002118, 1910902.09999993 4220837.850002118, 1910918.61999993 4220851.430002116, 1910920.54999993 4220853.020002119, 1910923.26999993 4220855.280002118, 1910923.5599999297 4220855.21000212, 1910927.7599999297 4220854.61000212, 1910930.5199999297 4220854.2600021195, 1910930.54999993 4220854.250002118, 1910933.4599999296 4220853.89000212, 1910943.49999993 4220852.570002119, 1910943.52999993 4220852.560002119, 1910948.7096840905 4220851.90131396, 1910948.71999993 4220851.900002119, 1910952.4499999299 4220851.430002118, 1910953.89999993 4220851.230002119, 1910953.90999993 4220851.230002118, 1910959.7499999297 4220850.470002119, 1910961.57999993 4220850.240002117, 1910961.58999993 4220850.230002119, 1910965.9399999296 4220849.660002121, 1910977.74999993 4220848.120002119, 1910977.83999993 4220848.070002119, 1910978.3899999298 4220845.15000212, 1910978.39000032 4220845.150000038, 1910979.09999993 4220841.360002118, 1910980.25999993 4220835.6000021165, 1910981.4599999296 4220831.20000212, 1910982.48999993 4220827.420002119, 1910983.4199999298 4220824.190002119, 1910984.48999993 4220820.560002119, 1910985.6199999298 4220816.67000212, 1910985.7599999297 4220816.290002119, 1910985.7599999297 4220816.280002119, 1910986.0399999297 4220815.69000212, 1910987.9199999296 4220811.310002119, 1910988.83999993 4220809.160002119, 1910988.84999993 4220809.140002118, 1910985.4299999296 4220806.39000212, 1910985.3499999298 4220806.34000212, 1910986.1599999298 4220804.000002119, 1910987.6199999298 4220799.790002118, 1910988.7295686528 4220797.131495837, 1910993.6236793983 4220800.709751419, 1911000.274842189 4220805.706079449, 1911016.6322473297 4220818.435577612, 1911025.7338385172 4220827.346226327, 1911032.16223509 4220834.53839279, 1911035.981084539 4220852.614280183, 1911038.0178042452 4220856.369482141, 1911042.1548911487 4220853.759935018, 1911048.9651726664 4220850.577560476, 1911065.3862252978 4220844.594696339, 1911076.5245361917 4220840.77584689, 1911083.2711702187 4220838.166299767, 1911090.892503823 4220834.784700298, 1911090.3499999298 4220837.940002118, 1911090.2899999297 4220838.530002119, 1911087.0199999297 4220868.09000212, 1911086.7099999296 4220868.040002118, 1911086.08999993 4220873.820002119, 1911073.9200020912 4220872.190002407, 1911073.92 4220872.19, 1911067.11 4220871.38, 1911057.33 4220869.92, 1911049.82 4220869.68, 1911041.52 4220868.83, 1911030.84 4220867.74, 1911027.3819608283 4220866.932225918, 1911023.4310802235 4220871.803244221, 1911018.7628288271 4220879.265590072, 1911011.866135276 4220893.8589747, 1911005.1614590986 4220906.219830367, 1910999.5555076678 4220915.880753689, 1910995.6362021018 4220921.931387779, 1910991.4639808412 4220928.831204742, 1910994.63 4220930.26, 1911001.83 4220933.05, 1911001.71 4220933.35, 1911007.15 4220935.47, 1911006.06 4220939.08, 1911005.22 4220941.75, 1911002.1 4220951.59, 1910999.56 4220960.14, 1910998.591173521 4220963.187619048, 1911026.8199999298 4220967.300822194, 1911049.0821296729 4220970.615412156, 1911080.47999993 4220979.370002118, 1911078.71999993 4220984.430002118, 1911077.29999993 4220990.340002118, 1911076.4399999299 4220993.980002118, 1911074.9499999296 4221000.210002119, 1911071.1799999299 4221015.980002119, 1911067.99999993 4221015.340002117, 1911059.6399999298 4221013.640002118, 1911042.15999993 4221010.100002117, 1911042.08999993 4221010.510002117, 1911041.04999993 4221010.280002119, 1911034.7299999297 4221008.950002119, 1911030.81999993 4221008.130002118, 1911026.2099999296 4221007.160002118, 1911026.09999993 4221008.090002117, 1911025.9199999296 4221009.810002119, 1911025.75999993 4221011.250002119, 1911011.7699999297 4221010.100002118, 1911001.71999993 4221009.290002118, 1911001.9799999297 4221006.720002119, 1911002.1699999296 4221004.800002118, 1910988.01999993 4221003.550002117, 1910977.7699999297 4221002.65000212, 1910976.6799999299 4221016.500002119, 1910975.6799999299 4221029.400002118, 1910970.6099999298 4221028.970002119, 1910970.56999993 4221029.350002118, 1910970.1999999299 4221034.030002119, 1910969.6799999299 4221040.880002119, 1910969.25999993 4221046.17000212, 1910968.9399999296 4221050.350002117, 1910968.75999993 4221052.690002117, 1910969.5399999297 4221052.750002119, 1910971.6599999298 4221052.900002119, 1910971.51999993 4221055.060002117, 1910971.34999993 4221057.730002118, 1910964.25999993 4221057.36000212, 1910963.40999993 4221070.100002117, 1910964.0799999298 4221070.160002118, 1910966.98999993 4221070.4300021175, 1910969.79999993 4221070.700002118, 1910968.65999993 4221082.12000212, 1910967.40999993 4221094.640002117, 1910987.8762456463 4221096.51965732, 1910987.87999993 4221096.52000212, 1910989.77 4221096.68, 1911012.2600000002 4221098.569999994, 1911014.0055741223 4221098.703342465, 1911014.252720818 4221093.9576138295, 1911016.15 4221094.59, 1911041.23 4221102.06, 1911051.41 4221105.1, 1911059.17 4221107.41, 1911070.91 4221110.82, 1911074.37 4221111.81, 1911088.17 4221115.83, 1911091.4 4221116.76, 1911109.55 4221122.29, 1911109.78 4221121.34, 1911112.74 4221108.74, 1911115.6 4221096.12, 1911117.9 4221086.1, 1911118.89 4221081.9, 1911119.8 4221078.09, 1911120.05 4221077.06, 1911124.08 4221060.17, 1911124.73 4221057.42, 1911129.27 4221037.97, 1911129.76 4221035.86, 1911130.13 4221034.34, 1911131.56 4221028.26, 1911132.3 4221025.15, 1911132.98 4221022.3, 1911133.12 4221021.68, 1911133.36 4221020.64, 1911134.21 4221016.83, 1911136.28 4221007.43, 1911137.4630402408 4221003.710441276, 1911148.49999993 4221007.730002117, 1911231.0767799544 4221027.008068261, 1911244.9454209828 4221031.290472795, 1911245.553728314 4221031.478307931, 1911271.05929993 4221039.354002119, 1911285.47159993 4221043.644202116, 1911300.5838999297 4221047.133002116, 1911304.1976363878 4221047.615155023, 1911317.450649928 4221049.383402118, 1911342.7912953305 4221049.203399787, 1911345.3883499296 4221049.184952116, 1911382.7220881113 4221055.05305531, 1911384.7416143073 4221055.351336794, 1911439.1215380519 4221063.09918674, 1911441.9899999297 4221025.700002119, 1911457.9799999297 4221026.240002119, 1911489.6099999298 4221029.290002119, 1911503.9799999297 4221033.4300021175, 1911521.4099999298 4221041.690002119, 1911522.611551301 4221042.3629625505, 1911537.1399999298 4221050.500002119, 1911537.9099999298 4221047.300002118, 1911538.0299999297 4221046.670002116, 1911544.4399999296 4221047.460002118, 1911550.4099999298 4221048.200002117, 1911553.1299999298 4221048.540002119, 1911560.9199999296 4221049.550002116, 1911566.6299999296 4221050.280002118, 1911568.7499999297 4221050.520002119, 1911574.8999999298 4221051.210002117, 1911580.6599999298 4221051.860002119, 1911588.8399999298 4221053.280002119, 1911596.5499999297 4221054.440002118, 1911597.4499999296 4221054.570002119, 1911599.5299999297 4221042.530002119, 1911599.7499999297 4221041.270002118, 1911601.5999999298 4221030.630002119, 1911603.1599999298 4221021.660002121, 1911631.7799999297 4221023.300002119, 1911631.1199999298 4221036.290002118, 1911630.5299999297 4221047.920002116, 1911630.4599999296 4221049.32000212, 1911630.0399999297 4221056.960002118, 1911629.7499999295 4221062.400002119, 1911629.1799999296 4221072.770002118, 1911628.8399999298 4221080.710002119, 1911628.802836808 4221081.546172356, 1911628.7599999295 4221082.510002119, 1911628.71750574 4221083.143664464, 1911628.6315719904 4221083.239513647, 1911604.7593863609 4221081.696053368, 1911604.4999999297 4221083.990002118, 1911603.2999999297 4221092.000002118, 1911602.4299999296 4221097.730002116, 1911601.1699999296 4221106.100002118, 1911600.2899999297 4221111.980002119, 1911591.1699999296 4221115.100002118, 1911587.6499999298 4221130.040002117, 1911576.7399999294 4221126.78000212, 1911575.2599999297 4221139.120002117, 1911575.0899999298 4221149.280002118, 1911575.0399999297 4221152.140002119, 1911575.8299999298 4221161.730002118, 1911576.2299999297 4221165.9300021175, 1911576.3099999297 4221172.080002119, 1911576.4999999297 4221179.560002117, 1911576.6399999298 4221185.290002119, 1911576.3099999297 4221189.990002116, 1911599.8599999298 4221201.730002117, 1911611.4 4221164.45, 1911612.7799999297 4221160.320002117, 1911646.41 4221171.32, 1911677.36 4221181.32, 1911679.7799999295 4221182.110002118, 1911683.6099999298 4221177.740002119, 1911687.7999999297 4221170.040002118, 1911696.9999999295 4221152.530002118, 1911700.5099999295 4221140.42000212, 1911700.9199999296 4221140.770002118, 1911701.3999999298 4221141.100002117, 1911701.9199999296 4221141.380002118, 1911702.4599999296 4221141.630002118, 1911702.9999999297 4221141.840002116, 1911703.5699999295 4221141.990002118, 1911704.1399999298 4221142.110002118, 1911704.7299999294 4221142.180002118, 1911705.3099999297 4221142.210002119, 1911705.8999999298 4221142.180002117, 1911707.0299999295 4221142.0100021195, 1911718.3199999298 4221148.260002117, 1911722.2399999294 4221142.820002119, 1911723.0299999297 4221141.740002119, 1911729.9999999297 4221132.1800021175, 1911737.5699999298 4221116.810002118, 1911749.6199999298 4221091.740002118, 1911752.6499999296 4221085.150002121, 1911750.8099999297 4221084.810002118, 1911751.2699999295 4221081.92000212, 1911752.0499999297 4221077.000002117, 1911752.2599999295 4221075.710002119, 1911753.0599999295 4221070.81000212, 1911756.4799999297 4221049.950002118, 1911757.6899999294 4221042.780002119, 1911762.3399999295 4221014.960002119, 1911763.9599999296 4221003.300002118, 1911741.2999999297 4220995.110002117, 1911737.8999999296 4220993.83000212, 1911766.1199999298 4220868.170002118, 1911746.1899999296 4220864.170002118, 1911727.5399999295 4220860.66000212, 1911687.8699999298 4220854.440002118, 1911671.0199999295 4220852.2600021195, 1911648.8599999298 4220849.350002118, 1911616.3199999298 4220849.510002118, 1911600.3099999297 4220852.400002119, 1911563.3999999298 4220864.890002119, 1911558.1999999294 4220866.350002119, 1911574.1599999298 4220846.240002118, 1911586.0499999295 4220837.45000212, 1911597.1299999296 4220831.220002119, 1911586.7099999296 4220831.4700021185, 1911576.0799999298 4220830.980002119, 1911561.5999999298 4220830.140002119, 1911553.6799999294 4220829.780002119, 1911546.76 4220829.13, 1911545.8199999298 4220828.980002119, 1911542.89 4220828.55, 1911537.7599999295 4220827.560002119, 1911532.26 4220826.25, 1911531.5699999298 4220826.030002119, 1911527.61 4220824.74, 1911523.9099999298 4220823.410002118, 1911520.5999999298 4220822.010002119, 1911517.6799999296 4220820.520002118, 1911512.9999999297 4220818.10000212, 1911501.4299999294 4220810.580002119, 1911483.6099999298 4220841.580002119, 1911450.4599999296 4220793.370002119, 1911450.3599999298 4220792.550002119, 1911450.2599999295 4220792.08000212, 1911449.9199999296 4220790.440002118, 1911449.8299999298 4220789.370002119, 1911449.8199999298 4220788.300002119, 1911449.8899999296 4220787.23000212, 1911450.0499999297 4220786.160002119, 1911450.2999999297 4220785.120002118, 1911450.6199999298 4220784.09000212, 1911451.0199999295 4220783.09000212, 1911451.8499999295 4220781.540002121, 1911452.3599999298 4220780.770002119, 1911452.6399999296 4220780.400002121, 1911452.9299999296 4220780.040002121, 1911453.2199999294 4220779.690002121, 1911453.5299999297 4220779.340002117, 1911453.8499999298 4220779.0100021195, 1911454.1899999296 4220778.700002121, 1911454.5199999297 4220778.39000212, 1911454.8699999298 4220778.080002118, 1911455.2299999297 4220777.790002118, 1911455.5999999298 4220777.52000212, 1911456.3399999295 4220777.00000212, 1911449.9199999294 4220766.89000212, 1911449.3999999298 4220766.080002118, 1911440.1099999298 4220751.96000212, 1911437.2399999297 4220747.610002118, 1911433.5899999298 4220741.980002117, 1911427.7799999297 4220733.000002118, 1911424.2399999297 4220727.550002119, 1911414.2799999297 4220711.920002118, 1911412.7799999297 4220710.140002118, 1911401.0599999297 4220695.0500021195, 1911388.8499999298 4220679.160002121, 1911384.9299999296 4220674.03000212, 1911382.8999999298 4220671.640002119, 1911381.3099999297 4220670.100002119, 1911379.9999999297 4220669.050002118, 1911378.6199999298 4220668.100002118, 1911377.1699999296 4220667.27000212, 1911375.6499999298 4220666.5500021195, 1911372.4799999297 4220665.490002118, 1911370.8299999298 4220665.080002119, 1911369.3799999298 4220664.850002118, 1911367.9099999298 4220664.740002118, 1911366.4399999296 4220664.740002119, 1911364.9699999297 4220664.860002119, 1911363.8999999298 4220665.03000212, 1911363.5099999297 4220665.090002119, 1911362.0899999298 4220665.440002119, 1911360.6799999296 4220665.900002118, 1911359.3199999298 4220666.460002121, 1911358.0099999297 4220667.140002119, 1911356.7499999297 4220667.910002119, 1911354.4399999296 4220669.74000212, 1911352.1199999298 4220671.790002121, 1911341.0999999298 4220682.650002118, 1911335.8699999298 4220687.75000212, 1911325.7899999297 4220697.540002119, 1911319.5999999298 4220703.540002118, 1911318.6899999296 4220704.430002121, 1911317.7699999297 4220705.31000212, 1911313.3299999298 4220709.610002121, 1911311.6299999298 4220711.320002119, 1911309.0799999298 4220713.870002121, 1911304.9499999296 4220718.04000212, 1911302.1999999296 4220721.16000212, 1911299.9299999299 4220723.870002119, 1911297.3199999298 4220726.920002119, 1911295.7699999297 4220729.160002118, 1911293.9299999296 4220732.010002119, 1911292.4899999297 4220734.490002119, 1911290.9599999296 4220737.62000212, 1911289.7099999296 4220740.330002119, 1911288.8399999298 4220742.390002119, 1911288.0499999297 4220744.4700021185, 1911287.3099999297 4220746.58000212, 1911286.6499999298 4220748.710002118, 1911285.5099999297 4220753.03000212, 1911284.6299999298 4220757.790002119, 1911284.3399999298 4220760.760002119, 1911284.1499999298 4220764.440002119, 1911284.0599999297 4220768.810002118, 1911284.0699999298 4220772.060002119, 1911283.7799999297 4220775.320002119, 1911283.5299999297 4220778.610002119, 1911282.9899999297 4220782.16000212, 1911282.3299999298 4220784.89000212, 1911281.4499999296 4220787.56000212, 1911280.3699999298 4220790.160002121, 1911279.3699999298 4220792.120002121, 1911279.0899999298 4220792.650002119, 1911275.9599999296 4220797.32000212, 1911273.6799999296 4220800.2200021185, 1911271.7299999297 4220802.31000212, 1911269.6099999298 4220804.23000212, 1911267.3499999298 4220805.980002119, 1911264.9699999297 4220807.550002119, 1911262.7899999297 4220808.740002118, 1911257.1699999296 4220811.06000212, 1911254.3399999298 4220811.860002118, 1911250.3599999298 4220812.820002121, 1911248.7199999297 4220813.190002119, 1911235.8599999298 4220811.870002119, 1911222.8499999298 4220808.040002119, 1911212.0199999297 4220801.340002117, 1911203.5299999297 4220792.730002119, 1911200.3399999298 4220787.840002119, 1911199.7899999297 4220786.81000212, 1911198.6999999296 4220784.180002118, 1911197.9999999297 4220782.3000021195, 1911197.3699999298 4220780.390002118, 1911196.7899999297 4220778.470002119, 1911196.2799999297 4220776.520002118, 1911195.8299999298 4220774.56000212, 1911195.10999993 4220770.620002117, 1911196.5299999297 4220768.820002118, 1911210.7399999297 4220763.940002119, 1911205.5999999298 4220743.240002121, 1911199.4999999297 4220718.67000212, 1911196.8099999297 4220707.84000212, 1911191.1799999296 4220692.01000212, 1911181.6999999296 4220651.380002118, 1911181.1894596135 4220649.845896789, 1911172.7 4220647.85, 1911172.41 4220647.78, 1911171.29 4220647.6, 1911170.1327230446 4220647.410446016, 1911169.87 4220641.65, 1911163.92 4220640.86, 1911138.57 4220615.7, 1911137.7 4220614.84, 1911132.52 4220608.87, 1911128.56 4220602.98, 1911124.77 4220596.83, 1911121.37 4220588.36, 1911119.43 4220580.9, 1911118.44 4220575.47, 1911103.82 4220570.02, 1911097.16 4220587.71, 1911100.59 4220602.29, 1911102.48 4220609.62, 1911109.36 4220618.9, 1911113.23 4220623.94, 1911114.65 4220626.18, 1911119.53 4220639.13, 1911119.5300023258 4220639.130002508, 1911119.5299999297 4220639.130002119, 1911116.6199999298 4220639.30000212, 1911113.7499999297 4220662.990002118, 1911128.2199999297 4220665.280002119, 1911136.26999993 4220666.550002118, 1911141.2999999297 4220667.360002121, 1911138.2499999297 4220682.59000212, 1911152.3199999298 4220685.94000212, 1911148.4899999297 4220694.170002119, 1911147.5899999298 4220696.08000212, 1911148.1699999296 4220709.460002118, 1911148.8399999298 4220724.59000212, 1911149.0199999297 4220732.740002119, 1911149.02 4220733.02, 1911148.69 4220733.63, 1911147.37 4220736.11, 1911146.68 4220737.39, 1911145.75 4220739.08, 1911145.095822196 4220740.201829421, 1911139.5999999298 4220750.260002118, 1911138.8499999298 4220750.18000212, 1911137.5199999297 4220750.380002119, 1911136.2599999297 4220750.850002118, 1911133.4099999298 4220751.74000212, 1911130.0799999298 4220752.63000212, 1911125.4499999296 4220753.460002119, 1911121.56999993 4220753.99000212, 1911117.7799999297 4220754.03000212, 1911115.9599999296 4220753.8400021205, 1911114.3499999298 4220753.5900021205, 1911111.6299999298 4220753.660002119, 1911103.5999999298 4220754.630002119, 1911101.6199999298 4220754.880002118, 1911099.9199999296 4220755.12000212, 1911100.6199999298 4220755.960002119, 1911101.4399999296 4220757.610002121, 1911101.8199999298 4220758.24000212, 1911103.4499999296 4220760.150002118, 1911104.1299999298 4220760.640002118, 1911102.7299999297 4220763.44000212, 1911101.52999993 4220765.820002117, 1911092.8799999298 4220775.710002119, 1911079.9199999296 4220790.490002119, 1911078.46 4220792.17, 1911072.17 4220785.42, 1911056.23 4220768.05, 1911037.35 4220747.57, 1911027.84 4220737.82, 1911012.45 4220725.7, 1911003.220001142 4220718.700003039, 1911003.22 4220718.7, 1911001.1 4220711.93, 1910992.2 4220682.75, 1910991.54 4220680.59, 1910985.32 4220661.2, 1910984.01 4220657.6, 1910981.77 4220652.41, 1910979.84 4220648.45, 1910979.19 4220647.68, 1910972.06 4220643.03, 1910961.32 4220636.43, 1910958.44 4220634.67, 1910956.52339993 4220633.287602117, 1910954.1167999299 4220627.786402118, 1910949.80549993 4220617.684402118, 1910935.38129993 4220599.8862021165, 1910926.2679999298 4220590.388602119, 1910921.7579993953 4220587.713784498, 1910921.85 4220584.11, 1910921.63 4220576.96, 1910922.13 4220576.19, 1910922.9113170975 4220575.365810171, 1910920.5563599372 4220573.201795483, 1910917.373985396 4220571.037780795, 1910914.0006683827 4220567.9190537445, 1910909.4199999296 4220562.100002118, 1910906.9499999299 4220560.460002119, 1910902.7599999297 4220559.56000212, 1910891.7799999297 4220547.280002119, 1910888.2099999299 4220544.460002121, 1910883.3386621403 4220541.540748691, 1910882.5 4220542.39, 1910881.94 4220542.48, 1910873.06 4220543.82, 1910871.99 4220543.98, 1910851.62 4220546.99, 1910846.27 4220547.82, 1910839.21 4220548.27, 1910836.72 4220548.53, 1910829.86 4220549.77, 1910824.18 4220550.68, 1910812.26 4220552.69, 1910805.28 4220553.86, 1910795.26 4220435.9, 1910795.3031726745 4220435.468702947, 1910787.10999993 4220435.20000212, 1910773.7299999297 4220435.200002121, 1910734.46999993 4220433.93000212, 1910724.09999993 4220433.990002119, 1910719.97999993 4220433.960002119, 1910705.63999993 4220433.620002119, 1910697.6799999299 4220433.070002121, 1910679.89999993 4220434.37000212, 1910676.32999993 4220434.58000212, 1910666.1699999298 4220434.78000212, 1910655.53999993 4220434.920002121, 1910650.86999993 4220378.910002119, 1910642.62999993 4220329.770002121, 1910639.6992140024 4220316.852503201, 1910632.5200779147 4220285.21031406, 1910713.133704079 4220285.284970741, 1910713.03 4220272.16, 1910711.36 4220238.33, 1910701.97 4220207.14, 1910692.22 4220209.32, 1910689.44 4220209.93, 1910689.18 4220209.99, 1910682.5 4220211.48, 1910662.95 4220210.43, 1910659.97 4220210.27, 1910640.64 4220210.25, 1910621.79 4220210.99, 1910623.31 4220219.72, 1910607.79 4220223.5, 1910601.434237325 4220226.026687575, 1910596.50999993 4220213.640002119, 1910590.2731952756 4220184.210736365, 1910583.4340636875 4220164.29216083, 1910585.52999993 4220142.81000212, 1910584.3637605528 4220135.10477149, 1910575.09999993 4220073.900002121, 1910558.0618149454 4220002.998105765, 1910558.9321825358 4220002.770697795, 1910645.05 4219980.27, 1910643.81 4219975.6, 1910642.62 4219971.14, 1910635.43 4219944.17, 1910634.92 4219942.24, 1910624.71 4219903.98, 1910621.42 4219891.6, 1910614.8351041407 4219866.53373897, 1910629.01 4219862.81, 1910628.38999993 4219861.1700021215, 1910650.2099999296 4219855.440002123, 1910668.22999993 4219850.7100021215, 1910679.82999993 4219847.660002122, 1910680.2099999299 4219849.650002122, 1910690.08999993 4219847.110002122, 1910689.2499999297 4219824.600002121, 1910689.3847719533 4219822.5889921235, 1910689.39 4219822.59, 1910704.86 4219819.85, 1910707.3 4219819.11, 1910719.2 4219814.52, 1910721.63 4219815.34, 1910723.92 4219816.54, 1910724.34 4219816.94, 1910726.88 4219813.91, 1910734.2917976927 4219811.969854103, 1910740.4800011725 4219810.350002575, 1910725.79 4219776.3, 1910713.1 4219746.82, 1910710.9500965725 4219741.445591978, 1910678.71 4219746.62, 1910677.82 4219746.62, 1910676.07 4219736.67, 1910674.68 4219729.4, 1910673.15 4219722.24, 1910672.52 4219718.95, 1910672.14 4219716.88, 1910671.71 4219714.95, 1910670.7 4219710.04, 1910669.95 4219706.68, 1910669.71 4219705.89, 1910668.8 4219703.39, 1910667.67 4219700.18, 1910667.51 4219699.09, 1910666.85 4219695.21, 1910666.65 4219694.12, 1910666.42 4219693.35, 1910665.6 4219691.09, 1910664.75 4219688.45, 1910664.64 4219688.14, 1910664.35 4219687.35, 1910664.17 4219685.8, 1910663.26 4219681.8, 1910662.52 4219677.79, 1910661.76 4219673.28, 1910661.41 4219670.71, 1910661.37 4219669.4, 1910661.16 4219665.06, 1910660.94 4219660.51, 1910660.48 4219658.91, 1910659.33 4219654.32, 1910658.04 4219649.39, 1910655.48 4219640.65, 1910654.77 4219639.28, 1910653.84 4219637.36, 1910653.27 4219634.79, 1910652.45 4219632.13, 1910652.24 4219630.26, 1910652.05 4219628.73, 1910652.08 4219626.27, 1910652.39 4219618.76, 1910652.41 4219616.16, 1910652.42 4219615.51, 1910652.33 4219614.81, 1910652.12 4219613.89, 1910652 4219613.23, 1910651.71 4219612.58, 1910651.15 4219611.92, 1910650.79 4219611.44, 1910650.74 4219611.41, 1910650.12 4219610.95, 1910649.63 4219610.5, 1910648.49 4219610.08, 1910642.4887552913 4219611.165275463, 1910643.22 4219622.06, 1910644.49 4219640.21, 1910644.73 4219643.91, 1910644.94 4219650.04, 1910644.93 4219654.23, 1910644.91 4219655.35, 1910644.85 4219658.46, 1910644.3 4219662.27, 1910643.51 4219666.62, 1910641.46 4219677.63, 1910640.76 4219680.96, 1910639.14 4219687.48, 1910638.36 4219691.06, 1910636.56 4219696.98, 1910636.27 4219698, 1910635.15 4219701.91, 1910632.35 4219710.52, 1910631.22 4219714.12, 1910629.16 4219720.68, 1910626.11 4219730.15, 1910625.86 4219730.93, 1910621.97 4219742.6, 1910617.52 4219756.38, 1910617.28 4219757.15, 1910615.37 4219762.68, 1910614.34 4219765.67, 1910611.03 4219774.73, 1910610.06 4219777.26, 1910607.05 4219785.13, 1910602.56 4219798.18, 1910597.88 4219811.32, 1910595.54 4219816.6, 1910592.95 4219821.76, 1910592.81 4219822.03, 1910590.8 4219825.77, 1910588.94 4219828.85, 1910587.83 4219830.56, 1910585.13 4219834.12, 1910583.21 4219836.57, 1910581.08 4219838.74, 1910578.16 4219841.5, 1910576.58 4219842.97, 1910575.02 4219844.4, 1910573.06 4219845.8, 1910570.81 4219847.31, 1910569.23 4219848.37, 1910565.8 4219850.51, 1910563.55 4219851.7, 1910553.46 4219855.49, 1910540.24 4219860.41, 1910537.17 4219861.61, 1910536.5 4219861.88, 1910536.16 4219860.5, 1910534.62 4219854.13, 1910533.49 4219849.5, 1910533.0394198033 4219847.5487918435, 1910524.36 4219850.24, 1910523.33 4219850.63, 1910522.17 4219851.07, 1910518.81 4219852.36, 1910499.66 4219859.79, 1910487.27 4219864.61, 1910483.13 4219867.36, 1910475.74 4219872.44, 1910468.25 4219877.61, 1910466.57 4219878.81, 1910464.74 4219881.85, 1910459.27 4219892.65, 1910455.34 4219901.83, 1910443.31 4219907.52, 1910451.71 4219921.51, 1910455.2 4219947.1, 1910456.37 4219956.04, 1910456.7 4219962.39, 1910457.44 4219980.45, 1910453.17 4219981.78, 1910446.19 4220006.71, 1910455.97 4220007.88, 1910460.61999993 4220008.250002122, 1910465.1899999299 4220025.740002122, 1910464.99999993 4220032.500002122, 1910465.21999993 4220042.250002121, 1910465.76999993 4220059.900002122, 1910465.9299999299 4220069.720002121, 1910463.4199999298 4220069.700002122, 1910463.36999993 4220078.200002122, 1910463.57999993 4220096.350002121, 1910463.74999993 4220116.160002122, 1910463.80999993 4220126.030002122, 1910463.88999993 4220138.020002122, 1910466 4220140.01, 1910465.81 4220144.63, 1910465.77 4220144.83, 1910465.7 4220145.21, 1910465.83 4220151.96, 1910465.85 4220155.63, 1910466.3 4220177.32, 1910466.35999993 4220189.90000212, 1910452.82999993 4220188.980002121, 1910405.58999993 4220173.29000212, 1910373.33999993 4220169.040002122, 1910366.8375966095 4220164.453849365, 1910362.21 4220161.19, 1910350.02 4220160.04, 1910327.34 4220163.82, 1910307.48 4220168.9, 1910314.92 4220204, 1910313.8599999303 4220209.460002119, 1910310.41999993 4220269.94000212, 1910329.21 4220275.9, 1910330.14 4220276.2, 1910325.66 4220285.57, 1910317.08 4220297.94, 1910313.45 4220301.74, 1910279.6254951702 4220286.216588211, 1910259.12 4220287.08, 1910258.26 4220289.41, 1910256.31 4220292.42, 1910253.65 4220295.93, 1910253.5550824327 4220309.59961332, 1910250.5253862946 4220315.605394891, 1910245.430242708 4220320.750278103, 1910238.3101567489 4220324.030293273, 1910226.7925433044 4220324.975785752, 1910226.67 4220338.67, 1910226.72 4220349.35, 1910234.59 4220370.81, 1910252.01 4220388.85, 1910203.9661470496 4220399.96463463, 1910220.15 4220431.07, 1910214.64 4220432.42, 1910227.85 4220463.38, 1910273.45 4220465.69, 1910271.1 4220482.64, 1910268.63 4220496.62, 1910264.35 4220520.97, 1910241.01 4220515.42, 1910241.52 4220530.2, 1910242.03 4220545.16, 1910242.2466039478 4220553.8531508455, 1910258.96 4220552.14, 1910257.88 4220558.26, 1910257.65 4220560.23, 1910258.55 4220566.63, 1910255.9 4220571.91, 1910226.4478240386 4220568.957103476, 1910231.4157826675 4220589.086839281, 1910248.7528622954 4220589.983596864, 1910245.48 4220602.08, 1910256.81 4220618.12, 1910257.05 4220622.24, 1910248.93 4220635.49, 1910246.89386439 4220639.137338571, 1910246.63 4220639.61, 1910243.32 4220648.88, 1910242.74 4220650.08, 1910241.52 4220652.68, 1910240.83 4220653.52, 1910239.31 4220655.26, 1910231.83 4220661.72, 1910226.93 4220665.78, 1910224.82 4220667.36, 1910223.73 4220668.02, 1910222.01 4220668.97, 1910220.76 4220669.45, 1910218.32 4220670.31, 1910213.94 4220671.38, 1910207.34 4220673.01, 1910201.51 4220674.58, 1910196.47 4220676.49, 1910189.22 4220679.22, 1910181.2 4220681.88, 1910175.07 4220683.92, 1910171.65 4220684.99, 1910164.93 4220687.84, 1910158.56 4220690.72, 1910156.8 4220691.37, 1910152.87 4220692.71, 1910150.41 4220693.36, 1910147 4220693.89, 1910143.97 4220694.13, 1910141.02 4220694.23, 1910135.43 4220694.09, 1910131.65 4220694.45, 1910128.25 4220695.17, 1910126.61 4220695.73, 1910125 4220696.43, 1910123.47 4220697.24, 1910122 4220698.17, 1910119.3 4220700.36, 1910118.04 4220702.51, 1910116.6 4220704.9, 1910113.84 4220708.24, 1910107.61 4220714.02, 1910102.72 4220718.27, 1910088.9 4220731.36, 1910070.59 4220741.82, 1910053.64 4220747.27, 1910042.75 4220747.28, 1910025.68 4220748.32, 1910021.251308194 4220748.336045985, 1910028.4231660506 4220736.374889892, 1910023.46 4220735.69, 1910019.22 4220735.95, 1910007.98 4220735.01, 1910004.85 4220747.24, 1910004.17 4220747.17, 1909998.82 4220747.2, 1909971.64 4220747.1, 1909966.3845458932 4220748.472692334, 1909960.2 4220749.53, 1909957.11 4220756.56, 1909950.5 4220772.35, 1909946.55 4220781.71, 1909935.7 4220800.19, 1909929.020121487 4220811.4735785695, 1909938.63 4220816.57, 1909964.69 4220828.84, 1909954.9 4220847.83, 1909960.88 4220850.72, 1909956.92 4220858.81, 1909951.8 4220870.91, 1909944.97 4220887.6, 1909938.45 4220903.55, 1909932 4220920.08, 1909923.93 4220939.94, 1909923.5399999302 4220952.110002119, 1909919.27 4220977.32, 1909916.7 4220994.96, 1909914.12 4221012.43, 1909913.02 4221023.67, 1909912.69 4221026.41, 1909910.76 4221042.44, 1909909.52 4221051.39, 1909910.47 4221056, 1909911.95 4221061.41, 1909915.14 4221069.14, 1909916.54 4221072.56, 1909922.8 4221088, 1909924.19 4221090.46, 1909928.2721428054 4221091.915372652, 1909931.09 4221092.92, 1909933.08 4221093.85, 1909948.25 4221100.88, 1909956.93 4221102.06, 1909960 4221103.11, 1909975.83 4221107.28, 1909976.75 4221107.55, 1909979.11 4221108.25, 1910006.02 4221118.74, 1910028.13 4221127.07, 1910031.9433936852 4221129.578811635, 1910031.93999993 4221126.610002116, 1910032.1399999303 4221122.890002118, 1910034.5799999302 4221107.20000212, 1910034.9099999303 4221096.130002118, 1910035.15 4221092.76, 1910037.6099999303 4221072.600002119, 1910038.0899999302 4221068.710002119, 1910039.3399999302 4221058.680002118, 1910042.0899999302 4221036.810002117, 1910043.19999993 4221028.300002118, 1910045.7599999302 4221008.870002117, 1910046.0499999302 4221006.550002118, 1910105.4899999301 4221036.750002118, 1910106.9505852344 4221037.638143878, 1910109.6709408693 4221038.033279334, 1910112.9169610827 4221038.504768304, 1910137.415766941 4221041.837939167, 1910151.5256005311 4221043.700437201, 1910170.9520147739 4221046.57205252, 1910209.9042791557 4221052.04573673, 1910225.688856879 4221047.972297318, 1910229.9086423654 4221046.681190292, 1910230.6145885764 4221052.27253929, 1910233.360526213 4221067.418187189, 1910239.51059993 4221107.385402115, 1910241.1184999302 4221115.889202115, 1910242.02359993 4221120.791402119, 1910230.2208999302 4221125.404002116, 1910219.7354691734 4221128.250445559, 1910219.7199999301 4221131.100002117, 1910219.7899999302 4221140.650002118, 1910219.7699999302 4221171.950002117, 1910218.7899999302 4221202.200002118, 1910196.7599999302 4221201.250002119, 1910197.2899999302 4221209.780002118, 1910198.6524455836 4221237.667765303, 1910234.21 4221243.33, 1910237.46 4221243.87, 1910256.23 4221236.03, 1910270.07 4221239.73, 1910280.24 4221242.33, 1910291 4221245.73, 1910302.04 4221248.81, 1910310.38 4221252.81, 1910327.48 4221252.66, 1910340.74 4221256.25, 1910356.99 4221255.23, 1910361.45 4221256.08, 1910363.98 4221256.56, 1910387.83 4221260.78, 1910397.03 4221262.04, 1910447.5299999302 4221246.540002117, 1910465.05999993 4221247.730002118, 1910483.6899999299 4221245.010002118, 1910510.7 4221248.25, 1910522.787007174 4221249.838155767, 1910531.78 4221259.95, 1910533.82 4221261.49, 1910537.85 4221264.32, 1910539.71 4221265.56, 1910561.31 4221288.42, 1910563.63 4221297.88, 1910567.35 4221305.49, 1910578.17 4221313.65, 1910580.02 4221322.33, 1910584.54 4221339, 1910586.22 4221347.41, 1910586.9630371432 4221351.515977258, 1910601.88999993 4221348.160002117, 1910601.8936721059 4221348.159343009, 1910601.94 4221350.45, 1910602.19 4221359.8), (1910148.69999993 4220818.080002118, 1910181.0899999302 4220821.920002117, 1910187.95999993 4220823.29000212, 1910197.0199999302 4220827.960002119, 1910219.6099999303 4220825.630002118, 1910292.9399999299 4220818.590002119, 1910297.7899999302 4220862.81000212, 1910299.0699999302 4220866.950002117, 1910302.4899999301 4220867.800002117, 1910325.236654182 4220861.999442574, 1910325.01 4220864.48, 1910324.88 4220865.65, 1910320.01 4220911, 1910313.1721576003 4220971.220306553, 1910313.1699999298 4220971.220002119, 1910306.2799999302 4220971.160002119, 1910272.1399999303 4220971.070002118, 1910267.82999993 4220971.070002119, 1910244.5299999302 4220971.080002117, 1910238.5999999302 4220971.08000212, 1910231.4699999301 4220971.0900021205, 1910229.7299999301 4220971.090002117, 1910226.8199999302 4220971.080002119, 1910219.94999993 4220971.920002119, 1910217.4672309768 4220947.5591087, 1910209.16 4220948.78, 1910194.12 4220950.57, 1910180.9 4220952.14, 1910172.32 4220953.16, 1910165.91 4220953.93, 1910162.66 4220955.9, 1910156.28 4220959.77, 1910148.32 4220964.35, 1910143.48 4220967.13, 1910133.56 4220976.58, 1910131 4220976.17, 1910125.97 4220975.37, 1910118.97 4220980.84, 1910118.46 4220983.84, 1910117.5655063784 4220988.969539549, 1910041.8855353121 4220950.633352169, 1910048.9799999301 4220930.840002119, 1910053.6099999303 4220918.150002118, 1910055.5899999302 4220912.730002117, 1910057.9099999303 4220912.980002118, 1910064.13 4220886.03, 1910064.63 4220883.34, 1910065.3399999302 4220879.58000212, 1910068.0599999302 4220857.080002118, 1910070.0699999302 4220842.4700021185, 1910096.1199999303 4220841.430002118, 1910095.8099999302 4220838.810002119, 1910092.2599999302 4220819.480002121, 1910089.72 4220814.25, 1910086.3599999303 4220807.31000212, 1910087.98999993 4220802.110002121, 1910089.2899999302 4220797.350002117, 1910106.68999993 4220810.3900021175, 1910126.45999993 4220817.530002118, 1910148.69999993 4220818.080002118))','ZO32099','"lib_modif"=>"N", "lib_code_insee"=>"38486 / 38485", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','A','Agricole','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1917978 4232753.62, 1917975.206811373 4232753.370608158, 1917972.85 4232756.69, 1917973.95 4232764.98, 1917978.41 4232772.52, 1917979.6253264167 4232774.97051815, 1917989.9716666914 4232796.6352023985, 1917999.4 4232806.61, 1918007.76 4232817.07, 1918011.04 4232821.16, 1918009.9 4232822.07, 1918015.71 4232831.3, 1918033.656934668 4232860.727779399, 1918057.2132095445 4232840.00186406, 1918076.23 4232823.27, 1917994.23 4232754.8, 1917978 4232753.62))','ZO34469','"lib_modif"=>"N", "lib_code_insee"=>"38471", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UZ1','Equipements collectifs et touristiques','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UZ1.pdf','2019-12-20','SRID=3945;POLYGON ((1917221.1179965355 4226446.943197921, 1917222.47 4226443.06, 1917228.57 4226426.43, 1917231 4226419.86, 1917255.83 4226352.38, 1917256.1430262935 4226351.6244192915, 1917256.41 4226350.98, 1917256.97 4226349.3, 1917227.57 4226338.4, 1917188.69 4226324.06, 1917177.87265821 4226319.8629118, 1917160.7696999284 4226365.970202101, 1917138.9044999282 4226419.922402102, 1917154.2197999284 4226426.113002103, 1917205.5654999283 4226442.677002104, 1917221.1179965355 4226446.943197921))','ZO32492','"lib_modif"=>"N", "lib_code_insee"=>"38229", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','N','Naturelle','N',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/N.pdf','2019-12-20','SRID=3945;POLYGON ((1920153.26 4217778.66, 1920212.52 4217864.92, 1920245.17 4217897.22, 1920256.9795841519 4217909.203389122, 1920292.9799999997 4217885.240000003, 1920297.3088420643 4217882.3478247365, 1920288.91 4217866.57, 1920277.86 4217845.81, 1920273.85 4217847.32, 1920268.76 4217849.25, 1920258.5 4217853.14, 1920234.8 4217824.96, 1920208.72 4217793.92, 1920201.44 4217785.27, 1920194.38 4217776.87, 1920187.11 4217768.22, 1920179.99 4217759.75, 1920153.26 4217778.66))','ZO32574','"lib_modif"=>"N", "lib_code_insee"=>"38059 / 38188", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','A','Agricole','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1921569.725948704 4207833.857661132, 1921569.9441699407 4207833.882014054, 1921581.5856706193 4207835.1285227295, 1921582.3424794588 4207834.994968229, 1921592.4035852079 4207818.612282761, 1921594.718529894 4207814.472093227, 1921601.885954786 4207811.64518962, 1921606.6939168253 4207809.530576686, 1921606.7829531594 4207808.996358683, 1921610.6115155243 4207784.956548486, 1921615.953695568 4207755.930703581, 1921619.0699672601 4207740.260308786, 1921623.9669656337 4207730.021130369, 1921631.1789086927 4207716.487607592, 1921638.4798880855 4207702.419866809, 1921647.472557826 4207685.235854335, 1921652.9705514547 4207675.130230418, 1921652.19 4207673.87, 1921648.55 4207667.24, 1921637.51 4207647.15, 1921645.93 4207629.83, 1921609.44 4207616.64, 1921599.14 4207606.17, 1921567.81 4207621.81, 1921568.28 4207621.19, 1921566.3149325976 4207620.867857803, 1921565.4812236945 4207617.334520071, 1921556.6666266222 4207593.294709873, 1921539.3935778139 4207577.312687908, 1921530.9351260778 4207569.076827007, 1921530.8015715769 4207566.583809654, 1921549.2320927281 4207553.629023047, 1921554.7078272728 4207535.064947396, 1921563.3888698446 4207519.528107101, 1921571.3576217433 4207504.547743895, 1921567.7293911302 4207497.625168922, 1921573.338680176 4207466.640524668, 1921586.649612119 4207456.312309917, 1921586.78316662 4207444.158850317, 1921571.6915079958 4207437.926306933, 1921565.3254101104 4207433.697081065, 1921561.6526613303 4207431.115027376, 1921555.0194544427 4207425.995438168, 1921552.3928825879 4207420.208076454, 1921556.5775902888 4207416.5575867575, 1921564.1456786843 4207412.016733721, 1921584.802108187 4207400.442010293, 1921599.047921637 4207392.606812895, 1921609.999390727 4207380.764980465, 1921626.4711125286 4207364.115185996, 1921647.3056146994 4207341.767066147, 1921649.798632053 4207331.616924064, 1921652.2916494068 4207321.822927317, 1921658.0790111208 4207313.008330245, 1921670.900243226 4207292.886118746, 1921675.5301325973 4207284.561221512, 1921685.1015385087 4207261.545329155, 1921688.395882869 4207253.08687742, 1921690.6217912205 4207242.669626335, 1921691.7792635632 4207229.848394229, 1921688.3513647018 4207217.24975296, 1921683.5879208294 4207200.778031159, 1921683.3653299941 4207187.778726387, 1921683.4543663282 4207166.320969878, 1921679.9819492996 4207135.6924709575, 1921675.6191689307 4207123.761602193, 1921668.8524075425 4207103.461318028, 1921670.403110573 4207085.984475766, 1921668.72 4207086.46, 1921667.1058466698 4207086.989565975, 1921619.38 4207103.34, 1921622.35 4207088.59, 1921622.87 4207080.61, 1921615.500000075 4207090.219997842, 1921604.93 4207104.47, 1921601.79 4207108.56, 1921596.51 4207115.42, 1921591.14 4207122.41, 1921586.34 4207131.72, 1921575.53 4207152.94, 1921573.82 4207156.27, 1921568.83 4207166.01, 1921565.48 4207172.45, 1921560.51 4207182.06, 1921560.08 4207182.96, 1921542.49 4207162.88, 1921537.91 4207164.79, 1921524.4 4207170.19, 1921517.64 4207172.95, 1921514.83 4207174.72, 1921499.3 4207183.32, 1921492.8 4207186.84, 1921477.11 4207195.43, 1921464.53 4207202.19, 1921463.41 4207204.01, 1921458.65 4207210.2, 1921452.9500000745 4207217.4799978435, 1921452.42 4207218.29, 1921450.54 4207221.56, 1921445.1 4207232.11, 1921438.19 4207245.14, 1921431.86 4207256.89, 1921426.99 4207266.16, 1921427.24 4207268.37, 1921426.49 4207282.2, 1921425.88 4207292.39, 1921425.65 4207296.08, 1921424.83 4207298.44, 1921422.56 4207304.57, 1921417.98 4207316.71, 1921417.26 4207316.67, 1921416.04 4207319.14, 1921413.71 4207318.76, 1921397.36 4207313.92, 1921392.63 4207312.43, 1921376.22 4207326.69, 1921374.919999925 4207327.870002157, 1921366.97 4207334.71, 1921364.99 4207336.52, 1921347.52 4207355.48, 1921330.15 4207374.05, 1921319.7400000747 4207364.519997843, 1921299.88 4207378.16, 1921273.06 4207401.22, 1921269.19 4207404.72, 1921248.71 4207416.08, 1921248.07 4207416.29, 1921246.83 4207416.71, 1921211.92 4207407.67, 1921211.35 4207407.66, 1921211.14 4207407.65, 1921207.6599999254 4207407.830002158, 1921161.32 4207410.2, 1921153.02 4207410.94, 1921146.66 4207386.95, 1921137.13 4207392.59, 1921125.11 4207377.68, 1921106.33 4207391.59, 1921105.69 4207391.98, 1921095.03 4207408.84, 1921100.59 4207425.65, 1921056.02 4207430.97, 1921031.09 4207434.01, 1920987.09 4207439.03, 1920984.19 4207425.36, 1920938.71 4207427.69, 1920936.07 4207428.71, 1920927.5799999253 4207431.990002157, 1920884.8599999254 4207553.410002156, 1920879.8099999253 4207568.970002156, 1920876.5199999255 4207579.070002156, 1920875.6399999254 4207580.880002155, 1920875.0999999254 4207583.300002157, 1920840.3699999256 4207678.910002156, 1920825.9099999256 4207719.370002156, 1920820.6299999256 4207734.120002156, 1920809.8699999256 4207764.230002156, 1920793.2599999255 4207811.530002154, 1920786.6199999256 4207830.450002156, 1920781.98 4207843.69, 1920799.49 4207861.03, 1920834.89 4207896.07, 1920835.36 4207896.54, 1920835.04 4207909.91, 1920834.86 4207917.9, 1920835 4207920.01, 1920842.21 4207929.32, 1920865.65 4207938.33, 1920889.54 4207925.42, 1920890.82 4207924.83, 1920897.5299999253 4207917.820002156, 1920899.11 4207918.82, 1920898.37 4207919.76, 1920894.25 4207937.89, 1920894.05 4207938.81, 1920895.42 4207947.04, 1920900.05 4207974.67, 1920927.61 4207992.45, 1920940.6 4207995, 1920936.49 4208023.92, 1920940.61 4208032.08, 1920941.32 4208032.96, 1920953.99 4208048.79, 1920955.4 4208060.2, 1920957.57 4208077.71, 1920957.7909399748 4208079.585295396, 1920958.2798583128 4208079.481785658, 1920975.0186891104 4208076.476809385, 1920981.5628596614 4208075.586446045, 1920993.9389100913 4208074.9186735395, 1921004.4006793394 4208075.319337043, 1921013.4823854102 4208076.209700383, 1921023.8551183245 4208078.613681401, 1921034.940141911 4208082.130616595, 1921037.9228591009 4208083.199052603, 1921056.887598249 4208092.592385842, 1921082.0848807788 4208104.790363604, 1921097.376871148 4208111.223238737, 1921100.8270290918 4208112.024565743, 1921129.4967286487 4208113.894328758, 1921139.0236163896 4208113.760774258, 1921146.858813784 4208114.606619431, 1921146.903331951 4208119.904281304, 1921145.05582802 4208129.297614544, 1921144.833237185 4208130.232496051, 1921144.9000144359 4208131.479004728, 1921145.9461913607 4208138.245766114, 1921147.103663703 4208145.034786584, 1921154.2933476756 4208152.268988724, 1921163.6644218324 4208161.06132671, 1921167.893647699 4208165.535402494, 1921170.831846722 4208173.4151180545, 1921172.6570915694 4208182.363269624, 1921174.8384817524 4208194.96191089, 1921176.619208433 4208206.13597081, 1921194.8716569087 4208211.300078183, 1921203.19655414 4208213.815354619, 1921210.6533471148 4208213.971168203, 1921217.3088130835 4208213.793095536, 1921223.1852111293 4208213.147582114, 1921228.1712458348 4208212.61336411, 1921229.7293816803 4208213.281136614, 1921235.1383389726 4208219.4914209135, 1921239.4609573656 4208224.562184798, 1921238.71 4208225.93, 1921216.36 4208265.06, 1921209.1 4208278.16, 1921233.14 4208285.42, 1921238.46 4208287.51, 1921254.55 4208293.75, 1921261.25 4208308.42, 1921253.97 4208322.2, 1921253.36 4208323.93, 1921262.86 4208323.8, 1921269.16 4208323.69, 1921278.84 4208322.31, 1921290.72 4208320.44, 1921290.77 4208321.48, 1921289.04 4208334.9, 1921287.3800000749 4208347.099997846, 1921286 4208357.9, 1921285.68 4208360.39, 1921289.93 4208374.64, 1921289.98 4208375.42, 1921288.77 4208383.89, 1921290.67 4208384, 1921300.58 4208384.31, 1921293.91 4208420.51, 1921295.45 4208420.42, 1921301.44 4208420.52, 1921311.47 4208420.87, 1921317.86 4208420.08, 1921333.32 4208418.14, 1921338.53 4208423.11, 1921331.88 4208452.48, 1921326.98 4208475.24, 1921326.44 4208477.41, 1921324.4500000747 4208490.009997846, 1921321.04 4208509.28, 1921319.94 4208515.83, 1921320.11 4208537.23, 1921320.02 4208538.88, 1921319.46 4208541.36, 1921317.77 4208551.87, 1921317.17 4208554.3, 1921317.16 4208558.36, 1921280.05 4208594.2, 1921299.44 4208611.75, 1921308.13 4208609.53, 1921331.82 4208617.22, 1921337.99 4208619.29, 1921310.14 4208629.32, 1921322.06 4208648.43, 1921353.22 4208697.1, 1921358.08 4208691.18, 1921365.18 4208696.29, 1921385.41 4208711.52, 1921396.95 4208720.05, 1921399.55 4208721.97, 1921401.21 4208723.25, 1921403.83 4208724.54, 1921416.47 4208731.8, 1921423 4208712.84, 1921432.5 4208717.57, 1921468.68 4208736.17, 1921470.61 4208737.17, 1921472.9 4208738.81, 1921504.48 4208760.41, 1921524.03 4208773.54, 1921527.59 4208769.19, 1921530.58 4208770.05, 1921562.96 4208779.62, 1921560.75 4208781.57, 1921549.62 4208790.45, 1921546.16 4208794.2, 1921534.6200000746 4208806.249997849, 1921518.96 4208822.29, 1921522.95 4208827.59, 1921523.87 4208829.01, 1921533.97 4208839.5, 1921535.74 4208841.18, 1921552.47 4208848.43, 1921543.55 4208857.5, 1921535.26 4208865.71, 1921534.96 4208866.33, 1921546.27 4208882.56, 1921549.87 4208897.82, 1921550.1 4208898.78, 1921550.29 4208899.72, 1921552.11 4208898.52, 1921556.05 4208895.91, 1921591.44 4208871.94, 1921607.3 4208872.81, 1921607.67 4208872.47, 1921629.99 4208851.69, 1921643.11 4208867.33, 1921648.22 4208860.33, 1921656.59 4208848.92, 1921672.82 4208850.37, 1921680.14 4208833.51, 1921681.4858286092 4208830.9679215485, 1921679.8386564297 4208817.078253441, 1921678.8592567553 4208814.941381424, 1921675.9655758995 4208809.243056045, 1921671.469241031 4208799.983277306, 1921669.5549598495 4208794.9527244335, 1921666.5277244926 4208788.007890379, 1921664.880552313 4208785.47035486, 1921661.8978351234 4208781.619533414, 1921658.1137909272 4208776.232835205, 1921654.2852285642 4208771.513909502, 1921651.9702838794 4208768.798301314, 1921650.76829337 4208766.082693126, 1921649.2101575246 4208761.85346726, 1921647.9191306808 4208758.803972819, 1921646.2274403342 4208754.841855955, 1921644.5357499877 4208749.722266749, 1921642.9330959746 4208744.981081961, 1921640.3510422884 4208737.813657071, 1921637.6354341006 4208729.666832508, 1921636.8563661778 4208726.750892568, 1921636.6337753427 4208722.900071122, 1921636.4111845074 4208710.768870611, 1921636.7673298437 4208702.13234621, 1921636.0995573385 4208693.317749141, 1921634.630457827 4208675.154336998, 1921634.0517216558 4208659.973642047, 1921633.161358316 4208648.621509458, 1921632.671658479 4208640.519203061, 1921633.027803815 4208636.111904527, 1921633.472985485 4208631.526533325, 1921632.092922307 4208627.475380126, 1921629.7334594554 4208619.729219066, 1921624.658388416 4208612.561794178, 1921615.176018842 4208598.80568057, 1921614.2856555018 4208595.600372545, 1921613.0836649924 4208587.854211485, 1921612.6384833222 4208582.823658613, 1921612.8165559901 4208580.241604926, 1921613.8404738316 4208577.303405903, 1921616.7341546875 4208570.581162684, 1921620.7407897194 4208560.163911602, 1921622.0763347298 4208554.198477223, 1921624.0796522454 4208543.736707974, 1921626.0384515945 4208533.675602229, 1921626.7062240997 4208529.802521699, 1921626.7952604336 4208526.463659173, 1921626.5095323264 4208525.130261339, 1921627.21 4208521.64, 1921643.31 4208521.06, 1921642.36 4208521.07, 1921642.91 4208516.53, 1921643.2 4208510.22, 1921643.56 4208500.05, 1921643.67 4208495.98, 1921643.7100000747 4208494.519997846, 1921658.77 4208495.92, 1921667.83 4208496.55, 1921681.62 4208497.67, 1921693.45 4208498.36, 1921693.65 4208497.38, 1921700.81 4208490.74, 1921708.02 4208484.36, 1921717.78 4208475.66, 1921719.6 4208474.67, 1921723.88 4208472.82, 1921738.9700000747 4208466.289997848, 1921738.44 4208449.03, 1921738.7918390993 4208448.465048178, 1921738.1685847612 4208447.819534756, 1921735.4195879474 4208439.0271967705, 1921730.121926073 4208422.33288414, 1921724.2900461943 4208403.368144994, 1921723.800346357 4208400.251873303, 1921729.0534900643 4208389.745585887, 1921737.511941797 4208369.311747228, 1921737.1780555444 4208368.165404428, 1921735.1190903194 4208364.459267024, 1921728.2632925995 4208351.949662093, 1921725.3250935767 4208346.462798009, 1921718.869959359 4208341.543540554, 1921707.2061996015 4208332.684425318, 1921691.2241776441 4208320.397411223, 1921688.9537511263 4208316.769180611, 1921669.5660893915 4208287.3649312975, 1921665.092013606 4208284.538027692, 1921656.5890437067 4208278.728406898, 1921648.6425508948 4208273.964963027, 1921641.1189806694 4208269.557664492, 1921636.6671639676 4208273.4752631895, 1921624.55822254 4208283.046669098, 1921623.0000866945 4208283.580887102, 1921611.0024406842 4208285.250318365, 1921608.4871642478 4208285.317095615, 1921604.0798657136 4208285.183541114, 1921600.362598768 4208282.690523761, 1921598.1366904173 4208280.575910828, 1921598.3592812524 4208278.016116225, 1921599.5390126777 4208264.460334369, 1921600.6519668538 4208258.583936323, 1921601.8984755299 4208251.3274751, 1921604.12438388 4208240.954742186, 1921605.7715560596 4208233.5202082945, 1921608.4871642478 4208224.48302039, 1921609.7781910913 4208220.298312691, 1921613.6512716215 4208211.261124787, 1921615.7881436383 4208207.8777440945, 1921622.7329776925 4208196.080429836, 1921625.2705132123 4208191.895722137, 1921625.6097377578 4208191.3362992015, 1921625.16 4208191.24, 1921607.6 4208187.48, 1921615.09 4208174.4, 1921613.18 4208174.65, 1921595.94 4208180.97, 1921594.91 4208181.36, 1921593.32 4208182, 1921591.34 4208183.12, 1921585.01 4208186.68, 1921578.28 4208190.69, 1921575.56 4208192.54, 1921572.57 4208192.26, 1921559.07 4208190.25, 1921553.53 4208189.11, 1921552.27 4208189.12, 1921548.26 4208189.24, 1921547.6785954242 4208189.261533503, 1921551.4969544772 4208184.85211339, 1921552.704509758 4208183.460920671, 1921554.3628114802 4208180.478203479, 1921557.7907103417 4208165.074917686, 1921561.040536535 4208150.428440734, 1921564.156808227 4208136.004554616, 1921564.2458445611 4208132.265028586, 1921564.7800625656 4208125.498267197, 1921575.7315316552 4208120.022532652, 1921582.320220376 4208116.639151958, 1921585.1693830658 4208111.163417414, 1921594.5627163092 4208092.599341761, 1921598.3912786744 4208086.5893892115, 1921601.3294776985 4208080.490400328, 1921602.3979137072 4208077.596719472, 1921612.6816102916 4208062.90572435, 1921617.2224633289 4208052.5775096, 1921619.0031900099 4208048.081174729, 1921618.3799356716 4208032.099152765, 1921618.2908993375 4208026.489863719, 1921601.0178505294 4207994.125156287, 1921595.9872976546 4207984.687304877, 1921594.3846436415 4207981.749105853, 1921596.1208521558 4207954.860132965, 1921597.1447699976 4207940.925946685, 1921598.0351333383 4207930.6422501, 1921595.5421159843 4207916.440954817, 1921593.9839801383 4207904.866231389, 1921591.2683719492 4207898.900797007, 1921589.2205362655 4207894.7160893055, 1921580.8066026967 4207888.79517309, 1921574.1288776419 4207883.052329543, 1921565.5368714049 4207876.107495487, 1921557.3900468382 4207872.635078456, 1921557.2681266023 4207872.5836523855, 1921556.3636327286 4207874.674324551, 1921547.9899999253 4207893.510002155, 1921546.24 4207892.96, 1921545.06 4207892.43, 1921538.47 4207900.14, 1921532.59 4207907.03, 1921532.3 4207923.52, 1921534.08 4207923.52, 1921535.25 4207923.57, 1921534.87 4207927.71, 1921534.09 4207936.4, 1921534.85 4207936.97, 1921533.8 4207942.14, 1921533.09 4207944.65, 1921532.48 4207945.6, 1921531.67 4207947.2, 1921531.19 4207948.21, 1921530.57 4207948.8, 1921527.6 4207949.3, 1921513.53 4207943.86, 1921509.4529448226 4207943.89621208, 1921511.78 4207960.7, 1921496.85 4207962.61, 1921494.73 4207962.89, 1921494.64 4207961.48, 1921494.58 4207950.93, 1921489.04 4207952.2, 1921481.44 4207980.25, 1921477.91 4207979.04, 1921476.43 4207984.13, 1921468.56 4207979.95, 1921467.55 4207976.9, 1921468.23 4207975.43, 1921468.7 4207973.92, 1921460.69 4207972.06, 1921458.2100000002 4207971.359999991, 1921449.399083034 4207997.455029228, 1921456.213432421 4207999.854448028, 1921465.09 4208002.98, 1921466.51 4208003.48, 1921473.57 4208005.97, 1921493.14 4208016.88, 1921494.8762685738 4208017.689756493, 1921492.39 4208022.33, 1921488.2 4208030.15, 1921485.5488764509 4208035.193160017, 1921473.34 4208030.55, 1921469.63 4208029.22, 1921453.72 4208023.49, 1921445.9801248773 4208029.334922374, 1921443.56 4208026.25, 1921442.64 4208025.33, 1921440.11 4208031.44, 1921438.73 4208034.81, 1921437.5 4208037.94, 1921435.82 4208042.63, 1921433.94 4208048, 1921432.46 4208051.95, 1921431.03 4208055.74, 1921430.31 4208057.41, 1921428.64 4208060.84, 1921427.24 4208063.94, 1921426.1 4208066.52, 1921442.02 4208084.2, 1921439.87 4208086.28, 1921439.38 4208085.82, 1921438.66 4208086.63, 1921436.44 4208088.47, 1921433.34 4208091.07, 1921430.07 4208093.83, 1921428.77 4208094.98, 1921428.75 4208095, 1921428.73 4208095.01, 1921428.71 4208095.03, 1921428.69 4208095.04, 1921428.68 4208095.06, 1921428.66 4208095.07, 1921428.64 4208095.08, 1921428.62 4208095.09, 1921428.6 4208095.1, 1921428.58 4208095.11, 1921428.56 4208095.12, 1921428.54 4208095.12, 1921428.52 4208095.13, 1921428.5 4208095.13, 1921428.48 4208095.14, 1921428.46 4208095.14, 1921428.44 4208095.15, 1921428.42 4208095.15, 1921428.4 4208095.15, 1921428.38 4208095.15, 1921428.36 4208095.15, 1921428.34 4208095.16, 1921428.32 4208095.15, 1921428.3 4208095.15, 1921428.28 4208095.15, 1921428.26 4208095.15, 1921428.24 4208095.15, 1921428.22 4208095.14, 1921428.2 4208095.14, 1921428.18 4208095.13, 1921428.16 4208095.13, 1921428.14 4208095.12, 1921428.12 4208095.12, 1921428.1 4208095.11, 1921428.08 4208095.1, 1921428.06 4208095.09, 1921428.04 4208095.08, 1921428.02 4208095.07, 1921428 4208095.05, 1921427.98 4208095.04, 1921427.96 4208095.03, 1921427.95 4208095.01, 1921426.87 4208095.71, 1921416.6 4208084.41, 1921415.6255844035 4208083.337858205, 1921414.4601096949 4208082.224718657, 1921416.13 4208079.15, 1921408.55 4208076.58, 1921412.26 4208068.82, 1921410.45 4208068.12, 1921405.5 4208066.77, 1921398.14 4208064.32, 1921397.21 4208064.1, 1921390.87 4208063.78, 1921388.65 4208063.01, 1921386.09 4208062.12, 1921380.03 4208069.46, 1921378.78 4208068.38, 1921374.01 4208074.33, 1921372.79 4208075.85, 1921366.33 4208083.84, 1921358.11 4208077.08, 1921357.33 4208076.54, 1921347.14 4208076.17, 1921345.34 4208074.06, 1921337.1 4208064.38, 1921334.26 4208046.89, 1921333.92 4208045.96, 1921330.8240392923 4208044.128083611, 1921328.2220882683 4208042.588478565, 1921312.8000000003 4208033.359999995, 1921301.4700000002 4208026.579999991, 1921282.2229160399 4208015.062231422, 1921284.41 4208007.29, 1921287.7546562376 4208001.426790079, 1921292.66 4208003.03, 1921294.71 4208003.7, 1921302.85 4208005.67, 1921310.43 4208007.58, 1921310.4276550915 4208007.503904241, 1921310.41 4208006.68, 1921310.26 4207996.64, 1921300.2 4207979.61, 1921293.11 4207974.72, 1921281.09 4207982.73, 1921280.53 4207983.22, 1921265.93 4208001.38, 1921265.55 4208002.68, 1921265.84 4208003.71, 1921268.63 4208013.31, 1921265.1592912804 4208028.8957527075, 1921249.53 4208018.51, 1921243.36 4208014.41, 1921238.1336094758 4208010.937033834, 1921236.2804933907 4208010.036628949, 1921238.98 4207996.69, 1921237.7197326843 4207985.0235254215, 1921240.66 4207983.09, 1921259.61 4207968.76, 1921263.4272203052 4207965.819922577, 1921275.6099999254 4207981.960002154, 1921300.6899999254 4207964.570002154, 1921300.8847907 4207964.574713885, 1921347.94 4207973.92, 1921348.26 4207972.98, 1921348.84 4207971.26, 1921350.26 4207965.82, 1921369.07 4207971.99, 1921369.61 4207972.17, 1921378.79 4207975.18, 1921383.59235395 4207976.706992259, 1921375.28 4207992.33, 1921377.0400000003 4207995.63999999, 1921389.87 4208001.92, 1921395.12 4208004.82, 1921403.07 4208009.37, 1921401.15 4208003.29, 1921401.36 4208001.57, 1921402.3 4207981.05, 1921403.95 4207980.74, 1921409.72 4207982.22, 1921414.17 4207986.3, 1921421.68 4207983.65, 1921427.08 4207980.29, 1921431.74 4207974.19, 1921426.39 4207971.89, 1921420.68 4207969.89, 1921427.5 4207952.78, 1921420.98 4207950.18, 1921425.45 4207938.35, 1921427.464920181 4207933.474229292, 1921427.95 4207933.7, 1921439.81 4207939.22, 1921437.81 4207944.3, 1921448.91 4207949.64, 1921451.99 4207951.57, 1921455.61 4207953.48, 1921458.5 4207955.01, 1921462.04 4207953.09, 1921463.32 4207953.15, 1921473.4 4207955.77, 1921479.27 4207955.34, 1921480.79 4207950.15, 1921482.9 4207941.71, 1921485.74 4207930.38, 1921487.38 4207928.32, 1921487.25 4207918.17, 1921483.41 4207883.04, 1921461.63 4207887.86, 1921460.65 4207888.08, 1921460.07 4207882.08, 1921459.61 4207878.13, 1921459.33 4207875.73, 1921458.95 4207873.88, 1921458.83 4207873.12, 1921458.29 4207870.43, 1921463.71 4207869.68, 1921466.7 4207869.16, 1921489.92 4207864.83, 1921491.6 4207861.86, 1921463 4207855.37, 1921459.97 4207854.66, 1921454.8 4207853.37, 1921445.36 4207848.19, 1921437.68 4207842.27, 1921434.12 4207839.29, 1921399.8164592828 4207851.764014797, 1921400.84 4207854.58, 1921404.94 4207865.86, 1921396.48 4207868.93, 1921392.39 4207857.66, 1921391.3655326734 4207854.83707902, 1921387.7 4207856.17, 1921387.02 4207856.42, 1921386.1 4207856.51, 1921383.73 4207857.13, 1921373.15 4207860.64, 1921373.54 4207861.3, 1921365.75 4207870.02, 1921365.0000000002 4207870.869999992, 1921354.8608090344 4207881.699323071, 1921364.1300000004 4207891.97999999, 1921369.7200000002 4207898.179999991, 1921359.6300000001 4207908.579999992, 1921353.8800000004 4207902.429999991, 1921344.1096416737 4207891.979964563, 1921341.0800000003 4207894.109999992, 1921334.19 4207898.94, 1921333.3 4207899.35, 1921321.28 4207904.8, 1921320.91 4207903.78, 1921318.74 4207891.98, 1921317.38 4207885.89, 1921315.68 4207880.87, 1921312.79 4207872.64, 1921314.23 4207871.77, 1921329.2 4207859.77, 1921330.49 4207858.72, 1921334.2999999253 4207855.670002157, 1921335.2099999252 4207854.990002155, 1921356.2999999253 4207829.540002157, 1921352.7799999253 4207822.390002154, 1921351.9799999252 4207820.810002156, 1921347.8899999254 4207812.300002155, 1921345.9499999252 4207808.210002155, 1921391.789999925 4207775.250002158, 1921394.4329137767 4207773.822952867, 1921398.44 4207779.6, 1921401.17 4207783.54, 1921409.55 4207786.24, 1921416.124208757 4207798.573828966, 1921428.92782285 4207780.733451138, 1921445.044772871 4207791.39562815, 1921426.26 4207817.57, 1921452.6599999252 4207808.790002156, 1921456.0699999253 4207812.420002154, 1921457.2099999252 4207814.010002155, 1921457.2329809053 4207813.993779321, 1921482.313743499 4207845.792259593, 1921476.8886786348 4207824.834541623, 1921481.03 4207821.29, 1921496.76 4207808.15, 1921507.26 4207824.54, 1921505.43 4207844.18, 1921505.74 4207845.69, 1921520.65 4207840.85, 1921524.13 4207840.56, 1921530.05 4207840.09, 1921531.883044921 4207839.944471097, 1921534.3659263237 4207839.747350446, 1921534.22 4207843.66, 1921548.36 4207843.98, 1921549.51 4207835.84, 1921544.94 4207834.44, 1921546.09 4207823.55, 1921547.05 4207814.46, 1921547.106739812 4207813.591105907, 1921555.77 4207813.33, 1921559.88 4207807.99, 1921564 4207800.43, 1921563.81 4207799.45, 1921561.28 4207780.97, 1921565.95 4207771.03, 1921566.7631883495 4207769.304699358, 1921569.789999925 4207772.130002156, 1921577.7 4207778.88, 1921587.7 4207781.53, 1921589.56 4207788.02, 1921588.56 4207791.79, 1921585.39 4207797.82, 1921579.92 4207810.55, 1921577.92 4207815.83, 1921572.25 4207814.22, 1921571.8 4207815.36, 1921565.32 4207831.3, 1921568.98 4207832.32, 1921569.725948704 4207833.857661132))','ZO32066','"lib_modif"=>"N", "lib_code_insee"=>"38364", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','AUD2','Zone à urbaniser de type UD2','AUc',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/AUD2.pdf','2019-12-20','SRID=3945;POLYGON ((1920672.8 4215100.89, 1920674.54 4215091.01, 1920682.97 4215039.97, 1920683.9953458398 4215033.682092141, 1920648.93 4215015.09, 1920610.529999926 4215001.2100021355, 1920602.6299999263 4215047.410002137, 1920603.1399999263 4215047.4600021355, 1920637.419999926 4215050.640002137, 1920641.519999926 4215051.020002136, 1920640.8399999263 4215053.570002136, 1920636.099999926 4215106.120002137, 1920652.04 4215103.19, 1920672.8 4215100.89))','ZO32069','"lib_modif"=>"N", "lib_code_insee"=>"38528", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','N','Naturelle','N',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/N.pdf','2019-12-20','SRID=3945;POLYGON ((1920785.1244740917 4224896.290687742, 1920796.8167074102 4224873.115407766, 1920804.060189311 4224858.905826215, 1920799.139999927 4224855.53000211, 1920745.339999927 4224818.790002109, 1920744.129999927 4224820.420002108, 1920730.7299999269 4224838.010002107, 1920727.7199999269 4224841.940002108, 1920750.829999927 4224863.460002109, 1920785.1244740917 4224896.290687742))','ZO33960','"lib_modif"=>"N", "lib_code_insee"=>"38179 / 38271", "lib_modif_comment"=>NULL',1);
INSERT INTO urba_plui_ecriture.zoneurba (idurba,libelle,libelong,typezone,nomfic,urlfic,datevalid,geom,lib_idzone,lib_hstore,lib_id_version) VALUES
     ('MJ3_PH1_ZON_050_09','UE1','Activités productives et artisanales','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UE1.pdf','2019-12-20','SRID=3945;POLYGON ((1920861.51 4224963.65, 1920869.17 4224952.89, 1920872.81 4224947.8, 1920873.71 4224946.54, 1920877.32 4224948.94, 1920882.49 4224941.49, 1920885.44 4224937.25, 1920885.64 4224936.96, 1920891.63 4224941.02, 1920896.441264537 4224933.885223172, 1920901.5041518612 4224926.191504107, 1920885.74 4224915.45, 1920864.56 4224901.07, 1920837.86 4224940.93, 1920861.51 4224963.65))','ZO33313','"lib_modif"=>"N", "lib_code_insee"=>"38271", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','A','Agricole','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1918542.7357649347 4214471.226398357, 1918480.49 4214425.46, 1918371.03 4214338.8, 1918339.907945012 4214274.8442064095, 1918352.2924233791 4214248.256207527, 1918465.08 4214261.25, 1918476.46 4214270.03, 1918516.26 4214298.53, 1918526.639951831 4214304.831242915, 1918535.3149414388 4214392.605758855, 1918542.7357649347 4214471.226398357))','ZO33903','"lib_modif"=>"N", "lib_code_insee"=>"38252 / 38562", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','N','Naturelle','N',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/N.pdf','2019-12-20','SRID=3945;POLYGON ((1909404.1526717488 4212778.604332983, 1909399.7564378758 4212773.296437875, 1909400.4908659258 4212780.991293049, 1909404.104656814 4212795.148972632, 1909406.3495117947 4212806.497926604, 1909405.62 4212806.74, 1909379.07 4212811.62, 1909366.51 4212800.63, 1909338.56 4212790.09, 1909293.1 4212770.14, 1909274.41 4212773.74, 1909258.73 4212776.56, 1909217.79 4212746.68, 1909174.69 4212734.49, 1909161.61999993 4212682.510002141, 1909157.41 4212673.13, 1909128.9799999297 4212623.960002143, 1909096.8699999298 4212639.430002142, 1909075.7599999297 4212646.600002141, 1909061.1199999298 4212652.740002141, 1909044.97999993 4212626.410002141, 1909009.23999993 4212648.920002141, 1909003.77999993 4212642.800002141, 1908979.00999993 4212614.100002142, 1908984.6799999299 4212603.190002142, 1908982.85999993 4212599.9000021415, 1908970.9510273673 4212603.84154105, 1908965.891027297 4212604.8215431925, 1908940.51999993 4212607.660002141, 1908928.9399999299 4212609.490002142, 1908893.53999993 4212625.980002142, 1908887.51999993 4212624.280002141, 1908813.84999993 4212632.290002142, 1908803.39999993 4212631.160002141, 1908801.23999993 4212629.800002142, 1908794.30999993 4212620.730002142, 1908784.1899999299 4212594.62000214, 1908778.37999993 4212571.580002142, 1908776.87999993 4212552.740002144, 1908777.52999993 4212515.050002141, 1908780.4599999299 4212489.160002142, 1908797.58999993 4212467.120002143, 1908780.30999993 4212446.360002141, 1908826.37999993 4212416.470002143, 1908815.4599999296 4212394.910002143, 1908796.50999993 4212406.620002142, 1908781.5199999297 4212394.820002143, 1908774.1299999298 4212387.220002143, 1908774.2499999297 4212387.110002143, 1908773.78999993 4212386.660002142, 1908804.4199999298 4212357.450002142, 1908818.58999993 4212340.640002143, 1908828.3499999298 4212331.100002143, 1908834.8199999298 4212325.980002143, 1908853.6399999298 4212307.120002142, 1908848.52999993 4212300.650002142, 1908848.4199999298 4212300.310002141, 1908824.47999993 4212315.320002143, 1908827.76999993 4212319.180002142, 1908803.26999993 4212338.160002142, 1908773.38999993 4212313.89000214, 1908721.88999993 4212359.910002141, 1908716.2099999299 4212358.210002142, 1908702.6999999299 4212354.360002142, 1908701.21999993 4212353.910002142, 1908692.23999993 4212333.710002142, 1908691.09999993 4212329.960002142, 1908724.98999993 4212274.650002142, 1908736.77999993 4212256.590002141, 1908727.35999993 4212250.350002141, 1908743.4499999299 4212221.7300021425, 1908748.0999999298 4212214.920002143, 1908761.47999993 4212197.420002144, 1908759.77999993 4212195.490002142, 1908746.36999993 4212184.040002143, 1908702.59999993 4212235.160002142, 1908723.26999993 4212247.860002144, 1908715.78999993 4212266.370002143, 1908701.81999993 4212256.620002141, 1908669.15999993 4212297.860002142, 1908674.15999993 4212307.7300021425, 1908650.12999993 4212349.640002143, 1908618.78999993 4212338.880002141, 1908601.1899999299 4212333.110002142, 1908582.6799999299 4212327.110002142, 1908577.31999993 4212301.79000214, 1908579.6999999299 4212293.8500021435, 1908586.03999993 4212276.240002143, 1908571.38999993 4212267.180002143, 1908559.13999993 4212277.630002141, 1908541.2099999299 4212291.720002143, 1908508.37999993 4212268.360002143, 1908506.31999993 4212247.140002141, 1908508.9199999298 4212236.240002142, 1908509.9399999299 4212232.490002143, 1908545.56999993 4212208.620002143, 1908560.54999993 4212198.390002141, 1908563.49999993 4212197.700002142, 1908567.9199999298 4212196.570002142, 1908608.32999993 4212192.100002143, 1908622.62999993 4212188.690002143, 1908632.50999993 4212183.000002145, 1908637.50999993 4212189.580002144, 1908645.79999993 4212198.660002143, 1908650.6899999299 4212203.080002143, 1908684.83999993 4212176.030002143, 1908707.63999993 4212157.850002143, 1908711.26999993 4212155.010002142, 1908727.37999993 4212142.160002142, 1908739.62999993 4212134.090002143, 1908759.47999993 4212109.780002142, 1908765.36999993 4212097.290002144, 1908767.8699999298 4212097.970002143, 1908772.29999993 4212099.440002143, 1908776.49999993 4212101.820002142, 1908780.6999999299 4212104.660002141, 1908782.62999993 4212106.360002141, 1908791.48999993 4212107.940002142, 1908791.554878544 4212107.879227435, 1908791.44 4212107.85, 1908782.77 4212058.2, 1908798.6999999299 4212042.540002143, 1908805.98 4212013.89, 1908792.01 4211996.32, 1908805.46 4211981.75, 1908833.03 4211956.85, 1908788.55 4211917.15, 1908782.77 4211922.64, 1908758.65999993 4211945.860002143, 1908715.77999993 4211987.210002143, 1908691.82999993 4211991.780002143, 1908688.99999993 4212001.200002141, 1908678.6699999298 4212006.090002144, 1908671.84999993 4211992.250002142, 1908636.78999993 4212011.010002143, 1908610.08999993 4211988.670002145, 1908596.6799999299 4211975.170002145, 1908648.39999993 4211920.970002143, 1908658.60999993 4211911.090002144, 1908657.35999993 4211907.570002143, 1908655.08999993 4211903.490002143, 1908649.8499999298 4211892.250002143, 1908647.57999993 4211886.690002142, 1908646.53 4211882.68, 1908642.14 4211900.31, 1908614.05 4211908.33, 1908578.45 4211933.74, 1908572.19 4211946.4, 1908572.5236775493 4211948.392358314, 1908568.55 4211945.38, 1908569.63 4211952.06, 1908571.08 4211960.94, 1908557.84 4211979.9, 1908542.96 4212005.27, 1908486.7 4211997.16, 1908468.71 4211975.37, 1908468.84 4211967.47, 1908429.26 4211943.15, 1908457.98 4211933.85, 1908463.15 4211936.99, 1908469.56 4211937.98, 1908468.2 4211931.38, 1908459.75 4211920.58, 1908454.34 4211908.13, 1908465.8 4211901.37, 1908451.35 4211870.77, 1908447.85 4211863.98, 1908445.24 4211859.95, 1908458.63 4211854.03, 1908524.54 4211809.49, 1908519.78 4211803.77, 1908538.92 4211796.29, 1908543.0792748728 4211794.3589080945, 1908537.44 4211785.87, 1908509.24 4211750.46, 1908494.08 4211750.43, 1908478.76 4211750.56, 1908466.71 4211758.16, 1908436.46 4211777.67, 1908427.38 4211785.41, 1908437.25 4211793.15, 1908431.48 4211800.7, 1908420.93 4211814.53, 1908414.28 4211821.39, 1908401.18 4211836.65, 1908387.92 4211847.46, 1908385.13 4211849.47, 1908364.98 4211865.42, 1908361.21 4211870.02, 1908362.67 4211872.69, 1908383.91 4211893.69, 1908379.91 4211908.94, 1908362.46 4211930.08, 1908356.51 4211937.7, 1908355.21 4211946.8, 1908310.57 4211989.2, 1908309.04 4211996.49, 1908278.37 4212025.78, 1908276.27 4212027.46, 1908266.03 4212035.66, 1908231.5 4212036.25, 1908234.46 4212008.03, 1908264.37999993 4211956.950002144, 1908263.19 4211950.43, 1908258.97 4211943.29, 1908241.97 4211927.47, 1908253.38 4211904.82, 1908238.23 4211895.37, 1908199.88 4211924.19, 1908209.14 4211936.98, 1908203.36 4211945.22, 1908179.07 4211954.96, 1908180.04 4211960.05, 1908165.61 4211972.33, 1908155.5 4211977.47, 1908128.8 4212011.99, 1908104.23 4212000.63, 1908079.64 4211989.04, 1908079.79 4211986.27, 1908106.16 4211946.43, 1908097.97 4211933.61, 1908086.9 4211916.16, 1908088.957470227 4211905.791963759, 1908072.9133550648 4211903.990484329, 1908070.52 4211908.23, 1908060.32 4211918.93, 1908034.43 4211933.38, 1908022.76 4211917.88, 1908007.79 4211897.75, 1908008.2119973935 4211896.879080226, 1908003.5360126682 4211890.497264164, 1907996.92 4211906.75, 1907989.9 4211916.51, 1907976.69 4211907.87, 1907948.02 4211940.3, 1907950.16 4211940.89, 1907942.61 4211955.57, 1907861.73 4211934, 1907859.5 4211929.36, 1907835.13 4211908.82, 1907856.02 4211881.04, 1907825.32 4211854.03, 1907796.25 4211878.17, 1907785.03 4211844.96, 1907815.22 4211804.8, 1907834.9 4211780.25, 1907857.8199348063 4211750.124654496, 1907853.99 4211748.25, 1907807.0199999302 4211719.390002144, 1907824.32 4211688.71, 1907830 4211692.47, 1907837.31 4211697.49, 1907839.8 4211699.2, 1907858.87 4211685.65, 1907861.32 4211683.6, 1907861.51 4211683.44, 1907871.49 4211675.13, 1907877.53 4211669.73, 1907880.58 4211666.02, 1907881.56 4211664.83, 1907866.9 4211657.26, 1907858.22 4211651.86, 1907854.72 4211649.14, 1907854.82 4211647.39, 1907855.3 4211624.93, 1907855.63 4211609.61, 1907855.58 4211601.79, 1907855.8 4211599.14, 1907860.62 4211590.26, 1907837.9 4211577.76, 1907832.45 4211574.55, 1907815.55 4211564.5, 1907797.71 4211552.53, 1907777.39 4211538.57, 1907751.11 4211519.96, 1907747.8199999302 4211523.050002144, 1907745.20999993 4211524.520002143, 1907732.1599999303 4211533.3900021445, 1907729.5331140864 4211535.033361774, 1907728.31 4211532.42, 1907725.36 4211526.79, 1907716.97 4211506.52, 1907713.44 4211499.28, 1907704.97 4211484.24, 1907699.72 4211472.92, 1907693.97 4211462.52, 1907690.37 4211454.75, 1907682.15 4211440.06, 1907667.67 4211450.44, 1907648.38 4211464.1, 1907645.67 4211466.01, 1907642.69 4211468.12, 1907660.78 4211490.44, 1907662.5 4211492.62, 1907649.98 4211504.31, 1907643.67 4211510.5, 1907626.63 4211489.74, 1907611.32 4211516.02, 1907532.45 4211436.32, 1907533.51 4211432.31, 1907535.41 4211429.22, 1907541.05 4211421.64, 1907547.3 4211414.91, 1907550.74 4211411.52, 1907556.82 4211406.57, 1907559.39 4211403.52, 1907561.36 4211400.38, 1907567.1 4211406.55, 1907571.37 4211409.86, 1907573.51 4211410.95, 1907578.53 4211413.52, 1907582.09 4211414.62, 1907586.15 4211415.38, 1907586.64 4211415.14, 1907592.26 4211412.48, 1907612.2400000698 4211402.969997855, 1907610.96 4211400.05, 1907605.97 4211401.45, 1907604.03 4211401.54, 1907602.22 4211400.92, 1907598.63 4211398.98, 1907596.41 4211397.34, 1907593.89 4211394.88, 1907592.08 4211393.5, 1907589.55 4211392.75, 1907589.72 4211389.65, 1907589.945687184 4211385.738088808, 1907586.34 4211387.15, 1907582.87 4211387.99, 1907569.7 4211389.69, 1907569.2 4211389.76, 1907566.38 4211391.33, 1907566.6 4211387.73, 1907557.01 4211387.03, 1907539.74 4211386.49, 1907538 4211386.59, 1907530.54 4211384.47, 1907527.09 4211385.12, 1907522.46 4211388.42, 1907501.47 4211392.63, 1907493.74 4211396.32, 1907490.2 4211397.95, 1907488.02 4211398.73, 1907471.83 4211403.05, 1907467.89 4211405.07, 1907464.6 4211408.37, 1907460.91 4211413.01, 1907449.64 4211429.75, 1907446.43 4211431.7, 1907429.44 4211443.11, 1907425.63 4211445.64, 1907418.76 4211450.23, 1907408.35 4211442.83, 1907395.84 4211441.21, 1907386.95 4211438.66, 1907384.3 4211441.56, 1907378.81 4211452.74, 1907378.72 4211463.17, 1907369.08 4211463.35, 1907362.96 4211464.36, 1907356.58 4211466.17, 1907343.74 4211470.25, 1907343.22 4211468.61, 1907334.19 4211448.56, 1907331.69 4211444.03, 1907330.43 4211441.05, 1907330.98 4211438.33, 1907335.1 4211432.64, 1907343.5 4211422.97, 1907348.2 4211418.3, 1907381.86 4211394.22, 1907392.95 4211384.64, 1907397.65 4211381.73, 1907402.82 4211378.67, 1907416.61 4211361.75, 1907420.63 4211357.99, 1907430.72 4211349.89, 1907436.57 4211345.2, 1907433.3509774038 4211339.390941003, 1907444.3642317753 4211330.442486941, 1907462.25 4211315.91, 1907467.23 4211308.47, 1907474.6 4211295.93, 1907475.95 4211247.29, 1907477.6533115571 4211248.745466392, 1907477.7387662812 4211244.301574712, 1907478.384416801 4211235.494075809, 1907479.13287575 4211228.96501683, 1907479.113778029 4211222.530192443, 1907476.98 4211222.26, 1907474.44 4211214.15, 1907472.18 4211207.79, 1907451.62 4211195.65, 1907444.81 4211192.74, 1907423.79 4211184.31, 1907419.52 4211181.95, 1907415.18 4211179.26, 1907412.02 4211176.46, 1907401.39 4211165.32, 1907395.92 4211158.36, 1907390.17 4211152.2, 1907388.23 4211148.8, 1907387.15 4211145.64, 1907385.6400000695 4211139.079997854, 1907385.12 4211135.69, 1907397.68 4211135.12, 1907396.13 4211111.43, 1907391.5 4211111.61, 1907388.08 4211111.58, 1907387.01 4211116.93, 1907384.94 4211121.8, 1907381.42 4211125.41, 1907379.93 4211126.61, 1907377.42 4211127.84, 1907374.42 4211128.45, 1907366.44 4211129.14, 1907353.33 4211131.11, 1907346.83 4211132.68, 1907340.02 4211133.83, 1907335.12 4211134.23, 1907327.73 4211133.98, 1907324.66 4211133.68, 1907321.02 4211132.82, 1907313.23 4211089.6, 1907274.41 4211105.26, 1907261.73 4211102.1, 1907258.11 4211099.91, 1907249.89 4211094.29, 1907247.5 4211093.47, 1907233.76 4211091.03, 1907231.56 4211090.21, 1907223.97 4211086.08, 1907218.11 4211084.13, 1907214.62 4211083.57, 1907205.67 4211054.8, 1907234.06 4211053.96, 1907256.6 4211041.54, 1907254.93 4211037.15, 1907241.98 4211042.92, 1907228.55 4211010.2, 1907227.9329454363 4211008.724872088, 1907231.4414546208 4211009.274496567, 1907231.11 4211008.03, 1907222.04 4210978.96, 1907216.76 4210964.83, 1907214.45 4210959.28, 1907214.25 4210958.81, 1907208.96 4210946.09, 1907203.56 4210937.23, 1907186.46 4210918.52, 1907184.93 4210916.85, 1907183.4 4210915.16, 1907181.75 4210913.37, 1907188.84 4210910.96, 1907192.25 4210907.7, 1907193.04 4210906.95, 1907195.9 4210904.22, 1907198.71 4210897.22, 1907200.33 4210893.2, 1907200.79 4210891.02, 1907202.88 4210878.19, 1907203.14 4210869.25, 1907203.02 4210867.09, 1907203.39 4210859.03, 1907203.61 4210854.5, 1907201.56 4210849.34, 1907204.15 4210845.03, 1907204.16 4210824.32, 1907204.17 4210812.79, 1907204.17 4210811.42, 1907204.18 4210810.52, 1907214.92 4210793.08, 1907219.35 4210785.91, 1907220.23 4210784.47, 1907224.41 4210769.07, 1907224.7 4210768.03, 1907225.55 4210764.85, 1907225.91 4210763.5, 1907226.55 4210761.32, 1907225.4 4210757.95, 1907218.39 4210737.54, 1907218.06 4210736.56, 1907216.94 4210733.3, 1907216.57 4210732.23, 1907216.52 4210732.1, 1907216.2421747402 4210731.124075808, 1907186.6620883958 4210738.28455583, 1907186.23 4210736.61, 1907181.02 4210724.57, 1907177.6 4210718.13, 1907173.16 4210708.37, 1907171.68 4210706.38, 1907168.1 4210702.63, 1907166 4210701.26, 1907163.18 4210699.8, 1907159.62 4210698.95, 1907156.11 4210698.53, 1907150.77 4210699.02, 1907126.99 4210654.5, 1907123.54 4210647.97, 1907122.9022947457 4210646.758698961, 1907116.1215073897 4210650.723288452, 1907109.9384926104 4210650.457397921, 1907087.6279452655 4210649.322741107, 1907075.7750695138 4210654.863288452, 1907021.8056168586 4210656.175069514, 1906989.4543831416 4210673.679659005, 1906965.1986989605 4210682.0930147795, 1906939.2745583055 4210692.198939661, 1906938.82 4210690.23, 1906936.38 4210676.1, 1906916.52 4210674.01, 1906918.42 4210651.37, 1906921.63 4210651.4, 1906956.45 4210652.12, 1906955.43 4210647.62, 1907024.75 4210612.73, 1907064.5099999304 4210579.3400021475, 1907096.43 4210530.65, 1907082.76 4210526.46, 1907050.79 4210515.71, 1907040.34 4210512.42, 1907032.98 4210497.83, 1907024.68 4210495.62, 1907011.89 4210491.67, 1907009.42 4210479.89, 1906997.72 4210473.81, 1907007.47 4210457.87, 1907028.03 4210452.48, 1907024.35 4210433.43, 1907023.6512161868 4210428.620273672, 1907061.2908210172 4210423.414517786, 1907076.7547958412 4210426.665751504, 1907085.353974824 4210430.68260208, 1907125.6138357965 4210451.801094689, 1907138.3103111072 4210457.164056211, 1907166.387397921 4210466.629313627, 1907185.9265314874 4210473.295244028, 1907188.2152457428 4210471.10685961, 1907189.42 4210471.48, 1907213.09 4210481.35, 1907213.78 4210481.6, 1907214.46 4210481.84, 1907220.59 4210484.34, 1907237.52 4210489.43, 1907244.91 4210492.67, 1907244.94 4210493, 1907245.61 4210495.17, 1907250.22 4210502.22, 1907253.858705247 4210511.726751129, 1907257.2969146597 4210512.2594988765, 1907289.54 4210517.99, 1907298.71 4210516.37, 1907315.64 4210516.05, 1907320.89 4210514.54, 1907368.6384619698 4210515.589087362, 1907369.2699999302 4210520.390002147, 1907372.5899999302 4210547.9700021455, 1907373.7399999304 4210560.910002145, 1907373.7399999301 4210561.250002147, 1907373.7399999301 4210561.370002147, 1907373.6199999303 4210561.820002147, 1907372.93999993 4210563.750002148, 1907371.5799999302 4210566.820002147, 1907370.3399999302 4210570.110002147, 1907368.17999993 4210570.340002145, 1907366.3599999303 4210570.450002147, 1907358.1899999303 4210570.690002145, 1907357.6199999303 4210570.920002147, 1907357.16999993 4210571.140002148, 1907355.68999993 4210572.280002148, 1907354.3299999302 4210572.730002147, 1907352.8599999303 4210572.960002147, 1907349.3399999302 4210573.420002148, 1907346.0499999302 4210573.540002148, 1907343.8899999303 4210573.310002147, 1907341.7299999301 4210572.520002148, 1907338.43999993 4210572.750002148, 1907327.5399999302 4210572.870002147, 1907317.7799999302 4210574.240002148, 1907310.8599999303 4210575.160002149, 1907307.6799999303 4210575.390002145, 1907296.20999993 4210577.440002147, 1907295.06 4210577.79, 1907295.88 4210579.28, 1907297.93 4210583.38, 1907299.37 4210583.37, 1907322.67 4210583.05, 1907340.17 4210582.89, 1907351.02 4210581.7, 1907407.25 4210583.82, 1907410.66 4210583.51, 1907414.02 4210582.94, 1907426.5699999302 4210612.9700021455, 1907427.0199999302 4210614.450002148, 1907427.2499999304 4210614.900002146, 1907427.4799999301 4210615.700002148, 1907431.68999993 4210623.640002146, 1907438.1599999303 4210633.630002146, 1907421.2599999302 4210640.560002148, 1907426.1399999303 4210647.710002147, 1907436.3699999303 4210661.210002146, 1907452.3999999303 4210681.970002148, 1907454.5599999302 4210684.360002146, 1907456.5999999302 4210686.170002146, 1907496.70999993 4210730.3000021465, 1907507.5999999302 4210721.320002148, 1907523.4799999301 4210708.360002149, 1907527.7999999302 4210704.840002147, 1907529.6099999305 4210703.250002147, 1907533.2399999301 4210700.410002147, 1907539.70999993 4210694.960002147, 1907539.8199999302 4210695.070002146, 1907539.92999993 4210694.960002146, 1907546.9799999301 4210699.380002147, 1907552.0899999302 4210702.550002147, 1907568.66999993 4210712.870002147, 1907586.34 4210724.52, 1907601.92 4210734.49, 1907626.66 4210747.09, 1907632.72 4210750.06, 1907640.43 4210753.22, 1907643.49 4210753.86, 1907653.18 4210754.09, 1907656 4210753.43, 1907663.62 4210756.23, 1907678.43 4210764.79, 1907682.33 4210766.81, 1907684.69 4210768.13, 1907698.37 4210776.92, 1907715.46 4210786.83, 1907719.15 4210794.39, 1907719.51 4210795.06, 1907725.02 4210791.41, 1907725.2 4210791.29, 1907726.31 4210791.62, 1907779.12 4210807.76, 1907791.91 4210815.47, 1907919.6 4210948.41, 1907921.22 4210949.76, 1907924.7799999302 4210958.340002146, 1907924.99999993 4210959.020002149, 1907925.3399999302 4210959.820002145, 1907925.68999993 4210960.610002144, 1907925.9099999303 4210960.840002147, 1907926.4799999301 4210962.090002145, 1907926.81999993 4210962.540002146, 1907927.1599999303 4210963.110002146, 1907930.45999993 4210967.420002146, 1907930.7999999302 4210967.760002145, 1907931.0299999302 4210968.210002146, 1907931.4799999301 4210968.440002145, 1907933.63999993 4210970.600002145, 1907934.20999993 4210971.050002146, 1907934.7799999302 4210971.500002146, 1907935.45999993 4210972.070002146, 1907946.31 4210983.09, 1907953.08 4210992.46, 1907959.92 4211001.4, 1907964.62 4211005.44, 1907969.31 4211008.62, 1907979.28 4211014.33, 1907984.05 4211016.66, 1907987.28 4211018.68, 1907996.74 4211025.49, 1908002.65 4211031.21, 1908008.44 4211036.09, 1908019.53 4211043.38, 1908025.83 4211046.73, 1908030.77 4211048.99, 1908041.24 4211055.11, 1908062.78 4211066.32, 1908065.94 4211068.33, 1908071.22 4211072.62, 1908076.01 4211077.42, 1908078.83 4211079.94, 1908081.81 4211082.22, 1908085.48 4211084.39, 1908089.99 4211087.59, 1908095.88 4211090.77, 1908106.76 4211095.02, 1908110.59 4211097.36, 1908113.5 4211100.74, 1908116.76 4211105.12, 1908118.92 4211109.95, 1908124.49 4211118.55, 1908141.83 4211136.07, 1908162.25 4211156.29, 1908165.09 4211161.52, 1908175.04 4211177.41, 1908182.69 4211190.92, 1908183.22 4211193.54, 1908183.23 4211194.39, 1908182.55999993 4211197.200002145, 1908181.98 4211198.64, 1908180.3 4211201.46, 1908183.43 4211200.25, 1908192.9 4211194.92, 1908195.09 4211193.46, 1908200.24 4211188.93, 1908204.38 4211186.36, 1908208.63 4211183.71, 1908211.88 4211184.08, 1908218.71 4211183.26, 1908224.26 4211184.43, 1908227.36 4211186, 1908241.33 4211197.09, 1908241.94 4211196, 1908239.65 4211190.94, 1908237.43 4211186.73, 1908230.1 4211176.06, 1908222.7 4211166.15, 1908212.15 4211152.44, 1908208.16 4211147.55, 1908200.22 4211138.89, 1908183.32 4211123.04, 1908187.14999993 4211117.510002145, 1908153.39999993 4211081.550002146, 1908141.46999993 4211066.910002147, 1908139.4299999299 4211064.760002146, 1908136.35999993 4211061.010002146, 1908133.73999993 4211057.270002146, 1908131.5799999302 4211052.850002144, 1908123.74999993 4211051.260002146, 1908111.49999993 4211063.990002145, 1908100.12999993 4211051.060002146, 1908099.1099999303 4211047.200002144, 1908098.87999993 4211046.400002146, 1908098.6499999303 4211045.610002145, 1908098.19999993 4211044.810002145, 1908097.8599999303 4211044.130002146, 1908097.39999993 4211043.450002147, 1908096.83999993 4211042.880002146, 1908096.71999993 4211042.660002147, 1908091.60999993 4211037.330002147, 1908091.4999999302 4211037.210002146, 1908091.2699999302 4211036.990002146, 1908091.0399999302 4211036.870002145, 1908088.5399999302 4211034.600002145, 1908087.8599999303 4211034.040002146, 1908087.28999993 4211033.580002147, 1908086.60999993 4211033.240002146, 1908085.58999993 4211032.680002146, 1908085.01999993 4211032.450002146, 1908084.56999993 4211032.220002146, 1908083.99999993 4211032.000002147, 1908080.47999993 4211030.750002146, 1908080.13999993 4211030.6400021445, 1908079.7999999302 4211030.530002145, 1908079.4599999299 4211030.410002145, 1908076.95999993 4211029.850002145, 1908076.15999993 4211029.730002147, 1908075.36999993 4211029.620002146, 1908074.90999993 4211029.620002145, 1908069.9199999298 4211027.130002146, 1908055.03999993 4211018.170002147, 1908043.22999993 4211011.820002146, 1908032.8899999303 4211005.140002145, 1908031.0699999302 4211002.640002145, 1908030.61999993 4211002.190002147, 1908026.8699999303 4210998.670002146, 1908026.29999993 4210998.220002146, 1908025.61999993 4210997.760002146, 1908024.9399999299 4210997.200002147, 1908024.7099999299 4210997.080002147, 1908023.45999993 4210996.400002145, 1908022.77999993 4210996.060002145, 1908021.97999993 4210995.840002145, 1908021.0799999302 4210995.610002147, 1908020.95999993 4210995.500002147, 1908019.13999993 4210995.040002147, 1908018.34999993 4210995.040002146, 1908000.62999993 4210985.300002146, 1907997.10999993 4210981.670002146, 1907989.9599999299 4210978.150002147, 1907968.12999993 4210949.560002146, 1907963.58999993 4210943.780002147, 1907961.08999993 4210942.530002147, 1907956.99999993 4210938.450002146, 1907953.47999993 4210932.890002146, 1907949.4899999301 4210922.220002145, 1907949.48999993 4210922.450002147, 1907949.3799999303 4210921.990002146, 1907949.26999993 4210921.770002148, 1907948.46999993 4210918.9300021455, 1907948.4699999301 4210918.700002144, 1907948.3499999302 4210918.480002147, 1907948.2399999301 4210918.140002145, 1907946.52999993 4210913.600002145, 1907946.30999993 4210913.030002147, 1907945.84999993 4210912.460002146, 1907945.5099999302 4210911.890002146, 1907943.80999993 4210909.170002147, 1907943.5799999302 4210908.7200021455, 1907943.23999993 4210908.490002147, 1907943.00999993 4210907.920002147, 1907941.64999993 4210906.330002147, 1907941.3099999302 4210906.110002144, 1907941.0799999302 4210905.880002146, 1907940.7399999301 4210905.430002146, 1907939.48999993 4210904.520002147, 1907932.54999993 4210893.740002146, 1907924.1399999303 4210879.100002146, 1907919.9399999299 4210873.660002148, 1907911.4099999303 4210865.380002146, 1907900.9599999299 4210854.720002146, 1907896.31 4210848.44, 1907889.0300000003 4210831.069999998, 1907884.69999993 4210820.450002147, 1907875.14999993 4210808.530002148, 1907867.0799999302 4210799.000002147, 1907860.14999993 4210790.040002146, 1907848.33999993 4210781.990002145, 1907835.3899999303 4210774.970002145, 1907820.39999993 4210769.420002148, 1907800.0799999302 4210766.1400021445, 1907798.5999999302 4210765.910002147, 1907794.16999993 4210763.870002146, 1907789.3999999303 4210761.840002147, 1907779.7499999302 4210757.080002146, 1907778.4999999302 4210756.400002147, 1907769.51999993 4210748.800002147, 1907752.0299999302 4210738.370002146, 1907741.92999993 4210734.970002145, 1907731.4799999301 4210729.420002145, 1907716.3699999303 4210722.160002147, 1907690.92999993 4210711.5100021465, 1907669.69999993 4210704.830002145, 1907656.18999993 4210700.310002147, 1907643.5799999302 4210698.840002147, 1907642.8999999303 4210698.500002147, 1907642.67999993 4210698.270002148, 1907634.7299999301 4210694.530002148, 1907631.0899999302 4210691.930002146, 1907618.2499999302 4210682.740002146, 1907607.3499999302 4210678.550002146, 1907596.7899999302 4210668.910002148, 1907574.6299999303 4210649.400002148, 1907566.3399999302 4210642.940002146, 1907552.93999993 4210633.980002146, 1907544.7599999302 4210629.790002149, 1907528.6399999303 4210625.830002147, 1907515.15 4210620.11, 1907512.7 4210618.45, 1907502.56 4210607.64, 1907501.71 4210605.02, 1907498.5299999302 4210604.060002146, 1907498.0799999302 4210603.940002146, 1907494.2199999301 4210602.360002148, 1907493.9899999301 4210602.250002147, 1907493.6499999303 4210602.020002148, 1907493.41999993 4210601.910002147, 1907488.3099999302 4210600.0900021475, 1907483.61 4210594.68, 1907481.32 4210588.88, 1907476.1 4210564.57, 1907483.54 4210563.71, 1907488.08 4210563.16, 1907521.67 4210562.74, 1907574.55 4210559.24, 1907615.16 4210556.63, 1907634.68 4210554.69, 1907638.3 4210555.81, 1907638.99 4210556.2, 1907643.06 4210557.46, 1907652.37 4210561.96, 1907654 4210563.19, 1907662.42 4210520.64, 1907678.42 4210486.7, 1907689.39 4210463.04, 1907690.2599999302 4210449.840002146, 1907680.49 4210443.93, 1907659.9 4210430.75, 1907646.45 4210421.46, 1907617.1 4210401.63, 1907607.86 4210395.01, 1907615.79 4210356.55, 1907618.48 4210341.75, 1907631.36 4210345.73, 1907635.23 4210346.41, 1907649.03 4210349.85, 1907654.23 4210351.78, 1907660.23 4210352.89, 1907674.76 4210357.33, 1907678.35 4210358.13, 1907684.9 4210359.01, 1907689.79 4210360.58, 1907692.99 4210361.21, 1907698.36 4210361.61, 1907701.41 4210361.49, 1907707.2 4210362.53, 1907717.13 4210362.5, 1907723.99 4210362.12, 1907732.49000007 4210361.119997851, 1907743.37 4210359.34, 1907756.04 4210358.85, 1907766.93 4210357.61, 1907771.73 4210356.61, 1907772.5 4210370.3, 1907774.92 4210380.55, 1907776.58 4210389.31, 1907778.19 4210395.99, 1907786.74 4210402.07, 1907788.57 4210420.38, 1907790.1930763486 4210433.30393504, 1907805.12 4210434.41, 1907859.37 4210411.08, 1907875.92 4210480.41, 1907880.71 4210478.87, 1907912.18 4210468.75, 1907917.3 4210467.1, 1907925.99 4210494.32, 1907955.28 4210503.08, 1907952.32 4210514.57, 1907961.99 4210523.48, 1907979.14 4210541.37, 1907986.76 4210549.44, 1907993.94 4210562, 1907996.06 4210574.58, 1907998.65 4210576.04, 1908019.76 4210553.49, 1908035.07 4210527.8, 1908035.64 4210526.42, 1908040.79 4210517.95, 1908063.22 4210508.36, 1908086.1538720455 4210498.307179407, 1908088.14 4210491.73, 1908091.85 4210488.63, 1908092.39 4210488.19, 1908092.67 4210487.96, 1908111.99 4210472.13, 1908127.44 4210459.41, 1908137.73 4210450.76, 1908148.25 4210442.68, 1908152.3 4210440.68, 1908174.13 4210433.15, 1908177.19 4210431.89, 1908177.57 4210393.28, 1908179.09 4210386.3, 1908182.38 4210380.05, 1908189.03 4210368.51, 1908199.29 4210370.48, 1908244.67 4210312.99, 1908252.23 4210300.9, 1908280.01 4210258.01, 1908281.82 4210264.75, 1908284.69 4210274.49, 1908287.84 4210284.11, 1908289 4210288.52, 1908289.7 4210298.49, 1908289.83 4210305.94, 1908289.62 4210312.54, 1908289.4057953628 4210315.482879621, 1908293.44 4210316.67, 1908292.01 4210342.84, 1908285.56 4210362.77, 1908284.63 4210364.45, 1908281.88 4210368.84, 1908279.27 4210371.22, 1908261.44 4210390.8, 1908251.8 4210400.64, 1908260.29 4210410.17, 1908260.94 4210412.51, 1908262.86999993 4210447.200002148, 1908263.19 4210453.14, 1908263.33 4210459.43, 1908264.03 4210461.1, 1908270.84 4210468.55, 1908279.7 4210477.77, 1908300.87 4210448.51, 1908319.64 4210421.71, 1908332.5 4210429.61, 1908331.68 4210432.71, 1908349.92 4210443.76, 1908367.74 4210454.18, 1908353.88 4210483.03, 1908380.22 4210497.91, 1908403.04 4210510.18, 1908395.68 4210544.49, 1908390.26 4210558.62, 1908386.21 4210568.93, 1908384.43 4210573.73, 1908382.54 4210579.41, 1908385.02 4210580.67, 1908386.97 4210581.5, 1908442.48 4210607.8, 1908466.65 4210619.02, 1908470.91 4210603.26, 1908470.98 4210601.44, 1908486.42 4210608.1, 1908493.67 4210610.66, 1908506.72 4210614.24, 1908516.4 4210617.57, 1908521.7 4210618.16, 1908550.84 4210610.21, 1908550.35 4210608.63, 1908577.88 4210600.7, 1908599.54 4210639.02, 1908607.2 4210654.44, 1908623.93 4210686.32, 1908638.92 4210715.16, 1908646.98 4210736.29, 1908652.78 4210740.39, 1908654.66 4210742.1, 1908657.29 4210744.5, 1908659.31 4210746.35, 1908696.85 4210780.58, 1908697.9499999296 4210781.490002147, 1908704.6499999298 4210786.710002146, 1908712.3699999298 4210793.400002146, 1908714.7599999297 4210795.2200021455, 1908718.26999993 4210782.270002146, 1908719.23960819 4210779.256693717, 1908724.3188953374 4210781.422473203, 1908733.0199999297 4210770.790002147, 1908745.4799999297 4210743.200002147, 1908762.9799999297 4210764.410002147, 1908764.2299999297 4210766.110002148, 1908764.9099999298 4210766.790002147, 1908791.22999993 4210739.980002145, 1908795.4199999296 4210735.770002147, 1908838.3099999297 4210711.100002146, 1908834.3299999298 4210701.910002147, 1908814.3099999297 4210653.450002147, 1908822.0299999297 4210649.360002147, 1908824.4099999298 4210648.110002147, 1908833.7199999297 4210642.880002148, 1908839.04999993 4210640.040002146, 1908844.6099999298 4210636.850002146, 1908858.5699999298 4210630.600002146, 1908875.35999993 4210622.520002147, 1908891.8199999298 4210614.340002147, 1908900.1099999298 4210617.510002146, 1908907.5999999298 4210620.340002147, 1908929.8599999298 4210628.830002147, 1908934.5099999297 4210627.580002147, 1908940.1899999296 4210625.990002148, 1908947.5599999297 4210623.82000215, 1908962.67 4210650.92, 1908972.41 4210645.87, 1908974.54 4210649.17, 1908983 4210645.92, 1908989.58 4210657.29, 1908989.76 4210657.62, 1908995 4210652.61, 1909004.63 4210642.28, 1909022.02 4210623.64, 1909025.98 4210618.23, 1909033.93 4210608.77, 1909078.37 4210618.19, 1909081.68 4210621.64, 1909063.51 4210663.83, 1909028.02 4210745.35, 1909031.78 4210754.31, 1909045.16 4210767.88, 1909056.39 4210779.16, 1909057.43 4210780.19, 1909063.6 4210786.48, 1909083.63 4210806.22, 1909099.89 4210822.54, 1909117.93 4210841.31, 1909118 4210841.4, 1909138.2599999295 4210865.920002147, 1909146.7 4210876.24, 1909149.98 4210880.19, 1909155.57 4210886.81, 1909169.45 4210903.89, 1909184.55 4210922.14, 1909184.95 4210923.12, 1909194.27 4210951.85, 1909195.18 4210954.82, 1909195.24 4210955.07, 1909203.04 4210967.03, 1909205.26 4210969.15, 1909205.86 4210969.74, 1909206.36 4210970.2, 1909206.56 4210970.39, 1909207.7 4210971.49, 1909208.04 4210971.82, 1909208.26 4210972.03, 1909208.68 4210972.43, 1909209.03 4210972.77, 1909209.46 4210973.18, 1909216.18 4210979.63, 1909221.16 4210984.42, 1909229.66 4210992.58, 1909236.53 4210998.83, 1909249.14 4211008.46, 1909255.86 4211012.65, 1909259.98 4211015.66, 1909266.39 4211020.1, 1909272.06 4211024.16, 1909277.79 4211028.9, 1909282.76 4211035.29, 1909286.68 4211041.37, 1909289.33 4211044.83, 1909292.68 4211048.76, 1909294.12 4211050.44, 1909296.07 4211052.56, 1909296.38 4211053.03, 1909300.33 4211060.94, 1909301.12 4211062.84, 1909303.21 4211070.26, 1909304.95 4211075.66, 1909305.15 4211076.35, 1909307.9 4211083.91, 1909310.39 4211089.31, 1909313.67 4211092.74, 1909326.71 4211107.14, 1909328.58 4211109.73, 1909331.95 4211113.59, 1909335.96 4211119.34, 1909338.14 4211123.17, 1909338.27 4211124.12, 1909339.96 4211132.04, 1909340 4211132.31, 1909340.96 4211135.04, 1909343.17 4211141.8, 1909343.28 4211141.92, 1909347.66 4211149.64, 1909349.8 4211153.59, 1909349.93 4211153.85, 1909368.85 4211188.55, 1909378.34 4211202.82, 1909387.89 4211215.23, 1909387.97 4211215.43, 1909389.28 4211218.18, 1909391.28 4211220.12, 1909392.62 4211221.61, 1909392.71 4211221.71, 1909394.64 4211224.35, 1909413.28 4211250.38, 1909418.91 4211259.02, 1909421.05 4211262.5, 1909424.3 4211268.56, 1909435.64 4211296.12, 1909436.69 4211298.4, 1909436.76 4211299.84, 1909438.04 4211301.31, 1909438.39 4211301.69, 1909461.35 4211327.82, 1909477.5399999297 4211348.670002145, 1909484.64 4211357.84, 1909488.51 4211363.11, 1909504.62 4211387.22, 1909511.62 4211396.86, 1909511.68 4211396.95, 1909522.73 4211412.63, 1909528.63 4211421.46, 1909529.96 4211424.5, 1909530.71 4211426.23, 1909531.74 4211429.17, 1909533.42 4211435.38, 1909533.48 4211435.56, 1909539.37 4211455.29, 1909540.02 4211456.3, 1909537.73 4211458.29, 1909533.5 4211461.7, 1909527.69 4211466.8, 1909511.68 4211482.6, 1909504.78 4211491.91, 1909503.49 4211495.15, 1909502.96 4211499.1, 1909501.96 4211501.28, 1909501.35 4211501.61, 1909501.9999999993 4211503.914999987, 1909505.0700000066 4211503.379999983, 1909505.2068031323 4211504.951033123, 1909513.353286556 4211511.193855051, 1909524.244181288 4211520.3751871865, 1909532.105934778 4211529.613475637, 1909535.3878639252 4211527.595552332, 1909535.4 4211527.58, 1909578.39 4211490.73, 1909579.99 4211489.34, 1909588.28 4211500.91, 1909596.98 4211514.25, 1909599.18 4211517.17, 1909606.73 4211523.75, 1909605.2 4211525.1, 1909610.86 4211530.05, 1909618.18 4211537.41, 1909627.5699999295 4211549.480002144, 1909631.4299999294 4211554.700002144, 1909649.5099999297 4211581.590002144, 1909654.8499999295 4211588.740002146, 1909669.5099999297 4211606.890002143, 1909672.4599999294 4211610.860002144, 1909680.5299999295 4211621.290002146, 1909686.2199999294 4211630.370002143, 1909700.7699999295 4211651.4700021455, 1909706.8999999296 4211660.440002144, 1909725.5499999295 4211688.120002143, 1909728.7299999294 4211692.430002144, 1909739.5199999295 4211706.500002144, 1909741.9099999296 4211709.560002145, 1909750.6599999296 4211722.160002145, 1909761.2299999294 4211738.270002144, 1909770.74 4211752.71, 1909777.85 4211763.83, 1909783.98 4211773.58, 1909790.41 4211784.06, 1909808.99 4211813.88, 1909812.46 4211819.42, 1909846.03 4211872.64, 1909849.64 4211876.91, 1909851.5 4211878.79, 1909853.2763044706 4211877.089377674, 1910100.8201075196 4211924.997084582, 1910129.975364623 4211930.552409102, 1910129.792797326 4211930.129607601, 1910136.0791038817 4211931.243229198, 1910020.564365332 4211662.239151255, 1909917.0948003347 4211422.88257129, 1909852.1947644348 4211272.4731025575, 1909821.5139380442 4211206.933827445, 1909744.9328578957 4211108.526417216, 1909715.4791565356 4211033.075589914, 1909663.8352863165 4210991.287968495, 1909632.986399024 4210913.68038782, 1909599.32320406 4210824.987386766, 1909596.1814778908 4210806.519259455, 1909591.5368991047 4210763.414664109, 1909583.9208802632 4210737.960856853, 1909575.4242751126 4210721.4869989455, 1909529.8233990371 4210664.561654657, 1909501.1935411282 4210624.30198985, 1909485.5756366032 4210599.531818937, 1909464.7062324174 4210559.718754807, 1909437.3538764578 4210528.018075163, 1909426.3446043585 4210515.258610916, 1909420.9408406226 4210502.352026363, 1909409.0370902626 4210486.697564163, 1909395.1566492554 4210468.992865176, 1909381.1835872938 4210440.990150307, 1909368.5644673035 4210412.776941913, 1909349.8569038224 4210362.510482545, 1909342.8676813063 4210341.986534554, 1909339.1795069664 4210335.406139396, 1909315.4626034156 4210305.607385306, 1909312.8223497586 4210302.290077493, 1909295.5144156376 4210278.073680745, 1909274.65321832 4210250.665782961, 1909260.337856795 4210217.3940343475, 1909228.2747709888 4210181.7339278925, 1909220.592333194 4210170.859174829, 1909213.2769763402 4210157.706722939, 1909212.3939219797 4210155.812267753, 1909208.578768083 4210143.544659772, 1909200.3242185486 4210116.925981101, 1909191.2944006566 4210110.206142833, 1909181.9568834137 4210092.863733122, 1909111.0066659376 4209952.882369414, 1909071.160241838 4209951.910181155, 1909069.9795217968 4209949.147928082, 1909069.631182777 4209949.153772408, 1909066.3925155583 4209940.756252953, 1909059.637739645 4209923.412687623, 1909038.2158643599 4209885.861540269, 1909004.3255170684 4209885.395981989, 1909002.3414807164 4209882.153710652, 1909001.6921029815 4209881.11564171, 1908973.5943274768 4209836.211226508, 1908966.2086102478 4209823.430643454, 1908941.650765469 4209777.782442929, 1908936.8117000572 4209771.585302434, 1908936.5315079188 4209771.203780451, 1908929.5398212443 4209763.430931475, 1908927.6977108195 4209759.388580922, 1908924.8815918434 4209750.228359164, 1908918.477529924 4209710.956560375, 1908879.5749492485 4209600.794275112, 1908854.2404178581 4209552.6554740695, 1908849.1062044853 4209548.000217259, 1908847.9498420176 4209547.052878842, 1908844.0054075825 4209545.014384926, 1908830.3744547837 4209538.028926101, 1908826.5505906106 4209537.150014494, 1908780.3507736924 4209530.36146786, 1908775.9673210904 4209528.683062095, 1908736.864323965 4209487.765401045, 1908676.8180886689 4209446.415179369, 1908623.9741410501 4209412.0921512, 1908590.1255491704 4209381.588407067, 1908494.6608351546 4209347.128245747, 1908479.913986865 4209344.409696757, 1908451.848478112 4209340.289077656, 1908420.3032146557 4209380.187736538, 1908413.2143784477 4209374.770932837, 1908412.431423424 4209374.18820122, 1908375.6944450573 4209346.914139651, 1908352.8990414836 4209329.9740207335, 1908352.0127940432 4209330.378507108, 1908347.2785579152 4209326.945701056, 1908264.0516436854 4209365.155927894, 1908238.4131533084 4209439.383854733, 1908146.780322448 4209402.44986017, 1908146.4163676016 4209402.156137523, 1908138.5061480568 4209395.344622476, 1908102.2621803007 4209301.70541004, 1908093.5280499249 4209294.726326862, 1908066.9886941658 4209283.087122034, 1908062.0028797092 4209280.948186181, 1907998.6917657573 4209219.855993742, 1907997.7271370844 4209220.641628668, 1907974.703647448 4209221.425321245, 1907971.4504913602 4209223.522730416, 1907942.5184947108 4209148.466768372, 1907875.7319481943 4208990.10206789, 1907825.6950346748 4208831.415565857, 1907783.1348060903 4208587.226701553, 1907777.7995363257 4208588.102526698, 1907777.2827165022 4208585.317966736, 1907692.8913884833 4208601.085987183, 1907658.4027774935 4208616.889528267, 1907655.5112226803 4208616.763920033, 1907652.2041205775 4208616.72314221, 1907638.9012203128 4208609.643374786, 1907633.8170405012 4208608.329987421, 1907629.1847671592 4208608.063355556, 1907621.9983549977 4208607.63809897, 1907615.7932092524 4208607.02851617, 1907604.7508341921 4208605.924772548, 1907572.0972255603 4208598.94595565, 1907563.1832964667 4208595.996509624, 1907536.967337117 4208584.910393328, 1907500.4485251396 4208561.443999344, 1907465.0026566715 4208545.33454262, 1907419.4756278982 4208508.395019707, 1907397.1466401785 4208496.692306065, 1907372.9452429132 4208486.234150579, 1907348.4623802362 4208479.873166678, 1907332.554487245 4208478.076424228, 1907312.317631427 4208478.168845637, 1907285.6642105354 4208479.620801299, 1907283.7784612202 4208479.727307421, 1907271.5385974469 4208480.894214853, 1907269.918865474 4208481.116954529, 1907249.6601826106 4208484.023117112, 1907239.455267911 4208488.101440811, 1907213.2118280502 4208501.5027341405, 1907211.1806421971 4208502.539965447, 1907207.936212671 4208503.924256408, 1907175.9499069888 4208511.564223806, 1907170.3861903206 4208514.533891788, 1907169.3690980517 4208515.211040753, 1907165.272374542 4208517.977846572, 1907163.7167827415 4208519.228243073, 1907160.3478552082 4208523.242395695, 1907145.7909216075 4208543.3783397125, 1907138.8182852555 4208550.648608059, 1907105.9729310933 4208577.794423771, 1907096.5403825704 4208583.891052944, 1907092.9110617484 4208586.207372338, 1907088.9262006595 4208589.426277336, 1907086.547094533 4208591.396278597, 1907085.3323758985 4208592.65778189, 1907080.3515147483 4208598.1079227775, 1907076.1370889533 4208600.926023557, 1907069.5557247743 4208604.10838034, 1907051.8546779691 4208605.641812716, 1907053.458595161 4208597.714010484, 1907057.9431274876 4208581.353229353, 1907060.074631098 4208573.607613622, 1907063.7476530562 4208554.518764073, 1907064.0605434559 4208552.106823707, 1907063.9532406293 4208551.909196349, 1907064.75 4208543.39, 1907064.8015712858 4208541.666458707, 1907052.2610362843 4208526.735385543, 1906941.3914588718 4208394.731306617, 1906817.176991719 4208245.200579919, 1906638.8786396922 4207879.0925714, 1906625.4257807417 4207732.334549705, 1906602.8146525305 4207477.73359188, 1906595.7114353843 4207397.869457205, 1906595.5243998375 4207398.036478905, 1906595.286402471 4207395.155181588, 1906365.9651628507 4207601.262796984, 1906100.5910857753 4207844.544367627, 1905979.5598251193 4207901.49344396, 1905930.1523867657 4207935.309570525, 1905832.7334408336 4207961.22057006, 1905795.1013450355 4207976.360741127, 1905715.985896853 4208041.0921512935, 1905629.8118939456 4208059.836937523, 1905548.0469807533 4208080.647386765, 1904362.742790962 4208190.466636288, 1904344.7740975085 4208204.558593344, 1904359.97 4208307.99, 1904360.72 4208310.73, 1904372.41 4208389.15, 1904405.2 4208596.35, 1904408.23 4208612.44, 1904438.2 4208753.85, 1904448.9 4208799.25, 1904518.21 4209116.87, 1904518.78 4209120.26, 1904526.37 4209172.62, 1904530.35 4209193.22, 1904566 4209327.53, 1904612.57 4209511.48, 1904663 4209705.78, 1904683.02 4209779.92, 1904725.27 4209941.32, 1904771.3 4210121.16, 1904800.86 4210236.97, 1904925.92 4210492.13, 1905064.23 4210771.27, 1905205.79 4211059.09, 1905323.95 4211296.88, 1905332.87 4211487.53, 1905336.81 4211561.11, 1905351.27 4211701.58, 1905352.41 4211708.65, 1905367.52 4211776.02, 1905378.96 4211824.09, 1905418.44 4211976.96, 1905457.37 4212082.17, 1905516.6399999312 4212221.750002142, 1905521.26 4212232.32, 1905561.52 4212313.21, 1905586.63 4212361.76, 1905596.43 4212373.28, 1905618.24 4212394, 1905641.29 4212416.89, 1905642.51 4212419.91, 1905644.74 4212469.07, 1905686.05 4212561.95, 1905687.7 4212564.76, 1905690.01 4212567.15, 1905692.74 4212569.13, 1905708.3 4212571.15, 1905728.040000069 4212611.2599978605, 1905740.53 4212615.15, 1905756.21 4212621.44, 1905758.95 4212623.84, 1905763.59 4212626.7, 1905771.76 4212634.13, 1905778.03 4212641.52, 1905792.79 4212672.78, 1905796.93 4212679.49, 1905798.16 4212682.08, 1905829.27 4212729.47, 1905847.08 4212757.58, 1905800.75 4212961.72, 1905798.428098735 4212965.719550596, 1905906.1498161098 4212886.39497677, 1906035.057684943 4212791.192549027, 1906090.151256058 4212750.412076332, 1906175.4047612345 4212687.655623739, 1906446.0337536673 4212488.1374536, 1906548.418831955 4212412.810964406, 1906632.2820263072 4212351.099571976, 1906633.5744787676 4212350.600143578, 1906636.6888096407 4212349.360802423, 1906715.3572710354 4212339.044205488, 1906810.1778271953 4212326.367568979, 1906981.2669378305 4212407.118402518, 1907051.8083419208 4212474.897447762, 1907056.071597891 4212477.295552163, 1907060.091634514 4212479.410158044, 1907083.5998083628 4212484.984479982, 1907120.7528020914 4212493.85876415, 1907126.8609170383 4212493.859225473, 1907129.3669793024 4212493.923144099, 1907197.7252551627 4212481.541891189, 1907208.2791082945 4212479.628650769, 1907260.3623481782 4212509.850121457, 1907305.6501696208 4212535.454862694, 1907317.1637740692 4212540.008144311, 1907319.399397771 4212539.724380329, 1907319.6401728613 4212539.701666837, 1907332.643796842 4212532.762050431, 1907349.3236020503 4212525.416754804, 1907352.8946678024 4212523.877579237, 1907354.967231041 4212523.198303895, 1907356.8778338148 4212522.625329181, 1907358.5215668408 4212522.348041626, 1907367.6512290244 4212521.033559097, 1907395.0736621844 4212518.729986386, 1907395.5645509963 4212517.590330639, 1907397.8022735142 4212517.423064366, 1907402.8327566434 4212506.034776964, 1907410.0400542028 4212502.507271369, 1907410.1299740258 4212502.486291416, 1907413.773029708 4212501.741875966, 1907444.0294821933 4212503.866758137, 1907448.4006279327 4212504.173739587, 1907497.8511634588 4212530.430733984, 1907533.722076065 4212540.705033564, 1907553.6200578227 4212564.296988686, 1907573.178494925 4212581.469372067, 1907614.8333873656 4212592.840123236, 1907620.4083545704 4212592.909849609, 1907621.1898440002 4212592.961676556, 1907629.7253069605 4212590.893750335, 1907660.798978013 4212583.44149617, 1907701.307335035 4212601.208224744, 1907705.4380874033 4212641.137278352, 1907742.4871837595 4212677.465, 1907751.3917430858 4212693.522026736, 1907772.3936600345 4212699.014640905, 1907812.945295413 4212719.690489322, 1907831.7347598865 4212740.957866992, 1907829.500664419 4212750.310395454, 1907853.0258263908 4212772.011555826, 1907913.459778403 4212830.128650104, 1907929.6044599258 4212856.039704586, 1907963.47301015 4212878.932474624, 1907976.166311165 4212900.206842143, 1908012.5994253247 4212964.126296305, 1908071.5606374047 4213020.095891877, 1908087.379540372 4213023.641243537, 1908088.0626738872 4213032.419305696, 1908125.540468458 4213039.615855154, 1908127.862982638 4213038.964925575, 1908137.3875821226 4213035.45621694, 1908141.8591487214 4213034.665175245, 1908148.156505075 4213039.30281624, 1908168.5531245668 4213061.80499359, 1908170.4819939535 4213071.454431595, 1908202.4787395862 4213111.055152254, 1908228.341772957 4213125.41911918, 1908261.6753492663 4213167.686286874, 1908289.4533192823 4213193.0538497465, 1908301.779942779 4213207.393436061, 1908319.199079993 4213256.951084642, 1908326.0071636147 4213256.317033149, 1908338.386579097 4213255.826385585, 1908346.9878070122 4213313.920309119, 1908350.7124799292 4213334.941881941, 1908367.5891274058 4213391.806597482, 1908354.9685918798 4213432.553301015, 1908281.2014497756 4213553.640868046, 1908437.5464081203 4213563.883827445, 1908623.5320406011 4213574.708536579, 1908814.8338827444 4213586.597326918, 1908911.232573197 4213592.675988178, 1908925.8994091745 4213613.248642632, 1908933.8760112042 4213630.933208608, 1908946.5110226714 4213641.607395915, 1908955.0267761322 4213660.015929865, 1908961.86217689 4213667.993518151, 1908988.5909892495 4213680.654832323, 1908997.2524294998 4213684.596248321, 1909120.12 4213681.02, 1909118.35 4213674.56, 1909117.35 4213663.42, 1909114.95 4213639.63, 1909119.18 4213641.45, 1909122.36 4213642.39, 1909125.14 4213642.46, 1909148.83 4213635.14, 1909165.62 4213630.63, 1909179.59 4213627.57, 1909188.83 4213626.09, 1909227.53 4213625.56, 1909251.07 4213624.64, 1909295.65 4213619.76, 1909333.31 4213618.78, 1909342.27 4213619.22, 1909349.120244661 4213614.547474625, 1909347.895 4213603.835, 1909346.49 4213604.57, 1909335.31 4213606.86, 1909290.64 4213606.6, 1909253.54 4213611.23, 1909240.06 4213611.54, 1909198.9 4213616.29, 1909189.34 4213502.54, 1909189.077671594 4213500.146610566, 1909185.129726328 4213499.626610567, 1909155.5125347576 4213495.940686376, 1909130.5333557734 4213491.873014782, 1909076.7768715085 4213473.578162463, 1909077.18000007 4213471.089997862, 1909079.01 4213460.45, 1909132.43 4213435.7, 1909145.22 4213428.75, 1909143.96 4213419.32, 1909143.4559530376 4213416.085417492, 1909159.8291429833 4213413.783305957, 1909170.5641094688 4213411.395204157, 1909203.0641094688 4213402.703149422, 1909211.2617839852 4213400.913955502, 1909210.96 4213398.32, 1909205.42 4213354.57, 1909201.54 4213321.55, 1909201.24 4213316.2, 1909200.52 4213310.84, 1909181.91 4213311.44, 1909096.1 4213297.98, 1909118.88 4213241.68, 1909163.86 4213246.64, 1909164.84 4213241.55, 1909184.76 4213239.9, 1909193.55 4213222.16, 1909208.46 4213206.93, 1909209.44 4213184.71, 1909261.8 4213176.83, 1909279.81 4213183.05, 1909272.33 4213148.87, 1909299.38 4213144.42, 1909303.1403829735 4213143.867518667, 1909309.6740421485 4213146.759793648, 1909335.5343158203 4213157.123149421, 1909357.4220547343 4213152.983355774, 1909368.017705254 4213147.779759988, 1909367.41 4213147.07, 1909354.67 4213139.96, 1909336.95 4213133.76, 1909335.56 4213121.07, 1909345.17 4213114.39, 1909352.65 4213106.92, 1909351.77 4213099.24, 1909362.72 4213096.55, 1909367.61 4213095.62, 1909369.21 4213079.16, 1909361.36 4213060.19, 1909350.22 4213036.44, 1909338.23 4213017.25, 1909326.76 4213000.23, 1909319.61 4212988.71, 1909312.62 4212976.67, 1909297.01 4212951.71, 1909296.1 4212947.4, 1909280.17 4212901.33, 1909279.37 4212898.03, 1909267.76 4212834.51, 1909245.49 4212801.67, 1909251.35 4212798.39, 1909262.14 4212794.38, 1909272.02 4212792.28, 1909281.03 4212791.01, 1909288.09 4212790.97, 1909301.7600000703 4212792.029997859, 1909311.12 4212793.25, 1909327.25 4212797.93, 1909339.73 4212802.95, 1909350.93 4212808.35, 1909365.88 4212817.71, 1909396.2 4212844.76, 1909402.94 4212840.22, 1909406.66 4212836.68, 1909408.7799999297 4212839.53000214, 1909423.5092436944 4212895.506857853, 1909468.55 4212879.07, 1909474.96 4212909.81, 1909482.07 4212941.04, 1909492.41 4212938.48, 1909506.44 4212943.86, 1909533.49 4212966.54, 1909564.02 4212983.27, 1909580.9900000703 4212973.829997862, 1909575.59 4212937.44, 1909612.1 4212937.81, 1909606.35 4212891.11, 1909605.6200000704 4212869.209997858, 1909595.08 4212850.66, 1909588.92 4212832.91, 1909614.04 4212783.69, 1909577.5499999297 4212795.000002141, 1909564.6299999298 4212817.370002141, 1909554.6499999298 4212827.370002143, 1909520.3699999298 4212834.660002138, 1909489.79 4212829.78, 1909428.720714995 4212809.659448922, 1909425.294150657 4212805.328116885, 1909404.1526717488 4212778.604332983), (1907094.32 4210362.34, 1907083.7 4210365.2, 1907072.69 4210366.24, 1907052.5 4210366.52, 1907035.6 4210364.65, 1907026.1 4210364.23, 1907016.17 4210363.65, 1907010.47 4210363.2, 1906995.79 4210361.9, 1906983.39 4210360.24, 1906964.96 4210357.79, 1906960.29 4210358.2, 1906957.56 4210358.44, 1906957.41 4210358.45, 1906945.65 4210359.17, 1906909.57 4210370.14, 1906894.64 4210374.14, 1906813.28 4210398.77, 1906814.85 4210378.96, 1906787.94 4210378.33, 1906788.28 4210320.82, 1906761.23 4210323.19, 1906745.04 4210322, 1906739.31 4210320.87, 1906713.26 4210311.09, 1906707.16 4210308.88, 1906665.55 4210293.24, 1906641.61 4210283.99, 1906619.53 4210285.09, 1906604.08 4210290.56, 1906601.05 4210286.79, 1906558.87 4210297, 1906556.47 4210293.67, 1906591.8899999305 4210278.110002149, 1906599.03 4210266.16, 1906599.29 4210233.24, 1906603.5 4210216.54, 1906676.67 4210234.1, 1906721.36 4210243.25, 1906762.08 4210250.31, 1906763.15 4210245.86, 1906763.9927367242 4210243.61807991, 1906792.7838357966 4210249.008766282, 1906804.8856168587 4210251.436985221, 1906811.4486989602 4210253.293663109, 1906812.13 4210250.3, 1906818.78 4210217.89, 1906817.62 4210217.82, 1906775.07 4210215.2, 1906768.7 4210214.26, 1906698.77 4210200.5, 1906640.35 4210187.7, 1906623.38 4210180.27, 1906635.13 4210175.91, 1906644.66 4210173.36, 1906664.13 4210168.71, 1906691.78 4210162.74, 1906725.36 4210158.12, 1906732.19 4210158.23, 1906724.04 4210145.22, 1906694.59 4210139.56, 1906697.44 4210115.1, 1906748.04 4210084.98, 1906764 4210095.77, 1906756.89 4210101.43, 1906786.22 4210132.74, 1906789.3 4210135.46, 1906832.7 4210153.75, 1906871.81 4210168.2, 1906872.65 4210166.68, 1906874.13 4210164.04, 1906807.28 4210135.01, 1906789.46 4210127.34, 1906766.24 4210093.53, 1906783.76 4210057.57, 1906747.58 4210058.43, 1906693.7 4210039.87, 1906698.17 4210008.64, 1906777.47 4210013.86, 1906785.39 4209995.41, 1906789.72 4209985.14, 1906792.4 4209978.21, 1906799.99 4209980.7, 1906839 4209997.08, 1906842.95 4209999.19, 1906843.893482409 4210000.38087044, 1906846.03 4209999.34, 1906848.09 4209993.98, 1906847.34 4209986.61, 1906846.93 4209979.15, 1906847.06 4209974.23, 1906847.54 4209962.77, 1906851.44 4209962.99, 1906856.1 4209962.77, 1906861.01 4209962.13, 1906874.63 4209958.43, 1906893.32 4209951.13, 1906897.7 4209949.22, 1906928.61 4209942.22, 1907003.38 4209930.99, 1907009.7742856534 4209929.9258794645, 1907029.63 4209951.07, 1907037.79 4209960.58, 1907045.08 4209969.59, 1907048.61 4209974.14, 1907054.91 4209984.85, 1907057.86 4209991.52, 1907059.95 4209996.14, 1907061.23 4209998.95, 1907094.14 4209962.75, 1907096.1 4209963.83, 1907103.61 4209968.04, 1907105.52 4209995.22, 1907108.07 4210005.79, 1907110.29 4210015.02, 1907155.73 4210060.04, 1907148.49 4210074.37, 1907147.82 4210075.65, 1907147.24 4210076.89, 1907209.491485186 4210150.933268621, 1907234.0602793242 4210192.871654882, 1907257.21 4210210.73, 1907260.49 4210207.82, 1907285.61 4210231.94, 1907295 4210262.24, 1907304.76 4210285.95, 1907314.35 4210347.59, 1907314.33 4210347.61, 1907312.85 4210349.32, 1907300.25 4210362, 1907290.19 4210374.65, 1907290.76 4210381.01, 1907300.63 4210414.76, 1907324.8009895117 4210428.660679238, 1907340.5999999305 4210447.420002146, 1907342.3199999302 4210462.400002149, 1907340.4108856882 4210484.335492914, 1907340.3460936807 4210484.330783391, 1907332.34 4210477.98, 1907324.95 4210477.63, 1907324.88 4210478.82, 1907318.76 4210478.63, 1907312.91 4210483.7, 1907310.01 4210485.33, 1907309.99 4210486.78, 1907288.89 4210485.79, 1907280.22 4210484.26, 1907259.99 4210479.96, 1907244.1495651004 4210483.6819088105, 1907243.69 4210478.25, 1907233.51 4210460.71, 1907229.83 4210459.89, 1907221.16 4210457.96, 1907164.7499999302 4210445.520002148, 1907173.1299999305 4210410.210002147, 1907141.81 4210403.75, 1907150.79 4210363.32, 1907141.36 4210361.67, 1907127.31 4210424.71, 1907126.55 4210428.11, 1907125.19 4210434.23, 1907125.1 4210434.61, 1907122.88 4210433.62, 1907119.06 4210432.56, 1907117.08 4210430.79, 1907115.98 4210430.21, 1907114.62 4210430.14, 1907112.57 4210429.65, 1907110.69 4210427.37, 1907110.1 4210427.21, 1907106.88 4210427.07, 1907103.81 4210426.59, 1907102.37 4210425.92, 1907090.33 4210418.66, 1907086.16 4210416.5, 1907085.48 4210416.34, 1907088.28 4210399.34, 1907089.48 4210391.86, 1907094.32 4210362.34), (1906741.9 4209701.26, 1906698.01 4209688.71, 1906681.84 4209677.9, 1906653.16 4209651.11, 1906631.45 4209648.8, 1906595.66 4209645.84, 1906558.21 4209555.54, 1906536.51 4209516.46, 1906509.67 4209477.99, 1906530.01 4209463.76, 1906527.4 4209455.72, 1906534.65 4209433.4, 1906562.15 4209448.8, 1906603.68 4209452.25, 1906611.52 4209454.12, 1906618.45 4209456.58, 1906660.42 4209587.51, 1906683.58 4209618.1, 1906693.74 4209642.96, 1906717.19 4209671.86, 1906741.9 4209701.26), (1906761.48 4208577.9, 1906818.9837115516 4208587.360260512, 1906828.89 4208588.99, 1906838.57 4208636.48, 1906843.1 4208658.02, 1906844.45 4208663.48, 1906850.66 4208743.3, 1906959.4 4208662.78, 1907021.31 4208617.16, 1907025.18 4208613.79, 1907023.61 4208659, 1906991.53 4208716.33, 1906977.02 4208728.58, 1906975.81 4208737.46, 1906928 4208773.93, 1906900.71 4208800.91, 1906892.2480170955 4208807.550632858, 1906882.73 4208815.02, 1906871.79 4208826.7, 1906860.18 4208838.39, 1906845.9 4208852.11, 1906838.56 4208860.27, 1906829.94 4208858.25, 1906815.73 4208794.81, 1906813.41 4208753.87, 1906810.69 4208748.51, 1906786.03 4208708.16, 1906786.33 4208665.33, 1906767.13 4208661.47, 1906755.45 4208642.29, 1906768.51 4208633.75, 1906766.79 4208630.39, 1906757.28 4208587.73, 1906761.48 4208577.9), (1907278.2599999302 4210158.6700021485, 1907279.5199999302 4210165.02000215, 1907281.44999993 4210168.200002148, 1907283.1499999303 4210170.360002148, 1907294.3999999303 4210179.0900021475, 1907283.6199999303 4210182.0500021465, 1907279.18999993 4210183.750002148, 1907274.2999999302 4210174.790002148, 1907271.9099999303 4210169.000002149, 1907271.1099999303 4210164.010002147, 1907278.2599999302 4210158.6700021485), (1907472.88 4211570.78, 1907438.29 4211559.86, 1907396.57 4211544.2, 1907384.02 4211536.82, 1907379.9 4211533.72, 1907376.85 4211530.8, 1907373.11 4211526.2, 1907435.49 4211494.26, 1907439.46 4211500.13, 1907466.69 4211534.25, 1907486.01 4211558.32, 1907472.88 4211570.78), (1907351.8699999303 4210209.920002146, 1907343.45999993 4210203.910002149, 1907288.3699999303 4210169.330002148, 1907286.5599999302 4210167.510002147, 1907284.2799999302 4210164.790002149, 1907281.8899999303 4210155.600002148, 1907295.0499999302 4210144.580002148, 1907311.7499999302 4210155.120002148, 1907351.94999993 4210170.750002149, 1907374.9999999302 4210183.220002146, 1907383.5199999302 4210188.090002147, 1907403.16999993 4210202.950002147, 1907411.3599999303 4210212.140002147, 1907426.4799999301 4210237.210002148, 1907435.1199999303 4210251.400002149, 1907431.70999993 4210255.030002148, 1907457.6199999303 4210281.690002147, 1907472.94999993 4210292.350002148, 1907467.8499999302 4210298.480002147, 1907447.18999993 4210299.750002148, 1907445.70999993 4210299.290002147, 1907414.1399999303 4210279.3400021475, 1907399.92999993 4210264.590002148, 1907390.2699999302 4210252.340002148, 1907373.3399999302 4210227.830002148, 1907351.8699999303 4210209.920002146), (1906826.9299999303 4209937.57000215, 1906815.4699999304 4209941.660002149, 1906806.4999999304 4209944.170002149, 1906795.2699999304 4209946.33000215, 1906790.1599999305 4209945.770002149, 1906727.4799999304 4209926.180002149, 1906709.2899999304 4209894.300002149, 1906739.2399999304 4209873.500002148, 1906781.6699999303 4209843.610002149, 1906813.4699999304 4209857.770002149, 1906817.0999999305 4209858.790002149, 1906820.2799999304 4209858.900002149, 1906823.0099999304 4209857.990002149, 1906825.4999999304 4209856.400002149, 1906852.3799999305 4209822.770002149, 1906854.111716722 4209819.813593701, 1906881.1653431165 4209837.772877899, 1906890.7271241785 4209844.012877901, 1906901.6409599753 4209854.396166352, 1906910.5998652854 4209864.66740007, 1906918.4595916132 4209876.294111617, 1906927.3062782837 4209886.968421475, 1906920.4399999303 4209890.720002149, 1906911.3599999305 4209895.720002149, 1906879.91999993 4209909.370002149, 1906870.7299999304 4209913.920002148, 1906844.1799999303 4209929.15000215, 1906826.9299999303 4209937.57000215), (1907319.8699999303 4210227.990002148, 1907331.8899999303 4210211.520002148, 1907342.9099999303 4210217.760002147, 1907345.17999993 4210219.680002148, 1907347.7899999302 4210221.390002148, 1907350.5199999302 4210223.770002148, 1907363.3599999303 4210236.930002146, 1907381.42999993 4210261.770002149, 1907392.5699999302 4210277.650002149, 1907399.7299999301 4210286.280002148, 1907404.4999999302 4210291.270002147, 1907406.7699999302 4210293.760002148, 1907411.7699999302 4210297.620002148, 1907420.16999993 4210302.7200021455, 1907425.8499999302 4210304.870002148, 1907429.8299999302 4210306.120002148, 1907438.9099999303 4210308.150002148, 1907444.1299999303 4210308.940002148, 1907449.8099999302 4210309.510002148, 1907457.4099999303 4210307.910002149, 1907470.8099999302 4210307.100002147, 1907473.3099999302 4210307.330002147, 1907475.91999993 4210308.690002149, 1907484.9999999302 4210311.520002148, 1907490.7899999302 4210313.900002148, 1907502.1499999303 4210319.910002149, 1907516.2399999301 4210327.8400021475, 1907527.4799999301 4210335.660002149, 1907543.6099999303 4210345.070002147, 1907548.3799999303 4210348.360002148, 1907571.67999993 4210376.720002147, 1907584.17999993 4210391.240002148, 1907587.3599999303 4210394.530002147, 1907595.8799999303 4210402.020002148, 1907603.4899999301 4210407.230002149, 1907618.2599999302 4210416.640002148, 1907594.5399999302 4210435.390002148, 1907591.5899999302 4210435.620002148, 1907582.5099999302 4210434.8400021475, 1907578.0799999302 4210435.290002148, 1907574.44999993 4210436.430002146, 1907571.7299999301 4210436.320002149, 1907566.0499999302 4210435.650002146, 1907556.0599999302 4210436.790002149, 1907541.18999993 4210437.260002147, 1907533.0199999302 4210437.150002148, 1907518.93999993 4210436.590002147, 1907510.7699999302 4210436.940002148, 1907506.2299999301 4210437.970002147, 1907502.8199999302 4210438.540002148, 1907497.1499999303 4210439.900002147, 1907491.5899999302 4210441.730002148, 1907487.0499999302 4210443.660002147, 1907485.2299999301 4210445.250002148, 1907481.8299999302 4210449.230002148, 1907479.5599999302 4210452.9700021455, 1907477.2899999302 4210456.950002146, 1907476.7299999301 4210458.990002146, 1907484.68999993 4210480.670002147, 1907486.0599999302 4210488.840002147, 1907442.69999993 4210493.760002147, 1907443.4899999301 4210488.310002147, 1907442.91999993 4210485.700002148, 1907438.93999993 4210475.370002147, 1907435.6399999303 4210465.500002148, 1907433.92999993 4210461.300002147, 1907431.5399999302 4210457.330002148, 1907428.92999993 4210454.270002147, 1907423.2499999302 4210449.960002148, 1907415.4099999303 4210445.200002148, 1907410.5299999304 4210440.770002145, 1907408.5999999302 4210438.730002148, 1907406.6599999303 4210435.670002146, 1907405.6399999303 4210433.400002148, 1907402.3399999302 4210426.590002145, 1907393.8199999302 4210413.200002148, 1907386.0899999302 4210404.010002149, 1907381.7699999302 4210398.000002146, 1907377.8999999303 4210386.650002148, 1907372.2199999301 4210379.730002149, 1907366.41999993 4210374.170002147, 1907357.2299999301 4210370.320002148, 1907363.4699999304 4210367.820002146, 1907369.2499999302 4210363.160002148, 1907374.2399999301 4210357.820002148, 1907379.1199999303 4210350.890002147, 1907381.0399999302 4210343.960002147, 1907380.3599999303 4210335.900002149, 1907381.1399999303 4210321.030002147, 1907389.2999999302 4210310.690002147, 1907388.95999993 4210308.080002147, 1907388.3899999303 4210306.3800021475, 1907387.8199999302 4210305.130002147, 1907384.4099999303 4210300.710002148, 1907382.3699999303 4210298.780002148, 1907379.8699999303 4210296.850002148, 1907374.2999999302 4210293.450002148, 1907369.7599999302 4210289.480002148, 1907365.8999999303 4210285.280002149, 1907363.16999993 4210282.7900021495, 1907360.66999993 4210280.750002148, 1907357.93999993 4210279.050002147, 1907354.7599999302 4210277.570002148, 1907352.3799999303 4210275.650002148, 1907336.0099999302 4210253.640002146, 1907332.4799999301 4210243.080002148, 1907330.8899999303 4210240.700002148, 1907319.8699999303 4210227.990002148))','ZO32203','"lib_modif"=>"N", "lib_code_insee"=>"38187 / 38436 / 38524 / 38545", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','A','Agricole','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1906103.96 4205272.62, 1906168.73 4205224.49, 1906181.771652644 4205244.465995501, 1906189.45 4205255.87, 1906231.0315408155 4205225.444283967, 1906244.9 4205242.9, 1906253.99 4205255.03, 1906250.96 4205256.89, 1906242.46 4205260.22, 1906238.14 4205261.95, 1906235.03 4205262.95, 1906232.61 4205263.73, 1906226.79 4205265.76, 1906219.68 4205268.02, 1906214.98 4205270.62, 1906204.59 4205278.81, 1906184.5 4205294.71, 1906175.6 4205302.07, 1906172.57 4205304.73, 1906169.63 4205307.98, 1906166.51 4205310.87, 1906167.2293653172 4205312.186703389, 1906167.994088726 4205313.001736669, 1906167.57 4205313.42, 1906163.26 4205318.09, 1906158.63 4205324.47, 1906155.87 4205328.37, 1906153.12 4205333.22, 1906139.91 4205347.7, 1906148.77 4205366.63, 1906156.77 4205382.84, 1906162.19 4205397.48, 1906162.5 4205398.32, 1906168.12 4205415.21, 1906174.16 4205433.55, 1906181.16 4205457.77, 1906184.67 4205473.16, 1906187.8 4205486.59, 1906192.15 4205509.68, 1906195.2144292095 4205530.2910861615, 1906190.5 4205542.28, 1906121.83 4205557.61, 1906054.37 4205562.01, 1906055.52 4205582.87, 1906056.8 4205605.85, 1906066.5 4205655.84, 1906067.3881362604 4205658.086346067, 1906050.994088294 4205660.892534457, 1906031.3507695594 4205664.732581729, 1906016.1382745996 4205670.788040888, 1906002.1073326461 4205675.957335291, 1905994.722626355 4205678.025053053, 1905973.66 4205679.55, 1905968.77 4205679.24, 1905967.38 4205683.43, 1905965.47 4205685.99, 1905961.82 4205690.02, 1905955.43 4205697.19, 1905946.75 4205705.44, 1905941.94 4205710, 1905936.89 4205714.81, 1905923.12 4205726.61, 1905910.32 4205737.15, 1905903.58 4205741.3, 1905897.68 4205745.38, 1905888.8815713834 4205751.600386673, 1905888.4493259063 4205751.949253164, 1905882.281864598 4205756.384756161, 1905881.9035252107 4205756.981789482, 1905880.7301734593 4205757.966798037, 1905878.8780550787 4205759.088503536, 1905878.630699939 4205759.238310169, 1905874.710959362 4205761.689388454, 1905874.5701686903 4205761.774240182, 1905868.4201686902 4205765.344240181, 1905868.270099411 4205765.427939515, 1905862.4060545824 4205768.567666977, 1905858.2596550032 4205771.3137473995, 1905852.4021041107 4205776.146710183, 1905851.934418595 4205776.489039377, 1905848.400800368 4205778.773304458, 1905843.2351141984 4205783.087609018, 1905843.1367667464 4205783.167652407, 1905841.7950535403 4205784.231654401, 1905839.1267667464 4205786.347652406, 1905839.1152248054 4205786.356777738, 1905830.6984026076 4205792.991214058, 1905827.9472073435 4205795.355391029, 1905827.0486744724 4205796.585990396, 1905825.4202732695 4205799.331009567, 1905825.2703409356 4205799.5683095455, 1905820.9312955104 4205806.026888681, 1905817.712249135 4205810.825467128, 1905817.5260019868 4205811.084803482, 1905814.3860019867 4205815.174803481, 1905814.3610409077 4205815.207043477, 1905810.3010409079 4205820.4070434775, 1905810.0275879735 4205820.728352315, 1905802.3510274657 4205816.41444895, 1905805.3679400438 4205806.717948688, 1905807.3553331576 4205803.212317556, 1905808.0920755423 4205801.9127523005, 1905810.2031767217 4205797.183885659, 1905810.6607391757 4205796.036711221, 1905811.2205420083 4205794.633205547, 1905811.2303018686 4205793.745058262, 1905811.58634175 4205791.946236785, 1905812.566957958 4205790.396748173, 1905815.1869579582 4205787.576748174, 1905815.8751105377 4205786.961289674, 1905832.8151105377 4205774.421289674, 1905832.8546398985 4205774.392326462, 1905845.4977470175 4205765.223585, 1905845.706298583 4205765.063210132, 1905864.9220362136 4205750.286426265, 1905865.2572511171 4205750.1265160665, 1905865.8099932296 4205749.740635216, 1905878.0987417512 4205743.854267339, 1905890.744773396 4205733.2300748415, 1905908.876733287 4205715.784931613, 1905909.37148629 4205715.171947194, 1905904.746796195 4205706.013843782, 1905904.221222855 4205704.0948172575, 1905904.021222855 4205701.114817258, 1905904.0452004387 4205700.187745566, 1905906.2389688203 4205681.79764215, 1905906.5422807173 4205671.758996786, 1905906.8064571247 4205670.29954297, 1905907.487146417 4205668.981796143, 1905911.757146417 4205663.0717961425, 1905913.8722135616 4205660.148512943, 1905920.6855618728 4205650.731626719, 1905933.038808922 4205633.067080215, 1905940.38485975 4205621.848541665, 1905947.491106112 4205607.559224656, 1905950.220514591 4205599.218837074, 1905950.2479852326 4205599.134893686, 1905950.5404965987 4205598.428843346, 1905952.3404965987 4205594.878843346, 1905952.3765853418 4205594.809033942, 1905954.5108754553 4205590.758846192, 1905956.2806802327 4205587.287682126, 1905958.6068673811 4205582.467030461, 1905958.637864045 4205582.403932022, 1905960.4885958969 4205578.702468319, 1905961.2302403236 4205577.039880812, 1905961.3955439879 4205576.502643903, 1905961.83322954 4205574.442947188, 1905962.303200787 4205571.519726031, 1905962.594640208 4205569.3533596685, 1905962.645543868 4205569.047215312, 1905963.125543868 4205566.627215312, 1905963.138915818 4205566.591705127, 1905963.142750257 4205566.544163862, 1905963.5889117848 4205565.302885405, 1905964.3389117848 4205563.8528854055, 1905964.4744187726 4205563.607959423, 1905966.0769176765 4205560.893731649, 1905970.6577077592 4205553.1523969155, 1905974.1056886732 4205547.329581885, 1905974.4452377043 4205546.732874396, 1905974.408574221 4205546.692503152, 1905973.3221949793 4205545.396821488, 1905971.1358254526 4205542.801131639, 1905970.1338681404 4205540.887077379, 1905969.8738681404 4205539.927077379, 1905969.7013519206 4205538.503735735, 1905969.9398571935 4205537.089954098, 1905970.2998571936 4205535.969954098, 1905971.2971165266 4205534.2074769605, 1905974.7964182228 4205530.208275022, 1905975.2492890207 4205529.690265274, 1905949.72 4205518.24, 1905934.01 4205523.65, 1905934.53 4205526.07, 1905917.32 4205526.02, 1905921.1 4205509.9, 1905910.34 4205503.3, 1905901.58 4205539.3, 1905889.9 4205536.3, 1905888.83 4205549.25, 1905888.63 4205552.29, 1905853.98 4205545.49, 1905850.574008455 4205544.279734829, 1905847.3064353138 4205543.485407657, 1905842.87 4205549.64, 1905814.842727868 4205538.356065201, 1905837.0396959574 4205487.604801245, 1905801.794090494 4205472.2377172625, 1905806.91 4205463.31, 1905790.9006160686 4205443.506214506, 1905787.2957585645 4205445.950558112, 1905779.4801078092 4205434.4862223435, 1905777.368015351 4205431.201133441, 1905773.7584311378 4205425.911171346, 1905769.511100983 4205419.470963105, 1905768.2409331317 4205417.623423611, 1905754.564979174 4205427.828254379, 1905743.0044205827 4205434.313445786, 1905741.98 4205432.05, 1905723.26 4205389.13, 1905700.84 4205338, 1905705.37 4205332.4, 1905706.2080084789 4205330.691365725, 1905706.8639193978 4205328.94859097, 1905713.49 4205330.33, 1905723.91 4205332.51, 1905739.4 4205336.05, 1905742.42 4205336.54, 1905748.46 4205337.15, 1905758.03 4205337.69, 1905764.46 4205337.64, 1905771.59 4205337.59, 1905779.55 4205337.27, 1905782.7 4205337.14, 1905796.11 4205336.3, 1905799.22 4205336.1, 1905801.82 4205336.08, 1905803.23 4205336.07, 1905810.29 4205336.94, 1905821.85 4205338.55, 1905827.0411582852 4205339.096437715, 1905827.55 4205339.15, 1905833.01 4205339.11, 1905836.64 4205339.32, 1905841.4 4205339.6, 1905848.4 4205339.8, 1905856.21 4205340.02, 1905864.08 4205340.24, 1905870.84 4205340.44, 1905878.74 4205343.39, 1905884.49 4205345.67, 1905884.81 4205345.52, 1905875.89 4205337.77, 1905860.37 4205325.97, 1905851.51 4205319.23, 1905846.23 4205314.9, 1905832.62 4205303.73, 1905839.81 4205296.62, 1905870.76 4205267.83, 1905873.99 4205261.73, 1905846.43 4205238.8, 1905823.95 4205219.96, 1905832.04 4205214.04, 1905840.1 4205208.23, 1905870.42 4205186.31, 1905884.6 4205176.07, 1905900.66 4205164.47, 1905900.66 4205163.87, 1905899.72 4205162.89, 1905893.14 4205156.02, 1905894.72 4205154.25, 1905870.39 4205133.22, 1905837.86 4205105.1, 1905819.86 4205089.55, 1905801.7942106868 4205073.938178897, 1905782.02 4205056.85, 1905767.03 4205043.89, 1905755.45 4205043.3, 1905740.9319211703 4205059.745406396, 1905703.7 4205101.92, 1905679.26 4205073.47, 1905671.59 4205077.8, 1905646.43 4205029.46, 1905694.1132209194 4204999.055483144, 1905740.0599199617 4204969.758234372, 1905775.5911196198 4204947.964259457, 1905801.572087609 4204936.358181957, 1905817.89 4204929.13, 1905824.23 4204933.4, 1905845 4204911.18, 1905845.48 4204910.75, 1905848.58 4204909.61, 1905859.54 4204905.6, 1905858.59 4204902.42, 1905862.852890926 4204901.380748763, 1905858.73 4204865.07, 1905856.55 4204807.41, 1905856.03 4204802.45, 1905851.86 4204763.54, 1905849.2 4204738.68, 1905846.57 4204714.14, 1905842.59 4204676.99, 1905816.54 4204668.14, 1905818.51 4204646.75, 1905805.8 4204640.92, 1905787 4204652.93, 1905760.72 4204654.06, 1905756.85 4204659.33, 1905750.34 4204653.8, 1905744.51 4204641.26, 1905731.16 4204636.59, 1905722.67 4204651.65, 1905719.79 4204656.75, 1905712.39 4204655.48, 1905693.7 4204652.31, 1905689.07 4204661.56, 1905653.11 4204662.16, 1905645.05 4204662.29, 1905659.5 4204632.64, 1905657.55 4204630.99, 1905654.96 4204629.44, 1905642.4 4204622.93, 1905634.56 4204637.63, 1905642.65 4204635.92, 1905640.89 4204648.87, 1905626.55 4204652.56, 1905623.67 4204665.3, 1905611.7 4204663.14, 1905602.32 4204657.94, 1905588.08 4204650.04, 1905590.22 4204640.11, 1905560.23 4204638.26, 1905535.37 4204724.06, 1905522.76 4204719.48, 1905525.13 4204707.06, 1905525.22 4204706.68, 1905437.95 4204692.56, 1905425.13 4204690.66, 1905417.41 4204726.23, 1905411.69 4204752.62, 1905401 4204750.8, 1905374.83 4204746.33, 1905359.47 4204734.67, 1905342 4204729.7, 1905338.43 4204762.58, 1905329.15 4204761.86, 1905324.44 4204812.84, 1905335.17 4204813.75, 1905367.52 4204816.51, 1905392.87 4204823.8, 1905391.97 4204831.87, 1905392.57 4204831.99, 1905391.9084766908 4204835.744492041, 1905404.019394979 4204835.744492041, 1905404.26 4204838.58, 1905396.45 4204859.26, 1905393.43 4204867.24, 1905390.26 4204892.7, 1905388.42 4204907.46, 1905419.79 4204909.36, 1905420.27 4204929.63, 1905437.3 4204925.39, 1905446.65 4204930.27, 1905446.98 4204936.91, 1905464.25 4204941.63, 1905479.59 4204944.8, 1905478.69 4204956.88, 1905461.71 4204956.14, 1905449.33 4204967.83, 1905411.34 4204956.34, 1905386.41 4204955.92, 1905379.6 4204965.42, 1905364.31 4204964.99, 1905358.43 4204956.19, 1905352.87 4204957.32, 1905335.09 4204960.92, 1905333.4216030056 4204961.284498689, 1905339.1816738988 4204975.020052357, 1905343.6124976627 4204973.100028725, 1905359.4157690878 4204979.4508761205, 1905373.7420992581 4204995.401841671, 1905401.89 4205031.13, 1905411.54 4205030.9, 1905421.93 4205040.43, 1905440.33 4205042.06, 1905448.24 4205052.92, 1905497.04 4205110.12, 1905507.84 4205109.73, 1905525.05 4205105.93, 1905551.65 4205092.54, 1905551.28 4205091.83, 1905537.07 4205059.06, 1905532.67 4205046.42, 1905563.65 4205030.46, 1905587.82 4205073.6, 1905602.23 4205069.88, 1905617.12 4205095.19, 1905618.81 4205098.21, 1905649.39 4205131.92, 1905651.53 4205134.28, 1905652.2932198897 4205135.194331424, 1905637.9725163032 4205137.263482944, 1905625.2840983365 4205139.23723685, 1905608.9301374017 4205144.312604036, 1905593.1401061544 4205149.246988801, 1905585.3860729525 4205154.604320832, 1905580.8746354533 4205156.01414505, 1905576.363197954 4205156.155127472, 1905570.5829186582 4205157.142004425, 1905555.356817098 4205149.528953644, 1905550.9863620207 4205145.581445833, 1905546.1929596777 4205138.391342319, 1905543.091346397 4205136.840535678, 1905520.5341589008 4205126.97176615, 1905477.5345202368 4205109.912893105, 1905473.0230827373 4205107.23422709, 1905446.6593698512 4205078.614795454, 1905440.4561432898 4205075.372199751, 1905434.9578288374 4205073.821393111, 1905431.4332682912 4205074.103357955, 1905453.285543678 4205109.066998574, 1905450.6 4205108.97, 1905392.25 4205105.99, 1905390.34 4205123.93, 1905403.08 4205149.4, 1905395.51 4205157.69, 1905378.57 4205149.17, 1905335.97 4205079.01, 1905293.35 4205075.01, 1905290.6811590465 4205075.114562798, 1905302.4343522964 4205106.670297403, 1905352.4831120544 4205238.629844255, 1905355.04 4205237.4, 1905356.93 4205242.33, 1905358.77 4205245.79, 1905368.96 4205260.54, 1905354.59 4205267.74, 1905354.94 4205267.99, 1905352.7650768978 4205269.364012217, 1905388.8565768916 4205294.035936041, 1905402.6728542333 4205313.632492678, 1905410.0039401695 4205313.632492678, 1905410.0039401695 4205319.553754397, 1905403.2367839206 4205328.012699707, 1905374.1944050193 4205352.54364111, 1905325.8374343237 4205424.86762352, 1905335.366772276 4205463.384432503, 1905337.71 4205463.75, 1905378.9 4205467.51, 1905387.24 4205468.28, 1905395.06 4205535.42, 1905366.49 4205539.75, 1905389.5614890014 4205629.856064892, 1905366.4403718177 4205635.213396923, 1905353.7519538512 4205635.495361767, 1905347.266762446 4205638.596975047, 1905325.2735046372 4205648.465744576, 1905303.2802468282 4205661.436127387, 1905322.7358210434 4205692.7342250375, 1905377.38 4205714.79, 1905411.3 4205760, 1905313.88 4205782.57, 1905311.4572272957 4205783.103957444, 1905328.375117918 4205821.028228923, 1905329.2210124491 4205823.988859781, 1905331.3 4205823.79, 1905375.6 4205820.2, 1905379.07 4205827.31, 1905410.52 4205819.21, 1905437.26 4205812.95, 1905445.64 4205841.17, 1905445.89 4205842.05, 1905462.76 4205871.25, 1905463.4362780517 4205873.47368985, 1905449.760983132 4205880.804775787, 1905426.4988835265 4205895.044000394, 1905427.7 4205897.94, 1905455.86 4205944.36, 1905488.09 4205997.51, 1905489.0950788287 4205999.370992565, 1905482.7508698453 4206002.472605845, 1905468.3706628166 4206022.210144904, 1905468.54 4206024.45, 1905469.41 4206043.35, 1905432.7 4206082.84, 1905417.27 4206104.74, 1905410.69 4206119.95, 1905406.89 4206132.88, 1905418.86 4206141, 1905432.07 4206150.42, 1905448.4 4206161.18, 1905453.57 4206164.62, 1905461.8 4206169.47, 1905465.372004748 4206171.3220068095, 1905461.83 4206179.01, 1905460 4206180.91, 1905469.1 4206192.64, 1905446.25 4206202.95, 1905428.94 4206210.75, 1905408.35 4206215.18, 1905333.71 4206287.82, 1905332.0406608868 4206288.807904626, 1905331.0537839336 4206298.25372689, 1905325.978416747 4206307.135619467, 1905322.8768034664 4206310.942144858, 1905321.3259968262 4206315.7355472, 1905323.8636804195 4206334.627191728, 1905327.65 4206336.18, 1905349.52 4206348.5, 1905358.3 4206343.53, 1905375.25 4206368.22, 1905407.93 4206359.21, 1905461.8 4206344.38, 1905466.8198561775 4206345.34185579, 1905505.167074921 4206305.866777671, 1905509.3965475766 4206302.76516439, 1905508.19 4206299.87, 1905503.5 4206292.52, 1905549.42 4206292.26, 1905593.55 4206303.4, 1905595.1843512738 4206304.456953452, 1905608.7186637716 4206298.6766741555, 1905622.8169059567 4206281.335836268, 1905624.7906598626 4206282.604678065, 1905621.5480641595 4206355.210625316, 1905668.636193058 4206363.951535472, 1905706.2784996924 4206364.515465159, 1905724.3242496895 4206387.636582343, 1905738.5634742964 4206401.734824528, 1905744.8465215345 4206417.753539964, 1905745.75 4206416.58, 1905748.78 4206413.25, 1905761.26 4206428.42, 1905794.75 4206456.82, 1905840.55 4206396.29, 1905883.14 4206425.99, 1905909.2 4206443.77, 1905937.78 4206462.4, 1905967.61 4206408.19, 1905943.04 4206386.85, 1905940.41 4206385.02, 1905919.29 4206366.54, 1905882.32 4206344.61, 1905856.37 4206323.16, 1905831.26 4206302.74, 1905789.27 4206269.81, 1905849.88 4206231.18, 1905865.41 4206248.43, 1905898.66 4206286.16, 1905915.93 4206305.69, 1905938.8 4206277.94, 1905939.991062084 4206279.090059117, 1905941.2257057088 4206277.59980209, 1905984.648291639 4206222.616657568, 1906007.9808824558 4206196.95785679, 1906006.71 4206195.19, 1905946.92 4206101.58, 1905996.68 4206067.49, 1906055.34 4206149.45, 1906056.3378531511 4206151.068078481, 1906071.8459195548 4206136.123941764, 1906070.91 4206134.19, 1906009.32 4206034.73, 1906031.38 4206014.72, 1906053.57 4205994.57, 1906050.22 4205989.18, 1906043.13 4205993.53, 1906024.8 4205957.66, 1906001.46 4205912.45, 1905987.26 4205886.46, 1905982.6 4205877.93, 1906037.27 4205844.65, 1906074.74 4205907.07, 1906058.42 4205917.48, 1906090.06 4205972.12, 1906107.35 4205961.34, 1906165.54 4206059.1, 1906183.24 4206049.76, 1906195.68 4206041.82, 1906202.37 4206037.23, 1906216.52 4206027.63, 1906229.49 4206019.01, 1906250.7 4206008.06, 1906267.72 4205999.55, 1906285.23 4205993.65, 1906304.03 4205987.37, 1906307.7654363904 4205986.798274842, 1906295.3400325682 4205911.098495525, 1906322.34 4205906.37, 1906395.47 4205895.33, 1906447.9963152679 4205907.027603583, 1906472.78 4205856.87, 1906473.53 4205855.65, 1906474.36 4205855.24, 1906473.85 4205860.06, 1906483.1101769318 4205924.305007902, 1906444.35 4205970.64, 1906429.66 4205944.41, 1906403.94 4205965.72, 1906375.82 4205977.37, 1906356.44 4205994.52, 1906344.83 4206004.81, 1906335.14 4206017.73, 1906311.4 4206047.92, 1906309.44 4206060.06, 1906369.37 4206101.66, 1906417.37 4206132.44, 1906417.62 4206131.87, 1906494.8678622504 4206128.875738373, 1906491.68 4206000.33, 1906518.73 4205959.68, 1906515.1598022364 4205989.438117391, 1906522.8398967795 4206014.250730531, 1906534.0646503426 4206026.066260597, 1906557.1049339718 4206027.247813604, 1906613.879659547 4206033.775768847, 1906666.35 4205926.42, 1906744.82 4205971.2, 1906768.54 4205984.73, 1906799.79 4206016.53, 1906816.47 4206032.22, 1906833.4 4206127.95, 1906868.11 4206164.13, 1906897.41 4206168.37, 1906920.17 4206149.61, 1906942.13 4206165.99, 1906977.33 4206166.07, 1906981.24 4206166.08, 1907023.17 4206156.19, 1907029.04 4206154.81, 1907044.8858382623 4206130.233583097, 1907035.14 4206118.32, 1907028.0929231583 4206093.499227063, 1907198.47 4206046.8, 1907182.81 4206002.54, 1907179.61 4205991.07, 1907165.57 4205939.34, 1907156.57 4205922.22, 1907129.05 4205871.33, 1907118.51 4205860.56, 1907101.39 4205851.46, 1907100.0726537246 4205846.755191874, 1907099.96 4205846.67, 1907093.61 4205841.98, 1907087.46 4205837.66, 1907083.93 4205835.66, 1907075.66 4205832.1, 1907069.34 4205829.43, 1907066.23 4205828.56, 1907063.96 4205828.13, 1907061.1 4205828.42, 1907057.64 4205829.26, 1907056.52 4205829.76, 1907050.55 4205833.33, 1907046.01 4205834.97, 1907041.02 4205833.97, 1907033.18 4205832.91, 1907027.04 4205832.47, 1907021.19 4205832.56, 1907018.26 4205832.68, 1907011.51 4205831.58, 1907007.24 4205830.91, 1907003.8 4205830.87, 1906991.65 4205847.91, 1906950.25 4205888.25, 1906948.051285041 4205890.187664833, 1906942.8819906372 4205888.858417701, 1906913.1954713454 4205886.938394065, 1906912.6046948424 4205889.892276581, 1906914.377024352 4205896.095429867, 1906926.3402485442 4205911.751007204, 1906930.6233781932 4205919.135713495, 1906935.4972843456 4205933.905126078, 1906933.2818724583 4205935.97284384, 1906880.1119871598 4205895.5046533635, 1906863.4225509411 4205872.464369734, 1906862.9794685636 4205869.805875469, 1906857.3670917822 4205867.885851833, 1906840.8253496895 4205863.602722185, 1906800.9479357158 4205860.058063164, 1906794.4493941793 4205857.990345403, 1906777.316875583 4205843.664015197, 1906780.85 4205839.79, 1906800.69 4205844.46, 1906808.22 4205846.39, 1906810.98 4205844.66, 1906813.23 4205842.96, 1906814.48 4205841.17, 1906821.75 4205831.1, 1906825.2 4205827.21, 1906826.83 4205825.47, 1906827.97 4205824.21, 1906828.95 4205823.32, 1906830.95 4205821.84, 1906855.47 4205816.15, 1906870.2 4205799.14, 1906854.89 4205773.47, 1906860.26 4205770.87, 1906869.14 4205767.07, 1906904.96 4205783.21, 1906962.96 4205775.86, 1906974.4 4205681.87, 1906909.55 4205677.43, 1906903.13 4205627.22, 1906901.04 4205626.29, 1906898.79 4205625.28, 1906863.33 4205606.52, 1906872.66 4205573.85, 1906820.85 4205624.2, 1906726.18 4205550.12, 1906730.81 4205547.37, 1906757.67 4205532.08, 1906760.69 4205530.17, 1906783.54 4205522.48, 1906783.34 4205520.75, 1906850.48 4205479.25, 1906829.83 4205430.86, 1906802 4205368.3, 1906775.32 4205310.46, 1906759.3 4205275.29, 1906719.53 4205216.27, 1906643.48 4205234.93, 1906626.06 4205172.46, 1906612.78 4205173.87, 1906608.67 4205052, 1906638.64 4205053.27, 1906639.2929340773 4204969.116897901, 1906697.04 4204975.63, 1906672.66 4204938.81, 1906649.84 4204905.55, 1906629.63 4204875.98, 1906616.7 4204856.63, 1906605.52 4204850.82, 1906586.38 4204838.93, 1906580.02 4204835.21, 1906519.5 4204799.57, 1906505.82 4204792.04, 1906485.95 4204780.42, 1906464.51 4204767.2, 1906441.02 4204752.73, 1906404.49 4204728.6, 1906387.15 4204761.73, 1906386.46 4204763.77, 1906386.33 4204766.63, 1906386.34 4204776.82, 1906376.26 4204775.18, 1906346.12 4204770.27, 1906330.17 4204767.68, 1906296.49 4204818.94, 1906292.29 4204811.3, 1906289.66 4204807.9, 1906286.41 4204803.59, 1906283.58 4204799.79, 1906281.16 4204797.39, 1906278.72 4204793.99, 1906276.37 4204789.51, 1906274.06 4204784.08, 1906271.28 4204779.2, 1906268.05 4204773.83, 1906223.46 4204792.66, 1906217 4204782.36, 1906208.77 4204767.39, 1906202.29 4204758.87, 1906193.44 4204748.71, 1906190.32 4204750.65, 1906183.66 4204752.74, 1906179.2 4204754.32, 1906171.85 4204755.75, 1906166.94 4204756.71, 1906167.82 4204764.78, 1906167.73 4204765.42, 1906167.53 4204766.24, 1906167.03 4204767.25, 1906165.96 4204768.75, 1906158.71 4204775.32, 1906151.35 4204781.85, 1906150.21 4204782.32, 1906148.01 4204783.06, 1906146.9 4204783.56, 1906146.05 4204784.19, 1906145.57 4204784.82, 1906145.29 4204785.44, 1906144.86 4204786.9, 1906144.55 4204789.38, 1906144.85 4204796.98, 1906142.34 4204810.09, 1906139.66 4204822.68, 1906139.12 4204825.83, 1906137.86 4204834.93, 1906136.43 4204840.56, 1906135.33 4204844.04, 1906133.87 4204848.61, 1906131.76 4204855.23, 1906126.4 4204883.63, 1906118.18 4204918.16, 1906115.56 4204929.46, 1906117.63 4204940.59, 1906117.86 4204941.59, 1906118.72 4204942.54, 1906119.59 4204942.87, 1906120.35 4204943.13, 1906121.58 4204943.25, 1906124.37 4204943.7, 1906126.92 4204944.46, 1906127.85 4204944.91, 1906128.4 4204945.78, 1906129.19 4204946.73, 1906130.44 4204949.18, 1906131.85 4204951.6, 1906133.28 4204953.37, 1906136.52 4204958.19, 1906137.64 4204960.27, 1906137.88 4204961.83, 1906137.6 4204964.78, 1906137.34 4204967.3, 1906136.92 4204969.03, 1906136.5 4204972.51, 1906136.04 4204977.1, 1906136.45 4204981.68, 1906136.83 4204986.14, 1906138.8 4204991.21, 1906141 4204993.86, 1906143.29 4204996.46, 1906143.76 4204997.89, 1906144.03 4205005.51, 1906144.52 4205007.98, 1906144.21 4205010.7, 1906143.27 4205014.75, 1906142.43 4205017.4, 1906141.45 4205020.57, 1906141.25 4205023.67, 1906141.09 4205027.35, 1906141.12 4205030.79, 1906142.05 4205035.45, 1906142.52 4205039.88, 1906142.3 4205043.12, 1906140.66 4205047.34, 1906140.44 4205049.87, 1906139.79 4205053.43, 1906138.29 4205058.88, 1906133.48 4205067.24, 1906132.06 4205070.68, 1906131.57 4205072.05, 1906128.1 4205077.44, 1906125.78 4205079.62, 1906134.96 4205087.57, 1906153.22 4205134.46, 1906154.47 4205136.28, 1906152.45 4205137.71, 1906148.61 4205155.36, 1906126.61 4205160.76, 1906125.81 4205160.96, 1906124.22 4205161.35, 1906121.15 4205161.34, 1906115.82 4205161.07, 1906107.69 4205160.75, 1906105.08 4205160.74, 1906102.25 4205161.3, 1906095.94 4205163.38, 1906087.93 4205165.96, 1906084.74 4205172.02, 1906081.46 4205179.83, 1906078.63 4205185.81, 1906077.24 4205190.81, 1906075.61 4205196.04, 1906073.79 4205202, 1906080.68 4205213.12, 1906083.55 4205218.31, 1906085.19 4205222.13, 1906087.59 4205228.45, 1906089.16 4205231.86, 1906093.92 4205243.51, 1906095.77 4205248.56, 1906098.93 4205257.22, 1906103.96 4205272.62), (1905705.02 4204921.89, 1905607.63 4204931.61, 1905604.05 4204931.97, 1905599.89 4204907.35, 1905599.79 4204906.82, 1905606.77 4204840.26, 1905607.4945881127 4204835.793106013, 1905618.6564584696 4204835.91007112, 1905636.6751418205 4204832.956188602, 1905662.0785314632 4204825.128399934, 1905676.1094734168 4204826.162258815, 1905701.3651689335 4204834.13774161, 1905712.4422283706 4204836.0577652445, 1905712.26 4204841.51, 1905705.02 4204921.89))','ZO32161','"lib_modif"=>"N", "lib_code_insee"=>"38187", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UV','Parcs urbains','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UV.pdf','2019-12-20','SRID=3945;POLYGON ((1913834.412676044 4219894.095847904, 1913919.4653746549 4219880.770709872, 1913909.0549366265 4219810.605615497, 1913902.7775627784 4219802.630533548, 1913822.3500478724 4219815.008926756, 1913834.412676044 4219894.095847904))','ZO32918','"lib_modif"=>"N", "lib_code_insee"=>"38151", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UD1','Pavillonnaire en mutation','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD1.pdf','2019-12-20','SRID=3945;POLYGON ((1908925.4310058365 4227595.885832331, 1908936.805699931 4227596.9160020985, 1908946.761850922 4227599.117512819, 1909002.6672999312 4227620.974402097, 1909027.5914999312 4227631.1594020985, 1909035.5007999311 4227636.755802099, 1909131.115199931 4227700.913202099, 1909170.3606999312 4227726.095002099, 1909181.373099931 4227731.989602099, 1909203.392999931 4227740.275602099, 1909221.506899931 4227743.262002097, 1909242.921999931 4227744.644202097, 1909258.0300999312 4227744.231402097, 1909261.2128185267 4227744.237045996, 1909261.4199999308 4227745.1000021, 1909260.1999999308 4227747.350002098, 1909241.839999931 4227781.4300021, 1909238.949999931 4227787.500002099, 1909238.119999931 4227789.2400020985, 1909223.2799999309 4227820.470002099, 1909210.279999931 4227847.8100021, 1909223.829999931 4227854.3200020995, 1909245.1799999308 4227864.580002099, 1909270.7799999309 4227877.000002099, 1909282.8299999312 4227882.840002098, 1909282.9799999308 4227882.910002099, 1909296.9899999308 4227888.710002099, 1909297.7299999308 4227887.990002099, 1909304.4399999308 4227891.680002099, 1909306.0999999312 4227889.9000021, 1909321.1199999312 4227867.0700020995, 1909367.2699999309 4227864.250002098, 1909359.06 4227845.17, 1909355.34 4227836.76, 1909350.27 4227825.22, 1909341.51 4227805.57, 1909336.08 4227793, 1909332.25 4227786.13, 1909323.65 4227771.93, 1909318.46 4227764.65, 1909313.95 4227758.49, 1909307.96 4227753.25, 1909305.32 4227751.06, 1909303.42 4227749.86, 1909288.59 4227735.49, 1909288.58 4227733.71, 1909287.72 4227731.06, 1909286.44 4227726.75, 1909285.33 4227722.67, 1909284.3 4227718.4, 1909283.51 4227714.26, 1909283.05 4227710.19, 1909282.79 4227704.97, 1909282.72 4227700.21, 1909282.89 4227694.95, 1909283.35 4227689.22, 1909283.65 4227684.25, 1909284.36 4227677.35, 1909285.29 4227669.22, 1909285.72 4227666.58, 1909286.75 4227661.35, 1909288.51 4227655.01, 1909290.34 4227649.63, 1909292.55 4227643.4, 1909293.81 4227640.06, 1909294.78 4227637.1, 1909295.46 4227633.79, 1909296.01 4227629.7, 1909296.41 4227624.88, 1909296.58 4227621.41, 1909296.25 4227614.39, 1909296.06 4227606.03, 1909295.85 4227601.52, 1909296 4227598.25, 1909296.21 4227594.98, 1909296.53 4227592.24, 1909297.04 4227589.52, 1909297.84 4227586.78, 1909298.57 4227584.72, 1909302.45 4227576.81, 1909306.96 4227569.29, 1909311.93 4227560.76, 1909315.83 4227554.39, 1909317.78 4227550.91, 1909318.95 4227548.53, 1909320.72 4227544.53, 1909325.3 4227532.29, 1909333.35 4227508.64, 1909333.43 4227508.39, 1909346.99 4227469.27, 1909336.01 4227467.26, 1909342 4227446.86, 1909350.74 4227417.6, 1909353.52 4227407.94, 1909356.28 4227398.51, 1909359.18 4227388.56, 1909361.93 4227378.8, 1909364.68 4227369.08, 1909367.55 4227359.17, 1909370.25 4227349.83, 1909372.86 4227340.28, 1909375.56 4227330.45, 1909378.18 4227320.84, 1909380.92 4227310.78, 1909384.56 4227297.48, 1909387.17 4227287.95, 1909389.84 4227278.23, 1909392.51 4227268.55, 1909395.17 4227258.8, 1909397.78 4227249.19, 1909400.48 4227239.14, 1909401.14 4227235.77, 1909402.04 4227231.43, 1909402.38 4227229.15, 1909402.54 4227225.25, 1909402.52 4227220.49, 1909402.03 4227215.46, 1909401.13 4227210.61, 1909400.25 4227207.12, 1909398.73 4227203.11, 1909397.04 4227199.86, 1909395.09 4227196.24, 1909390.81 4227190.72, 1909387.46 4227187.05, 1909382.62 4227182.4, 1909379.21 4227179.29, 1909375.84 4227177.18, 1909372.65 4227175.44, 1909369.75 4227174.11, 1909366.25 4227172.88, 1909362.07 4227171.44, 1909356 4227170.3, 1909351.44 4227169.99, 1909346.9 4227169.95, 1909328.89 4227171.55, 1909302.31 4227174.77, 1909292.19 4227176.55, 1909290.88 4227176.78, 1909286.5999999312 4227165.240002099, 1909274.9499999308 4227137.230002101, 1909264.839999931 4227113.4600021, 1909263.149999931 4227109.2800021, 1909262.079999931 4227105.9800021015, 1909260.869999931 4227100.0700021, 1909258.5299999309 4227088.230002104, 1909257.4299999308 4227087.180002102, 1909249.9999999308 4227082.300002102, 1909232.1899999308 4227070.120002102, 1909220.7499999308 4227062.540002102, 1909190.0299999309 4227038.290002102, 1909178.569999931 4227030.070002104, 1909167.639999931 4227021.7300021015, 1909148.379999931 4227008.360002102, 1909132.669999931 4226999.910002101, 1909125.999999931 4226994.520002101, 1909114.7399999308 4226985.390002102, 1909111.4799999308 4226982.710002103, 1909110.2199999308 4226982.170002101, 1909109.219999931 4226981.8400021, 1909107.299999931 4226979.640002101, 1909090.109999931 4226965.570002102, 1909084.3599999312 4226961.910002101, 1909079.4599999308 4226958.050002101, 1909071.3799999312 4226951.350002101, 1909068.569999931 4226949.290002103, 1909066.809999931 4226948.240002101, 1909065.349999931 4226947.7400021, 1909063.7499999308 4226947.460002102, 1909061.2499999308 4226947.420002102, 1909059.559999931 4226947.710002103, 1909040.5099999309 4226956.400002102, 1909022.399999931 4226944.280002102, 1909016.879999931 4226940.590002101, 1908995.379999931 4226926.2100021, 1908987.879999931 4226921.200002103, 1908975.4999999308 4226912.900002101, 1908959.27 4226936.1, 1908960.47 4226946.98, 1908961.07 4226952.36, 1908962.32 4226963.81, 1908962.87 4226968.75, 1908965.28 4226990.78, 1908937.73 4226992.14, 1908934.1064494804 4226991.975643764, 1908936.1140717838 4226995.390501873, 1908943.9570824457 4227005.951021941, 1908942.4 4227006.35, 1908922.78 4227010.41, 1908909.94 4227013.08, 1908898.16 4227018.49, 1908893.4 4227021.11, 1908891.51 4227021.87, 1908889.49 4227022.31, 1908885.92 4227022.31, 1908848.81 4227002.86, 1908844.2118895059 4227001.363492909, 1908861.6165999311 4226962.790802101, 1908873.296799931 4226931.6618021, 1908886.676599931 4226899.130202101, 1908876.9682999314 4226896.437002098, 1908863.558399931 4226893.746802101, 1908845.757630209 4226887.758680248, 1908844.6 4226891.46, 1908835.73 4226914.42, 1908826.72 4226909.71, 1908821.97 4226907.24, 1908817.19 4226904.73, 1908811.28 4226903.52, 1908805.54 4226902.34, 1908795.31 4226902.05, 1908791.19 4226902.29, 1908785.45 4226902.63, 1908784.66 4226905.22, 1908781.54 4226911.48, 1908781.34 4226911.88, 1908748.31 4226894.78, 1908746.54 4226893.81, 1908728.63 4226884, 1908720.42 4226880.17, 1908719.04 4226879.53, 1908718.1570598201 4226879.077153756, 1908724.1526999313 4226870.3518020995, 1908731.649699931 4226861.7402021, 1908749.7685999312 4226833.381002104, 1908733.8810782651 4226819.0309815435, 1908723.4231816623 4226811.005962255, 1908722.56 4226812.56, 1908721.8 4226813.52, 1908720.57 4226815.07, 1908717.17 4226812.4, 1908713.48 4226814.07, 1908710.82 4226815.37, 1908708.68 4226816.93, 1908706.09 4226819.19, 1908703.61 4226821.65, 1908701.59 4226823.88, 1908699.97 4226825.99, 1908698.14 4226828.46, 1908697.18 4226830.17, 1908692.54 4226828.31, 1908657.759999931 4226814.420002102, 1908648.749999931 4226823.1000021, 1908646.3299999312 4226824.700002101, 1908642.959999931 4226827.930002102, 1908640.0999999312 4226831.060002102, 1908637.6299999312 4226834.070002101, 1908635.719999931 4226837.240002102, 1908634.459999931 4226839.940002103, 1908630.679999931 4226847.420002103, 1908627.7999999311 4226853.440002102, 1908625.729999931 4226858.620002101, 1908623.8499999312 4226863.800002101, 1908621.519999931 4226871.190002101, 1908619.4099999312 4226877.610002101, 1908617.0499999311 4226884.540002101, 1908614.439999931 4226892.3900021035, 1908611.449999931 4226900.960002102, 1908607.919999931 4226911.7600021, 1908604.519999931 4226921.860002102, 1908601.8599999312 4226929.300002101, 1908599.479999931 4226935.2200021, 1908596.5599999311 4226942.0200021025, 1908594.0899999312 4226947.010002099, 1908592.429999931 4226950.820002102, 1908592.0899999312 4226952.920002101, 1908592.259999931 4226956.1300021, 1908591.5599999314 4226962.8700021, 1908589.959999931 4226969.100002102, 1908589.449999931 4226971.540002102, 1908588.429999931 4226980.9400021015, 1908590.709999931 4226981.680002102, 1908592.8399999312 4226982.760002102, 1908594.769999931 4226984.160002104, 1908596.479999931 4226985.860002101, 1908597.8799999312 4226987.790002102, 1908598.979999931 4226989.920002101, 1908599.709999931 4226992.1900021015, 1908600.0899999312 4226994.560002101, 1908600.0999999312 4226996.950002101, 1908599.729999931 4226999.3200021, 1908598.999999931 4227001.600002099, 1908597.9099999312 4227003.720002101, 1908596.509999931 4227005.660002103, 1908594.8199999311 4227007.370002099, 1908592.8799999312 4227008.770002102, 1908590.749999931 4227009.8700021, 1908588.469999931 4227010.600002102, 1908586.1099999312 4227010.980002102, 1908582.2899999311 4227021.640002101, 1908582.8399999312 4227023.510002103, 1908583.8699999312 4227027.0200021025, 1908584.4899999313 4227030.7400021, 1908585.269999931 4227035.620002103, 1908585.3699999312 4227040.010002099, 1908585.0799999312 4227044.290002099, 1908583.6499999312 4227053.000002102, 1908581.939999931 4227062.770002102, 1908580.449999931 4227071.5500021, 1908579.0399999311 4227080.4500021, 1908577.029999931 4227092.0200021025, 1908575.249999931 4227102.7700021025, 1908573.9099999312 4227110.240002101, 1908572.499999931 4227117.840002102, 1908571.0699999311 4227126.170002102, 1908569.8799999312 4227134.000002103, 1908568.759999931 4227142.870002102, 1908568.0399999311 4227149.920002099, 1908567.419999931 4227158.050002101, 1908567.3899999312 4227164.1800021, 1908567.1499999312 4227170.1800021, 1908567.2899999311 4227177.080002101, 1908567.939999931 4227187.000002101, 1908568.8999999312 4227196.270002102, 1908569.9099999312 4227206.8300021, 1908571.689999931 4227213.610002102, 1908573.689999931 4227220.500002101, 1908574.0599999311 4227232.790002099, 1908574.769999931 4227243.230002101, 1908576.949999931 4227256.090002101, 1908579.6399999312 4227270.7100021, 1908579.939999931 4227278.9500021, 1908578.5499999311 4227289.200002102, 1908576.449999931 4227303.940002101, 1908575.8599999314 4227313.1900021, 1908575.669999931 4227327.1100021005, 1908576.0499999314 4227332.450002101, 1908577.179999931 4227340.550002099, 1908580.0799999312 4227361.810002101, 1908582.1099999312 4227367.960002102, 1908584.919999931 4227374.780002101, 1908589.6499999312 4227384.590002101, 1908600.519999931 4227401.780002101, 1908612.8499999314 4227421.120002099, 1908617.8099999311 4227430.1300021, 1908620.3399999312 4227437.6600021, 1908627.8699999312 4227466.640002099, 1908634.3299999312 4227493.760002099, 1908636.8199999311 4227508.370002101, 1908636.5599999314 4227514.560002098, 1908635.3299999312 4227519.870002101, 1908626.699999931 4227538.6500021005, 1908614.9099999312 4227564.2200021, 1908606.0599999311 4227581.980002099, 1908597.1299999312 4227599.1100021, 1908584.9399999313 4227618.930002098, 1908580.51 4227626.6, 1908578.18 4227632.31, 1908573.15 4227650.05, 1908571.81 4227656.84, 1908570.71 4227668.22, 1908573.07 4227669.33, 1908577.85 4227669.65, 1908582.49 4227669.96, 1908588.69 4227669.78, 1908593.21 4227667.29, 1908594.46 4227664.22, 1908597.8 4227664.67, 1908601.13 4227665.13, 1908602.57 4227667.53, 1908603.19 4227667.01, 1908604.83 4227669.62, 1908607.83 4227673.39, 1908617.6 4227663.62, 1908619.61 4227661.75, 1908617.68 4227669.28, 1908615.96 4227675.98, 1908612.71 4227691.16, 1908610.12 4227703.24, 1908605.15 4227718.63, 1908602.23 4227727.67, 1908596.53 4227744.05, 1908589.36 4227743.18, 1908587.48 4227758.18, 1908585 4227757.87, 1908584 4227765.84, 1908583.55 4227770.5, 1908583.31690236 4227776.693628506, 1908592.56 4227777.57, 1908606.16 4227788.67, 1908621.08 4227789.58, 1908619.75 4227810.89, 1908619.4558559512 4227812.61068847, 1908630.4026249996 4227813.312097985, 1908642.5127433639 4227816.403633311, 1908664.0545052176 4227821.018818166, 1908667.6325999312 4227821.7854021, 1908687.0484999313 4227825.971402098, 1908706.7646999313 4227830.957402098, 1908722.2759999312 4227832.8454021, 1908727.7786999312 4227831.740202095, 1908732.1795999312 4227830.035002098, 1908735.2798999313 4227827.630802098, 1908737.6780999312 4227824.026602099, 1908744.8726999313 4227813.013802099, 1908766.2527999312 4227773.671202098, 1908769.550499931 4227768.9658021, 1908773.7504999314 4227765.660002098, 1908778.951499931 4227763.654002098, 1908784.6199999312 4227757.080002099, 1908782.8099999311 4227754.860002099, 1908781.8899999312 4227753.4500021, 1908781.1299999312 4227750.7000021, 1908780.6199999312 4227747.670002101, 1908780.5399999311 4227744.360002099, 1908780.729999931 4227741.6900021, 1908781.279999931 4227738.9300021, 1908782.019999931 4227735.660002099, 1908781.9099999312 4227733.880002101, 1908782.1299999312 4227731.580002099, 1908782.1099999312 4227729.050002101, 1908781.8199999311 4227727.560002099, 1908779.929999931 4227722.4400021, 1908777.019999931 4227716.790002098, 1908772.5999999312 4227708.270002101, 1908768.019999931 4227699.390002101, 1908762.189999931 4227688.590002102, 1908754.8999999312 4227674.6400021, 1908746.929999931 4227659.380002101, 1908739.189999931 4227644.690002101, 1908730.5999999312 4227628.560002101, 1908723.929999931 4227615.5600021025, 1908715.939999931 4227600.450002098, 1908708.949999931 4227586.9900021, 1908700.929999931 4227571.6100021005, 1908694.9099999312 4227560.0400021, 1908689.6099999312 4227550.110002102, 1908688.5399999311 4227547.990002102, 1908686.7899999311 4227545.8000021, 1908684.8599999312 4227544.0800021, 1908682.5799999312 4227542.4000021005, 1908679.6399999312 4227541.1100021005, 1908675.669999931 4227540.460002099, 1908675.729999931 4227533.050002101, 1908675.8599999312 4227519.810002099, 1908675.989999931 4227506.0900021, 1908676.439999931 4227456.830002101, 1908676.749999931 4227423.6200021, 1908682.259999931 4227429.510002099, 1908682.1099999312 4227429.8500021, 1908686.6099999312 4227434.870002101, 1908691.8299999312 4227440.7600021, 1908697.5999999312 4227447.270002101, 1908703.0499999311 4227453.1300021, 1908704.979999931 4227452.840002101, 1908714.259999931 4227463.910002102, 1908722.999999931 4227473.370002101, 1908728.939999931 4227479.9800021, 1908736.779999931 4227488.660002101, 1908743.6199999312 4227496.370002102, 1908751.0799999312 4227504.860002101, 1908757.6199999312 4227511.6200021, 1908763.8699999312 4227518.2800021, 1908767.3799999312 4227522.3200021, 1908771.8799999312 4227528.2200021, 1908777.439999931 4227534.9400021, 1908778.919999931 4227537.370002099, 1908816.3199999311 4227527.1000021, 1908858.3799999312 4227515.730002101, 1908884.259999931 4227508.6600021, 1908906.9699999308 4227502.400002101, 1908928.3999999312 4227496.760002099, 1908927.949999931 4227490.4300021, 1908930.1199999312 4227488.280002101, 1908946.949999931 4227491.680002101, 1908944.76 4227504.35, 1908941.58 4227523.89, 1908938.1 4227544.24, 1908936.32 4227555.09, 1908933.48 4227571.36, 1908928.94 4227571.71, 1908928.56 4227577.64, 1908927.72 4227584.52, 1908926.7826694914 4227588.834379433, 1908926.31 4227591.01, 1908925.4310058365 4227595.885832331), (1908890.205731751 4227076.572805684, 1908934.266099931 4227085.5038021, 1908957.0910268645 4227098.492210734, 1908971.9079223883 4227107.58508448, 1908977.0154316244 4227112.6838339, 1908982.7276034527 4227122.785136178, 1908982.5296999312 4227125.3870021, 1908983.033699931 4227129.4888021005, 1908984.8403999312 4227135.591202099, 1908977.838999931 4227139.6996021, 1908974.1380999312 4227141.604002099, 1908970.036099931 4227142.1076021, 1908966.834299931 4227142.010802099, 1908960.218599271 4227141.597378346, 1908959.84 4227144.52, 1908959.36 4227147.17, 1908957.61 4227156.29, 1908956.23 4227167.5, 1908955.91 4227169.62, 1908955.39 4227172.06, 1908954.79 4227174.37, 1908954.38 4227175.74, 1908952.89 4227178.58, 1908950.21 4227183.74, 1908949.14 4227187.01, 1908948.45 4227189.44, 1908947.23 4227196.4, 1908946.66 4227199.61, 1908945.22 4227210.15, 1908944.96 4227214.18, 1908944.51 4227220.63, 1908943.86 4227230.9, 1908943.19 4227240.03, 1908942.7 4227246.8, 1908909.93 4227250.62, 1908909.53 4227253.05, 1908906.99 4227252.51, 1908897.96 4227250.6, 1908884.39 4227247.75, 1908882.26 4227247.3, 1908878.4690999312 4227246.050002098, 1908875.6683999312 4227247.153602101, 1908872.2663999312 4227247.056202099, 1908868.3624999311 4227245.7586020995, 1908864.9590999312 4227244.3608021, 1908861.9560999312 4227242.6626021005, 1908858.852299931 4227240.4636021005, 1908855.548299931 4227237.865002099, 1908852.6439999314 4227234.965402098, 1908850.439699931 4227231.665202099, 1908849.2363999311 4227228.1644021, 1908849.232899931 4227223.961802099, 1908850.128899931 4227219.358002099, 1908851.3258999311 4227214.554002098, 1908852.321299931 4227209.450002099, 1908853.8143999313 4227199.842802099, 1908854.612399931 4227196.240002099, 1908854.9098999312 4227193.2378020985, 1908853.606499931 4227190.837402099, 1908835.5807999314 4227173.642802098, 1908830.773899931 4227169.2438020995, 1908828.370799931 4227166.744602099, 1908828.9678999311 4227163.3418021, 1908829.6650999312 4227159.438802098, 1908830.661199931 4227154.835002098, 1908831.9568999312 4227148.530002099, 1908832.654099931 4227144.0266021, 1908833.450699931 4227140.1236021, 1908833.9490999312 4227137.6220021, 1908834.6469999312 4227134.419002099, 1908835.643799931 4227129.815802101, 1908836.840099931 4227124.8112021, 1908837.735399931 4227119.107002099, 1908838.432599931 4227115.9046021, 1908841.1324999314 4227113.301002098, 1908846.2354999313 4227113.396202099, 1908849.4386999311 4227114.1944021005, 1908853.7415999311 4227114.9910021, 1908858.5456999312 4227116.588002099, 1908863.650099931 4227118.184202099, 1908868.4541999311 4227119.281202099, 1908872.6576999314 4227120.6782021, 1908876.589885495 4227121.174969268, 1908884.270699931 4227110.666402101, 1908888.5784250747 4227087.758726412, 1908890.205731751 4227076.572805684), (1908961.9001060636 4227449.890807552, 1908968.7979455027 4227407.99068528, 1908971.9974078904 4227389.1670436915, 1908975.5548503264 4227366.9314671615, 1908983.49 4227367.41, 1909020.12 4227371.74, 1909033.32 4227373.44, 1909039.61 4227374.22, 1909045.46 4227374.98, 1909054.52 4227376.46, 1909055.62 4227348.87, 1909056.51 4227326.34, 1909059.06 4227262.54, 1909059.12 4227261.13, 1909059.1155190924 4227259.088767454, 1909063.0337897998 4227257.240753097, 1909090.595174541 4227240.865113398, 1909095.792524548 4227234.056469103, 1909099.7961839624 4227235.453891506, 1909105.3998806772 4227235.7492633825, 1909111.402791776 4227234.843554465, 1909118.5055189016 4227232.936285968, 1909135.1912468038 4227253.566462815, 1909141.7692472336 4227263.421394964, 1909149.5636999311 4227278.637802101, 1909153.977384013 4227290.5990415085, 1909156.2134879923 4227302.280374241, 1909156.926299011 4227316.1334694885, 1909158.500698888 4227321.671585922, 1909158.642699931 4227363.982602098, 1909158.553099931 4227375.889802099, 1909158.6298751556 4227382.5946021, 1909157.663399931 4227388.798402099, 1909156.3349818292 4227394.941557302, 1909149.6661329856 4227415.008751387, 1909141.347191972 4227438.110156528, 1909129.673912768 4227470.9736020975, 1909127.3257713623 4227477.59101386, 1909123.13 4227476.8, 1909120.9 4227476.44, 1909088.42 4227471.06, 1909054.89 4227465.51, 1909029.42 4227461.31, 1909009.87 4227457.98, 1908971.6 4227451.48, 1908969.09 4227451.05, 1908961.9001060636 4227449.890807552))','ZO32707','"lib_modif"=>"N", "lib_code_insee"=>"38474", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','A','Agricole','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1907724.6311323512 4214319.206996697, 1907724.1164988673 4214337.062097934, 1907724.4933019043 4214348.14222194, 1907727.5123996725 4214354.190365385, 1907730.9412345197 4214359.1365110865, 1907736.942505045 4214364.113884151, 1907741.292643564 4214366.77365916, 1907739.9780423325 4214370.294393398, 1907742.7678253148 4214387.846425764, 1907743.5412188864 4214391.558253577, 1907744.226750917 4214397.840801002, 1907744.6814087029 4214403.013521303, 1907745.4997019852 4214412.217798264, 1907749.6156200862 4214427.733016632, 1907754.15229089 4214444.559014729, 1907757.1858184498 4214458.684174619, 1907757.4516136826 4214464.847613989, 1907754.6265717484 4214472.7744757645, 1907751.0816873845 4214481.36232214, 1907745.319444145 4214493.81402896, 1907741.2436434694 4214501.441787793, 1907740.016743755 4214505.89553698, 1907739.024228792 4214515.5816299375, 1907740.4129879754 4214524.9559213, 1907741.770750423 4214533.179391961, 1907744.1457890724 4214537.529818135, 1907745.870304635 4214541.460561891, 1907746.2546292895 4214546.5228829635, 1907750.6582832786 4214548.140044938, 1907759.5410069632 4214556.747327633, 1907767.9920841963 4214564.64477827, 1907775.4521743285 4214571.332191455, 1907789.1790446946 4214582.076152891, 1907805.8504763646 4214596.229926321, 1907811.173310564 4214595.805155713, 1907819.4669764517 4214595.0980968075, 1907827.729384103 4214592.229247556, 1907841.3116387236 4214586.1344529, 1907859.3259907134 4214579.104757453, 1907886.1733299282 4214570.217293028, 1907906.9990592191 4214563.185198916, 1907932.490871672 4214548.00494416, 1907972.9552631853 4214514.702137462, 1907996.5717171007 4214495.420770668, 1907986.3891426472 4214463.441664359, 1907975.1688062565 4214447.212099691, 1907974.1934383612 4214441.7900825385, 1907970.4072593169 4214425.063705793, 1907964.9969981562 4214404.616622624, 1907958.5437955782 4214393.846067331, 1907956.9179476749 4214388.054197593, 1907955.931456787 4214380.850990238, 1907956.7057458768 4214373.6366768135, 1907957.0029632007 4214370.174278126, 1907954.8649583275 4214350.214885532, 1907947.097623679 4214335.223280624, 1907934.9133203342 4214314.962079097, 1907929.066337324 4214310.384688716, 1907928.2979216476 4214312.516540592, 1907925.2697002685 4214316.601414291, 1907913.0303936794 4214325.486629891, 1907896.88907605 4214334.585288381, 1907890.728905431 4214338.683036641, 1907881.31163176 4214348.096544944, 1907876.1624958122 4214352.273276448, 1907872.6411036989 4214353.196593929, 1907908.3041373931 4214298.245555441, 1907913.7840355567 4214282.771998762, 1907908.9608357623 4214258.712798013, 1907905.9645914412 4214241.145287599, 1907907.3004445145 4214223.654531887, 1907897.7963187017 4214225.543486584, 1907892.7441591127 4214225.867771258, 1907885.7765292735 4214233.478176882, 1907875.7041745859 4214249.095521392, 1907861.6136039165 4214269.458952922, 1907855.476428643 4214276.588381886, 1907842.8462632173 4214284.7235041335, 1907831.4961978123 4214292.367660441, 1907825.0921238777 4214296.091633713, 1907841.6879294876 4214230.718156072, 1907841.6896282923 4214230.71396606, 1907860.4011190815 4214208.385901629, 1907862.1508052042 4214207.333821305, 1907868.9856819767 4214220.064746508, 1907882.6996971255 4214215.740841244, 1907885.5703393384 4214214.83788982, 1907902.7532551824 4214206.468358876, 1907911.878850375 4214171.801333414, 1907906.3772672988 4214138.577380208, 1907909.0377478846 4214125.648062095, 1907907.8419774391 4214119.425390386, 1907905.006533255 4214103.158682446, 1907901.5545791432 4214079.8883735845, 1907898.9812300082 4214066.142858446, 1907900.388754641 4214062.309710736, 1907911.7419502304 4214093.577573159, 1907928.2341819603 4214144.0416292725, 1907939.276901748 4214151.936852167, 1907940.4310912935 4214167.834587989, 1907941.4887241425 4214176.098523731, 1907948.2332982535 4214188.529953845, 1907952.6593480043 4214204.454920058, 1907952.0118869112 4214207.627051849, 1907952.3489662898 4214250.931471678, 1907961.495593669 4214264.89111688, 1907967.5178227725 4214275.041885674, 1907967.5005105066 4214277.973346428, 1907970.5560563677 4214282.703799442, 1907975.6223714699 4214287.011702096, 1907987.7859960147 4214294.985816469, 1907998.978948501 4214302.340609758, 1908007.6685547044 4214308.356383866, 1908008.7670611457 4214317.380316002, 1908009.5005716234 4214320.781801459, 1908018.6879567907 4214335.362162267, 1908024.0143210213 4214363.022962723, 1908033.2610855845 4214400.066097721, 1908037.452863698 4214422.85553387, 1908039.4312289637 4214442.8648955915, 1908036.3521377356 4214457.69585772, 1908053.0510483577 4214468.867706797, 1908072.9095864824 4214466.019578677, 1908072.3784513401 4214488.032009082, 1908063.7660194465 4214490.860941082, 1908065.0649875854 4214500.525268911, 1908095.1727770125 4214501.53036912, 1908101.696228892 4214501.745128564, 1908138.2046136651 4214498.992053128, 1908148.8465883262 4214517.743524967, 1908162.513817506 4214516.971836184, 1908182.8969480637 4214507.66902082, 1908188.3579760815 4214505.273215841, 1908192.379287504 4214504.159159551, 1908200.0407266237 4214500.560200977, 1908204.5531200017 4214500.15652516, 1908212.8069533613 4214499.20875192, 1908228.4847098729 4214498.434743286, 1908228.8481490377 4214502.226765807, 1908227.7623177506 4214507.360579313, 1908229.6387031316 4214560.499069908, 1908193.385337921 4214557.488099438, 1908184.949620517 4214591.524245929, 1908190.8693991974 4214599.083451106, 1908194.1677806647 4214606.264879597, 1908198.1451633445 4214612.764945606, 1908212.6190268474 4214642.679438813, 1908215.1714692102 4214643.858125127, 1908225.4258933393 4214653.765155301, 1908234.6888273603 4214663.282211689, 1908239.4247503257 4214666.630456692, 1908246.309314182 4214667.905100987, 1908253.3578434528 4214672.781633326, 1908258.825869893 4214678.580433363, 1908265.5708224007 4214692.122504481, 1908270.8791510393 4214697.911235275, 1908280.0925680078 4214707.788536695, 1908305.3792631752 4214710.428845713, 1908327.9257813133 4214703.655789064, 1908346.3727308747 4214699.157310782, 1908369.7103872388 4214692.964101917, 1908390.6242128853 4214695.597330845, 1908397.6823085572 4214700.424023224, 1908403.8010280684 4214706.132213968, 1908414.1318463676 4214735.880349259, 1908437.7945536806 4214722.972673259, 1908450.0281424809 4214719.340380392, 1908455.8538717553 4214722.206819781, 1908461.9611818586 4214726.504224598, 1908466.8973697298 4214730.962320057, 1908469.766284951 4214739.274552182, 1908464.6499216277 4214746.673289851, 1908466.2753224238 4214751.924860239, 1908470.7779409238 4214752.020668703, 1908486.7534503965 4214759.641517472, 1908498.0185598033 4214758.661142913, 1908483.267140102 4214673.065533075, 1908475.0570099773 4214666.148850944, 1908480.4366440577 4214662.642482112, 1908485.468141171 4214649.370712893, 1908486.6317449007 4214641.115071621, 1908486.4092934902 4214637.923264907, 1908481.9741234027 4214623.319032619, 1908480.7383951533 4214617.426571557, 1908480.3783773617 4214605.700479591, 1908480.862087581 4214598.4858063115, 1908483.5798220176 4214582.334396476, 1908484.0414739612 4214571.787868073, 1908484.2783341706 4214567.9557096865, 1908483.103170399 4214562.683947441, 1908476.7381360107 4214549.741902847, 1908472.1080916333 4214541.030756888, 1908469.142934341 4214536.710859298, 1908461.101464882 4214528.343020134, 1908456.39365244 4214522.763902586, 1908431.3333434777 4214527.197796219, 1908420.2804274869 4214495.459584315, 1908420.813847372 4214476.158275855, 1908420.4616706832 4214461.660425503, 1908418.6722221472 4214452.006726303, 1908430.6568777326 4214449.334591145, 1908437.777211806 4214445.506759464, 1908434.1035327772 4214443.148170561, 1908428.254159124 4214436.489422247, 1908425.750419949 4214433.2899616975, 1908419.4778015679 4214411.162681183, 1908418.4426042042 4214405.991058711, 1908421.3727265163 4214403.737290387, 1908423.3305717432 4214400.393539702, 1908425.027088585 4214394.729108129, 1908426.4775957898 4214382.891017852, 1908426.5082444202 4214371.68449531, 1908426.7964038285 4214369.573463243, 1908432.1012732948 4214372.020108247, 1908443.2909932616 4214375.572349261, 1908455.6212236185 4214379.674124618, 1908468.2920505726 4214384.015743292, 1908472.7071772378 4214387.113913467, 1908477.0643736492 4214392.6735161515, 1908487.1355952376 4214387.712126843, 1908519.229938882 4214465.338342168, 1908524.4396227808 4214461.071493063, 1908530.372369072 4214460.616168949, 1908569.1443323318 4214437.169864148, 1908570.6868248335 4214427.602768947, 1908560.2835706149 4214419.1673167655, 1908559.4216280384 4214417.226562503, 1908559.3102098103 4214415.405834463, 1908568.748092418 4214395.016312866, 1908561.3581063203 4214376.952477477, 1908558.2919864631 4214347.928792465, 1908554.7380076975 4214333.903751246, 1908551.0754344463 4214310.123925472, 1908560.759418722 4214296.717923983, 1908564.1506633717 4214284.007690067, 1908558.097837089 4214273.20679756, 1908550.4272778383 4214254.182671376, 1908548.6878441076 4214232.812162468, 1908536.6821066015 4214233.983476343, 1908532.7578586896 4214231.354953451, 1908475.2819136577 4214261.931208612, 1908471.1220926296 4214311.712912241, 1908463.568387705 4214312.810179307, 1908462.6549768592 4214308.94839067, 1908458.462063324 4214308.76226678, 1908457.8821206416 4214308.742350843, 1908455.184799354 4214302.4110989105, 1908414.5903215639 4214288.728077908, 1908411.7085008188 4214276.543697248, 1908392.8549044412 4214284.96452105, 1908389.7682660972 4214278.984198334, 1908376.3636315214 4214282.137211495, 1908371.286104165 4214276.658669781, 1908361.9138085896 4214280.3683526255, 1908343.0584075376 4214286.6783891255, 1908336.6043528488 4214286.173614072, 1908325.183216265 4214280.169790294, 1908302.4499840653 4214267.902102486, 1908292.1919627748 4214265.719630363, 1908265.6754979065 4214263.400953083, 1908266.0648811003 4214274.377183219, 1908267.019117019 4214278.9485357115, 1908268.3833006113 4214282.71988934, 1908271.2734832948 4214292.752656896, 1908273.1625211048 4214302.33662698, 1908277.7496702597 4214319.182373667, 1908281.2855895704 4214335.277997023, 1908280.5145265255 4214335.0085035525, 1908279.1333337456 4214334.519807534, 1908266.141482351 4214328.947762531, 1908266.8210745384 4214328.256794619, 1908271.04641877 4214320.018362472, 1908270.8142004958 4214317.336854586, 1908269.4987286136 4214311.554929739, 1908264.806945831 4214300.832711306, 1908261.3795094907 4214294.372407714, 1908255.037971568 4214285.022167667, 1908253.4895881105 4214276.448874928, 1908249.7857235742 4214274.590991623, 1908234.5519483872 4214268.000286862, 1908220.3286574564 4214262.249190735, 1908218.4744981087 4214258.358788236, 1908214.7931019708 4214247.655519874, 1908210.58879245 4214233.411310412, 1908199.5320211842 4214221.023788237, 1908193.1453558397 4214217.176876277, 1908187.64061127 4214215.47061343, 1908179.4271891771 4214216.628467853, 1908165.8042208988 4214222.113363585, 1908140.6979465254 4214231.749780402, 1908136.1865772288 4214232.644529207, 1908107.9697699372 4214231.507547997, 1908103.1351836205 4214229.31083653, 1908111.51 4214221.33, 1908124.59 4214207.05, 1908125.65 4214204.81, 1908125.9 4214203.19, 1908113.37 4214205.21, 1908112.86 4214203.33, 1908112.854963967 4214203.328574362, 1908112.8582895417 4214203.327764906, 1908112.4867128362 4214201.957512737, 1908100.4844200097 4214195.203754852, 1908098.3550592158 4214185.390063365, 1908120.4318220827 4214179.027472543, 1908125.1322342046 4214176.65213237, 1908127.9008121234 4214172.927682278, 1908131.7006682737 4214170.493076597, 1908150.0065997853 4214165.404613365, 1908168.1228754292 4214160.376344396, 1908178.3360047543 4214157.796387559, 1908184.9709850908 4214159.271756842, 1908188.3468651879 4214163.711368392, 1908192.4055560841 4214171.231926139, 1908194.6221190088 4214177.703466567, 1908195.8091625744 4214184.946718198, 1908198.8849943925 4214189.526464585, 1908202.3912737905 4214194.816642535, 1908214.5362167372 4214204.11149961, 1908240.146177185 4214222.620241376, 1908263.5934606849 4214239.409661775, 1908284.8485325614 4214231.136883559, 1908290.391932799 4214219.755766037, 1908290.4801101398 4214205.60755092, 1908293.2917482103 4214193.9586151615, 1908299.2091486882 4214187.489736238, 1908302.1806826587 4214198.583825638, 1908299.367105465 4214207.961088556, 1908298.8425161317 4214215.115751289, 1908298.1848587946 4214229.544210169, 1908306.2323921765 4214233.079327246, 1908323.8395723375 4214242.099364739, 1908338.0850719193 4214238.7055021925, 1908345.3032563545 4214232.065614821, 1908351.5594313804 4214234.952095254, 1908393.6028586365 4214211.793009492, 1908403.7942456491 4214218.197703278, 1908410.4068105542 4214228.568278046, 1908417.038383093 4214226.050803313, 1908411.559987819 4214196.158706047, 1908407.938268235 4214185.045962867, 1908395.9553956278 4214154.649140099, 1908366.7301881483 4214155.80453565, 1908364.4195113692 4214144.58021193, 1908391.6745908596 4214144.336610016, 1908405.841672966 4214143.324347845, 1908412.7308642343 4214138.085327792, 1908369.7125145106 4214133.139276998, 1908346.0491318367 4214121.292630345, 1908338.0835867082 4214108.312349481, 1908337.007669824 4214090.603337855, 1908349.9839149623 4214089.161654774, 1908393.5580387982 4214077.087691537, 1908397.1803976756 4214065.7580478145, 1908429.1555494983 4214051.032694963, 1908459.006020474 4214043.232834756, 1908458.2161539132 4214032.196924117, 1908346.8689405282 4214003.595953376, 1908328.2473430564 4213990.514916201, 1908317.8963667345 4213996.166916154, 1908307.0356169248 4214002.419687435, 1908304.2168738984 4214005.743755257, 1908298.0287628286 4214011.552490409, 1908288.012240432 4214022.206807569, 1908280.2246870392 4214030.658388534, 1908258.2317751022 4214041.693336641, 1908253.0021925448 4214045.1497353185, 1908248.5237444446 4214050.145956278, 1908241.7777439188 4214059.267223945, 1908234.5203806781 4214067.127621128, 1908228.540878338 4214071.875383322, 1908210.1693040298 4214081.636325863, 1908197.8585770626 4214089.111416743, 1908189.459428838 4214095.632236271, 1908178.8003504248 4214103.955993972, 1908169.8912396203 4214110.8572614975, 1908167.4137548935 4214115.201610492, 1908165.2184347038 4214122.367901563, 1908164.9846772996 4214129.842292945, 1908160.194600189 4214132.667962433, 1908149.879388583 4214133.106604221, 1908136.9117750581 4214132.707637287, 1908113.3562010312 4214130.406229372, 1908095.5942085537 4214127.790103983, 1908081.1048252918 4214126.0812966665, 1908071.9053874174 4214121.296654545, 1908057.8793275852 4214111.683417957, 1908041.9109142062 4214100.350671998, 1908026.5117007573 4214088.4068978075, 1908021.2434890182 4214081.767464377, 1908015.2218600758 4214072.317297136, 1908007.2465463118 4214059.827490759, 1907999.2611243846 4214046.746962214, 1907994.5309955874 4214038.2058048565, 1907985.824336119 4214024.145542396, 1907978.0287762452 4214011.2449540775, 1907971.1449928042 4213999.594089691, 1907964.3321662452 4213988.78423643, 1907956.9779030383 4213976.6432989, 1907949.2829779182 4213964.183273159, 1907947.2880647173 4213959.962207791, 1907946.634669283 4213956.171040581, 1907947.2183181525 4213948.566083328, 1907949.902067876 4213939.698630238, 1907950.7804666925 4213937.006574127, 1907944.9092745315 4213939.232822305, 1907912.1886793189 4213960.522817868, 1907906.7092218536 4213964.529329079, 1907903.8978918577 4213964.582152954, 1907902.1321581253 4213959.480798863, 1907894.5319248377 4213940.486631465, 1907893.3856087392 4213933.823875753, 1907889.7486416772 4213916.057022344, 1907892.4926994096 4213907.509498808, 1907894.625009123 4213896.842109484, 1907897.7851155486 4213883.381681506, 1907895.5974291635 4213875.559364994, 1907889.7518613327 4213861.356191581, 1907884.5759645684 4213858.068959002, 1907882.602684223 4213855.279077609, 1907883.120080625 4213851.64660365, 1907884.9134997963 4213842.739690823, 1907882.58783335 4213837.8489337815, 1907875.332297589 4213824.608101385, 1907870.8422902066 4213815.336736018, 1907871.1398832365 4213812.314391271, 1907872.6448290758 4213805.859497685, 1907870.1180751594 4213799.588139942, 1907863.5654255622 4213789.038016188, 1907855.2113268275 4213777.968936157, 1907844.8678805495 4213768.50264667, 1907843.6647120623 4213765.571631333, 1907844.4929988587 4213763.250027405, 1907844.3774609596 4213756.586398156, 1907841.2712748055 4213751.596051203, 1907836.5947735892 4213746.797348385, 1907834.6913724323 4213744.287765115, 1907826.0739946582 4213741.2832207205, 1907816.682952766 4213734.247479974, 1907800.8240020901 4213722.40435602, 1907797.6487964168 4213718.844667985, 1907794.015282878 4213705.120486068, 1907791.9595572893 4213699.97916095, 1907785.9883152775 4213690.458720069, 1907770.8781624069 4213688.6909919325, 1907767.4453595805 4213687.1828702465, 1907765.6408266558 4213683.042090874, 1907762.4467340764 4213657.300618642, 1907760.5618794542 4213652.599194706, 1907747.7027808896 4213638.602514393, 1907736.394894137 4213625.244471119, 1907729.365155934 4213618.416837145, 1907717.6012720442 4213621.578613548, 1907710.819240316 4213623.645338877, 1907706.9357280305 4213621.597898773, 1907698.6933687618 4213612.719949927, 1907686.83624329 4213600.142809262, 1907675.234300209 4213593.95902369, 1907661.3521837892 4213589.06849982, 1907646.5505289072 4213585.08886627, 1907633.019357548 4213580.607471013, 1907630.7524382295 4213574.196017054, 1907625.4597932957 4213562.804354418, 1907622.526212347 4213560.285442182, 1907614.0593956534 4213557.83127167, 1907598.0151910912 4213551.901603021, 1907595.0812698675 4213548.982267182, 1907592.6239646776 4213541.770128335, 1907590.2586127433 4213537.500154725, 1907584.3479268395 4213528.579998629, 1907582.2655531506 4213527.391305365, 1907581.765210179 4213527.081357695, 1907575.9909728714 4213526.1257336065, 1907555.8779342128 4213524.00144751, 1907546.3508514785 4213521.458126571, 1907536.9810325373 4213516.063079061, 1907521.905327263 4213507.491107475, 1907507.3183903573 4213497.618393502, 1907491.8606077633 4213486.615388076, 1907486.796265992 4213484.5983660575, 1907473.746140443 4213481.727854086, 1907466.4756926997 4213474.2100354405, 1907451.42479429 4213459.50441574, 1907437.5458006703 4213446.268620614, 1907434.9123479892 4213443.6996242525, 1907433.6631865387 4213445.271763118, 1907428.50656033 4213452.630251773, 1907431.249515091 4213466.0754266195, 1907438.6856288058 4213468.6205292335, 1907444.2875473665 4213478.731414016, 1907448.2232784738 4213482.890191652, 1907505.1054594815 4213542.685042325, 1907465.7060652757 4213568.823528332, 1907479.4463288498 4213607.403207503, 1907507.758755146 4213685.763145566, 1907513.3356659259 4213713.753857424, 1907526.5111592296 4213758.838075181, 1907535.0310966787 4213788.447198555, 1907541.7748295139 4213811.9248036165, 1907557.7715027705 4213844.529252762, 1907561.5505657636 4213852.230150649, 1907580.9711491996 4213922.452959367, 1907573.0009669035 4213939.249344646, 1907565.025063552 4213961.318489771, 1907561.1499482717 4213981.143092309, 1907562.146843737 4213988.596020984, 1907567.6836433515 4213993.414413377, 1907607.3328022459 4214001.104607032, 1907623.957921262 4214043.434593779, 1907636.52159674 4214074.981194484, 1907628.4600941492 4214101.573363289, 1907629.2958768771 4214108.056288285, 1907650.7186737524 4214144.478496376, 1907670.4656524293 4214210.188369808, 1907685.7670182008 4214260.233245461, 1907698.746045825 4214262.043619111, 1907698.1188012564 4214265.696003539, 1907694.3198551233 4214269.911802975, 1907687.4823624862 4214277.371409151, 1907677.7659024862 4214287.945613784, 1907667.519029534 4214298.150462316, 1907668.1162293325 4214306.454418102, 1907666.1405771296 4214312.869502001, 1907664.1200142526 4214313.071734519, 1907657.4903861561 4214329.876613977, 1907645.0809278912 4214362.455473784, 1907652.9653065277 4214373.915206251, 1907639.052933778 4214404.063984343, 1907659.3234467248 4214426.068910023, 1907669.341725316 4214417.425728613, 1907688.1196567337 4214391.305271471, 1907691.8472393323 4214362.495510498, 1907705.4899656894 4214356.220576762, 1907710.9107817446 4214341.848089355, 1907711.5576922367 4214338.025191231, 1907712.3530687054 4214332.301499044, 1907712.3592686749 4214332.282879259, 1907721.838157177 4214303.815827535, 1907721.8703808312 4214303.996994099, 1907724.6311323512 4214319.206996697))','ZO33133','"lib_modif"=>"N", "lib_code_insee"=>"38524", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','N','Naturelle','N',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/N.pdf','2019-12-20','SRID=3945;POLYGON ((1911574.9225914269 4235398.6041057855, 1911470.6832484654 4234955.302881458, 1911462.4061705237 4234914.8579325145, 1911448.5564303065 4234858.038573429, 1911402.5449999587 4234755.320000032, 1911368.6044331603 4234677.45546563, 1911326.5515586839 4234587.2070344305, 1911238.3749999723 4234408.760000033, 1911197.7867003968 4234317.349585022, 1911068.7824999292 4234121.7275, 1910962.4605405636 4233897.936105073, 1910956.0213351764 4233883.977775258, 1910952.7390715084 4233877.11023093, 1910952.0452416777 4233874.20311821, 1910945.5724999933 4233852.7849999685, 1910943.217151334 4233795.0938515775, 1910934.946750991 4233724.465354268, 1910926.1356680128 4233650.939473711, 1910926.145026876 4233648.785372258, 1910926.0997208094 4233646.960701846, 1910927.119692503 4233633.007653524, 1910927.1404834078 4233632.720937741, 1910927.179895455 4233632.195302914, 1910927.222697872 4233631.608260668, 1910937.3584728637 4233486.609866576, 1910936.2761015033 4233483.115244946, 1910929.8576341502 4233472.295789511, 1910925.2534039752 4233464.535834329, 1910915.3665062592 4233447.907273307, 1910880.3525463135 4233388.735462061, 1910800.7738764912 4233254.245749017, 1910763.378615017 4233190.450646506, 1910760.1920075722 4233185.0584418345, 1910758.9131492272 4233182.898132435, 1910757.8319792617 4233181.0688889595, 1910757.5450463356 4233180.583418151, 1910757.365562882 4233180.279811007, 1910757.2485127083 4233180.082323154, 1910757.240168437 4233180.068218843, 1910757.092752968 4233179.81877582, 1910744.7377327438 4233158.951525321, 1910740.8422334942 4233152.364169362, 1910737.1973711737 4233146.4248787435, 1910734.2738778156 4233141.883401128, 1910720.819934771 4233121.20144947, 1910698.6181781208 4233089.791639691, 1910661.7913165276 4233038.104300559, 1910655.3249220243 4233029.211017828, 1910621.0309601775 4232980.519359238, 1910587.223693654 4232932.575879132, 1910586.5238325729 4232931.5815756805, 1910585.4791209113 4232930.096909563, 1910582.7327363545 4232926.184834488, 1910545.2155325962 4232872.699344397, 1910537.9281697616 4232785.5901946565, 1910535.9211955396 4232785.204005608, 1910535.691297043 4232782.685895463, 1910414.280621281 4232759.872009148, 1910266.420565622 4232732.088105638, 1909776.7342759345 4232636.003772733, 1909683.8281712497 4232622.0507390015, 1909570.1567585568 4232688.6249442715, 1909570.5812439523 4232689.906526047, 1909568.8521407358 4232690.931416993, 1909589.8183544914 4232759.134372149, 1909633.3410806467 4232854.410669424, 1909671.5970850068 4232921.480323828, 1909732.2334672417 4233170.952156599, 1909737.8992263717 4233316.097813813, 1909736.4314227982 4233314.536934277, 1909736.5257228666 4233317.457780666, 1909636.6703796894 4233209.367564223, 1909572.5231892627 4233141.21315839, 1909571.7450935212 4233143.691519451, 1909570.8485583519 4233143.064859664, 1909556.395870156 4233190.127208682, 1909546.0681530505 4233221.842016618, 1909544.5126724748 4233226.605261197, 1909543.97853662 4233228.154943461, 1909542.9221649359 4233231.440448903, 1909534.5010236234 4233257.881586827, 1909533.9743539873 4233256.711656568, 1909533.3469374133 4233258.48366255, 1909518.497744919 4233219.283847319, 1909497.197559603 4233182.676676922, 1909482.4373240361 4233158.895254646, 1909464.332034776 4233133.171769957, 1909399.6690015423 4233094.821368611, 1909360.031473196 4233070.626178993, 1909296.4311415106 4233128.739473685, 1909294.2048176564 4233131.821151642, 1909270.9418562886 4233184.334460671, 1909218.465829061 4233302.306440648, 1909207.4319046512 4233347.421190084, 1909186.5166654652 4233430.212559784, 1909188.77 4233435.5, 1909184.44 4233438.03, 1909185.51 4233440.87, 1909188.63 4233439.31, 1909195.77 4233489.5, 1909197.23 4233500.79, 1909198.47 4233510.21, 1909200.34 4233522.43, 1909206.75 4233568.97, 1909211.05 4233602.61, 1909223.5 4233694.56, 1909242.56 4233836.35, 1909248.67 4233880.15, 1909256.64 4233938.6, 1909263.71 4233990.77, 1909269.32 4234031.49, 1909275.59 4234078.53, 1909280.62 4234112.7, 1909284.7 4234141.67, 1909288.48 4234166.45, 1909296.06 4234206.07, 1909301.4 4234244.65, 1909309.92 4234304.27, 1909317.51 4234354.4, 1909323.23 4234395.46, 1909329.18 4234435.04, 1909332.35 4234455.87, 1909354.24 4234455.01, 1909374.92 4234454.19, 1909381.26 4234454.57, 1909389.23 4234457.1, 1909405.86 4234474.76, 1909416.94 4234484.45, 1909424.46 4234493.26, 1909450.59 4234487.86, 1909470.4 4234517.54, 1909463.16 4234542.74, 1909474.77 4234591.62, 1909483.53 4234616.29, 1909508.27 4234626.73, 1909517.8 4234632.63, 1909522.58 4234637.45, 1909535.68 4234653.24, 1909554.63 4234682.03, 1909560.35 4234690.16, 1909566.76 4234697.4, 1909580.44 4234702.66, 1909603.9 4234702.28, 1909630.23 4234704.67, 1909655.55 4234707.04, 1909691.76 4234716.36, 1909708.49 4234720.81, 1909716.98 4234713.33, 1909723.67 4234711.44, 1909736.39 4234709.71, 1909752.39 4234710.49, 1909762.02 4234711.58, 1909794.28 4234722.7, 1909811.71 4234717.92, 1909823.11 4234720.55, 1909825.97 4234719.81, 1909841.5 4234715.84, 1909863.64 4234730.3, 1909875.94 4234748.63, 1909905.98 4234762.53, 1909925.73 4234793.54, 1909928.33 4234807.58, 1909924.48 4234838.28, 1909922.89 4234852.23, 1909928.47 4234866.45, 1909931.55 4234869.11, 1909948.98 4234894.79, 1909954.87 4234902.94, 1909982.27 4234933.12, 1910002.16 4234954.9, 1910010.06 4234963.57, 1910020.94 4234966.72, 1910033.55 4234975.15, 1910042.35 4234990.35, 1910065.67 4235010.26, 1910089.12 4235030.71, 1910093.8 4235033.69, 1910115.9 4235038.16, 1910153.46 4235048.01, 1910162.92 4235058.34, 1910188.52 4235074.51, 1910194.9 4235078.41, 1910208.76 4235100.24, 1910223.38 4235112.32, 1910238 4235126.68, 1910248.63 4235137.83, 1910271.5 4235165.82, 1910281.76 4235180.66, 1910291.91 4235198.46, 1910296.2 4235207.37, 1910301.37 4235219.58, 1910304.66 4235232.88, 1910305.9 4235240.84, 1910295.06 4235264.32, 1910286.88 4235281.96, 1910291.04 4235289.66, 1910319.42 4235314.19, 1910337.33 4235330.92, 1910365.7 4235358.01, 1910366.78 4235362.95, 1910369.9 4235374.58, 1910375.23 4235383.64, 1910389.26 4235399.29, 1910406.45 4235418.51, 1910416.08 4235430.11, 1910421.14 4235441.17, 1910421.14 4235441.84713746, 1910426.02 4235460.49, 1910438.19 4235501.3, 1910443.07 4235515.7, 1910447.82 4235526.11, 1910453.08 4235532.75, 1910470.41 4235550.24, 1910483.47 4235563.85, 1910496.46 4235579.29, 1910508.38 4235593.32, 1910520.61 4235611.18, 1910537.52 4235636.23, 1910552.17 4235657.44, 1910574.62 4235650.64, 1910586.22 4235648.08, 1910586.91 4235642.65, 1910588.4 4235642.64, 1910595.44 4235643.09, 1910614.28 4235649.01, 1910629.74 4235655.51, 1910637.39 4235660.37, 1910639.96 4235664.25, 1910647.27 4235684.7, 1910646.8974484522 4235684.154447507, 1910649.97 4235692.97, 1910649.24 4235702.34, 1910658.91 4235714.99, 1910661.54 4235721.71, 1910667.61 4235731.32, 1910685.45 4235742.04, 1910698.61 4235744.82, 1910708.7 4235748.3, 1910714.52 4235753.46, 1910716.73 4235739.87, 1910718.67 4235736.55, 1910722.62 4235734.37, 1910723.84 4235740.57, 1910727.58 4235746.33, 1910732.6 4235751.07, 1910743.38 4235759.04, 1910749.86 4235765.44, 1910768.29 4235778.33, 1910782.35 4235788.42, 1910784.61 4235792.33, 1910785.3 4235796.28, 1910784.68 4235805.33, 1910783.77 4235827.94, 1910790.6 4235842.83, 1910791.64 4235847.77, 1910795.87 4235866.9, 1910802.35 4235896.85, 1910811.04 4235943.87, 1910812.7 4235958.19, 1910810.9 4235985.49, 1910811.94 4235995.93, 1910813.61 4235999.08, 1910816.72 4236001.78, 1910821.44 4236004.45, 1910845.41 4236010.44, 1910865.47 4236016.33, 1910876.94 4236020.85, 1910883.14 4236025.12, 1910886.33 4236029.04, 1910891.98 4236040.22, 1910897.48 4236052.74, 1910900.22 4236057.13, 1910903.2 4236059.9, 1910920.11 4236069.53, 1910927.7 4236076.27, 1910933.31 4236083.8, 1910947.1 4236103.01, 1910961.37 4236121.68, 1910974.12 4236138.7, 1910976.44 4236144.95, 1910981.16 4236178.27, 1910981.85 4236210.53, 1910980.91 4236227.93, 1910987.88 4236235.96, 1911005.17 4236248.24, 1910998.55 4236274.4, 1911004.68 4236287.26, 1911007.83 4236295.26, 1911009.95 4236304.14, 1911010.54 4236310.98, 1911008.91 4236326.77, 1911010.43 4236335.63, 1911014.31 4236342.73, 1911021.38 4236350.56, 1911045.91 4236372.21, 1911048.6788617773 4236372.119809063, 1911051.0999999312 4236355.100002075, 1911056.499999931 4236351.000002077, 1911192.399999931 4236217.40000208, 1911194.999999931 4236214.300002075, 1911210.299999931 4236199.200002077, 1911218.8999999312 4236193.400002075, 1911224.1999999308 4236131.800002077, 1911267.1999999308 4236165.300002075, 1911236.7999999311 4236205.300002076, 1911232.7999999311 4236244.600002074, 1911283.799999931 4236272.500002075, 1911383.5999999312 4236305.400002075, 1911411.099999931 4236296.400002075, 1911417.4999999308 4236260.400002076, 1911328.5999999312 4236155.500002076, 1911351.1999999308 4236147.200002077, 1911459.1999999308 4236132.600002074, 1911458.5999999312 4236098.6000020765, 1911477.9999999308 4236064.100002075, 1911440.9999999308 4236002.800002077, 1911448.4999999308 4235992.900002076, 1911443.099999931 4235918.000002077, 1911451.1999999308 4235886.000002079, 1911469.299999931 4235851.400002078, 1911516.099999931 4235633.000002079, 1911509.1999999308 4235604.600002077, 1911506.899999931 4235565.400002079, 1911597.461619418 4235626.96939991, 1911574.9225914269 4235398.6041057855), (1909768.7999999314 4233555.500002083, 1909780.29 4233559.67, 1909790.699999931 4233568.400002084, 1909804.2999999314 4233545.500002083, 1909805.0999999314 4233546.100002083, 1909805.9999999313 4233544.600002083, 1909808.8999999315 4233546.300002082, 1909809.4999999313 4233545.300002083, 1909824.0999999312 4233554.500002082, 1909834.3999999315 4233537.700002083, 1909853.0999999312 4233506.100002083, 1909856.999999931 4233496.600002082, 1909859.7999999314 4233490.100002083, 1909822.2999999314 4233446.400002085, 1909824.3999999315 4233445.200002084, 1909832.999999931 4233434.000002084, 1909851.699999931 4233410.7000020845, 1909864.0999999314 4233393.900002084, 1909867.8999999315 4233383.200002084, 1909874.7999999311 4233371.700002085, 1909885.2999999311 4233345.200002085, 1909888.2999999311 4233336.600002084, 1909901.7999999311 4233311.2000020845, 1909919.5999999312 4233301.7000020845, 1909936.999999931 4233290.400002085, 1909947.5999999314 4233268.800002084, 1909949.5999999312 4233228.800002084, 1909934.1999999313 4233214.800002082, 1909929.0999999312 4233199.100002085, 1909928.5999999312 4233185.900002086, 1909942.499999931 4233154.000002084, 1909973.6999999313 4233134.7000020845, 1909984.3999999312 4233123.100002084, 1909962.199999931 4233111.200002084, 1909972.7999999311 4233092.000002084, 1909977.3999999312 4233086.800002084, 1909988.7999999311 4233078.600002084, 1910000.3999999312 4233070.800002085, 1910007.7999999311 4233066.100002084, 1910022.2999999311 4233049.800002084, 1910035.699999931 4233045.600002086, 1910087.499999931 4233035.700002084, 1910139.3999999312 4233042.500002085, 1910157.999999931 4233051.300002085, 1910167.2999999311 4233058.500002084, 1910173.499999931 4233064.800002084, 1910158.5999999312 4233075.500002083, 1910156.3999999312 4233083.300002086, 1910162.8999999312 4233112.900002087, 1910171.0999999312 4233142.200002085, 1910177.999999931 4233189.300002085, 1910181.5999999312 4233205.700002084, 1910187.699999931 4233221.900002085, 1910189.5999999312 4233232.200002085, 1910187.699999931 4233252.300002086, 1910183.499999931 4233283.100002084, 1910180.699999931 4233291.700002083, 1910179.7999999311 4233292.900002085, 1910176.499999931 4233300.400002083, 1910202.2999999311 4233299.2000020845, 1910217.999999931 4233364.900002084, 1910192.7999999311 4233369.600002084, 1910196.2999999311 4233374.400002086, 1910233.199999931 4233370.900002083, 1910264.7999999311 4233360.000002084, 1910279.499999931 4233404.300002082, 1910224.5999999312 4233419.7000020845, 1910220.199999931 4233421.800002085, 1910217.999999931 4233424.900002083, 1910215.999999931 4233428.600002083, 1910216.199999931 4233433.2000020845, 1910224.2999999311 4233429.500002085, 1910232.2999999311 4233425.400002084, 1910239.7999999311 4233421.100002083, 1910266.199999931 4233417.300002084, 1910288.0999999312 4233493.400002085, 1910320.5999999312 4233504.400002084, 1910321.8999999312 4233523.400002084, 1910298.999999931 4233544.600002083, 1910294.3299999312 4233546.830002083, 1910294.2999999311 4233550.200002084, 1910294.599999931 4233553.900002085, 1910360.999999931 4233547.300002082, 1910370.7999999311 4233598.700002084, 1910386.2999999311 4233608.700002083, 1910388.7999999311 4233630.400002082, 1910380.699999931 4233638.200002083, 1910372.7999999311 4233646.200002083, 1910368.8999999312 4233650.500002083, 1910360.8999999312 4233643.400002083, 1910357.5999999312 4233641.400002083, 1910354.3999999312 4233641.300002082, 1910352.699999931 4233643.000002082, 1910351.5999999312 4233644.600002082, 1910349.8999999312 4233659.300002082, 1910348.8999999312 4233661.7000020845, 1910326.2999999311 4233683.600002083, 1910330.999999931 4233688.500002082, 1910333.279999931 4233692.1200020835, 1910339.999999931 4233687.800002083, 1910351.3999999312 4233678.600002082, 1910356.999999931 4233672.700002083, 1910368.0999999312 4233656.900002084, 1910373.199999931 4233651.300002083, 1910379.499999931 4233662.500002083, 1910381.199999931 4233663.900002085, 1910389.699999931 4233661.200002084, 1910392.499999931 4233657.200002084, 1910397.3999999312 4233648.000002082, 1910400.8999999312 4233643.400002083, 1910404.699999931 4233641.800002084, 1910437.5899999312 4233639.320002084, 1910441.799999931 4233639.000002085, 1910441.4499999308 4233628.320002083, 1910444.6999999308 4233628.200002085, 1910450.499999931 4233626.900002083, 1910451.6999999308 4233626.900002086, 1910455.199999931 4233649.000002084, 1910459.199999931 4233671.000002082, 1910463.5999999312 4233692.900002084, 1910468.499999931 4233714.800002082, 1910473.299999931 4233734.900002083, 1910489.8999999312 4233786.000002083, 1910487.5999999312 4233787.000002082, 1910482.8999999312 4233784.600002083, 1910480.239999931 4233780.950002083, 1910476.699999931 4233780.2000020845, 1910432.699999931 4233773.100002084, 1910432.5999999312 4233775.700002083, 1910462.6999999308 4233812.400002084, 1910471.2999999311 4233835.200002083, 1910490.199999931 4233856.400002082, 1910498.8999999312 4233875.500002081, 1910507.999999931 4233894.400002084, 1910511.0999999312 4233900.600002081, 1910519.199999931 4233925.200002084, 1910521.199999931 4233906.600002082, 1910523.8199999311 4233897.210002083, 1910526.899999931 4233898.500002083, 1910544.999999931 4233902.200002084, 1910548.7999999311 4233952.700002084, 1910554.5999999312 4233963.100002081, 1910561.2999999311 4233965.400002083, 1910567.299999931 4233967.800002082, 1910591.5999999312 4233984.600002081, 1910606.299999931 4233991.100002083, 1910605.3999999312 4233991.500002082, 1910632.999999931 4234047.600002081, 1910655.0999999312 4234080.900002083, 1910676.9999999308 4234114.500002082, 1910681.1699999308 4234122.080002082, 1910687.2999999311 4234120.600002081, 1910707.4999999308 4234173.100002082, 1910690.599999931 4234193.200002084, 1910682.099999931 4234240.400002083, 1910670.7999999311 4234249.600002082, 1910666.299999931 4234245.800002081, 1910659.0999999312 4234245.5000020815, 1910655.399999931 4234237.5000020815, 1910632.2999999311 4234191.800002081, 1910627.099999931 4234182.700002083, 1910610.199999931 4234156.100002081, 1910609.799999931 4234133.200002083, 1910611.609999931 4234132.550002083, 1910611.499999931 4234131.000002082, 1910569.299999931 4234055.000002082, 1910551.0999999312 4234024.300002082, 1910529.8999999312 4233971.700002084, 1910528.899999931 4233963.800002081, 1910524.599999931 4233960.000002083, 1910519.5999999312 4233948.000002082, 1910514.5999999312 4233942.900002082, 1910496.3999999312 4233931.60000208, 1910462.0999999312 4233915.700002082, 1910441.5999999312 4233897.900002083, 1910436.2999999311 4233885.200002082, 1910434.699999931 4233883.200002084, 1910420.499999931 4233882.800002082, 1910418.5999999312 4233879.400002084, 1910414.499999931 4233862.500002082, 1910397.499999931 4233852.700002083, 1910390.8999999312 4233852.000002082, 1910383.899999931 4233852.000002083, 1910376.699999931 4233852.400002083, 1910369.3999999312 4233853.300002081, 1910358.7999999311 4233857.100002081, 1910353.699999931 4233859.000002083, 1910350.2999999311 4233859.300002081, 1910346.0999999312 4233858.200002083, 1910334.499999931 4233852.000002083, 1910329.499999931 4233849.900002084, 1910304.0999999312 4233845.000002084, 1910283.199999931 4233840.500002083, 1910314.5999999312 4233884.300002084, 1910339.8999999312 4233912.200002083, 1910366.2999999311 4233955.700002083, 1910355.6999999308 4233966.000002083, 1910351.199999931 4233970.400002084, 1910350.499999931 4233975.100002081, 1910364.2999999311 4233988.100002082, 1910390.3999999312 4234017.700002082, 1910413.7999999311 4234043.900002081, 1910423.199999931 4234052.80000208, 1910446.999999931 4234068.400002083, 1910471.699999931 4234084.100002082, 1910465.3999999312 4234091.100002081, 1910444.899999931 4234099.100002084, 1910435.199999931 4234100.500002083, 1910436.2999999311 4234159.700002082, 1910436.8999999312 4234163.600002081, 1910450.3999999312 4234199.000002082, 1910457.0999999312 4234226.700002082, 1910491.5999999312 4234259.800002079, 1910511.199999931 4234256.700002083, 1910522.8999999312 4234263.700002081, 1910530.5999999312 4234281.400002082, 1910530.199999931 4234287.100002081, 1910530.0999999312 4234292.700002081, 1910530.499999931 4234298.400002082, 1910530.699999931 4234299.800002083, 1910531.999999931 4234307.900002082, 1910534.489999931 4234313.410002081, 1910545.0999999312 4234336.900002083, 1910542.199999931 4234341.600002079, 1910539.5999999312 4234346.600002082, 1910538.2999999311 4234349.60000208, 1910535.5999999312 4234358.700002083, 1910535.5999999312 4234364.100002081, 1910536.509999931 4234369.300002081, 1910539.3999999312 4234368.800002082, 1910565.199999931 4234361.400002081, 1910569.499999931 4234360.100002081, 1910606.699999931 4234332.5000020815, 1910613.899999931 4234328.200002084, 1910632.999999931 4234348.900002081, 1910640.0999999312 4234342.000002082, 1910657.939999931 4234324.57000208, 1910692.5999999312 4234290.70000208, 1910713.5999999312 4234310.400002082, 1910730.999999931 4234322.300002081, 1910735.6999999308 4234333.200002082, 1910734.799999931 4234364.500002083, 1910738.899999931 4234380.000002081, 1910746.2999999311 4234387.600002081, 1910814.0999999312 4234375.300002081, 1910824.799999931 4234383.000002082, 1910828.769999931 4234387.210002081, 1910837.9999999308 4234377.800002081, 1910842.5999999312 4234378.000002081, 1910855.6999999308 4234387.700002082, 1910878.399999931 4234411.700002082, 1910887.399999931 4234436.900002084, 1910906.5999999312 4234449.40000208, 1910910.299999931 4234454.200002081, 1910936.899999931 4234487.0000020815, 1910960.6999999308 4234517.400002081, 1910982.099999931 4234550.5000020815, 1910993.4999999308 4234570.0000020815, 1911012.9999999308 4234582.400002081, 1911028.6999999308 4234592.50000208, 1911035.299999931 4234606.90000208, 1911047.6999999308 4234615.80000208, 1911053.5999999312 4234620.60000208, 1911046.7999999311 4234652.300002078, 1911047.4999999308 4234655.10000208, 1911060.6999999308 4234669.000002081, 1911072.9999999308 4234681.200002083, 1911084.599999931 4234715.20000208, 1911102.899999931 4234768.60000208, 1911070.799999931 4234785.60000208, 1911034.799999931 4234749.300002081, 1910997.599999931 4234712.10000208, 1910959.399999931 4234673.900002082, 1910933.899999931 4234649.30000208, 1910952.799999931 4234625.700002081, 1910981.299999931 4234611.40000208, 1910979.299999931 4234604.50000208, 1910976.799999931 4234602.200002081, 1910943.799999931 4234590.800002082, 1910940.6999999308 4234578.800002079, 1910934.599999931 4234555.00000208, 1910923.399999931 4234544.0000020815, 1910898.9999999308 4234520.000002082, 1910898.099999931 4234516.500002081, 1910893.199999931 4234498.700002082, 1910872.499999931 4234484.000002081, 1910869.7599999309 4234482.040002081, 1910851.999999931 4234508.90000208, 1910844.8999999312 4234517.50000208, 1910823.3999999312 4234531.900002081, 1910797.3999999312 4234548.70000208, 1910791.899999931 4234544.10000208, 1910786.099999931 4234538.10000208, 1910780.199999931 4234531.10000208, 1910765.6999999308 4234527.300002079, 1910707.0999999312 4234585.300002079, 1910712.0999999312 4234605.100002081, 1910704.5999999312 4234618.700002082, 1910717.599999931 4234642.400002082, 1910672.2999999311 4234707.10000208, 1910650.699999931 4234703.700002078, 1910624.7999999311 4234701.100002079, 1910585.999999931 4234568.20000208, 1910583.5999999312 4234559.900002082, 1910536.2999999311 4234520.5000020815, 1910515.499999931 4234500.400002082, 1910497.7999999311 4234482.900002082, 1910491.3999999312 4234483.400002082, 1910465.3999999312 4234476.100002082, 1910450.499999931 4234474.00000208, 1910443.3999999312 4234471.50000208, 1910435.8999999312 4234468.400002081, 1910428.5999999312 4234464.800002082, 1910424.8999999312 4234461.600002081, 1910422.0999999312 4234458.600002081, 1910419.699999931 4234455.300002079, 1910416.699999931 4234448.300002079, 1910416.0999999312 4234445.300002082, 1910414.1999999313 4234435.600002079, 1910412.699999931 4234425.800002079, 1910409.699999931 4234420.80000208, 1910398.8999999312 4234416.800002081, 1910392.7999999311 4234415.5000020815, 1910378.7999999311 4234412.800002081, 1910364.699999931 4234410.500002082, 1910353.2999999311 4234406.20000208, 1910350.0999999312 4234400.600002081, 1910355.0999999312 4234376.000002083, 1910357.699999931 4234370.700002083, 1910362.5999999312 4234364.300002083, 1910362.999999931 4234359.5000020815, 1910363.2999999311 4234346.600002082, 1910360.519999931 4234334.380002082, 1910355.699999931 4234336.0000020815, 1910293.2999999311 4234343.500002081, 1910292.7999999311 4234350.700002083, 1910285.7999999311 4234362.10000208, 1910271.4999999313 4234363.20000208, 1910268.5999999312 4234367.800002081, 1910264.999999931 4234372.800002081, 1910261.0999999312 4234377.400002084, 1910256.499999931 4234381.600002081, 1910241.0999999312 4234391.60000208, 1910234.7999999311 4234398.600002081, 1910231.3999999312 4234403.800002081, 1910227.7999999311 4234412.900002081, 1910220.5999999312 4234414.40000208, 1910193.6999999313 4234410.500002081, 1910183.9999999313 4234409.600002082, 1910176.3999999312 4234410.30000208, 1910169.999999931 4234411.30000208, 1910110.999999931 4234369.200002081, 1910106.7999999311 4234367.10000208, 1910102.6999999313 4234366.20000208, 1910098.7999999311 4234365.80000208, 1910094.8999999312 4234365.800002082, 1910089.1999999313 4234384.700002082, 1910071.9999999313 4234398.700002081, 1910067.999999931 4234396.20000208, 1910026.5999999314 4234486.200002081, 1910021.199999931 4234481.000002081, 1910016.2999999314 4234475.60000208, 1910011.7999999314 4234469.900002081, 1909988.3999999315 4234434.70000208, 1909980.9999999313 4234414.400002081, 1910001.1999999313 4234398.300002081, 1909960.6999999313 4234336.500002079, 1909963.6999999313 4234328.100002082, 1909972.0999999314 4234333.700002081, 1909992.1999999313 4234308.10000208, 1910013.999999931 4234281.300002081, 1910034.5999999314 4234254.200002083, 1910005.8999999312 4234188.700002083, 1909986.8999999315 4234189.40000208, 1909984.6999999313 4234192.00000208, 1909964.9999999313 4234187.800002081, 1909961.1999999313 4234188.900002084, 1909955.9999999313 4234192.900002081, 1909953.1999999313 4234193.900002082, 1909887.3999999315 4234263.200002082, 1909863.0999999314 4234287.800002081, 1909852.1999999313 4234298.0000020815, 1909841.5999999314 4234307.400002082, 1909830.5999999314 4234316.50000208, 1909820.4999999313 4234321.700002081, 1909795.9999999313 4234332.300002079, 1909775.7999999314 4234340.5000020815, 1909723.5999999314 4234353.40000208, 1909689.0999999316 4234375.700002081, 1909698.3999999315 4234376.8000020785, 1909702.0999999314 4234376.0000020815, 1909714.1999999313 4234371.400002082, 1909725.3999999315 4234369.900002082, 1909757.5999999314 4234379.200002081, 1909776.4999999313 4234381.700002082, 1909793.5999999314 4234381.400002083, 1909819.8999999315 4234379.000002081, 1909832.3999999315 4234376.400002083, 1909842.3999999315 4234372.800002081, 1909849.6799999312 4234369.640002082, 1909853.7999999314 4234372.200002082, 1909868.6999999313 4234375.30000208, 1909837.8999999315 4234416.60000208, 1909808.7999999314 4234447.00000208, 1909765.9999999313 4234491.20000208, 1909747.9999999313 4234469.800002079, 1909713.3999999315 4234491.50000208, 1909673.1999999313 4234517.500002081, 1909658.0999999316 4234526.8000020785, 1909631.0999999314 4234542.100002078, 1909606.6999999313 4234553.200002082, 1909590.5999999314 4234542.000002081, 1909590.3999999315 4234524.300002079, 1909587.6999999313 4234512.800002081, 1909555.3999999315 4234513.300002079, 1909528.1999999313 4234513.5000020815, 1909523.8999999315 4234505.100002079, 1909532.1999999313 4234494.400002081, 1909518.7999999314 4234478.100002079, 1909515.3999999315 4234465.80000208, 1909528.4999999313 4234450.400002081, 1909615.0999999314 4234391.200002081, 1909616.6999999313 4234417.000002081, 1909628.0999999314 4234430.900002081, 1909674.5999999314 4234396.500002081, 1909686.9999999313 4234406.100002081, 1909696.1999999313 4234402.200002083, 1909688.4999999313 4234381.00000208, 1909687.3999999315 4234380.50000208, 1909683.5999999314 4234378.600002081, 1909679.8999999315 4234376.200002082, 1909674.9934893185 4234371.017068335, 1909675.64 4234364.46, 1909672.89 4234342.19, 1909674.87 4234323.78, 1909677.27 4234305.42, 1909677.98 4234300.52, 1909688.1107663265 4234258.758538811, 1909685.4999999313 4234258.200002082, 1909677.7999999314 4234266.60000208, 1909673.7999999314 4234269.5000020815, 1909654.0999999314 4234272.600002081, 1909648.1999999313 4234275.0000020815, 1909646.6999999313 4234276.100002081, 1909645.6999999313 4234277.300002079, 1909644.9999999313 4234278.700002081, 1909644.7999999314 4234280.300002081, 1909644.9999999313 4234281.800002081, 1909645.5999999316 4234283.300002081, 1909651.1999999313 4234291.5000020815, 1909654.5999999314 4234298.20000208, 1909655.6999999313 4234303.10000208, 1909636.9999999313 4234303.0000020815, 1909627.1999999313 4234303.600002079, 1909609.5999999314 4234305.000002082, 1909592.0999999314 4234306.900002083, 1909577.3999999315 4234310.2000020845, 1909564.9999999315 4234314.50000208, 1909529.0999999316 4234321.900002079, 1909525.7999999314 4234322.900002081, 1909513.8999999315 4234325.40000208, 1909497.2999999314 4234327.000002082, 1909485.3999999315 4234326.800002082, 1909475.4999999315 4234326.10000208, 1909465.5999999314 4234325.000002082, 1909445.4999999315 4234320.900002081, 1909428.8999999315 4234315.600002082, 1909409.9999999315 4234296.400002082, 1909413.5999999316 4234291.700002082, 1909421.6999999313 4234294.20000208, 1909450.8999999315 4234256.60000208, 1909490.3999999315 4234214.700002083, 1909428.6999999313 4234198.700002082, 1909412.5999999314 4234183.000002081, 1909406.8999999315 4234175.400002083, 1909412.2999999314 4234157.500002082, 1909426.6999999315 4234128.200002082, 1909410.8999999315 4234121.900002082, 1909376.2999999314 4234115.10000208, 1909349.5999999316 4234136.300002081, 1909338.8999999315 4234157.300002083, 1909337.8999999315 4234167.500002083, 1909339.0999999316 4234196.80000208, 1909312.7999999316 4234197.700002082, 1909310.5999999316 4234194.600002081, 1909297.3999999315 4234164.000002082, 1909296.7999999314 4234151.500002081, 1909299.3999999315 4234099.900002083, 1909300.9999999315 4234022.600002082, 1909302.3999999315 4234004.500002082, 1909311.0999999316 4233958.900002082, 1909322.6999999313 4233898.500002082, 1909327.6999999313 4233873.000002081, 1909344.2999999314 4233871.100002084, 1909345.7999999314 4233864.300002081, 1909357.5999999316 4233850.800002082, 1909378.1999999313 4233840.300002081, 1909387.2999999316 4233822.600002082, 1909388.9999999313 4233795.800002082, 1909389.1999999313 4233787.0000020815, 1909389.2999999314 4233785.000002083, 1909389.3999999315 4233779.900002083, 1909389.4999999313 4233773.300002083, 1909386.1999999313 4233757.600002083, 1909384.7999999316 4233754.600002082, 1909369.5999999316 4233751.800002081, 1909358.1999999315 4233744.100002082, 1909354.3999999315 4233738.100002084, 1909354.4999999313 4233723.000002084, 1909362.5999999314 4233708.800002082, 1909353.7999999314 4233691.300002083, 1909340.6999999313 4233691.600002083, 1909329.0999999314 4233684.400002084, 1909325.8999999315 4233643.300002082, 1909335.0999999314 4233625.900002084, 1909339.1999999315 4233586.500002082, 1909325.6999999313 4233543.300002085, 1909326.1999999313 4233499.000002082, 1909321.9999999313 4233499.500002082, 1909315.3999999317 4233498.300002083, 1909310.4999999313 4233495.800002083, 1909308.7999999314 4233493.500002082, 1909307.5999999314 4233491.200002084, 1909306.8999999315 4233488.800002083, 1909307.3999999315 4233485.200002086, 1909309.4999999313 4233481.900002084, 1909311.9999999313 4233478.700002084, 1909305.1999999313 4233473.400002084, 1909299.0999999316 4233473.300002082, 1909296.1999999313 4233470.300002083, 1909293.8999999315 4233467.200002083, 1909294.3999999315 4233462.2000020845, 1909315.0999999314 4233433.900002086, 1909325.2999999314 4233421.900002084, 1909336.9399999313 4233412.330002083, 1909345.5499999314 4233405.860002085, 1909345.2999999316 4233405.900002084, 1909334.9999999313 4233413.400002085, 1909341.2999999314 4233403.900002085, 1909340.6999999313 4233400.800002083, 1909338.5999999314 4233396.7000020845, 1909324.1999999313 4233387.800002082, 1909320.2999999314 4233380.100002082, 1909316.7999999314 4233368.400002085, 1909316.9999999313 4233355.300002085, 1909318.3999999315 4233349.2000020845, 1909320.2999999314 4233343.000002082, 1909322.5999999314 4233336.900002082, 1909332.5999999314 4233320.000002083, 1909341.8999999315 4233306.300002083, 1909354.2999999314 4233311.800002084, 1909387.8099999316 4233336.610002083, 1909390.8999999315 4233331.2000020845, 1909417.3999999315 4233295.300002083, 1909408.9999999313 4233291.900002085, 1909406.3999999315 4233291.2000020845, 1909396.3999999315 4233288.000002083, 1909386.4999999313 4233284.400002085, 1909376.7999999314 4233280.500002085, 1909367.2999999314 4233275.000002083, 1909364.9999999313 4233266.300002085, 1909365.3999999315 4233260.200002086, 1909365.6999999313 4233253.000002082, 1909371.6999999313 4233230.600002083, 1909368.7999999314 4233200.800002085, 1909392.4999999313 4233159.300002084, 1909436.9999999313 4233181.500002084, 1909490.2999999314 4233201.100002085, 1909494.6999999313 4233237.400002084, 1909494.8999999315 4233270.700002085, 1909498.4999999313 4233302.300002084, 1909486.7999999314 4233312.500002084, 1909483.9999999313 4233321.100002084, 1909476.8999999315 4233358.100002083, 1909468.0999999314 4233362.7000020845, 1909466.6999999313 4233362.500002084, 1909463.8999999315 4233391.600002082, 1909464.6999999313 4233392.600002085, 1909465.7999999316 4233396.100002081, 1909465.0999999314 4233398.700002083, 1909462.9999999313 4233400.600002083, 1909460.8999999315 4233417.400002082, 1909465.5999999314 4233438.800002083, 1909454.7999999314 4233475.900002084, 1909454.7999999314 4233484.600002083, 1909456.8999999315 4233492.900002082, 1909467.7999999316 4233519.600002081, 1909470.8999999315 4233555.700002083, 1909472.7999999314 4233559.100002082, 1909479.5999999314 4233562.000002083, 1909482.9999999313 4233562.100002081, 1909485.2999999314 4233560.000002082, 1909488.6999999313 4233547.600002085, 1909492.3999999315 4233535.900002084, 1909496.8999999315 4233528.100002086, 1909501.1999999313 4233521.400002082, 1909505.8999999315 4233515.000002082, 1909512.8999999315 4233505.800002082, 1909519.9999999313 4233498.600002085, 1909528.7999999314 4233491.600002082, 1909551.1999999313 4233475.100002084, 1909576.2999999314 4233453.900002085, 1909577.3999999315 4233453.400002084, 1909579.4999999313 4233452.800002082, 1909581.6999999313 4233452.700002084, 1909584.6999999313 4233454.300002084, 1909589.3999999315 4233463.000002083, 1909605.3999999315 4233457.900002083, 1909618.8999999315 4233486.700002085, 1909623.4999999313 4233484.100002083, 1909647.0999999314 4233483.700002084, 1909673.1999999313 4233484.2000020845, 1909683.699999931 4233480.700002084, 1909769.199999931 4233554.100002083, 1909768.7999999314 4233555.500002083), (1910612.699999931 4235468.100002077, 1910611.199999931 4235470.660002079, 1910628.0999999312 4235480.3000020785, 1910628.699999931 4235500.100002077, 1910630.499999931 4235569.600002077, 1910605.5999999312 4235596.8000020785, 1910591.5999999312 4235617.000002077, 1910546.0999999312 4235573.900002078, 1910539.3999999312 4235563.000002079, 1910526.3999999312 4235542.400002077, 1910513.0999999312 4235522.000002078, 1910505.199999931 4235510.100002078, 1910487.199999931 4235482.3000020785, 1910469.499999931 4235454.300002078, 1910491.8999999312 4235447.100002079, 1910502.2999999311 4235442.3000020785, 1910511.499999931 4235437.200002078, 1910527.2999999311 4235426.500002078, 1910536.2999999311 4235418.800002077, 1910540.499999931 4235413.300002078, 1910542.479999931 4235411.220002078, 1910466.3999999315 4235334.6000020765, 1910576.699999931 4235346.600002079, 1910579.199999931 4235352.300002078, 1910584.0999999312 4235359.700002077, 1910615.499999931 4235401.000002078, 1910627.8999999312 4235418.500002081, 1910628.199999931 4235422.000002077, 1910627.2999999314 4235433.700002077, 1910625.8999999312 4235438.6000020765, 1910612.699999931 4235468.100002077))','ZO32062','"lib_modif"=>"N", "lib_code_insee"=>"38170 / 38258 / 38325", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','A','Agricole','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1914399.8699999296 4231251.750002091, 1914382.5999999295 4231235.900002089, 1914375.6699999296 4231222.860002091, 1914366.7599999295 4231206.380002091, 1914362.9999999297 4231199.43000209, 1914346.208515381 4231176.150791642, 1914334.8299999295 4231159.780002089, 1914331.2199999294 4231152.640002089, 1914328.2699999295 4231146.0900020925, 1914323.2199999294 4231135.070002091, 1914325.6699999294 4231133.860002092, 1914326.3399999295 4231124.85000209, 1914324.1199999296 4231107.070002091, 1914322.73 4231096.52, 1914318.81 4231068.48, 1914315.74 4231051.29, 1914316.44 4231038.33, 1914316.62 4231019.65, 1914316.27 4231016.34, 1914314.57 4231011.94, 1914306.21 4231004.6, 1914310.7799999295 4231001.480002092, 1914304.9999999295 4230994.84000209, 1914302.3099999295 4230990.25000209, 1914300.9799999294 4230986.520002091, 1914298.1099999296 4230977.560002092, 1914297.5399999295 4230971.77000209, 1914296.8099999297 4230959.26000209, 1914293.4099999298 4230948.700002091, 1914290.0899999298 4230946.020002091, 1914286.9999999297 4230943.35000209, 1914293.1099999296 4230934.600002091, 1914303.5299999295 4230926.330002091, 1914315.3299999295 4230916.9700020915, 1914334.7899999295 4230906.010002091, 1914355.5999999298 4230894.320002092, 1914372.5499999295 4230883.630002091, 1914378.4899999294 4230881.790002091, 1914383.0399999295 4230879.9700020915, 1914386.6599999296 4230876.640002091, 1914380.2699999295 4230873.780002091, 1914376.9899999294 4230873.540002092, 1914365.6599999296 4230876.190002091, 1914345.3699999296 4230885.790002093, 1914338.0399999295 4230887.050002092, 1914330.7999999295 4230886.310002091, 1914319.4799999294 4230883.020002092, 1914307.6999999294 4230877.660002092, 1914287.2499999297 4230868.060002091, 1914282.0999999295 4230867.320002092, 1914274.8499999298 4230867.380002091, 1914268.9999999295 4230868.700002091, 1914259.5199999297 4230870.55000209, 1914248.3899999298 4230871.00000209, 1914242.9899999294 4230869.740002091, 1914225.59 4230859.64, 1914212.01 4230881.2, 1914208.47 4230878.87, 1914212.7 4230852.05, 1914223.53 4230818.45, 1914237.71 4230799.37, 1914257.98 4230772.06, 1914263.86 4230765.08, 1914284.36 4230740.71, 1914301.45 4230721.01, 1914269.88 4230675.36, 1914264.12 4230666.73, 1914242.71 4230614.66, 1914194.15 4230590.93, 1914177.49 4230620.46, 1914151.8 4230604.56, 1914147.9339046946 4230601.941091887, 1914162.6399999296 4230586.910002092, 1914174.8899999298 4230574.620002092, 1914182.4599999294 4230563.330002094, 1914185.9799999297 4230553.850002092, 1914186.7899999295 4230551.040002091, 1914187.7099999294 4230544.540002091, 1914187.6899999294 4230541.040002093, 1914187.6299999296 4230533.230002092, 1914185.3099999295 4230525.290002093, 1914183.5899999295 4230522.420002091, 1914172.5299999295 4230510.270002093, 1914166.8899999298 4230504.090002092, 1914164.3099999295 4230499.960002091, 1914162.1699999296 4230495.460002091, 1914159.3399999295 4230488.760002091, 1914157.9099999298 4230483.470002091, 1914165.0199999295 4230489.420002092, 1914172.1599999296 4230494.910002093, 1914201.6099999296 4230510.990002093, 1914210.7599999295 4230507.250002091, 1914212.9399999294 4230506.350002091, 1914223.6799999294 4230498.82000209, 1914237.1399999298 4230485.730002091, 1914247.0599999295 4230477.1400020905, 1914251.0699999295 4230473.650002093, 1914261.7699999295 4230466.120002093, 1914276.5299999295 4230463.440002092, 1914288.9299999294 4230460.860002093, 1914301.3699999296 4230453.430002091, 1914309.5799999295 4230448.940002093, 1914311.1699999294 4230448.340002094, 1914320.8899999296 4230441.680002092, 1914323.6899999294 4230435.450002094, 1914333.7699999295 4230432.410002093, 1914339.0999999295 4230430.3400020925, 1914351.4599999294 4230422.090002093, 1914355.4099999298 4230420.300002092, 1914366.2699999295 4230413.3000020925, 1914380.0399999295 4230402.070002094, 1914385.2699999295 4230396.670002092, 1914389.2399999294 4230392.880002091, 1914394.3699999296 4230389.080002093, 1914397.0199999295 4230387.520002092, 1914403.8099999295 4230384.800002093, 1914415.5899999295 4230381.350002093, 1914420.4699999294 4230379.790002093, 1914427.7299999294 4230376.330002092, 1914434.6199999296 4230371.220002092, 1914459.3599999296 4230345.520002091, 1914483.0699999295 4230321.630002094, 1914500.0799999295 4230318.360002091, 1914503.96 4230314.47, 1914510.07 4230308.75, 1914516.33 4230304.03, 1914521.09 4230301.22, 1914527.34 4230298.16, 1914551.5 4230287.18, 1914564.97 4230281.06, 1914569.7 4230277.25, 1914579.42 4230263.29, 1914601.5913268812 4230256.033563913, 1914612.5099999295 4230252.460002093, 1914628.1 4230243.2, 1914651.02 4230229.62, 1914646.4699999294 4230227.250002094, 1914596.1699999291 4230215.480002094, 1914593.1199999293 4230214.600002093, 1914587.0599999295 4230211.380002092, 1914581.9599999294 4230207.870002091, 1914579.9899999292 4230206.710002093, 1914574.3999999296 4230201.620002091, 1914558.4999999295 4230181.770002093, 1914549.0999999293 4230170.740002093, 1914537.8699999296 4230161.460002092, 1914524.9 4230154.35, 1914517.64 4230150.86, 1914505.7499999295 4230146.180002091, 1914491.7699999295 4230176.880002093, 1914459.3399999295 4230153.410002094, 1914471.4399999294 4230135.130002094, 1914460.09 4230132.53, 1914453.7435934013 4230134.4226868525, 1914446.17 4230124.23, 1914436.59 4230113.57, 1914417.8500540927 4230086.500853638, 1914450.5699999295 4230068.9600020945, 1914472.1499999296 4230054.100002092, 1914483.9699999294 4230039.370002094, 1914487.24 4230033.32, 1914490.37 4230047.99, 1914491.24 4230050.47, 1914518 4230054.22, 1914521.27 4230030.12, 1914526.1799999294 4229995.350002093, 1914527.1799999292 4229990.9600020945, 1914528.2414667455 4229987.248943552, 1914533.4568870552 4229968.551358989, 1914557.75 4229979.52, 1914572.34 4229986.83, 1914590.11 4229995.81, 1914595.7979964197 4229985.120108438, 1914610.6699999291 4229957.170002094, 1914615.6099999296 4229934.480002096, 1914624.7999999293 4229910.9200020945, 1914631.4899999294 4229893.430002093, 1914641.5499999295 4229867.810002094, 1914642.3799999296 4229854.990002093, 1914644.2699999292 4229844.790002095, 1914644.7099999292 4229833.410002095, 1914643.1199999293 4229819.860002094, 1914634.591378626 4229787.710638428, 1914505.7119450106 4229840.657908454, 1914501.4041797423 4229841.737566848, 1914431.7651931245 4229847.898134963, 1914403.8526002525 4229850.168517227, 1914411.1799999294 4229856.270002095, 1914420.7699999295 4229863.160002093, 1914421.0899999295 4229863.340002093, 1914435.2899999293 4229871.2500020955, 1914455.4399999294 4229883.1300020935, 1914459.5899999295 4229887.710002094, 1914461.9999999292 4229895.040002095, 1914465.0599999295 4229904.860002095, 1914466.7999999295 4229914.140002093, 1914468.2599999295 4229921.410002094, 1914469.4199999294 4229931.280002095, 1914470.8399999295 4229943.410002095, 1914470.6499999296 4229957.540002094, 1914470.2899999295 4229970.880002093, 1914464.8999999296 4229977.3400020925, 1914452.4199999294 4229988.530002094, 1914444.2099999292 4229995.560002094, 1914281.1599999296 4229902.780002095, 1914274.8999999296 4229905.370002095, 1914268.8699999296 4229908.720002093, 1914264.7999999295 4229910.510002093, 1914258.35 4229912.36, 1914243.6899999294 4229916.3800020935, 1914237.21 4229919.52, 1914228.68 4229924.33, 1914221.44 4229928.06, 1914215.82 4229930.71, 1914190.7299999294 4229941.170002094, 1914189.3899999296 4229946.940002092, 1914187.4999999295 4229951.800002093, 1914184.68 4229955.4, 1914179.9199999294 4229960.420002094, 1914173.48 4229963.88, 1914165.8 4229967.81, 1914162.17 4229969.51, 1914155.9899999294 4229973.460002094, 1914151.1099999296 4229977.260002093, 1914147.0799999298 4229981.290002093, 1914161.7699999295 4229992.290002095, 1914175.3599999296 4229991.870002093, 1914182.6899999294 4229990.940002094, 1914188.8499999295 4229989.680002094, 1914195.58 4229987.91, 1914204.1099999296 4229985.470002093, 1914216.5599999295 4229981.170002093, 1914232.42 4229978.73, 1914265.0699999295 4229973.700002094, 1914296.9199999294 4229971.760002094, 1914301.7399999294 4229973.420002094, 1914311.7199999294 4229983.420002093, 1914306.9899999294 4230001.830002096, 1914306.2 4230010.25, 1914305.1999999294 4230020.610002093, 1914306.2 4230032.64, 1914306.2499999295 4230039.740002094, 1914306.0499999295 4230047.080002096, 1914305.4799999294 4230057.300002094, 1914356.1199999296 4230055.510002094, 1914353.2199999294 4230123.640002092, 1914369.8299999295 4230140.830002093, 1914371.2299999294 4230153.660002096, 1914361.7499999295 4230182.780002093, 1914336.8999999296 4230209.610002094, 1914319.8899999293 4230211.700002095, 1914316.4099999296 4230203.890002093, 1914310.3199999295 4230191.750002095, 1914302.3699999296 4230177.810002094, 1914299.0199999295 4230172.630002094, 1914266.2199999294 4230124.870002094, 1914262.6899999294 4230120.600002092, 1914257.1699999296 4230115.670002091, 1914254.4199999294 4230114.000002092, 1914251.8799999296 4230113.140002091, 1914248.6399999296 4230113.430002091, 1914229.3599999296 4230120.250002095, 1914206.2599999295 4230130.840002092, 1914187.0099999295 4230142.180002091, 1914173.0699999298 4230150.210002092, 1914165.7299999294 4230151.510002094, 1914144.7299999294 4230153.110002092, 1914138.3799999296 4230153.980002095, 1914130.9699999294 4230156.960002095, 1914124.6899999296 4230160.080002094, 1914100.5499999295 4230173.310002095, 1914091.9099999296 4230178.330002093, 1914077.8199999295 4230187.330002093, 1914073.3899999296 4230191.080002094, 1914064.6899999294 4230198.830002094, 1914055.5699999298 4230207.790002092, 1914051.1799999294 4230212.540002093, 1914039.6299999296 4230226.070002092, 1914044.9799999297 4230238.4700020915, 1914013.1199999298 4230282.250002093, 1914009.2799999295 4230287.620002094, 1914007.8299999298 4230289.640002091, 1914006.0599999297 4230290.950002091, 1914003.8799999296 4230293.330002096, 1914000.6999999294 4230298.510002092, 1914002.3499999298 4230311.870002094, 1913989.5199999297 4230336.120002095, 1913977.8699999298 4230363.780002092, 1913970.3299999298 4230381.350002092, 1913997.9699999294 4230373.520002093, 1914026.7699999297 4230358.350002091, 1914020.8399999295 4230379.730002092, 1914019.3399999298 4230384.870002091, 1914017.5999999298 4230392.850002092, 1914058.6799999294 4230426.060002093, 1914055.7699999297 4230478.180002092, 1914070.1299999296 4230483.780002092, 1914091.0899999295 4230490.830002095, 1914092.17 4230515.12, 1914080.36 4230518.57, 1914036.6699999296 4230529.390002092, 1913984.2299999297 4230542.370002093, 1913988.16 4230557.03, 1913949.03 4230565.47, 1913948.53 4230541.13, 1913946.5719999298 4230535.99400209, 1913944.9682999298 4230533.394002091, 1913939.99136993 4230528.573552089, 1913932.8554999297 4230527.30060209, 1913931.56 4230517.78, 1913930.6406999298 4230511.592602091, 1913929.96 4230509.54, 1913928.3 4230507.86, 1913925.28 4230506.23, 1913917.9 4230505.63, 1913911.01 4230507.69, 1913892.64 4230523.53, 1913886.6399999298 4230526.620002093, 1913878.0399999297 4230528.270002094, 1913870.8 4230526.53, 1913868.3599999298 4230524.170002092, 1913861.3399999295 4230525.2200020915, 1913846.93 4230514.71, 1913843.4299999296 4230512.160002093, 1913837.54 4230506.01, 1913837.36 4230505.82, 1913844.17 4230524.76, 1913807.4823516817 4230542.528853117, 1913803.7599999297 4230533.530002092, 1913801.4499999296 4230527.980002093, 1913794.86 4230512.07, 1913792.8003677288 4230507.272339407, 1913822.87 4230492.79, 1913825.19 4230489.63, 1913825.46 4230487.3, 1913819.45 4230467.84, 1913818.64 4230463.72, 1913822.5899999298 4230461.0500020925, 1913845.1799999296 4230438.770002091, 1913845.1399999298 4230434.460002092, 1913852.0399999297 4230421.890002091, 1913851.27 4230420.48, 1913846.8099999297 4230412.290002093, 1913849.9699999297 4230402.700002092, 1913849.1799999296 4230400.5500020925, 1913847.9299999296 4230398.230002093, 1913886.1699999296 4230394.940002093, 1913900.4199999296 4230375.520002092, 1913901.8099999297 4230373.660002092, 1913915.0899999298 4230356.680002091, 1913916.5199999297 4230353.060002093, 1913918.1799999296 4230348.800002091, 1913921.2999999297 4230350.340002093, 1913968.8899999298 4230230.510002092, 1913984.9399999294 4230208.620002094, 1913997.1499999296 4230198.8800020935, 1914012.5899999295 4230213.560002093, 1914013.4599999296 4230201.250002093, 1914023.4999999297 4230182.070002092, 1914029.0099999297 4230154.830002092, 1914034.2099999296 4230137.030002094, 1914029.9699999294 4230098.410002095, 1914026.7199999294 4230065.570002095, 1914028.2299999294 4230050.530002094, 1914031.4899999294 4230026.620002095, 1914024.4499999296 4230015.190002094, 1914002.9899999297 4229975.890002091, 1913997.9399999294 4229967.140002093, 1914000.3799999298 4229965.980002094, 1914001.2699999295 4229965.210002094, 1914008.1299999296 4229955.450002094, 1914013.1399999296 4229944.690002095, 1914038.4699999294 4229954.490002094, 1914060.2199999294 4229939.210002094, 1914080.8999999296 4229923.200002094, 1914077.1999999296 4229921.740002093, 1914073.67 4229918.93, 1914069.8199999298 4229913.920002093, 1914056.8 4229880.72, 1914056.4253964366 4229879.778633139, 1913819.4881918614 4229899.754085402, 1913604.2605599791 4229873.896519331, 1913426.7234322897 4229853.140118749, 1913423.599004971 4229860.465523835, 1913398.916127355 4229918.203871911, 1913369.3209166517 4229976.464880052, 1913372.22 4229977.78, 1913378.16 4229980.24, 1913389.12 4229970.32, 1913393.12 4229968.69, 1913404.07 4229965.32, 1913407.62 4229963.25, 1913410.76 4229960.7, 1913415.91 4229954.96, 1913419.2699999297 4229956.240002094, 1913397.2199999297 4230021.170002094, 1913435.9099999298 4230039.9200020945, 1913440.9099999298 4230041.100002095, 1913436.34 4230051, 1913429.22 4230069.05, 1913426.21 4230079.7, 1913424.69 4230086.27, 1913423.67 4230098.88, 1913423.32 4230106.73, 1913423.16 4230110.31, 1913419.72 4230116.75, 1913412.67 4230135.64, 1913408.45 4230146.06, 1913487.94 4230181.33, 1913490.92 4230172.52, 1913503.15 4230176.68, 1913528.5 4230185.28, 1913528.26 4230192.96, 1913527.99 4230201.97, 1913534.51 4230213.34, 1913565.93 4230176.51, 1913577.04 4230166.92, 1913596.1199999298 4230177.500002094, 1913564.1399999298 4230238.620002095, 1913569.7099999296 4230240.490002093, 1913579.7699999297 4230246.080002093, 1913569.6799999299 4230269.630002092, 1913567.8399999298 4230277.1300020935, 1913581.0299999297 4230285.260002094, 1913596.3999999298 4230294.520002093, 1913599.5999999298 4230296.800002092, 1913592.1399999298 4230303.660002092, 1913638.8899999298 4230347.880002093, 1913635.3699999298 4230361.560002091, 1913635.4499999296 4230373.010002092, 1913634.9299999296 4230385.220002092, 1913613.4999999297 4230375.140002092, 1913569.4499999296 4230416.970002093, 1913550.7999999297 4230436.530002094, 1913541.49999993 4230449.940002093, 1913539.1999999296 4230455.380002092, 1913538.5999999298 4230462.8400020925, 1913543.0499999297 4230493.070002093, 1913542.5399999297 4230505.740002093, 1913523.3599999298 4230528.920002092, 1913509.8299999298 4230537.520002092, 1913482.6499999298 4230554.810002093, 1913466.7999999297 4230564.780002093, 1913467.7899999297 4230566.910002092, 1913488.51 4230607.78, 1913490.37 4230611.29, 1913511.17 4230599.05, 1913528.91 4230589.3, 1913552.45 4230627.07, 1913529.08 4230659.46, 1913524.97 4230654.62, 1913513.73 4230640.62, 1913502.42 4230651.15, 1913496.75 4230646.7, 1913464.88 4230675.48, 1913457.72 4230667.35, 1913429.24999993 4230676.710002093, 1913429.5499999297 4230686.350002091, 1913418.1799999296 4230729.360002092, 1913400.4499999296 4230785.630002092, 1913395.1599999298 4230795.070002091, 1913363.96999993 4230816.200002091, 1913371.89999993 4230848.610002092, 1913360.1099999298 4230857.9700020915, 1913351.0299999297 4230846.080002093, 1913346.1999999299 4230849.730002092, 1913362.06999993 4230891.270002091, 1913355.65999993 4230910.330002091, 1913360.64999993 4230909.040002093, 1913361.2199999297 4230912.650002092, 1913363.55999993 4230917.400002091, 1913368.24999993 4230921.460002092, 1913403.48999993 4230938.040002089, 1913435.0599999297 4230942.920002091, 1913458.1699999298 4230937.27000209, 1913466.25999993 4231000.41000209, 1913476.1599999298 4230998.9300020905, 1913508.2099999299 4230994.410002091, 1913510.6199999298 4231005.240002091, 1913503.143807957 4231050.257215725, 1913508.29 4231050.52, 1913517.92 4231053.18, 1913529.8 4231058.35, 1913576.31 4231080.87, 1913590.82 4231084.14, 1913599.321582285 4231086.550148461, 1913598.06999993 4231091.07000209, 1913580.21 4231097.81, 1913556.2099999296 4231106.620002092, 1913540.99 4231111.48, 1913524.4699999297 4231116.76000209, 1913492.4199999298 4231124.480002091, 1913469.06999993 4231127.830002091, 1913446.7699999297 4231127.200002091, 1913400.57999993 4231122.820002093, 1913401.09999993 4231116.14000209, 1913329.34999993 4231105.900002091, 1913301.14999993 4231102.890002089, 1913272.32999993 4231099.360002091, 1913276.71 4231064.27, 1913282.88 4231061.55, 1913281.63 4231057.96, 1913266.82 4231057.27, 1913255.37 4231056.21, 1913235.72 4231052.15, 1913229.87 4231050.27, 1913226.43 4231048.54, 1913223.54 4231046, 1913221.99 4231043.71, 1913221.07 4231041.11, 1913220.94 4231039.01, 1913221.28 4231036.96, 1913221.76 4231035.42, 1913222.49 4231033.99, 1913224.4 4231031.25, 1913227.12 4231029.84, 1913261.72 4231012.014787306, 1913264.97 4231011.22, 1913274.03 4231011.97, 1913275.92 4231004.52, 1913283.25 4230942.73, 1913305.72 4230942.03, 1913320.85999993 4230934.710002091, 1913325.60999993 4230928.220002091, 1913309.3299999298 4230923.450002091, 1913274.96999993 4230920.3900020905, 1913269.80999993 4230917.420002091, 1913252.52999993 4230905.000002093, 1913237.23999993 4230906.72000209, 1913217.9899999297 4230878.360002092, 1913153.74999993 4230892.72000209, 1913166.10999993 4230911.060002091, 1913130.0999999302 4230948.210002089, 1913104.61999993 4230964.910002091, 1913098.10999993 4230968.590002092, 1913091.32999993 4230979.72000209, 1913090.96999993 4230993.870002092, 1913082.64999993 4230997.090002092, 1913065.59999993 4230981.010002091, 1913037.22999993 4230999.470002091, 1913024.76999993 4230981.490002091, 1912965.6799999299 4231018.620002093, 1912918.83999993 4231052.73000209, 1912908.50999993 4231042.3500020895, 1912904.4572139208 4231044.676374094, 1912882.991663688 4231096.505111961, 1912880.287066043 4231126.904789495, 1912873.0917035392 4231159.32833658, 1912902.64999993 4231199.630002088, 1912886.36999993 4231209.35000209, 1912891.28999993 4231216.41000209, 1912893.30999993 4231219.87000209, 1912908.1799999299 4231216.590002092, 1912931.1999999299 4231206.57000209, 1912975.6799999299 4231186.290002091, 1912978.54999993 4231185.240002089, 1912992.9199999298 4231178.3100020895, 1913020.27999993 4231165.090002089, 1913025.4599999299 4231161.96000209, 1913061.75999993 4231180.090002089, 1913090.57999993 4231187.85000209, 1913096.60999993 4231192.110002092, 1913102.65999993 4231186.160002089, 1913148.03999993 4231261.180002088, 1913156.1899999299 4231264.590002091, 1913176.97999993 4231244.7200020915, 1913195.71999993 4231227.400002088, 1913204.04999993 4231219.5600020895, 1913210.1599999303 4231214.640002088, 1913215.51999993 4231211.1000020895, 1913221.27999993 4231208.24000209, 1913228.39999993 4231206.12000209, 1913235.78999993 4231205.580002091, 1913242.75999993 4231206.23000209, 1913249.5999999298 4231207.590002092, 1913258.73999993 4231210.58000209, 1913267.35999993 4231214.790002091, 1913302.6899999299 4231242.77000209, 1913311.9599999299 4231250.10000209, 1913316.3899999298 4231252.13000209, 1913321.10999993 4231253.280002089, 1913343.49999993 4231254.06000209, 1913378.4299999299 4231249.460002091, 1913385.3999999298 4231214.490002092, 1913414.21999993 4231219.4300020905, 1913487.48999993 4231216.70000209, 1913509.7099999296 4231209.330002091, 1913521.89999993 4231203.490002091, 1913530.7599999297 4231198.360002091, 1913539.2899999297 4231192.67000209, 1913559.10999993 4231176.650002088, 1913571.04999993 4231195.570002089, 1913577.0499999297 4231187.460002092, 1913599.5499999297 4231153.19000209, 1913602.29999993 4231148.990002088, 1913610.77999993 4231139.630002089, 1913617.8999999298 4231132.190002091, 1913650.0599999297 4231103.81000209, 1913668.81999993 4231100.74000209, 1913681.0499999297 4231093.000002092, 1913684.29 4231092.22, 1913685.69 4231091.83, 1913686.3631764546 4231087.0142228445, 1913687.99 4231086.33, 1913689.94 4231086.84, 1913691.92 4231087.35, 1913702.82 4231098.52, 1913708.01 4231100.97, 1913705.12 4231120.83, 1913703.52 4231133.13, 1913704.42 4231141.41, 1913708.87 4231148.72, 1913714.73 4231156.22, 1913742.74 4231177.72, 1913752.18 4231183.75, 1913763.77 4231190.85, 1913766.59 4231192.57, 1913771.22999993 4231195.170002088, 1913776.03499866 4231188.490828979, 1913810.2099999296 4231139.990002093, 1913845.3599999298 4231092.360002091, 1913872.2499999297 4231102.060002093, 1913899.8399999298 4231116.170002091, 1913912.6299999298 4231123.370002091, 1913942.0899999298 4231141.750002092, 1913921.2999999297 4231175.080002091, 1913901.0099999297 4231207.60000209, 1913898.7393171429 4231211.768841813, 1913902.6499999298 4231213.050002092, 1913917.6999999296 4231219.390002091, 1913926.25 4231223.16, 1913930.8299999298 4231225.180002089, 1913933.1199999298 4231226.610002089, 1913941.1599999298 4231231.620002091, 1913945.12999993 4231233.050002089, 1913949.5899999298 4231234.350002091, 1913965.3999999298 4231236.460002088, 1913982.2399999297 4231242.240002092, 1913985.36 4231237.62, 1913990.18 4231240.09, 1913992.57 4231241.7, 1913998.37 4231248.88, 1914003.06 4231260.9, 1914007.4099999298 4231271.31000209, 1914019.4199999296 4231259.200002091, 1914023.8499999298 4231254.62000209, 1914054.8699999296 4231223.790002092, 1914078.7299999297 4231255.88000209, 1914078.2199999297 4231258.380002091, 1914073.9099999298 4231269.080002091, 1914078.9399999296 4231269.100002091, 1914087.04 4231272.52, 1914093.34 4231271.65, 1914102.45 4231267.83, 1914111.98 4231263.18, 1914121.19 4231264.21, 1914143.3599999298 4231251.700002091, 1914146.25 4231253.96, 1914143.31 4231259.11, 1914132.4099999298 4231274.910002089, 1914169.8499999298 4231270.28000209, 1914197.8999999296 4231264.190002092, 1914203.4099999298 4231263.40000209, 1914203.8299999298 4231263.07000209, 1914212.5499999297 4231261.81000209, 1914234.9699999294 4231264.44000209, 1914261.4599999294 4231259.67000209, 1914267.4299999294 4231260.690002093, 1914271.0599999295 4231262.560002091, 1914277.2099999294 4231266.22000209, 1914282.0799999298 4231269.51000209, 1914287.6699999294 4231274.650002092, 1914290.0199999295 4231276.760002091, 1914299.3799999298 4231291.73000209, 1914340.3199999295 4231331.1800020905, 1914322.1499999298 4231338.880002087, 1914336.6699999294 4231367.97000209, 1914336.2099999294 4231379.62000209, 1914386.0899999295 4231455.23000209, 1914385.5699999295 4231479.420002088, 1914407.5599999295 4231534.47000209, 1914415.1 4231543.9, 1914432.2699999297 4231565.380002088, 1914440.8699999298 4231572.17000209, 1914446.5199999295 4231575.22000209, 1914453.1599999296 4231576.54000209, 1914463.8899999296 4231576.67000209, 1914464.5699999295 4231578.1000020895, 1914464.9299999294 4231576.710002091, 1914466.3099999295 4231576.340002088, 1914473.8399999295 4231568.67000209, 1914524.0499999295 4231554.260002087, 1914552.1099999298 4231550.880002088, 1914555.4499999294 4231566.130002089, 1914579.5999999295 4231568.450002088, 1914591.4699999294 4231566.29000209, 1914605.1699999294 4231561.71000209, 1914600.5099999295 4231543.870002088, 1914610.1699999294 4231539.250002088, 1914630.8199999295 4231529.87000209, 1914605.9599999294 4231471.53000209, 1914589.6299999296 4231445.30000209, 1914575.5099999295 4231428.340002089, 1914569.2599999295 4231437.35000209, 1914542.8599999296 4231442.810002092, 1914531.4599999294 4231411.300002088, 1914567.2999999295 4231395.99000209, 1914574.0299999295 4231385.030002091, 1914580.1999999294 4231385.430002089, 1914580.4699999294 4231390.8500020895, 1914580.8699999296 4231394.22000209, 1914581.4199999294 4231397.43000209, 1914582.6199999296 4231402.190002089, 1914583.9099999296 4231406.3900020905, 1914586.0699999295 4231410.31000209, 1914588.6999999294 4231414.920002091, 1914590.3599999296 4231417.19000209, 1914596.2299999294 4231421.4700020915, 1914605.0699999295 4231424.18000209, 1914633.7299999294 4231432.060002089, 1914669.9299999294 4231435.92000209, 1914692.1399999298 4231438.1500020875, 1914697.2399999294 4231436.92000209, 1914707.1199999296 4231427.70000209, 1914710.1399999293 4231424.47000209, 1914721.6699999291 4231414.420002092, 1914746.2999999295 4231402.42000209, 1914705.0099999292 4231386.320002091, 1914710.3699999296 4231354.16000209, 1914742.4599999294 4231338.03000209, 1914777.5799999295 4231308.030002091, 1914801.2699999292 4231287.590002091, 1914800.7099999294 4231283.35000209, 1914840.0199999292 4231250.490002091, 1914858.3299999295 4231241.97000209, 1914873.2199999292 4231222.420002092, 1914883.8299999295 4231209.41000209, 1914909.4799999292 4231179.840002092, 1914937.72 4231149.97, 1914963.17 4231122.77, 1914983.67 4231107.25, 1914999.35 4231095.63, 1915006.6 4231089.45, 1915013.3390999294 4231082.666402091, 1915018.3910983151 4231061.656236241, 1915020.4657999296 4231053.028002089, 1915040.8777999294 4231026.10280209, 1915037.6766999294 4231000.901202088, 1915011.1137999294 4231005.6932020895, 1915009.3847999296 4230976.062602089, 1915008.023386285 4230968.7266822895, 1915006.2012629933 4230958.908248058, 1915004.7080999294 4230950.86240209, 1915000.51 4230942.83, 1914999.87 4230940.09, 1914973.05 4230930.57, 1914971.29 4230926.98, 1914968.6599999294 4230922.770002091, 1914978.3899999296 4230907.360002091, 1914967.9 4230877.76, 1914948.5078993514 4230833.0181773165, 1914952.22 4230825.77, 1914953.57 4230823.15, 1914960.0407097426 4230812.846526745, 1914929.5339778888 4230793.452388928, 1914944.66 4230768.11, 1914933.2199999294 4230764.96000209, 1914916.09 4230754.9, 1914903.98 4230744.79, 1914901.5417940896 4230743.687663102, 1914905.13 4230739.97, 1914897.24 4230736.45, 1914889.17 4230734.7, 1914856.08 4230734.95, 1914847.99 4230725.21, 1914846.71 4230719.35, 1914847.07 4230708.65, 1914852.21 4230687.5, 1914856.2299999294 4230670.89000209, 1914852 4230673.77, 1914794.31 4230660.77, 1914770.56 4230671.92, 1914767.89 4230673.36, 1914756.14 4230698.96, 1914741.36 4230726.24, 1914724.97 4230766.19, 1914722.08 4230778.31, 1914722.27 4230783.73, 1914714.19 4230783.79, 1914722.33 4230825.31, 1914740.43 4230844.57, 1914760.15 4230865.73, 1914747.64 4230891.47, 1914732.61 4230903.1, 1914737.99 4230905.27, 1914776.81 4230923.64, 1914763.65 4230957.86, 1914762.28 4230961.41, 1914761.35 4230966.39, 1914760 4230985.31, 1914757.06 4230994.91, 1914745.52 4231010.36, 1914727.83 4231020.98, 1914717.01 4231018.2, 1914713.29 4231018.78, 1914707.92 4231021.87, 1914705.14 4231025.24, 1914703.95 4231028.81, 1914703.61 4231042.41, 1914704.2 4231061.78, 1914704.63 4231063.86, 1914708.6 4231071.47, 1914722.39 4231107.77, 1914715.71 4231108.98, 1914690.84 4231113.54, 1914673.36 4231073.58, 1914666.56 4231058.61, 1914656.69 4231046.57, 1914655.15 4231045.07, 1914632.03 4231043.46, 1914569.74 4231060.74, 1914552.87 4231059.15, 1914543.97 4231051.97, 1914540.38 4231048.68, 1914522.62 4231027.33, 1914503.4599999294 4231043.16000209, 1914532.4 4231073.47, 1914587.7399999294 4231135.68000209, 1914600.8299999295 4231176.840002092, 1914612.3999999296 4231214.500002092, 1914612.4699999294 4231249.710002089, 1914578.8799999296 4231263.150002091, 1914577.3899999296 4231264.340002091, 1914541.0399999295 4231299.380002088, 1914533.7199999294 4231306.86000209, 1914540.1299999296 4231312.04000209, 1914541.6099999296 4231318.760002089, 1914525.7199999294 4231331.340002089, 1914504.3299999295 4231303.710002088, 1914508.1299999296 4231274.830002089, 1914505.810427289 4231270.209979441, 1914499.6399999298 4231257.920002088, 1914495.1399999296 4231250.12000209, 1914483.8599999296 4231246.38000209, 1914471.8999999296 4231244.73000209, 1914459.8799999296 4231242.830002092, 1914456.9099999296 4231242.180002089, 1914452.1599999296 4231241.13000209, 1914447.97 4231240.05, 1914439.92 4231236.7, 1914424.02 4231226.88, 1914399.8699999296 4231251.750002091), (1913737.69 4229970.62, 1913765.5269396703 4229971.73142909, 1913774.62 4230026.38, 1913779.13 4230051.14, 1913789.15 4230105.47, 1913784.59 4230107.58, 1913781.35 4230109.36, 1913779.03 4230114.68, 1913779.5599999297 4230129.470002092, 1913766.0499999297 4230124.910002093, 1913746.9499999296 4230119.490002093, 1913742.4199999296 4230118.2100020945, 1913747.09 4230097.53, 1913750.44 4230082.75, 1913752.046053244 4230076.035816256, 1913750.56 4230076.03, 1913750.5636518733 4230075.281366017, 1913740.9399999296 4230074.980002092, 1913746.3199999295 4230050.080002096, 1913719.51 4230049.29, 1913711 4230045.38, 1913712.07 4230044.31, 1913730.11 4229988.34, 1913732.58 4229981.12, 1913734.73 4229977.69, 1913737.69 4229970.62), (1913808.8899999298 4230227.640002094, 1913814.55 4230229.33, 1913818.53 4230263.44, 1913819.42 4230275.63, 1913819.55 4230292.65, 1913821.34 4230324.98, 1913822.83 4230341.28, 1913825.78 4230353.57, 1913828.39 4230364.43, 1913831.44 4230380.13, 1913831.8 4230383.35, 1913826.8799999298 4230381.0900020925, 1913798.3899999296 4230364.120002095, 1913797.0499999297 4230363.3400020925, 1913795.3599999298 4230362.370002092, 1913787.0799999298 4230357.580002093, 1913780.3899999298 4230353.690002092, 1913774.8799999298 4230350.32000209, 1913759.7899999297 4230341.070002093, 1913744.8699999298 4230331.920002094, 1913740.7299999297 4230328.940002093, 1913721.4899999294 4230315.060002094, 1913718.6299999298 4230312.910002093, 1913728.2299999297 4230306.900002094, 1913735.3499999298 4230297.040002094, 1913737.4999999297 4230292.740002093, 1913740.3399999298 4230285.980002093, 1913742.8299999298 4230279.280002092, 1913749.3099999297 4230264.000002092, 1913754.0599999297 4230252.410002093, 1913759.7499999297 4230236.270002092, 1913766.6499999298 4230216.680002091, 1913769.8199999298 4230206.340002092, 1913808.8899999298 4230227.640002094), (1914030.27 4231006.39, 1914025.64 4230982.87, 1914024.37 4230976.38, 1914022.82 4230968.48, 1914020.66 4230957.48, 1914019.76 4230952.88, 1914017.52 4230941.5, 1914035.23 4230938.13, 1914041.45 4230937.5, 1914052.98 4230936.55, 1914064.68 4230935.14, 1914089.65 4230991.98, 1914105.69 4231003.92, 1914112.33 4231010.27, 1914121.24 4231018.77, 1914125.6090617727 4231023.235695707, 1914120.41 4231028.14, 1914118.08 4231030.81, 1914084.45 4231050.82, 1914067.44 4231033.91, 1914057.7 4231003.93, 1914055.89 4230998.72, 1914045.09 4231002.08, 1914036.91 4231004.54, 1914030.27 4231006.39))','ZO33582','"lib_modif"=>"N", "lib_code_insee"=>"38328 / 38423", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UD3','Pavillonnaire en évolution modérée','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD3.pdf','2019-12-20','SRID=3945;POLYGON ((1913339.3506792563 4215532.621242475, 1913320.33 4215521.68, 1913299.319592371 4215508.8650293285, 1913281.9792066407 4215536.954050512, 1913320.420789743 4215560.530452543, 1913329.1027928807 4215547.733800232, 1913339.3506792563 4215532.621242475))','ZO32187','"lib_modif"=>"N", "lib_code_insee"=>"38068", "lib_modif_comment"=>NULL',1);
INSERT INTO urba_plui_ecriture.zoneurba (idurba,libelle,libelong,typezone,nomfic,urlfic,datevalid,geom,lib_idzone,lib_hstore,lib_id_version) VALUES
     ('MJ3_PH1_ZON_050_09','UD2','Pavillonnaire en densification','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD2.pdf','2019-12-20','SRID=3945;POLYGON ((1911075.567504591 4213332.276767893, 1911031.91 4213358.32, 1911029.39786686 4213359.81991904, 1911053.171310044 4213383.066477438, 1911055.7 4213381.54, 1911059.03 4213379.57, 1911076.79 4213369, 1911078.74 4213370.34, 1911078.57 4213383.14, 1911082.57 4213383.19, 1911082.42 4213394.11, 1911101.28 4213394.32, 1911101.32 4213389.12, 1911100.26 4213383.24, 1911100.47 4213364.54, 1911102.14 4213360.65, 1911101.39 4213354.36, 1911096.79 4213351.41, 1911083.05 4213327.83, 1911075.567504591 4213332.276767893))','ZO32404','"lib_modif"=>"N", "lib_code_insee"=>"38524", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','A','Agricole','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1921456.5635656258 4217184.394174554, 1921457.63 4217186.07, 1921455.76 4217190.68, 1921454.69 4217193.8, 1921453.26 4217198.34, 1921451.95 4217203.06, 1921451.4 4217205.58, 1921450.71 4217212.97, 1921450.12 4217218.49, 1921449.51 4217224.08, 1921453.06 4217224.31, 1921488.34 4217227.04, 1921509.07 4217228.66, 1921533.64 4217230.56, 1921537.17 4217228.97, 1921541.84 4217227.24, 1921546.11 4217225.59, 1921550.76 4217224.86, 1921553.07 4217224.44, 1921557.16 4217224.04, 1921560.33 4217223.78, 1921566.75 4217225.02, 1921574.98 4217226.48, 1921579.41 4217225.46, 1921583.565045749 4217228.671357392, 1921594.16 4217236.86, 1921595.08 4217235.47, 1921613.59 4217207.55, 1921620.3041243409 4217197.405323155, 1921605.3422494947 4217175.582355721, 1921598.2238647935 4217161.6776377885, 1921595.6348049757 4217154.372472908, 1921592.5963851046 4217147.987802454, 1921592.58440955 4217146.728110698, 1921592.3510199345 4217146.272218345, 1921590.459951969 4217140.105696099, 1921586.964551454 4217133.839898151, 1921585.201065385 4217129.046496595, 1921583.0896724109 4217123.798291499, 1921578.4972062726 4217110.556729746, 1921575.6464527377 4217099.818221517, 1921572.7543298937 4217084.728052619, 1921569.8720055595 4217070.6685412815, 1921566.9134747323 4217048.592814215, 1921564.622245612 4217036.474657191, 1921560.967695038 4217025.514738494, 1921560.2011182294 4217017.1615029685, 1921558.6601365972 4217011.678822363, 1921557.2567420208 4216996.5745069655, 1921557.194688207 4216990.047018137, 1921557.12065911 4216982.259838758, 1921557.8482514075 4216974.465039025, 1921558.2464442775 4216968.162230919, 1921558.3522523064 4216967.245003586, 1921558.321769733 4216964.038518275, 1921562.9888825486 4216948.9910245, 1921571.8101895647 4216937.225341811, 1921578.6104648921 4216929.716396086, 1921581.9610676393 4216920.751385715, 1921577.7078037541 4216907.04850158, 1921577.6109119013 4216896.856462182, 1921590.633223276 4216893.296834367, 1921600.317997058 4216900.076422675, 1921607.8204106106 4216906.189592041, 1921613.3956269028 4216914.38258052, 1921616.2289603788 4216923.288801679, 1921619.7515753934 4216932.417525621, 1921629.086267796 4216938.513275965, 1921634.283095303 4216943.0449769925, 1921634.399790033 4216943.272922928, 1921637.1939314036 4216948.056521411, 1921638.9574169735 4216952.849918334, 1921640.1439611518 4216957.190689589, 1921641.4569985163 4216962.790062827, 1921642.0698674328 4216967.021760493, 1921642.9183033116 4216971.938384822, 1921643.6663751376 4216978.344823354, 1921645.4494579555 4216985.199533043, 1921647.473551442 4216993.31175631, 1921649.0036481111 4216997.649262206, 1921651.3321001695 4217001.635595128, 1921654.6901197948 4217005.497612284, 1921659.2871447832 4217007.171823821, 1921663.6540464077 4217008.733695358, 1921664.806841034 4217009.524429607, 1921673.038825061 4217020.097244288, 1921678.0556137832 4217029.784404723, 1921678.4285616365 4217032.87310741, 1921679.0414315644 4217037.104806368, 1921680.8147175228 4217042.928861288, 1921682.0012631556 4217047.269634149, 1921683.7887028493 4217054.582415239, 1921686.5882906194 4217059.9386024475, 1921689.0290840424 4217063.694812592, 1921692.046819456 4217067.903648615, 1921694.7264465296 4217072.688337842, 1921698.4421739904 4217078.035815409, 1921701.6835008746 4217081.669887115, 1921705.614109755 4217085.52646114, 1921710.0071433834 4217089.836749743, 1921714.6281232464 4217094.030343431, 1921719.1389409145 4217098.683095458, 1921724.5778743918 4217104.5868288735, 1921728.397233009 4217108.788043842, 1921731.3058962976 4217113.570555971, 1921736.7644283066 4217121.535602917, 1921740.8280650857 4217127.337884288, 1921744.8819031587 4217132.109508949, 1921748.5976330095 4217137.456987069, 1921753.0385747727 4217146.80604255, 1921755.3670305798 4217150.792377047, 1921757.57008126 4217153.634626051, 1921757.573347595 4217153.978178348, 1921758.383679867 4217154.886696353, 1921760.7197573336 4217159.674652985, 1921762.44949549 4217160.918013067, 1921767.035636934 4217161.447048951, 1921771.4724197993 4217158.3126155995, 1921780.8508728778 4217156.963643167, 1921788.04696179 4217154.948252847, 1921792.1358366972 4217151.359015832, 1921796.7929434124 4217147.306265095, 1921802.1491313395 4217144.506673203, 1921807.3886240805 4217141.479135172, 1921813.0807423186 4217137.874654713, 1921820.5866292894 4217132.305957056, 1921826.1457197506 4217126.755769157, 1921829.640229999 4217120.881627757, 1921832.3418287267 4217115.9312474765, 1921833.3169556416 4217110.0810603285, 1921836.8005772056 4217103.061745276, 1921841.8219218103 4217101.181558678, 1921846.0862863788 4217104.004207195, 1921848.075546524 4217108.451875871, 1921850.4617116032 4217118.507631152, 1921852.7999683886 4217123.5246206615, 1921857.800435571 4217131.494019944, 1921863.4836523414 4217138.998816691, 1921865.9342494372 4217143.785682849, 1921867.256004948 4217150.301198879, 1921867.550370167 4217157.170066947, 1921865.318818761 4217163.375785093, 1921863.4417079228 4217170.723411279, 1921863.167841193 4217178.055793997, 1921860.2448294135 4217183.809975966, 1921854.7360147194 4217182.6025481075, 1921849.44425785 4217180.133250558, 1921838.0547670764 4217174.744207128, 1921832.751033571 4217171.015217393, 1921825.6052218645 4217166.272991713, 1921819.8499519234 4217163.235461658, 1921814.7948524903 4217161.565607838, 1921805.9715657835 4217161.076858853, 1921796.474240084 4217161.968851514, 1921788.713185397 4217164.791308239, 1921780.8441457977 4217168.301958142, 1921773.8825351712 4217170.887757987, 1921766.5653954057 4217172.217132125, 1921760.042256193 4217172.737262457, 1921753.5365373667 4217175.089671676, 1921744.4916402344 4217187.4301404655, 1921734.747660835 4217198.517450204, 1921723.051439667 4217209.050681734, 1921714.7461024544 4217214.856034334, 1921702.1441926504 4217222.216925551, 1921714.5472688412 4217228.704170609, 1921710.2893015938 4217233.620650475, 1921762.2723780298 4217259.318506419, 1921761.39 4217264.36, 1921760.629905773 4217268.634926961, 1921768.01 4217268.84, 1921791.58 4217266.58, 1921858.8 4217270.08, 1921894.17 4217257.7, 1921889.77 4217244.09, 1921887.24 4217236.26, 1921879.85 4217212.35, 1921897.03 4217205.81, 1921913.98 4217199.25, 1921916.09 4217198.55, 1921929.22 4217191.42, 1921934.2764505018 4217188.751072714, 1921942 4217184.68, 1921967.17 4217233.07, 1921974.86 4217247.64, 1921977.22 4217252.1, 1921978.1553929031 4217254.273076794, 1921979.46 4217257.46, 1921977.39 4217261.34, 1921976.17 4217264.38, 1921974.83 4217269.06, 1921973.65 4217273.71, 1921972.51 4217280.57, 1921971.6 4217286.14, 1921971.24 4217290.1, 1921970.69 4217296.07, 1921970.46 4217299.03, 1921969.27 4217302.29, 1921967.9 4217307.65, 1921967.52 4217310, 1921967.78 4217313.55, 1921961.03 4217316.87, 1921953.98 4217320.97, 1921947.66 4217326.16, 1921940.54 4217332.44, 1921933.71 4217338.92, 1921921.92 4217350.08, 1921914.94 4217356.68, 1921905.79 4217365.15, 1921898.88 4217373.42, 1921892.76 4217381.35, 1921882.77 4217394.3, 1921875.76 4217403.76, 1921891.99 4217422.04, 1921906.13 4217440.62, 1921910.69 4217448.55, 1921920.63 4217465.78, 1921928.81 4217487.63, 1921944.37 4217529.16, 1921937.8 4217538.55, 1921921.79 4217562.82, 1921916.52 4217572.54, 1921914.42 4217576.41, 1921913.09 4217578.88, 1921898.02 4217605.69, 1921882.49 4217633.91, 1921903.84 4217652.82, 1921906.6886354021 4217655.343077071, 1921902.48 4217658.11, 1921892.42 4217665.46, 1921884.47 4217671.39, 1921879.22 4217675.69, 1921870.71 4217682.87, 1921867.8 4217685.06, 1921862.36 4217688.31, 1921856.33 4217692.05, 1921850.89 4217694.56, 1921848.7 4217695.19, 1921846.51 4217696.06, 1921848.01 4217696.28, 1921848.9 4217696.72, 1921853.09 4217698.79, 1921876.82 4217751.21, 1921880.96 4217756.11, 1921881.61 4217757.39, 1921883.52 4217760.93, 1921875.12089489 4217769.568233688, 1921870.81 4217774, 1921868.66 4217776.03, 1921866.3 4217778.26, 1921858.45 4217785.52, 1921860.77 4217788.52, 1921863.91 4217792.59, 1921873.18 4217804.62, 1921885.2 4217820.62, 1921881.82 4217823.97, 1921873.9661548904 4217831.284712404, 1921885.29 4217844.06, 1921891.79 4217850.19, 1921896.19 4217854.33, 1921899.53 4217855.39, 1921902.05 4217856.34, 1921904.5 4217859.03, 1921909.5 4217864.55, 1921927.17 4217883.79, 1921929.53 4217887.39, 1921933.66 4217893.7, 1921938.17 4217900.35, 1921944.01 4217905.53, 1921944.75 4217906.83, 1921947.14 4217911.02, 1921948.74 4217913.92, 1921951.92 4217918.93, 1921953.03 4217920.43, 1921959.21 4217925.72, 1921962.7 4217928.7, 1921966.91 4217932.38, 1921972.69 4217937.13, 1921974.52 4217938.1, 1921976.83 4217939.17, 1921979.64 4217940.18, 1921983.98 4217941.94, 1921991.18 4217944.87, 1921998.36 4217947.7, 1922004.38 4217950.08, 1922006.55 4217950.93, 1922003.55 4217954.82, 1921987.16 4217975.66, 1921978.55 4217986.75, 1921973.76 4217992.97, 1921963.07 4218006.43, 1921958.5 4218012.33, 1921956.17 4218015.08, 1921955.12 4218016.55, 1921953.57 4218018.43, 1921951.24 4218021.7, 1921944.98 4218016.18, 1921922.23 4217995.29, 1921910.15 4217984.2, 1921874.87 4218019.57, 1921870 4218024, 1921862.65 4218030.71, 1921851.58 4218040.71, 1921850.65 4218041.52, 1921839.13 4218051.69, 1921828.89 4218060.83, 1921821.68 4218067.27, 1921814.68 4218073.52, 1921811.73 4218076.28, 1921817.71 4218078.45, 1921827.06 4218081.99, 1921831.5424402812 4218083.2761985, 1921830.94 4218087.73, 1921825.21 4218127.34, 1921792.33 4218122.25, 1921791.7 4218122.15, 1921789.05 4218132.62, 1921785.51 4218146.22, 1921779.88 4218167.82, 1921778.3127132973 4218173.897691339, 1921747.918677259 4218166.311505213, 1921739.71 4218190.88, 1921733.55 4218209.27, 1921719.7 4218250.57, 1921713.57 4218254.78, 1921725.1257745507 4218265.799903777, 1921770.34 4218235.13, 1921784.53 4218225.51, 1921785.5 4218224.86, 1921791.27 4218223.7, 1921816.9 4218218.41, 1921828.67 4218215.98, 1921895.7 4218202.15, 1921902.87 4218200.67, 1921918.31 4218190.78, 1921932.7 4218181.52, 1921949.4484349757 4218170.670961039, 1921982.22 4218149.45, 1921983.5893167742 4218147.976238763, 1921984.8465568544 4218146.214881326, 1922023.7054891645 4218098.4916641405, 1922060.0139855077 4218129.04619843, 1922043.0335526506 4218149.854026182, 1922087.431681204 4218185.644013384, 1922095.347350152 4218175.881188384, 1922109.809084092 4218158.097788351, 1922111.888165317 4218155.554632052, 1922136.6347176048 4218124.9240767155, 1922140.5025761325 4218120.127995696, 1922156.0040254293 4218100.943044308, 1922161.7870879618 4218112.0741818, 1922164.6339887884 4218117.414661822, 1922167.0595830223 4218122.245232203, 1922169.4850313053 4218126.9155105585, 1922172.3821894177 4218132.726015478, 1922174.98 4218137.82, 1922176.572195861 4218140.84727278, 1922178.135718428 4218143.727506273, 1922183.5470832475 4218152.787791931, 1922185.918230303 4218156.746877187, 1922190.7820481795 4218164.867954956, 1922193.1370826985 4218168.688208783, 1922194.2581377875 4218169.577499615, 1922195.7901210103 4218170.78700049, 1922198.1129681682 4218172.225713004, 1922201.0159034696 4218173.833794668, 1922203.6191484686 4218175.312474778, 1922208.1330464524 4218177.179037927, 1922214.4690850829 4218179.805178566, 1922221.9965541987 4218182.80965162, 1922228.2220015917 4218185.295411885, 1922231.8158162069 4218186.773188952, 1922241.8147256896 4218190.235874005, 1922248.07 4218192.34, 1922241.8928085489 4218210.037601556, 1922241.663753428 4218211.658743476, 1922239.8059548808 4218225.788370454, 1922239.810255656 4218225.788051122, 1922248.8105301678 4218225.119782892, 1922252.7023762194 4218224.906114537, 1922259.6258284296 4218224.539596334, 1922262.397485145 4218224.386983467, 1922264.6286944174 4218224.084776803, 1922266.9895054498 4218223.702606012, 1922268.9203593566 4218223.200157655, 1922270.5605280006 4218222.568299609, 1922271.6105847303 4218221.966996773, 1922272.580476498 4218221.015765504, 1922273.3601135784 4218220.1247422295, 1922281.2162530187 4218222.118532572, 1922283.6419409446 4218215.852915348, 1922288.6733646858 4218203.260882276, 1922289.7414358791 4218200.68862844, 1922291.2293271278 4218196.995146712, 1922298.2073467888 4218179.438283295, 1922301.461723785 4218171.4309095405, 1922304.3469536218 4218164.153892679, 1922308 4218154.93, 1922311.08 4218147.27, 1922312.56 4218142.59, 1922313.69 4218139.81, 1922316.03 4218133.71, 1922318.64 4218128.58, 1922327.26 4218107.72, 1922332.64 4218092.4, 1922336.07 4218082.37, 1922333.3318123512 4218074.806279155, 1922327.71 4218074.98, 1922313.31 4218078.22, 1922309.87 4218078.89, 1922304.4017681093 4218059.654127097, 1922302.6865799956 4218055.042638081, 1922297.9525762848 4218042.880357969, 1922299.3022832838 4218019.97595951, 1922270.8627849673 4218005.543173149, 1922266.601086344 4218006.367729585, 1922256.8975023355 4218008.11757526, 1922255.5656453068 4217995.941989666, 1922250.234774699 4217987.591846239, 1922245.4149546106 4217980.072114718, 1922239.4609013856 4217968.40083058, 1922230.7505364364 4217951.318748202, 1922219.3431588188 4217928.676328453, 1922198.3129053111 4217908.723819228, 1922193.2460128106 4217915.332229948, 1922184.7567779552 4217910.327085525, 1922167.4447392537 4217897.265547118, 1922158.6940523193 4217890.609692045, 1922151.8158288419 4217897.119494085, 1922143.8541289722 4217889.292247254, 1922143.3031302968 4217888.762644737, 1922152.614922868 4217873.435163079, 1922146.7094898638 4217849.226837971, 1922151.4065622953 4217843.268940252, 1922138.487754456 4217809.011234417, 1922152.552408353 4217804.815820523, 1922170.9266342141 4217765.366648122, 1922161.9937182544 4217734.6269433545, 1922156.3401536788 4217712.089161129, 1922142.2222829785 4217657.860912833, 1922129.7890770345 4217585.280422808, 1922160.5883000034 4217564.600530344, 1922154.97 4217548.38, 1922153.9679611002 4217545.274190789, 1922152.39 4217516.32, 1922135.49 4217472.49, 1922122.23 4217441.16, 1922118.78 4217433.586301964, 1922131.65 4217391.156301964, 1922130.27 4217386.31, 1922118.84 4217349.24, 1922097.6 4217351.09, 1922082.79 4217310.82, 1922081.8903312704 4217308.719967005, 1922068.8278612508 4217316.418174673, 1922067.41 4217314.36, 1922056.46 4217299.98, 1922049.83 4217291.46, 1922044.95 4217283.72, 1922039.58 4217274.91, 1922030.64 4217260.23, 1922025.58 4217251.84, 1922024.52 4217249.85, 1922021.4056688305 4217242.732977121, 1922017.615193225 4217233.60160531, 1922012.2811235858 4217221.7094599595, 1922006.0849785102 4217207.857379067, 1922005.1716749973 4217205.6462903535, 1921998.3030561595 4217219.060597523, 1921989.3767871573 4217234.655121411, 1921986.73 4217230.58, 1921989.76 4217217.86, 1921993.36 4217202.8, 1921975.23 4217176.07, 1921964.44 4217173.43, 1921963.74 4217172.46, 1921936.18 4217127.64, 1921923.92 4217134.4, 1921923.04 4217135.87, 1921917.64 4217138.31, 1921909.69 4217127.76, 1921896.73 4217102.98, 1921897.7 4217090.33, 1921897.91 4217085.19, 1921926.79 4217059.25, 1921908.63 4217017.17, 1921908.89 4216999.91, 1921910.8 4216995.45, 1921917.34 4216992.55, 1921921.28 4216990.77, 1921938.92 4216984.31, 1921942.1274280923 4216975.662744329, 1921944.0262809228 4216973.649868587, 1921950.8098187635 4216973.283489546, 1921956.11 4216969.98, 1921953.14 4216945.05, 1921946.66 4216935.63, 1921935.84 4216914.08, 1921931.64 4216911.33, 1921916.89 4216915.6, 1921916.49 4216911.91, 1921916.27 4216909.94, 1921915.5 4216906.87, 1921914.83 4216903.85, 1921913.26 4216898.45, 1921911.3034487562 4216891.8829812715, 1921910.36 4216888.71, 1921908.07 4216884.65, 1921905.77 4216880.59, 1921900.21 4216871.37, 1921898.220463241 4216867.475982788, 1921897.9730109745 4216866.991108147, 1921895.6646638114 4216861.802399358, 1921895.4367807494 4216861.290163634, 1921893.4524481222 4216857.769760693, 1921891.9563651346 4216852.458092482, 1921887.4435953475 4216851.801821741, 1921873.765281874 4216840.457590999, 1921864.9536432317 4216833.401980166, 1921858.4078286448 4216828.146017083, 1921857.2239938704 4216827.19546955, 1921858.1333200757 4216826.324146111, 1921835.7881589732 4216779.759774184, 1921815.7587798138 4216759.674281581, 1921810.8194940838 4216752.7748400355, 1921807.8742714925 4216748.87529528, 1921805.9006475485 4216745.9053970855, 1921803.7656497858 4216741.745167418, 1921801.544955481 4216731.151150369, 1921799.053043305 4216720.047089721, 1921803.24244317 4216716.321159499, 1921802.7511233012 4216704.174887549, 1921798.3473965253 4216692.051985532, 1921790.9046151447 4216682.432872005, 1921787.3789728214 4216678.653924287, 1921778.3459253097 4216669.7374563, 1921776.7536646717 4216668.24765502, 1921766.841136145 4216660.6725500105, 1921757.8297479479 4216653.787018547, 1921752.411393874 4216648.2087662425, 1921740.3225015646 4216635.212151856, 1921729.222208757 4216619.393032574, 1921722.6770701592 4216607.272080022, 1921716.7939813635 4216596.331398112, 1921716.0093235332 4216594.484953868, 1921716.8771822283 4216592.566398021, 1921717.8502349055 4216590.961326447, 1921718.602138493 4216588.589964032, 1921711.7382650068 4216564.959894889, 1921707.70447401 4216554.977723403, 1921703.816735958 4216546.169196937, 1921702.2342628592 4216542.677232798, 1921699.968848996 4216538.661528457, 1921697.5635071953 4216534.391372465, 1921695.5329684485 4216531.429499818, 1921692.7854868057 4216527.960103192, 1921689.7713557577 4216524.385822562, 1921684.5741690472 4216519.1005080305, 1921679.278469156 4216512.958594952, 1921676.516800056 4216509.428082363, 1921670.8766666153 4216502.3664603755, 1921667.118737035 4216497.647407437, 1921664.7229323962 4216493.349800552, 1921663.0530437306 4216489.725362478, 1921662.0984593134 4216486.37705175, 1921661.9107503386 4216483.8165544495, 1921662.1435697444 4216481.099597053, 1921663.4839204038 4216477.361316145, 1921665.4926778562 4216474.060723319, 1921668.4532034034 4216470.938836307, 1921667.38 4216469.51, 1921664.1907619154 4216471.398311165, 1921634.1796052966 4216489.135655975, 1921620.4996415635 4216497.742574818, 1921616.8198053963 4216500.007404762, 1921610.0996959426 4216504.095832799, 1921576.502481457 4216528.21025741, 1921582.0661036987 4216562.194141055, 1921582.5787574933 4216564.795555851, 1921583.9060617622 4216572.008054926, 1921590.9954333522 4216610.924166479, 1921598.4238897986 4216615.359946015, 1921589.29 4216622.51, 1921591.04 4216624.17, 1921587.93 4216633.59, 1921582.94 4216651.42, 1921566.57 4216702.51, 1921570.87 4216709.69, 1921578.57 4216722.25, 1921586.6283577327 4216715.777839615, 1921607.52690485 4216744.895250547, 1921598.37 4216751.85, 1921582.21 4216764, 1921562.93 4216778.98, 1921589.8268458992 4216811.532385439, 1921571.3 4216823.06, 1921572.38 4216827.2, 1921566.14 4216827.67, 1921562.28 4216828.32, 1921556.93 4216829.42, 1921551.95 4216830.77, 1921546.17 4216832.33, 1921540.73 4216833.46, 1921535.21 4216834.41, 1921531.74 4216834.44, 1921527.65 4216833.56, 1921524.39 4216832.34, 1921521.12 4216830.58, 1921518.83 4216829.12, 1921514.56 4216824.66, 1921509.81 4216819.59, 1921525.48 4216843.08, 1921475.34 4216872.44, 1921478.89 4216879.94, 1921480.7048331348 4216883.763510676, 1921485.35 4216893.55, 1921488.12 4216898.86, 1921490.74 4216904.69, 1921491.92 4216907.32, 1921494.48 4216914.68, 1921497.84 4216924.33, 1921503.24 4216939.84, 1921426.4562402698 4216968.067082485, 1921410.98 4216943.25, 1921407.8 4216949.22, 1921380.36 4216968.92, 1921333.08 4217002.9, 1921334.61 4217005.33, 1921339.46 4217013.06, 1921345.85 4217023.07, 1921353.05 4217034.6, 1921364.07 4217052.26, 1921372.98 4217066.57, 1921376.64 4217072.81, 1921379.27 4217076.95, 1921385.65 4217086.99, 1921393.11 4217098.75, 1921398.78 4217107.69, 1921402 4217112.15, 1921405.81 4217117.21, 1921410.73 4217123.95, 1921417.84 4217133.7, 1921425.7 4217144.29, 1921436.77 4217159.2, 1921443.96 4217168.79, 1921455.33 4217183.03, 1921456.5635656258 4217184.394174554))','ZO32529','"lib_modif"=>"N", "lib_code_insee"=>"38529", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UC1','Habitat collectif en R+5','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UC1.pdf','2019-12-20','SRID=3945;POLYGON ((1916377.8727491698 4224916.932310029, 1916414.438909338 4224898.757413852, 1916413.248886374 4224896.48555183, 1916410.76065654 4224891.400908256, 1916407.4069554596 4224884.909873908, 1916403.945070473 4224877.769736125, 1916395.1821741017 4224860.460311192, 1916386.0947260126 4224842.285415011, 1916383.714680084 4224843.367254071, 1916381.3346341562 4224844.449093129, 1916376.2499905825 4224846.829139058, 1916369.0016688923 4224850.074656232, 1916365.3234160943 4224851.805598727, 1916354.505025512 4224856.890242299, 1916344.8766578939 4224861.325782438, 1916333.0846121593 4224866.843161635, 1916356.7768875344 4224893.240034655, 1916356.993255346 4224893.564586372, 1916377.8727491698 4224916.932310029))','ZO32947','"lib_modif"=>"N", "lib_code_insee"=>"38421", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','A','Agricole','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1908050.79 4205077.66, 1908052.72 4205107.64, 1908053.41 4205114.47, 1908054.04 4205118.91, 1908056.15 4205131.56, 1908056.65 4205134.18, 1908057.28 4205136.28, 1908058.07 4205138.82, 1908058.75 4205140.71, 1908059.12 4205141.45, 1908063.06 4205149.2, 1908067.45 4205156.54, 1908070.75 4205161.91, 1908071.94 4205163.34, 1908080.6 4205173.87, 1908085.31 4205179.53, 1908089.84 4205186.9, 1908092.7 4205191.52, 1908095.38 4205196.65, 1908097.23 4205200.57, 1908098.47 4205203.41, 1908099.91 4205206.81, 1908103.03 4205220.33, 1908104.13 4205225.06, 1908104.65 4205227.35, 1908105.33 4205230.27, 1908111.34 4205229.01, 1908117.14 4205227.79, 1908120.31 4205227.14, 1908135.74 4205223.21, 1908146.19 4205220.18, 1908151.63 4205218.52, 1908157.58 4205216.37, 1908165.69 4205213.25, 1908169.65 4205211.45, 1908172.27 4205209.5, 1908178.8073358706 4205211.459309584, 1908177.588142749 4205202.15457963, 1908170.3511305833 4205158.584812511, 1908170.2034364576 4205151.052412094, 1908168.5788010755 4205147.101594235, 1908167.6926363206 4205142.818464586, 1908169.908048208 4205104.41799187, 1908171.2372953387 4205093.599397146, 1908171.6387448767 4205090.39809442, 1908176.9973662458 4205047.6665240135, 1908177.2927544974 4205041.906453107, 1908176.701977994 4205030.386311292, 1908176.701977994 4205017.241534093, 1908174.6342602326 4205003.50598039, 1908173.3050131002 4204995.087415218, 1908169.6126599545 4204980.761085013, 1908159.569459398 4204959.197742642, 1908152.6278354842 4204944.723718311, 1908149.9693412192 4204935.862070762, 1908148.7877882125 4204925.67117608, 1908146.720070451 4204910.163292867, 1908146.1292939477 4204902.187810073, 1908144.947740941 4204890.076891755, 1908142.1415525503 4204886.384538609, 1908140.3692230403 4204881.067550079, 1908141.846164299 4204877.670585185, 1908141.5507760474 4204869.842796517, 1908135.9383992658 4204847.836371768, 1908129.735245981 4204824.2053116355, 1908124.4182574512 4204800.7219456285, 1908121.6120690603 4204779.7493797615, 1908120.5782101795 4204766.161520185, 1908118.0674100404 4204757.5952608865, 1908113.7842803914 4204750.062860469, 1908110.4854423783 4204748.27571105, 1908102.39 4204736.16, 1908101.62 4204734.85, 1908100.69 4204732.47, 1908100.24 4204729.48, 1908111.54 4204728.11, 1908116.05 4204736.11, 1908119.03 4204740.21, 1908119.9739432167 4204741.26398841, 1908122.89 4204744.52, 1908127.16 4204749.12, 1908131.26 4204753.92, 1908135.09 4204758.66, 1908137.36 4204761.91, 1908139.66 4204765, 1908142.27 4204769.87, 1908146.32 4204777.07, 1908147.92 4204780.47, 1908149.11 4204783.84, 1908149.83 4204786.48, 1908151 4204790.93, 1908151.57 4204794.69, 1908151.96 4204798.46, 1908152.32 4204803.2, 1908154.12 4204839.08, 1908154.62 4204841.88, 1908154.8 4204843.63, 1908157.09 4204848, 1908158.04 4204849.49, 1908159.49 4204851.17, 1908161.52 4204852.99, 1908166.75 4204857.24, 1908171.332022912 4204860.787648336, 1908172.11 4204861.39, 1908174.03 4204863.23, 1908179.56 4204867.74, 1908180.98 4204868.48, 1908182.41 4204870.31, 1908183.75 4204872.19, 1908184.83 4204874.61, 1908185.61 4204877.54, 1908185.86 4204879.87, 1908185.94 4204882.68, 1908185.93 4204886.27, 1908185.48 4204892.29, 1908185.33 4204898.53, 1908185.52 4204902.99, 1908186.13 4204906.07, 1908186.87 4204908.94, 1908188.56 4204913.86, 1908189.6 4204917.02, 1908189.94 4204919.68, 1908190.2 4204922.65, 1908190.1868188754 4204923.376844875, 1908190.13 4204926.51, 1908189.87 4204929.59, 1908189.17 4204933.84, 1908188.67 4204936.31, 1908187.81 4204938.51, 1908187.08 4204940.21, 1908184.724524792 4204942.964543321, 1908184.66 4204943.04, 1908182.48 4204945.56, 1908180.07 4204947.27, 1908177.98 4204948.97, 1908177.4404486236 4204951.074565724, 1908195.6068261007 4204981.647249769, 1908205.0592501538 4205002.324427386, 1908210.967015187 4205016.946145843, 1908213.9208977036 4205027.727817028, 1908214.9547565843 4205039.543347094, 1908215.8409213393 4205046.041888631, 1908217.760944975 4205051.801959538, 1908223.3733217565 4205063.76518373, 1908226.7702866502 4205072.922219532, 1908229.4287809152 4205087.470090926, 1908229.98 4205087.24, 1908233.48 4205085.87, 1908273.53 4205070.23, 1908308.78 4205056.88, 1908355.71 4205038.8, 1908411.83 4205017.19, 1908413.3079675715 4205016.798451714, 1908409.0248379225 4205006.607557032, 1908396.6185313528 4204973.967155224, 1908392.4830958296 4204961.265460403, 1908391.7446252005 4204956.39155425, 1908390.95 4204937.82, 1908391.3 4204922.31, 1908390.57 4204907.99, 1908389.39 4204892.16, 1908387.2 4204880.52, 1908385.23 4204870.87, 1908380.87 4204845.43, 1908380.18 4204844.89, 1908371.77 4204831.21, 1908370.99 4204802.15, 1908367.27 4204785.81, 1908354.74 4204756.96, 1908347.12 4204739.39, 1908346.32 4204731.08, 1908346.06 4204728.4, 1908345.65 4204718.11, 1908345.25 4204708.28, 1908345.5 4204705.43, 1908347.58 4204694.64, 1908350.44 4204681.42, 1908349.97 4204647.86, 1908349.49 4204613.67, 1908330.1 4204586.86, 1908323.38 4204574.57, 1908296.69 4204541.55, 1908296.2 4204540.94, 1908293.89 4204516.31, 1908283.96 4204477, 1908272.47 4204445.4, 1908257.17 4204449.66, 1908254.45 4204440.38, 1908261.67 4204439.42, 1908263.24 4204439.07, 1908286.8 4204433.89, 1908279.6 4204394.94, 1908279.497089571 4204393.233852466, 1908277.4293718094 4204393.381546591, 1908273.8847127894 4204392.126146521, 1908256.8260412563 4204383.929122538, 1908252.5429116073 4204382.230640091, 1908252.76 4204381.11, 1908257.64 4204345.07, 1908179.64 4204339.25, 1908169.62 4204278.66, 1908217.54 4204270.8, 1908210.66 4204250.7, 1908197.43 4204236.5, 1908193.95 4204232.77, 1908193.68 4204221.81, 1908192.64 4204217.14, 1908190.88 4204209.2, 1908190.78 4204208.8, 1908189.83 4204205.16, 1908149.8464986647 4204226.477984741, 1908119.68 4204170.54, 1908097.59 4204128.19, 1908069.79 4204140.39, 1908067.9991013978 4204141.11997971, 1908065.1929130072 4204127.975202511, 1908063.58 4204127.7, 1908063.64 4204128.02, 1908045.0328189828 4204130.318441837, 1908039.92 4204130.95, 1908038.3125821063 4204130.929085027, 1908039.7895233647 4204121.3289668495, 1908036.6879467221 4204111.728848671, 1908036.6879467221 4204102.2764246175, 1908030.6324875632 4204080.860776373, 1908031.2232640665 4204074.509928962, 1908037.721805603 4204057.968186869, 1908044.2203471398 4204037.143315127, 1908043.9249588882 4204020.74926716, 1908040.9710763716 4204007.161407584, 1908039.37 4204006.75, 1908034.1573558296 4204005.821201584, 1908000.87 4203999.89, 1907972.5 4204067.61, 1907963.81 4204088.37, 1907961.5 4204093.93, 1907988.24 4204103.82, 1907990.63 4204120.81, 1907992.4 4204124.51, 1907993.11 4204141.76, 1907996.81 4204163.08, 1907998.02 4204170.16, 1907999.18 4204177.02, 1908004.7491829316 4204183.400953973, 1907989.17 4204190.25, 1907981.7 4204192.03, 1907989.29 4204211.64, 1907973.4703483505 4204220.631601524, 1907971.3443581588 4204265.733759104, 1907955.0781251572 4204265.51973203, 1907949.95 4204267.83, 1907948.95 4204270.19, 1907948.9398626685 4204270.868718472, 1907948.8816770914 4204274.764381401, 1907948.32 4204312.37, 1907947.94 4204314.89, 1907947.27 4204317.37, 1907945.3 4204322.41, 1907942.96 4204328.26, 1907939.57 4204336.37, 1907939.39 4204337.71, 1907939.33 4204339.37, 1907934.14 4204342.43, 1907929.91 4204339.8, 1907927.44 4204338.55, 1907923.73 4204337.2, 1907919.84 4204336.02, 1907914.51 4204335.08, 1907910.19 4204334.67, 1907902.41 4204335.46, 1907888.29 4204333.17, 1907865.84 4204334.68, 1907851.09 4204334.39, 1907835.35 4204332.38, 1907833.33 4204331.7, 1907830.71 4204330.83, 1907826.51 4204325.19, 1907825.22 4204323.47, 1907820.48 4204315.36, 1907819.98 4204311.06, 1907821.792993645 4204310.45129495, 1907818.6914170005 4204284.530975888, 1907814.5559814773 4204252.92443296, 1907802.888145537 4204209.797748218, 1907770.9862143581 4204187.643629344, 1907754.739860517 4204167.114145854, 1907736.7211771659 4204155.150921662, 1907731.2564945102 4204148.800074251, 1907702.7515282251 4204101.39025986, 1907701.1268928412 4204099.322542098, 1907678.8250798406 4204078.349976231, 1907658.738678728 4204066.8298344165, 1907640.719995377 4204052.798892463, 1907642.25 4204051.31, 1907686.13 4203999.5, 1907687.2436450128 4203998.447454158, 1907683.9943742447 4203997.413595277, 1907681.040491728 4203994.755101012, 1907678.381997463 4203988.404253602, 1907669.9634322908 4203976.44102941, 1907669.9634322908 4203964.920887595, 1907672.31 4203963.53, 1907709.32 4203975.87, 1907752.97 4203981.48, 1907751.61 4204007.38, 1907787.97 4204024.75, 1907842.93 4204075.89, 1907842.47 4204078.47, 1907855.56 4204090.87, 1907862.61 4204104.35, 1907864.09 4204117.64, 1907872.09 4204111.53, 1907886.99 4204110.61, 1907911.8 4204105.71, 1907918.44 4204092.81, 1907937.79 4204094.64, 1907940.834459063 4204094.596330053, 1907935.812858783 4204076.725340847, 1907935.812858783 4204068.7498580525, 1907937.1421059156 4204061.955928264, 1907935.72 4204061.19, 1907891.61 4204046.24, 1907910.61 4204011.47, 1907940.68 4204014.51, 1907942.0898591303 4204014.250725622, 1907936.0343999714 4203998.8905365355, 1907933.006670392 4203985.598065211, 1907931.11 4203985.23, 1907860.21 4203978.88, 1907857.54 4203961.69, 1907857.2393478942 4203959.674517365, 1907779.6263207183 4203955.542310604, 1907779.84 4203953.98, 1907792.84 4203915.27, 1907758.35 4203866.18, 1907725.58 4203872.72, 1907723.53 4203862.46, 1907710.23 4203861.89, 1907705.69 4203809.06, 1907682.64 4203822.66, 1907644.31 4203802.57, 1907611.91 4203791.38, 1907610.77 4203730.07, 1907566.02 4203642.61, 1907536.07 4203638.7, 1907506.99 4203614.64, 1907522.51 4203616.86, 1907543.73 4203608.28, 1907545.3095900966 4203607.353408969, 1907558.3066731691 4203616.067362393, 1907568.9406502286 4203625.667480572, 1907598.7748636454 4203656.683246995, 1907613.8396644797 4203676.9173422335, 1907624.0305591617 4203691.982143068, 1907640.4246071284 4203720.634803478, 1907655.194019711 4203742.4935341, 1907661.8402553732 4203746.333581371, 1907666.861855651 4203747.219746127, 1907677.0527503332 4203747.81052263, 1907691.67446879 4203750.025934517, 1907696.8437631938 4203750.469016895, 1907717.6686349353 4203750.025934517, 1907725.9395059815 4203751.059793399, 1907731.9949651405 4203753.422899412, 1907739.3796714318 4203759.330664445, 1907754.4444722661 4203775.724712411, 1907757.989131286 4203779.860147934, 1907762.7153433124 4203781.337089192, 1907768.7708024713 4203782.370948073, 1907773.9400968752 4203781.78017157, 1907803.6266161662 4203773.361606398, 1907807.0235810603 4203772.91852402, 1907810.56824008 4203774.100077027, 1907839.8116769937 4203788.574101358, 1907861.0796311125 4203803.934290444, 1907864.033513629 4203806.740478835, 1907872.8951611787 4203819.737561908, 1907874.3 4203818.86, 1907882.65 4203816.34, 1907887.94 4203807.32, 1907889.08 4203793.45, 1907887.11 4203784.69, 1907885 4203775.26, 1907881.81 4203761.02, 1907911.93 4203740.59, 1907883 4203666.93, 1907849.45 4203611.68, 1907804.87 4203654.14, 1907786 4203677.92, 1907784.62 4203671.98, 1907760.3 4203656.09, 1907731.39 4203646.33, 1907700.23 4203655.13, 1907697.752544481 4203585.303291575, 1907680.5974093524 4203583.426960585, 1907649.581642929 4203573.088371776, 1907620.9289825186 4203560.6820652075, 1907590.5039925985 4203543.5495466115, 1907576.77 4203533.33, 1907565.01 4203521.46, 1907546.74 4203503.04, 1907558.49 4203492.69, 1907551.21 4203488.64, 1907550.35 4203488.15, 1907540.34 4203473.86, 1907539.35 4203472.35, 1907535.77 4203466.92, 1907531.21 4203464.89, 1907524.97 4203462.22, 1907513.87 4203457.47, 1907507.08 4203453.82, 1907503.12 4203451.7, 1907506.76 4203450.24, 1907514.67 4203436.25, 1907563.79 4203349.38, 1907572.6 4203342.5, 1907573.9991740393 4203341.503982483, 1907575.0330329202 4203343.867088497, 1907579.9069390725 4203366.759678001, 1907583.3039039667 4203377.689043312, 1907586.7008688606 4203384.4829731, 1907597.1871517946 4203394.969256034, 1907612.3996467548 4203408.261727358, 1907613.4335056357 4203411.954080504, 1907615.06 4203411.84, 1907639.95 4203417.07, 1907659.01 4203433.11, 1907659.67 4203433.66, 1907676.44 4203429.17, 1907695.09 4203432.31, 1907698.27 4203431.84, 1907705.57 4203425.1, 1907716.49 4203417.67, 1907722.13 4203415.89, 1907726.96 4203415.25, 1907731.35 4203415.63, 1907747.57 4203422.58, 1907755.04 4203426.44, 1907762.84 4203430.47, 1907779.28 4203441.64, 1907785.23 4203445.98, 1907828.6 4203457.4, 1907863.48 4203468.99, 1907867.46 4203472.71, 1907866.62 4203455.49, 1907864.87 4203419.64, 1907864.37 4203391.85, 1907864.87 4203341.08, 1907907.46 4203348.77, 1907930.86 4203404.64, 1907963.482664257 4203545.37131842, 1907983.75 4203525.87, 1907990.68 4203442.51, 1907991.6781618833 4203441.640599797, 1907990.6443030024 4203438.68671728, 1907972.9210079028 4203376.802878558, 1907967.1609369956 4203361.7380777225, 1907958.7423718234 4203349.922547657, 1907959.22 4203348.61, 1907966.96 4203323.59, 1907976.48 4203293.54, 1907982.12 4203274.46, 1907981.27 4203269.86, 1907978.47 4203244.83, 1907908.8 4203235.23, 1907907.0494277836 4203235.164211887, 1907924.6250287571 4203214.339340146, 1907929.794323161 4203207.250022106, 1907933.7820645585 4203197.797598053, 1907935.7020881942 4203189.674421133, 1907931.566652671 4203184.505126729, 1907895.8246742205 4203188.788256377, 1907887.8491914258 4203186.425150364, 1907882.532202896 4203187.311315119, 1907879.5783203794 4203192.037527146, 1907876.6244378628 4203194.400633159, 1907823.7499408163 4203212.41931651, 1907823.26 4203209.45, 1907825.23 4203175.68, 1907786.28 4203188.67, 1907777.2 4203185.02, 1907770.52 4203185.53, 1907762.04 4203196.93, 1907759.7983843326 4203198.24068043, 1907756.9921959417 4203192.037527145, 1907732.770359306 4203164.418725615, 1907719.625582107 4203143.150771495, 1907706.628499034 4203137.538394714, 1907685.6559331666 4203138.276865343, 1907658.0371316366 4203127.495194158, 1907631.3044948617 4203107.113404793, 1907603.6856933318 4203106.374934164, 1907583.5992922192 4203103.125663396, 1907558.1959025767 4203096.774815985, 1907530.8724892982 4203092.34399221, 1907509.1614528014 4203083.186956409, 1907510 4203081.09, 1907513.08 4203075.1, 1907535.06 4203032.33, 1907547.67 4203020.01, 1907575.05 4203038.49, 1907577.73 4203035.37, 1907594.46 4203001.81, 1907582.74 4202990.4, 1907582.5 4202990.16, 1907572.99 4202980.34, 1907568.22 4202975.42, 1907554.13 4202959.9, 1907566.02 4202947.65, 1907565.15 4202946.75, 1907548.01 4202933.53, 1907534.8 4202920.22, 1907538.7 4202918.06, 1907532.37 4202910.68, 1907512.35 4202887.33, 1907502.65 4202876.02, 1907500.8793136661 4202875.848297083, 1907500.2998052519 4202871.984356474, 1907495.1305108478 4202847.024049209, 1907472.9763919734 4202804.340446845, 1907463.6716620463 4202800.648093699, 1907461.308556033 4202800.205011321, 1907444.3237315628 4202806.4081646055, 1907423.6465539467 4202813.054400268, 1907387.7568813704 4202820.291412434, 1907371.3628334035 4202816.451365163, 1907350.6856557876 4202814.383647401, 1907331.0423370523 4202806.9989411095, 1907310.5128535621 4202804.635835096, 1907308.7405240522 4202806.260470481, 1907304.4573944032 4202817.780612295, 1907300.1742647542 4202837.867013408, 1907298.1065469927 4202837.867013408, 1907289.8356759462 4202817.337529917, 1907281.8601931515 4202799.466540692, 1907270.192357211 4202794.149552162, 1907270.94 4202792.65, 1907286.39 4202763.13, 1907284.42 4202759.67, 1907272.79 4202758.49, 1907254 4202754.47, 1907229.54 4202748.73, 1907263.56 4202717.44, 1907262.03 4202678.37, 1907269.55 4202669.27, 1907289.43 4202659.3, 1907316.56 4202629.76, 1907329.26 4202597.01, 1907350.43 4202613.84, 1907356.34 4202655.58, 1907379.21 4202658.78, 1907426.04 4202613.67, 1907433.76 4202585.79, 1907418.18 4202562.18, 1907402.12 4202545.66, 1907401.81 4202540.29, 1907405.55 4202533.78, 1907396.87 4202523.54, 1907376.18 4202513.51, 1907339.77 4202514.16, 1907340.38 4202513.53, 1907289.34 4202484.68, 1907262.59 4202463.9, 1907274.19 4202454.71, 1907230.21 4202435.14, 1907206.15 4202457.47, 1907180.99 4202439.25, 1907155.8 4202420.4, 1907138.87 4202406.48, 1907139.483055853 4202403.941671723, 1907110.2396189389 4202392.273835782, 1907102.559524396 4202390.058423894, 1907098.8671712503 4202390.20611802, 1907101.7841302203 4202393.750777029, 1907128.2213787436 4202424.471155202, 1907129.698320002 4202429.788143732, 1907141.2184618167 4202455.930004003, 1907150.0801093662 4202487.831935182, 1907152.4432153795 4202501.715183009, 1907166.3264632074 4202551.340409288, 1907167.508016214 4202580.288457951, 1907176.074275512 4202632.276790243, 1907176.6650520153 4202650.295473593, 1907177.846605022 4202693.126770084, 1907183.1635935518 4202725.619477767, 1907184.0497583067 4202728.130277906, 1907083.913140995 4202755.305997058, 1907073.2791639355 4202726.062560145, 1907057.328198346 4202685.889757919, 1907055.5902609644 4202681.554678158, 1907050.65 4202681.27, 1907005.12 4202679.58, 1907007.62 4202773.24, 1907009.63 4202777.23, 1907017.46 4202803.68, 1907091.93 4202798.52, 1907124.9551773965 4202939.812255811, 1907080.08 4202946.89, 1907080.19 4202949.78, 1907074.18 4202949.7, 1907074.15 4202952.02, 1907086.92 4202963.61, 1907090.94 4202966.89, 1907101.48 4202975.7, 1907109.24 4202982.19, 1907116.08 4202988.13, 1907117.52 4202994.86, 1907121.1018536196 4202999.952031853, 1907124.22 4203003.37, 1907128.42 4203009.23, 1907131.71 4203015.01, 1907134.64 4203020.22, 1907138.85 4203027.63, 1907145.73 4203038.37, 1907147.58 4203040.54, 1907149.36 4203042.46, 1907152.12 4203044.7, 1907154.4 4203046.1, 1907157.38 4203047.69, 1907159.75 4203048.77, 1907163.26 4203050.31, 1907167.99 4203052.28, 1907177.62 4203055.64, 1907192.51 4203061.12, 1907196.0129825051 4203056.602013732, 1907189.5144409686 4203050.398860447, 1907167.3603220943 4203032.084788845, 1907158.7940627963 4203022.33697654, 1907150.5231917496 4203004.909069692, 1907139.8892146898 4202964.736267466, 1907123.6428608487 4202900.932405109, 1907129.15 4202900.07, 1907174.62 4202899.98, 1907177.91 4202899.98, 1907223.3367632923 4202896.1015276825, 1907235.3715396097 4202894.744087782, 1907238.3508680372 4202904.719062039, 1907238.4004018367 4202904.896800073, 1907242.1804018368 4202919.4968000725, 1907242.2875644576 4202920.027777085, 1907244.4275644575 4202934.687777085, 1907244.4367012002 4202934.753407881, 1907246.1667012002 4202947.81340788, 1907246.1564422126 4202948.4043816915, 1907246.1572643889 4202948.414761877, 1907246.1936452405 4202948.874079344, 1907245.9634751102 4202951.712844284, 1907245.939918825 4202952.003371802, 1907245.930154784 4202976.345126053, 1907250.3871677052 4203005.049472543, 1907254.004059304 4203026.974087049, 1907261.6441800166 4203030.538968897, 1907262.2777907844 4203030.89272268, 1907272.7977907844 4203037.81272268, 1907273.0822458798 4203038.014388735, 1907278.9822458797 4203042.514388735, 1907279.644048142 4203043.1204290595, 1907286.394048142 4203050.520429059, 1907287.4986274412 4203052.485302637, 1907293.6986274412 4203073.665302638, 1907293.7002056187 4203073.670705172, 1907297.1556621061 4203085.524462728, 1907303.5647483366 4203092.00378552, 1907304.750396198 4203093.929828975, 1907306.8497948656 4203100.188263641, 1907312.16 4203096.14, 1907340.92 4203108.9, 1907354.04 4203114.72, 1907398.9 4203116.53, 1907422.07 4203112.97, 1907423.25 4203117.26, 1907431.24 4203146.35, 1907411.61 4203157.27, 1907434.03 4203193.97, 1907449.49 4203230.71, 1907449.3084082964 4203233.391882364, 1907462.3054913695 4203242.992000543, 1907460.6 4203244.16, 1907454.98 4203248.48, 1907467.6 4203291.99, 1907444.25 4203302.56, 1907450.01 4203328.21, 1907456.76 4203350.6, 1907457.359178619 4203357.614587908, 1907457.5590437998 4203357.8182966495, 1907458.3323400018 4203358.8412738545, 1907458.8200023978 4203360.027298628, 1907459.9200023978 4203364.137298628, 1907460.080216048 4203365.117359959, 1907460.4021733513 4203370.256293835, 1907468.38 4203375.17, 1907466.3559421431 4203381.440295636, 1907468.2452515978 4203383.457693866, 1907468.5568928286 4203383.788812674, 1907476.0427752768 4203391.704458734, 1907476.4267412315 4203392.162452371, 1907480.4667412315 4203397.612452371, 1907480.814890952 4203398.151203785, 1907484.334890952 4203404.451203785, 1907484.7264408907 4203405.348484495, 1907486.5964408908 4203411.118484495, 1907486.8127861598 4203412.13904145, 1907487.6709761752 4203420.330855233, 1907488.5481461717 4203424.9399848515, 1907490.9428551814 4203428.626038651, 1907493.6709684734 4203432.825897252, 1907486.31 4203435.22, 1907476.79 4203446.01, 1907450.9 4203466.95, 1907423.27 4203481.58, 1907419.96 4203483.35, 1907420.360359647 4203484.767284532, 1907419.7695831438 4203517.112298088, 1907416.3726182496 4203527.450886896, 1907407.5109707003 4203571.463736393, 1907407.8063589518 4203590.959361001, 1907410.9079355942 4203622.565903928, 1907414.1572063623 4203653.138587974, 1907417.849559508 4203677.065036357, 1907420.9511361502 4203694.492943205, 1907423.9050186668 4203706.751555649, 1907432.6189720905 4203736.733463191, 1907434.3913016005 4203743.084310601, 1907436.1636311102 4203755.490617171, 1907437.9359606204 4203762.7276293365, 1907450.046878938 4203785.6202188395, 1907453.7392320838 4203795.958807647, 1907456.1023380968 4203809.842055475, 1907458.9085264874 4203828.008432952, 1907456.6931146001 4203833.620809733, 1907460.2377736198 4203863.602717276, 1907462.600879633 4203869.067399931, 1907467.770174037 4203895.356954328, 1907470.1332800502 4203900.23086048, 1907474.2687155737 4203905.547849011, 1907543.2418723344 4203989.881194858, 1907549.4450256191 4204001.10594842, 1907569.5314267315 4204013.6599491155, 1907577.3592154004 4204018.681549394, 1907576.45 4204019.61, 1907520.39 4204067.15, 1907558.07 4204111.66, 1907537.94 4204131.53, 1907534.6756130364 4204133.735273411, 1907536.595636672 4204138.756873689, 1907537.1864131754 4204145.993885854, 1907536.1525542948 4204164.455651582, 1907537.4818014272 4204174.351158013, 1907532.97 4204176.08, 1907529.41 4204184.14, 1907521.73 4204184.42, 1907519.23 4204186.23, 1907516.18 4204188.43, 1907507.85 4204194.45, 1907502.91 4204198.02, 1907490.85 4204178.26, 1907459.499302991 4204192.2221472375, 1907464.520903269 4204217.330148628, 1907461.8624090042 4204218.65939576, 1907454.182314461 4204215.557819118, 1907443.25294915 4204213.34240723, 1907420.212665521 4204220.874807647, 1907410.4648532167 4204221.317890026, 1907399.3877937796 4204217.920925131, 1907393.6277228724 4204211.422383595, 1907392.68 4204212.47, 1907408.38 4204255.38, 1907397.35 4204263.48, 1907399.49 4204270.04, 1907393.73 4204273.03, 1907388.901510846 4204275.373940078, 1907393.9231111242 4204280.690928607, 1907408.3971354552 4204287.780246647, 1907424.3481010445 4204291.91568217, 1907440.889843137 4204291.029517415, 1907474.2687155737 4204281.28170511, 1907480.76725711 4204278.6232108455, 1907486.0842456399 4204280.395540356, 1907489.9242929113 4204283.349422872, 1907491.4012341695 4204289.552576156, 1907495.54 4204287.79, 1907509.72 4204271.59, 1907513.3 4204245.68, 1907530.69 4204235.87, 1907546.16 4204272.84, 1907539.93 4204352.44, 1907552.18 4204384.18, 1907540.25 4204396.28, 1907536.45 4204407.88, 1907547.96 4204418.33, 1907561.82 4204421.56, 1907592.84 4204397.81, 1907593.3 4204393.06, 1907623.82 4204380.31, 1907625.79 4204384.81, 1907631.47 4204385.64, 1907647.04 4204404.68, 1907666.29 4204428.21, 1907684.64 4204450.65, 1907666.66 4204462.54, 1907649.82 4204466.95, 1907636.11 4204484.74, 1907630.76 4204494.26, 1907628.82 4204499.63, 1907628.609077062 4204503.561364479, 1907637.766112863 4204502.379811472, 1907659.9202317372 4204500.3120937105, 1907671.735761803 4204504.447529234, 1907696.8437631936 4204518.330777061, 1907715.157834796 4204531.623248386, 1907769.5092731002 4204579.771533405, 1907829.4730881855 4204633.827583457, 1907856.353419086 4204687.588245259, 1907858.1257485955 4204722.739447204, 1907858.4211368472 4204740.758130555, 1907862.2611841187 4204757.004484396, 1907873.4859376815 4204792.155686343, 1907894.7538918005 4204841.190136117, 1907912.086571681 4204853.313784395, 1907913.81 4204848.13, 1907919.3297664076 4204851.683398009, 1907920.94 4204852.72, 1907947.2 4204868.88, 1907957.47 4204874.83, 1907962.89 4204876.97, 1907965.67 4204877.95, 1907968.67 4204879.02, 1907969.57 4204879.34, 1907977.93 4204881.09, 1907990.64 4204883.52, 1907995.61 4204884.65, 1908001.76 4204886.49, 1908006.3 4204887.95, 1908010.97 4204890.61, 1908014.97 4204892.51, 1908018.65 4204895.66, 1908023.69 4204901.64, 1908031.04 4204910.31, 1908035.96 4204920.33, 1908036.78 4204922.43, 1908037.21 4204923.96, 1908037.77 4204926.12, 1908038.12 4204928.09, 1908038.12 4204931.39, 1908037.96 4204933.27, 1908037.37 4204935.81, 1908037.01 4204937.04, 1908034.97 4204940.84, 1908037.61 4204959.54, 1908041.64 4204988.68, 1908044.28 4205006.23, 1908046.42 4205028.28, 1908048.87 4205056.53, 1908050.64220829 4205076.033521441, 1908050.79 4205077.66), (1907998.47 4204504.83, 1907996.24 4204494.76, 1908068.2 4204541.53, 1908071.4699133576 4204543.217237254, 1908074.5714900002 4204553.112743684, 1908077.0822901393 4204558.282038088, 1908089.1932084572 4204573.7899213005, 1908099.679491391 4204585.900839618, 1908100.41796202 4204592.990157658, 1908098.86 4204592.46, 1908075.75 4204572.23, 1908016.57 4204533.79, 1907996.4542968688 4204508.556585162, 1907998.47 4204504.83), (1907702.73 4204359.67, 1907745.37 4204365.59, 1907745.5 4204398.01, 1907751.36 4204399.62, 1907759.91 4204397.87, 1907768.03 4204397.66, 1907777.064234509 4204399.503920434, 1907777.29 4204399.55, 1907777.317594027 4204399.560245307, 1907775.58 4204403.15, 1907759.54 4204412.36, 1907749.99 4204414.31, 1907740.62 4204413.73, 1907727.18 4204405.32, 1907715.82 4204391.94, 1907706.52 4204367.78, 1907701.3116957806 4204363.926404084, 1907702.73 4204359.67))','ZO33033','"lib_modif"=>"N", "lib_code_insee"=>"38187", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','A','Agricole','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1921170.71 4212318.74, 1921177.8 4212319.89, 1921192.1099041565 4212322.033277629, 1921193.44 4212313.93, 1921203.93 4212287.14, 1921214.56 4212268.67, 1921249.2 4212209.3, 1921263.37 4212215.01, 1921272.99 4212214.45, 1921266.82 4212235.13, 1921284.96 4212241.83, 1921278.12 4212258.41, 1921257.68 4212296.23, 1921255.79 4212333.11, 1921267.79 4212333.99, 1921278.7 4212334.8, 1921283.87 4212302.16, 1921298.85 4212305.56, 1921310.25 4212308.14, 1921305.98 4212321.33, 1921328.93 4212334.32, 1921342.23 4212288.11, 1921365.25 4212213.08, 1921374.12 4212182.63, 1921391.95 4212154.73, 1921409.05 4212127.35, 1921419.26 4212132.31, 1921427.37 4212136.25, 1921438.26 4212141.53, 1921446.16 4212145.37, 1921454.01 4212149.17, 1921468.01 4212155.97, 1921440.39 4212199.48, 1921439.65 4212203.13, 1921413.18 4212231.89, 1921405.76 4212227.96, 1921390.68 4212271.3, 1921380.59 4212294.03, 1921410.27 4212354.42, 1921410.2 4212376, 1921416.02 4212403.2, 1921421.23 4212432.02, 1921442.76 4212460.91, 1921448.58 4212459.24, 1921450.28 4212463.89, 1921455.35 4212461.66, 1921459.48 4212487.5, 1921472.82 4212483.51, 1921467.74 4212433.98, 1921486.49 4212427.15, 1921487.31 4212427.61, 1921521.22 4212397.79, 1921543.96 4212368.16, 1921571.11 4212386.56, 1921573.28 4212382.09, 1921589.6 4212342.71, 1921605.69 4212351.82, 1921621.75 4212360.91, 1921622.934891036 4212361.580651278, 1921613.2558040086 4212402.994676503, 1921611.3658040087 4212416.664676503, 1921605.2213677613 4212464.243308742, 1921607.6122550105 4212474.004195991, 1921631.4475785075 4212498.917097996, 1921638.8020147546 4212505.868872494, 1921642.6387737698 4212509.202406775, 1921646.5833825164 4212511.146210746, 1921649.5104969344 4212512.270527086, 1921665.8317829077 4212515.075746392, 1921666.16 4212513.28, 1921670.85 4212487.62, 1921676.5 4212454.58, 1921681.73 4212421.47, 1921684.18 4212410.19, 1921684.82 4212406.55, 1921685.83 4212403.41, 1921687.23 4212400.42, 1921701.77 4212367.34, 1921710.43 4212328.03, 1921692.36 4212329.92, 1921690.24 4212283.1, 1921689.97 4212277.12, 1921696.56 4212256.58, 1921693.05 4212224.61, 1921690.87 4212204.69, 1921686.2 4212162.6, 1921673.2 4212070.59, 1921673.8 4212066.94, 1921676.25 4212052.12, 1921682.75 4212051.91, 1921686.54 4212016.46, 1921691.41 4211991.09, 1921697 4211974.6, 1921698.1497914512 4211972.442543565, 1921705.696355247 4211982.011122143, 1921707.05 4211981.14, 1921737.16 4211965.9, 1921743.03 4211965.48, 1921736.01 4211940.07, 1921738.42 4211928.01, 1921740.87 4211924.43, 1921744.68 4211920.1, 1921740.79 4211899.01, 1921719.81 4211902.78, 1921711.75 4211903.22, 1921696.04 4211901.12, 1921638.31 4211884.41, 1921610.37 4211883.17, 1921601.7 4211878.57, 1921587.17 4211854.81, 1921585.8624214926 4211855.362661748, 1921584.8306021579 4211851.452145616, 1921576.9675785075 4211837.45088725, 1921573.9216080173 4211830.999833518, 1921567.2789926229 4211817.47567017, 1921565.281340341 4211814.4671443505, 1921562.625790842 4211812.533960329, 1921559.341794851 4211810.862645765, 1921541.8786402869 4211805.032070644, 1921539.1361643926 4211804.23088725, 1921511.2933182043 4211797.908613855, 1921508.8742697656 4211797.006451002, 1921487.5005268655 4211776.613835609, 1921485.0601586397 4211773.922316148, 1921482.0746765034 4211769.3934288705, 1921470.9620147548 4211746.9326617485, 1921461.6369778677 4211729.847264478, 1921448.408405693 4211704.665443625, 1921445.4298309465 4211703.917819594, 1921444.31 4211702.66, 1921414.44 4211674.39, 1921374.51 4211662.62, 1921361.55 4211680.2, 1921360.9174446694 4211681.017631716, 1921334.0154436247 4211667.551247634, 1921326.3389926224 4211665.164796632, 1921318.2598798722 4211662.688465757, 1921315.0617744988 4211661.650360384, 1921303.811534243 4211655.586571131, 1921296.23342887 4211650.107578508, 1921289.7988724946 4211645.522134882, 1921287.4079494714 4211644.664715231, 1921275.209879872 4211642.523909382, 1921265.9705268652 4211641.102902004, 1921259.868105373 4211638.58657113, 1921248.7469778678 4211632.828345628, 1921248.3243161195 4211631.219999998, 1921248.5678651172 4211629.561774498, 1921249.598091546 4211628.371085264, 1921258.5465546276 4211620.788603081, 1921260.5893993606 4211618.641247632, 1921261.3207671214 4211617.423308741, 1921261.652820439 4211615.940746243, 1921261.7469778678 4211614.621414116, 1921261.7178270814 4211612.559450695, 1921261.3009151912 4211610.835147664, 1921260.5069729155 4211609.374072394, 1921259.4324091242 4211608.044871402, 1921258.0906469936 4211606.55745838, 1921250.219759744 4211597.891127505, 1921239.6340775485 4211590.579234479, 1921228.347097996 4211584.158465757, 1921213.6511738591 4211578.47479663, 1921212.0068577398 4211577.809353006, 1921210.8148728136 4211576.554946303, 1921194.3136691258 4211562.68225501, 1921164.9117744989 4211561.775036887, 1921119.1882255012 4211559.8641496375, 1921095.2982255009 4211568.569593262, 1921091.566617484 4211570.140480512, 1921097.814842985 4211643.904842985, 1921096.9080223592 4211645.329634663, 1921094.3606254251 4211645.660178322, 1921091.8854728914 4211644.56111523, 1921088.67314226 4211641.9812939875, 1921062.0935679313 4211620.417357185, 1921047.7500823815 4211609.86948895, 1921030.9049167589 4211599.283308742, 1921032.45 4211597.92, 1921028.93 4211596.3, 1920995.29 4211585.07, 1920979.54 4211570.49, 1920968.82 4211560.57, 1920966.3888745096 4211558.320301785, 1920965.7797889311 4211556.22814741, 1920954.542255011 4211517.628225501, 1920952.4588724945 4211511.3125142, 1920926.4004805118 4211460.3186322395, 1920925.3733825162 4211456.295563753, 1920923.3007207678 4211447.517985244, 1920911.9853424304 4211436.566969381, 1920897.0348124423 4211416.619292156, 1920890.5124952665 4211406.657985245, 1920885.3671717695 4211385.770887249, 1920887.3169315138 4211367.396691258, 1920898.6911275054 4211356.745157015, 1920911.6693530064 4211344.427818764, 1920913.7324952667 4211330.49088725, 1920912.481367761 4211318.378225501, 1920912.3941093679 4211308.788302152, 1920913.498465757 4211300.574676503, 1920911.3366912578 4211287.437338252, 1920906.748465757 4211281.571774499, 1920898.2955637525 4211270.875970491, 1920895.8330306187 4211269.894935693, 1920893.8019768875 4211269.4763034545, 1920891.1095932624 4211269.069519488, 1920875.958225501 4211273.625083241, 1920868.1979852451 4211278.180646993, 1920857.3462107463 4211283.923308742, 1920851.4170979953 4211284.509759745, 1920844.8375047334 4211289.348225501, 1920830.3544362471 4211294.680646993, 1920825.9109347558 4211295.261209912, 1920816.318225501 4211295.542421492, 1920811.8780951558 4211286.454131297, 1920810.13 4211287.76, 1920805.7 4211289.65, 1920789.1 4211296.42, 1920808.23 4211326.75, 1920832.44 4211357.06, 1920836.37 4211377.56, 1920845.85 4211369.64, 1920856.75 4211373.03, 1920854.65 4211401.65, 1920853.22 4211421.9, 1920853.1143151051 4211423.5142395245, 1920834.3591127505 4211424.782421492, 1920828.960046354 4211425.732661749, 1920823.699926226 4211427.552014755, 1920819.9483919828 4211429.890480511, 1920817.1696345296 4211434.019068605, 1920807.2462107462 4211447.63342887, 1920805.4767684082 4211448.507166275, 1920802.7464284222 4211448.544336944, 1920799.1191127505 4211448.471534243, 1920791.3415342427 4211448.020526865, 1920789.8527959366 4211447.876691434, 1920788.149759744 4211448.1552033685, 1920786.0777449894 4211448.826210747, 1920783.7212939872 4211450.104436248, 1920780.9344362472 4211451.768752367, 1920763.8770979957 4211461.760526866, 1920761.9101236656 4211463.127673969, 1920760.025511245 4211464.935470769, 1920758.4541286277 4211466.63243422, 1920757.3160906183 4211467.812661747, 1920756.4163292733 4211469.362346184, 1920755.7177061858 4211471.023672754, 1920754.9996647616 4211472.628518949, 1920754.7733087419 4211474.4533087425, 1920754.921534243 4211476.631894627, 1920755.1517744989 4211478.4033825165, 1920755.583650277 4211479.88270563, 1920756.231855838 4211481.897499672, 1920757.317097996 4211484.29657113, 1920760.4177449895 4211489.711654372, 1920761.6839557355 4211491.751414116, 1920751.0091127506 4211494.369519488, 1920743.698345629 4211491.838752367, 1920731.4812476332 4211488.326977868, 1920728.9784657569 4211487.238678593, 1920726.9129475863 4211485.7683072835, 1920725.2836404413 4211483.999393546, 1920724.1792943368 4211482.541028307, 1920723.0506006398 4211480.402301365, 1920722.2348436601 4211478.087768835, 1920718.8707945417 4211464.565277143, 1920718.503696546 4211462.604362473, 1920720.17 4211462.33, 1920726.32 4211458.06, 1920727.19 4211457.46, 1920669.98 4211418.99, 1920674.92 4211410.7, 1920644.25 4211390.81, 1920649.06 4211346.49, 1920581.16 4211339.8, 1920558.6 4211350.44, 1920556.8209916304 4211350.113052091, 1920567.2240295098 4211309.894676504, 1920570.9973078459 4211295.536488662, 1920574.6740295098 4211280.655083241, 1920574.5340295096 4211278.785970491, 1920574.1558040087 4211275.987097995, 1920573.0240295096 4211273.9844362475, 1920571.724460505 4211271.948355121, 1920567.7746765034 4211267.21597049, 1920560.8666912578 4211262.901534243, 1920555.0211275052 4211259.684195992, 1920548.5469315138 4211256.389759744, 1920540.4781307816 4211254.291823404, 1920525.7075785077 4211251.984195991, 1920512.9879852452 4211250.796857741, 1920501.366451002 4211250.99685774, 1920492.843234968 4211251.766210746, 1920486.9146695528 4211252.573681933, 1920481.2764510019 4211254.0877449885, 1920479.27 4211253.24, 1920475.37 4211251.75, 1920461.47 4211253.78, 1920456.43 4211256.25, 1920418.58 4211288.29, 1920417.52 4211288.29, 1920385.99 4211288.76, 1920374.24 4211289, 1920342.65 4211261.5, 1920339.2 4211258.79, 1920317.25 4211249.2, 1920312.67 4211255.23, 1920297.72 4211299.84, 1920298.14 4211322.24, 1920298.050979789 4211325.1966591505, 1920258.8202402561 4211319.604842984, 1920255.3478187637 4211316.640646993, 1920254.16 4211318.32, 1920249.62 4211325.51, 1920243.65 4211335.62, 1920220.16 4211375.34, 1920218.16 4211378.47, 1920194.55 4211360.33, 1920164.61 4211377.42, 1920168.3 4211379.15, 1920166.99 4211404.87, 1920162.75 4211459.02, 1920198.97 4211502.48, 1920271.46 4211528.27, 1920253.72 4211576.08, 1920251.89 4211581.78, 1920269.77 4211595.35, 1920289.41 4211576.65, 1920312.63 4211554.75, 1920328.48 4211539.67, 1920354.23 4211523.73, 1920371.83 4211513, 1920379.19 4211508.01, 1920386.31 4211502.69, 1920389.95 4211499.75, 1920398.64 4211524.58, 1920399.0769316826 4211525.828448066, 1920389.1953234966 4211528.85225501, 1920385.83110351 4211530.408367636, 1920382.5155637525 4211532.709593262, 1920381.416051161 4211534.756385929, 1920380.883885409 4211537.292953135, 1920379.7242697657 4211548.536931515, 1920379.2146671403 4211551.167410775, 1920378.2731975005 4211553.136415833, 1920376.4444170734 4211554.504763197, 1920373.8229757783 4211555.925563753, 1920370.839853923 4211557.555590597, 1920367.4147195045 4211558.65460344, 1920364.5520251212 4211560.242080481, 1920362.578998454 4211561.384632232, 1920361.677911471 4211596.529723837, 1920361.7387060132 4211601.265249723, 1920360.892014755 4211613.458059019, 1920361.0356082858 4211620.08970815, 1920361.761367761 4211624.1544362465, 1920362.9345299536 4211627.084565975, 1920365.302086298 4211631.651574757, 1920367.7148485407 4211636.048571433, 1920370.16 4211635.07, 1920410.43 4211618.87, 1920409.55 4211632.49, 1920421.19 4211653.4, 1920427.83 4211683.04, 1920438.72 4211697.58, 1920444.94 4211695.12, 1920449.49 4211693.31, 1920464.37 4211693.04, 1920481.98 4211692.71, 1920485.36 4211703.66, 1920490.17 4211706.71, 1920504.73 4211701.37, 1920504.32 4211695.07, 1920513.6 4211663.88, 1920483.4 4211621.93, 1920472.42 4211593.61, 1920467.36 4211593.92, 1920481.78 4211558.33, 1920487.63 4211537.03, 1920472.76 4211538.7, 1920445.99 4211541.7, 1920438.95 4211538.11, 1920429.01 4211539.62, 1920422.91 4211540.55, 1920420.95 4211525.46, 1920409.44 4211523.97, 1920407.974842985 4211522.089759744, 1920409.115083241 4211518.612421493, 1920410.1904067378 4211513.133548997, 1920410.1286322386 4211508.715323497, 1920410.0912939871 4211504.579759744, 1920409.790406738 4211501.252902005, 1920408.8606356273 4211495.271485533, 1920407.7741959915 4211490.879833518, 1920404.7883919827 4211481.755563753, 1920402.8175047333 4211477.331127505, 1920401.1937154797 4211473.833789254, 1920403.48 4211472.41, 1920408.6 4211466.47, 1920414.01 4211460.84, 1920421.12 4211455.36, 1920432.49 4211449.2, 1920441.23 4211447.85, 1920454.9 4211449.47, 1920477.11 4211461.72, 1920508.1 4211474.53, 1920508.72 4211476.33, 1920521.58 4211489.26, 1920558.82 4211515.3, 1920567.51 4211501.64, 1920568.322393447 4211500.448421008, 1920585.3024214925 4211515.968706014, 1920588.3914415352 4211517.614269765, 1920591.6471654763 4211518.104712176, 1920594.6990797196 4211517.40807104, 1920603.232411976 4211514.99603255, 1920605.162902004 4211514.800480512, 1920607.3657450138 4211514.924662515, 1920609.3710676867 4211516.138205498, 1920618.4998800778 4211522.086888793, 1920630.992375098 4211527.819466357, 1920636.387440446 4211530.485335282, 1920640.4130684861 4211533.6933825165, 1920652.644842985 4211547.709353006, 1920657.1004067378 4211553.6902402565, 1920661.463068486 4211559.482014754, 1920664.4808694199 4211565.559368447, 1920667.3112939869 4211573.066451002, 1920671.1921812363 4211585.355563752, 1920672.9574683022 4211592.157200506, 1920673.513068486 4211595.128706013, 1920673.5075947384 4211598.768434288, 1920672.751592883 4211613.471308478, 1920672.3186322383 4211615.992661748, 1920671.8251442318 4211619.115007988, 1920669.9904067377 4211628.744195991, 1920669.393840424 4211632.171225784, 1920669.3480590193 4211634.522661748, 1920669.473504561 4211636.569651665, 1920674.010240256 4211645.195489978, 1920676.345397271 4211648.262661749, 1920679.5552572687 4211650.651948982, 1920687.0155637525 4211654.833308742, 1920696.516451002 4211658.722181236, 1920729.645323497 4211665.783068486, 1920754.8318938408 4211662.445907241, 1920757.1551451113 4211662.138081919, 1920758.75 4211659.83, 1920773.24 4211638.86, 1920784.75 4211631.01, 1920815.89 4211600.32, 1920823.67 4211592.64, 1920826.99 4211589.47, 1920832.7 4211583.55, 1920838.09 4211577.35, 1920863.14 4211545.42, 1920913.51 4211523.36, 1920916.8844362472 4211523.290480511, 1920919.9079852453 4211525.732255011, 1920922.5431422603 4211528.598872496, 1920921.02 4211529.59, 1920949.2914077414 4211592.826568717, 1920955.7567555695 4211611.2352364715, 1920970.0629927744 4211640.15338413, 1920992.5550271603 4211671.673065509, 1921026.06 4211714.23, 1921045.21 4211711.37, 1921070.94 4211707.53, 1921096.09 4211703.06, 1921097.587589777 4211702.875043166, 1921096.2193530065 4211726.498225501, 1921096.1858040083 4211736.015323496, 1921096.1258040087 4211747.714676503, 1921099.9591865244 4211763.140961024, 1921102.8258040086 4211780.319353007, 1921116.9031422602 4211815.41911275, 1921117.2975785076 4211816.786210747, 1921115.2077458862 4211835.833035756, 1921116.63 4211835.27, 1921133.23 4211830.45, 1921155.85 4211877.39, 1921151.4 4211879.97, 1921159.05 4211903.58, 1921169.13 4211933.55, 1921178 4211966.91, 1921184.23 4211996.68, 1921162.84 4212001.89, 1921140.7 4212009.29, 1921138.9786715745 4212009.891575651, 1921144.7433825159 4212023.186164393, 1921145.7319020757 4212026.226853879, 1921145.8313677611 4212034.002902005, 1921143.824932645 4212041.945577573, 1921140.2007207677 4212059.562661748, 1921140.2623279279 4212063.218153724, 1921141.065157015 4212066.995083241, 1921142.1835473748 4212070.636511365, 1921144.473382516 4212075.590406738, 1921159.2874120255 4212099.630240256, 1921164.7833825161 4212109.617744989, 1921169.5358040084 4212119.068151727, 1921170.7049167592 4212121.897264478, 1921171.628299275 4212127.294417314, 1921173.2765247764 4212138.1298883585, 1921175.0278187634 4212156.393530064, 1921174.8140295097 4212166.810868316, 1921172.703382516 4212186.578225501, 1921165.3495932622 4212247.457578508, 1921143.756533694 4212314.236516065, 1921146.45 4212314.84, 1921170.71 4212318.74))','ZO33065','"lib_modif"=>"N", "lib_code_insee"=>"38478", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','A','Agricole','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1906255.06 4204594, 1906227.202577954 4204602.889529787, 1906213.35 4204607.31, 1906210.55 4204614.34, 1906207.39 4204622.27, 1906225.69 4204623.08, 1906224.9161638857 4204629.469746436, 1906222.58 4204648.76, 1906222.29 4204652.09, 1906221.75 4204654.73, 1906221.53 4204655.68, 1906245.28 4204664.47, 1906257.1381644264 4204651.144719709, 1906259.9443528173 4204648.486225444, 1906282.3938599431 4204633.716812861, 1906285.4954365855 4204630.762930345, 1906288.0062367246 4204626.922883073, 1906293.7663076313 4204597.9748344105, 1906293.6186135055 4204592.879387069, 1906290.664730989 4204579.73460987, 1906289.36 4204580, 1906287.4 4204581.44, 1906284.91 4204583.81, 1906255.06 4204594))','ZO34062','"lib_modif"=>"N", "lib_code_insee"=>"38187", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','AU','Zone à urbaniser stricte','AUs',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/AU.pdf','2019-12-20','SRID=3945;POLYGON ((1922869.82 4208967.54, 1922863.05 4208958.34, 1922846.32 4208945.25, 1922843.88 4208947.41, 1922842.55 4208947.72, 1922842.92 4208948.15, 1922785.12 4209018.44, 1922784.0300685472 4209019.783703047, 1922807.97 4209052.36, 1922796.02 4209067.61, 1922802.3 4209067.79, 1922806.82 4209068.32, 1922812.71 4209066.75, 1922837.57 4209036.58, 1922854.42 4209009.95, 1922875.08 4208971.35, 1922869.82 4208967.54))','ZO33833','"lib_modif"=>"N", "lib_code_insee"=>"38364", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UC1u','Habitat collectif en R+5 avec bureaux autorisés sans limitation de surface','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UC1.pdf','2019-12-20','SRID=3945;POLYGON ((1913838.4498650816 4219913.871482768, 1913834.412676044 4219894.095847904, 1913822.3500478724 4219815.008926756, 1913822.81 4219811.81, 1913821.83 4219805.51, 1913817.6798975125 4219775.205333191, 1913805.11 4219776.92, 1913776.65 4219781.57, 1913786.2 4219840.9, 1913788.1 4219852.71, 1913795.74 4219900.23, 1913789.94 4219908.25, 1913788.29 4219921.79, 1913799.12 4219988.68, 1913800.2738527674 4219999.225223307, 1913814.025150854 4219996.9705928415, 1913821.0451999288 4219995.81960212, 1913826.897274927 4219994.828044339, 1913847.7571999289 4219991.293602121, 1913851.1134183109 4219990.639133276, 1913838.4498650816 4219913.871482768))','ZO32686','"lib_modif"=>"N", "lib_code_insee"=>"38151", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','N','Naturelle','N',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/N.pdf','2019-12-20','SRID=3945;POLYGON ((1918732.94 4218938.91, 1918728.7 4218940.57, 1918726.83 4218941.320000003, 1918737.5399999998 4218974.880000003, 1918737.5439264174 4218974.8927649865, 1918740.6926643064 4218985.129472414, 1918741.7 4218984.93, 1918742.6573876801 4218984.707886058, 1918744.2 4218984.35, 1918748.11 4218983.12, 1918761.9 4218978.6, 1918782.65 4218972.72, 1918791.35 4218970.14, 1918793.41 4218968.24, 1918795.08 4218967.75, 1918796.07 4218967.95, 1918797.27 4218967.9, 1918800.2 4218967.35, 1918801.06 4218967.2, 1918808.29 4218965.41, 1918811.28 4218986.18, 1918850.16 4218977.3, 1918852.7793160684 4218977.228067919, 1918850.8021355683 4218958.233385309, 1918848.9696876563 4218949.038906188, 1918843.43984395 4218933.429062359, 1918832.5901043583 4218899.628853885, 1918830.63 4218900.31, 1918732.94 4218938.91))','ZO32782','"lib_modif"=>"N", "lib_code_insee"=>"38059", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UD4','Pavillonnaire au développement limité','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD4.pdf','2019-12-20','SRID=3945;POLYGON ((1913479.7284415006 4228984.037116171, 1913418.93 4229017.75, 1913432.4999999297 4229047.5000020955, 1913434.6999999296 4229052.200002096, 1913438.4999999297 4229059.900002096, 1913451.6999999294 4229087.100002096, 1913455.2999999297 4229084.400002097, 1913457.9999999297 4229082.600002096, 1913474.47 4229070.07, 1913496.11 4229056.7, 1913500.46 4229053.83, 1913508.533789445 4229049.721830495, 1913479.7284415006 4228984.037116171))','ZO34017','"lib_modif"=>"N", "lib_code_insee"=>"38423", "lib_modif_comment"=>""',1);
INSERT INTO urba_plui_ecriture.zoneurba (idurba,libelle,libelong,typezone,nomfic,urlfic,datevalid,geom,lib_idzone,lib_hstore,lib_id_version) VALUES
     ('MJ3_PH1_ZON_050_09','UD3','Pavillonnaire en évolution modérée','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD3.pdf','2019-12-20','SRID=3945;POLYGON ((1909786.0999999314 4233807.900002082, 1909780.1099999314 4233763.820002084, 1909767.8999999312 4233765.000002083, 1909752.3999999315 4233764.600002083, 1909748.6999999313 4233764.500002082, 1909731.5999999314 4233765.300002082, 1909717.9999999313 4233767.200002083, 1909704.5999999314 4233771.100002083, 1909701.3999999315 4233799.900002083, 1909700.9439414493 4233804.037530118, 1909710.68 4233804.83, 1909721.42 4233804.86, 1909766.39 4233812.83, 1909780.79 4233812.39, 1909784.04 4233812.29, 1909786.4943993557 4233812.214173028, 1909786.0999999314 4233807.900002082))','ZO32126','"lib_modif"=>"N", "lib_code_insee"=>"38258", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','A','Agricole','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1907312.74 4203845.06, 1907274.72 4203818.05, 1907274.5862574491 4203816.709832303, 1907282.414046118 4203815.971361674, 1907305.4543297472 4203813.165173284, 1907315.349836178 4203813.165173284, 1907329.9715546349 4203812.131314402, 1907353.4549206416 4203810.949761396, 1907366.895086092 4203814.494420416, 1907384.175298814 4203822.912985588, 1907403.2278410457 4203839.15933943, 1907409.874076708 4203845.214798588, 1907426.415818801 4203853.485669635, 1907431.1420308275 4203857.17802278, 1907429.45 4203857.84, 1907401.15 4203876.24, 1907374.38 4203893.64, 1907366.47 4203899.17, 1907362.9073446947 4203901.190872277, 1907335.7316255423 4203864.710423198, 1907325.9838132374 4203855.553387396, 1907318.4514128203 4203851.565645999, 1907312.74 4203845.06))','ZO32127','"lib_modif"=>"N", "lib_code_insee"=>"38187", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UV','Parcs urbains','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UV.pdf','2019-12-20','SRID=3945;POLYGON ((1916386.1599999282 4220815.9700021185, 1916372.8799999282 4220831.7600021195, 1916374.679999928 4220833.78000212, 1916410.049999928 4220873.330002118, 1916473.499999928 4220943.90000212, 1916496.1399999282 4220968.360002119, 1916510.789999928 4220951.060002119, 1916525.469999928 4220933.680002119, 1916524.889999928 4220933.100002119, 1916386.1599999282 4220815.9700021185))','ZO33468','"lib_modif"=>"N", "lib_code_insee"=>"38158", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UV','Parcs urbains','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UV.pdf','2019-12-20','SRID=3945;POLYGON ((1914897.0900020364 4226278.930002122, 1914903.1490948168 4226285.246118478, 1914909.82 4226292.2, 1914927.8 4226310.93, 1914928.81 4226311.9, 1914929.4823579073 4226311.250054023, 1914932.41 4226308.42, 1914933.35 4226307.49, 1914958.029999858 4226289.560004205, 1914961.669999858 4226286.790004205, 1914965.459999858 4226283.640004205, 1914950.359999858 4226266.160004207, 1914932.1999998582 4226245.170004207, 1914928.819999858 4226248.620004205, 1914920.3899998579 4226256.680004207, 1914918.489999858 4226258.49000421, 1914914.639999858 4226262.170004206, 1914914.239999858 4226262.5500042075, 1914902.3599998583 4226273.890004208, 1914897.0900020364 4226278.930002122))','ZO32131','"lib_modif"=>"N", "lib_code_insee"=>"38516", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','N','Naturelle','N',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/N.pdf','2019-12-20','SRID=3945;POLYGON ((1908867.5572848825 4206541.170393282, 1908865.0977383032 4206464.41789467, 1908858.2126524067 4206433.367507294, 1908865.8986997658 4206386.050023581, 1909025.3816197158 4206360.081939464, 1909027.47 4206366.62, 1909035.28 4206388.61, 1909043 4206410.39, 1909106.03 4206434.6, 1909115.9 4206453.36, 1909118.23 4206457.79, 1909130.67 4206460.29, 1909125.98 4206427.54, 1909124.3 4206417.8, 1909123.4493940582 4206407.900052841, 1909123.401534723 4206407.392825391, 1909123.402547624 4206407.392690961, 1909122.35 4206396.14, 1909115.4 4206349.02, 1909115.13 4206338.36, 1909119.06 4206337.09, 1909119.08 4206336.32, 1909119.05 4206335.8, 1909118.95 4206335.17, 1909118.86 4206334.83, 1909117.4 4206330.44, 1909115.51 4206324.92, 1909113.93 4206319.22, 1909113.79 4206318.83, 1909113.51 4206318.2, 1909111.58 4206314.86, 1909111.07 4206313.78, 1909110.14 4206311.54, 1909109.99 4206310.86, 1909109.92 4206310.22, 1909109.69 4206306.48, 1909109.43 4206303.86, 1909109.2 4206301.4, 1909109.22 4206300.8, 1909109.52 4206299.87, 1909110.03 4206298.84, 1909110.46 4206298.13, 1909111.44 4206297.17, 1909112.94 4206296.06, 1909113.49 4206294.42, 1909113.67 4206293.49, 1909113.8 4206291.44, 1909113.88 4206289.74, 1909113.97 4206289.29, 1909114.08 4206288.82, 1909114.63 4206286.78, 1909114.93 4206285.76, 1909115.53 4206284.02, 1909116.12 4206282.46, 1909116.21 4206282.08, 1909116.31 4206281.37, 1909116.52 4206278.63, 1909117.58 4206271.54, 1909118.84 4206265.41, 1909119.75 4206259.61, 1909120.3 4206254.54, 1909120.55 4206248.15, 1909121.27 4206240.97, 1909122.17 4206237.86, 1909125.07 4206230.79, 1909127.62 4206227.48, 1909128.38 4206226.33, 1909128.87 4206225.55, 1909129.62 4206224.33, 1909130.28 4206223.24, 1909130.75 4206222.42, 1909130.98 4206221.88, 1909131.29 4206220.92, 1909132.22 4206217.67, 1909132.47 4206216.94, 1909132.86 4206215.89, 1909133.73 4206213.97, 1909134.81 4206211.39, 1909134.89 4206210.42, 1909135.01 4206207.24, 1909135.07 4206203.11, 1909134.65 4206197.67, 1909134.65 4206197.12, 1909134.69 4206195.04, 1909134.84 4206192.5, 1909136 4206180.19, 1909137.16 4206167.68, 1909137.51 4206156.78, 1909138.22 4206151.72, 1909138.23 4206151.38, 1909138.22 4206150.79, 1909138.06 4206148.94, 1909137.93 4206148.1, 1909136.48 4206141.65, 1909135.03 4206132.61, 1909133.66 4206127.39, 1909133.58 4206127.02, 1909133.42 4206125.98, 1909133.32 4206124.26, 1909133.38 4206123.26, 1909133.46 4206122.7, 1909133.68 4206121.79, 1909134.28 4206120.49, 1909135.13 4206118.62, 1909135.23 4206118.26, 1909135.45 4206117.25, 1909135.71 4206115.77, 1909135.93 4206114.39, 1909135.95 4206114.26, 1909136.02 4206113.64, 1909136.04 4206112.06, 1909135.93 4206110.13, 1909135.97 4206108.54, 1909136.22 4206107.02, 1909139 4206098.92, 1909139.02 4206098.81, 1909140.58 4206081.62, 1909141.29 4206073.64, 1909141.31 4206073.43, 1909141.33 4206073.13, 1909141.32 4206072.89, 1909140.07 4206068.44, 1909139.98 4206066.82, 1909139.72 4206064.23, 1909139.79 4206058.44, 1909139.9 4206052.36, 1909139.73 4206051.18, 1909139.24 4206047.78, 1909139.1 4206041.1, 1909139.03 4206036.92, 1909138.49 4206029.25, 1909137.86 4206019.94, 1909136.7 4206011.01, 1909135.32 4206004.2, 1909133.61 4205997.37, 1909133.57 4205997.23, 1909131.35 4205989.75, 1909128.85 4205982.77, 1909125.3 4205975.3, 1909122.9 4205968.68, 1909122.85 4205968.54, 1909122.17 4205963.04, 1909124.92 4205949.74, 1909128.45 4205941.16, 1909129.9 4205937.65, 1909131.12 4205933.68, 1909132.66 4205928.64, 1909133.75 4205925.39, 1909134.19 4205924.08, 1909135.99 4205918.8, 1909138.75 4205910.7, 1909138.85 4205910.28, 1909139.11 4205909.08, 1909142.43 4205894.03, 1909144.34 4205885.36, 1909144.96 4205880.55, 1909145.87 4205873.49, 1909145.95 4205867.09, 1909145.9227543084 4205861.9768919125, 1909128.650919839 4205865.982051375, 1909118.3263025687 4205841.192612548, 1909121.68 4205839.42, 1909123.23 4205838.6, 1909129.35 4205835.4, 1909124.12 4205819.8, 1909124.43 4205819.81, 1909125.47 4205818.32, 1909132.516374403 4205808.263646183, 1909158.5474084236 4205807.388652099, 1909159.05 4205806.11, 1909165.62 4205787.32, 1909166.27 4205785.46, 1909168.79 4205779.99, 1909171.36 4205772.26, 1909171.91 4205770.62, 1909175.48 4205765.31, 1909175.4 4205740.6, 1909176.7063592928 4205733.705673206, 1909178.1039663674 4205733.866331386, 1909180.0066999295 4205725.516602158, 1909180.8503972082 4205722.470380225, 1909182.0019938557 4205718.310824416, 1909185.4980943915 4205711.604302698, 1909190.9927618257 4205701.994542811, 1909199.0261205256 4205690.497372705, 1909199.3868972932 4205689.981036758, 1909206.80333241 4205679.784283967, 1909213.8774697774 4205670.058151558, 1909214.5859093885 4205668.620461436, 1909217.8724999295 4205661.950202158, 1909220.1200451257 4205655.834203173, 1909220.6675999295 4205654.344202158, 1909221.017250672 4205652.733125473, 1909222.3615999294 4205646.53880216, 1909223.7538999293 4205636.632402157, 1909224.1711694482 4205631.531814146, 1909224.7443999292 4205624.5248021595, 1909226.0379999292 4205615.91940216, 1909230.976735127 4205593.203871631, 1909240.4078750375 4205552.801333989, 1909250.1883164267 4205518.686222954, 1909251.003353209 4205512.515230172, 1909251.119787035 4205493.536516525, 1909250.886919383 4205481.310964789, 1909251.9348238176 4205468.6196777485, 1909252.4005591217 4205460.00357462, 1909254.845669469 4205453.832581839, 1909266.605485901 4205430.545816626, 1909271.1464051174 4205416.690191326, 1909275.1051552035 4205403.649602807, 1909279.0639052894 4205397.711477678, 1909328.0825460604 4205363.3634989895, 1909339.6094948405 4205353.815925253, 1909363.4784291827 4205327.967615868, 1909375.2382456146 4205316.2077994365, 1909377.683355962 4205314.344858219, 1909379.3134295268 4205313.646255263, 1909382.8064443085 4205313.879122915, 1909390.8403783066 4205315.974931784, 1909395.548679282 4205315.110141809, 1909393.7755304875 4205307.57288518, 1909393.27 4205307.65, 1909388.32 4205308.4, 1909387.14 4205308.58, 1909385.85 4205308.78, 1909383.05 4205309.01, 1909380.85 4205309.79, 1909379.62 4205310.54, 1909377.76 4205310.61, 1909375.79 4205310.53, 1909374.75 4205310.54, 1909373.24 4205311.07, 1909370.1 4205313.07, 1909369 4205313.7, 1909368.09 4205314.15, 1909367.21 4205314.12, 1909364.22 4205313.71, 1909362.87 4205313.28, 1909361.09 4205313.72, 1909358.91 4205314.52, 1909357.32 4205315.39, 1909355.74 4205316.28, 1909354.37 4205316.7, 1909352.63 4205316.99, 1909351.09 4205316.84, 1909348.54 4205316.48, 1909347.19 4205316.29, 1909345.37 4205316.42, 1909343.3 4205316.65, 1909342.04 4205316.73, 1909340.08 4205316.69, 1909338.75 4205316.51, 1909337.19 4205315.68, 1909334.37 4205313.9, 1909333.33 4205313.21, 1909332.5 4205313.05, 1909328.97 4205312.96, 1909327.41 4205312.93, 1909325.68 4205312.5, 1909323.87 4205311.36, 1909321.95 4205309.27, 1909320.2 4205307.25, 1909318.98 4205306.26, 1909316.28 4205306.15, 1909311.76 4205307.09, 1909304.14 4205309.37, 1909299.63 4205311.27, 1909297.07 4205312.69, 1909295.26 4205315, 1909293.53 4205318.09, 1909288.74 4205326.87, 1909287.18 4205329.83, 1909285.54 4205332.26, 1909283.58 4205334.57, 1909282.76 4205335.6, 1909278.52 4205338.86, 1909272.7 4205343.82, 1909268.91 4205346.47, 1909267.58 4205347.54, 1909265.27 4205348.7, 1909263.13 4205349.86, 1909262.04 4205351.39, 1909261.28 4205352.88, 1909260.92 4205353.69, 1909259.71 4205353.58, 1909257.42 4205354.08, 1909255.78 4205355.12, 1909255.18 4205355.95, 1909254.32 4205356.58, 1909252.89 4205356.48, 1909251.41 4205355.38, 1909249.22 4205353.86, 1909247.89 4205352.45, 1909246.14 4205350.3, 1909245.24 4205348.64, 1909245.25 4205347, 1909244.87 4205345.65, 1909243.96 4205344.34, 1909242.94 4205343.89, 1909240.67 4205344.12, 1909239.08 4205344.25, 1909236.47 4205344.02, 1909235.61 4205343.86, 1909234.54 4205346.04, 1909226.21 4205348.6, 1909223.48 4205349.2, 1909222.09 4205349.25, 1909220.44 4205348.74, 1909218.94 4205348.12, 1909217.08 4205347.86, 1909213.34 4205347.88, 1909212.4 4205347.83, 1909209.63 4205348.42, 1909206.58 4205349.33, 1909204.27 4205349.88, 1909199.63 4205350.75, 1909197.56 4205351.09, 1909194.9 4205351.42, 1909194.16 4205351.75, 1909192.15 4205353.06, 1909191.25 4205353.38, 1909188.96 4205352.91, 1909181.91 4205350.62, 1909180.81 4205350.22, 1909178.98 4205349.39, 1909177.54 4205349.01, 1909176.03 4205349.2, 1909175.47 4205350, 1909173.93 4205352.46, 1909170.75 4205352.73, 1909162.33 4205353.29, 1909161.3 4205353.44, 1909160.05 4205353.62, 1909152.58 4205352.85, 1909151.06 4205352.5, 1909149.49 4205351.58, 1909148.43 4205351.24, 1909145.34 4205350.83, 1909144.36 4205350.56, 1909142.51 4205348.96, 1909140.88 4205348.23, 1909137.5 4205347.26, 1909136.62 4205346.99, 1909136.43 4205346.13, 1909136.29 4205342.26, 1909135.86 4205340.44, 1909134.91 4205338, 1909127.18 4205330.37, 1909125.31 4205329, 1909124.36 4205328.41, 1909121.69 4205327.6, 1909118.61 4205326.03, 1909116.63 4205324.93, 1909114.18 4205323.34, 1909112.69 4205323.8, 1909110.02 4205324.66, 1909106.04 4205323.19, 1909103.4 4205322.51, 1909098.99 4205322.25, 1909096.81 4205322.65, 1909094.02 4205323.48, 1909092.6 4205324.01, 1909091.13 4205324.14, 1909085.25 4205322.45, 1909083.71 4205321.78, 1909082.68 4205320.86, 1909081.67 4205319.25, 1909080.19 4205317.87, 1909075.55 4205314.53, 1909072.84 4205312.91, 1909072.12 4205312.43, 1909070.66 4205312.09, 1909068.93 4205311.87, 1909066.01 4205311.06, 1909061.96 4205309.54, 1909057.63 4205307.85, 1909055.02 4205306.87, 1909053.97 4205306.46, 1909049.6756541557 4205304.500543992, 1909045.62 4205302.65, 1908997.37 4205289.16, 1909000.92 4205298.1, 1909012.4 4205348.35, 1909014.76 4205365.42, 1909016.2 4205403.03, 1909014.15 4205450.18, 1909007.98 4205481.22, 1908996.6739288503 4205515.741007879, 1908992.6 4205528.18, 1908976.54 4205572.2, 1908972.78 4205583.44, 1908965.0618502584 4205616.355991096, 1908959.9 4205638.37, 1908949.66 4205668.56, 1908942.95 4205683.75, 1908932.6 4205713.91, 1908912.83 4205788.52, 1908909.83 4205788.39, 1908888.79 4205869.06, 1908866.9305036545 4205923.407376933, 1908864.0329786371 4205930.611243016, 1908863.4910990638 4205931.958475006, 1908862.9827219434 4205933.216728161, 1908861.8791760218 4205935.8526068, 1908853.49 4205955.89, 1908849.86 4205967.63, 1908846.27 4205980.06, 1908844.89 4205991, 1908844.35 4206000.22, 1908844.9 4206013.64, 1908848.85 4206030.46, 1908852.61 4206041.71, 1908866.53 4206074.54, 1908872.79 4206093.16, 1908876.24 4206109.07, 1908876.06 4206119.81, 1908875.1087454902 4206126.382303885, 1908874.3 4206131.97, 1908871.658874247 4206141.6388737345, 1908870.3789410724 4206146.324569687, 1908870.2675739587 4206146.732116385, 1908870.1751454435 4206147.055413315, 1908869.9606690896 4206147.8012927715, 1908869.6628820861 4206148.837251511, 1908862.95 4206172.19, 1908862.0837780824 4206175.780368418, 1908860.4425504084 4206180.872571767, 1908856.8648840445 4206191.522979324, 1908850.3232604107 4206211.867548184, 1908847.9858713895 4206221.944388598, 1908849.2926156186 4206222.28797221, 1908850.3419810391 4206222.563882945, 1908846.9636101446 4206250.529570893, 1908844.6861570077 4206277.402912776, 1908842.391133162 4206308.122364489, 1908842.2409698877 4206310.174873829, 1908842.1340906362 4206311.681630352, 1908841.2663891693 4206325.73592303, 1908839.6285334236 4206352.921206368, 1908839.5273050426 4206354.650083438, 1908839.4834552943 4206355.378935469, 1908838.3695628208 4206369.606183166, 1908837.5659810936 4206377.85569824, 1908836.30598829 4206390.891032914, 1908832.0993631312 4206424.463121044, 1908831.5096843338 4206430.552270381, 1908829.3687385435 4206452.660134351, 1908828.5339157875 4206462.743988374, 1908827.9787687627 4206475.453726838, 1908827.9398442025 4206486.211976276, 1908827.9507026405 4206486.751106642, 1908828.097379932 4206489.130023172, 1908828.930102101 4206500.065096373, 1908829.667665683 4206503.763663676, 1908832.0259426793 4206512.709472795, 1908836.1383823662 4206525.521525483, 1908845.1572550752 4206554.24078479, 1908849.8614483404 4206570.39725344, 1908853.145536678 4206583.343259891, 1908853.7159137495 4206588.213786786, 1908874.089991806 4206687.672886927, 1908910.8851340618 4206838.534173609, 1908932.9786751904 4206924.460193909, 1908963.5742569198 4207002.97742842, 1909020.4375074042 4207120.478768285, 1909022.0003118245 4207123.600500845, 1909076.2412160165 4207211.941689788, 1909116.848633535 4207284.285581729, 1909159.4792569198 4207379.768388874, 1909211.449206168 4207542.301163459, 1909217.502647647 4207558.432502188, 1909236.3636189976 4207608.69361707, 1909245.1381182834 4207631.960550612, 1909259.7332879102 4207665.89046466, 1909202.8729128917 4207711.770286785, 1909199.105884519 4207714.63994581, 1909202.0289422378 4207718.37159876, 1909195.1760139086 4207724.2823672835, 1909194.1414006131 4207725.38003977, 1909204.010620984 4207737.9302992, 1909215.369799785 4207763.749377425, 1909235.5085120988 4207792.179536472, 1909241.6785444987 4207801.209682515, 1909256.4152644752 4207822.973703831, 1909258.9199704067 4207826.670736487, 1909265.070743935 4207833.540343829, 1909257.0202784245 4207836.858013128, 1909243.552988863 4207837.926717692, 1909210.9091435256 4207840.518055799, 1909151.5585653237 4207847.030748859, 1909095.3134638527 4207850.059506245, 1909051.667927878 4207850.312986612, 1909042.2106345335 4207851.91073249, 1909038.7298676623 4207852.490020254, 1909034.1195103126 4207853.319408137, 1909027.3494289545 4207854.419588368, 1909017.0603241262 4207855.5894159125, 1909013.0196736269 4207856.421317421, 1909009.6907012232 4207857.600796102, 1909003.5104580547 4207859.779848477, 1908991.2992652836 4207863.920508772, 1908989.2611640398 4207864.609620718, 1908988.6808243743 4207864.809424, 1908982.8504327503 4207866.830292049, 1908976.529304602 4207868.531008358, 1908967.1806438419 4207874.309896172, 1908963.5706759056 4207876.84033764, 1908957.3987408122 4207884.520726267, 1908952.5994672263 4207890.478819325, 1908948.8894392848 4207895.340994388, 1908946.570204321 4207897.2195831705, 1908936.8093848317 4207904.008563703, 1908928.8501868458 4207909.461488353, 1908924.3603319179 4207912.90997344, 1908921.089730748 4207916.359816742, 1908917.3191207033 4207920.580300133, 1908889.4303038763 4207940.59906194, 1908888.6404930633 4207941.050256083, 1908875.2329999297 4207902.776202154, 1908869.6057444832 4207895.655708102, 1908865.2750460436 4207890.706338457, 1908845.4775674634 4207872.455537891, 1908833.1041433509 4207863.484805409, 1908816.7093564018 4207851.111381297, 1908807.8932917216 4207841.831313212, 1908802.9439220766 4207835.799268957, 1908797.9945524314 4207828.065878887, 1908793.973189595 4207822.0338346325, 1908791.9625081767 4207816.465793782, 1908788.250480943 4207802.08168825, 1908788.250480943 4207795.894976194, 1908791.4985047725 4207772.849473786, 1908789.5402063646 4207772.540032608, 1908789.5402138392 4207772.539304978, 1908785.9803513235 4207773.289748055, 1908760.3391482686 4207767.331269444, 1908760.2308155112 4207767.009589974, 1908750.379617178 4207739.700403782, 1908747.5802904214 4207731.939445978, 1908744.9614981941 4207724.691008142, 1908742.420316281 4207717.640009731, 1908719.4091016715 4207707.438613285, 1908709.7094299416 4207683.218553333, 1908721.14962039 4207678.85945213, 1908701.3008307777 4207638.369170778, 1908728.7106280078 4207626.140025941, 1908729.996540833 4207625.56667494, 1908714.937943076 4207600.858878621, 1908708.7512310196 4207586.938776494, 1908685.0198999296 4207539.105002154, 1908682.5026014259 4207533.907287737, 1908652.762954547 4207542.156260668, 1908622.5333200912 4207554.93546907, 1908604.2244625723 4207558.405678027, 1908589.6578870234 4207561.166585468, 1908577.9387452807 4207566.9085515775, 1908520.0901403532 4207609.341574629, 1908507.6340696728 4207605.831566876, 1908511.5600228766 4207593.184505702, 1908438.5969702597 4207617.0175814815, 1908376.057728541 4207636.519228281, 1908269.1190578383 4207686.45489385, 1908264.3101419925 4207619.969186433, 1908240.587671971 4207617.394365889, 1908225.953424959 4207618.536164051, 1908191.047318005 4207630.65759349, 1908179.1479864884 4207633.822000734, 1908134.6227004102 4207640.612351414, 1908101.9178018735 4207640.236913772, 1908109.3816762445 4207540.051306617, 1908085.3590635275 4207467.112391288, 1908051.618990101 4207437.663544814, 1907994.3883306598 4207344.610373872, 1907929.4829471342 4207283.748973123, 1907884.427489713 4207205.903560436, 1907794.8146379818 4207151.740585381, 1907764.6697679514 4207133.327068533, 1907731.338996258 4207118.994428582, 1907679.2370490674 4207072.180172498, 1907606.3007650338 4207013.154611648, 1907596.0217997157 4207007.663368539, 1907537.8583084028 4206979.585403992, 1907507.1544233577 4206944.534928699, 1907504.9534940184 4206949.241591747, 1907491.8966273828 4206978.611052382, 1907456.369417507 4207054.554646849, 1907453.9154540382 4207059.80028272, 1907470.34 4207090.56, 1907475.92 4207101.26, 1907480 4207108.9, 1907485.65 4207114.92, 1907495.59 4207124.12, 1907506.7 4207131.47, 1907507.43 4207132.36, 1907512.13 4207161.41, 1907518.69 4207200.36, 1907522.1999815223 4207205.260124556, 1907522.8400854443 4207206.130036019, 1907523.3400770645 4207208.16169354, 1907524.9291991636 4207214.609578469, 1907528.149051855 4207220.659266573, 1907540.4005393204 4207240.630501009, 1907544.9791345133 4207258.239994743, 1907546.3410477615 4207265.760845541, 1907552.5403190863 4207278.909787286, 1907566.6092711356 4207307.699981998, 1907568.0603974422 4207313.530857529, 1907569.830610562 4207322.559967092, 1907573.4996379633 4207341.480137491, 1907578.900621107 4207369.619754493, 1907572.8613005695 4207389.279969922, 1907577.729564131 4207405.8398676375, 1907582.4002391372 4207424.420012015, 1907586.7589731237 4207440.439456352, 1907588.7913350894 4207457.010772442, 1907592.0991876759 4207459.9387248475, 1907597.0807680772 4207464.319830835, 1907597.0007174003 4207466.90007586, 1907596.470411721 4207470.16927111, 1907590.0395282009 4207474.111038103, 1907588.360193674 4207475.949445915, 1907587.02088335 4207478.77989436, 1907585.719765635 4207482.048544274, 1907585.708583979 4207486.550356635, 1907599.0396092427 4207540.58948149, 1907565.5408091906 4207565.650722331, 1907566.3792448307 4207567.520008509, 1907565.480791388 4207569.1992685795, 1907564.0692219976 4207571.771041218, 1907529.2792421994 4207611.100600165, 1907469.1897791345 4207672.159256741, 1907414.1196622648 4207620.229054467, 1907402.670655749 4207633.319767516, 1907358.9998722859 4207669.560399754, 1907353.3293155907 4207673.890526407, 1907318.700707415 4207728.700414623, 1907309.0504524533 4207720.810182655, 1907303.1588060057 4207724.940589885, 1907271.3810199157 4207708.2096006675, 1907256.8096333616 4207700.6699289465, 1907255.4599452578 4207704.010659984, 1907259.179192624 4207705.73042491, 1907257.219567087 4207711.180001018, 1907267.8106181337 4207717.060161883, 1907263.150103004 4207726.700470379, 1907228.939852831 4207718.499700142, 1907223.2551278635 4207724.531146599, 1907195.620210038 4207753.850262186, 1907195.6199537045 4207753.85020716, 1907194.63 4207758.28, 1907188.79 4207784.45, 1907181.37 4207817.82, 1907179.31 4207827.05, 1907178.42 4207835.91, 1907164.1807922102 4207832.282713655, 1907154.943211202 4207842.4680011105, 1907155.5784186642 4207853.5993451215, 1907158.2396374121 4207900.23441027, 1907143.280632481 4207968.681467968, 1907142.1545582607 4208055.8392084995, 1907150.8607292217 4208121.118161239, 1907174.5321421043 4208205.595632481, 1907172.174447499 4208209.843748984, 1907184.3089564797 4208217.329211447, 1907185.7403252593 4208225.34890284, 1907187.3492871656 4208229.710079769, 1907193.848551761 4208240.5301775355, 1907215.0892000943 4208272.418687407, 1907222.070712396 4208296.899914595, 1907253.7008472038 4208357.430606087, 1907253.9601863776 4208357.430385983, 1907234.7185033686 4208387.679564095, 1907222.5300439757 4208429.290471122, 1907220.0093902475 4208437.899437885, 1907218.8109890951 4208441.959237279, 1907216.5694032982 4208451.179096288, 1907216.0800446027 4208453.188792061, 1907215.0594890793 4208458.840496963, 1907214.890174795 4208468.009971968, 1907213.2994099078 4208497.829960896, 1907213.2118280502 4208501.5027341405, 1907239.455267911 4208488.101440811, 1907249.6601826106 4208484.023117112, 1907269.918865474 4208481.116954529, 1907271.5385974469 4208480.894214853, 1907283.7784612202 4208479.727307421, 1907285.6642105354 4208479.620801299, 1907312.317631427 4208478.168845637, 1907332.554487245 4208478.076424228, 1907348.4623802362 4208479.873166678, 1907372.9452429132 4208486.234150579, 1907397.1466401785 4208496.692306065, 1907419.4756278982 4208508.395019707, 1907465.0026566715 4208545.33454262, 1907500.4485251396 4208561.443999344, 1907536.967337117 4208584.910393328, 1907563.1832964667 4208595.996509624, 1907572.0972255603 4208598.94595565, 1907604.7508341921 4208605.924772548, 1907615.7932092524 4208607.02851617, 1907621.9983549977 4208607.63809897, 1907629.1847671592 4208608.063355556, 1907633.8170405012 4208608.329987421, 1907638.9012203128 4208609.643374786, 1907652.2041205775 4208616.72314221, 1907655.5112226803 4208616.763920033, 1907658.4027774935 4208616.889528267, 1907692.8913884833 4208601.085987183, 1907777.2827165022 4208585.317966736, 1907777.7995363257 4208588.102526698, 1907783.1348060903 4208587.226701553, 1907825.6950346748 4208831.415565857, 1907875.7319481943 4208990.10206789, 1907942.5184947108 4209148.466768372, 1907971.4504913602 4209223.522730416, 1907974.703647448 4209221.425321245, 1907997.7271370844 4209220.641628668, 1907998.6917657573 4209219.855993742, 1908062.0028797092 4209280.948186181, 1908066.9886941658 4209283.087122034, 1908093.5280499249 4209294.726326862, 1908102.2621803007 4209301.70541004, 1908138.5061480568 4209395.344622476, 1908146.4163676016 4209402.156137523, 1908146.780322448 4209402.44986017, 1908238.4131533084 4209439.383854733, 1908264.0516436854 4209365.155927894, 1908347.2785579152 4209326.945701056, 1908352.0127940432 4209330.378507108, 1908352.8990414836 4209329.9740207335, 1908375.6944450573 4209346.914139651, 1908412.431423424 4209374.18820122, 1908413.2143784477 4209374.770932837, 1908420.3032146557 4209380.187736538, 1908451.848478112 4209340.289077656, 1908479.913986865 4209344.409696757, 1908494.6608351546 4209347.128245747, 1908590.1255491704 4209381.588407067, 1908623.9741410501 4209412.0921512, 1908676.8180886689 4209446.415179369, 1908736.864323965 4209487.765401045, 1908775.9673210904 4209528.683062095, 1908780.3507736924 4209530.36146786, 1908826.5505906106 4209537.150014494, 1908830.3744547837 4209538.028926101, 1908844.0054075825 4209545.014384926, 1908847.9498420176 4209547.052878842, 1908849.1062044853 4209548.000217259, 1908854.2404178581 4209552.6554740695, 1908879.5749492485 4209600.794275112, 1908918.477529924 4209710.956560375, 1908924.8815918434 4209750.228359164, 1908927.6977108195 4209759.388580922, 1908929.5398212443 4209763.430931475, 1908936.5315079188 4209771.203780451, 1908936.8117000572 4209771.585302434, 1908941.650765469 4209777.782442929, 1908966.2086102478 4209823.430643454, 1908973.5943274768 4209836.211226508, 1909001.6921029815 4209881.11564171, 1909002.3414807164 4209882.153710652, 1909004.3255170684 4209885.395981989, 1909038.2158643599 4209885.861540269, 1909059.637739645 4209923.412687623, 1909066.3925155583 4209940.756252953, 1909069.631182777 4209949.153772408, 1909069.9795217968 4209949.147928082, 1909071.160241838 4209951.910181155, 1909111.0066659376 4209952.882369414, 1909181.9568834137 4210092.863733122, 1909191.2944006566 4210110.206142833, 1909200.3242185486 4210116.925981101, 1909208.578768083 4210143.544659772, 1909212.3939219797 4210155.812267753, 1909213.2769763402 4210157.706722939, 1909220.592333194 4210170.859174829, 1909228.2747709888 4210181.7339278925, 1909260.337856795 4210217.3940343475, 1909274.65321832 4210250.665782961, 1909295.5144156376 4210278.073680745, 1909312.8223497586 4210302.290077493, 1909315.4626034156 4210305.607385306, 1909316.3299726793 4210305.100711544, 1909312.4509306862 4210272.510473945, 1909291.560629129 4210236.66064132, 1909240.699225222 4210082.68978176, 1909259.090011071 4210082.430886406, 1909256.6991807853 4210068.038903415, 1909262.8494588681 4210052.551208111, 1909214.200967176 4209927.360602828, 1909214.20099409 4209927.359393149, 1909214.2000111793 4209927.359498095, 1909200.32 4209911.32, 1909170.04 4209893.01, 1909162.74 4209878.14, 1909147.88 4209883.97, 1909129.82 4209884.29, 1909121.58 4209883.48, 1909087.49 4209802.59, 1909086.25 4209779.26, 1909101.77 4209751.22, 1909107.09 4209744.61, 1909162.110414991 4209749.798764155, 1909158.539618581 4209702.080123826, 1909156.9199326993 4209680.348519575, 1909131.5400620417 4209669.250428083, 1909118.8394593326 4209669.819609672, 1909109.4000687418 4209637.729483534, 1909095.0001999438 4209534.150253744, 1909108.0197726532 4209533.118550237, 1909107.5693677706 4209530.766129955, 1909059.3819835617 4209493.081195091, 1909026.6049644803 4209469.961162815, 1909018.9309311481 4209459.310899672, 1909020.331974441 4209413.1337793, 1909015.2512162803 4209408.93515941, 1908989.982261842 4209358.764888464, 1908987.9385539496 4209345.595547365, 1908982.7037902174 4209328.082801032, 1908977.0517424364 4209295.825595843, 1908965.9096890483 4209283.40731221, 1908955.641252152 4209268.193892812, 1908956.0903193757 4209246.349806792, 1908952.2532979578 4209236.669198477, 1908944.779277794 4209227.1628466295, 1908901.267782162 4209180.849827986, 1908894.7134376054 4209169.363088981, 1908882.0156140523 4209141.289489952, 1908879.3557420308 4209133.487582253, 1908876.299053985 4209120.836236286, 1908872.4831400586 4209095.599385138, 1908866.5077101828 4209058.865682325, 1908858.0984023428 4209042.280193682, 1908850.5754167887 4209024.984028487, 1908839.850193922 4208996.148402799, 1908834.5950347509 4208987.607648687, 1908813.3843751485 4208956.080526277, 1908809.5635961061 4208938.154988177, 1908807.9504189459 4208938.160696251, 1908799.6885288332 4208934.3785168715, 1908777.698803422 4208934.540797145, 1908755.88866101 4208939.719228431, 1908750.169621908 4208915.430811423, 1908729.42002676 4208912.619823712, 1908702.351146428 4208889.818649954, 1908677.140253083 4208885.960304168, 1908676.739459047 4208871.468831024, 1908661.710318476 4208880.55977047, 1908628.7702542103 4208888.64126066, 1908631.4605810232 4208858.049465086, 1908633.0408877153 4208851.321487681, 1908648.6302915968 4208855.768572301, 1908674.010133587 4208853.610332062, 1908679.079373893 4208849.520797103, 1908674.4391633288 4208817.548523264, 1908605.410164283 4208841.220635518, 1908603.8089119324 4208840.827992672, 1908614.955886578 4208778.78519747, 1908616.9437889624 4208775.130805119, 1908659.148015392 4208731.862387108, 1908667.9444226297 4208724.051715134, 1908672.016462721 4208719.404174297, 1908673.3294751386 4208713.73340574, 1908669.8637127448 4208699.4718767945, 1908671.1593673197 4208697.4908900615, 1908687.2747138555 4208693.361044579, 1908699.2932682675 4208694.999747454, 1908710.39408612 4208698.264503046, 1908717.5909811128 4208702.020066598, 1908723.5321556926 4208706.440341888, 1908731.5197083896 4208713.640950151, 1908745.6170194882 4208728.288517125, 1908756.8908715015 4208733.899265381, 1908758.9352722627 4208737.805954435, 1908762.6256157889 4208748.690467246, 1908785.5345000175 4208788.678262248, 1908786.4154984704 4208806.869515684, 1908783.2622781687 4208821.924749171, 1908784.9699714365 4208822.25902973, 1908809.9898444293 4208827.390212978, 1908820.5391354878 4208848.220226487, 1908832.2488199936 4208857.779371756, 1908842.8993073616 4208862.1598297, 1908854.479939967 4208864.719310148, 1908858.979957268 4208868.919528101, 1908866.9093140773 4208885.389831405, 1908877.1190349679 4208882.599797927, 1908890.7606530965 4208871.911370316, 1908896.7194847083 4208878.949870983, 1908916.0185632845 4208861.959206351, 1908904.599211403 4208855.65056941, 1908874.3793644076 4208815.469745832, 1908879.3587440494 4208809.499470578, 1908909.9901158542 4208848.631175013, 1908928.0401004287 4208859.918625836, 1908938.3295164343 4208866.779926119, 1908943.9910072363 4208875.009121834, 1908949.3712190746 4208894.079805295, 1908952.9307739052 4208905.5789631605, 1908944.6391698832 4208906.360476219, 1908930.9708658883 4208907.6100396365, 1908904.4703910633 4208916.988760298, 1908919.3596144335 4208947.850678416, 1908935.7096062058 4208971.201296459, 1908945.111016344 4208978.610254431, 1908949.7900195217 4208982.910573497, 1908957.471453034 4208994.4710431285, 1908952.9000285834 4208998.028873457, 1908951.8844967778 4208998.678443328, 1908959.038112645 4209015.419926403, 1908965.1915459358 4209024.883638629, 1908975.2581780883 4209036.225003869, 1908980.4629270672 4209036.016597049, 1909007.1071328467 4209034.352679371, 1909016.7606349916 4209034.919710493, 1909024.550996706 4209035.952355326, 1909031.5013109792 4209037.328955434, 1909035.1367323042 4209038.971861686, 1909037.0882600944 4209041.055513415, 1909040.0491277953 4209040.171470221, 1909050.49 4209050.26, 1909052.71 4209052.91, 1909054.0395302926 4209057.5238685, 1909059.0599457663 4209074.940978213, 1909059.8992478326 4209077.1014267905, 1909060.1612702033 4209102.670813344, 1909058.9505085014 4209102.778707729, 1909053.1091031015 4209104.590084871, 1909062.3886510585 4209121.80904613, 1909075.659907371 4209130.08936244, 1909078.2605503933 4209140.649842728, 1909071.4688467681 4209167.719483337, 1909061.800990043 4209168.149789459, 1909072.1002528353 4209186.491088741, 1909081.329393536 4209192.511044207, 1909100.3800025797 4209193.809440955, 1909097.5700542724 4209208.7299117455, 1909093.3096980946 4209222.221052041, 1909096.250397685 4209234.499974187, 1909090.4894383147 4209237.719645942, 1909068.2394715697 4209224.240400097, 1909064.000124805 4209237.0303436555, 1909046.0192660177 4209239.208708564, 1908994.4096309254 4209271.789285874, 1909009.2006334555 4209279.038752938, 1909021.7314765204 4209291.971027237, 1909027.7807688336 4209308.5900421, 1909030.8494360358 4209323.79124115, 1909033.070076588 4209337.159774982, 1909040.3293119525 4209387.769956007, 1909039.209998584 4209398.629592917, 1909037.6387317057 4209406.089976574, 1909045.1901609204 4209412.331093927, 1909055.9990129387 4209431.260894533, 1909077.4092091017 4209427.290621386, 1909094.2296396247 4209455.239360878, 1909068.8804614486 4209470.138927122, 1909073.709001929 4209480.80077024, 1909081.1493083898 4209483.4598428365, 1909088.3096808037 4209496.420736025, 1909096.768832657 4209492.879376945, 1909108.319156974 4209502.069469315, 1909123.470881767 4209514.119428096, 1909142.5500945672 4209522.1492455425, 1909148.977980185 4209531.985823052, 1909178.9899951362 4209585.561734741, 1909212.9461959477 4209654.229178197, 1909214.3791132015 4209654.669585173, 1909226.87 4209672.47, 1909231.38 4209680.51, 1909254.24 4209689.44, 1909261.5785793364 4209716.380437271, 1909270.1704023888 4209747.85115701, 1909298.4312909334 4209768.09933592, 1909306.4499347948 4209779.409205423, 1909300.8608377464 4209786.33875661, 1909299.1302060666 4209801.870672954, 1909305.6008905645 4209822.610591547, 1909318.6491914229 4209850.8687592875, 1909333.5499134527 4209888.008968022, 1909345.6801026359 4209920.211472129, 1909351.7099317717 4209928.789766717, 1909365.1609620927 4209968.130824059, 1909371.3888146328 4209979.408617833, 1909371.630019318 4209986.261137084, 1909372.3110798562 4209987.2997180605, 1909373.4594874373 4209990.78002619, 1909378.5593726449 4209994.4106290545, 1909384.7094583388 4209997.608696425, 1909392.7886703818 4210003.2298277, 1909392.7599416678 4210019.429662694, 1909394.94255673 4210020.676375987, 1909407.5330711617 4209994.956795912, 1909412.9221031875 4209973.872990172, 1909413.8506911895 4209975.429855327, 1909439.130011705 4210019.721267251, 1909460.720408752 4210036.810849634, 1909464.649616233 4210066.979292277, 1909464.6906547458 4210067.231394246, 1909465.1500492576 4210069.499034077, 1909477.060822533 4210111.81904919, 1909450.9503462573 4210125.2707612915, 1909471.6305446245 4210160.418961682, 1909465.6710370127 4210172.939689596, 1909504.6497625303 4210229.720584387, 1909516.5288565834 4210235.110331292, 1909520.640706442 4210254.241026549, 1909533.1302179615 4210264.390843119, 1909526.0696128653 4210273.999135323, 1909526.6810803933 4210284.880740571, 1909526.3003623502 4210286.150759259, 1909577.7702803225 4210289.96067882, 1909583.6400560336 4210290.399881724, 1909609.6608256989 4210282.929282278, 1909621.2004833333 4210279.630781815, 1909653.2889363915 4210250.699277944, 1909654.6501119498 4210250.4238768555, 1909655.8706379863 4210254.9114220375, 1909663.686878702 4210268.742664691, 1909688.2712079976 4210288.604728813, 1909689.7304778218 4210307.180974152, 1909691.1804985618 4210306.750494712, 1909717.3991172814 4210298.980750461, 1909721.680133198 4210321.438915271, 1909722.5198302648 4210356.890520862, 1909722.8203983468 4210369.939577822, 1909706.1704078703 4210384.019551267, 1909691.6108280688 4210388.399439625, 1909681.5003531813 4210374.000266924, 1909670.679834554 4210377.939903927, 1909660.869561892 4210386.650675285, 1909647.3294483162 4210406.539144495, 1909641.3090695357 4210402.001036598, 1909635.9391812368 4210407.640921663, 1909616.2801641354 4210448.081455195, 1909599.5303903718 4210466.919108059, 1909618.38041094 4210481.990356239, 1909615.38936235 4210488.729801323, 1909620.5197161562 4210492.870658438, 1909619.4007330965 4210543.2397151785, 1909618.0992511204 4210546.069577264, 1909607.9597276181 4210541.1904149195, 1909568.8204466612 4210519.149967049, 1909569.1004159537 4210513.108628882, 1909572.3104080088 4210499.868647496, 1909579.0391999101 4210490.450933656, 1909581.6986537129 4210484.859600062, 1909589.0000227254 4210479.480399204, 1909589.9794534643 4210475.630257599, 1909589.559627316 4210467.009913628, 1909592.6594026964 4210450.559477378, 1909591.7003601901 4210447.390571313, 1909584.9395246243 4210449.550351083, 1909568.1808040768 4210457.269942773, 1909523.0309219207 4210456.750393764, 1909520.2290863236 4210463.620546082, 1909524.81039116 4210489.039288206, 1909499.0995916543 4210500.970054355, 1909486.3699747857 4210529.339259404, 1909439.9 4210525.83, 1909437.3538764578 4210528.018075163, 1909464.7062324174 4210559.718754807, 1909485.5756366032 4210599.531818937, 1909501.1935411282 4210624.30198985, 1909529.8233990371 4210664.561654657, 1909575.4242751126 4210721.4869989455, 1909583.9208802632 4210737.960856853, 1909591.5368991047 4210763.414664109, 1909596.1814778908 4210806.519259455, 1909599.32320406 4210824.987386766, 1909632.986399024 4210913.68038782, 1909663.8352863165 4210991.287968495, 1909715.4791565356 4211033.075589914, 1909744.9328578957 4211108.526417216, 1909821.5139380442 4211206.933827445, 1909914.8075715792 4211170.684755338, 1910079.042077326 4211107.343834384, 1910107.53820406 4211087.315050752, 1910149.7322672065 4211057.814838056, 1910158.314993962 4211055.074533418, 1910177.896264962 4211048.93441827, 1910191.2351939098 4211032.2436933825, 1910192.0698338524 4211026.983603681, 1910178.76 4211032.44, 1910172.39 4211034.35, 1910159.4214892967 4211037.4521641545, 1910157.711696893 4211033.322142451, 1910142.6998423163 4211032.090416833, 1910140.2899999295 4211028.480002147, 1910138.4399999296 4211024.470002142, 1910132.3099999293 4211011.240002145, 1910126.0053888594 4210996.249538593, 1910164.0199999295 4210983.590002145, 1910178.5899999295 4210978.730002145, 1910177.2882382076 4210971.708072271, 1910173.4399999294 4210950.950002148, 1910170.4399999294 4210934.080002141, 1910172.0699999295 4210933.790002147, 1910178.1099999296 4210932.580002145, 1910194.5199999295 4210929.430002142, 1910190.7399999297 4210895.450002148, 1910215.1399999291 4210892.130002146, 1910227.52 4210890.44, 1910238.63 4210889.61, 1910240.5037006137 4210889.504048497, 1910242.4855081227 4210875.3091798015, 1910243.281093133 4210868.120117213, 1910243.3165776543 4210867.834049529, 1910243.49852961 4210866.644184571, 1910243.7751873136 4210865.307750782, 1910245.1248802007 4210858.785805355, 1910241.3199999295 4210859.750002145, 1910219.4599999292 4210863.250002145, 1910216.3199999295 4210863.760002146, 1910216.0199999292 4210863.810002144, 1910214.1599999294 4210855.360002144, 1910211.2999999295 4210836.910002147, 1910209.6773152226 4210827.662074876, 1910212.2199999294 4210836.010002146, 1910213.1399999293 4210835.740002146, 1910216.0999999295 4210843.250002144, 1910216.9899999294 4210844.690002143, 1910218.0399999293 4210845.560002145, 1910219.5399999293 4210846.500002146, 1910221.0599999295 4210847.360002145, 1910222.9899999294 4210848.050002146, 1910225.1999999294 4210848.300002144, 1910227.1299999293 4210848.140002143, 1910228.8599999296 4210847.720002146, 1910230.3999999291 4210847.110002147, 1910231.7199999294 4210846.360002145, 1910232.7999999295 4210845.3100021435, 1910233.7799999292 4210843.850002148, 1910234.0699999295 4210842.430002139, 1910233.0699999295 4210839.710002146, 1910232.0614932845 4210837.94941432, 1910230.5299999292 4210834.830002147, 1910227.5499999293 4210828.940002145, 1910225.339999929 4210825.500002146, 1910214.0599999295 4210804.450002145, 1910205.9499999294 4210790.000002143, 1910200.1499999294 4210778.460002146, 1910193.6199999296 4210749.6000021435, 1910191.9799999294 4210739.940002147, 1910190.0199999295 4210734.7200021455, 1910189.4199999294 4210732.8100021435, 1910176.3499999295 4210735.900002145, 1910171.4599999294 4210715.030002146, 1910165.2099999294 4210688.320002144, 1910159.4799999294 4210664.650002146, 1910157.6599999294 4210657.610002147, 1910151.6099999296 4210637.240002144, 1910128.2194004944 4210642.048142527, 1910125.89266825 4210629.96106742, 1910101.4394565576 4210634.244875867, 1910096.1164776327 4210609.3299334245, 1910120.247322735 4210604.270602162, 1910122.995064403 4210553.845648989, 1910113.1776484228 4210556.19043792, 1910111.8899999293 4210551.070002146, 1910111.3599999296 4210546.8000021465, 1910113.1299999293 4210540.470002145, 1910112.4743395275 4210523.024965921, 1910120.838725819 4210494.909675256, 1910132.9199999294 4210490.420002146, 1910123.1599999294 4210464.900002145, 1910118.1699999294 4210467.040002147, 1910110.2799999295 4210445.630002146, 1910095.2699999295 4210448.330002146, 1910092.1699999294 4210440.270002146, 1910078.75 4210406.39, 1910062 4210360.1, 1910061.57 4210356.49, 1910055.7 4210342.43, 1910050.52 4210326.74, 1910042.64 4210308.33, 1910028.09 4210261.49, 1910020.47 4210236.94, 1910017.04 4210233.6, 1910015.24 4210227.98, 1910007.6 4210204.02, 1910004.0202257917 4210177.909544034, 1909998.84 4210153.53, 1909997.33 4210144.76, 1909993.06 4210120.03, 1909988.09 4210091.31, 1909985.93 4210078.8, 1909968.38 4209978.92, 1909961.48 4209939.66, 1909972.01 4209937.76, 1909985.61 4209935.42, 1910027.91 4209928.23, 1910018.14 4209898.03, 1910014.04 4209885.36, 1910010.14 4209873.32, 1910009.36 4209870.92, 1910007.23 4209864.31, 1910003.53 4209852.84, 1910001.34 4209846.23, 1909999.14 4209839.52, 1909991.53 4209827.16, 1909988.17 4209819.43, 1909976.62 4209791.42, 1909955.05 4209801.34, 1909949.19 4209803.48, 1909943.9762697832 4209805.3830833435, 1909942.31 4209800.35, 1909941.24 4209797.44, 1909935.2 4209781.08, 1909919.9160041786 4209739.710252889, 1909917.98 4209734.47, 1909909.81 4209712.67, 1909900.8 4209688.64, 1909899.52 4209685.22, 1909900.37 4209672.04, 1909900.74 4209666.31, 1909903.52 4209622.96, 1909900.79 4209590.83, 1909891.91 4209565.72, 1909869.2591785814 4209507.860461103, 1909863.4121061119 4209494.002777515, 1909844.478135813 4209478.968899546, 1909828.0707709715 4209444.457979253, 1909824.61 4209446.18, 1909782.68 4209467.1, 1909777.38 4209469.74, 1909764.2190010662 4209476.293129594, 1909762.43 4209472.75, 1909735.88 4209437.87, 1909694.4220372208 4209383.892157977, 1909697.2 4209381.74, 1909699.54 4209379.89, 1909702.23 4209377.77, 1909705.49 4209375.13, 1909707.08 4209373.84, 1909711.75 4209370.67, 1909712.06 4209370.46, 1909717.72 4209366.7, 1909725.69 4209362.1, 1909736.42 4209356.45, 1909741.5746649972 4209353.457779831, 1909741.3663203137 4209353.0440590745, 1909730.8213161542 4209333.917058092, 1909701.5409186708 4209349.574228197, 1909685.9 4209318.37, 1909683.22 4209312.97, 1909678.1451867018 4209302.659961906, 1909694.1276471196 4209295.8212416135, 1909681.6 4209263.24, 1909678.01 4209253.96, 1909673.99 4209241.52, 1909670.09 4209229.82, 1909668.9101781158 4209225.593941694, 1909656.3 4209230.15, 1909621.7694803746 4209242.66266135, 1909614.460215882 4209221.250120377, 1909633.713377534 4209195.191161833, 1909636.2299453279 4209190.709467031, 1909637.54 4209187.17, 1909638.37 4209184.68, 1909638.6 4209184.12, 1909629.6692296006 4209172.061484076, 1909624.320761199 4209157.16962647, 1909622.07 4209156.06, 1909610.5694627117 4209154.759123072, 1909601.6147474356 4209154.505742853, 1909601.59 4209130.01, 1909599.83 4209123.53, 1909595.72 4209111.53, 1909564.39 4209121.92, 1909554.17 4209125.3, 1909549.25 4209114.4, 1909547.65 4209108.38, 1909544.14 4209097.97, 1909552.84 4209095.21, 1909552.77 4209094.99, 1909547.29 4209078.24, 1909546.1589348505 4209081.744390794, 1909542.22 4209080.85, 1909525.0800778486 4209084.708944028, 1909524.1658999294 4209082.311202149, 1909511.3405361034 4209024.625751887, 1909529.07 4209020.54, 1909562.18 4209012.91, 1909562.82 4209012.76, 1909563.52 4209007.72, 1909563.89 4209001.7, 1909563.84 4208996.8, 1909563.88 4208994.83, 1909563.75 4208993.34, 1909563.56 4208992.23, 1909563.33 4208991.29, 1909563.05 4208990.4, 1909562.78 4208989.67, 1909562.36 4208988.7, 1909561.78 4208987.59, 1909558.82 4208984.11, 1909556.76 4208981.37, 1909553.12 4208982.05, 1909552.17 4208982.24, 1909551.04 4208982.46, 1909517.6 4208988.96, 1909516.69 4208986.48, 1909514.25 4208961.93, 1909511.72 4208952.93, 1909521.46 4208949.04, 1909518.15 4208947.44, 1909513.86 4208945.65, 1909511.34 4208944.71, 1909509.13 4208943.83, 1909507.68 4208943.23, 1909506.57 4208942.81, 1909505.37 4208942.32, 1909504.15 4208941.77, 1909502.34 4208940.72, 1909499.7692491033 4208938.633043553, 1909494.21 4208934.12, 1909487.128219819 4208928.327163073, 1909484.65 4208926.3, 1909482.66 4208922.78, 1909467.93 4208905.49, 1909461.05 4208897.91, 1909457 4208893.81, 1909452.83 4208889.57, 1909449.8007731629 4208886.775531172, 1909455.3 4208883.51, 1909456.41 4208883.03, 1909492.64 4208867.22, 1909510.7588312041 4208859.259356893, 1909501.91 4208833.62, 1909493.22 4208813.58, 1909491.65 4208810.04, 1909484.3 4208792.93, 1909478.16 4208778.63, 1909475.62 4208745.81, 1909458.14 4208721.11, 1909443.77 4208708.56, 1909441.72 4208702.83, 1909441.39 4208701.9, 1909439.41 4208696.35, 1909429.52 4208668.7, 1909399.957031867 4208683.724631609, 1909390.44 4208663.82, 1909387.55 4208659.08, 1909395.84 4208656.23, 1909398.64 4208655.3, 1909399.1 4208655.14, 1909409.24 4208651.73, 1909410.44 4208651.3, 1909411.41 4208651.01, 1909417.0919696945 4208649.726135092, 1909410.84 4208621.65, 1909405.29 4208610.34, 1909400.5188813936 4208603.040158115, 1909393.926793492 4208585.088297787, 1909408.1838953928 4208583.964974171, 1909401.8003220418 4208569.847201165, 1909409.6568597332 4208567.176830879, 1909401.7491194655 4208545.140955383, 1909377.71 4208481.26, 1909366.9655396403 4208448.958701285, 1909345.81 4208427.21, 1909325.76 4208403.98, 1909311.106885794 4208366.713920695, 1909340.1848520092 4208353.314704906, 1909317.1625804566 4208294.714380888, 1909308.2 4208270.62, 1909312.28 4208266.77, 1909316.54 4208263.06, 1909319.73 4208260.28, 1909326.22 4208256.17, 1909328.4 4208254.46, 1909331 4208253.21, 1909337.02 4208250.35, 1909342.3 4208247.84, 1909345.42 4208246.33, 1909348.87 4208245.18, 1909352.36 4208243.18, 1909356.72 4208241.03, 1909359.29 4208238.72, 1909360.8 4208237.13, 1909361.28 4208236.62, 1909361 4208236.34, 1909362.25 4208235.12, 1909366.1 4208231.36, 1909366.39 4208231.68, 1909366.55 4208231.85, 1909389.18 4208269.05, 1909406.09 4208298.75, 1909410.5 4208306.5, 1909416.69 4208318.01, 1909421.1 4208315.98, 1909438.3059720886 4208349.6854738, 1909443.75 4208360.35, 1909445.59 4208363.96, 1909451.76 4208376.04, 1909452.57 4208375.66, 1909456.85 4208378.31, 1909457.86 4208378.54, 1909459.04 4208378.91, 1909460.08 4208379.35, 1909460.78 4208379.74, 1909461.39 4208380.15, 1909461.7 4208380.39, 1909462.03 4208380.67, 1909462.36 4208380.97, 1909462.78 4208381.37, 1909463.17 4208381.75, 1909463.54 4208382.14, 1909463.93 4208382.55, 1909464.17 4208382.87, 1909464.35 4208383.19, 1909464.48 4208383.47, 1909464.62 4208383.84, 1909464.74 4208384.18, 1909464.84 4208384.54, 1909464.92 4208384.92, 1909464.98 4208385.28, 1909465 4208385.72, 1909464.98 4208386.14, 1909464.91 4208386.57, 1909464.67 4208387.66, 1909464.47 4208388.47, 1909464.24 4208389.42, 1909464.1 4208389.96, 1909462.93 4208394.27, 1909462.73 4208395.91, 1909462.74 4208397.54, 1909462.82 4208398.85, 1909462.91 4208399.76, 1909463.15 4208401.61, 1909463.41 4208403.39, 1909463.75 4208404.98, 1909464.13 4208406.38, 1909464.27 4208406.84, 1909468.96 4208420.52, 1909469.05 4208420.88, 1909472.47 4208433.86, 1909480.15 4208459.58, 1909481.52 4208463.12, 1909482.8 4208465.95, 1909492.34 4208489.06, 1909513.74 4208479.63, 1909514.79 4208483.65, 1909521.22 4208498.18, 1909530.4810291268 4208516.024772292, 1909524.27 4208518.88, 1909510.74 4208525.1, 1909508.09 4208526.32, 1909520.74 4208555.64, 1909521.16 4208556.63, 1909527.4 4208571.25, 1909534.68 4208588.07, 1909537.44 4208594.95, 1909537.8 4208594.89, 1909553.09 4208632.35, 1909556.53 4208640.96, 1909558.93 4208646.57, 1909560.21 4208649.56, 1909579.45 4208695.27, 1909579.52 4208695.44, 1909586.1 4208711.72, 1909589.42 4208720.87, 1909592.52 4208728.2, 1909595 4208734.06, 1909602.57 4208751.93, 1909602.71 4208752.27, 1909613.1545460434 4208781.873069875, 1909622.34 4208778.04, 1909625.907414592 4208776.556745176, 1909626.41 4208777.74, 1909628.63 4208783.25, 1909625.34 4208784.81, 1909626.67 4208787.8, 1909617.37 4208791.23, 1909624.89 4208808.49, 1909627.03 4208807.51, 1909658.63 4208856.34, 1909661.7 4208861.08, 1909662.52 4208862.35, 1909657.8431189524 4208865.704409004, 1909655.0097326715 4208867.470130739, 1909649.70051398 4208868.220291224, 1909645.2599982857 4208870.409281906, 1909641.8107113834 4208872.009104306, 1909635.7312545888 4208875.529819245, 1909630.8806778572 4208879.071090736, 1909626.5636996247 4208881.809271311, 1909638.8015357624 4208928.934385057, 1909618.9417114877 4208936.729230422, 1909622.3711304057 4208946.949201088, 1909629.0714322056 4208967.329247248, 1909633.1986452444 4208979.899488474, 1909638.3310483755 4208996.2539099, 1909645.7908346353 4208994.343277463, 1909648.1291832763 4208993.745148061, 1909666.9476048201 4208988.928199104, 1909687.6398241513 4208983.630581171, 1909697.8213735237 4208982.422067658, 1909698.03 4208984.99, 1909698.4 4208991.43, 1909699.92 4209023.76, 1909699.98 4209024.64, 1909700.05 4209025.61, 1909700.12 4209026.47, 1909700.2 4209027.35, 1909700.24 4209027.67, 1909700.36 4209028.55, 1909700.51 4209029.69, 1909700.61 4209030.44, 1909700.73 4209031.39, 1909700.84 4209032.18, 1909700.93 4209032.86, 1909701.04 4209033.63, 1909701.23 4209034.68, 1909701.53 4209036.28, 1909701.84 4209037.85, 1909702.02 4209038.76, 1909702.17 4209039.51, 1909702.33 4209040.23, 1909702.56 4209041.25, 1909702.86 4209042.56, 1909703.12 4209043.73, 1909703.27 4209044.39, 1909703.51 4209045.34, 1909703.62 4209045.74, 1909705.99 4209044.98, 1909717.63 4209072.49, 1909727.64 4209096.36, 1909730.36 4209103.65, 1909735.1 4209116.36, 1909728.52 4209118.75, 1909728.48 4209119.2, 1909732.58 4209125.53, 1909737.31 4209132.04, 1909740.96 4209136.23, 1909746.1 4209140.79, 1909753.96 4209143.3, 1909759.06 4209147.84, 1909761 4209148.51, 1909766.17 4209152.85, 1909766.78 4209152.64, 1909771.21 4209155.35, 1909778.39 4209160.32, 1909779.68 4209161.25, 1909791.1 4209170.04, 1909792.24 4209171.08, 1909797.58 4209175.84, 1909801.57 4209179.64, 1909804.68 4209182.96, 1909806.94 4209185.95, 1909808.85 4209189.25, 1909810.46 4209192.43, 1909812.16 4209196.7, 1909817.45 4209211.43, 1909825.23 4209233.22, 1909823.46 4209233.8, 1909824.05 4209235.6, 1909845.884241347 4209296.367348649, 1909846.09 4209296.94, 1909847 4209299.48, 1909851.85 4209313.84, 1909853.199336225 4209317.31096135, 1909864.29 4209345.84, 1909866.08 4209349.48, 1909867.89 4209353.1, 1909868.92 4209354.86, 1909870.23 4209357.1, 1909904.09 4209402.98, 1909905.26 4209404.56, 1909905.88 4209405.4, 1909919.52 4209425.91, 1909948.77 4209465.24, 1909954.07 4209471.21, 1909959.86 4209479.81, 1909982.17 4209508.64, 1909987.617359426 4209515.814950558, 1909993.1683315726 4209529.440121369, 1909998.619709749 4209542.820833225, 1910006.2803069283 4209556.600714861, 1910006.6694219655 4209557.419824237, 1910009.419140413 4209563.268830104, 1910012.6594832041 4209569.999892326, 1910015.421153143 4209577.180409812, 1910018.5892282377 4209585.738924993, 1910022.5198616437 4209596.559410967, 1910022.9609404164 4209597.768687271, 1910029.7795696892 4209615.369766692, 1910032.4204803247 4209622.439929282, 1910034.78 4209625.62, 1910035.25 4209626.84, 1910037.9 4209633.54, 1910027.54 4209638.83, 1910022.64 4209641.26, 1910020.4015941394 4209645.130045667, 1910023.7229999295 4209648.388602148, 1910026.127600973 4209651.78412973, 1910036.0443999295 4209665.787602149, 1910042.2526999293 4209671.78540215, 1910048.0584999295 4209674.582202147, 1910054.1390040005 4209675.022581333, 1910054.9143664434 4209684.242842874, 1910058.79 4209703.46, 1910058.26 4209705.72, 1910057.98 4209709.69, 1910058.1168524143 4209711.396378542, 1910058.62 4209717.67, 1910060.2 4209726.83, 1910065.02 4209754.46, 1910065.2510094247 4209757.07423925, 1910082.5496888433 4209816.378996997, 1910085.4 4209832.11, 1910092.78 4209875.16, 1910100.1060133136 4209916.256844408, 1910109.3110442816 4209974.680441649, 1910121.13 4210040.89, 1910135.3 4210125.21, 1910146.41 4210184.84, 1910154.5 4210226.61, 1910157.4 4210247.29, 1910160.1 4210262.19, 1910163.27 4210279.3, 1910166.81 4210297.56, 1910189.4840139374 4210428.470363462, 1910191.6810794994 4210440.552658837, 1910195.21425789 4210459.982622904, 1910198.3344754064 4210478.605032644, 1910201.1568646654 4210493.289970435, 1910202.9784941247 4210501.5691224225, 1910205.164024638 4210511.502173956, 1910209.6779999295 4210524.805802145, 1910216.1921999294 4210537.206602146, 1910216.5932999295 4210538.007002147, 1910235.3315999294 4210571.008802146, 1910284.7218222301 4210644.322555986, 1910334.5145999296 4210720.605002146, 1910357.4577999292 4210756.304802146, 1910364.6613363149 4210764.394149326, 1910373.8873698337 4210758.106928328, 1910380.8987030718 4210753.357452906, 1910381.0425398094 4210753.576958016, 1910381.2666103705 4210753.435097935, 1910392.2579083461 4210770.6924094325, 1910397.146092957 4210778.36871826, 1910403.868528363 4210788.411042768, 1910431.6137335165 4210829.769624298, 1910494.7980689185 4210926.339732482, 1910543.4349053928 4211000.095421334, 1910665.247549005 4211186.20430032, 1910691.0808274115 4211225.778898577, 1910725.5229168108 4211230.315118394, 1910725.32 4211229.61, 1910701.9799999292 4211194.330002144, 1910697.6999999292 4211187.480002144, 1910691.6499999291 4211177.810002146, 1910690.8199999293 4211178.3100021435, 1910677.5299999292 4211158.200002145, 1910679.1199999293 4211157.160002144, 1910674.6799999292 4211149.720002144, 1910672.8999999291 4211151.350002145, 1910664.5999999293 4211139.030002145, 1910665.9699999292 4211138.380002145, 1910640.2899999293 4211098.850002144, 1910573.9599999292 4210997.350002145, 1910531.4399999292 4210932.670002146, 1910520.8599999293 4210916.830002145, 1910496.3499999293 4210879.200002146, 1910473.9999999292 4210844.820002147, 1910470.3999999291 4210839.320002146, 1910446.4299999292 4210802.710002146, 1910424.629999929 4210769.700002145, 1910411.3499999295 4210749.570002145, 1910403.9477921654 4210738.282691041, 1910396.8767624204 4210743.006568342, 1910387.92 4210728.29, 1910374.89 4210707.91, 1910360.2 4210685.64, 1910352.97 4210674.83, 1910339.94 4210653.94, 1910325.97 4210633.7, 1910316.43 4210620.68, 1910315.81 4210618.74, 1910310.26 4210609.75, 1910307.09 4210605.85, 1910299.2 4210594.89, 1910293.5 4210586.37, 1910288.97 4210579.82, 1910287.78 4210577.8, 1910282.48 4210570.56, 1910272.96 4210556.38, 1910266.27 4210546.39, 1910246.3 4210519.63, 1910244 4210516.2, 1910235.31 4210498.42, 1910232.67 4210491.53, 1910230.88 4210485.91, 1910228.58 4210478.64, 1910227.28 4210473.58, 1910226.22 4210469.27, 1910223.44 4210446.59, 1910221.61 4210427.75, 1910218.54 4210408.97, 1910214.2 4210384.76, 1910209.8 4210357.76, 1910207.84 4210342.72, 1910206.9458721746 4210338.954996886, 1910204.14 4210327.14, 1910202.27 4210311.4, 1910199.49 4210296.07, 1910197.19 4210284.42, 1910191.73 4210257.16, 1910179.4835298166 4210178.613411213, 1910178.6887609493 4210173.515911079, 1910175.66 4210154.09, 1910166.64 4210099.37, 1910159.43 4210055.82, 1910153.67 4210021.03, 1910143.860585346 4209961.558056523, 1910143.31 4209958.22, 1910116.087830711 4209793.364009944, 1910109.17 4209751.47, 1910100.17 4209691.82, 1910098.9365445045 4209687.337247504, 1910097.08 4209680.59, 1910090.22 4209660.77, 1910070.01 4209602.83, 1910065.36 4209590.04, 1910039.12 4209518.68, 1910017.5 4209461.29, 1910012.9757426616 4209448.936001192, 1909986.2478737098 4209375.952517609, 1909947.555763089 4209271.385864223, 1909945.142705398 4209265.095201439, 1909928.37 4209221.37, 1909900.07 4209142.72, 1909887 4209106.98, 1909862.6 4209040.31, 1909806.28 4208886.34, 1909794.0695358422 4208853.957670146, 1909792.63 4208850.14, 1909752.6 4208741.26, 1909730.504450559 4208682.188280976, 1909724.9536836345 4208664.066659546, 1909720.545721665 4208631.415089403, 1909721.0354952172 4208602.028676273, 1909718.0968539042 4208581.947960635, 1909710.02 4208563.23, 1909708.09 4208563.67, 1909700.14 4208567.51, 1909696.17 4208569.66, 1909691.71 4208570.8, 1909681.09 4208572.34, 1909673.36 4208568.34, 1909673.09 4208568.02, 1909669.84 4208564.28, 1909669.73 4208564.13, 1909667.85 4208561.68, 1909667 4208560.58, 1909664.21 4208556.94, 1909645.62 4208533.03, 1909644.64 4208531.78, 1909643.07 4208529.76, 1909642.75 4208529.34, 1909640 4208525.75, 1909637.4 4208522.28, 1909633.87 4208517.77, 1909630.49 4208512.94, 1909627.06 4208507.91, 1909625.02 4208504.73, 1909620.38 4208498.57, 1909616.16 4208492.51, 1909613.59 4208488.37, 1909609.44 4208481.77, 1909607.48 4208479.33, 1909604.74 4208475.1, 1909597.93 4208459.89, 1909598.64 4208459.4, 1909596.48 4208455.43, 1909588.16 4208441.89, 1909589.63 4208440.98, 1909578.06 4208424.16, 1909579.71 4208423.1, 1909579.24 4208422.29, 1909562.95 4208393.99, 1909553.94 4208377.82, 1909553.58 4208377.16, 1909552.18 4208374.83, 1909550.26 4208371.62, 1909546.87 4208365.99, 1909543.27 4208359.95, 1909543.08 4208359.62, 1909537.7699538362 4208348.87065509, 1909539.5790580956 4208347.859360494, 1909531.0597562648 4208309.930500466, 1909549.97 4208300.33, 1909543.524779375 4208277.942915612, 1909638.5463911765 4208230.337262769, 1909572.3475866823 4208093.700167235, 1909533.5375496778 4208116.033850692, 1909533.85 4208096.71, 1909534.22 4208070.47, 1909534.55 4208058.23, 1909532.06 4208059.47, 1909522.51 4208062.45, 1909505.69 4208008.47, 1909495.69 4208011.78, 1909485.51 4208015.15, 1909474.61 4208018.76, 1909452.29 4208026.12, 1909448.66 4208027.3, 1909444.95 4208028.51, 1909438.91 4208030.48, 1909425.56 4208034.78, 1909419.01 4208013.54, 1909408.57 4207979.68, 1909399.25 4207948.6, 1909396.73 4207937.29, 1909395.47 4207926.56, 1909394.51 4207914.23, 1909393.04 4207900.94, 1909389.7 4207888.12, 1909391 4207852.94, 1909391.96 4207852.66, 1909394.526437462 4207851.9110453995, 1909444.08 4207837.45, 1909443.7941242468 4207836.589597248, 1909443.05 4207834.35, 1909439.83 4207835.02, 1909439.74 4207834.51, 1909438.78 4207832.09, 1909437.98 4207830.08, 1909435.93 4207828.76, 1909497.31 4207810.08, 1909469.03 4207717.15, 1909413.04 4207746.9, 1909403.48 4207712.8, 1909402.45 4207707.43, 1909405.8 4207705.66, 1909387.03 4207589.7, 1909384.88 4207582.34, 1909383.81 4207579.52, 1909382.83 4207576.93, 1909382.44 4207575.92, 1909384.05 4207575.29, 1909383.33 4207574.5, 1909320.72 4207514.84, 1909318.79 4207513, 1909291.35 4207482.92, 1909288.06 4207479.32, 1909259.8 4207450.79, 1909239.13 4207398.84, 1909220.62 4207352.36, 1909215.6450291418 4207339.523395581, 1909194.99 4207350.03, 1909186.07 4207354.56, 1909183.62 4207349.83, 1909179.68 4207343.27, 1909175.07 4207333.47, 1909174.84 4207333.09, 1909169.68 4207324.6, 1909166.84 4207318.23, 1909161.78 4207309.38, 1909158.8 4207304, 1909158.17 4207302.87, 1909153.06 4207294.77, 1909147.19 4207283.44, 1909145.42 4207280.69, 1909141.67 4207274.89, 1909135.69 4207266.96, 1909131.665126514 4207261.787609393, 1909130.99 4207260.92, 1909121.57 4207250.73, 1909102.28 4207230.55, 1909109.82 4207223.96, 1909110.3105576034 4207223.533707585, 1909112.11 4207221.97, 1909113.94 4207220.36, 1909117.2 4207217.52, 1909123.7140354342 4207212.052530578, 1909134.69 4207202.84, 1909166.27 4207170.69, 1909173 4207163.16, 1909177.3 4207158.4, 1909181.69 4207152.92, 1909188.42 4207143.43, 1909195.7 4207132.29, 1909199.88 4207127.03, 1909205.78 4207119.61, 1909212.81 4207110.68, 1909217.93 4207101.73, 1909220.24 4207096.94, 1909222.46 4207092.36, 1909225.08 4207086.93, 1909228.84 4207080.07, 1909231.51 4207074.68, 1909243.51 4207067.71, 1909259.869405558 4207051.057130962, 1909279.6384233008 4207029.813949942, 1909322.9115707797 4206983.203049064, 1909341.8551788789 4206966.377097459, 1909349.2729349164 4206962.93383314, 1909364.3920745126 4206960.255457626, 1909379.87 4206960.53, 1909382.5 4206962.96, 1909385.62 4206965.43, 1909386.95 4206965.83, 1909395.26 4206967.73, 1909399.27 4206967.41, 1909415.7 4206966.61, 1909427.68 4206968.42, 1909432.93 4206967.79, 1909433.11 4206967.77, 1909433.76 4206970.21, 1909446.5 4207007.41, 1909457.76 4207054.31, 1909452.07 4207055.72, 1909451.74 4207077.81, 1909452.65 4207084.3, 1909454.26 4207095.85, 1909449.11 4207096.56, 1909406.79 4207102.37, 1909428.48 4207147.15, 1909418.6 4207153.27, 1909418.67 4207153.4, 1909431.7 4207176.92, 1909460.21 4207228.39, 1909469.56 4207242.73, 1909477.51 4207254.4, 1909484.61 4207263.92, 1909487.79 4207269.44, 1909491.651561658 4207277.640923034, 1909492.72 4207279.91, 1909495.73 4207289.32, 1909498.42 4207296.1, 1909498.98 4207295.81, 1909500.78 4207294.7, 1909505.8 4207303.23, 1909507.95 4207307.59, 1909510.41 4207312.08, 1909514.41 4207322.38, 1909517.84 4207331.37, 1909520.07 4207341.52, 1909521.97 4207348.11, 1909523.35 4207354.13, 1909549.42 4207430.92, 1909571.52 4207476.02, 1909576.11 4207485.36, 1909556.14 4207496.14, 1909569.68 4207522.11, 1909583.03 4207547.7, 1909585.3 4207546.75, 1909592.74 4207543.66, 1909593.92 4207543.17, 1909611.25 4207567.42, 1909618.11 4207608.42, 1909618.66 4207611.73, 1909612.22 4207614.58, 1909628.8 4207650.51, 1909644.126866299 4207669.96731763, 1909656.89 4207686.17, 1909657.05 4207686.34, 1909659.3 4207684.9, 1909660.97 4207687.12, 1909662.23 4207688.79, 1909660.91 4207689.67, 1909663.2 4207693.1, 1909665.7 4207695.84, 1909672.53 4207703.35, 1909677.8 4207711.96, 1909683.06 4207720.57, 1909685.9 4207723.47, 1909705.3 4207743.32, 1909707.63 4207746.25, 1909722.04 4207764.4, 1909740.34 4207784.48, 1909741.33 4207783.8, 1909754.57 4207799.95, 1909759.68 4207809.79, 1909761.91 4207812.89, 1909765.32 4207817.55, 1909770.94 4207826.77, 1909774.38 4207833.05, 1909777.81 4207838.21, 1909784.85 4207847.75, 1909788.69 4207853.09, 1909791.27 4207855.89, 1909792.64 4207857.36, 1909797.91 4207862.98, 1909805.63 4207871.81, 1909809.73 4207876.67, 1909813.39 4207881, 1909818.19 4207886.96, 1909821.82 4207891.21, 1909826.08 4207896.92, 1909831.24 4207905.08, 1909835.05 4207910.78, 1909839.69 4207917.44, 1909842.66 4207922.73, 1909850 4207936.18, 1909858.19 4207947.62, 1909861.64 4207952.91, 1909863.39 4207955.6, 1909865.38 4207961.14, 1909871.05 4207971.28, 1909872.56 4207973.99, 1909874.73 4207977.9, 1909879.76 4207982.09, 1909884.96 4207988.84, 1909890.52 4207998.22, 1909897.21 4208008.88, 1909906.44 4208025.14, 1909915.82 4208041.39, 1909925.89 4208058.56, 1909935.33 4208076, 1909944.17 4208091.55, 1909952.68 4208108.16, 1909961.68 4208123.58, 1909970.9 4208139.46, 1909988.29 4208149.37, 1909994.31 4208152.8, 1910012.2 4208142.21, 1910025.19 4208134.52, 1910030.455059862 4208131.331246191, 1909969.6885146736 4208027.168008111, 1909976.1 4208023.2, 1909996.36 4208010.63, 1909975.56 4207975.04, 1909958.64 4207946.11, 1909946.93 4207926.59, 1909946.8 4207925.95, 1909943.88 4207923.88, 1909940.8 4207921.14, 1909939.82 4207919.68, 1909939.79 4207918.87, 1909939.95 4207918.34, 1909938.93 4207913.69, 1909936.05 4207900.02, 1909934.11 4207888.43, 1909932.38 4207876.79, 1909930.96 4207864.52, 1909929.15 4207842.38, 1909929.05 4207835.68, 1909929.17 4207834.14, 1909929.41 4207831.09, 1909922.22 4207818.86, 1909917.81 4207811.36, 1909913.8 4207804.3, 1909912.39 4207801.83, 1909890.27 4207761.43, 1909879.32 4207742.46, 1909876.03 4207738.25, 1909874.5 4207735.42, 1909867.5 4207721.46, 1909855.88 4207697.99, 1909845.96 4207678.01, 1909835.73 4207657.25, 1909834.14 4207655.33, 1909816.67 4207632.18, 1909809.38 4207622.36, 1909806.93 4207619.1, 1909804.44 4207615.11, 1909798.36 4207605.27, 1909791.74 4207592.77, 1909783.95 4207573.59, 1909774.18 4207548.5, 1909770.95 4207537.24, 1909766.73 4207523.89, 1909762.2 4207507.47, 1909761.12 4207503.22, 1909755.11 4207477.16, 1909752.94 4207467.68, 1909749.59 4207453.03, 1909744.71 4207431.59, 1909742.7 4207422.16, 1909738.83 4207405.37, 1909734.5 4207386.29, 1909732.49 4207376.99, 1909730.05 4207366.62, 1909727.81 4207352.22, 1909725.98 4207344.54, 1909724.5 4207336.77, 1909723.21 4207330.35, 1909722.4 4207325.79, 1909721.84 4207321.47, 1909721.2 4207306.29, 1909720.29 4207288.19, 1909719.92 4207276.27, 1909720.16 4207272.65, 1909722.24 4207259.92, 1909715.67 4207259.87, 1909713.71 4207265.77, 1909703.82 4207262.48, 1909698.02 4207258.87, 1909696.28 4207255.96, 1909689.1 4207250.9, 1909671.61 4207241.93, 1909659.61 4207231.9, 1909633.74 4207230.87, 1909626.53 4207227, 1909622.43 4207226.21, 1909616.34 4207223.05, 1909612.98 4207218.08, 1909607.25 4207216.14, 1909606.68 4207212.06, 1909604.17 4207210.04, 1909600.42 4207209.08, 1909599.5 4207208.84, 1909601.46 4207204.31, 1909599.39 4207197.18, 1909601.43 4207190.48, 1909601.85 4207185.06, 1909601.03 4207181.34, 1909597.3 4207175.52, 1909591.97 4207171.83, 1909583.23 4207167.99, 1909582.96 4207164.42, 1909583.4 4207162.42, 1909584.61 4207156.85, 1909584.95 4207151.31, 1909584.29 4207145.2, 1909587.94 4207139.52, 1909588.24 4207133.33, 1909586.73 4207125.74, 1909582.02 4207118.93, 1909581.25 4207113.09, 1909577.58 4207106.92, 1909572.76 4207103.04, 1909567.14 4207099.53, 1909568.91 4207097.25, 1909569.4 4207096.21, 1909575.33 4207083.72, 1909573.01 4207072.49, 1909570.36 4207064.33, 1909568.09 4207061.02, 1909562.23 4207057.8, 1909556.52 4207055.82, 1909549.26 4207052.61, 1909546.86 4207051.07, 1909541.79 4207046.34, 1909536.66 4207042.01, 1909532.58 4207038.32, 1909530.36 4207036.34, 1909526.84 4207033.2, 1909521.43 4207027.51, 1909517.12 4207021.28, 1909516.61 4207019.82, 1909509.9 4207016.5, 1909507.63 4207013.12, 1909507.18 4207012.98, 1909506.73 4207013.15, 1909504.54 4207011.86, 1909500.06 4207005.53, 1909485.16 4206985.4, 1909498.93 4206977.15, 1909484.18 4206946.87, 1909497.3 4206942.26, 1909493.25 4206919.31, 1909491.12 4206922.31, 1909490.96 4206922.41, 1909490.78 4206922.48, 1909490.68 4206922.5, 1909483.92 4206923.85, 1909484.2 4206922.67, 1909486.3787358168 4206910.892325646, 1909466.132631639 4206917.8985708915, 1909439.8143416247 4206932.939317496, 1909411.4221095084 4206934.86667236, 1909384.0558823268 4206939.665670565, 1909372.4221006974 4206941.532429783, 1909351.5406691767 4206940.205013606, 1909333.8090667943 4206945.830191564, 1909309.5857893522 4206970.555220636, 1909302.02 4206953.47, 1909302.8970143974 4206951.83851623, 1909308.988639569 4206956.05868598, 1909309.91 4206954.67, 1909329.45 4206925.66, 1909295.92 4206902.2, 1909278.83 4206913.31, 1909264.44 4206923.42, 1909261.88 4206924.46, 1909260.25 4206927.48, 1909282.2 4207006.75, 1909272.51 4207018.02, 1909260.06 4207014.2, 1909253.89 4207012.71, 1909248.36 4207011.86, 1909242.91 4207010.94, 1909237.5 4207010.24, 1909233.13 4207009.67, 1909229.73 4207009.37, 1909224.75 4207009.19, 1909221.69 4207009.17, 1909219.53 4207009.57, 1909217.69 4207010.35, 1909215.81 4207011.37, 1909214.37 4207012.35, 1909213.98 4207012.72, 1909213.32 4207013.38, 1909212.01 4207014.83, 1909210.2997546094 4207017.387864755, 1909210.3 4207017.39, 1909209.93 4207017.94, 1909215.54 4207027.92, 1909230.41 4207050.26, 1909232.3098294074 4207053.224756205, 1909222.7092275268 4207064.96026015, 1909220.41 4207068.71, 1909199.5808084894 4207105.706934016, 1909169.991237929 4207150.068867122, 1909134.422583862 4207188.249631437, 1909112.617418096 4207209.56764079, 1909095.2853015054 4207222.477647079, 1909084.11 4207202.45, 1909083.32 4207201.08, 1909079.4603878718 4207194.371370562, 1909076.14 4207188.6, 1909074.45 4207185.87, 1909074.051070844 4207185.251625944, 1909069.5334887495 4207178.2489902, 1909068.56 4207176.74, 1909065.39 4207171.7, 1909056.1403753464 4207157.909942741, 1909053.88 4207154.54, 1909048.39 4207144.34, 1909046.83 4207141.08, 1909046.03 4207138.88, 1909042.38 4207123, 1909041 4207117.37, 1909040.19 4207114.39, 1909039.95 4207113.49, 1909039.34 4207111.11, 1909039.13 4207110.28, 1909038.19 4207107.03, 1909037.1 4207103.62, 1909033.72 4207094.67, 1909032.6 4207092.5, 1909027.64 4207077.09, 1909026.11 4207072.41, 1909023.93 4207067.06, 1909021.67 4207061.3, 1909014.33 4207045.84, 1909012.24 4207041.1, 1909007.89 4207031.19, 1909003.44 4207021.09, 1909002.38 4207018.29, 1908999.56 4207010.27, 1908992.69 4206987.88, 1908991.17 4206984.68, 1908991.63 4206984.49, 1908988.01 4206972.51, 1908986.91 4206969.35, 1908985.4 4206965.8, 1908982.6 4206959.44, 1908979.95 4206953.91, 1908976.43 4206946.78, 1908973.76 4206940.56, 1908970.32 4206929.39, 1908962.65 4206904.38, 1908960.66 4206898.52, 1908956.48 4206889.67, 1908954.07 4206884.12, 1908952.96 4206880.52, 1908951.94 4206877.06, 1908950.86 4206873.02, 1908950 4206870.05, 1908948.98 4206866.7, 1908947.87 4206863.78, 1908946.03 4206858.92, 1908935.5 4206832.77, 1908930.07 4206817.33, 1908926.58 4206805.7, 1908923.24 4206793.19, 1908921.61 4206787.18, 1908909.39 4206748.63, 1908904.31 4206732.62, 1908901.02 4206722.11, 1908896.77 4206704.34, 1908895.91 4206700.78, 1908891.1 4206677.87, 1908889.85 4206672.23, 1908887.45 4206662.76, 1908884.0242422854 4206649.799151543, 1908878.68 4206629.58, 1908877.93 4206626.3, 1908873.59 4206607.31, 1908868.89 4206586.75, 1908864.06 4206565.65, 1908860.68 4206550.88, 1908858.649702301 4206540.6166493725, 1908867.5572848825 4206541.170393282), (1908320.753095891 4208350.659287893, 1908334.3352252112 4208344.001381364, 1908341.2320923542 4208341.483477485, 1908345.6110556195 4208340.826632996, 1908381.491185875 4208352.704570855, 1908390.6049031706 4208356.344584069, 1908397.6386129153 4208360.997232539, 1908403.6870559256 4208365.567775447, 1908404.81 4208364.23, 1908404.80989758 4208364.228519634, 1908404.810129571 4208364.228708251, 1908405.3306108671 4208364.230665347, 1908422.449860373 4208345.769945295, 1908468.8289081124 4208349.209225236, 1908479.729751409 4208360.679886107, 1908504.1498782183 4208417.170402121, 1908505.9406567863 4208417.189284044, 1908534.5809793035 4208407.49963353, 1908564.559999847 4208432.228935282, 1908569.2192207088 4208450.639854607, 1908577.6398144918 4208466.649273028, 1908569.7306081005 4208468.108809621, 1908568.8400415645 4208504.320441736, 1908597.170310868 4208518.180509986, 1908610.4794847246 4208510.46879895, 1908615.9500789843 4208516.619836149, 1908616.9005000787 4208522.370117438, 1908615.010706956 4208546.289197481, 1908614.0311979512 4208550.760639352, 1908611.4409381843 4208554.430825556, 1908606.1295680224 4208563.200078557, 1908603.6608057853 4208566.439729485, 1908589.259618671 4208577.639050969, 1908586.569347899 4208585.811145287, 1908586.5705492538 4208597.759374244, 1908583.0197452223 4208599.290229573, 1908578.030898814 4208601.209521586, 1908574.0501794326 4208601.9393127, 1908567.1501832427 4208602.779655349, 1908556.92020959 4208604.340228009, 1908543.5201726786 4208604.779702744, 1908537.289424285 4208605.488602572, 1908530.569109898 4208607.249086084, 1908526.589537573 4208608.619420225, 1908521.5999799562 4208610.409642318, 1908515.0593924709 4208612.440117377, 1908508.2713442845 4208614.321323122, 1908505.4298210419 4208615.50038277, 1908497.570803385 4208619.4992421055, 1908489.0406727884 4208627.07059704, 1908412.120602985 4208656.538889697, 1908367.8706004233 4208673.919992014, 1908370.1107508482 4208669.398846793, 1908373.4608246349 4208662.6801716965, 1908379.0306921971 4208598.039822808, 1908374.769436747 4208555.639640773, 1908367.5787115884 4208526.728820117, 1908363.5803613847 4208523.680790465, 1908349.4512183878 4208510.379485198, 1908334.6597238646 4208487.699901128, 1908326.829641417 4208471.431229565, 1908318.6993596656 4208453.70943353, 1908311.990558906 4208437.999908228, 1908304.4098265534 4208414.239599961, 1908307.508632315 4208405.020803411, 1908323.1005567056 4208391.351363699, 1908322.019339614 4208374.42018789, 1908321.5198943897 4208359.669488634, 1908320.928651493 4208352.720059338, 1908320.753095891 4208350.659287893), (1909276.1860107267 4207832.79629602, 1909286.0846999295 4207852.854402151, 1909288.4030999294 4207873.263402154, 1909284.9618935853 4207954.766270123, 1909287.8099444285 4207954.89044457, 1909287.7 4207955.77, 1909287.53 4207957.28, 1909287.37 4207958.84, 1909287.25 4207960.14, 1909287.18 4207960.89, 1909287.1 4207961.96, 1909287 4207963.17, 1909286.95 4207963.98, 1909286.92 4207964.84, 1909286.92 4207965.2, 1909286.97 4207965.93, 1909287.04 4207966.56, 1909287.13 4207967.21, 1909287.26 4207968.05, 1909287.41 4207968.9, 1909287.48 4207969.26, 1909287.56 4207969.66, 1909287.69 4207970.31, 1909287.87 4207971.15, 1909287.93 4207971.4, 1909288.13 4207972.11, 1909288.37 4207972.87, 1909288.6 4207973.59, 1909288.77 4207974.09, 1909288.99 4207974.72, 1909290.88 4207979.87, 1909293.15 4207985.61, 1909295.76 4207992.04, 1909297.31 4207995.78, 1909298.61 4207998.87, 1909301.09 4208004.75, 1909304.49 4208013.62, 1909305.93 4208017.26, 1909309.5 4208026.51, 1909312.47 4208035.13, 1909314.71 4208041.17, 1909316.53 4208046.34, 1909316.99 4208048.14, 1909318.29 4208054.56, 1909319.31 4208058.88, 1909319.91 4208061.45, 1909320.42 4208063.62, 1909320.91 4208065.66, 1909321.29 4208067.24, 1909321.68 4208069.34, 1909323.54 4208079.43, 1909323.76 4208082.14, 1909324.05 4208085.07, 1909324.2 4208086.64, 1909324.31 4208088.17, 1909324.48 4208091.66, 1909324.62 4208094.73, 1909324.88 4208101.68, 1909325.04 4208106.42, 1909325.2 4208110.25, 1909325.31 4208112.45, 1909325.4 4208114.03, 1909325.5 4208115.64, 1909325.58 4208116.68, 1909325.68 4208118, 1909325.8 4208119.45, 1909326 4208121.56, 1909326.19 4208123.22, 1909326.35 4208124.57, 1909326.68 4208127.14, 1909326.99 4208129.32, 1909327.18 4208130.56, 1909327.39 4208131.68, 1909332.78 4208154.17, 1909334.4 4208162.05, 1909336.2 4208169.24, 1909337.86 4208175.47, 1909339.27 4208180.21, 1909340.38 4208183.85, 1909340.82 4208185.26, 1909341.38 4208186.98, 1909341.83 4208188.27, 1909342.08 4208188.98, 1909342.51 4208190.15, 1909343.07 4208191.61, 1909343.71 4208193.16, 1909344.12 4208194.12, 1909344.46 4208194.9, 1909345.39 4208196.98, 1909340.44 4208199.25, 1909274.2654127695 4208248.985046456, 1909253.5608348146 4208201.145284553, 1909252.34 4208193.51, 1909243.64 4208179.28, 1909243.72 4208176.38, 1909237.7 4208162.1, 1909234.95 4208155.57, 1909231.88 4208148.29, 1909173.36 4208182.14, 1909133.35 4208205.28, 1909137.51 4208219.68, 1909138.89 4208224.44, 1909166.92 4208209.95, 1909172.99 4208223.61, 1909181.81 4208243.47, 1909193.79 4208270.7, 1909234.4 4208244.08, 1909243.42 4208262.78, 1909250.14 4208276.7, 1909254.9849407251 4208296.1617054045, 1909248.729761796 4208303.376936156, 1909193.43 4208313.88, 1909158.5663181643 4208321.392989574, 1909130.0682530385 4208329.788454831, 1909130.0682530382 4208329.788454831, 1909128.23 4208330.33, 1909126.955481908 4208330.566583174, 1909126.465708356 4208328.117715414, 1909122.4250765508 4208318.403873296, 1909119.404806312 4208312.424554513, 1909112.238631472 4208303.308091584, 1909110.0802789421 4208300.990556808, 1909106.6401262633 4208297.128027275, 1909103.9203208485 4208293.219256436, 1909098.7526881956 4208287.037958726, 1909093.854952674 4208279.201581892, 1909089.5286196298 4208270.140771177, 1909079.4066328853 4208250.38657124, 1909076.3047337215 4208244.590917538, 1909069.8560486182 4208233.815899391, 1909064.8766841711 4208225.6530068545, 1909061.9239683684 4208219.860059661, 1909059.1598855841 4208215.610105393, 1909055.3309287361 4208209.179131039, 1909049.4813895915 4208199.360468096, 1909047.308565628 4208194.85090783, 1909044.4098339055 4208188.800342019, 1909039.589350806 4208178.400887667, 1909035.9999992875 4208167.149123241, 1909035.5301570417 4208165.290328228, 1909035.200667101 4208163.98911221, 1909033.9508928857 4208157.789456336, 1909033.8416119625 4208157.248984752, 1909030.29 4208158.12, 1909017.42 4208165.18, 1908989.96 4208170.42, 1908968.08 4208178.43, 1908963.41 4208180.38, 1908943.73 4208135.9, 1908922.4581682023 4208093.623666881, 1908945.7260842237 4208077.54, 1908945.9077722174 4208077.594572407, 1908945.8798337323 4208077.541160071, 1908941.0994545538 4208068.399948383, 1908936.1807635284 4208058.980305982, 1908918.0573910044 4208070.448226298, 1908898.726822768 4208046.748209685, 1908872.41 4208036.95, 1908873.09 4208023.33, 1908878.75 4208016.91, 1908856.67 4207990.97, 1908867.36 4207978.79, 1908874.45 4207970.9, 1908892.87 4207951.52, 1908958.9972526045 4207913.118666917, 1908987.1960094464 4207887.000369958, 1909030.946216443 4207871.559883509, 1909121.3493392114 4207868.923919419, 1909212.9945781087 4207860.044717782, 1909225.5624707777 4207858.839311736, 1909262.2558950025 4207855.325409711, 1909273.6792181425 4207849.500309738, 1909274.5 4207833.54, 1909276.1860107267 4207832.79629602))','ZO32133','"lib_modif"=>"N", "lib_code_insee"=>"38187 / 38436 / 38524 / 38545", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UE4','Activités tertiaires et technologiques','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UE4.pdf','2019-12-20','SRID=3945;POLYGON ((1913774.7230286992 4220229.085380666, 1913771.0619379971 4220218.385514694, 1913768.8107127736 4220219.296031049, 1913723.1277695338 4220237.416879096, 1913691.0923034803 4220250.182211117, 1913683.4313702132 4220253.47348696, 1913684.6894067351 4220297.253157922, 1913685.760164934 4220320.006769645, 1913703.83 4220315.74, 1913704.56 4220315.52, 1913804.77 4220284.95, 1913804.49 4220284.2, 1913804.19 4220283.41, 1913799.12 4220269.83, 1913794.03 4220271.68, 1913784.56 4220246.09, 1913781.71 4220247.25, 1913777.93 4220237.44, 1913774.7440507195 4220229.0771951545, 1913774.7230286992 4220229.085380666))','ZO32132','"lib_modif"=>"N", "lib_code_insee"=>"38151", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UC3','Habitat collectif en R+3','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UC3.pdf','2019-12-20','SRID=3945;POLYGON ((1910502.57 4210000.48, 1910503.38 4210000.01, 1910555.15 4209970.18, 1910553.01 4209966.23, 1910541.29 4209945.61, 1910529.74 4209924.91, 1910467.21 4209961.24, 1910464.31 4209962.96, 1910433.52 4209980.81, 1910408.34 4209995.47, 1910407.52 4209995.89, 1910405.7687276832 4209997.143320188, 1910420.1450082487 4210013.145802147, 1910437.432217208 4210038.004937407, 1910440.22 4210036.08, 1910446.02 4210032.77, 1910461.64 4210023.86, 1910463.19 4210022.97, 1910466.72 4210020.97, 1910470.99 4210018.54, 1910475.49 4210015.97, 1910476.96 4210015.13, 1910480.67 4210012.97, 1910485.01 4210010.45, 1910489.46 4210007.86, 1910494.53 4210005, 1910498.94 4210002.52, 1910502.57 4210000.48))','ZO33754','"lib_modif"=>"N", "lib_code_insee"=>"38545", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UE1','Activités productives et artisanales','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UE1.pdf','2019-12-20','SRID=3945;POLYGON ((1910513.7332512836 4226343.0472618705, 1910513.7332512839 4226343.0472618705, 1910515.3299999305 4226341.420002103, 1910513.7332512836 4226343.0472618705))','ZO34744','"lib_modif"=>"N", "lib_code_insee"=>"38474", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UV','Parcs urbains','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UV.pdf','2019-12-20','SRID=3945;POLYGON ((1910026.127600973 4209651.78412973, 1910020.94 4209653.24, 1910016.75 4209654.47, 1909979.73 4209665.38, 1909962.28 4209670.52, 1909928.12 4209680.59, 1909922 4209682.39, 1909905.99 4209687.11, 1909900.8 4209688.64, 1909909.81 4209712.67, 1909917.98 4209734.47, 1909919.9160041786 4209739.710252889, 1909981.51 4209719.88, 1909995.95 4209715.37, 1909998.1069678646 4209721.512546281, 1910058.79 4209703.46, 1910054.9143664434 4209684.242842874, 1910054.1390040005 4209675.022581333, 1910048.0584999295 4209674.582202147, 1910042.2526999293 4209671.78540215, 1910036.0443999295 4209665.787602149, 1910026.127600973 4209651.78412973))','ZO34137','"lib_modif"=>"N", "lib_code_insee"=>"38545", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','NLj2','STECAL en zone naturelle pour les jardins partagés','N',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/NL.pdf','2019-12-20','SRID=3945;POLYGON ((1918187.4099745138 4228490.224958913, 1918190.76 4228491.61, 1918212.46 4228500.75, 1918213.22 4228498.99, 1918226.81 4228504.87, 1918226.18 4228506.42, 1918232.6622426938 4228509.073353227, 1918251.27 4228516.69, 1918260.21 4228520.79, 1918262.13 4228521.73, 1918282.31 4228528.92, 1918287.86 4228531.37, 1918295.52 4228514.06, 1918298.85 4228506.62, 1918299.54 4228505.34, 1918311.001308537 4228478.955546248, 1918207.2703749563 4228437.135169864, 1918200.8469838123 4228452.715310086, 1918194.970264255 4228451.485299015, 1918190.42 4228463.72, 1918183.3354077344 4228481.528632245, 1918180.94 4228487.55, 1918187.4099745138 4228490.224958913))','ZO33433','"lib_modif"=>"N", "lib_code_insee"=>"38229", "lib_modif_comment"=>NULL',1);
INSERT INTO urba_plui_ecriture.zoneurba (idurba,libelle,libelong,typezone,nomfic,urlfic,datevalid,geom,lib_idzone,lib_hstore,lib_id_version) VALUES
     ('MJ3_PH1_ZON_050_09','UD2','Pavillonnaire en densification','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD2.pdf','2019-12-20','SRID=3945;POLYGON ((1908247.02 4211283.7, 1908242.67 4211282.42, 1908239.33 4211281.6, 1908230.18 4211278.91, 1908219.81 4211287.9, 1908208.91 4211297.35, 1908202.91 4211288.95, 1908197.59 4211281.51, 1908194.9 4211277.84, 1908177.11 4211288.64, 1908172.68 4211291.3, 1908175.91 4211295.76, 1908179.77 4211302.03, 1908176.77 4211304.42, 1908181.34 4211316.02, 1908191.52999993 4211322.190002146, 1908203.21999993 4211329.440002146, 1908215.47999993 4211321.140002145, 1908247.02 4211283.7))','ZO33434','"lib_modif"=>"N", "lib_code_insee"=>"38436", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','N','Naturelle','N',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/N.pdf','2019-12-20','SRID=3945;POLYGON ((1907706.52 4204367.78, 1907715.82 4204391.94, 1907727.18 4204405.32, 1907740.62 4204413.73, 1907749.99 4204414.31, 1907759.54 4204412.36, 1907775.58 4204403.15, 1907777.317594027 4204399.560245307, 1907777.29 4204399.55, 1907777.064234509 4204399.503920434, 1907768.03 4204397.66, 1907759.91 4204397.87, 1907751.36 4204399.62, 1907745.5 4204398.01, 1907745.37 4204365.59, 1907702.73 4204359.67, 1907701.3116957806 4204363.926404084, 1907706.52 4204367.78))','ZO33551','"lib_modif"=>"N", "lib_code_insee"=>"38187", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UV','Parcs urbains','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UV.pdf','2019-12-20','SRID=3945;POLYGON ((1911926.13 4225463.9, 1911933.98 4225455.89, 1911937.3 4225452.48, 1911938.38 4225451.39, 1911939.24 4225450.52, 1911951.42 4225438.1, 1911938.09 4225429.22, 1911935.3 4225427.35, 1911928.25 4225422.61, 1911919.5 4225416.76, 1911905.52 4225407.42, 1911901.57 4225404.78, 1911900.99 4225404.38, 1911897.46 4225402.16, 1911894.9381237673 4225400.75602227, 1911870.01709993 4225417.351002105, 1911868.1736228028 4225418.6939672325, 1911873.69 4225423.2, 1911875.75 4225424.73, 1911879.01 4225427.16, 1911901.23 4225443.67, 1911906.56 4225447.61, 1911913.26 4225452.6, 1911913.52 4225452.36, 1911920.9 4225459.13, 1911924.16 4225462.1, 1911925.77 4225463.58, 1911926.13 4225463.9))','ZO33211','"lib_modif"=>"N", "lib_code_insee"=>"38169", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','Ns','Naturelle avec secteurs à protéger (stricts)','N',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/N.pdf','2019-12-20','SRID=3945;POLYGON ((1918578.7652758025 4222725.136619218, 1918572.72 4222722.65, 1918565.19 4222719.42, 1918561.41 4222716.99, 1918559.53 4222715.78, 1918545.36 4222706.73, 1918529.456684847 4222731.414102854, 1918540.5772104766 4222737.892078949, 1918559.076658372 4222748.169550004, 1918559.7257618073 4222748.49410172, 1918565.7840605334 4222751.090515459, 1918570.0032328605 4222752.605090139, 1918573.6814856585 4222753.686929197, 1918577.3597384563 4222754.44421654, 1918580.4970717253 4222754.9851360675, 1918582.1198303127 4222755.20150388, 1918583.3098532767 4222732.699251469, 1918578.3333936087 4222730.319205541, 1918578.7652758025 4222725.136619218))','ZO34045','"lib_modif"=>"N", "lib_code_insee"=>"38421", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','A','Agricole','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1904467.542315051 4203653.409647376, 1904482.0229766187 4203697.825009684, 1904488.2406849584 4203711.583343032, 1904505.9677683099 4203731.691676386, 1904514.037559985 4203736.189593057, 1904513.31 4203738.18, 1904491.54 4203762.84, 1904474.99 4203781.59, 1904463.29 4203826.18, 1904450.13 4203876.36, 1904434.61 4203935.51, 1904343.41 4203893.48, 1904329.73 4203835.29, 1904344.26 4203840.25, 1904346.69 4203807.1, 1904343.9 4203784.57, 1904296.88 4203782.1, 1904296.03 4203769.71, 1904294.69 4203750.01, 1904293.91 4203738.48, 1904289.26 4203728.86, 1904268.99 4203686.91, 1904349.26 4203661.06, 1904393.15 4203615.86, 1904413.14 4203546.37, 1904430.1 4203545.44, 1904453.95 4203556.4, 1904519.95 4203559, 1904544.75 4203574.63, 1904540.94 4203641.48, 1904469.05 4203653.18, 1904467.542315051 4203653.409647376))','ZO33037','"lib_modif"=>"N", "lib_code_insee"=>"38187", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','AUD3','Zone à urbaniser de type UD3','AUc',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/AUD3.pdf','2019-12-20','SRID=3945;POLYGON ((1916722.5799999272 4211633.680002145, 1916725.64 4211661.64, 1916725.94 4211664.99, 1916727.76 4211681.5, 1916728.073778597 4211684.346420128, 1916718.95 4211684.57, 1916717.8499999272 4211686.690002143, 1916721.1299999272 4211709.720002143, 1916724.5299999272 4211734.200002146, 1916725.0899999272 4211737.800002144, 1916728.229999927 4211758.860002146, 1916728.219999927 4211759.100002143, 1916749.5699999272 4211760.990002144, 1916759.61 4211761.9, 1916750.15 4211682.84, 1916774.959999927 4211681.060002146, 1916776.3599999272 4211679.240002145, 1916782.2999999272 4211692.300002144, 1916794.8399999272 4211686.890002144, 1916810.1199999272 4211680.410002146, 1916821.229999927 4211675.080002143, 1916839.939999927 4211665.870002144, 1916844.15 4211657.49, 1916841.6099999272 4211651.430002145, 1916836.479999927 4211638.330002144, 1916814.1599999273 4211635.350002144, 1916764.9999999271 4211628.610002146, 1916722.5799999272 4211633.680002145))','ZO33363','"lib_modif"=>"N", "lib_code_insee"=>"38279", "lib_modif_comment"=>"Arbitrage le 11/04 avec les elus"',1),
     ('MJ3_PH1_ZON_050_09','UE1','Activités productives et artisanales','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UE1.pdf','2019-12-20','SRID=3945;POLYGON ((1911118.2044999301 4225005.953802107, 1911122.48289993 4224978.534002107, 1911130.55529993 4224940.7040021075, 1911146.7232576264 4224854.641692309, 1911136.7544703048 4224853.719428763, 1911087.75029993 4224849.185802106, 1911081.4275242477 4224848.2796979435, 1911080.7302259167 4224853.824299306, 1911079.5748309158 4224860.409480308, 1911078.2782178929 4224864.76323495, 1911077.7695398403 4224866.644612747, 1911076.183756062 4224872.619597968, 1911073.308303122 4224879.876875451, 1911066.6085373356 4224896.83272873, 1911062.0162597192 4224908.493956457, 1911056.7644214272 4224921.81636037, 1911030.2063981 4224988.609958035, 1911028.2059238611 4224994.381231074, 1911033.3427999301 4224994.520802106, 1911118.2044999301 4225005.953802107))','ZO33364','"lib_modif"=>"N", "lib_code_insee"=>"38169", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UD4','Pavillonnaire au développement limité','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD4.pdf','2019-12-20','SRID=3945;POLYGON ((1917810.4499999266 4210146.170002149, 1917809.67 4210145.92, 1917807.75 4210145.33, 1917749.15 4210122.75, 1917746.35 4210121.67, 1917737.98 4210118.45, 1917723.0215613071 4210113.690498952, 1917727.0349892697 4210124.563997885, 1917729.9382043164 4210132.743696255, 1917733.1114903353 4210141.400144093, 1917735.6449182977 4210150.9240866015, 1917736.7414903352 4210158.077283904, 1917737.113959979 4210162.205966282, 1917737.1867936708 4210166.1723720925, 1917736.9034899091 4210171.1585182985, 1917736.3525688604 4210176.671767262, 1917735.5871282776 4210181.772843682, 1917735.0150247554 4210185.966148356, 1917751.22 4210180.98, 1917755.52 4210179.41, 1917763.2199999266 4210175.0000021495, 1917767.6899999266 4210172.430002147, 1917786.9599999266 4210162.310002148, 1917795.5399999267 4210157.820002149, 1917793.0499999267 4210156.460002149, 1917797.1599999268 4210153.77000215, 1917810.4499999266 4210146.170002149))','ZO32964','"lib_modif"=>"N", "lib_code_insee"=>"38445", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UD4','Pavillonnaire au développement limité','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD4.pdf','2019-12-20','SRID=3945;POLYGON ((1917891.906511162 4222577.022610991, 1917896.342051301 4222576.157139745, 1917895.692947866 4222572.803438664, 1917896.4502352064 4222562.093231987, 1917897.315706453 4222550.301186253, 1917897.7484420766 4222547.380220796, 1917899.1548328523 4222537.860037082, 1917900.3448558163 4222527.582566028, 1917900.6694075337 4222520.442428245, 1917900.6694075335 4222516.872359354, 1917900.8857753454 4222515.682336389, 1917902.1839822154 4222509.840405474, 1917902.292166121 4222508.10946298, 1917910.946878587 4222510.056773286, 1917917.7624646537 4222509.948589381, 1917926.4171771193 4222509.948589382, 1917929.1217747652 4222509.948589382, 1917931.6100045992 4222509.948589381, 1917941.6711078407 4222509.840405474, 1917954.6531765393 4222509.515853755, 1917952.1649467056 4222457.154843339, 1917932.23 4222431.87, 1917929.030891664 4222428.827115958, 1917929.0135908592 4222428.810660015, 1917918.6279359001 4222447.31010791, 1917866.8078450111 4222451.312912425, 1917862.69685659 4222580.484495978, 1917891.906511162 4222577.022610991))','ZO32699','"lib_modif"=>"N", "lib_code_insee"=>"38421", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','NLv4','STECAL en zone naturelle réservés aux gens du voyage','N',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/NL.pdf','2019-12-20','SRID=3945;POLYGON ((1916820.2309074767 4225543.638473004, 1916820.0261005715 4225543.6113509685, 1916796.5786500007 4225550.611124056, 1916786.475113495 4225553.627335252, 1916784.1803050833 4225550.3552409485, 1916767.8164815854 4225558.064027956, 1916759.7989318178 4225562.654955714, 1916752.1089408959 4225567.409298642, 1916747.6557971467 4225569.992728764, 1916745.8912904155 4225571.0163830845, 1916739.5102243891 4225574.951026583, 1916736.8917907558 4225575.935597982, 1916741.3219251574 4225587.227429394, 1916749.2988709288 4225608.396984242, 1916751.0034972574 4225612.920793428, 1916790.6081465136 4225598.970457579, 1916803.2913428464 4225594.605756881, 1916807.3011342338 4225593.225857144, 1916812.865268975 4225591.092714456, 1916809.4195576666 4225582.255610928, 1916812.9869068363 4225580.784476068, 1916832.4937541094 4225572.740070639, 1916845.3094197155 4225571.821298038, 1916869.4891427413 4225570.087820611, 1916867.5950332787 4225547.73293833, 1916867.1729044293 4225542.750839394, 1916839.3426179653 4225542.611912477, 1916822.4819927276 4225543.936578261, 1916820.2309074767 4225543.638473004))','ZO32889','"lib_modif"=>"N", "lib_code_insee"=>"38516", "lib_modif_comment"=>NULL',1);
INSERT INTO urba_plui_ecriture.zoneurba (idurba,libelle,libelong,typezone,nomfic,urlfic,datevalid,geom,lib_idzone,lib_hstore,lib_id_version) VALUES
     ('MJ3_PH1_ZON_050_09','UE2v','Activités de production industrielle avec secteurs réservés aux gens du voyage','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UE2.pdf','2019-12-20','SRID=3945;POLYGON ((1913261.9765194212 4220982.462143548, 1913232.3200733576 4221021.211544078, 1913201.1527857685 4221055.495560425, 1913167.907679007 4221086.143393221, 1913129.7277517102 4221114.193952052, 1913088.9505504481 4221136.270780761, 1913067.652903929 4221147.958513606, 1913051.4877010656 4221154.158865389, 1913060.3262188346 4221187.2431411445, 1913070.4120813522 4221192.662099502, 1913077.2631578336 4221196.335885737, 1913088.9659458844 4221202.004081376, 1913095.6762491465 4221205.3699172605, 1913098.6717660185 4221206.876638746, 1913099.3308600592 4221207.208152071, 1913099.3414355265 4221207.2109835055, 1913099.8625626036 4221207.36927827, 1913117.3318691237 4221209.051089242, 1913165.6474788547 4221213.314379912, 1913208.239968145 4221217.1393963015, 1913214.8451715293 4221193.605434163, 1913227.1728485215 4221152.870501492, 1913238.9645395575 4221120.175358165, 1913251.2922165496 4221090.16014462, 1913263.0839075856 4221063.896832767, 1913271.9078475055 4221046.282436611, 1913263.2051969606 4220990.180795716, 1913261.9765194212 4220982.462143548))','ZO32257','"lib_modif"=>"N", "lib_code_insee"=>"38151 / 38185", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UE1','Activités productives et artisanales','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UE1.pdf','2019-12-20','SRID=3945;POLYGON ((1911568.13200488 4219376.814681104, 1911567.727198246 4219375.749044547, 1911564.02 4219365.99, 1911560.37 4219354.04, 1911556.22 4219338.88, 1911554.2 4219330.24, 1911550.65 4219313.59, 1911548.12 4219297.9, 1911547.02 4219288.8, 1911545.6199999298 4219274.520002121, 1911538.4699999297 4219283.56000212, 1911515.6299999296 4219307.950002121, 1911494.4599999296 4219330.560002121, 1911483.6399999296 4219342.110002121, 1911476.8599999298 4219349.35000212, 1911466.1499999296 4219362.580002122, 1911438.399071589 4219398.393894357, 1911444.4867235068 4219397.778849662, 1911557.228241163 4219378.67419238, 1911566.56797456 4219377.081408456, 1911568.13200488 4219376.814681104))','ZO32259','"lib_modif"=>"N", "lib_code_insee"=>"38151 / 38317", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UV','Parcs urbains','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UV.pdf','2019-12-20','SRID=3945;POLYGON ((1913410.5812941622 4218594.054417831, 1913412.7 4218596.45, 1913413.67 4218597.52, 1913450.97 4218639.4, 1913453.9 4218636.74, 1913475.02 4218660.26, 1913483.95 4218660.62, 1913491.63 4218669.29, 1913492.73 4218668.4, 1913514.9267144368 4218693.116341481, 1913514.93 4218693.12, 1913521.8 4218686.8, 1913527.6675006077 4218681.232298695, 1913526.1162999289 4218673.909602124, 1913525.412099929 4218670.207802123, 1913522.090599929 4218647.297202124, 1913519.2786999287 4218635.793402125, 1913514.065799929 4218624.491002124, 1913502.848999929 4218612.494002123, 1913491.632899929 4218602.198202123, 1913474.476030669 4218589.845346153, 1913473.3110999288 4218589.006602123, 1913462.698399929 4218581.611202122, 1913458.4636524424 4218575.503878619, 1913458.12 4218582.47, 1913451.5126606675 4218579.046550876, 1913443.158564694 4218573.82905983, 1913438.5186658239 4218575.706878011, 1913437.6664717982 4218576.166069544, 1913429.299903045 4218581.6054385705, 1913410.5812941622 4218594.054417831))','ZO34112','"lib_modif"=>"N", "lib_code_insee"=>"38068 / 38151 / 38317", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UZ1','Equipements collectifs et touristiques','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UZ1.pdf','2019-12-20','SRID=3945;POLYGON ((1918409.568618937 4212172.355772729, 1918412.15 4212179.97, 1918422.65 4212202.3, 1918433.4 4212225.17, 1918441.54 4212242.5, 1918446.97 4212254.14, 1918451.74 4212264.36, 1918458.97 4212279.84, 1918466.22 4212295.39, 1918472 4212307.77, 1918474.02 4212312.08, 1918478.98 4212322.7, 1918483.81 4212333.06, 1918498.74 4212325.79, 1918513.67 4212318.5, 1918520.61 4212315.12, 1918528.37 4212311.19, 1918542.46 4212304.08, 1918549.5 4212300.51, 1918559.32 4212295.56, 1918551.62 4212236, 1918542.99 4212169.23, 1918541.46 4212169.25, 1918540.63 4212163.34, 1918539.2459927457 4212153.990782585, 1918539.1184985642 4212152.854529309, 1918473.594321784 4212161.241565378, 1918454.7137088764 4212164.174476122, 1918431.734829844 4212167.744010729, 1918409.568618937 4212172.355772729))','ZO33518','"lib_modif"=>"N", "lib_code_insee"=>"38562", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UD3','Pavillonnaire en évolution modérée','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD3.pdf','2019-12-20','SRID=3945;POLYGON ((1910260.4819905516 4213833.099922594, 1910225.04 4213838.34, 1910209.69710453 4213840.577506249, 1910198.5944604452 4213842.1966423225, 1910199.5999999298 4213848.220002137, 1910210.5099999297 4213908.920002137, 1910215.5999999298 4213937.230002139, 1910215.9999999297 4213939.440002138, 1910279.6571787472 4213931.386198807, 1910279.4921596558 4213929.343431697, 1910275.2855703512 4213894.093186696, 1910274.0771199993 4213881.995039811, 1910272.7005812733 4213868.662245543, 1910270.5101797772 4213857.157237109, 1910267.0872951874 4213846.12654489, 1910265.1849999966 4213838.825001044, 1910265.5724999653 4213835.557501571, 1910265.9599999296 4213832.2900021365, 1910260.4819905516 4213833.099922594))','ZO33376','"lib_modif"=>"N", "lib_code_insee"=>"38524", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UD2m','Pavillonnaire en densification avec secteurs où l''implantation en limite est restreinte','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD2.pdf','2019-12-20','SRID=3945;POLYGON ((1920349.7099999269 4223105.550002113, 1920333.779999927 4223092.870002113, 1920326.7099999269 4223088.100002115, 1920294.4299999268 4223064.390002112, 1920292.599999927 4223068.1100021135, 1920283.519999927 4223085.620002112, 1920294.659999927 4223099.880002114, 1920307.019999927 4223115.700002112, 1920321.849999927 4223133.85000211, 1920325.509999927 4223138.330002114, 1920325.869999927 4223137.850002112, 1920332.889999927 4223128.6900021145, 1920335.4199999268 4223125.5700021135, 1920349.7099999269 4223105.550002113))','ZO32079','"lib_modif"=>"N", "lib_code_insee"=>"38533", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','AUD1','Zone à urbaniser de type UD1','AUc',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/AUD1.pdf','2019-12-20','SRID=3945;POLYGON ((1911078.2598678393 4209071.034774624, 1911080.33 4209075.92, 1911105.28 4209107.15, 1911131.27 4209140.48, 1911139.65 4209151.23, 1911163.03 4209136.96, 1911173.49 4209130.57, 1911159.17 4209114.86, 1911155.58 4209110.92, 1911167.11 4209100.61, 1911150.34 4209079.93, 1911163.32 4209042.76, 1911184.66 4209012.9, 1911185.31 4209012.23, 1911186.26 4209011.23, 1911182.53 4209008.97, 1911173.45 4209003.48, 1911151.55 4208990.21, 1911150.890023597 4208991.41573606, 1911138.78 4209013.54, 1911125.88 4209037.13, 1911121.76 4209044.67, 1911116.83 4209053.68, 1911116.13 4209054.43, 1911105.8 4209048.45, 1911104.691699929 4209049.83320215, 1911080.696399929 4209069.86440215, 1911078.2598678393 4209071.034774624))','ZO32939','"lib_modif"=>"N", "lib_code_insee"=>"38545", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','A','Agricole','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1907896.76 4204253.81, 1907888.36 4204230.65, 1907915.3414241476 4204223.542917452, 1907914.3906585055 4204218.152414464, 1907913.9972506661 4204216.785765292, 1907913.0072506662 4204209.635765293, 1907912.9647739152 4204209.168440755, 1907912.3335554125 4204194.733958818, 1907911.1693814148 4204192.514752135, 1907903.757620867 4204187.258497634, 1907903.6106628836 4204187.150192677, 1907890.9329059417 4204177.444875994, 1907880.1155456284 4204169.43903237, 1907879.4109664068 4204168.805958035, 1907873.9809664066 4204162.905958035, 1907873.7524089597 4204162.639412166, 1907868.1324089598 4204155.5994121665, 1907867.369777869 4204154.2657842105, 1907863.1618061818 4204143.261004132, 1907849.5169769984 4204133.170091322, 1907848.7860086893 4204132.481293604, 1907829.93 4204149.44, 1907837.29 4204169.85, 1907848.58 4204201.25, 1907855.2 4204219.63, 1907859.81 4204232.42, 1907863.73 4204243.3, 1907871.13 4204263.87, 1907896.76 4204253.81))','ZO32365','"lib_modif"=>"N", "lib_code_insee"=>"38187", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UE4','Activités tertiaires et technologiques','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UE4.pdf','2019-12-20','SRID=3945;POLYGON ((1915538.701061531 4226152.0859803315, 1915538.1906999287 4226151.280002104, 1915481.269396705 4226112.521929579, 1915469.3799998579 4226104.610004206, 1915466.0099998573 4226110.79000421, 1915463.5899998576 4226114.430004207, 1915455.8999998579 4226126.010004205, 1915454.8299998576 4226127.610004211, 1915428.301310156 4226184.915642095, 1915426.3079126878 4226189.221656254, 1915479.6308988861 4226203.945142585, 1915518.2299998577 4226169.250004206, 1915536.9699998577 4226151.250004206, 1915538.701061531 4226152.0859803315))','ZO32461','"lib_modif"=>"N", "lib_code_insee"=>"38516", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','AUC3','Zone à urbaniser de type UC3','AUc',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/AUC3.pdf','2019-12-20','SRID=3945;POLYGON ((1910906.0299999295 4214030.440002135, 1910891.25 4213995.56, 1910885.43 4213983.71, 1910920.91 4213967.8, 1910924.39 4213966.25, 1910923.69 4213964.71, 1910956.95 4213950.68, 1910943.11 4213920.86, 1910940.56 4213915.37, 1910914.24 4213924.62, 1910906.69 4213927.26, 1910828.15 4213954.84, 1910698.03 4214008.87, 1910700.71 4214015.62, 1910706.41 4214033.34, 1910711.39 4214042.41, 1910717.5 4214053.74, 1910724.83 4214066.84, 1910731.5 4214077.83, 1910734.95 4214083.13, 1910739.14 4214087.55, 1910743.37 4214090.57, 1910752.39 4214096.98, 1910755.87 4214100.48, 1910757.68 4214102.7, 1910794.12 4214087.28, 1910825.41 4214071.4, 1910867.83 4214049.9, 1910906.0299999295 4214030.440002135))','ZO33937','"lib_modif"=>"N", "lib_code_insee"=>"38524", "lib_modif_comment"=>NULL',1);
INSERT INTO urba_plui_ecriture.zoneurba (idurba,libelle,libelong,typezone,nomfic,urlfic,datevalid,geom,lib_idzone,lib_hstore,lib_id_version) VALUES
     ('MJ3_PH1_ZON_050_09','N','Naturelle','N',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/N.pdf','2019-12-20','SRID=3945;POLYGON ((1915847.328424169 4228957.972241826, 1915848.148424634 4228961.494773001, 1915847.1261203755 4228969.381120139, 1915846.98007691 4228989.243031447, 1915849.6088592887 4229019.766115736, 1915851.069293944 4229032.910027631, 1915851.5736842128 4229038.313461533, 1915863.666570488 4229035.762984328, 1915864.076423677 4229035.676543325, 1915868.983942318 4229034.051973683, 1915880.9549999968 4229026.4624999985, 1915891.9431805364 4229018.306823016, 1915901.3566242668 4229011.319951434, 1915914.745712665 4229000.233889701, 1915925.4551581817 4228994.610190116, 1915925.8883845934 4228994.453070168, 1915950.9058267577 4228985.379894807, 1915963.8830996628 4228974.853137717, 1915962.4799998577 4228973.910004191, 1915946.8299998578 4228964.110004192, 1915943.6299998579 4228961.600004192, 1915947.8599998578 4228957.060004193, 1915949.1099998578 4228955.510004193, 1915950.6599998577 4228953.090004193, 1915952.2299998577 4228950.690004191, 1915954.1999998577 4228946.710004191, 1915954.8399998578 4228944.340004191, 1915955.129999858 4228941.040004189, 1915954.9499998577 4228937.290004192, 1915954.2099998577 4228933.880004191, 1915953.3299998576 4228931.540004194, 1915952.9399998577 4228930.520004193, 1915949.2999998578 4228924.470004192, 1915943.9499998577 4228916.530004194, 1915939.5199998578 4228909.710004195, 1915930.8399998578 4228918.440004192, 1915914.839999858 4228902.130004191, 1915901.7399998577 4228903.210004194, 1915890.3399998578 4228906.24000419, 1915886.8699998579 4228904.050004193, 1915877.5199998578 4228918.210004193, 1915869.7299998577 4228929.660004195, 1915860.7199998577 4228943.240004191, 1915855.5699998578 4228949.920004193, 1915848.4799998577 4228957.340004192, 1915847.328424169 4228957.972241826))','ZO34172','"lib_modif"=>"N", "lib_code_insee"=>"38126 / 38516", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','N','Naturelle','N',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/N.pdf','2019-12-20','SRID=3945;POLYGON ((1909498.3596235039 4216438.81043264, 1909503.7360276887 4216454.545675845, 1909509.1619594365 4216470.233695898, 1909512.8185656143 4216483.680570229, 1909519.6599578175 4216508.215218131, 1909525.7936197931 4216529.211214894, 1909530.747731389 4216558.817929431, 1909533.3427422247 4216572.97253399, 1909536.2916181746 4216586.065543207, 1909539.9482243522 4216595.973766399, 1909544.0766506821 4216603.994708981, 1909550.8000878477 4216614.492707362, 1909562.359681571 4216630.298682454, 1909569.6728939265 4216641.032590911, 1909578.0477016238 4216655.069240432, 1909582.2940829918 4216662.736317901, 1909588.8405876001 4216677.657630207, 1909590.06 4216677.03, 1909639.92 4216649.34, 1909639.9238103577 4216649.331317594, 1909639.9162773192 4216649.335524604, 1909613.9383343123 4216599.149390094, 1909600.745292312 4216569.9138367865, 1909599.8630753267 4216567.453190338, 1909593.965465499 4216550.868992475, 1909588.779677543 4216536.165056948, 1909582.7417165106 4216519.030467453, 1909577.4058098986 4216504.286439621, 1909574.086449218 4216495.824463738, 1909570.1756459402 4216485.842329029, 1909550.763007387 4216436.970731519, 1909547.654069476 4216428.859176635, 1909544.87609295 4216421.6472506365, 1909542.8105202226 4216416.295773632, 1909538.2839971764 4216400.290937352, 1909536.507590389 4216394.008681948, 1909508.9831674763 4216408.173200546, 1909518.9 4216424.07, 1909520.0508925123 4216425.617783005, 1909500.58 4216437.71, 1909498.3596235039 4216438.81043264))','ZO32430','"lib_modif"=>"N", "lib_code_insee"=>"38111", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UC3','Habitat collectif en R+3','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UC3.pdf','2019-12-20','SRID=3945;POLYGON ((1911529.3955193355 4223145.883046128, 1911525.13899993 4223148.684402111, 1911460.8665473775 4223160.002812099, 1911462.5197999298 4223169.651602111, 1911469.3762999298 4223229.88160211, 1911466.3257098598 4223242.469178421, 1911464.8892999298 4223248.39620211, 1911462.5981025067 4223252.769458014, 1911459.8958410895 4223259.594379729, 1911470.5533007854 4223263.421200228, 1911471.1866501307 4223263.475216531, 1911475.873000529 4223263.8749001, 1911485.8508002297 4223268.323201599, 1911497.2882998018 4223272.521001512, 1911506.0550012132 4223274.304601682, 1911520.44689993 4223276.064802109, 1911530.086663553 4223275.194635384, 1911538.3556999299 4223274.448202112, 1911547.96039993 4223272.739002111, 1911581.4658999299 4223256.70000211, 1911597.16829993 4223248.08160211, 1911626.27219993 4223232.447002111, 1911644.1936072079 4223225.022588912, 1911643.6499999298 4223211.070002113, 1911633.8099999297 4223211.130002112, 1911632.0899999298 4223211.060002114, 1911631.89999993 4223211.060002112, 1911582.05999993 4223211.170002111, 1911547.40999993 4223211.240002112, 1911544.29999993 4223199.470002111, 1911536.2699999297 4223168.320002114, 1911531.7499999297 4223150.680002112, 1911531.7299999297 4223150.560002113, 1911529.3955193355 4223145.883046128))','ZO32656','"lib_modif"=>"N", "lib_code_insee"=>"38485", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UD4','Pavillonnaire au développement limité','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD4.pdf','2019-12-20','SRID=3945;POLYGON ((1917614.3 4212385.7, 1917612.1301853356 4212384.689816733, 1917609.5789035934 4212385.395415281, 1917604.2547883138 4212388.409175859, 1917595.5691051201 4212416.473105734, 1917580.2934058085 4212455.549462034, 1917578.9724787658 4212458.73248098, 1917553.3584046487 4212484.4347209465, 1917586.9399999268 4212517.880002142, 1917580.789999927 4212521.700002143, 1917573.789999927 4212526.010002144, 1917548.36 4212541.79, 1917536.281944216 4212549.271795067, 1917547.07 4212559.22, 1917552.41 4212564.55, 1917571.2 4212580.71, 1917668.1 4212511.08, 1917670.27 4212507.45, 1917671.0212857712 4212505.9621080225, 1917636.2098226505 4212486.815872632, 1917632.981930672 4212485.120366788, 1917634.36 4212483.5, 1917646.14 4212463.79, 1917647.92 4212453.73, 1917648.44 4212450.61, 1917651.08 4212435.19, 1917653.73 4212424.36, 1917659.92 4212404.16, 1917656.01 4212402.12, 1917655.25 4212399.91, 1917645.2753512342 4212395.89483116, 1917634.23 4212391.55, 1917627.56 4212389.07, 1917614.3 4212385.7))','ZO32660','"lib_modif"=>"N", "lib_code_insee"=>"38279", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','N','Naturelle','N',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/N.pdf','2019-12-20','SRID=3945;POLYGON ((1910202.14 4215215.29, 1910201.7 4215217.96, 1910200.5442447893 4215220.34472562, 1910202.250110291 4215221.637303001, 1910204.1628299667 4215223.689357825, 1910209.0522852624 4215230.48881835, 1910220.0413303478 4215249.681382558, 1910237.4310144847 4215274.800102104, 1910239.5245578652 4215279.105853175, 1910244.699748056 4215292.838430081, 1910248.2223241783 4215298.042431582, 1910258.1932324027 4215308.21129097, 1910265.3904585834 4215317.3918939, 1910274.5339679848 4215336.081097578, 1910277.04 4215334.66, 1910283.3599999298 4215333.810002131, 1910282.2299999297 4215321.410002133, 1910281.7599999297 4215316.230002133, 1910281.5799999298 4215309.900002132, 1910281.8499999298 4215296.9200021345, 1910282.3699999298 4215287.800002132, 1910282.5299999297 4215281.480002134, 1910282.0199999297 4215276.870002133, 1910281.2299999297 4215273.670002133, 1910280.2899999297 4215271.8400021335, 1910279.0799999298 4215270.690002133, 1910277.7399999297 4215269.380002132, 1910273.1699999296 4215264.930002133, 1910258.8499999298 4215251.910002134, 1910247.0299999297 4215241.650002132, 1910230.5899999298 4215226.780002134, 1910223.6699999298 4215220.490002133, 1910219.8099999297 4215217.220002131, 1910216.1299999296 4215215.540002133, 1910209.48 4215215.17, 1910202.14 4215215.29))','ZO32802','"lib_modif"=>"N", "lib_code_insee"=>"38111 / 38524", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UZ1','Equipements collectifs et touristiques','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UZ1.pdf','2019-12-20','SRID=3945;POLYGON ((1916132.2351999278 4216767.919402129, 1916133.123022371 4216773.566679636, 1916133.7450999278 4216777.523602128, 1916133.4748999279 4216811.943202128, 1916131.409227053 4216853.4157632375, 1916131.311899928 4216855.36980213, 1916129.723369815 4216868.8791197175, 1916129.2293999281 4216876.483802128, 1916129.4386999279 4216886.489602132, 1916130.4191137394 4216892.462371042, 1916132.255675885 4216892.430526424, 1916132.2555643935 4216892.42678247, 1916132.2599999278 4216892.430002129, 1916173.2424564222 4216883.228431265, 1916202.4467010554 4216839.354147466, 1916286.52775886 4216801.049045203, 1916301.8769665046 4216780.130656024, 1916311.482703421 4216770.880687143, 1916259.9699999278 4216743.07000213, 1916201.2999999279 4216711.40000213, 1916198.5416924702 4216709.110594237, 1916193.8825504566 4216713.389398127, 1916190.323638789 4216718.727765629, 1916182.4778562489 4216726.411779457, 1916153.3594880588 4216754.478651018, 1916145.5137055186 4216760.787630792, 1916139.0752928103 4216762.999644379, 1916132.2082289432 4216765.2767125545, 1916132.2351999278 4216767.919402129))','ZO32804','"lib_modif"=>"N", "lib_code_insee"=>"38200", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','N','Naturelle','N',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/N.pdf','2019-12-20','SRID=3945;POLYGON ((1913203.6 4234617.94, 1913169.55 4234621.12, 1913161.57 4234622.12, 1913152.68 4234641.67, 1913150.37 4234646.76, 1913137.51 4234674.85, 1913126.87 4234698.29, 1913124.64 4234703.08, 1913119.49 4234714.82, 1913117.28 4234721.66, 1913171.28 4234735.28, 1913177.15 4234714.61, 1913178.1 4234710.95, 1913185.89 4234682.51, 1913189.43 4234669.62, 1913193.74 4234653.9, 1913202.31 4234622.64, 1913203.6 4234617.94))','ZO32806','"lib_modif"=>"N", "lib_code_insee"=>"38325", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','A','Agricole','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1912675.97 4235188.01, 1912691.23 4235202.12, 1912729.1499999305 4235168.460002079, 1912725.4499999303 4235167.14000208, 1912705.2499999304 4235166.23000208, 1912701.3099999304 4235165.150002078, 1912695.9099999305 4235162.090002079, 1912689.4199999303 4235157.07000208, 1912681.4399999303 4235148.27000208, 1912666.1799999303 4235128.230002079, 1912661.3299999305 4235125.530002079, 1912653.3799999305 4235123.100002079, 1912640.2299999304 4235119.860002078, 1912624.6899999303 4235116.640002078, 1912593.3699999305 4235147.010002082, 1912596.3499999305 4235154.030002078, 1912675.97 4235188.01))','ZO32807','"lib_modif"=>"N", "lib_code_insee"=>"38325", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UD2','Pavillonnaire en densification','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD2.pdf','2019-12-20','SRID=3945;POLYGON ((1915456.9525153069 4222178.643806558, 1915465.8876457755 4222175.94961963, 1915463.08 4222163.57, 1915460.1487424436 4222149.615671265, 1915459.28 4222145.48, 1915458.58 4222142.18, 1915460.49 4222142.83, 1915475.45 4222148.86, 1915482.52 4222130.28, 1915505.77 4222070.54, 1915504.22 4222069.91, 1915500.4 4222068.41, 1915489.29 4222063.84, 1915490.85 4222059.81, 1915492.51 4222055.61, 1915493.04 4222054.14, 1915493.85 4222052.2, 1915498.29 4222040.64, 1915504.12 4222025.69, 1915505.5361612982 4222022.300683966, 1915454.9999848178 4222039.454858299, 1915454.1224283217 4222040.113265676, 1915448.0553782557 4222043.75592672, 1915421.1701192379 4222052.565343498, 1915421.203387938 4222052.714839388, 1915421.1248283223 4222052.739582057, 1915422.7941805457 4222060.32160697, 1915424.8685291645 4222069.121031143, 1915429.210965555 4222086.972567343, 1915451.38498185 4222180.110745003, 1915451.57204796 4222180.063489627, 1915451.5860987008 4222180.122056266, 1915454.1170096241 4222179.420598614, 1915456.9525153069 4222178.643806558))','ZO32188','"lib_modif"=>"N", "lib_code_insee"=>"38158 / 38185", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UZ1','Equipements collectifs et touristiques','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UZ1.pdf','2019-12-20','SRID=3945;POLYGON ((1920876.57 4216658.98, 1920893.5 4216651.04, 1920909.9066285652 4216642.8696618825, 1920901.06 4216627.7, 1920879.71 4216590.26, 1920862.99 4216561.36, 1920861.4895823323 4216558.310368829, 1920860.7775655114 4216558.226379572, 1920854.7364429254 4216558.096480839, 1920845.2201502009 4216558.131183894, 1920806.3775000111 4216558.342500033, 1920800.7640668966 4216556.536521468, 1920788.2397764688 4216549.006031571, 1920776.4775370443 4216542.026784291, 1920764.9640529095 4216537.597899668, 1920760.033284605 4216537.241538455, 1920747.6991588504 4216536.927898526, 1920738.4637326149 4216536.871636463, 1920713.8843645917 4216536.24054873, 1920691.2850725811 4216535.309905382, 1920686.342153042 4216535.10635497, 1920687.1 4216536.68, 1920725.87 4216635.39, 1920757.16 4216714.61, 1920785.26 4216701.5, 1920796.83 4216696.05, 1920835.29 4216678.13, 1920841.78 4216675.16, 1920876.57 4216658.98))','ZO32190','"lib_modif"=>"N", "lib_code_insee"=>"38528 / 38529", "lib_modif_comment"=>NULL',1);
INSERT INTO urba_plui_ecriture.zoneurba (idurba,libelle,libelong,typezone,nomfic,urlfic,datevalid,geom,lib_idzone,lib_hstore,lib_id_version) VALUES
     ('MJ3_PH1_ZON_050_09','A','Agricole','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1919872.51 4213376.49, 1919873.25 4213413.77, 1919872.835267351 4213414.680776317, 1919882.0398711232 4213422.507445392, 1919898.8506744194 4213439.648953016, 1919899.5959766808 4213440.36988722, 1919900.7214498965 4213440.195394455, 1919900.8574995953 4213440.17353194, 1919901.0713957315 4213440.124292387, 1919901.8519508878 4213439.944757508, 1919928.5549369077 4213433.041572783, 1919928.6339711936 4213432.860922987, 1919929.236935364 4213431.477980931, 1919994.0538905517 4213414.4471946675, 1919993.3556667003 4213413.451886144, 1919970.24 4213385.7, 1920011.7741235993 4213347.843913711, 1920026.311373065 4213334.59400442, 1920034.72 4213326.93, 1920007.95 4213281.48, 1919971.67 4213300.75, 1919941.33 4213317.22, 1919927.4621948786 4213324.912099603, 1919924.96 4213326.3, 1919898.64 4213326.91, 1919879.72 4213259.86, 1919897.42 4213253.59, 1919894.86 4213241.91, 1919894.2759312282 4213240.509830688, 1919890.6381836298 4213240.950769791, 1919869.6935762442 4213241.722413221, 1919840.2608911286 4213232.572926837, 1919824.8280225287 4213225.407666416, 1919822.9540313417 4213225.628135967, 1919806.0881106574 4213236.761848314, 1919806.96 4213238.56, 1919840.44 4213301.04, 1919845.99 4213297.22, 1919888.41 4213362.43, 1919882.62 4213367.55, 1919872.51 4213376.49))','ZO32100','"lib_modif"=>"N", "lib_code_insee"=>"38528 / 38562", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','NLv1','STECAL en zone naturelle réservés aux gens du voyage','N',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/NL.pdf','2019-12-20','SRID=3945;POLYGON ((1908611.6146710417 4230275.402208994, 1908557.6760307031 4230242.993486957, 1908434.178654049 4230463.759295782, 1908388.14115401 4230551.293323102, 1908446.6820591744 4230577.100028588, 1908473.9494566259 4230588.941906669, 1908511.2802531878 4230515.036016686, 1908582.3541564126 4230388.136096328, 1908635.495636896 4230293.253877466, 1908636.9689568807 4230290.623317158, 1908611.6146710417 4230275.402208994))','ZO32268','"lib_modif"=>"N", "lib_code_insee"=>"38170 / 38382", "lib_modif_comment"=>""',1),
     ('MJ3_PH1_ZON_050_09','A','Agricole','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1921493.86 4226256.95, 1921493.8366262752 4226256.949310979, 1921489.45 4226256.82, 1921488.7358480708 4226254.931825582, 1921486.81 4226249.84, 1921487.23 4226249.84, 1921486.5224108023 4226248.297787974, 1921481.27 4226236.85, 1921473.58 4226216.76, 1921471.05 4226208.44, 1921469.61 4226203.73, 1921465.5 4226190.2, 1921464.830500442 4226188.2723804675, 1921462.52 4226181.62, 1921457.09 4226163.53, 1921458.67 4226163.65, 1921443.37 4226113.36, 1921441.1695622583 4226106.16896946, 1921433.37 4226080.68, 1921419.68 4226048.54, 1921402.74 4226008.33, 1921401.59 4226005.58, 1921381.18 4225962.85, 1921365.47 4225931.35, 1921363.88 4225927.48, 1921362.69 4225925.45, 1921359.97 4225921.36, 1921349.897683521 4225906.202076598, 1921333.49 4225881.51, 1921303.92 4225840.77, 1921291.83 4225824.76, 1921269.12 4225798.76, 1921260.29 4225788.36, 1921254.98 4225784.52, 1921244.92 4225777.24, 1921234.69 4225769.95, 1921225.5190928862 4225763.159293177, 1921214.77 4225755.2, 1921201.49 4225745.9, 1921199.9 4225744.33, 1921147.28 4225706.8, 1921135.4 4225698.67, 1921131.463071927 4225695.813633037, 1921114.0437994378 4225683.175394911, 1921112.336653343 4225681.9368059365, 1921112.26 4225682.05, 1921112.0470856396 4225681.900248839, 1921070.4491599316 4225732.988990388, 1921014.458843747 4225801.873430101, 1921014.5563200163 4225801.962162076, 1921038.9198810286 4225821.287947822, 1921050.984560746 4225830.855673384, 1921080.279840327 4225853.533026345, 1921084.2338167804 4225856.58837818, 1921089.885264687 4225860.839866255, 1921095.6390513862 4225865.151969504, 1921096.652045117 4225865.91122701, 1921097.4422839247 4225866.504393913, 1921098.5077142585 4225867.299095668, 1921101.17262286 4225869.288994252, 1921104.1419818061 4225871.530772997, 1921110.4526905215 4225876.386578264, 1921115.6879875928 4225880.419404001, 1921125.0161553537 4225887.597155492, 1921142.9680322313 4225901.41462365, 1921143.2201848924 4225901.590636162, 1921146.4980617396 4225903.894615376, 1921265.1174536992 4225993.264733014, 1921277.396313258 4226035.774156124, 1921280.6436127478 4226047.1264557745, 1921280.6609554803 4226047.176598624, 1921281.323171228 4226049.091255671, 1921286.0718909919 4226064.823044447, 1921291.9812633358 4226085.068136, 1921302.4219774758 4226120.449171937, 1921318.161667331 4226173.930108554, 1921328.3893344668 4226208.000658063, 1921332.991494948 4226225.403859014, 1921339.8836173678 4226249.258295695, 1921341.2321576218 4226254.1550071845, 1921343.221255443 4226261.253669398, 1921347.98052275 4226277.213852328, 1921368.8212572199 4226347.1629735045, 1921368.94 4226347.13, 1921375.7124811776 4226345.269860102, 1921379.28 4226344.29, 1921387.59 4226342.09, 1921447.3493437197 4226333.7188451, 1921496.76196507 4226326.797070503, 1921496.79 4226320.42, 1921492.32 4226302.17, 1921492.43 4226293.62, 1921493.86 4226256.95))','ZO34180','"lib_modif"=>"N", "lib_code_insee"=>"38271 / 38150", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','A','Agricole','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1922681.5321043557 4225151.430850751, 1922676.4980422398 4225143.406135578, 1922675.9208316656 4225143.501266051, 1922667.98 4225144.81, 1922666.2981204034 4225144.560205421, 1922652.09 4225142.45, 1922633.82 4225141.81, 1922622.02 4225142.8, 1922609.82 4225143.18, 1922584.68 4225143.66, 1922543.78 4225160.78, 1922537.88 4225163.63, 1922533.96 4225167.1, 1922526.31 4225180.22, 1922518.96 4225193.37, 1922506.95 4225196.24, 1922493.77 4225195.16, 1922492.77 4225189.86, 1922489.91 4225185.98, 1922486.67 4225183.13, 1922483.83 4225181.91, 1922481.46 4225181.99, 1922477.24 4225184.33, 1922472.5 4225192.56, 1922461.85 4225195.63, 1922456.86 4225193.19, 1922458.05 4225186.06, 1922452.65 4225182.04, 1922442.59 4225189.8, 1922436.22 4225198.6, 1922434.4 4225204.56, 1922433.48 4225209.53, 1922433.18 4225213.54, 1922439.12 4225237.28, 1922451.39 4225237.62, 1922451.65 4225253.64, 1922458.68 4225271.81, 1922458.99 4225272.59, 1922466.37 4225280.87, 1922473.6 4225288.52, 1922479.39 4225282.5, 1922503.4510909433 4225320.878307764, 1922526.53 4225357.69, 1922531.43 4225376.26, 1922532.95 4225379.83, 1922535.45 4225384.32, 1922539.27 4225390.46, 1922547.0954361164 4225402.275972752, 1922551.84 4225409.44, 1922555.76 4225413.12, 1922560.91 4225416.91, 1922571.1350407326 4225423.227381854, 1922580.27 4225423.81, 1922592.95 4225426.42, 1922605.32 4225432.54, 1922613.717419974 4225420.170952587, 1922623.44 4225405.85, 1922640.51 4225380.69, 1922663.58 4225345.88, 1922653.3184346792 4225339.303943012, 1922619.95 4225317.92, 1922609.22 4225310.72, 1922617.03 4225297.22, 1922622.18 4225298.36, 1922638.29 4225307.05, 1922642.88 4225308.99, 1922653.39 4225294.33, 1922629.93 4225278.47, 1922626.51 4225274.15, 1922629.04 4225264.92, 1922628.38 4225261.94, 1922620.88 4225256.01, 1922625.91 4225249.25, 1922628.22 4225247.87, 1922633.86 4225246.7, 1922645.02 4225249.88, 1922665.73 4225260.8, 1922674.68 4225262.99, 1922687.07 4225265.21, 1922701.03 4225266.9, 1922710.09 4225267.56, 1922715.5057412507 4225267.574012267, 1922716.0715651272 4225267.575476236, 1922716.808733804 4225267.577383528, 1922716.6039271632 4225267.354741903, 1922720.0837943733 4225259.47217124, 1922722.1044507683 4225254.95275159, 1922743.9637403197 4225222.54157884, 1922752.4924566452 4225208.728875737, 1922759.6457429926 4225199.1191744525, 1922761.761062862 4225196.217889685, 1922741.06465625 4225184.664321173, 1922712.2586239686 4225168.583632687, 1922681.5321043557 4225151.430850751))','ZO34183','"lib_modif"=>"N", "lib_code_insee"=>"38271 / 38150", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','A','Agricole','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1917908.651451441 4214094.807960122, 1917905.3578228813 4214050.135502767, 1917953.68 4214028.23, 1917952.41 4214023.71, 1917965.26 4213967.95, 1917965.635092405 4213966.07248206, 1918025.171945379 4213985.907962099, 1918048.591103383 4214020.20900919, 1918070.9517988476 4214052.903742972, 1918078.501469709 4214058.062993726, 1918078.5140090117 4214059.410968743, 1918078.5218347334 4214060.252233834, 1918085.819066701 4214067.950009611, 1918103.318927442 4214084.407201733, 1918110.5958942447 4214091.187115701, 1918121.924541157 4214101.438531111, 1918126.110933334 4214104.452932402, 1918130.166453873 4214107.252966224, 1918137.8275188622 4214112.106129717, 1918151.3771356274 4214119.983820851, 1918167.00043933 4214125.949392304, 1918175.41381414 4214128.742893278, 1918174.03 4214132.4, 1918157.13 4214172.69, 1918009.31 4214109.56, 1917978.23 4214110.48, 1917908.651451441 4214094.807960122))','ZO34188','"lib_modif"=>"N", "lib_code_insee"=>"38252 / 38562", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','As','Agricole avec secteurs à protéger (stricts)','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1913936.9599237859 4228004.023811745, 1913970.66 4228002.15, 1913978.86 4228001.66, 1913981.14 4228001.59, 1913981.85 4227971.64, 1913982.35 4227953.63, 1913982.53 4227952.25, 1913983.66 4227946.66, 1913984.57 4227914.96, 1913969.52 4227913.29, 1913964.27 4227912.72, 1913906.31 4227907.09, 1913908.89 4227845.34, 1913896.1999999294 4227843.100002101, 1913895.6999999294 4227846.700002098, 1913895.0999999295 4227850.700002099, 1913894.5999999293 4227854.3000021, 1913890.2999999295 4227868.1000021, 1913888.2999999295 4227874.000002099, 1913886.8999999296 4227879.0000021, 1913885.8999999296 4227883.300002099, 1913884.9999999295 4227886.600002099, 1913884.1999999294 4227889.9000021, 1913883.2999999295 4227895.900002099, 1913881.9999999295 4227904.6000021, 1913880.2999999295 4227915.800002098, 1913879.3999999296 4227922.600002099, 1913878.1999999294 4227943.9000021, 1913872.9357529122 4227970.055434129, 1913874.9085717348 4227970.339761578, 1913870.69 4227989.37, 1913867.13 4228004.4, 1913866.3999999296 4228007.600002098, 1913881.3999999296 4228007.000002099, 1913895.9999999295 4228006.300002099, 1913895.1999999294 4228019.800002099, 1913920.7999999295 4228059.700002098, 1913928.97 4228058.04, 1913941.6300685394 4228055.542453495, 1913936.9599237859 4228004.023811745))','ZO34195','"lib_modif"=>"N", "lib_code_insee"=>"38423", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UC1u','Habitat collectif en R+5 avec bureaux autorisés sans limitation de surface','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UC1.pdf','2019-12-20','SRID=3945;POLYGON ((1912664.9371238376 4221087.308662402, 1912659.27 4221093.24, 1912659.33 4221121.67, 1912639.43 4221121.75, 1912637.55 4221121.7, 1912637.79 4221116.72, 1912630.58 4221116.92, 1912621.64 4221116.77, 1912621.39 4221091.29, 1912621.29 4221068.29, 1912620.28 4221067.78, 1912614.77 4221070.51, 1912555.140942868 4221094.460273481, 1912535.7 4221097.23, 1912495.68 4221103.77, 1912492.27 4221083.58, 1912489.19 4221065.36, 1912485.21 4221041.79, 1912377.75 4221033.94, 1912431.4646028776 4221223.750714009, 1912434.879458502 4221221.63777328, 1912448.4513663969 4221213.12909919, 1912454.2866839608 4221209.569558998, 1912454.293777322 4221209.388678291, 1912454.6368363602 4221209.179168328, 1912454.8791070834 4221206.102144408, 1912456.0354180648 4221202.478709614, 1912457.7276375114 4221199.657029229, 1912458.7085201994 4221198.288950516, 1912459.2354821134 4221197.637904474, 1912460.2536681462 4221196.739284326, 1912461.2218155705 4221195.976906424, 1912464.139785382 4221194.202361323, 1912468.604464574 4221193.24488756, 1912471.2241480942 4221193.294738981, 1912473.2701010492 4221193.519894331, 1912475.2997740903 4221194.183760663, 1912477.4744036351 4221195.04948621, 1912489.9974746245 4221187.124173609, 1912516.7025083753 4221170.45173778, 1912544.0279520699 4221153.330098269, 1912564.043375072 4221155.401686908, 1912584.725188892 4221157.516131623, 1912603.5851031095 4221159.98389763, 1912628.483928628 4221163.252659266, 1912632.2073331773 4221163.748057558, 1912654.7822214437 4221166.652804775, 1912657.1907782864 4221166.769426666, 1912662.2049419093 4221166.7555512255, 1912783.5330158211 4221166.403448654, 1912803.228936015 4221161.537612505, 1912809.7499999292 4221159.960002116, 1912814.931988447 4221158.860973317, 1912839.0799999293 4221153.740002118, 1912863.0799999293 4221148.680002117, 1912869.82 4221147.22, 1912890.73 4221148.91, 1912891.4850962092 4221149.218025191, 1912891.2779542003 4221151.305187247, 1912891.5129378107 4221152.159935447, 1912917.3543624755 4221169.0366532765, 1912962.5540804563 4221198.609026871, 1913046.901043786 4221179.363592311, 1913060.3262188346 4221187.2431411445, 1913051.4877010656 4221154.158865389, 1913044.9372690686 4221129.6393357385, 1913037.1029304639 4221101.232680408, 1913036.0892519583 4221097.500224739, 1913027.940348985 4221067.49523068, 1913019.8216406542 4221038.279440535, 1913015.353699897 4221022.5231447, 1913014.361373566 4221018.840653373, 1912999.4 4221022.1, 1912952.71 4221034.16, 1912951.03 4221034.55, 1912935.3643519147 4221038.771489046, 1912941.9945176723 4221067.2180411825, 1912916.17 4221075.27, 1912852.04 4221097.59, 1912853.7 4221102.18, 1912849.68 4221102.4, 1912825.3 4221104.09, 1912796.33 4221106.03, 1912789.98 4221119.88, 1912788.65 4221119.92, 1912773.59 4221120.37, 1912768.99 4221120.63, 1912759.03 4221121.06, 1912749.1 4221121.4, 1912748.07 4221121.42, 1912725.67 4221122.47, 1912722.58 4221122.62, 1912719.67 4221122.71, 1912712.62 4221122.73, 1912711.22 4221122.81, 1912702.8 4221122.9, 1912699.372796798 4221122.904711955, 1912699.3679999295 4221117.4586021155, 1912698.9936128184 4221086.878503146, 1912695.5599999465 4221086.970002116, 1912688.499999937 4221087.070002121, 1912679.2099999303 4221087.020002112, 1912668.4599999376 4221087.240002125, 1912668.459999745 4221087.2400011225, 1912664.9371238376 4221087.308662402))','ZO34197','"lib_modif"=>"N", "lib_code_insee"=>"38151 / 38185", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','A','Agricole','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1919494.4124868019 4222933.056688269, 1919502.8349868872 4222916.07, 1919505.733802077 4222910.074778004, 1919563.2888175831 4222791.041630882, 1919569.515 4222777.37, 1919588.1971135233 4222743.420213609, 1919560.83 4222754.79, 1919541.61 4222765.78, 1919517.36 4222779.65, 1919500.97 4222790.45, 1919493.9400191226 4222795.519531664, 1919484.69 4222802.19, 1919473.29 4222787.39, 1919460.8775952577 4222770.208901157, 1919457.1 4222764.98, 1919450.06 4222771.77, 1919444.41 4222780.67, 1919441.65 4222786.49, 1919438.87 4222792.96, 1919432.92 4222808.92, 1919421.27 4222849.07, 1919419.4869707392 4222857.6549557, 1919418.03 4222864.67, 1919414.19 4222884.47, 1919471.34 4222885.09, 1919473.4 4222891.96, 1919473.77 4222893.03, 1919486.08 4222935.69, 1919494.4124868019 4222933.056688269))','ZO34190','"lib_modif"=>"N", "lib_code_insee"=>"38179 / 38533", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UD3','Pavillonnaire en évolution modérée','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD3.pdf','2019-12-20','SRID=3945;POLYGON ((1909167.7003306593 4206452.8411750905, 1909166.4230673183 4206456.733787178, 1909164.2190863336 4206462.774327654, 1909161.8518474984 4206469.386270608, 1909160.7906714687 4206473.304459025, 1909160.7090425433 4206475.181924309, 1909161.0355582447 4206478.202194546, 1909161.1988160955 4206479.834773053, 1909161.1310276473 4206480.578153427, 1909162.29 4206480.66, 1909165.04 4206484.32, 1909167.26 4206486.21, 1909174.16 4206492.09, 1909179.39 4206496.17, 1909183.07 4206492.47, 1909189.44 4206490.34, 1909189.78 4206491.07, 1909191.02 4206490.69, 1909191.44 4206491.66, 1909193.92 4206490.84, 1909195.15 4206496.47, 1909196.18 4206501.22, 1909197.93 4206506.01, 1909188.32 4206510.05, 1909184.37 4206511.5, 1909177.33 4206514.09, 1909175.0308383733 4206514.935411571, 1909175.78 4206518.21, 1909178.26 4206531, 1909179.94 4206539.69, 1909195.91 4206537, 1909197.29 4206545.75, 1909199.4774635595 4206558.682898589, 1909199.57 4206559.23, 1909214.08 4206555.97, 1909212.82 4206553.28, 1909210.41 4206543.38, 1909219.33 4206541.55, 1909218.71 4206511.91, 1909229.59 4206508.41, 1909232.59 4206508.33, 1909230.82 4206505.54, 1909230.52 4206505.03, 1909229.78 4206503.74, 1909228.48 4206501.51, 1909228.01 4206500.73, 1909226.75 4206498.81, 1909225.6 4206497.08, 1909225.11 4206496.43, 1909224.5 4206495.83, 1909224.99 4206493.56, 1909225.73 4206490.18, 1909225.9468597716 4206489.200845273, 1909226.06 4206488.69, 1909233.280923358 4206483.007555159, 1909234.79 4206481.82, 1909236.91 4206479.38, 1909239.05 4206476.92, 1909242.31 4206470.48, 1909245.21 4206460.06, 1909247.11 4206455.07, 1909250.16 4206449.42, 1909253.28 4206444.21, 1909256.46 4206439.27, 1909257.20079121 4206438.671930032, 1909256.2740699581 4206437.689988124, 1909255 4206436.34, 1909254.55 4206436.23, 1909242.92 4206433.31, 1909245.05 4206426.92, 1909201.18 4206425.4, 1909198.42 4206445.73, 1909197.23 4206454.32, 1909196.1 4206462.52, 1909169.52 4206452.09, 1909169.14 4206452.62, 1909168.9095807376 4206453.262898189, 1909167.7003306593 4206452.8411750905))','ZO34198','"lib_modif"=>"N", "lib_code_insee"=>"38545", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UC1u','Habitat collectif en R+5 avec bureaux autorisés sans limitation de surface','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UC1.pdf','2019-12-20','SRID=3945;POLYGON ((1914060.09 4221112.99, 1914051.0282836184 4221129.7951471815, 1914028.3423363075 4221152.77193997, 1913986.1697419474 4221180.69310589, 1913962.3204127233 4221195.8170707645, 1913943.9971475876 4221207.16004442, 1913922.4745821902 4221215.012872335, 1913879.7202968735 4221221.702318337, 1913841.9103846888 4221225.483309556, 1913804.100472504 4221229.264300774, 1913807.0515557635 4221267.983461418, 1913812.0282212107 4221268.40158644, 1913829.6042417886 4221269.8782728035, 1913830.3111498328 4221269.9176203245, 1913836.073846581 4221309.122299255, 1913836.8998547534 4221313.163685834, 1913838.0704072858 4221317.112926312, 1913838.8333273833 4221319.294130691, 1913839.4624628176 4221320.984372602, 1913839.6817347535 4221321.5272457255, 1913840.30895565 4221322.532731865, 1913841.5556211814 4221324.586756546, 1913846.2884663893 4221331.321466686, 1913849.7034180197 4221335.3804482, 1913852.0148392282 4221337.823813598, 1913854.0196145033 4221339.485481646, 1913857.794696382 4221342.264457121, 1913862.9168140972 4221345.2965838695, 1913868.5102628227 4221348.165925647, 1913875.5257480592 4221350.720513667, 1913880.2056320384 4221351.617354851, 1913884.2424746242 4221351.9949954515, 1913887.4915635765 4221352.231948879, 1913889.941693855 4221352.257277188, 1913895.5760582753 4221351.701814183, 1913899.5685001768 4221350.902933258, 1913902.441211713 4221350.208501273, 1913906.5772764196 4221349.062341678, 1913918.317219612 4221345.572046595, 1913933.5056989775 4221341.316610671, 1913951.446831934 4221336.412538418, 1913968.4665433485 4221332.090113757, 1913970.983325567 4221331.464161963, 1913972.6912419896 4221331.038928305, 1913973.868798182 4221330.754153599, 1913974.0061671184 4221330.720922197, 1913981.092428687 4221329.014169282, 1913984.0680273932 4221328.28211194, 1913993.223823402 4221326.030384316, 1914003.3978825305 4221323.568541469, 1914005.1069442255 4221323.159492123, 1914006.8012734088 4221322.753130704, 1914010.3040598254 4221321.935631169, 1914014.97688479 4221320.859507163, 1914021.9778593678 4221319.268357977, 1914034.9645656762 4221316.45253898, 1914039.869962696 4221315.414697053, 1914046.3198354456 4221314.100096349, 1914047.4416706997 4221313.872753314, 1914053.9516346515 4221312.573081527, 1914061.5691632284 4221311.07368043, 1914081.7654169865 4221307.313754505, 1914090.5822409852 4221305.694217785, 1914091.24 4221301.7, 1914091.41 4221291.28, 1914091.1897422706 4221274.523725515, 1914070.22 4221189.89, 1914061.2918166125 4221155.137071159, 1914058.05 4221142.62, 1914060.09 4221112.99))','ZO34201','"lib_modif"=>"N", "lib_code_insee"=>"38151 / 38185", "lib_modif_comment"=>NULL',1);
INSERT INTO urba_plui_ecriture.zoneurba (idurba,libelle,libelong,typezone,nomfic,urlfic,datevalid,geom,lib_idzone,lib_hstore,lib_id_version) VALUES
     ('MJ3_PH1_ZON_050_09','AU','Zone à urbaniser stricte','AUs',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/AU.pdf','2019-12-20','SRID=3945;POLYGON ((1912798.8898506814 4215311.429213492, 1912787.3300000005 4215342.009999992, 1912778.87 4215364.45, 1912765.17 4215401.46, 1912747.28 4215450.42, 1912717.73 4215531.3, 1912677.5034598056 4215640.537884259, 1912687.489999929 4215656.330002132, 1912742.739999929 4215750.510002131, 1912749.889999929 4215762.11000213, 1912760.549999929 4215770.880002132, 1912758.949999929 4215794.300002131, 1912758.559999929 4215798.940002131, 1912758.9479445047 4215804.010991942, 1912941.6429726307 4215814.079654468, 1913090.869999929 4215823.810002122, 1913092.2603957802 4215823.900662878, 1913087.215182186 4215817.538643724, 1913021.6332492256 4215703.162863553, 1912989.5777754532 4215647.25768272, 1912984.1599999287 4215649.620002131, 1912881.1799999287 4215692.540002132, 1912862.399999929 4215700.420002132, 1912829.4111466156 4215714.082543229, 1912828.8495303893 4215713.052849414, 1912828.359999929 4215712.3100021295, 1912813.3699999289 4215687.090002132, 1912811.4399999287 4215683.650002133, 1912811.319999929 4215682.650002132, 1912825.729999929 4215672.26000213, 1912839.179999929 4215661.540002131, 1912852.619999929 4215650.830002132, 1912858.5899999288 4215647.350002132, 1912883.709999929 4215635.320002133, 1912888.4199999287 4215633.200002132, 1912890.859999929 4215632.56000213, 1912893.319999929 4215632.350002131, 1912896.189999929 4215632.210002133, 1912899.059999929 4215632.450002133, 1912901.2499999288 4215632.880002131, 1912903.2699999288 4215633.980002131, 1912923.139999929 4215653.220002132, 1912925.2599999288 4215655.150002132, 1912926.4399999287 4215655.810002132, 1912927.709999929 4215656.120002131, 1912928.6499999287 4215656.23000213, 1912929.5999999288 4215656.110002132, 1912937.0999999288 4215653.940002132, 1912942.4299999287 4215656.350002132, 1912944.0899999288 4215656.800002132, 1912945.7999999288 4215656.930002132, 1912947.3799999286 4215656.890002132, 1912948.9599999287 4215656.680002132, 1912957.2199999287 4215655.240002133, 1912957.209999929 4215654.070002132, 1912961.9499999287 4215651.5100021325, 1912962.5399999288 4215652.080002133, 1912980.2299999287 4215642.450002133, 1912985.5507357358 4215640.19251884, 1912962.1354226551 4215598.25553551, 1912957.9993858053 4215590.850714917, 1912944.2797985247 4215566.795161981, 1912939.138329234 4215557.776441635, 1912916.568804848 4215517.808658268, 1912890.600749392 4215472.405710583, 1912864.9988006072 4215427.642869433, 1912814.4878560032 4215338.849119963, 1912798.8898506814 4215311.429213492))','ZO34208','"lib_modif"=>"N", "lib_code_insee"=>"38068 / 38317", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UV','Parcs urbains','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UV.pdf','2019-12-20','SRID=3945;POLYGON ((1910994.78 4226595.35, 1910972.3901713076 4226593.945755186, 1910966.496936779 4226603.958111758, 1910955.6472302142 4226615.767861816, 1910936.6734559555 4226635.866315751, 1910889.146594881 4226685.023430556, 1910857.4397464378 4226714.257132993, 1910822.1045929703 4226748.160137344, 1910783.042368792 4226787.027366437, 1910748.7467305213 4226817.177072013, 1910725.8579896267 4226839.00564964, 1910685.4616653202 4226877.369182159, 1910653.370714516 4226911.716814259, 1910580.431857425 4226984.626536301, 1910455.3943363905 4227104.544865498, 1910367.162510726 4227189.283384654, 1910371.323366059 4227194.095508622, 1910375.0730637847 4227198.376347359, 1910376.6319092188 4227200.166308801, 1910379.5565045413 4227203.473912908, 1910387.4342486935 4227212.471698963, 1910393.2927428412 4227219.163326468, 1910396.6028588056 4227222.943537274, 1910398.4028982138 4227224.999367957, 1910399.9037267924 4227226.716790995, 1910400.6432536463 4227227.560808741, 1910401.894155001 4227228.98962978, 1910403.2737585118 4227230.565531868, 1910405.8647193834 4227233.57612342, 1910442.432400933 4227206.4131396115, 1910508.3687563634 4227158.9965487905, 1910545.6156487297 4227132.088388934, 1910577.0961709395 4227110.604121818, 1910613.0651353055 4227089.939154891, 1910663.7988847324 4227061.244789997, 1910701.1220748716 4227041.028246445, 1910738.3278476764 4227022.058572045, 1910756.6451383452 4227014.264688212, 1910773.4533434012 4227008.01863948, 1910806.2377214816 4226996.235441926, 1910820.0451612705 4226992.199099051, 1910841.1309731016 4226986.006872968, 1910865.0858921742 4226978.9720821865, 1910868.157430559 4226963.294324387, 1910871.244209074 4226940.344828068, 1910958.3281380108 4226675.239422059, 1910970.4 4226638.42, 1910983.2 4226615.98, 1910994.78 4226595.35))','ZO34206','"lib_modif"=>"N", "lib_code_insee"=>"38185 / 38382 / 38474", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','AUD1','Zone à urbaniser de type UD1','AUc',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/AUD1.pdf','2019-12-20','SRID=3945;POLYGON ((1908294.48 4211518.58, 1908299.9199999871 4211520.334999979, 1908303.8661699812 4211512.778333026, 1908325.5769738534 4211489.809123656, 1908347.5049999943 4211466.349999977, 1908362.274219865 4211450.659938447, 1908368.3699999955 4211444.184999975, 1908376.5749999832 4211435.484999987, 1908374.12 4211433.61, 1908373.99 4211433.48, 1908373.78 4211433.29, 1908369.12 4211429.02, 1908346.32 4211408.07, 1908298.25 4211362.17, 1908276.93 4211355.43, 1908260.04 4211349.8, 1908234.33 4211341.52, 1908209.68 4211333.24, 1908203.21999993 4211329.440002146, 1908191.52999993 4211322.190002146, 1908181.34 4211316.02, 1908181.07 4211316.3, 1908172.77 4211324.89, 1908156.95 4211341.06, 1908174.52 4211360.82, 1908130.23 4211413.74, 1908123.0570805152 4211422.482724182, 1908111.77 4211436.24, 1908110.46 4211438.04, 1908104.5703495073 4211435.179046359, 1908109.403970646 4211441.176570605, 1908120.0923354137 4211451.228723184, 1908132.5620943091 4211457.845329945, 1908142.9959742012 4211463.571239642, 1908164.499946174 4211472.478210282, 1908183.3318269548 4211481.512423359, 1908193.765706847 4211485.075211614, 1908216.92383051 4211493.727697379, 1908247.9709853109 4211505.815728961, 1908270.7473816606 4211514.340972288, 1908291.36468299 4211522.246051554, 1908294.48 4211518.58))','ZO34214','"lib_modif"=>"N", "lib_code_insee"=>"38436", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UD2','Pavillonnaire en densification','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD2.pdf','2019-12-20','SRID=3945;POLYGON ((1915799.337408553 4219437.283398501, 1915794.5762022603 4219436.373402957, 1915780.2551181854 4219432.91654142, 1915773.2107232797 4219431.283269524, 1915769.403908916 4219430.579722453, 1915765.116146084 4219429.954524863, 1915760.638021585 4219429.490196456, 1915754.0357684437 4219429.20300311, 1915747.7666067814 4219429.243643724, 1915740.4702458754 4219429.513484769, 1915723.7908759178 4219430.424123765, 1915707.8757147547 4219431.355056904, 1915695.040670782 4219431.925895569, 1915639.796028181 4219434.382901408, 1915633.5180943205 4219434.663775712, 1915605.0487965497 4219435.865885303, 1915589.590468488 4219436.215740776, 1915588.000251544 4219436.250098964, 1915580.8148481746 4219436.437093645, 1915570.308086412 4219436.778286785, 1915564.0747251501 4219437.173111478, 1915546.291537952 4219437.472442559, 1915534.7410380873 4219437.611670449, 1915534.5000903045 4219438.126663403, 1915529.0652186365 4219445.030541487, 1915522.9652235878 4219452.732832635, 1915510.5053612792 4219469.211484336, 1915510.3981927943 4219469.3529780945, 1915510.338097849 4219469.434592447, 1915509.9821873421 4219469.918760997, 1915507.8426843458 4219472.831900278, 1915507.3473187624 4219473.503777566, 1915506.8547798286 4219474.17284975, 1915492.373961441 4219493.882027081, 1915485.005743843 4219503.889145655, 1915479.8018678636 4219510.963457077, 1915465.717136737 4219530.311470481, 1915464.5086421052 4219531.9719949225, 1915462.8516080345 4219534.250010327, 1915451.9568059773 4219549.233233453, 1915451.1547260582 4219550.313645679, 1915448.7604954941 4219553.547883481, 1915442.8570417196 4219561.709969469, 1915421.7145125521 4219590.959978476, 1915415.9158571858 4219598.825465707, 1915415.4647895459 4219599.434450494, 1915415.379755937 4219599.536211422, 1915413.132278097 4219602.225604224, 1915404.9295534252 4219611.251636552, 1915418.1299999284 4219619.610002123, 1915418.5199999283 4219619.900002123, 1915418.9099999282 4219620.170002123, 1915431.9999999283 4219629.100002123, 1915441.3999999284 4219635.510002122, 1915446.3099999283 4219638.930002122, 1915448.4899999283 4219640.160002124, 1915449.2899999283 4219638.900002122, 1915462.549999928 4219646.500002124, 1915475.759999928 4219654.280002122, 1915482.6299999284 4219644.450002123, 1915485.9699999283 4219639.690002124, 1915495.799999928 4219625.500002123, 1915503.6999999282 4219614.400002123, 1915515.0999999284 4219598.300002124, 1915520.929999928 4219590.0800021235, 1915521.779999928 4219588.890002122, 1915522.8999999282 4219587.300002123, 1915534.5999999281 4219570.800002124, 1915542.0999999281 4219560.200002124, 1915553.299999928 4219544.100002123, 1915562.299999928 4219531.100002122, 1915574.5999999281 4219513.600002124, 1915584.1999999282 4219499.700002123, 1915606.699999928 4219521.400002123, 1915608.5999999281 4219523.300002122, 1915635.3999999282 4219549.100002122, 1915640.499999928 4219542.400002123, 1915645.6399999282 4219535.550002122, 1915648.8999999284 4219531.200002123, 1915658.3999999282 4219518.400002124, 1915690.199999928 4219545.400002124, 1915707.9999999283 4219519.700002123, 1915722.7999999283 4219498.200002122, 1915725.499999928 4219494.400002123, 1915741.699999928 4219500.400002124, 1915749.999999928 4219491.000002121, 1915768.199999928 4219471.600002121, 1915794.779999928 4219443.050002123, 1915797.209999928 4219440.450002125, 1915799.337408553 4219437.283398501))','ZO34223','"lib_modif"=>"N", "lib_code_insee"=>"38057 / 38158", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UE3','Activités productives et de services','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UE3.pdf','2019-12-20','SRID=3945;POLYGON ((1918518.9 4224549.21, 1918549.8563840627 4224545.695090532, 1918548.9799999276 4224539.27000211, 1918547.7999999276 4224529.100002109, 1918545.0099999276 4224512.730002111, 1918542.8699999277 4224500.110002111, 1918539.8099999276 4224482.15000211, 1918537.0099999276 4224466.660002109, 1918534.6399999277 4224455.20000211, 1918531.6099999277 4224440.41000211, 1918525.6199999277 4224413.390002111, 1918525.2041169635 4224411.667138364, 1918518.1899999278 4224382.610002108, 1918506.8799999277 4224341.700002111, 1918501.3599999277 4224322.380002108, 1918495.6099999277 4224303.920002109, 1918488.3299999277 4224282.1600021105, 1918482.4999999274 4224264.250002111, 1918477.0199999276 4224248.7900021095, 1918470.7399999276 4224231.840002109, 1918464.9099999277 4224216.610002109, 1918455.6899999273 4224194.490002112, 1918453.4999999276 4224188.60000211, 1918449.8999999275 4224180.140002113, 1918443.1199999277 4224164.23000211, 1918441.170770311 4224159.641586221, 1918439.823916731 4224161.447447932, 1918431.5844133857 4224172.803422849, 1918431.110274541 4224173.456897774, 1918426.65 4224178.99, 1918425.16 4224180.99, 1918415.3177807524 4224194.201181691, 1918387.5680381698 4224231.474440144, 1918355.9075653793 4224274.001211752, 1918321.036859531 4224320.900294497, 1918282.9403813495 4224371.770211176, 1918282.6367011918 4224372.175712815, 1918236.2758518057 4224434.20236587, 1918205.4904051004 4224475.39043587, 1918198.9000606795 4224484.165092984, 1918152.0482681035 4224546.545507237, 1918125.7295214648 4224581.752403018, 1918110.247541672 4224602.452920935, 1918096.24 4224621.28, 1918095.72 4224622.52, 1918094.897452732 4224624.09654893, 1918094.88 4224624.13, 1918094.1 4224625.5, 1918088.6647137525 4224622.370206185, 1918074.0133521624 4224660.172393963, 1918045.2107619795 4224710.909249567, 1918048.0399999279 4224712.750002108, 1918049.7699999278 4224713.880002108, 1918053.9999999278 4224716.620002108, 1918084.5099999278 4224736.570002109, 1918087.829999928 4224738.7100021085, 1918101.889999928 4224747.7500021085, 1918104.4499999278 4224749.400002108, 1918104.8699999277 4224749.74000211, 1918107.079999928 4224751.070002109, 1918214.9099999277 4224816.620002109, 1918239.3099999279 4224831.580002109, 1918243.1513587814 4224794.362102736, 1918246.41 4224762.79, 1918246.78 4224756.43, 1918246.92 4224751.26, 1918246.7820058013 4224749.953744236, 1918245.89 4224741.51, 1918245.3 4224739.39, 1918244.86 4224737.19, 1918242.2009792386 4224735.414629538, 1918238.27 4224732.79, 1918238.45 4224732.51, 1918238.61 4224732.24, 1918238.74 4224731.96, 1918238.86 4224731.65, 1918238.96 4224731.35, 1918239.03 4224731.05, 1918239.08 4224730.74, 1918239.11 4224730.42, 1918239.12 4224730.11, 1918239.1 4224729.8, 1918239.07 4224729.48, 1918239.02 4224729.17, 1918238.94 4224728.87, 1918238.83 4224728.58, 1918238.71 4224728.28, 1918238.58 4224728, 1918238.42 4224727.73, 1918238.24 4224727.47, 1918238.04 4224727.22, 1918237.82 4224726.99, 1918237.61 4224726.75, 1918237.14 4224726.15, 1918236.7 4224725.52, 1918236.31 4224724.85, 1918235.97 4224724.17, 1918235.68 4224723.46, 1918235.43 4224722.73, 1918235.25 4224721.99, 1918235.1 4224721.23, 1918235.01 4224720.47, 1918234.99 4224719.71, 1918235 4224718.94, 1918235.08 4224718.17, 1918235.21 4224717.41, 1918235.87 4224715.99, 1918217.96 4224687.22, 1918213.4396026337 4224680.122553668, 1918210.47 4224675.46, 1918201.98 4224663.11, 1918202.26 4224659.49, 1918196.95 4224652.76, 1918192.36 4224648.08, 1918202.5621999279 4224643.295602106, 1918248.2413999278 4224588.621802107, 1918265.535599928 4224570.795402108, 1918285.2328999278 4224554.368002107, 1918288.3854669712 4224552.020906131, 1918292.38 4224556.87, 1918300.87 4224566.41, 1918301.26 4224566.89, 1918314.87 4224582.1, 1918334.18 4224603.76, 1918335.24 4224605.05, 1918335.36 4224605.24, 1918340.61 4224601.5, 1918353.71 4224592.39, 1918369.9 4224583.65, 1918377.75 4224579.94, 1918393.45 4224572.83, 1918395.99 4224571.65, 1918398.7 4224570.73, 1918401.08 4224569.27, 1918402.77 4224568.1, 1918404.4 4224567.11, 1918405.56 4224566.45, 1918406.95 4224565.71, 1918408.18 4224565.09, 1918409.79 4224564.34, 1918411.41 4224563.66, 1918412.65 4224563.17, 1918413.79 4224562.76, 1918414.17 4224562.62, 1918415.19 4224562.28, 1918416.85 4224561.78, 1918418.42 4224561.35, 1918418.62 4224561.3, 1918420.11 4224560.94, 1918421.29 4224560.69, 1918422.36 4224560.49, 1918423.65 4224560.28, 1918424.71 4224560.12, 1918425.96 4224559.97, 1918427.19 4224559.85, 1918428.55 4224559.75, 1918429.69 4224559.69, 1918431.15 4224559.65, 1918432.46 4224559.65, 1918433.81 4224559.67, 1918435.07 4224559.73, 1918435.93 4224559.79, 1918439.42 4224560.05, 1918442.9 4224559.77, 1918444 4224559.85, 1918466.1 4224557.08, 1918469.95 4224555.15, 1918470.94 4224554.3, 1918472 4224552.76, 1918474.43 4224554.27, 1918475.71 4224555, 1918476.91 4224555.7, 1918486.7970042003 4224554.585971358, 1918494.66 4224553.7, 1918509.13 4224551.85, 1918510.27 4224551.71, 1918510.1 4224550.28, 1918518.9 4224549.21))','ZO32274','"lib_modif"=>"N", "lib_code_insee"=>"38179 / 38421", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UD4','Pavillonnaire au développement limité','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD4.pdf','2019-12-20','SRID=3945;POLYGON ((1906759.758203011 4201509.129762898, 1906799.8099999297 4201507.850002171, 1906800.6999999296 4201503.460002172, 1906798.1 4201499.21, 1906800.21 4201480.54, 1906800.7499999297 4201477.790002172, 1906804.38 4201465.88, 1906806.23 4201460.99, 1906806.81 4201458.51, 1906779.82 4201452.1, 1906759.1101399928 4201445.152890261, 1906749.89000086 4201442.060000288, 1906735.97 4201469.84, 1906735.9043452726 4201469.97102646, 1906746.2994216443 4201486.758030292, 1906759.758203011 4201509.129762898))','ZO32418','"lib_modif"=>"N", "lib_code_insee"=>"38235 / 38187", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','N','Naturelle','N',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/N.pdf','2019-12-20','SRID=3945;POLYGON ((1909843.5 4226347.47, 1909849.9441190804 4226406.27836046, 1909871.84 4226420.95, 1909876.09 4226420.48, 1909879.49 4226420.71, 1909882.05 4226421.45, 1909884.54 4226422.39, 1909886.64 4226423.39, 1909888.96 4226424.56, 1909890.37 4226424.91, 1909892.27 4226426.71, 1909890.07 4226428.28, 1909891.68 4226432.88, 1909897.68 4226437.37, 1909904.9565517672 4226451.702912021, 1909904.0134814926 4226470.092782377, 1909919.923709734 4226477.884603429, 1909909.7 4226499.72, 1909901.5 4226495.38, 1909901.74 4226494.93, 1909900.09 4226493.74, 1909897.81 4226492.7, 1909878.63 4226485.25, 1909872.6899999306 4226482.650002104, 1909872.2899999307 4226488.150002103, 1909872.4099999308 4226494.990002103, 1909872.4599999306 4226502.980002103, 1909872.2199999306 4226505.560002104, 1909874.9999999306 4226507.790002102, 1909878.1599999308 4226512.860002103, 1909878.1899999306 4226513.260002103, 1909894.3999999308 4226526.5200021025, 1909907.2199999306 4226537.230002104, 1909923.2399999306 4226550.200002103, 1909941.819999931 4226565.130002101, 1909961.4799999306 4226581.150002103, 1909970.0899999307 4226588.210002102, 1909972.4899999304 4226590.170002104, 1909983.2099999306 4226598.980002103, 1909986.3799999307 4226601.580002102, 1910000.5599999307 4226613.300002104, 1910032.5099999306 4226639.170002103, 1910051.6199999307 4226654.630002104, 1910057.7699999306 4226659.630002103, 1910058.7799999306 4226659.520002103, 1910060.1199999307 4226659.750002104, 1910061.4699999304 4226660.340002104, 1910062.8099999307 4226661.180002102, 1910086.7199999304 4226681.080002103, 1910106.3499999307 4226696.990002102, 1910130.5899999307 4226716.690002104, 1910133.2599999306 4226714.630002103, 1910189.8499999307 4226646.350002103, 1910198.3399999305 4226636.660002104, 1910256.3299999307 4226566.940002103, 1910266.3799999305 4226554.860002104, 1910274.1499999305 4226554.900002103, 1910280.4899999306 4226554.930002103, 1910291.6399999307 4226555.170002103, 1910304.1299999307 4226555.630002101, 1910314.8199999304 4226555.800002103, 1910320.5599999307 4226555.910002103, 1910321.4299999303 4226555.670002104, 1910322.2999999304 4226555.110002103, 1910324.3399999305 4226552.640002103, 1910337.1599999308 4226537.460002102, 1910367.9399999303 4226500.540002103, 1910381.5099999304 4226484.680002104, 1910396.0999999307 4226467.120002104, 1910404.4799999304 4226458.940002103, 1910412.0999999305 4226450.000002103, 1910422.4399999303 4226437.610002105, 1910433.6299999305 4226425.100002103, 1910443.3299999305 4226414.7700021025, 1910445.5218617504 4226412.48337934, 1910428.9599999306 4226400.560002103, 1910411.1399999305 4226419.970002103, 1910399.8199999304 4226432.300002103, 1910385.4099999305 4226448.010002104, 1910378.9199999303 4226452.930002104, 1910376.9699999306 4226454.870002102, 1910363.3999999305 4226465.360002103, 1910340.5199999304 4226488.610002104, 1910315.7299999306 4226468.300002102, 1910297.1199999307 4226452.830002104, 1910278.3999999305 4226447.570002104, 1910273.62 4226442.95, 1910270.42 4226440.47, 1910267.3099999307 4226444.450002103, 1910253.1399999307 4226433.530002102, 1910226.6699999303 4226415.820002103, 1910202.3999999305 4226405.950002103, 1910191.1099999305 4226397.880002103, 1910191.3999999308 4226398.820002104, 1910191.4099999308 4226399.580002103, 1910191.3499999305 4226400.400002103, 1910190.7499999306 4226401.760002103, 1910185.9099999308 4226409.600002102, 1910168.5599999304 4226432.840002104, 1910143.7299999306 4226414.620002103, 1910151.0499999304 4226405.830002105, 1910125.8899999307 4226384.490002104, 1910084.0799999307 4226348.330002105, 1910040.5299999304 4226400.840002104, 1910038.9999999306 4226395.5600021025, 1910036.1699999305 4226379.620002104, 1910035.7099999306 4226378.390002103, 1910034.7399999306 4226376.950002104, 1910033.3499999307 4226375.650002103, 1910031.1599999308 4226374.310002103, 1910028.3099999307 4226372.980002104, 1910024.2099999306 4226371.120002105, 1910020.6499999308 4226369.910002103, 1910003.1999999306 4226363.890002104, 1909994.6199999307 4226360.8500021035, 1909983.6299999307 4226356.9700021045, 1909977.5399999307 4226354.830002104, 1909966.5899999307 4226351.110002105, 1909963.2699999306 4226349.820002103, 1909961.5099999306 4226349.150002104, 1909959.76 4226348.29, 1909957.58 4226346.4, 1909969.53 4226326.44, 1909980.5999999307 4226310.780002104, 1909987.6899999306 4226300.750002103, 1909987.3947832282 4226204.388362583, 1909901.0234999307 4226231.350202102, 1909900.7299646009 4226235.600569504, 1909900.3499999307 4226266.060002103, 1909900.4299999306 4226306.670002105, 1909900.4099999308 4226309.280002104, 1909900.1699999305 4226331.390002103, 1909899.8499999307 4226334.870002103, 1909898.6299999307 4226337.820002105, 1909896.9599999306 4226340.920002103, 1909895.3299999307 4226343.770002104, 1909893.6999999308 4226346.330002103, 1909891.2099999306 4226349.490002104, 1909889.4299999306 4226350.690002102, 1909887.6399999307 4226351.500002103, 1909885.7199999308 4226351.830002104, 1909876.5799999307 4226350.440002104, 1909876.2999999307 4226350.400002105, 1909851.225196506 4226347.430002102, 1909843.5 4226347.47))','ZO34634','"lib_modif"=>"N", "lib_code_insee"=>"38474", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UD2','Pavillonnaire en densification','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD2.pdf','2019-12-20','SRID=3945;POLYGON ((1915997.1435293488 4214122.240698445, 1915999.96 4214126.04, 1916004.31 4214131.9, 1916037.43 4214176.46, 1916038.35 4214175.95, 1916063.94 4214210.95, 1916110.91 4214275.15, 1916117.07 4214273.45, 1916144.68 4214266.09, 1916164.86 4214284, 1916179.06 4214321.6, 1916179.0607111012 4214321.600871824, 1916201.0055862586 4214308.2470309, 1916225.457069196 4214294.447639427, 1916238.0641799092 4214289.534601051, 1916212.2999999276 4214247.650002138, 1916198.1381814498 4214210.221035471, 1916169.8041476987 4214159.997487117, 1916156.8724099935 4214120.984201048, 1916131.855745249 4214074.176561974, 1916120.43 4214083.89, 1916115.19 4214087.66, 1916100.98 4214097.76, 1916094.8727607555 4214101.348272176, 1916092.47 4214102.76, 1916082 4214108.68, 1916060.17 4214119.72, 1916056.44 4214121.17, 1916053.24 4214122.04, 1916050.59 4214122.78, 1916047.57 4214123.03, 1916046.7 4214123.06, 1916045.34 4214123.1, 1916042.14 4214123.18, 1916040.54 4214123.16, 1916037.72 4214123.09, 1916035.1 4214122.83, 1916032.62 4214122.46, 1916022.83 4214120.99, 1916022.2645850102 4214122.985341305, 1916005.1207999275 4214121.436202136, 1915997.1435293488 4214122.240698445))','ZO33645','"lib_modif"=>"N", "lib_code_insee"=>"38200", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UE1','Activités productives et artisanales','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UE1.pdf','2019-12-20','SRID=3945;POLYGON ((1914669.9235952988 4212576.196050788, 1914663.9199999287 4212577.910002111, 1914619.1807831496 4212589.6605363, 1914619.6911395136 4212591.224793414, 1914641.8308062393 4212661.519010769, 1914654.1889212744 4212700.758587914, 1914695.029999929 4212689.09000211, 1914701.1758600394 4212687.324387506, 1914669.9235952988 4212576.196050788))','ZO32420','"lib_modif"=>"N", "lib_code_insee"=>"38071", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','A','Agricole','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1916366.1055905123 4215676.392896817, 1916364.8317078853 4215679.124995281, 1916366.8 4215679.98, 1916370.54 4215681.35, 1916372.99 4215682.11, 1916377.02 4215683.41, 1916379.84 4215684.23, 1916383.3 4215685.31, 1916387.25 4215686.38, 1916390.54 4215687.27, 1916393.66 4215688.12, 1916396.73 4215689.11, 1916400.22 4215690.35, 1916402.19 4215691.17, 1916404.8 4215692.11, 1916407 4215693.27, 1916409.39 4215694.39, 1916411.85 4215695.77, 1916415.42 4215697.89, 1916419.11 4215700.25, 1916421.04 4215701.63, 1916423.89 4215703.82, 1916426.02 4215705.74, 1916430.08 4215709.2, 1916432.87 4215712.01, 1916435.03 4215714.15, 1916436.47 4215715.91, 1916437.78 4215717.69, 1916439.44 4215719.83, 1916441.93 4215723.28, 1916444.99 4215727.45, 1916445.88 4215728.51, 1916448.97 4215732.69, 1916452.43 4215737.62, 1916454.04 4215739.77, 1916456.14 4215742.91, 1916460.73 4215749.01, 1916461.7888914037 4215750.612909005, 1916465.3853670135 4215747.72066827, 1916485.10358022 4215726.111810269, 1916570.2999999279 4215632.000002131, 1916570.6748708955 4215631.573288661, 1916569.8988465257 4215631.150786504, 1916561.700211078 4215625.869548708, 1916553.6811077932 4215617.491381097, 1916548.6841292537 4215610.399860655, 1916547.1619851326 4215607.300221718, 1916547.038417759 4215607.048593611, 1916544.734421666 4215602.799665751, 1916542.3406594915 4215599.418476679, 1916537.0743827075 4215591.459217449, 1916534.4412443154 4215587.5095098615, 1916529.1749675316 4215580.537677529, 1916525.8237004871 4215574.822570337, 1916521.7543047902 4215569.2869953085, 1916516.4281839519 4215561.387580132, 1916511.7902697388 4215553.936995365, 1916506.9810356093 4215546.699107574, 1916506.5199999276 4215546.910002133, 1916478.1199999277 4215560.260002134, 1916454.2299999276 4215571.480002132, 1916444.0138736346 4215561.917988712, 1916443.7230697977 4215561.648093943, 1916438.0999999277 4215556.530002132, 1916437.064122459 4215555.5803671125, 1916433.3089760258 4215552.171969326, 1916423.0399999279 4215542.81000213, 1916421.0348079759 4215541.521757804, 1916419.0150379767 4215545.570710895, 1916409.8250999276 4215562.288202133, 1916400.7292999276 4215573.502802133, 1916387.7329427842 4215585.721158632, 1916369.9980410263 4215602.679736497, 1916371.4099999275 4215604.130002133, 1916405.0899999277 4215635.250002132, 1916404.6699999275 4215635.6800021315, 1916402.5899999277 4215637.870002134, 1916399.1599999275 4215641.470002134, 1916391.2099999278 4215649.800002131, 1916385.5899999277 4215655.74000213, 1916381.7299999276 4215659.7600021325, 1916381.1599999275 4215660.340002133, 1916375.8799999275 4215665.810002131, 1916374.4799999278 4215667.260002131, 1916368.7099999276 4215673.500002133, 1916366.1010853206 4215676.391649247, 1916366.1055905123 4215676.392896817))','ZO33646','"lib_modif"=>"N", "lib_code_insee"=>"38200", "lib_modif_comment"=>NULL',1);
INSERT INTO urba_plui_ecriture.zoneurba (idurba,libelle,libelong,typezone,nomfic,urlfic,datevalid,geom,lib_idzone,lib_hstore,lib_id_version) VALUES
     ('MJ3_PH1_ZON_050_09','N','Naturelle','N',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/N.pdf','2019-12-20','SRID=3945;POLYGON ((1913258.09 4208412.52, 1913263.8 4208413.21, 1913281.33 4208425.42, 1913299.4862640533 4208433.686381837, 1913306.94 4208437.08, 1913303.16 4208440.9, 1913299.49 4208444.6, 1913283.14 4208455.15, 1913283.77 4208466.33, 1913284.51 4208479.36, 1913285.37 4208494.81, 1913285.79 4208499.93, 1913286.33 4208504.82, 1913287.06 4208508.32, 1913290.12 4208519.75, 1913293.24 4208531.39, 1913295.25 4208540.72, 1913297.59 4208550.93, 1913298.78 4208554.74, 1913301.32 4208561.42, 1913304.01 4208569.05, 1913305.81 4208572.71, 1913308.61 4208577.08, 1913328.41 4208602.99, 1913332.96 4208609.48, 1913341.04 4208621, 1913352.6 4208638.68, 1913359.22 4208648.69, 1913371.54 4208663.59, 1913374.36 4208667.39, 1913379.27 4208673.98, 1913384.55 4208679.78, 1913387.75 4208683.74, 1913398.129999928 4208692.5800021505, 1913417.34536681 4208710.197632236, 1913429.759999928 4208721.5800021505, 1913454.2399999283 4208740.77000215, 1913484 4208764.11, 1913500.9658246492 4208777.201588985, 1913468.8723455237 4208801.794305979, 1913480.85 4208813.2, 1913475.297732938 4208819.271117052, 1913467.01 4208862.76, 1913457.4491609137 4208873.213030572, 1913477.9584020074 4208916.959879007, 1913479.6261865066 4208971.254551993, 1913492.796247003 4208973.510060497, 1913502.99 4208967.4, 1913502.46 4208961.65, 1913501.15 4208950.17, 1913500.8 4208940.68, 1913500.33 4208928.16, 1913502.59 4208910.51, 1913506.48 4208894.29, 1913588.44 4208877.47, 1913619.96 4208890.34, 1913633.07 4208911.38, 1913653.1 4208979.24, 1913650.72 4208981.76, 1913711.74 4209002.26, 1913718.09 4209011.72, 1913716.11 4209019.35, 1913725.0484190197 4209022.664014257, 1913737.2875240168 4209030.750565772, 1913747.3683921904 4209041.5943326065, 1913749.8718033328 4209049.29990888, 1913751.173413883 4209061.5281242225, 1913750.963968963 4209075.1883672215, 1913751.2860100137 4209097.234261944, 1913751.1929727322 4209105.270790596, 1913751.2058365692 4209114.197026126, 1913753.0069883286 4209126.949999816, 1913757.060004158 4209139.348516555, 1913762.8631991425 4209147.681147987, 1913768.9173608946 4209159.457055763, 1913775.984009831 4209182.184424342, 1913779.351916023 4209198.701000208, 1913780.2316171126 4209215.301034758, 1913778.4262400765 4209230.039329043, 1913775.0255413894 4209240.990848611, 1913763.51 4209248.29, 1913751.41 4209254.77, 1913719.9171748313 4209266.001502986, 1913697.18469799 4209274.108742657, 1913695.0293291174 4209274.877426692, 1913691.8340969416 4209266.001861006, 1913688.333382287 4209255.52624795, 1913680.9288189746 4209245.28581546, 1913674.6729980465 4209237.924198057, 1913666.95793586 4209230.222528855, 1913661.1037127583 4209224.876012863, 1913655.1825457283 4209220.3619218385, 1913649.581605548 4209216.151295927, 1913643.3378476019 4209209.620012733, 1913638.1032181652 4209201.53314278, 1913634.1275653697 4209189.516599205, 1913629.9984133018 4209177.870962189, 1913625.4217008054 4209162.073979404, 1913619.7105288706 4209143.040001361, 1913616.8165522127 4209130.193493992, 1913614.482630587 4209121.596852583, 1913612.523298328 4209114.061213447, 1913611.5639008877 4209106.556145507, 1913609.2050548273 4209098.148216072, 1913606.5819753234 4209092.158239662, 1913602.0799815732 4209087.1365817, 1913597.7302148477 4209083.1195748495, 1913592.0630223753 4209079.059189771, 1913586.7933040042 4209075.998265467, 1913580.691370786 4209072.934188178, 1913575.239165848 4209070.060223751, 1913571.293356176 4209068.446724751, 1913569.05 4209071.08, 1913561.33 4209081.09, 1913554.1 4209091.03, 1913552.44 4209094.05, 1913549.99 4209098.15, 1913549.02 4209105.16, 1913543.43 4209122.78, 1913538.18 4209136.69, 1913529.51 4209159.47, 1913526.65 4209167.44, 1913518.02 4209182.94, 1913516.9796491805 4209181.21257775, 1913493.45 4209135.03, 1913488.34 4209137.19, 1913480.1 4209121.58, 1913473.92 4209106.64, 1913467.45 4209091.84, 1913464.77 4209084.86, 1913460.26 4209078.47, 1913455.778062899 4209070.201246751, 1913447.98 4209049.84, 1913445.38 4209041.89, 1913445.03 4209035.07, 1913443.31 4209026.92, 1913433.88 4209010.09, 1913445.1684802833 4209004.417584385, 1913441.5063883632 4208996.974222912, 1913436.7959853006 4208987.973485344, 1913434.4902860955 4208982.872749736, 1913432.8843518342 4208977.071024981, 1913431.679507642 4208972.269489128, 1913431.276143823 4208968.667900021, 1913431.372612027 4208964.565604412, 1913431.9657638455 4208956.360663572, 1913434.3439679735 4208929.944348808, 1913434.3392453687 4208924.541441377, 1913435.1346911048 4208918.837672903, 1913436.399382261 4208911.255790879, 1913430.1241283724 4208909.837200395, 1913428.2218811805 4208908.4381083315, 1913424.9172187676 4208905.139217762, 1913423.0451399735 4208902.272868821, 1913419.04 4208897.06, 1913408.0837779157 4208877.238891317, 1913404.07620363 4208871.03905221, 1913401.171232677 4208867.139489119, 1913396.2640487961 4208861.940975251, 1913381.1435072299 4208847.746536724, 1913360.11480982 4208827.854189352, 1913337.3842397751 4208806.862735991, 1913326.16 4208801.16, 1913320.36 4208794.61, 1913320.03 4208794.17, 1913319.47 4208793.38, 1913318.76 4208792.37, 1913318.22 4208791.57, 1913317.84 4208790.99, 1913317.4 4208790.29, 1913317.11 4208789.83, 1913316.47 4208788.77, 1913315.78 4208787.57, 1913314.92 4208786, 1913313.98 4208784.16, 1913312.53 4208781.76, 1913311.25 4208779.26, 1913309.97 4208776.24, 1913308.82 4208772.68, 1913308.08 4208769.49, 1913307.46 4208764.62, 1913306.8179265475 4208749.758685823, 1913307.1046281126 4208734.350143456, 1913307.091081 4208718.841810505, 1913306.4807948205 4208707.436206783, 1913304.5720823668 4208698.633137261, 1913302.44 4208684.4, 1913301.22 4208698, 1913301.2023813324 4208703.248013793, 1913301.07 4208742.68, 1913301.11 4208751.49, 1913301.05 4208763.66, 1913303.19 4208778.05, 1913305.97 4208786.86, 1913307.36 4208789.64, 1913308.75 4208791.96, 1913310.03 4208794.51, 1913311.19 4208796.13, 1913312.46 4208798.1, 1913313.97 4208800.3, 1913320.32 4208808.05, 1913338.55 4208823.92, 1913361.14 4208843.91, 1913382.58 4208864.59, 1913387.62 4208871.11, 1913388.93 4208872.64, 1913391.66 4208876.17, 1913390.26 4208877.79, 1913394.12 4208904.62, 1913387.81 4208958.75, 1913380.99 4208984.3, 1913372.7 4209009.49, 1913367.25 4209026.42, 1913359.559999928 4209017.540002151, 1913353.5799999284 4209010.64000215, 1913351.4999999283 4209007.81000215, 1913345.409999928 4208998.620002151, 1913336.499999928 4208984.500002151, 1913324.5399999283 4208966.110002152, 1913314.1299999282 4208949.98000215, 1913306.4099999282 4208940.28000215, 1913300.5299999283 4208932.780002151, 1913299.2699999283 4208930.510002151, 1913293.429999928 4208919.91000215, 1913286.449999928 4208907.59000215, 1913280.039999928 4208895.690002151, 1913271.9199999282 4208880.59000215, 1913257.0802775784 4208851.857074322, 1913248.8499999281 4208836.470002151, 1913247.239999928 4208833.340002151, 1913237.739999928 4208837.940002152, 1913209.429999928 4208790.970002151, 1913204.1499999282 4208783.15000215, 1913196.8599999284 4208773.070002151, 1913184.4599999283 4208758.660002151, 1913113.5699999284 4208678.260002149, 1913020.8699999284 4208570.770002152, 1912979.7399999283 4208523.78000215, 1912971.929999928 4208515.510002152, 1912961.1899999282 4208505.760002153, 1912949.9199999282 4208497.3700021515, 1912939.0099999283 4208490.590002152, 1912927.0999999284 4208484.360002153, 1912915.0899999284 4208479.38000215, 1912901.1099999284 4208476.1600021515, 1912896.5999999284 4208473.750002151, 1912898.4699999283 4208468.170002152, 1912871.7493480379 4208458.596403434, 1912842.3499999284 4208448.050002153, 1912838.1999999282 4208442.4100021515, 1912822.2299999283 4208434.300002152, 1912806.2599999283 4208426.190002151, 1912797.2799999283 4208422.300002151, 1912793.7199999283 4208429.730002154, 1912781.3099999283 4208424.490002153, 1912765.9799999283 4208417.720002151, 1912760.7 4208416.23, 1912752.45 4208413.01, 1912742.32 4208409.07, 1912732.74 4208405.31, 1912713.89 4208398, 1912715.6199999284 4208389.640002152, 1912712.166925081 4208388.915744758, 1912707.805937849 4208387.981155544, 1912701.5499999283 4208386.650002151, 1912697.0499999283 4208385.840002152, 1912690.2599999283 4208384.170002153, 1912685.1199999284 4208382.780002152, 1912678.5899999284 4208380.560002152, 1912672.1699999282 4208378.150002153, 1912671.3799999282 4208380.7400021525, 1912670.2599999283 4208385.550002151, 1912667.6299999282 4208385.00000215, 1912665.2599999283 4208384.52000215, 1912666.6399999282 4208377.840002151, 1912652.8599999286 4208368.6600021515, 1912647.8369532297 4208367.4814350065, 1912647.5207388639 4208356.4220058415, 1912645.7899999283 4208329.170002152, 1912644.692838929 4208326.108200754, 1912644.0799999284 4208322.680002153, 1912643.7199999283 4208318.620002153, 1912644.5599999283 4208309.210002151, 1912645.5799999284 4208299.00000215, 1912645.5899999284 4208291.820002153, 1912645.8699999284 4208282.720002152, 1912645.8399999284 4208279.940002153, 1912645.7499999285 4208276.4900021525, 1912645.6199999286 4208272.420002151, 1912645.2199999285 4208268.400002151, 1912644.6599999284 4208262.88000215, 1912643.3599999284 4208252.210002153, 1912642.6899999282 4208245.540002151, 1912642.1199999284 4208239.800002152, 1912641.2099999283 4208230.680002151, 1912640.8099999283 4208226.6500021545, 1912640.5999999284 4208223.360002152, 1912638.7099999283 4208215.750002151, 1912637.6499999282 4208212.120002152, 1912637.2599999283 4208209.480002152, 1912636.8199999284 4208207.710002152, 1912635.8799999282 4208197.460002152, 1912633.7699999283 4208178.370002153, 1912635.9599999283 4208153.540002151, 1912639.8999999282 4208132.330002153, 1912640.9399999285 4208127.250002152, 1912641.9199999284 4208122.360002153, 1912642.6899999282 4208118.540002153, 1912643.1499999284 4208115.550002151, 1912642.7499999283 4208104.530002153, 1912642.4999999283 4208093.270002152, 1912643.6899999282 4208090.990002153, 1912645.6599999284 4208088.330002153, 1912648.2899999283 4208085.100002153, 1912653.4099999282 4208079.470002153, 1912642.6799999282 4208073.210002152, 1912656.5899999284 4208069.420002152, 1912664.5899999286 4208067.110002152, 1912665.4899999283 4208066.830002154, 1912666.4199999282 4208066.100002153, 1912671.0099999283 4208059.690002153, 1912675.05 4208058.17, 1912670.44 4208040.49, 1912665.78 4208023.15, 1912664.68 4208019.01, 1912656.46 4208002.78, 1912647.03 4207983.12, 1912645.01 4207977.49, 1912643.35 4207971.67, 1912641.51 4207964.38, 1912639.93 4207958.12, 1912638.9 4207952.94, 1912637.22 4207942.59, 1912635.93 4207932.85, 1912634.58 4207923.66, 1912634.04 4207918.8, 1912634.01 4207915.04, 1912634.22 4207910.9, 1912634.3438854539 4207908.54079005, 1912631.83 4207905.07, 1912595.75 4207855.56, 1912603.45 4207843.9, 1912610.49 4207837.57, 1912622.73 4207826.57, 1912632.71 4207817.58, 1912637.13 4207813.31, 1912640.9 4207807.63, 1912652.19 4207789.11, 1912656.11 4207782.92, 1912688.41 4207754.13, 1912691.7217911 4207751.178097035, 1912693.37 4207744.27, 1912696.34 4207731.87, 1912699.1 4207719.78, 1912701.87 4207707.59, 1912703.77 4207699.27, 1912707.05 4207684.84, 1912709.04 4207674.8, 1912709.81 4207670.91, 1912710.19 4207667.49, 1912710.16 4207663.69, 1912710.12 4207658.27, 1912709.51 4207651.03, 1912709.49 4207648.84, 1912710.21 4207647.43, 1912710.85 4207646.46, 1912712.96 4207644.23, 1912712.7475637826 4207640.9989965875, 1912709.3163202896 4207640.948032908, 1912697.5807348036 4207637.507491731, 1912681.4178895934 4207632.375314022, 1912681.04 4207633.95, 1912672.13 4207685.61, 1912667.39 4207712.62, 1912636.48 4207701.12, 1912627.130185313 4207750.9128090255, 1912568.75 4207776.76, 1912535.1380274515 4207791.734494601, 1912511.02 4207730.9, 1912558.32 4207698.2, 1912556.85 4207667.15, 1912555.74 4207643.61, 1912554.73 4207615.39, 1912554.07 4207601.77, 1912551.72 4207561.55, 1912550.41 4207526.66, 1912542.24 4207497.05, 1912542.08 4207491.79, 1912542.98 4207463.27, 1912549.21 4207437.25, 1912550.55 4207416.91, 1912552.84 4207385.83, 1912561.58 4207380.17, 1912568.32 4207371.3, 1912569.81 4207369.6, 1912571.79 4207367.21, 1912585.61 4207368.4, 1912595.18 4207369.17, 1912600.56 4207378.4, 1912606.17 4207388.04, 1912617.08 4207407.68, 1912629.64 4207428.84, 1912641.31 4207449.17, 1912647.07 4207458.85, 1912654.15 4207473.83, 1912661.08 4207488.86, 1912665.31 4207497.44, 1912677.3999990383 4207492.0300004305, 1912678.8846033704 4207491.331984341, 1912677.6810890532 4207488.031272158, 1912675.5746559235 4207481.929852836, 1912674.3709674524 4207478.429034246, 1912672.9657785252 4207473.327537831, 1912671.0598006505 4207467.626157595, 1912668.952061051 4207460.023939938, 1912666.1419450818 4207450.121107636, 1912664.0347285196 4207443.119209941, 1912660.7235627004 4207432.316334681, 1912658.2170917988 4207426.415371517, 1912653.706245947 4207416.7141278535, 1912650.197936369 4207409.313237649, 1912648.695047201 4207406.913266812, 1912644.6887366734 4207402.114196295, 1912643.1854991629 4207399.314012585, 1912636.7693749284 4207384.711816856, 1912630.954528929 4207371.209684544, 1912624.137496554 4207355.8074128525, 1912618.9244519 4207344.005663668, 1912614.312162452 4207332.703658339, 1912610.9032988634 4207324.60231056, 1912610.7024086062 4207323.702005983, 1912610.9970811447 4207317.398393401, 1912612.085124403 4207302.989775858, 1912612.9746289328 4207290.382290638, 1912613.569373845 4207283.978364449, 1912613.4637464893 4207277.575048098, 1912612.9556419454 4207268.570697772, 1912612.3406908163 4207251.762287721, 1912610.9185211386 4207227.150429222, 1912610.8098456173 4207217.245253984, 1912610.0922289174 4207197.435340181, 1912609.7766538984 4207179.726195484, 1912609.566096415 4207167.7199934665, 1912609.7624576653 4207163.417534618, 1912609.8592883423 4207159.715481711, 1912611.4552611504 4207154.111113036, 1912616.3431451835 4207137.197867521, 1912618.2378835229 4207129.992388162, 1912618.9346843816 4207125.889600728, 1912619.2324921174 4207123.187905336, 1912619.628175542 4207117.984795063, 1912619.3233129906 4207112.582188363, 1912619.319219455 4207107.879692245, 1912619.1148455173 4207102.977264198, 1912618.209228905 4207097.074914879, 1912617.5027604932 4207090.071807398, 1912616.2967233984 4207083.869560376, 1912614.9916784053 4207078.868037749, 1912612.484428662 4207072.06660465, 1912608.272270322 4207060.664210139, 1912605.3636764532 4207052.562435708, 1912602.6548405942 4207044.060275, 1912599.3425513194 4207031.95672627, 1912597.8423647683 4207032.658404114, 1912591.4397515631 4207033.564455277, 1912585.14 4207032.55, 1912582.63 4207032.77, 1912554.24 4207033.84, 1912551.12 4207031.05, 1912544.692789489 4207032.124332494, 1912528.2771495366 4207035.989950934, 1912519.486839111 4207037.843329638, 1912511.014250749 4207041.126457629, 1912499.3114880738 4207046.633640064, 1912494.0161203477 4207048.116343027, 1912489.885733521 4207048.804740831, 1912484.8551341812 4207048.0104356725, 1912481.3072378046 4207046.315918, 1912477.494573041 4207044.118340394, 1912473.4965704079 4207041.708948079, 1912473.52 4207041.25, 1912474.15 4207031.29, 1912471.61 4207018.06, 1912480.28 4207008.22, 1912488.01 4206999.3, 1912517.44 4206986.51, 1912500.7677141982 4206977.158415494, 1912495.684161181 4206960.21323877, 1912498.99 4206948.08, 1912521.5255556854 4206936.701806065, 1912526.78 4206917.04, 1912529.27 4206912.66, 1912520.5194358174 4206908.530449759, 1912527.7476127637 4206892.035379293, 1912551.2590454684 4206889.069973368, 1912572.970053146 4206873.607499608, 1912584.1962327256 4206860.263172938, 1912589.66 4206840.05, 1912592.9865431513 4206830.820928379, 1912586.5261945252 4206826.16100478, 1912572.6523310824 4206813.028492819, 1912564.0738353657 4206802.093558463, 1912569.1838652217 4206797.777833768, 1912571.884502762 4206795.02424255, 1912574.0556035298 4206792.270651332, 1912578.2389440336 4206784.96304387, 1912580.9925352514 4206779.985398208, 1912584.4345242735 4206773.419142227, 1912587.6646985866 4206768.388542887, 1912592.218714831 4206759.227556721, 1912596.1902406255 4206751.866995581, 1912598.2024803616 4206747.312979337, 1912600.2147200976 4206741.276260129, 1912601.6444693836 4206735.927938724, 1912602.6505892517 4206730.526663643, 1912603.3389870562 4206725.707879012, 1912603.709662797 4206718.717993613, 1912604.027384861 4206709.13337803, 1912605.3512267924 4206687.26350932, 1912605.7748562107 4206681.968141593, 1912606.3573466607 4206678.049569476, 1912607.045744465 4206675.084163549, 1912607.8930033012 4206672.436479687, 1912611.0172702598 4206666.770436219, 1912614.5651666364 4206660.786670689, 1912619.4369049445 4206652.949526453, 1912623.4613844166 4206646.2244094405, 1912627.962446984 4206638.863848302, 1912629.9217330425 4206636.269118115, 1912633.1519073558 4206632.350545998, 1912638.6590897911 4206627.055178272, 1912644.1662722265 4206623.877957636, 1912657.4576452195 4206613.55199057, 1912666.3009093225 4206605.079402207, 1912672.0199064668 4206596.818628555, 1912677.65 4206592.77, 1912697.76 4206590.39, 1912701.812626129 4206590.333354712, 1912707.596874989 4206568.716877169, 1912710.8930441404 4206562.3106174, 1912713.0909838679 4206558.606743955, 1912714.989374785 4206555.603502098, 1912717.6869688851 4206551.198822924, 1912719.9846999014 4206547.194703832, 1912723.6817769986 4206541.588518954, 1912728.3784241886 4206534.88088123, 1912733.7749183956 4206527.572316448, 1912739.571013785 4206519.56303317, 1912746.068524513 4206512.753774401, 1912751.166950542 4206507.84673999, 1912763.4630818833 4206495.929731119, 1912774.7624310297 4206488.315866372, 1912790.4621873444 4206478.497003797, 1912798.061584263 4206473.187578815, 1912811.6552605003 4206457.667534018, 1912820.451454885 4206447.954738053, 1912826.4481742596 4206440.54559813, 1912830.1455960234 4206435.339625539, 1912840.2391628725 4206421.823689201, 1912845.5351625525 4206414.014948602, 1912856.5292030242 4206400.498228213, 1912859.7275800793 4206396.693431368, 1912863.9266595275 4206393.08786831, 1912880.0248734518 4206381.26759924, 1912964.13 4206297.09, 1912959.28 4206285.61, 1913002.32 4206268.6, 1912995.74 4206253.97, 1912990.32 4206241.91, 1912983.46 4206226.65, 1912977.28 4206216.04, 1912999.96 4206143.47, 1912953.17 4206142.25, 1912953.81 4206123.99, 1912903.9 4206127.64, 1912902.03 4206120.99, 1912898.08 4206121.94, 1912889.62 4206123.59, 1912888.99 4206111.31, 1912880.39 4206099.5, 1912874.37 4206092.39, 1912870.52 4206072.59, 1912866.99 4206070.39, 1912868 4206046.89, 1912868.81 4206028.14, 1912866.94 4206013.43, 1912866.56 4206010.5, 1912866.76 4206007.84, 1912870.52 4205989.91, 1912872.69 4205978.99, 1912876.48 4205968.57, 1912883 4205950.62, 1912890.42 4205941.59, 1912901.52 4205928.95, 1912912.23 4205916.03, 1912924.16 4205901.13, 1912934.61 4205888.08, 1912943.12 4205877.46, 1912948.47 4205870.17, 1912950.8837934078 4205866.7103500785, 1912949.917082387 4205845.102991243, 1912949.9247420896 4205845.094520513, 1912948.24 4205840.22, 1912949.1 4205835.06, 1912950.46 4205827.79, 1912950.83 4205820.61, 1912931.97 4205813.42, 1912906.57 4205803.73, 1912903.9 4205803.88, 1912903.4550944678 4205805.434780057, 1912898.772084054 4205810.562003787, 1912881.9972176328 4205828.681359954, 1912862.3743990916 4205857.3117963495, 1912861.3283145053 4205858.838073431, 1912829.1800564844 4205885.134079078, 1912788.2685973763 4205920.079232194, 1912753.500813582 4205954.8334518885, 1912739.480867521 4205971.607135559, 1912721.0219586557 4206039.505072899, 1912720.1938055493 4206059.718788242, 1912716.2031180472 4206077.984467588, 1912694.2807898598 4206106.802654487, 1912686.7377700026 4206113.493735193, 1912665.2470303427 4206125.324811749, 1912654.94 4206128.45, 1912549.2485838227 4206176.743258021, 1912483.1437401713 4206209.869022595, 1912483.1495017356 4206301.106050009, 1912444.6573625572 4206390.33915787, 1912340.3518158207 4206590.819986704, 1912273.2214700978 4206766.261136033, 1912233.545739255 4206917.558245715, 1912219.7637585013 4206981.623800157, 1912216.8916676368 4207064.949320283, 1912223.3556254047 4207135.816066038, 1912230.0680190097 4207176.7263201745, 1912241.7292552968 4207246.451042965, 1912248.1213833028 4207288.720886378, 1912255.862291699 4207367.9978022715, 1912258.8881068535 4207439.154057396, 1912258.8967052372 4207468.035123886, 1912255.200172958 4207525.8554531485, 1912252.420796092 4207629.352423637, 1912251.9895895368 4207661.092536352, 1912249.9864060928 4207707.314584935, 1912250.0815934476 4207714.346249335, 1912250.8240983535 4207719.641828288, 1912256.2811973917 4207752.076997718, 1912262.1178858513 4207773.589919231, 1912271.9285004553 4207805.949478278, 1912282.8987282242 4207843.052929958, 1912286.4035672012 4207855.768800917, 1912287.927838464 4207861.310806911, 1912288.8726036046 4207864.470908804, 1912317.7237482267 4207961.338367277, 1912331.7571209 4208000.242670414, 1912353.217408531 4208056.932278462, 1912364.422201739 4208089.003688205, 1912367.5196363116 4208097.869455872, 1912378.681631644 4208162.219244198, 1912386.6634158178 4208200.639992159, 1912389.2970731603 4208213.317243607, 1912394.1560530069 4208238.80785126, 1912420.855041655 4208344.861509624, 1912424.7556376858 4208361.746820411, 1912430.0526667964 4208384.677157742, 1912432.9145297068 4208397.0658912305, 1912466.984876752 4208539.731514646, 1912469.5513293713 4208551.3619267605, 1912471.839883219 4208562.606793684, 1912479.8161808122 4208609.289729084, 1912475.616804573 4208723.7681197105, 1912505.3713973537 4208846.206335681, 1912516.9076093356 4208953.488488159, 1912523.8500924069 4209091.570665039, 1912517.984459926 4209196.052243607, 1912505.0700959377 4209395.838688405, 1912495.439074687 4209481.496771149, 1912502.2790545742 4209534.301299745, 1912521.466551516 4209641.726998668, 1912530.4290434278 4209681.984139035, 1912561.3167478708 4209795.118311721, 1912574.3026064574 4209840.335130934, 1912580.048032512 4209859.762435946, 1912592.9310834089 4209897.570955586, 1912603.9337356456 4209927.936348832, 1912613.9616061284 4209955.844033761, 1912626.628560728 4209995.491324435, 1912645.5091798448 4210042.081084357, 1912658.500956069 4210082.9376144, 1912685.964593938 4210173.700998891, 1912710.1535827832 4210242.776297522, 1912811.1333313594 4210411.958975212, 1912818.2497871092 4210407.67964824, 1912819.7943367378 4210410.076020303, 1912867.5798238663 4210380.817036658, 1912973.3524791722 4210316.059713683, 1913209.766112996 4210173.4933450315, 1913285.4412142104 4210127.435969549, 1913327.2056909348 4210101.723892216, 1913369.5575121478 4210076.215738641, 1913731.4589030738 4209854.155641587, 1913739.9634347234 4209856.258340878, 1913759.2531323493 4209852.771569805, 1913774.3237129122 4209850.233823535, 1913806.9455701513 4209844.754810212, 1913812.6259153385 4209844.060498441, 1913818.4407248874 4209842.806071051, 1913839.577565222 4209838.89624551, 1913865.825617286 4209834.040964269, 1913867.4924872003 4209833.404729057, 1913890.278936411 4209818.05717514, 1913890.343648593 4209818.013588985, 1913890.5217068698 4209817.896530487, 1913890.58618724 4209817.854077786, 1913898.2497130272 4209812.768649941, 1913902.3937240795 4209810.016834968, 1913920.1976581535 4209798.197417758, 1913920.676283736 4209798.12713308, 1913925.7637320946 4209796.979135558, 1913930.870274863 4209799.924966776, 1913934.2467671416 4209801.541419154, 1913954.6282577608 4209805.978493035, 1913960.8786315948 4209803.653551707, 1913973.5038974953 4209792.030162299, 1913983.4349213308 4209773.280681055, 1913995.1849462476 4209759.112185041, 1914032.9473712808 4209726.541292368, 1914056.0153460389 4209705.354285807, 1914084.503884462 4209692.379775128, 1914123.1716937367 4209676.100924976, 1914161.7891409982 4209647.967491892, 1914174.6337120715 4209641.085604, 1914199.2423686716 4209629.175071363, 1914227.181972719 4209606.878761807, 1914268.8626129325 4209588.402775427, 1914302.168553654 4209569.1518208, 1914329.7569405837 4209552.053622197, 1914357.6170312027 4209535.023634145, 1914378.0363273444 4209518.609182574, 1914399.3976256275 4209502.202733352, 1914405.0412381934 4209499.473385098, 1914414.574529776 4209496.608146485, 1914423.9195980425 4209489.410560447, 1914437.5988576123 4209470.358420025, 1914751.7927419266 4209343.906806404, 1914828.5963734633 4209313.074482225, 1914918.655438571 4209278.33024466, 1914978.657722387 4209254.485867729, 1915160.3679252828 4209181.991298674, 1915279.0075538368 4209134.529247391, 1915291.3372773067 4209129.617104862, 1915325.9618707183 4209115.791932795, 1915330.8159401529 4209113.992769964, 1915452.1852518944 4209135.360197537, 1915527.1384215944 4209149.035833806, 1915566.2761373683 4209156.220612554, 1915574.4863562754 4209158.136437247, 1915584.3328430415 4209143.652158674, 1915618.3024262406 4209098.7236795295, 1916005 4208590.15, 1916035.93 4208549.49, 1916023.4649598936 4208507.1414087275, 1915987.9972131648 4208452.043192909, 1915965.1010937493 4208377.529494567, 1915973.28 4208368.18, 1915921.679999927 4208284.240002153, 1915908.0761490006 4208250.4057117365, 1915892.9421494985 4208221.103386176, 1915904.5347351583 4208207.4468961805, 1915933.4480765318 4208203.258034305, 1915918.220481377 4208181.259709884, 1915897.0972514818 4208167.77115218, 1915869.9199999273 4208120.1100021545, 1915858.7121151502 4208094.665932003, 1915830.5801135325 4208075.480516188, 1915785.027234588 4208043.203479898, 1915764.9841919946 4208006.601601518, 1915765.8657559166 4207985.189372547, 1915822.4840562446 4207971.632121784, 1915849.7299999273 4207947.240002153, 1915850.1748877205 4207944.493153697, 1915831.96375324 4207942.908392946, 1915804.8538780147 4207948.135131269, 1915790.8458705829 4207947.547188146, 1915770.132958955 4207945.464365879, 1915749.1194454564 4207942.881540007, 1915720.599717531 4207937.804005668, 1915705.089142247 4207935.216315215, 1915700.185730169 4207934.320164734, 1915684.3749067115 4207931.632684694, 1915677.91 4207913.83, 1915724.5633204542 4207894.177190325, 1915737.624973201 4207842.838230817, 1915705.2299999273 4207838.410002153, 1915702.4512768788 4207780.636065502, 1915775.1803308371 4207769.565944124, 1915777.041918653 4207724.9404815445, 1915816.7647648628 4207726.806397416, 1915826.7862770173 4207745.107313335, 1915837.592478068 4207745.59803053, 1915890.5299999272 4207765.410002155, 1915907.3450348303 4207762.945668629, 1915925.0251059055 4207729.712308927, 1915936.979999927 4207691.080002154, 1915954.688477877 4207670.354426131, 1915976.4977948691 4207667.73375322, 1915970.4692048964 4207639.023769358, 1915988.479414312 4207639.708216014, 1915986.0543340065 4207612.796009258, 1916009.2739482273 4207620.979848417, 1916030.2985869334 4207636.169361827, 1916100.7098732956 4207719.551581737, 1916113.1217072073 4207725.443748992, 1916129.9203926243 4207713.822690655, 1916144.7210210243 4207705.605215013, 1916153.332246432 4207713.10159756, 1916161.4574632 4207736.7070060335, 1916153.2715101626 4207757.525357933, 1916179.405531494 4207780.214349927, 1916183.630089889 4207805.424071415, 1916198.567000939 4207838.128320068, 1916225.3887413563 4207846.509063376, 1916253.229999927 4207874.740002154, 1916257.909999927 4207899.810002153, 1916270.2934512566 4207937.718054296, 1916313.3577972793 4207984.40489151, 1916340.7034007534 4208019.399393942, 1916378.64 4208101.95, 1916404.27 4208069.05, 1916406.3 4208066.39, 1916427.5 4208039.24, 1916465.1299999268 4207990.5300021535, 1916485.16 4207964.61, 1916486.449999927 4207963.000002154, 1916482.829999927 4207959.660002154, 1916477.6599999268 4207954.540002152, 1916472.1299999268 4207948.760002154, 1916468.139999927 4207944.410002154, 1916462.699999927 4207937.140002153, 1916458.7899999272 4207930.970002154, 1916453.2499999271 4207921.490002154, 1916449.179999927 4207913.600002153, 1916445.619999927 4207905.580002154, 1916441.259999927 4207894.580002154, 1916436.619999927 4207882.890002153, 1916431.669999927 4207868.4900021525, 1916426.239999927 4207853.720002154, 1916420.5099999271 4207838.140002153, 1916415.7499999271 4207826.870002153, 1916412.449999927 4207818.600002154, 1916411.219999927 4207815.540002154, 1916407.7799999272 4207809.210002152, 1916405.8099999272 4207806.230002154, 1916400.5499999272 4207799.260002152, 1916398.499999927 4207796.940002155, 1916393.7899999272 4207792.420002154, 1916386.949999927 4207786.910002154, 1916380.5399999272 4207782.240002155, 1916377.5099999271 4207780.160002154, 1916372.5399999272 4207777.550002153, 1916354.1199999272 4207769.220002153, 1916348.0899999272 4207766.290002154, 1916343.389999927 4207764.000002153, 1916339.579999927 4207762.6500021545, 1916323.989999927 4207757.480002155, 1916313.159999927 4207754.060002154, 1916303.0699999272 4207750.870002155, 1916285.23 4207734.29, 1916271.989999927 4207721.620002152, 1916242.1299999268 4207693.370002153, 1916218.909999927 4207671.840002154, 1916210.949999927 4207664.460002153, 1916206.179999927 4207660.020002153, 1916194.5899999272 4207647.350002155, 1916190.159999927 4207638.700002155, 1916184.949999927 4207629.870002155, 1916183.3699999272 4207626.910002154, 1916177.229999927 4207618.010002153, 1916167.0999999272 4207606.650002157, 1916156.199999927 4207594.120002155, 1916143.669999927 4207579.740002155, 1916137.2599999271 4207570.380002154, 1916130.699999927 4207561.330002155, 1916115.2499999271 4207538.800002155, 1916110.2599999271 4207531.750002155, 1916104.219999927 4207523.4400021555, 1916089.0799999272 4207502.250002155, 1916080.7699999271 4207490.260002155, 1916066.389999927 4207470.810002156, 1916063.3299999272 4207462.340002155, 1916058.199999927 4207443.600002156, 1916051.0599999272 4207416.680002154, 1916043.0199999271 4207385.870002156, 1916036.2699999271 4207359.170002155, 1916030.3499999272 4207336.540002157, 1916026.719999927 4207321.660002154, 1916022.929999927 4207306.150002155, 1916022.159999927 4207301.110002156, 1916021.719999927 4207293.610002156, 1916021.929999927 4207290.490002157, 1916022.989999927 4207277.080002156, 1916024.449999927 4207260.940002155, 1916026.2599999271 4207235.820002155, 1916028.2599999271 4207207.750002157, 1916028.3699999272 4207203.060002155, 1916028.959999927 4207195.100002156, 1916026.8099999272 4207186.940002156, 1916016.139999927 4207169.080002155, 1916000.889999927 4207144.860002157, 1915999.0799999272 4207141.970002157, 1915995.3399999272 4207135.430002155, 1915993.7899999272 4207131.620002156, 1915983.8599999272 4207105.120002155, 1915977.5999999272 4207089.220002157, 1915965.709999927 4207059.390002157, 1915962.479999927 4207047.920002156, 1915955.0499999272 4207021.590002156, 1915951.219999927 4207009.660002154, 1915949.7899999272 4207005.200002157, 1915944.6199999272 4206990.200002157, 1915940.0799999272 4206979.5200021565, 1915933.8599999272 4206964.890002156, 1915929.5999999272 4206954.890002156, 1915922.689999927 4206940.240002156, 1915915.909999927 4206925.860002155, 1915903.459999927 4206900.3100021565, 1915889.0199999271 4206870.640002157, 1915878.3099999272 4206849.200002157, 1915874.0799999272 4206837.980002157, 1915883.949999927 4206822.900002156, 1915889.4999999271 4206813.120002156, 1915891.0799999272 4206809.300002156, 1915897.0199999271 4206789.8100021565, 1915904.0299999272 4206767.680002156, 1915911.5099999271 4206742.160002156, 1915920.8399999272 4206712.460002157, 1915927.8399999272 4206690.150002158, 1915926.9999999271 4206684.130002157, 1915922.969999927 4206671.500002156, 1915911.469999927 4206641.460002157, 1915905.5099999271 4206625.910002158, 1915900.439999927 4206613.500002157, 1915893.0099999271 4206597.200002157, 1915881.909999927 4206572.830002156, 1915877.3299999272 4206562.780002159, 1915872.039999927 4206551.170002159, 1915871.929999927 4206535.880002158, 1915871.7999999272 4206518.240002158, 1915872.3199999272 4206509.930002156, 1915874.949999927 4206475.550002157, 1915875.0099999271 4206465.650002156, 1915874.459999927 4206445.900002156, 1915876.3399999272 4206430.400002156, 1915878.159999927 4206415.280002157, 1915877.7799999272 4206393.850002157, 1915877.5599999272 4206364.980002157, 1915877.909999927 4206342.1000021575, 1915877.8299999272 4206331.610002157, 1915876.489999927 4206328.03000216, 1915875.389999927 4206325.590002159, 1915871.3099999272 4206319.920002158, 1915868.429999927 4206318.080002156, 1915846.2699999271 4206305.780002157, 1915832.189999927 4206297.830002157, 1915809.179999927 4206285.550002157, 1915792.5199999271 4206276.210002156, 1915786.2499999271 4206264.660002157, 1915779.8399999272 4206252.900002158, 1915773.5699999272 4206237.61000216, 1915756.879999927 4206198.950002159, 1915745.909999927 4206173.540002158, 1915738.8699999272 4206157.250002159, 1915731.8199999272 4206140.920002159, 1915729.989999927 4206131.110002158, 1915727.0699999272 4206118.210002159, 1915726.0199999271 4206113.540002159, 1915727.7999999272 4206100.850002158, 1915729.989999927 4206087.210002158, 1915731.969999927 4206072.660002159, 1915729.0899999272 4206062.06000216, 1915725.1099999272 4206050.330002157, 1915721.2999999272 4206044.780002159, 1915716.5199999271 4206038.220002158, 1915706.219999927 4206027.200002159, 1915690.679999927 4206011.050002159, 1915673.169999927 4205995.440002159, 1915662.8099999272 4205985.770002158, 1915645.139999927 4205970.620002159, 1915633.979999927 4205960.640002159, 1915624.2999999272 4205952.1800021585, 1915615.739999927 4205944.450002159, 1915612.8699999272 4205941.050002159, 1915606.5499999272 4205933.190002159, 1915591.3399999272 4205913.080002159, 1915584.3699999272 4205904.350002158, 1915581.149999927 4205901.700002159, 1915569.2599999271 4205893.89000216, 1915546.979999927 4205879.040002158, 1915540.659999927 4205874.820002158, 1915536.429999927 4205872.330002159, 1915524.889999927 4205861.730002159, 1915511.1099999272 4205849.060002159, 1915493.6099999272 4205832.850002159, 1915490.199999927 4205831.690002158, 1915475.689999927 4205826.55000216, 1915454.3099999272 4205820.540002159, 1915440.3499999272 4205816.610002158, 1915433.3499999272 4205814.98000216, 1915430.5299999272 4205816.60000216, 1915416.239999927 4205829.20000216, 1915397.3499999272 4205845.850002158, 1915390.2699999271 4205852.100002159, 1915383.0399999272 4205857.720002159, 1915364.2599999271 4205871.91000216, 1915345.2499999271 4205885.790002159, 1915325.5199999274 4205899.780002159, 1915320.9299999273 4205901.400002159, 1915307.6299999272 4205904.430002158, 1915302.469999927 4205906.9700021595, 1915292.5099999271 4205918.880002159, 1915279.4899999273 4205935.1800021585, 1915271.2899999274 4205937.850002158, 1915253.2699999274 4205942.490002159, 1915244.7699999274 4205944.6800021585, 1915239.1399999273 4205946.720002159, 1915233.8699999272 4205948.620002159, 1915231.3799999272 4205949.860002159, 1915224.1699999273 4205953.780002158, 1915220.9499999273 4205954.8500021575, 1915211.7699999274 4205960.440002159, 1915199.2799999274 4205969.990002159, 1915196.699999927 4205971.970002159, 1915188.5199999274 4205977.14000216, 1915167.5799999274 4205990.170002159, 1915156.0799999274 4205996.810002158, 1915144.439999927 4206004.360002159, 1915137.3099999274 4206014.800002158, 1915128.2299999273 4206027.160002159, 1915111.3899999273 4206031.9300021585, 1915087.4599999273 4206038.410002159, 1915065.0099999274 4206044.50000216, 1915054.5599999274 4206047.490002158, 1915045.5999999274 4206046.980002159, 1915038.0199999274 4206042.400002158, 1915029.2799999274 4206037.62000216, 1915024.5299999274 4206035.360002158, 1915015.9799999273 4206027.370002159, 1915018.0699999274 4206011.820002158, 1915020.1599999273 4206001.750002159, 1915023.0299999274 4205987.130002159, 1915030.5199999274 4205968.480002159, 1915046.7799999274 4205929.850002158, 1915054.2499999274 4205911.690002158, 1915066.1299999272 4205896.1400021585, 1915093.1699999273 4205861.110002159, 1915097.7399999273 4205854.920002159, 1915122.0999999274 4205829.00000216, 1915142.449999927 4205807.54000216, 1915148.3399999274 4205798.50000216, 1915159.6899999273 4205780.433274563, 1915168.7599999271 4205760.740002161, 1915182.0899999274 4205731.330002157, 1915193.989999927 4205704.47000216, 1915198.8099999274 4205694.0100021595, 1915200.5399999274 4205682.77000216, 1915206.0099999271 4205651.670002161, 1915207.5099999271 4205643.140002159, 1915239.3999999273 4205586.270002157, 1915243.239999927 4205564.71000216, 1915247.0099999271 4205543.530002161, 1915257.0099999274 4205528.47000216, 1915272.4399999273 4205505.95000216, 1915281.3399999272 4205493.1300021615, 1915284.959999927 4205487.620002159, 1915293.5499999272 4205484.10000216, 1915300.5399999274 4205481.38000216, 1915302.7599999271 4205478.500002161, 1915309.159999927 4205466.52000216, 1915328.5399999274 4205430.710002161, 1915339.7699999271 4205409.300002161, 1915338.949999927 4205393.700002161, 1915338.0299999272 4205367.410002161, 1915337.1499999273 4205354.24000216, 1915336.209999927 4205332.1400021585, 1915335.5799999272 4205322.910002163, 1915332.8599999272 4205316.640002159, 1915328.5699999272 4205313.950002162, 1915316.9799999273 4205313.750002161, 1915308.8699999275 4205314.10000216, 1915302.449999927 4205312.530002163, 1915290.7699999271 4205309.3000021605, 1915283.439999927 4205306.840002162, 1915281.8599999275 4205303.980002159, 1915283.899999927 4205301.040002159, 1915291.7599999271 4205294.320002163, 1915295.4599999273 4205291.1400021585, 1915298.679999927 4205284.700002162, 1915300.5699999272 4205280.910002161, 1915305.959999927 4205274.10000216, 1915306.989999927 4205271.830002162, 1915303.439999927 4205265.100002162, 1915295.719999927 4205261.9600021625, 1915284.6399999273 4205261.060002158, 1915276.669999927 4205260.500002161, 1915269.3599999275 4205259.310002159, 1915256.5599999274 4205255.70000216, 1915248.0999999274 4205254.740002161, 1915244.8399999272 4205254.6700021615, 1915240.919999927 4205255.950002163, 1915239.0399999274 4205257.51000216, 1915232.2499999274 4205261.84000216, 1915226.6499999273 4205264.8000021605, 1915220.879999927 4205263.370002162, 1915218.7699999271 4205260.6700021615, 1915216.5099999271 4205256.610002162, 1915216.7799999272 4205253.860002159, 1915217.979999927 4205247.370002161, 1915221.0599999274 4205241.570002161, 1915225.959999927 4205232.3400021605, 1915232.379999927 4205224.800002161, 1915235.1699999273 4205222.180002159, 1915238.909999927 4205215.64000216, 1915238.489999927 4205213.07000216, 1915234.0299999272 4205210.500002161, 1915224.5499999272 4205208.870002163, 1915220.139999927 4205207.750002162, 1915215.6199999275 4205205.750002161, 1915207.0199999274 4205202.16000216, 1915201.739999927 4205199.960002161, 1915197.8199999272 4205197.060002159, 1915197.7699999274 4205190.270002159, 1915199.3099999272 4205185.710002162, 1915201.0099999271 4205182.830002161, 1915205.889999927 4205177.830002162, 1915209.659999927 4205175.860002162, 1915227.4999999271 4205168.22000216, 1915234.189999927 4205165.120002162, 1915241.1899999273 4205158.220002159, 1915245.669999927 4205150.360002162, 1915245.8299999274 4205143.27000216, 1915238.139999927 4205137.22000216, 1915234.3199999272 4205129.76000216, 1915232.9699999273 4205124.920002162, 1915228.1099999272 4205101.790002162, 1915224.0899999272 4205086.770002161, 1915221.629999927 4205078.070002162, 1915218.979999927 4205070.930002161, 1915216.889999927 4205066.530002162, 1915214.5399999272 4205062.940002161, 1915212.939999927 4205060.50000216, 1915207.8299999272 4205055.700002162, 1915204.5999999272 4205052.3800021615, 1915197.0799999272 4205044.830002164, 1915191.1399999273 4205038.39000216, 1915186.169999927 4205032.500002161, 1915183.8199999272 4205029.190002163, 1915178.679999927 4205020.9200021615, 1915175.9199999273 4205015.12000216, 1915173.629999927 4205008.920002163, 1915166.9599999273 4204992.05000216, 1915160.6199999272 4204975.710002162, 1915155.6599999273 4204957.930002161, 1915150.7399999273 4204938.35000216, 1915149.479999927 4204932.820002163, 1915147.5299999274 4204912.50000216, 1915146.399999927 4204897.750002162, 1915141.8199999272 4204883.780002161, 1915138.5899999272 4204873.850002161, 1915137.0199999271 4204868.050002162, 1915136.1699999273 4204862.850002161, 1915134.7799999272 4204851.950002161, 1915133.3199999272 4204839.720002162, 1915133.1999999273 4204824.180002163, 1915132.7899999272 4204811.020002162, 1915131.9099999273 4204798.24000216, 1915133.9299999273 4204778.43000216, 1915135.1099999272 4204762.940002163, 1915125.6199999272 4204745.170002162, 1915122.8299999274 4204739.950002162, 1915116.6999999273 4204721.370002161, 1915113.0699999272 4204711.830002162, 1915109.44 4204703.69, 1915105.58 4204700.09, 1915101.65 4204699.43, 1915100.32 4204699.21, 1915095.27 4204704.47, 1915090.7233713951 4204698.045384965, 1914991.3400858308 4204801.051983738, 1914970.8318088062 4204821.878220954, 1914957.3068592001 4204835.4437846765, 1914938.039444388 4204854.769057673, 1914923.1632668723 4204869.689906912, 1914911.5009437304 4204881.3872508835, 1914894.5507229725 4204898.388371516, 1914869.5952769134 4204918.622275374, 1914853.2997730456 4204931.834688319, 1914832.65530662 4204943.597815672, 1914823.1439747282 4204947.843688338, 1914780.5793911389 4204949.12755476, 1914763.2770665775 4204949.649441072, 1914746.5888521238 4204950.152804112, 1914732.0622489266 4204948.0701246215, 1914698.0311529667 4204943.191085479, 1914679.1202331244 4204940.479826394, 1914644.7861943673 4204943.67248312, 1914603.5699070054 4204934.368724241, 1914573.406168108 4204936.144367791, 1914542.8290903082 4204937.880797753, 1914512.64735122 4204939.364419002, 1914484.9330451875 4204955.526359693, 1914455.3244113603 4204981.258609667, 1914431.1698966355 4205002.250797775, 1914416.5311545231 4205014.973025134, 1914402.412407249 4205029.822642419, 1914378.1886911823 4205056.370819365, 1914367.2432980903 4205066.930107368, 1914336.4998586378 4205089.452541102, 1914323.2264560824 4205099.176545142, 1914322.2149330059 4205112.893586661, 1914324.0773015886 4205125.832263182, 1914323.332215529 4205137.8254230935, 1914318.2456651516 4205163.164524881, 1914316.909317751 4205181.984555118, 1914318.8886863152 4205196.967050317, 1914318.4439546776 4205203.005777047, 1914315.3518633065 4205208.820650272, 1914296.0792122465 4205233.482320283, 1914287.8839643288 4205241.957542503, 1914283.0313239954 4205251.455270904, 1914281.813460038 4205257.137445945, 1914279.8046799637 4205263.00570619, 1914272.630624268 4205299.981706106, 1914268.822206141 4205317.7506024605, 1914264.366146421 4205330.124058167, 1914259.65627831 4205340.528089955, 1914256.9807345257 4205346.705028336, 1914257.243229803 4205355.126440715, 1914257.6864407153 4205360.901779642, 1914259.6847260615 4205366.534229808, 1914260.0397693329 4205372.040367211, 1914260.9985862155 4205385.100259079, 1914259.39031155 4205398.986968102, 1914255.982165796 4205420.98572508, 1914256.2124856585 4205456.099039502, 1914255.3628814307 4205485.370037781, 1914253.9255845146 4205495.920052297, 1914244.4508225909 4205528.110378174, 1914220.9318279105 4205531.974121577, 1914236.674974535 4205620.48138953, 1914250.355552791 4205704.213393853, 1914280.67 4205772.81, 1914281.1 4205774.51, 1914283.99 4205775.25, 1914291.5 4205777.16, 1914299.5 4205779.19, 1914306.18 4205781.26, 1914316.67 4205784.11, 1914327.77 4205787.31, 1914337.18 4205790.43, 1914348.46 4205794.32, 1914356.65 4205797.15, 1914360.67 4205797.24, 1914374.5398918109 4205839.975904123, 1914376.1618921238 4205864.08716856, 1914361.2832933418 4205897.417759572, 1914331.08 4205931.88, 1914330.0714346347 4205932.963908097, 1914327.4959777435 4205932.386000507, 1914325.3950486416 4205932.36763032, 1914312.4301086492 4205938.465743748, 1914299.6917984844 4205944.096342831, 1914297.4930108157 4205946.799694144, 1914289.696981572 4205956.011380075, 1914284.2003189353 4205963.119942666, 1914281.7018996403 4205966.423873051, 1914278.1048321775 4205971.92992644, 1914276.207167232 4205975.73359344, 1914272.1406861208 4205984.400793822, 1914269.3075166526 4205990.912868703, 1914270.41 4205992.79, 1914283.0423397059 4206011.7465720475, 1914287.4683519672 4206038.756923663, 1914269.5535815866 4206073.479082085, 1914290.03 4206075.88, 1914303.12 4206106.41, 1914318.32 4206143.38, 1914330.06 4206172.16, 1914318.4031260093 4206178.990375847, 1914324.92 4206188.86, 1914333.73 4206202.01, 1914344.13 4206218.02, 1914349.77 4206226.5, 1914354.84 4206233.99, 1914360.56 4206242, 1914367.37 4206251.59, 1914375.49 4206263.05, 1914384.25 4206275.4, 1914392.35 4206286.51, 1914402.25 4206299.83, 1914413.41 4206315.33, 1914425.82 4206332.8, 1914395.883182853 4206350.062637101, 1914369.7490202466 4206309.327499846, 1914352.34537165 4206315.646100479, 1914368.081751271 4206347.649201229, 1914344.587961677 4206368.881022167, 1914316.9007825588 4206346.292796971, 1914263.3715262976 4206285.007938159, 1914247.61 4206352.96, 1914302.3985157926 4206406.33781012, 1914319.1506626431 4206401.820160748, 1914330.841250934 4206437.929566052, 1914365.9784010963 4206459.109946562, 1914399.611603462 4206476.689739186, 1914404.5410643255 4206507.301602363, 1914398.1570023277 4206529.318847842, 1914389.4481018784 4206524.423898292, 1914363.2339932222 4206524.146745302, 1914370.3568866954 4206545.952032315, 1914392.7915576159 4206571.946106075, 1914434.136841316 4206598.623950966, 1914404.0268101017 4206605.35392926, 1914379.4159975143 4206607.8768536635, 1914414.4586566323 4206635.360660726, 1914444.5859072276 4206648.241046677, 1914451.3007824854 4206661.141985177, 1914444.7220613079 4206689.362701803, 1914459.6367968547 4206697.153740692, 1914524.5916994652 4206720.509104122, 1914560.221437633 4206732.884382153, 1914612.356484596 4206741.343087084, 1914677.0965335637 4206747.889696034, 1914691.7796035092 4206719.761897221, 1914721.301899141 4206727.339975351, 1914766.4448566143 4206749.01179011, 1914830.7931463306 4206765.163791961, 1914847.0204668047 4206786.460812307, 1914808.1202842824 4206809.707327158, 1914776.4866591732 4206790.524962662, 1914767.66 4206805.07, 1914802.0489929104 4206846.031919803, 1914819.7480733688 4206834.310148414, 1914844.375535291 4206850.533915181, 1914859.79839054 4206867.392481306, 1914885.7982575065 4206851.397954927, 1914913.5863011244 4206846.318047566, 1914922.36 4206852.05, 1914950.99 4206869.98, 1914967.9631435438 4206875.801821569, 1914979.9201705977 4206933.421865913, 1915028.3516373264 4206939.982738228, 1915026.5686514608 4206960.395137607, 1915029.98 4206987.62, 1915032.55 4206984.04, 1915043.33 4206978.06, 1915054.81 4206971.44, 1915063.37 4206968.48, 1915070.77 4206966.2, 1915073.45 4206965.37, 1915086.14 4206961.5, 1915102.14 4206956.76, 1915111.08 4206954.24, 1915115.45 4206952.56, 1915122.33 4206949.44, 1915127.99 4206946.86, 1915131.86 4206944.98, 1915135.4165477343 4206949.193398553, 1915162.5483635345 4206968.980011646, 1915187.569726727 4206978.16285404, 1915197.6897145277 4206994.7627527425, 1915202.8170133736 4207022.673052679, 1915215.1483092676 4207050.777114462, 1915197.03 4207063.81, 1915184.81 4207042.39, 1915176.36 4207027.1, 1915171.93 4207019.76, 1915162.5688991426 4206992.292365319, 1915146.48 4207004.61, 1915114.95661227 4207007.04210853, 1915109.7318260686 4206982.033433908, 1915087.625482714 4206988.156140513, 1915093.72 4207020.26, 1915089.7785789869 4207047.18558169, 1915086.99 4207055.85, 1915082.02 4207072.2, 1915081.5769233382 4207073.867380324, 1915074.9905976518 4207070.763346431, 1915066.1898155478 4207067.063440013, 1915060.8785765036 4207064.620273953, 1915058.4758936544 4207063.021539335, 1915053.4682196374 4207057.32291991, 1915048.2410389786 4207050.520134515, 1915046.51 4207052.32, 1915042.38 4207056.64, 1915040.68 4207055, 1915037.2 4207058.73, 1915029.27 4207067.2, 1915038.57 4207107.9, 1915115.7355842846 4207096.288812138, 1915140.7515832367 4207099.368426446, 1915159.3692100174 4207108.15670406, 1915163.9884857344 4207127.262787301, 1915161.42 4207133.25, 1915151.3024558774 4207150.786455522, 1915138.104260814 4207160.803397991, 1915077.1820580855 4207172.363166672, 1915019.0741076365 4207198.4281553915, 1915008.2505803746 4207178.226940125, 1914982.7063044843 4207143.330867368, 1914945.5694387313 4207123.853184697, 1914902.5386026008 4207114.7862116005, 1914906.6141929831 4207084.56657442, 1914935.2172197972 4207070.734072795, 1914942.2 4207040.31, 1914942.5876702704 4207039.069471048, 1914949.8 4207036.72, 1914956.97 4207034.274966695, 1914964.2059895403 4207032.531208368, 1914979.755604184 4207023.074010461, 1914990.6568791629 4207021.084329206, 1915001.95 4207017.09, 1915003.4 4207011.56, 1914996.13 4207002.86, 1914989.77 4206995.26, 1914983.91 4206992.96, 1914967.83 4206991.94, 1914963.85 4206993.57, 1914950.73 4206992.72, 1914933.11 4206991.59, 1914926.36 4206990.79, 1914917.59 4206988.11, 1914905.05 4206984.28, 1914894.92 4206978.76, 1914886.39 4206974.14, 1914867.56 4206960.47, 1914850.35 4206947.77, 1914848.62 4206946.25, 1914838.43 4206937.47, 1914828.06 4206928.77, 1914825.06 4206924.59, 1914821.22 4206918.88, 1914815.43 4206909.78, 1914812.83 4206905.03, 1914809.96 4206897.78, 1914807.69 4206892.38, 1914804.89 4206886.32, 1914801.24 4206879.83, 1914797.98 4206874.36, 1914796.71 4206872.02, 1914793.15 4206866.65, 1914789.29 4206861.67, 1914785.96 4206857.15, 1914782.18 4206852.33, 1914778.37 4206847.93, 1914772.97 4206842.64, 1914766.75 4206837.25, 1914763.98 4206835.11, 1914736.11 4206826.19, 1914719.69 4206820.57, 1914709.86 4206817.43, 1914696.5 4206813.17, 1914689.98 4206810.15, 1914687.77 4206808.9, 1914682.24 4206805.8, 1914674.98 4206801.11, 1914668.4886584098 4206799.905033306, 1914664.03 4206808.24, 1914664.32 4206811.24, 1914670.19 4206817, 1914680.18 4206819.55, 1914692.21 4206832.71, 1914701.52 4206840.95, 1914722.25 4206859.29, 1914734.38 4206870.31, 1914741.61 4206878.25, 1914743.09 4206881.47, 1914745.37 4206899.06, 1914747.28 4206904.99, 1914751.23 4206912.52, 1914754.9 4206918.42, 1914761.1 4206927.73, 1914705.15746819 4206914.1531892745, 1914719.23 4206971.3, 1914728.91 4206996.38, 1914779.5626541872 4206988.927487126, 1914776.1 4207023.56, 1914778.72 4207026.46, 1914792.7186964669 4207044.745557913, 1914836.0410516285 4207044.007085132, 1914866.2661384335 4207054.285970771, 1914870.0027802328 4207093.703620768, 1914880.332763663 4207102.689048903, 1914875.8585655761 4207107.665606341, 1914870.9716239558 4207110.195745381, 1914864.2742828242 4207113.136105492, 1914859.4612270382 4207114.992922133, 1914853.2144588977 4207117.130826803, 1914848.7129503733 4207118.135318063, 1914841.3100784644 4207119.3424676005, 1914836.8080418175 4207119.746640162, 1914829.6043079386 4207119.853029444, 1914823.1010336182 4207120.05885561, 1914813.8957980939 4207119.666738989, 1914796.6851721902 4207117.980971116, 1914793.6715697867 4207119.104935135, 1914791.3842945555 4207120.1868022205, 1914781.882946955 4207124.397390181, 1914778.3824087102 4207125.901265791, 1914769.781626408 4207130.211114658, 1914760.1806647996 4207134.922055395, 1914758.7807133081 4207135.823764817, 1914747.6801864398 4207141.936768053, 1914736.3793768873 4207147.849840701, 1914718.2665123744 4207144.1637969585, 1914715.9648514527 4207143.665554469, 1914715.95 4207145.3, 1914715.09 4207159.44, 1914693.7832303348 4207178.003292967, 1914630.4706260827 4207201.971649024, 1914546.7623500524 4207231.203893704, 1914532.5068466503 4207188.650586397, 1914536.3863323946 4207162.933510052, 1914528.8695193261 4207148.332348386, 1914511.3658509895 4207154.751124877, 1914509.6820831299 4207174.262974074, 1914511.4997347714 4207193.271483749, 1914527.3556696917 4207247.386341225, 1914500.766313855 4207275.624702427, 1914482.6574844043 4207276.541084391, 1914500.730287708 4207234.602914299, 1914484.6007342956 4207210.704362808, 1914462.596778036 4207219.528366412, 1914469.6212308896 4207243.134755898, 1914463.6310449503 4207257.947891954, 1914459.9493724878 4207281.063419751, 1914434.9468009437 4207293.2918665605, 1914442.6245405732 4207263.269156963, 1914423.4988425202 4207245.5765283685, 1914426.3769308324 4207218.859794448, 1914445.6808596272 4207211.639015923, 1914449.871582893 4207198.528367386, 1914436.6560504977 4207188.8348104395, 1914441.4361121675 4207163.216997782, 1914453.0113499921 4207127.988117344, 1914438.7790398933 4207099.785621325, 1914458.886458333 4207096.06600055, 1914480.17 4207094.61, 1914489.96 4207086.31, 1914497.51 4207082.44, 1914507.72 4207077.42, 1914521.16664384 4207057.932099555, 1914530.0735299096 4207035.069766821, 1914558.6729841905 4207020.338192967, 1914539.74 4207019.58, 1914527.1557477308 4207019.765557716, 1914503.6431942324 4207019.686154428, 1914478.2318292086 4207022.109744314, 1914469.0492634547 4207047.531302128, 1914446.4567737684 4207069.762935595, 1914419.6515986372 4207080.0919423895, 1914380.6364332025 4207086.429537746, 1914373.2173138775 4207069.126854819, 1914370.55 4207046.95, 1914386.2981834651 4207039.399591688, 1914401.8023670341 4207034.783538808, 1914419.1105790262 4207033.667760884, 1914440.040029864 4207030.265027997, 1914452.6053359036 4207007.424436664, 1914459.676510176 4206970.298524154, 1914447.9322702547 4206926.985845673, 1914424.2273487172 4206935.711275071, 1914395.9972940038 4206918.526924749, 1914369.1780833115 4206912.847438044, 1914336.7353039721 4206904.4644195, 1914313.58 4206857.22, 1914281.39 4206791.57, 1914268.2891070524 4206758.3539980715, 1914266.287478188 4206746.282552108, 1914286.3813980503 4206738.627682993, 1914283.6113764094 4206702.608141239, 1914301.63 4206657.3, 1914298.34 4206656.18, 1914293.84 4206653.59, 1914290.72 4206650.21, 1914289.13 4206646.9, 1914287.98 4206645.16, 1914287.74 4206643.32, 1914289.08 4206640.2, 1914291.27 4206638.19, 1914295.05 4206636.97, 1914298.07 4206635.77, 1914306.16 4206635.21, 1914310.35 4206635.39, 1914312.15 4206635.63, 1914331.93 4206640.25, 1914343.3753819186 4206626.839107369, 1914335.895980128 4206611.316844994, 1914318.6910105431 4206616.0344300745, 1914295.7849568806 4206622.95818082, 1914251.8710421617 4206633.602316674, 1914229.9656014564 4206640.625237184, 1914215.7536155733 4206635.534999596, 1914210.9368626752 4206619.330643215, 1914208.9043063086 4206583.413414711, 1914203.04 4206561.93, 1914203.26 4206558.78, 1914202.99 4206555.65, 1914201.16 4206548.35, 1914198.87 4206541.54, 1914196.36 4206536, 1914194.91 4206532.83, 1914184.6325573851 4206516.199126245, 1914162.3004222482 4206493.006430026, 1914148.93 4206506.53, 1914151.97 4206509.31, 1914154.77 4206511.7, 1914157.24 4206512.99, 1914161.76 4206515.32, 1914161.53 4206518.92, 1914156.85 4206516.84, 1914152.87 4206514.31, 1914094.812989222 4206548.094697044, 1914061.9661915856 4206514.505699818, 1914042.9553620038 4206514.274972032, 1914027.6272015967 4206490.723195146, 1913998.2229750159 4206503.655782844, 1913980.653744256 4206475.035537085, 1913977.99 4206461.5, 1913975.89 4206451.89, 1913975.5624787824 4206448.246323261, 1913976.060376529 4206445.544458952, 1913973.2459267278 4206430.73909633, 1913970.332563807 4206417.234508681, 1913967.7201483808 4206404.630134024, 1913967.0156597784 4206399.928265882, 1913970.4081651708 4206389.319689673, 1913974.698253245 4206375.408583059, 1913977.0932099696 4206368.202678952, 1913980.0888338299 4206361.39646032, 1913983.5850720082 4206354.990014744, 1913987.6827660713 4206349.883729538, 1913992.980216801 4206343.775864841, 1913997.7783675487 4206338.769018948, 1914002.6767461756 4206333.962190965, 1914001.9 4206332.71, 1913995.05 4206319.18, 1913989.64 4206308.47, 1913986.23 4206301.16, 1913987.8 4206238.12, 1913987.96 4206226.85, 1913986.94 4206222.41, 1913974.89 4206174.74, 1913965.08 4206131.63, 1913962.69 4206120.5, 1913957.36 4206095.79, 1913952.44 4206073.87, 1913950.02 4206057.54, 1913946.64 4206033.92, 1913940.93 4205992.7, 1913949.8461114515 4205988.126012526, 1913963.9611563166 4205996.818235987, 1913973.17975738 4206012.518437819, 1913978.523298868 4206059.038275383, 1913987.662096003 4206097.850735111, 1913992.1623629332 4206095.445526969, 1913992.8501985148 4206081.137381451, 1913993.2058860264 4206030.310280589, 1914013.491592717 4206001.777485253, 1914004.6444516857 4205953.259674884, 1913986.0720557133 4205881.738278792, 1913971.5107120154 4205820.418757739, 1913966.1897869182 4205799.712522681, 1914013.2123834095 4205797.270071107, 1914037.51 4205787.42, 1914040.5059547324 4205773.533687945, 1914026.0947072392 4205769.344103743, 1913996.2808906075 4205771.471326014, 1913966.0568734757 4205762.192905569, 1913933.83 4205735.27, 1913872.3894728343 4205637.70844295, 1913833.6761349835 4205654.098499258, 1913827.0362870912 4205655.752883396, 1913826.1040856256 4205655.937845192, 1913730.6460295592 4205653.180917077, 1913610.4073570282 4205650.152834387, 1913438.6818706607 4205645.011127674, 1913430.7988712303 4205644.775099395, 1913383.1523020363 4205643.519856214, 1913396.62 4205714.59, 1913404.78 4205758.22, 1913420.43 4205842.6, 1913399.69 4205850.49, 1913381.3 4205857.52, 1913377.75 4205845.15, 1913375.08 4205834.95, 1913371.73 4205830.52, 1913365.09 4205822.39, 1913360.45 4205808.28, 1913348.57 4205768.87, 1913346.84 4205763.34, 1913342.76 4205749.98, 1913339.31 4205738.47, 1913338.04 4205734.59, 1913336.5555742115 4205728.440756507, 1913274.6746706688 4205740.885935788, 1913277.52 4205752.44, 1913283.6262416735 4205778.366241674, 1913281.99 4205793.91, 1913290.89 4205820.2, 1913301.97 4205852.24, 1913307.98 4205869.62, 1913313.19 4205886.01, 1913314.01 4205888.23, 1913314.55 4205892.11, 1913319.71 4205929.25, 1913319.3645684463 4205931.547276023, 1913314.024335381 4205930.688440396, 1913286.1760254337 4205928.907626332, 1913286.938439219 4205930.9829824045, 1913261.52 4205928.94, 1913266.54 4205948.53, 1913279.78 4205999.67, 1913282.01 4206005.67, 1913291.85 4206032.14, 1913328.1649238858 4206022.181758714, 1913331.33 4206052.28, 1913334.13 4206077.33, 1913338.2 4206113.86, 1913344.63 4206171.59, 1913346.21 4206185.19, 1913351.11 4206227.34, 1913353.92 4206251.52, 1913348.89 4206253.19, 1913366.32 4206317.14, 1913363.41 4206327.12, 1913370.51 4206330.27, 1913376.73 4206333.01, 1913379.13 4206335.41, 1913382.12 4206346.49, 1913384.55 4206353.47, 1913385.64 4206355.98, 1913387.67 4206358.72, 1913396.56 4206370.06, 1913404 4206380.07, 1913398.96 4206383.77, 1913395.3 4206384.42, 1913399.99 4206401.41, 1913404.13 4206416.46, 1913408.36 4206431.8, 1913407.42 4206432, 1913423.18 4206478.81, 1913433.01 4206508.16, 1913436.76 4206519.09, 1913441.29 4206532.3, 1913439.17 4206532.74, 1913447.81 4206553.76, 1913451.5617530246 4206558.3428042475, 1913458.23 4206579.19, 1913457.56 4206580.97, 1913457.9065418183 4206583.070306732, 1913459.66 4206583.96, 1913470.45 4206583.45, 1913487.44 4206628.07, 1913490.95 4206637.43, 1913491.38 4206638.12, 1913493.95 4206650.33, 1913494.43 4206652.62, 1913498.01 4206669.74, 1913498.78 4206673.42, 1913499.1 4206673.41, 1913501.33 4206678.28, 1913503.8 4206683.67, 1913518.68 4206695.87, 1913525.16 4206721.44, 1913525.55 4206722.44, 1913536.23 4206742.25, 1913542.8 4206754.14, 1913546.13 4206761.12, 1913549.25 4206767.65, 1913555.65 4206788.17, 1913558.46 4206792.4, 1913562.12 4206797.9, 1913562.66 4206799.08, 1913563.26 4206801.11, 1913563.81 4206803.93, 1913565.21 4206812.1, 1913565.21 4206812.77, 1913565.64 4206813.13, 1913570.52 4206812.94, 1913600.7 4206868.77, 1913599.19 4206891.11, 1913599.2 4206892.15, 1913609.62 4206902.2, 1913615.51 4206907.76, 1913604.8 4206921.93, 1913593.82 4206921.69, 1913591.95 4206926.27, 1913580.23 4206926.14, 1913565.48 4206925.97, 1913556.55 4206925.8, 1913544.96 4206921.66, 1913541.43 4206922.09, 1913536.82 4206923.25, 1913533.01 4206923.99, 1913529.57 4206924.44, 1913526.8 4206924.4, 1913522.7 4206924.34, 1913518.38 4206924.1, 1913515.21 4206923.58, 1913507.57 4206920.04, 1913501.36 4206917.17, 1913504.39 4206921.62, 1913508.52 4206928.79, 1913519.99 4206949.58, 1913522.58 4206953.13, 1913524.51 4206955.16, 1913543.7 4206973.36, 1913549.77 4206978.41, 1913558.24 4206983.65, 1913577.94 4206994.8, 1913591.5 4207002.46, 1913605.44 4207034.37, 1913606.40426488 4207087.277823657, 1913611.9842453974 4207087.234920278, 1913628.43 4207087.11, 1913653.35 4207086.69, 1913688 4207081.61, 1913690.164967619 4207081.131456551, 1913699.2824911189 4207095.631188051, 1913707.197452676 4207107.930802486, 1913714.310501998 4207118.530214964, 1913720.0214077719 4207127.530003726, 1913723.9285565303 4207133.329669248, 1913726.9335640743 4207137.229113804, 1913728.9364647355 4207139.328477995, 1913739.4498332164 4207148.224011417, 1913748.7621273138 4207156.620329844, 1913756.5718740628 4207163.0168993315, 1913763.2805115364 4207168.8141132435, 1913770.8898025362 4207174.810645216, 1913778.0985311335 4207180.407314892, 1913781.903176946 4207183.405580797, 1913784.3061158005 4207185.304488356, 1913788.8123597042 4207189.702884929, 1913797.2231279486 4207196.899353474, 1913801.5954375044 4207197.66185416, 1913808.3781371259 4207194.077745766, 1913821.5 4207193.68, 1913857.0525328366 4207194.14553898, 1913905.855674846 4207192.382414829, 1913910.9795025832 4207192.197304935, 1913933.193224131 4207194.379019615, 1913952.6069484327 4207198.26408945, 1913963.8203486532 4207206.758788988, 1913970.7303254663 4207213.956566591, 1913979.0423613994 4207222.653914071, 1913984.14 4207231.93, 1914001.44 4207235.09, 1914014.08 4207236.14, 1914017.4962403805 4207236.297326859, 1914017.919004016 4207238.396097765, 1914025.0294715627 4207238.8163792975, 1914032.9800887462 4207239.376958958, 1914035.4456747018 4207239.359149691, 1914037.9463018244 4207238.324314878, 1914041.8566833816 4207236.868002354, 1914046.7153595616 4207234.952896688, 1914064.3354188371 4207228.776255724, 1914067.8718812156 4207227.4881130485, 1914070.614437689 4207226.601235171, 1914073.053466704 4207226.05739231, 1914074.2699846711 4207225.798266985, 1914077.1969424253 4207225.369392939, 1914079.7980608619 4207225.066953451, 1914080.7985922159 4207225.06607649, 1914084.9006830682 4207224.962427771, 1914096.706602212 4207224.551866579, 1914106.9117588499 4207224.242761272, 1914112.9165257 4207226.038455207, 1914115.1198874374 4207228.537853982, 1914117.1241077697 4207232.138012702, 1914118.828607305 4207236.238700288, 1914120.0329289064 4207240.439879632, 1914120.7381251056 4207245.942188466, 1914120.7426861825 4207251.144951976, 1914120.7481243943 4207257.348247077, 1914120.4559468406 4207266.453346857, 1914116.11 4207271.82, 1914092.5 4207297.7, 1914091.42 4207299.35, 1914082.73 4207310.01, 1914082.14 4207310.82, 1914076.83 4207338.85, 1914068.11 4207384.97, 1914006.7 4207417.84, 1913998.33 4207519.19, 1913977.68 4207514.11, 1913963.89 4207510.71, 1913960.97 4207508.31, 1913954.12 4207502.13, 1913950.64 4207498.89, 1913946.71 4207495.51, 1913945.75 4207494.59, 1913944.2 4207493.57, 1913941.91 4207492.06, 1913935.33 4207489.81, 1913929.52 4207488.22, 1913924.13 4207486.65, 1913905.75 4207481.33, 1913898.61 4207479.3, 1913896.414774981 4207478.473468197, 1913896.621557989 4207477.461722476, 1913896.1182249328 4207473.960297177, 1913894.510888953 4207466.557759519, 1913892.100586158 4207456.254379284, 1913889.9893041882 4207444.650044625, 1913888.283054457 4207438.548287349, 1913887.4817524508 4207437.548456062, 1913880.7738054954 4207432.551665313, 1913872.463955905 4207426.355637651, 1913864.4541787761 4207420.0592938, 1913861.4547665424 4207420.078973978, 1913860.51 4207419.07, 1913858.9 4207416.54, 1913857.78 4207414.55, 1913856.71 4207412.65, 1913855.37 4207410.6, 1913853.46 4207407.39, 1913851.28 4207403.96, 1913847.89 4207398.28, 1913844.16 4207392.27, 1913841.99 4207389.07, 1913839.7 4207385.91, 1913837.57 4207380.48, 1913838.62 4207378.4, 1913841.81 4207371.64, 1913844.68 4207365.92, 1913846.42 4207362.43, 1913847.92 4207362.04, 1913851.31 4207361.72, 1913855.82 4207361.16, 1913858.06 4207360.97, 1913859.81 4207360.28, 1913861.34 4207359.68, 1913863.79 4207358.47, 1913866.35 4207357.13, 1913867.47 4207356.43, 1913868.14 4207356.01, 1913869.69 4207354.39, 1913871.19 4207352.57, 1913872.6604562502 4207350.630618725, 1913868.4 4207348.82, 1913866.58 4207347.65, 1913862.01 4207344.86, 1913855.31 4207340.8, 1913849.14 4207338.21, 1913844.55 4207341.15, 1913839.24 4207335.81, 1913831.3 4207327.85, 1913830.03 4207326.59, 1913819.7 4207339.33, 1913810.03 4207361.25, 1913813.39 4207363.53, 1913815.09 4207364.87, 1913811.32 4207366.19, 1913808.46 4207367.82, 1913802.2 4207371.23, 1913797.76 4207373.6, 1913794.06 4207375.95, 1913793.28 4207377.28, 1913791.32 4207381.15, 1913788.58 4207386.54, 1913785.25 4207385.5, 1913782 4207384.28, 1913773.36 4207381.47, 1913766.77 4207379.12, 1913766.46 4207379.64, 1913765.58 4207381.95, 1913765.36 4207392.54, 1913758.3 4207391.83, 1913749.44 4207388.48, 1913747.29 4207392.94, 1913744.5 4207398.65, 1913759.32 4207402.09, 1913758.75 4207407.81, 1913766.74 4207409.33, 1913776.56 4207411.2, 1913776.03 4207416.02, 1913775.58 4207420.14, 1913775.05 4207424.95, 1913774.71 4207427.95, 1913773.73 4207430.52, 1913772.75 4207432.47, 1913771.24 4207435.49, 1913769.29 4207438.45, 1913767.39 4207441.38, 1913765.59 4207443.7, 1913763.92 4207445.86, 1913761.82 4207448.36, 1913759.17 4207451.17, 1913757.37 4207453.06, 1913756.58 4207453.83, 1913754.62 4207455.22, 1913752.1 4207457.17, 1913749.13 4207459.12, 1913746.15 4207461.07, 1913744.74 4207461.98, 1913740.39 4207464.45, 1913734.65 4207467.91, 1913728.78 4207471.44, 1913724.64 4207473.94, 1913720.9 4207475.24, 1913715.28 4207475.86, 1913711.79 4207476.25, 1913706.23 4207476.71, 1913698.82 4207477.32, 1913689.37 4207478.1, 1913684.607248274 4207475.946401693, 1913678.7008680906 4207472.249596354, 1913673.4954734996 4207469.2525508795, 1913667.1885305606 4207465.155882525, 1913664.9850835244 4207462.556423974, 1913662.9816554817 4207459.85673713, 1913661.889287507 4207461.041274612, 1913653.2856815432 4207470.370817379, 1913584.878225307 4207503.548300372, 1913538.94 4207486.66, 1913514 4207478.48, 1913476.03 4207478.92, 1913457.5220392817 4207479.064237059, 1913448.8805780024 4207474.751781375, 1913445.375566544 4207471.152924944, 1913447.1697046058 4207463.347198033, 1913446.565887553 4207459.345593032, 1913444.2630891243 4207457.546645823, 1913442.4617810594 4207457.148006762, 1913436.58 4207459.11, 1913431.361904412 4207464.061385788, 1913428.370799067 4207476.070398168, 1913427.473904572 4207480.173368237, 1913426.1769719103 4207484.476794605, 1913413.7884662093 4207505.198659688, 1913388.5896434279 4207521.929585014, 1913373.390287981 4207531.948198843, 1913350.2993957894 4207556.481442407, 1913338.203873376 4207568.998678258, 1913325.110788135 4207584.918600061, 1913319.9128233285 4207590.426075593, 1913308.716117069 4207601.041512603, 1913297.9190987658 4207611.056280246, 1913290.5172513144 4207613.46402567, 1913271.3122588603 4207619.4839999685, 1913261.1095297702 4207622.5945641305, 1913254.209345945 4207626.602724737, 1913247.4097393672 4207631.21111774, 1913242.3104273784 4207635.117652347, 1913236.8116881682 4207639.925016197, 1913232.212817129 4207644.031220599, 1913228.3140571187 4207647.836653555, 1913224.6157530386 4207652.0421250975, 1913221.0180262583 4207656.847829255, 1913216.4208142592 4207662.855046866, 1913209.2269321498 4207674.267415393, 1913206.429369381 4207678.7722610235, 1913203.0308576631 4207684.177062664, 1913198.7664264764 4207686.682045074, 1913190.0783632603 4207690.638722284, 1913180.8746104627 4207691.86640669, 1913168.1500691422 4207690.246809308, 1913159.3422816244 4207688.883117603, 1913144.4461030737 4207688.059716223, 1913137.811323059 4207687.507229094, 1913122.8583337457 4207675.97156205, 1913102.5744219662 4207659.889548033, 1913101.2305110926 4207660.759235386, 1913068.777080687 4207681.191800882, 1913086.21 4207698.14, 1913073.72 4207705.58, 1913101.27 4207748.71, 1913101.67 4207751.59, 1913096.31 4207755.4, 1913091.59 4207758.62, 1913084.57 4207761.16, 1913078.15 4207763.4, 1913070.07 4207766.08, 1913054.58 4207771.58, 1913054.83 4207772.69, 1913055.17 4207774.15, 1913055.99 4207777.61, 1913060.14 4207795.29, 1913069.52 4207802.71, 1913059.23 4207814.14, 1913046.58 4207831.22, 1913039.77 4207824.49, 1913034.9 4207819.56, 1913034.22 4207819.22, 1913018.85 4207839.64, 1913014.37 4207845.43, 1912999.69 4207864.66, 1912991.85 4207874.97, 1912988.13 4207879.96, 1912984.07 4207885.24, 1912978.85 4207883.52, 1912975.4 4207897.09, 1912977.95 4207897.69, 1912971.35 4207906.13, 1912969.54 4207925.66, 1912968.14 4207934.83, 1912966.65 4207944.59, 1912964.05 4207961.56, 1912960.14 4207988.08, 1912958.48 4208002.18, 1912956.82 4208019.04, 1912956.05 4208028.7, 1912954.76 4208040.55, 1912950.95 4208051.09, 1912949.21 4208056.38, 1912944.61 4208070.37, 1912940.34 4208084.05, 1912934.38 4208103.1, 1912930.86 4208114.73, 1912929.81 4208119.53, 1912926.71 4208133.71, 1912921.24 4208157, 1912916.14 4208177.11, 1912913.8599999284 4208184.050002153, 1912911.5199999283 4208191.130002153, 1912908.2699999283 4208201.010002152, 1912902.7099999283 4208217.050002152, 1912897.9799999283 4208229.690002151, 1912893.0899999284 4208235.490002153, 1912887.1199999284 4208242.570002153, 1912881.1899999282 4208248.940002151, 1912876.8499999284 4208252.420002153, 1912884.3299999284 4208259.870002152, 1912876.2199999283 4208272.220002151, 1912870.0299999283 4208281.200002153, 1912877.8699999284 4208283.510002153, 1912886.8 4208289.63, 1912889.28 4208286.11, 1912897.86 4208275.21, 1912919.98 4208279.54, 1912924 4208274.6, 1912936.93 4208256.94, 1912946.42 4208243.79, 1912951.16 4208236.97, 1912954.13 4208232.68, 1912957.81 4208224.95, 1912961.7 4208217.61, 1912964.42 4208211.75, 1912966.4354391687 4208207.572371345, 1912968.93 4208208.75, 1912974.07 4208197.54, 1912978.13 4208189.23, 1912983.76 4208179.25, 1912984.96 4208176.77, 1912988.5272649005 4208171.422900022, 1912995.57 4208161.96, 1912997.88 4208158.14, 1912999.8 4208156.54, 1913002 4208153.7, 1913004.55 4208150.69, 1913006.04 4208148.65, 1913007.11 4208146.67, 1913007.31 4208144.84, 1913007.29 4208142.7, 1913006.3 4208137.58, 1913004.95 4208130.68, 1913004.6 4208127.69, 1913004.57 4208124.59, 1913005.2 4208122.46, 1913006.17 4208120.6, 1913008.26 4208118.35, 1913010.37 4208117.19, 1913012.34 4208116.31, 1913015.73 4208115.15, 1913022.13 4208112.96, 1913025.67 4208111.63, 1913029.01 4208109.87, 1913030.96 4208107.83, 1913034.0399999283 4208109.120002154, 1913035.6799999282 4208109.570002153, 1913037.1499999282 4208109.550002152, 1913039.1199999284 4208109.290002152, 1913039.759999928 4208109.080002153, 1913041.7299999283 4208108.490002154, 1913047.939999928 4208106.120002153, 1913053.7499999283 4208134.550002152, 1913056.969999928 4208150.280002154, 1913058.4699999283 4208157.630002153, 1913088.55 4208150.31, 1913088.88 4208144.83, 1913089.46 4208140.14, 1913090.16 4208135.88, 1913091.31 4208131.77, 1913092.74 4208128.14, 1913094.18 4208125.12, 1913100.7 4208112.18, 1913108.59 4208096.81, 1913109.78 4208093.87, 1913110.4 4208091.4, 1913110.38 4208088.69, 1913110.36 4208086.13, 1913109.98 4208082.77, 1913108.64 4208070.92, 1913108.5138666495 4208069.903430841, 1913138.1499999282 4208069.890002152, 1913141.8094413227 4208069.856724739, 1913137.117337518 4208051.331890973, 1913131.590470274 4208023.922039704, 1913128.2759572105 4208009.317114182, 1913125.465815748 4207999.414265737, 1913120.5506226989 4207985.010845514, 1913112.2261041282 4207962.005797692, 1913105.794427119 4207944.649742374, 1913103.5014860362 4207937.02564405, 1913101.6792713585 4207928.108347131, 1913091.95 4207928.09, 1913091.91 4207923.31, 1913092.61 4207920.2, 1913094.48 4207915.8, 1913097.39 4207909.83, 1913100.73 4207904.46, 1913103.4 4207900.16, 1913106.52 4207896.07, 1913108.34 4207893.69, 1913112.62 4207888.08, 1913115.8 4207883.9, 1913118.77 4207880.03, 1913122.45 4207874.6, 1913123.99 4207871.9, 1913125.2 4207868.89, 1913126.18 4207865.29, 1913127.12 4207861.1, 1913124.2 4207862.31, 1913122.84 4207856.95, 1913121.9 4207850.06, 1913120.76 4207844.53, 1913120.75 4207842.92, 1913120.71 4207838.73, 1913121.39 4207835.15, 1913122.08 4207833, 1913123.37 4207830.37, 1913124.91 4207828.06, 1913126.83 4207825.66, 1913128.27 4207824.15, 1913131.32 4207820.96, 1913133.53 4207819.11, 1913135.49 4207817.46, 1913140.2 4207814.07, 1913141.87 4207812.69, 1913158.25 4207808.75, 1913185.6185729562 4207793.751822672, 1913210.05 4207785.34, 1913234.1290001632 4207776.000011342, 1913241.9335126826 4207776.393410819, 1913254.4397474523 4207775.882223549, 1913273.3494853338 4207775.465497193, 1913308.3663303214 4207773.333793145, 1913311.0677713295 4207773.331433659, 1913325.5189936366 4207771.165777021, 1913323.7014029277 4207764.256015119, 1913332.3864939692 4207753.807715398, 1913342.3136823769 4207744.58576249, 1913354.9157624901 4207733.463590947, 1913355.9839253065 4207732.285107434, 1913356.8440296678 4207731.202926784, 1913357.2414475442 4207730.078714908, 1913357.3950185233 4207728.796149811, 1913357.174929545 4207727.505440479, 1913356.8206972627 4207726.027738961, 1913356.2375966045 4207724.8420028305, 1913357.54 4207723.78, 1913362.97 4207719.52, 1913371.34 4207712.69, 1913371.28 4207705.92, 1913372.84 4207702.67, 1913373.83 4207700.59, 1913377.3 4207695.56, 1913381.48 4207689.46, 1913384.6 4207684.93, 1913387.59 4207680.57, 1913390.67 4207676.24, 1913392.23 4207673.85, 1913394.03 4207671.22, 1913394.82 4207667.6, 1913395.02 4207661.24, 1913395.46 4207649.26, 1913395.9 4207636.93, 1913396.15 4207634.11, 1913396.86 4207629.15, 1913395.81 4207624.51, 1913394.85 4207619.57, 1913395.21 4207616.27, 1913395.63 4207613.75, 1913396.67 4207611.1, 1913397.47 4207609.05, 1913399 4207606.9, 1913400.38 4207604.94, 1913403.74 4207600.89, 1913407.7 4207596.3, 1913409.77 4207593.76, 1913411.62 4207591.5, 1913412.4 4207590.37, 1913415.18 4207585.48, 1913416.6 4207582.85, 1913419.02 4207580.36, 1913420.77 4207578.57, 1913425.71 4207575.22, 1913434.91 4207568.71, 1913438.62 4207565.9, 1913441.37 4207561.08, 1913446.02 4207553.61, 1913450.21 4207550.13, 1913454 4207547.52, 1913455.81 4207546.28, 1913460.43 4207543.55, 1913465.13 4207541.11, 1913468.27 4207539.49, 1913471 4207538.41, 1913473.55 4207537.48, 1913476.67 4207536.68, 1913479.74 4207536.04, 1913483.25 4207535.45, 1913486.78 4207535.02, 1913490.93 4207534.58, 1913494.53 4207534.36, 1913498.53 4207534.46, 1913501.62 4207534.55, 1913504.11 4207535, 1913506.68 4207535.46, 1913509.08 4207536.02, 1913511.06 4207536.58, 1913513.03 4207562.03, 1913499.88 4207581.82, 1913490.48 4207588.18, 1913476.95 4207618.11, 1913472.25 4207635.19, 1913468.13 4207650.89, 1913464.16 4207665.61, 1913462.35 4207671.92, 1913459.82 4207680.45, 1913458.33 4207685.29, 1913456.47 4207690.14, 1913452.5 4207699.88, 1913448.71 4207709.57, 1913444.77 4207719.92, 1913443.48 4207723.06, 1913442.1 4207726.38, 1913440.12 4207730.29, 1913438.22 4207733.84, 1913436.1 4207737.28, 1913433.9 4207740.54, 1913431.93 4207743.36, 1913429.1 4207746.61, 1913425.92 4207750.23, 1913418.65 4207743.93, 1913411.41 4207751.25, 1913418.79 4207757.96, 1913414.68 4207762.31, 1913395.16 4207783.08, 1913385.03 4207793.85, 1913383.3200362264 4207795.668913949, 1913389.13 4207808.86, 1913394.58 4207804.39, 1913407.23 4207799.33, 1913416.49 4207792.39, 1913426.09 4207785.2, 1913430.09 4207780.76, 1913436.69 4207773.47, 1913456.35 4207752.18, 1913474.259999928 4207732.810002153, 1913482.43 4207734.79, 1913486.629999928 4207735.770002154, 1913501.06 4207739.17, 1913510.22 4207741.44, 1913516.4371008014 4207727.127392998, 1913537.3177199196 4207692.190494227, 1913491.0168004793 4207676.132731181, 1913493.17 4207661.42, 1913498.79 4207625.66, 1913522.59 4207631.11, 1913538.21 4207603.46, 1913553.95 4207617.5, 1913560.28 4207611.8, 1913567.89 4207600.88, 1913595.47 4207586.43, 1913608.33 4207574.59, 1913610.53 4207572.55, 1913624.99 4207551.94, 1913624.59 4207518.98, 1913628.49 4207515.79, 1913632.31 4207512.8, 1913637.73 4207508.66, 1913640.8 4207506.13, 1913643.54 4207504.11, 1913645.5 4207502.67, 1913647.22 4207501.69, 1913650.24 4207499.98, 1913652.36 4207498.67, 1913654.63 4207497.73, 1913657.25 4207496.64, 1913660.76 4207495.31, 1913665.39 4207493.68, 1913667.63 4207493.08, 1913669.75 4207492.51, 1913674.14 4207489.61, 1913678.96 4207486.55, 1913686.11 4207482.16, 1913689.7 4207480.01, 1913693.1197402333 4207485.043806175, 1913698.8250514609 4207487.640200691, 1913711.2345433433 4207490.931102173, 1913724.9918823047 4207487.034351119, 1913735.727750259 4207493.63472729, 1913768.8569662455 4207466.985805554, 1913787.3548348085 4207467.752166401, 1913801.5574899304 4207462.136748383, 1913809.39 4207462.95, 1913811.19 4207463.51, 1913812.78 4207463.67, 1913805.26 4207489.77, 1913805.17 4207490.28, 1913798.38 4207518.79, 1913796 4207529.91, 1913779.67 4207519.46, 1913774.23 4207517.02, 1913753.97 4207504.85, 1913740.42 4207548.4, 1913748.18 4207552.38, 1913719.93 4207627.14, 1913700.07 4207614.36, 1913657.52 4207629.6, 1913652.08 4207624.89, 1913649.58 4207625.94, 1913644.17 4207627.94, 1913637.35 4207634.65, 1913635.2 4207636.85, 1913632.17 4207640, 1913630.6 4207641.84, 1913628.23 4207644.84, 1913625.93 4207647.56, 1913620.33 4207658.07, 1913619.73 4207665.52, 1913618.88 4207674.51, 1913617.75 4207686.42, 1913616.54 4207701.14, 1913615.19 4207716.23, 1913614.15 4207727.94, 1913613.59 4207739.79, 1913613.25 4207747.02, 1913613.42 4207749.41, 1913613.47 4207756.18, 1913613.5 4207760.59, 1913613.84 4207772.77, 1913614.45 4207794.7, 1913611.47 4207796.09, 1913603.79 4207799.44, 1913592.12 4207804.32, 1913572.56 4207813.04, 1913571.11 4207811.3, 1913568.99 4207812.23, 1913566.82 4207813.04, 1913551.98 4207819.47, 1913536.84 4207823.16, 1913511.549999928 4207833.380002153, 1913438.7212078276 4207843.281455405, 1913409.95 4207833.54, 1913408.01 4207834.96, 1913405.79 4207836.25, 1913383.74 4207844.91, 1913393.25 4207853.55, 1913401.76 4207861.16, 1913409.35 4207867.96, 1913407.56 4207869.91, 1913386.2 4207882.97, 1913396.05 4207888.61, 1913423.3 4207904.2, 1913432.01099227 4207908.831204145, 1913441.6392367806 4207889.779646048, 1913493.0040879794 4207885.332431608, 1913509.875141661 4207889.119679191, 1913517.15 4207892.62, 1913545.7861813926 4207879.783306719, 1913562.7934238678 4207877.667311797, 1913574.830853091 4207879.992011269, 1913576.2028557453 4207880.25697597, 1913588.0068830992 4207877.645262142, 1913606.48 4207868.17, 1913610.88 4207866.36, 1913616.24 4207864.23, 1913621.08 4207862.22, 1913627.19 4207859.54, 1913633.09 4207856.72, 1913640.04 4207853.02, 1913643.57 4207851.08, 1913644.96 4207850.07, 1913652.7 4207844.58, 1913666.33 4207834.9, 1913678.34 4207825.91, 1913687.43 4207824.17, 1913695.69 4207822.57, 1913708.78 4207819.99, 1913714.18 4207818.95, 1913718.63 4207817.18, 1913723.48 4207815.26, 1913727.86 4207813.51, 1913731.79 4207811.04, 1913736.73 4207807.96, 1913741.77 4207804.81, 1913746.5266472707 4207803.366953701, 1913753.9373548324 4207803.815849974, 1913764.4371650247 4207804.451865581, 1913762.2726919625 4207799.525891722, 1913761.2290640844 4207797.150771543, 1913777.3141858585 4207770.322368947, 1913782.69 4207760.01, 1913785.01 4207759.36, 1913790.99 4207757.66, 1913796.16 4207756.06, 1913801 4207754.99, 1913808.94 4207753.33, 1913832.65 4207768.35, 1913801.59 4207822.32, 1913781.29 4207810.46, 1913780.4203052542 4207817.620910392, 1913800.895133861 4207848.44347519, 1913789.5055130455 4207867.263499171, 1913769.7079009092 4207882.088744469, 1913758.415028978 4207887.300324998, 1913755.806081728 4207888.504335702, 1913745.3994760984 4207887.3128021, 1913741.1963571599 4207886.315945823, 1913733.14 4207884.31, 1913730.92 4207889.5, 1913729.21 4207893.52, 1913727.21 4207898.88, 1913725.55 4207903.33, 1913723.89 4207908.09, 1913722.59 4207911.57, 1913720.25 4207917.83, 1913718.08 4207923.61, 1913728.95 4207927.71, 1913744.87 4207974.85, 1913785.9 4208004.36, 1913792.2524332432 4208053.657185957, 1913826.23 4208062.62, 1913877.89 4208212.91, 1913872.52 4208231.23, 1913868.4 4208245.31, 1913863.68 4208261.38, 1913858.5 4208287.27, 1913856.18 4208298.93, 1913854.73 4208306.19, 1913852.22 4208318.74, 1913852.0629259748 4208327.287705311, 1913859.5284435663 4208352.547222771, 1913857.78 4208353.64, 1913804.36 4208384.24, 1913783.52 4208395.8, 1913774.45 4208400.91, 1913773.64 4208401.5, 1913770.55 4208402.86, 1913765.09 4208404.94, 1913762.14 4208406.06, 1913757.04 4208407.98, 1913751.34 4208410.28, 1913744.81 4208412.89, 1913735.74 4208416.52, 1913734.05 4208417.21, 1913729.18 4208419.57, 1913724.49 4208421.85, 1913717.89 4208425.52, 1913711.52 4208428.91, 1913706.86 4208431.4, 1913698.32 4208435.95, 1913690.15 4208440.3, 1913679.58 4208446.27, 1913671.15 4208450.87, 1913670.54 4208451.24, 1913660.65 4208456.57, 1913651.55 4208461.5, 1913651.13 4208461.82, 1913671.85 4208481.87, 1913679.29 4208489.06, 1913655.54 4208505.21, 1913637.85 4208517.24, 1913635.71 4208518.75, 1913635.13 4208519.42, 1913625.77 4208530.2, 1913623.42 4208540.24, 1913620.82 4208551.22, 1913616.45 4208562.34, 1913615.64 4208575.85, 1913615.05 4208579.97, 1913610.72 4208592.19, 1913606.7535023254 4208603.418458265, 1913606.4 4208604.42, 1913630 4208634.18, 1913648.8 4208657.87, 1913656.03 4208666.78, 1913685.6 4208682.44, 1913679.58 4208687.77, 1913666.72 4208695.17, 1913656.7 4208698.24, 1913642.5 4208700.59, 1913633.1 4208702.93, 1913607.94 4208708.87, 1913600.04 4208708.74, 1913590.2 4208710.14, 1913585.62 4208714.89, 1913576.87 4208727.48, 1913562.8699999282 4208730.32000215, 1913535.159999928 4208737.30000215, 1913530.9339686236 4208738.129513158, 1913530.5077524697 4208742.216663528, 1913529.1 4208750.98, 1913519.24 4208746.94, 1913518.89 4208744.88, 1913513.4569916558 4208741.56, 1913506.89 4208737.72, 1913502.2069916558 4208734.45, 1913498 4208731.29, 1913493.93 4208728.11, 1913490.64 4208725.2, 1913487.9 4208722.2, 1913485.62 4208719.34, 1913481.58 4208713.05, 1913475.79 4208704.49, 1913474.91 4208703.4, 1913470.01 4208701.31, 1913463.6 4208691.01, 1913466.24 4208686.02, 1913458.94 4208675.97, 1913444.56 4208656.64, 1913432.01 4208639.79, 1913427.49 4208633.96, 1913424.26 4208630.36, 1913420.58 4208627.34, 1913417.28 4208624.96, 1913412.95 4208622.62, 1913408.95 4208621.01, 1913404.96 4208619.41, 1913398.96 4208618.15, 1913394.34 4208616.96, 1913391.64 4208616.59, 1913389.45 4208615.74, 1913387.7 4208614.6, 1913386.16 4208612.73, 1913383.19 4208609.05, 1913379.93 4208603.99, 1913377.53 4208599.64, 1913375.53 4208596.01, 1913374.01 4208591.94, 1913370.12 4208581.62, 1913367.76 4208575.38, 1913365.91 4208571.2, 1913363.36 4208566.69, 1913359.96 4208560.03, 1913354.2 4208550.15, 1913348.25 4208540.51, 1913346.88 4208540.52, 1913341.04 4208530.63, 1913342.5 4208527.73, 1913341.8639833117 4208522.42, 1913340.28 4208513.64, 1913339.92 4208505.02, 1913339.84 4208495.09, 1913340.06 4208484.12, 1913340.62 4208474.46, 1913340.76 4208462.48, 1913341.48 4208442.78, 1913338.63 4208442.25, 1913338.81 4208437.46, 1913339.02 4208426.2, 1913340.67 4208423.78, 1913339.56 4208418.04, 1913338.43 4208415.38, 1913335.34 4208412.53, 1913330.94 4208409.85, 1913328.17 4208408.17, 1913322.01 4208405.54, 1913314.25 4208402.46, 1913309.2 4208400.29, 1913300.57 4208400.61, 1913260.93 4208410.58, 1913258.09 4208412.52), (1912685.336992808 4208590.741239598, 1912711.17 4208566.84, 1912682.85 4208536.73, 1912679.39 4208533.04, 1912680.7 4208532.01, 1912683.43 4208529.15, 1912685.56 4208525.94, 1912687.46 4208522.86, 1912690.46 4208516.85, 1912691.97 4208514.03, 1912693.11 4208512.04, 1912694.87 4208509.99, 1912697.53 4208507.13, 1912698.16 4208506.45, 1912700.89 4208504, 1912703.35 4208501.88, 1912705.14 4208499.83, 1912718.98 4208486.64, 1912719.38 4208486.27, 1912723.34 4208482.94, 1912726.2 4208481.04, 1912729.27 4208479.37, 1912732.8 4208477.43, 1912735.98 4208476.47, 1912741.15 4208474.89, 1912749.22 4208472.44, 1912755.63 4208470.94, 1912762 4208468.95, 1912767.63 4208466.97, 1912772.74 4208465.31, 1912781.1 4208465.75, 1912784.69 4208473.48, 1912788.95 4208482.69, 1912790.37 4208485.34, 1912837.8 4208487.92, 1912845.79 4208488.35, 1912876.48 4208504.41, 1912900.31 4208518.77, 1912914.89 4208529.1, 1912905.25 4208542.96, 1912931.05 4208559.14, 1912960.26 4208577.71, 1912985.56 4208593.84, 1912987.72 4208595.19, 1913004.7899999283 4208615.160002151, 1913024.39 4208638.28, 1913048.31 4208666.4, 1913060.13 4208680.6, 1913086 4208720.27, 1913097.0699999284 4208737.240002152, 1913106.6799999282 4208747.780002151, 1913111.1899999282 4208752.730002151, 1913116.1099999284 4208758.170002152, 1913121.6599999282 4208764.200002151, 1913126.2299999283 4208769.240002151, 1913134.8499999284 4208778.680002151, 1913143.1499999282 4208787.78000215, 1913166.5199999283 4208813.880002151, 1913178.3099999283 4208827.05000215, 1913180.03 4208828.92, 1913201.16 4208851.89, 1913209.57 4208861.04, 1913217.08 4208871.59, 1913241.26 4208905.56, 1913276.959086731 4208957.903088966, 1913288.64 4208975.03, 1913276.9035257113 4208980.809257839, 1913279.4522103767 4208984.549175891, 1913270.3612526464 4208993.048939827, 1913269.2815075484 4208994.234477132, 1913268.8759777169 4208994.855879246, 1913268.4051383382 4208995.577356604, 1913267.7546795781 4208997.043048123, 1913267.3122754418 4208998.950643919, 1913267.1921565167 4209000.18992633, 1913267.2945566582 4209001.790195814, 1913267.6514241525 4209003.353523623, 1913268.2535826827 4209004.83971114, 1913269.0855486463 4209006.210543317, 1913270.125929327 4209007.430771288, 1913274.5745720747 4209011.871649351, 1913276.9211563994 4209015.654897591, 1913281.9876283514 4209023.823247178, 1913286.703254727 4209036.75603349, 1913287.157785764 4209038.717844743, 1913289.4420276296 4209048.57691053, 1913289.9278303895 4209050.673694343, 1913289.8509171386 4209052.267715874, 1913290.042697019 4209053.85202669, 1913290.4977264374 4209055.381656884, 1913291.2030896046 4209056.813188609, 1913285.280226966 4209067.364909114, 1913274.6125625344 4209075.137465832, 1913263.6804487454 4209083.102702741, 1913262.827372754 4209083.724261618, 1913250.1358082774 4209092.971448828, 1913246.5752381969 4209095.1629415415, 1913239.0241945395 4209099.810526998, 1913238.684179088 4209100.019802821, 1913237.6899999282 4209098.16000215, 1913230.1841259827 4209102.015414733, 1913223.3836924622 4209105.723351018, 1913207.34 4209113.09, 1913202.68 4209115.9, 1913198.22 4209108.05, 1913197.07 4209108.66, 1913194.74 4209104.55, 1913186.76 4209090.72, 1913177.04 4209073.89, 1913164.46 4209052.1, 1913152.33 4209030.61, 1913147.23 4209022.04, 1913143.31 4209015.44, 1913140.98 4209011.26, 1913134.3 4208999.27, 1913123.83 4208981.41, 1913114.46 4208965.42, 1913113.21 4208964.01, 1913103.21 4208950.14, 1913096.96 4208940.96, 1913092.63 4208935.03, 1913089.35 4208930.83, 1913084.62 4208925.13, 1913075.09 4208913.67, 1913065.38 4208902.33, 1913072.1199999284 4208898.17000215, 1913077.76 4208894.37, 1913074.59 4208893.5, 1913068.96 4208891.95, 1913061.45 4208887.36, 1913051.18 4208881.07, 1913041.74 4208871.44, 1913035.22 4208864.78, 1913020.68 4208849.04, 1913005.55 4208832.67, 1913000.44 4208827.35, 1912995.79 4208822.52, 1912988.94 4208815.37, 1912979.16 4208805.17, 1912970.46 4208795.69, 1912951.99 4208775.99, 1912946.79 4208770.45, 1912936.1 4208753.65, 1912936.89 4208748.18, 1912931.6194181005 4208753.688087276, 1912929.33 4208756.24, 1912900.43 4208727.09, 1912904.32 4208720.29, 1912886.05 4208709.17, 1912857.4 4208692.12, 1912828.13 4208674.7, 1912795.2 4208657.07, 1912774.9 4208646.2, 1912752.55 4208634.23, 1912724.79 4208619.38, 1912719.8254849282 4208616.763940478, 1912703.27 4208608.04, 1912685.336992808 4208590.741239598), (1913461.4746865747 4209291.7158699, 1913420.5688711451 4209310.361685466, 1913416.89 4209312.05, 1913411.94 4209313.45, 1913409.22 4209311.53, 1913400.53 4209305.44, 1913380.62 4209291.97, 1913367.8 4209283.3, 1913363.86 4209280.45, 1913361.48 4209278.99, 1913360.13 4209277.43, 1913358.5 4209275.53, 1913357.04 4209273.3, 1913355.1804159044 4209268.47536336, 1913354.32 4209266.41, 1913351.73 4209258.12, 1913348.42 4209248.23, 1913347.27 4209245.22, 1913346.13 4209243.01, 1913344.55 4209239.98, 1913342.65 4209237.69, 1913337.29 4209231.24, 1913325.4 4209217.98, 1913310.85 4209202.56, 1913296.32 4209187.16, 1913288.84 4209179.6, 1913280.84 4209172.4, 1913271.58 4209164.63, 1913268.16 4209161.7, 1913265.97 4209159.35, 1913263.54 4209156.35, 1913260.88 4209152.7, 1913259.03 4209150.13, 1913256.57 4209147.94, 1913254.12 4209145.76, 1913249.22 4209142.53, 1913248.74 4209142.26, 1913247.9 4209141.78, 1913246.37 4209140.33, 1913244.6 4209138.66, 1913242.27 4209136.16, 1913240.27 4209133.36, 1913237.54 4209128.76, 1913240.0065359387 4209121.617420083, 1913247.15 4209116.85, 1913301.9037292022 4209080.141004241, 1913315.12159607 4209092.436097312, 1913461.4746865747 4209291.7158699))','ZO32415','"lib_modif"=>"N", "lib_code_insee"=>"38071 / 38277 / 38279 / 38388 / 38445 / 38545", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','AU','Zone à urbaniser stricte','AUs',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/AU.pdf','2019-12-20','SRID=3945;POLYGON ((1915706.1058434404 4214973.28856949, 1915670.4799999278 4215007.410002134, 1915668.7099999278 4215009.080002135, 1915666.1599999277 4215007.360002134, 1915620.3099999279 4214977.580002134, 1915576.8099999346 4214949.300002137, 1915618.8799999286 4215055.8800021075, 1915650.8375339943 4215128.405060115, 1915683.6422485695 4215172.768358581, 1915710.093139471 4215205.990292703, 1915711.017275102 4215207.290841489, 1915742.3214394553 4215190.32364852, 1915769.990391646 4215175.733139604, 1915769.517599928 4215172.034602132, 1915767.8039999278 4215158.428802133, 1915765.3896999278 4215143.322202134, 1915762.8752999278 4215128.116002133, 1915759.560799928 4215114.311202134, 1915757.9507999278 4215103.806802135, 1915757.654073506 4215096.999945697, 1915754.4084653186 4215096.867640024, 1915718.2658459037 4215086.462685711, 1915718.5999999284 4215084.1200021235, 1915726.5699999281 4215051.090002122, 1915729.1699999282 4215048.080002122, 1915754.348241861 4215069.398513556, 1915754.348301616 4215069.396925596, 1915754.3499999281 4215069.400002125, 1915757.2194968327 4215069.5320502315, 1915757.2143999278 4215063.784602133, 1915757.7008999279 4215047.474802134, 1915758.5835999278 4215027.463002134, 1915760.2740999279 4215016.1552021345, 1915763.368799928 4215007.947602133, 1915767.4644999278 4215000.439802133, 1915762.3537999277 4214991.539602133, 1915756.3407999277 4214980.538202135, 1915743.902499928 4214945.029602134, 1915743.3832899143 4214940.59756777, 1915739.7099999278 4214941.120002134, 1915737.7599999278 4214942.990002135, 1915706.1058434404 4214973.28856949))','ZO33644','"lib_modif"=>"N", "lib_code_insee"=>"38200", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','As','Agricole avec secteurs à protéger (stricts)','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1914856.7246883984 4215158.757620208, 1914856.0640775391 4215156.069143006, 1914843.2247038558 4215118.597193144, 1914833.1434178525 4215086.831631588, 1914833.999376098 4215078.652475019, 1914832.5727790222 4215064.671823675, 1914831.8119272483 4215043.938612838, 1914826.7712842466 4214983.070470932, 1914828.388094266 4214948.071289335, 1914828.5783072095 4214921.251264308, 1914825.3446871706 4214886.917828014, 1914824.713829237 4214852.638927463, 1914824.991193669 4214826.951185583, 1914820.1251295323 4214774.981620605, 1914819.3465592705 4214738.583460864, 1914818.3733464433 4214699.849590337, 1914818.3733464435 4214693.815670808, 1914812.3394269142 4214648.26931049, 1914812.5340694797 4214638.147897086, 1914815.6483505268 4214573.526565353, 1914815.259065396 4214565.156935038, 1914813.7019248724 4214552.310525718, 1914809.4197884323 4214521.751642941, 1914803.9697965994 4214485.937410896, 1914807.038511603 4214457.777437921, 1914807.3006617478 4214456.693959148, 1914776.7290481112 4214425.7165962355, 1914773.427973814 4214424.782777468, 1914760.8180019136 4214421.4920250075, 1914750.343408272 4214422.952259569, 1914744.0118488143 4214425.218701521, 1914721.5314421332 4214439.326594636, 1914734.3601399597 4214474.905081591, 1914738.633654234 4214499.135126516, 1914756.5401911002 4214517.869693889, 1914760.872615959 4214540.138389103, 1914763.2943142962 4214552.3435141435, 1914765.436288869 4214587.090950642, 1914760.120175055 4214629.229107585, 1914753.1269052734 4214640.892015518, 1914753.5541168344 4214648.816093846, 1914754.09 4214651.6, 1914702.57 4214650.15, 1914703.21 4214652.93, 1914714.19 4214680.24, 1914718 4214689.25, 1914724.65 4214705.24, 1914727.33 4214711.46, 1914729.95 4214726.75, 1914732.08 4214740.82, 1914736.98 4214760.03, 1914738.3 4214765.23, 1914752.8 4214826.21, 1914756.18 4214840.78, 1914712.2272307246 4214845.154971778, 1914666.7709127802 4214853.71069527, 1914605.7908294746 4214878.141313292, 1914553.4176121484 4214898.992211203, 1914557.807777074 4214918.421026194, 1914557.2238493776 4214924.844230854, 1914553.5256406334 4214941.778134051, 1914548.5622552142 4214961.63167573, 1914551.8884169625 4214976.83698658, 1914551.96850011 4214977.203080969, 1914559.3649175982 4215007.761963748, 1914566.3720499554 4215045.911906582, 1914568.5131181758 4215058.1743882075, 1914569.5836522859 4215085.521668659, 1914573.671146161 4215102.26092929, 1914585.5443426552 4215122.017149687, 1914589.2425513994 4215129.900173589, 1914601.4077117417 4215154.8144219695, 1914622.2344662482 4215181.869738571, 1914651.7228149185 4215220.798251666, 1914663.5960114128 4215234.3259099675, 1914674.4959950796 4215246.199106461, 1914694.0575729103 4215259.824086045, 1914721.0643926896 4215273.139269017, 1914722.2935049834 4215271.154699381, 1914724 4215271.93, 1914748.32 4215282.77, 1914754.5451501203 4215285.793491964, 1914756.034710842 4215284.3920100415, 1914789.6565079675 4215253.494778443, 1914816.729618544 4215228.526857036, 1914840.2036278392 4215206.893985609, 1914842.6030514382 4215204.700635702, 1914857.977919579 4215189.159264411, 1914859.601074849 4215188.7308889935, 1914856.7246883984 4215158.757620208))','ZO33616','"lib_modif"=>"N", "lib_code_insee"=>"38068", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UA2','Centres bourgs et villages','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UA2.pdf','2019-12-20','SRID=3945;POLYGON ((1916993.0239416417 4216822.850898467, 1917032.19 4216822.22, 1917051.05 4216821.27, 1917053.26 4216823.12, 1917052.57 4216833.12, 1917053.79 4216834.71, 1917052.84 4216841.13, 1917051.28 4216851.54, 1917064.8 4216854.9, 1917082.53 4216859.37, 1917088.3 4216860.82, 1917088.27 4216856.03, 1917088.12 4216854.37, 1917088.78 4216846.11, 1917088.14 4216836.54, 1917089.64 4216831.07, 1917091.02 4216831.15, 1917090.75 4216823.68, 1917089.65 4216823.76, 1917074.7049441263 4216824.810286185, 1917075.5992999275 4216796.89820213, 1917076.9901999275 4216785.090602129, 1917078.3636283423 4216781.227733739, 1917081.15 4216781.56, 1917098.36 4216779.27, 1917114.4234813226 4216779.439931042, 1917114.43 4216779.44, 1917114.59 4216780.83, 1917122.59 4216780.46, 1917126.762207887 4216781.424118944, 1917123.8328662948 4216757.666184413, 1917120.447995948 4216737.134643722, 1917109.9713999275 4216742.836802129, 1917104.7724999276 4216747.644202128, 1917096.9744999276 4216755.1554021295, 1917090.2748246905 4216759.864246353, 1917084.9738522123 4216762.170277693, 1917080.9727399955 4216763.474723853, 1917072.8706956937 4216766.383447971, 1917067.8892386013 4216768.784306802, 1917067.11 4216766.38, 1917064.55 4216760.59, 1917054.0909943993 4216734.792452725, 1917034.4267828758 4216741.8936733045, 1917022.9141184292 4216746.056486842, 1917016.8027946267 4216748.2627803795, 1916998.978318439 4216754.662682234, 1916995.4941532295 4216741.418025572, 1916993.6738059002 4216741.970159222, 1916993.103632207 4216742.140563438, 1916965.4053814516 4216750.630034499, 1916963.574899197 4216751.262022514, 1916962.4707429204 4216747.070813461, 1916929.4897030285 4216755.814722732, 1916925.6064618984 4216743.41149961, 1916923.8712577405 4216739.120594599, 1916921.8250309143 4216733.42876709, 1916923.6956917453 4216732.746915276, 1916913.990895128 4216710.853255751, 1916901.7782801345 4216715.7467019325, 1916899.2386890482 4216729.086767391, 1916896.6985990366 4216741.866114173, 1916891.5297641917 4216768.995984858, 1916891.4700417863 4216769.346637992, 1916890.8566741357 4216772.687183471, 1916895.4699164121 4216773.501877402, 1916910.3845999276 4216775.682880514, 1916913.4185776287 4216775.574410175, 1916920.612747362 4216775.317205241, 1916952.5937195239 4216772.304169161, 1916968.6483277662 4216770.395059362, 1916976.2937458064 4216769.998733078, 1916987.5882032383 4216769.745515987, 1916987.6399999275 4216772.180002128, 1916988.9499999275 4216774.07000213, 1916991.3599999277 4216777.15000213, 1916992.8299999277 4216817.49000213, 1916993.0239416417 4216822.850898467))','ZO33640','"lib_modif"=>"N", "lib_code_insee"=>"38200", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UA3','Hameaux anciens ','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UA3.pdf','2019-12-20','SRID=3945;POLYGON ((1915796.07 4214770.36, 1915806.13 4214765.05, 1915803.2 4214754.2, 1915802.47 4214752.49, 1915802.59 4214752.19, 1915803.5231921193 4214749.867106854, 1915795.2518350934 4214730.454309252, 1915795.2499999278 4214730.450002136, 1915789.6899999278 4214717.430002134, 1915783.1998405803 4214702.218280722, 1915775.4199999277 4214684.610002134, 1915774.0399999279 4214682.490002136, 1915765.6576078 4214665.823328708, 1915763.119999928 4214660.760002135, 1915748.1699999277 4214631.030002135, 1915744.319999928 4214632.710002135, 1915737.9497867476 4214633.714917587, 1915738.1260999278 4214636.161002135, 1915739.104649325 4214642.083101934, 1915735.449999928 4214643.000002124, 1915734.8599999282 4214643.140002125, 1915730.219999928 4214639.780002124, 1915718.149999928 4214642.890002127, 1915722.3199999281 4214658.620002124, 1915723.409999928 4214662.740002126, 1915724.118681966 4214665.430464266, 1915725.279999928 4214668.820002124, 1915716.6099999282 4214672.170002127, 1915720.7899999283 4214682.540002123, 1915717.049999928 4214683.860002128, 1915702.679999928 4214688.690002127, 1915703.449999928 4214692.64000212, 1915705.3199999281 4214702.220002125, 1915705.6499999282 4214704.420002122, 1915705.8200908352 4214705.355502113, 1915705.9477738556 4214706.057758727, 1915705.9477777767 4214706.057777772, 1915705.95 4214706.07, 1915708.6 4214718.94, 1915714.68 4214716.61, 1915724.22 4214713.01, 1915729.4 4214711.05, 1915732.92 4214709.72, 1915733.99 4214709.28, 1915736.91 4214708.03, 1915737.61 4214707.73, 1915740.5871080337 4214707.080339895, 1915742.5611551024 4214738.505646275, 1915743.1985364824 4214744.590716619, 1915745.8563254476 4214753.780924889, 1915750.6913509672 4214762.055039374, 1915767.306121312 4214783.448101449, 1915768.5966438754 4214785.404973364, 1915773.3 4214782.38, 1915796.07 4214770.36))','ZO33647','"lib_modif"=>"N", "lib_code_insee"=>"38200", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UD4','Pavillonnaire au développement limité','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD4.pdf','2019-12-20','SRID=3945;POLYGON ((1913926.9696019941 4228468.390371577, 1913884.5999999295 4228473.500002097, 1913885.2999999295 4228476.500002097, 1913885.4999999295 4228478.800002097, 1913885.1999999294 4228480.7000020975, 1913884.8999999296 4228482.700002099, 1913884.7999999295 4228484.400002099, 1913884.8999999296 4228485.800002098, 1913885.2999999295 4228487.100002098, 1913888.5999999295 4228491.2000020975, 1913889.5999999295 4228492.700002099, 1913891.9999999295 4228495.800002096, 1913892.2999999295 4228500.300002098, 1913892.7999999295 4228505.100002097, 1913893.1999999294 4228508.700002097, 1913893.3999999296 4228510.300002099, 1913893.9999999295 4228511.500002098, 1913897.5999999295 4228514.000002097, 1913898.4999999295 4228515.000002097, 1913898.8999999296 4228516.100002096, 1913899.3999999296 4228520.500002097, 1913900.0999999295 4228525.500002099, 1913900.1999999294 4228528.000002098, 1913899.8999999296 4228531.600002098, 1913899.8999999296 4228534.600002097, 1913900.1999999294 4228536.300002097, 1913900.9999999295 4228538.500002097, 1913902.1999999294 4228541.000002096, 1913902.8999999296 4228542.7000020975, 1913904.5999999295 4228547.000002097, 1913905.3999999296 4228550.000002097, 1913905.9999999295 4228551.900002097, 1913906.4999999295 4228554.000002097, 1913906.5999999295 4228555.500002097, 1913906.7999999295 4228557.2000020975, 1913907.2999999295 4228558.800002096, 1913908.8999999296 4228562.700002098, 1913911.7999999295 4228569.300002096, 1913913.5999999295 4228573.7000020975, 1913914.3999999296 4228576.5000020955, 1913915.7999999295 4228580.800002099, 1913916.6999999294 4228583.400002098, 1913918.2999999295 4228586.200002098, 1913920.8999999296 4228590.100002097, 1913922.4999999295 4228592.800002096, 1913922.3999999296 4228603.000002098, 1913922.3999999296 4228604.7000020975, 1913922.9999999295 4228606.500002097, 1913923.7999999295 4228608.400002099, 1913924.9999999295 4228611.400002097, 1913925.9999999295 4228615.200002098, 1913926.6999999294 4228618.7000020975, 1913926.4999999295 4228620.100002096, 1913923.3999999296 4228623.600002097, 1913922.4999999295 4228624.800002098, 1913922.3999999296 4228626.800002098, 1913923.3999999296 4228631.300002096, 1913924.1999999294 4228634.2000020975, 1913924.4999999295 4228636.000002097, 1913924.4999999295 4228636.100002098, 1913924.7999999295 4228639.000002097, 1913925.36 4228644.56, 1913925.74 4228649.17, 1913925.61 4228652.36, 1913925.1999999294 4228656.7000020975, 1913925.26 4228657.96, 1913926.69 4228660.81, 1913930.2999999295 4228668.300002098, 1913932.0999999295 4228671.800002097, 1913932.7999999295 4228673.500002098, 1913933.1999999294 4228675.000002098, 1913933.5999999295 4228677.2000020975, 1913934.0999999295 4228680.800002095, 1913934.5999999295 4228684.700002099, 1913934.9999999295 4228686.900002097, 1913935.2999999295 4228688.2000020975, 1913936.0999999295 4228691.300002098, 1913936.5999999295 4228693.100002096, 1913937.5999999295 4228695.300002098, 1913938.7999999295 4228697.000002096, 1913940.26 4228698.86, 1913941.55 4228700.54, 1913942.2 4228701.47, 1913943.01 4228703.33, 1913943.31 4228704.92, 1913943.33 4228706.54, 1913943.01 4228708.28, 1913942.57 4228710.09, 1913942.36 4228711.65, 1913942.22 4228713.4, 1913942.41 4228715.27, 1913942.77 4228716.84, 1913943.07 4228717.69, 1913943.67 4228719.44, 1913946.03 4228725.74, 1913947.67 4228730.1, 1913948.65 4228732.73, 1913952.6999999294 4228738.300002098, 1913957.2999999295 4228742.900002097, 1913957.8999999296 4228743.7000021, 1913958.3999999296 4228744.900002099, 1913958.5999999295 4228754.800002098, 1913960.8999999296 4228768.800002097, 1913961.3999999296 4228770.100002097, 1913962.9999999295 4228774.900002097, 1913963.6999999294 4228782.300002098, 1913995.4471720315 4228782.2942549335, 1914003.4999999295 4228782.300002097, 1914003.7999999295 4228782.300002095, 1914051.1999999294 4228783.100002096, 1914052.7999999295 4228784.900002097, 1914054.5999999295 4228787.100002097, 1914056.4999999295 4228789.600002096, 1914067.7999999295 4228807.000002097, 1914069.0999999295 4228809.2000020975, 1914069.7999999295 4228810.300002098, 1914070.2999999295 4228811.800002096, 1914070.8999999296 4228813.200002097, 1914072.4999999295 4228820.600002095, 1914071.1999999294 4228837.500002097, 1914070.8999999296 4228841.100002097, 1914070.6999999294 4228843.500002097, 1914070.6999999294 4228845.2000020975, 1914070.8999999296 4228847.100002096, 1914071.6999999294 4228858.400002098, 1914071.8999999296 4228862.000002096, 1914072.0999999295 4228864.000002098, 1914072.0999999295 4228866.200002097, 1914072.0999999295 4228868.900002096, 1914071.8999999296 4228874.500002096, 1914071.5999999295 4228886.300002096, 1914071.9999999295 4228892.900002096, 1914072.6999999294 4228893.000002097, 1914073.3999999296 4228893.700002097, 1914073.5999999295 4228895.300002095, 1914071.8999999296 4228899.800002098, 1914067.8999999296 4228910.800002097, 1914065.3999999296 4228917.600002096, 1914064.8999999296 4228919.200002097, 1914064.6999999294 4228920.900002096, 1914064.5999999295 4228922.500002098, 1914064.9999999295 4228924.200002095, 1914065.4999999295 4228925.600002096, 1914066.0999999295 4228926.600002096, 1914067.0999999295 4228928.100002098, 1914068.3999999296 4228929.600002097, 1914070.0999999295 4228930.900002098, 1914071.8999999296 4228932.000002097, 1914073.3999999296 4228932.600002097, 1914076.2999999295 4228933.2000020975, 1914079.3999999296 4228933.400002096, 1914090.8999999296 4228942.700002096, 1914092.3999999296 4228940.100002098, 1914094.1999999294 4228939.400002097, 1914102.6999999294 4228938.000002096, 1914113.5999999295 4228936.300002095, 1914120.9999999295 4228935.200002097, 1914123.3999999296 4228934.900002096, 1914130.5999999295 4228934.400002098, 1914141.6999999294 4228933.700002097, 1914143.6999999294 4228933.700002097, 1914148.0999999293 4228933.900002099, 1914149.0999999295 4228928.700002096, 1914158.8999999296 4228902.500002096, 1914158.9999999295 4228901.000002097, 1914162.2999999295 4228894.300002096, 1914153.2999999293 4228872.600002098, 1914147.2999999295 4228872.2000020975, 1914145.3999999296 4228864.300002097, 1914144.6999999294 4228861.800002095, 1914141.7999999295 4228857.400002099, 1914137.2999999295 4228853.100002096, 1914141.0999999295 4228842.200002097, 1914138.6999999294 4228840.400002097, 1914139.3999999296 4228838.600002097, 1914140.2999999295 4228836.300002095, 1914141.7999999295 4228831.400002099, 1914143.1999999294 4228826.200002096, 1914144.2999999295 4228820.600002098, 1914144.7999999295 4228817.500002096, 1914145.1999999294 4228814.000002096, 1914145.3999999296 4228811.800002096, 1914145.7999999295 4228805.700002096, 1914145.8999999296 4228804.700002097, 1914145.8999999296 4228802.600002096, 1914145.7999999295 4228799.800002097, 1914145.4999999295 4228798.000002096, 1914144.9999999295 4228796.000002097, 1914144.0999999295 4228793.300002096, 1914143.1999999294 4228790.5000020955, 1914142.4999999295 4228788.800002096, 1914141.4999999295 4228786.800002095, 1914140.0999999295 4228784.500002098, 1914138.0999999293 4228781.300002097, 1914136.7999999295 4228779.2000020975, 1914136.3999999296 4228777.400002098, 1914135.2999999295 4228773.500002097, 1914132.5999999295 4228762.000002096, 1914132.1999999294 4228760.200002097, 1914131.7999999295 4228757.900002099, 1914132.0999999293 4228756.900002099, 1914132.3999999296 4228756.200002097, 1914132.7999999295 4228755.600002096, 1914131.8999999296 4228742.100002094, 1914124.6999999294 4228728.600002097, 1914123.7999999295 4228726.600002098, 1914111.2999999295 4228692.000002097, 1914109.9999999295 4228674.100002096, 1914109.0999999295 4228671.700002097, 1914108.6999999294 4228666.700002098, 1914102.7999999295 4228664.600002097, 1914099.2999999295 4228664.100002096, 1914085.2999999295 4228663.900002099, 1914079.5999999295 4228663.900002099, 1914067.8999999296 4228664.100002097, 1914064.4999999295 4228663.900002098, 1914061.1999999294 4228663.600002098, 1914058.5999999295 4228663.300002098, 1914055.8999999296 4228663.800002097, 1914052.1999999294 4228664.400002097, 1914050.8999999296 4228664.500002095, 1914050.1999999294 4228663.800002096, 1914049.8999999294 4228662.700002098, 1914044.6999999294 4228637.9000021, 1914038.6999999294 4228619.500002097, 1914037.4999999295 4228616.100002097, 1914039.2999999295 4228576.300002096, 1914040.8999999296 4228536.300002096, 1914040.8999999296 4228535.500002096, 1914042.1999999294 4228503.900002097, 1914042.9999999295 4228487.700002098, 1914043.6999999294 4228476.200002099, 1914030.5999999295 4228474.500002098, 1913989.1999999294 4228469.000002099, 1913959.2999999295 4228473.500002097, 1913937.6999999294 4228469.600002097, 1913935.6999999294 4228469.200002098, 1913931.5999999295 4228467.900002099, 1913926.9696019941 4228468.390371577))','ZO34023','"lib_modif"=>"N", "lib_code_insee"=>"38423", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','A','Agricole','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1922577.9800000004 4215714.259999992, 1922580.0883809964 4215714.127713443, 1922579.3075799076 4215716.102680903, 1922578.8194149411 4215717.337451112, 1922580.4800000004 4215717.729999991, 1922593.3023779956 4215720.77, 1922711.2252429936 4215741.34826168, 1922737.229999851 4215679.3700042665, 1922740.7172232026 4215676.826517928, 1922742.49757291 4215681.259937787, 1922747.8397563093 4215685.688326658, 1922754.5174855583 4215687.445623828, 1922763.8663065073 4215685.477450998, 1922773.4962950032 4215680.97877024, 1922790.4366397301 4215668.607398157, 1922800.980422755 4215661.086166266, 1922811.945957101 4215655.8845666405, 1922820.380983521 4215653.775810036, 1922829.8703882436 4215652.932307393, 1922841.6794252314 4215654.127269469, 1922850.4659110857 4215657.571571924, 1922860.7988184502 4215662.492004002, 1922870.2179312857 4215668.607398157, 1922878.934125253 4215675.496003066, 1922885.1198112944 4215681.2599377865, 1922893.4142539406 4215689.905839867, 1922898.5455616794 4215696.232109682, 1922899.5900000003 4215692.249999991, 1922905.39 4215675.85, 1922910.2200000002 4215662.149999994, 1922916.6200000006 4215643.409999991, 1922926.8300000003 4215613.489999991, 1922979.5499998508 4215645.910004267, 1922983.824879856 4215634.072394784, 1922992.1100000003 4215611.129999991, 1922983.0900000003 4215606.879999991, 1922990.7000000002 4215581.259999992, 1922990.7330964894 4215579.326217297, 1922995.579484197 4215579.427535508, 1923026.1702315279 4215581.146396719, 1923039.2236123108 4215581.843905616, 1923053.5723667594 4215582.840346897, 1923070.910445051 4215584.335008819, 1923074.8962101757 4215583.438211666, 1923075.917562489 4215582.616147609, 1923077.268393815 4215580.398928153, 1923080.1095053689 4215574.310831967, 1923081.2341755582 4215567.984562152, 1923078.9848351795 4215564.259092149, 1923075.470240838 4215559.549535732, 1923063.0988687556 4215547.564769029, 1923059.3733987533 4215542.644336951, 1923050.0245778046 4215528.23450015, 1923044.5418106318 4215520.291516937, 1923039.7971082707 4215513.051452594, 1923037.6180597788 4215510.064047403, 1923025.984752508 4215499.766285982, 1923019.482752976 4215492.4559297515, 1923009.3255753287 4215481.455249461, 1923003.8428081556 4215476.39423361, 1922998.7817923033 4215474.144893231, 1922984.0204960683 4215471.930698796, 1922982.5092205014 4215473.266244646, 1922981.3494043688 4215481.103790028, 1922980.1192963494 4215491.542135223, 1922978.0456856878 4215495.232459282, 1922973.1252536094 4215498.60646985, 1922961.1404869044 4215507.428101648, 1922958.0124979403 4215508.658209668, 1922949.0502823691 4215509.853171743, 1922934.745883399 4215511.786198631, 1922928.8765108485 4215513.051452594, 1922922.7259707504 4215514.843895708, 1922915.3804685764 4215518.35849005, 1922906.734566496 4215522.189397883, 1922892.570751299 4215528.410229868, 1922884.8034978039 4215531.292197228, 1922879.7776278954 4215532.979202513, 1922876.9308064787 4215537.68875893, 1922873.0998986464 4215544.050174688, 1922868.9175313797 4215550.481882334, 1922865.402937038 4215556.843298092, 1922865.6489586423 4215562.536940925, 1922858.865791563 4215569.320108005, 1922849.6224084438 4215578.2471776325, 1922843.0149710816 4215584.784323108, 1922829.026885602 4215592.375846886, 1922814.9121082819 4215599.766131238, 1922813.0300000005 4215596.5499999905, 1922812.8177310813 4215596.269399084, 1922800.4800000002 4215579.959999991, 1922792.8200000003 4215574.119999992, 1922772.1221293039 4215574.258380256, 1922749.4711602991 4215575.199871196, 1922741.307036805 4215578.484948989, 1922729.88 4215569.2, 1922695 4215600.61, 1922686.89 4215608.17, 1922685.11610344 4215609.884009943, 1922684.4594804407 4215609.412861622, 1922683.0053028374 4215608.369441978, 1922678.422030028 4215604.452114791, 1922676.0893128216 4215602.458339401, 1922673.172199518 4215598.908599116, 1922667.1973891372 4215590.403280809, 1922660.4669409723 4215580.492124765, 1922656.3900115367 4215574.447022499, 1922653.472898233 4215572.654579384, 1922642.858823321 4215566.996082494, 1922633.0179591645 4215562.954299001, 1922626.1645001983 4215558.947661451, 1922623.2122409514 4215555.5385049395, 1922619.2758952887 4215549.774570219, 1922615.4449874563 4215543.342862574, 1922612.8441876434 4215540.952938422, 1922607.994047452 4215536.665133324, 1922599.4887291451 4215531.006636434, 1922593.6193565945 4215525.031826054, 1922590.5265135742 4215521.200918221, 1922582.5132384752 4215511.2897621775, 1922572.6723743184 4215498.004595566, 1922566.0122180406 4215489.464131315, 1922561.9001426608 4215484.26253169, 1922560.3010022359 4215482.434942631, 1922560.3010022359 4215478.428305081, 1922558.3328294044 4215469.501235453, 1922551.8659758156 4215459.730663183, 1922546.5237924163 4215452.631182613, 1922539.6351875067 4215440.259810531, 1922535.9097175049 4215433.3009137325, 1922530.356658445 4215427.747854673, 1922514.4004001338 4215415.095315043, 1922502.8725306932 4215405.465326548, 1922493.1019584234 4215397.241175788, 1922481.9958403038 4215391.758408615, 1922468.7809655792 4215384.729219932, 1922461.7517768957 4215380.722582382, 1922460.064771612 4215377.2079880405, 1922464.914911803 4215357.069362463, 1922465.986863077 4215352.447670904, 1922466.6897819452 4215349.354827884, 1922466.654636002 4215346.261984862, 1922466.2328846809 4215343.643612078, 1922468.3767872292 4215343.66118505, 1922468.7134129868 4215345.19470239, 1922505.4500000002 4215350.029999992, 1922510.9400000002 4215332.169999992, 1922539.3500000003 4215333.359999991, 1922568.8300000005 4215335.0499999905, 1922611.3900000001 4215340.219999991, 1922614.999999851 4215282.880004272, 1922624.6100000003 4215279.999999993, 1922612.6700000002 4215244.289999992, 1922607.9159362132 4215230.086012425, 1922580.5769452588 4215230.519132622, 1922552.1883985049 4215230.968880491, 1922550.6230722028 4215237.094065285, 1922543.4200000002 4215265.279999992, 1922509.5200000003 4215255.4199999925, 1922499.699999851 4215275.95000427, 1922495.669999851 4215274.83000427, 1922495.849999851 4215272.280004271, 1922504.6673402637 4215253.179833539, 1922506.6800000002 4215248.819999991, 1922510.5900000003 4215239.909999991, 1922489.3200000003 4215225.709999991, 1922466.4100000001 4215256.239999993, 1922458.1700000002 4215233.369999993, 1922455.9599999266 4215219.820002135, 1922462.1699999254 4215212.180002135, 1922492.7199999255 4215171.350002136, 1922509.2499999295 4215149.590002132, 1922538.5700000003 4215176.2999999905, 1922543.6300000001 4215179.359999991, 1922550.9600000002 4215181.629999992, 1922560.7100000002 4215183.459999989, 1922564.5000000002 4215183.419999991, 1922593.8700000003 4215183.119999991, 1922629.271714999 4215126.66567249, 1922629.569999851 4215126.190004271, 1922630.7078830507 4215124.522259041, 1922630.6648283473 4215124.28350114, 1922620.1210453447 4215117.851793508, 1922611.0885379063 4215113.388258704, 1922604.1296411247 4215110.225123803, 1922596.6787011365 4215106.780821356, 1922595.7147757409 4215106.46799413, 1922575.2296372517 4215098.561815426, 1922576.9000000004 4215097.25999999, 1922592.9399999254 4215058.490002136, 1922609.4199999254 4215018.070002137, 1922593.8200000003 4215007.129999992, 1922578.5700000005 4214996.01999999, 1922558.0800000003 4214983.509999991, 1922548.6300000001 4214995.979999993, 1922513.0200000003 4214980.95999999, 1922516.0600000003 4214970.5899999915, 1922469.3900000001 4214958.729999991, 1922464.2900000005 4214919.84999999, 1922462.5600000005 4214910.71999999, 1922463.0600000003 4214906.369999991, 1922462.9596379902 4214901.981949891, 1922464.4976095837 4214900.932223247, 1922479.4372617584 4214888.257358769, 1922482.1391137473 4214887.542162655, 1922480.1900000002 4214884.44999999, 1922485.4600000002 4214867.799999992, 1922494.4800000002 4214850.63999999, 1922499.9600000002 4214842.10999999, 1922495.5800000003 4214818.11999999, 1922496.8100000003 4214781.38999999, 1922499.96935022 4214780.739542851, 1922499.8104177495 4214780.431611191, 1922490.512868258 4214761.836512208, 1922489.6387396732 4214756.909605639, 1922482.7251772308 4214743.082480754, 1922480.0233252419 4214741.334223584, 1922469.4543159907 4214733.705465027, 1922457.45491451 4214721.467664842, 1922446.9653714937 4214710.978121826, 1922444.5813844446 4214707.481607487, 1922438.7803492919 4214696.912598236, 1922427.8140088657 4214679.112161603, 1922424.158562057 4214671.483403046, 1922421.456710068 4214663.695712019, 1922415.973539855 4214645.6568766795, 1922414.2252826858 4214641.604098695, 1922400.9544214457 4214627.220710166, 1922398.2525694566 4214625.3135205265, 1922384.7433095116 4214616.890099621, 1922379.995201972 4214613.3737187255, 1922378.019999926 4214614.250002129, 1922336.8600000003 4214633.11999999, 1922364.02 4214683.16, 1922350.05 4214699.49, 1922375.3 4214748.44, 1922358.36 4214762.48, 1922342.51 4214775.77, 1922300.6400000001 4214711.679999991, 1922246.4400000002 4214645.01999999, 1922240.7200000004 4214651.54999999, 1922220.4600000002 4214637.379999991, 1922182.2500000002 4214610.809999991, 1922199.3900000001 4214588.319999993, 1922145.2600000002 4214546.779999993, 1922161.0700000003 4214528.24999999, 1922136.91 4214502.14, 1922134.4300000002 4214499.459999989, 1922207.4400000002 4214468.359999991, 1922205.03 4214444.78, 1922200.72 4214411.48, 1922179.0300000003 4214388.159999991, 1922172.2500000005 4214405.169999992, 1922160.1000000003 4214433.51999999, 1922128.8200000003 4214420.479999991, 1922115.6900000002 4214441.10999999, 1922106.7600000002 4214455.569999992, 1922086.9600000004 4214501.82999999, 1922074.7000000002 4214529.1699999925, 1922067.0900000003 4214537.92999999, 1922063.0200000003 4214580.259999992, 1922028.4200000002 4214603.359999991, 1922009.4900000002 4214565.439999991, 1921987.8286073662 4214570.560850565, 1921987.2400000002 4214570.699999992, 1921985.011346581 4214571.175979002, 1921981.4323004736 4214582.481219882, 1921978.0152523697 4214590.507309616, 1921976.4855273466 4214593.28862784, 1921966.9694457091 4214603.480172477, 1921965.5589200384 4214605.744960173, 1921964.2079940434 4214611.089064477, 1921965.4993203618 4214615.737839224, 1921970.128228549 4214619.870083442, 1921976.4060611115 4214625.035388715, 1921999.848600428 4214644.425150048, 1922021.7812812803 4214662.305052915, 1922024.2447345643 4214666.5962296035, 1922033.5025509389 4214695.641138486, 1922038.3897243894 4214706.170414619, 1922042.0849043156 4214713.322375767, 1922054.6008363238 4214727.109767534, 1922066.0837072774 4214740.1223635115, 1922070.2358180548 4214745.824065871, 1922082.1954864177 4214759.750523551, 1922090.1619764736 4214769.644069806, 1922096.7676072554 4214775.951702205, 1922097.8900678244 4214777.580760023, 1922098.9100000001 4214776.739999993, 1922141.3400000003 4214734.88999999, 1922159.7300000002 4214716.209999991, 1922178.2400000002 4214740.069999992, 1922193.2600000002 4214753.399999992, 1922206.6000000003 4214764.739999992, 1922219.3400000003 4214776.2999999905, 1922197.6400000001 4214795.89999999, 1922171.1500000001 4214774.199999992, 1922145.25 4214798.01, 1922134.4500000002 4214807.909999992, 1922133.59135842 4214808.60703131, 1922138.0724661965 4214811.049674373, 1922142.4657091142 4214813.6329012085, 1922148.229643823 4214817.288079317, 1922154.1693082487 4214820.767527708, 1922165.62688578 4214826.900494821, 1922168.7373017664 4214828.429343356, 1922171.3205286022 4214830.186640523, 1922176.6099930757 4214834.369007781, 1922182.3212088686 4214838.305353437, 1922185.6425005149 4214845.422406965, 1922189.8063805609 4214853.665535347, 1922190.0146036854 4214854.077749418, 1922189.2200000002 4214854.499999992, 1922159.6 4214870.24, 1922144.8600000003 4214878.409999992, 1922129.2600000002 4214887.06999999, 1922106.0700000003 4214899.86999999, 1922104.789257848 4214900.500493431, 1922103.5064309158 4214898.655331406, 1922102.803512049 4214896.757450465, 1922082.4188649082 4214858.202350615, 1922069.2039902103 4214850.751410626, 1922057.5003910763 4214835.462925269, 1922039.2596464797 4214829.224520326, 1922038.128868957 4214828.837790055, 1922037.3999999256 4214829.710002138, 1922017.0099999255 4214854.110002138, 1922010.2700006533 4214862.410001241, 1922018.5300000003 4214878.2199999895, 1922013.8500000003 4214880.559999992, 1922007.1400000001 4214883.91999999, 1921996.9900000002 4214866.279999991, 1921998.7699999257 4214846.710002135, 1922000.3499999256 4214829.430002137, 1921994.4099999256 4214821.630002136, 1921992.5899999258 4214822.430002135, 1921963.3599999258 4214835.330002136, 1921958.9229803772 4214837.648536126, 1921934.6643362083 4214848.339388096, 1921922.5074447833 4214854.263949106, 1921922.9300000002 4214855.089999991, 1921923.1309043816 4214855.486571706, 1921927.182247259 4214863.48364963, 1921967.4299999257 4214942.930002133, 1921970.8099999258 4214949.510002134, 1921991.2199999257 4214969.360002135, 1921985.200000856 4214974.400001357, 1921997.3700000003 4214993.8399999915, 1922002.9000000004 4215002.59999999, 1922008.5600000003 4215028.589999992, 1922010.2600000002 4215036.09999999, 1922015.4100000001 4215044.05999999, 1922047.585306371 4215079.951747399, 1922048.8709098655 4215081.385845814, 1922049.825395717 4215081.669044913, 1922051.1082226487 4215082.635558355, 1922058.330714005 4215092.3006927725, 1922063.3038649873 4215098.539097715, 1922065.8343729074 4215101.877962332, 1922067.9255565365 4215104.3733243095, 1922074.2166803938 4215110.629302223, 1922080.8768366564 4215117.148874712, 1922087.1855334854 4215123.633301258, 1922091.5436304593 4215127.850814458, 1922099.627197427 4215131.998035772, 1922110.329137173 4215137.428084018, 1922114.1600449968 4215142.014629623, 1922118.2896933386 4215147.0229265485, 1922128.9740601128 4215159.939060724, 1922128.0454374023 4215160.419022568, 1922124.4558153183 4215162.383712845, 1922123.9456757854 4215162.662925018, 1922124.3100000003 4215163.399999993, 1922139.0100000002 4215193.139999992, 1922160.8400000003 4215237.59999999, 1922165.1400000001 4215243.429999991, 1922184.9500000002 4215272.14999999, 1922166.5000000002 4215290.499999993, 1922175.3600000006 4215302.159999992, 1922182.3600000003 4215309.409999992, 1922186.1100000003 4215316.379999991, 1922189.1000000003 4215318.979999993, 1922202.8100000003 4215330.909999991, 1922225.2300000004 4215344.4699999895, 1922234.0100000002 4215349.749999993, 1922256.0500000003 4215362.009999991, 1922273.5600000028 4215329.449999994, 1922275.2367544328 4215325.83212986, 1922278.614069436 4215329.408110452, 1922297.9243646301 4215342.718704875, 1922319.2213157087 4215356.7047623, 1922331.0935831983 4215366.553347831, 1922333.1838728639 4215363.252465626, 1922341.2900000003 4215345.969999991, 1922353.3200000003 4215324.279999992, 1922364.4000000001 4215306.879999992, 1922388.9800000002 4215324.2999999905, 1922400.3000000003 4215332.639999992, 1922391.5300000003 4215353.5499999905, 1922399.6000000003 4215357.389999992, 1922428.5500000003 4215363.409999992, 1922411.9110743322 4215411.957873493, 1922411.2900000003 4215413.769999992, 1922409.7595339387 4215417.853283449, 1922377.1786974664 4215396.006736488, 1922375.051119131 4215399.237148005, 1922366.7499999255 4215412.150002135, 1922364.2399999255 4215431.180002134, 1922356.8799999256 4215479.830002134, 1922353.4100000004 4215505.00999999, 1922353.044433871 4215505.987951554, 1922369.2844477268 4215511.732380513, 1922381.9721332723 4215516.5473747505, 1922396.1710943813 4215521.608390592, 1922407.5935259662 4215525.790757849, 1922422.2142383952 4215531.097795294, 1922426.8535029162 4215533.452573497, 1922433.7069618672 4215536.615708398, 1922447.5193175995 4215544.1017943295, 1922454.8648197574 4215548.249015643, 1922460.523316635 4215549.79543715, 1922467.9039647363 4215552.255653183, 1922476.1984073643 4215554.11838818, 1922484.457704049 4215555.770247517, 1922494.825757334 4215557.386960911, 1922519.5333555012 4215561.358452508, 1922528.5362691365 4215562.868556611, 1922538.9813921654 4215564.63219121, 1922538.61 4215567.11, 1922533.9 4215599.09, 1922531.1900000002 4215617.63999999, 1922555.8700000003 4215625.269999991, 1922571.5700000003 4215631.339999991, 1922607.8400000003 4215645.80999999, 1922614.5800000003 4215648.119999993, 1922615.0385589332 4215649.010275724, 1922614.3535055525 4215649.4586743, 1922607.2538614243 4215653.5939056175, 1922605.6346443424 4215655.113478571, 1922604.0300000003 4215654.429999992, 1922591.0399999255 4215653.700002135, 1922564.6800000002 4215652.2099999925, 1922502.4500000002 4215648.309999989, 1922500.7100000002 4215659.519999989, 1922497.7300000002 4215677.949999992, 1922492.8300000003 4215677.639999991, 1922482.9500000002 4215703.2899999935, 1922515.9499999254 4215709.400002135, 1922516.6399999256 4215707.520002134, 1922538.2099999255 4215710.240002134, 1922572.25 4215714.54, 1922577.9800000004 4215714.259999992), (1922418.4496613387 4215257.830410726, 1922415.8678462743 4215260.799977976, 1922402.369999851 4215250.910004271, 1922391.7899999255 4215230.240002135, 1922383.61570956 4215241.626584931, 1922350.2799999255 4215231.570002136, 1922348.4899999255 4215231.030002136, 1922330.0499999255 4215226.690002137, 1922317.0099999255 4215223.620002136, 1922302.7106300206 4215220.241041439, 1922292.050505978 4215217.722043018, 1922294.59 4215134.2, 1922273.71 4215141.78, 1922254.81 4215149.04, 1922251.41 4215159.62, 1922249.78 4215166.88, 1922243.04 4215161.07, 1922237.36 4215155.37, 1922230.87 4215147.35, 1922221.22 4215133.63, 1922216.52 4215127.98, 1922214.57 4215126.43, 1922212.04 4215125.11, 1922206.46 4215116.11, 1922202.43 4215092.94, 1922199.5599999256 4215075.9600021355, 1922192.7099999255 4215056.570002138, 1922183.9299999254 4215032.310002138, 1922179.1699999254 4215019.160002136, 1922222.2499999255 4215017.550002137, 1922233.4399999254 4215017.0000021355, 1922232.2699999255 4215006.720002137, 1922230.9999999255 4214998.110002136, 1922230.7799999255 4214996.580002136, 1922230.4399999254 4214994.3400021335, 1922229.9799999255 4214980.840002137, 1922234.4899999255 4214971.370002136, 1922237.2899999255 4214965.450002134, 1922237.2939084573 4214965.438152739, 1922233.9899998512 4214959.010004272, 1922241.7099999255 4214952.050002135, 1922250.7799999255 4214943.870002136, 1922253.1599999256 4214941.860002137, 1922255.7299999255 4214952.770002136, 1922269.0099999255 4214951.390002134, 1922269.4799999255 4214953.470002137, 1922269.5699999256 4214953.900002138, 1922315.0799999256 4214995.300002137, 1922323.0199999255 4215000.950002135, 1922334.5699999258 4215009.9600021355, 1922337.0499999255 4215011.900002136, 1922339.2399999255 4215013.300002136, 1922338.1099999256 4215014.800002134, 1922344.6199999256 4215018.2900021365, 1922352.0499999255 4215022.280002136, 1922355.2999999255 4215019.830002135, 1922362.4399999254 4215003.850002135, 1922366.0999999256 4215003.810002136, 1922369.6599999256 4215013.140002136, 1922374.7499999255 4215024.720002135, 1922391.1199999256 4215016.120002136, 1922394.0899999256 4215016.680002137, 1922396.4699999255 4215036.380002136, 1922405.7599999255 4215035.740002135, 1922407.8899999256 4215050.650002136, 1922412.1699999254 4215051.420002136, 1922424.1599999256 4215050.530002136, 1922427.1599999256 4215050.040002135, 1922428.6999999257 4215052.090002133, 1922416.5699999256 4215073.340002136, 1922397.7999999255 4215082.060002135, 1922384.8499999256 4215091.200002137, 1922383.8499999256 4215097.280002136, 1922378.2299999255 4215109.390002135, 1922373.3899999256 4215117.560002135, 1922381.1347759413 4215116.111534382, 1922407.6099999256 4215111.160002135, 1922410.3799999256 4215111.590002134, 1922430.2799999255 4215114.690002138, 1922446.4199999254 4215126.840002136, 1922429.6999999254 4215149.290002136, 1922405.1999999254 4215132.0800021365, 1922401.7999999255 4215129.690002134, 1922395.5299999255 4215129.750002135, 1922387.7199999255 4215133.400002136, 1922381.8199999256 4215139.910002136, 1922381.5099999255 4215142.500002136, 1922382.4299999254 4215146.990002136, 1922383.5399999255 4215157.630002136, 1922396.4199999254 4215166.060002136, 1922398.7599999255 4215167.600002136, 1922406.8099999256 4215180.050002134, 1922412.899999851 4215172.070004275, 1922426.2886557765 4215183.070155407, 1922408.705101089 4215206.766501567, 1922413.5199999255 4215212.720002136, 1922414.8499999256 4215214.100002135, 1922425.109999851 4215227.050004273, 1922432.16 4215221.33, 1922439.7182879052 4215230.159248009, 1922427.5371968332 4215247.97056078, 1922418.4496613387 4215257.830410726))','ZO32417','"lib_modif"=>"N", "lib_code_insee"=>"38528", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','ALg1','STECAL en zone agricole avec hébergement autorisé','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/AL.pdf','2019-12-20','SRID=3945;POLYGON ((1917819.85 4218291.65, 1917801.14 4218277.6, 1917793.5385641411 4218272.483648941, 1917794.3860250143 4218271.314497842, 1917861.14 4218175.12, 1917908.41 4218207.92, 1917908.75 4218208.12, 1917884.08 4218275.31, 1917881.78 4218276.9, 1917840.96 4218305.03, 1917839.61 4218305.96, 1917819.85 4218291.65))','ZO32568','"lib_modif"=>"N", "lib_code_insee"=>"38059", "lib_modif_comment"=>"Stecal ALg1"',1),
     ('MJ3_PH1_ZON_050_09','UD3','Pavillonnaire en évolution modérée','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD3.pdf','2019-12-20','SRID=3945;POLYGON ((1913629.1282999292 4225810.353602105, 1913625.0297999294 4225814.460002105, 1913623.5345999293 4225820.965002103, 1913624.4438999295 4225831.670602103, 1913624.7637999295 4225853.484002102, 1913621.4261078888 4225872.51156449, 1913619.0719950518 4225877.401802103, 1913616.107640623 4225881.601281307, 1913607.206783113 4225892.1847724505, 1913588.1922999294 4225911.551002103, 1913552.3039999295 4225949.806002103, 1913545.7057999296 4225956.015202104, 1913535.2050999294 4225962.528802104, 1913527.9026999294 4225965.236802104, 1913516.4086999295 4225980.256002103, 1913496.3151999295 4226002.187002102, 1913480.0177999297 4226015.609202101, 1913466.8185999296 4226025.627202103, 1913448.2181999295 4226038.150802102, 1913414.6160999294 4226058.893002102, 1913417.5231999294 4226065.294402103, 1913419.3319999296 4226074.097802102, 1913413.7969278009 4226090.407671295, 1913421.3999999296 4226083.500002105, 1913432.2999999293 4226074.500002106, 1913448.4999999295 4226095.400002105, 1913466.2999999295 4226116.000002105, 1913462.1999999294 4226119.400002105, 1913477.9999999295 4226139.000002104, 1913471.3999999296 4226144.6000021035, 1913472.3999999296 4226158.200002104, 1913472.9999999295 4226159.1000021035, 1913473.6999999294 4226160.000002103, 1913474.7999999295 4226161.500002103, 1913479.3999999296 4226168.500002103, 1913480.7424482952 4226170.643831494, 1913521.8800000027 4226145.289999999, 1913527.5590000004 4226123.534000002, 1913530.9670995944 4226115.141681969, 1913538.5433643213 4226096.485412888, 1913541.9579999968 4226088.077, 1913545.5700000003 4226081.745000001, 1913554.25 4226085.855, 1913554.0999999295 4226087.400002105, 1913553.8999999296 4226089.500002104, 1913553.8999999296 4226095.200002104, 1913553.8999999296 4226100.200002104, 1913553.7999999295 4226107.100002104, 1913554.4999999292 4226108.400002105, 1913555.5999999293 4226109.300002105, 1913556.8999999296 4226109.900002103, 1913558.3999999296 4226110.000002103, 1913560.1999999294 4226109.600002103, 1913561.7999999295 4226108.700002105, 1913565.4999999292 4226104.100002104, 1913572.2999999295 4226095.800002105, 1913577.2999999295 4226089.800002103, 1913584.6999999294 4226080.700002103, 1913587.2999999295 4226078.000002105, 1913592.3999999296 4226073.1000021035, 1913624.7999999293 4226041.1000021035, 1913628.5999999295 4226037.800002105, 1913633.9999999292 4226033.000002104, 1913643.0999999293 4226025.000002105, 1913644.2999999295 4226023.500002105, 1913645.3999999294 4226020.400002105, 1913646.3999999294 4226014.600002104, 1913647.9999999292 4226004.500002104, 1913655.3999999294 4225958.200002106, 1913655.5999999293 4225957.000002106, 1913661.4999999292 4225922.000002105, 1913661.0999999295 4225906.200002104, 1913657.8999999294 4225893.500002106, 1913649.8999999294 4225856.8000021055, 1913637.9399999976 4225804.3500000015, 1913629.3108138915 4225800.915245528, 1913629.1282999292 4225810.353602105))','ZO34024','"lib_modif"=>"N", "lib_code_insee"=>"38423", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UD1','Pavillonnaire en mutation','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD1.pdf','2019-12-20','SRID=3945;POLYGON ((1916357.61 4223312.16, 1916357.9394950285 4223312.294856615, 1916371.83 4223317.98, 1916385.05 4223323.4, 1916388.6386159249 4223324.8714939365, 1916398.39 4223328.87, 1916425.02 4223339.78, 1916426.87 4223340.53, 1916457.44 4223353.29, 1916475.58 4223360.87, 1916484.76 4223364.57, 1916485.6 4223364.92, 1916508.46 4223374.31, 1916517.1 4223377.82, 1916529.31 4223382.78, 1916535.657943437 4223385.3561257925, 1916542.5010160308 4223375.671537211, 1916529.5936999284 4223336.30320211, 1916527.371213811 4223330.464632742, 1916521.3693999283 4223314.697602111, 1916518.8612999283 4223307.3952021105, 1916518.2061092248 4223305.068781415, 1916522.1 4223303.33, 1916522.56 4223303.13, 1916523.49 4223302.71, 1916526.8325857336 4223301.238702849, 1916535.44 4223297.45, 1916547.22 4223292.36, 1916562.98 4223285.62, 1916578.62 4223278.89, 1916593.35 4223272.55, 1916601.69 4223268.82, 1916616.4 4223262.36, 1916624.38 4223258.9, 1916630.73 4223256.24, 1916633.16 4223255.21, 1916630.79 4223251.85, 1916633.8503962557 4223244.330922992, 1916630.1465458074 4223242.986839748, 1916627.366899928 4223240.159002111, 1916625.3620999283 4223236.858802112, 1916623.857099928 4223232.657602111, 1916597.7654583366 4223154.83001803, 1916587.7480354481 4223123.76090846, 1916588.6880035994 4223119.091355778, 1916583.7761306013 4223116.898325972, 1916563.2899860924 4223107.751769142, 1916543.8582256485 4223100.304493326, 1916540.302134157 4223098.941611447, 1916539.4517356819 4223098.618407908, 1916535.79 4223102.56, 1916527.35 4223111.72, 1916524.76 4223108.42, 1916523.71 4223107.37, 1916521.32 4223104.98, 1916521.0919192878 4223104.752956019, 1916519.9162266897 4223106.678136862, 1916519.1846999284 4223107.8760021115, 1916513.3872999283 4223114.985202112, 1916500.2923999282 4223129.205602113, 1916466.1547813367 4223164.0286727995, 1916462.0037999284 4223168.263002111, 1916465.9029898352 4223175.033064674, 1916462.1480118057 4223180.039702047, 1916455.7651613622 4223173.765035508, 1916451.7623568468 4223169.870414901, 1916449.8150465419 4223167.923104594, 1916449.4904948245 4223168.139472407, 1916447.4350006138 4223170.086782712, 1916445.5958742148 4223171.817725204, 1916444.297667345 4223173.007748169, 1916443.5403800043 4223168.355840217, 1916443.4321960984 4223167.490368972, 1916443.2158282867 4223166.949449443, 1916442.7830926632 4223166.516713819, 1916442.3503570403 4223166.083978198, 1916441.4848857936 4223165.867610384, 1916440.8357823587 4223165.759426478, 1916440.1866789237 4223165.651242571, 1916439.6457593946 4223165.651242572, 1916439.2130237713 4223165.759426478, 1916431.0992308345 4223167.598552878, 1916416.6025874543 4223170.844070052, 1916406.6496681187 4223173.007748168, 1916405.8923807777 4223173.22411598, 1916401.7813923566 4223174.19777113, 1916393.6675994198 4223175.928713626, 1916394.4248867605 4223183.0688514095, 1916394.5330706665 4223184.799793902, 1916394.8576223839 4223187.288023735, 1916395.1821741015 4223190.208989193, 1916395.5067258189 4223194.103609806, 1916396.047645348 4223198.322782131, 1916397.1294844062 4223208.600253184, 1916397.237668312 4223209.249356619, 1916397.7785878412 4223214.766735815, 1916397.4540361236 4223214.983103629, 1916389.232059281 4223215.848574873, 1916380.0364272862 4223216.822230026, 1916377.3318296405 4223217.25496565, 1916373.545392937 4223220.933218447, 1916377.2236457348 4223252.306551136, 1916359.914220803 4223270.156895597, 1916360.671508144 4223283.896251637, 1916368.568933269 4223287.249952718, 1916367.3789103047 4223289.846366457, 1916365.972519529 4223292.983699726, 1916364.27 4223296.99, 1916357.6252537374 4223312.125255376, 1916357.61 4223312.16))','ZO34036','"lib_modif"=>"N", "lib_code_insee"=>"38421", "lib_modif_comment"=>NULL',1);
INSERT INTO urba_plui_ecriture.zoneurba (idurba,libelle,libelong,typezone,nomfic,urlfic,datevalid,geom,lib_idzone,lib_hstore,lib_id_version) VALUES
     ('MJ3_PH1_ZON_050_09','UD3','Pavillonnaire en évolution modérée','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD3.pdf','2019-12-20','SRID=3945;POLYGON ((1916443.5175321342 4215450.650436962, 1916441.6112125972 4215476.089723665, 1916446.29 4215476.42, 1916446.84 4215476.52, 1916460.44 4215479.01, 1916463.79 4215479.59, 1916463.75 4215479.8, 1916493.81 4215484.27, 1916533.97 4215507.36, 1916532.32 4215509.52, 1916530.53 4215511.89, 1916529.29 4215513.51, 1916509.65 4215540.34, 1916506.2 4215545.05, 1916506.47 4215545.93, 1916506.9810356093 4215546.699107574, 1916511.7902697388 4215553.936995365, 1916516.4281839519 4215561.387580132, 1916521.7543047902 4215569.2869953085, 1916525.8237004871 4215574.822570337, 1916529.1749675316 4215580.537677529, 1916534.4412443154 4215587.5095098615, 1916537.0743827075 4215591.459217449, 1916542.3406594915 4215599.418476679, 1916544.734421666 4215602.799665751, 1916547.038417759 4215607.048593611, 1916547.1619851326 4215607.300221718, 1916547.53 4215606.98, 1916588.26 4215557.87, 1916580.95 4215540.43, 1916579.73 4215537.5, 1916578.92 4215518.53, 1916578.79 4215515.42, 1916576.96 4215492.39, 1916576.56 4215486.01, 1916575.05 4215462.28, 1916574.66 4215455.99, 1916574.27 4215450.97, 1916573.12 4215436.39, 1916571.79 4215411.85, 1916571.45 4215406.8, 1916568.98 4215404.32, 1916567.47 4215402.8, 1916561.02 4215396.32, 1916559.12 4215394.4, 1916555.7813238078 4215390.788778813, 1916555.69 4215390.69, 1916555.18 4215391.05, 1916554.85 4215390.67, 1916554.03 4215389.75, 1916549.15 4215384.23, 1916547.19 4215381.55, 1916545.42 4215379.14, 1916542.83 4215375.6, 1916536.7378161373 4215365.1588915475, 1916531.4213999277 4215368.570802133, 1916518.4209999277 4215376.787202133, 1916508.919899928 4215380.897602132, 1916502.8172999276 4215382.404002133, 1916494.3143999276 4215383.712402132, 1916487.8494264213 4215383.960679085, 1916488.01 4215386.72, 1916488.2 4215400.66, 1916488.27 4215409.5, 1916488.29 4215412.5, 1916479.54 4215411.91, 1916479.54 4215423.46, 1916472.94 4215422.58, 1916466.32 4215421.47, 1916463.47165853 4215452.210219089, 1916463.43 4215452.73, 1916456.8 4215451.95, 1916446.45 4215450.68, 1916443.5175321342 4215450.650436962))','ZO33660','"lib_modif"=>"N", "lib_code_insee"=>"38200", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','As','Agricole avec secteurs à protéger (stricts)','A',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/A.pdf','2019-12-20','SRID=3945;POLYGON ((1918313.97 4229373.7, 1918251.43 4229425.52, 1918238.33 4229433.92, 1918232.97 4229434.25, 1918200.09 4229407.63, 1918197.81 4229402.54, 1918206.2831150733 4229393.509056838, 1918269.96 4229325.64, 1918313.97 4229373.7))','ZO32713','"lib_modif"=>"N", "lib_code_insee"=>"38229", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UE2','Activités de production industrielle','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UE2.pdf','2019-12-20','SRID=3945;POLYGON ((1919750.1909138807 4213736.385879388, 1919727.9399999261 4213748.15000214, 1919737.5499999262 4213763.960002139, 1919742.4899999262 4213786.360002139, 1919746.1699999261 4213793.930002139, 1919749.3899999263 4213800.520002138, 1919757.820681039 4213802.222973822, 1919775.4299999261 4213805.780002138, 1919780.9799999262 4213806.910002139, 1919814.4599999262 4213788.040002139, 1919817.1799999261 4213787.050002139, 1919820.9599998526 4213785.660004279, 1919810.9799998526 4213766.290004278, 1919803.4399998526 4213754.370004278, 1919795.7599998526 4213742.580004278, 1919790.6499998525 4213734.300004279, 1919790.5199998526 4213734.0400042785, 1919782.845812619 4213719.121132007, 1919778.9931044667 4213721.15807089, 1919764.7295318225 4213728.699266484, 1919750.1909138807 4213736.385879388))','ZO32405','"lib_modif"=>"N", "lib_code_insee"=>"38528", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UD3','Pavillonnaire en évolution modérée','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UD3.pdf','2019-12-20','SRID=3945;POLYGON ((1919574.0461934633 4227937.983163697, 1919572.6567999276 4227937.871802098, 1919569.5557999276 4227939.075202098, 1919567.6580999277 4227941.979202097, 1919565.8590999276 4227944.682402098, 1919562.3639999276 4227952.990402098, 1919559.5674999275 4227958.296002098, 1919556.346495948 4227963.807922895, 1919551.7736999276 4227970.811202099, 1919546.175799928 4227976.919602098, 1919538.6385702745 4227982.939043689, 1919536.529150737 4227984.698296965, 1919511.3726583358 4228005.678780404, 1919490.222066295 4228022.188497219, 1919485.3061768604 4228025.768708382, 1919483.4035514684 4228027.154378413, 1919477.1891890806 4228032.0630100565, 1919468.5821999277 4228036.927002098, 1919464.0790999276 4228036.630802098, 1919460.3623067574 4228034.544587091, 1919454.4680999275 4228031.2362020975, 1919437.4510999275 4228023.646602098, 1919400.7136999276 4228007.269802099, 1919380.6926882889 4227997.712980596, 1919375.1867999276 4227995.084802099, 1919365.3584168276 4227990.108479788, 1919328.2363999276 4227971.3128021, 1919320.3298132177 4227967.889198234, 1919310.0181999279 4227963.424202098, 1919292.0029999278 4227958.837402097, 1919284.9846493797 4227956.45342333, 1919282.1406073256 4227955.4873650195, 1919279.059981437 4227954.440944403, 1919275.5090728765 4227961.841130029, 1919265.352583876 4227983.007516783, 1919255.323102678 4228003.909215978, 1919244.0886633894 4228027.322079117, 1919226.0562054173 4228064.902189678, 1919225.3798854838 4228066.299942742, 1919219.6328823508 4228078.177296703, 1919216.328549479 4228085.0063744355, 1919200.3354031784 4228118.374625376, 1919189.8330614176 4228140.286810056, 1919175.4638375342 4228170.982821656, 1919144.962399928 4228236.141002098, 1919136.0723999278 4228254.460202097, 1919132.725876478 4228261.43544026, 1919114.6999999278 4228299.007202096, 1919108.0107999279 4228315.923202097, 1919102.3320927445 4228349.899757778, 1919099.8424999279 4228356.856002096, 1919120.2513167441 4228375.45378618, 1919127.221328046 4228381.38645476, 1919141.501599928 4228393.541402097, 1919167.3588027244 4228415.56232185, 1919175.5097652033 4228423.396956527, 1919188.3973102593 4228439.477556088, 1919191.672647489 4228443.564400107, 1919201.488747489 4228454.562200107, 1919210.8320039075 4228465.532075332, 1919265.2986999277 4228527.913002097, 1919273.506979132 4228538.240190158, 1919288.0166851012 4228553.774556524, 1919302.0026711728 4228567.871419812, 1919313.262158336 4228577.414227771, 1919315.0024401885 4228578.703878571, 1919346.0149999277 4228601.686002094, 1919380.898099329 4228628.073502824, 1919392.9748736257 4228636.987457966, 1919449.9488999278 4228679.040402098, 1919462.965399928 4228688.690602779, 1919467.3066675332 4228691.548384429, 1919470.2172992432 4228693.464403124, 1919476.3253649867 4228695.658480436, 1919478.0199999276 4228691.5600021, 1919479.4999999276 4228686.000002098, 1919480.0099999276 4228682.020002098, 1919478.7799999276 4228676.850002097, 1919477.5299999276 4228672.070002099, 1919477.9899999276 4228668.100002097, 1919478.4499999275 4228666.290002097, 1919479.1299999277 4228663.6200020965, 1919480.0599999276 4228660.090002097, 1919481.6499999277 4228658.180002097, 1919485.5899999277 4228655.760002098, 1919487.7799999276 4228654.600002099, 1919489.8999999277 4228653.270002098, 1919494.3399999277 4228649.290002098, 1919499.4199999275 4228644.700002097, 1919512.1999999275 4228633.350002097, 1919517.9499999275 4228627.720002097, 1919525.5099999276 4228620.540002099, 1919530.6899999275 4228615.730002097, 1919538.2899999276 4228607.1200020965, 1919544.3299999277 4228600.630002097, 1919550.6899999275 4228593.820002097, 1919557.2699999276 4228585.9000021, 1919558.3199999277 4228580.670002098, 1919560.3999999277 4228567.260002098, 1919564.0799999277 4228544.660002098, 1919567.3299999277 4228527.050002097, 1919573.8499999277 4228515.930002099, 1919576.0699999277 4228512.630002098, 1919580.1499999277 4228508.130002097, 1919583.5099999276 4228505.7000020975, 1919588.4399999275 4228502.500002099, 1919592.8999999277 4228500.4700021, 1919596.3799999277 4228499.130002098, 1919598.4099999275 4228498.200002099, 1919601.3699999277 4228497.810002098, 1919609.0399999274 4228498.0400021, 1919612.3599999277 4228497.870002098, 1919616.5599999276 4228496.9100020975, 1919626.5699999277 4228493.730002099, 1919632.2799999276 4228491.780002098, 1919637.5499999276 4228489.540002097, 1919643.4399999275 4228486.800002098, 1919648.0499999276 4228483.980002098, 1919654.4699999276 4228479.400002099, 1919659.0599999276 4228476.4800021, 1919663.5699999277 4228473.640002098, 1919674.7899999276 4228467.620002098, 1919683.2299999276 4228462.990002097, 1919689.5299999276 4228459.1200021, 1919697.2099999276 4228453.800002098, 1919702.7099999276 4228450.600002097, 1919704.2899999276 4228449.040002098, 1919709.7999999276 4228441.600002097, 1919712.4699999276 4228438.440002098, 1919716.4599999276 4228435.1500021, 1919719.8099999276 4228432.510002097, 1919721.7799999276 4228429.940002097, 1919723.4199999275 4228426.830002098, 1919724.7299999273 4228424.950002099, 1919725.9799999273 4228424.490002099, 1919732.9899999276 4228421.310002098, 1919740.5199999276 4228418.460002098, 1919758.7799999276 4228411.270002099, 1919769.2199999276 4228407.220002098, 1919776.4899999276 4228403.2400020985, 1919790.5399999274 4228395.7000020975, 1919806.6099999277 4228387.850002098, 1919821.3499999277 4228381.100002098, 1919838.2099999276 4228372.4900020985, 1919853.5899999274 4228364.580002099, 1919872.1799999275 4228354.940002099, 1919896.4999999274 4228342.130002099, 1919919.2799999274 4228330.140002099, 1919938.0899999277 4228320.1600020975, 1919950.7999999274 4228313.170002098, 1919971.0299999274 4228300.800002099, 1919992.9799999273 4228287.6200021, 1920004.2499999274 4228281.170002098, 1920010.7899999274 4228277.080002098, 1920018.7499999274 4228271.6500021, 1920028.4899999273 4228265.350002099, 1920031.8999999275 4228263.760002098, 1920036.5099999274 4228261.5000021, 1920040.7799999274 4228258.830002098, 1920043.1399999275 4228257.3900021, 1920046.3599999275 4228255.290002101, 1920049.2999999274 4228253.340002098, 1920054.0699999274 4228249.2400021, 1920058.5699999274 4228244.550002098, 1920060.7399999273 4228242.330002098, 1920065.6899999273 4228234.020002099, 1920067.5399999274 4228225.250002099, 1920067.7499999274 4228221.880002098, 1920067.7099999273 4228217.350002098, 1920067.1899999273 4228207.2300021015, 1920066.3799999275 4228196.300002099, 1920065.3899999275 4228186.310002101, 1920063.8699999275 4228170.710002098, 1920063.6699999273 4228165.9100021, 1920063.8199999274 4228161.080002098, 1920064.3499999274 4228156.6300021, 1920063.0299999274 4228155.5400021, 1920058.5899999274 4228165.980002099, 1920054.0699999274 4228180.3300021, 1920012.0799999274 4228158.200002099, 1919981.4599999273 4228153.220002098, 1919981.8499999274 4228154.4700021, 1919915.5499999274 4228213.970002096, 1919914.4499999275 4228212.950002099, 1919912.6999999273 4228210.9800021015, 1919894.9699999273 4228191.190002099, 1919864.9299999273 4228157.980002099, 1919851.0399999276 4228142.6500021, 1919881.5099999274 4228116.5500021, 1919881.0599999274 4228105.470002098, 1919912.7699999274 4228076.590002101, 1919948.4399999273 4228043.950002099, 1919938.4499999273 4228013.170002101, 1919938.2899999274 4228012.660002098, 1919932.7799999276 4228000.430002098, 1919915.0499999274 4227963.6300021, 1919907.8799999275 4227950.6100021, 1919898.3099999274 4227933.460002099, 1919896.2899999274 4227929.870002099, 1919891.8999999275 4227921.9000021, 1919886.6699999273 4227912.400002099, 1919892.5499999274 4227905.190002101, 1919894.1899999275 4227906.550002099, 1919895.6799999273 4227907.750002099, 1919897.4899999273 4227908.9700021, 1919899.1299999277 4227909.970002099, 1919900.4099999275 4227910.6900021, 1919902.5399999274 4227911.770002102, 1919905.5199999274 4227912.930002102, 1919907.7999999274 4227913.6400021, 1919909.5599999276 4227914.090002098, 1919911.6799999273 4227914.4400021015, 1919914.6399999275 4227914.750002102, 1919917.7999999274 4227914.800002099, 1919920.9099999275 4227914.6500021, 1919922.9499999273 4227914.5400021, 1919924.9399999273 4227914.310002102, 1919926.2799999274 4227914.0200021, 1919929.0399999274 4227913.310002101, 1919930.9999999274 4227912.5900021, 1919933.0499999274 4227911.890002099, 1919934.9999999274 4227910.9300021, 1919936.2699999274 4227910.270002101, 1919938.2799999274 4227909.060002101, 1919939.7599999274 4227908.1000021, 1919941.9999999274 4227906.5200021, 1919944.0899999274 4227904.480002101, 1919946.0199999274 4227902.710002099, 1919947.9599999273 4227900.120002099, 1919955.8099999274 4227889.7400021, 1919965.6299999275 4227876.8200021, 1919967.8299999274 4227873.9800021015, 1919975.4599999273 4227878.6800021, 1920005.6299999275 4227894.400002099, 1920041.4099999275 4227913.5000021, 1920066.2899999274 4227926.670002098, 1920067.5199999274 4227927.230002101, 1920067.1899999273 4227925.010002101, 1920066.5299999274 4227919.9400021015, 1920065.4699999273 4227910.2800021, 1920064.6999999273 4227902.9600021, 1920063.8699999275 4227893.790002099, 1920063.3599999275 4227887.850002101, 1920063.2099999273 4227884.8200020995, 1920063.1599999275 4227882.930002099, 1920063.5199999274 4227872.5600021, 1920063.7999999274 4227868.880002099, 1920064.4299999273 4227865.5200021, 1920065.6399999275 4227861.660002101, 1920066.8999999275 4227858.820002101, 1920068.2099999273 4227856.5700021, 1920069.3399999274 4227855.0200021, 1920072.2899999274 4227850.620002099, 1920078.3399999274 4227842.980002101, 1920082.8599999275 4227837.770002102, 1920089.7199999273 4227829.720002101, 1920100.9799999273 4227816.910002099, 1920104.1499999275 4227813.1500021005, 1920106.9599999273 4227809.4900021, 1920109.9199999273 4227805.4900021, 1920111.4499999273 4227803.010002101, 1920113.0599999274 4227800.180002101, 1920117.3599999275 4227791.250002101, 1920118.929999927 4227787.4000021005, 1920120.4299999273 4227784.0700021, 1920121.9999999274 4227780.6500021005, 1920122.3299999274 4227780.3800021, 1920122.9699999273 4227779.7000021, 1920123.4299999273 4227779.140002102, 1920122.8299999274 4227778.860002098, 1920124.6299999275 4227774.9300021, 1920127.7499999274 4227767.9500021, 1920131.2099999273 4227760.260002101, 1920132.169999927 4227758.420002103, 1920133.7399999273 4227756.060002102, 1920134.8899999275 4227754.170002097, 1920140.7399999273 4227744.970002099, 1920143.5099999274 4227740.320002099, 1920144.7499999274 4227738.7600021, 1920151.5899999274 4227731.5200021, 1920164.229999927 4227717.6900021015, 1920169.0599999274 4227712.400002101, 1920177.5899999274 4227703.8900021, 1920182.3199999274 4227699.4300021, 1920184.1799999273 4227697.6400021, 1920188.7399999273 4227693.490002101, 1920193.2099999273 4227690.2400021, 1920197.6399999275 4227686.920002101, 1920198.2999999274 4227686.3700021, 1920200.9599999273 4227684.4000021005, 1920216.8399999274 4227672.660002102, 1920223.5199999274 4227667.3900021, 1920233.5199999274 4227659.590002101, 1920236.7499999274 4227657.070002101, 1920240.1999999273 4227653.740002099, 1920243.4799999273 4227650.470002101, 1920247.169999927 4227646.470002102, 1920248.8099999274 4227644.5500021, 1920250.3799999272 4227642.080002102, 1920255.0299999274 4227633.7700021, 1920259.9299999273 4227624.7000021, 1920265.9999999274 4227614.150002101, 1920267.2899999274 4227611.4400021015, 1920270.3599999275 4227606.4600021, 1920275.0999999274 4227599.1600021, 1920277.1499999275 4227596.1000021, 1920282.3299999272 4227589.270002102, 1920290.8299999272 4227577.550002101, 1920299.469999927 4227565.510002101, 1920317.3699999272 4227540.390002101, 1920332.8599999272 4227519.010002101, 1920344.0399999272 4227503.6900021015, 1920347.5099999274 4227499.060002102, 1920350.2399999273 4227495.600002102, 1920351.469999927 4227493.620002102, 1920353.3999999275 4227490.2300021, 1920354.5899999272 4227488.280002101, 1920362.669999927 4227478.7800021, 1920371.8599999275 4227468.020002101, 1920378.1599999275 4227460.480002102, 1920384.219999927 4227453.6600021, 1920387.8499999272 4227449.510002102, 1920389.5899999274 4227447.5900021, 1920393.0499999272 4227444.120002101, 1920395.1299999272 4227441.780002102, 1920396.7899999274 4227439.850002101, 1920398.7799999274 4227437.120002099, 1920399.9799999273 4227435.3700021, 1920405.8699999272 4227426.110002102, 1920407.3699999272 4227423.330002101, 1920408.239999927 4227421.890002101, 1920409.0099999271 4227422.420002102, 1920409.8299999272 4227421.150002103, 1920416.7799999272 4227416.760002101, 1920420.229999927 4227414.790002101, 1920425.5199999274 4227412.480002102, 1920429.7299999273 4227410.4800021, 1920432.3499999272 4227409.680002101, 1920435.989999927 4227409.390002103, 1920457.0199999271 4227410.620002102, 1920482.9099999273 4227412.600002102, 1920498.0499999272 4227413.930002099, 1920497.7099999273 4227411.430002101, 1920496.8199999272 4227406.650002103, 1920492.2999999272 4227382.240002102, 1920488.0699999272 4227358.400002101, 1920487.2799999272 4227353.550002102, 1920486.0699999272 4227349.620002101, 1920484.7899999272 4227346.2300021015, 1920482.709999927 4227342.2000021, 1920480.419999927 4227338.450002103, 1920478.2899999272 4227335.110002102, 1920476.219999927 4227332.380002101, 1920473.6099999272 4227329.860002103, 1920469.929999927 4227326.450002102, 1920450.5099999271 4227311.910002102, 1920431.2799999274 4227297.5800021, 1920404.469999927 4227277.440002103, 1920370.6599999275 4227326.990002102, 1920370.8799999272 4227337.7600021, 1920358.6199999272 4227337.120002102, 1920356.3599999272 4227333.940002102, 1920353.5099999271 4227329.680002102, 1920352.5099999271 4227328.120002103, 1920351.3399999272 4227326.5600021025, 1920350.1399999273 4227324.890002101, 1920349.1299999272 4227323.410002102, 1920347.6899999273 4227321.930002102, 1920346.4099999275 4227320.1900021015, 1920344.5499999274 4227318.1400021, 1920342.4999999274 4227316.080002102, 1920339.3799999272 4227313.190002102, 1920338.4599999273 4227312.340002101, 1920337.2799999272 4227311.110002102, 1920334.7299999273 4227309.510002102, 1920302.989999927 4227288.110002102, 1920299.5099999271 4227285.690002102, 1920298.5199999271 4227284.990002101, 1920274.8299999272 4227268.890002101, 1920271.419999927 4227266.570002104, 1920268.9799999273 4227265.110002101, 1920249.3899999273 4227251.640002101, 1920246.4299999273 4227249.680002101, 1920241.5699999272 4227246.580002102, 1920238.9899999273 4227245.0000021, 1920237.2999999272 4227244.200002103, 1920236.0599999272 4227243.750002101, 1920234.9499999273 4227243.4100021, 1920233.5599999274 4227243.050002101, 1920231.2599999271 4227242.7300021015, 1920229.7099999273 4227242.470002099, 1920227.719999927 4227242.290002104, 1920226.6099999272 4227242.270002101, 1920224.2899999274 4227242.280002101, 1920222.1799999273 4227242.500002101, 1920218.1799999273 4227242.9200021, 1920203.7499999271 4227244.070002102, 1920192.2699999274 4227245.170002102, 1920188.4999999274 4227246.460002103, 1920174.3199999272 4227246.860002102, 1920155.4799999273 4227248.320002101, 1920138.3899999273 4227249.860002102, 1920117.0999999272 4227251.660002102, 1920102.6199999272 4227253.020002102, 1920096.6699999273 4227253.290002102, 1920091.7799999274 4227253.270002102, 1920088.2399999273 4227253.260002102, 1920085.3399999274 4227253.220002101, 1920081.2299999273 4227252.890002099, 1920077.8499999274 4227252.710002101, 1920071.6899999273 4227251.920002101, 1920069.5099999274 4227251.550002102, 1920061.6799999273 4227249.990002101, 1920055.9699999273 4227248.850002101, 1920041.6299999275 4227246.420002102, 1920030.1299999275 4227244.310002102, 1920024.2499999274 4227243.450002102, 1920013.4999999274 4227240.420002102, 1920000.3899999275 4227232.580002101, 1919991.3999999275 4227226.720002102, 1919940.1599999275 4227192.220002102, 1919927.2099999273 4227183.570002102, 1919885.770089215 4227224.010269959, 1919900.2203346617 4227231.086372962, 1919902.7581301676 4227232.329099424, 1919906.6399999275 4227234.230002102, 1919906.06 4227236.43, 1919905.479999927 4227238.330002103, 1919902.4699999273 4227244.140002101, 1919897.3399999274 4227249.110002101, 1919896.4199999273 4227249.610002101, 1919894.9399999273 4227250.620002102, 1919893.1399999275 4227251.8700021, 1919892.0699999274 4227252.650002102, 1919889.9199999273 4227255.130002101, 1919888.4199999273 4227256.7700021025, 1919886.6899999273 4227259.140002102, 1919885.5899999274 4227260.530002104, 1919884.5199999274 4227262.0300021, 1919882.3799999275 4227264.150002102, 1919876.5899999277 4227270.260002101, 1919871.2099999273 4227276.230002102, 1919867.5999999274 4227280.040002102, 1919865.8799999275 4227282.340002102, 1919862.9299999273 4227286.280002101, 1919861.2699999274 4227288.5200021025, 1919857.7399999273 4227295.090002102, 1919853.1199999275 4227303.420002102, 1919851.5599999274 4227306.3600021005, 1919848.6899999273 4227311.350002102, 1919846.9499999273 4227314.530002102, 1919840.4699999273 4227322.850002102, 1919836.9599999273 4227327.850002103, 1919830.9599999273 4227334.420002101, 1919829.5799999274 4227336.670002102, 1919824.6199999275 4227343.390002102, 1919823.1799999275 4227345.4700021, 1919817.0699999274 4227353.3100021025, 1919813.1399999275 4227358.180002104, 1919811.8099999274 4227360.180002102, 1919810.0899999274 4227362.8600021005, 1919808.5899999274 4227364.9300021, 1919804.7099999273 4227370.240002101, 1919803.1399999275 4227372.400002102, 1919801.3199999274 4227375.4400021015, 1919800.5699999274 4227376.780002101, 1919798.3899999275 4227383.630002099, 1919796.2799999274 4227389.040002101, 1919794.049233426 4227395.852129343, 1919792.12 4227402.51, 1919786.8331779297 4227406.791882342, 1919779.85 4227412.4, 1919775.6899999273 4227424.790002102, 1919772.4899999273 4227431.640002102, 1919769.4899999273 4227438.390002102, 1919766.8499999274 4227444.270002102, 1919764.1299999277 4227449.8800021, 1919759.8599999277 4227458.080002099, 1919753.9599999273 4227470.650002101, 1919748.8299999274 4227481.610002101, 1919748.3199999277 4227483.8000021, 1919747.6499999277 4227486.6000021, 1919747.3499999274 4227489.840002102, 1919747.2499999274 4227491.3000021, 1919746.0799999274 4227502.090002101, 1919744.7899999274 4227515.3000021, 1919744.3199999277 4227520.080002101, 1919741.3499999277 4227532.090002099, 1919737.9199999273 4227546.580002101, 1919734.5199999274 4227555.160002101, 1919730.5999999274 4227565.200002101, 1919728.7199999273 4227568.640002102, 1919723.3699999275 4227578.490002101, 1919714.9799999276 4227592.5000021, 1919705.0799999274 4227606.060002102, 1919694.6899999273 4227620.410002101, 1919697.1399999277 4227627.560002101, 1919689.5 4227637.76, 1919688.6 4227639.06, 1919683.11 4227646.74, 1919676.43 4227656.37, 1919673.89 4227660.91, 1919670.55 4227665.97, 1919668.26 4227669.09, 1919666.84 4227670.78, 1919663.98 4227675.33, 1919659 4227683.19, 1919655.88 4227688.77, 1919654.59 4227688.11, 1919653.56 4227690.28, 1919653.03 4227691.3, 1919645.18 4227708.19, 1919640.76 4227717.74, 1919639.26 4227720.9, 1919637.6705911676 4227724.959196535, 1919636.57 4227727.77, 1919630.81 4227739.38, 1919627.0586346493 4227747.150219361, 1919625.06 4227751.29, 1919623.02 4227756.02, 1919620.17 4227761.91, 1919619.16 4227763.85, 1919618.14 4227766.9, 1919615.3 4227775.01, 1919613.36 4227780.88, 1919612.56 4227783.23, 1919611.45 4227785.79, 1919609.36 4227791.43, 1919608.3299999274 4227793.900002101, 1919606.2999999274 4227798.7900021, 1919607.4999999276 4227799.390002099, 1919604.8299999277 4227807.5400021, 1919603.4599999276 4227812.190002102, 1919602.5799999274 4227815.2100021, 1919600.5399999276 4227821.3600021, 1919598.3199999277 4227827.840002101, 1919597.3399999277 4227832.6600021, 1919596.6399999277 4227835.7300021, 1919594.0099999276 4227844.800002099, 1919593.1099999277 4227846.950002101, 1919591.1899999273 4227852.3600021005, 1919587.5699999277 4227861.5800021, 1919585.7899999274 4227866.180002102, 1919582.9599999273 4227873.420002101, 1919581.8699999277 4227880.1700021, 1919579.2299999276 4227890.2200021, 1919578.9299999275 4227892.4400021, 1919578.1099999277 4227896.200002099, 1919578.0999999277 4227898.490002099, 1919577.8799999275 4227902.0300021, 1919577.8399999277 4227903.830002101, 1919577.4899999276 4227906.4500021, 1919576.9499999275 4227910.9300021, 1919576.3299999274 4227913.630002101, 1919575.9799999276 4227915.5300021, 1919575.7899999276 4227919.040002099, 1919575.6999999275 4227920.8100021, 1919575.8799999277 4227925.3200021, 1919575.7699999276 4227929.2900021, 1919575.7699999276 4227932.3800021, 1919575.4799999276 4227934.4200021, 1919574.0461934633 4227937.983163697))','ZO32137','"lib_modif"=>"N", "lib_code_insee"=>"38229", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','UA3','Hameaux anciens ','U',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/UA3.pdf','2019-12-20','SRID=3945;POLYGON ((1920140.1199999263 4213960.910002138, 1920130.67 4213950.28, 1920127.7999999262 4213951.77000214, 1920126.6799999261 4213952.64000214, 1920125.7399999262 4213953.57000214, 1920112.5099999262 4213963.010002139, 1920132.1699999261 4213991.430002138, 1920135.8799999263 4213997.07000214, 1920129.72 4213996.61, 1920121.74 4213996.83, 1920116.6 4213997.71, 1920109.7 4214001.49, 1920111.4232438535 4214004.007071087, 1920072.9899999262 4214024.36000214, 1920070.1199999263 4214026.620002139, 1920073.7399999262 4214031.200002138, 1920082.8199999263 4214036.870002138, 1920094.3259567101 4214054.794712261, 1920092.4 4214056.27, 1920086.4 4214061.09, 1920096.2160595702 4214074.587631398, 1920108.7699999262 4214091.850002139, 1920114.2499999262 4214099.380002138, 1920117.35 4214103.64, 1920126.9399999261 4214097.48000214, 1920124.5199999262 4214094.120002138, 1920124.8099999262 4214093.95000214, 1920135.6499999263 4214087.660002138, 1920143.0299999262 4214083.360002139, 1920165.6099999263 4214070.230002138, 1920178.6699999261 4214091.210002139, 1920179.5699999263 4214091.380002138, 1920181.059999926 4214093.890002138, 1920187.4099999263 4214104.2400021395, 1920205.6799999261 4214087.200002139, 1920209.4299999261 4214083.590002138, 1920210.1499999263 4214082.900002139, 1920231.0299999262 4214062.750002139, 1920230.6599999263 4214062.210002137, 1920213.4799999262 4214037.300002137, 1920212.0999999263 4214035.440002138, 1920225.7399999262 4214026.180002138, 1920235.599999926 4214004.84000214, 1920239.6248366663 4213994.882101514, 1920237.9199999264 4213994.480002129, 1920231.3199999265 4213976.68000213, 1920227.1199999265 4213965.1900021285, 1920225.7799999267 4213961.510002131, 1920223.7499999264 4213959.070002129, 1920213.5399999267 4213963.790002127, 1920209.3099999262 4213957.300002138, 1920206.2599999262 4213952.600002138, 1920198.6599999263 4213955.660002138, 1920164.9499999261 4213953.340002138, 1920150.4099999263 4213957.78000214, 1920140.1199999263 4213960.910002138))','ZO34353','"lib_modif"=>"N", "lib_code_insee"=>"38528", "lib_modif_comment"=>NULL',1),
     ('MJ3_PH1_ZON_050_09','N','Naturelle','N',NULL,'https://sitdl.lametro.fr/urba_posplu/Webcarto/Reglement_zonage/N.pdf','2019-12-20','SRID=3945;POLYGON ((1906555.67 4226471.33, 1906850.6859354528 4226393.62304505, 1906720.542237496 4226520.623175423, 1906082.2243871945 4227661.631886389, 1906082.62 4227663.14, 1906079.85 4227688.97, 1906074.67 4227732.84, 1906076.33 4227765.8, 1906078.19 4227797.44, 1906079.9 4227824.72, 1906080 4227833.72, 1906079.65 4227844.62, 1906076.76 4227867.13, 1906073.42 4227885.89, 1906070.39 4227900.52, 1906067.1 4227914.68, 1906064.7776469947 4227916.205220566, 1906105.520000002 4227944.984999993, 1906191.6694418911 4228000.947647354, 1906289.6874999988 4228070.037500022, 1906345.2324999112 4228134.027499977, 1906428.6574999143 4228217.005000039, 1906490.7105875204 4228257.005765009, 1906549.686912968 4228283.52211545, 1906574.936447359 4228311.190627515, 1906581.4756376387 4228331.063117401, 1906625.7549999955 4228362.057500002, 1906725.7275000191 4228425.984999961, 1906912.400650728 4228543.409350329, 1906957.086701788 4228571.51853741, 1906988.4425000062 4228591.242499973, 1907067.9072186833 4228640.818409122, 1907199.6893814225 4228723.033770054, 1907243.0375000015 4228750.077499953, 1907339.2127831464 4228810.665533335, 1907343.250340323 4228813.209093811, 1907387.0987499997 4228840.832499974, 1907436.0749999916 4228871.593749962, 1907514.9685677313 4228920.882529833, 1907513.2624744647 4228934.8770862315, 1907629.6625000779 4229025.328750031, 1907631.592619693 4229024.074482022, 1907651.4665634106 4228997.5873027975, 1907654.5587139716 4228993.628525014, 1907670.815544505 4228975.604366793, 1907671.1533986058 4228963.922034978, 1907688.4635338427 4228944.432361525, 1907688.9877023061 4228943.124103038, 1907689.4010983272 4228942.362443165, 1907690.8381146777 4228939.714818043, 1907688.7008615024 4228932.75146367, 1907688.3901455738 4228932.347399609, 1907700.7266799533 4228923.179143349, 1907707.7052100135 4228917.95766881, 1907719.382852509 4228908.311911898, 1907744.842354314 4228887.317124998, 1907751.833785534 4228881.242866083, 1907776.3093996637 4228857.527221478, 1907781.2715491522 4228848.126082367, 1907781.9874945336 4228842.962000152, 1907784.9917189947 4228840.1764298845, 1907785.2919198498 4228837.224454808, 1907785.6299999317 4228833.900002096, 1907786.5199999316 4228831.230002097, 1907790.7299999313 4228822.050002098, 1907795.4699999315 4228813.410002096, 1907801.6699999315 4228802.890002096, 1907809.5599999316 4228793.780002098, 1907820.8999999317 4228781.870002096, 1907823.2399999315 4228778.270002097, 1907827.6699999315 4228774.150002097, 1907830.7399999315 4228773.490002095, 1907843.8499999314 4228771.680002097, 1907849.5199999313 4228768.760002097, 1907855.7599999316 4228764.560002097, 1907862.6199999317 4228758.490002097, 1907864.8799999314 4228757.020002099, 1907872.0499999316 4228754.900002097, 1907877.3799999314 4228752.810002098, 1907886.8399999314 4228746.970002098, 1907897.8299999316 4228740.320002097, 1907908.1899999315 4228733.750002096, 1907914.4999999315 4228730.010002096, 1907937.3299999316 4228720.120002096, 1907944.5499999314 4228717.170002096, 1907950.7299999315 4228715.190002097, 1907968.0199999316 4228711.350002096, 1907974.9999999313 4228697.020002097, 1907997.9399999313 4228684.080002097, 1908008.7099999313 4228678.230002098, 1908013.8299999314 4228674.310002098, 1908028.3899999314 4228662.640002097, 1908044.1899999315 4228649.860002098, 1908062.3099999316 4228635.2500020955, 1908079.9799999315 4228620.940002097, 1908095.7599999313 4228606.740002098, 1908106.8999999315 4228596.640002096, 1908123.3399999314 4228586.260002098, 1908145.7599999313 4228560.170002098, 1908152.7799999313 4228551.990002099, 1908175.4899999313 4228528.500002097, 1908186.7799999313 4228516.280002097, 1908190.9799999313 4228512.090002097, 1908197.3199999314 4228516.920002095, 1908203.4399999313 4228506.380002097, 1908209.2899999316 4228495.610002095, 1908215.7199999313 4228488.050002097, 1908228.8099999314 4228472.250002097, 1908247.7599999313 4228461.190002098, 1908258.7499999313 4228450.130002097, 1908270.3299999314 4228439.150002097, 1908286.7399999313 4228428.440002098, 1908301.8499999314 4228418.550002096, 1908323.9299999312 4228409.070002097, 1908324.4599999313 4228410.7000020975, 1908357.8599999314 4228391.690002099, 1908391.0599999314 4228372.870002098, 1908391.9899999313 4228374.290002096, 1908418.8999999315 4228496.630002098, 1908447.2799999313 4228505.170002095, 1908462.7299999313 4228509.590002097, 1908467.9799999313 4228510.170002098, 1908484.7599999313 4228518.750002097, 1908499.0699999314 4228507.050002097, 1908548.4899999313 4228466.560002097, 1908550.6499999315 4228464.890002098, 1908551.8499999314 4228463.510002096, 1908542.4199999312 4228452.770002097, 1908523.77 4228387.41, 1908493.01 4228319.84, 1908502.3 4228313.18, 1908512.37 4228305.97, 1908523.33 4228298.36, 1908533.29 4228291.27, 1908538.98 4228287.02, 1908541.58 4228284.02, 1908542.98 4228278.8, 1908544.26 4228273.57, 1908545.53 4228271.1, 1908547.36 4228268.14, 1908549.09 4228266.14, 1908552.01 4228262.19, 1908556.6544971499 4228259.521962061, 1908555.39 4228257.69, 1908551.49 4228252.71, 1908556.47 4228248.42, 1908553.35 4228242.39, 1908544.43 4228235.62, 1908532.66 4228227.14, 1908483.0999999314 4228217.140002097, 1908488.5099999313 4228202.170002098, 1908489.4599999313 4228198.030002097, 1908489.3999999315 4228190.840002097, 1908489.0499999311 4228178.180002099, 1908488.8899999312 4228160.930002098, 1908489.5199999313 4228152.890002099, 1908490.4599999313 4228141.5700020995, 1908491.19 4228137.33, 1908494.72 4228129.61, 1908497.31 4228125.05, 1908504.53 4228113.06, 1908513.96 4228097.81, 1908515.89 4228093.73, 1908517.96 4228087.57, 1908570.24 4228082.33, 1908570.23 4228083.16, 1908570.68 4228086.68, 1908572.09 4228093, 1908572.83 4228095.57, 1908576.71 4228103.83, 1908581.68 4228114.58, 1908585.64 4228123.18, 1908589.09 4228131.66, 1908592.5 4228140.11, 1908591.68 4228145.94, 1908593.12 4228159.8, 1908594.4 4228172.52, 1908595.01 4228180.1, 1908595.69 4228184.75, 1908595.84 4228186.81, 1908595.48 4228192.96, 1908595.8 4228199.2, 1908612.33 4228187.84, 1908622.19 4228181.06, 1908631.61 4228174.52, 1908637.82 4228170.29, 1908646.74 4228162.3, 1908656.24 4228154.19, 1908664.79 4228146.85, 1908674.61 4228138.85, 1908690.74 4228125.82, 1908696.79 4228126.4, 1908706.76 4228125.71, 1908709.57 4228125.05, 1908717.29 4228123.28, 1908755.77 4228114.44, 1908775.04 4228110.5, 1908792.18 4228107.55, 1908802.22 4228106.55, 1908807.26 4228102.81, 1908810.83 4228098.72, 1908815.64 4228090.93, 1908822.15 4228081.22, 1908821.79 4228078.52, 1908826.31 4228071.42, 1908836.05 4228056.95, 1908840.2 4228051.07, 1908854.669999931 4228047.200002098, 1908857.6599999312 4228030.070002099, 1908853.7899999311 4228022.630002099, 1908849.6099999312 4228018.440002101, 1908841.739999931 4228013.0700020995, 1908837.5699999311 4228010.000002098, 1908831.0599999311 4228006.710002099, 1908828.469999931 4228005.440002098, 1908821.019999931 4228002.590002097, 1908816.625804366 4228001.506198829, 1908815.0599999311 4228001.120002098, 1908809.169999931 4227999.760002099, 1908805.1199999312 4227999.010002097, 1908800.7899999311 4227998.500002098, 1908794.9099999312 4227997.700002098, 1908784.249999931 4227997.5200021, 1908778.3399999312 4227996.910002098, 1908770.1399999312 4227995.670002099, 1908766.1499999312 4227994.800002098, 1908758.749999931 4227993.2700021, 1908751.2399999313 4227991.6200020965, 1908745.1199999312 4227990.410002098, 1908743.3299999312 4227990.120002099, 1908739.509999931 4227989.500002099, 1908735.3899999312 4227988.780002099, 1908732.669999931 4228006.380002098, 1908726.699999931 4228005.600002098, 1908725.739999931 4228011.550002098, 1908704.979999931 4228008.630002099, 1908705.519999931 4228022.550002098, 1908698.5999999314 4228022.840002099, 1908685.8899999314 4228023.110002097, 1908676.179999931 4228014.220002097, 1908664.519999931 4228013.550002097, 1908651.6099999314 4228003.710002098, 1908649.8399999312 4227997.930002099, 1908641.999999931 4227995.3400021, 1908637.029999931 4227994.600002099, 1908626.9499999313 4227995.880002099, 1908619.219999931 4227997.7200021, 1908607.3099999311 4228000.4900021, 1908598.1599999312 4228003.0600021, 1908591.1399999312 4228003.8100021, 1908579.469999931 4228004.9800021, 1908576.5699999311 4228005.1200021, 1908573.5399999314 4228005.770002099, 1908567.029999931 4228007.800002098, 1908553.6599999315 4228012.280002098, 1908549.6199999312 4228015.2300021, 1908542.019999931 4228020.470002099, 1908536.8399999314 4228025.090002099, 1908540.5299999313 4228038.100002098, 1908543.6499999312 4228043.4400021, 1908542.209999931 4228044.210002099, 1908549.4499999313 4228066.300002098, 1908518.5399999314 4228069.070002097, 1908516.4599999313 4228069.260002097, 1908514.5499999314 4228069.420002097, 1908518.7399999313 4228058.9400021, 1908519.4599999313 4228050.610002098, 1908519.979999931 4228042.780002099, 1908520.1799999312 4228039.910002097, 1908521.3299999314 4228036.310002099, 1908521.6799999312 4228035.500002098, 1908517.4499999313 4228028.790002098, 1908516.029999931 4228025.330002102, 1908514.7999999311 4228022.260002099, 1908514.949999931 4228020.7400020985, 1908515.4599999313 4228019.390002097, 1908516.709999931 4228017.580002099, 1908524.0699999311 4228009.250002097, 1908513.1299999314 4227991.500002099, 1908509.2499999313 4227985.5800020965, 1908509.2499999313 4227984.720002098, 1908510.1399999312 4227984.4000021, 1908513.0699999314 4227983.7000020975, 1908515.3099999311 4227982.790002098, 1908516.259999931 4227981.630002099, 1908516.8699999312 4227980.4100021, 1908517.3899999314 4227979.340002098, 1908517.5499999314 4227977.670002099, 1908517.6999999313 4227975.370002099, 1908519.5499999311 4227963.7800020985, 1908520.459999931 4227956.730002098, 1908521.709999931 4227949.8600021, 1908522.6999999313 4227946.750002097, 1908524.459999931 4227942.970002098, 1908526.5899999312 4227939.1900021, 1908530.1199999312 4227937.6600021, 1908532.9099999312 4227936.9400021, 1908546.5599999311 4227935.880002098, 1908558.2999999311 4227934.970002099, 1908603.3499999312 4227932.050002098, 1908605.9799999313 4227932.620002099, 1908608.029999931 4227933.060002099, 1908598.8199999314 4227909.310002099, 1908590.5399999311 4227894.520002101, 1908588.019999931 4227890.020002099, 1908578.0799999312 4227872.160002099, 1908563.4299999312 4227846.810002099, 1908551.9599999313 4227827.340002098, 1908546.259999931 4227814.0200021, 1908545.759999931 4227812.310002099, 1908544.3799999314 4227807.670002099, 1908544.0499999314 4227803.640002097, 1908539.1499999312 4227798.490002099, 1908535.6199999312 4227794.7800021, 1908533.229999931 4227793.170002099, 1908529.989999931 4227792.3800021, 1908527.1499999315 4227792.160002098, 1908522.689999931 4227792.730002099, 1908517.9399999313 4227794.200002098, 1908510.3699999312 4227797.340002098, 1908504.029999931 4227800.270002102, 1908500.3499999312 4227802.640002098, 1908476.1599999312 4227792.620002098, 1908499.259999931 4227757.820002099, 1908502.9499999313 4227752.250002098, 1908512.0499999314 4227734.640002098, 1908518.0499999314 4227723.020002099, 1908520.7799999313 4227719.7300021, 1908523.4799999313 4227717.940002098, 1908527.3799999312 4227716.080002101, 1908528.4299999312 4227715.580002099, 1908536.2899999311 4227712.410002101, 1908480.9299999312 4227686.880002099, 1908488.1099999314 4227677.830002097, 1908493.0099999313 4227669.030002099, 1908493.969999931 4227661.1600021, 1908490.5299999313 4227657.450002099, 1908501.0899999314 4227639.810002098, 1908505.959999931 4227631.6600021, 1908510.929999931 4227618.230002099, 1908515.469999931 4227608.930002099, 1908518.489999931 4227601.980002101, 1908521.999999931 4227593.370002099, 1908533.2399999313 4227597.710002099, 1908562.459999931 4227609.7000021, 1908584.9399999313 4227618.930002098, 1908597.1299999312 4227599.1100021, 1908606.0599999311 4227581.980002099, 1908614.9099999312 4227564.2200021, 1908626.699999931 4227538.6500021005, 1908635.3299999312 4227519.870002101, 1908636.5599999314 4227514.560002098, 1908636.8199999311 4227508.370002101, 1908634.3299999312 4227493.760002099, 1908627.8699999312 4227466.640002099, 1908620.3399999312 4227437.6600021, 1908617.8099999311 4227430.1300021, 1908612.8499999314 4227421.120002099, 1908600.519999931 4227401.780002101, 1908589.6499999312 4227384.590002101, 1908584.919999931 4227374.780002101, 1908582.1099999312 4227367.960002102, 1908580.0799999312 4227361.810002101, 1908577.179999931 4227340.550002099, 1908576.0499999314 4227332.450002101, 1908575.669999931 4227327.1100021005, 1908575.8599999314 4227313.1900021, 1908576.449999931 4227303.940002101, 1908578.5499999311 4227289.200002102, 1908579.939999931 4227278.9500021, 1908579.6399999312 4227270.7100021, 1908576.949999931 4227256.090002101, 1908574.769999931 4227243.230002101, 1908574.0599999311 4227232.790002099, 1908573.689999931 4227220.500002101, 1908571.689999931 4227213.610002102, 1908569.9099999312 4227206.8300021, 1908568.8999999312 4227196.270002102, 1908567.939999931 4227187.000002101, 1908567.2899999311 4227177.080002101, 1908567.1499999312 4227170.1800021, 1908567.3899999312 4227164.1800021, 1908567.419999931 4227158.050002101, 1908568.0399999311 4227149.920002099, 1908568.759999931 4227142.870002102, 1908569.8799999312 4227134.000002103, 1908571.0699999311 4227126.170002102, 1908572.499999931 4227117.840002102, 1908573.9099999312 4227110.240002101, 1908575.249999931 4227102.7700021025, 1908577.029999931 4227092.0200021025, 1908579.0399999311 4227080.4500021, 1908580.449999931 4227071.5500021, 1908581.939999931 4227062.770002102, 1908583.6499999312 4227053.000002102, 1908585.0799999312 4227044.290002099, 1908585.3699999312 4227040.010002099, 1908585.269999931 4227035.620002103, 1908584.4899999313 4227030.7400021, 1908583.8699999312 4227027.0200021025, 1908582.8399999312 4227023.510002103, 1908582.2899999311 4227021.640002101, 1908586.1099999312 4227010.980002102, 1908588.469999931 4227010.600002102, 1908590.749999931 4227009.8700021, 1908592.8799999312 4227008.770002102, 1908594.8199999311 4227007.370002099, 1908596.509999931 4227005.660002103, 1908597.9099999312 4227003.720002101, 1908598.999999931 4227001.600002099, 1908599.729999931 4226999.3200021, 1908600.0999999312 4226996.950002101, 1908600.0899999312 4226994.560002101, 1908599.709999931 4226992.1900021015, 1908598.979999931 4226989.920002101, 1908597.8799999312 4226987.790002102, 1908596.479999931 4226985.860002101, 1908594.769999931 4226984.160002104, 1908592.8399999312 4226982.760002102, 1908590.709999931 4226981.680002102, 1908588.429999931 4226980.9400021015, 1908589.449999931 4226971.540002102, 1908589.959999931 4226969.100002102, 1908591.5599999314 4226962.8700021, 1908592.259999931 4226956.1300021, 1908592.0899999312 4226952.920002101, 1908592.429999931 4226950.820002102, 1908594.0899999312 4226947.010002099, 1908596.5599999311 4226942.0200021025, 1908599.479999931 4226935.2200021, 1908601.8599999312 4226929.300002101, 1908604.519999931 4226921.860002102, 1908607.919999931 4226911.7600021, 1908611.449999931 4226900.960002102, 1908614.439999931 4226892.3900021035, 1908617.0499999311 4226884.540002101, 1908619.4099999312 4226877.610002101, 1908621.519999931 4226871.190002101, 1908623.8499999312 4226863.800002101, 1908625.729999931 4226858.620002101, 1908627.7999999311 4226853.440002102, 1908630.679999931 4226847.420002103, 1908634.459999931 4226839.940002103, 1908635.719999931 4226837.240002102, 1908637.6299999312 4226834.070002101, 1908640.0999999312 4226831.060002102, 1908642.959999931 4226827.930002102, 1908646.3299999312 4226824.700002101, 1908648.749999931 4226823.1000021, 1908657.759999931 4226814.420002102, 1908636.7899999311 4226816.740002103, 1908635.6399999312 4226817.080002103, 1908633.8099999311 4226817.660002101, 1908636.3099999311 4226803.650002101, 1908640.9099999312 4226801.270002102, 1908638.5699999314 4226793.0100021, 1908639.8099999311 4226788.630002103, 1908643.009999931 4226777.310002104, 1908645.7999999311 4226767.410002102, 1908652.3099999311 4226769.440002102, 1908653.439999931 4226765.300002102, 1908652.5799999312 4226765.030002102, 1908653.0999999312 4226762.990002103, 1908654.3199999311 4226753.940002102, 1908655.769999931 4226743.250002101, 1908653.3099999311 4226742.910002101, 1908653.499999931 4226736.030002101, 1908653.6599999312 4226729.730002102, 1908653.8199999311 4226723.960002104, 1908650.3499999312 4226689.690002101, 1908645.669999931 4226689.750002102, 1908643.1299999312 4226689.720002103, 1908642.919999931 4226681.080002101, 1908642.8399999312 4226677.320002102, 1908635.3899999312 4226680.180002103, 1908634.5399999311 4226678.430002102, 1908632.5999999312 4226679.170002102, 1908625.459999931 4226682.890002102, 1908615.3599999312 4226688.170002103, 1908614.1199999312 4226685.350002103, 1908611.749999931 4226679.970002101, 1908609.0499999311 4226673.680002103, 1908607.489999931 4226668.360002102, 1908607.209999931 4226667.370002103, 1908603.3699999312 4226663.040002102, 1908602.7999999311 4226660.790002102, 1908602.419999931 4226651.910002101, 1908601.209999931 4226649.980002103, 1908600.7899999311 4226648.500002103, 1908600.6499999312 4226646.690002102, 1908601.1399999312 4226644.3100021025, 1908603.989999931 4226638.2700021025, 1908601.7999999311 4226631.920002102, 1908600.489999931 4226628.940002102, 1908598.6599999312 4226625.040002101, 1908602.6499999312 4226623.050002102, 1908602.969999931 4226623.470002103, 1908606.3999999312 4226622.1000021035, 1908607.1199999312 4226623.360002103, 1908609.019999931 4226622.920002101, 1908614.6199999312 4226625.620002101, 1908625.019999931 4226618.680002103, 1908635.6299999314 4226606.910002101, 1908633.549999931 4226602.1400021035, 1908633.919999931 4226600.420002103, 1908632.9722861997 4226598.3671471095, 1908630.9099999312 4226593.900002101, 1908628.279999931 4226586.960002102, 1908628.6499999312 4226586.940002102, 1908625.959999931 4226580.410002101, 1908626.5599999311 4226579.950002101, 1908623.5599999311 4226573.360002103, 1908621.9952146 4226569.808868268, 1908621.3699999312 4226568.390002101, 1908620.279999931 4226565.790002104, 1908619.5499999311 4226563.110002103, 1908619.6599999312 4226561.210002104, 1908620.179999931 4226559.820002102, 1908621.239999931 4226558.360002103, 1908623.189999931 4226556.320002105, 1908626.429999931 4226553.0600021025, 1908629.5699999311 4226550.340002102, 1908632.8799999312 4226547.470002102, 1908636.679999931 4226543.890002101, 1908638.499999931 4226541.690002103, 1908639.5799999312 4226540.120002104, 1908640.8899999312 4226537.280002103, 1908642.449999931 4226534.090002103, 1908644.5899999312 4226530.260002103, 1908646.769999931 4226526.530002103, 1908648.5499999311 4226524.100002103, 1908650.7899999311 4226520.680002102, 1908651.999999931 4226518.620002104, 1908653.989999931 4226514.420002102, 1908656.1299999312 4226509.5300021, 1908659.0999999312 4226502.930002103, 1908660.7899999311 4226498.660002103, 1908661.929999931 4226493.530002103, 1908662.959999931 4226488.750002102, 1908663.949999931 4226484.830002103, 1908665.0799999312 4226481.360002104, 1908666.7999999311 4226477.410002103, 1908667.269999931 4226476.480002103, 1908670.1399999312 4226470.830002103, 1908674.1699999308 4226462.810002105, 1908676.5899999312 4226456.830002103, 1908679.979999931 4226450.210002104, 1908683.3599999312 4226443.750002102, 1908686.009999931 4226438.630002103, 1908689.5599999311 4226432.400002101, 1908693.959999931 4226424.6000021035, 1908699.8999999312 4226414.410002102, 1908701.999999931 4226411.550002102, 1908706.049999931 4226406.040002103, 1908711.939999931 4226398.410002104, 1908717.0599999311 4226391.730002103, 1908722.079999931 4226385.240002104, 1908725.1399999312 4226380.500002104, 1908728.239999931 4226372.570002103, 1908730.759999931 4226365.530002104, 1908734.5099999309 4226355.920002105, 1908737.439999931 4226348.220002104, 1908741.3099999311 4226338.680002102, 1908744.839999931 4226330.2200021045, 1908744.4499999308 4226330.060002104, 1908744.8199999311 4226327.620002103, 1908746.939999931 4226313.580002103, 1908749.119999931 4226300.260002105, 1908751.029999931 4226291.4400021015, 1908753.239999931 4226280.690002103, 1908755.6599999312 4226266.960002103, 1908757.329999931 4226254.620002104, 1908758.669999931 4226245.270002104, 1908759.189999931 4226236.770002103, 1908759.609999931 4226230.010002105, 1908760.729999931 4226214.810002103, 1908762.079999931 4226196.790002104, 1908763.099999931 4226181.150002104, 1908768.9699999308 4226166.980002104, 1908774.889999931 4226152.340002105, 1908782.1199999312 4226134.850002104, 1908786.999999931 4226123.590002104, 1908791.2999999311 4226110.9300021045, 1908791.7299999308 4226109.080002105, 1908792.4999999308 4226100.550002105, 1908793.1899999308 4226093.060002104, 1908793.1599999312 4226086.140002104, 1908789.919999931 4226071.320002104, 1908787.7399999308 4226059.890002104, 1908785.6299999312 4226049.550002103, 1908783.9599999308 4226041.880002104, 1908782.8499999312 4226035.820002104, 1908782.679999931 4226033.120002102, 1908783.189999931 4226030.440002104, 1908783.949999931 4226028.950002105, 1908785.2099999308 4226027.350002104, 1908786.3899999312 4226026.270002103, 1908793.579999931 4226022.040002104, 1908798.049999931 4226021.580002104, 1908800.189999931 4226021.870002104, 1908804.4999999308 4226022.070002104, 1908808.0199999309 4226022.720002104, 1908811.119999931 4226023.6000021035, 1908814.769999931 4226025.050002103, 1908827.169999931 4226038.1800021045, 1908830.839999931 4226038.790002105, 1908832.4299999308 4226038.230002105, 1908835.7299999308 4226035.210002104, 1908840.3699999312 4226029.550002103, 1908846.2599999309 4226020.600002104, 1908850.609999931 4226012.6400021035, 1908855.089999931 4226004.560002105, 1908862.419999931 4225991.660002104, 1908871.9499999308 4225976.710002104, 1908889.2099999308 4225952.320002106, 1908912.559999931 4225920.070002105, 1908920.9899999308 4225910.940002106, 1908923.2299999308 4225907.580002105, 1908924.5299999309 4225902.090002103, 1908890.9599999308 4225879.030002106, 1908941.829999931 4225755.740002104, 1908974.4999999308 4225728.990002104, 1908978.559999931 4225725.680002105, 1908987.1799999308 4225725.630002106, 1909074.7399999308 4225725.330002104, 1909113.149999931 4225732.8400021065, 1909153.579999931 4225740.880002105, 1909167.649999931 4225765.230002105, 1909172.2699999309 4225773.220002105, 1909188.129999931 4225748.920002104, 1909199.289999931 4225731.830002104, 1909201.0599999307 4225729.660002106, 1909222.559999931 4225703.510002105, 1909256.9999999306 4225661.650002106, 1909281.649999931 4225586.270002108, 1909305.379999931 4225598.200002107, 1909314.649999931 4225602.860002106, 1909316.1699999308 4225591.420002107, 1909341.9199999308 4225599.590002105, 1909349.9299999308 4225602.130002105, 1909354.2099999308 4225589.460002106, 1909356.2799999309 4225582.250002106, 1909359.0799999307 4225579.860002104, 1909362.289999931 4225578.050002105, 1909364.5133707284 4225576.853802612, 1909365.3323999308 4225574.510802104, 1909367.425399931 4225565.303602103, 1909373.1293729963 4225536.206825489, 1909381.4645742571 4225500.069485288, 1909390.817895263 4225468.270510348, 1909393.6422332209 4225461.543384822, 1909394.1373231276 4225460.364159106, 1909390.24 4225459.44, 1909346.96 4225447.33, 1909309.88 4225436.96, 1909306.68 4225436.06, 1909303.4499999308 4225452.030002106, 1909295.8699999307 4225449.880002106, 1909293.8699999307 4225427.070002107, 1909291.6099999307 4225401.3000021055, 1909296.859999931 4225392.6000021035, 1909327.6699999308 4225401.260002105, 1909357.5699999307 4225409.660002105, 1909360.0199999306 4225410.340002107, 1909360.8099999307 4225408.360002104, 1909363.0099999306 4225402.830002107, 1909368.589999931 4225388.930002105, 1909371.2799999306 4225389.980002106, 1909396.9699999306 4225349.690002107, 1909398.6296334479 4225348.111450294, 1909398.0731052416 4225346.876359054, 1909397.9012186695 4225346.4475713065, 1909395.6689517985 4225341.76765569, 1909389.2202897372 4225332.144641314, 1909387.494381805 4225329.176613042, 1909388.9797437273 4225328.584378707, 1909388.033960888 4225306.063345689, 1909387.3083309087 4225305.167740701, 1909375.2816055163 4225303.41629175, 1909356.4452419502 4225300.651656047, 1909344.5363536985 4225297.091858199, 1909331.2153403338 4225291.477155254, 1909306.5136183864 4225290.584135825, 1909291.6665270748 4225288.196064651, 1909281.3917801112 4225289.337713816, 1909152.689974186 4225326.661246896, 1909087.3363958339 4225345.875423402, 1909030.801535842 4225363.036414495, 1909028.910945486 4225361.677120742, 1908985.2510402529 4225324.855886176, 1908954.434612214 4225330.072259422, 1908926.3397346034 4225331.920417508, 1908887.024641259 4225330.149582557, 1908866.9088569079 4225330.930767966, 1908852.8467408903 4225340.910991902, 1908842.2189420864 4225350.304476684, 1908830.5863067852 4225378.455561111, 1908791.5765789475 4225397.869873482, 1908769.5759940022 4225409.015725262, 1908750.348532131 4225420.601381724, 1908669.176106063 4225427.042285637, 1908558.40246544 4225434.838233653, 1908474.754198814 4225440.878070682, 1908440.426750993 4225443.377534048, 1908396.060194763 4225446.6465200735, 1908260.1510627766 4225456.731673108, 1908257.46 4225476.45, 1908257.57 4225503.45, 1908245.05 4225536.73, 1908241.37 4225547.93, 1908240.47 4225567.69, 1908232.32 4225568.57, 1908232.52 4225587.26, 1908221.88 4225616.99, 1908203.33 4225625.62, 1908222.33 4225688.74, 1908196.05 4225682.91, 1908161.36 4225671.99, 1908111.76 4225644.34, 1908076.29 4225624.85, 1908056.66 4225614.07, 1908048.53 4225608, 1908037.95 4225598.12, 1908020.54 4225580.44, 1908019.79 4225583.88, 1908009.23 4225562.43, 1908001.21 4225543.01, 1907995.75 4225526.15, 1907994.05 4225517.76, 1907996.78 4225518.67, 1907985.24 4225500.26, 1907976.72 4225489.35, 1907970.84 4225480.88, 1907968.09 4225476.01, 1907963.63 4225464.74, 1907962.9 4225462.88, 1907956.82 4225447.8, 1907952.83 4225437.12, 1907948.22 4225425.04, 1907947.18 4225425.32, 1907943.01 4225425.79, 1907910.47 4225394.34, 1907877.67 4225363.28, 1907874.22 4225360.3, 1907861.41 4225348.72, 1907844.14 4225339.59, 1907825.99 4225318.76, 1907801.75 4225301.24, 1907776.56 4225283.34, 1907752.52 4225266.51, 1907735.22 4225247.85, 1907709.48 4225220.76, 1907700.02 4225211.47, 1907692.64 4225205.69, 1907679.05 4225196.49, 1907663.66 4225186.32, 1907638.55 4225169.23, 1907627.84 4225162.49, 1907598.2 4225152.25, 1907569.8 4225155.7, 1907531.47 4225146.13, 1907487.5 4225127.26, 1907452.9 4225106.28, 1907438.17 4225097.1, 1907390.86 4225056.11, 1907359.56 4225033.37, 1907306.93 4225036.32, 1907273.65 4225015.37, 1907256.09 4224994.44, 1907237.6 4224979.41, 1907223.71 4224970.53, 1907201.61 4224983.59, 1907154.11 4225039.7, 1907094.94 4225109.81, 1907091.11 4225114.14, 1907071.55 4225138.18, 1907067.2 4225154.2, 1907064.66 4225157.69, 1906991.61 4225255.15, 1906947.53 4225314.32, 1906911.09 4225352.31, 1906831.66 4225434.84, 1906829.36 4225436.95, 1906821.3787657847 4225445.334260115, 1906817.28 4225449.64, 1906816.09 4225451.36, 1906803.09 4225457.72, 1906794.7393387163 4225453.9098458, 1906765.13 4225440.4, 1906744.6 4225436.61, 1906736.07 4225435.19, 1906731.86 4225433.53, 1906714.41 4225422.37, 1906700.25 4225412.51, 1906684.13 4225400.74, 1906673.43 4225394.88, 1906660.32 4225387.46, 1906647.93 4225380.27, 1906640.93 4225376.21, 1906635.38 4225370.94, 1906632.05 4225367.4, 1906624.97 4225346.29, 1906619.72 4225331.06, 1906613.98 4225313.72, 1906611.3 4225306.7, 1906608.43 4225299.83, 1906592.36 4225314.06, 1906585.24 4225320.84, 1906568.86 4225332.08, 1906559.07 4225338.46, 1906552.35 4225340.91, 1906542.93 4225342.21, 1906529.14 4225342.76, 1906518.91 4225343.21, 1906513.07 4225344.08, 1906532.56 4225371.41, 1906539.14 4225379.98, 1906542.9 4225387.62, 1906549.18 4225401.08, 1906555.87 4225416.1, 1906559.92 4225423.6, 1906567.31 4225435.07, 1906572.23 4225443.21, 1906573.1 4225445.08, 1906571.95 4225460.97, 1906570.93 4225470.61, 1906571.05 4225477.8, 1906573.65 4225486.71, 1906578.61 4225497.02, 1906586.96 4225504.48, 1906596.14 4225512.25, 1906607.4 4225519.82, 1906619.97 4225525.06, 1906633.95 4225529.4, 1906641.24 4225531.61, 1906652.32 4225539.65, 1906668.19 4225552.62, 1906685.14 4225566.12, 1906691.54 4225572.14, 1906696.28 4225577.45, 1906704.34 4225587.59, 1906711.13 4225600.56, 1906717.11 4225613.08, 1906723.34 4225628.42, 1906729.84 4225643.51, 1906732.85 4225650.29, 1906736.59 4225657.43, 1906743.48 4225668.35, 1906748.71 4225675.12, 1906753.77 4225681.27, 1906761.32 4225690.58, 1906764.97 4225693.86, 1906768.62 4225694.43, 1906772.61 4225693.73, 1906767.81 4225666.89, 1906766.39 4225649.78, 1906765.7 4225637.69, 1906765.09 4225626.1, 1906760.51 4225593.57, 1906769.93 4225608.66, 1906775.73 4225625.4, 1906779.46 4225638.25, 1906781.87 4225644.69, 1906783.96 4225662.75, 1906786.1 4225678.74, 1906787.6 4225686.4, 1906792.84 4225701.05, 1906798.99 4225716.75, 1906806.54 4225736.59, 1906809.97 4225746.84, 1906813.76 4225760.98, 1906816.79 4225769.54, 1906821.89 4225776.97, 1906828.26 4225784.04, 1906838.63 4225794.58, 1906845.23 4225803.07, 1906851.74 4225814.52, 1906856.62 4225841.46, 1906859.11 4225853.25, 1906861.34 4225855.84, 1906867.13 4225860.03, 1906872.6 4225862.17, 1906877.91 4225864.34, 1906884.44 4225867.01, 1906900.38 4225870.71, 1906908.94 4225872.17, 1906918.82 4225874.02, 1906930.26 4225877.07, 1906944.76 4225884.06, 1906957.85 4225889.98, 1906977.43 4225899.95, 1907003.32 4225911.65, 1907012.31 4225915.9, 1907030.97 4225929.06, 1907036.27 4225933.48, 1907042.71 4225939.2, 1907052.32 4225951.13, 1907056.54 4225956.91, 1907060.95 4225961.9, 1907064.52 4225964.79, 1907062.25 4225967.9, 1907046.26 4225974.58, 1907023.18 4225983.27, 1907016.15 4225984.88, 1907011.5 4225985.31, 1907001.86 4225984.51, 1906996.1 4225983.88, 1906988.46 4225988.01, 1906990.28 4225990.75, 1906929.91 4225999.9, 1906927.21 4225998.97, 1906914.54 4226003.06, 1906894.3 4226010.73, 1906889.58 4226012.59, 1906883.09 4226016.83, 1906876.17 4226021.9, 1906870.73 4226026.19, 1906865.05 4226030.46, 1906858.5 4226037.54, 1906847.02 4226048.77, 1906843.27 4226052.53, 1906838.57 4226056.04, 1906833.35 4226057.75, 1906825.76 4226059.58, 1906820.74 4226061.9, 1906816.21 4226066.02, 1906806.34 4226075.37, 1906798.96 4226083.05, 1906794.63 4226086.99, 1906785.26 4226093.89, 1906776.64 4226098.96, 1906769.64 4226101.93, 1906763.18 4226104.42, 1906756.77 4226112.96, 1906750.56 4226120.03, 1906742.22 4226125.72, 1906737.68 4226127.95, 1906726.11 4226131.2, 1906716.89 4226132.98, 1906698.96 4226135.23, 1906689.81 4226136.37, 1906681.69 4226137.49, 1906667.03 4226140.5, 1906659.93 4226142.46, 1906654.88 4226143.87, 1906651.99 4226145.8, 1906649.96 4226150.05, 1906643.83 4226169.75, 1906637.1 4226190.44, 1906632.89 4226204.61, 1906628.04 4226222.29, 1906625.69 4226231.81, 1906624.65 4226241.35, 1906622.76 4226256.45, 1906621.77 4226262.12, 1906618.27 4226269.91, 1906617.35 4226278.16, 1906614.74 4226289.7, 1906613.03 4226296.38, 1906608.98 4226308.55, 1906608.88 4226318.66, 1906608.31 4226326.94, 1906603.56 4226337.01, 1906601.05 4226342.3, 1906598.7 4226354.18, 1906594.72 4226368.9, 1906592.28 4226379.8, 1906589.92 4226391.93, 1906587.36 4226403.04, 1906582.99 4226414.34, 1906576.69 4226428.95, 1906573.14 4226437.12, 1906568.87 4226445.7, 1906564.74 4226455.15, 1906560.08 4226463.55, 1906555.67 4226471.33), (1907942.469998586 4227620.270000651, 1907942.47 4227620.27, 1907942.3849098277 4227607.295590279, 1907942.3347153729 4227589.860165723, 1907943.8513114685 4227579.868473798, 1907946.3492344492 4227570.055204946, 1907948.4903112901 4227566.754378149, 1907951.6127150161 4227564.880935914, 1907958.2143686085 4227566.843589685, 1908038.7 4227647.14, 1908073.4175041688 4227673.809732905, 1908089.025144249 4227689.530002099, 1908123.6839440586 4227702.361509618, 1908146.0416860494 4227733.196570061, 1908141.5008476912 4227769.125775909, 1908137.8514727622 4227775.502274809, 1908131.1063235004 4227779.34546613, 1908119.5088239464 4227780.416004551, 1908107.7329013222 4227779.34546613, 1908098.811747819 4227771.851697187, 1908076.999290536 4227750.54200291, 1908072.6700312893 4227734.176624035, 1908050.75 4227742.87, 1908041.63 4227748.53, 1908037 4227754.55, 1908017.2306855912 4227764.984123535, 1908001.3399999314 4227758.450002098, 1907998.2799999313 4227755.0700021, 1907993.8099999314 4227752.100002099, 1907983.8399999314 4227746.190002101, 1907972.3099999314 4227738.570002099, 1907965.1399999314 4227734.2400020985, 1907958.4399999315 4227730.610002099, 1907954.94 4227720.56, 1907956.89 4227719.84, 1907958.53 4227718.61, 1907959.63 4227716.11, 1907959.8 4227710.56, 1907960.1 4227703.3, 1907960.85 4227690.94, 1907960.73 4227681.59, 1907959.54 4227675.94, 1907956.07 4227667.64, 1907951.39 4227659.06, 1907944.59 4227649.37, 1907930.1199999314 4227632.680002102, 1907936.2399999313 4227628.3300021, 1907940.1399999314 4227624.920002101, 1907941.8699999314 4227622.190002101, 1907942.4699999313 4227620.2700021, 1907942.469998586 4227620.270000651), (1907988.5199999313 4227523.930002099, 1907983.8399999314 4227517.5400021, 1907981.4099999315 4227514.090002101, 1907979.7799999313 4227511.7700021, 1907975.7099999313 4227506.3300021, 1907973.2199999313 4227502.250002098, 1907972.1199999314 4227499.410002098, 1907969.4799999313 4227491.8000021, 1907964.8799999314 4227478.8900021, 1907959.6899999313 4227463.5900021, 1907957.1899999313 4227453.650002101, 1907955.5799999314 4227445.810002102, 1907953.6299999314 4227435.960002101, 1907951.9599999313 4227426.3500021, 1907950.4299999312 4227416.000002099, 1907949.5499999314 4227408.0200021, 1907948.9599999313 4227400.7900021, 1907948.5299999316 4227392.7400021, 1907948.7499999313 4227385.490002101, 1907949.0699999314 4227379.9500021, 1907949.9699999313 4227374.090002101, 1907953.6099999314 4227362.480002101, 1907954.4599999313 4227346.1000021, 1907955.7999999314 4227334.420002099, 1907956.7299999313 4227326.750002101, 1907958.1899999313 4227307.7400021, 1907959.3999999315 4227288.270002102, 1907961.1599999315 4227269.2200021, 1907961.9499999313 4227259.800002099, 1907962.1199999314 4227251.9500021, 1907961.5999999314 4227243.520002101, 1907976.2099999313 4227237.9700021, 1907980.9199999312 4227236.1800021, 1908003.5799999314 4227227.6300021, 1908010.1199999314 4227223.160002101, 1908019.7399999313 4227219.310002102, 1908024.4899999313 4227218.2500021, 1908036.6799999312 4227223.0100021, 1908042.2399999313 4227224.710002101, 1908040.2499999313 4227207.070002102, 1908072.6799999312 4227207.890002101, 1908075.2999999314 4227157.420002101, 1908080.4599999313 4227159.060002101, 1908086.0999999314 4227160.660002103, 1908091.4199999312 4227161.540002099, 1908097.2499999313 4227161.580002099, 1908101.2399999313 4227161.1300021, 1908107.6599999315 4227159.590002101, 1908108.1399999314 4227156.700002102, 1908110.0299999313 4227149.470002102, 1908111.8499999314 4227144.660002102, 1908113.4199999312 4227140.5300021, 1908115.9099999312 4227134.490002102, 1908120.0999999312 4227127.980002102, 1908126.0599999314 4227119.830002101, 1908131.2399999313 4227114.300002102, 1908134.2999999314 4227111.200002101, 1908136.5199999313 4227108.0600021025, 1908141.8099999314 4227098.8700021, 1908147.9699999313 4227087.890002103, 1908155.6099999314 4227074.6200021, 1908162.9599999313 4227061.600002101, 1908170.1199999312 4227049.400002102, 1908173.9699999313 4227042.720002101, 1908175.429999931 4227039.940002102, 1908176.8499999314 4227034.880002101, 1908179.1699999312 4227026.870002102, 1908179.439999931 4227025.900002103, 1908208.6899999313 4227032.950002101, 1908210.9599999313 4227033.490002101, 1908213.429999931 4227020.710002102, 1908219.0399999314 4226991.7000021, 1908231.3599999314 4226994.770002102, 1908234.4299999312 4226980.770002101, 1908240.7899999314 4226982.110002101, 1908245.519999931 4226983.280002102, 1908253.3899999314 4226985.800002101, 1908259.0199999313 4226987.630002101, 1908263.6299999312 4226988.990002102, 1908270.0399999311 4226991.540002101, 1908283.929999931 4226985.070002103, 1908294.8899999312 4226981.390002102, 1908302.2399999313 4226979.280002101, 1908309.6999999313 4226977.0800021, 1908310.429999931 4226969.1000021035, 1908332.3399999312 4226942.4400021015, 1908337.4299999312 4226936.240002101, 1908364.939999931 4226932.300002101, 1908371.3699999312 4226933.580002102, 1908383.749999931 4226946.510002102, 1908380.009999931 4226947.850002102, 1908380.939999931 4226951.950002103, 1908387.939999931 4226971.400002101, 1908393.5599999311 4226985.180002101, 1908396.709999931 4226992.350002102, 1908400.199999931 4226998.520002102, 1908404.9599999313 4227009.9600021, 1908413.3499999312 4227030.1600021, 1908417.0599999311 4227039.0100021, 1908413.459999931 4227045.500002101, 1908407.5499999311 4227055.380002101, 1908402.3199999311 4227065.080002102, 1908397.499999931 4227073.800002102, 1908401.0599999311 4227077.740002101, 1908406.8299999314 4227078.060002101, 1908412.0399999314 4227078.360002102, 1908420.1299999312 4227137.0300021, 1908425.8499999312 4227178.080002101, 1908428.5799999314 4227197.630002099, 1908422.5099999313 4227196.770002101, 1908417.7999999311 4227195.840002101, 1908414.679999931 4227195.1200021, 1908402.8399999312 4227191.4300021, 1908378.489999931 4227182.590002102, 1908365.189999931 4227177.8400021, 1908359.5899999314 4227175.3900021, 1908359.4899999313 4227184.070002101, 1908358.7499999313 4227189.700002101, 1908361.5299999313 4227192.7100021, 1908366.4999999313 4227198.7700021025, 1908370.6099999312 4227203.6800021, 1908371.6799999312 4227204.9600021, 1908374.7399999313 4227209.100002099, 1908377.7899999314 4227213.8900021, 1908387.3899999312 4227228.260002101, 1908392.5799999314 4227236.0700021, 1908397.4099999312 4227244.140002102, 1908402.5599999311 4227251.680002101, 1908406.8899999312 4227258.270002102, 1908410.1999999313 4227263.6700021, 1908412.1199999312 4227266.990002101, 1908414.479999931 4227272.450002099, 1908416.2199999313 4227277.6300021, 1908417.4099999312 4227283.260002102, 1908418.729999931 4227290.390002102, 1908419.3399999314 4227295.2600021, 1908420.2399999313 4227304.1300021, 1908422.479999931 4227315.160002101, 1908420.1499999315 4227316.410002101, 1908420.5899999312 4227318.350002101, 1908422.8899999312 4227329.800002099, 1908424.769999931 4227340.900002102, 1908426.7299999313 4227351.140002099, 1908428.919999931 4227362.990002102, 1908430.199999931 4227369.630002102, 1908432.439999931 4227377.550002101, 1908433.509999931 4227383.100002101, 1908434.1199999312 4227388.380002101, 1908434.3199999311 4227393.9700021, 1908434.449999931 4227398.640002101, 1908435.9999999313 4227402.0700021, 1908438.7599999313 4227405.7200021, 1908441.5499999311 4227408.580002099, 1908443.6999999313 4227410.5200021, 1908444.939999931 4227413.7300021, 1908445.9099999312 4227416.580002101, 1908446.3299999314 4227418.530002099, 1908446.219999931 4227421.520002101, 1908444.6299999314 4227432.850002098, 1908442.6499999315 4227432.090002099, 1908442.3499999312 4227433.0700020995, 1908441.4499999313 4227434.670002101, 1908438.0499999314 4227450.660002101, 1908436.5499999311 4227455.650002101, 1908433.7199999313 4227465.4700021, 1908430.3599999312 4227477.490002103, 1908428.189999931 4227485.210002099, 1908425.219999931 4227495.260002101, 1908422.0799999312 4227506.620002099, 1908419.8199999314 4227514.250002097, 1908417.3799999314 4227522.040002099, 1908415.1899999313 4227527.550002102, 1908411.3399999314 4227535.690002101, 1908407.0999999312 4227544.3000021, 1908403.419999931 4227551.4200021, 1908399.9399999313 4227558.9100021, 1908398.0699999314 4227564.690002101, 1908397.1599999315 4227568.7100021, 1908396.7199999313 4227572.4800021, 1908396.6699999312 4227574.5300021, 1908396.8199999314 4227577.780002101, 1908399.229999931 4227594.250002101, 1908394.8199999311 4227602.6900021015, 1908393.8099999311 4227606.940002101, 1908392.3599999314 4227611.140002099, 1908390.3799999314 4227614.6600021, 1908387.5399999314 4227619.1500021, 1908384.4699999313 4227622.960002099, 1908380.2499999313 4227627.2300021, 1908373.499999931 4227633.1800021, 1908367.249999931 4227638.040002098, 1908358.439999931 4227644.2400021, 1908350.259999931 4227650.510002101, 1908345.9699999313 4227654.450002099, 1908340.9399999313 4227659.2400021, 1908330.2999999314 4227670.5000021, 1908328.5899999314 4227674.050002099, 1908326.2999999314 4227677.7100021, 1908322.489999931 4227683.9300021, 1908319.999999931 4227688.500002102, 1908318.5899999314 4227692.050002098, 1908318.1099999314 4227693.250002098, 1908306.2199999313 4227714.8900021, 1908283.3499999312 4227704.8600021005, 1908216.6999999313 4227687.410002099, 1908157.729999931 4227671.970002101, 1908146.4899999313 4227648.5500021, 1908142.8299999314 4227649.6500021, 1908113.0199999313 4227601.220002101, 1908072.2899999314 4227534.7400021, 1908068.4399999313 4227528.6300021, 1908067.3699999314 4227526.830002099, 1908043.3099999314 4227536.4000021, 1908039.4199999312 4227537.720002101, 1908026.2699999313 4227543.030002101, 1908025.5499999314 4227543.3200020995, 1908022.5499999314 4227543.810002101, 1908020.4499999313 4227543.830002098, 1908017.0199999313 4227543.7000021, 1908016.7899999314 4227548.820002099, 1908012.0699999314 4227556.940002101, 1908008.7299999313 4227551.2200021, 1908003.8999999315 4227543.9400021, 1907999.1799999312 4227537.510002101, 1907993.6599999315 4227530.5900021, 1907988.5199999313 4227523.930002099), (1907353.22 4228799.55, 1907339.51 4228787.8, 1907357.37 4228764.89, 1907363.31 4228748.15, 1907359.3 4228734, 1907355.43 4228723.1, 1907332.54 4228736.96, 1907328.29 4228736.38, 1907322.16 4228735.55, 1907310.95 4228733.39, 1907284.12 4228728.24, 1907277.25 4228726.45, 1907261.35 4228719.61, 1907264.22 4228712.85, 1907269.22 4228695.6, 1907274.21 4228668.93, 1907294.71 4228628.02, 1907295.55 4228628.43, 1907296.9 4228626.82, 1907302.94 4228622.43, 1907342.29 4228601.24, 1907342.34 4228601.19, 1907353.91 4228590.52, 1907370.23 4228575.32, 1907380.31 4228565.89, 1907388.08 4228559.21, 1907393.69 4228554.79, 1907408.38 4228542.82, 1907420.85 4228531.47, 1907431.82 4228522.9, 1907433.82 4228520.4, 1907436.08 4228518.06, 1907437.43 4228517.12, 1907443.07 4228515.77, 1907455.14 4228514.3, 1907460.48 4228509.79, 1907465.57 4228505.48, 1907468.67 4228502.31, 1907470.73 4228499.85, 1907473.9399999315 4228499.7000020975, 1907520.67 4228513.51, 1907526.4599999315 4228538.980002097, 1907567.0799999316 4228540.390002097, 1907572.8199999316 4228542.410002098, 1907576.5999999316 4228539.1600020975, 1907594.0999999316 4228524.840002096, 1907601.2499999315 4228523.2400020985, 1907606.2499999315 4228513.930002098, 1907610.1499999317 4228508.550002096, 1907614.9399999315 4228504.7800020985, 1907619.9599999315 4228502.160002098, 1907625.9999999315 4228499.760002096, 1907632.1299999317 4228498.730002098, 1907637.2299999315 4228499.150002097, 1907649.6699999315 4228504.700002097, 1907664.0199999316 4228511.470002094, 1907673.61 4228515.59, 1907685.89 4228521.27, 1907700.69 4228527.74, 1907708.36 4228530.98, 1907712.13 4228531.91, 1907716.66 4228532.17, 1907720.59 4228531.78, 1907725.68 4228530.59, 1907730.46 4228528.68, 1907736.31 4228523.75, 1907744.75 4228516.44, 1907752.63 4228510.15, 1907758.54 4228506.68, 1907766.99 4228503.95, 1907776.42 4228501.26, 1907791.04 4228497.2, 1907799.82 4228494.63, 1907801.73 4228494.15, 1907805.46 4228492.75, 1907810.92 4228490.2, 1907817.99 4228485.85, 1907825.06 4228481.45, 1907831.54 4228476.48, 1907834.93 4228473, 1907842.83 4228464.3, 1907852.68 4228453.61, 1907859.84 4228448.28, 1907862.82 4228446.79, 1907870.34 4228444.43, 1907879.06 4228441.43, 1907884.04 4228438.79, 1907884.9706573098 4228437.902114593, 1907890.1299999317 4228442.390002098, 1907914.76 4228470.26, 1907868.1 4228541.35, 1907861.32 4228551.69, 1907852.31 4228557.1, 1907844.05 4228570.05, 1907872.56 4228581.8, 1907868.89 4228589, 1907858.52 4228609.29, 1907852.79 4228638.52, 1907828.82 4228648.05, 1907796.83 4228660.25, 1907771.76 4228669.45, 1907749.4 4228673.3, 1907735.56 4228675.57, 1907723.8 4228677.47, 1907705.94 4228680.37, 1907690.43 4228682.82, 1907670.41 4228686.04, 1907652.3 4228688.87, 1907652.41 4228690.03, 1907638.8 4228704.98, 1907642.11 4228730.21, 1907620.38 4228738.24, 1907587.7 4228752.04, 1907559.4 4228764.43, 1907556.21 4228765.77, 1907541.88 4228783.43, 1907539.17 4228785.02, 1907520.03 4228781.06, 1907517.32 4228794.63, 1907512.54 4228788.71, 1907490.1599999317 4228785.440002097, 1907484.9699999315 4228784.730002098, 1907474.5999999316 4228782.730002097, 1907467.7599999316 4228777.940002098, 1907448.8899999317 4228756.190002095, 1907447.5499999316 4228754.6200020965, 1907439.7899999316 4228755.640002098, 1907430.8399999316 4228757.570002098, 1907417.5999999316 4228763.830002097, 1907402.0699999318 4228767.6200020965, 1907390.7599999318 4228770.050002097, 1907374.1499999317 4228782.900002097, 1907355.5699999316 4228797.510002097, 1907353.22 4228799.55), (1907407.4399999315 4227577.670002101, 1907405.63 4227584.86, 1907402.57 4227603.29, 1907399.08 4227625.82, 1907394.79 4227630.36, 1907390.76 4227635.38, 1907384.46 4227651.76, 1907378.24 4227668.17, 1907376.4 4227670.24, 1907373.38 4227669.82, 1907370.02 4227668.65, 1907367.85 4227665.92, 1907368.64 4227661.98, 1907371.28 4227651.2, 1907372.71 4227642.87, 1907373.95 4227633.1, 1907370.17 4227632.47, 1907362.41 4227631.37, 1907353.33 4227630.58, 1907345.38 4227630.57, 1907335.14 4227629.96, 1907321.52 4227629.21, 1907281.44 4227622.79, 1907257.79 4227612.1, 1907253.75 4227612.23, 1907232.6 4227609.22, 1907220.18 4227607.83, 1907212.27 4227608.13, 1907202.24 4227609.51, 1907200.37 4227583.72, 1907202.04 4227570.17, 1907207.45 4227522.61, 1907208.21 4227502.29, 1907219.81 4227459.37, 1907222.59 4227449.06, 1907225.74 4227447.36, 1907226.52 4227432.16, 1907224.16 4227426.47, 1907222.37 4227417.21, 1907236.77 4227366.79, 1907241.55 4227364.82, 1907247.05 4227362.84, 1907251.53 4227361.64, 1907256.9699999315 4227358.0200021, 1907253.11 4227357.35, 1907249.46 4227357.15, 1907244.44 4227358.04, 1907239.28 4227359.26, 1907232.51 4227361.6, 1907223.34 4227367.07, 1907215.85 4227372, 1907204.51 4227379.79, 1907194.86 4227385.63, 1907186.78 4227390.39, 1907180.04 4227394.89, 1907173.83 4227397.15, 1907168.66 4227397.88, 1907163.64 4227397.72, 1907159.95 4227396.29, 1907159.31 4227392.47, 1907161.73 4227378.54, 1907167.04 4227363.83, 1907166.62 4227361, 1907163.9 4227357.34, 1907159.93 4227354.63, 1907153.38 4227352.77, 1907130.79 4227350.96, 1907118.96 4227346.79, 1907112 4227344.26, 1907109.01 4227338.92, 1907107.04 4227323.18, 1907106.79 4227319.06, 1907114.69 4227313.43, 1907133.9699999315 4227307.3100021025, 1907134.3599999317 4227289.130002103, 1907180.35 4227273.45, 1907206.37 4227264.3, 1907214.03 4227260.12, 1907223.12 4227253.01, 1907244.85 4227236.08, 1907261.8 4227233.19, 1907274.28 4227229.53, 1907273.38 4227222, 1907276.93 4227221.36, 1907265.91 4227220.6, 1907242.85 4227219.54, 1907233.81 4227218.48, 1907223.55 4227216.78, 1907184.54 4227211.12, 1907155.26 4227209.22, 1907137.81 4227208, 1907120.6 4227206.86, 1907115.99 4227205.53, 1907112.65 4227203.72, 1907109.9 4227201.81, 1907108.54 4227195.53, 1907108.85 4227178.55, 1907109.53 4227163.04, 1907111.03 4227150.27, 1907111.98 4227147.55, 1907113.91 4227144.41, 1907115.65 4227142.47, 1907119.3 4227140.39, 1907140.67 4227137.99, 1907144.9099999317 4227133.370002102, 1907145.8899999317 4227100.310002101, 1907147.2099999315 4227096.420002102, 1907165.26 4227094.22, 1907185.17 4227092.48, 1907187.35 4227090.48, 1907188.35 4227086.96, 1907187.4 4227076.59, 1907186.6 4227062.25, 1907186.86 4227058.16, 1907188.28 4227053.55, 1907191.05 4227050.46, 1907194.86 4227048.17, 1907198.82 4227046.99, 1907209.31 4227044.68, 1907213.21 4227044.03, 1907228.93 4227042.66, 1907248.27 4227042.66, 1907249.38 4227042.66, 1907249.32 4227040.42, 1907249.24 4227037.66, 1907249.13 4227033.9, 1907247.77 4227033.94, 1907243.33 4227034.06, 1907238.68 4227033.77, 1907234.46 4227033.19, 1907228.13 4227031.88, 1907222.62 4227030.02, 1907216.42 4227027.51, 1907210.91 4227024.37, 1907202.42 4227019.22, 1907183.23 4227008.09, 1907179.61 4227007.45, 1907175 4227006.33, 1907169.4 4227003.84, 1907166.3 4227002.01, 1907161.31 4226997.66, 1907150.1 4226988.07, 1907141.34 4226983.48, 1907128.78 4226978.94, 1907117.41 4226975.11, 1907110.04 4226971.51, 1907109.67 4226967.49, 1907111.4 4226966.63, 1907117.87 4226961.49, 1907121.97 4226956.83, 1907127.24 4226949.57, 1907132.52 4226940.91, 1907136.06 4226933.15, 1907138.85 4226923.41, 1907140.57 4226917.23, 1907142.74 4226912.71, 1907148.44 4226908.4, 1907150 4226907.19, 1907153.71 4226904.3, 1907175.37 4226896.38, 1907194.78 4226889, 1907208.46 4226883.94, 1907218.42 4226880.24, 1907226.04 4226876.19, 1907233.34 4226870.66, 1907239.84 4226864.92, 1907240.03 4226857.27, 1907264.12 4226839.73, 1907285.8299999316 4226837.6500021005, 1907305.2299999315 4226836.230002101, 1907316.3899999317 4226834.780002102, 1907322.0899999316 4226831.630002101, 1907342.6499999317 4226820.570002101, 1907348.1199999317 4226818.870002103, 1907373.4099999317 4226816.580002103, 1907382.0799999314 4226818.1400021035, 1907387.9999999315 4226819.190002102, 1907389.4899999315 4226819.460002101, 1907404.5299999316 4226822.150002103, 1907431.8199999316 4226828.040002102, 1907446.7099999313 4226827.0600021025, 1907462.9999999315 4226824.360002102, 1907463.4599999315 4226819.760002101, 1907463.8999999317 4226796.410002101, 1907465.1399999317 4226792.390002102, 1907467.3799999314 4226776.380002103, 1907448.2599999313 4226769.080002101, 1907447.2899999316 4226766.400002101, 1907451.1599999315 4226760.780002102, 1907454.1399999317 4226756.620002102, 1907457.4099999317 4226750.310002102, 1907461.0499999316 4226741.810002101, 1907463.2099999315 4226737.080002101, 1907465.8799999317 4226732.840002103, 1907468.7599999316 4226728.610002102, 1907473.4199999312 4226723.450002104, 1907478.3899999317 4226718.660002102, 1907489.5499999314 4226709.630002102, 1907503.5399999314 4226698.930002103, 1907514.2699999316 4226691.050002101, 1907516.2399999313 4226706.330002103, 1907530.5099999316 4226698.370002101, 1907533.9899999313 4226696.270002103, 1907541.1399999314 4226690.400002104, 1907545.6999999315 4226686.660002102, 1907549.1799999312 4226686.360002102, 1907550.3199999316 4226687.220002102, 1907554.8699999314 4226687.990002101, 1907607.8399999314 4226678.900002102, 1907609.8299999316 4226678.920002101, 1907613.3199999314 4226668.080002102, 1907616.1999999315 4226659.190002104, 1907651.0399999314 4226656.600002103, 1907665.5899999314 4226658.890002103, 1907666.22 4226667.95, 1907669.12 4226677.72, 1907670.31 4226681.19, 1907671.99 4226687.11, 1907674.8 4226687.09, 1907674.57 4226686.6, 1907674.89 4226685.63, 1907675.89 4226685.12, 1907675.5799999314 4226684.320002102, 1907679.7099999315 4226682.500002101, 1907682.7099999313 4226682.550002102, 1907691.2999999314 4226682.730002102, 1907692.4999999313 4226683.590002102, 1907692.9899999313 4226683.600002103, 1907693.0999999314 4226690.220002103, 1907693.1299999314 4226692.200002102, 1907711.1999999313 4226699.370002102, 1907719.3999999315 4226700.710002103, 1907737.1499999315 4226703.980002103, 1907737.7499999313 4226716.9800021015, 1907738.2499999313 4226727.860002102, 1907742.4099999315 4226728.390002102, 1907754.0799999316 4226731.060002102, 1907763.6799999312 4226733.440002104, 1907777.9399999313 4226738.910002102, 1907789.5499999314 4226744.580002104, 1907793.1699999312 4226745.750002101, 1907806.6599999315 4226746.7200021, 1907831.4899999313 4226746.910002103, 1907843.0199999313 4226748.630002101, 1907845.3699999314 4226748.900002103, 1907858.2199999313 4226750.070002103, 1907871.2199999313 4226750.200002102, 1907877.2399999313 4226750.820002102, 1907883.4999999313 4226751.220002102, 1907891.6899999313 4226752.980002102, 1907897.1899999313 4226754.930002102, 1907896.1899999313 4226750.780002103, 1907898.0599999314 4226750.360002102, 1907899.1199999314 4226748.290002101, 1907901.4399999313 4226747.380002102, 1907898.7599999313 4226740.370002103, 1907916.3699999314 4226733.180002102, 1907922.9799999313 4226741.940002102, 1907923.2499999313 4226742.950002102, 1907936.9299999312 4226739.080002102, 1907947.7599999313 4226733.410002103, 1907955.9299999312 4226728.790002103, 1907964.4099999315 4226724.420002103, 1907967.7999999314 4226722.930002102, 1907973.7399999313 4226720.900002102, 1907980.9499999313 4226718.950002102, 1907989.9899999313 4226719.5800021, 1907993.4599999313 4226718.7300021015, 1907994.3999999315 4226718.800002102, 1908008.3999999315 4226719.820002102, 1908031.1099999314 4226720.250002101, 1908042.7999999314 4226727.860002101, 1908043.8699999312 4226726.250002103, 1908045.999999931 4226723.030002103, 1908052.5999999312 4226725.410002104, 1908056.4399999313 4226726.820002103, 1908059.6699999312 4226727.590002102, 1908063.8999999312 4226728.080002103, 1908067.5699999311 4226729.290002103, 1908076.7599999313 4226728.540002102, 1908089.3599999312 4226727.560002103, 1908090.1799999312 4226726.160002102, 1908091.4099999312 4226725.020002103, 1908092.7799999313 4226724.020002103, 1908094.5899999312 4226723.440002103, 1908096.9999999313 4226722.970002102, 1908104.8799999314 4226721.770002102, 1908105.9699999313 4226722.190002103, 1908117.3699999312 4226716.530002103, 1908117.8599999314 4226716.570002104, 1908117.2499999313 4226718.280002102, 1908115.3999999315 4226724.080002102, 1908112.3899999314 4226731.200002101, 1908110.1399999314 4226737.280002103, 1908107.7199999313 4226744.370002101, 1908105.0999999314 4226751.970002102, 1908101.9899999313 4226757.120002101, 1908097.7899999314 4226761.820002102, 1908094.5999999314 4226764.650002103, 1908093.7699999313 4226765.3900021, 1908087.1399999314 4226770.580002104, 1908081.2899999314 4226773.350002101, 1908074.6599999315 4226775.780002101, 1908069.6799999312 4226777.530002102, 1908065.1299999314 4226779.220002104, 1908061.6899999313 4226781.430002101, 1908060.2399999313 4226784.250002101, 1908059.9699999313 4226787.540002102, 1908060.2099999313 4226792.330002103, 1908060.6099999314 4226796.650002103, 1908061.6699999312 4226800.4500021, 1908063.729999931 4226803.990002103, 1908066.3999999315 4226808.170002101, 1908068.689999931 4226811.230002103, 1908068.1499999315 4226811.840002101, 1908067.5099999313 4226811.840002101, 1908066.8699999314 4226813.620002101, 1908066.4799999313 4226814.970002102, 1908066.3099999314 4226815.550002102, 1908081.2899999314 4226818.460002101, 1908082.4899999313 4226827.9800021, 1908075.7899999314 4226844.760002101, 1908078.7699999313 4226854.180002102, 1908089.459999931 4226861.070002103, 1908092.4699999313 4226864.220002101, 1908096.3599999314 4226871.840002103, 1908097.419999931 4226875.030002102, 1908098.1199999314 4226884.210002101, 1908098.3999999315 4226887.9800021015, 1908097.4899999313 4226898.000002103, 1908097.1899999313 4226900.060002102, 1908096.6799999312 4226901.580002102, 1908089.7399999313 4226922.4400021015, 1908083.6899999313 4226940.620002102, 1908077.6199999314 4226958.850002102, 1908073.4199999312 4226971.4800021015, 1908071.3499999314 4226977.7700021025, 1908063.8099999314 4227000.740002101, 1908056.9399999313 4227021.660002099, 1908052.2299999313 4227035.990002101, 1908049.1299999314 4227044.6000021, 1908042.3199999314 4227063.600002101, 1908042.1599999312 4227064.030002103, 1908041.759999931 4227065.300002102, 1908037.3299999316 4227079.390002099, 1908034.7399999313 4227087.620002099, 1908017.8199999314 4227089.960002102, 1908016.8999999315 4227090.0900021, 1908014.4799999313 4227090.4000021005, 1907998.7299999313 4227092.430002103, 1907998.5199999313 4227093.920002101, 1907997.189999931 4227103.320002102, 1907979.1299999314 4227123.250002101, 1907969.4499999313 4227140.480002101, 1907964.5699999314 4227145.430002101, 1907962.7099999313 4227147.1500021005, 1907961.4499999313 4227150.430002101, 1907953.3699999314 4227150.980002101, 1907945.6099999314 4227157.240002101, 1907940.4999999313 4227159.300002101, 1907931.3999999315 4227168.6600021, 1907923.3699999314 4227171.180002101, 1907915.3199999314 4227171.5900021, 1907906.5499999314 4227181.3100021, 1907905.7499999313 4227182.2000021, 1907896.3799999314 4227203.500002099, 1907893.0099999313 4227211.360002101, 1907885.5399999314 4227256.060002102, 1907884.5299999313 4227262.060002102, 1907880.2499999313 4227294.390002099, 1907879.6099999314 4227299.170002101, 1907881.7199999313 4227309.090002101, 1907876.2999999314 4227314.550002101, 1907875.3999999315 4227314.920002101, 1907862.7099999313 4227320.0900021, 1907852.6399999314 4227324.210002099, 1907835.2299999313 4227329.8600021, 1907825.3899999314 4227330.750002101, 1907808.4799999313 4227333.930002101, 1907804.6999999313 4227334.640002101, 1907802.4399999313 4227340.8800021, 1907799.2199999313 4227347.0300021, 1907792.5899999314 4227354.9000021005, 1907776.4299999315 4227362.260002099, 1907775.6299999314 4227362.8800021, 1907765.6599999315 4227363.100002101, 1907753.2499999315 4227362.3600021005, 1907748.8299999314 4227369.1600021, 1907738.1799999315 4227381.540002101, 1907719.7299999313 4227385.270002102, 1907719.7899999314 4227374.950002102, 1907718.7499999315 4227371.6300021, 1907721.6099999314 4227370.660002101, 1907718.4699999313 4227361.0900021, 1907731.8099999316 4227357.0200021, 1907760.6399999314 4227337.540002101, 1907758.1999999313 4227334.0500021, 1907719.5399999316 4227306.5900021, 1907715.8999999315 4227304.870002102, 1907709.0199999313 4227306.490002101, 1907691.3999999317 4227310.6700021, 1907684.8299999316 4227299.130002101, 1907659.9899999313 4227304.1200021, 1907649.6999999313 4227306.6200021, 1907639.7499999315 4227300.500002101, 1907622.8499999316 4227300.4300021, 1907615.4399999315 4227304.790002102, 1907616.4299999312 4227312.720002101, 1907614.9699999313 4227316.620002101, 1907611.7799999316 4227321.240002101, 1907605.1699999315 4227320.8900021, 1907601.4999999315 4227314.490002101, 1907599.4099999317 4227312.8200021, 1907596.1199999317 4227312.3200021, 1907589.5499999314 4227312.3400021, 1907585.0199999316 4227313.9500021, 1907581.1399999317 4227318.160002099, 1907580.6399999314 4227318.950002099, 1907578.1799999312 4227322.7700021025, 1907575.7699999316 4227326.5500021, 1907571.5299999316 4227331.530002101, 1907569.1299999314 4227333.520002102, 1907564.0399999316 4227337.140002101, 1907560.1399999317 4227338.9100021, 1907556.5099999313 4227341.6000021, 1907553.8299999316 4227345.330002101, 1907541.9499999315 4227363.5000021, 1907538.8099999316 4227368.760002099, 1907529.6299999314 4227384.1600021, 1907520.9799999315 4227399.300002102, 1907513.0199999316 4227411.7300021, 1907504.0899999316 4227425.7500021, 1907497.7299999315 4227436.6100021, 1907485.1699999315 4227457.0400021, 1907482.5199999316 4227461.570002101, 1907450.7999999316 4227486.170002099, 1907442.1599999317 4227495.7400021, 1907433.2699999316 4227505.2900021, 1907429.6399999317 4227510.490002099, 1907426.4999999315 4227515.680002101, 1907424.6099999317 4227521.780002101, 1907418.3999999317 4227538.130002099, 1907413.8099999314 4227550.400002101, 1907412.1499999317 4227558.290002099, 1907407.4399999315 4227577.670002101), (1908309.3599999314 4226918.010002101, 1908309.709999931 4226912.110002103, 1908309.959999931 4226905.240002101, 1908310.3599999312 4226895.880002103, 1908310.3599999312 4226895.530002103, 1908299.0699999311 4226868.4200021, 1908292.3599999314 4226852.470002101, 1908291.749999931 4226849.910002102, 1908269.679999931 4226805.290002103, 1908267.0399999311 4226801.470002101, 1908261.2899999311 4226806.330002103, 1908255.4299999312 4226811.220002102, 1908249.0699999314 4226815.990002103, 1908246.3299999312 4226818.4000021005, 1908244.0999999314 4226821.090002101, 1908242.6299999312 4226823.060002103, 1908240.7499999313 4226825.650002101, 1908238.6699999312 4226829.140002101, 1908238.3099999314 4226829.860002102, 1908230.9599999313 4226828.350002101, 1908224.4199999312 4226819.680002102, 1908216.5699999314 4226804.910002101, 1908214.0299999313 4226800.010002102, 1908213.8499999312 4226799.670002101, 1908212.5699999314 4226795.520002102, 1908210.5099999313 4226788.720002101, 1908206.3499999312 4226775.090002104, 1908210.3799999314 4226769.930002102, 1908208.8899999312 4226767.580002104, 1908207.1399999312 4226764.700002103, 1908206.0899999314 4226762.370002103, 1908205.0799999314 4226759.990002102, 1908203.5399999311 4226755.030002101, 1908202.7099999313 4226751.900002102, 1908201.029999931 4226745.650002103, 1908199.6399999312 4226740.530002102, 1908198.7199999313 4226737.720002101, 1908198.0799999314 4226736.290002101, 1908196.679999931 4226734.040002102, 1908194.8699999314 4226731.650002101, 1908190.3799999314 4226727.450002103, 1908185.6499999315 4226723.290002102, 1908180.4299999312 4226718.8100021025, 1908172.5299999313 4226712.390002102, 1908172.8499999314 4226712.640002101, 1908182.1999999313 4226695.140002101, 1908196.169999931 4226698.810002105, 1908206.9299999312 4226703.330002102, 1908218.3599999314 4226709.890002102, 1908232.5699999311 4226705.300002105, 1908238.3999999315 4226701.970002102, 1908263.95 4226699.88, 1908263.84 4226691.12, 1908273.25 4226683.74, 1908280.71 4226687.76, 1908285.45 4226690.02, 1908288.25 4226690.9, 1908291.57 4226690.87, 1908293.65 4226690.24, 1908297.89 4226689.31, 1908300.41 4226688.95, 1908302.41 4226689.39, 1908304.94 4226690.62, 1908308.49 4226693.48, 1908310.48 4226694.57, 1908312.04 4226694.78, 1908312.56 4226694.48, 1908311.27 4226689.64, 1908308.91 4226684.14, 1908306.59 4226679.46, 1908321.11 4226683.88, 1908327.73 4226685.89, 1908332.84 4226686.99, 1908338.32 4226687.96, 1908344.97 4226688.08, 1908356.87 4226687.82, 1908364.95 4226686.97, 1908373.59 4226687.51, 1908374.459999931 4226687.270002103, 1908388.1099999312 4226687.170002103, 1908397.269999931 4226686.7900021, 1908402.219999931 4226686.580002102, 1908415.0399999311 4226685.480002103, 1908431.3699999314 4226679.110002101, 1908448.9