
-- remplissage des listes de valeurs

INSERT INTO urba_plui_ecriture.documenturbatype (typedoc,lib_typedoc) VALUES
     ('PLU','Le document d''urbanisme est un plan local d''urbanisme'),
     ('PLUI','Le document d''urbanisme est un plan local d''urbanisme intercommunal'),
     ('POS','Le document d''urbanisme est un plan d''occupation des sols'),
     ('PSMV','Le document est un plan de sauvegarde et de mise en valeur');


INSERT INTO urba_plui_ecriture.etatdocumenttype (etat,lib_etat) VALUES
     ('01','En cours de procédure'),
     ('02','Arrêté'),
     ('03','Opposable'),
     ('04','Annulé'),
     ('05','Remplacé'),
     ('06','Abrogé'),
     ('07','Approuvé'),
     ('08','Partiellement annulé'),
     ('09','Caduc');


INSERT INTO urba_plui_ecriture.procedureurbatype (nomproc,lib_nomproc) VALUES
     ('E','Élaboration'),
     ('R','Révision'),
     ('A','Abrogation'),
     ('MC','Mise en compatibilité'),
     ('MJ','Mise à jour'),
     ('M','Modification de droit commun'),
     ('MS','Modification simplifiée'),
     ('RS','Révision simplifiée (art. L.153-34)'),
     ('RF','Procédure de référence (plugin)');


INSERT INTO urba_plui_ecriture.zoneurbatype (typezone,lib_typezone) VALUES
     ('U','urbaine'),
     ('AUc','à urbaniser'),
     ('AUs','à urbaniser bloquée'),
     ('A','agricole'),
     ('N','naturelle et forestière');

-- formdomitype
INSERT INTO urba_plui_ecriture.formdomitype (id,formdomi,lib_formdomi,definition) VALUES
     (1,'0000','sans objet ou non encore définie dans le règlement',NULL),
     (2,'0100','habitat','Tout type d''habitat'),
     (3,'0101','habitat centre-ville','Petites parcelles étroites – bâti implanté en mitoyen et à l’alignement
Rues sinueuses et non structurées.'),
     (4,'0102','habitat centre-villageois','Tissu compact issu d’une implantation historique - petites parcelles étroites – bâti
implanté en mitoyen et/ou à l’alignement. Rues sinueuses et non structurées. Présence
d’espaces ou équipements publics fédérateurs, nombre de constructions plus important
que les hameaux.'),
     (5,'0103','habitat faubourg','Tissu compact et dense en extension du centre ancien. Petites parcelles étroites et
souvent allongées (autour de 400 m²) en forme parallélogramme – bâti implanté en
mitoyen et/ou à l’alignement.'),
     (6,'0104','habitat hameau','Tissu compact issu d’une implantation historique. Parcelles de taille variable – bâti
globalement implanté au contact de l’espace public. Rues sinueuses et étroites.'),
     (7,'0105','habitat collectif','(R+3 et plus). Bâti discontinu, déconnecté des espaces urbains voisins. Taille des
parcelles variables avec une prédominance de grandes parcelles de plus de 1 000 m² –
voies de desserte larges – bâti en retrait par rapport aux limites parcellaires.'),
     (8,'0106','habitat petits collectifs','(R+2 max)Bâti discontinu, déconnecté des espaces urbains voisinsTaille des parcelles
variables avec une prédominance de grandes parcelles de plus de 1 000 m² – voies de
desserte larges – bâti en retrait par rapport aux limites parcellaires.'),
     (9,'0107','habitat pavillonnaire dense','Tissus résidentiel discontinu, dense, organisé et présentant une certaine homogénéité.
Petites parcelles en forme homogène – bâti implanté en retrait des limites parcellaires.'),
     (10,'0108','habitat pavillonnaire peu dense','Tissus discontinu, non organisé et hétérogène. Bâti implanté de manière aléatoire –
plutôt grandes parcelles - bâti implanté en retrait des limites parcellaires.'),
     (11,'0109','habitat maitrisé','Bâti isolé au milieu d’un espace naturel, agricole ou forestier
Parcelles de forme variable avec prédominance pour les grandes de plus de 1 000 m² -bâti implanté en retrait des limites parcellaires.'),
     (12,'0200','activité','Tout type d’activité'),
     (13,'0201','activité industrielle / logistique /
commerciale','Zone regroupant des entreprises, usines, entrepôts, surfaces commerciales… visibles et
en dehors des zones urbanisées.'),
     (14,'0202','activité commerces','Espace regroupant des commerces de proximité. Parcelles de taille et forme variables.'),
     (15,'0203','activité bureaux','Ensembles d’immeubles de bureaux privatisés abritant des entreprises et activités
tertiaires Parcelles de taille et de formes variables – surface de parkings importante
mais espaces verts présents.'),
     (16,'0300','mixte habitat / activité','Secteur où une mixité fonctionnelle est soit recherchée, soit à encadrer.'),
     (17,'0400','loisirs et tourisme','Tout type de loisir et de tourisme'),
     (18,'0401','loisir parc et jardin','Parcs et jardins en milieu urbain'),
     (19,'0402','loisir parc d''attraction','Parcs d''attraction'),
     (20,'0403','loisir balnéaire et nautique','Plages, port de plaisance'),
     (21,'0404','loisir de montagne','Pistes et domaines orientés vers les loisirs de montagnes (tracés skiables en hiver,
espaces de randonnées, activités sportives …)'),
     (22,'0405','loisir sportif','Ensemble d''équipements sportifs (stades, gymnases, circuit automobile …)'),
     (23,'0406','tourisme hôtelier','Ensembles d''immeubles d''hébergement hôtelier'),
     (24,'0407','tourisme camping','Espaces réservés aux activités de camping'),
     (25,'0500','Équipement public','Tout type d’équipement'),
     (26,'0501','équipement de proximité','Crèches, écoles, collèges, lycées, gendarmerie, commissariat, sécurité incendie'),
     (27,'0502','équipement généraux','Hopitaux, Universités'),
     (28,'0503','équipement de défense nationale','Domaine militaire'),
     (29,'0600','infrastructure de transport','Tout type d’infrastructure de transport'),
     (30,'0601','infrastructure autoroutière','Emprise autoroutière et équipements associés'),
     (31,'0602','infrastructure ferroviaire','Emprise ferroviaire et équipements associés'),
     (32,'0603','infrastructure aéroportuaire','Emprise aéroportuaire et équipements associés'),
     (33,'0604','infrastructure portuaire','Port d''ampleur nationale (frêt, marchandises…)'),
     (34,'0700','activité agricole','Toutes activités agricoles'),
     (35,'0701','terres agricoles non bâties','Terres agricoles dépourvues de toute construction'),
     (36,'0702','terres agricoles avec bâtis légers','terres agricoles pouvant contenir des constructions démontables (serres, tunnels,
constructions sans fondation…)'),
     (37,'0703','terres agricoles avec bâtis en dur','terres agricoles avec éventuellement des bâtiments agricoles en dur'),
     (38,'0704','terres agricoles avec bâtis agricoles','terres agricoles avec éventuellement des bâtiments agricoles, le logement des
exploitants et des locaux dans le prolongement de l’activité agricole (point de vente à
la ferme, atelier de transformation des produits de la ferme...)'),
     (39,'0705','terres agricoles avec bâtis divers','terres agricoles avec éventuellement des bâtiments agricoles, le logement des
exploitants, des locaux dans le prolongement de l’activité agricole (point de vente à la
ferme, atelier de transformation des produits de la ferme…), des locaux associés à une
diversification (touristique, culturelle, éducative…)'),
     (40,'0800','espace naturel','Tous espaces naturels'),
     (41,'0801','espace naturel remarquable','espace naturel remarquable'),
     (42,'0802','espace naturel montagne ou littoral','espace naturel caractéristique du patrimoine naturel et relevant de l’application des
dispositions montagne / littoral'),
     (43,'0900','Valorisation des sols et sous-sols','Toutes valorisations des sols et sous-sols'),
     (44,'0901','secteur de carrière','Secteur d''activité d''extraction minérale'),
     (45,'0902','secteur d''accueil des déchets','Secteur de traitement ou d''enfouissement des déchets'),
     (46,'0903','secteur de parc photovoltaïque','secteur susceptible d’accueillir des parcs photovoltaïques'),
     (47,'9900','autre','Autre');


-- destinationtype
INSERT INTO urba_plui_ecriture.destinationtype (id,destination,lib_destination) VALUES
     (1,'10','Exploitation agricole et forestière'),
     (2,'11','Exploitation agricole et forestière - exploitation agricole'),
     (3,'12','Exploitation agricole et forestière - exploitation forestière'),
     (4,'20','Habitation'),
     (5,'21','Habitation - logement'),
     (6,'22','Habitation - hébergement'),
     (7,'30','Commerce et activités de service'),
     (8,'31','Commerce et activités de service - artisanat et commerce de détail'),
     (9,'32','Commerce et activités de service - restauration'),
     (10,'33','Commerce et activités de service - commerce de gros'),
     (11,'34','Commerce et activités de service - activités de services où s''effectue l''accueil d''une clientèle'),
     (12,'35','Commerce et activités de service - cinéma'),
     (13,'36','Commerce et activités de service - hôtels'),
     (14,'37','Commerce et activités de service - autres hébergements touristiques'),
     (15,'40','Equipements d''intérêt collectif et services publics'),
     (16,'41','Equipements d''intérêt collectif et services publics - locaux et bureaux accueillant du public des administrations publiques et assimilés'),
     (17,'42','Equipements d''intérêt collectif et services publics - locaux techniques et industriels des administrations publiques et assimilés'),
     (18,'43','Equipements d''intérêt collectif et services publics - établissements d''enseignement, de santé et d''action sociale'),
     (19,'44','Equipements d''intérêt collectif et services publics - salles d''art et de spectacles'),
     (20,'45','Equipements d''intérêt collectif et services publics - équipements sportifs'),
     (21,'46','Equipements d''intérêt collectif et services publics - autres équipements recevant du public'),
     (22,'50','Autres activités des secteurs secondaire ou tertiaire'),
     (23,'51','Autres activités des secteurs secondaire ou tertiaire - industrie'),
     (24,'52','Autres activités des secteurs secondaire ou tertiaire - entrepôt'),
     (25,'53','Autres activités des secteurs secondaire ou tertiaire - bureau'),
     (26,'54','Autres activités des secteurs secondaire ou tertiaire - centre de congrès et d''exposition'),
     (27,'99','Autres activités, usages et affectations des sols. Il est recommandé de consulter le règlement littéral.');


-- prescriptionurbatype
INSERT INTO urba_plui_ecriture.prescriptionurbatype (id,typepsc,lib_libelle_typepsc,stypepsc,lib_libelle_stypepsc,lib_ref_legis,lib_ref_regl,lib_supprime,lib_version_cnig_fin,lib_remarques,lib_cacher) VALUES
     (1,'01','Espace boisé classé','00','Espace boisé classé','L113-1','R151-31 1° ',false,NULL,NULL,false),
     (2,'01','Espace boisé classé','01','Espace boisé classé à protéger ou conserver','L113-1','R151-31 1° ',false,NULL,NULL,false),
     (3,'01','Espace boisé classé','02','Espace boisé classé à créer','L113-1','R151-31 1° ',false,NULL,NULL,false),
     (4,'01','Espace boisé classé','03','Espace boisé classé significatif au titre de la loi littoral','L121-27',' ',false,NULL,NULL,false),
     (5,'02','Limitations de la constructibilité pour des raisons environnementales, de risques, d’intérêt général','00','Limitations de la constructibilité pour des raisons environnementales, de risques, d’intérêt général','','R151-31 2° et R151-34 1° ',false,NULL,NULL,false),
     (6,'02','Limitations de la constructibilité pour des raisons environnementales, de risques, d’intérêt général','01','Secteur avec interdiction de constructibilité pour des raisons environnementales, de risques, d’intérêt général','','R151-31 2° ',false,NULL,NULL,false),
     (7,'02','Limitations de la constructibilité pour des raisons environnementales, de risques, d’intérêt général','02','Secteur avec conditions spéciales de constructibilité pour des raisons environnementales, de risques, d’intérêt général','','R151-34 1° ',false,NULL,NULL,false),
     (8,'03','Secteur avec disposition de reconstruction / démolition','00','Secteur avec disposition de reconstruction / démolition','L151-10','R151-34 3° ',false,NULL,NULL,false),
     (9,'03','Secteur avec disposition de reconstruction / démolition','01','Secteur dans lequel la reconstruction à l''identique d''un bâtiment détruit par un sinistre n''est pas autorisée','','R161-7 ',true,'2017','Réservé aux cartes communales',false),
     (10,'03','Secteur avec disposition de reconstruction / démolition','02','Interdiction de restauration de bâtiment dont il reste l’essentiel des murs porteurs','L111-23',' ',false,NULL,NULL,false),
     (11,'04','Périmètre issu des PDU sur obligation de stationnement','00','Périmètre issu des PDU sur obligation de stationnement','L151-47 dernier alinéa',' ',false,NULL,NULL,false),
     (12,'05','Emplacement réservé','00','Emplacement réservé','L151-41 1° à 3°','R151-34 4°, R151-38 1°, R151-43 3°, R151-48 2°, R151-50 1° ',false,NULL,'Sauf lot de données antérieurs au standard v2017, ne pas utiliser le sous-code 00',false),
     (13,'05','Emplacement réservé','01','Emplacement réservé aux voies publiques','L151-41 1°','R151-48 2° ',false,NULL,NULL,false),
     (14,'05','Emplacement réservé','02','Emplacement réservé aux ouvrages publics','L151-41 1°','R151-50 1° ',false,NULL,NULL,false),
     (15,'05','Emplacement réservé','03','Emplacement réservé aux installations d’intérêt général','L151-41 2°','R151-34 4° ',false,NULL,NULL,false),
     (16,'05','Emplacement réservé','04','Emplacement réservé aux espaces verts/continuités écologiques','L151-41 3°','R151-43 3° ',false,NULL,NULL,false),
     (17,'05','Emplacement réservé','05','Emplacement réservé logement social/mixité sociale','L151-41 4°','R151-38 1° ',false,NULL,NULL,false),
     (18,'05','Emplacement réservé','06','Servitude de localisation des voies, ouvrages publics, installations d’intérêt général et espaces verts en zone U ou AU','L151-41 dernier alinéa',' ',false,NULL,NULL,false),
     (19,'05','Emplacement réservé','07','Secteur de projet en attente d’un projet d’aménagement global','L151-41 5°','R151-32 ',false,NULL,NULL,false),
     (20,'05','Emplacement réservé','08','Emplacements réservés à la relocalisation d’équipements, de constructions et d’installations exposés au recul du trait de côte','L151-41 6°','en attente ',false,NULL,NULL,false),
     (21,'06','Secteur à densité maximale pour les reconstructions ou aménagements de bâtiments existants','00','Secteur à densité maximale pour les reconstructions ou aménagements de bâtiments existants','L123-1-5 5','R123-11 e',true,'2017','Abrogé',false),
     (22,'07','Patrimoine bâti, paysager ou éléments de paysages à protéger pour des motifs d''ordre culturel, historique, architectural ou écologique','00','Patrimoine bâti, paysager ou éléments de paysages à protéger pour des motifs d''ordre culturel, historique, architectural ou écologique','L151-19 et L151-23','R151-41 3° et R151-43 5° ',false,NULL,NULL,false),
     (23,'07','Patrimoine bâti, paysager ou éléments de paysages à protéger pour des motifs d''ordre culturel, historique, architectural ou écologique','01','Patrimoine bâti à protéger pour des motifs d''ordre culturel, historique, architectural','L151-19','R151-41 3° ',false,NULL,NULL,false),
     (24,'07','Patrimoine bâti, paysager ou éléments de paysages à protéger pour des motifs d''ordre culturel, historique, architectural ou écologique','02','Patrimoine paysager à protéger pour des motifs d''ordre culturel, historique, architectural','L151-19','R151-41 3° ',false,NULL,NULL,false),
     (25,'07','Patrimoine bâti, paysager ou éléments de paysages à protéger pour des motifs d''ordre culturel, historique, architectural ou écologique','03','Patrimoine paysager correspondant à un espace boisé à protéger pour des motifs d''ordre culturel, historique, architectural','L151-19','R151-41 3° ',false,NULL,NULL,false),
     (26,'07','Patrimoine bâti, paysager ou éléments de paysages à protéger pour des motifs d''ordre culturel, historique, architectural ou écologique','04','Éléments de paysage, (sites et secteurs) à préserver pour des motifs d''ordre écologique','L151-23','R151-43 5° ',false,NULL,NULL,false),
     (27,'07','Patrimoine bâti, paysager ou éléments de paysages à protéger pour des motifs d''ordre culturel, historique, architectural ou écologique','05','Éléments de paysage correspondant à un espace boisé, (sites et secteurs) à préserver pour des motifs d''ordre écologique','L151-23 al.1','R151-43 5° ',false,NULL,NULL,false),
     (28,'08','Terrain cultivé ou non bâti à protéger en zone urbaine','00','Terrain cultivé ou non bâti à protéger en zone urbaine','L151-23 al. 2','R151-43 6° ',false,NULL,NULL,false),
     (29,'09','Emplacement réservé logement social/mixité sociale','00','Emplacement réservé logement social/mixité sociale','L151-41 4°','R151-38 1°',true,'2022','Transféré en 05 05',false),
     (30,'10','Servitude de localisation des voies (,,) et espaces verts en zone U ou AU','00','Servitude de localisation des voies (,,) et espaces verts en zone U ou AU',NULL,' ',true,'2017','Transféré en 05 06',false),
     (31,'11','Règles d’implantation des constructions','00','Règles d’implantation des constructions',NULL,' ',true,'2017','Transféré en code 15',false),
     (32,'12','Secteur de projet en attente d’un projet d’aménagement global','00','Secteur de projet en attente d’un projet d’aménagement global',NULL,' ',true,'2017','Transféré en 05 07',false),
     (33,'13','Zone à aménager en vue de la pratique du ski','00','Zone à aménager en vue de la pratique du ski','L151-38 al. 2','R151-48 3° ',false,NULL,NULL,false),
     (34,'14','Secteur de plan de masse','00','Secteur de plan de masse','','R151-40 ',false,NULL,NULL,false),
     (35,'15','Règles d’implantation des constructions','00','Règles d’implantation des constructions','L151-17 et L151-18','R151-39 dernier al. ',false,NULL,NULL,false),
     (36,'15','Règles d’implantation des constructions','01','Implantation des constructions par rapport aux voies et aux emprises publiques','L151-17 et L151-18','R151-39 ',false,NULL,NULL,false),
     (37,'15','Règles d’implantation des constructions','02','Implantation des constructions par rapport aux limites séparatives latérales','L151-17 et L151-18','R151-39 ',false,NULL,NULL,false),
     (38,'15','Règles d’implantation des constructions','03','Implantation des constructions par rapport aux limites des fonds de parcelles','L151-17','R151-39 ',false,NULL,NULL,false),
     (39,'15','Règles d’implantation des constructions','98','Implantation alternative des constructions','L151-17','R151-39 ',false,NULL,NULL,false),
     (40,'16','Constructions et installations nécessaires à des équipements collectifs en zone A ou N','00','Constructions et installations nécessaires à des équipements collectifs en zone A ou N','L151-11 I 1°','R151-23 2° et R151-25 2° ',false,NULL,NULL,false),
     (41,'16','Constructions et installations nécessaires à des équipements collectifs en zone A ou N','01','Bâtiment susceptible de changer de destination en zone A ou N','L151-11 I 2°','R151-23 2°, R151-25 2° et R151-35 ',false,NULL,NULL,false),
     (42,'16','Constructions et installations nécessaires à des équipements collectifs en zone A ou N','02','Bâtiments d’habitation existants pouvant faire l’objet d’extensions ou d’annexes en zone A ou N','L151-12','R151-23 2° et R151-25 2° ',false,NULL,NULL,false),
     (43,'16','Constructions et installations nécessaires à des équipements collectifs en zone A ou N','03','Secteur de taille et de capacité d’accueil limitées (STECAL) en zone A ou N','L151-13','R151-23 2° et R151-25 2° ',false,NULL,NULL,false),
     (44,'16','Constructions et installations nécessaires à des équipements collectifs en zone A ou N','04','Constructions et installations nécessaires à l’activité agricole en zone A ou N','','R151-23 1° et R151-25 1° ',false,NULL,NULL,false),
     (45,'16','Constructions et installations nécessaires à des équipements collectifs en zone A ou N','05','Diversification de l''activité agricole : transformation, conditionnement et ventes de produits agricoles (activités liées au tourisme exclues)','L151-11 II',' ',false,NULL,NULL,false),
     (46,'17','Secteur à programme de logements mixité sociale en zone U et AU','00','Secteur à programme de logements mixité sociale en zone U et AU','L151-15','R151-38 3° ',false,NULL,NULL,false),
     (47,'18','Périmètre comportant des orientations d’aménagement et de programmation (OAP)','00','Périmètre comportant des orientations d’aménagement et de programmation (OAP)','L151-6 et L151-7','R151-6 à R151-8-1 ',false,NULL,NULL,false),
     (48,'18','Périmètre comportant des orientations d’aménagement et de programmation (OAP)','01','OAP de projet (sans règlement)','L151-6 et L151-7','R151-8 ',false,NULL,NULL,false),
     (49,'18','Périmètre comportant des orientations d’aménagement et de programmation (OAP)','02','OAP entrées de ville','L151-6 et L151-7 1°','R151-6 ',false,NULL,NULL,false),
     (50,'18','Périmètre comportant des orientations d’aménagement et de programmation (OAP)','03','OAP relatives à la réhabilitation, la restructuration, la mise en valeur ou l’aménagement','L151-7 4°',' ',false,NULL,NULL,false),
     (51,'18','Périmètre comportant des orientations d’aménagement et de programmation (OAP)','04','OAP d’adaptation des périmètres de transports collectifs','L151-7 6°',' ',false,NULL,NULL,false),
     (52,'18','Périmètre comportant des orientations d’aménagement et de programmation (OAP)','05','OAP patrimoniales, architecturales et écologiques','L151-6 et L151-7 1°','R151-7 ',false,NULL,NULL,false),
     (53,'18','Périmètre comportant des orientations d’aménagement et de programmation (OAP)','06','OAP relatives à l’habitat','L151-6 et L151-46',' ',false,NULL,NULL,false),
     (54,'18','Périmètre comportant des orientations d’aménagement et de programmation (OAP)','07','OAP comprenant des dispositions relatives à l''équipement commercial, artisanal et logistique','L151-6 2e alinéa et L151-7 2°',' ',false,NULL,NULL,false),
     (55,'18','Périmètre comportant des orientations d’aménagement et de programmation (OAP)','08','OAP relatives aux transports et aux déplacements','L151-6 ou L151-47',' ',false,NULL,NULL,false),
     (56,'18','Périmètre comportant des orientations d’aménagement et de programmation (OAP)','09','OAP relatives aux espaces publics en zone d’aménagement concerté','L151-7-1 1°',' ',false,NULL,NULL,false),
     (57,'18','Périmètre comportant des orientations d’aménagement et de programmation (OAP)','10','OAP relatives aux ouvrages publics, installations d’intérêt général et espaces verts en zone d’aménagement concerté','L151-7-1 2°',' ',false,NULL,NULL,false),
     (58,'18','Périmètre comportant des orientations d’aménagement et de programmation (OAP)','11','OAP valant création de zone d’aménagement concerté','L151-7-2','R. 151-8-1 ',false,NULL,NULL,false),
     (59,'18','Périmètre comportant des orientations d’aménagement et de programmation (OAP)','12','OAP secteurs de renaturation','L. 151-7 I 4°',' ',false,NULL,NULL,false),
     (60,'18','Périmètre comportant des orientations d’aménagement et de programmation (OAP)','13','OAP relatives à la protection des franges urbaines et rurales','L.151-7 I 7°',' ',false,NULL,NULL,false),
     (61,'18','Périmètre comportant des orientations d’aménagement et de programmation (OAP)','14','OAP recul du trait de côte','L.151-7 III',' ',false,NULL,NULL,false),
     (62,'19','Secteur protégé en raison de la richesse du sol et du sous-sol','00','Secteur protégé en raison de la richesse du sol et du sous-sol','','R151-34 2° ',false,NULL,NULL,false),
     (63,'20','Secteur à transfert de constructibilité en zone N','00','Secteur à transfert de constructibilité en zone N','L151-25','R151-36 ',false,NULL,NULL,false),
     (64,'21','Terrain concerné par la localisation d''équipements en zone U et AU, voies, ouvrages publics, espaces verts','00','Terrain concerné par la localisation d''équipements en zone U et AU, voies, ouvrages publics, espaces verts','L123-2c','R123-12 4d',true,'2017','Doublon avec code 10 (lui-même transféré en 05 06)',false),
     (65,'22','Diversité commerciale à protéger ou à développer','00','Diversité commerciale à protéger ou à développer','L151-1 6-1','R151-37 4° ',false,NULL,NULL,false),
     (66,'22','Diversité commerciale à protéger ou à développer','01','Diversité commerciale à protéger','L151-1 6-1','R151-37 4° ',false,NULL,NULL,false),
     (67,'22','Diversité commerciale à protéger ou à développer','02','Diversité commerciale à développer','L151-1 6-1','R151-37 4° ',false,NULL,NULL,false),
     (68,'22','Diversité commerciale à protéger ou à développer','03','Linéaire commercial protégé','L151-1 6-1','R151-37 4° ',false,NULL,NULL,false),
     (69,'22','Diversité commerciale à protéger ou à développer','04','Linéaire commercial protégé renforcé','L151-1 6-1','R151-37 4° ',false,NULL,NULL,false),
     (70,'23','Secteur avec taille minimale des logements en zone U et AU','00','Secteur avec taille minimale des logements en zone U et AU','L151-14','R151-38 2° ',false,NULL,NULL,false),
     (71,'24','Voies, chemins, transport public à conserver et à créer','00','Voies, chemins, transport public à conserver et à créer','L151-38','R151-48 1° ',false,NULL,NULL,false),
     (72,'24','Voies, chemins, transport public à conserver et à créer','01','Voies de circulation à créer, modifier ou conserver','L151-38','R151-48 1° ',false,NULL,NULL,false),
     (73,'24','Voies, chemins, transport public à conserver et à créer','02','Voies de circulation à modifier','L151-38','R151-48 1° ',false,NULL,NULL,false),
     (74,'24','Voies, chemins, transport public à conserver et à créer','03','Voies de circulation à créer','L151-38','R151-48 1° ',false,NULL,NULL,false),
     (75,'24','Voies, chemins, transport public à conserver et à créer','04','Voies de circulation à conserver','L151-38','R151-48 1° ',false,NULL,NULL,false),
     (76,'25','Eléments de continuité écologique et trame verte et bleue','00','Eléments de continuité écologique et trame verte et bleue','L151-23 al. 2','R151-43 4° et R151-43 8° ',false,NULL,NULL,false),
     (77,'26','Secteur de performance énergétique','00','Secteur de performance énergétique','L151-21','R151-42 1° ',false,NULL,NULL,false),
     (78,'26','Secteur de performance énergétique','01','Secteur de performance énergétique renforcé','L151-21','R151-42 2° ',false,NULL,NULL,false),
     (79,'27','Secteur d’aménagement numérique','00','Secteur d’aménagement numérique','L151-40','R151-50 2° ',false,NULL,NULL,false),
     (80,'28','Conditions de desserte','00','Conditions de desserte','','R151-47 1° et 2° ',false,NULL,NULL,false),
     (81,'28','Conditions de desserte','01','Conditions permettant une bonne desserte des terrains par les services publics de collecte des déchets','','R151-47 2° ',false,NULL,NULL,false),
     (82,'29','Secteur avec densité minimale de construction','00','Secteur avec densité minimale de construction','','R151-39 2ème al. ',false,NULL,NULL,false),
     (83,'29','Secteur avec densité minimale de construction','01','Secteur avec densité minimale de construction à proximité des transports collectifs','L151-26','R151-39 2ème al. ',false,NULL,NULL,false),
     (84,'29','Secteur avec densité minimale de construction','02','Secteur de ZAC avec densité minimale de construction','L151-27 2e al.',' ',false,NULL,NULL,false),
     (85,'30','Majoration des volumes constructibles^{3}','00','Majoration des volumes constructibles^{3}','','R151-37 2° ',false,NULL,NULL,false),
     (86,'30','Majoration des volumes constructibles^{3}','01','Majoration des volumes constructibles pour l’habitation','L151-28 1°','R151-37 5° ',false,NULL,NULL,false),
     (87,'30','Majoration des volumes constructibles^{3}','02','Majoration des volumes constructibles pour les programmes comportant des logements locatifs sociaux','L151-28 2°','R151-37 2° ',false,NULL,NULL,false),
     (88,'30','Majoration des volumes constructibles^{3}','03','Majoration des volumes constructibles pour exemplarité énergétique ou environnementale','L151-28 3°','R151-42 3° ',false,NULL,NULL,false),
     (89,'30','Majoration des volumes constructibles^{3}','04','Majoration des volumes constructibles pour les programmes comportant des logements intermédiaires','L151-28 4°','R151-37 7° ',false,NULL,NULL,false),
     (90,'31','Espaces remarquables du littoral','00','Espaces remarquables du littoral','L121-23','R121-4 1° à 8° ',false,NULL,NULL,false),
     (91,'31','Espaces remarquables du littoral','01','Dunes, landes côtières, plages et lidos, estrans, falaises et abords','L121-23','R121-4 1°',false,NULL,NULL,false),
     (92,'31','Espaces remarquables du littoral','02','Forêts et zones boisées proches du rivage de la mer et des plans d’eau intérieurs d’une superficie supérieure à 1 000 hectares','L121-23','R121-4 2°',false,NULL,NULL,false),
     (93,'31','Espaces remarquables du littoral','03','Ilots inhabités','L121-23','R121-4 3°',false,NULL,NULL,false),
     (94,'31','Espaces remarquables du littoral','04','Parties naturelles des estuaires, des rias ou abers et des caps','L121-23','R121-4 4°',false,NULL,NULL,false),
     (95,'31','Espaces remarquables du littoral','05','Marais, vasières, tourbières, plans d''eau, les zones humides et milieux temporairement immergés','L121-23','R121-4 5°',false,NULL,NULL,false),
     (96,'31','Espaces remarquables du littoral','06','Milieux abritant des concentrations naturelles d''espèces animales ou végétales','L121-23','R121-4 6°',false,NULL,NULL,false),
     (97,'31','Espaces remarquables du littoral','07','Parties naturelles des sites inscrits ou classés','L121-23','R121-4 7°',false,NULL,NULL,false),
     (98,'31','Espaces remarquables du littoral','08','Formations géologiques','L121-23','R121-4 8°',false,NULL,NULL,false),
     (99,'32','Exclusion protection de plans d’eau de faible importance','00','Exclusion protection de plans d’eau de faible importance','L122-12','R122-2 ',false,NULL,NULL,false),
     (100,'33','Secteur de dérogation aux protections des rives des plans d''eau en zone de montagne','00','Secteur de dérogation aux protections des rives des plans d''eau en zone de montagne','L122-14 1°',' ',false,NULL,NULL,false);
INSERT INTO urba_plui_ecriture.prescriptionurbatype (id,typepsc,lib_libelle_typepsc,stypepsc,lib_libelle_stypepsc,lib_ref_legis,lib_ref_regl,lib_supprime,lib_version_cnig_fin,lib_remarques,lib_cacher) VALUES
     (101,'34','Espaces, paysage et milieux caractéristiques du patrimoine naturel et culturel montagnard à préserver','00','Espaces, paysage et milieux caractéristiques du patrimoine naturel et culturel montagnard à préserver','L122-9',' ',false,NULL,NULL,false),
     (102,'35','Terres nécessaires au maintien et au développement des activités agricoles, pastorales et forestières à préserver','00','Terres nécessaires au maintien et au développement des activités agricoles, pastorales et forestières à préserver','L122-10',' ',false,NULL,NULL,false),
     (103,'36','Mixité des destinations ou sous-destinations','00','Mixité des destinations ou sous-destinations','','R151-37 1° ',false,NULL,NULL,false),
     (104,'37','Règles différenciées entre le rez-de-chaussée et les étages supérieurs des constructions','00','Règles différenciées entre le rez-de-chaussée et les étages supérieurs des constructions','','R151-37 3° ',false,NULL,NULL,false),
     (105,'37','Règles différenciées entre le rez-de-chaussée et les étages supérieurs des constructions','01','Règles différenciées pour le rez-de-chaussée en raison des risques inondations','','R151-42 4° ',false,NULL,NULL,false),
     (106,'37','Règles différenciées entre le rez-de-chaussée et les étages supérieurs des constructions','02','Règles différenciées pour mixité sociale et fonctionnelle','','R151-37 1° et 3° ',false,NULL,NULL,false),
     (107,'38','Emprise au sol','00','Emprise au sol','','R151-39 ',false,NULL,NULL,false),
     (108,'38','Emprise au sol','01','Emprise au sol minimale','','R151-39 2ème al.',false,NULL,NULL,false),
     (109,'38','Emprise au sol','02','Emprise au sol maximale','','R151-39 1er al.',false,NULL,NULL,false),
     (110,'38','Emprise au sol','97','Emprise au sol règles qualitatives','','R151-39 al.',false,NULL,NULL,false),
     (111,'38','Emprise au sol','98','Emprise au sol règles alternatives','','R151-41 1°',false,NULL,NULL,false),
     (112,'39','Hauteur','00','Hauteur','','R151-39',false,NULL,NULL,false),
     (113,'39','Hauteur','01','Hauteur minimale','','R151-39 2ème al.',false,NULL,NULL,false),
     (114,'39','Hauteur','02','Hauteur maximale','','R151-39 1er al.',false,NULL,NULL,false),
     (115,'39','Hauteur','97','Hauteur règles qualitatives','','R151-39 dernier al.',false,NULL,NULL,false),
     (116,'39','Hauteur','98','Hauteur règles alternatives','','R151-41 1°',false,NULL,NULL,false),
     (117,'40','Volumétrie','00','Volumétrie','','R151-39',false,NULL,NULL,false),
     (118,'40','Volumétrie','01','Volumétrie minimale','','R151-39 2ème al.',false,NULL,NULL,false),
     (119,'40','Volumétrie','02','Volumétrie maximale','','R151-39 1er al.',false,NULL,NULL,false),
     (120,'40','Volumétrie','97','Règles volumétriques qualitatives','','R151-39 dernier al.',false,NULL,NULL,false),
     (121,'40','Volumétrie','98','Règles volumétriques alternatives','','R151-41 1°',false,NULL,NULL,false),
     (122,'41','Aspect extérieur','00','Aspect extérieur','L151-18','R151-41 2°',false,NULL,NULL,false),
     (123,'41','Aspect extérieur','01','Aspect extérieur façades','L151-18','R151-41 2°',false,NULL,NULL,false),
     (124,'41','Aspect extérieur','02','Aspect extérieur toitures','L151-18','R151-41 2°',false,NULL,NULL,false),
     (125,'41','Aspect extérieur','03','Aspect extérieur clôtures','L151-18','R151-41 2°',false,NULL,NULL,false),
     (126,'41','Aspect extérieur','98','Aspect extérieur règles alternatives','','R151-13',false,NULL,NULL,false),
     (127,'42','Coefficient de biotope par surface','00','Coefficient de biotope par surface','L151-22','R151-43 1°',false,NULL,NULL,false),
     (128,'43','Réalisation d’espaces libres, plantations, aires de jeux et de loisir','00','Réalisation d’espaces libres, plantations, aires de jeux et de loisir','','R151-43 2° et 8°',false,NULL,NULL,false),
     (129,'43','Réalisation d’espaces libres, plantations, aires de jeux et de loisir','01','Réalisation d’espaces libres,','','R151-43 2°',false,NULL,NULL,false),
     (130,'43','Réalisation d’espaces libres, plantations, aires de jeux et de loisir','02','Réalisation d’aires de jeux et de loisirs','','R151-43 2°',false,NULL,NULL,false),
     (131,'43','Réalisation d’espaces libres, plantations, aires de jeux et de loisir','03','Réglementation des plantations','','R151-43 8°',false,NULL,NULL,false),
     (132,'44','Stationnement','00','Stationnement','','R151-44',false,NULL,NULL,false),
     (133,'44','Stationnement','01','Stationnement minimal','L151-30 à L151-37','R151-44',false,NULL,NULL,false),
     (134,'44','Stationnement','02','Stationnement maximal','L151-30 à L151-37','R151-45 3°',false,NULL,NULL,false),
     (135,'44','Stationnement','03','Caractéristiques et type de stationnement','','R151-45 1°',false,NULL,NULL,false),
     (136,'44','Stationnement','04','Minoration des règles de stationnement','','R151-45 2°',false,NULL,NULL,false),
     (137,'44','Stationnement','05','Réalisation d’aires de livraisons imposée','L151-33-1','',false,NULL,NULL,false),
     (138,'44','Stationnement','98','Stationnement règles alternatives','','R151-13',false,NULL,NULL,false),
     (139,'45','Secteur de ZAC avec surfaces de plancher déterminées','00','Secteur de ZAC avec surfaces de plancher déterminées','L 151-27 1°','',false,NULL,NULL,false),
     (140,'46','Constructibilité espace boisé antérieur au 20^{ème} siècle','00','Constructibilité espace boisé antérieur au 20^{ème} siècle','L151-20','',false,NULL,NULL,false),
     (141,'47','Desserte par les réseaux','00','Desserte par les réseaux','L151-39','R151-49',false,NULL,NULL,false),
     (142,'47','Desserte par les réseaux','01','Réseaux publics d''eau','L151-39','R151-49',false,NULL,NULL,false),
     (143,'47','Desserte par les réseaux','02','Réseaux publics d''électricité','L151-39','R151-49',false,NULL,NULL,false),
     (144,'47','Desserte par les réseaux','03','Réseaux publics d''assainissement','L151-39','R151-49',false,NULL,NULL,false),
     (145,'47','Desserte par les réseaux','04','Conditions de réalisation d''un assainissement non collectif','L151-39','R151-49',false,NULL,NULL,false),
     (146,'47','Desserte par les réseaux','05','Infrastructures et réseaux de communications électroniques','L151-39','R151-49 3°',false,NULL,NULL,false),
     (147,'48','Mesures pour limiter l''imperméabilisation des sols','00','Mesures pour limiter l''imperméabilisation des sols','','R151-49 2°',false,NULL,NULL,false),
     (148,'48','Mesures pour limiter l''imperméabilisation des sols','01','Installations nécessaires à la gestion des eaux pluviales et du ruissellement','','R151-43 7° et R151-49 2°',false,NULL,NULL,false),
     (149,'49','Opération d''ensemble imposée en zone AU','00','Opération d''ensemble imposée en zone AU','','R151-20',false,NULL,NULL,false),
     (150,'49','Opération d''ensemble imposée en zone AU','01','Urbanisation par opération d''ensemble','','R151-20 2ème al.',false,NULL,NULL,false),
     (151,'49','Opération d''ensemble imposée en zone AU','02','Urbanisation conditionnée à la réalisation des équipements internes à la zone','','R151-20 3^{e} al.',false,NULL,NULL,false),
     (152,'50','Interdiction types d’activités, destinations, sous-destinations','00','Interdiction types d’activités, destinations, sous-destinations','L151-9','R151-30',false,NULL,NULL,false),
     (153,'51','Autorisation sous conditions types d’activités, destinations, sous-destinations','00','Autorisation sous conditions types d’activités, destinations, sous-destinations','L151-9','R151-33',false,NULL,NULL,false),
     (154,'52','Infrastructures et équipements logistiques à préserver ou à développer en zones U et AU','00','Infrastructures et équipements logistiques à préserver ou à développer en zones U et AU','L151-16- 2','',false,NULL,NULL,false),
     (155,'97','Périmètre d’application d’une pièce écrite territorialisée (rapport de présentation, PADD, règlement, règlement graphique, POA)','00','Périmètre d’application d’une pièce écrite territorialisée (rapport de présentation, PADD, règlement, règlement graphique, POA)','','',false,NULL,NULL,false),
     (156,'97','Périmètre d’application d’une pièce écrite territorialisée (rapport de présentation, PADD, règlement, règlement graphique, POA)','01','Périmètre couvert par un Plan de secteurs','L151-3','',false,NULL,NULL,false),
     (157,'99','Autre','00','Autre','','',false,NULL,NULL,false),
     (158,'99','Autre','01','Autre : affectation des sols et destination des constructions','L151-9 à L151-10','R151-27 à R151-29 et R151-30 à R151-36',false,NULL,NULL,false),
     (159,'99','Autre','02','Autre : zones naturelles, agricoles ou forestières','L151-11 à L151-13','R151-17 à R151-26',false,NULL,NULL,false),
     (160,'99','Autre','03','Autre : mixité sociale et fonctionnelle en zones urbaines ou à urbaniser','L151-14 à L151-16','R151-37 à R151-38',false,NULL,NULL,false),
     (161,'99','Autre','04','Autre : qualité du cadre de vie','L151-17 à L151-25','',false,NULL,NULL,false),
     (162,'99','Autre','05','Autre : Qualité urbaine, architecturale, environnementale et paysagère','','R151-41 à R151-42',false,NULL,NULL,false),
     (163,'99','Autre','06','Autre : Traitement environnemental et paysager des espaces non bâtis et abords des constructions','','R151-43',false,NULL,NULL,false),
     (164,'99','Autre','07','Autre : densité','L151-26 à L151-29','R151-39 à R151-40',false,NULL,NULL,false),
     (165,'99','Autre','08','Autre : équipements, réseaux et emplacements réservés','L151-38 à L151-42','R151-47 à R151-48 et R151-49 à R151-50',false,NULL,NULL,false),
     (166,'99','Autre','09','Autre : plan local d’urbanisme tenant lieu de programme local de l’habitat et de plan de déplacements urbains','L151-44 à L151-48','R151-54 à R151-55',false,NULL,NULL,false),
     (167,'99','Autre','10','Autre : plan local d’urbanisme tenant lieu de plan de déplacements urbains','L151-44 à L151-48','R151-55',false,NULL,NULL,false);


-- informationurbatype

 INSERT INTO urba_plui_ecriture.informationurbatype (id,typeinf,lib_libelle_typeinf,stypeinf,lib_libelle_stypeinf,lib_ref_legis,lib_ref_regl,lib_supprime,lib_version_cnig_fin,lib_remarques,lib_cacher) VALUES
     (1,'01','« Secteur sauvegardé » puis « Site patrimonial remarquable » depuis la Loi CAP de juillet 2016','00','« Secteur sauvegardé » puis « Site patrimonial remarquable » depuis la Loi CAP de juillet 2016','L631-1 code du patrimoine','',true,'2017','Ce périmètre d’information est désormais supprimé car il correspond à une SUP',false),
     (2,'02','Zone d''aménagement concerté','00','Zone d''aménagement concerté','L311-1 code de l’urbanisme','R151-52 8°',false,NULL,NULL,false),
     (3,'03','Zone de préemption dans un espace naturel et sensible [Attention : information facultative non exigée par la loi]','00','Zone de préemption dans un espace naturel et sensible [Attention : information facultative non exigée par la loi]','L215-1 code de l’urbanisme','Pas de référence pour l’annexion',false,NULL,NULL,false),
     (4,'04','Périmètre de droit de préemption urbain','00','Périmètre de droit de préemption urbain','L211-1 code de l’urbanisme','R151-52 7°',false,NULL,NULL,false),
     (5,'04','Périmètre de droit de préemption urbain','01','Périmètre de droit de préemption urbain renforcé','','R151-52 7°',false,NULL,NULL,false),
     (6,'05','Zone d''aménagement différé','00','Zone d''aménagement différé','L212-1 et L212-2-1 code de l’urbanisme','R151-52 7°',false,NULL,NULL,false),
     (7,'06','Zone d’obligation du permis de démolir','00','Zone d’obligation du permis de démolir','','',true,'2017','Transféré en Prescription 03',false),
     (8,'07','Périmètre de développement prioritaire économie d''énergie','00','Périmètre de développement prioritaire économie d''énergie','L712-2 code de l’énergie','R151-53 1°',false,NULL,NULL,false),
     (9,'08','Périmètre forestier : interdiction ou réglementation des plantations (code rural et de la pêche maritime), plantations à réaliser et semis d''essence forestière','00','Périmètre forestier : interdiction ou réglementation des plantations (code rural et de la pêche maritime), plantations à réaliser et semis d''essence forestière','L126-1 code rural et de la pêche maritime','R151-53 2°',false,NULL,NULL,false),
     (10,'09','Périmètre minier de concession pour l''exploitation ou le stockage','00','Périmètre minier de concession pour l''exploitation ou le stockage','Livres I et II du code minier','R151-53 3°',false,NULL,NULL,false),
     (11,'10','Zone de recherche et d''exploitation de carrière','00','Zone de recherche et d''exploitation de carrière','L321-1, L333-1 et L334-1 du code minier','R151-53 4°',false,NULL,NULL,false),
     (12,'11','Périmètre des zones délimitées - divisions foncières soumises à déclaration préalable','00','Périmètre des zones délimitées - divisions foncières soumises à déclaration préalable','L 115-3 code de l’urbanisme','R151-52 4°',false,NULL,NULL,false),
     (13,'12','Périmètre de sursis à statuer','00','Périmètre de sursis à statuer','L424-1 code de l’urbanisme','R151-52 13°',false,NULL,NULL,false),
     (14,'13','Secteur de programme d''aménagement d''ensemble','00','Secteur de programme d''aménagement d''ensemble','L332-9 code de l’urbanisme dans sa version antérieure au 1er mars 2012','R151-52 9°',false,NULL,NULL,false),
     (15,'14','Périmètre de voisinage d''infrastructure de transport terrestre (secteur affecté par le bruit)','00','Périmètre de voisinage d''infrastructure de transport terrestre (secteur affecté par le bruit)','L571-10 code de l’environnement','R151-53 5°',false,NULL,NULL,false),
     (16,'15','Zones Agricoles Protégées','00','Zones Agricoles Protégées','L. 112-2 du code rural','R123-14 8',true,NULL,'Abrogé. A traiter en SUP A9',false),
     (17,'16','Site archéologique [Attention : information facultative non exigée par la loi]','00','Site archéologique [Attention : information facultative non exigée par la loi]','L522-5 2ème alinéa du code du patrimoine','Pas de référence pour annexion',false,NULL,NULL,false),
     (18,'17','Zone à risque d''exposition au plomb','00','Zone à risque d''exposition au plomb','L1334-5 code de la santé publique dans sa version antérieure au 11 août 2004','R151-53 6°',false,NULL,NULL,false),
     (19,'18','Espaces et milieux à préserver, en fonction de l''intérêt écologique','00','Espaces et milieux à préserver, en fonction de l''intérêt écologique','L121-23 code de l’urbanisme','R121-4',true,'2017','Transféré en Prescription 31',false),
     (20,'20','Règlement local de publicité','00','Règlement local de publicité','L581-14 code de l’environnement','R151-53 11°',false,NULL,NULL,false),
     (21,'21','Projet de plan de prévention des risques','00','Projet de plan de prévention des risques','L562-2 code de l’environnement','R151-53 9°',false,NULL,NULL,false),
     (22,'22','Protection des rives des plans d''eau en zone de montagne','00','Protection des rives des plans d''eau en zone de montagne','L122-12 code de l’urbanisme','Pas de référence pour l’annexion',false,NULL,NULL,false),
     (23,'23','Arrêté du préfet coordonnateur de massif','00','Arrêté du préfet coordonnateur de massif','L122-12 code de l’urbanisme','R151-52 6°',false,NULL,NULL,false),
     (24,'24','Document d''aménagement artisanal et Commercial','00','Document d''aménagement artisanal et Commercial',NULL,'',true,'2017','Transféré en Prescription 18-08',false),
     (25,'25','Périmètre de protection des espaces agricoles et naturels périurbain','00','Périmètre de protection des espaces agricoles et naturels périurbain','L 113-16 code de l’urbanisme','R151-52 3°',false,NULL,NULL,false),
     (26,'26','Lotissement','00','Lotissement','L 442-9','R123-14 2',true,'2017','Abrogé',false),
     (27,'27','Plan d''exposition au bruit des aérodromes','00','Plan d''exposition au bruit des aérodromes','L112-6 code de l’urbanisme','R151-52 2°',false,NULL,NULL,false),
     (28,'28','Dépassement des règles du PLU pour diversité de l’habitat','00','Dépassement des règles du PLU pour diversité de l’habitat','L123-1 11 et L127-1','R 123-13 16',true,'2017','Transféré en Prescription 30',false),
     (29,'29','Dépassement des règles du PLU pour performance énergétique','00','Dépassement des règles du PLU pour performance énergétique','L 128-1, L128-2','R123-13 16',true,'2017','Transféré en Prescription 30',false),
     (30,'30','Périmètre projet urbain partenarial','00','Périmètre projet urbain partenarial','L332-11-3 code de l’urbanisme','R151-52 12°',false,NULL,NULL,false),
     (31,'31','Périmètres patrimoniaux d’exclusion des matériaux et énergies renouvelables pris par délibération','00','Périmètres patrimoniaux d’exclusion des matériaux et énergies renouvelables pris par délibération','L111-17 code de l’urbanisme','Pas de référence pour l’annexion',false,NULL,NULL,false),
     (32,'32','Secteur de taxe d''aménagement','00','Secteur de taxe d''aménagement','L 331-14 et L331-15 code urba.','R151-52 10°',false,NULL,NULL,false),
     (33,'33','Droit de préemption commercial [Attention : information facultative non exigée par la loi]','00','Droit de préemption commercial [Attention : information facultative non exigée par la loi]','L 214-1, R214-1 et 2 code de l’urbanisme','Pas de référence pour l’annexion',false,NULL,NULL,false),
     (34,'34','Périmètre d''opération d''intérêt national [Attention : information facultative non exigée par la loi]','00','Périmètre d''opération d''intérêt national [Attention : information facultative non exigée par la loi]','L102-12 et R102-3 code de l’urbanisme','Pas de référence pour l’annexion',false,NULL,NULL,false),
     (35,'35','Périmètre de secteur affecté par un seuil minimal de densité','00','Périmètre de secteur affecté par un seuil minimal de densité','L331-36 code de l’urbanisme','R151-52 11°',false,NULL,NULL,false),
     (36,'36','Schémas d''aménagement de plage','00','Schémas d''aménagement de plage','L121-28 code de l’urbanisme','R151-52 5°',false,NULL,NULL,false),
     (37,'37','Bois ou forêts relevant du régime forestier','00','Bois ou forêts relevant du régime forestier','L211-1 et L211-2 code forestier','R151-53 7°',false,NULL,NULL,false),
     (38,'38','Secteurs d''information sur les sols','00','Secteurs d''information sur les sols','L125-6 code de l’environnement','R151-53 10°',false,NULL,NULL,false),
     (39,'39','Périmètres de projets AFUP (dans lesquels les propriétaires fonciers sont incités à se regrouper en AFU de projet et les AFU de projet à mener leurs opérations de façon concertée)','00','Périmètres de projets AFUP (dans lesquels les propriétaires fonciers sont incités à se regrouper en AFU de projet et les AFU de projet à mener leurs opérations de façon concertée)','L322-13 code de l’urbanisme','R151-52 14°',false,NULL,NULL,false),
     (40,'41','Bande de recul le long des axes à grande circulation','00','Bande de recul le long des axes à grande circulation','L111-6 code de l’urbanisme','Pas de référence pour l’annexion',false,NULL,NULL,false),
     (41,'42','Secteurs délimités par délibération de l''autorité compétente en matière d''urbanisme, dans lesquels certaines opérations sont soumises à autorisation d''urbanisme.','00','Secteurs délimités par délibération de l''autorité compétente en matière d''urbanisme, dans lesquels certaines opérations sont soumises à autorisation d''urbanisme.',NULL,NULL,false,NULL,NULL,false),
     (42,'42','Secteurs délimités par délibération de l''autorité compétente en matière d''urbanisme, dans lesquels certaines opérations sont soumises à autorisation d''urbanisme.','01','secteur dans lequel les travaux de démolition sont soumis à permis de démolir','R421-27','Pas de référence pour l’annexion',false,NULL,NULL,false),
     (43,'42','Secteurs délimités par délibération de l''autorité compétente en matière d''urbanisme, dans lesquels certaines opérations sont soumises à autorisation d''urbanisme.','02','Secteur dans lequel l''édification d''une clôture doit être précédée d''une déclaration préalable','R421-12 d',NULL,false,NULL,NULL,false),
     (44,'42','Secteurs délimités par délibération de l''autorité compétente en matière d''urbanisme, dans lesquels certaines opérations sont soumises à autorisation d''urbanisme.','03','secteur dans lequel les travaux de ravalement sont soumis à déclaration préalable','R421-17-1 e',NULL,false,NULL,NULL,false),
     (45,'97','Périmètre d’application d’une pièce écrite territorialisée relative aux annexes (liste des annexes, liste et plan des SUP)','00','Périmètre d’application d’une pièce écrite territorialisée relative aux annexes (liste des annexes, liste et plan des SUP)',NULL,NULL,false,NULL,NULL,false),
     (46,'98','Périmètre d’annulation partielle du document d’urbanisme (lorsqu’elle impacte le règlement graphique)','00','Périmètre d’annulation partielle du document d’urbanisme (lorsqu’elle impacte le règlement graphique)',NULL,NULL,false,NULL,NULL,false),
     (47,'99','Autre périmètre, secteur, plan, document, site, projet, espace.','00','Autre périmètre, secteur, plan, document, site, projet, espace.','','',false,NULL,NULL,false),
     (48,'99','Autre périmètre, secteur, plan, document, site, projet, espace.','01','autre relevant de la loi littoral','','',false,NULL,NULL,false),
     (49,'99','Autre périmètre, secteur, plan, document, site, projet, espace.','02','autre relevant de la loi montagne','','',false,NULL,NULL,false);
