# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GeoPEC
                A QGIS plugin [Generated by Plugin Builder]


autores: Afonso P. Santos; João Vítor A. Gonçalves; Luis Philippe Ventura

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog, QMessageBox, QLabel
from qgis.core import *
from ..resources import *
# Import the code for the dialog
from ..gui.padraodistribuicao_dialog import padraodistribuicaoDialog
#from .teste_dist_espac_dialog import teste_dist_espacDialog #Atento aqui, rem que mudar para o padrao dialog
import os.path
import os

## Biblioteca com funções procedurais
from ..functions.calc_dist_esp import *


class padraodistribuicao:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
               
        #################################       
        # Pega o caminho do diretório onde o arquivo atual está localizado
        current_dir = os.path.dirname(os.path.abspath(__file__))
        # Sobe um nível na hierarquia de diretórios para chegar à pasta principal
        self.plugin_dir = os.path.dirname(current_dir)
        
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(self.plugin_dir,'i18n','pec_{}.qm'.format(locale))
        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)
        #################################
                
        # Save reference to the QGIS interface
        self.iface = iface 
        self.dlg = padraodistribuicaoDialog()

        
        # Adicionando controle de conexões - evita que a mesma função seja feita mais de uma vez desnecessariamente       
        self.first_start = True
        
        # Adicionando uma variável para controlar as conexões     
        self.connections_made = False  
        
        #Ativando métodos de atualização dos combo_Box quando uma layer é adicionada
        #ou removida do projeto
        QgsProject.instance().layersAdded.connect(self.carregaPonto)
        QgsProject.instance().layersRemoved.connect(self.carregaPonto)
        QgsProject.instance().layersAdded.connect(self.carregaPoligono)
        QgsProject.instance().layersRemoved.connect(self.carregaPoligono)
        
    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('padraodistribuicao', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action
    
    

    def initGui(self):
        pass

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        self.iface.mainWindow().menuBar().removeAction(self.menu.menuAction())
        del self.menu
        # remove the toolbar
        del self.toolbar

    def carregaPonto(self):
        """Preenche os combobox com as layers vetoriais do tipo ponto"""
        
        #limpando os comboBox do Conjunto de Pontos
        
        self.dlg.comboBox_3.clear()
        
        #obtendo as instâncias do projeto
        
        project = QgsProject.instance()
        
        #obtendo as layers
        
        layers = project.mapLayers()
        
        #obtendo somente as layers de pontos
        
        point_layers = []
        
        #garantindo que as camada adicionadas são do tipo ponto
        
        for layer in layers.values():
            if layer.type() == QgsMapLayerType.VectorLayer and layer.geometryType() == QgsWkbTypes.PointGeometry:
                point_layers.append(layer)
        
        # Adicionando as layers de pontos ao comboBox correspondente
        
        for layer in point_layers:
            self.dlg.comboBox_3.addItem(layer.name(), layer)
        

    def procuraPonto(self):
        """Execução do botão para abrir uma layer de ponto. Será aberto uma janela de diálogo e a layer escolhida será adicionada ao projeto e ao combobox"""
        camada_abrir = str(QFileDialog.getOpenFileName(caption = "Escolha a camada",filter = "Shapefiles (*.shp)")[0])
    
        if camada_abrir:
    
            # Carregar a camada
            
            layer = QgsVectorLayer(camada_abrir, str.split(os.path.basename(camada_abrir), ".") [0], "ogr")
        
        
            # Verificando se a camada possui geometria de ponto
            
            if layer.geometryType() == QgsWkbTypes.PointGeometry:
            
                # Adicionar a camada ao projeto
                
                QgsProject.instance().addMapLayer(layer)
                
                #Atualiza o comboBox ao vetor escolhido
                
                self.carregaPonto()
                
                self.dlg.comboBox_3.addItem(layer.name(), layer)
                
                index = self.dlg.comboBox_3.findText(layer.name())
                
                if index != -1:
                    self.dlg.comboBox_3.setCurrentIndex(index)
                    
            else:
            # Informar ao usuário que a camada não possui geometria de ponto
                self.show_messagebox_erro('erro', 'A camada selecionada não possui geometria de ponto')


    def carregaPoligono(self):
        """Preenche os combobox_8, quando habilitado com as layers vetoriais do tipo polígono"""
        
        
        # limpando os comboBox do Conjunto de Polígonos
        
        self.dlg.comboBox_8.clear()
        
        # obtendo as instâncias do projeto
        
        project = QgsProject.instance()
        
        # obtendo as layers
        
        layers = project.mapLayers()
        
        # obtendo somente as layers de polígonos
        
        polygon_layers = []
        
        #garantindo que as camada adicionadas são do tipo poligono
        
        for layer in layers.values():
            if layer.type() == QgsMapLayerType.VectorLayer and layer.geometryType() == QgsWkbTypes.PolygonGeometry:
                polygon_layers.append(layer)
        
        # Adicionando as layers de polígonos ao comboBox
        
        for layer in polygon_layers:
        
            self.dlg.comboBox_8.addItem(layer.name(), layer)


    def procuraPoligono(self):
        """execução do botão para abrir uma layer do tipo polígono. Será aberto uma janela de diálogo e a layer escolhida será adicionada ao projeto e ao combobox_8"""
        
        camada_abrir = str(QFileDialog.getOpenFileName(caption = "Escolha a camada",filter = "Shapefiles (*.shp)")[0])
    
        if camada_abrir:
    
            # Carregar a camada
            
            layer = QgsVectorLayer(camada_abrir, str.split(os.path.basename(camada_abrir), ".") [0], "ogr")
        
            # Verificando se a camada possui geometria de polígono
            
            if layer.geometryType() == QgsWkbTypes.PolygonGeometry:
            
                # Adicionar a camada ao projeto
                
                QgsProject.instance().addMapLayer(layer)
                
                #Atualiza o comboBox ao vetor escolhido
                
                self.carregaPoligono()
                
                self.dlg.comboBox_8.addItem(layer.name(), layer)
                
                index = self.dlg.comboBox_8.findText(layer.name())
                
                if index != -1:
                    self.dlg.comboBox_8.setCurrentIndex(index)
                    
            else:
            # Informar ao usuário que a camada não possui geometria de polígono
                
                self.show_messagebox_erro('erro', 'A camada selecionada não possui geometria de polígono.')
                

    def calculaArea(self, _=None):
        """Obtém as informações referentes à Área de Estudo"""
        
        area = 0

        # Define o nível de confiança
        
        nivel_confianca = self.defineNC()

        # Seleção manual do valor de área
        
        if self.dlg.radioButton.isChecked():
            try:
                # Permite a vírgula como separador decimal
                
                valor_area = self.dlg.lineEdit.text().replace(',', '.')
                
                valor_area = float(valor_area)
                
            except ValueError:
                
                self.show_messagebox_erro('erro', 'Por favor, insira um valor numérico válido para a área.')
                
                return None
            
            unidade = self.dlg.comboBox_7.currentText()
            
            # Transformação de unidades --> levando para m²
            
            if unidade == 'ha':
                area = valor_area * 10000
            elif unidade == 'km²':
                area = valor_area * 1000000
            else:
                area = valor_area

        # Seleção do valor de área pelo retângulo envolvente
        
        elif self.dlg.radioButton_2.isChecked():
            layer_name = self.dlg.comboBox_3.currentText()
            
            if not layer_name:
                
                self.show_messagebox_erro('erro', 'Por favor, selecione uma camada de pontos.')
                
                return None
            
            layers = QgsProject.instance().mapLayersByName(layer_name)
            
            if not layers:
                
                self.show_messagebox_erro('erro', 'Camada de pontos não encontrada.')
                
                return None
            
            layer = layers[0]
            extent = layer.extent()
            area = extent.width() * extent.height()
        
        # Seleção do valor de área por polígono escolhido pelo usuário
        
        elif self.dlg.radioButton_3.isChecked():
            layer_name = self.dlg.comboBox_8.currentText()
            
            if not layer_name:
                
                self.show_messagebox_erro('erro', 'Por favor, selecione uma camada de polígonos.')
               
                return None

            layers = QgsProject.instance().mapLayersByName(layer_name)
            if not layers:
                
                self.show_messagebox_erro('erro', 'Camada de polígonos não encontrada.')

                return None

            layer = layers[0]
            if layer.geometryType() != QgsWkbTypes.PolygonGeometry:
                
                self.show_messagebox_erro('erro', 'A camada selecionada não possui geometria de polígono.')
                
                return None

            # Contar o número de polígonos
            num_polygons = sum(1 for _ in layer.getFeatures())
            
            # Verificar se há mais de um polígono na camada
            if num_polygons != 1:
                
                self.show_messagebox_erro('erro', 'A camada (layer) selecionada deve conter uma única feição de polígono.')

                return None

            # Calcular a área se a camada tem apenas 1 polígono
            for feature in layer.getFeatures():
                geom = feature.geometry()
                area += geom.area()

        # Caso de a área ser nula ou negativa
        
        if area <= 0:
            
            self.show_messagebox_erro('erro', 'Resultado inválido para área. Por favor, verifique as entradas.')

            return None

        return area
    

        
    def habilitaArea(self):
        """Desabilita ou habilita as ferramentas gráficas, dependendo da selação do usuário"""
        
        self.dlg.radioButton.toggled.connect(self.atualizaWidgets)
        self.dlg.radioButton_2.toggled.connect(self.atualizaWidgets)
        self.dlg.radioButton_3.toggled.connect(self.atualizaWidgets)
        
        # Desabilita todos os widgets no início, quando ainda não há seleção de radioButton
        self.atualizaWidgets()
        

    def atualizaWidgets(self):
        """Desabilita as ferramentas não necessárias dependendo da seleção
        de toolButton do usuário, servindo de apoio para a função habilitaArea"""
        
        # Se a seleção manual for ativada
        
        if self.dlg.radioButton.isChecked():
            self.dlg.lineEdit.setEnabled(True)
            self.dlg.comboBox_7.setEnabled(True)
            self.dlg.comboBox_8.setEnabled(False)
            self.dlg.toolButton_2.setEnabled(False)
            
        # Se a seleção por retângulo envolvente for ativada
        
        elif self.dlg.radioButton_2.isChecked():
            self.dlg.lineEdit.setEnabled(False)
            self.dlg.comboBox_7.setEnabled(False)
            self.dlg.comboBox_8.setEnabled(False)
            self.dlg.toolButton_2.setEnabled(False)
            
        # Se a seleção por polígono for ativada
        
        elif self.dlg.radioButton_3.isChecked():
            self.dlg.lineEdit.setEnabled(False)
            self.dlg.comboBox_7.setEnabled(False)
            self.dlg.comboBox_8.setEnabled(True)
            self.dlg.toolButton_2.setEnabled(True)
            
        # Se não houver nenhuma das 3 seleções, todos ficam desabilitados
        
        else:
            self.dlg.lineEdit.setEnabled(False)
            self.dlg.comboBox_7.setEnabled(False)
            self.dlg.comboBox_8.setEnabled(False)
            self.dlg.toolButton_2.setEnabled(False)
    
    
    def atualizaComboBoxes(self):
        """Atualiza os comboBox_3 e comboBox_8 com base nas camadas no QGIS"""
        comboBox_3 = self.dlg.comboBox_3
        comboBox_8 = self.dlg.comboBox_8

        # Limpar os comboboxes referentes a ponto e polígono, respectivamente
        
        comboBox_3.clear()
        comboBox_8.clear()

        # Iterar sobre todas as camadas no QGIS
        
        for layer in QgsProject.instance().mapLayers().values():
            if layer.type() == QgsMapLayer.VectorLayer:
                if layer.geometryType() == QgsWkbTypes.PointGeometry:
                    comboBox_3.addItem(layer.name(), layer)
                elif layer.geometryType() == QgsWkbTypes.PolygonGeometry:
                    comboBox_8.addItem(layer.name(), layer)
    
    
    def defineNC(self):
        """Lê o nível de confiança do comboBox_9 e retorna a escolha do usuário"""
        
        nivel_confianca = self.dlg.comboBox_9.currentText()
        

    def insereResultado(self):
        """Insere os resultados calculados nas labels específicas"""
        
        
        # Chama a função calculaArea para obter a área
        
        area = self.calculaArea()
        
        
        if area is None:
            return


        # Chama a função fCalculaEstatistica para obter os resultados
        
        resultados = fCalculaEstatistica(self.dlg, area)
        
        if resultados is None:
            return

        try:
        
            # Desempacotando os resultados calculados em fCalculaEstatistica
            
            (R_primeira_ordem, R_segunda_ordem, R_terceira_ordem,
             r_obs_primeira_ordem, r_obs_segunda_ordem, r_obs_terceira_ordem,
             r_esperado_primeira_ordem, r_esperado_segunda_ordem, r_esperado_terceira_ordem,
             Zcalculado_primeira_ordem, Zcalculado_segunda_ordem, Zcalculado_terceira_ordem,
             SE_r_primeira_ordem, SE_r_segunda_ordem, SE_r_terceira_ordem,
             padrao_primeira_ordem, padrao_segunda_ordem, padrao_terceira_ordem,
             significancia_primeira_ordem, significancia_segunda_ordem, significancia_terceira_ordem,
             Ztabelado, nivel_confianca,
             padrao_final_primeira_ordem, padrao_final_segunda_ordem, padrao_final_terceira_ordem) = resultados


            # Função para determinar a significância estatística
            
            def determinaSignificancia(Zcalculado, Ztabelado):
                if abs(Zcalculado) > Ztabelado:
                    return "(significativo estatisticamente)"
                else:
                    return "(NÃO é significativo estatisticamente)"
            

            # Função para formatar números com vírgula como separador decimal, tendo 4 casas decimais
            
            def formataResultado4c(number):
                return f"{number:.4f}".replace('.', ',')
            
            # Função para formatar números com vírgula como separador decimal, tendo 2 casas decimais
            
            def formataResultado2c(number):
                return f"{number:.2f}".replace('.', ',')
            
            ## Atualização das labels para a primeira ordem
            
            self.dlg.label_31.setText(formataResultado4c(r_obs_primeira_ordem))
            self.dlg.label_32.setText(formataResultado4c(r_esperado_primeira_ordem))
            self.dlg.label_33.setText(formataResultado4c(R_primeira_ordem))
            self.dlg.label_34.setText(formataResultado4c(Zcalculado_primeira_ordem))
            self.dlg.label_35.setText(formataResultado4c(SE_r_primeira_ordem))
            self.dlg.label_36.setText(formataResultado2c(Ztabelado))
            self.dlg.label_56.setText(formataResultado4c(area))
            self.dlg.label_37.setText(padrao_primeira_ordem)
            self.dlg.label_38.setText(significancia_primeira_ordem)

            # Atualização das labels para a segunda ordem
            
            self.dlg.label_43.setText(formataResultado4c(r_obs_segunda_ordem))
            self.dlg.label_44.setText(formataResultado4c(r_esperado_segunda_ordem))
            self.dlg.label_45.setText(formataResultado4c(R_segunda_ordem))
            self.dlg.label_46.setText(formataResultado4c(Zcalculado_segunda_ordem))
            self.dlg.label_47.setText(formataResultado4c(SE_r_segunda_ordem))
            self.dlg.label_41.setText(padrao_segunda_ordem)
            self.dlg.label_39.setText(significancia_segunda_ordem)

             # Atualização das labels para a terceira ordem
             
            self.dlg.label_48.setText(formataResultado4c(r_obs_terceira_ordem))
            self.dlg.label_49.setText(formataResultado4c(r_esperado_terceira_ordem))
            self.dlg.label_50.setText(formataResultado4c(R_terceira_ordem))
            self.dlg.label_51.setText(formataResultado4c(Zcalculado_terceira_ordem))
            self.dlg.label_52.setText(formataResultado4c(SE_r_terceira_ordem))
            self.dlg.label_42.setText(padrao_terceira_ordem)
            self.dlg.label_40.setText(significancia_terceira_ordem)

            # Exibindo resultados finais, destacados na cor vermelha, na última linha
            
            self.dlg.label_57.setText(padrao_final_primeira_ordem)
            self.dlg.label_58.setText(padrao_final_segunda_ordem)
            self.dlg.label_59.setText(padrao_final_terceira_ordem)
            
            # Mudar automaticamente para a segunda aba do tabWidget, a aba de resultados
            self.dlg.tabWidget.setCurrentIndex(1)

        except ValueError as e:
            
            self.show_messagebox_erro('erro', 'Erro ao processar resultados.')

    
    def show_messagebox_erro(self, tipo, mensagem):

        if  (tipo == 'erro'):
        
            # Crie uma instância do QMessageBox
            msg_box = QMessageBox()



            # Defina o ícone da janela
            msg_box.setWindowIcon(QIcon(self.plugin_dir + "/icon/geopec.png"))  

            # Configure a mensagem de erro
            msg_box.setIcon(QMessageBox.Critical)
            msg_box.setWindowTitle('Erro')
            msg_box.setText(mensagem)

            # Exiba a mensagem
            msg_box.exec_()
        
            
        else: # tipo igual sucesso
            
            # Crie uma instância do QMessageBox
            msg_box = QMessageBox()

            # Defina o ícone da janela
            msg_box.setWindowIcon(QIcon(self.plugin_dir + "/icon/geopec.png"))  

            # Configure a mensagem de erro
            msg_box.setIcon(QMessageBox.Information)
            msg_box.setWindowTitle('Sucesso')
            msg_box.setText(mensagem)

            # Exiba a mensagem
            msg_box.exec_()
        
    def generateRelatorio(self):        ##(self, resultados)
        
        """ Método para gerar o relatório"""
        

        try:
            # chama a função de gerar o relatório aqui - fGeraRelatorio
            
            # Obtém a área
            area = self.calculaArea()
            if area is None:
                return
                
                
             # Obtém os resultados calculados
            resultados = fCalculaEstatistica(self.dlg, area)
            if resultados is None:
                return
                

            
            fGeraRelatorio(resultados)
              

        except:
            
            ##trocar para o messagebox da função padronizada pro geopec
            msg_box = QMessageBox()
            msg_box.setWindowTitle('Erro')  # Definir o título da janela
            msg_box.setText('Ocorreu um erro durante o processamento.')  # Definir a mensagem do erro
            msg_box.exec_() 
        

    def run(self):
        """Run method that performs all the real work"""

        if self.first_start:
            self.first_start = False
            self.dlg = padraodistribuicaoDialog()

        # O if abaixo certifica que as conexões serão feitas uma única vez.
        if not self.connections_made:
            
            # Chamando as funções para rodar o programa.
            self.carregaPonto()
            self.dlg.toolButton.clicked.connect(self.procuraPonto)
            self.habilitaArea()
            self.carregaPoligono()
            self.dlg.toolButton_2.clicked.connect(self.procuraPoligono)
           
            # Conectar o botão para calcular estatísticas e inserir resultados
            self.dlg.pushButton.clicked.connect(self.insereResultado)
            
            # Conectar o botão para gerar relatório
            self.dlg.pushButton_2.clicked.connect(self.generateRelatorio)
            
            # Marcar as conexões como feitas
            self.connections_made = True

        # Atualiza os comboboxes antes de mostrar o diálogo
        self.atualizaComboBoxes()

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        #result = self.dlg.exec_()
        # See if OK was pressed
        #if result:
            # Do something útil aqui
            #pass#
