# -*- coding: utf-8 -*-
"""
/***************************************************************************
 pec
                                 A QGIS plugin
 software cientifico para avaliação da acurácia posicional de dados espaciais
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-02-08
        git sha              : $Format:%H$
        copyright            : (C) 2024 by UFV
        email                : afonso.santos@ufv.br
        autores: Afonso P. Santos; João Vítor A. Gonçalves; Luis Philippe Ventura
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, qVersion, QCoreApplication, QUrl
from qgis.PyQt.QtGui import QIcon, QDesktopServices
from qgis.PyQt.QtWidgets import QAction, QMenu, QFileDialog,  QToolBar, QFileDialog

# Initialize Qt resources from file resources.py
from .resources import *
#from .variancia_circular import *
# Importando o código de todas as janelas gráficas
from .GeoPEC_dialog import pecDialog
from .core.tamanhoamostral import tamanhoamostral
from .core.padraodistribuicao import padraodistribuicao
from .core.posicional import posicional
from .core.gerarentrada import gerarentrada
from .core.sobre import sobre
from .gui.tamanhoamostral_dialog import tamanhoamostralDialog
from .gui.padraodistribuicao_dialog import padraodistribuicaoDialog
from .gui.posicional_dialog import posicionalDialog
from .gui.gerarentrada_dialog import gerarentradaDialog
from .gui.sobre_dialog import sobreDialog


import os.path


class pec:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'pec_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        #Chamando as classes de outros arquivos
        self.tamanhoamostral = tamanhoamostral(iface)
        self.padraodistribuicao = padraodistribuicao(iface)
        self.posicional = posicional(iface)
        self.sobre = sobre(iface)
        self.gerarentrada = gerarentrada(iface)
        # Declare instance attributes
        self.actions = []
        #self.menu = '&GeoPEC'
        
        # Atributo da barra de ferramentas
        self.toolbar = self.iface.addToolBar(u'GeoPEC')
        self.toolbar.setObjectName(u'GeoPEC')
        
        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('pec', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        """ icon_path = ':/plugins/GeoPEC/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'GeoPEC'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True """

        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        actions = self.iface.mainWindow().menuBar().actions()
        """ Create main menu"""
        lastAction = actions[-1]
        self.menu = QMenu( u'&GeoPEC', self.iface.mainWindow().menuBar() )
        self.iface.mainWindow().menuBar().insertMenu( lastAction, self.menu )
        
        #criando os submenus
        self.menuAmostragem = self.menu.addMenu(QIcon(self.plugin_dir + "/icon/amostragem-1.svg"),"&Amostragem")
        self.menuPosicional = self.menu.addMenu(QIcon(self.plugin_dir + "/icon/posicional-1.svg"),"Acurácia &posicional")
        self.menuAuxiliar = self.menu.addMenu(QIcon(self.plugin_dir + "/icon/auxiliar-1.svg"),"&Ferramentas auxiliares")
        self.menuAjuda = self.menu.addMenu(QIcon(self.plugin_dir + "/icon/ajuda-2.svg"),"A&juda")

        action = self.menuAmostragem.addAction(QIcon(self.plugin_dir + "/icon/amostragem-tamanho.svg"),"Tamanho amostral")
        action.triggered.connect(self.tamanhoamostral.run)
        action.setEnabled(True)
        self.toolbar.addAction(action)
        self.actions.append(action)

        action = self.menuAmostragem.addAction(QIcon(self.plugin_dir + "/icon/amostragem-padrao.svg"),"Padrão de distribuição espacial")
        action.triggered.connect(self.padraodistribuicao.run)
        action.setEnabled(True)
        self.toolbar.addAction(action)
        self.actions.append(action)

        action = self.menuPosicional.addAction(QIcon(self.plugin_dir + "/icon/posicional-2.svg"),"Calcular")
        action.triggered.connect(self.posicional.run)
        action.setEnabled(True)
        self.toolbar.addAction(action)
        self.actions.append(action)

        action = self.menuAuxiliar.addAction(QIcon(self.plugin_dir + "/icon/auxiliar-2.svg"),"Gerar arquivo de entrada para GeoPEC desktop")
        action.triggered.connect(self.gerarentrada.run)
        action.setEnabled(True)
        self.toolbar.addAction(action)
        self.actions.append(action)

        action = self.menuAjuda.addAction(QIcon(self.plugin_dir + "/icon/ajuda-sobre.svg"),"Sobre o GeoPEC")
        action.triggered.connect(self.sobre.run)
        action.setEnabled(True)
        self.toolbar.addAction(action)
        self.actions.append(action)

        action = self.menuAjuda.addAction(QIcon(self.plugin_dir + "/icon/ajuda-1.svg"),"Ajuda")
        action.triggered.connect(self.abrir_ajuda)
        action.setEnabled(True)
        self.toolbar.addAction(action)
        self.actions.append(action)


        action = self.menuAjuda.addAction(QIcon(self.plugin_dir + "/icon/ajuda-referencial.svg"),"Referências teóricas")
        action.triggered.connect(self.abrir_referencia)
        action.setEnabled(True)
        self.toolbar.addAction(action)
        self.actions.append(action)


        #self.toolbar.addSeparator()
    
    
    def abrir_ajuda(self):
        
        url = QUrl("http://www.geopec.com.br/")

        # Abra a URL no navegador padrão
        QDesktopServices.openUrl(url)
        
    def abrir_referencia(self):
        
        url = QUrl("https://www.scielo.br/j/bcg/a/VksYzhPKpNbf54hQ5JQfnnL/?lang=pt")

        # Abra a URL no navegador padrão
        QDesktopServices.openUrl(url)
        
    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&GeoPEC'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        #if self.first_start == True:
        #    self.first_start = False
        #    self.dlg = pecDialog()

        # show the dialog
        #self.dlg.show()
        # Run the dialog event loop
        #result = self.dlg.exec_()
        # See if OK was pressed
        #if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
        pass
