# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GeoPEC
                A QGIS plugin [Generated by Plugin Builder]

autores: Afonso P. Santos; João Vítor A. Gonçalves; Luis Philippe Ventura

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""


from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication, QVariant, Qt, QDate , QTimer
from PyQt5.QtGui import QIcon, QFont, QFontMetrics, QColor, QBrush, QPixmap, QPalette, QWindowStateChangeEvent, QImage
from PyQt5.QtWidgets import QAction, QFileDialog, QMessageBox, QApplication, QMainWindow, QTableWidgetItem, QComboBox, QAbstractItemView, QRadioButton, QVBoxLayout, QWidget
from qgis.core import *
from osgeo import gdal
# Initialize Qt resources from file resources.py
from ..resources import *
#from .variancia_circular import *
import processing
# Import the code for the dialog
from ..gui.posicional_dialog import posicionalDialog
import os.path
import math
from datetime import datetime


#Bibliotecas para fazer o gráfico
#Paara colocar a imagem na memória
import io
#################
from qgis.gui import QgsMapCanvas, QgsLayerTreeMapCanvasBridge # essa é para atualizar o comboBox quando colocar uma layer no projeto
import matplotlib.pyplot as plt
from matplotlib.backends.backend_qt5agg import FigureCanvasQTAgg as FigureCanvas
from qgis.PyQt.QtWidgets import QAction, QMainWindow, QVBoxLayout, QLabel,  QGraphicsView, QSizePolicy
import numpy as np 

from PyQt5.QtWidgets import QVBoxLayout, QWidget
from PyQt5 import QtGui


####################
#Para mexer com as imagens
from PIL import Image

#########################
# Para fazer o gráfico

import matplotlib.pyplot as plt
# Fazendo o retângulo do boxplot manualmente - LUIS
from matplotlib.patches import Rectangle

import numpy as np
from io import BytesIO
import tempfile
import os

#Importando as funções usadas
from ..functions.normas_pec import *
from ..functions.relatorio import *


class posicional:
    """QGIS Plugin Implementation."""
    
    #Declarando as variáveis de controle do processamento, variáveis a nivel de classe
    def __init__(self, iface):
    #################################     
        # Pega o caminho do diretório onde o arquivo atual está localizado
        current_dir = os.path.dirname(os.path.abspath(__file__))
        # Sobe um nível na hierarquia de diretórios para chegar à pasta principal
        self.plugin_dir = os.path.dirname(current_dir)
        
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(self.plugin_dir,'i18n','pec_{}.qm'.format(locale))
        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)
    #################################
        
        #Configurando métodos para não aparecer janelas de erro mais de uma vez
        self.first_start = True
        self.connections_made = False  
        
        #icon = QIcon(self.plugin_dir + "/icon/geopec.png")    
        # Save reference to the QGIS interface
        self.iface = iface
        
        self.dlg = posicionalDialog()
        
        # Criando atributos de controle de processamento
        
        self.processamento = True
        self.c_nome_teste = 'inicia1'
        self.c_nome_referencia = 'inicia2'
        self.op_norma = 0
        self.pontos_excluir = set()
        self.data_geral = {}
        
       #Criando um dicionário para controlar a visualização das janelas de gráfico
            
        self.graphs_open = {
                'dispersao_2d': False,
                'dispersao_z': False,
                'tendencia_en': False,
                'tendencia_z': False,
                'boxplot_2D': False,
                'boxplot_Z': False,
                '3sigma_2D': False,
                '3sigma_Z': False
            }
        
        #Criando um atributo de verificação de memória para as imagens do gráfico
        self.bytes_io_objects = []
        
        #Ativando métodos de atualização dos combo_Box quando uma layer é adicionada
        #ou removida do projeto
        QgsProject.instance().layersAdded.connect(self.carregaVetor)
        QgsProject.instance().layersRemoved.connect(self.carregaVetor)
            
    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('tamanhoamostral', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        pass
        
    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        self.iface.mainWindow().menuBar().removeAction(self.menu.menuAction())
        del self.menu
        # remove the toolbar
        del self.toolbar
        
    def carregaVetor(self):
        """Preenche os combobox com as layers vetoriais do tipo ponto"""
        #limpando os comboBox
        self.dlg.comboBox.clear()
        self.dlg.comboBox_2.clear()
        
        #obtendo as instâncias do projeto
        project = QgsProject.instance()
        
        #obtendo as layers
        layers = project.mapLayers()
        
        #obtendo somente as layers de pontos
        point_layers = []
        
        for layer in layers.values():
        
            if layer.type() == QgsMapLayerType.VectorLayer and layer.geometryType() == QgsWkbTypes.PointGeometry:
                point_layers.append(layer)
        
        # Obtendo os nomes das camadas de pontos
        point_layer_names = [layer.name() for layer in point_layers]

        # Preenchendo  os ComboBoxes
        self.dlg.comboBox.addItems(point_layer_names)
        self.dlg.comboBox_2.addItems(point_layer_names)    

    def carregaCamada(self):
        """execução do botão para abrir uma layer. Será aberto uma janela de diálogo e a layer escolhida será adicionada ao projeto e ao combobox"""
        camada_abrir = str(QFileDialog.getOpenFileName(caption = "Escolha a camada",filter = "Shapefiles (*.shp)")[0])
    
        if camada_abrir:
    
            # Carregar a camada
            layer = QgsVectorLayer(camada_abrir, str.split(os.path.basename(camada_abrir), ".") [0], "ogr")
        
            # Verificando se a camada possui geometria de ponto
            if layer.geometryType() == QgsWkbTypes.PointGeometry:
                # Adicionar a camada ao projeto
                QgsProject.instance().addMapLayer(layer)
                self.carregaVetor()
            else:
            # Informar ao usuário que a camada não possui geometria de ponto
                QMessageBox.warning(self.dlg, "Erro", "A camada selecionada não possui geometria de ponto.")
                pass

    def carregaCamada(self):
        """execução do botão para abrir uma layer. Será aberto uma janela de diálogo e a layer escolhida será adicionada ao projeto e ao combobox"""
        camada_abrir = str(QFileDialog.getOpenFileName(caption = "Escolha a camada",filter = "Shapefiles (*.shp)")[0])
    
        if camada_abrir:
    
            # Carregar a camada
            layer = QgsVectorLayer(camada_abrir, str.split(os.path.basename(camada_abrir), ".") [0], "ogr")
        
            # Verificando se a camada possui geometria de ponto
            if layer.geometryType() == QgsWkbTypes.PointGeometry:
                # Adicionar a camada ao projeto
                QgsProject.instance().addMapLayer(layer)
                self.carregaVetor()
            else:
            # Informar ao usuário que a camada não possui geometria de ponto
                QMessageBox.warning(self.dlg, "Erro", "A camada selecionada não possui geometria de ponto.")
                pass
    
    def show_messagebox_erro(self, tipo, mensagem):
        """Método para exibir um messagebox informando erro ou sucesso em alguma ação do programa"""    
        
        
        
        if  (tipo == 'erro'): #Mensagem do tipo erro
        
            # Crie uma instância do QMessageBox
            msg_box = QMessageBox()

            # Defina o ícone da janela
            msg_box.setWindowIcon(QIcon(self.plugin_dir + "/icon/geopec.png"))  

            # Configure a mensagem de erro
            msg_box.setIcon(QMessageBox.Critical)
            msg_box.setWindowTitle('Erro')
            msg_box.setText(mensagem)

            # Exibindo a mensagem
            msg_box.exec_()
        
            
        else: # tipo igual sucesso
            
            # Criando uma instância do QMessageBox
            msg_box = QMessageBox()

            # Definindo o ícone da janela
            msg_box.setWindowIcon(QIcon(self.plugin_dir + "/icon/geopec.png"))  

            # Configurando a mensagem de sucesso
            msg_box.setIcon(QMessageBox.Information)
            msg_box.setWindowTitle('Sucesso')
            msg_box.setText(mensagem)

            # Exibindo a mensagem
            msg_box.exec_()
         
    def obt_data(self):
        """Método que extrai os dados das camadas de teste e de referência, faz a junção espacial e gera uma estrutura para salvar os dados necessários"""
        
        num_layers = self.dlg.comboBox.count()
        
        #Verificando se tem pelo menos 2 layers no comboBox
        if num_layers <=1:
            return False, 1
        
        #Obtendo o nome das camadas de teste e de referência
        nome_pt_teste = self.dlg.comboBox.currentText()
        nome_pt_ref = self.dlg.comboBox_2.currentText()
        
        #Obtendo as camadas pelo nome
        pt_teste = QgsProject.instance().mapLayersByName(nome_pt_teste)[0]
        pt_ref = QgsProject.instance().mapLayersByName(nome_pt_ref)[0]
        
        #Criando cópias temporárias das camadas de teste e de referência
        
        self.pt_teste = pt_teste.clone()
        self.pt_ref = pt_ref.clone()
        
        # Verificando se as camadas têm o mesmo SRC
        crs_teste = self.pt_teste.crs()
        crs_ref = self.pt_ref.crs()
        if not crs_teste == crs_ref:
            return False, 2
        
        # Verificando se as camadas tem pelo menos 3 pontos, pois muitas estátisticas necessitam
        # de pelo menos 3 pontos
        num_pontos_teste = self.pt_teste.featureCount()
        num_pontos_ref = self.pt_ref.featureCount()
        if (num_pontos_teste < 3) or (num_pontos_ref < 3) :
            return False, 3
            
        # Removendo todos os atributos das camadas temporárias
        fields_test_names = [field.name() for field in self.pt_teste.fields()]
        self.pt_teste.dataProvider().deleteAttributes([self.pt_teste.fields().indexFromName(name) for name in fields_test_names])

        fields_ref_names = [field.name() for field in self.pt_ref.fields()]
        self.pt_ref.dataProvider().deleteAttributes([self.pt_ref.fields().indexFromName(name) for name in fields_ref_names])

  
        # Adicionando os novos atributos às camadas temporárias
        fields_test = [
            QgsField("IDt", QVariant.Int),
            QgsField("Xxtest", QVariant.Double),
            QgsField("Yytest", QVariant.Double),
            QgsField("Zztest", QVariant.Double),
        ]
        
        fields_ref = [
            QgsField("IDr", QVariant.Int),
            QgsField("Xxref", QVariant.Double),
            QgsField("Yyref", QVariant.Double),
            QgsField("Zzref", QVariant.Double),
        ]
        
        self.pt_teste.dataProvider().addAttributes(fields_test)
        self.pt_ref.dataProvider().addAttributes(fields_ref)
    
        # Atualizando os campos das camadas
        self.pt_teste.updateFields()
        self.pt_ref.updateFields()    

        
        # calculando os campos X Y Z
        # =======================================================================
        
        self.pt_teste.startEditing()
        numb = 1
        for ft in self.pt_teste.getFeatures():
            self.pt_teste.changeAttributeValue(ft.id(), self.pt_teste.fields().indexFromName("IDt"), numb)
            self.pt_teste.changeAttributeValue(ft.id(), self.pt_teste.fields().indexFromName("Xxtest"), ft.geometry().asPoint().x())
            self.pt_teste.changeAttributeValue(ft.id(), self.pt_teste.fields().indexFromName("Yytest"), ft.geometry().asPoint().y())
            self.pt_teste.changeAttributeValue(ft.id(), self.pt_teste.fields().indexFromName("Zztest"), ft.geometry().vertexAt(0).z())
            
            numb += 1
        self.pt_teste.commitChanges()

        self.pt_ref.startEditing()

        nn = 1
        for fr in self.pt_ref.getFeatures():
            self.pt_ref.changeAttributeValue(fr.id(), self.pt_ref.fields().indexFromName("IDr"), nn)
            self.pt_ref.changeAttributeValue(fr.id(), self.pt_ref.fields().indexFromName("Xxref"), fr.geometry().asPoint().x())
            self.pt_ref.changeAttributeValue(fr.id(), self.pt_ref.fields().indexFromName("Yyref"), fr.geometry().asPoint().y())
            self.pt_ref.changeAttributeValue(fr.id(), self.pt_ref.fields().indexFromName("Zzref"), fr.geometry().vertexAt(0).z())
            
            nn += 1
        self.pt_ref.commitChanges()
        
        # Realizando o spatial join para juntar os dados de teste e de referência
        # Considera pontos homólogos os pontos mais próximos entre o conjunto dos dados de teste e de referência
        # OBS: Caso o produto possua um efeito sistemático de grande magnitude, esta metodologia de definição de pontos homólogos não será eficiente
        algresult  = processing.run("qgis:joinbynearest", {
                'DISCARD_NONMATCHING' : True, 
                'FIELDS_TO_COPY' : [], 
                'INPUT' : self.pt_teste, 
                'INPUT_2' : self.pt_ref, 
                'MAX_DISTANCE' : None, 
                'NEIGHBORS' : 1, 
                'OUTPUT' : 'memory:JOIN', 
                'PREFIX' : '' })
                
        self.join = algresult['OUTPUT']
        
        # Manipulando os dados do spatial join para gerar uma estrutura com os dados necessários para realizar os cálculos
        data = {}
   
        for f in self.join.getFeatures(): 
            
            dict_valores = { "IDt" : f["IDt"],
                            "Xxtest": f["Xxtest"],
                            "Yytest" : f["Yytest"],
                            "Zztest" : f["Zztest"],
                            "Xxref" : f["Xxref"],
                            "Yyref" : f["Yyref"],
                            "Zzref" : f["Zzref"]}
            
            for pt in dict_valores.keys():
                
                #Verificando se existem dados nan ou NULL, caso existam, são substituídos por 0
                
                comp = str(dict_valores[pt])
                
                if  (comp == 'nan' or comp == 'NULL'):
                    
                    dict_valores[pt] = 0
                
                else:
                    
                    pass
            
            
            idd, xt, yt, zt, xr, yr, zr = dict_valores["IDt"], dict_valores["Xxtest"], dict_valores["Yytest"], dict_valores["Zztest"], dict_valores["Xxref"], dict_valores["Yyref"], dict_valores["Zzref"]
                            
            data[str(idd)] = {'Xtest': xt, 'Ytest': yt, 'Ztest': zt, 'Xref': xr, 'Yref': yr, 'Zref': zr}
                
                
        #Apagando as camadas temporárias e o join
        del self.join 
        del self.pt_teste
        del self.pt_ref   
                
        
        #Retornando os dados, e o código 4, de sucesso        
        return data, 4
    
    def atualiza_imagem(self, imagem):
        """ Método que atualiza a imagem da tendência, a partir da estatistica espacial"""
        """Tem como parâmetro qual imagem deve ser exibida"""
        
        #Caminho das imagens
        caminho_imagens = {
            '1': self.plugin_dir + "/icon/tendencia_1.png",
            '2': self.plugin_dir + "/icon/tendencia_2.png",
            '3': self.plugin_dir + "/icon/tendencia_3.png",
            '4': self.plugin_dir + "/icon/tendencia_4.png",
            '5': self.plugin_dir + "/icon/tendencia_5.png"
        }
        
        #Atualizando a imagem
        caminho_imagem = caminho_imagens[imagem]
        pixmap = QPixmap(caminho_imagem)
        self.dlg.label_86.setPixmap(pixmap)
    
    def showVarCircular(self,op):
        """Este método deixa visível ou invisivel os labels da aba de tendênciia, referentes a variancia circular"""
        """Se op for verdadeiro, exibe os labels, caso seja falso, não exige os labels"""
        
        if op: #Op é verdadeiro, exibe os labels
            
            self.dlg.label_61.setVisible(True)
            self.dlg.label_62.setVisible(True)
            self.dlg.label_63.setVisible(True)
            self.dlg.label_64.setVisible(True)
            self.dlg.label_108.setVisible(True)
            self.dlg.label_109.setVisible(True)
            self.dlg.label_110.setVisible(True)
            self.dlg.label_65.setVisible(True)
            self.dlg.label_111.setVisible(True)
            self.dlg.label_82.setVisible(True)
            self.dlg.label_86.setVisible(True)
            self.dlg.label_84.setVisible(True)
            self.dlg.label_83.setVisible(True)
            self.dlg.label_85.setVisible(True)
            self.dlg.label_67.setVisible(True)
            self.dlg.label_112.setVisible(True)
        
        else: #Op é falso, não exibe os labels
        
            self.dlg.label_61.setVisible(False)
            self.dlg.label_62.setVisible(False)
            self.dlg.label_63.setVisible(False)
            self.dlg.label_64.setVisible(False)
            self.dlg.label_108.setVisible(False)
            self.dlg.label_109.setVisible(False)
            self.dlg.label_110.setVisible(False)
            self.dlg.label_65.setVisible(False)
            self.dlg.label_111.setVisible(False)
            self.dlg.label_82.setVisible(False)
            self.dlg.label_86.setVisible(False)
            self.dlg.label_84.setVisible(False)
            self.dlg.label_83.setVisible(False)
            self.dlg.label_85.setVisible(False)
            self.dlg.label_67.setVisible(False)
            self.dlg.label_112.setVisible(False)
                     
    def tendencia(self, dx, dy, dz):
        """Este método processa as atualizações da aba de tendência, como cálculos e atualizações da interface gráfica """
        """ Tem como parâmetros, os dicionários de discrepâncias dx, dy e dx"""
        
        #Obtendo a opção de processamento
        op = self.op_norma 
        
        #Obtendo o nível de confiança do teste T de stdent e adicionando a uma variável geral
            
        niv_conf = self.dlg.comboBox_13.currentIndex()
        self.niv_conf_t =niv_conf
        
        #Aplicando o teste T de student utilizando uma função da biblioteca externa
        
        result_x, t_calc_x, t_tabelado_x, teste_x = fTdeStudent(dx,niv_conf)
        result_y, t_calc_y, t_tabelado_y, teste_y = fTdeStudent(dy,niv_conf)
        result_z, t_calc_z, t_tabelado_z, teste_z = fTdeStudent(dz,niv_conf)
        
        #Obtendo o nível de confiança para alterar os labels
        
        if niv_conf ==0:
        
            nc_label = '75%'
    
        elif niv_conf ==1:
            
            nc_label = '90%'

        elif niv_conf ==2:
            
            nc_label = '95%'
            
        elif niv_conf ==3:
            
            nc_label = '97,5%'

        else:
            
            nc_label = '99%'
            
        
        #Atualizando os labels da aba de tendência
        
        if (op==0) or (op==3) or (op==6) or (op==7): #2D
            
            #Limpando a tabela do teste t
            self.dlg.tableWidget.clear()
            
            # Definindo os cabeçalhos das colunas
            headers = ["t tabelado", "t calculado", "Resultado"]
            self.dlg.tableWidget.setColumnCount(3)
            self.dlg.tableWidget.setHorizontalHeaderLabels(headers)
            
            #Definindo um estilo para os cabeçalhos da tabela (em negrito)
            header_font = QFont()
            header_font.setBold(True)
            self.dlg.tableWidget.horizontalHeader().setFont(header_font)
            
            # Definindo os cabeçalhos das linhas
            headers = ["di(X)", "di(Y)"]
            self.dlg.tableWidget.setRowCount(2)
            self.dlg.tableWidget.setVerticalHeaderLabels(headers)
            
            #Definindo um estilo para os cabeçalhos da tabela (em negrito)
            header_font = QFont()
            header_font.setBold(True)
            self.dlg.tableWidget.verticalHeader().setFont(header_font)
            
            #Definindo o tamanho da coluna de resultado
         
            self.dlg.tableWidget.setGeometry(20, 50, 295, 80)
            self.dlg.tableWidget.setColumnWidth(2, 100) # define o tamanho da coluna
            
            #Preenchendo a tabela de resultados
            self.dlg.tableWidget.setItem(0, 0, QTableWidgetItem(f"{t_tabelado_x:.3f}"))
            self.dlg.tableWidget.setItem(0, 1, QTableWidgetItem(f"{t_calc_x:.3f}"))
            self.dlg.tableWidget.setItem(0, 2, QTableWidgetItem(result_x))
            
            self.dlg.tableWidget.setItem(1, 0, QTableWidgetItem(f"{t_tabelado_y:.3f}"))
            self.dlg.tableWidget.setItem(1, 1, QTableWidgetItem(f"{t_calc_y:.3f}"))
            self.dlg.tableWidget.setItem(1, 2, QTableWidgetItem(result_y))
                                             
            #Caso não seja para processar a ANM, os labels de variancia circular ficam visiveis
            
            if  not((op == 7) or (op == 8) or (op == 9)): #Processamento de outras normas, sem ser da ANM
                       
                #Deixando os labels da variancia circular visiveis
                self.showVarCircular(True)
                soma_seno, soma_cosseno, media_dir, var_circular = fMedia_Dir_e_Var_Circ(dx,dy)
                
                self.dlg.label_108.setText(f"{soma_seno:.3f}")
                self.dlg.label_109.setText(f"{soma_cosseno:.3f}")
                self.dlg.label_110.setText(f"{media_dir:.2f}º")
                self.dlg.label_111.setText(f"{var_circular:.3f}")
                
                #Atualizando a imagem da variancia circular
                if var_circular <= 0.2:
                    
                    imagem =  '1'
                
                elif var_circular <= 0.4:
                    
                    imagem =  '2'
                
                elif var_circular <= 0.6:
                
                    imagem =  '3'
                
                elif var_circular <= 0.8:
                    
                    imagem =  '4'
                
                else:
                
                    imagem =  '5'
                
                self.atualiza_imagem(imagem)
                
                #Mudando o resultado final para a variância circular
            
                if var_circular >= 0.5:
                
                    self.dlg.label_112.setText('Não Tendencioso')
            
                else:
                
                    self.dlg.label_112.setText('Tendencioso')
                
                #Alterando a tabela do relatório
                
                self.table_med_relatorio = [ soma_seno, soma_cosseno, media_dir, var_circular, self.dlg.label_112.text()]
            
            #Caso o processamento for da ANM, não exibe os labels de variancia circular
            
            else:
                
                self.showVarCircular(False)
                self.table_med_relatorio = [ 0, 0, 0, 0, 0]
            
            #Mudando o resultado final para o teste t de student 
            
            #Deixando os labels visiveis, mudando a posição dos labels e o conteúdo dos labels
            
            self.dlg.label_60.setVisible(True)
            self.dlg.label_120.setVisible(True)
            
            self.dlg.label_118.setVisible(False)
            self.dlg.label_129.setVisible(False)
            
            #Alterando o nível de confiança do teste
            
            self.dlg.label_183.setGeometry(20,144,151,16)
            self.dlg.label_183.setText(f"Nível de confiança: {nc_label}")
            
            #Mudando a posição do label
            self.dlg.label_120.setGeometry(85, 240, 121, 16)
            
            #Mudando o conteúdo do label
            self.dlg.label_60.setText('Resultado:')
            
            #Mudando o resultado final
            
            #Entra no if se o usuário ter escolhido levar em conta a normalidade para o teste t de student
            
            if self.dlg.radioButton_4.isChecked():
                
                #Entra no if se as discrepâncias forem normais estatisticamente
                if self.normalidade_2d:
                    
                    if (result_x == 'Não há tendência') and (result_y == 'Não há tendência') :
                        
                        self.dlg.label_120.setText('Não Tendencioso')
                        #Não Tendencioso
                    
                    else:
                        
                        self.dlg.label_120.setText('Tendencioso')
                        #Tendencioso
                
                #Entra no else se as discrepâncias não forem normais estatisticamente                
                else:
                    
                    self.dlg.label_120.setText('Inconclusivo')
                    #inconclusivo
                
            else: # Cai no else se o usuário não ter escolhido levar em conta a normalidade
                
                if (result_x == 'Não há tendência') and (result_y == 'Não há tendência'):
                        
                    self.dlg.label_120.setText('Não Tendencioso')
                        #Não Tendencioso
                    
                else:
                        
                    self.dlg.label_120.setText('Tendencioso')
                        #Tendencioso
                                    
            
            #Atualizando as variáveis de tendência do relatório
            
            #Atualizando a variável 2D
            
            if not((op == 7) or (op == 8) or (op == 9)): #Processamento de outras normas
            
                if (self.dlg.label_112.text() == 'Não Tendencioso') and (self.dlg.label_120.text() == 'Não Tendencioso'):
                
                    self.var_tendencia_2D_relatorio = 'Não Tendencioso'
                
                elif (self.dlg.label_112.text() == 'Não Tendencioso') and (self.dlg.label_120.text() == 'Inconclusivo'):
                    
                    self.var_tendencia_2D_relatorio = 'Não Tendencioso'
                
                else:
                
                    self.var_tendencia_2D_relatorio = 'existe tendência'
                
                self.var_tendencia_Z_relatorio = 'nao definido'
            
            else: #ANM
                
                if (self.dlg.label_120.text() == 'Não Tendencioso'):
            
                    self.var_tendencia_2D_relatorio = 'Não Tendencioso'
            
                elif (self.dlg.label_120.text() == 'Inconclusivo'):
                
                    self.var_tendencia_2D_relatorio = 'inconclusivo'
            
                else:
            
                    self.var_tendencia_2D_relatorio = 'existe tendência'
                    
                self.var_tendencia_Z_relatorio = 'nao definido'
            
            
            #Atualizando as variáveis da tabela
            
            self.table_t_relatorio = [ [t_tabelado_x, t_calc_x, result_x],
                                       [t_tabelado_y, t_calc_y, result_y]
                                     ]
            
            
                
        elif (op==1) or (op==4) or (op==8): #z
            
            #Limpando a tabela do teste t
            self.dlg.tableWidget.clear()
            
            # Definindo os cabeçalhos das colunas
            headers = ["t tabelado", "t calculado", "Resultado"]
            self.dlg.tableWidget.setColumnCount(3)
            self.dlg.tableWidget.setHorizontalHeaderLabels(headers)
            
            #Definindo um estilo para os cabeçalhos da tabela (em negrito)
            header_font = QFont()
            header_font.setBold(True)
            self.dlg.tableWidget.horizontalHeader().setFont(header_font)
            
            # Definindo os cabeçalhos das linhas
            headers = ["di(Z)"]
            self.dlg.tableWidget.setRowCount(1)
            self.dlg.tableWidget.setVerticalHeaderLabels(headers)
            
            #Definindo um estilo para os cabeçalhos da tabela (em negrito)
            header_font = QFont()
            header_font.setBold(True)
            self.dlg.tableWidget.verticalHeader().setFont(header_font)
            
            #Definindo o tamanho da coluna de resultado
        
            self.dlg.tableWidget.setGeometry(20, 50, 295, 50)
            self.dlg.tableWidget.setColumnWidth(2, 100) # define o tamanho da coluna
            
            #Preenchendo a tabela de resultados
            self.dlg.tableWidget.setItem(0, 0, QTableWidgetItem(f"{t_tabelado_z:.3f}"))
            self.dlg.tableWidget.setItem(0, 1, QTableWidgetItem(f"{t_calc_z:.3f}"))
            self.dlg.tableWidget.setItem(0, 2, QTableWidgetItem(result_z))
            
            self.showVarCircular(False)
            
            #Mudando o resultado final para o teste t de student
            
            #Deixando os labels visiveis, mudando a posição dos labels e o conteúdo dos labels
            
            self.dlg.label_60.setVisible(True)
            self.dlg.label_120.setVisible(True)
            
            self.dlg.label_118.setVisible(False)
            self.dlg.label_129.setVisible(False)
            
            #Alterando o nível de confiança do teste
            
            self.dlg.label_183.setGeometry(20,114,151,16)
            self.dlg.label_183.setText(f"Nível de confiança: {nc_label}")
            
            #Mudando a posição do label
            self.dlg.label_120.setGeometry(85, 240, 121, 16)
            
            #Mudando o conteúdo do label
            self.dlg.label_60.setText('Resultado:')
            
            #Mudando o resultado final
            
            #Entra no if se o usuário ter escolhido levar em conta a normalidade para o teste t de student
            if self.dlg.radioButton_4.isChecked():
                
                #Entra no if se as discrepâncias em Z forem normais estatisticamente
                
                if self.normalidade_z:
                    
                    if (result_z == 'Não há tendência'):
                        
                        self.dlg.label_120.setText('Não Tendencioso')
                        #Não Tendencioso
                    
                    else:
                        
                        self.dlg.label_120.setText('Tendencioso')
                        #Tendencioso
                
                #Entra no else se as discrepâncias em Z não forem normais estatisticamente
               
                else: 
                    
                    self.dlg.label_120.setText('Inconclusivo')
                    #inconclusivo
            
            # Cai no else se o usuário não ter escolhido levar em conta a normalidade
            else:
                
                if (result_z == 'Não há tendência'):
                        
                    self.dlg.label_120.setText('Não Tendencioso')
                        #Não Tendencioso
                    
                else:
                        
                    self.dlg.label_120.setText('Tendencioso')
                        #Tendencioso
            
            #Atualizando as variáveis de tendência do relatório
               
            #Atualizando a variável Z
            
            if (self.dlg.label_120.text() == 'Não Tendencioso'):
            
                self.var_tendencia_Z_relatorio = 'Não Tendencioso'
            
            elif (self.dlg.label_120.text() == 'Inconclusivo'):
                
                self.var_tendencia_Z_relatorio = 'inconclusivo'
            
            else:
            
                self.var_tendencia_Z_relatorio = 'existe tendência'
            
            self.var_tendencia_2D_relatorio = 'nao definido'
            
            #Atualizando as variáveis da tabela
            
            self.table_t_relatorio = [t_tabelado_z, t_calc_z, result_z]
                                     
            self.table_med_relatorio = [ 'nao definido', 'nao definido', 'nao definido', 'nao definido', 'nao definido']
    

        else: #2D e Z
            
            #Limpando a tabela do teste t
            self.dlg.tableWidget.clear()
            
            # Definindo os cabeçalhos das colunas
            headers = ["t tabelado", "t calculado", "Resultado"]
            self.dlg.tableWidget.setColumnCount(3)
            self.dlg.tableWidget.setHorizontalHeaderLabels(headers)
            
            #Definindo um estilo para os cabeçalhos da tabela (em negrito)
            header_font = QFont()
            header_font.setBold(True)
            self.dlg.tableWidget.horizontalHeader().setFont(header_font)
            
            # Definindo os cabeçalhos das linhas
            headers = ["di(X)", "di(Y)", "di(Z)"]
            self.dlg.tableWidget.setRowCount(3)
            self.dlg.tableWidget.setVerticalHeaderLabels(headers)
            
            #Definindo um estilo para os cabeçalhos da tabela (em negrito)
            header_font = QFont()
            header_font.setBold(True)
            self.dlg.tableWidget.verticalHeader().setFont(header_font)
            
            #Definindo o tamanho da coluna de resultado

            self.dlg.tableWidget.setGeometry(20, 50, 295, 106)
            self.dlg.tableWidget.setColumnWidth(2, 100) # define o tamanho da coluna
            
            #Preenchendo a tabela de resultados
            self.dlg.tableWidget.setItem(0, 0, QTableWidgetItem(f"{t_tabelado_x:.3f}"))
            self.dlg.tableWidget.setItem(0, 1, QTableWidgetItem(f"{t_calc_x:.3f}"))
            self.dlg.tableWidget.setItem(0, 2, QTableWidgetItem(result_x))
            
            self.dlg.tableWidget.setItem(1, 0, QTableWidgetItem(f"{t_tabelado_y:.3f}"))
            self.dlg.tableWidget.setItem(1, 1, QTableWidgetItem(f"{t_calc_y:.3f}"))
            self.dlg.tableWidget.setItem(1, 2, QTableWidgetItem(result_y))
            
            self.dlg.tableWidget.setItem(2, 0, QTableWidgetItem(f"{t_tabelado_z:.3f}"))
            self.dlg.tableWidget.setItem(2, 1, QTableWidgetItem(f"{t_calc_z:.3f}"))
            self.dlg.tableWidget.setItem(2, 2, QTableWidgetItem(result_z))
            
            if  not((op == 7) or (op == 8) or (op == 9)): #Processamento de outras normas
            
                #Deixando os labels da variancia circular visiveis
                self.showVarCircular(True)
                
                #Calculando as estatisticas espaciais
                
                soma_seno, soma_cosseno, media_dir, var_circular = fMedia_Dir_e_Var_Circ(dx,dy)
                
                #Alterando os labels de variancia circular
                self.dlg.label_108.setText(f"{soma_seno:.3f}")
                self.dlg.label_109.setText(f"{soma_cosseno:.3f}")
                self.dlg.label_110.setText(f"{media_dir:.2f}º")
                self.dlg.label_111.setText(f"{var_circular:.3f}")
                
                #Atualizando a imagem da variancia circular
                if var_circular <= 0.2:
                    
                    imagem =  '1'
                
                elif var_circular <= 0.4:
                    
                    imagem =  '2'
                
                elif var_circular <= 0.6:
                
                    imagem =  '3'
                
                elif var_circular <= 0.8:
                    
                    imagem =  '4'
                
                else:
                
                    imagem =  '5'
                
                self.atualiza_imagem(imagem)
                
                #Mudando o resultado final para a variância circular
                
                if var_circular >= 0.5:
                    
                    self.dlg.label_112.setText('Não Tendencioso')
                
                else:
                    
                    self.dlg.label_112.setText('Tendencioso')
                
                self.table_med_relatorio = [ soma_seno, soma_cosseno, media_dir, var_circular, self.dlg.label_112.text()]
                
            else: #Processamento da ANM
                
                self.showVarCircular(False)
                self.table_med_relatorio = [ 0, 0, 0, 0, 0]
                
            #Mudando o resultado final para os testes t de student, caso 2d
            
            #Deixando os labels visiveis, mudando a posição dos labels e o conteúdo dos labels
            
            self.dlg.label_60.setVisible(True)
            self.dlg.label_120.setVisible(True)
            
            #Alterando o nível de confiança do teste
            
            self.dlg.label_183.setGeometry(20,170,151,16)
            self.dlg.label_183.setText(f"Nível de confiança: {nc_label}")
            
            #Mudando a posição do label
            self.dlg.label_120.setGeometry(160, 240, 121, 16)
            
            #Mudando o conteúdo do label
            self.dlg.label_60.setText('Resultado Planimetria:')
            
            #Mudando o resultado final
            
            #Entra no if se o usuário ter escolhido levar em conta a normalidade para o teste t de student
            if self.dlg.radioButton_4.isChecked():
                
                #Entra no if se as discrepâncias forem normais estatisticamente
                if self.normalidade_2d:
                    
                    if (result_x == 'Não há tendência') and (result_y == 'Não há tendência'):
                        
                        self.dlg.label_120.setText('Não Tendencioso')
                        #Não Tendencioso
                    
                    else:
                        
                        self.dlg.label_120.setText('Tendencioso')
                        #Tendencioso 
                
                #Entra no else se as discrepâncias não forem normais estatisticamente
                else:
                    
                    self.dlg.label_120.setText('Inconclusivo')
                    #inconclusivo
              
            #Cai no else se o usuário não ter escolhido levar em conta a normalidade  
            else:
                
                if (result_x == 'Não há tendência') and (result_y == 'Não há tendência'):
                        
                    self.dlg.label_120.setText('Não Tendencioso')
                        #Não Tendencioso
                    
                else:
                        
                    self.dlg.label_120.setText('Tendencioso')
                        #Tendencioso               
            
            #Mudando o resultado final para o teste t de student da altimetria
            
            self.dlg.label_118.setVisible(True)
            self.dlg.label_129.setVisible(True)

            #Mudando o conteúdo do label
            self.dlg.label_118.setText('Resultado Altimetria:')
            
            #Mudando o resultado final
            
            #Entra no if se o usuário ter escolhido levar em conta a normalidade para o teste t de student
            if self.dlg.radioButton_4.isChecked():
                
                #Entra no if se as discrepâncias forem normais estatisticamente
                if self.normalidade_z:
                    
                    if (result_z == 'Não há tendência'):
                        
                        self.dlg.label_129.setText('Não Tendencioso')
                        #Não Tendencioso
                    
                    else:
                        
                        self.dlg.label_129.setText('Tendencioso')
                        #Tendencioso
                
                #Entra no else se as discrepâncias não forem normais estatisticamente                
                else:
                    
                    self.dlg.label_129.setText('Inconclusivo')
                    #inconclusivo
             
            #Cai no else se o usuário não ter escolhido levar em conta a normalidade   
            else:
                
                if (result_z == 'Não há tendência'):
                        
                    self.dlg.label_129.setText('Não Tendencioso')
                        #Não Tendencioso
                    
                else:
                        
                    self.dlg.label_129.setText('Tendencioso')
                        #Tendencioso
            
            
            #Atualizando as variáveis de tendência do relatório
            
            #Atualizando a variável 2D
            
            if  not((op == 7) or (op == 8) or (op == 9)): #Processamento de outras normas
            
                if (self.dlg.label_112.text() == 'Não Tendencioso') and (self.dlg.label_120.text() == 'Não Tendencioso'):
                
                    self.var_tendencia_2D_relatorio = 'Não Tendencioso'
                
                elif (self.dlg.label_112.text() == 'Não Tendencioso') and (self.dlg.label_120.text() == 'Inconclusivo'):
                    
                    self.var_tendencia_2D_relatorio = 'Não Tendencioso'
                
                else:
                
                    self.var_tendencia_2D_relatorio = 'existe tendência'
            
            else: #ANM
                
                if (self.dlg.label_120.text() == 'Não Tendencioso'):
            
                    self.var_tendencia_2D_relatorio = 'Não Tendencioso'
            
                elif (self.dlg.label_120.text() == 'Inconclusivo'):
                
                    self.var_tendencia_2D_relatorio = 'inconclusivo'
            
                else:
            
                    self.var_tendencia_2D_relatorio = 'existe tendência'
                
            #Atualizando a variável Z
            
            if (self.dlg.label_129.text() == 'Não Tendencioso'):
            
                self.var_tendencia_Z_relatorio = 'Não Tendencioso'
            
            elif (self.dlg.label_129.text() == 'Inconclusivo'):
                
                self.var_tendencia_Z_relatorio = 'inconclusivo'
            
            else:
            
                self.var_tendencia_Z_relatorio = 'existe tendência'    
            
            #Atualizando as variáveis da tabela
            
            self.table_t_relatorio = [ [t_tabelado_x, t_calc_x, result_x],
                                       [t_tabelado_y, t_calc_y, result_y],
                                       [t_tabelado_z, t_calc_z, result_z]
                                     ]
                         
    def showNormalidade(self, op):
        """Este método habilita ou desabilita os labels da aba de normalidade, conforme a opção de processamento """
        
        if op == 1: #2D
        
        #Labels visiveis
            
            self.dlg.label_50.setVisible(True)
            self.dlg.label_51.setVisible(True)
            self.dlg.label_147.setVisible(True)
            self.dlg.label_55.setVisible(True)
            self.dlg.label_54.setVisible(True)
            self.dlg.label_131.setVisible(True)
            self.dlg.label_58.setVisible(True)
            self.dlg.label_57.setVisible(True)
            self.dlg.label_137.setVisible(True)
            self.dlg.label_100.setVisible(True)
            self.dlg.label_101.setVisible(True)
            self.dlg.label_148.setVisible(True)
            
        #Labels invisiveis
            
            self.dlg.label_52.setVisible(False)
            self.dlg.label_151.setVisible(False)
            self.dlg.label_53.setVisible(False)
            self.dlg.label_149.setVisible(False)
            self.dlg.label_56.setVisible(False)
            self.dlg.label_150.setVisible(False)
            self.dlg.label_102.setVisible(False)
            self.dlg.label_152.setVisible(False)
        
        elif op ==2: #Z
            
            #Labels visiveis
            
            self.dlg.label_50.setVisible(True)
            self.dlg.label_55.setVisible(True)
            self.dlg.label_58.setVisible(True)
            self.dlg.label_100.setVisible(True)
            
            #Labels invisiveis
         
            self.dlg.label_51.setVisible(False)
            self.dlg.label_147.setVisible(False)           
            self.dlg.label_54.setVisible(False)
            self.dlg.label_131.setVisible(False)          
            self.dlg.label_57.setVisible(False)
            self.dlg.label_137.setVisible(False)
            self.dlg.label_101.setVisible(False)
            self.dlg.label_148.setVisible(False)
            self.dlg.label_52.setVisible(False)
            self.dlg.label_151.setVisible(False)
            self.dlg.label_53.setVisible(False)
            self.dlg.label_149.setVisible(False)
            self.dlg.label_56.setVisible(False)
            self.dlg.label_150.setVisible(False)
            self.dlg.label_102.setVisible(False)
            self.dlg.label_152.setVisible(False)
        
        else: #2D e Z 
            
            #Todos os labels visiveis
            
            self.dlg.label_50.setVisible(True)
            self.dlg.label_51.setVisible(True)
            self.dlg.label_147.setVisible(True)
            self.dlg.label_55.setVisible(True)
            self.dlg.label_54.setVisible(True)
            self.dlg.label_131.setVisible(True)
            self.dlg.label_58.setVisible(True)
            self.dlg.label_57.setVisible(True)
            self.dlg.label_137.setVisible(True)
            self.dlg.label_100.setVisible(True)
            self.dlg.label_101.setVisible(True)
            self.dlg.label_148.setVisible(True)           
            self.dlg.label_52.setVisible(True)
            self.dlg.label_151.setVisible(True)
            self.dlg.label_53.setVisible(True)
            self.dlg.label_149.setVisible(True)
            self.dlg.label_56.setVisible(True)
            self.dlg.label_150.setVisible(True)
            self.dlg.label_102.setVisible(True)
            self.dlg.label_152.setVisible(True)
            
    def normalidade(self,dx,dy,dz,d2D,d3D):
        """Este método realiza os processamentos referentes a aba de normalidade, como cálculos e atualização da interface gráfica"""
        """Tem como parâmetros os dicionários com as discrepâncias em x, y, z, 2D e 3D"""
        
        #Obtendo o nível de confiança e atribuindo também a uma variável geral
        niv_conf = self.dlg.comboBox_9.currentIndex()
        self.niv_conf_s = niv_conf
        
        #Obtendo a opção de processamento
        op = self.op_norma
        
        #Obtendo o nível de confiança para alterar os labels
        
        if niv_conf ==0:
        
            nc_label = '75%'
    
        elif niv_conf ==1:
            
            nc_label = '90%'

        elif niv_conf ==2:
            
            nc_label = '95%'
            
        elif niv_conf ==3:
            
            nc_label = '97,5%'

        else:
            
            nc_label = '99%'
            
        #Atualizando a interface gráfica da aba de normalidade
        
        if (op==0) or (op==3) or (op==6) or (op==7): #2D
            
            #Aplicando o teste de normalidade com o uso de uma função da biblioteca de funções
            result_dx = fTesteDeNormalidade(dx, niv_conf)
            result_dy = fTesteDeNormalidade(dy, niv_conf)
            result_d2D = fTesteDeNormalidade(d2D, niv_conf)
            
            #Mudando a visibilidade dos labels
            self.showNormalidade(1)
            
            #Alterando os resultados e os labels referentes
                
            wy = f"Wcalc Y = {result_dy[0]:.3f}"
            wx = f"Wcalc X = {result_dx[0]:.3f}"
            w2d = f"Wcalc 2D = {result_d2D[0]:.3f}"

            self.dlg.label_50.setText(wx)
            self.dlg.label_51.setText(wy)
            self.dlg.label_147.setText(w2d)
     
            py = f"p-value Y = {result_dy[1]:.3f}"
            px = f"p-value X = {result_dx[1]:.3f}"
            p2d = f"p-value 2D = {result_d2D[1]:.3f}"
        
            self.dlg.label_55.setText(px)
            self.dlg.label_54.setText(py)
            self.dlg.label_131.setText(p2d)
            
            self.dlg.label_58.setText('Resultado X:')
            self.dlg.label_57.setText('Resultado Y:')
            self.dlg.label_137.setText('Resultado 2D:')
            
            self.dlg.label_100.setText(result_dx[2])
            self.dlg.label_101.setText(result_dy[2])
            self.dlg.label_148.setText(result_d2D[2])
            
            #Alterando o nível de confiança do teste
            
            self.dlg.label_180.setGeometry(50,140,151,16)
            self.dlg.label_180.setText(f"Nível de confiança: {nc_label}")
            
            # Atualizando o atributo de normalidade
        
            if (result_dy[2] == 'Amostra Normal') and (result_dx[2] == 'Amostra Normal') :
            
                self.normalidade_2d = True
        
            else:
            
                self.normalidade_2d = False
            
            
        elif (op==1) or (op==4) or (op==8): #z
            
            #Aplicando o teste de normalidade com o uso de uma função da biblioteca de funções
            result_dz = fTesteDeNormalidade(dz, niv_conf)
            
            #Mudando a visibilidade dos labels
            self.showNormalidade(2)
            
            #Alterando os resultados e os labels referentes
                
            wz = f"Wcalc Z = {result_dz[0]:.3f}"
        
            self.dlg.label_50.setText(wz)

            pz = f"p-value Z = {result_dz[1]:.3f}"
            self.dlg.label_55.setText(pz)
            
            self.dlg.label_58.setText('Resultado Z:')
            
            self.dlg.label_100.setText(result_dz[2])
            
            #Alterando o nível de confiança do teste
            
            self.dlg.label_180.setGeometry(50,80,151,16)
            self.dlg.label_180.setText(f"Nível de confiança: {nc_label}")
            
            # Atualizando os atributos de normalidade
            
            if (result_dz[2] =='Amostra Normal'):
            
                self.normalidade_z = True
        
            else:
            
                self.normalidade_z = False
        
        else: #2D e Z
            
            #Aplicando o teste de normalidade com o uso de uma função da biblioteca de funções
            
            result_dx = fTesteDeNormalidade(dx, niv_conf)
            result_dy = fTesteDeNormalidade(dy, niv_conf)
            result_dz = fTesteDeNormalidade(dz, niv_conf)
            result_d2D = fTesteDeNormalidade(d2D, niv_conf)
            result_d3D = fTesteDeNormalidade(d2D, niv_conf)
            
            #Mudando a visibilidade dos labels 
            self.showNormalidade(3)
            
            #Alterando os resultados e a visibilidade dos labels
            
            wy = f"Wcalc Y = {result_dy[0]:.3f}"
            wx = f"Wcalc X = {result_dx[0]:.3f}"
            wz = f"Wcalc Z = {result_dz[0]:.3f}"
            w2d = f"Wcalc 2D = {result_d2D[0]:.3f}"
            w3d = f"Wcalc 3D = {result_d3D[0]:.3f}"
        
            self.dlg.label_50.setText(wx)
            self.dlg.label_51.setText(wy)
            self.dlg.label_147.setText(wz)
            self.dlg.label_52.setText(w2d)
            self.dlg.label_151.setText(w3d)
        
            py = f"p-value Y = {result_dy[1]:.3f}"
            px = f"p-value X = {result_dx[1]:.3f}"
            pz = f"p-value Z = {result_dz[1]:.3f}"
            p2d = f"p-value 2D = {result_d2D[1]:.3f}"
            p3d = f"p-value 3D = {result_d3D[1]:.3f}"
        
            self.dlg.label_55.setText(px)
            self.dlg.label_54.setText(py)
            self.dlg.label_131.setText(pz)
            self.dlg.label_53.setText(p2d)
            self.dlg.label_149.setText(p3d)
            
            self.dlg.label_58.setText('Resultado X:')
            self.dlg.label_57.setText('Resultado Y:')
            self.dlg.label_137.setText('Resultado Z:')
        
            self.dlg.label_100.setText(result_dx[2])
            self.dlg.label_101.setText(result_dy[2])
            self.dlg.label_148.setText(result_dz[2])
            self.dlg.label_102.setText(result_d2D[2])
            self.dlg.label_152.setText(result_d3D[2])
            
            #Alterando o nível de confiança do teste
            
            self.dlg.label_180.setGeometry(50,200,151,16)
            self.dlg.label_180.setText(f"Nível de confiança: {nc_label}")
            
            # Atualizando os atributos de normalidade
        
            if (result_dy[2] == 'Amostra Normal') and (result_dx[2] == 'Amostra Normal') :
            
                self.normalidade_2d = True
        
            else:
            
                self.normalidade_2d = False
        
        
            if (result_dz[2] =='Amostra Normal'):
            
                self.normalidade_z = True
        
            else:
            
                self.normalidade_z = False
                
    def atualizaOutlier(self, metodo, dados_2D, dados_Z):
        """Este método atualiza a interface gráfica da aba de outliers"""
        
        #Obtendo a opção de processamento referente as normas e a aba de outlier
        op = self.op_norma
        opcao = self.opcao_outliers_processamento
        
        #Atualizando a interface gráfica
        
        if (op==0) or (op==3) or (op==6) or (op==7): #2D
            
            #Deixando os labels invisiveis
            self.dlg.label_153.setVisible(False)
            self.dlg.label_157.setVisible(False)
            self.dlg.label_159.setVisible(False)
            self.dlg.label_130.setVisible(False)
            
            #Alterando os labels
            
            self.dlg.label_46.setText('Tolerância:')
            self.dlg.label_47.setText('Quantidade de Outliers:')
            
            #Alterando a classe caso o método for 3sigma
            
            if opcao == 0: #3sigma
                
                self.dlg.label_177.setVisible(True)
                self.dlg.label_176.setVisible(True)
                
                classe = self.classe_3sigma
                
                if classe ==0:
                    
                    self.dlg.label_176.setText('Classe A')
    
                elif classe ==1:
        
                    self.dlg.label_176.setText('Classe B')
    
                elif classe == 3:
        
                    self.dlg.label_176.setText('Classe C')
    
                else:
        
                    self.dlg.label_176.setText('Classe D')
            
            else: #Boxplot
                
                self.dlg.label_177.setVisible(False)
                self.dlg.label_176.setVisible(False)
            
            #Mudando a posição dos labels
            self.dlg.label_122.setGeometry(95, 80, 191, 16)
            self.dlg.label_123.setGeometry(157, 110, 81, 16)
            
            #Mudando o resultado e os labels referentes
            
            self.dlg.label_121.setText(metodo)
            self.dlg.label_122.setText(dados_2D[0])
            self.dlg.label_123.setText(dados_2D[1])
        
        elif (op==1) or (op==4) or (op==8): #z
            
            #Deixando os labels invisiveis
            self.dlg.label_153.setVisible(False)
            self.dlg.label_157.setVisible(False)
            self.dlg.label_159.setVisible(False)
            self.dlg.label_130.setVisible(False)
            
            #Alterando os labels
            
            #Alterando a classe caso o método for 3sigma
            
            if opcao == 0: #3sigma
                
                self.dlg.label_177.setVisible(True)
                self.dlg.label_176.setVisible(True)
                
                classe = self.classe_3sigma
                
                if classe ==0:
                    
                    self.dlg.label_176.setText('Classe A')
    
                elif classe ==1:
        
                    self.dlg.label_176.setText('Classe B')
    
                elif classe == 3:
        
                    self.dlg.label_176.setText('Classe C')
    
                else:
        
                    self.dlg.label_176.setText('Classe D')
            
            else: #Boxplot
                
                self.dlg.label_177.setVisible(False)
                self.dlg.label_176.setVisible(False)
            
            self.dlg.label_46.setText('Tolerância:')
            self.dlg.label_47.setText('Quantidade de Outliers:')
            
            #Mudando a posição dos labels
            self.dlg.label_122.setGeometry(95, 80, 191, 16)
            self.dlg.label_123.setGeometry(157, 110, 81, 16)
            
            #Mudando o resultado e os labels referentes
            
            self.dlg.label_121.setText(metodo)
            self.dlg.label_122.setText(dados_Z[0])
            self.dlg.label_123.setText(dados_Z[1])
            
        else: #2d e z  
            
            #Deixando os labels visiveis
            self.dlg.label_153.setVisible(True)
            self.dlg.label_157.setVisible(True)
            self.dlg.label_159.setVisible(True)
            self.dlg.label_130.setVisible(True)
            
            #Alterando os labels           
            
            self.dlg.label_46.setText('Tolerância Planimetria:')
            self.dlg.label_47.setText('Quantidade de Outliers Planimetria:')
            
            #Alterando a classe caso o método for 3sigma
            
            if opcao == 0: #3sigma
                
                self.dlg.label_177.setVisible(True)
                self.dlg.label_176.setVisible(True)
                
                classe = self.classe_3sigma
                
                if classe ==0:
                    
                    self.dlg.label_176.setText('Classe A')
    
                elif classe ==1:
        
                    self.dlg.label_176.setText('Classe B')
    
                elif classe == 3:
        
                    self.dlg.label_176.setText('Classe C')
    
                else:
        
                    self.dlg.label_176.setText('Classe D')
            
            else: #Boxplot
                
                self.dlg.label_177.setVisible(False)
                self.dlg.label_176.setVisible(False)
            
            #Mudando a posição dos labels
            self.dlg.label_122.setGeometry(160, 80, 191, 16)
            self.dlg.label_123.setGeometry(220, 110, 81, 16)
            
            #mudando o metodo
            self.dlg.label_121.setText(metodo)
            
            #Mudando o resultado de 2D
            self.dlg.label_122.setText(dados_2D[0])
            self.dlg.label_123.setText(dados_2D[1])
            
            #Mudando o resultado de Z
            self.dlg.label_157.setText(dados_Z[0])
            self.dlg.label_130.setText(dados_Z[1])
                      
    def outlier(self, dados, op): #op é para planimetria ou altimetria
        """Este método realiza a análise de outliers com base nos dados de discrepâncias e na opção se planimetria ou altimetria"""
        
        #Obtendo o método para análise de outliers, 3sigma ouy boxplot  
        
        self.opcao_outliers_processamento = self.dlg.comboBox_6.currentIndex()      
        opcao = self.opcao_outliers_processamento
        
        if opcao == 0: #3sigma
            
            #Obtendo o fator e a classe do método 3sigma
            self.fator_3sigma = self.dlg.lineEdit.text()
            self.classe_3sigma = self.dlg.comboBox_7.currentIndex()
            
            #Obtendo a escala a ser utulizada no teste 3sigma
            if op ==1: #Planimetria
            
                escala = self.dlg.comboBox_3.currentText()
            else:#Altimetria
                escala = self.dlg.comboBox_5.currentText()
            
            #Aplicando o método de detecção de outliers
            outliers, maximo = f3sigma(dados, self.fator_3sigma, escala, self.classe_3sigma, op)
            tolerancia = f"{maximo:.3f}m"
            metodo = 'Teste 3σ'
            
            #Retornando os outliers, o método e a tolerância
            return[metodo, tolerancia, outliers]
           
        else: #boxplot
                  
            #Obtendo o fator para o  boxplot
            self.fator_boxplot = self.dlg.lineEdit_2.text()
            
            #Aplicando a análise de outliers pelo boxplot
            outliers, LI, LS = fBoxPlot(dados,self.fator_boxplot)
            metodo = 'Diagrama Boxplot'
            tolerancia = f"LI: {LI:.3f}m - LS: {LS:.3f}m"
            
            #Retornando os outliers, o método e a tolerância
            return[metodo, tolerancia, outliers]
        
    def travar(self):
        """Este método deixa as tabwidgets desabilitadas"""
        
        self.dlg.tabWidget.setTabEnabled(1, False)
        self.dlg.tabWidget.setTabEnabled(2, False)
        self.dlg.tabWidget.setTabEnabled(3, False)
        self.dlg.tabWidget.setTabEnabled(4, False)
        self.dlg.tabWidget.setTabEnabled(5, False)
        self.dlg.tabWidget.setTabEnabled(6, False)
        self.dlg.tabWidget.setTabEnabled(7, False)
        
    def atualizar_cor_linha(self, index, row, out):
        """Este método atualiza a cor da linha da tabela de discrepâncias"""
        
        
        #Entra no if se o ponto for marcado para ser excluido
        if index == 1:
            
            color = QColor(235, 235, 235)  # Cor desejada, cinza
            brush = QBrush(color)
        
            # Percorrendo todas as colunas da linha
            for col in range(self.dlg.tableWidget_11.columnCount()):
                
                #Obtendo o item da coluna
                item = self.dlg.tableWidget_11.item(row, col)
                
                #Alterando a cor do item para a cor desejada
                
                if item: #Casos em que são itens
        
                    item.setBackground(brush)         
         
                else: #Casos em que temos o comboBox de excluir 
        
                    widget = self.dlg.tableWidget_11.cellWidget(row, col)
                    widget.setStyleSheet("background-color: rgb(235, 235, 235);")
        
        #Entra no else caso o usuário não ter escolhido excluir a linha
        else:
            
            #Entra no if se a discrepância em questão for outlier
            if  out:
                
                color = QColor(100, 255, 255)  # Cor desejada, ciano
                brush = QBrush(color)
                
                # Percorrendo todas as colunas da linha
                for col in range(self.dlg.tableWidget_11.columnCount()):
                    
                    #Obtendo o item da coluna
                    item = self.dlg.tableWidget_11.item(row, col)
                    
                    #Alterando a cor do item para a cor desejada
                    
                    if item : #Casos em que são itens
        
                        item.setBackground(brush) 
         
         
                    else: #Casos em que temos o comboBox de excluir
        
                        widget = self.dlg.tableWidget_11.cellWidget(row, col)
                        widget.setStyleSheet("background-color: rgb(100, 255, 255);")
                
            else:
                
                color = QColor(255, 255, 255, 255)  # Cor desejada, branco
                brush = QBrush(color)
                
                # Percorrendo todas as colunas da linha
                for col in range(self.dlg.tableWidget_11.columnCount()):
                    
                    #Obtendo o item da coluna
                    item = self.dlg.tableWidget_11.item(row, col)
                    
                    #Alterando a cor do item para a cor desejada
                    
                    if item : #Casos em que são itens
        
                        item.setBackground(brush) 
         
         
                    else: #Casos em que temos o comboBox de excluir
        
                        widget = self.dlg.tableWidget_11.cellWidget(row, col)
                        widget.setStyleSheet("background-color: rgb(255, 255, 255);")
    
    def showMessageBox(self, pontos):
        ''' Função para exibir o messageBox de escolha de processamento caso o usuário escolha excluir algum ponto'''
        
        #Entra no if se o usuário escolher excluir pelo menos um ponto
        
        if pontos!=0:
            
            #Criando o messagebox
            msgBox = QMessageBox()
            msgBox.setWindowTitle("Escolha uma opção")
            
            #Criando a mensagem do messagebox
            if pontos ==1:
                mensagem = f"Você selecionou 1 ponto para ser exluido do cálculo. Deseja mesmo excluir?"
                
            else:
                mensagem = f"Você selecionou {pontos} pontos para serem exluidos do cálculo. Deseja mesmo excluir?"
            
            #Adicionando a mensagem ao messagebox
            msgBox.setText(mensagem)
            
            # Adicionando um ícone personalizado do GeoPEC
            icon = QIcon(self.plugin_dir + "/icon/geopec.png")  
            msgBox.setWindowIcon(icon)
            
            # Adicionando o ícone de informação
            msgBox.setIcon(QMessageBox.Information)
            
            #Adicionando as opções de sim e de não ao messagebox
            simButton = QRadioButton("Sim, exclua os pontos do processamento")
            naoButton = QRadioButton("Não, mantenha os pontos no processamento ")
            
            #Adicionando os botões de sim e de não ao messagebox
            msgBox.addButton(simButton, QMessageBox.YesRole)
            msgBox.addButton(naoButton, QMessageBox.NoRole)
            
            #Obtendo a escolha do usuário
            returnValue = msgBox.exec_()
           
            #Entra no if caso o usuário escolha "sim", ou seja, processar excluindo os pontos
            if returnValue == 0:
                return True
            
            #Entra no else se o usuário escolha "Não", ou seja, desista de excluir os pontos
            else:
                return False
        
        #Entra no else caso o usuário não queira excluir nenhum ponto
        else:
            return False
            
    def atulizaEtCQDG(self,op,resultados):
        """Este método atualiza a interface gráfica da aba da ETCQDG, e tem como parâmetros a opção se 2D, Z ou 3D, e os resultados"""
        
        #Desempacotando os resultados 2D e Z
        result2d = resultados[0]
        resultZ = resultados[1]
        
        #Atualizando a interface gráfica da aba da ET-CQDG
        
        if (op ==0): #2d
            
            #Atualizando a primeira tabela 
            
            self.dlg.tableWidget_3.setItem(0, 4, QTableWidgetItem(f"{result2d['A']['PEC']:.3f}"))
            self.dlg.tableWidget_3.setItem(0, 5, QTableWidgetItem(f"{result2d['A']['EP']:.3f}"))
            
            self.dlg.tableWidget_3.setItem(1, 4, QTableWidgetItem(f"{result2d['B']['PEC']:.3f}"))
            self.dlg.tableWidget_3.setItem(1, 5, QTableWidgetItem(f"{result2d['B']['EP']:.3f}"))
            
            self.dlg.tableWidget_3.setItem(2, 4, QTableWidgetItem(f"{result2d['C']['PEC']:.3f}"))
            self.dlg.tableWidget_3.setItem(2, 5, QTableWidgetItem(f"{result2d['C']['EP']:.3f}"))
            
            self.dlg.tableWidget_3.setItem(3, 4, QTableWidgetItem(f"{result2d['D']['PEC']:.3f}"))
            self.dlg.tableWidget_3.setItem(3, 5, QTableWidgetItem(f"{result2d['D']['EP']:.3f}"))
            
            #Alterando a segunda tabela
            #Alterando a porcentagem de discrepâncias menores que o PEC e se o RMS foi menor que o EP
            
            self.dlg.tableWidget_5.setItem(0, 2, QTableWidgetItem(f"{result2d['A']['Percent']:.3f}"))
            self.dlg.tableWidget_5.setItem(1, 2, QTableWidgetItem(f"{result2d['B']['Percent']:.3f}"))
            self.dlg.tableWidget_5.setItem(2, 2, QTableWidgetItem(f"{result2d['C']['Percent']:.3f}"))
            self.dlg.tableWidget_5.setItem(3, 2, QTableWidgetItem(f"{result2d['D']['Percent']:.3f}"))
            
            self.dlg.tableWidget_5.setItem(0, 3, QTableWidgetItem(f"{result2d['A']['TestRMS']}"))
            self.dlg.tableWidget_5.setItem(1, 3, QTableWidgetItem(f"{result2d['B']['TestRMS']}"))
            self.dlg.tableWidget_5.setItem(2, 3, QTableWidgetItem(f"{result2d['C']['TestRMS']}"))
            self.dlg.tableWidget_5.setItem(3, 3, QTableWidgetItem(f"{result2d['D']['TestRMS']}"))
            
            r_A = result2d['A']['Resultado']
            r_B = result2d['B']['Resultado']
            r_C = result2d['C']['Resultado']
            r_D = result2d['D']['Resultado']
            
            #Alterando o resultado que aparece na tabela
            
            if r_A:
            
                self.dlg.tableWidget_5.setItem(0, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_5.setItem(0, 4, QTableWidgetItem('Reprovado'))
                
            if r_B:
            
                self.dlg.tableWidget_5.setItem(1, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_5.setItem(1, 4, QTableWidgetItem('Reprovado'))
                
            if r_C:
            
                self.dlg.tableWidget_5.setItem(2, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_5.setItem(2, 4, QTableWidgetItem('Reprovado'))
                
            if r_D:
            
                self.dlg.tableWidget_5.setItem(3, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_5.setItem(3, 4, QTableWidgetItem('Reprovado'))
            
            
            #mudando a visibilidade das tabwidget           
            self.dlg.tabWidget_2.setTabEnabled(0, True)
            self.dlg.tabWidget_3.setTabEnabled(0, True)
            self.dlg.tabWidget_2.setTabEnabled(1, False)
            self.dlg.tabWidget_3.setTabEnabled(1, False)
            
            # setando as abas que ficarão correntes
            self.dlg.tabWidget_2.setCurrentIndex(0)
            self.dlg.tabWidget_3.setCurrentIndex(0)
            
            #mudando o resultado final 
            self.dlg.label_127.setVisible(False)
            self.dlg.label_12.setVisible(False)
            
            self.dlg.label_11.setVisible(True)
            self.dlg.label_124.setVisible(True)
            
            self.dlg.label_11.setText('Resultado Planimetria:')
            
            #Não será "preciso" somente se não tiver classificação, ou seja, cair no else
            self.var_precisao_2D_relatorio = 'É preciso'
            
            if r_A: #Classe A
            
                self.dlg.label_124.setText('Classe A')
                self.classe_2D_relatorio = 'classe A'
                
                self.ep_2D_relatorio = result2d['A']['EP']
                self.pec_2D_relatorio = result2d['A']['PEC']
                self.percent_di_2D_relatorio = result2d['A']['Percent']
                
            elif r_B: #Classe B
                
                self.dlg.label_124.setText('Classe B')
                self.classe_2D_relatorio = 'classe B'
                
                self.ep_2D_relatorio = result2d['B']['EP']
                self.pec_2D_relatorio = result2d['B']['PEC']
                self.percent_di_2D_relatorio = result2d['B']['Percent']
                
            elif r_C: #Classe C
            
                self.dlg.label_124.setText('Classe C')
                self.classe_2D_relatorio = 'classe C'
                
                self.ep_2D_relatorio = result2d['C']['EP']
                self.pec_2D_relatorio = result2d['C']['PEC']
                self.percent_di_2D_relatorio = result2d['C']['Percent']
                
            elif r_D: #Classe D
            
                self.dlg.label_124.setText('Classe D')
                self.classe_2D_relatorio = 'classe D'
                
                self.ep_2D_relatorio = result2d['D']['EP']
                self.pec_2D_relatorio = result2d['D']['PEC']
                self.percent_di_2D_relatorio = result2d['D']['Percent']
                
            else: #Sem classificação
            
                self.dlg.label_124.setText('Sem Classificação')
                self.classe_2D_relatorio = 'sem classificação'
                self.var_precisao_2D_relatorio = 'Não é preciso'
                
                self.ep_2D_relatorio = result2d['D']['EP']
                self.pec_2D_relatorio = result2d['D']['PEC']
                self.percent_di_2D_relatorio = result2d['D']['Percent']
            
            #Atualizando as variaveis de relatorio
            self.ep_Z_relatorio = 'nao definido'
            self.pec_Z_relatorio = 'nao definido'
            self.percent_di_Z_relatorio = 'nao definido'
            self.classe_Z_relatorio = 'nao definido'
            self.var_precisao_Z_relatorio = 'nao definido'
        
        elif (op==1): #Z
            
            #Atualizando a primeira tabela
            
            self.dlg.tableWidget_4.setItem(0, 4, QTableWidgetItem(f"{resultZ['A']['PEC']:.3f}"))
            self.dlg.tableWidget_4.setItem(0, 5, QTableWidgetItem(f"{resultZ['A']['EP']:.3f}"))
            
            self.dlg.tableWidget_4.setItem(1, 4, QTableWidgetItem(f"{resultZ['B']['PEC']:.3f}"))
            self.dlg.tableWidget_4.setItem(1, 5, QTableWidgetItem(f"{resultZ['B']['EP']:.3f}"))
            
            self.dlg.tableWidget_4.setItem(2, 4, QTableWidgetItem(f"{resultZ['C']['PEC']:.3f}"))
            self.dlg.tableWidget_4.setItem(2, 5, QTableWidgetItem(f"{resultZ['C']['EP']:.3f}"))
            
            self.dlg.tableWidget_4.setItem(3, 4, QTableWidgetItem(f"{resultZ['D']['PEC']:.3f}"))
            self.dlg.tableWidget_4.setItem(3, 5, QTableWidgetItem(f"{resultZ['D']['EP']:.3f}"))
            
            #Atualizando a segunda tabela
            #Alterando a porcentagem de discrepâncias menores que o PEC e se o RMS foi menor que o EP
            
            self.dlg.tableWidget_6.setItem(0, 2, QTableWidgetItem(f"{resultZ['A']['Percent']:.3f}"))
            self.dlg.tableWidget_6.setItem(1, 2, QTableWidgetItem(f"{resultZ['B']['Percent']:.3f}"))
            self.dlg.tableWidget_6.setItem(2, 2, QTableWidgetItem(f"{resultZ['C']['Percent']:.3f}"))
            self.dlg.tableWidget_6.setItem(3, 2, QTableWidgetItem(f"{resultZ['D']['Percent']:.3f}"))
            
            self.dlg.tableWidget_6.setItem(0, 3, QTableWidgetItem(f"{resultZ['A']['TestRMS']}"))
            self.dlg.tableWidget_6.setItem(1, 3, QTableWidgetItem(f"{resultZ['B']['TestRMS']}"))
            self.dlg.tableWidget_6.setItem(2, 3, QTableWidgetItem(f"{resultZ['C']['TestRMS']}"))
            self.dlg.tableWidget_6.setItem(3, 3, QTableWidgetItem(f"{resultZ['D']['TestRMS']}"))
            
            r_A = resultZ['A']['Resultado']
            r_B = resultZ['B']['Resultado']
            r_C = resultZ['C']['Resultado']
            r_D = resultZ['D']['Resultado']
            
            #Alterando o resultado que aparece na tabela
            
            if r_A:
            
                self.dlg.tableWidget_6.setItem(0, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_6.setItem(0, 4, QTableWidgetItem('Reprovado'))
                
            if r_B:
            
                self.dlg.tableWidget_6.setItem(1, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_6.setItem(1, 4, QTableWidgetItem('Reprovado'))
                
            if r_C:
            
                self.dlg.tableWidget_6.setItem(2, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_6.setItem(2, 4, QTableWidgetItem('Reprovado'))
                
            if r_D:
            
                self.dlg.tableWidget_6.setItem(3, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_6.setItem(3, 4, QTableWidgetItem('Reprovado'))
            
            
            #mudando a visibilidade das tabwidget           
            self.dlg.tabWidget_2.setTabEnabled(0, False) #Abas de 2d
            self.dlg.tabWidget_3.setTabEnabled(0, False)
            self.dlg.tabWidget_2.setTabEnabled(1, True) #Abas de z
            self.dlg.tabWidget_3.setTabEnabled(1, True)
            
            # setando as abas que ficarão correntes
            self.dlg.tabWidget_2.setCurrentIndex(1)
            self.dlg.tabWidget_3.setCurrentIndex(1)
            
            #mudando o resultado final 
            
            self.dlg.label_127.setVisible(False)
            self.dlg.label_12.setVisible(False)
            
            self.dlg.label_11.setVisible(True)
            self.dlg.label_124.setVisible(True)
            
            self.dlg.label_11.setText('Resultado Altimetria:')
            
            #Não será preciso somente se cair no else, ou seja, "sem classificação"
            self.var_precisao_Z_relatorio = 'É preciso'
            
            if r_A: #Classe A
            
                self.dlg.label_124.setText('Classe A')
                self.classe_Z_relatorio = 'classe A'
                
                self.ep_Z_relatorio = resultZ['A']['EP']
                self.pec_Z_relatorio = resultZ['A']['PEC']
                self.percent_di_Z_relatorio = resultZ['A']['Percent']
                
            elif r_B: #Classe B
                
                self.dlg.label_124.setText('Classe B')
                self.classe_Z_relatorio = 'classe B'
                
                self.ep_Z_relatorio = resultZ['B']['EP']
                self.pec_Z_relatorio = resultZ['B']['PEC']
                self.percent_di_Z_relatorio = resultZ['B']['Percent']
                
            elif r_C: #Classe C
            
                self.dlg.label_124.setText('Classe C')
                self.classe_Z_relatorio = 'classe C'
                
                self.ep_Z_relatorio = resultZ['C']['EP']
                self.pec_Z_relatorio = resultZ['C']['PEC']
                self.percent_di_Z_relatorio = resultZ['C']['Percent']
                
            elif r_D: #Classe D
            
                self.dlg.label_124.setText('Classe D')
                self.classe_Z_relatorio = 'classe D'
                
                self.ep_Z_relatorio = resultZ['D']['EP']
                self.pec_Z_relatorio = resultZ['D']['PEC']
                self.percent_di_Z_relatorio = resultZ['D']['Percent']
                
            else: #Sem classificação
            
                self.dlg.label_124.setText('Sem Classificação')
                self.classe_Z_relatorio = 'sem classificação'
                self.var_precisao_Z_relatorio = 'Não é preciso'
                
                self.ep_Z_relatorio = resultZ['D']['EP']
                self.pec_Z_relatorio = resultZ['D']['PEC']
                self.percent_di_Z_relatorio = resultZ['D']['Percent']
                
            #Atualizando as variáveis de relatório
            
            self.ep_2D_relatorio = 'não definido'
            self.pec_2D_relatorio = 'não definido'  
            self.percent_di_2D_relatorio = 'não definido'             
            self.classe_2D_relatorio = 'não definido'
            self.var_precisao_2D_relatorio = 'não definido'
            
        else: #2D e Z
            
            #fazendo a parte 2D
            
            #Atualizando a primeira tabela
            
            self.dlg.tableWidget_3.setItem(0, 4, QTableWidgetItem(f"{result2d['A']['PEC']:.3f}"))
            self.dlg.tableWidget_3.setItem(0, 5, QTableWidgetItem(f"{result2d['A']['EP']:.3f}"))
            
            self.dlg.tableWidget_3.setItem(1, 4, QTableWidgetItem(f"{result2d['B']['PEC']:.3f}"))
            self.dlg.tableWidget_3.setItem(1, 5, QTableWidgetItem(f"{result2d['B']['EP']:.3f}"))
            
            self.dlg.tableWidget_3.setItem(2, 4, QTableWidgetItem(f"{result2d['C']['PEC']:.3f}"))
            self.dlg.tableWidget_3.setItem(2, 5, QTableWidgetItem(f"{result2d['C']['EP']:.3f}"))
            
            self.dlg.tableWidget_3.setItem(3, 4, QTableWidgetItem(f"{result2d['D']['PEC']:.3f}"))
            self.dlg.tableWidget_3.setItem(3, 5, QTableWidgetItem(f"{result2d['D']['EP']:.3f}"))
            
            #Atualizando a segunda tabela
            #Alterando a porcentagem de discrepâncias menores que o PEC e se o RMS foi menor que o EP
            
            self.dlg.tableWidget_5.setItem(0, 2, QTableWidgetItem(f"{result2d['A']['Percent']:.3f}"))
            self.dlg.tableWidget_5.setItem(1, 2, QTableWidgetItem(f"{result2d['B']['Percent']:.3f}"))
            self.dlg.tableWidget_5.setItem(2, 2, QTableWidgetItem(f"{result2d['C']['Percent']:.3f}"))
            self.dlg.tableWidget_5.setItem(3, 2, QTableWidgetItem(f"{result2d['D']['Percent']:.3f}"))
            
            self.dlg.tableWidget_5.setItem(0, 3, QTableWidgetItem(f"{result2d['A']['TestRMS']}"))
            self.dlg.tableWidget_5.setItem(1, 3, QTableWidgetItem(f"{result2d['B']['TestRMS']}"))
            self.dlg.tableWidget_5.setItem(2, 3, QTableWidgetItem(f"{result2d['C']['TestRMS']}"))
            self.dlg.tableWidget_5.setItem(3, 3, QTableWidgetItem(f"{result2d['D']['TestRMS']}"))
            
            r_A = result2d['A']['Resultado']
            r_B = result2d['B']['Resultado']
            r_C = result2d['C']['Resultado']
            r_D = result2d['D']['Resultado']
            
            #Alterando o resultado que aparece na tabela
            
            if r_A:
            
                self.dlg.tableWidget_5.setItem(0, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_5.setItem(0, 4, QTableWidgetItem('Reprovado'))
                
            if r_B:
            
                self.dlg.tableWidget_5.setItem(1, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_5.setItem(1, 4, QTableWidgetItem('Reprovado'))
                
            if r_C:
            
                self.dlg.tableWidget_5.setItem(2, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_5.setItem(2, 4, QTableWidgetItem('Reprovado'))
                
            if r_D:
            
                self.dlg.tableWidget_5.setItem(3, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_5.setItem(3, 4, QTableWidgetItem('Reprovado'))
                
            
            # Fazendo a parte Z
            
            #Atualizando a primeira tabela
            
            self.dlg.tableWidget_4.setItem(0, 4, QTableWidgetItem(f"{resultZ['A']['PEC']:.3f}"))
            self.dlg.tableWidget_4.setItem(0, 5, QTableWidgetItem(f"{resultZ['A']['EP']:.3f}"))
            
            self.dlg.tableWidget_4.setItem(1, 4, QTableWidgetItem(f"{resultZ['B']['PEC']:.3f}"))
            self.dlg.tableWidget_4.setItem(1, 5, QTableWidgetItem(f"{resultZ['B']['EP']:.3f}"))
            
            self.dlg.tableWidget_4.setItem(2, 4, QTableWidgetItem(f"{resultZ['C']['PEC']:.3f}"))
            self.dlg.tableWidget_4.setItem(2, 5, QTableWidgetItem(f"{resultZ['C']['EP']:.3f}"))
            
            self.dlg.tableWidget_4.setItem(3, 4, QTableWidgetItem(f"{resultZ['D']['PEC']:.3f}"))
            self.dlg.tableWidget_4.setItem(3, 5, QTableWidgetItem(f"{resultZ['D']['EP']:.3f}"))
            
            #Atualizando a segunda tabela
            #Alterando a porcentagem de discrepâncias menores que o PEC e se o RMS foi menor que o EP
            
            self.dlg.tableWidget_6.setItem(0, 2, QTableWidgetItem(f"{resultZ['A']['Percent']:.3f}"))
            self.dlg.tableWidget_6.setItem(1, 2, QTableWidgetItem(f"{resultZ['B']['Percent']:.3f}"))
            self.dlg.tableWidget_6.setItem(2, 2, QTableWidgetItem(f"{resultZ['C']['Percent']:.3f}"))
            self.dlg.tableWidget_6.setItem(3, 2, QTableWidgetItem(f"{resultZ['D']['Percent']:.3f}"))
            
            self.dlg.tableWidget_6.setItem(0, 3, QTableWidgetItem(f"{resultZ['A']['TestRMS']}"))
            self.dlg.tableWidget_6.setItem(1, 3, QTableWidgetItem(f"{resultZ['B']['TestRMS']}"))
            self.dlg.tableWidget_6.setItem(2, 3, QTableWidgetItem(f"{resultZ['C']['TestRMS']}"))
            self.dlg.tableWidget_6.setItem(3, 3, QTableWidgetItem(f"{resultZ['D']['TestRMS']}"))
            
            r_A_Z = resultZ['A']['Resultado']
            r_B_Z = resultZ['B']['Resultado']
            r_C_Z = resultZ['C']['Resultado']
            r_D_Z = resultZ['D']['Resultado']
            
            #Alterando o resultado que aparece na tabela
            
            if r_A_Z:
            
                self.dlg.tableWidget_6.setItem(0, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_6.setItem(0, 4, QTableWidgetItem('Reprovado'))
                
            if r_B_Z:
            
                self.dlg.tableWidget_6.setItem(1, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_6.setItem(1, 4, QTableWidgetItem('Reprovado'))
                
            if r_C_Z:
            
                self.dlg.tableWidget_6.setItem(2, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_6.setItem(2, 4, QTableWidgetItem('Reprovado'))
                
            if r_D_Z:
            
                self.dlg.tableWidget_6.setItem(3, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_6.setItem(3, 4, QTableWidgetItem('Reprovado'))
                
            #mudando a visibilidade das tabwidget           
            self.dlg.tabWidget_2.setTabEnabled(0, True) #Abas de 2d
            self.dlg.tabWidget_3.setTabEnabled(0, True)
            self.dlg.tabWidget_2.setTabEnabled(1, True) #Abas de z
            self.dlg.tabWidget_3.setTabEnabled(1, True)
            
            # setando as abas que ficarão correntes
            self.dlg.tabWidget_2.setCurrentIndex(0)
            self.dlg.tabWidget_3.setCurrentIndex(0)
            
            #mudando o resultado final para altimetria e planimetria
 
            self.dlg.label_127.setVisible(True)
            self.dlg.label_12.setVisible(True)
            
            self.dlg.label_11.setVisible(True)
            self.dlg.label_124.setVisible(True)
            
            self.dlg.label_11.setText('Resultado Planimetria:')
            
            #Mudando o resultado da planimetria
            
            #Não será "preciso" somente se não tiver classificação, ou seja, cair no else
            
            self.var_precisao_2D_relatorio = 'É preciso'
            
            if r_A: #Classe A
            
                self.dlg.label_124.setText('Classe A')
                self.classe_2D_relatorio = 'classe A'
                
                self.ep_2D_relatorio = result2d['A']['EP']
                self.pec_2D_relatorio = result2d['A']['PEC']
                self.percent_di_2D_relatorio = result2d['A']['Percent']
                
            elif r_B: #Classe B
                
                self.dlg.label_124.setText('Classe B')
                self.classe_2D_relatorio = 'classe B'
                
                self.ep_2D_relatorio = result2d['B']['EP']
                self.pec_2D_relatorio = result2d['B']['PEC']
                self.percent_di_2D_relatorio = result2d['B']['Percent']
                
            elif r_C: #Classe C
            
                self.dlg.label_124.setText('Classe C')
                self.classe_2D_relatorio = 'classe C'
                
                self.ep_2D_relatorio = result2d['C']['EP']
                self.pec_2D_relatorio = result2d['C']['PEC']
                self.percent_di_2D_relatorio = result2d['C']['Percent']
                
            elif r_D: #Classe D
            
                self.dlg.label_124.setText('Classe D')
                self.classe_2D_relatorio = 'classe D'
                
                self.ep_2D_relatorio = result2d['D']['EP']
                self.pec_2D_relatorio = result2d['D']['PEC']
                self.percent_di_2D_relatorio = result2d['D']['Percent']
                
            else: #Sem classificação
            
                self.dlg.label_124.setText('Sem Classificação')
                self.classe_2D_relatorio = 'sem classificação'
                self.var_precisao_2D_relatorio = 'Não é preciso'
                
                self.ep_2D_relatorio = result2d['D']['EP']
                self.pec_2D_relatorio = result2d['D']['PEC']
                self.percent_di_2D_relatorio = result2d['D']['Percent']
                
            #Mudando o resultado da altimetria
            #Não será "preciso" somente se não tiver classificação, ou seja, cair no else
            
            self.var_precisao_Z_relatorio = 'É preciso'
            
            if r_A_Z: #Classe A
            
                self.dlg.label_127.setText('Classe A')
                self.classe_Z_relatorio = 'classe A'
                
                self.ep_Z_relatorio = resultZ['A']['EP']
                self.pec_Z_relatorio = resultZ['A']['PEC']
                self.percent_di_Z_relatorio = resultZ['A']['Percent']
                
            elif r_B_Z: #Classe B
                
                self.dlg.label_127.setText('Classe B')
                self.classe_Z_relatorio = 'classe B'
                
                self.ep_Z_relatorio = resultZ['B']['EP']
                self.pec_Z_relatorio = resultZ['B']['PEC']
                self.percent_di_Z_relatorio = resultZ['B']['Percent']
                
            elif r_C_Z: #Classe C
            
                self.dlg.label_127.setText('Classe C')
                self.classe_Z_relatorio = 'classe C'
                
                self.ep_Z_relatorio = resultZ['C']['EP']
                self.pec_Z_relatorio = resultZ['C']['PEC']
                self.percent_di_Z_relatorio = resultZ['C']['Percent']
                
                
            elif r_D_Z: #Classe D
            
                self.dlg.label_127.setText('Classe D')
                self.classe_Z_relatorio = 'classe D'
                
                self.ep_Z_relatorio = resultZ['D']['EP']
                self.pec_Z_relatorio = resultZ['D']['PEC']
                self.percent_di_Z_relatorio = resultZ['D']['Percent']
                
            else: #Sem classificação
            
                self.dlg.label_127.setText('Sem Classificação')
                self.classe_Z_relatorio = 'sem classificação'
                self.var_precisao_Z_relatorio = 'Não é preciso'
                
                self.ep_Z_relatorio = resultZ['D']['EP']
                self.pec_Z_relatorio = resultZ['D']['PEC']
                self.percent_di_Z_relatorio = resultZ['D']['Percent']
                              
    def atulizaANM(self,op,resultados, esc_pla, esc_alt):
        """Este método atualiza a interface gráfica da aba da ANM, e tem como parâmetros a opção se 2D, Z ou 3D,os resultados e a escala de processamento"""
        
        #Desempacotando os resultados 2D e Z    
        result2d = resultados[0]
        resultZ = resultados[1]
        
        #Desempacotando os resultados de normalidade
        normalidade_x = resultados[2]
        normalidade_y = resultados[3]
        normalidade_z = resultados[4]
        
        #Desempacotando os resultados de tendência
        tendencia_x = resultados[5]
        tendencia_y = resultados[6]
        tendencia_z = resultados[7]
        
        #Atulizando a interface gráfica
        
        if (op ==7): #2d
            
            #Atualizando a primeira tabela 
            
            self.dlg.tableWidget_19.setItem(0, 4, QTableWidgetItem(f"{result2d['A']['PEC']:.3f}"))
            self.dlg.tableWidget_19.setItem(0, 5, QTableWidgetItem(f"{result2d['A']['EP']:.3f}"))
            
            self.dlg.tableWidget_19.setItem(1, 4, QTableWidgetItem(f"{result2d['B']['PEC']:.3f}"))
            self.dlg.tableWidget_19.setItem(1, 5, QTableWidgetItem(f"{result2d['B']['EP']:.3f}"))
            
            self.dlg.tableWidget_19.setItem(2, 4, QTableWidgetItem(f"{result2d['C']['PEC']:.3f}"))
            self.dlg.tableWidget_19.setItem(2, 5, QTableWidgetItem(f"{result2d['C']['EP']:.3f}"))
            
            self.dlg.tableWidget_19.setItem(3, 4, QTableWidgetItem(f"{result2d['D']['PEC']:.3f}"))
            self.dlg.tableWidget_19.setItem(3, 5, QTableWidgetItem(f"{result2d['D']['EP']:.3f}"))
            
            #Atualizando a segunda tabela
            #Alterando a porcentagem de discrepâncias menores que o PEC e se o RMS foi menor que o EP
            
            self.dlg.tableWidget_21.setItem(0, 2, QTableWidgetItem(f"{result2d['A']['Percent']:.3f}"))
            self.dlg.tableWidget_21.setItem(1, 2, QTableWidgetItem(f"{result2d['B']['Percent']:.3f}"))
            self.dlg.tableWidget_21.setItem(2, 2, QTableWidgetItem(f"{result2d['C']['Percent']:.3f}"))
            self.dlg.tableWidget_21.setItem(3, 2, QTableWidgetItem(f"{result2d['D']['Percent']:.3f}"))
            
            self.dlg.tableWidget_21.setItem(0, 3, QTableWidgetItem(f"{result2d['A']['TestRMS']}"))
            self.dlg.tableWidget_21.setItem(1, 3, QTableWidgetItem(f"{result2d['B']['TestRMS']}"))
            self.dlg.tableWidget_21.setItem(2, 3, QTableWidgetItem(f"{result2d['C']['TestRMS']}"))
            self.dlg.tableWidget_21.setItem(3, 3, QTableWidgetItem(f"{result2d['D']['TestRMS']}"))
            
            r_A = result2d['A']['Resultado']
            r_B = result2d['B']['Resultado']
            r_C = result2d['C']['Resultado']
            r_D = result2d['D']['Resultado']
            
            #Mudando o resultado que aparece na tabela 
            
            if r_A:
            
                self.dlg.tableWidget_21.setItem(0, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_21.setItem(0, 4, QTableWidgetItem('Reprovado'))
                
            if r_B:
            
                self.dlg.tableWidget_21.setItem(1, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_21.setItem(1, 4, QTableWidgetItem('Reprovado'))
                
            if r_C:
            
                self.dlg.tableWidget_21.setItem(2, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_21.setItem(2, 4, QTableWidgetItem('Reprovado'))
                
            if r_D:
            
                self.dlg.tableWidget_21.setItem(3, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_21.setItem(3, 4, QTableWidgetItem('Reprovado'))
            
            
            #mudando a visibilidade das tabwidget           
            self.dlg.tabWidget_6.setTabEnabled(0, True)
            self.dlg.tabWidget_11.setTabEnabled(0, True)
            self.dlg.tabWidget_6.setTabEnabled(1, False)
            self.dlg.tabWidget_11.setTabEnabled(1, False)
            
            # setando as abas que ficarão correntes
            self.dlg.tabWidget_6.setCurrentIndex(0)
            self.dlg.tabWidget_11.setCurrentIndex(0)
            
            #Atualizando os labels de normalidade
            
            #deixando os labels de z invisíveis
            self.dlg.label_38.setVisible(False)
            self.dlg.label_104.setVisible(False)
            
            #deixando os labels de x e y visíveis
            
            self.dlg.label_36.setVisible(True)
            self.dlg.label_37.setVisible(True)
            self.dlg.label_103.setVisible(True)
            self.dlg.label_99.setVisible(True)
            
            #Atualizando o contéudo dos labels
            
            self.dlg.label_36.setText('dx:')
            self.dlg.label_37.setText('dy:')
            self.dlg.label_99.setText(normalidade_x)
            self.dlg.label_103.setText(normalidade_y)
            
            #Atualizando os labels de tendência
            
            #Deizando os labels de z invisíveis
            self.dlg.label_42.setVisible(False)
            self.dlg.label_107.setVisible(False)
            
            #deixando os labels de x e y visíveis
            
            self.dlg.label_40.setVisible(True)
            self.dlg.label_41.setVisible(True)
            self.dlg.label_105.setVisible(True)
            self.dlg.label_106.setVisible(True)
            
            #Atualizando o contéudo dos labels
            
            self.dlg.label_40.setText('dx:')
            self.dlg.label_41.setText('dy:')
            
            #Atualizando os labels de tendência
            
            if  normalidade_x == 'Amostra NÃO Normal':
                
                self.dlg.label_105.setText('Inconclusivo')
            
            else:
                
                self.dlg.label_105.setText(tendencia_x)
            
            
            if  normalidade_y == 'Amostra NÃO Normal':
                
                self.dlg.label_106.setText('Inconclusivo')
            
            else:
                
                self.dlg.label_106.setText(tendencia_y)
            
            #Mudando o resultado final
            #Deizando os labels da altimetria invisíveis
            self.dlg.label_44.setVisible(False)
            self.dlg.label_128.setVisible(False)
            
            #Deizando os labels da planimetria visíveis
            self.dlg.label_43.setVisible(True)
            self.dlg.label_126.setVisible(True)
            
            #setando o label da planimetria
            self.dlg.label_43.setText('Resultado Geral Planimetria:')
            
            #Mudando o resultado final
            
            if (r_A == True) and (normalidade_x == 'Amostra Normal') and (normalidade_y == 'Amostra Normal') and (tendencia_x == 'Não há tendência') and (tendencia_y == 'Não há tendência'):
            
                self.dlg.label_126.setText(f'O produto foi aprovado para a escala 1:{esc_pla}')
                self.atende_ANM_2D_relatorio = 'ATENDE'
                
            else:
                
                self.dlg.label_126.setText(f'O produto não foi aprovado para a escala 1:{esc_pla}')
                self.atende_ANM_2D_relatorio = 'NÃO ATENDE'
            
            self.atende_ANM_Z_relatorio = 'não definido'
            
            #mudando o resultado final 
            self.dlg.label_127.setVisible(False)
            self.dlg.label_12.setVisible(False)
            
            self.dlg.label_11.setVisible(True)
            self.dlg.label_124.setVisible(True)
            
            self.dlg.label_11.setText('Resultado Planimetria:')
            
            #Não será "preciso" somente se não tiver classificação, ou seja, cair no else
            self.var_precisao_2D_relatorio = 'É preciso'
            
            if r_A: #Classe A
            
                self.classe_2D_relatorio = 'classe A'
                
                self.ep_2D_relatorio = result2d['A']['EP']
                self.pec_2D_relatorio = result2d['A']['PEC']
                
                self.percent_di_2D_relatorio = result2d['A']['Percent']
                
            elif r_B: #Classe B
                
                self.classe_2D_relatorio = 'classe B'
                
                self.ep_2D_relatorio = result2d['B']['EP']
                self.pec_2D_relatorio = result2d['B']['PEC']
                
                self.percent_di_2D_relatorio = result2d['B']['Percent']
                
            elif r_C: #Classe C
            
                self.classe_2D_relatorio = 'classe C'
                
                self.ep_2D_relatorio = result2d['C']['EP']
                self.pec_2D_relatorio = result2d['C']['PEC']
                
                self.percent_di_2D_relatorio = result2d['C']['Percent']
                
            
            elif r_D: #Classe D
            
                self.classe_2D_relatorio = 'classe D'
                
                self.ep_2D_relatorio = result2d['D']['EP']
                self.pec_2D_relatorio = result2d['D']['PEC']
                
                self.percent_di_2D_relatorio = result2d['D']['Percent']
                
            else: #Sem classificação
            
                self.classe_2D_relatorio = 'sem classificação'
                self.var_precisao_2D_relatorio = 'Não é preciso'
                
                self.ep_2D_relatorio = result2d['D']['EP']
                self.pec_2D_relatorio = result2d['D']['PEC']
                
                self.percent_di_2D_relatorio = result2d['D']['Percent']
            
            #Atualizando as variáveis de relatório
            
            self.ep_Z_relatorio = 'nao definido'
            self.pec_Z_relatorio = 'nao definido'
            self.classe_Z_relatorio = 'nao definido'
            self.var_precisao_Z_relatorio = 'nao definido'
            self.percent_di_Z_relatorio = 'nao definido'
           
        
        elif (op==8): #Z
            
            #Atualizando a primeira tabela
            
            self.dlg.tableWidget_20.setItem(0, 4, QTableWidgetItem(f"{resultZ['A']['PEC']:.3f}"))
            self.dlg.tableWidget_20.setItem(0, 5, QTableWidgetItem(f"{resultZ['A']['EP']:.3f}"))
            
            self.dlg.tableWidget_20.setItem(1, 4, QTableWidgetItem(f"{resultZ['B']['PEC']:.3f}"))
            self.dlg.tableWidget_20.setItem(1, 5, QTableWidgetItem(f"{resultZ['B']['EP']:.3f}"))
            
            self.dlg.tableWidget_20.setItem(2, 4, QTableWidgetItem(f"{resultZ['C']['PEC']:.3f}"))
            self.dlg.tableWidget_20.setItem(2, 5, QTableWidgetItem(f"{resultZ['C']['EP']:.3f}"))
            
            self.dlg.tableWidget_20.setItem(3, 4, QTableWidgetItem(f"{resultZ['D']['PEC']:.3f}"))
            self.dlg.tableWidget_20.setItem(3, 5, QTableWidgetItem(f"{resultZ['D']['EP']:.3f}"))
            
            #Atualizando a segunda tabela
            #Alterando a porcentagem de discrepâncias menores que o PEC e se o RMS foi menor que o EP
            
            self.dlg.tableWidget_22.setItem(0, 2, QTableWidgetItem(f"{resultZ['A']['Percent']:.3f}"))
            self.dlg.tableWidget_22.setItem(1, 2, QTableWidgetItem(f"{resultZ['B']['Percent']:.3f}"))
            self.dlg.tableWidget_22.setItem(2, 2, QTableWidgetItem(f"{resultZ['C']['Percent']:.3f}"))
            self.dlg.tableWidget_22.setItem(3, 2, QTableWidgetItem(f"{resultZ['D']['Percent']:.3f}"))
            
            self.dlg.tableWidget_22.setItem(0, 3, QTableWidgetItem(f"{resultZ['A']['TestRMS']}"))
            self.dlg.tableWidget_22.setItem(1, 3, QTableWidgetItem(f"{resultZ['B']['TestRMS']}"))
            self.dlg.tableWidget_22.setItem(2, 3, QTableWidgetItem(f"{resultZ['C']['TestRMS']}"))
            self.dlg.tableWidget_22.setItem(3, 3, QTableWidgetItem(f"{resultZ['D']['TestRMS']}"))
            
            r_A = resultZ['A']['Resultado']
            r_B = resultZ['B']['Resultado']
            r_C = resultZ['C']['Resultado']
            r_D = resultZ['D']['Resultado']
            
            #Atualizando o resultado que aparece na tabela
            
            if r_A:
            
                self.dlg.tableWidget_22.setItem(0, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_22.setItem(0, 4, QTableWidgetItem('Reprovado'))
                
            if r_B:
            
                self.dlg.tableWidget_22.setItem(1, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_22.setItem(1, 4, QTableWidgetItem('Reprovado'))
                
            if r_C:
            
                self.dlg.tableWidget_22.setItem(2, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_22.setItem(2, 4, QTableWidgetItem('Reprovado'))
                
            if r_D:
            
                self.dlg.tableWidget_22.setItem(3, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_22.setItem(3, 4, QTableWidgetItem('Reprovado'))
            
            
            #mudando a visibilidade das tabwidget           
            self.dlg.tabWidget_6.setTabEnabled(0, False) #Abas de 2d
            self.dlg.tabWidget_11.setTabEnabled(0, False)
            self.dlg.tabWidget_6.setTabEnabled(1, True) #Abas de z
            self.dlg.tabWidget_11.setTabEnabled(1, True)
            
            # setando as abas que ficarão correntes
            self.dlg.tabWidget_6.setCurrentIndex(1)
            self.dlg.tabWidget_11.setCurrentIndex(1)
            
            #Atualizando os labels de normalidade
            
            #deixando os resultados dos últimos dois labels invisíveis
            self.dlg.label_38.setVisible(False)
            self.dlg.label_104.setVisible(False)
            self.dlg.label_37.setVisible(False)
            self.dlg.label_103.setVisible(False)
            
            #deixando os labels que apareceram os resultados visíveis
            
            self.dlg.label_36.setVisible(True)
            self.dlg.label_99.setVisible(True)
            
            #Atualizando o contéudo dos labels
            
            self.dlg.label_36.setText('dz:')
            self.dlg.label_99.setText(normalidade_z)

            #Atualizando os labels de tendência
            
            #Deizando os dois últimos labels invisíveis
            
            self.dlg.label_41.setVisible(False)
            self.dlg.label_106.setVisible(False)            
            self.dlg.label_42.setVisible(False)
            self.dlg.label_107.setVisible(False)
            
            #deixando os labels que apareceream os resultados de z visíveis
            
            self.dlg.label_40.setVisible(True)            
            self.dlg.label_105.setVisible(True)
            
            
            #Atualizando o contéudo dos labels
            
            self.dlg.label_40.setText('dz:')
            
            #Atualizando o label de tendência          
            if  normalidade_z == 'Amostra NÃO Normal':
                
                self.dlg.label_105.setText('Inconclusivo')
            
            else:
                
                self.dlg.label_105.setText(tendencia_z)
                       
            #Mudando o resultado final
            #Deizando os labels da segunda linha invisíveis
            self.dlg.label_44.setVisible(False)
            self.dlg.label_128.setVisible(False)
            
            #Deizando os labels da altimetria visíveis
            self.dlg.label_43.setVisible(True)
            self.dlg.label_126.setVisible(True)
            
            #setando o label da planimetria
            self.dlg.label_43.setText('Resultado Geral Altimetria:')
            
            #Mudando o resultado final
            
            if (r_A == True) and (normalidade_z == 'Amostra Normal') and (tendencia_z == 'Não há tendência') :
            
                self.dlg.label_126.setText(f'O produto foi aprovado para a equidistância vertical de {esc_alt} metros')
                self.atende_ANM_Z_relatorio = 'ATENDE'
            
            else:
                
                self.dlg.label_126.setText(f'O produto não foi aprovado para a equidistância vertical de {esc_alt} metros')
                self.atende_ANM_Z_relatorio = 'NÃO ATENDE'
            
            self.atende_ANM_2D_relatorio = 'não defindo'
            
            #Alterando as variáveis de relatório
            #Não será "preciso" somente se não tiver classificação, ou seja, cair no else
            
            self.var_precisao_Z_relatorio = 'É preciso'
            
            if r_A: #Classe A
            
                self.classe_Z_relatorio = 'classe A'
                
                self.ep_Z_relatorio = resultZ['A']['EP']
                self.pec_Z_relatorio = resultZ['A']['PEC']
                
                self.percent_di_Z_relatorio = resultZ['A']['Percent']
                
            elif r_B: #Classe B
                
                self.classe_Z_relatorio = 'classe B'
                
                self.ep_Z_relatorio = resultZ['B']['EP']
                self.pec_Z_relatorio = resultZ['B']['PEC']
                
                self.percent_di_Z_relatorio = resultZ['B']['Percent']
                
            elif r_C: #Classe C
            
                self.classe_Z_relatorio = 'classe C'
                
                self.ep_Z_relatorio = resultZ['C']['EP']
                self.pec_Z_relatorio = resultZ['C']['PEC']
                
                self.percent_di_Z_relatorio = resultZ['C']['Percent']
                
            elif r_D: #Classe D
            
                self.classe_Z_relatorio = 'classe D'
                
                self.ep_Z_relatorio = resultZ['D']['EP']
                self.pec_Z_relatorio = resultZ['D']['PEC']
                
                self.percent_di_Z_relatorio = resultZ['D']['Percent']
                
            else: #Sem classificação
            
                self.classe_Z_relatorio = 'sem classificação'
                self.var_precisao_Z_relatorio = 'Não é preciso'
                
                self.ep_Z_relatorio = resultZ['D']['EP']
                self.pec_Z_relatorio = resultZ['D']['PEC']
                
                self.percent_di_Z_relatorio = resultZ['D']['Percent']
            
            
            #Atualizando as variáveis de relatório
            
            self.ep_2D_relatorio = 'não definido'
            self.pec_2D_relatorio = 'não definido'   
            self.classe_2D_relatorio = 'não definido'
            self.var_precisao_2D_relatorio = 'não definido'
            self.percent_di_2D_relatorio = 'não definido'
                       
        else: #2D e Z
            
            #fazendo a parte 2D            
            #Atualizando a primeira tabela
            
            self.dlg.tableWidget_19.setItem(0, 4, QTableWidgetItem(f"{result2d['A']['PEC']:.3f}"))
            self.dlg.tableWidget_19.setItem(0, 5, QTableWidgetItem(f"{result2d['A']['EP']:.3f}"))
            
            self.dlg.tableWidget_19.setItem(1, 4, QTableWidgetItem(f"{result2d['B']['PEC']:.3f}"))
            self.dlg.tableWidget_19.setItem(1, 5, QTableWidgetItem(f"{result2d['B']['EP']:.3f}"))
            
            self.dlg.tableWidget_19.setItem(2, 4, QTableWidgetItem(f"{result2d['C']['PEC']:.3f}"))
            self.dlg.tableWidget_19.setItem(2, 5, QTableWidgetItem(f"{result2d['C']['EP']:.3f}"))
            
            self.dlg.tableWidget_19.setItem(3, 4, QTableWidgetItem(f"{result2d['D']['PEC']:.3f}"))
            self.dlg.tableWidget_19.setItem(3, 5, QTableWidgetItem(f"{result2d['D']['EP']:.3f}"))
            
            #Atualizando a segunda tabela
            #Alterando a porcentagem de discrepâncias menores que o PEC e se o RMS foi menor que o EP
            
            self.dlg.tableWidget_21.setItem(0, 2, QTableWidgetItem(f"{result2d['A']['Percent']:.3f}"))
            self.dlg.tableWidget_21.setItem(1, 2, QTableWidgetItem(f"{result2d['B']['Percent']:.3f}"))
            self.dlg.tableWidget_21.setItem(2, 2, QTableWidgetItem(f"{result2d['C']['Percent']:.3f}"))
            self.dlg.tableWidget_21.setItem(3, 2, QTableWidgetItem(f"{result2d['D']['Percent']:.3f}"))
            
            self.dlg.tableWidget_21.setItem(0, 3, QTableWidgetItem(f"{result2d['A']['TestRMS']}"))
            self.dlg.tableWidget_21.setItem(1, 3, QTableWidgetItem(f"{result2d['B']['TestRMS']}"))
            self.dlg.tableWidget_21.setItem(2, 3, QTableWidgetItem(f"{result2d['C']['TestRMS']}"))
            self.dlg.tableWidget_21.setItem(3, 3, QTableWidgetItem(f"{result2d['D']['TestRMS']}"))
            
            r_A = result2d['A']['Resultado']
            r_B = result2d['B']['Resultado']
            r_C = result2d['C']['Resultado']
            r_D = result2d['D']['Resultado']
            
            #Mudando o resultado final que aparece na tabela
            
            if r_A:
            
                self.dlg.tableWidget_21.setItem(0, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_21.setItem(0, 4, QTableWidgetItem('Reprovado'))
                
            if r_B:
            
                self.dlg.tableWidget_21.setItem(1, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_21.setItem(1, 4, QTableWidgetItem('Reprovado'))
                
            if r_C:
            
                self.dlg.tableWidget_21.setItem(2, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_21.setItem(2, 4, QTableWidgetItem('Reprovado'))
                
            if r_D:
            
                self.dlg.tableWidget_21.setItem(3, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_21.setItem(3, 4, QTableWidgetItem('Reprovado'))
                
            
            # Fazendo a parte Z
            #Atualizando a primeira tabela 
            
            self.dlg.tableWidget_20.setItem(0, 4, QTableWidgetItem(f"{resultZ['A']['PEC']:.3f}"))
            self.dlg.tableWidget_20.setItem(0, 5, QTableWidgetItem(f"{resultZ['A']['EP']:.3f}"))
            
            self.dlg.tableWidget_20.setItem(1, 4, QTableWidgetItem(f"{resultZ['B']['PEC']:.3f}"))
            self.dlg.tableWidget_20.setItem(1, 5, QTableWidgetItem(f"{resultZ['B']['EP']:.3f}"))
            
            self.dlg.tableWidget_20.setItem(2, 4, QTableWidgetItem(f"{resultZ['C']['PEC']:.3f}"))
            self.dlg.tableWidget_20.setItem(2, 5, QTableWidgetItem(f"{resultZ['C']['EP']:.3f}"))
            
            self.dlg.tableWidget_20.setItem(3, 4, QTableWidgetItem(f"{resultZ['D']['PEC']:.3f}"))
            self.dlg.tableWidget_20.setItem(3, 5, QTableWidgetItem(f"{resultZ['D']['EP']:.3f}"))
            
            
            #Atualizando a segunda tabela
            #Alterando a porcentagem de discrepâncias menores que o PEC e se o RMS foi menor que o EP
            
            self.dlg.tableWidget_22.setItem(0, 2, QTableWidgetItem(f"{resultZ['A']['Percent']:.3f}"))
            self.dlg.tableWidget_22.setItem(1, 2, QTableWidgetItem(f"{resultZ['B']['Percent']:.3f}"))
            self.dlg.tableWidget_22.setItem(2, 2, QTableWidgetItem(f"{resultZ['C']['Percent']:.3f}"))
            self.dlg.tableWidget_22.setItem(3, 2, QTableWidgetItem(f"{resultZ['D']['Percent']:.3f}"))
            
            self.dlg.tableWidget_22.setItem(0, 3, QTableWidgetItem(f"{resultZ['A']['TestRMS']}"))
            self.dlg.tableWidget_22.setItem(1, 3, QTableWidgetItem(f"{resultZ['B']['TestRMS']}"))
            self.dlg.tableWidget_22.setItem(2, 3, QTableWidgetItem(f"{resultZ['C']['TestRMS']}"))
            self.dlg.tableWidget_22.setItem(3, 3, QTableWidgetItem(f"{resultZ['D']['TestRMS']}"))
            
            r_A_Z = resultZ['A']['Resultado']
            r_B_Z = resultZ['B']['Resultado']
            r_C_Z = resultZ['C']['Resultado']
            r_D_Z = resultZ['D']['Resultado']
            
            #Atualizando o resultado que aparece na tabela 
            
            if r_A_Z:
            
                self.dlg.tableWidget_22.setItem(0, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_22.setItem(0, 4, QTableWidgetItem('Reprovado'))
                
            if r_B_Z:
            
                self.dlg.tableWidget_22.setItem(1, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_22.setItem(1, 4, QTableWidgetItem('Reprovado'))
                
            if r_C_Z:
            
                self.dlg.tableWidget_22.setItem(2, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_22.setItem(2, 4, QTableWidgetItem('Reprovado'))
                
            if r_D_Z:
            
                self.dlg.tableWidget_22.setItem(3, 4, QTableWidgetItem('Aprovado'))
                
            else:
            
                self.dlg.tableWidget_22.setItem(3, 4, QTableWidgetItem('Reprovado'))
                
            #mudando a visibilidade das tabwidget           
            self.dlg.tabWidget_6.setTabEnabled(0, True) #Abas de 2d
            self.dlg.tabWidget_11.setTabEnabled(0, True)
            self.dlg.tabWidget_6.setTabEnabled(1, True) #Abas de z
            self.dlg.tabWidget_11.setTabEnabled(1, True)
            
            # setando as abas que ficarão correntes
            self.dlg.tabWidget_6.setCurrentIndex(0)
            self.dlg.tabWidget_11.setCurrentIndex(0)
            
            #Atualizando os labels de normalidade
            
            #deixando os resultados de x, y e z visíveis
                       
            self.dlg.label_36.setVisible(True)
            self.dlg.label_37.setVisible(True)
            self.dlg.label_38.setVisible(True)
            
            self.dlg.label_99.setVisible(True)
            self.dlg.label_103.setVisible(True)
            self.dlg.label_104.setVisible(True)
            
            #Atualizando o contéudo dos labels
            
            self.dlg.label_36.setText('dx:')
            self.dlg.label_37.setText('dy:')
            self.dlg.label_38.setText('dz:')
            self.dlg.label_99.setText(normalidade_x)
            self.dlg.label_103.setText(normalidade_y)
            self.dlg.label_104.setText(normalidade_z)
            
            #Atualizando os labels de tendência                      
            #deixando os labels de x, y e z visíveis
            
            self.dlg.label_40.setVisible(True)
            self.dlg.label_41.setVisible(True)
            self.dlg.label_42.setVisible(True)
            self.dlg.label_105.setVisible(True)
            self.dlg.label_106.setVisible(True)            
            self.dlg.label_107.setVisible(True)
            
            #Atualizando o contéudo dos labels
            self.dlg.label_40.setText('dx:')
            self.dlg.label_41.setText('dy:')
            self.dlg.label_42.setText('dz:')
            
            #Atualizando os labels de tendência
            if  normalidade_x == 'Amostra NÃO Normal':
                
                self.dlg.label_105.setText('Inconclusivo')
            
            else:
                
                self.dlg.label_105.setText(tendencia_x)
            
            
            if  normalidade_y == 'Amostra NÃO Normal':
                
                self.dlg.label_106.setText('Inconclusivo')
            
            else:
                
                self.dlg.label_106.setText(tendencia_y)
            
            if  normalidade_z == 'Amostra NÃO Normal':
                
                self.dlg.label_107.setText('Inconclusivo')
            
            else:
                
                self.dlg.label_107.setText(tendencia_z)
            
            
            #Mudando o resultado final
            #Deizando os labels de resultado visíveis
            
            #Deizando os labels da planimetria visíveis
            self.dlg.label_43.setVisible(True)
            self.dlg.label_126.setVisible(True)
            #Deizando os labels da altimetria visíveis
            self.dlg.label_44.setVisible(True)
            self.dlg.label_128.setVisible(True)
                  
            #setando o label da planimetria
            self.dlg.label_43.setText('Resultado Geral Planimetria:')
            #setando o label da altimetria
            self.dlg.label_44.setText('Resultado Geral Altimetria:')
            
            #Mudando o resultado final da planimetria
            
            if (r_A == True) and (normalidade_x == 'Amostra Normal') and (normalidade_y == 'Amostra Normal') and (tendencia_x == 'Não há tendência') and (tendencia_y == 'Não há tendência'):
            
                self.dlg.label_126.setText(f'O produto foi aprovado para a escala 1:{esc_pla}')
                self.atende_ANM_2D_relatorio = 'ATENDE'
            
            else:
                
                self.dlg.label_126.setText(f'O produto não foi aprovado para a escala 1:{esc_pla}')
                self.atende_ANM_2D_relatorio = 'NÃO ATENDE'
            
            #Mudando o resultado final da altimetria
            
            if (r_A_Z == True) and (normalidade_z == 'Amostra Normal') and (tendencia_z == 'Não há tendência') :
            
                self.dlg.label_128.setText(f'O produto foi aprovado para a equidistância vertical de {esc_alt} metros')
                self.atende_ANM_Z_relatorio = 'ATENDE'
                
            else:
                
                self.dlg.label_128.setText(f'O produto não foi aprovado para a equidistância vertical de {esc_alt} metros')
                self.atende_ANM_Z_relatorio = 'NÃO ATENDE'
            
            #Alterando as variáveis de relatório
            
            #Mudando o resultado da planimetria
            #Não será "preciso" somente se não tiver classificação, ou seja, cair no else
            
            self.var_precisao_2D_relatorio = 'É preciso'
            
            if r_A: #Classe A

                self.classe_2D_relatorio = 'classe A'
                
                self.ep_2D_relatorio = result2d['A']['EP']
                self.pec_2D_relatorio = result2d['A']['PEC']
                
                self.percent_di_2D_relatorio = result2d['A']['Percent']
                
            elif r_B: #Classe B
                
                self.classe_2D_relatorio = 'classe B'
                
                self.ep_2D_relatorio = result2d['B']['EP']
                self.pec_2D_relatorio = result2d['B']['PEC']
                
                self.percent_di_2D_relatorio = result2d['B']['Percent']
                
            elif r_C: #Classe C

                self.classe_2D_relatorio = 'classe C'
                
                self.ep_2D_relatorio = result2d['C']['EP']
                self.pec_2D_relatorio = result2d['C']['PEC']
                
                self.percent_di_2D_relatorio = result2d['C']['Percent']
                
            elif r_D: #Classe D
            
                self.classe_2D_relatorio = 'classe D'
                
                self.ep_2D_relatorio = result2d['D']['EP']
                self.pec_2D_relatorio = result2d['D']['PEC']
                
                self.percent_di_2D_relatorio = result2d['D']['Percent']
                
            else: #Sem classificação

                self.classe_2D_relatorio = 'sem classificação'
                self.var_precisao_2D_relatorio = 'Não é preciso'
                
                self.ep_2D_relatorio = result2d['D']['EP']
                self.pec_2D_relatorio = result2d['D']['PEC']
                
                self.percent_di_2D_relatorio = result2d['D']['Percent']
                
            #Mudando o resultado da altimetria
            #Não será "preciso" somente se não tiver classificação, ou seja, cair no else
            
            self.var_precisao_Z_relatorio = 'É preciso'
            
            if r_A_Z: #Classe A

                self.classe_Z_relatorio = 'classe A'
                
                self.ep_Z_relatorio = resultZ['A']['EP']
                self.pec_Z_relatorio = resultZ['A']['PEC']
                
                self.percent_di_Z_relatorio = resultZ['A']['Percent']
                
            elif r_B_Z: #Classe B

                self.classe_Z_relatorio = 'classe B'
                
                self.ep_Z_relatorio = resultZ['B']['EP']
                self.pec_Z_relatorio = resultZ['B']['PEC']
                
                self.percent_di_Z_relatorio = resultZ['B']['Percent']
                
            elif r_C_Z: #Classe C
            
                self.classe_Z_relatorio = 'classe C'
                
                self.ep_Z_relatorio = resultZ['C']['EP']
                self.pec_Z_relatorio = resultZ['C']['PEC']
                
                self.percent_di_Z_relatorio = resultZ['C']['Percent']
                
            elif r_D_Z: #Classe D
            
                self.classe_Z_relatorio = 'classe D'
                
                self.ep_Z_relatorio = resultZ['D']['EP']
                self.pec_Z_relatorio = resultZ['D']['PEC']
                
                self.percent_di_Z_relatorio = resultZ['D']['Percent']
                
            else: #Sem classificação
            
                self.classe_Z_relatorio = 'sem classificação'
                self.var_precisao_Z_relatorio = 'Não é preciso'
                
                self.ep_Z_relatorio = resultZ['D']['EP']
                self.pec_Z_relatorio = resultZ['D']['PEC']
                
                self.percent_di_Z_relatorio = resultZ['D']['Percent']
                            
    def atulizaIncra(self, op, result2d, d2D):
        """Este método atualiza a interface gráfica da aba do INCRA, e tem como parâmetros a opção se 2D, Z ou 3D,os resultados e as discrepancias 2D"""
        
        #Atualizando a primeira tabela 
        
        self.dlg.tableWidget_7.setItem(0, 4, QTableWidgetItem(f"{result2d['A']['PEC']:.3f}"))
        self.dlg.tableWidget_7.setItem(0, 5, QTableWidgetItem(f"{result2d['A']['EP']:.3f}"))
            
        self.dlg.tableWidget_7.setItem(1, 4, QTableWidgetItem(f"{result2d['B']['PEC']:.3f}"))
        self.dlg.tableWidget_7.setItem(1, 5, QTableWidgetItem(f"{result2d['B']['EP']:.3f}"))
            
        self.dlg.tableWidget_7.setItem(2, 4, QTableWidgetItem(f"{result2d['C']['PEC']:.3f}"))
        self.dlg.tableWidget_7.setItem(2, 5, QTableWidgetItem(f"{result2d['C']['EP']:.3f}"))
            
        self.dlg.tableWidget_7.setItem(3, 4, QTableWidgetItem(f"{result2d['D']['PEC']:.3f}"))
        self.dlg.tableWidget_7.setItem(3, 5, QTableWidgetItem(f"{result2d['D']['EP']:.3f}"))
        
        #Atualizando a segunda tabela
        #Alterando a porcentagem de discrepâncias menores que o PEC e se o RMS foi menor que o EP
        
        self.dlg.tableWidget_9.setItem(0, 2, QTableWidgetItem(f"{result2d['A']['Percent']:.3f}"))
        self.dlg.tableWidget_9.setItem(1, 2, QTableWidgetItem(f"{result2d['B']['Percent']:.3f}"))
        self.dlg.tableWidget_9.setItem(2, 2, QTableWidgetItem(f"{result2d['C']['Percent']:.3f}"))
        self.dlg.tableWidget_9.setItem(3, 2, QTableWidgetItem(f"{result2d['D']['Percent']:.3f}"))
        
        self.dlg.tableWidget_9.setItem(0, 3, QTableWidgetItem(f"{result2d['A']['TestRMS']}"))
        self.dlg.tableWidget_9.setItem(1, 3, QTableWidgetItem(f"{result2d['B']['TestRMS']}"))
        self.dlg.tableWidget_9.setItem(2, 3, QTableWidgetItem(f"{result2d['C']['TestRMS']}"))
        self.dlg.tableWidget_9.setItem(3, 3, QTableWidgetItem(f"{result2d['D']['TestRMS']}"))    
            
        r_A = result2d['A']['Resultado']
        r_B = result2d['B']['Resultado']
        r_C = result2d['C']['Resultado']
        r_D = result2d['D']['Resultado']
        
        #Atualizando o resultado que aparece na tabela 
        
        if r_A:
            
            self.dlg.tableWidget_9.setItem(0, 4, QTableWidgetItem('Aprovado'))
                
        else:
            
            self.dlg.tableWidget_9.setItem(0, 4, QTableWidgetItem('Reprovado'))
                
        if r_B:
            
            self.dlg.tableWidget_9.setItem(1, 4, QTableWidgetItem('Aprovado'))
                
        else:
            
            self.dlg.tableWidget_9.setItem(1, 4, QTableWidgetItem('Reprovado'))
                
        if r_C:
            
            self.dlg.tableWidget_9.setItem(2, 4, QTableWidgetItem('Aprovado'))
                
        else:
            
            self.dlg.tableWidget_9.setItem(2, 4, QTableWidgetItem('Reprovado'))
                
        if r_D:
            
            self.dlg.tableWidget_9.setItem(3, 4, QTableWidgetItem('Aprovado'))
                
        else:
            
            self.dlg.tableWidget_9.setItem(3, 4, QTableWidgetItem('Reprovado'))
                     
        #mudando o resultado final 
                  
        if r_A: #Classe A
            
            classe = 'A'           
            self.classe_2D_relatorio = 'classe A' #Variável de relatório 
            self.pec_2D_relatorio = result2d['A']['PEC'] #Variável de relatório
            self.ep_2D_relatorio = result2d['A']['EP'] #Variável de relatório
            self.percent_di_2D_relatorio = result2d['A']['Percent'] #Variável de relatório
            
        elif r_B: #Classe B
                
            classe = 'B'
            self.classe_2D_relatorio = 'classe B' #Variável de relatório
            self.pec_2D_relatorio = result2d['B']['PEC'] #Variável de relatório
            self.ep_2D_relatorio = result2d['B']['EP'] #Variável de relatório
            self.percent_di_2D_relatorio = result2d['B']['Percent'] #Variável de relatório
            
        elif r_C: #Classe C
            
            classe = 'C'
            self.classe_2D_relatorio = 'classe C' #Variável de relatório
            self.pec_2D_relatorio = result2d['C']['PEC'] #Variável de relatório
            self.ep_2D_relatorio = result2d['C']['EP'] #Variável de relatório
            self.percent_di_2D_relatorio = result2d['C']['Percent'] #Variável de relatório
            
        elif r_D: #Classe D
            
            classe = 'D'
            self.classe_2D_relatorio = 'classe D' #Variável de relatório
            self.pec_2D_relatorio = result2d['D']['PEC'] #Variável de relatório
            self.ep_2D_relatorio = result2d['D']['EP'] #Variável de relatório
            self.percent_di_2D_relatorio = result2d['D']['Percent'] #Variável de relatório
            
        else: #Sem classificação
            
            classe = False
            self.classe_2D_relatorio = 'sem classificação' #Variável de relatório
            self.pec_2D_relatorio = result2d['D']['PEC'] #Variável de relatório
            self.ep_2D_relatorio = result2d['D']['EP'] #Variável de relatório
            self.percent_di_2D_relatorio = result2d['D']['Percent'] #Variável de relatório
            
        #Atualizando os labels do resultado final
        
        if (classe == False): #O produto não atende nenhuma classe do decreto/ETCQDG
            
            self.dlg.label_96.setText('Reprovado')
            self.dlg.label_97.setText('Reprovado')
            self.dlg.label_98.setText('Reprovado')
            self.dlg.label_125.setText('O produto NÃO ATENDE as normativas do INCRA')
            self.var_limites_INCRA_relatorio = 'nao definido' #Variável de relatório
            self.var_atende_INCRA_relatorio = 'NÃO ATENDE' #Variável de relatório
        
        else:  #O produto pode atender a algum tipo de vértice
        
            pec = result2d[classe]['PEC']
           
            self.var_atende_INCRA_relatorio = 'ATENDE' #Variável de relatório
            
            if (pec<= 0.5): #artificial
                
                #Atualizando os labels 
                self.dlg.label_96.setText('Atende')
                self.dlg.label_97.setText('Atende')
                self.dlg.label_98.setText('Atende')
                self.dlg.label_125.setText('O produto ATENDE as normativas do INCRA')
                
                #Variável de relatório
                self.var_limites_INCRA_relatorio = 'dos <b>limites artificial, natural e inacessível</b>' #Variável de relatório
                
            elif (pec<=3): #natural
                
                #Atualizando os labels
                self.dlg.label_96.setText('Reprovado')
                self.dlg.label_97.setText('Atende')
                self.dlg.label_98.setText('Atende')
                self.dlg.label_125.setText('O produto ATENDE as normativas do INCRA')
                
                #Variável de relatório
                self.var_limites_INCRA_relatorio = 'dos <b>limites natural e inacessível</b>' #Variável de relatório
                
            elif (pec<=7.5): #inacessível
                
                #Atualizando os labels
                self.dlg.label_96.setText('Reprovado')
                self.dlg.label_97.setText('Reprovado')
                self.dlg.label_98.setText('Atende')
                self.dlg.label_125.setText('O produto ATENDE as normativas do INCRA')
                
                #Variável de relatório
                self.var_limites_INCRA_relatorio = 'do <b>limite inacessível</b>' #Variável de relatório
                
            else: #Não atende nenhum tipo de vértice
                
                #Atualizando os labels
                self.dlg.label_96.setText('Reprovado')
                self.dlg.label_97.setText('Reprovado')
                self.dlg.label_98.setText('Reprovado')
                self.dlg.label_125.setText('O produto NÃO ATENDE as normativas do INCRA')
                self.var_limites_INCRA_relatorio = 'nao definido' #Variável de relatório
                self.var_atende_INCRA_relatorio = 'NÃO ATENDE' #Variável de relatório
            
        #Precisão dos vértices:
        
        self.dlg.label_185.setText(f"Precisão dos vértices (m): {fRms(d2D):.3f}")
        
        #Atualizando as variáveis de relatório
        
        self.var_artificial_INCRA_relatorio = self.dlg.label_96.text()
        self.var_natural_INCRA_relatorio = self.dlg.label_97.text()
        self.var_inacessivel_INCRA_relatorio = self.dlg.label_98.text()
        
        self.var_precisao_2D_relatorio = 'nao definido'
        self.var_precisao_Z_relatorio = 'nao definido'
        
        self.classe_Z_relatorio = 'nao definido' #Variável de relatório
        self.pec_Z_relatorio =  'nao definido'
        self.ep_Z_relatorio = 'nao definido'
        self.classe_Z_relatorio = 'nao definido'
        self.percent_di_Z_relatorio = 'nao definido'  #Variável de relatório
               
    def atulizaNBR(self, op, resultados):
        """Este método atualiza a interface gráfica da aba da NBR 13133, e tem como parâmetros a opção se 2D, Z ou 3D, e os resultados"""
        
        #Desempacotando os resultados 2D e Z
        result2d = resultados[0]
        resultZ = resultados[1]
        
        #Desempacotando os resultados referentes a precisão planimétrica e altimétrica
        p_pla = resultados[2]
        p_alt = resultados[3]
        
        #Atualizando a interface gráfica
        
        if (op ==3): #2d
            
            #Calculando a tolerância planimétrica
            t_pla = p_pla*3

            #Atualizando a tabela 
            self.dlg.tableWidget_12.setItem(0, 1, QTableWidgetItem(f"{p_pla:.2f}"))
            self.dlg.tableWidget_12.setItem(0, 2, QTableWidgetItem(f"{t_pla:.2f}"))         
            self.dlg.tableWidget_12.setItem(0, 3, QTableWidgetItem(f"{result2d[1]:.2f}"))
            
            #mudando a visibilidade da tabwidget           
            self.dlg.tabWidget_8.setTabEnabled(0, True)
            self.dlg.tabWidget_8.setTabEnabled(1, False)
 
            # setando a aba que ficara corrente
            self.dlg.tabWidget_8.setCurrentIndex(0)

            #mudando o resultado final
            #Alterando a visibilidade dos labels da altimetria
            
            self.dlg.label_163.setVisible(False)
            self.dlg.label_162.setVisible(False)
            
            #Alterando a visibilidade dos labels da planimetria
            self.dlg.label_160.setVisible(True)
            self.dlg.label_156.setVisible(True)
            
            self.dlg.label_160.setText('ACEITAÇÃO RELATIVA PLANIMETRIA')
            
            #Alterando o label do resultado final e a tabela 
            
            if result2d[0]: #Aprovado
            
                self.dlg.tableWidget_12.setItem(0, 4, QTableWidgetItem("Aprovado"))
                self.dlg.label_156.setText('O produto foi APROVADO no processo de inspeção posicional da NBR 13.133 de 2021')
                
                self.var_result_2D_NBR_relatorio = 'Aprovado' #Variável de relatório
                
            else: #Reprovado
                
                self.dlg.tableWidget_12.setItem(0, 4, QTableWidgetItem("Reprovado"))
                self.dlg.label_156.setText('O produto foi REPROVADO no processo de inspeção posicional da NBR 13.133 de 2021')
                
                self.var_result_2D_NBR_relatorio = 'Reprovado' #Variável de relatório
            
            #Atualizando as variáveis de relatório
            
            self.var_percent_2D_NBR_relatorio = f"{result2d[1]:.2f}"
            
            self.var_result_Z_NBR_relatorio = 'nao definido'
            self.var_percent_Z_NBR_relatorio = 'nao definido'
            
            self.var_precisao_2D_NBR_relatorio = self.dlg.lineEdit_4.text()
            self.var_precisao_Z_NBR_relatorio = 'nao definido'
            self.var_tolerancia_2D_NBR_relatorio = f"{float(self.dlg.lineEdit_4.text())*3:.3f}"
            self.var_tolerancia_Z_NBR_relatorio = 'nao definido'
             
            
        elif (op ==4): #z
            
            #Calculando a tolerância altimétrica
            t_alt = p_alt*3
            
            #Atualizando a tabela
            self.dlg.tableWidget_14.setItem(0, 1, QTableWidgetItem(f"{p_alt:.2f}"))
            self.dlg.tableWidget_14.setItem(0, 2, QTableWidgetItem(f"{t_alt:.2f}"))            
            self.dlg.tableWidget_14.setItem(0, 3, QTableWidgetItem(f"{resultZ[1]:.2f}"))
            
            #mudando a visibilidade da tabwidget           
            self.dlg.tabWidget_8.setTabEnabled(0, False)
            self.dlg.tabWidget_8.setTabEnabled(1, True)
 
            # setando a aba que ficará corrente
            self.dlg.tabWidget_8.setCurrentIndex(1)

            #mudando o resultado final
            #Alterando a visibilidade dos labels das últimas linhas
            
            self.dlg.label_163.setVisible(False)
            self.dlg.label_162.setVisible(False)
            
            #Alterando a visibilidade dos labels superiores
            self.dlg.label_160.setVisible(True)
            self.dlg.label_156.setVisible(True)
            
            self.dlg.label_160.setText('ACEITAÇÃO RELATIVA ALTIMETRIA')
            
            #Alterando o label do resultado final e a tabela 
            
            if resultZ[0]: #Aprovado
            
                self.dlg.tableWidget_14.setItem(0, 4, QTableWidgetItem("Aprovado"))
                self.dlg.label_156.setText('O produto foi APROVADO no processo de inspeção posicional da NBR 13.133 de 2021')
                
                self.var_result_Z_NBR_relatorio = 'Aprovado' #Variável de relatório
                
            else: #Reprovado
                
                self.dlg.tableWidget_14.setItem(0, 4, QTableWidgetItem("Reprovado"))
                self.dlg.label_156.setText('O produto foi REPROVADO no processo de inspeção posicional da NBR 13.133 de 2021')
                
                self.var_result_Z_NBR_relatorio = 'Reprovado'
            
            #Atualizando as variáveis de relatório
            
            self.var_percent_Z_NBR_relatorio = f"{resultZ[1]:.2f}"           
            self.var_result_2D_NBR_relatorio = 'nao definido'
            self.var_percent_2D_NBR_relatorio = 'nao definido'
            
            self.var_precisao_2D_NBR_relatorio = 'nao definido'
            self.var_precisao_Z_NBR_relatorio = self.dlg.lineEdit_5.text()
            self.var_tolerancia_2D_NBR_relatorio = 'nao definido'
            self.var_tolerancia_Z_NBR_relatorio = f"{float(self.dlg.lineEdit_5.text())*3:.3f}"
            
        else: #2D e z
            
            #Calculando as tolerâncias 2D e Z
            t_pla = p_pla*3
            t_alt = p_alt*3
            
            #fazendo a parte 2D
            #Atualizando a tabela
            
            self.dlg.tableWidget_12.setItem(0, 1, QTableWidgetItem(f"{p_pla:.2f}"))
            self.dlg.tableWidget_12.setItem(0, 2, QTableWidgetItem(f"{t_pla:.2f}"))
            self.dlg.tableWidget_12.setItem(0, 3, QTableWidgetItem(f"{result2d[1]:.2f}"))
            
            #fazendo a parte z
            #Atualizando a tabela
            self.dlg.tableWidget_14.setItem(0, 1, QTableWidgetItem(f"{p_alt:.2f}"))
            self.dlg.tableWidget_14.setItem(0, 2, QTableWidgetItem(f"{t_alt:.2f}"))     
            self.dlg.tableWidget_14.setItem(0, 3, QTableWidgetItem(f"{resultZ[1]:.2f}"))
            
            #mudando a visibilidade da tabwidget           
            self.dlg.tabWidget_8.setTabEnabled(0, True)
            self.dlg.tabWidget_8.setTabEnabled(1, True)
 
            # setando a aba que ficará corrente
            self.dlg.tabWidget_8.setCurrentIndex(0)

            #mudando o resultado final
            #Alterando a visibilidade dos labels 
            
            self.dlg.label_160.setVisible(True)
            self.dlg.label_156.setVisible(True)
            
            self.dlg.label_163.setVisible(True)
            self.dlg.label_162.setVisible(True)
            
            #Setando o texto dos labels
            self.dlg.label_160.setText('ACEITAÇÃO RELATIVA PLANIMETRIA')
            self.dlg.label_163.setText('ACEITAÇÃO RELATIVA ALTIMETRIA')
            
            #Alterando o label do resultado final e a tabela 
            
            #Alterando para 2D
            if result2d[0]: #Aprovado
            
                self.dlg.tableWidget_12.setItem(0, 4, QTableWidgetItem("Aprovado"))
                self.dlg.label_156.setText('O produto foi APROVADO no processo de inspeção posicional da NBR 13.133 de 2021')
                
                self.var_result_2D_NBR_relatorio = 'Aprovado' #Variável de relatório
                
            else: #Reprovado
                
                self.dlg.tableWidget_12.setItem(0, 4, QTableWidgetItem("Reprovado"))
                self.dlg.label_156.setText('O produto foi REPROVADO no processo de inspeção posicional da NBR 13.133 de 2021')
                
                self.var_result_2D_NBR_relatorio = 'Reprovado' #Variável de relatório
                
            #Alterando para z
            if resultZ[0]: #Aprovado
            
                self.dlg.tableWidget_14.setItem(0, 4, QTableWidgetItem("Aprovado"))
                self.dlg.label_162.setText('O produto foi APROVADO no processo de inspeção posicional da NBR 13.133 de 2021')
                
                self.var_result_Z_NBR_relatorio = 'Aprovado' #Variável de relatório
                
            else: #Reprovado
                
                self.dlg.tableWidget_14.setItem(0, 4, QTableWidgetItem("Reprovado"))
                self.dlg.label_162.setText('O produto foi REPROVADO no processo de inspeção posicional da NBR 13.133 de 2021')
                
                self.var_result_Z_NBR_relatorio = 'Reprovado' #Variável de relatório
            
            #Atualizando as variáveis de relatório
            self.var_percent_Z_NBR_relatorio = f"{resultZ[1]:.2f}"
            self.var_percent_2D_NBR_relatorio = f"{result2d[1]:.2f}"
            
            self.var_precisao_2D_NBR_relatorio = self.dlg.lineEdit_4.text()
            self.var_precisao_Z_NBR_relatorio = self.dlg.lineEdit_5.text()
            self.var_tolerancia_2D_NBR_relatorio = f"{float(self.dlg.lineEdit_4.text())*3:.3f}"
            self.var_tolerancia_Z_NBR_relatorio = f"{float(self.dlg.lineEdit_5.text())*3:.3f}"
                     
    def proc_normas(self, dx, dy, dz, d2D):
        """Este método realiza o processamento da norma escolhida pelo usuário, e tem como parâmetro as discrepâncias calculadas"""
        
        #Obtendo a opção de processamento
        op = self.op_norma
        
        #Realizando o processamento das normas
        
        if (op==0) or (op==1) or (op==2): #ET CDQG
                   
            if (op==0): #2D
                
                #Realizando o processamento
                esc_pla = float(self.dlg.comboBox_3.currentText())
                result = fClassesETpla(d2D,esc_pla)
                resultados = [result, 0]
                #Chamando a função para atualizar a interface gráfica
                self.atulizaEtCQDG(op,resultados)
                
                #Definindo variáveis de relatório 
                self.escala_2D_relatorio = self.dlg.comboBox_3.currentText()
                self.escala_Z_relatorio = 'nao definido'
                
            elif (op==1): #Z
                
                #Realizando o processamento
                esc_alt = float(self.dlg.comboBox_5.currentText())
                result = fClassesETalt(dz,esc_alt)
                resultados = [0, result]
                #Chamando a função para atualizar a interface gráfica
                self.atulizaEtCQDG(op,resultados)
                
                #Definindo variáveis de relatório 
                self.escala_2D_relatorio = 'nao definido'
                self.escala_Z_relatorio = self.dlg.comboBox_5.currentText()
                
            else: #2D e Z
                
                #Realizando o processamento
                esc_pla = float(self.dlg.comboBox_3.currentText())
                esc_alt = float(self.dlg.comboBox_5.currentText())
                result2d = fClassesETpla(d2D,esc_pla)
                resultZ = fClassesETalt(dz,esc_alt)
                resultados = [result2d, resultZ]
                #Chamando a função para atualizar a interface gráfica
                self.atulizaEtCQDG(op,resultados)
                
                #Definindo variáveis de relatório
                self.escala_2D_relatorio = self.dlg.comboBox_3.currentText()
                self.escala_Z_relatorio = self.dlg.comboBox_5.currentText()
                

        elif (op==3) or (op==4) or (op==5): #NBR 13133
                    
            if (op==3): #2D
                
                #Realizando o processamento
                p_pla = float(self.dlg.lineEdit_4.text())
                result = fCalcNBR(d2D, p_pla)
                resultados = [result,0, p_pla, 0]
                
                #Chamando a função para atualizar a interface gráfica
                self.atulizaNBR(op, resultados)
                
            elif (op==4): #Z
                
                #Realizando o processamento
                p_alt = float(self.dlg.lineEdit_5.text())
                result = fCalcNBR(dz, p_alt)
                resultados = [0, result, 0, p_alt]
                
                #Chamando a função para atualizar a interface gráfica
                self.atulizaNBR(op,resultados)
                
            else: #2D e Z
                
                #Realizando o processamento
                p_pla = float(self.dlg.lineEdit_4.text())
                p_alt = float(self.dlg.lineEdit_5.text())
                result2d = fCalcNBR(d2D, p_pla)
                resultZ = fCalcNBR(dz, p_alt)
                resultados = [result2d, resultZ, p_pla, p_alt ]
                
                #Chamando a função para atualizar a interface gráfica
                self.atulizaNBR(op,resultados)
                
            
        elif (op==6): #INCRA
            
            #Realizando o processamento
            esc_pla = float(self.dlg.comboBox_3.currentText())
            result2d = fClassesETpla(d2D,esc_pla)
            #Chamando a função para atualizar a interface gráfica
            self.atulizaIncra(op,result2d,d2D)
            
            #Definindo variáveis de relatório 
            self.escala_2D_relatorio = self.dlg.comboBox_3.currentText()
            self.escala_Z_relatorio = 'nao definido'
            
        else: #ANM

            #Realizando as análises de normalidade e tendência
            
            nomalidade_x = fTesteDeNormalidade(dx, 2)
            nomalidade_y = fTesteDeNormalidade(dy, 2)
            nomalidade_z = fTesteDeNormalidade(dz, 2)
            tendencia_x = fTdeStudent(dx, 1)
            tendencia_y = fTdeStudent(dy, 1)
            tendencia_z = fTdeStudent(dz, 1)
            
            if (op==7): #2D
                
                #Realizando o processamento
                esc_pla = float(self.dlg.comboBox_3.currentText())
                result = fClassesETpla(d2D,esc_pla)
                resultados = [result, 0, nomalidade_x[2], nomalidade_y[2], nomalidade_z[2],tendencia_x[0], tendencia_y[0], tendencia_z[0] ]
                #Chamando a função para atualizar a interface gráfica
                self.atulizaANM(op,resultados, esc_pla, 0)
                
                #Definindo variáveis de relatório 
                self.escala_2D_relatorio = self.dlg.comboBox_3.currentText()
                self.escala_Z_relatorio = 'nao definido'
            
            elif (op==8):#Z
                
                #Realizando o processamento
                esc_alt = float(self.dlg.comboBox_5.currentText())
                result = fClassesETalt(dz,esc_alt)
                resultados = [0, result, nomalidade_x[2], nomalidade_y[2], nomalidade_z[2],tendencia_x[0], tendencia_y[0], tendencia_z[0]]
                #Chamando a função para atualizar a interface gráfica
                self.atulizaANM(op,resultados, 0, esc_alt)
                
                #Definindo variáveis de relatório 
                self.escala_2D_relatorio = 'nao definido'
                self.escala_Z_relatorio = self.dlg.comboBox_5.currentText()
                
            else: #2D e Z
                
                #Realizando o processamento
                esc_pla = float(self.dlg.comboBox_3.currentText())
                esc_alt = float(self.dlg.comboBox_5.currentText())
                result2d = fClassesETpla(d2D,esc_pla)
                resultZ = fClassesETalt(dz,esc_alt)
                resultados = [result2d, resultZ, nomalidade_x[2], nomalidade_y[2], nomalidade_z[2],tendencia_x[0], tendencia_y[0], tendencia_z[0]]
                 #Chamando a função para atualizar a interface gráfica
                self.atulizaANM(op,resultados, esc_pla, esc_alt)
                
                #Definindo variáveis de relatório
                self.escala_2D_relatorio = self.dlg.comboBox_3.currentText()
                self.escala_Z_relatorio = self.dlg.comboBox_5.currentText()
    
    def preenche_table(self,dx,dy,dz,d2D,d3D, dict_outliers, pts_utilizados):
        """Este método preenche a tabela de estátisticas e tem como parâmetros as discrepâncias, os outliers e o número de pontos utilizados no processamento"""
        
        #Obtendo a opção de processamento 
        op = self.op_norma
        
        #Atualizando a tabela
        
        if (op==0) or (op==3) or (op==6) or (op==7): #2D
            
            #Montando uma lista que será a base da tabela 
            table = [[fMedia(dx), fMedia(dy),'-', fMedia(d2D), '-'],
                     [fMediana(dx), fMediana(dy), '-', fMediana(d2D), '-'],
                     [fMinimo(dx), fMinimo(dy), '-', fMinimo(d2D), '-'],
                     [fMaximo(dx), fMaximo(dy), '-', fMaximo(d2D), '-'],
                     [fDevPad(dx), fDevPad(dy), '-', fDevPad(d2D), '-'],
                     [fRms(dx), fRms(dy), '-', fRms(d2D), '-'],
                     [fCalcQ1(dx), fCalcQ1(dy), '-', fCalcQ1(d2D), '-'],
                     [fCalcQ3(dx), fCalcQ3(dy), '-', fCalcQ3(d2D), '-'],  
                     [fCalcMAD(dx), fCalcMAD(dy), '-', fCalcMAD(d2D), '-']] 
            
            #Preenchendo os valores da tabela 
            #Preenchendo o número de pontos e o número de outliers
            for j in range(5):
                
                #Preenchendo os pontos utilizados 
                if j == 2:
                    self.dlg.tableWidget_2.setItem(0, j, QTableWidgetItem('-'))
                
                elif j ==4:
                
                    self.dlg.tableWidget_2.setItem(0, j, QTableWidgetItem('-'))
                
                else:
                    
                    self.dlg.tableWidget_2.setItem(0, j, QTableWidgetItem(str(pts_utilizados)))
                
                #Preenchendo os outliers
                if j == 3:
                    
                    self.dlg.tableWidget_2.setItem(10, j, QTableWidgetItem(str(dict_outliers['var_qtd_outliers_2D'])))
                    
                else:
                    
                    self.dlg.tableWidget_2.setItem(10, j, QTableWidgetItem('-'))
                    
                    
            #Preenchendo os valores da tabela 
            for i in range(len(table)):
            
                for j in range(5):
                    
                    if (j!=2) and (j!=4):
                        
                        item = f"{table[i][j]:.3f}"
                        self.dlg.tableWidget_2.setItem(i+1, j, QTableWidgetItem(item))
                    
                    else:
                        self.dlg.tableWidget_2.setItem(i+1, j, QTableWidgetItem(str(table[i][j])))
            

        elif (op==1) or (op==4) or (op==8): #Z
            
            #Montando uma lista que será a base da tabela 
            
            table = [[ '-', '-',fMedia(dz), '-', '-'],
                     [ '-', '-', fMediana(dz), '-', '-'],
                     [ '-', '-', fMinimo(dz) , '-', '-'],
                     [ '-', '-', fMaximo(dz), '-', '-'],
                     [ '-', '-', fDevPad(dz), '-', '-'],
                     [ '-', '-', fRms(dz), '-', '-'],
                     [ '-', '-', fCalcQ1(dz), '-', '-'],
                     [ '-', '-', fCalcQ3(dz), '-', '-'],  
                     [ '-', '-', fCalcMAD(dz), '-', '-']] 
        
            #Preenchendo o número de pontos e o número de outliers
            for j in range (5):
                
                if j == 2:
                    
                    self.dlg.tableWidget_2.setItem(0, j, QTableWidgetItem(str(pts_utilizados)))
                    self.dlg.tableWidget_2.setItem(10, j, QTableWidgetItem(str(dict_outliers['var_qtd_outliers_Z'])))
                
                else:
                    
                    self.dlg.tableWidget_2.setItem(0, j, QTableWidgetItem('-'))
                    self.dlg.tableWidget_2.setItem(10, j, QTableWidgetItem('-'))
            
            #Preenchendo os valores da tabela 
            
            for i in range(len(table)):
            
                for j in range(5):
                    
                    if j ==2:
                        item = f"{table[i][j]:.3f}"
                        self.dlg.tableWidget_2.setItem(i+1, j, QTableWidgetItem(item))
                    
                    else:
                        self.dlg.tableWidget_2.setItem(i+1, j, QTableWidgetItem(str(table[i][j])))
        
        else: #2D e Z
            
            #Construindo uma lista que será a base da tabela 
            
            table = [[fMedia(dx), fMedia(dy), fMedia(dz), fMedia(d2D), fMedia(d3D)],
                     [fMediana(dx), fMediana(dy), fMediana(dz), fMediana(d2D), fMediana(d3D)],
                     [fMinimo(dx), fMinimo(dy), fMinimo(dz), fMinimo(d2D), fMinimo(d3D)],
                     [fMaximo(dx), fMaximo(dy), fMaximo(dz), fMaximo(d2D), fMaximo(d3D)],
                     [fDevPad(dx), fDevPad(dy), fDevPad(dz), fDevPad(d2D), fDevPad(d3D)],
                     [fRms(dx), fRms(dy), fRms(dz), fRms(d2D), fRms(d3D)],
                     [fCalcQ1(dx), fCalcQ1(dy), fCalcQ1(dz), fCalcQ1(d2D), fCalcQ1(d3D)],
                     [fCalcQ3(dx), fCalcQ3(dy), fCalcQ3(dz), fCalcQ3(d2D), fCalcQ3(d3D)],  
                     [fCalcMAD(dx), fCalcMAD(dy), fCalcMAD(dz), fCalcMAD(d2D), fCalcMAD(d3D)]] 
        
            
            #Preenchendo o número de pontos e o número de outliers
            for j in range(5):
                
                #Preenchendo o número de pontos
                self.dlg.tableWidget_2.setItem(0, j, QTableWidgetItem(str(pts_utilizados)))
                
                #Preenchendo o número de outliers
                if j == 2:
                    
                    self.dlg.tableWidget_2.setItem(10, j, QTableWidgetItem(str(dict_outliers['var_qtd_outliers_Z'])))
                    
                elif j==3:
                    self.dlg.tableWidget_2.setItem(10, j, QTableWidgetItem(str(dict_outliers['var_qtd_outliers_2D'])))
                    
                else:
                    
                    self.dlg.tableWidget_2.setItem(10, j, QTableWidgetItem('-'))
                    
                
            #Preenchendo os valores da tabela     
            for i in range(len(table)):
            
                for j in range(5):
                    
                    item = f"{table[i][j]:.3f}"
                    self.dlg.tableWidget_2.setItem(i+1, j, QTableWidgetItem(item))
                    
    def funcao_teste(self,data):
        """Este método atualiza a tabela discrepâncias, e tem como parâmetro a estrutura de dados com as discrepâncias """
       
        #Desempacotando os dados de discrepâncias 
        dx, dy, dz = fDiscrepancia(data)
        #Calculando as discrepâncias 2D e 3D e azimutes das discrepâncias
        d2D = fDiscrepancia2D(dx, dy)
        d3D = fDiscrepancia3D(dx, dy, dz)
        azimutes2D = fAzimute2D(dx,dy)
        #Obtendo o número de linhas da tabela e setando esse número de linhas   
        tam = len(dx.keys())   
        self.dlg.tableWidget_11.setRowCount(tam)
        
        #Obtendo a opção de processamento
        op = self.dlg.comboBox_4.currentIndex()
        
        #Atualizando a tabela de discrepâncias 
        
        if (op==0) or (op==3) or (op==6) or (op==7): #2D
            
            #Calculando os outliers e atualizando a aba de outliers
            metodo, tolerancia, outliers = self.outlier(d2D,1)
            self.atualizaOutlier(metodo, [tolerancia, str(len(outliers))], 0)    
            #Deixando a barra de progresso visível 
            self.dlg.progressBar.setVisible(True)

            
            i = 0
            #Criando um for para inserir linha por linha da tabela
            for pt in itera(dx):
                
                #Calculando a atualizaação da barra de progresso
                aument = math.ceil((i / len(dx))*100)
                # Atualiza o valor do progress bar para o valor atual da iteração
                self.dlg.progressBar.setValue(aument)

                # Força a atualização da interface gráfica para exibir o progresso atual
                QApplication.processEvents()
                
                #Atualizando a tabela de discrepâncias
                self.dlg.tableWidget_11.setVerticalHeaderItem(i, QTableWidgetItem(""))
                self.dlg.tableWidget_11.setItem(i, 0, QTableWidgetItem(str(pt)))
                self.dlg.tableWidget_11.setItem(i, 1, QTableWidgetItem(f"{dx[pt]:.3f}"))
                self.dlg.tableWidget_11.setItem(i, 2, QTableWidgetItem(f"{dy[pt]:.3f}"))
                self.dlg.tableWidget_11.setItem(i, 3, QTableWidgetItem("-"))
                self.dlg.tableWidget_11.setItem(i, 4, QTableWidgetItem(f"{d2D[pt]:.3f}"))
                self.dlg.tableWidget_11.setItem(i, 5, QTableWidgetItem("-"))
            
                self.dlg.tableWidget_11.setItem(i, 6, QTableWidgetItem(f"{azimutes2D[pt]:.3f}"))
                out = False
                
                #Atualizando a parte de outliers da tabela 
                if pt in outliers:
                
                    out = True
                    self.dlg.tableWidget_11.setItem(i, 7, QTableWidgetItem('Sim'))
            
                else:
                
                    self.dlg.tableWidget_11.setItem(i, 7, QTableWidgetItem('Não'))
                
                
                # Criando e preenchendo o ComboBox de escolha de excluir os pontos
                combo_box = QComboBox()
                combo_box.addItems([" ", "Sim"])
                combo_box.setCurrentIndex(0)  # Define o índice selecionado inicialmente, ou seja, "Não excluir"
            
                # Define o ComboBox como editor de célula para a coluna desejada (índice 8)
                self.dlg.tableWidget_11.setCellWidget(i, 8, combo_box)
                
                #Mudando a cor da linha para ciano caso a discrepância seja outlier 
                #Criando a cor, ciano
                light_cyan_color = QColor(100, 255, 255) 
                ciano_brush = QBrush(light_cyan_color)
            
                for j in range(self.dlg.tableWidget_11.columnCount()):
                
                    if out:
                        if j != 8: #Quando não é o comboBox
                        
                            self.dlg.tableWidget_11.item(i, j).setBackground(ciano_brush)

                        else: #Quando é o comboBox
                            widget = self.dlg.tableWidget_11.cellWidget(i, j)
                            widget.setStyleSheet("background-color: rgb(100, 235, 235);")
                
                    else:
                    
                            pass
            
                #Conectando o comboBox ao signal de mudança de cor da linha caso o usuário escolha excluir a discrepância
                #Obtendo a posição do comboBox na linha
                row = i
                n = self.dlg.tableWidget_11.columnCount() - 1
                combo_box = self.dlg.tableWidget_11.cellWidget(row, n)  # Assume-se que o combo box está na coluna 8
                #Realizando a conexão com a função de atualizar a cor da linha
                combo_box.currentIndexChanged.connect(lambda index, row=row, out=out: self.atualizar_cor_linha(index, row, out))

                i = i+1 #aumentando o valor da iteração
            
            #Ao final do for, a barra de progresso deixa de aparecer, fica invisivel
            self.dlg.progressBar.setVisible(False)
            
        elif (op==1) or (op==4) or (op==8): #Z
            
            #Calculando os outliers e atualizando a aba de outliers
            metodo, tolerancia, outliers = self.outlier(dz,2)
            self.atualizaOutlier(metodo, 0, [tolerancia, str(len(outliers))])
            #Deixando a barra de progresso visível 
            self.dlg.progressBar.setVisible(True)
            
            i = 0
            #Criando um for para inserir linha por linha da tabela
            for pt in itera(dz):
                
                #Calculando a atualização da barra de progresso
                aument = math.ceil((i / len(dz))*100)
                # Atualiza o valor do progress bar para o valor atual da iteração
                self.dlg.progressBar.setValue(aument)
                # Força a atualização da interface gráfica para exibir o progresso atual
                QApplication.processEvents()
                
                #Atualizando a tabela de discrepâncias 
                #Tirando os labels das linhas
                self.dlg.tableWidget_11.setVerticalHeaderItem(i, QTableWidgetItem(""))
                #Prenchendo as colunas
                self.dlg.tableWidget_11.setItem(i, 0, QTableWidgetItem(str(pt)))
                self.dlg.tableWidget_11.setItem(i, 1, QTableWidgetItem("-"))
                self.dlg.tableWidget_11.setItem(i, 2, QTableWidgetItem("-"))
                self.dlg.tableWidget_11.setItem(i, 3, QTableWidgetItem(f"{dz[pt]:.3f}"))
                self.dlg.tableWidget_11.setItem(i, 4, QTableWidgetItem("-"))
                self.dlg.tableWidget_11.setItem(i, 5, QTableWidgetItem("-"))
            
                self.dlg.tableWidget_11.setItem(i, 6, QTableWidgetItem("-"))
                out = False
                
                #Atualizando a parte de outliers da tabela 
                if pt in outliers:
                
                    out = True
                    self.dlg.tableWidget_11.setItem(i, 7, QTableWidgetItem('Sim'))
            
                else:
                
                    self.dlg.tableWidget_11.setItem(i, 7, QTableWidgetItem('Não'))
                
                
                #Criando e preenchendo o ComboBox de escolha de excluir os pontos
                combo_box = QComboBox()
                combo_box.addItems([" ", "Sim"])
                combo_box.setCurrentIndex(0)  #Define o índice selecionado inicialmente, ou seja, "Não excluir"
            
                # Define o ComboBox como editor de célula para a coluna desejada (índice 8)
                self.dlg.tableWidget_11.setCellWidget(i, 8, combo_box)
                
                #Mudando a cor da linha para ciano caso a discrepância seja outlier 
                #Criando a cor, ciano
                light_cyan_color = QColor(100, 255, 255)
                ciano_brush = QBrush(light_cyan_color)
            
                for j in range(self.dlg.tableWidget_11.columnCount()):
                
                    if out:
                        if j != 8: #Quando não é o comboBox

                            self.dlg.tableWidget_11.item(i, j).setBackground(ciano_brush)

                        else: #Quando é o comboBox
                            widget = self.dlg.tableWidget_11.cellWidget(i, j)
                            widget.setStyleSheet("background-color: rgb(100, 235, 235);")
                
                    else:
                    
                            pass
            
                #Conectando o comboBox ao signal de mudança de cor da linha caso o usuário escolha excluir a discrepância
                #Obtendo a posição do comboBox na linha
                row = i
                n = self.dlg.tableWidget_11.columnCount() - 1
                combo_box = self.dlg.tableWidget_11.cellWidget(row, n)  # Assume-se que o combo box está na coluna 8
                #Realizando a conexão com a função de atualizar a cor da linha
                combo_box.currentIndexChanged.connect(lambda index, row=row, out=out: self.atualizar_cor_linha(index, row, out))

            
                i = i+1 #Aumentando o valor da iteração
            
            #Ao final do for, a barra de progresso deixa de aparecer, fica invisivel
            self.dlg.progressBar.setVisible(False)
            
        else: #2D e Z 
            
            #Calculando os outliers e atualizando a aba de outliers
            metodo, tolerancia_2D, outliers_2D = self.outlier(d2D,1)
            metodo, tolerancia_Z, outliers_Z = self.outlier(dz,2)
            self.atualizaOutlier(metodo, [tolerancia_2D, str(len(outliers_2D))], [tolerancia_Z, str(len(outliers_Z))])
            #Deixando a barra de progresso visível
            self.dlg.progressBar.setVisible(True)
            
            i = 0
            #Criando um for para inserir linha por linha da tabela
            for pt in itera(dx):
                
                #Calculando a atualização da barra de progresso
                aument = math.ceil((i / len(dx))*100)
                # Atualiza o valor do progress bar para o valor atual da iteração
                self.dlg.progressBar.setValue(aument)
                # Força a atualização da interface gráfica para exibir o progresso atual
                QApplication.processEvents()
                
                #Atualizando a tabela de discrepâncias
                #Tirando os labels das linhas
                self.dlg.tableWidget_11.setVerticalHeaderItem(i, QTableWidgetItem(""))
                #Preenchendo as tabelas
                self.dlg.tableWidget_11.setItem(i, 0, QTableWidgetItem(str(pt)))
                self.dlg.tableWidget_11.setItem(i, 1, QTableWidgetItem(f"{dx[pt]:.3f}"))
                self.dlg.tableWidget_11.setItem(i, 2, QTableWidgetItem(f"{dy[pt]:.3f}"))
                self.dlg.tableWidget_11.setItem(i, 3, QTableWidgetItem(f"{dz[pt]:.3f}"))
                self.dlg.tableWidget_11.setItem(i, 4, QTableWidgetItem(f"{d2D[pt]:.3f}"))
                self.dlg.tableWidget_11.setItem(i, 5, QTableWidgetItem(f"{d3D[pt]:.3f}"))
            
                self.dlg.tableWidget_11.setItem(i, 6, QTableWidgetItem(f"{azimutes2D[pt]:.3f}"))
                out = False
                
                #Atualizando a parte de outliers da tabela
                if (pt in outliers_2D) or (pt in outliers_Z):
                
                    out = True
                    self.dlg.tableWidget_11.setItem(i, 7, QTableWidgetItem('Sim'))
            
                else:
                
                    self.dlg.tableWidget_11.setItem(i, 7, QTableWidgetItem('Não'))
                
                
                #Criando e preenchendo o ComboBox de escolha de excluir os pontos
                combo_box = QComboBox()
                combo_box.addItems([" ", "Sim"])
                combo_box.setCurrentIndex(0)  #Define o índice selecionado inicialmente, ou seja, "Não excluir"
            
                # Define o ComboBox como editor de célula para a coluna desejada (índice 8)
                self.dlg.tableWidget_11.setCellWidget(i, 8, combo_box)
                
                #Mudando a cor da linha para ciano caso a discrepância seja outlier 
                #Criando a cor, ciano            
                light_cyan_color = QColor(100, 255, 255)
                ciano_brush = QBrush(light_cyan_color)
            
                for j in range(self.dlg.tableWidget_11.columnCount()):
                
                    if out:
                        if j != 8: #Quando não é o comboBox

                            self.dlg.tableWidget_11.item(i, j).setBackground(ciano_brush)

                        else: #Quando é o comboBox
                            widget = self.dlg.tableWidget_11.cellWidget(i, j)
                            widget.setStyleSheet("background-color: rgb(100, 235, 235);")
                
                    else:
                    
                            pass
            
                #Conectando o comboBox ao signal de mudança de cor da linha caso o usuário escolha excluir a discrepância
                #Obtendo a posição do comboBox na linha
                row = i
                n = self.dlg.tableWidget_11.columnCount() - 1
                combo_box = self.dlg.tableWidget_11.cellWidget(row, n)  # Assume-se que o combo box está na coluna 8
                #Realizando a conexão com a função de atualizar a cor da linha
                combo_box.currentIndexChanged.connect(lambda index, row=row, out=out: self.atualizar_cor_linha(index, row, out))

                i = i+1 #Aumentando o valor da iteração
            
            #Ao final do for, a barra de progresso deixa de aparecer, fica invisivel                    
            self.dlg.progressBar.setVisible(False)  
            #fim do else
            
    def testeOutlier(self):
        """Este método testa se o usuário digitou um valor número válido para o fator 3sigma ou boxplot"""
        
        #Obtendo a opção de processamento de outlier, 3sigma ou boxplot
        op = self.dlg.comboBox_6.currentIndex()
        
        #Tenta fazer a conversão para float, se der certo, retorna "False", não deu erro
        #Se der erro, retorna "True", deu erro 
        
        try:
        
            if op ==0: #3sigma
                fator_3_sigma = float(self.dlg.lineEdit.text())
                
            else: #boxplot
                fator_box_plot = float(self.dlg.lineEdit_2.text())
            
            return False,'falso'
            
        except:
            
            mensagem = 'Dados incoerentes. Digite um valor númérico válido para os parâmetros de detecção de outlier'
            return True, mensagem
                        
    def testeEscala(self):
        """Este método testa se o usuário digitou um valor número válido para a escala 2D e Z e para as precisões da NBR 13133"""
        
        #Obtendo a opção de processamento do usuário
        op = self.dlg.comboBox_4.currentIndex()
        
        #Testando se os valores são válidos a depender da norma escolhida
        
        if (op == 3) or (op==4) or (op ==5): #NBR 13133
            
            #Tenta fazer a conversão para float, se der certo, retorna "False", não deu erro
            #Se der erro, retorna "True", deu erro 
            try:
                
                if op ==3: #2D
                    
                    p_pla = float(self.dlg.lineEdit_4.text())
                
                elif op==4: #Z
                    p_alt = float(self.dlg.lineEdit_5.text())
                    
                else: #2D e Z
                
                    p_pla = float(self.dlg.lineEdit_4.text())
                    p_alt = float(self.dlg.lineEdit_5.text())
                
                
                return False, 'falso'
            
            except:
                
                mensagem = 'Dados incoerentes. Digite um valor numérico válido para a precisão'               
                return True, mensagem  
              
              
        else: # DEMAIS NORMAS
            
            #Tenta fazer a conversão para float, se der certo, retorna "False", não deu erro
            #Se der erro, retorna "True", deu erro
            try:
                
                if (op==0) or (op==6) or (op==7): #2D
                    esc_pla = float(self.dlg.comboBox_3.currentText())
                    
                elif (op==1) or (op==8): #Z
                    esc_alt = float(self.dlg.comboBox_5.currentText())
                    
                else: #2D e Z
                    esc_pla = float(self.dlg.comboBox_3.currentText())
                    esc_alt = float(self.dlg.comboBox_5.currentText())
            
                return False, 'falso'
            
            except:
                
                mensagem = 'Dados incoerentes. Digite um valor numérico válido para a escala'
                return True, mensagem 
                               
    def verifica_erro(self):
        """Este método verifica se há alguma incoerencia nos valores digitados para a escala ou para os fatores de outliers"""
        
        #Chamando os métodos que testam a escala e os fatores para os outliers
        return_out, mensagem_out = self.testeOutlier()
        return_esc, mensagem_esc = self.testeEscala()
        
        #Verificando se há incoerencia na escala e nos fatores para os outliers
        #Caso haver entra no if ou no elif, e retorna False e exibe mensagem de erro, se não, entra no else e retorna True
        
        if return_esc: #Incoerencia nos valores de escala 
            
            self.show_messagebox_erro('erro', mensagem_esc)
            return False
        
        elif return_out: #Incoerencia nos valores dos fatores para o boxplot
        
            self.show_messagebox_erro('erro', mensagem_out)
            return False
            
        else: #Não há incoerencias
        
            return True
        
    def visibleTables(self, op):
        """Este método desabilita e habilita as tabelas de discrepância, estátisticas e os gráficos que aparecem na parte inferior da interface gráfica"""
        
        #Se a opção é igual "1", os componetes ficam habilitados, se não, ficam desabilitados 
        
        if op == 1:
            
            #Tabelas e gráficos e seus labels
            self.dlg.tableWidget_11.setVisible(True)
            self.dlg.tableWidget_2.setVisible(True)
            self.dlg.graphicsView_2.setVisible(True)
            self.dlg.label_17.setVisible(True)
            self.dlg.label_19.setVisible(True)
            self.dlg.label_18.setVisible(True)
            self.dlg.tabWidget_9.setVisible(True)
            
            #Labels de número de pontos utilizados
            self.dlg.label_154.setVisible(False)
            self.dlg.label_155.setVisible(False)
        
        else:
            
            #Tabelas e gráficos e seus labels
            self.dlg.tableWidget_11.setVisible(False)
            self.dlg.tableWidget_2.setVisible(False)
            self.dlg.graphicsView_2.setVisible(False)
            self.dlg.label_17.setVisible(False)
            self.dlg.label_19.setVisible(False)
            self.dlg.label_18.setVisible(False)
            self.dlg.tabWidget_9.setVisible(False)
            
            #Labels de número de pontos utilizados
            self.dlg.label_154.setVisible(False)
            self.dlg.label_155.setVisible(False)
            
    def clearTables(self):
        """Este método limpa a tabela de discrepancias e estátisticas e cria uma nova tabela vazia"""
        
        #Limpando a tabela de discrepâncias
        self.dlg.tableWidget_11.clear()
        #Definindo os cabeçalhos das colunas
        headers = ["ID", "dX", "dY", "dZ", "d2D", "d3D", "Azim.2D", "Outlier", "Excluir?"]
        self.dlg.tableWidget_11.setColumnCount(len(headers))
        self.dlg.tableWidget_11.setRowCount(0)
        self.dlg.tableWidget_11.setHorizontalHeaderLabels(headers)
        
        #Definindo um estilo para os cabeçalhos da tabela (em negrito)
        header_font = QFont()
        header_font.setBold(True)
        self.dlg.tableWidget_11.horizontalHeader().setFont(header_font)
        
        #Limpando a tabela de estátisticas
        self.dlg.tableWidget_2.clear()
        #Definindo os cabeçalhos das colunas
        headers = ["dX", "dY", "dZ", "d2D", "d3D"]
        self.dlg.tableWidget_2.setColumnCount(len(headers))
        self.dlg.tableWidget_2.setHorizontalHeaderLabels(headers)
        
        #Definindo um estilo para os cabeçalhos da tabela (em negrito)
        self.dlg.tableWidget_2.horizontalHeader().setFont(header_font)
        
        # Definindo os cabeçalhos das linhas
        headers = ["nº de pontos (n)","média", "mediana", "mín.", 'máx.', 'desv.padrão (S)', 'RMS', 'Q1', 'Q3', 'MAD', "nº de outliers"]
        self.dlg.tableWidget_2.setRowCount(len(headers))
        self.dlg.tableWidget_2.setVerticalHeaderLabels(headers)
            
        #Definindo um estilo para os cabeçalhos da tabela (em negrito)
        self.dlg.tableWidget_2.verticalHeader().setFont(header_font)
        
        #Deixando os labels de pontos invisisiveis    
        self.dlg.label_154.setVisible(False)
        self.dlg.label_155.setVisible(False)
        
        #Deixando as tabelas invisíveis, e deixando as demais abas do programa  desabilitadas
        self.visibleTables(2)
        self.trava_tabs()

    def opcaoExcluir(self,data):
        """Este método cria um conjunto com os pontos que foram marcados para excluir, pergunta a o usuário se quer mesmo excluir os pontos e retorna a opção do usário e o conjunto de pontos"""
        
        #Definindo um conjunto vazio para os pontos a serem excluidos
        pontos_excluir = set() 
        
        #Fazendo um for para analisar linha por linha da coluna se o ponto foi marcado como excluir
        i = 0           
        for pt in data.keys():
            
            #Obtendo o comboBox de excluir e o seu indice selecionado
            row = i
            n = self.dlg.tableWidget_11.columnCount() - 1
            combo_box = self.dlg.tableWidget_11.cellWidget(row, n)
            index = combo_box.currentIndex()
            
            #Se o indice é igual a "1", o ponto foi marcado como excluir e deve ser adicionado ao conjunto de pontos
            if (index==1):                     
                pontos_excluir.add(pt)
            
            else:
                pass
                           
            i = i+1 #Aumentando o i do indice 
            #Fim do for
        
        #Obtendo o número de pontos marcados como excluir e exibindo a mensagem ao usuário
        pontos = len(pontos_excluir) 
        opcao = self.showMessageBox( pontos)    
        
        #Retornando o número de pontos marcados como excluir e a opção escolhida pelo usuário no messagebox
        resultado =(opcao,pontos_excluir)
        return resultado
    
    def obterDisc(self, data, pontos_excluir):
        """Este método exclui os pontos marcados como excluir dos dados de discrepâncias"""
        
        #Calculando as discrepâncias 
        dx, dy, dz = fDiscrepancia(data)
        d2D = fDiscrepancia2D(dx, dy)
        d3D = fDiscrepancia3D(dx, dy, dz)
        copia_dx = dx.copy()
        
        #Realizando um for para deletar os pontos marcados como excluir 
        for pt in copia_dx.keys():
                        
            if pt in pontos_excluir: #Ponto está incluso no conjunto de pontos para ser excluidos
                            
                del dx[pt]
                del dy[pt]
                del dz[pt]
                del d2D[pt]
                del d3D[pt]
            
            else:
                pass
        
        #Retornando as discrepâncias sem os pontos marcados para serem excluidos 
        return dx, dy, dz, d2D, d3D
    
    def atulizaPtsExcluidos(self, data, pontos_excluir):
        """Este método atualiza o comboBox de excluir dos pontos marcados para serem excluidos"""
        
        #Fazendo um for para atualizar os pontos marcados como excluir 
        #Os pontos não são utilizados nos cálculos mas são exibidos na tabela de discrepâncias
        
        #Fazendo um for para atualizar o comboBox dos pontos marcados como excluir 
        i = 0
        for pt in itera(data):
                        
            if pt in pontos_excluir: #Ponto marcado como excluir
                
                #Obtendo o comboBox e atualizando o indice
                row = i
                n = self.dlg.tableWidget_11.columnCount() - 1
                combo_box = self.dlg.tableWidget_11.cellWidget(row, n)
                combo_box.setCurrentIndex(1)

                
            else: #Ponto não foi marcado como excluir
                pass
                
            i = i+1 #Aumentando o i que será usado como indice
    
    def enableEscala(self, op):
        """Este método deixa os componentes de escala visiveis ou invisiveis a depender da opção escolhida pelo usuário"""
        
        #Habilitando os componentes a depender da opção de processamento escolhida pelo usuário
        
        if (op == 3) or (op == 4) or (op == 5): #NBR 13133
            
            if (op == 3): #2D
                
                self.dlg.lineEdit_4.setEnabled(True)
                self.dlg.lineEdit_5.setEnabled(False)
                self.dlg.comboBox_3.setEnabled(False)
                self.dlg.comboBox_5.setEnabled(False)
                
                self.dlg.label_27.setEnabled(True)
                self.dlg.label_28.setEnabled(False)
                self.dlg.label_4.setEnabled(False)
                self.dlg.label_6.setEnabled(False)
                
            elif (op == 4): #Z
                
                self.dlg.lineEdit_4.setEnabled(False)
                self.dlg.lineEdit_5.setEnabled(True)
                self.dlg.comboBox_3.setEnabled(False)
                self.dlg.comboBox_5.setEnabled(False)
                
                self.dlg.label_27.setEnabled(False)
                self.dlg.label_28.setEnabled(True)
                self.dlg.label_4.setEnabled(False)
                self.dlg.label_6.setEnabled(False)
            
            else: #2D e Z
                
                self.dlg.lineEdit_4.setEnabled(True)
                self.dlg.lineEdit_5.setEnabled(True)
                self.dlg.comboBox_3.setEnabled(False)
                self.dlg.comboBox_5.setEnabled(False)
                
                self.dlg.label_27.setEnabled(True)
                self.dlg.label_28.setEnabled(True)
                self.dlg.label_4.setEnabled(False)
                self.dlg.label_6.setEnabled(False)
                
        else: #Demais normas
            
            if (op == 0) or (op == 6) or (op == 7): #2D
                
                self.dlg.lineEdit_4.setEnabled(False)
                self.dlg.lineEdit_5.setEnabled(False)
                self.dlg.comboBox_3.setEnabled(True)
                self.dlg.comboBox_5.setEnabled(False)
                
                self.dlg.label_27.setEnabled(False)
                self.dlg.label_28.setEnabled(False)
                self.dlg.label_4.setEnabled(True)
                self.dlg.label_6.setEnabled(False)
                
            elif (op == 1) or (op == 8): #Z
                
                self.dlg.lineEdit_4.setEnabled(False)
                self.dlg.lineEdit_5.setEnabled(False)
                self.dlg.comboBox_3.setEnabled(False)
                self.dlg.comboBox_5.setEnabled(True)
                
                self.dlg.label_27.setEnabled(False)
                self.dlg.label_28.setEnabled(False)
                self.dlg.label_4.setEnabled(False)
                self.dlg.label_6.setEnabled(True)
            
            else: #2D e Z
                
                self.dlg.lineEdit_4.setEnabled(False)
                self.dlg.lineEdit_5.setEnabled(False)
                self.dlg.comboBox_3.setEnabled(True)
                self.dlg.comboBox_5.setEnabled(True)
                
                self.dlg.label_27.setEnabled(False)
                self.dlg.label_28.setEnabled(False)
                self.dlg.label_4.setEnabled(True)
                self.dlg.label_6.setEnabled(True)
                   
    def enableOutlier(self, op):
        """Este método deixa os componentes de oultliers visiveis ou invisiveis a depender da opção escolhida pelo usuário"""       
        
        #Habilitando ou desabilitando os componentes a depender da opção de processamento escolhida pelo usuário
        #ativa o 3 sigma e desabilita o boxplot
        
        if (op==0): 
            
            self.dlg.lineEdit.setEnabled(True)
            self.dlg.comboBox_7.setEnabled(True)
            
            self.dlg.label_22.setEnabled(True)
            self.dlg.label_31.setEnabled(True)
            self.dlg.label_88.setEnabled(True)
            
            self.dlg.label_23.setEnabled(False)
            self.dlg.label_24.setEnabled(False)
            self.dlg.lineEdit_2.setEnabled(False)
        
        else: #ativa o box plot e desabilita o 3 sigma
            
            self.dlg.lineEdit.setEnabled(False)
            self.dlg.comboBox_7.setEnabled(False)
            
            self.dlg.label_22.setEnabled(False)
            self.dlg.label_31.setEnabled(False)
            self.dlg.label_88.setEnabled(False)
            
            self.dlg.label_23.setEnabled(True)
            self.dlg.label_24.setEnabled(True)
            self.dlg.lineEdit_2.setEnabled(True)

    def enable_estatisticas_ANM(self, op):
        """Este método trava as opções de normalidade e tendencia caso a norma escolhida seja a ANM"""
        
        if (op == 7) or (op == 8) or (op == 9): #ANM
            
            self.dlg.comboBox_9.setCurrentIndex(2)
            self.dlg.comboBox_13.setCurrentIndex(1)
            self.dlg.radioButton_4.setChecked(True)
            
            self.dlg.comboBox_9.setEnabled(False)
            self.dlg.comboBox_13.setEnabled(False)
            self.dlg.radioButton_4.setEnabled(False)
            
        else: #Demais normas
            
            self.dlg.radioButton_4.setChecked(True)
            
            self.dlg.comboBox_9.setEnabled(True)
            self.dlg.comboBox_13.setEnabled(True)
            self.dlg.radioButton_4.setEnabled(True)
    
    def enable_outliers_NBR(self, op):
        """Este método trava a opção de outliers para o Boxplot caso a norma escolhida seja a NBR13133"""
      
        if (op ==3) or (op ==4) or (op ==5): #NBR
            
            self.dlg.comboBox_6.setCurrentIndex(1)
            self.dlg.comboBox_6.setEnabled(False)
        
        else: #Demais normas
            
            self.dlg.comboBox_6.setEnabled(True)
    
    def enable_opcao_processamento (self, op):
        """Este método habilita ou desabilita a opção de processamento pelo decreto ou pela metodologia Santos et al"""
        
        #Só pode usar a metodologia Santos et al, se o processamento for utilizando a norma da ETCQDG
        if not ((op ==0) or (op ==1) or (op ==2)): #Demais normas
            
            self.dlg.radioButton_2.setChecked(True)
            self.dlg.radioButton_3.setEnabled(False)
            
        else: #ET-CQDG
            
            self.dlg.radioButton_3.setEnabled(True)
            
    def configuracao_Interface(self):
        """Este método realiza as configurações iniciais da interface"""
        
        #setando a data atual no calendário
        data_atual = datetime.now()
        self.dlg.dateEdit.setDate(data_atual.date())
        
        #Configurando a visualização das opções de escala, de outlier, ANM e opção de processamento
        self.dlg.comboBox_4.currentIndexChanged.connect(lambda index: self.enableEscala(index))
        self.dlg.comboBox_4.currentIndexChanged.connect(lambda index: self.enable_estatisticas_ANM(index))
        self.dlg.comboBox_4.currentIndexChanged.connect(lambda index: self.enable_outliers_NBR(index))
        self.dlg.comboBox_4.currentIndexChanged.connect(lambda index: self.enable_opcao_processamento(index))      
        self.dlg.comboBox_6.currentIndexChanged.connect(lambda index: self.enableOutlier(index))
        
        #Setando a cor da barra de progresso como verde
        palette = QPalette()
        palette.setColor(QPalette.Highlight, Qt.green)
        self.dlg.progressBar.setPalette(palette)
        
        #Deixando a barra de progresso invisivel
        if self.processamento:
            self.dlg.progressBar.setVisible(False)
        else:
             pass
        
        #Setando o tamanho das tabelas do decreto
        self.dlg.tableWidget_5.setColumnWidth(2, 120)
        self.dlg.tableWidget_5.setColumnWidth(3, 100)
        
        self.dlg.tableWidget_6.setColumnWidth(2, 120)
        self.dlg.tableWidget_6.setColumnWidth(3, 100)
        
        self.dlg.tableWidget_9.setColumnWidth(2, 120)
        self.dlg.tableWidget_9.setColumnWidth(3, 100)
        
        self.dlg.tableWidget_21.setColumnWidth(2, 120)
        self.dlg.tableWidget_21.setColumnWidth(3, 100)
        
        self.dlg.tableWidget_22.setColumnWidth(2, 120)
        self.dlg.tableWidget_22.setColumnWidth(3, 100)
        
        
        #Configurando as tabelas para não serem editáveis, ou seja, o usuário não pode apagar os valores da tabela
        
        self.dlg.tableWidget_11.setEditTriggers(QAbstractItemView.NoEditTriggers)   
        self.dlg.tableWidget_2.setEditTriggers(QAbstractItemView.NoEditTriggers)
        
        self.dlg.tableWidget_3.setEditTriggers(QAbstractItemView.NoEditTriggers)
        self.dlg.tableWidget_4.setEditTriggers(QAbstractItemView.NoEditTriggers)
        self.dlg.tableWidget_5.setEditTriggers(QAbstractItemView.NoEditTriggers)
        self.dlg.tableWidget_6.setEditTriggers(QAbstractItemView.NoEditTriggers)
        
        self.dlg.tableWidget_19.setEditTriggers(QAbstractItemView.NoEditTriggers)
        self.dlg.tableWidget_20.setEditTriggers(QAbstractItemView.NoEditTriggers)
        self.dlg.tableWidget_21.setEditTriggers(QAbstractItemView.NoEditTriggers)
        self.dlg.tableWidget_22.setEditTriggers(QAbstractItemView.NoEditTriggers)
        
        self.dlg.tableWidget_7.setEditTriggers(QAbstractItemView.NoEditTriggers)
        self.dlg.tableWidget_9.setEditTriggers(QAbstractItemView.NoEditTriggers)
        
        self.dlg.tableWidget_12.setEditTriggers(QAbstractItemView.NoEditTriggers)
        self.dlg.tableWidget_14.setEditTriggers(QAbstractItemView.NoEditTriggers)
        
        self.dlg.tableWidget.setEditTriggers(QAbstractItemView.NoEditTriggers)
    
    def trava_tabs(self):
        """Este método deixa todas as demais abas do programa desabilitadas com execeção da aba inicial"""
        
        self.dlg.tabWidget.setTabEnabled(1, False)
        self.dlg.tabWidget.setTabEnabled(2, False)
        self.dlg.tabWidget.setTabEnabled(3, False)
        self.dlg.tabWidget.setTabEnabled(4, False)
        self.dlg.tabWidget.setTabEnabled(5, False)
        self.dlg.tabWidget.setTabEnabled(6, False)
        self.dlg.tabWidget.setTabEnabled(7, False)
        self.dlg.tabWidget.setTabEnabled(8, False)
        
    def iniciaInterface(self):
        """Este método inicia a interface do programa"""
        
        #Setando a aba inicial como corrente, travando as demais abas e deixando as tabelas invisiveis
        self.dlg.tabWidget.setCurrentIndex(0)
        self.trava_tabs()
        self.visibleTables(2)
       
        #Chamando os demais métodos de configuração da interface gráfica
        esc = self.dlg.comboBox_4.currentIndex()
        out = self.dlg.comboBox_6.currentIndex()
        
        self.enableEscala(esc)      
        self.enable_estatisticas_ANM(esc)
        self.enable_outliers_NBR(esc)
        self.enableOutlier(out)
        
    def atualizaInterface(self):
        """Este método atualiza a interface no momento do processamento"""
        
        #Travando as abas e obtendo a opção de processamento
        self.trava_tabs()
        op = self.op_norma      
        
        #Deixando habilitada a aba da opção de processamento escolhida pelo usuário
        
        if (op == 0) or (op == 1) or (op == 2): #ET CQDG
            
            self.dlg.tabWidget.setTabEnabled(1, True)
            self.dlg.tabWidget.setTabEnabled(5, True)
            self.dlg.tabWidget.setTabEnabled(6, True)
            self.dlg.tabWidget.setTabEnabled(7, True)
            self.dlg.tabWidget.setTabEnabled(8, True)
            
        elif (op == 3) or (op == 4) or (op == 5): # NBR 13133
            
            self.dlg.tabWidget.setTabEnabled(2, True)
            self.dlg.tabWidget.setTabEnabled(5, True)
            self.dlg.tabWidget.setTabEnabled(6, True)
            self.dlg.tabWidget.setTabEnabled(7, True)
            self.dlg.tabWidget.setTabEnabled(8, True)
        
        elif op == 6: #INCRA
            
            self.dlg.tabWidget.setTabEnabled(3, True)
            self.dlg.tabWidget.setTabEnabled(5, True)
            self.dlg.tabWidget.setTabEnabled(6, True)
            self.dlg.tabWidget.setTabEnabled(7, True)
            self.dlg.tabWidget.setTabEnabled(8, True)
        
        else: #ANM
            
            self.dlg.tabWidget.setTabEnabled(4, True)
            self.dlg.tabWidget.setTabEnabled(5, True)
            self.dlg.tabWidget.setTabEnabled(6, True)
            self.dlg.tabWidget.setTabEnabled(7, True)
            self.dlg.tabWidget.setTabEnabled(8, True)
        
        #Atualizando a aba de resumo 
        self.atualizaInterface_resumo()
        self.atualiza_interface_graficos()
        
    def processamento_PEC(self):
        """Este método controla todo o fluxo de processamento do programa com relação as normas, é a função principal """
        
        #Entra no if se for o primeiro processamento
        if self.processamento:
            
            #Obtendo os dados de discrepancias
            data, retorno = self.obt_data()
            if data: #Entra no if se conseguir obter os dados
                
                #Passando os dados para uma variável de dados geral
                self.data_geral = data
                #Calculando as discrepâncias
                dx, dy, dz = fDiscrepancia(data)
                d2D = fDiscrepancia2D(dx, dy)
                d3D = fDiscrepancia3D(dx, dy, dz)
                
                #Verificando se os dados de escala e fator para o boxplot são válidos
                
                if self.verifica_erro(): #Entra no if se os dados inserido pelo usuário são válidos
                    
                    #Obtendo a opção de processamento e passando para uma variável geral
                    self.op_norma = self.dlg.comboBox_4.currentIndex()
                    
                    #Atualizando a tabela de discrepâncias e deixando ela visivel
                    self.funcao_teste(data)
                    self.visibleTables(1)
                    
                    #Processamento as normas, normalidade e tendencia
                    self.proc_normas(dx, dy, dz, d2D)
                    self.normalidade(dx,dy,dz,d2D,d3D)
                    self.tendencia(dx, dy, dz)
                    
                    #Atualizando o número de pontos e pontos excluidos
                    pts_total = len(data)
                    self.dlg.label_154.setVisible(True)
                    self.dlg.label_155.setVisible(True)
                    self.dlg.label_155.setText(f"Nº Pts Total: {pts_total}")
                    self.dlg.label_154.setText(f"Nº Pts Excluídos do cálculo: 0")
                              
                    #atualizando as variaveis de controle de processamento
                    self.processamento = False
                    self.c_nome_teste = self.dlg.comboBox.currentText()
                    self.c_nome_referencia = self.dlg.comboBox_2.currentText()
                    
                    #atualizando as variaveis do relatório
                    self.var_pts_inseridos_relatorio = len(data)
                    self.var_pts_utilizados_relatorio = len(data)
                    
                    #Preenchendo a tabela de estatisticas
                    dict_outliers =  self.get_Outliers_relatorio(data)
                    self.preenche_table(dx,dy,dz,d2D,d3D,dict_outliers,self.var_pts_utilizados_relatorio )
                    
                    #Atualizando as variaveis de relatorio
                    self.dados_relatorio = (dx, dy, dz, d2D, d3D, data)                   
                    self.pontos_excluidos_relatorio = set()                 
                    self.getMetodologia_relatorio()

                    #Atualizando a interface
                    self.atualizaInterface()
                    
                    #Mensagem de processamento concluído para o usuário
                    self.iface.messageBar().pushMessage("Processamento Concluido")
                    
                else: #Entra no else se os dados inseridos pelo usuário não são válidos
                    pass
            else: #Entra no else se não conseguir obter os dados
                
                if retorno ==1:
                
                    self.show_messagebox_erro('erro', 'Não há camadas suficientes para realizar o processamento!')
                    self.clearTables() #Limpando as tabelas da aba inicial
                
                elif retorno == 2:

                    self.show_messagebox_erro('erro', 'O SRC das camadas são diferentes! realize a compatibilização de referencial')
                    self.clearTables() #Limpando as tabelas da aba inicial
                    
                else:
                
                    self.show_messagebox_erro('erro', 'O conjunto de dados é menor do que 3 pontos!')
                    self.clearTables() #Limpando as tabelas da aba inicial
            
        else: # cai aqui a partir do segundo processamento
            
            #Obtendo os dados de discrepancias
            data, retorno = self.obt_data()
            
            if data: #Entra no if se conseguir obter os dados
                
                #Verificando se os dados de escala e fator para o boxplot são válidos
                
                if self.verifica_erro(): #Entra no if se os dados inserido pelo usuário são válidos
                
                    #entra no if se as layers forem iguais a do último processamento e a tabela não for vazia
                    #Obtendo o número de linhas da tabela de discrepancias
                    num_linhas = self.dlg.tableWidget_11.rowCount()
                
                    if (self.c_nome_teste == self.dlg.comboBox.currentText()) and (self.c_nome_referencia == self.dlg.comboBox_2.currentText()) and (num_linhas!=0):
                        
                        #Obtendo os dados da variável de dados gerais ---> self.data_geral
                        data = self.data_geral
                        #Perguntando ao usuário se deseja mesmo excluir os pontos marcados, caso tenha escolhido excluir algum ponto
                        opcao, pontos_excluir = self.opcaoExcluir(data)                       
                                               
                        if opcao: #entra aqui se o usuário escolher processar depois que aparecer o messagebox 
                            
                            pontos_total = len(data) - len(pontos_excluir)
                            
                            if pontos_total >= 3:# A quantidade de pontos após as exclusões é maior do que 3 pontos
                                
                                #Obtendo a opção de processamento
                                self.op_norma = self.dlg.comboBox_4.currentIndex()
                                
                                #fazendo o processamento diferente excluindo os pontos 
                                self.visibleTables(2)
                                dx, dy, dz, d2D, d3D = self.obterDisc( data, pontos_excluir)                               
                                self.funcao_teste(data)
                                self.visibleTables(1)
                                self.atulizaPtsExcluidos(data, pontos_excluir)   
                    
                                #Processando as normas
                                self.proc_normas(dx, dy, dz, d2D)
                                
                                #Analisando os outliers
                                metodo, tolerancia_2D, outliers_2D = self.outlier(d2D,1)
                                metodo, tolerancia_Z, outliers_Z = self.outlier(dz,2)
                                #self.atualizaOutlier(metodo, [tolerancia_2D, str(len(outliers_2D))], [tolerancia_Z, str(len(outliers_Z))])
                                
                                #Processando normalidade e tendencia
                                self.normalidade(dx,dy,dz,d2D,d3D)
                                self.tendencia(dx, dy, dz)

                                #Atualizando o número de pontos e pontos excluidos
                                pts_total = len(data)
                                pts_excluidos = len(pontos_excluir)
                                self.dlg.label_154.setVisible(True)
                                self.dlg.label_155.setVisible(True)
                                self.dlg.label_155.setText(f"Nº Pts Total: {pts_total}")
                                self.dlg.label_154.setText(f"Nº Pts Excluídos do cálculo: {pts_excluidos}") 
                                
                                #atualizando as variaveis do relatório
                                self.var_pts_inseridos_relatorio = len(data)
                                self.var_pts_utilizados_relatorio = pts_total - pts_excluidos
                                
                                #Preenchendo a tabela de estatisticas
                                dict_outliers =  { 'var_qtd_outliers_2D' : len(outliers_2D),
                                                    'var_qtd_outliers_Z': len(outliers_Z)
                                                    }
                    
                                self.preenche_table(dx,dy,dz,d2D,d3D,dict_outliers,self.var_pts_utilizados_relatorio )
                                
                                #Atualizando as variáveis de relatório
                                self.dados_relatorio = (dx, dy, dz, d2D, d3D, data)              
                                self.pontos_excluidos_relatorio = pontos_excluir                               
                                self.getMetodologia_relatorio()

                                #Atualizando a interface gráfica
                                self.atualizaInterface()
                                
                                #Mensagem de processamento concluído para o usuário
                                self.iface.messageBar().pushMessage("Processamento Concluido")
                                
                            else: # A quantidade de pontos após as exclusões é menor do que 3 pontos
                        
                                self.show_messagebox_erro('erro', 'O conjunto de dados é menor do que 3 pontos!')
                                self.clearTables() #Limpando as tabelas da aba inicial
                                
                        else:   # entra aqui se mesmo depois do messagebox o usuário negar o processamento
                                
                                #Obtendo a opção de processamento 
                                self.op_norma = self.dlg.comboBox_4.currentIndex()
                                #Deixando as tabelas da aba inicial invisiveis
                                self.visibleTables(2)
                                #Obtendo os dados de discrepâncias
                                data, retorno = self.obt_data()
                                self.data_geral = data
                                
                                #Atualizando a tabela de discrepâncias
                                self.funcao_teste(data)
                                #Deixando as tabelas da aba inicial visiveis
                                self.visibleTables(1)
                                
                                #Calculando as discrepâncias
                                dx, dy, dz = fDiscrepancia(data)
                                d2D = fDiscrepancia2D(dx, dy)
                                d3D = fDiscrepancia3D(dx, dy, dz)
                                
                                #Processando as normas, normalidade e tendencia
                                self.proc_normas(dx, dy, dz, d2D)                    
                                self.normalidade(dx,dy,dz,d2D,d3D)
                                self.tendencia(dx, dy, dz)
                            
                                #Atualizando o número de pontos e pontos excluidos
                                pts_total = len(data)
                                self.dlg.label_154.setVisible(True)
                                self.dlg.label_155.setVisible(True)
                                self.dlg.label_155.setText(f"Nº Pts Total: {pts_total}")
                                self.dlg.label_154.setText(f"Nº Pts Excluídos do cálculo: 0")
                    
                                #atualizando as variaveis de controle
                                self.c_nome_teste = self.dlg.comboBox.currentText()
                                self.c_nome_referencia = self.dlg.comboBox_2.currentText()
                            
                                #atualizando as variaveis do relatório
                                self.var_pts_inseridos_relatorio = len(data)
                                self.var_pts_utilizados_relatorio = len(data)
                                
                                #Preenchendo a tabela de estatisticas
                                dict_outliers =  self.get_Outliers_relatorio(data)
                                self.preenche_table(dx,dy,dz,d2D,d3D,dict_outliers,self.var_pts_utilizados_relatorio )
                                
                                #atualizando as variaveis do relatório
                                self.dados_relatorio = (dx, dy, dz, d2D, d3D, data)                    
                                self.pontos_excluidos_relatorio = set()                              
                                self.getMetodologia_relatorio()

                                #Atuaizando a interface gráfica
                                self.atualizaInterface()
                                #Mensagem de processamento concluído para o usuário
                                self.iface.messageBar().pushMessage("Processamento Concluido")
                                
                    else:   # cai aqui se as layers tiverem nomes diferentes
                
                        #processa normal
                        
                        #Obtendo a opção de processamento
                        self.op_norma = self.dlg.comboBox_4.currentIndex()
                        #Deixando as tabelas da aba inicial invisiveis
                        self.visibleTables(2)
                        #Obtendo os dados de discrepâncias
                        data, retorno = self.obt_data()
                        self.data_geral = data
                        
                        #Atualizando a tabela de discrepancias
                        self.funcao_teste(data)
                        #Deixando as tabelas da aba inicial visiveis
                        self.visibleTables(1)
                        
                        #Calculando as discrepancias
                        dx, dy, dz = fDiscrepancia(data)
                        d2D = fDiscrepancia2D(dx, dy)
                        d3D = fDiscrepancia3D(dx, dy, dz)
                    
                        #Processando as normas, a normalidade e a tendencia
                        self.proc_normas(dx, dy, dz, d2D)                
                        self.normalidade(dx,dy,dz,d2D,d3D)
                        self.tendencia(dx, dy, dz)
                
                        #Atualizando o número de pontos e pontos excluidos
                        pts_total = len(data)
                        self.dlg.label_154.setVisible(True)
                        self.dlg.label_155.setVisible(True)
                        self.dlg.label_155.setText(f"Nº Pts Total: {pts_total}")
                        self.dlg.label_154.setText(f"Nº Pts Excluídos do cálculo: 0")
                
                        #atualizando as variaveis de controle
                        self.c_nome_teste = self.dlg.comboBox.currentText()
                        self.c_nome_referencia = self.dlg.comboBox_2.currentText()
                        
                        #atualizando as variaveis do relatório
                        self.var_pts_inseridos_relatorio = len(data)
                        self.var_pts_utilizados_relatorio = len(data)
                        
                        #Preenchendo a tabela de estatisticas
                        dict_outliers =  self.get_Outliers_relatorio(data)
                        self.preenche_table(dx,dy,dz,d2D,d3D,dict_outliers,self.var_pts_utilizados_relatorio )
                        
                        #Atualizando as variaveis de relatorio                     
                        self.dados_relatorio = (dx, dy, dz, d2D, d3D, data)                   
                        self.pontos_excluidos_relatorio = set()                        
                        self.getMetodologia_relatorio()
                        
                        #Atuaizando a interface gráfica
                        self.atualizaInterface()
                        #Mensagem de processamento concluído para o usuário
                        self.iface.messageBar().pushMessage("Processamento Concluido")
            
                else: #Entra no else se os dados inseridos pelo usuário não são válidos
                
                    self.clearTables() #Limpando as tabelas da aba inicial
            
            else: #Entra no else se não conseguir obter os dados
                
                if retorno ==1:
                
                    self.show_messagebox_erro('erro', 'Não há camadas suficientes para realizar o processamento!')
                    self.clearTables() #Limpando as tabelas da aba inicial
                
                elif retorno == 2:

                    self.show_messagebox_erro('erro', 'O SRC das camadas são diferentes! realize a compatibilização de referencial')
                    self.clearTables() #Limpando as tabelas da aba inicial
                    
                else:
                
                    self.show_messagebox_erro('erro', 'O conjunto de dados é menor do que 3 pontos!')
                    self.clearTables() #Limpando as tabelas da aba inicial

#########################################
######## PARTE DO RELATORIO ################
    
    def abrir_caminho_relatorio(self):
        """execução do botão para definir o local e o nome do arquivo pdf do relatorio."""
        
        # Abrir uma caixa de diálogo para salvar o arquivo de saída
        file_path, _ = QFileDialog.getSaveFileName(self.dlg, "Salvar relatório", "", "PDF Files (*.pdf)")
        self.dlg.lineEdit_42.setText(file_path)
        pass
    
    def is_valid_path(self, path):
        """Este método verifica se o caminho informado pelo usuário é válido"""
        
        # Verifica se o diretório onde o arquivo será salvo existe
        directory = os.path.dirname(path)
        if os.path.isdir(directory):
            return False
        else:
            return True
    
    def getVariaveis_relatorio(self):
        """Este método obtém as variáveis inseridas pelo usuário para colocar no relatório"""
        
        #Obtendo as variáveis
        var_produto = self.dlg.lineEdit_39.text()
        var_local = self.dlg.lineEdit_40.text()
        var_data = self.dlg.dateEdit.date().toString("dd/MM/yyyy")
        var_resp_tecnico = self.dlg.lineEdit_41.text()
        caminho = self.dlg.lineEdit_42.text()
        
        #Verificando se o caminho inserido é válido, se for válido retorna True, se não False
        #Caso seja válido também são retornadas as variáveis
        if self.is_valid_path(caminho):
            
            mensagem = 'Insira um caminho válido para gerar o relatório!'
            return '', mensagem, False
            
        elif (len(var_produto) >35) or (len(var_local)>35) or (len(var_resp_tecnico)>35) :
            
            mensagem = 'Os dados a serem inseridos no relatório devem ter apenas 35 caracteres, diminua o tamanho dos dados!'
            return '', mensagem, False
        
        else:
            
            variaveis = { 'var_produto' : var_produto,
                          'var_local' : var_local,
                          'var_data' : var_data,
                          'var_resp_tecnico' : var_resp_tecnico,
                          'caminho' : caminho
                        }
            
            return variaveis, '', True
            
    def getNC_testes_relatorio(self):
        """Este método obtém o nível de confiança dos testes shapiro wilk e t de student"""
        
        #obtendo o nc do shapiro 
        if self.niv_conf_s ==0:
            
            nc_shapiro = 'com 75% de nível de confiança'
        
        elif self.niv_conf_s ==1:
            
            nc_shapiro = 'com 90% de nível de confiança'
        
        elif self.niv_conf_s ==2:
            
            nc_shapiro = 'com 95% de nível de confiança'
            
        elif self.niv_conf_s ==3:
            
            nc_shapiro = 'com 97,5% de nível de confiança'
        
        else:
            
            nc_shapiro = 'com 99% de nível de confiança'

        #obtendo o nc do t de student 
        if self.niv_conf_t ==0:
            
            nc_student = 'com 75% de nível de confiança'
        
        elif self.niv_conf_t ==1:
            
            nc_student = 'com 90% de nível de confiança'
        
        elif self.niv_conf_t ==2:
            
            nc_student = 'com 95% de nível de confiança'
            
        elif self.niv_conf_t ==3:
            
            nc_student = 'com 97,5% de nível de confiança'
        
        else:
            
            nc_student = 'com 99% de nível de confiança'
        
        #Retornando o nível de confiança dos testes
        return nc_shapiro, nc_student
    
    def get_Outliers_relatorio(self, data):
        """Este método obtém os outliers para serem inseridos no relatório"""
        
        #Calculando as discrepâncias
        dx, dy, dz = fDiscrepancia(data)
        d2D = fDiscrepancia2D(dx, dy)
        op = self.op_norma
        
        if (op==0) or (op==3) or (op==6) or (op==7): #2D
            
            #Obtendo os outliers
            metodo, tolerancia_2D, outliers_2D = self.outlier(d2D, 1)
            qtd_outliers_2D = len(outliers_2D)
            
            try: #Para os processamentos diferentes da NBR13133
                
                #Obtendo a classe do teste 3sigma
                classe = self.classe_3sigma
                
                if classe ==0:
            
                    var_classe_3_sigma = 'Classe A'
        
                elif classe ==1:
            
                    var_classe_3_sigma = 'Classe B'
        
                elif classe == 2:
            
                    var_classe_3_sigma = 'Classe C'
        
                else:
            
                    var_classe_3_sigma = 'Classe D'
            
            except:
            
                var_classe_3_sigma = 'nao definido'
            
            #Criando o dicionário com os outliers
            
            dict_outliers = { 'var_metodo' : metodo,
                           'var_qtd_outliers_2D' : qtd_outliers_2D,
                           'var_qtd_outliers_Z' : 'não definido',
                           'var_limite_2D' : tolerancia_2D,
                           'var_limite_Z' : 'não definido',
                           'outliers_2D' : outliers_2D,
                           'outliers_Z' : 'não definido',
                           'var_classe_3_sigma' : var_classe_3_sigma
                            }
            
            #Retornando os outliers
            return dict_outliers
            
        elif (op==1) or (op==4) or (op==8): #Z
            
            #Obtendo os outliers
            metodo, tolerancia_Z, outliers_Z = self.outlier(dz, 2)
            qtd_outliers_Z = len(outliers_Z)
        
            
            try: #Para os processamentos diferentes da NBR13133
                
                #Obtendo a classe do teste 3sigma
                classe = self.classe_3sigma
                
                if classe ==0:
            
                    var_classe_3_sigma = 'Classe A'
        
                elif classe ==1:
            
                    var_classe_3_sigma = 'Classe B'
        
                elif classe == 2:
            
                    var_classe_3_sigma = 'Classe C'
        
                else:
            
                    var_classe_3_sigma = 'Classe D'
            
            except:
                var_classe_3_sigma = 'nao definido'
            
            #Criando o dicionário com os outliers
            dict_outliers = { 'var_metodo' : metodo,
                           'var_qtd_outliers_2D' : 'não definido',
                           'var_qtd_outliers_Z' : qtd_outliers_Z,
                           'var_limite_2D' : 'não definido',
                           'var_limite_Z' : tolerancia_Z,
                           'outliers_2D' : 'não definido',
                           'outliers_Z' : outliers_Z,
                           'var_classe_3_sigma' : var_classe_3_sigma
                            }
            
            #Retornando os outliers
            return dict_outliers
            
        else: #2D e Z
            
            #Obtendo os outliers
            metodo, tolerancia_2D, outliers_2D = self.outlier(d2D, 1)
            metodo, tolerancia_Z, outliers_Z = self.outlier(dz, 2)
            
            qtd_outliers_2D = len(outliers_2D)
            qtd_outliers_Z = len(outliers_Z)
            
            
            try: #Para os processamentos diferentes da NBR13133
                
                #Obtendo a classe do método 3sigma
                classe = self.classe_3sigma
                
                if classe ==0:
            
                    var_classe_3_sigma = 'Classe A'
        
                elif classe ==1:
            
                    var_classe_3_sigma = 'Classe B'
        
                elif classe == 2:
            
                    var_classe_3_sigma = 'Classe C'
        
                else:
            
                    var_classe_3_sigma = 'Classe D'
            
            except:
                var_classe_3_sigma = 'nao definido'
            
            #Criando o dicionário com os outliers
            dict_outliers = { 'var_metodo' : metodo,
                           'var_qtd_outliers_2D' : qtd_outliers_2D,
                           'var_qtd_outliers_Z' : qtd_outliers_Z,
                           'var_limite_2D' : tolerancia_2D,
                           'var_limite_Z' : tolerancia_Z,
                           'outliers_2D' : outliers_2D,
                           'outliers_Z' : outliers_Z,
                           'var_classe_3_sigma' : var_classe_3_sigma
                           
                            }
            #Retornando o dicionário com os outliers
            return dict_outliers
    
    def getMetodologia_relatorio(self):
        """Este método obtém a metodologia de processamento escolhida pelo usuário, santos et al, ou apenas o decreto"""
        
        if self.dlg.radioButton_3.isChecked(): #Metodologia Santos et al
        
            self.var_metodologia_relatorio = 'Santos et al. (2016) com as tolerâncias PEC-PCD da ET-CQDG'
            self.opc = 1
                
        else: #Metodologia do decreto
        
            self.var_metodologia_relatorio = 'ET-CQDG'
            self.opc = 2
    
    def getAcuracia_relatorio(self):
        """Este método realiza a análise de acurácia conforme a metodologa Santos et al"""
        
        #Realizando o teste de acurácia 2D  
        if (self.var_tendencia_2D_relatorio == 'Não Tendencioso') and (self.var_precisao_2D_relatorio == 'É preciso'):
            
            var_acuracia_2D = 'É ACURADO'
        else:
            var_acuracia_2D = 'NÃO É ACURADO'
          
        #Realizando o teste de acurácia Z       
        if (self.var_tendencia_Z_relatorio == 'Não Tendencioso') and (self.var_precisao_Z_relatorio == 'É preciso'):
            
            var_acuracia_Z = 'É ACURADO'
        else:
            var_acuracia_Z = 'NÃO É ACURADO'
        
        #Retornando os valores de acurácia
        return var_acuracia_2D, var_acuracia_Z
    
    def getImagens_relatorio(self):
        """Este método obtém as imagens dos gráficos para serem inseridas no relatório"""
       
        #Obtendo as opções de processamento 
        opcao = self.opcao_outliers_processamento #Depois mudar e definir variável global no momento do processamento
        op = self.op_norma
        
        #Obtendo as imagens conforme a opção de processamento
        
        if (op==0) or (op==3) or (op==6) or (op==7): #2D
            
            #Definindo um dicionário com as imagens
            dict_imagens = {'dispersão_2D' : self.FG_exibir_janela_dispersao_2D(2),
                            'discrepancias_2D' : self.FG_exibir_janela_discrepancias_2D(2),
                            'discrepancias_Z' : 'nao definido',
                            'outliers_2D' : 0,
                            'outliers_Z' : 'nao definido'
                            }
                            
            dados_2D = self.FG_get_dados_outliers()
            
            if opcao ==0 : #3sigma
                
                dict_imagens['outliers_2D'] = self.FG_exibir_janela_3sigma(dados_2D, 2, '2D')
            
            else: #Boxplot
                
                dict_imagens['outliers_2D'] = self.FG_exibir_janela_boxplot(dados_2D, 2, '2D')

            #Retornando o dicionário com as imagens
            return dict_imagens
        
        elif (op==1) or (op==4) or (op==8): #Z
            
            #Definindo um dicionário com as imagens
            dict_imagens = {'dispersão_2D' : 'nao definido',
                            'discrepancias_2D' : 'nao definido',
                            'discrepancias_Z' : self.FG_exibir_janela_discrepancias_Z(2),
                            'outliers_2D' : 'nao definido',
                            'outliers_Z' : 0
                            }
                            
            dados_Z = self.FG_get_dados_outliers()
            
            if opcao ==0 : #3sigma
                
                dict_imagens['outliers_Z'] = self.FG_exibir_janela_3sigma(dados_Z, 2, 'Z')
            
            else: #Boxplot
                
                dict_imagens['outliers_Z'] = self.FG_exibir_janela_boxplot(dados_Z, 2, 'Z')
                
            #Retornando o dicionário com as imagens
            return dict_imagens
            
        else: #2D e Z
            
            #Definindo um dicionário com as imagens
            dict_imagens = {'dispersão_2D' : self.FG_exibir_janela_dispersao_2D(2),
                            'discrepancias_2D' : self.FG_exibir_janela_discrepancias_2D(2),
                            'discrepancias_Z' : self.FG_exibir_janela_discrepancias_Z(2),
                            'outliers_2D' : 0,
                            'outliers_Z' : 0
                            }
                            
            dados_2D, dados_Z = self.FG_get_dados_outliers()
            
            if opcao ==0 : #3sigma
                
                dict_imagens['outliers_2D'] = self.FG_exibir_janela_3sigma(dados_2D, 2, '2D')
                dict_imagens['outliers_Z'] = self.FG_exibir_janela_3sigma(dados_Z, 2, 'Z')
            
            else: #Boxplot
                
                dict_imagens['outliers_2D'] = self.FG_exibir_janela_boxplot(dados_2D, 2, '2D')
                dict_imagens['outliers_Z'] = self.FG_exibir_janela_boxplot(dados_Z, 2, 'Z')
                
            #Retornando o dicionário com as imagens
            return dict_imagens
               
    def variaveis_relatorio(self):
        """Este método empacota as variáveis que serão utilizadas para gerar o relatório em uma variável do tipo dicionário"""
        
        #Obtendo as variáveis inseridas pelo usuário
        variaveis, mensagem, valid = self.getVariaveis_relatorio()
        
        #Verificando se as variáveis inseridas pelo usuário são válidas, caso sejam é montado um dicionário para o relatório
        #Se não forem válidas, é exibida uma mensagem de erro
        
        if valid:
            
            #Função que deixa a primeira letra da string maiuscula
            def capitalize_first_letter(s):
                return s[0].upper() + s[1:]
            
            
            #Obtendo a opção de processamento
            op = self.op_norma
            
            #Desempacotando os dados de discrepâncias
            dx, dy, dz, d2D, d3D, data = self.dados_relatorio
            
            #Obtendo o nível de confiança dos testes de hipótese
            nc_shapiro, nc_student = self.getNC_testes_relatorio()
            
            #alterando a variável de normalidade
            normalidade_x = fTesteDeNormalidade(dx, self.niv_conf_s)
            normalidade_y = fTesteDeNormalidade(dy, self.niv_conf_s)
            
            if (normalidade_x[2] == 'Amostra Normal') and (normalidade_y[2] == 'Amostra Normal'):
                
                var_normalidade_2D = 'Amostra Normal'
            
            else:
                
                var_normalidade_2D = 'Amostra NÃO Normal'
                           
            var_normalidade_Z = fTesteDeNormalidade(dz, self.niv_conf_s)
            
            #obtendo os outliers
            dict_outliers = self.get_Outliers_relatorio(data)
          
            #Obtendo as variáveis referentes a NBR 13133
            
            if (op ==3) or (op==4) or (op==5):
            
                self.var_atende_INCRA_relatorio = 'nao definido'
                self.var_artificial_INCRA_relatorio = 'nao definido'
                self.var_natural_INCRA_relatorio = 'nao definido'
                self.var_inacessivel_INCRA_relatorio = 'nao definido'
                self.var_limites_INCRA_relatorio = 'nao definido'
                self.pec_2D_relatorio = 'nao definido'
                self.classe_2D_relatorio = 'nao definido'
                self.classe_Z_relatorio = 'nao definido'
                self.var_precisao_2D_relatorio = 'nao definido'
                self.var_precisao_Z_relatorio = 'nao definido'
                table_precisao = 'nao definido'
                self.escala_2D_relatorio = 'nao definido'
                self.escala_Z_relatorio = 'nao definido'
                  
                dict_NBR = {
                        'var_precisao_2D' : self.var_precisao_2D_NBR_relatorio , 
                        'var_precisao_Z' : self.var_precisao_Z_NBR_relatorio, 
                        'var_tolerancia_2D' : self.var_tolerancia_2D_NBR_relatorio,
                        'var_tolerancia_Z' : self.var_tolerancia_Z_NBR_relatorio,
                        'var_result_2D' : self.var_result_2D_NBR_relatorio,
                        'var_result_Z' : self.var_result_Z_NBR_relatorio,
                        'var_percent_2D' : self.var_percent_2D_NBR_relatorio,
                        'var_percent_Z' : self.var_percent_Z_NBR_relatorio,
                        'var_resultado_2D_NBR' : self.var_result_2D_NBR_relatorio.upper(),
                        'var_resultado_Z_NBR' : self.var_result_Z_NBR_relatorio.upper()
                         }
                     
            else:
                
                dict_NBR = 'nao definido'
                table_precisao = [ [self.pec_2D_relatorio, self.ep_2D_relatorio, self.percent_di_2D_relatorio,  capitalize_first_letter(self.classe_2D_relatorio)],
                               [self.pec_Z_relatorio, self.ep_Z_relatorio, self.percent_di_Z_relatorio, capitalize_first_letter(self.classe_Z_relatorio)]
                              ]

            #Definindo algumas variáveis para os casos de processamento ETCQDG e ANM
            
            if (op==0) or (op==1) or (op==2) or (op==7)or (op==8) or (op==9) : #Processamento ET-CQDG e ANM
                
                self.var_atende_INCRA_relatorio = 'nao definido'
                self.var_artificial_INCRA_relatorio = 'nao definido'
                self.var_natural_INCRA_relatorio = 'nao definido'
                self.var_inacessivel_INCRA_relatorio = 'nao definido'
                self.var_limites_INCRA_relatorio = 'nao definido'
            
            else:
                 pass
            
            if not ((op ==7) or (op==8) or (op==9)): #Quando não processa a ANM
                
                self.atende_ANM_2D_relatorio = 'nao definido'
                self.atende_ANM_Z_relatorio = 'nao definido'
            
            else:
                
                pass
                
            #Realizando o teste de acurácia 2D e Z            
            var_acuracia_2D, var_acuracia_Z = self.getAcuracia_relatorio()
            
            #Obtendo as imagens do relatório
            dict_imagens = self.getImagens_relatorio()
            
            #Montando o dicionário com as variáveis do relatório
            
            dict_var = { 'var_produto' : variaveis['var_produto'],
                               'var_local' : variaveis['var_local'],
                               'var_data' : variaveis['var_data'],
                               'var_resp_tecnico' : variaveis['var_resp_tecnico'],
                                'var_metodologia' : self.var_metodologia_relatorio,
                                'var_acurado2D' : var_acuracia_2D,
                                'var_acuradoZ' : var_acuracia_Z,
                                'var_atende_ANM_2D': self.atende_ANM_2D_relatorio,
                                'var_atende_ANM_Z': self.atende_ANM_Z_relatorio,
                                'var_normalidade_2D' : var_normalidade_2D, #Depois quando organizar a variável de normalidade da uma ajeitada
                                'var_normalidade_Z' : var_normalidade_Z[2],
                                'var_atende_INCRA': self.var_atende_INCRA_relatorio,
                                'var_artificial_INCRA': self.var_artificial_INCRA_relatorio,
                                'var_natural_INCRA' : self.var_natural_INCRA_relatorio,
                                'var_inacessivel_INCRA' : self.var_inacessivel_INCRA_relatorio,
                                'var_limites_INCRA' : self.var_limites_INCRA_relatorio,
                                'var_pec_INCRA' : self.pec_2D_relatorio,
                                'var_escala_2D' : self.escala_2D_relatorio, # depois trocar pode da bo / troquei
                                'var_escala_Z' : self.escala_Z_relatorio, # depois trocar pode da bo, o usuário pode processar, mudar a escala e mandar fazer o relatório, fazer um atributo na hora do processamento pra evitar isso
                                'var_NBR' : dict_NBR,
                                'var_classe_2D' : self.classe_2D_relatorio,
                                'var_classe_Z' : self.classe_Z_relatorio,
                                'var_precisao_2D' : self.var_precisao_2D_relatorio,
                                'var_precisao_Z' : self.var_precisao_Z_relatorio,
                                'var_tendencia_2D' : self.var_tendencia_2D_relatorio,
                                'var_tendencia_Z' : self.var_tendencia_Z_relatorio,
                                'var_rms_2D' : fRms(d2D),
                                'var_rms_Z' : fRms(dz),
                                'var_pts_inseridos' : self.var_pts_inseridos_relatorio,
                                'var_pts_utilizados' : self.var_pts_utilizados_relatorio,
                                'dados' : self.dados_relatorio,
                                'dict_outliers' : dict_outliers,                            
                                'table_precisao' : table_precisao,
                                'table t' : self.table_t_relatorio,
                                'table med' : self.table_med_relatorio,
                                'pts_excluidos' : self.pontos_excluidos_relatorio,
                                'niv_conf' : self.niv_conf_s,
                                'nc_shapiro' : nc_shapiro,
                                'nc_student' : nc_student,
                                'plugin_dir' : self.plugin_dir,
                                 'opc' : self.opc,
                                 'op' : op ,   
                                 'caminho' : variaveis['caminho'],
                                 'imagem_dispersao_2D' : dict_imagens['dispersão_2D'],
                                 'imagem_discrepancias_2D': dict_imagens['discrepancias_2D'],
                                 'imagem_discrepancias_Z': dict_imagens['discrepancias_Z'],
                                 'imagem_outliers_2D': dict_imagens['outliers_2D'],
                                 'imagem_outliers_Z': dict_imagens['outliers_Z'],
                            }
            
            #Retornando o dicionário
            return dict_var, True
        
        else:
            
            self.show_messagebox_erro('erro', mensagem)
            return '', False
   
    def generateRelatorio (self):
        """Este método é responsável por gerar o relatório"""
        
        #Obtendo o dicionário com as variáveis do relatório e a variável que define se os dados são válidos ou não
        dict_var, var_true = self.variaveis_relatorio()
        
        #Se os dados são válidos, entra no IF e tenta gerar o relatório
        #Caso os dados não sejam válidos, entra no else e exibe uma mensagem de erro
        
        if var_true:
                       
            try: #Tentando gerar o relatório
                
                fProcessamento_relatorio(dict_var)
                self.show_messagebox_erro('sucesso', 'Relatório gerado com sucesso!')
            
            except PermissionError as e: #Erro por estar aberto um relatório com mesmo nome
                
                if e.errno == 13:                    
                 
                    self.show_messagebox_erro('erro', 'Não é possível gerar o relatório com um arquivo com o mesmo nome e diretório aberto. Feche o arquivo e tente gerar o relatório novamente!')
                
                else:
                    
                    self.show_messagebox_erro('erro', 'Não foi possível gerar o relatório!')
                # tratar o erro do cara ter aberto o relatório
            
            except Exception as e: #Outro tipo de erro ao gerar o relatório
                
                #self.show_messagebox_erro('erro', f'Não foi possível gerar o relatório! ERRO: {e}')
                self.show_messagebox_erro('erro', f'Não foi possível gerar o relatório! ERRO: {e}')
            
            finally: #Fechando os objetos de memória
            
                # Fechar os objetos BytesIO em dict_var
                for key in ['imagem_dispersao_2D','imagem_discrepancias_2D', 'imagem_discrepancias_Z', 'imagem_outliers_2D', 'imagem_outliers_Z']:
                    if isinstance(dict_var[key], io.BytesIO):
                        dict_var[key].close()
                
                # Verificando novamente e fechando os objetos restantes na lista de rastreamento
                for obj in self.bytes_io_objects:
                    if not obj.closed:
                        obj.close()
                               
                # Verificando novamente se todos os objetos BytesIO foram fechados 
                for obj in self.bytes_io_objects:
                    if not obj.closed:
                        print(f"Warning: BytesIO object {obj} is not closed.")
                
                # Limpando a lista de objetos
                self.bytes_io_objects.clear()
                #Depois alterar o código acima, estamos fazendo mais verificações do que o 
                # necessário
        else:
        
             pass
    
    ######################################################
    #Parte de resumo e relatório
    
    def visibleLabels_resumo(self):
        """Este método deixa todos os labels da aba de resumo e relatório desabilitadas"""
        
        self.dlg.label_66.setVisible(False)
        self.dlg.label_68.setVisible(False)
        self.dlg.label_113.setVisible(False)
        self.dlg.label_69.setVisible(False)
        self.dlg.label_114.setVisible(False)
        self.dlg.label_70.setVisible(False)
        self.dlg.label_71.setVisible(False)
        self.dlg.label_72.setVisible(False)
        self.dlg.label_73.setVisible(False)
        self.dlg.label_115.setVisible(False)
        self.dlg.label_116.setVisible(False)
        self.dlg.label_117.setVisible(False)
        self.dlg.label_75.setVisible(False)
        self.dlg.label_76.setVisible(False)
        self.dlg.label_119.setVisible(False)
        self.dlg.label_139.setVisible(False)
        self.dlg.label_142.setVisible(False)
        self.dlg.label_141.setVisible(False)
        self.dlg.label_140.setVisible(False)
        self.dlg.label_138.setVisible(False)
        self.dlg.label_132.setVisible(False)
        self.dlg.label_136.setVisible(False)
        self.dlg.label_134.setVisible(False)
        self.dlg.label_133.setVisible(False)
        self.dlg.label_135.setVisible(False)
        self.dlg.label_144.setVisible(False)
        self.dlg.label_145.setVisible(False)
        self.dlg.label_143.setVisible(False)
        
        self.dlg.label_179.setVisible(False)
        self.dlg.label_181.setVisible(False)
        self.dlg.label_178.setVisible(False)
        self.dlg.label_182.setVisible(False)
        #escala
        self.dlg.label_161.setVisible(False)
        self.dlg.label_164.setVisible(False)
        self.dlg.label_165.setVisible(False)
        self.dlg.label_166.setVisible(False)
        #colocar os do INCRA
        self.dlg.label_172.setVisible(False)
        self.dlg.label_173.setVisible(False)
        self.dlg.label_171.setVisible(False)
        self.dlg.label_169.setVisible(False)
        self.dlg.label_170.setVisible(False)
        self.dlg.label_167.setVisible(False)
        self.dlg.label_168.setVisible(False)
        self.dlg.label_184.setVisible(False)
        #NBR
        self.dlg.label_174.setVisible(False)
        self.dlg.label_175.setVisible(False)
             
    def resumo_ETCQDG (self):
        """Este método atualiza a aba de resumo e relatório quando o processamento é da norma ET-CQDG"""
        
        #Função para deixar a primeira letra da string maiuscula 
        def capitalize_first_letter(s):
                return s[0].upper() + s[1:]
        
        #Obtendo as opções de processamento, norma e metodologia (Santos et al ou decreto)
        op = self.op_norma
        opc = self.opc
        
        #Realizando o teste de acurácia 2D e Z
        var_acuracia_2D, var_acuracia_Z = self.getAcuracia_relatorio()
        
        #Atualizando a interface gráfica da aba de resumo e relatório
        
        if (op==0): #2D
            
            if (opc == 1): #Santos et al
                
                #Deixando as labels visíveis
                
                self.dlg.label_66.setVisible(True)
                self.dlg.label_68.setVisible(True)
                self.dlg.label_69.setVisible(True)
                self.dlg.label_113.setVisible(True)
                self.dlg.label_114.setVisible(True)
                self.dlg.label_70.setVisible(True)
                self.dlg.label_71.setVisible(True)
                self.dlg.label_72.setVisible(True)
                self.dlg.label_73.setVisible(True)
                self.dlg.label_115.setVisible(True)
                self.dlg.label_116.setVisible(True)
                self.dlg.label_117.setVisible(True)
                self.dlg.label_75.setVisible(True)
                self.dlg.label_76.setVisible(True)
                self.dlg.label_119.setVisible(True)
                self.dlg.label_179.setVisible(True)
                self.dlg.label_178.setVisible(True)
                #dois labels amais para a escala
                self.dlg.label_161.setVisible(True)
                self.dlg.label_164.setVisible(True)
                
                #Setando a geometria dos labels
                
                self.dlg.label_75.setGeometry(530, 20, 181, 16)
                self.dlg.label_76.setGeometry(540, 110, 211, 31)
                self.dlg.label_119.setGeometry(540, 50, 211, 61)                
                self.dlg.label_114.setGeometry(85, 80, 101, 16)
                self.dlg.label_164.setGeometry(63, 60, 171, 16)
                
                #Mudando o resultado dos labels:
                self.dlg.label_66.setText('Análise de precisão')
                self.dlg.label_69.setText('Resultado:')
                self.dlg.label_113.setText('Decreto/ET-CQDG')
                self.dlg.label_114.setText(f"{capitalize_first_letter(self.classe_2D_relatorio)}")
                
                #Resultado em vermelho
                self.dlg.label_179.setText(f"{capitalize_first_letter(self.classe_2D_relatorio)}")
                
                #Labels de escala
                self.dlg.label_161.setText('Escala:')
                self.dlg.label_164.setText(f"1/{self.escala_2D_relatorio}")
                
                #Parte de tendência
                self.dlg.label_70.setText('Análise de tendência')
                
                #Parte de normalidade
                if self.normalidade_2d:
                
                    self.dlg.label_115.setText('Amostra Normal')
                
                else:
                
                    self.dlg.label_115.setText('Amostra NÃO Normal')
                    
                self.dlg.label_116.setText(self.dlg.label_120.text())
                self.dlg.label_117.setText(self.dlg.label_112.text()) 
                
                #Resultado em vermelho
                self.dlg.label_178.setText(f"{capitalize_first_letter(self.var_tendencia_2D_relatorio)}")
                
                #Mudando o resultado de acurácia:               
                if (var_acuracia_2D == 'É ACURADO'):
                    
                    text = f"Produto acurado para a {self.classe_2D_relatorio} na escala 1/{self.escala_2D_relatorio}" 
                    self.dlg.label_119.setText(text)
                
                else:
                    
                    text = f"Produto NÃO acurado" 
                    self.dlg.label_119.setText(text)
                    
                self.dlg.label_75.setText("Análise de acurácia")
                self.dlg.label_76.setText("Metodologia Santos et al. (2016)")
                
                
            else: #Somente decreto
                
                #Deixando as labels visíveis         
                self.dlg.label_66.setVisible(True)
                self.dlg.label_68.setVisible(True)
                self.dlg.label_69.setVisible(True)
                self.dlg.label_113.setVisible(True)
                self.dlg.label_114.setVisible(True)
                self.dlg.label_75.setVisible(True)
                self.dlg.label_76.setVisible(True)
                self.dlg.label_119.setVisible(True)
                self.dlg.label_179.setVisible(True)
                
                #dois labels amais para a escala
                self.dlg.label_161.setVisible(True)
                self.dlg.label_164.setVisible(True)
                
                #Setando a geometria dos labels
                
                self.dlg.label_75.setGeometry(280, 20, 181, 16)
                self.dlg.label_76.setGeometry(290, 110, 211, 31)
                self.dlg.label_119.setGeometry(290, 50, 211, 61)
                self.dlg.label_114.setGeometry(85, 80, 101, 16)
                self.dlg.label_164.setGeometry(63, 60, 171, 16)
                
                #Mudando o resultado dos labels:               
                self.dlg.label_66.setText('Análise de precisão')
                self.dlg.label_69.setText('Resultado:')
                self.dlg.label_113.setText('Decreto/ET-CQDG')
                self.dlg.label_114.setText(f"{capitalize_first_letter(self.classe_2D_relatorio)}")
                
                #Resultado em vermelho
                self.dlg.label_179.setText(f"{capitalize_first_letter(self.classe_2D_relatorio)}")
                
                #Labels de escala              
                self.dlg.label_161.setText('Escala:')
                self.dlg.label_164.setText(f"1/{self.escala_2D_relatorio}")
                
                #Mudando o resultado de acurácia              
                self.dlg.label_75.setText("Análise de acurácia")
                text = f"Classificação pelo Decreto 89.817:\n{self.dlg.label_124.text()} na escala 1/{self.escala_2D_relatorio}" 
                self.dlg.label_119.setText(text)
 
                self.dlg.label_76.setText("Metodologia ET-CQDG")
        
        elif (op==1): #Z
        
            if (opc == 1): #Santos et al
                
                #Deixando as labels visíveis               
                self.dlg.label_66.setVisible(True)
                self.dlg.label_68.setVisible(True)
                self.dlg.label_69.setVisible(True)
                self.dlg.label_113.setVisible(True)
                self.dlg.label_114.setVisible(True)
                self.dlg.label_70.setVisible(True)
                self.dlg.label_71.setVisible(True)
                self.dlg.label_72.setVisible(True)
                self.dlg.label_115.setVisible(True)
                self.dlg.label_116.setVisible(True)
                self.dlg.label_75.setVisible(True)
                self.dlg.label_76.setVisible(True)
                self.dlg.label_119.setVisible(True)
                self.dlg.label_179.setVisible(True)
                self.dlg.label_178.setVisible(True)
                #dois labels amais para a escala
                self.dlg.label_161.setVisible(True)
                self.dlg.label_164.setVisible(True)
                
                #Setando a geometria dos labels           
                self.dlg.label_75.setGeometry(530, 20, 181, 16)
                self.dlg.label_76.setGeometry(540, 110, 211, 31)
                self.dlg.label_119.setGeometry(540, 50, 211, 61)                
                self.dlg.label_114.setGeometry(85, 80, 101, 16)
                self.dlg.label_164.setGeometry(90, 60, 171, 16)
                
                #Mudando o resultado dos labels:              
                self.dlg.label_66.setText('Decreto/ET-CQDG altimetria')
                
                #Mudando o resultado dos labels:  
                self.dlg.label_66.setText('Análise de precisão')
                self.dlg.label_69.setText('Resultado:')
                self.dlg.label_113.setText('Decreto/ET-CQDG')
                self.dlg.label_114.setText(f"{capitalize_first_letter(self.classe_Z_relatorio)}")
                
                #Resultado em vermelho
                self.dlg.label_179.setText(f"{capitalize_first_letter(self.classe_Z_relatorio)}")
                
                #Labels de escala               
                self.dlg.label_161.setText('Equidistância:')
                self.dlg.label_164.setText(f"{self.escala_Z_relatorio}m")
                
                #Parte de tendência
                self.dlg.label_70.setText('Análise de tendência')
                
                #Parte de normalidade
                if self.normalidade_z:
                
                    self.dlg.label_115.setText('Amostra Normal')
                
                else:
                
                    self.dlg.label_115.setText('Amostra NÃO Normal')
                    
                self.dlg.label_116.setText(self.dlg.label_120.text())
                
                #Resultado em vermelho
                self.dlg.label_178.setText(f"{capitalize_first_letter(self.var_tendencia_Z_relatorio)}")
                
                #Mudando o resultado de acurácia:
                
                if (var_acuracia_Z == 'É ACURADO'):
                    
                    text = f"Produto acurado para a {self.classe_Z_relatorio}\nna equidistância de {self.escala_Z_relatorio}m" 
                    self.dlg.label_119.setText(text)
                
                else:
                    
                    text = f"Produto NÃO acurado" 
                    self.dlg.label_119.setText(text)
                    
                self.dlg.label_75.setText("Análise de acurácia")
                self.dlg.label_76.setText("Metodologia Santos et al. (2016)")
                
            else: #Somente decreto
                
                #Deixando as labels visíveis              
                self.dlg.label_66.setVisible(True)
                self.dlg.label_68.setVisible(True)
                self.dlg.label_69.setVisible(True)
                self.dlg.label_113.setVisible(True)
                self.dlg.label_114.setVisible(True)
                self.dlg.label_75.setVisible(True)
                self.dlg.label_76.setVisible(True)
                self.dlg.label_119.setVisible(True)
                self.dlg.label_179.setVisible(True)
                
                #dois labels amais para a escala
                self.dlg.label_161.setVisible(True)
                self.dlg.label_164.setVisible(True)
                #Setando a geometria dos labels
                
                self.dlg.label_75.setGeometry(280, 20, 181, 16)
                self.dlg.label_76.setGeometry(290, 110, 211, 31)
                self.dlg.label_119.setGeometry(290, 50, 211, 61)
                self.dlg.label_114.setGeometry(85, 80, 101, 16)              
                
                #Mudando o resultado dos labels:             
                self.dlg.label_66.setText('Análise de precisão')
                self.dlg.label_69.setText('Resultado:')
                self.dlg.label_113.setText('Decreto/ET-CQDG')
                self.dlg.label_114.setText(f"{capitalize_first_letter(self.classe_Z_relatorio)}")
                self.dlg.label_164.setGeometry(90, 60, 171, 16)
                
                #Resultado em vermelho
                self.dlg.label_179.setText(f"{capitalize_first_letter(self.classe_Z_relatorio)}")
                
                #Labels de escala             
                self.dlg.label_161.setText('Equidistância:')
                self.dlg.label_164.setText(f"{self.escala_Z_relatorio}m")
                
                #Mudando o resultado de acurácia              
                self.dlg.label_75.setText("Análise de acurácia")
                text = f"Classificação pelo Decreto 89.817:\n{self.dlg.label_124.text()} para a equidistância de {self.escala_Z_relatorio}m." 
                self.dlg.label_119.setText(text)
 
                self.dlg.label_76.setText("Metodologia ET-CQDG")
                
        else: #2D e Z
        
            if (opc == 1): #Santos et al
                
                #Deixando as labels visíveis                
                self.dlg.label_66.setVisible(True)
                self.dlg.label_68.setVisible(True)
                self.dlg.label_113.setVisible(True)
                self.dlg.label_69.setVisible(True)
                self.dlg.label_114.setVisible(True)
                self.dlg.label_70.setVisible(True)
                self.dlg.label_71.setVisible(True)
                self.dlg.label_72.setVisible(True)
                self.dlg.label_73.setVisible(True)
                self.dlg.label_115.setVisible(True)
                self.dlg.label_116.setVisible(True)
                self.dlg.label_117.setVisible(True)
                self.dlg.label_75.setVisible(True)
                self.dlg.label_76.setVisible(True)
                self.dlg.label_119.setVisible(True)
                self.dlg.label_139.setVisible(True)
                self.dlg.label_142.setVisible(True)
                self.dlg.label_141.setVisible(True)
                self.dlg.label_140.setVisible(True)
                self.dlg.label_138.setVisible(True)
                self.dlg.label_132.setVisible(True)
                self.dlg.label_136.setVisible(True)
                self.dlg.label_134.setVisible(True)
                self.dlg.label_133.setVisible(True)
                self.dlg.label_135.setVisible(True)
                self.dlg.label_144.setVisible(True)
                self.dlg.label_145.setVisible(True)
                self.dlg.label_143.setVisible(True)
                
                self.dlg.label_179.setVisible(True)
                self.dlg.label_181.setVisible(True)
                self.dlg.label_178.setVisible(True)
                self.dlg.label_182.setVisible(True)
                
                #quatro labels amais para a escala
                self.dlg.label_161.setVisible(True)
                self.dlg.label_164.setVisible(True)
                self.dlg.label_165.setVisible(True)
                self.dlg.label_166.setVisible(True)
                
                #Setando a geometria dos labels          
                self.dlg.label_75.setGeometry(530, 20, 181, 16)
                self.dlg.label_76.setGeometry(540, 110, 211, 31)
                self.dlg.label_119.setGeometry(540, 50, 211, 61)                
                self.dlg.label_114.setGeometry(85, 80, 101, 16)
                self.dlg.label_164.setGeometry(63, 60, 171, 16)
                
                self.dlg.label_144.setGeometry(530, 150, 181, 16)
                self.dlg.label_145.setGeometry(540, 240, 211, 31)
                self.dlg.label_143.setGeometry(540, 180, 211, 61)
                self.dlg.label_138.setGeometry(85, 210, 101, 16)
                
                #Mudando o resultado dos labels 2D:
                self.dlg.label_66.setText('Análise de precisão planimetria')
                self.dlg.label_69.setText('Resultado:')
                self.dlg.label_113.setText('Decreto/ET-CQDG')
                self.dlg.label_114.setText(f"{capitalize_first_letter(self.classe_2D_relatorio)}")
                
                #Resultado em vermelho
                self.dlg.label_179.setText(f"{capitalize_first_letter(self.classe_2D_relatorio)}")
                
                #Labels de escala               
                self.dlg.label_161.setText('Escala:')
                self.dlg.label_164.setText(f"1/{self.escala_2D_relatorio}")
                
                #Parte de tendência
                self.dlg.label_70.setText('Análise de tendência planimetria')
                
                #Parte de normalidade
                if self.normalidade_2d:
                
                    self.dlg.label_115.setText('Amostra Normal')
                
                else:
                
                    self.dlg.label_115.setText('Amostra NÃO Normal')
                    
                self.dlg.label_116.setText(self.dlg.label_120.text())
                self.dlg.label_117.setText(self.dlg.label_112.text()) 
                
                #Resultado em vermelho
                self.dlg.label_178.setText(f"{capitalize_first_letter(self.var_tendencia_2D_relatorio)}")
                
                
                #Mudando o resultado de acurácia:               
                if (var_acuracia_2D == 'É ACURADO'):
                    
                    text = f"Produto acurado para a {self.classe_2D_relatorio} na escala 1/{self.escala_2D_relatorio}" 
                    self.dlg.label_119.setText(text)
                
                else:
                    
                    text = f"Produto NÃO acurado" 
                    self.dlg.label_119.setText(text)
                    
                self.dlg.label_75.setText("Análise de acurácia planimetria")
                self.dlg.label_76.setText("Metodologia Santos et al. (2016)")              
                
                ###################################################
                #Mudando o resultado dos labels Z:             
                self.dlg.label_139.setText('Análise de precisão altimetria')
                self.dlg.label_141.setText('Resultado:')
                self.dlg.label_140.setText('Decreto/ET-CQDG')
                self.dlg.label_138.setText(f"{capitalize_first_letter(self.classe_Z_relatorio)}")
                
                #Resultado em vermelho
                self.dlg.label_181.setText(f"{capitalize_first_letter(self.classe_Z_relatorio)}")
                
                #Labels de escala                
                self.dlg.label_165.setText('Equidistância:') #mudar nome do label
                self.dlg.label_166.setText(f"{self.escala_Z_relatorio}m")
                
                #Parte de tendência
                if self.normalidade_z:
                
                    self.dlg.label_133.setText('Amostra Normal')
                
                else:
                
                    self.dlg.label_133.setText('Amostra NÃO Normal')
                    
                self.dlg.label_135.setText(self.dlg.label_129.text())

                #Resultado em vermelho
                self.dlg.label_182.setText(f"{capitalize_first_letter(self.var_tendencia_Z_relatorio)}")
                
                #Mudando o resultado de acurácia:             
                if (var_acuracia_Z == 'É ACURADO'):
                    
                    text = f"Produto acurado para a {self.classe_Z_relatorio}\nna equidistância de {self.escala_Z_relatorio}m" 
                    self.dlg.label_143.setText(text)
                
                else:
                    
                    text = f"Produto NÃO acurado" 
                    self.dlg.label_143.setText(text)
                    
                self.dlg.label_144.setText("Análise de acurácia altimetria")
                self.dlg.label_145.setText("Metodologia Santos et al. (2016)")
                
            else: #Somente decreto
                
                #Deixando as labels visíveis         
                self.dlg.label_66.setVisible(True)
                self.dlg.label_68.setVisible(True)
                self.dlg.label_69.setVisible(True)
                self.dlg.label_113.setVisible(True)
                self.dlg.label_114.setVisible(True)
                self.dlg.label_75.setVisible(True)
                self.dlg.label_76.setVisible(True)
                self.dlg.label_119.setVisible(True)
                
                self.dlg.label_139.setVisible(True)
                self.dlg.label_142.setVisible(True)
                self.dlg.label_141.setVisible(True)
                self.dlg.label_140.setVisible(True)
                self.dlg.label_138.setVisible(True)
                self.dlg.label_144.setVisible(True)
                self.dlg.label_145.setVisible(True)
                self.dlg.label_143.setVisible(True)
                self.dlg.label_179.setVisible(True)
                self.dlg.label_181.setVisible(True)
                
                #quatro labels amais para a escala
                self.dlg.label_161.setVisible(True)
                self.dlg.label_164.setVisible(True)
                self.dlg.label_165.setVisible(True) 
                self.dlg.label_166.setVisible(True)
                
                #Setando a geometria dos labels              
                self.dlg.label_75.setGeometry(280, 20, 181, 16)
                self.dlg.label_76.setGeometry(290, 110, 211, 31)
                self.dlg.label_119.setGeometry(290, 50, 211, 61)
                self.dlg.label_114.setGeometry(85, 80, 101, 16) 
                self.dlg.label_164.setGeometry(63, 60, 171, 16)
                
                self.dlg.label_144.setGeometry(280, 150, 181, 16)
                self.dlg.label_145.setGeometry(290, 240, 211, 31)
                self.dlg.label_143.setGeometry(290, 180, 211, 61)
                self.dlg.label_138.setGeometry(85, 210, 101, 16)
                
                
                #Mudando o resultado dos labels 2D:             
                self.dlg.label_66.setText('Análise de precisão planimetria')
                self.dlg.label_69.setText('Resultado:')
                self.dlg.label_113.setText('Decreto/ET-CQDG')
                self.dlg.label_114.setText(f"{capitalize_first_letter(self.classe_2D_relatorio)}")
                
                #Resultado em vermelho
                self.dlg.label_179.setText(f"{capitalize_first_letter(self.classe_2D_relatorio)}")
                
                #Labels de escala
                self.dlg.label_161.setText('Escala:')
                self.dlg.label_164.setText(f"1/{self.escala_2D_relatorio}")
                
                #Mudando o resultado de acurácia               
                self.dlg.label_75.setText("Análise de acurácia planimetria")
                text = f"Classificação pelo Decreto 89.817:\n{self.dlg.label_124.text()} na escala 1/{self.escala_2D_relatorio}" 
                self.dlg.label_119.setText(text)
 
                self.dlg.label_76.setText("Metodologia ET-CQDG")
                
                ###################################################
                #Mudando o resultado dos labels Z:
                
                self.dlg.label_139.setText('Análise de precisão altimetria')
                self.dlg.label_141.setText('Resultado:')
                self.dlg.label_140.setText('Decreto/ET-CQDG')
                self.dlg.label_138.setText(f"{capitalize_first_letter(self.classe_Z_relatorio)}")
                
                #Resultado em vermelho
                self.dlg.label_181.setText(f"{capitalize_first_letter(self.classe_Z_relatorio)}")
                
                #Labels de escala               
                self.dlg.label_165.setText('Equidistância:')
                self.dlg.label_166.setText(f"{self.escala_Z_relatorio}m")
                
                #Mudando o resultado de acurácia            
                self.dlg.label_144.setText("Análise de acurácia altimetria")
                text = f"Classificação pelo Decreto 89.817:\n{self.dlg.label_127.text()} para a equidistância de {self.escala_Z_relatorio}m." 
                self.dlg.label_143.setText(text)
 
                self.dlg.label_145.setText("Metodologia ET-CQDG")
                              
    def resumo_ANM(self):
        """Este método atualiza a aba de resumo e relatório quando o processamento é da norma ANM"""
        
        #Função para deixar a primeira letra da string maiuscula 
        def capitalize_first_letter(s):
                return s[0].upper() + s[1:]
        
        #Obtendo a opção de processamento
        op = self.op_norma
        
        #Atualizando a interface gráfica 
        
        if (op ==7): #2D
            
            #Deixando as labels visíveis             
            self.dlg.label_66.setVisible(True)
            self.dlg.label_68.setVisible(True)
            self.dlg.label_69.setVisible(True)
            self.dlg.label_113.setVisible(True)
            self.dlg.label_114.setVisible(True)
            self.dlg.label_70.setVisible(True)
            self.dlg.label_71.setVisible(True)
            self.dlg.label_72.setVisible(True)
            self.dlg.label_115.setVisible(True)
            self.dlg.label_116.setVisible(True)
            self.dlg.label_75.setVisible(True)
            self.dlg.label_76.setVisible(True)
            self.dlg.label_119.setVisible(True)
            self.dlg.label_179.setVisible(True)
            self.dlg.label_178.setVisible(True)
            
            #dois labels amais para a escala
            self.dlg.label_161.setVisible(True)
            self.dlg.label_164.setVisible(True)
            
            #Setando a geometria dos labels          
            self.dlg.label_75.setGeometry(530, 20, 181, 16)
            self.dlg.label_76.setGeometry(540, 110, 211, 31)
            self.dlg.label_119.setGeometry(540, 50, 211, 61)                
            self.dlg.label_114.setGeometry(120, 80, 101, 16)
            self.dlg.label_164.setGeometry(63, 60, 171, 16)
            
            #Mudando o resultado dos labels:      
            self.dlg.label_66.setText('Análise de precisão')
            self.dlg.label_69.setText('Decreto/ET-CQDG:')
            self.dlg.label_113.setText('ANM')
            self.dlg.label_114.setText(f"{capitalize_first_letter(self.classe_2D_relatorio)}")            
            
            #Resultado em vermelho
            self.dlg.label_179.setText(f"{capitalize_first_letter(self.classe_2D_relatorio)}")
            
            #Labels de escala
            self.dlg.label_161.setText('Escala:')
            self.dlg.label_164.setText(f"1/{self.escala_2D_relatorio}")
            
            
            #Parte de tendência
            self.dlg.label_70.setText('Análise de tendência')
            
            #Parte de normalidade
            if self.normalidade_2d:
            
                self.dlg.label_115.setText('Amostra Normal')
            
            else:
            
                self.dlg.label_115.setText('Amostra NÃO Normal')
                
            self.dlg.label_116.setText(self.dlg.label_120.text())
            
            #Resultado em vermelho
            self.dlg.label_178.setText(f"{capitalize_first_letter(self.var_tendencia_2D_relatorio)}")
            
            #Mudando o resultado de acurácia:               
            if (self.atende_ANM_2D_relatorio == 'ATENDE'):
                    
                text = f"O produto ATENDE aos critérios de avaliação da acurácia posicional absoluta, de acordo com a Resolução n.123 de 2022 da ANM" 
                self.dlg.label_119.setText(text)
                
            else:
                    
                text = f"O produto NÃO ATENDE aos critérios de avaliação da acurácia posicional absoluta, de acordo com a Resolução n.123 de 2022 da ANM" 
                self.dlg.label_119.setText(text)
                    
            self.dlg.label_75.setText("Análise de acurácia")
            self.dlg.label_76.setText("Metodologia: Resolução 123 de 2022 - ANM")
            
        elif (op ==8): #Z
            
            #Deixando as labels visíveis           
            self.dlg.label_66.setVisible(True)
            self.dlg.label_68.setVisible(True)
            self.dlg.label_69.setVisible(True)
            self.dlg.label_113.setVisible(True)
            self.dlg.label_114.setVisible(True)
            self.dlg.label_70.setVisible(True)
            self.dlg.label_71.setVisible(True)
            self.dlg.label_72.setVisible(True)
            self.dlg.label_115.setVisible(True)
            self.dlg.label_116.setVisible(True)
            self.dlg.label_75.setVisible(True)
            self.dlg.label_76.setVisible(True)
            self.dlg.label_119.setVisible(True)
            self.dlg.label_179.setVisible(True)
            self.dlg.label_178.setVisible(True)
            
            #dois labels amais para a escala
            self.dlg.label_161.setVisible(True)
            self.dlg.label_164.setVisible(True)
            
            #Setando a geometria dos labels         
            self.dlg.label_75.setGeometry(530, 20, 181, 16)
            self.dlg.label_76.setGeometry(540, 110, 211, 31)
            self.dlg.label_119.setGeometry(540, 50, 211, 61)                
            self.dlg.label_114.setGeometry(120, 80, 101, 16)
            self.dlg.label_164.setGeometry(90, 60, 171, 16)
            
            #Mudando o resultado dos labels:         
            self.dlg.label_66.setText('Análise de precisão')
            self.dlg.label_69.setText('Decreto/ET-CQDG:')
            self.dlg.label_113.setText('ANM')
            self.dlg.label_114.setText(f"{capitalize_first_letter(self.classe_Z_relatorio)}")            
            
            #Resultado em vermelho
            self.dlg.label_179.setText(f"{capitalize_first_letter(self.classe_Z_relatorio)}")
            
            #Labels de escala
            self.dlg.label_161.setText('Equidistância:')
            self.dlg.label_164.setText(f"{self.escala_Z_relatorio}m")
            
            #Parte de tendência
            self.dlg.label_70.setText('Análise de tendência')
            
            #Parte de normalidade
            if self.normalidade_z:
            
                self.dlg.label_115.setText('Amostra Normal')
            
            else:
            
                self.dlg.label_115.setText('Amostra NÃO Normal')
                
            self.dlg.label_116.setText(self.dlg.label_120.text())
            
            #Resultado em vermelho
            self.dlg.label_178.setText(f"{capitalize_first_letter(self.var_tendencia_Z_relatorio)}")
            
            #Mudando o resultado de acurácia:              
            if (self.atende_ANM_Z_relatorio == 'ATENDE'):
                    
                text = f"O produto ATENDE aos critérios de avaliação da acurácia posicional absoluta, de acordo com a Resolução n.123 de 2022 da ANM" 
                self.dlg.label_119.setText(text)
                
            else:
                    
                text = f"O produto NÃO ATENDE aos critérios de avaliação da acurácia posicional absoluta, de acordo com a Resolução n.123 de 2022 da ANM" 
                self.dlg.label_119.setText(text)
                    
            self.dlg.label_75.setText("Análise de acurácia")
            self.dlg.label_76.setText("Metodologia: Resolução 123 de 2022 - ANM")
        
        else: #2D e Z
            
            #Deixando as labels visíveis         
            self.dlg.label_66.setVisible(True)
            self.dlg.label_68.setVisible(True)
            self.dlg.label_113.setVisible(True)
            self.dlg.label_69.setVisible(True)
            self.dlg.label_114.setVisible(True)
            self.dlg.label_70.setVisible(True)
            self.dlg.label_71.setVisible(True)
            self.dlg.label_72.setVisible(True)
            self.dlg.label_115.setVisible(True)
            self.dlg.label_116.setVisible(True)
            self.dlg.label_75.setVisible(True)
            self.dlg.label_76.setVisible(True)
            self.dlg.label_119.setVisible(True)
            self.dlg.label_139.setVisible(True)
            self.dlg.label_142.setVisible(True)
            self.dlg.label_141.setVisible(True)
            self.dlg.label_140.setVisible(True)
            self.dlg.label_138.setVisible(True)
            self.dlg.label_132.setVisible(True)
            self.dlg.label_136.setVisible(True)
            self.dlg.label_134.setVisible(True)
            self.dlg.label_133.setVisible(True)
            self.dlg.label_135.setVisible(True)
            self.dlg.label_144.setVisible(True)
            self.dlg.label_145.setVisible(True)
            self.dlg.label_143.setVisible(True)
            
            self.dlg.label_179.setVisible(True)
            self.dlg.label_181.setVisible(True)
            self.dlg.label_178.setVisible(True)
            self.dlg.label_182.setVisible(True)
                
            #quatro labels amais para a escala
            self.dlg.label_161.setVisible(True)
            self.dlg.label_164.setVisible(True)
            self.dlg.label_165.setVisible(True)
            self.dlg.label_166.setVisible(True)
            
            #Setando a geometria dos labels           
            self.dlg.label_75.setGeometry(530, 20, 181, 16)
            self.dlg.label_76.setGeometry(540, 110, 211, 31)
            self.dlg.label_119.setGeometry(540, 50, 211, 61)                
            self.dlg.label_114.setGeometry(120, 80, 101, 16)
            self.dlg.label_164.setGeometry(63, 60, 171, 16)
            
            self.dlg.label_144.setGeometry(530, 150, 181, 16)
            self.dlg.label_145.setGeometry(540, 240, 211, 31)
            self.dlg.label_143.setGeometry(540, 180, 211, 61)
            self.dlg.label_138.setGeometry(120, 210, 101, 16)
            
            #Mudando o resultado dos labels 2D:          
            self.dlg.label_66.setText('Análise de precisão planimetria')
            self.dlg.label_69.setText('Decreto/ET-CQDG:')
            self.dlg.label_113.setText('ANM')
            self.dlg.label_114.setText(f"{capitalize_first_letter(self.classe_2D_relatorio)}")            
            
            #Resultado em vermelho
            self.dlg.label_179.setText(f"{capitalize_first_letter(self.classe_2D_relatorio)}")
                
            #Labels de escala
            self.dlg.label_161.setText('Escala:')
            self.dlg.label_164.setText(f"1/{self.escala_2D_relatorio}")
            
            
            #Parte de tendência
            self.dlg.label_70.setText('Análise de tendência planimetria')
            
            #Parte de normalidade 
            if self.normalidade_2d:
            
                self.dlg.label_115.setText('Amostra Normal')
            
            else:
            
                self.dlg.label_115.setText('Amostra NÃO Normal')
                
            self.dlg.label_116.setText(self.dlg.label_120.text())
            
            #Resultado em vermelho
            self.dlg.label_178.setText(f"{capitalize_first_letter(self.var_tendencia_2D_relatorio)}")
                
            #Mudando o resultado de acurácia:                
            if (self.atende_ANM_2D_relatorio == 'ATENDE'):
                    
                text = f"O produto ATENDE aos critérios de avaliação da acurácia posicional absoluta, de acordo com a Resolução n.123 de 2022 da ANM" 
                self.dlg.label_119.setText(text)
                
            else:
                    
                text = f"O produto NÃO ATENDE aos critérios de avaliação da acurácia posicional absoluta, de acordo com a Resolução n.123 de 2022 da ANM" 
                self.dlg.label_119.setText(text)
                    
            self.dlg.label_75.setText("Análise de acurácia planimetria")
            self.dlg.label_76.setText("Metodologia: Resolução 123 de 2022 - ANM")
         
            ###################################################
            #Mudando o resultado dos labels Z:
            
            self.dlg.label_139.setText('Análise de precisão altimetria')
            self.dlg.label_141.setText('Decreto/ET-CQDG:')
            self.dlg.label_140.setText('ANM')
            self.dlg.label_138.setText(f"{capitalize_first_letter(self.classe_Z_relatorio)}")            
            
            #Resultado em vermelho
            self.dlg.label_181.setText(f"{capitalize_first_letter(self.classe_Z_relatorio)}")
                
            #Labels de escala
            self.dlg.label_165.setText('Equidistância:')
            self.dlg.label_166.setText(f"{self.escala_Z_relatorio}m") #mudar número
            
            
            #Parte de normalidade
            if self.normalidade_z:
            
                self.dlg.label_133.setText('Amostra Normal')
            
            else:
            
                self.dlg.label_133.setText('Amostra NÃO Normal')
            
            #Parte de tendência    
            self.dlg.label_135.setText(self.dlg.label_129.text())
            
            #Resultado em vermelho
            self.dlg.label_182.setText(f"{capitalize_first_letter(self.var_tendencia_Z_relatorio)}")
                
            #Mudando o resultado de acurácia:
                
            if (self.atende_ANM_Z_relatorio == 'ATENDE'):
                    
                text = f"O produto ATENDE aos critérios de avaliação da acurácia posicional absoluta, de acordo com a Resolução n.123 de 2022 da ANM" 
                self.dlg.label_143.setText(text)
                
            else:
                    
                text = f"O produto NÃO ATENDE aos critérios de avaliação da acurácia posicional absoluta, de acordo com a Resolução n.123 de 2022 da ANM" 
                self.dlg.label_143.setText(text)
                    
            self.dlg.label_144.setText("Análise de acurácia altimetria")
            self.dlg.label_145.setText("Metodologia: Resolução 123 de 2022 - ANM")
               
    def resumo_NBR(self):
        """Este método atualiza a aba de resumo e relatório quando o processamento é da norma NBR 13133"""
        
        #Obtendo a opção de processamento
        op = self.op_norma
        
        #Atualizando a interface gráfica
        
        if (op==3): #2D
            
            #Deixando as labels visíveis               
            self.dlg.label_66.setVisible(True)
            self.dlg.label_174.setVisible(True)
            self.dlg.label_161.setVisible(True)
            self.dlg.label_164.setVisible(True)
            self.dlg.label_114.setVisible(True)
            self.dlg.label_69.setVisible(True)
            self.dlg.label_75.setVisible(True)
            self.dlg.label_76.setVisible(True)
            self.dlg.label_119.setVisible(True)
            
            #Setando a geometria dos labels         
            self.dlg.label_75.setGeometry(280, 20, 181, 16)
            self.dlg.label_76.setGeometry(290, 110, 211, 31)
            self.dlg.label_119.setGeometry(290, 50, 211, 61)
            self.dlg.label_114.setGeometry(87, 80, 101, 16)
            self.dlg.label_164.setGeometry(90, 60, 171, 16)
            
            #Mudando o resultado dos labels:            
            self.dlg.label_66.setText('NBR 13133 (2021)')
            self.dlg.label_161.setText('Precisão:')
            self.dlg.label_69.setText('Tolerância:')
            
            #Precisão e tolerância
            self.dlg.label_164.setText(f"{self.var_precisao_2D_NBR_relatorio}")
            self.dlg.label_114.setText(f"{self.var_tolerancia_2D_NBR_relatorio}")
            
            #Mudando a aceitação relativa      
            self.dlg.label_119.setText(self.dlg.label_156.text())
                    
            self.dlg.label_75.setText("ACEITAÇÃO RELATIVA")
            self.dlg.label_76.setText("Metodologia: NBR 13133 de 2021, item 7.2")
            
            
        elif (op==4): #Z
            
            #Deixando as labels visíveis              
            self.dlg.label_66.setVisible(True)
            self.dlg.label_174.setVisible(True)
            self.dlg.label_161.setVisible(True)
            self.dlg.label_164.setVisible(True)
            self.dlg.label_114.setVisible(True)
            self.dlg.label_69.setVisible(True)
            self.dlg.label_75.setVisible(True)
            self.dlg.label_76.setVisible(True)
            self.dlg.label_119.setVisible(True)
            
            #Setando a geometria dos labels            
            self.dlg.label_75.setGeometry(280, 20, 181, 16)
            self.dlg.label_76.setGeometry(290, 110, 211, 31)
            self.dlg.label_119.setGeometry(290, 50, 211, 61)
            self.dlg.label_114.setGeometry(87, 80, 101, 16)
            self.dlg.label_164.setGeometry(90, 60, 171, 16)
            
            #Mudando o resultado dos labels:      
            self.dlg.label_66.setText('NBR 13133 (2021)')
            self.dlg.label_161.setText('Precisão:')
            self.dlg.label_69.setText('Tolerância:')
            
            #Precisão e tolerância
            self.dlg.label_164.setText(f"{self.var_precisao_Z_NBR_relatorio}")
            self.dlg.label_114.setText(f"{self.var_tolerancia_Z_NBR_relatorio}")
            
            #Mudando a aceitação relativa   
            self.dlg.label_119.setText(self.dlg.label_156.text())
                    
            self.dlg.label_75.setText("ACEITAÇÃO RELATIVA")
            self.dlg.label_76.setText("Metodologia: NBR 13133 de 2021, item 7.3")
            
        else: #2D e Z
            
            #Deixando as labels visíveis      
            self.dlg.label_66.setVisible(True)
            self.dlg.label_174.setVisible(True)
            self.dlg.label_161.setVisible(True)
            self.dlg.label_164.setVisible(True)
            self.dlg.label_114.setVisible(True)
            self.dlg.label_69.setVisible(True)
            self.dlg.label_75.setVisible(True)
            self.dlg.label_76.setVisible(True)
            self.dlg.label_119.setVisible(True)           
            self.dlg.label_139.setVisible(True)
            self.dlg.label_175.setVisible(True)
            self.dlg.label_165.setVisible(True)
            self.dlg.label_166.setVisible(True)
            self.dlg.label_141.setVisible(True)         
            self.dlg.label_138.setVisible(True)
            self.dlg.label_144.setVisible(True)
            self.dlg.label_145.setVisible(True)
            self.dlg.label_143.setVisible(True)
            
            #Setando a geometria dos labels      
            self.dlg.label_75.setGeometry(280, 20, 210, 16)
            self.dlg.label_76.setGeometry(290, 110, 211, 31)
            self.dlg.label_119.setGeometry(290, 50, 211, 61)
            self.dlg.label_114.setGeometry(87, 80, 101, 16)
            self.dlg.label_164.setGeometry(90, 60, 171, 16)
            
            self.dlg.label_144.setGeometry(280, 150, 200, 16)
            self.dlg.label_145.setGeometry(290, 240, 211, 31)
            self.dlg.label_143.setGeometry(290, 180, 211, 61)
            self.dlg.label_138.setGeometry(87, 210, 101, 16)
            self.dlg.label_166.setGeometry(90, 190, 171, 16)
            
            #Mudando o resultado dos labels 2D:        
            self.dlg.label_66.setText('NBR 13133 (2021) - Planimetria')
            self.dlg.label_161.setText('Precisão:')
            self.dlg.label_69.setText('Tolerância:')
            
            #Precisão e tolerância
            self.dlg.label_164.setText(f"{self.var_precisao_2D_NBR_relatorio}")
            self.dlg.label_114.setText(f"{self.var_tolerancia_2D_NBR_relatorio}")
            
            #Mudando a aceitação relativa 
            self.dlg.label_119.setText(self.dlg.label_156.text())
                    
            self.dlg.label_75.setText("ACEITAÇÃO RELATIVA PLANIMETRIA")
            self.dlg.label_76.setText("Metodologia: NBR 13133 de 2021, item 7.2")
            
            #Mudando o resultado dos labels Z:   
            self.dlg.label_139.setText('NBR 13133 (2021) - Altimetria')
            self.dlg.label_165.setText('Precisão:')
            self.dlg.label_141.setText('Tolerância:')
            
            #Precisão e tolerância
            self.dlg.label_166.setText(f"{self.var_precisao_Z_NBR_relatorio}")
            self.dlg.label_138.setText(f"{self.var_tolerancia_Z_NBR_relatorio}")
            
            #Mudando a aceitação relativa 
            self.dlg.label_143.setText(self.dlg.label_162.text())
                    
            self.dlg.label_144.setText("ACEITAÇÃO RELATIVA ALTIMETRIA")
            self.dlg.label_145.setText("Metodologia: NBR 13133 de 2021, item 7.3")
        
    def resumo_INCRA(self):
        """Este método atualiza a aba de resumo e relatório quando o processamento é da norma INCRA"""
        
        #Função para deixar a primeira letra da string maiuscula 
        def capitalize_first_letter(s):
                return s[0].upper() + s[1:]
         
        #Deixando os labels visiveis
        
        self.dlg.label_66.setVisible(True)
        self.dlg.label_68.setVisible(True)
        self.dlg.label_69.setVisible(True)
        self.dlg.label_113.setVisible(True)
        self.dlg.label_114.setVisible(True)
        self.dlg.label_179.setVisible(True)
        ###### LABELS DE TIPO DE LIMITE
        self.dlg.label_172.setVisible(True)
        self.dlg.label_173.setVisible(True)
        self.dlg.label_171.setVisible(True)
        self.dlg.label_169.setVisible(True)
        self.dlg.label_170.setVisible(True)
        self.dlg.label_167.setVisible(True)
        self.dlg.label_168.setVisible(True)
        self.dlg.label_184.setVisible(True)
               
        self.dlg.label_75.setVisible(True)
        self.dlg.label_76.setVisible(True)
        self.dlg.label_119.setVisible(True)
        #dois labels amais para a escala
        self.dlg.label_161.setVisible(True)
        self.dlg.label_164.setVisible(True)    
        
        #Setando a geometria dos labels   
        self.dlg.label_75.setGeometry(530, 20, 181, 16)
        self.dlg.label_76.setGeometry(540, 110, 211, 31)
        self.dlg.label_119.setGeometry(540, 50, 211, 61)                
        self.dlg.label_114.setGeometry(120, 80, 101, 16)
        self.dlg.label_164.setGeometry(63, 60, 171, 16)        
        
        #Mudando o resultado dos labels:      
        self.dlg.label_66.setText('Análise de precisão')
        self.dlg.label_69.setText('Decreto/ET-CQDG:')
        self.dlg.label_113.setText('INCRA')
        self.dlg.label_114.setText(f"{capitalize_first_letter(self.classe_2D_relatorio)}")            
        
        #Resultado em vermelho
        self.dlg.label_179.setText(f"{capitalize_first_letter(self.classe_2D_relatorio)}")
                
        #Labels de escala
        self.dlg.label_161.setText('Escala:')
        self.dlg.label_164.setText(f"1/{self.escala_2D_relatorio}")
        
        #Labels de limite - mudar o nome dos labels
        self.dlg.label_171.setText(self.dlg.label_96.text())
        self.dlg.label_170.setText(self.dlg.label_97.text())
        self.dlg.label_168.setText(self.dlg.label_98.text())
        
        #Precisão dos vértices
        dx, dy, dz, d2D, d3D, data  =  self.dados_relatorio 
        self.dlg.label_184.setText(f"Precisão dos vértices (m): {fRms(d2D):.3f}")
        
        #Labels de acurácia
        self.dlg.label_75.setText("Análise de acurácia")
        self.dlg.label_76.setText("Metodologia: Manual Técnico de Georreferenciamento - 2ª edição - 2022")
        self.dlg.label_119.setText(self.dlg.label_125.text())
              
    def atualizaInterface_resumo(self):
        """Este método atualiza a aba de resumo e relatório, é o método principal para atualizar a aba, com base na norma a ser processada"""
        
        #Obtendo a opção de processamento e deixando todas as labels invisiveis
        op = self.op_norma
        self.visibleLabels_resumo()
        
        #Atuaizando a interface gráfica com base na opção de processamento 
        
        if (op==0) or (op==1) or (op==2): #ET CDQG   
        
            self.resumo_ETCQDG()
        
        elif (op==3) or (op==4) or (op==5): #NBR 13133
        
            self.resumo_NBR()
        
        elif (op==6): #INCRA
        
            self.resumo_INCRA()
        
        else: #ANM
        
            self.resumo_ANM()
        
        #Setando a aba de resumo e relatório como a aba corrente
        self.dlg.tabWidget.setCurrentIndex(8)
     
    ###################################################
    #Parte dos gráficos
      
    def FG_exibir_janela_dispersao_2D(self, op):
        """Este método cria o gráfico de dispersão 2D para ser aberto em uma janela do programa ou para ser inserido no relatório"""
        
        
        if (op==1):
            #Verificando se o gráfico está aberto
            if self.graphs_open['dispersao_2d']:
                    return
                    
        #Obtendo os dados para gerar o gráfico        
        dx, dy, dz, d2D, d3D, data = self.dados_relatorio
        dx, dy, dz = fDiscrepancia(data)       
               
        dx_lista = [dx[pt] for pt in itera(dx)]
        dy_lista = [dy[pt] for pt in itera(dy)]
               
        #Obtendo os dados de x e y
        x = dx_lista 
        y =  dy_lista
        
        #Criando uma figura de 11x5 polegadas           
        fig, ax = plt.subplots(figsize=(11, 6))
        
        #Plotando o gráfico de dispersão
        ax.scatter(x,y) 
       
        #Obtendo o módulo  das discrepâncias        
        x_abs = [abs(dx[pt]) for pt in itera(dx)]
        y_abs = [abs(dy[pt]) for pt in itera(dy)]
        
        # Obtendo o range dos valores para definir quais valores devem ser exibidos no gráfico
        #A multplicação por 1.2 aumenta os valores exibidos em até 20% do maior valor do conjunto de dados
        max_range = (max(max(x_abs), max(y_abs))) * 1.2   
        
        # Definindo os valores máximos e minimos a serem exibidos no gráfico
        ax.set_xlim(-max_range, max_range)
        ax.set_ylim(-max_range, max_range)
        
        #Definindo os rótulos dos labels do gráfico
        #Labelpad é offset em relação ao gráfico e rotation a rotação do label
        #Com rotação igual a zero o label "dY", fica na vertical
        
        ax.set_xlabel('dX', labelpad=15)   
        ax.set_ylabel('dY', rotation=0, labelpad=15) 
        
        #Titulo do gráfico
        ax.set_title('Dispersão 2D')
        
        #Definindo as cores das linhas do gráfico
        plt.axhline(0, color='gray', linewidth=.5)
        plt.axvline(0, color='gray', linewidth=.5)
    
        #Definindo função que serve para colocar as linhas no meio do gráfico 
        
        def update_tick_labels(event, ax):     
            for label in ax.get_xticklabels():
                label.set_y(.5)        
            for label in ax.get_yticklabels():
                label.set_x(.5) 
        #Fim da função
        
        #Chamando a função    
        fig.canvas.mpl_connect('resize_event', lambda event: update_tick_labels(event, ax))        
        
        if (op == 1): #Exibir janela do gráfico 
        
            #Mudando a variável de visibilidade do gráfico            
            self.graphs_open['dispersao_2d'] = True
            
            # Título da janela do gráfico 
            fig_manager = plt.get_current_fig_manager()
            fig_manager.set_window_title('Dispersão 2D')
            #Título da janela do gráfico 
            #fig.canvas.set_window_title('Dispersão 2D')
            
            #Definindo o ícone do GeoPEC na janela do gráfico
            plt.get_current_fig_manager().window.setWindowIcon(QtGui.QIcon(self.plugin_dir + "/icon/geopec.png"))
        
            #Conectando o evento de fechamento da janela do gráfico a função onclose, que controla 
            #A variável booleana de fechado e aberto para o gráfico. Ao fechar o gráfico, a variável
            #se torna false, logo o gráfico poderá ser aberto novamente. 
        
            def on_close(event):
                self.graphs_open['dispersao_2d'] = False
            fig.canvas.mpl_connect('close_event', on_close)
                  
            #Exibindo a janela do gráfico       
            plt.show() 
  
        
        else: #Salvar a imagem para o relatório       
            
            '''temp_image_path = self.plugin_dir + '\\images\\temp_image.png'
            plt.savefig(temp_image_path, format='png', bbox_inches='tight')

            # Store the image path in an attribute
            self.imagem_relatorio = temp_image_path '''
            
            # Definir o tamanho da figura em polegadas (largura x altura)
            fig.set_size_inches(15, 8.5)
            
            #Obtendo um objeto de mémoria para salvar a imagem
            image_stream = io.BytesIO()
            #Salvando a imagem no objeto de memória
            plt.savefig(image_stream, format='png', bbox_inches='tight')
            image_stream.seek(0)  # Go to the beginning of the BytesIO object
            
            #Fechando a janela do gráfico 
            plt.close()
            
            # Adicionando o objeto à lista de rastreamento
            self.bytes_io_objects.append(image_stream)
            #Retornando a imagem para ser inserida no relatório
            return image_stream
        
    def FG_exibir_gv_dispersao_2D(self):   
        """Este método cria o gráfico de dispersão 2D e insere no graphicview correspondente"""
        
        #Obtendo os dados de discrepâncias
        dx, dy, dz, d2D, d3D, data = self.dados_relatorio
        dx, dy, dz = fDiscrepancia(data)       

        dx_lista = [dx[pt] for pt in itera(dx)]
        dy_lista = [dy[pt] for pt in itera(dy)]

        # dados de x, recebe as discrepâncias em x
        x =  np.array(dx_lista) 
        # dados de teste em y
        y =  np.array(dy_lista)
        
        #criação de uma figura e um conjunto de eixos (subplots) com tamanho de 6.5 e 2.8, em polegadas         
        fig, ax = plt.subplots(figsize=(6.5, 2.8))  
        
        # plota um gráfico de DISPERSAO com valores x e y fornecidos
        ax.scatter(x, y)
        
        #Obtendo o módulo  das discrepâncias        
        x_abs = [abs(dx[pt]) for pt in itera(dx)]
        y_abs = [abs(dy[pt]) for pt in itera(dy)]
        
        # aumento do range do retangulo em 10%
        max_range = (max(max(x_abs), max(y_abs))) * 1.5  
        
        # configurando os eixos x e y, respectivamente, para o max_range definido anteriormente
        ax.set_xlim(-max_range, max_range)
        ax.set_ylim(-max_range, max_range)
        
        # labels dX e dY, com as rotations correspondentes para o texto ficar "em pé"
        # por ser gv, desloquei a conteudo do gráfico usando esse labelpad, e o valor 15 foi o que melhor encaixou
        ax.set_xlabel('dX', labelpad=5)
        ax.set_ylabel('dY', rotation=0, labelpad=15)
        
        #titulo no gráfico
        #ax.set_title('Dispersão 2D')
        ## Definindo as linhas em x=0 e y=0 
        plt.axhline(0, color='gray', linewidth=0.5)
        plt.axvline(0, color='gray', linewidth=.5)
        
        ## Encaixando gráfico no graphicView correspondente
        ##forma de encaixar o gráf no gv sem cortar
        fig.tight_layout(pad=0.5) 
        
        ##essa linha evita que o gráf configurado para o gv apareça como tela maximizável
        plt.close()     
        
        #funç para trazer os tick_labels para o centro do retangulo do gráfico - INICIO
       
        def update_tick_labels(event, ax):
       
            for label in ax.get_xticklabels():
                label.set_y(.5)
            for label in ax.get_yticklabels():
                label.set_x(.5) 
                
        fig.canvas.mpl_connect('resize_event', lambda event: update_tick_labels(event, ax))
        #funç para trazer os tick_labels para o centro do retangulo do gráfico - FIM
        
        # Limpar o layout atual do graphicsView_2 antes de configurar o novo gráfico
        if self.dlg.graphicsView_2.layout() is not None:
            
            # Obtenha o layout atual do graphicsView_2 e remova-o
            self.dlg.graphicsView_2.layout().deleteLater()
            QApplication.processEvents()
            # Agende a chamada do método FG_exibir_gv_dispersao_2D após um pequeno atraso
            QTimer.singleShot(1, self.FG_exibir_gv_dispersao_2D)
       
        
        ##a partir dessa linha, insere-se o gráf no gv
        canvas0 = FigureCanvas(fig)         
        layout0 = QVBoxLayout()  
        
        ## config dist das margens - centralizando manualmente o gráfico, Margem de 0 pixels, melhorou a exibição
        layout0.setContentsMargins(0,15, 10, 0) 
        layout0.addWidget(canvas0) 
        
        # por fim, insere-se o layout0 no graphicView correspondente ao graf de disp 2d
        self.dlg.graphicsView_2.setLayout(layout0)

    ## graf de dispersao z, para tela maximizavel
    def FG_exibir_janela_dispersao_Z(self, op):
        
        if (op ==1):
        #Verificando se a janela do gráfico está aberta
            if self.graphs_open['dispersao_z']:
                return
            
        
        #Obtendo os dados para gerar o gráfico
        dx, dy, dz, d2D, d3D, data = self.dados_relatorio      
        dz_lista = [dz[pt] for pt in itera(dz)]
        dz_pts = [int(pt) for pt in itera(dz)]
              
        #Repassando os dados do gráfico para as variáveis x e y
        x = dz_pts  
        y = dz_lista  
         
        #Criando uma figura de 8x6 polegadas
        fig, ax = plt.subplots(figsize=(8, 6)) 
        
        #Plotando o gráfico de dispersão
        ax.scatter(x, y)
        
        #Obtendo o módulo dos valores dos dados
        abs_x = [abs(val) for val in x]
        abs_y = [abs(val) for val in y]
        
        #Obtendo o máximo range para criação do gráfico e multiplicando por 1.1
        #Para ter um limite maior no intervalo de dados que irão aparecer no gráfico
        max_range = max(max(abs_x), max(abs_y)) * 1.1
        
        #Definindo os valores máximos e minimos que irão aparecer no gráfico
        ax.set_xlim(-max_range, max_range)
        ax.set_ylim(-max_range, max_range)
        
        #Definindo os rótulos do gráfico
        ax.set_xlabel('ID', labelpad=15)
        ax.set_ylabel('dZ', rotation=0, labelpad=15)
        
        #Definindo o título do gráfico
        ax.set_title('Dispersão Z')
        
        #Definindo as cores das linhas do gráfico
        plt.axhline(0, color='gray', linewidth=.5)      
        plt.axvline(0, color='gray', linewidth=.5)
        
        #Definindo função para colocar as linhas do gráfico no meio
        def update_tick_labels(event, ax):
            for label in ax.get_xticklabels():
                label.set_y(.5)
            for label in ax.get_yticklabels():
                label.set_x(.5)  
        #Fim da função
        
        #Chamando a função
        fig.canvas.mpl_connect('resize_event', lambda event: update_tick_labels(event, ax))

        if (op==1): #Exibir a janela do gráfico
            
            #Mudando a variável de visibilidade do gráfico
            self.graphs_open['dispersao_z'] = True                    
            
            # Título da janela do gráfico 
            fig_manager = plt.get_current_fig_manager()
            fig_manager.set_window_title('Dispersão Z')
            #Título da janela do gráfico
            #fig.canvas.set_window_title('Dispersão Z')
            
            #Definindo o ícone do GeoPEC na janela do gráfico
            plt.get_current_fig_manager().window.setWindowIcon(QtGui.QIcon(self.plugin_dir + "/icon/geopec.png"))
             
            #Conectando o evento de fechamento da janela do gráfico a função onclose, que controla 
            #A variável booleana de fechado e aberto para o gráfico. Ao fechar o gráfico, a variável
            #se torna false, logo o gráfico poderá ser aberto novamente. 
            def on_close(event):
                self.graphs_open['dispersao_z'] = False
            fig.canvas.mpl_connect('close_event', on_close)
            
            #Exibindo a janela do gráfico 
            plt.show()  
        
        else: # Salvar imagem 
            
            # Definir o tamanho da figura em polegadas (largura x altura)
            fig.set_size_inches(15, 8.5)
            
            #Obtendo um objeto de mémoria para salvar a imagem
            image_stream = io.BytesIO()
            #Salvando a imagem no objeto de memória
            plt.savefig(image_stream, format='png', bbox_inches='tight')
            image_stream.seek(0)  # Go to the beginning of the BytesIO object
            
            #Fechando a janela do gráfico 
            plt.close()
            
            # Adicionando o objeto à lista de rastreamento
            self.bytes_io_objects.append(image_stream)
            
            #Retornando a imagem para ser inserida no relatório
            return image_stream
             
    ## graf de dispersao z, para GRAPHICVIEW
    def FG_exibir_gv_dispersao_Z(self):
        
        dx, dy, dz, d2D, d3D, data = self.dados_relatorio
        
        dz_lista = [dz[pt] for pt in itera(dz)]
        dz_pts = [int(pt) for pt in itera(dz)]
        
        x = dz_pts
        y = dz_lista
        
        #criação de uma figura e um conjunto de eixos (subplots) com tamanho de 6.5 e 2.8, em polegadas  
        fig, ax = plt.subplots(figsize=(6.5, 2.8)) ## muda tamanho da janela maximizavel                ##[11, 7, 52, 9, 15, 25, 33, 11, 45, 41]
        
        ## plotando na figura os pts de x e y, em forma de pontos azuis
        ax.scatter(x, y)
        
        # Calculando os valores máximos em modulos de x e y
        abs_x = [abs(val) for val in x]
        abs_y = [abs(val) for val in y]
        
        ##fazendo o intervalo extrapolar o limite em 10%
        max_range = max(max(abs_x), max(abs_y)) * 1.1
        
        ## Define quais os valores maximos e minimos mostrados no eixo x e y, respectivamente
        ax.set_xlim(-max_range, max_range)
        ax.set_ylim(-max_range, max_range)
        
        ## inserindo os rotulos dos eixos x e y
        # por ser gv, desloquei a conteudo do gráfico usando esse labelpad, e o valor 5 e 15 ficaram bons
        ax.set_xlabel('ID', labelpad=5)
        ax.set_ylabel('dZ', rotation=0, labelpad=15)
        
        # título do gráfico
        #ax.set_title('Dispersão Z')
        
        ## linhas em x=0 e y=0
        plt.axhline(0, color='gray', linewidth=.5)
        plt.axvline(0, color='gray', linewidth=.5)
        
        ## encaixando melhor o gráfico na GV
        fig.tight_layout(pad=1.1 )
        
        ##fecha janela maximizavel(no gv nao queremos)
        ## por algum motivo, por padrão, quando estava chamando o gráfico no GV, o qgis
        ## exibia o gráfico no GV mas tambem na tela maximizavel
        plt.close(fig) 
         
        #funç para trazer os tick_labels para o centro do retangulo do gráfico - INICIO
        def update_tick_labels(event, ax):
            for label in ax.get_xticklabels():
                label.set_y(.5)
            for label in ax.get_yticklabels():
                label.set_x(.5)       
        fig.canvas.mpl_connect('resize_event', lambda event: update_tick_labels(event, ax))
        #funç para trazer os tick_labels para o centro do retangulo do gráfico - FIM
        
        # Limpar o layout atual do graphicsView_2 antes de configurar o novo gráfico
        if self.dlg.graphicsView_6.layout() is not None:
            
            # Obtenha o layout atual do graphicsView_2 e remova-o
            self.dlg.graphicsView_6.layout().deleteLater()
            QApplication.processEvents()
            # Agende a chamada do método FG_exibir_gv_dispersao_2D após um pequeno atraso
            QTimer.singleShot(1, self.FG_exibir_gv_dispersao_Z)
                
        ##inserindo o gráfico no gv
        canvas = FigureCanvas(fig)
        layout1 = QVBoxLayout()
        ## ajusatndo as margens para melhor visualização
        layout1.setContentsMargins(0, 15, 10, 0)  
        layout1.addWidget(canvas)
        ## fazendo o gráf aparecer na GV correta
        self.dlg.graphicsView_6.setLayout(layout1)
    
    def FG_exibir_janela_discrepancias_2D(self, op):
        """Este método cria o gráfico de discrepâncias 2D para ser aberto em uma janela do programa ou para ser inserido no relatório"""
        
        if (op ==1):
        #Verificando se a janela do gráfico está aberta
            if self.graphs_open['tendencia_en']:
                return
        
        
        #Obtendo os dados para gerar o gráfico
        dx, dy, dz, d2D, d3D, data = self.dados_relatorio
        dx, dy, dz = fDiscrepancia(data)       
        d2D = fDiscrepancia2D(dx, dy)
        
        dx_lista = [dx[pt] for pt in itera(dx)]
        dy_lista = [dy[pt] for pt in itera(dy)]
        d2D_lista = [d2D[pt] for pt in itera(d2D)]
        
        #Repassando os dados para as variáveis que serão chamadas na função
        dados_x = [pt for pt in itera(dx)]  
        
        # erros em e
        erros_e = dx_lista   
        
        # erros em n
        erros_n = dy_lista
        
        # erros resultantes 2d
        erros_resultantes =  d2D_lista     
        
        # largura da barra, .2 se encaixou bem
        largura_barra = 0.2
        
        #determinando o tamanho dos nomes dos pts
        x = np.arange(len(dados_x))  
        
        # Criando uma figura de 11X5 polegadas
        fig, ax = plt.subplots(figsize=(11, 5)) 
        
        # Plotando as barras de erro em E
        barra_e = ax.bar(x - largura_barra, erros_e, largura_barra, label='X - Este (m)', color='yellow', edgecolor='black')
        
        # Plotando as barras de erro em N
        barra_n = ax.bar(x, erros_n, largura_barra, label= 'Y - Norte (m)', color='green', edgecolor='black')
        
        # Plotando as barras de erro resultantes
        barra_res = ax.bar(x + largura_barra, erros_resultantes, largura_barra, label='2D - Posicional (m)', color='red', edgecolor='black')
        
        
        # Adicionando traços horizontais para quando valores sao zero
        for i in range(len(dados_x)):
            if erros_e[i] == 0:
                ax.hlines(0, x[i] - largura_barra - largura_barra/2, x[i] - largura_barra + largura_barra/2, color=barra_e[0].get_facecolor())
            if erros_n[i] == 0:
                ax.hlines(0, x[i] - largura_barra/2, x[i] + largura_barra/2, color=barra_n[0].get_facecolor())
            if erros_resultantes[i] == 0:
                ax.hlines(0, x[i] + largura_barra - largura_barra/2, x[i] + largura_barra + largura_barra/2, color=barra_res[0].get_facecolor())
 
        #Definindo os labels do gráfico
        ax.set_xlabel('Pontos de checagem (Nome)')
        ax.set_ylabel('Discrepâncias (m)')
        
        #Título do gráfico
        ax.set_title('Gráfico das discrepâncias posicionais planimétricas')
        
        #Definindo os nomes dos pontos
        #ax.set_xticks(x)
        #ax.set_xticklabels(dados_x)
  
        if len(dados_x) > 20:  
            step = len(dados_x) // 20  
            ax.set_xticks(x[::step])
            ax.set_xticklabels(dados_x[::step])
        else:
            ax.set_xticks(x)
            ax.set_xticklabels(dados_x)
        
        #Definindo o tamanho da legenda do gráfico
        ax.legend(fontsize = 12) 
        
        ##tamanho da fonte para legenda - repare que é diferente para o gv
        # loc e bbox_to_anchor servem para alterar a posição da legenda
        ax.legend(fontsize=12, loc='upper left', bbox_to_anchor=(1, 1)) 
        # a legenda, quando inserida fora do gráfico, estava sendo cortada
        # e o gráfico com legenda nao estava centralizado. Sendo assim,
        # a linha abaixo faz esse acerto 
        plt.subplots_adjust(right=0.75)
        
        
        
        
        if (op==1): #Exibir janela do gráfico
            
            #Alterando a variável de visibilidade do gráfico 
            self.graphs_open['tendencia_en'] = True
            
            # Título da janela do gráfico 
            fig_manager = plt.get_current_fig_manager()
            fig_manager.set_window_title('Gráfico Discrepâncias 2D')
            
            #Título da janela do gráfico 
            #fig.canvas.set_window_title('Gráfico Discrepâncias 2D')
            
            #Definindo o ícone do GeoPEC na janela do gráfico
            plt.get_current_fig_manager().window.setWindowIcon(QtGui.QIcon(self.plugin_dir + "/icon/geopec.png"))
             
            #Conectando o evento de fechamento da janela do gráfico a função onclose, que controla 
            #A variável booleana de fechado e aberto para o gráfico. Ao fechar o gráfico, a variável
            #se torna false, logo o gráfico poderá ser aberto novamente.
            def on_close(event):
                self.graphs_open['tendencia_en'] = False
            fig.canvas.mpl_connect('close_event', on_close)
            
            #Exibindo a janela do gráfico
            plt.show()     
        
        else: # Salvar imagem 
            
            # Definir o tamanho da figura em polegadas (largura x altura)
            fig.set_size_inches(15, 8.5)
            
            #Obtendo um objeto de mémoria para salvar a imagem
            image_stream = io.BytesIO()
            #Salvando a imagem no objeto de memória
            plt.savefig(image_stream, format='png', bbox_inches='tight')
            image_stream.seek(0)  # Go to the beginning of the BytesIO object
            
            #Fechando a janela do gráfico 
            plt.close()
            
            # Adicionando o objeto à lista de rastreamento
            self.bytes_io_objects.append(image_stream)
            
            #Retornando a imagem para ser inserida no relatório
            return image_stream
        
    def FG_exibir_gv_discrepancias_2D(self):
        """Este método cria o gráfico de discrepâncias 2D e insere no graphicView correspondente"""
        
        #Obtendo os dados para gerar o gráfico
        dx, dy, dz, d2D, d3D, data = self.dados_relatorio
        dx, dy, dz = fDiscrepancia(data)       
        d2D = fDiscrepancia2D(dx, dy)
            
        dx_lista = [dx[pt] for pt in itera(dx)]
        dy_lista = [dy[pt] for pt in itera(dy)]
        d2D_lista = [d2D[pt] for pt in itera(d2D)]
        
        # Dados de exemplo
        # nome dos pts (poderia ser id1, id2, etc) ou ['Pt 1', 'Pt 2', 'Pt 3', 'Pt 4', 'Pt 5']
        dados_x = [pt for pt in itera(dx)]  
        
        # erros em e
        erros_e = dx_lista   
        
        # erros em n
        erros_n = dy_lista
        
        ## erros resultantes 2d... os dados que aqui estão sao só de exemplo
        erros_resultantes =  d2D_lista     
            
        #largura da barra, tamanho ficou bom
        largura_barra = 0.2
        
        ## contando a quantidade de pts a ser inserida no gráfico
        x = np.arange(len(dados_x))
        
        # criação de uma figura e um conjunto de eixos (subplots), alem do tamanho
        fig, ax = plt.subplots(figsize=(3.5, 2.8))  
        
        # Plotar as barras de erro em E
        barra_e = ax.bar(x - largura_barra, erros_e, largura_barra, label='X - Este (m)', color='yellow')
        
        # Plotar as barras de erro em N
        barra_n = ax.bar(x, erros_n, largura_barra, label='Y - Norte (m)', color='green')
        
        # Plotar as barras de erro resultantes
        barra_res = ax.bar(x + largura_barra, erros_resultantes, largura_barra, label='2D - Posicional (m)' , color='red')
       
        # Adicionando traços horizontais para quando valores sao zero
        for i in range(len(dados_x)):
            if erros_e[i] == 0:
                ax.hlines(0, x[i] - largura_barra - largura_barra/2, x[i] - largura_barra + largura_barra/2, color=barra_e[0].get_facecolor())
            if erros_n[i] == 0:
                ax.hlines(0, x[i] - largura_barra/2, x[i] + largura_barra/2, color=barra_n[0].get_facecolor())
            if erros_resultantes[i] == 0:
                ax.hlines(0, x[i] + largura_barra - largura_barra/2, x[i] + largura_barra + largura_barra/2, color=barra_res[0].get_facecolor())
        
        
        # Configurações do gráfico, nome dos eixos e seus "offsets"
        ax.set_xlabel('Pontos de checagem (Nome)', labelpad=-1)
        ax.set_ylabel('Discrepâncias (m)', labelpad=-1)
        
        #titulo do graf
        #ax.set_title('Discrepâncias')
        ## dando nome aos pontos e fazendo aparecer eles no GV
        #ax.set_xticks(x)
        #ax.set_xticklabels(dados_x)
        
        ## plotando os ticks com numero de dados e os dados, respectivamente
        # Ajustar os ticks do eixo x para evitar sobreposição
        # se o numero de dados for maior que 20, ele só mostra 20 dos dados
        # sendo assim, os outros ficam omitidos no eixo horizontal
        # se for menor ou igual a 20, ele exibe todos os pts
        if len(dados_x) > 6:  
            step = len(dados_x) //  6 
            ax.set_xticks(x[::step])
            ax.set_xticklabels(dados_x[::step])
        else:
            ax.set_xticks(x)
            ax.set_xticklabels(dados_x)    
        
        ## tamanh para legenda no GV (menor que na tela maximizavel)
        ax.legend(fontsize = 7.)
        
        # Ajustar o layout para evitar cortes
        fig.tight_layout(pad=2 )
        canvas = FigureCanvas(fig)
        
        ##fechando o grafico maximizavel, que aparece automaticamente quando insiro essa funç
        plt.close(fig)  
        
        # Limpar o layout atual do graphicsView_3 antes de configurar o novo gráfico
        if self.dlg.graphicsView_3.layout() is not None:
            
            # Obtenha o layout atual do graphicsView_3 e remova-o
            self.dlg.graphicsView_3.layout().deleteLater()
            QApplication.processEvents()
            # Agende a chamada do método FG_exibir_gv_dispersao_2D após um pequeno atraso
            QTimer.singleShot(1, self.FG_exibir_gv_discrepancias_2D)
        
        
        ##inserindo o graphico em uma posição no GV
        layout2 = QVBoxLayout()
        layout2.setContentsMargins(0, 15, 0, 0)  # Margem de 0 pixels
        layout2.addWidget(canvas)
        self.dlg.graphicsView_3.setLayout(layout2)
          
    def FG_exibir_janela_discrepancias_Z(self, op):
        """Este método cria o gráfico de discrepâncias Z para ser aberto em uma janela do programa ou para ser inserido no relatório"""
        
        if (op ==1):
        #Verificando se a janela do gráfico está aberta
            if self.graphs_open['tendencia_z']:
                return      
        
        #Obtendo os dados para gerar o gráfico       
        dx, dy, dz, d2D, d3D, data = self.dados_relatorio       
        dz_lista = [dz[pt] for pt in itera(dz)]
        dz_pts = [pt for pt in itera(dz)]
        
        #Nomes do pontos
        nomes = dz_pts
        
        #Discrepâncias em Z
        erros_z = dz_lista
        
        # Largura da barra, 0.6 se encaixou bem
        largura_barra = 0.6
        
        # Determinando o tamanho dos nomes dos pontos
        x = np.arange(len(dz_pts))  
        
        # Criando uma figura com 8x6 polegadas
        fig, ax = plt.subplots(figsize=(11, 5)) 
        
        # Plotando as discrepâncias em Z
        barra_z = ax.bar(x, erros_z, largura_barra, label= 'Z - Altitude(m)' , color='red', edgecolor='black')
        
        # Adicionando traços horizontais para quando valor=0
        for i in range(len(nomes)):
            if erros_z[i] == 0:
                ax.hlines(0, x[i] - largura_barra/2, x[i] + largura_barra/2, color=barra_z[0].get_facecolor())
        
        #Definindo os labels do gráfico
        ax.set_xlabel('Pontos de checagem (Nome)')
        ax.set_ylabel('Discrepâncias (m)')
        
        #Título do gráfico
        ax.set_title('Gráfico das discrepâncias posicionais altimétricas')
        
        #Definindo os nomes dos pontos
        ## plotando os ticks com numero de dados e os dados, respectivamente
        # Ajustar os ticks do eixo x para evitar sobreposição
        # se o numero de dados for maior que 20, ele só mostra 20 dos dados
        # sendo assim, os outros ficam omitidos no eixo horizontal
        # se for menor ou igual a 20, ele exibe todos os pts
        if len(nomes) > 20:  
            step = len(nomes) // 20  
            ax.set_xticks(x[::step])
            ax.set_xticklabels(nomes[::step])
        else:
            ax.set_xticks(x)
            ax.set_xticklabels(nomes)
        
        
        
        #ax.set_xticks(x)
        #ax.set_xticklabels(nomes)
        
        # Tamanho da fonte para legenda - repare que é diferente para o graphicView
        # loc e bbox_to_anchor servem para alterar a posição da legenda
        ax.legend(fontsize=12, loc='upper left', bbox_to_anchor=(1, 1)) 
        # a legenda, quando inserida fora do gráfico, estava sendo cortada
        # e o gráfico com legenda nao estava centralizado. Sendo assim,
        # a linha abaixo faz esse acerto 
        plt.subplots_adjust(right=0.8)
        
        if (op==1): #Exibir janela do gráfico
            
            #Mudando a variável de visibilidade do gráfico
            self.graphs_open['tendencia_z'] = True
            
            # Título da janela do gráfico 
            fig_manager = plt.get_current_fig_manager()
            fig_manager.set_window_title('Gráfico Discrepâncias Z')
            
            #Título da janela do gráfico
            #fig.canvas.set_window_title('Gráfico Discrepâncias Z')
            
            #Definindo o ícone do GeoPEC na janela do gráfico
            plt.get_current_fig_manager().window.setWindowIcon(QtGui.QIcon(self.plugin_dir + "/icon/geopec.png"))
                     
            #Conectando o evento de fechamento da janela do gráfico a função onclose, que controla 
            #A variável booleana de fechado e aberto para o gráfico. Ao fechar o gráfico, a variável
            #se torna false, logo o gráfico poderá ser aberto novamente.
            def on_close(event):
                self.graphs_open['tendencia_z'] = False
            # Conecta o evento de fechamento da janela à função on_close
            fig.canvas.mpl_connect('close_event', on_close)
            
            #Exibindo a janela do gráfico
            plt.show()     
        
        else: #Salvar imagem
            
            # Definir o tamanho da figura em polegadas (largura x altura)
            fig.set_size_inches(15, 8.5)
            
            #Obtendo um objeto de mémoria para salvar a imagem
            image_stream = io.BytesIO()
            #Salvando a imagem no objeto de memória
            plt.savefig(image_stream, format='png', bbox_inches='tight')
            image_stream.seek(0)  # Go to the beginning of the BytesIO object
            
            #Fechando a janela do gráfico 
            plt.close()
            
            # Adicionando o objeto à lista de rastreamento
            self.bytes_io_objects.append(image_stream)
            
            #Retornando a imagem para ser inserida no relatório
            return image_stream
   
    def FG_exibir_gv_discrepancias_Z(self):
        """Este método cria o gráfico de discrepâncias Z e insere no graphicView correspondente"""
        
        #Obtendo os dados para gerar o gráfico
        dx, dy, dz, d2D, d3D, data = self.dados_relatorio
   
        dz_lista = [dz[pt] for pt in itera(dz)]
        dz_pts = [pt for pt in itera(dz)]
        
        # Dados de exemplo
        # Nome dos pontos (poderia ser id1, id2, etc)
        nomes = dz_pts
        
        # Dados de exemplo para Z
        erros_z = dz_lista
        
        # Largura da barra, tamanho ficou bom
        largura_barra = 0.6   
        
        # Contando a quantidade de pontos a ser inserida no gráfico
        x = np.arange(len(nomes))
        
        # Criação de uma figura e um conjunto de eixos (subplots), além do tamanho
        fig, ax = plt.subplots(figsize=(3.5, 2.8))
        
        # Plotar as barras de erro em Z        
        barra_z = ax.bar(x, erros_z, largura_barra, label='Z - Altitude(m)', color='red')
        
        # Adicionando traços horizontais para quando valor=0
        for i in range(len(nomes)):
            if erros_z[i] == 0:
                ax.hlines(0, x[i] - largura_barra/2, x[i] + largura_barra/2, color=barra_z[0].get_facecolor())
        
        # Configurações do gráfico, nome dos eixos e seus "offsets"
        ax.set_xlabel('Pontos de checagem (Nome)', labelpad=-1)
        ax.set_ylabel('Discrepâncias (m)', labelpad=-1)
        
        # Título do gráfico
        #ax.set_title('Discrepâncias em Z')
        
        # Dando nome aos pontos e fazendo aparecer eles no GraphicView
        ## plotando os ticks com numero de dados e os dados, respectivamente
        # Ajustar os ticks do eixo x para evitar sobreposição
        # se o numero de dados for maior que 6, ele só mostra 6 dos dados
        # sendo assim, os outros ficam omitidos no eixo horizontal
        # se for menor ou igual a 6, ele exibe todos os pts
        if len(nomes) > 6:  
            step = len(nomes) //  6 
            ax.set_xticks(x[::step])
            ax.set_xticklabels(nomes[::step])
        else:
            ax.set_xticks(x)
            ax.set_xticklabels(nomes)
               
        #ax.set_xticks(x)
        #ax.set_xticklabels(nomes)
        
        # Tamanho para legenda no GraphicView (menor que na tela maximizável)
        ax.legend(fontsize=7.)
        
        # Ajustar o layout para evitar cortes
        fig.tight_layout(pad=2)
        
        # Criação do canvas
        canvas = FigureCanvas(fig)
        
        # Fechar o gráfico maximizável, que aparece automaticamente quando insiro essa função
        plt.close(fig)
        
        # Limpar o layout atual do graphicsView_7 antes de configurar o novo gráfico
        if self.dlg.graphicsView_7.layout() is not None:
            
            # Obtenha o layout atual do graphicsView_2 e remova-o
            self.dlg.graphicsView_7.layout().deleteLater()
            QApplication.processEvents()
            # Agende a chamada do método FG_exibir_gv_dispersao_2D após um pequeno atraso
            QTimer.singleShot(1, self.FG_exibir_gv_discrepancias_Z)
        
        
        # Inserindo o gráfico em uma posição no GraphicView
        layout2 = QVBoxLayout()
        layout2.setContentsMargins(0, 15, 0, 0)  # Margem de 0 pixels
        layout2.addWidget(canvas)
        self.dlg.graphicsView_7.setLayout(layout2)
    
    def FG_exibir_janela_boxplot(self, dados, op, op_exib):
        """Este método cria o gráfico de boxplot para ser aberto em uma janela do programa ou para ser inserido no relatório"""
        
        if (op ==1):
        #Verificando se a janela do gráfico está aberta        
            if self.graphs_open['boxplot_2D'] and self.graphs_open['boxplot_Z'] :
                return
        
        #Obtendo os dados para gerar os gráficos
        dados_lista, dados_pts = dados
        
        
        # Criando uma figura de 8x6 polegadas
        #fig, ax = plt.subplots(figsize=(8, 6))

        dados_listat = {}
        i = 0
        for pt in dados_pts:
            
            dados_listat[pt] = dados_lista[i]
            i = i+1
        
        
        # Calcular os quartis e o IQR
        Q1 = fCalcQ1(dados_listat)
        Q3 = fCalcQ3(dados_listat)
        IQR = Q3 - Q1

               
        fator_interquartil= float(self.fator_boxplot)
        
        # Cálculo dos limites superior e inferior usando o fator interquartil
        # Conforme aula teórica CQC - Afonso
        limite_inferior = Q1 - fator_interquartil * IQR
        limite_superior = Q3 + fator_interquartil * IQR
        
        data = np.array(dados_lista)
        
        # Identificando os outliers
        outliers = [point for point in data if point < limite_inferior or point > limite_superior]
         
        
        # Criar uma figura e um eixo para o gráfico de boxplot, com tamanho padrao de 10 e 6
        fig, ax = plt.subplots(figsize=(11, 6))
        # Criar o gráfico de BOXPLOT, com os dados inseridos
        # whis=0 corresponde aos bigodes antigos estarem desativados, ou seja, permanece
        # só as linhas "T" nos intervalos entre os quartis e lim sup e inf. 
        # whis=0 faz o bigode original do boxplot sumir (útil pois estamos definindo
        #  outro limite superior e outro limite inferior)
        # showfliers=False faz com que os pontos que NAO sao outliers nao apareçam entre
        #  1º quartil e o limite inferior e o 3º quartil e o limite superior.
        # e patch_artist=False faz com que nao haja preenchimento do retangulo do boxplot
        
        # Cálculo da mediana  de acordo com os valores de entrada
        median = np.median(list(dados_listat.values()))  
                
        
        # Desenhar o retângulo que representa a caixa com o Q1 e Q3 
        rect = Rectangle((.95, Q1), 0.1, Q3 - Q1, fill=False, color='black')
        ax.add_patch(rect)

        # Adicionar a linha laranja para a mediana
        ax.hlines(median, 0.95, 1.05, color='orange', linestyle='-', linewidth=2)
        
        # Centraliza as componentes do boxplot dentro do quadrado de exibição do gráfico 
        # colcoando espaçamento em branco tanto para a esquerda quanto a direita.
        ax.set_xlim(0.8, 1.2)
        
        
        # Adicionando linhas horizontais referentes aos limites inferior e superior
        ax.hlines(limite_inferior, 0.95, 1.05, color='black', linestyle='-', linewidth=1)  
        ax.hlines(limite_superior, 0.95, 1.05, color='black', linestyle='-', linewidth=1)  
        
        
        # Adicionando linhas verticais que liga os quartis 1 e 3 aos limites inf e sup, respectivamente
        ax.plot([1, 1], [Q1, limite_inferior], 'k-', linewidth=1)  # linha do quartil 1 até o limite inferior
        ax.plot([1, 1], [Q3, limite_superior], 'k-', linewidth=1)  # linha do quartil 3 até o limite superior
        
        ##Plotando outliers identificados
        ax.scatter([1] * len(outliers), outliers, color='black', zorder=5)
            
        ##inserindo titulo do grafico 
        #ax.set_title('Boxplot')
        
        ax.set_title('Gráfico de detecção de outliers pelo diagrama Boxplot')
        # Nome do eixo y
        ax.set_ylabel('Valores')
        # Removendo o rótulo "1" acima do eixo x - na vdd é rotulo padrao
        # para o 1o grupo de dados, defini o xtick como vazio
        ax.set_xticks([])
       
        # Ajustando os limites do eixo y para adicionar margem com base nos extremos
        # estes extremos ou são os outliers (se tiver) ou o "limite_superior" ou 
        # "limite_inferior", caso não existam outliers.
        if outliers:
            max_val = max(max(outliers), limite_superior)
            min_val = min(min(outliers), limite_inferior)
        else:
            max_val = limite_superior
            min_val = limite_inferior
        margem = 0.1 * (max_val - min_val)
        ax.set_ylim(min_val - margem, max_val + margem)





         
        '''# Determinar quais dados são outliers com base no fator especificado
        outliers = data[(data < lower_bound) | (data > upper_bound)]

        # Criar uma figura e um eixo para o gráfico de boxplot
        fig, ax = plt.subplots(figsize=(8, 6))

        # Criar o gráfico de boxplot
        boxprops = dict(color='blue')
        whiskerprops = dict(color='black', linestyle='--')
        capprops = dict(color='black')
        medianprops = dict(color='red')
        flierprops = dict(markerfacecolor='r', marker='o', markersize=5)

        ax.boxplot(data, boxprops=boxprops, whiskerprops=whiskerprops, capprops=capprops, medianprops=medianprops, flierprops=flierprops)

        # Adicionar os limites para os outliers
        ax.plot([1, 1], [lower_bound, upper_bound], color='green', linestyle='--')

        # Adicionar os outliers com base no fator especificado
        ax.plot(np.ones_like(outliers), outliers, 'ro') #
        
        boxplot = ax.boxplot(dados_lista, vert=True, patch_artist=False, whis=0, showfliers=False)'''
        
        
        
        
        #Plotando o gráfico boxplot
        #ax.boxplot(dados_lista)
            
        #Inserindo o título do gráfico
        #ax.set_title('Gráfico de detecção de outliers pelo diagrama Boxplot')
        
        # Nome do eixo x
        #ax.set_xlabel('Eixo X')
        
        # Nome do eixo y
        #ax.set_ylabel('Valores')
        
        if (op ==1): #Exibir a janela do gráfico
            
            if (op_exib == '2D'): #2D
                
                if self.graphs_open['boxplot_2D']:
                    return
                    
                #Mudando a variável de visibilidade do gráfico
                self.graphs_open['boxplot_2D'] = True
                
                # Título da janela do gráfico 
                fig_manager = plt.get_current_fig_manager()
                fig_manager.set_window_title('Gráfico do Boxplot')
                
                #Título da janela do gráfico
                #fig.canvas.set_window_title('Gráfico do Boxplot')
                
                #Definindo o ícone do GeoPEC na janela do gráfico
                plt.get_current_fig_manager().window.setWindowIcon(QtGui.QIcon(self.plugin_dir + "/icon/geopec.png"))
                       
                #Conectando o evento de fechamento da janela do gráfico a função onclose, que controla 
                #A variável booleana de fechado e aberto para o gráfico. Ao fechar o gráfico, a variável
                #se torna false, logo o gráfico poderá ser aberto novamente.
                def on_close(event):
                    self.graphs_open['boxplot_2D'] = False
                fig.canvas.mpl_connect('close_event', on_close)
                
                #Exibindo a janela do gráfico
                plt.show()
            
            else : #Z 
                
                if self.graphs_open['boxplot_Z']:
                    return
                    
                #Mudando a variável de visibilidade do gráfico
                self.graphs_open['boxplot_Z'] = True
                
                #Título da janela do gráfico
                fig.canvas.set_window_title('Gráfico do Boxplot')
                
                #Definindo o ícone do GeoPEC na janela do gráfico
                plt.get_current_fig_manager().window.setWindowIcon(QtGui.QIcon(self.plugin_dir + "/icon/geopec.png"))
                       
                #Conectando o evento de fechamento da janela do gráfico a função onclose, que controla 
                #A variável booleana de fechado e aberto para o gráfico. Ao fechar o gráfico, a variável
                #se torna false, logo o gráfico poderá ser aberto novamente.
                def on_close(event):
                    self.graphs_open['boxplot_Z'] = False
                fig.canvas.mpl_connect('close_event', on_close)
                
                #Exibindo a janela do gráfico
                plt.show()
        
        else: #Salvar a imagem
        
            # Definir o tamanho da figura em polegadas (largura x altura)
            fig.set_size_inches(15, 8.5)
            
            #Obtendo um objeto de mémoria para salvar a imagem
            image_stream = io.BytesIO()
            #Salvando a imagem no objeto de memória
            plt.savefig(image_stream, format='png', bbox_inches='tight')
            image_stream.seek(0)  # Go to the beginning of the BytesIO object
            
            #Fechando a janela do gráfico 
            plt.close()
            
            # Adicionando o objeto à lista de rastreamento
            self.bytes_io_objects.append(image_stream)
            
            #Retornando a imagem para ser inserida no relatório
            return image_stream
      
    def FG_exibir_gv_boxplot(self, objeto, dados): 
        """Este método cria o gráfico de boxplot e insere no graphicView correspondente"""
             
        #Obtendo os dados para gerar os gráficos
        dados_lista, dados_pts = dados

        dados_listat = {}
        i = 0
        for pt in dados_pts:
            
            dados_listat[pt] = dados_lista[i]
            i = i+1
        
        
        # Calcular os quartis e o IQR
        Q1 = fCalcQ1(dados_listat)
        Q3 = fCalcQ3(dados_listat)
        IQR = Q3 - Q1
        
        fator_interquartil= float(self.fator_boxplot)
        
        # Cálculo dos limites superior e inferior usando o fator interquartil
        # Conforme aula teórica CQC - Afonso
        limite_inferior = Q1 - fator_interquartil * IQR
        limite_superior = Q3 + fator_interquartil * IQR
        
        data = np.array(dados_lista)
        
        # Identificando os outliers
        outliers = [point for point in data if point < limite_inferior or point > limite_superior]
         
        
        # Criar uma figura e um eixo para o gráfico de boxplot, com tamanho padrao de 10 e 6
        fig, ax = plt.subplots(figsize=(3.5, 2.7))
        # Criar o gráfico de BOXPLOT, com os dados inseridos
        # whis=0 corresponde aos bigodes antigos estarem desativados, ou seja, permanece
        # só as linhas "T" nos intervalos entre os quartis e lim sup e inf. 
        # whis=0 faz o bigode original do boxplot sumir (útil pois estamos definindo
        #  outro limite superior e outro limite inferior)
        # showfliers=False faz com que os pontos que NAO sao outliers nao apareçam entre
        #  1º quartil e o limite inferior e o 3º quartil e o limite superior.
        # e patch_artist=False faz com que nao haja preenchimento do retangulo do boxplot
        
        # Cálculo da mediana  de acordo com os valores de entrada
        median = np.median(list(dados_listat.values()))  
                
        
        # Desenhar o retângulo que representa a caixa com o Q1 e Q3 
        rect = Rectangle((.95, Q1), 0.1, Q3 - Q1, fill=False, color='black')
        ax.add_patch(rect)

        # Adicionar a linha laranja para a mediana
        ax.hlines(median, 0.95, 1.05, color='orange', linestyle='-', linewidth=2)
        
        # Centraliza as componentes do boxplot dentro do quadrado de exibição do gráfico 
        # colcoando espaçamento em branco tanto para a esquerda quanto a direita.
        ax.set_xlim(0.8, 1.2)
        
        
        # Adicionando linhas horizontais referentes aos limites inferior e superior
        ax.hlines(limite_inferior, 0.95, 1.05, color='black', linestyle='-', linewidth=1)  
        ax.hlines(limite_superior, 0.95, 1.05, color='black', linestyle='-', linewidth=1)  
        
        
        # Adicionando linhas verticais que liga os quartis 1 e 3 aos limites inf e sup, respectivamente
        ax.plot([1, 1], [Q1, limite_inferior], 'k-', linewidth=1)  # linha do quartil 1 até o limite inferior
        ax.plot([1, 1], [Q3, limite_superior], 'k-', linewidth=1)  # linha do quartil 3 até o limite superior
        
        ##Plotando outliers identificados
        ax.scatter([1] * len(outliers), outliers, color='black', zorder=5)
            
        ##inserindo titulo do grafico 
        #ax.set_title('Boxplot')
        
        #ax.set_title('Gráfico de detecção de outliers pelo diagrama Boxplot')
        # Nome do eixo y
        #ax.set_ylabel('Valores')
        # Removendo o rótulo "1" acima do eixo x - na vdd é rotulo padrao
        # para o 1o grupo de dados, defini o xtick como vazio
        ax.set_xticks([])
       
        # Ajustando os limites do eixo y para adicionar margem com base nos extremos
        # estes extremos ou são os outliers (se tiver) ou o "limite_superior" ou 
        # "limite_inferior", caso não existam outliers.
        if outliers:
            max_val = max(max(outliers), limite_superior)
            min_val = min(min(outliers), limite_inferior)
        else:
            max_val = limite_superior
            min_val = limite_inferior
        margem = 0.1 * (max_val - min_val)
        ax.set_ylim(min_val - margem, max_val + margem)
        
            
        #-----------------------------------------------
        
        ## Ajustando gráf dentro da graphicView
        fig.tight_layout(pad=1 )
        
        ##fechou o grafico maximizavel que se abria automaticamente
        plt.close(fig)  
        
        # Limpar o layout atual do objeto antes de configurar o novo gráfico
        if objeto.layout() is not None:
            
            # Obtenha o layout atual do objeto e remova-o
            objeto.layout().deleteLater()
            QApplication.processEvents()
            # Agende a chamada do método FG_exibir_gv_boxplot após um pequeno atraso
            QTimer.singleShot(1, lambda: self.FG_exibir_gv_boxplot(objeto, dados))
        
        
        #fazendo o boxplot aparecer no GV
        canvas = FigureCanvas(fig)
        layout = QVBoxLayout()
        #configurando as margens
        layout.setContentsMargins(0, 15, 0, 0)
        layout.addWidget(canvas) 
        objeto.setLayout(layout)
        
    def FG_get_limite_3sigma(self, op_exib):
        """Este método obtém o valor do limite para a linha do teste 3sigma"""
        
        #Criando a linha de limite do 3 sigma
        classe = self.classe_3sigma
        fator = self.fator_3sigma
        
        fator = float(fator)    
        
        if op_exib == '2D' : #2D
                       
            escala = self.escala_2D_relatorio
            escala = float(escala)
            
            if classe ==0:
        
                limite_superior = fator * ((0.170/1000) * escala)
        
            elif classe ==1:
            
                limite_superior = fator * ((0.3/1000) * escala)
        
            elif classe == 3:
            
                limite_superior = fator * ((0.5/1000) * escala)
        
            else:
            
                limite_superior = fator * ((0.6/1000) * escala)
        
        else: #Z
            
            escala = self.escala_Z_relatorio
            escala = float(escala)
            
            if classe ==0:
        
                limite_superior = fator * ((1/6) * escala)
        
            elif classe ==1:
            
                limite_superior = fator * ((1/3) * escala)
        
            elif classe == 3:
            
                limite_superior = fator * ((2/5) * escala)
        
            else:
            
                limite_superior = fator * ((1/2) * escala)
        
        #Retornando o limite do teste 3sigma
        return limite_superior
        
    def  FG_exibir_janela_3sigma(self, dados, op, op_exib):
        """Este método cria o gráfico do método 3sigma para ser aberto em uma janela do programa ou para ser inserido no relatório"""
        
        if (op ==1):
        #Verificando se a janela do gráfico está aberta        
            if self.graphs_open['3sigma_2D'] and self.graphs_open['3sigma_Z'] :
                return
        
        #Obtendo os dados para gerar o gráfico
        dados_lista, dados_pts = dados
      
        #nomes dos pontos
        dados_x = dados_pts
        
        #Discrepâncias 
        erros_resultantes = dados_lista                
        
        #Limite superior
        limite_superior = self.FG_get_limite_3sigma(op_exib)
        
        # Criando uma figura de 8x6 polegadas
        fig, ax = plt.subplots(figsize=(11, 5)) 
        
        #largura da barra do gráfico
        largura_barra = 0.4
        
        #contando o número de valores a ser inserido no graf
        x = np.arange(len(dados_x))  # Posições no eixo X
        
        if (op_exib) == '2D': #2D
        
            #Plotando as barras da discrepância 2D, com os dados e seus respectivos valores
            barra_z = plt.bar(x, erros_resultantes, largura_barra, label= '2D - Posicional (m)' , color='blue', edgecolor='black')
            # Adicionando opções da linha de  limite de 3 sigma, linha, cor, estilo e nome
            plt.axhline(y=limite_superior, color='r', linestyle='--', label=f'Limite de detecção\ndo teste 3σ')
            
        else:
            
            #Plotando as barras da discrepância Z, com os dados e seus respectivos valores
            barra_z = plt.bar(x, erros_resultantes, largura_barra, label= 'Z - Altitude (m)', color='blue', edgecolor='black')
            
            # Adicionando opções da linha de  limite de 3 sigma, linha, cor, estilo e nome
            plt.axhline(y=limite_superior, color='r', linestyle='--', label='Limite de detecção\ndo teste 3σ')
            # Adicionando opções da linha de  limite de 3 sigma, linha, cor, estilo e nome
            plt.axhline(y=(-limite_superior), color='r', linestyle='--')
            
        # Adicionando traços horizontais para quando valor=0
        for i in range(len(dados_x)):
            if erros_resultantes[i] == 0:
                ax.hlines(0, x[i] - largura_barra/2, x[i] + largura_barra/2, color=barra_z[0].get_facecolor())
        
        # Adicionando opções da linha de  limite de 3 sigma, linha, cor, estilo e nome
        #plt.axhline(y=limite_superior, color='r', linestyle='--', label='Limite de detecção do teste 3σ')
        
        #Definindo os labels do gráfico
        plt.xlabel('Pontos de checagem (Nome)')
        plt.ylabel('Discrepâncias (m)')
        
        #título do gráfico
        plt.title('Gráfico de detecção de outliers pelo teste 3σ')
        
        # Plotando os ticks com numero de dados e os dados, respectivamente
        
        ## plotando os ticks com numero de dados e os dados, respectivamente
        # Ajustar os ticks do eixo x para evitar sobreposição
        # se o numero de dados for maior que 16, ele só mostra 16 dos dados
        # sendo assim, os outros ficam omitidos no eixo horizontal
        # se for menor ou igual a 166, ele exibe todos os pts
        if len(dados_x) > 16:  
            step = len(dados_x) // 16  
            ax.set_xticks(x[::step])
            ax.set_xticklabels(dados_x[::step])
        else:
            ax.set_xticks(x)
            ax.set_xticklabels(dados_x)
        
        #plt.xticks(x, dados_x ) 
        
        #Definindo o tamanho da legenda do gráfico
        # loc e bbox_to_anchor servem para alterar a posição da legenda
        ax.legend(fontsize=12, loc='upper left', bbox_to_anchor=(1, 1))
        # a legenda, quando inserida fora do gráfico, estava sendo cortada
        # e o gráfico com legenda nao estava centralizado. Sendo assim,
        # a linha abaixo faz esse acerto 
        plt.subplots_adjust(right=0.75)
        
        
        
        #plt.legend(fontsize=13)  
        
        if (op==1): #Exibir janela do gráfico
        
            if (op_exib) == '2D': #2D
                
                if self.graphs_open['3sigma_2D']:
                    return
                
                self.graphs_open['3sigma_2D'] = True 
                
                # Título da janela do gráfico 
                fig_manager = plt.get_current_fig_manager()
                fig_manager.set_window_title('Gráfico do teste 3σ')
                
                #Título da janela do gráfico
                #fig.canvas.set_window_title('Gráfico do teste 3σ')
                
                #Definindo o ícone do GeoPEC na janela do gráfico
                plt.get_current_fig_manager().window.setWindowIcon(QtGui.QIcon(self.plugin_dir + "/icon/geopec.png"))
                     
                #Conectando o evento de fechamento da janela do gráfico a função onclose, que controla 
                #A variável booleana de fechado e aberto para o gráfico. Ao fechar o gráfico, a variável
                #se torna false, logo o gráfico poderá ser aberto novamente.
                def on_close(event):
                    self.graphs_open['3sigma_2D'] = False
                fig.canvas.mpl_connect('close_event', on_close)
                
                #Exibindo a janela do gráfico
                plt.show() 
            
            else: #Z
                
                if self.graphs_open['3sigma_Z']:
                    return
                
                self.graphs_open['3sigma_Z'] = True 
                
                #Título da janela do gráfico
                fig.canvas.set_window_title('Gráfico do teste 3σ')
                
                #Definindo o ícone do GeoPEC na janela do gráfico
                plt.get_current_fig_manager().window.setWindowIcon(QtGui.QIcon(self.plugin_dir + "/icon/geopec.png"))
                     
                #Conectando o evento de fechamento da janela do gráfico a função onclose, que controla 
                #A variável booleana de fechado e aberto para o gráfico. Ao fechar o gráfico, a variável
                #se torna false, logo o gráfico poderá ser aberto novamente.
                def on_close(event):
                    self.graphs_open['3sigma_Z'] = False
                fig.canvas.mpl_connect('close_event', on_close)
                           
                #Exibindo a janela do gráfico
                plt.show() 
        
        else: #Salvar imagem
            
            # Definir o tamanho da figura em polegadas (largura x altura)
            fig.set_size_inches(15, 8.5)
            
            #Obtendo um objeto de mémoria para salvar a imagem
            image_stream = io.BytesIO()
            #Salvando a imagem no objeto de memória
            plt.savefig(image_stream, format='png', bbox_inches='tight')
            image_stream.seek(0)  # Go to the beginning of the BytesIO object
            
            #Fechando a janela do gráfico 
            plt.close()
            
            # Adicionando o objeto à lista de rastreamento
            self.bytes_io_objects.append(image_stream)
            
            #Retornando a imagem para ser inserida no relatório
            return image_stream
               
    def FG_exibir_gv_3sigma(self,objeto, dados, op_exib):
        """Este método cria o gráfico do método 3sigma e insere no graphicView correspondente"""
        
        #Obtendo os dados para gerar o gráfico
        d2D_lista, d2D_pts = dados

        # nomes dos pontos, poderia ser pt1, pt2, pt2, etc
        dados_x = d2D_pts
        
        # valor referente a cada dado, e pelos videos do af, os dados estão todos positivos
        erros_resultantes = d2D_lista
        
        #Limite superior
        limite_superior = self.FG_get_limite_3sigma(op_exib)
        
        # Configurações para o gráfico
        fig, ax = plt.subplots(figsize=(3., 2.4))   ## muda tamanho da janela maximizavel
        
        #largura de cada barra
        largura_barra = 0.4
        
        #contando a quantidade de dados, para poder "parear" o nome do pt ao valor deste ponto
        x = np.arange(len(dados_x)) 
        
        
        if (op_exib) == '2D': #2D
        
            #Plotando as barras da discrepância 2D, com os dados e seus respectivos valores
            barra_z = plt.bar(x, erros_resultantes, largura_barra, label= '2D - Posicional (m)' , color='blue')
            # Adicionando opções da linha de  limite de 3 sigma, linha, cor, estilo e nome
            plt.axhline(y=limite_superior, color='r', linestyle='--', label=f'Limite de detecção\ndo teste 3σ')
            
        else: #Z
            
            #Plotando as barras da discrepância Z, com os dados e seus respectivos valores
            barra_z = plt.bar(x, erros_resultantes, largura_barra, label= 'Z - Altitude (m)', color='blue')
            
            # Adicionando opções da linha de  limite de 3 sigma, linha, cor, estilo e nome
            plt.axhline(y=limite_superior, color='r', linestyle='--', label='Limite de detecção\ndo teste 3σ')
            # Adicionando opções da linha de  limite de 3 sigma, linha, cor, estilo e nome
            plt.axhline(y=(-limite_superior), color='r', linestyle='--')
            
        # Adicionando traços horizontais para quando valor=0
        for i in range(len(dados_x)):
            if erros_resultantes[i] == 0:
                ax.hlines(0, x[i] - largura_barra/2, x[i] + largura_barra/2, color=barra_z[0].get_facecolor())
        
        
        
        
        
        '''# Plotando as barras de erro resultantes
        #ax.bar(x, erros_resultantes, largura_barra, label='2D - Posicional (m)')
        
        # Adicionando opções da linha de  limite de 3 sigmas, linha, cor, estilo e nome
        #ax.axhline(y=limite_superior, color='r', linestyle='--', label='Limite de detecção do teste 3σ')'''
      
        # Configurações do gráfico
        # label em x
        ax.set_xlabel('Pontos de checagem (Nome)', labelpad=-1)
        
        # label em y
        ax.set_ylabel('Discrepâncias (m)', labelpad=-1)
        
        '''# titulo do grafico
        #plt.title('Gráfico 3 sigma')
        
        # Dando nome aos pontos e fazendo aparecer eles no GraphicView
        #ax.set_xticks(x)
        #ax.set_xticklabels(dados_x)'''
        
        
        ## plotando os ticks com numero de dados e os dados, respectivamente
        # Ajustar os ticks do eixo x para evitar sobreposição
        # se o numero de dados for maior que 5, ele só mostra 5 dos dados
        # sendo assim, os outros ficam omitidos no eixo horizontal
        # se for menor ou igual a 5, ele exibe todos os pts
        if len(dados_x) > 5:  
            step = len(dados_x) // 5  
            ax.set_xticks(x[::step])
            ax.set_xticklabels(dados_x[::step])
        else:
            ax.set_xticks(x)
            ax.set_xticklabels(dados_x)
        
        
        
        # Tamanho para legenda no GraphicView (menor que na tela maximizável)
        ax.legend(fontsize=7.)
        
        ## Ajustando gráf dentro da graphicView
        fig.tight_layout(pad=1.1 )   
        
        #mostrando graf
        #plt.show() 
        ##fecha o grafico maximizavel que se abria automaticamente
        plt.close(fig)
        
        # Limpar o layout atual do objeto antes de configurar o novo gráfico
        if objeto.layout() is not None:
            
            # Obtenha o layout atual do objeto e remova-o
            objeto.layout().deleteLater()
            QApplication.processEvents()
            # Agende a chamada do método FG_exibir_gv_3sigma após um pequeno atraso
            QTimer.singleShot(1, lambda: self.FG_exibir_gv_3sigma(objeto, dados, op_exib))
                        
        #fazendo o graf de 3 sigma aparecer no GV
        canvas = FigureCanvas(fig)  
        layout = QVBoxLayout()
        
        #ajustando margem
        layout.setContentsMargins(0, 15, 0, 0) 
        layout.addWidget(canvas)   
        objeto.setLayout(layout)  
        
    def tabs_graficos(self):
        """Este método deixa as abas dos gráficos visiveis ou invisisiveis a depender da opção de processamento"""
        
        #Obtendo a opçao de processamento
        op = self.op_norma
        
        #Habilitando ou desabilitando as abas conforme a opção de processamento
        
        if (op==0) or (op==3) or (op==6) or (op==7): #2D
            
            self.dlg.tabWidget_9.setTabEnabled(0, True)
            self.dlg.tabWidget_9.setTabEnabled(1, True)
            self.dlg.tabWidget_9.setTabEnabled(3, True)
            
            self.dlg.tabWidget_9.setTabEnabled(2, False)
            self.dlg.tabWidget_9.setTabEnabled(4, False)
            #self.dlg.tabWidget_9.setTabEnabled(5, False)
                      
            self.dlg.tabWidget_10.setTabEnabled(0, True)
            self.dlg.tabWidget_10.setTabEnabled(1, False)
            
            self.dlg.tabWidget_9.setCurrentIndex(0)
            self.dlg.tabWidget_10.setCurrentIndex(0)
            
        elif (op==1) or (op==4) or (op==8): #Z
            
            self.dlg.tabWidget_9.setTabEnabled(0, False)
            self.dlg.tabWidget_9.setTabEnabled(1, False)
            self.dlg.tabWidget_9.setTabEnabled(3, False)
            
            self.dlg.tabWidget_9.setTabEnabled(2, True)
            self.dlg.tabWidget_9.setTabEnabled(4, True)
            #self.dlg.tabWidget_9.setTabEnabled(5, True)
            
            self.dlg.tabWidget_10.setTabEnabled(0, False)
            self.dlg.tabWidget_10.setTabEnabled(1, True)
            
            self.dlg.tabWidget_9.setCurrentIndex(2)
            self.dlg.tabWidget_10.setCurrentIndex(1)
            
        else: #2D e Z
            
            self.dlg.tabWidget_9.setTabEnabled(0, True)
            self.dlg.tabWidget_9.setTabEnabled(1, True)
            self.dlg.tabWidget_9.setTabEnabled(3, True)
            
            self.dlg.tabWidget_9.setTabEnabled(2, True)
            self.dlg.tabWidget_9.setTabEnabled(4, True)
            #self.dlg.tabWidget_9.setTabEnabled(5, True)
            
            self.dlg.tabWidget_10.setTabEnabled(0, True)
            self.dlg.tabWidget_10.setTabEnabled(1, True)
            
            self.dlg.tabWidget_9.setCurrentIndex(0)
            self.dlg.tabWidget_10.setCurrentIndex(0)
    
    def FG_exibir_gv_outliers(self, objeto, dados, op_exib):
        """Este método chama o método de atualizar o graphicView dos outliers com base na opção de processamento"""
        
        #Obtendo a opção de outliers, 3sigma ou boxplot
        opcao = self.dlg.comboBox_6.currentIndex() 
        
        if opcao == 0: #teste 3 sigma
            
            self.FG_exibir_gv_3sigma(objeto, dados, op_exib)
            
        else: #boxplot   
            
            self.FG_exibir_gv_boxplot(objeto, dados)
               
    def FG_exibir_janela_outliers(self, objeto, dados, op, op_exib):
        """Este método configura qual gráfico de outlier será aberto nas janelas, com base na opção do usuário"""
        
        #Obtendo a opção de processamento
        opcao = self.dlg.comboBox_6.currentIndex() 
        
        #Desconectando as conexões anteriores dos pushButtons
        self.desconectar_todas_as_conexoes(objeto)
        
        #Realizando a conexão dos botões
        
        if opcao == 0: #teste 3 sigma
            
            objeto.clicked.connect(lambda: self.FG_exibir_janela_3sigma(dados,op, op_exib)) #passar dados  e a opçao de abrir a janela
            
        else: #boxplot   
            
            objeto.clicked.connect(lambda: self.FG_exibir_janela_boxplot(dados,op, op_exib))
    
    def FG_get_dados_outliers(self):
        """Este método obtém os dados dos outliers para gerar os gráficos de outliers"""
        
        #Obtendo a opção de processamento
        op = self.op_norma
        
        #Obtendo os dados de discrepancias
        dx, dy, dz, d2D, d3D, data = self.dados_relatorio
        dx, dy, dz = fDiscrepancia(data)       
        
        #Construindo a estrutura com os dados para gerar o gráfico 
        
        if  (op==0) or (op==3) or (op==6) or (op==7): #2D
            
            d2D = fDiscrepancia2D(dx, dy)
            
            d2D_lista = [d2D[pt] for pt in itera(d2D)]
            d2D_pts = [pt for pt in itera(d2D)]
            
            dados = [d2D_lista, d2D_pts]
            
            return dados
            
        elif (op==1) or (op==4) or (op==8): #Z
            
            dZ_lista = [dz[pt] for pt in itera(dz)]
            dZ_pts = [pt for pt in itera(dz)]
            
            dados = [dZ_lista, dZ_pts]
            
            return dados
        
        else: #2D e Z
        
            d2D = fDiscrepancia2D(dx, dy)         
            d2D_lista = [d2D[pt] for pt in itera(d2D)]
            d2D_pts = [pt for pt in itera(d2D)]
            dados_2D = [d2D_lista, d2D_pts]
            
            dZ_lista = [dz[pt] for pt in itera(dz)]
            dZ_pts = [pt for pt in itera(dz)]           
            dados_Z = [dZ_lista, dZ_pts]
            
            return [dados_2D, dados_Z]

    def desconectar_todas_as_conexoes(self,botao):
        """Este método desconecta todas as conexões do pushButton passado para o método"""
        
        #Tentando desconectar as conexões
        try:
            botao.clicked.disconnect()
            
        except TypeError:
            pass  # Nenhuma conexão existente para desconectar 
            
    def atualiza_interface_graficos(self):
        """Este método realiza a atualização da interface dos graphicViews e das conexões dos pussbuttons, é a função principal dos gráficos"""
        
        #Obtendo a opção de processamento
        op = self.op_norma
        
        #Configurando as janelas dos gráficos que ficaram habilitadas e dasabilitadas
        self.tabs_graficos()
        
        #Atualizando a interface dos gráficos
        
        if (op==0) or (op==3) or (op==6) or (op==7): #2D
            
            #Atulizando os graphics views na janela do GeoPEC        
            self.FG_exibir_gv_dispersao_2D()
            self.FG_exibir_gv_discrepancias_2D()
            
            #Outliers            
            dados = self.FG_get_dados_outliers()
            
            self.FG_exibir_gv_outliers(self.dlg.graphicsView_4, dados, '2D')
            self.FG_exibir_gv_outliers(self.dlg.graphicsView_12, dados, '2D')
            
            #Conectando os pussbuttons aos métodos de exibir as janelas dos gráficos 
            
            self.dlg.pushButton_2.clicked.connect(lambda: self.FG_exibir_janela_dispersao_2D(1))
            self.dlg.pushButton_4.clicked.connect(lambda: self.FG_exibir_janela_discrepancias_2D(1))
            
            #Desconectando conexões anteriores do botão
            self.desconectar_todas_as_conexoes(self.dlg.pushButton_5)
            self.dlg.pushButton_5.clicked.connect(lambda: self.FG_exibir_janela_discrepancias_2D(1))
            
            #Outliers
            self.FG_exibir_janela_outliers(self.dlg.pushButton_7, dados, 1, '2D')
            self.FG_exibir_janela_outliers(self.dlg.pushButton_14, dados, 1, '2D')
            
        elif (op==1) or (op==4) or (op==8): #z
            
            #Atulizando os graphics views na janela do GeoPEC           
            #self.FG_exibir_gv_dispersao_Z()
            self.FG_exibir_gv_discrepancias_Z()
            
            #Outliers            
            dados = self.FG_get_dados_outliers()
            
            self.FG_exibir_gv_outliers(self.dlg.graphicsView_5, dados, 'Z')
            self.FG_exibir_gv_outliers(self.dlg.graphicsView_13, dados, 'Z')
            
            #Conectando os pussbuttons aos métodos de exibir as janelas dos gráficos
            
            #self.dlg.pushButton_3.clicked.connect(lambda: self.FG_exibir_janela_dispersao_Z(1))
            self.dlg.pushButton_9.clicked.connect(lambda: self.FG_exibir_janela_discrepancias_Z(1))
            #Desconectando conexões anteriores do botão
            self.desconectar_todas_as_conexoes(self.dlg.pushButton_5)
            self.dlg.pushButton_5.clicked.connect(lambda: self.FG_exibir_janela_discrepancias_Z(1))
            
            #Outliers
            self.FG_exibir_janela_outliers(self.dlg.pushButton_8, dados, 1, 'Z')
            self.FG_exibir_janela_outliers(self.dlg.pushButton_15, dados, 1, 'Z')
            
            
        else: #2D e Z
            
            #Atulizando os graphics views na janela do GeoPEC
            
            #2D
            self.FG_exibir_gv_dispersao_2D()
            self.FG_exibir_gv_discrepancias_2D()
            #Z
            #self.FG_exibir_gv_dispersao_Z()
            self.FG_exibir_gv_discrepancias_Z()
            
            #Outliers            
            dados_2D, dados_Z = self.FG_get_dados_outliers()
            
            #2D
            self.FG_exibir_gv_outliers(self.dlg.graphicsView_4, dados_2D, '2D')
            self.FG_exibir_gv_outliers(self.dlg.graphicsView_12, dados_2D, '2D')
            #Z
            self.FG_exibir_gv_outliers(self.dlg.graphicsView_5, dados_Z, 'Z')
            self.FG_exibir_gv_outliers(self.dlg.graphicsView_13, dados_Z, 'Z')
            
            #Conectando os pussbuttons aos métodos de exibir as janelas dos gráficos
            
            #2D
            self.dlg.pushButton_2.clicked.connect(lambda: self.FG_exibir_janela_dispersao_2D(1))
            self.dlg.pushButton_4.clicked.connect(lambda: self.FG_exibir_janela_discrepancias_2D(1))          
            
            #Outliers
            self.FG_exibir_janela_outliers(self.dlg.pushButton_7, dados_2D, 1, '2D')
            self.FG_exibir_janela_outliers(self.dlg.pushButton_14, dados_2D, 1, '2D')
            
            #Z
            #self.dlg.pushButton_3.clicked.connect(lambda: self.FG_exibir_janela_dispersao_Z(1))
            self.dlg.pushButton_9.clicked.connect(lambda: self.FG_exibir_janela_discrepancias_Z(1))
            
            #Desconectando conexões anteriores do botão
            self.desconectar_todas_as_conexoes(self.dlg.pushButton_5)            
            #Adicinando as conexões ao botão
            
            self.dlg.pushButton_5.clicked.connect(lambda: self.FG_exibir_janela_discrepancias_Z(1))
            self.dlg.pushButton_5.clicked.connect(lambda: self.FG_exibir_janela_discrepancias_2D(1))
            
            #Outliers
            self.FG_exibir_janela_outliers(self.dlg.pushButton_8, dados_Z, 1, 'Z')
            self.FG_exibir_janela_outliers(self.dlg.pushButton_15, dados_Z, 1, 'Z')
            
    def run(self):
        """Run method that performs all the real work"""
       
        #Testando luis
        if not self.connections_made:
        
            self.carregaVetor()
            #A parte de atualizar as layers
            #QgsProject.instance().layersAdded.connect(self.carregaVetor)
            #QgsProject.instance().layersWillBeRemoved.connect(self.remove_vetor)
            #########
            self.dlg.toolButton.clicked.connect(self.carregaCamada)
            self.dlg.toolButton_2.clicked.connect(self.carregaCamada)
            self.dlg.toolButton_3.clicked.connect(self.abrir_caminho_relatorio)
            self.dlg.pushButton.clicked.connect(self.processamento_PEC)
        ##########     
            self.configuracao_Interface()
            self.dlg.setWindowFlags(Qt.Window | Qt.WindowMinimizeButtonHint | Qt.WindowMaximizeButtonHint | Qt.WindowCloseButtonHint)
            self.iniciaInterface()        
        #testando a escrita de PDF
            self.dlg.pushButton_6.clicked.connect(self.generateRelatorio)
            
            #Testando luis
            self.connections_made = True
            
        self.dlg.show()
        
        # Run the dialog event loop
        #result = self.dlg.exec_()
        # See if OK was pressed
        #if result:
        
        '''self.carregaVetor()
        self.dlg.toolButton.clicked.connect(self.carregaCamada)
        self.dlg.toolButton_2.clicked.connect(self.carregaCamada)    
        self.dlg.pushButton.clicked.connect(self.processamento_PEC)'''
    # pass
	