# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GeoPEC
                A QGIS plugin [Generated by Plugin Builder]


autores: Afonso P. Santos; João Vítor A. Gonçalves; Luis Philippe Ventura

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction, QFileDialog
from qgis.core import *
from osgeo import gdal
# Initialize Qt resources from file resources.py
from ..resources import *
import processing
# Import the code for the dialog
from ..gui.sobre_dialog import sobreDialog
import os.path
import math
import os
import platform
import subprocess

class sobre:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
    #################################
            
        # Pega o caminho do diretório onde o arquivo atual está localizado
        current_dir = os.path.dirname(os.path.abspath(__file__))
        # Sobe um nível na hierarquia de diretórios para chegar à pasta principal
        self.plugin_dir = os.path.dirname(current_dir)
        
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(self.plugin_dir,'i18n','pec_{}.qm'.format(locale))
        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)
    #################################
                
        # Save reference to the QGIS interface
        self.iface = iface
   
        self.dlg = sobreDialog()

        #Configurando métodos para não aparecer janelas de erro mais de uma vez
        self.first_start = True
        self.connections_made = False  
        
    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('tamanhoamostral', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        pass
        
    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        self.iface.mainWindow().menuBar().removeAction(self.menu.menuAction())
        del self.menu
        # remove the toolbar
        del self.toolbar

    
    def open_pdf(self):
        
        file_path = self.plugin_dir + "/docs/Termos_de_uso_plugin_geopec.pdf"
        
        try:
        
            if platform.system() == 'Windows':
                os.startfile(file_path)
            elif platform.system() == 'Darwin':  # macOS
                subprocess.call(('open', file_path))
            else:  # Linux
                subprocess.call(('xdg-open', file_path))
            
        except:
            
            self.show_messagebox_erro("erro", "Não foi possível abrir os termos de uso do programa!")
    
    def show_messagebox_erro(self, tipo, mensagem):
        """Método para exibir um messagebox informando erro ou sucesso em alguma ação do programa"""    
        
        
        
        if  (tipo == 'erro'): #Mensagem do tipo erro
        
            # Crie uma instância do QMessageBox
            msg_box = QMessageBox()

            # Defina o ícone da janela
            msg_box.setWindowIcon(QIcon(self.plugin_dir + "/icon/geopec.png"))  

            # Configure a mensagem de erro
            msg_box.setIcon(QMessageBox.Critical)
            msg_box.setWindowTitle('Erro')
            msg_box.setText(mensagem)

            # Exibindo a mensagem
            msg_box.exec_()
        
            
        else: # tipo igual sucesso
            
            # Criando uma instância do QMessageBox
            msg_box = QMessageBox()

            # Definindo o ícone da janela
            msg_box.setWindowIcon(QIcon(self.plugin_dir + "/icon/geopec.png"))  

            # Configurando a mensagem de sucesso
            msg_box.setIcon(QMessageBox.Information)
            msg_box.setWindowTitle('Sucesso')
            msg_box.setText(mensagem)

            # Exibindo a mensagem
            msg_box.exec_()
    
    
    def run(self):
        """Run method that performs all the real work"""
        
        if not self.connections_made:
            
            self.dlg.pushButton.clicked.connect(self.open_pdf)
            
            #Testando luis
            self.connections_made = True
            
        self.dlg.show()
        
        
        # show the dialog
        #self.dlg.show()
        
        # Run the dialog event loop
        #result = self.dlg.exec_()
        # See if OK was pressed
        #if result:
            

    # pass
	