# -*- coding: utf-8 -*-
"""
/***************************************************************************
 FloodPathFinder
                                 A QGIS plugin
 Este plugin é usado para identificar as infraestruturas viárias em pontos suscetívesa inundação
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-03-11
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Nogueira
        email                : catce.nogueira@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon, QStandardItemModel, QStandardItem, QTextCursor
from qgis.PyQt.QtWidgets import QAction, QFileDialog
from qgis.core import *
import datetime

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .flood_path_finder_dialog import FloodPathFinderDialog
import os.path
import processing
import subprocess
import sys, os
from osgeo import ogr

class FloodPathFinder: 

    def __init__(self, iface): 
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'FloodPathFinder_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Flood Path Finder')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('FloodPathFinder', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/flood_path_finder/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Flood Path Finder'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Flood Path Finder'),
                action)
            self.iface.removeToolBarIcon(action)
    
    def carregaVetor(self, comboBox):
        """Preenche o comboBox com as camadas vetoriais existentes no projeto"""
        comboBox.clear()
        lista_camadas = [layer for layer in QgsProject.instance().mapLayers().values()]
        lista_camadas_vetor = []
        for layer in lista_camadas:
            if layer.type() == QgsMapLayer.VectorLayer:
                lista_camadas_vetor.append(layer.name())
        comboBox.addItems(lista_camadas_vetor)

    
    def abrirVetor(self, comboBox):
        """Abre a janela de dialogo para abrir uma layer"""
        camada_abrir, _ = QFileDialog.getOpenFileName(caption="Escolha a camada", filter="Shapefiles (*.shp);;GeoJSON (*.geojson)")
        # Se camada_abrir não for vazia
        if camada_abrir:
            self.iface.addVectorLayer(camada_abrir, os.path.basename(camada_abrir), "ogr")
            self.carregaVetor(comboBox)

    def run(self): 
        if self.first_start == True:
            self.first_start = False
            self.dlg = FloodPathFinderDialog()

        self.dlg.checkBox.setChecked(True)
        self.dlg.checkBox_2.setChecked(True) 

        # show the dialog
        self.dlg.show()
        # add funções criadas
        self.dlg.comboBox.clear()
        self.dlg.comboBox_2.clear()

        self.carregaVetor(self.dlg.comboBox)
        self.carregaVetor(self.dlg.comboBox_2)

        self.dlg.comboBox.currentIndexChanged.connect(lambda: self.carregaColunas(self.dlg.comboBox, self.dlg.comboBox_3))
        self.dlg.comboBox_2.currentIndexChanged.connect(lambda: self.carregaColunasComboBox4(self.dlg.comboBox_2, self.dlg.comboBox_4))
        
        self.carregaColunas(self.dlg.comboBox, self.dlg.comboBox_3)
        self.carregaColunasComboBox4(self.dlg.comboBox_2, self.dlg.comboBox_4)

        self.dlg.comboBox.currentIndexChanged.connect(lambda: self.carregaColunas(self.dlg.comboBox, self.dlg.comboBox_3))

        self.dlg.comboBox_3.currentIndexChanged.connect(lambda: self.carregaValoresColuna(self.dlg.comboBox_3, self.dlg.listView))
        
        self.dlg.toolButton.clicked.connect(lambda: self.abrirVetor(self.dlg.comboBox))  # Conectar o primeiro toolButton
        self.dlg.toolButton_2.clicked.connect(lambda: self.abrirVetor(self.dlg.comboBox_2))  # Conectar o segundo toolButton
        self.dlg.toolButton_3.clicked.connect(lambda: self.definirCaminhoSaida(self.dlg.lineEdit))  # Conectar toolButton_3
        self.dlg.toolButton_4.clicked.connect(lambda: self.definirCaminhoSaida(self.dlg.lineEdit_2))  # Conectar toolButton_4

        # Connect the function to load columns to the change event of comboBox
        self.dlg.comboBox.currentIndexChanged.connect(lambda: self.carregaColunas(self.dlg.comboBox, self.dlg.comboBox_3))

        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Clear existing text
            self.dlg.plainTextEdit.clear() 
            try:
                current_datetime = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
                input_layer_hand = self.dlg.comboBox.currentText()
                input_layer_line = self.dlg.comboBox_2.currentText()
                data_layer_column_risk = self.dlg.comboBox_3.currentText() 
                data_layer_column_size = self.dlg.comboBox_4.currentText() 
                
                # Adicionar a mensagem de início do algoritmo
                self.dlg.plainTextEdit.appendPlainText(f"Algoritmo iniciado às: {current_datetime}")
                self.dlg.plainTextEdit.appendPlainText("Algoritmo 'Flood Path Finder' iniciando…")
                self.dlg.plainTextEdit.appendPlainText("Entrada de parâmetros:")
                self.dlg.plainTextEdit.appendPlainText(f"Camada de entrada 01: {input_layer_hand}")
                self.dlg.plainTextEdit.appendPlainText(f"Camada de entrada 02: {input_layer_line}")
                self.dlg.plainTextEdit.appendPlainText(f"Coluna de risco selecionada: {data_layer_column_risk}")  
                self.dlg.plainTextEdit.appendPlainText(f"Coluna de tamanho da via selecionada: {data_layer_column_size}")  
                self.dlg.plainTextEdit.appendPlainText("Algoritmo finalizado.") 
            except Exception as e:
                # Se ocorrer algum erro, registre a exceção
                self.dlg.plainTextEdit.appendPlainText(f"Error: {str(e)}")

            # Check if at least one item is checked in the listView
            listViewModel = self.dlg.listView.model()
            if listViewModel is None or listViewModel.rowCount() == 0 or all(listViewModel.item(row).checkState() != Qt.Checked for row in range(listViewModel.rowCount())):
                self.iface.messageBar().pushMessage("Error", "Selecione pelo menos um item no listView | Please select at least one item in the listView.", level=Qgis.Critical)
                return

            # Get the selected layer from the first combobox
            selected_polygon_layer_name = self.dlg.comboBox.currentText()
            # Filter the polygon layer to extract features where DN is equal to comboBox_3's current text
            selected_polygon_layer = QgsProject.instance().mapLayersByName(selected_polygon_layer_name)[0]
            selected_field_name = self.dlg.comboBox_3.currentText()
            
            # Lista para armazenar os valores selecionados no listView
            selected_values = []
            model = self.dlg.listView.model()
            for row in range(model.rowCount()):
                item = model.item(row)
                if item.checkState() == Qt.Checked:
                    selected_values.append(item.text())

            # Criar a expressão de filtro com base nos valores selecionados
            expression = QgsExpression('"{}" IN ({})'.format(selected_field_name, ','.join(selected_values)))
            request = QgsFeatureRequest(expression)
            polygon_features = [f for f in selected_polygon_layer.getFeatures(request)]

            # Create a memory layer for the filtered polygon features
            output_polygon_layer = QgsVectorLayer("Polygon?crs=" + selected_polygon_layer.crs().authid(), "Filtered_Polygons", "memory")
            output_polygon_layer.dataProvider().addAttributes(selected_polygon_layer.fields())
            output_polygon_layer.updateFields()
            output_polygon_layer.startEditing()
            for feature in polygon_features:
                output_polygon_layer.addFeature(feature)
            output_polygon_layer.commitChanges()

            selected_line_layer_name = self.dlg.comboBox_2.currentText()
            line_layer = QgsProject.instance().mapLayersByName(selected_line_layer_name)[0]

            # Filter the line layer based on the selected column and threshold
            selected_column_name = self.dlg.comboBox_4.currentText()
            threshold = 10  # Adjust the threshold as needed
            expression = QgsExpression(f'"{selected_column_name}" >= {threshold}')
            request = QgsFeatureRequest(expression)
            filtered_features = [f for f in line_layer.getFeatures(request)]

            # Create a memory layer for the filtered line features
            filtered_line_layer = QgsVectorLayer("LineString?crs=" + line_layer.crs().authid(), "Filtered_Lines", "memory")
            filtered_line_layer.dataProvider().addAttributes(line_layer.fields())
            filtered_line_layer.updateFields()
            filtered_line_layer.startEditing()
            for feature in filtered_features:
                filtered_line_layer.addFeature(feature)
            filtered_line_layer.commitChanges()

            # Perform spatial intersection between the filtered line layer and polygon layer
            intersection_result = processing.run("native:intersection", {
                'INPUT': filtered_line_layer,
                'OVERLAY': output_polygon_layer,
                'INPUT_FIELDS': [],
                'OVERLAY_FIELDS': [],
                'OUTPUT': 'memory:'
            })

            # Add the resulting layers to the map
            intersection_layer = intersection_result['OUTPUT']

            # Set the output paths
            if self.dlg.checkBox.isChecked():
                # If the checkbox for temporary files is checked
                output_polygon_path = None
                intersection_path = None
            else:
                # If the checkbox for temporary files is not checked
                output_polygon_path = self.dlg.lineEdit.text()
                intersection_path = self.dlg.lineEdit_2.text()

                # Save the layers to disk
                QgsVectorFileWriter.writeAsVectorFormat(output_polygon_layer, output_polygon_path, "utf-8", output_polygon_layer.crs(), driverName="ESRI Shapefile")
                QgsVectorFileWriter.writeAsVectorFormat(intersection_layer, intersection_path, "utf-8", intersection_layer.crs(), driverName="ESRI Shapefile")

            # Add the layers to the project
            if self.dlg.checkBox_2.isChecked():
                # If the checkbox for opening temporary layers is checked
                QgsProject.instance().addMapLayer(output_polygon_layer)
                QgsProject.instance().addMapLayer(intersection_layer)
            else:
                # If the checkbox for opening temporary layers is not checked
                if output_polygon_path:
                    output_polygon_layer = QgsVectorLayer(output_polygon_path, os.path.basename(output_polygon_path), "ogr")
                    QgsProject.instance().addMapLayer(output_polygon_layer)
                if intersection_path:
                    intersection_layer = QgsVectorLayer(intersection_path, os.path.basename(intersection_path), "ogr")
                    QgsProject.instance().addMapLayer(intersection_layer)
            
            self.dlg.tabWidget.setCurrentIndex(1) 
            self.dlg.show() # Fecha a tela do plugin e so abre quando o processo terminar




    def definirCaminhoSaida(self, lineEdit):
        """Define o caminho de saída para o arquivo"""
        path, _ = QFileDialog.getSaveFileName(caption="Escolha o caminho de saída", filter="Shapefile (*.shp)")
        if path:
            lineEdit.setText(path)

    def carregaColunas(self, comboBox, comboBox_3):
        """Preenche o comboBox_3 com as colunas da tabela de atributos da camada selecionada"""
        selected_layer_name = comboBox.currentText()
        selected_layer = QgsProject.instance().mapLayersByName(selected_layer_name)
        print("Selected Layer:", selected_layer)  # Check if the selected layer is correct
        if not selected_layer:
            return
        selected_layer = selected_layer[0]
        fields = selected_layer.fields()
        column_names = [field.name() for field in fields]
        print("Column Names:", column_names)  # Check if column names are correct
        comboBox_3.clear()
        comboBox_3.addItems(column_names)

    def carregaColunasComboBox4(self, comboBox_2, comboBox_4):
        """Preenche o comboBox_4 com as colunas da tabela de atributos da camada selecionada no comboBox_2"""
        selected_layer_name = comboBox_2.currentText()
        selected_layer = QgsProject.instance().mapLayersByName(selected_layer_name)
        if not selected_layer:
            return
        selected_layer = selected_layer[0]
        fields = selected_layer.fields()
        column_names = [field.name() for field in fields]
        comboBox_4.clear()
        comboBox_4.addItems(column_names)

    def carregaValoresColuna(self, comboBox_3, listView): 
        selected_layer_name = self.dlg.comboBox.currentText()
        selected_layer = QgsProject.instance().mapLayersByName(selected_layer_name)
        if not selected_layer:
            return
        selected_layer = selected_layer[0]
        selected_field_name = comboBox_3.currentText()
        field_index = selected_layer.fields().indexFromName(selected_field_name)
        
        # Coleta todos os valores únicos da coluna selecionada
        unique_values = set()
        for feature in selected_layer.getFeatures():
            unique_values.add(feature.attributes()[field_index]) 

        # Preenche o listView com os valores únicos
        model = QStandardItemModel()
        for value in unique_values:
            item = QStandardItem(str(value))
            item.setCheckable(True)
            model.appendRow(item)
        listView.setModel(model)
