"""橋梁モデル (./brid/)"""

from .base import (
    Attribute,
    AttributeGroup,
    FacilityAttributePaths,
    FeatureProcessingDefinition,
    GeometricAttribute,
    GeometricAttributes,
)

BRIDGE = FeatureProcessingDefinition(
    id="brid:Bridge",
    name="Bridge",
    target_elements=["brid:Bridge"],
    attribute_groups=[
        AttributeGroup(
            base_element=None,
            attributes=[
                Attribute(
                    name="class",
                    path="./brid:class",
                    datatype="string",
                    predefined_codelist="Bridge_class",
                ),
                Attribute(
                    name="function",
                    path="./brid:function",
                    datatype="[]string",
                    predefined_codelist="Bridge_function",
                ),
                Attribute(
                    name="yearOfConstruction",
                    path="./brid:yearOfConstruction",
                    datatype="integer",
                ),
                Attribute(
                    name="yearOfDemolition",
                    path="./brid:yearOfDemolition",
                    datatype="integer",
                ),
                Attribute(
                    name="isMovable",
                    path="./brid:isMovable",
                    datatype="boolean",
                ),
            ],
        ),
        AttributeGroup(
            base_element="./uro:bridBaseAttribute/uro:ConstructionBaseAttribute",
            attributes=[
                Attribute(
                    name="adminOffice",
                    path="./uro:adminOffice",
                    datatype="string",
                ),
                Attribute(
                    name="adminType",
                    path="./uro:adminType",
                    datatype="string",
                    predefined_codelist="ConstructionBaseAttribute_adminType",
                ),
                Attribute(
                    name="administorator",
                    path="./uro:administorator",
                    datatype="string",
                ),
                Attribute(
                    name="completionYear",
                    path="./uro:completionYear",
                    datatype="integer",
                ),
                Attribute(
                    name="constructionStartYear",
                    path="./uro:constructionStartYear",
                    datatype="integer",
                ),
                Attribute(
                    name="facilityAge",
                    path="./uro:facilityAge",
                    datatype="integer",
                ),
                Attribute(
                    name="installer",
                    path="./uro:installer",
                    datatype="string",
                ),
                Attribute(
                    name="installerType",
                    path="./uro:installerType",
                    datatype="string",
                    predefined_codelist="ConstructionBaseAttribute_installerType",
                ),
                Attribute(
                    name="kana",
                    path="./uro:kana",
                    datatype="string",
                ),
                Attribute(
                    name="operatorType",
                    path="./uro:operatorType",
                    datatype="string",
                    predefined_codelist=None,
                ),
                Attribute(
                    name="purpose",
                    path="./uro:purpose",
                    datatype="string",
                    predefined_codelist="ConstructionBaseAttribute_purpose",
                ),
                Attribute(
                    name="specification",
                    path="./uro:specification",
                    datatype="string",
                ),
                Attribute(
                    name="structureOrdinance",
                    path="./uro:structureOrdinance",
                    datatype="string",
                ),
                Attribute(
                    name="update",
                    path="./uro:update",
                    datatype="date",
                ),
            ],
        ),
        AttributeGroup(
            base_element="./uro:bridStructureAttribute/uro:BridgeStructureAttribute",
            attributes=[
                Attribute(
                    name="area",
                    path="./uro:area",
                    datatype="double",
                ),
                Attribute(
                    name="bridgeType",
                    path="./uro:bridgeType",
                    datatype="string",
                    predefined_codelist="BridgeStructureAttribute_bridgeType",
                ),
                Attribute(
                    name="escalator",
                    path="./uro:escalator",
                    datatype="boolean",
                ),
                Attribute(
                    name="heightRestriction",
                    path="./uro:heightRestriction",
                    datatype="double",
                ),
                Attribute(
                    name="length",
                    path="./uro:length",
                    datatype="double",
                ),
                Attribute(
                    name="material",
                    path="./uro:material",
                    datatype="string",
                    predefined_codelist="BridgeStructureAttribute_material",
                ),
                Attribute(
                    name="slopeType",
                    path="./uro:slopeType",
                    datatype="string",
                    predefined_codelist="ConstructionStructureAttribute_slopeType",
                ),
                Attribute(
                    name="underGirderHeight",
                    path="./uro:underGirderHeight",
                    datatype="double",
                ),
                Attribute(
                    name="weightRestriction",
                    path="./uro:weightRestriction",
                    datatype="double",
                ),
                Attribute(
                    name="width",
                    path="./uro:width",
                    datatype="double",
                ),
                Attribute(
                    name="widthRestriction",
                    path="./uro:widthRestriction",
                    datatype="double",
                ),
            ],
        ),
        AttributeGroup(
            base_element="./uro:bridFunctionalAttribute/uro:BridgeFunctionalAttribute",
            attributes=[
                Attribute(
                    name="directionType",
                    path="./uro:directionType",
                    datatype="string",
                    predefined_codelist="ConstructionFunctionalAttribute_directionType",
                ),
                Attribute(
                    name="userType",
                    path="./uro:userType",
                    datatype="string",
                    predefined_codelist="BridgeFunctionalAttribute_userType",
                ),
            ],
        ),
        AttributeGroup(
            base_element="./uro:bridRiskAssessmentAttribute/uro:ConstructionRiskAssessmentAttribute",
            attributes=[
                Attribute(
                    name="referenceDate",
                    path="./uro:referenceDate",
                    datatype="date",
                ),
                Attribute(
                    name="riskType",
                    path="./uro:riskType",
                    datatype="string",
                    predefined_codelist="ConstructionRiskAssessmentAttribute_riskType",
                ),
                Attribute(
                    name="status",
                    path="./uro:status",
                    datatype="string",
                    predefined_codelist="ConstructionRiskAssessmentAttribute_status",
                ),
                Attribute(
                    name="surveyYear",
                    path="./uro:surveyYear",
                    datatype="integer",
                ),
            ],
        ),
        AttributeGroup(
            base_element="./uro:bridDataQualityAttribute/uro:ConstructionDataQualityAttribute",
            attributes=[
                Attribute(
                    name="appearanceSrcDesc",
                    path="./uro:appearanceSrcDesc",
                    datatype="[]string",
                    predefined_codelist="DataQualityAttribute_appearanceSrcDesc",
                ),
                Attribute(
                    name="dataAcquisition",
                    path="./uro:dataAcquisition",
                    datatype="string",
                ),
                Attribute(
                    name="geometrySrcDesc",
                    path="./uro:geometrySrcDesc",
                    datatype="[]string",
                    predefined_codelist="DataQualityAttribute_geometrySrcDesc",
                ),
                Attribute(
                    name="lod1HeightType",
                    path="./uro:lod1HeightType",
                    datatype="string",
                    predefined_codelist="DataQualityAttribute_lod1HeightType",
                ),
                Attribute(
                    name="lodType",
                    path="./uro:lodType",
                    datatype="[]string",
                    predefined_codelist="Bridge_lodType",
                ),
                Attribute(
                    name="photoScale",
                    path="./uro:photoScale",
                    datatype="integer",
                ),
                Attribute(
                    name="srcScale",
                    path="./uro:srcScale",
                    datatype="string",
                    predefined_codelist="DataQualityAttribute_srcScale",
                ),
                Attribute(
                    name="thematicSrcDesc",
                    path="./uro:thematicSrcDesc",
                    datatype="[]string",
                    predefined_codelist="DataQualityAttribute_thematicSrcDesc",
                ),
            ],
        ),
    ],
    disaster_risk_attr_conatiner_path="./uro:bridDisasterRiskAttribute",
    dm_attr_container_path="./uro:bridDmAttribute",
    facility_attr_paths=FacilityAttributePaths(
        facility_id="./uro:bridFacilityIdAttribute",
        facility_types="./uro:bridFacilityTypeAttribute",
        facility_attrs="./uro:bridFacilityAttribute",
    ),
    geometries=GeometricAttributes(
        lod1=GeometricAttribute(
            lod_detection=["./brid:lod1Solid"],
            collect_all=["./brid:lod1Solid//gml:Polygon"],
        ),
        lod2=GeometricAttribute(
            lod_detection=["./brid:lod2Solid", "./brid:lod2MultiSurface"],
            collect_all=[
                ".//brid:lod2MultiSurface//gml:Polygon",
                ".//brid:lod2Geometry//gml:Polygon",
            ],
            only_direct=[
                "./brid:lod2MultiSurface//gml:Polygon",
                "./brid:lod2Solid//gml:Polygon",
            ],
        ),
        lod3=GeometricAttribute(
            lod_detection=["./brid:lod3Solid", "./brid:lod3MultiSurface"],
            collect_all=[
                ".//brid:lod3MultiSurface//gml:Polygon",
                ".//brid:lod3Geometry//gml:Polygon",
            ],
            only_direct=[
                "./brid:lod3MultiSurface//gml:Polygon",
                "./brid:lod3Solid//gml:Polygon",
            ],
        ),
        lod4=GeometricAttribute(
            lod_detection=["./brid:lod4Solid", "./brid:lod4MultiSurface"],
            collect_all=[
                ".//brid:lod4MultiSurface//gml:Polygon",
                ".//brid:lod4Geometry//gml:Polygon",
            ],
            only_direct=[
                "./brid:lod4MultiSurface//gml:Polygon",
                "./brid:lod4Solid//gml:Polygon",
            ],
        ),
        semantic_parts=[
            ".//brid:GroundSurface",
            ".//brid:WallSurface",
            ".//brid:RoofSurface",
            ".//brid:OuterCeilingSurface",
            ".//brid:OuterFloorSurface",
            ".//brid:ClosureSurface",
            ".//brid:CeilingSurface",
            ".//brid:InteriorWallSurface",
            ".//brid:FloorSurface",
            ".//brid:BridgeInstallation",
            ".//brid:IntBridgeInstallation",
            ".//brid:BridgeConstructionElement",
            ".//brid:BridgeFurniture",
        ],
    ),
)

BRIDGE_BOUNDARY_SURFACE = FeatureProcessingDefinition(
    id="brid:_BoundarySurface",
    name="BoundarySurface",
    target_elements=[
        "brid:GroundSurface",
        "brid:WallSurface",
        "brid:RoofSurface",
        "brid:OuterCeilingSurface",
        "brid:OuterFloorSurface",
        "brid:ClosureSurface",
        "brid:InteriorWallSurface",
        "brid:CeilingSurface",
        "brid:FloorSurface",
    ],
    attribute_groups=[],
    geometries=GeometricAttributes(
        lod2=GeometricAttribute(
            lod_detection=["./brid:lod2MultiSurface"],
            collect_all=[
                ".//brid:lod2MultiSurface//gml:Polygon",
                ".//brid:lod2Geometry//gml:Polygon",
            ],
        ),
        lod3=GeometricAttribute(
            lod_detection=["./brid:lod3MultiSurface"],
            collect_all=[
                ".//brid:lod3MultiSurface//gml:Polygon",
                ".//brid:lod3Geometry//gml:Polygon",
            ],
        ),
        lod4=GeometricAttribute(
            lod_detection=["./brid:lod4MultiSurface"],
            collect_all=[
                ".//brid:lod4MultiSurface//gml:Polygon",
                ".//brid:lod4Geometry//gml:Polygon",
            ],
        ),
        semantic_parts=[
            "./brid:opening/brid:Door",
            "./brid:opening/brid:Window",
        ],
    ),
)

BRIDGE_OPENING = FeatureProcessingDefinition(
    id="brid:_Opening",
    name="Opening",
    target_elements=[
        "brid:Window",
        "brid:Door",
    ],
    attribute_groups=[],
    geometries=GeometricAttributes(
        lod3=GeometricAttribute(
            lod_detection=["./brid:lod3MultiSurface"],
            collect_all=[".//brid:lod3MultiSurface//gml:Polygon"],
        ),
        lod4=GeometricAttribute(
            lod_detection=["./brid:lod4MultiSurface"],
            collect_all=[".//brid:lod4MultiSurface//gml:Polygon"],
        ),
    ),
)

BRIDGE_CONSTRUCTION_ELEMENT = FeatureProcessingDefinition(
    id="brid:BridgeConstructionElement",
    name="BridgeConstructionElement",
    target_elements=[
        "brid:BridgeConstructionElement",
    ],
    attribute_groups=[
        AttributeGroup(
            base_element=None,
            attributes=[
                Attribute(
                    name="function",
                    path="./brid:function",
                    datatype="[]string",
                    predefined_codelist="BridgeConstructionElement_function",
                ),
            ],
        )
    ],
    geometries=GeometricAttributes(
        lod2=GeometricAttribute(
            lod_detection=["./brid:lod2Geometry"],
            collect_all=[".//brid:lod2Geometry//gml:Polygon"],
        ),
        lod3=GeometricAttribute(
            lod_detection=["./brid:lod3Geometry"],
            collect_all=[".//brid:lod3Geometry//gml:Polygon"],
        ),
        lod4=GeometricAttribute(
            lod_detection=["./brid:lod4Geometry"],
            collect_all=[".//brid:lod4Geometry//gml:Polygon"],
        ),
    ),
)

BRIDGE_INSTALLATION = FeatureProcessingDefinition(
    id="brid:BridgeInstallation",
    name="BridgeInstallation",
    target_elements=["brid:BridgeInstallation"],
    attribute_groups=[
        AttributeGroup(
            base_element=None,
            attributes=[
                Attribute(
                    name="class",
                    path="./brid:class",
                    datatype="string",
                ),
                Attribute(
                    name="function",
                    path="./brid:function",
                    datatype="[]string",
                    predefined_codelist="BridgeInstallation_function",
                ),
                Attribute(
                    name="usage",
                    path="./brid:usage",
                    datatype="[]string",
                ),
            ],
        )
    ],
    geometries=GeometricAttributes(
        lod2=GeometricAttribute(
            lod_detection=["./brid:lod2Geometry"],
            collect_all=[".//brid:lod2Geometry//gml:Polygon"],
        ),
        lod3=GeometricAttribute(
            lod_detection=["./brid:lod3Geometry"],
            collect_all=[".//brid:lod3Geometry//gml:Polygon"],
        ),
        lod4=GeometricAttribute(
            lod_detection=["./brid:lod4Geometry"],
            collect_all=[".//brid:lod4Geometry//gml:Polygon"],
        ),
    ),
)


BRIDGE_INT_INSTALLATION = FeatureProcessingDefinition(
    id="IntBridgeInstallation",
    name="IntBridgeInstallation",
    target_elements=["brid:IntBridgeInstallation"],
    attribute_groups=[
        AttributeGroup(
            base_element=None,
            attributes=[
                Attribute(
                    name="class",
                    path="./brid:class",
                    datatype="string",
                    predefined_codelist="IntBuildingInstallation_class",
                ),
                Attribute(
                    name="function",
                    path="./brid:function",
                    datatype="[]string",
                    predefined_codelist="IntBuildingInstallation_function",
                ),
            ],
        )
    ],
    geometries=GeometricAttributes(
        lod2=GeometricAttribute(
            lod_detection=["./brid:lod2Geometry"],
            collect_all=[".//brid:lod2Geometry//gml:Polygon"],
        ),
        lod3=GeometricAttribute(
            lod_detection=["./brid:lod3Geometry"],
            collect_all=[".//brid:lod3Geometry//gml:Polygon"],
        ),
        lod4=GeometricAttribute(
            lod_detection=["./brid:lod4Geometry"],
            collect_all=[".//brid:lod4Geometry//gml:Polygon"],
        ),
    ),
)


BRIDGE_FURNITURE = FeatureProcessingDefinition(
    id="brid:BridgeFurniture",
    name="BridgeFurniture",
    target_elements=["brid:BridgeFurniture"],
    attribute_groups=[
        AttributeGroup(
            base_element=None,
            attributes=[
                Attribute(
                    name="function",
                    path="./brid:function",
                    datatype="[]string",
                    predefined_codelist="BuildingFurniture_function",
                ),
            ],
        ),
    ],
    geometries=GeometricAttributes(
        lod4=GeometricAttribute(
            lod_detection=["./brid:lod4Geometry"],
            collect_all=[".//brid:lod4Geometry//gml:Polygon"],
        ),
    ),
)
