"""地下街モデル (./ubld/)"""

from .base import (
    Attribute,
    AttributeGroup,
    FacilityAttributePaths,
    FeatureProcessingDefinition,
    GeometricAttribute,
    GeometricAttributes,
)

UNDERGROUND_BUILDING = FeatureProcessingDefinition(
    id="uro:UndergroundBuilding",
    name="UndergroundBuilding",
    target_elements=[
        "uro:UndergroundBuilding",
    ],
    nested_attributes=[
        "./uro:buildingDetailAttribute/uro:BuildingDetailAttribute",
        "./uro:buildingDetails/uro:BuildingDetails",  # PLATEAU v1.x
        "./uro:largeCustomerFacilityAttribute/uro:LargeCustomerFacilityAttribute",
        "./uro:largeCustomerFacilities/uro:LargeCustomerFacilities",  # PLATEAU v1.x
    ],
    attribute_groups=[
        AttributeGroup(
            base_element=None,
            attributes=[
                Attribute(
                    name="usage",
                    path="./bldg:usage",
                    datatype="[]string",
                    predefined_codelist="Building_usage",
                ),
                Attribute(
                    name="yearOfConstruction",
                    path="./bldg:yearOfConstruction",
                    datatype="integer",
                ),
                Attribute(
                    name="yearOfDemolition",
                    path="./bldg:yearOfDemolition",
                    datatype="integer",
                ),
                Attribute(
                    name="storeysBelowGround",
                    path="./bldg:storeysBelowGround",
                    datatype="integer",
                ),
                Attribute(
                    name="storeyHeightsBelowGround",
                    path="./bldg:storeyHeightsBelowGround",
                    datatype="[]double",
                ),
                Attribute(
                    name="address",
                    path="./bldg:address",
                    datatype="xAL",
                ),
            ],
        ),
        AttributeGroup(
            base_element="./uro:buildingIDAttribute/uro:BuildingIDAttribute",
            attributes=[
                Attribute(
                    name="buildingID",
                    path="./uro:buildingID",
                    datatype="string",
                ),
                Attribute(
                    name="branchID",
                    path="./uro:branchID",
                    datatype="integer",
                ),
                Attribute(
                    name="partID",
                    path="./uro:partID",
                    datatype="integer",
                ),
                Attribute(
                    name="prefecture",
                    path="./uro:prefecture",
                    datatype="string",
                    predefined_codelist="Common_localPublicAuthorities",
                ),
                Attribute(
                    name="city",
                    path="./uro:city",
                    datatype="string",
                    predefined_codelist="Common_localPublicAuthorities",
                ),
            ],
        ),
        AttributeGroup(
            base_element="./uro:buildingDataQualityAttribute/uro:BuildingDataQualityAttribute",
            attributes=[
                Attribute(
                    name="srcScale",
                    path="./uro:srcScale",
                    datatype="[]string",
                    predefined_codelist="BuildingDataQualityAttribute_srcScale",
                ),
                Attribute(
                    name="geometrySrcDesc",
                    path="./uro:geometrySrcDesc",
                    datatype="[]string",
                    predefined_codelist="BuildingDataQualityAttribute_geometrySrcDesc",
                ),
                Attribute(
                    name="thematicSrcDesc",
                    path="./uro:thematicSrcDesc",
                    datatype="[]string",
                    predefined_codelist="BuildingDataQualityAttribute_thematicSrcDesc",
                ),
                Attribute(
                    name="appearanceSrcDesc",
                    path="./uro:appearanceSrcDesc",
                    datatype="[]string",
                    predefined_codelist="BuildingDataQualityAttribute_appearanceSrcDesc",
                ),
                Attribute(
                    name="lod1HeightType",
                    path="./uro:lod1HeightType",
                    datatype="string",
                    predefined_codelist="BuildingDataQualityAttribute_lod1HeightType",
                ),
                Attribute(
                    name="lodType",
                    path="./uro:lodType",
                    datatype="[]string",
                ),
            ],
        ),
        # TODO: uro:keyValuePairAttribute
        # TODO: uro:indoorBuildingAttribute
        # (TODO: uro:ifcBuildingAttribute)
    ],
    disaster_risk_attr_conatiner_path="./uro:buildingDisasterRiskAttribute",
    dm_attr_container_path="./uro:bldgDmAttribute",
    facility_attr_paths=FacilityAttributePaths(
        facility_id="./uro:bldgFacilityIdAttribute",
        facility_types="./uro:bldgFacilityTypeAttribute",
        facility_attrs="./uro:bldgFacilityAttribute",
        large_customer_facility_attrs="./uro:largeCustomerFacilityAttribute",
    ),
    geometries=GeometricAttributes(
        lod0=GeometricAttribute(
            is2d=True,
            lod_detection=["./bldg:lod0RoofEdge"],
            collect_all=[".//bldg:lod0RoofEdge//gml:Polygon"],
        ),
        lod1=GeometricAttribute(
            lod_detection=["./bldg:lod1Solid"],
            collect_all=[".//bldg:lod1Solid//gml:Polygon"],
        ),
        lod2=GeometricAttribute(
            lod_detection=["./bldg:lod2Solid"],
            collect_all=[
                ".//bldg:lod2MultiSurface//gml:Polygon",
                ".//bldg:lod2Geometry//gml:Polygon",
            ],
            only_direct=["./bldg:lod2Solid//gml:Polygon"],
        ),
        lod3=GeometricAttribute(
            lod_detection=["./bldg:lod3Solid"],
            collect_all=[
                ".//bldg:lod3MultiSurface//gml:Polygon",
                ".//bldg:lod3Geometry//gml:Polygon",
                ".//bldg:lod3Solid//gml:Polygon",
            ],
            only_direct=["./bldg:lod3Solid//gml:Polygon"],
        ),
        lod4=GeometricAttribute(
            lod_detection=["./bldg:lod4Solid", "./bldg:lod4MultiSurface"],
            collect_all=[
                ".//bldg:lod4MultiSurface//gml:Polygon",
                ".//bldg:lod4Geometry//gml:Polygon",
                ".//bldg:lod4Solid//gml:Polygon",
            ],
            only_direct=[
                "./bldg:lod4MultiSurface//gml:Polygon",
                "./bldg:lod4Solid//gml:Polygon",
            ],
        ),
        semantic_parts=[
            ".//bldg:GroundSurface",
            ".//bldg:WallSurface",
            ".//bldg:RoofSurface",
            ".//bldg:OuterCeilingSurface",
            ".//bldg:OuterFloorSurface",
            ".//bldg:ClosureSurface",
            ".//bldg:CeilingSurface",
            ".//bldg:InteriorWallSurface",
            ".//bldg:FloorSurface",
            ".//bldg:BuildingInstallation",
            ".//bldg:IntBuildingInstallation",
            ".//bldg:BuildingFurniture",
            # TODO: 現状、 bldg:Room と bldg:BuildingPart の概念は考慮していない
        ],
    ),
)
