"""その他の構造物モデル (./cons/)"""

from .base import (
    Attribute,
    AttributeGroup,
    FacilityAttributePaths,
    FeatureProcessingDefinition,
    GeometricAttribute,
    GeometricAttributes,
)

_construction_structure_attribute_attrs = [
    Attribute(
        name="ceilingHeight",
        path="./uro:ceilingHeight",
        datatype="double",
    ),
    Attribute(
        name="damCode",
        path="./uro:damCode",
        datatype="string",
        predefined_codelist=None,
    ),
    Attribute(
        name="depth",
        path="./uro:depth",
        datatype="double",
    ),
    Attribute(
        name="length",
        path="./uro:length",
        datatype="double",
    ),
    Attribute(
        name="mainPartLength",
        path="./uro:mainPartLength",
        datatype="double",
    ),
    Attribute(
        name="structureType",
        path="./uro:structureType",
        datatype="string",
        predefined_codelist="ConstructionStructureAttribute_structureType",
    ),
    Attribute(
        name="totalWaterStorage",
        path="./uro:totalWaterStorage",
        datatype="double",
    ),
    Attribute(
        name="volume",
        path="./uro:volume",
        datatype="double",
    ),
    Attribute(
        name="waveDissipatorLength",
        path="./uro:waveDissipatorLength",
        datatype="double",
    ),
    Attribute(
        name="width",
        path="./uro:width",
        datatype="double",
    ),
]

URO_ELEVATION = FeatureProcessingDefinition(
    id="uro:Elevation",
    name="Elevation",
    target_elements=["uro:Elevation"],
    non_geometric=True,
    attribute_groups=[
        AttributeGroup(
            base_element=None,
            attributes=[
                Attribute(
                    name="elevationReference",
                    path="./uro:elevationReference",
                    datatype="string",
                    predefined_codelist="Elevation_elevationReference",
                ),
            ],
        )
    ],
    geometries=GeometricAttributes(
        lod0=GeometricAttribute(
            lod_detection=["./uro:elevationValue"],
            collect_all=["./uro:elevationValue"],
        ),
    ),
)


URO_HEIGHT = FeatureProcessingDefinition(
    id="uro:Height",
    name="Height",
    target_elements=["uro:Height"],
    non_geometric=True,
    attribute_groups=[
        AttributeGroup(
            base_element=None,
            attributes=[
                Attribute(
                    name="heighReference",
                    path="./uro:heighReference",
                    datatype="string",
                    predefined_codelist="Elevation_elevationReference",
                ),
                Attribute(
                    name="lowReference",
                    path="./uro:lowReference",
                    datatype="string",
                    predefined_codelist="Elevation_elevationReference",
                ),
                Attribute(
                    name="status",
                    path="./uro:status",
                    datatype="string",
                ),
                Attribute(
                    name="value",
                    path="./uro:value",
                    datatype="double",
                ),
            ],
        )
    ],
    geometries=GeometricAttributes(),
)


OTHER_CONSTRUCTION = FeatureProcessingDefinition(
    id="uro:OtherConstruction",
    name="OtherConstruction",
    target_elements=["uro:OtherConstruction"],
    nested_attributes=[
        "./uro:elevation/uro:Elevation",
        "./uro:height/uro:Height",
    ],
    attribute_groups=[
        AttributeGroup(
            base_element=None,
            attributes=[
                Attribute(
                    name="class",
                    path="./uro:class",
                    datatype="string",
                    predefined_codelist="OtherConstruction_class",
                ),
                Attribute(
                    name="function",
                    path="./uro:function",
                    datatype="[]string",
                    predefined_codelist="OtherConstruction_function",
                ),
                Attribute(
                    name="dateOfConstruction",
                    path="./uro:dateOfConstruction",
                    datatype="date",
                ),
                Attribute(
                    name="conditionOfConstruction",
                    path="./uro:conditionOfConstruction/uro:ConditionOfConstructionValue",
                    datatype="string",
                ),
            ],
        ),
        AttributeGroup(
            base_element="./uro:consBaseAttribute/uro:ConstructionBaseAttribute",
            attributes=[
                Attribute(
                    name="adminOffice",
                    path="./uro:adminOffice",
                    datatype="string",
                ),
                Attribute(
                    name="adminType",
                    path="./uro:adminType",
                    datatype="string",
                    predefined_codelist="ConstructionBaseAttribute_adminType",
                ),
                Attribute(
                    name="administorator",
                    path="./uro:administorator",
                    datatype="string",
                ),
                Attribute(
                    name="completionYear",
                    path="./uro:completionYear",
                    datatype="integer",
                ),
                Attribute(
                    name="constructionStartYear",
                    path="./uro:constructionStartYear",
                    datatype="integer",
                ),
                Attribute(
                    name="facilityAge",
                    path="./uro:facilityAge",
                    datatype="integer",
                ),
                Attribute(
                    name="installer",
                    path="./uro:installer",
                    datatype="string",
                ),
                Attribute(
                    name="installerType",
                    path="./uro:installerType",
                    datatype="string",
                    predefined_codelist="ConstructionBaseAttribute_installerType",
                ),
                Attribute(
                    name="kana",
                    path="./uro:kana",
                    datatype="string",
                ),
                Attribute(
                    name="operatorType",
                    path="./uro:operatorType",
                    datatype="string",
                    predefined_codelist=None,
                ),
                Attribute(
                    name="purpose",
                    path="./uro:purpose",
                    datatype="string",
                    predefined_codelist="ConstructionBaseAttribute_purpose",
                ),
                Attribute(
                    name="specification",
                    path="./uro:specification",
                    datatype="string",
                ),
                Attribute(
                    name="structureOrdinance",
                    path="./uro:structureOrdinance",
                    datatype="string",
                ),
                Attribute(
                    name="update",
                    path="./uro:update",
                    datatype="date",
                ),
            ],
        ),
        AttributeGroup(
            base_element="./uro:consStructureAttribute/uro:ConstructionStructureAttribute",
            attributes=_construction_structure_attribute_attrs,
        ),
        AttributeGroup(
            base_element="./uro:consStructureAttribute/uro:DamAttribute",
            attributes=_construction_structure_attribute_attrs,
        ),
        AttributeGroup(
            base_element="./uro:consStructureAttribute/uro:EmbankmentAttribute",
            attributes=_construction_structure_attribute_attrs,
        ),
        AttributeGroup(
            base_element="./uro:consDataQualityAttribute/uro:ConstructionDataQualityAttribute",
            attributes=[
                Attribute(
                    name="appearanceSrcDesc",
                    path="./uro:appearanceSrcDesc",
                    datatype="[]string",
                    predefined_codelist="DataQualityAttribute_appearanceSrcDesc",
                ),
                Attribute(
                    name="dataAcquisition",
                    path="./uro:dataAcquisition",
                    datatype="string",
                ),
                Attribute(
                    name="geometrySrcDesc",
                    path="./uro:geometrySrcDesc",
                    datatype="[]string",
                    predefined_codelist="DataQualityAttribute_geometrySrcDesc",
                ),
                Attribute(
                    name="lod1HeightType",
                    path="./uro:lod1HeightType",
                    datatype="string",
                    predefined_codelist="DataQualityAttribute_lod1HeightType",
                ),
                Attribute(
                    name="lodType",
                    path="./uro:lodType",
                    datatype="[]string",
                    predefined_codelist="OtherConstruction_lodType",
                ),
                Attribute(
                    name="photoScale",
                    path="./uro:photoScale",
                    datatype="integer",
                ),
                Attribute(
                    name="srcScale",
                    path="./uro:srcScale",
                    datatype="string",
                    predefined_codelist="DataQualityAttribute_srcScale",
                ),
                Attribute(
                    name="thematicSrcDesc",
                    path="./uro:thematicSrcDesc",
                    datatype="[]string",
                    predefined_codelist="DataQualityAttribute_thematicSrcDesc",
                ),
            ],
        ),
    ],
    dm_attr_container_path="./uro:consDmAttribute",
    facility_attr_paths=FacilityAttributePaths(
        facility_id="./uro:consFacilityIdAttribute",
        facility_types="./uro:consFacilityTypeAttribute",
        facility_attrs="./uro:consFacilityAttribute",
    ),
    geometries=GeometricAttributes(
        lod0=GeometricAttribute(
            is2d=True,
            lod_detection=["./uro:lod0Geometry"],
            collect_all=[
                "./uro:lod0Geometry//gml:LineString",
                "./uro:lod0Geometry//gml:Polygon",
                "./uro:lod0Geometry//gml:Point",
            ],
        ),
        lod1=GeometricAttribute(
            lod_detection=["./uro:lod1Geometry"],
            collect_all=["./uro:lod1Geometry//gml:Polygon"],
        ),
        lod2=GeometricAttribute(
            lod_detection=["./uro:lod2Geometry"],
            collect_all=[
                ".//uro:lod2MultiSurface//gml:Polygon",
                ".//uro:lod2Geometry//gml:Polygon",
            ],
            only_direct=[
                "./uro:lod2MultiSurface//gml:Polygon",
                "./uro:lod2Geometry//gml:Polygon",
            ],
        ),
        lod3=GeometricAttribute(
            lod_detection=["./uro:lod3Geometry"],
            collect_all=[
                ".//uro:lod3MultiSurface//gml:Polygon",
                ".//uro:lod3Geometry//gml:Polygon",
            ],
            only_direct=[
                "./uro:lod3MultiSurface//gml:Polygon",
                "./uro:lod3Geometry//gml:Polygon",
            ],
        ),
        semantic_parts=[
            ".//uro:GroundSurface",
            ".//uro:WallSurface",
            ".//uro:RoofSurface",
            ".//uro:OuterCeilingSurface",
            ".//uro:OuterFloorSurface",
            ".//uro:ClosureSurface",
            ".//uro:ConstructionInstallation",
        ],
    ),
)

OTHER_CONSTRUCTION_BOUNDARY_SURFACE = FeatureProcessingDefinition(
    id="uro:_BoundarySurface",
    name="BoundarySurface",
    target_elements=[
        "uro:GroundSurface",
        "uro:WallSurface",
        "uro:RoofSurface",
        "uro:OuterCeilingSurface",
        "uro:OuterFloorSurface",
        "uro:ClosureSurface",
    ],
    attribute_groups=[],
    geometries=GeometricAttributes(
        lod2=GeometricAttribute(
            lod_detection=["./uro:lod2MultiSurface"],
            collect_all=[
                ".//uro:lod2MultiSurface//gml:Polygon",
                ".//uro:lod2Geometry//gml:Polygon",
            ],
        ),
        lod3=GeometricAttribute(
            lod_detection=["./uro:lod3MultiSurface"],
            collect_all=[
                ".//uro:lod3MultiSurface//gml:Polygon",
                ".//uro:lod3Geometry//gml:Polygon",
            ],
        ),
        lod4=GeometricAttribute(
            lod_detection=["./uro:lod4MultiSurface"],
            collect_all=[
                ".//uro:lod4MultiSurface//gml:Polygon",
                ".//uro:lod4Geometry//gml:Polygon",
            ],
        ),
    ),
)

OTHER_CONSTRUCTION_INSTALLATION = FeatureProcessingDefinition(
    id="uro:ConstructionInstallation",
    name="ConstructionInstallation",
    target_elements=["uro:ConstructionInstallation"],
    attribute_groups=[
        AttributeGroup(
            base_element=None,
            attributes=[
                Attribute(
                    name="class",
                    path="./uro:class",
                    datatype="string",
                ),
                Attribute(
                    name="function",
                    path="./uro:function",
                    datatype="[]string",
                    predefined_codelist="ConstructionInstallation_function",
                ),
                Attribute(
                    name="usage",
                    path="./uro:usage",
                    datatype="[]string",
                ),
            ],
        )
    ],
    geometries=GeometricAttributes(
        lod2=GeometricAttribute(
            lod_detection=["./uro:lod2Geometry"],
            collect_all=[".//uro:lod2Geometry//gml:Polygon"],
        ),
        lod3=GeometricAttribute(
            lod_detection=["./uro:lod3Geometry"],
            collect_all=[".//uro:lod3Geometry//gml:Polygon"],
        ),
        lod4=GeometricAttribute(
            lod_detection=["./uro:lod4Geometry"],
            collect_all=[".//uro:lod4Geometry//gml:Polygon"],
        ),
    ),
)
