from ..base import (
    Attribute,
    AttributeGroup,
    FeatureProcessingDefinition,
    GeometricAttribute,
    GeometricAttributes,
)
from .common import ZONE_ATTRIBUTES

_COMMON_ATTRS = [
    AttributeGroup(
        base_element=None,
        attributes=[
            Attribute(
                name="function",
                path="./urf:function",
                datatype="[]string",
                predefined_codelist="DistrictDevelopmentPlan_function",
            ),
        ],
    ),
    *ZONE_ATTRIBUTES,
    AttributeGroup(
        base_element=None,
        attributes=[
            Attribute(
                name="activityRestrictionInFarmland",
                path="./urf:activityRestrictionInFarmland",
                datatype="string",
            ),
            Attribute(
                name="buildingRestrictions",
                path="./urf:buildingRestrictions",
                datatype="string",
            ),
            Attribute(
                name="districtFacilitiesAllocation",
                path="./urf:districtFacilitiesAllocation",
                datatype="string",
            ),
            Attribute(
                name="landuseRestrictions",
                path="./urf:landuseRestrictions",
                datatype="string",
            ),
            Attribute(
                name="urbanGreenSpaceConservation",
                path="./urf:urbanGreenSpaceConservation",
                datatype="string",
            ),
        ],
    ),
]

_COMMON_GEOMETRIES = GeometricAttributes(
    lod1=GeometricAttribute(
        is2d=True,
        lod_detection=["./urf:lod1MultiSurface", "./urf:lod0MultiSurface"],
        collect_all=[
            "./urf:lod1MultiSurface//gml:Polygon",
            "./urf:lod0MultiSurface//gml:Polygon",
        ],
    ),
    semantic_parts=[
        "./urf:districtFacility/*",
        "./urf:district/urf:District",
    ],
)

_URF_DISTRICT = FeatureProcessingDefinition(
    id="urf:District",
    name="地区",
    target_elements=["urf:District"],
    attribute_groups=[
        *ZONE_ATTRIBUTES,
        AttributeGroup(
            base_element=None,
            attributes=[
                Attribute(
                    name="function",
                    path="./urf:function",
                    datatype="[]string",
                    predefined_codelist="District_function",
                ),
                Attribute(
                    name="buildingDesignRestriction",
                    path="./urf:buildingDesignRestriction",
                    datatype="string",
                ),
                Attribute(
                    name="buildingRestrictions",
                    path="./urf:buildingRestrictions",
                    datatype="string",
                ),
                Attribute(
                    name="fenceGuideline",
                    path="./urf:fenceGuideline",
                    datatype="string",
                ),
                Attribute(
                    name="maximumBuildingCoverageRate",
                    path="./urf:maximumBuildingCoverageRate",
                    datatype="double",
                ),
                Attribute(
                    name="maximumBuildingHeight",
                    path="./urf:maximumBuildingHeight",
                    datatype="double",
                ),
                Attribute(
                    name="maximumFloorAreaRate",
                    path="./urf:maximumFloorAreaRate",
                    datatype="double",
                ),
                Attribute(
                    name="minimumBuildingArea",
                    path="./urf:minimumBuildingArea",
                    datatype="double",
                ),
                Attribute(
                    name="minimumBuildingCoverageRate",
                    path="./urf:minimumBuildingCoverageRate",
                    datatype="double",
                ),
                Attribute(
                    name="minimumBuildingHeight",
                    path="./urf:minimumBuildingHeight",
                    datatype="double",
                ),
                Attribute(
                    name="minimumFloorAreaRate",
                    path="./urf:minimumFloorAreaRate",
                    datatype="double",
                ),
                Attribute(
                    name="minimumFloorHeight",
                    path="./urf:minimumFloorHeight",
                    datatype="double",
                ),
                Attribute(
                    name="minimumFrontageRate",
                    path="./urf:minimumFrontageRate",
                    datatype="double",
                ),
                Attribute(
                    name="minimumGreeningRate",
                    path="./urf:minimumGreeningRate",
                    datatype="double",
                ),
                Attribute(
                    name="minimumGroundHeight",
                    path="./urf:minimumGroundHeight",
                    datatype="double",
                ),
                Attribute(
                    name="minimumSiteArea",
                    path="./urf:minimumSiteArea",
                    datatype="double",
                ),
                Attribute(
                    name="restrictionsForFireProtection",
                    path="./urf:restrictionsForFireProtection",
                    datatype="string",
                ),
                Attribute(
                    name="restrictionsForNoiseProtection",
                    path="./urf:restrictionsForNoiseProtection",
                    datatype="string",
                ),
                Attribute(
                    name="setbackSize",
                    path="./urf:setbackSize",
                    datatype="string",
                ),
                Attribute(
                    name="structurePlacementRestrictions",
                    path="./urf:structurePlacementRestrictions",
                    datatype="string",
                ),
                Attribute(
                    name="useRestrictions",
                    path="./urf:useRestrictions",
                    datatype="string",
                ),
            ],
        ),
    ],
    geometries=GeometricAttributes(
        lod0=GeometricAttribute(
            is2d=True,
            lod_detection=["./urf:lod0MultiSurface"],
            collect_all=["./urf:lod0MultiSurface//gml:Polygon"],
        ),
        lod1=GeometricAttribute(
            is2d=True,
            lod_detection=["./urf:lod1MultiSurface"],
            collect_all=["./urf:lod1MultiSurface//gml:Polygon"],
        ),
    ),
)

_URF_DISTRICT = FeatureProcessingDefinition(
    id="urf:District",
    name="地区",
    target_elements=["urf:District"],
    attribute_groups=[
        *ZONE_ATTRIBUTES,
        AttributeGroup(
            base_element=None,
            attributes=[
                Attribute(
                    name="function",
                    path="./urf:function",
                    datatype="[]string",
                    predefined_codelist="District_function",
                ),
                Attribute(
                    name="buildingDesignRestriction",
                    path="./urf:buildingDesignRestriction",
                    datatype="string",
                ),
                Attribute(
                    name="buildingRestrictions",
                    path="./urf:buildingRestrictions",
                    datatype="string",
                ),
                Attribute(
                    name="fenceGuideline",
                    path="./urf:fenceGuideline",
                    datatype="string",
                ),
                Attribute(
                    name="maximumBuildingCoverageRate",
                    path="./urf:maximumBuildingCoverageRate",
                    datatype="double",
                ),
                Attribute(
                    name="maximumBuildingHeight",
                    path="./urf:maximumBuildingHeight",
                    datatype="double",
                ),
                Attribute(
                    name="maximumFloorAreaRate",
                    path="./urf:maximumFloorAreaRate",
                    datatype="double",
                ),
                Attribute(
                    name="minimumBuildingArea",
                    path="./urf:minimumBuildingArea",
                    datatype="double",
                ),
                Attribute(
                    name="minimumBuildingCoverageRate",
                    path="./urf:minimumBuildingCoverageRate",
                    datatype="double",
                ),
                Attribute(
                    name="minimumBuildingHeight",
                    path="./urf:minimumBuildingHeight",
                    datatype="double",
                ),
                Attribute(
                    name="minimumFloorAreaRate",
                    path="./urf:minimumFloorAreaRate",
                    datatype="double",
                ),
                Attribute(
                    name="minimumFloorHeight",
                    path="./urf:minimumFloorHeight",
                    datatype="double",
                ),
                Attribute(
                    name="minimumFrontageRate",
                    path="./urf:minimumFrontageRate",
                    datatype="double",
                ),
                Attribute(
                    name="minimumGreeningRate",
                    path="./urf:minimumGreeningRate",
                    datatype="double",
                ),
                Attribute(
                    name="minimumGroundHeight",
                    path="./urf:minimumGroundHeight",
                    datatype="double",
                ),
                Attribute(
                    name="minimumSiteArea",
                    path="./urf:minimumSiteArea",
                    datatype="double",
                ),
                Attribute(
                    name="restrictionsForFireProtection",
                    path="./urf:restrictionsForFireProtection",
                    datatype="string",
                ),
                Attribute(
                    name="restrictionsForNoiseProtection",
                    path="./urf:restrictionsForNoiseProtection",
                    datatype="string",
                ),
                Attribute(
                    name="setbackSize",
                    path="./urf:setbackSize",
                    datatype="string",
                ),
                Attribute(
                    name="structurePlacementRestrictions",
                    path="./urf:structurePlacementRestrictions",
                    datatype="string",
                ),
                Attribute(
                    name="useRestrictions",
                    path="./urf:useRestrictions",
                    datatype="string",
                ),
            ],
        ),
    ],
    geometries=GeometricAttributes(
        lod0=GeometricAttribute(
            is2d=True,
            lod_detection=["./urf:lod0MultiSurface"],
            collect_all=["./urf:lod0MultiSurface//gml:Polygon"],
        ),
        lod1=GeometricAttribute(
            is2d=True,
            lod_detection=["./urf:lod1MultiSurface"],
            collect_all=["./urf:lod1MultiSurface//gml:Polygon"],
        ),
    ),
)

DEFS = [
    _URF_DISTRICT,
    FeatureProcessingDefinition(
        id="urf:DistrictDevelopmentPlan",
        name="地区整備計画",
        target_elements=["urf:DistrictDevelopmentPlan"],
        attribute_groups=_COMMON_ATTRS,
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="RoadsideDistrictImprovementPlan",
        name="沿道地区整備計画",
        target_elements=["urf:RoadsideDistrictImprovementPlan"],
        attribute_groups=[
            *_COMMON_ATTRS,
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="roadsideDistrictFacilitiesAllocation",
                        path="./urf:roadsideDistrictFacilitiesAllocation",
                        datatype="string",
                    ),
                ],
            ),
        ],
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="RuralDistrictImprovementPlan",
        name="集落地区整備計画",
        target_elements=["urf:RuralDistrictImprovementPlan"],
        attribute_groups=[
            *_COMMON_ATTRS,
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="ruralDistrictFacilitiesAllocation",
                        path="./urf:ruralDistrictFacilitiesAllocation",
                        datatype="string",
                    ),
                ],
            ),
        ],
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="DistrictImprovementPlanForHistoricSceneryMaintenanceAndImprovementDistrict",
        name="歴史的風致維持向上地区整備計画",
        target_elements=[
            "urf:DistrictImprovementPlanForHistoricSceneryMaintenanceAndImprovementDistrict"
        ],
        attribute_groups=_COMMON_ATTRS,
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="SpecifiedBuildingZoneImprovementPlan",
        name="特定建築物地区整備計画",
        target_elements=["urf:SpecifiedBuildingZoneImprovementPlan"],
        attribute_groups=_COMMON_ATTRS,
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="DistrictImprovementPlanForDisasterPreventionBlockImprovementZonePlan",
        name="防災街区整備地区整備計画",
        target_elements=[
            "urf:DistrictImprovementPlanForDisasterPreventionBlockImprovementZonePlan"
        ],
        attribute_groups=_COMMON_ATTRS,
        geometries=_COMMON_GEOMETRIES,
    ),
]
