from ..base import (
    Attribute,
    AttributeGroup,
    FeatureProcessingDefinition,
    GeometricAttribute,
    GeometricAttributes,
)
from .common import ZONE_ATTRIBUTES

_ABSTRACT_ATTRS = [
    AttributeGroup(
        base_element=None,
        attributes=[
            Attribute(
                name="function",
                path="./urf:function",
                datatype="[]string",
                predefined_codelist="DistrictPlan_function",
            ),
        ],
    ),
    *ZONE_ATTRIBUTES,
    AttributeGroup(
        base_element=None,
        attributes=[
            Attribute(
                name="objectives",
                path="./urf:objectives",
                datatype="string",
            ),
            Attribute(
                name="policy",
                path="./urf:policy",
                datatype="string",
            ),
        ],
    ),
]

_ABSTRACT_GEOMETRIES = GeometricAttributes(
    lod1=GeometricAttribute(
        is2d=True,
        lod_detection=["./urf:lod1MultiSurface", "./urf:lod0MultiSurface"],
        collect_all=[
            "./urf:lod1MultiSurface//gml:Polygon",
            "./urf:lod0MultiSurface//gml:Polygon",
        ],
    ),
    semantic_parts=[
        "./urf:districtDevelopmentPlan/*",
        "./urf:promotionDistrict/urf:PromotionDistrict",
        "./urf:zonalDisasterPreventionFacilities/urf:ZonalDisasterPreventionFacility",
    ],
)


DEFS = [
    FeatureProcessingDefinition(
        id="urf:DistrictPlan",
        name="地区計画",
        target_elements=["urf:DistrictPlan"],
        attribute_groups=[
            *_ABSTRACT_ATTRS,
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="facilityAllocation",
                        path="./urf:facilityAllocation",
                        datatype="string",
                    ),
                    Attribute(
                        name="landUsePolicy",
                        path="./urf:landUsePolicy",
                        datatype="string",
                    ),
                ],
            ),
        ],
        geometries=_ABSTRACT_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:RoadsideDistrictPlan",
        name="沿道地区計画",
        target_elements=["urf:RoadsideDistrictPlan"],
        attribute_groups=[
            *_ABSTRACT_ATTRS,
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="facilitiesAllocation",
                        path="./urf:facilitiesAllocation",
                        datatype="string",
                    ),
                    Attribute(
                        name="landUsePolicy",
                        path="./urf:landUsePolicy",
                        datatype="string",
                    ),
                ],
            ),
        ],
        geometries=_ABSTRACT_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:RuralDistrictPlan",
        name="集落地区計画",
        target_elements=["urf:RuralDistrictPlan"],
        attribute_groups=_ABSTRACT_ATTRS,
        geometries=_ABSTRACT_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:HistoricSceneryMaintenanceAndImprovementDistrictPlan",
        name="歴史的風致維持向上地区計画",
        target_elements=["urf:HistoricSceneryMaintenanceAndImprovementDistrictPlan"],
        attribute_groups=[
            *_ABSTRACT_ATTRS,
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="landUsePolicy",
                        path="./urf:landUsePolicy",
                        datatype="string",
                    ),
                ],
            ),
        ],
        geometries=_ABSTRACT_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:DisasterPreventionBlockImprovementZonePlan",
        name="防災街区整備地区計画",
        target_elements=["urf:DisasterPreventionBlockImprovementZonePlan"],
        attribute_groups=[
            *_ABSTRACT_ATTRS,
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="specifiedZonalDisasterPreventionFacilitiesAllocation",
                        path="./urf:specifiedZonalDisasterPreventionFacilitiesAllocation",
                        datatype="string",
                    ),
                    Attribute(
                        name="zonalDisasterPreventionFacilitiesAllocation",
                        path="./urf:zonalDisasterPreventionFacilitiesAllocation",
                        datatype="string",
                    ),
                ],
            ),
        ],
        geometries=_ABSTRACT_GEOMETRIES,
    ),
]
