"""地下埋設物モデル (./unf/)

Featureの継承関係:

- (uro:UtilityNetworkElement)
  - (uro:UtilityNode)
    - uro:Appurtenance
  - (uro:UtilityNodeContainer)
    - uro:Manhole
    - uro:Handhole
  - (uro:UtilityLink)
    - uro:Pipe
      - uro:WaterPipe
      - uro:SewerPipe
      - uro:OilGasChemicalsPipe
      - uro:ThermalPipe
    - uro:Cable
      - uro:ElectricityCable
      - uro:TelecommunicationsCable
    - uro:Duct

uro:UtilityNode, uro:UtilityNodeContainer, uro:UtilityLink の3種類に分けて取り扱う
"""

from .base import (
    Attribute,
    AttributeGroup,
    FacilityAttributePaths,
    FeatureProcessingDefinition,
    GeometricAttribute,
    GeometricAttributes,
)

_utility_network_element_attrs = [
    AttributeGroup(
        base_element=None,
        attributes=[
            Attribute(
                name="function",
                path="./frn:function",
                datatype="[]string",
                predefined_codelist="CityFurniture_function",
            ),
            Attribute(
                name="administrator",
                path="./uro:administrator",
                datatype="string",
                predefined_codelist="UtilityNetworkElement_administrator",
            ),
            Attribute(
                name="occupierName",
                path="./uro:occupierName",
                datatype="string",
                predefined_codelist="UtilityNetworkElement_occupierName",
            ),
            Attribute(
                name="occupierType",
                path="./uro:occupierType",
                datatype="string",
                predefined_codelist="UtilityNetworkElement_occupierType",
            ),
            Attribute(
                name="year",
                path="./uro:year",
                datatype="integer",
            ),
            Attribute(
                name="yearType",
                path="./uro:yearType",
                datatype="string",
                predefined_codelist="UtilityNetworkElement_yearType",
            ),
        ],
    ),
    AttributeGroup(
        base_element="./uro:cityFurnitureDataQualityAttribute/uro:CityFurnitureDataQualityAttribute",
        attributes=[
            Attribute(
                name="srcScale",
                path="./uro:srcScale",
                datatype="[]string",
                predefined_codelist="CityFurnitureDataQualityAttribute_srcScale",
            ),
            Attribute(
                name="geometrySrcDesc",
                path="./uro:geometrySrcDesc",
                datatype="[]string",
                predefined_codelist="CityFurnitureDataQualityAttribute_geometrySrcDesc",
            ),
            Attribute(
                name="thematicSrcDesc",
                path="./uro:thematicSrcDesc",
                datatype="[]string",
                predefined_codelist="CityFurnitureDataQualityAttribute_thematicSrcDesc",
            ),
            Attribute(
                name="appearanceSrcDesc",
                path="./uro:appearanceSrcDesc",
                datatype="[]string",
                predefined_codelist="CityFurnitureDataQualityAttribute_appearanceSrcDesc",
            ),
            Attribute(
                name="lodType",
                path="./uro:lodType",
                datatype="[]string",
            ),
        ],
    ),
]


UTILITY_NODE = FeatureProcessingDefinition(
    id="uro:UtilityNode",
    name="UtilityNode",
    target_elements=[
        "uro:Appurtenance",
    ],
    load_generic_attributes=True,
    nested_attributes=[
        "./uro:offsetDepth/uro:OffsetDepth",
        "./uro:thematicShape/uro:ThematicShape",
        "./uro:cityFurnitureDetailAttribute/uro:CityFurnitureDetailAttribute",
    ],
    attribute_groups=[
        *_utility_network_element_attrs,
        AttributeGroup(
            base_element=None,
            attributes=[
                Attribute(
                    name="appurtenanceType",
                    path="./uro:appurtenanceType",
                    datatype="string",
                    predefined_codelist="Appurtenance_appurtenanceType",
                ),
                Attribute(
                    name="nextLink",
                    path="./uro:nextLink",
                    datatype="[]string",
                ),
                Attribute(
                    name="previousLink",
                    path="./uro:previousLink",
                    datatype="[]string",
                ),
                Attribute(
                    name="rotationAngle",
                    path="./uro:rotationAngle",
                    datatype="double",
                ),
            ],
        ),
    ],
    dm_attr_container_path="./uro:frnDmAttribute",
    facility_attr_paths=FacilityAttributePaths(
        facility_id="./uro:frnFacilityIdAttribute",
        facility_types="./uro:frnFacilityTypeAttribute",
        facility_attrs="./uro:frnFacilityAttribute",
    ),
    geometries=GeometricAttributes(
        lod1=GeometricAttribute(
            lod_detection=["./frn:lod1Geometry"],
            collect_all=["./frn:lod1Geometry//gml:Polygon"],
        ),
        lod2=GeometricAttribute(
            lod_detection=["./frn:lod2Geometry"],
            collect_all=["./frn:lod2Geometry//gml:Polygon"],
        ),
        lod3=GeometricAttribute(
            lod_detection=["./frn:lod3Geometry"],
            collect_all=["./frn:lod3Geometry//gml:Polygon"],
        ),
    ),
)

UTILITY_NODE_CONTAINER = FeatureProcessingDefinition(
    id="uro:UtilityNodeContainer",
    name="UtilityNodeContainer",
    target_elements=[
        "uro:Manhole",
        "uro:Handhole",
    ],
    load_generic_attributes=True,
    nested_attributes=[
        "./uro:offsetDepth/uro:OffsetDepth",
        "./uro:thematicShape/uro:ThematicShape",
        "./uro:cityFurnitureDetailAttribute/uro:CityFurnitureDetailAttribute",
    ],
    attribute_groups=[
        *_utility_network_element_attrs,
        AttributeGroup(
            base_element=None,
            attributes=[
                Attribute(
                    name="appurtenance",
                    path="./uro:appurtenance",
                    datatype="[]string",
                ),
                Attribute(
                    name="containerType",
                    path="./uro:containerType",
                    datatype="string",
                    predefined_codelist="UtilityNodeContainer_containerType",
                ),
                Attribute(
                    name="depth",
                    path="./uro:depth",
                    datatype="double",
                ),
                Attribute(
                    name="innerDiamiterLong",
                    path="./uro:innerDiamiterLong",
                    datatype="double",
                ),
                Attribute(
                    name="innerDiamiterShort",
                    path="./uro:innerDiamiterShort",
                    datatype="double",
                ),
                Attribute(
                    name="outerDiamiterLong",
                    path="./uro:outerDiamiterLong",
                    datatype="double",
                ),
                Attribute(
                    name="outerDiamiterShort",
                    path="./uro:outerDiamiterShort",
                    datatype="double",
                ),
                Attribute(
                    name="rotationAngle",
                    path="./uro:rotationAngle",
                    datatype="double",
                ),
            ],
        ),
    ],
    dm_attr_container_path="./uro:frnDmAttribute",
    facility_attr_paths=FacilityAttributePaths(
        facility_id="./uro:frnFacilityIdAttribute",
        facility_types="./uro:frnFacilityTypeAttribute",
        facility_attrs="./uro:frnFacilityAttribute",
    ),
    geometries=GeometricAttributes(
        lod1=GeometricAttribute(
            lod_detection=["./frn:lod1Geometry"],
            collect_all=["./frn:lod1Geometry//gml:Polygon"],
        ),
        lod2=GeometricAttribute(
            lod_detection=["./frn:lod2Geometry"],
            collect_all=["./frn:lod2Geometry//gml:Polygon"],
        ),
        lod3=GeometricAttribute(
            lod_detection=["./frn:lod3Geometry"],
            collect_all=["./frn:lod3Geometry//gml:Polygon"],
        ),
    ),
)

UTILITY_LINK = FeatureProcessingDefinition(
    id="uro:UtilityLink",
    name="UtilityLink",
    target_elements=[
        "uro:Pipe",
        "uro:WaterPipe",
        "uro:ThermalPipe",
        "uro:SewerPipe",
        "uro:OilGasChemicalsPipe",
        "uro:Duct",
        "uro:Cable",
        "uro:TelecommunicationsCable",
        "uro:ElectricityCable",
    ],
    load_generic_attributes=True,
    nested_attributes=[
        "./uro:cityFurnitureDetailAttribute/uro:CityFurnitureDetailAttribute",
        "./uro:offsetDepth/uro:OffsetDepth",
        "./uro:thematicShape/uro:ThematicShape",
        "./uro:lengthAttribute/uro:LengthAttribute",
    ],
    attribute_groups=[
        *_utility_network_element_attrs,
        AttributeGroup(
            base_element=None,
            attributes=[
                Attribute(
                    name="cables",
                    path="./uro:cables",
                    datatype="integer",
                ),
                Attribute(
                    name="columns",
                    path="./uro:columns",
                    datatype="integer",
                ),
                Attribute(
                    name="depth",
                    path="./uro:depth",
                    datatype="double",
                ),
                Attribute(
                    name="endNode",
                    path="./uro:endNode",
                    datatype="string",
                ),
                Attribute(
                    name="innerDiamiter",
                    path="./uro:innerDiamiter",
                    datatype="double",
                ),
                Attribute(
                    name="material",
                    path="./uro:material",
                    datatype="string",
                    predefined_codelist="UtilityNetworkElement_material",
                ),
                Attribute(
                    name="maxDepth",
                    path="./uro:maxDepth",
                    datatype="double",
                ),
                Attribute(
                    name="maxWidth",
                    path="./uro:maxWidth",
                    datatype="double",
                ),
                Attribute(
                    name="minDepth",
                    path="./uro:minDepth",
                    datatype="double",
                ),
                Attribute(
                    name="offset",
                    path="./uro:offset",
                    datatype="double",
                ),
                Attribute(
                    name="outerDiamiter",
                    path="./uro:outerDiamiter",
                    datatype="double",
                ),
                Attribute(
                    name="routeEndNode",
                    path="./uro:routeEndNode",
                    datatype="string",
                ),
                Attribute(
                    name="routeStartNode",
                    path="./uro:routeStartNode",
                    datatype="string",
                ),
                Attribute(
                    name="rows",
                    path="./uro:rows",
                    datatype="integer",
                ),
                Attribute(
                    name="sleeveType",
                    path="./uro:sleeveType",
                    datatype="string",
                    predefined_codelist="Pipe_sleeveType",
                ),
                Attribute(
                    name="slope",
                    path="./uro:slope",
                    datatype="double",
                ),
                Attribute(
                    name="startNode",
                    path="./uro:startNode",
                    datatype="string",
                ),
                Attribute(
                    name="width",
                    path="./uro:width",
                    datatype="double",
                ),
            ],
        ),
    ],
    dm_attr_container_path="./uro:frnDmAttribute",
    facility_attr_paths=FacilityAttributePaths(
        facility_id="./uro:frnFacilityIdAttribute",
        facility_types="./uro:frnFacilityTypeAttribute",
        facility_attrs="./uro:frnFacilityAttribute",
    ),
    geometries=GeometricAttributes(
        lod1=GeometricAttribute(
            lod_detection=["./frn:lod1Geometry"],
            collect_all=["./frn:lod1Geometry//gml:Polygon"],
        ),
        lod2=GeometricAttribute(
            lod_detection=["./frn:lod2Geometry"],
            collect_all=["./frn:lod2Geometry//gml:Polygon"],
        ),
        lod3=GeometricAttribute(
            lod_detection=["./frn:lod3Geometry"],
            collect_all=["./frn:lod3Geometry//gml:Polygon"],
        ),
    ),
)

OFFSET_DEPTH = FeatureProcessingDefinition(
    id="uro:OffsetDepth",
    name="OffsetDepth",
    target_elements=[
        "uro:OffsetDepth",
    ],
    attribute_groups=[
        AttributeGroup(
            base_element=None,
            attributes=[
                Attribute(
                    name="offset",
                    path="./uro:offset",
                    datatype="double",
                ),
                Attribute(
                    name="depth",
                    path="./uro:depth",
                    datatype="double",
                ),
                Attribute(
                    name="minDepth",
                    path="./uro:minDepth",
                    datatype="double",
                ),
                Attribute(
                    name="maxDepth",
                    path="./uro:maxDepth",
                    datatype="double",
                ),
            ],
        )
    ],
    geometries=GeometricAttributes(
        lod0=GeometricAttribute(
            lod_detection=["./uro:pos"],
            collect_all=["./uro:pos"],
        ),
    ),
)

THEMATIC_SHAPE = FeatureProcessingDefinition(
    id="uro:TheamticShape",
    name="ThematicShape",
    target_elements=[
        "uro:ThematicShape",
    ],
    attribute_groups=[
        AttributeGroup(
            base_element=None,
            attributes=[
                Attribute(
                    name="heightType",
                    path="./uro:heightType",
                    datatype="string",
                    predefined_codelist="ThematicShape_heightType",
                ),
            ],
        )
    ],
    geometries=GeometricAttributes(
        lod0=GeometricAttribute(
            lod_detection=[
                "./uro:shape//gml:LineString",
                "./uro:shape//gml:Point",
            ],
            collect_all=["./uro:shape//gml:LineString", "./uro:shape//gml:Point"],
        ),
    ),
)

LENGTH_ATTRIBUTE = FeatureProcessingDefinition(
    id="uro:LengthAttribute",
    name="LengthAttribute",
    target_elements=[
        "uro:LengthAttribute",
    ],
    non_geometric=True,
    attribute_groups=[
        AttributeGroup(
            base_element=None,
            attributes=[
                Attribute(
                    name="length",
                    path="./uro:length",
                    datatype="double",
                ),
                Attribute(
                    name="mesureType",
                    path="./uro:mesureType",
                    datatype="string",
                    predefined_codelist="LengthAttribute_mesureType",
                ),
            ],
        )
    ],
    geometries=GeometricAttributes(),
)
