from ..base import (
    Attribute,
    AttributeGroup,
    FeatureProcessingDefinition,
    GeometricAttribute,
    GeometricAttributes,
)
from .common import ZONE_ATTRIBUTES

_COMMON_ATTRS = [
    AttributeGroup(
        base_element=None,
        attributes=[
            Attribute(
                name="function",
                path="./urf:function",
                datatype="[]string",
                predefined_codelist="UrbanFacility_function",
            ),
        ],
    ),
    *ZONE_ATTRIBUTES,
]

_STIPULATED_ATTRS = [
    *ZONE_ATTRIBUTES,
    AttributeGroup(
        base_element=None,
        attributes=[
            Attribute(
                name="function",
                path="./urf:function",
                datatype="[]string",
                predefined_codelist="UrbanFacility_function",
            ),
            Attribute(
                name="length",
                path="./urf:length",
                datatype="double",
            ),
            Attribute(
                name="width",
                path="./urf:width",
                datatype="double",
            ),
        ],
    ),
]

_COMMON_GEOMETRIES = GeometricAttributes(
    lod1=GeometricAttribute(
        is2d=True,
        lod_detection=["./urf:lod1MultiSurface", "./urf:lod0MultiSurface"],
        collect_all=[
            "./urf:lod1MultiSurface//gml:Polygon",
            "./urf:lod0MultiSurface//gml:Polygon",
        ],
    ),
)


DEFS = [
    FeatureProcessingDefinition(
        id="urf:UrbanFacility",
        name="都市施設",
        target_elements=["urf:UrbanFacility"],
        attribute_groups=_COMMON_ATTRS,
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:StructureDetails",
        name="StructureDetails",
        target_elements=["urf:StructureDetails"],
        non_geometric=True,
        attribute_groups=[
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="startLocation",
                        path="urf:startLocation",
                        datatype="string",
                    ),
                    Attribute(
                        name="endLocation",
                        path="urf:endLocation",
                        datatype="string",
                    ),
                    Attribute(
                        name="viaLocations",
                        path="urf:viaLocations",
                        datatype="string",
                    ),
                    Attribute(
                        name="length",
                        path="urf:length",
                        datatype="double",
                    ),
                    Attribute(
                        name="structureType",
                        path="urf:structureType",
                        datatype="string",
                        predefined_codelist="TrafficFacility_trafficFacilityStructureType",
                    ),
                    Attribute(
                        name="minimumWidth",
                        path="urf:minimumWidth",
                        datatype="double",
                    ),
                    Attribute(
                        name="maximumWidth",
                        path="urf:maximumWidth",
                        datatype="double",
                    ),
                    Attribute(
                        name="standardWidth",
                        path="urf:standardWidth",
                        datatype="double",
                    ),
                    Attribute(
                        name="crossType",
                        path="urf:crossType",
                        datatype="string",
                        predefined_codelist="TrafficFacility_trafficFacilityCrossingType",
                    ),
                ],
            )
        ],
        geometries=GeometricAttributes(),
    ),
    FeatureProcessingDefinition(
        id="urf:TrafficFacility",
        name="交通施設",
        target_elements=["urf:TrafficFacility"],
        nested_attributes=[
            "./urf:urbanRapidTransitRailroadAttribute/urf:UrbanRapidTransitRailroadAttribute/urf:structuralDetails/urf:StructureDetails",
            "./urf:urbanRoadAttribute/urf:UrbanRoadAttribute/urf:structuralDetails/urf:StructureDetails",
        ],
        attribute_groups=[
            *_COMMON_ATTRS,
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="endLocation",
                        path="./urf:endLocation",
                        datatype="string",
                    ),
                    Attribute(
                        name="length",
                        path="./urf:length",
                        datatype="double",
                    ),
                    Attribute(
                        name="startLocation",
                        path="./urf:startLocation",
                        datatype="string",
                    ),
                    Attribute(
                        name="viaLocations",
                        path="./urf:viaLocations",
                        datatype="string",
                    ),
                    Attribute(
                        name="width",
                        path="./urf:width",
                        datatype="double",
                    ),
                ],
            ),
            AttributeGroup(
                base_element="./urf:parkingPlaceAttribute/urf:ParkingPlaceAttribute",
                attributes=[
                    Attribute(
                        name="storeysAboveGround",
                        path="./urf:storeysAboveGround",
                        datatype="integer",
                    ),
                    Attribute(
                        name="storeysBelowGround",
                        path="./urf:storeysBelowGround",
                        datatype="integer",
                    ),
                ],
            ),
            AttributeGroup(
                base_element="./urf:urbanRapidTransitRailroadAttribute/urf:UrbanRapidTransitRailroadAttribute",
                attributes=[
                    Attribute(
                        name="structureType",
                        path="./urf:structureType",
                        datatype="string",
                        predefined_codelist="TrafficFacility_trafficFacilityStructureType",
                    ),
                    Attribute(
                        name="crossType",
                        path="./urf:crossType",
                        datatype="string",
                        predefined_codelist="TrafficFacility_trafficFacilityCrossingType",
                    ),
                ],
            ),
            AttributeGroup(
                base_element="./urf:urbanRoadAttribute/urf:UrbanRoadAttribute",
                attributes=[
                    Attribute(
                        name="routeTypeNumber",
                        path="./urf:routeTypeNumber",
                        datatype="string",
                        predefined_codelist="UrbanRoadAttribute_routeTypeNumber",
                    ),
                    Attribute(
                        name="routeSizeNumber",
                        path="./urf:routeSizeNumber",
                        datatype="string",
                        predefined_codelist="UrbanRoadAttribute_routeSizeNumber",
                    ),
                    Attribute(
                        name="routeSerialNumber",
                        path="./urf:routeSerialNumber",
                        datatype="string",
                    ),
                    Attribute(
                        name="roadType",
                        path="./urf:roadType",
                        datatype="string",
                        predefined_codelist="UrbanRoadAttribute_roadType",
                    ),
                    Attribute(
                        name="numberOfLanes",
                        path="./urf:numberOfLanes",
                        datatype="integer",
                    ),
                    Attribute(
                        name="roadStructure",
                        path="./urf:roadStructure",
                        datatype="string",
                    ),
                    Attribute(
                        name="structureType",
                        path="./urf:structureType",
                        datatype="string",
                        predefined_codelist="TrafficFacility_trafficFacilityStructureType",
                    ),
                    Attribute(
                        name="crossType",
                        path="./urf:crossType",
                        datatype="string",
                        predefined_codelist="TrafficFacility_trafficFacilityCrossingType",
                    ),
                    Attribute(
                        name="trafficPlazas",
                        path="./urf:trafficPlazas",
                        datatype="string",
                        predefined_codelist="Common_availabilityType",
                    ),
                ],
            ),
            AttributeGroup(
                base_element="./urf:vehicleTerminalAttribute/urf:VehicleTerminalAttribute",
                attributes=[
                    Attribute(
                        name="terminalType",
                        path="./urf:terminalType",
                        datatype="string",
                        predefined_codelist="VehicleTerminalAttribute_terminalType",
                    ),
                ],
            ),
        ],
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:OpenSpaceForPublicUse",
        name="公共空地",
        target_elements=["urf:OpenSpaceForPublicUse"],
        attribute_groups=[
            *_COMMON_ATTRS,
            AttributeGroup(
                base_element="./urf:parkAttribute/urf:ParkAttribute",
                attributes=[
                    Attribute(
                        name="parkTypeNumber",
                        path="./urf:parkTypeNumber",
                        datatype="string",
                        predefined_codelist="ParkAttribute_parkTypeNumber",
                    ),
                    Attribute(
                        name="parkSizeNumber",
                        path="./urf:parkSizeNumber",
                        datatype="string",
                        predefined_codelist="ParkAttribute_parkSizeNumber",
                    ),
                    Attribute(
                        name="parkSerialNumber",
                        path="./urf:parkSerialNumber",
                        datatype="string",
                    ),
                ],
            ),
        ],
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:SupplyFacility",
        name="供給施設",
        target_elements=["urf:SupplyFacility"],
        attribute_groups=[
            *_COMMON_ATTRS,
            AttributeGroup(
                base_element="./urf:waterWorksAttribute/urf:WaterWorksAttribute",
                attributes=[
                    Attribute(
                        name="startLocation",
                        path="./urf:startLocation",
                        datatype="string",
                    ),
                    Attribute(
                        name="endLocation",
                        path="./urf:endLocation",
                        datatype="string",
                    ),
                ],
            ),
        ],
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:TreatmentFacility",
        name="処理施設",
        target_elements=["urf:TreatmentFacility"],
        attribute_groups=[
            *_COMMON_ATTRS,
            AttributeGroup(
                base_element="./urf:sewerSystemsAttribute/urf:SewerSystemAttribute",
                attributes=[
                    Attribute(
                        name="startLocation",
                        path="./urf:startLocation",
                        datatype="string",
                    ),
                    Attribute(
                        name="endLocation",
                        path="./urf:endLocation",
                        datatype="string",
                    ),
                    Attribute(
                        name="systemType",
                        path="./urf:systemType",
                        datatype="string",
                        predefined_codelist="SewerSystemAttribute_systemType",
                    ),
                    Attribute(
                        name="drainageArea",
                        path="./urf:drainageArea",
                        datatype="string",
                    ),
                ],
            ),
        ],
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:Waterway",
        name="水路",
        target_elements=["urf:Waterway"],
        attribute_groups=[
            *_COMMON_ATTRS,
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="endLocation",
                        path="./urf:endLocation",
                        datatype="string",
                    ),
                    Attribute(
                        name="length",
                        path="./urf:length",
                        datatype="double",
                    ),
                    Attribute(
                        name="startLocation",
                        path="./urf:startLocation",
                        datatype="string",
                    ),
                    Attribute(
                        name="structure",
                        path="./urf:structure",
                        datatype="string",
                        predefined_codelist="Waterway_structure",
                    ),
                    Attribute(
                        name="width",
                        path="./urf:width",
                        datatype="double",
                    ),
                ],
            ),
        ],
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:EducationalAndCulturalFacility",
        name="教育文化施設",
        target_elements=["urf:EducationalAndCulturalFacility"],
        attribute_groups=_COMMON_ATTRS,
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:MedicalFacility",
        name="医療施設",
        target_elements=["urf:MedicalFacility"],
        attribute_groups=_COMMON_ATTRS,
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:SocialWelfareFacility",
        name="社会福祉施設",
        target_elements=["urf:SocialWelfareFacility"],
        attribute_groups=_COMMON_ATTRS,
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:MarketsSlaughterhousesCrematoria",
        name="市場、と畜場、火葬場",
        target_elements=["urf:MarketsSlaughterhousesCrematoria"],
        attribute_groups=_COMMON_ATTRS,
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:CollectiveHousingFacilities",
        name="一団地の住宅施設",
        target_elements=["urf:CollectiveHousingFacilities"],
        attribute_groups=[
            *_COMMON_ATTRS,
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="buildingCoverageRate",
                        path="./urf:buildingCoverageRate",
                        datatype="double",
                    ),
                    Attribute(
                        name="floorAreaRate",
                        path="./urf:floorAreaRate",
                        datatype="double",
                    ),
                    Attribute(
                        name="numberOfHighRiseHousing",
                        path="./urf:numberOfHighRiseHousing",
                        datatype="integer",
                    ),
                    Attribute(
                        name="numberOfLowRiseHousing",
                        path="./urf:numberOfLowRiseHousing",
                        datatype="integer",
                    ),
                    Attribute(
                        name="numberOfMiddleRiseHousing",
                        path="./urf:numberOfMiddleRiseHousing",
                        datatype="integer",
                    ),
                    Attribute(
                        name="publicFacilitiesAllocationPolicy",
                        path="./urf:publicFacilitiesAllocationPolicy",
                        datatype="string",
                    ),
                    Attribute(
                        name="scheduledExecutor",
                        path="./urf:scheduledExecutor",
                        datatype="string",
                    ),
                    Attribute(
                        name="totalNumberOfHousing",
                        path="./urf:totalNumberOfHousing",
                        datatype="integer",
                    ),
                ],
            ),
        ],
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:CollectiveGovernmentAndPublicOfficeFacilities",
        name="一団地の官公庁施設",
        target_elements=["urf:CollectiveGovernmentAndPublicOfficeFacilities"],
        attribute_groups=[
            *_COMMON_ATTRS,
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="buildingCoverageRate",
                        path="./urf:buildingCoverageRate",
                        datatype="double",
                    ),
                    Attribute(
                        name="floorAreaRate",
                        path="./urf:floorAreaRate",
                        datatype="double",
                    ),
                    Attribute(
                        name="publicFacilitiesAllocationPolicy",
                        path="./urf:publicFacilitiesAllocationPolicy",
                        datatype="string",
                    ),
                    Attribute(
                        name="scheduledExecutor",
                        path="./urf:scheduledExecutor",
                        datatype="string",
                    ),
                ],
            ),
        ],
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:DistributionBusinessPark",
        name="流通業務団地",
        target_elements=["urf:DistributionBusinessPark"],
        attribute_groups=[
            *_COMMON_ATTRS,
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="buildingCoverageRate",
                        path="./urf:buildingCoverageRate",
                        datatype="double",
                    ),
                    Attribute(
                        name="distributionBusinessPark",
                        path="./urf:distributionBusinessPark",
                        datatype="string",
                    ),
                    Attribute(
                        name="floorAreaRate",
                        path="./urf:floorAreaRate",
                        datatype="double",
                    ),
                    Attribute(
                        name="maximumBuildingHeight",
                        path="./urf:maximumBuildingHeight",
                        datatype="double",
                    ),
                    Attribute(
                        name="minimumBuildingHeight",
                        path="./urf:minimumBuildingHeight",
                        datatype="double",
                    ),
                    Attribute(
                        name="publicAndUtilityFacilities",
                        path="./urf:publicAndUtilityFacilities",
                        datatype="string",
                    ),
                    Attribute(
                        name="scheduledExecutor",
                        path="./urf:scheduledExecutor",
                        datatype="string",
                    ),
                    Attribute(
                        name="setbackSize",
                        path="./urf:setbackSize",
                        datatype="string",
                    ),
                ],
            ),
        ],
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:CollectiveFacilitiesForTsunamiDisasterPrevention",
        name="一団地の津波防災拠点市街地形成施設",
        target_elements=["urf:CollectiveFacilitiesForTsunamiDisasterPrevention"],
        attribute_groups=[
            *_COMMON_ATTRS,
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="housingFacilities",
                        path="./urf:housingFacilities",
                        datatype="string",
                    ),
                    Attribute(
                        name="maximumBuildingCoverageRate",
                        path="./urf:maximumBuildingCoverageRate",
                        datatype="double",
                    ),
                    Attribute(
                        name="maximumBuildingHeight",
                        path="./urf:maximumBuildingHeight",
                        datatype="double",
                    ),
                    Attribute(
                        name="maximumFloorAreaRate",
                        path="./urf:maximumFloorAreaRate",
                        datatype="double",
                    ),
                    Attribute(
                        name="minimumBuildingHeight",
                        path="./urf:minimumBuildingHeight",
                        datatype="double",
                    ),
                    Attribute(
                        name="minimumFloorAreaRate",
                        path="./urf:minimumFloorAreaRate",
                        datatype="double",
                    ),
                    Attribute(
                        name="publicFacilities",
                        path="./urf:publicFacilities",
                        datatype="string",
                    ),
                    Attribute(
                        name="supecificBusinessFacilities",
                        path="./urf:supecificBusinessFacilities",
                        datatype="string",
                    ),
                    Attribute(
                        name="utilityFacilities",
                        path="./urf:utilityFacilities",
                        datatype="string",
                    ),
                ],
            ),
        ],
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:CollectiveFacilitiesForReconstructionAndRevitalization",
        name="一団地の復興再生拠点市街地形成施設",
        target_elements=["urf:CollectiveFacilitiesForReconstructionAndRevitalization"],
        attribute_groups=[
            *_COMMON_ATTRS,
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="housingFacilities",
                        path="./urf:housingFacilities",
                        datatype="string",
                    ),
                    Attribute(
                        name="maximumBuildingCoverageRate",
                        path="./urf:maximumBuildingCoverageRate",
                        datatype="double",
                    ),
                    Attribute(
                        name="maximumBuildingHeight",
                        path="./urf:maximumBuildingHeight",
                        datatype="double",
                    ),
                    Attribute(
                        name="maximumFloorAreaRate",
                        path="./urf:maximumFloorAreaRate",
                        datatype="double",
                    ),
                    Attribute(
                        name="minimumBuildingHeight",
                        path="./urf:minimumBuildingHeight",
                        datatype="double",
                    ),
                    Attribute(
                        name="minimumFloorAreaRate",
                        path="./urf:minimumFloorAreaRate",
                        datatype="double",
                    ),
                    Attribute(
                        name="publicFacilities",
                        path="./urf:publicFacilities",
                        datatype="string",
                    ),
                    Attribute(
                        name="supecificBusinessFacilities",
                        path="./urf:supecificBusinessFacilities",
                        datatype="string",
                    ),
                    Attribute(
                        name="utilityFacilities",
                        path="./urf:utilityFacilities",
                        datatype="string",
                    ),
                ],
            ),
        ],
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:CollectiveFacilitiesForReconstruction",
        name="一団地の復興拠点市街地形成施設",
        target_elements=["urf:CollectiveFacilitiesForReconstruction"],
        attribute_groups=[
            *_COMMON_ATTRS,
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="housingFacilities",
                        path="./urf:housingFacilities",
                        datatype="string",
                    ),
                    Attribute(
                        name="maximumBuildingCoverageRate",
                        path="./urf:maximumBuildingCoverageRate",
                        datatype="double",
                    ),
                    Attribute(
                        name="maximumBuildingHeight",
                        path="./urf:maximumBuildingHeight",
                        datatype="double",
                    ),
                    Attribute(
                        name="maximumFloorAreaRate",
                        path="./urf:maximumFloorAreaRate",
                        datatype="double",
                    ),
                    Attribute(
                        name="minimumBuildingHeight",
                        path="./urf:minimumBuildingHeight",
                        datatype="double",
                    ),
                    Attribute(
                        name="minimumFloorAreaRate",
                        path="./urf:minimumFloorAreaRate",
                        datatype="double",
                    ),
                    Attribute(
                        name="publicFacilities",
                        path="./urf:publicFacilities",
                        datatype="string",
                    ),
                    Attribute(
                        name="supecificBusinessFacilities",
                        path="./urf:supecificBusinessFacilities",
                        datatype="string",
                    ),
                    Attribute(
                        name="utilityFacilities",
                        path="./urf:utilityFacilities",
                        datatype="string",
                    ),
                ],
            ),
        ],
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:CollectiveUrbanDisasterPreventionFacilities",
        name="一団地の都市安全確保拠点施設",
        target_elements=["urf:CollectiveUrbanDisasterPreventionFacilities"],
        attribute_groups=[
            *_COMMON_ATTRS,
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="maximumBuildingCoverageRate",
                        path="./urf:maximumBuildingCoverageRate",
                        datatype="double",
                    ),
                    Attribute(
                        name="maximumBuildingHeight",
                        path="./urf:maximumBuildingHeight",
                        datatype="double",
                    ),
                    Attribute(
                        name="maximumFloorAreaRate",
                        path="./urf:maximumFloorAreaRate",
                        datatype="double",
                    ),
                    Attribute(
                        name="minimumBuildingHeight",
                        path="./urf:minimumBuildingHeight",
                        datatype="double",
                    ),
                    Attribute(
                        name="minimumFloorAreaRate",
                        path="./urf:minimumFloorAreaRate",
                        datatype="double",
                    ),
                    Attribute(
                        name="specificUtilityAndPublicFacilities",
                        path="./urf:specificUtilityAndPublicFacilities",
                        datatype="string",
                    ),
                ],
            ),
        ],
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:UrbanFacilityStipulatedByCabinetOrder",
        name="政令で定める都市施設",
        target_elements=["urf:UrbanFacilityStipulatedByCabinetOrder"],
        attribute_groups=_STIPULATED_ATTRS,
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:TelecommunicationFacility",
        name="電気通信施設",
        target_elements=["urf:TelecommunicationFacility"],
        attribute_groups=_STIPULATED_ATTRS,
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:WindProtectionFacility",
        name="防風施設",
        target_elements=["urf:WindProtectionFacility"],
        attribute_groups=_STIPULATED_ATTRS,
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:FireProtectionFacility",
        name="防火施設",
        target_elements=["urf:FireProtectionFacility"],
        attribute_groups=_STIPULATED_ATTRS,
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:TideFacility",
        name="防潮施設",
        target_elements=["urf:TideFacility"],
        attribute_groups=_STIPULATED_ATTRS,
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:FloodPreventionFacility",
        name="防水施設",
        target_elements=["urf:FloodPreventionFacility"],
        attribute_groups=_STIPULATED_ATTRS,
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:SnowProtectionFacility",
        name="防雪施設",
        target_elements=["urf:SnowProtectionFacility"],
        attribute_groups=_STIPULATED_ATTRS,
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:SandControlFacility",
        name="防砂施設",
        target_elements=["urf:SandControlFacility"],
        attribute_groups=_STIPULATED_ATTRS,
        geometries=_COMMON_GEOMETRIES,
    ),
]
