from ..base import (
    Attribute,
    AttributeGroup,
    FeatureProcessingDefinition,
    GeometricAttribute,
    GeometricAttributes,
)
from .common import ZONE_ATTRIBUTES

_COMMON_ATTRS = [
    AttributeGroup(
        base_element=None,
        attributes=[
            Attribute(
                name="function",
                path="./urf:function",
                datatype="[]string",
                predefined_codelist="UrbanDevelopmentProject_function",
            ),
        ],
    ),
    *ZONE_ATTRIBUTES,
    AttributeGroup(
        base_element=None,
        attributes=[
            Attribute(
                name="scheduledExecutor",
                path="./urf:scheduledExecutor",
                datatype="string",
            ),
        ],
    ),
]

_COMMON_GEOMETRIES = GeometricAttributes(
    lod1=GeometricAttribute(
        is2d=True,
        lod_detection=["./urf:lod1MultiSurface", "./urf:lod0MultiSurface"],
        collect_all=[
            "./urf:lod1MultiSurface//gml:Polygon",
            "./urf:lod0MultiSurface//gml:Polygon",
        ],
    ),
)

DEFS = [
    FeatureProcessingDefinition(
        id="urf:UrbanDevelopmentProject",
        name="市街地開発事業",
        target_elements=["urf:UrbanDevelopmentProject"],
        attribute_groups=[
            *_COMMON_ATTRS,
        ],
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:LandReadjustmentProject",
        name="土地区画整理事業",
        target_elements=["urf:LandReadjustmentProject"],
        attribute_groups=[
            *_COMMON_ATTRS,
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="buildingLotDevelopment",
                        path="./urf:buildingLotDevelopment",
                        datatype="string",
                    ),
                    Attribute(
                        name="publicFacilityAllocation",
                        path="./urf:publicFacilityAllocation",
                        datatype="string",
                    ),
                ],
            ),
        ],
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:NewHousingAndUrbanDevelopmentProject",
        name="新住宅市街地開発事業",
        target_elements=["urf:NewHousingAndUrbanDevelopmentProject"],
        attribute_groups=[
            *_COMMON_ATTRS,
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="housing",
                        path="./urf:housing",
                        datatype="string",
                    ),
                    Attribute(
                        name="publicFacilityAllocation",
                        path="./urf:publicFacilityAllocation",
                        datatype="string",
                    ),
                    Attribute(
                        name="residentialLandUsePlan",
                        path="./urf:residentialLandUsePlan",
                        datatype="string",
                    ),
                ],
            ),
        ],
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:IndustrialParkDevelopmentProject",
        name="工業団地造成事業",
        target_elements=["urf:IndustrialParkDevelopmentProject"],
        attribute_groups=[
            *_COMMON_ATTRS,
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="publicFacilityAllocation",
                        path="./urf:publicFacilityAllocation",
                        datatype="string",
                    ),
                    Attribute(
                        name="residentialLandUsePlan",
                        path="./urf:residentialLandUsePlan",
                        datatype="string",
                    ),
                ],
            ),
        ],
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:UrbanRedevelopmentProject",
        name="市街地再開発事業",
        target_elements=["urf:UrbanRedevelopmentProject"],
        attribute_groups=[
            *_COMMON_ATTRS,
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="usage",
                        path="./urf:usage",
                        datatype="string",
                        predefined_codelist="UrbanRedevelopmentProject_usage",
                    ),
                    Attribute(
                        name="developmentPlan",
                        path="./urf:developmentPlan",
                        datatype="string",
                    ),
                    Attribute(
                        name="housingTarget",
                        path="./urf:housingTarget",
                        datatype="string",
                    ),
                    Attribute(
                        name="numberOfHousing",
                        path="./urf:numberOfHousing",
                        datatype="integer",
                    ),
                    Attribute(
                        name="publicFacilityAllocation",
                        path="./urf:publicFacilityAllocation",
                        datatype="string",
                    ),
                    Attribute(
                        name="siteArea",
                        path="./urf:siteArea",
                        datatype="double",
                    ),
                    Attribute(
                        name="totalFloorArea",
                        path="./urf:totalFloorArea",
                        datatype="double",
                    ),
                ],
            ),
        ],
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:NewUrbanInfrastructureProject",
        name="新都市基盤整備事業",
        target_elements=["urf:NewUrbanInfrastructureProject"],
        attribute_groups=[
            *_COMMON_ATTRS,
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="districtsAllocation",
                        path="./urf:districtsAllocation",
                        datatype="string",
                    ),
                    Attribute(
                        name="landForCentralPublicFacilities",
                        path="./urf:landForCentralPublicFacilities",
                        datatype="string",
                    ),
                    Attribute(
                        name="landUsePlan",
                        path="./urf:landUsePlan",
                        datatype="string",
                    ),
                ],
            ),
        ],
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:ResidentialBlockConstructionProject",
        name="住宅街区整備事業",
        target_elements=["urf:ResidentialBlockConstructionProject"],
        attribute_groups=[
            *_COMMON_ATTRS,
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="developmentPlan",
                        path="./urf:developmentPlan",
                        datatype="string",
                    ),
                    Attribute(
                        name="publicFacilityAllocation",
                        path="./urf:publicFacilityAllocation",
                        datatype="string",
                    ),
                    Attribute(
                        name="siteArea",
                        path="./urf:siteArea",
                        datatype="double",
                    ),
                    Attribute(
                        name="totalFloorArea",
                        path="./urf:totalFloorArea",
                        datatype="double",
                    ),
                ],
            ),
        ],
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:DisasterPreventionBlockImprovementProject",
        name="防災街区整備事業",
        target_elements=["urf:DisasterPreventionBlockImprovementProject"],
        attribute_groups=[
            *_COMMON_ATTRS,
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="developmentPlan",
                        path="./urf:developmentPlan",
                        datatype="string",
                    ),
                    Attribute(
                        name="disasterPreventionPublicFacilityAllocation",
                        path="./urf:disasterPreventionPublicFacilityAllocation",
                        datatype="string",
                    ),
                    Attribute(
                        name="otherPublicFacilityAllocation",
                        path="./urf:otherPublicFacilityAllocation",
                        datatype="string",
                    ),
                ],
            ),
        ],
        geometries=_COMMON_GEOMETRIES,
    ),
    FeatureProcessingDefinition(
        id="urf:UrbanRenewalProject",
        name="市街地改造事業",
        target_elements=["urf:UrbanRenewalProject"],
        attribute_groups=[
            *_COMMON_ATTRS,
            AttributeGroup(
                base_element=None,
                attributes=[
                    Attribute(
                        name="buildingUsage",
                        path="./urf:buildingUsage",
                        datatype="string",
                    ),
                    Attribute(
                        name="floorAreaRate",
                        path="./urf:floorAreaRate",
                        datatype="double",
                    ),
                    Attribute(
                        name="setbackSize",
                        path="./urf:setbackSize",
                        datatype="string",
                    ),
                    Attribute(
                        name="siteArea",
                        path="./urf:siteArea",
                        datatype="double",
                    ),
                    Attribute(
                        name="storeysAboveGround",
                        path="./urf:storeysAboveGround",
                        datatype="integer",
                    ),
                    Attribute(
                        name="storeysBelowGround",
                        path="./urf:storeysBelowGround",
                        datatype="integer",
                    ),
                ],
            ),
        ],
        geometries=_COMMON_GEOMETRIES,
    ),
]
