# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PlacesSearchDialog
                                 A QGIS plugin
 Fetch places data from Google Maps API and save to Shapefile.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-03-02
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Yanni Wang
        email                : yanni.wang2000@outlook.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt5.QtWidgets import QDialog
from .places_search_dialog_base import Ui_PlacesSearchDialogBase
from qgis.core import QgsProject, QgsMapLayer
from qgis.PyQt.QtWidgets import QDialog, QFileDialog

class PlacesSearchDialog(QDialog, Ui_PlacesSearchDialogBase):
    def __init__(self):
        """Initialize the dialog."""
        super().__init__()
        self.setupUi(self)
        self.populate_layers()
        self.search_button.clicked.connect(self.accept)
        self.browse_button.clicked.connect(self.select_output_path)

    def populate_layers(self):
        """Refresh the combo box with available vector polygon layers."""
        self.polygon_layer_combo.clear()
        layers = QgsProject.instance().mapLayers().values()

        for layer in layers:
            if isinstance(layer, QgsMapLayer) and layer.type() == QgsMapLayer.VectorLayer:
                if layer.geometryType() == 2:  # Ensure it's a polygon layer
                    self.polygon_layer_combo.addItem(layer.name(), layer)

    def showEvent(self, event):
        """Refresh layer list every time the dialog is opened."""
        self.populate_layers()
        super().showEvent(event)

    def select_output_path(self):
        """Open file dialog to select the output shapefile path."""
        output_path, _ = QFileDialog.getSaveFileName(None, "Save Shapefile", "", "Shapefile (*.shp)")
        if output_path:
            self.output_path_input.setText(output_path)

    def get_inputs(self):
        """Retrieve user inputs from the dialog."""
        api_key = self.api_key_input.text().strip()
        keywords = [k.strip() for k in self.keyword_input.text().split(",")]
        layer_index = self.polygon_layer_combo.currentIndex()
        polygon_layer = self.polygon_layer_combo.itemData(layer_index)
        output_path = self.output_path_input.text().strip()
        
        return api_key, keywords, polygon_layer, output_path
