# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SearchForPlaceDialog
                                 A QGIS plugin
 Uses web APIs to find a place and zoom to it.
                             -------------------
        begin                : 2013-02-14
        copyright            : (C) 2013 by Augustin Roche
        email                : augustin.roche@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt4 import QtCore, QtGui
from ui_placefinder import Ui_PlaceFinder
from placefinder_utils import *

from qgis.core import *
from qgis.gui import *

# create the dialog for zoom to point




class PlaceFinderDialog(QtGui.QDialog):
    def __init__(self, iface):
        QtGui.QDialog.__init__(self)
        # Set up the user interface from Designer.
        self.iface = iface
        self.ui = Ui_PlaceFinder()
        self.ui.setupUi(self)
        
        QtCore.QObject.connect(self.ui.searchButton, QtCore.SIGNAL("clicked()"), self.onSearchButton)
        QtCore.QObject.connect(self.ui.buttonBox, QtCore.SIGNAL("accepted()"), self.zoomToSelection)
        
        self.ui.searchField.setFocus()
        
    def onSearchButton(self):
        search = self.ui.searchField.text()
        if not search:
            return
            
        cursor = self.cursor()
        self.setCursor(QtCore.Qt.WaitCursor)        
        if self.ui.selectNominatim.isChecked():
            service = NominatimGeoService()
        if self.ui.selectGeonames.isChecked():
            service = GeoNamesGeoService()
        service.query(search)
        self.candidates = service.results
        
        self.ui.licenseText.setText(service.copyright)
        
        model = QtGui.QStandardItemModel()
        model.setColumnCount(2)
        model.setHeaderData(0, QtCore.Qt.Horizontal, 'Place')
        model.setHeaderData(1, QtCore.Qt.Horizontal, 'BBOX')
        for li in service.results:
            model.appendRow((QtGui.QStandardItem(li.title), QtGui.QStandardItem(li.strBBox())))
        self.ui.resultList.setModel(model)
        self.ui.resultList.resizeColumnToContents(0)
        self.ui.resultList.resizeColumnToContents(1)
        self.setCursor(cursor)
        
    def zoomToSelection(self):
        indexes = self.ui.resultList.selectedIndexes()
        if len(indexes) == 0: return
        i = indexes[0]
        selectedPlace = self.candidates[i.row()]
        p = QgsProject.instance()
        (proj4string, ok) = p.readEntry("SpatialRefSys","ProjectCRSProj4String")
        if not ok:
            bbox = selectedPlace.bbox
        else:
            bbox = selectedPlace.transformBBox(proj4string)
        canvas = self.iface.mapCanvas()
        canvas.setExtent(bbox)
        canvas.refresh()
        
        self.hide()
        
        
