# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SearchForPlaceUtil
                                 A QGIS plugin
 Uses web APIs to find a place and zoom to it.
                             -------------------
        begin                : 2013-02-14
        copyright            : (C) 2013 by Augustin Roche
        email                : augustin.roche@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

# Utilities for consulting geocoding services

import urllib, urllib2, json
from qgis.core import *

import pdb


class Place:
    """
        A place returned by services
    """
    def __init__(self, desc, bbox, center=None):
        self.title = desc
        bbox = [float(i) for i in bbox]
        self.bbox = QgsRectangle(bbox[0], bbox[1], bbox[2], bbox[3])
        if center:
            self.center = [float(i) for i in center]
        if not center and bbox:
            x = float(bbox[2]-bbox[0])/2
            y = float(bbox[3]-bbox[1])/2
            self.center = (x, y)
    
    def strBBox(self):
        return "%.3f %.3f %.3f %.3f" % (
            self.bbox.xMinimum(),
            self.bbox.yMinimum(),
            self.bbox.xMaximum(),
            self.bbox.yMaximum())
        
    def transformBBox(self, srs):
        """ returns a transformed BBox """
        crsSrc = QgsCoordinateReferenceSystem(4326)
        crsTarget=QgsCoordinateReferenceSystem()
        crsTarget.createFromProj4(srs)
        transformer = QgsCoordinateTransform(crsSrc, crsTarget)
        bbox = transformer.transform(self.bbox)
        return bbox
        
    

class GeoService:
    """
        Abstract class for gocoding services
    """
    result_limit = 10
    
    def __init__(self):
        self.method = 'GET'
        self.results = []
        
        
    def download(self, params):
        if self.method == 'GET':
            try:
                res = urllib2.urlopen(self.base_url + '?' + urllib.urlencode(params))
            except:
                print 'Network failure'
                return
        
        try:
            result = json.load(res)
        except:
            print 'Could not parse result: '
            return
            
        return result
        

    
class NominatimGeoService(GeoService):
    copyright = 'Data provided by <a href="http://openstreetmap.org">OpenStreetMap</a>.' \
        + '<br /><a href="http://www.openstreetmap.org/copyright">\xa9 OpenStreetMap contributors</a>'
        
    def __init__(self):
        GeoService.__init__(self)
        self.base_url = "http://nominatim.openstreetmap.org/search"
        
    def query(self, search):
        params = {'q': search, 'format': 'json', 'limit': self.result_limit}
        data = self.download(params)

        self.results = []
        for li in data:
            bbox = [li['boundingbox'][i] for i in (2, 0, 3, 1)]
            self.results.append(Place(
                li['display_name'],
                bbox,
                (li['lat'], li['lon'])))
        

class GeoNamesGeoService(GeoService):
    userName = 'a3x'
    copyright = 'Data provided by <a href="http://www.geonames.org">GeoNames</a>' \
        + 'License CC-BY.'
    
    def __init__(self):
        GeoService.__init__(self)
        self.base_url = "http://api.geonames.org/searchJSON"
        
    def query(self, search):
        params = { 
            'q': search, 
            'maxRows': self.result_limit,
            'orderby': 'relevance',
            'isNameRequired': 'true',
            'style': 'FULL',
            'username': self.userName
        }
        data = self.download(params)
        #pdb.set_trace()
        self.results = []
        for li in data['geonames']:
            title = li['name'] + ', ' + li['adminName1'] + ', ' + li['countryName'] \
                + ', ' + li['adminName2'] + ' (' + li['fcodeName'] + ')'
            center = (li['lng'], li['lat'])
            if 'bbox' in li:
                bbox = li['bbox']
                bbox = [bbox[i] for i in ('west', 'south', 'east', 'north')]
            else:
                # TODO: better process for bbox
                bbox = (
                    float(center[0])-.05,
                    float(center[1])-.05,
                    float(center[0])+.05,
                    float(center[1])+.05
                )
            self.results.append(Place(title, bbox, center))
            