"""
/***************************************************************************
 PinPoint
                                 A QGIS plugin
 Place a pin with label on the map
                              -------------------
        begin                : 2011-10-29
        copyright            : (C) 2013 by GeoApt LLC
        email                : gsherman@geoapt.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import * #g
# Initialize Qt resources from file resources.py
import resources
# Import the code for the dialog
from pinpointdialog import PinPointDialog

class PinPoint:

    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface
        #g reference to the canvas
        self.canvas = self.iface.mapCanvas()

        #g pin tool
        self.pinTool = QgsMapToolEmitPoint(self.canvas)

        #g boolean for memory layer state
        self.have_layer = False

    def initGui(self):
        # Create action that will start plugin configuration
        self.action = QAction(QIcon(":/plugins/pinpoint/pinpoint.png"), \
            "Place a Pin...", self.iface.mainWindow())
        # connect the action to the run method
        QObject.connect(self.action, SIGNAL("triggered()"), self.run)
        # connect signal that the canvas was clicked
        result = QObject.connect(self.pinTool, SIGNAL("canvasClicked(const QgsPoint &, Qt::MouseButton)"), self.place_pin)
        #QMessageBox.information( self.iface.mainWindow(),"Info", "connect = %s"%str(result) )

        # Add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu("&Place a Pin...", self.action)

        # set the default pin label
        self.last_desc = 'My Pin'

    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu("&Place a Pin...",self.action)
        self.iface.removeToolBarIcon(self.action)

    # get the x,y and create the pin
    def place_pin(self, point, button):
        # user might remove the layer so we have to check each time
        # to see if it exists
        if self.have_layer == False:
            #QMessageBox.information(self.iface.mainWindow(),"Memory Provider", "No provider yet")
            self.create_pin_layer()

        
        ok = False

        (desc,ok) = QInputDialog.getText(
                self.iface.mainWindow(), 
                "Description",
                "Description for pin at %.2f, %.2f" % (float(str(point.x())),float(str(point.y()))), 
                QLineEdit.Normal,
                self.last_desc)

        if(ok):
            self.last_desc = desc

           
            fc = int(self.provider.featureCount())
            #QMessageBox.information( self.iface.mainWindow(),"Feature Count", str(fc)) #"X,Y = %s,%s" % (str(point.x()),str(point.y())) )
            # create the feature
            feature = QgsFeature()
            feature.setGeometry(QgsGeometry.fromPoint(point))
            if QGis.QGIS_VERSION_INT > 10800:
                feature.setAttributes([fc, desc, point.x(), point.y()])
                self.pinLayer.startEditing()
                self.pinLayer.addFeature(feature, True)
                self.pinLayer.commitChanges()
            else:
                feature.setAttributeMap( {0 : QVariant(fc), 
                    1 : QVariant(desc),
                    2 : QVariant(point.x()),
                    3 : QVariant(point.y())})
                self.provider.addFeatures([feature])
                self.pinLayer.updateExtents()
            #QMessageBox.information(self.iface.mainWindow(), "Feature/field count", "%s / %s" % (str(self.provider.featureCount()), str(self.provider.fieldCount())))
            #self.pinLayer.reload()
            self.pinLayer.setCacheImage(None)
            self.pinLayer.triggerRepaint()

            #self.canvas.refresh()

    # run method that performs all the real work
    def run(self):
        # Check to see if the memory layer has been created and if not,
        # create it
        if self.have_layer == False:
            #QMessageBox.information(self.iface.mainWindow(),"Memory Provider", "No provider yet")
            self.create_pin_layer()
        # set the map tool
        self.canvas.setMapTool(self.pinTool)

        # create and show the dialog
        #dlg = PinPointDialog()
        # show the dialog
        #dlg.show()
        #result = dlg.exec_()
        # See if OK was pressed
        #if result == 1:
            # do something useful (delete the line containing pass and
            # substitute with your code
        #    pass
    def create_pin_layer(self):
      self.pinLayer =  QgsVectorLayer("Point", "Pins", "memory")
      self.provider = self.pinLayer.dataProvider()
      if QGis.QGIS_VERSION_INT > 10800:
          self.pinLayer.startEditing()
      self.provider.addAttributes ([
          QgsField("id", QVariant.Int), 
          QgsField("description", QVariant.String),
          QgsField("x", QVariant.Double),
          QgsField("y", QVariant.Double)
          ])
      if QGis.QGIS_VERSION_INT < 10900:
          self.pinLayer.updateFieldMap()
      self.pinLayer.setDisplayField("description")
      if QGis.QGIS_VERSION_INT > 10800:
          self.pinLayer.commitChanges()
      self.provider.createSpatialIndex()
      QgsMapLayerRegistry.instance().addMapLayer(self.pinLayer)
      result = QObject.connect(self.pinLayer, SIGNAL("layerDeleted()"), self.layer_deleted)
      self.have_layer = True

    def layer_deleted(self):
      self.have_layer = False
