# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PlaceImageByCoordinatesDialog
                                 A QGIS plugin
 This plugin places images by coordinates
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-10-23
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Kouki Kitajima
        email                : kitajima@wisc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from PyQt5 import uic
from PyQt5 import QtWidgets

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(os.path.dirname(__file__), 'pibc_dialog_base.ui'))


class PlaceImageByCoordinatesDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(PlaceImageByCoordinatesDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.connect_ui()
        self.res_values = {}
        self.Btn_Box.button(self.Btn_Box.Ok).setEnabled(False)

    def set_instruments(self, instruments):
        self.Cmb_Instrument.clear()
        self.Cmb_Instrument.addItems(map(lambda x: x.replace('_', ' '), reversed(instruments)))

    def connect_ui(self):
        """Connect UI controls to actions"""
        self.Btn_Select_Image_Dir.clicked.connect(self.select_image_dir)
        self.Btn_Select_Meta_Dir.clicked.connect(self.select_meta_dir)
        self.Txt_Meta_Dir.textChanged.connect(self.update_button_status)
        self.Txt_Image_Dir.textChanged.connect(self.update_button_status)

    def select_image_dir(self):
        img_dir = QtWidgets.QFileDialog.getExistingDirectory(self,
                                                             "Open Image Directory",
                                                             "~/Desktop",
                                                             QtWidgets.QFileDialog.ShowDirsOnly)
        self.Txt_Image_Dir.setText(img_dir)
        if self.Txt_Meta_Dir.text() == "":
            self.Txt_Meta_Dir.setText(img_dir)

    def select_meta_dir(self):
        meta_dir = QtWidgets.QFileDialog.getExistingDirectory(self,
                                                              "Open Meta File Directory",
                                                              "~/Desktop",
                                                              QtWidgets.QFileDialog.ShowDirsOnly)
        self.Txt_Meta_Dir.setText(meta_dir)

    def update_button_status(self):
        status = bool(self.Txt_Image_Dir.text() and self.Txt_Meta_Dir.text())
        self.Btn_Box.button(self.Btn_Box.Ok).setEnabled(status)

    def get_import_style(self):
        if self.Rdo_Multi_Layers.isChecked():
            return 'multi'
        elif self.Rdo_Virtual_Layer.isChecked():
            return 'virtual'
        else:
            return 'others'

    def accept(self):
        self.res_values = {
            'instrument': self.Cmb_Instrument.currentText().replace(' ', '_'),
            'shiftposition': self.Cbx_To_The_Center.isChecked(),
            'import': self.get_import_style(),
            'image': self.Txt_Image_Dir.text(),
            'meta': self.Txt_Meta_Dir.text()
        }
        self.done(1)
