# coding=utf-8
"""WorldFileTool test.

.. note:: This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

"""
try:
    import unittest2 as unittest
except ImportError:
    import unittest

import sys
import os
sys.path.append(os.path.join(os.path.dirname(__file__), '..'))
from worldFileTool import WorldFileTool


class WorldFileToolTest (unittest.TestCase):
    """Test for worldFileTool."""

    def setUp(self):
        """Run before each test."""
        self.wft = WorldFileTool()
        pass

    def tearDown(self):
        """Run after each test."""
        pass

    def test_get_extension(self):
        """Run tests to get world file extensions."""
        self.assertEqual("tfw", self.wft.get_extension("tif"))
        self.assertEqual("jgw", self.wft.get_extension("jpg"))
        self.assertEqual("extensionw", self.wft.get_extension("extension"))
        self.assertEqual("exw", self.wft.get_extension("ex"))
        self.assertEqual("w", self.wft.get_extension(""))

    def test_get_path(self):
        """Run test to get world file path."""
        self.assertEqual("/path/to/worldfile/image.jgw",
                         self.wft.get_path("/path/to/worldfile/image.jpg"))

    def test_rotate_coordinates(self):
        """Run tests rotate coordinates."""
        self.assertEqual([1.0, 0.0], self.wft.rotate_coordinates(0, 1, 90))
        self.assertEqual([0.0, -1.0], self.wft.rotate_coordinates(1, 0, 90))
        self.assertEqual([-1.0, 0.0], self.wft.rotate_coordinates(0, 1, -90))
        self.assertEqual([0.0, 1.0], self.wft.rotate_coordinates(1, 0, -90))
        self.assertEqual([0.70711, 0.70711],
                         map(lambda x: float("{0:.5f}".format(x)),
                             self.wft.rotate_coordinates(0, 1, 45)))
        self.assertEqual([0.70711, 0.70711],
                         map(lambda x: float("{0:.5f}".format(x)),
                             self.wft.rotate_coordinates(1, 0, -45)))

if __name__ == '__main__':
    suite = unittest.TestLoader().loadTestsFromTestCase(WorldFileToolTest)
    unittest.TextTestRunner(verbosity=2).run(suite)
