# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PianExporterDialog
                                 A QGIS plugin
 Plugin exportuje vrstvu do formátu pro pian
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-09-26
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Marek Lečbych
        email                : lecbych@uapp.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.core import QgsProject


# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'pian_exporter_dialog_base.ui'))


class PianExporterDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, iface, parent=None):
        """Constructor."""
        super(PianExporterDialog, self).__init__(parent)
        self.iface = iface
        self.setupUi(self)

        # Naplnit seznam vrstev při otevření dialogu
        self.populate_layers()

    def populate_layers(self):
        """Naplní combobox seznamem vrstev a předvybere aktivní."""
        # vyčistit combobox
        self.layerComboBox.clear()

        # Všechny vrstvy z projektu
        layers = QgsProject.instance().mapLayers().values()
        for layer in layers:
            if layer.type() == 0:  # 0 = vector layer
                self.layerComboBox.addItem(layer.name(), layer.id())

        # Vyber aktuální aktivní vrstvu
        active_layer = self.iface.activeLayer()
        if active_layer:
            index = self.layerComboBox.findData(active_layer.id())
            if index != -1:
                self.layerComboBox.setCurrentIndex(index)
