
 SELECT row_number() OVER () AS rownum,
    to_timestamp((v1.systime / 1000)::double precision) AS start_time,
    to_timestamp((v2.systime / 1000)::double precision) AS end_time,
    v1.id,
    v1.version_log_id,
	v2.version_log_id,
    v1.action,
	v2.action,
	v1.revision,
	v2.revision
  FROM versions.public_trassenachse_version_log v1
     LEFT JOIN versions.public_trassenachse_version_log v2 ON v2.id = v1.id AND v2.action::text = 'delete'::text and v1.revision <> v2.revision
  WHERE v1.action::text = 'insert'::text or v1.action::text = 'update'