# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PgSchemaImporterDialog
                                 A QGIS plugin
 Importa all Tables; Relation
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2026-01-28
        git sha              : $Format:%H$
        copyright            : (C) 2026 by Tobias Heini
        email                : tobias.heini@opengis.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.core import QgsSettings
from qgis.core import QgsDataSourceUri, QgsProviderRegistry

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'pg_schema_importer_dialog_base.ui'))


class PgSchemaImporterDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(PgSchemaImporterDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.ConComboBox.currentIndexChanged.connect(self.update_pg_schemas)
 
        
        # Load PostgreSQL connections after UI is set up
        self.load_pg_connections()

    def load_pg_connections(self):
        # Zugriff auf die QGIS-Einstellungen
        settings = QgsSettings()
        
        # Pfad zu den PostGIS-Verbindungen
        settings.beginGroup("/PostgreSQL/connections")
        
        # Alle Verbindungsnamen (Keys) abrufen
        connection_names = settings.childGroups()
        settings.endGroup()
    
        # ComboBox leeren und neu befüllen
        self.ConComboBox.clear()
        if connection_names:
            self.ConComboBox.addItems(connection_names)
        else:
            self.ConComboBox.addItem("Keine Verbindungen gefunden")

    def update_pg_schemas(self):
        # Get the selected connection name
        connection_name = self.ConComboBox.currentText()
        self.SchComboBox.clear()
        
        if not connection_name or connection_name == "Keine Verbindungen gefunden":
            return
        else:
            schemas = self.list_schemas(connection_name)
            self.SchComboBox.addItems(schemas)


    def list_schemas(self, connection_name):
        # 1. Get the 'postgres' provider metadata
        metadata = QgsProviderRegistry.instance().providerMetadata('postgres')

        # 2. Get the connection object (this is the "Class" you wanted)
        # This connection object understands schemas, tables, and SQL
        conn = metadata.findConnection(connection_name)

        if conn:
            # 3. Simply ask for the schemas
            schemas = conn.schemas()
            return schemas # Returns a list of strings
        return []