# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PGRasterCreateOverviewsDialog
                                 A QGIS plugin
 Create raster overviews for already imported PgRaster
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-07-17
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Dr. Horst Duester / Sourcepols, Florian Jenn / GCI
        email                : florian.jenn@gci-kw.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os
import sys
import psycopg2
from qgis.PyQt import uic
from qgis.core import QgsMapLayerProxyModel
from qgis.utils import OverrideCursor
from qgis.PyQt.QtCore import Qt, pyqtSlot
from qgis.PyQt.QtWidgets import QDialog, QMessageBox
from .raster.raster_upload import RasterUpload
from .about.about import About

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'pgraster_create_overviews_dialog.ui'))


class PGRasterCreateOverviewsDialog(QDialog, FORM_CLASS):
    def __init__(self, iface, parent=None):
        """Constructor."""
        super(PGRasterCreateOverviewsDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.iface = iface
        self.conn = None
        
    def __error_message(self, e):
        QMessageBox.critical(
            None,
            self.tr("Error"),
            "%s" % e,
            QMessageBox.StandardButtons(
                QMessageBox.StandardButton.Ok),
            QMessageBox.StandardButton.Ok)
        return None        

    def open_dialog(self):
        self.conn = None
        self.txt_dbname.clear()
        self.txt_schema.clear()
        self.txt_table.clear()
        self.progress_bar.reset()
        self.progress_label.clear()
        self.cmb_map_layer.setCurrentIndex(-1) 
        self.cmb_map_layer.setFilters(QgsMapLayerProxyModel.Filter.RasterLayer)        
        self.set_excluded_layers()
        self.enable_buttons(False)
        self.show()

    def message(self, title, text, type):
        widget = self.iface.messageBar().createMessage(title, text)
        self.iface.messageBar().pushWidget(widget, type, duration=5)
        
    def set_excluded_layers(self):
        """Exclude all layers except PostGIS raster"""
        excepted_layers = []
        for i in range(self.cmb_map_layer.count()):
            layer = self.cmb_map_layer.layer(i)
            if layer.dataProvider().name() != 'postgresraster':
                excepted_layers.append(layer)                
        self.cmb_map_layer.setExceptedLayerList(excepted_layers)
        
    def enable_buttons(self, status=None):
        if status is not None:
            self.btn_create.setEnabled(status)
            return
        if self.cmb_map_layer.currentIndex() == -1 or not self.conn:
            self.btn_create.setEnabled(False)
        else:
            self.btn_create.setEnabled(True)
            
    def table_exists(self, conn, schema, table):            
        sql = """
            SELECT exists( 
                SELECT table_name 
                FROM information_schema.tables 
                WHERE table_schema = '%s' and table_name = '%s')
            """ % (schema,  table)
        cur = conn.cursor()
        cur.execute(sql)
        rows = cur.fetchall()        
        return rows[0][0]

    def init_DB(self, connection_info):
        """Connect to DB, using data source info and credentials from layer source."""
        try:
            conn = psycopg2.connect(connection_info)
        except psycopg2.Error:
            QMessageBox.critical(None, self.tr('Error'),
                                 self.tr('Cannot connect to {0}: Exception info: {1}').format(
                                     connection_info, sys.exc_info()[1]))
            return None        
        return conn
        
    def db_schemas(self, conn):
        """Retrieve valid schemas for import from DB connection `conn`"""      
        sql = """
             SELECT n.nspname AS "Name"
               FROM pg_catalog.pg_namespace n                                      
             WHERE n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'     
             ORDER BY 1;        
        """
        cur = conn.cursor()
        cur.execute(sql)
        rows = cur.fetchall()        
        schema_list = [row[0] for row in rows]
        return schema_list           

    @pyqtSlot()
    def on_btn_close_clicked(self):
        """
        Slot documentation goes here.
        """
        self.close()

    @pyqtSlot()
    def on_btn_create_clicked(self):
        if not self.conn:
            return
        selected_layer_uri = self.selected_layer.dataProvider().uri()
        schema = selected_layer_uri.schema()
        table = selected_layer_uri.table()
        geom_column = selected_layer_uri.geometryColumn()

        if not (schema in self.db_schemas(self.conn) and self.table_exists(self.conn, schema, table)):
            return #TODO error message        
        with OverrideCursor(Qt.CursorShape.WaitCursor):
            uploader = RasterUpload(self.conn, self.progress_label, self.progress_bar)
            result = uploader.create_overviews(schema, table, geom_column)  #TODO handle result

        self.conn.close()
        self.enable_buttons(False)
        self.selected_layer.reload()  #FIXME: Qgis doesn’t recognise the newly created overviews even after reload()
    
    @pyqtSlot()
    def on_btn_about_clicked(self):
        """
        Slot documentation goes here.
        """
        About().exec()
    
    @pyqtSlot(str)
    def on_cmb_map_layer_currentIndexChanged(self):
        """Update data source info when new layer is selected and enable buttons correspondingly."""
        selected_layer = self.cmb_map_layer.currentLayer()
        if not selected_layer:
            return
        self.txt_dbname.clear()
        self.txt_schema.clear()
        self.txt_table.clear()
        if self.conn:
            self.conn.close()

        self.selected_layer = self.cmb_map_layer.currentLayer()
        selected_layer_uri = self.selected_layer.dataProvider().uri()
        dbname = selected_layer_uri.database()
        schema = selected_layer_uri.schema()
        table = selected_layer_uri.table()
        conn_info = selected_layer_uri.connectionInfo()

        self.conn = self.init_DB(conn_info)
        if not self.conn:
            QMessageBox.warning(None, self.tr('Error'), 
                                self.tr('Cannot connect to database {}').format(dbname))
            return
        if not self.raster_extension_exists(self.conn):  # shouldn’t happen
            QMessageBox.warning(None, self.tr('Error'), self.tr('PostGIS Raster Extension not installed in destination DB'))
            return
        self.enable_buttons()

        self.txt_dbname.setText(dbname)
        self.txt_schema.setText(schema)
        self.txt_table.setText(table)
        
    def raster_extension_exists(self, conn):
        sql = 'SELECT extname FROM pg_extension;'
        cursor = conn.cursor()
        cursor.execute(sql)
        conn.commit()
        result = cursor.fetchall()
        
        for extension in result:
            if str(extension) == "('postgis_raster',)":
                return True
        return False
