# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PeopleFlowVisualizationDialog
                                 A QGIS plugin
 This plugin visualize people flow
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2022-10-07
        git sha              : $Format:%H$
        copyright            : (C) 2022 by MLIT
        email                : trial@MILT
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import subprocess
import shutil
import csv
import processing
import datetime
import json
from urllib.parse import quote
import pandas as pd
import re
import numpy as np
import webbrowser

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtCore import pyqtSignal,QVariant,Qt
from qgis.PyQt.QtWidgets import QMessageBox,QFileDialog,QProgressDialog,QApplication

from qgis.core import *
from qgis.gui import *

from . import worldmesh
from chardet import detect
from datetime import timedelta

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'people_flow_visualization_dialog_base.ui'))


class PeopleFlowVisualizationDialog(QtWidgets.QDialog, FORM_CLASS):

    closingPlugin = pyqtSignal()

    def __init__(self,iface, parent=None):
        """Constructor."""
        super(PeopleFlowVisualizationDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        self.iface = iface
        
        self.default_file_path = os.path.expanduser('~') + '/Desktop'
        self.setMinimumSize(1024, 700)
        self.setMaximumSize(1024, 700)

        self.tabWidget.setCurrentIndex(0)

        self.lnk_tebiki.clicked.connect(self.lnk_tebiki_clicked)
        self.lnk_riyo.clicked.connect(self.lnk_riyo_clicked)
        self.lnk_use.clicked.connect(self.lnk_use_clicked)
        self.lnk_guide.clicked.connect(self.lnk_guide_clicked)



        self.btn_001_csv_select.clicked.connect(self.m001_csv_select)
        self.btn_001_shp_select.clicked.connect(self.m001_shp_select)
        self.btn_002_csv_select.clicked.connect(self.m002_csv_select)
        self.btn_002_shp_select.clicked.connect(self.m002_shp_select)
        self.btn_003_csv_select.clicked.connect(self.m003_csv_select)
        self.btn_003_shp_select.clicked.connect(self.m003_shp_select)
        self.btn_004_csv_select.clicked.connect(self.m004_csv_select)
        self.btn_004_shp_select.clicked.connect(self.m004_shp_select)
        self.btn_005_csv_select.clicked.connect(self.m005_csv_select)

        self.btn_001.clicked.connect(self.move_001)
        self.btn_002.clicked.connect(self.move_002)
        self.btn_003.clicked.connect(self.move_003)
        self.btn_004.clicked.connect(self.move_004)
        self.btn_005.clicked.connect(self.move_005)
        self.btn_home_1.clicked.connect(self.move_0)
        self.btn_home_002.clicked.connect(self.move_0)
        self.btn_home_003.clicked.connect(self.move_0)
        self.btn_home_004.clicked.connect(self.move_0)
        self.btn_home_005.clicked.connect(self.move_0)

        self.btn_001_run.clicked.connect(self.run_001)
        self.btn_002_run.clicked.connect(self.run_002)
        self.btn_003_run.clicked.connect(self.run_003)
        self.btn_004_run.clicked.connect(self.run_004)
        self.btn_005_run.clicked.connect(self.run_005)

        self.btn_001_csv_download.clicked.connect(self.download_001)
        self.btn_002_csv_download.clicked.connect(self.download_002)
        self.btn_003_csv_download.clicked.connect(self.download_003)
        self.btn_004_csv_download.clicked.connect(self.download_004)
        self.btn_005_csv_download.clicked.connect(self.download_005)

    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()

    def lnk_tebiki_clicked(self):
        url = os.path.dirname(__file__)+"/document/tebiki.pdf"       
        subprocess.Popen(['start', url], shell=True)      

    def lnk_riyo_clicked(self):
        url = os.path.dirname(__file__)+"/document/terms_of_use.pdf"       
        subprocess.Popen(['start', url], shell=True)        

    def lnk_use_clicked(self):
        url = os.path.dirname(__file__)+"/document/howtouse.pdf"       
        subprocess.Popen(['start', url], shell=True)        

    def lnk_guide_clicked(self):
        url = os.path.dirname(__file__)+"/document/guide.pdf"       
        subprocess.Popen(['start', url], shell=True)


    def move_0(self):
        self.tabWidget.setCurrentIndex(0)
        self.lbl_001_csv_select.setText('')
        self.lbl_001_shp_select.setText('')
        self.lbl_002_csv_select.setText('')
        self.lbl_002_shp_select.setText('')
        self.lbl_003_csv_select.setText('')
        self.lbl_003_shp_select.setText('')
        self.lbl_004_csv_select.setText('')
        self.lbl_004_shp_select.setText('')
        self.lbl_005_csv_select.setText('')
        if len(QgsProject.instance().mapLayersByName('poi')) >= 1 :
            QgsProject.instance().removeMapLayer(QgsProject.instance().mapLayersByName('poi')[0].id())


    def move_001(self):
        self.tabWidget.setCurrentIndex(1)

    def move_002(self):
        self.tabWidget.setCurrentIndex(2)

    def move_003(self):
        self.tabWidget.setCurrentIndex(3)

    def move_004(self):
        self.tabWidget.setCurrentIndex(4)

    def move_005(self):
        self.tabWidget.setCurrentIndex(5)


    def m001_csv_select(self) :
        try :
            
            self.lbl_001_csv_select.setText('')
                        
            fname = QFileDialog.getOpenFileName(self, 'ファイル選択', self.default_file_path,"csv (*.csv)")
            if fname[0]:
                self.default_file_path = os.path.dirname(fname[0])
                progress = QProgressDialog('処理しています...', '', 0, 0, None)
                progress.setWindowModality(Qt.ApplicationModal)
                progress.setCancelButton(None)
                progress.setWindowFlag(Qt.WindowContextHelpButtonHint, False)
                progress.setWindowFlag(Qt.WindowCloseButtonHint, False)
                progress.show()

                QApplication.processEvents()

                file_encoding = encodingCheck(fname[0])
                if "error" in file_encoding :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "文字コードが対応していません(" + file_encoding +")")
                    return                

                #ヘッダー確認
                with open(fname[0], encoding=file_encoding, newline='') as f:
                    csvreader = csv.reader(f)
                    header = next(csvreader)
                
                if len(header) != len(set(header)) :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "項目名が重複しています")
                    return                

                if len(header) > 13 :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "フィールド数が異なります")
                    return                

                
                self.header_count = len(header)
                if header[0] != "meshcode" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(meshcode)")
                    return

                if header[1] != "mesh_size" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(mesh_size)")
                    return

                if header[2] != "year" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(year)")
                    return

                if header[3] != "month" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(month)")
                    return

                if header[4] != "date" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(date)")
                    return

                if header[5] != "hour" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(hour)")
                    return

                if header[6] != "holiday" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(holiday)")
                    return

                if header[self.header_count-1] != "value" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(value)")
                    return

                with open(fname[0], encoding=file_encoding, newline='') as f:
                    csvreader = csv.reader(f)
                    header = next(csvreader)
                    for row in csvreader:
                        try :
                            float(row[0])
                        except :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(meshcode)の値に数値以外の値が含まれています")        
                            return
                        
                        if (len(row[0]) < 8) or (len(row[0]) > 12) :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(meshcode)の桁数が異なります")        
                            return
                        
                        try :
                            int(row[1])
                        except :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(mesh_size)の値に数値以外の値が含まれています")        
                            return
                        
                        if int(row[1]) in [1000,500,250,125,100] :
                            pass
                        else :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(mesh_size)に[1000,500,250,125,100]以外の値が含まれています")        
                            return
                        
                        try :
                            checkDate(int(row[2]), int(row[3]), int(row[4]),int(row[5]),0,0)
                        except :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "データに不正な日付が含まれています")        
                            return
                        if (row[6] == "休日") or (row[6] == "平日")  :
                            pass
                        else:
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(holiday)に[平日,休日]以外の値が含まれています")        
                            return

                        try :
                            float(row[self.header_count-1])
                        except :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(value)の値に数値以外の値が含まれています")        
                            return                        

                self.lbl_001_csv_select.setText(fname[0])

                QApplication.processEvents()
                progress.close()

            else :
                self.lbl_001_csv_select.setText('')

        except ValueError as e:
            progress.close()
            QMessageBox.warning(None, "CSVチェック", "フィールド(value)の値を数値として保存できませんでした")
        except :
            progress.close()
            QMessageBox.warning(None, "メッシュデータ読み込み", "ファイル読み込み時に問題が発生しました")        

    def m001_shp_select(self) :
        try :
            self.lbl_001_shp_select.setText('')
                        
            fname = QFileDialog.getOpenFileName(self, 'ファイル選択', self.default_file_path,"shape (*.shp)")
            if fname[0]:
                self.default_file_path = os.path.dirname(fname[0])
                progress = QProgressDialog('処理しています...', '', 0, 0, None)
                progress.setWindowModality(Qt.ApplicationModal)
                progress.setCancelButton(None)
                progress.setWindowFlag(Qt.WindowContextHelpButtonHint, False)
                progress.setWindowFlag(Qt.WindowCloseButtonHint, False)
                progress.show()

                QApplication.processEvents()

                if len(QgsProject.instance().mapLayersByName('poi')) >= 1 :
                    QgsProject.instance().removeMapLayer(QgsProject.instance().mapLayersByName('poi')[0].id())

                #読み込み
                layer = QgsVectorLayer(fname[0], 'poi', 'ogr') 
                #レイヤに追加
                QgsProject.instance().addMapLayer(layer)

                self.cmb_001_shp_attr_select.setLayer(layer)
                self.lbl_001_shp_select.setText(fname[0])
                
                QApplication.processEvents()
                progress.close()

            else :
                self.lbl_001_shp_select.setText('')

        except :
            progress.close()
            QMessageBox.warning(None, "Shapeデータ読み込み", "ファイル読み込み時に問題が発生しました")        

    def run_001(self):
        try :
            progress = QProgressDialog('処理しています...', '', 0, 0, None)
            progress.setWindowModality(Qt.ApplicationModal)
            progress.setCancelButton(None)
            progress.setWindowFlag(Qt.WindowContextHelpButtonHint, False)
            progress.setWindowFlag(Qt.WindowCloseButtonHint, False)
            progress.show()

            QApplication.processEvents()

            # ファイルのコピー
            moto = self.lbl_001_csv_select.text()
            if moto == "" :
                progress.close()
                return
            
            saki = os.path.dirname(__file__)+"/html/testdata_1.csv"
            shutil.copyfile(moto, saki)

            if len(QgsProject.instance().mapLayersByName('poi')) >= 1 :
                layer = QgsProject.instance().mapLayersByName('poi')[0]
                
                moto2 = os.path.dirname(__file__) + '/html/dummy.geojson'
                saki2 = os.path.dirname(__file__) + '/html/poi.geojson'
                shutil.copyfile(moto2, saki2)
                saki2 = os.path.dirname(__file__) + '/html/poi_p.geojson'
                shutil.copyfile(moto2, saki2)
                saki2 = os.path.dirname(__file__) + '/html/poi_l.geojson'
                shutil.copyfile(moto2, saki2)

                if layer.geometryType() == 0: 
                    poi_name = '/html/poi.geojson'
                elif layer.geometryType() == 1: 
                    poi_name = '/html/poi_l.geojson'
                else :
                    poi_name = '/html/poi_p.geojson'


                # Rename field
                oldname = self.cmb_001_shp_attr_select.currentField()

                QgsVectorFileWriter.writeAsVectorFormat(
                    layer,
                    os.path.dirname(__file__) + poi_name,
                    'UTF-8',
                    QgsCoordinateReferenceSystem("EPSG:4326"),
                    'GeoJSON'
                )


                with open(os.path.dirname(__file__) + poi_name) as reader:
                    content = reader.read()
                content = content.replace(oldname, 'name')
                with open(os.path.dirname(__file__) + poi_name, 'w') as writer:
                    writer.write(content)
            else :
                moto2 = os.path.dirname(__file__) + '/html/dummy.geojson'
                saki2 = os.path.dirname(__file__) + '/html/poi.geojson'
                shutil.copyfile(moto2, saki2)
                moto2 = os.path.dirname(__file__) + '/html/dummy.geojson'
                saki2 = os.path.dirname(__file__) + '/html/poi_p.geojson'
                shutil.copyfile(moto2, saki2)
                moto2 = os.path.dirname(__file__) + '/html/dummy.geojson'
                saki2 = os.path.dirname(__file__) + '/html/poi_l.geojson'
                shutil.copyfile(moto2, saki2)

            moto = os.path.dirname(__file__) + '/html/template/001.html'
            saki = os.path.dirname(__file__) + '/html/001.html'
            shutil.copyfile(moto, saki)

            with open(os.path.dirname(__file__) + '/html/001.html') as reader:
                content = reader.read()
            content = content.replace('replace_csv_file_name', os.path.basename(self.lbl_001_csv_select.text()))
            with open(os.path.dirname(__file__) + '/html/001.html', 'w') as writer:
                writer.write(content)


            progress.close()

            webbrowser.open('http://localhost:8000/001.html', new=0, autoraise=True)

        except :
            progress.close()
            QMessageBox.warning(None, "処理実行", "処理実行時に問題が発生しました")        

    def m002_csv_select(self) :
        try :
            
            self.lbl_002_csv_select.setText('')
                        
            fname = QFileDialog.getOpenFileName(self, 'ファイル選択', self.default_file_path,"csv (*.csv)")
            if fname[0]:
                self.default_file_path = os.path.dirname(fname[0])
                progress = QProgressDialog('処理しています...', '', 0, 0, None)
                progress.setWindowModality(Qt.ApplicationModal)
                progress.setCancelButton(None)
                progress.setWindowFlag(Qt.WindowContextHelpButtonHint, False)
                progress.setWindowFlag(Qt.WindowCloseButtonHint, False)
                progress.show()

                QApplication.processEvents()

                file_encoding = encodingCheck(fname[0])
                if "error" in file_encoding :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "文字コードが対応していません(" + file_encoding +")")
                    return                

                #ヘッダー確認
                with open(fname[0], encoding=file_encoding, newline='') as f:
                    csvreader = csv.reader(f)
                    header = next(csvreader)
                
                if len(header) != len(set(header)) :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "項目名が重複しています")
                    return                

                if len(header) > 17 :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "フィールド数が異なります")
                    return                

                
                self.header_count = len(header)
                if header[0] != "origin_area" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(origin_area)")
                    return

                if header[1] != "origin_area_lat" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(origin_area_lat)")
                    return

                if header[2] != "origin_area_lng" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(origin_area_lng)")
                    return

                if header[3] != "destination_area" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(destination_area)")
                    return

                if header[4] != "destination_area_lat" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(destination_area_lat)")
                    return

                if header[5] != "destination_area_lng" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(destination_area_lng)")
                    return

                if header[6] != "year" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(year)")
                    return

                if header[7] != "month" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(month)")
                    return

                if header[8] != "date" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(date)")
                    return

                if header[9] != "hour" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(hour)")
                    return

                if header[10] != "holiday" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(holiday)")
                    return
                
                if header[self.header_count-1] != "value" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(value)")
                    return

                with open(fname[0], encoding=file_encoding, newline='') as f:
                    csvreader = csv.reader(f)
                    header = next(csvreader)
                    for row in csvreader:
                        try :
                            float(row[1])
                        except :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(origin_area_lat)の値に数値以外の値が含まれています")        
                            return
                        
                        if (float(row[1]) < -90) or (float(row[1]) > 90) :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(origin_area_lat)の値が範囲を超えています")        
                            return

                        try :
                            float(row[2])
                        except :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(origin_area_lng)の値に数値以外の値が含まれています")        
                            return
                        
                        if (float(row[2]) < -180) or (float(row[2]) > 180) :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(origin_area_lng)の値が範囲を超えています")        
                            return

                        try :
                            float(row[4])
                        except :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(destination_area_lat)の値に数値以外の値が含まれています")        
                            return
                        
                        if (float(row[4]) < -90) or (float(row[4]) > 90) :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(destination_area_lat)の値が範囲を超えています")        
                            return

                        try :
                            float(row[5])
                        except :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(destination_area_lng)の値に数値以外の値が含まれています")        
                            return
                        
                        if (float(row[5]) < -180) or (float(row[5]) > 180) :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(destination_area_lng)の値が範囲を超えています")        
                            return

                        try :
                            checkDate(int(row[6]), int(row[7]), int(row[8]),int(row[9]),0,0)
                        except :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "データに不正な日付が含まれています")        
                            return
                        
                        if (row[10] == "休日") or (row[10] == "平日")  :
                            pass
                        else:
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(holiday)に[平日,休日]以外の値が含まれています")        
                            return

                        try :
                            float(row[self.header_count-1])
                        except :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(value)の値に数値以外の値が含まれています")        
                            return           
                                                
                self.lbl_002_csv_select.setText(fname[0])

                QApplication.processEvents()
                progress.close()

            else :
                self.lbl_002_csv_select.setText('')

        except ValueError as e:
            progress.close()
            QMessageBox.warning(None, "CSVチェック", "フィールド(value)の値を数値として保存できませんでした")
        except :
            progress.close()
            QMessageBox.warning(None, "移動データ読み込み", "ファイル読み込み時に問題が発生しました")        

    def m002_shp_select(self) :
        try :
            self.lbl_002_shp_select.setText('')
                        
            fname = QFileDialog.getOpenFileName(self, 'ファイル選択', self.default_file_path,"shape (*.shp)")
            if fname[0]:
                self.default_file_path = os.path.dirname(fname[0])
                progress = QProgressDialog('処理しています...', '', 0, 0, None)
                progress.setWindowModality(Qt.ApplicationModal)
                progress.setCancelButton(None)
                progress.setWindowFlag(Qt.WindowContextHelpButtonHint, False)
                progress.setWindowFlag(Qt.WindowCloseButtonHint, False)
                progress.show()

                QApplication.processEvents()

                if len(QgsProject.instance().mapLayersByName('poi')) >= 1 :
                    QgsProject.instance().removeMapLayer(QgsProject.instance().mapLayersByName('poi')[0].id())

                #読み込み
                layer = QgsVectorLayer(fname[0], 'poi', 'ogr') 
                #レイヤに追加
                QgsProject.instance().addMapLayer(layer)

                self.cmb_002_shp_attr_select.setLayer(layer)
                self.lbl_002_shp_select.setText(fname[0])
                
                QApplication.processEvents()
                progress.close()

            else :
                self.lbl_002_shp_select.setText('')

        except :
            progress.close()
            QMessageBox.warning(None, "地理情報データ読み込み", "ファイル読み込み時に問題が発生しました")        

    def run_002(self):
        try :
            progress = QProgressDialog('処理しています...', '', 0, 0, None)
            progress.setWindowModality(Qt.ApplicationModal)
            progress.setCancelButton(None)
            progress.setWindowFlag(Qt.WindowContextHelpButtonHint, False)
            progress.setWindowFlag(Qt.WindowCloseButtonHint, False)
            progress.show()

            QApplication.processEvents()

            # ファイルのコピー
            moto = self.lbl_002_csv_select.text()
            if moto == "" :
                progress.close()
                return
            
            saki = os.path.dirname(__file__)+"/html/testdata_2.csv"
            shutil.copyfile(moto, saki)

            if len(QgsProject.instance().mapLayersByName('poi')) >= 1 :
                layer = QgsProject.instance().mapLayersByName('poi')[0]

                moto2 = os.path.dirname(__file__) + '/html/dummy.geojson'
                saki2 = os.path.dirname(__file__) + '/html/poi2.geojson'
                shutil.copyfile(moto2, saki2)
                saki2 = os.path.dirname(__file__) + '/html/poi2_p.geojson'
                shutil.copyfile(moto2, saki2)
                saki2 = os.path.dirname(__file__) + '/html/poi2_l.geojson'
                shutil.copyfile(moto2, saki2)

                if layer.geometryType() == 0: 
                    poi_name = '/html/poi2.geojson'
                elif layer.geometryType() == 1: 
                    poi_name = '/html/poi2_l.geojson'
                else :
                    poi_name = '/html/poi2_p.geojson'



                # Rename field
                oldname = self.cmb_002_shp_attr_select.currentField()

                QgsVectorFileWriter.writeAsVectorFormat(
                    layer,
                    os.path.dirname(__file__) + poi_name,
                    'UTF-8',
                    QgsCoordinateReferenceSystem("EPSG:4326"),
                    'GeoJSON'
                )
                with open(os.path.dirname(__file__) + poi_name) as reader:
                    content = reader.read()
                content = content.replace(oldname, 'name')
                with open(os.path.dirname(__file__) + poi_name, 'w') as writer:
                    writer.write(content)
            else :
                moto2 = os.path.dirname(__file__) + '/html/dummy.geojson'
                saki2 = os.path.dirname(__file__) + '/html/poi2.geojson'
                shutil.copyfile(moto2, saki2)
                moto2 = os.path.dirname(__file__) + '/html/dummy.geojson'
                saki2 = os.path.dirname(__file__) + '/html/poi2_p.geojson'
                shutil.copyfile(moto2, saki2)
                moto2 = os.path.dirname(__file__) + '/html/dummy.geojson'
                saki2 = os.path.dirname(__file__) + '/html/poi2_l.geojson'
                shutil.copyfile(moto2, saki2)


            moto = os.path.dirname(__file__) + '/html/template/002.html'
            saki = os.path.dirname(__file__) + '/html/002.html'
            shutil.copyfile(moto, saki)

            with open(os.path.dirname(__file__) + '/html/002.html') as reader:
                content = reader.read()
            content = content.replace('replace_csv_file_name', os.path.basename(self.lbl_002_csv_select.text()))
            with open(os.path.dirname(__file__) + '/html/002.html', 'w') as writer:
                writer.write(content)

            progress.close()

            webbrowser.open('http://localhost:8000/002.html', new=0, autoraise=True)

        except :
            progress.close()
            QMessageBox.warning(None, "処理実行", "処理実行時に問題が発生しました")        


    def m003_csv_select(self) :
        try :
            
            self.lbl_003_csv_select.setText('')
                        
            fname = QFileDialog.getOpenFileName(self, 'ファイル選択', self.default_file_path,"csv (*.csv)")
            if fname[0]:
                self.default_file_path = os.path.dirname(fname[0])
                progress = QProgressDialog('処理しています...', '', 0, 0, None)
                progress.setWindowModality(Qt.ApplicationModal)
                progress.setCancelButton(None)
                progress.setWindowFlag(Qt.WindowContextHelpButtonHint, False)
                progress.setWindowFlag(Qt.WindowCloseButtonHint, False)
                progress.show()

                QApplication.processEvents()

                file_encoding = encodingCheck(fname[0])
                if "error" in file_encoding :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "文字コードが対応していません(" + file_encoding +")")
                    return                

                #ヘッダー確認
                with open(fname[0], encoding=file_encoding, newline='') as f:
                    csvreader = csv.reader(f)
                    header = next(csvreader)
                
                if len(header) != len(set(header)) :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "項目名が重複しています")
                    return                

                if len(header) > 11 :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "フィールド数が異なります")
                    return                

                
                self.header_count = len(header)
                if header[0] != "id" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(id)")
                    return

                if header[1] != "timestamp" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(timestamp)")
                    return

                if header[2] != "area" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(area)")
                    return

                if header[3] != "area_lat" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(area_lat)")
                    return

                if header[4] != "area_lng" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(area_lng)")
                    return

                
                if header[self.header_count-1] != "value" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(value)")
                    return


                with open(fname[0], encoding=file_encoding, newline='') as f:
                    csvreader = csv.reader(f)
                    header = next(csvreader)
                    for row in csvreader:

                        try:
                            datetime.datetime.strptime(row[1], '%Y-%m-%d %H:%M:%S')
                        except :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(timestamp)を日時に変換できません")        
                            return
                        

                        try :
                            float(row[3])
                        except :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(area_lat)の値に数値以外の値が含まれています")        
                            return
                        
                        if (float(row[3]) < -90) or (float(row[3]) > 90) :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(area_lat)の値が範囲を超えています")        
                            return

                        try :
                            float(row[4])
                        except :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(area_lon)の値に数値以外の値が含まれています")        
                            return
                        
                        if (float(row[4]) < -180) or (float(row[4]) > 180) :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(area_lon)の値が範囲を超えています")        
                            return

                        try :
                            float(row[self.header_count-1])
                        except :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(value)の値に数値以外の値が含まれています")        
                            return           

                self.lbl_003_csv_select.setText(fname[0])

                QApplication.processEvents()
                progress.close()

            else :
                self.lbl_003_csv_select.setText('')

        except ValueError as e:
            progress.close()
            QMessageBox.warning(None, "CSVチェック", "フィールド(value)の値を数値として保存できませんでした")
        except :
            progress.close()
            QMessageBox.warning(None, "エリア集計データ読み込み", "ファイル読み込み時に問題が発生しました")        

    def m003_shp_select(self) :
        try :
            self.lbl_003_shp_select.setText('')
                        
            fname = QFileDialog.getOpenFileName(self, 'ファイル選択', self.default_file_path,"shape (*.shp)")
            if fname[0]:
                self.default_file_path = os.path.dirname(fname[0])
                progress = QProgressDialog('処理しています...', '', 0, 0, None)
                progress.setWindowModality(Qt.ApplicationModal)
                progress.setCancelButton(None)
                progress.setWindowFlag(Qt.WindowContextHelpButtonHint, False)
                progress.setWindowFlag(Qt.WindowCloseButtonHint, False)
                progress.show()

                QApplication.processEvents()

                if len(QgsProject.instance().mapLayersByName('poi')) >= 1 :
                    QgsProject.instance().removeMapLayer(QgsProject.instance().mapLayersByName('poi')[0].id())

                #読み込み
                layer = QgsVectorLayer(fname[0], 'poi', 'ogr') 
                #レイヤに追加
                QgsProject.instance().addMapLayer(layer)

                self.cmb_003_shp_attr_select.setLayer(layer)
                self.lbl_003_shp_select.setText(fname[0])
                
                QApplication.processEvents()
                progress.close()

            else :
                self.lbl_003_shp_select.setText('')

        except :
            progress.close()
            QMessageBox.warning(None, "地理情報データ読み込み", "ファイル読み込み時に問題が発生しました")        

    def run_003(self):
        try :
            progress = QProgressDialog('処理しています...', '', 0, 0, None)
            progress.setWindowModality(Qt.ApplicationModal)
            progress.setCancelButton(None)
            progress.setWindowFlag(Qt.WindowContextHelpButtonHint, False)
            progress.setWindowFlag(Qt.WindowCloseButtonHint, False)
            progress.show()

            QApplication.processEvents()

            # ファイルのコピー
            moto = self.lbl_003_csv_select.text()
            if moto == "" :
                progress.close()
                return
            
            saki = os.path.dirname(__file__)+"/html/testdata_3.csv"
            shutil.copyfile(moto, saki)

            if len(QgsProject.instance().mapLayersByName('poi')) >= 1 :
                layer = QgsProject.instance().mapLayersByName('poi')[0]

                moto2 = os.path.dirname(__file__) + '/html/dummy.geojson'
                saki2 = os.path.dirname(__file__) + '/html/poi3.geojson'
                shutil.copyfile(moto2, saki2)
                saki2 = os.path.dirname(__file__) + '/html/poi3_p.geojson'
                shutil.copyfile(moto2, saki2)
                saki2 = os.path.dirname(__file__) + '/html/poi3_l.geojson'
                shutil.copyfile(moto2, saki2)

                if layer.geometryType() == 0: 
                    poi_name = '/html/poi3.geojson'
                elif layer.geometryType() == 1: 
                    poi_name = '/html/poi3_l.geojson'
                else :
                    poi_name = '/html/poi3_p.geojson'



                # Rename field
                oldname = self.cmb_003_shp_attr_select.currentField()

                QgsVectorFileWriter.writeAsVectorFormat(
                    layer,
                    os.path.dirname(__file__) + poi_name,
                    'UTF-8',
                    QgsCoordinateReferenceSystem("EPSG:4326"),
                    'GeoJSON'
                )
                with open(os.path.dirname(__file__) + poi_name) as reader:
                    content = reader.read()
                content = content.replace(oldname, 'name')
                with open(os.path.dirname(__file__) + poi_name, 'w') as writer:
                    writer.write(content)
            else :
                moto2 = os.path.dirname(__file__) + '/html/dummy.geojson'
                saki2 = os.path.dirname(__file__) + '/html/poi3.geojson'
                shutil.copyfile(moto2, saki2)
                moto2 = os.path.dirname(__file__) + '/html/dummy.geojson'
                saki2 = os.path.dirname(__file__) + '/html/poi3_p.geojson'
                shutil.copyfile(moto2, saki2)
                moto2 = os.path.dirname(__file__) + '/html/dummy.geojson'
                saki2 = os.path.dirname(__file__) + '/html/poi3_l.geojson'
                shutil.copyfile(moto2, saki2)

            moto = os.path.dirname(__file__) + '/html/template/003-1.html'
            saki = os.path.dirname(__file__) + '/html/003-1.html'
            shutil.copyfile(moto, saki)

            with open(os.path.dirname(__file__) + '/html/003-1.html') as reader:
                content = reader.read()
            content = content.replace('replace_csv_file_name', os.path.basename(self.lbl_003_csv_select.text()))
            with open(os.path.dirname(__file__) + '/html/003-1.html', 'w') as writer:
                writer.write(content)

            moto = os.path.dirname(__file__) + '/html/template/003-2.html'
            saki = os.path.dirname(__file__) + '/html/003-2.html'
            shutil.copyfile(moto, saki)

            with open(os.path.dirname(__file__) + '/html/003-2.html') as reader:
                content = reader.read()
            content = content.replace('replace_csv_file_name', os.path.basename(self.lbl_003_csv_select.text()))
            with open(os.path.dirname(__file__) + '/html/003-2.html', 'w') as writer:
                writer.write(content)

            progress.close()

            webbrowser.open('http://localhost:8000/003.html', new=0, autoraise=True)

        except :
            progress.close()
            QMessageBox.warning(None, "処理実行", "処理実行時に問題が発生しました")        


    def m004_csv_select(self) :
        try :
            
            self.lbl_004_csv_select.setText('')
                        
            fname = QFileDialog.getOpenFileName(self, 'ファイル選択', self.default_file_path,"csv (*.csv)")
            if fname[0]:
                self.default_file_path = os.path.dirname(fname[0])
                progress = QProgressDialog('処理しています...', '', 0, 0, None)
                progress.setWindowModality(Qt.ApplicationModal)
                progress.setCancelButton(None)
                progress.setWindowFlag(Qt.WindowContextHelpButtonHint, False)
                progress.setWindowFlag(Qt.WindowCloseButtonHint, False)
                progress.show()

                QApplication.processEvents()

                file_encoding = encodingCheck(fname[0])
                if "error" in file_encoding :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "文字コードが対応していません(" + file_encoding +")")
                    return                

                #ヘッダー確認
                with open(fname[0], encoding=file_encoding, newline='') as f:
                    csvreader = csv.reader(f)
                    header = next(csvreader)
                
                if len(header) != len(set(header)) :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "項目名が重複しています")
                    return                

                if len(header) > 10 :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "フィールド数が異なります")
                    return                

                
                self.header_count = len(header)
                if header[0] != "id" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(id)")
                    return

                if header[1] != "timestamp" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(timestamp)")
                    return

                if header[2] != "lat" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(lat)")
                    return

                if header[3] != "lng" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(lng)")
                    return

                
                if header[self.header_count-1] != "value" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(value)")
                    return

                with open(fname[0], encoding=file_encoding, newline='') as f:
                    csvreader = csv.reader(f)
                    header = next(csvreader)
                    for row in csvreader:

                        try:
                            datetime.datetime.strptime(row[1], '%Y-%m-%d %H:%M:%S')
                        except :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(timestamp)を日時に変換できません")        
                            return
                        

                        try :
                            float(row[2])
                        except :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(lat)の値に数値以外の値が含まれています")        
                            return
                        
                        if (float(row[2]) < -90) or (float(row[2]) > 90) :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(lat)の値が範囲を超えています")        
                            return

                        try :
                            float(row[3])
                        except :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(lng)の値に数値以外の値が含まれています")        
                            return
                        
                        if (float(row[3]) < -180) or (float(row[3]) > 180) :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(lng)の値が範囲を超えています")        
                            return

                        try :
                            float(row[self.header_count-1])
                        except :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(value)の値に数値以外の値が含まれています")        
                            return           


                self.lbl_004_csv_select.setText(fname[0])

                QApplication.processEvents()
                progress.close()

            else :
                self.lbl_004_csv_select.setText('')

        except ValueError as e:
            progress.close()
            QMessageBox.warning(None, "CSVチェック", "フィールド(value)の値を数値として保存できませんでした")
        except :
            progress.close()
            QMessageBox.warning(None, "ポイントデータ読み込み", "ファイル読み込み時に問題が発生しました")        

    def m004_shp_select(self) :
        try :
            self.lbl_004_shp_select.setText('')
                        
            fname = QFileDialog.getOpenFileName(self, 'ファイル選択', self.default_file_path,"shape (*.shp)")
            if fname[0]:
                self.default_file_path = os.path.dirname(fname[0])
                progress = QProgressDialog('処理しています...', '', 0, 0, None)
                progress.setWindowModality(Qt.ApplicationModal)
                progress.setCancelButton(None)
                progress.setWindowFlag(Qt.WindowContextHelpButtonHint, False)
                progress.setWindowFlag(Qt.WindowCloseButtonHint, False)
                progress.show()

                QApplication.processEvents()

                if len(QgsProject.instance().mapLayersByName('poi')) >= 1 :
                    QgsProject.instance().removeMapLayer(QgsProject.instance().mapLayersByName('poi')[0].id())

                #読み込み
                layer = QgsVectorLayer(fname[0], 'poi', 'ogr') 
                #レイヤに追加
                QgsProject.instance().addMapLayer(layer)

                self.cmb_004_shp_attr_select.setLayer(layer)
                self.lbl_004_shp_select.setText(fname[0])
                
                QApplication.processEvents()
                progress.close()

            else :
                self.lbl_004_shp_select.setText('')

        except :
            progress.close()
            QMessageBox.warning(None, "Shapeデータ読み込み", "ファイル読み込み時に問題が発生しました")        

    def run_004(self):
        try :
            progress = QProgressDialog('処理しています...', '', 0, 0, None)
            progress.setWindowModality(Qt.ApplicationModal)
            progress.setCancelButton(None)
            progress.setWindowFlag(Qt.WindowContextHelpButtonHint, False)
            progress.setWindowFlag(Qt.WindowCloseButtonHint, False)
            progress.show()

            QApplication.processEvents()

            # ファイルのコピー
            moto = self.lbl_004_csv_select.text()
            if moto == "" :
                progress.close()
                return
            
            saki = os.path.dirname(__file__)+"/html/testdata_4_5.csv"
            shutil.copyfile(moto, saki)

            if len(QgsProject.instance().mapLayersByName('poi')) >= 1 :
                layer = QgsProject.instance().mapLayersByName('poi')[0]

                moto2 = os.path.dirname(__file__) + '/html/dummy.geojson'
                saki2 = os.path.dirname(__file__) + '/html/poi4.geojson'
                shutil.copyfile(moto2, saki2)
                saki2 = os.path.dirname(__file__) + '/html/poi4_p.geojson'
                shutil.copyfile(moto2, saki2)
                saki2 = os.path.dirname(__file__) + '/html/poi4_l.geojson'
                shutil.copyfile(moto2, saki2)

                if layer.geometryType() == 0: 
                    poi_name = '/html/poi4.geojson'
                elif layer.geometryType() == 1: 
                    poi_name = '/html/poi4_l.geojson'
                else :
                    poi_name = '/html/poi4_p.geojson'


                # Rename field
                oldname = self.cmb_004_shp_attr_select.currentField()

                QgsVectorFileWriter.writeAsVectorFormat(
                    layer,
                    os.path.dirname(__file__) + poi_name,
                    'UTF-8',
                    QgsCoordinateReferenceSystem("EPSG:4326"),
                    'GeoJSON'
                )
                with open(os.path.dirname(__file__) + poi_name) as reader:
                    content = reader.read()
                content = content.replace(oldname, 'name')
                with open(os.path.dirname(__file__) + poi_name, 'w') as writer:
                    writer.write(content)
            else :
                moto2 = os.path.dirname(__file__) + '/html/dummy.geojson'
                saki2 = os.path.dirname(__file__) + '/html/poi4.geojson'
                shutil.copyfile(moto2, saki2)
                moto2 = os.path.dirname(__file__) + '/html/dummy.geojson'
                saki2 = os.path.dirname(__file__) + '/html/poi4_p.geojson'
                shutil.copyfile(moto2, saki2)
                moto2 = os.path.dirname(__file__) + '/html/dummy.geojson'
                saki2 = os.path.dirname(__file__) + '/html/poi4_l.geojson'
                shutil.copyfile(moto2, saki2)

            moto = os.path.dirname(__file__) + '/html/template/004-1.html'
            saki = os.path.dirname(__file__) + '/html/004-1.html'
            shutil.copyfile(moto, saki)

            with open(os.path.dirname(__file__) + '/html/004-1.html') as reader:
                content = reader.read()
            content = content.replace('replace_csv_file_name', os.path.basename(self.lbl_004_csv_select.text()))
            with open(os.path.dirname(__file__) + '/html/004-1.html', 'w') as writer:
                writer.write(content)

            moto = os.path.dirname(__file__) + '/html/template/004-2.html'
            saki = os.path.dirname(__file__) + '/html/004-2.html'
            shutil.copyfile(moto, saki)

            with open(os.path.dirname(__file__) + '/html/004-2.html') as reader:
                content = reader.read()
            content = content.replace('replace_csv_file_name', os.path.basename(self.lbl_004_csv_select.text()))
            with open(os.path.dirname(__file__) + '/html/004-2.html', 'w') as writer:
                writer.write(content)

            progress.close()

            webbrowser.open('http://localhost:8000/004.html', new=0, autoraise=True)

        except :
            progress.close()
            QMessageBox.warning(None, "処理実行", "処理実行時に問題が発生しました")        

    def m005_csv_select(self) :
        try :
            
            self.lbl_005_csv_select.setText('')
                        
            fname = QFileDialog.getOpenFileName(self, 'ファイル選択', self.default_file_path,"csv (*.csv)")
            if fname[0]:
                self.default_file_path = os.path.dirname(fname[0])
                progress = QProgressDialog('処理しています...', '', 0, 0, None)
                progress.setWindowModality(Qt.ApplicationModal)
                progress.setCancelButton(None)
                progress.setWindowFlag(Qt.WindowContextHelpButtonHint, False)
                progress.setWindowFlag(Qt.WindowCloseButtonHint, False)
                progress.show()

                QApplication.processEvents()

                file_encoding = encodingCheck(fname[0])
                if "error" in file_encoding :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "文字コードが対応していません(" + file_encoding +")")
                    return                

                #ヘッダー確認
                with open(fname[0], encoding=file_encoding, newline='') as f:
                    csvreader = csv.reader(f)
                    header = next(csvreader)
                
                if len(header) != len(set(header)) :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "項目名が重複しています")
                    return                

                if len(header) > 10 :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "フィールド数が異なります")
                    return                

                
                self.header_count = len(header)
                if header[0] != "id" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(id)")
                    return

                if header[1] != "timestamp" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(timestamp)")
                    return

                if header[2] != "lat" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(lat)")
                    return

                if header[3] != "lng" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(lng)")
                    return

                
                if header[self.header_count-1] != "value" :
                    progress.close()
                    QMessageBox.warning(None, "CSVフォーマットチェック", "CSVの形式が異なります(value)")
                    return
                with open(fname[0], encoding=file_encoding, newline='') as f:
                    csvreader = csv.reader(f)
                    header = next(csvreader)
                    for row in csvreader:

                        try:
                            datetime.datetime.strptime(row[1], '%Y-%m-%d %H:%M:%S')
                        except :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(timestamp)を日時に変換できません")        
                            return
                        

                        try :
                            float(row[2])
                        except :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(lat)の値に数値以外の値が含まれています")        
                            return
                        
                        if (float(row[2]) < -90) or (float(row[2]) > 90) :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(lat)の値が範囲を超えています")        
                            return

                        try :
                            float(row[3])
                        except :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(lng)の値に数値以外の値が含まれています")        
                            return
                        
                        if (float(row[3]) < -180) or (float(row[3]) > 180) :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(lng)の値が範囲を超えています")        
                            return

                        try :
                            float(row[self.header_count-1])
                        except :
                            progress.close()
                            QMessageBox.warning(None, "CSVチェック", "フィールド(value)の値に数値以外の値が含まれています")        
                            return  

                self.lbl_005_csv_select.setText(fname[0])

                QApplication.processEvents()
                progress.close()

            else :
                self.lbl_005_csv_select.setText('')

        except ValueError as e:
            progress.close()
            QMessageBox.warning(None, "CSVチェック", "フィールド(value)の値を数値として保存できませんでした")
        except :
            progress.close()
            QMessageBox.warning(None, "メッシュデータ読み込み", "ファイル読み込み時に問題が発生しました")        


    def run_005(self):
        try :
            progress = QProgressDialog('処理しています...', '', 0, 0, None)
            progress.setWindowModality(Qt.ApplicationModal)
            progress.setCancelButton(None)
            progress.setWindowFlag(Qt.WindowContextHelpButtonHint, False)
            progress.setWindowFlag(Qt.WindowCloseButtonHint, False)
            progress.show()

            QApplication.processEvents()

            # ファイルのコピー
            moto = self.lbl_005_csv_select.text()
            if moto == "" :
                progress.close()
                return
            
            saki = os.path.dirname(__file__)+"/html/testdata_4_5.csv"
            shutil.copyfile(moto, saki)

            moto = os.path.dirname(__file__) + '/html/template/005.html'
            saki = os.path.dirname(__file__) + '/html/005.html'
            shutil.copyfile(moto, saki)

            with open(os.path.dirname(__file__) + '/html/005.html') as reader:
                content = reader.read()
            content = content.replace('replace_csv_file_name', os.path.basename(self.lbl_005_csv_select.text()))
            with open(os.path.dirname(__file__) + '/html/005.html', 'w') as writer:
                writer.write(content)

            progress.close()

            webbrowser.open('http://localhost:8000/005.html', new=0, autoraise=True)

        except :
            progress.close()
            QMessageBox.warning(None, "処理実行", "処理実行時に問題が発生しました")     

    def download_001(self) :
        output_path = QFileDialog.getSaveFileName(self, "保存先指定",
                                    os.path.expanduser('~') + '/Desktop/sample_data_1.csv','CSV(*.csv)')
        try:
            if output_path[0] :
                shutil.copyfile(os.path.dirname(__file__) + '/sample/sample_data_1.csv', output_path[0])
        except:
            QMessageBox.warning(None, "csv保存", "csv保存時に問題が発生しました")        

    def download_002(self) :
        output_path = QFileDialog.getSaveFileName(self, "保存先指定",
                                    os.path.expanduser('~') + '/Desktop/sample_data_2.csv','CSV(*.csv)')
        try:
            if output_path[0] :
                shutil.copyfile(os.path.dirname(__file__) + '/sample/sample_data_2.csv', output_path[0])
        except:
            QMessageBox.warning(None, "csv保存", "csv保存時に問題が発生しました")        

    def download_003(self) :
        output_path = QFileDialog.getSaveFileName(self, "保存先指定",
                                    os.path.expanduser('~') + '/Desktop/sample_data_3.csv','CSV(*.csv)')
        try:
            if output_path[0] :
                shutil.copyfile(os.path.dirname(__file__) + '/sample/sample_data_3.csv', output_path[0])
        except:
            QMessageBox.warning(None, "csv保存", "csv保存時に問題が発生しました")        

    def download_004(self) :
        output_path = QFileDialog.getSaveFileName(self, "保存先指定",
                                    os.path.expanduser('~') + '/Desktop/sample_data_4.csv','CSV(*.csv)')
        try:
            if output_path[0] :
                shutil.copyfile(os.path.dirname(__file__) + '/sample/sample_data_4.csv', output_path[0])
        except:
            QMessageBox.warning(None, "csv保存", "csv保存時に問題が発生しました")        

    def download_005(self) :
        output_path = QFileDialog.getSaveFileName(self, "保存先指定",
                                    os.path.expanduser('~') + '/Desktop/sample_data_5.csv','CSV(*.csv)')
        try:
            if output_path[0] :
                shutil.copyfile(os.path.dirname(__file__) + '/sample/sample_data_5.csv', output_path[0])
        except:
            QMessageBox.warning(None, "csv保存", "csv保存時に問題が発生しました")        

def isonlynum(s):
    return True if re.fullmatch('[0-9]+', s) else False

def getZoomFromScale(scale):
    z = None
    if scale < 1250:
        z=18
    elif scale < 2500:
        z=17
    elif scale < 5000:
        z=16
    elif scale < 10000:
        z=15
    elif scale < 20000:
        z=14
    elif scale < 40000:
        z=13
    elif scale < 100000:
        z=12
    elif scale < 200000:
        z=11
    elif scale < 400000:
        z=10
    elif scale < 1000000:
        z=9
    elif scale < 2000000:
        z=8
    elif scale < 4000000:
        z=7
    elif scale < 8000000:
        z=6
    else:
        z=5

    # １段階zoom_out
    return z-0.5

def encodingCheck(file_path) :
    with open(file_path, mode='rb') as f:
        b = f.read()
        encoding_info = detect(b)

    file_encoding = encoding_info['encoding']
    if file_encoding == "utf-8":
        file_encoding = "utf-8"
    elif file_encoding == "SHIFT_JIS":
        file_encoding = "cp932"
    elif file_encoding == "Windows-1252":
        file_encoding = "cp932"
    elif file_encoding == "ascii":
        file_encoding = "cp932"
    elif file_encoding == "UTF-8-SIG":
        file_encoding = "utf-8-sig"
    else :
        file_encoding = "error:" + file_encoding

    return file_encoding
    

def checkDate(year,month,day,hour,min,sec):
    try:
        newDataStr="%04d/%02d/%02d/%02d/%02d/%02d"%(year,month,day,hour,min,sec)
        newDate=datetime.datetime.strptime(newDataStr,"%Y/%m/%d/%H/%M/%S")
    except ValueError:
        raise ValueError("Incorrect data format, should be YYYY-MM-DD")