var style_sample = 
[
    'interpolate',
    ['linear'],
    ['get', 'cnt']
]
const aryMax = function (a, b) {return Math.max(a, b);}
const aryMin = function (a, b) {return Math.min(a, b);}

var df_data = []
var value_list = []
var value_list_2 = []
var grad_style = ['#fff0f0','#ffd0d0','#ffa0a0','#ff8080','#ff5050']

var grad_style2 = [
    [255,240,240, 255],
    [255,208,208, 255],
    [255,160,160, 255],
    [255,128,125, 255],
    [255,80,80, 255]
]


var map;
var initial_data
//Select2
$(document).ready(function() {
    $("#overlay").fadeIn(300)
    map = new maplibregl.Map({
        container: 'map', // container id
        style: 'style/dark.json', // style URL
        center: [0, 0], // starting position [lng, lat]
        zoom: 1, // starting zoom
        maxZoom: 18,
        pitch: 45,
    });
    var nav = new maplibregl.NavigationControl({ visualizePitch: true }); 

    const scale = new maplibregl.ScaleControl({
    maxWidth: 80,
      unit: 'imperial'
    });
    
    map.addControl(scale, 'bottom-right');
    scale.setUnit('metric');
    map.addControl(nav, 'bottom-right');
    let request = {
        table: "df-i",
    };

    map.on('load', async () => {
        // Add an image to use as a custom marker
        const image1 = await map.loadImage('http://localhost:8000/custom_marker.png');
        const image2 = await map.loadImage('http://localhost:8000/custom_marker_select.png');
        map.addImage('custom-marker', image1.data);
        map.addImage('custom-marker-select', image2.data);
    })

    map.on('click', 'high', (e) => {


        const prop = e.features[0].properties;

        if ($("#area").val().includes(prop.name)) {
            items = $("#area").val();
            $("#area").val(items.filter(function( item ) {return item !== prop.name;}));
            $('#area').multiselect("refresh");
        } else {
            $("#area").val($("#area").val().concat(prop.name)); 
            $('#area').multiselect("refresh");
        }
        showhighlight();

    });

    $.ajax({
        type: "POST",
        url: '/cgi-bin/mod_002_load.py',
        data: JSON.stringify(request),
        dataType: "json",
        success: function(data) {
            initial_data = data
            let options = $.map(data.year_list, function(text, value) {
                let option = $('<option>', {value: text, text: text});
                return option;
            });
            $('#year').append(options);

            options = $.map(data.month_list, function(text, value) {
                let option = $('<option>', {value: text, text: text});
                return option;
            });
            $('#month').append(options);

            options = $.map(data.date_list, function(text, value) {
                let option = $('<option>', {value: text, text: text});
                return option;
            });
            $('#date').append(options);

            options = $.map(data.hour_list, function(text, value) {
                let option = $('<option>', {value: text, text: text});
                return option;
            });
            $('#time').append(options);

            options = $.map(data.area_list, function(text, value) {
                let option = $('<option>', {value: text, text: text});
                return option;
            });
            $('#area').append(options);


            options = $.map(data.holiday_list, function(text, value) {
                let option = $('<option>', {value: text, text: text});
                return option;
            });
            $('#holyday').append(options);

            options = $.map(data.week_list, function(text, value) {
                let option = $('<option>', {value: text, text: text});
                return option;
            });
            $('#yobi').append(options);
            options = $.map(data.attr1_list, function(text, value) {
                let option = $('<option>', {value: text, text: text});
                return option;
            });
            $('#attr1').append(options);

            options = $.map(data.attr2_list, function(text, value) {
                let option = $('<option>', {value: text, text: text});
                return option;
            });
            $('#attr2').append(options);

            options = $.map(data.attr3_list, function(text, value) {
                let option = $('<option>', {value: text, text: text});
                return option;
            });
            $('#attr3').append(options);

            options = $.map(data.attr4_list, function(text, value) {
                let option = $('<option>', {value: text, text: text});
                return option;
            });
            $('#attr4').append(options);

            options = $.map(data.attr5_list, function(text, value) {
                let option = $('<option>', {value: text, text: text});
                return option;
            });
            $('#attr5').append(options);

            options = $.map(data.attrs_name, function(text, value) {
                let option = $('<option>', {value: text, text: text});
                return option;
            });
            $('#attr').append(options);

            $('.multiple').multiselect({
                maxHeight: 200,
                includeSelectAllOption: true,
                includeResetOption: true,
            });

            $("#year").val($("#year").val().concat(data.init_year)); 
            $('#year').multiselect("refresh");
            $("#month").val($("#month").val().concat(data.init_month)); 
            $('#month').multiselect("refresh");

            $("#attr").val(data.attrs_name[0]); 
            $('#attr').multiselect("refresh");

            $("#date").multiselect('selectAll', false);
            $("#time").multiselect('selectAll', false);
            $("#holyday").multiselect('selectAll', false);
            $("#yobi").multiselect('selectAll', false);
            $("#area").multiselect('selectAll', false);
            $("#attr1").multiselect('selectAll', false);
            $("#attr2").multiselect('selectAll', false);
            $("#attr3").multiselect('selectAll', false);
            $("#attr4").multiselect('selectAll', false);
            $("#attr5").multiselect('selectAll', false);
            if (data.attr1_list[0] == 'すべて') {$('#attr1_div').css({"visibility":"hidden", });}
            if (data.attr2_list[0] == 'すべて') {$('#attr2_div').css({"visibility":"hidden", });}
            if (data.attr3_list[0] == 'すべて') {$('#attr3_div').css({"visibility":"hidden", });}
            if (data.attr4_list[0] == 'すべて') {$('#attr4_div').css({"visibility":"hidden", });}
            if (data.attr5_list[0] == 'すべて') {$('#attr5_div').css({"visibility":"hidden", });}


            data.attrs_name.forEach(function(elem, index) {
                console.log("attr"+ String(index+1)+"_label");
                document.getElementById("attr"+ String(index+1)+"_label").textContent = elem;
            });            
            
            $("#area").change(function () {
                showhighlight();
            });

            $('.btn-outline-secondary').click(function(event) {
                showhighlight();
            });

            $('#apply').click();

        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
            console.log("ERROR:\n" +  textStatus + ":\n" + errorThrown);
        }
    });
    
    $("#attr").change(function () {
        $('#apply').click();
    });

    $("#applyButton").on('click', function() {
        lenegd_value_p = 0;
        lenegd_value_n = 0;
        for (let i = 0; i < 5; i++) {
            lenegd_value = document.getElementById('legend_text_' + i);
            lenegd_value_n = Number(lenegd_value.value)
            if (lenegd_value_p > lenegd_value_n) {
                custom_alert('凡例の数字の大小関係に矛盾があります。');
                return;
            }
            lenegd_value_p = lenegd_value_n

        }

        add_style = []
        value_list_2 = []
        for (let i = 0; i < 5; i++) {
            lenegd_value = document.getElementById('legend_text_' + i);
            value_list_2.push(lenegd_value)
            add_style.push(Number(lenegd_value.value));
            add_style.push(grad_style[i]);
        }
        addArcLayer();
    });

    $("#applyButton1").on('click', function() {
        add_style = []
        value_list_2 = []
        for (let i = 0; i < 5; i++) {
            add_style.push(value_list[i]);
            add_style.push(grad_style[i]);
            lenegd_value = document.getElementById('legend_text_' + i);
            lenegd_value.value =  (Math.round((value_list[i]*100))/100).toFixed(2);
            value_list_2.push(value_list[i])

        }
        addArcLayer();
    });

    $("#applyButton2").on('click', function() {
        add_style = []
        value_list_2 = []
        diff  = (value_list[0] + value_list[5]) / 6 
        for (let i = 0; i < 5; i++) {
            add_style.push(value_list[0] + (i*diff));
            add_style.push(grad_style[i]);
            lenegd_value = document.getElementById('legend_text_' + i);
            lenegd_value.value =  (Math.round(((value_list[0] + (i*diff))*100))/100).toFixed(2);
            value_list_2.push(value_list[0] + (i*diff))
        }
        addArcLayer();

    });
    $("#styles").change(function (event) {
        const style = event.target.value;
        map.setStyle('style/' + style + '.json');

        if ($('#area').val().length == 0 ) {
            $("#area").multiselect('selectAll', false);
            showhighlight();
        }
        $('#apply').click();
    });
    $("#legend-show").on('click', function() {
        $("#chart-legend").dialog( {title:"凡例"});
    });


    $('#apply').on('click', function() {
        if ($('#year').val().length == 0) { custom_alert('該当する条件でデータがありません。抽出条件を変えて更新してください。'); return false;}
        if ($('#month').val().length == 0) { custom_alert('該当する条件でデータがありません。抽出条件を変えて更新してください。'); return false;}
        if ($('#date').val().length == 0) { custom_alert('該当する条件でデータがありません。抽出条件を変えて更新してください。'); return false;}
        if ($('#time').val().length == 0) { custom_alert('該当する条件でデータがありません。抽出条件を変えて更新してください。'); return false;}
        if ($('#holyday').val().length == 0) { custom_alert('該当する条件でデータがありません。抽出条件を変えて更新してください。'); return false;}
        if ($('#yobi').val().length == 0) { custom_alert('該当する条件でデータがありません。抽出条件を変えて更新してください。'); return false;}
        if ($('#area').val().length == 0) { custom_alert('該当する条件でデータがありません。抽出条件を変えて更新してください。'); return false;}
        if ($('#attr1').val().length == 0) { custom_alert('該当する条件でデータがありません。抽出条件を変えて更新してください。'); return false;}
        if ($('#attr2').val().length == 0) { custom_alert('該当する条件でデータがありません。抽出条件を変えて更新してください。'); return false;}
        if ($('#attr3').val().length == 0) { custom_alert('該当する条件でデータがありません。抽出条件を変えて更新してください。'); return false;}
        if ($('#attr4').val().length == 0) { custom_alert('該当する条件でデータがありません。抽出条件を変えて更新してください。'); return false;}
        if ($('#attr5').val().length == 0) { custom_alert('該当する条件でデータがありません。抽出条件を変えて更新してください。'); return false;}

        $("#overlay").fadeIn(300);
        $("#chart-df-b").empty();
        $("#chart-df-c").empty();
        $("#chart-df-d").empty();
        $("#chart-df-e").empty();
        $("#chart-df-f").empty();
        $("#chart-df-g").empty();
        $("#chart-df-h").empty();
        $("#chart-df-i").empty();
        $("#chart-df-j").empty();
        $("#swatches").empty();
        $("#chart-legend").empty();

        let request = {
          year: $('#year').val(),
          month: $('#month').val(),
          date: $('#date').val(),
          time: $('#time').val(),
          holyday: $('#holyday').val(),
          yobi: $('#yobi').val(),
          origin_area: $('#area').val(),
          destination_area: $('#area').val(),
          attr1: $('#attr1').val(),
          attr2: $('#attr2').val(),
          attr3: $('#attr3').val(),
          attr4: $('#attr4').val(),
          attr5: $('#attr5').val(),
          attr: $('#attr').val()
        };
        $.ajax({
          type: "POST",
          url: '/cgi-bin/mod_002.py',
          data: JSON.stringify(request),
          dataType: "json",
          success: function(data) {
            if (Object.keys(data).length  === 0) {
                custom_alert('該当する条件でデータがありません。抽出条件を変えて更新してください。');
                return;
            }
            let filtertext = document.getElementById('filter-text');
            filtertext.innerHTML = createFilterText();

            $.getJSON('./outfile2.geojson', function(response){
                var boundingBox = getBoundingBox(response);
                map.fitBounds([[boundingBox.xMin, boundingBox.yMin], [boundingBox.xMax, boundingBox.yMax]],{animate: false});
                map.zoomOut();
                map.setBearing(45);
                value_list = jenks(response.features.map(d => d.properties.cnt),5)
                //NaNの削除
                if(value_list !== null) {
                    value_list = value_list = value_list.filter(function (x) { return x === x })
                }
                if ((value_list === null) || (value_list.length != 5 )) {
                    value_list = []
                    dlist = response.features.map(d => d.properties.cnt)
                    max = dlist.reduce(aryMax)
                    min = dlist.reduce(aryMin)
                    diff  = (min + max) / 6 
                    for (let i = 0; i < 6; i++) {
                        value_list.push(min + (i*diff));
                    }
                }
            
                add_style = []
                for (let i = 0; i < 5; i++) {
                    add_style.push(value_list[i])
                    add_style.push(grad_style[i])
                }

                // for legend control
                const swatches = document.getElementById('swatches');
                grad_style.forEach((color,index) => {
                    const button = document.createElement('button');
                    const text = document.createElement('input');
                    text.setAttribute("id", "legend_text_" + index);
                    button.style.backgroundColor = color;
                    text.value = (Math.round((value_list[index]*100))/100).toFixed(2);
                    // swatch.addEventListener('click', () => {
                    //     map.setPaintProperty(
                    //         layer.value,
                    //         layer.value === 'water' ? 'fill-color' : 'fill-extrusion-color',
                    //         color
                    //     );
                    // });
                    swatches.appendChild(button);
                    swatches.appendChild(text);
                });

                if (map.getLayer('arch')) {
                    map.removeLayer('arch');
                }
                const myArcLayer = new deck.MapboxLayer({
                    id: 'arch',
                    type: deck.GeoJsonLayer,
                    data: response,
                    stroked: true,
                    filled: false,
                    getLineColor: d => {
                        value = d.properties.cnt
                        if(value_list[0] <= value && value < value_list[1]) 
                            return grad_style2[0] 
                        else if(value_list[1] <= value && value < value_list[2]) 
                            return grad_style2[1]
                        else if(value_list[2] <= value && value < value_list[3]) 
                            return grad_style2[2] 
                        else if(value_list[3] <= value && value < value_list[4] ) 
                            return grad_style2[3]
                        else if(value_list[4] <= value && value < value_list[5] ) 
                            return grad_style2[4]
                        else 
                            return grad_style2[0]
                      },
                    //getFillColor: [255, 0, 0, 180],
                    lineJointRounded : true,
                    lineWidthMinPixels: 8,    
                });
                map.addLayer(myArcLayer);
            });
            $.getJSON('./outfile2_area.geojson', function(response){
                
                //map.addImage('custom-marker', image1.data);
                //map.addImage('custom-marker-select', image2.data);

                if (map.getLayer('area')) {
                    map.removeLayer('area');
                    map.removeLayer('area2');
                    map.removeLayer('high');
                    map.removeSource('area')
                    map.removeSource('high')
                }

                map.addSource('area', {
                    type: 'geojson',
                    data: response,
                });
                map.addSource('high', {
                    type: 'geojson',
                    data: './outfile2_point.geojson',
                });       
                map.addLayer({
                    'id': 'area',
                    'type': 'circle',
                    'source': 'area',     
                    'paint': {
                      "circle-color": "#99DDFF",
                      //"circle-radius":100,
                      "circle-radius":["interpolate",["exponential", 2],["zoom"],0, 0,   20,2000],
                      "circle-opacity":0.2,
                    }
                });
            
                // map.addLayer({
                //     'id': 'area2',
                //     'type': 'symbol',
                //     'source': 'area',
                //     'layout': {
                //         'text-field': ['get', 'name'],
                //         'text-size': 10,
                //         'text-offset': [0, 1.5]
                //     },
                //     'paint': {
                //         'text-color': 'rgba(255,255,255, 1)'
                //       }
                // });

         
                map.addLayer({
                    'id': 'high',
                    'type': 'symbol',
                    'source': 'high',
                    'layout': {
                        'icon-image':'custom-marker',
                        'text-field': ['get', 'name'],
                        'text-font': ['Open Sans Semibold', 'Arial Unicode MS Bold'],
                        'text-size': 12,
                        'text-offset': [0, 3]
                    },
                    'paint': {
                        'text-color': 'rgba(255,255,255, 1)'
                      }
                });
                if (map.getLayer('poi_sample1')) {
                    map.removeLayer('poi_sample1');
                    map.removeLayer('poi_sample2');
                    map.removeLayer('poi_sample3');
                    map.removeLayer('poi_sample4');
                    map.removeLayer('poi_sample5');
                    map.removeLayer('poi_sample6');
                    map.removeSource('poi_sample')
                    map.removeSource('poi_sample_p')
                    map.removeSource('poi_sample_l')
                }

                map.addSource('poi_sample', {
                    type: 'geojson',
                    data: './poi2.geojson',
                });
                map.addSource('poi_sample_p', {
                    type: 'geojson',
                    data: './poi2_p.geojson',
                });
                map.addSource('poi_sample_l', {
                    type: 'geojson',
                    data: './poi2_l.geojson',
                });
                map.addLayer({
                    'id': 'poi_sample1',
                    'type': 'circle',
                    'source': 'poi_sample',     
                    'paint': {
                      "circle-color": "#fff",
                      "circle-radius": 5,
                      "circle-opacity":0.8,
                    }
                });
            
                map.addLayer({
                    'id': 'poi_sample2',
                    'type': 'symbol',
                    'source': 'poi_sample',
                    'layout': {
                        'text-field': ['get', 'name'],
                        'text-size': 10,
                        'text-offset': [0, 1.5]
                    },
                    'paint': {
                        'text-color': 'rgba(255,255,255, 1)'
                      }
                });
                map.addLayer({
                    'id': 'poi_sample3',
                    'type': 'fill',
                    'source': 'poi_sample_p',
                    'paint': {
                        'fill-color': '#84C98B',
                        'fill-opacity': 0.8,
                      }
                });                                
                map.addLayer({
                    'id': 'poi_sample4',
                    'type': 'symbol',
                    'source': 'poi_sample_p',
                    'layout': {
                        'text-field': ['get', 'name'],
                        'text-size': 10,
                        'text-offset': [0, 1.5]
                    },
                    'paint': {
                        'text-color': 'rgba(255,255,255, 1)'
                      }
                });
                map.addLayer({
                    'id': 'poi_sample5',
                    'type': 'line',
                    'source': 'poi_sample_l',
                    'paint': {
                        'line-color': '#84C98B',
                        'line-opacity': 0.8,
                      }
                });                                
                map.addLayer({
                    'id': 'poi_sample6',
                    'type': 'symbol',
                    'source': 'poi_sample_l',
                    'layout': {
                        'text-field': ['get', 'name'],
                        'text-size': 10,
                        'text-offset': [0, 1.5]
                    },
                    'paint': {
                        'text-color': 'rgba(255,255,255, 1)'
                      }
                });
            });
            create_chart_df_b(data.df_b);
            create_chart_df_c(data.df_c);
            create_chart_df_d(data.df_d);
            create_chart_df_e(data.df_e);
            create_chart_df_f(data.df_f);
            if (data.df_g.length > 0) {
                create_chart_df_g(data.df_g);
                create_chart_df_h(data.df_h);
                create_chart_df_i(data.df_i);    
            }
            create_chart_df_j(data.cross);
            df_data = data;
            if (df_data.df_b.length == 0) {alert('該当する条件でデータがありません。抽出条件を変えて更新してください。');}

            $("#legend-show").click();  
            $("#chart-legend").dialog("close");
            map.zoomOut();
            $(window).scrollTop(0);
          },
          error: function(XMLHttpRequest, textStatus, errorThrown) {
              console.log("ERROR:\n" +  textStatus + ":\n" + errorThrown);
          }
        }).done(function() {
            setTimeout(function(){
              $("#overlay").fadeOut(300);
            },500);
        });


      })
});

// function getBoundingBox(data) {
//     var bounds = {}, coords, point, latitude, longitude;
  
//     for (var i = 0; i < data.features.length; i++) {
//       coords = data.features[i].geometry.coordinates;
  
//       longitude = coords[0];
//       latitude = coords[1];
//       bounds.xMin = bounds.xMin < longitude ? bounds.xMin : longitude;
//       bounds.xMax = bounds.xMax > longitude ? bounds.xMax : longitude;
//       bounds.yMin = bounds.yMin < latitude ? bounds.yMin : latitude;
//       bounds.yMax = bounds.yMax > latitude ? bounds.yMax : latitude;
//     }
  
//     return bounds;
// }

function addArcLayer() {
    $.getJSON('./outfile2.geojson', function(response){
        if (map.getLayer('arch')) {
            map.removeLayer('arch');
        }
        const myArcLayer = new deck.MapboxLayer({
            id: 'arch',
            type: deck.GeoJsonLayer,
            data: response,
            stroked: true,
            filled: false,
            getLineColor: d => {
                value = d.properties.cnt
                if(value_list_2[0] <= value && value < value_list_2[1]) 
                    return grad_style2[0] 
                else if(value_list_2[1] <= value && value < value_list_2[2]) 
                    return grad_style2[1]
                else if(value_list_2[2] <= value && value < value_list_2[3]) 
                    return grad_style2[2] 
                else if(value_list_2[3] <= value && value < value_list_2[4] ) 
                    return grad_style2[3]
                else if(value_list_2[4] <= value && value < value_list_2[5] ) 
                    return grad_style2[4]
                else 
                    return grad_style2[0]
            },
            //getFillColor: [255, 0, 0, 180],
            lineJointRounded : true,
            lineWidthMinPixels: 8,    
        });
        map.addLayer(myArcLayer);
    });
}

function getBoundingBox(data) {
    var bounds = {}, coords, point, latitude, longitude;
  
    for (var i = 0; i < data.features.length; i++) {
      coords = data.features[i].geometry.coordinates;
  
      for (var j = 0; j < coords.length; j++) {
        longitude = coords[j][0];
        latitude = coords[j][1];
        bounds.xMin = bounds.xMin < longitude ? bounds.xMin : longitude;
        bounds.xMax = bounds.xMax > longitude ? bounds.xMax : longitude;
        bounds.yMin = bounds.yMin < latitude ? bounds.yMin : latitude;
        bounds.yMax = bounds.yMax > latitude ? bounds.yMax : latitude;
      }
    }
  
    return bounds;
}

function create_chart_df_b(data) {
    var w = 1150;
    var h = 200;
    var svg = d3.select("#chart-df-b").append("svg").attr("width", w).attr("height", h);
    var g = svg.append("g");

    // データセットの日付フォーマット変換
    var timeparser = d3.timeParse("%Y-%m-%d");
    data = data.map( function(d){    // 標準日付に変換して、新しい配列作成 
            return  { yyyymmdd: timeparser(d.yyyymmdd), cnt:d.cnt } ;
    } );

    console.log(data)
    // 時系列のスケール（scaleTime）利用
    var xScale = d3.scaleBand()
	    .domain(data.map(d => d.yyyymmdd)).range([0, w])
	    .padding(0.3)
    //scale yAxis
    var yMin=d3.min(data,d=>d.cnt)
    var yMax=d3.max(data,d=>d.cnt) * 1.1
    yScale = d3.scaleLinear().domain([0, yMax]).range([h, 0]) 

    // 時系列の軸が時系列のスケールを呼び出し
    var x_axis = d3.axisBottom(xScale).tickFormat(d3.timeFormat("%Y/%m/%e")) // 例：1/1、1/2 のフォーマット
    var y_axis = d3.axisLeft(yScale).ticks(5).tickSize(-w);
 
    svg.append("g")
    .attr("class", "x axis")
    .attr("transform", "translate(0," + h + ")")
    .call(x_axis);
  
    svg.append("g")
    .call(y_axis);

    svg.selectAll(".x text")
      .attr("transform", function(d) {
              return "translate(" + this.getBBox().height/2*-3 + "," + this.getBBox().height + ")rotate(-45)";
      })
      .attr("font-size", "8px");

    svg.append("g")
    .selectAll("rect")
    .data(data)
    .enter()
    .append("rect")
    .attr("x", function(d) { return xScale(d.yyyymmdd); })
    .attr("y", function(d) { return yScale(d.cnt); })
    .attr("width", xScale.bandwidth())
    .attr("height", function(d) { return h - yScale(d.cnt); })
    .attr("fill", "#7f7fff");

    //append label 
    // d3.select("#chart-df-b").select("svg")
    //     .selectAll(".t")
    //     .append("g")
    //     .data(data)
    //     .enter()
    //     .append("text")
    //     .style("font", "8px times")
    //     .attr("x", d => xScale(d.yyyymmdd))
    //     .attr("y", d => yScale(d.cnt)-10)
    //     .text(function(d){ return Math.round(d.cnt * 10) / 10; });

} 

function create_chart_df_c(data) {
    var w = 1150;
    var h = 200;
    var svg = d3.select("#chart-df-c").append("svg").attr("width", w).attr("height", h);
    var g = svg.append("g");

    //set canvas margins
    leftMargin=70
    topMargin=30

    //scale xAxis 
    var xMin=d3.min(data,d=>d.hour)
    var xMax=d3.max(data,d=>d.hour)
    xScale = d3.scaleLinear().domain([xMin, xMax]).range([0, w])

    //scale yAxis
    var yMin=d3.min(data,d=>d.cnt)
    var yMax=d3.max(data,d=>d.cnt) * 1.1
    yScale = d3.scaleLinear().domain([0, yMax]).range([h, 0]) 

    var x_axis = d3.axisBottom(xScale);
    var y_axis = d3.axisLeft(yScale).ticks(5).tickSize(-w);
    svg.append("g")
      .attr("transform", "translate(0," + h + ")")
      .call(x_axis);
  
    svg.append("g")
      .call(y_axis);

    var line = d3.line()
      .x(function(d,i) { return xScale(d.hour); })
      .y(function(d,i) { return yScale(d.cnt); });

    g.append("path")
      .datum(data)
      .attr("d", line)
      .attr("stroke", d3.color("#7f7fff"))
      .attr("fill", "none")
      .attr("stroke-width", "3px");

    //append label 
    // d3.select("#chart-df-c").select("svg")
    //     .selectAll(".t")
    //     .append("g")
    //     .data(data)
    //     .enter()
    //     .append("text")
    //     .style("font", "11px times")
    //     .attr("x", d => xScale(d.hour)+10)
    //     .attr("y", d => yScale(d.cnt))
    //     .text(function(d){ return Math.round(d.cnt * 10) / 10; });

    //append circle 
    d3.select("#chart-df-c").select("svg")
        .selectAll("circle")
        .append("g")
        .data(data)
        .enter()
        .append("circle")
        .attr("r", 3)
        .attr("cx", d => xScale(d.hour))
        .attr("cy", d => yScale(d.cnt))
        .style("fill", d3.color("#7f7fff"))   

}

function create_chart_df_d(data) {
    var w = 900;
    var h = 200;
    var svg = d3.select("#chart-df-d").append("svg").attr("width", w).attr("height", h);
    var g = svg.append("g");

    var stack = d3.stack()
      .keys([ "休日", "平日"]);   //キーを登録


    // データセットの日付フォーマット変換
    var timeparser = d3.timeParse("%Y-%m-%d");
    data = data.map( function(d){    // 標準日付に変換して、新しい配列作成 
            return  { yyyymmdd: timeparser(d.yyyymmdd), "平日":d["平日"],"休日":d["休日"]  } ;
    } );

    var series = stack(data);

    color = d3.scaleOrdinal()
    .domain(series.map(d => d.key))
    .range(['#ff7f7f','#aaa'])

    console.log(data)
    // 時系列のスケール（scaleTime）利用
    var xScale = d3.scaleBand()
	    .domain(data.map(d => d.yyyymmdd)).range([0, w - 100])
	    .padding(0.3)
    //scale yAxis

    var yScale = d3.scaleLinear()
    .domain([0,
        d3.max(data, function(d) {
            return d["平日"] + d["休日"] ;
        }) * 1.1
    ])
    .range([h, 0]);

    var x_axis = d3.axisBottom(xScale).tickFormat(d3.timeFormat("%Y-%m/%e")) ;
    var y_axis = d3.axisLeft(yScale).ticks(5).tickSize(-w);

    svg.append("g")
    .attr("class", "x axis")
    .attr("transform", "translate(0," + h + ")")
    .call(x_axis);
  
    svg.append("g")
    .call(y_axis);

    svg.selectAll(".x text")
      .attr("transform", function(d) {
              return "translate(" + this.getBBox().height/2*-3 + "," + this.getBBox().height + ")rotate(-45)";
      })
      .attr("font-size", "8px");


    svg.append("g")
    .selectAll("g")
    .data(series)
    .join("g")
      .attr("fill", d => color(d.key))
    .selectAll("rect")
    .data(d => d)
    .join("rect")
      .attr("x", (d, i) => xScale(d.data.yyyymmdd))
      .attr("y", d => yScale(d[1]))
      .attr("height", d => yScale(d[0]) - yScale(d[1]))
      .attr("width", xScale.bandwidth())

    //append label 
    // d3.select("#chart-df-d").select("svg")
    // .selectAll(".t")
    // .append("g")
    // .data(data)
    // .enter()
    // .append("text")
    // .style("font", "11px times")
    // .attr("x", d => xScale(d.yyyymmdd))
    // .attr("y", d => yScale(d[1])-10)
    // .text(function(d){ return Math.round( (d["平日"] + d["休日"]) * 10) / 10; });

    //append legends
    var legend = d3.select("#chart-df-d").select("svg")
        .selectAll('g.legend')
        .data(series)
        .enter()
        .append("g")
        .attr("class", "legend");

    legend.append("circle")
        .attr("cx", 850)
        .attr('cy', (d, i) => i * 30 + 20)
        .attr("r", 6)
        .style("fill", d => color(d.key))

    legend.append("text")
        .style("font", "11px times")
        .attr("x", 860)
        .attr("y", (d, i) => i * 30 + 20)
        .text(d => d.key)

}

function create_chart_df_e(data) {
    var w = 150;
    var h = 200;
    var svg = d3.select("#chart-df-e").append("svg").attr("width", w).attr("height", h);
    var g = svg.append("g");

    console.log(data)
    
    color = d3.scaleOrdinal()
    .domain([ "休日", "平日"])
    .range(['#ff7f7f','#aaa'])

    var xScale = d3.scaleBand()
        .domain(data.map(function(d) { return d.holiday; }))
        .range([0, w]) // 描画幅
        .padding(0.3); // グラフの間隔
    //scale yAxis
    var yMin=d3.min(data,d=>d.cnt)
    var yMax=d3.max(data,d=>d.cnt)  * 1.1
    yScale = d3.scaleLinear().domain([0, yMax]).range([h, 0]) 

    // 時系列の軸が時系列のスケールを呼び出し
    var x_axis = d3.axisBottom(xScale)
    var y_axis = d3.axisLeft(yScale).ticks(5).tickSize(-w);
    svg.append("g")
    .attr("transform", "translate(0," + h + ")")
    .call(x_axis);
  
    svg.append("g")
    .call(y_axis);

    svg.append("g")
    .selectAll("rect")
    .data(data)
    .enter()
    .append("rect")
    .attr("x", function(d) { return xScale(d.holiday); })
    .attr("y", function(d) { return yScale(d.cnt); })
    .attr("width", xScale.bandwidth())
    .attr("height", function(d) { return h - yScale(d.cnt); })
    .attr("fill", d => color(d.holiday))


    //append label 
    // d3.select("#chart-df-e").select("svg")
    //     .selectAll(".t")
    //     .append("g")
    //     .data(data)
    //     .enter()
    //     .append("text")
    //     .style("font", "11px times")
    //     .attr("x", d => xScale(d.holiday))
    //     .attr("y", d => yScale(d.cnt)-10)
    //     .text(function(d){ return Math.round( (d.cnt* 10) / 10) });
}

function create_chart_df_f(data) {
    var w = 1050;
    var h = 200;
    var svg = d3.select("#chart-df-f").append("svg").attr("width", w).attr("height", h);
    var g = svg.append("g");

    //set canvas margins
    leftMargin=70
    topMargin=30

    //scale xAxis 
    var xMin=d3.min(data,d=>d.hour)
    var xMax=d3.max(data,d=>d.hour)
    xScale = d3.scaleLinear().domain([xMin, xMax]).range([0, w])

    //scale yAxis
    var yMin=d3.min(data,d=>d.cnt)
    var yMax=d3.max(data,d=>d.cnt) * 1.1
    yScale = d3.scaleLinear().domain([0, yMax]).range([h, 0]) 

    var x_axis = d3.axisBottom(xScale);
    var y_axis = d3.axisLeft(yScale).ticks(5).tickSize(-w);
    svg.append("g")
    .attr("transform", "translate(0," + h + ")")
    .call(x_axis);
  
    svg.append("g")
    .call(y_axis);

    //use .nest()function to group data so the line can be computed for each group
    var sumstat = d3.nest() 
        .key(d => d.holiday)
        .entries(data);

    console.log(sumstat)

    //set color pallete for different vairables
    var attrName = sumstat.map(d => d.key) 
    var color = d3.scaleOrdinal().domain(attrName).range(['#ff7f7f','#aaa'])

    //select path - three types: curveBasis,curveStep, curveCardinal
    d3.select("#chart-df-f").select("svg")
        .selectAll(".line")
        .append("g")
        .attr("class", "line")
        .data(sumstat)
        .enter()
        .append("path")
        .attr("d", function (d) {
            return d3.line()
                .x(d => xScale(d.hour))
                .y(d => yScale(d.cnt))
                (d.values)
        })
        .attr("fill", "none")
        .attr("stroke", d => color(d.key))
        .attr("stroke-width", 2)

    //append label 
    // d3.select("#chart-df-f").select("svg")
    //     .selectAll(".t")
    //     .append("g")
    //     .data(data)
    //     .enter()
    //     .append("text")
    //     .style("font", "11px times")
    //     .attr("x", d => xScale(d.hour)+10)
    //     .attr("y", d => yScale(d.cnt))
    //     .text(function(d){ return Math.round(d.cnt * 10) / 10; });

    //append circle 
    d3.select("#chart-df-f").select("svg")
        .selectAll("circle")
        .append("g")
        .data(data)
        .enter()
        .append("circle")
        .attr("r", 3)
        .attr("cx", d => xScale(d.hour))
        .attr("cy", d => yScale(d.cnt))
        .style("fill", d => color(d.holiday))
    
    //append legends
    var legend = d3.select("#chart-df-f").select("svg")
        .selectAll('g.legend')
        .data(sumstat)
        .enter()
        .append("g")
        .attr("class", "legend");

    legend.append("circle")
        .attr("cx", 1100)
        .attr('cy', (d, i) => i * 30 + 20)
        .attr("r", 6)
        .style("fill", d => color(d.key))

    legend.append("text")
        .style("font", "11px times")
        .attr("x", 1110)
        .attr("y", (d, i) => i * 30 + 20)
        .text(d => d.key)
}

function create_chart_df_g(data) {
    var w = 525;
    var h = 200;
    var svg = d3.select("#chart-df-g").append("svg").attr("width", w).attr("height", h);
    var g = svg.append("g");



    var result = []
    var val = data[0];
    for(var j in val){
        if (j !== 'yyyymmdd' && j !== 'All') { result.push(j) }
    }

    var stack = d3.stack()
        .keys(result);   //キーを登録
  
    // データセットの日付フォーマット変換
    var timeparser = d3.timeParse("%Y-%m-%d");

    var series = stack(data);

    color = d3.scaleOrdinal()
    .domain(series.map(d => d.key))
    .range(["#7fbfff","#7fffbf","#ffff7f","#ff7f7f"])

    console.log(data)

    // 時系列のスケール（scaleTime）利用
    var xScale = d3.scaleBand()
	    .domain(data.map(d => timeparser(d.yyyymmdd))).range([0, w])
	    .padding(0.3)
    //scale yAxis

    var yScale = d3.scaleLinear()
    .domain([0,
        d3.max(data, function(d) {
            return d.All ;
        }) * 1.1
    ])
    .range([h, 0]);


    var x_axis = d3.axisBottom(xScale).tickFormat(d3.timeFormat("%Y-%m/%e")) ;
    var y_axis = d3.axisLeft(yScale).ticks(5).tickSize(-w);

    svg.append("g")
    .attr("class", "x axis")
    .attr("transform", "translate(0," + h + ")")
    .call(x_axis);
  
    svg.append("g")
    .call(y_axis);

    svg.selectAll(".x text")
      .attr("transform", function(d) {
              return "translate(" + this.getBBox().height/2*-3 + "," + this.getBBox().height + ")rotate(-45)";
      })
      .attr("font-size", "8px");


    svg.append("g")
    .selectAll("g")
    .data(series)
    .join("g")
      .attr("fill", d => color(d.key))
    .selectAll("rect")
    .data(d => d)
    .join("rect")
      .attr("x", (d, i) => xScale(timeparser(d.data.yyyymmdd)))
      .attr("y", d => yScale(d[1]))
      .attr("height", d => yScale(d[0]) - yScale(d[1]))
      .attr("width", xScale.bandwidth())  

    //append label 
    // d3.select("#chart-df-g").select("svg")
    //     .selectAll(".t")
    //     .append("g")
    //     .data(data)
    //     .enter()
    //     .append("text")
    //     .style("font", "11px times")
    //     .attr("x", d => xScale(d.yyyymmdd))
    //     .attr("y", d => yScale(10))
    //     .text(function(d){ return Math.round( (d.all* 10) / 10) });

    //append legends
    var legend = d3.select("#chart-legend").append("svg").attr("width", 100)
        .selectAll('g.legend')
        .data(series)
        .enter()
        .append("g")
        .attr("class", "legend");

    legend.append("circle")
        .attr("cx", 0)
        .attr('cy', (d, i) => i * 30 + 20)
        .attr("r", 6)
        .style("fill", d => color(d.key))

    legend.append("text")
        .style("font", "11px times")
        .attr("x", 10)
        .attr("y", (d, i) => i * 30 + 20)
        .text(d => d.key)
    
    $("#chart-legend").dialog({width: 150,height:series.length*50+50});
}

function create_chart_df_h(data) {
    //var w = 150;
    var w = data.length * 80;
    var h = 200;
    var svg = d3.select("#chart-df-h").append("svg").attr("width", w).attr("height", h);
    var g = svg.append("g");

    console.log(data)

    color = d3.scaleOrdinal()
    .domain(data.map(d => d.attr1))
    .range(["#7fbfff","#7fffbf","#ffff7f","#ff7f7f","#ff7fbf","#ff7fff","#bf7fff","#7f7fff"])


    var xScale = d3.scaleBand()
        .domain(data.map(function(d) { return d.attr1; }))
        .range([0, w]) // 描画幅
        .padding(0.3); // グラフの間隔
    //scale yAxis
    var yMin=d3.min(data,d=>d.cnt)
    var yMax=d3.max(data,d=>d.cnt) * 1.1
    yScale = d3.scaleLinear().domain([0, yMax]).range([h, 0]) 

    // 時系列の軸が時系列のスケールを呼び出し
    var x_axis = d3.axisBottom(xScale)
    var y_axis = d3.axisLeft(yScale).ticks(5).tickSize(-w);
    svg.append("g")
    .attr("class", "x axis")
    .attr("transform", "translate(0," + h + ")")
    .call(x_axis);
  
    svg.append("g")
    .call(y_axis);



    svg.append("g")
    .selectAll("rect")
    .data(data)
    .enter()
    .append("rect")
    .attr("x", function(d) { return xScale(d.attr1); })
    .attr("y", function(d) { return yScale(d.cnt); })
    .attr("width", xScale.bandwidth())
    .attr("height", function(d) { return h - yScale(d.cnt); })
    .attr("fill", d => color(d.attr1));
    
    //append label 
    // d3.select("#chart-df-h").select("svg")
    //     .selectAll(".t")
    //     .append("g")
    //     .data(data)
    //     .enter()
    //     .append("text")
    //     .style("font", "11px times")
    //     .attr("x", d => xScale(d.attr1))
    //     .attr("y", d => yScale(d.cnt)-10)
    //     .text(function(d){ return Math.round( (d.cnt* 10) / 10) });
}

function create_chart_df_i(data) {
    var w = 1150;
    var h = 200;
    var svg = d3.select("#chart-df-i").append("svg").attr("width", w).attr("height", h);
    var g = svg.append("g");

    //set canvas margins
    leftMargin=70
    topMargin=30

    //scale xAxis 
    var xMin=d3.min(data,d=>d.hour)
    var xMax=d3.max(data,d=>d.hour)
    xScale = d3.scaleLinear().domain([xMin, xMax]).range([0, w])

    //scale yAxis
    var yMin=d3.min(data,d=>d.cnt)
    var yMax=d3.max(data,d=>d.cnt) * 1.1
    yScale = d3.scaleLinear().domain([0, yMax]).range([h, 0]) 

    var x_axis = d3.axisBottom(xScale);
    var y_axis = d3.axisLeft(yScale).ticks(5).tickSize(-w);
    svg.append("g")
    .attr("transform", "translate(0," + h + ")")
    .call(x_axis);
  
    svg.append("g")
    .call(y_axis);

    //use .nest()function to group data so the line can be computed for each group
    var sumstat = d3.nest() 
        .key(d => d.attr1)
        .entries(data);

    console.log(sumstat)

    //set color pallete for different vairables
    var attrName = sumstat.map(d => d.key) 
    var color = d3.scaleOrdinal().domain(attrName).range(["#7fbfff","#7fffbf","#ffff7f","#ff7f7f"])

    //select path - three types: curveBasis,curveStep, curveCardinal
    d3.select("#chart-df-i").select("svg")
        .selectAll(".line")
        .append("g")
        .attr("class", "line")
        .data(sumstat)
        .enter()
        .append("path")
        .attr("d", function (d) {
            return d3.line()
                .x(d => xScale(d.hour))
                .y(d => yScale(d.cnt))
                (d.values)
        })
        .attr("fill", "none")
        .attr("stroke", d => color(d.key))
        .attr("stroke-width", 2)

    //append label 
    // d3.select("#chart-df-i").select("svg")
    //     .selectAll(".t")
    //     .append("g")
    //     .data(data)
    //     .enter()
    //     .append("text")
    //     .style("font", "11px times")
    //     .attr("x", d => xScale(d.hour)+10)
    //     .attr("y", d => yScale(d.cnt))
    //     .text(function(d){ return Math.round(d.cnt * 10) / 10; });

    //append circle 
    d3.select("#chart-df-i").select("svg")
        .selectAll("circle")
        .append("g")
        .data(data)
        .enter()
        .append("circle")
        .attr("r", 3)
        .attr("cx", d => xScale(d.hour))
        .attr("cy", d => yScale(d.cnt))
        .style("fill", d => color(d.attr1))
    
    //append legends
    // var legend = d3.select("#chart-df-i").select("svg")
    //     .selectAll('g.legend')
    //     .data(sumstat)
    //     .enter()
    //     .append("g")
    //     .attr("class", "legend");

    // legend.append("circle")
    //     .attr("cx", 1100)
    //     .attr('cy', (d, i) => i * 30 + 20)
    //     .attr("r", 6)
    //     .style("fill", d => color(d.key))

    // legend.append("text")
    //     .style("font", "11px times")
    //     .attr("x", 1110)
    //     .attr("y", (d, i) => i * 30 + 20)
    //     .text(d => d.key)

}

function create_chart_df_j(data) {
    var myh1 = document.getElementById("chart-df-j");
    myh1.innerHTML = data;
//   var names = d3.keys(data[0]);
 
//   var table = d3.select("#chart-df-j")
//     .append("table")
//     .attr("border", "1") // 枠線表示;
 
//   table.append("thead")
//     .append("tr")
//     .selectAll("th")
//     .data(names)
//     .enter()
//     .append("th")
//     .text(function(d) { return d; });
 
//   table.append("tbody")
//     .selectAll("tr")
//     .data(data)
//     .enter()
//     .append("tr")
//     .selectAll("td")
//     .data(function(row) { return d3.entries(row); })
//     .enter()
//     .append("td")
//     .text(function(d){ 
//         if (!isNaN(d.value)) 
//             return Math.round(d.value).toLocaleString();
//         else
//             return d.value;
//     });

}

//CSV出力

function jsonToCsv(items) {
    // headerを取得
    const header = Object.keys(items[0]);
    const headerString = header.join(',');
  
    const replacer = (key, value) => value ?? '';
    const rowItems = items.map((row) =>
      header.map((fieldName) => JSON.stringify(row[fieldName], replacer)).join(',')
    );
  
    // headerとコンテンツ部分を結合する
    const csv = [headerString, ...rowItems].join('\r\n');
  
    return csv;
}

function csvexport(kind,filename) {
    switch (kind) {
        case "map": data = df_data.df_a; break;
        case "a": data = df_data.df_selected; break;
        case "b": data = df_data.df_b; break;
        case "c": data = df_data.df_c; break;
        case "d": data = df_data.df_d; break;
        case "e": data = df_data.df_e; break;
        case "f": data = df_data.df_f; break;
        case "g": data = df_data.df_g; break;
        case "h": data = df_data.df_h; break;
        case "i": data = df_data.df_i; break;
        case "j": data = df_data.df_j; break;
        default : data = [];
    }
    
    if (data.length == 0 ) {
      alert("データが選択されていません");
      return 0;
    }
  
    csv_string = jsonToCsv(data)

    //ファイル名の指定
    let file_name   = filename + ".csv";
    let bom  = new Uint8Array([0xEF, 0xBB, 0xBF])
    //CSVのバイナリデータを作る
    let blob        = new Blob([bom,csv_string], {type: "text/csv"});
    let uri         = URL.createObjectURL(blob);

    //リンクタグを作る
    let link        = document.createElement("a");
    link.download   = file_name;
    link.href       = uri;

    //作ったリンクタグをクリックさせる
    document.body.appendChild(link);
    link.click();

    //クリックしたら即リンクタグを消す
    document.body.removeChild(link);

    delete link;
}
function createFilterText() {

    fText = "抽出条件<br>" ;

    if ($('#year').val().length == document.getElementById("year").length ) {
        fText += "年:すべて　" 
    } else if ($('#year').val().length > 5) {
        stemp = "年:" + $('#year').val().slice(0,4).join(',') + '...　';
        fText += stemp
    } else {
        stemp = "年:" + $('#year').val().join(',') + '　';
        fText += stemp
    }

    if ($('#month').val().length == document.getElementById("month").length ) {
        fText += "月:すべて　" 
    } else if ($('#month').val().length > 5) {
        stemp = "月:" + $('#month').val().slice(0,4).join(',') + '...　';
        fText += stemp
    } else {
        stemp = "月:" + $('#month').val().join(',') + '　';
        fText += stemp
    }

    if ($('#date').val().length == document.getElementById("date").length ) {
        fText += "日:すべて　" 
    } else if ($('#date').val().length > 5) {
        stemp = "日:" + $('#date').val().slice(0,4).join(',') + '...　';
        fText += stemp
    } else {
        stemp = "日:" + $('#date').val().join(',') + '　';
        fText += stemp
    }

    if ($('#time').val().length == document.getElementById("time").length ) {
        fText += "時間:すべて　" 
    } else if ($('#time').val().length > 5) {
        stemp = "時間:" + $('#time').val().slice(0,4).join(',') + '...　';
        fText += stemp
    } else {
        stemp = "時間:" + $('#time').val().join(',') + '　';
        fText += stemp
    }

    if ($('#holyday').val().length == document.getElementById("holyday").length ) {
        fText += "平休日:すべて　" 
    } else if ($('#holyday').val().length > 5) {
        stemp = "平休日:" + $('#holyday').val().slice(0,4).join(',') + '...　';
        fText += stemp
    } else {
        stemp = "平休日:" + $('#holyday').val().join(',') + '　';
        fText += stemp
    }

    if ($('#yobi').val().length == document.getElementById("yobi").length ) {
        fText += "曜日:すべて　" 
    } else if ($('#yobi').val().length > 5) {
        stemp = "曜日:" + $('#yobi').val().slice(0,4).join(',') + '...　';
        fText += stemp
    } else {
        stemp = "曜日:" + $('#yobi').val().join(',') + '　';
        fText += stemp
    }

    if ($('#area').val().length == document.getElementById("area").length ) {
        fText += "エリア:すべて　" 

    } else if ($('#area').val().length > 5) {
        stemp = "エリア:" + $('#area').val().slice(0,4).join(',') + '...　';
        fText += stemp
    } else {
        stemp = "エリア:" + $('#area').val().join(',') + '　';
        fText += stemp
    }


    if ($('#attr1').val()[0] !== 'すべて') {
        label = document.getElementById("attr1_label").textContent;
        if ($('#attr1').val().length == document.getElementById("attr1").length ) {
            fText += label + ":すべて　" 
        } else if ($('#attr1').val().length > 5) {
            stemp = label + ":" + $('#attr1').val().slice(0,4).join(',') + '...　';
            fText += stemp
        } else {
            stemp = label + ":" + $('#attr1').val().join(',') + '　';
            fText += stemp
        }
    }

    if ($('#attr2').val()[0] !== 'すべて') {
        label = document.getElementById("attr2_label").textContent;
        if ($('#attr2').val().length == document.getElementById("attr2").length ) {
            fText += label + ":すべて　" 
        } else if ($('#attr2').val().length > 5) {
            stemp = label + ":" + $('#attr2').val().slice(0,4).join(',') + '...　';
            fText += stemp
        } else {
            stemp = label + ":" + $('#attr2').val().join(',') + '　';
            fText += stemp
        }
    }

    if ($('#attr3').val()[0] !== 'すべて') {
        label = document.getElementById("attr3_label").textContent;
        if ($('#attr3').val().length == document.getElementById("attr3").length ) {
            fText += label + ":すべて　" 
        } else if ($('#attr3').val().length > 5) {
            stemp = label + ":" + $('#attr3').val().slice(0,4).join(',') + '...　';
            fText += stemp
        } else {
            stemp = label + ":" + $('#attr3').val().join(',') + '　';
            fText += stemp
        }
    }

    if ($('#attr4').val()[0] !== 'すべて') {
        label = document.getElementById("attr4_label").textContent;
        if ($('#attr4').val().length == document.getElementById("attr4").length ) {
            fText += label + ":すべて　" 
        } else if ($('#attr4').val().length > 5) {
            stemp = label + ":" + $('#attr4').val().slice(0,4).join(',') + '...　';
            fText += stemp
        } else {
            stemp = label + ":" + $('#attr4').val().join(',') + '　';
            fText += stemp
        }
    }

    if ($('#attr5').val()[0] !== 'すべて') {
        label = document.getElementById("attr5_label").textContent;
        if ($('#attr5').val().length == document.getElementById("attr5").length ) {
            fText += label + ":すべて　" 
        } else if ($('#attr5').val().length > 5) {
            stemp = label + ":" + $('#attr5').val().slice(0,4).join(',') + '...　';
            fText += stemp
        } else {
            stemp = label + ":" + $('#attr5').val().join(',') + '　';
            fText += stemp
        }
    }

    return fText;
}
function custom_alert( message, title ) {
    if ( !title )
        title = 'メッセージ';

    if ( !message )
        message = 'No Message to Display.';

    $('<div></div>').html( message ).dialog({
        title: title,
        resizable: false,
        modal: true,
        buttons: {
            'Ok': function()  {
                $( this ).dialog( 'close' );
            }
        }
    });
}
function allselect() {
    $('#year').multiselect('selectAll', false);
    $('#month').multiselect('selectAll', false);
    $("#date").multiselect('selectAll', false);
    $("#time").multiselect('selectAll', false);
    $("#holyday").multiselect('selectAll', false);
    $("#yobi").multiselect('selectAll', false);
    $("#area").multiselect('selectAll', false);
    $("#attr1").multiselect('selectAll', false);
    $("#attr2").multiselect('selectAll', false);
    $("#attr3").multiselect('selectAll', false);
    $("#attr4").multiselect('selectAll', false);
    $("#attr5").multiselect('selectAll', false);

    showhighlight();
}
function allreset() {
    $('#year').val([]);
    $('#month').val([]);
    $('#year').multiselect("refresh");
    $('#month').multiselect("refresh");

    $("#year").val($("#year").val().concat(initial_data.init_year)); 
    $('#year').multiselect("refresh");
    $("#month").val($("#month").val().concat(initial_data.init_month)); 
    $('#month').multiselect("refresh");

    $("#date").multiselect('selectAll', false);
    $("#time").multiselect('selectAll', false);
    $("#holyday").multiselect('selectAll', false);
    $("#yobi").multiselect('selectAll', false);
    $("#area").multiselect('selectAll', false);
    $("#attr1").multiselect('selectAll', false);
    $("#attr2").multiselect('selectAll', false);
    $("#attr3").multiselect('selectAll', false);
    $("#attr4").multiselect('selectAll', false);
    $("#attr5").multiselect('selectAll', false);

    showhighlight();
}


// ハイライト管理
function showhighlight() {

    val = []
    val_list = $('#area').val();
    for (i = 0; i < df_data.area_id_list.length; i++) {
        if (val_list.includes(df_data.area_id_list[i][1])) {
            val.push(df_data.area_id_list[i][0])
        } 
    }

    if (val.length == 0) {
        map.setLayoutProperty('high', 'icon-image','custom-marker')
    } else {
        map.setLayoutProperty('high', 'icon-image',
            [
            'match',
            ['id'], // get the feature id (make sure your data has an id set or use generateIds for GeoJSON sources
            val, 'custom-marker-select', //image when id is the clicked feature id
            'custom-marker' // default
            ]
        )
    }

}